<?php
/**********************************************************************
	Copyright (C) Evolve Techniologies
	Author : Chathuri Gunawardana
	Email : chathuri@evolve-sl.com
	Company : Evolve Technologies(pvt)Ltd
***********************************************************************/

function add_batches($batch_name, $course_full_name, $course_short_name, $batch_year, $batch_month, $batch_entrM, $tuitionFee, $uweFee, $totalFee)
{
	$sql = "INSERT INTO ".TB_PREF."batches (batch_name, course_full_name, course_id, course_short_name, batch_year, batch_month, batch_entrM, tuitionFee, uweFee, totalFee)VALUES (
		".db_escape($batch_name).",
		".db_escape(get_course_name($course_full_name) ).",
		".db_escape(get_course_id(get_course_name($course_full_name)) ).",
		".db_escape($course_short_name).",
		".db_escape($batch_year).",
		".db_escape($batch_month).",
		".db_escape($batch_entrM).",
		".db_escape($tuitionFee).",
		".db_escape($uweFee).",
		".db_escape($totalFee)." )";
		
	db_query($sql, "could not add batch");
	
	
	$batch_id = db_insert_id();
	
	$sql2_catagories = "INSERT INTO ".TB_PREF."stock_category(description, dflt_mb_flag, dflt_sales_act, dflt_cogs_act, dflt_inventory_act, dflt_adjustment_act, dflt_assembly_act, dflt_dim1, dflt_dim2, main_category_id, batch_id, isAdminCat )VALUES (
		".db_escape($batch_name).",
		'D','4010','5010','1200','1202','1205',0,0,
		".db_escape(get_id2(get_course_name($course_full_name)) ).",
		".db_escape($batch_id).",
		1 )";
		
	db_query($sql2_catagories, "could not add batches as item catagories");
}

function update_batches($id, $batch_name, $course_full_name, $course_short_name, $batch_year, $batch_month, $batch_entrM, $tuitionFee, $uweFee, $totalFee)
{
	$sql = "UPDATE ".TB_PREF."batches SET 
	batch_name = ".db_escape($batch_name).",
	course_full_name = ".db_escape(get_course_name($course_full_name) ).", 
	course_id = ".db_escape(get_course_id(get_course_name($course_full_name))).", 
	course_short_name = ".db_escape($course_short_name).",
	batch_year = ".db_escape($batch_year).",
	batch_month = ".db_escape($batch_month).",
	batch_entrM = ".db_escape($batch_entrM).",
	tuitionFee = ".db_escape($tuitionFee).",
	uweFee = ".db_escape($uweFee).",
	totalFee = ".db_escape($totalFee)."
	WHERE id = ".db_escape($id);
	
	db_query($sql, "could not update batch");
	

	$sql2 = "SELECT id FROM ".TB_PREF."batches 
	WHERE batch_name = ".db_escape($batch_name);
	
	$result = db_query($sql2, "could not select batch");
	$row = db_fetch_row($result);
	//print_r($row[0]);

	$updated_batch_id = $row[0];
	
	$sql2_catagories = "UPDATE ".TB_PREF."stock_category SET
	description = ".db_escape($batch_name)."
	WHERE batch_id = ".db_escape($updated_batch_id);		
	
	db_query($sql2_catagories, "could not update batch in item catagories");
	
				
}

function delete_batches($selected_id)
{	
	/*$sql2="DELETE FROM ".TB_PREF."prices WHERE isAdminCat=1 AND category_id =".db_escape(get_stockCat_cat_id($selected_id));
	//print_r($sql2);
	db_query($sql2,"The Batch records in Prices Table could not be deleted");
	
	$sql2="DELETE FROM ".TB_PREF."loc_stock WHERE loc_code='LOC' AND isAdminCat=1 AND category_id =".db_escape(get_stockCat_cat_id($selected_id));
	//print_r($sql2);
	db_query($sql2,"The Batch records in Loc Stock Table could not be deleted");
	
	$sql2="DELETE FROM ".TB_PREF."stock_master WHERE category_id=".db_escape(get_stockCat_cat_id($selected_id));
	db_query($sql2,"The Batch records in Stock Master Table could not be deleted");
	
	$sql2="DELETE FROM ".TB_PREF."item_codes WHERE category_id=".db_escape(get_stockCat_cat_id($selected_id));
	db_query($sql2,"The Batch records in Item Codes Table could not be deleted");
	
	$sql2="DELETE FROM ".TB_PREF."stock_category WHERE batch_id=".db_escape($selected_id);
	db_query($sql2,"The Batch record in Stock Catagory Table could not be deleted");

	$sql="DELETE FROM ".TB_PREF."batches WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete batch");*/
	
	/*************Set to inactive on delete**************/
	$sql="UPDATE ".TB_PREF."batches SET inactive=1 WHERE id=".db_escape($selected_id);
	db_query($sql,"could not set inactive in batch table");
	
	$sql="UPDATE ".TB_PREF."stock_master SET inactive=1 WHERE category_id=".db_escape(get_stockCat_cat_id($selected_id));
	db_query($sql,"could not set inactive in batch table");
	
	$sql="UPDATE ".TB_PREF."stock_category SET inactive=1 WHERE category_id=".db_escape(get_stockCat_cat_id($selected_id))." AND isAdminCat=1";
	db_query($sql,"could not set inactive in stock_category table");
	
	$sql="UPDATE ".TB_PREF."item_codes SET inactive=1 WHERE category_id=".db_escape(get_stockCat_cat_id($selected_id))." AND isAdminCat=1";
	db_query($sql,"could not set inactive in item_codes table");
	/*************Set to inactive on delete**************/
}

function get_batches($id)
{
	$sql = "SELECT * FROM ".TB_PREF."batches WHERE id=".db_escape($id);
	
	$result = db_query($sql, "could not get batches");
	
	return db_fetch($result);
}

function get_all_batches($all=false)
{
	$sql = "SELECT * FROM ".TB_PREF."batches";
	if (!$all)
		$sql .= " WHERE !inactive";
	
	return db_query($sql, "could not get all batches");
}

function get_batches_name($group_no)
{
	$sql = "SELECT batch_name FROM ".TB_PREF."batches WHERE id = ".db_escape($group_no);
	$result = db_query($sql, "could not get batch name");
	$row = db_fetch($result);
	return $row[0];
}

function get_stockCat_cat_id($selectdId)
{
	$sql = "SELECT category_id FROM ".TB_PREF."stock_category WHERE batch_id=".db_escape($selectdId);
	
	$result = db_query($sql,"stock id could not be retreived");
	
	$row =  db_fetch($result);
	return $row[0];
}

function get_itemCat_details($cname)
{
	$sql = "SELECT category_id,dflt_tax_type,dflt_units,dflt_mb_flag,dflt_sales_act,dflt_inventory_act,dflt_cogs_act,dflt_adjustment_act,dflt_assembly_act,dflt_dim1,dflt_dim2 FROM ".TB_PREF."stock_category WHERE description=".db_escape($cname);
	
	$result = db_query($sql, "could not get id");
	
	$row = db_fetch_row($result);
	return $row;
}

function get_id2($cname)
{
	$sql = "SELECT main_category_id FROM ".TB_PREF."main_category WHERE main_cat_name=".db_escape($cname);
	
	$result = db_query($sql, "could not get id");
	
	$row = db_fetch_row($result);
	return $row[0];
}


?>