<?php
/**********************************************************************
	Copyright (C) Evolve Techniologies
	Author : Danushka Widanage
	Email : dwidanage@gmail.com
	Company : Evolve Technologies(pvt)Ltd
***********************************************************************/
$page_security = 'SA_GLANALYTIC';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	evolve, Chaitanya for the recursive version 2009-02-05.
// date_:	2005-05-19
// Title:	Profit and Loss Statement
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/admin/db/tags_db.inc");

//----------------------------------------------------------------------------------------------------

function display_type ($type, $typename, $from, $to, $begin, $end, $compare, $convert, &$dec, &$pdec, &$rep, $dimension, $dimension2, 
	$tags, &$pg, $graphics){
		
	$code_per_balance = 0;
	$code_acc_balance = 0;
	$per_balance_total = 0;
	$acc_balance_total = 0;
	$totals_arr = array();

	$printtitle = 0; //Flag for printing type name	
	
	//Get Accounts directly under this group/type
	$result = get_gl_accounts(null, null, $type);	
	while ($account=db_fetch($result)){
		if ($tags != -1 && is_array($tags) && $tags[0] != false){
			if (!is_record_in_tags($tags, TAG_ACCOUNT, $account['account_code']))
				continue;
		}	
		$per_balance = get_gl_trans_from_to($from, $to, $account["account_code"], $dimension, $dimension2);

		if ($compare == 2)
			$acc_balance = get_budget_trans_from_to($begin, $end, $account["account_code"], $dimension, $dimension2);
		else
			$acc_balance = get_gl_trans_from_to($begin, $end, $account["account_code"], $dimension, $dimension2);
		if (!$per_balance && !$acc_balance)
			continue;
		
		//Print Type Title if it has atleast one non-zero account	
		/*if (!$printtitle){
			$printtitle = 1;
			$rep->row -= 4;
			$rep->TextCol(0, 5, $typename);
			$rep->row -= 4;
			$rep->Line($rep->row);
			$rep->NewLine();		
		}*/			

		/*$rep->TextCol(0, 1,	$account['account_code']);
		$rep->TextCol(1, 2,	$account['account_name']);

		$rep->AmountCol(2, 3, $per_balance * $convert, $dec);
		$rep->AmountCol(3, 4, $acc_balance * $convert, $dec);
		$rep->AmountCol(4, 5, Achieve($per_balance, $acc_balance), $pdec);*/

		//$rep->NewLine();

		if ($rep->row < $rep->bottomMargin + 3 * $rep->lineHeight){
			$rep->Line($rep->row - 2);
			$rep->NewPage();
		}

		$code_per_balance += $per_balance;
		$code_acc_balance += $acc_balance;
	}
		
	//Get Account groups/types under this group/type
	$result = get_account_types(false, false, $type);
	while ($accounttype=db_fetch($result)){
		//Print Type Title if has sub types and not previously printed
		if (!$printtitle){
			$printtitle = 1;
			$rep->row -= 4;
			$rep->TextCol(0, 5, $typename);
			$rep->row -= 4;
			$rep->Line($rep->row);
			$rep->NewLine();		
		}

		$totals_arr = display_type($accounttype["id"], $accounttype["name"], $from, $to, $begin, $end, $compare, $convert, $dec, 
			$pdec, $rep, $dimension, $dimension2, $tags, $pg, $graphics);
		$per_balance_total += $totals_arr[0];
		$acc_balance_total += $totals_arr[1];
	}

	//Display Type Summary if total is != 0 OR head is printed (Needed in case of unused hierarchical COA) 
	if (($code_per_balance + $per_balance_total + $code_acc_balance + $acc_balance_total) != 0 || $printtitle)
	{
		/*$rep->row += 6;
		$rep->Line($rep->row);
		$rep->NewLine();
		$rep->TextCol(0, 2,	$typename);
		$rep->AmountCol(2, 3, ($code_per_balance + $per_balance_total) * $convert, $dec);
		$rep->AmountCol(3, 4, ($code_acc_balance + $acc_balance_total) * $convert, $dec);
		$rep->AmountCol(4, 5, Achieve(($code_per_balance + $per_balance_total), ($code_acc_balance + $acc_balance_total)), $pdec);		
		if ($graphics)
		{
			$pg->x[] = $typename;
			$pg->y[] = abs($code_per_balance + $per_balance_total);
			$pg->z[] = abs($code_acc_balance + $acc_balance_total);
		}
		$rep->NewLine();*/
	}
	
	$totals_arr[0] = $code_per_balance + $per_balance_total;
	$totals_arr[1] = $code_acc_balance + $acc_balance_total;
	return $totals_arr;
}




function display_type_ex ($type, $typename, $from, $to, $begin, $end, $compare, $convert, &$dec, &$pdec, &$rep, $dimension, $dimension2, 
	$tags, &$pg, $graphics){
		
	$code_per_balance = 0;
	$code_acc_balance = 0;
	$per_balance_total = 0;
	$acc_balance_total = 0;
	$totals_arr = array();

	$printtitle = 0; //Flag for printing type name	
	
	//Get Accounts directly under this group/type
	$result = get_gl_accounts(null, null, $type);	
	while ($account=db_fetch($result)){
		if ($tags != -1 && is_array($tags) && $tags[0] != false){
			if (!is_record_in_tags($tags, TAG_ACCOUNT, $account['account_code']))
				continue;
		}	
		$per_balance = get_gl_trans_from_to($from, $to, $account["account_code"], $dimension, $dimension2);

		if ($compare == 2)
			$acc_balance = get_budget_trans_from_to($begin, $end, $account["account_code"], $dimension, $dimension2);
		else
			$acc_balance = get_gl_trans_from_to($begin, $end, $account["account_code"], $dimension, $dimension2);
		if (!$per_balance && !$acc_balance)
			continue;
		
		//Print Type Title if it has atleast one non-zero account	
		if (!$printtitle){
			$printtitle = 1;
			//$rep->row -= 4;
			//$rep->TextCol(0, 5, $typename);
			//$rep->row -= 4;
			//$rep->Line($rep->row);
			//$rep->NewLine();		
		}/**/			

		/*$rep->TextCol(0, 1,	$account['account_code']);
		$rep->TextCol(1, 2,	$account['account_name']);

		$rep->AmountCol(2, 3, $per_balance * $convert, $dec);
		$rep->AmountCol(3, 4, $acc_balance * $convert, $dec);
		$rep->AmountCol(4, 5, Achieve($per_balance, $acc_balance), $pdec);*/

		//$rep->NewLine();

		if ($rep->row < $rep->bottomMargin + 3 * $rep->lineHeight){
			$rep->Line($rep->row - 2);
			$rep->NewPage();
		}

		$code_per_balance += $per_balance;
		$code_acc_balance += $acc_balance;
	}
		
	//Get Account groups/types under this group/type
	$result = get_account_types(false, false, $type);
	while ($accounttype=db_fetch($result)){
		//Print Type Title if has sub types and not previously printed
		if (!$printtitle){
			$printtitle = 1;
			$rep->row -= 4;
			$rep->TextCol(0, 5, $typename);
			$rep->row -= 4;
			$rep->Line($rep->row);
			$rep->NewLine();		
		}

		$totals_arr = display_type($accounttype["id"], $accounttype["name"], $from, $to, $begin, $end, $compare, $convert, $dec, 
			$pdec, $rep, $dimension, $dimension2, $tags, $pg, $graphics);
		$per_balance_total += $totals_arr[0];
		$acc_balance_total += $totals_arr[1];
	}

	//Display Type Summary if total is != 0 OR head is printed (Needed in case of unused hierarchical COA) 
	if (($code_per_balance + $per_balance_total + $code_acc_balance + $acc_balance_total) != 0 || $printtitle)
	{
		$rep->row += 6;
		//$rep->Line($rep->row);
		$rep->NewLine();
		$rep->TextCol(0, 2,	$typename);
		$rep->AmountCol(2, 3, ($code_per_balance + $per_balance_total) * $convert, $dec);
		$rep->AmountCol(3, 4, ($code_acc_balance + $acc_balance_total) * $convert, $dec);
		$rep->AmountCol(4, 5, Achieve(($code_per_balance + $per_balance_total), ($code_acc_balance + $acc_balance_total)), $pdec);		
		if ($graphics)
		{
			$pg->x[] = $typename;
			$pg->y[] = abs($code_per_balance + $per_balance_total);
			$pg->z[] = abs($code_acc_balance + $acc_balance_total);
		}
		$rep->NewLine();/**/
	}
	
	$totals_arr[0] = $code_per_balance + $per_balance_total;
	$totals_arr[1] = $code_acc_balance + $acc_balance_total;
	return $totals_arr;
}





print_income_statement();

//----------------------------------------------------------------------------------------------------

function Achieve($d1, $d2){
	if ($d1 == 0 && $d2 == 0)
		return 0;
	elseif ($d2 == 0)
		return 999;
	$ret = ($d1 / $d2 * 100.0);
	if ($ret > 999)
		$ret = 999;
	return $ret;
}
//-------------new function added to the reposrt------------------------
function get_account_classes_R1($all=false, $balance=-1){
	$sql = "SELECT * FROM ".TB_PREF."chart_class";

	if (!$all) 
		$sql .= " WHERE !inactive";
	if ($balance == 0) 
		$sql .= " AND (ctype=".CL_INCOME." OR ctype=".CL_COGS.") OR ctype=0";
		//$sql .= " AND ctype>".CL_EQUITY." OR ctype=0";
	elseif ($balance == 1) 
		$sql .= " AND ctype>0 AND ctype<".CL_INCOME; 
	$sql .= " ORDER BY ctype, cid";
	
	//return $sql;
	return db_query($sql, "could not get account classes");
}

function get_account_classes_R2($all=false, $balance=-1){
	$sql = "SELECT * FROM ".TB_PREF."chart_class";

	if (!$all) 
		$sql .= " WHERE !inactive";
	if ($balance == 0) 
		$sql .= " AND ctype=".CL_EXPENSE." OR ctype=0";
		//$sql .= " AND ctype>".CL_EQUITY." OR ctype=0";
	elseif ($balance == 1) 
		$sql .= " AND ctype>0 AND ctype<".CL_INCOME; 
	$sql .= " ORDER BY ctype, cid";

	return db_query($sql, "could not get account classes");
}

//----------------------------------------------------------------------------------------------------

function print_income_statement()
{
	global $path_to_root;

	$dim = get_company_pref('use_dimension');
	$dimension = $dimension2 = 0;

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$compare = $_POST['PARAM_2'];
	if ($dim == 2) {
		$dimension = $_POST['PARAM_3'];
		$dimension2 = $_POST['PARAM_4'];
		$tags = (isset($_POST['PARAM_5']) ? $_POST['PARAM_5'] : -1);
		$decimals = $_POST['PARAM_6'];
		$graphics = $_POST['PARAM_7'];
		$comments = $_POST['PARAM_8'];
		$destination = $_POST['PARAM_9'];
	} else if ($dim == 1) {
		$dimension = $_POST['PARAM_3'];
		$tags = (isset($_POST['PARAM_4']) ? $_POST['PARAM_4'] : -1);
		$decimals = $_POST['PARAM_5'];
		$graphics = $_POST['PARAM_6'];
		$comments = $_POST['PARAM_7'];
		$destination = $_POST['PARAM_8'];
	} else {
		$tags = (isset($_POST['PARAM_3']) ? $_POST['PARAM_3'] : -1);
		$decimals = $_POST['PARAM_4'];
		$graphics = $_POST['PARAM_5'];
		$comments = $_POST['PARAM_6'];
		$destination = $_POST['PARAM_7'];
	}
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	if ($graphics) {
		include_once($path_to_root . "/reporting/includes/class.graphic.inc");
		$pg = new graph();
	}
	if (!$decimals)
		$dec = 0;
	else
		$dec = user_price_dec();
	$pdec = user_percent_dec();

	$cols = array(0, 50, 200, 350, 425,	500);
	//------------0--1---2----3----4----5--

	$headers = array(_('Account'), _('Account Name'), _('Period'), _('Accumulated'), _('Achieved %'));

	$aligns = array('left',	'left',	'right', 'right', 'right');

    if ($dim == 2){
    	$params =   array( 	0 => $comments,
    				    1 => array('text' => _('Period'),'from' => $from, 'to' => $to),
                    	2 => array('text' => _('Dimension')." 1",
                            'from' => get_dimension_string($dimension), 'to' => ''),
                    	3 => array('text' => _('Dimension')." 2",
                            'from' => get_dimension_string($dimension2), 'to' => ''),
                        4 => array('text' => _('Tags'), 'from' => get_tag_names($tags), 'to' => ''));
    } else if ($dim == 1) {
    	$params =   array( 	0 => $comments,
    				    1 => array('text' => _('Period'),'from' => $from, 'to' => $to),
                    	2 => array('text' => _('Dimension'),
                            'from' => get_dimension_string($dimension), 'to' => ''),
                        3 => array('text' => _('Tags'), 'from' => get_tag_names($tags), 'to' => ''));
    } else {
    	$params =   array( 	0 => $comments,
    				    1 => array('text' => _('Period'),'from' => $from, 'to' => $to),
    				    2 => array('text' => _('Tags'), 'from' => get_tag_names($tags), 'to' => ''));
    }


	if ($compare == 0 || $compare == 2) {
		$end = $to;
		if ($compare == 2) {
			$begin = $from;
			$headers[3] = _('Budget');
		}else
			$begin = begin_fiscalyear();
	}
	elseif ($compare == 1) {
		$begin = add_months($from, -12);
		$end = add_months($to, -12);
		$headers[3] = _('Period Y-1');
	}

	$rep = new FrontReport(_('Income Statement'), "Income", user_pagesize());
	$rep->SetHeaderType('Header_bs');

	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();

	$salesper = 0.0;
	$salesacc = 0.0;	

	$classresult = get_account_classes_R1(false, 0);
	//$rep->TextCol(0, 5, $classresult);
	//$rep->NewLine();
	while ($class = db_fetch($classresult)){
		$class_per_total = 0;
		$class_acc_total = 0;
		$convert = get_class_type_convert($class["ctype"]); 		
		
		//Print Class Name	
		/*$rep->Font('bold');
		$rep->TextCol(0, 5, $class["class_name"]);
		$rep->Font();
		$rep->NewLine();*/
		
		//Get Account groups/types under this group/type with no parents
		$typeresult = get_account_types(false, $class['cid'], -1);
		while ($accounttype=db_fetch($typeresult)) {
			$classtotal = display_type($accounttype["id"], $accounttype["name"], $from, $to, $begin, $end, $compare, $convert, $dec, 
				$pdec, $rep, $dimension, $dimension2, $tags, $pg, $graphics);
			$class_per_total += $classtotal[0];
			$class_acc_total += $classtotal[1];			
		}
		
		//Print Class Summary	
		/*$rep->row += 6;
		$rep->Line($rep->row);
		$rep->NewLine();*/
		//$rep->Font('bold');
		$rep->TextCol(0, 2,	_('') . " " . $class["class_name"]);
		$rep->AmountCol(2, 3, $class_per_total * $convert, $dec);
		$rep->AmountCol(3, 4, $class_acc_total * $convert, $dec);
		$rep->AmountCol(4, 5, Achieve($class_per_total, $class_acc_total), $pdec);
		$rep->Font();
		$rep->NewLine(1);	

		$gross = $salesper += $class_per_total;
		$grossacc = $salesacc += $class_acc_total;
	}

		$rep->row += 6;
		$rep->Line($rep->row);
		$rep->NewLine();
		$rep->Font('bold');

		$rep->TextCol(0, 2,	_('Gross Profit'));
		$rep->AmountCol(2, 3, $gross * $convert*-1, $dec);
		$rep->AmountCol(3, 4, $grossacc * $convert*-1, $dec);
		$rep->AmountCol(4, 5, Achieve($class_per_total, $class_acc_total), $pdec);
		
		$rep->NewLine();
		$rep->Line($rep->row);
		$rep->NewLine();


///////////////////////////////////////////////////////////////////////////////////////////////
	$classresult = get_account_classes_R2(false, 0);
	while ($class = db_fetch($classresult))
	{
		$class_per_total = 0;
		$class_acc_total = 0;
		$convert = get_class_type_convert($class["ctype"]); 		
		
		//Print Class Name	
		/*$rep->Font('bold');
		$rep->TextCol(0, 5, $class["class_name"]);*/
		$rep->Font();
		//$rep->NewLine();
		
		//Get Account groups/types under this group/type with no parents
		$typeresult = get_account_types(false, $class['cid'], -1);
		while ($accounttype=db_fetch($typeresult)) {
			$classtotal = display_type_ex($accounttype["id"], $accounttype["name"], $from, $to, $begin, $end, $compare, $convert, $dec, 
				$pdec, $rep, $dimension, $dimension2, $tags, $pg, $graphics);
			$class_per_total += $classtotal[0];
			$class_acc_total += $classtotal[1];			
		}
		
		//Print Class Summary	
		/**/$rep->row += 6;
		$rep->Line($rep->row);
		$rep->NewLine();
		$rep->Font('bold');
		$rep->TextCol(0, 2,	_('Total') . " " . $class["class_name"]);
		$rep->AmountCol(2, 3, $class_per_total * $convert, $dec);
		$rep->AmountCol(3, 4, $class_acc_total * $convert, $dec);
		$rep->AmountCol(4, 5, Achieve($class_per_total, $class_acc_total), $pdec);
		$rep->Font();
		$rep->NewLine(2);	

		$gross = $salesper += $class_per_total;
		$grossacc = $salesacc += $class_acc_total;
	}

///////////////////
		$rep->row += 6;
		$rep->Line($rep->row);
		$rep->NewLine();
		$rep->Font('bold');

		$rep->TextCol(0, 2,	_('Profit Before Tax'));
		$rep->AmountCol(2, 3, ($gross-$expences) * $convert*-1, $dec);
		$rep->AmountCol(3, 4, ($grossacc-$expencesacc) * $convert*-1, $dec);
		$rep->AmountCol(4, 5, Achieve($class_per_total, $class_acc_total), $pdec);
		
		$rep->NewLine();
		$rep->Line($rep->row);
		$rep->NewLine();

//////////////////////////////////////////////////////////////////////////////////

	$rep->Font('bold');	
	$rep->TextCol(0, 2,	_('Profit for the Period'));
	$rep->AmountCol(2, 3, $salesper *-1, $dec); // always convert
	$rep->AmountCol(3, 4, $salesacc * -1, $dec);
	$rep->AmountCol(4, 5, Achieve($salesper, $salesacc), $pdec);
	if ($graphics) {
		$pg->x[] = _('Profit for the Period');
		$pg->y[] = abs($salesper);
		$pg->z[] = abs($salesacc);
	}
	$rep->Font();
	$rep->NewLine();
	$rep->Line($rep->row);
	if ($graphics) {
		global $decseps, $graph_skin;
		$pg->title     = $rep->title;
		$pg->axis_x    = _("Group");
		$pg->axis_y    = _("Amount");
		$pg->graphic_1 = $headers[2];
		$pg->graphic_2 = $headers[3];
		$pg->type      = $graphics;
		$pg->skin      = $graph_skin;
		$pg->built_in  = false;
		$pg->latin_notation = ($decseps[$_SESSION["wa_current_user"]->prefs->dec_sep()] != ".");
		$filename = company_path(). "/pdf_files/". uniqid("").".png";
		$pg->display($filename, true);
		$w = $pg->width / 1.5;
		$h = $pg->height / 1.5;
		$x = ($rep->pageWidth - $w) / 2;
		$rep->NewLine(2);
		if ($rep->row - $h < $rep->bottomMargin)
			$rep->NewPage();
		$rep->AddImage($filename, $x, $rep->row - $h, $w, $h);
	}
		
	$rep->End();
}

?>