<?php
/**********************************************************************
   Copyright (C) Evolve Techniologies
	Author : Danushka Widanage
	Email : dwidanage@gmail.com
	Company : Evolve Technologies(pvt)Ltd
***********************************************************************/
$page_security = 'SA_ITEMSVALREP';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	evolve
// date_:	2005-05-19
// Title:	Inventory Valuation
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/inventory/includes/db/items_category_db.inc");

//----------------------------------------------------------------------------------------------------

print_sales_details_report();


function getSales_Salesman_Details($from, $to){
	$fromdate = date2sql($from);
	$todate = date2sql($to);
					
	$sql = "SELECT  dtd.debtor_trans_no, dt.tpe, cb.salesman, s.salesman_name, s.salesman_code, dt.ov_amount, dt.ov_discount, dt.ov_gst, dt.trans_no, 
			dt.debtor_no, dt.reference,
				(SELECT sales_type FROM ".TB_PREF."sales_types WHERE id = dt.tpe) AS stype

				FROM ".TB_PREF."main_category AS mc , ".TB_PREF."stock_category AS sc, ".TB_PREF."stock_master AS sm, ".TB_PREF."debtor_trans_details AS dtd,
				 ".TB_PREF."debtor_trans AS dt, ".TB_PREF."cust_branch AS cb, ".TB_PREF."salesman AS s
				
				WHERE  sc.category_id = sm.category_id
				AND sm.stock_id = dtd.stock_id
				AND dtd.debtor_trans_no = dt.trans_no
				AND dt.branch_code = cb.branch_code
				AND cb.salesman = s.salesman_code
				AND (dtd.debtor_trans_type = ".ST_SALESINVOICE." OR dtd.debtor_trans_type = ".ST_CUSTCREDIT.")
				AND (dt.type = ".ST_SALESINVOICE." OR dt.type = ".ST_CUSTCREDIT.")
				AND dt.tran_date>=".db_escape($fromdate)." 
				AND dt.tran_date<=".db_escape($todate)."
	
				GROUP BY dt.trans_no
				ORDER BY  dt.tpe, s.salesman_code, dt.debtor_no, dt.trans_no";
	
	
	return db_query($sql,"No transactions were returned");
}

function print_sales_details_report(){
    global $path_to_root;
	
	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$main_category = $_POST['PARAM_2'];
	
	$main_cat = get_main_category_name($main_category);
	//include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	include_once($path_to_root . "/reporting/includes/excel_report.inc");
    $dec = user_price_dec();
	

	$cols = array(0, 10, 90, 150, 300, 380, 460, 520, 600, 680);
	$headers = array(_(''), _('Description'), _('INV #'),_('Customer'),  _('Total with Vat'), _('Vat'), _('Total'));
	
	$aligns = array('left',	'left',	'left', 'left',	'right',	'right', 'right', 'right');
    $params =   array( 	0 => $comments,
    					//1 => array('text' => _('Main Category'), 'from' => $main_cat, 'to' => ''),
						1 => array('text' => _('Date'), 'from' => $from, 'to' => $to));

    $rep = new FrontReport(_('Sales Report'), "SalesReport", user_pagesize(), 10, 'P');

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();
//$rep->TextColLines(1, 5, print_r($items), 10);

	$grandtotal = 0;

		$subtotal = $total = $subprov = $provtotal = 0;

		$result_sales = getSales_Salesman_Details($from, $to);
		$sales_type = '';
		$sales_men = '';
		$sales_subtotals = '';
		while($row_sales = db_fetch($result_sales)){
			
			if($sales_type != $row_sales['tpe']){
				$rep->Font('bold');
				$rep->TextCol(0, 2, $row_sales['stype']);
				$rep->NewLine(2, 3);
				$rep->Font('bold');
				$rep->Font();
				$sales_type = $row_sales['tpe'];
			}
			
			if($sales_men != $row_sales['salesman_name']){
				$rep->TextCol(1, 2,	$row_sales['salesman_name'], -2);
				$sales_men = $row_sales['salesman_name'];
			}
			
			$rep->TextCol(2, 3,	$row_sales['reference'], -2);
			$customer_name = get_customer_name($row_sales['debtor_no']);
			$rep->TextCol(3, 4,	$customer_name, -2);
			$rep->AmountCol(4, 5,	$row_sales['ov_amount'], $dec);
			$rep->AmountCol(5, 6,	($row_sales['ov_amount']/112)*12, $dec);
			$rep->AmountCol(6, 7,	($row_sales['ov_amount']/112)*100, $dec);/**/
			$rep->NewLine();
			
			$subtotal += $row_sales['ov_amount'];
			$grandtotal += $row_sales['ov_amount'];

		}
		
	$rep->Line($rep->row  - 4);
	$rep->NewLine();
	$rep->NewLine();
	$rep->NewLine();
	$rep->fontSize += 2;
	$rep->TextCol(0, 2,	'Grand Total', -2);
	$rep->fontSize -= 2;
	$rep->AmountCol(4, 5,	$grandtotal, $dec);
	$rep->AmountCol(5, 6,	($grandtotal/112)*12, $dec);
	$rep->AmountCol(6, 7,	($grandtotal/112)*100, $dec);

	$rep->NewLine();
    $rep->End();
}

?>