<?php
/**********************************************************************
	Copyright (C) Evolve Techniologies
	Author : Danushka Widanage
	Email : dwidanage@gmail.com
	Company : Evolve Technologies(pvt)Ltd
***********************************************************************/
$page_security = 'SA_ITEMCATEGORY';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");

page(_($help_context = "Main Categories"));

include_once($path_to_root . "/includes/ui.inc");

include_once($path_to_root . "/inventory/includes/inventory_db.inc");

simple_page_mode(true);
//----------------------------------------------------------------------------------

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{

	//initialise no input errors assumed initially before we test
	$input_error = 0;

	if (strlen($_POST['main_cat_name']) == 0) 
	{
		$input_error = 1;
		display_error(_("The Main category description cannot be empty."));
		set_focus('main_cat_name');
	}

	if ($input_error !=1)
	{
    	if ($selected_id != -1) 
    	{
		    update_main_category($selected_id, $_POST['main_cat_name']);
			display_notification(_('Selected Main category has been updated'));
    	} 
    	else 
    	{
		    add_main_category($_POST['main_cat_name']);
			display_notification(_('New Main category has been added'));
    	}
		$Mode = 'RESET';
	}
}

//---------------------------------------------------------------------------------- 

if ($Mode == 'Delete')
{

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'stock_master'
	if (key_in_foreign_table($selected_id, 'stock_category', 'main_category_id'))
	{
		display_error(_("Cannot delete this Main category because items category have been created using this Main category."));
	} 
	else 
	{
		delete_main_category($selected_id);
		display_notification(_('Selected Main category has been deleted'));
	}
	$Mode = 'RESET';
}

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}
if (list_updated('mb_flag')) {
	$Ajax->activate('details');
}
//----------------------------------------------------------------------------------

$result = get_main_categories(check_value('show_inactive'));

start_form();
start_table(TABLESTYLE, "width=80%");
$th = array(_("Name"), "","");
inactive_control_column($th);

table_header($th);
$k = 0; //row colour counter

while ($myrow = db_fetch($result)) 
{
	
	alt_table_row_color($k);

	label_cell($myrow["main_cat_name"]);
	inactive_control_cell($myrow["main_category_id"], $myrow["inactive"], 'main_category', 'main_category_id');
 	edit_button_cell("Edit".$myrow["main_category_id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["main_category_id"], _("Delete"));
	end_row();
}

inactive_control_row($th);
end_table();
echo '<br>';
//----------------------------------------------------------------------------------

div_start('details');
start_table(TABLESTYLE2);

if ($selected_id != -1) 
{
 	if ($Mode == 'Edit') {
		//editing an existing item category
		$myrow = get_main_category($selected_id);

		$_POST['main_category_id'] = $myrow["main_category_id"];
		$_POST['main_cat_name']  = $myrow["main_cat_name"];
		
	} 
	hidden('selected_id', $selected_id);
	hidden('main_category_id');
} else if ($Mode != 'CLONE') {
		$_POST['main_cat_name'] = '';

		$company_record = get_company_prefs();


}

text_row(_("Main Category Name:"), 'main_cat_name', null, 30, 30);  

table_section_title(_("Default values for new items"));



end_table(1);
div_end();
submit_add_or_update_center($selected_id == -1, '', 'both', true);

end_form();

end_page();

?>
