# MySQL dump of database 'evolve35_360v6' on host 'localhost'
# Backup Date and Time: 2018-02-24 02:21
# Built by EvolveAccounting EVOLVE360v6
# http://evolve-sl.com
# Company: Demo - AT Group
# User: Administrator

# Compatibility: 2.4.1


SET NAMES latin1;


### Structure of table `3_areas` ###

DROP TABLE IF EXISTS `3_areas`;

CREATE TABLE `3_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_areas` ###

INSERT INTO `3_areas` VALUES
('1', 'Global', '0');

### Structure of table `3_attachments` ###

DROP TABLE IF EXISTS `3_attachments`;

CREATE TABLE `3_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_no` int(11) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `unique_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT '0',
  `filetype` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_attachments` ###


### Structure of table `3_audit_trail` ###

DROP TABLE IF EXISTS `3_audit_trail`;

CREATE TABLE `3_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `user` smallint(6) unsigned NOT NULL DEFAULT '0',
  `stamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL DEFAULT '0',
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_audit_trail` ###

INSERT INTO `3_audit_trail` VALUES
('1', '18', '1', '1', '2018-02-08 07:30:53', NULL, '11', '2018-02-08', '0'),
('2', '25', '1', '1', '2018-02-08 07:30:53', NULL, '11', '2018-02-08', '0'),
('3', '18', '2', '1', '2018-02-08 07:52:07', NULL, '11', '2018-02-08', '0'),
('4', '25', '2', '1', '2018-02-08 07:52:08', NULL, '11', '2018-02-08', '0'),
('5', '20', '1', '1', '2018-02-08 07:55:13', NULL, '11', '2018-02-08', NULL),
('6', '20', '1', '1', '2018-02-08 07:55:13', 'Voided.\nDocument reentered.', '11', '2018-02-08', '0'),
('7', '20', '2', '1', '2018-02-08 08:07:16', NULL, '11', '2018-02-08', NULL),
('8', '20', '2', '1', '2018-02-08 08:07:16', 'Voided.\nDocument reentered.', '11', '2018-02-08', '0'),
('9', '20', '3', '1', '2018-02-09 04:35:10', NULL, '11', '2018-02-08', NULL),
('10', '20', '3', '1', '2018-02-09 04:35:10', 'Voided.\nDocument reentered.', '11', '2018-02-09', '0'),
('11', '20', '4', '1', '2018-02-09 04:41:56', NULL, '11', '2018-02-08', NULL),
('12', '20', '4', '1', '2018-02-09 04:41:56', 'Voided.\nDocument reentered.', '11', '2018-02-09', '0'),
('13', '20', '5', '1', '2018-02-09 04:43:21', NULL, '11', '2018-02-08', NULL),
('14', '20', '5', '1', '2018-02-09 04:43:21', 'Voided.\nDocument reentered.', '11', '2018-02-09', '0'),
('15', '20', '6', '1', '2018-02-09 04:45:30', NULL, '11', '2018-02-08', NULL),
('16', '20', '6', '1', '2018-02-09 04:45:30', 'Voided.\nDocument reentered.', '11', '2018-02-09', '0'),
('17', '20', '7', '1', '2018-02-09 04:46:22', NULL, '11', '2018-02-08', NULL),
('18', '20', '7', '1', '2018-02-09 04:46:22', 'Voided.\nDocument reentered.', '11', '2018-02-09', '0'),
('19', '20', '8', '1', '2018-02-09 04:47:51', NULL, '11', '2018-02-08', NULL),
('20', '20', '8', '1', '2018-02-09 04:47:51', 'Voided.\nDocument reentered.', '11', '2018-02-09', '0'),
('21', '20', '9', '1', '2018-02-09 05:49:30', NULL, '11', '2018-02-08', NULL),
('22', '18', '3', '1', '2018-02-09 05:09:50', NULL, '11', '2018-02-09', '0'),
('23', '25', '3', '1', '2018-02-09 05:09:50', NULL, '11', '2018-02-09', '0'),
('24', '18', '4', '1', '2018-02-09 05:18:47', NULL, '11', '2018-02-09', '0'),
('25', '25', '4', '1', '2018-02-09 05:18:47', NULL, '11', '2018-02-09', '0'),
('26', '18', '5', '1', '2018-02-09 05:27:16', NULL, '11', '2018-02-09', '0'),
('27', '25', '5', '1', '2018-02-09 05:27:16', NULL, '11', '2018-02-09', '0'),
('28', '18', '6', '1', '2018-02-09 05:28:20', NULL, '11', '2018-02-09', '0'),
('29', '25', '6', '1', '2018-02-09 05:28:20', NULL, '11', '2018-02-09', '0'),
('30', '18', '7', '1', '2018-02-09 05:34:06', NULL, '11', '2018-02-09', '0'),
('31', '25', '7', '1', '2018-02-09 05:34:06', NULL, '11', '2018-02-09', '0'),
('32', '18', '8', '1', '2018-02-09 05:39:01', NULL, '11', '2018-02-09', '0'),
('33', '25', '8', '1', '2018-02-09 05:39:01', NULL, '11', '2018-02-09', '0'),
('34', '20', '10', '1', '2018-02-10 02:14:38', NULL, '11', '2018-02-09', NULL),
('35', '20', '9', '1', '2018-02-09 05:49:30', 'Voided.\n', '11', '2018-02-09', '0'),
('36', '30', '1', '1', '2018-02-09 05:56:12', NULL, '11', '2018-02-09', '0'),
('37', '13', '1', '1', '2018-02-10 02:03:50', NULL, '11', '2018-02-09', NULL),
('38', '10', '1', '1', '2018-02-09 06:28:36', NULL, '11', '2018-02-09', NULL),
('39', '30', '2', '1', '2018-02-09 05:57:26', NULL, '11', '2018-02-09', '0'),
('40', '13', '2', '1', '2018-02-10 01:46:10', NULL, '11', '2018-02-09', NULL),
('41', '10', '2', '1', '2018-02-09 06:28:02', NULL, '11', '2018-02-09', NULL),
('42', '30', '3', '1', '2018-02-09 05:58:36', NULL, '11', '2018-02-09', '0'),
('43', '13', '3', '1', '2018-02-09 05:58:36', NULL, '11', '2018-02-09', '0'),
('44', '10', '3', '1', '2018-02-09 06:28:22', NULL, '11', '2018-02-09', NULL),
('45', '30', '4', '1', '2018-02-09 05:59:39', NULL, '11', '2018-02-09', '0'),
('46', '13', '4', '1', '2018-02-09 05:59:39', NULL, '11', '2018-02-09', '0'),
('47', '10', '4', '1', '2018-02-09 06:26:38', NULL, '11', '2018-02-09', NULL),
('48', '2', '1', '1', '2018-02-09 06:12:44', NULL, '11', '2018-01-01', '0'),
('49', '1', '1', '1', '2018-02-09 06:13:51', NULL, '11', '2018-02-09', '0'),
('50', '10', '4', '1', '2018-02-09 06:26:38', 'Updated.', '11', '2018-02-09', '0'),
('51', '10', '2', '1', '2018-02-10 01:42:17', 'Updated.', '11', '2018-02-09', NULL),
('52', '10', '3', '1', '2018-02-09 06:28:22', 'Updated.', '11', '2018-02-09', '0'),
('53', '10', '1', '1', '2018-02-10 01:29:38', 'Updated.', '11', '2018-02-09', NULL),
('54', '10', '1', '1', '2018-02-10 01:32:46', 'Updated.', '11', '2018-02-09', NULL),
('55', '10', '1', '1', '2018-02-10 01:40:17', 'Updated.', '11', '2018-02-09', NULL),
('56', '10', '1', '1', '2018-02-10 02:03:50', 'Updated.', '11', '2018-02-09', NULL),
('57', '10', '2', '1', '2018-02-10 01:46:10', 'Updated.', '11', '2018-02-09', NULL),
('58', '30', '5', '1', '2018-02-10 01:43:27', NULL, '11', '2018-02-10', '0'),
('59', '13', '5', '1', '2018-02-10 01:56:15', NULL, '11', '2018-02-10', NULL),
('60', '10', '5', '1', '2018-02-10 01:54:05', NULL, '11', '2018-02-10', NULL),
('61', '12', '1', '1', '2018-02-10 02:02:48', NULL, '11', '2018-02-10', NULL),
('62', '13', '2', '1', '2018-02-10 01:46:10', 'Voided.', '11', '2018-02-10', '0'),
('63', '10', '2', '1', '2018-02-10 01:46:10', 'Voided.\n', '11', '2018-02-10', '0'),
('64', '10', '5', '1', '2018-02-10 01:56:15', 'Updated.', '11', '2018-02-10', NULL),
('65', '13', '5', '1', '2018-02-10 01:56:15', 'Voided.', '11', '2018-02-10', '0'),
('66', '10', '5', '1', '2018-02-10 01:56:15', 'Voided.\n', '11', '2018-02-10', '0'),
('67', '30', '6', '1', '2018-02-10 01:58:45', NULL, '11', '2018-02-10', '0'),
('68', '13', '6', '1', '2018-02-10 01:58:45', NULL, '11', '2018-02-10', '0'),
('69', '10', '6', '1', '2018-02-10 01:58:45', NULL, '11', '2018-02-10', '0'),
('70', '12', '2', '1', '2018-02-10 01:58:45', NULL, '11', '2018-02-10', '0'),
('71', '12', '1', '1', '2018-02-10 02:02:48', 'Voided.\n', '11', '2018-02-10', '0'),
('72', '13', '1', '1', '2018-02-10 02:03:50', 'Voided.', '11', '2018-02-10', '0'),
('73', '10', '1', '1', '2018-02-10 02:03:50', 'Voided.\n', '11', '2018-02-10', '0'),
('74', '30', '7', '1', '2018-02-10 02:04:53', NULL, '11', '2018-02-10', '0'),
('75', '13', '7', '1', '2018-02-10 02:04:53', NULL, '11', '2018-02-10', '0'),
('76', '10', '7', '1', '2018-02-10 02:04:53', NULL, '11', '2018-02-10', '0'),
('77', '12', '3', '1', '2018-02-10 02:04:53', NULL, '11', '2018-02-10', '0'),
('78', '20', '10', '1', '2018-02-10 02:14:38', 'Voided.\nDocument reentered.', '11', '2018-02-10', '0'),
('79', '20', '11', '1', '2018-02-10 02:17:39', NULL, '11', '2018-02-09', NULL),
('80', '20', '11', '1', '2018-02-10 02:17:39', 'Voided.\nDocument reentered.', '11', '2018-02-10', '0'),
('81', '20', '12', '1', '2018-02-10 02:17:39', NULL, '11', '2018-02-09', '0'),
('82', '1', '2', '1', '2018-02-13 00:28:56', NULL, '11', '2018-02-13', NULL),
('83', '1', '2', '1', '2018-02-13 00:28:56', NULL, '11', '2018-02-13', '0'),
('84', '18', '9', '1', '2018-02-23 00:16:54', NULL, '11', '2018-02-15', NULL),
('85', '25', '9', '1', '2018-02-15 06:52:17', NULL, '11', '2018-02-15', '0'),
('86', '18', '10', '1', '2018-02-22 05:08:13', NULL, '11', '2018-02-22', '0'),
('87', '25', '10', '1', '2018-02-22 05:08:13', NULL, '11', '2018-02-22', '0'),
('88', '18', '11', '1', '2018-02-22 21:15:43', NULL, '11', '2018-02-23', '0'),
('89', '25', '11', '1', '2018-02-22 21:15:43', NULL, '11', '2018-02-23', '0'),
('90', '18', '12', '1', '2018-02-22 21:19:16', NULL, '11', '2018-02-22', '0'),
('91', '25', '12', '1', '2018-02-22 21:19:16', NULL, '11', '2018-02-22', '0'),
('92', '1', '3', '1', '2018-02-22 21:24:27', NULL, '11', '2018-02-23', '0'),
('93', '30', '8', '1', '2018-02-22 21:29:13', NULL, '11', '2018-02-23', '0'),
('94', '13', '8', '1', '2018-02-22 21:29:13', NULL, '11', '2018-02-23', '0'),
('95', '10', '8', '1', '2018-02-23 01:00:14', NULL, '11', '2018-02-23', NULL),
('96', '30', '9', '1', '2018-02-22 21:31:18', NULL, '11', '2018-02-22', '0'),
('97', '13', '9', '1', '2018-02-22 21:31:18', NULL, '11', '2018-02-22', '0'),
('98', '10', '9', '1', '2018-02-22 21:31:18', NULL, '11', '2018-02-22', '0'),
('99', '30', '10', '1', '2018-02-22 21:32:42', NULL, '11', '2018-02-23', '0'),
('100', '13', '10', '1', '2018-02-22 21:32:42', NULL, '11', '2018-02-23', '0'),
('101', '10', '10', '1', '2018-02-22 21:32:42', NULL, '11', '2018-02-23', '0'),
('102', '30', '11', '1', '2018-02-22 21:33:47', NULL, '11', '2018-02-23', '0'),
('103', '13', '11', '1', '2018-02-22 21:33:47', NULL, '11', '2018-02-23', '0'),
('104', '10', '11', '1', '2018-02-22 21:33:47', NULL, '11', '2018-02-23', '0'),
('105', '18', '13', '1', '2018-02-22 21:59:48', NULL, '11', '2018-02-22', '0'),
('106', '25', '13', '1', '2018-02-22 21:59:48', NULL, '11', '2018-02-22', '0'),
('107', '20', '13', '1', '2018-02-23 00:06:34', NULL, '11', '2018-02-22', NULL),
('108', '20', '14', '1', '2018-02-22 23:42:40', NULL, '11', '2018-02-22', NULL),
('109', '20', '15', '1', '2018-02-23 00:09:12', NULL, '11', '2018-02-22', NULL),
('110', '20', '14', '1', '2018-02-22 23:42:40', 'Voided.\nDocument reentered.', '11', '2018-02-22', '0'),
('111', '20', '16', '1', '2018-02-23 00:06:41', NULL, '11', '2018-02-22', NULL),
('112', '18', '14', '1', '2018-02-22 23:57:03', NULL, '11', '2018-02-22', '0'),
('113', '25', '14', '1', '2018-02-22 23:57:04', NULL, '11', '2018-02-22', '0'),
('114', '20', '17', '1', '2018-02-23 01:10:22', NULL, '11', '2018-02-22', NULL),
('115', '20', '18', '1', '2018-02-23 01:13:11', NULL, '11', '2018-02-22', NULL),
('116', '20', '13', '1', '2018-02-23 00:06:34', 'Voided.\n', '11', '2018-02-22', '0'),
('117', '20', '16', '1', '2018-02-23 00:06:41', 'Voided.\n', '11', '2018-02-23', '0'),
('118', '20', '15', '1', '2018-02-23 00:09:12', 'Voided.\n', '11', '2018-02-23', '0'),
('119', '18', '9', '1', '2018-02-23 00:16:54', 'Updated.', '11', '2018-02-23', '0'),
('120', '12', '4', '1', '2018-02-23 00:20:34', NULL, '11', '2018-02-23', '0'),
('121', '22', '1', '1', '2018-02-23 00:29:40', NULL, '11', '2018-02-23', NULL),
('122', '22', '2', '1', '2018-02-23 00:26:51', NULL, '11', '2018-02-23', '0'),
('123', '22', '1', '1', '2018-02-23 00:29:40', 'Voided.\n', '11', '2018-02-23', '0'),
('124', '22', '3', '1', '2018-02-23 00:31:22', NULL, '11', '2018-02-23', '0'),
('125', '22', '4', '1', '2018-02-23 00:34:06', NULL, '11', '2018-02-23', '0'),
('126', '18', '15', '1', '2018-02-23 00:48:12', NULL, '11', '2018-02-23', '0'),
('127', '25', '15', '1', '2018-02-23 00:48:12', NULL, '11', '2018-02-23', '0'),
('128', '20', '19', '1', '2018-02-23 00:52:36', NULL, '11', '2018-02-23', '0'),
('129', '30', '12', '1', '2018-02-23 00:55:20', NULL, '11', '2018-02-23', '0'),
('130', '13', '12', '1', '2018-02-23 00:55:20', NULL, '11', '2018-02-23', '0'),
('131', '10', '12', '1', '2018-02-23 00:57:27', NULL, '11', '2018-02-23', NULL),
('132', '10', '12', '1', '2018-02-23 00:57:27', 'Updated.', '11', '2018-02-23', '0'),
('133', '10', '8', '1', '2018-02-23 01:00:14', 'Updated.', '11', '2018-02-23', '0'),
('134', '20', '17', '1', '2018-02-23 01:10:22', 'Voided.\nDocument reentered.', '11', '2018-02-23', '0'),
('135', '20', '20', '1', '2018-02-23 01:16:15', NULL, '11', '2018-02-22', NULL),
('136', '20', '18', '1', '2018-02-23 01:13:11', 'Voided.\nDocument reentered.', '11', '2018-02-23', '0'),
('137', '20', '21', '1', '2018-02-23 01:21:28', NULL, '11', '2018-02-22', NULL),
('138', '20', '20', '1', '2018-02-23 01:16:15', 'Voided.\nDocument reentered.', '11', '2018-02-23', '0'),
('139', '20', '22', '1', '2018-02-23 01:23:43', NULL, '11', '2018-02-22', NULL),
('140', '20', '21', '1', '2018-02-23 01:21:28', 'Voided.\nDocument reentered.', '11', '2018-02-23', '0'),
('141', '20', '23', '1', '2018-02-23 01:23:38', NULL, '11', '2018-02-22', NULL),
('142', '20', '23', '1', '2018-02-23 01:23:38', 'Voided.\n', '11', '2018-02-23', '0'),
('143', '20', '22', '1', '2018-02-23 01:23:43', 'Voided.\n', '11', '2018-02-23', '0'),
('144', '18', '16', '1', '2018-02-23 01:24:57', NULL, '11', '2018-02-23', '0'),
('145', '25', '16', '1', '2018-02-23 01:24:57', NULL, '11', '2018-02-23', '0'),
('146', '20', '24', '1', '2018-02-23 01:25:30', NULL, '11', '2018-02-23', '0'),
('147', '20', '25', '1', '2018-02-23 01:26:13', NULL, '11', '2018-02-23', '0'),
('148', '18', '17', '1', '2018-02-23 04:05:28', NULL, '11', '2018-02-23', '0'),
('149', '25', '17', '1', '2018-02-23 04:05:28', NULL, '11', '2018-02-23', '0'),
('150', '1', '4', '1', '2018-02-23 04:25:14', NULL, '11', '2018-02-23', '0'),
('151', '1', '5', '1', '2018-02-23 04:28:28', NULL, '11', '2018-02-23', '0'),
('152', '30', '13', '1', '2018-02-23 04:36:40', NULL, '11', '2018-02-23', '0'),
('153', '13', '13', '1', '2018-02-23 04:36:40', NULL, '11', '2018-02-23', '0'),
('154', '10', '13', '1', '2018-02-23 04:36:40', NULL, '11', '2018-02-23', '0'),
('155', '12', '5', '1', '2018-02-23 04:36:40', NULL, '11', '2018-02-23', '0'),
('156', '30', '14', '1', '2018-02-23 04:41:52', NULL, '11', '2018-02-23', '0'),
('157', '13', '14', '1', '2018-02-23 04:41:52', NULL, '11', '2018-02-23', '0'),
('158', '10', '14', '1', '2018-02-23 04:41:52', NULL, '11', '2018-02-23', '0'),
('159', '12', '6', '1', '2018-02-23 04:44:19', NULL, '11', '2018-02-23', '0'),
('160', '20', '26', '1', '2018-02-23 04:54:50', NULL, '11', '2018-02-23', '0'),
('161', '20', '27', '1', '2018-02-23 04:57:45', NULL, '11', '2018-02-23', '0'),
('162', '22', '5', '1', '2018-02-23 04:59:00', NULL, '11', '2018-02-23', '0');

### Structure of table `3_bank_accounts` ###

DROP TABLE IF EXISTS `3_bank_accounts`;

CREATE TABLE `3_bank_accounts` (
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT '0',
  `bank_account_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_address` tinytext COLLATE utf8_unicode_ci,
  `bank_curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT '0',
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `bank_charge_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_bank_accounts` ###

INSERT INTO `3_bank_accounts` VALUES
('10400', '0', 'Current account', 'N/A', 'N/A', NULL, 'USD', '1', '1', '62000', '0000-00-00 00:00:00', '0', '0'),
('10000', '3', 'Petty Cash account', 'N/A', 'N/A', NULL, 'USD', '0', '2', '62000', '0000-00-00 00:00:00', '0', '0'),
('10500', '3', 'Petty Cash', '', '', NULL, 'LKR', '0', '3', '62000', '0000-00-00 00:00:00', '0', '0'),
('10100', '3', 'Cash Account', '', '', NULL, 'LKR', '1', '4', '62000', '2018-02-22 00:00:00', '0', '0');

### Structure of table `3_bank_trans` ###

DROP TABLE IF EXISTS `3_bank_trans`;

CREATE TABLE `3_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ref` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `person_type_id` int(11) NOT NULL DEFAULT '0',
  `person_id` tinyblob,
  `reconciled` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_bank_trans` ###

INSERT INTO `3_bank_trans` VALUES
('1', '2', '1', '3', '1', '2018-01-01', '10000', '0', '0', '0', NULL, NULL),
('2', '1', '1', '3', '1', '2018-02-09', '-1200', '0', '0', '0', 'Cash', NULL),
('3', '12', '1', '4', '1', '2018-02-10', '0', '0', '0', '2', '1', NULL),
('4', '12', '2', '4', '2', '2018-02-10', '14840', '0', '0', '2', '1', NULL),
('5', '12', '3', '4', '3', '2018-02-10', '17340', '0', '0', '2', '4', NULL),
('6', '1', '2', '4', '2', '2018-02-13', '-20000', '0', '0', '3', '1', NULL),
('7', '1', '3', '3', '3', '2018-02-23', '-1200', '0', '0', '0', 'Cash', NULL),
('8', '12', '4', '3', '4', '2018-02-23', '46590', '0', '0', '2', '6', NULL),
('9', '22', '1', '3', '1', '2018-02-23', '0', '0', '0', '3', '4', NULL),
('10', '22', '2', '4', '2', '2018-02-23', '-10000', '0', '0', '3', '1', NULL),
('11', '22', '3', '3', '3', '2018-02-23', '-16720', '0', '0', '3', '4', NULL),
('12', '22', '4', '3', '4', '2018-02-23', '-25046.8', '0', '0', '3', '4', NULL),
('13', '1', '4', '3', '20812', '2018-02-23', '-2640', '0', '0', '0', 'cash', NULL),
('14', '1', '5', '3', '20818', '2018-02-23', '-180', '0', '0', '0', 'cash', NULL),
('15', '12', '5', '4', '5', '2018-02-23', '36890', '0', '0', '2', '7', NULL),
('16', '12', '6', '3', '70200', '2018-02-23', '10000', '0', '0', '2', '4', NULL),
('17', '22', '5', '4', '5', '2018-02-23', '-30886', '0', '0', '3', '6', NULL);

### Structure of table `3_bom` ###

DROP TABLE IF EXISTS `3_bom`;

CREATE TABLE `3_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `component` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_bom` ###


### Structure of table `3_budget_trans` ###

DROP TABLE IF EXISTS `3_budget_trans`;

CREATE TABLE `3_budget_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `dimension_id` int(11) DEFAULT '0',
  `dimension2_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_budget_trans` ###


### Structure of table `3_chart_class` ###

DROP TABLE IF EXISTS `3_chart_class`;

CREATE TABLE `3_chart_class` (
  `cid` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `class_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_chart_class` ###

INSERT INTO `3_chart_class` VALUES
('1', 'Assets', '1', '0'),
('2', 'Liabilities', '2', '0'),
('4', 'Income', '4', '0'),
('6', 'Expense', '6', '0');

### Structure of table `3_chart_master` ###

DROP TABLE IF EXISTS `3_chart_master`;

CREATE TABLE `3_chart_master` (
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_code2` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_chart_master` ###

INSERT INTO `3_chart_master` VALUES
('001', '', 'lease', '27', '0'),
('10000', '', 'Cash at Bank', '11', '0'),
('10100', '', 'Cash on Hand', '11', '0'),
('10400', '', 'Bank Account', '11', '0'),
('10500', '', 'Petty Cash', '11', '0'),
('11000', '', 'Accounts Receivable', '12', '0'),
('12000', '', 'Inventory Account', '11', '0'),
('15000', '', 'Furniture and Fixtures', '10', '0'),
('15100', '', 'Equipment', '10', '0'),
('15500', '', 'Building', '10', '0'),
('16900', '', 'Land', '10', '0'),
('17000', '', 'Accum. Depreciation - Furniture', '10', '0'),
('17100', '', 'Accum. Depreciation - Equipment', '10', '0'),
('17500', '', 'Accum. Depreciation - Building', '10', '0'),
('19000', '', 'Deposits', '19', '0'),
('19300', '', 'Software Development Costs', '19', '0'),
('20000', '', 'Accounts Payable', '20', '0'),
('23000', '', 'Accrued Expenses', '20', '0'),
('23100', '', 'VAT  Payable', '20', '0'),
('23200', '', 'Wages Payable', '20', '0'),
('23900', '', 'Income Taxes Payable', '20', '0'),
('24200', '', 'Current Portion Long-Term Debt', '20', '0'),
('24800', '', 'Other Current Liabilities', '20', '0'),
('27100', '', 'Deferred Revenue', '27', '0'),
('27400', '', 'Other Long-Term Liabilities', '27', '0'),
('30000', '', 'Equity', '30', '0'),
('35000', '', 'Retained Earnings', '30', '0'),
('40000', '', 'Commission Sales', '40', '0'),
('41000', '', 'Other Commission', '40', '0'),
('41800', '', 'Interest Income', '40', '0'),
('42000', '', 'Commission Income', '40', '0'),
('42100', '', 'Unloading expenses - Commission', '40', '0'),
('42200', '', 'Lorry Cooly - Commission', '40', '0'),
('42300', '', 'Cart cooly - Commission', '40', '0'),
('42400', '', 'Brokerage - commission', '40', '0'),
('43000', '', 'Sales Nattami Cooly', '40', '0'),
('45400', '', 'Finance Charge Income', '40', '0'),
('45500', '', 'Shipping Charges Reimbursed', '40', '0'),
('49000', '', 'Sales Discounts', '40', '0'),
('50000', '', 'Cost of Sales', '50', '0'),
('51000', '', 'Loading charges', '50', '0'),
('51100', '', 'Unloading charges', '50', '0'),
('51200', '', 'Cart cooly', '50', '0'),
('51300', '', 'Lorry cooly', '50', '0'),
('51400', '', 'Nattami cooly', '50', '0'),
('52000', '', 'Commission and Brokerage', '50', '0'),
('58500', '', 'Inventory Adjustments', '50', '0'),
('59500', '', 'Purchase Discounts', '50', '0'),
('60100', '', 'Advertising Expense', '60', '0'),
('62000', '', 'Bank Charges', '60', '0'),
('64000', '', 'Depreciation Expense', '60', '0'),
('65500', '', 'Freight Expense', '60', '0'),
('66500', '', 'Income Tax Expense', '60', '0'),
('67500', '', 'Interest Expense', '60', '0'),
('69000', '', 'Licenses Expense', '60', '0'),
('70000', '', 'Maintenance Expense', '60', '0'),
('70500', '', 'Meals and Entertainment Exp', '60', '0'),
('73500', '', 'Postage Expense', '60', '0'),
('76500', '', 'Telephone Expense', '60', '0'),
('77000', '', 'Salaries Expense', '60', '0'),
('89000', '', 'Other Expense', '60', '0'),
('90000', '', 'Profit/(Loss) for the year', '60', '0');

### Structure of table `3_chart_types` ###

DROP TABLE IF EXISTS `3_chart_types`;

CREATE TABLE `3_chart_types` (
  `id` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `class_id` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '-1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_chart_types` ###

INSERT INTO `3_chart_types` VALUES
('10', 'Fixed Assets', '1', '', '0'),
('11', 'Current Assets', '1', '', '0'),
('12', 'Accounts Receivable', '4', '11', '0'),
('19', 'Other Assets', '1', '', '0'),
('2', 'long Term Liabilities', '2', '', '0'),
('20', 'Current Liabilities', '2', '', '0'),
('27', 'Long Term Liabilities', '2', '', '0'),
('30', 'Equity', '2', '', '0'),
('40', 'Sales', '4', '', '0'),
('50', 'Cost of Goods Sold', '6', '', '0'),
('60', 'Expenses', '6', '', '0');

### Structure of table `3_comments` ###

DROP TABLE IF EXISTS `3_comments`;

CREATE TABLE `3_comments` (
  `type` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_comments` ###

INSERT INTO `3_comments` VALUES
('12', '1', '2018-02-10', 'Cash invoice 5'),
('12', '2', '2018-02-10', 'Cash invoice 6'),
('12', '3', '2018-02-10', 'Cash invoice 7'),
('12', '5', '2018-02-23', 'Cash invoice 13');

### Structure of table `3_credit_status` ###

DROP TABLE IF EXISTS `3_credit_status`;

CREATE TABLE `3_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_credit_status` ###

INSERT INTO `3_credit_status` VALUES
('1', 'Good History', '0', '0'),
('3', 'No more work until payment received', '1', '0'),
('4', 'In liquidation', '1', '0');

### Structure of table `3_crm_categories` ###

DROP TABLE IF EXISTS `3_crm_categories`;

CREATE TABLE `3_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `system` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_crm_categories` ###

INSERT INTO `3_crm_categories` VALUES
('1', 'cust_branch', 'general', 'General', 'General contact data for customer branch (overrides company setting)', '1', '0'),
('2', 'cust_branch', 'invoice', 'Invoices', 'Invoice posting (overrides company setting)', '1', '0'),
('3', 'cust_branch', 'order', 'Orders', 'Order confirmation (overrides company setting)', '1', '0'),
('4', 'cust_branch', 'delivery', 'Deliveries', 'Delivery coordination (overrides company setting)', '1', '0'),
('5', 'customer', 'general', 'General', 'General contact data for customer', '1', '0'),
('6', 'customer', 'order', 'Orders', 'Order confirmation', '1', '0'),
('7', 'customer', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('8', 'customer', 'invoice', 'Invoices', 'Invoice posting', '1', '0'),
('9', 'supplier', 'general', 'General', 'General contact data for supplier', '1', '0'),
('10', 'supplier', 'order', 'Orders', 'Order confirmation', '1', '0'),
('11', 'supplier', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('12', 'supplier', 'invoice', 'Invoices', 'Invoice posting', '1', '0');

### Structure of table `3_crm_contacts` ###

DROP TABLE IF EXISTS `3_crm_contacts`;

CREATE TABLE `3_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT '0' COMMENT 'foreign key to crm_contacts',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `entity_id` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_crm_contacts` ###

INSERT INTO `3_crm_contacts` VALUES
('1', '1', 'supplier', 'general', '1'),
('2', '2', 'cust_branch', 'general', '1'),
('3', '2', 'customer', 'general', '1'),
('4', '3', 'cust_branch', 'general', '2'),
('5', '3', 'customer', 'general', '2'),
('6', '4', 'cust_branch', 'general', '3'),
('7', '4', 'customer', 'general', '3'),
('8', '5', 'cust_branch', 'general', '4'),
('9', '5', 'customer', 'general', '4'),
('10', '6', 'supplier', 'general', '2'),
('11', '7', 'supplier', 'general', '3'),
('12', '8', 'cust_branch', 'general', '5'),
('13', '8', 'customer', 'general', '5'),
('14', '9', 'supplier', 'general', '4'),
('15', '10', 'cust_branch', 'general', '6'),
('16', '10', 'customer', 'general', '6'),
('17', '11', 'supplier', 'general', '5'),
('18', '12', 'supplier', 'general', '6'),
('19', '13', 'cust_branch', 'general', '7'),
('20', '13', 'customer', 'general', '7'),
('21', '14', 'supplier', 'general', '7');

### Structure of table `3_crm_persons` ###

DROP TABLE IF EXISTS `3_crm_persons`;

CREATE TABLE `3_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `name2` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` tinytext COLLATE utf8_unicode_ci,
  `phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone2` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lang` char(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_crm_persons` ###

INSERT INTO `3_crm_persons` VALUES
('1', 'M M Jaffna', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('2', 'A K A S', 'A K A S -Minuwangoda', NULL, 'A K A S \nMinuwangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3', 'B S P', 'B S P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('4', 'PS', 'PS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('5', 'LTC', 'LTC - Rathnapura', NULL, 'LTC \nRathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('6', 'M.C.Jaffna', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('7', 'v s', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('8', 'CASH BUYER', 'CASH BUYER', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('9', 'X', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('10', 'Y', 'Y', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('11', 'VS Jaffna', '', NULL, 'Colombo 02', NULL, NULL, NULL, NULL, NULL, '', '0'),
('12', 'VS Jaffna', '', NULL, 'Colombo 02', NULL, NULL, NULL, NULL, NULL, '', '0'),
('13', 'Cash', 'Cash', NULL, 'Cash', NULL, NULL, NULL, NULL, NULL, '', '0'),
('14', 'S JAFFNA', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0');

### Structure of table `3_currencies` ###

DROP TABLE IF EXISTS `3_currencies`;

CREATE TABLE `3_currencies` (
  `currency` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `auto_update` tinyint(1) NOT NULL DEFAULT '1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_currencies` ###

INSERT INTO `3_currencies` VALUES
('CA Dollars', 'CAD', '$', 'Canada', 'Cents', '1', '0'),
('Euro', 'EUR', '?', 'Europe', 'Cents', '1', '0'),
('Pounds', 'GBP', '?', 'England', 'Pence', '1', '0'),
('Sri Lanka Rupees', 'LKR', 'Rs.', 'Sri Lanka', 'Cents', '1', '0'),
('US Dollars', 'USD', '$', 'United States', 'Cents', '1', '0');

### Structure of table `3_cust_allocations` ###

DROP TABLE IF EXISTS `3_cust_allocations`;

CREATE TABLE `3_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_cust_allocations` ###

INSERT INTO `3_cust_allocations` VALUES
('3', '4', '17340', '2018-02-10', '3', '12', '7', '10'),
('4', '1', '14840', '2018-02-10', '2', '12', '6', '10'),
('5', '6', '8720', '0000-00-00', '4', '12', '8', '10'),
('6', '6', '12790', '0000-00-00', '4', '12', '9', '10'),
('7', '6', '8140', '0000-00-00', '4', '12', '10', '10'),
('8', '6', '16940', '0000-00-00', '4', '12', '11', '10'),
('9', '7', '36890', '2018-02-23', '5', '12', '13', '10'),
('10', '4', '10000', '0000-00-00', '6', '12', '14', '10');

### Structure of table `3_cust_branch` ###

DROP TABLE IF EXISTS `3_cust_branch`;

CREATE TABLE `3_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `br_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `branch_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `br_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT '0',
  `default_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `receivables_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT '1',
  `br_post_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT '0',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `bank_account` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_cust_branch` ###

INSERT INTO `3_cust_branch` VALUES
('1', '1', 'A K A S -Minuwangoda', 'A K A S', 'A K A S \nMinuwangoda', '1', '1', 'DEF', '2', '', '49000', '11000', '49000', '1', 'A K A S \nMinuwangoda', '0', '', NULL, '0'),
('2', '2', 'B S P', 'B S P', '', '1', '1', 'DEF', '2', '', '49000', '11000', '49000', '1', '', '0', '', NULL, '0'),
('3', '3', 'PS', 'PS', '', '1', '1', 'DEF', '2', '', '49000', '11000', '49000', '1', '', '0', '', NULL, '0'),
('4', '4', 'LTC - Rathnapura', 'LTC', 'LTC \nRathnapura', '1', '1', 'DEF', '2', '', '49000', '11000', '49000', '1', 'LTC \nRathnapura', '0', '', NULL, '0'),
('5', '5', 'CASH BUYER', 'CASH BUYER', '', '1', '1', 'DEF', '1', '', '49000', '11000', '49000', '1', '', '0', '', NULL, '0'),
('6', '6', 'Y', 'Y', 'Colombo', '1', '1', 'DEF', '2', '', '49000', '11000', '49000', '1', 'Colombo', '0', '', NULL, '0'),
('7', '7', 'Cash', 'Cash', 'Cash', '1', '1', 'DEF', '2', '', '49000', '11000', '49000', '1', 'Cash', '0', '', NULL, '0');

### Structure of table `3_debtor_trans` ###

DROP TABLE IF EXISTS `3_debtor_trans`;

CREATE TABLE `3_debtor_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `version` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `debtor_no` int(11) unsigned NOT NULL DEFAULT '0',
  `branch_code` int(11) NOT NULL DEFAULT '-1',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT '0',
  `order_` int(11) NOT NULL DEFAULT '0',
  `ov_amount` double NOT NULL DEFAULT '0',
  `ov_gst` double NOT NULL DEFAULT '0',
  `ov_freight` double NOT NULL DEFAULT '0',
  `ov_freight_tax` double NOT NULL DEFAULT '0',
  `ov_discount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  `ship_via` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`type`,`trans_no`,`debtor_no`),
  KEY `debtor_no` (`debtor_no`,`branch_code`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_debtor_trans` ###

INSERT INTO `3_debtor_trans` VALUES
('1', '10', '2', '4', '4', '2018-02-09', '2018-02-10', '1', '1', '1', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '2', '4', '1'),
('2', '10', '2', '1', '1', '2018-02-09', '2018-02-10', '2', '1', '2', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '2', '4', '1'),
('3', '10', '0', '2', '2', '2018-02-09', '2018-03-17', '3', '1', '3', '14550', '0', '0', '0', '0', '0', '14550', '1', '1', '1', '2', '1', '1'),
('4', '10', '0', '3', '3', '2018-02-09', '2018-03-17', '4', '1', '4', '42110', '0', '0', '0', '0', '0', '42110', '1', '1', '1', '2', '1', '1'),
('5', '10', '2', '1', '1', '2018-02-10', '2018-02-10', '5', '1', '5', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '2', '4', '1'),
('6', '10', '0', '1', '1', '2018-02-10', '2018-02-10', '5', '1', '6', '14840', '0', '0', '0', '0', '14840', '0', '1', '1', '1', '2', '4', '1'),
('7', '10', '0', '4', '4', '2018-02-10', '2018-02-10', '6', '1', '7', '17340', '0', '0', '0', '0', '17340', '0', '1', '1', '1', '2', '4', '1'),
('8', '10', '0', '6', '6', '2018-02-23', '2018-03-17', '7', '2', '8', '8720', '0', '0', '0', '0', '0', '8720', '1', '1', '4', '5', '1', '0'),
('9', '10', '0', '6', '6', '2018-02-22', '2018-03-17', '8', '2', '9', '12790', '0', '0', '0', '0', '12790', '0', '1', '1', '4', '5', '1', '0'),
('10', '10', '0', '6', '6', '2018-02-23', '2018-03-17', '9', '2', '10', '8140', '0', '0', '0', '0', '8140', '0', '1', '1', '4', '5', '1', '0'),
('11', '10', '0', '6', '6', '2018-02-23', '2018-03-17', '10', '2', '11', '16940', '0', '0', '0', '0', '16940', '0', '1', '1', '4', '5', '1', '0'),
('12', '10', '0', '6', '6', '2018-02-23', '2018-03-17', '11', '2', '12', '200', '0', '0', '0', '0', '0', '200', '1', '1', '0', '0', '1', '0'),
('13', '10', '0', '7', '7', '2018-02-23', '2018-02-23', '70257', '2', '13', '36890', '0', '0', '0', '0', '36890', '0', '1', '1', '6', '7', '4', '0'),
('14', '10', '0', '4', '4', '2018-02-23', '2018-03-17', '70200', '1', '14', '12660', '0', '0', '0', '0', '10000', '0', '1', '1', '6', '7', '1', '1'),
('1', '12', '2', '1', '1', '2018-02-10', '0000-00-00', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', NULL, '0'),
('2', '12', '0', '1', '1', '2018-02-10', '0000-00-00', '2', '0', '0', '14840', '0', '0', '0', '0', '14840', '0', '1', '0', '0', '0', NULL, '0'),
('3', '12', '0', '4', '4', '2018-02-10', '0000-00-00', '3', '0', '0', '17340', '0', '0', '0', '0', '17340', '0', '1', '0', '0', '0', NULL, '0'),
('4', '12', '0', '6', '6', '2018-02-23', '0000-00-00', '4', '0', '0', '46590', '0', '0', '0', '0', '46590', '0', '1', '0', '0', '0', NULL, '0'),
('5', '12', '0', '7', '7', '2018-02-23', '0000-00-00', '5', '0', '0', '36890', '0', '0', '0', '0', '36890', '0', '1', '0', '0', '0', NULL, '0'),
('6', '12', '0', '4', '4', '2018-02-23', '0000-00-00', '70200', '0', '0', '10000', '0', '0', '0', '0', '10000', '0', '1', '0', '0', '0', NULL, '0'),
('1', '13', '3', '4', '4', '2018-02-09', '2018-02-10', 'auto', '1', '1', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '2', '4', '1'),
('2', '13', '3', '1', '1', '2018-02-09', '2018-02-10', 'auto', '1', '2', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '2', '4', '1'),
('3', '13', '2', '2', '2', '2018-02-09', '2018-03-17', 'auto', '1', '3', '14550', '0', '0', '0', '0', '0', '0', '1', '1', '1', '2', '1', '1'),
('4', '13', '2', '3', '3', '2018-02-09', '2018-03-17', 'auto', '1', '4', '42110', '0', '0', '0', '0', '0', '0', '1', '1', '1', '2', '1', '1'),
('5', '13', '3', '1', '1', '2018-02-10', '2018-02-10', 'auto', '1', '5', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '2', '4', '1'),
('6', '13', '1', '1', '1', '2018-02-10', '2018-02-10', 'auto', '1', '6', '14840', '0', '0', '0', '0', '0', '0', '1', '1', '1', '2', '4', '1'),
('7', '13', '1', '4', '4', '2018-02-10', '2018-02-10', 'auto', '1', '7', '17340', '0', '0', '0', '0', '0', '0', '1', '1', '1', '2', '4', '1'),
('8', '13', '2', '6', '6', '2018-02-23', '2018-03-17', 'auto', '2', '8', '8720', '0', '0', '0', '0', '0', '0', '1', '1', '4', '5', '1', '0'),
('9', '13', '1', '6', '6', '2018-02-22', '2018-03-17', 'auto', '2', '9', '12790', '0', '0', '0', '0', '0', '0', '1', '1', '4', '5', '1', '0'),
('10', '13', '1', '6', '6', '2018-02-23', '2018-03-17', 'auto', '2', '10', '8140', '0', '0', '0', '0', '0', '0', '1', '1', '4', '5', '1', '0'),
('11', '13', '1', '6', '6', '2018-02-23', '2018-03-17', 'auto', '2', '11', '16940', '0', '0', '0', '0', '0', '0', '1', '1', '4', '5', '1', '0'),
('12', '13', '2', '6', '6', '2018-02-23', '2018-03-17', 'auto', '2', '12', '200', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('13', '13', '1', '7', '7', '2018-02-23', '2018-02-23', 'auto', '2', '13', '36890', '0', '0', '0', '0', '0', '0', '1', '1', '6', '7', '4', '0'),
('14', '13', '1', '4', '4', '2018-02-23', '2018-03-17', 'auto', '1', '14', '12660', '0', '0', '0', '0', '0', '0', '1', '1', '6', '7', '1', '1');

### Structure of table `3_debtor_trans_details` ###

DROP TABLE IF EXISTS `3_debtor_trans_details`;

CREATE TABLE `3_debtor_trans_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_trans_no` int(11) DEFAULT NULL,
  `debtor_trans_type` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `unit_price` double NOT NULL DEFAULT '0',
  `unit_tax` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `discount_percent` double NOT NULL DEFAULT '0',
  `standard_cost` double NOT NULL DEFAULT '0',
  `qty_done` double NOT NULL DEFAULT '0',
  `src_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`debtor_trans_type`,`debtor_trans_no`),
  KEY `src_id` (`src_id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_debtor_trans_details` ###

INSERT INTO `3_debtor_trans_details` VALUES
('1', '1', '13', 'RO', 'Red Onion', '0', '0', '0', '0', '0', '46.8', '0'),
('2', '1', '13', 'NTcooly', 'Sales Nattami Cooly', '0', '0', '0', '0', '0', '1', '0'),
('3', '1', '10', 'RO', 'Red Onion', '0', '0', '0', '0', '0', '0', '0'),
('4', '1', '10', 'NTcooly', 'Sales Nattami Cooly', '0', '0', '0', '0', '0', '0', '0'),
('5', '2', '13', 'RO', 'Red Onion', '0', '0', '0', '0', '0', '47.8', '0'),
('6', '2', '13', 'NTcooly', 'Sales Nattami Cooly', '0', '0', '0', '0', '0', '1', '0'),
('7', '2', '10', 'RO', 'Red Onion', '0', '0', '0', '0', '0', '0', '0'),
('8', '2', '10', 'NTcooly', 'Sales Nattami Cooly', '0', '0', '0', '0', '0', '0', '0'),
('9', '3', '13', 'RO', 'Red Onion', '320', '0', '45.4', '0', '-1616.75206059', '45.4', '5'),
('10', '3', '13', 'NTcooly', 'Sales Nattami Cooly', '22', '0', '1', '0', '0', '1', '6'),
('11', '3', '10', 'RO', 'Red Onion', '320', '0', '45.4', '0', '-1616.75206059', '0', '9'),
('12', '3', '10', 'NTcooly', 'Sales Nattami Cooly', '22', '0', '1', '0', '0', '0', '10'),
('13', '4', '13', 'RO', 'Red Onion', '320', '0', '131.4', '0', '-1616.75206059', '131.4', '7'),
('14', '4', '13', 'NTcooly', 'Sales Nattami Cooly', '62', '0', '1', '0', '0', '1', '8'),
('15', '4', '10', 'RO', 'Red Onion', '320', '0', '131.4', '0', '-1616.75206059', '0', '13'),
('16', '4', '10', 'NTcooly', 'Sales Nattami Cooly', '62', '0', '1', '0', '0', '0', '14'),
('17', '5', '13', 'RO', 'Red Onion', '0', '0', '0', '0', '0', '47.8', '0'),
('18', '5', '13', 'NTcooly', 'Sales Nattami Cooly', '0', '0', '0', '0', '0', '1', '0'),
('19', '5', '10', 'RO', 'Red Onion', '0', '0', '0', '0', '0', '0', '0'),
('20', '5', '10', 'NTcooly', 'Sales Nattami Cooly', '0', '0', '0', '0', '0', '0', '0'),
('21', '6', '13', 'RO', 'Red Onion', '310', '0', '47.8', '0', '-1616.75206059', '47.8', '11'),
('22', '6', '13', 'NTcooly', 'Sales Nattami Cooly', '22', '0', '1', '0', '0', '1', '12'),
('23', '6', '10', 'RO', 'Red Onion', '310', '0', '47.8', '0', '-1616.75206059', '0', '21'),
('24', '6', '10', 'NTcooly', 'Sales Nattami Cooly', '22', '0', '1', '0', '0', '0', '22'),
('25', '7', '13', 'RO', 'Red Onion', '370', '0', '46.8', '0', '-1616.75206059', '46.8', '13'),
('26', '7', '13', 'NTcooly', 'Sales Nattami Cooly', '24', '0', '1', '0', '0', '1', '14'),
('27', '7', '10', 'RO', 'Red Onion', '370', '0', '46.8', '0', '-1616.75206059', '0', '25'),
('28', '7', '10', 'NTcooly', 'Sales Nattami Cooly', '24', '0', '1', '0', '0', '0', '26'),
('29', '8', '13', 'RO', 'Red Onion', '230', '0', '37.8', '0', '-1658.65019639', '37.8', '15'),
('30', '8', '13', 'NTcooly', 'Sales Nattami Cooly', '26', '0', '1', '0', '0', '1', '16'),
('31', '8', '10', 'RO', 'Red Onion', '230', '0', '37.8', '0', '-1658.65019639', '0', '29'),
('32', '8', '10', 'NTcooly', 'Sales Nattami Cooly', '26', '0', '1', '0', '0', '0', '30'),
('33', '9', '13', 'RO', 'Red Onion', '180', '0', '70.8', '0', '-1658.65019639', '70.8', '17'),
('34', '9', '13', 'NTcooly', 'Sales Nattami Cooly', '46', '0', '1', '0', '0', '1', '18'),
('35', '9', '10', 'RO', 'Red Onion', '180', '0', '70.8', '0', '-1658.65019639', '0', '33'),
('36', '9', '10', 'NTcooly', 'Sales Nattami Cooly', '46', '0', '1', '0', '0', '0', '34'),
('37', '10', '13', 'RO', 'Red Onion', '200', '0', '40.6', '0', '-1658.65019639', '40.6', '19'),
('38', '10', '13', 'NTcooly', 'Sales Nattami Cooly', '20', '0', '1', '0', '0', '1', '20'),
('39', '10', '10', 'RO', 'Red Onion', '200', '0', '40.6', '0', '-1658.65019639', '0', '37'),
('40', '10', '10', 'NTcooly', 'Sales Nattami Cooly', '20', '0', '1', '0', '0', '0', '38'),
('41', '11', '13', 'RO', 'Red Onion', '220', '0', '76.8', '0', '-1658.65019639', '76.8', '21'),
('42', '11', '13', 'NTcooly', 'Sales Nattami Cooly', '44', '0', '1', '0', '0', '1', '22'),
('43', '11', '10', 'RO', 'Red Onion', '220', '0', '76.8', '0', '-1658.65019639', '0', '41'),
('44', '11', '10', 'NTcooly', 'Sales Nattami Cooly', '44', '0', '1', '0', '0', '0', '42'),
('45', '12', '13', 'ROnion', 'Red Onion', '25', '0', '8', '0', '198.068669527', '8', '23'),
('46', '12', '10', 'ROnion', 'Red Onion', '25', '0', '8', '0', '198.068669527', '0', '45'),
('47', '13', '13', 'ROnion', 'Red Onion', '100', '0', '367.1', '0', '137.835824577', '367.1', '24'),
('48', '13', '13', 'NTcooly', 'Sales Nattami Cooly', '180', '0', '1', '0', '0', '1', '25'),
('49', '13', '10', 'ROnion', 'Red Onion', '100', '0', '367.1', '0', '137.835824577', '0', '47'),
('50', '13', '10', 'NTcooly', 'Sales Nattami Cooly', '180', '0', '1', '0', '0', '0', '48'),
('51', '14', '13', 'ROnion', 'Red Onion', '105', '0', '120', '0', '137.835824577', '120', '26'),
('52', '14', '13', 'NTcooly', 'Sales Nattami Cooly', '60', '0', '1', '0', '0', '1', '27'),
('53', '14', '10', 'ROnion', 'Red Onion', '105', '0', '120', '0', '137.835824577', '0', '51'),
('54', '14', '10', 'NTcooly', 'Sales Nattami Cooly', '60', '0', '1', '0', '0', '0', '52');

### Structure of table `3_debtors_master` ###

DROP TABLE IF EXISTS `3_debtors_master`;

CREATE TABLE `3_debtors_master` (
  `debtor_no` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `debtor_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `address` tinytext COLLATE utf8_unicode_ci,
  `tax_id` varchar(55) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type` int(11) NOT NULL DEFAULT '1',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `credit_status` int(11) NOT NULL DEFAULT '0',
  `payment_terms` int(11) DEFAULT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `pymt_discount` double NOT NULL DEFAULT '0',
  `credit_limit` float NOT NULL DEFAULT '1000',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`debtor_no`),
  UNIQUE KEY `debtor_ref` (`debtor_ref`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_debtors_master` ###

INSERT INTO `3_debtors_master` VALUES
('1', 'A K A S -Minuwangoda', 'A K A S', 'A K A S \nMinuwangoda', '', 'LKR', '1', '0', '0', '1', '1', '0', '0', '1000', '', '0'),
('2', 'B S P', 'B S P', NULL, '', 'LKR', '1', '0', '0', '1', '1', '0', '0', '1000', '', '0'),
('3', 'PS', 'PS', NULL, '', 'LKR', '1', '0', '0', '1', '1', '0', '0', '1000', '', '0'),
('4', 'LTC - Rathnapura', 'LTC', 'LTC \nRathnapura', '', 'LKR', '1', '0', '0', '1', '1', '0', '0', '100000', '', '0'),
('5', 'CASH BUYER', 'CASH BUYER', NULL, '', 'LKR', '1', '0', '0', '1', '4', '0', '0', '1000000', '', '0'),
('6', 'Y', 'Y', 'Colombo', '', 'LKR', '2', '0', '0', '1', '1', '0', '0', '1000000', '', '0'),
('7', 'Cash', 'Cash', 'Cash', '', 'LKR', '2', '0', '0', '1', '4', '0', '0', '1000000', '', '0');

### Structure of table `3_dimensions` ###

DROP TABLE IF EXISTS `3_dimensions`;

CREATE TABLE `3_dimensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_` tinyint(1) NOT NULL DEFAULT '1',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  KEY `date_` (`date_`),
  KEY `due_date` (`due_date`),
  KEY `type_` (`type_`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_dimensions` ###

INSERT INTO `3_dimensions` VALUES
('1', '1', 'MM Jaffna', '1', '1', '2018-02-02', '2018-02-22'),
('2', '2', 'GRN10843', '2', '0', '2018-02-02', '2018-02-22'),
('3', '10868', 'V S JAFFNA', '2', '0', '2018-02-19', '2018-02-19'),
('4', '3', 'X', '1', '0', '2018-02-22', '2018-03-14'),
('5', '4', '10844', '2', '0', '2018-02-22', '2018-03-14'),
('6', '5', 'VS Jaffna', '1', '0', '2018-02-23', '2018-03-15'),
('7', '6', '10868', '2', '0', '2018-02-23', '2018-03-15'),
('8', '10883', 'S JAFFNA', '1', '0', '2018-02-23', '2018-03-15'),
('9', '8', '10883', '2', '0', '2018-02-23', '2018-03-15');

### Structure of table `3_exchange_rates` ###

DROP TABLE IF EXISTS `3_exchange_rates`;

CREATE TABLE `3_exchange_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rate_buy` double NOT NULL DEFAULT '0',
  `rate_sell` double NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `curr_code` (`curr_code`,`date_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_exchange_rates` ###


### Structure of table `3_fiscal_year` ###

DROP TABLE IF EXISTS `3_fiscal_year`;

CREATE TABLE `3_fiscal_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `begin` date DEFAULT '0000-00-00',
  `end` date DEFAULT '0000-00-00',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `begin` (`begin`),
  UNIQUE KEY `end` (`end`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_fiscal_year` ###

INSERT INTO `3_fiscal_year` VALUES
('9', '2016-01-01', '2016-12-31', '0'),
('10', '2017-01-01', '2017-12-31', '0'),
('11', '2018-01-01', '2018-12-31', '0');

### Structure of table `3_gl_trans` ###

DROP TABLE IF EXISTS `3_gl_trans`;

CREATE TABLE `3_gl_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT '0',
  `type_no` int(11) NOT NULL DEFAULT '0',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `amount` double NOT NULL DEFAULT '0',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `dimension_id` (`dimension_id`),
  KEY `dimension2_id` (`dimension2_id`),
  KEY `tran_date` (`tran_date`),
  KEY `account_and_tran_date` (`account`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=239 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_gl_trans` ###

INSERT INTO `3_gl_trans` VALUES
('1', '20', '1', '2018-02-08', '20000', '', '0', '0', '0', '3', '1'),
('2', '20', '1', '2018-02-08', '40000', '', '0', '0', '0', NULL, NULL),
('3', '20', '2', '2018-02-08', '20000', '', '0', '0', '0', '3', '1'),
('4', '20', '2', '2018-02-08', '42200', '', '0', '1', '2', NULL, NULL),
('5', '20', '2', '2018-02-08', '40000', '', '0', '0', '0', NULL, NULL),
('6', '20', '3', '2018-02-08', '20000', '', '0', '0', '0', '3', '1'),
('7', '20', '3', '2018-02-08', '40000', '', '0', '1', '2', NULL, NULL),
('8', '20', '3', '2018-02-08', '42200', '', '0', '1', '2', NULL, NULL),
('9', '20', '3', '2018-02-08', '42100', '', '0', '1', '2', NULL, NULL),
('10', '20', '3', '2018-02-08', '42300', '', '0', '1', '2', NULL, NULL),
('11', '20', '3', '2018-02-08', '42400', '', '0', '1', '2', NULL, NULL),
('12', '20', '3', '2018-02-08', '40000', '', '0', '1', '2', NULL, NULL),
('13', '20', '4', '2018-02-08', '20000', '', '0', '0', '0', '3', '1'),
('14', '20', '4', '2018-02-08', '42200', '', '0', '0', '0', NULL, NULL),
('15', '20', '4', '2018-02-08', '42100', '', '0', '0', '0', NULL, NULL),
('16', '20', '4', '2018-02-08', '42300', '', '0', '0', '0', NULL, NULL),
('17', '20', '4', '2018-02-08', '42400', '', '0', '0', '0', NULL, NULL),
('18', '20', '4', '2018-02-08', '42000', '', '0', '0', '0', NULL, NULL),
('19', '20', '4', '2018-02-08', '42000', '', '0', '0', '0', NULL, NULL),
('20', '20', '5', '2018-02-08', '20000', '', '0', '0', '0', '3', '1'),
('21', '20', '5', '2018-02-08', '42200', '', '0', '0', '0', NULL, NULL),
('22', '20', '5', '2018-02-08', '42100', '', '0', '0', '0', NULL, NULL),
('23', '20', '5', '2018-02-08', '42300', '', '0', '0', '0', NULL, NULL),
('24', '20', '5', '2018-02-08', '42400', '', '0', '0', '0', NULL, NULL),
('25', '20', '5', '2018-02-08', '42000', '', '0', '0', '0', NULL, NULL),
('26', '20', '5', '2018-02-08', '42000', '', '0', '1', '2', NULL, NULL),
('27', '20', '6', '2018-02-08', '20000', '', '0', '0', '0', '3', '1'),
('28', '20', '6', '2018-02-08', '42000', '', '0', '1', '2', NULL, NULL),
('29', '20', '7', '2018-02-08', '20000', '', '0', '0', '0', '3', '1'),
('30', '20', '7', '2018-02-08', '42000', '', '0', '0', '0', NULL, NULL),
('31', '20', '8', '2018-02-08', '20000', '', '0', '0', '0', '3', '1'),
('32', '20', '8', '2018-02-08', '41000', '', '0', '0', '0', NULL, NULL),
('33', '20', '9', '2018-02-08', '20000', '', '0', '0', '0', '3', '1'),
('34', '20', '9', '2018-02-08', '42000', '', '0', '1', '2', NULL, NULL),
('35', '20', '9', '2018-02-08', '41000', '', '0', '1', '2', NULL, NULL),
('36', '20', '10', '2018-02-09', '20000', '', '0', '0', '0', '3', '1'),
('37', '20', '10', '2018-02-09', '42000', 'Sales Commission Income', '0', '1', '2', NULL, NULL),
('38', '20', '10', '2018-02-09', '42100', 'Sales Commission Income', '0', '1', '2', NULL, NULL),
('39', '20', '10', '2018-02-09', '42200', 'Lorry Cooly - Commission', '0', '1', '2', NULL, NULL),
('40', '20', '10', '2018-02-09', '42300', 'Lorry Cooly - Commission', '0', '1', '2', NULL, NULL),
('41', '20', '10', '2018-02-09', '42400', 'Lorry Cooly - Commission', '0', '1', '2', NULL, NULL),
('42', '20', '10', '2018-02-09', '41000', '', '0', '0', '0', NULL, NULL),
('43', '10', '1', '2018-02-09', '40000', '', '0', '1', '2', NULL, NULL),
('44', '10', '1', '2018-02-09', '40000', '', '0', '1', '2', NULL, NULL),
('45', '10', '1', '2018-02-09', '11000', '', '0', '0', '0', '2', '4'),
('46', '10', '2', '2018-02-09', '40000', '', '0', '1', '2', NULL, NULL),
('47', '10', '2', '2018-02-09', '40000', '', '0', '1', '2', NULL, NULL),
('48', '10', '2', '2018-02-09', '12000', '', '0', '0', '0', '2', '1'),
('49', '10', '3', '2018-02-09', '40000', '', '0', '1', '2', NULL, NULL),
('50', '10', '3', '2018-02-09', '40000', '', '0', '1', '2', NULL, NULL),
('51', '10', '3', '2018-02-09', '11000', '', '0', '0', '0', '2', '2'),
('52', '10', '4', '2018-02-09', '40000', '', '0', '1', '2', NULL, NULL),
('53', '10', '4', '2018-02-09', '40000', '', '0', '1', '2', NULL, NULL),
('54', '10', '4', '2018-02-09', '11000', '', '0', '0', '0', '2', '3'),
('55', '2', '1', '2018-01-01', '35000', '', '-10000', '0', '0', NULL, NULL),
('56', '2', '1', '2018-01-01', '10500', '', '10000', '0', '0', NULL, NULL),
('57', '1', '1', '2018-02-09', '51300', 'Lorry cooly', '1020', '1', '2', NULL, NULL),
('58', '1', '1', '2018-02-09', '51200', 'Cart  cooly', '90', '1', '2', NULL, NULL),
('59', '1', '1', '2018-02-09', '51400', 'Nattamy  cooly', '90', '1', '2', NULL, NULL),
('60', '1', '1', '2018-02-09', '10500', '', '-1200', '0', '0', NULL, NULL),
('61', '10', '4', '2018-02-09', '41000', '', '-42048', '1', '2', NULL, NULL),
('62', '10', '4', '2018-02-09', '43000', '', '-62', '1', '2', NULL, NULL),
('63', '10', '4', '2018-02-09', '11000', '', '42110', '0', '0', '2', '3'),
('64', '10', '2', '2018-02-09', '41000', '', '0', '1', '2', NULL, NULL),
('65', '10', '2', '2018-02-09', '43000', '', '0', '1', '2', NULL, NULL),
('66', '10', '2', '2018-02-09', '12000', '', '0', '0', '0', '2', '1'),
('67', '10', '3', '2018-02-09', '41000', '', '-14528', '1', '2', NULL, NULL),
('68', '10', '3', '2018-02-09', '43000', '', '-22', '1', '2', NULL, NULL),
('69', '10', '3', '2018-02-09', '11000', '', '14550', '0', '0', '2', '2'),
('70', '10', '1', '2018-02-09', '41000', '', '0', '1', '2', NULL, NULL),
('71', '10', '1', '2018-02-09', '43000', '', '0', '1', '2', NULL, NULL),
('72', '10', '1', '2018-02-09', '11000', '', '0', '0', '0', '2', '4'),
('73', '10', '1', '2018-02-09', '', '', '0', '1', '2', NULL, NULL),
('74', '10', '1', '2018-02-09', '', '', '0', '1', '2', NULL, NULL),
('75', '10', '1', '2018-02-09', '11000', '', '0', '0', '0', '2', '4'),
('76', '10', '1', '2018-02-09', '', '', '0', '1', '2', NULL, NULL),
('77', '10', '1', '2018-02-09', '', '', '0', '1', '2', NULL, NULL),
('78', '10', '1', '2018-02-09', '11000', '', '0', '0', '0', '2', '4'),
('79', '10', '1', '2018-02-09', '', '', '0', '1', '2', NULL, NULL),
('80', '10', '1', '2018-02-09', '', '', '0', '1', '2', NULL, NULL),
('81', '10', '1', '2018-02-09', '11000', '', '0', '0', '0', '2', '4'),
('82', '10', '2', '2018-02-09', '', '', '0', '1', '2', NULL, NULL),
('83', '10', '2', '2018-02-09', '', '', '0', '1', '2', NULL, NULL),
('84', '10', '2', '2018-02-09', '12000', '', '0', '0', '0', '2', '1'),
('85', '10', '5', '2018-02-10', '41000', '', '0', '1', '2', NULL, NULL),
('86', '10', '5', '2018-02-10', '43000', '', '0', '1', '2', NULL, NULL),
('87', '10', '5', '2018-02-10', '12000', '', '0', '0', '0', '2', '1'),
('88', '12', '1', '2018-02-10', '10100', '', '0', '0', '0', NULL, NULL),
('89', '12', '1', '2018-02-10', '12000', '', '0', '0', '0', '2', '1'),
('90', '10', '5', '2018-02-10', '41000', '', '0', '1', '2', NULL, NULL),
('91', '10', '5', '2018-02-10', '43000', '', '0', '1', '2', NULL, NULL),
('92', '10', '5', '2018-02-10', '11000', '', '0', '0', '0', '2', '1'),
('93', '10', '6', '2018-02-10', '41000', '', '-14818', '1', '2', NULL, NULL),
('94', '10', '6', '2018-02-10', '43000', '', '-22', '1', '2', NULL, NULL),
('95', '10', '6', '2018-02-10', '11000', '', '14840', '0', '0', '2', '1'),
('96', '12', '2', '2018-02-10', '10100', '', '14840', '0', '0', NULL, NULL),
('97', '12', '2', '2018-02-10', '11000', '', '-14840', '0', '0', '2', '1'),
('98', '10', '7', '2018-02-10', '41000', '', '-17316', '1', '2', NULL, NULL),
('99', '10', '7', '2018-02-10', '43000', '', '-24', '1', '2', NULL, NULL),
('100', '10', '7', '2018-02-10', '11000', '', '17340', '0', '0', '2', '4'),
('101', '12', '3', '2018-02-10', '10100', '', '17340', '0', '0', NULL, NULL),
('102', '12', '3', '2018-02-10', '11000', '', '-17340', '0', '0', '2', '4'),
('103', '20', '11', '2018-02-09', '20000', '', '0', '0', '0', '3', '1'),
('104', '20', '11', '2018-02-09', '42000', 'Sales Commission Income', '0', '0', '0', NULL, NULL),
('105', '20', '11', '2018-02-09', '42100', 'Sales Commission Income', '0', '0', '0', NULL, NULL),
('106', '20', '11', '2018-02-09', '42200', 'Lorry Cooly - Commission', '0', '0', '0', NULL, NULL),
('107', '20', '11', '2018-02-09', '42300', 'Lorry Cooly - Commission', '0', '0', '0', NULL, NULL),
('108', '20', '11', '2018-02-09', '42400', 'Lorry Cooly - Commission', '0', '0', '0', NULL, NULL),
('109', '20', '11', '2018-02-09', '41000', '', '0', '1', '2', NULL, NULL),
('110', '20', '12', '2018-02-09', '20000', '', '-81915.6', '0', '0', '3', '1'),
('111', '20', '12', '2018-02-09', '42000', 'Sales Commission Income', '-5306.4', '1', '2', NULL, NULL),
('112', '20', '12', '2018-02-09', '42100', 'Sales Commission Income', '-90', '1', '2', NULL, NULL),
('113', '20', '12', '2018-02-09', '42200', 'Lorry Cooly - Commission', '-1020', '1', '2', NULL, NULL),
('114', '20', '12', '2018-02-09', '42300', 'Lorry Cooly - Commission', '-90', '1', '2', NULL, NULL),
('115', '20', '12', '2018-02-09', '42400', 'Lorry Cooly - Commission', '-18', '1', '2', NULL, NULL),
('116', '20', '12', '2018-02-09', '41000', '', '88440', '1', '2', NULL, NULL),
('117', '1', '2', '2018-02-13', '20000', '', '20000', '1', '2', '3', '1'),
('118', '1', '2', '2018-02-13', '10100', '', '-20000', '0', '0', NULL, NULL),
('119', '1', '3', '2018-02-23', '51300', 'Lorry Cooly- 10844', '1020', '4', '5', NULL, NULL),
('120', '1', '3', '2018-02-23', '51200', 'Crat Cooly', '90', '4', '5', NULL, NULL),
('121', '1', '3', '2018-02-23', '51400', 'Nattami Cooly', '90', '4', '5', NULL, NULL),
('122', '1', '3', '2018-02-23', '10500', '', '-1200', '0', '0', NULL, NULL),
('123', '10', '8', '2018-02-23', '41000', '', '0', '4', '5', NULL, NULL),
('124', '10', '8', '2018-02-23', '43000', '', '0', '4', '5', NULL, NULL),
('125', '10', '8', '2018-02-23', '11000', '', '0', '0', '0', '2', '6'),
('126', '10', '9', '2018-02-22', '41000', '', '-12744', '4', '5', NULL, NULL),
('127', '10', '9', '2018-02-22', '43000', '', '-46', '4', '5', NULL, NULL),
('128', '10', '9', '2018-02-22', '11000', '', '12790', '0', '0', '2', '6'),
('129', '10', '10', '2018-02-23', '41000', '', '-8120', '4', '5', NULL, NULL),
('130', '10', '10', '2018-02-23', '43000', '', '-20', '4', '5', NULL, NULL),
('131', '10', '10', '2018-02-23', '11000', '', '8140', '0', '0', '2', '6'),
('132', '10', '11', '2018-02-23', '41000', '', '-16896', '4', '5', NULL, NULL),
('133', '10', '11', '2018-02-23', '43000', '', '-44', '4', '5', NULL, NULL),
('134', '10', '11', '2018-02-23', '11000', '', '16940', '0', '0', '2', '6'),
('135', '20', '13', '2018-02-22', '20000', '', '0', '0', '0', '3', '4'),
('136', '20', '13', '2018-02-22', '41000', '', '0', '4', '5', NULL, NULL),
('137', '20', '14', '2018-02-22', '20000', '', '0', '0', '0', '3', '4'),
('138', '20', '14', '2018-02-22', '41000', '', '0', '4', '5', NULL, NULL),
('139', '20', '15', '2018-02-22', '20000', '', '0', '0', '0', '3', '4'),
('140', '20', '15', '2018-02-22', '42000', 'Sales Commission Income', '0', '4', '5', NULL, NULL),
('141', '20', '15', '2018-02-22', '42100', 'Sales Commission Income', '0', '4', '5', NULL, NULL),
('142', '20', '15', '2018-02-22', '42200', 'Lorry Cooly - Commission', '0', '4', '5', NULL, NULL),
('143', '20', '15', '2018-02-22', '42400', 'Sales Commission Income', '0', '4', '5', NULL, NULL),
('144', '20', '16', '2018-02-22', '20000', '', '0', '0', '0', '3', '4'),
('145', '20', '16', '2018-02-22', '42000', 'Sales Commission Income', '0', '4', '5', NULL, NULL),
('146', '20', '16', '2018-02-22', '42100', 'Sales Commission Income', '0', '4', '5', NULL, NULL),
('147', '20', '16', '2018-02-22', '42200', 'Lorry Cooly - Commission', '0', '4', '5', NULL, NULL),
('148', '20', '16', '2018-02-22', '42400', 'Sales Commission Income', '0', '4', '5', NULL, NULL),
('149', '20', '16', '2018-02-22', '41000', '', '0', '4', '5', NULL, NULL),
('150', '20', '17', '2018-02-22', '20000', '', '0', '0', '0', '3', '4'),
('151', '20', '17', '2018-02-22', '12000', '', '0', '4', '5', NULL, NULL),
('152', '20', '18', '2018-02-22', '20000', '', '0', '0', '0', '3', '4'),
('153', '20', '18', '2018-02-22', '42000', 'Sales Commission Income', '0', '4', '5', NULL, NULL),
('154', '20', '18', '2018-02-22', '42100', 'Sales Commission Income', '0', '4', '5', NULL, NULL),
('155', '20', '18', '2018-02-22', '42200', 'Lorry Cooly - Commission', '0', '4', '5', NULL, NULL),
('156', '20', '18', '2018-02-22', '42400', 'Sales Commission Income', '0', '4', '5', NULL, NULL),
('157', '20', '18', '2018-02-22', '12000', '', '0', '4', '5', NULL, NULL),
('158', '20', '18', '2018-02-22', '12000', 'GRN Provision', '0', '4', '5', NULL, NULL),
('159', '12', '4', '2018-02-23', '10500', '', '46590', '0', '0', NULL, NULL),
('160', '12', '4', '2018-02-23', '11000', '', '-46590', '0', '0', '2', '6'),
('161', '22', '1', '2018-02-23', '20000', '', '0', '0', '0', '3', '4'),
('162', '22', '1', '2018-02-23', '10500', '', '0', '0', '0', NULL, NULL),
('163', '22', '2', '2018-02-23', '20000', '', '10000', '0', '0', '3', '1'),
('164', '22', '2', '2018-02-23', '10100', '', '-10000', '0', '0', NULL, NULL),
('165', '22', '3', '2018-02-23', '20000', '', '16720', '0', '0', '3', '4'),
('166', '22', '3', '2018-02-23', '10500', '', '-16720', '0', '0', NULL, NULL),
('167', '22', '4', '2018-02-23', '20000', '', '25046.8', '0', '0', '3', '4'),
('168', '22', '4', '2018-02-23', '10500', '', '-25046.8', '0', '0', NULL, NULL),
('169', '20', '19', '2018-02-23', '20000', '', '-210', '0', '0', '3', '3'),
('170', '20', '19', '2018-02-23', '12000', '', '200', '0', '0', NULL, NULL),
('171', '20', '19', '2018-02-23', '12000', 'GRN Provision', '10', '0', '0', NULL, NULL),
('172', '13', '12', '2018-02-23', '50000', '', '1584.55', '0', '0', NULL, NULL),
('173', '13', '12', '2018-02-23', '12000', '', '-1584.55', '0', '0', NULL, NULL),
('174', '10', '12', '2018-02-23', '40000', '', '0', '0', '0', NULL, NULL),
('175', '10', '12', '2018-02-23', '11000', '', '0', '0', '0', '2', '6'),
('176', '10', '12', '2018-02-23', '12000', '', '-200', '0', '0', NULL, NULL),
('177', '10', '12', '2018-02-23', '11000', '', '200', '0', '0', '2', '6'),
('178', '10', '8', '2018-02-23', '41000', '', '-8694', '4', '5', NULL, NULL),
('179', '10', '8', '2018-02-23', '43000', '', '-26', '4', '5', NULL, NULL),
('180', '10', '8', '2018-02-23', '11000', '', '8720', '0', '0', '2', '6'),
('181', '20', '20', '2018-02-22', '20000', '', '0', '0', '0', '3', '4'),
('182', '20', '20', '2018-02-22', '41000', '', '0', '0', '0', NULL, NULL),
('183', '20', '21', '2018-02-22', '20000', '', '0', '0', '0', '3', '4'),
('184', '20', '21', '2018-02-22', '42000', 'Sales Commission Income', '0', '0', '0', NULL, NULL),
('185', '20', '21', '2018-02-22', '42100', 'Sales Commission Income', '0', '0', '0', NULL, NULL),
('186', '20', '21', '2018-02-22', '42200', 'Lorry Cooly - Commission', '0', '0', '0', NULL, NULL),
('187', '20', '21', '2018-02-22', '42400', 'Sales Commission Income', '0', '0', '0', NULL, NULL),
('188', '20', '21', '2018-02-22', '41000', '', '0', '0', '0', NULL, NULL),
('189', '20', '21', '2018-02-22', '41000', 'GRN Provision', '0', '0', '0', NULL, NULL),
('190', '20', '22', '2018-02-22', '20000', '', '0', '0', '0', '3', '4'),
('191', '20', '22', '2018-02-22', '41000', '', '0', '0', '0', NULL, NULL),
('192', '20', '23', '2018-02-22', '20000', '', '0', '0', '0', '3', '4'),
('193', '20', '23', '2018-02-22', '42000', 'Sales Commission Income', '0', '4', '5', NULL, NULL),
('194', '20', '23', '2018-02-22', '42100', 'Sales Commission Income', '0', '4', '5', NULL, NULL),
('195', '20', '23', '2018-02-22', '42200', 'Lorry Cooly - Commission', '0', '4', '5', NULL, NULL),
('196', '20', '23', '2018-02-22', '42400', 'Sales Commission Income', '0', '4', '5', NULL, NULL),
('197', '20', '23', '2018-02-22', '41000', '', '0', '0', '0', NULL, NULL),
('198', '20', '23', '2018-02-22', '41000', 'GRN Provision', '0', '0', '0', NULL, NULL),
('199', '20', '24', '2018-02-23', '20000', '', '-16720', '0', '0', '3', '4'),
('200', '20', '24', '2018-02-23', '41000', '', '16720', '4', '5', NULL, NULL),
('201', '20', '25', '2018-02-23', '20000', '', '-25046.8', '0', '0', '3', '4'),
('202', '20', '25', '2018-02-23', '42000', 'Sales Commission Income', '-2755.2', '4', '5', NULL, NULL),
('203', '20', '25', '2018-02-23', '42100', 'Sales Commission Income', '-90', '4', '5', NULL, NULL),
('204', '20', '25', '2018-02-23', '42200', 'Lorry Cooly - Commission', '-1290', '4', '5', NULL, NULL),
('205', '20', '25', '2018-02-23', '42400', 'Sales Commission Income', '-18', '4', '5', NULL, NULL),
('206', '20', '25', '2018-02-23', '41000', '', '32120', '4', '5', NULL, NULL),
('207', '20', '25', '2018-02-23', '41000', 'GRN Provision', '-2920', '4', '5', NULL, NULL),
('208', '1', '4', '2018-02-23', '51300', 'Lorry Cooly', '2400', '6', '7', NULL, NULL),
('209', '1', '4', '2018-02-23', '51200', 'Cart Cooly', '240', '6', '7', NULL, NULL),
('210', '1', '4', '2018-02-23', '10500', '', '-2640', '0', '0', NULL, NULL),
('211', '1', '5', '2018-02-23', '51100', 'Unloading Cost', '180', '6', '5', NULL, NULL),
('212', '1', '5', '2018-02-23', '10500', '', '-180', '0', '0', NULL, NULL),
('213', '13', '13', '2018-02-23', '50000', '', '50599.53', '6', '7', NULL, NULL),
('214', '13', '13', '2018-02-23', '41000', '', '-50599.53', '0', '0', NULL, NULL),
('215', '10', '13', '2018-02-23', '41000', '', '-36710', '6', '7', NULL, NULL),
('216', '10', '13', '2018-02-23', '43000', '', '-180', '6', '7', NULL, NULL),
('217', '10', '13', '2018-02-23', '11000', '', '36890', '0', '0', '2', '7'),
('218', '12', '5', '2018-02-23', '10100', '', '36890', '0', '0', NULL, NULL),
('219', '12', '5', '2018-02-23', '11000', '', '-36890', '0', '0', '2', '7'),
('220', '13', '14', '2018-02-23', '50000', '', '16540.3', '6', '7', NULL, NULL),
('221', '13', '14', '2018-02-23', '41000', '', '-16540.3', '0', '0', NULL, NULL),
('222', '10', '14', '2018-02-23', '41000', '', '-12600', '6', '7', NULL, NULL),
('223', '10', '14', '2018-02-23', '43000', '', '-60', '6', '7', NULL, NULL),
('224', '10', '14', '2018-02-23', '11000', '', '12660', '0', '0', '2', '4'),
('225', '12', '6', '2018-02-23', '10500', '', '10000', '0', '0', NULL, NULL),
('226', '12', '6', '2018-02-23', '11000', '', '-10000', '0', '0', '2', '4'),
('227', '20', '26', '2018-02-23', '20000', '', '-12600', '0', '0', '3', '6'),
('228', '20', '26', '2018-02-23', '41000', '', '13200', '6', '7', NULL, NULL),
('229', '20', '26', '2018-02-23', '41000', 'GRN Provision', '-600', '6', '7', NULL, NULL),
('230', '20', '27', '2018-02-23', '20000', '', '-30886', '0', '0', '3', '6'),
('231', '20', '27', '2018-02-23', '42000', 'Sales Commission Income', '-2958', '6', '7', NULL, NULL),
('232', '20', '27', '2018-02-23', '42100', 'Sales Commission Income', '-180', '6', '7', NULL, NULL),
('233', '20', '27', '2018-02-23', '42200', 'Lorry Cooly - Commission', '-2640', '6', '7', NULL, NULL),
('234', '20', '27', '2018-02-23', '42400', 'Sales Commission Income', '-36', '6', '7', NULL, NULL),
('235', '20', '27', '2018-02-23', '41000', '', '40370', '6', '7', NULL, NULL),
('236', '20', '27', '2018-02-23', '41000', 'GRN Provision', '-3670', '6', '7', NULL, NULL),
('237', '22', '5', '2018-02-23', '20000', '', '30886', '0', '0', '3', '6'),
('238', '22', '5', '2018-02-23', '10100', '', '-30886', '0', '0', NULL, NULL);

### Structure of table `3_grn_batch` ###

DROP TABLE IF EXISTS `3_grn_batch`;

CREATE TABLE `3_grn_batch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `purch_order_no` int(11) DEFAULT NULL,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rate` double DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `delivery_date` (`delivery_date`),
  KEY `purch_order_no` (`purch_order_no`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_grn_batch` ###

INSERT INTO `3_grn_batch` VALUES
('1', '1', '1', '1', '2018-02-08', 'DEF', '1'),
('2', '1', '2', 'auto', '2018-02-08', 'DEF', '1'),
('3', '1', '3', '2', '2018-02-09', 'DEF', '1'),
('4', '1', '4', '3', '2018-02-09', 'DEF', '1'),
('5', '1', '5', '4', '2018-02-09', 'DEF', '1'),
('6', '1', '6', '5', '2018-02-09', 'DEF', '1'),
('7', '1', '7', '6', '2018-02-09', 'DEF', '1'),
('8', '1', '8', '7', '2018-02-09', 'DEF', '1'),
('9', '2', '9', '8', '2018-02-15', 'DEF', '1'),
('10', '1', '10', '9', '2018-02-22', 'DEF', '1'),
('11', '4', '11', '10', '2018-02-23', 'DEF', '1'),
('12', '4', '12', '11', '2018-02-22', 'DEF', '1'),
('13', '4', '13', '12', '2018-02-22', 'DEF', '1'),
('14', '4', '14', '13', '2018-02-22', 'DEF', '1'),
('15', '3', '15', '14', '2018-02-23', 'DEF', '1'),
('16', '4', '16', '15', '2018-02-23', 'DEF', '1'),
('17', '6', '17', '16', '2018-02-23', 'DEF', '1');

### Structure of table `3_grn_items` ###

DROP TABLE IF EXISTS `3_grn_items`;

CREATE TABLE `3_grn_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_batch_id` int(11) DEFAULT NULL,
  `po_detail_item` int(11) NOT NULL DEFAULT '0',
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `qty_recd` double NOT NULL DEFAULT '0',
  `quantity_inv` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `grn_batch_id` (`grn_batch_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_grn_items` ###

INSERT INTO `3_grn_items` VALUES
('1', '1', '1', 'R/O', 'Red Onions', '0', '0'),
('2', '2', '2', 'RO', 'Red Onion', '0', '0'),
('3', '3', '3', 'RO', 'Red Onion', '0', '0'),
('4', '4', '4', 'RO', 'Red Onion', '0', '0'),
('5', '5', '5', 'RO', 'Red Onion', '0', '0'),
('6', '6', '6', 'BRK-Commission', 'Brokerage - Commission', '0', '0'),
('7', '7', '7', 'RO', 'Red Onion', '268', '268'),
('8', '8', '8', 'RO', 'Red Onion', '0', '0'),
('9', '9', '9', '10843', 'M.C.Jaffna', '1', '0'),
('10', '10', '10', 'RO', 'Red Onion', '0', '0'),
('11', '11', '11', 'RO', 'Red Onion', '0', '0'),
('12', '12', '12', 'RO', 'Red Onion', '0', '0'),
('13', '12', '13', 'RO', 'Red Onion', '0', '0'),
('14', '13', '14', 'RO', 'Red Onion', '0', '0'),
('15', '14', '15', 'ROnion', 'Red Onion', '0', '0'),
('16', '15', '16', 'ROnion', 'Red Onion', '11', '10'),
('17', '16', '17', 'ROnion', 'Red Onion', '222', '222'),
('18', '17', '18', 'ROnion', 'Red Onion', '540', '487');

### Structure of table `3_groups` ###

DROP TABLE IF EXISTS `3_groups`;

CREATE TABLE `3_groups` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_groups` ###

INSERT INTO `3_groups` VALUES
('1', 'Small', '0'),
('2', 'Medium', '0'),
('3', 'Large', '0');

### Structure of table `3_item_codes` ###

DROP TABLE IF EXISTS `3_item_codes`;

CREATE TABLE `3_item_codes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` smallint(6) unsigned NOT NULL,
  `quantity` double NOT NULL DEFAULT '1',
  `is_foreign` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `stock_id` (`stock_id`,`item_code`),
  KEY `item_code` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_item_codes` ###

INSERT INTO `3_item_codes` VALUES
('2', 'R/O', 'R/O', 'Red Onions', '2', '1', '0', '1'),
('3', 'RO', 'RO', 'Red Onion', '1', '1', '0', '1'),
('4', 'UNL-Commission', 'UNL-Commission', 'Unloading Expenses - Commission', '2', '1', '0', '0'),
('5', 'LC-Commissioin', 'LC-Commissioin', 'Lorry Cooly Commission', '2', '1', '0', '0'),
('6', 'CRT-Commission', 'CRT-Commission', 'Cart Cooly - Commission', '2', '1', '0', '0'),
('7', 'BRK-Commission', 'BRK-Commission', 'Brokerage - Commission', '2', '1', '0', '0'),
('8', 'Commission', 'Commission', 'Commission', '2', '1', '0', '0'),
('9', 'NTcooly', 'NTcooly', 'Sales Nattami Cooly', '2', '1', '0', '0'),
('10', '10843', '10843', 'M.C.Jaffna', '1', '1', '0', '0'),
('11', 'ROnion', 'ROnion', 'Red Onion', '3', '1', '0', '0');

### Structure of table `3_item_tax_type_exemptions` ###

DROP TABLE IF EXISTS `3_item_tax_type_exemptions`;

CREATE TABLE `3_item_tax_type_exemptions` (
  `item_tax_type_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_tax_type_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_item_tax_type_exemptions` ###


### Structure of table `3_item_tax_types` ###

DROP TABLE IF EXISTS `3_item_tax_types`;

CREATE TABLE `3_item_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `exempt` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_item_tax_types` ###

INSERT INTO `3_item_tax_types` VALUES
('1', 'Regular', '0', '0'),
('2', 'Tax exempt', '1', '0');

### Structure of table `3_item_units` ###

DROP TABLE IF EXISTS `3_item_units`;

CREATE TABLE `3_item_units` (
  `abbr` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `decimals` tinyint(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`abbr`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_item_units` ###

INSERT INTO `3_item_units` VALUES
('Bg.', 'Bags', '-1', '0'),
('ea.', 'Each', '0', '0'),
('KG', 'Killo Grams', '-1', '0');

### Structure of table `3_journal` ###

DROP TABLE IF EXISTS `3_journal`;

CREATE TABLE `3_journal` (
  `type` smallint(6) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `tran_date` date DEFAULT '0000-00-00',
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `source_ref` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `event_date` date DEFAULT '0000-00-00',
  `doc_date` date NOT NULL DEFAULT '0000-00-00',
  `currency` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_journal` ###


### Structure of table `3_loc_stock` ###

DROP TABLE IF EXISTS `3_loc_stock`;

CREATE TABLE `3_loc_stock` (
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `reorder_level` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`loc_code`,`stock_id`),
  KEY `stock_id` (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_loc_stock` ###

INSERT INTO `3_loc_stock` VALUES
('DEF', '10843', '0'),
('DEF', 'BRK-Commission', '0'),
('DEF', 'Commission', '0'),
('DEF', 'CRT-Commission', '0'),
('DEF', 'LC-Commissioin', '0'),
('DEF', 'NTcooly', '0'),
('DEF', 'R/O', '0'),
('DEF', 'RO', '0'),
('DEF', 'ROnion', '0'),
('DEF', 'UNL-Commission', '0');

### Structure of table `3_locations` ###

DROP TABLE IF EXISTS `3_locations`;

CREATE TABLE `3_locations` (
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `location_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fax` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fixed_asset` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_locations` ###

INSERT INTO `3_locations` VALUES
('DEF', 'Default', 'N/A', '', '', '', '', '', '0', '0');

### Structure of table `3_payment_terms` ###

DROP TABLE IF EXISTS `3_payment_terms`;

CREATE TABLE `3_payment_terms` (
  `terms_indicator` int(11) NOT NULL AUTO_INCREMENT,
  `terms` char(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `days_before_due` smallint(6) NOT NULL DEFAULT '0',
  `day_in_following_month` smallint(6) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`terms_indicator`),
  UNIQUE KEY `terms` (`terms`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_payment_terms` ###

INSERT INTO `3_payment_terms` VALUES
('1', 'Due 15th Of the Following Month', '0', '17', '0'),
('2', 'Due By End Of The Following Month', '0', '30', '0'),
('3', 'Payment due within 10 days', '10', '0', '0'),
('4', 'Cash Only', '0', '0', '0');

### Structure of table `3_prices` ###

DROP TABLE IF EXISTS `3_prices`;

CREATE TABLE `3_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type_id` int(11) NOT NULL DEFAULT '0',
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `price` (`stock_id`,`sales_type_id`,`curr_abrev`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_prices` ###

INSERT INTO `3_prices` VALUES
('1', 'BRK-Commission', '1', 'LKR', '18');

### Structure of table `3_print_profiles` ###

DROP TABLE IF EXISTS `3_print_profiles`;

CREATE TABLE `3_print_profiles` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `report` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `printer` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile` (`profile`,`report`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_print_profiles` ###

INSERT INTO `3_print_profiles` VALUES
('1', 'Out of office', NULL, '0'),
('2', 'Sales Department', NULL, '0'),
('3', 'Central', NULL, '2'),
('4', 'Sales Department', '104', '2'),
('5', 'Sales Department', '105', '2'),
('6', 'Sales Department', '107', '2'),
('7', 'Sales Department', '109', '2'),
('8', 'Sales Department', '110', '2'),
('9', 'Sales Department', '201', '2');

### Structure of table `3_printers` ###

DROP TABLE IF EXISTS `3_printers`;

CREATE TABLE `3_printers` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `queue` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `host` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `port` smallint(11) unsigned NOT NULL,
  `timeout` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_printers` ###

INSERT INTO `3_printers` VALUES
('1', 'QL500', 'Label printer', 'QL500', 'server', '127', '20'),
('2', 'Samsung', 'Main network printer', 'scx4521F', 'server', '515', '5'),
('3', 'Local', 'Local print server at user IP', 'lp', '', '515', '10');

### Structure of table `3_purch_data` ###

DROP TABLE IF EXISTS `3_purch_data`;

CREATE TABLE `3_purch_data` (
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT '0',
  `suppliers_uom` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `conversion_factor` double NOT NULL DEFAULT '1',
  `supplier_description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`supplier_id`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_purch_data` ###

INSERT INTO `3_purch_data` VALUES
('1', 'BRK-Commission', '320', '', '1', 'Brokerage - Commission'),
('1', 'R/O', '0', '', '1', 'Red Onions'),
('1', 'RO', '320', '', '1', 'Red Onion'),
('2', '10843', '10', '', '1', 'M.C.Jaffna'),
('3', 'ROnion', '21', '', '1', 'Red Onion'),
('4', 'RO', '230', '', '1', 'Red Onion'),
('4', 'ROnion', '200', '', '1', 'Red Onion'),
('6', 'ROnion', '100', '', '1', 'Red Onion');

### Structure of table `3_purch_order_details` ###

DROP TABLE IF EXISTS `3_purch_order_details`;

CREATE TABLE `3_purch_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT '0',
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `act_price` double NOT NULL DEFAULT '0',
  `std_cost_unit` double NOT NULL DEFAULT '0',
  `quantity_ordered` double NOT NULL DEFAULT '0',
  `quantity_received` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`),
  KEY `itemcode` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_purch_order_details` ###

INSERT INTO `3_purch_order_details` VALUES
('1', '1', 'R/O', 'Red Onions', '2018-02-08', '0', '0', '0', '0', '0', '0'),
('2', '2', 'RO', 'Red Onion', '2018-02-08', '0', '330', '330', '0', '0', '0'),
('3', '3', 'RO', 'Red Onion', '2018-02-09', '0', '0', '0', '0', '0', '0'),
('4', '4', 'RO', 'Red Onion', '2018-02-09', '0', '320', '320', '0', '0', '0'),
('5', '5', 'RO', 'Red Onion', '2018-02-09', '0', '320', '320', '-322.388059701', '0', '0'),
('6', '6', 'BRK-Commission', 'Brokerage - Commission', '2018-02-09', '0', '320', '320', '0', '0', '0'),
('7', '7', 'RO', 'Red Onion', '2018-02-09', '268', '320', '330', '-969.570060146', '268', '268'),
('8', '8', 'RO', 'Red Onion', '2018-02-09', '0', '320', '320', '-969.570060146', '0', '0'),
('9', '9', '10843', 'M.C.Jaffna', '2018-02-15', '0', '10', '0', '0', '1', '1'),
('10', '10', 'RO', 'Red Onion', '2018-02-22', '0', '320', '320', '-1651.64814571', '0', '0'),
('11', '11', 'RO', 'Red Onion', '2018-02-23', '0', '220', '220', '-1651.64814571', '0', '0'),
('12', '12', 'RO', 'Red Onion', '2018-02-22', '0', '220', '220', '-1651.64814571', '0', '0'),
('13', '12', 'RO', 'Red Onion', '2018-02-22', '0', '220', '220', '-1651.64814571', '0', '0'),
('14', '13', 'RO', 'Red Onion', '2018-02-22', '0', '220', '230', '-3673.2884767', '0', '0'),
('15', '14', 'ROnion', 'Red Onion', '2018-02-22', '0', '220', '220', '220', '0', '0'),
('16', '15', 'ROnion', 'Red Onion', '2018-02-23', '10', '20', '21', '198.025751072', '11', '11'),
('17', '16', 'ROnion', 'Red Onion', '2018-02-23', '222', '220', '200', '211.709673431', '222', '222'),
('18', '17', 'ROnion', 'Red Onion', '2018-02-23', '487', '110', '100', '137.835824577', '540', '540');

### Structure of table `3_purch_orders` ###

DROP TABLE IF EXISTS `3_purch_orders`;

CREATE TABLE `3_purch_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `comments` tinytext COLLATE utf8_unicode_ci,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `requisition_no` tinytext COLLATE utf8_unicode_ci,
  `into_stock_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `total` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_purch_orders` ###

INSERT INTO `3_purch_orders` VALUES
('1', '1', NULL, '2018-02-08', 'auto', '001', 'DEF', 'N/A', '0', '0', '0', '0'),
('2', '1', NULL, '2018-02-08', 'auto', '01', 'DEF', 'N/A', '88440', '0', '0', '0'),
('3', '1', NULL, '2018-02-09', 'auto', NULL, 'DEF', 'N/A', '0', '0', '0', '0'),
('4', '1', NULL, '2018-02-09', 'auto', '01', 'DEF', 'N/A', '86400', '0', '0', '0'),
('5', '1', NULL, '2018-02-09', 'auto', NULL, 'DEF', 'N/A', '86400', '0', '0', '0'),
('6', '1', NULL, '2018-02-09', 'auto', NULL, 'DEF', 'N/A', '86400', '0', '0', '0'),
('7', '1', NULL, '2018-02-09', 'auto', NULL, 'DEF', 'N/A', '86400', '0', '0', '0'),
('8', '1', NULL, '2018-02-09', 'auto', '001', 'DEF', 'N/A', '86400', '0', '0', '0'),
('9', '2', NULL, '2018-02-15', 'auto', NULL, 'DEF', 'N/A', '10', '0', '0', '0'),
('10', '1', NULL, '2018-02-22', 'auto', '123', 'DEF', 'N/A', '86400', '0', '0', '0'),
('11', '4', NULL, '2018-02-23', 'auto', '20', 'DEF', 'N/A', '52800', '0', '0', '0'),
('12', '4', NULL, '2018-02-22', 'auto', NULL, 'DEF', 'N/A', '440', '0', '0', '0'),
('13', '4', NULL, '2018-02-22', 'auto', '02', 'DEF', 'N/A', '52800', '0', '0', '0'),
('14', '4', NULL, '2018-02-22', 'auto', '555', 'DEF', 'N/A', '52800', '0', '0', '0'),
('15', '3', NULL, '2018-02-23', 'auto', NULL, 'DEF', 'N/A', '220', '0', '0', '0'),
('16', '4', NULL, '2018-02-23', 'auto', '123', 'DEF', 'N/A', '52800', '0', '0', '0'),
('17', '6', NULL, '2018-02-23', 'auto', '12', 'DEF', 'N/A', '59400', '0', '0', '0');

### Structure of table `3_quick_entries` ###

DROP TABLE IF EXISTS `3_quick_entries`;

CREATE TABLE `3_quick_entries` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `usage` varchar(120) COLLATE utf8_unicode_ci DEFAULT NULL,
  `base_amount` double NOT NULL DEFAULT '0',
  `base_desc` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bal_type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_quick_entries` ###

INSERT INTO `3_quick_entries` VALUES
('1', '1', 'Maintenance', NULL, '0', 'Amount', '0'),
('2', '4', 'Phone', NULL, '0', 'Amount', '0'),
('3', '4', 'Consignment Note', NULL, '49300', 'Amount', '0');

### Structure of table `3_quick_entry_lines` ###

DROP TABLE IF EXISTS `3_quick_entry_lines`;

CREATE TABLE `3_quick_entry_lines` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `qid` smallint(6) unsigned NOT NULL,
  `amount` double DEFAULT '0',
  `memo` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `dest_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` smallint(6) unsigned DEFAULT NULL,
  `dimension2_id` smallint(6) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_quick_entry_lines` ###

INSERT INTO `3_quick_entry_lines` VALUES
('1', '1', '0', '', 't-', '1', '0', '0'),
('2', '2', '0', '', 't-', '1', '0', '0'),
('3', '3', '-6', 'Sales Commission Income', '%', '42000', '6', '7'),
('5', '1', '0', '', '=', '70000', '0', '0'),
('6', '2', '0', '', '=', '76500', '0', '0'),
('7', '3', '-180', 'Sales Commission Income', 'a', '42100', '6', '7'),
('8', '3', '-2640', 'Lorry Cooly - Commission', 'a', '42200', '6', '7'),
('13', '3', '-36', 'Sales Commission Income', 'a', '42400', '6', '7');

### Structure of table `3_recurrent_invoices` ###

DROP TABLE IF EXISTS `3_recurrent_invoices`;

CREATE TABLE `3_recurrent_invoices` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order_no` int(11) unsigned NOT NULL,
  `debtor_no` int(11) unsigned DEFAULT NULL,
  `group_no` smallint(6) unsigned DEFAULT NULL,
  `days` int(11) NOT NULL DEFAULT '0',
  `monthly` int(11) NOT NULL DEFAULT '0',
  `begin` date NOT NULL DEFAULT '0000-00-00',
  `end` date NOT NULL DEFAULT '0000-00-00',
  `last_sent` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_recurrent_invoices` ###


### Structure of table `3_reflines` ###

DROP TABLE IF EXISTS `3_reflines`;

CREATE TABLE `3_reflines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` int(11) NOT NULL,
  `prefix` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pattern` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `prefix` (`trans_type`,`prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_reflines` ###

INSERT INTO `3_reflines` VALUES
('1', '0', '', '1', '', '1', '0'),
('2', '1', '', '4', '', '1', '0'),
('3', '2', '', '2', '', '1', '0'),
('4', '4', '', '1', '', '1', '0'),
('5', '10', '', '12', '', '1', '0'),
('6', '11', '', '1', '', '1', '0'),
('7', '12', '', '6', '', '1', '0'),
('8', '13', '', '1', '', '1', '0'),
('9', '16', '', '1', '', '1', '0'),
('10', '17', '', '1', '', '1', '0'),
('11', '18', '', '1', '', '1', '0'),
('12', '20', '', '16', '', '1', '0'),
('13', '21', '', '1', '', '1', '0'),
('14', '22', '', '6', '', '1', '0'),
('15', '25', '', '17', '', '1', '0'),
('16', '26', '', '1', '', '1', '0'),
('17', '28', '', '1', '', '1', '0'),
('18', '29', '', '1', '', '1', '0'),
('19', '30', '', '1', '', '1', '0'),
('20', '32', '', '1', '', '1', '0'),
('21', '35', '', '1', '', '1', '0'),
('22', '40', '', '7', '', '1', '0');

### Structure of table `3_refs` ###

DROP TABLE IF EXISTS `3_refs`;

CREATE TABLE `3_refs` (
  `id` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`type`),
  KEY `Type_and_Reference` (`type`,`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_refs` ###

INSERT INTO `3_refs` VALUES
('1', '1', '1'),
('2', '1', '2'),
('4', '1', '20812'),
('5', '1', '20818'),
('3', '1', '3'),
('1', '2', '1'),
('1', '10', '1'),
('11', '10', '10'),
('12', '10', '11'),
('2', '10', '2'),
('3', '10', '3'),
('4', '10', '4'),
('5', '10', '5'),
('6', '10', '5'),
('7', '10', '6'),
('8', '10', '7'),
('14', '10', '70200'),
('13', '10', '70257'),
('9', '10', '8'),
('10', '10', '9'),
('1', '12', '1'),
('2', '12', '2'),
('3', '12', '3'),
('4', '12', '4'),
('5', '12', '5'),
('6', '12', '70200'),
('1', '20', '1'),
('3', '20', '1'),
('5', '20', '1'),
('7', '20', '1'),
('9', '20', '1'),
('20', '20', '10'),
('21', '20', '11'),
('22', '20', '12'),
('24', '20', '12'),
('23', '20', '13'),
('25', '20', '13'),
('26', '20', '14'),
('27', '20', '15'),
('2', '20', '2'),
('4', '20', '2'),
('6', '20', '2'),
('8', '20', '2'),
('10', '20', '2'),
('12', '20', '2'),
('11', '20', '3'),
('13', '20', '3'),
('14', '20', '4'),
('15', '20', '5'),
('16', '20', '6'),
('17', '20', '7'),
('18', '20', '8'),
('19', '20', '9'),
('1', '22', '1'),
('2', '22', '2'),
('3', '22', '3'),
('4', '22', '4'),
('5', '22', '5'),
('1', '25', '1'),
('11', '25', '10'),
('12', '25', '11'),
('13', '25', '12'),
('14', '25', '13'),
('15', '25', '14'),
('16', '25', '15'),
('17', '25', '16'),
('3', '25', '2'),
('4', '25', '3'),
('5', '25', '4'),
('6', '25', '5'),
('7', '25', '6'),
('8', '25', '7'),
('9', '25', '8'),
('10', '25', '9'),
('1', '40', '1'),
('3', '40', '10868'),
('8', '40', '10883'),
('2', '40', '2'),
('4', '40', '3'),
('5', '40', '4'),
('6', '40', '5'),
('7', '40', '6'),
('9', '40', '8');

### Structure of table `3_sales_order_details` ###

DROP TABLE IF EXISTS `3_sales_order_details`;

CREATE TABLE `3_sales_order_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT '0',
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `stk_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `qty_sent` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `invoiced` double NOT NULL DEFAULT '0',
  `discount_percent` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `sorder` (`trans_type`,`order_no`),
  KEY `stkcode` (`stk_code`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_sales_order_details` ###

INSERT INTO `3_sales_order_details` VALUES
('1', '1', '30', 'RO', 'Red Onion', '0', '370', '0', '140.39999999999998', '0'),
('2', '1', '30', 'NTcooly', 'Sales Nattami Cooly', '0', '24', '0', '3', '0'),
('3', '2', '30', 'RO', 'Red Onion', '0', '310', '0', '0', '0'),
('4', '2', '30', 'NTcooly', 'Sales Nattami Cooly', '0', '22', '0', '0', '0'),
('5', '3', '30', 'RO', 'Red Onion', '45.4', '320', '45.4', '47.8', '0'),
('6', '3', '30', 'NTcooly', 'Sales Nattami Cooly', '1', '22', '1', '1', '0'),
('7', '4', '30', 'RO', 'Red Onion', '131.4', '320', '131.4', '0', '0'),
('8', '4', '30', 'NTcooly', 'Sales Nattami Cooly', '1', '62', '1', '0', '0'),
('9', '5', '30', 'RO', 'Red Onion', '0', '310', '0', '0', '0'),
('10', '5', '30', 'NTcooly', 'Sales Nattami Cooly', '0', '22', '0', '0', '0'),
('11', '6', '30', 'RO', 'Red Onion', '47.8', '310', '47.8', '0', '0'),
('12', '6', '30', 'NTcooly', 'Sales Nattami Cooly', '1', '22', '1', '0', '0'),
('13', '7', '30', 'RO', 'Red Onion', '46.8', '370', '46.8', '0', '0'),
('14', '7', '30', 'NTcooly', 'Sales Nattami Cooly', '1', '24', '1', '0', '0'),
('15', '8', '30', 'RO', 'Red Onion', '37.8', '230', '37.8', '0', '0'),
('16', '8', '30', 'NTcooly', 'Sales Nattami Cooly', '1', '26', '1', '0', '0'),
('17', '9', '30', 'RO', 'Red Onion', '70.8', '180', '70.8', '0', '0'),
('18', '9', '30', 'NTcooly', 'Sales Nattami Cooly', '1', '46', '1', '0', '0'),
('19', '10', '30', 'RO', 'Red Onion', '40.6', '200', '40.6', '0', '0'),
('20', '10', '30', 'NTcooly', 'Sales Nattami Cooly', '1', '20', '1', '0', '0'),
('21', '11', '30', 'RO', 'Red Onion', '76.8', '220', '76.8', '0', '0'),
('22', '11', '30', 'NTcooly', 'Sales Nattami Cooly', '1', '44', '1', '0', '0'),
('23', '12', '30', 'ROnion', 'Red Onion', '8', '25', '8', '0', '0'),
('24', '13', '30', 'ROnion', 'Red Onion', '367.1', '100', '367.1', '0', '0'),
('25', '13', '30', 'NTcooly', 'Sales Nattami Cooly', '1', '180', '1', '0', '0'),
('26', '14', '30', 'ROnion', 'Red Onion', '120', '105', '120', '0', '0'),
('27', '14', '30', 'NTcooly', 'Sales Nattami Cooly', '1', '60', '1', '0', '0');

### Structure of table `3_sales_orders` ###

DROP TABLE IF EXISTS `3_sales_orders`;

CREATE TABLE `3_sales_orders` (
  `order_no` int(11) NOT NULL,
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `version` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `branch_code` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `customer_ref` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `comments` tinytext COLLATE utf8_unicode_ci,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `order_type` int(11) NOT NULL DEFAULT '0',
  `ship_via` int(11) NOT NULL DEFAULT '0',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `contact_phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `deliver_to` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `freight_cost` double NOT NULL DEFAULT '0',
  `from_stk_loc` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `payment_terms` int(11) DEFAULT NULL,
  `total` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`trans_type`,`order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_sales_orders` ###

INSERT INTO `3_sales_orders` VALUES
('1', '30', '1', '0', '4', '4', 'auto', '', NULL, '2018-02-09', '1', '1', 'LTC \nRathnapura', NULL, NULL, 'LTC - Rathnapura', '0', 'DEF', '2018-02-10', '4', '17340', '0', '0'),
('2', '30', '1', '0', '1', '1', 'auto', '', NULL, '2018-02-09', '1', '1', 'A K A S \nMinuwangoda', NULL, NULL, 'A K A S -Minuwangoda', '0', 'DEF', '2018-02-10', '4', '14840', '0', '0'),
('3', '30', '1', '0', '2', '2', 'auto', '', NULL, '2018-02-09', '1', '1', 'col', NULL, NULL, 'B S P', '0', 'DEF', '2018-03-17', '1', '14550', '0', '0'),
('4', '30', '1', '0', '3', '3', 'auto', '', NULL, '2018-02-09', '1', '1', 'Col', NULL, NULL, 'PS', '0', 'DEF', '2018-03-17', '1', '42110', '0', '0'),
('5', '30', '1', '0', '1', '1', 'auto', '', NULL, '2018-02-10', '1', '1', 'A K A S \nMinuwangoda', NULL, NULL, 'A K A S -Minuwangoda', '0', 'DEF', '2018-02-10', '4', '14840', '0', '0'),
('6', '30', '1', '0', '1', '1', 'auto', '', NULL, '2018-02-10', '1', '1', 'A K A S \nMinuwangoda', NULL, NULL, 'A K A S -Minuwangoda', '0', 'DEF', '2018-02-10', '4', '14840', '0', '0'),
('7', '30', '1', '0', '4', '4', 'auto', '', NULL, '2018-02-10', '1', '1', 'LTC \nRathnapura', NULL, NULL, 'LTC - Rathnapura', '0', 'DEF', '2018-02-10', '4', '17340', '0', '0'),
('8', '30', '1', '0', '6', '6', 'auto', '', NULL, '2018-02-23', '2', '1', 'Colombo', NULL, NULL, 'Yggfg', '0', 'DEF', '2018-03-17', '1', '8720', '0', '0'),
('9', '30', '1', '0', '6', '6', 'auto', '', NULL, '2018-02-22', '2', '1', 'Colombo', NULL, NULL, 'Y41', '0', 'DEF', '2018-03-17', '1', '12790', '0', '0'),
('10', '30', '1', '0', '6', '6', 'auto', '', NULL, '2018-02-23', '2', '1', 'Colombo', NULL, NULL, 'Yjip', '0', 'DEF', '2018-03-17', '1', '8140', '0', '0'),
('11', '30', '1', '0', '6', '6', 'auto', '', NULL, '2018-02-23', '2', '1', 'Colombo', NULL, NULL, 'Ytgjdt', '0', 'DEF', '2018-03-17', '1', '16940', '0', '0'),
('12', '30', '1', '0', '6', '6', 'auto', '', NULL, '2018-02-23', '2', '1', 'Colombo', NULL, NULL, 'Yttrr', '0', 'DEF', '2018-03-17', '1', '200', '0', '0'),
('13', '30', '1', '0', '7', '7', 'auto', '', NULL, '2018-02-23', '2', '1', 'Cash', NULL, NULL, 'Cash', '0', 'DEF', '2018-02-23', '4', '36890', '0', '0'),
('14', '30', '1', '0', '4', '4', 'auto', '', NULL, '2018-02-23', '1', '1', 'LTC \nRathnapura', NULL, NULL, 'LTC - Rathnapura', '0', 'DEF', '2018-03-17', '1', '12660', '0', '0');

### Structure of table `3_sales_pos` ###

DROP TABLE IF EXISTS `3_sales_pos`;

CREATE TABLE `3_sales_pos` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `pos_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `cash_sale` tinyint(1) NOT NULL,
  `credit_sale` tinyint(1) NOT NULL,
  `pos_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `pos_account` smallint(6) unsigned NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `pos_name` (`pos_name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_sales_pos` ###

INSERT INTO `3_sales_pos` VALUES
('1', 'Default', '1', '1', 'DEF', '4', '0'),
('2', 'Cash', '1', '1', 'DEF', '4', '0');

### Structure of table `3_sales_types` ###

DROP TABLE IF EXISTS `3_sales_types`;

CREATE TABLE `3_sales_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_type` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_included` int(1) NOT NULL DEFAULT '0',
  `factor` double NOT NULL DEFAULT '1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_type` (`sales_type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_sales_types` ###

INSERT INTO `3_sales_types` VALUES
('1', 'Retail', '1', '1', '0'),
('2', 'Wholesale', '0', '0.7', '0');

### Structure of table `3_salesman` ###

DROP TABLE IF EXISTS `3_salesman`;

CREATE TABLE `3_salesman` (
  `salesman_code` int(11) NOT NULL AUTO_INCREMENT,
  `salesman_name` char(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_phone` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_fax` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `provision` double NOT NULL DEFAULT '0',
  `break_pt` double NOT NULL DEFAULT '0',
  `provision2` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`salesman_code`),
  UNIQUE KEY `salesman_name` (`salesman_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_salesman` ###

INSERT INTO `3_salesman` VALUES
('1', 'Sales Person', '', '', '', '5', '20000', '4', '0');

### Structure of table `3_security_roles` ###

DROP TABLE IF EXISTS `3_security_roles`;

CREATE TABLE `3_security_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sections` text COLLATE utf8_unicode_ci,
  `areas` text COLLATE utf8_unicode_ci,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `role` (`role`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_security_roles` ###

INSERT INTO `3_security_roles` VALUES
('1', 'Inquiries', 'Inquiries', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;773;774;2822;3073;3075;3076;3077;3329;3330;3331;3332;3333;3334;3335;5377;5633;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8450;8451;10497;10753;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15873;15882;16129;16130;16131;16132;775', '0'),
('2', 'System Administrator', 'System Administrator', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;10496;10752;11008;13056;13312;15616;15872;16128', '513;514;515;516;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;775;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15629;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132', '0'),
('3', 'Salesman', 'Salesman', '768;3072;5632;8192;15872', '773;774;3073;3075;3081;5633;8194;15873;775', '0'),
('4', 'Stock Manager', 'Stock Manager', '2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128;768', '775', '0'),
('5', 'Production Manager', 'Production Manager', '512;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128;768', '775', '0'),
('6', 'Purchase Officer', 'Purchase Officer', '512;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128;768', '775', '0'),
('7', 'AR Officer', 'AR Officer', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;771;773;774;2818;2819;2820;2821;2822;2823;3073;3073;3074;3075;3076;3077;3078;3079;3080;3081;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5633;5634;5637;5638;5639;5640;5640;5889;5890;5891;8193;8194;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0'),
('8', 'AP Officer', 'AP Officer', '512;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128;768', '775', '0'),
('9', 'Accountant', 'New Accountant', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;769;772;775;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;8193;8194;8195;8196;8197;8449;8450;8451;10753;10755;11009;11010;11012;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15629;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;7937;7938;7939;7940;9217;10497', '0'),
('10', 'Sub Admin', 'Sub Admin', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5637;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15873;15874;15876;15877;15878;15879;15880;15882;16129;16130;16131;16132;775', '0');

### Structure of table `3_shippers` ###

DROP TABLE IF EXISTS `3_shippers`;

CREATE TABLE `3_shippers` (
  `shipper_id` int(11) NOT NULL AUTO_INCREMENT,
  `shipper_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`shipper_id`),
  UNIQUE KEY `name` (`shipper_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_shippers` ###

INSERT INTO `3_shippers` VALUES
('1', 'Default', '', '', '', '', '0');

### Structure of table `3_sql_trail` ###

DROP TABLE IF EXISTS `3_sql_trail`;

CREATE TABLE `3_sql_trail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sql` text COLLATE utf8_unicode_ci NOT NULL,
  `result` tinyint(1) NOT NULL,
  `msg` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_sql_trail` ###


### Structure of table `3_stock_category` ###

DROP TABLE IF EXISTS `3_stock_category`;

CREATE TABLE `3_stock_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_tax_type` int(11) NOT NULL DEFAULT '1',
  `dflt_units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `dflt_mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `dflt_sales_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_cogs_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_inventory_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_adjustment_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_wip_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_dim1` int(11) DEFAULT NULL,
  `dflt_dim2` int(11) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `dflt_no_sale` tinyint(1) NOT NULL DEFAULT '0',
  `dflt_no_purchase` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_stock_category` ###

INSERT INTO `3_stock_category` VALUES
('1', 'Components', '1', 'ea.', 'B', '40000', '50000', '12000', '58500', '', '0', '0', '0', '0', '0'),
('2', 'Consignment Sales', '1', 'Bg.', 'B', '40000', '50000', '12000', '58500', '70000', '0', '0', '0', '0', '0'),
('3', 'Consignment goods', '2', 'KG', 'B', '41000', '50000', '12000', '58500', '70000', '0', '0', '0', '0', '0');

### Structure of table `3_stock_fa_class` ###

DROP TABLE IF EXISTS `3_stock_fa_class`;

CREATE TABLE `3_stock_fa_class` (
  `fa_class_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `long_description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `depreciation_rate` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fa_class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_stock_fa_class` ###


### Structure of table `3_stock_master` ###

DROP TABLE IF EXISTS `3_stock_master`;

CREATE TABLE `3_stock_master` (
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `long_description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cogs_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inventory_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `adjustment_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `wip_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` int(11) DEFAULT NULL,
  `dimension2_id` int(11) DEFAULT NULL,
  `purchase_cost` double NOT NULL DEFAULT '0',
  `material_cost` double NOT NULL DEFAULT '0',
  `labour_cost` double NOT NULL DEFAULT '0',
  `overhead_cost` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `no_sale` tinyint(1) NOT NULL DEFAULT '0',
  `no_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `editable` tinyint(1) NOT NULL DEFAULT '0',
  `depreciation_method` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'S',
  `depreciation_rate` double NOT NULL DEFAULT '0',
  `depreciation_factor` double NOT NULL DEFAULT '0',
  `depreciation_start` date NOT NULL DEFAULT '0000-00-00',
  `depreciation_date` date NOT NULL DEFAULT '0000-00-00',
  `fa_class_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_stock_master` ###

INSERT INTO `3_stock_master` VALUES
('10843', '1', '1', 'M.C.Jaffna', '', 'ea.', 'B', '40000', '50000', '12000', '58500', '', '0', '2', '0', '10', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('BRK-Commission', '2', '2', 'Brokerage - Commission', '', 'ea.', 'D', '42400', '42400', '12000', '58500', '70000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('Commission', '2', '2', 'Commission', '', 'ea.', 'D', '42000', '42000', '12000', '58500', '70000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CRT-Commission', '2', '2', 'Cart Cooly - Commission', '', 'ea.', 'D', '42300', '42300', '12000', '58500', '70000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('LC-Commissioin', '2', '2', 'Lorry Cooly Commission', '', 'ea.', 'D', '42200', '42200', '12000', '58500', '70000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('NTcooly', '2', '2', 'Sales Nattami Cooly', '', 'ea.', 'D', '43000', '43000', '12000', '58500', '70000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('R/O', '2', '2', 'Red Onions', 'Red Onions', 'Bg.', 'B', '41000', '51000', '58500', '58500', '70000', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('RO', '1', '2', 'Red Onion', '', 'Bg.', 'D', '41000', '41000', '12000', '58500', '70000', '0', '0', '230', '-53157.2793381', '0', '0', '1', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('ROnion', '3', '2', 'Red Onion', 'Red Onion', 'KG', 'B', '41000', '50000', '41000', '58500', '', '0', '0', '100', '117.148688349', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('UNL-Commission', '2', '2', 'Unloading Expenses - Commission', '', 'ea.', 'D', '42100', '42100', '12000', '58500', '70000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '');

### Structure of table `3_stock_moves` ###

DROP TABLE IF EXISTS `3_stock_moves`;

CREATE TABLE `3_stock_moves` (
  `trans_id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` smallint(6) NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `price` double NOT NULL DEFAULT '0',
  `reference` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT '1',
  `standard_cost` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`trans_id`),
  KEY `type` (`type`,`trans_no`),
  KEY `Move` (`stock_id`,`loc_code`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_stock_moves` ###

INSERT INTO `3_stock_moves` VALUES
('1', '1', 'R/O', '25', 'DEF', '2018-02-08', '1', '', '270', '0'),
('2', '2', 'RO', '25', 'DEF', '2018-02-08', '1', '', '268', '0'),
('3', '2', 'RO', '25', 'DEF', '2018-02-08', '330', '', '0', '0'),
('4', '2', 'RO', '25', 'DEF', '2018-02-08', '330', '', '0', '0'),
('5', '1', 'R/O', '25', 'DEF', '2018-02-08', '0', '', '-270', '0'),
('6', '2', 'RO', '25', 'DEF', '2018-02-08', '330', '', '0', '0'),
('7', '3', 'RO', '25', 'DEF', '2018-02-09', '1', '', '51', '0'),
('8', '4', 'RO', '25', 'DEF', '2018-02-09', '1', '', '270', '0'),
('9', '3', 'RO', '25', 'DEF', '2018-02-09', '0', '', '-51', '0'),
('10', '4', 'RO', '25', 'DEF', '2018-02-09', '320', '', '-270', '0'),
('11', '5', 'RO', '25', 'DEF', '2018-02-09', '1', '', '270', '-322.388059701'),
('12', '6', 'BRK-Commission', '25', 'DEF', '2018-02-09', '1', '', '270', '0'),
('13', '6', 'BRK-Commission', '25', 'DEF', '2018-02-09', '320', '', '-270', '0'),
('14', '5', 'RO', '25', 'DEF', '2018-02-09', '320', '', '-270', '-322.388059701'),
('15', '7', 'RO', '25', 'DEF', '2018-02-09', '1', '', '270', '-969.570060146'),
('16', '8', 'RO', '25', 'DEF', '2018-02-09', '1', '', '270', '-969.570060146'),
('17', '8', 'RO', '25', 'DEF', '2018-02-09', '320', '', '-270', '-969.570060146'),
('22', '3', 'RO', '13', 'DEF', '2018-02-09', '320', 'auto', '-45.4', '-1616.75206059'),
('23', '3', 'NTcooly', '13', 'DEF', '2018-02-09', '22', 'auto', '-1', '0'),
('24', '4', 'RO', '13', 'DEF', '2018-02-09', '320', 'auto', '-131.4', '-1616.75206059'),
('25', '4', 'NTcooly', '13', 'DEF', '2018-02-09', '62', 'auto', '-1', '0'),
('28', '6', 'RO', '13', 'DEF', '2018-02-10', '310', 'auto', '-47.8', '-1616.75206059'),
('29', '6', 'NTcooly', '13', 'DEF', '2018-02-10', '22', 'auto', '-1', '0'),
('30', '7', 'RO', '13', 'DEF', '2018-02-10', '370', 'auto', '-46.8', '-1616.75206059'),
('31', '7', 'NTcooly', '13', 'DEF', '2018-02-10', '24', 'auto', '-1', '0'),
('32', '7', 'RO', '25', 'DEF', '2018-02-09', '320', '', '-2', '-969.570060146'),
('33', '9', '10843', '25', 'DEF', '2018-02-15', '2', '', '1', '10'),
('34', '10', 'RO', '25', 'DEF', '2018-02-22', '1', '', '270', '-1651.64814571'),
('35', '11', 'RO', '25', 'DEF', '2018-02-23', '4', '', '240', '-1651.64814571'),
('36', '12', 'RO', '25', 'DEF', '2018-02-22', '4', '', '1', '-1651.64814571'),
('37', '12', 'RO', '25', 'DEF', '2018-02-22', '4', '', '1', '-1651.64814571'),
('38', '12', 'RO', '25', 'DEF', '2018-02-22', '220', '', '-1', '-1651.64814571'),
('39', '12', 'RO', '25', 'DEF', '2018-02-22', '220', '', '-1', '-1651.64814571'),
('40', '8', 'RO', '13', 'DEF', '2018-02-23', '230', 'auto', '-37.8', '-1658.65019639'),
('41', '8', 'NTcooly', '13', 'DEF', '2018-02-23', '26', 'auto', '-1', '0'),
('42', '9', 'RO', '13', 'DEF', '2018-02-22', '180', 'auto', '-70.8', '-1658.65019639'),
('43', '9', 'NTcooly', '13', 'DEF', '2018-02-22', '46', 'auto', '-1', '0'),
('44', '10', 'RO', '13', 'DEF', '2018-02-23', '200', 'auto', '-40.6', '-1658.65019639'),
('45', '10', 'NTcooly', '13', 'DEF', '2018-02-23', '20', 'auto', '-1', '0'),
('46', '11', 'RO', '13', 'DEF', '2018-02-23', '220', 'auto', '-76.8', '-1658.65019639'),
('47', '11', 'NTcooly', '13', 'DEF', '2018-02-23', '44', 'auto', '-1', '0'),
('48', '11', 'RO', '25', 'DEF', '2018-02-23', '220', '', '-240', '-1651.64814571'),
('49', '13', 'RO', '25', 'DEF', '2018-02-22', '4', '', '240', '-3673.2884767'),
('50', '14', 'ROnion', '25', 'DEF', '2018-02-22', '4', '', '240', '220'),
('51', '13', 'RO', '25', 'DEF', '2018-02-22', '220', '', '-240', '-3673.2884767'),
('52', '14', 'ROnion', '25', 'DEF', '2018-02-22', '220', '', '-18', '220'),
('53', '2', 'RO', '25', 'DEF', '2018-02-08', '330', '', '-268', '0'),
('54', '10', 'RO', '25', 'DEF', '2018-02-22', '320', '', '-270', '-1651.64814571'),
('55', '15', 'ROnion', '25', 'DEF', '2018-02-23', '3', '', '11', '198.025751072'),
('56', '12', 'ROnion', '13', 'DEF', '2018-02-23', '25', 'auto', '-8', '198.068669527'),
('57', '14', 'ROnion', '25', 'DEF', '2018-02-22', '220', '', '-222', '220'),
('58', '16', 'ROnion', '25', 'DEF', '2018-02-23', '4', '', '240', '211.709673431'),
('59', '17', 'ROnion', '25', 'DEF', '2018-02-23', '6', '', '540', '137.835824577'),
('60', '13', 'ROnion', '13', 'DEF', '2018-02-23', '100', 'auto', '-367.1', '137.835824577'),
('61', '13', 'NTcooly', '13', 'DEF', '2018-02-23', '180', 'auto', '-1', '0'),
('62', '14', 'ROnion', '13', 'DEF', '2018-02-23', '105', 'auto', '-120', '137.835824577'),
('63', '14', 'NTcooly', '13', 'DEF', '2018-02-23', '60', 'auto', '-1', '0'),
('64', '16', 'ROnion', '25', 'DEF', '2018-02-23', '220', '', '-18', '211.709673431');

### Structure of table `3_supp_allocations` ###

DROP TABLE IF EXISTS `3_supp_allocations`;

CREATE TABLE `3_supp_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_supp_allocations` ###

INSERT INTO `3_supp_allocations` VALUES
('1', '1', '20000', '2018-02-13', '2', '1', '12', '20'),
('4', '1', '10000', '2018-02-23', '2', '22', '12', '20'),
('11', '6', '30886', '2018-02-23', '5', '22', '27', '20');

### Structure of table `3_supp_invoice_items` ###

DROP TABLE IF EXISTS `3_supp_invoice_items`;

CREATE TABLE `3_supp_invoice_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_trans_no` int(11) DEFAULT NULL,
  `supp_trans_type` int(11) DEFAULT NULL,
  `gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `grn_item_id` int(11) DEFAULT NULL,
  `po_detail_item_id` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `quantity` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `unit_tax` double NOT NULL DEFAULT '0',
  `memo_` tinytext COLLATE utf8_unicode_ci,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `Transaction` (`supp_trans_type`,`supp_trans_no`,`stock_id`)
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_supp_invoice_items` ###

INSERT INTO `3_supp_invoice_items` VALUES
('1', '1', '20', '0', '2', '2', 'RO', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('2', '2', '20', '42200', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '1'),
('3', '2', '20', '0', '2', '2', 'RO', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('4', '3', '20', '40000', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '1'),
('5', '3', '20', '42200', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '1'),
('6', '3', '20', '42100', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '1'),
('7', '3', '20', '42300', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '1'),
('8', '3', '20', '42400', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '1'),
('9', '3', '20', '0', '2', '2', 'RO', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('10', '4', '20', '42200', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '0'),
('11', '4', '20', '42100', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '0'),
('12', '4', '20', '42300', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '0'),
('13', '4', '20', '42400', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '0'),
('14', '4', '20', '42000', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '0'),
('15', '4', '20', '0', '2', '2', 'RO', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('16', '5', '20', '42200', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '0'),
('17', '5', '20', '42100', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '0'),
('18', '5', '20', '42300', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '0'),
('19', '5', '20', '42400', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '0'),
('20', '5', '20', '42000', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '0'),
('21', '5', '20', '0', '2', '2', 'RO', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('22', '6', '20', '0', '2', '2', 'RO', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('23', '7', '20', '0', '2', '2', 'RO', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('24', '8', '20', '0', '2', '2', 'RO', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('25', '9', '20', '42000', '-1', '0', '', NULL, '0', '0', '0', NULL, '0', '1'),
('26', '9', '20', '0', '2', '2', 'RO', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('27', '10', '20', '42000', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '1'),
('28', '10', '20', '42100', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '1'),
('29', '10', '20', '42200', '-1', '0', '', NULL, '0', '0', '0', 'Lorry Cooly - Commission', '0', '1'),
('30', '10', '20', '42300', '-1', '0', '', NULL, '0', '0', '0', 'Lorry Cooly - Commission', '0', '1'),
('31', '10', '20', '42400', '-1', '0', '', NULL, '0', '0', '0', 'Lorry Cooly - Commission', '0', '1'),
('32', '10', '20', '0', '7', '7', 'RO', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('33', '11', '20', '42000', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '0'),
('34', '11', '20', '42100', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '0'),
('35', '11', '20', '42200', '-1', '0', '', NULL, '0', '0', '0', 'Lorry Cooly - Commission', '0', '0'),
('36', '11', '20', '42300', '-1', '0', '', NULL, '0', '0', '0', 'Lorry Cooly - Commission', '0', '0'),
('37', '11', '20', '42400', '-1', '0', '', NULL, '0', '0', '0', 'Lorry Cooly - Commission', '0', '0'),
('38', '11', '20', '0', '7', '7', 'RO', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('39', '12', '20', '42000', '-1', '0', '', NULL, '0', '-5306.4', '0', 'Sales Commission Income', '0', '1'),
('40', '12', '20', '42100', '-1', '0', '', NULL, '0', '-90', '0', 'Sales Commission Income', '0', '1'),
('41', '12', '20', '42200', '-1', '0', '', NULL, '0', '-1020', '0', 'Lorry Cooly - Commission', '0', '1'),
('42', '12', '20', '42300', '-1', '0', '', NULL, '0', '-90', '0', 'Lorry Cooly - Commission', '0', '1'),
('43', '12', '20', '42400', '-1', '0', '', NULL, '0', '-18', '0', 'Lorry Cooly - Commission', '0', '1'),
('44', '12', '20', '0', '7', '7', 'RO', 'Red Onion', '268', '330', '0', NULL, '0', '0'),
('45', '13', '20', '0', '14', '14', 'RO', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('46', '14', '20', '0', '14', '14', 'RO', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('47', '15', '20', '42000', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '4'),
('48', '15', '20', '42100', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '4'),
('49', '15', '20', '42200', '-1', '0', '', NULL, '0', '0', '0', 'Lorry Cooly - Commission', '0', '4'),
('50', '15', '20', '42400', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '4'),
('51', '16', '20', '42000', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '4'),
('52', '16', '20', '42100', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '4'),
('53', '16', '20', '42200', '-1', '0', '', NULL, '0', '0', '0', 'Lorry Cooly - Commission', '0', '4'),
('54', '16', '20', '42400', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '4'),
('55', '16', '20', '0', '14', '14', 'RO', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('56', '17', '20', '0', '15', '15', 'ROnion', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('57', '18', '20', '42000', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '4'),
('58', '18', '20', '42100', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '4'),
('59', '18', '20', '42200', '-1', '0', '', NULL, '0', '0', '0', 'Lorry Cooly - Commission', '0', '4'),
('60', '18', '20', '42400', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '4'),
('61', '18', '20', '0', '15', '15', 'ROnion', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('62', '19', '20', '0', '16', '16', 'ROnion', 'Red Onion', '10', '21', '0', NULL, '0', '0'),
('63', '20', '20', '0', '15', '15', 'ROnion', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('64', '21', '20', '42000', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '0'),
('65', '21', '20', '42100', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '0'),
('66', '21', '20', '42200', '-1', '0', '', NULL, '0', '0', '0', 'Lorry Cooly - Commission', '0', '0'),
('67', '21', '20', '42400', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '0'),
('68', '21', '20', '0', '15', '15', 'ROnion', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('69', '22', '20', '0', '15', '15', 'ROnion', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('70', '23', '20', '42000', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '4'),
('71', '23', '20', '42100', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '4'),
('72', '23', '20', '42200', '-1', '0', '', NULL, '0', '0', '0', 'Lorry Cooly - Commission', '0', '4'),
('73', '23', '20', '42400', '-1', '0', '', NULL, '0', '0', '0', 'Sales Commission Income', '0', '4'),
('74', '23', '20', '0', '15', '15', 'ROnion', 'Red Onion', '0', '0', '0', NULL, '0', '0'),
('75', '24', '20', '0', '17', '17', 'ROnion', 'Red Onion', '76', '220', '0', NULL, '0', '0'),
('76', '25', '20', '42000', '-1', '0', '', NULL, '0', '-2755.2', '0', 'Sales Commission Income', '0', '4'),
('77', '25', '20', '42100', '-1', '0', '', NULL, '0', '-90', '0', 'Sales Commission Income', '0', '4'),
('78', '25', '20', '42200', '-1', '0', '', NULL, '0', '-1290', '0', 'Lorry Cooly - Commission', '0', '4'),
('79', '25', '20', '42400', '-1', '0', '', NULL, '0', '-18', '0', 'Sales Commission Income', '0', '4'),
('80', '25', '20', '0', '17', '17', 'ROnion', 'Red Onion', '146', '200', '0', NULL, '0', '0'),
('81', '26', '20', '0', '18', '18', 'ROnion', 'Red Onion', '120', '105', '0', NULL, '0', '0'),
('82', '27', '20', '42000', '-1', '0', '', NULL, '0', '-2958', '0', 'Sales Commission Income', '0', '6'),
('83', '27', '20', '42100', '-1', '0', '', NULL, '0', '-180', '0', 'Sales Commission Income', '0', '6'),
('84', '27', '20', '42200', '-1', '0', '', NULL, '0', '-2640', '0', 'Lorry Cooly - Commission', '0', '6'),
('85', '27', '20', '42400', '-1', '0', '', NULL, '0', '-36', '0', 'Sales Commission Income', '0', '6'),
('86', '27', '20', '0', '18', '18', 'ROnion', 'Red Onion', '367', '100', '0', NULL, '0', '0');

### Structure of table `3_supp_trans` ###

DROP TABLE IF EXISTS `3_supp_trans`;

CREATE TABLE `3_supp_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `supplier_id` int(11) unsigned NOT NULL DEFAULT '0',
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `ov_amount` double NOT NULL DEFAULT '0',
  `ov_discount` double NOT NULL DEFAULT '0',
  `ov_gst` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  `alloc` double NOT NULL DEFAULT '0',
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`type`,`trans_no`,`supplier_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_supp_trans` ###

INSERT INTO `3_supp_trans` VALUES
('2', '1', '1', '2', '', '2018-02-13', '0000-00-00', '-20000', '0', '0', '1', '20000', '0'),
('1', '20', '1', '1', '01', '2018-02-08', '2018-03-30', '0', '0', '0', '1', '0', '0'),
('2', '20', '1', '2', '01', '2018-02-08', '2018-03-30', '0', '0', '0', '1', '0', '0'),
('3', '20', '1', '1', '01', '2018-02-08', '2018-03-30', '0', '0', '0', '1', '0', '0'),
('4', '20', '1', '2', '01', '2018-02-08', '2018-03-30', '0', '0', '0', '1', '0', '0'),
('5', '20', '1', '1', '01', '2018-02-08', '2018-03-30', '0', '0', '0', '1', '0', '0'),
('6', '20', '1', '2', '01', '2018-02-08', '2018-03-30', '0', '0', '0', '1', '0', '0'),
('7', '20', '1', '1', '01', '2018-02-08', '2018-03-30', '0', '0', '0', '1', '0', '0'),
('8', '20', '1', '2', '01', '2018-02-08', '2018-03-30', '0', '0', '0', '1', '0', '0'),
('9', '20', '1', '1', '01', '2018-02-08', '2018-03-30', '0', '0', '0', '1', '0', '0'),
('10', '20', '1', '2', '001', '2018-02-09', '2018-02-09', '0', '0', '0', '1', '0', '0'),
('11', '20', '1', '3', '001', '2018-02-09', '2018-02-09', '0', '0', '0', '1', '0', '0'),
('12', '20', '1', '2', '001', '2018-02-09', '2018-02-09', '81915.6', '0', '0', '1', '30000', '0'),
('13', '20', '4', '3', '001', '2018-02-22', '2018-02-22', '0', '0', '0', '1', '0', '0'),
('14', '20', '4', '4', '11270', '2018-02-22', '2018-02-22', '0', '0', '0', '1', '0', '0'),
('15', '20', '4', '5', '0011', '2018-02-22', '2018-02-22', '0', '0', '0', '1', '0', '0'),
('16', '20', '4', '6', '11270', '2018-02-22', '2018-02-22', '0', '0', '0', '1', '0', '0'),
('17', '20', '4', '7', '22', '2018-02-22', '2018-02-22', '0', '0', '0', '1', '0', '0'),
('18', '20', '4', '8', '12125', '2018-02-22', '2018-02-23', '0', '0', '0', '1', '0', '0'),
('19', '20', '3', '9', '3', '2018-02-23', '2018-03-17', '210', '0', '0', '1', '0', '0'),
('20', '20', '4', '10', '22', '2018-02-22', '2018-02-22', '0', '0', '0', '1', '0', '0'),
('21', '20', '4', '11', '12125', '2018-02-22', '2018-02-23', '0', '0', '0', '1', '0', '0'),
('22', '20', '4', '12', '22', '2018-02-22', '2018-02-22', '0', '0', '0', '1', '0', '0'),
('23', '20', '4', '13', '12125', '2018-02-22', '2018-02-23', '0', '0', '0', '1', '0', '0'),
('24', '20', '4', '12', '21654', '2018-02-23', '2018-02-23', '16720', '0', '0', '1', '0', '0'),
('25', '20', '4', '13', '5641654', '2018-02-23', '2018-02-23', '25046.8', '0', '0', '1', '0', '0'),
('26', '20', '6', '14', '11293', '2018-02-23', '2018-03-30', '12600', '0', '0', '1', '0', '0'),
('27', '20', '6', '15', '11293.', '2018-02-23', '2018-02-23', '30886', '0', '0', '1', '30886', '0'),
('1', '22', '4', '1', '', '2018-02-23', '2018-02-23', '0', '0', '0', '1', '0', '0'),
('2', '22', '1', '2', '', '2018-02-23', '2018-02-23', '-10000', '0', '0', '1', '10000', '0'),
('3', '22', '4', '3', '', '2018-02-23', '2018-02-23', '-16720', '0', '0', '1', '16720', '0'),
('4', '22', '4', '4', '', '2018-02-23', '2018-02-23', '-25046.8', '0', '0', '1', '25046.8', '0'),
('5', '22', '6', '5', '', '2018-02-23', '2018-02-23', '-30886', '0', '0', '1', '30886', '0');

### Structure of table `3_suppliers` ###

DROP TABLE IF EXISTS `3_suppliers`;

CREATE TABLE `3_suppliers` (
  `supplier_id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supp_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `gst_no` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supp_account_no` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `website` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  `dimension_id` int(11) DEFAULT '0',
  `dimension2_id` int(11) DEFAULT '0',
  `tax_group_id` int(11) DEFAULT NULL,
  `credit_limit` double NOT NULL DEFAULT '0',
  `purchase_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payable_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`supplier_id`),
  KEY `supp_ref` (`supp_ref`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_suppliers` ###

INSERT INTO `3_suppliers` VALUES
('1', 'M M Jaffna', 'M M Jaffna', '', '', '', '', '', '', '', 'LKR', '2', '0', '0', '0', '2', '1000000', '', '20000', '59500', '', '0'),
('2', 'M.C.Jaffna', '10432', '', '', '', '', '', '', '', 'LKR', '4', '0', '0', '2', '2', '0', '', '20000', '59500', '', '1'),
('3', 'v s jaffna', 'v s', '', '', '', '', '', '', '', 'LKR', '2', '0', '0', '0', '1', '0', '', '20000', '59500', '', '0'),
('4', 'X', 'X', 'COL 02', 'COL 02', '', '', '', '', '', 'LKR', '1', '0', '0', '0', '2', '0', '', '20000', '59500', '', '0'),
('5', 'VS Jaffna', 'VS Jaffna', 'Colombo 02', 'Colombo 02', '', '', '', '', '', 'LKR', '4', '0', '0', '0', '2', '0', '', '20000', '59500', '', '0'),
('6', 'VS Jaffna', 'VS Jaffna', 'Colombo 02', 'Colombo 02', '', '', '', '', '', 'LKR', '4', '0', '0', '0', '2', '0', '', '20000', '59500', '', '0'),
('7', 'S JAFFNA', 'S JAFFNA', '', '', '', '', '', '', '', 'LKR', '4', '0', '0', '0', '2', '0', '', '20000', '59500', '', '0');

### Structure of table `3_sys_prefs` ###

DROP TABLE IF EXISTS `3_sys_prefs`;

CREATE TABLE `3_sys_prefs` (
  `name` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `length` smallint(6) DEFAULT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`name`),
  KEY `category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_sys_prefs` ###

INSERT INTO `3_sys_prefs` VALUES
('accounts_alpha', 'glsetup.general', 'tinyint', '1', '0'),
('accumulate_shipping', 'glsetup.customer', 'tinyint', '1', '0'),
('add_pct', 'setup.company', 'int', '5', '-1'),
('allow_negative_prices', 'glsetup.inventory', 'tinyint', '1', '1'),
('allow_negative_stock', 'glsetup.inventory', 'tinyint', '1', '1'),
('alternative_tax_include_on_docs', 'setup.company', 'tinyint', '1', ''),
('auto_curr_reval', 'setup.company', 'smallint', '6', ''),
('bank_charge_act', 'glsetup.general', 'varchar', '15', '62000'),
('base_sales', 'setup.company', 'int', '11', '1'),
('bcc_email', 'setup.company', 'varchar', '100', ''),
('coy_logo', 'setup.company', 'varchar', '100', ''),
('coy_name', 'setup.company', 'varchar', '60', 'AT Group Demo'),
('coy_no', 'setup.company', 'varchar', '25', ''),
('creditors_act', 'glsetup.purchase', 'varchar', '15', '20000'),
('curr_default', 'setup.company', 'char', '3', 'LKR'),
('debtors_act', 'glsetup.sales', 'varchar', '15', '11000'),
('default_adj_act', 'glsetup.items', 'varchar', '15', '58500'),
('default_cogs_act', 'glsetup.items', 'varchar', '15', '50000'),
('default_credit_limit', 'glsetup.customer', 'int', '11', '1000000'),
('default_delivery_required', 'glsetup.sales', 'smallint', '6', '1'),
('default_dim_required', 'glsetup.dims', 'int', '11', '20'),
('default_inv_sales_act', 'glsetup.items', 'varchar', '15', '41000'),
('default_inventory_act', 'glsetup.items', 'varchar', '15', '12000'),
('default_loss_on_asset_disposal_act', 'glsetup.items', 'varchar', '15', '10000'),
('default_prompt_payment_act', 'glsetup.sales', 'varchar', '15', '49000'),
('default_quote_valid_days', 'glsetup.sales', 'smallint', '6', '30'),
('default_receival_required', 'glsetup.purchase', 'smallint', '6', '10'),
('default_sales_act', 'glsetup.sales', 'varchar', '15', '41000'),
('default_sales_discount_act', 'glsetup.sales', 'varchar', '15', '49000'),
('default_wip_act', 'glsetup.items', 'varchar', '15', '70000'),
('default_workorder_required', 'glsetup.manuf', 'int', '11', '20'),
('deferred_income_act', 'glsetup.sales', 'varchar', '15', ''),
('depreciation_period', 'glsetup.company', 'tinyint', '1', '1'),
('domicile', 'setup.company', 'varchar', '55', ''),
('email', 'setup.company', 'varchar', '100', ''),
('exchange_diff_act', 'glsetup.general', 'varchar', '15', '45400'),
('f_year', 'setup.company', 'int', '11', '11'),
('fax', 'setup.company', 'varchar', '30', ''),
('freight_act', 'glsetup.customer', 'varchar', '15', '45500'),
('gl_closing_date', 'setup.closing_date', 'date', '8', '2015-12-31'),
('grn_clearing_act', 'glsetup.purchase', 'varchar', '15', ''),
('gst_no', 'setup.company', 'varchar', '25', ''),
('legal_text', 'glsetup.customer', 'tinytext', '0', ''),
('loc_notification', 'glsetup.inventory', 'tinyint', '1', ''),
('login_tout', 'setup.company', 'smallint', '6', '600'),
('no_customer_list', 'setup.company', 'tinyint', '1', '0'),
('no_item_list', 'setup.company', 'tinyint', '1', '0'),
('no_supplier_list', 'setup.company', 'tinyint', '1', '0'),
('no_zero_lines_amount', 'glsetup.sales', 'tinyint', '1', ''),
('past_due_days', 'glsetup.general', 'int', '11', '30'),
('phone', 'setup.company', 'varchar', '30', ''),
('po_over_charge', 'glsetup.purchase', 'int', '11', '100'),
('po_over_receive', 'glsetup.purchase', 'int', '11', '100'),
('postal_address', 'setup.company', 'tinytext', '0', 'N/A'),
('print_invoice_no', 'glsetup.sales', 'tinyint', '1', '0'),
('print_item_images_on_quote', 'glsetup.inventory', 'tinyint', '1', ''),
('profit_loss_year_act', 'glsetup.general', 'varchar', '15', '90000'),
('pyt_discount_act', 'glsetup.purchase', 'varchar', '15', '59500'),
('retained_earnings_act', 'glsetup.general', 'varchar', '15', '35000'),
('round_to', 'setup.company', 'int', '5', '1'),
('show_po_item_codes', 'glsetup.purchase', 'tinyint', '1', ''),
('suppress_tax_rates', 'setup.company', 'tinyint', '1', ''),
('tax_algorithm', 'glsetup.customer', 'tinyint', '1', '1'),
('tax_last', 'setup.company', 'int', '11', '1'),
('tax_prd', 'setup.company', 'int', '11', '1'),
('time_zone', 'setup.company', 'tinyint', '1', '0'),
('use_dimension', 'setup.company', 'tinyint', '1', '2'),
('use_fixed_assets', 'setup.company', 'tinyint', '1', '1'),
('use_manufacturing', 'setup.company', 'tinyint', '1', '1'),
('version_id', 'system', 'varchar', '11', '2.4.1');

### Structure of table `3_sys_types` ###

DROP TABLE IF EXISTS `3_sys_types`;

CREATE TABLE `3_sys_types` (
  `type_id` smallint(6) NOT NULL DEFAULT '0',
  `type_no` int(11) NOT NULL DEFAULT '1',
  `next_reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_sys_types` ###

INSERT INTO `3_sys_types` VALUES
('0', '17', '1'),
('1', '7', '1'),
('2', '4', '1'),
('4', '3', '1'),
('10', '16', '1'),
('11', '2', '1'),
('12', '6', '1'),
('13', '1', '1'),
('16', '2', '1'),
('17', '2', '1'),
('18', '1', '1'),
('20', '6', '1'),
('21', '1', '1'),
('22', '3', '1'),
('25', '1', '1'),
('26', '1', '1'),
('28', '1', '1'),
('29', '1', '1'),
('30', '0', '1'),
('32', '0', '1'),
('35', '1', '1'),
('40', '1', '1');

### Structure of table `3_tag_associations` ###

DROP TABLE IF EXISTS `3_tag_associations`;

CREATE TABLE `3_tag_associations` (
  `record_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `tag_id` int(11) NOT NULL,
  UNIQUE KEY `record_id` (`record_id`,`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_tag_associations` ###


### Structure of table `3_tags` ###

DROP TABLE IF EXISTS `3_tags`;

CREATE TABLE `3_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_tags` ###


### Structure of table `3_tax_group_items` ###

DROP TABLE IF EXISTS `3_tax_group_items`;

CREATE TABLE `3_tax_group_items` (
  `tax_group_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `tax_shipping` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tax_group_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_tax_group_items` ###

INSERT INTO `3_tax_group_items` VALUES
('1', '1', '0');

### Structure of table `3_tax_groups` ###

DROP TABLE IF EXISTS `3_tax_groups`;

CREATE TABLE `3_tax_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_tax_groups` ###

INSERT INTO `3_tax_groups` VALUES
('1', 'Tax', '0'),
('2', 'Tax Exempt', '0');

### Structure of table `3_tax_types` ###

DROP TABLE IF EXISTS `3_tax_types`;

CREATE TABLE `3_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rate` double NOT NULL DEFAULT '0',
  `sales_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `purchasing_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_tax_types` ###

INSERT INTO `3_tax_types` VALUES
('1', '5', '23100', '23100', 'Tax', '0');

### Structure of table `3_trans_tax_details` ###

DROP TABLE IF EXISTS `3_trans_tax_details`;

CREATE TABLE `3_trans_tax_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `tran_date` date NOT NULL,
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '0',
  `ex_rate` double NOT NULL DEFAULT '1',
  `included_in_price` tinyint(1) NOT NULL DEFAULT '0',
  `net_amount` double NOT NULL DEFAULT '0',
  `amount` double NOT NULL DEFAULT '0',
  `memo` tinytext COLLATE utf8_unicode_ci,
  `reg_type` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Type_and_Number` (`trans_type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_trans_tax_details` ###

INSERT INTO `3_trans_tax_details` VALUES
('1', '20', '1', '2018-02-08', '0', '0', '1', '0', '0', '0', '01', '1'),
('2', '20', '2', '2018-02-08', '0', '0', '1', '0', '0', '0', '01', '1'),
('3', '20', '3', '2018-02-08', '0', '0', '1', '0', '0', '0', '01', '1'),
('4', '20', '4', '2018-02-08', '0', '0', '1', '0', '0', '0', '01', '1'),
('5', '20', '5', '2018-02-08', '0', '0', '1', '0', '0', '0', '01', '1'),
('6', '20', '6', '2018-02-08', '0', '0', '1', '0', '0', '0', '01', '1'),
('7', '20', '7', '2018-02-08', '0', '0', '1', '0', '0', '0', '01', '1'),
('8', '20', '8', '2018-02-08', '0', '0', '1', '0', '0', '0', '01', '1'),
('9', '20', '9', '2018-02-08', '0', '0', '1', '0', '0', '0', '01', '1'),
('10', '20', '10', '2018-02-09', '0', '0', '1', '0', '0', '0', '001', '1'),
('11', '13', '1', '2018-02-09', '0', '0', '1', '1', '0', '0', 'auto', NULL),
('12', '10', '1', '2018-02-09', '0', '0', '1', '1', '0', '0', '1', '0'),
('13', '13', '2', '2018-02-09', '0', '0', '1', '1', '0', '0', 'auto', NULL),
('14', '10', '2', '2018-02-09', '0', '0', '1', '1', '0', '0', '2', '0'),
('15', '13', '3', '2018-02-09', '0', '0', '1', '1', '14550', '0', 'auto', NULL),
('16', '10', '3', '2018-02-09', '0', '0', '1', '1', '0', '0', '3', '0'),
('17', '13', '4', '2018-02-09', '0', '0', '1', '1', '42110', '0', 'auto', NULL),
('18', '10', '4', '2018-02-09', '0', '0', '1', '1', '0', '0', '4', '0'),
('19', '10', '4', '2018-02-09', '0', '0', '1', '1', '42110', '0', '4', '0'),
('20', '10', '2', '2018-02-09', '0', '0', '1', '1', '0', '0', '2', '0'),
('21', '10', '3', '2018-02-09', '0', '0', '1', '1', '14550', '0', '3', '0'),
('22', '10', '1', '2018-02-09', '0', '0', '1', '1', '0', '0', '1', '0'),
('23', '10', '1', '2018-02-09', '0', '0', '1', '1', '0', '0', '1', '0'),
('24', '10', '1', '2018-02-09', '0', '0', '1', '1', '0', '0', '1', '0'),
('25', '10', '1', '2018-02-09', '0', '0', '1', '1', '0', '0', '1', '0'),
('26', '10', '2', '2018-02-09', '0', '0', '1', '1', '0', '0', '2', '0'),
('27', '13', '5', '2018-02-10', '0', '0', '1', '1', '0', '0', 'auto', NULL),
('28', '10', '5', '2018-02-10', '0', '0', '1', '1', '0', '0', '5', '0'),
('29', '10', '5', '2018-02-10', '0', '0', '1', '1', '0', '0', '5', '0'),
('30', '13', '6', '2018-02-10', '0', '0', '1', '1', '14840', '0', 'auto', NULL),
('31', '10', '6', '2018-02-10', '0', '0', '1', '1', '14840', '0', '5', '0'),
('32', '13', '7', '2018-02-10', '0', '0', '1', '1', '17340', '0', 'auto', NULL),
('33', '10', '7', '2018-02-10', '0', '0', '1', '1', '17340', '0', '6', '0'),
('34', '20', '11', '2018-02-09', '0', '0', '1', '0', '0', '0', '001', '1'),
('35', '20', '12', '2018-02-09', '0', '0', '1', '0', '88440', '0', '001', '1'),
('36', '13', '8', '2018-02-23', '0', '0', '1', '0', '8720', '0', 'auto', NULL),
('37', '10', '8', '2018-02-23', '0', '0', '1', '0', '0', '0', '7', '0'),
('38', '13', '9', '2018-02-22', '0', '0', '1', '0', '12790', '0', 'auto', NULL),
('39', '10', '9', '2018-02-22', '0', '0', '1', '0', '12790', '0', '8', '0'),
('40', '13', '10', '2018-02-23', '0', '0', '1', '0', '8140', '0', 'auto', NULL),
('41', '10', '10', '2018-02-23', '0', '0', '1', '0', '8140', '0', '9', '0'),
('42', '13', '11', '2018-02-23', '0', '0', '1', '0', '16940', '0', 'auto', NULL),
('43', '10', '11', '2018-02-23', '0', '0', '1', '0', '16940', '0', '10', '0'),
('44', '20', '13', '2018-02-22', '0', '0', '1', '0', '0', '0', '001', '1'),
('45', '20', '14', '2018-02-22', '0', '0', '1', '0', '0', '0', '11270', '1'),
('46', '20', '16', '2018-02-22', '0', '0', '1', '0', '0', '0', '11270', '1'),
('47', '20', '17', '2018-02-22', '0', '0', '1', '0', '0', '0', '22', '1'),
('48', '20', '18', '2018-02-22', '0', '0', '1', '0', '0', '0', '12125', '1'),
('49', '20', '19', '2018-02-23', '0', '0', '1', '0', '210', '0', '3', '1'),
('50', '13', '12', '2018-02-23', '0', '0', '1', '0', '200', '0', 'auto', NULL),
('51', '10', '12', '2018-02-23', '0', '0', '1', '0', '0', '0', '11', '0'),
('52', '10', '12', '2018-02-23', '0', '0', '1', '0', '200', '0', '11', '0'),
('53', '10', '8', '2018-02-23', '0', '0', '1', '0', '8720', '0', '7', '0'),
('54', '20', '20', '2018-02-22', '0', '0', '1', '0', '0', '0', '22', '1'),
('55', '20', '21', '2018-02-22', '0', '0', '1', '0', '0', '0', '12125', '1'),
('56', '20', '22', '2018-02-22', '0', '0', '1', '0', '0', '0', '22', '1'),
('57', '20', '23', '2018-02-22', '0', '0', '1', '0', '0', '0', '12125', '1'),
('58', '20', '24', '2018-02-23', '0', '0', '1', '0', '16720', '0', '21654', '1'),
('59', '20', '25', '2018-02-23', '0', '0', '1', '0', '29200', '0', '5641654', '1'),
('60', '13', '13', '2018-02-23', '0', '0', '1', '0', '36890', '0', 'auto', NULL),
('61', '10', '13', '2018-02-23', '0', '0', '1', '0', '36890', '0', '70257', '0'),
('62', '13', '14', '2018-02-23', '0', '0', '1', '1', '12660', '0', 'auto', NULL),
('63', '10', '14', '2018-02-23', '0', '0', '1', '1', '12660', '0', '70200', '0'),
('64', '20', '26', '2018-02-23', '0', '0', '1', '0', '12600', '0', '11293', '1'),
('65', '20', '27', '2018-02-23', '0', '0', '1', '0', '36700', '0', '11293.', '1');

### Structure of table `3_useronline` ###

DROP TABLE IF EXISTS `3_useronline`;

CREATE TABLE `3_useronline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` int(15) NOT NULL DEFAULT '0',
  `ip` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `file` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_useronline` ###


### Structure of table `3_users` ###

DROP TABLE IF EXISTS `3_users`;

CREATE TABLE `3_users` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `real_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `role_id` int(11) NOT NULL DEFAULT '1',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_format` tinyint(1) NOT NULL DEFAULT '0',
  `date_sep` tinyint(1) NOT NULL DEFAULT '0',
  `tho_sep` tinyint(1) NOT NULL DEFAULT '0',
  `dec_sep` tinyint(1) NOT NULL DEFAULT '0',
  `theme` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'default',
  `page_size` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'A4',
  `prices_dec` smallint(6) NOT NULL DEFAULT '2',
  `qty_dec` smallint(6) NOT NULL DEFAULT '2',
  `rates_dec` smallint(6) NOT NULL DEFAULT '4',
  `percent_dec` smallint(6) NOT NULL DEFAULT '1',
  `show_gl` tinyint(1) NOT NULL DEFAULT '1',
  `show_codes` tinyint(1) NOT NULL DEFAULT '0',
  `show_hints` tinyint(1) NOT NULL DEFAULT '0',
  `last_visit_date` datetime DEFAULT NULL,
  `query_size` tinyint(1) unsigned NOT NULL DEFAULT '10',
  `graphic_links` tinyint(1) DEFAULT '1',
  `pos` smallint(6) DEFAULT '1',
  `print_profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `rep_popup` tinyint(1) DEFAULT '1',
  `sticky_doc_date` tinyint(1) DEFAULT '0',
  `startup_tab` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `transaction_days` int(6) NOT NULL DEFAULT '30' COMMENT 'Transaction days',
  `save_report_selections` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Save Report Selection Days',
  `use_date_picker` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Use Date Picker for all Date Values',
  `def_print_destination` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Default Report Destination',
  `def_print_orientation` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Default Report Orientation',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_users` ###

INSERT INTO `3_users` VALUES
('1', 'admin', '21232f297a57a5a743894a0e4a801fc3', 'Administrator', '2', '', 'adm@adm.com', 'en_US', '0', '0', '0', '0', 'bluecollar', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2018-02-24 02:20:43', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0'),
('2', 'accountant', 'd2865faa2477b24ae02d23056bcc1a1c', 'testaccountant1', '9', '12335566', 'test@tesing.com', 'en_US', '0', '0', '0', '0', 'bluecollar', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2018-02-24 00:56:22', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0');

### Structure of table `3_voided` ###

DROP TABLE IF EXISTS `3_voided`;

CREATE TABLE `3_voided` (
  `type` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_voided` ###

INSERT INTO `3_voided` VALUES
('10', '1', '2018-02-10', ''),
('10', '2', '2018-02-10', ''),
('10', '5', '2018-02-10', ''),
('12', '1', '2018-02-10', ''),
('13', '1', '2018-02-10', ''),
('13', '2', '2018-02-10', ''),
('13', '5', '2018-02-10', ''),
('20', '1', '2018-02-08', 'Document reentered.'),
('20', '2', '2018-02-08', 'Document reentered.'),
('20', '3', '2018-02-09', 'Document reentered.'),
('20', '4', '2018-02-09', 'Document reentered.'),
('20', '5', '2018-02-09', 'Document reentered.'),
('20', '6', '2018-02-09', 'Document reentered.'),
('20', '7', '2018-02-09', 'Document reentered.'),
('20', '8', '2018-02-09', 'Document reentered.'),
('20', '9', '2018-02-09', ''),
('20', '10', '2018-02-10', 'Document reentered.'),
('20', '11', '2018-02-10', 'Document reentered.'),
('20', '13', '2018-02-22', ''),
('20', '14', '2018-02-22', 'Document reentered.'),
('20', '15', '2018-02-23', ''),
('20', '16', '2018-02-23', ''),
('20', '17', '2018-02-23', 'Document reentered.'),
('20', '18', '2018-02-23', 'Document reentered.'),
('20', '20', '2018-02-23', 'Document reentered.'),
('20', '21', '2018-02-23', 'Document reentered.'),
('20', '22', '2018-02-23', ''),
('20', '23', '2018-02-23', ''),
('22', '1', '2018-02-23', '');

### Structure of table `3_wo_costing` ###

DROP TABLE IF EXISTS `3_wo_costing`;

CREATE TABLE `3_wo_costing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `cost_type` tinyint(1) NOT NULL DEFAULT '0',
  `trans_type` int(11) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `factor` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_wo_costing` ###


### Structure of table `3_wo_issue_items` ###

DROP TABLE IF EXISTS `3_wo_issue_items`;

CREATE TABLE `3_wo_issue_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_id` int(11) DEFAULT NULL,
  `qty_issued` double DEFAULT NULL,
  `unit_cost` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_wo_issue_items` ###


### Structure of table `3_wo_issues` ###

DROP TABLE IF EXISTS `3_wo_issues`;

CREATE TABLE `3_wo_issues` (
  `issue_no` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workcentre_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`issue_no`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_wo_issues` ###


### Structure of table `3_wo_manufacture` ###

DROP TABLE IF EXISTS `3_wo_manufacture`;

CREATE TABLE `3_wo_manufacture` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_wo_manufacture` ###


### Structure of table `3_wo_requirements` ###

DROP TABLE IF EXISTS `3_wo_requirements`;

CREATE TABLE `3_wo_requirements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre` int(11) NOT NULL DEFAULT '0',
  `units_req` double NOT NULL DEFAULT '1',
  `unit_cost` double NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_issued` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_wo_requirements` ###


### Structure of table `3_workcentres` ###

DROP TABLE IF EXISTS `3_workcentres`;

CREATE TABLE `3_workcentres` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_workcentres` ###


### Structure of table `3_workorders` ###

DROP TABLE IF EXISTS `3_workorders`;

CREATE TABLE `3_workorders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wo_ref` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_reqd` double NOT NULL DEFAULT '1',
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `required_by` date NOT NULL DEFAULT '0000-00-00',
  `released_date` date NOT NULL DEFAULT '0000-00-00',
  `units_issued` double NOT NULL DEFAULT '0',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `released` tinyint(1) NOT NULL DEFAULT '0',
  `additional_costs` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `wo_ref` (`wo_ref`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_workorders` ###
