# MySQL dump of database 'demeland_evolve6' on host 'localhost'
# Backup Date and Time: 2016-11-02 06:43
# Built by EvolveAccounting EVOLVE360v6
# http://evolve-sl.com
# Company: Evolve Technologies
# User: Administrator

# Compatibility: 2.4.1


SET NAMES latin1;


### Structure of table `0_amortisation` ###

DROP TABLE IF EXISTS `0_amortisation`;

CREATE TABLE `0_amortisation` (
  `amortisation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `amortisation_year` int(11) DEFAULT NULL,
  `asset_value` double DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `posted` int(11) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`amortisation_id`),
  UNIQUE KEY `amortisation_id` (`amortisation_id`),
  KEY `0_amortisation_asset_id` (`asset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_amortisation` ###


### Structure of table `0_areas` ###

DROP TABLE IF EXISTS `0_areas`;

CREATE TABLE `0_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_areas` ###

INSERT INTO `0_areas` VALUES
('1', 'Global', '0'),
('2', 'colombo', '0');

### Structure of table `0_asset_types` ###

DROP TABLE IF EXISTS `0_asset_types`;

CREATE TABLE `0_asset_types` (
  `asset_type_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_type_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `depreciation_type` int(11) NOT NULL DEFAULT '1',
  `depreciation_rate` double NOT NULL DEFAULT '10',
  `asset_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `depreciation_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `accumulated_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `valuation_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `disposal_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_type_id`),
  UNIQUE KEY `asset_type_id` (`asset_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_asset_types` ###


### Structure of table `0_asset_valuations` ###

DROP TABLE IF EXISTS `0_asset_valuations`;

CREATE TABLE `0_asset_valuations` (
  `asset_valuation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `valuation_year` int(11) DEFAULT NULL,
  `asset_value` double NOT NULL DEFAULT '0',
  `value_change` double NOT NULL DEFAULT '0',
  `posted` int(11) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_valuation_id`),
  UNIQUE KEY `asset_valuation_id` (`asset_valuation_id`),
  UNIQUE KEY `asset_id` (`asset_id`,`valuation_year`),
  KEY `0_asset_valuations_asset_id` (`asset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_asset_valuations` ###


### Structure of table `0_assets` ###

DROP TABLE IF EXISTS `0_assets`;

CREATE TABLE `0_assets` (
  `asset_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_type_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `asset_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_serial` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `purchase_date` date NOT NULL,
  `purchase_value` double NOT NULL,
  `disposal_amount` double DEFAULT NULL,
  `disposal_date` date DEFAULT NULL,
  `disposal_posting` int(11) DEFAULT '0',
  `tag_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_location` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_condition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_acquisition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_id`),
  UNIQUE KEY `asset_id` (`asset_id`),
  KEY `0_assets_asset_type_id` (`asset_type_id`),
  KEY `0_assets_item_id` (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_assets` ###


### Structure of table `0_attachments` ###

DROP TABLE IF EXISTS `0_attachments`;

CREATE TABLE `0_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_no` int(11) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `unique_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT '0',
  `filetype` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attachments` ###


### Structure of table `0_audit_trail` ###

DROP TABLE IF EXISTS `0_audit_trail`;

CREATE TABLE `0_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `user` smallint(6) unsigned NOT NULL DEFAULT '0',
  `stamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL DEFAULT '0',
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_audit_trail` ###

INSERT INTO `0_audit_trail` VALUES
('1', '0', '1', '1', '2016-11-02 06:15:47', NULL, '1', '2016-03-31', NULL),
('2', '1', '1', '1', '2016-10-10 06:20:39', NULL, '2', '2016-04-04', NULL),
('3', '1', '2', '1', '2016-10-10 06:20:47', NULL, '2', '2016-04-05', NULL),
('4', '0', '2', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-01', '0'),
('5', '1', '1', '1', '2016-11-02 06:15:47', 'Voided.\n', '2', '2016-04-04', '0'),
('6', '1', '2', '1', '2016-11-02 06:15:47', 'Voided.\n', '2', '2016-04-05', '0'),
('7', '0', '1', '1', '2016-11-02 06:15:47', 'Voided.\n', '1', '2016-03-31', '0'),
('8', '0', '3', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-01', '0'),
('9', '0', '4', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-01', '0'),
('10', '0', '5', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-01', '0'),
('11', '0', '6', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-01', '0'),
('12', '0', '7', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-01', '0'),
('13', '0', '8', '1', '2016-10-17 03:12:51', NULL, '2', '2016-04-01', NULL),
('14', '0', '9', '1', '2016-10-17 03:15:26', NULL, '2', '2016-04-01', NULL),
('15', '0', '8', '1', '2016-11-02 06:15:47', NULL, '2', '2016-04-01', '0'),
('16', '0', '9', '1', '2016-11-02 06:15:47', NULL, '2', '2016-04-01', '0'),
('17', '0', '10', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-01', '0'),
('18', '0', '11', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-01', '0'),
('19', '0', '12', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-01', '0'),
('20', '0', '13', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-01', '0'),
('21', '0', '14', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-01', '0'),
('22', '1', '3', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-01', '0'),
('23', '1', '4', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-01', '0'),
('24', '1', '5', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-06', '0'),
('25', '1', '6', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-07', NULL),
('26', '1', '7', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-01', '0'),
('27', '1', '8', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-08', '0'),
('28', '1', '9', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-08', '0'),
('29', '1', '10', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-08', '0'),
('30', '1', '11', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-09', '0'),
('31', '1', '12', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-10', '0'),
('32', '1', '13', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-10', '0'),
('33', '1', '14', '1', '2016-10-24 05:07:09', NULL, '2', '2016-10-24', NULL),
('34', '1', '15', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-24', '0'),
('35', '1', '16', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-24', '0'),
('36', '1', '17', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-24', '0'),
('37', '1', '18', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-24', '0'),
('38', '1', '19', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-24', '0'),
('39', '1', '20', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-24', '0'),
('40', '1', '21', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-24', '0'),
('41', '1', '22', '1', '2016-10-24 06:05:04', NULL, '2', '2016-10-24', NULL),
('42', '1', '23', '1', '2016-10-24 04:53:01', NULL, '2', '2016-10-27', '0'),
('43', '1', '24', '1', '2016-10-24 04:54:37', NULL, '2', '2016-10-27', '0'),
('44', '1', '25', '1', '2016-10-24 04:55:39', NULL, '2', '2016-10-29', '0'),
('45', '1', '26', '1', '2016-10-24 04:57:37', NULL, '2', '2016-10-29', '0'),
('46', '1', '27', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-24', NULL),
('47', '1', '14', '1', '2016-10-24 05:07:09', 'Voided.\nDocument reentered.', '2', '2016-10-24', '0'),
('48', '1', '28', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-24', '0'),
('49', '1', '27', '1', '2016-11-02 06:15:47', 'Voided.\nDocument reentered.', '1', '2015-04-24', '0'),
('50', '1', '29', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-24', '0'),
('51', '1', '30', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-24', '0'),
('52', '1', '22', '1', '2016-10-24 06:05:04', 'Voided.\nDocument reentered.', '2', '2016-10-24', '0'),
('53', '1', '31', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-27', '0'),
('54', '1', '32', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-27', '0'),
('55', '1', '33', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-29', '0'),
('56', '1', '34', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-29', '0'),
('57', '1', '35', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-07', '0'),
('58', '1', '6', '1', '2016-11-02 06:15:47', 'Voided.\nDocument reentered.', '1', '2015-04-07', '0'),
('59', '2', '1', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-06', '0'),
('60', '2', '2', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-16', '0'),
('61', '2', '3', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-16', '0'),
('62', '2', '4', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-16', '0'),
('63', '2', '5', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-27', '0'),
('64', '2', '6', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-27', '0'),
('65', '2', '7', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-27', '0');

### Structure of table `0_bank_accounts` ###

DROP TABLE IF EXISTS `0_bank_accounts`;

CREATE TABLE `0_bank_accounts` (
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT '0',
  `bank_account_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_address` tinytext COLLATE utf8_unicode_ci,
  `bank_curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT '0',
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `bank_charge_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `bank_short_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_accounts` ###

INSERT INTO `0_bank_accounts` VALUES
('300', '1', 'Standared Chartered Bank', '01105356609', 'Standared Chartered Bank', NULL, 'LKR', '0', '1', '5690', '2015-04-30 00:00:00', '0', '0', 'SC'),
('301', '3', 'Petty Cash', '', 'Petty Cash', NULL, 'LKR', '0', '2', '5690', '0000-00-00 00:00:00', '0', '0', 'PC');

### Structure of table `0_bank_trans` ###

DROP TABLE IF EXISTS `0_bank_trans`;

CREATE TABLE `0_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ref` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `person_type_id` int(11) NOT NULL DEFAULT '0',
  `person_id` tinyblob,
  `reconciled` date DEFAULT NULL,
  `pay_mode` int(1) DEFAULT NULL,
  `cheque_no` int(6) DEFAULT NULL,
  `payment_increment` int(11) DEFAULT NULL,
  `payment_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_trans` ###

INSERT INTO `0_bank_trans` VALUES
('1', '1', '1', '1', '00001', '2016-04-04', '0', '0', '0', '0', 'Cash', NULL, '1', '134150', '1', 'SC/09/2016/P/1'),
('2', '1', '2', '1', '00002', '2016-04-05', '0', '0', '0', '0', 'Cash', NULL, '1', '134151', '2', 'SC/09/2016/P/2'),
('3', '0', '6', '1', '00005', '2015-04-01', '444986', '0', '0', '0', NULL, '2015-04-30', '0', '0', '0', NULL),
('4', '0', '6', '2', '00005', '2015-04-01', '10000', '0', '0', '0', NULL, NULL, '0', '0', '0', NULL),
('5', '1', '3', '1', '00002', '2015-04-01', '-7000', '0', '0', '0', 'Cash', NULL, '1', '47413', '3', 'SC/10/2016/P/3'),
('6', '1', '4', '1', '00003', '2015-04-01', '-561.2', '0', '0', '4', '2', NULL, '0', '47415', '4', 'SC/10/2016/P/4'),
('7', '1', '5', '1', '00004', '2015-04-06', '-35000', '0', '0', '0', NULL, '2015-04-30', '1', '47416', '5', 'SC/10/2016/P/5'),
('8', '1', '6', '1', '00005', '2015-04-07', '0', '0', '0', '0', 'Cash', NULL, '1', '47417', '6', 'SC/10/2016/P/6'),
('9', '1', '7', '1', '00006', '2015-04-01', '-800', '0', '0', '0', 'Cash', '2015-04-30', '1', '47414', '7', 'SC/10/2016/P/7'),
('10', '1', '8', '1', '00007', '2015-04-08', '-1017.85', '0', '0', '4', '3', NULL, '0', '47418', '8', 'SC/10/2016/P/8'),
('11', '1', '9', '1', '00008', '2015-04-08', '-16235', '0', '0', '4', '4', '2015-04-30', '0', '47419', '9', 'SC/10/2016/P/9'),
('12', '1', '10', '1', '00009', '2015-04-08', '-35000', '0', '0', '0', 'Cash', '2015-04-30', '1', '47420', '10', 'SC/10/2016/P/10'),
('13', '1', '11', '1', '00010', '2015-04-09', '-7280', '0', '0', '0', 'Office Networks (Pvt) Ltd', '2015-04-30', '0', '47421', '11', 'SC/10/2016/P/11'),
('14', '1', '12', '1', '00011', '2015-04-10', '-5000', '0', '0', '0', 'Cash', '2015-04-30', '1', '47422', '12', 'SC/10/2016/P/12'),
('15', '1', '13', '1', '00012', '2015-04-10', '-671.55', '0', '0', '4', '5', NULL, '0', '47423', '13', 'SC/10/2016/P/13'),
('16', '1', '14', '1', '00013', '2016-10-24', '0', '0', '0', '0', 'Cash', NULL, '1', '47425', '14', 'SC/10/2016/P/14'),
('17', '1', '15', '1', '00014', '2015-04-24', '-94135', '0', '0', '0', 'Cash', '2015-04-30', '1', '54401', '15', 'SC/10/2016/P/15'),
('18', '1', '16', '1', '00015', '2015-04-24', '-35186', '0', '0', '0', 'W.L.G.Kanchana', '2015-04-30', '0', '54402', '16', 'SC/10/2016/P/16'),
('19', '1', '17', '1', '00016', '2015-04-24', '-48707.2', '0', '0', '0', 'V.D.Jayasekera', '2015-04-30', '0', '54403', '17', 'SC/10/2016/P/17'),
('20', '1', '18', '1', '00017', '2015-04-24', '-23504', '0', '0', '0', 'G.A.D.K.Udeshini', '2015-04-30', '0', '54404', '18', 'SC/10/2016/P/18'),
('21', '1', '19', '1', '00018', '2015-04-24', '-42507', '0', '0', '0', 'H.L.De Mel &amp; Co. (Pvt) Ltd-P.P.F', '2015-04-30', '0', '54405', '19', 'SC/10/2016/P/19'),
('22', '1', '20', '1', '00019', '2015-04-24', '-6376.05', '0', '0', '4', '1', NULL, '0', '54406', '20', 'SC/10/2016/P/20'),
('23', '1', '21', '1', '00020', '2015-04-24', '-15500', '0', '0', '0', 'Cash', '2015-04-30', '1', '54407', '21', 'SC/10/2016/P/21'),
('24', '1', '22', '1', '00021', '2016-10-24', '0', '0', '0', '0', 'Cash', NULL, '1', '54408', '22', 'SC/10/2016/P/22'),
('25', '1', '23', '1', '00022', '2016-10-27', '-561.2', '0', '0', '4', '2', NULL, '0', '561', '23', 'SC/10/2016/P/23'),
('26', '1', '24', '1', '00023', '2016-10-27', '-24910.47', '0', '0', '4', '2', NULL, '0', '24910', '24', 'SC/10/2016/P/24'),
('27', '1', '25', '1', '00024', '2016-10-29', '-2100', '0', '0', '4', '1', NULL, '0', '54411', '25', 'SC/10/2016/P/25'),
('28', '1', '26', '1', '00025', '2016-10-29', '-20050', '0', '0', '4', '7', NULL, '0', '54412', '26', 'SC/10/2016/P/26'),
('29', '1', '27', '1', '00013', '2015-04-24', '0', '0', '0', '0', 'Cash', NULL, '0', '0', '27', 'SC/10/2016/P/27'),
('30', '1', '28', '1', '00013', '2015-04-24', '-2000', '0', '0', '0', 'Cash', '2015-04-30', '1', '47425', '28', 'SC/10/2016/P/28'),
('31', '1', '29', '1', '00026', '2015-04-24', '-24170.25', '0', '0', '4', '6', NULL, '1', '47424', '29', 'SC/10/2016/P/29'),
('32', '1', '30', '1', '00021', '2015-04-24', '-4000', '0', '0', '0', 'Cash', '2015-04-30', '1', '54408', '30', 'SC/10/2016/P/30'),
('33', '1', '31', '1', '00027', '2015-04-27', '-561.2', '0', '0', '4', '2', '2015-04-30', '0', '54409', '31', 'SC/10/2016/P/31'),
('34', '1', '32', '1', '00028', '2015-04-27', '-24910.47', '0', '0', '4', '2', '2015-04-30', '0', '54410', '32', 'SC/10/2016/P/32'),
('35', '1', '33', '1', '00029', '2015-04-29', '-2100', '0', '0', '4', '1', NULL, '0', '2100', '33', 'SC/10/2016/P/33'),
('36', '1', '34', '1', '00030', '2015-04-29', '-20050', '0', '0', '4', '7', '2015-04-30', '0', '54412', '34', 'SC/10/2016/P/34'),
('37', '1', '35', '1', '00005', '2015-04-07', '-85500', '0', '0', '0', 'Cash', '2015-04-30', '1', '47417', '35', 'SC/10/2016/P/35'),
('38', '2', '1', '1', '00001', '2015-04-06', '15000', '0', '0', '0', 'Tuder V Perera &amp; Co.', '2015-04-30', '0', '0', '1', 'SC/10/2016/D/1'),
('39', '2', '2', '1', '00002', '2015-04-16', '130000', '0', '0', '0', 'Inter Company', '2015-04-30', '0', '0', '2', 'SC/10/2016/D/2'),
('40', '2', '3', '1', '00003', '2015-04-16', '102869.4', '0', '0', '0', 'H.L.De Mel &amp; Co', '2015-04-30', '0', '0', '3', 'SC/10/2016/D/3'),
('41', '2', '4', '1', '00004', '2015-04-16', '1878.98', '0', '0', '0', 'Commercial Bank Of Ceylon PLC', '2015-04-30', '0', '0', '4', 'SC/10/2016/D/4'),
('42', '2', '5', '1', '00005', '2015-04-27', '4993.15', '0', '0', '0', 'Sampath Bank', NULL, '0', '0', '5', 'SC/10/2016/D/5'),
('43', '2', '6', '1', '00006', '2015-04-27', '4993.15', '0', '0', '0', 'Sampath Bank', NULL, '0', '0', '6', 'SC/10/2016/D/6'),
('44', '2', '7', '1', '00007', '2015-04-27', '4993.15', '0', '0', '0', 'Sampath Bank', NULL, '0', '0', '7', 'SC/10/2016/D/7');

### Structure of table `0_bom` ###

DROP TABLE IF EXISTS `0_bom`;

CREATE TABLE `0_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `component` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT '1',
  `budjet_cost` double NOT NULL,
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bom` ###


### Structure of table `0_budget_trans` ###

DROP TABLE IF EXISTS `0_budget_trans`;

CREATE TABLE `0_budget_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `dimension_id` int(11) DEFAULT '0',
  `dimension2_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_budget_trans` ###


### Structure of table `0_chart_class` ###

DROP TABLE IF EXISTS `0_chart_class`;

CREATE TABLE `0_chart_class` (
  `cid` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `class_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_class` ###

INSERT INTO `0_chart_class` VALUES
('1', 'Assets', '1', '0'),
('2', 'Liabilities', '2', '0'),
('3', 'Income', '4', '0'),
('4', 'Expenses', '6', '0'),
('5', 'Equity', '3', '0');

### Structure of table `0_chart_master` ###

DROP TABLE IF EXISTS `0_chart_master`;

CREATE TABLE `0_chart_master` (
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_code2` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_master` ###

INSERT INTO `0_chart_master` VALUES
('0001', '', 'Building', '1.2', '0'),
('0002', '', 'Fans', '1.2', '0'),
('0003', '', 'Television', '1.2', '0'),
('0004', '', 'Air Conditioner', '1.2', '0'),
('0005', '', 'Office Equipment', '1.2', '0'),
('0006', '', 'Vacume cleaner', '1.2', '0'),
('0007', '', 'Generator', '1.2', '0'),
('0008', '', 'Motor Bike', '1.2', '0'),
('0009', '', 'Foot Bicycle', '1.2', '0'),
('0010', '', 'Fax &amp; Printer', '1.2', '0'),
('0011', '', 'Mobile Phone', '1.2', '0'),
('0012', '', 'Trailer', '1.2', '0'),
('0013', '', 'Rotor Slasher', '1.2', '0'),
('0014', '', 'Computer', '1.2', '0'),
('0050', '', 'Tokyo Cement-Shares', '1.3', '0'),
('0051', '', 'Commercial Bank- Shares', '1.3', '0'),
('0052', '', 'Expo Lanka Ltd -Shares', '1.3', '0'),
('0100', '', 'Sampath Bank - Fixed Deposit', '1.4', '0'),
('0150', '', 'Life Membership', '1', '0'),
('0200', '', 'Restaurant Project', '1', '0'),
('0250', '', 'Tax Receivable', '2.1', '0'),
('0251', '', 'Fixed Deposit Interest Receivable', '2.1', '0'),
('0252', '', 'Sundry Debtors', '2.1', '0'),
('0253', '', 'Secretarial Fees Receivable', '2.1', '0'),
('0254', '', 'Galpothayaya Estate', '2.1', '0'),
('0255', '', 'Diyathure II', '2.1', '0'),
('0256', '', 'Funds Transfer', '2.1', '0'),
('0257', '', 'Water Reimbursement Receivable', '2.1', '0'),
('0258', '', 'Electricity Reimbursement Receivable', '2.1', '0'),
('0259', '', 'Festival Advance', '2.1', '0'),
('0350', '', 'Estate Superintendent', '3.1', '0'),
('0351', '', 'Dividend Payable', '3.1', '0'),
('0352', '', 'Audit Fees Payable', '3.1', '0'),
('0353', '', 'Telephone Payable', '3.1', '0'),
('0354', '', 'PAYE Payable', '3.1', '0'),
('0400', '', 'Share Capital', '4', '0'),
('0450', '', 'General Reserve', '5', '0'),
('0451', '', 'Retained Profit', '5', '0'),
('0500', '', 'Temporaly Loan', '2', '0'),
('0550', '', 'Refundable Deposit', '2', '0'),
('0600', '', 'Raththarankotuwa Trust', '2.5', '0'),
('0601', '', 'Diyathure I Estate', '2.5', '0'),
('0602', '', 'Diyathure II Estate', '2.5', '0'),
('0603', '', 'Diyathure III Estate', '2.5', '0'),
('0604', '', 'Millawana Estate', '2.5', '0'),
('0605', '', 'Ragedara Estate', '2.5', '0'),
('0606', '', 'Walpolayaya Estate', '2.5', '0'),
('0607', '', 'Marandawila Estate', '2.5', '0'),
('0608', '', 'Jacob De Mel Trust', '2.5', '0'),
('0609', '', 'Marandapitiya Estate', '2.5', '0'),
('0610', '', 'Dematagolla Estate', '2.5', '0'),
('0611', '', 'Share of Profit Receivable', '2.5', '0'),
('0650', '', 'H.L.De Mel &amp; Co. ', '3.2', '0'),
('0651', '', 'Galpothayaya Estate', '3.2', '0'),
('0652', '', 'Pothuwewa Estate', '3.2', '0'),
('300', '', 'Standard Chartered Bank', '2.2', '0'),
('301', '', 'Petty Cash', '2.2', '0'),
('4000', '', 'Agent Commission', '6', '0'),
('4050', '', 'Rent Income', '6.2', '0'),
('4051', '', 'Head Office &amp; Sub Office Income', '6.2', '0'),
('4100', '', 'Dividend Income', '6', '0'),
('4151', '', 'Donation', '7', '0'),
('4152', '', 'Directors Traveling', '7', '0'),
('4153', '', 'Newspapers &amp; Periodicals', '7', '0'),
('4154', '', 'Seasonal Gift', '7', '0'),
('4155', '', 'Television Bill', '7', '0'),
('4156', '', 'Depreciation', '7', '0'),
('4157', '', 'Company Registration Fees', '7', '0'),
('4158', '', 'Secretarial Fees', '7', '0'),
('4159', '', 'Gratuity', '7', '0'),
('4160', '', 'Overtime', '7', '0'),
('4161', '', 'Surcharge', '7', '0'),
('4162', '', 'Entertaining Charges ', '7', '0'),
('4163', '', 'Tea Expenses', '7', '0'),
('4164', '', 'Office Cleaning Expenses', '7', '0'),
('4165', '', 'Traveling expenses', '7', '0'),
('4166', '', 'Salary', '7', '0'),
('4300', '', 'FD Interest Income', '8', '0'),
('4350', '', 'Bank Charges', '9', '0'),
('4351', '', 'W.H.T', '8', '0'),
('6167', '', 'Advertisment Charges', '7', '0'),
('6168', '', 'Bonus &amp; Exgratia', '7', '0'),
('6169', '', 'Compensation', '7', '0'),
('6170', '', 'Electricity', '7', '0'),
('6171', '', 'E.T.F', '7', '0'),
('6172', '', 'Income Tax', '7', '0'),
('6173', '', 'Insurance', '7', '0'),
('6174', '', 'Newspaper &amp; Periodicals', '7', '0'),
('6175', '', 'Office Equipment Maintenance', '7', '0'),
('6176', '', 'Office Expenses', '7', '0'),
('6177', '', 'Postage', '7', '0'),
('6178', '', 'P.P.F', '7', '0'),
('6179', '', 'Printing &amp; Stationery', '7', '0'),
('6180', '', 'Professional Fees', '7', '0'),
('6181', '', 'Reimbursement of Traveling', '7', '0'),
('6182', '', 'Reimbursement of Mobile Charges', '7', '0'),
('6183', '', 'Staff Welfare', '7', '0'),
('6184', '', 'Sundry Expenses', '7', '0'),
('6185', '', 'Telephone Charges', '7', '0'),
('6186', '', 'Water', '7', '0');

### Structure of table `0_chart_types` ###

DROP TABLE IF EXISTS `0_chart_types`;

CREATE TABLE `0_chart_types` (
  `id` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `class_id` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '-1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_types` ###

INSERT INTO `0_chart_types` VALUES
('1', 'Non current assets', '1', '', '0'),
('1.2', 'Property Plant &amp; Equipment', '1', '1', '0'),
('1.3', 'Investments on Shares', '1', '1', '0'),
('1.4', 'Fixed Deposits', '1', '1', '0'),
('2', 'Current Asset', '1', '', '0'),
('2.1', 'Other Receivables', '1', '2', '0'),
('2.2', 'Cash &amp; Cash Equivalents', '1', '2', '0'),
('2.3', 'Temporary Loan', '1', '2', '0'),
('2.4', 'Refundable Deposit', '1', '2', '0'),
('2.5', 'Amounts Due From Related Parties', '1', '2', '0'),
('3', 'Current Liability', '2', '', '0'),
('3.1', 'Other Payables', '2', '3', '0'),
('3.2', 'Amounts Due to Related Parties', '2', '3', '0'),
('4', 'Equity &amp;  Liabilities', '5', '', '0'),
('5', 'Reserve &amp; Surpuls', '5', '', '0'),
('6', 'Revenue', '3', '', '0'),
('6.1', 'Agent Commission', '3', '6', '0'),
('6.2', 'Other Operating Income', '3', '6', '0'),
('6.3', 'Restaurant Project Profit or Loss', '3', '6', '0'),
('7', 'Administrative Expenses', '4', '', '0'),
('8', 'Finance Income', '3', '', '0'),
('9', 'Finance Cost', '4', '', '0');

### Structure of table `0_comments` ###

DROP TABLE IF EXISTS `0_comments`;

CREATE TABLE `0_comments` (
  `type` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_comments` ###


### Structure of table `0_credit_status` ###

DROP TABLE IF EXISTS `0_credit_status`;

CREATE TABLE `0_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_credit_status` ###

INSERT INTO `0_credit_status` VALUES
('1', 'Good History', '0', '0'),
('3', 'No more work until payment received', '1', '0'),
('4', 'In liquidation', '1', '0');

### Structure of table `0_crm_categories` ###

DROP TABLE IF EXISTS `0_crm_categories`;

CREATE TABLE `0_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `system` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_categories` ###

INSERT INTO `0_crm_categories` VALUES
('1', 'cust_branch', 'general', 'General', 'General contact data for customer branch (overrides company setting)', '1', '0'),
('2', 'cust_branch', 'invoice', 'Invoices', 'Invoice posting (overrides company setting)', '1', '0'),
('3', 'cust_branch', 'order', 'Orders', 'Order confirmation (overrides company setting)', '1', '0'),
('4', 'cust_branch', 'delivery', 'Deliveries', 'Delivery coordination (overrides company setting)', '1', '0'),
('5', 'customer', 'general', 'General', 'General contact data for customer', '1', '0'),
('6', 'customer', 'order', 'Orders', 'Order confirmation', '1', '0'),
('7', 'customer', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('8', 'customer', 'invoice', 'Invoices', 'Invoice posting', '1', '0'),
('9', 'supplier', 'general', 'General', 'General contact data for supplier', '1', '0'),
('10', 'supplier', 'order', 'Orders', 'Order confirmation', '1', '0'),
('11', 'supplier', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('12', 'supplier', 'invoice', 'Invoices', 'Invoice posting', '1', '0');

### Structure of table `0_crm_contacts` ###

DROP TABLE IF EXISTS `0_crm_contacts`;

CREATE TABLE `0_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT '0' COMMENT 'foreign key to crm_contacts',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `entity_id` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_contacts` ###

INSERT INTO `0_crm_contacts` VALUES
('1', '1', 'cust_branch', 'general', '1'),
('2', '2', 'supplier', 'general', '1'),
('3', '3', 'cust_branch', 'general', '2');

### Structure of table `0_crm_persons` ###

DROP TABLE IF EXISTS `0_crm_persons`;

CREATE TABLE `0_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `name2` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` tinytext COLLATE utf8_unicode_ci,
  `phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone2` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lang` char(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_persons` ###

INSERT INTO `0_crm_persons` VALUES
('1', 'Tuder V Perera &amp; Co', 'TVP', NULL, 'No -103,Chatham Street,Colombo 01', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2', 'Sri lanka Telecom', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('3', 'Dilshee', 'Dilshee', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0');

### Structure of table `0_currencies` ###

DROP TABLE IF EXISTS `0_currencies`;

CREATE TABLE `0_currencies` (
  `currency` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `auto_update` tinyint(1) NOT NULL DEFAULT '1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_currencies` ###

INSERT INTO `0_currencies` VALUES
('Sri Lanka Rupee', 'LKR', 'Rs', 'Sri Lanka', 'Cents', '1', '0');

### Structure of table `0_cust_allocations` ###

DROP TABLE IF EXISTS `0_cust_allocations`;

CREATE TABLE `0_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_allocations` ###


### Structure of table `0_cust_branch` ###

DROP TABLE IF EXISTS `0_cust_branch`;

CREATE TABLE `0_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `br_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `branch_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `br_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT '0',
  `default_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `receivables_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT '1',
  `br_post_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT '0',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `bank_account` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_branch` ###

INSERT INTO `0_cust_branch` VALUES
('1', '1', 'TVP', 'TVP', 'No -103,Chatham Street,Colombo 01', '2', '3', '', '2', '', '0150', '6170', '0150', '1', 'No -103,Chatham Street,Colombo 01', '0', '', NULL, '0'),
('2', '2', 'Dilshee', 'Dilshee', '', '2', '3', '', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0');

### Structure of table `0_debtor_trans` ###

DROP TABLE IF EXISTS `0_debtor_trans`;

CREATE TABLE `0_debtor_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `version` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `debtor_no` int(11) unsigned NOT NULL,
  `branch_code` int(11) NOT NULL DEFAULT '-1',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT '0',
  `order_` int(11) NOT NULL DEFAULT '0',
  `ov_amount` double NOT NULL DEFAULT '0',
  `ov_gst` double NOT NULL DEFAULT '0',
  `ov_freight` double NOT NULL DEFAULT '0',
  `ov_freight_tax` double NOT NULL DEFAULT '0',
  `ov_discount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  `ship_via` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `done_by` int(2) DEFAULT NULL,
  PRIMARY KEY (`type`,`trans_no`,`debtor_no`),
  KEY `debtor_no` (`debtor_no`,`branch_code`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans` ###


### Structure of table `0_debtor_trans_details` ###

DROP TABLE IF EXISTS `0_debtor_trans_details`;

CREATE TABLE `0_debtor_trans_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_trans_no` int(11) DEFAULT NULL,
  `debtor_trans_type` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `unit_price` double NOT NULL DEFAULT '0',
  `unit_tax` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `discount_percent` double NOT NULL DEFAULT '0',
  `standard_cost` double NOT NULL DEFAULT '0',
  `qty_done` double NOT NULL DEFAULT '0',
  `src_id` int(11) NOT NULL,
  `done_by` int(2) DEFAULT NULL,
  `line_location` char(15) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`debtor_trans_type`,`debtor_trans_no`),
  KEY `src_id` (`src_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans_details` ###


### Structure of table `0_debtors_master` ###

DROP TABLE IF EXISTS `0_debtors_master`;

CREATE TABLE `0_debtors_master` (
  `debtor_no` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `debtor_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `address` tinytext COLLATE utf8_unicode_ci,
  `tax_id` varchar(55) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type` int(11) NOT NULL DEFAULT '1',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `credit_status` int(11) NOT NULL DEFAULT '0',
  `payment_terms` int(11) DEFAULT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `pymt_discount` double NOT NULL DEFAULT '0',
  `credit_limit` float NOT NULL DEFAULT '1000',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `crm_no` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`debtor_no`),
  UNIQUE KEY `debtor_ref` (`debtor_ref`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtors_master` ###

INSERT INTO `0_debtors_master` VALUES
('1', 'Tuder V Perera &amp; Co', 'TVP', 'No -103,Chatham Street,Colombo 01', '', 'LKR', '1', '0', '0', '1', '0', '0', '0', '0', '', '0', ''),
('2', 'Dilshee', 'Dilshee', NULL, '', 'LKR', '1', '0', '0', '1', '1', '0', '0', '1000000', '', '0', '');

### Structure of table `0_dimensions` ###

DROP TABLE IF EXISTS `0_dimensions`;

CREATE TABLE `0_dimensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_` tinyint(1) NOT NULL DEFAULT '1',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  KEY `date_` (`date_`),
  KEY `due_date` (`due_date`),
  KEY `type_` (`type_`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_dimensions` ###

INSERT INTO `0_dimensions` VALUES
('1', '00001', 'Golden Palm Rest', '1', '0', '2016-09-23', '2016-10-13');

### Structure of table `0_exchange_rates` ###

DROP TABLE IF EXISTS `0_exchange_rates`;

CREATE TABLE `0_exchange_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rate_buy` double NOT NULL DEFAULT '0',
  `rate_sell` double NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `curr_code` (`curr_code`,`date_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_exchange_rates` ###


### Structure of table `0_fiscal_year` ###

DROP TABLE IF EXISTS `0_fiscal_year`;

CREATE TABLE `0_fiscal_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `begin` date DEFAULT '0000-00-00',
  `end` date DEFAULT '0000-00-00',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `begin` (`begin`),
  UNIQUE KEY `end` (`end`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_fiscal_year` ###

INSERT INTO `0_fiscal_year` VALUES
('1', '2015-04-01', '2016-03-31', '0'),
('2', '2016-04-01', '2017-03-31', '0');

### Structure of table `0_gl_trans` ###

DROP TABLE IF EXISTS `0_gl_trans`;

CREATE TABLE `0_gl_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT '0',
  `type_no` int(11) NOT NULL DEFAULT '0',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `amount` double NOT NULL DEFAULT '0',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob,
  `cheque_no` int(6) DEFAULT NULL,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `dimension_id` (`dimension_id`),
  KEY `dimension2_id` (`dimension2_id`),
  KEY `tran_date` (`tran_date`),
  KEY `account_and_tran_date` (`account`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=171 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_gl_trans` ###

INSERT INTO `0_gl_trans` VALUES
('1', '0', '1', '2016-03-31', '0350', '', '0', '0', '0', NULL, NULL, '0'),
('2', '0', '1', '2016-03-31', '0003', 'opening balance', '0', '0', '0', NULL, NULL, '0'),
('3', '1', '1', '2016-04-04', '4151', 'New Year Gift to Mr Nillegoda ', '0', '0', '0', NULL, NULL, '134150'),
('4', '1', '1', '2016-04-04', '300', '', '0', '0', '0', NULL, NULL, '134150'),
('5', '1', '2', '2016-04-05', '4165', 'Driver&#039;s salary advance April 2016', '0', '0', '0', NULL, NULL, '134151'),
('6', '1', '2', '2016-04-05', '300', '', '0', '0', '0', NULL, NULL, '134151'),
('7', '0', '2', '2015-04-01', '0100', 'Binning Balance as at 2015/04/01', '4556544', '0', '0', NULL, NULL, '0'),
('8', '0', '2', '2015-04-01', '0451', 'Binning Balance as at 2015/04/01', '-4556544', '0', '0', NULL, NULL, '0'),
('9', '0', '3', '2015-04-01', '0050', 'Beginning Balance As at 2015/04/01', '137148', '0', '0', NULL, NULL, '0'),
('10', '0', '3', '2015-04-01', '0051', 'Beginning Balance As at 2015/04/01', '301950', '0', '0', NULL, NULL, '0'),
('11', '0', '3', '2015-04-01', '0052', 'Beginning Balance As at 2015/04/01', '59500', '0', '0', NULL, NULL, '0'),
('12', '0', '3', '2015-04-01', '0451', 'Beginning Balance As at 2015/04/01', '-498598', '0', '0', NULL, NULL, '0'),
('13', '0', '4', '2015-04-01', '0001', 'Beginning balance as at 01/04/2015', '5249300', '0', '0', NULL, NULL, '0'),
('14', '0', '4', '2015-04-01', '0005', 'Beginning balance as at 01/04/2015', '256712', '0', '0', NULL, NULL, '0'),
('15', '0', '4', '2015-04-01', '0002', 'Beginning balance as at 01/04/2015', '8218', '0', '0', NULL, NULL, '0'),
('16', '0', '4', '2015-04-01', '0003', 'Beginning balance as at 01/04/2015', '27131', '0', '0', NULL, NULL, '0'),
('17', '0', '4', '2015-04-01', '0004', 'Beginning balance as at 01/04/2015', '36467', '0', '0', NULL, NULL, '0'),
('18', '0', '4', '2015-04-01', '0006', 'Beginning balance as at 01/04/2015', '8038', '0', '0', NULL, NULL, '0'),
('19', '0', '4', '2015-04-01', '0007', 'Beginning balance as at 01/04/2015', '17031', '0', '0', NULL, NULL, '0'),
('20', '0', '4', '2015-04-01', '0008', 'Beginning balance as at 01/04/2015', '48161', '0', '0', NULL, NULL, '0'),
('21', '0', '4', '2015-04-01', '0009', 'Beginning balance as at 01/04/2015', '1026', '0', '0', NULL, NULL, '0'),
('22', '0', '4', '2015-04-01', '0010', 'Beginning balance as at 01/04/2015', '16045', '0', '0', NULL, NULL, '0'),
('23', '0', '4', '2015-04-01', '0011', 'Beginning balance as at 01/04/2015', '8981', '0', '0', NULL, NULL, '0'),
('24', '0', '4', '2015-04-01', '0012', 'Beginning balance as at 01/04/2015', '46173', '0', '0', NULL, NULL, '0'),
('25', '0', '4', '2015-04-01', '0013', 'Beginning balance as at 01/04/2015', '19661', '0', '0', NULL, NULL, '0'),
('26', '0', '4', '2015-04-01', '0014', 'Beginning balance as at 01/04/2015', '159781', '0', '0', NULL, NULL, '0'),
('27', '0', '4', '2015-04-01', '0451', 'Beginning balance as at 01/04/2015', '-5902725', '0', '0', NULL, NULL, '0'),
('28', '0', '5', '2015-04-01', '0250', 'Beginning balance as at 01/04/15', '74605', '0', '0', NULL, NULL, '0'),
('29', '0', '5', '2015-04-01', '0251', 'Beginning balance as at 01/04/15', '83330', '0', '0', NULL, NULL, '0'),
('30', '0', '5', '2015-04-01', '0252', 'Beginning balance as at 01/04/15', '78956', '0', '0', NULL, NULL, '0'),
('31', '0', '5', '2015-04-01', '0253', 'Beginning balance as at 01/04/15', '750', '0', '0', NULL, NULL, '0'),
('32', '0', '5', '2015-04-01', '0256', 'Beginning balance as at 01/04/15', '76338', '0', '0', NULL, NULL, '0'),
('33', '0', '5', '2015-04-01', '0257', 'Beginning balance as at 01/04/15', '152127', '0', '0', NULL, NULL, '0'),
('34', '0', '5', '2015-04-01', '0258', 'Beginning balance as at 01/04/15', '50354', '0', '0', NULL, NULL, '0'),
('35', '0', '5', '2015-04-01', '0451', 'Beginning balance as at 01/04/15', '-516460', '0', '0', NULL, NULL, '0'),
('36', '0', '6', '2015-04-01', '300', 'Beginning balance as at 01/04/15', '444986', '0', '0', NULL, NULL, '0'),
('37', '0', '6', '2015-04-01', '301', 'Beginning balance as at 01/04/15', '10000', '0', '0', NULL, NULL, '0'),
('38', '0', '6', '2015-04-01', '0451', 'Beginning balance as at 01/04/15', '-454986', '0', '0', NULL, NULL, '0'),
('39', '0', '7', '2015-04-01', '0350', 'Beginning balance as at 01/04/15', '-43281', '0', '0', NULL, NULL, '0'),
('40', '0', '7', '2015-04-01', '0351', 'Beginning balance as at 01/04/15', '-420000', '0', '0', NULL, NULL, '0'),
('41', '0', '7', '2015-04-01', '0352', 'Beginning balance as at 01/04/15', '-64000', '0', '0', NULL, NULL, '0'),
('42', '0', '7', '2015-04-01', '0353', 'Beginning balance as at 01/04/15', '-26704', '0', '0', NULL, NULL, '0'),
('43', '0', '7', '2015-04-01', '0354', 'Beginning balance as at 01/04/15', '-96', '0', '0', NULL, NULL, '0'),
('44', '0', '7', '2015-04-01', '0451', 'Beginning balance as at 01/04/15', '554081', '0', '0', NULL, NULL, '0'),
('45', '0', '8', '2016-04-01', '0150', 'Beginning balance as at 01/04/2015', '0', '0', '0', NULL, NULL, '0'),
('46', '0', '8', '2016-04-01', '0200', 'Beginning balance as at 01/04/2015', '0', '0', '0', NULL, NULL, '0'),
('47', '0', '8', '2016-04-01', '0451', 'Beginning balance as at 01/04/2015', '0', '0', '0', NULL, NULL, '0'),
('48', '0', '9', '2016-04-01', '0500', 'Beginning balance as at 01/04/15', '0', '0', '0', NULL, NULL, '0'),
('49', '0', '9', '2016-04-01', '0550', 'Beginning balance as at 01/04/15', '0', '0', '0', NULL, NULL, '0'),
('50', '0', '9', '2016-04-01', '0451', 'Beginning balance as at 01/04/15', '0', '0', '0', NULL, NULL, '0'),
('51', '0', '8', '2015-04-01', '0150', 'Beginning balance as at 01/04/2015', '100000', '0', '0', NULL, NULL, '0'),
('52', '0', '8', '2015-04-01', '0200', 'Beginning balance as at 01/04/2015', '4257312', '0', '0', NULL, NULL, '0'),
('53', '0', '8', '2015-04-01', '0451', 'Beginning balance as at 01/04/2015', '-4357312', '0', '0', NULL, NULL, '0'),
('54', '0', '9', '2015-04-01', '0500', 'Beginning balance as at 01/04/15', '12500', '0', '0', NULL, NULL, '0'),
('55', '0', '9', '2015-04-01', '0550', 'Beginning balance as at 01/04/15', '45804', '0', '0', NULL, NULL, '0'),
('56', '0', '9', '2015-04-01', '0451', 'Beginning balance as at 01/04/15', '-58304', '0', '0', NULL, NULL, '0'),
('57', '0', '10', '2015-04-01', '0400', 'Beginning balance as at 01/04/15', '-30', '0', '0', NULL, NULL, '0'),
('58', '0', '10', '2015-04-01', '0450', 'Beginning balance as at 01/04/15', '-750000', '0', '0', NULL, NULL, '0'),
('59', '0', '10', '2015-04-01', '0451', 'Beginning balance as at 01/04/15', '750030', '0', '0', NULL, NULL, '0'),
('60', '0', '11', '2015-04-01', '0611', 'Beginning balance as at 01/04/2015', '974578', '0', '0', NULL, NULL, '0'),
('61', '0', '11', '2015-04-01', '0451', 'Beginning balance as at 01/04/2015', '-974578', '0', '0', NULL, NULL, '0'),
('62', '0', '12', '2015-04-01', '0652', 'Beginning balance as at 01/04/15', '-142874', '0', '0', NULL, NULL, '0'),
('63', '0', '12', '2015-04-01', '0451', 'Beginning balance as at 01/04/15', '142874', '0', '0', NULL, NULL, '0'),
('64', '0', '13', '2015-04-01', '0650', 'Beginning balance as at 01/04/15', '-2612558', '0', '0', NULL, NULL, '0'),
('65', '0', '13', '2015-04-01', '0651', 'Beginning balance as at 01/04/15', '-169886', '0', '0', NULL, NULL, '0'),
('66', '0', '13', '2015-04-01', '0451', 'Beginning balance as at 01/04/15', '2782444', '0', '0', NULL, NULL, '0'),
('67', '0', '14', '2015-04-01', '0610', 'Biginning balance as at 01/04/2015', '500509', '0', '0', NULL, NULL, '0'),
('68', '0', '14', '2015-04-01', '0600', 'Biginning balance as at 01/04/2015', '1129422', '0', '0', NULL, NULL, '0'),
('69', '0', '14', '2015-04-01', '0602', 'Biginning balance as at 01/04/2015', '869059', '0', '0', NULL, NULL, '0'),
('70', '0', '14', '2015-04-01', '0603', 'Biginning balance as at 01/04/2015', '320506', '0', '0', NULL, NULL, '0'),
('71', '0', '14', '2015-04-01', '0604', 'Biginning balance as at 01/04/2015', '737923', '0', '0', NULL, NULL, '0'),
('72', '0', '14', '2015-04-01', '0605', 'Biginning balance as at 01/04/2015', '467037', '0', '0', NULL, NULL, '0'),
('73', '0', '14', '2015-04-01', '0606', 'Biginning balance as at 01/04/2015', '320566', '0', '0', NULL, NULL, '0'),
('74', '0', '14', '2015-04-01', '0601', 'Biginning balance as at 01/04/2015', '473619', '0', '0', NULL, NULL, '0'),
('75', '0', '14', '2015-04-01', '0607', 'Biginning balance as at 01/04/2015', '185160', '0', '0', NULL, NULL, '0'),
('76', '0', '14', '2015-04-01', '0608', 'Biginning balance as at 01/04/2015', '554093', '0', '0', NULL, NULL, '0'),
('77', '0', '14', '2015-04-01', '0609', 'Biginning balance as at 01/04/2015', '31804', '0', '0', NULL, NULL, '0'),
('78', '0', '14', '2015-04-01', '0451', 'Biginning balance as at 01/04/2015', '-5589698', '0', '0', NULL, NULL, '0'),
('79', '1', '3', '2015-04-01', '4165', 'Being Driver&#039;s advance for April 2016', '7000', '0', '0', NULL, NULL, '47413'),
('80', '1', '3', '2015-04-01', '300', '', '-7000', '0', '0', NULL, NULL, '47413'),
('81', '1', '4', '2015-04-01', '6185', 'Internet bill for the period of 01/02/15 to 28/02/2015', '561.2', '0', '0', NULL, NULL, '47415'),
('82', '1', '4', '2015-04-01', '300', '', '-561.2', '0', '0', NULL, NULL, '47415'),
('83', '1', '5', '2015-04-06', '6168', 'Bonus pay to Mr.Saman', '10000', '0', '0', NULL, NULL, '47416'),
('84', '1', '5', '2015-04-06', '0350', 'Being payment of Festival Advance', '25000', '0', '0', NULL, NULL, '47416'),
('85', '1', '5', '2015-04-06', '300', '', '-35000', '0', '0', NULL, NULL, '47416'),
('86', '1', '6', '2015-04-07', '4152', 'Reimb. of traveling 2014/15 to Mr. Hema-Rs.18,000 &amp; Mr.Romesh-Rs.50000', '0', '0', '0', NULL, NULL, '47417'),
('87', '1', '6', '2015-04-07', '4165', 'Reimb. of  traveling to Mr. Daya', '0', '0', '0', NULL, NULL, '47417'),
('88', '1', '6', '2015-04-07', '300', '', '0', '0', '0', NULL, NULL, '47417'),
('89', '1', '7', '2015-04-01', '6185', 'M/D&#039;s phone charges-April&#039;2015', '800', '0', '0', NULL, NULL, '47414'),
('90', '1', '7', '2015-04-01', '300', '', '-800', '0', '0', NULL, NULL, '47414'),
('91', '1', '8', '2015-04-08', '4155', 'Television bill for 28/03/15 to 27/04/15', '1017.85', '0', '0', NULL, NULL, '47418'),
('92', '1', '8', '2015-04-08', '300', '', '-1017.85', '0', '0', NULL, NULL, '47418'),
('93', '1', '9', '2015-04-08', '6170', 'Electricity bill for April&#039;15', '16235', '0', '0', NULL, NULL, '47419'),
('94', '1', '9', '2015-04-08', '300', '', '-16235', '0', '0', NULL, NULL, '47419'),
('95', '1', '10', '2015-04-08', '0259', 'Festival Advance to W.S.Perera-Rs.20,000 &amp; A.K.Danapala-Rs.Rs.15,000', '35000', '0', '0', NULL, NULL, '47420'),
('96', '1', '10', '2015-04-08', '300', '', '-35000', '0', '0', NULL, NULL, '47420'),
('97', '1', '11', '2015-04-09', '6175', 'Maintaining &amp; Servicing the Fax machine 03/03/15 to 28/03/16', '7280', '0', '0', NULL, NULL, '47421'),
('98', '1', '11', '2015-04-09', '300', '', '-7280', '0', '0', NULL, NULL, '47421'),
('99', '1', '12', '2015-04-10', '4154', 'New year gift for April&#039;15 (Mr.Nagasinghe-Rs.1,000 &amp; Dissanayake-Rs.4,000', '5000', '0', '0', NULL, NULL, '47422'),
('100', '1', '12', '2015-04-10', '300', '', '-5000', '0', '0', NULL, NULL, '47422'),
('101', '1', '13', '2015-04-10', '6185', 'Telephone &amp; Fax line bill for 01/03/15 to 31/03/15', '671.55', '0', '0', NULL, NULL, '47423'),
('102', '1', '13', '2015-04-10', '300', '', '-671.55', '0', '0', NULL, NULL, '47423'),
('103', '1', '14', '2016-10-24', '4152', 'Director&#039;s traveling for April&#039; 2015', '0', '0', '0', NULL, NULL, '47425'),
('104', '1', '14', '2016-10-24', '300', '', '0', '0', '0', NULL, NULL, '47425'),
('105', '1', '15', '2015-04-24', '4166', 'Salary for April&#039;15', '88085', '0', '0', NULL, NULL, '54401'),
('106', '1', '15', '2015-04-24', '4165', 'Traveling Reimb. for April&#039;15', '4500', '0', '0', NULL, NULL, '54401'),
('107', '1', '15', '2015-04-24', '6182', 'Traveling Reimb. for April&#039;15', '1550', '0', '0', NULL, NULL, '54401'),
('108', '1', '15', '2015-04-24', '300', '', '-94135', '0', '0', NULL, NULL, '54401'),
('109', '1', '16', '2015-04-24', '4166', 'Salary for April 2015', '32936', '0', '0', NULL, NULL, '54402'),
('110', '1', '16', '2015-04-24', '6181', 'Trav. reimb. for April 2015', '1500', '0', '0', NULL, NULL, '54402'),
('111', '1', '16', '2015-04-24', '6182', 'Mobile. reimb. for April 2015', '750', '0', '0', NULL, NULL, '54402'),
('112', '1', '16', '2015-04-24', '300', '', '-35186', '0', '0', NULL, NULL, '54402'),
('113', '1', '17', '2015-04-24', '4166', 'Salary- April&#039;15', '36207.2', '0', '0', NULL, NULL, '54403'),
('114', '1', '17', '2015-04-24', '6181', 'Reimb. of Traveling- April&#039;15', '10000', '0', '0', NULL, NULL, '54403'),
('115', '1', '17', '2015-04-24', '6182', 'Reimb. of  Mobile- April&#039;15', '2500', '0', '0', NULL, NULL, '54403'),
('116', '1', '17', '2015-04-24', '300', '', '-48707.2', '0', '0', NULL, NULL, '54403'),
('117', '1', '18', '2015-04-24', '4166', 'Salary- April&#039;15', '21804', '0', '0', NULL, NULL, '54404'),
('118', '1', '18', '2015-04-24', '6181', 'Reimb. of traveling- April&#039;15', '1200', '0', '0', NULL, NULL, '54404'),
('119', '1', '18', '2015-04-24', '6182', 'Reimb. of Mobile- April&#039;15', '500', '0', '0', NULL, NULL, '54404'),
('120', '1', '18', '2015-04-24', '300', '', '-23504', '0', '0', NULL, NULL, '54404'),
('121', '1', '19', '2015-04-24', '6178', 'P.P.F- April&#039;15', '42507', '0', '0', NULL, NULL, '54405'),
('122', '1', '19', '2015-04-24', '300', '', '-42507', '0', '0', NULL, NULL, '54405'),
('123', '1', '20', '2015-04-24', '6171', 'E.T.F -April&#039;15', '6376.05', '0', '0', NULL, NULL, '54406'),
('124', '1', '20', '2015-04-24', '300', '', '-6376.05', '0', '0', NULL, NULL, '54406'),
('125', '1', '21', '2015-04-24', '4165', 'Driver&#039;s salary-April&#039;15', '15500', '0', '0', NULL, NULL, '54407'),
('126', '1', '21', '2015-04-24', '300', '', '-15500', '0', '0', NULL, NULL, '54407'),
('127', '1', '22', '2016-10-24', '6180', 'Consultancy fees to Mr.Senanayeke', '0', '0', '0', NULL, NULL, '54408'),
('128', '1', '22', '2016-10-24', '300', '', '0', '0', '0', NULL, NULL, '54408'),
('129', '1', '23', '2016-10-27', '6185', 'Inteernet bill for 01/03/15 to 31/03/15', '561.2', '0', '0', NULL, NULL, '561'),
('130', '1', '23', '2016-10-27', '300', '', '-561.2', '0', '0', NULL, NULL, '561'),
('131', '1', '24', '2016-10-27', '6185', 'Teliphone bill for Feb&#039;15-Rs.10,707.86 &amp; March-Rs.14,202.61', '24910.47', '0', '0', NULL, NULL, '24910'),
('132', '1', '24', '2016-10-27', '300', '', '-24910.47', '0', '0', NULL, NULL, '24910'),
('133', '1', '25', '2016-10-29', '6171', 'E.T.F-March&#039;15', '2100', '0', '0', NULL, NULL, '54411'),
('134', '1', '25', '2016-10-29', '300', '', '-2100', '0', '0', NULL, NULL, '54411'),
('135', '1', '26', '2016-10-29', '0350', 'E.P.F for March&#039;15', '20050', '0', '0', NULL, NULL, '54412'),
('136', '1', '26', '2016-10-29', '300', '', '-20050', '0', '0', NULL, NULL, '54412'),
('137', '1', '27', '2015-04-24', '4152', 'Director&#039;s traveling for April&#039; 2015', '0', '0', '0', NULL, NULL, '0'),
('138', '1', '27', '2015-04-24', '300', '', '0', '0', '0', NULL, NULL, '0'),
('139', '1', '28', '2015-04-24', '4152', 'Director&#039;s traveling for April&#039; 2015', '2000', '0', '0', NULL, NULL, '47425'),
('140', '1', '28', '2015-04-24', '300', '', '-2000', '0', '0', NULL, NULL, '47425'),
('141', '1', '29', '2015-04-24', '6186', 'Water bill for 18/03/15 to 21/04/15', '24170.25', '0', '0', NULL, NULL, '47424'),
('142', '1', '29', '2015-04-24', '300', '', '-24170.25', '0', '0', NULL, NULL, '47424'),
('143', '1', '30', '2015-04-24', '6180', 'Consultancy fees to Mr.Senanayeke', '4000', '0', '0', NULL, NULL, '54408'),
('144', '1', '30', '2015-04-24', '300', '', '-4000', '0', '0', NULL, NULL, '54408'),
('145', '1', '31', '2015-04-27', '6185', 'Internet bill for 01/03/15 to 31/03/15', '561.2', '0', '0', NULL, NULL, '54409'),
('146', '1', '31', '2015-04-27', '300', '', '-561.2', '0', '0', NULL, NULL, '54409'),
('147', '1', '32', '2015-04-27', '6185', 'Telephone bill for 01/02/15 to 31/03/15', '24910.47', '0', '0', NULL, NULL, '54410'),
('148', '1', '32', '2015-04-27', '300', '', '-24910.47', '0', '0', NULL, NULL, '54410'),
('149', '1', '33', '2015-04-29', '0350', 'E.T.F for March&#039;15', '2100', '0', '0', NULL, NULL, '2100'),
('150', '1', '33', '2015-04-29', '300', '', '-2100', '0', '0', NULL, NULL, '2100'),
('151', '1', '34', '2015-04-29', '0350', 'E.P.F for March&#039;15', '20050', '0', '0', NULL, NULL, '54412'),
('152', '1', '34', '2015-04-29', '300', '', '-20050', '0', '0', NULL, NULL, '54412'),
('153', '1', '35', '2015-04-07', '4152', 'Reimb. of traveling 2014/15 to Mr. Hema-Rs.18,000 &amp; Mr.Romesh-Rs.50000', '68000', '0', '0', NULL, NULL, '47417'),
('154', '1', '35', '2015-04-07', '4165', 'Reimb. of  traveling to Mr. Daya', '17500', '0', '0', NULL, NULL, '47417'),
('155', '1', '35', '2015-04-07', '300', '', '-85500', '0', '0', NULL, NULL, '47417'),
('156', '2', '1', '2015-04-06', '0257', 'Water reimbursement for March&#039;15', '-3000', '0', '0', NULL, NULL, '0'),
('157', '2', '1', '2015-04-06', '0258', 'Electricity reimbursement for March&#039;15', '-12000', '0', '0', NULL, NULL, '0'),
('158', '2', '1', '2015-04-06', '300', '', '15000', '0', '0', NULL, NULL, '0'),
('159', '2', '2', '2015-04-16', '4051', 'H/o &amp; Sub Office Charges-March&#039;15', '-130000', '0', '0', NULL, NULL, '0'),
('160', '2', '2', '2015-04-16', '300', '', '130000', '0', '0', NULL, NULL, '0'),
('161', '2', '3', '2015-04-16', '4050', 'Monthly rental for March&#039;15', '-102869.4', '0', '0', NULL, NULL, '0'),
('162', '2', '3', '2015-04-16', '300', '', '102869.4', '0', '0', NULL, NULL, '0'),
('163', '2', '4', '2015-04-16', '4100', 'Being dividend received', '-1878.98', '0', '0', NULL, NULL, '0'),
('164', '2', '4', '2015-04-16', '300', '', '1878.98', '0', '0', NULL, NULL, '0'),
('165', '2', '5', '2015-04-27', '4300', 'Direct FD interest transfer', '-4993.15', '0', '0', NULL, NULL, '0'),
('166', '2', '5', '2015-04-27', '300', '', '4993.15', '0', '0', NULL, NULL, '0'),
('167', '2', '6', '2015-04-27', '4300', 'Direct FD interest', '-4993.15', '0', '0', NULL, NULL, '0'),
('168', '2', '6', '2015-04-27', '300', '', '4993.15', '0', '0', NULL, NULL, '0'),
('169', '2', '7', '2015-04-27', '4300', 'Direct FD Interest Income', '-4993.15', '0', '0', NULL, NULL, '0'),
('170', '2', '7', '2015-04-27', '300', '', '4993.15', '0', '0', NULL, NULL, '0');

### Structure of table `0_grn_batch` ###

DROP TABLE IF EXISTS `0_grn_batch`;

CREATE TABLE `0_grn_batch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `purch_order_no` int(11) DEFAULT NULL,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rate` double DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `delivery_date` (`delivery_date`),
  KEY `purch_order_no` (`purch_order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_batch` ###


### Structure of table `0_grn_items` ###

DROP TABLE IF EXISTS `0_grn_items`;

CREATE TABLE `0_grn_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_batch_id` int(11) DEFAULT NULL,
  `po_detail_item` int(11) NOT NULL DEFAULT '0',
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `qty_recd` double NOT NULL DEFAULT '0',
  `quantity_inv` double NOT NULL DEFAULT '0',
  `line_location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `grn_batch_id` (`grn_batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_items` ###


### Structure of table `0_groups` ###

DROP TABLE IF EXISTS `0_groups`;

CREATE TABLE `0_groups` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_groups` ###

INSERT INTO `0_groups` VALUES
('1', 'Small', '0'),
('2', 'Medium', '0'),
('3', 'Large', '0');

### Structure of table `0_import_paypal` ###

DROP TABLE IF EXISTS `0_import_paypal`;

CREATE TABLE `0_import_paypal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date` date NOT NULL DEFAULT '0000-00-00',
  `ref` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `person` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `confirmed` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_import_paypal` ###


### Structure of table `0_import_paypal_accounts` ###

DROP TABLE IF EXISTS `0_import_paypal_accounts`;

CREATE TABLE `0_import_paypal_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `person` (`person`),
  KEY `memo` (`memo`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_import_paypal_accounts` ###


### Structure of table `0_item_codes` ###

DROP TABLE IF EXISTS `0_item_codes`;

CREATE TABLE `0_item_codes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` smallint(6) unsigned NOT NULL,
  `quantity` double NOT NULL DEFAULT '1',
  `is_foreign` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `stock_id` (`stock_id`,`item_code`),
  KEY `item_code` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_codes` ###

INSERT INTO `0_item_codes` VALUES
('1', '00012', '00012', 'Electricity', '1', '1', '0', '0');

### Structure of table `0_item_tax_type_exemptions` ###

DROP TABLE IF EXISTS `0_item_tax_type_exemptions`;

CREATE TABLE `0_item_tax_type_exemptions` (
  `item_tax_type_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_tax_type_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_type_exemptions` ###


### Structure of table `0_item_tax_types` ###

DROP TABLE IF EXISTS `0_item_tax_types`;

CREATE TABLE `0_item_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `exempt` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_types` ###

INSERT INTO `0_item_tax_types` VALUES
('1', 'Regular', '0', '0');

### Structure of table `0_item_units` ###

DROP TABLE IF EXISTS `0_item_units`;

CREATE TABLE `0_item_units` (
  `abbr` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `decimals` tinyint(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`abbr`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_units` ###

INSERT INTO `0_item_units` VALUES
('Cone', 'Cone', '-1', '0'),
('ea.', 'Each', '1', '0'),
('hrs', 'Hours', '1', '0'),
('Kg', 'Kilogram', '-1', '0'),
('l', 'Liter', '3', '0'),
('Mtr', 'Meters', '-1', '0'),
('Nos', 'Numbers', '0', '0'),
('Yard', 'Yard', '-1', '0');

### Structure of table `0_journal` ###

DROP TABLE IF EXISTS `0_journal`;

CREATE TABLE `0_journal` (
  `type` smallint(6) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `tran_date` date DEFAULT '0000-00-00',
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `source_ref` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `event_date` date DEFAULT '0000-00-00',
  `doc_date` date NOT NULL DEFAULT '0000-00-00',
  `currency` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_journal` ###

INSERT INTO `0_journal` VALUES
('0', '1', '2016-03-31', 'J0001', '', '2016-03-31', '2016-03-31', 'LKR', '0', '1'),
('0', '2', '2015-04-01', '00001', '', '2015-04-01', '2015-04-01', 'LKR', '4556544', '1'),
('0', '3', '2015-04-01', '00002', '', '2015-04-01', '2015-04-01', 'LKR', '498598', '1'),
('0', '4', '2015-04-01', '00003', '', '2015-04-01', '2015-04-01', 'LKR', '5902725', '1'),
('0', '5', '2015-04-01', '00004', '', '2015-04-01', '2015-04-01', 'LKR', '516460', '1'),
('0', '6', '2015-04-01', '00005', '', '2015-04-01', '2015-04-01', 'LKR', '454986', '1'),
('0', '7', '2015-04-01', '00006', '', '2015-04-01', '2015-04-01', 'LKR', '554081', '1'),
('0', '8', '2016-04-01', '00007', '', '2016-04-01', '2016-04-01', 'LKR', '4357312', '1'),
('0', '9', '2016-04-01', '00008', '', '2016-04-01', '2016-04-01', 'LKR', '58304', '1'),
('0', '10', '2015-04-01', '00009', '', '2015-04-01', '2015-04-01', 'LKR', '750030', '1'),
('0', '11', '2015-04-01', '00010', '', '2015-04-01', '2015-04-01', 'LKR', '974578', '1'),
('0', '12', '2015-04-01', '00011', '', '2015-04-01', '2015-04-01', 'LKR', '142874', '1'),
('0', '13', '2015-04-01', '00012', '', '2015-04-01', '2015-04-01', 'LKR', '2782444', '1'),
('0', '14', '2015-04-01', '00013', '', '2015-04-01', '2015-04-01', 'LKR', '5589698', '1');

### Structure of table `0_loc_stock` ###

DROP TABLE IF EXISTS `0_loc_stock`;

CREATE TABLE `0_loc_stock` (
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `reorder_level` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`loc_code`,`stock_id`),
  KEY `stock_id` (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_loc_stock` ###


### Structure of table `0_locations` ###

DROP TABLE IF EXISTS `0_locations`;

CREATE TABLE `0_locations` (
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `location_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fax` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fixed_asset` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `main_loc_id` int(3) NOT NULL,
  PRIMARY KEY (`loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_locations` ###


### Structure of table `0_main_category` ###

DROP TABLE IF EXISTS `0_main_category`;

CREATE TABLE `0_main_category` (
  `main_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `main_cat_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL,
  PRIMARY KEY (`main_category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_main_category` ###


### Structure of table `0_main_locations` ###

DROP TABLE IF EXISTS `0_main_locations`;

CREATE TABLE `0_main_locations` (
  `main_loc_id` int(11) NOT NULL AUTO_INCREMENT,
  `main_loc_code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `main_loc_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `inactive` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`main_loc_id`),
  UNIQUE KEY `main_loc_code` (`main_loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_main_locations` ###


### Structure of table `0_payment_terms` ###

DROP TABLE IF EXISTS `0_payment_terms`;

CREATE TABLE `0_payment_terms` (
  `terms_indicator` int(11) NOT NULL AUTO_INCREMENT,
  `terms` char(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `days_before_due` smallint(6) NOT NULL DEFAULT '0',
  `day_in_following_month` smallint(6) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`terms_indicator`),
  UNIQUE KEY `terms` (`terms`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payment_terms` ###

INSERT INTO `0_payment_terms` VALUES
('1', '30 days only', '0', '0', '0');

### Structure of table `0_prices` ###

DROP TABLE IF EXISTS `0_prices`;

CREATE TABLE `0_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type_id` int(11) NOT NULL DEFAULT '0',
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `price` (`stock_id`,`sales_type_id`,`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_prices` ###


### Structure of table `0_print_profiles` ###

DROP TABLE IF EXISTS `0_print_profiles`;

CREATE TABLE `0_print_profiles` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `report` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `printer` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile` (`profile`,`report`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_print_profiles` ###

INSERT INTO `0_print_profiles` VALUES
('1', 'Out of office', NULL, '0'),
('2', 'Sales Department', NULL, '0'),
('3', 'Central', NULL, '2'),
('4', 'Sales Department', '104', '2'),
('5', 'Sales Department', '105', '2'),
('6', 'Sales Department', '107', '2'),
('7', 'Sales Department', '109', '2'),
('8', 'Sales Department', '110', '2'),
('9', 'Sales Department', '201', '2');

### Structure of table `0_printers` ###

DROP TABLE IF EXISTS `0_printers`;

CREATE TABLE `0_printers` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `queue` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `host` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `port` smallint(11) unsigned NOT NULL,
  `timeout` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_printers` ###

INSERT INTO `0_printers` VALUES
('1', 'QL500', 'Label printer', 'QL500', 'server', '127', '20'),
('2', 'Samsung', 'Main network printer', 'scx4521F', 'server', '515', '5'),
('3', 'Local', 'Local print server at user IP', 'lp', '', '515', '10');

### Structure of table `0_products_collections` ###

DROP TABLE IF EXISTS `0_products_collections`;

CREATE TABLE `0_products_collections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pc_code` varchar(4) COLLATE utf8_unicode_ci NOT NULL,
  `pc_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `inactive` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pc_code` (`pc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_products_collections` ###


### Structure of table `0_purch_data` ###

DROP TABLE IF EXISTS `0_purch_data`;

CREATE TABLE `0_purch_data` (
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT '0',
  `suppliers_uom` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `conversion_factor` double NOT NULL DEFAULT '1',
  `supplier_description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`supplier_id`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_data` ###


### Structure of table `0_purch_order_details` ###

DROP TABLE IF EXISTS `0_purch_order_details`;

CREATE TABLE `0_purch_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT '0',
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `act_price` double NOT NULL DEFAULT '0',
  `std_cost_unit` double NOT NULL DEFAULT '0',
  `quantity_ordered` double NOT NULL DEFAULT '0',
  `quantity_received` double NOT NULL DEFAULT '0',
  `line_location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`),
  KEY `itemcode` (`item_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_order_details` ###


### Structure of table `0_purch_order_details_csv` ###

DROP TABLE IF EXISTS `0_purch_order_details_csv`;

CREATE TABLE `0_purch_order_details_csv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_ref` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `price` double(16,2) DEFAULT NULL,
  `order_date` date NOT NULL,
  `requeried_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_order_details_csv` ###


### Structure of table `0_purch_orders` ###

DROP TABLE IF EXISTS `0_purch_orders`;

CREATE TABLE `0_purch_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `comments` tinytext COLLATE utf8_unicode_ci,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `requisition_no` tinytext COLLATE utf8_unicode_ci,
  `into_stock_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `total` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_orders` ###


### Structure of table `0_quick_entries` ###

DROP TABLE IF EXISTS `0_quick_entries`;

CREATE TABLE `0_quick_entries` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `usage` varchar(120) COLLATE utf8_unicode_ci DEFAULT NULL,
  `base_amount` double NOT NULL DEFAULT '0',
  `base_desc` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bal_type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_entries` ###

INSERT INTO `0_quick_entries` VALUES
('1', '1', 'Employee Trust Fund', NULL, '0', 'Employee trust fund', '0'),
('2', '1', 'Sri Lanka Telecom PLC', NULL, '0', 'Telephone &amp; Internet', '0'),
('3', '1', 'Dialog Television (Pvt) Ltd', NULL, '0', 'Dialog Television bill', '0'),
('4', '1', 'The General Manager,Ceylon Electricity Board', NULL, '0', 'Electricity bill payment', '0'),
('5', '1', 'Dialog Broadband Networks (Pvt) Ltd', NULL, '0', 'Telephone &amp; Fax Line bill', '0'),
('6', '1', 'National Water Supply &amp; Draining Board', NULL, '0', 'Water Bill', '0'),
('7', '1', 'Employees Provident Fund', NULL, '0', 'E.P.F', '0');

### Structure of table `0_quick_entry_lines` ###

DROP TABLE IF EXISTS `0_quick_entry_lines`;

CREATE TABLE `0_quick_entry_lines` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `qid` smallint(6) unsigned NOT NULL,
  `amount` double DEFAULT '0',
  `memo` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `dest_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` smallint(6) unsigned DEFAULT NULL,
  `dimension2_id` smallint(6) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_entry_lines` ###

INSERT INTO `0_quick_entry_lines` VALUES
('2', '5', '0', '', '=', '6185', '0', '0'),
('3', '2', '0', '', '=', '6185', '0', '0'),
('4', '3', '0', '', '=', '4155', '0', '0'),
('5', '1', '0', '', '=', '0350', '0', '0'),
('6', '7', '0', '', '=', '0350', '0', '0'),
('7', '6', '0', '', '=', '6186', '0', '0'),
('8', '4', '0', '', '=', '6170', '0', '0');

### Structure of table `0_recurrent_invoices` ###

DROP TABLE IF EXISTS `0_recurrent_invoices`;

CREATE TABLE `0_recurrent_invoices` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order_no` int(11) unsigned NOT NULL,
  `debtor_no` int(11) unsigned DEFAULT NULL,
  `group_no` smallint(6) unsigned DEFAULT NULL,
  `days` int(11) NOT NULL DEFAULT '0',
  `monthly` int(11) NOT NULL DEFAULT '0',
  `begin` date NOT NULL DEFAULT '0000-00-00',
  `end` date NOT NULL DEFAULT '0000-00-00',
  `last_sent` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_recurrent_invoices` ###


### Structure of table `0_reflines` ###

DROP TABLE IF EXISTS `0_reflines`;

CREATE TABLE `0_reflines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` int(11) NOT NULL,
  `prefix` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pattern` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `prefix` (`trans_type`,`prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_reflines` ###

INSERT INTO `0_reflines` VALUES
('1', '0', '', '00014', '', '1', '0'),
('2', '1', '', '00031', '', '1', '0'),
('3', '2', '', '00008', '', '1', '0'),
('4', '4', '', '00001', '', '1', '0'),
('5', '10', '', '00001', '', '1', '0'),
('6', '11', '', '00001', '', '1', '0'),
('7', '12', '', '00001', '', '1', '0'),
('8', '13', '', '00001', '', '1', '0'),
('9', '16', '', '00001', '', '1', '0'),
('10', '17', '', '00001', '', '1', '0'),
('11', '18', '', '00001', '', '1', '0'),
('12', '20', '', '00001', '', '1', '0'),
('13', '21', '', '00001', '', '1', '0'),
('14', '22', '', '00031', '', '1', '0'),
('15', '25', '', '00001', '', '1', '0'),
('16', '26', '', '00001', '', '1', '0'),
('17', '28', '', '00001', '', '1', '0'),
('18', '29', '', '00001', '', '1', '0'),
('19', '30', '', '00001', '', '1', '0'),
('20', '32', '', '00001', '', '1', '0'),
('21', '35', '', '00001', '', '1', '0'),
('22', '40', '', '00001', '', '1', '0'),
('23', '50', '', '', '', '1', '0');

### Structure of table `0_refs` ###

DROP TABLE IF EXISTS `0_refs`;

CREATE TABLE `0_refs` (
  `id` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`type`),
  KEY `Type_and_Reference` (`type`,`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_refs` ###

INSERT INTO `0_refs` VALUES
('2', '0', '00001'),
('3', '0', '00002'),
('4', '0', '00003'),
('5', '0', '00004'),
('6', '0', '00005'),
('7', '0', '00006'),
('8', '0', '00007'),
('9', '0', '00008'),
('10', '0', '00009'),
('11', '0', '00010'),
('12', '0', '00011'),
('13', '0', '00012'),
('14', '0', '00013'),
('1', '0', 'J0001'),
('1', '1', '00001'),
('2', '1', '00002'),
('3', '1', '00002'),
('4', '1', '00003'),
('5', '1', '00004'),
('6', '1', '00005'),
('35', '1', '00005'),
('7', '1', '00006'),
('8', '1', '00007'),
('9', '1', '00008'),
('10', '1', '00009'),
('11', '1', '00010'),
('12', '1', '00011'),
('13', '1', '00012'),
('14', '1', '00013'),
('27', '1', '00013'),
('28', '1', '00013'),
('15', '1', '00014'),
('16', '1', '00015'),
('17', '1', '00016'),
('18', '1', '00017'),
('19', '1', '00018'),
('20', '1', '00019'),
('21', '1', '00020'),
('22', '1', '00021'),
('30', '1', '00021'),
('23', '1', '00022'),
('24', '1', '00023'),
('25', '1', '00024'),
('26', '1', '00025'),
('29', '1', '00026'),
('31', '1', '00027'),
('32', '1', '00028'),
('33', '1', '00029'),
('34', '1', '00030'),
('1', '2', '00001'),
('2', '2', '00002'),
('3', '2', '00003'),
('4', '2', '00004'),
('5', '2', '00005'),
('6', '2', '00006'),
('7', '2', '00007'),
('1', '40', '00001'),
('1', '50', ''),
('2', '50', ''),
('3', '50', ''),
('4', '50', ''),
('5', '50', ''),
('6', '50', ''),
('7', '50', ''),
('27', '50', ''),
('35', '50', '047417'),
('8', '50', '047418'),
('9', '50', '047419'),
('10', '50', '047420'),
('11', '50', '047421'),
('12', '50', '047422'),
('13', '50', '047423'),
('29', '50', '047424'),
('14', '50', '047425'),
('28', '50', '047425'),
('15', '50', '054401'),
('16', '50', '054402'),
('17', '50', '054403'),
('18', '50', '054404'),
('19', '50', '054405'),
('20', '50', '054406'),
('21', '50', '054407'),
('22', '50', '054408'),
('30', '50', '054408'),
('31', '50', '054409'),
('32', '50', '054410'),
('25', '50', '054411'),
('26', '50', '054412'),
('34', '50', '054412'),
('33', '50', '2100'),
('24', '50', '24910.47'),
('23', '50', '561.20');

### Structure of table `0_requisition_details` ###

DROP TABLE IF EXISTS `0_requisition_details`;

CREATE TABLE `0_requisition_details` (
  `requisition_detail_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `requisition_id` int(11) DEFAULT NULL,
  `item_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `lpo_id` int(11) DEFAULT '0',
  `order_quantity` int(11) NOT NULL DEFAULT '0',
  `estimate_price` double NOT NULL DEFAULT '0',
  `quantity` int(11) NOT NULL DEFAULT '0',
  `price` double NOT NULL DEFAULT '0',
  `purpose` varchar(320) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`requisition_detail_id`),
  UNIQUE KEY `requisition_detail_id` (`requisition_detail_id`),
  KEY `0_requisition_details_requisition_id` (`requisition_id`),
  KEY `0_requisition_details_item_code` (`item_code`),
  KEY `0_requisition_details_supplier_id` (`supplier_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_requisition_details` ###


### Structure of table `0_requisitions` ###

DROP TABLE IF EXISTS `0_requisitions`;

CREATE TABLE `0_requisitions` (
  `requisition_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `point_of_use` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `narrative` varchar(240) COLLATE utf8_unicode_ci DEFAULT NULL,
  `application_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `completed` tinyint(4) NOT NULL DEFAULT '0',
  `processed` tinyint(4) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`requisition_id`),
  UNIQUE KEY `requisition_id` (`requisition_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_requisitions` ###


### Structure of table `0_sales_order_details` ###

DROP TABLE IF EXISTS `0_sales_order_details`;

CREATE TABLE `0_sales_order_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT '0',
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `stk_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `qty_sent` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `invoiced` double NOT NULL DEFAULT '0',
  `discount_percent` double NOT NULL DEFAULT '0',
  `done_by` int(2) DEFAULT NULL,
  `line_location` char(15) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sorder` (`trans_type`,`order_no`),
  KEY `stkcode` (`stk_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_order_details` ###


### Structure of table `0_sales_order_details_csv` ###

DROP TABLE IF EXISTS `0_sales_order_details_csv`;

CREATE TABLE `0_sales_order_details_csv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cust_ref` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `stock_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `price` double(16,2) DEFAULT NULL,
  `discount_precent` double DEFAULT NULL,
  `order_date` date DEFAULT NULL,
  `delivery_date` date DEFAULT NULL,
  `deliver_addres` tinytext COLLATE utf8_unicode_ci,
  `deliver_branch` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_order_details_csv` ###


### Structure of table `0_sales_orders` ###

DROP TABLE IF EXISTS `0_sales_orders`;

CREATE TABLE `0_sales_orders` (
  `order_no` int(11) NOT NULL,
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `version` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `branch_code` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `customer_ref` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `comments` tinytext COLLATE utf8_unicode_ci,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `order_type` int(11) NOT NULL DEFAULT '0',
  `ship_via` int(11) NOT NULL DEFAULT '0',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `contact_phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `deliver_to` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `freight_cost` double NOT NULL DEFAULT '0',
  `from_stk_loc` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `payment_terms` int(11) DEFAULT NULL,
  `total` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `done_by` int(2) DEFAULT NULL,
  PRIMARY KEY (`order_no`,`trans_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_orders` ###


### Structure of table `0_sales_pos` ###

DROP TABLE IF EXISTS `0_sales_pos`;

CREATE TABLE `0_sales_pos` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `pos_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `cash_sale` tinyint(1) NOT NULL,
  `credit_sale` tinyint(1) NOT NULL,
  `pos_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `pos_account` smallint(6) unsigned NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `pos_name` (`pos_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_pos` ###

INSERT INTO `0_sales_pos` VALUES
('1', 'Default', '1', '1', 'DEF', '2', '0');

### Structure of table `0_sales_types` ###

DROP TABLE IF EXISTS `0_sales_types`;

CREATE TABLE `0_sales_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_type` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_included` int(1) NOT NULL DEFAULT '0',
  `factor` double NOT NULL DEFAULT '1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_type` (`sales_type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_types` ###

INSERT INTO `0_sales_types` VALUES
('1', 'Retail', '1', '1', '0'),
('2', 'Wholesale', '0', '0.7', '0');

### Structure of table `0_salesman` ###

DROP TABLE IF EXISTS `0_salesman`;

CREATE TABLE `0_salesman` (
  `salesman_code` int(11) NOT NULL AUTO_INCREMENT,
  `salesman_name` char(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_phone` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_fax` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `provision` double NOT NULL DEFAULT '0',
  `break_pt` double NOT NULL DEFAULT '0',
  `provision2` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`salesman_code`),
  UNIQUE KEY `salesman_name` (`salesman_name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_salesman` ###

INSERT INTO `0_salesman` VALUES
('1', 'Sales Person', '', '', '', '5', '20000', '4', '0'),
('3', 'De Mel', '0112326191', '0114719891', 'hldemelcoltd@sltnet.lk', '0', '0', '0', '0');

### Structure of table `0_security_roles` ###

DROP TABLE IF EXISTS `0_security_roles`;

CREATE TABLE `0_security_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sections` text COLLATE utf8_unicode_ci,
  `areas` text COLLATE utf8_unicode_ci,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `role` (`role`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_security_roles` ###

INSERT INTO `0_security_roles` VALUES
('1', 'Inquiries', 'Inquiries', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128;9216;9216;9216;9472;9472;9472;9472;9728', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;773;774;775;2822;3073;3075;3076;3077;3329;3330;3331;3332;3333;3334;3335;5377;5633;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15873;15882;16129;16130;16131;16132', '0'),
('2', 'System Administrator', 'System Administrator', '256;512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;10496;10752;11008;13056;13312;15616;15872;16128;549888;615424;812032;1008640;1074176;1205248;1270784;1336320;9216;9216;9216;9472;9472;9472;9472;9728', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;775;2817;2818;2819;2820;2821;2822;2823;3073;3074;3075;3076;3077;3078;3079;3080;3081;3082;3329;3330;3331;3332;3333;3334;3335;5377;5385;5633;5634;5635;5636;5637;5638;5639;5640;5641;5889;5890;5891;7937;7938;7939;7940;7941;7942;7943;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15627;15628;15629;15873;15874;15875;15876;15877;15878;15879;15880;15881;15882;15883;15884;16129;16130;16131;16132;549988;549989;549990;615524;615525;812132;1008740;1074276;1205348;1270884;1336420', '0'),
('3', 'Salesman', 'Salesman', '768;3072;5632;8192;15872;9216;9216;9216;9472;9472;9472;9472;9728', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;526;773;774;775;2817;2818;2819;2820;2821;2822;2823;3073;3075;3082;3329;3330;3331;3332;3333;3334;3335;5377;5633;5889;5890;5891;7937;7938;7939;7940;8194;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15627;15628;15629;15873;16129;16130;16131;16132;549988;549989;549990;615524;615525;812132;1008740;1074276', '0'),
('4', 'Stock Manager', 'Stock Manager', '2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128;768', '775', '0'),
('5', 'Production Manager', 'Production Manager', '512;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128;768', '775', '0'),
('6', 'Purchase Officer', 'Purchase Officer', '512;5376;5632;5888;8192;8448;10752;11008;13312;768', '775', '0'),
('7', 'AR Officer', 'AR Officer', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;771;773;774;2818;2819;2820;2821;2822;2823;3073;3073;3074;3075;3076;3077;3078;3079;3080;3081;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5633;5634;5637;5638;5639;5640;5640;5889;5890;5891;8193;8194;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0'),
('8', 'AP Officer', 'AP Officer', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;10496;10752;11008;13056;13312;15616;15872;16128;549888;615424', '257;258;259;260;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;7941;7942;7943;8193;8194;8195;8196;8197;8449;8450;8451;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15629;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;549988;549989;549990;615524;615525;812132;1008740;1074276;775', '0'),
('9', 'Accountant', 'New Accountant', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;10496;10752;11008;13056;13312;15616;15872;16128;9216;9216;9216;9472;9472;9472;9472;9728', '257;258;259;260;513;516;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;775;2817;2818;2819;2820;2821;2822;2823;3073;3074;3075;3076;3078;3079;3080;3081;3082;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5638;5639;5640;5641;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15627;15628;15629;15873;15874;15875;15876;15877;15878;15879;15880;15881;15882;15883;15884;16129;16130;16131;16132;549988;549989;549990;615524;615525;812132;1008740;1074276', '0'),
('10', 'Sub Admin', 'Sub Admin', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;10496;10752;11008;13056;13312;15616;15872;16128;549888;615424;812032;1008640;1074176', '257;258;259;260;519;520;521;522;523;524;525;526;769;770;771;772;773;774;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;7941;7942;7943;8193;8194;8195;8196;8197;8449;8450;8451;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15629;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;549988;549989;549990;615524;615525;812132;1008740;1074276;775', '0');

### Structure of table `0_shippers` ###

DROP TABLE IF EXISTS `0_shippers`;

CREATE TABLE `0_shippers` (
  `shipper_id` int(11) NOT NULL AUTO_INCREMENT,
  `shipper_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`shipper_id`),
  UNIQUE KEY `name` (`shipper_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_shippers` ###

INSERT INTO `0_shippers` VALUES
('1', 'Default', '', '', '', '', '0');

### Structure of table `0_sizes` ###

DROP TABLE IF EXISTS `0_sizes`;

CREATE TABLE `0_sizes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `size_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `size_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `inactive` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sizes` ###


### Structure of table `0_sql_trail` ###

DROP TABLE IF EXISTS `0_sql_trail`;

CREATE TABLE `0_sql_trail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sql` text COLLATE utf8_unicode_ci NOT NULL,
  `result` tinyint(1) NOT NULL,
  `msg` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sql_trail` ###


### Structure of table `0_stock_category` ###

DROP TABLE IF EXISTS `0_stock_category`;

CREATE TABLE `0_stock_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_tax_type` int(11) NOT NULL DEFAULT '1',
  `dflt_units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `dflt_mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `dflt_sales_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_cogs_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_inventory_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_adjustment_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_wip_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_dim1` int(11) DEFAULT NULL,
  `dflt_dim2` int(11) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `dflt_no_sale` tinyint(1) NOT NULL DEFAULT '0',
  `dflt_no_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `done_by` int(2) DEFAULT NULL,
  `main_category_id` int(11) NOT NULL,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_category` ###

INSERT INTO `0_stock_category` VALUES
('1', 'Services', '1', 'Cone', 'D', '6170', '0150', '0150', '0150', '0150', '0', '0', '0', '0', '0', NULL, '0');

### Structure of table `0_stock_fa_class` ###

DROP TABLE IF EXISTS `0_stock_fa_class`;

CREATE TABLE `0_stock_fa_class` (
  `fa_class_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `long_description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `depreciation_rate` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fa_class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_fa_class` ###


### Structure of table `0_stock_master` ###

DROP TABLE IF EXISTS `0_stock_master`;

CREATE TABLE `0_stock_master` (
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `long_description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cogs_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inventory_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `adjustment_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `wip_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` int(11) DEFAULT NULL,
  `dimension2_id` int(11) DEFAULT NULL,
  `purchase_cost` double NOT NULL DEFAULT '0',
  `material_cost` double NOT NULL DEFAULT '0',
  `labour_cost` double NOT NULL DEFAULT '0',
  `overhead_cost` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `no_sale` tinyint(1) NOT NULL DEFAULT '0',
  `no_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `editable` tinyint(1) NOT NULL DEFAULT '0',
  `depreciation_method` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'S',
  `depreciation_rate` double NOT NULL DEFAULT '0',
  `depreciation_factor` double NOT NULL DEFAULT '0',
  `depreciation_start` date NOT NULL DEFAULT '0000-00-00',
  `depreciation_date` date NOT NULL DEFAULT '0000-00-00',
  `fa_class_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `crm_code` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `done_by` int(2) DEFAULT NULL,
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_master` ###

INSERT INTO `0_stock_master` VALUES
('00012', '1', '1', 'Electricity', '', 'Cone', 'D', '6170', '0150', '0150', '0150', '0150', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL);

### Structure of table `0_stock_moves` ###

DROP TABLE IF EXISTS `0_stock_moves`;

CREATE TABLE `0_stock_moves` (
  `trans_id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` smallint(6) NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `price` double NOT NULL DEFAULT '0',
  `reference` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT '1',
  `standard_cost` double NOT NULL DEFAULT '0',
  `line_location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`trans_id`),
  KEY `type` (`type`,`trans_no`),
  KEY `Move` (`stock_id`,`loc_code`,`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_moves` ###


### Structure of table `0_stock_serial` ###

DROP TABLE IF EXISTS `0_stock_serial`;

CREATE TABLE `0_stock_serial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serial_key` int(4) DEFAULT NULL,
  `year_month` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serial_no` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `manufacture_date` date DEFAULT NULL,
  `stock_in_date` timestamp NULL DEFAULT NULL,
  `type_no_in` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_no_in` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `stock_out_date` datetime DEFAULT NULL,
  `type_no_out` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_no_out` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `availability` int(1) DEFAULT '1',
  `serial_status` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` int(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `serial_number` (`serial_no`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_serial` ###


### Structure of table `0_stock_serial_genarate_log` ###

DROP TABLE IF EXISTS `0_stock_serial_genarate_log`;

CREATE TABLE `0_stock_serial_genarate_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serial_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `commnet` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `genarate_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_serial_genarate_log` ###


### Structure of table `0_supp_allocations` ###

DROP TABLE IF EXISTS `0_supp_allocations`;

CREATE TABLE `0_supp_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_allocations` ###


### Structure of table `0_supp_invoice_items` ###

DROP TABLE IF EXISTS `0_supp_invoice_items`;

CREATE TABLE `0_supp_invoice_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_trans_no` int(11) DEFAULT NULL,
  `supp_trans_type` int(11) DEFAULT NULL,
  `gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `grn_item_id` int(11) DEFAULT NULL,
  `po_detail_item_id` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `quantity` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `unit_tax` double NOT NULL DEFAULT '0',
  `memo_` tinytext COLLATE utf8_unicode_ci,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `line_location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`supp_trans_type`,`supp_trans_no`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_invoice_items` ###


### Structure of table `0_supp_trans` ###

DROP TABLE IF EXISTS `0_supp_trans`;

CREATE TABLE `0_supp_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `supplier_id` int(11) unsigned NOT NULL,
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `ov_amount` double NOT NULL DEFAULT '0',
  `ov_discount` double NOT NULL DEFAULT '0',
  `ov_gst` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  `alloc` double NOT NULL DEFAULT '0',
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`type`,`trans_no`,`supplier_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_trans` ###


### Structure of table `0_supplier_areas` ###

DROP TABLE IF EXISTS `0_supplier_areas`;

CREATE TABLE `0_supplier_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supplier_areas` ###


### Structure of table `0_suppliers` ###

DROP TABLE IF EXISTS `0_suppliers`;

CREATE TABLE `0_suppliers` (
  `supplier_id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supp_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `gst_no` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supp_account_no` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `website` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  `dimension_id` int(11) DEFAULT '0',
  `dimension2_id` int(11) DEFAULT '0',
  `tax_group_id` int(11) DEFAULT NULL,
  `credit_limit` double NOT NULL DEFAULT '0',
  `purchase_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payable_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `area` int(11) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `supp_ref` (`supp_ref`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_suppliers` ###

INSERT INTO `0_suppliers` VALUES
('1', 'Sri lanka Telecom', 'Sri lanka Telecom', '', '', '', '', '', '', '', 'LKR', '0', '0', '0', '0', '1', '0', '4155', '0353', '0150', '', '0', '0');

### Structure of table `0_sys_prefs` ###

DROP TABLE IF EXISTS `0_sys_prefs`;

CREATE TABLE `0_sys_prefs` (
  `name` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `length` smallint(6) DEFAULT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`name`),
  KEY `category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sys_prefs` ###

INSERT INTO `0_sys_prefs` VALUES
('accounts_alpha', 'glsetup.general', 'tinyint', '1', '0'),
('accumulate_shipping', 'glsetup.customer', 'tinyint', '1', '0'),
('add_pct', 'setup.company', 'int', '5', '-1'),
('allow_negative_prices', 'glsetup.inventory', 'tinyint', '1', '1'),
('allow_negative_stock', 'glsetup.inventory', 'tinyint', '1', '1'),
('alternative_tax_include_on_docs', 'setup.company', 'tinyint', '1', '0'),
('auto_curr_reval', 'setup.company', 'smallint', '6', '1'),
('bank_charge_act', 'glsetup.general', 'varchar', '15', '5690'),
('base_sales', 'setup.company', 'int', '11', '0'),
('bcc_email', 'setup.company', 'varchar', '100', ''),
('coy_logo', 'setup.company', 'varchar', '100', ''),
('coy_name', 'setup.company', 'varchar', '60', 'H.L.De Mel &amp; Co.(Pvt) Ltd'),
('coy_no', 'setup.company', 'varchar', '25', 'PV85'),
('creditors_act', 'glsetup.purchase', 'varchar', '15', '2100'),
('curr_default', 'setup.company', 'char', '3', 'LKR'),
('debtors_act', 'glsetup.sales', 'varchar', '15', '1200'),
('default_adj_act', 'glsetup.items', 'varchar', '15', '5040'),
('default_cogs_act', 'glsetup.items', 'varchar', '15', '5010'),
('default_credit_limit', 'glsetup.customer', 'int', '11', '1000000'),
('default_delivery_required', 'glsetup.sales', 'smallint', '6', '1'),
('default_dim_required', 'glsetup.dims', 'int', '11', '20'),
('default_inv_sales_act', 'glsetup.items', 'varchar', '15', '4010'),
('default_inventory_act', 'glsetup.items', 'varchar', '15', '1510'),
('default_loss_on_asset_disposal_act', 'glsetup.items', 'varchar', '15', '5660'),
('default_prompt_payment_act', 'glsetup.sales', 'varchar', '15', '4500'),
('default_quote_valid_days', 'glsetup.sales', 'smallint', '6', '30'),
('default_receival_required', 'glsetup.purchase', 'smallint', '6', '10'),
('default_sales_act', 'glsetup.sales', 'varchar', '15', '4010'),
('default_sales_discount_act', 'glsetup.sales', 'varchar', '15', '4510'),
('default_wip_act', 'glsetup.items', 'varchar', '15', '1530'),
('default_workorder_required', 'glsetup.manuf', 'int', '11', '20'),
('deferred_income_act', 'glsetup.sales', 'varchar', '15', ''),
('depreciation_period', 'glsetup.company', 'tinyint', '1', '1'),
('domicile', 'setup.company', 'varchar', '55', ''),
('email', 'setup.company', 'varchar', '100', 'hldemelcoltd@sltnet.lk'),
('exchange_diff_act', 'glsetup.general', 'varchar', '15', '4450'),
('f_year', 'setup.company', 'int', '11', '2'),
('fax', 'setup.company', 'varchar', '30', '0114719891'),
('freight_act', 'glsetup.customer', 'varchar', '15', '4430'),
('gl_closing_date', 'setup.closing_date', 'date', '8', ''),
('grn_clearing_act', 'glsetup.purchase', 'varchar', '15', '1550'),
('gst_no', 'setup.company', 'varchar', '25', ''),
('legal_text', 'glsetup.customer', 'tinytext', '0', ''),
('loc_notification', 'glsetup.inventory', 'tinyint', '1', '0'),
('login_tout', 'setup.company', 'smallint', '6', '60000'),
('no_customer_list', 'setup.company', 'tinyint', '1', '0'),
('no_item_list', 'setup.company', 'tinyint', '1', '0'),
('no_supplier_list', 'setup.company', 'tinyint', '1', '0'),
('no_zero_lines_amount', 'glsetup.sales', 'tinyint', '1', '1'),
('past_due_days', 'glsetup.general', 'int', '11', '30'),
('phone', 'setup.company', 'varchar', '30', '0112326191'),
('po_over_charge', 'glsetup.purchase', 'int', '11', '10'),
('po_over_receive', 'glsetup.purchase', 'int', '11', '10'),
('postal_address', 'setup.company', 'tinytext', '0', 'No 103,Chatham Street,\r\nColombo 01.'),
('print_invoice_no', 'glsetup.sales', 'tinyint', '1', '0'),
('print_item_images_on_quote', 'glsetup.inventory', 'tinyint', '1', '0'),
('profit_loss_year_act', 'glsetup.general', 'varchar', '15', '9990'),
('pyt_discount_act', 'glsetup.purchase', 'varchar', '15', '5060'),
('retained_earnings_act', 'glsetup.general', 'varchar', '15', '3590'),
('round_to', 'setup.company', 'int', '5', '1'),
('show_po_item_codes', 'glsetup.purchase', 'tinyint', '1', '0'),
('suppress_tax_rates', 'setup.company', 'tinyint', '1', '0'),
('tax_algorithm', 'glsetup.customer', 'tinyint', '1', '1'),
('tax_last', 'setup.company', 'int', '11', '1'),
('tax_prd', 'setup.company', 'int', '11', '1'),
('time_zone', 'setup.company', 'tinyint', '1', '1'),
('use_dimension', 'setup.company', 'tinyint', '1', '2'),
('use_fixed_assets', 'setup.company', 'tinyint', '1', '1'),
('use_manufacturing', 'setup.company', 'tinyint', '1', '1'),
('version_id', 'system', 'varchar', '11', '2.4.1');

### Structure of table `0_sys_types` ###

DROP TABLE IF EXISTS `0_sys_types`;

CREATE TABLE `0_sys_types` (
  `type_id` smallint(6) NOT NULL DEFAULT '0',
  `type_no` int(11) NOT NULL DEFAULT '1',
  `next_reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sys_types` ###

INSERT INTO `0_sys_types` VALUES
('0', '19', '00014'),
('1', '8', '00031'),
('2', '5', '00008'),
('4', '3', '00001'),
('10', '19', '00001'),
('11', '3', '00001'),
('12', '6', '00001'),
('13', '5', '00001'),
('16', '2', '00001'),
('17', '2', '00001'),
('18', '1', '00001'),
('20', '8', '00001'),
('21', '1', '00001'),
('22', '4', '00031'),
('25', '1', '00001'),
('26', '1', '00001'),
('28', '1', '00001'),
('29', '1', '00001'),
('30', '5', '00001'),
('32', '0', '00001'),
('35', '1', '00001'),
('40', '1', '00001'),
('50', '1', '');

### Structure of table `0_tag_associations` ###

DROP TABLE IF EXISTS `0_tag_associations`;

CREATE TABLE `0_tag_associations` (
  `record_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `tag_id` int(11) NOT NULL,
  UNIQUE KEY `record_id` (`record_id`,`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tag_associations` ###


### Structure of table `0_tags` ###

DROP TABLE IF EXISTS `0_tags`;

CREATE TABLE `0_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tags` ###


### Structure of table `0_tax_group_items` ###

DROP TABLE IF EXISTS `0_tax_group_items`;

CREATE TABLE `0_tax_group_items` (
  `tax_group_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `tax_shipping` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tax_group_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_group_items` ###


### Structure of table `0_tax_groups` ###

DROP TABLE IF EXISTS `0_tax_groups`;

CREATE TABLE `0_tax_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_groups` ###

INSERT INTO `0_tax_groups` VALUES
('1', 'Tax', '0'),
('2', 'Tax Exempt', '0');

### Structure of table `0_tax_types` ###

DROP TABLE IF EXISTS `0_tax_types`;

CREATE TABLE `0_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rate` double NOT NULL DEFAULT '0',
  `sales_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `purchasing_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_types` ###

INSERT INTO `0_tax_types` VALUES
('1', '5', '2150', '2150', 'Tax', '0');

### Structure of table `0_trans_tax_details` ###

DROP TABLE IF EXISTS `0_trans_tax_details`;

CREATE TABLE `0_trans_tax_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `tran_date` date NOT NULL,
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '0',
  `ex_rate` double NOT NULL DEFAULT '1',
  `included_in_price` tinyint(1) NOT NULL DEFAULT '0',
  `net_amount` double NOT NULL DEFAULT '0',
  `amount` double NOT NULL DEFAULT '0',
  `memo` tinytext COLLATE utf8_unicode_ci,
  `reg_type` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Type_and_Number` (`trans_type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_trans_tax_details` ###


### Structure of table `0_type_styles` ###

DROP TABLE IF EXISTS `0_type_styles`;

CREATE TABLE `0_type_styles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ts_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `ts_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `inactive` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_type_styles` ###


### Structure of table `0_useronline` ###

DROP TABLE IF EXISTS `0_useronline`;

CREATE TABLE `0_useronline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` int(15) NOT NULL DEFAULT '0',
  `ip` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `file` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB AUTO_INCREMENT=2435 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_useronline` ###

INSERT INTO `0_useronline` VALUES
('2427', '1478005730', '124.43.16.168', '/index.php'),
('2428', '1478005734', '124.43.16.168', '/index.php'),
('2429', '1478005737', '124.43.16.168', '/admin/company_preferences.php'),
('2430', '1478005737', '124.43.16.168', '/admin/company_preferences.php'),
('2431', '1478005817', '124.43.16.168', '/index.php'),
('2432', '1478005817', '124.43.16.168', '/index.php'),
('2433', '1478005821', '124.43.16.168', '/admin/backups.php'),
('2434', '1478005821', '124.43.16.168', '/admin/backups.php');

### Structure of table `0_users` ###

DROP TABLE IF EXISTS `0_users`;

CREATE TABLE `0_users` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `real_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `role_id` int(11) NOT NULL DEFAULT '1',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_format` tinyint(1) NOT NULL DEFAULT '0',
  `date_sep` tinyint(1) NOT NULL DEFAULT '0',
  `tho_sep` tinyint(1) NOT NULL DEFAULT '0',
  `dec_sep` tinyint(1) NOT NULL DEFAULT '0',
  `theme` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'default',
  `page_size` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'A4',
  `prices_dec` smallint(6) NOT NULL DEFAULT '2',
  `qty_dec` smallint(6) NOT NULL DEFAULT '2',
  `rates_dec` smallint(6) NOT NULL DEFAULT '4',
  `percent_dec` smallint(6) NOT NULL DEFAULT '1',
  `show_gl` tinyint(1) NOT NULL DEFAULT '1',
  `show_codes` tinyint(1) NOT NULL DEFAULT '0',
  `show_hints` tinyint(1) NOT NULL DEFAULT '0',
  `last_visit_date` datetime DEFAULT NULL,
  `query_size` tinyint(1) unsigned NOT NULL DEFAULT '10',
  `graphic_links` tinyint(1) DEFAULT '1',
  `pos` smallint(6) DEFAULT '1',
  `print_profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `rep_popup` tinyint(1) DEFAULT '1',
  `sticky_doc_date` tinyint(1) DEFAULT '0',
  `startup_tab` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `transaction_days` int(6) NOT NULL DEFAULT '30' COMMENT 'Transaction days',
  `save_report_selections` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Save Report Selection Days',
  `use_date_picker` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Use Date Picker for all Date Values',
  `def_print_destination` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Default Report Destination',
  `def_print_orientation` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Default Report Orientation',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_users` ###

INSERT INTO `0_users` VALUES
('1', 'admin', 'aaefecb8f8eae50a948ad30e1f887784', 'Administrator', '2', '', 'adm@adm.com', 'C', '0', '0', '0', '0', 'dashboard', 'A4', '2', '2', '4', '1', '1', '1', '1', '2016-11-02 06:41:43', '30', '1', '1', '', '1', '1', 'orders', '30', '0', '1', '0', '0', '0'),
('6', 'charitha', 'e99a18c428cb38d5f260853678922e03', '', '8', '', NULL, 'C', '0', '0', '0', '0', 'aqua', 'A4', '2', '2', '4', '1', '1', '0', '1', '2015-06-17 22:32:34', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0'),
('10', 'Accountant', '53331d0acda95d2ffcd6b8d91f8f714f', 'accountant', '8', '', NULL, 'C', '0', '0', '0', '0', 'aqua', 'A4', '2', '2', '4', '1', '1', '0', '1', '2015-07-02 22:56:55', '127', '1', '1', '', '1', '1', 'orders', '30', '0', '1', '0', '0', '0'),
('11', 'admin 1', '21232f297a57a5a743894a0e4a801fc3', 'Sri', '10', '', NULL, 'C', '0', '0', '0', '0', 'aqua', 'A4', '2', '2', '4', '1', '1', '0', '1', '2015-05-18 04:24:57', '10', '1', '1', '', '1', '1', 'orders', '30', '0', '1', '0', '0', '0'),
('12', 'Shehani', '1c74a3ce39feab6041fc938e55a481e1', 'Shehani Fernando', '6', '', NULL, 'C', '0', '0', '0', '0', 'aqua', 'A4', '2', '2', '4', '1', '1', '0', '1', NULL, '10', '1', '1', '', '1', '1', 'orders', '30', '0', '1', '0', '0', '0');

### Structure of table `0_voided` ###

DROP TABLE IF EXISTS `0_voided`;

CREATE TABLE `0_voided` (
  `type` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_voided` ###

INSERT INTO `0_voided` VALUES
('0', '1', '2016-10-10', ''),
('1', '1', '2016-10-10', ''),
('1', '2', '2016-10-10', ''),
('1', '6', '2016-10-24', 'Document reentered.'),
('1', '14', '2016-10-24', 'Document reentered.'),
('1', '22', '2016-10-24', 'Document reentered.'),
('1', '27', '2016-10-24', 'Document reentered.');

### Structure of table `0_wo_costing` ###

DROP TABLE IF EXISTS `0_wo_costing`;

CREATE TABLE `0_wo_costing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `cost_type` tinyint(1) NOT NULL DEFAULT '0',
  `trans_type` int(11) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `factor` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_costing` ###


### Structure of table `0_wo_issue_items` ###

DROP TABLE IF EXISTS `0_wo_issue_items`;

CREATE TABLE `0_wo_issue_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_id` int(11) DEFAULT NULL,
  `qty_issued` double DEFAULT NULL,
  `unit_cost` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_issue_items` ###


### Structure of table `0_wo_issues` ###

DROP TABLE IF EXISTS `0_wo_issues`;

CREATE TABLE `0_wo_issues` (
  `issue_no` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workcentre_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`issue_no`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_issues` ###


### Structure of table `0_wo_manufacture` ###

DROP TABLE IF EXISTS `0_wo_manufacture`;

CREATE TABLE `0_wo_manufacture` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_manufacture` ###


### Structure of table `0_wo_requirements` ###

DROP TABLE IF EXISTS `0_wo_requirements`;

CREATE TABLE `0_wo_requirements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre` int(11) NOT NULL DEFAULT '0',
  `units_req` double NOT NULL DEFAULT '1',
  `unit_cost` double NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_issued` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_requirements` ###


### Structure of table `0_workcentres` ###

DROP TABLE IF EXISTS `0_workcentres`;

CREATE TABLE `0_workcentres` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_workcentres` ###

INSERT INTO `0_workcentres` VALUES
('1', 'Workshop', 'Workshop in Alabama', '0');

### Structure of table `0_workorders` ###

DROP TABLE IF EXISTS `0_workorders`;

CREATE TABLE `0_workorders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wo_ref` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_reqd` double NOT NULL DEFAULT '1',
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `required_by` date NOT NULL DEFAULT '0000-00-00',
  `released_date` date NOT NULL DEFAULT '0000-00-00',
  `units_issued` double NOT NULL DEFAULT '0',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `released` tinyint(1) NOT NULL DEFAULT '0',
  `additional_costs` double NOT NULL DEFAULT '0',
  `budjet_labour` double NOT NULL,
  `budjet_orverhead` double NOT NULL,
  `labour_cost` double NOT NULL,
  `orverhead_cost` double NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wo_ref` (`wo_ref`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_workorders` ###
