# MySQL dump of database 'evolvede_360erp' on host 'localhost'
# Backup Date and Time: 2021-10-29 04:48
# Built by EvolveAccounting EVOLVE360v6
# http://evolve-sl.com
# Company: Evolve Technologies
# User: Administrator

# Compatibility: 2.4.1


SET NAMES latin1;


### Structure of table `0_amortisation` ###

DROP TABLE IF EXISTS `0_amortisation`;

CREATE TABLE `0_amortisation` (
  `amortisation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `amortisation_year` int(11) DEFAULT NULL,
  `asset_value` double DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `posted` int(11) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`amortisation_id`),
  UNIQUE KEY `amortisation_id` (`amortisation_id`),
  KEY `0_amortisation_asset_id` (`asset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_amortisation` ###


### Structure of table `0_areas` ###

DROP TABLE IF EXISTS `0_areas`;

CREATE TABLE `0_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_areas` ###

INSERT INTO `0_areas` VALUES
('1', 'Global', '0');

### Structure of table `0_asset_types` ###

DROP TABLE IF EXISTS `0_asset_types`;

CREATE TABLE `0_asset_types` (
  `asset_type_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_type_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `depreciation_type` int(11) NOT NULL DEFAULT '1',
  `depreciation_rate` double NOT NULL DEFAULT '10',
  `asset_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `depreciation_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `accumulated_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `valuation_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `disposal_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_type_id`),
  UNIQUE KEY `asset_type_id` (`asset_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_asset_types` ###


### Structure of table `0_asset_valuations` ###

DROP TABLE IF EXISTS `0_asset_valuations`;

CREATE TABLE `0_asset_valuations` (
  `asset_valuation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `valuation_year` int(11) DEFAULT NULL,
  `asset_value` double NOT NULL DEFAULT '0',
  `value_change` double NOT NULL DEFAULT '0',
  `posted` int(11) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_valuation_id`),
  UNIQUE KEY `asset_valuation_id` (`asset_valuation_id`),
  UNIQUE KEY `asset_id` (`asset_id`,`valuation_year`),
  KEY `0_asset_valuations_asset_id` (`asset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_asset_valuations` ###


### Structure of table `0_assets` ###

DROP TABLE IF EXISTS `0_assets`;

CREATE TABLE `0_assets` (
  `asset_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_type_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `asset_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_serial` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `purchase_date` date NOT NULL,
  `purchase_value` double NOT NULL,
  `disposal_amount` double DEFAULT NULL,
  `disposal_date` date DEFAULT NULL,
  `disposal_posting` int(11) DEFAULT '0',
  `tag_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_location` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_condition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_acquisition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_id`),
  UNIQUE KEY `asset_id` (`asset_id`),
  KEY `0_assets_asset_type_id` (`asset_type_id`),
  KEY `0_assets_item_id` (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_assets` ###


### Structure of table `0_attachments` ###

DROP TABLE IF EXISTS `0_attachments`;

CREATE TABLE `0_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_no` int(11) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `unique_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT '0',
  `filetype` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attachments` ###


### Structure of table `0_audit_trail` ###

DROP TABLE IF EXISTS `0_audit_trail`;

CREATE TABLE `0_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `user` smallint(6) unsigned NOT NULL DEFAULT '0',
  `stamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL DEFAULT '0',
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_audit_trail` ###


### Structure of table `0_bank_accounts` ###

DROP TABLE IF EXISTS `0_bank_accounts`;

CREATE TABLE `0_bank_accounts` (
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT '0',
  `bank_account_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_address` tinytext COLLATE utf8_unicode_ci,
  `bank_curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT '0',
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `bank_charge_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `bank_short_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_accounts` ###

INSERT INTO `0_bank_accounts` VALUES
('300', '1', 'Standared Chartered Bank', '01105356609', 'Standared Chartered Bank', NULL, 'LKR', '0', '1', '5690', '2015-04-30 01:00:00', '0', '1', 'SC'),
('301', '3', 'Petty Cash', '', 'Petty Cash', NULL, 'LKR', '0', '2', '5690', '0000-00-00 00:00:00', '0', '1', 'PC'),
('1060', '1', 'A-Sampath Bank - Current Account', '000110081227', 'Sampath Bank', NULL, 'LKR', '1', '3', '5805', '2021-05-31 01:00:00', '1112729.44', '0', 'SB'),
('1090', '1', 'Pan Asia Bank', '', 'Pan Asia Bank', NULL, 'LKR', '0', '4', '5805', '2021-09-30 01:00:00', '108977.72', '0', 'PAB'),
('1061', '1', 'Sampath Bank - GBP Account', '', 'Sampath Bank', NULL, 'GBP', '0', '7', '5805', '2019-07-31 01:00:00', '32.53', '0', 'SGBP'),
('1062', '1', 'Sampath Bank - USD Account', '', 'Sampath Bank', NULL, 'USD', '0', '8', '5805', '2021-08-31 01:00:00', '56758.16', '0', 'SBD'),
('1064', '1', 'Sampath Bank - AUD Account', '', 'Sampath Bank', NULL, 'AUD', '0', '9', '5805', '2021-08-31 01:00:00', '41.23', '0', 'SAUD'),
('1065', '3', 'Petty Cash - 1st Floor', '', '', NULL, 'LKR', '0', '10', '5805', '0000-00-00 00:00:00', '0', '0', 'CASH!'),
('1070', '3', 'Petty Cash - 2nd Floor', '', '', NULL, 'LKR', '0', '11', '5805', '0000-00-00 00:00:00', '0', '0', 'CASH'),
('1063', '0', 'Debtors control', '', 'Debtors control', NULL, 'LKR', '0', '12', '5805', '0000-00-00 00:00:00', '0', '0', 'SB'),
('1066', '0', 'Sampath Bank - Savings Account', '', 'Sampath Bank - Savings A/C', NULL, 'LKR', '0', '13', '5805', '2020-03-31 01:00:00', '0', '0', 'SB-AC'),
('1068', '0', 'NDB - Savings A/C', '106110427387', 'National Development Bank', NULL, 'LKR', '0', '14', '5805', '2020-09-30 01:00:00', '417706.91', '0', 'NDB'),
('1069', '1', 'NDB-Current A/C', '', 'National Development Bank', NULL, 'LKR', '0', '16', '5805', '2021-09-30 01:00:00', '73244.76', '0', 'NDB-C/A'),
('1071', '1', 'National Development Bank - USD A/C', '', 'National Development Bank ', NULL, 'USD', '0', '17', '5805', '2020-06-30 01:00:00', '43.85', '0', 'NDB-USD A/C'),
('1072', '0', 'NDB Bank -AUD Account', '106590005439', 'NDB Bank', NULL, 'AUD', '0', '18', '5805', '2020-06-30 01:00:00', '395.28', '0', NULL),
('1092', '3', 'SDB - USD', '', '', NULL, 'USD', '0', '20', '5805', '0000-00-00 00:00:00', '0', '1', NULL),
('1093', '2', 'Standard Chartered Bank - Credit Card', '', '', NULL, 'LKR', '0', '21', '5805', '0000-00-00 00:00:00', '0', '0', NULL);

### Structure of table `0_bank_trans` ###

DROP TABLE IF EXISTS `0_bank_trans`;

CREATE TABLE `0_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ref` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `person_type_id` int(11) NOT NULL DEFAULT '0',
  `person_id` tinyblob,
  `reconciled` date DEFAULT NULL,
  `pay_mode` int(1) DEFAULT NULL,
  `cheque_reference` int(6) DEFAULT NULL,
  `payment_increment` int(11) DEFAULT NULL,
  `payment_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_trans` ###


### Structure of table `0_bom` ###

DROP TABLE IF EXISTS `0_bom`;

CREATE TABLE `0_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `component` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT '1',
  `budjet_cost` double NOT NULL,
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bom` ###

INSERT INTO `0_bom` VALUES
('11', 'EMSI', 'EMSISoft-Box', '1', 'EV/S', '1', '0'),
('10', 'EMSI', 'EMSISoft-Disk', '1', 'EV/S', '1', '0'),
('9', 'EMSI', 'oneyear', '1', 'EV/S', '1', '0'),
('12', 'EMSI', 'S/P', '1', 'EV/S', '1', '0'),
('5', 'FSe3year', 'CDs', '1', 'EV/S', '1', '0'),
('6', 'FSe3year', 'Pouch', '1', 'EV/S', '1', '0'),
('4', 'FSe3year', 'Threeyearoneuser', '1', 'EV/S', '1', '0'),
('2', 'LPPCPGFSAV1SBCO', 'CDs', '1', 'EV/S', '1', '0'),
('1', 'LPPCPGFSAV1SBCO', 'oneyear', '1', 'EV/S', '1', '0'),
('3', 'LPPCPGFSAV1SBCO', 'Pouch', '1', 'EV/S', '1', '0');

### Structure of table `0_budget_trans` ###

DROP TABLE IF EXISTS `0_budget_trans`;

CREATE TABLE `0_budget_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `dimension_id` int(11) DEFAULT '0',
  `dimension2_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_budget_trans` ###


### Structure of table `0_chart_class` ###

DROP TABLE IF EXISTS `0_chart_class`;

CREATE TABLE `0_chart_class` (
  `cid` varchar(3) NOT NULL,
  `class_name` varchar(60) NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ;

### Data of table `0_chart_class` ###

INSERT INTO `0_chart_class` VALUES
('1', 'Assets', '1', '0'),
('2', 'Liabilities', '2', '0'),
('3', 'Income', '4', '0'),
('4', 'Costs', '6', '0');

### Structure of table `0_chart_master` ###

DROP TABLE IF EXISTS `0_chart_master`;

CREATE TABLE `0_chart_master` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_code2` varchar(15) NOT NULL DEFAULT '',
  `account_name` varchar(60) NOT NULL DEFAULT '',
  `account_type` varchar(10) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ;

### Data of table `0_chart_master` ###

INSERT INTO `0_chart_master` VALUES
('1060', '', 'Sampath Bank - Current Account', '2.4', '0'),
('1065', '', 'Petty Cash - 1st  Floor', '2.4', '0'),
('1200', '', 'Accounts Receivable ', '2.2', '0'),
('1205', '', 'Allowance for doubtful accounts', '2.2', '0'),
('1510', '', 'Inventory', '2.1', '0'),
('1520', '', 'Stocks of Raw Materials', '2.1', '0'),
('1530', '', 'Stocks of Work In Progress', '2.1', '0'),
('1540', '', 'Stocks of Finsihed Goods', '2.1', '0'),
('1550', '', 'Goods Received Clearing account', '2.1', '0'),
('1820', '', 'Furniture &amp; Fittings', '1.1.1', '0'),
('1840', '', 'Office Equipment', '1.1.1', '0'),
('1860', '', 'Motor Vehicles - Freehold', '1.1.1', '0'),
('2100', '', 'Accounts Payable', '5', '0'),
('2171', '', 'Lease Liability - Short Term Portion - CAT 5081', '5', '0'),
('1063', '', 'Debtors Control', '2.2', '0'),
('5480', '', 'Staff Tea &amp; Meals', '11', '0'),
('2150', '', 'V.A.T Control Account', '5', '0'),
('2160', '', 'P.A.Y.E. Tax Payable', '5', '0'),
('2605', '', 'Gratuity Fund - Involve 360', '5', '0'),
('4200', '', 'Interest Income', '9', '0'),
('2180', '', 'EPF Control Account', '5', '0'),
('1068', '', 'NDB Bank Savings Account-106110427387', '2.4', '0'),
('1084', '', 'CN Global C/A', '2.5', '0'),
('1066', '', 'Sampath Bank - Savings A/C', '2.4', '0'),
('3350', '', 'Share Capital', '6', '0'),
('3590', '', 'Retained Earnings - prior years', '7', '0'),
('4010', '', 'Export Services to Japan', '8', '1'),
('4430', '', 'Shipping &amp; Handling', '10', '0'),
('4440', '', 'Interest', '9', '1'),
('4450', '', 'Foreign Exchange Gain/Loss', '14', '0'),
('4500', '', 'Prompt Payment Discounts', '9', '0'),
('4510', '', 'Cash Discounts Given', '9', '0'),
('5010', '', 'Cost of Sales  -  Accpac Software Develo', '10', '0'),
('5020', '', 'Cost of Sales -  Software export', '10', '0'),
('5030', '', 'Cost of Software Development', '10', '0'),
('5040', '', 'Cost of IT Support Services - Export', '10', '0'),
('5060', '', 'Cost of Sales -  Call Center', '10', '0'),
('5410', '', 'Salaries &amp; Wages Control A/C', '11', '0'),
('5420', '', 'Salaries &amp; Wages ', '11', '0'),
('2600', '', 'Provision for Gratuity', '4', '0'),
('5440', '', 'Staff  O/T and Casual Wages', '11', '0'),
('5450', '', 'Employees Provident Fund ', '11', '0'),
('5460', '', 'Employees Trust fund ', '11', '0'),
('5470', '', 'Staff Training', '11', '0'),
('5510', '', 'Staff Accomadation &amp; Welfare', '11', '0'),
('5520', '', 'Recruitment expenses', '11', '0'),
('5530', '', 'Staff Medical Expenses', '11', '0'),
('5540', '', 'Sales  Incentives - Staff', '11', '0'),
('1900', '', 'Accu. Depreciation - Buildings', '1.1.2', '0'),
('5610', '', 'Audit Fees', '12', '0'),
('5615', '', 'Advertising  Expenses', '13', '0'),
('5620', '', 'Secretarial Expenses', '12', '0'),
('5685', '', 'Insurance', '12', '0'),
('5690', '', 'Overdraft  Interest', '14', '0'),
('5700', '', 'Office Supplies', '12', '0'),
('5760', '', 'Office Rent', '12', '0'),
('5765', '', 'Office Repair &amp; Maintenance', '12', '0'),
('5780', '', 'Telephone &amp; Internet', '11', '0'),
('5785', '', 'Travelling expenses', '12', '0'),
('5790', '', 'Printing &amp; Stationery', '12', '0'),
('5795', '', 'Business Promotion Expenses', '13', '0'),
('5800', '', 'License, Membership &amp; Registration fees', '12', '0'),
('5415', '', 'Staff Salary Advances', '2.3', '0'),
('9990', '', 'Year Profit/Loss', '12', '0'),
('4020', '', 'Annual Maintenence Services', '8', '1'),
('4030', '', 'Local Accpac Software Development Charges', '8', '0'),
('4040', '', 'Export Services - IT Support ', '8', '0'),
('4050', '', 'Export Services - Call Centre', '8', '0'),
('5770', '', 'Office Cleaning &amp; Maintenence', '12', '0'),
('5805', '', 'Bank charges', '14', '0'),
('1080', '', 'Current Account - K.P.L.P', '5', '0'),
('1260', '', 'Involve 360 (Pvt)Ltd.', '2', '0'),
('2661', '', 'Lease Liability - Long Term Portion - CAT 5081', '4', '0'),
('5815', '', 'Water Bill', '12', '0'),
('1081', '', 'K.P.L.Pintoe - Drawings', '2.5', '0'),
('5775', '', 'Motor Vehicle Maintenence', '12', '0'),
('2170', '', 'Lease Liability - Short Term Portion - CAC 9188', '5', '0'),
('5890', '', 'Other expenses', '12', '0'),
('5771', '', 'Maintenence of Equipments', '12', '0'),
('1250', 'd', 'Deposits and Advances', '2.3', '0'),
('5820', '', 'Electricity', '12', '0'),
('1082', '', 'Directors C/A - Ashan  Pintoe', '2.5', '0'),
('1240', '', 'Staff Debtors', '2.5', '0'),
('1061', '', 'Sampath Bank - Sterling Pounds', '2.4', '0'),
('1062', '', 'Sampath Bank - US Dollars', '2.4', '0'),
('1070', '', 'Petty Cash - 2nd  Floor', '2.4', '0'),
('2110', '', 'Accrued Charges', '5', '0'),
('4060', '', 'Sales -  EMSISOFT Antivirus  Software', '8', '0'),
('1245', '', 'Withholding Tax', '14', '0'),
('4070', '', 'Software Training Income', '8', '0'),
('1265', '', 'Inbay Limited - Current Account', '2.5', '0'),
('5792', '', 'Postage &amp; Stamps', '12', '0'),
('5825', '', 'Donations &amp; Charity', '12', '0'),
('5802', '', 'Legal Expenses', '12', '0'),
('2620', '', 'Bank Loan - Pan Asia Bank', '4', '0'),
('5830', '', 'New Year Gifts &amp; Presents', '12', '0'),
('1090', '', 'Pan Asia Bank C/A', '2.4', '0'),
('1570', '', 'Import Control Account', '2.1', '0'),
('4015', '', 'Evolve Software Development Income', '8', '0'),
('5550', '', 'Staff Bonus', '11', '0'),
('5500', '', 'Staff  Travelling and Batta', '11', '0'),
('5895', '', 'Depreciation ', '12', '0'),
('5910', '', 'Bank loan Interest - Vehicle', '14', '0'),
('1067', '', 'NDB Bank Savings Account-106110427387', '2.4', '1'),
('2660', '', 'Lease Liability - Long Term Portion - CAC9188', '4', '0'),
('1230', '', 'Accounts Receivable - Export Services', '2.2', '0'),
('1202', '', 'Accounts Receivable - Export Services', '2.2', '0'),
('4520', '', 'Profit from Sale of Assets', '9', '0'),
('1800', '', 'Land ', '1.1.1', '0'),
('1810', '', 'Plant &amp; Machinery', '1.1.1', '0'),
('1845', '', 'Computer Equipment', '1.1.1', '0'),
('1807', '', 'Crockery &amp; Cutlery', '3', '1'),
('1830', '', 'Acc. Depreciation -  Furniture &amp; Fittings', '3', '1'),
('1831', '', 'Acc. Depreciation -  Telephone', '3', '1'),
('1832', '', 'Acc. Depreciation -  Linen', '3', '1'),
('1833', '', 'Acc. Depreciation -  Crockery &amp; Cutlery', '3', '1'),
('4215', '', 'Other Income', '9', '0'),
('2020', '', 'Investment in Fixed Deposits', '1.2', '0'),
('2010', '', 'Investment in Shares', '1.2', '0'),
('1203', '', 'Accounts Receivable - Software', '2.2', '0'),
('2000', '', 'Investment in Subsidiaries', '1.2', '0'),
('1204', '', 'Accounts Receivable -  F-Secure Division', '2.2', '0'),
('5080', '', 'Printing &amp; Packing charges', '10', '0'),
('5090', '', 'Transport &amp; Delivery', '10', '0'),
('1083', '', 'Directors Current Account - Nishantha Pintoe', '2.5', '0'),
('2155', '', 'N.B.T Tax', '5', '0'),
('4210', '', 'Dividend Income', '9', '0'),
('1255', '', 'Preliminary Expenses', '2.3', '0'),
('5772', '', 'Computer and Software charges', '12', '0'),
('5920', '', 'Lease Interest', '14', '0'),
('5761', '', 'Security Charges', '12', '0'),
('2610', '', 'Bank Loan - Sampath', '4', '0'),
('5915', '', 'Bank loan interest ', '14', '0'),
('5835', '', 'Generator Maintenence', '12', '0'),
('4045', '', 'Export of Software Development Services', '8', '0'),
('5551', '', 'Staff Loan', '2.3', '0'),
('5925', '', 'Gain/Loss from Investment Shares', '9', '0'),
('2185', '', 'ETF Control A/C', '5', '0'),
('4525', '', 'Profit from sale of Vehicles', '9', '0'),
('5762', '', 'Rates &amp; Taxes', '12', '0'),
('4075', '', 'Exports - Bookkeeping services ', '8', '0'),
('5035', '', 'Cost of Sales - EMSISOFT', '10', '0'),
('2151', '', 'Input VAT', '5', '0'),
('1064', '', 'Sampath Bank - Australian Dollar A/C', '2.4', '0'),
('1251', '', 'Customer Advance', '2.3', '0'),
('2650', '', 'With Holding Tax Payable', '5', '0'),
('5796', '', 'Foreign Travel Expenses', '13', '0'),
('1910', '', 'Acc. Depn - Plant &amp; Machinery', '1.1.2', '0'),
('1801', '', 'Buildings', '1.1.1', '0'),
('1870', '', 'Motor Vehicle - Leasehold', '1.1.1', '0'),
('1920', '', 'Accu. Depreciation - Furniture &amp; Fittings', '1.1.2', '0'),
('1940', '', 'Accu. Depreciation - Office Equipment', '1.1.2', '0'),
('1945', '', 'Accu. Depreciation - Computer Equipment', '1.1.2', '0'),
('1960', '', 'Accu. Depreciation - Freehold Vehicles', '1.1.2', '0'),
('1970', '', 'Accu. Depreciation - Leasehold Vehicles', '1.1.2', '0'),
('2005', '', 'Investment in Subsidiaries-C/N Global', '1.2', '0'),
('2615', '', 'Bank Loan - NDB 01 ( 7M )', '4', '0'),
('2616', '', 'Bank Loan - NDB 02 ( 35M )', '4', '0'),
('2617', '', 'Bank Loan - NDB 03 ( 8M )', '4', '0'),
('1085', '', 'Loan Account - Suren', '5', '0'),
('1069', '', 'NDB Bank Current Account', '2.4', '0'),
('2186', '', 'Staff Gratuity ', '11', '0'),
('1071', '', 'NDB Bank USD A/C', '2.4', '0'),
('1072', '', 'NDB Bank - AUD Account', '2.4', '0'),
('5515', '', 'Consultancy Fee', '11', '0'),
('1252', '', 'Tax Refunds Due', '2.3', '0'),
('1091', '', 'NDB Bank - Wealth Management A/C', '2.4', '0'),
('4065', '', 'Sales - e-Storage products', '8', '0'),
('5036', '', 'Cost of Sales - eStorage Products', '10', '0'),
('1092', '', 'SDB', '2.4', '0'),
('2618', '', 'Bank Loan-PABC Covid 19', '4', '0'),
('2619', '', 'Bank Loan-NDB Covid 19', '4', '0'),
('1093', '', 'Standard Chartered Bank - Credit Card', '2.4', '0'),
('2621', '', 'Moratorium Loan', '4', '0');

### Structure of table `0_chart_types` ###

DROP TABLE IF EXISTS `0_chart_types`;

CREATE TABLE `0_chart_types` (
  `id` varchar(10) NOT NULL,
  `name` varchar(60) NOT NULL DEFAULT '',
  `class_id` varchar(3) NOT NULL DEFAULT '',
  `parent` varchar(10) NOT NULL DEFAULT '-1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ;

### Data of table `0_chart_types` ###

INSERT INTO `0_chart_types` VALUES
('2', 'Current Assets', '1', '', '0'),
('2.1', 'Inventory', '1', '2', '0'),
('3', 'Equity &amp; Liabilities', '2', '', '0'),
('4', 'Non Current Liabilities', '2', '', '0'),
('5', 'Current  Liabilities', '2', '', '0'),
('6', 'Share Capital', '2', '', '0'),
('7', 'Retained Earnings', '2', '', '0'),
('8', 'Sales Revenue', '3', '', '0'),
('9', 'Other Revenue', '3', '', '0'),
('10', 'Cost of Goods Sold', '4', '', '0'),
('11', 'Operating  Expenses', '4', '', '0'),
('12', 'General &amp; Administrative expenses', '4', '', '0'),
('13', 'Sales &amp; Distribution Expenses', '4', '', '0'),
('14', 'Finance  Cost', '4', '', '0'),
('2.4', 'Cash &amp; Cash Equivalent', '1', '2', '0'),
('2.2', 'Accounts Receivable', '1', '2', '0'),
('2.5', 'Other Current Assets', '1', '2', '0'),
('2.3', 'Deposits &amp; Advances', '1', '2', '0'),
('1.', 'Assets', '1', '', '0'),
('1.1', 'Property, Plant &amp; Equipment', '1', '1.', '0'),
('1.2', 'Non Current  Assets', '1', '1.', '0'),
('3.1', 'Capital &amp; Reserves', '2', '', '0'),
('1.1.1', 'Assets', '1', '1.1', '0'),
('1.1.2', 'Depreciation', '1', '1.1', '0');

### Structure of table `0_cheque_books` ###

DROP TABLE IF EXISTS `0_cheque_books`;

CREATE TABLE `0_cheque_books` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(6) NOT NULL DEFAULT '0',
  `branch_code` varchar(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bank_code` varchar(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cheqeu_book_no` int(5) DEFAULT NULL,
  `chque_start_no` varchar(6) COLLATE utf8_unicode_ci DEFAULT NULL,
  `chque_end_no` varchar(6) COLLATE utf8_unicode_ci DEFAULT NULL,
  `added_date` datetime NOT NULL,
  `version` int(5) DEFAULT '0',
  `next_no_payment` varchar(6) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user` int(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cheque_books` ###

INSERT INTO `0_cheque_books` VALUES
('1', '10', NULL, NULL, '0', NULL, NULL, '2018-01-26 03:23:22', '1', NULL, '1', '1'),
('2', '3', '001', '7278', '1', '988134', '988150', '2018-01-15 22:45:44', '0', '2', '1', '1'),
('5', '3', '001', '7278', '2', '988190', '988200', '2018-02-14 04:37:50', '4', '988201', '1', '1'),
('7', '3', '001', '7278', '4', '988301', '988350', '2018-03-20 05:56:45', '1', '988351', '1', '1'),
('8', '3', '001', '7278', '5', '988254', '988300', '2018-04-06 03:03:37', '0', '988301', '1', '1'),
('9', '3', '001', '7278', '6', '988351', '988450', '2018-06-13 03:05:49', '1', '988451', '1', '1'),
('10', '3', '001', '7278', '7', '988451', '989240', '2020-02-10 04:09:00', '16', '988451', '1', '1'),
('11', '4', '009', '7311', '1', '869873', '869880', '2018-09-10 01:09:29', '1', '869881', '1', '1'),
('12', '4', '009', '7311', '3', '869881', '869930', '2019-03-15 01:34:54', '2', '869881', '1', '1'),
('13', '4', '009', '7311', '4', '001721', '001770', '2019-03-15 01:34:26', '0', '1769', '1', '1'),
('14', '4', '009', '7311', '5', '002046', '002095', '2019-07-22 05:32:59', '0', '2094', '1', '1'),
('15', '16', '001', '7214', '2', '896711', '896760', '2020-08-18 04:58:47', '1', '896761', '1', '1'),
('16', '3', '001', '7278', '8', '989301', '989350', '2020-06-23 03:09:13', '7', '989085', '1', '1'),
('17', '16', '001', '7214', '3', '198596', '198645', '2020-10-16 04:11:26', '0', '198629', '1', '0'),
('18', '3', '001', '7278', '9', '989467', '989600', '2021-10-25 02:03:20', '5', '989505', '1', '0'),
('19', '4', '009', '7311', '6', '001444', '001449', '2021-02-02 05:26:58', '2', '001444', '1', '1'),
('20', '4', '009', '7311', '7', '014442', '014490', '2021-02-02 05:28:25', '1', '14467', '1', '0');

### Structure of table `0_comments` ###

DROP TABLE IF EXISTS `0_comments`;

CREATE TABLE `0_comments` (
  `type` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_comments` ###


### Structure of table `0_credit_status` ###

DROP TABLE IF EXISTS `0_credit_status`;

CREATE TABLE `0_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_credit_status` ###

INSERT INTO `0_credit_status` VALUES
('1', 'Good History', '0', '0'),
('3', 'No more work until payment received', '1', '0'),
('4', 'In liquidation', '1', '0');

### Structure of table `0_crm_categories` ###

DROP TABLE IF EXISTS `0_crm_categories`;

CREATE TABLE `0_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `system` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_categories` ###

INSERT INTO `0_crm_categories` VALUES
('1', 'cust_branch', 'general', 'General', 'General contact data for customer branch (overrides company setting)', '1', '0'),
('2', 'cust_branch', 'invoice', 'Invoices', 'Invoice posting (overrides company setting)', '1', '0'),
('3', 'cust_branch', 'order', 'Orders', 'Order confirmation (overrides company setting)', '1', '0'),
('4', 'cust_branch', 'delivery', 'Deliveries', 'Delivery coordination (overrides company setting)', '1', '0'),
('5', 'customer', 'general', 'General', 'General contact data for customer', '1', '0'),
('6', 'customer', 'order', 'Orders', 'Order confirmation', '1', '0'),
('7', 'customer', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('8', 'customer', 'invoice', 'Invoices', 'Invoice posting', '1', '0'),
('9', 'supplier', 'general', 'General', 'General contact data for supplier', '1', '0'),
('10', 'supplier', 'order', 'Orders', 'Order confirmation', '1', '0'),
('11', 'supplier', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('12', 'supplier', 'invoice', 'Invoices', 'Invoice posting', '1', '0');

### Structure of table `0_crm_contacts` ###

DROP TABLE IF EXISTS `0_crm_contacts`;

CREATE TABLE `0_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT '0' COMMENT 'foreign key to crm_contacts',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `entity_id` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=2081 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_contacts` ###

INSERT INTO `0_crm_contacts` VALUES
('1', '1', 'supplier', 'general', '1'),
('2', '2', 'supplier', 'general', '2'),
('3', '3', 'supplier', 'general', '3'),
('4', '4', 'supplier', 'general', '4'),
('5', '5', 'cust_branch', 'general', '1'),
('6', '6', 'cust_branch', 'general', '2'),
('7', '7', 'cust_branch', 'general', '3'),
('8', '8', 'cust_branch', 'general', '4'),
('9', '9', 'cust_branch', 'general', '5'),
('10', '10', 'cust_branch', 'general', '6'),
('11', '11', 'cust_branch', 'general', '7'),
('13', '13', 'cust_branch', 'general', '9'),
('14', '14', 'cust_branch', 'general', '10'),
('15', '15', 'supplier', 'general', '5'),
('16', '16', 'supplier', 'general', '6'),
('17', '17', 'supplier', 'general', '7'),
('18', '18', 'cust_branch', 'general', '11'),
('19', '19', 'cust_branch', 'general', '12'),
('21', '21', 'cust_branch', 'general', '14'),
('22', '22', 'cust_branch', 'general', '15'),
('23', '23', 'cust_branch', 'general', '16'),
('24', '24', 'cust_branch', 'general', '17'),
('25', '25', 'cust_branch', 'general', '18'),
('26', '26', 'supplier', 'general', '8'),
('27', '27', 'supplier', 'general', '9'),
('28', '28', 'cust_branch', 'general', '19'),
('32', '32', 'cust_branch', 'general', '23'),
('35', '35', 'cust_branch', 'general', '26'),
('36', '36', 'cust_branch', 'general', '27'),
('37', '37', 'cust_branch', 'general', '28'),
('38', '38', 'cust_branch', 'general', '29'),
('44', '44', 'cust_branch', 'general', '35'),
('45', '45', 'cust_branch', 'general', '36'),
('46', '46', 'cust_branch', 'general', '37'),
('47', '47', 'cust_branch', 'general', '38'),
('48', '48', 'cust_branch', 'general', '39'),
('49', '49', 'cust_branch', 'general', '40'),
('51', '51', 'cust_branch', 'general', '42'),
('52', '52', 'cust_branch', 'general', '43'),
('53', '53', 'supplier', 'general', '10'),
('54', '54', 'cust_branch', 'general', '45'),
('55', '55', 'cust_branch', 'general', '46'),
('56', '56', 'cust_branch', 'general', '47'),
('57', '57', 'cust_branch', 'general', '48'),
('58', '58', 'cust_branch', 'general', '49'),
('59', '59', 'cust_branch', 'general', '50'),
('60', '60', 'cust_branch', 'general', '51'),
('61', '61', 'cust_branch', 'general', '52'),
('62', '62', 'cust_branch', 'general', '53'),
('63', '63', 'cust_branch', 'general', '54'),
('65', '65', 'cust_branch', 'general', '56'),
('66', '66', 'cust_branch', 'general', '57'),
('68', '68', 'cust_branch', 'general', '59'),
('70', '70', 'cust_branch', 'general', '61'),
('73', '73', 'cust_branch', 'general', '64'),
('76', '76', 'cust_branch', 'general', '67'),
('77', '77', 'cust_branch', 'general', '68'),
('78', '78', 'cust_branch', 'general', '69'),
('79', '79', 'cust_branch', 'general', '70'),
('81', '81', 'cust_branch', 'general', '72'),
('82', '82', 'cust_branch', 'general', '73'),
('83', '83', 'cust_branch', 'general', '74'),
('84', '84', 'cust_branch', 'general', '75'),
('85', '85', 'cust_branch', 'general', '76'),
('86', '86', 'cust_branch', 'general', '77'),
('87', '87', 'cust_branch', 'general', '78'),
('88', '88', 'cust_branch', 'general', '79'),
('89', '89', 'cust_branch', 'general', '80'),
('90', '90', 'cust_branch', 'general', '81'),
('91', '91', 'cust_branch', 'general', '82'),
('92', '92', 'cust_branch', 'general', '83'),
('93', '93', 'cust_branch', 'general', '84'),
('94', '94', 'cust_branch', 'general', '85'),
('95', '95', 'cust_branch', 'general', '86'),
('96', '96', 'cust_branch', 'general', '87'),
('97', '97', 'supplier', 'general', '11'),
('99', '99', 'supplier', 'general', '12'),
('100', '100', 'cust_branch', 'general', '89'),
('102', '102', 'cust_branch', 'general', '91'),
('103', '103', 'cust_branch', 'general', '92'),
('104', '104', 'supplier', 'general', '13'),
('105', '105', 'cust_branch', 'general', '93'),
('106', '106', 'cust_branch', 'general', '94'),
('107', '107', 'cust_branch', 'general', '95'),
('109', '109', 'cust_branch', 'general', '97'),
('110', '110', 'cust_branch', 'general', '98'),
('111', '111', 'cust_branch', 'general', '99'),
('112', '112', 'cust_branch', 'general', '100'),
('113', '113', 'cust_branch', 'general', '101'),
('114', '114', 'cust_branch', 'general', '102'),
('115', '115', 'cust_branch', 'general', '103'),
('116', '116', 'cust_branch', 'general', '104'),
('117', '117', 'cust_branch', 'general', '105'),
('118', '118', 'cust_branch', 'general', '106'),
('119', '119', 'cust_branch', 'general', '107'),
('121', '121', 'cust_branch', 'general', '109'),
('122', '122', 'cust_branch', 'general', '110'),
('123', '123', 'cust_branch', 'general', '111'),
('125', '125', 'cust_branch', 'general', '113'),
('126', '126', 'cust_branch', 'general', '114'),
('127', '127', 'cust_branch', 'general', '115'),
('128', '128', 'cust_branch', 'general', '116'),
('129', '129', 'cust_branch', 'general', '117'),
('130', '130', 'cust_branch', 'general', '118'),
('131', '131', 'cust_branch', 'general', '119'),
('132', '132', 'cust_branch', 'general', '120'),
('133', '133', 'cust_branch', 'general', '121'),
('134', '134', 'cust_branch', 'general', '122'),
('135', '135', 'cust_branch', 'general', '123'),
('136', '136', 'cust_branch', 'general', '124'),
('137', '137', 'cust_branch', 'general', '125'),
('139', '139', 'cust_branch', 'general', '129'),
('140', '140', 'cust_branch', 'general', '130'),
('141', '141', 'cust_branch', 'general', '131'),
('142', '142', 'cust_branch', 'general', '132'),
('143', '143', 'cust_branch', 'general', '133'),
('144', '144', 'supplier', 'general', '14'),
('145', '145', 'cust_branch', 'general', '134'),
('146', '146', 'cust_branch', 'general', '135'),
('147', '147', 'cust_branch', 'general', '136'),
('148', '148', 'cust_branch', 'general', '137'),
('149', '149', 'cust_branch', 'general', '138'),
('150', '150', 'cust_branch', 'general', '139'),
('151', '151', 'cust_branch', 'general', '140'),
('152', '152', 'cust_branch', 'general', '141'),
('153', '153', 'cust_branch', 'general', '142'),
('154', '154', 'cust_branch', 'general', '143'),
('155', '155', 'cust_branch', 'general', '144'),
('156', '156', 'cust_branch', 'general', '145'),
('158', '158', 'cust_branch', 'general', '147'),
('159', '159', 'cust_branch', 'general', '148'),
('160', '160', 'cust_branch', 'general', '149'),
('161', '161', 'cust_branch', 'general', '150'),
('162', '162', 'cust_branch', 'general', '151'),
('163', '163', 'cust_branch', 'general', '152'),
('164', '164', 'cust_branch', 'general', '153'),
('165', '165', 'cust_branch', 'general', '154'),
('166', '166', 'supplier', 'general', '15'),
('167', '167', 'supplier', 'general', '16'),
('168', '168', 'supplier', 'general', '17'),
('169', '169', 'cust_branch', 'general', '155'),
('170', '170', 'cust_branch', 'general', '156'),
('171', '171', 'cust_branch', 'general', '157'),
('172', '172', 'cust_branch', 'general', '158'),
('173', '173', 'cust_branch', 'general', '159'),
('174', '174', 'supplier', 'general', '18'),
('175', '175', 'cust_branch', 'general', '160'),
('176', '176', 'cust_branch', 'general', '161'),
('177', '177', 'cust_branch', 'general', '162'),
('178', '178', 'supplier', 'general', '19'),
('179', '179', 'supplier', 'general', '20'),
('180', '180', 'supplier', 'general', '21'),
('181', '181', 'supplier', 'general', '22'),
('182', '182', 'supplier', 'general', '23'),
('183', '183', 'supplier', 'general', '24'),
('184', '184', 'supplier', 'general', '25'),
('185', '185', 'cust_branch', 'general', '163'),
('186', '186', 'cust_branch', 'general', '164'),
('187', '187', 'cust_branch', 'general', '165'),
('188', '188', 'cust_branch', 'general', '166'),
('189', '189', 'cust_branch', 'general', '167'),
('190', '190', 'cust_branch', 'general', '168'),
('191', '191', 'cust_branch', 'general', '169'),
('192', '192', 'cust_branch', 'general', '170'),
('193', '193', 'cust_branch', 'general', '171'),
('194', '194', 'cust_branch', 'general', '172'),
('195', '195', 'cust_branch', 'general', '173'),
('196', '196', 'cust_branch', 'general', '174'),
('197', '197', 'cust_branch', 'general', '175'),
('198', '198', 'cust_branch', 'general', '176'),
('199', '199', 'cust_branch', 'general', '177'),
('200', '200', 'cust_branch', 'general', '178'),
('201', '201', 'cust_branch', 'general', '179'),
('202', '202', 'cust_branch', 'general', '180'),
('203', '203', 'cust_branch', 'general', '181'),
('204', '204', 'cust_branch', 'general', '182'),
('205', '205', 'cust_branch', 'general', '183'),
('206', '206', 'cust_branch', 'general', '184'),
('207', '207', 'cust_branch', 'general', '185'),
('208', '208', 'cust_branch', 'general', '186'),
('209', '209', 'cust_branch', 'general', '187'),
('210', '210', 'cust_branch', 'general', '188'),
('211', '211', 'cust_branch', 'general', '189'),
('212', '212', 'cust_branch', 'general', '190'),
('213', '213', 'cust_branch', 'general', '191'),
('214', '214', 'cust_branch', 'general', '192'),
('215', '215', 'cust_branch', 'general', '193'),
('216', '216', 'cust_branch', 'general', '194'),
('217', '217', 'cust_branch', 'general', '195'),
('218', '218', 'cust_branch', 'general', '196'),
('219', '219', 'cust_branch', 'general', '197'),
('220', '220', 'cust_branch', 'general', '198'),
('221', '221', 'cust_branch', 'general', '199'),
('222', '222', 'cust_branch', 'general', '200'),
('223', '223', 'cust_branch', 'general', '201'),
('224', '224', 'cust_branch', 'general', '202'),
('225', '225', 'cust_branch', 'general', '203'),
('226', '226', 'cust_branch', 'general', '204'),
('227', '227', 'cust_branch', 'general', '205'),
('228', '228', 'cust_branch', 'general', '206'),
('229', '229', 'cust_branch', 'general', '207'),
('230', '230', 'cust_branch', 'general', '208'),
('231', '231', 'cust_branch', 'general', '209'),
('232', '232', 'cust_branch', 'general', '210'),
('233', '233', 'cust_branch', 'general', '211'),
('234', '234', 'cust_branch', 'general', '212'),
('235', '235', 'cust_branch', 'general', '213'),
('236', '236', 'cust_branch', 'general', '214'),
('237', '237', 'cust_branch', 'general', '215'),
('238', '238', 'cust_branch', 'general', '216'),
('239', '239', 'cust_branch', 'general', '217'),
('240', '240', 'cust_branch', 'general', '218'),
('241', '241', 'cust_branch', 'general', '219'),
('242', '242', 'cust_branch', 'general', '220'),
('243', '243', 'supplier', 'general', '26'),
('244', '244', 'supplier', 'general', '27'),
('245', '245', 'supplier', 'general', '28'),
('246', '246', 'cust_branch', 'general', '221'),
('247', '247', 'supplier', 'general', '29'),
('248', '248', 'supplier', 'general', '30'),
('249', '249', 'cust_branch', 'general', '222'),
('250', '250', 'cust_branch', 'general', '223'),
('251', '251', 'cust_branch', 'general', '224'),
('252', '252', 'cust_branch', 'general', '225'),
('253', '253', 'cust_branch', 'general', '226'),
('254', '254', 'cust_branch', 'general', '227'),
('255', '255', 'cust_branch', 'general', '228'),
('256', '256', 'cust_branch', 'general', '229'),
('257', '257', 'cust_branch', 'general', '230'),
('258', '258', 'cust_branch', 'general', '231'),
('260', '260', 'cust_branch', 'general', '233'),
('261', '261', 'cust_branch', 'general', '234'),
('262', '262', 'cust_branch', 'general', '235'),
('263', '263', 'cust_branch', 'general', '236'),
('264', '264', 'cust_branch', 'general', '237'),
('265', '265', 'cust_branch', 'general', '238'),
('266', '266', 'cust_branch', 'general', '239'),
('267', '267', 'cust_branch', 'general', '240'),
('268', '268', 'cust_branch', 'general', '241'),
('269', '269', 'cust_branch', 'general', '242'),
('271', '271', 'cust_branch', 'general', '244'),
('272', '272', 'cust_branch', 'general', '245'),
('273', '273', 'cust_branch', 'general', '246'),
('274', '274', 'cust_branch', 'general', '247'),
('275', '275', 'cust_branch', 'general', '248'),
('276', '276', 'cust_branch', 'general', '249'),
('277', '277', 'cust_branch', 'general', '250'),
('278', '278', 'cust_branch', 'general', '251'),
('279', '279', 'supplier', 'general', '31'),
('280', '280', 'supplier', 'general', '32'),
('281', '281', 'cust_branch', 'general', '252'),
('282', '282', 'cust_branch', 'general', '253'),
('283', '283', 'cust_branch', 'general', '254'),
('284', '284', 'cust_branch', 'general', '255'),
('286', '286', 'cust_branch', 'general', '257'),
('287', '287', 'cust_branch', 'general', '258'),
('288', '288', 'cust_branch', 'general', '259'),
('289', '289', 'cust_branch', 'general', '260'),
('290', '290', 'cust_branch', 'general', '261'),
('291', '291', 'cust_branch', 'general', '262'),
('292', '292', 'cust_branch', 'general', '263'),
('293', '293', 'cust_branch', 'general', '264'),
('294', '294', 'cust_branch', 'general', '265'),
('295', '295', 'cust_branch', 'general', '266'),
('296', '296', 'cust_branch', 'general', '267'),
('297', '297', 'cust_branch', 'general', '268'),
('298', '298', 'cust_branch', 'general', '269'),
('299', '299', 'cust_branch', 'general', '270'),
('301', '301', 'cust_branch', 'general', '272'),
('302', '302', 'cust_branch', 'general', '273'),
('303', '303', 'cust_branch', 'general', '274'),
('304', '304', 'cust_branch', 'general', '275'),
('305', '305', 'cust_branch', 'general', '276'),
('306', '306', 'cust_branch', 'general', '277'),
('307', '307', 'cust_branch', 'general', '278'),
('308', '308', 'cust_branch', 'general', '279'),
('309', '309', 'cust_branch', 'general', '280'),
('310', '310', 'cust_branch', 'general', '281'),
('311', '311', 'cust_branch', 'general', '282'),
('312', '312', 'cust_branch', 'general', '283'),
('313', '313', 'cust_branch', 'general', '284'),
('314', '314', 'cust_branch', 'general', '285'),
('315', '315', 'cust_branch', 'general', '286'),
('316', '316', 'cust_branch', 'general', '287'),
('317', '317', 'cust_branch', 'general', '288'),
('318', '318', 'cust_branch', 'general', '289'),
('319', '319', 'cust_branch', 'general', '290'),
('320', '320', 'cust_branch', 'general', '291'),
('321', '321', 'cust_branch', 'general', '292'),
('323', '323', 'cust_branch', 'general', '294'),
('324', '324', 'cust_branch', 'general', '295'),
('325', '325', 'cust_branch', 'general', '296'),
('326', '326', 'cust_branch', 'general', '297'),
('327', '327', 'cust_branch', 'general', '298'),
('328', '328', 'cust_branch', 'general', '299'),
('329', '329', 'cust_branch', 'general', '300'),
('330', '330', 'cust_branch', 'general', '301'),
('331', '331', 'cust_branch', 'general', '302'),
('332', '332', 'cust_branch', 'general', '303'),
('333', '333', 'cust_branch', 'general', '304'),
('334', '334', 'cust_branch', 'general', '305'),
('335', '335', 'cust_branch', 'general', '306'),
('336', '336', 'cust_branch', 'general', '307'),
('337', '337', 'cust_branch', 'general', '308'),
('338', '338', 'cust_branch', 'general', '309'),
('339', '339', 'cust_branch', 'general', '310'),
('340', '340', 'cust_branch', 'general', '311'),
('341', '341', 'cust_branch', 'general', '312'),
('342', '342', 'cust_branch', 'general', '313'),
('343', '343', 'cust_branch', 'general', '314'),
('344', '344', 'cust_branch', 'general', '315'),
('345', '345', 'cust_branch', 'general', '316'),
('346', '346', 'cust_branch', 'general', '317'),
('347', '347', 'cust_branch', 'general', '318'),
('348', '348', 'cust_branch', 'general', '319'),
('349', '349', 'cust_branch', 'general', '320'),
('350', '350', 'cust_branch', 'general', '321'),
('351', '351', 'cust_branch', 'general', '322'),
('352', '352', 'cust_branch', 'general', '323'),
('353', '353', 'cust_branch', 'general', '324'),
('354', '354', 'cust_branch', 'general', '325'),
('355', '355', 'cust_branch', 'general', '326'),
('356', '356', 'cust_branch', 'general', '327'),
('357', '357', 'cust_branch', 'general', '328'),
('358', '358', 'cust_branch', 'general', '329'),
('359', '359', 'cust_branch', 'general', '330'),
('360', '360', 'cust_branch', 'general', '331'),
('361', '361', 'cust_branch', 'general', '332'),
('362', '362', 'supplier', 'general', '33'),
('363', '363', 'cust_branch', 'general', '333'),
('364', '364', 'cust_branch', 'general', '334'),
('365', '365', 'cust_branch', 'general', '335'),
('366', '366', 'cust_branch', 'general', '336'),
('367', '367', 'cust_branch', 'general', '337'),
('368', '368', 'cust_branch', 'general', '338'),
('369', '369', 'supplier', 'general', '34'),
('370', '370', 'supplier', 'general', '35'),
('371', '371', 'cust_branch', 'general', '339'),
('373', '373', 'cust_branch', 'general', '341'),
('374', '374', 'cust_branch', 'general', '342'),
('375', '375', 'cust_branch', 'general', '343'),
('376', '376', 'cust_branch', 'general', '344'),
('377', '377', 'cust_branch', 'general', '345'),
('378', '378', 'cust_branch', 'general', '346'),
('379', '379', 'cust_branch', 'general', '347'),
('380', '380', 'cust_branch', 'general', '348'),
('382', '382', 'cust_branch', 'general', '350'),
('383', '383', 'cust_branch', 'general', '351'),
('384', '384', 'cust_branch', 'general', '352'),
('385', '385', 'cust_branch', 'general', '353'),
('386', '386', 'cust_branch', 'general', '354'),
('387', '387', 'cust_branch', 'general', '355'),
('388', '388', 'cust_branch', 'general', '356'),
('389', '389', 'cust_branch', 'general', '357'),
('390', '390', 'cust_branch', 'general', '358'),
('391', '391', 'cust_branch', 'general', '359'),
('392', '392', 'cust_branch', 'general', '360'),
('393', '393', 'cust_branch', 'general', '361'),
('394', '394', 'cust_branch', 'general', '362'),
('395', '395', 'cust_branch', 'general', '363'),
('396', '396', 'cust_branch', 'general', '364'),
('397', '397', 'cust_branch', 'general', '365'),
('398', '398', 'cust_branch', 'general', '366'),
('400', '400', 'cust_branch', 'general', '368'),
('401', '401', 'cust_branch', 'general', '369'),
('402', '402', 'cust_branch', 'general', '370'),
('404', '404', 'cust_branch', 'general', '372'),
('405', '405', 'cust_branch', 'general', '373'),
('406', '406', 'cust_branch', 'general', '374'),
('407', '407', 'cust_branch', 'general', '375'),
('408', '408', 'cust_branch', 'general', '376'),
('409', '409', 'cust_branch', 'general', '377'),
('410', '410', 'cust_branch', 'general', '378'),
('411', '411', 'cust_branch', 'general', '379'),
('412', '412', 'cust_branch', 'general', '380'),
('413', '413', 'cust_branch', 'general', '381'),
('414', '414', 'cust_branch', 'general', '382'),
('415', '415', 'cust_branch', 'general', '383'),
('416', '416', 'cust_branch', 'general', '384'),
('417', '417', 'cust_branch', 'general', '385'),
('418', '418', 'cust_branch', 'general', '386'),
('419', '419', 'supplier', 'general', '36'),
('420', '420', 'cust_branch', 'general', '387'),
('421', '421', 'cust_branch', 'general', '388'),
('422', '422', 'cust_branch', 'general', '389'),
('423', '423', 'cust_branch', 'general', '390'),
('424', '424', 'cust_branch', 'general', '391'),
('425', '425', 'supplier', 'general', '37'),
('426', '426', 'cust_branch', 'general', '392'),
('427', '427', 'cust_branch', 'general', '393'),
('428', '428', 'cust_branch', 'general', '394'),
('429', '429', 'supplier', 'general', '38'),
('430', '430', 'cust_branch', 'general', '395'),
('431', '431', 'cust_branch', 'general', '396'),
('432', '432', 'cust_branch', 'general', '397'),
('433', '433', 'cust_branch', 'general', '398'),
('434', '434', 'cust_branch', 'general', '399'),
('435', '435', 'cust_branch', 'general', '400'),
('436', '436', 'supplier', 'general', '39'),
('437', '437', 'cust_branch', 'general', '401'),
('438', '438', 'cust_branch', 'general', '402'),
('439', '439', 'cust_branch', 'general', '403'),
('440', '440', 'supplier', 'general', '40'),
('441', '441', 'cust_branch', 'general', '404'),
('443', '443', 'cust_branch', 'general', '406'),
('444', '444', 'cust_branch', 'general', '407'),
('445', '445', 'cust_branch', 'general', '408'),
('446', '446', 'cust_branch', 'general', '409'),
('447', '447', 'cust_branch', 'general', '410'),
('448', '448', 'cust_branch', 'general', '411'),
('449', '449', 'cust_branch', 'general', '412'),
('450', '450', 'cust_branch', 'general', '413'),
('451', '451', 'cust_branch', 'general', '414'),
('452', '452', 'cust_branch', 'general', '415'),
('453', '453', 'cust_branch', 'general', '416'),
('454', '454', 'cust_branch', 'general', '417'),
('455', '455', 'cust_branch', 'general', '418'),
('456', '456', 'cust_branch', 'general', '419'),
('457', '457', 'cust_branch', 'general', '420'),
('458', '458', 'cust_branch', 'general', '421'),
('460', '460', 'cust_branch', 'general', '423'),
('461', '461', 'cust_branch', 'general', '424'),
('462', '462', 'cust_branch', 'general', '425'),
('463', '463', 'cust_branch', 'general', '426'),
('464', '464', 'cust_branch', 'general', '427'),
('465', '465', 'cust_branch', 'general', '428'),
('466', '466', 'cust_branch', 'general', '429'),
('467', '467', 'cust_branch', 'general', '430'),
('469', '469', 'cust_branch', 'general', '432'),
('470', '470', 'cust_branch', 'general', '433'),
('471', '471', 'supplier', 'general', '41'),
('472', '472', 'cust_branch', 'general', '434'),
('473', '473', 'cust_branch', 'general', '435'),
('474', '474', 'cust_branch', 'general', '436'),
('475', '475', 'cust_branch', 'general', '437'),
('476', '476', 'cust_branch', 'general', '438'),
('477', '477', 'cust_branch', 'general', '439'),
('478', '478', 'cust_branch', 'general', '440'),
('479', '479', 'cust_branch', 'general', '441'),
('480', '480', 'cust_branch', 'general', '442'),
('481', '481', 'cust_branch', 'general', '443'),
('482', '482', 'cust_branch', 'general', '444'),
('483', '483', 'cust_branch', 'general', '445'),
('484', '484', 'cust_branch', 'general', '446'),
('485', '485', 'cust_branch', 'general', '447'),
('486', '486', 'cust_branch', 'general', '448'),
('487', '487', 'cust_branch', 'general', '449'),
('488', '488', 'cust_branch', 'general', '450'),
('489', '489', 'cust_branch', 'general', '451'),
('490', '490', 'cust_branch', 'general', '452'),
('491', '491', 'cust_branch', 'general', '453'),
('492', '492', 'cust_branch', 'general', '454'),
('493', '493', 'cust_branch', 'general', '455'),
('494', '494', 'cust_branch', 'general', '456'),
('495', '495', 'cust_branch', 'general', '457'),
('496', '496', 'cust_branch', 'general', '458'),
('497', '497', 'cust_branch', 'general', '459'),
('498', '498', 'cust_branch', 'general', '460'),
('499', '499', 'cust_branch', 'general', '461'),
('500', '500', 'cust_branch', 'general', '462'),
('501', '501', 'cust_branch', 'general', '463'),
('502', '502', 'cust_branch', 'general', '464'),
('503', '503', 'cust_branch', 'general', '465'),
('504', '504', 'cust_branch', 'general', '466'),
('505', '505', 'cust_branch', 'general', '467'),
('506', '506', 'cust_branch', 'general', '468'),
('507', '507', 'cust_branch', 'general', '469'),
('508', '508', 'cust_branch', 'general', '470'),
('509', '509', 'cust_branch', 'general', '471'),
('510', '510', 'cust_branch', 'general', '472'),
('511', '511', 'cust_branch', 'general', '473'),
('512', '512', 'cust_branch', 'general', '474'),
('513', '513', 'cust_branch', 'general', '475'),
('514', '514', 'cust_branch', 'general', '476'),
('515', '515', 'cust_branch', 'general', '477'),
('516', '516', 'cust_branch', 'general', '478'),
('517', '517', 'cust_branch', 'general', '479'),
('518', '518', 'cust_branch', 'general', '480'),
('519', '519', 'cust_branch', 'general', '481'),
('520', '520', 'cust_branch', 'general', '482'),
('522', '522', 'cust_branch', 'general', '484'),
('523', '523', 'cust_branch', 'general', '485'),
('524', '524', 'cust_branch', 'general', '486'),
('525', '525', 'cust_branch', 'general', '487'),
('526', '526', 'cust_branch', 'general', '488'),
('527', '527', 'cust_branch', 'general', '489'),
('528', '528', 'cust_branch', 'general', '490'),
('529', '529', 'cust_branch', 'general', '491'),
('530', '530', 'cust_branch', 'general', '492'),
('531', '531', 'cust_branch', 'general', '493'),
('532', '532', 'cust_branch', 'general', '494'),
('533', '533', 'cust_branch', 'general', '495'),
('534', '534', 'cust_branch', 'general', '496'),
('535', '535', 'cust_branch', 'general', '497'),
('536', '536', 'cust_branch', 'general', '498'),
('537', '537', 'cust_branch', 'general', '499'),
('538', '538', 'cust_branch', 'general', '500'),
('539', '539', 'cust_branch', 'general', '501'),
('540', '540', 'cust_branch', 'general', '502'),
('541', '541', 'cust_branch', 'general', '503'),
('542', '542', 'cust_branch', 'general', '504'),
('543', '543', 'cust_branch', 'general', '505'),
('544', '544', 'cust_branch', 'general', '506'),
('545', '545', 'cust_branch', 'general', '507'),
('546', '546', 'cust_branch', 'general', '508'),
('547', '547', 'cust_branch', 'general', '509'),
('548', '548', 'cust_branch', 'general', '510'),
('549', '549', 'cust_branch', 'general', '511'),
('550', '550', 'cust_branch', 'general', '512'),
('551', '551', 'cust_branch', 'general', '513'),
('552', '552', 'cust_branch', 'general', '514'),
('554', '554', 'cust_branch', 'general', '516'),
('555', '555', 'cust_branch', 'general', '517'),
('556', '556', 'cust_branch', 'general', '518'),
('557', '557', 'cust_branch', 'general', '519'),
('558', '558', 'cust_branch', 'general', '520'),
('559', '559', 'cust_branch', 'general', '521'),
('560', '560', 'cust_branch', 'general', '522'),
('561', '561', 'cust_branch', 'general', '523'),
('562', '562', 'cust_branch', 'general', '524'),
('563', '563', 'cust_branch', 'general', '525'),
('564', '564', 'cust_branch', 'general', '526'),
('565', '565', 'cust_branch', 'general', '527'),
('566', '566', 'cust_branch', 'general', '528'),
('567', '567', 'cust_branch', 'general', '529'),
('568', '568', 'cust_branch', 'general', '530'),
('569', '569', 'cust_branch', 'general', '531'),
('570', '570', 'cust_branch', 'general', '532'),
('571', '571', 'cust_branch', 'general', '533'),
('572', '572', 'cust_branch', 'general', '534'),
('573', '573', 'cust_branch', 'general', '535'),
('574', '574', 'cust_branch', 'general', '536'),
('575', '575', 'cust_branch', 'general', '537'),
('576', '576', 'cust_branch', 'general', '538'),
('577', '577', 'cust_branch', 'general', '539'),
('578', '578', 'cust_branch', 'general', '540'),
('579', '579', 'cust_branch', 'general', '541'),
('580', '580', 'cust_branch', 'general', '542'),
('581', '581', 'cust_branch', 'general', '543'),
('582', '582', 'cust_branch', 'general', '544'),
('583', '583', 'cust_branch', 'general', '545'),
('584', '584', 'cust_branch', 'general', '546'),
('585', '585', 'cust_branch', 'general', '547'),
('586', '586', 'cust_branch', 'general', '548'),
('587', '587', 'cust_branch', 'general', '549'),
('588', '588', 'cust_branch', 'general', '550'),
('590', '590', 'cust_branch', 'general', '552'),
('591', '591', 'cust_branch', 'general', '553'),
('592', '592', 'cust_branch', 'general', '554'),
('593', '593', 'cust_branch', 'general', '555'),
('594', '594', 'cust_branch', 'general', '556'),
('595', '595', 'cust_branch', 'general', '557'),
('597', '597', 'supplier', 'general', '42'),
('598', '598', 'cust_branch', 'general', '559'),
('599', '599', 'cust_branch', 'general', '560'),
('600', '600', 'cust_branch', 'general', '561'),
('601', '601', 'cust_branch', 'general', '562'),
('602', '602', 'cust_branch', 'general', '563'),
('603', '603', 'cust_branch', 'general', '564'),
('604', '604', 'cust_branch', 'general', '565'),
('605', '605', 'cust_branch', 'general', '566'),
('606', '606', 'cust_branch', 'general', '567'),
('607', '607', 'cust_branch', 'general', '568'),
('608', '608', 'cust_branch', 'general', '569'),
('609', '609', 'cust_branch', 'general', '570'),
('610', '610', 'cust_branch', 'general', '571'),
('611', '611', 'cust_branch', 'general', '572'),
('612', '612', 'cust_branch', 'general', '573'),
('613', '613', 'cust_branch', 'general', '574'),
('614', '614', 'cust_branch', 'general', '575'),
('615', '615', 'cust_branch', 'general', '576'),
('616', '616', 'cust_branch', 'general', '577'),
('617', '617', 'cust_branch', 'general', '578'),
('618', '618', 'cust_branch', 'general', '579'),
('619', '619', 'cust_branch', 'general', '580'),
('620', '620', 'cust_branch', 'general', '581'),
('621', '621', 'cust_branch', 'general', '582'),
('622', '622', 'cust_branch', 'general', '583'),
('623', '623', 'cust_branch', 'general', '584'),
('624', '624', 'cust_branch', 'general', '585'),
('625', '625', 'cust_branch', 'general', '586'),
('626', '626', 'cust_branch', 'general', '587'),
('627', '627', 'cust_branch', 'general', '588'),
('628', '628', 'cust_branch', 'general', '589'),
('629', '629', 'cust_branch', 'general', '590'),
('630', '630', 'cust_branch', 'general', '591'),
('631', '631', 'cust_branch', 'general', '592'),
('632', '632', 'cust_branch', 'general', '593'),
('633', '633', 'cust_branch', 'general', '594'),
('634', '634', 'cust_branch', 'general', '595'),
('635', '635', 'cust_branch', 'general', '596'),
('636', '636', 'cust_branch', 'general', '597'),
('637', '637', 'cust_branch', 'general', '598'),
('638', '638', 'cust_branch', 'general', '599'),
('639', '639', 'cust_branch', 'general', '600'),
('640', '640', 'cust_branch', 'general', '601'),
('641', '641', 'cust_branch', 'general', '602'),
('642', '642', 'cust_branch', 'general', '603'),
('643', '643', 'cust_branch', 'general', '604'),
('644', '644', 'cust_branch', 'general', '605'),
('645', '645', 'cust_branch', 'general', '606'),
('646', '646', 'cust_branch', 'general', '607'),
('647', '647', 'cust_branch', 'general', '608'),
('648', '648', 'cust_branch', 'general', '609'),
('649', '649', 'cust_branch', 'general', '610'),
('650', '650', 'cust_branch', 'general', '611'),
('651', '651', 'cust_branch', 'general', '612'),
('652', '652', 'cust_branch', 'general', '613'),
('653', '653', 'cust_branch', 'general', '614'),
('654', '654', 'cust_branch', 'general', '615'),
('655', '655', 'cust_branch', 'general', '616'),
('656', '656', 'cust_branch', 'general', '617'),
('657', '657', 'cust_branch', 'general', '618'),
('658', '658', 'cust_branch', 'general', '619'),
('659', '659', 'cust_branch', 'general', '620'),
('660', '660', 'cust_branch', 'general', '621'),
('661', '661', 'cust_branch', 'general', '622'),
('662', '662', 'cust_branch', 'general', '623'),
('663', '663', 'cust_branch', 'general', '624'),
('664', '664', 'cust_branch', 'general', '625'),
('665', '665', 'cust_branch', 'general', '626'),
('666', '666', 'cust_branch', 'general', '627'),
('667', '667', 'cust_branch', 'general', '628'),
('668', '668', 'supplier', 'general', '43'),
('669', '669', 'cust_branch', 'general', '629'),
('670', '670', 'cust_branch', 'general', '630'),
('671', '671', 'cust_branch', 'general', '631'),
('672', '672', 'cust_branch', 'general', '632'),
('673', '673', 'cust_branch', 'general', '633'),
('674', '674', 'cust_branch', 'general', '634'),
('675', '675', 'cust_branch', 'general', '635'),
('676', '676', 'cust_branch', 'general', '636'),
('677', '677', 'cust_branch', 'general', '637'),
('678', '678', 'cust_branch', 'general', '638'),
('679', '679', 'cust_branch', 'general', '639'),
('680', '680', 'cust_branch', 'general', '640'),
('681', '681', 'cust_branch', 'general', '641'),
('682', '682', 'cust_branch', 'general', '642'),
('683', '683', 'cust_branch', 'general', '643'),
('684', '684', 'cust_branch', 'general', '644'),
('685', '685', 'cust_branch', 'general', '645'),
('686', '686', 'cust_branch', 'general', '646'),
('687', '687', 'cust_branch', 'general', '647'),
('688', '688', 'cust_branch', 'general', '648'),
('689', '689', 'cust_branch', 'general', '649'),
('690', '690', 'cust_branch', 'general', '650'),
('691', '691', 'cust_branch', 'general', '651'),
('692', '692', 'cust_branch', 'general', '652'),
('693', '693', 'cust_branch', 'general', '653'),
('694', '694', 'cust_branch', 'general', '654'),
('695', '695', 'cust_branch', 'general', '655'),
('696', '696', 'cust_branch', 'general', '656'),
('697', '697', 'cust_branch', 'general', '657'),
('698', '698', 'cust_branch', 'general', '658'),
('699', '699', 'cust_branch', 'general', '659'),
('700', '700', 'cust_branch', 'general', '660'),
('701', '701', 'cust_branch', 'general', '661'),
('702', '702', 'cust_branch', 'general', '662'),
('703', '703', 'cust_branch', 'general', '663'),
('704', '704', 'cust_branch', 'general', '664'),
('705', '705', 'cust_branch', 'general', '665'),
('706', '706', 'cust_branch', 'general', '666'),
('707', '707', 'cust_branch', 'general', '667'),
('709', '709', 'cust_branch', 'general', '669'),
('710', '710', 'cust_branch', 'general', '670'),
('711', '711', 'cust_branch', 'general', '671'),
('712', '712', 'cust_branch', 'general', '672'),
('713', '713', 'cust_branch', 'general', '673'),
('714', '714', 'cust_branch', 'general', '674'),
('715', '715', 'cust_branch', 'general', '675'),
('716', '716', 'cust_branch', 'general', '676'),
('717', '717', 'cust_branch', 'general', '677'),
('718', '718', 'cust_branch', 'general', '678'),
('719', '719', 'cust_branch', 'general', '679'),
('720', '720', 'cust_branch', 'general', '680'),
('721', '721', 'cust_branch', 'general', '681'),
('722', '722', 'cust_branch', 'general', '682'),
('723', '723', 'cust_branch', 'general', '683'),
('724', '724', 'cust_branch', 'general', '684'),
('725', '725', 'cust_branch', 'general', '685'),
('726', '726', 'cust_branch', 'general', '686'),
('727', '727', 'cust_branch', 'general', '687'),
('728', '728', 'cust_branch', 'general', '688'),
('729', '729', 'cust_branch', 'general', '689'),
('730', '730', 'cust_branch', 'general', '690'),
('731', '731', 'cust_branch', 'general', '691'),
('732', '732', 'cust_branch', 'general', '692'),
('733', '733', 'cust_branch', 'general', '693'),
('734', '734', 'cust_branch', 'general', '694'),
('735', '735', 'cust_branch', 'general', '695'),
('736', '736', 'cust_branch', 'general', '696'),
('737', '737', 'cust_branch', 'general', '697'),
('738', '738', 'cust_branch', 'general', '698'),
('739', '739', 'cust_branch', 'general', '699'),
('740', '740', 'cust_branch', 'general', '700'),
('741', '741', 'cust_branch', 'general', '701'),
('742', '742', 'cust_branch', 'general', '702'),
('743', '743', 'cust_branch', 'general', '703'),
('744', '744', 'cust_branch', 'general', '704'),
('745', '745', 'cust_branch', 'general', '705'),
('746', '746', 'cust_branch', 'general', '706'),
('747', '747', 'cust_branch', 'general', '707'),
('748', '748', 'cust_branch', 'general', '708'),
('749', '749', 'cust_branch', 'general', '709'),
('750', '750', 'cust_branch', 'general', '710'),
('751', '751', 'cust_branch', 'general', '711'),
('752', '752', 'cust_branch', 'general', '712'),
('753', '753', 'cust_branch', 'general', '713'),
('754', '754', 'cust_branch', 'general', '714'),
('755', '755', 'cust_branch', 'general', '715'),
('756', '756', 'cust_branch', 'general', '716'),
('757', '757', 'cust_branch', 'general', '717'),
('758', '758', 'cust_branch', 'general', '718'),
('759', '759', 'cust_branch', 'general', '719'),
('760', '760', 'cust_branch', 'general', '720'),
('761', '761', 'cust_branch', 'general', '721'),
('762', '762', 'cust_branch', 'general', '722'),
('763', '763', 'cust_branch', 'general', '723'),
('764', '764', 'cust_branch', 'general', '724'),
('765', '765', 'cust_branch', 'general', '725'),
('766', '766', 'cust_branch', 'general', '726'),
('767', '767', 'cust_branch', 'general', '727'),
('768', '768', 'supplier', 'general', '44'),
('769', '769', 'cust_branch', 'general', '728'),
('770', '770', 'cust_branch', 'general', '729'),
('771', '771', 'cust_branch', 'general', '730'),
('772', '772', 'supplier', 'general', '45'),
('773', '773', 'cust_branch', 'general', '731'),
('774', '774', 'cust_branch', 'general', '732'),
('775', '775', 'cust_branch', 'general', '733'),
('776', '776', 'cust_branch', 'general', '734'),
('777', '777', 'cust_branch', 'general', '735'),
('778', '778', 'cust_branch', 'general', '736'),
('779', '779', 'cust_branch', 'general', '737'),
('780', '780', 'cust_branch', 'general', '738'),
('781', '781', 'cust_branch', 'general', '739'),
('782', '782', 'cust_branch', 'general', '740'),
('783', '783', 'cust_branch', 'general', '741'),
('784', '784', 'cust_branch', 'general', '742'),
('785', '785', 'supplier', 'general', '46'),
('786', '786', 'cust_branch', 'general', '743'),
('787', '787', 'cust_branch', 'general', '744'),
('788', '788', 'cust_branch', 'general', '745'),
('789', '789', 'cust_branch', 'general', '746'),
('790', '790', 'cust_branch', 'general', '747'),
('791', '791', 'cust_branch', 'general', '748'),
('792', '792', 'cust_branch', 'general', '749'),
('793', '793', 'cust_branch', 'general', '750'),
('794', '794', 'supplier', 'general', '47'),
('795', '795', 'cust_branch', 'general', '751'),
('796', '796', 'cust_branch', 'general', '752'),
('797', '797', 'supplier', 'general', '48'),
('798', '798', 'cust_branch', 'general', '753'),
('799', '799', 'cust_branch', 'general', '754'),
('800', '800', 'cust_branch', 'general', '755'),
('802', '802', 'cust_branch', 'general', '757'),
('803', '803', 'cust_branch', 'general', '758'),
('804', '804', 'cust_branch', 'general', '759'),
('805', '805', 'cust_branch', 'general', '760'),
('806', '521', 'cust_branch', 'general', '483'),
('807', '806', 'cust_branch', 'general', '761'),
('808', '807', 'cust_branch', 'general', '762'),
('809', '808', 'cust_branch', 'general', '763'),
('810', '809', 'cust_branch', 'general', '764'),
('811', '810', 'cust_branch', 'general', '765'),
('812', '811', 'cust_branch', 'general', '766'),
('813', '812', 'cust_branch', 'general', '767'),
('814', '813', 'cust_branch', 'general', '768'),
('815', '814', 'cust_branch', 'general', '769'),
('816', '815', 'cust_branch', 'general', '770'),
('817', '816', 'cust_branch', 'general', '771'),
('818', '817', 'cust_branch', 'general', '772'),
('819', '818', 'cust_branch', 'general', '773'),
('820', '819', 'cust_branch', 'general', '774'),
('821', '820', 'cust_branch', 'general', '775'),
('822', '821', 'cust_branch', 'general', '776'),
('823', '822', 'cust_branch', 'general', '777'),
('824', '823', 'cust_branch', 'general', '778'),
('825', '824', 'cust_branch', 'general', '779'),
('826', '825', 'cust_branch', 'general', '780'),
('827', '826', 'cust_branch', 'general', '781'),
('828', '827', 'cust_branch', 'general', '782'),
('829', '828', 'cust_branch', 'general', '783'),
('830', '829', 'cust_branch', 'general', '784'),
('831', '830', 'cust_branch', 'general', '785'),
('832', '831', 'cust_branch', 'general', '786'),
('833', '832', 'cust_branch', 'general', '787'),
('834', '833', 'cust_branch', 'general', '788'),
('836', '835', 'cust_branch', 'general', '790'),
('837', '836', 'supplier', 'general', '49'),
('838', '837', 'cust_branch', 'general', '791'),
('839', '838', 'cust_branch', 'general', '792'),
('840', '839', 'cust_branch', 'general', '793'),
('841', '840', 'cust_branch', 'general', '794'),
('842', '841', 'cust_branch', 'general', '795'),
('843', '842', 'cust_branch', 'general', '796'),
('844', '843', 'cust_branch', 'general', '797'),
('845', '844', 'cust_branch', 'general', '798'),
('846', '845', 'cust_branch', 'general', '799'),
('847', '846', 'cust_branch', 'general', '800'),
('849', '848', 'cust_branch', 'general', '802'),
('850', '849', 'cust_branch', 'general', '803'),
('851', '850', 'cust_branch', 'general', '804'),
('852', '851', 'cust_branch', 'general', '805'),
('853', '852', 'cust_branch', 'general', '806'),
('854', '853', 'cust_branch', 'general', '807'),
('855', '854', 'cust_branch', 'general', '808'),
('856', '855', 'cust_branch', 'general', '809'),
('857', '856', 'cust_branch', 'general', '810'),
('858', '857', 'cust_branch', 'general', '811'),
('859', '858', 'cust_branch', 'general', '812'),
('860', '859', 'cust_branch', 'general', '813'),
('861', '860', 'cust_branch', 'general', '814'),
('862', '861', 'cust_branch', 'general', '815'),
('863', '862', 'cust_branch', 'general', '816'),
('864', '862', 'customer', 'general', '794'),
('865', '863', 'cust_branch', 'general', '817'),
('866', '863', 'customer', 'general', '795'),
('867', '864', 'cust_branch', 'general', '818'),
('868', '864', 'customer', 'general', '796'),
('869', '865', 'cust_branch', 'general', '819'),
('870', '865', 'customer', 'general', '797'),
('871', '866', 'cust_branch', 'general', '820'),
('872', '866', 'customer', 'general', '798'),
('873', '867', 'cust_branch', 'general', '821'),
('874', '867', 'customer', 'general', '799'),
('875', '868', 'cust_branch', 'general', '822'),
('876', '868', 'customer', 'general', '800'),
('877', '869', 'cust_branch', 'general', '823'),
('878', '869', 'customer', 'general', '801'),
('879', '870', 'cust_branch', 'general', '824'),
('880', '870', 'customer', 'general', '802'),
('881', '871', 'cust_branch', 'general', '825'),
('882', '871', 'customer', 'general', '803'),
('883', '872', 'cust_branch', 'general', '826'),
('884', '872', 'customer', 'general', '804'),
('885', '873', 'cust_branch', 'general', '827'),
('886', '873', 'customer', 'general', '805'),
('887', '874', 'cust_branch', 'general', '828'),
('888', '874', 'customer', 'general', '806'),
('889', '875', 'cust_branch', 'general', '829'),
('890', '875', 'customer', 'general', '807'),
('891', '876', 'cust_branch', 'general', '830'),
('892', '876', 'customer', 'general', '808'),
('893', '877', 'cust_branch', 'general', '831'),
('894', '877', 'customer', 'general', '809'),
('895', '878', 'cust_branch', 'general', '832'),
('896', '878', 'customer', 'general', '810'),
('897', '879', 'cust_branch', 'general', '833'),
('898', '879', 'customer', 'general', '811'),
('899', '880', 'cust_branch', 'general', '834'),
('900', '880', 'customer', 'general', '812'),
('901', '881', 'cust_branch', 'general', '835'),
('902', '881', 'customer', 'general', '813'),
('903', '882', 'cust_branch', 'general', '836'),
('904', '882', 'customer', 'general', '814'),
('906', '883', 'customer', 'general', '815'),
('907', '884', 'cust_branch', 'general', '838'),
('908', '884', 'customer', 'general', '816'),
('909', '885', 'cust_branch', 'general', '839'),
('910', '885', 'customer', 'general', '817'),
('911', '886', 'cust_branch', 'general', '840'),
('912', '886', 'customer', 'general', '818'),
('913', '887', 'cust_branch', 'general', '841'),
('914', '887', 'customer', 'general', '819'),
('915', '888', 'cust_branch', 'general', '842'),
('916', '888', 'customer', 'general', '820'),
('917', '889', 'cust_branch', 'general', '843'),
('918', '889', 'customer', 'general', '821'),
('919', '890', 'cust_branch', 'general', '844'),
('920', '890', 'customer', 'general', '822'),
('921', '891', 'cust_branch', 'general', '845'),
('922', '891', 'customer', 'general', '823'),
('923', '892', 'cust_branch', 'general', '846'),
('924', '892', 'customer', 'general', '824'),
('925', '893', 'cust_branch', 'general', '847'),
('926', '893', 'customer', 'general', '825'),
('927', '894', 'cust_branch', 'general', '848'),
('928', '894', 'customer', 'general', '826'),
('929', '895', 'cust_branch', 'general', '849'),
('930', '895', 'customer', 'general', '827'),
('931', '896', 'cust_branch', 'general', '850'),
('932', '896', 'customer', 'general', '828'),
('933', '897', 'cust_branch', 'general', '851'),
('934', '897', 'customer', 'general', '829'),
('935', '898', 'cust_branch', 'general', '852'),
('936', '898', 'customer', 'general', '830'),
('937', '899', 'cust_branch', 'general', '853'),
('938', '899', 'customer', 'general', '831'),
('939', '900', 'cust_branch', 'general', '854'),
('940', '900', 'customer', 'general', '832'),
('941', '901', 'cust_branch', 'general', '855'),
('942', '901', 'customer', 'general', '833'),
('943', '902', 'cust_branch', 'general', '856'),
('944', '902', 'customer', 'general', '834'),
('945', '903', 'cust_branch', 'general', '857'),
('946', '903', 'customer', 'general', '835'),
('947', '904', 'cust_branch', 'general', '858'),
('948', '904', 'customer', 'general', '836'),
('949', '905', 'cust_branch', 'general', '859'),
('950', '905', 'customer', 'general', '837'),
('951', '906', 'supplier', 'general', '50'),
('952', '907', 'cust_branch', 'general', '860'),
('953', '907', 'customer', 'general', '838'),
('954', '908', 'cust_branch', 'general', '861'),
('955', '908', 'customer', 'general', '839'),
('956', '909', 'cust_branch', 'general', '862'),
('957', '909', 'customer', 'general', '840'),
('958', '910', 'cust_branch', 'general', '863'),
('959', '910', 'customer', 'general', '841'),
('960', '911', 'cust_branch', 'general', '864'),
('961', '911', 'customer', 'general', '842'),
('962', '912', 'cust_branch', 'general', '865'),
('963', '912', 'customer', 'general', '843'),
('964', '913', 'cust_branch', 'general', '866'),
('965', '913', 'customer', 'general', '844'),
('966', '914', 'cust_branch', 'general', '867'),
('967', '914', 'customer', 'general', '845'),
('968', '915', 'cust_branch', 'general', '868'),
('969', '915', 'customer', 'general', '846'),
('970', '916', 'cust_branch', 'general', '869'),
('971', '916', 'customer', 'general', '848'),
('972', '917', 'cust_branch', 'general', '870'),
('973', '917', 'customer', 'general', '849'),
('974', '918', 'cust_branch', 'general', '871'),
('975', '918', 'customer', 'general', '850'),
('976', '919', 'cust_branch', 'general', '872'),
('977', '919', 'customer', 'general', '851'),
('978', '920', 'cust_branch', 'general', '873'),
('979', '920', 'customer', 'general', '852'),
('980', '921', 'supplier', 'general', '51'),
('981', '922', 'supplier', 'general', '52'),
('982', '923', 'cust_branch', 'general', '874'),
('983', '923', 'customer', 'general', '853'),
('984', '924', 'cust_branch', 'general', '875'),
('985', '924', 'customer', 'general', '854'),
('986', '925', 'cust_branch', 'general', '876'),
('987', '925', 'customer', 'general', '855'),
('988', '926', 'cust_branch', 'general', '877'),
('989', '926', 'customer', 'general', '856'),
('990', '927', 'cust_branch', 'general', '878'),
('991', '927', 'customer', 'general', '857'),
('992', '928', 'cust_branch', 'general', '879'),
('993', '928', 'customer', 'general', '858'),
('994', '929', 'cust_branch', 'general', '880'),
('995', '929', 'customer', 'general', '859'),
('996', '930', 'cust_branch', 'general', '881'),
('997', '930', 'customer', 'general', '860'),
('998', '931', 'cust_branch', 'general', '882'),
('999', '931', 'customer', 'general', '861'),
('1000', '932', 'cust_branch', 'general', '883'),
('1001', '932', 'customer', 'general', '862'),
('1002', '933', 'cust_branch', 'general', '884'),
('1003', '933', 'customer', 'general', '863'),
('1004', '934', 'cust_branch', 'general', '885'),
('1005', '934', 'customer', 'general', '864'),
('1006', '935', 'cust_branch', 'general', '886'),
('1007', '935', 'customer', 'general', '865'),
('1008', '936', 'cust_branch', 'general', '887'),
('1009', '936', 'customer', 'general', '867'),
('1010', '937', 'cust_branch', 'general', '888'),
('1011', '937', 'customer', 'general', '869'),
('1012', '938', 'cust_branch', 'general', '889'),
('1013', '938', 'customer', 'general', '870'),
('1017', '939', 'customer', 'general', '871'),
('1018', '939', 'cust_branch', 'general', '890'),
('1019', '940', 'cust_branch', 'general', '891'),
('1020', '940', 'customer', 'general', '872'),
('1021', '941', 'cust_branch', 'general', '892'),
('1022', '941', 'customer', 'general', '873'),
('1023', '942', 'cust_branch', 'general', '893'),
('1024', '942', 'customer', 'general', '874'),
('1025', '943', 'cust_branch', 'general', '894'),
('1026', '943', 'customer', 'general', '875'),
('1027', '944', 'cust_branch', 'general', '895'),
('1028', '944', 'customer', 'general', '876'),
('1029', '945', 'cust_branch', 'general', '896'),
('1030', '945', 'customer', 'general', '877'),
('1031', '946', 'cust_branch', 'general', '897'),
('1032', '946', 'customer', 'general', '878'),
('1033', '947', 'cust_branch', 'general', '898'),
('1034', '947', 'customer', 'general', '879'),
('1035', '948', 'cust_branch', 'general', '899'),
('1036', '948', 'customer', 'general', '880'),
('1037', '949', 'cust_branch', 'general', '900'),
('1038', '949', 'customer', 'general', '881'),
('1039', '950', 'cust_branch', 'general', '901'),
('1040', '950', 'customer', 'general', '882'),
('1041', '951', 'cust_branch', 'general', '902'),
('1042', '951', 'customer', 'general', '883'),
('1043', '952', 'cust_branch', 'general', '903'),
('1044', '952', 'customer', 'general', '884'),
('1045', '953', 'cust_branch', 'general', '904'),
('1046', '953', 'customer', 'general', '885'),
('1047', '954', 'cust_branch', 'general', '905'),
('1048', '954', 'customer', 'general', '886'),
('1049', '955', 'cust_branch', 'general', '906'),
('1050', '955', 'customer', 'general', '887'),
('1052', '956', 'customer', 'general', '888'),
('1053', '956', 'cust_branch', 'general', '907'),
('1054', '957', 'cust_branch', 'general', '908'),
('1055', '957', 'customer', 'general', '889'),
('1056', '958', 'cust_branch', 'general', '909'),
('1057', '958', 'customer', 'general', '890'),
('1058', '959', 'cust_branch', 'general', '910'),
('1059', '959', 'customer', 'general', '891'),
('1060', '960', 'cust_branch', 'general', '911'),
('1061', '960', 'customer', 'general', '892'),
('1062', '961', 'cust_branch', 'general', '912'),
('1063', '961', 'customer', 'general', '893'),
('1064', '962', 'cust_branch', 'general', '913'),
('1065', '962', 'customer', 'general', '894'),
('1066', '963', 'cust_branch', 'general', '914'),
('1068', '964', 'cust_branch', 'general', '915'),
('1069', '964', 'customer', 'general', '897'),
('1070', '965', 'cust_branch', 'general', '916'),
('1071', '965', 'customer', 'general', '898'),
('1072', '966', 'cust_branch', 'general', '917'),
('1073', '966', 'customer', 'general', '899'),
('1074', '967', 'cust_branch', 'general', '918'),
('1075', '967', 'customer', 'general', '900'),
('1076', '968', 'supplier', 'general', '53'),
('1079', '969', 'customer', 'general', '901'),
('1080', '970', 'cust_branch', 'general', '920'),
('1081', '970', 'customer', 'general', '902'),
('1082', '971', 'cust_branch', 'general', '921'),
('1083', '971', 'customer', 'general', '903'),
('1084', '972', 'cust_branch', 'general', '922'),
('1085', '972', 'customer', 'general', '904'),
('1086', '973', 'cust_branch', 'general', '923'),
('1087', '973', 'customer', 'general', '905'),
('1089', '969', 'cust_branch', 'general', '919'),
('1090', '974', 'cust_branch', 'general', '924'),
('1091', '974', 'customer', 'general', '906'),
('1092', '975', 'supplier', 'general', '54'),
('1093', '976', 'cust_branch', 'general', '925'),
('1094', '976', 'customer', 'general', '907'),
('1095', '977', 'cust_branch', 'general', '926'),
('1096', '977', 'customer', 'general', '908'),
('1097', '978', 'cust_branch', 'general', '927'),
('1098', '978', 'customer', 'general', '909'),
('1099', '979', 'cust_branch', 'general', '928'),
('1100', '979', 'customer', 'general', '910'),
('1101', '980', 'cust_branch', 'general', '929'),
('1102', '980', 'customer', 'general', '911'),
('1103', '981', 'cust_branch', 'general', '930'),
('1104', '981', 'customer', 'general', '912'),
('1105', '982', 'cust_branch', 'general', '931'),
('1106', '982', 'customer', 'general', '913'),
('1107', '983', 'cust_branch', 'general', '932'),
('1108', '983', 'customer', 'general', '914'),
('1111', '985', 'cust_branch', 'general', '934'),
('1112', '985', 'customer', 'general', '916'),
('1113', '986', 'cust_branch', 'general', '935'),
('1114', '986', 'customer', 'general', '917'),
('1115', '987', 'cust_branch', 'general', '936'),
('1116', '987', 'customer', 'general', '920'),
('1117', '988', 'cust_branch', 'general', '937'),
('1118', '988', 'customer', 'general', '921'),
('1119', '989', 'cust_branch', 'general', '938'),
('1120', '989', 'customer', 'general', '922'),
('1121', '990', 'cust_branch', 'general', '939'),
('1122', '990', 'customer', 'general', '923'),
('1123', '991', 'cust_branch', 'general', '940'),
('1124', '991', 'customer', 'general', '924'),
('1125', '992', 'cust_branch', 'general', '941'),
('1126', '992', 'customer', 'general', '925'),
('1127', '993', 'cust_branch', 'general', '942'),
('1128', '993', 'customer', 'general', '926'),
('1129', '994', 'cust_branch', 'general', '943'),
('1130', '994', 'customer', 'general', '927'),
('1131', '995', 'cust_branch', 'general', '944'),
('1132', '995', 'customer', 'general', '928'),
('1133', '996', 'cust_branch', 'general', '945'),
('1134', '996', 'customer', 'general', '929'),
('1135', '997', 'cust_branch', 'general', '946'),
('1136', '997', 'customer', 'general', '930'),
('1137', '998', 'cust_branch', 'general', '947');
INSERT INTO `0_crm_contacts` VALUES
('1138', '998', 'customer', 'general', '931'),
('1139', '999', 'supplier', 'general', '55'),
('1140', '596', 'cust_branch', 'general', '558'),
('1141', '1000', 'cust_branch', 'general', '948'),
('1142', '1000', 'customer', 'general', '932'),
('1143', '1001', 'cust_branch', 'general', '949'),
('1144', '1001', 'customer', 'general', '933'),
('1145', '1002', 'cust_branch', 'general', '950'),
('1146', '1002', 'customer', 'general', '934'),
('1147', '1003', 'cust_branch', 'general', '951'),
('1148', '1003', 'customer', 'general', '935'),
('1149', '1004', 'cust_branch', 'general', '952'),
('1150', '1004', 'customer', 'general', '936'),
('1151', '1005', 'cust_branch', 'general', '953'),
('1152', '1005', 'customer', 'general', '937'),
('1153', '1006', 'cust_branch', 'general', '954'),
('1154', '1006', 'customer', 'general', '938'),
('1155', '1007', 'cust_branch', 'general', '955'),
('1156', '1007', 'customer', 'general', '939'),
('1157', '1008', 'cust_branch', 'general', '956'),
('1158', '1008', 'customer', 'general', '940'),
('1159', '1009', 'cust_branch', 'general', '957'),
('1160', '1009', 'customer', 'general', '941'),
('1161', '1010', 'cust_branch', 'general', '958'),
('1162', '1010', 'customer', 'general', '942'),
('1163', '1011', 'cust_branch', 'general', '959'),
('1164', '1011', 'customer', 'general', '943'),
('1165', '1012', 'cust_branch', 'general', '960'),
('1166', '1012', 'customer', 'general', '944'),
('1167', '1013', 'cust_branch', 'general', '961'),
('1168', '1013', 'customer', 'general', '945'),
('1172', '1016', 'cust_branch', 'general', '964'),
('1173', '1016', 'customer', 'general', '947'),
('1174', '1017', 'cust_branch', 'general', '965'),
('1175', '1017', 'customer', 'general', '948'),
('1176', '1018', 'cust_branch', 'general', '966'),
('1177', '1018', 'customer', 'general', '949'),
('1178', '1019', 'cust_branch', 'general', '967'),
('1179', '1019', 'customer', 'general', '950'),
('1180', '1020', 'cust_branch', 'general', '968'),
('1181', '1020', 'customer', 'general', '951'),
('1182', '1021', 'cust_branch', 'general', '969'),
('1183', '1021', 'customer', 'general', '952'),
('1184', '1022', 'cust_branch', 'general', '970'),
('1185', '1022', 'customer', 'general', '954'),
('1186', '1023', 'cust_branch', 'general', '971'),
('1187', '1023', 'customer', 'general', '955'),
('1188', '1024', 'cust_branch', 'general', '972'),
('1189', '1024', 'customer', 'general', '956'),
('1190', '1025', 'cust_branch', 'general', '973'),
('1191', '1025', 'customer', 'general', '957'),
('1192', '1026', 'cust_branch', 'general', '974'),
('1193', '1026', 'customer', 'general', '958'),
('1194', '1027', 'cust_branch', 'general', '975'),
('1195', '1027', 'customer', 'general', '959'),
('1196', '1028', 'cust_branch', 'general', '976'),
('1197', '1028', 'customer', 'general', '960'),
('1198', '1029', 'cust_branch', 'general', '977'),
('1199', '1029', 'customer', 'general', '961'),
('1200', '1030', 'cust_branch', 'general', '978'),
('1201', '1030', 'customer', 'general', '962'),
('1202', '1031', 'cust_branch', 'general', '979'),
('1203', '1031', 'customer', 'general', '963'),
('1204', '1032', 'cust_branch', 'general', '980'),
('1205', '1032', 'customer', 'general', '964'),
('1206', '1033', 'cust_branch', 'general', '981'),
('1207', '1033', 'customer', 'general', '965'),
('1208', '1034', 'cust_branch', 'general', '982'),
('1209', '1034', 'customer', 'general', '966'),
('1210', '1035', 'cust_branch', 'general', '983'),
('1211', '1035', 'customer', 'general', '967'),
('1212', '1036', 'cust_branch', 'general', '984'),
('1213', '1036', 'customer', 'general', '968'),
('1214', '1037', 'cust_branch', 'general', '985'),
('1215', '1037', 'customer', 'general', '969'),
('1216', '1038', 'cust_branch', 'general', '986'),
('1217', '1038', 'customer', 'general', '970'),
('1218', '1039', 'cust_branch', 'general', '987'),
('1219', '1039', 'customer', 'general', '971'),
('1220', '1040', 'cust_branch', 'general', '988'),
('1221', '1040', 'customer', 'general', '972'),
('1222', '1041', 'cust_branch', 'general', '989'),
('1223', '1041', 'customer', 'general', '973'),
('1224', '1042', 'cust_branch', 'general', '990'),
('1225', '1042', 'customer', 'general', '974'),
('1226', '1043', 'cust_branch', 'general', '991'),
('1227', '1043', 'customer', 'general', '975'),
('1228', '801', 'cust_branch', 'general', '756'),
('1229', '1044', 'cust_branch', 'general', '992'),
('1230', '1044', 'customer', 'general', '976'),
('1231', '1045', 'cust_branch', 'general', '993'),
('1232', '1045', 'customer', 'general', '977'),
('1233', '1046', 'cust_branch', 'general', '994'),
('1234', '1046', 'customer', 'general', '978'),
('1235', '1047', 'cust_branch', 'general', '995'),
('1236', '1047', 'customer', 'general', '979'),
('1237', '1048', 'cust_branch', 'general', '996'),
('1238', '1048', 'customer', 'general', '980'),
('1239', '1049', 'cust_branch', 'general', '997'),
('1240', '1049', 'customer', 'general', '981'),
('1241', '1050', 'supplier', 'general', '56'),
('1242', '1051', 'cust_branch', 'general', '998'),
('1243', '1051', 'customer', 'general', '982'),
('1244', '1052', 'cust_branch', 'general', '999'),
('1245', '1052', 'customer', 'general', '983'),
('1246', '1053', 'cust_branch', 'general', '1000'),
('1247', '1053', 'customer', 'general', '984'),
('1248', '1054', 'cust_branch', 'general', '1001'),
('1249', '1054', 'customer', 'general', '985'),
('1250', '1055', 'cust_branch', 'general', '1002'),
('1251', '1055', 'customer', 'general', '986'),
('1252', '1056', 'cust_branch', 'general', '1003'),
('1253', '1056', 'customer', 'general', '987'),
('1254', '1057', 'cust_branch', 'general', '1004'),
('1255', '1057', 'customer', 'general', '988'),
('1256', '1058', 'cust_branch', 'general', '1005'),
('1257', '1058', 'customer', 'general', '989'),
('1258', '1059', 'cust_branch', 'general', '1006'),
('1259', '1059', 'customer', 'general', '990'),
('1260', '1060', 'cust_branch', 'general', '1007'),
('1261', '1060', 'customer', 'general', '991'),
('1262', '1061', 'cust_branch', 'general', '1008'),
('1263', '1061', 'customer', 'general', '992'),
('1264', '1062', 'cust_branch', 'general', '1009'),
('1265', '1062', 'customer', 'general', '993'),
('1266', '1063', 'cust_branch', 'general', '1010'),
('1267', '1063', 'customer', 'general', '994'),
('1268', '1064', 'cust_branch', 'general', '1011'),
('1269', '1064', 'customer', 'general', '995'),
('1270', '1065', 'cust_branch', 'general', '1012'),
('1271', '1065', 'customer', 'general', '996'),
('1272', '1066', 'cust_branch', 'general', '1013'),
('1273', '1066', 'customer', 'general', '997'),
('1274', '1067', 'cust_branch', 'general', '1014'),
('1275', '1067', 'customer', 'general', '998'),
('1276', '1068', 'cust_branch', 'general', '1015'),
('1277', '1068', 'customer', 'general', '999'),
('1278', '1069', 'cust_branch', 'general', '1016'),
('1279', '1069', 'customer', 'general', '1000'),
('1280', '1070', 'cust_branch', 'general', '1017'),
('1281', '1070', 'customer', 'general', '1001'),
('1282', '1071', 'cust_branch', 'general', '1018'),
('1283', '1071', 'customer', 'general', '1002'),
('1284', '1072', 'cust_branch', 'general', '1019'),
('1285', '1072', 'customer', 'general', '1003'),
('1286', '1073', 'cust_branch', 'general', '1020'),
('1287', '1073', 'customer', 'general', '1004'),
('1288', '1074', 'supplier', 'general', '57'),
('1289', '1075', 'cust_branch', 'general', '1021'),
('1290', '1075', 'customer', 'general', '1005'),
('1291', '1076', 'cust_branch', 'general', '1022'),
('1292', '1076', 'customer', 'general', '1006'),
('1293', '1077', 'cust_branch', 'general', '1023'),
('1294', '1077', 'customer', 'general', '1007'),
('1295', '1078', 'cust_branch', 'general', '1024'),
('1296', '1078', 'customer', 'general', '1008'),
('1297', '1079', 'cust_branch', 'general', '1025'),
('1298', '1079', 'customer', 'general', '1009'),
('1299', '1080', 'cust_branch', 'general', '1026'),
('1300', '1080', 'customer', 'general', '1010'),
('1301', '1081', 'cust_branch', 'general', '1027'),
('1302', '1081', 'customer', 'general', '1011'),
('1303', '1082', 'cust_branch', 'general', '1028'),
('1304', '1082', 'customer', 'general', '1012'),
('1305', '1083', 'cust_branch', 'general', '1029'),
('1306', '1083', 'customer', 'general', '1013'),
('1307', '1084', 'cust_branch', 'general', '1030'),
('1308', '1084', 'customer', 'general', '1014'),
('1309', '1085', 'cust_branch', 'general', '1031'),
('1310', '1085', 'customer', 'general', '1015'),
('1311', '1086', 'cust_branch', 'general', '1032'),
('1312', '1086', 'customer', 'general', '1016'),
('1313', '1087', 'cust_branch', 'general', '1033'),
('1314', '1087', 'customer', 'general', '1017'),
('1315', '1088', 'cust_branch', 'general', '1034'),
('1316', '1088', 'customer', 'general', '1018'),
('1317', '1089', 'cust_branch', 'general', '1035'),
('1318', '1089', 'customer', 'general', '1019'),
('1319', '1090', 'supplier', 'general', '58'),
('1320', '1091', 'cust_branch', 'general', '1036'),
('1321', '1091', 'customer', 'general', '1020'),
('1322', '1092', 'cust_branch', 'general', '1037'),
('1323', '1092', 'customer', 'general', '1021'),
('1324', '1093', 'cust_branch', 'general', '1038'),
('1325', '1093', 'customer', 'general', '1022'),
('1326', '1094', 'cust_branch', 'general', '1039'),
('1327', '1094', 'customer', 'general', '1023'),
('1328', '1095', 'cust_branch', 'general', '1040'),
('1329', '1095', 'customer', 'general', '1024'),
('1330', '1096', 'cust_branch', 'general', '1041'),
('1331', '1096', 'customer', 'general', '1025'),
('1332', '1097', 'cust_branch', 'general', '1042'),
('1333', '1097', 'customer', 'general', '1026'),
('1334', '1098', 'cust_branch', 'general', '1043'),
('1335', '1098', 'customer', 'general', '1027'),
('1336', '1099', 'cust_branch', 'general', '1044'),
('1337', '1099', 'customer', 'general', '1028'),
('1338', '1100', 'cust_branch', 'general', '1045'),
('1339', '1100', 'customer', 'general', '1029'),
('1340', '1101', 'cust_branch', 'general', '1046'),
('1341', '1101', 'customer', 'general', '1031'),
('1342', '1102', 'cust_branch', 'general', '1047'),
('1343', '1102', 'customer', 'general', '1032'),
('1344', '1103', 'cust_branch', 'general', '1048'),
('1345', '1103', 'customer', 'general', '1033'),
('1346', '1104', 'cust_branch', 'general', '1049'),
('1347', '1104', 'customer', 'general', '1034'),
('1348', '1105', 'cust_branch', 'general', '1050'),
('1349', '1105', 'customer', 'general', '1035'),
('1350', '1106', 'cust_branch', 'general', '1051'),
('1351', '1106', 'customer', 'general', '1036'),
('1352', '1107', 'cust_branch', 'general', '1052'),
('1353', '1107', 'customer', 'general', '1037'),
('1354', '1108', 'cust_branch', 'general', '1053'),
('1355', '1108', 'customer', 'general', '1038'),
('1356', '1109', 'cust_branch', 'general', '1054'),
('1357', '1109', 'customer', 'general', '1039'),
('1358', '1110', 'cust_branch', 'general', '1055'),
('1359', '1110', 'customer', 'general', '1040'),
('1360', '1111', 'cust_branch', 'general', '1056'),
('1361', '1111', 'customer', 'general', '1041'),
('1362', '1112', 'cust_branch', 'general', '1057'),
('1363', '1112', 'customer', 'general', '1042'),
('1364', '1113', 'cust_branch', 'general', '1058'),
('1365', '1113', 'customer', 'general', '1043'),
('1366', '1114', 'cust_branch', 'general', '1059'),
('1367', '1114', 'customer', 'general', '1044'),
('1368', '1115', 'cust_branch', 'general', '1060'),
('1369', '1115', 'customer', 'general', '1045'),
('1370', '1116', 'cust_branch', 'general', '1061'),
('1371', '1116', 'customer', 'general', '1046'),
('1372', '1117', 'cust_branch', 'general', '1062'),
('1373', '1117', 'customer', 'general', '1047'),
('1374', '1118', 'cust_branch', 'general', '1063'),
('1375', '1118', 'customer', 'general', '1048'),
('1376', '1119', 'cust_branch', 'general', '1064'),
('1377', '1119', 'customer', 'general', '1049'),
('1378', '1120', 'cust_branch', 'general', '1065'),
('1379', '1120', 'customer', 'general', '1050'),
('1380', '1121', 'cust_branch', 'general', '1066'),
('1381', '1121', 'customer', 'general', '1051'),
('1382', '1122', 'cust_branch', 'general', '1067'),
('1383', '1122', 'customer', 'general', '1052'),
('1384', '1123', 'cust_branch', 'general', '1068'),
('1385', '1123', 'customer', 'general', '1053'),
('1386', '1124', 'cust_branch', 'general', '1069'),
('1387', '1124', 'customer', 'general', '1054'),
('1388', '1125', 'cust_branch', 'general', '1070'),
('1389', '1125', 'customer', 'general', '1055'),
('1390', '1126', 'cust_branch', 'general', '1071'),
('1391', '1126', 'customer', 'general', '1056'),
('1392', '1127', 'cust_branch', 'general', '1072'),
('1393', '1127', 'customer', 'general', '1057'),
('1394', '1128', 'cust_branch', 'general', '1073'),
('1395', '1128', 'customer', 'general', '1058'),
('1396', '1129', 'cust_branch', 'general', '1074'),
('1397', '1129', 'customer', 'general', '1059'),
('1398', '1130', 'cust_branch', 'general', '1075'),
('1399', '1130', 'customer', 'general', '1060'),
('1400', '1131', 'cust_branch', 'general', '1076'),
('1401', '1131', 'customer', 'general', '1061'),
('1402', '1132', 'cust_branch', 'general', '1077'),
('1403', '1132', 'customer', 'general', '1062'),
('1404', '1133', 'cust_branch', 'general', '1078'),
('1405', '1133', 'customer', 'general', '1063'),
('1406', '1134', 'cust_branch', 'general', '1079'),
('1407', '1134', 'customer', 'general', '1064'),
('1408', '1135', 'cust_branch', 'general', '1080'),
('1409', '1135', 'customer', 'general', '1065'),
('1410', '1136', 'cust_branch', 'general', '1081'),
('1411', '1136', 'customer', 'general', '1066'),
('1412', '1137', 'cust_branch', 'general', '1082'),
('1413', '1137', 'customer', 'general', '1067'),
('1414', '1138', 'cust_branch', 'general', '1083'),
('1415', '1138', 'customer', 'general', '1068'),
('1416', '1139', 'cust_branch', 'general', '1084'),
('1417', '1139', 'customer', 'general', '1069'),
('1418', '1140', 'cust_branch', 'general', '1085'),
('1419', '1140', 'customer', 'general', '1070'),
('1420', '1141', 'cust_branch', 'general', '1086'),
('1421', '1141', 'customer', 'general', '1071'),
('1422', '1142', 'cust_branch', 'general', '1087'),
('1423', '1142', 'customer', 'general', '1072'),
('1424', '1143', 'cust_branch', 'general', '1088'),
('1425', '1143', 'customer', 'general', '1073'),
('1426', '1144', 'cust_branch', 'general', '1089'),
('1427', '1144', 'customer', 'general', '1074'),
('1428', '1145', 'cust_branch', 'general', '1090'),
('1429', '1145', 'customer', 'general', '1075'),
('1430', '1146', 'cust_branch', 'general', '1091'),
('1431', '1146', 'customer', 'general', '1076'),
('1432', '1147', 'cust_branch', 'general', '1092'),
('1433', '1147', 'customer', 'general', '1077'),
('1434', '1148', 'cust_branch', 'general', '1093'),
('1435', '1148', 'customer', 'general', '1078'),
('1436', '1149', 'cust_branch', 'general', '1094'),
('1437', '1149', 'customer', 'general', '1079'),
('1438', '1150', 'cust_branch', 'general', '1095'),
('1439', '1150', 'customer', 'general', '1080'),
('1440', '1151', 'supplier', 'general', '59'),
('1441', '1152', 'cust_branch', 'general', '1096'),
('1442', '1152', 'customer', 'general', '1081'),
('1443', '1153', 'cust_branch', 'general', '1097'),
('1444', '1153', 'customer', 'general', '1082'),
('1445', '1154', 'cust_branch', 'general', '1098'),
('1446', '1154', 'customer', 'general', '1083'),
('1447', '1155', 'cust_branch', 'general', '1099'),
('1448', '1155', 'customer', 'general', '1084'),
('1449', '1156', 'cust_branch', 'general', '1100'),
('1450', '1156', 'customer', 'general', '1085'),
('1451', '1157', 'cust_branch', 'general', '1101'),
('1452', '1157', 'customer', 'general', '1086'),
('1453', '1158', 'cust_branch', 'general', '1102'),
('1454', '1158', 'customer', 'general', '1087'),
('1455', '1159', 'cust_branch', 'general', '1103'),
('1456', '1159', 'customer', 'general', '1088'),
('1457', '1160', 'cust_branch', 'general', '1104'),
('1458', '1160', 'customer', 'general', '1089'),
('1459', '1161', 'cust_branch', 'general', '1105'),
('1460', '1161', 'customer', 'general', '1090'),
('1461', '1162', 'cust_branch', 'general', '1106'),
('1462', '1162', 'customer', 'general', '1091'),
('1463', '1163', 'cust_branch', 'general', '1107'),
('1464', '1163', 'customer', 'general', '1092'),
('1465', '1164', 'cust_branch', 'general', '1108'),
('1466', '1164', 'customer', 'general', '1093'),
('1467', '1165', 'cust_branch', 'general', '1109'),
('1468', '1165', 'customer', 'general', '1094'),
('1469', '1166', 'cust_branch', 'general', '1110'),
('1470', '1166', 'customer', 'general', '1095'),
('1471', '1167', 'cust_branch', 'general', '1111'),
('1472', '1167', 'customer', 'general', '1096'),
('1473', '1168', 'cust_branch', 'general', '1112'),
('1474', '1168', 'customer', 'general', '1097'),
('1475', '1169', 'cust_branch', 'general', '1113'),
('1476', '1169', 'customer', 'general', '1098'),
('1477', '1170', 'cust_branch', 'general', '1114'),
('1478', '1170', 'customer', 'general', '1099'),
('1479', '1171', 'cust_branch', 'general', '1115'),
('1480', '1171', 'customer', 'general', '1100'),
('1481', '1172', 'cust_branch', 'general', '1116'),
('1482', '1172', 'customer', 'general', '1101'),
('1483', '1173', 'cust_branch', 'general', '1117'),
('1484', '1173', 'customer', 'general', '1102'),
('1485', '1174', 'cust_branch', 'general', '1118'),
('1486', '1174', 'customer', 'general', '1103'),
('1487', '1175', 'cust_branch', 'general', '1119'),
('1488', '1175', 'customer', 'general', '1104'),
('1489', '1176', 'cust_branch', 'general', '1120'),
('1490', '1176', 'customer', 'general', '1105'),
('1491', '1177', 'cust_branch', 'general', '1121'),
('1492', '1177', 'customer', 'general', '1106'),
('1493', '1178', 'cust_branch', 'general', '1122'),
('1494', '1178', 'customer', 'general', '1107'),
('1495', '1179', 'cust_branch', 'general', '1123'),
('1496', '1179', 'customer', 'general', '1108'),
('1497', '1180', 'cust_branch', 'general', '1124'),
('1498', '1180', 'customer', 'general', '1109'),
('1499', '1181', 'cust_branch', 'general', '1125'),
('1500', '1181', 'customer', 'general', '1110'),
('1501', '1182', 'cust_branch', 'general', '1126'),
('1502', '1182', 'customer', 'general', '1111'),
('1503', '1183', 'cust_branch', 'general', '1127'),
('1504', '1183', 'customer', 'general', '1112'),
('1505', '1184', 'cust_branch', 'general', '1128'),
('1506', '1184', 'customer', 'general', '1113'),
('1507', '1185', 'cust_branch', 'general', '1129'),
('1508', '1185', 'customer', 'general', '1114'),
('1509', '1186', 'cust_branch', 'general', '1130'),
('1510', '1186', 'customer', 'general', '1115'),
('1511', '1187', 'cust_branch', 'general', '1131'),
('1512', '1187', 'customer', 'general', '1116'),
('1513', '1188', 'cust_branch', 'general', '1132'),
('1514', '1188', 'customer', 'general', '1117'),
('1515', '1189', 'cust_branch', 'general', '1133'),
('1516', '1189', 'customer', 'general', '1118'),
('1518', '1190', 'customer', 'general', '1119'),
('1519', '1191', 'cust_branch', 'general', '1135'),
('1520', '1192', 'supplier', 'general', '60'),
('1521', '1193', 'cust_branch', 'general', '1136'),
('1522', '1193', 'customer', 'general', '1120'),
('1523', '1194', 'cust_branch', 'general', '1137'),
('1524', '1194', 'customer', 'general', '1121'),
('1525', '1195', 'cust_branch', 'general', '1138'),
('1526', '1195', 'customer', 'general', '1122'),
('1527', '1196', 'cust_branch', 'general', '1139'),
('1528', '1196', 'customer', 'general', '1123'),
('1529', '1197', 'cust_branch', 'general', '1140'),
('1530', '1197', 'customer', 'general', '1124'),
('1531', '1198', 'cust_branch', 'general', '1141'),
('1532', '1198', 'customer', 'general', '1125'),
('1533', '1199', 'cust_branch', 'general', '1142'),
('1534', '1199', 'customer', 'general', '1126'),
('1535', '1200', 'cust_branch', 'general', '1143'),
('1536', '1200', 'customer', 'general', '1127'),
('1537', '1201', 'cust_branch', 'general', '1144'),
('1538', '1201', 'customer', 'general', '1128'),
('1539', '1202', 'cust_branch', 'general', '1145'),
('1540', '1202', 'customer', 'general', '1129'),
('1541', '1203', 'cust_branch', 'general', '1146'),
('1542', '1203', 'customer', 'general', '1130'),
('1543', '1204', 'cust_branch', 'general', '1147'),
('1544', '1204', 'customer', 'general', '1131'),
('1545', '1205', 'cust_branch', 'general', '1148'),
('1546', '1205', 'customer', 'general', '1132'),
('1547', '1206', 'cust_branch', 'general', '1149'),
('1548', '1206', 'customer', 'general', '1133'),
('1549', '1207', 'cust_branch', 'general', '1150'),
('1550', '1207', 'customer', 'general', '1134'),
('1551', '1208', 'cust_branch', 'general', '1151'),
('1552', '1208', 'customer', 'general', '1135'),
('1553', '1209', 'cust_branch', 'general', '1152'),
('1554', '1209', 'customer', 'general', '1136'),
('1555', '1210', 'cust_branch', 'general', '1153'),
('1556', '1210', 'customer', 'general', '1137'),
('1557', '1211', 'cust_branch', 'general', '1154'),
('1558', '1211', 'customer', 'general', '1138'),
('1559', '1212', 'cust_branch', 'general', '1155'),
('1560', '1212', 'customer', 'general', '1139'),
('1561', '1213', 'cust_branch', 'general', '1156'),
('1562', '1213', 'customer', 'general', '1140'),
('1563', '1214', 'cust_branch', 'general', '1157'),
('1564', '1214', 'customer', 'general', '1141'),
('1565', '1215', 'cust_branch', 'general', '1158'),
('1566', '1215', 'customer', 'general', '1142'),
('1567', '1216', 'cust_branch', 'general', '1159'),
('1568', '1216', 'customer', 'general', '1143'),
('1569', '1217', 'cust_branch', 'general', '1160'),
('1570', '1217', 'customer', 'general', '1144'),
('1571', '1218', 'cust_branch', 'general', '1161'),
('1572', '1218', 'customer', 'general', '1145'),
('1573', '1219', 'cust_branch', 'general', '1162'),
('1574', '1219', 'customer', 'general', '1146'),
('1575', '1220', 'cust_branch', 'general', '1163'),
('1576', '1220', 'customer', 'general', '1147'),
('1577', '1221', 'cust_branch', 'general', '1164'),
('1578', '1221', 'customer', 'general', '1148'),
('1579', '1222', 'cust_branch', 'general', '1165'),
('1580', '1222', 'customer', 'general', '1149'),
('1581', '1223', 'cust_branch', 'general', '1166'),
('1582', '1223', 'customer', 'general', '1150'),
('1583', '1224', 'cust_branch', 'general', '1167'),
('1584', '1224', 'customer', 'general', '1151'),
('1585', '1225', 'cust_branch', 'general', '1168'),
('1586', '1225', 'customer', 'general', '1152'),
('1587', '1226', 'cust_branch', 'general', '1169'),
('1588', '1226', 'customer', 'general', '1153'),
('1589', '1227', 'cust_branch', 'general', '1170'),
('1590', '1227', 'customer', 'general', '1154'),
('1591', '1228', 'cust_branch', 'general', '1171'),
('1592', '1228', 'customer', 'general', '1155'),
('1593', '1229', 'cust_branch', 'general', '1172'),
('1594', '1229', 'customer', 'general', '1156'),
('1595', '1230', 'cust_branch', 'general', '1173'),
('1596', '1230', 'customer', 'general', '1157'),
('1597', '1231', 'cust_branch', 'general', '1174'),
('1598', '1231', 'customer', 'general', '1158'),
('1599', '1232', 'cust_branch', 'general', '1175'),
('1600', '1232', 'customer', 'general', '1159'),
('1601', '1233', 'cust_branch', 'general', '1176'),
('1602', '1233', 'customer', 'general', '1160'),
('1603', '1234', 'cust_branch', 'general', '1177'),
('1604', '1234', 'customer', 'general', '1161'),
('1605', '1235', 'cust_branch', 'general', '1178'),
('1606', '1235', 'customer', 'general', '1162'),
('1607', '1236', 'cust_branch', 'general', '1179'),
('1608', '1236', 'customer', 'general', '1163'),
('1609', '1237', 'cust_branch', 'general', '1180'),
('1610', '1237', 'customer', 'general', '1164'),
('1611', '1238', 'cust_branch', 'general', '1181'),
('1612', '1238', 'customer', 'general', '1165'),
('1613', '1239', 'cust_branch', 'general', '1182'),
('1614', '1239', 'customer', 'general', '1166'),
('1615', '1240', 'cust_branch', 'general', '1183'),
('1616', '1240', 'customer', 'general', '1167'),
('1617', '1241', 'cust_branch', 'general', '1184'),
('1618', '1241', 'customer', 'general', '1168'),
('1619', '1242', 'cust_branch', 'general', '1185'),
('1620', '1242', 'customer', 'general', '1169'),
('1621', '1243', 'cust_branch', 'general', '1186'),
('1622', '1243', 'customer', 'general', '1170'),
('1623', '1244', 'cust_branch', 'general', '1187'),
('1624', '1244', 'customer', 'general', '1171'),
('1625', '1245', 'cust_branch', 'general', '1188'),
('1626', '1245', 'customer', 'general', '1172'),
('1627', '1246', 'cust_branch', 'general', '1189'),
('1628', '1246', 'customer', 'general', '1173'),
('1629', '1247', 'cust_branch', 'general', '1190'),
('1630', '1247', 'customer', 'general', '1174'),
('1631', '1248', 'cust_branch', 'general', '1191'),
('1632', '1248', 'customer', 'general', '1175'),
('1633', '1249', 'cust_branch', 'general', '1192'),
('1634', '1249', 'customer', 'general', '1176'),
('1635', '1250', 'cust_branch', 'general', '1193'),
('1636', '1250', 'customer', 'general', '1177'),
('1637', '1251', 'cust_branch', 'general', '1194'),
('1638', '1251', 'customer', 'general', '1178'),
('1639', '1252', 'cust_branch', 'general', '1195'),
('1640', '1252', 'customer', 'general', '1179'),
('1641', '1253', 'cust_branch', 'general', '1196'),
('1642', '1253', 'customer', 'general', '1180'),
('1643', '1254', 'cust_branch', 'general', '1197'),
('1644', '1254', 'customer', 'general', '1181'),
('1645', '1255', 'cust_branch', 'general', '1198'),
('1646', '1255', 'customer', 'general', '1182'),
('1647', '1256', 'cust_branch', 'general', '1199'),
('1648', '1256', 'customer', 'general', '1183'),
('1649', '1257', 'cust_branch', 'general', '1200'),
('1650', '1257', 'customer', 'general', '1184'),
('1651', '1260', 'cust_branch', 'general', '1201'),
('1652', '1260', 'customer', 'general', '1185'),
('1653', '1261', 'cust_branch', 'general', '1202'),
('1654', '1261', 'customer', 'general', '1186'),
('1655', '1262', 'cust_branch', 'general', '1203'),
('1656', '1262', 'customer', 'general', '1187'),
('1657', '1263', 'cust_branch', 'general', '1204'),
('1658', '1263', 'customer', 'general', '1188'),
('1659', '1264', 'cust_branch', 'general', '1205'),
('1660', '1264', 'customer', 'general', '1189'),
('1661', '1265', 'cust_branch', 'general', '1206'),
('1662', '1265', 'customer', 'general', '1190'),
('1663', '1266', 'cust_branch', 'general', '1207'),
('1664', '1266', 'customer', 'general', '1191'),
('1665', '1267', 'cust_branch', 'general', '1208'),
('1666', '1267', 'customer', 'general', '1192'),
('1667', '1268', 'cust_branch', 'general', '1209'),
('1668', '1268', 'customer', 'general', '1193'),
('1669', '1269', 'cust_branch', 'general', '1210'),
('1670', '1269', 'customer', 'general', '1194'),
('1671', '1270', 'supplier', 'general', '61'),
('1672', '1271', 'cust_branch', 'general', '1211'),
('1673', '1271', 'customer', 'general', '1195'),
('1674', '1272', 'cust_branch', 'general', '1212'),
('1675', '1272', 'customer', 'general', '1196'),
('1676', '1273', 'cust_branch', 'general', '1213'),
('1677', '1273', 'customer', 'general', '1197'),
('1678', '1274', 'cust_branch', 'general', '1214'),
('1679', '1274', 'customer', 'general', '1198'),
('1680', '1275', 'cust_branch', 'general', '1215'),
('1681', '1275', 'customer', 'general', '1199'),
('1683', '1276', 'customer', 'general', '1200'),
('1684', '1277', 'cust_branch', 'general', '1217'),
('1685', '1277', 'customer', 'general', '1201'),
('1686', '1278', 'cust_branch', 'general', '1218'),
('1687', '1278', 'customer', 'general', '1202'),
('1688', '1279', 'cust_branch', 'general', '1219'),
('1689', '1279', 'customer', 'general', '1203'),
('1690', '1280', 'cust_branch', 'general', '1220'),
('1691', '1280', 'customer', 'general', '1204'),
('1692', '1281', 'cust_branch', 'general', '1221'),
('1693', '1281', 'customer', 'general', '1205'),
('1694', '1282', 'cust_branch', 'general', '1222'),
('1695', '1282', 'customer', 'general', '1206'),
('1696', '1283', 'supplier', 'general', '62'),
('1697', '1284', 'cust_branch', 'general', '1223'),
('1698', '1284', 'customer', 'general', '1207'),
('1699', '1285', 'cust_branch', 'general', '1224'),
('1700', '1285', 'customer', 'general', '1208'),
('1701', '1286', 'cust_branch', 'general', '1225'),
('1702', '1286', 'customer', 'general', '1209'),
('1703', '1287', 'cust_branch', 'general', '1226'),
('1704', '1287', 'customer', 'general', '1210'),
('1705', '1288', 'cust_branch', 'general', '1227'),
('1706', '1288', 'customer', 'general', '1211'),
('1707', '1289', 'cust_branch', 'general', '1228'),
('1708', '1289', 'customer', 'general', '1212'),
('1709', '1290', 'cust_branch', 'general', '1229'),
('1710', '1290', 'customer', 'general', '1213'),
('1711', '1291', 'cust_branch', 'general', '1230'),
('1712', '1291', 'customer', 'general', '1214'),
('1713', '1292', 'cust_branch', 'general', '1231'),
('1714', '1292', 'customer', 'general', '1215'),
('1715', '1293', 'cust_branch', 'general', '1232'),
('1716', '1293', 'customer', 'general', '1216'),
('1717', '1294', 'supplier', 'general', '63'),
('1718', '1295', 'cust_branch', 'general', '1233'),
('1719', '1295', 'customer', 'general', '1217'),
('1720', '1296', 'cust_branch', 'general', '1234'),
('1721', '1296', 'customer', 'general', '1218'),
('1722', '1297', 'cust_branch', 'general', '1235'),
('1723', '1297', 'customer', 'general', '1219'),
('1724', '1298', 'cust_branch', 'general', '1236'),
('1725', '1298', 'customer', 'general', '1220'),
('1726', '1299', 'cust_branch', 'general', '1237'),
('1727', '1299', 'customer', 'general', '1221'),
('1728', '1300', 'cust_branch', 'general', '1238'),
('1729', '1300', 'customer', 'general', '1222'),
('1730', '1301', 'cust_branch', 'general', '1239'),
('1731', '1301', 'customer', 'general', '1223'),
('1732', '1302', 'cust_branch', 'general', '1240'),
('1733', '1302', 'customer', 'general', '1224'),
('1734', '1303', 'cust_branch', 'general', '1241'),
('1735', '1303', 'customer', 'general', '1225'),
('1736', '963', 'customer', 'general', '896'),
('1737', '1304', 'cust_branch', 'general', '1242'),
('1738', '1304', 'customer', 'general', '1226'),
('1739', '1305', 'cust_branch', 'general', '1243'),
('1740', '1305', 'customer', 'general', '1227'),
('1741', '1306', 'cust_branch', 'general', '1244'),
('1742', '1306', 'customer', 'general', '1228'),
('1743', '1307', 'cust_branch', 'general', '1245'),
('1744', '1307', 'customer', 'general', '1229'),
('1745', '1308', 'supplier', 'general', '64'),
('1746', '1309', 'cust_branch', 'general', '1246'),
('1747', '1309', 'customer', 'general', '1230'),
('1748', '1310', 'cust_branch', 'general', '1247'),
('1749', '1310', 'customer', 'general', '1231'),
('1750', '1311', 'cust_branch', 'general', '1248'),
('1751', '1311', 'customer', 'general', '1232'),
('1752', '1312', 'cust_branch', 'general', '1249'),
('1753', '1312', 'customer', 'general', '1233'),
('1754', '1313', 'cust_branch', 'general', '1250'),
('1755', '1313', 'customer', 'general', '1234'),
('1756', '1314', 'cust_branch', 'general', '1251'),
('1757', '1314', 'customer', 'general', '1235'),
('1758', '1315', 'cust_branch', 'general', '1252'),
('1759', '1315', 'customer', 'general', '1236'),
('1760', '1316', 'cust_branch', 'general', '1253'),
('1761', '1316', 'customer', 'general', '1237'),
('1762', '1317', 'cust_branch', 'general', '1254'),
('1763', '1317', 'customer', 'general', '1238'),
('1764', '1318', 'cust_branch', 'general', '1255'),
('1765', '1318', 'customer', 'general', '1239'),
('1766', '1319', 'cust_branch', 'general', '1256'),
('1767', '1319', 'customer', 'general', '1240'),
('1768', '1320', 'cust_branch', 'general', '1257'),
('1769', '1320', 'customer', 'general', '1241'),
('1770', '1321', 'cust_branch', 'general', '1258'),
('1771', '1321', 'customer', 'general', '1242'),
('1772', '1322', 'cust_branch', 'general', '1259'),
('1773', '1322', 'customer', 'general', '1243'),
('1774', '1323', 'cust_branch', 'general', '1260'),
('1775', '1323', 'customer', 'general', '1244'),
('1776', '1324', 'cust_branch', 'general', '1261'),
('1777', '1324', 'customer', 'general', '1245'),
('1778', '1325', 'cust_branch', 'general', '1262'),
('1779', '1325', 'customer', 'general', '1246'),
('1780', '1326', 'cust_branch', 'general', '1263'),
('1781', '1326', 'customer', 'general', '1247'),
('1782', '1327', 'cust_branch', 'general', '1264'),
('1783', '1327', 'customer', 'general', '1248'),
('1784', '1328', 'cust_branch', 'general', '1265'),
('1785', '1328', 'customer', 'general', '1249'),
('1786', '1329', 'cust_branch', 'general', '1266'),
('1787', '1329', 'customer', 'general', '1250'),
('1788', '1330', 'cust_branch', 'general', '1267'),
('1789', '1330', 'customer', 'general', '1251'),
('1790', '1331', 'cust_branch', 'general', '1268'),
('1791', '1331', 'customer', 'general', '1252'),
('1792', '1332', 'cust_branch', 'general', '1269'),
('1793', '1332', 'customer', 'general', '1253'),
('1794', '1333', 'cust_branch', 'general', '1270'),
('1795', '1333', 'customer', 'general', '1254'),
('1796', '1334', 'supplier', 'general', '65'),
('1797', '1335', 'supplier', 'general', '66'),
('1798', '1336', 'cust_branch', 'general', '1271'),
('1799', '1336', 'customer', 'general', '1255'),
('1800', '1337', 'cust_branch', 'general', '1272'),
('1801', '1337', 'customer', 'general', '1256'),
('1802', '1338', 'cust_branch', 'general', '1273'),
('1803', '1338', 'customer', 'general', '1257'),
('1804', '1339', 'cust_branch', 'general', '1274'),
('1805', '1339', 'customer', 'general', '1258'),
('1806', '1340', 'cust_branch', 'general', '1275'),
('1807', '1340', 'customer', 'general', '1259'),
('1808', '1341', 'cust_branch', 'general', '1276'),
('1809', '1341', 'customer', 'general', '1260'),
('1810', '1342', 'cust_branch', 'general', '1277'),
('1811', '1342', 'customer', 'general', '1261'),
('1812', '1343', 'cust_branch', 'general', '1278'),
('1813', '1343', 'customer', 'general', '1262'),
('1814', '1344', 'cust_branch', 'general', '1279'),
('1815', '1344', 'customer', 'general', '1263'),
('1816', '1345', 'cust_branch', 'general', '1280'),
('1817', '1345', 'customer', 'general', '1264'),
('1818', '1346', 'cust_branch', 'general', '1281'),
('1819', '1346', 'customer', 'general', '1265'),
('1820', '1347', 'cust_branch', 'general', '1282'),
('1821', '1347', 'customer', 'general', '1266'),
('1822', '1348', 'cust_branch', 'general', '1283'),
('1823', '1348', 'customer', 'general', '1267'),
('1824', '1349', 'cust_branch', 'general', '1284'),
('1825', '1349', 'customer', 'general', '1268'),
('1826', '1350', 'cust_branch', 'general', '1285'),
('1827', '1350', 'customer', 'general', '1269'),
('1828', '1351', 'cust_branch', 'general', '1286'),
('1829', '1351', 'customer', 'general', '1270'),
('1830', '1352', 'cust_branch', 'general', '1287'),
('1831', '1352', 'customer', 'general', '1271'),
('1832', '1353', 'cust_branch', 'general', '1288'),
('1833', '1353', 'customer', 'general', '1272'),
('1834', '883', 'cust_branch', 'general', '837'),
('1835', '1354', 'cust_branch', 'general', '1289'),
('1836', '1354', 'customer', 'general', '1273'),
('1837', '1355', 'cust_branch', 'general', '1290'),
('1838', '1355', 'customer', 'general', '1274'),
('1839', '1356', 'cust_branch', 'general', '1291'),
('1840', '1356', 'customer', 'general', '1275'),
('1841', '1357', 'cust_branch', 'general', '1292'),
('1842', '1357', 'customer', 'general', '1276'),
('1843', '1358', 'cust_branch', 'general', '1293'),
('1844', '1358', 'customer', 'general', '1277'),
('1845', '1359', 'cust_branch', 'general', '1294'),
('1846', '1359', 'customer', 'general', '1278'),
('1847', '1360', 'cust_branch', 'general', '1295'),
('1848', '1360', 'customer', 'general', '1279'),
('1849', '1361', 'cust_branch', 'general', '1296'),
('1850', '1361', 'customer', 'general', '1280'),
('1851', '1362', 'supplier', 'general', '67'),
('1852', '1363', 'cust_branch', 'general', '1297'),
('1853', '1363', 'customer', 'general', '1281'),
('1854', '1364', 'cust_branch', 'general', '1298'),
('1855', '1364', 'customer', 'general', '1282'),
('1856', '1365', 'cust_branch', 'general', '1299'),
('1857', '1365', 'customer', 'general', '1283'),
('1858', '1366', 'cust_branch', 'general', '1300'),
('1859', '1366', 'customer', 'general', '1284'),
('1860', '1367', 'cust_branch', 'general', '1301'),
('1861', '1367', 'customer', 'general', '1285'),
('1862', '1368', 'cust_branch', 'general', '1302'),
('1863', '1368', 'customer', 'general', '1286'),
('1864', '1369', 'cust_branch', 'general', '1303'),
('1865', '1369', 'customer', 'general', '1287'),
('1866', '1370', 'cust_branch', 'general', '1304'),
('1867', '1370', 'customer', 'general', '1288'),
('1868', '1371', 'cust_branch', 'general', '1305'),
('1869', '1371', 'customer', 'general', '1289'),
('1870', '1372', 'cust_branch', 'general', '1306'),
('1871', '1372', 'customer', 'general', '1290'),
('1872', '1373', 'cust_branch', 'general', '1307'),
('1873', '1373', 'customer', 'general', '1291'),
('1874', '1374', 'cust_branch', 'general', '1308'),
('1875', '1374', 'customer', 'general', '1292'),
('1876', '1375', 'cust_branch', 'general', '1309'),
('1877', '1375', 'customer', 'general', '1293'),
('1878', '1376', 'cust_branch', 'general', '1310'),
('1879', '1376', 'customer', 'general', '1294'),
('1880', '1377', 'cust_branch', 'general', '1311'),
('1881', '1377', 'customer', 'general', '1295'),
('1882', '1378', 'cust_branch', 'general', '1312'),
('1883', '1378', 'customer', 'general', '1296'),
('1884', '1379', 'cust_branch', 'general', '1313'),
('1885', '1379', 'customer', 'general', '1297'),
('1886', '1380', 'cust_branch', 'general', '1314'),
('1887', '1380', 'customer', 'general', '1298'),
('1888', '1381', 'cust_branch', 'general', '1315'),
('1889', '1381', 'customer', 'general', '1299'),
('1890', '1382', 'cust_branch', 'general', '1316'),
('1891', '1382', 'customer', 'general', '1300'),
('1892', '1383', 'cust_branch', 'general', '1317'),
('1893', '1383', 'customer', 'general', '1301'),
('1894', '1384', 'cust_branch', 'general', '1318'),
('1895', '1384', 'customer', 'general', '1302'),
('1896', '1385', 'cust_branch', 'general', '1319'),
('1897', '1385', 'customer', 'general', '1303'),
('1898', '1386', 'cust_branch', 'general', '1320'),
('1899', '1386', 'customer', 'general', '1304'),
('1900', '1387', 'cust_branch', 'general', '1321'),
('1901', '1387', 'customer', 'general', '1305'),
('1902', '1388', 'cust_branch', 'general', '1322'),
('1903', '1388', 'customer', 'general', '1306'),
('1904', '1390', 'cust_branch', 'general', '1323'),
('1905', '1390', 'customer', 'general', '1307'),
('1906', '1391', 'cust_branch', 'general', '1324'),
('1907', '1391', 'customer', 'general', '1308'),
('1908', '1392', 'cust_branch', 'general', '1325'),
('1909', '1392', 'customer', 'general', '1309'),
('1910', '1393', 'cust_branch', 'general', '1326'),
('1911', '1393', 'customer', 'general', '1310'),
('1912', '1394', 'cust_branch', 'general', '1327'),
('1913', '1394', 'customer', 'general', '1311'),
('1914', '1395', 'cust_branch', 'general', '1328'),
('1915', '1395', 'customer', 'general', '1312'),
('1916', '1396', 'cust_branch', 'general', '1329'),
('1917', '1396', 'customer', 'general', '1313'),
('1918', '1397', 'cust_branch', 'general', '1330'),
('1919', '1397', 'customer', 'general', '1314'),
('1920', '1398', 'cust_branch', 'general', '1331'),
('1921', '1398', 'customer', 'general', '1315'),
('1922', '1399', 'cust_branch', 'general', '1332'),
('1923', '1399', 'customer', 'general', '1316'),
('1924', '1400', 'cust_branch', 'general', '1333'),
('1925', '1400', 'customer', 'general', '1317'),
('1926', '1401', 'cust_branch', 'general', '1334'),
('1927', '1401', 'customer', 'general', '1318'),
('1928', '1402', 'cust_branch', 'general', '1335'),
('1929', '1402', 'customer', 'general', '1319'),
('1930', '1403', 'cust_branch', 'general', '1336'),
('1931', '1403', 'customer', 'general', '1320'),
('1932', '1404', 'cust_branch', 'general', '1337'),
('1933', '1404', 'customer', 'general', '1321'),
('1934', '1405', 'cust_branch', 'general', '1338'),
('1935', '1405', 'customer', 'general', '1322'),
('1936', '1406', 'cust_branch', 'general', '1339'),
('1937', '1406', 'customer', 'general', '1323'),
('1938', '1407', 'cust_branch', 'general', '1340'),
('1939', '1407', 'customer', 'general', '1324'),
('1940', '1408', 'cust_branch', 'general', '1341'),
('1941', '1408', 'customer', 'general', '1325'),
('1942', '1409', 'cust_branch', 'general', '1342'),
('1943', '1409', 'customer', 'general', '1326'),
('1944', '1410', 'cust_branch', 'general', '1343'),
('1945', '1410', 'customer', 'general', '1327'),
('1946', '1411', 'cust_branch', 'general', '1344'),
('1947', '1411', 'customer', 'general', '1328'),
('1948', '1412', 'cust_branch', 'general', '1345'),
('1949', '1412', 'customer', 'general', '1329'),
('1950', '1413', 'cust_branch', 'general', '1346'),
('1951', '1413', 'customer', 'general', '1330'),
('1952', '1414', 'cust_branch', 'general', '1347'),
('1953', '1414', 'customer', 'general', '1331'),
('1954', '1415', 'cust_branch', 'general', '1348'),
('1955', '1415', 'customer', 'general', '1332'),
('1956', '1416', 'cust_branch', 'general', '1349'),
('1957', '1416', 'customer', 'general', '1333'),
('1958', '1417', 'cust_branch', 'general', '1350'),
('1959', '1417', 'customer', 'general', '1334'),
('1960', '1418', 'cust_branch', 'general', '1351'),
('1961', '1418', 'customer', 'general', '1335'),
('1962', '1419', 'cust_branch', 'general', '1352'),
('1963', '1419', 'customer', 'general', '1336'),
('1964', '1420', 'cust_branch', 'general', '1353'),
('1965', '1420', 'customer', 'general', '1337'),
('1966', '1421', 'cust_branch', 'general', '1354'),
('1967', '1421', 'customer', 'general', '1338'),
('1968', '1422', 'cust_branch', 'general', '1355'),
('1969', '1422', 'customer', 'general', '1339'),
('1970', '1423', 'cust_branch', 'general', '1356'),
('1971', '1423', 'customer', 'general', '1340'),
('1972', '1424', 'cust_branch', 'general', '1357'),
('1973', '1424', 'customer', 'general', '1341'),
('1974', '1425', 'cust_branch', 'general', '1358'),
('1975', '1425', 'customer', 'general', '1342'),
('1976', '1426', 'cust_branch', 'general', '1359'),
('1977', '1426', 'customer', 'general', '1343'),
('1978', '1427', 'cust_branch', 'general', '1360'),
('1979', '1427', 'customer', 'general', '1344'),
('1980', '1428', 'cust_branch', 'general', '1361'),
('1981', '1428', 'customer', 'general', '1345'),
('1982', '1429', 'cust_branch', 'general', '1362'),
('1983', '1429', 'customer', 'general', '1346'),
('1984', '1430', 'cust_branch', 'general', '1363'),
('1985', '1430', 'customer', 'general', '1347'),
('1986', '1431', 'cust_branch', 'general', '1364'),
('1987', '1431', 'customer', 'general', '1348'),
('1988', '1432', 'cust_branch', 'general', '1365'),
('1989', '1432', 'customer', 'general', '1349'),
('1990', '1433', 'cust_branch', 'general', '1366'),
('1991', '1433', 'customer', 'general', '1350'),
('1992', '1434', 'cust_branch', 'general', '1367'),
('1993', '1434', 'customer', 'general', '1351'),
('1994', '1435', 'cust_branch', 'general', '1368'),
('1995', '1435', 'customer', 'general', '1352'),
('1996', '1436', 'cust_branch', 'general', '1369'),
('1997', '1436', 'customer', 'general', '1353'),
('1998', '1437', 'supplier', 'general', '68'),
('1999', '1438', 'cust_branch', 'general', '1370'),
('2000', '1438', 'customer', 'general', '1354'),
('2001', '1439', 'cust_branch', 'general', '1371'),
('2002', '1439', 'customer', 'general', '1355'),
('2003', '1440', 'cust_branch', 'general', '1372'),
('2004', '1440', 'customer', 'general', '1356'),
('2005', '1441', 'cust_branch', 'general', '1373'),
('2006', '1441', 'customer', 'general', '1357'),
('2007', '1442', 'cust_branch', 'general', '1374'),
('2008', '1442', 'customer', 'general', '1358'),
('2009', '1443', 'cust_branch', 'general', '1375'),
('2010', '1443', 'customer', 'general', '1359'),
('2011', '1444', 'cust_branch', 'general', '1376'),
('2012', '1444', 'customer', 'general', '1360'),
('2013', '1445', 'cust_branch', 'general', '1377'),
('2014', '1445', 'customer', 'general', '1361'),
('2015', '1446', 'cust_branch', 'general', '1378'),
('2016', '1446', 'customer', 'general', '1362'),
('2017', '1447', 'cust_branch', 'general', '1379'),
('2018', '1447', 'customer', 'general', '1363'),
('2019', '1448', 'cust_branch', 'general', '1380'),
('2020', '1448', 'customer', 'general', '1364'),
('2021', '1449', 'cust_branch', 'general', '1381'),
('2022', '1449', 'customer', 'general', '1365'),
('2023', '1450', 'cust_branch', 'general', '1382'),
('2024', '1450', 'customer', 'general', '1366'),
('2025', '1451', 'cust_branch', 'general', '1383'),
('2026', '1451', 'customer', 'general', '1367'),
('2027', '1452', 'cust_branch', 'general', '1384'),
('2028', '1452', 'customer', 'general', '1368'),
('2029', '1453', 'cust_branch', 'general', '1385'),
('2030', '1453', 'customer', 'general', '1369'),
('2031', '1276', 'cust_branch', 'general', '1216'),
('2032', '1454', 'cust_branch', 'general', '1386'),
('2033', '1454', 'customer', 'general', '1370'),
('2034', '1455', 'cust_branch', 'general', '1387'),
('2035', '1455', 'customer', 'general', '1371'),
('2036', '1456', 'cust_branch', 'general', '1388'),
('2037', '1456', 'customer', 'general', '1372'),
('2038', '1457', 'cust_branch', 'general', '1389'),
('2039', '1457', 'customer', 'general', '1373'),
('2040', '1458', 'cust_branch', 'general', '1390'),
('2041', '1458', 'customer', 'general', '1374'),
('2042', '1459', 'cust_branch', 'general', '1391'),
('2043', '1459', 'customer', 'general', '1375'),
('2044', '1460', 'cust_branch', 'general', '1392'),
('2045', '1460', 'customer', 'general', '1376'),
('2046', '1461', 'cust_branch', 'general', '1393'),
('2047', '1461', 'customer', 'general', '1377'),
('2048', '1462', 'cust_branch', 'general', '1394'),
('2049', '1462', 'customer', 'general', '1378'),
('2050', '1463', 'cust_branch', 'general', '1395'),
('2051', '1463', 'customer', 'general', '1379'),
('2052', '1464', 'cust_branch', 'general', '1396'),
('2053', '1464', 'customer', 'general', '1384'),
('2054', '1465', 'cust_branch', 'general', '1397'),
('2055', '1465', 'customer', 'general', '1385'),
('2056', '1466', 'cust_branch', 'general', '1398'),
('2057', '1466', 'customer', 'general', '1386'),
('2058', '1467', 'cust_branch', 'general', '1399'),
('2059', '1467', 'customer', 'general', '1387'),
('2060', '1468', 'cust_branch', 'general', '1400'),
('2061', '1468', 'customer', 'general', '1388'),
('2062', '1469', 'cust_branch', 'general', '1401'),
('2063', '1469', 'customer', 'general', '1389'),
('2064', '1470', 'cust_branch', 'general', '1402'),
('2065', '1470', 'customer', 'general', '1390'),
('2066', '1471', 'cust_branch', 'general', '1403'),
('2067', '1471', 'customer', 'general', '1391'),
('2068', '1472', 'cust_branch', 'general', '1404'),
('2069', '1472', 'customer', 'general', '1392'),
('2070', '1473', 'cust_branch', 'general', '1405'),
('2071', '1473', 'customer', 'general', '1393'),
('2072', '1474', 'cust_branch', 'general', '1406'),
('2073', '1474', 'customer', 'general', '1394'),
('2076', '1475', 'customer', 'general', '1397'),
('2079', '1475', 'cust_branch', 'general', '1407'),
('2080', '468', 'cust_branch', 'general', '431');

### Structure of table `0_crm_persons` ###

DROP TABLE IF EXISTS `0_crm_persons`;

CREATE TABLE `0_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `name2` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` tinytext COLLATE utf8_unicode_ci,
  `phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone2` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lang` char(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=1476 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_persons` ###

INSERT INTO `0_crm_persons` VALUES
('1', 'Techzone', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('2', 'sil', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('3', 'high', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('4', 'opensys', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('5', 'Main Branch', 'Main Branch', NULL, 'BAM Holdings Limited\n120, Station Road\nHomagama.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('6', 'Main Branch', 'Main Branch', NULL, 'Bartleet Produce Marketing(Pvt)Ltd.\n211/10 Veluwana Place\nColombo 9.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('7', 'Main Branch', 'Main Branch', NULL, 'De La Ru Lanka (Pvt)Ltd.\nExport Processing Zone\nBiyagama\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('8', 'Main Branch', 'Main Branch', NULL, 'Employee Trust Fund Board\n44/5, Narahenpita Road,\nNawala.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('9', 'Main Branch', 'Main Branch', NULL, 'Field Services Limited\n26, Milagiriya Avenue\nColombo 4.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('10', 'Main Branch', 'Main Branch', NULL, 'Free Lanka Trading Co; Ltd.\nLevel 3, Prince Alfred Tower\nColombo 3.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('11', 'Main Branch', 'Main Branch', NULL, 'Inbay Limited\nOne Selforde Street,\nClerkenwell,\nLondon ECIR OBE', NULL, NULL, NULL, NULL, NULL, '', '0'),
('13', 'Main Branch', 'Main Branch', NULL, 'Mitsui O.S.K.Lines Lanka (Pvt)Ltd.\nLevel 12, Access Towers\n278, Union Place,\nColombo 2.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('14', 'Main Branch', 'Main Branch', NULL, '234/2, Galle Road,\nColombo 3.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('15', 'pharm', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('16', 'dms', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('17', 'peebee', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('18', 'Main Branch', 'Main Branch', NULL, '12,Edmonton Lane,\nColombo 6', NULL, NULL, NULL, NULL, NULL, '', '0'),
('19', 'Main Branch', 'Main Branch', NULL, 'Negombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('20', 'Main Branch', 'Main Branch', NULL, 'No.8, San Juan, St.George?s Road,\nSt.Julians, ST J 3203, Malta. \n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('21', 'Main Branch', 'Main Branch', NULL, 'No.14, Station Road,\nMaharagama.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('22', 'Main Branch', 'Main Branch', NULL, 'Slave Island,\nColombo 2.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('23', 'Main Branch', 'Main Branch', NULL, 'Kirula Road,\nColombo 5.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('24', 'Main Branch', 'Main Branch', NULL, 'Havelock Road,\nPannipitiya.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('25', 'Main Branch', 'Main Branch', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('26', 'sj', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('27', 'dpj', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('28', 'Main Branch', 'Main Branch', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('32', 'Main Branch', 'Main Branch', NULL, 'Karapitiya, \nGalle.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('34', 'Main Branch', 'Main Branch', NULL, 'Kirimandala Mawatha,\nColombo 05.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('35', 'Main Branch', 'Main Branch', NULL, '114,Norris Canal Road,\nColombo 10.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('36', 'Main Branch', 'Main Branch', NULL, 'Karapitiya,\nGalle.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('37', 'Main Branch', 'Main Branch', NULL, 'Galle,', NULL, NULL, NULL, NULL, NULL, '', '0'),
('38', 'Main Branch', 'Main Branch', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('44', 'Main Branch', 'Main Branch', NULL, 'Colombo 10.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('45', 'Main Branch', 'Main Branch', NULL, 'Ragama.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('46', 'Main Branch', 'Main Branch', NULL, 'Ragama.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('47', 'Main Branch', 'Main Branch', NULL, 'Negombo.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('48', 'Main Branch', 'Main Branch', NULL, 'Ragama.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('49', 'Main Branch', 'Main Branch', NULL, '60, Park Street,\nColombo 02.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('50', 'Main Branch', 'Main Branch', NULL, 'Wathupitiwala,\nNittambuwa.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('51', 'Main Branch', 'Main Branch', NULL, 'Gampaha.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('52', 'Main Branch', 'Main Branch', NULL, 'Wattala.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('53', 'SLAA', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('54', 'Main Branch', 'Main Branch', NULL, 'Pinnaduwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('55', 'Main Branch', 'Main Branch', NULL, '7/1A, Bandaranayake Place,\nThanipolgaha Junction,\nGalle.', '0770483399', NULL, NULL, NULL, NULL, '', '0'),
('56', 'Main Branch', 'Main Branch', NULL, 'Gintota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('57', 'Main Branch', 'Main Branch', NULL, 'No.09, Karapitiya,\nGalle.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('58', 'Main Branch', 'Main Branch', NULL, 'General Hospital,\nHambantota.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('59', 'Main Branch', 'Main Branch', NULL, 'No. 90,Mahaveediya,\nAmbalantota.', '047 4909494', '047 2225433', NULL, NULL, NULL, '', '0'),
('60', 'Main Branch', 'Main Branch', NULL, 'Nakiyadeniya.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('61', 'Main Branch', 'Main Branch', NULL, 'Akuressa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('62', 'Main Branch', 'Main Branch', NULL, 'Makuluwa Junction,\nGalle.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('63', 'Main Branch', 'Main Branch', NULL, 'Monaragala.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('65', 'Main Branch', 'Main Branch', NULL, 'Opposite Hospital,\nSirigala,\nMonaragala.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('66', 'Main Branch', 'Main Branch', NULL, 'No.78, Main Street,\nMonaragala.', '055 2276220', NULL, NULL, NULL, NULL, '', '0'),
('68', 'M.M. Saman A. De Silva', 'M.M. Saman A. De Silva', NULL, 'Monaragala.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('70', 'Dr. W. K. Dissanayake', 'Dr. W. K. Dissanayake', NULL, 'Deberawewa.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('73', 'Main Branch', 'Main Branch', NULL, 'Hambantota.', '047-2220378', NULL, NULL, NULL, NULL, '', '0'),
('76', 'Main Branch', 'Main Branch', NULL, 'Hambantota.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('77', 'Main Branch', 'Main Branch', NULL, 'Heenmara.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('78', 'Main Branch', 'Main Branch', NULL, 'Ketanwila, Akuressa.', '0777-151207', NULL, NULL, NULL, NULL, '', '0'),
('79', 'Main Branch', 'Main Branch', NULL, 'Ambalamwaththa,\nGalle.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('81', 'Main Branch', 'Main Branch', NULL, 'Yatadola, Mathugama.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('82', 'Main Branch', 'Main Branch', NULL, 'Piyadigama,\nGalle.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('83', 'Main Branch', 'Main Branch', NULL, '01, Ingiriya Road,\nPadukka.', '0112-859004', NULL, NULL, NULL, NULL, '', '0'),
('84', 'Main Branch', 'Main Branch', NULL, 'Negombo Road,\nMahabage.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('85', 'Main Branch', 'Main Branch', NULL, 'Gampaha.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('86', 'Main Branch', 'Main Branch', NULL, 'Gampaha.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('87', 'Main Branch', 'Main Branch', NULL, 'Gampaha.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('88', 'Dr. Kiyamudeen', 'Dr. Kiyamudeen', NULL, '186, Colombo Road,\nMalwana.', '0714 293 693', '011 2 450554', NULL, NULL, NULL, '', '0'),
('89', 'Main Branch', 'Main Branch', NULL, 'Mathugama.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('90', 'Main Branch', 'Main Branch', NULL, 'Kaluthara.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('91', 'Main Branch', 'Main Branch', NULL, 'Thawalama Junction,\nThawalama,\nGalle.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('92', 'Main Branch', 'Main Branch', NULL, 'Sarenthukade Junction,\nGalle.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('93', 'Main Branch', 'Main Branch', NULL, 'Weligama.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('94', 'Main Branch', 'Main Branch', NULL, 'Nagoda, Kaluthara.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('95', 'Main Branch', 'Main Branch', NULL, 'No. 90,Elapitiwala, Ragama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('96', 'Main Branch', 'Main Branch', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('97', 'kaypharma', '', NULL, '63/1, Railway Avenue\nNugegoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('99', 'arjuna', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('100', 'Main Branch', 'Main Branch', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('101', 'Main Branch', 'Main Branch', NULL, 'Australia.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('102', 'Main Branch', 'Main Branch', NULL, 'Front Street\nColombo 1.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('103', 'Main Branch', 'Main Branch', NULL, 'Colombo 8', NULL, NULL, NULL, NULL, NULL, '', '0'),
('104', 'chirag', '', NULL, 'Bangalore, India', NULL, NULL, NULL, NULL, NULL, '', '0'),
('105', 'Main Branch', 'Main Branch', NULL, 'Talagoha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('106', 'Main Branch', 'Main Branch', NULL, 'Ambalangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('107', 'Main Branch', 'Main Branch', NULL, 'Weligama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('108', 'Main Branch', 'Main Branch', NULL, 'Hiniduma', NULL, NULL, NULL, NULL, NULL, '', '0'),
('109', 'Main Branch', 'Main Branch', NULL, 'Nakiyadeniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('110', 'Main Branch', 'Main Branch', NULL, 'Tangalle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('111', 'Main Branch', 'Main Branch', NULL, 'Karapitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('112', 'Main Branch', 'Main Branch', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('113', 'Main Branch', 'Main Branch', NULL, 'Nakiyadeniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('114', 'Main Branch', 'Main Branch', NULL, 'Monaragala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('115', 'Main Branch', 'Main Branch', NULL, 'Borella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('116', 'Main Branch', 'Main Branch', NULL, 'Wattala.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('117', 'Main Branch', 'Main Branch', NULL, 'Wattala.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('118', 'Main Branch', 'Main Branch', NULL, 'Ja-ela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('119', 'Main Branch', 'Main Branch', NULL, 'Ja-ela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('120', 'Main Branch', 'Main Branch', NULL, 'Gampaha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('121', 'Main Branch', 'Main Branch', NULL, 'Yakkala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('122', 'Main Branch', 'Main Branch', NULL, 'Mahabage', NULL, NULL, NULL, NULL, NULL, '', '0'),
('123', 'Main Branch', 'Main Branch', NULL, 'Wattala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('124', 'Main Branch', 'Main Branch', NULL, 'Negombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('125', 'Main Branch', 'Main Branch', NULL, 'Negombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('126', 'Main Branch', 'Main Branch', NULL, 'Marawila', NULL, NULL, NULL, NULL, NULL, '', '0'),
('127', 'Main Branch', 'Main Branch', NULL, 'Nagoda,\nKandana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('128', 'Main Branch', 'Main Branch', NULL, 'Negombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('129', 'Main Branch', 'Main Branch', NULL, 'Makola.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('130', 'Main Branch', 'Main Branch', NULL, 'Divulapitiya.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('131', 'Main Branch', 'Main Branch', NULL, 'Church Street,\nColombo 2.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('132', 'Main Branch', 'Main Branch', NULL, 'Borella.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('133', 'Main Branch', 'Main Branch', NULL, 'Wennappuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('134', 'Main Branch', 'Main Branch', NULL, 'Dalupotha,\nNegombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('135', 'Main Branch', 'Main Branch', NULL, '71, Anderson Road,\nNegombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('136', 'Main Branch', 'Main Branch', NULL, 'Wennappuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('137', 'Main Branch', 'Main Branch', NULL, 'Gampaha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('139', 'Main Branch', 'Main Branch', NULL, 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('140', 'Main Branch', 'Main Branch', NULL, 'Ambalantota.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('141', 'Main Branch', 'Main Branch', NULL, 'Galle.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('142', 'Main Branch', 'Main Branch', NULL, 'Mapalagama Road,\nThalagaha.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('143', 'Main Branch', 'Main Branch', NULL, 'Kiwulawatta, \nBombuwella - Kaluthara.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('144', 'geofman', '', NULL, 'Pakistan', NULL, NULL, NULL, NULL, NULL, '', '0'),
('145', 'Main Branch', 'Main Branch', NULL, 'Thanamallwila.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('146', 'Main Branch', 'Main Branch', NULL, 'Base Hospital - Wellawaya.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('147', 'Main Branch', 'Main Branch', NULL, 'Pitabaddara.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('148', 'Main Branch', 'Main Branch', NULL, 'Dispensary, Kalubovitiyana.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('149', 'Main Branch', 'Main Branch', NULL, 'Kosnilgoda, Morawa.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('150', 'Main Branch', 'Main Branch', NULL, 'No.12, Mahaveediya,\nAkurassa.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('151', 'Main Branch', 'Main Branch', NULL, 'Gonamulla.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('152', 'Main Branch', 'Main Branch', NULL, 'Weerakatiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('153', 'Main Branch', 'Main Branch', NULL, 'Pilana.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('154', 'Main Branch', 'Main Branch', NULL, 'Bogahagoda.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('155', 'Main Branch', 'Main Branch', NULL, 'Imaduwa.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('156', 'Main Branch', 'Main Branch', NULL, 'No.51/1A, Olcott Mawatha,\nGalle.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('158', 'Main Branch', 'Main Branch', NULL, 'No.5C, H.K. Edmond Mawatha.\nSaranthukade Junction,\nGalle.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('159', 'Main Branch', 'Main Branch', NULL, 'Wennappuwa.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('160', 'Main Branch', 'Main Branch', NULL, 'No.101/11, St Mary&#039;s Road,\nSilver Place, Ja-Ela.', '011 2238141', NULL, NULL, NULL, NULL, '', '0'),
('161', 'Main Branch', 'Main Branch', NULL, 'No.04, Main Street, Mihirigama.', '033-2273029', NULL, NULL, NULL, NULL, '', '0'),
('162', 'Main Branch', 'Main Branch', NULL, 'Mirigama.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('163', 'Main Branch', 'Main Branch', NULL, 'No.10, Opposite Bus Stand,\nPasyala Road,\nMirigama.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('164', 'Main Branch', 'Main Branch', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('165', 'Main Branch', 'Main Branch', NULL, 'Family Health Medical Centre.\n18, Station Road, Pallewela.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('166', 'Dilshee', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('167', 'Kangaroo', '', NULL, NULL, '0112588588', NULL, NULL, NULL, NULL, '', '0'),
('168', 'ADT', '', NULL, 'sales@cctvyes.com', '0112385178', NULL, '0112386757', NULL, NULL, '', '0'),
('169', 'NDB Wealth Management', 'NDB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('170', 'Ceylinco Hotels Ltd', 'Ceylinco Hotel', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('171', 'Staff - Asanka Pathumkumara', 'sasanka', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('172', 'Staff ImprestAccount', 'staffimprest', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('173', 'Staff - Perera', 'staffperera', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('174', 'Finaly', '', NULL, 'Finaly House.\nP.O.Box 211,\nNo:186, Vauxhall Street,\nColombo.', '0114714392', NULL, NULL, 'sanitact@finlays.lk', NULL, '', '0'),
('175', 'DIC LANKA (PVT) LTD', 'DIC', NULL, 'No.147, Katuwana Industrial Estate,\nKatuwana Road,\nHomagama.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('176', 'Lawson pest control Internatio', 'Lawson Pest', NULL, 'No.330\nGalle Road\nColombo 04', NULL, NULL, NULL, NULL, NULL, '', '0'),
('177', 'Child Fund of Sri Lanka', 'childfund', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('178', 'Capital Lands', '', NULL, 'No.285.\nR.A.De Mel Mawatha \nColombo 03', '5361361', NULL, NULL, NULL, NULL, '', '0'),
('179', 'Genesiis', '', NULL, '49/16,\nIceland Building\nGalle road\nColombo 03', '0114765464', NULL, NULL, NULL, NULL, '', '0'),
('180', 'CEB', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('181', 'Dailog', '', NULL, 'No.475\nUnion Place,\nColombo 02', NULL, NULL, NULL, NULL, NULL, '', '0'),
('182', 'Dailog', '', NULL, 'No.475\nUnion Place,\nColombo 02', NULL, NULL, NULL, NULL, NULL, '', '0'),
('183', 'SLT', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('184', 'Lanka Bell', '', NULL, 'P.O Box 1719\nColombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('185', 'Dewa Pharmacy', 'Dewa', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('186', 'Dr.D.K.P.Rodrigo', 'Dr.D.K.P.Rodrigo', NULL, 'Kadana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('187', 'Dr.M.Fernando', 'Dr.M.Fernando', NULL, 'Wennappuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('188', 'Dr.Kumara Ranasinghe', 'Dr.Kumara Ranasinghe', NULL, 'Delgoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('189', 'Dr.Mrs.Chithra Perera', 'Dr.Mrs.Chithra Perera', NULL, 'Kadana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('190', 'Dr.Vajira Mendis', 'Dr.Vajira Mendis', NULL, 'Kadawatha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('191', 'Milan Pharmacy', 'Milan Pharmacy', NULL, 'Ederamulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('192', 'Ederamulla Pharamcy', 'Ederamulla Pharamcy', NULL, 'Ederamulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('193', 'Sanura Pharmacy', 'Sanura Pharmacy', NULL, 'Ederamulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('194', 'Dr.Mrs.H.Gunasena', 'Dr.Mrs.H.Gunasena', NULL, 'Kadana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('195', 'Dr.C.W.Liyanage', 'Dr.C.W.Liyanage', NULL, 'Dompe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('196', 'P.Lal', 'P.Lal', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('197', 'Dr.Sunil Mendis', 'Dr.Sunil Mendis', NULL, 'Ragama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('198', 'Dr.R.S.Jayakumar', 'Dr.R.S.Jayakumar', NULL, 'Hendala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('199', 'Janasuwa Pharmacy', 'Janasuwa Pharmacy', NULL, 'Biyagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('200', 'Janasetha Pharmacy', 'Janasetha', NULL, 'Sapugaskanda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('201', 'Medi Tech Pharmacy', 'Medi Tech', NULL, 'Gampaha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('202', 'Lanka Pharma', 'Lanka ', NULL, 'Mahara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('203', 'Nissi Pharmacy', 'Nissi', NULL, 'Wattala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('204', 'Dr.Mrs.C.Hathurusinghe', 'Dr.Mrs.C.Hathurusinghe', NULL, 'Wattala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('205', 'Dr.N.P.Hapuarachchi', 'Dr.N.P.Hapuarachchi', NULL, 'Sapugastenna', NULL, NULL, NULL, NULL, NULL, '', '0'),
('206', 'Dr.K.A.E.C.Premarathna', 'Dr.K.A.E.C.Premarathna', NULL, 'Nittabuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('207', 'My Chemist Pharmacy', 'My Chemist', NULL, 'Pallewela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('208', 'Dr.Naleem Perera', 'Dr.Naleem Perera', NULL, 'Kadana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('209', 'Dr.Sanath Fernando', 'Dr.Sanath Fernando', NULL, 'Wennappuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('210', 'Dr.D.Kumarasinghe', 'Dr.D.Kumarasinghe', NULL, 'Yakkala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('211', 'C&amp;D Pharmacy', 'C&amp;D Pharmacy', NULL, 'Bathuwattha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('212', 'Dr.Sydney Perera', 'Dr.Sydney Perera', NULL, 'Ederamulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('213', 'Dr.Senaka Herath', 'Dr.Senaka Herath', NULL, 'Ederamulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('214', 'Dr.Upul Pathirana', 'Dr.Upul Pathirana', NULL, 'Dompe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('215', 'Manahara Pharmacy', 'Manahara', NULL, 'Borella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('216', 'Dr.G.G.Hettiarachchi', 'Dr.G.G.Hettiarachchi', NULL, 'Sapugaskanda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('217', 'People&#039;s York Pharma', 'People&#039;s York', NULL, 'Colombo 08', NULL, NULL, NULL, NULL, NULL, '', '0'),
('218', 'Iraj Pharamaceuticals', 'Iraj ', NULL, 'Colombo 11', NULL, NULL, NULL, NULL, NULL, '', '0'),
('219', 'Dr.E.R.Weerasinghe', 'Dr.E.R.Weerasinghe', NULL, 'Bogoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('220', 'Ruhunu Medi House', 'Ruhunu Medi House', NULL, 'Hambanthota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('221', 'Dr.A.L.Sarjahan', 'Dr.A.L.Sarjahan', NULL, 'Ginthota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('222', 'Omaya Pharmacy', 'Omaya', NULL, 'Thanamalvilla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('223', 'New royal Pharamcy', 'New royal ', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('224', 'Isurudisi Pharmacy', 'Isurudisi Pharmacy', NULL, 'Pilane', NULL, NULL, NULL, NULL, NULL, '', '0'),
('225', 'New Supun Pharmacy', 'New Supun Pharmacy', NULL, 'Weligama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('226', 'New Gihan Pharmacy', 'New Gihan', NULL, 'Thawalama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('227', 'New Jayasinghe Pharmacy', 'New Jayasinghe', NULL, 'Hambanthota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('228', 'Sanmed Pharmacy', 'Sanmed', NULL, 'Benthota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('229', 'Dr.Manjula Nakandala', 'Dr.Manjula', NULL, 'Monaragala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('230', 'New Metro Pharma', 'New Metro ', NULL, 'Mathugama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('231', 'Dr.V.C.K.K.M.Rathnayake', 'Dr.Rathnayake', NULL, 'Tellabuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('232', 'Dr.M.I.D.Jayaweera', 'Dr..D.Jayaweera', NULL, 'Kirimatimulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('233', 'Mega Pharmacy', 'Mega Pharmacy', NULL, 'Kirimatimulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('234', 'New Central Pharmacy', 'New Central', NULL, 'Weligama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('235', 'new Chaminda Pharmacy', 'new Chaminda', NULL, 'Piyadigama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('236', 'Dilneth Pharma', 'Dilneth Pharma', NULL, 'Boossa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('237', 'K.J.P.Pharmacy', 'K.J.P.Pharmacy', NULL, 'Wellawaya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('238', 'Dr.P.Jayasekara', 'Dr.P.Jayasekara', NULL, 'Magaha Junction , Kaluthara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('239', 'Dr.Kusuma Liyanage', 'Dr.Kusuma Liyanage', NULL, 'Lelwela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('240', 'Thisara Pharma', 'Thisara Pharma', NULL, 'Karapitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('241', 'Delmon Pharmacy', 'Delmon Pharmacy', NULL, 'Baddagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('242', 'Dr.C.W.Janaka', 'Dr.C.W.Janaka', NULL, 'Tanipollgaha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('243', 'NIC', '', NULL, 'No.82 ,\nLesley Ranagala M.W.\nColombo 08', '0773594973', '0775768514', NULL, NULL, NULL, '', '0'),
('244', 'kangaroo', '', NULL, 'Galle Road, Colombo 3.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('245', 'Meewella', '', NULL, '329,\nGalle Road,\nColombo 04\nSri Lanka', '812031', NULL, NULL, NULL, NULL, '', '0'),
('246', 'D.Sivasutagaran', 'D.Sivasutagaran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('247', 'Frostaire', '', NULL, 'PO Box 1952 ,102\nUnion Place,\nColombo 02', '0112958958', NULL, NULL, NULL, NULL, '', '0'),
('248', 'Gamma', '', NULL, 'No.254,\nHinatikumbura Road\nHimbutana\nAngoda', '0112788999', '0773226884', NULL, NULL, NULL, '', '0'),
('249', 'National Lotteries Board', 'National Lotteries Board', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('250', 'Jayalath Pharmacy', 'jayalath', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('251', 'Induwara Pharmacy', 'Induwara', NULL, 'Induwara Pharmacy and grossary,\nJayanthi Junction,\nUdugama Road,\nGalle.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('252', 'New Southern Pharmacy &amp; Gr', 'Southern PH', NULL, ' Southern Pharmacy &amp; Grocery,\nNo 27A1/1,Karapitiya Road, Kalegana,Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('253', 'Dr V C K K M Rathnayake', 'M Rathnayake', NULL, 'Dr V C K K M Rathnayake,\nMedical Officer,\nTeaching Hospitial Karapitiya.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('254', 'Pasan Pharmacy', 'Pasan PH', NULL, 'Pasan Pharmacy,\nUdugama Road,\nNakiyadeniya,\nGalle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('255', 'Vimalasiri Pharmacy', 'Vimalasiri', NULL, 'Vimalasiri Pharmacy,\nAluthwala,\nGalle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('256', 'Sithruwana Pharmacy', 'Sithruwana', NULL, 'Sithruwana Pharmacy,\nNo;04,Shopping,\nBatapola,\nGallage', NULL, NULL, NULL, NULL, NULL, '', '0'),
('257', 'Union pharmacy', 'Union ph', NULL, 'Union pharmacy,Baddegama Road,\nAmpegama,\nGalle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('258', 'Dr Susantha Nadasena', 'Dr Susantha', NULL, 'Dr Susantha Nadasena,\nSLMC REG No 25553\nNeluwa,\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('259', 'Orent Pharmacy', 'Orent', NULL, 'Orent Pharmacy,\nPalawatha,\nGalle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('260', 'Desala Pharmacy', 'Desala PH', NULL, 'Desala Pharmacy,\nManikgoda,\nKatugahahena.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('261', 'Ram pharmacy &amp; grocery', 'Ram PH', NULL, 'Ram pharmacy &amp; grocery,\nKeeranthidiya,\nNaththuduwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('262', 'Manahari pharmacy', 'Manahari PH', NULL, 'Manahari pharmacy,\nMain Street,\nBalapitiya.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('263', 'Chandana Pharmacy', 'Chandana PH', NULL, 'Chandana Pharmacy &amp; grocery,\nGall road,\nYatalamatta.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('264', 'Nagodavithana Pharmacy', 'Nagodavithana  PH', NULL, 'Nagodavithana Pharmacy,\nThalgaswala.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('265', 'Medi house', 'Medi house', NULL, 'Medi house,\n1st cross road,\nniyagama,\nThalgaswala.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('266', 'Majestic pharmacy', 'Majestic ph', NULL, 'Majestic pharmacy,\nno122A,\nMain Street,\nCharoa Town.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('267', 'Jayantha pharmacy', 'Jayantha ph', NULL, 'Jayantha pharmacy,\nNo 365A,\nMain street,\ncharga Town.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('268', 'Medi cure pharmacy', 'Medi cure ph', NULL, 'Medi cure pharmacy,\n2E,Main street,\ndharaga Town', NULL, NULL, NULL, NULL, NULL, '', '0'),
('269', 'Lloyed pharmacy', 'Lloyed ph', NULL, 'Lloyed pharmacy,\nNo 94,\ngalle.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('270', 'Asanka pharmacy', 'Asanka PH', NULL, 'Asanka pharmacy,\nBorakanda,\nKarandeniya.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('271', 'Dr Thushara Edirisinghe', 'Dr Thushara', NULL, 'Dr Thushara Edirisinghe,\nGeneral Hospital,\nKalutara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('272', 'DR C C Gurusingha', 'DR C C Gurusingha', NULL, 'DR C C Gurusingha,\nElipitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('273', 'Dr Saman Patirana', 'Dr Saman Patirana', NULL, 'Dr Saman Patirana,\nGalle.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('274', 'Chathuranga pharmacy', 'Chathuranga ph', NULL, 'Chathuranga pharmacy,\nGalle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('275', 'Eraj pharmacy', 'Eraj ph', NULL, 'Eraj pharmacy,\nColombo 11.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('276', 'Dr M S Mohamed Ziyard', 'Dr M S Ziyard', NULL, 'Dr M S Mohamed Ziyard,\nTseyva hospital (PVT)LTD.No 11 Jayarathna road,\nDean junction ,\nNegambo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('277', 'city pharmacy', 'City ph', NULL, 'city pharmacy,\nno 166 \nWattala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('278', 'Dr K D Rodrigo', 'Dr K D Rodrigo', NULL, 'Dr K D Rodrigo,\nMedi house dispansary,\nKadana.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('279', 'C W Mackie PLC', '', NULL, NULL, '0112423554', NULL, '0112440228', 'info@cwmackie.com', 'C', '', '0'),
('280', 'C W Mackie PLC', '', NULL, NULL, '0112423554', NULL, '0112440228', 'info@cwmackie.com', 'C', '', '0'),
('281', 'Chater House', 'Chater House', NULL, 'Chater House,\nNawala road,\nnarahenpita,Colombo 5,\nSri Lanka.', '0112368690', NULL, '0112368625', NULL, NULL, '', '0'),
('282', 'Rocevilla pharmacy', 'Rocevilla pharmacy', NULL, 'Rocevilla pharmacy,\nEndramulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('283', 'Senura pharmacy', 'Senura pharmacy', NULL, 'Senura pharmacy,\n233/412,\ngamini jayapura,\nenderamulla,\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('284', 'Central medial stores', 'Central medial stores', NULL, 'Central medial stores,\ndruggist and grocers,\nMain street,\nDompe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('285', 'Asiri Pharmacy', 'Asiri pharmacy', NULL, 'Asiri pharmacy,\nDompe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('286', 'Star distributor', 'Star distributor', NULL, 'Star distributor,\nKadawatha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('287', 'Dr laxman siriwardana', 'Dr L siriwardana', NULL, 'Dr laxman siriwardana,\nmirigama clinic &amp; channel center,\nno 186,\nPasyala road,\nMirigama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('288', 'Dr Krishantha samaraweera', 'Dr K samaraweera', NULL, 'Dr Krishantha samaraweera,\nMallewa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('289', 'Dr P.Y.R gunathilaka', 'Dr P.Y.R gunathilaka', NULL, 'Dr P.Y.R gunathilaka,\nganemulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('290', 'Aravints (PVT) LTD', 'Aravints (PVT) LTD', NULL, 'Aravints (PVT) LTD,\n125/B,\nold Dispancery Road, \nHendala,\nWattala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('291', 'Mr Sumudu', 'Sumudu', NULL, 'Sumudu,\nKadawatha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('292', 'Abila Marketing services', 'Abila Marketing services', NULL, 'Abila Marketing services,\nNo 100/9A,\nBalagala Road,\nHendala,\nWattala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('293', 'evolve', 'Evolve Technologies (Pvt)Ltd.', NULL, '329, Galle Road,\nColombo 4.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('294', 'Techtools Integrators (Pvt)Ltd', 'techtools', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('295', 'Dr Daya Fernando', 'Dr Daya Fernando', NULL, 'No264,\nNagoda,\nKandana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('296', 'Dr P S K Samaranayaka', 'Dr P S K Samaranayaka', NULL, 'Wathupitiwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('297', 'HEALTH PHARMACY &amp; GROCERY', 'HEALTH PHARMACY &amp; GROCERY', NULL, 'HEALTH PHARMACY &amp; GROCERY\nKeembiela,\nBaddegama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('298', 'DR U L Piyathilaka', 'DR U L Piyathilaka', NULL, 'Dispansary surgery \nMedicare 25,Main street,\nAmbalangoda.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('299', 'Rajmalee Pharmacy &amp; Grocer', 'Rajmalee Pharmacy &amp; Grocery', NULL, 'Payagala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('300', 'ASHA Pharmacy', 'ASHA Pharmacy', NULL, 'Kaluthara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('301', 'Isuru Pharmacy', 'Isuru Pharmacy', NULL, 'No 7-Cross Road,\nKaluthra', NULL, NULL, NULL, NULL, NULL, '', '0'),
('302', 'Thilakam Pharmacy', 'Thilakam Pharmacy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('303', 'Kuamari Ph', 'Kuamari Ph', NULL, 'Pinnaduna', NULL, NULL, NULL, NULL, NULL, '', '0'),
('304', 'Chirath Osusala', 'Chirath Osusala', NULL, 'Dikkubura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('305', 'Sisira Pharmacy', 'Sisira Ph', NULL, 'Matara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('306', 'Union Dispancery', 'Union Dispancery', NULL, 'Matara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('307', 'Hiruni Pharmacy', 'Hiruni Ph', NULL, 'Dikkwella,\nMatara.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('308', 'Dr Nilanga Samarasinghe', 'Dr Nilanga Samarasinghe', NULL, 'Ragama Medical Center,\nEnderamulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('309', 'Ashen Pharmacy', 'Ashen Pharmacy', NULL, 'Kelaniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('310', 'Jeewanthi Pharmacy', 'Jeewanthi Pharmacy', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('311', 'Asini Pharmacy', 'Asini Pharmacy', NULL, 'Dompe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('312', 'Health palace', 'Health palace', NULL, 'Ampegama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('313', 'Westend Pharmacy', 'Westend Pharmacy', NULL, 'Megahathanna', NULL, NULL, NULL, NULL, NULL, '', '0'),
('314', 'We care Pharmacy', 'We care Pharmacy', NULL, 'China fort - Beruwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('315', 'Dr Damayanthi Gurusinha', 'Dr Damayanthi Gurusinha', NULL, 'Pituwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('316', 'Wimalasiri Pharmacy', 'Wimalasiri Pharmacy', NULL, 'Aluthwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('317', 'Dr C Premajayantha', 'Dr C Premajayantha', NULL, 'Wattala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('318', 'Chathumina Pharmacy', 'Chathumina Pharmacy', NULL, 'Diwalapitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('319', 'Jiffy Products SL (PVT) LTD', 'Jiffy Products SL (PVT) LTD', NULL, 'Mirigama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('320', 'The Muliti Stitch', 'The Muliti Stitch', NULL, 'Negombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('321', 'Dr Saliva Bombuwala', 'Dr Saliva Bombuwala', NULL, 'Minuwangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('322', 'Dr Ananda Ratnayaka', 'Dr Ananda Ratnayaka', NULL, 'Kadana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('323', 'Manadara resort (PVT) LTD', 'Manadara resort (PVT) LTD', NULL, 'De-fonseka Road,\nColombo 04.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('324', 'LUMINEX PRIVATE LIMITED', 'LUMINEX PRIVATE LIMITED', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('325', 'J &amp; H Technologies (Pvt)Lt', 'J&amp;H', NULL, '#242k, level 2 Nawala Road,  \nNawala.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('326', 'Abans PLC', 'Abans ', NULL, 'Mr. Chatura Jayawardena.\nSenior Brand Manager\nAbans PLC\n4th floor, Abans Head Office, \nNo. 498, Galle Road, Colombo 3,\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('327', 'Sonic Computers', 'Sonic Computers', NULL, 'No 50,\nStation Road,\nNugegoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('328', 'S S Pharmacy', 'S S Pharmacy', NULL, 'Naboda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('329', 'DR Danasiri Malliyawadu', 'DR Danasiri Malliyawadu', NULL, 'Naboda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('330', 'Samarasinaha PH', 'Samarasinaha PH', NULL, 'Pollgampola', NULL, NULL, NULL, NULL, NULL, '', '0'),
('331', 'Star PH', 'Star PH', NULL, 'Kaluthara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('332', 'Gintota PH', 'Gintota PH', NULL, 'Galle road gintota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('333', 'Pemachandra PH', 'Pemachandra PH', NULL, 'Kurudugaha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('334', 'Elpitiya Medical food city', 'Elpitiya Medical food city', NULL, 'Elpitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('335', 'MIMS PH', 'MIMS PH', NULL, 'Waduraba', NULL, NULL, NULL, NULL, NULL, '', '0'),
('336', 'M/S Chandara PH', 'M/S Chandara PH', NULL, 'Yatlalamula', NULL, NULL, NULL, NULL, NULL, '', '0'),
('337', 'Dissanayaka PH', 'Dissanayaka PH', NULL, 'Neluwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('338', 'DR Arunlal', 'DR Arunlal', NULL, 'Panepitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('339', 'Dr P C Liyanage', 'Dr P C Liyanage', NULL, 'Welipitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('340', 'Sahana PH', 'Sahana PH', NULL, 'Telijjawila', NULL, NULL, NULL, NULL, NULL, '', '0'),
('341', 'Sampath PH', 'Sampath PH', NULL, 'Ambalangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('342', 'Dr D R K Sirisena', 'Dr D R K Sirisena', NULL, 'Karandeniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('343', 'Sethsuwa PH', 'Sethsuwa PH', NULL, 'Agalawatha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('344', 'Ravi PH', 'Ravi PH', NULL, 'Ithapana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('345', 'Stemm PH', 'Stemm PH', NULL, 'Tanipollgaha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('346', 'Sathren PH', 'Sathren PH', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('347', 'Taridu PH', 'Taridu PH', NULL, 'Mirissa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('348', 'Dr Nilantha Priyasana', 'Dr Nilantha Priyasana', NULL, 'Thalgaswela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('349', 'Polegoda PH', 'Polegoda PH', NULL, 'Poligoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('350', 'Dr H A C Mangala', 'Dr H A C Mangala', NULL, 'Godapitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('351', 'Sehansa PH', 'Sehansa PH', NULL, 'Rathgama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('352', 'Nayana PH', 'Nayana PH', NULL, 'Wathugedara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('353', 'Saranga PH', 'Saranga PH', NULL, 'Tawalama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('354', 'Gayan PH', 'Gayan PH', NULL, 'Wetharawitha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('355', 'Isiwara PH', 'Isiwara PH', NULL, 'Nagoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('356', 'New Supreem PH', 'New Supreem PH', NULL, 'Elpitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('357', 'Dr Keertisena vithanage', 'Dr Keertisena vithanage', NULL, 'Agalawaththa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('358', 'Karapitiya Medical', 'Karapitiya Medical', NULL, 'Ampegama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('359', 'Involve 360 PVT LTD', 'Involve 360 PVT LTD', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('360', 'Dilhani Chemist', 'Dilhani Chemist', NULL, 'Maggona', NULL, NULL, NULL, NULL, NULL, '', '0'),
('361', 'Tritel Services Pvt. Ltd', 'tritel', NULL, 'No.19/4, Sri Saranankara Road,\nColombo 4.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('362', 'Sonic Computers', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('363', 'Dr Sanath Pathirana', 'Dr Sanath Pathirana', NULL, 'Katarvila', NULL, NULL, NULL, NULL, NULL, '', '0'),
('364', 'Dr Menaka Widanapathirana', 'Dr Menaka Widanapathirana', NULL, 'Poraba', NULL, NULL, NULL, NULL, NULL, '', '0'),
('365', 'Dr Krishantha Samaraweera', 'Dr Krishantha Samaraweera', NULL, 'Mallewa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('366', 'Amila', 'Amila', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('367', 'Infinex Solutions (PVT) LTD', 'Infinex Solutions (PVT) LTD', NULL, '10 1/1 Unity place,\nColombo 3', NULL, NULL, NULL, NULL, NULL, '', '0'),
('368', 'THUNDER &amp; NEON (PVT) LTD', 'THUNDER &amp; NEON (PVT) LTD', NULL, '191, Kasbewa road, werahera,Boralesgamuwa.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('369', 'SP Software Private Limited', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('370', 'Mr Anupam Rahi', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('371', 'Prasanna PH', 'Prasanna PH', NULL, 'Prasanna PH,\nWakwella road,\nGalle\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('372', 'Dr Anuruddhika Karunarathne', 'Dr Anuruddhika Karunarathne', NULL, 'Dr Anuruddhika Karunarathne,\nTeligavila,\nMatara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('373', 'Ashoka Chanal Center', 'Ashoka Chanal Center', NULL, 'Ashoka Chanal Center,\nBalapitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('374', 'Dr Manjula M Kumara', 'Dr Manjula M Kumara', NULL, 'Dr Manjula M Kumara,\nBeralihela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('375', 'Dr Ajith Kumara', 'Dr Ajith Kumara', NULL, 'Katharagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('376', 'Lisara PH', 'Lisara PH', NULL, 'Kataragama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('377', 'Dr W Dissanayaka', 'Dr W Dissanayaka', NULL, 'Deberawewa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('378', 'Mr Udara Weerasinghe', 'Mr Udara Weerasinghe', NULL, 'Singhagiri(PVT)LTD\nNo 515,\nDarley Road,\nColombo 10', NULL, NULL, NULL, NULL, NULL, '', '0'),
('379', 'Priminto PH', 'Priminto PH', NULL, 'Mirigama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('380', 'City School of Architecture', 'City school', NULL, 'City School of Architecture Limited, \n120/7, Vidya Mawatha, \nColombo 07.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('382', 'Onet Solutions ', 'ONET', NULL, 'No 840,Thalagaha Junction,\nGothatuwa New Town\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('383', 'Singhagiri Direct (Private ) L', 'Sinhagiri', NULL, 'Singhagiri Direct (Private ) Limited.\nNo. 515 ,\nDarley road ,\nColombo 10 .\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('384', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('385', 'Dr Hemantha Fernendo', 'Dr Hemantha Fernendo', NULL, 'katuneriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('386', 'Senith PH', 'Senith PH', NULL, 'Akuressa Road\nBobahagoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('387', 'Intime PH', 'Intime PH', NULL, 'Dikkubura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('388', 'Awrasa Ph', 'Awrasa Ph', NULL, 'Bombuwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('389', 'Suwamadura Ph', 'Suwamadura Ph', NULL, 'Mathugama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('390', 'Dr Janaka Marasinghe', 'Dr Janaka Marasinghe', NULL, 'Agalawaththa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('391', 'Dr Lasitha D Kannangara', 'Dr Lasitha D Kannangara', NULL, 'Warakagoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('392', 'Chamara PH', 'Chamara PH', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('393', 'Mahanama PH', 'Mahanama PH', NULL, 'No 67,\nNew Town,Lunugamwehera', NULL, NULL, NULL, NULL, NULL, '', '0'),
('394', 'Samantna PH', 'Samantna PH', NULL, 'Miriswatha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('395', 'Medi Line PH', 'Medi Line PH', NULL, 'Katugoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('396', 'Samadara PH', 'Samadara PH', NULL, 'Matthaka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('397', 'Suprem PH', 'Suprem PH', NULL, 'Meetiyagoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('398', '', '', NULL, 'Onet Solutions 		\nNo.840,  Thalagaha Junction,		\nGothatuwa New Town		\n    \n', '0115 240 247/ 0117 90 50 50		', NULL, NULL, NULL, NULL, '', '0'),
('399', 'Aloka PH', 'Aloka PH', NULL, 'Kalegane,\nGalle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('400', 'UNICOLOMBO', 'University of Colombo', NULL, 'Institute of Human Resource Advancement,\nUniversity of Colombo\n275, Bauddhaloka Mawatha,\nColombo 7.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('401', 'Dr A J P Amitha', 'Dr A J P Amitha', NULL, 'Pannegamuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('402', 'Dr Dayarathna', 'Dr Dayarathna', NULL, 'Tanamallwela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('403', 'Buttala PH', 'Buttala PH', NULL, 'Buttala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('404', 'City PH (Buttala)', 'City PH (Buttala)', NULL, 'No 03,\nBadaikumbura Road,\nButtala\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('405', 'Cash', 'Cash', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('406', 'Dr Iresha Amarasinghe', 'Dr Iresha Amarasinghe', NULL, 'Berrolibela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('407', 'Dr D Kodithuwakku', 'Dr D Kodithuwakku', NULL, 'General Hospital Hambantota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('408', 'Leo PH', 'Leo PH', NULL, 'Deberawawa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('409', 'Priya PH', 'Priya PH', NULL, 'Nagas Handiya,\nKalutara North', NULL, NULL, NULL, NULL, NULL, '', '0'),
('410', 'Omedlak PH', 'Omedlak PH', NULL, 'Aluthgama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('411', 'Vidura PH', 'Vidura PH', NULL, 'Dewlapitiya road,\nBalapana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('412', 'Green Media Partners (pvt) Ltd', 'Green Media Partners (pvt) Ltd', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('413', 'Pradeep PH', 'Pradeep PH', NULL, 'Rotuba', NULL, NULL, NULL, NULL, NULL, '', '0'),
('414', 'Mawarala PH', 'Mawarala PH', NULL, 'Mawarala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('415', 'Sadaham PH', 'Sadaham PH', NULL, 'urubokka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('416', 'Dr Chanaka Gayan', 'Dr Chanaka Gayan', NULL, 'Kirinda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('417', 'Suwana PH', 'Suwana PH', NULL, 'Katharagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('418', 'New Medical Center', 'New Medical Center', NULL, 'Udugama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('419', 'penguin', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('420', 'Rajabojun (pvt) Ltd', 'Rajabojun (pvt) Ltd', NULL, 'Mr Mishantha Masinghe,\nDirector,\nRajabojun (pvt) Ltd,\nLiberty Arcade,\nColombo 03.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('421', 'The Elanvital (Pvt) Ltd', 'The Elanvital (Pvt) Ltd', NULL, 'The Elanvital (Pvt) Ltd,\nNo28/2,\nBiyagama,\nSri Lanka', '0112487108', '0772524575', NULL, NULL, NULL, '', '0'),
('422', 'C W Mackie PLC', 'C W Mackie PLC', NULL, 'C W Mackie PLC,\nReg No PQ 47,\n36,D.R Wijewardena Mawatha,\nColombo 10', NULL, NULL, NULL, NULL, NULL, '', '0'),
('423', 'Kalany Valley Canneries Ltd', 'Kalany Valley Canneries Ltd', NULL, 'Kalany Valley Canneries Ltd,\nNo-436,\nKaluaggala,\nHanwella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('424', 'Dr Sampath', 'Dr Sampath', NULL, 'Dompe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('425', 'Gulf Coast Medical.inc', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('426', 'Shehan patherana', 'Shehan patherana', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('427', 'Manahara PH', 'Manahara PH', NULL, 'Wallawaya ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('428', 'J.H PH', 'J.H PH', NULL, 'Thnipolgaha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('429', 'SKY', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('430', 'My Store .lk', 'mystore', NULL, 'Galle Road,\nColombo 4.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('431', 'R F R  Group', 'R F R  Group', NULL, 'Dubai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('432', 'Browns Hospitals', 'Browns Hospitals', NULL, 'Ragama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('433', 'The Golden Key Credit Card Com', 'Golden Key', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('434', 'Ushan PH', 'Ushan PH', NULL, 'Dodamgoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('435', 'Abans Retail (Pvt)Ltd.', 'AbanRetail', NULL, 'Laleendra Brahmana\n498, Galle Road,\nColombo3.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('436', 'Onetma Solutions', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('437', 'Lanka Bell Ltd.', 'lankabell', NULL, 'No: 344, Galle road, Colombo 3 ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('438', 'IC Collection (PVT) Ltd', 'IC Collection (PVT) Ltd', NULL, 'No 29,\nLauries Road,\nColombo 04', NULL, NULL, NULL, NULL, NULL, '', '0'),
('439', 'New PH', 'New PH', NULL, 'Pugoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('440', 'John Keells', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('441', 'Mobitel (Pvt)Ltd.', 'mobitel', NULL, '108, W. A. D. Ramanayake Mawatha,               \nColombo 02,\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('442', 'Asoka Chanel PH', 'Asoka Chanel PH', NULL, 'Balapitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('443', 'LGL Marketing Services (PVT) L', 'LGL Marketing', NULL, '45,katukurunduwatta Road,\nRatmalana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('444', 'Dr K K S Devika', 'Dr K K S Devika', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('445', 'Bus Stand Shoping Comlex PH', 'Bus Stand Shoping Comlex PH', NULL, 'Ambalangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('446', 'Sampath Jayawardhena', 'Sampath Jayawardhena', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('447', 'City Cycle Industries', 'City Cycle Industries', NULL, 'Gall Road.\nPanadura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('448', 'Red Orchids Restaurant (Pvt) L', 'Red Orchids ', NULL, 'De Fonseka Road \nColombo 04', NULL, NULL, NULL, NULL, NULL, '', '0'),
('449', 'Nimal Chemist', 'Nimal Chemist', NULL, 'Nimal Chemist,\nNo 90,\nMain Street,\nGalle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('450', 'Dr.T Edirisinghe', 'Dr.T Edirisinghe', NULL, 'Dr.T Edirisinghe,\nPannipitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('451', 'Dr G.H.Amarasiri', 'Dr G.H.Amarasiri', NULL, 'Dr G.H.Amarasiri\nYatadola', NULL, NULL, NULL, NULL, NULL, '', '0'),
('452', 'Kahawatte Plantation', 'Kahawatte Plantation', NULL, 'Kahawatte Plantation,\nColombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('453', 'Singhagiri (Pvt) Ltd.', 'Singhagiri(Pvt)', NULL, 'Colombo\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('454', 'Feroz', 'Feroz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('455', 'Mr Danushka', 'Mr Danushka', NULL, 'Matara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('456', 'AMCOR', 'AMCOR', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('457', 'DPJ Holdings', 'DPJ Holdings', NULL, 'Nawala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('458', 'South Asia Pacific (PVT) Ltd', 'South Asia Pacific (PVT) Ltd', NULL, 'Colombo 04', NULL, NULL, NULL, NULL, NULL, '', '0'),
('460', 'MyDeal.lk (Pvt) Ltd', 'MyDeal', NULL, 'No 323,Galle Road,\nColombo 4', '0112555088', NULL, NULL, NULL, NULL, '', '0'),
('461', 'Mydeal.lk (Pvt) Ltd.', 'Mydeal.lk (Pvt) Ltd.', NULL, '323, Galle Road, Colombo 00400', '011 2 555088', NULL, NULL, NULL, NULL, '', '0'),
('462', 'M-Town', 'M-Town', NULL, 'Mattegoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('463', 'Bookkeeping-AUS', 'Bookkeeping-AUS', NULL, 'Australia', NULL, NULL, NULL, NULL, NULL, '', '0'),
('464', 'Wintech Cellular Services', 'Wintech Cellular Services', NULL, '159/1/3,\nMain Street,Colombo 11', NULL, NULL, NULL, NULL, NULL, '', '0'),
('465', 'Notrthshore College', 'Notrthshore College', NULL, '141, Church Road,\n  Colombo 15,\n  Sri Lanka.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('466', 'The High Commission of Pakista', 'The High Commission of Pakista', NULL, 'No. 42 &amp; 44, Bullers Ln,\nColombo 00700\nSri Lanka\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('467', 'Water Mart Systems', 'Water Mart', NULL, 'No 594,\nGalle Road,\nColombo 03', NULL, NULL, NULL, NULL, NULL, '', '0'),
('468', ' Smart Solutions', ' Smart Solutions', NULL, 'No 10, \nSri darmarama road,\nDematagoda,\nColombo 09', NULL, NULL, NULL, 'danushka@evolve-sl.com', NULL, '', '0'),
('469', 'ABC Computers (PVT) Ltd', 'ABC Computers ', NULL, 'No 447,\nLipton Circus, \nColombo 2', NULL, NULL, NULL, NULL, NULL, '', '0'),
('470', 'Green Aircorn (pvt) ltd', 'Green Aircorn ', NULL, 'No 12\nParakumba Place,\nColombo 06', NULL, NULL, NULL, NULL, NULL, '', '0'),
('471', 'JOHN KEELLS', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0');
INSERT INTO `0_crm_persons` VALUES
('472', 'Brantel Lanka (Pvt) Ltd', 'Brantel Lanka', NULL, 'No 06,\nR.A De Mel Mawatha,\nColombo 06', NULL, NULL, NULL, NULL, NULL, '', '0'),
('473', 'Favourite garment (PVT) Ltd', 'Favourite', NULL, 'The Landmark(level 6)', NULL, NULL, NULL, NULL, NULL, '', '0'),
('474', 'Millennium Airlines (PVT) Ltd', 'Millennium Airlines', NULL, 'Formerly Deccan Aviation Lanka,\nThe Landmark,level 06,\n385,Gall Road', NULL, NULL, NULL, NULL, NULL, '', '0'),
('475', 'Regent Plaza (PVT) Ltd', 'Regent', NULL, 'The Landmark (Level 6),\n385,Gall Road, Colombo 03', NULL, NULL, NULL, NULL, NULL, '', '0'),
('476', 'Favourite International (Pvt) ', 'Favourite International', NULL, 'The Landmark,\n385,Gall road,\nColombo 03', NULL, NULL, NULL, NULL, NULL, '', '0'),
('477', 'Mitsu Mobiles Phones', 'Mitsu Mobiles ', NULL, 'No 227,\nGalle Road,\nColombo 04', NULL, NULL, NULL, NULL, NULL, '', '0'),
('478', 'Taruja PH', 'Taruja PH', NULL, 'Galle ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('479', 'Special Task Force', 'Special Task Force', NULL, '223,\nBauddaloka Mawatha,\nColombo 07', NULL, NULL, NULL, NULL, NULL, '', '0'),
('480', 'celltronics Mega Store', 'celltronics ', NULL, '422/A\nGalle Road,\nColombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('481', 'Skills International (Pvt) Ltd', 'Skills International ', NULL, 'No 321,\nGalle Road,\nColombo 03', NULL, NULL, NULL, NULL, NULL, '', '0'),
('482', 'Flexiv Micro Systems (pvt) Ltd', 'Flexiv', NULL, '30/2,Jesmin park,\nNarahenpita Road,\nNawala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('483', 'Win Net', 'Win Net', NULL, 'Win Net, \nNugegoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('484', 'Shanbe Jeane Corporation (Pvt)', 'Shanbe', NULL, 'No 07A,\nPostmasters Place\nTemple Road\nMt Lavinia\n ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('485', 'JapanSoft', 'JapanSoft', NULL, 'No;05,\nJoseph&#039;s Street\nColombo 04\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('486', 'Vista Advertising &amp; Busine', 'Vista Advertising', NULL, 'No;33,\n14th Lane,\nColombo 03.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('487', 'VCube', 'VCube', NULL, 'No:260/5,\nGalle Road, \nColombo-04', NULL, NULL, NULL, NULL, NULL, '', '0'),
('488', 'Agaya Hldings (PVT) LTD', 'Agaya', NULL, 'Subadrarama Roas,\nNugegoda,10250,\nSri lanka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('489', 'TVS Lanka Pvt ltd', 'TVS', NULL, 'Mr. Sudagaran,\nNo:38,\nOld Negombo Road,\nWattala,\nSri Lanka.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('490', 'Laugfs Supermarket (Pvt) Ltd', 'Laugfs', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('491', 'AB Fortune Technology Services', 'AB Fortune', NULL, '5th Floor, SB Tower - 1, Sector 16, Noida\nUttar Pradesh\nINDIA - 201301\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('492', 'Fine Tech PC', 'Fine Tech PC', NULL, 'Clinipath Buliding,\nFron of Temple Tree,\nNegambo Road,\nMinuwangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('493', 'ES Computer', 'ES Computer', NULL, 'No 12,\nPrivate Bus Stand,\nMawanella.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('494', 'Isuru Celleulor', 'Isuru Celleulor', NULL, 'Kaduwela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('495', 'Fedora E-Zone Computer', 'Fedora', NULL, 'No 07,\nMarket Place,\nKegalle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('496', 'Dinuka Technologies (Pvt) Ltd', 'Dinuka Technologies', NULL, 'Delgoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('497', 'Senitro- IT (Pvt) Ltd', 'Senitro', NULL, 'Malabe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('498', 'ACP Solutions', 'ACP Solutions', NULL, 'Homagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('499', 'i a t Computers', 'i a t Computers', NULL, 'Malabe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('500', 'Yasiru Creations', 'Yasiru Creations', NULL, 'Kotikawatte', NULL, NULL, NULL, NULL, NULL, '', '0'),
('501', 'Samarasinghe Solutions (Pvt) L', 'Samarasinghe Solutions ', NULL, 'Kadawatha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('502', 'Sky Computer &amp; Entertainme', 'Sky Computer', NULL, 'Ragama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('503', 'DYNTECH Enterprises ', 'DYNTECH ', NULL, 'Waththala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('504', 'MICRO BIT Computers', 'MICRO BIT ', NULL, 'Kadawatha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('505', 'Susara Miusic &amp; Phones Rep', 'Susara Miusic &amp; Phones ', NULL, 'Nittabuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('506', 'Soft Green Technology', 'Soft Green ', NULL, 'Nittabuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('507', 'New Total Solutions', 'New Total Solutions', NULL, 'Malabe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('508', 'Mr Wijesekara', 'Mr Wijesekara', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('509', 'Dadiance Computer Systems', 'Dadiance', NULL, 'Siyabalape', NULL, NULL, NULL, NULL, NULL, '', '0'),
('510', 'Nitlan Technologies', 'Nitlan', NULL, 'Kaduwela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('511', 'SNN Technologies', 'SNN Technologies', NULL, 'Weliweriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('512', 'NJ Computers', 'NJ Computers', NULL, 'Weliweriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('513', 'Asith Computers', 'Asith Computers', NULL, 'Yakkala\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('514', 'Neoview (Pvt) Ltd', 'Neoview ', NULL, 'Yakkala\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('515', 'Rajapaksha Communication', 'Rajapaksha Communication', NULL, 'Mawanella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('516', 'E-Max Computer', 'E-Max Computer', NULL, 'Negambo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('517', 'New Seoul Trade Center', 'New Seoul Trade Center', NULL, 'Kiribathgoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('518', 'Sha Tech Zone', 'Sha Tech Zone', NULL, 'Kiribathgoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('519', 'Global Payments Asia Pacific L', 'GlobalPayments', NULL, 'Advantage Building Complex\n4th Floor, 74A Dharmapala Mawatha\nColombo 7.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('520', 'The RainTree Hotel', 'The RainTree Hotel', NULL, 'Tissamaharama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('521', 'Abans PLC', 'Abans PLC', NULL, 'Mr. Chatura Jayawardena.\nSenior Brand Manager\nAbans PLC\n4th floor, Abans Head Office, \nNo. 498, Galle Road, Colombo 3,', NULL, NULL, NULL, NULL, NULL, '', '0'),
('522', 'P &amp; T Computers', 'P &amp; T Computers', NULL, 'Batapola', NULL, NULL, NULL, NULL, NULL, '', '0'),
('523', 'NetCom Computer Services', 'Net Com', NULL, 'Minuwangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('524', 'Ruwani Computers', 'Ruwani Computers', NULL, 'Ampawila', NULL, NULL, NULL, NULL, NULL, '', '0'),
('525', 'Sisith Printers', 'Sisith Printers', NULL, 'Katharagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('526', 'A.G Computer &amp; Services', 'A.G Computer &amp; Services', NULL, 'Tissamaharama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('527', 'Mayura Phone Shop', 'Mayura Phone Shop', NULL, 'Tissamaharama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('528', 'The Asia Foundation', 'The Asia Foundation', NULL, 'No 30/1, \nBagatalle Rd,\nColombo 00300,\nSri Lanka.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('529', 'Youth Computers Technology', 'Youth Computers ', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('530', 'J &amp; D Group', 'J &amp; D Group', NULL, '17/30, \n10th Mile Post,\nKatuwawala,\nBoralesgamuwa,\nSri Lanka.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('531', 'Wheels Lanka Trading (Pvt) Ltd', 'Wheels Lanka', NULL, 'No 214,\nHigh level Road,\nKirulapone,\nColombo 06', NULL, NULL, NULL, NULL, NULL, '', '0'),
('532', 'SK International Holdings', 'SK International', NULL, 'No 115,\nHill street,\nDehiwala,\nSri Lanka.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('533', 'Global Payments Asia Pacific L', 'GlobalPayments 01', NULL, 'Advantage Building Complex\n4th Floor, 74A Dharmapala Mawatha\nColombo 7.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('534', 'Abeywarna Phones', 'Abeywarna Phones', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('535', 'Three Star', 'Three Star', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('536', 'Beyond Technologies', 'Beyond Technologies', NULL, 'Dompe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('537', 'Global Investment House Ltd.', 'GloInvestments', NULL, 'Colombo 1.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('538', 'Digital Base Holdings (Pvt) Lt', 'Digital Base Holdings', NULL, 'No 03,\nDharmaraja Mawatha,\nOff Alfred House Avenue,\nColombo 03\nSri Lanka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('539', 'Orange Computers', 'Orange Computers', NULL, 'Matugama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('540', 'P C Technologies', 'P C Technologies', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('541', 'Palliyaguru Marketing &amp; Te', 'Palliyaguru Marketing', NULL, 'Gampaha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('542', 'Shan PC Partner', 'Shan PC', NULL, 'Dodangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('543', 'Galle Net Technologies', 'Galle Net ', NULL, 'Gonamulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('544', 'IT Mart Computers', 'IT Mart ', NULL, 'Embilipitiya\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('545', 'Mega PC ', 'Mega PC ', NULL, 'Buttala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('546', 'K S Computers', 'K S Computers', NULL, 'Monaragala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('547', 'Chipra Computers', 'Chipra Computers', NULL, 'Kirindiwela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('548', 'Tecno Lanka', 'Tecno Lanka', NULL, 'Kiribathgoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('549', 'NPS IT Gallery', 'NPS IT Gallery', NULL, 'Wennappuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('550', 'Windicom Computers', 'Windicom Computers', NULL, 'Wennappuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('551', 'Green Computers', 'Green Computers', NULL, 'Marawilla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('552', 'Crest Business Computers', 'Crest Business Computers', NULL, 'Gampaha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('554', 'e-Wis', 'e-Wis', NULL, 'No 329,\nGalle Road,\nColombo 04,\nSri Lanka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('555', 'Recon Computers', 'Recon Computers', NULL, 'Dompe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('556', 'SriLucky Computers', 'SriLucky Computers', NULL, 'Nittabuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('557', 'Stylish Computers', 'Stylish Computers', NULL, 'Kochchikade', NULL, NULL, NULL, NULL, NULL, '', '0'),
('558', 'Ruwi Mobiles', 'Ruwi Mobiles', NULL, 'Kirindiwela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('559', 'Dinidu PC Solutions', 'Dinidu PC Solutions', NULL, 'Pugoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('560', 'Nara IT Solutions', 'Nara IT Solutions', NULL, 'Minuwangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('561', 'Prasad Computers', 'Prasad Computers', NULL, 'Mirigama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('562', 'Global Computers', 'Global Computers', NULL, 'Gampaha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('563', 'Way Detect Holdings', 'Way Detect Holdings', NULL, 'Kiribathgoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('564', 'Mark Computers', 'Mark Computers', NULL, 'Gannemulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('565', 'Evident Computers', 'Evident Computers', NULL, 'Kiribathgoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('566', 'Makeen Books', 'Makeen Books', NULL, 'No 441,\nGalle Road,\nColombo - 03,\nSri Lanka.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('567', 'Micro Print', 'Micro Print', NULL, 'Yakkala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('568', 'Dnet Computers', 'Dnet Computers', NULL, 'Mirigama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('569', 'Thilakarathna PC Center', 'Thilakarathna PC', NULL, 'Mirigama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('570', 'N S Technologies', 'N S Technologies', NULL, 'Pasyala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('571', 'Gate Way Computers', 'Gate Way Computers', NULL, 'Neluwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('572', 'Ranmuthu Computers', 'Ranmuthu Computers', NULL, 'Neluwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('573', 'SK Group (Pvt) Ltd', 'SK Group', NULL, 'Mathugama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('574', 'Ceylon IT Solutions', 'Ceylon IT', NULL, 'Rathgama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('575', 'Horisen Computers', 'Horisen Computers', NULL, 'Hambanthota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('576', 'B.S.K Cellular', 'B.S.K Cellular', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('577', 'V-TEC Computers', 'V-TEC Computers', NULL, 'Monaragala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('578', 'RU Salu Clothing [PVT] Ltd', 'RU Salu Clothing ', NULL, 'No:640,\nGiriulla Road,\nKandawala,\nKatana,\nSri Lanka.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('579', 'Nanotek Computer Solutions', 'Nanotek Computer Solutions', NULL, 'NO 110A,\nGalle Road, \nDehiwala,\nSri Lanka.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('580', 'P C Needs', 'P C Needs', NULL, 'Pitabadda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('581', '3p Computer Technologies', '3p Computer Technologies', NULL, 'Morawaka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('582', 'Tech Zone', 'Tech Zone', NULL, 'Pitabaddara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('583', 'Morawaka Computers', 'Morawaka Computers', NULL, 'Morawaka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('584', 'Shasika', 'Shasika', NULL, '125,\nDarmapala mawatha,\nColombo 07', NULL, NULL, NULL, NULL, NULL, '', '0'),
('585', 'Right Click Computers', 'Right Click Computers', NULL, 'Tellabuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('586', 'Click Solutions', 'Click Solutions', NULL, 'Yakkalamulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('587', 'Multi Computers &amp; Electron', 'Multi Computers ', NULL, 'Yakkalamullla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('588', 'Aruna Computers', 'Aruna Computers', NULL, 'Makumbura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('590', 'Computer Care Technology Cente', 'C C Tech', NULL, 'Deniyaya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('591', 'Venus E Cafe &amp; Solutions', 'Venus E Cafe ', NULL, 'Deniyaya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('592', 'Data World Computers', 'Data World Computers', NULL, 'Deniyaya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('593', 'P C Super Mart', 'P C Super Mart', NULL, 'Beralapanathara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('594', 'Madhura Computer Shop', 'Madhura Computer Shop', NULL, 'Pasgoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('595', 'Lakmal IT Solutions', 'Lakmal IT Solutions', NULL, 'Mawarala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('596', 'PepperCube Consultants (Pvt) L', 'PepperCube Consultant', NULL, '20/43,\nFairfield Gardens,\nColombo 08,\nSri Lanka \n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('597', 'F-Secure Corporation', '', NULL, 'Tammasaarenkatu 7,\n00180 Helsinki,\nFinland', NULL, NULL, NULL, NULL, NULL, '', '0'),
('598', 'Mr.Suren Dharmaratne', 'Suren- Australia  Bookkeeping', NULL, 'Melbourne\nAustralia', NULL, NULL, NULL, NULL, NULL, '', '0'),
('599', 'A Plus Technologies &amp; Comm', 'A Plus Technologies', NULL, 'Henegama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('600', 'Beeta Computers', 'Beeta Computers', NULL, 'Nittabuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('601', 'Shenaya Holdings', 'Shenaya Holdings', NULL, 'Mirisswaththe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('602', 'Six D Solutions', 'Six D Solutions', NULL, 'Mirigama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('603', 'Seya DVD House', 'Seya DVD House', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('604', 'sarasavi Computers', 'sarasavi Computers', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('605', 'Dimuthu Electronics', 'Dimuthu Electronics', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('606', 'Abacus Computers', 'Abacus Computers', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('607', 'Richmond Hill Computers', 'Richmond Hill Computers', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('608', 'A N Computers', 'A N Computers', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('609', 'Mekala Computers', 'Mekala Computers', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('610', 'Tilly  Computer Gadgets', 'Tilly  Computer', NULL, 'Marawilla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('611', 'Insight Technologies ', 'Insight Technologies ', NULL, 'Hikkaduwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('612', 'Eranga Computers', 'Eranga Computers', NULL, 'Uragaha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('613', 'E-Win Computers', 'E-Win Computers', NULL, 'Uragasmanhandiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('614', 'Bandara Tecchnologies', 'Bandara Tecchnologies', NULL, 'Karandeniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('615', 'A &amp; G Technologies ', 'A &amp; G Technologies ', NULL, 'Tangalle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('616', 'Cell World', 'Cell World', NULL, 'Aluthgama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('617', 'RM Holdings (PVT) Ltd', 'RM Holdings', NULL, 'No 34,\nMendis Mawatha, \nNegombo,\nSri Lanka.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('618', 'R-CIS ', 'R-CIS ', NULL, 'Tissamaharama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('619', 'Boralessa Technologies', 'Boralessa Technologies', NULL, 'Monaragala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('620', 'United Computers', 'United Computers', NULL, 'Puhulkotuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('621', 'Danuka Celluler &amp; Computer', 'Danuka Celluler &amp; Computers', NULL, 'Ahangama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('622', 'Visual Computers', 'Visual Computers', NULL, 'Habaraduwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('623', 'Senara Technologies', 'Senara Technologies', NULL, 'Bogahagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('624', 'IDEAL Technologies', 'IDEAL Technologies', NULL, 'Naiwela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('625', 'Comtec Computers', 'Comtec Computers', NULL, 'Kandana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('626', 'K-Tech Trading', 'K-Tech Trading', NULL, 'Kandana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('627', 'AMA Games', 'AMA Games', NULL, 'Kandana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('628', 'Micro Sis', 'Micro Sis', NULL, 'Ja-Ela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('629', 'Araliya Computers', 'Araliya Computers', NULL, 'Weligama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('630', 'CCTV Lanaka (PVT) Ltd', 'CCTV Lanaka', NULL, 'No 629 1/1,\nYanthampalawa,\nKurunegala.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('631', 'Wislan Apparel', 'Wislan Apparel', NULL, 'No 93/2,\nPitawala Waththa,\nGampola Road,\nGelioya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('632', 'Macstore', 'Macstore', NULL, '3rd floor,\nMajestic City, \nColombo 04.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('633', 'EasyAds (Pvt) Ltd', 'EasyAds', NULL, 'No 225-A-2,\nIhala Karagahamuna,\nKadawatha,\nSri Lanka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('634', 'Nicstop Computer', 'Nicstop Computer', NULL, 'Kegalle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('635', 'Micro World', 'Micro World', NULL, 'Kaluthara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('636', 'Uni Tech PC', 'Uni Tech PC', NULL, 'Baduruliya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('637', 'One IT, Australia', 'oneITAUS', NULL, 'Australia', NULL, NULL, NULL, NULL, NULL, '', '0'),
('638', 'E-Mas Computers', 'E-Mas Computers', NULL, 'Negambo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('639', 'Z Mesenger (Pvt) Ltd', 'Z Mesenger ', NULL, 'No 121,\nHunupitiya Lake Road,\nColombo 02,\nSri Lanka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('640', 'Sumithra Garments ( Pte ) Ltd', 'Sumithra Garments', NULL, 'No 33,\nThelangapatha Road,\nWattala,\nSri Lanka.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('641', 'Chandrasiri Communications', 'Chandrasiri Communications', NULL, 'Katharagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('642', 'P C Tech Computer system', 'P C Tech Computer system', NULL, 'Embilipitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('643', 'RD Computer Services (Pvt) Ltd', 'RD Computer Services', NULL, 'Minuwangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('644', 'Game Soft', 'Game Soft', NULL, 'Ganemulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('645', 'ComNet Computers', 'ComNet Computers', NULL, 'Gannemulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('646', 'PC Friends', 'PC Friends', NULL, 'Nittambuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('647', 'Soft Bios Technology', 'Soft Bios', NULL, 'Aluthwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('648', 'Infortec Computers', 'Infortec Computers', NULL, 'Hikkaduwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('649', 'Xenon Computers', 'Xenon Computers', NULL, 'Elpitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('650', 'Gamage Computers', 'Gamage Computers', NULL, 'Tissamaharama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('651', 'Hiru Computers', 'Hiru Computers', NULL, 'Badalkumbura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('652', 'Real Tec', 'Real Tec', NULL, 'Wellawaya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('653', 'Silverline Information Technol', 'Silverline', NULL, 'No 85, \nDr.N.M.Perera Mawatha,\nColombo 08, \nSri Lanka.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('654', 'American College of Higher Edu', 'American College', NULL, 'No: 23,\nHospital Road,\nDehiwala\nSri Lanka.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('655', 'Mr. Ganeshan Prabakaran', 'Mr. Prabakaran', NULL, 'No 155/176,\nKalmunai,\nSri Lanka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('656', 'Ceylon Business Appliances (Pv', 'CBA', NULL, 'No 112,\nReid Avenue,\nColombo - 04,\nSri Lanka.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('657', 'Old Joes Sports Club', 'Old Joes Sports Club', NULL, 'T.B Jaya Mawatha,\nColombo 10,\nSri Lanka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('658', 'E-Net Computers', 'E-Net Computers', NULL, 'Kadawatha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('659', 'Super Unique', 'Super Unique', NULL, 'Negambo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('660', 'Best Computers', 'Best Computers', NULL, 'Wennappuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('661', 'Infonee', 'Infonee', NULL, 'Kaluthara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('662', 'N Gadgets', 'N Gadgets', NULL, 'Baduraliya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('663', 'Dragon Computer Services', 'Dragon Computer Services', NULL, 'Aluthgama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('664', 'P C World', 'P C World', NULL, 'Aluthgama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('665', 'PC &amp; Network Technologies', 'PC &amp; Network', NULL, 'Minuwangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('666', 'Nilan Computers', 'Nilan Computers', NULL, 'Ragama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('667', 'Vihanga Technologies', 'Vihanga Technologies', NULL, 'Malabe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('668', 'Abans', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('669', 'Golden Way Computers', 'Golden Way', NULL, 'Urubokka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('670', 'Okrich Computers', 'Okrich Computers', NULL, 'Middeniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('671', 'S J Computers', 'S J Computers', NULL, 'Embilipitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('672', 'BC Agro-Tronics (Pvt) Limited', 'BC Agro-Tronics ', NULL, 'Mr. Mark Allen Dirckze\nBC Agro-Tronics (Pvt) Limited\nNo 211/10,\nVeluwana Place,\nColombo 09.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('673', 'Central Industries PLC', 'Central Industries', NULL, 'No:312\nNawala Rd,\nSri Jayawardenepura Kotte 10107,\nSri Lanka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('674', 'W.I. Tel Solutions (pvt) Ltd', 'W.I. Tel Solutions ', NULL, 'A: 27-1/3,\nYork Arcade Building,\nLayden Bastian Road,\nColombo 01\nSri Lanka.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('675', 'Best Way Computers', 'Best Way', NULL, 'Kiribathgoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('676', 'Office Station', 'Office Station', NULL, 'Ja-Ela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('677', 'M.C Computers', 'M.C Computers', NULL, 'Wennappuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('678', 'Galaxy Technologies', 'Galaxy Technologies', NULL, 'Hikkaduwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('679', 'K L Computers', 'K L Computers', NULL, 'Panadura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('680', 'G.M.S.Lanka Computers', 'G.M.S.Lanka', NULL, 'Induruwa Road ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('681', 'Abeyrathne Computers', 'Abeyrathne Computers', NULL, 'Induruwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('682', 'Tecno Computers', 'Tecno Computers', NULL, 'Baduraliya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('683', 'NMN Computers', 'NMN Computers', NULL, 'Urubokka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('684', 'E-Rats Technologies', 'E-Rats ', NULL, 'Mawanella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('685', 'Peshala Computers', 'Peshala Computers', NULL, 'Dilulapitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('686', 'N &amp; N Computers', 'N &amp; N Computers', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('687', 'Max Computers', 'Max Computers', NULL, 'Bus Stand-Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('688', 'S.P Mobile &amp; Computers', 'S.P Mobile &amp; Computers', NULL, 'Bus Stand Road,\nRathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('689', 'Apple Computer &amp; Mobile', 'Apple Computer &amp; Mobile', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('690', 'PC Net Computer Home', 'PC Net Computer Home', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('691', 'Computer Home', 'Computer Home', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('692', 'MicroNet Computers', 'MicroNet Computers', NULL, 'Main Street,\nRathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('693', 'PREB Computers', 'PREB Computers', NULL, 'Kuruwita', NULL, NULL, NULL, NULL, NULL, '', '0'),
('694', 'Razan Samsung Mobile', 'Razan Samsung Mobile', NULL, 'Kuruwita', NULL, NULL, NULL, NULL, NULL, '', '0'),
('695', 'SeaCom International', 'SeaCom International', NULL, 'Kuruwita', NULL, NULL, NULL, NULL, NULL, '', '0'),
('696', 'Eshantha Computer &amp; Cellul', 'Eshantha Computer &amp; Cellular', NULL, 'Parakaduwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('697', '777 Phone Arcade', '777 Phone Arcade', NULL, 'Ehaliyagoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('698', 'Sharp Computers', 'Sharp Computers', NULL, 'Eheliyagoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('699', 'Imaya Computers', 'Imaya Computers', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('700', 'Micro System Technologies ', 'Micro System Technologies ', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('701', 'Win Max Computer &amp; Technol', 'Win Max Computer', NULL, 'Awissawella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('702', 'E Mart Computers', 'E Mart Computers', NULL, 'Kahawatta', NULL, NULL, NULL, NULL, NULL, '', '0'),
('703', 'Swarna Communication', 'Swarna Communication', NULL, 'Kahawatta', NULL, NULL, NULL, NULL, NULL, '', '0'),
('704', 'Chandrika Mobiles', 'Chandrika Mobiles', NULL, 'Kahawatta', NULL, NULL, NULL, NULL, NULL, '', '0'),
('705', 'Susil Computer System', 'Susil Computer System', NULL, 'Kahawatte', NULL, NULL, NULL, NULL, NULL, '', '0'),
('706', 'I Com', 'I Com', NULL, 'Eheliyagoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('707', 'Smart Mobile', 'Smart Mobile', NULL, 'Eheliyagoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('709', 'Capital Lands (Pvt) Ltd', 'Capital Lands (Pvt) Ltd', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('710', 'Galle Com Zone', 'Galle Com Zone', NULL, 'Wanduramba', NULL, NULL, NULL, NULL, NULL, '', '0'),
('711', 'LandMark Computers', 'LandMark Computers', NULL, 'Pitigala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('712', 'Ru Sanda Ras Computers', 'Ru Sanda Ras Computers', NULL, 'Palawaththe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('713', 'Micro City ', 'Micro City ', NULL, 'Kaluthara-South', NULL, NULL, NULL, NULL, NULL, '', '0'),
('714', 'Thakshila Computers', 'Thakshila Computers', NULL, 'Nahalla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('715', 'W.A Computers', 'W.A Computers', NULL, 'Horana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('716', 'The IT Park', 'The IT Park', NULL, 'Kaluthara-South', NULL, NULL, NULL, NULL, NULL, '', '0'),
('717', 'Seven Star Enterprices', 'Seven Star Enterprices', NULL, 'No 317/D\nOld Kottawa Road,\nEmbuldeniya,\nNugegoda.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('718', 'MITECH Computer Systems (Pvt) ', 'MI Tech', NULL, 'No 106,\nLower Ground Floor,\nUnity Plaza,\nColombo 04', NULL, NULL, NULL, NULL, NULL, '', '0'),
('719', 'Hiru.Com &amp; Phone Shop', 'Hiru.Com &amp; Phone Shop', NULL, 'Pasgoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('720', 'Omega Computers', 'Omega Computers', NULL, 'Pitigala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('721', 'My Way Computers', 'My Way Computers', NULL, 'Kirindiwela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('722', 'Sky Computers (Pvt) Ltd', 'Sky Computers (Pvt) Ltd', NULL, 'Mr.Roshan Fernando\nSt.Joeph?s Street,\nnegombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('723', 'Max Pac (Pvt) Ltd', 'Max Pac (Pvt) Ltd', NULL, '1st Cross Street,\nPettah', NULL, NULL, NULL, NULL, NULL, '', '0'),
('724', 'Finlays Cold Storage (Pvt) Lim', 'Finlays Cold Storage', NULL, 'No 309/7,\nNegambo Road,\nWelisara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('725', 'Edulink International (Pvt) Lt', 'Edulink', NULL, 'No 498,\nDe Mel Mawatha,\nColombo 03,\nSri Lanka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('726', 'PC Net Technologies', 'PC Net Technologies', NULL, 'Kollupitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('727', 'Newgen Technologies', 'Newgen Technologies', NULL, 'Dankotuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('728', 'Max Computers (Pvt) Ltd', 'Max Computers (Pvt) Ltd', NULL, 'Naththandiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('729', 'Mr Dilan Fernando', 'Mr Dilan Fernando', NULL, 'NO 284B 1/1,\nBandaranayake Mawatha,\nKatubedda,\nMoratuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('730', 'E Plus (Pvt) Ltd', 'E Plus (Pvt) Ltd', NULL, 'Mr Keerthi Jayakody\nNo L2-47,\nRealty Plaza,\nJa-Ela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('731', 'I Max Computers', 'I Max Computers', NULL, 'Badulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('732', 'Creatives Computers (Pvt) Ltd', 'Creatives Computers', NULL, 'Kuliyapitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('733', 'Inova IT Systems (Pvt) Ltd', 'Inova IT', NULL, 'No 5,\nSulaiman Terrace, \nColombo 5\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('734', 'P.C.S. Technologies', 'P.C.S. Technologies', NULL, 'Baddalkubura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('735', 'PC House', 'PC House', NULL, 'Unity Plaza', NULL, NULL, NULL, NULL, NULL, '', '0'),
('736', 'Ramya Communications', 'Ramya Communications', NULL, 'Badulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('737', 'Sybrain Computer Systems', 'Sybrain Computer', NULL, 'Badulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('738', 'Computer City', 'Computer City', NULL, 'Bandarawela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('739', 'Horizon College International', 'Horizon College', NULL, 'Millenium Drive,\nChandrika Kumarathunga Mawatha,\nMalabe,\nSri Lanka.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('740', 'Rovinta Electronics', 'Rovinta Electronics', NULL, 'Kiribathgoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('741', 'IML Private Limited (UPS)', 'IML Private Limited ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('742', 'H L De Mel &amp; Company (Pvt)', 'H L De Mel ', NULL, 'De Mel Building,\nNo 103,\nChatham Street,\nColombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('743', 'Seven Computers', 'Seven Computers', NULL, 'Kottawa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('744', 'DOS Computers', 'DOS Computers', NULL, 'No 77/1,\nKandy road,\nwarakapola', NULL, NULL, NULL, NULL, NULL, '', '0'),
('745', 'Do Max Computers', 'Do Max Computers', NULL, 'Kalawana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('746', 'Phone House', 'Phone House', NULL, 'Kalawana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('747', 'Like Computer House', 'Like Computer', NULL, 'Ehaliyagoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('748', 'Niranjan Networks', 'Niranjan Networks', NULL, 'Badulla ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('749', 'Herath Technicians', 'Herath Technicians', NULL, 'Bandarawela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('750', 'GIGAMAXZ Computers', 'GIGAMAXZ Computers', NULL, 'Bandarawela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('751', 'Star Net Computers', 'Star Net Computers', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('752', 'Kingston computer technology', 'Kingston computers', NULL, 'Horana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('753', 'Universal CAL-Computers', 'Universal Computers', NULL, 'Dodangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('754', 'New Gen Technologies', 'New Gen ', NULL, 'Mr Suresh,\nNattandiya Road,\nDankotuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('755', 'MEGA Computers', 'MEGA Computers', NULL, 'Tissamaharama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('756', 'NC Computers', 'NC Computers', NULL, 'Ahangama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('757', 'Lahiru Computers', 'Lahiru Computers', NULL, 'Neluwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('758', 'Pentech Technologies', 'Pentech', NULL, 'Neluwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('759', 'DSIT House', 'DSIT House', NULL, 'Negambo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('760', 'Matrix Technologies', 'Matrix Technologies', NULL, 'Weliweriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('761', 'P.C House ', 'P.C House ', NULL, 'Hanwella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('762', 'Dimuthu PC Solutions', 'Dimuthu PC Solutions', NULL, 'Kosgama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('763', 'G.M Mobile &amp; Computers', 'G.M Mobile &amp; Computers', NULL, 'Koagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('764', 'Venus Mobile', 'Venus Mobile', NULL, 'Eheliyagoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('765', 'PERCY Studio', 'PERCY Studio', NULL, 'Kuruwita', NULL, NULL, NULL, NULL, NULL, '', '0'),
('766', 'Chandana Studio', 'Chandana Studio', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('767', 'Multi Technologies', 'Multi Technologies', NULL, 'Baduraliya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('768', 'NARA', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('769', 'Visual Net Solution', 'Visual Net Solution', NULL, 'Kandy', NULL, NULL, NULL, NULL, NULL, '', '0'),
('770', 'Computerage (Pvt) Ltd', 'Computerage', NULL, 'Kandy', NULL, NULL, NULL, NULL, NULL, '', '0'),
('771', 'Modern Computer Systems', 'Modern Computer', NULL, 'Wattala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('772', 'SAIO', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('773', 'Talent Computer Systems', 'Talent Computer', NULL, 'Kadawatha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('774', 'Chani Computer Institute', 'Chani Computer Institute', NULL, 'Hali ella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('775', 'Arcit Cxee', 'Arcit Cxee', NULL, 'Bandarawela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('776', 'Infofix', 'Infofix', NULL, 'Bandarawela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('777', 'Falcon Degital Video', 'Falcon Degital Video', NULL, 'Bandarawela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('778', 'Win Tel Mobile Center', 'Win Tel Mobile Center', NULL, 'Balangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('779', 'New Phone House', 'New Phone House', NULL, 'Balangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('780', 'DM Computers', 'DM Computers', NULL, 'Balangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('781', 'Mellow Computers', 'Mellow Computers', NULL, 'Balangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('782', 'Feel Computers', 'Feel Computers', NULL, 'Balangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('783', 'Mega Phone House &amp; Communi', 'Mega Phone House &amp; Communicati', NULL, 'Balangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('784', 'Uni Tec Computers', 'Uni Tec Computers', NULL, 'Avissawella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('785', 'IWRM', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('786', 'Everlight Chemicals (Prt)Ltd', 'Everlight ', NULL, 'Mr. Asif,\nEverlight Chemicals (Prt)Ltd,\n638, High Level Road,\nNugegoda,\nSri Lanka.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('787', 'Sinara Cellular', 'Sinara Cellular', NULL, 'Ratnapura ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('788', 'Thuhansa Mobile', 'Thuhansa Mobile', NULL, 'Ratnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('789', 'Smart Mobile ( Ratnapura)', 'Smart Mobile ( Ratnapura)', NULL, 'Ratnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('790', 'Jayamee Phonekade', 'Jayamee Phonekade', NULL, 'Ratnapura ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('791', 'AG Computors- Ampara', 'AG Computors- Ampara', NULL, 'Regal Junction \nAmpara', '0772777329', NULL, NULL, NULL, NULL, '', '0'),
('792', 'Dammika Computers', 'Dammika Computers', NULL, 'Main Street,\nThanamalvila', NULL, NULL, NULL, NULL, NULL, '', '0'),
('793', 'S P C CONSULTANTS (PRIVATE) LI', 'SPC', NULL, 'No: 69/04,\nJayarathna Mawatha,\nThimbirigasyaya,\nColombo 05.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('794', 'Sugarcan Research Institute', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('795', 'Content Management and Solutio', 'CMS', NULL, 'Level 10,\nAccess Tower,\n278,\nUnion Place,\nColombo 02.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('796', 'City Mobile', 'City Mobile', NULL, 'palmadulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('797', 'St.Joseph&#039;s College', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('798', 'Max D Computers', 'Max D Computers', NULL, 'Ampara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('799', 'Nandana Computers', 'Nandana Computers', NULL, 'Palawaththa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('800', 'PC Software', 'PC Software', NULL, 'Mathugama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('801', 'Sri Lanka Navy Head Quarters', 'Sri Lanka Navy', NULL, 'Sri Lanka  Navy Headquarters\nP O Box 593,\nColombo 01', NULL, NULL, NULL, NULL, NULL, '', '0'),
('802', 'CS Computers', 'CS Computers', NULL, 'Akuressa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('803', 'Softlogic Phone Centre ', 'Softlogic Phone Centre ', NULL, 'Softlogic Phone Centre \nMr.Kaushal\nLiberty Showroom.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('804', 'U Computers ', 'U Computers ', NULL, 'Mr.Ishan Ravindra\nPitakotte. ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('805', 'Dinuka Cellulers &amp; Compute', 'Dinuka Cellulers &amp; Computers', NULL, 'Ahangama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('806', 'Trrident Corporation (PVT) Ltd', 'Trrident ', NULL, 'No 297, 1st floor,\nUnion Place,Colombo 02,\nSri Lankan', NULL, NULL, NULL, NULL, NULL, '', '0'),
('807', 'Thakral One (PVT) Ltd', 'Thakral', NULL, 'No 297, \n1 st floor,\nUnion Place ,\nColombo 02,\nSri Lankan', NULL, NULL, NULL, NULL, NULL, '', '0'),
('808', 'Futureworld lanka (Pvt) Ltd', 'Futureworld', NULL, '#02,\nR.A.De Mel Mawatha,\nColombo 05,\nSri lanka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('809', 'Vipula Computers', 'Vipula Computers', NULL, 'Horana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('810', 'SuhaS Computers &amp; Mobile', 'SuhaS Computers', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('811', 'M &amp; N Computers', 'M &amp; N Computers', NULL, 'Piliyandala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('812', 'Intelnet Computers', 'Intelnet Computers', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('813', 'E-Spring Technologies', 'E-Spring ', NULL, 'Negambo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('814', 'E Plus Computers', 'E Plus', NULL, 'Negambo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('815', 'Nil Nethu Computers', 'Nil Nethu', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('816', 'Max Mo Computers', 'Max Mo', NULL, 'Chilaw', NULL, NULL, NULL, NULL, NULL, '', '0'),
('817', 'Smart IT', 'Smart IT', NULL, 'Ja-Ela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('818', 'NeoN Computers (Pvt) Ltd', 'NeoN Computers ', NULL, 'Embilipitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('819', 'Zaak Enterprises', 'Zaak Enterprises', NULL, 'No 147,\nMain Street,\nAnuradhapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('820', 'Tech Tool', 'Tech Tool', NULL, 'no 561/B/14 \nN S B Road,\nNew bus Stand,\nAnuradhapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('821', 'Power PC (Pvt) Ltd', 'Power PC ', NULL, 'Anuradhapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('822', 'S J Computers (Anuradhapura)', 'S J Computers (Anuradhapura)', NULL, 'Anuradhapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('823', 'Build PC (Pvt) Ltd', 'Build PC ', NULL, 'Kurunegala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('824', 'GCT computer (Pvt) Ltd', 'GCT computer', NULL, 'Kurunegala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('825', 'Y Entertainment (Pvt) Ltd', 'Y Entertainment', NULL, 'Kurunegala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('826', 'Seoul Trading', 'Seoul Trading', NULL, 'Malabe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('827', 'AJ Medichem International (Pvt', 'AJ Medichem', NULL, 'No 50, \nAlbion Lane\nColombo 00900,\nSri Lanka.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('828', 'M.N.Computers', 'M.N.Computers', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('829', 'Malinda Computerss', 'Malinda Computerss', NULL, 'Anguruwathota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('830', 'Rasika Computers', 'Rasika Computers', NULL, 'Horana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('831', 'Extreme Computers', 'Extreme', NULL, 'Hatton', NULL, NULL, NULL, NULL, NULL, '', '0'),
('832', 'P N D Mobile', 'P N D Mobile', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('833', 'MLF Technologies', 'MLF Technologies', NULL, 'Welisara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('835', 'Ceylon Trading Company Limited', 'Ceylon Trading', NULL, 'The Accountant,\np.O.box 161,\nNo 36,\nD.R.Wijewardena Mawatha,\nColombo 10', NULL, NULL, NULL, NULL, NULL, '', '0'),
('836', 'Softlogic ', '', NULL, 'Mr Dinith Kurukulasuriya,\nNo 14\n2nd Floor,\nDe Fonseka Place,\nColombo 05', NULL, NULL, NULL, NULL, NULL, '', '0'),
('837', 'T.N Computers', 'T.N Computers', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('838', 'Swiss Hotel &amp; Queens Hotel', 'Swiss Hotel', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('839', 'Child Eye Hospital', 'Child Eye', NULL, 'Rajagiriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('840', 'Modeena Computers', 'Modeena', NULL, 'Giriulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('841', 'Soft Land PC', 'Soft Land PC', NULL, 'Maharagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('842', 'Tech Solutions', 'Tech Solutions', NULL, 'Maharagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('843', 'Computer Super Store', 'Computer Super Store', NULL, 'Giriulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('844', '3C Technologies', '3C Technologies', NULL, 'Malabe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('845', 'GIT Computers', 'GIT Computers', NULL, 'Poddiwela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('846', 'J And G Computers', 'J And G Computers', NULL, 'Deniyaya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('847', 'Sunquick Lanka (Pvt) Ltd', 'Sunquick Lanka', NULL, 'No 36,\nD R Wijewardena Mawatha,\nColombo 10', NULL, NULL, NULL, NULL, NULL, '', '0'),
('848', 'Sahara Computers', 'Sahara Computers', NULL, 'Elpitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('849', 'D.G.Constructions (Pvt) Ltd', 'D.G.Constructions', NULL, 'Naboda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('850', 'Asia Mobile Network', 'Asia Mobile', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('851', 'Horizon Campus', 'Horizon Campus', NULL, 'No 482/B,\nMillennium Drive,\nChandrika Kumarathunga Mawatha,\nMalabe.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('852', 'Universal PC Systems', 'Universal PC', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('853', 'Apalo Computers', 'Apalo Computers', NULL, 'Tangalle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('854', 'Abeysekara Cellulars', 'Abeysekara Cellulars', NULL, 'Yatiyana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('855', 'e-Shop Computers', 'e-Shop Computers', NULL, 'Angunakolapalessa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('856', 'Infinity Solutions', 'Infinity Solutions', NULL, 'Kandy', NULL, NULL, NULL, NULL, NULL, '', '0'),
('857', 'EPG Technologies', 'EPG Technologies', NULL, 'Dehiwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('858', 'EIM Tech Networks', 'EIM Tech', NULL, 'Colombo 05', NULL, NULL, NULL, NULL, NULL, '', '0'),
('859', 'Friendly Computers', 'Friendly Computers', NULL, 'Rajagiriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('860', 'Nesh.lk', 'Nesh.lk', NULL, 'Colombo 04', NULL, NULL, NULL, NULL, NULL, '', '0'),
('861', 'T S Technologies (Pvt) Ltd.', 'T S Technologies', NULL, 'No.4 A 1/1,Dabare Mawatha,\nColombo 05.\nSri Lanka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('862', 'E-Link ', 'E-Link Solutions', NULL, 'Ambalangoda Road,\nElpitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('863', 'Creative Systems', 'D N Creative Systems', NULL, 'Wattala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('864', 'Smart Tech Computers', 'Smart Tech Computers', NULL, 'Hendala Road,\nWattala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('865', 'Riytec Computers', 'Riytec Computers', NULL, 'Chilaw', NULL, NULL, NULL, NULL, NULL, '', '0'),
('866', 'Cell Net', 'Cell Net Cellular', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('867', 'Adithya Cellular', 'Adithya Cellular', NULL, 'Bus Stand,\nRathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('868', 'DCT computers', 'DCT computers', NULL, 'Mr chaminda samarasinghe\nNO. 1/B Ground Floor,\nWelikada Plaza,\nRajagiriya.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('869', 'Riya Enterprises', 'Riya Enterprises', NULL, 'No. 12 B1,\nK.K.Street,\nPuttalam.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('870', 'Sri Lanka Savings Bank', 'SLS Bank', NULL, 'Senior Manager\nNo 265,\nWard Place,\nColombo 07', NULL, NULL, NULL, NULL, NULL, '', '0'),
('871', 'Systech solutions', 'Systech solutions', NULL, 'No 16/1/1\nOld Kottawa road, \nMirihana,\nNugegoda\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('872', 'Synergy Tech', 'Synergy Tech', NULL, 'Mr Rohana Perera\nNO 116/A,\nStanley Thilkarathne Mawatha, \nNugegoda.\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('873', 'DSL Computers', 'DSL Computers', NULL, 'No 155 D,\nHighlevel Road,\nMaharagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('874', 'Netcore ', 'Netcore solutions', NULL, 'Maharagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('875', 'Bright Computers', 'Bright Computers', NULL, 'Kandy', NULL, NULL, NULL, NULL, NULL, '', '0'),
('876', 'Power Link', 'Power Link Computers', NULL, 'Kandy', NULL, NULL, NULL, NULL, NULL, '', '0'),
('877', 'IPK Computers', 'IPK Computers', NULL, 'Beliatta', NULL, NULL, NULL, NULL, NULL, '', '0'),
('878', 'HI-Tec', 'HI-Tec Computers', NULL, 'Sooriyawewa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('879', 'Galle Computers', 'Galle Computers', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('880', 'South Net ', 'South Net Computers', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('881', 'Globe ', 'Globe international', NULL, 'Kaduruwela,\npolonnaruwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('882', 'A &amp; M Computers', 'A &amp; M Computers &amp; Technologies', NULL, 'Gallella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('883', 'AIM Tech', 'AIM Tech', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('884', 'Orient ', 'Orient Computers', NULL, 'No 626/A,\nPeradeniya Road,\nKandy', NULL, NULL, NULL, NULL, NULL, '', '0'),
('885', 'Data E Net', 'Data E Net Computer System (Pvt) Ltd', NULL, 'No 264,\nPeradeniya Road,\nKandy', NULL, NULL, NULL, NULL, NULL, '', '0'),
('886', 'PC Home-Kandy', 'PC Home Computer System', NULL, 'D S Senanayake Street,Kandy', NULL, NULL, NULL, NULL, NULL, '', '0'),
('887', 'May D-Darshana', 'May D Computers', NULL, 'No 09,\n4th Lane,\nAmpara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('888', 'Encription IT', 'Encription IT', NULL, 'Bandaragama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('889', 'Future Shop', 'Future Shop', NULL, 'Union Place', NULL, NULL, NULL, NULL, NULL, '', '0'),
('890', 'Hyper', 'Hyper', NULL, 'Moratuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('891', 'PC Doctor', 'PC Doctor', NULL, 'Baththaramulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('892', 'Tech', 'Tech', NULL, 'Baththaramulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('893', 'Future Shop-Primal', 'Future Shop-Primal', NULL, 'Kandana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('894', 'Future Shop-Wattala', 'Future Shop-Wattala', NULL, 'Wattala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('895', 'IFix Computers', 'IFix Computers', NULL, 'Nittabuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('896', 'Inter Web Computers', 'Inter Web Computers', NULL, 'Minuwangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('897', 'PC Life ', 'PC Life Solutions', NULL, 'Divulapitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('898', 'Menaka Computers', 'Menaka Computers', NULL, 'Beliaththa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('899', 'One Stop Computers', 'One Stop Computers', NULL, 'Tissamaharama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('900', 'Dot Net ', 'Dot Net Computers', NULL, 'Agalawaththa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('901', 'Perovin Computers', 'Perovin Computers', NULL, 'Mathugama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('902', 'A Plus Computers', 'A Plus Computers', NULL, 'Matara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('903', 'Sha Mobile', 'Sha Mobile', NULL, 'No 83,New Shopping Complex,\nPellmadulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('904', 'Micro Solutions', 'Micro Solutions', NULL, 'No 63,\ncanel road\nPuliyankulama\nAnuradhapura\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('905', 'My computer', 'My computer technologies', NULL, 'No 43/A \nBodiraja Mawatha\nKurunegala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('906', 'ShareColombo ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('907', 'Office Shop', 'The Office Shop (Pvt) Ltd', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('908', 'Power Tec', 'Power Tec Computers', NULL, 'Walasmulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('909', 'Sunquick', 'Sunquick Lanka (Pvt) Ltd.', NULL, 'Rathnapura Road,\nMunagama,\nHorana,\nSri Lanka\n', '94 34 2263822', NULL, '94 34 2263576', NULL, NULL, '', '0'),
('910', 'P.C.Palace', 'P.C.Palace', NULL, 'Horana', NULL, NULL, NULL, NULL, NULL, '', '0');
INSERT INTO `0_crm_persons` VALUES
('911', 'Smart Tech-Morawaka', 'Smart Tech-Morawaka', NULL, 'Morawaka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('912', 'Sonash Cellular', 'Sonash Cellular &amp; CD House', NULL, 'Kotapola', NULL, NULL, NULL, NULL, NULL, '', '0'),
('913', 'Geotech Computers', 'Geotech Computers', NULL, 'Wanduramba', NULL, NULL, NULL, NULL, NULL, '', '0'),
('914', 'Pitigala Computers', 'Pitigala Computers', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('915', 'Diyatha Lanka', 'Diyatha Lanka Computers', NULL, 'Panadura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('916', 'The D Tech', 'The D Tech Computers', NULL, 'Pallebedda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('917', 'Sagara Mobile &amp; Computer', 'Sagara Mobile &amp; Computer World', NULL, 'Embilipitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('918', 'H D K IT', 'H D K IT (Pvt) Ltd', NULL, 'Embilipitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('919', 'DCS Computers', 'DCS Computers', NULL, 'NSB Road,\nNew Town,\nAnuradhapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('920', 'SK Computers-Kuliyapitiya', 'SK Computers', NULL, 'Kuliyapitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('921', 'expense', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('922', 'Onetma', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('923', 'Micro business', 'Micro business solutions', NULL, 'Puliyankulam,\nAnuradhapura ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('924', 'Adam Inovations Co; Ltd', 'adam-i', NULL, '105-0004\nLevel 4, Shimbashi Annex Bld, 5-35-10, Shimbashi, Minato-ku,\nTokyo 105-0004 JAPAN', ' 03-5530-8947 ', NULL, NULL, 'kw@adam-i.jp', NULL, '', '0'),
('925', 'Phone Expert', 'Phone Expert', NULL, 'Kegalle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('926', 'S S S Phone Shop', 'S S S Phone Shop', NULL, 'Weerakatiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('927', 'Indika computers', 'Indika computers', NULL, 'Weerakatiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('928', 'Supreem Computers', 'Supreem Computers', NULL, 'Hokandara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('929', 'C S Electronics', 'C S Electronics', NULL, 'Walasmulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('930', 'Laptronics', 'Laptronics Lanka', NULL, 'Galle Road,\nColombo 04', NULL, NULL, NULL, NULL, NULL, '', '0'),
('931', 'Future Shop-Kosala', 'Future Shop-Kosala', NULL, 'Biyagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('932', 'C &amp; J Computers', 'C &amp; J Computers', NULL, 'Embilipitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('933', 'Uditha Enterprices', 'Uditha Enterprices', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('934', 'K iss Technologies', 'K iss Technologies', NULL, 'Pelmadulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('935', 'SNC Computer &amp; Commiunicat', 'SNC Computer &amp; Commiunication', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('936', 'Final Solution', 'Final Solution Technologies', NULL, 'Delgoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('937', 'Hansa Technologies', 'Hansa Technologies', NULL, 'Gampaha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('938', 'E-Max Computers-Darga Town', 'E-Max Computers-Darga Town', NULL, 'Darga Town', NULL, NULL, NULL, NULL, NULL, '', '0'),
('939', 'Shirtworks ', 'Shirtworks (Pvt) Ltd', NULL, 'No 104/4,\nDehiwala Road,\nMaharagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('940', 'East Asian International', 'East Asian International (Pvt) Ltd', NULL, 'No 36/3,\nWoodland Avenue,\nKohuwala,Nugegoda,\nSri Lanka', '0112854838', '0778982620', NULL, NULL, NULL, '', '0'),
('941', 'Access Natural ', 'Access Natural Water (Pvt) Ltd', NULL, 'No 775/1\nM.D.H.Jayawardana Mw,\nRajagiriya', '0114333222', NULL, '0112867277', 'info@aquafresh.lk', NULL, '', '0'),
('942', 'VOLLKART', 'VOLLKART PVT LTD', NULL, 'Mohamed Azmeel\nVollKart\n[Street Address]\nMale&#039; , Maldives\n\n', 'Phone: (960) 968-0010', NULL, NULL, NULL, NULL, '', '0'),
('943', 'Circa Technology ', 'Circa Technology services', NULL, 'No 172/B,\nBorella road,\nThalawathugoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('944', 'AZ Associates', 'AZ Associates', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('945', 'Mac Tec', 'Mac Tec', NULL, 'No 39/3,\nGalle road,\nFortune arcade (opposite MC),\nCOL-04\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('946', 'ACER', 'ACER Com House', NULL, 'Siyabalapitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('947', 'Horizon College-F Secure', 'Horizon College International', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('948', 'NS Digital', 'NS Digital (Pvt) Ltd', NULL, 'Piliyandala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('949', 'Braclays', 'Braclays (Pvt) Ltd', NULL, 'Unity Plaza', NULL, NULL, NULL, NULL, NULL, '', '0'),
('950', 'Sampath IT', 'Sampath Information Technology Solutions (Pvt) Ltd', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('951', 'Mr.Shehan', 'Mr.Shehan', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('952', 'Chanz IT', 'Chanz IT', NULL, 'Mahabage', NULL, NULL, NULL, NULL, NULL, '', '0'),
('953', 'Galle Mobile', 'Galle Mobile', NULL, 'Udugama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('954', 'One Click Computers', 'One Click Computers', NULL, 'Matara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('955', 'Sahasra Computers', 'Sahasra Computers', NULL, 'Elpitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('956', 'Dr.Chanaka Gayan', 'Dr.Chanaka Gayan', NULL, 'Walasmulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('957', 'Ranmark Computers ', 'Ranmark Computers ', NULL, 'Middeniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('958', 'Nex Computers', 'Nex Computers', NULL, 'Kurunegala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('959', 'P Tec Computer', 'P Tec Computer Service Centre', NULL, 'Kurunegala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('960', 'Digital Tag (PC Hut)', 'Digital Tag Training (Pvt) Ltd', NULL, 'Kurunegala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('961', 'Millenium Phone House', 'Millenium Phone House', NULL, 'Kuruwita', NULL, NULL, NULL, NULL, NULL, '', '0'),
('962', 'MG Mobile &amp; Video', 'MG Mobile &amp; Video', NULL, 'Kuruwita', NULL, NULL, NULL, NULL, NULL, '', '0'),
('963', 'Abans PLC - ', 'Abans PLC - ', NULL, 'Galle Road,\nColombo 03', NULL, NULL, NULL, NULL, NULL, '', '0'),
('964', 'Ultrium', 'Ultrium Technologies (Pvt) Ltd', NULL, '74B 1/1,\nGalle Road,\nDehiwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('965', 'Koshalya Garments ', 'Koshalya Garments ', NULL, 'P.P.J Weerasooriya\nManaging Director\nNo 66 A, Hewagama\nKaduwela, \nSri Lanka\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('966', 'CryptoGen Pvt Ltd', 'CryptoGen Pvt Ltd', NULL, 'Mr.Wasantha Perera\nLevel 8 East, Ceylinco House, \nNo 69, Janadipathi Mawatha, \nColombo 01\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('967', 'Free Lanka Granite', 'Free Lanka Granite (Pvt) Ltd', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('968', 'C.W Mackie PLC', '', NULL, 'P O Box 161,\nNo 36,\nD R Wijewardana Mawatha,\nColombo 10', NULL, NULL, NULL, NULL, NULL, '', '0'),
('969', 'ATG', 'ATG', NULL, 'S S Wilson &amp; Company (Pvt) Ltd\nS. Ashokan-Chairman\nNo 174 1/1,\nMohamed Zain Mawatha,\nColombo 12', NULL, NULL, NULL, NULL, NULL, '', '0'),
('970', 'Millenium IT', 'Millenium IT', NULL, 'Panadura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('971', 'Colour Lab', 'Colour Lab', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('972', 'SLIATE', 'Sri Lanka Institute of Advance Technological Education', NULL, 'No 320,\nJanawathu Piyasa,\nT B Jaya Mawatha,\nColombo 10', NULL, NULL, NULL, NULL, NULL, '', '0'),
('973', 'Open Ark', 'Open Ark Systems ', NULL, 'No 120,\nHigh level Road,\nKirulapona\nColombo 06', NULL, NULL, NULL, NULL, NULL, '', '0'),
('974', 'Balfour Beauty', 'Balfour Beauty', NULL, 'Mr. Shyaad Perera\nPhase 3\nInvestment Promotion Zone, Katunayake,\nColombo,\nSri Lanka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('975', 'EMSI Soft ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('976', 'Abans PLC -Tender sales Elite', 'Abans PLC ', NULL, 'Abans PLC (Elite)\nMr.Anand Kumar \nSales manager-Abans corporate\n4th floor, Abans Head Office,\nNo. 498, Galle Road, Colombo 3,', NULL, NULL, NULL, NULL, NULL, '', '0'),
('977', 'Ashen', 'Ashen', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('978', ' Niese', 'Mr ER DE Niese', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('979', 'Link Square', 'Link Square', NULL, 'Unity Plaza', NULL, NULL, NULL, NULL, NULL, '', '0'),
('980', 'IT Store', 'IT Store', NULL, 'Unity Plaza', NULL, NULL, NULL, NULL, NULL, '', '0'),
('981', 'My Computers (Pvt) Ltd', 'My Computers (Pvt) Ltd', NULL, 'Maharagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('982', 'Saw Engineering ', 'Saw Engineering (Pvt) Ltd', NULL, 'No 52,\nMakoia Nortn,\nMakola,\nKiribathgoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('983', 'Total Solutions', 'Total Solutions', NULL, 'Panadura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('984', 'MOL Logistics', 'MOL Logistics Lanka (Private) Limited', NULL, 'Ms.Hannelore Baldsing\nLevel 04,\nBTL Shipping House,\n45/2,Braybroole Street,\nColombo 02\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('985', 'Sagara Technicians', 'Sagara Technicians', NULL, 'Hambanthota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('986', 'Trans Asia ', 'Trans Asia Computers', NULL, 'Ambalanota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('987', 'E-Tec Computers', 'E-Tec Computers', NULL, 'Sooriyawewa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('988', 'PC Cards', 'PC Cards', NULL, 'Kaluthara South', NULL, NULL, NULL, NULL, NULL, '', '0'),
('989', 'Prime Tech', 'Prime Tech Computers', NULL, '122/1/1,\nBekariya Junction,\nAttidiya,\nDehiwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('990', 'Doctor PC ', 'Doctor PC ', NULL, 'Battaramulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('991', 'Advantec Network', 'Advantec Network System (Pvt) Ltd', NULL, 'No.9/1,\nSumner Pl,\nColombo 08.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('992', 'Ledvo ', 'Ledvo Computers', NULL, 'Kurunegala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('993', 'Cyber Zone', 'Cyber Zone', NULL, 'Balangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('994', 'Technic World ', 'Technic World Computers', NULL, 'Balangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('995', 'CS Computer-Balangoda', 'CS Computer-Balangoda', NULL, 'Balangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('996', 'Crown Computers', 'Crown Computers', NULL, 'Melsiripura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('997', 'Infomax Computers', 'Infomax Computers', NULL, 'Gallewela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('998', 'Mr.Premathilaka', 'Mr.Premathilaka', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('999', 'Shenzhen Konchang ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1000', 'Charuka Soft Net', 'Charuka Soft Net', NULL, 'Maththegoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1001', 'DLW Computers', 'DLW Computers', NULL, 'Kottawa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1002', 'Guident Computers', 'Guident Computers', NULL, 'Homagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1003', 'K-Net Computers', 'K-Net Computers', NULL, 'Nittambuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1004', 'Revo Computers', 'Revo Computers', NULL, 'Marawila', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1005', 'Brillianz Computers', 'Brillianz Computers', NULL, 'Chilaw', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1006', 'NEAT Computers', 'NEAT Computers', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1007', 'SEGA Family', 'SEGA Family Computers', NULL, 'Sammanthurai', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1008', 'TEKNO World', 'TEKNO World', NULL, 'Batticola', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1009', 'The Galaxy', 'The Galaxy', NULL, 'Main Street,\nKalawachchikudi', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1010', 'E-City', 'E-City', NULL, 'Akkareipaththu', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1011', 'Selco ', 'Selco Continental Private Limited', NULL, 'Mr. Malaka,\nNo 69A ? 1/1,\nGalle Road,\nDehiwala South,\nSri Lanka.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1012', 'R &amp; W Computer System', 'R &amp; W Computer System', NULL, 'Horana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1013', 'Ayowee IT Care', 'Ayowee IT Care', NULL, 'Maggona', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1014', 'Millenium Technologies', 'Millenium Technologies', NULL, 'Panadura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1015', 'Main Branch', 'Main Branch', NULL, 'Panadura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1016', 'ILM', 'Institute of Lean Management (Pvt) Ltd', NULL, 'Level 26,\nEast Tower,\nWorld Trade Center,\nColombo 01,\nSri Lanka.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1017', 'Trans Technology', 'Trans Technology Computers', NULL, 'Matara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1018', 'Micro Computer-Hanwella', 'Micro Computer Center', NULL, 'No 25 B/2,\nMain Street,\nHanwella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1019', 'PrimeTek-Matara', 'PrimeTek-Matara', NULL, 'Matara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1020', 'TechMore-Matara', 'TechMore Computers', NULL, 'Matara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1021', 'Sarasi Computer-Ambalangoda', 'Sarasi Computer House', NULL, 'Ambalangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1022', 'Angel Electronics', 'Angel Electronics', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1023', 'Tulip Comuters', 'Tulip Comuters', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1024', 'Next Computers', 'Next Computers', NULL, 'Battaramulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1025', 'PC Mart', 'PC Mart', NULL, 'No 100/225,\nMumtaz Mahal,\nColombo 11', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1026', 'SDR Computers', 'SDR Computers', NULL, 'Dankotuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1027', 'Ayngaran Computers', 'Ayngaran Computers', NULL, 'Hettiyawatta', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1028', 'C-Com ', 'C-Com ', NULL, 'Nugegoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1029', 'East Link', 'East Link Engineering Co.(pvt) Ltd', NULL, 'No 163/26,\nNawala Road,\nColombo 05', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1030', 'Chanowm Technologies', 'Chanowm Technologies', NULL, 'Motatuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1031', 'Smart Computers-Moratuwa', 'Smart Computers', NULL, 'Moratuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1032', 'Damith IT', 'Damith IT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1033', 'Texas Electronics', 'Texas Electronics Engineering', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1034', 'Metro Computer', 'Metro Computer Technologies', NULL, 'Matara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1035', 'ComTec-Wadduwa', 'Com Tec Computers', NULL, 'Wadduwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1036', 'Wajira Karunathilaka-Primal', 'Wajira Karunathilaka', NULL, 'Gampaha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1037', 'E-Line Technologies', 'E-Line Technologies', NULL, 'Kandy', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1038', 'Akura Book Shop', 'Akura Book Shop', NULL, 'Miriswatta', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1039', 'Thisara Book Shop', 'Thisara Book Shop', NULL, 'Ahungalla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1040', 'PC Globe', 'PC Globe', NULL, 'Unity Plaza', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1041', 'Stafford Garments', 'Stafford Garments Industries (Pvt) Ltd,', NULL, 'No: 304-5 1/2,\nNegombo Road,\nPeliyagoda.\n               \nVAT : 0114096512-7000\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1042', 'Computer House', 'Computer House', NULL, 'Padukka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1043', 'Sashi Computers', 'Sashi Computers', NULL, 'Panadura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1044', 'D-Tech Computer ', 'D-Tech Computer Services', NULL, 'Bibile', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1045', 'Soft Tech Computers', 'Soft Tech Computers', NULL, 'Ambalanthota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1046', 'M V C Computers', 'M V C Computers', NULL, 'Weerakatiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1047', 'Indika Electronics', 'Indika Electronics', NULL, 'Weerakatiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1048', 'Dilan Computers', 'Dilan Computers', NULL, 'Diulapitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1049', 'MyCom Technologies', 'MyCom Technologies', NULL, 'Kirillawala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1050', 'HSBC Credit Crad', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1051', 'Soft System', 'Soft System Computer Zone', NULL, 'Kelaniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1052', 'Wisdom Books', 'Wisdom Books', NULL, 'Wattala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1053', 'Aussie Computers', 'Aussie Computers', NULL, 'Makola', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1054', 'Sampath Technologies ', 'Sampath Technologies &amp; Marketing', NULL, 'Kelaniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1055', 'Cash-Primal', 'Cash-Primal', NULL, 'Primal', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1056', 'Plus Computers', 'Plus Computers', NULL, 'Embilipitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1057', 'Nenasa Computers', 'Nenasa Computers', NULL, 'Polonnaruwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1058', 'Sewwandi Communication', 'Sewwandi Communication', NULL, 'Embilipitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1059', 'Nelum Video', 'Nelum Video &amp; Communication', NULL, 'Embilipitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1060', 'Onimtar High Tech', 'Onimtar High Tech Solutions (Pvt) Ltd', NULL, 'Ratnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1061', 'PC System', 'PC System', NULL, 'Opanayake', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1062', 'Aiken Digital', 'Aiken Digital', NULL, 'Ratnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1063', 'Smart PC', 'Smart PC', NULL, 'Dambulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1064', 'Info Net Computers', 'Info Net Computers', NULL, 'Gallewela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1065', 'A Eon Computers', 'A Eon Computers', NULL, 'Dambulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1066', 'Quick Flix ', 'Quick Flix Tech Lanka', NULL, 'Pilimathalawa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1067', 'RDF Computers', 'RDF Computers', NULL, 'Katubedda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1068', 'New Olanka Computers', 'New Olanka Computers', NULL, 'Piliyandala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1069', 'Smart Laptop', 'Smart Laptop House', NULL, 'Matara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1070', 'Multi 9', 'Multi 9', NULL, 'Awissawella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1071', 'Fair Price', 'Fair Price', NULL, 'Horana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1072', 'Chptronics', 'Chptronics', NULL, 'Wadduwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1073', 'Matheesha Computers', 'Matheesha Computers', NULL, 'Horana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1074', 'ICEMAN', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1075', 'Globel Net-Nimendra', 'Globel Net Computers', NULL, 'Hikkaduwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1076', 'Synergy Computer-Nimendra', 'Synergy Computer Systems', NULL, 'Piliyandala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1077', 'PC Max-Nimendra', 'PC Max', NULL, 'Piliyandala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1078', 'AP Technologioes', 'AP Technologioes', NULL, 'Piliyandala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1079', 'Nishantha Book Shop', 'Nishantha Book Shop', NULL, 'Payagala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1080', 'Renown Computers', 'Renown Computers', NULL, 'Ingiriiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1081', 'SM Computers', 'SM Computers', NULL, 'Rawatawatte', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1082', 'Angel Computers-Nimendra', 'Angel Computers', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1083', 'K M K Technologies', 'K M K Technologies', NULL, 'Karapitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1084', 'Zee Mobile', 'Zee Mobile', NULL, 'Matara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1085', 'E-Work Shop-Horana', 'E-Work Shop', NULL, 'Horana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1086', 'Enitss Com0puters', 'Enitss Com0puters', NULL, 'Bandaragama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1087', 'HP Computer System', 'HP Computer System', NULL, 'Bandaragama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1088', 'CMC-Procurement Dept', 'Colombo Municipal Council', NULL, 'Central Procurement Department\nColombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1089', 'Colombo', 'Colombo', NULL, 'Evolve Store', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1090', 'Cash purchases', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1091', 'RP Technologies', 'RP Technologies', NULL, 'Negambo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1092', 'PC Home-Kiribathgoda', 'PC Home', NULL, 'Kiribathgoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1093', 'SD Computers', 'SD Computers', NULL, 'Padukka', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1094', 'V S Technologies', 'V S Technologies', NULL, 'Weligama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1095', 'Charlton Business Center', 'Charlton Business Center', NULL, 'Kandy', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1096', 'Chami Movie', 'Chami Movie World', NULL, 'Makola', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1097', 'Super Beam', 'Super Beam (Pvt) Ltd', NULL, 'Nugegoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1098', 'Onex ', 'Onex (Pvt) Ltd', NULL, 'Pelawaththe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1099', 'SK Gadget Shop', 'SK Gadget Shop &amp; Laptop Repair Center', NULL, 'Battaramulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1100', 'Okidlo Computers', 'Okidlo Computers', NULL, 'Kelaniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1101', 'Micro Tech ', 'Micro Tech Computers', NULL, 'Kochchikade', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1102', 'CyberZone', 'CyberZone', NULL, 'Homagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1103', 'Sandaru Video', 'Sandaru Video', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1104', 'Hasi Video', 'Hasi Video', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1105', 'New Net Computers', 'New Net Computers', NULL, 'Hidella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1106', 'LMP Printing', 'LMP Printing', NULL, 'Polonnaruwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1107', 'Ranga PC', 'Ranga PC', NULL, 'Polonnaruwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1108', 'Bitwin Computers', 'Bitwin Computers', NULL, 'Kurunegala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1109', 'Cebit Computers', 'Cebit Computers', NULL, 'Polonnaruwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1110', 'Techno Mobile And CCTV', 'Techno Mobile And CCTV', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1111', 'Senani Videos', 'Senani Videos', NULL, 'Kuruwita', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1112', 'Studio Cooray', 'Studio Cooray', NULL, 'Maggona', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1113', 'Mobile Zone', 'Mobile Zone', NULL, 'K-Zone,\nKatubedda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1114', 'Navora Communications', 'Navora Communications', NULL, 'Hikkaduwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1115', 'AB Mobile', 'AB Mobile', NULL, 'Aluthgama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1116', 'E-Zone', 'E-Zone', NULL, 'Ingiriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1117', 'Manjula Electronics', 'Manjula Electronics', NULL, 'Ingiriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1118', 'Intell lanka-Kosala', 'Intell lanka Computers', NULL, 'Kurunegala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1119', 'Aradana Mobile', 'Aradana Mobile', NULL, 'Anuradhapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1120', 'PC World-Kosala', 'PC World', NULL, 'Polonnaruwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1121', 'Excellent Computers-Kosala', 'Excellent Computers', NULL, 'Plonnaruwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1122', 'ATS Group-USA Project', 'ATS Group', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1123', 'Microtec -Panadura', 'Microtec Computers', NULL, 'Panadura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1124', 'Epitichia-Nimendra', 'Epitichia Multi Traders', NULL, 'Hatton', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1125', 'Kavindu Computers', 'Kavindu Computers', NULL, 'Payagala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1126', 'Rohan Book Shop', 'Rohan Book Shop', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1127', 'Cell One Cellullar', 'Cell One Cellullar', NULL, 'Ambalangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1128', 'G.S.M.Solutions', 'G.S.M.Solutions', NULL, 'Ambalangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1129', 'Amasha Video.com', 'Amasha Video.com', NULL, 'Horana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1130', 'Lakshan Mobile', 'Lakshan Mobile', NULL, 'Katukurunda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1131', 'I.R.Computers', 'I.R.Computers', NULL, 'Maggona', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1132', 'Perera Graphics', 'Perera Graphics', NULL, 'Kaluthara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1133', 'Galaxy Computers', 'Galaxy Computers', NULL, 'Kalawakachchikudi', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1134', 'Copreus (Pvt) Ltd', 'Copreus (Pvt) Ltd', NULL, 'Level 26,East Tower,\nWorld Trade Center,\nColombo 01', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1135', 'TCR Computers System', 'TCR Computers System', NULL, 'Pitigala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1136', 'SenitCom IT Solutions', 'SenitCom IT Solutions', NULL, 'Ratmalana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1137', 'Difontec Computers', 'Difontec Computers', NULL, 'Moratuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1138', 'Micro Computer Home-Beruwala', 'Micro Computer Home', NULL, 'Beruwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1139', 'Sitelka Cellular', 'Sitelka Cellular', NULL, 'Katubedda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1140', 'Hedra Solutions', 'Hedra Solutions', NULL, 'Athurugiriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1141', 'CNN Computers', 'CNN Computers', NULL, 'Nattandiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1142', 'The Print Hub', 'The Print Hub', NULL, 'Polonnaruwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1143', 'Wisdom Computers', 'Wisdom Computers', NULL, 'Balangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1144', 'IT Plus', 'IT Plus', NULL, 'Anuradhapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1145', 'Power PC laptop', 'Power PC laptop', NULL, 'Anuradhapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1146', 'Tech Tool Computer', 'Tech Tool Computer', NULL, 'Anuradhapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1147', 'Smart IT-Polonnaruwa', 'Smart IT', NULL, 'Polonnaruwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1148', 'Darshani Computers', 'Darshani Computers', NULL, 'Habarana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1149', 'Max Computer Sys', 'Max Computer Sys', NULL, 'Polgahawela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1150', 'Mobile Hut', 'Mobile Hut', NULL, 'Opanayake', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1151', 'Ceilao ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1152', 'Workshop-Nimendra', 'Workshop', NULL, 'Horana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1153', 'V.S.P.Computer', 'V.S.P.Computer System', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1154', '3Quities', '3Quities Multi Shop', NULL, 'Payagala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1155', 'Danansaya Print House', 'Danansaya Print House &amp; Computers', NULL, 'Dehiowita', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1156', 'Super Max', 'Super Max', NULL, 'Karawanaella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1157', 'K.G.S.Computers', 'K.G.S.Computers', NULL, 'Yatiyantota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1158', 'I Com-Nimendra', 'I Com Computers', NULL, 'Ginigathhena', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1159', 'H.D.Haran', 'H.D.Haran', NULL, 'Nuwaraeliya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1160', 'Jetro Communication', 'Jetro Communication', NULL, 'Nuwara eliya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1161', 'B.D.F Computers', 'B.D.F Computers', NULL, 'Katubedda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1162', 'Vishwa Celluler', 'Vishwa Celluler', NULL, 'Niwithigala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1163', 'K &amp; L Mobile', 'K &amp; L Mobile', NULL, 'Kuruwita', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1164', 'Lakmal Communication', 'Lakmal Communication', NULL, 'Polpithigama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1165', 'Edirisinghe Celluler', 'Edirisinghe Celluler', NULL, 'Nivithigala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1166', 'G &amp;  J Computers', 'G &amp;  J Computers', NULL, 'Deyandara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1167', 'Zima Computers', 'Zima Computers', NULL, 'Polonnaruwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1168', 'Shahon Computers', 'Shahon Computers', NULL, 'Polonnaruwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1169', 'JD Computers', 'JD Computers', NULL, 'Anuradhapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1170', 'Priyankara Stores', 'Priyankara Stores', NULL, 'Habarana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1171', 'Cool Zone ', 'Cool Zone Entertainment', NULL, 'Aluthgama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1172', 'New Isuru Trade', 'New Isuru Trade Center', NULL, 'Bombuwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1173', 'S.N Multi Tech', 'S.N Multi Tech', NULL, 'Kaluthara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1174', 'Brad Ferris', 'Brad Ferris', NULL, 'Director\nRed Digital\nAustralia\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1175', 'Strangers ', 'Strangers Computers', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1176', 'Future Tech', 'Future Tech Computers', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1177', 'Scenic Digital-Nimendra', 'Scenic Digital Word', NULL, 'Bombuwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1178', 'I Fix Solutions', 'I Fix Solutions', NULL, 'Kadawatha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1179', 'Micro Phone Shop -Nimendra', 'Micro Phone Shop', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1180', 'Micro Phone Shop-Nimendra', 'Senvo Computers', NULL, 'Ambalangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1181', 'Softvision IT', 'Softvision IT Group (Pvt) Ltd', NULL, 'No 414/7-1/1,\nBaseline Garden,Baseline Road,\nColombo 09', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1182', 'Pubudu Mobile &amp; Multi Cent', 'Pubudu Mobile &amp; Multi Center', NULL, 'Dehiowita', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1183', 'Best Computers &amp; Phone Sho', 'Best Computers &amp; Phone Shop', NULL, 'Yatiyanthota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1184', 'Hatton Computer ', 'Hatton Computer Systems', NULL, 'Hatton', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1185', 'Nalin Stores', 'Nalin Stores', NULL, 'Kaluthara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1186', 'Isuru Video &amp; Phone-Nimend', 'Isuru Video &amp; Phone Center', NULL, 'Kahawaththa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1187', 'I Fix Pc -Nimendra', 'I Fix Pc Solutions', NULL, 'Panadura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1188', 'Service Global-USD', 'Service Global', NULL, '980,Mission Court,\nFremont,CA\n94539,USA', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1189', 'Rota-Japan', 'Rota-Japan', NULL, 'Japan', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1190', 'Ole Takai-Mr.Ashan&#039;s Cust', 'Ole Takai', NULL, 'Ripples', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1191', 'Main Branch', 'Main Branch', NULL, 'Ripples', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1192', 'TECHZONE ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1193', 'House of Travels &amp; Tourism', 'House of Travels &amp; Tourism', NULL, 'NO 220,Hight Level Road,\nColombo 06', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1194', 'NCTS Technology ', 'NCTS Technology PC System', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1195', 'Multi Phone Shop-Ijas', 'Multi Phone Shop', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1196', 'I Com Technology-Ijas', 'I Com Technology', NULL, 'Kinniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1197', 'Phone Time-Ijas', 'Phone Time Mobile Shop', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1198', 'I Mobile-Ijas', 'I Mobile', NULL, 'Kinniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1199', 'F S Mobile Shop-Ijas', 'F S Mobile Shop', NULL, 'Uppuveli', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1200', 'Asian Cell Stores-Ijas', 'Asian Cell Stores', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1201', 'Naja Computer System', 'Naja Computer System', NULL, 'Main Street,Muthur', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1202', 'Mobile World-Ijas', 'Mobile World', NULL, 'Oddumavadi', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1203', 'Boardway-Ijas', 'Boardway Computer Tech', NULL, 'Oddumavadi', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1204', 'CMB Phone Shop-Ijas', 'Colombo Phone Shop and Rent a Car', NULL, 'Beticalo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1205', 'ITM-Ijas', 'Institute of zTechnology &amp; Management', NULL, 'Akkarapattu', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1206', 'New World Mobile-Ijas', 'New World Mobile', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1207', 'EyeCom Technologies-Ijas', 'EyeCom Technologies', NULL, 'Kinniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1208', 'Issath Communication-Ijas', 'Issath Communication', NULL, 'Jinnagar', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1209', 'New City Technology-Ijas', 'New City Technology PC System', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1210', 'N K T Computers', 'N K T Computers', NULL, 'Colombo 05', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1211', 'Blue Chip Technologies', 'Blue Chip Technologies (Pvt) Ltd', NULL, 'Dehiwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1212', 'Smart Net ', 'Smart Net Computers', NULL, 'Wellawaya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1213', 'Tele Print-Nimendra', 'Tele Print Computer Service ', NULL, 'Hatton', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1214', 'Lanka Minerals &amp; Chemicals', 'Lanka Minerals &amp; Chemicals (Pvt) Limited', NULL, 'No 75,\n2nd Lane,\nRatmalana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1215', 'Lead Capital-USD', 'Lead Capital Corporation', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1216', 'CNGA', 'CN Global Pty. Ltd. Australia', NULL, 'Australia', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1217', 'Lakshitha Communication ', 'Lakshitha Communication ', NULL, 'Pallebedda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1218', 'S.L.A.Rizard.Com-Nimendra', 'S.L.A.Rizard.Com', NULL, 'Haputhale', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1219', 'Anil&#039;s Computers-Nimendra', 'Anil&#039;s Computers', NULL, 'Hali-Ella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1220', 'Minro Communication-Nimendra', 'Minro Communication', NULL, 'Aluthgama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1221', 'Samadhi Communication-Nimendra', 'Samadhi Communication', NULL, 'Balangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1222', 'Global Net-Nimendra', 'Global Net Computers', NULL, 'Hikkaduwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1223', 'I Net Computer-Nimendra', 'I Net Computer Technologies', NULL, 'Matara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1224', 'E-World-Roshan', 'E-World', NULL, 'Wellawaththa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1225', 'Chamara Technologies-Roshan', 'Chamara Technologies', NULL, 'Hokandara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1226', 'Veema Computers-Nimendra', 'Veema Computers', NULL, 'Bandaragama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1227', 'C H Computers-Nimendra', 'C H Computers', NULL, 'Kithulgala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1228', 'Best Way Computers-Nimendra', 'Best Way Computers', NULL, 'Awissawella', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1229', 'E-Base Computer-Dilruk', 'E-Base Computer', NULL, 'Mapolagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1230', 'Top Choice-Ijas', 'Top Choice', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1231', 'RS Enterprises-Ijas', 'RS Enterprises', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1232', 'JM Electronics-Ijas', 'JM Electronics', NULL, 'Kinniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1233', 'Askas Fancy Place-Ijas', 'Askas Fancy Place', NULL, 'Kinniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1234', 'I Techno -Ijas', 'I Techno Computers', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1235', 'Ayan Cellcity-Kinniya', 'Ayan Cellcity', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1236', 'Northern Pc Park-Ijas', 'Northern Pc Park', NULL, 'Jaffna', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1237', 'G Base-Ijas', 'G Base ', NULL, 'Kinniya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1238', 'Asiri Media Solutions-Ijas', 'Asiri Media Solutions', NULL, 'Kanthale', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1239', 'Shoppy Computers-Kaluthara', 'Shoppy Computers', NULL, 'Kaluthara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1240', 'Best Buy-Nimendra', 'Best Buy Mobile', NULL, 'Panadura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1241', 'Millennium Auto', 'Millennium Auto Exprez (Pvt.) Limited', NULL, 'No 298,\nButhgamuwa Road,\nRajagiriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1242', 'CN Global ', 'CN Global Lanka (Pvt) Ltd', NULL, 'Colombo 02', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1243', 'Ocen Mobile-Nimendra', 'Ocen Mobile', NULL, 'Kahawaththe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1244', 'SICT Computers', 'SICT Computers', NULL, 'Godakawela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1245', 'Pansilu Book Shop-Ijas', 'Pansilu Book Shop', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1246', 'Shathusa Video Vision-Ijas', 'Shathusa Video Vision', NULL, '3rd Mile Post', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1247', 'San Book Center', 'San Book Center', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1248', 'Info Net Lanka-Roshan', 'Info Net Lanka', NULL, 'No 573/A,Lake Road,Boralegamuwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1249', 'Uni Tec Gadgets-Roshsn', 'Uni Tec Gadgets', NULL, '123A,Sudharma Road,Kattiya Junction', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1250', 'Hight Tech Gelley-Roshan', 'Hight Tech Gelley', NULL, 'Maharagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1251', 'Ringing More Mobile-Roshan', 'Ringing More Mobile', NULL, '345,Kotte Road,Rajagiriya\n\n\n\n\n\n\n\n\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1252', 'Detech Solutions-Roshan', 'Detech Solutions', NULL, '23/1C Nawinna Maharagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1253', 'Kotte Movie Shop-Roshan', 'Kotte Movie Shop', NULL, '411,Thalawathugoda Road,Pitaktte', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1254', '3C Computers-Roshan', '3C Computers', NULL, '26/17 Metro Center.Athurugiya Road,Malabe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1255', '3D Computers-Roshan', '3D Computers', NULL, 'Thalahena,Malabe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1256', 'Nexx Com-Roshan', 'Nexx Com', NULL, 'Kaduwela Road,Battaramulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1257', 'NEX Computers-Roshan', 'NEX Computers', NULL, 'Kotte Road,Rajagiriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1258', 'CNG', 'CN Global Pty. Ltd. Sydney', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1259', 'sundry', 'Sundry Debtors', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1260', 'AMP Ceylon (Pvt) Ltd', 'AMP Ceylon (Pvt) Ltd', NULL, 'Phase 2, E.P.Z\nKatunayake', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1261', 'Star Link', 'Star Link', NULL, 'Mobile Phone Shop\n84 Power House Road\nTrincomalee', '0719666667', NULL, NULL, NULL, NULL, '', '0'),
('1262', 'Reema Phone Shop', 'Reema Phone Shop', NULL, 'Main Street\nOddamavadi', '0777733296', NULL, NULL, NULL, NULL, '', '0'),
('1263', 'Iqra Mobile', 'Iqra Soft ', NULL, 'Jamaliya Junction\nTrincomalee', '0767324891', NULL, NULL, NULL, NULL, '', '0'),
('1264', 'Digi Tech Computer', 'Digi Tech Computer', NULL, '488/9\nMaithreepala Senanayaka Mw,\nAnuradhapura', '0773730774', NULL, NULL, NULL, NULL, '', '0'),
('1265', 'D N R Mobile', 'D N R Mobile', NULL, '1019 Kandy Road\nTrincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1266', 'IT Land', 'IT Land', NULL, 'Main Street\nkattankudi', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1267', 'M I C Computers', 'M I C Computers', NULL, '24 Sea View\nTrincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1268', 'Ministry of Transport Manageme', 'Ministry of Transport Management ', NULL, 'Colombo Suburban Railway Project', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1269', 'OneITUSD', 'One IT - Australia', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1270', 'Computer Superstore', '', NULL, 'No:542, Duplication Raod,Colombo 03', '0112582411', '0112594976', '011582411', NULL, NULL, '', '0'),
('1271', 'Master Computer - Roshan', 'Master Computer - Roshan', NULL, '448 kotte Road\nRajagiriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1272', 'Nex Group of Company - Roshan', 'Nex Group of Company - Roshan', NULL, 'Rajagiriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1273', 'FNF Brothers Pvt Ltd - Roshan ', 'FNF Brothers Pvt Ltd - Roshan ', NULL, '58, Ground Floor\nLiberty Plaza\nColombo 03', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1274', 'Mr. Nilantha  - Roshan', 'Mr. Nilantha  - Roshan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1275', 'Global Phone Shop -  Nimendra', 'Global Phone Shop -  Nimendra', NULL, '85 Galle Rd \nAluthgama\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1276', 'Decent Technologies - Sinas', 'Decent Technologies - Sinas', NULL, '169 Goodshed Road\nRatnapura', '0716907151', NULL, NULL, NULL, NULL, '', '0'),
('1277', 'ORIKMO Technologies - Nimendra', 'ORIKMO Technologies - Nimendra', NULL, 'Galle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1278', 'Rishi Tele Mart - Nimendra', 'Rishi Tele Mart - Nimendra', NULL, 'Park Road\nNuwaraeliya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1279', 'ETNESS - NIMENDRA', 'ETNESS - NIMENDRA', NULL, 'Kalutara Road\nBandaragama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1280', 'Mr. Roshan ', 'Mr. Roshan ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1281', 'Abans PLC', 'Abans PLC', NULL, 'Abans PLC\nNo 498, Galle Road\nColombo-03', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1282', 'Express Mobile Shop', 'Express Mobile Shop', NULL, 'Main Street\nPalathoppur\nThoppur', '0778482233', NULL, NULL, NULL, NULL, '', '0'),
('1283', 'Rentokil', '', NULL, 'No:186, Vausxhall Street,\nColombo 02.', '0114725267', '0114725243', NULL, 'cuscare-lk@rentokil-intial.com', NULL, '', '0'),
('1284', 'Mobile Edge - Mirihana - Rosha', 'Mobile Edge - Mirihana - Roshan', NULL, '16 Old Kottawa Rd\nNugegoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1285', 'Channel Mait Computers - Rosha', 'Channel Mait Computers - Roshan', NULL, '80/1 Attidiya\nDehiwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1286', 'Channel Mait Computers-Roshan-', 'Channel Mait Computers-Roshan-', NULL, '80/1 Attidiya \nDehiwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1287', 'Quick Tech Lanka - Roshan', 'Quick Tech Lanka - Roshan', NULL, '390 Galle Rd\nRathmalana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1288', 'Siesis IT - Roshan', 'Siesis IT - Roshan', NULL, '816/05 Thalahena', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1289', 'PC Systems - Sinas New', 'PC Systems - Sinas New', NULL, '319/c ,01/01\nRatnapura Rd , Balgahamulla\nBalangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1290', 'F A F Communication - Sinas', 'F A F Communication - Sinas', NULL, '343 Kadugalwatta\nRatnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1291', 'N H Mobile - Sinas', 'N H Mobile - Sinas', NULL, '7 Pradeshiya saba Building \nEheliyagoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1292', 'Hi Tech Computer Systems-Sinas', 'Hi Tech Computer Systems - Sinas', NULL, 'Ratnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1293', 'Winap Lanka Computers - Sinas', 'Winap Lanka Computers - Sinas', NULL, 'Bandarawela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1294', 'Promt', '', NULL, 'No 40, Ferry Road, Rathmalana', '0114422733', NULL, '0114506505', NULL, NULL, '', '0'),
('1295', 'DVM Computers - Chanaka', 'DVM Computers - Chanaka', NULL, '554/A/1/3 Negombo Rd\nMahabage', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1296', 'Prabha Soft Creation - Sinas', 'Prabha Soft Creation - Sinas', NULL, '106C\nMaib Street\nRakwana , Ratnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1297', 'Genuine Mobile Home - Sinas', 'Genuine Mobile Home - Sinas', NULL, '9 New Market Comples\nRatnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1298', 'Online Communication &amp; Com', 'Online Communication &amp; Computers - Sinas', NULL, 'Kuruwita', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1299', 'Success Electronics - Sinas', 'Success Electronics - Sinas', NULL, 'Kalupalama asala,\nRatnapura Rd\nKalawewa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1300', 'E Vision Computers - Sinas', 'E Vision Computers - Sinas', NULL, 'Weddagala Rd\nKalawana', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1301', 'Enet Computers - Sinas', 'Enet Computers - Sinas', NULL, '101 Ratnapura RD\nPelmadulla\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1302', 'Likeminds', 'Like Minds Consulting Inc.', NULL, '30, Knightsbridge Road,\nNJ 08854\nUSA.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1303', 'Trans World - Ijas', 'Trans World - Ijas', NULL, 'Power House \nMuthur', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1304', 'Zest Computers - Nimendra', 'Zest Computers - Nimendra', NULL, '172/B Galle Rd\nKalutara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1305', 'Promax Computer Systems ', 'Promax Computer Systems - Nimendra', NULL, '2 Parkwood Complex\nNuwara Eliya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1306', 'Xeon Computers - Nimendra', 'Xeon Computers - Nimendra', NULL, '8 Viskam Road\nGalwadugoda\nGalle', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1307', 'Lap&#039;s Zone - Nimendra', 'Lap&#039;s Zone - Nimendra', NULL, '4 Kalidasa Rd\nMatara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1308', 'Sesiro Enterprise', 'Mr.Tharanga / Mr.Gayan', NULL, 'No 433 E3, Galle Raod,Ratmalana.', '0777010563', '0772225493', NULL, 'sesiro.enterprise@gmail.com', NULL, '', '0'),
('1309', 'CELLETRA - Roshan', 'CELLETRA - Roshan', NULL, '1075A Old Kotte rd\nWelikada&#039;\nRajagiriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1310', 'Flicks Video shop - Roshan', 'Flicks Video shop - Roshan', NULL, 'Rajagiriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1311', 'C.S. Studio &amp; Communicatio', 'C.S. Studio &amp; Communication -Sinas', NULL, 'Balawinna\nPalebadda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1312', 'Planet Technical -Sinas', 'Planet Technical -Sinas', NULL, 'Palama Asala\nVitanagama\nAyagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1313', 'M.M Computer &amp; Mobile - Si', 'M.M Computer &amp; Mobile - Sinas', NULL, 'Galbada  Junction\nGallaala \nRatnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1314', 'INTEL GSM - Sinas', 'INTEL GSM - Sinas', NULL, 'Bandarawela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1315', 'Easy Technology - Sinas', 'Easy Technology - Sinas', NULL, '12 New Shopping Complex\nHempala Munidasa Mawatha', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1316', 'Naflan.Com - Sinas', 'Naflan.Com - Sinas', NULL, 'Ratnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1317', 'PC Mart Computer Sales - Sinas', 'PC Mart Computer Sales &amp; Repair Center Sinas', NULL, 'Ratnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1318', 'Suranga Mobile - Sinas', 'Suranga Mobile - Sinas', NULL, 'Bus Stand\nRatnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1319', 'ARC Computers- Sinas', 'ARC Computers- Sinas', NULL, 'Darmaduta road\nBadulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1320', 'F N F Communication -Sinas', 'F N F Communication -Sinas', NULL, 'Ratnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1321', 'F M Rilwan - Sinas', 'F M Rilwan - Sinas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1322', 'UltraNet Computers - sinas', 'UltraNet Computers - sinas', NULL, 'NIvetegala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1323', 'I Support Company - Sinas', 'I Support Company - Sinas', NULL, 'Rakwana Rd\nPalmadulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1324', 'Malsha Communication - Sinas', 'Malsha Communication - Sinas', NULL, 'Sooriyawewa Town', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1325', 'H.D Computers - Nimendra ', 'H.D Computers - Nimendra ', NULL, '369/2 Wilegoda\nKalutara ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1326', 'P &amp; J Grocery - Nimnedra ', 'P &amp; J Grocery - Nimnedra ', NULL, 'Kuda Payagala\nPayagala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1327', 'Evolutions of the Computer ', 'Evolutions of the Computer Solution - Nimendra ', NULL, 'Kanda Udawatta Road ,\nWadduwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1328', 'P.CEYL COMPUTERS -Nimendra', 'P.CEYL COMPUTERS -Nimendra', NULL, 'Bandaragama Rd\nMoranthuduwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1329', 'Trinco Ravanan Technology ', 'Trinco Ravanan Technology - Ijas', NULL, 'Thiruganasampanthar st\nTrinco', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1330', 'S.T Com -Ijas', 'S.T Com -Ijas', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1331', 'Mega Phone Shop - Ijas', 'Mega Phone Shop - Ijas', NULL, 'Dockyard Road\nTrincomalee ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1332', 'Mr Thilina - Dilruk ', 'Mr Thilina - Dilruk ', NULL, 'Beliatta', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1333', 'Barclays Computers Pvt Ltd', 'Barclays Computers Pvt Ltd', NULL, 'Galle Rd\nColombo 04\n\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1334', 'Shenzhen', '', NULL, 'Shenzhen', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1335', 'Emsisoft', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1336', 'M.S Computers - Sinas', 'M.S Computers - Sinas', NULL, 'Main Street\nGodakawela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1337', 'S.T Site Computers -Sinas ', 'S.T Site Computers -Sinas ', NULL, '195\nMain Street\nGodakawala', NULL, NULL, NULL, NULL, NULL, '', '0');
INSERT INTO `0_crm_persons` VALUES
('1338', 'IT LAB -Sinas', 'IT LAB -Sinas', NULL, 'Rakwana Road\nPalmadulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1339', 'Skynet Solutions - Sinas', 'Skynet Solutions - Sinas', NULL, 'Ayagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1340', '4D M Tec - Sinas', '4D M Tec - Sinas', NULL, 'Main Street\nBogawantalawa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1341', 'Nanasala Mobile - Sinas', 'Nanasala Mobile - Sinas', NULL, '102 Bus Stand \nTanamalwila ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1342', 'C.T Computers -Sinas', 'C.T Computers -Sinas', NULL, 'Bus Stand\nTanamalwila', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1343', 'R.S Mobile - Sinas ', 'R.S Mobile - Sinas ', NULL, '403 Kudugalwatta\nRatnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1344', 'VIP Technologies Pvt Ltd -Rosh', 'VIP Technologies Pvt Ltd -Roshan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1345', 'Next Solutions - Roshan', 'Next Solutions - Roshan', NULL, 'pelawatta', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1346', 'I Care Computers &amp; Mobile', 'I Care Computers &amp; Mobile - Roshan ', NULL, 'Ingiriya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1347', 'M.I Mobile -Nimendra ', 'M.I Mobile -Nimendra ', NULL, 'BNS Store\nKoladiya Junction \nKalutara South\n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1348', 'LAP HUB Computers - Nimendra', 'LAP HUB Computers - Nimendra', NULL, 'Wadiyamankada\nWaskaduwa\nKalutara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1349', 'N.D.R Solutions - Nimendra', 'N.D.R Solutions - Nimendra', NULL, 'Nagoda\nKalutara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1350', 'E Zone Communication -Nimendra', 'E Zone Communication - Nimendra ', NULL, 'Galle Rd\nMaggona ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1351', 'Navinda Computer - Nimendra', 'Navinda Computer Services - Nimendra', NULL, 'Kotmale Rd\nNawalapitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1352', 'Creative Tech Computer - Chana', 'Creative Tech Computer - Chanaka', NULL, 'Dimo Junction\nSiyambalape', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1353', 'Bilal Traders - Ijas', 'Bilal Traders - Ijas', NULL, 'Old Market Rd\nOddamavadi 03', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1354', 'A-Z Mobiles-Ijas', 'A-Z Mobiles', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1355', 'Pala Net Com-Sinaz', 'Pala Net Computers', NULL, 'Kalawana road,', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1356', 'Pouja Cellular-Sinaz', 'Pouja Cellular', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1357', 'Chajana Mobilr Hoom-Sinaz', 'Chajana Mobilr Hoom', NULL, 'Rathnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1358', 'CALL ME-IJAS', 'CALL ME-IJAS', NULL, 'TRINCO', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1359', 'SKY CREATIONS-IJAS', 'SKY CREATIONS-IJAS', NULL, 'TRINCO', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1360', 'CITY HALL MULTY SHOP-IJAS', 'CITY HALL MULTY SHOP', NULL, 'TRINCO', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1361', 'Pascal Computers', 'Pascal Computers', NULL, 'Buththala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1362', 'Nescafe Station', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1363', 'New express communication-Rosh', 'New express communication', NULL, 'Dehiwala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1364', 'Trade Wings Enterprises-Roshan', 'Trade Wings Enterprises', NULL, 'Battaramulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1365', 'Happy Laptop Service-Roshan', 'Happy Laptop Service', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1366', 'Thilina computers-Dilruk', 'Thilina computers', NULL, 'Beliatta', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1367', 'O Zone Computers-Dilruk', 'O Zone Computers', NULL, 'deiyandara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1368', 'T S I Comouters', 'T S I Comouters', NULL, 'Ampara', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1369', 'Lotus Computers-Dilruk', 'Lotus Computers', NULL, 'Siyabalanduwa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1370', 'Star Computer-Dilruk', 'Star Computer', NULL, 'Beliatta', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1371', 'Pasidu Computers-Dilruk', 'Pasidu Computers', NULL, 'Wellawaya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1372', 'New SN Computers-Dilruk', 'New SN Computers', NULL, 'Wellawaya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1373', 'My Computer Technologies-Chana', 'My Computer Technologies', NULL, 'Kurunegala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1374', 'Hello World -Sinas', 'Hello World -Sinas', NULL, '179 , Main Street\nRatnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1375', 'Savidu.Com -Sinas', 'Savidu.Com -Sinas', NULL, 'R.E.T Udawalawe', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1376', 'Tileni Mobile &amp; Comm- Sina', 'Tileni Mobile &amp; Comm- Sinas', NULL, 'RET udawalawa , ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1377', 'Siva Rama Computers- Sinas', 'Siva Rama Computers- Sinas', NULL, 'Kovil Road , Rakwana ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1378', 'Rama Computers &amp; Comm-Sina', 'Rama Computers &amp; Comm-Sinas', NULL, '775/5F Winil Complex , Kahawatta', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1379', 'Master Mind-Ijas', 'Master Mind', NULL, 'Kalmunei', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1380', 'T Mobiling-Ijas', 'T Mobiling', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1381', 'Lahiru Mobile Video - Sinas', 'Lahiru Mobile Video - Sinas', NULL, 'Ratnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1382', 'Unitec Computer -Sinas', 'Unitec Computer -Sinas', NULL, '\nRatnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1383', 'Nawodya Mobile &amp; Comm -Sin', 'Nawodya Mobile &amp; Comm -Sinas', NULL, 'Tennahena \nGinigathhena', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1384', 'Sathusa-Ijas', 'Sathusa', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1385', 'D N R Solutions-Nimendra', 'D N R Solutions', NULL, 'Nagoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1386', 'Methmi Mobiles-Ijas', 'Methmi Mobiles', NULL, 'Muthur', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1387', 'Fulgar Lanka ', 'Fulgar Lanka (Pvt) Limited', NULL, 'Katunayake', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1388', 'Lead Capital Corporation-LKR', 'Lead Capital Corporation', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1389', 'Chamara Technologies', 'Chamara Technologies', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1390', 'C.N.S Mobile &amp; Com - Sinas', 'C.N.S Mobile &amp; Com - Sinas', NULL, 'Ratnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1391', 'F.B Mobile &amp; Computers - S', 'F.B Mobile &amp; Computers - Sinas', NULL, '31 , Bus Stand ,\nRatnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1392', 'Ifa Mobile &amp; Technology -S', 'Ifa Mobile &amp; Technology - Sinas', NULL, 'Mahawala\nRatnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1393', 'AD Tec Computers - Sinas', 'AD Tec Computers - Sinas', NULL, 'Balangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1394', 'Smart Mobile Tanamalwila Sinas', 'Smart Mobile Tanamalwila - Sinas', NULL, 'Bogaha Asala\nTanamalwila', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1395', 'D.N.S Technologies -Sinas ', 'D.N.S Technologies -Sinas ', NULL, 'Udagama ,\nEmbilipitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1396', 'Kadar Mobile - Sinas', 'Kadar Mobile - Sinas', NULL, 'Bus Stand Rd ,\nPalleBadda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1397', 'Umar Mobile &amp; Comm- Sinas', 'Umar Mobile &amp; Comm- Sinas', NULL, 'Kudugalwatta ,\nRatnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1398', 'Cine Mobile - Sinas', 'Cine Mobile - Sinas', NULL, 'Galbadda Junction ,\nwewalwatta Rd', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1399', 'Rizad Mobile - Sinas', 'Rizad Mobile - Sinas', NULL, 'Dabatana rd , \nHaputala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1400', 'Rapip Computers- Sinas', 'Rapip Computers- Sinas', NULL, 'Lallupitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1401', 'Osura Mobile - Sinas', 'Osura Mobile - Sinas', NULL, 'Ratnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1402', 'Rahman Mobile - Sinas', 'Rahman Mobile - Sinas', NULL, 'Bogawantalawa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1403', 'CITE Computers- Sinas', 'CITE Computers- Sinas', NULL, 'Banadarawela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1404', 'Crystal Music World - Ijas', 'Crystal Music World - Ijas', NULL, 'Central Road ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1405', 'CD World-Ijas', 'CD World', NULL, 'AJ Junction', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1406', 'Kumar Studio/Video - Ijas', 'Kumar Studio/Video - Ijas', NULL, 'New Shopping Complex\n3rd Mile Post\nTrincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1407', 'Ring Master - ijas', 'Ring Master - ijas', NULL, '3rd Mile Post ,\nTrincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1408', 'Samadhi Technologies-Dilruk', 'Samadhi Technologies', NULL, 'Bibile', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1409', 'Real Solutions-Dilruk', 'Real Solutions', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1410', 'M N Multy Shop-Dilruk', 'M N Multy Shop', NULL, 'Tallgampola', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1411', 'B &amp; S Stores - Nimendra', 'B &amp; S Stores - Nimendra', NULL, 'Kolaniya junc , \nKalutara South', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1412', 'Star Multi Shop - Ijas', 'Star Multi Shop - Ijas', NULL, 'Trinco', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1413', 'Extreme Tech - Ijas', 'Extreme Tech - Ijas', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1414', 'Success Techno -  Ijas', 'Success Techno -  Ijas', NULL, 'Vidyalayam Road\nTrinco', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1415', 'Various Computer - Ijas', 'Various Computer - Ijas', NULL, 'Kahatagasdigiliya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1416', 'LAPMART -IJAS', 'LAPMART -IJAS', NULL, 'Anuradhapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1417', 'PC Village - Ijas', 'PC Village - Ijas', NULL, 'Kattankudy', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1418', 'CJ Computer Solutions - Sinas', 'CJ Computer Solutions - Sinas', NULL, '90 , Badulla Rd , \nAtampitiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1419', 'Zoom Networks - Sinas', 'Zoom Networks - Sinas', NULL, '12 , Lower Street ,\nBadulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1420', 'Kasun Video &amp; Computers -S', 'Kasun Video &amp; Computers - Sinas', NULL, '7 , namunukula ,\nElla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1421', 'Swiss Net - Sinas', 'Swiss Net - Sinas', NULL, 'Bandarawela', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1422', 'Infaz Com &amp; Comp -Sinas', 'Infaz Com &amp; Comp -Sinas', NULL, 'Hapugastenna', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1423', 'Azmil Computer - Sinas', 'Azmil Computer - Sinas', NULL, 'Ratnajoti Mw ,\nRatnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1424', 'Sameera Comm &amp; Comp - Sina', 'Sameera Comm &amp; Comp - Sinas', NULL, 'Ratgama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1425', 'Sripagama Communication -Sinas', 'Sripagama Communication -Sinas', NULL, 'Sripagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1426', 'Computer Solution &amp; Mobile', 'Computer Solution &amp; Mobile -Sinas', NULL, 'B/27 , Commercial Building,\nBandawala  ', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1427', 'Computers &amp; Comm - Sinas', 'Computers &amp; Comm - Sinas', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1428', 'Oxbrain Computer System -Sinas', 'Oxbrain Computer System - Sinas', NULL, 'Main Street,\nDiyatalawa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1429', 'Comtec Computers-Nimendra', 'Comtec Computers', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1430', 'GI-Tech-Nimendra', 'GI-Tech Solutions (Pvt) Ltd', NULL, 'Nuwaraeliya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1431', 'Babege Computers-Dilruk', 'Babege Computers', NULL, 'Bibile', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1432', 'I T House-Dilruk', 'I T House', NULL, 'Bibile', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1433', 'Saranga Computers-Dilruk', 'Saranga Computers', NULL, 'Hambanthota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1434', 'E-Wings Trading-Roshan', 'E-Wings Trading', NULL, 'Battaramulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1435', 'E-Happy computers-Roshan', 'E-Happy computers', NULL, 'Battaramulla', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1436', 'CS Computer-Chanaka', 'CS Computer &amp; Multi Shop', NULL, 'Makola', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1437', 'Shenzhen', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1438', 'Divisional Secretariat-Colombo', 'Divisional Secretariat-Colombo', NULL, 'No 12,\nDam Street,\nColombo 12', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1439', 'HIGHTEK COMPUTERS - Chanaka', 'HIGHTEK COMPUTERS - Chanaka', NULL, 'Mawaramandiya\nSiyabalape', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1440', 'Deleepa Computer &amp; Comm-Si', 'Deleepa Computer &amp; Comm-Sinas', NULL, 'Kesalovitagama Road', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1441', 'Walawa Mobile &amp; Computer-S', 'Walawa Mobile &amp; Computer Solution - Sinas', NULL, 'Embilipitiya Road\nWalawa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1442', 'A One Computer - Sinas', 'A One Computer - Sinas', NULL, 'Ayagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1443', 'Chapa Mobile -Sinas', 'Chapa Mobile -Sinas', NULL, 'Ayagama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1444', 'I Tech Computer Sys- Sinas', 'I Tech Computer Sys - Sinas', NULL, 'Ratnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1445', 'Computer Solution - Kaltota', 'Computer Solution - Sinas Kaltota', NULL, 'Kaltota', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1446', 'I Net Computer - Sinas', 'I Net Computer - Sinas', NULL, 'Main Street\nEhaliyagoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1447', 'PC Tech System - Nemindra', 'PC Tech System - Nemindra', NULL, '474 1/C Arther V D Mw, \nPanadura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1448', 'D.K Computers - Nemindra', 'D.K Computers - Nemindra', NULL, 'Awariyawatta , Alubonull\nPanadura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1449', 'Digital Expose - Ijas', 'Digital Expose - Ijas', NULL, '147 , Kandy Rd\nTrincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1450', 'Wide Tech Solution -  Ijas', 'Wide Tech Solution -  Ijas', NULL, '167A , Central Road\nTrincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1451', 'Visualization Unit Comp-Ijas', 'Visualization Unit Comp-Ijas', NULL, '836 , Kandy Rd\nMihindapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1452', 'Promoditha Technology - Ijas', 'Promoditha Technology - Ijas', NULL, 'Pottuvil', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1453', 'Senu Book Shop - Nimendra', 'Senu Book Shop - Nimendra', NULL, 'Daluwaththa \nPayagala', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1454', 'Tharaka Mobile - Sinas', 'Tharaka Mobile - Sinas', NULL, 'Badulla Road\nBalangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1455', 'Pahan Net - Sinas', 'Pahan Net - Sinas', NULL, 'Main Street - \nRatnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1456', 'R.M.S Mobile - Sinas', 'R.M.S Mobile - Sinas', NULL, '14/B \nWallandura\nKahawatta', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1457', 'Link Natural', 'Link Natural Products (Pvt) Limited', NULL, 'P.O Box 2,\nMalinda,\nKapugoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1458', 'Rajabima - Dilruk', 'Rajabima - Dilruk', NULL, 'LK', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1459', 'Akalanka Mobile - Sinas', 'Akalanka Mobile - Sinas', NULL, 'No.8\nKalawewa Rd , \nKuruwita', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1460', 'VIJI Computers - Sinas', 'VIJI Computers - Sinas', NULL, 'Colombo Rd\nNew Town Junction', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1461', 'PC Partner Computer -SINAS', 'PC Partner Computer Store -SINAS', NULL, 'No , 8\nShopping Complex\nKAPUGALWATTA', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1462', 'Samanala Communication - Chana', 'Samanala Communication - Chanaka', NULL, 'Mawaramandiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1463', 'suspence', 'suspence', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1464', 'Cash-Zakin', 'Cash-Zakin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1465', 'A.S.P.D Mobile &amp; Com -Sina', 'A.S.P.D Mobile &amp; Com -Sinas', NULL, 'Bus Stand \nRatnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1466', 'Smart Touch PC - IJAS', 'Smart Touch PC - IJAS', NULL, 'Trincomalee', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1467', 'Chaminda Computers - Sinas', 'Chaminda Computers - Sinas', NULL, 'Muduwa Rd\nPahalahakmuwa\nRatnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1468', 'P.E.M Technologies - Sinas', 'P.E.M Technologies - Sinas', NULL, 'Ebilipitiya rd\nUdawalawa', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1469', 'Oshan Computers- Sinas', 'Oshan Computers- Sinas', NULL, 'Balangoda Rd \nTerwanketiya', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1470', 'New Mobile Mart - Sinas', 'New Mobile Mart - Sinas', NULL, 'Balangoda', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1471', 'Sandaruwan Cellular - Nimendra', 'Sandaruwan Cellular - Nimendra', NULL, 'Bus Stand\nBandaragama', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1472', 'PS Computer - Dilruk', 'PS Computer - Dilruk', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('1473', 'Sandun CD Mobile - Sinas', 'Sandun CD Mobile - Sinas', NULL, 'New Bus Stand rd\nRatnapura\n \n', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1474', 'Mayanta Computers - Sinas', 'Mayanta Computers - Sinas', NULL, 'Ratnapura', NULL, NULL, NULL, NULL, NULL, '', '0'),
('1475', 'Lanka Bell WareHouse', 'Lanka Bell WareHouse', NULL, 'No 2/72,\nMinuwangoda Road,\nMathammana,Gampaha.\n\n', NULL, NULL, NULL, NULL, NULL, '', '0');

### Structure of table `0_currencies` ###

DROP TABLE IF EXISTS `0_currencies`;

CREATE TABLE `0_currencies` (
  `currency` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `auto_update` tinyint(1) NOT NULL DEFAULT '1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_currencies` ###

INSERT INTO `0_currencies` VALUES
('Australian Dollar', 'AUD', 'AUD', 'Australia', 'Cents', '1', '0'),
('Sterling Pounds', 'GBP', 'GBP', '', 'Cents', '1', '0'),
('Japanese Yen', 'JPY', 'JPY', 'Japan', 'Cents', '1', '0'),
('Sri Lanka Rupee', 'LKR', 'Rs', 'Sri Lanka', 'Cents', '1', '0'),
('US Dollar', 'USD', '$', '', 'Cents', '1', '0');

### Structure of table `0_cust_allocations` ###

DROP TABLE IF EXISTS `0_cust_allocations`;

CREATE TABLE `0_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_allocations` ###


### Structure of table `0_cust_branch` ###

DROP TABLE IF EXISTS `0_cust_branch`;

CREATE TABLE `0_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `br_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `branch_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `br_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT '0',
  `default_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `receivables_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT '1',
  `br_post_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT '0',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `bank_account` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `contact_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `disable_trans` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=InnoDB AUTO_INCREMENT=1408 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_branch` ###

INSERT INTO `0_cust_branch` VALUES
('1', '2', 'BAM Holdings', 'bam', 'BAM Holdings Limited\n120, Station Road\nHomagama.', '1', '1', 'DEF', '1', '', '4510', '1200', '4500', '1', 'BAM Holdings Limited\n120, Station Road\nHomagama.', '0', '', NULL, '0', '', '0'),
('2', '3', 'Bartleet Produce Marketing(Pvt)Ltd.', 'Bartleet', 'Bartleet Produce Marketing(Pvt)Ltd.\n211/10 Veluwana Place\nColombo 9.\n', '1', '1', 'DEF', '1', '', '4510', '1203', '4500', '1', 'Bartleet Produce Marketing(Pvt)Ltd.\n211/10 Veluwana Place\nColombo 9.\n', '0', '', NULL, '0', '', '0'),
('3', '5', 'De La Ru Lanka (Pvt)Ltd.', 'Delaru', 'De La Ru Lanka (Pvt)Ltd.\nExport Processing Zone\nBiyagama\n', '1', '1', 'DEF', '2', '', '4510', '1203', '4500', '1', 'De La Ru Lanka (Pvt)Ltd.\nExport Processing Zone\nBiyagama\n', '0', '', NULL, '0', '', '0'),
('4', '4', 'Employee Trust Fund Board', 'etf', 'Employee Trust Fund Board\n44/5, Narahenpita Road,\nNawala.\n', '1', '1', 'DEF', '1', '', '4510', '1203', '4500', '1', 'Employee Trust Fund Board\n44/5, Narahenpita Road,\nNawala.\n', '0', '', NULL, '0', '', '0'),
('5', '6', 'Field Services Limited', 'field', 'Field Services Limited\n26, Milagiriya Avenue\nColombo 4.\n', '1', '1', 'DEF', '2', '', '4510', '1203', '4500', '1', 'Field Services Limited\n26, Milagiriya Avenue\nColombo 4.\n', '0', '', NULL, '0', '', '0'),
('6', '7', 'Free Lanka Trading Co; Ltd.', 'free', 'Free Lanka Trading Co; Ltd.\nLevel 3, Prince Alfred Tower\nColombo 3.\n', '1', '1', 'DEF', '1', '', '4510', '1203', '4500', '1', 'Free Lanka Trading Co; Ltd.\nLevel 3, Prince Alfred Tower\nColombo 3.\n', '0', '', NULL, '0', '', '0'),
('7', '8', 'Inbay Limited', 'inbay', 'Inbay Limited\nOne Selforde Street,\nClerkenwell,\nLondon ECIR OBE', '1', '1', 'DEF', '1', '', '4510', '1202', '4500', '1', 'Inbay Limited\nOne Selforde Street,\nClerkenwell,\nLondon ECIR OBE', '0', '', NULL, '0', '', '0'),
('9', '9', 'Mitsui O.S.K.Lines Lanka (Pvt)Ltd.', 'mitsui', 'Mitsui O.S.K.Lines Lanka (Pvt)Ltd.\nLevel 12, Access Towers\n278, Union Place,\nColombo 2.\n', '1', '1', 'DEF', '2', '', '4510', '1203', '4500', '1', 'Mitsui O.S.K.Lines Lanka (Pvt)Ltd.\nLevel 12, Access Towers\n278, Union Place,\nColombo 2.\n', '0', '', NULL, '0', '', '0'),
('10', '1', 'National Lotteries Board', 'nlb', '234/2, Galle Road,\nColombo 3.', '1', '1', 'DEF', '1', '', '4510', '1203', '1245', '1', '234/2, Galle Road,\nColombo 3.', '0', '', NULL, '0', '', '0'),
('11', '10', 'Sanasa Development Bank Ltd.', 'sanasa', '12,Edmonton Lane,\nColombo 6', '1', '1', 'DEF', '2', '', '4510', '1203', '4500', '1', '12,Edmonton Lane,\nColombo 6', '2', '', NULL, '0', '', '0'),
('12', '11', 'Unique Pharmacy', 'unique', 'Negombo', '1', '14', 'N P', '2', '', '4510', '1200', '4500', '1', 'Negombo', '0', '', NULL, '0', '', '0'),
('14', '13', 'Rosen Enterprises (Pvt)Ltd', 'rosen', 'No.14, Station Road,\nMaharagama.', '1', '4', 'DEF', '2', '', '4510', '1203', '4500', '1', 'No.14, Station Road,\nMaharagama.', '0', '', NULL, '0', '', '0'),
('15', '14', 'Nawaloka Hospitals (Pvt)Ltd', 'nawaloka hosp', 'Slave Island,\nColombo 2.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Slave Island,\nColombo 2.', '0', '', NULL, '0', '', '0'),
('16', '15', 'Asiri Hospitals (Pvt)Ltd.', 'asiri', 'Kirula Road,\nColombo 5.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Kirula Road,\nColombo 5.', '0', '', NULL, '0', '', '0'),
('17', '16', 'Pannipitiya Nursing Home (Pvt)Ltd.', 'pannipitiya NH', 'Havelock Road,\nPannipitiya.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Havelock Road,\nPannipitiya.', '0', '', NULL, '0', '', '0'),
('18', '17', 'Sridhara Pharmacy', 'sridhara pharma', 'Colombo', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('19', '18', 'Devon Pharmacy', 'devon pharma', 'Galle', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('23', '19', 'Pathirage Pharmacy', 'pathirage pharma', 'Karapitiya, \nGalle.', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Karapitiya, \nGalle.', '0', '', NULL, '0', '', '0'),
('26', '21', 'Central Hospital (Pvt.) Ltd.', 'the central', '114,Norris Canal Road,\nColombo 10.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', '114,Norris Canal Road,\nColombo 10.', '0', '', NULL, '0', '', '0'),
('27', '22', 'Thamudi Pharmacy', 'thamudi pharma', 'Karapitiya,\nGalle.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Karapitiya,\nGalle.', '0', '', NULL, '0', '', '0'),
('28', '23', 'Nipuna Pharmacy', 'nipuna pharma', 'Galle,', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Galle,', '0', '', NULL, '0', '', '0'),
('29', '24', 'Teaching Hospital', 'teaching hosp', 'Kurunegala.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Kurunegala.', '0', '', NULL, '0', '', '0'),
('35', '25', 'National Hospital of Sri Lanka', 'national hosp', 'Colombo 10.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Colombo 10.', '0', '', NULL, '0', '', '0'),
('36', '26', 'Leesons Hospital', 'leesons hosp', 'Ragama.', '1', '14', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Ragama.', '0', '', NULL, '0', '', '0'),
('37', '27', 'Ragama Pharmacy', 'ragama pharma', 'Ragama.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Ragama.', '0', '', NULL, '0', '', '0'),
('38', '28', 'The Pharmacy', 'the pharma', 'Negombo.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Negombo.', '0', '', NULL, '0', '', '0'),
('39', '29', 'MaMa Pharmacy', 'mama pharma', 'Ragama.', '1', '14', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Ragama.', '0', '', NULL, '0', '', '0'),
('40', '30', 'Ceylinco Health Care Services Limited', 'ceylinco-hc', '60, Park Street,\nColombo 02.', '1', '3', 'DEF', '2', '', '4510', '1200', '4500', '1', '60, Park Street,\nColombo 02.', '0', '', NULL, '0', '', '0'),
('42', '32', 'Co-operative Hospital', 'co-op hosp ', 'Gampaha.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Gampaha.', '0', '', NULL, '0', '', '0'),
('43', '33', 'Hemas Hospital', 'hemas hosp', 'Wattala.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Wattala.', '0', '', NULL, '0', '', '0'),
('45', '34', 'Hasmira Pharmacy', 'hasmira pharma', 'Pinnaduwa', '1', '13', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Pinnaduwa', '0', '', NULL, '0', '', '0'),
('46', '35', 'Lu Lu Pharmacy', 'lulu pharma', '7/1A, Bandaranayake Place,\nThanipolgaha Junction,\nGalle.', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', '7/1A, Bandaranayake Place,\nThanipolgaha Junction,\nGalle.', '0', '', NULL, '0', '', '0'),
('47', '36', 'Kuruduwatta Pharmacy', 'kuruduwatta pharma', 'Gintota', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Gintota', '0', '', NULL, '0', '', '0'),
('48', '37', 'New Lanka Pharmacy', 'new lanka', 'No.09, Karapitiya,\nGalle.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'No.09, Karapitiya,\nGalle.', '0', '', NULL, '0', '', '0'),
('49', '38', 'Dr. Nalin Geeganage', 'Dr. Nalin', 'General Hospital,\nHambantota.', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'General Hospital,\nHambantota.', '0', '', NULL, '0', '', '0'),
('50', '39', 'Sithari Pharmacy', 'sithari pharma', 'No. 90,Mahaveediya,\nAmbalantota.', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'No. 90,Mahaveediya,\nAmbalantota.', '0', '', NULL, '0', '', '0'),
('51', '40', 'Nakiyadeniya Pharmacy', 'nakiyadnya pharma', 'Nakiyadeniya.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Nakiyadeniya.', '0', '', NULL, '0', '', '0'),
('52', '41', 'New Piyasiri Medical', 'piyasiri ph', 'Akuressa', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Akuressa', '0', '', NULL, '0', '', '0'),
('53', '42', 'Makuluwa Pharmacy', 'makuluwa pharma', 'Makuluwa Junction,\nGalle.', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Makuluwa Junction,\nGalle.', '0', '', NULL, '0', '', '0'),
('54', '43', 'Monaragala Nursing Home', 'monaragla NH', 'No.124, Pottuvill Road,\nMonaragala.', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'No.124, Pottuvill Road,\nMonaragala.', '0', '', NULL, '0', '', '0'),
('56', '44', 'Bodhi Pharmacy', 'bodhi pharma', 'Opposite Hospital,\nSirigala,\nMonaragala.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Opposite Hospital,\nSirigala,\nMonaragala.', '0', '', NULL, '0', '', '0'),
('57', '45', 'New Sausiri Pharmacy and Grocery', 'new sausiri pharma', 'No.78, Main Street,\nMonaragala.', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'No.78, Main Street,\nMonaragala.', '0', '', NULL, '0', '', '0'),
('59', '46', 'Monaragala Pharmacy', 'monaragla pharma', 'Monaragala.', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Monaragala.', '0', '', NULL, '0', '', '0'),
('61', '47', 'Dr. W. K. Dissanayake', 'Dr. Dissanayake', 'Deberawewa.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Deberawewa.', '0', '', NULL, '0', '', '0'),
('64', '48', 'Isuru Medi House', 'isuru medi', 'Hambantota.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Hambantota.', '0', '', NULL, '0', '', '0'),
('67', '49', 'Jayasinghe Pharmacy', 'jayasinghe pharma', 'Hambantota.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Hambantota.', '0', '', NULL, '0', '', '0'),
('68', '50', 'Dr. H. K. Prabhath Lakmal', 'Dr. Prabhath', 'Heenmara.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Heenmara.', '0', '', NULL, '0', '', '0'),
('69', '51', 'Chathuranga Pharmacy', 'chathu pharma', 'Ketanwila, Akuressa.', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Ketanwila, Akuressa.', '0', '', NULL, '0', '', '0'),
('70', '52', 'Dr. Jeewan Nanayakkara', 'Dr. Jeewan', 'Ambalamwaththa,\nGalle.', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Ambalamwaththa,\nGalle.', '0', '', NULL, '0', '', '0'),
('72', '53', 'Dr. G. H. Amarasiri', 'Dr. G, Amarasiri', 'Yatadola, Mathugama.', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Yatadola, Mathugama.', '0', '', NULL, '0', '', '0'),
('73', '54', 'Chaminda Pharmacy', 'chaminda pharma', 'Piyadigama,\nGalle.', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Piyadigama,\nGalle.', '0', '', NULL, '0', '', '0'),
('74', '55', 'Central Pharmacy', 'central pharma', '01, Ingiriya Road,\nPadukka.', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', '01, Ingiriya Road,\nPadukka.', '0', '', NULL, '0', '', '0'),
('75', '56', 'New Peoples Pharmacy', 'new peoples ph', 'Negombo Road,\nMahabage.', '1', '14', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Negombo Road,\nMahabage.', '0', '', NULL, '0', '', '0'),
('76', '57', 'Sethma Hospitals', 'sethma hosp', 'Gampaha.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Gampaha.', '0', '', NULL, '0', '', '0'),
('77', '58', 'Sathira Pharmacy', 'sathira pharma', 'Gampaha.', '1', '14', 'N P', '2', '', '4510', '1200', '4500', '1', 'Gampaha.', '0', '', NULL, '0', '', '0'),
('78', '59', 'Anura Pharmacy', 'anura pharma', 'Gampaha.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Gampaha.', '0', '', NULL, '0', '', '0'),
('79', '60', 'K. F. Medical Centre', 'kf medi centre', '186, Colombo Road,\nMalwana.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', '186, Colombo Road,\nMalwana.', '0', '', NULL, '0', '', '0'),
('80', '61', 'Metro Pharmacy', 'metro', 'Mathugama.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Mathugama.', '0', '', NULL, '0', '', '0'),
('81', '62', 'New Philip Hospitals', 'philip hosp', 'Kaluthara.', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Kaluthara.', '0', '', NULL, '0', '', '0'),
('82', '63', 'Gihan Pharmacy &amp; Grocery', 'gihan pharma', 'Thawalama Junction,\nThawalama,\nGalle.', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Thawalama Junction,\nThawalama,\nGalle.', '0', '', NULL, '0', '', '0'),
('83', '64', 'Royal Pharmacy', 'royal pharma', 'Sarenthukade Junction,\nGalle.', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Sarenthukade Junction,\nGalle.', '0', '', NULL, '0', '', '0'),
('84', '65', 'Salaka Pharmacy', 'salaka pharma', 'Weligama.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Weligama.', '0', '', NULL, '0', '', '0'),
('85', '66', 'Wickrama Pharmacy', 'wickrama pharma', 'Nagoda, Kaluthara.', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Nagoda, Kaluthara.', '0', '', NULL, '0', '', '0'),
('86', '67', 'Wasana Enterprises', 'wasana', 'No. 90,Elapitiwala, Ragama', '1', '6', 'DEF', '1', '', '4510', '1200', '4500', '1', 'No. 90,Elapitiwala, Ragama', '1', '', NULL, '0', '', '0'),
('87', '68', 'mjf', 'M.J.F Exports', 'Colombo', '1', '1', 'DEF', '2', '', '4510', '1203', '4500', '1', 'Colombo', '2', '', NULL, '0', '', '0'),
('89', '70', 'Certis Lanka Security Solutions(Pvt)Ltd.', 'certis', 'Colombo', '1', '1', 'DEF', '2', '4030', '4510', '1203', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('91', '72', 'Vasa Infotech Services (Pvt)Ltd.', 'vasa', 'Front Street\nColombo 1.', '1', '6', 'DEF', '2', '4015', '4510', '1203', '4015', '1', 'Front Street\nColombo 1.', '0', '', NULL, '0', '', '0'),
('92', '73', 'Cooperation for Industrial Development Lanka(Pvt)Ltd', 'coopid', 'Colombo 8', '1', '6', 'DEF', '2', '4015', '4510', '1200', '4015', '1', 'Colombo 8', '0', '', NULL, '0', '', '0'),
('93', '74', 'Karapitiya Private Hospital', 'karapitiya', 'Talagoha', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Talagoha', '0', '', NULL, '0', '', '0'),
('94', '75', 'Wijeratne Pharmacy', 'wijeratna', 'Ambalangoda', '1', '6', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Ambalangoda', '0', '', NULL, '0', '', '0'),
('95', '76', 'Dr.Indika Samanmalee', 'indika', 'Weligama', '1', '6', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Weligama', '0', '', NULL, '0', '', '0'),
('97', '78', 'Sanuja Pharmacy', 'sanuja', 'Nakiyadeniya', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Nakiyadeniya', '0', '', NULL, '0', '', '0'),
('98', '79', 'New Wijaya Pharmacy', 'newwijaya', 'Tangalle', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Tangalle', '0', '', NULL, '0', '', '0'),
('99', '80', 'Karapitiya Osusala', 'karapitiyaosusala', 'Karapitiya', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Karapitiya', '0', '', NULL, '0', '', '0'),
('100', '81', 'Dr.Jagath Premathilake', 'jagath', 'Galle', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('101', '82', 'Dr.V.C.K.Rathnayake', 'rathnayake', 'Nakiyadeniya', '1', '6', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Nakiyadeniya', '0', '', NULL, '0', '', '0'),
('102', '83', 'Sirigala Pharmacy', 'sirigala', 'Monaragala', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Monaragala', '0', '', NULL, '0', '', '0'),
('103', '84', 'Western Pharmacy', 'western', 'Borella', '1', '14', 'N P', '2', '', '4510', '1200', '4500', '1', 'Borella', '0', '', NULL, '0', '', '0'),
('104', '85', 'Peoples Pharmacy', 'peoples', 'Wattala.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Wattala.', '0', '', NULL, '0', '', '0'),
('105', '86', 'Good Health Pharmacy', 'goodhealth', 'Wattala.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Wattala.', '0', '', NULL, '0', '', '0'),
('106', '87', 'Prasanna Pharmacy', 'prasanna', 'Ja-ela', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Ja-ela', '0', '', NULL, '0', '', '0'),
('107', '88', 'City Pharmacy', 'city', 'Ja-ela', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Ja-ela', '0', '', NULL, '0', '', '0'),
('109', '90', 'Dr.Darshana Kumarasinghe', 'darshana', 'Yakkala', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Yakkala', '0', '', NULL, '0', '', '0'),
('110', '91', 'Teleray Pharmacy', 'teleray', 'Mahabage', '1', '14', 'N P', '2', '', '4510', '1200', '4500', '1', 'Mahabage', '0', '', NULL, '0', '', '0'),
('111', '92', 'New Rio Pharmacy', 'newrio', 'Wattala', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Wattala', '0', '', NULL, '0', '', '0'),
('113', '94', 'Negombo Food &amp; Drugs', 'negombo f&amp;d', 'Negombo', '1', '14', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Negombo', '0', '', NULL, '0', '', '0'),
('114', '95', 'St.Annes Nursing Home', 'st.annes', 'Marawila', '1', '14', 'N P', '2', '', '4510', '1200', '4500', '1', 'Marawila', '0', '', NULL, '0', '', '0'),
('115', '96', 'Nagoda Pharmacy', 'nagoda', 'Nagoda,\nKandana', '1', '14', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Nagoda,\nKandana', '0', '', NULL, '0', '', '0'),
('116', '97', 'Dr.Ziyard', 'ziyard', 'Negombo', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Negombo', '0', '', NULL, '0', '', '0'),
('117', '98', 'Dr. Mrs. Mayadunna', 'mayadunna', 'Makola.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Makola.', '0', '', NULL, '0', '', '0'),
('118', '99', 'J.D.Distributor', 'jdistributor', 'Divulapitiya.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Divulapitiya.', '0', '', NULL, '0', '', '0'),
('119', '100', 'Pearl Medical Services', 'pearlmedical', 'Church Street,\nColombo 2.', '1', '14', 'N P', '2', '', '4510', '1200', '4500', '1', 'Church Street,\nColombo 2.', '0', '', NULL, '0', '', '0'),
('120', '101', 'New Borella Chemists', 'newborella', 'Borella.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Borella.', '0', '', NULL, '0', '', '0'),
('121', '102', 'New City Pharmacy', 'newcity', 'Wennappuwa', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Wennappuwa', '0', '', NULL, '0', '', '0'),
('122', '103', 'S &amp; G Medicals', 's&amp;g', 'Dalupotha,\nNegombo', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Dalupotha,\nNegombo', '0', '', NULL, '0', '', '0'),
('123', '104', 'Dr.K.Sundaralingam', 'sundaralingam', '71, Anderson Road,\nNegombo', '1', '14', 'N P', '2', '', '4510', '1200', '4500', '1', '71, Anderson Road,\nNegombo', '0', '', NULL, '0', '', '0'),
('124', '105', 'Dr.Sanath Fernando', 'sanath', 'Wennappuwa', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Wennappuwa', '0', '', NULL, '0', '', '0'),
('125', '106', 'Empire Medical Stores', 'empire', 'Gampaha', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Gampaha', '0', '', NULL, '0', '', '0'),
('129', '110', 'Inbay Limited', 'inbayl', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', '1', '4', 'DEF', '2', '', '4510', '1202', '4500', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', '3', '', NULL, '0', '', '0'),
('130', '111', 'New Wijerathna Pharmacy', 'new wijerathna', 'Ambalantota.', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Ambalantota.', '0', '', NULL, '0', '', '0'),
('131', '112', 'Dr. U.K. Nuwan Shyamal', 'Dr. Nuwan', 'Galle.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Galle.', '0', '', NULL, '0', '', '0'),
('132', '113', 'Karapitiya Pharmacy &amp; Grocery', 'karapitiya pharma', 'Mapalagama Road,\nThalagaha.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Mapalagama Road,\nThalagaha.', '0', '', NULL, '0', '', '0'),
('133', '114', 'Sirasa Pharmacy', 'sirasa pharma', 'Kiwulawatta, \nBombuwella - Kaluthara.', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Kiwulawatta, \nBombuwella - Kaluthara.', '0', '', NULL, '0', '', '0'),
('134', '115', 'Lanka Pharmacy', 'lanka pharma', 'Thanamallwila.', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Thanamallwila.', '0', '', NULL, '0', '', '0'),
('135', '116', 'Dr. Dasun S. Landage', 'Dr. Dasun S', 'Base Hospital - Wellawaya.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Base Hospital - Wellawaya.', '0', '', NULL, '0', '', '0'),
('136', '117', 'Medi Care Pharmacy ', 'medi care pharma', 'Pitabaddara.', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Pitabaddara.', '0', '', NULL, '0', '', '0'),
('137', '118', 'Dr. S. Jayawardana', 'Dr. S jayawardana', 'Dispensary, Kalubovitiyana.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Dispensary, Kalubovitiyana.', '0', '', NULL, '0', '', '0'),
('138', '119', 'S. D. Pharmacy', 's.d. pharma', 'Kosnilgoda, Morawa.', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Kosnilgoda, Morawa.', '0', '', NULL, '0', '', '0'),
('139', '120', 'Dr. Ms. R. S. Gamage', 'Dr. Ms RS Gamage', 'No.12, Mahaveediya,\nAkurassa.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'No.12, Mahaveediya,\nAkurassa.', '0', '', NULL, '0', '', '0'),
('140', '121', 'Suhanda Pharmacy', 'suhanda pharma', 'Gonamulla.', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Gonamulla.', '0', '', NULL, '0', '', '0'),
('141', '122', 'Dr. Amila Kasun', 'Dr. Amila K', 'Weerakatiya', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Weerakatiya', '0', '', NULL, '0', '', '0'),
('142', '123', 'Dr. K.P.V.N.R. Dilrukshi', 'Dr. K Dilrukshi', 'Pilana.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Pilana.', '0', '', NULL, '0', '', '0'),
('143', '124', 'Kumadhi Pharmacy', 'kumdadhi pharma', 'Bogahagoda.', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Bogahagoda.', '0', '', NULL, '0', '', '0'),
('144', '125', 'Prabath Pharmacy', 'prabath pharma', 'Imaduwa.', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Imaduwa.', '0', '', NULL, '0', '', '0'),
('145', '126', 'Singhe Pharmacy', 'singhe pharma', 'No.51/1A, Olcott Mawatha,\nGalle.', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'No.51/1A, Olcott Mawatha,\nGalle.', '0', '', NULL, '0', '', '0'),
('147', '127', 'New City Pharmacy', 'new city pharma', 'No.5C, H.K. Edmond Mawatha.\nSaranthukade Junction,\nGalle.', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'No.5C, H.K. Edmond Mawatha.\nSaranthukade Junction,\nGalle.', '0', '', NULL, '0', '', '0'),
('148', '128', 'Dr. R.A. Thilak N. Ranasinghe', 'Dr. T Ranasinghe', 'Wennappuwa.', '1', '14', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Wennappuwa.', '0', '', NULL, '0', '', '0'),
('149', '129', 'The Pharmacy Ja-Ela', 'the pharma Ja-ela', 'No.101/11, St Mary&#039;s Road,\nSilver Place, Ja-Ela.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'No.101/11, St Mary&#039;s Road,\nSilver Place, Ja-Ela.', '0', '', NULL, '0', '', '0'),
('150', '130', 'Senani&#039;s Grocery &amp; Druggists', 'senani pharma', 'No.04, Main Street, Mihirigama.', '1', '14', 'N P', '2', '', '4510', '1200', '4500', '1', 'No.04, Main Street, Mihirigama.', '0', '', NULL, '0', '', '0'),
('151', '131', 'Shantha Pharmacy', 'shantha pharma', 'Mirigama.', '1', '14', 'N P', '2', '', '4510', '1200', '4500', '1', 'Mirigama.', '0', '', NULL, '0', '', '0'),
('152', '132', 'Apsara Pharmacy', 'apsara pharma', 'No.10, Opposite Bus Stand,\nPasyala Road,\nMirigama.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'No.10, Opposite Bus Stand,\nPasyala Road,\nMirigama.', '0', '', NULL, '0', '', '0'),
('153', '133', 'L.B.Finance Plc.', 'lbfinance', 'Colombo', '1', '1', 'DEF', '2', '', '4510', '1202', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('154', '134', 'Dr. S.M. Jagath K. Jayasinghe', 'Dr. Jagath J', 'Family Health Medical Centre.\n18, Station Road, Pallewela.', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Family Health Medical Centre.\n18, Station Road, Pallewela.', '0', '', NULL, '0', '', '0'),
('155', '135', 'NDB Wealth Management', 'NDB', '', '1', '1', 'DEF', '1', '', '4510', '1203', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('156', '136', 'Ceylinco Hotels Ltd', 'Ceylinco Hotel', '', '1', '1', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('157', '137', 'Staff - Asanka Pathumkumara', 'sasanka', '', '1', '4', 'DEF', '2', '', '4510', '1240', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('158', '138', 'A.P.Perera', 'apperrea', '', '1', '6', 'DEF', '2', '', '4510', '1240', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('159', '139', 'Staff - Perera', 'staffperera', '', '1', '6', 'DEF', '2', '', '4510', '1240', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('160', '140', 'DIC LANKA (PVT) LTD', 'DIC', 'No.147, Katuwana Industrial Estate,\nKatuwana Road,\nHomagama.', '1', '4', 'DEF', '2', '', '4510', '1200', '4500', '1', 'No.147, Katuwana Industrial Estate,\nKatuwana Road,\nHomagama.', '0', '', NULL, '0', '', '0'),
('161', '141', 'Lawson pest control International Pvt Ltd', 'Lawson Pest', 'No.330\nGalle Road\nColombo 04', '1', '6', 'DEF', '1', '', '4510', '1200', '4500', '1', 'No.330\nGalle Road\nColombo 04', '0', '', NULL, '0', '', '0'),
('162', '142', 'Child Fund of Sri Lanka', 'childfund', '', '1', '15', 'DEF', '2', '', '4510', '1203', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('163', '143', 'Dewa Pharmacy', 'Dewa', '', '1', '14', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('164', '144', 'Dr.D.K.P.Rodrigo', 'Dr.D.K.P.Rodrigo', 'Kadana', '1', '3', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Kadana', '0', '', NULL, '0', '', '0'),
('165', '145', 'Dr.M.Fernando', 'Dr.M.Fernando', 'Wennappuwa', '1', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Wennappuwa', '0', '', NULL, '0', '', '0'),
('166', '146', 'Dr.Kumara Ranasinghe', 'Dr.Kumara Ranasinghe', 'Delgoda', '1', '3', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Delgoda', '0', '', NULL, '0', '', '0'),
('167', '147', 'Dr.Mrs.Chithra Perera', 'Dr.Mrs.Chithra Perera', 'Kadana', '1', '14', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Kadana', '0', '', NULL, '0', '', '0'),
('168', '148', 'Dr.Vajira Mendis', 'Dr.Vajira Mendis', 'Kadawatha', '1', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Kadawatha', '0', '', NULL, '0', '', '0'),
('169', '149', 'Milan Pharmacy', 'Milan Pharmacy', 'Ederamulla', '1', '14', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Ederamulla', '0', '', NULL, '0', '', '0'),
('170', '150', 'Ederamulla Pharamcy', 'Ederamulla Pharamcy', 'Ederamulla', '1', '14', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Ederamulla', '0', '', NULL, '0', '', '0'),
('171', '151', 'Sanura Pharmacy', 'Sanura Pharmacy', 'Ederamulla', '1', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Ederamulla', '0', '', NULL, '0', '', '0'),
('172', '152', 'Dr.Mrs.H.Gunasena', 'Dr.Mrs.H.Gunasena', 'Kadana', '1', '14', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Kadana', '0', '', NULL, '0', '', '0'),
('173', '153', 'Dr.C.W.Liyanage', 'Dr.C.W.Liyanage', 'Dompe', '1', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Dompe', '0', '', NULL, '0', '', '0'),
('174', '154', 'P.Lal', 'P.Lal', 'Colombo', '1', '3', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('175', '155', 'Dr.Sunil Mendis', 'Dr.Sunil Mendis', 'Ragama', '1', '14', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Ragama', '0', '', NULL, '0', '', '0'),
('176', '156', 'Dr.R.S.Jayakumar', 'Dr.R.S.Jayakumar', 'Hendala', '1', '14', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Hendala', '0', '', NULL, '0', '', '0'),
('177', '157', 'Janasuwa Pharmacy', 'Janasuwa Pharmacy', 'Biyagama', '1', '14', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Biyagama', '0', '', NULL, '0', '', '0'),
('178', '158', 'Janasetha Pharmacy', 'Janasetha', 'Sapugaskanda', '1', '14', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Sapugaskanda', '0', '', NULL, '0', '', '0'),
('179', '159', 'Medi Tech Pharmacy', 'Medi Tech', 'Gampaha', '1', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Gampaha', '0', '', NULL, '0', '', '0'),
('180', '160', 'Lanka Pharma', 'Lanka ', 'Mahara', '1', '14', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Mahara', '0', '', NULL, '0', '', '0'),
('181', '161', 'Nissi Pharmacy', 'Nissi', 'Wattala', '1', '14', 'N P', '1', '', '4510', '1200', '4500', '1', 'Wattala', '0', '', NULL, '0', '', '0'),
('182', '162', 'Dr.Mrs.C.Hathurusinghe', 'Dr.Mrs.C.Hathurusinghe', 'Wattala', '1', '14', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Wattala', '0', '', NULL, '0', '', '0'),
('183', '163', 'Dr.N.P.Hapuarachchi', 'Dr.N.P.Hapuarachchi', 'Sapugastenna', '1', '3', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Sapugastenna', '0', '', NULL, '0', '', '0'),
('184', '164', 'Dr.K.A.E.C.Premarathna', 'Dr.K.A.E.C.Premarathna', 'Nittabuwa', '1', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Nittabuwa', '0', '', NULL, '0', '', '0'),
('185', '165', 'My Chemist Pharmacy', 'My Chemist', 'Pallewela', '1', '14', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Pallewela', '0', '', NULL, '0', '', '0'),
('186', '166', 'Dr.Naleem Perera', 'Dr.Naleem Perera', 'Kadana', '1', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Kadana', '0', '', NULL, '0', '', '0'),
('187', '167', 'Dr.Sanath Fernando', 'Dr.Sanath Fernando', 'Wennappuwa', '1', '3', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Wennappuwa', '0', '', NULL, '0', '', '0'),
('188', '168', 'Dr.D.Kumarasinghe', 'Dr.D.Kumarasinghe', 'Yakkala', '1', '3', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Yakkala', '0', '', NULL, '0', '', '0'),
('189', '169', 'C&amp;D Pharmacy', 'C&amp;D Pharmacy', 'Bathuwattha', '1', '14', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Bathuwattha', '0', '', NULL, '0', '', '0'),
('190', '170', 'Dr.Sydney Perera', 'Dr.Sydney Perera', 'Ederamulla', '1', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Ederamulla', '0', '', NULL, '0', '', '0'),
('191', '171', 'Dr.Senaka Herath', 'Dr.Senaka Herath', 'Ederamulla', '1', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Ederamulla', '0', '', NULL, '0', '', '0'),
('192', '172', 'Dr.Upul Pathirana', 'Dr.Upul Pathirana', 'Dompe', '1', '3', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Dompe', '0', '', NULL, '0', '', '0'),
('193', '173', 'Manahara Pharmacy', 'Manahara', 'Borella', '1', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Borella', '0', '', NULL, '0', '', '0'),
('194', '174', 'Dr.G.G.Hettiarachchi', 'Dr.G.G.Hettiarachchi', 'Sapugaskanda', '1', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Sapugaskanda', '0', '', NULL, '0', '', '0'),
('195', '175', 'People`s York Pharma', 'People&#039;s York', 'Colombo 08', '1', '14', 'N P', '1', '', '4510', '1200', '4500', '1', 'Colombo 08', '0', '', NULL, '0', '', '0'),
('196', '176', 'Iraj Pharamaceuticals', 'Iraj ', 'Colombo 11', '1', '3', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Colombo 11', '0', '', NULL, '0', '', '0'),
('197', '177', 'Dr.E.R.Weerasinghe', 'Dr.E.R.Weerasinghe', 'Bogoda', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Bogoda', '0', '', NULL, '0', '', '0'),
('198', '178', 'Ruhunu Medi House', 'Ruhunu Medi House', 'Hambanthota', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Hambanthota', '0', '', NULL, '0', '', '0'),
('199', '179', 'Dr.A.L.Sarjahan', 'Dr.A.L.Sarjahan', 'Ginthota', '1', '13', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Ginthota', '0', '', NULL, '0', '', '0'),
('200', '180', 'Omaya Pharmacy', 'Omaya', 'Thanamalvilla', '1', '13', 'G D', '1', '', '4510', '1200', '4500', '1', 'Thanamalvilla', '0', '', NULL, '0', '', '0'),
('201', '181', 'New royal Pharamcy', 'New royal ', 'Galle', '1', '13', 'G D', '1', '', '4510', '1200', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('202', '182', 'Isurudisi Pharmacy', 'Isurudisi Pharmacy', 'Pilane', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Pilane', '0', '', NULL, '0', '', '0'),
('203', '183', 'New Supun Pharmacy', 'New Supun Pharmacy', 'Weligama', '1', '13', 'G D', '1', '', '4510', '1200', '4500', '1', 'Weligama', '0', '', NULL, '0', '', '0'),
('204', '184', 'New Gihan Pharmacy', 'New Gihan', 'Thawalama', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Thawalama', '0', '', NULL, '0', '', '0'),
('205', '185', 'New Jayasinghe Pharmacy', 'New Jayasinghe', 'Hambanthota', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Hambanthota', '0', '', NULL, '0', '', '0'),
('206', '186', 'Sanmed Pharmacy', 'Sanmed', 'Benthota', '1', '13', 'G D', '1', '', '4510', '1200', '4500', '1', 'Benthota', '0', '', NULL, '0', '', '0'),
('207', '187', 'Dr.Manjula Nakandala', 'Dr.Manjula', 'Monaragala', '1', '13', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Monaragala', '0', '', NULL, '0', '', '0'),
('208', '188', 'New Metro Pharma', 'New Metro ', 'Mathugama', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Mathugama', '0', '', NULL, '0', '', '0'),
('209', '189', 'Dr.V.C.K.K.M.Rathnayake', 'Dr.Rathnayake', 'Tellabuwa', '1', '13', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Tellabuwa', '0', '', NULL, '0', '', '0'),
('210', '190', 'Dr.M.I.D.Jayaweera', 'Dr..D.Jayaweera', 'Kirimatimulla', '1', '13', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Kirimatimulla', '0', '', NULL, '0', '', '0'),
('211', '191', 'Mega Pharmacy', 'Mega Pharmacy', 'Kirimatimulla', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Kirimatimulla', '0', '', NULL, '0', '', '0'),
('212', '192', 'New Central Pharmacy', 'New Central', 'Weligama', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Weligama', '0', '', NULL, '0', '', '0'),
('213', '193', 'new Chaminda Pharmacy', 'new Chaminda', 'Piyadigama', '1', '13', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Piyadigama', '0', '', NULL, '0', '', '0'),
('214', '194', 'Dilneth Pharma', 'Dilneth Pharma', 'Boossa', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Boossa', '0', '', NULL, '0', '', '0'),
('215', '195', 'K.J.P.Pharmacy', 'K.J.P.Pharmacy', 'Wellawaya', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Wellawaya', '0', '', NULL, '0', '', '0'),
('216', '196', 'Dr.P.Jayasekara', 'Dr.P.Jayasekara', 'Magaha Junction , Kaluthara', '1', '13', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Magaha Junction , Kaluthara', '0', '', NULL, '0', '', '0'),
('217', '197', 'Dr.Kusuma Liyanage', 'Dr.Kusuma Liyanage', 'Lelwela', '1', '13', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Lelwela', '0', '', NULL, '0', '', '0'),
('218', '198', 'Thisara Pharma', 'Thisara Pharma', 'Karapitiya', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Karapitiya', '0', '', NULL, '0', '', '0'),
('219', '199', 'Delmon Pharmacy', 'Delmon Pharmacy', 'Baddagama', '1', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Baddagama', '0', '', NULL, '0', '', '0'),
('220', '200', 'Dr.C.W.Janaka', 'Dr.C.W.Janaka', 'Tanipollgaha', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Tanipollgaha', '0', '', NULL, '0', '', '0'),
('221', '201', 'D.Sivasutagaran', 'D.Sivasutagaran', '', '1', '3', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('222', '202', 'National Lotteries Board', 'National Lotteries Board', '', '1', '6', 'DEF', '2', '4030', '4510', '1203', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('223', '203', 'Jayalath Pharmacy', 'jayalath', 'Galle', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('224', '204', 'Induwara Pharmacy', 'Induwara', 'Induwara Pharmacy and grossary,\nJayanthi Junction,\nUdugama Road,\nGalle.', '1', '13', '02', '2', '', '4510', '1200', '4500', '1', 'Induwara Pharmacy and grossary,\nJayanthi Junction,\nUdugama Road,\nGalle.', '0', '', NULL, '0', '', '0'),
('225', '205', 'New Southern Pharmacy &amp; Grocery', 'Southern PH', ' Southern Pharmacy &amp; Grocery,\nNo 27A1/1,Karapitiya Road, Kalegana,Galle', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', ' Southern Pharmacy &amp; Grocery,\nNo 27A1/1,Karapitiya Road, Kalegana,Galle', '0', '', NULL, '0', '', '0'),
('226', '206', 'Dr V C K K M Rathnayake', 'M Rathnayake', 'Dr V C K K M Rathnayake,\nMedical Officer,\nTeaching Hospitial Karapitiya.', '1', '5', '02', '1', '', '4510', '1200', '4500', '1', 'Dr V C K K M Rathnayake,\nMedical Officer,\nTeaching Hospitial Karapitiya.', '0', '', NULL, '0', '', '0'),
('227', '207', 'Pasan Pharmacy', 'Pasan PH', 'Pasan Pharmacy,\nUdugama Road,\nNakiyadeniya,\nGalle', '1', '5', '02', '1', '', '4510', '1200', '4500', '1', 'Pasan Pharmacy,\nUdugama Road,\nNakiyadeniya,\nGalle', '0', '', NULL, '0', '', '0'),
('228', '208', 'Vimalasiri Pharmacy', 'Vimalasiri', 'Vimalasiri Pharmacy,\nAluthwala,\nGalle', '1', '5', '02', '1', '', '4510', '1200', '4500', '1', 'Vimalasiri Pharmacy,\nAluthwala,\nGalle', '0', '', NULL, '0', '', '0'),
('229', '209', 'Sithruwana Pharmacy', 'Sithruwana', 'Sithruwana Pharmacy,\nNo;04,Shopping,\nBatapola,\nGallage', '1', '5', '02', '1', '', '4510', '1200', '4500', '1', 'Sithruwana Pharmacy,\nNo;04,Shopping,\nBatapola,\nGallage', '0', '', NULL, '0', '', '0'),
('230', '210', 'Union pharmacy', 'Union ph', 'Union pharmacy,Baddegama Road,\nAmpegama,\nGalle', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Union pharmacy,Baddegama Road,\nAmpegama,\nGalle', '0', '', NULL, '0', '', '0'),
('231', '211', 'Dr Susantha Nadasena', 'Dr Susantha', 'Dr Susantha Nadasena,\nSLMC REG No 25553\nNeluwa,\n', '1', '13', '02', '1', '', '4510', '1200', '4500', '1', 'Dr Susantha Nadasena,\nSLMC REG No 25553\nNeluwa,\n', '0', '', NULL, '0', '', '0'),
('233', '213', 'Desala Pharmacy', 'Desala PH', 'Desala Pharmacy,\nManikgoda,\nKatugahahena.', '1', '13', '02', '2', '', '4510', '1200', '4500', '1', 'Desala Pharmacy,\nManikgoda,\nKatugahahena.', '0', '', NULL, '0', '', '0'),
('234', '214', 'Ram pharmacy &amp; grocery', 'Ram PH', 'Ram pharmacy &amp; grocery,\nKeeranthidiya,\nNaththuduwa', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Ram pharmacy &amp; grocery,\nKeeranthidiya,\nNaththuduwa', '0', '', NULL, '0', '', '0'),
('235', '215', 'Manahari pharmacy', 'Manahari PH', 'Manahari pharmacy,\nMain Street,\nBalapitiya.', '1', '13', '02', '2', '', '4510', '1200', '4500', '1', 'Manahari pharmacy,\nMain Street,\nBalapitiya.', '0', '', NULL, '0', '', '0'),
('236', '216', 'Chandana Pharmacy', 'Chandana PH', 'Chandana Pharmacy &amp; grocery,\nGall road,\nYatalamatta.', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', 'Chandana Pharmacy &amp; grocery,\nGall road,\nYatalamatta.', '0', '', NULL, '0', '', '0'),
('237', '217', 'Nagodavithana Pharmacy', 'Nagodavithana  PH', 'Nagodavithana Pharmacy,\nThalgaswala.\n', '1', '13', '02', '2', '', '4510', '1200', '4500', '1', 'Nagodavithana Pharmacy,\nThalgaswala.\n', '0', '', NULL, '0', '', '0'),
('238', '218', 'Medi house', 'Medi house', 'Medi house,\n1st cross road,\nniyagama,\nThalgaswala.\n', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', 'Medi house,\n1st cross road,\nniyagama,\nThalgaswala.\n', '0', '', NULL, '0', '', '0'),
('239', '219', 'Majestic pharmacy', 'Majestic ph', 'Majestic pharmacy,\nno122A,\nMain Street,\nCharoa Town.', '1', '13', '02', '2', '', '4510', '1200', '4500', '1', 'Majestic pharmacy,\nno122A,\nMain Street,\nCharoa Town.', '0', '', NULL, '0', '', '0'),
('240', '220', 'Jayantha pharmacy', 'Jayantha ph', 'Jayantha pharmacy,\nNo 365A,\nMain street,\ncharga Town.', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', 'Jayantha pharmacy,\nNo 365A,\nMain street,\ncharga Town.', '0', '', NULL, '0', '', '0'),
('241', '221', 'Medi cure pharmacy', 'Medi cure ph', 'Medi cure pharmacy,\n2E,Main street,\ndharaga Town', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', 'Medi cure pharmacy,\n2E,Main street,\ndharaga Town', '0', '', NULL, '0', '', '0'),
('242', '222', 'Lloyed pharmacy', 'Lloyed ph', 'Lloyed pharmacy,\nNo 94,\ngalle.', '1', '13', '02', '2', '', '4510', '1200', '4500', '1', 'Lloyed pharmacy,\nNo 94,\ngalle.', '0', '', NULL, '0', '', '0'),
('244', '224', 'Dr Thushara Edirisinghe', 'Dr Thushara', 'Dr Thushara Edirisinghe,\nGeneral Hospital,\nKalutara', '1', '13', '02', '2', '', '4510', '1200', '4500', '1', 'Dr Thushara Edirisinghe,\nGeneral Hospital,\nKalutara', '0', '', NULL, '0', '', '0'),
('245', '225', 'DR C C Gurusingha', 'DR C C Gurusingha', 'DR C C Gurusingha,\nElipitiya', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', 'DR C C Gurusingha,\nElipitiya', '0', '', NULL, '0', '', '0'),
('246', '226', 'Dr Saman Patirana', 'Dr Saman Patirana', 'Dr Saman Patirana,\nGalle.', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', 'Dr Saman Patirana,\nGalle.', '0', '', NULL, '0', '', '0'),
('247', '227', 'Chathuranga pharmacy', 'Chathuranga ph', 'Chathuranga pharmacy,\nGalle', '1', '13', '02', '2', '', '4510', '1200', '4500', '1', 'Chathuranga pharmacy,\nGalle', '0', '', NULL, '0', '', '0'),
('248', '228', 'Eraj pharmacy', 'Eraj ph', 'Eraj pharmacy,\nColombo 11.', '1', '2', '02', '2', '', '4510', '1200', '4500', '1', 'Eraj pharmacy,\nColombo 11.', '0', '', NULL, '0', '', '0'),
('249', '229', 'Dr M S Mohamed Ziyard', 'Dr M S Ziyard', 'Dr M S Mohamed Ziyard,\nTseyva hospital (PVT)LTD.No 11 Jayarathna road,\nDean junction ,\nNegambo', '1', '2', '02', '2', '', '4510', '1200', '4500', '1', 'Dr M S Mohamed Ziyard,\nTseyva hospital (PVT)LTD.No 11 Jayarathna road,\nDean junction ,\nNegambo', '0', '', NULL, '0', '', '0'),
('250', '230', 'city pharmacy', 'City ph', 'city pharmacy,\nno 166 \nWattala', '1', '14', '02', '2', '', '4510', '1200', '4500', '1', 'city pharmacy,\nno 166 \nWattala', '0', '', NULL, '0', '', '0'),
('251', '231', 'Dr K D Rodrigo', 'Dr K D Rodrigo', 'Dr K D Rodrigo,\nMedi house dispansary,\nKadana.', '1', '2', '02', '2', '', '4510', '1200', '4500', '1', 'Dr K D Rodrigo,\nMedi house dispansary,\nKadana.', '0', '', NULL, '0', '', '0'),
('252', '232', 'Chater House', 'Chater House', 'Chater House,\nNawala road,\nnarahenpita,Colombo 5,\nSri Lanka.', '1', '6', '02', '1', '', '4510', '1203', '4500', '1', 'Chater House,\nNawala road,\nnarahenpita,Colombo 5,\nSri Lanka.', '0', '', NULL, '0', '', '0'),
('253', '233', 'Rocevilla pharmacy', 'Rocevilla pharmacy', 'Rocevilla pharmacy,\nEndramulla', '1', '14', 'N P', '2', '', '4510', '1200', '4500', '1', 'Rocevilla pharmacy,\nEndramulla', '0', '', NULL, '0', '', '0'),
('254', '234', 'Senura pharmacy', 'Senura pharmacy', 'Senura pharmacy,\n233/412,\ngamini jayapura,\nenderamulla,\n', '1', '14', 'N P', '2', '', '4510', '1200', '4500', '1', 'Senura pharmacy,\n233/412,\ngamini jayapura,\nenderamulla,\n', '0', '', NULL, '0', '', '0'),
('255', '235', 'Central medial stores', 'Central medial stores', 'Central medial stores,\ndruggist and grocers,\nMain street,\nDompe', '1', '2', '02', '2', '', '4510', '1200', '4500', '1', 'Central medial stores,\ndruggist and grocers,\nMain street,\nDompe', '0', '', NULL, '0', '', '0'),
('257', '237', 'Star distributor', 'Star distributor', 'Star distributor,\nKadawatha', '1', '2', '02', '2', '', '4510', '1200', '4500', '1', 'Star distributor,\nKadawatha', '0', '', NULL, '0', '', '0'),
('258', '238', 'Dr laxman siriwardana', 'Dr L siriwardana', 'Dr laxman siriwardana,\nmirigama clinic &amp; channel center,\nno 186,\nPasyala road,\nMirigama', '1', '2', '02', '2', '', '4510', '1200', '4500', '1', 'Dr laxman siriwardana,\nmirigama clinic &amp; channel center,\nno 186,\nPasyala road,\nMirigama', '0', '', NULL, '0', '', '0'),
('259', '239', 'Dr Krishantha samaraweera', 'Dr K samaraweera', 'Dr Krishantha samaraweera,\nMallewa', '1', '2', '02', '2', '', '4510', '1200', '4500', '1', 'Dr Krishantha samaraweera,\nMallewa', '0', '', NULL, '0', '', '0'),
('260', '240', 'Dr P.Y.R gunathilaka', 'Dr P.Y.R gunathilaka', 'Dr P.Y.R gunathilaka,\nganemulla', '1', '2', '02', '2', '', '4510', '1200', '4500', '1', 'Dr P.Y.R gunathilaka,\nganemulla', '0', '', NULL, '0', '', '0'),
('261', '241', 'Aravints (PVT) LTD', 'Aravints (PVT) LTD', 'Aravints (PVT) LTD,\n125/B,\nold Dispancery Road, \nHendala,\nWattala', '1', '3', '02', '2', '', '4510', '1200', '4500', '1', 'Aravints (PVT) LTD,\n125/B,\nold Dispancery Road, \nHendala,\nWattala', '0', '', NULL, '0', '', '0'),
('262', '242', 'Mr Sumudu', 'Sumudu', 'Sumudu,\nKadawatha', '1', '3', '02', '2', '', '4510', '1200', '4500', '1', 'Sumudu,\nKadawatha', '0', '', NULL, '0', '', '0'),
('263', '243', 'Abila Marketing services', 'Abila Marketing services', 'Abila Marketing services,\nNo 100/9A,\nBalagala Road,\nHendala,\nWattala', '1', '3', '02', '2', '', '4510', '1200', '4500', '1', 'Abila Marketing services,\nNo 100/9A,\nBalagala Road,\nHendala,\nWattala', '0', '', NULL, '0', '', '0'),
('264', '244', 'evolve', 'Evolve Technologies (Pvt)Ltd.', '329, Galle Road,\nColombo 4.', '1', '7', 'DEF', '1', '', '4510', '1204', '4500', '1', '329, Galle Road,\nColombo 4.', '0', '', NULL, '0', '', '0'),
('265', '245', 'Techtools Integrators (Pvt)Ltd.', 'Techtools', 'No.10, Narahenpita Road,\nNawala,\nRajagiriya.', '1', '7', 'DEF', '1', '', '4510', '1204', '4500', '1', 'No.10, Narahenpita Road,\nNawala,\nRajagiriya.', '0', '', NULL, '0', '', '0'),
('266', '246', 'Dr Daya Fernando', 'Dr Daya Fernando', 'No264,\nNagoda,\nKandana', '1', '2', '02', '2', '', '4510', '1200', '4500', '1', 'No264,\nNagoda,\nKandana', '0', '', NULL, '0', '', '0'),
('267', '247', 'Dr P S K Samaranayaka', 'Dr P S K Samaranayaka', 'Wathupitiwala', '1', '14', '02', '2', '', '4510', '1200', '4500', '1', 'Wathupitiwala', '0', '', NULL, '0', '', '0'),
('268', '248', 'HEALTH PHARMACY &amp; GROCERY', 'HEALTH PHARMACY &amp; GROCERY', 'HEALTH PHARMACY &amp; GROCERY\nKeembiela,\nBaddegama', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', 'HEALTH PHARMACY &amp; GROCERY\nKeembiela,\nBaddegama', '0', '', NULL, '0', '', '0'),
('269', '249', 'DR U L Piyathilaka', 'DR U L Piyathilaka', 'Dispansary surgery \nMedicare 25,Main street,\nAmbalangoda.', '1', '13', '02', '2', '', '4510', '1200', '4500', '1', 'Dispansary surgery \nMedicare 25,Main street,\nAmbalangoda.', '0', '', NULL, '0', '', '0'),
('270', '250', 'Rajmalee Pharmacy &amp; Grocery', 'Rajmalee Pharmacy &amp; Grocer', 'Payagala', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', 'Payagala', '0', '', NULL, '0', '', '0'),
('272', '252', 'Isuru Pharmacy', 'Isuru Pharmacy', 'No 7-Cross Road,\nKaluthra', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', 'No 7-Cross Road,\nKaluthra', '0', '', NULL, '0', '', '0'),
('273', '253', 'Thilakan Pharmacy', 'Thilakan Pharmacy', '', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('274', '254', 'Kuamari Ph', 'Kuamari Ph', 'Pinnaduna', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', 'Pinnaduna', '0', '', NULL, '0', '', '0'),
('275', '255', 'Chirath Osusala', 'Chirath Osusala', 'Dikkubura', '1', '13', '02', '2', '', '4510', '1200', '4500', '1', 'Dikkubura', '0', '', NULL, '0', '', '0'),
('276', '256', 'Sisira Pharmacy', 'Sisira Ph', 'Matara', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Matara', '0', '', NULL, '0', '', '0'),
('277', '257', 'Union Dispancery', 'Union Dispancery', 'Matara', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', 'Matara', '0', '', NULL, '0', '', '0'),
('278', '258', 'Hiruni Pharmacy', 'Hiruni Ph', 'Dikkwella,\nMatara.', '1', '13', '02', '2', '', '4510', '1200', '4500', '1', 'Dikkwella,\nMatara.', '0', '', NULL, '0', '', '0'),
('279', '259', 'Dr Nilanga Samarasinghe', 'Dr Nilanga Samarasinghe', 'Ragama Medical Center,\nEnderamulla', '1', '2', '02', '2', '', '4510', '1200', '4500', '1', 'Ragama Medical Center,\nEnderamulla', '0', '', NULL, '0', '', '0'),
('280', '260', 'Ashen Pharmacy', 'Ashen Pharmacy', 'Kelaniya', '1', '2', '02', '2', '', '4510', '1200', '4500', '1', 'Kelaniya', '0', '', NULL, '0', '', '0'),
('281', '261', 'Jeewanthi Pharmacy', 'Jeewanthi Pharmacy', '', '1', '14', '02', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('282', '262', 'Asini Pharmacy', 'Asini Pharmacy', 'Dompe', '1', '2', '02', '2', '', '4510', '1200', '4500', '1', 'Dompe', '0', '', NULL, '0', '', '0'),
('283', '263', 'Health palace', 'Health palace', 'Ampegama', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', 'Ampegama', '0', '', NULL, '0', '', '0'),
('284', '264', 'Westend Pharmacy', 'Westend Pharmacy', 'Megahathanna', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', 'Megahathanna', '0', '', NULL, '0', '', '0'),
('285', '265', 'We care Pharmacy', 'We care Pharmacy', 'China fort - Beruwala', '1', '5', '02', '2', '', '4510', '1200', '4500', '1', 'China fort - Beruwala', '0', '', NULL, '0', '', '0'),
('286', '266', 'Dr Damayanthi Gurusinha', 'Dr Damayanthi Gurusinha', 'Pituwala', '1', '13', '02', '2', '', '4510', '1200', '4500', '1', 'Pituwala', '0', '', NULL, '0', '', '0'),
('287', '267', 'Wimalasiri Pharmacy', 'Wimalasiri Pharmacy', 'Aluthwala', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Aluthwala', '0', '', NULL, '0', '', '0'),
('288', '268', 'Dr C Premajayantha', 'Dr C Premajayantha', 'Wattala', '1', '14', '02', '2', '', '4510', '1200', '4500', '1', 'Wattala', '0', '', NULL, '0', '', '0'),
('289', '269', 'Chathumina Pharmacy', 'Chathumina Pharmacy', 'Diwalapitiya', '1', '2', '02', '2', '', '4510', '1200', '4500', '1', 'Diwalapitiya', '0', '', NULL, '0', '', '0'),
('290', '270', 'Jiffy Products SL (PVT) LTD', 'Jiffy Products SL (PVT) LTD', 'Mirigama', '1', '6', '02', '2', '', '4510', '1200', '4500', '1', 'Mirigama', '0', '', NULL, '0', '', '0'),
('291', '271', 'The Muliti Stitch', 'The Muliti Stitch', 'Negombo', '1', '4', 'EV/S', '2', '', '4510', '1203', '4500', '1', 'Negombo', '0', '', NULL, '0', '', '0'),
('292', '272', 'Dr Saliva Bombuwala', 'Dr Saliva Bombuwala', 'Minuwangoda', '1', '2', '02', '2', '', '4510', '1200', '4500', '1', 'Minuwangoda', '0', '', NULL, '0', '', '0'),
('294', '274', 'Manadara resort (PVT) LTD', 'Manadara resort (PVT) LTD', 'De-fonseka Road,\nColombo 04.', '1', '4', 'EV/S', '2', '', '4510', '1200', '4500', '1', 'De-fonseka Road,\nColombo 04.', '0', '', NULL, '0', '', '0'),
('295', '275', 'LUMINEX PRIVATE LIMITED', 'LUMINEX PRIVATE LIMITED', 'Colombo', '1', '1', 'F04', '2', '', '4510', '1203', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('296', '276', 'J &amp; H Technologies (Pvt)Ltd.', 'J&amp;H', '#242k, level 2 Nawala Road,  \nNawala.', '1', '7', '02', '2', '4060', '4510', '1204', '4500', '1', '#242k, level 2 Nawala Road,  \nNawala.', '0', '', NULL, '0', '', '0'),
('297', '277', 'Abans PLC (Elite)', 'Abans PLC ', 'Mr. Chatura Jayawardena.\nSenior Brand Manager\n4th floor, Abans Head Office, \nNo. 498, Galle Road, Colombo 3,\nVAT No:104080065-7000\n', '1', '8', 'F04', '3', '', '4510', '1204', '4500', '1', 'Mr. Chatura Jayawardena.\nSenior Brand Manager\n4th floor, Abans Head Office, \nNo. 498, Galle Road, Colombo 3,\n', '0', '', NULL, '0', '', '0'),
('298', '278', 'Sonic Computers', 'Sonic Computers', 'No 50,\nStation Road,\nNugegoda', '1', '15', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 50,\nStation Road,\nNugegoda', '0', '', NULL, '0', '', '0'),
('299', '279', 'S S Pharmacy', 'S S Pharmacy', 'Naboda', '1', '13', 'G D', '1', '', '4510', '1200', '4500', '1', 'Naboda', '0', '', NULL, '0', '', '0'),
('300', '280', 'DR Danasiri Malliyawadu', 'DR Danasiri Malliyawadu', 'Naboda', '1', '13', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Naboda', '0', '', NULL, '0', '', '0');
INSERT INTO `0_cust_branch` VALUES
('301', '281', 'Samarasinaha PH', 'Samarasinaha PH', 'Pollgampola', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Pollgampola', '0', '', NULL, '0', '', '0'),
('302', '282', 'Star PH', 'Star PH', 'Kaluthara', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Kaluthara', '0', '', NULL, '0', '', '0'),
('303', '283', 'Gintota PH', 'Gintota PH', 'Galle road gintota', '1', '13', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Galle road gintota', '0', '', NULL, '0', '', '0'),
('304', '284', 'Pemachandra PH', 'Pemachandra PH', 'Kurudugaha', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Kurudugaha', '0', '', NULL, '0', '', '0'),
('305', '285', 'Elpitiya Medical food city', 'Elpitiya Medical food city', 'Elpitiya', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Elpitiya', '0', '', NULL, '0', '', '0'),
('306', '286', 'MIMS PH', 'MIMS PH', 'Waduraba', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Waduraba', '0', '', NULL, '0', '', '0'),
('307', '287', 'M/S Chandara PH', 'M/S Chandara PH', 'Yatlalamula', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Yatlalamula', '0', '', NULL, '0', '', '0'),
('308', '288', 'Dissanayaka PH', 'Dissanayaka PH', 'Neluwa', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Neluwa', '0', '', NULL, '0', '', '0'),
('309', '289', 'DR Arunlal', 'DR Arunlal', 'Panepitiya', '1', '5', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Panepitiya', '0', '', NULL, '0', '', '0'),
('310', '290', 'Dr P C Liyanage', 'Dr P C Liyanage', 'Welipitiya', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Welipitiya', '0', '', NULL, '0', '', '0'),
('311', '291', 'Sahana PH', 'Sahana PH', 'Telijjawila', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Telijjawila', '0', '', NULL, '0', '', '0'),
('312', '292', 'Sampath PH', 'Sampath PH', 'Ambalangoda', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Ambalangoda', '0', '', NULL, '0', '', '0'),
('313', '293', 'Dr D R K Sirisena', 'Dr D R K Sirisena', 'Karandeniya', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Karandeniya', '0', '', NULL, '0', '', '0'),
('314', '294', 'Sethsuwa PH', 'Sethsuwa PH', 'Agalawatha', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Agalawatha', '0', '', NULL, '0', '', '0'),
('315', '295', 'Ravi PH', 'Ravi PH', 'Ithapana', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Ithapana', '0', '', NULL, '0', '', '0'),
('316', '296', 'Stemm PH', 'Stemm PH', 'Tanipollgaha', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Tanipollgaha', '0', '', NULL, '0', '', '0'),
('317', '297', 'Sathren PH', 'Sathren PH', 'Galle', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('318', '298', 'Taridu PH', 'Taridu PH', 'Mirissa', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Mirissa', '0', '', NULL, '0', '', '0'),
('319', '299', 'Dr Nilantha Priyasana', 'Dr Nilantha Priyasana', 'Thalgaswela', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Thalgaswela', '0', '', NULL, '0', '', '0'),
('320', '300', 'Polegoda PH', 'Polegoda PH', 'Poligoda', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Poligoda', '0', '', NULL, '0', '', '0'),
('321', '301', 'Dr H A C Mangala', 'Dr H A C Mangala', 'Godapitiya', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Godapitiya', '0', '', NULL, '0', '', '0'),
('322', '302', 'Sehansa PH', 'Sehansa PH', 'Rathgama', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Rathgama', '0', '', NULL, '0', '', '0'),
('323', '303', 'Nayana PH', 'Nayana PH', 'Wathugedara', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Wathugedara', '0', '', NULL, '0', '', '0'),
('324', '304', 'Saranga PH', 'Saranga PH', 'Tawalama', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Tawalama', '0', '', NULL, '0', '', '0'),
('325', '305', 'Gayan PH', 'Gayan PH', 'Wetharawitha', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Wetharawitha', '0', '', NULL, '0', '', '0'),
('326', '306', 'Isiwara PH', 'Isiwara PH', 'Nagoda', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Nagoda', '0', '', NULL, '0', '', '0'),
('327', '307', 'New Supreem PH', 'New Supreem PH', 'Elpitiya', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Elpitiya', '0', '', NULL, '0', '', '0'),
('328', '308', 'Dr Keertisena vithanage', 'Dr Keertisena vithanage', 'Agalawaththa', '1', '13', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Agalawaththa', '0', '', NULL, '0', '', '0'),
('329', '309', 'Karapitiya Medical', 'Karapitiya Medical', 'Ampegama', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Ampegama', '0', '', NULL, '0', '', '0'),
('330', '310', 'Involve 360 PVT LTD', 'Involve 360 PVT LTD', 'Colombo', '1', '4', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('331', '311', 'Dilhani Chemist', 'Dilhani Chemist', 'Maggona', '1', '13', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Maggona', '0', '', NULL, '0', '', '0'),
('332', '312', 'Tritel Services Pvt. Ltd', 'tritel', 'No.19/4, Sri Saranankara Road,\nKalubowila,\nDehiwala.', '1', '4', '02', '2', '', '4510', '1203', '4500', '1', 'No.19/4, Sri Saranankara Road,\nKalubowila,\nDehiwala.', '0', '', NULL, '0', '', '0'),
('333', '313', 'Dr Sanath Pathirana', 'Dr Sanath Pathirana', 'Katarvila', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Katarvila', '0', '', NULL, '0', '', '0'),
('334', '314', 'Dr Menaka Widanapathirana', 'Dr Menaka Widanapathirana', 'Poraba', '1', '5', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Poraba', '0', '', NULL, '0', '', '0'),
('335', '315', 'Dr Krishantha Samaraweera', 'Dr Krishantha Samaraweera', 'Mallewa', '1', '2', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Mallewa', '0', '', NULL, '0', '', '0'),
('336', '316', 'Amila', 'Amila', 'Colombo', '1', '4', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('337', '317', 'Infinex Solutions (PVT) LTD', 'Infinex Solutions (PVT) LTD', '10 1/1 Unity place,\nColombo 3', '1', '4', 'DEF', '1', '', '4510', '1200', '4500', '1', '10 1/1 Unity place,\nColombo 3', '0', '', NULL, '0', '', '0'),
('338', '318', 'THUNDER &amp; NEON (PVT) LTD', 'THUNDER &amp; NEON (PVT) LTD', '191, Kasbewa road, werahera,Boralesgamuwa.', '1', '6', 'DEF', '2', '', '4510', '1203', '4500', '1', '191, Kasbewa road, werahera,Boralesgamuwa.', '0', '', NULL, '0', '', '0'),
('339', '319', 'Prasanna PH', 'Prasanna PH', 'Prasanna PH,\nWakwella road,\nGalle\n', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Prasanna PH,\nWakwella road,\nGalle\n', '0', '', NULL, '0', '', '0'),
('341', '321', 'Ashoka Chanal Center', 'Ashoka Chanal Center', 'Ashoka Chanal Center,\nBalapitiya', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Ashoka Chanal Center,\nBalapitiya', '0', '', NULL, '0', '', '0'),
('342', '322', 'Dr Manjula M Kumara', 'Dr Manjula M Kumara', 'Dr Manjula M Kumara,\nBeralihela', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Dr Manjula M Kumara,\nBeralihela', '0', '', NULL, '0', '', '0'),
('343', '323', 'Dr Ajith Kumara', 'Dr Ajith Kumara', 'Katharagama', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Katharagama', '0', '', NULL, '0', '', '0'),
('344', '324', 'Lisara PH', 'Lisara PH', 'Kataragama', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Kataragama', '0', '', NULL, '0', '', '0'),
('345', '325', 'Dr W Dissanayaka', 'Dr W Dissanayaka', 'Deberawewa', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Deberawewa', '0', '', NULL, '0', '', '0'),
('346', '326', 'Mr Udara Weerasinghe', 'Mr Udara Weerasinghe', 'Singhagiri(PVT)LTD\nNo 515,\nDarley Road,\nColombo 10', '1', '8', 'DEF', '1', '', '4510', '1203', '4500', '1', 'Singhagiri(PVT)LTD\nNo 515,\nDarley Road,\nColombo 10', '0', '', NULL, '0', '', '0'),
('347', '327', 'Priminto PH', 'Priminto PH', 'Mirigama', '1', '14', 'N P', '2', '', '4510', '1200', '4500', '1', 'Mirigama', '0', '', NULL, '0', '', '0'),
('348', '328', 'City School of Architecture', 'City school of Architecture', 'City School of Architecture Limited, \n120/7, Vidya Mawatha, \nColombo 07.', '1', '10', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'City School of Architecture Limited, \n120/7, Vidya Mawatha, \nColombo 07.', '0', '', NULL, '0', '', '0'),
('350', '330', 'Onet Solutions ', 'ONET', 'No 840,Thalagaha Junction,\nGothatuwa New Town\n', '1', '10', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 840,Thalagaha Junction,\nGothatuwa New Town\n', '0', '', NULL, '0', '', '0'),
('351', '331', 'Singhagiri Direct (Private ) Limited.', 'Sinhagiri', 'No. 515 ,\nDarley road ,\nColombo 10 .\n', '1', '8', 'DEF', '1', '', '4510', '1204', '4500', '1', 'No. 515 ,\nDarley road ,\nColombo 10 .\n', '0', '', NULL, '0', '', '0'),
('352', '277', 'Abans PLC', 'Abans PLC', 'Retail Division\n4th floor, Abans Head Office, \nNo. 498, Galle Road, Colombo 3,\n', '1', '8', 'F04', '3', '', '4510', '1204', '4500', '1', 'Retail Division\n4th floor, Abans Head Office, \nNo. 498, Galle Road, Colombo 3,\n', '0', '', NULL, '0', '', '0'),
('353', '332', 'Dr Hemantha Fernendo', 'Dr Hemantha Fernendo', 'katuneriya', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'katuneriya', '0', '', NULL, '0', '', '0'),
('354', '333', 'Senith PH', 'Senith PH', 'Akuressa Road\nBobahagoda', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Akuressa Road\nBobahagoda', '0', '', NULL, '0', '', '0'),
('355', '334', 'Intime PH', 'Intime PH', 'Dikkubura', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Dikkubura', '0', '', NULL, '0', '', '0'),
('356', '335', 'Awrasa Ph', 'Awrasa Ph', 'Bombuwala', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Bombuwala', '0', '', NULL, '0', '', '0'),
('357', '336', 'Suwamadura Ph', 'Suwamadura Ph', 'Mathugama', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Mathugama', '0', '', NULL, '0', '', '0'),
('358', '337', 'Dr Janaka Marasinghe', 'Dr Janaka Marasinghe', 'Agalawaththa', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Agalawaththa', '0', '', NULL, '0', '', '0'),
('359', '338', 'Dr Lasitha D Kannangara', 'Dr Lasitha D Kannangara', 'Warakagoda', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Warakagoda', '0', '', NULL, '0', '', '0'),
('360', '339', 'Chamara PH', 'Chamara PH', 'Galle', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('361', '340', 'Mahanama PH', 'Mahanama PH', 'No 67,\nNew Town,Lunugamwehera', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'No 67,\nNew Town,Lunugamwehera', '0', '', NULL, '0', '', '0'),
('362', '341', 'Samantna PH', 'Samantna PH', 'Miriswatha', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Miriswatha', '0', '', NULL, '0', '', '0'),
('363', '342', 'Medi Line PH', 'Medi Line PH', 'Katugoda', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Katugoda', '0', '', NULL, '0', '', '0'),
('364', '343', 'Samadara PH', 'Samadara PH', 'Matthaka', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Matthaka', '0', '', NULL, '0', '', '0'),
('365', '344', 'Suprem PH', 'Suprem PH', 'Meetiyagoda', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Meetiyagoda', '0', '', NULL, '0', '', '0'),
('366', '330', 'Onet1', 'Onet1', 'Onet Solutions 		\nNo.840, Thalagaha Junction,		\nGothatuwa New Town		\n   ', '1', '7', 'DEF', '2', '', '4510', '1204', '4500', '1', 'Onet Solutions 		\nNo.840,  Thalagaha Junction,		\nGothatuwa New Town		\n    \n', '2', '', NULL, '0', '', '0'),
('368', '346', 'UNICOLOMBO', 'University of Colombo', 'Institute of Human Resource Advancement,\nUniversity of Colombo\n275, Bauddhaloka Mawatha,\nColombo 7.', '1', '1', 'DEF', '2', '', '4510', '1203', '4500', '1', 'Institute of Human Resource Advancement,\nUniversity of Colombo\n275, Bauddhaloka Mawatha,\nColombo 7.', '0', '', NULL, '0', '', '0'),
('369', '347', 'Dr A J P Amitha', 'Dr A J P Amitha', 'Pannegamuwa', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Pannegamuwa', '0', '', NULL, '0', '', '0'),
('370', '348', 'Dr Dayarathna', 'Dr Dayarathna', 'Tanamallwela', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Tanamallwela', '0', '', NULL, '0', '', '0'),
('372', '350', 'City PH (Buttala)', 'City PH (Buttala)', 'No 03,\nBadaikumbura Road,\nButtala\n', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'No 03,\nBadaikumbura Road,\nButtala\n', '0', '', NULL, '0', '', '0'),
('373', '351', 'Cash', 'Cash', 'Colombo', '1', '26', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('374', '352', 'Dr Iresha Amarasinghe', 'Dr Iresha Amarasinghe', 'Berrolibela', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Berrolibela', '0', '', NULL, '0', '', '0'),
('375', '353', 'Dr D Kodithuwakku', 'Dr D Kodithuwakku', 'General Hospital Hambantota', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'General Hospital Hambantota', '0', '', NULL, '0', '', '0'),
('376', '354', 'Leo PH', 'Leo PH', 'Deberawawa', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Deberawawa', '0', '', NULL, '0', '', '0'),
('377', '355', 'Priya PH', 'Priya PH', 'Nagas Handiya,\nKalutara North', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Nagas Handiya,\nKalutara North', '0', '', NULL, '0', '', '0'),
('378', '356', 'Omedlak PH', 'Omedlak PH', 'Aluthgama', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Aluthgama', '0', '', NULL, '0', '', '0'),
('379', '357', 'Vidura PH', 'Vidura PH', 'Dewlapitiya road,\nBalapana', '1', '14', 'N P', '2', '', '4510', '1200', '4500', '1', 'Dewlapitiya road,\nBalapana', '0', '', NULL, '0', '', '0'),
('380', '358', 'Green Media Partners (pvt) Ltd', 'Green Media Partners (pvt) Ltd', '', '1', '4', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('381', '359', 'Pradeep PH', 'Pradeep PH', 'Rotuba', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Rotuba', '0', '', NULL, '0', '', '0'),
('382', '360', 'Mawarala PH', 'Mawarala PH', 'Mawarala', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Mawarala', '0', '', NULL, '0', '', '0'),
('383', '361', 'Sadaham PH', 'Sadaham PH', 'urubokka', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'urubokka', '0', '', NULL, '0', '', '0'),
('384', '362', 'Dr Chanaka Gayan', 'Dr Chanaka Gayan', 'Kirinda', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Kirinda', '0', '', NULL, '0', '', '0'),
('385', '363', 'Suwana PH', 'Suwana PH', 'Katharagama', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Katharagama', '0', '', NULL, '0', '', '0'),
('386', '364', 'New Medical Center', 'New Medical Center', 'Udugama', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Udugama', '0', '', NULL, '0', '', '0'),
('387', '365', 'Rajabojun (pvt) Ltd', 'Rajabojun (pvt) Ltd', 'Mr Mishantha Masinghe,\nDirector,\nRajabojun (pvt) Ltd,\nLiberty Arcade,\nColombo 03.', '1', '1', 'DEF', '2', '', '4510', '1203', '4500', '1', 'Mr Mishantha Masinghe,\nDirector,\nRajabojun (pvt) Ltd,\nLiberty Arcade,\nColombo 03.', '0', '', NULL, '0', '', '0'),
('388', '366', 'The Elanvital (Pvt) Ltd', 'The Elanvital (Pvt) Ltd', 'The Elanvital (Pvt) Ltd,\nNo28/2,\nBiyagama,\nSri Lanka', '1', '8', 'DEF', '2', '', '4510', '1204', '4500', '1', 'The Elanvital (Pvt) Ltd,\nNo28/2,\nBiyagama,\nSri Lanka', '0', '', NULL, '0', '', '0'),
('389', '367', 'C W Mackie PLC', 'C W Mackie PLC', 'C W Mackie PLC,\nReg No PQ 47,\n36,D.R Wijewardena Mawatha,\nColombo 10', '1', '10', 'EV/S', '3', '', '4510', '1204', '4500', '1', 'C W Mackie PLC,\nReg No PQ 47,\n36,D.R Wijewardena Mawatha,\nColombo 10', '0', '', NULL, '0', '', '0'),
('390', '368', 'Kalany Valley Canneries Ltd', 'Kalany Valley Canneries Ltd', 'Kalany Valley Canneries Ltd,\nNo-436,\nKaluaggala,\nHanwella', '1', '8', 'DEF', '2', '', '4510', '1204', '4500', '1', 'Kalany Valley Canneries Ltd,\nNo-436,\nKaluaggala,\nHanwella', '0', '', NULL, '0', '', '0'),
('391', '369', 'Dr Sampath', 'Dr Sampath', 'Dompe', '1', '2', 'N P', '2', '', '4510', '1200', '4500', '1', 'Dompe', '0', '', NULL, '0', '', '0'),
('392', '370', 'Shehan patherana', 'Shehan patherana', 'Colombo', '1', '4', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('393', '371', 'Manahara PH', 'Manahara PH', 'Wallawaya ', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Wallawaya ', '0', '', NULL, '0', '', '0'),
('394', '372', 'J.H PH', 'J.H PH', 'Thnipolgaha', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Thnipolgaha', '0', '', NULL, '0', '', '0'),
('395', '373', 'My Store .lk', 'mystore', 'Galle Road,\nColombo 4.', '1', '11', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Galle Road,\nColombo 4.', '0', '', NULL, '0', '', '0'),
('396', '374', 'R F R  Group', 'R F R  Group', 'Dubai', '1', '4', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Dubai', '0', '', NULL, '0', '', '0'),
('397', '375', 'Browns Hospitals', 'Browns Hospitals', 'Ragama', '1', '2', 'N P', '2', '', '4510', '1200', '4500', '1', 'Ragama', '0', '', NULL, '0', '', '0'),
('398', '376', 'The Golden Key Credit Card Company Limited', 'Golden Key', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('399', '377', 'Ushan PH', 'Ushan PH', 'Dodamgoda', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Dodamgoda', '0', '', NULL, '0', '', '0'),
('400', '378', 'Abans PLC (Dealer)', 'Aban PLC', 'Laleendra Brahmana\n498, Galle Road,\nColombo3.', '1', '8', 'F04', '1', '', '4510', '1204', '4500', '1', 'Laleendra Brahmana\n498, Galle Road,\nColombo3.', '0', '', NULL, '0', '', '0'),
('401', '379', 'Lanka Bell Ltd.', 'lankabell', 'No: 344, Galle road, Colombo 3 ', '1', '7', 'DEF', '2', '', '4510', '1204', '4500', '1', 'No: 344, Galle road, Colombo 3 ', '0', '', NULL, '0', '', '0'),
('402', '380', 'IC Collection (PVT) Ltd', 'IC Collection (PVT) Ltd', 'No 29,\nLauries Road,\nColombo 04', '1', '4', 'DEF', '2', '', '4510', '1200', '4500', '1', 'No 29,\nLauries Road,\nColombo 04', '0', '', NULL, '0', '', '0'),
('403', '381', 'New PH', 'New PH', 'Pugoda', '1', '14', 'N P', '2', '', '4510', '1200', '4500', '1', 'Pugoda', '0', '', NULL, '0', '', '0'),
('404', '382', 'Mobitel (Pvt)Ltd.', 'mobitel', 'Procurement Manager\n108, W. A. D. Ramanayake Mawatha,               \nColombo 02,\n', '1', '10', 'MOB  ', '3', '', '4510', '1204', '4500', '1', '108, W. A. D. Ramanayake Mawatha,               \nColombo 02,\n', '2', '', NULL, '0', '', '0'),
('406', '384', 'LGL Marketing Services (PVT) LTD', 'LGL Marketing', '45,katukurunduwatta Road,\nRatmalana', '1', '1', 'DEF', '2', '', '4510', '1203', '4500', '1', '45,katukurunduwatta Road,\nRatmalana', '0', '', NULL, '0', '', '0'),
('407', '385', 'Dr K K S Devika', 'Dr K K S Devika', '', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('408', '386', 'Bus Stand Shoping Comlex PH', 'Bus Stand Shoping Comlex PH', 'Ambalangoda', '1', '5', 'G D', '2', '', '4510', '1200', '4500', '1', 'Ambalangoda', '0', '', NULL, '0', '', '0'),
('409', '387', 'Sampath Jayawardhena', 'Sampath Jayawardhena', 'Colombo', '1', '8', 'DEF', '2', '', '4510', '1204', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('410', '388', 'City Cycle Industries', 'City Cycle Industries', 'Gall Road.\nPanadura', '1', '17', 'EV/S', '3', '', '4510', '1204', '4500', '1', 'Gall Road.\nPanadura', '0', '', NULL, '0', '', '0'),
('411', '389', 'Red Orchids Restaurant (Pvt) Ltd', 'Red Orchids Restaurant (Pvt)', 'De Fonseka Road \nColombo 04', '1', '4', 'EV/S', '2', '', '4510', '1203', '4500', '1', 'De Fonseka Road \nColombo 04', '0', '', NULL, '0', '', '0'),
('412', '390', 'Nimal Chemist', 'Nimal Chemist', 'Nimal Chemist,\nNo 90,\nMain Street,\nGalle', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Nimal Chemist,\nNo 90,\nMain Street,\nGalle', '0', '', NULL, '0', '', '0'),
('413', '391', 'Dr.T Edirisinghe', 'Dr.T Edirisinghe', 'Dr.T Edirisinghe,\nPannipitiya', '1', '13', 'N P', '2', '', '4510', '1200', '4500', '1', 'Dr.T Edirisinghe,\nPannipitiya', '0', '', NULL, '0', '', '0'),
('414', '392', 'Dr G.H.Amarasiri', 'Dr G.H.Amarasiri', 'Dr G.H.Amarasiri\nYatadola', '1', '13', 'G D', '2', '', '4510', '1200', '4500', '1', 'Dr G.H.Amarasiri\nYatadola', '0', '', NULL, '0', '', '0'),
('415', '393', 'Kahawatte Plantation', 'Kahawatte Plantation', 'Kahawatte Plantation,\nColombo', '1', '7', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Kahawatte Plantation,\nColombo', '0', '', NULL, '0', '', '0'),
('416', '394', 'Singhagiri (Pvt) Ltd.', 'Singhagiri(Pvt)', 'Colombo\n', '1', '8', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Colombo\n', '0', '', NULL, '0', '', '0'),
('417', '395', 'Feroz', 'Feroz', '', '1', '8', 'DEF', '2', '', '4510', '1204', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('418', '396', 'Mr Danushka', 'Mr Danushka', 'Matara', '1', '8', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Matara', '0', '', NULL, '0', '', '0'),
('419', '397', 'AMCOR', 'AMCOR', 'Colombo', '1', '1', 'DEF', '2', '', '4510', '1203', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('420', '398', 'DPJ Holdings', 'DPJ Holdings', 'Nawala', '1', '8', 'DEF', '1', '', '4510', '1200', '4500', '1', 'Nawala', '0', '', NULL, '0', '', '0'),
('421', '399', 'South Asia Pacific (PVT) Ltd', 'South Asia Pacific (PVT) Ltd', 'Colombo 04', '1', '8', 'DEF', '3', '', '4510', '1200', '4500', '1', 'Colombo 04', '0', '', NULL, '0', '', '0'),
('423', '401', 'MyDeal.lk (Pvt) Ltd', 'MyDeal', 'No 323,Galle Road,\nColombo 4', '1', '8', 'DEF', '2', '', '4510', '1200', '4500', '2', 'No 323,Galle Road,\nColombo 4', '0', '', NULL, '0', '', '0'),
('424', '402', 'Mydeal.lk (Pvt) Ltd.', 'Mydeal.lk (Pvt) Ltd.', '323, Galle Road, Colombo 00400', '1', '9', 'DEF', '1', '', '4510', '1203', '4500', '2', '323, Galle Road, Colombo 00400', '0', '', NULL, '0', '', '0'),
('425', '403', 'M-Town', 'M-Town', 'Mattegoda', '1', '8', 'DEF', '2', '', '4510', '1204', '4500', '2', 'Mattegoda', '0', '', NULL, '0', '', '0'),
('426', '404', 'Bookkeeping-AUS', 'Bookkeeping-AUS', 'Australia', '1', '4', 'DEF', '2', '', '4510', '1200', '4500', '2', 'Australia', '0', '', NULL, '0', '', '0'),
('427', '405', 'Wintech Cellular Services', 'Wintech Cellular Services', '159/1/3,\nMain Street,Colombo 11', '1', '8', 'DEF', '2', '', '4510', '1200', '4500', '2', '159/1/3,\nMain Street,Colombo 11', '0', '', NULL, '0', '', '0'),
('428', '406', 'Notrthshore College', 'Notrthshore College', '141, Church Road,\n  Colombo 15,\n  Sri Lanka.\n', '1', '18', 'EV/S', '2', '', '4510', '1203', '4500', '1', '141, Church Road,\n  Colombo 15,\n  Sri Lanka.\n', '0', '', NULL, '0', '', '0'),
('429', '407', 'The High Commission of Pakistan in Sri Lanka', 'The High Commission of Pakista', 'No. 42 &amp; 44, Bullers Ln,\nColombo 00700\nSri Lanka\n', '1', '8', 'DEF', '1', '', '4510', '1204', '4500', '2', 'No. 42 &amp; 44, Bullers Ln,\nColombo 00700\nSri Lanka\n', '0', '', NULL, '0', '', '0'),
('430', '408', 'Water Mart Systems', 'Water Mart', 'No 594,\nGalle Road,\nColombo 03', '1', '9', 'DEF', '2', '', '4510', '1203', '4500', '2', 'No 594,\nGalle Road,\nColombo 03', '0', '', NULL, '0', '', '0'),
('431', '409', ' Smart Solutions', ' Smart Solutions', 'No 10, \nSri darmarama road,\nDematagoda,\nColombo 09', '1', '8', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 10, \nSri darmarama road,\nDematagoda,\nColombo 09', '3', '', NULL, '0', '', '0'),
('432', '410', 'ABC Computers (PVT) Ltd', 'ABC Computers ', 'No 447,\nLipton Circus, \nColombo 2', '1', '8', 'DEF', '1', '', '4510', '1204', '4500', '2', 'No 447,\nLipton Circus, \nColombo 2', '0', '', NULL, '0', '', '0'),
('433', '411', 'Green Aircon (pvt) ltd', 'Green Aircon ', 'No 12\nParakumba Place,\nColombo 06', '1', '8', 'DEF', '1', '', '4510', '1204', '4500', '2', 'No 12\nParakumba Place,\nColombo 06', '0', '', NULL, '0', '', '0'),
('434', '412', 'Brantel Lanka (Pvt) Ltd', 'Brantel Lanka (Pvt) Ltd', 'No 06,\nR.A De Mel Mawatha,\nColombo 06', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 06,\nR.A De Mel Mawatha,\nColombo 06', '0', '', NULL, '0', '', '0'),
('435', '413', 'Favourite garment (PVT) Ltd', 'Favourite', 'The Landmark(level 6)', '1', '10', 'DEF', '3', '', '4510', '1200', '4500', '2', 'The Landmark(level 6)', '0', '', NULL, '0', '', '0'),
('436', '414', 'Millennium Airlines (PVT) Ltd', 'Millennium Airlines', 'Formerly Deccan Aviation Lanka,\nThe Landmark,level 06,\n385,Gall Road', '1', '10', 'DEF', '3', '', '4510', '1200', '4500', '2', 'Formerly Deccan Aviation Lanka,\nThe Landmark,level 06,\n385,Gall Road', '0', '', NULL, '0', '', '0'),
('437', '415', 'Regent Plaza (PVT) Ltd', 'Regent', 'The Landmark (Level 6),\n385,Gall Road, Colombo 03', '1', '10', 'DEF', '3', '', '4510', '1200', '4500', '2', 'The Landmark (Level 6),\n385,Gall Road, Colombo 03', '0', '', NULL, '0', '', '0'),
('438', '416', 'Favourite International (Pvt) Ltd', 'Favourite International', 'The Landmark,\n385,Gall road,\nColombo 03', '1', '10', 'DEF', '3', '', '4510', '1200', '4500', '2', 'The Landmark,\n385,Gall road,\nColombo 03', '0', '', NULL, '0', '', '0'),
('439', '417', 'Mitsu Mobiles Phones', 'Mitsu Mobiles ', 'No 227,\nGalle Road,\nColombo 04', '1', '8', 'DEF', '2', '', '4510', '1204', '4500', '2', 'No 227,\nGalle Road,\nColombo 04', '0', '', NULL, '0', '', '0'),
('440', '418', 'Taruja PH', 'Taruja PH', 'Galle ', '1', '13', 'G D', '1', '', '4510', '1200', '4500', '2', 'Galle ', '0', '', NULL, '0', '', '0'),
('441', '419', 'Special Task Force', 'Special Task Force', '223,\nBauddaloka Mawatha,\nColombo 07', '1', '8', 'DEF', '1', '', '4510', '1204', '4500', '2', '223,\nBauddaloka Mawatha,\nColombo 07', '0', '', NULL, '0', '', '0'),
('442', '420', 'celltronics Mega Store', 'celltronics ', '422/A\nGalle Road,\nColombo', '1', '11', '02', '2', '', '4510', '1204', '4500', '2', '422/A\nGalle Road,\nColombo', '0', '', NULL, '0', '', '0'),
('443', '421', 'Skills International (Pvt) Ltd', 'Skills International ', 'No 321,\nGalle Road,\nColombo 03', '1', '11', '02', '1', '', '4510', '1200', '4500', '2', 'No 321,\nGalle Road,\nColombo 03', '0', '', NULL, '0', '', '0'),
('444', '422', 'Flexiv Micro Systems (pvt) Ltd', 'Flexiv', '30/2,Jesmin park,\nNarahenpita Road,\nNawala', '1', '17', 'EV/S', '1', '', '4510', '1200', '4500', '1', '30/2,Jesmin park,\nNarahenpita Road,\nNawala', '0', '', NULL, '0', '', '0'),
('445', '423', 'Win Net', 'Win Net', 'Win Net, \nNugegoda', '1', '8', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Win Net, \nNugegoda', '0', '', NULL, '0', '', '0'),
('446', '424', 'Shanbe Jeane Corporation (Pvt) Ltd', 'Shanbe', 'No 07A,\nPostmasters Place\nTemple Road\nMt Lavinia\n ', '1', '11', '02', '1', '', '4510', '1204', '4500', '2', 'No 07A,\nPostmasters Place\nTemple Road\nMt Lavinia\n ', '0', '', NULL, '0', '', '0'),
('447', '425', 'JapanSoft', 'JapanSoft', 'No;05,\nJoseph&#039;s Street\nColombo 04\n', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'No;05,\nJoseph&#039;s Street\nColombo 04\n', '0', '', NULL, '0', '', '0'),
('448', '426', 'Vista Advertising &amp; Business Consultants (Pvt) Ltd', 'Vista Advertising', 'No;33,\n14th Lane,\nColombo 03.', '1', '8', '02', '2', '', '4510', '1204', '4500', '2', 'No;33,\n14th Lane,\nColombo 03.', '0', '', NULL, '0', '', '0'),
('449', '427', 'VCube', 'VCube', 'No:260/5,\nGalle Road, \nColombo-04', '1', '8', '02', '2', '', '4510', '1204', '4500', '2', 'No:260/5,\nGalle Road, \nColombo-04', '0', '', NULL, '0', '', '0'),
('450', '428', 'Agaya Holdings (PVT) LTD', 'Agaya', 'No 125/2, \n3rd Lane,\nNugegoda,\nSri Lanka.\n', '1', '11', 'EV/S', '1', '', '4510', '1204', '4500', '2', 'No 125/2, \n3rd Lane,\nNugegoda,\nSri Lanka.\n', '0', '', NULL, '0', '', '0'),
('451', '429', 'TVS Lanka Pvt ltd', 'TVS', 'Mr. Sudagaran,\nNo:38,\nOld Negombo Road,\nWattala,\nSri Lanka.\n', '1', '17', 'EV/S', '3', '', '4510', '1204', '4500', '1', 'Mr. Sudagaran,\nNo:38,\nOld Negombo Road,\nWattala,\nSri Lanka.\n', '0', '', NULL, '0', '', '0'),
('452', '430', 'Laugfs Supermarket (Pvt) Ltd', 'Laugfs', 'No 446,\nThalawathugoda Road ,\nMadiwela.', '1', '11', '02', '1', '', '4510', '1204', '4500', '2', 'No 446,\nThalawathugoda Road ,\nMadiwela.', '0', '', NULL, '0', '', '0'),
('453', '431', 'AB Fortune Technology Services Private Limited', 'AB Fortune', '5th Floor, SB Tower - 1, Sector 16, Noida\nUttar Pradesh\nINDIA - 201301\n', '1', '4', 'DEF', '2', '', '4510', '1203', '4500', '2', '5th Floor, SB Tower - 1, Sector 16, Noida\nUttar Pradesh\nINDIA - 201301\n', '0', '', NULL, '1', '', '0'),
('454', '432', 'Fine Tech PC', 'Fine Tech PC', 'Clinipath Buliding,\nFron of Temple Tree,\nNegambo Road,\nMinuwangoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Clinipath Buliding,\nFron of Temple Tree,\nNegambo Road,\nMinuwangoda', '0', '', NULL, '0', '', '0'),
('455', '433', 'ES Computer', 'ES Computer', 'No 12,\nPrivate Bus Stand,\nMawanella.', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'No 12,\nPrivate Bus Stand,\nMawanella.', '0', '', NULL, '0', '', '0'),
('456', '434', 'Isuru Celleulor', 'Isuru Celleulor', 'Kaduwela', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kaduwela', '0', '', NULL, '0', '', '0'),
('457', '435', 'Fedora E-Zone Computer', 'Fedora', 'No 07,\nMarket Place,\nKegalle', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'No 07,\nMarket Place,\nKegalle', '0', '', NULL, '0', '', '0'),
('458', '436', 'Dinuka Technologies (Pvt) Ltd', 'Dinuka Technologies', 'Delgoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Delgoda', '0', '', NULL, '0', '', '0'),
('459', '437', 'Senitro- IT (Pvt) Ltd', 'Senitro', 'Malabe', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Malabe', '0', '', NULL, '0', '', '0'),
('460', '438', 'ACP Solutions', 'ACP Solutions', 'Homagama', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Homagama', '0', '', NULL, '0', '', '0'),
('461', '439', 'i a t Computers', 'i a t Computers', 'Malabe', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Malabe', '0', '', NULL, '0', '', '0'),
('462', '440', 'Yasiru Creations', 'Yasiru Creations', 'Kotikawatte', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Kotikawatte', '0', '', NULL, '0', '', '0'),
('463', '441', 'Samarasinghe Solutions (Pvt) Ltd', 'Samarasinghe Solutions ', 'Kadawatha', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kadawatha', '0', '', NULL, '0', '', '0'),
('464', '442', 'Sky Computer &amp; Entertainment', 'Sky Computer', 'Ragama', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Ragama', '0', '', NULL, '0', '', '0'),
('465', '443', 'DYNTECH Enterprises ', 'DYNTECH ', 'Waththala', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Waththala', '0', '', NULL, '0', '', '0'),
('466', '444', 'MICRO BIT Computers', 'MICRO BIT ', 'Kadawatha', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kadawatha', '0', '', NULL, '0', '', '0'),
('467', '445', 'Susara Miusic &amp; Phones Repair Center', 'Susara Miusic &amp; Phones ', 'Nittabuwa', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Nittabuwa', '0', '', NULL, '0', '', '0'),
('468', '446', 'Soft Green Technology', 'Soft Green ', 'Nittabuwa', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Nittabuwa', '0', '', NULL, '0', '', '0'),
('469', '447', 'New Total Solutions', 'New Total Solutions', 'Malabe', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Malabe', '0', '', NULL, '0', '', '0'),
('470', '448', 'Mr Wijesekara', 'Mr Wijesekara', '', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', '', '0', '', NULL, '0', '', '0'),
('471', '449', 'Radiance Computer Systems', 'Radiance', 'Siyabalape', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Siyabalape', '0', '', NULL, '0', '', '0'),
('472', '450', 'Nitlan Technologies', 'Nitlan', 'Kaduwela', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kaduwela', '0', '', NULL, '0', '', '0'),
('473', '451', 'SNN Technologies', 'SNN Technologies', 'Weliweriya', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Weliweriya', '0', '', NULL, '0', '', '0'),
('474', '452', 'NJ Computers', 'NJ Computers', 'Weliweriya', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Weliweriya', '0', '', NULL, '0', '', '0'),
('475', '453', 'Asith Computers', 'Asith Computers', 'Yakkala\n', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Yakkala\n', '0', '', NULL, '0', '', '0'),
('476', '454', 'Neoview (Pvt) Ltd', 'Neoview ', 'Yakkala\n', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Yakkala\n', '0', '', NULL, '0', '', '0'),
('477', '455', 'Rajapaksha Communication', 'Rajapaksha Communication', 'Mawanella', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Mawanella', '0', '', NULL, '0', '', '0'),
('478', '456', 'E-Max Computer', 'E-Max Computer', 'Negambo', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Negambo', '0', '', NULL, '0', '', '0'),
('479', '457', 'New Seoul Trade Center', 'New Seoul Trade Center', 'Kiribathgoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kiribathgoda', '0', '', NULL, '0', '', '0'),
('480', '458', 'Sha Tech Zone', 'Sha Tech Zone', 'Kiribathgoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kiribathgoda', '0', '', NULL, '0', '', '0'),
('481', '459', 'Global Payments Asia Pacific Lanka(Pvt)Ltd', 'GlobalPayments', 'Advantage Building Complex\n4th Floor, 74A Dharmapala Mawatha\nColombo 7.', '1', '4', 'DEF', '2', '4045', '4045', '1230', '4045', '1', 'Advantage Building Complex\n4th Floor, 74A Dharmapala Mawatha\nColombo 7.', '0', '', NULL, '0', '', '0'),
('482', '460', 'The RainTree Hotel', 'The RainTree Hotel', 'Tissamaharama', '1', '4', 'DEF', '2', '', '4510', '1203', '4500', '1', 'Tissamaharama', '0', '', NULL, '0', '', '0'),
('483', '461', 'Abans PLC (Retail)', 'Abans PLC ', 'Mr. Chatura Jayawardena.\nSenior Brand Manager\n4th floor, Abans Head Office, \nNo. 498, Galle Road, Colombo 3,\nVAT No:104080065-7000', '1', '8', 'F04', '3', '', '4510', '1204', '4500', '1', 'Mr. Chatura Jayawardena.\nSenior Brand Manager\nAbans PLC\n4th floor, Abans Head Office, \nNo. 498, Galle Road, Colombo 3,', '0', '', NULL, '0', '', '0'),
('484', '462', 'P &amp; T Computers', 'P &amp; T Computers', 'Batapola', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Batapola', '0', '', NULL, '0', '', '0'),
('485', '463', 'NetCom Computer Services', 'Net Com', 'Minuwangoda', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Minuwangoda', '0', '', NULL, '0', '', '0'),
('486', '464', 'Ruwani Computers', 'Ruwani Computers', 'Ampawila', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Ampawila', '0', '', NULL, '0', '', '0'),
('487', '465', 'Sisith Printers', 'Sisith Printers', 'Katharagama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Katharagama', '0', '', NULL, '0', '', '0'),
('488', '466', 'A.G Computer &amp; Services', 'A.G Computer &amp; Services', 'Tissamaharama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Tissamaharama', '0', '', NULL, '0', '', '0'),
('489', '467', 'Mayura Phone Shop', 'Mayura Phone Shop', 'Tissamaharama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Tissamaharama', '0', '', NULL, '0', '', '0'),
('490', '468', 'The Asia Foundation', 'The Asia Foundation', 'No 30/1, \nBagatalle Rd,\nColombo 00300,\nSri Lanka.\n', '1', '11', '02', '1', '', '4510', '1204', '4500', '2', 'No 30/1, \nBagatalle Rd,\nColombo 00300,\nSri Lanka.\n', '0', '', NULL, '0', '', '0'),
('491', '469', 'Youth Computers Technology', 'Youth Computers ', 'Galle', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Galle', '0', '', NULL, '0', '', '0'),
('492', '470', 'J &amp; D Group', 'J &amp; D Group', '17/30, \n10th Mile Post,\nKatuwawala,\nBoralesgamuwa,\nSri Lanka.\n', '1', '17', 'EV/S', '3', '', '4510', '1204', '4500', '2', '17/30, \n10th Mile Post,\nKatuwawala,\nBoralesgamuwa,\nSri Lanka.\n', '0', '', NULL, '0', '', '0'),
('493', '471', 'Wheels Lanka Trading (Pvt) Ltd', 'Wheels Lanka', 'No 214,\nHigh level Road,\nKirulapone,\nColombo 06', '1', '17', 'EV/S', '3', '', '4510', '1204', '4500', '2', 'No 214,\nHigh level Road,\nKirulapone,\nColombo 06', '0', '', NULL, '0', '', '0'),
('494', '472', 'Malay Resturant', 'Malay Resturant', 'No 115,\nHill street,\nDehiwala,\nSri Lanka.\n', '1', '11', '02', '1', '', '4510', '1204', '4500', '2', 'No 115,\nHill street,\nDehiwala,\nSri Lanka.\n', '0', '', NULL, '0', '', '0'),
('495', '473', 'Global Payments Asia Pacific Lanka(Pvt)Ltd 01', 'GlobalPayments 01', 'Advantage Building Complex\n4th Floor, 74A Dharmapala Mawatha\nColombo 7.', '1', '4', 'DEF', '2', '4045', '4045', '1230', '4045', '1', 'Advantage Building Complex\n4th Floor, 74A Dharmapala Mawatha\nColombo 7.', '0', '', NULL, '0', '', '0'),
('496', '474', 'Abeywarna Phones', 'Abeywarna Phones', 'middeniya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Middeniya', '0', '', NULL, '0', '', '0'),
('497', '475', 'Three Star', 'Three Star', 'Galle', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Galle', '0', '', NULL, '0', '', '0'),
('498', '476', 'Beyond Technologies', 'Beyond Technologies', 'Dompe', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Dompe', '0', '', NULL, '0', '', '0'),
('499', '477', 'Global Investment House Ltd.', 'GloInvestments', 'Colombo 1.', '1', '4', 'DEF', '2', '4050', '4510', '1202', '4500', '1', 'Colombo 1.', '0', '', NULL, '0', '', '0'),
('500', '478', 'Digital Base Holdings (Pvt) Ltd.', 'Digital Base Holdings', 'No 03,\nDharmaraja Mawatha,\nOff Alfred House Avenue,\nColombo 03\nSri Lanka', '1', '11', '02', '2', '', '4510', '1204', '4500', '2', 'No 03,\nDharmaraja Mawatha,\nOff Alfred House Avenue,\nColombo 03\nSri Lanka', '0', '', NULL, '0', '', '0'),
('501', '479', 'Orange Computers', 'Orange Computers', 'Matugama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Matugama', '0', '', NULL, '0', '', '0'),
('502', '480', 'P C Technologies', 'P C Technologies', 'Middeniya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Middeniya\n', '0', '', NULL, '0', '', '0'),
('503', '481', 'Palliyaguru Marketing &amp; Technologies Service', 'Palliyaguru Marketing', 'Gampaha', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Gampaha', '0', '', NULL, '0', '', '0'),
('504', '482', 'Shan PC Partner', 'Shan PC', 'Dodangoda', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Dodangoda', '0', '', NULL, '0', '', '0'),
('505', '483', 'Galle Net Technologies', 'Galle Net ', 'Gonamulla', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Gonamulla', '0', '', NULL, '0', '', '0'),
('506', '484', 'IT Mart Computers', 'IT Mart ', 'Embilipitiya\n', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Embilipitiya\n', '0', '', NULL, '0', '', '0'),
('507', '485', 'Mega PC ', 'Mega PC ', 'Buttala', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Buttala', '0', '', NULL, '0', '', '0'),
('508', '486', 'K S Computers', 'K S Computers', 'Monaragala', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Monaragala', '0', '', NULL, '0', '', '0'),
('509', '487', 'Chipra Computers', 'Chipra Computers', 'Kirindiwela', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kirindiwela', '0', '', NULL, '0', '', '0'),
('510', '488', 'Tecno Lanka', 'Tecno Lanka', 'Kiribathgoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kiribathgoda', '0', '', NULL, '0', '', '0'),
('511', '489', 'NPS IT Gallery', 'NPS IT Gallery', 'Wennappuwa', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Wennappuwa', '0', '', NULL, '0', '', '0'),
('512', '490', 'Windicom Computers', 'Windicom Computers', 'Wennappuwa', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Wennappuwa', '0', '', NULL, '0', '', '0'),
('513', '491', 'Green Computers', 'Green Computers', 'Marawilla', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Marawilla', '0', '', NULL, '0', '', '0'),
('514', '492', 'Crest Business Computers', 'Crest Business Computers', 'Gampaha', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Gampaha', '0', '', NULL, '0', '', '0'),
('516', '494', 'e-Wis', 'e-Wis', 'No 329,\nGalle Road,\nColombo 04,\nSri Lanka', '1', '8', 'DEF', '2', '', '4510', '1204', '4500', '2', 'No 329,\nGalle Road,\nColombo 04,\nSri Lanka', '0', '', NULL, '0', '', '0'),
('517', '495', 'Recon Computers', 'Recon Computers', 'Dompe', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Dompe', '0', '', NULL, '0', '', '0'),
('518', '496', 'SriLucky Computers', 'SriLucky Computers', 'Nittabuwa', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Nittabuwa', '0', '', NULL, '0', '', '0'),
('519', '497', 'Stylish Computers', 'Stylish Computers', 'Kochchikade', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kochchikade', '0', '', NULL, '0', '', '0'),
('520', '498', 'Ruwi Mobiles', 'Ruwi Mobiles', 'Kirindiwela', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kirindiwela', '0', '', NULL, '0', '', '0'),
('521', '499', 'Dinidu PC Solutions', 'Dinidu PC Solutions', 'Pugoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Pugoda', '0', '', NULL, '0', '', '0'),
('522', '500', 'Nara IT Solutions', 'Nara IT Solutions', 'Minuwangoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Minuwangoda', '0', '', NULL, '0', '', '0'),
('523', '501', 'Prasad Computers', 'Prasad Computers', 'Mirigama', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Mirigama', '0', '', NULL, '0', '', '0'),
('524', '502', 'Global Computers', 'Global Computers', 'Gampaha', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Gampaha', '0', '', NULL, '0', '', '0'),
('525', '503', 'Way Detect Holdings', 'Way Detect Holdings', 'Kiribathgoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kiribathgoda', '0', '', NULL, '0', '', '0'),
('526', '504', 'Mark Computers', 'Mark Computers', 'Gannemulla', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Gannemulla', '0', '', NULL, '0', '', '0'),
('527', '505', 'Evident Computers', 'Evident Computers', 'Kiribathgoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kiribathgoda', '0', '', NULL, '0', '', '0'),
('528', '506', 'Makeen Books', 'Makeen Books', 'No 441,\nGalle Road,\nColombo - 03,\nSri Lanka.\n', '1', '11', 'DEF', '1', '', '4510', '1204', '4500', '2', 'No 441,\nGalle Road,\nColombo - 03,\nSri Lanka.\n', '0', '', NULL, '0', '', '0'),
('529', '507', 'Micro Print', 'Micro Print', 'Yakkala', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Yakkala', '0', '', NULL, '0', '', '0'),
('530', '508', 'Dnet Computers', 'Dnet Computers', 'Mirigama', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Mirigama', '0', '', NULL, '0', '', '0'),
('531', '509', 'Thilakarathna PC Center', 'Thilakarathna PC', 'Mirigama', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Mirigama', '0', '', NULL, '0', '', '0'),
('532', '510', 'N S Technologies', 'N S Technologies', 'Pasyala', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Pasyala', '0', '', NULL, '0', '', '0'),
('533', '511', 'Gate Way Computers', 'Gate Way Computers', 'Neluwa', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Neluwa', '0', '', NULL, '0', '', '0'),
('534', '512', 'Ranmuthu Computers', 'Ranmuthu Computers', 'Neluwa', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Neluwa', '0', '', NULL, '0', '', '0'),
('535', '513', 'SK Group (Pvt) Ltd', 'SK Group', 'Mathugama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Mathugama', '0', '', NULL, '0', '', '0'),
('536', '514', 'Ceylon IT Solutions', 'Ceylon IT', 'Rathgama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Rathgama', '0', '', NULL, '0', '', '0'),
('537', '515', 'Horisen Computers', 'Horisen Computers', 'Hambanthota', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Hambanthota', '0', '', NULL, '0', '', '0'),
('538', '516', 'B.S.K Cellular', 'B.S.K Cellular', 'Galle', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Galle', '0', '', NULL, '0', '', '0'),
('539', '517', 'V-TEC Computers', 'V-TEC Computers', 'Monaragala', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Monaragala', '0', '', NULL, '0', '', '0'),
('540', '518', 'RU Salu Clothing [PVT] Ltd', 'RU Salu Clothing ', 'No:640,\nGiriulla Road,\nKandawala,\nKatana,\nSri Lanka.\n', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No:640,\nGiriulla Road,\nKandawala,\nKatana,\nSri Lanka.\n', '0', '', NULL, '0', '', '0'),
('541', '519', 'Nanotek Computer Solutions', 'Nanotek Computer Solutions', 'NO 110A,\nGalle Road, \nDehiwala,\nSri Lanka.\n', '1', '11', 'DEF', '2', '', '4510', '1204', '4500', '2', 'NO 110A,\nGalle Road, \nDehiwala,\nSri Lanka.\n', '0', '', NULL, '0', '', '0'),
('542', '520', 'P C Needs', 'P C Needs', 'Pitabadda', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Pitabadda', '0', '', NULL, '0', '', '0'),
('543', '521', '3p Computer Technologies', '3p Computer Technologies', 'Morawaka', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Morawaka', '0', '', NULL, '0', '', '0'),
('544', '522', 'Tech Zone', 'Tech Zone', 'Pitabaddara', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Pitabaddara', '0', '', NULL, '0', '', '0'),
('545', '523', 'Morawaka Computers', 'Morawaka Computers', 'Morawaka', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Morawaka', '0', '', NULL, '0', '', '0'),
('546', '524', 'Shasika', 'Shasika', '125,\nDarmapala mawatha,\nColombo 07', '1', '11', 'DEF', '2', '', '4510', '1200', '4500', '2', '125,\nDarmapala mawatha,\nColombo 07', '0', '', NULL, '0', '', '0'),
('547', '525', 'Right Click Computers', 'Right Click Computers', 'Tellabuwa', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Tellabuwa', '0', '', NULL, '0', '', '0'),
('548', '526', 'Click Solutions', 'Click Solutions', 'Yakkalamulla', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Yakkalamulla', '0', '', NULL, '0', '', '0'),
('549', '527', 'Multi Computers &amp; Electronics', 'Multi Computers ', 'Yakkalamullla', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Yakkalamullla', '0', '', NULL, '0', '', '0'),
('550', '528', 'Aruna Computers', 'Aruna Computers', 'Makumbura', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Makumbura', '0', '', NULL, '0', '', '0'),
('552', '530', 'Computer Care Technology Center', 'C C Tech', 'Deniyaya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Deniyaya', '0', '', NULL, '0', '', '0'),
('553', '531', 'Venus E Cafe &amp; Solutions', 'Venus E Cafe ', 'Deniyaya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Deniyaya', '0', '', NULL, '0', '', '0'),
('554', '532', 'Data World Computers', 'Data World Computers', 'Deniyaya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Deniyaya', '0', '', NULL, '0', '', '0'),
('555', '533', 'P C Super Mart', 'P C Super Mart', 'Beralapanathara', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Beralapanathara', '0', '', NULL, '0', '', '0'),
('556', '534', 'Madhura Computer Shop', 'Madhura Computer Shop', 'Pasgoda', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Pasgoda', '0', '', NULL, '0', '', '0'),
('557', '535', 'Lakmal IT Solutions', 'Lakmal IT Solutions', 'Mawarala', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Mawarala', '0', '', NULL, '0', '', '0'),
('558', '536', 'PepperCube Consultants (Pvt) Limited', 'PepperCube Consultant', '20/43,\nFairfield Gardens,\nColombo 08,\nSri Lanka \n', '1', '8', 'EV/S', '1', '', '4510', '1204', '4500', '1', '20/43,\nFairfield Gardens,\nColombo 08,\nSri Lanka \n', '0', '', NULL, '0', '', '0'),
('559', '537', 'Mr.Suren Dharmaratne', 'Suren- Australia  Bookkeeping', 'Melbourne\nAustralia', '1', '12', 'DEF', '2', '4075', '4075', '1202', '4075', '1', 'Melbourne\nAustralia', '1', '', NULL, '0', '', '0'),
('560', '538', 'A Plus Technologies &amp; Communication', 'A Plus Technologies', 'Henegama', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Henegama', '0', '', NULL, '0', '', '0'),
('561', '539', 'Beeta Computers', 'Beeta Computers', 'Nittabuwa', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Nittabuwa', '0', '', NULL, '0', '', '0'),
('562', '540', 'Shenaya Holdings', 'Shenaya Holdings', 'Mirisswaththe', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Mirisswaththe', '0', '', NULL, '0', '', '0'),
('563', '541', 'Six D Solutions', 'Six D Solutions', 'Mirigama', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Mirigama', '0', '', NULL, '0', '', '0'),
('564', '542', 'Seya DVD House', 'Seya DVD House', 'Galle', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Galle', '0', '', NULL, '0', '', '0'),
('565', '543', 'sarasavi Computers', 'sarasavi Computers', 'Galle', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Galle', '0', '', NULL, '0', '', '0'),
('566', '544', 'Dimuthu Electronics', 'Dimuthu Electronics', '', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', '', '0', '', NULL, '0', '', '0'),
('567', '545', 'Abacus Computers', 'Abacus Computers', 'Galle', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Galle', '0', '', NULL, '0', '', '0'),
('568', '546', 'Richmond Hill Computers', 'Richmond Hill Computers', 'Galle', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Galle', '0', '', NULL, '0', '', '0'),
('569', '547', 'A N Computers', 'A N Computers', 'Galle', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Galle', '0', '', NULL, '0', '', '0'),
('570', '548', 'Mekala Computers', 'Mekala Computers', 'Galle', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('571', '549', 'Tilly  Computer Gadgets', 'Tilly  Computer', 'Marawilla', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Marawilla', '0', '', NULL, '0', '', '0'),
('572', '550', 'Insight Technologies ', 'Insight Technologies ', 'Hikkaduwa', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Hikkaduwa', '0', '', NULL, '0', '', '0'),
('573', '551', 'Eranga Computers', 'Eranga Computers', 'Uragaha', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Uragaha', '0', '', NULL, '0', '', '0'),
('574', '552', 'E-Win Computers', 'E-Win Computers', 'Uragasmanhandiya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Uragasmanhandiya', '0', '', NULL, '0', '', '0'),
('575', '553', 'Bandara Tecchnologies', 'Bandara Tecchnologies', 'Karandeniya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Karandeniya', '0', '', NULL, '0', '', '0');
INSERT INTO `0_cust_branch` VALUES
('576', '554', 'A &amp; G Technologies ', 'A &amp; G Technologies ', 'Tangalle', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Tangalle', '0', '', NULL, '0', '', '0'),
('577', '555', 'Cell World', 'Cell World', 'Aluthgama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Aluthgama', '0', '', NULL, '0', '', '0'),
('578', '556', 'RM Holdings (PVT) Ltd', 'RM Holdings', 'No 34,\nMendis Mawatha, \nNegombo,\nSri Lanka.\n', '1', '17', 'DEF', '4', '', '4510', '1204', '4500', '2', 'No 34,\nMendis Mawatha, \nNegombo,\nSri Lanka.\n', '0', '', NULL, '0', '', '0'),
('579', '557', 'R-CIS ', 'R-CIS ', 'Tissamaharama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Tissamaharama', '0', '', NULL, '0', '', '0'),
('580', '558', 'Boralessa Technologies', 'Boralessa Technologies', 'Monaragala', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Monaragala', '0', '', NULL, '0', '', '0'),
('581', '559', 'United Computers', 'United Computers', 'Puhulkotuwa', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Puhulkotuwa', '0', '', NULL, '0', '', '0'),
('582', '560', 'Danuka Celluler &amp; Computers', 'Danuka Celluler &amp; Computer', 'Ahangama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Ahangama', '0', '', NULL, '0', '', '0'),
('583', '561', 'Visual Computers', 'Visual Computers', 'Habaraduwa', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Habaraduwa', '0', '', NULL, '0', '', '0'),
('584', '562', 'Senara Technologies', 'Senara Technologies', 'Bogahagama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Bogahagama', '0', '', NULL, '0', '', '0'),
('585', '563', 'IDEAL Technologies', 'IDEAL Technologies', 'Naiwela', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Naiwela', '0', '', NULL, '0', '', '0'),
('586', '564', 'Comtec Computers', 'Comtec Computers', 'Kandana', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kandana', '0', '', NULL, '0', '', '0'),
('587', '565', 'K-Tech Trading', 'K-Tech Trading', 'Kandana', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kandana', '0', '', NULL, '0', '', '0'),
('588', '566', 'AMA Games', 'AMA Games', 'Kandana', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kandana', '0', '', NULL, '0', '', '0'),
('589', '567', 'Micro Sis', 'Micro Sis', 'Ja-Ela', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Ja-Ela', '0', '', NULL, '0', '', '0'),
('590', '568', 'Araliya Computers', 'Araliya Computers', 'Weligama', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Weligama', '0', '', NULL, '0', '', '0'),
('591', '569', 'CCTV Lanaka (PVT) Ltd', 'CCTV Lanaka', 'No 629 1/1,\nYanthampalawa,\nKurunegala.', '1', '15', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'No 629 1/1,\nYanthampalawa,\nKurunegala.', '0', '', NULL, '0', '', '0'),
('592', '570', 'Wislan Apparel', 'Wislan Apparel', 'No 93/2,\nPitawala Waththa,\nGampola Road,\nGelioya', '1', '15', 'EV/S', '2', '', '4510', '1203', '4500', '2', 'No 93/2,\nPitawala Waththa,\nGampola Road,\nGelioya', '0', '', NULL, '0', '', '0'),
('593', '571', 'Macstore', 'Macstore', '3rd floor,\nMajestic City, \nColombo 04.', '1', '11', 'EV/S', '2', '', '4510', '1204', '4500', '2', '3rd floor,\nMajestic City, \nColombo 04.', '0', '', NULL, '0', '', '0'),
('594', '572', 'EasyAds (Pvt) Ltd', 'EasyAds', 'No 225-A-2,\nIhala Karagahamuna,\nKadawatha,\nSri Lanka', '1', '8', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'No 225-A-2,\nIhala Karagahamuna,\nKadawatha,\nSri Lanka', '0', '', NULL, '0', '', '0'),
('595', '573', 'Nicstop Computer', 'Nicstop Computer', 'Kegalle', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kegalle', '0', '', NULL, '0', '', '0'),
('596', '574', 'Micro World', 'Micro World', 'Kaluthara', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Kaluthara', '0', '', NULL, '0', '', '0'),
('597', '575', 'Uni Tech PC', 'Uni Tech PC', 'Baduruliya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Baduruliya', '0', '', NULL, '0', '', '0'),
('598', '576', 'One IT, Australia', 'oneITAUS', 'Australia', '1', '10', 'DEF', '2', '', '4510', '1202', '4500', '1', 'Australia', '0', '', NULL, '0', '', '0'),
('599', '577', 'E-Mas Computers', 'E-Mas Computers', 'Negambo', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Negambo', '0', '', NULL, '0', '', '0'),
('600', '578', 'zMessenger (Pvt) Ltd', 'zMessenger ', 'No 121,\nHunupitiya Lake Road,\nColombo 02,\nSri Lanka', '1', '11', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'No 121,\nHunupitiya Lake Road,\nColombo 02,\nSri Lanka', '0', '', NULL, '0', '', '0'),
('601', '579', 'Sumithra Garments ( Pte ) Ltd', 'Sumithra Garments', 'No 33,\nThelangapatha Road,\nWattala,\nSri Lanka.\n', '1', '11', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'No 33,\nThelangapatha Road,\nWattala,\nSri Lanka.\n', '0', '', NULL, '0', '', '0'),
('602', '580', 'Chandrasiri Communications', 'Chandrasiri Communications', 'Katharagama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Katharagama', '0', '', NULL, '0', '', '0'),
('603', '581', 'P C Tech Computer system', 'P C Tech Computer system', 'Embilipitiya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Embilipitiya', '0', '', NULL, '0', '', '0'),
('604', '582', 'RD Computer Services (Pvt) Ltd', 'RD Computer Services', 'Minuwangoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Minuwangoda', '0', '', NULL, '0', '', '0'),
('605', '583', 'Game Soft', 'Game Soft', 'Ganemulla', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Ganemulla', '0', '', NULL, '0', '', '0'),
('606', '584', 'ComNet Computers', 'ComNet Computers', 'Gannemulla', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Gannemulla', '0', '', NULL, '0', '', '0'),
('607', '585', 'P C Friends', 'P C Friends', 'Nittambuwa', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Nittambuwa', '0', '', NULL, '0', '', '0'),
('608', '586', 'Soft Bios Technology', 'Soft Bios', 'Aluthwala', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Aluthwala', '0', '', NULL, '0', '', '0'),
('609', '587', 'Infortec Computers', 'Infortec Computers', 'Hikkaduwa', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Hikkaduwa', '0', '', NULL, '0', '', '0'),
('610', '588', 'Xenon Computers', 'Xenon Computers', 'Elpitiya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Elpitiya', '0', '', NULL, '0', '', '0'),
('611', '589', 'Gamage Computers', 'Gamage Computers', 'Tissamaharama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Tissamaharama', '0', '', NULL, '0', '', '0'),
('612', '590', 'Hiru Computers', 'Hiru Computers', 'Badalkumbura', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Badalkumbura', '0', '', NULL, '0', '', '0'),
('613', '591', 'Real Tec', 'Real Tec', 'Wellawaya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Wellawaya', '0', '', NULL, '0', '', '0'),
('614', '592', 'Silverline Information Technology (Pvt) Ltd', 'Silverline', 'No 85, \nDr.N.M.Perera Mawatha,\nColombo 08, \nSri Lanka.\n', '1', '15', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'No 85, \nDr.N.M.Perera Mawatha,\nColombo 08, \nSri Lanka.\n', '0', '', NULL, '0', '', '0'),
('615', '593', 'American College of Higher Education', 'American College', 'No: 23,\nHospital Road,\nDehiwala\nSri Lanka.\n', '1', '10', 'EV/S', '3', '', '4510', '1204', '4500', '2', 'No: 23,\nHospital Road,\nDehiwala\nSri Lanka.\n', '0', '', NULL, '0', '', '0'),
('616', '594', 'Mr. Ganeshan Prabakaran', 'Mr. Prabakaran', 'No 155/176,\nKalmunai,\nSri Lanka', '1', '15', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'No 155/176,\nKalmunai,\nSri Lanka', '0', '', NULL, '0', '', '0'),
('617', '595', 'Ceylon Business Appliances (Pvt) Ltd', 'CBA', 'No 112,\nReid Avenue,\nColombo - 04,\nSri Lanka.\n', '1', '8', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'No 112,\nReid Avenue,\nColombo - 04,\nSri Lanka.\n', '0', '', NULL, '0', '', '0'),
('618', '596', 'Old Joes Sports Club', 'Old Joes Sports Club', 'T.B Jaya Mawatha,\nColombo 10,\nSri Lanka', '1', '1', '02', '2', '', '4510', '1203', '4500', '2', 'T.B Jaya Mawatha,\nColombo 10,\nSri Lanka', '0', '', NULL, '0', '', '0'),
('619', '597', 'E-Net Computers', 'E-Net Computers', 'Kadawatha', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kadawatha', '0', '', NULL, '0', '', '0'),
('620', '598', 'Super Unique', 'Super Unique', 'Negambo', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Negambo', '0', '', NULL, '0', '', '0'),
('621', '599', 'Best Computers', 'Best Computers', 'Wennappuwa', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Wennappuwa', '0', '', NULL, '0', '', '0'),
('622', '600', 'Infonee', 'Infonee', 'Kaluthara', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Kaluthara', '0', '', NULL, '0', '', '0'),
('623', '601', 'N Gadgets', 'N Gadgets', 'Baduraliya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Baduraliya', '0', '', NULL, '0', '', '0'),
('624', '602', 'Dragon Computer Services', 'Dragon Computer Services', 'Aluthgama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Aluthgama', '0', '', NULL, '0', '', '0'),
('625', '603', 'P C World', 'P C World', 'Aluthgama', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Aluthgama', '0', '', NULL, '0', '', '0'),
('626', '604', 'PC &amp; Network Technologies', 'PC &amp; Network', 'Minuwangoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Minuwangoda', '0', '', NULL, '0', '', '0'),
('627', '605', 'Nilan Computers', 'Nilan Computers', 'Ragama', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Ragama', '0', '', NULL, '0', '', '0'),
('628', '606', 'Vihanga Technologies', 'Vihanga Technologies', 'Malabe', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Malabe', '0', '', NULL, '0', '', '0'),
('629', '607', 'Golden Way Computers', 'Golden Way', 'Urubokka', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Urubokka', '0', '', NULL, '0', '', '0'),
('630', '608', 'Okrich Computers', 'Okrich Computers', 'Middeniya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Middeniya', '0', '', NULL, '0', '', '0'),
('631', '609', 'S J Computers', 'S J Computers', 'Embilipitiya', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Embilipitiya', '0', '', NULL, '0', '', '0'),
('632', '610', 'BC Agro-Tronics (Pvt) Limited', 'BC Agro-Tronics ', 'Mr. Mark Allen Dirckze\nBC Agro-Tronics (Pvt) Limited\nNo 211/10,\nVeluwana Place,\nColombo 09.', '1', '1', '02', '2', '', '4510', '1203', '4500', '2', 'Mr. Mark Allen Dirckze\nBC Agro-Tronics (Pvt) Limited\nNo 211/10,\nVeluwana Place,\nColombo 09.', '0', '', NULL, '0', '', '0'),
('633', '611', 'Central Industries PLC', 'Central Industries', 'No:312\nNawala Rd,\nSri Jayawardenepura Kotte 10107,\nSri Lanka', '1', '4', 'F04', '2', '', '4510', '1203', '4500', '1', 'No:312\nNawala Rd,\nSri Jayawardenepura Kotte 10107,\nSri Lanka', '0', '', NULL, '0', '', '0'),
('634', '612', 'W.I. Tel Solutions (pvt) Ltd', 'W.I. Tel Solutions ', 'A: 27-1/3,\nYork Arcade Building,\nLayden Bastian Road,\nColombo 01\nSri Lanka.', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'A: 27-1/3,\nYork Arcade Building,\nLayden Bastian Road,\nColombo 01\nSri Lanka.', '0', '', NULL, '0', '', '0'),
('635', '613', 'Best Way Computers', 'Best Way', 'Kiribathgoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kiribathgoda', '0', '', NULL, '0', '', '0'),
('636', '614', 'Office Station', 'Office Station', 'Ja-Ela', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Ja-Ela', '0', '', NULL, '0', '', '0'),
('637', '615', 'M.C Computers', 'M.C Computers', 'Wennappuwa', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Wennappuwa', '0', '', NULL, '0', '', '0'),
('638', '616', 'Galaxy Technologies', 'Galaxy Technologies', 'Hikkaduwa', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Hikkaduwa', '0', '', NULL, '0', '', '0'),
('639', '617', 'K L Computers', 'K L Computers', 'Panadura', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Panadura', '0', '', NULL, '0', '', '0'),
('640', '618', 'G.M.S.Lanka Computers', 'G.M.S.Lanka', 'Induruwa Road ', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Induruwa Road ', '0', '', NULL, '0', '', '0'),
('641', '619', 'Abeyrathne Computers', 'Abeyrathne Computers', 'Induruwa', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Induruwa', '0', '', NULL, '0', '', '0'),
('642', '620', 'Tecno Computers', 'Tecno Computers', 'Baduraliya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Baduraliya', '0', '', NULL, '0', '', '0'),
('643', '621', 'NMN Computers', 'NMN Computers', 'Urubokka', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Urubokka', '0', '', NULL, '0', '', '0'),
('644', '622', 'E-Rats Technologies', 'E-Rats ', 'Mawanella', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Mawanella', '0', '', NULL, '0', '', '0'),
('645', '623', 'Peshala Computers', 'Peshala Computers', 'Dilulapitiya', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Dilulapitiya', '0', '', NULL, '0', '', '0'),
('646', '624', 'N &amp; N Computers', 'N &amp; N Computers', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('647', '625', 'Max Computers', 'Max Computers', 'Bus Stand-Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Bus Stand-Rathnapura', '0', '', NULL, '0', '', '0'),
('648', '626', 'S.P Mobile &amp; Computers', 'S.P Mobile &amp; Computers', 'Bus Stand Road,\nRathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Bus Stand Road,\nRathnapura', '0', '', NULL, '0', '', '0'),
('649', '627', 'Apple Computer &amp; Mobile', 'Apple Computer &amp; Mobile', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('650', '628', 'PC Net Computer Home', 'PC Net Computer Home', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('651', '629', 'Computer Home', 'Computer Home', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('652', '630', 'MicroNet Computers', 'MicroNet Computers', 'Main Street,\nRathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Main Street,\nRathnapura', '0', '', NULL, '0', '', '0'),
('653', '631', 'PREB Computers', 'PREB Computers', 'Kuruwita', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Kuruwita', '0', '', NULL, '0', '', '0'),
('654', '632', 'Razan Samsung Mobile', 'Razan Samsung Mobile', 'Kuruwita', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Kuruwita', '0', '', NULL, '0', '', '0'),
('655', '633', 'SeaCom International', 'SeaCom International', 'Kuruwita', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Kuruwita', '0', '', NULL, '0', '', '0'),
('656', '634', 'Eshantha Computer &amp; Cellular', 'Eshantha Computer &amp; Cellul', 'Parakaduwa', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Parakaduwa', '0', '', NULL, '0', '', '0'),
('657', '635', '777 Phone Arcade', '777 Phone Arcade', 'Ehaliyagoda', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Ehaliyagoda', '0', '', NULL, '0', '', '0'),
('658', '636', 'Sharp Computers', 'Sharp Computers', 'Eheliyagoda', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Eheliyagoda', '0', '', NULL, '0', '', '0'),
('659', '637', 'Imaya Computers', 'Imaya Computers', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('660', '638', 'Micro System Technologies ', 'Micro System Technologies ', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('661', '639', 'Win Max Computer &amp; Technologies', 'Win Max Computer', 'Awissawella', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Awissawella', '0', '', NULL, '0', '', '0'),
('662', '640', 'E Mart Computers', 'E Mart Computers', 'Kahawatta', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Kahawatta', '0', '', NULL, '0', '', '0'),
('663', '641', 'Swarna Communication', 'Swarna Communication', 'Kahawatta', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Kahawatta', '0', '', NULL, '0', '', '0'),
('664', '642', 'Chandrika Mobiles', 'Chandrika Mobiles', 'Kahawatta', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Kahawatta', '0', '', NULL, '0', '', '0'),
('665', '643', 'Susil Computer System', 'Susil Computer System', 'Kahawatte', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Kahawatte', '0', '', NULL, '0', '', '0'),
('666', '644', 'I Com', 'I Com', 'Eheliyagoda', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Eheliyagoda', '0', '', NULL, '0', '', '0'),
('667', '645', 'Smart Mobile', 'Smart Mobile', 'Eheliyagoda', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Eheliyagoda', '0', '', NULL, '0', '', '0'),
('669', '647', 'Capital Lands (Pvt) Ltd', 'Capital Lands (Pvt) Ltd', 'Colombo', '1', '4', '02', '2', '', '4510', '1200', '4500', '2', 'Colombo', '0', '', NULL, '0', '', '0'),
('670', '648', 'Galle Com Zone', 'Galle Com Zone', 'Wanduramba', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Wanduramba', '0', '', NULL, '0', '', '0'),
('671', '649', 'LandMark Computers', 'LandMark Computers', 'Pitigala', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Pitigala', '0', '', NULL, '0', '', '0'),
('672', '650', 'Ru Sanda Ras Computers', 'Ru Sanda Ras Computers', 'Palawaththe', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Palawaththe', '0', '', NULL, '0', '', '0'),
('673', '651', 'Micro City ', 'Micro City ', 'Kaluthara-South', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Kaluthara-South', '0', '', NULL, '0', '', '0'),
('674', '652', 'Thakshila Computers', 'Thakshila Computers', 'Nahalla', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Nahalla', '0', '', NULL, '0', '', '0'),
('675', '653', 'W.A Computers', 'W.A Computers', 'Horana', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Horana', '0', '', NULL, '0', '', '0'),
('676', '654', 'The IT Park', 'The IT Park', 'Kaluthara-South', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Kaluthara-South', '0', '', NULL, '0', '', '0'),
('677', '655', 'Seven Star Enterprices', 'Seven Star Enterprices', 'No 317/D\nOld Kottawa Road,\nEmbuldeniya,\nNugegoda.', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'No 317/D\nOld Kottawa Road,\nEmbuldeniya,\nNugegoda.', '0', '', NULL, '0', '', '0'),
('678', '656', 'MITECH Computer Systems (Pvt) Ltd', 'MI Tech', 'No 106,\nLower Ground Floor,\nUnity Plaza,\nColombo 04', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'No 106,\nLower Ground Floor,\nUnity Plaza,\nColombo 04', '0', '', NULL, '0', '', '0'),
('679', '657', 'Hiru.Com &amp; Phone Shop', 'Hiru.Com &amp; Phone Shop', 'Pasgoda', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Pasgoda', '0', '', NULL, '0', '', '0'),
('680', '658', 'Omega Computers', 'Omega Computers', 'Pitigala', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Pitigala', '0', '', NULL, '0', '', '0'),
('681', '659', 'My Way Computers', 'My Way Computers', 'Kirindiwela', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kirindiwela', '0', '', NULL, '0', '', '0'),
('682', '660', 'Sky Computers (Pvt) Ltd', 'Sky Computers (Pvt) Ltd', 'Mr.Roshan Fernando\nSt.Joeph?s Street,\nnegombo', '1', '2', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Mr.Roshan Fernando\nSt.Joeph?s Street,\nnegombo', '0', '', NULL, '0', '', '0'),
('683', '661', 'Max Pac (Pvt) Ltd', 'Max Pac (Pvt) Ltd', '1st Cross Street,\nPettah', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', '1st Cross Street,\nPettah', '0', '', NULL, '0', '', '0'),
('684', '662', 'Finlays Cold Storage (Pvt) Limited', 'Finlays Cold Storage', 'No 309/7,\nNegambo Road,\nWelisara', '1', '1', 'DEF', '2', '', '4510', '1203', '4500', '2', 'No 309/7,\nNegambo Road,\nWelisara', '0', '', NULL, '0', '', '0'),
('685', '663', 'Edulink International (Pvt) Ltd', 'Edulink', 'No 498,\nDe Mel Mawatha,\nColombo 03,\nSri Lanka', '1', '10', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 498,\nDe Mel Mawatha,\nColombo 03,\nSri Lanka', '0', '', NULL, '0', '', '0'),
('686', '664', 'PC Net Technologies', 'PC Net Technologies', 'Kollupitiya', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Kollupitiya', '0', '', NULL, '0', '', '0'),
('687', '665', 'Newgen Technologies', 'Newgen Technologies', 'Dankotuwa', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Dankotuwa', '0', '', NULL, '0', '', '0'),
('688', '666', 'Max Computers (Pvt) Ltd', 'Max Computers (Pvt) Ltd', 'Naththandiya', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Naththandiya', '0', '', NULL, '0', '', '0'),
('689', '667', 'Mr Dilan Fernando', 'Mr Dilan Fernando', 'NO 284B 1/1,\nBandaranayake Mawatha,\nKatubedda,\nMoratuwa', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'NO 284B 1/1,\nBandaranayake Mawatha,\nKatubedda,\nMoratuwa', '0', '', NULL, '0', '', '0'),
('690', '668', 'E Plus (Pvt) Ltd', 'E Plus (Pvt) Ltd', 'Mr Keerthi Jayakody\nNo L2-47,\nRealty Plaza,\nJa-Ela', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Mr Keerthi Jayakody\nNo L2-47,\nRealty Plaza,\nJa-Ela', '0', '', NULL, '0', '', '0'),
('691', '669', 'I Max Computers', 'I Max Computers', 'Badulla', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Badulla', '0', '', NULL, '0', '', '0'),
('692', '670', 'Creatives Computers (Pvt) Ltd', 'Creatives Computers', 'Kuliyapitiya', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Kuliyapitiya', '0', '', NULL, '0', '', '0'),
('693', '671', 'Inova IT Systems (Pvt) Ltd', 'Inova IT', 'No 5,\nSulaiman Terrace, \nColombo 5\n', '1', '8', 'EV/S', '3', '', '4510', '1204', '4500', '2', 'No 5,\nSulaiman Terrace, \nColombo 5\n', '0', '', NULL, '0', '', '0'),
('694', '672', 'P.C.S. Technologies', 'P.C.S. Technologies', 'Baddalkubura', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Baddalkubura', '0', '', NULL, '0', '', '0'),
('695', '673', 'PC House', 'PC House', 'Unity Plaza', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Unity Plaza', '0', '', NULL, '0', '', '0'),
('696', '674', 'Ramya Communications', 'Ramya Communications', 'Badulla', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Badulla', '0', '', NULL, '0', '', '0'),
('697', '675', 'Sybrain Computer Systems', 'Sybrain Computer', 'Badulla', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Badulla', '0', '', NULL, '0', '', '0'),
('698', '676', 'Computer City', 'Computer City', 'Bandarawela', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Bandarawela', '0', '', NULL, '0', '', '0'),
('699', '677', 'Horizon College International', 'Horizon College', 'Millenium Drive,\nChandrika Kumarathunga Mawatha,\nMalabe,\nSri Lanka.', '1', '20', 'EV/S', '2', '', '4510', '1203', '4500', '1', 'Millenium Drive,\nChandrika Kumarathunga Mawatha,\nMalabe,\nSri Lanka.', '0', '', NULL, '0', '', '0'),
('700', '678', 'Rovinta Electronics', 'Rovinta Electronics', 'Kiribathgoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kiribathgoda', '0', '', NULL, '0', '', '0'),
('701', '679', 'IML Private Limited (UPS)', 'IML Private Limited ', '', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', '', '0', '', NULL, '0', '', '0'),
('702', '680', 'H L De Mel &amp; Company (Pvt) Ltd', 'H L De Mel ', 'De Mel Building,\nNo 103,\nChatham Street,\nColombo', '1', '18', 'EV/S', '2', '', '4510', '1203', '4500', '2', 'De Mel Building,\nNo 103,\nChatham Street,\nColombo', '0', '', NULL, '0', '', '0'),
('703', '681', 'Seven Computers', 'Seven Computers', 'Kottawa', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Kottawa', '0', '', NULL, '0', '', '0'),
('704', '682', 'DOS Computers', 'DOS Computers', 'No 77/1,\nKandy road,\nwarakapola', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'No 77/1,\nKandy road,\nwarakapola', '0', '', NULL, '0', '', '0'),
('705', '683', 'Do Max Computers', 'Do Max Computers', 'Kalawana', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Kalawana', '0', '', NULL, '0', '', '0'),
('706', '684', 'Phone House', 'Phone House', 'Kalawana', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Kalawana', '0', '', NULL, '0', '', '0'),
('707', '685', 'Like Computer House', 'Like Computer', 'Ehaliyagoda', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Ehaliyagoda', '0', '', NULL, '0', '', '0'),
('708', '686', 'Niranjan Networks', 'Niranjan Networks', 'Badulla ', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Badulla ', '0', '', NULL, '0', '', '0'),
('709', '687', 'Herath Technicians', 'Herath Technicians', 'Bandarawela', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Bandarawela', '0', '', NULL, '0', '', '0'),
('710', '688', 'GIGAMAXZ Computers', 'GIGAMAXZ Computers', 'Bandarawela', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Bandarawela', '0', '', NULL, '0', '', '0'),
('711', '689', 'Star Net Computers', 'Star Net Computers', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('712', '690', 'Kingston computer technology', 'Kingston computers', 'Horana', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Horana', '0', '', NULL, '0', '', '0'),
('713', '691', 'Universal CAL-Computers', 'Universal Computers', 'Dodangoda', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Dodangoda', '0', '', NULL, '0', '', '0'),
('714', '692', 'New Gen Technologies', 'New Gen ', 'Mr Suresh,\nNattandiya Road,\nDankotuwa', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Mr Suresh,\nNattandiya Road,\nDankotuwa', '0', '', NULL, '0', '', '0'),
('715', '693', 'MEGA Computers', 'MEGA Computers', 'Tissamaharama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Tissamaharama', '0', '', NULL, '0', '', '0'),
('716', '694', 'NC Computers', 'NC Computers', 'Ahangama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Ahangama', '0', '', NULL, '0', '', '0'),
('717', '695', 'Lahiru Computers', 'Lahiru Computers', 'Neluwa', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Neluwa', '0', '', NULL, '0', '', '0'),
('718', '696', 'Pentech Technologies', 'Pentech', 'Neluwa', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Neluwa', '0', '', NULL, '0', '', '0'),
('719', '697', 'DSIT House', 'DSIT House', 'Negambo', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Negambo', '0', '', NULL, '0', '', '0'),
('720', '698', 'Matrix Technologies', 'Matrix Technologies', 'Weliweriya', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Weliweriya', '0', '', NULL, '0', '', '0'),
('721', '699', 'P.C House ', 'P.C House ', 'Hanwella', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Hanwella', '0', '', NULL, '0', '', '0'),
('722', '700', 'Dimuthu PC Solutions', 'Dimuthu PC Solutions', 'Kosgama', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Kosgama', '0', '', NULL, '0', '', '0'),
('723', '701', 'G.M Mobile &amp; Computers', 'G.M Mobile &amp; Computers', 'Koagama', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Koagama', '0', '', NULL, '0', '', '0'),
('724', '702', 'Venus Mobile', 'Venus Mobile', 'Eheliyagoda', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Eheliyagoda', '0', '', NULL, '0', '', '0'),
('725', '703', 'PERCY Studio', 'PERCY Studio', 'Kuruwita', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Kuruwita', '0', '', NULL, '0', '', '0'),
('726', '704', 'Chandana Studio', 'Chandana Studio', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('727', '705', 'Multi Technologies', 'Multi Technologies', 'Baduraliya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Baduraliya', '0', '', NULL, '0', '', '0'),
('728', '706', 'Visual Net Solution', 'Visual Net Solution', 'Kandy', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kandy', '0', '', NULL, '0', '', '0'),
('729', '707', 'Computerage (Pvt) Ltd', 'Computerage', 'Kandy', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kandy', '0', '', NULL, '0', '', '0'),
('730', '708', 'Modern Computer Systems', 'Modern Computer', 'Wattala', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Wattala', '0', '', NULL, '0', '', '0'),
('731', '709', 'Talent Computer Systems', 'Talent Computer', 'Kadawatha', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Kadawatha', '0', '', NULL, '0', '', '0'),
('732', '710', 'Chani Computer Institute', 'Chani Computer Institute', 'Hali ella', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Hali ella', '0', '', NULL, '0', '', '0'),
('733', '711', 'Arcit Cxee', 'Arcit Cxee', 'Bandarawela', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Bandarawela', '0', '', NULL, '0', '', '0'),
('734', '712', 'Infofix', 'Infofix', 'Bandarawela', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Bandarawela', '0', '', NULL, '0', '', '0'),
('735', '713', 'Falcon Degital Video', 'Falcon Degital Video', 'Bandarawela', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Bandarawela', '0', '', NULL, '0', '', '0'),
('736', '714', 'Win Tel Mobile Center', 'Win Tel Mobile Center', 'Balangoda', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Balangoda', '0', '', NULL, '0', '', '0'),
('737', '715', 'New Phone House', 'New Phone House', 'Balangoda', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Balangoda', '0', '', NULL, '0', '', '0'),
('738', '716', 'DM Computers', 'DM Computers', 'Balangoda', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Balangoda', '0', '', NULL, '0', '', '0'),
('739', '717', 'Mellow Computers', 'Mellow Computers', 'Balangoda', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Balangoda', '0', '', NULL, '0', '', '0'),
('740', '718', 'Feel Computers', 'Feel Computers', 'Balangoda', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Balangoda', '0', '', NULL, '0', '', '0'),
('741', '719', 'Mega Phone House &amp; Communication', 'Mega Phone House &amp; Communi', 'Balangoda', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Balangoda', '0', '', NULL, '0', '', '0'),
('742', '720', 'Uni Tec Computers', 'Uni Tec Computers', 'Avissawella', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Avissawella', '0', '', NULL, '0', '', '0'),
('743', '721', 'Everlight Chemicals (Prt)Ltd', 'Everlight ', 'Mr. Asif,\nEverlight Chemicals (Prt)Ltd,\n638, High Level Road,\nNugegoda,\nSri Lanka.', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Mr. Asif,\nEverlight Chemicals (Prt)Ltd,\n638, High Level Road,\nNugegoda,\nSri Lanka.', '0', '', NULL, '0', '', '0'),
('744', '722', 'Sinara Cellular', 'Sinara Cellular', 'Ratnapura ', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Ratnapura ', '0', '', NULL, '0', '', '0'),
('745', '723', 'Thuhansa Mobile', 'Thuhansa Mobile', 'Ratnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Ratnapura', '0', '', NULL, '0', '', '0'),
('746', '724', 'Smart Mobile ( Ratnapura)', 'Smart Mobile ( Ratnapura)', 'Ratnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Ratnapura', '0', '', NULL, '0', '', '0'),
('747', '725', 'Jayamee Phonekade', 'Jayamee Phonekade', 'Ratnapura ', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Ratnapura ', '0', '', NULL, '0', '', '0'),
('748', '726', 'AG Computers- Ampara', 'AG Computers- Ampara', 'Regal Junction \nAmpara', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Regal Junction \nAmpara', '0', '', NULL, '0', '', '0'),
('749', '727', 'Dammika Computers', 'Dammika Computers', 'Main Street,\nThanamalvila', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Main Street,\nThanamalvila', '0', '', NULL, '0', '', '0'),
('750', '728', 'S P C CONSULTANTS (PRIVATE) LIMITED', 'SPC', 'No: 69/04,\nJayarathna Mawatha,\nThimbirigasyaya,\nColombo 05.', '1', '10', 'EV/S', '3', '', '4510', '1204', '4500', '1', 'No: 69/04,\nJayarathna Mawatha,\nThimbirigasyaya,\nColombo 05.', '0', '', NULL, '0', '', '0'),
('751', '729', 'Content Management and Solutions (pvt) Ltd', 'CMS', 'Level 10,\nAccess Tower,\n278,\nUnion Place,\nColombo 02.', '1', '17', 'EV/S', '3', '', '4510', '1204', '4500', '1', 'Level 10,\nAccess Tower,\n278,\nUnion Place,\nColombo 02.', '0', '', NULL, '0', '', '0'),
('752', '730', 'City Mobile', 'City Mobile', 'palmadulla', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'palmadulla', '0', '', NULL, '0', '', '0'),
('753', '731', 'Max D Computers', 'Max D Computers', 'Ampara', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Ampara', '0', '', NULL, '0', '', '0'),
('754', '732', 'Nandana Computers', 'Nandana Computers', 'Palawaththa', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Palawaththa', '0', '', NULL, '0', '', '0'),
('755', '733', 'PC Software', 'PC Software', 'Mathugama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Mathugama', '0', '', NULL, '0', '', '0'),
('756', '734', 'Sri Lanka Navy Head Quarters', 'Sri Lanka Navy', 'Sri Lanka  Navy Headquarters\nP O Box 593,\nColombo 01', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Sri Lanka  Navy Headquarters\nP O Box 593,\nColombo 01', '0', '', NULL, '0', '', '0'),
('757', '735', 'CS Computers', 'CS Computers', 'Akuressa', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Akuressa', '0', '', NULL, '0', '', '0'),
('758', '736', 'Softlogic Phone Centre ', 'Softlogic Phone Centre ', 'Mr.Kaushal\nLiberty Showroom.', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', '', '0', '', NULL, '0', '', '0'),
('759', '737', 'U Computers ', 'U Computers ', 'Mr.Ishan Ravindra\nPitakotte. ', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', '', '0', '', NULL, '0', '', '0'),
('760', '738', 'Dinuka Cellulers &amp; Computers', 'Dinuka Cellulers &amp; Compute', 'Ahangama', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Ahangama', '0', '', NULL, '0', '', '0'),
('761', '739', 'Trrident Corporation (PVT) Ltd', 'Trrident ', 'No 297, 1st floor,\nUnion Place,Colombo 02,\nSri Lankan', '1', '18', '02', '2', '', '4510', '1203', '4500', '2', 'No 297, 1st floor,\nUnion Place,Colombo 02,\nSri Lankan', '0', '', NULL, '0', '', '0'),
('762', '740', 'Thakral One (PVT) Ltd', 'Thakral', 'No 297, \n1 st floor,\nUnion Place ,\nColombo 02,\nSri Lankan', '1', '18', 'DEF', '2', '', '4510', '1203', '4500', '2', 'No 297, \n1 st floor,\nUnion Place ,\nColombo 02,\nSri Lankan', '0', '', NULL, '0', '', '0'),
('763', '741', 'Futureworld lanka (Pvt) Ltd', 'Futureworld', '#02,\nR.A.De Mel Mawatha,\nColombo 05,\nSri lanka', '1', '18', 'DEF', '2', '', '4510', '1203', '4500', '2', '#02,\nR.A.De Mel Mawatha,\nColombo 05,\nSri lanka', '0', '', NULL, '0', '', '0'),
('764', '742', 'Vipula Computers', 'Vipula Computers', 'Horana', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Horana', '0', '', NULL, '0', '', '0'),
('765', '743', 'SuhaS Computers &amp; Mobile', 'SuhaS Computers', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('766', '744', 'M &amp; N Computers', 'M &amp; N Computers', 'Piliyandala', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Piliyandala', '0', '', NULL, '0', '', '0'),
('767', '745', 'Intelnet Computers', 'Intelnet Computers', 'Thalwila', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Thalwila', '0', '', NULL, '0', '', '0'),
('768', '746', 'E-Spring Technologies', 'E-Spring ', 'Negambo', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Negambo', '0', '', NULL, '0', '', '0'),
('769', '747', 'E Plus Computers', 'E Plus', 'Ja-Ela', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Ja-Ela', '0', '', NULL, '0', '', '0'),
('770', '748', 'Nil Nethu Computers', 'Nil Nethu', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('771', '749', 'Max Mo Computers', 'Max Mo', 'Chilaw', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Chilaw', '0', '', NULL, '0', '', '0'),
('772', '750', 'Smart IT', 'Smart IT', 'Ja-Ela', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Ja-Ela', '0', '', NULL, '0', '', '0'),
('773', '751', 'NeoN Computers (Pvt) Ltd', 'NeoN Computers ', 'Embilipitiya', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Embilipitiya', '0', '', NULL, '0', '', '0'),
('774', '752', 'Zaak Enterprises', 'Zaak Enterprises', 'No 147,\nMain Street,\nAnuradhapura', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'No 147,\nMain Street,\nAnuradhapura', '0', '', NULL, '0', '', '0'),
('775', '753', 'Tech Tool', 'Tech Tool', 'no 561/B/14 \nN S B Road,\nNew bus Stand,\nAnuradhapura', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'no 561/B/14 \nN S B Road,\nNew bus Stand,\nAnuradhapura', '0', '', NULL, '0', '', '0'),
('776', '754', 'Power PC (Pvt) Ltd', 'Power PC ', 'Anuradhapura', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Anuradhapura', '0', '', NULL, '0', '', '0'),
('777', '755', 'S J Computers (Anuradhapura)', 'S J Computers (Anuradhapura)', 'Anuradhapura', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Anuradhapura', '0', '', NULL, '0', '', '0'),
('778', '756', 'Build PC (Pvt) Ltd', 'Build PC ', 'Kurunegala', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Kurunegala', '0', '', NULL, '0', '', '0'),
('779', '757', 'GCT computer (Pvt) Ltd', 'GCT computer', 'Kurunegala', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Kurunegala', '0', '', NULL, '0', '', '0'),
('780', '758', 'Y Entertainment (Pvt) Ltd', 'Y Entertainment', 'Kurunegala', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Kurunegala', '0', '', NULL, '0', '', '0'),
('781', '759', 'Seoul Trading', 'Seoul Trading', 'Malabe', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Malabe', '0', '', NULL, '0', '', '0'),
('782', '760', 'AJ Medichem International (Pvt) Ltd', 'AJ Medichem', 'No 50, \nAlbion Lane\nColombo 00900,\nSri Lanka.', '1', '17', 'EV/S', '3', '', '4510', '1204', '4500', '2', 'No 50, \nAlbion Lane\nColombo 00900,\nSri Lanka.', '0', '', NULL, '0', '', '0'),
('783', '761', 'M.N.Computers', 'M.N.Computers', 'Galle', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Galle', '0', '', NULL, '0', '', '0'),
('784', '762', 'Malinda Computerss', 'Malinda Computerss', 'Anguruwathota', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Anguruwathota', '0', '', NULL, '0', '', '0'),
('785', '763', 'Rasika Computers', 'Rasika Computers', 'Horana', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Horana', '0', '', NULL, '0', '', '0'),
('786', '764', 'Extreme Computers', 'Extreme', 'Hatton', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Hatton', '0', '', NULL, '0', '', '0'),
('787', '765', 'P N D Mobile', 'P N D Mobile', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('788', '766', 'MLF Technologies', 'MLF Technologies', 'Welisara', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Welisara', '0', '', NULL, '0', '', '0'),
('790', '768', 'Ceylon Trading Company Limited', 'Ceylon Trading', 'The Accountant,\nP.O.box 161,\nNo 36,\nD.R.Wijewardena Mawatha,\nColombo 10', '1', '18', 'EV/S', '2', '', '4510', '1203', '4500', '2', 'The Accountant,\nP.O.box 161,\nNo 36,\nD.R.Wijewardena Mawatha,\nColombo 10', '0', '', NULL, '0', '', '0'),
('791', '769', 'T.N Computers', 'T.N Computers', 'Batuwaththa', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '2', 'Batuwaththa', '0', '', NULL, '0', '', '0'),
('792', '770', 'Swiss Hotel &amp; Queens Hotel', 'Swiss Hotel', 'Colombo', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Colombo', '0', '', NULL, '0', '', '0'),
('793', '771', 'Child Eye Hospital', 'Child Eye', 'Rajagiriya', '1', '17', 'EV/S', '3', '', '4510', '1204', '4500', '2', 'Rajagiriya', '0', '', NULL, '0', '', '0'),
('794', '772', 'Modeena Computers', 'Modeena', 'Giriulla', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Giriulla', '0', '', NULL, '0', '', '0'),
('795', '773', 'Soft Land PC', 'Soft Land PC', 'Maharagama', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Maharagama', '0', '', NULL, '0', '', '0'),
('796', '774', 'Tech Solutions', 'Tech Solutions', 'Maharagama', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Maharagama', '0', '', NULL, '0', '', '0'),
('797', '775', 'Computer Super Store', 'Computer Super Store', 'Giriulla', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Giriulla', '0', '', NULL, '0', '', '0'),
('798', '776', '3C Technologies', '3C Technologies', 'Malabe', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Malabe', '0', '', NULL, '0', '', '0'),
('799', '777', 'GTI Computers', 'GTI Computers', 'Poddiwela', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Poddiwela', '0', '', NULL, '0', '', '0'),
('800', '778', 'J And G Computers', 'J And G Computers', 'Deniyaya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Deniyaya', '0', '', NULL, '0', '', '0'),
('802', '780', 'Sahara Computers', 'Sahara Computers', 'Elpitiya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Elpitiya', '0', '', NULL, '0', '', '0'),
('803', '781', 'D.G.Constructions (Pvt) Ltd', 'D.G.Constructions', 'Naboda', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Naboda', '0', '', NULL, '0', '', '0'),
('804', '782', 'Asia Mobile Network', 'Asia Mobile', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '2', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('805', '783', 'Horizon Campus', 'Horizon Campus', 'No 482/B,\nMillennium Drive,\nChandrika Kumarathunga Mawatha,\nMalabe.', '1', '10', 'EV/S', '2', '', '4510', '1203', '4500', '1', 'No 482/B,\nMillennium Drive,\nChandrika Kumarathunga Mawatha,\nMalabe.', '0', '', NULL, '0', '', '0'),
('806', '784', 'Universal PC Systems', 'Universal PC', 'Galle', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('807', '785', 'Apalo Computers', 'Apalo Computers', 'Tangalle', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Tangalle', '0', '', NULL, '0', '', '0'),
('808', '786', 'Abeysekara Cellulars', 'Abeysekara Cellulars', 'Yatiyana', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Yatiyana', '0', '', NULL, '0', '', '0'),
('809', '787', 'e-Shop Computers', 'e-Shop Computers', 'Angunakolapalessa', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '2', 'Angunakolapalessa', '0', '', NULL, '0', '', '0'),
('810', '788', 'Infinity Solutions', 'Infinity Solutions', 'Kandy', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kandy', '0', '', NULL, '0', '', '0'),
('811', '789', 'EPG Technologies', 'EPG Technologies', 'Dehiwala', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Dehiwala', '0', '', NULL, '0', '', '0'),
('812', '790', 'EIM Tech Networks', 'EIM Tech', 'Galle Road \nDehiwala', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Galle Road \nDehiwala', '0', '', NULL, '0', '', '0'),
('813', '791', 'Friendly Computers', 'Friendly Computers', 'Rajagiriya', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Rajagiriya', '0', '', NULL, '0', '', '0'),
('814', '792', 'Nesh.lk', 'Nesh.lk', 'Colombo 04', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'Colombo 04', '0', '', NULL, '0', '', '0'),
('815', '793', 'T S Technologies (Pvt) Ltd.', 'T S Technologies', 'No.4 A 1/1,Dabare Mawatha,\nColombo 05.\nSri Lanka', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '2', 'No.4 A 1/1,Dabare Mawatha,\nColombo 05.\nSri Lanka', '0', '', NULL, '0', '', '0'),
('816', '794', 'E-Link Solutions', 'E-Link ', 'Ambalangoda Road,\nElpitiya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Ambalangoda Road,\nElpitiya', '0', '', NULL, '0', '', '0'),
('817', '795', 'D N Creative Systems', 'Creative Systems', 'Wattala', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Wattala', '0', '', NULL, '0', '', '0'),
('818', '796', 'Smart Tech Computers', 'Smart Tech Computers', 'Hendala Road,\nWattala', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Hendala Road,\nWattala', '0', '', NULL, '0', '', '0'),
('819', '797', 'Riytec Computers', 'Riytec Computers', 'Chilaw', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Chilaw', '0', '', NULL, '0', '', '0'),
('820', '798', 'Cell Net Cellular', 'Cell Net', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('821', '799', 'Adithya Cellular', 'Adithya Cellular', 'Bus Stand,\nRathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Bus Stand,\nRathnapura', '0', '', NULL, '0', '', '0'),
('822', '800', 'DCT computers', 'DCT computers', 'Mr chaminda samarasinghe\nNO. 1/B Ground Floor,\nWelikada Plaza,\nRajagiriya.\n', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Mr chaminda samarasinghe\nNO. 1/B Ground Floor,\nWelikada Plaza,\nRajagiriya.\n', '0', '', NULL, '0', '', '0'),
('823', '801', 'Riya Enterprises', 'Riya Enterprises', 'No. 12 B1,\nK.K.Street,\nPuttalam.\n', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No. 12 B1,\nK.K.Street,\nPuttalam.\n', '0', '', NULL, '0', '', '0'),
('824', '802', 'Sri Lanka Savings Bank', 'SLS', 'Senior Manager-IT\nNo 265,\nWard Place,\nColombo 07', '1', '12', 'EV/S', '2', '', '4510', '1203', '4500', '1', 'Senior Manager-IT\nNo 265,\nWard Place,\nColombo 07', '0', '', NULL, '0', '', '0'),
('825', '803', 'Systech solutions', 'Systech solutions', 'No 16/1/1\nOld Kottawa road, \nMirihana,\nNugegoda\n', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 16/1/1\nOld Kottawa road, \nMirihana,\nNugegoda\n', '0', '', NULL, '0', '', '0'),
('826', '804', 'Synergy Tech', 'Synergy Tech', 'Mr Rohana Perera\nNO 116/A,\nStanley Thilkarathne Mawatha, \nNugegoda.\n', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Mr Rohana Perera\nNO 116/A,\nStanley Thilkarathne Mawatha, \nNugegoda.\n', '0', '', NULL, '0', '', '0'),
('827', '805', 'DSL Computers', 'DSL Computers', 'No 155 D,\nHighlevel Road,\nMaharagama', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 155 D,\nHighlevel Road,\nMaharagama', '0', '', NULL, '0', '', '0'),
('828', '806', 'Netcore solutions', 'Netcore ', 'Maharagama', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Maharagama', '0', '', NULL, '0', '', '0'),
('829', '807', 'Bright Computers', 'Bright Computers', 'Kandy', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kandy', '0', '', NULL, '0', '', '0'),
('830', '808', 'Power Link Computers', 'Power Link', 'Kandy', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kandy', '0', '', NULL, '0', '', '0'),
('831', '809', 'IPK Computers', 'IPK Computers', 'Beliatta', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Beliatta', '0', '', NULL, '0', '', '0'),
('832', '810', 'HI-Tec Computers', 'HI-Tec', 'Sooriyawewa', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Sooriyawewa', '0', '', NULL, '0', '', '0'),
('833', '811', 'Galle Computers', 'Galle Computers', 'Galle', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('834', '812', 'South Net Computers', 'South Net ', 'Galle', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('835', '813', 'Globe international', 'Globe ', 'Kaduruwela,\npolonnaruwa', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Kaduruwela,\npolonnaruwa', '0', '', NULL, '0', '', '0'),
('836', '814', 'A &amp; M Computers &amp; Technologies', 'A &amp; M Computers', 'Gallella', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Gallella', '0', '', NULL, '0', '', '0'),
('837', '815', 'AIM Tech', 'AIM Tech', '', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('838', '816', 'Orient Computers', 'Orient ', 'No 626/A,\nPeradeniya Road,\nKandy', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'No 626/A,\nPeradeniya Road,\nKandy', '0', '', NULL, '0', '', '0'),
('839', '817', 'Data E Net Computer System (Pvt) Ltd', 'Data E Net', 'No 264,\nPeradeniya Road,\nKandy', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'No 264,\nPeradeniya Road,\nKandy', '0', '', NULL, '0', '', '0'),
('840', '818', 'PC Home Computer System', 'PC Home-Kandy', 'D S Senanayake Street,Kandy', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'D S Senanayake Street,Kandy', '0', '', NULL, '0', '', '0'),
('841', '819', 'May D Computers', 'May D-Darshana', 'No 09,\n4th Lane,\nAmpara', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'No 09,\n4th Lane,\nAmpara', '0', '', NULL, '0', '', '0'),
('842', '820', 'Encription IT', 'Encription IT', 'Bandaragama', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Bandaragama', '0', '', NULL, '0', '', '0'),
('843', '821', 'Future Shop', 'Future Shop', 'Union Place', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Union Place', '0', '', NULL, '0', '', '0'),
('844', '822', 'Hyper', 'Hyper', 'Moratuwa', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Moratuwa', '0', '', NULL, '0', '', '0'),
('845', '823', 'PC Doctor', 'PC Doctor', 'Baththaramulla', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Baththaramulla', '0', '', NULL, '0', '', '0'),
('846', '824', 'Tech', 'Tech', 'Baththaramulla', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Baththaramulla', '0', '', NULL, '0', '', '0'),
('847', '825', 'Future Shop-Primal', 'Future Shop-Primal', 'Kandana', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kandana', '0', '', NULL, '0', '', '0'),
('848', '826', 'Future Shop-Wattala', 'Future Shop-Wattala', 'Wattala', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Wattala', '0', '', NULL, '0', '', '0'),
('849', '827', 'IFix Computers', 'IFix Computers', 'Nittabuwa', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Nittabuwa', '0', '', NULL, '0', '', '0'),
('850', '828', 'Inter Web Computers', 'Inter Web Computers', 'Minuwangoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Minuwangoda', '0', '', NULL, '0', '', '0'),
('851', '829', 'PC Life Solutions', 'PC Life ', 'Divulapitiya', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Divulapitiya', '0', '', NULL, '0', '', '0');
INSERT INTO `0_cust_branch` VALUES
('852', '830', 'Menaka Computers', 'Menaka Computers', 'Beliaththa', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Beliaththa', '0', '', NULL, '0', '', '0'),
('853', '831', 'One Stop Computers', 'One Stop Computers', 'Tissamaharama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Tissamaharama', '0', '', NULL, '0', '', '0'),
('854', '832', 'Dot Net Computers', 'Dot Net ', 'Agalawaththa', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Agalawaththa', '0', '', NULL, '0', '', '0'),
('855', '833', 'Perovin Computers', 'Perovin Computers', 'Mathugama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Mathugama', '0', '', NULL, '0', '', '0'),
('856', '834', 'A Plus Computers', 'A Plus Computers', 'Matara', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Matara', '0', '', NULL, '0', '', '0'),
('857', '835', 'Sha Mobile', 'Sha Mobile', 'No 83,New Shopping Complex,\nPellmadulla', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'No 83,New Shopping Complex,\nPellmadulla', '0', '', NULL, '0', '', '0'),
('858', '836', 'Micro Solutions', 'Micro Solutions', 'No 63,\ncanel road\nPuliyankulama\nAnuradhapura\n', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 63,\ncanel road\nPuliyankulama\nAnuradhapura\n', '0', '', NULL, '0', '', '0'),
('859', '837', 'My computer technologies', 'My computer', 'No 43/A \nBodiraja Mawatha\nKurunegala', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'No 43/A \nBodiraja Mawatha\nKurunegala', '0', '', NULL, '0', '', '0'),
('860', '838', 'The Office Shop (Pvt) Ltd', 'Office Shop', '', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('861', '839', 'Power Tec Computers', 'Power Tec', 'Walasmulla', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Walasmulla', '0', '', NULL, '0', '', '0'),
('862', '840', 'Sunquick Lanka (Pvt) Ltd.', 'Sunquick', 'Rathnapura Road,\nMunagama,\nHorana,\nSri Lanka\n', '1', '17', 'EV/S', '2', '', '4510', '1203', '4500', '1', 'Rathnapura Road,\nMunagama,\nHorana,\nSri Lanka\n', '0', '', NULL, '0', '', '0'),
('863', '841', 'P.C.Palace', 'P.C.Palace', 'Horana', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Horana', '0', '', NULL, '0', '', '0'),
('864', '842', 'Smart Tech-Morawaka', 'Smart Tech-Morawaka', 'Morawaka', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Morawaka', '0', '', NULL, '0', '', '0'),
('865', '843', 'Sonash Cellular &amp; CD House', 'Sonash Cellular', 'Kotapola', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Kotapola', '0', '', NULL, '0', '', '0'),
('866', '844', 'Geotech Computers', 'Geotech Computers', 'Wanduramba', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Wanduramba', '0', '', NULL, '0', '', '0'),
('867', '845', 'Pitigala Computers', 'Pitigala Computers', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('868', '846', 'Diyatha Lanka Computers', 'Diyatha Lanka', 'Panadura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Panadura', '0', '', NULL, '0', '', '0'),
('869', '848', 'The D Tech Computers', 'The D Tech', 'Pallebedda', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Pallebedda', '0', '', NULL, '0', '', '0'),
('870', '849', 'Sagara Mobile &amp; Computer World', 'Sagara Mobile &amp; Computer', 'Embilipitiya', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Embilipitiya', '0', '', NULL, '0', '', '0'),
('871', '850', 'H D K IT (Pvt) Ltd', 'H D K IT', 'Embilipitiya', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Embilipitiya', '0', '', NULL, '0', '', '0'),
('872', '851', 'DCS Computers', 'DCS Computers', 'NSB Road,\nNew Town,\nAnuradhapura', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'NSB Road,\nNew Town,\nAnuradhapura', '0', '', NULL, '0', '', '0'),
('873', '852', 'SK Computers', 'SK Computers-Kuliyapitiya', 'Kuliyapitiya', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kuliyapitiya', '0', '', NULL, '0', '', '0'),
('874', '853', 'Micro business solutions', 'Micro business', 'Puliyankulam,\nAnuradhapura ', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Puliyankulam,\nAnuradhapura ', '0', '', NULL, '0', '', '0'),
('875', '854', 'Adam Inovations Co; Ltd', 'adam-i', '105-0004\nLevel 4, Shimbashi Annex Bld, 5-35-10, Shimbashi, Minato-ku,\nTokyo 105-0004 JAPAN', '1', '19', 'EV/S', '2', '4040', '4510', '1202', '4500', '1', '105-0004\nLevel 4, Shimbashi Annex Bld, 5-35-10, Shimbashi, Minato-ku,\nTokyo 105-0004 JAPAN', '2', 'Please remit payments to :\nSampath Bank Plc. Colombo\nUSD A/C No: 5001 1900 0133  \nSWIFT CODE : BSAMLKLX', NULL, '0', '', '0'),
('876', '855', 'Phone Expert', 'Phone Expert', 'Kegalle', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kegalle', '0', '', NULL, '0', '', '0'),
('877', '856', 'S S S Phone Shop', 'S S S Phone Shop', 'Weerakatiya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Weerakatiya', '0', '', NULL, '0', '', '0'),
('878', '857', 'Indika computers', 'Indika computers', 'Weerakatiya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Weerakatiya', '0', '', NULL, '0', '', '0'),
('879', '858', 'Supreem Computers', 'Supreem Computers', 'Hokandara', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Hokandara', '0', '', NULL, '0', '', '0'),
('880', '859', 'C S Electronics', 'C S Electronics', 'Walasmulla', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Walasmulla', '0', '', NULL, '0', '', '0'),
('881', '860', 'Laptronics Lanka', 'Laptronics', 'Galle Road,\nColombo 04', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Galle Road,\nColombo 04', '0', '', NULL, '0', '', '0'),
('882', '861', 'Future Shop-Kosala', 'Future Shop-Kosala', 'Biyagama', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Biyagama', '0', '', NULL, '0', '', '0'),
('883', '862', 'C &amp; J Computers', 'C &amp; J Computers', 'Embilipitiya', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Embilipitiya', '0', '', NULL, '0', '', '0'),
('884', '863', 'Uditha Enterprices', 'Uditha Enterprices', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('885', '864', 'K iss Technologies', 'K iss Technologies', 'Pelmadulla', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Pelmadulla', '0', '', NULL, '0', '', '0'),
('886', '865', 'SNC Computer &amp; Commiunication', 'SNC Computer &amp; Commiunicat', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('887', '867', 'Final Solution Technologies', 'Final Solution', 'Delgoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Delgoda', '0', '', NULL, '0', '', '0'),
('888', '869', 'Hansa Technologies', 'Hansa Technologies', 'Gampaha', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Gampaha', '0', '', NULL, '0', '', '0'),
('889', '870', 'E-Max Computers-Darga Town', 'E-Max Computers-Darga Town', 'Darga Town', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Darga Town', '0', '', NULL, '0', '', '0'),
('890', '871', 'Shirtworks (Pvt) Ltd', 'Shirtworks', 'No 104/4,\nDehiwala Road,\nMaharagama', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 104/4,\nDehiwala Road,\nMaharagama', '0', '', NULL, '0', '', '0'),
('891', '872', 'East Asian International (Pvt) Ltd', 'East Asian International', 'No 36/3,\nWoodland Avenue,\nKohuwala,Nugegoda,\nSri Lanka', '1', '12', 'EV/S', '2', '', '4510', '1203', '4500', '1', 'No 36/3,\nWoodland Avenue,\nKohuwala,Nugegoda,\nSri Lanka', '0', '', NULL, '0', '', '0'),
('892', '873', 'Access Natural Water (Pvt) Ltd', 'Access Natural ', 'N0. 278,\nUnion Place,\nColombo 02', '1', '15', 'EV/S', '2', '', '4510', '1203', '4500', '1', 'N0. 278,\nUnion Place,\nColombo 02', '0', '', NULL, '0', '', '0'),
('893', '874', 'VOLLKART PVT LTD', 'VOLLKART', 'Mohamed Azmeel\nVollKart\n[Street Address]\nMale&#039; , Maldives\n\n', '1', '20', 'DEF', '2', '', '4510', '1202', '4500', '1', 'Mohamed Azmeel\nVollKart\n[Street Address]\nMale&#039; , Maldives\n\n', '2', '', NULL, '0', '', '0'),
('894', '875', 'Circa Technology services', 'Circa Technology ', 'No 172/B,\nBorella road,\nThalawathugoda', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 172/B,\nBorella road,\nThalawathugoda', '0', '', NULL, '0', '', '0'),
('895', '876', 'AZ Associates', 'AZ Associates', 'Colombo', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('896', '877', 'Mac Tec', 'Mac Tec', 'No 39/3,\nGalle road,\nFortune arcade (opposite MC),\nCOL-04\n', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 39/3,\nGalle road,\nFortune arcade (opposite MC),\nCOL-04\n', '0', '', NULL, '0', '', '0'),
('897', '878', 'ACER Com House', 'ACER', 'Siyabalapitiya', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Siyabalapitiya', '0', '', NULL, '0', '', '0'),
('898', '879', 'Horizon College International', 'Horizon College-F Secure', 'Millenium Drive,\nChandrika Kumarathunga Mawatha,\nMalabe,\nSri Lanka.', '1', '10', 'EV/S', '3', '', '4510', '1204', '4500', '1', 'Millenium Drive,\nChandrika Kumarathunga Mawatha,\nMalabe,\nSri Lanka.', '0', '', NULL, '0', '', '0'),
('899', '880', 'NS Digital (Pvt) Ltd', 'NS Digital', 'Piliyandala', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Piliyandala', '0', '', NULL, '0', '', '0'),
('900', '881', 'Braclays (Pvt) Ltd', 'Braclays', 'Unity Plaza', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Unity Plaza', '0', '', NULL, '0', '', '0'),
('901', '882', 'Sampath Information Technology Solutions (Pvt) Ltd', 'Sampath IT', 'No 293,\nR.A.D Mel Mawatha,\nColombo 03', '1', '10', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 293,\nR.A.D Mel Mawatha,\nColombo 03', '0', '', NULL, '0', '', '0'),
('902', '883', 'Mr.Shehan', 'Mr.Shehan', 'Colombo', '1', '8', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('903', '884', 'Chanz IT', 'Chanz IT', 'Mahabage', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Mahabage', '0', '', NULL, '0', '', '0'),
('904', '885', 'Galle Mobile', 'Galle Mobile', 'Udugama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Udugama', '0', '', NULL, '0', '', '0'),
('905', '886', 'One Click Computers', 'One Click Computers', 'Matara', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Matara', '0', '', NULL, '0', '', '0'),
('906', '887', 'Sahasra Computers', 'Sahasra Computers', 'Elpitiya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Elpitiya', '0', '', NULL, '0', '', '0'),
('907', '888', 'Dr.Chanaka Gayan', 'Dr.Chanaka Gayan', 'Walasmulla', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Walasmulla', '0', '', NULL, '0', '', '0'),
('908', '889', 'Ranmark Computers ', 'Ranmark Computers ', 'Middeniya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Middeniya', '0', '', NULL, '0', '', '0'),
('909', '890', 'Nex Computers', 'Nex Computers', 'Kurunegala', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Kurunegala', '0', '', NULL, '0', '', '0'),
('910', '891', 'P Tec Computer Service Centre', 'P Tec Computer', 'Kurunegala', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Kurunegala', '0', '', NULL, '0', '', '0'),
('911', '892', 'Digital Tag Training (Pvt) Ltd', 'Digital Tag (PC Hut)', 'Kurunegala', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Kurunegala', '0', '', NULL, '0', '', '0'),
('912', '893', 'Millenium Phone House', 'Millenium Phone House', 'Kuruwita', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Kuruwita', '0', '', NULL, '0', '', '0'),
('913', '894', 'MG Mobile &amp; Video', 'MG Mobile &amp; Video', 'Kuruwita', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Kuruwita', '0', '', NULL, '0', '', '0'),
('914', '896', 'Abans PLC - Computer Sales Division', 'Abans - Computer Sales ', 'No 18,\nCharles Drives,\nDuplication Road,\nColombo 03', '1', '21', 'F04', '2', '', '4510', '1204', '4500', '1', 'No 18,\nCharles Drives,\nDuplication Road,\nColombo 03', '0', '', NULL, '0', '', '0'),
('915', '897', 'Ultrium Technologies (Pvt) Ltd', 'Ultrium', '74B 1/1,\nGalle Road,\nDehiwala', '1', '21', 'EV/S', '2', '', '4510', '1204', '4500', '1', '74B 1/1,\nGalle Road,\nDehiwala', '0', '', NULL, '0', '', '0'),
('916', '898', 'Koshalya Garments ', 'Koshalya Garments ', 'P.P.J Weerasooriya\nManaging Director\nNo 66 A, Hewagama\nKaduwela, \nSri Lanka\n', '1', '15', 'DEF', '2', '', '4510', '1203', '4500', '1', 'P.P.J Weerasooriya\nManaging Director\nNo 66 A, Hewagama\nKaduwela, \nSri Lanka\n', '0', '', NULL, '0', '', '0'),
('917', '899', 'CryptoGen Pvt Ltd', 'CryptoGen Pvt Ltd', 'Mr.Wasantha Perera\nLevel 8 East, Ceylinco House, \nNo 69, Janadipathi Mawatha, \nColombo 01\n', '1', '10', 'DEF', '2', '', '4510', '1204', '4500', '1', 'Mr.Wasantha Perera\nLevel 8 East, Ceylinco House, \nNo 69, Janadipathi Mawatha, \nColombo 01\n', '0', '', NULL, '0', '', '0'),
('918', '900', 'Free Lanka Granite (Pvt) Ltd', 'Free Lanka Granite', 'Colombo', '1', '1', 'DEF', '2', '', '4510', '1203', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('919', '901', 'ATG', 'S S Wilson &amp; Company (Pvt)', 'S S Wilson &amp; Company (Pvt) Ltd\nS. Ashokan-Chairman\nNo 174 1/1,\nMohamed Zain Mawatha,\nColombo 12', '1', '20', 'EV/S', '2', '', '4510', '1203', '4500', '1', 'S S Wilson &amp; Company (Pvt) Ltd\nS. Ashokan-Chairman\nNo 174 1/1,\nMohamed Zain Mawatha,\nColombo 12', '0', '', NULL, '0', '', '0'),
('920', '902', 'Millenium IT', 'Millenium IT', 'Panadura', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Panadura', '0', '', NULL, '0', '', '0'),
('921', '903', 'Colour Lab', 'Colour Lab', '', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('922', '904', 'Sri Lanka Institute of Advance Technological Education', 'SLIATE', 'No 320,\nJanawathu Piyasa,\nT B Jaya Mawatha,\nColombo 10', '1', '20', 'EV/S', '2', '4015', '4510', '1203', '4500', '1', 'No 320,\nJanawathu Piyasa,\nT B Jaya Mawatha,\nColombo 10', '0', '', NULL, '0', '', '0'),
('923', '905', 'Open Ark Systems ', 'Open Ark', 'No 120,\nHigh level Road,\nKirulapona\nColombo 06', '1', '8', 'EV/S', '3', '', '4510', '1204', '4500', '1', 'No 120,\nHigh level Road,\nKirulapona\nColombo 06', '0', '', NULL, '0', '', '0'),
('924', '906', 'Balfour Beauty', 'Balfour Beauty', 'Mr. Shyaad Perera\nPhase 3\nInvestment Promotion Zone, Katunayake,\nColombo,\nSri Lanka', '1', '17', 'EV/S', '3', '', '4510', '1204', '4500', '1', 'Mr. Shyaad Perera\nPhase 3\nInvestment Promotion Zone, Katunayake,\nColombo,\nSri Lanka', '0', '', NULL, '0', '', '0'),
('925', '907', 'Abans PLC ', 'Abans PLC -Tender sales Elite', 'Abans PLC (Elite)\nMr.Anand Kumar \nSales manager-Abans corporate\n4th floor, Abans Head Office,\nNo. 498, Galle Road, Colombo 3,', '1', '17', 'F04', '3', '', '4510', '1200', '4500', '1', 'Abans PLC (Elite)\nMr.Anand Kumar \nSales manager-Abans corporate\n4th floor, Abans Head Office,\nNo. 498, Galle Road, Colombo 3,', '0', '', NULL, '0', '', '0'),
('926', '908', 'Ashen', 'Ashen', 'Colombo', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('927', '909', 'Mr ER DE Niese', ' Niese', 'Colombo', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Colombo', '0', '', NULL, '0', '', '0'),
('928', '910', 'Link Square', 'Link Square', 'Unity Plaza', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Unity Plaza', '0', '', NULL, '0', '', '0'),
('929', '911', 'IT Store', 'IT Store', 'Unity Plaza', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Unity Plaza', '0', '', NULL, '0', '', '0'),
('930', '912', 'My Computers (Pvt) Ltd', 'My Computers (Pvt) Ltd', 'Maharagama', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Maharagama', '0', '', NULL, '0', '', '0'),
('931', '913', 'Saw Engineering (Pvt) Ltd', 'Saw Engineering ', 'No 52,\nMakoia Nortn,\nMakola,\nKiribathgoda', '1', '17', 'EV/S', '3', '', '4510', '1200', '4500', '1', 'No 52,\nMakoia Nortn,\nMakola,\nKiribathgoda', '0', '', NULL, '0', '', '0'),
('932', '914', 'Total Solutions', 'Total Solutions', 'Panadura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Panadura', '0', '', NULL, '0', '', '0'),
('934', '916', 'Saranga Technicians', 'Saranga Technicians', 'Hambanthota', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Hambanthota', '0', '', NULL, '0', '', '0'),
('935', '917', 'Trans Asia Computers', 'Trans Asia ', 'Ambalanota', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Ambalanota', '0', '', NULL, '0', '', '0'),
('936', '920', 'E-Tec Computers', 'E-Tec Computers', 'Sooriyawewa', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Sooriyawewa', '0', '', NULL, '0', '', '0'),
('937', '921', 'PC Cards', 'PC Cards', 'Kaluthara South', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Kaluthara South', '0', '', NULL, '0', '', '0'),
('938', '922', 'Prime Tech Computers', 'Prime Tech', '122/1/1,\nBekariya Junction,\nAttidiya,\nDehiwala', '1', '8', 'EV/S', '2', '', '4510', '1204', '4500', '1', '122/1/1,\nBekariya Junction,\nAttidiya,\nDehiwala', '0', '', NULL, '0', '', '0'),
('939', '923', 'Doctor PC ', 'Doctor PC ', 'Battaramulla', '1', '8', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Battaramulla', '0', '', NULL, '0', '', '0'),
('940', '924', 'Advantec Network System (Pvt) Ltd', 'Advantec Network', 'No.9/1,\nSumner Pl,\nColombo 08.', '1', '12', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No.9/1,\nSumner Pl,\nColombo 08.', '0', '', NULL, '0', '', '0'),
('941', '925', 'Ledvo Computers', 'Ledvo ', 'Kurunegala', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Kurunegala', '0', '', NULL, '0', '', '0'),
('942', '926', 'Cyber Zone', 'Cyber Zone', 'Balangoda', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Balangoda', '0', '', NULL, '0', '', '0'),
('943', '927', 'Technic World Computers', 'Technic World ', 'Balangoda', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Balangoda', '0', '', NULL, '0', '', '0'),
('944', '928', 'CS Computer-Balangoda', 'CS Computer-Balangoda', 'Balangoda', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Balangoda', '0', '', NULL, '0', '', '0'),
('945', '929', 'Crown Computers', 'Crown Computers', 'Melsiripura', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Melsiripura', '0', '', NULL, '0', '', '0'),
('946', '930', 'Infomax Computers', 'Infomax Computers', 'Gallewela', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Gallewela', '0', '', NULL, '0', '', '0'),
('947', '931', 'Mr.Premathilaka', 'Mr.Premathilaka', '', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('948', '932', 'Charuka Soft Net', 'Charuka Soft Net', 'Maththegoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Maththegoda', '0', '', NULL, '0', '', '0'),
('949', '933', 'DLW Computers', 'DLW Computers', 'Kottawa', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kottawa', '0', '', NULL, '0', '', '0'),
('950', '934', 'Guident Computers', 'Guident Computers', 'Homagama', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Homagama', '0', '', NULL, '0', '', '0'),
('951', '935', 'K-Net Computers', 'K-Net Computers', 'Nittambuwa', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Nittambuwa', '0', '', NULL, '0', '', '0'),
('952', '936', 'Revo Computers', 'Revo Computers', 'Marawila', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Marawila', '0', '', NULL, '0', '', '0'),
('953', '937', 'Brillianz Computers', 'Brillianz Computers', 'Chilaw', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Chilaw', '0', '', NULL, '0', '', '0'),
('954', '938', 'NEAT Computers', 'NEAT Computers', 'Ampara', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Ampara', '0', '', NULL, '0', '', '0'),
('955', '939', 'SEGA Family Computers', 'SEGA Family', 'Sammanthurai', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Sammanthurai', '0', '', NULL, '0', '', '0'),
('956', '940', 'TEKNO World', 'TEKNO World', 'Batticola', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Batticola', '0', '', NULL, '0', '', '0'),
('957', '941', 'The Galaxy', 'The Galaxy', 'Main Street,\nKalawachchikudi', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Main Street,\nKalawachchikudi', '0', '', NULL, '0', '', '0'),
('958', '942', 'E-City', 'E-City', 'Akkareipaththu', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Akkareipaththu', '0', '', NULL, '0', '', '0'),
('959', '943', 'Selco Continental Private Limited', 'Selco ', 'Mr. Malaka,\nNo 69A ? 1/1,\nGalle Road,\nDehiwala South,\nSri Lanka.', '1', '20', 'EV/S', '2', '', '4510', '1203', '4500', '1', 'Mr. Malaka,\nNo 69A ? 1/1,\nGalle Road,\nDehiwala South,\nSri Lanka.', '0', '', NULL, '0', '', '0'),
('960', '944', 'R &amp; W Computer System', 'R &amp; W Computer System', 'Horana', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Horana', '0', '', NULL, '0', '', '0'),
('961', '945', 'Ayowee IT Care', 'Ayowee IT Care', 'Maggona', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Maggona', '0', '', NULL, '0', '', '0'),
('964', '947', 'Institute of Lean Management (Pvt) Ltd', 'ILM', 'Level 26,\nEast Tower,\nWorld Trade Center,\nColombo 01,\nSri Lanka.', '1', '8', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Level 26,\nEast Tower,\nWorld Trade Center,\nColombo 01,\nSri Lanka.', '0', '', NULL, '0', '', '0'),
('965', '948', 'Trans Technology Computers', 'Trans Technology', 'Matara', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Matara', '0', '', NULL, '0', '', '0'),
('966', '949', 'Micro Computer Center', 'Micro Computer-Hanwella', 'No 25 B/2,\nMain Street,\nHanwella', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'No 25 B/2,\nMain Street,\nHanwella', '0', '', NULL, '0', '', '0'),
('967', '950', 'PrimeTek-Matara', 'PrimeTek-Matara', 'Matara', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Matara', '0', '', NULL, '0', '', '0'),
('968', '951', 'TechMore Computers', 'TechMore-Matara', 'Matara', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Matara', '0', '', NULL, '0', '', '0'),
('969', '952', 'Sarasi Computer House', 'Sarasi Computer-Ambalangoda', 'Ambalangoda', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Ambalangoda', '0', '', NULL, '0', '', '0'),
('970', '954', 'Angel Electronics', 'Angel Electronics', 'Galle', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('971', '955', 'Tulip Comuters', 'Tulip Comuters', 'Galle', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('972', '956', 'Next Computers', 'Next Computers', 'Battaramulla', '1', '8', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Battaramulla', '0', '', NULL, '0', '', '0'),
('973', '957', 'PC Mart', 'PC Mart', 'No 100/225,\nMumtaz Mahal,\nColombo 11', '1', '22', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 100/225,\nMumtaz Mahal,\nColombo 11', '0', '', NULL, '0', '', '0'),
('974', '958', 'SDR Computers', 'SDR Computers', 'Dankotuwa', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Dankotuwa', '0', '', NULL, '0', '', '0'),
('975', '959', 'Ayngaran Computers', 'Ayngaran Computers', 'Hettiyawatta', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Hettiyawatta', '0', '', NULL, '0', '', '0'),
('976', '960', 'C-Com ', 'C-Com ', 'Nugegoda', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Nugegoda', '0', '', NULL, '0', '', '0'),
('977', '961', 'East Link Engineering Co.(pvt) Ltd', 'East Link', 'No 163/26,\nNawala Road,\nColombo 05', '1', '12', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 163/26,\nNawala Road,\nColombo 05', '0', '', NULL, '0', '', '0'),
('978', '962', 'Chanowm Technologies', 'Chanowm Technologies', 'Motatuwa', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Motatuwa', '0', '', NULL, '0', '', '0'),
('979', '963', 'Smart Computers', 'Smart Computers-Moratuwa', 'Moratuwa', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Moratuwa', '0', '', NULL, '0', '', '0'),
('980', '964', 'Damith IT', 'Damith IT', '', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('981', '965', 'Texas Electronics Engineering', 'Texas Electronics', 'Galle', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('982', '966', 'Metro Computer Technologies', 'Metro Computer', 'Matara', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Matara', '0', '', NULL, '0', '', '0'),
('983', '967', 'Com Tec Computers', 'ComTec-Wadduwa', 'Wadduwa', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Wadduwa', '0', '', NULL, '0', '', '0'),
('984', '968', 'Wajira Karunathilaka', 'Wajira Karunathilaka-Primal', 'Gampaha', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Gampaha', '0', '', NULL, '0', '', '0'),
('985', '969', 'E-Line Technologies', 'E-Line Technologies', 'Kandy', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kandy', '0', '', NULL, '0', '', '0'),
('986', '970', 'Akura Book Shop', 'Akura Book Shop', 'Miriswatta', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Miriswatta', '0', '', NULL, '0', '', '0'),
('987', '971', 'Thisara Book Shop', 'Thisara Book Shop', 'Ahungalla', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Ahungalla', '0', '', NULL, '0', '', '0'),
('988', '972', 'PC Globe', 'PC Globe', 'Unity Plaza', '1', '17', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Unity Plaza', '0', '', NULL, '0', '', '0'),
('989', '973', 'Stafford Garments Industries (Pvt) Ltd,', 'Stafford Garments', 'No: 304-5 1/2,\nNegombo Road,\nPeliyagoda.\n               \nVAT : 0114096512-7000\n', '1', '20', 'EV/S', '3', '', '4510', '1203', '4500', '1', 'No: 304-5 1/2,\nNegombo Road,\nPeliyagoda.\n               \nVAT : 0114096512-7000\n', '0', '', NULL, '0', '', '0'),
('990', '974', 'Computer House', 'Computer House', 'Padukka', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Padukka', '0', '', NULL, '0', '', '0'),
('991', '975', 'Sashi Computers', 'Sashi Computers', 'Panadura', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Panadura', '0', '', NULL, '0', '', '0'),
('992', '976', 'D-Tech Computer Services', 'D-Tech Computer ', 'Bibile', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Bibile', '0', '', NULL, '0', '', '0'),
('993', '977', 'Soft Tech Computers', 'Soft Tech Computers', 'Ambalanthota', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Ambalanthota', '0', '', NULL, '0', '', '0'),
('994', '978', 'M V C Computers', 'M V C Computers', 'Weerakatiya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Weerakatiya', '0', '', NULL, '0', '', '0'),
('995', '979', 'Indika Electronics', 'Indika Electronics', 'Weerakatiya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Weerakatiya', '0', '', NULL, '0', '', '0'),
('996', '980', 'Dilan Computers', 'Dilan Computers', 'Diulapitiya', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Diulapitiya', '0', '', NULL, '0', '', '0'),
('997', '981', 'MyCom Technologies', 'MyCom Technologies', 'Kirillawala', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kirillawala', '0', '', NULL, '0', '', '0'),
('998', '982', 'Soft System Computer Zone', 'Soft System', 'Kelaniya', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kelaniya', '0', '', NULL, '0', '', '0'),
('999', '983', 'Wisdom Books', 'Wisdom Books', 'Wattala', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Wattala', '0', '', NULL, '0', '', '0'),
('1000', '984', 'Aussie Computers', 'Aussie Computers', 'Makola', '1', '2', 'F01', '2', '', '4510', '1200', '4500', '1', 'Makola', '0', '', NULL, '0', '', '0'),
('1001', '985', 'Sampath Technologies &amp; Marketing', 'Sampath Technologies ', 'Kelaniya', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kelaniya', '0', '', NULL, '0', '', '0'),
('1002', '986', 'Cash-Primal', 'Cash-Primal', 'Primal', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Primal', '0', '', NULL, '0', '', '0'),
('1003', '987', 'Plus Computers', 'Plus Computers', 'Embilipitiya', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Embilipitiya', '0', '', NULL, '0', '', '0'),
('1004', '988', 'Nenasa Computers', 'Nenasa Computers', 'Polonnaruwa', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Polonnaruwa', '0', '', NULL, '0', '', '0'),
('1005', '989', 'Sewwandi Communication', 'Sewwandi Communication', 'Embilipitiya', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Embilipitiya', '0', '', NULL, '0', '', '0'),
('1006', '990', 'Nelum Video &amp; Communication', 'Nelum Video', 'Embilipitiya', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Embilipitiya', '0', '', NULL, '0', '', '0'),
('1007', '991', 'Onimtar High Tech Solutions (Pvt) Ltd', 'Onimtar High Tech', 'Ratnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Ratnapura', '0', '', NULL, '0', '', '0'),
('1008', '992', 'PC System', 'PC System', 'Opanayake', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Opanayake', '0', '', NULL, '0', '', '0'),
('1009', '993', 'Aiken Digital', 'Aiken Digital', 'Ratnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Ratnapura', '0', '', NULL, '0', '', '0'),
('1010', '994', 'Smart PC', 'Smart PC', 'Dambulla', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Dambulla', '0', '', NULL, '0', '', '0'),
('1011', '995', 'Info Net Computers', 'Info Net Computers', 'Gallewela', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Gallewela', '0', '', NULL, '0', '', '0'),
('1012', '996', 'A Eon Computers', 'A Eon Computers', 'Dambulla', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Dambulla', '0', '', NULL, '0', '', '0'),
('1013', '997', 'Quick Flix Tech Lanka', 'Quick Flix ', 'Pilimathalawa', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Pilimathalawa', '0', '', NULL, '0', '', '0'),
('1014', '998', 'RDF Computers', 'RDF Computers', 'Katubedda', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Katubedda', '0', '', NULL, '0', '', '0'),
('1015', '999', 'New Olanka Computers', 'New Olanka Computers', 'Piliyandala', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Piliyandala', '0', '', NULL, '0', '', '0'),
('1016', '1000', 'Smart Laptop House', 'Smart Laptop', 'Matara', '1', '1', 'F05', '2', '', '4510', '1200', '4500', '1', 'Matara', '0', '', NULL, '0', '', '0'),
('1017', '1001', 'Multi 9', 'Multi 9', 'Awissawella', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Awissawella', '0', '', NULL, '0', '', '0'),
('1018', '1002', 'Fair Price', 'Fair Price', 'Horana', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Horana', '0', '', NULL, '0', '', '0'),
('1019', '1003', 'Chptronics', 'Chptronics', 'Wadduwa', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Wadduwa', '0', '', NULL, '0', '', '0'),
('1020', '1004', 'Matheesha Computers', 'Matheesha Computers', 'Horana', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Horana', '0', '', NULL, '0', '', '0'),
('1021', '1005', 'Globel Net Computers', 'Globel Net-Nimendra', 'Hikkaduwa', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Hikkaduwa', '0', '', NULL, '0', '', '0'),
('1022', '1006', 'Synergy Computer Systems', 'Synergy Computer-Nimendra', 'Piliyandala', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Piliyandala', '0', '', NULL, '0', '', '0'),
('1023', '1007', 'PC Max', 'PC Max-Nimendra', 'Piliyandala', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Piliyandala', '0', '', NULL, '0', '', '0'),
('1024', '1008', 'AP Technologioes', 'AP Technologioes', 'Piliyandala', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Piliyandala', '0', '', NULL, '0', '', '0'),
('1025', '1009', 'Nishantha Book Shop', 'Nishantha Book Shop', 'Payagala', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Payagala', '0', '', NULL, '0', '', '0'),
('1026', '1010', 'Renown Computers', 'Renown Computers', 'Ingiriiya', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Ingiriiya', '0', '', NULL, '0', '', '0'),
('1027', '1011', 'SM Computers', 'SM Computers', 'Rawatawatte', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Rawatawatte', '0', '', NULL, '0', '', '0'),
('1028', '1012', 'Angel Computers', 'Angel Computers-Nimendra', 'Galle', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('1029', '1013', 'K M K Technologies', 'K M K Technologies', 'Karapitiya', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Karapitiya', '0', '', NULL, '0', '', '0'),
('1030', '1014', 'Zee Mobile', 'Zee Mobile', 'Matara', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Matara', '0', '', NULL, '0', '', '0'),
('1031', '1015', 'E-Work Shop', 'E-Work Shop-Horana', 'Horana', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Horana', '0', '', NULL, '0', '', '0'),
('1032', '1016', 'Enitss Com0puters', 'Enitss Com0puters', 'Bandaragama', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Bandaragama', '0', '', NULL, '0', '', '0'),
('1033', '1017', 'HP Computer System', 'HP Computer System', 'Bandaragama', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Bandaragama', '0', '', NULL, '0', '', '0'),
('1034', '1018', 'Colombo Municipal Council', 'CMC-Procurement Dept', 'Central Procurement Department\nColombo', '1', '10', 'EV/S', '3', '', '4510', '1204', '4500', '1', 'Central Procurement Department\nColombo', '0', '', NULL, '0', '', '0'),
('1035', '1019', 'Colombo', 'Colombo', 'Evolve Store', '1', '8', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Evolve Store', '0', '', NULL, '0', '', '0'),
('1036', '1020', 'RP Technologies', 'RP Technologies', 'Negambo', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Negambo', '0', '', NULL, '0', '', '0'),
('1037', '1021', 'PC Home', 'PC Home-Kiribathgoda', 'Kiribathgoda', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kiribathgoda', '0', '', NULL, '0', '', '0'),
('1038', '1022', 'SD Computers', 'SD Computers', 'Padukka', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Padukka', '0', '', NULL, '0', '', '0'),
('1039', '1023', 'V S Technologies', 'V S Technologies', 'Weligama', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Weligama', '0', '', NULL, '0', '', '0'),
('1040', '1024', 'Charlton Business Center', 'Charlton Business Center', 'Kandy', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kandy', '0', '', NULL, '0', '', '0'),
('1041', '1025', 'Chami Movie World', 'Chami Movie', 'Makola', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Makola', '0', '', NULL, '0', '', '0'),
('1042', '1026', 'Super Beam (Pvt) Ltd', 'Super Beam', 'Nugegoda', '1', '8', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Nugegoda', '0', '', NULL, '0', '', '0'),
('1043', '1027', 'Onex (Pvt) Ltd', 'Onex ', 'Pelawaththe', '1', '8', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Pelawaththe', '0', '', NULL, '0', '', '0'),
('1044', '1028', 'SK Gadget Shop &amp; Laptop Repair Center', 'SK Gadget Shop', 'Battaramulla', '1', '8', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Battaramulla', '0', '', NULL, '0', '', '0'),
('1045', '1029', 'Okidlo Computers', 'Okidlo Computers', 'Kelaniya', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kelaniya', '0', '', NULL, '0', '', '0'),
('1046', '1031', 'Micro Tech Computers', 'Micro Tech ', 'Kochchikade', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kochchikade', '0', '', NULL, '0', '', '0'),
('1047', '1032', 'CyberZone', 'CyberZone', 'Homagama', '1', '2', 'F01', '2', '', '4510', '1200', '4500', '1', 'Homagama', '0', '', NULL, '0', '', '0'),
('1048', '1033', 'Sandaru Video', 'Sandaru Video', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('1049', '1034', 'Hasi Video', 'Hasi Video', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('1050', '1035', 'New Net Computers', 'New Net Computers', 'Hidella', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Hidella', '0', '', NULL, '0', '', '0'),
('1051', '1036', 'LMP Printing', 'LMP Printing', 'Polonnaruwa', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Polonnaruwa', '0', '', NULL, '0', '', '0'),
('1052', '1037', 'Ranga PC', 'Ranga PC', 'Polonnaruwa', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Polonnaruwa', '0', '', NULL, '0', '', '0'),
('1053', '1038', 'Bitwin Computers', 'Bitwin Computers', 'Kurunegala', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Kurunegala', '0', '', NULL, '0', '', '0'),
('1054', '1039', 'Cebit Computers', 'Cebit Computers', 'Polonnaruwa', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Polonnaruwa', '0', '', NULL, '0', '', '0'),
('1055', '1040', 'Techno Mobile And CCTV', 'Techno Mobile And CCTV', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('1056', '1041', 'Senani Videos', 'Senani Videos', 'Kuruwita', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Kuruwita', '0', '', NULL, '0', '', '0'),
('1057', '1042', 'Studio Cooray', 'Studio Cooray', 'Maggona', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Maggona', '0', '', NULL, '0', '', '0'),
('1058', '1043', 'Mobile Zone', 'Mobile Zone', 'K-Zone,\nKatubedda', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'K-Zone,\nKatubedda', '0', '', NULL, '0', '', '0'),
('1059', '1044', 'Navora Communications', 'Navora Communications', 'Hikkaduwa', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Hikkaduwa', '0', '', NULL, '0', '', '0'),
('1060', '1045', 'AB Mobile', 'AB Mobile', 'Aluthgama', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Aluthgama', '0', '', NULL, '0', '', '0'),
('1061', '1046', 'E-Zone', 'E-Zone', 'Ingiriya', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Ingiriya', '0', '', NULL, '0', '', '0'),
('1062', '1047', 'Manjula Electronics', 'Manjula Electronics', 'Ingiriya', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Ingiriya', '0', '', NULL, '0', '', '0'),
('1063', '1048', 'Intell lanka Computers', 'Intell lanka-Kosala', 'Kurunegala', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Kurunegala', '0', '', NULL, '0', '', '0'),
('1064', '1049', 'Aradana Mobile', 'Aradana Mobile', 'Anuradhapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Anuradhapura', '0', '', NULL, '0', '', '0'),
('1065', '1050', 'PC World', 'PC World-Kosala', 'Polonnaruwa', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Polonnaruwa', '0', '', NULL, '0', '', '0'),
('1066', '1051', 'Excellent Computers', 'Excellent Computers-Kosala', 'Plonnaruwa', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Plonnaruwa', '0', '', NULL, '0', '', '0'),
('1067', '1052', 'ATS Group', 'ATS Group-USA Project', '', '1', '4', 'DEF', '2', '', '4510', '1230', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1068', '1053', 'Microtec Computers', 'Microtec -Panadura', 'Panadura', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Panadura', '0', '', NULL, '0', '', '0'),
('1069', '1054', 'Epitichia Multi Traders', 'Epitichia-Nimendra', 'Hatton', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Hatton', '0', '', NULL, '0', '', '0'),
('1070', '1055', 'Kavindu Computers', 'Kavindu Computers', 'Payagala', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Payagala', '0', '', NULL, '0', '', '0'),
('1071', '1056', 'Rohan Book Shop', 'Rohan Book Shop', 'Galle', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('1072', '1057', 'Cell One Cellullar', 'Cell One Cellullar', 'Ambalangoda', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Ambalangoda', '0', '', NULL, '0', '', '0'),
('1073', '1058', 'G.S.M.Solutions', 'G.S.M.Solutions', 'Ambalangoda', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Ambalangoda', '0', '', NULL, '0', '', '0'),
('1074', '1059', 'Amasha Video.com', 'Amasha Video.com', 'Horana', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Horana', '0', '', NULL, '0', '', '0'),
('1075', '1060', 'Lakshan Mobile', 'Lakshan Mobile', 'Katukurunda', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Katukurunda', '0', '', NULL, '0', '', '0'),
('1076', '1061', 'I.R.Computers', 'I.R.Computers', 'Maggona', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Maggona', '0', '', NULL, '0', '', '0'),
('1077', '1062', 'Perera Graphics', 'Perera Graphics', 'Kaluthara', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Kaluthara', '0', '', NULL, '0', '', '0'),
('1078', '1063', 'Galaxy Computers', 'Galaxy Computers', 'Kalawakachchikudi', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Kalawakachchikudi', '0', '', NULL, '0', '', '0'),
('1079', '1064', 'Copreus (Pvt) Ltd', 'Copreus (Pvt) Ltd', 'Level 26,East Tower,\nWorld Trade Center,\nColombo 01', '1', '4', 'EV/S', '2', '', '4510', '1200', '4500', '1', 'Level 26,East Tower,\nWorld Trade Center,\nColombo 01', '0', '', NULL, '0', '', '0'),
('1080', '1065', 'TCR Computers System', 'TCR Computers System', 'Pitigala', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Pitigala', '0', '', NULL, '0', '', '0'),
('1081', '1066', 'SenitCom IT Solutions', 'SenitCom IT Solutions', 'Ratmalana', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Ratmalana', '0', '', NULL, '0', '', '0'),
('1082', '1067', 'Difontec Computers', 'Difontec Computers', 'Moratuwa', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Moratuwa', '0', '', NULL, '0', '', '0'),
('1083', '1068', 'Micro Computer Home', 'Micro Computer Home-Beruwala', 'Beruwala', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Beruwala', '0', '', NULL, '0', '', '0'),
('1084', '1069', 'Sitelka Cellular', 'Sitelka Cellular', 'Katubedda', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Katubedda', '0', '', NULL, '0', '', '0'),
('1085', '1070', 'Hedra Solutions', 'Hedra Solutions', 'Athurugiriya', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Athurugiriya', '0', '', NULL, '0', '', '0'),
('1086', '1071', 'CNN Computers', 'CNN Computers', 'Nattandiya', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Nattandiya', '0', '', NULL, '0', '', '0'),
('1087', '1072', 'The Print Hub', 'The Print Hub', 'Polonnaruwa', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Polonnaruwa', '0', '', NULL, '0', '', '0'),
('1088', '1073', 'Wisdom Computers', 'Wisdom Computers', 'Balangoda', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Balangoda', '0', '', NULL, '0', '', '0'),
('1089', '1074', 'IT Plus', 'IT Plus', 'Anuradhapura', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Anuradhapura', '0', '', NULL, '0', '', '0'),
('1090', '1075', 'Power PC laptop', 'Power PC laptop', 'Anuradhapura', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Anuradhapura', '0', '', NULL, '0', '', '0'),
('1091', '1076', 'Tech Tool Computer', 'Tech Tool Computer', 'Anuradhapura', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Anuradhapura', '0', '', NULL, '0', '', '0'),
('1092', '1077', 'Smart IT', 'Smart IT-Polonnaruwa', 'Polonnaruwa', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Polonnaruwa', '0', '', NULL, '0', '', '0'),
('1093', '1078', 'Darshani Computers', 'Darshani Computers', 'Habarana', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Habarana', '0', '', NULL, '0', '', '0'),
('1094', '1079', 'Max Computer Sys', 'Max Computer Sys', 'Polgahawela', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Polgahawela', '0', '', NULL, '0', '', '0'),
('1095', '1080', 'Mobile Hut', 'Mobile Hut', 'Opanayake', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Opanayake', '0', '', NULL, '0', '', '0'),
('1096', '1081', 'Workshop', 'Workshop-Nimendra', 'Horana', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Horana', '0', '', NULL, '0', '', '0'),
('1097', '1082', 'V.S.P.Computer System', 'V.S.P.Computer', 'Galle', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('1098', '1083', '3Quities Multi Shop', '3Quities', 'Payagala', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Payagala', '0', '', NULL, '0', '', '0'),
('1099', '1084', 'Danansaya Print House &amp; Computers', 'Danansaya Print House', 'Dehiowita', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Dehiowita', '0', '', NULL, '0', '', '0'),
('1100', '1085', 'Super Max', 'Super Max', 'Karawanaella', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Karawanaella', '0', '', NULL, '0', '', '0'),
('1101', '1086', 'K.G.S.Computers', 'K.G.S.Computers', 'Yatiyantota', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Yatiyantota', '0', '', NULL, '0', '', '0'),
('1102', '1087', 'I Com Computers', 'I Com-Nimendra', 'Ginigathhena', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Ginigathhena', '0', '', NULL, '0', '', '0'),
('1103', '1088', 'H.D.Haran', 'H.D.Haran', 'Nuwaraeliya', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Nuwaraeliya', '0', '', NULL, '0', '', '0'),
('1104', '1089', 'Jetro Communication', 'Jetro Communication', 'Nuwara eliya', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Nuwara eliya', '0', '', NULL, '0', '', '0'),
('1105', '1090', 'B.D.F Computers', 'B.D.F Computers', 'Katubedda', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Katubedda', '0', '', NULL, '0', '', '0'),
('1106', '1091', 'Vishwa Celluler', 'Vishwa Celluler', 'Niwithigala', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Niwithigala', '0', '', NULL, '0', '', '0'),
('1107', '1092', 'K &amp; L Mobile', 'K &amp; L Mobile', 'Kuruwita', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Kuruwita', '0', '', NULL, '0', '', '0'),
('1108', '1093', 'Lakmal Communication', 'Lakmal Communication', 'Polpithigama', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Polpithigama', '0', '', NULL, '0', '', '0'),
('1109', '1094', 'Edirisinghe Celluler', 'Edirisinghe Celluler', 'Nivithigala', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Nivithigala', '0', '', NULL, '0', '', '0'),
('1110', '1095', 'G &amp;  J Computers', 'G &amp;  J Computers', 'Deyandara', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Deyandara', '0', '', NULL, '0', '', '0'),
('1111', '1096', 'Zima Computers', 'Zima Computers', 'Polonnaruwa', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Polonnaruwa', '0', '', NULL, '0', '', '0'),
('1112', '1097', 'Shahon Computers', 'Shahon Computers', 'Polonnaruwa', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Polonnaruwa', '0', '', NULL, '0', '', '0'),
('1113', '1098', 'JD Computers', 'JD Computers', 'Anuradhapura', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Anuradhapura', '0', '', NULL, '0', '', '0'),
('1114', '1099', 'Priyankara Stores', 'Priyankara Stores', 'Habarana', '1', '27', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Habarana', '0', '', NULL, '0', '', '0'),
('1115', '1100', 'Cool Zone Entertainment', 'Cool Zone ', 'Aluthgama', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Aluthgama', '0', '', NULL, '0', '', '0'),
('1116', '1101', 'New Isuru Trade Center', 'New Isuru Trade', 'Bombuwala', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Bombuwala', '0', '', NULL, '0', '', '0'),
('1117', '1102', 'S.N Multi Tech', 'S.N Multi Tech', 'Kaluthara', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Kaluthara', '0', '', NULL, '0', '', '0'),
('1118', '1103', 'Brad Ferris', 'Brad Ferris', 'Director\nRed Digital\nAustralia\n', '1', '4', 'EV/S', '2', '', '4510', '1230', '4500', '1', 'Director\nRed Digital\nAustralia\n', '0', '', NULL, '0', '', '0'),
('1119', '1104', 'Strangers Computers', 'Strangers ', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1120', '1105', 'Future Tech Computers', 'Future Tech', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1121', '1106', 'Scenic Digital Word', 'Scenic Digital-Nimendra', 'Bombuwala', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Bombuwala', '0', '', NULL, '0', '', '0'),
('1122', '1107', 'I Fix Solutions', 'I Fix Solutions', 'Kadawatha', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Kadawatha', '0', '', NULL, '0', '', '0'),
('1123', '1108', 'Micro Phone Shop', 'Micro Phone Shop -Nimendra', '', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1124', '1109', 'Senvo Computers', 'Senvo Computers-Nimendra', 'Ambalangoda', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Ambalangoda', '0', '', NULL, '0', '', '0'),
('1125', '1110', 'Softvision IT Group (Pvt) Ltd', 'Softvision IT', 'No 414/7-1/1,\nBaseline Garden,Baseline Road,\nColombo 09', '1', '12', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 414/7-1/1,\nBaseline Garden,Baseline Road,\nColombo 09', '0', '', NULL, '0', '', '0'),
('1126', '1111', 'Pubudu Mobile &amp; Multi Center', 'Pubudu Mobile &amp; Multi Cent', 'Dehiowita', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Dehiowita', '0', '', NULL, '0', '', '0'),
('1127', '1112', 'Best Computers &amp; Phone Shop', 'Best Computers &amp; Phone Sho', 'Yatiyanthota', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Yatiyanthota', '0', '', NULL, '0', '', '0'),
('1128', '1113', 'Hatton Computer Systems', 'Hatton Computer ', 'Hatton', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Hatton', '0', '', NULL, '0', '', '0'),
('1129', '1114', 'Nalin Stores', 'Nalin Stores', 'Kaluthara', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Kaluthara', '0', '', NULL, '0', '', '0'),
('1130', '1115', 'Isuru Video &amp; Phone Center', 'Isuru Video &amp; Phone-Nimend', 'Kahawaththa', '1', '22', 'F05', '1', '', '4510', '1204', '4500', '1', 'Kahawaththa', '0', '', NULL, '0', '', '0'),
('1131', '1116', 'I Fix Pc Solutions', 'I Fix Pc -Nimendra', 'Panadura', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Panadura', '0', '', NULL, '0', '', '0');
INSERT INTO `0_cust_branch` VALUES
('1132', '1117', 'Service Global', 'Service Global-USD', '980,Mission Court,\nFremont,CA\n94539,USA', '1', '4', 'EV/S', '2', '', '4510', '1202', '4500', '1', '980,Mission Court,\nFremont,CA\n94539,USA', '0', '', NULL, '0', '', '0'),
('1133', '1118', 'Rota-Japan', 'Rota-Japan', 'Japan', '1', '4', 'EV/S', '2', '', '4510', '1202', '4500', '1', 'Japan', '0', '', NULL, '0', '', '0'),
('1135', '1119', 'Ole Takai', 'Ole Takai-Mr.Ashan&#039;s Cust', 'Ripples', '1', '21', 'F04', '1', '', '4510', '1202', '4500', '1', 'Ripples', '0', '', NULL, '0', '', '0'),
('1136', '1120', 'House of Travels &amp; Tourism', 'House of Travels &amp; Tourism', 'NO 220,Hight Level Road,\nColombo 06', '1', '1', 'EV/S', '2', '', '4510', '1203', '4500', '1', 'NO 220,Hight Level Road,\nColombo 06', '0', '', NULL, '0', '', '0'),
('1137', '1121', 'NCTS Technology PC System', 'NCTS Technology ', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1138', '1122', 'Multi Phone Shop', 'Multi Phone Shop-Ijas', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1139', '1123', 'I Com Technology', 'I Com Technology-Ijas', 'Kinniya', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Kinniya', '0', '', NULL, '0', '', '0'),
('1140', '1124', 'Phone Time Mobile Shop', 'Phone Time-Ijas', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1141', '1125', 'I Mobile', 'I Mobile-Ijas', 'Kinniya', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Kinniya', '0', '', NULL, '0', '', '0'),
('1142', '1126', 'F S Mobile Shop', 'F S Mobile Shop-Ijas', 'Uppuveli', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Uppuveli', '0', '', NULL, '0', '', '0'),
('1143', '1127', 'Asian Cell Stores', 'Asian Cell Stores-Ijas', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1144', '1128', 'Naja Computer System', 'Naja Computer System', 'Main Street,Muthur', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Main Street,Muthur', '0', '', NULL, '0', '', '0'),
('1145', '1129', 'Mobile World', 'Mobile World-Ijas', 'Oddumavadi', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Oddumavadi', '0', '', NULL, '0', '', '0'),
('1146', '1130', 'Boardway Computer Tech', 'Boardway-Ijas', 'Oddumavadi', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Oddumavadi', '0', '', NULL, '0', '', '0'),
('1147', '1131', 'Colombo Phone Shop and Rent a Car', 'CMB Phone Shop-Ijas', 'Beticalo', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Beticalo', '0', '', NULL, '0', '', '0'),
('1148', '1132', 'Institute of Technology &amp; Management', 'ITM-Ijas', 'Akkarapattu', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Akkarapattu', '0', '', NULL, '0', '', '0'),
('1149', '1133', 'New World Mobile', 'New World Mobile-Ijas', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1150', '1134', 'EyeCom Technologies', 'EyeCom Technologies-Ijas', 'Kinniya', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Kinniya', '0', '', NULL, '0', '', '0'),
('1151', '1135', 'Issath Communication', 'Issath Communication-Ijas', 'Jinnagar', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Jinnagar', '0', '', NULL, '0', '', '0'),
('1152', '1136', 'New City Technology PC System', 'New City Technology-Ijas', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1153', '1137', 'N K T Computers', 'N K T Computers', 'Colombo 05', '1', '8', 'F06', '2', '', '4510', '1204', '4500', '1', 'Colombo 05', '0', '', NULL, '0', '', '0'),
('1154', '1138', 'Blue Chip Technologies (Pvt) Ltd', 'Blue Chip Technologies', 'Dehiwala', '1', '8', 'F06', '2', '', '4510', '1204', '4500', '1', 'Dehiwala', '0', '', NULL, '0', '', '0'),
('1155', '1139', 'Smart Net Computers', 'Smart Net ', 'Wellawaya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Wellawaya', '0', '', NULL, '0', '', '0'),
('1156', '1140', 'Tele Print Computer Service ', 'Tele Print-Nimendra', 'Hatton', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Hatton', '0', '', NULL, '0', '', '0'),
('1157', '1141', 'Lanka Minerals &amp; Chemicals (Pvt) Limited', 'Lanka Minerals &amp; Chemicals', 'No 75,\n2nd Lane,\nRatmalana', '1', '1', 'EV/S', '2', '', '4510', '1203', '4500', '1', 'No 75,\n2nd Lane,\nRatmalana', '0', '', NULL, '0', '', '0'),
('1158', '1142', 'Lead Capital Corporation', 'Lead Capital-USD', '', '1', '4', 'EV/S', '2', '4050', '4510', '1230', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1159', '1143', 'CN Global Pty. Ltd. Australia', 'CNGA', 'Australia', '1', '1', 'EV/S', '1', '4045', '4510', '1202', '4500', '1', 'Australia', '0', '', NULL, '0', '', '0'),
('1160', '1144', 'Lakshitha Communication ', 'Lakshitha Communication ', 'Pallebedda', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Pallebedda', '0', '', NULL, '0', '', '0'),
('1161', '1145', 'S.L.A.Rizard.Com', 'S.L.A.Rizard.Com-Nimendra', 'Haputhale', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Haputhale', '0', '', NULL, '0', '', '0'),
('1162', '1146', 'Anil&#039;s Computers', 'Anil&#039;s Computers-Nimendra', 'Hali-Ella', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Hali-Ella', '0', '', NULL, '0', '', '0'),
('1163', '1147', 'Minro Communication', 'Minro Communication-Nimendra', 'Aluthgama', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Aluthgama', '0', '', NULL, '0', '', '0'),
('1164', '1148', 'Samadhi Communication', 'Samadhi Communication-Nimendra', 'Balangoda', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Balangoda', '0', '', NULL, '0', '', '0'),
('1165', '1149', 'Global Net Computers', 'Global Net-Nimendra', 'Hikkaduwa', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Hikkaduwa', '0', '', NULL, '0', '', '0'),
('1166', '1150', 'I Net Computer Technologies', 'I Net Computer-Nimendra', 'Matara', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Matara', '0', '', NULL, '0', '', '0'),
('1167', '1151', 'E-World', 'E-World-Roshan', 'Wellawaththa', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Wellawaththa', '0', '', NULL, '0', '', '0'),
('1168', '1152', 'Chamara Technologies', 'Chamara Technologies-Roshan', 'Hokandara', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Hokandara', '0', '', NULL, '0', '', '0'),
('1169', '1153', 'Veema Computers', 'Veema Computers-Nimendra', 'Bandaragama', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Bandaragama', '0', '', NULL, '0', '', '0'),
('1170', '1154', 'C H Computers', 'C H Computers-Nimendra', 'Kithulgala', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Kithulgala', '0', '', NULL, '0', '', '0'),
('1171', '1155', 'Best Way Computers', 'Best Way Computers-Nimendra', 'Awissawella', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Awissawella', '0', '', NULL, '0', '', '0'),
('1172', '1156', 'E-Base Computer', 'E-Base Computer-Dilruk', 'Mapolagama', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Mapolagama', '0', '', NULL, '0', '', '0'),
('1173', '1157', 'Top Choice', 'Top Choice-Ijas', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1174', '1158', 'RS Enterprises', 'RS Enterprises-Ijas', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1175', '1159', 'JM Electronics', 'JM Electronics-Ijas', 'Kinniya', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Kinniya', '0', '', NULL, '0', '', '0'),
('1176', '1160', 'Askas Fancy Place', 'Askas Fancy Place-Ijas', 'Kinniya', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Kinniya', '0', '', NULL, '0', '', '0'),
('1177', '1161', 'I Techno Computers', 'I Techno -Ijas', '', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1178', '1162', 'Ayan Cellcity', 'Ayan Cellcity-Kinniya', '', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1179', '1163', 'Northern Pc Park', 'Northern Pc Park-Ijas', 'Jaffna', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Jaffna', '0', '', NULL, '0', '', '0'),
('1180', '1164', 'G Base ', 'G Base-Ijas', 'Kinniya', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Kinniya', '0', '', NULL, '0', '', '0'),
('1181', '1165', 'Asiri Media Solutions', 'Asiri Media Solutions-Ijas', 'Kanthale', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Kanthale', '0', '', NULL, '0', '', '0'),
('1182', '1166', 'Shoppy Computers', 'Shoppy Computers-Kaluthara', 'Kaluthara', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Kaluthara', '0', '', NULL, '0', '', '0'),
('1183', '1167', 'Best Buy Mobile', 'Best Buy-Nimendra', 'Panadura', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Panadura', '0', '', NULL, '0', '', '0'),
('1184', '1168', 'Millennium Auto Exprez (Pvt.) Limited', 'Millennium Auto', 'No 298,\nButhgamuwa Road,\nRajagiriya', '1', '1', 'EV/S', '2', '', '4510', '1203', '4500', '1', 'No 298,\nButhgamuwa Road,\nRajagiriya', '0', '', NULL, '0', '', '0'),
('1185', '1169', 'CN Global Lanka (Pvt) Ltd', 'CN Global ', 'Colombo 02', '1', '4', 'EV/S', '2', '', '4510', '1202', '4500', '1', 'Colombo 02', '0', '', NULL, '0', '', '0'),
('1186', '1170', 'Ocen Mobile', 'Ocen Mobile-Nimendra', 'Kahawaththe', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Kahawaththe', '0', '', NULL, '0', '', '0'),
('1187', '1171', 'SICT Computers', 'SICT Computers', 'Godakawela', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Godakawela', '0', '', NULL, '0', '', '0'),
('1188', '1172', 'Pansilu Book Shop', 'Pansilu Book Shop-Ijas', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1189', '1173', 'Shathusa Video Vision', 'Shathusa Video Vision-Ijas', '3rd Mile Post', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', '3rd Mile Post', '0', '', NULL, '0', '', '0'),
('1190', '1174', 'San Book Center', 'San Book Center', '', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1191', '1175', 'Info Net Lanka', 'Info Net Lanka-Roshan', 'No 573/A,Lake Road,Boralegamuwa', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 573/A,Lake Road,Boralegamuwa', '0', '', NULL, '0', '', '0'),
('1192', '1176', 'Uni Tec Gadgets', 'Uni Tec Gadgets-Roshsn', '123A,Sudharma Road,Kattiya Junction', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', '123A,Sudharma Road,Kattiya Junction', '0', '', NULL, '0', '', '0'),
('1193', '1177', 'Hight Tech Gelley', 'Hight Tech Gelley-Roshan', 'Maharagama', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Maharagama', '0', '', NULL, '0', '', '0'),
('1194', '1178', 'Ringing More Mobile', 'Ringing More Mobile-Roshan', '345,Kotte Road,Rajagiriya\n\n\n\n\n\n\n\n\n', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', '345,Kotte Road,Rajagiriya\n\n\n\n\n\n\n\n\n', '0', '', NULL, '0', '', '0'),
('1195', '1179', 'Detech Solutions', 'Detech Solutions-Roshan', '23/1C Nawinna Maharagama', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', '23/1C Nawinna Maharagama', '0', '', NULL, '0', '', '0'),
('1196', '1180', 'Kotte Movie Shop', 'Kotte Movie Shop-Roshan', '411,Thalawathugoda Road,Pitaktte', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', '411,Thalawathugoda Road,Pitaktte', '0', '', NULL, '0', '', '0'),
('1197', '1181', '3C Computers', '3C Computers-Roshan', '26/17 Metro Center.Athurugiya Road,Malabe', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', '26/17 Metro Center.Athurugiya Road,Malabe', '3', '', NULL, '0', '', '0'),
('1198', '1182', '3D Computers', '3D Computers-Roshan', 'Thalahena,Malabe', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Thalahena,Malabe', '0', '', NULL, '0', '', '0'),
('1199', '1183', 'Nexx Com', 'Nexx Com-Roshan', 'Kaduwela Road,Battaramulla', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Kaduwela Road,Battaramulla', '0', '', NULL, '0', '', '0'),
('1200', '1184', 'NEX Computers', 'NEX Computers-Roshan', 'Kotte Road,Rajagiriya', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Kotte Road,Rajagiriya', '0', '', NULL, '0', '', '0'),
('1201', '1185', 'AMP Ceylon (Pvt) Ltd', 'AMP Ceylon (Pvt) Ltd', 'Phase 2, E.P.Z\nKatunayake', '1', '25', 'EV/S', '2', '', '4510', '1200', '4500', '1', 'Phase 2, E.P.Z\nKatunayake', '0', '', NULL, '0', '', '0'),
('1202', '1186', 'Star Link', 'Star Link', 'Mobile Phone Shop\n84 Power House Road\nTrincomalee', '1', '23', 'EV/S', '2', '', '4510', '1200', '4500', '1', 'Mobile Phone Shop\n84 Power House Road\nTrincomalee', '0', '', NULL, '0', '', '0'),
('1203', '1187', 'Reema Phone Shop', 'Reema Phone Shop', 'Main Street\nOddamavadi', '1', '23', 'EV/S', '2', '', '4510', '1200', '4500', '1', 'Main Street\nOddamavadi', '0', '', NULL, '0', '', '0'),
('1204', '1188', 'Iqra Soft ', 'Iqra Mobile', 'Jamaliya Junction\nTrincomalee', '1', '23', 'F04', '2', '', '4510', '1200', '4500', '1', 'Jamaliya Junction\nTrincomalee', '0', '', NULL, '0', '', '0'),
('1205', '1189', 'Digi Tech Computer', 'Digi Tech Computer', '488/9\nMaithreepala Senanayaka Mw,\nAnuradhapura', '1', '23', 'EV/S', '2', '', '4510', '1200', '4500', '1', '488/9\nMaithreepala Senanayaka Mw,\nAnuradhapura', '0', '', NULL, '0', '', '0'),
('1206', '1190', 'D N R Mobile', 'D N R Mobile', '1019 Kandy Road\nTrincomalee', '1', '23', 'EV/S', '2', '', '4510', '1200', '4500', '1', '1019 Kandy Road\nTrincomalee', '0', '', NULL, '0', '', '0'),
('1207', '1191', 'IT Land', 'IT Land', 'Main Street\nkattankudi', '1', '23', 'EV/S', '2', '', '4510', '1200', '4500', '1', 'Main Street\nkattankudi', '0', '', NULL, '0', '', '0'),
('1208', '1192', 'M I C Computers', 'M I C Computers', '24 Sea View\nTrincomalee', '1', '23', 'EV/S', '2', '', '4510', '1200', '4500', '1', '24 Sea View\nTrincomalee', '0', '', NULL, '0', '', '0'),
('1209', '1193', 'Ministry of Transport Management ', 'Ministry of Transport Manageme', 'Colombo Suburban Railway Project', '1', '12', 'EV/S', '2', '', '4510', '1200', '4500', '1', 'Colombo Suburban Railway Project', '0', '', NULL, '0', '', '0'),
('1210', '1194', 'One IT - Australia', 'OneITUSD', '', '1', '1', 'DEF', '2', '', '4510', '1202', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1211', '1195', 'Master Computer - Roshan', 'Master Computer - Roshan', '448 kotte Road\nRajagiriya', '1', '24', 'EV/S', '2', '', '4510', '1200', '4500', '1', '448 kotte Road\nRajagiriya', '0', '', NULL, '0', '', '0'),
('1212', '1196', 'Nex Group of Company - Roshan', 'Nex Group of Company - Roshan', 'Rajagiriya', '1', '24', 'EV/S', '2', '', '4510', '1200', '4500', '1', 'Rajagiriya', '0', '', NULL, '0', '', '0'),
('1213', '1197', 'FNF Brothers Pvt Ltd - Roshan ', 'FNF Brothers Pvt Ltd - Roshan ', '58, Ground Floor\nLiberty Plaza\nColombo 03', '1', '24', 'EV/S', '2', '', '4510', '1200', '4500', '1', '58, Ground Floor\nLiberty Plaza\nColombo 03', '0', '', NULL, '0', '', '0'),
('1214', '1198', 'Mr. Nilantha  - Roshan', 'Mr. Nilantha  - Roshan', '', '1', '24', 'EV/S', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1215', '1199', 'Global Phone Shop -  Nimendra', 'Global Phone Shop -  Nimendra', '85 Galle Rd \nAluthgama\n', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', '85 Galle Rd \nAluthgama\n', '0', '', NULL, '0', '', '0'),
('1216', '1200', 'Decent Technologies - Sinas', 'Decent Technologies - Sinas', '169 Goodshed Road\nRatnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '169 Goodshed Road\nRatnapura', '0', '', NULL, '0', '', '0'),
('1217', '1201', 'ORIKMO Technologies - Nimendra', 'ORIKMO Technologies - Nimendra', 'Galle', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', 'Galle', '0', '', NULL, '0', '', '0'),
('1218', '1202', 'Rishi Tele Mart - Nimendra', 'Rishi Tele Mart - Nimendra', 'Park Road\nNuwaraeliya', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', 'Park Road\nNuwaraeliya', '0', '', NULL, '0', '', '0'),
('1219', '1203', 'ETNESS - NIMENDRA', 'ETNESS - NIMENDRA', 'Kalutara Road\nBandaragama', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', 'Kalutara Road\nBandaragama', '0', '', NULL, '0', '', '0'),
('1220', '1204', 'Mr. Roshan ', 'Mr. Roshan ', '', '1', '4', 'EV/S', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1221', '1205', 'Abans PLC', 'Abans PLC', 'Mr. Chatura Jayawardena.\nSenior Brand Manager\n4th floor, Abans Head Office, \nNo. 498, Galle Road, Colombo 3,\n', '1', '4', 'F04', '1', '4060', '4510', '1200', '4500', '1', 'Mr. Chatura Jayawardena.\nSenior Brand Manager\n4th floor, Abans Head Office, \nNo. 498, Galle Road, Colombo 3,\n', '0', '', NULL, '0', '', '0'),
('1222', '1206', 'Express Mobile Shop', 'Express Mobile Shop', 'Main Street\nPalathoppur\nThoppur', '1', '23', 'EV/S', '2', '', '4510', '1200', '4500', '1', 'Main Street\nPalathoppur\nThoppur', '0', '', NULL, '0', '', '0'),
('1223', '1207', 'Mobile Edge - Mirihana - Roshan', 'Mobile Edge - Mirihana - Rosha', '16 Old Kottawa Rd\nNugegoda', '1', '24', 'EV/S', '2', '', '4510', '1200', '4500', '1', '16 Old Kottawa Rd\nNugegoda', '0', '', NULL, '0', '', '0'),
('1224', '1208', 'Channel Mait Computers - Roshan', 'Channel Mait Computers - Rosha', '80/1 Attidiya\nDehiwala', '1', '24', 'EV/S', '1', '', '4510', '1200', '4500', '1', '80/1 Attidiya\nDehiwala', '0', '', NULL, '0', '', '0'),
('1225', '1209', 'Channel Mait Computers-Roshan-', 'Channel Mait Computers-Roshan-', '80/1 Attidiya \nDehiwala', '1', '24', 'EV/S', '2', '', '4510', '1200', '4500', '1', '80/1 Attidiya \nDehiwala', '0', '', NULL, '0', '', '0'),
('1226', '1210', 'Quick Tech Lanka - Roshan', 'Quick Tech Lanka - Roshan', '390 Galle Rd\nRathmalana', '1', '24', 'EV/S', '2', '', '4510', '1200', '4500', '1', '390 Galle Rd\nRathmalana', '0', '', NULL, '0', '', '0'),
('1227', '1211', 'Siesis IT - Roshan', 'Siesis IT - Roshan', '816/05 Thalahena', '1', '24', 'EV/S', '2', '', '4510', '1200', '4500', '1', '816/05 Thalahena', '0', '', NULL, '0', '', '0'),
('1228', '1212', 'PC Systems - Sinas New', 'PC Systems - Sinas New', '319/c ,01/01\nRatnapura Rd , Balgahamulla\nBalangoda', '1', '16', 'EV/S', '2', '', '4510', '1200', '4500', '1', '319/c ,01/01\nRatnapura Rd , Balgahamulla\nBalangoda', '0', '', NULL, '0', '', '0'),
('1229', '1213', 'F A F Communication - Sinas', 'F A F Communication - Sinas', '343 Kadugalwatta\nRatnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '343 Kadugalwatta\nRatnapura', '0', '', NULL, '0', '', '0'),
('1230', '1214', 'N H Mobile - Sinas', 'N H Mobile - Sinas', '7 Pradeshiya saba Building \nEheliyagoda', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '7 Pradeshiya saba Building \nEheliyagoda', '0', '', NULL, '0', '', '0'),
('1231', '1215', 'Hi Tech Computer Systems - Sinas', 'Hi Tech Computer Systems-Sinas', 'Ratnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Ratnapura', '0', '', NULL, '0', '', '0'),
('1232', '1216', 'Winap Lanka Computers - Sinas', 'Winap Lanka Computers - Sinas', 'Bandarawela', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Bandarawela', '0', '', NULL, '0', '', '0'),
('1233', '1217', 'DVM Computers - Chanaka', 'DVM Computers - Chanaka', '554/A/1/3 Negombo Rd\nMahabage', '1', '2', 'F01', '2', '', '4510', '1200', '4500', '1', '554/A/1/3 Negombo Rd\nMahabage', '0', '', NULL, '0', '', '0'),
('1234', '1218', 'Prabha Soft Creation - Sinas', 'Prabha Soft Creation - Sinas', '106C\nMaib Street\nRakwana , Ratnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '106C\nMaib Street\nRakwana , Ratnapura', '0', '', NULL, '0', '', '0'),
('1235', '1219', 'Genuine Mobile Home - Sinas', 'Genuine Mobile Home - Sinas', '9 New Market Comples\nRatnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '9 New Market Comples\nRatnapura', '0', '', NULL, '0', '', '0'),
('1236', '1220', 'Online Communication &amp; Computers - Sinas', 'Online Communication &amp; Com', 'Kuruwita', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Kuruwita', '0', '', NULL, '0', '', '0'),
('1237', '1221', 'Success Electronics - Sinas', 'Success Electronics - Sinas', 'Kalupalama asala,\nRatnapura Rd\nKalawewa', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Kalupalama asala,\nRatnapura Rd\nKalawewa', '0', '', NULL, '0', '', '0'),
('1238', '1222', 'E Vision Computers - Sinas', 'E Vision Computers - Sinas', 'Weddagala Rd\nKalawana', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Weddagala Rd\nKalawana', '0', '', NULL, '0', '', '0'),
('1239', '1223', 'Enet Computers - Sinas', 'Enet Computers - Sinas', '101 Ratnapura RD\nPelmadulla\n', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '101 Ratnapura RD\nPelmadulla\n', '0', '', NULL, '0', '', '0'),
('1240', '1224', 'Like Minds Consulting Inc.', 'Likeminds', '30, Knightsbridge Road,\nNJ 08854\nUSA.', '1', '12', 'DEF', '2', '', '4510', '1202', '4500', '1', '30, Knightsbridge Road,\nNJ 08854\nUSA.', '0', '', NULL, '0', '', '0'),
('1241', '1225', 'Trans World - Ijas', 'Trans World - Ijas', 'Power House \nMuthur', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', 'Power House \nMuthur', '0', '', NULL, '0', '', '0'),
('1242', '1226', 'Zest Computers - Nimendra', 'Zest Computers - Nimendra', '172/B Galle Rd\nKalutara', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', '172/B Galle Rd\nKalutara', '0', '', NULL, '0', '', '0'),
('1243', '1227', 'Promax Computer Systems - Nimendra', 'Promax Computer Systems ', '2 Parkwood Complex\nNuwara Eliya', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', '2 Parkwood Complex\nNuwara Eliya', '0', '', NULL, '0', '', '0'),
('1244', '1228', 'Xeon Computers - Nimendra', 'Xeon Computers - Nimendra', '8 Viskam Road\nGalwadugoda\nGalle', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', '8 Viskam Road\nGalwadugoda\nGalle', '0', '', NULL, '0', '', '0'),
('1245', '1229', 'Lap&#039;s Zone - Nimendra', 'Lap&#039;s Zone - Nimendra', '4 Kalidasa Rd\nMatara', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', '4 Kalidasa Rd\nMatara', '0', '', NULL, '0', '', '0'),
('1246', '1230', 'CELLETRA - Roshan', 'CELLETRA - Roshan', '1075A Old Kotte rd\nWelikada&#039;\nRajagiriya', '1', '24', 'F06', '2', '', '4510', '1200', '4500', '1', '1075A Old Kotte rd\nWelikada&#039;\nRajagiriya', '0', '', NULL, '0', '', '0'),
('1247', '1231', 'Flicks Video shop - Roshan', 'Flicks Video shop - Roshan', 'Rajagiriya', '1', '24', 'F06', '2', '', '4510', '1200', '4500', '1', 'Rajagiriya', '0', '', NULL, '0', '', '0'),
('1248', '1232', 'C.S. Studio &amp; Communication -Sinas', 'C.S. Studio &amp; Communicatio', 'Balawinna\nPalebadda', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Balawinna\nPalebadda', '0', '', NULL, '0', '', '0'),
('1249', '1233', 'Planet Technical -Sinas', 'Planet Technical -Sinas', 'Palama Asala\nVitanagama\nAyagama', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Palama Asala\nVitanagama\nAyagama', '0', '', NULL, '0', '', '0'),
('1250', '1234', 'M.M Computer &amp; Mobile - Sinas', 'M.M Computer &amp; Mobile - Si', 'Galbada  Junction\nGallaala \nRatnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Galbada  Junction\nGallaala \nRatnapura', '0', '', NULL, '0', '', '0'),
('1251', '1235', 'INTEL GSM - Sinas', 'INTEL GSM - Sinas', 'Bandarawela', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Bandarawela', '0', '', NULL, '0', '', '0'),
('1252', '1236', 'Easy Technology - Sinas', 'Easy Technology - Sinas', '12 New Shopping Complex\nHempala Munidasa Mawatha', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '12 New Shopping Complex\nHempala Munidasa Mawatha', '0', '', NULL, '0', '', '0'),
('1253', '1237', 'Naflan.Com - Sinas', 'Naflan.Com - Sinas', 'Ratnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Ratnapura', '0', '', NULL, '0', '', '0'),
('1254', '1238', 'PC Mart Computer Sales &amp; Repair Center Sinas', 'PC Mart Computer Sales - Sinas', 'Ratnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Ratnapura', '0', '', NULL, '0', '', '0'),
('1255', '1239', 'Suranga Mobile - Sinas', 'Suranga Mobile - Sinas', 'Bus Stand\nRatnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Bus Stand\nRatnapura', '0', '', NULL, '0', '', '0'),
('1256', '1240', 'ARC Computers- Sinas', 'ARC Computers- Sinas', 'Darmaduta road\nBadulla', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Darmaduta road\nBadulla', '0', '', NULL, '0', '', '0'),
('1257', '1241', 'F N F Communication -Sinas', 'F N F Communication -Sinas', 'Ratnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Ratnapura', '0', '', NULL, '0', '', '0'),
('1258', '1242', 'F M Rilwan - Sinas', 'F M Rilwan - Sinas', '', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1259', '1243', 'UltraNet Computers - sinas', 'UltraNet Computers - sinas', 'NIvetegala', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'NIvetegala', '0', '', NULL, '0', '', '0'),
('1260', '1244', 'I Support Company - Sinas', 'I Support Company - Sinas', 'Rakwana Rd\nPalmadulla', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Rakwana Rd\nPalmadulla', '0', '', NULL, '0', '', '0'),
('1261', '1245', 'Malsha Communication - Sinas', 'Malsha Communication - Sinas', 'Sooriyawewa Town', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Sooriyawewa Town', '0', '', NULL, '0', '', '0'),
('1262', '1246', 'H.D Computers - Nimendra ', 'H.D Computers - Nimendra ', '369/2 Wilegoda\nKalutara ', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', '369/2 Wilegoda\nKalutara ', '0', '', NULL, '0', '', '0'),
('1263', '1247', 'P &amp; J Grocery - Nimnedra ', 'P &amp; J Grocery - Nimnedra ', 'Kuda Payagala\nPayagala', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', 'Kuda Payagala\nPayagala', '0', '', NULL, '0', '', '0'),
('1264', '1248', 'Evolutions of the Computer Solution - Nimendra ', 'Evolutions of the Computer ', 'Kanda Udawatta Road ,\nWadduwa', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', 'Kanda Udawatta Road ,\nWadduwa', '0', '', NULL, '0', '', '0'),
('1265', '1249', 'P.CEYL COMPUTERS -Nimendra', 'P.CEYL COMPUTERS -Nimendra', 'Bandaragama Rd\nMoranthuduwa', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', 'Bandaragama Rd\nMoranthuduwa', '0', '', NULL, '0', '', '0'),
('1266', '1250', 'Trinco Ravanan Technology - Ijas', 'Trinco Ravanan Technology ', 'Thiruganasampanthar st\nTrinco', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', 'Thiruganasampanthar st\nTrinco', '0', '', NULL, '0', '', '0'),
('1267', '1251', 'S.T Com -Ijas', 'S.T Com -Ijas', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1268', '1252', 'Mega Phone Shop - Ijas', 'Mega Phone Shop - Ijas', 'Dockyard Road\nTrincomalee ', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', 'Dockyard Road\nTrincomalee ', '0', '', NULL, '0', '', '0'),
('1269', '1253', 'Mr Thilina - Dilruk ', 'Mr Thilina - Dilruk ', 'Beliatta', '1', '5', 'F04', '2', '', '4510', '1200', '4500', '1', 'Beliatta', '0', '', NULL, '0', '', '0'),
('1270', '1254', 'Barclays Computers Pvt Ltd', 'Barclays Computers Pvt Ltd', 'Galle Rd\nColombo 04\n\n', '1', '12', 'EV/S', '2', '', '4510', '1200', '4500', '1', 'Galle Rd\nColombo 04\n\n', '0', '', NULL, '0', '', '0'),
('1271', '1255', 'M.S Computers - Sinas', 'M.S Computers - Sinas', 'Main Street\nGodakawela', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Main Street\nGodakawela', '0', '', NULL, '0', '', '0'),
('1272', '1256', 'S.T Site Computers -Sinas ', 'S.T Site Computers -Sinas ', '195\nMain Street\nGodakawala', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '195\nMain Street\nGodakawala', '0', '', NULL, '0', '', '0'),
('1273', '1257', 'IT LAB -Sinas', 'IT LAB -Sinas', 'Rakwana Road\nPalmadulla', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Rakwana Road\nPalmadulla', '0', '', NULL, '0', '', '0'),
('1274', '1258', 'Skynet Solutions - Sinas', 'Skynet Solutions - Sinas', 'Ayagama', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Ayagama', '0', '', NULL, '0', '', '0'),
('1275', '1259', '4D M Tec - Sinas', '4D M Tec - Sinas', 'Main Street\nBogawantalawa', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Main Street\nBogawantalawa', '0', '', NULL, '0', '', '0'),
('1276', '1260', 'Nanasala Mobile - Sinas', 'Nanasala Mobile - Sinas', '102 Bus Stand \nTanamalwila ', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '102 Bus Stand \nTanamalwila ', '0', '', NULL, '0', '', '0'),
('1277', '1261', 'C.T Computers -Sinas', 'C.T Computers -Sinas', 'Bus Stand\nTanamalwila', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Bus Stand\nTanamalwila', '0', '', NULL, '0', '', '0'),
('1278', '1262', 'R.S Mobile - Sinas ', 'R.S Mobile - Sinas ', '403 Kudugalwatta\nRatnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '403 Kudugalwatta\nRatnapura', '0', '', NULL, '0', '', '0'),
('1279', '1263', 'VIP Technologies Pvt Ltd -Roshan', 'VIP Technologies Pvt Ltd -Rosh', '', '1', '24', 'EV/S', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1280', '1264', 'Next Solutions - Roshan', 'Next Solutions - Roshan', 'pelawatta', '1', '24', 'F03', '2', '', '4510', '1200', '4500', '1', 'pelawatta', '0', '', NULL, '0', '', '0'),
('1281', '1265', 'I Care Computers &amp; Mobile - Roshan ', 'I Care Computers &amp; Mobile', 'Ingiriya', '1', '24', 'EV/S', '2', '', '4510', '1200', '4500', '1', 'Ingiriya', '0', '', NULL, '0', '', '0'),
('1282', '1266', 'M.I Mobile -Nimendra ', 'M.I Mobile -Nimendra ', 'BNS Store\nKoladiya Junction \nKalutara South\n', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'BNS Store\nKoladiya Junction \nKalutara South\n', '0', '', NULL, '0', '', '0'),
('1283', '1267', 'LAP HUB Computers - Nimendra', 'LAP HUB Computers - Nimendra', 'Wadiyamankada\nWaskaduwa\nKalutara', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', 'Wadiyamankada\nWaskaduwa\nKalutara', '0', '', NULL, '0', '', '0'),
('1284', '1268', 'N.D.R Solutions - Nimendra', 'N.D.R Solutions - Nimendra', 'Nagoda\nKalutara', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', 'Nagoda\nKalutara', '0', '', NULL, '0', '', '0'),
('1285', '1269', 'E Zone Communication - Nimendra ', 'E Zone Communication -Nimendra', 'Galle Rd\nMaggona ', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', 'Galle Rd\nMaggona ', '0', '', NULL, '0', '', '0'),
('1286', '1270', 'Navinda Computer Services - Nimendra', 'Navinda Computer - Nimendra', 'Kotmale Rd\nNawalapitiya', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', 'Kotmale Rd\nNawalapitiya', '0', '', NULL, '0', '', '0'),
('1287', '1271', 'Creative Tech Computer - Chanaka', 'Creative Tech Computer - Chana', 'Dimo Junction\nSiyambalape', '1', '2', 'F01', '2', '', '4510', '1200', '4500', '1', 'Dimo Junction\nSiyambalape', '0', '', NULL, '0', '', '0'),
('1288', '1272', 'Bilal Traders - Ijas', 'Bilal Traders - Ijas', 'Old Market Rd\nOddamavadi 03', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', 'Old Market Rd\nOddamavadi 03', '0', '', NULL, '0', '', '0'),
('1289', '1273', 'A-Z Mobiles', 'A-Z Mobiles-Ijas', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1290', '1274', 'Pala Net Computers', 'Pala Net Com-Sinaz', 'Kalawana road,', '1', '16', 'F04', '2', '', '4510', '1204', '4500', '1', 'Kalawana road,', '0', '', NULL, '0', '', '0'),
('1291', '1275', 'Pouja Cellular', 'Pouja Cellular-Sinaz', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('1292', '1276', 'Chajana Mobilr Hoom', 'Chajana Mobilr Hoom-Sinaz', 'Rathnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Rathnapura', '0', '', NULL, '0', '', '0'),
('1293', '1277', 'CALL ME-IJAS', 'CALL ME-IJAS', 'TRINCO', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'TRINCO', '0', '', NULL, '0', '', '0'),
('1294', '1278', 'SKY CREATIONS-IJAS', 'SKY CREATIONS-IJAS', 'TRINCO', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'TRINCO', '0', '', NULL, '0', '', '0'),
('1295', '1279', 'CITY HALL MULTY SHOP', 'CITY HALL MULTY SHOP-IJAS', 'TRINCO', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'TRINCO', '0', '', NULL, '0', '', '0'),
('1296', '1280', 'Pascal Computers', 'Pascal Computers', 'Buththala', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Buththala', '0', '', NULL, '0', '', '0'),
('1297', '1281', 'New express communication', 'New express communication-Rosh', 'Dehiwala', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Dehiwala', '0', '', NULL, '0', '', '0'),
('1298', '1282', 'Trade Wings Enterprises', 'Trade Wings Enterprises-Roshan', 'Battaramulla', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Battaramulla', '0', '', NULL, '0', '', '0'),
('1299', '1283', 'Happy Laptop Service', 'Happy Laptop Service-Roshan', '', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1300', '1284', 'Thilina computers', 'Thilina computers-Dilruk', 'Beliatta', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Beliatta', '0', '', NULL, '0', '', '0'),
('1301', '1285', 'O Zone Computers', 'O Zone Computers-Dilruk', 'deiyandara', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'deiyandara', '0', '', NULL, '0', '', '0'),
('1302', '1286', 'T S I Comouters', 'T S I Comouters', 'Ampara', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Ampara', '0', '', NULL, '0', '', '0'),
('1303', '1287', 'Lotus Computers', 'Lotus Computers-Dilruk', 'Siyabalanduwa', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Siyabalanduwa', '0', '', NULL, '0', '', '0'),
('1304', '1288', 'Star Computer', 'Star Computer-Dilruk', 'Beliatta', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Beliatta', '0', '', NULL, '0', '', '0'),
('1305', '1289', 'Pasidu Computers', 'Pasidu Computers-Dilruk', 'Wellawaya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Wellawaya', '0', '', NULL, '0', '', '0'),
('1306', '1290', 'New SN Computers', 'New SN Computers-Dilruk', 'Wellawaya', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Wellawaya', '0', '', NULL, '0', '', '0'),
('1307', '1291', 'My Computer Technologies', 'My Computer Technologies-Chana', 'Kurunegala', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Kurunegala', '0', '', NULL, '0', '', '0'),
('1308', '1292', 'Hello World -Sinas', 'Hello World -Sinas', '179 , Main Street\nRatnapura', '1', '16', 'F03', '1', '', '4510', '1204', '4500', '1', '179 , Main Street\nRatnapura', '0', '', NULL, '0', '', '0'),
('1309', '1293', 'Savidu.Com -Sinas', 'Savidu.Com -Sinas', 'R.E.T Udawalawe', '1', '16', 'F03', '1', '', '4510', '1204', '4500', '1', 'R.E.T Udawalawe', '0', '', NULL, '0', '', '0'),
('1310', '1294', 'Tileni Mobile &amp; Comm- Sinas', 'Tileni Mobile &amp; Comm- Sina', 'RET udawalawa , ', '1', '16', 'F03', '1', '', '4510', '1204', '4500', '1', 'RET udawalawa , ', '0', '', NULL, '0', '', '0'),
('1311', '1295', 'Siva Rama Computers- Sinas', 'Siva Rama Computers- Sinas', 'Kovil Road , Rakwana ', '1', '16', 'F03', '1', '', '4510', '1204', '4500', '1', 'Kovil Road , Rakwana ', '0', '', NULL, '0', '', '0'),
('1312', '1296', 'Rama Computers &amp; Comm-Sinas', 'Rama Computers &amp; Comm-Sina', '775/5F Winil Complex , Kahawatta', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', '775/5F Winil Complex , Kahawatta', '0', '', NULL, '0', '', '0'),
('1313', '1297', 'Master Mind', 'Master Mind-Ijas', 'Kalmunei', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Kalmunei', '0', '', NULL, '0', '', '0'),
('1314', '1298', 'T Mobiling', 'T Mobiling-Ijas', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1315', '1299', 'Lahiru Mobile Video - Sinas', 'Lahiru Mobile Video - Sinas', 'Ratnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Ratnapura', '0', '', NULL, '0', '', '0'),
('1316', '1300', 'Unitec Computer -Sinas', 'Unitec Computer -Sinas', 'Ratnapura', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Ratnapura', '0', '', NULL, '0', '', '0'),
('1317', '1301', 'Nawodya Mobile &amp; Comm -Sinas', 'Nawodya Mobile &amp; Comm -Sin', 'Tennahena \nGinigathhena', '1', '16', 'F03', '2', '', '4510', '1204', '4500', '1', 'Tennahena \nGinigathhena', '0', '', NULL, '0', '', '0'),
('1318', '1302', 'Sathusa', 'Sathusa-Ijas', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1319', '1303', 'D N R Solutions', 'D N R Solutions-Nimendra', 'Nagoda', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Nagoda', '0', '', NULL, '0', '', '0'),
('1320', '1304', 'Methmi Mobiles', 'Methmi Mobiles-Ijas', 'Muthur', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'Muthur', '0', '', NULL, '0', '', '0'),
('1321', '1305', 'Fulgar Lanka (Pvt) Limited', 'Fulgar Lanka ', 'Katunayake', '1', '1', 'EV/S', '2', '', '4510', '1203', '4500', '1', 'Katunayake', '0', '', NULL, '0', '', '0'),
('1322', '1306', 'Lead Capital Corporation', 'Lead Capital Corporation-LKR', '', '1', '4', 'EV/S', '2', '4050', '4510', '1202', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1323', '1307', 'C.N.S Mobile &amp; Com - Sinas', 'C.N.S Mobile &amp; Com - Sinas', 'Ratnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Ratnapura', '0', '', NULL, '0', '', '0'),
('1324', '1308', 'F.B Mobile &amp; Computers - Sinas', 'F.B Mobile &amp; Computers - S', '31 , Bus Stand ,\nRatnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '31 , Bus Stand ,\nRatnapura', '0', '', NULL, '0', '', '0'),
('1325', '1309', 'Ifa Mobile &amp; Technology - Sinas', 'Ifa Mobile &amp; Technology -S', 'Mahawala\nRatnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Mahawala\nRatnapura', '0', '', NULL, '0', '', '0'),
('1326', '1310', 'AD Tec Computers - Sinas', 'AD Tec Computers - Sinas', 'Balangoda', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Balangoda', '0', '', NULL, '0', '', '0'),
('1327', '1311', 'Smart Mobile Tanamalwila - Sinas', 'Smart Mobile Tanamalwila Sinas', 'Bogaha Asala\nTanamalwila', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Bogaha Asala\nTanamalwila', '0', '', NULL, '0', '', '0'),
('1328', '1312', 'D.N.S Technologies -Sinas ', 'D.N.S Technologies -Sinas ', 'Udagama ,\nEmbilipitiya', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Udagama ,\nEmbilipitiya', '0', '', NULL, '0', '', '0'),
('1329', '1313', 'Kadar Mobile - Sinas', 'Kadar Mobile - Sinas', 'Bus Stand Rd ,\nPalleBadda', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Bus Stand Rd ,\nPalleBadda', '0', '', NULL, '0', '', '0'),
('1330', '1314', 'Umar Mobile &amp; Comm- Sinas', 'Umar Mobile &amp; Comm- Sinas', 'Kudugalwatta ,\nRatnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Kudugalwatta ,\nRatnapura', '0', '', NULL, '0', '', '0'),
('1331', '1315', 'Cine Mobile - Sinas', 'Cine Mobile - Sinas', 'Galbadda Junction ,\nwewalwatta Rd', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Galbadda Junction ,\nwewalwatta Rd', '0', '', NULL, '0', '', '0'),
('1332', '1316', 'Rizad Mobile - Sinas', 'Rizad Mobile - Sinas', 'Dabatana rd , \nHaputala', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Dabatana rd , \nHaputala', '0', '', NULL, '0', '', '0'),
('1333', '1317', 'Rapip Computers- Sinas', 'Rapip Computers- Sinas', 'Lallupitiya', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Lallupitiya', '0', '', NULL, '0', '', '0'),
('1334', '1318', 'Osura Mobile - Sinas', 'Osura Mobile - Sinas', 'Ratnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Ratnapura', '0', '', NULL, '0', '', '0'),
('1335', '1319', 'Rahman Mobile - Sinas', 'Rahman Mobile - Sinas', 'Bogawantalawa', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Bogawantalawa', '0', '', NULL, '0', '', '0'),
('1336', '1320', 'CITE Computers- Sinas', 'CITE Computers- Sinas', 'Banadarawela', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Banadarawela', '0', '', NULL, '0', '', '0'),
('1337', '1321', 'Crystal Music World - Ijas', 'Crystal Music World - Ijas', 'Central Road ', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', 'Central Road ', '0', '', NULL, '0', '', '0'),
('1338', '1322', 'CD World', 'CD World-Ijas', 'AJ Junction', '1', '23', 'F07', '2', '', '4510', '1204', '4500', '1', 'AJ Junction', '0', '', NULL, '0', '', '0'),
('1339', '1323', 'Kumar Studio/Video - Ijas', 'Kumar Studio/Video - Ijas', 'New Shopping Complex\n3rd Mile Post\nTrincomalee', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', 'New Shopping Complex\n3rd Mile Post\nTrincomalee', '0', '', NULL, '0', '', '0'),
('1340', '1324', 'Ring Master - ijas', 'Ring Master - ijas', '3rd Mile Post ,\nTrincomalee', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', '3rd Mile Post ,\nTrincomalee', '0', '', NULL, '0', '', '0'),
('1341', '1325', 'Samadhi Technologies', 'Samadhi Technologies-Dilruk', 'Bibile', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Bibile', '0', '', NULL, '0', '', '0'),
('1342', '1326', 'Real Solutions', 'Real Solutions-Dilruk', '', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1343', '1327', 'M N Multy Shop', 'M N Multy Shop-Dilruk', 'Tallgampola', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Tallgampola', '0', '', NULL, '0', '', '0'),
('1344', '1328', 'B &amp; S Stores - Nimendra', 'B &amp; S Stores - Nimendra', 'Kolaniya junc , \nKalutara South', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', 'Kolaniya junc , \nKalutara South', '0', '', NULL, '0', '', '0'),
('1345', '1329', 'Star Multi Shop - Ijas', 'Star Multi Shop - Ijas', 'Trinco', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', 'Trinco', '0', '', NULL, '0', '', '0'),
('1346', '1330', 'Extreme Tech - Ijas', 'Extreme Tech - Ijas', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1347', '1331', 'Success Techno -  Ijas', 'Success Techno -  Ijas', 'Vidyalayam Road\nTrinco', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', 'Vidyalayam Road\nTrinco', '0', '', NULL, '0', '', '0'),
('1348', '1332', 'Various Computer - Ijas', 'Various Computer - Ijas', 'Kahatagasdigiliya', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', 'Kahatagasdigiliya', '0', '', NULL, '0', '', '0'),
('1349', '1333', 'LAPMART -IJAS', 'LAPMART -IJAS', 'Anuradhapura', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', 'Anuradhapura', '0', '', NULL, '0', '', '0'),
('1350', '1334', 'PC Village - Ijas', 'PC Village - Ijas', 'Kattankudy', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', 'Kattankudy', '0', '', NULL, '0', '', '0'),
('1351', '1335', 'CJ Computer Solutions - Sinas', 'CJ Computer Solutions - Sinas', '90 , Badulla Rd , \nAtampitiya', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '90 , Badulla Rd , \nAtampitiya', '0', '', NULL, '0', '', '0'),
('1352', '1336', 'Zoom Networks - Sinas', 'Zoom Networks - Sinas', '12 , Lower Street ,\nBadulla', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '12 , Lower Street ,\nBadulla', '0', '', NULL, '0', '', '0'),
('1353', '1337', 'Kasun Video &amp; Computers - Sinas', 'Kasun Video &amp; Computers -S', '7 , namunukula ,\nElla', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '7 , namunukula ,\nElla', '0', '', NULL, '0', '', '0'),
('1354', '1338', 'Swiss Net - Sinas', 'Swiss Net - Sinas', 'Bandarawela', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Bandarawela', '0', '', NULL, '0', '', '0'),
('1355', '1339', 'Infaz Com &amp; Comp -Sinas', 'Infaz Com &amp; Comp -Sinas', 'Hapugastenna', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Hapugastenna', '0', '', NULL, '0', '', '0'),
('1356', '1340', 'Azmil Computer - Sinas', 'Azmil Computer - Sinas', 'Ratnajoti Mw ,\nRatnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Ratnajoti Mw ,\nRatnapura', '0', '', NULL, '0', '', '0'),
('1357', '1341', 'Sameera Comm &amp; Comp - Sinas', 'Sameera Comm &amp; Comp - Sina', 'Ratgama', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Ratgama', '0', '', NULL, '0', '', '0'),
('1358', '1342', 'Sripagama Communication -Sinas', 'Sripagama Communication -Sinas', 'Sripagama', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Sripagama', '0', '', NULL, '0', '', '0'),
('1359', '1343', 'Computer Solution &amp; Mobile -Sinas', 'Computer Solution &amp; Mobile', 'B/27 , Commercial Building,\nBandawala  ', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'B/27 , Commercial Building,\nBandawala  ', '0', '', NULL, '0', '', '0'),
('1360', '1344', 'Computers &amp; Comm - Sinas', 'Computers &amp; Comm - Sinas', '', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1361', '1345', 'Oxbrain Computer System - Sinas', 'Oxbrain Computer System -Sinas', 'Main Street,\nDiyatalawa', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Main Street,\nDiyatalawa', '0', '', NULL, '0', '', '0'),
('1362', '1346', 'Comtec Computers', 'Comtec Computers-Nimendra', '', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1363', '1347', 'GI-Tech Solutions (Pvt) Ltd', 'GI-Tech-Nimendra', 'Nuwaraeliya', '1', '22', 'F05', '2', '', '4510', '1204', '4500', '1', 'Nuwaraeliya', '0', '', NULL, '0', '', '0'),
('1364', '1348', 'Babege Computers', 'Babege Computers-Dilruk', 'Bibile', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Bibile', '0', '', NULL, '0', '', '0'),
('1365', '1349', 'I T House', 'I T House-Dilruk', 'Bibile', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Bibile', '0', '', NULL, '0', '', '0'),
('1366', '1350', 'Saranga Computers', 'Saranga Computers-Dilruk', 'Hambanthota', '1', '5', 'F02', '2', '', '4510', '1204', '4500', '1', 'Hambanthota', '0', '', NULL, '0', '', '0'),
('1367', '1351', 'E-Wings Trading', 'E-Wings Trading-Roshan', 'Battaramulla', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Battaramulla', '0', '', NULL, '0', '', '0'),
('1368', '1352', 'E-Happy computers', 'E-Happy computers-Roshan', 'Battaramulla', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'Battaramulla', '0', '', NULL, '0', '', '0'),
('1369', '1353', 'CS Computer &amp; Multi Shop', 'CS Computer-Chanaka', 'Makola', '1', '2', 'F01', '2', '', '4510', '1204', '4500', '1', 'Makola', '0', '', NULL, '0', '', '0'),
('1370', '1354', 'Divisional Secretariat-Colombo', 'Divisional Secretariat-Colombo', 'No 12,\nDam Street,\nColombo 12', '1', '24', 'EV/S', '2', '4065', '4510', '1204', '4500', '1', 'No 12,\nDam Street,\nColombo 12', '0', '', NULL, '0', '', '0'),
('1371', '1355', 'HIGHTEK COMPUTERS - Chanaka', 'HIGHTEK COMPUTERS - Chanaka', 'Mawaramandiya\nSiyabalape', '1', '2', 'F01', '2', '', '4510', '1200', '4500', '1', 'Mawaramandiya\nSiyabalape', '0', '', NULL, '0', '', '0'),
('1372', '1356', 'Deleepa Computer &amp; Comm-Sinas', 'Deleepa Computer &amp; Comm-Si', 'Kesalovitagama Road', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Kesalovitagama Road', '0', '', NULL, '0', '', '0'),
('1373', '1357', 'Walawa Mobile &amp; Computer Solution - Sinas', 'Walawa Mobile &amp; Computer-S', 'Embilipitiya Road\nWalawa', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Embilipitiya Road\nWalawa', '0', '', NULL, '0', '', '0'),
('1374', '1358', 'A One Computer - Sinas', 'A One Computer - Sinas', 'Ayagama', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Ayagama', '0', '', NULL, '0', '', '0'),
('1375', '1359', 'Chapa Mobile -Sinas', 'Chapa Mobile -Sinas', 'Ayagama', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Ayagama', '0', '', NULL, '0', '', '0'),
('1376', '1360', 'I Tech Computer Sys - Sinas', 'I Tech Computer Sys- Sinas', 'Ratnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Ratnapura', '0', '', NULL, '0', '', '0'),
('1377', '1361', 'Computer Solution - Sinas Kaltota', 'Computer Solution - Kaltota', 'Kaltota', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Kaltota', '0', '', NULL, '0', '', '0'),
('1378', '1362', 'I Net Computer - Sinas', 'I Net Computer - Sinas', 'Main Street\nEhaliyagoda', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Main Street\nEhaliyagoda', '0', '', NULL, '0', '', '0'),
('1379', '1363', 'PC Tech System - Nemindra', 'PC Tech System - Nemindra', '474 1/C Arther V D Mw, \nPanadura', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', '474 1/C Arther V D Mw, \nPanadura', '0', '', NULL, '0', '', '0'),
('1380', '1364', 'D.K Computers - Nemindra', 'D.K Computers - Nemindra', 'Awariyawatta , Alubonull\nPanadura', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', 'Awariyawatta , Alubonull\nPanadura', '0', '', NULL, '0', '', '0'),
('1381', '1365', 'Digital Expose - Ijas', 'Digital Expose - Ijas', '147 , Kandy Rd\nTrincomalee', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', '147 , Kandy Rd\nTrincomalee', '0', '', NULL, '0', '', '0'),
('1382', '1366', 'Wide Tech Solution -  Ijas', 'Wide Tech Solution -  Ijas', '167A , Central Road\nTrincomalee', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', '167A , Central Road\nTrincomalee', '0', '', NULL, '0', '', '0'),
('1383', '1367', 'Visualization Unit Comp-Ijas', 'Visualization Unit Comp-Ijas', '836 , Kandy Rd\nMihindapura', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', '836 , Kandy Rd\nMihindapura', '0', '', NULL, '0', '', '0'),
('1384', '1368', 'Promoditha Technology - Ijas', 'Promoditha Technology - Ijas', 'Pottuvil', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', 'Pottuvil', '0', '', NULL, '0', '', '0'),
('1385', '1369', 'Senu Book Shop - Nimendra', 'Senu Book Shop - Nimendra', 'Daluwaththa \nPayagala', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', 'Daluwaththa \nPayagala', '0', '', NULL, '0', '', '0');
INSERT INTO `0_cust_branch` VALUES
('1386', '1370', 'Tharaka Mobile - Sinas', 'Tharaka Mobile - Sinas', 'Badulla Road\nBalangoda', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Badulla Road\nBalangoda', '0', '', NULL, '0', '', '0'),
('1387', '1371', 'Pahan Net - Sinas', 'Pahan Net - Sinas', 'Main Street - \nRatnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Main Street - \nRatnapura', '0', '', NULL, '0', '', '0'),
('1388', '1372', 'R.M.S Mobile - Sinas', 'R.M.S Mobile - Sinas', '14/B \nWallandura\nKahawatta', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', '14/B \nWallandura\nKahawatta', '0', '', NULL, '0', '', '0'),
('1389', '1373', 'Link Natural Products (Pvt) Limited', 'Link Natural', 'P.O Box 2,\nMalinda,\nKapugoda', '1', '1', 'EV/S', '2', '', '4510', '1203', '4500', '1', 'P.O Box 2,\nMalinda,\nKapugoda', '0', '', NULL, '0', '', '0'),
('1390', '1374', 'Rajabima - Dilruk', 'Rajabima - Dilruk', 'LK', '1', '5', 'F02', '2', '', '4510', '1200', '4500', '1', 'LK', '0', '', NULL, '0', '', '0'),
('1391', '1375', 'Akalanka Mobile - Sinas', 'Akalanka Mobile - Sinas', 'No.8\nKalawewa Rd , \nKuruwita', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'No.8\nKalawewa Rd , \nKuruwita', '0', '', NULL, '0', '', '0'),
('1392', '1376', 'VIJI Computers - Sinas', 'VIJI Computers - Sinas', 'Colombo Rd\nNew Town Junction', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Colombo Rd\nNew Town Junction', '0', '', NULL, '0', '', '0'),
('1393', '1377', 'PC Partner Computer Store -SINAS', 'PC Partner Computer -SINAS', 'No , 8\nShopping Complex\nKAPUGALWATTA', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'No , 8\nShopping Complex\nKAPUGALWATTA', '0', '', NULL, '0', '', '0'),
('1394', '1378', 'Samanala Communication - Chanaka', 'Samanala Communication - Chana', 'Mawaramandiya', '1', '2', 'F01', '2', '', '4510', '1200', '4500', '1', 'Mawaramandiya', '0', '', NULL, '0', '', '0'),
('1395', '1379', 'suspence', 'suspence', '', '1', '4', 'F04', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1396', '1384', 'Cash-Zakin', 'Cash-Zakin', '', '1', '26', 'EV/S', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1397', '1385', 'A.S.P.D Mobile &amp; Com -Sinas', 'A.S.P.D Mobile &amp; Com -Sina', 'Bus Stand \nRatnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Bus Stand \nRatnapura', '0', '', NULL, '0', '', '0'),
('1398', '1386', 'Smart Touch PC - IJAS', 'Smart Touch PC - IJAS', 'Trincomalee', '1', '23', 'F07', '2', '', '4510', '1200', '4500', '1', 'Trincomalee', '0', '', NULL, '0', '', '0'),
('1399', '1387', 'Chaminda Computers - Sinas', 'Chaminda Computers - Sinas', 'Muduwa Rd\nPahalahakmuwa\nRatnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Muduwa Rd\nPahalahakmuwa\nRatnapura', '0', '', NULL, '0', '', '0'),
('1400', '1388', 'P.E.M Technologies - Sinas', 'P.E.M Technologies - Sinas', 'Ebilipitiya rd\nUdawalawa', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Ebilipitiya rd\nUdawalawa', '0', '', NULL, '0', '', '0'),
('1401', '1389', 'Oshan Computers- Sinas', 'Oshan Computers- Sinas', 'Balangoda Rd \nTerwanketiya', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Balangoda Rd \nTerwanketiya', '0', '', NULL, '0', '', '0'),
('1402', '1390', 'New Mobile Mart - Sinas', 'New Mobile Mart - Sinas', 'Balangoda', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Balangoda', '0', '', NULL, '0', '', '0'),
('1403', '1391', 'Sandaruwan Cellular - Nimendra', 'Sandaruwan Cellular - Nimendra', 'Bus Stand\nBandaragama', '1', '22', 'F05', '2', '', '4510', '1200', '4500', '1', 'Bus Stand\nBandaragama', '0', '', NULL, '0', '', '0'),
('1404', '1392', 'PS Computer - Dilruk', 'PS Computer - Dilruk', '', '1', '5', 'F02', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0', '', '0'),
('1405', '1393', 'Sandun CD Mobile - Sinas', 'Sandun CD Mobile - Sinas', 'New Bus Stand rd\nRatnapura\n \n', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'New Bus Stand rd\nRatnapura\n \n', '0', '', NULL, '0', '', '0'),
('1406', '1394', 'Mayanta Computers - Sinas', 'Mayanta Computers - Sinas', 'Ratnapura', '1', '16', 'F03', '2', '', '4510', '1200', '4500', '1', 'Ratnapura', '0', '', NULL, '0', '', '0'),
('1407', '1397', 'Lanka Bell WareHouse', 'Lanka Bell WareHouse', 'No 72/2,\nMinuwangoda Road,\nMathammana,Gampaha.\n', '1', '24', 'EV/S', '2', '', '4510', '1204', '4500', '1', 'No 72/2,\nMinuwangoda Road,\nMathammana,Gampaha.\n', '0', '', NULL, '0', '', '0');

### Structure of table `0_debtor_trans` ###

DROP TABLE IF EXISTS `0_debtor_trans`;

CREATE TABLE `0_debtor_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `version` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `debtor_no` int(11) unsigned NOT NULL,
  `branch_code` int(11) NOT NULL DEFAULT '-1',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT '0',
  `order_` int(11) NOT NULL DEFAULT '0',
  `ov_amount` double NOT NULL DEFAULT '0',
  `ov_gst` double NOT NULL DEFAULT '0',
  `ov_freight` double NOT NULL DEFAULT '0',
  `ov_freight_tax` double NOT NULL DEFAULT '0',
  `ov_discount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  `ship_via` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `done_by` int(2) DEFAULT NULL,
  PRIMARY KEY (`type`,`trans_no`,`debtor_no`),
  KEY `debtor_no` (`debtor_no`,`branch_code`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans` ###


### Structure of table `0_debtor_trans_details` ###

DROP TABLE IF EXISTS `0_debtor_trans_details`;

CREATE TABLE `0_debtor_trans_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_trans_no` int(11) DEFAULT NULL,
  `debtor_trans_type` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `unit_price` double NOT NULL DEFAULT '0',
  `unit_tax` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `discount_percent` double NOT NULL DEFAULT '0',
  `standard_cost` double NOT NULL DEFAULT '0',
  `qty_done` double NOT NULL DEFAULT '0',
  `src_id` int(11) NOT NULL,
  `done_by` int(2) DEFAULT NULL,
  `line_location` char(15) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`debtor_trans_type`,`debtor_trans_no`),
  KEY `src_id` (`src_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans_details` ###


### Structure of table `0_debtors_master` ###

DROP TABLE IF EXISTS `0_debtors_master`;

CREATE TABLE `0_debtors_master` (
  `debtor_no` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `debtor_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `address` tinytext COLLATE utf8_unicode_ci,
  `tax_id` varchar(55) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type` int(11) NOT NULL DEFAULT '1',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `credit_status` int(11) NOT NULL DEFAULT '0',
  `payment_terms` int(11) DEFAULT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `pymt_discount` double NOT NULL DEFAULT '0',
  `credit_limit` float NOT NULL DEFAULT '1000',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `crm_no` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`debtor_no`),
  UNIQUE KEY `debtor_ref` (`debtor_ref`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=1398 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtors_master` ###

INSERT INTO `0_debtors_master` VALUES
('1', 'National Lotteries Board', 'nlb', '234/2, Galle Road,\nColombo 3.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '800000', '', '0', ''),
('2', 'BAM Holdings', 'bam', 'BAM Holdings Limited\n120, Station Road\nHomagama.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('3', 'Bartleet Produce Marketing(Pvt)Ltd.', 'Bartleet', 'Bartleet Produce Marketing(Pvt)Ltd.\n211/10 Veluwana Place\nColombo 9.\n', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('4', 'Employee Trust Fund Board', 'etf', 'Employee Trust Fund Board\n44/5, Narahenpita Road,\nNawala.\n', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('5', 'De La Ru Lanka (Pvt)Ltd.', 'Delaru', 'De La Ru Lanka (Pvt)Ltd.\nExport Processing Zone\nBiyagama\n', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('6', 'Field Services Limited', 'field', 'Field Services Limited\n26, Milagiriya Avenue\nColombo 4.\n', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('7', 'Free Lanka Trading Co; Ltd.', 'Free Lanka Trading Co; Ltd.', 'Free Lanka Trading Co; Ltd.\nLevel 3, Prince Alfred Tower\nColombo 3.\n', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('8', 'Inbay Limited', 'inbay', 'Inbay Limited\nOne Selforde Street,\nClerkenwell,\nLondon ECIR OBE', '', 'LKR', '1', '6', '0', '1', '3', '0', '0', '500000', 'Monthly charges for export of IT support services for Inbay Ltd. of UK.', '0', ''),
('9', 'MOL Logistics Lanka (Private) Limited', 'MOL Logistics-Mitsui', 'Ms.Hannelore Baldsing\nLevel 4,\nBTL Shipping House,\n45/2,Braybrooke Street,\nColombo 02', '', 'LKR', '1', '7', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('10', 'Sanasa Development Bank Ltd.', 'sanasa', '12,Edmonton Lane,\nColombo 6', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('11', 'Unique Pharmacy', 'unique pharma', 'Negombo.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('13', 'Rosen Enterprises (Pvt)Ltd', 'rosen', 'No.14, Station Road,\nMaharagama.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('14', 'Nawaloka Hospitals (Pvt)Ltd', 'nawaloka hosp', 'Slave Island,\nColombo 2.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('15', 'Asiri Hospitals (Pvt)Ltd.', 'asiri hosp', 'Kirula Road,\nColombo 5.', '', 'LKR', '1', '0', '0', '1', '2', '0', '0', '500000', '', '1', ''),
('16', 'Pannipitiya Nursing Home (Pvt)Ltd.', 'pannipitiya NH', 'Havelock Road,\nPannipitiya.', '', 'LKR', '1', '0', '0', '1', '2', '0', '0', '500000', '', '1', ''),
('17', 'Sridhara Pharmacy', 'sridhara pharma', 'Colombo.', '', 'LKR', '1', '0', '0', '1', '4', '0', '0', '500000', '', '1', ''),
('18', 'Devon Pharmacy', 'devon pharma', 'Galle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('19', 'Pathirage Pharmacy', 'pathirage pharma', 'Karapitiya, \nGalle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('21', 'Central Hospital (Pvt.) Ltd.', 'the central', '114,Norris Canal Road,\nColombo 10.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('22', 'Thamudi Pharmacy', 'thamudi pharma', 'Karapitiya,\nGalle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('23', 'Nipuna Pharmacy', 'nipuna pharma', 'Galle,', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('24', 'Teaching Hospital', 'teaching hosp', 'Kurunegala.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('25', 'National Hospital of Sri Lanka', 'national hosp', 'Colombo 10.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('26', 'Leesons Hospital', 'leesons hosp', 'Ragama.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('27', 'Ragama Pharmacy', 'ragama pharma', '(Franchised) Osu Sala, \n34, Tewatta Road,\nRagama.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('28', 'The Pharmacy', 'the pharmacy', 'Negombo.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('29', 'MaMa Pharmacy', 'mama pharma', 'No. 11/1, Talagolla Road,\nHospital Junction,\nRagama.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('30', 'Ceylinco Health Care Services Limited', 'ceylinco-hc', '60, Park Street,\nColombo 02.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('32', 'Co-operative Hospital', 'co-op hosp ', NULL, '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('33', 'Hemas Hospital', 'hemas hosp', 'Wattala.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('34', 'Hasmira Pharmacy', 'hasmira pharma', 'Pinnaduwa.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('35', 'Lu Lu Pharmacy', 'lulu pharma', '7/1A, Bandaranayake Place,\nThanipolgaha Junction,\nGalle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('36', 'Kuruduwatta Pharmacy', 'kuruduwatta pharma', 'Gintota.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('37', 'New Lanka Pharmacy', 'new lanka', 'No.09, Karapitiya,\nGalle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('38', 'Dr. Nalin Geeganage', 'Dr. Nalin', 'General Hospital,\nHambantota.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('39', 'Sithari Pharmacy', 'sithari pharma', 'No. 90,Mahaveediya,\nAmbalantota.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('40', 'Nakiyadeniya Pharmacy', 'nakiyadnya pharma', 'Nakiyadeniya.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('41', 'New Piyasiri Medical', 'piyasiri ph', 'Akuressa.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('42', 'Makuluwa Pharmacy', 'makuluwa pharma', 'Makuluwa Junction,\nGalle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('43', 'Monaragala Nursing Home', 'monaragla NH', 'No.124, Pottuvill Road,\nMonaragala.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('44', 'Bodhi Pharmacy', 'bodhi pharma', 'Opposite Hospital,\nSirigala,\nMonaragala.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('45', 'New Sausiri Pharmacy and Grocery', 'new sausiri pharma', 'No.78, Main Street,\nMonaragala.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('46', 'Monaragala Pharmacy', 'monaragla pharma', 'Monaragala.', '', 'LKR', '1', '0', '0', '1', '4', '0', '0', '500000', '', '1', ''),
('47', 'Dr. W. K. Dissanayake', 'Dr. Dissanayake', 'Deberawewa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('48', 'Isuru Medi House', 'isuru medi', 'Hambantota.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('49', 'Jayasinghe Pharmacy', 'jayasinghe pharma', 'Hambantota.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('50', 'Dr. H. K. Prabhath Lakmal', 'Dr. Prabhath', 'Heenmara.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('51', 'Chathuranga Pharmacy', 'chathu pharma', 'Ketanwila, Akuressa.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('52', 'Dr. Jeewan Nanayakkara', 'Dr. Jeewan', 'Ambalamwaththa,\nGalle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('53', 'Dr. G. H. Amarasiri', 'Dr. G, Amarasiri', 'Yatadola, Mathugama.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('54', 'Chaminda Pharmacy', 'chaminda pharma', 'Piyadigama,\nGalle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('55', 'Central Pharmacy', 'central pharma', '01, Ingiriya Road,\nPadukka.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('56', 'New Peoples Pharmacy', 'new peoples ph', 'Negombo Road,\nMahabage.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('57', 'Sethma Hospitals', 'sethma hosp', 'Gampaha.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('58', 'Sathira Pharmacy', 'sathira pharma', 'Gampaha.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('59', 'Anura Pharmacy', 'anura pharma', 'Gampaha.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('60', 'K. F. Medical Centre', 'kf medi centre', '186, Colombo Road,\nMalwana.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('61', 'Metro Pharmacy', 'metro', 'Mathugama.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('62', 'New Philip Hospitals', 'philip hosp', 'Kaluthara.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('63', 'Gihan Pharmacy &amp; Grocery', 'gihan pharma', 'Thawalama Junction,\nThawalama,\nGalle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('64', 'Royal Pharmacy', 'royal pharma', 'Sarenthukade Junction,\nGalle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('65', 'Salaka Pharmacy', 'salaka pharma', 'Weligama.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('66', 'Wickrama Pharmacy', 'wickrama pharma', 'Nagoda, Kaluthara.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('67', 'Wasana Enterprises', 'wasana', 'No. 90,Elapitiwala, Ragama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('68', 'mjf', 'M.J.F Exports', 'Colombo', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('70', 'Certis Lanka Security Solutions(Pvt)Ltd.', 'certis', 'Colombo', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('72', 'Vasa Infotech Services (Pvt)Ltd.', 'vasa', 'Front Street\nColombo 1.', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('73', 'Cooperation for Industrial Development Lanka(Pvt)Ltd', 'coopid', '81/7 Kynsey Road,\nColombo 8\nSri Lanka', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('74', 'Karapitiya Private Hospital', 'karapitiya', 'Talagoha', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('75', 'Wijeratne Pharmacy', 'wijeratna', 'Ambalangoda', '', 'LKR', '1', '0', '0', '1', '4', '0', '0', '500000', '', '1', ''),
('76', 'Dr.Indika Samanmalee', 'indika', 'Weligama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('78', 'Sanuja Pharmacy', 'sanuja', 'Nakiyadeniya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('79', 'New Wijaya Pharmacy', 'newwijaya', 'Tangalle', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('80', 'Karapitiya Osusala', 'karapitiyaosusala', 'Karapitiya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('81', 'Dr.Jagath Premathilake', 'jagath', 'Galle', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('82', 'Dr.V.C.K.Rathnayake', 'rathnayake', 'Nakiyadeniya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('83', 'Sirigala Pharmacy', 'sirigala', 'Monaragala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('84', 'Western Pharmacy', 'western', 'Borella', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('85', 'Peoples Pharmacy', 'peoples', 'Wattala.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('86', 'Good Health Pharmacy', 'goodhealth', 'Wattala.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('87', 'Prasanna Pharmacy', 'prasanna', 'Ja-ela', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('88', 'City Pharmacy', 'city', 'Ja-ela', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('90', 'Dr.Darshana Kumarasinghe', 'darshana', 'Yakkala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('91', 'Teleray Pharmacy', 'teleray', 'Mahabage', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('92', 'New Rio Pharmacy', 'newrio', 'Wattala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('94', 'Negombo Food &amp; Drugs', 'negombo f&amp;d', 'Negombo', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('95', 'St.Annes Nursing Home', 'st.annes', 'Marawila', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('96', 'Nagoda Pharmacy', 'nagoda', 'Nagoda,\nKandana', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('97', 'Dr.Ziyard', 'ziyard', 'Negombo', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('98', 'Dr. Mrs. Mayadunna', 'mayadunna', 'Makola.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('99', 'J.D.Distributor', 'jdistributor', 'Divulapitiya.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('100', 'Pearl Medical Services', 'pearlmedical', 'Church Street,\nColombo 2.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('101', 'New Borella Chemists', 'newborella', 'Borella.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('102', 'New City Pharmacy', 'newcity', 'Wennappuwa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('103', 'S &amp; G Medicals', 's&amp;g', 'Dalupotha,\nNegombo', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('104', 'Dr.K.Sundaralingam', 'sundaralingam', '71, Anderson Road,\nNegombo', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('105', 'Dr.Sanath Fernando', 'sanath', 'Wennappuwa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('106', 'Empire Medical Stores', 'empire', 'Gampaha', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('110', 'Inbay Limited', 'inbayl', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', '', 'GBP', '2', '6', '0', '1', '1', '0', '0', '50000000', '', '0', ''),
('111', 'New Wijerathna Pharmacy', 'new wijerathna', 'Ambalantota.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('112', 'Dr. U.K. Nuwan Shyamal', 'Dr. Nuwan', 'Galle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('113', 'Karapitiya Pharmacy &amp; Grocery', 'karapitiya pharma', 'Mapalagama Road,\nThalagaha.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('114', 'Sirasa Pharmacy', 'sirasa pharma', 'Kiwulawatta, \nBombuwella - Kaluthara.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('115', 'Lanka Pharmacy', 'lanka pharma', 'Thanamallwila.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('116', 'Dr. Dasun S. Landage', 'Dr. Dasun S', 'Base Hospital - Wellawaya.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('117', 'Medi Care Pharmacy ', 'medi care pharma', 'Pitabaddara.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('118', 'Dr. S. Jayawardana', 'Dr. S jayawardana', 'Dispensary, Kalubovitiyana.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('119', 'S. D. Pharmacy', 's.d. pharma', 'Kosnilgoda, Morawa.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('120', 'Dr. Ms. R. S. Gamage', 'Dr. Ms RS Gamage', 'No.12, Mahaveediya,\nAkurassa.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('121', 'Suhanda Pharmacy', 'suhanda pharma', 'Gonamulla.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('122', 'Dr. Amila Kasun', 'Dr. Amila K', 'Weerakatiya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('123', 'Dr. K.P.V.N.R. Dilrukshi', 'Dr. K Dilrukshi', 'Pilana.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('124', 'Kumadhi Pharmacy', 'kumdadhi pharma', 'Bogahagoda.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('125', 'Prabath Pharmacy', 'prabath pharma', 'Imaduwa.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('126', 'Singhe Pharmacy', 'singhe pharma', 'No.51/1A, Olcott Mawatha,\nGalle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('127', 'New City Pharmacy', 'new city pharma', 'No.5C, H.K. Edmond Mawatha.\nSaranthukade Junction,\nGalle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('128', 'Dr. R.A. Thilak N. Ranasinghe', 'Dr. T Ranasinghe', 'Wennappuwa.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('129', 'The Pharmacy Ja-Ela', 'the pharma Ja-ela', 'No.101/11, St Mary&#039;s Road,\nSilver Place, Ja-Ela.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('130', 'Senani&#039;s Grocery &amp; Druggists', 'senani pharma', 'No.04, Main Street, Mihirigama.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('131', 'Shantha Pharmacy', 'shantha pharma', 'Mirigama.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('132', 'Apsara Pharmacy', 'apsara pharma', 'No.10, Opposite Bus Stand,\nPasyala Road,\nMirigama.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('133', 'L.B.Finance Plc.', 'lbfinance', 'Colombo', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('134', 'Dr. S.M. Jagath K. Jayasinghe', 'Dr. Jagath J', 'Family Health Medical Centre.\n18, Station Road, Pallewela.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('135', 'NDB Wealth Management', 'NDB', NULL, '', 'LKR', '1', '0', '0', '1', '4', '0', '0', '500000', '', '0', ''),
('136', 'Ceylinco Hotels Ltd', 'Ceylinco Hotel', NULL, '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('137', 'Staff - Asanka Pathumkumara', 'staffasanka', NULL, '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('138', 'Staff ImprestAccount', 'staffimprest', NULL, '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('139', 'Staff - Perera', 'staffperera', NULL, '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('140', 'DIC LANKA (PVT) LTD', 'DIC', 'No.147, Katuwana Industrial Estate,\nKatuwana Road,\nHomagama.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('141', 'Lawson Pest Control International Pvt Ltd', 'Lawson Pest', 'No.330\nGalle Road\nColombo 04', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('142', 'Child Fund of Sri Lanka', 'childfund', NULL, '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('143', 'Dewa Pharmacy', 'Dewa', NULL, '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('144', 'Dr.D.K.P.Rodrigo', 'Dr.D.K.P.Rodrigo', 'Kadana', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('145', 'Dr.M.Fernando', 'Dr.M.Fernando', 'Wennappuwa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('146', 'Dr.Kumara Ranasinghe', 'Dr.Kumara Ranasinghe', 'Delgoda', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('147', 'Dr.Mrs.Chithra Perera', 'Dr.Mrs.Chithra Perera', 'Kadana', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('148', 'Dr.Vajira Mendis', 'Dr.Vajira Mendis', 'Kadawatha', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('149', 'Milan Pharmacy', 'Milan Pharmacy', 'Ederamulla', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('150', 'Ederamulla Pharamcy', 'Ederamulla Pharamcy', 'Ederamulla', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('151', 'Sanura Pharmacy', 'Sanura Pharmacy', 'Ederamulla', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('152', 'Dr.Mrs.H.Gunasena', 'Dr.Mrs.H.Gunasena', 'Kadana', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('153', 'Dr.C.W.Liyanage', 'Dr.C.W.Liyanage', 'Dompe', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('154', 'P.Lal', 'P.Lal', 'Colombo', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('155', 'Dr.Sunil Mendis', 'Dr.Sunil Mendis', 'Ragama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('156', 'Dr.R.S.Jayakumar', 'Dr.R.S.Jayakumar', 'Hendala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('157', 'Janasuwa Pharmacy', 'Janasuwa Pharmacy', 'Biyagama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('158', 'Janasetha Pharmacy', 'Janasetha', 'Sapugaskanda', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('159', 'Medi Tech Pharmacy', 'Medi Tech', 'Gampaha', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('160', 'Lanka Pharma', 'Lanka ', 'Mahara', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('161', 'Nissi Pharmacy', 'Nissi', 'Wattala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('162', 'Dr.Mrs.C.Hathurusinghe', 'Dr.Mrs.C.Hathurusinghe', 'Wattala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('163', 'Dr.N.P.Hapuarachchi', 'Dr.N.P.Hapuarachchi', 'Sapugastenna', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('164', 'Dr.K.A.E.C.Premarathna', 'Dr.K.A.E.C.Premarathna', 'Nittabuwa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('165', 'My Chemist Pharmacy', 'My Chemist', 'Pallewela', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('166', 'Dr.Naleem Perera', 'Dr.Naleem Perera', 'Kadana', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('167', 'Dr.Sanath Fernando', 'Dr.Sanath Fernando', 'Wennappuwa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('168', 'Dr.D.Kumarasinghe', 'Dr.D.Kumarasinghe', 'Yakkala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('169', 'C&amp;D Pharmacy', 'C&amp;D Pharmacy', 'Bathuwattha', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('170', 'Dr.Sydney Perera', 'Dr.Sydney Perera', 'Ederamulla', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('171', 'Dr.Senaka Herath', 'Dr.Senaka Herath', 'Ederamulla', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('172', 'Dr.Upul Pathirana', 'Dr.Upul Pathirana', 'Dompe', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('173', 'Manahara Pharmacy', 'Manahara', 'Borella', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('174', 'Dr.G.G.Hettiarachchi', 'Dr.G.G.Hettiarachchi', 'Sapugaskanda', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('175', 'People&#039;s York Pharma', 'People&#039;s York', 'Colombo 08', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('176', 'Iraj Pharamaceuticals', 'Iraj ', 'Colombo 11', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('177', 'Dr.E.R.Weerasinghe', 'Dr.E.R.Weerasinghe', 'Bogoda', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('178', 'Ruhunu Medi House', 'Ruhunu Medi House', 'Hambanthota', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('179', 'Dr.A.L.Sarjahan', 'Dr.A.L.Sarjahan', 'Ginthota', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('180', 'Omaya Pharmacy', 'Omaya', 'Thanamalvilla', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('181', 'New royal Pharamcy', 'New royal ', 'Galle', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('182', 'Isurudisi Pharmacy', 'Isurudisi Pharmacy', 'Pilane', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('183', 'New Supun Pharmacy', 'New Supun Pharmacy', 'Weligama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('184', 'New Gihan Pharmacy', 'New Gihan', 'Thawalama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('185', 'New Jayasinghe Pharmacy', 'New Jayasinghe', 'Hambanthota', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('186', 'Sanmed Pharmacy', 'Sanmed', 'Benthota', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('187', 'Dr.Manjula Nakandala', 'Dr.Manjula', 'Monaragala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('188', 'New Metro Pharma', 'New Metro ', 'Mathugama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('189', 'Dr.V.C.K.K.M.Rathnayake', 'Dr.V.C.Rathnayake', 'Tellabuwa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('190', 'Dr.M.I.D.Jayaweera', 'Dr..D.Jayaweera', 'Kirimatimulla', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('191', 'Mega Pharmacy', 'Mega Pharmacy', 'Kirimatimulla', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('192', 'New Central Pharmacy', 'New Central', 'Weligama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('193', 'new Chaminda Pharmacy', 'new Chaminda', 'Piyadigama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('194', 'Dilneth Pharma', 'Dilneth Pharma', 'Boossa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('195', 'K.J.P.Pharmacy', 'K.J.P.Pharmacy', 'Wellawaya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('196', 'Dr.P.Jayasekara', 'Dr.P.Jayasekara', 'Magaha Junction , Kaluthara', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('197', 'Dr.Kusuma Liyanage', 'Dr.Kusuma Liyanage', 'Lelwela', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('198', 'Thisara Pharma', 'Thisara Pharma', 'Karapitiya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('199', 'Delmon Pharmacy', 'Delmon Pharmacy', 'Baddagama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('200', 'Dr.C.W.Janaka', 'Dr.C.W.Janaka', 'Tanipollgaha', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('201', 'D.Sivasutagaran', 'D.Sivasutagaran', NULL, '', 'LKR', '1', '0', '0', '1', '4', '0', '0', '500000', '', '0', ''),
('202', 'National Lotteries Board', 'National Lotteries Board', NULL, '', 'LKR', '1', '0', '0', '1', '4', '0', '0', '500000', '', '0', ''),
('203', 'Jayalath Pharmacy', 'jayalath', 'Galle', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('204', 'Induwara Pharmacy', 'Induwara', 'Induwara Pharmacy and grossary,\nJayanthi Junction,\nUdugama Road,\nGalle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('205', 'New Southern Pharmacy &amp; Grocery', 'Southern PH', ' Southern Pharmacy &amp; Grocery,\nNo 27A1/1,Karapitiya Road, Kalegana,Galle', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('206', 'Dr V C K K M Rathnayake', 'M Rathnayake', 'Dr V C K K M Rathnayake,\nMedical Officer,\nTeaching Hospitial Karapitiya.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('207', 'Pasan Pharmacy', 'Pasan PH', 'Pasan Pharmacy,\nUdugama Road,\nNakiyadeniya,\nGalle', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('208', 'Vimalasiri Pharmacy', 'Vimalasiri', 'Vimalasiri Pharmacy,\nAluthwala,\nGalle', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('209', 'Sithruwana Pharmacy', 'Sithruwana', 'Sithruwana Pharmacy,\nNo;04,Shopping,\nBatapola,\nGalle', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('210', 'Union pharmacy', 'Union ph', 'Union pharmacy,Baddegama Road,\nAmpegama,\nGalle', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('211', 'Dr Susantha Nadasena', 'Dr Susantha', 'Dr Susantha Nadasena,\nSLMC REG No 25553\nNeluwa,\n', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('213', 'Desala Pharmacy', 'Desala PH', 'Desala Pharmacy,\nManikgoda,\nKatugahahena.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('214', 'Ram pharmacy &amp; grocery', 'Ram PH', 'Ram pharmacy &amp; grocery,\nKeeranthidiya,\nNaththuduwa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('215', 'Manahari pharmacy', 'Manahari PH', 'Manahari pharmacy,\nMain Street,\nBalapitiya.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('216', 'Chandana Pharmacy', 'Chandana PH', 'Chandana Pharmacy &amp; grocery,\nGall road,\nYatalamatta.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('217', 'Nagodavithana Pharmacy', 'Nagodavithana  PH', 'Nagodavithana Pharmacy,\nThalgaswala.\n', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('218', 'Medi house', 'Medi house', 'Medi house,\n1st cross road,\nniyagama,\nThalgaswala.\n', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('219', 'Majestic pharmacy', 'Majestic ph', 'Majestic pharmacy,\nno122A,\nMain Street,\nCharoa Town.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('220', 'Jayantha pharmacy', 'Jayantha ph', 'Jayantha pharmacy,\nNo 365A,\nMain street,\ncharga Town.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('221', 'Medi cure pharmacy', 'Medi cure ph', 'Medi cure pharmacy,\n2E,Main street,\ndharaga Town', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('222', 'Lloyed pharmacy', 'Lloyed ph', 'Lloyed pharmacy,\nNo 94,\ngalle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('224', 'Dr Thushara Edirisinghe', 'Dr Thushara', 'Dr Thushara Edirisinghe,\nGeneral Hospital,\nKalutara', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('225', 'DR C C Gurusingha', 'DR C C Gurusingha', 'DR C C Gurusingha,\nElipitiya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('226', 'Dr Saman Patirana', 'Dr Saman Patirana', 'Dr Saman Patirana,\nGalle.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('227', 'Chathuranga pharmacy', 'Chathuranga ph', 'Chathuranga pharmacy,\nGalle', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('228', 'Eraj pharmacy', 'Eraj ph', 'Eraj pharmacy,\nColombo 11.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('229', 'Dr M S Mohamed Ziyard', 'Dr M S Ziyard', 'Dr M S Mohamed Ziyard,\nTseyva hospital (PVT)LTD.No 11 Jayarathna road,\nDean junction ,\nNegambo', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('230', 'city pharmacy', 'City ph', 'city pharmacy,\nno 166 \nWattala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('231', 'Dr K D Rodrigo', 'Dr K D Rodrigo', 'Dr K D Rodrigo,\nMedi house dispansary,\nKadana.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('232', 'Chater House', 'Chater House', 'Chater House,\nNawala road,\nnarahenpita,Colombo 5,\nSri Lanka.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('233', 'Rocevilla pharmacy', 'Rocevilla pharmacy', 'Rocevilla pharmacy,\nEndramulla', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('234', 'Senura pharmacy', 'Senura pharmacy', 'Senura pharmacy,\n233/412,\ngamini jayapura,\nenderamulla,\n', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('235', 'Central medial stores', 'Central medial stores', 'Central medial stores,\ndruggist and grocers,\nMain street,\nDompe', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('237', 'Star distributor', 'Star distributor', 'Star distributor,\nKadawatha', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('238', 'Dr laxman siriwardana', 'Dr L siriwardana', 'Dr laxman siriwardana,\nmirigama clinic &amp; channel center,\nno 186,\nPasyala road,\nMirigama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('239', 'Dr Krishantha samaraweera', 'Dr K samaraweera', 'Dr Krishantha samaraweera,\nMallewa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('240', 'Dr P.Y.R gunathilaka', 'Dr P.Y.R gunathilaka', 'Dr P.Y.R gunathilaka,\nganemulla', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('241', 'Aravints (PVT) LTD', 'Aravints (PVT) LTD', 'Aravints (PVT) LTD,\n125/B,\nold Dispancery Road, \nHendala,\nWattala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('242', 'Mr Sumudu', 'Sumudu', 'Sumudu,\nKadawatha', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('243', 'Abila Marketing services', 'Abila Marketing services', 'Abila Marketing services,\nNo 100/9A,\nBalagala Road,\nHendala,\nWattala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('244', 'evolve', 'Evolve Technologies (Pvt)Ltd.', '329, Galle Road,\nColombo 4.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('245', 'Techtools Integrators (Pvt)Ltd.', 'Techtools', NULL, '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('246', 'Dr Daya Fernando', 'Dr Daya Fernando', 'No264,\nNagoda,\nKandana', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('247', 'Dr P S K Samaranayaka', 'Dr P S K Samaranayaka', 'Wathupitiwala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('248', 'HEALTH PHARMACY &amp; GROCERY', 'HEALTH PHARMACY &amp; GROCERY', 'HEALTH PHARMACY &amp; GROCERY\nKeembiela,\nBaddegama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('249', 'DR U L Piyathilaka', 'DR U L Piyathilaka', 'Dispansary surgery \nMedicare 25,Main street,\nAmbalangoda.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('250', 'Rajmalee Pharmacy &amp; Grocery', 'Rajmalee Pharmacy &amp; Grocer', 'Payagala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('252', 'Isuru Pharmacy', 'Isuru Pharmacy', 'No 7-Cross Road,\nKaluthra', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('253', 'Thilakam Pharmacy', 'Thilakam Pharmacy', NULL, '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('254', 'Kuamari Ph', 'Kuamari Ph', 'Pinnaduna', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('255', 'Chirath Osusala', 'Chirath Osusala', 'Dikkubura', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('256', 'Sisira Pharmacy', 'Sisira Ph', 'Matara', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('257', 'Union Dispancery', 'Union Dispancery', 'Matara', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('258', 'Hiruni Pharmacy', 'Hiruni Ph', 'Dikkwella,\nMatara.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('259', 'Dr Nilanga Samarasinghe', 'Dr Nilanga Samarasinghe', 'Ragama Medical Center,\nEnderamulla', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('260', 'Ashen Pharmacy', 'Ashen Pharmacy', 'Kelaniya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('261', 'Jeewanthi Pharmacy', 'Jeewanthi Pharmacy', NULL, '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('262', 'Asini Pharmacy', 'Asini Pharmacy', 'Dompe', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('263', 'Health palace', 'Health palace', 'Ampegama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('264', 'Westend Pharmacy', 'Westend Pharmacy', 'Megahathanna', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('265', 'We care Pharmacy', 'We care Pharmacy', 'China fort - Beruwala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('266', 'Dr Damayanthi Gurusinha', 'Dr Damayanthi Gurusinha', 'Pituwala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('267', 'Wimalasiri Pharmacy', 'Wimalasiri Pharmacy', 'Aluthwala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('268', 'Dr C Premajayantha', 'Dr C Premajayantha', 'Wattala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('269', 'Chathumina Pharmacy', 'Chathumina Pharmacy', 'Diwalapitiya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('270', 'Jiffy Products SL (PVT) LTD', 'Jiffy Products SL (PVT) LTD', 'Mirigama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('271', 'The Muliti Stitch', 'The Muliti Stitch', 'Negombo', '', 'LKR', '1', '0', '0', '1', '1', '0', '0', '500000', '', '0', ''),
('272', 'Dr Saliva Bombuwala', 'Dr Saliva Bombuwala', 'Minuwangoda', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('274', 'Manadara resort (PVT) LTD', 'Manadara resort (PVT) LTD', 'De-fonseka Road,\nColombo 04.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('275', 'LUMINEX PRIVATE LIMITED', 'LUMINEX PRIVATE LIMITED', 'Colombo', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('276', 'J &amp; H Technologies (Pvt)Ltd.', 'J&amp;H', '#242k, level 2 Nawala Road,  \nNawala.', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('277', 'Abans PLC', 'Abans PLC (Elite)', 'Mr. Chatura Jayawardena.\nSenior Brand Manager\nAbans PLC\n4th floor, Abans Head Office, \nNo. 498, Galle Road, Colombo 3,\n', '', 'LKR', '3', '14', '19', '1', '1', '0', '0', '5000000', '', '0', ''),
('278', 'Sonic Computers', 'Sonic Computers', 'No 50,\nStation Road,\nNugegoda', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('279', 'S S Pharmacy', 'S S Pharmacy', 'Naboda', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('280', 'DR Danasiri Malliyawadu', 'DR Danasiri Malliyawadu', 'Naboda', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('281', 'Samarasinaha PH', 'Samarasinaha PH', 'Pollgampola', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('282', 'Star PH', 'Star PH', 'Kaluthara', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('283', 'Gintota PH', 'Gintota PH', 'Galle road gintota', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('284', 'Pemachandra PH', 'Pemachandra PH', 'Kurudugaha', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('285', 'Elpitiya Medical food city', 'Elpitiya Medical food city', 'Elpitiya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('286', 'MIMS PH', 'MIMS PH', 'Waduraba', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('287', 'M/S Chandara PH', 'M/S Chandara PH', 'Yatlalamula', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('288', 'Dissanayaka PH', 'Dissanayaka PH', 'Neluwa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('289', 'DR Arunlal', 'DR Arunlal', 'Panepitiya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('290', 'Dr P C Liyanage', 'Dr P C Liyanage', 'Welipitiya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('291', 'Sahana PH', 'Sahana PH', 'Telijjawila', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('292', 'Sampath PH', 'Sampath PH', 'Ambalangoda', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('293', 'Dr D R K Sirisena', 'Dr D R K Sirisena', 'Karandeniya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('294', 'Sethsuwa PH', 'Sethsuwa PH', 'Agalawatha', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('295', 'Ravi PH', 'Ravi PH', 'Ithapana', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('296', 'Stenn PH', 'Stenn PH', 'Tanipollgaha', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('297', 'Sathren PH', 'Sathren PH', 'Galle', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('298', 'Taridu PH', 'Taridu PH', 'Mirissa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('299', 'Dr Nilantha Priyasana', 'Dr Nilantha Priyasana', 'Thalgaswela', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('300', 'Polegoda PH', 'Polegoda PH', 'Poligoda', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('301', 'Dr H A C Mangala', 'Dr H A C Mangala', 'Godapitiya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('302', 'Sehansa PH', 'Sehansa PH', 'Rathgama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('303', 'Nayana PH', 'Nayana PH', 'Wathugedara', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('304', 'Saranga PH', 'Saranga PH', 'Tawalama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('305', 'Gayan PH', 'Gayan PH', 'Wetharawitha', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('306', 'Isiwara PH', 'Isiwara PH', 'Nagoda', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('307', 'New Supreem PH', 'New Supreem PH', 'Elpitiya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('308', 'Dr Keertisena vithanage', 'Dr Keertisena vithanage', 'Agalawaththa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('309', 'Karapitiya Medical', 'Karapitiya Medical', 'Ampegama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('310', 'Involve 360 PVT LTD', 'Involve 360 PVT LTD', 'Colombo', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('311', 'Dilhani Chemist', 'Dilhani Chemist', 'Maggona', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('312', 'Tritel Services Pvt. Ltd', 'tritel', 'No.19/4, Sri Saranankara Road,\nKalubowila,\nDehiwala.', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('313', 'Dr Sanath Pathirana', 'Dr Sanath Pathirana', 'Katarvila', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('314', 'Dr Menaka Widanapathirana', 'Dr Menaka Widanapathirana', 'Poraba', '', 'LKR', '1', '0', '0', '1', '5', '0', '0', '500000', '', '1', ''),
('315', 'Dr Krishantha Samaraweera', 'Dr Krishantha Samaraweera', 'Mallewa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('316', 'Amila', 'Amila', 'Colombo', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('317', 'Infinex Solutions (PVT) LTD', 'Infinex Solutions (PVT) LTD', '10 1/1 Unity place,\nColombo 3', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('318', 'THUNDER &amp; NEON (PVT) LTD', 'THUNDER &amp; NEON (PVT) LTD', '191, Kasbewa road, werahera,Boralesgamuwa.', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('319', 'Prasanna PH', 'Prasanna PH', 'Prasanna PH,\nWakwella road,\nGalle\n', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('321', 'Ashoka Chanal Center', 'Ashoka Chanal Center', 'Ashoka Chanal Center,\nBalapitiya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('322', 'Dr Manjula M Kumara', 'Dr Manjula M Kumara', 'Dr Manjula M Kumara,\nBeralihela', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('323', 'Dr Ajith Kumara', 'Dr Ajith Kumara', 'Katharagama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('324', 'Lisara PH', 'Lisara PH', 'Kataragama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('325', 'Dr W Dissanayaka', 'Dr W Dissanayaka', 'Deberawewa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('326', 'Mr Udara Weerasinghe', 'Mr Udara Weerasinghe', 'Singhagiri(PVT)LTD\nNo 515,\nDarley Road,\nColombo 10', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('327', 'Priminto PH', 'Priminto PH', 'Mirigama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('328', 'City School of Architecture Limited', 'City school', 'City School of Architecture Limited, \n120/7, Vidya Mawatha, \nColombo 07.', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '500000', '', '0', ''),
('330', 'Onet Solutions ', 'ONET', 'No 840,Thalagaha Junction,\nGothatuwa New Town\n', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('331', 'Singhagiri Direct (Private ) Limited.', 'Sinhagiri', 'No. 515 ,\nDarley road ,\nColombo 10 .\n', '', 'LKR', '3', '13', '0', '1', '1', '0', '0', '500000', '', '0', ''),
('332', 'Dr Hemantha Fernendo', 'Dr Hemantha Fernendo', 'katuneriya', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('333', 'Senith PH', 'Senith PH', 'Akuressa Road\nBobahagoda', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('334', 'Intime PH', 'Intime PH', 'Dikkubura', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('335', 'Awrasa Ph', 'Awrasa Ph', 'Bombuwala', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('336', 'Suwamadura Ph', 'Suwamadura Ph', 'Mathugama', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('337', 'Dr Janaka Marasinghe', 'Dr Janaka Marasinghe', 'Agalawaththa', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('338', 'Dr Lasitha D Kannangara', 'Dr Lasitha D Kannangara', 'Warakagoda', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('339', 'Chamara PH', 'Chamara PH', 'Galle', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('340', 'Mahanama PH', 'Mahanama PH', 'No 67,\nNew Town,Lunugamwehera', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('341', 'Samantna PH', 'Samantna PH', 'Miriswatha', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('342', 'Medi Line PH', 'Medi Line PH', 'Katugoda', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('343', 'Samadara PH', 'Samadara PH', 'Matthaka', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('344', 'Suprem PH', 'Suprem PH', 'Meetiyagoda', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('346', 'UNICOLOMBO', 'University of Colombo', 'Institute of Human Resource Advancement,\nUniversity of Colombo\n275, Bauddhaloka Mawatha,\nColombo 7.', '', 'LKR', '1', '0', '0', '1', '1', '0', '0', '1500000', '', '0', ''),
('347', 'Dr A J P Amitha', 'Dr A J P Amitha', 'Pannegamuwa', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('348', 'Dr Dayarathna', 'Dr Dayarathna', 'Tanamallwela', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('350', 'City PH (Buttala)', 'City PH (Buttala)', 'No 03,\nBadaikumbura Road,\nButtala\n', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('351', 'Cash Customer', 'Cash ', 'Colombo', '', 'LKR', '3', '0', '0', '1', '4', '0', '0', '500000', '', '0', ''),
('352', 'Dr Iresha Amarasinghe', 'Dr Iresha Amarasinghe', 'Berrolibela', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('353', 'Dr D Kodithuwakku', 'Dr D Kodithuwakku', 'General Hospital Hambantota', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('354', 'Leo PH', 'Leo PH', 'Deberawawa', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('355', 'Priya PH', 'Priya PH', 'Nagas Handiya,\nKalutara North', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('356', 'Omedlak PH', 'Omedlak PH', 'Aluthgama', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('357', 'Vidura PH', 'Vidura PH', 'Dewlapitiya road,\nBalapana', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('358', 'Green Media Partners (pvt) Ltd', 'Green Media Partners (pvt) Ltd', NULL, '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('359', 'Pradeep PH', 'Pradeep PH', 'Rotuba', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('360', 'Mawarala PH', 'Mawarala PH', 'Mawarala', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('361', 'Sadaham PH', 'Sadaham PH', 'urubokka', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('362', 'Dr Chanaka Gayan', 'Dr Chanaka Gayan', 'Kirinda', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('363', 'Suwana PH', 'Suwana PH', 'Katharagama', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('364', 'New Medical Center', 'New Medical Center', 'Udugama', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('365', 'Rajabojun (pvt) Ltd', 'Rajabojun (pvt) Ltd', 'Mr Mishantha Masinghe,\nDirector,\nRajabojun (pvt) Ltd,\nLiberty Arcade,\nColombo 03.', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('366', 'The Elanvital (Pvt) Ltd', 'The Elanvital (Pvt) Ltd', 'The Elanvital (Pvt) Ltd,\nNo28/2,\nBiyagama,\nSri Lanka', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('367', 'C W Mackie PLC', 'C W Mackie PLC', 'C W Mackie PLC,\nReg No PQ 47,\n36,D.R Wijewardena Mawatha,\nColombo 10', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('368', 'Kalany Valley Canneries Ltd', 'Kalany Valley Canneries Ltd', 'Kalany Valley Canneries Ltd,\nNo-436,\nKaluaggala,\nHanwella', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('369', 'Dr Sampath', 'Dr Sampath', 'Dompe', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('370', 'Shehan patherana', 'Shehan patherana', 'Colombo', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('371', 'Manahara PH', 'Manahara PH', 'Wallawaya ', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('372', 'J.H PH', 'J.H PH', 'Thnipolgaha', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '500000', '', '1', ''),
('373', 'My Store .lk', 'mystore', 'Galle Road,\nColombo 4.', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '500000', '', '0', ''),
('374', 'R F R  Group', 'R F R  Group', 'Dubai', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '500000', '', '0', ''),
('375', 'Browns Hospitals', 'Browns Hospitals', 'Ragama', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '0', '', '1', ''),
('376', 'The Golden Key Credit Card Company Limited', 'Golden Key', 'Ceylinco center(P.O Box 2104)\n02,R.A. De Mel Mawatha,\nColombo 04', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '0', '', '0', '');
INSERT INTO `0_debtors_master` VALUES
('377', 'Ushan PH', 'Ushan PH', 'Dodamgoda', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '0', '', '1', ''),
('378', 'Abans Retail (Pvt)Ltd.', 'Abans-Delar', 'Laleendra Brahmana\n498, Galle Road,\nColombo3.', '', 'LKR', '3', '14', '19', '1', '1', '0', '0', '0', '', '0', ''),
('379', 'Lanka Bell Ltd.', 'lankabell', 'No: 344, Galle road, Colombo 3 ', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('380', 'IC Collection (PVT) Ltd', 'IC Collection (PVT) Ltd', 'No 29,\nLauries Road,\nColombo 04', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('381', 'New PH', 'New PH', 'Pugoda', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('382', 'Mobitel (Pvt)Ltd.', 'mobitel', '108, W. A. D. Ramanayake Mawatha,               \nColombo 02,\n', '', 'LKR', '3', '14', '20', '1', '1', '0', '0', '500000', '', '0', ''),
('384', 'LGL Marketing Services (PVT) LTD', 'LGL Marketing', '45,katukurunduwatta Road,\nRatmalana', '', 'LKR', '2', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('385', 'Dr K K S Devika', 'Dr K K S Devika', NULL, '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '0', '', '1', ''),
('386', 'Bus Stand Shoping Comlex PH', 'Bus Stand Shoping Comlex PH', 'Ambalangoda', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '0', '', '1', ''),
('387', 'Sampath Jayawardhena', 'Sampath Jayawardhena', 'Colombo', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('388', 'City Cycle Industries Manufacturing (Pvt) Ltd.', 'City Cycle Industries', 'Gall Road.\nPanadura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('389', 'Red Orchids Restaurant (Pvt) Ltd', 'Red Orchids ', 'De Fonseka Road \nColombo 04', '', 'LKR', '2', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('390', 'Nimal Chemist', 'Nimal Chemist', 'Nimal Chemist,\nNo 90,\nMain Street,\nGalle', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('391', 'Dr.T Edirisinghe', 'Dr.T Edirisinghe', 'Dr.T Edirisinghe,\nPannipitiya', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('392', 'Dr G.H.Amarasiri', 'Dr G.H.Amarasiri', 'Dr G.H.Amarasiri\nYatadola', '', 'LKR', '2', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('393', 'Kahawatte Plantation', 'Kahawatte Plantation', 'Kahawatte Plantation,\nColombo', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('394', 'Singhagiri (Pvt) Ltd.', 'Singhagiri(Pvt)', 'No: 515, Darley Road,\nColombo 10\n', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('395', 'Feroz', 'Feroz', 'pitakotte', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('396', 'Mr Danushka', 'Mr Danushka', 'Matara', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('397', 'AMCOR', 'AMCOR', 'Colombo', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('398', 'DPJ Holdings', 'DPJ Holdings', 'Nawala', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('399', 'South Asia Pacific (PVT) Ltd', 'South Asia Pacific (PVT) Ltd', 'No 233,\nGalle Road,\nColombo 04', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('401', 'MyDeal.lk (Pvt) Ltd', 'MyDeal', 'No 323,Galle Road,\nColombo 4', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('402', 'Mydeal.lk (Pvt) Ltd.', 'Mydeal.lk (Pvt) Ltd.', '323, Galle Road, Colombo 00400', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('403', 'M-Town', 'M-Town', 'Mattegoda', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('404', 'Bookkeeping-AUS', 'Bookkeeping-AUS', 'Australia', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('405', 'Wintech Cellular Services', 'Wintech Cellular Services', '159/1/3,\nMain Street,Colombo 11', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('406', 'Notrthshore College', 'Notrthshore College', '141, Church Road,\n  Colombo 15,\n  Sri Lanka.\n', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('407', 'The High Commission of Pakistan in Sri Lanka', 'The High Commission of Pakista', 'No. 42 &amp; 44, Bullers Ln,\nColombo 00700\nSri Lanka\n', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('408', 'Water Mart Systems', 'Water Mart', 'No 594,\nGalle Road,\nColombo 03', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('409', ' Smart Solutions', ' Smart Solutions', 'No 10, \nSri darmarama road,\nDematagoda,\nColombo 09', '', 'LKR', '3', '0', '0', '1', '3', '0', '0.02', '0', '', '0', ''),
('410', 'ABC Computers (PVT) Ltd', 'ABC Computers ', 'No 447,\nLipton Circus, \nColombo 2', '', 'LKR', '3', '13', '0', '1', '3', '0', '0', '0', '', '0', ''),
('411', 'Green Aircon (pvt) ltd', 'Green Aircon ', 'No 12\nParakumba Place,\nColombo 06', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('412', 'Brantel Lanka (Pvt) Ltd', 'Brantel Lanka', 'No 06,\nR.A De Mel Mawatha,\nColombo 06', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('413', 'Favourite garment (PVT) Ltd', 'Favourite', 'The Landmark(level 6)', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('414', 'Millennium Airlines (PVT) Ltd', 'Millennium Airlines', 'Formerly Deccan Aviation Lanka,\nThe Landmark,level 06,\n385,Gall Road', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('415', 'Regent Plaza (PVT) Ltd', 'Regent', 'The Landmark (Level 6),\n385,Gall Road, Colombo 03', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('416', 'Favourite International (Pvt) Ltd', 'Favourite International', 'The Landmark,\n385,Gall road,\nColombo 03', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('417', 'Mitsu Mobiles Phones', 'Mitsu Mobiles ', 'No 227,\nGalle Road,\nColombo 04', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('418', 'Taruja PH', 'Taruja PH', 'Galle ', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('419', 'Special Task Force', 'Special Task Force', '223,\nBauddaloka Mawatha,\nColombo 07', '', 'LKR', '3', '0', '0', '1', '4', '0', '0', '0', '', '0', ''),
('420', 'celltronics Mega Store', 'celltronics ', '422/A\nGalle Road,\nColombo', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('421', 'Skills International (Pvt) Ltd', 'Skills International ', 'No 321,\nGalle Road,\nColombo 03', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('422', 'Flexiv Micro Systems (pvt) Ltd', 'Flexiv', '30/2,Jesmin park,\nNarahenpita Road,\nNawala', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('423', 'Win Net', 'Win Net', 'Win Net, \nNugegoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('424', 'Shanbe Jeane Corporation (Pvt) Ltd', 'Shanbe', 'No 07A,\nPostmasters Place\nTemple Road\nMt Lavinia\n ', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('425', 'JapanSoft', 'JapanSoft', 'No;05,\nJoseph&#039;s Street\nColombo 04\n', '', 'LKR', '3', '13', '0', '1', '3', '0', '0', '0', '', '0', ''),
('426', 'Vista Advertising &amp; Business Consultants (Pvt) Ltd', 'Vista Advertising', 'No;33,\n14th Lane,\nColombo 03.', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('427', 'VCube', 'VCube', 'No:260/5,\nGalle Road, \nColombo-04', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('428', 'Agaya Hldings (PVT) LTD', 'Agaya', 'Subadrarama Roas,\nNugegoda,10250,\nSri lanka', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('429', 'TVS Lanka Pvt ltd', 'TVS', 'Mr. Sudagaran,\nNo:38,\nOld Negombo Road,\nWattala,\nSri Lanka.\n', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('430', 'Laugfs Supermarket (Pvt) Ltd', 'Laugfs', 'Colombo', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('431', 'AB Fortune Technology Services Private Limited', 'AB Fortune', '5th Floor, SB Tower - 1, Sector 16, Noida\nUttar Pradesh\nINDIA - 201301\n', '', 'USD', '1', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('432', 'Fine Tech PC', 'Fine Tech PC', 'Clinipath Buliding,\nFron of Temple Tree,\nNegambo Road,\nMinuwangoda', '', 'LKR', '3', '13', '0', '1', '1', '0', '0', '0', '', '0', ''),
('433', 'ES Computer', 'ES Computer', 'No 12,\nPrivate Bus Stand,\nMawanella.', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('434', 'Isuru Celleulor', 'Isuru Celleulor', 'Kaduwela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('435', 'Fedora E-Zone Computer', 'Fedora', 'No 07,\nMarket Place,\nKegalle', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('436', 'Dinuka Technologies (Pvt) Ltd', 'Dinuka Technologies', 'Delgoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('437', 'Senitro- IT (Pvt) Ltd', 'Senitro', 'Malabe', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('438', 'ACP Solutions', 'ACP Solutions', 'Homagama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('439', 'i a t Computers', 'i a t Computers', 'Malabe', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('440', 'Yasiru Creations', 'Yasiru Creations', 'Kotikawatte', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('441', 'Samarasinghe Solutions (Pvt) Ltd', 'Samarasinghe Solutions ', 'Kadawatha', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('442', 'Sky Computer &amp; Entertainment', 'Sky Computer', 'Ragama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('443', 'DYNTECH Enterprises ', 'DYNTECH ', 'Waththala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('444', 'MICRO BIT Computers', 'MICRO BIT ', 'Kadawatha', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('445', 'Susara Miusic &amp; Phones Repair Center', 'Susara Miusic &amp; Phones ', 'Nittabuwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('446', 'Soft Green Technology', 'Soft Green ', 'Nittabuwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('447', 'New Total Solutions', 'New Total Solutions', 'Malabe', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('448', 'Mr Wijesekara', 'Mr Wijesekara', NULL, '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('449', 'Radiance Computer Systems', 'Radiance', 'Siyabalape', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('450', 'Nitlan Technologies', 'Nitlan', 'Kaduwela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('451', 'SNN Technologies', 'SNN Technologies', 'Weliweriya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('452', 'NJ Computers', 'NJ Computers', 'Weliweriya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('453', 'Asith Computers', 'Asith Computers', 'Yakkala\n', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('454', 'Neoview (Pvt) Ltd', 'Neoview ', 'Yakkala\n', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('455', 'Rajapaksha Communication', 'Rajapaksha Communication', 'Mawanella', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('456', 'E-Max Computer', 'E-Max Computer', 'Negambo', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('457', 'New Seoul Trade Center', 'New Seoul Trade Center', 'Kiribathgoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('458', 'Sha Tech Zone', 'Sha Tech Zone', 'Kiribathgoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('459', 'Global Payments Asia Pacific Lanka(Pvt)Ltd', 'GlobalPayments', 'Advantage Building Complex\n4th Floor, 74A Dharmapala Mawatha\nColombo 7.', '', 'USD', '1', '0', '0', '1', '1', '0', '0', '1000000', '', '0', ''),
('460', 'The RainTree Hotel', 'The RainTree Hotel', 'Tissamaharama', '', 'LKR', '3', '1', '0', '1', '3', '0', '0', '0', '', '0', ''),
('461', 'Abans PLC', 'Abans PLC (Retail)', 'Mr. Chatura Jayawardena.\nSenior Brand Manager\nAbans PLC\n4th floor, Abans Head Office, \nNo. 498, Galle Road, Colombo 3,', '', 'LKR', '3', '14', '19', '1', '1', '0', '0', '0', '', '0', ''),
('462', 'P &amp; T Computers', 'P &amp; T Computers', 'Batapola', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('463', 'NetCom Computer Services', 'Net Com', 'Minuwangoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('464', 'Ruwani Computers', 'Ruwani Computers', 'Ampawila', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('465', 'Sisith Printers', 'Sisith Printers', 'Katharagama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('466', 'A.G Computer &amp; Services-Tissa', 'A.G Computer -Tissa', 'Tissamaharama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('467', 'Mayura Phone Shop', 'Mayura Phone Shop', 'Tissamaharama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('468', 'The Asia Foundation', 'The Asia Foundation', 'No 30/1, \nBagatalle Rd,\nColombo 00300,\nSri Lanka.\n', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('469', 'Youth Computers Technology', 'Youth Computers ', 'Galle', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('470', 'J &amp; D Group', 'J &amp; D Group', '17/30, \n10th Mile Post,\nKatuwawala,\nBoralesgamuwa,\nSri Lanka.\n', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('471', 'Wheels Lanka Trading (Pvt) Ltd', 'Wheels Lanka', 'No 214,\nHigh level Road,\nKirulapone,\nColombo 06', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('472', 'Malay Restaurant', 'Malay Restaurant', 'No 115,\nHill street,\nDehiwala,\nSri Lanka.\n', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('473', 'Global Payments Asia Pacific Lanka(Pvt)Ltd 01', 'GlobalPayments 01', 'Advantage Building Complex\n4th Floor, 74A Dharmapala Mawatha\nColombo 7.', '', 'LKR', '1', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('474', 'Abeywarna Phones', 'Abeywarna Phones', 'middeniya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('475', 'Three Star', 'Three Star', 'Galle', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('476', 'Beyond Technologies', 'Beyond Technologies', 'Dompe', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('477', 'Global Investment House Ltd.', 'GloInvestments', 'Colombo 1.', '', 'LKR', '2', '15', '0', '1', '1', '0', '0', '0', '', '0', ''),
('478', 'Digital Base Holdings (Pvt) Ltd.', 'Digital Base Holdings', 'No 03,\nDharmaraja Mawatha,\nOff Alfred House Avenue,\nColombo 03\nSri Lanka', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('479', 'Orange Computers', 'Orange Computers', 'Matugama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('480', 'P C Technologies', 'P C Technologies', 'Middeniya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('481', 'Palliyaguru Marketing &amp; Technologies Service', 'Palliyaguru Marketing', 'Gampaha', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('482', 'Shan PC Partner', 'Shan PC', 'Dodangoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('483', 'Galle Net Technologies', 'Galle Net ', 'Gonamulla', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('484', 'IT Mart Computers', 'IT Mart ', 'Embilipitiya\n', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('485', 'Mega PC ', 'Mega PC-Buttala', 'Buttala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('486', 'K S Computers', 'K S Computers', 'Monaragala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('487', 'Chipra Computers', 'Chipra Computers', 'Kirindiwela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('488', 'Tecno Lanka', 'Tecno Lanka', 'Kiribathgoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('489', 'NPS IT Gallery', 'NPS IT Gallery', 'Wennappuwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('490', 'Windicom Computers', 'Windicom Computers', 'Wennappuwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('491', 'Green Computers', 'Green Computers', 'Marawilla', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('492', 'Crest Business Computers', 'Crest Business Computers', 'Gampaha', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('493', 'Flexiv Micro Systems (Pvt) Ltd.', 'Flexiv Micro System', 'DPJ House, \nNo 30/2,\nJesmin Park,\nNarahenpita Road,\nNawala,\nSri Lanka.', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '1', ''),
('494', 'e-Wis', 'e-Wis', 'No 329,\nGalle Road,\nColombo 04,\nSri Lanka', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('495', 'Recon Computers', 'Recon Computers', 'Dompe', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('496', 'SriLucky Computers', 'SriLucky Computers', 'Nittabuwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('497', 'Stylish Computers', 'Stylish Computers', 'Kochchikade', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('498', 'Ruwi Mobiles', 'Ruwi Mobiles', 'Kirindiwela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('499', 'Dinidu PC Solutions', 'Dinidu PC Solutions', 'Pugoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('500', 'Nara IT Solutions', 'Nara IT Solutions', 'Minuwangoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('501', 'Prasad Computers', 'Prasad Computers', 'Mirigama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('502', 'Global Computers', 'Global Computers', 'Gampaha', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('503', 'Way Detect Holdings', 'Way Detect Holdings', 'Kiribathgoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('504', 'Mark Computers', 'Mark Computers', 'Gannemulla', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('505', 'Evident Computers', 'Evident Computers', 'Kiribathgoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('506', 'Makeen Books', 'Makeen Books', 'No 441,\nGalle Road,\nColombo - 03,\nSri Lanka.\n', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('507', 'Micro Print', 'Micro Print', 'Yakkala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('508', 'Dnet Computers', 'Dnet Computers', 'Mirigama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('509', 'Thilakarathna PC Center', 'Thilakarathna PC', 'Mirigama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('510', 'N S Technologies', 'N S Technologies', 'Pasyala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('511', 'Gate Way Computers', 'Gate Way Computers', 'Neluwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('512', 'Ranmuthu Computers', 'Ranmuthu Computers', 'Neluwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('513', 'SK Group (Pvt) Ltd', 'SK Group', 'Mathugama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('514', 'Ceylon IT Solutions', 'Ceylon IT', 'Rathgama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('515', 'Horisen Computers', 'Horisen Computers', 'Hambanthota', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('516', 'B.S.K Cellular', 'B.S.K Cellular', 'Galle', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('517', 'V-TEC Computers', 'V-TEC Computers', 'Monaragala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('518', 'RU Salu Clothing [PVT] Ltd', 'RU Salu Clothing ', 'No:640,\nGiriulla Road,\nKandawala,\nKatana,\nSri Lanka.\n', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('519', 'Nanotek Computer Solutions', 'Nanotek Computer Solutions', 'NO 110A,\nGalle Road, \nDehiwala,\nSri Lanka.\n', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('520', 'P C Needs', 'P C Needs', 'Pitabadda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('521', '3p Computer Technologies', '3p Computer Technologies', 'Morawaka', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('522', 'Tech Zone', 'Tech Zone', 'Pitabaddara', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('523', 'Morawaka Computers', 'Morawaka Computers', 'Morawaka', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('524', 'Shasika', 'Shasika', '125,\nDarmapala mawatha,\nColombo 07', '', 'LKR', '3', '0', '0', '1', '4', '0', '0', '0', '', '0', ''),
('525', 'Right Click Computers', 'Right Click Computers', 'Tellabuwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('526', 'Click Solutions', 'Click Solutions', 'Yakkalamulla', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('527', 'Multi Computers &amp; Electronics', 'Multi Computers ', 'Yakkalamullla', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('528', 'Aruna Computers', 'Aruna Computers', 'Makumbura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('530', 'Computer Care Technology Center', 'C C Tech', 'Deniyaya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('531', 'Venus E Cafe &amp; Solutions', 'Venus E Cafe ', 'Deniyaya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('532', 'Data World Computers', 'Data World Computers', 'Deniyaya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('533', 'P C Super Mart', 'P C Super Mart', 'Beralapanathara', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('534', 'Madhura Computer Shop', 'Madhura Computer Shop', 'Pasgoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('535', 'Lakmal IT Solutions', 'Lakmal IT Solutions', 'Mawarala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('536', 'PepperCube Consultants (Pvt) Limited', 'PepperCube Consultant', '20/43,\nFairfield Gardens,\nColombo 08,\nSri Lanka \n', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('537', 'Mr.Suren Dharmaratne', 'Suren- Australia  Bookkeeping', 'Melbourne\nAustralia', '', 'AUD', '1', '16', '0', '1', '1', '0', '0', '0', '', '0', ''),
('538', 'A Plus Technologies &amp; Communication', 'A Plus Technologies', 'Henegama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('539', 'Beeta Computers', 'Beeta Computers', 'Nittabuwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('540', 'Shenaya Holdings', 'Shenaya Holdings', 'Mirisswaththe', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('541', 'Six D Solutions', 'Six D Solutions', 'Mirigama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('542', 'Seya DVD House', 'Seya DVD House', 'Galle', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('543', 'sarasavi Computers', 'sarasavi Computers', 'Galle', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('544', 'Dimuthu Electronics', 'Dimuthu Electronics', NULL, '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('545', 'Abacus Computers', 'Abacus Computers', 'Galle', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('546', 'Richmond Hill Computers', 'Richmond Hill Computers', 'Galle', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('547', 'A N Computers', 'A N Computers', 'Galle', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('548', 'Mekala Cellulars', 'Mekala Cellulars', 'Embuldeniya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('549', 'Tilly  Computer Gadgets', 'Tilly  Computer', 'Marawilla', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('550', 'Insight Technologies ', 'Insight Technologies ', 'Hikkaduwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('551', 'Eranga Computers', 'Eranga Computers', 'Uragaha', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('552', 'E-Win Computers', 'E-Win Computers', 'Uragasmanhandiya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('553', 'Bandara Tecchnologies', 'Bandara Tecchnologies', 'Karandeniya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('554', 'A &amp; G Technologies-Tangalle', 'A&amp;G Technologies-Tangalle', 'Tangalle', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('555', 'Cell World', 'Cell World', 'Aluthgama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('556', 'RM Holdings (PVT) Ltd', 'RM Holdings', 'No 34,\nMendis Mawatha, \nNegombo,\nSri Lanka.\n', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('557', 'R-CIS ', 'R-CIS ', 'Tissamaharama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('558', 'Boralessa Technologies', 'Boralessa Technologies', 'Monaragala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('559', 'United Computers', 'United Computers', 'Puhulkotuwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('560', 'Danuka Celluler &amp; Computers', 'Danuka Celluler &amp; Computer', 'Ahangama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('561', 'Visual Computers', 'Visual Computers', 'Habaraduwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('562', 'Senara Technologies', 'Senara Technologies', 'Bogahagama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('563', 'IDEAL Technologies', 'IDEAL Technologies', 'Naiwela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('564', 'Comtec Computers', 'Comtec Computers', 'Kandana', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('565', 'K-Tech Trading', 'K-Tech Trading', 'Kandana', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('566', 'AMA Games', 'AMA Games', 'Kandana', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('567', 'Micro Sis', 'Micro Sis', 'Ja-Ela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('568', 'Araliya Computers', 'Araliya Computers', 'Weligama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('569', 'CCTV Lanaka (PVT) Ltd', 'CCTV Lanaka', 'No 629 1/1,\nYanthampalawa,\nKurunegala.', '', 'LKR', '3', '0', '0', '1', '6', '0', '0', '0', '', '0', ''),
('570', 'Wislan Apparel', 'Wislan Apparel', 'No 93/2,\nPitawala Waththa,\nGampola Road,\nGelioya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('571', 'Macstore', 'Macstore', '3rd floor,\nMajestic City, \nColombo 04.', '', 'LKR', '3', '0', '0', '1', '6', '0', '0', '0', '', '0', ''),
('572', 'EasyAds (Pvt) Ltd', 'EasyAds', 'No 225-A-2,\nIhala Karagahamuna,\nKadawatha,\nSri Lanka', '', 'LKR', '3', '0', '0', '1', '4', '0', '0', '0', '', '0', ''),
('573', 'Nicstop Computer', 'Nicstop Computer', 'Kegalle', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('574', 'Micro World', 'Micro World', 'Kaluthara', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('575', 'Uni Tech PC', 'Uni Tech PC', 'Baduruliya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('576', 'One IT, Australia', 'oneITAUS', 'Australia', '', 'AUD', '2', '4', '0', '1', '1', '0', '0', '0', '', '0', ''),
('577', 'E-Mas Computers', 'E-Mas Computers', 'Negambo', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('578', 'zMessenger (Pvt) Ltd', 'zMessenger ', 'No 121,\nHunupitiya Lake Road,\nColombo 02,\nSri Lanka', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('579', 'Sumithra Garments ( Pte ) Ltd', 'Sumithra Garments', 'No 33,\nThelangapatha Road,\nWattala,\nSri Lanka.\n', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('580', 'Chandrasiri Communications', 'Chandrasiri Communications', 'Katharagama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('581', 'P C Tech Computer system', 'P C Tech Computer system', 'Embilipitiya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('582', 'RD Computer Services (Pvt) Ltd', 'RD Computer Services', 'Minuwangoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('583', 'Game Soft', 'Game Soft', 'Ganemulla', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('584', 'ComNet Computers', 'ComNet Computers', 'Gannemulla', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('585', 'P C Friends', 'P C Friends', 'Nittambuwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('586', 'Soft Bios Technology', 'Soft Bios', 'Aluthwala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('587', 'Infortec Computers', 'Infortec Computers', 'Hikkaduwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('588', 'Xenon Computers', 'Xenon Computers', 'Elpitiya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('589', 'Gamage Computers', 'Gamage Computers', 'Tissamaharama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('590', 'Hiru Computers', 'Hiru Computers', 'Badalkumbura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('591', 'Real Tec', 'Real Tec', 'Wellawaya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('592', 'Silverline Information Technology (Pvt) Ltd', 'Silverline', 'No 85, \nDr.N.M.Perera Mawatha,\nColombo 08, \nSri Lanka.\n', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('593', 'American College of Higher Education', 'American College', 'No: 23,\nHospital Road,\nDehiwala\nSri Lanka.\n', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('594', 'Mr. Ganeshan Prabakaran', 'Mr. Prabakaran', 'No 155/176,\nKalmunai,\nSri Lanka', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('595', 'Ceylon Business Appliances (Pvt) Ltd', 'CBA', 'No 112,\nReid Avenue,\nColombo - 04,\nSri Lanka.\n', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('596', 'Old Joes Sports Club', 'Old Joes Sports Club', 'T.B Jaya Mawatha,\nColombo 10,\nSri Lanka', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('597', 'E-Net Computers', 'E-Net Computers', 'Kadawatha', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('598', 'Super Unique', 'Super Unique', 'Negambo', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('599', 'Best Computers', 'Best Computers', 'Wennappuwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('600', 'Infonee', 'Infonee', 'Kaluthara', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('601', 'N Gadgets', 'N Gadgets', 'Baduraliya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('602', 'Dragon Computer Services', 'Dragon Computer Services', 'Aluthgama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('603', 'P C World', 'P C World', 'Aluthgama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('604', 'PC &amp; Network Technologies', 'PC &amp; Network', 'Minuwangoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('605', 'Nilan Computers', 'Nilan Computers', 'Ragama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('606', 'Vihanga Technologies', 'Vihanga Technologies', 'Malabe', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('607', 'Golden Way Computers', 'Golden Way', 'Urubokka', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('608', 'Okrich Computers', 'Okrich Computers', 'Middeniya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('609', 'S J Computers', 'S J Computers', 'Embilipitiya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('610', 'BC Agro-Tronics (Pvt) Limited', 'BC Agro-Tronics ', 'Mr. Mark Allen Dirckze\nBC Agro-Tronics (Pvt) Limited\nNo 211/10,\nVeluwana Place,\nColombo 09.', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('611', 'Central Industries PLC', 'Central Industries', 'No:312\nNawala Rd,\nSri Jayawardenepura Kotte 10107,\nSri Lanka', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('612', 'W.I. Tel Solutions (pvt) Ltd', 'W.I. Tel Solutions ', 'A: 27-1/3,\nYork Arcade Building,\nLayden Bastian Road,\nColombo 01\nSri Lanka.', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('613', 'Best Way Computers', 'Best Way', 'Kiribathgoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('614', 'Office Station', 'Office Station', 'Ja-Ela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('615', 'M.C Computers', 'M.C Computers', 'Wennappuwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('616', 'Galaxy Technologies', 'Galaxy Technologies', 'Hikkaduwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('617', 'K L Computers', 'K L Computers', 'Panadura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('618', 'G.M.S.Lanka Computers', 'G.M.S.Lanka', 'Induruwa Road ', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('619', 'Abeyrathne Computers', 'Abeyrathne Computers', 'Induruwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('620', 'Tecno Computers', 'Tecno Computers', 'Baduraliya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('621', 'NMN Computers', 'NMN Computers', 'Urubokka', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('622', 'E-Rats Technologies', 'E-Rats ', 'Mawanella', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('623', 'Peshala Computers', 'Peshala Computers', 'Dilulapitiya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('624', 'N &amp; N Computers', 'N &amp; N Computers', 'Rathnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('625', 'Max Computers', 'Max Computers', 'Bus Stand-Rathnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('626', 'S.P Mobile &amp; Computers', 'S.P Mobile &amp; Computers', 'Bus Stand Road,\nRathnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('627', 'Apple Computer &amp; Mobile', 'Apple Computer &amp; Mobile', 'Rathnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('628', 'PC Net Computer Home', 'PC Net Computer Home', 'Rathnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('629', 'Computer Home', 'Computer Home', 'Rathnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('630', 'MicroNet Computers', 'MicroNet Computers', 'Main Street,\nRathnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('631', 'PREB Computers', 'PREB Computers', 'Kuruwita', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('632', 'Razan Samsung Mobile', 'Razan Samsung Mobile', 'Kuruwita', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('633', 'SeaCom International', 'SeaCom International', 'Kuruwita', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('634', 'Eshantha Computer &amp; Cellular', 'Eshantha Computer &amp; Cellul', 'Parakaduwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('635', '777 Phone Arcade', '777 Phone Arcade', 'Ehaliyagoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('636', 'Sharp Computers', 'Sharp Computers', 'Eheliyagoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('637', 'Imaya Computers', 'Imaya Computers', 'Rathnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('638', 'Micro System Technologies ', 'Micro System Technologies ', 'Rathnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('639', 'Win Max Computer &amp; Technologies', 'Win Max Computer', 'Awissawella', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('640', 'E Mart Computers', 'E Mart Computers', 'Kahawatta', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('641', 'Swarna Communication', 'Swarna Communication', 'Kahawatta', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('642', 'Chandrika Mobiles', 'Chandrika Mobiles', 'Kahawatta', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('643', 'Susil Computer System', 'Susil Computer System', 'Kahawatte', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('644', 'I Com', 'I Com', 'Eheliyagoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('645', 'Smart Mobile', 'Smart Mobile', 'Eheliyagoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('647', 'Capital Lands (Pvt) Ltd', 'Capital Lands (Pvt) Ltd', 'Colombo', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '1', ''),
('648', 'Galle Com Zone', 'Galle Com Zone', 'Wanduramba', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('649', 'LandMark Computers', 'LandMark Computers', 'Pitigala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('650', 'Ru Sanda Ras Computers', 'Ru Sanda Ras Computers', 'Palawaththe', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('651', 'Micro City ', 'Micro City ', 'Kaluthara-South', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('652', 'Thakshila Computers', 'Thakshila Computers', 'Nahalla', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('653', 'W.A Computers', 'W.A Computers', 'Horana', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('654', 'The IT Park', 'The IT Park', 'Kaluthara-South', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('655', 'Seven Star Enterprices', 'Seven Star Enterprices', 'No 317/D\nOld Kottawa Road,\nEmbuldeniya,\nNugegoda.', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('656', 'MITECH Computer Systems (Pvt) Ltd', 'MI Tech', 'No 106,\nLower Ground Floor,\nUnity Plaza,\nColombo 04', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('657', 'Hiru.Com &amp; Phone Shop', 'Hiru.Com &amp; Phone Shop', 'Pasgoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('658', 'Omega Computers', 'Omega Computers', 'Pitigala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('659', 'My Way Computers', 'My Way Computers', 'Kirindiwela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('660', 'Sky Computers (Pvt) Ltd', 'Sky Computers (Pvt) Ltd', 'Mr.Roshan Fernando\nSt.Joeph?s Street,\nnegombo', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('661', 'Max Pac (Pvt) Ltd', 'Max Pac (Pvt) Ltd', '1st Cross Street,\nPettah', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('662', 'Finlays Cold Storage (Pvt) Limited', 'Finlays Cold Storage', 'No 309/7,\nNegambo Road,\nWelisara', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('663', 'Edulink International (Pvt) Ltd', 'Edulink', 'No 498,\nDe Mel Mawatha,\nColombo 03,\nSri Lanka', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('664', 'PC Net Technologies', 'PC Net Technologies', 'Kollupitiya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('665', 'Newgen Technologies', 'Newgen Technologies', 'Dankotuwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('666', 'Max Computers (Pvt) Ltd', 'Max Computers (Pvt) Ltd', 'Naththandiya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('667', 'Mr Dilan Fernando', 'Mr Dilan Fernando', 'NO 284B 1/1,\nBandaranayake Mawatha,\nKatubedda,\nMoratuwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('668', 'E Plus (Pvt) Ltd', 'E Plus (Pvt) Ltd', 'Mr Keerthi Jayakody\nNo L2-47,\nRealty Plaza,\nJa-Ela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('669', 'I Max Computers', 'I Max Computers', 'Badulla', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('670', 'Creatives Computers (Pvt) Ltd', 'Creatives Computers', 'Kuliyapitiya', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('671', 'Inova IT Systems (Pvt) Ltd', 'Inova IT', 'No 5,\nSulaiman Terrace, \nColombo 5\n', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('672', 'P.C.S. Technologies', 'P.C.S. Technologies', 'Baddalkubura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('673', 'PC House', 'PC House', 'Unity Plaza', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('674', 'Ramya Communications', 'Ramya Communications', 'Badulla', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('675', 'Sybrain Computer Systems', 'Sybrain Computer', 'Badulla', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('676', 'Computer City', 'Computer City', 'Bandarawela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('677', 'Horizon College International', 'Horizon College', 'Millenium Drive,\nChandrika Kumarathunga Mawatha,\nMalabe,\nSri Lanka.', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('678', 'Rovinta Electronics', 'Rovinta Electronics', 'Kiribathgoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('679', 'IML Private Limited (UPS)', 'IML Private Limited ', NULL, '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('680', 'H L De Mel &amp; Company (Pvt) Ltd', 'H L De Mel ', 'De Mel Building,\nNo 103,\nChatham Street,\nColombo', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('681', 'Seven Computers', 'Seven Computers', 'Kottawa', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('682', 'DOS Computers', 'DOS Computers', 'No 77/1,\nKandy road,\nwarakapola', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('683', 'Do Max Computers', 'Do Max Computers', 'Kalawana', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('684', 'Phone House', 'Phone House', 'Kalawana', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('685', 'Like Computer House', 'Like Computer', 'Ehaliyagoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('686', 'Niranjan Networks', 'Niranjan Networks', 'Badulla ', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('687', 'Herath Technicians', 'Herath Technicians', 'Bandarawela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('688', 'GIGAMAXZ Computers', 'GIGAMAXZ Computers', 'Bandarawela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('689', 'Star Net Computers', 'Star Net Computers', 'Rathnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('690', 'Kingston computer technology', 'Kingston computers', 'Horana', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('691', 'Universal CAL-Computers', 'Universal Computers', 'Dodangoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('692', 'New Gen Technologies', 'New Gen ', 'Mr Suresh,\nNattandiya Road,\nDankotuwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('693', 'MEGA Computers', 'MEGA Computers-Tissa', 'Tissamaharama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('694', 'NC Computers', 'NC Computers', 'Ahangama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('695', 'Lahiru Computers', 'Lahiru Computers', 'Neluwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('696', 'Pentech Technologies', 'Pentech', 'Neluwa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('697', 'DSIT House', 'DSIT House', 'Negambo', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('698', 'Matrix Technologies', 'Matrix Technologies', 'Weliweriya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('699', 'P.C House ', 'P.C House ', 'Hanwella', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('700', 'Dimuthu PC Solutions', 'Dimuthu PC Solutions', 'Kosgama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('701', 'G.M Mobile &amp; Computers', 'G.M Mobile &amp; Computers', 'Koagama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('702', 'Venus Mobile', 'Venus Mobile', 'Eheliyagoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('703', 'PERCY Studio', 'PERCY Studio', 'Kuruwita', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('704', 'Chandana Studio', 'Chandana Studio', 'Rathnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('705', 'Multi Technologies', 'Multi Technologies', 'Baduraliya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('706', 'Visual Net Solution', 'Visual Net Solution', 'Kandy', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('707', 'Computerage (Pvt) Ltd', 'Computerage', 'Kandy', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('708', 'Modern Computer Systems', 'Modern Computer', 'Wattala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('709', 'Talent Computer Systems', 'Talent Computer', 'Kadawatha', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('710', 'Chani Computer Institute', 'Chani Computer Institute', 'Hali ella', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('711', 'Arcit Cxee', 'Arcit Cxee', 'Bandarawela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('712', 'Infofix', 'Infofix', 'Bandarawela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('713', 'Falcon Degital Video', 'Falcon Degital Video', 'Bandarawela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('714', 'Win Tel Mobile Center', 'Win Tel Mobile Center', 'Balangoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('715', 'New Phone House', 'New Phone House', 'Balangoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('716', 'DM Computers', 'DM Computers', 'Balangoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('717', 'Mellow Computers', 'Mellow Computers', 'Balangoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('718', 'Feel Computers', 'Feel Computers', 'Balangoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('719', 'Mega Phone House &amp; Communication', 'Mega Phone House &amp; Communi', 'Balangoda', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('720', 'Uni Tec Computers', 'Uni Tec Computers', 'Avissawella', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('721', 'Everlight Chemicals (Prt)Ltd', 'Everlight ', 'Mr. Asif,\nEverlight Chemicals (Prt)Ltd,\n638, High Level Road,\nNugegoda,\nSri Lanka.', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('722', 'Sinara Cellular', 'Sinara Cellular', 'Ratnapura ', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('723', 'Thuhansa Mobile', 'Thuhansa Mobile', 'Ratnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('724', 'Smart Mobile ( Ratnapura)', 'Smart Mobile ( Ratnapura)', 'Ratnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('725', 'Jayamee Phonekade', 'Jayamee Phonekade', 'Ratnapura ', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('726', 'AG Computors- Ampara', 'AG Computors- Ampara', 'Regal Junction \nAmpara', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('727', 'Dammika Computers', 'Dammika Computers', 'Main Street,\nThanamalvila', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('728', 'S P C CONSULTANTS (PRIVATE) LIMITED', 'SPC', 'No: 69/04,\nJayarathna Mawatha,\nThimbirigasyaya,\nColombo 05.', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('729', 'Content Management and Solutions (pvt) Ltd', 'CMS', 'Level 10,\nAccess Tower,\n278,\nUnion Place,\nColombo 02.', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('730', 'City Mobile', 'City Mobile', 'palmadulla', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('731', 'Max D Computers', 'Max D Computers', 'Ampara', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('732', 'Nandana Computers', 'Nandana Computers', 'Palawaththa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('733', 'PC Software', 'PC Software', 'Mathugama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('734', 'Sri Lanka Navy Head Quarters', 'Sri Lanka Navy', 'P.O Box 593,\nColombo 01', '', 'LKR', '3', '2', '0', '1', '1', '0', '0', '0', '', '0', ''),
('735', 'CS Computers', 'CS Computers', 'Akuressa', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('736', 'Softlogic Phone Centre ', 'Softlogic Phone Centre ', 'Mr.Kaushal\nLiberty Showroom.', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('737', 'U Computers ', 'U Computers ', 'Mr.Ishan Ravindra\nPitakotte. ', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('738', 'Dinuka Cellulers &amp; Computers', 'Dinuka Cellulers &amp; Compute', 'Ahangama', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('739', 'Trrident Corporation (PVT) Ltd', 'Trrident ', 'No 297, 1st floor,\nUnion Place,Colombo 02,\nSri Lankan', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('740', 'Thakral One (PVT) Ltd', 'Thakral', 'No 297, \n1 st floor,\nUnion Place ,\nColombo 02,\nSri Lankan', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('741', 'Futureworld lanka (Pvt) Ltd', 'Futureworld', '#02,\nR.A.De Mel Mawatha,\nColombo 05,\nSri lanka', '', 'LKR', '1', '0', '0', '1', '3', '0', '0', '0', '', '0', ''),
('742', 'Vipula Computers', 'Vipula Computers', 'Horana', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('743', 'SuhaS Computers &amp; Mobile', 'SuhaS Computers', 'Rathnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('744', 'M &amp; N Computers', 'M &amp; N Computers', 'Piliyandala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('745', 'Intelnet Computers', 'Intelnet Computers', NULL, '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', '');
INSERT INTO `0_debtors_master` VALUES
('746', 'E-Spring Technologies', 'E-Spring ', 'Negambo', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('747', 'E Plus Computers', 'E Plus', 'Ja-Ela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('748', 'Nil Nethu Computers', 'Nil Nethu', 'Rathnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('749', 'Max Mo Computers', 'Max Mo', 'Chilaw', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('750', 'Smart IT', 'Smart IT', 'Ja-Ela', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('751', 'NeoN Computers (Pvt) Ltd', 'NeoN Computers ', 'Embilipitiya', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('752', 'Zaak Enterprises', 'Zaak Enterprises', 'No 147,\nMain Street,\nAnuradhapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('753', 'Tech Tool', 'Tech Tool', 'no 561/B/14 \nN S B Road,\nNew bus Stand,\nAnuradhapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('754', 'Power PC (Pvt) Ltd', 'Power PC ', 'Anuradhapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('755', 'S J Computers (Anuradhapura)', 'S J Computers (Anuradhapura)', 'Anuradhapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('756', 'Build PC (Pvt) Ltd', 'Build PC ', 'Kurunegala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('757', 'GCT computer (Pvt) Ltd', 'GCT computer', 'Kurunegala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('758', 'Y Entertainment (Pvt) Ltd', 'Y Entertainment', 'Kurunegala', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('759', 'Seoul Trading', 'Seoul Trading', 'Malabe', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('760', 'AJ Medichem International (Pvt) Ltd', 'AJ Medichem', 'No 50, \nAlbion Lane\nColombo 00900,\nSri Lanka.', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('761', 'M.N.Computers', 'M.N.Computers', 'Galle', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('762', 'Malinda Computerss', 'Malinda Computerss', 'Anguruwathota', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('763', 'Rasika Computers', 'Rasika Computers', 'Horana', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('764', 'Extreme Computers', 'Extreme', 'Hatton', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('765', 'P N D Mobile', 'P N D Mobile', 'Rathnapura', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('766', 'MLF Technologies', 'MLF Technologies', 'Welisara', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('768', 'Ceylon Trading Company Limited', 'Ceylon Trading', 'The Accountant,\nP.O.box 161,\nNo 36,\nD.R.Wijewardena Mawatha,\nColombo 10', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('769', 'T.N Computers', 'T.N Computers', NULL, '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('770', 'Swiss Hotel &amp; Queens Hotel', 'Swiss Hotel', 'Colombo', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('771', 'Child Eye Hospital', 'Child Eye', 'Rajagiriya', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('772', 'Modeena Computers', 'Modeena', 'Giriulla', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('773', 'Soft Land PC', 'Soft Land PC', 'Maharagama', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('774', 'Tech Solutions', 'Tech Solutions', 'Maharagama', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('775', 'Computer Super Store', 'Computer Super Store', 'Giriulla', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('776', '3C Technologies', '3C Technologies', 'Malabe', '', 'LKR', '3', '0', '0', '1', '7', '0', '0.02', '0', '', '0', ''),
('777', 'GIT Computers', 'GIT Computers', 'Poddiwela', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('778', 'J And G Computers', 'J And G Computers', 'Deniyaya', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('780', 'Sahara Computers', 'Sahara Computers', 'Elpitiya', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('781', 'D.G.Constructions (Pvt) Ltd', 'D.G.Constructions', 'Naboda', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('782', 'Asia Mobile Network', 'Asia Mobile', 'Rathnapura', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('783', 'Horizon Campus', 'Horizon Campus', 'No 482/B,\nMillennium Drive,\nChandrika Kumarathunga Mawatha,\nMalabe.', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('784', 'Universal PC Systems', 'Universal PC', 'Galle', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('785', 'Apalo Computers', 'Apalo Computers', 'Tangalle', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('786', 'Abeysekara Cellulars', 'Abeysekara Cellulars', 'Yatiyana', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('787', 'e-Shop Computers', 'e-Shop Computers', 'Angunakolapalessa', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('788', 'Infinity Solutions', 'Infinity Solutions', 'Kandy', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('789', 'EPG Technologies', 'EPG Technologies', 'Dehiwala', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('790', 'EIM Tech Networks', 'EIM Tech', 'Colombo 05', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('791', 'Friendly Computers', 'Friendly Computers', 'Rajagiriya', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('792', 'Nesh.lk', 'Nesh.lk', 'Colombo 04', '', 'LKR', '3', '0', '0', '1', '7', '0', '0', '0', '', '0', ''),
('793', 'T S Technologies (Pvt) Ltd.', 'T S Technologies', 'No.4 A 1/1,Dabare Mawatha,\nColombo 05.\nSri Lanka', '', 'LKR', '3', '0', '0', '1', '1', '0', '0', '0', '', '0', ''),
('794', 'E-Link Solutions', 'E-Link ', 'Ambalangoda Road,\nElpitiya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('795', 'D N Creative Systems', 'Creative Systems', 'Wattala', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('796', 'Smart Tech Computers', 'Smart Tech Computers', 'Hendala Road,\nWattala', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('797', 'Riytec Computers', 'Riytec Computers', 'Chilaw', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('798', 'Cell Net Cellular', 'Cell Net', 'Rathnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('799', 'Adithya Cellular', 'Adithya Cellular', 'Bus Stand,\nRathnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('800', 'DCT computers', 'DCT computers', 'Mr chaminda samarasinghe\nNO. 1/B Ground Floor,\nWelikada Plaza,\nRajagiriya.\n', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('801', 'Riya Enterprises', 'Riya Enterprises', 'No. 12 B1,\nK.K.Street,\nPuttalam.\n', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('802', 'Sri Lanka Savings Bank', 'SLS Bank', 'Senior Manager-IT\nNo 265,\nWard Place,\nColombo 07', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('803', 'Systech solutions', 'Systech solutions', 'No 16/1/1\nOld Kottawa road, \nMirihana,\nNugegoda\n', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('804', 'Synergy Tech', 'Synergy Tech', 'Mr Rohana Perera\nNO 116/A,\nStanley Thilkarathne Mawatha, \nNugegoda.\n', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('805', 'DSL Computers', 'DSL Computers', 'No 155 D,\nHighlevel Road,\nMaharagama', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('806', 'Netcore solutions', 'Netcore ', 'Maharagama', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('807', 'Bright Computers', 'Bright Computers', 'Kandy', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('808', 'Power Link Computers', 'Power Link', 'Kandy', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('809', 'IPK Computers', 'IPK Computers', 'Beliatta', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('810', 'HI-Tec Computers', 'HI-Tec', 'Sooriyawewa', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('811', 'Galle Computers', 'Galle Computers', 'Galle', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('812', 'South Net Computers', 'South Net ', 'Galle', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('813', 'Globe international', 'Globe ', 'Kaduruwela,\npolonnaruwa', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('814', 'A &amp; M Computers &amp; Technologies', 'A &amp; M Computers', 'Gallella', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('815', 'AMI Tech', 'AMI Tech', NULL, '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('816', 'Orient Computers', 'Orient ', 'No 626/A,\nPeradeniya Road,\nKandy', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('817', 'Data E Net Computer System (Pvt) Ltd', 'Data E Net', 'No 264,\nPeradeniya Road,\nKandy', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('818', 'PC Home Computer System', 'PC Home-Kandy', 'D S Senanayake Street,Kandy', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('819', 'May D Computers', 'May D-Darshana', 'No 09,\n4th Lane,\nAmpara', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('820', 'Encription IT', 'Encription IT', 'Bandaragama', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('821', 'Future Shop', 'Future Shop', 'Union Place', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('822', 'Hyper', 'Hyper', 'Moratuwa', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('823', 'PC Doctor', 'PC Doctor', 'Baththaramulla', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('824', 'Tech', 'Tech', 'Baththaramulla', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('825', 'Future Shop-Primal', 'Future Shop-Primal', 'Kandana', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('826', 'Future Shop-Wattala', 'Future Shop-Wattala', 'Wattala', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('827', 'IFix Computers', 'IFix Computers', 'Nittabuwa', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('828', 'Inter Web Computers', 'Inter Web Computers', 'Minuwangoda', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('829', 'PC Life Solutions', 'PC Life ', 'Divulapitiya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('830', 'Menaka Computers', 'Menaka Computers', 'Beliaththa', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('831', 'One Stop Computers', 'One Stop Computers', 'Tissamaharama', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('832', 'Dot Net Computers', 'Dot Net ', 'Agalawaththa', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('833', 'Perovin Computers', 'Perovin Computers', 'Mathugama', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('834', 'A Plus Computers', 'A Plus Computers', 'Matara', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('835', 'Sha Mobile', 'Sha Mobile', 'No 83,New Shopping Complex,\nPellmadulla', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('836', 'Micro Solutions', 'Micro Solutions', 'No 63,\ncanel road\nPuliyankulama\nAnuradhapura\n', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('837', 'My computer technologies', 'My computer', 'No 43/A \nBodiraja Mawatha\nKurunegala', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('838', 'The Office Shop (Pvt) Ltd', 'Office Shop', NULL, '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('839', 'Power Tec Computers', 'Power Tec', 'Walasmulla', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('840', 'Sunquick Lanka (Pvt) Ltd.', 'Sunquick', 'Rathnapura Road,\nMunagama,\nHorana,\nSri Lanka\n', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('841', 'P.C.Palace', 'P.C.Palace', 'Horana', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('842', 'Smart Tech-Morawaka', 'Smart Tech-Morawaka', 'Morawaka', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('843', 'Sonash Cellular &amp; CD House', 'Sonash Cellular', 'Kotapola', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('844', 'Geotech Computers', 'Geotech Computers', 'Wanduramba', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('845', 'Pitigala Computers', 'Pitigala Computers', 'Rathnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('846', 'Diyatha Lanka Computers', 'Diyatha Lanka', 'Panadura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('848', 'The D Tech Computers', 'The D Tech', 'Pallebedda', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('849', 'Sagara Mobile &amp; Computer World', 'Sagara Mobile &amp; Computer', 'Embilipitiya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('850', 'H D K IT (Pvt) Ltd', 'H D K IT', 'Embilipitiya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('851', 'DCS Computers', 'DCS Computers', 'NSB Road,\nNew Town,\nAnuradhapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('852', 'SK Computers', 'SK Computers-Kuliyapitiya', 'Kuliyapitiya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('853', 'Micro business solutions', 'Micro business', 'Puliyankulam,\nAnuradhapura ', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('854', 'Adam Inovations Co; Ltd', 'adam-i', '105-0004\nLevel 4, Shimbashi Annex Bld, 5-35-10, Shimbashi, Minato-ku,\nTokyo 105-0004 JAPAN', '', 'JPY', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('855', 'Phone Expert', 'Phone Expert', 'Kegalle', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('856', 'S S S Phone Shop', 'S S S Phone Shop', 'Weerakatiya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('857', 'Indika computers', 'Indika computers', 'Weerakatiya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('858', 'Supreem Computers', 'Supreem Computers', 'Hokandara', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('859', 'C S Electronics', 'C S Electronics', 'Walasmulla', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('860', 'Laptronics Lanka', 'Laptronics', 'Galle Road,\nColombo 04', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('861', 'Future Shop-Kosala', 'Future Shop-Kosala', 'Biyagama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('862', 'C &amp; J Computers', 'C &amp; J Computers', 'Embilipitiya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('863', 'Uditha Enterprices', 'Uditha Enterprices', 'Rathnapura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('864', 'K iss Technologies', 'K iss Technologies', 'Pelmadulla', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('865', 'SNC Computer &amp; Commiunication', 'SNC Computer &amp; Commiunicat', 'Rathnapura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('867', 'Final Solution Technologies', 'Final Solution', 'Delgoda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('869', 'Hansa Technologies', 'Hansa Technologies', 'Gampaha', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('870', 'E-Max Computers-Darga Town', 'E-Max Computers-Darga Town', 'Darga Town', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('871', 'Shirtworks (Pvt) Ltd', 'Shirtworks ', 'No 104/4,\nDehiwala Road,\nMaharagama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('872', 'East Asian International (Pvt) Ltd', 'East Asian International', 'No 36/3,\nWoodland Avenue,\nKohuwala,Nugegoda,\nSri Lanka', '', 'LKR', '4', '0', '0', '1', '1', '0', '0', '1000000', '', '0', ''),
('873', 'Access Natural Water (Pvt) Ltd', 'Access Natural ', 'No 278,\nUnion Place,\nColombo 02\n', '', 'LKR', '4', '0', '0', '1', '1', '0', '0', '1000000', '', '0', ''),
('874', 'VOLLKART PVT LTD', 'VOLLKART', 'Mohamed Azmeel\nVollKart\n[Street Address]\nMale&#039; , Maldives\n\n', '', 'USD', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('875', 'Circa Technology services', 'Circa Technology ', 'No 172/B,\nBorella road,\nThalawathugoda', '', 'LKR', '4', '0', '0', '1', '1', '0', '0', '1000000', '', '0', ''),
('876', 'AZ Associates', 'AZ Associates', 'Colombo', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('877', 'Mac Tec', 'Mac Tec', 'No 39/3,\nGalle road,\nFortune arcade (opposite MC),\nCOL-04\n', '', 'LKR', '4', '0', '0', '1', '1', '0', '0', '1000000', '', '0', ''),
('878', 'ACER Com House', 'ACER', 'Siyabalapitiya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('879', 'Horizon College International', 'Horizon College-F Secure', 'Millenium Drive,\nChandrika Kumarathunga Mawatha,\nMalabe,\nSri Lanka.', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('880', 'NS Digital (Pvt) Ltd', 'NS Digital', 'Piliyandala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('881', 'Braclays (Pvt) Ltd', 'Braclays', 'Unity Plaza', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('882', 'Sampath Information Technology Solutions (Pvt) Ltd', 'Sampath IT', NULL, '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('883', 'Mr.Shehan', 'Mr.Shehan', 'Colombo', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('884', 'Chanz IT', 'Chanz IT', 'Mahabage', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('885', 'Galle Mobile', 'Galle Mobile', 'Udugama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('886', 'One Click Computers', 'One Click Computers', 'Matara', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('887', 'Sahasra Computers', 'Sahasra Computers', 'Elpitiya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('888', 'Dr.Chanaka Gayan', 'Dr.Chanaka Gayan', 'Walasmulla', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('889', 'Ranmark Computers ', 'Ranmark Computers ', 'Middeniya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('890', 'Nex Computers', 'Nex Computers', 'Kurunegala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('891', 'P Tec Computer Service Centre', 'P Tec Computer', 'Kurunegala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('892', 'Digital Tag Training (Pvt) Ltd', 'Digital Tag (PC Hut)', 'Kurunegala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('893', 'Millenium Phone House', 'Millenium Phone House', 'Kuruwita', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('894', 'MG Mobile &amp; Video', 'MG Mobile &amp; Video', 'Kuruwita', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('896', 'Abans PLC ', 'Abans PLC -', 'Galle Road,\nColombo 03', '', 'LKR', '2', '14', '19', '1', '2', '0', '0', '1000000', '', '0', ''),
('897', 'Ultrium Technologies (Pvt) Ltd', 'Ultrium', '74B 1/1,\nGalle Road,\nDehiwala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('898', 'Koshalya Garments ', 'Koshalya Garments ', 'P.P.J Weerasooriya\nManaging Director\nNo 66 A, Hewagama\nKaduwela, \nSri Lanka\n', '', 'LKR', '4', '0', '0', '1', '1', '0', '0', '1000000', '', '0', ''),
('899', 'CryptoGen Pvt Ltd', 'CryptoGen Pvt Ltd', 'Mr.Wasantha Perera\nLevel 8 East, Ceylinco House, \nNo 69, Janadipathi Mawatha, \nColombo 01\n', '', 'LKR', '4', '0', '0', '1', '3', '0', '0', '1000000', '', '0', ''),
('900', 'Free Lanka Granite (Pvt) Ltd', 'Free Lanka Granite', 'Colombo', '', 'LKR', '1', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('901', 'ATG', 'S S Wilson &amp; Company (Pvt)', 'S S Wilson &amp; Company (Pvt) Ltd\nS. Ashokan-Chairman\nNo 174 1/1,\nMohamed Zain Mawatha,\nColombo 12', '', 'LKR', '1', '0', '0', '1', '1', '0', '0', '1000000', '', '0', ''),
('902', 'Millenium IT', 'Millenium IT', 'Panadura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('903', 'Colour Lab', 'Colour Lab', 'Ratnapura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('904', 'Sri Lanka Institute of Advance Technological Education', 'SLIATE', 'No 320,\nJanawathu Piyasa,\nT B Jaya Mawatha,\nColombo 10', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('905', 'Open Ark Systems ', 'Open Ark', 'No 120,\nHigh level Road,\nKirulapona\nColombo 06', '', 'LKR', '4', '0', '0', '1', '1', '0', '0', '1000000', '', '0', ''),
('906', 'Balfour Beauty', 'Balfour Beauty', 'Mr. Shyaad Perera\nPhase 3\nInvestment Promotion Zone, Katunayake,\nColombo,\nSri Lanka', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('907', 'Abans PLC ', 'Abans PLC -Tender sales Elite', 'Abans PLC (Elite)\nMr.Anand Kumar \nSales manager-Abans corporate\n4th floor, Abans Head Office,\nNo. 498, Galle Road, Colombo 3,', '', 'LKR', '4', '14', '19', '1', '2', '0', '0', '1000000', '', '0', ''),
('908', 'Ashen', 'Ashen', 'Colombo', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('909', 'Sundry Debtors', 'sundry', 'Colombo', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('910', 'Link Square', 'Link Square', 'Unity Plaza', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('911', 'IT Store', 'IT Store', 'Unity Plaza', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('912', 'My Computers (Pvt) Ltd', 'My Computers (Pvt) Ltd', 'Maharagama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('913', 'Saw Engineering (Pvt) Ltd', 'Saw Engineering ', 'No 52,\nMakoia Nortn,\nMakola,\nKiribathgoda', '', 'LKR', '4', '2', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('914', 'Total Solutions', 'Total Solutions', 'Panadura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('916', 'Saranga Technicians', 'Saranga Technicians', 'Hambanthota', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('917', 'Trans Asia Computers', 'Trans Asia ', 'Ambalanota', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('920', 'E-Tec Computers', 'E-Tec Computers', 'Sooriyawewa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('921', 'PC Cards', 'PC Cards', 'Kaluthara South', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('922', 'Prime Tech Computers', 'Prime Tech', '122/1/1,\nBekariya Junction,\nAttidiya,\nDehiwala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('923', 'Doctor PC ', 'Doctor PC ', 'Battaramulla', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('924', 'Advantec Network System (Pvt) Ltd', 'Advantec Network', 'No.9/1,\nSumner Pl,\nColombo 08.', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('925', 'Ledvo Computers', 'Ledvo ', 'Kurunegala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('926', 'Cyber Zone', 'Cyber Zone', 'Balangoda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('927', 'Technic World Computers', 'Technic World ', 'Balangoda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('928', 'CS Computer-Balangoda', 'CS Computer-Balangoda', 'Balangoda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('929', 'Crown Computers', 'Crown Computers', 'Melsiripura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('930', 'Infomax Computers', 'Infomax Computers', 'Gallewela', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('931', 'Mr.Premathilaka', 'Mr.Premathilaka', NULL, '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('932', 'Charuka Soft Net', 'Charuka Soft Net', 'Maththegoda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('933', 'DLW Computers', 'DLW Computers', 'Kottawa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('934', 'Guident Computers', 'Guident Computers', 'Homagama', '', 'LKR', '4', '2', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('935', 'K-Net Computers', 'K-Net Computers', 'Nittambuwa', '', 'LKR', '4', '2', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('936', 'Revo Computers', 'Revo Computers', 'Marawila', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('937', 'Brillianz Computers', 'Brillianz Computers', 'Chilaw', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('938', 'NEAT Computers', 'NEAT Computers', NULL, '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('939', 'SEGA Family Computers', 'SEGA Family', 'Sammanthurai', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('940', 'TEKNO World', 'TEKNO World', 'Batticola', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('941', 'The Galaxy', 'The Galaxy', 'Main Street,\nKalawachchikudi', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('942', 'E-City', 'E-City', 'Akkareipaththu', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('943', 'Selco Continental Private Limited', 'Selco ', 'Mr. Malaka,\nNo 69A ? 1/1,\nGalle Road,\nDehiwala South,\nSri Lanka.', '', 'LKR', '4', '5', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('944', 'R &amp; W Computer System', 'R &amp; W Computer System', 'Horana', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('945', 'Ayowee IT Care', 'Ayowee IT Care', 'Maggona', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('947', 'Institute of Lean Management (Pvt) Ltd', 'ILM', 'Level 26,\nEast Tower,\nWorld Trade Center,\nColombo 01,\nSri Lanka.', '', 'LKR', '4', '16', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('948', 'Trans Technology Computers', 'Trans Technology', 'Matara', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('949', 'Micro Computer Center', 'Micro Computer-Hanwella', 'No 25 B/2,\nMain Street,\nHanwella', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('950', 'PrimeTek-Matara', 'PrimeTek-Matara', 'Matara', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('951', 'TechMore Computers', 'TechMore-Matara', 'Matara', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('952', 'Sarasi Computer House', 'Sarasi Computer-Ambalangoda', 'Ambalangoda', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('954', 'Angel Electronics', 'Angel Electronics', 'Galle', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('955', 'Tulip Comuters', 'Tulip Comuters', 'Galle', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('956', 'Next Computers', 'Next Computers', 'Battaramulla', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('957', 'PC Mart', 'PC Mart', 'No 100/225,\nMumtaz Mahal,\nColombo 11', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('958', 'SDR Computers', 'SDR Computers', 'Dankotuwa', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('959', 'Ayngaran Computers', 'Ayngaran Computers', 'Hettiyawatta', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('960', 'C-Com ', 'C-Com ', 'Nugegoda', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('961', 'East Link Engineering Co.(pvt) Ltd', 'East Link', 'No 163/26,\nNawala Road,\nColombo 05', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('962', 'Chanowm Technologies', 'Chanowm Technologies', 'Motatuwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('963', 'Smart Computers', 'Smart Computers-Moratuwa', 'Moratuwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('964', 'Damith IT', 'Damith IT', NULL, '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('965', 'Texas Electronics Engineering', 'Texas Electronics', 'Galle', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('966', 'Metro Computer Technologies', 'Metro Computer', 'Matara', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('967', 'Comet Computers', 'Comet-Wadduwa', 'Wadduwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('968', 'Wajira Karunathilaka', 'Wajira Karunathilaka-Primal', 'Gampaha', '', 'LKR', '4', '16', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('969', 'E-Line Technologies', 'E-Line Technologies', 'Kandy', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('970', 'Akura Book Shop', 'Akura Book Shop', 'Miriswatta', '', 'LKR', '4', '16', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('971', 'Thisara Book Shop', 'Thisara Book Shop', 'Ahungalla', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('972', 'PC Globe', 'PC Globe', 'Unity Plaza', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('973', 'Stafford Garments Industries (Pvt) Ltd,', 'Stafford Garments', 'No: 304-5 1/2,\nNegombo Road,\nPeliyagoda.\n               \nVAT : 0114096512-7000\n', '', 'LKR', '4', '5', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('974', 'Computer House', 'Computer House', 'Padukka', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('975', 'Sashi Computers', 'Sashi Computers', 'Panadura', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('976', 'D-Tech Computer Services', 'D-Tech Computer ', 'Bibile', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('977', 'Soft Tech Computers', 'Soft Tech Computers', 'Ambalanthota', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('978', 'M V C Computers', 'M V C Computers', 'Weerakatiya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('979', 'Indika Electronics', 'Indika Electronics', 'Weerakatiya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('980', 'Dilan Computers', 'Dilan Computers', 'Diulapitiya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('981', 'MyCom Technologies', 'MyCom Technologies', 'Kirillawala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('982', 'Soft System Computer Zone', 'Soft System', 'Kelaniya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('983', 'Wisdom Books', 'Wisdom Books', 'Wattala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('984', 'Aussie Computers', 'Aussie Computers', 'Makola', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('985', 'Sampath Technologies &amp; Marketing', 'Sampath Technologies ', 'Kelaniya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('986', 'Cash-Primal', 'Cash-Primal', 'Primal', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('987', 'Plus Computers', 'Plus Computers', 'Embilipitiya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('988', 'Nenasa Computers', 'Nenasa Computers', 'Polonnaruwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('989', 'Sewwandi Communication', 'Sewwandi Communication', 'Embilipitiya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('990', 'Nelum Video &amp; Communication', 'Nelum Video', 'Embilipitiya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('991', 'Onimtar High Tech Solutions (Pvt) Ltd', 'Onimtar High Tech', 'Ratnapura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('992', 'PC System', 'PC System', 'Opanayake', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('993', 'Aiken Digital', 'Aiken Digital', 'Ratnapura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('994', 'Smart PC', 'Smart PC', 'Dambulla', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('995', 'Info Net Computers', 'Info Net Computers', 'Gallewela', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('996', 'A Eon Computers', 'A Eon Computers', 'Dambulla', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('997', 'Quick Flix Tech Lanka', 'Quick Flix ', 'Pilimathalawa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('998', 'RDF Computers', 'RDF Computers', 'Katubedda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('999', 'New Olanka Computers', 'New Olanka Computers', 'Piliyandala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1000', 'Smart Laptop House', 'Smart Laptop', 'Matara', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1001', 'Multi 9', 'Multi 9', 'Awissawella', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1002', 'Fair Price', 'Fair Price', 'Horana', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1003', 'Chptronics', 'Chptronics', 'Wadduwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1004', 'Matheesha Computers', 'Matheesha Computers', 'Horana', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1005', 'Globel Net Computers', 'Globel Net-Nimendra', 'Hikkaduwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1006', 'Synergy Computer Systems', 'Synergy Computer-Nimendra', 'Piliyandala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1007', 'PC Max', 'PC Max-Nimendra', 'Piliyandala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1008', 'AP Technologioes', 'AP Technologioes', 'Piliyandala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1009', 'Nishantha Book Shop', 'Nishantha Book Shop', 'Payagala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1010', 'Renown Computers', 'Renown Computers', 'Ingiriiya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1011', 'SM Computers', 'SM Computers', 'Rawatawatte', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1012', 'Angel Computers', 'Angel Computers-Nimendra', 'Galle', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1013', 'K M K Technologies', 'K M K Technologies', 'Karapitiya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1014', 'Zee Mobile', 'Zee Mobile', 'Matara', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1015', 'E-Work Shop', 'E-Work Shop-Horana', 'Horana', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1016', 'Enitss Com0puters', 'Enitss Com0puters', 'Bandaragama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1017', 'HP Computer System', 'HP Computer System', 'Bandaragama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1018', 'Colombo Municipal Council', 'CMC-Procurement Dept', 'Central Procurement Department\nColombo', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1019', 'Colombo', 'Colombo', 'Evolve Store', '', 'LKR', '4', '0', '0', '1', '3', '0', '0', '1000000', '', '0', ''),
('1020', 'RP Technologies', 'RP Technologies', 'Negambo', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1021', 'PC Home', 'PC Home-Kiribathgoda', 'Kiribathgoda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1022', 'SD Computers', 'SD Computers', 'Padukka', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1023', 'V S Technologies', 'V S Technologies', 'Weligama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1024', 'Charlton Business Center', 'Charlton Business Center', 'Kandy', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1025', 'Chami Movie World', 'Chami Movie', 'Makola', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1026', 'Super Beam (Pvt) Ltd', 'Super Beam', 'Nugegoda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1027', 'Onex (Pvt) Ltd', 'Onex ', 'Pelawaththe', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1028', 'SK Gadget Shop &amp; Laptop Repair Center', 'SK Gadget Shop', 'Battaramulla', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1029', 'Okidlo Computers', 'Okidlo Computers', 'Kelaniya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1031', 'Micro Tech Computers', 'Micro Tech ', 'Kochchikade', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1032', 'CyberZone', 'CyberZone-Primal', 'Homagama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1033', 'Sandaru Video', 'Sandaru Video', 'Rathnapura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1034', 'Hasi Video', 'Hasi Video', 'Rathnapura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1035', 'New Net Computers', 'New Net Computers', 'Hidella', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1036', 'LMP Printing', 'LMP Printing', 'Polonnaruwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1037', 'Ranga PC', 'Ranga PC', 'Polonnaruwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1038', 'Bitwin Computers', 'Bitwin Computers', 'Kurunegala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1039', 'Cebit Computers', 'Cebit Computers', 'Polonnaruwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1040', 'Techno Mobile And CCTV', 'Techno Mobile And CCTV', 'Rathnapura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1041', 'Senani Videos', 'Senani Videos', 'Kuruwita', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1042', 'Studio Cooray', 'Studio Cooray', 'Maggona', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1043', 'Mobile Zone', 'Mobile Zone', 'K-Zone,\nKatubedda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1044', 'Navora Communications', 'Navora Communications', 'Hikkaduwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1045', 'AB Mobile', 'AB Mobile', 'Aluthgama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1046', 'E-Zone', 'E-Zone', 'Ingiriya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1047', 'Manjula Electronics', 'Manjula Electronics', 'Ingiriya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1048', 'Intell lanka Computers', 'Intell lanka-Kosala', 'Kurunegala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1049', 'Aradana Mobile', 'Aradana Mobile', 'Anuradhapura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1050', 'PC World', 'PC World-Kosala', 'Polonnaruwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1051', 'Excellent Computers', 'Excellent Computers-Kosala', 'Plonnaruwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1052', 'ATS Group', 'ATS Group-USA Project', NULL, '', 'USD', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1053', 'Microtec Computers', 'Microtec -Panadura', 'Panadura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1054', 'Epitichia Multi Traders', 'Epitichia-Nimendra', 'Hatton', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1055', 'Kavindu Computers', 'Kavindu Computers', 'Payagala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1056', 'Rohan Book Shop', 'Rohan Book Shop', 'Galle', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1057', 'Cell One Cellullar', 'Cell One Cellullar', 'Ambalangoda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1058', 'G.S.M.Solutions', 'G.S.M.Solutions', 'Ambalangoda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1059', 'Amasha Video.com', 'Amasha Video.com', 'Horana', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1060', 'Lakshan Mobile', 'Lakshan Mobile', 'Katukurunda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1061', 'I.R.Computers', 'I.R.Computers', 'Maggona', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1062', 'Perera Graphics', 'Perera Graphics', 'Kaluthara', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1063', 'Galaxy Computers', 'Galaxy Computers', 'Kalawakachchikudi', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1064', 'Copreus (Pvt) Ltd', 'Copreus (Pvt) Ltd', 'Level 26,East Tower,\nWorld Trade Center,\nColombo 01', '', 'LKR', '4', '15', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1065', 'TCR Computers System', 'TCR Computers System', 'Pitigala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1066', 'SenitCom IT Solutions', 'SenitCom IT Solutions', 'Ratmalana', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1067', 'Difontec Computers', 'Difontec Computers', 'Moratuwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1068', 'Micro Computer Home', 'Micro Computer Home-Beruwala', 'Beruwala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1069', 'Sitelka Cellular', 'Sitelka Cellular', 'Katubedda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1070', 'Hedra Solutions', 'Hedra Solutions', 'Athurugiriya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1071', 'CNN Computers', 'CNN Computers', 'Nattandiya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1072', 'The Print Hub', 'The Print Hub', 'Polonnaruwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1073', 'Wisdom Computers', 'Wisdom Computers', 'Balangoda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1074', 'IT Plus', 'IT Plus', 'Anuradhapura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1075', 'Power PC laptop', 'Power PC laptop', 'Anuradhapura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1076', 'Tech Tool Computer', 'Tech Tool Computer', 'Anuradhapura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1077', 'Smart IT', 'Smart IT-Polonnaruwa', 'Polonnaruwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1078', 'Darshani Computers', 'Darshani Computers', 'Habarana', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1079', 'Max Computer Sys', 'Max Computer Sys', 'Polgahawela', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1080', 'Mobile Hut', 'Mobile Hut', 'Opanayake', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1081', 'Workshop', 'Workshop-Nimendra', 'Horana', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1082', 'V.S.P.Computer System', 'V.S.P.Computer', 'Galle', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1083', '3Quities Multi Shop', '3Quities', 'Payagala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1084', 'Danansaya Print House &amp; Computers', 'Danansaya Print House', 'Dehiowita', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1085', 'Super Max', 'Super Max', 'Karawanaella', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1086', 'K.G.S.Computers', 'K.G.S.Computers', 'Yatiyantota', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1087', 'I Com Computers', 'I Com-Nimendra', 'Ginigathhena', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1088', 'H.D.Haran', 'H.D.Haran', 'Nuwaraeliya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1089', 'Jetro Communication', 'Jetro Communication', 'Nuwara eliya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1090', 'B.D.F Computers', 'B.D.F Computers', 'Katubedda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1091', 'Vishwa Celluler', 'Vishwa Celluler', 'Niwithigala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1092', 'K &amp; L Mobile', 'K &amp; L Mobile', 'Kuruwita', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1093', 'Lakmal Communication', 'Lakmal Communication', 'Polpithigama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1094', 'Edirisinghe Celluler', 'Edirisinghe Celluler', 'Nivithigala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1095', 'G &amp;  J Computers', 'G &amp;  J Computers', 'Deyandara', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1096', 'Zima Computers', 'Zima Computers', 'Polonnaruwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1097', 'Shahon Computers', 'Shahon Computers', 'Polonnaruwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1098', 'JD Computers', 'JD Computers', 'Anuradhapura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1099', 'Priyankara Stores', 'Priyankara Stores', 'Habarana', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1100', 'Cool Zone Entertainment', 'Cool Zone ', 'Aluthgama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1101', 'New Isuru Trade Center', 'New Isuru Trade', 'Bombuwala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1102', 'S.N Multi Tech', 'S.N Multi Tech', 'Kaluthara', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1103', 'Brad Ferris', 'Brad Ferris', 'Director\nRed Digital\nAustralia\n', '', 'AUD', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1104', 'Strangers Computers', 'Strangers ', 'Trincomalee', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1105', 'Future Tech Computers', 'Future Tech', 'Trincomalee', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1106', 'Scenic Digital Word', 'Scenic Digital-Nimendra', 'Bombuwala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1107', 'I Fix Solutions', 'I Fix Solutions', 'Kadawatha', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1108', 'Micro Phone Shop', 'Micro Phone Shop -Nimendra', NULL, '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1109', 'Senvo Computers', 'Senvo Computers-Nimendra', 'Ambalangoda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1110', 'Softvision IT Group (Pvt) Ltd', 'Softvision IT', 'No 414/7-1/1,\nBaseline Garden,Baseline Road,\nColombo 09', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1111', 'Pubudu Mobile &amp; Multi Center', 'Pubudu Mobile &amp; Multi Cent', 'Dehiowita', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1112', 'Best Computers &amp; Phone Shop', 'Best Computers &amp; Phone Sho', 'Yatiyanthota', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1113', 'Hatton Computer Systems', 'Hatton Computer ', 'Hatton', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1114', 'Nalin Stores', 'Nalin Stores', 'Kaluthara', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1115', 'Isuru Video &amp; Phone Center', 'Isuru Video &amp; Phone-Nimend', 'Kahawaththa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1116', 'I Fix Pc Solutions', 'I Fix Pc -Nimendra', 'Panadura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1117', 'Service Global', 'Service Global-USD', '980,Mission Court,\nFremont,CA\n94539,USA', '', 'USD', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1118', 'Rota-Japan', 'Rota-Japan', 'Japan', '', 'USD', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1119', 'Ole Takai', 'Ole Takai-Mr.Ashan&#039;s Cust', 'Ripples', '', 'USD', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1120', 'House of Travels &amp; Tourism', 'House of Travels &amp; Tourism', 'NO 220,Hight Level Road,\nColombo 06', '', 'LKR', '4', '7', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1121', 'NCTS Technology PC System', 'NCTS Technology ', 'Trincomalee', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1122', 'Multi Phone Shop', 'Multi Phone Shop-Ijas', 'Trincomalee', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', '');
INSERT INTO `0_debtors_master` VALUES
('1123', 'I Com Technology', 'I Com Technology-Ijas', 'Kinniya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1124', 'Phone Time Mobile Shop', 'Phone Time-Ijas', 'Trincomalee', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1125', 'I Mobile', 'I Mobile-Ijas', 'Kinniya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1126', 'F S Mobile Shop', 'F S Mobile Shop-Ijas', 'Uppuveli', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1127', 'Asian Cell Stores', 'Asian Cell Stores-Ijas', 'Trincomalee', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1128', 'Naja Computer System', 'Naja Computer System', 'Main Street,Muthur', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1129', 'Mobile World', 'Mobile World-Ijas', 'Oddumavadi', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1130', 'Boardway Computer Tech', 'Boardway-Ijas', 'Oddumavadi', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1131', 'Colombo Phone Shop and Rent a Car', 'CMB Phone Shop-Ijas', 'Beticalo', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1132', 'Institute of zTechnology &amp; Management', 'ITM-Ijas', 'Akkarapattu', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1133', 'New World Mobile', 'New World Mobile-Ijas', 'Trincomalee', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1134', 'EyeCom Technologies', 'EyeCom Technologies-Ijas', 'Kinniya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1135', 'Issath Communication', 'Issath Communication-Ijas', 'Jinnagar', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1136', 'New City Technology PC System', 'New City Technology-Ijas', 'Trincomalee', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1137', 'N K T Computers', 'N K T Computers', 'Colombo 05', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1138', 'Blue Chip Technologies (Pvt) Ltd', 'Blue Chip Technologies', 'Dehiwala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1139', 'Smart Net Computers', 'Smart Net ', 'Wellawaya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1140', 'Tele Print Computer Service ', 'Tele Print-Nimendra', 'Hatton', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1141', 'Lanka Minerals &amp; Chemicals (Pvt) Limited', 'Lanka Minerals &amp; Chemicals', 'No 75,\n2nd Lane,\nRatmalana', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1142', 'Lead Capital Corporation', 'Lead Capital-USD', 'Suite 03,Global Village,\nJivan&#039;s Complex,Mont Fleuri\nMahe,Seychelles', '', 'USD', '4', '15', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1143', 'CN Global Pty. Ltd. Australia', 'CNGA', 'Australia', '', 'AUD', '4', '12', '0', '1', '2', '0', '0', '11000000', '', '0', ''),
('1144', 'Lakshitha Communication ', 'Lakshitha Communication ', 'Pallebedda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1145', 'S.L.A.Rizard.Com', 'S.L.A.Rizard.Com-Sinas', 'Haputhale', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1146', 'Anil&#039;s Computers', 'Anil&#039;s Computers-Nimendra', 'Hali-Ella', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1147', 'Minro Communication', 'Minro Communication-Nimendra', 'Aluthgama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1148', 'Samadhi Communication', 'Samadhi Communication-Nimendra', 'Balangoda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1149', 'Global Net Computers', 'Global Net-Nimendra', 'Hikkaduwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1150', 'I Net Computer Technologies', 'I Net Computer-Nimendra', 'Matara', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1151', 'E-World', 'E-World-Roshan', 'Wellawaththa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1152', 'Chamara Technologies', 'Chamara Technologies-Roshan', 'Hokandara', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1153', 'Veema Computers', 'Veema Computers-Nimendra', 'Bandaragama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1154', 'C H Computers', 'C H Computers-Nimendra', 'Kithulgala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1155', 'Best Way Computers', 'Best Way Computers-Nimendra', 'Awissawella', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1156', 'E-Base Computer', 'E-Base Computer-Dilruk', 'Mapolagama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1157', 'Top Choice', 'Top Choice-Ijas', 'Trincomalee', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1158', 'RS Enterprises', 'RS Enterprises-Ijas', 'Trincomalee', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1159', 'JM Electronics', 'JM Electronics-Ijas', 'Kinniya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1160', 'Askas Fancy Place', 'Askas Fancy Place-Ijas', 'Kinniya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1161', 'I Techno Computers', 'I Techno -Ijas', 'Main Street\nMutur', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1162', 'Ayan Cellcity', 'Ayan Cellcity-Ijas', 'Kinniya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1163', 'Northern Pc Park', 'Northern Pc Park-Ijas', 'Jaffna', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1164', 'G Base ', 'G Base-Ijas', 'Kinniya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1165', 'Asiri Media Solutions', 'Asiri Media Solutions-Ijas', 'Kanthale', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1166', 'Shoppy Computers', 'Shoppy Computers-Kaluthara', 'Kaluthara', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1167', 'Best Buy Mobile', 'Best Buy-Nimendra', 'Panadura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1168', 'Millennium Auto Exprez (Pvt.) Limited', 'Millennium Auto', 'No 298,\nButhgamuwa Road,\nRajagiriya', '', 'LKR', '4', '5', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1169', 'CN Global Lanka (Pvt) Ltd', 'CN Global ', 'Colombo 02', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1170', 'Ocen Mobile', 'Ocen Mobile-Nimendra', 'Kahawaththe', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1171', 'SICT Computers', 'SICT Computers', 'Godakawela', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1172', 'Pansilu Book Shop', 'Pansilu Book Shop-Ijas', 'Trincomalee', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1173', 'Shathusa Video Vision', 'Shathusa Video Vision-Ijas', '3rd Mile Post', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1174', 'San Book Center', 'San Book Center', NULL, '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1175', 'Info Net Lanka', 'Info Net Lanka-Roshan', 'No 573/A,Lake Road,Boralegamuwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1176', 'Uni Tec Gadgets', 'Uni Tec Gadgets-Roshsn', '123A,Sudharma Road,Kattiya Junction', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1177', 'Hight Tech Gelley', 'Hight Tech Gelley-Roshan', 'Maharagama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1178', 'Ringing More Mobile', 'Ringing More Mobile-Roshan', '345,Kotte Road,Rajagiriya\n\n\n\n\n\n\n\n\n', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1179', 'Detech Solutions', 'Detech Solutions-Roshan', '23/1C Nawinna Maharagama', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1180', 'Kotte Movie Shop', 'Kotte Movie Shop-Roshan', '411,Thalawathugoda Road,Pitaktte', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1181', '3C Computers', '3C Computers-Roshan', '26/17 Metro Center.Athurugiya Road,Malabe', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1182', '3D Computers', '3D Computers-Roshan', 'Thalahena,Malabe', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1183', 'Nexx Com', 'Nexx Com-Roshan', 'Kaduwela Road,Battaramulla', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1184', 'NEX Computers', 'NEX Computers-Roshan', 'Kotte Road,Rajagiriya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1185', 'AMP Ceylon (Pvt) Ltd', 'AMP Ceylon (Pvt) Ltd', 'Phase 2, E.P.Z\nKatunayake', '', 'LKR', '1', '0', '0', '1', '2', '0', '0', '0', '', '0', ''),
('1186', 'Star Link', 'Star Link', 'Mobile Phone Shop\n84 Power House Road\nTrincomalee', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1187', 'Reema Phone Shop', 'Reema Phone Shop', 'Main Street\nOddamavadi', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1188', 'Iqra Soft ', 'Iqra Mobile', 'Jamaliya Junction\nTrincomalee', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1189', 'Digi Tech Computer', 'Digi Tech Computer', '488/9\nMaithreepala Senanayaka Mw,\nAnuradhapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1190', 'D N R Mobile', 'D N R Mobile', '1019 Kinniya Road\nTrincomalee', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1191', 'IT Land', 'IT Land', 'Main Street\nkattankudi', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1192', 'M I C Computers', 'M I C Computers', '24 Sea View\nTrincomalee', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1193', 'Ministry of Transport Management ', 'Ministry of Transport Manageme', 'Colombo Suburban Railway Project\nNo 217\nKotta Road\nColombo 08', '', 'LKR', '3', '0', '0', '1', '3', '0', '0', '1000000', '', '0', ''),
('1194', 'One IT - Australia', 'OneITUSD', NULL, '', 'USD', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1195', 'Master Computer - Roshan', 'Master Computer - Roshan', '448 kotte Road\nRajagiriya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1196', 'Nex Group of Company - Roshan', 'Nex Group of Company - Roshan', 'Rajagiriya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1197', 'FNF Brothers Pvt Ltd - Roshan ', 'FNF Brothers Pvt Ltd - Roshan ', '58, Ground Floor\nLiberty Plaza\nColombo 03', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1198', 'Mr. Nilantha  - Roshan', 'Mr. Nilantha  - Roshan', NULL, '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1199', 'Global Phone Shop -  Nimendra', 'Global Phone Shop -  Nimendra', '85 Galle Rd \nAluthgama\n', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1200', 'Decent Technologies - Sinas', 'Decent Technologies - Sinas', '169 Goodshed Road\nRatnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1201', 'ORIKMO Technologies - Nimendra', 'ORIKMO Technologies - Nimendra', 'Galle', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1202', 'Rishi Tele Mart - Nimendra', 'Rishi Tele Mart - Nimendra', 'Park Road\nNuwaraeliya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1203', 'ETNESS - NIMENDRA', 'ETNESS - NIMENDRA', 'Kalutara Road\nBandaragama', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1204', 'Mr. Roshan ', 'Mr. Roshan ', NULL, '', 'LKR', '1', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1205', 'Abans PLC', 'Abans PLC', 'Abans PLC\nNo 498, Galle Road\nColombo-03', '', 'LKR', '2', '14', '19', '1', '2', '0', '0', '1000000', '', '0', ''),
('1206', 'Express Mobile Shop', 'Express Mobile Shop', 'Main Street\nPalathoppur\nThoppur', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1207', 'Mobile Edge - Mirihana - Roshan', 'Mobile Edge - Mirihana - Rosha', '16 Old Kottawa Rd\nNugegoda', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1208', 'Channel Mait Computers - Roshan', 'Channel Mait Computers - Rosha', '80/1 Attidiya\nDehiwala', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1209', 'Channel Mait Computers-Roshan-', 'Channel Mait Computers-Roshan-', '80/1 Attidiya \nDehiwala', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1210', 'Quick Tech Lanka - Roshan', 'Quick Tech Lanka - Roshan', '390 Galle Rd\nRathmalana', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1211', 'Siesis IT - Roshan', 'Siesis IT - Roshan', '816/05 Thalahena', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1212', 'PC Systems - Sinas New', 'PC Systems - Sinas New', '319/c ,01/01\nRatnapura Rd , Balgahamulla\nBalangoda', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1213', 'F A F Communication - Sinas', 'F A F Communication - Sinas', '343 Kadugalwatta\nRatnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1214', 'N H Mobile - Sinas', 'N H Mobile - Sinas', '7 Pradeshiya saba Building \nEheliyagoda', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1215', 'Hi Tech Computer Systems - Sinas', 'Hi Tech Computer Systems-Sinas', 'Ratnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1216', 'Winap Lanka Computers - Sinas', 'Winap Lanka Computers - Sinas', 'Bandarawela', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1217', 'DVM Computers - Chanaka', 'DVM Computers - Chanaka', '554/A/1/3 Negombo Rd\nMahabage', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1218', 'Prabha Soft Creation - Sinas', 'Prabha Soft Creation - Sinas', '106C\nMaib Street\nRakwana , Ratnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1219', 'Genuine Mobile Home - Sinas', 'Genuine Mobile Home - Sinas', '9 New Market Comples\nRatnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1220', 'Online Communication &amp; Computers - Sinas', 'Online Communication &amp; Com', 'Kuruwita', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1221', 'Success Electronics - Sinas', 'Success Electronics - Sinas', 'Kalupalama asala,\nRatnapura Rd\nKalawewa', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1222', 'E Vision Computers - Sinas', 'E Vision Computers - Sinas', 'Weddagala Rd\nKalawana', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1223', 'Enet Computers - Sinas', 'Enet Computers - Sinas', '101 Ratnapura RD\nPelmadulla\n', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1224', 'Like Minds Consulting Inc.', 'Likeminds', '30, Knightsbridge Road,\nNJ 08854\nUSA.', '', 'USD', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1225', 'Trans World - Ijas', 'Trans World - Ijas', 'Power House \nMuthur', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1226', 'Zest Computers - Nimendra', 'Zest Computers - Nimendra', '172/B Galle Rd\nKalutara', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1227', 'Promax Computer Systems - Nimendra', 'Promax Computer Systems ', '2 Parkwood Complex\nNuwara Eliya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1228', 'Xeon Computers - Nimendra', 'Xeon Computers - Nimendra', '8 Viskam Road\nGalwadugoda\nGalle', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1229', 'Lap&#039;s Zone - Nimendra', 'Lap&#039;s Zone - Nimendra', '4 Kalidasa Rd\nMatara', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1230', 'CELLETRA - Roshan', 'CELLETRA - Roshan', '1075A Old Kotte rd\nWelikada&#039;\nRajagiriya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1231', 'Flicks Video shop - Roshan', 'Flicks Video shop - Roshan', 'Rajagiriya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1232', 'C.S. Studio &amp; Communication -Sinas', 'C.S. Studio &amp; Communicatio', 'Balawinna\nPalebadda', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1233', 'Planet Technical -Sinas', 'Planet Technical -Sinas', 'Palama Asala\nVitanagama\nAyagama', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1234', 'M.M Computer &amp; Mobile - Sinas', 'M.M Computer &amp; Mobile - Si', 'Galbada  Junction\nGallaala \nRatnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1235', 'INTEL GSM - Sinas', 'INTEL GSM - Sinas', 'Bandarawela', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1236', 'Easy Technology - Sinas', 'Easy Technology - Sinas', '12 New Shopping Complex\nHempala Munidasa Mawatha', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1237', 'Naflan.Com - Sinas', 'Naflan.Com - Sinas', 'Ratnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1238', 'PC Mart Computer Sales &amp; Repair Center Sinas', 'PC Mart Computer Sales - Sinas', 'Ratnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1239', 'Suranga Mobile - Sinas', 'Suranga Mobile - Sinas', 'Bus Stand\nRatnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1240', 'ARC Computers- Sinas', 'ARC Computers- Sinas', 'Darmaduta road\nBadulla', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1241', 'F N F Communication -Sinas', 'F N F Communication -Sinas', 'Ratnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1242', 'F M Rilwan - Sinas', 'F M Rilwan - Sinas', NULL, '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1243', 'UltraNet Computers - sinas', 'UltraNet Computers - sinas', 'NIvetegala', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1244', 'I Support Company - Sinas', 'I Support Company - Sinas', 'Rakwana Rd\nPalmadulla', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1245', 'Malsha Communication - Sinas', 'Malsha Communication - Sinas', 'Sooriyawewa Town', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1246', 'H.D Computers - Nimendra ', 'H.D Computers - Nimendra ', '369/2 Wilegoda\nKalutara ', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1247', 'P &amp; J Grocery - Nimnedra ', 'P &amp; J Grocery - Nimnedra ', 'Kuda Payagala\nPayagala', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1248', 'Evolutions of the Computer Solution - Nimendra ', 'Evolutions of the Computer ', 'Kanda Udawatta Road ,\nWadduwa', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1249', 'P.CEYL COMPUTERS -Nimendra', 'P.CEYL COMPUTERS -Nimendra', 'Bandaragama Rd\nMoranthuduwa', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1250', 'Trinco Ravanan Technology - Ijas', 'Trinco Ravanan Technology ', 'Thiruganasampanthar st\nTrinco', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1251', 'S.T Com -Ijas', 'S.T Com -Ijas', 'Trincomalee', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1252', 'Mega Phone Shop - Ijas', 'Mega Phone Shop - Ijas', 'Dockyard Road\nTrincomalee ', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1253', 'Mr Thilina - Dilruk ', 'Mr Thilina - Dilruk ', 'Beliatta', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1254', 'Barclays Computers Pvt Ltd', 'Barclays Computers Pvt Ltd', 'Galle Rd\nColombo 04\n\n', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1255', 'M.S Computers - Sinas', 'M.S Computers - Sinas', 'Main Street\nGodakawela', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1256', 'S.T Site Computers -Sinas ', 'S.T Site Computers -Sinas ', '195\nMain Street\nGodakawala', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1257', 'IT LAB -Sinas', 'IT LAB -Sinas', 'Rakwana Road\nPalmadulla', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1258', 'Skynet Solutions - Sinas', 'Skynet Solutions - Sinas', 'Ayagama', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1259', '4D M Tec - Sinas', '4D M Tec - Sinas', 'Main Street\nBogawantalawa', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1260', 'Nanasala Mobile - Sinas', 'Nanasala Mobile - Sinas', '102 Bus Stand \nTanamalwila ', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1261', 'C.T Computers -Sinas', 'C.T Computers -Sinas', 'Bus Stand\nTanamalwila', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1262', 'R.S Mobile - Sinas ', 'R.S Mobile - Sinas ', '403 Kudugalwatta\nRatnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1263', 'VIP Technologies Pvt Ltd -Roshan', 'VIP Technologies Pvt Ltd -Rosh', NULL, '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1264', 'Next Solutions - Roshan', 'Next Solutions - Roshan', 'pelawatta', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1265', 'I Care Computers &amp; Mobile - Roshan ', 'I Care Computers &amp; Mobile', 'Ingiriya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1266', 'M.I Mobile -Nimendra ', 'M.I Mobile -Nimendra ', 'BNS Store\nKoladiya Junction \nKalutara South\n', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1267', 'LAP HUB Computers - Nimendra', 'LAP HUB Computers - Nimendra', 'Wadiyamankada\nWaskaduwa\nKalutara', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1268', 'N.D.R Solutions - Nimendra', 'N.D.R Solutions - Nimendra', 'Nagoda\nKalutara', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1269', 'E Zone Communication - Nimendra ', 'E Zone Communication -Nimendra', 'Galle Rd\nMaggona ', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1270', 'Navinda Computer Services - Nimendra', 'Navinda Computer - Nimendra', 'Kotmale Rd\nNawalapitiya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1271', 'Creative Tech Computer - Chanaka', 'Creative Tech Computer - Chana', 'Dimo Junction\nSiyambalape', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1272', 'Bilal Traders - Ijas', 'Bilal Traders - Ijas', 'Old Market Rd\nOddamavadi 03', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1273', 'A-Z Mobiles', 'A-Z Mobiles-Ijas', 'Trincomalee', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1274', 'Pala Net Computers', 'Pala Net Com-Sinaz', 'Kalawana road,', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1275', 'Pouja Cellular', 'Pouja Cellular-Sinaz', 'Rathnapura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1276', 'Chajana Mobilr Hoom', 'Chajana Mobilr Hoom-Sinaz', 'Rathnapura', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1277', 'CALL ME-IJAS', 'CALL ME-IJAS', 'TRINCO', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1278', 'SKY CREATIONS-IJAS', 'SKY CREATIONS-IJAS', 'TRINCO', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1279', 'CITY HALL MULTY SHOP', 'CITY HALL MULTY SHOP-IJAS', 'TRINCO', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1280', 'Pascal Computers', 'Pascal Computers', 'Buththala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1281', 'New express communication', 'New express communication-Rosh', 'Dehiwala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1282', 'Trade Wings Enterprises', 'Trade Wings Enterprises-Roshan', 'Battaramulla', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1283', 'Happy Laptop Service', 'Happy Laptop Service-Roshan', NULL, '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1284', 'Thilina computers', 'Thilina computers-Dilruk', 'Beliatta', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1285', 'O Zone Computers', 'O Zone Computers-Dilruk', 'deiyandara', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1286', 'T S I Comouters', 'T S I Comouters', 'Ampara', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1287', 'Lotus Computers', 'Lotus Computers-Dilruk', 'Siyabalanduwa', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1288', 'Star Computer', 'Star Computer-Dilruk', 'Beliatta', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1289', 'Pasidu Computers', 'Pasidu Computers-Dilruk', 'Wellawaya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1290', 'New SN Computers', 'New SN Computers-Dilruk', 'Wellawaya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1291', 'My Computer Technologies', 'My Computer Technologies-Chana', 'Kurunegala', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1292', 'Hello World -Sinas', 'Hello World -Sinas', '179 , Main Street\nRatnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1293', 'Savidu.Com -Sinas', 'Savidu.Com -Sinas', 'R.E.T Udawalawe', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1294', 'Tileni Mobile &amp; Comm- Sinas', 'Tileni Mobile &amp; Comm- Sina', 'RET udawalawa , ', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1295', 'Siva Rama Computers- Sinas', 'Siva Rama Computers- Sinas', 'Kovil Road , Rakwana ', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1296', 'Rama Computers &amp; Comm-Sinas', 'Rama Computers &amp; Comm-Sina', '775/5F Winil Complex , Kahawatta', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1297', 'Master Mind', 'Master Mind-Ijas', 'Kalmunei', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1298', 'T Mobiling', 'T Mobiling-Ijas', 'Trincomalee', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1299', 'Lahiru Mobile Video - Sinas', 'Lahiru Mobile Video - Sinas', 'Ratnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1300', 'Unitec Computer -Sinas', 'Unitec Computer -Sinas', '\nRatnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1301', 'Nawodya Mobile &amp; Comm -Sinas', 'Nawodya Mobile &amp; Comm -Sin', 'Tennahena \nGinigathhena', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1302', 'Sathusa', 'Sathusa-Ijas', 'Trincomalee', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '1', ''),
('1303', 'D N R Solutions', 'D N R Solutions-Nimendra', 'Nagoda', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1304', 'Methmi Mobiles', 'Methmi Mobiles-Ijas', 'Muthur', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1305', 'Fulgar Lanka (Pvt) Limited', 'Fulgar Lanka ', 'Katunayake', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1306', 'Lead Capital Corporation', 'Lead Capital Corporation-LKR', 'colombo', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1307', 'C.N.S Mobile &amp; Com - Sinas', 'C.N.S Mobile &amp; Com - Sinas', 'Ratnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1308', 'F.B Mobile &amp; Computers - Sinas', 'F.B Mobile &amp; Computers - S', '31 , Bus Stand ,\nRatnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1309', 'Ifa Mobile &amp; Technology - Sinas', 'Ifa Mobile &amp; Technology -S', 'Mahawala\nRatnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1310', 'AD Tec Computers - Sinas', 'AD Tec Computers - Sinas', 'Balangoda', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1311', 'Smart Mobile Tanamalwila - Sinas', 'Smart Mobile Tanamalwila Sinas', 'Bogaha Asala\nTanamalwila', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1312', 'D.N.S Technologies -Sinas ', 'D.N.S Technologies -Sinas ', 'Udagama ,\nEmbilipitiya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1313', 'Kadar Mobile - Sinas', 'Kadar Mobile - Sinas', 'Bus Stand Rd ,\nPalleBadda', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1314', 'Umar Mobile &amp; Comm- Sinas', 'Umar Mobile &amp; Comm- Sinas', 'Kudugalwatta ,\nRatnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1315', 'Cine Mobile - Sinas', 'Cine Mobile - Sinas', 'Galbadda Junction ,\nwewalwatta Rd', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1316', 'Rizad Mobile - Sinas', 'Rizad Mobile - Sinas', 'Dabatana rd , \nHaputala', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1317', 'Rapip Computers- Sinas', 'Rapip Computers- Sinas', 'Lallupitiya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1318', 'Osura Mobile - Sinas', 'Osura Mobile - Sinas', 'Ratnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1319', 'Rahman Mobile - Sinas', 'Rahman Mobile - Sinas', 'Bogawantalawa', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1320', 'CITE Computers- Sinas', 'CITE Computers- Sinas', 'Banadarawela', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1321', 'Crystal Music World - Ijas', 'Crystal Music World - Ijas', 'Central Road ', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1322', 'CD World', 'CD World-Ijas', 'AJ Junction', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1323', 'Kumar Studio/Video - Ijas', 'Kumar Studio/Video - Ijas', 'New Shopping Complex\n3rd Mile Post\nTrincomalee', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1324', 'Ring Master - ijas', 'Ring Master - ijas', '3rd Mile Post ,\nTrincomalee', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1325', 'Samadhi Technologies', 'Samadhi Technologies-Dilruk', 'Bibile', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1326', 'Real Solutions', 'Real Solutions-Dilruk', NULL, '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1327', 'M N Multy Shop', 'M N Multy Shop-Dilruk', 'Tallgampola', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1328', 'B &amp; S Stores - Nimendra', 'B &amp; S Stores - Nimendra', 'Kolaniya junc , \nKalutara South', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1329', 'Star Multi Shop - Ijas', 'Star Multi Shop - Ijas', 'Trinco', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1330', 'Extreme Tech - Ijas', 'Extreme Tech - Ijas', 'Trincomalee', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1331', 'Success Techno -  Ijas', 'Success Techno -  Ijas', 'Vidyalayam Road\nTrinco', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1332', 'Various Computer - Ijas', 'Various Computer - Ijas', 'Kahatagasdigiliya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1333', 'LAPMART -IJAS', 'LAPMART -IJAS', 'Anuradhapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1334', 'PC Village - Ijas', 'PC Village - Ijas', 'Kattankudy', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1335', 'CJ Computer Solutions - Sinas', 'CJ Computer Solutions - Sinas', '90 , Badulla Rd , \nAtampitiya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1336', 'Zoom Networks - Sinas', 'Zoom Networks - Sinas', '12 , Lower Street ,\nBadulla', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1337', 'Kasun Video &amp; Computers - Sinas', 'Kasun Video &amp; Computers -S', '7 , namunukula ,\nElla', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1338', 'Swiss Net - Sinas', 'Swiss Net - Sinas', 'Bandarawela', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1339', 'Infaz Com &amp; Comp -Sinas', 'Infaz Com &amp; Comp -Sinas', 'Hapugastenna', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1340', 'Azmil Computer - Sinas', 'Azmil Computer - Sinas', 'Ratnajoti Mw ,\nRatnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1341', 'Sameera Comm &amp; Comp - Sinas', 'Sameera Comm &amp; Comp - Sina', 'Ratgama', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1342', 'Sripagama Communication -Sinas', 'Sripagama Communication -Sinas', 'Sripagama', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1343', 'Computer Solution &amp; Mobile -Sinas', 'Computer Solution &amp; Mobile', 'B/27 , Commercial Building,\nBandawala  ', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1344', 'Computers &amp; Comm - Sinas', 'Computers &amp; Comm - Sinas', NULL, '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1345', 'Oxbrain Computer System - Sinas', 'Oxbrain Computer System -Sinas', 'Main Street,\nDiyatalawa', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1346', 'Comtec Computers', 'Comtec Computers-Nimendra', NULL, '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1347', 'GI-Tech Solutions (Pvt) Ltd', 'GI-Tech-Nimendra', 'Nuwaraeliya', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1348', 'Babege Computers', 'Babege Computers-Dilruk', 'Bibile', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1349', 'I T House', 'I T House-Dilruk', 'Bibile', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1350', 'Saranga Computers', 'Saranga Computers-Dilruk', 'Hambanthota', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1351', 'E-Wings Trading', 'E-Wings Trading-Roshan', 'Battaramulla', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1352', 'E-Happy computers', 'E-Happy computers-Roshan', 'Battaramulla', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1353', 'CS Computer &amp; Multi Shop', 'CS Computer-Chanaka', 'Makola', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1354', 'Divisional Secretariat-Colombo', 'Divisional Secretariat-Colombo', 'No 12,\nDam Street,\nColombo 12', '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1355', 'HIGHTEK COMPUTERS - Chanaka', 'HIGHTEK COMPUTERS - Chanaka', 'Mawaramandiya\nSiyabalape', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1356', 'Deleepa Computer &amp; Comm-Sinas', 'Deleepa Computer &amp; Comm-Si', 'Kesalovitagama Road', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1357', 'Walawa Mobile &amp; Computer Solution - Sinas', 'Walawa Mobile &amp; Computer-S', 'Embilipitiya Road\nWalawa', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1358', 'A One Computer - Sinas', 'A One Computer - Sinas', 'Ayagama', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1359', 'Chapa Mobile -Sinas', 'Chapa Mobile -Sinas', 'Ayagama', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1360', 'I Tech Computer Sys - Sinas', 'I Tech Computer Sys- Sinas', 'Ratnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1361', 'Computer Solution - Sinas Kaltota', 'Computer Solution - Kaltota', 'Kaltota', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1362', 'I Net Computer - Sinas', 'I Net Computer - Sinas', 'Main Street\nEhaliyagoda', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1363', 'PC Tech System - Nemindra', 'PC Tech System - Nemindra', '474 1/C Arther V D Mw, \nPanadura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1364', 'D.K Computers - Nemindra', 'D.K Computers - Nemindra', 'Awariyawatta , Alubonull\nPanadura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1365', 'Digital Expose - Ijas', 'Digital Expose - Ijas', '147 , Kandy Rd\nTrincomalee', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1366', 'Wide Tech Solution -  Ijas', 'Wide Tech Solution -  Ijas', '167A , Central Road\nTrincomalee', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1367', 'Visualization Unit Comp-Ijas', 'Visualization Unit Comp-Ijas', '836 , Kandy Rd\nMihindapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1368', 'Promoditha Technology - Ijas', 'Promoditha Technology - Ijas', 'Pottuvil', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1369', 'Senu Book Shop - Nimendra', 'Senu Book Shop - Nimendra', 'Daluwaththa \nPayagala', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1370', 'Tharaka Mobile - Sinas', 'Tharaka Mobile - Sinas', 'Badulla Road\nBalangoda', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1371', 'Pahan Net - Sinas', 'Pahan Net - Sinas', 'Main Street - \nRatnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1372', 'R.M.S Mobile - Sinas', 'R.M.S Mobile - Sinas', '14/B \nWallandura\nKahawatta', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1373', 'Link Natural Products (Pvt) Limited', 'Link Natural', 'P.O Box 2,\nMalinda,\nKapugoda', '', 'LKR', '2', '0', '0', '1', '2', '0', '0', '10000000', '', '0', ''),
('1374', 'Rajabima - Dilruk', 'Rajabima - Dilruk', 'LK', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1375', 'Akalanka Mobile - Sinas', 'Akalanka Mobile - Sinas', 'No.8\nKalawewa Rd , \nKuruwita', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1376', 'VIJI Computers - Sinas', 'VIJI Computers - Sinas', 'Colombo Rd\nNew Town Junction', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1377', 'PC Partner Computer Store -SINAS', 'PC Partner Computer -SINAS', 'No , 8\nShopping Complex\nKAPUGALWATTA', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1378', 'Samanala Communication - Chanaka', 'Samanala Communication - Chana', 'Mawaramandiya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1379', 'suspence', 'suspence', NULL, '', 'LKR', '4', '0', '0', '1', '2', '0', '0', '10000000', '', '0', ''),
('1384', 'Cash-Zakin', 'Cash-Zakin', NULL, '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1385', 'A.S.P.D Mobile &amp; Com -Sinas', 'A.S.P.D Mobile &amp; Com -Sina', 'Bus Stand \nRatnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1386', 'Smart Touch PC - IJAS', 'Smart Touch PC - IJAS', 'Trincomalee', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1387', 'Chaminda Computers - Sinas', 'Chaminda Computers - Sinas', 'Muduwa Rd\nPahalahakmuwa\nRatnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1388', 'P.E.M Technologies - Sinas', 'P.E.M Technologies - Sinas', 'Ebilipitiya rd\nUdawalawa', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1389', 'Oshan Computers- Sinas', 'Oshan Computers- Sinas', 'Balangoda Rd \nTerwanketiya', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1390', 'New Mobile Mart - Sinas', 'New Mobile Mart - Sinas', 'Balangoda', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1391', 'Sandaruwan Cellular - Nimendra', 'Sandaruwan Cellular - Nimendra', 'Bus Stand\nBandaragama', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1392', 'PS Computer - Dilruk', 'PS Computer - Dilruk', NULL, '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1393', 'Sandun CD Mobile - Sinas', 'Sandun CD Mobile - Sinas', 'New Bus Stand rd\nRatnapura\n \n', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1394', 'Mayanta Computers - Sinas', 'Mayanta Computers - Sinas', 'Ratnapura', '', 'LKR', '3', '0', '0', '1', '2', '0', '0', '1000000', '', '0', ''),
('1397', 'Lanka Bell WareHouse', 'Lanka Bell WareHouse', 'No 2/72,\nMinuwangoda Road,\nMathammana,Gampaha.\n', '', 'LKR', '4', '14', '0', '1', '2', '0', '0', '1000000', '', '0', '');

### Structure of table `0_dimensions` ###

DROP TABLE IF EXISTS `0_dimensions`;

CREATE TABLE `0_dimensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_` tinyint(1) NOT NULL DEFAULT '1',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  KEY `date_` (`date_`),
  KEY `due_date` (`due_date`),
  KEY `type_` (`type_`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_dimensions` ###

INSERT INTO `0_dimensions` VALUES
('1', '00001', 'A', '2', '1', '2016-09-23', '2022-10-31'),
('2', '01', 'F-Secure Products', '1', '0', '2014-04-01', '2008-05-01'),
('3', '02', 'Accpac/Local Software', '1', '0', '2009-04-01', '2009-05-01'),
('4', '03', 'One IT', '1', '0', '2016-04-01', '2017-05-10'),
('5', '04', 'Administration', '1', '0', '2016-04-01', '2017-05-10'),
('6', '05', 'Inbay', '1', '0', '2016-04-01', '2017-05-10'),
('7', '06', 'ACCPAC Division', '1', '1', '2016-04-01', '2021-05-31'),
('8', '07', 'CAT-5081', '1', '1', '2016-04-01', '2017-05-10'),
('9', '08', 'CAC-9188', '1', '1', '2016-04-01', '2017-05-10'),
('10', '09', 'Japan Subsidiary', '1', '1', '2017-09-11', '2017-11-01'),
('11', '10', 'B', '1', '1', '2020-04-01', '2020-04-30'),
('12', '11', 'C.N.Global ', '1', '0', '2017-04-01', '2017-04-01'),
('13', '12', 'Administrator', '1', '1', '2017-04-01', '2018-03-27'),
('14', '13', 'Retail Sales ', '1', '0', '2018-05-04', '2022-05-31'),
('15', '14', 'Call Centre', '1', '0', '2018-04-01', '2020-08-31'),
('16', '15', 'E-Storage', '2', '1', '2018-08-01', '2018-10-31'),
('17', '16', 'SD Cards', '1', '1', '2018-12-01', '2019-01-23'),
('18', '17', 'OTG', '1', '1', '2019-01-03', '2019-01-23'),
('19', '18', 'Abans', '2', '0', '2021-03-01', '2022-04-30'),
('20', '19', 'Mobitel', '2', '0', '2021-03-01', '2022-04-30');

### Structure of table `0_employee_pay_rates` ###

DROP TABLE IF EXISTS `0_employee_pay_rates`;

CREATE TABLE `0_employee_pay_rates` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `emp_id` tinyint(4) NOT NULL,
  `pay_type_id` tinyint(4) NOT NULL,
  `pay_rate` float NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Index` (`emp_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ;

### Data of table `0_employee_pay_rates` ###


### Structure of table `0_employees` ###

DROP TABLE IF EXISTS `0_employees`;

CREATE TABLE `0_employees` (
  `emp_id` int(11) NOT NULL AUTO_INCREMENT,
  `emp_first_name` varchar(100) DEFAULT NULL,
  `emp_last_name` varchar(100) DEFAULT NULL,
  `emp_address` tinytext,
  `emp_phone` varchar(30) DEFAULT NULL,
  `emp_email` varchar(100) DEFAULT NULL,
  `emp_birthdate` date NOT NULL,
  `emp_payfrequency` varchar(30) DEFAULT NULL,
  `emp_filingstatus` varchar(100) DEFAULT NULL,
  `emp_allowances` int(2) DEFAULT NULL,
  `emp_extrawitholding` float DEFAULT NULL,
  `emp_taxid` varchar(11) DEFAULT NULL,
  `emp_hiredate` date DEFAULT NULL,
  `emp_releasedate` date DEFAULT NULL,
  `emp_type` varchar(30) DEFAULT NULL,
  `emp_notes` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`emp_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ;

### Data of table `0_employees` ###


### Structure of table `0_exchange_rates` ###

DROP TABLE IF EXISTS `0_exchange_rates`;

CREATE TABLE `0_exchange_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rate_buy` double NOT NULL DEFAULT '0',
  `rate_sell` double NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `curr_code` (`curr_code`,`date_`)
) ENGINE=InnoDB AUTO_INCREMENT=332 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_exchange_rates` ###

INSERT INTO `0_exchange_rates` VALUES
('68', 'AUD', '118.75', '118.75', '2018-04-06'),
('69', 'GBP', '223.7', '223.7', '2018-04-17'),
('70', 'AUD', '118.75', '118.75', '2018-06-22'),
('74', 'AUD', '120.81', '120.81', '2018-04-04'),
('75', 'AUD', '118.75', '118.75', '2018-04-27'),
('76', 'GBP', '223.7', '223.7', '2018-04-23'),
('77', 'GBP', '223.7', '223.7', '2018-04-19'),
('80', 'AUD', '117.9', '117.9', '2018-05-01'),
('81', 'GBP', '210.5', '210.5', '2018-05-25'),
('82', 'GBP', '213.5', '213.5', '2018-05-14'),
('83', 'AUD', '118', '118', '2018-06-18'),
('84', 'GBP', '209.9', '209.9', '2018-06-26'),
('85', 'AUD', '120.85', '120.85', '2018-06-07'),
('87', 'AUD', '115.9', '115.9', '2018-07-03'),
('88', 'AUD', '117.67', '117.67', '2018-07-11'),
('89', 'GBP', '209.75', '209.75', '2018-07-26'),
('90', 'GBP', '213.5', '213.5', '2018-05-23'),
('91', 'GBP', '223.7', '223.7', '2018-05-02'),
('92', 'GBP', '210.5', '210.5', '2018-05-28'),
('93', 'GBP', '210.5', '210.5', '2018-06-25'),
('94', 'GBP', '209.9', '209.9', '2018-07-24'),
('95', 'GBP', '209.75', '209.75', '2018-08-26'),
('96', 'GBP', '206', '206', '2018-08-27'),
('97', 'AUD', '117.67', '117.67', '2018-07-31'),
('98', 'AUD', '118', '118', '2018-08-08'),
('99', 'AUD', '116.8', '116.8', '2018-08-30'),
('100', 'GBP', '210.5', '210.5', '2018-06-07'),
('101', 'GBP', '209.9', '209.9', '2018-06-29'),
('102', 'AUD', '120.85', '120.85', '2018-06-13'),
('103', 'GBP', '209.9', '209.9', '2018-07-05'),
('104', 'GBP', '209.75', '209.75', '2018-07-31'),
('105', 'GBP', '209.9', '209.9', '2018-07-17'),
('106', 'AUD', '117.67', '117.67', '2018-08-07'),
('107', 'AUD', '118', '118', '2018-08-29'),
('108', 'USD', '152.75', '152.75', '2018-07-05'),
('109', 'USD', '152.75', '152.75', '2018-07-06'),
('110', 'GBP', '221.4', '221.4', '2018-09-27'),
('111', 'AUD', '121.9', '121.9', '2018-09-27'),
('113', 'USD', '161.85', '161.85', '2018-09-06'),
('114', 'AUD', '121.9', '121.9', '2018-10-25'),
('115', 'USD', '152.75', '152.75', '2018-08-30'),
('116', 'JPY', '1.4244', '1.4244', '2018-09-05'),
('117', 'JPY', '1.3315', '1.3315', '2018-09-04'),
('118', 'GBP', '221.6', '221.6', '2018-10-29'),
('119', 'AUD', '122.66', '122.66', '2018-10-30'),
('120', 'AUD', '130.5', '130.5', '2018-11-29'),
('121', 'GBP', '229.5', '229.5', '2018-11-29'),
('122', 'JPY', '1.4244', '1.4244', '2019-01-16'),
('123', 'AUD', '129.2', '129.2', '2018-12-19'),
('124', 'USD', '180.15', '180.15', '2018-12-19'),
('126', 'GBP', '230.49', '230.49', '2018-12-28'),
('127', 'AUD', '129.45', '129.45', '2019-01-29'),
('128', 'GBP', '233.2', '233.2', '2019-01-30'),
('129', 'AUD', '116.8', '116.8', '2018-09-25'),
('130', 'AUD', '121.9', '121.9', '2018-10-29'),
('131', 'AUD', '122.66', '122.66', '2018-11-28'),
('132', 'AUD', '122.66', '122.66', '2018-11-21'),
('133', 'AUD', '129.2', '129.2', '2019-01-28'),
('134', 'GBP', '206', '206', '2018-09-25'),
('135', 'GBP', '221.4', '221.4', '2018-10-26'),
('136', 'GBP', '221.4', '221.4', '2018-10-02'),
('137', 'GBP', '221.6', '221.6', '2018-11-28'),
('138', 'GBP', '229.5', '229.5', '2018-12-24'),
('139', 'GBP', '230.49', '230.49', '2019-01-29'),
('140', 'AUD', '129.45', '129.45', '2019-02-28'),
('141', 'USD', '179.7', '179.7', '2019-02-28'),
('142', 'GBP', '238.65', '238.65', '2019-02-28'),
('143', 'USD', '161.85', '161.85', '2018-11-28'),
('144', 'JPY', '1.4244', '1.4244', '2018-12-05'),
('145', 'USD', '180.15', '180.15', '2018-12-07'),
('146', 'USD', '230.49', '230.49', '2018-12-06'),
('147', 'JPY', '1.4244', '1.4244', '2018-12-06'),
('148', 'GBP', '233.2', '233.2', '2019-02-07'),
('149', 'GBP', '233.2', '233.2', '2019-02-27'),
('150', 'GBP', '263.2', '263.2', '2019-03-01'),
('151', 'AUD', '123.8', '123.8', '2019-03-29'),
('152', 'GBP', '228.6', '228.6', '2019-03-29'),
('153', 'AUD', '125.7', '125.7', '2019-03-12'),
('154', 'AUD', '123', '123', '2019-04-29'),
('155', 'GBP', '227', '227', '2019-04-30'),
('156', 'AUD', '125.7', '125.7', '2019-03-28'),
('157', 'AUD', '123.8', '123.8', '2019-04-24'),
('158', 'AUD', '121.44', '121.44', '2019-05-30'),
('159', 'GBP', '221.6', '221.6', '2019-05-31'),
('160', 'AUD', '122.55', '122.55', '2019-06-26'),
('161', 'GBP', '222.75', '222.75', '2019-06-26'),
('162', 'AUD', '122.55', '122.55', '2019-08-09'),
('163', 'AUD', '121', '121', '2019-07-30'),
('164', 'GBP', '224.57', '224.57', '2019-07-31'),
('165', 'AUD', '122.55', '122.55', '2019-09-10'),
('166', 'USD', '179.7', '179.7', '2019-07-22'),
('167', 'USD', '181.65', '181.65', '2019-09-18'),
('168', 'USD', '178.3', '178.3', '2019-09-16'),
('169', 'AUD', '123.1', '123.1', '2019-09-16'),
('170', 'GBP', '218.7', '218.7', '2019-08-30'),
('171', 'AUD', '120.51', '120.51', '2019-08-27'),
('172', 'GBP', '263.2', '263.2', '2019-03-16'),
('173', 'GBP', '228.6', '228.6', '2019-04-09'),
('174', 'GBP', '227', '227', '2019-05-30'),
('175', 'GBP', '213.8', '213.8', '2019-08-29'),
('176', 'AUD', '125.7', '125.7', '2019-03-15'),
('177', 'AUD', '123', '123', '2019-05-27'),
('178', 'AUD', '121.44', '121.44', '2019-06-24'),
('179', 'AUD', '122.55', '122.55', '2019-07-29'),
('180', 'AUD', '122.55', '122.55', '2019-08-23'),
('181', 'AUD', '122.55', '122.55', '2019-09-22'),
('182', 'AUD', '122.55', '122.55', '2019-09-30'),
('183', 'AUD', '122.2', '122.2', '2019-09-27'),
('184', 'USD', '181.75', '181.75', '2019-09-27'),
('185', 'GBP', '218.7', '218.7', '2019-09-30'),
('186', 'GBP', '222.2', '222.2', '2019-10-03'),
('187', 'AUD', '123', '123', '2019-10-28'),
('188', 'USD', '181.75', '181.75', '2019-12-09'),
('189', 'USD', '179.7', '179.7', '2019-09-11'),
('190', 'USD', '180.75', '180.75', '2019-10-21'),
('191', 'AUD', '120.51', '120.51', '2019-08-28'),
('192', 'AUD', '117.51', '117.51', '2019-08-30'),
('193', 'USD', '180', '180', '2019-12-16'),
('194', 'GBP', '232.7', '232.7', '2019-11-04'),
('195', 'AUD', '122', '122', '2019-11-27'),
('196', 'USD', '180', '180', '2020-01-13'),
('197', 'GBP', '237.33', '237.33', '2019-12-05'),
('198', 'AUD', '124.2', '124.2', '2019-12-19'),
('199', 'AUD', '120', '120', '2020-02-10'),
('200', 'USD', '180', '180', '2020-02-13'),
('201', 'AUD', '120.02', '120.02', '2020-01-29'),
('202', 'AUD', '121', '121', '2020-01-30'),
('203', 'USD', '180.1', '180.1', '2020-02-17'),
('204', 'AUD', '122.77', '122.77', '2020-01-27'),
('205', 'GBP', '236.4', '236.4', '2020-01-06'),
('206', 'AUD', '118.22', '118.22', '2020-02-28'),
('207', 'USD', '179.4', '179.4', '2020-01-23'),
('208', 'AUD', '122.55', '122.55', '2019-10-22'),
('209', 'AUD', '122.95', '122.95', '2019-11-21'),
('210', 'GBP', '222.2', '222.2', '2019-11-01'),
('211', 'GBP', '237.33', '237.33', '2020-01-03'),
('212', 'AUD', '122', '122', '2019-12-18'),
('213', 'AUD', '120.02', '120.02', '2020-01-23'),
('214', 'AUD', '120', '120', '2020-02-27'),
('215', 'AUD', '122.6', '122.6', '2019-11-26'),
('216', 'AUD', '114.22', '114.22', '2020-03-23'),
('217', 'AUD', '105.5611', '105.5611', '2020-03-20'),
('218', 'USD', '191.0505', '191.0505', '2020-04-17'),
('219', 'USD', '185.75', '185.75', '2020-05-25'),
('220', 'USD', '185.75', '185.75', '2020-05-26'),
('221', 'AUD', '124.2', '124.2', '2020-06-28'),
('222', 'AUD', '124.2', '124.2', '2020-06-29'),
('223', 'USD', '186.3', '186.3', '2020-06-25'),
('224', 'USD', '179.7', '179.7', '2019-03-15'),
('225', 'USD', '183.25', '183.25', '2020-03-15'),
('226', 'USD', '180', '180', '2020-01-01'),
('227', 'USD', '180.1', '180.1', '2020-03-01'),
('228', 'USD', '191.0505', '191.0505', '2020-05-01'),
('229', 'USD', '185.75', '185.75', '2020-06-01'),
('230', 'USD', '186.3', '186.3', '2020-07-01'),
('231', 'USD', '180.1', '180.1', '2020-03-10'),
('232', 'USD', '183.25', '183.25', '2020-04-10'),
('233', 'USD', '191.0505', '191.0505', '2020-05-20'),
('234', 'USD', '185.75', '185.75', '2020-06-19'),
('235', 'USD', '186.3', '186.3', '2020-06-30'),
('236', 'AUD', '120', '120', '2020-02-21'),
('237', 'AUD', '105.5611', '105.5611', '2020-05-22'),
('238', 'AUD', '105.5611', '105.5611', '2020-05-24'),
('239', 'AUD', '120.51', '120.51', '2019-08-31'),
('240', 'AUD', '121', '121', '2020-01-31'),
('241', 'AUD', '118.22', '118.22', '2020-02-29'),
('242', 'AUD', '114.21', '114.21', '2020-03-31'),
('243', 'AUD', '105.5611', '105.5611', '2020-04-30'),
('244', 'AUD', '105.5611', '105.5611', '2020-05-31'),
('245', 'AUD', '124.2', '124.2', '2020-06-30'),
('246', 'USD', '182.5', '182.5', '2020-07-24'),
('247', 'USD', '186.3', '186.3', '2020-07-26'),
('248', 'USD', '185.5', '185.5', '2020-07-27'),
('249', 'USD', '185.65', '185.65', '2020-08-26'),
('251', 'USD', '195.5', '195.5', '2020-08-27'),
('252', 'USD', '185.5', '185.5', '2020-08-28'),
('253', 'USD', '184.6', '184.6', '2020-09-20'),
('254', 'USD', '184.6', '184.6', '2020-09-23'),
('255', 'AUD', '130.8', '130.8', '2020-10-26'),
('256', 'AUD', '122', '122', '2019-11-30'),
('257', 'AUD', '124.2', '124.2', '2020-08-31'),
('258', 'USD', '185', '185', '2020-11-26'),
('259', 'AUD', '136', '136', '2020-11-26'),
('260', 'USD', '185.5', '185.5', '2020-08-20'),
('261', 'USD', '184.6', '184.6', '2020-09-21'),
('262', 'USD', '184.6', '184.6', '2020-11-24'),
('263', 'USD', '185', '185', '2020-12-18'),
('264', 'USD', '185.5', '185.5', '2020-08-24'),
('265', 'USD', '184.6', '184.6', '2020-09-22'),
('266', 'USD', '184.6', '184.6', '2020-10-27'),
('267', 'AUD', '142.48', '142.48', '2020-12-30'),
('268', 'USD', '186.5', '186.5', '2020-12-30'),
('269', 'AUD', '142.48', '142.48', '2021-01-06'),
('270', 'AUD', '142.48', '142.48', '2021-01-14'),
('271', 'AUD', '134', '134', '2020-09-02'),
('272', 'AUD', '129.25', '129.25', '2020-09-28'),
('273', 'AUD', '132.25', '132.25', '2020-11-06'),
('274', 'AUD', '127.5', '127.5', '2020-07-06'),
('275', 'USD', '184.5', '184.5', '2020-07-28'),
('276', 'USD', '181.75', '181.75', '2019-10-06'),
('277', 'USD', '180.75', '180.75', '2019-11-07'),
('278', 'AUD', '142.48', '142.48', '2020-12-31'),
('279', 'AUD', '142.48', '142.48', '2021-02-09'),
('280', 'AUD', '142.48', '142.48', '2021-03-12'),
('281', 'USD', '186.5', '186.5', '2021-02-09'),
('282', 'USD', '200', '200', '2021-03-24'),
('283', 'USD', '200', '200', '2021-03-26'),
('284', 'AUD', '151.42', '151.42', '2021-03-31'),
('285', 'AUD', '151.24', '151.24', '2021-03-24'),
('286', 'AUD', '136', '136', '2020-12-24'),
('287', 'AUD', '142.48', '142.48', '2021-01-29'),
('288', 'AUD', '146.33', '146.33', '2021-02-02'),
('289', 'AUD', '142.48', '142.48', '2021-02-24'),
('290', 'AUD', '154.5', '154.5', '2021-02-25'),
('291', 'USD', '186.5', '186.5', '2021-01-20'),
('292', 'USD', '186.5', '186.5', '2021-01-25'),
('293', 'USD', '193.85', '193.85', '2021-01-27'),
('294', 'USD', '186.5', '186.5', '2021-02-18'),
('295', 'USD', '186.5', '186.5', '2021-03-18'),
('296', 'USD', '186.5', '186.5', '2021-02-24'),
('297', 'USD', '186.5', '186.5', '2021-03-17'),
('298', 'USD', '194.4', '194.4', '2021-02-25'),
('299', 'USD', '198', '198', '2021-03-22'),
('300', 'AUD', '127.5', '127.5', '2020-07-31'),
('301', 'AUD', '134', '134', '2020-09-22'),
('302', 'AUD', '129.25', '129.25', '2020-10-20'),
('303', 'AUD', '134', '134', '2020-09-10'),
('304', 'AUD', '136', '136', '2020-11-30'),
('305', 'AUD', '142.48', '142.48', '2021-01-31'),
('306', 'AUD', '154.5', '154.5', '2021-02-26'),
('307', 'AUD', '130.8', '130.8', '2020-10-31'),
('308', 'USD', '200', '200', '2021-04-16'),
('309', 'USD', '199.75', '199.75', '2021-04-23'),
('310', 'AUD', '154.3', '154.3', '2021-05-06'),
('311', 'AUD', '151.42', '151.42', '2021-05-05'),
('312', 'USD', '199.85', '199.85', '2021-05-25'),
('313', 'USD', '199.75', '199.75', '2021-05-21'),
('314', 'AUD', '154.3', '154.3', '2021-06-01'),
('315', 'AUD', '154.15', '154.15', '2021-06-07'),
('316', 'USD', '185', '185', '2020-12-01'),
('317', 'USD', '186.5', '186.5', '2021-01-21'),
('318', 'USD', '199.85', '199.85', '2021-06-09'),
('319', 'USD', '199.85', '199.85', '2021-06-17'),
('320', 'USD', '199.85', '199.85', '2021-06-23'),
('321', 'USD', '199.85', '199.85', '2021-06-25'),
('322', 'AUD', '154.15', '154.15', '2021-07-30'),
('323', 'AUD', '154.15', '154.15', '2021-09-23'),
('324', 'AUD', '152.25', '152.25', '2021-07-06'),
('325', 'AUD', '148.61', '148.61', '2021-08-02'),
('326', 'USD', '199.85', '199.85', '2021-07-22'),
('327', 'USD', '199.85', '199.85', '2021-08-19'),
('328', 'USD', '199.85', '199.85', '2021-07-05'),
('329', 'USD', '199.85', '199.85', '2021-08-03'),
('330', 'USD', '202.5', '202.5', '2021-07-26'),
('331', 'USD', '224', '224', '2021-08-31');

### Structure of table `0_fiscal_year` ###

DROP TABLE IF EXISTS `0_fiscal_year`;

CREATE TABLE `0_fiscal_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `begin` date DEFAULT '0000-00-00',
  `end` date DEFAULT '0000-00-00',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `begin` (`begin`),
  UNIQUE KEY `end` (`end`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_fiscal_year` ###

INSERT INTO `0_fiscal_year` VALUES
('5', '2018-04-01', '2019-03-31', '1'),
('6', '2019-04-01', '2020-03-31', '1'),
('7', '2020-04-01', '2021-03-31', '0'),
('8', '2021-04-01', '2022-03-31', '0');

### Structure of table `0_gl_trans` ###

DROP TABLE IF EXISTS `0_gl_trans`;

CREATE TABLE `0_gl_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT '0',
  `type_no` int(11) NOT NULL DEFAULT '0',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `amount` double NOT NULL DEFAULT '0',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob,
  `cheque_no` int(6) DEFAULT NULL,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `dimension_id` (`dimension_id`),
  KEY `dimension2_id` (`dimension2_id`),
  KEY `tran_date` (`tran_date`),
  KEY `account_and_tran_date` (`account`,`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_gl_trans` ###


### Structure of table `0_grn_batch` ###

DROP TABLE IF EXISTS `0_grn_batch`;

CREATE TABLE `0_grn_batch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `purch_order_no` int(11) DEFAULT NULL,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rate` double DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `delivery_date` (`delivery_date`),
  KEY `purch_order_no` (`purch_order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_batch` ###


### Structure of table `0_grn_items` ###

DROP TABLE IF EXISTS `0_grn_items`;

CREATE TABLE `0_grn_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_batch_id` int(11) DEFAULT NULL,
  `po_detail_item` int(11) NOT NULL DEFAULT '0',
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `qty_recd` double NOT NULL DEFAULT '0',
  `quantity_inv` double NOT NULL DEFAULT '0',
  `line_location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `grn_batch_id` (`grn_batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_items` ###


### Structure of table `0_groups` ###

DROP TABLE IF EXISTS `0_groups`;

CREATE TABLE `0_groups` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_groups` ###

INSERT INTO `0_groups` VALUES
('1', 'Small', '0'),
('2', 'Medium', '0'),
('3', 'Large', '0');

### Structure of table `0_import_paypal` ###

DROP TABLE IF EXISTS `0_import_paypal`;

CREATE TABLE `0_import_paypal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date` date NOT NULL DEFAULT '0000-00-00',
  `ref` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `person` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `confirmed` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_import_paypal` ###


### Structure of table `0_import_paypal_accounts` ###

DROP TABLE IF EXISTS `0_import_paypal_accounts`;

CREATE TABLE `0_import_paypal_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `person` (`person`),
  KEY `memo` (`memo`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_import_paypal_accounts` ###


### Structure of table `0_item_codes` ###

DROP TABLE IF EXISTS `0_item_codes`;

CREATE TABLE `0_item_codes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` smallint(6) unsigned NOT NULL,
  `quantity` double NOT NULL DEFAULT '1',
  `is_foreign` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `stock_id` (`stock_id`,`item_code`),
  KEY `item_code` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=115 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_codes` ###

INSERT INTO `0_item_codes` VALUES
('4', '001', '001', 'Installation &amp; Configuration Chargers', '6', '1', '0', '0'),
('5', '002', '002', 'Evolve 360 ERP solution', '6', '1', '0', '0'),
('6', '003', '003', 'Evolve HRM Installation', '6', '1', '0', '0'),
('7', '004', '004', 'Evolve Student Management System', '6', '1', '0', '0'),
('8', '005', '005', 'License Fees', '6', '1', '0', '0'),
('9', '006', '006', 'Local Software Development ', '6', '1', '0', '0'),
('10', 'FCCW', 'FCCW', 'F-Secure Client Security for Corporate P/C', '11', '1', '0', '0'),
('11', 'FCSW', 'FCSW', 'F-Seure Corporate Security Server License', '11', '1', '0', '0'),
('15', 'Mobile', 'Mobile', 'Mobile Security Licenses for one year', '8', '1', '0', '0'),
('16', 'FCE-MO', 'FCE-MO', 'F-Secure Active Mobile  licenses to Mobitel customers', '10', '1', '0', '0'),
('17', 'FCE-PC', 'FCE-PC', 'F-Secure Active PC  licenses to Mobitel customers', '10', '1', '0', '0'),
('18', 'LPPCPGFSAV3', 'LPPCPGFSAV3', 'F-secure Client Security 1 User 3 Years License- LPPCPGFSAV3', '12', '1', '0', '0'),
('19', 'LPPCPGFSAVTPGCON', 'LPPCPGFSAVTPGCON', 'F-Seure Client Security License for one year- LPPCPGFSAVTPGCON', '12', '1', '0', '0'),
('20', 'LPPCPGFSINVGCON', 'LPPCPGFSINVGCON', 'F-Seure Client Security License for one year-	LPPCPGFSINVGCON', '12', '1', '0', '0'),
('21', 'F-Se3User', 'F-Se3User', 'F-Secure Internet Security 3 User License for 01 Year in a Pouch', '9', '1', '0', '0'),
('22', 'Freedome', 'Freedome', 'F-Secure Safe  1  User License for 01 Year in a Box', '9', '1', '0', '0'),
('23', 'FSe3year', 'FSe3year', 'F-secure Client Security 1 User 3 Year in a Pouch', '9', '1', '0', '0'),
('24', 'FSebox', 'FSebox', 'F-Secure Client Security 1 User 1 Year in a box', '9', '1', '0', '0'),
('25', 'FSePouch', 'FSePouch', 'F-Secure Client Security 1 User 1 Year in a Pouch', '9', '1', '0', '0'),
('26', 'CDs', 'CDs', 'Compack Disk', '13', '1', '0', '1'),
('27', 'Export', 'Export', 'Export of IT Support -Inbay', '1', '1', '0', '1'),
('28', 'Export01', 'Export01', 'Export of Software Development BPO', '1', '1', '0', '0'),
('29', 'Export02', 'Export02', 'Export - Call Centre Services', '1', '1', '0', '0'),
('30', 'Export03', 'Export03', 'Export of Software - One IT', '1', '1', '0', '0'),
('31', 'Export04', 'Export04', 'Export of Bookkeeping services for the month', '1', '1', '0', '0'),
('32', 'FW', 'FW', 'Firewall Services', '1', '1', '0', '1'),
('33', 'Maintenence', 'Maintenence', 'Annual Maintenence Fees', '1', '1', '0', '0'),
('34', 'ManagedServices', 'ManagedServices', 'Managed IT Support Services  Local', '1', '1', '0', '1'),
('35', 'SKY-RE', 'SKY-RE', 'Repacking-Sky Print', '1', '1', '0', '1'),
('36', 'Training', 'Training', 'Training Programmes', '1', '1', '0', '1'),
('37', 'LPPCPGFSAV1SU17CON', 'LPPCPGFSAV1SU17CON', 'F-secure Virus Guard-	LPPCPGFSAV1SU17CON', '12', '1', '0', '0'),
('38', 'IN01', 'IN01', 'Finger Scanner Machine', '2', '1', '0', '1'),
('39', 'Sec-Key', 'Sec-Key', 'F-Secure Security Key', '9', '1', '0', '1'),
('40', 'Table', 'Table', 'Office Tables', '14', '1', '0', '0'),
('41', 'MH-001', 'MH-001', 'Grinding Machine', '15', '1', '0', '0'),
('42', 'table1', 'table1', 'Table 1', '16', '1', '0', '0'),
('43', 'tb2', 'tb2', 'Table 2', '14', '1', '0', '0'),
('44', '10001', '10001', 'Chairs', '17', '1', '0', '0'),
('45', '10002', '10002', 'Chairs', '17', '1', '0', '0'),
('46', 'LPPCPGFSAV1SBCO', 'LPPCPGFSAV1SBCO', 'F-Seure Client Security License for one year-LPPCPGFSAV1SBCO', '12', '1', '0', '0'),
('47', '2001', '2001', 'Table', '14', '1', '0', '0'),
('48', '2002', '2002', 'Table', '14', '1', '0', '0'),
('49', '2003', '2003', 'Table', '14', '1', '0', '0'),
('50', '0006', '0006', 'Registration of  Domain name  and Webhosting charges', '1', '1', '0', '0'),
('51', 'Datashur', 'Datashur', 'Datashur Flash Drive', '2', '1', '0', '0'),
('52', 'LPPCPGVG1U3Y', 'LPPCPGVG1U3Y', 'F-secure Client Security 1 User 3 Years License-LPPCPGVG1U3Y', '12', '1', '0', '0'),
('53', 'Threeyearoneuser', 'Threeyearoneuser', 'Emsisoft license - 3 year 1 user', '13', '1', '0', '0'),
('54', 'oneyear', 'oneyear', 'License - 1 year 1 user EMSI', '13', '1', '0', '0'),
('55', 'Pouch', 'Pouch', 'Cost of Pouch', '13', '1', '0', '0'),
('57', 'Water', 'Water', 'Water Bottles', '1', '1', '0', '1'),
('58', 'W/H', 'W/H', 'Web Hosting Charges', '1', '1', '0', '0'),
('59', 'ACCSOFT', 'ACCSOFT', 'Accpac Software Development &amp; Implimentation Charges', '18', '1', '0', '0'),
('60', 'ACCSERVICE', 'ACCSERVICE', 'Accpac Software support service', '18', '1', '0', '0'),
('61', 'IS-DA2-256-1000B', 'IS-DA2-256-1000B', 'DiskAshur2 256-bit 1TB - Black', '2', '1', '0', '0'),
('62', 'EMSI', 'EMSI', 'EMSI Soft Client Security 1 User 1 Year', '9', '1', '0', '0'),
('63', 'EMSISoft-Box', 'EMSISoft-Box', 'EMSI Soft Boxes', '13', '1', '0', '0'),
('64', 'EMSISoft-Disk', 'EMSISoft-Disk', 'EMSI Soft Disk', '13', '1', '0', '0'),
('65', 'P/C', 'P/C', 'Positive Charges', '1', '1', '0', '1'),
('66', 'S/P', 'S/P', 'Sticker Pasting', '13', '1', '0', '0'),
('67', 'LPPCPGENDPSECU', 'LPPCPGENDPSECU', 'F-Seure Client Security License for one year-	LPPCPGENDPSECU', '12', '1', '0', '0'),
('68', 'Symantec-Lic', 'Symantec-Lic', 'Symantec End Point Protection License', '9', '1', '0', '1'),
('69', 'SWIVELUSB16GB', 'SWIVELUSB16GB', ' USB 16GB 2.0  Flash Drive', '19', '1', '0', '1'),
('70', 'SWIVELUSB32GB', 'SWIVELUSB32GB', 'USB 32GB 2.0 Flash Drive', '19', '1', '0', '1'),
('71', 'OH', 'OH', 'Overhead cost - Sorting', '13', '1', '0', '0'),
('72', 'LPPVIRUSEMSI', 'LPPVIRUSEMSI', 'EMSI SOFT-EMSI Virus Guard', '12', '1', '0', '0'),
('74', 'EMSI3User', 'EMSI3User', 'EMSI Soft 3 User 1 Year', '9', '1', '0', '0'),
('75', 'EMSIPouch', 'EMSIPouch', 'EMSI 1 User 1 Year Pouch', '9', '1', '0', '0'),
('76', 'SOPHOS', 'SOPHOS', 'Sophos Central Endpoint Protection (formerly Central Endpoint Advanced) -1 yr. support', '11', '1', '0', '1'),
('77', 'SOPHOS.', 'SOPHOS.', 'Sophos Central Intercept X Advanced for Server (formerly Central Server Protection Advanced) - 1 yr. support', '11', '1', '0', '1'),
('78', 'SWIVELUSB8GB', 'SWIVELUSB8GB', 'USB 8GB 2.0 Flash Drive', '19', '1', '0', '1'),
('79', 'LPPCPGEMISSOFT', 'LPPCPGEMISSOFT', 'Emsi Soft Malware Software Ransoomware Production 03 Year', '12', '1', '0', '0'),
('80', '32GBSD', '32GBSD', '32 GB Micro SD Card', '20', '1', '0', '0'),
('82', '8GBSD', '8GBSD', '8 GB Micro SD Card', '20', '1', '0', '0'),
('83', '16GBOTG', '16GBOTG', '16 GB OTG', '21', '1', '0', '0'),
('84', '32GBOTG', '32GBOTG', '32 GB OTG', '21', '1', '0', '0'),
('85', '32GB3.0', '32GB3.0', 'USB 32GB 3.2 Flash Drive', '19', '1', '0', '0'),
('86', 'WIRELES', 'WIRELES', 'Wireless Charger', '19', '1', '0', '1'),
('87', 'SRP-275III', 'SRP-275III', 'SRP-275III Dot-matrix Receipt ', '2', '1', '0', '1'),
('88', 'AP3615', 'AP3615', 'HDD All in One Touch Terminal ', '2', '1', '0', '1'),
('89', 'CASHDRAWER', 'CASHDRAWER', 'Cash Drawer', '2', '1', '0', '1'),
('90', 'MicroSD16GB', 'MicroSD16GB', 'Micro SD 16GB C10', '20', '1', '0', '0'),
('91', 'NBT', 'NBT', 'NBT', '1', '1', '0', '1'),
('92', 'VAT', 'VAT', 'VAT', '1', '1', '0', '0'),
('93', 'LPPCEMSOFTSWFSFWER', 'LPPCEMSOFTSWFSFWER', 'EMSI-SOFTWARE', '12', '1', '0', '0'),
('94', 'CPU', 'CPU', 'INTEL-CPU-CORE i5', '2', '1', '0', '1'),
('95', 'emsi-enterprice', 'emsi-enterprice', 'EMSI SOFT Enterprice Security', '9', '1', '0', '0'),
('96', 'emsi-server', 'emsi-server', 'EMSI SOFT Server Licence Keys', '9', '1', '0', '0'),
('97', 'B100', 'B100', 'Mouse', '2', '1', '0', '1'),
('98', 'BW08', 'BW08', 'Keyboard', '2', '1', '0', '0'),
('99', '4GB2.0', '4GB2.0', '4 GB 2.0  Flash Drive', '19', '1', '0', '0'),
('100', 'RtnCheque', 'RtnCheque', 'Cheque Returns', '1', '1', '0', '1'),
('101', 'LicenseKey', 'LicenseKey', 'Emsisoft  license key only ', '9', '1', '0', '0'),
('102', '2GB2.0', '2GB2.0', '2 GB 2.0 USB Flash Drive', '19', '1', '0', '1'),
('103', 'EMSIPENDRIVE', 'EMSIPENDRIVE', 'EMSISOFT  Pendrives', '13', '1', '0', '1'),
('104', 'EMSI2N13U3Y', 'EMSI2N13U3Y', 'EMSI Soft 2 In 1 3 User 3 Years', '9', '1', '0', '0'),
('105', 'LicenseKey-', 'LicenseKey-', 'Emsisoft 5 user 1 year license key only ', '9', '1', '0', '0'),
('106', 'EMSI2N1', 'EMSI2N1', 'EMSI Soft Client Security 2 In 1 -1 User 1 Year', '9', '1', '0', '0'),
('107', 'Keys', 'Keys', 'Emsisoft 3 user 1 year license key only ', '9', '1', '0', '0'),
('108', 'Licenskey', 'Licenskey', 'EMSISOFT BUSINESS SECURITY ANTIVIRUS SOLUTION', '9', '1', '0', '0'),
('109', 'Magneticable', 'Magneticable', 'Magnetic Cable', '19', '1', '0', '0'),
('110', '8GB2.0', '8GB2.0', '8GB 2.0 Flash Drive', '19', '1', '0', '0'),
('111', '16GB2.0', '16GB2.0', '16GB 2.0 Flash Drive', '19', '1', '0', '0'),
('112', '32GB2.0', '32GB2.0', '32GB 2.0 Flash Drive', '19', '1', '0', '0'),
('113', 'EMSISOfT', 'EMSISOfT', 'EMSI SOFT 1 User 1 Year License Key Only', '9', '1', '0', '0'),
('114', 'LicenseKe', 'LicenseKe', 'Emsisoft 10 user 1 year license key only ', '9', '1', '0', '0');

### Structure of table `0_item_tax_type_exemptions` ###

DROP TABLE IF EXISTS `0_item_tax_type_exemptions`;

CREATE TABLE `0_item_tax_type_exemptions` (
  `item_tax_type_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_tax_type_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_type_exemptions` ###

INSERT INTO `0_item_tax_type_exemptions` VALUES
('2', '4'),
('4', '3'),
('4', '4'),
('5', '2'),
('5', '3');

### Structure of table `0_item_tax_types` ###

DROP TABLE IF EXISTS `0_item_tax_types`;

CREATE TABLE `0_item_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `exempt` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_types` ###

INSERT INTO `0_item_tax_types` VALUES
('1', 'Regular', '0', '0'),
('2', 'Local software', '0', '0'),
('3', 'Exempt', '1', '0'),
('4', 'NBT Only', '0', '0'),
('5', 'VAT only', '0', '0');

### Structure of table `0_item_units` ###

DROP TABLE IF EXISTS `0_item_units`;

CREATE TABLE `0_item_units` (
  `abbr` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `decimals` tinyint(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`abbr`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_units` ###

INSERT INTO `0_item_units` VALUES
(' Licenses', 'F-Secure -  Licenses', '0', '0'),
('Box', 'Boxes', '0', '0'),
('Cone', 'Cone', '-1', '0'),
('ea.', 'Each', '1', '0'),
('hrs', 'Hours', '1', '0'),
('Kg', 'Kilogram', '-1', '0'),
('l', 'Liter', '3', '0'),
('Mtr', 'Meters', '-1', '0'),
('Nos', 'Numbers', '0', '0'),
('Yard', 'Yard', '-1', '0');

### Structure of table `0_journal` ###

DROP TABLE IF EXISTS `0_journal`;

CREATE TABLE `0_journal` (
  `type` smallint(6) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `tran_date` date DEFAULT '0000-00-00',
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `source_ref` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `event_date` date DEFAULT '0000-00-00',
  `doc_date` date NOT NULL DEFAULT '0000-00-00',
  `currency` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_journal` ###


### Structure of table `0_loc_stock` ###

DROP TABLE IF EXISTS `0_loc_stock`;

CREATE TABLE `0_loc_stock` (
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `reorder_level` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`loc_code`,`stock_id`),
  KEY `stock_id` (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_loc_stock` ###

INSERT INTO `0_loc_stock` VALUES
('01', '0006', '0'),
('01', '001', '0'),
('01', '002', '0'),
('01', '003', '0'),
('01', '004', '0'),
('01', '005', '0'),
('01', '006', '0'),
('01', '10001', '0'),
('01', '10002', '0'),
('01', '16GB2.0', '0'),
('01', '16GBOTG', '0'),
('01', '2001', '0'),
('01', '2002', '0'),
('01', '2003', '0'),
('01', '2GB2.0', '0'),
('01', '32GB2.0', '0'),
('01', '32GB3.0', '0'),
('01', '32GBOTG', '0'),
('01', '32GBSD', '0'),
('01', '4GB2.0', '0'),
('01', '8GB2.0', '0'),
('01', '8GBSD', '0'),
('01', 'ACCSERVICE', '0'),
('01', 'ACCSOFT', '0'),
('01', 'AP3615', '0'),
('01', 'B100', '0'),
('01', 'BW08', '0'),
('01', 'CASHDRAWER', '0'),
('01', 'CDs', '0'),
('01', 'CPU', '0'),
('01', 'Datashur', '0'),
('01', 'EMSI', '0'),
('01', 'emsi-enterprice', '0'),
('01', 'emsi-server', '0'),
('01', 'EMSI2N1', '0'),
('01', 'EMSI2N13U3Y', '0'),
('01', 'EMSI3User', '0'),
('01', 'EMSIPENDRIVE', '0'),
('01', 'EMSIPouch', '0'),
('01', 'EMSISOfT', '0'),
('01', 'EMSISoft-Box', '0'),
('01', 'EMSISoft-Disk', '0'),
('01', 'Export', '0'),
('01', 'Export01', '0'),
('01', 'Export02', '0'),
('01', 'Export03', '0'),
('01', 'Export04', '0'),
('01', 'F-Se3User', '0'),
('01', 'FCCW', '0'),
('01', 'FCE-MO', '0'),
('01', 'FCE-PC', '0'),
('01', 'FCSW', '0'),
('01', 'Freedome', '0'),
('01', 'FSe3year', '0'),
('01', 'FSebox', '0'),
('01', 'FSePouch', '0'),
('01', 'FW', '0'),
('01', 'IN01', '0'),
('01', 'IS-DA2-256-1000B', '0'),
('01', 'Keys', '0'),
('01', 'LicenseKe', '0'),
('01', 'LicenseKey', '0'),
('01', 'LicenseKey-', '0'),
('01', 'Licenskey', '0'),
('01', 'LPPCEMSOFTSWFSFWER', '0'),
('01', 'LPPCPGEMISSOFT', '0'),
('01', 'LPPCPGENDPSECU', '0'),
('01', 'LPPCPGFSAV1SBCO', '0'),
('01', 'LPPCPGFSAV1SU17CON', '0'),
('01', 'LPPCPGFSAV3', '0'),
('01', 'LPPCPGFSAVTPGCON', '0'),
('01', 'LPPCPGFSINVGCON', '0'),
('01', 'LPPCPGVG1U3Y', '0'),
('01', 'LPPVIRUSEMSI', '0'),
('01', 'Magneticable', '0'),
('01', 'Maintenence', '0'),
('01', 'ManagedServices', '0'),
('01', 'MH-001', '0'),
('01', 'MicroSD16GB', '0'),
('01', 'Mobile', '0'),
('01', 'NBT', '0'),
('01', 'OH', '0'),
('01', 'oneyear', '0'),
('01', 'P/C', '0'),
('01', 'Pouch', '0'),
('01', 'RtnCheque', '0'),
('01', 'S/P', '0'),
('01', 'Sec-Key', '0'),
('01', 'SKY-RE', '0'),
('01', 'SOPHOS', '0'),
('01', 'SOPHOS.', '0'),
('01', 'SRP-275III', '0'),
('01', 'SWIVELUSB16GB', '0'),
('01', 'SWIVELUSB32GB', '0'),
('01', 'SWIVELUSB8GB', '0'),
('01', 'Symantec-Lic', '0'),
('01', 'Table', '0'),
('01', 'table1', '0'),
('01', 'tb2', '0'),
('01', 'Threeyearoneuser', '0'),
('01', 'Training', '0'),
('01', 'VAT', '0'),
('01', 'W/H', '0'),
('01', 'Water', '0'),
('01', 'WIRELES', '0'),
('DEF', '0006', '0'),
('DEF', '001', '0'),
('DEF', '002', '0'),
('DEF', '003', '0'),
('DEF', '004', '0'),
('DEF', '005', '0'),
('DEF', '006', '0'),
('DEF', '10001', '0'),
('DEF', '10002', '0'),
('DEF', '16GB2.0', '0'),
('DEF', '16GBOTG', '0'),
('DEF', '2001', '0'),
('DEF', '2002', '0'),
('DEF', '2003', '0'),
('DEF', '2GB2.0', '0'),
('DEF', '32GB2.0', '0'),
('DEF', '32GB3.0', '0'),
('DEF', '32GBOTG', '0'),
('DEF', '32GBSD', '0'),
('DEF', '4GB2.0', '0'),
('DEF', '8GB2.0', '0'),
('DEF', '8GBSD', '0'),
('DEF', 'ACCSERVICE', '0'),
('DEF', 'ACCSOFT', '0'),
('DEF', 'AP3615', '0'),
('DEF', 'B100', '0'),
('DEF', 'BW08', '0'),
('DEF', 'CASHDRAWER', '0'),
('DEF', 'CDs', '0'),
('DEF', 'CPU', '0'),
('DEF', 'Datashur', '0'),
('DEF', 'EMSI', '0'),
('DEF', 'emsi-enterprice', '0'),
('DEF', 'emsi-server', '0'),
('DEF', 'EMSI2N1', '0'),
('DEF', 'EMSI2N13U3Y', '0'),
('DEF', 'EMSI3User', '0'),
('DEF', 'EMSIPENDRIVE', '0'),
('DEF', 'EMSIPouch', '0'),
('DEF', 'EMSISOfT', '0'),
('DEF', 'EMSISoft-Box', '0'),
('DEF', 'EMSISoft-Disk', '0'),
('DEF', 'Export', '0'),
('DEF', 'Export01', '0'),
('DEF', 'Export02', '0'),
('DEF', 'Export03', '0'),
('DEF', 'Export04', '0'),
('DEF', 'F-Se3User', '0'),
('DEF', 'FCCW', '0'),
('DEF', 'FCE-MO', '0'),
('DEF', 'FCE-PC', '0'),
('DEF', 'FCSW', '0'),
('DEF', 'Freedome', '0'),
('DEF', 'FSe3year', '0'),
('DEF', 'FSebox', '0'),
('DEF', 'FSePouch', '0'),
('DEF', 'FW', '0'),
('DEF', 'IN01', '0'),
('DEF', 'IS-DA2-256-1000B', '0'),
('DEF', 'Keys', '0'),
('DEF', 'LicenseKe', '0'),
('DEF', 'LicenseKey', '0'),
('DEF', 'LicenseKey-', '0'),
('DEF', 'Licenskey', '0'),
('DEF', 'LPPCEMSOFTSWFSFWER', '0'),
('DEF', 'LPPCPGEMISSOFT', '0'),
('DEF', 'LPPCPGENDPSECU', '0'),
('DEF', 'LPPCPGFSAV1SBCO', '0'),
('DEF', 'LPPCPGFSAV1SU17CON', '0'),
('DEF', 'LPPCPGFSAV3', '0'),
('DEF', 'LPPCPGFSAVTPGCON', '0'),
('DEF', 'LPPCPGFSINVGCON', '0'),
('DEF', 'LPPCPGVG1U3Y', '0'),
('DEF', 'LPPVIRUSEMSI', '0'),
('DEF', 'Magneticable', '0'),
('DEF', 'Maintenence', '0'),
('DEF', 'ManagedServices', '0'),
('DEF', 'MH-001', '0'),
('DEF', 'MicroSD16GB', '0'),
('DEF', 'Mobile', '0'),
('DEF', 'NBT', '0'),
('DEF', 'OH', '0'),
('DEF', 'oneyear', '0'),
('DEF', 'P/C', '0'),
('DEF', 'Pouch', '0'),
('DEF', 'RtnCheque', '0'),
('DEF', 'S/P', '0'),
('DEF', 'Sec-Key', '0'),
('DEF', 'SKY-RE', '0'),
('DEF', 'SOPHOS', '0'),
('DEF', 'SOPHOS.', '0'),
('DEF', 'SRP-275III', '0'),
('DEF', 'SWIVELUSB16GB', '0'),
('DEF', 'SWIVELUSB32GB', '0'),
('DEF', 'SWIVELUSB8GB', '0'),
('DEF', 'Symantec-Lic', '0'),
('DEF', 'Table', '0'),
('DEF', 'table1', '0'),
('DEF', 'tb2', '0'),
('DEF', 'Threeyearoneuser', '0'),
('DEF', 'Training', '0'),
('DEF', 'VAT', '0'),
('DEF', 'W/H', '0'),
('DEF', 'Water', '0'),
('DEF', 'WIRELES', '0'),
('EV/S', '0006', '0'),
('EV/S', '001', '0'),
('EV/S', '002', '0'),
('EV/S', '003', '0'),
('EV/S', '004', '0'),
('EV/S', '005', '0'),
('EV/S', '006', '0'),
('EV/S', '10001', '0'),
('EV/S', '10002', '0'),
('EV/S', '16GB2.0', '0'),
('EV/S', '16GBOTG', '0'),
('EV/S', '2001', '0'),
('EV/S', '2002', '0'),
('EV/S', '2003', '0'),
('EV/S', '2GB2.0', '0'),
('EV/S', '32GB2.0', '0'),
('EV/S', '32GB3.0', '0'),
('EV/S', '32GBOTG', '0'),
('EV/S', '32GBSD', '0'),
('EV/S', '4GB2.0', '0'),
('EV/S', '8GB2.0', '0'),
('EV/S', '8GBSD', '0'),
('EV/S', 'ACCSERVICE', '0'),
('EV/S', 'ACCSOFT', '0'),
('EV/S', 'AP3615', '0'),
('EV/S', 'B100', '0'),
('EV/S', 'BW08', '0'),
('EV/S', 'CASHDRAWER', '0'),
('EV/S', 'CDs', '0'),
('EV/S', 'CPU', '0'),
('EV/S', 'Datashur', '0'),
('EV/S', 'EMSI', '0'),
('EV/S', 'emsi-enterprice', '0'),
('EV/S', 'emsi-server', '0'),
('EV/S', 'EMSI2N1', '0'),
('EV/S', 'EMSI2N13U3Y', '0'),
('EV/S', 'EMSI3User', '0'),
('EV/S', 'EMSIPENDRIVE', '0'),
('EV/S', 'EMSIPouch', '0'),
('EV/S', 'EMSISOfT', '0'),
('EV/S', 'EMSISoft-Box', '0'),
('EV/S', 'EMSISoft-Disk', '0'),
('EV/S', 'Export', '0'),
('EV/S', 'Export01', '0'),
('EV/S', 'Export02', '0'),
('EV/S', 'Export03', '0'),
('EV/S', 'Export04', '0'),
('EV/S', 'F-Se3User', '0'),
('EV/S', 'FCCW', '0'),
('EV/S', 'FCE-MO', '0'),
('EV/S', 'FCE-PC', '0'),
('EV/S', 'FCSW', '0'),
('EV/S', 'Freedome', '0'),
('EV/S', 'FSe3year', '0'),
('EV/S', 'FSebox', '0'),
('EV/S', 'FSePouch', '0'),
('EV/S', 'FW', '0'),
('EV/S', 'IN01', '0'),
('EV/S', 'IS-DA2-256-1000B', '0'),
('EV/S', 'Keys', '0'),
('EV/S', 'LicenseKe', '0'),
('EV/S', 'LicenseKey', '0'),
('EV/S', 'LicenseKey-', '0'),
('EV/S', 'Licenskey', '0'),
('EV/S', 'LPPCEMSOFTSWFSFWER', '0'),
('EV/S', 'LPPCPGEMISSOFT', '0'),
('EV/S', 'LPPCPGENDPSECU', '0'),
('EV/S', 'LPPCPGFSAV1SBCO', '0'),
('EV/S', 'LPPCPGFSAV1SU17CON', '0'),
('EV/S', 'LPPCPGFSAV3', '0'),
('EV/S', 'LPPCPGFSAVTPGCON', '0'),
('EV/S', 'LPPCPGFSINVGCON', '0'),
('EV/S', 'LPPCPGVG1U3Y', '0'),
('EV/S', 'LPPVIRUSEMSI', '0'),
('EV/S', 'Magneticable', '0'),
('EV/S', 'Maintenence', '0'),
('EV/S', 'ManagedServices', '0'),
('EV/S', 'MH-001', '0'),
('EV/S', 'MicroSD16GB', '0'),
('EV/S', 'Mobile', '0'),
('EV/S', 'NBT', '0'),
('EV/S', 'OH', '0'),
('EV/S', 'oneyear', '0'),
('EV/S', 'P/C', '0'),
('EV/S', 'Pouch', '0'),
('EV/S', 'RtnCheque', '0'),
('EV/S', 'S/P', '0'),
('EV/S', 'Sec-Key', '0'),
('EV/S', 'SKY-RE', '0'),
('EV/S', 'SOPHOS', '0'),
('EV/S', 'SOPHOS.', '0'),
('EV/S', 'SRP-275III', '0'),
('EV/S', 'SWIVELUSB16GB', '0'),
('EV/S', 'SWIVELUSB32GB', '0'),
('EV/S', 'SWIVELUSB8GB', '0'),
('EV/S', 'Symantec-Lic', '0'),
('EV/S', 'Table', '0'),
('EV/S', 'table1', '0'),
('EV/S', 'tb2', '0'),
('EV/S', 'Threeyearoneuser', '0'),
('EV/S', 'Training', '0'),
('EV/S', 'VAT', '0'),
('EV/S', 'W/H', '0'),
('EV/S', 'Water', '0'),
('EV/S', 'WIRELES', '0'),
('F01', '0006', '0'),
('F01', '001', '0'),
('F01', '002', '0'),
('F01', '003', '0'),
('F01', '004', '0'),
('F01', '005', '0'),
('F01', '006', '0'),
('F01', '10001', '0'),
('F01', '10002', '0'),
('F01', '16GB2.0', '0'),
('F01', '16GBOTG', '0'),
('F01', '2001', '0'),
('F01', '2002', '0'),
('F01', '2003', '0'),
('F01', '2GB2.0', '0'),
('F01', '32GB2.0', '0'),
('F01', '32GB3.0', '0'),
('F01', '32GBOTG', '0'),
('F01', '32GBSD', '0'),
('F01', '4GB2.0', '0'),
('F01', '8GB2.0', '0'),
('F01', '8GBSD', '0'),
('F01', 'ACCSERVICE', '0'),
('F01', 'ACCSOFT', '0'),
('F01', 'AP3615', '0'),
('F01', 'B100', '0'),
('F01', 'BW08', '0'),
('F01', 'CASHDRAWER', '0'),
('F01', 'CDs', '0'),
('F01', 'CPU', '0'),
('F01', 'Datashur', '0'),
('F01', 'EMSI', '0'),
('F01', 'emsi-enterprice', '0'),
('F01', 'emsi-server', '0'),
('F01', 'EMSI2N1', '0'),
('F01', 'EMSI2N13U3Y', '0'),
('F01', 'EMSI3User', '0'),
('F01', 'EMSIPENDRIVE', '0'),
('F01', 'EMSIPouch', '0'),
('F01', 'EMSISOfT', '0'),
('F01', 'EMSISoft-Box', '0'),
('F01', 'EMSISoft-Disk', '0'),
('F01', 'Export', '0'),
('F01', 'Export01', '0'),
('F01', 'Export02', '0'),
('F01', 'Export03', '0'),
('F01', 'Export04', '0'),
('F01', 'F-Se3User', '0'),
('F01', 'FCCW', '0'),
('F01', 'FCE-MO', '0'),
('F01', 'FCE-PC', '0'),
('F01', 'FCSW', '0'),
('F01', 'Freedome', '0'),
('F01', 'FSe3year', '0'),
('F01', 'FSebox', '0'),
('F01', 'FSePouch', '0'),
('F01', 'FW', '0'),
('F01', 'IN01', '0'),
('F01', 'IS-DA2-256-1000B', '0'),
('F01', 'Keys', '0'),
('F01', 'LicenseKe', '0'),
('F01', 'LicenseKey', '0'),
('F01', 'LicenseKey-', '0'),
('F01', 'Licenskey', '0'),
('F01', 'LPPCEMSOFTSWFSFWER', '0'),
('F01', 'LPPCPGEMISSOFT', '0'),
('F01', 'LPPCPGENDPSECU', '0'),
('F01', 'LPPCPGFSAV1SBCO', '0'),
('F01', 'LPPCPGFSAV1SU17CON', '0'),
('F01', 'LPPCPGFSAV3', '0'),
('F01', 'LPPCPGFSAVTPGCON', '0'),
('F01', 'LPPCPGFSINVGCON', '0'),
('F01', 'LPPCPGVG1U3Y', '0'),
('F01', 'LPPVIRUSEMSI', '0'),
('F01', 'Magneticable', '0'),
('F01', 'Maintenence', '0'),
('F01', 'ManagedServices', '0'),
('F01', 'MH-001', '0'),
('F01', 'MicroSD16GB', '0'),
('F01', 'Mobile', '0'),
('F01', 'NBT', '0'),
('F01', 'OH', '0'),
('F01', 'oneyear', '0'),
('F01', 'P/C', '0'),
('F01', 'Pouch', '0'),
('F01', 'RtnCheque', '0'),
('F01', 'S/P', '0'),
('F01', 'Sec-Key', '0'),
('F01', 'SKY-RE', '0'),
('F01', 'SOPHOS', '0'),
('F01', 'SOPHOS.', '0'),
('F01', 'SRP-275III', '0'),
('F01', 'SWIVELUSB16GB', '0'),
('F01', 'SWIVELUSB32GB', '0'),
('F01', 'SWIVELUSB8GB', '0'),
('F01', 'Symantec-Lic', '0'),
('F01', 'Table', '0'),
('F01', 'table1', '0'),
('F01', 'tb2', '0'),
('F01', 'Threeyearoneuser', '0'),
('F01', 'Training', '0'),
('F01', 'VAT', '0'),
('F01', 'W/H', '0'),
('F01', 'Water', '0'),
('F01', 'WIRELES', '0'),
('F02', '0006', '0'),
('F02', '001', '0'),
('F02', '002', '0'),
('F02', '003', '0'),
('F02', '004', '0'),
('F02', '005', '0'),
('F02', '006', '0'),
('F02', '10001', '0'),
('F02', '10002', '0'),
('F02', '16GB2.0', '0'),
('F02', '16GBOTG', '0'),
('F02', '2001', '0'),
('F02', '2002', '0'),
('F02', '2003', '0'),
('F02', '2GB2.0', '0'),
('F02', '32GB2.0', '0'),
('F02', '32GB3.0', '0'),
('F02', '32GBOTG', '0'),
('F02', '32GBSD', '0'),
('F02', '4GB2.0', '0'),
('F02', '8GB2.0', '0'),
('F02', '8GBSD', '0'),
('F02', 'ACCSERVICE', '0'),
('F02', 'ACCSOFT', '0'),
('F02', 'AP3615', '0'),
('F02', 'B100', '0'),
('F02', 'BW08', '0'),
('F02', 'CASHDRAWER', '0'),
('F02', 'CDs', '0'),
('F02', 'CPU', '0'),
('F02', 'Datashur', '0'),
('F02', 'EMSI', '0'),
('F02', 'emsi-enterprice', '0'),
('F02', 'emsi-server', '0'),
('F02', 'EMSI2N1', '0'),
('F02', 'EMSI2N13U3Y', '0'),
('F02', 'EMSI3User', '0'),
('F02', 'EMSIPENDRIVE', '0'),
('F02', 'EMSIPouch', '0'),
('F02', 'EMSISOfT', '0'),
('F02', 'EMSISoft-Box', '0'),
('F02', 'EMSISoft-Disk', '0'),
('F02', 'Export', '0'),
('F02', 'Export01', '0'),
('F02', 'Export02', '0'),
('F02', 'Export03', '0'),
('F02', 'Export04', '0'),
('F02', 'F-Se3User', '0'),
('F02', 'FCCW', '0'),
('F02', 'FCE-MO', '0'),
('F02', 'FCE-PC', '0'),
('F02', 'FCSW', '0'),
('F02', 'Freedome', '0'),
('F02', 'FSe3year', '0'),
('F02', 'FSebox', '0'),
('F02', 'FSePouch', '0'),
('F02', 'FW', '0'),
('F02', 'IN01', '0'),
('F02', 'IS-DA2-256-1000B', '0'),
('F02', 'Keys', '0'),
('F02', 'LicenseKe', '0'),
('F02', 'LicenseKey', '0'),
('F02', 'LicenseKey-', '0'),
('F02', 'Licenskey', '0'),
('F02', 'LPPCEMSOFTSWFSFWER', '0'),
('F02', 'LPPCPGEMISSOFT', '0'),
('F02', 'LPPCPGENDPSECU', '0'),
('F02', 'LPPCPGFSAV1SBCO', '0'),
('F02', 'LPPCPGFSAV1SU17CON', '0'),
('F02', 'LPPCPGFSAV3', '0'),
('F02', 'LPPCPGFSAVTPGCON', '0'),
('F02', 'LPPCPGFSINVGCON', '0'),
('F02', 'LPPCPGVG1U3Y', '0'),
('F02', 'LPPVIRUSEMSI', '0'),
('F02', 'Magneticable', '0'),
('F02', 'Maintenence', '0'),
('F02', 'ManagedServices', '0'),
('F02', 'MH-001', '0'),
('F02', 'MicroSD16GB', '0'),
('F02', 'Mobile', '0'),
('F02', 'NBT', '0'),
('F02', 'OH', '0'),
('F02', 'oneyear', '0'),
('F02', 'P/C', '0'),
('F02', 'Pouch', '0'),
('F02', 'RtnCheque', '0'),
('F02', 'S/P', '0'),
('F02', 'Sec-Key', '0'),
('F02', 'SKY-RE', '0'),
('F02', 'SOPHOS', '0'),
('F02', 'SOPHOS.', '0'),
('F02', 'SRP-275III', '0'),
('F02', 'SWIVELUSB16GB', '0'),
('F02', 'SWIVELUSB32GB', '0'),
('F02', 'SWIVELUSB8GB', '0'),
('F02', 'Symantec-Lic', '0'),
('F02', 'Table', '0'),
('F02', 'table1', '0'),
('F02', 'tb2', '0'),
('F02', 'Threeyearoneuser', '0'),
('F02', 'Training', '0'),
('F02', 'VAT', '0'),
('F02', 'W/H', '0'),
('F02', 'Water', '0'),
('F02', 'WIRELES', '0'),
('F03', '0006', '0'),
('F03', '001', '0'),
('F03', '002', '0'),
('F03', '003', '0'),
('F03', '004', '0'),
('F03', '005', '0'),
('F03', '006', '0'),
('F03', '10001', '0'),
('F03', '10002', '0'),
('F03', '16GB2.0', '0'),
('F03', '16GBOTG', '0'),
('F03', '2001', '0'),
('F03', '2002', '0'),
('F03', '2003', '0'),
('F03', '2GB2.0', '0'),
('F03', '32GB2.0', '0'),
('F03', '32GB3.0', '0'),
('F03', '32GBOTG', '0'),
('F03', '32GBSD', '0'),
('F03', '4GB2.0', '0'),
('F03', '8GB2.0', '0'),
('F03', '8GBSD', '0'),
('F03', 'ACCSERVICE', '0'),
('F03', 'ACCSOFT', '0'),
('F03', 'AP3615', '0'),
('F03', 'B100', '0'),
('F03', 'BW08', '0'),
('F03', 'CASHDRAWER', '0'),
('F03', 'CDs', '0'),
('F03', 'CPU', '0'),
('F03', 'Datashur', '0'),
('F03', 'EMSI', '0'),
('F03', 'emsi-enterprice', '0'),
('F03', 'emsi-server', '0'),
('F03', 'EMSI2N1', '0'),
('F03', 'EMSI2N13U3Y', '0'),
('F03', 'EMSI3User', '0'),
('F03', 'EMSIPENDRIVE', '0'),
('F03', 'EMSIPouch', '0'),
('F03', 'EMSISOfT', '0'),
('F03', 'EMSISoft-Box', '0'),
('F03', 'EMSISoft-Disk', '0'),
('F03', 'Export', '0'),
('F03', 'Export01', '0'),
('F03', 'Export02', '0'),
('F03', 'Export03', '0'),
('F03', 'Export04', '0'),
('F03', 'F-Se3User', '0'),
('F03', 'FCCW', '0'),
('F03', 'FCE-MO', '0'),
('F03', 'FCE-PC', '0'),
('F03', 'FCSW', '0'),
('F03', 'Freedome', '0'),
('F03', 'FSe3year', '0'),
('F03', 'FSebox', '0'),
('F03', 'FSePouch', '0'),
('F03', 'FW', '0'),
('F03', 'IN01', '0'),
('F03', 'IS-DA2-256-1000B', '0'),
('F03', 'Keys', '0'),
('F03', 'LicenseKe', '0'),
('F03', 'LicenseKey', '0'),
('F03', 'LicenseKey-', '0'),
('F03', 'Licenskey', '0'),
('F03', 'LPPCEMSOFTSWFSFWER', '0'),
('F03', 'LPPCPGEMISSOFT', '0'),
('F03', 'LPPCPGENDPSECU', '0'),
('F03', 'LPPCPGFSAV1SBCO', '0'),
('F03', 'LPPCPGFSAV1SU17CON', '0'),
('F03', 'LPPCPGFSAV3', '0'),
('F03', 'LPPCPGFSAVTPGCON', '0'),
('F03', 'LPPCPGFSINVGCON', '0'),
('F03', 'LPPCPGVG1U3Y', '0'),
('F03', 'LPPVIRUSEMSI', '0'),
('F03', 'Magneticable', '0'),
('F03', 'Maintenence', '0'),
('F03', 'ManagedServices', '0'),
('F03', 'MH-001', '0'),
('F03', 'MicroSD16GB', '0'),
('F03', 'Mobile', '0'),
('F03', 'NBT', '0'),
('F03', 'OH', '0'),
('F03', 'oneyear', '0'),
('F03', 'P/C', '0'),
('F03', 'Pouch', '0'),
('F03', 'RtnCheque', '0'),
('F03', 'S/P', '0'),
('F03', 'Sec-Key', '0'),
('F03', 'SKY-RE', '0'),
('F03', 'SOPHOS', '0'),
('F03', 'SOPHOS.', '0'),
('F03', 'SRP-275III', '0'),
('F03', 'SWIVELUSB16GB', '0'),
('F03', 'SWIVELUSB32GB', '0'),
('F03', 'SWIVELUSB8GB', '0'),
('F03', 'Symantec-Lic', '0'),
('F03', 'Table', '0'),
('F03', 'table1', '0'),
('F03', 'tb2', '0'),
('F03', 'Threeyearoneuser', '0'),
('F03', 'Training', '0'),
('F03', 'VAT', '0'),
('F03', 'W/H', '0'),
('F03', 'Water', '0'),
('F03', 'WIRELES', '0'),
('F04', '0006', '0'),
('F04', '001', '0'),
('F04', '002', '0'),
('F04', '003', '0'),
('F04', '004', '0'),
('F04', '005', '0'),
('F04', '006', '0'),
('F04', '10001', '0'),
('F04', '10002', '0'),
('F04', '16GB2.0', '0'),
('F04', '16GBOTG', '0'),
('F04', '2001', '0'),
('F04', '2002', '0'),
('F04', '2003', '0'),
('F04', '2GB2.0', '0'),
('F04', '32GB2.0', '0'),
('F04', '32GB3.0', '0'),
('F04', '32GBOTG', '0'),
('F04', '32GBSD', '0'),
('F04', '4GB2.0', '0'),
('F04', '8GB2.0', '0'),
('F04', '8GBSD', '0'),
('F04', 'ACCSERVICE', '0'),
('F04', 'ACCSOFT', '0'),
('F04', 'AP3615', '0'),
('F04', 'B100', '0'),
('F04', 'BW08', '0'),
('F04', 'CASHDRAWER', '0'),
('F04', 'CDs', '0'),
('F04', 'CPU', '0'),
('F04', 'Datashur', '0'),
('F04', 'EMSI', '0'),
('F04', 'emsi-enterprice', '0'),
('F04', 'emsi-server', '0'),
('F04', 'EMSI2N1', '0'),
('F04', 'EMSI2N13U3Y', '0'),
('F04', 'EMSI3User', '0'),
('F04', 'EMSIPENDRIVE', '0'),
('F04', 'EMSIPouch', '0'),
('F04', 'EMSISOfT', '0'),
('F04', 'EMSISoft-Box', '0'),
('F04', 'EMSISoft-Disk', '0'),
('F04', 'Export', '0'),
('F04', 'Export01', '0'),
('F04', 'Export02', '0'),
('F04', 'Export03', '0'),
('F04', 'Export04', '0'),
('F04', 'F-Se3User', '0'),
('F04', 'FCCW', '0'),
('F04', 'FCE-MO', '0'),
('F04', 'FCE-PC', '0'),
('F04', 'FCSW', '0'),
('F04', 'Freedome', '0'),
('F04', 'FSe3year', '0'),
('F04', 'FSebox', '0'),
('F04', 'FSePouch', '0'),
('F04', 'FW', '0'),
('F04', 'IN01', '0'),
('F04', 'IS-DA2-256-1000B', '0'),
('F04', 'Keys', '0'),
('F04', 'LicenseKe', '0'),
('F04', 'LicenseKey', '0'),
('F04', 'LicenseKey-', '0'),
('F04', 'Licenskey', '0'),
('F04', 'LPPCEMSOFTSWFSFWER', '0'),
('F04', 'LPPCPGEMISSOFT', '0'),
('F04', 'LPPCPGENDPSECU', '0'),
('F04', 'LPPCPGFSAV1SBCO', '0'),
('F04', 'LPPCPGFSAV1SU17CON', '0'),
('F04', 'LPPCPGFSAV3', '0'),
('F04', 'LPPCPGFSAVTPGCON', '0'),
('F04', 'LPPCPGFSINVGCON', '0'),
('F04', 'LPPCPGVG1U3Y', '0'),
('F04', 'LPPVIRUSEMSI', '0'),
('F04', 'Magneticable', '0'),
('F04', 'Maintenence', '0'),
('F04', 'ManagedServices', '0'),
('F04', 'MH-001', '0'),
('F04', 'MicroSD16GB', '0'),
('F04', 'Mobile', '0'),
('F04', 'NBT', '0'),
('F04', 'OH', '0'),
('F04', 'oneyear', '0'),
('F04', 'P/C', '0'),
('F04', 'Pouch', '0'),
('F04', 'RtnCheque', '0'),
('F04', 'S/P', '0'),
('F04', 'Sec-Key', '0'),
('F04', 'SKY-RE', '0'),
('F04', 'SOPHOS', '0'),
('F04', 'SOPHOS.', '0'),
('F04', 'SRP-275III', '0'),
('F04', 'SWIVELUSB16GB', '0'),
('F04', 'SWIVELUSB32GB', '0'),
('F04', 'SWIVELUSB8GB', '0'),
('F04', 'Symantec-Lic', '0'),
('F04', 'Table', '0'),
('F04', 'table1', '0'),
('F04', 'tb2', '0'),
('F04', 'Threeyearoneuser', '0'),
('F04', 'Training', '0'),
('F04', 'VAT', '0'),
('F04', 'W/H', '0'),
('F04', 'Water', '0'),
('F04', 'WIRELES', '0'),
('F05', '0006', '0'),
('F05', '001', '0'),
('F05', '002', '0'),
('F05', '003', '0'),
('F05', '004', '0'),
('F05', '005', '0'),
('F05', '006', '0'),
('F05', '10001', '0'),
('F05', '10002', '0'),
('F05', '16GB2.0', '0'),
('F05', '16GBOTG', '0'),
('F05', '2001', '0'),
('F05', '2002', '0'),
('F05', '2003', '0'),
('F05', '2GB2.0', '0'),
('F05', '32GB2.0', '0'),
('F05', '32GB3.0', '0'),
('F05', '32GBOTG', '0'),
('F05', '32GBSD', '0'),
('F05', '4GB2.0', '0'),
('F05', '8GB2.0', '0'),
('F05', '8GBSD', '0'),
('F05', 'ACCSERVICE', '0'),
('F05', 'ACCSOFT', '0'),
('F05', 'AP3615', '0'),
('F05', 'B100', '0'),
('F05', 'BW08', '0'),
('F05', 'CASHDRAWER', '0'),
('F05', 'CDs', '0'),
('F05', 'CPU', '0'),
('F05', 'Datashur', '0'),
('F05', 'EMSI', '0'),
('F05', 'emsi-enterprice', '0'),
('F05', 'emsi-server', '0'),
('F05', 'EMSI2N1', '0'),
('F05', 'EMSI2N13U3Y', '0'),
('F05', 'EMSI3User', '0'),
('F05', 'EMSIPENDRIVE', '0'),
('F05', 'EMSIPouch', '0'),
('F05', 'EMSISOfT', '0'),
('F05', 'EMSISoft-Box', '0'),
('F05', 'EMSISoft-Disk', '0'),
('F05', 'Export', '0'),
('F05', 'Export01', '0'),
('F05', 'Export02', '0'),
('F05', 'Export03', '0'),
('F05', 'Export04', '0'),
('F05', 'F-Se3User', '0'),
('F05', 'FCCW', '0'),
('F05', 'FCE-MO', '0'),
('F05', 'FCE-PC', '0'),
('F05', 'FCSW', '0'),
('F05', 'Freedome', '0'),
('F05', 'FSe3year', '0'),
('F05', 'FSebox', '0'),
('F05', 'FSePouch', '0'),
('F05', 'FW', '0'),
('F05', 'IN01', '0'),
('F05', 'IS-DA2-256-1000B', '0'),
('F05', 'Keys', '0'),
('F05', 'LicenseKe', '0'),
('F05', 'LicenseKey', '0'),
('F05', 'LicenseKey-', '0'),
('F05', 'Licenskey', '0'),
('F05', 'LPPCEMSOFTSWFSFWER', '0'),
('F05', 'LPPCPGEMISSOFT', '0'),
('F05', 'LPPCPGENDPSECU', '0'),
('F05', 'LPPCPGFSAV1SBCO', '0'),
('F05', 'LPPCPGFSAV1SU17CON', '0'),
('F05', 'LPPCPGFSAV3', '0'),
('F05', 'LPPCPGFSAVTPGCON', '0'),
('F05', 'LPPCPGFSINVGCON', '0'),
('F05', 'LPPCPGVG1U3Y', '0'),
('F05', 'LPPVIRUSEMSI', '0'),
('F05', 'Magneticable', '0'),
('F05', 'Maintenence', '0'),
('F05', 'ManagedServices', '0'),
('F05', 'MH-001', '0'),
('F05', 'MicroSD16GB', '0'),
('F05', 'Mobile', '0'),
('F05', 'NBT', '0'),
('F05', 'OH', '0'),
('F05', 'oneyear', '0'),
('F05', 'P/C', '0'),
('F05', 'Pouch', '0'),
('F05', 'RtnCheque', '0'),
('F05', 'S/P', '0'),
('F05', 'Sec-Key', '0'),
('F05', 'SKY-RE', '0'),
('F05', 'SOPHOS', '0'),
('F05', 'SOPHOS.', '0'),
('F05', 'SRP-275III', '0'),
('F05', 'SWIVELUSB16GB', '0'),
('F05', 'SWIVELUSB32GB', '0'),
('F05', 'SWIVELUSB8GB', '0'),
('F05', 'Symantec-Lic', '0'),
('F05', 'Table', '0'),
('F05', 'table1', '0'),
('F05', 'tb2', '0'),
('F05', 'Threeyearoneuser', '0'),
('F05', 'Training', '0'),
('F05', 'VAT', '0'),
('F05', 'W/H', '0'),
('F05', 'Water', '0'),
('F05', 'WIRELES', '0'),
('F06', '0006', '0'),
('F06', '001', '0'),
('F06', '002', '0'),
('F06', '003', '0'),
('F06', '004', '0'),
('F06', '005', '0'),
('F06', '006', '0'),
('F06', '10001', '0'),
('F06', '10002', '0'),
('F06', '16GB2.0', '0'),
('F06', '16GBOTG', '0'),
('F06', '2001', '0'),
('F06', '2002', '0'),
('F06', '2003', '0'),
('F06', '2GB2.0', '0'),
('F06', '32GB2.0', '0'),
('F06', '32GB3.0', '0'),
('F06', '32GBOTG', '0'),
('F06', '32GBSD', '0'),
('F06', '4GB2.0', '0'),
('F06', '8GB2.0', '0'),
('F06', '8GBSD', '0'),
('F06', 'ACCSERVICE', '0'),
('F06', 'ACCSOFT', '0'),
('F06', 'AP3615', '0'),
('F06', 'B100', '0'),
('F06', 'BW08', '0'),
('F06', 'CASHDRAWER', '0'),
('F06', 'CDs', '0'),
('F06', 'CPU', '0'),
('F06', 'Datashur', '0'),
('F06', 'EMSI', '0'),
('F06', 'emsi-enterprice', '0'),
('F06', 'emsi-server', '0'),
('F06', 'EMSI2N1', '0'),
('F06', 'EMSI2N13U3Y', '0'),
('F06', 'EMSI3User', '0'),
('F06', 'EMSIPENDRIVE', '0'),
('F06', 'EMSIPouch', '0'),
('F06', 'EMSISOfT', '0'),
('F06', 'EMSISoft-Box', '0'),
('F06', 'EMSISoft-Disk', '0'),
('F06', 'Export', '0'),
('F06', 'Export01', '0'),
('F06', 'Export02', '0'),
('F06', 'Export03', '0'),
('F06', 'Export04', '0'),
('F06', 'F-Se3User', '0'),
('F06', 'FCCW', '0'),
('F06', 'FCE-MO', '0'),
('F06', 'FCE-PC', '0'),
('F06', 'FCSW', '0'),
('F06', 'Freedome', '0'),
('F06', 'FSe3year', '0'),
('F06', 'FSebox', '0'),
('F06', 'FSePouch', '0'),
('F06', 'FW', '0'),
('F06', 'IN01', '0'),
('F06', 'IS-DA2-256-1000B', '0'),
('F06', 'Keys', '0'),
('F06', 'LicenseKe', '0'),
('F06', 'LicenseKey', '0'),
('F06', 'LicenseKey-', '0'),
('F06', 'Licenskey', '0'),
('F06', 'LPPCEMSOFTSWFSFWER', '0'),
('F06', 'LPPCPGEMISSOFT', '0'),
('F06', 'LPPCPGENDPSECU', '0'),
('F06', 'LPPCPGFSAV1SBCO', '0'),
('F06', 'LPPCPGFSAV1SU17CON', '0'),
('F06', 'LPPCPGFSAV3', '0'),
('F06', 'LPPCPGFSAVTPGCON', '0'),
('F06', 'LPPCPGFSINVGCON', '0'),
('F06', 'LPPCPGVG1U3Y', '0'),
('F06', 'LPPVIRUSEMSI', '0'),
('F06', 'Magneticable', '0'),
('F06', 'Maintenence', '0'),
('F06', 'ManagedServices', '0'),
('F06', 'MH-001', '0'),
('F06', 'MicroSD16GB', '0'),
('F06', 'Mobile', '0'),
('F06', 'NBT', '0'),
('F06', 'OH', '0'),
('F06', 'oneyear', '0'),
('F06', 'P/C', '0'),
('F06', 'Pouch', '0'),
('F06', 'RtnCheque', '0'),
('F06', 'S/P', '0'),
('F06', 'Sec-Key', '0'),
('F06', 'SKY-RE', '0'),
('F06', 'SOPHOS', '0'),
('F06', 'SOPHOS.', '0'),
('F06', 'SRP-275III', '0'),
('F06', 'SWIVELUSB16GB', '0'),
('F06', 'SWIVELUSB32GB', '0'),
('F06', 'SWIVELUSB8GB', '0'),
('F06', 'Symantec-Lic', '0'),
('F06', 'Table', '0'),
('F06', 'table1', '0'),
('F06', 'tb2', '0'),
('F06', 'Threeyearoneuser', '0'),
('F06', 'Training', '0'),
('F06', 'VAT', '0'),
('F06', 'W/H', '0'),
('F06', 'Water', '0'),
('F06', 'WIRELES', '0'),
('F07', '0006', '0'),
('F07', '001', '0'),
('F07', '002', '0'),
('F07', '003', '0'),
('F07', '004', '0'),
('F07', '005', '0'),
('F07', '006', '0'),
('F07', '10001', '0'),
('F07', '10002', '0'),
('F07', '16GB2.0', '0'),
('F07', '16GBOTG', '0'),
('F07', '2001', '0'),
('F07', '2002', '0'),
('F07', '2003', '0'),
('F07', '2GB2.0', '0'),
('F07', '32GB2.0', '0'),
('F07', '32GB3.0', '0'),
('F07', '32GBOTG', '0'),
('F07', '32GBSD', '0'),
('F07', '4GB2.0', '0'),
('F07', '8GB2.0', '0'),
('F07', '8GBSD', '0'),
('F07', 'ACCSERVICE', '0'),
('F07', 'ACCSOFT', '0'),
('F07', 'AP3615', '0'),
('F07', 'B100', '0'),
('F07', 'BW08', '0'),
('F07', 'CASHDRAWER', '0'),
('F07', 'CDs', '0'),
('F07', 'CPU', '0'),
('F07', 'Datashur', '0'),
('F07', 'EMSI', '0'),
('F07', 'emsi-enterprice', '0'),
('F07', 'emsi-server', '0'),
('F07', 'EMSI2N1', '0'),
('F07', 'EMSI2N13U3Y', '0'),
('F07', 'EMSI3User', '0'),
('F07', 'EMSIPENDRIVE', '0'),
('F07', 'EMSIPouch', '0'),
('F07', 'EMSISOfT', '0'),
('F07', 'EMSISoft-Box', '0'),
('F07', 'EMSISoft-Disk', '0'),
('F07', 'Export', '0'),
('F07', 'Export01', '0'),
('F07', 'Export02', '0'),
('F07', 'Export03', '0'),
('F07', 'Export04', '0'),
('F07', 'F-Se3User', '0'),
('F07', 'FCCW', '0'),
('F07', 'FCE-MO', '0'),
('F07', 'FCE-PC', '0'),
('F07', 'FCSW', '0'),
('F07', 'Freedome', '0'),
('F07', 'FSe3year', '0'),
('F07', 'FSebox', '0'),
('F07', 'FSePouch', '0'),
('F07', 'FW', '0'),
('F07', 'IN01', '0'),
('F07', 'IS-DA2-256-1000B', '0'),
('F07', 'Keys', '0'),
('F07', 'LicenseKe', '0'),
('F07', 'LicenseKey', '0'),
('F07', 'LicenseKey-', '0'),
('F07', 'Licenskey', '0'),
('F07', 'LPPCEMSOFTSWFSFWER', '0'),
('F07', 'LPPCPGEMISSOFT', '0'),
('F07', 'LPPCPGENDPSECU', '0'),
('F07', 'LPPCPGFSAV1SBCO', '0'),
('F07', 'LPPCPGFSAV1SU17CON', '0'),
('F07', 'LPPCPGFSAV3', '0'),
('F07', 'LPPCPGFSAVTPGCON', '0'),
('F07', 'LPPCPGFSINVGCON', '0'),
('F07', 'LPPCPGVG1U3Y', '0'),
('F07', 'LPPVIRUSEMSI', '0'),
('F07', 'Magneticable', '0'),
('F07', 'Maintenence', '0'),
('F07', 'ManagedServices', '0'),
('F07', 'MH-001', '0'),
('F07', 'MicroSD16GB', '0'),
('F07', 'Mobile', '0'),
('F07', 'NBT', '0'),
('F07', 'OH', '0'),
('F07', 'oneyear', '0'),
('F07', 'P/C', '0'),
('F07', 'Pouch', '0'),
('F07', 'RtnCheque', '0'),
('F07', 'S/P', '0'),
('F07', 'Sec-Key', '0'),
('F07', 'SKY-RE', '0'),
('F07', 'SOPHOS', '0'),
('F07', 'SOPHOS.', '0'),
('F07', 'SRP-275III', '0'),
('F07', 'SWIVELUSB16GB', '0'),
('F07', 'SWIVELUSB32GB', '0'),
('F07', 'SWIVELUSB8GB', '0'),
('F07', 'Symantec-Lic', '0'),
('F07', 'Table', '0'),
('F07', 'table1', '0'),
('F07', 'tb2', '0'),
('F07', 'Threeyearoneuser', '0'),
('F07', 'Training', '0'),
('F07', 'VAT', '0'),
('F07', 'W/H', '0'),
('F07', 'Water', '0'),
('F07', 'WIRELES', '0'),
('L01', '0006', '0'),
('L01', '001', '0'),
('L01', '002', '0'),
('L01', '003', '0'),
('L01', '004', '0'),
('L01', '005', '0'),
('L01', '006', '0'),
('L01', '10001', '0'),
('L01', '10002', '0'),
('L01', '16GB2.0', '0'),
('L01', '16GBOTG', '0'),
('L01', '2001', '0'),
('L01', '2002', '0'),
('L01', '2003', '0'),
('L01', '2GB2.0', '0'),
('L01', '32GB2.0', '0'),
('L01', '32GB3.0', '0'),
('L01', '32GBOTG', '0'),
('L01', '32GBSD', '0'),
('L01', '4GB2.0', '0'),
('L01', '8GB2.0', '0'),
('L01', '8GBSD', '0'),
('L01', 'ACCSERVICE', '0'),
('L01', 'ACCSOFT', '0'),
('L01', 'AP3615', '0'),
('L01', 'B100', '0'),
('L01', 'BW08', '0'),
('L01', 'CASHDRAWER', '0'),
('L01', 'CDs', '0'),
('L01', 'CPU', '0'),
('L01', 'Datashur', '0'),
('L01', 'EMSI', '0'),
('L01', 'emsi-enterprice', '0'),
('L01', 'emsi-server', '0'),
('L01', 'EMSI2N1', '0'),
('L01', 'EMSI2N13U3Y', '0'),
('L01', 'EMSI3User', '0'),
('L01', 'EMSIPENDRIVE', '0'),
('L01', 'EMSIPouch', '0'),
('L01', 'EMSISOfT', '0'),
('L01', 'EMSISoft-Box', '0'),
('L01', 'EMSISoft-Disk', '0'),
('L01', 'Export', '0'),
('L01', 'Export01', '0'),
('L01', 'Export02', '0'),
('L01', 'Export03', '0'),
('L01', 'Export04', '0'),
('L01', 'F-Se3User', '0'),
('L01', 'FCCW', '0'),
('L01', 'FCE-MO', '0'),
('L01', 'FCE-PC', '0'),
('L01', 'FCSW', '0'),
('L01', 'Freedome', '0'),
('L01', 'FSe3year', '0'),
('L01', 'FSebox', '0'),
('L01', 'FSePouch', '0'),
('L01', 'FW', '0'),
('L01', 'IN01', '0'),
('L01', 'IS-DA2-256-1000B', '0'),
('L01', 'Keys', '0'),
('L01', 'LicenseKe', '0'),
('L01', 'LicenseKey', '0'),
('L01', 'LicenseKey-', '0'),
('L01', 'Licenskey', '0'),
('L01', 'LPPCEMSOFTSWFSFWER', '0'),
('L01', 'LPPCPGEMISSOFT', '0'),
('L01', 'LPPCPGENDPSECU', '0'),
('L01', 'LPPCPGFSAV1SBCO', '0'),
('L01', 'LPPCPGFSAV1SU17CON', '0'),
('L01', 'LPPCPGFSAV3', '0'),
('L01', 'LPPCPGFSAVTPGCON', '0'),
('L01', 'LPPCPGFSINVGCON', '0'),
('L01', 'LPPCPGVG1U3Y', '0'),
('L01', 'LPPVIRUSEMSI', '0'),
('L01', 'Magneticable', '0'),
('L01', 'Maintenence', '0'),
('L01', 'ManagedServices', '0'),
('L01', 'MH-001', '0'),
('L01', 'MicroSD16GB', '0'),
('L01', 'Mobile', '0'),
('L01', 'NBT', '0'),
('L01', 'OH', '0'),
('L01', 'oneyear', '0'),
('L01', 'P/C', '0'),
('L01', 'Pouch', '0'),
('L01', 'RtnCheque', '0'),
('L01', 'S/P', '0'),
('L01', 'Sec-Key', '0'),
('L01', 'SKY-RE', '0'),
('L01', 'SOPHOS', '0'),
('L01', 'SOPHOS.', '0'),
('L01', 'SRP-275III', '0'),
('L01', 'SWIVELUSB16GB', '0'),
('L01', 'SWIVELUSB32GB', '0'),
('L01', 'SWIVELUSB8GB', '0'),
('L01', 'Symantec-Lic', '0'),
('L01', 'Table', '0'),
('L01', 'table1', '0'),
('L01', 'tb2', '0'),
('L01', 'Threeyearoneuser', '0'),
('L01', 'Training', '0'),
('L01', 'VAT', '0'),
('L01', 'W/H', '0'),
('L01', 'Water', '0'),
('L01', 'WIRELES', '0'),
('MOB', '0006', '0'),
('MOB', '001', '0'),
('MOB', '002', '0'),
('MOB', '003', '0'),
('MOB', '004', '0'),
('MOB', '005', '0'),
('MOB', '006', '0'),
('MOB', '10001', '0'),
('MOB', '10002', '0'),
('MOB', '16GB2.0', '0'),
('MOB', '16GBOTG', '0'),
('MOB', '2001', '0'),
('MOB', '2002', '0'),
('MOB', '2003', '0'),
('MOB', '2GB2.0', '0'),
('MOB', '32GB2.0', '0'),
('MOB', '32GB3.0', '0'),
('MOB', '32GBOTG', '0'),
('MOB', '32GBSD', '0'),
('MOB', '4GB2.0', '0'),
('MOB', '8GB2.0', '0'),
('MOB', '8GBSD', '0'),
('MOB', 'ACCSERVICE', '0'),
('MOB', 'ACCSOFT', '0'),
('MOB', 'AP3615', '0'),
('MOB', 'B100', '0'),
('MOB', 'BW08', '0'),
('MOB', 'CASHDRAWER', '0'),
('MOB', 'CDs', '0'),
('MOB', 'CPU', '0'),
('MOB', 'Datashur', '0'),
('MOB', 'EMSI', '0'),
('MOB', 'emsi-enterprice', '0'),
('MOB', 'emsi-server', '0'),
('MOB', 'EMSI2N1', '0'),
('MOB', 'EMSI2N13U3Y', '0'),
('MOB', 'EMSI3User', '0'),
('MOB', 'EMSIPENDRIVE', '0'),
('MOB', 'EMSIPouch', '0'),
('MOB', 'EMSISOfT', '0'),
('MOB', 'EMSISoft-Box', '0'),
('MOB', 'EMSISoft-Disk', '0'),
('MOB', 'Export', '0'),
('MOB', 'Export01', '0'),
('MOB', 'Export02', '0'),
('MOB', 'Export03', '0'),
('MOB', 'Export04', '0'),
('MOB', 'F-Se3User', '0'),
('MOB', 'FCCW', '0'),
('MOB', 'FCE-MO', '0'),
('MOB', 'FCE-PC', '0'),
('MOB', 'FCSW', '0'),
('MOB', 'Freedome', '0'),
('MOB', 'FSe3year', '0'),
('MOB', 'FSebox', '0'),
('MOB', 'FSePouch', '0'),
('MOB', 'FW', '0'),
('MOB', 'IN01', '0'),
('MOB', 'IS-DA2-256-1000B', '0'),
('MOB', 'Keys', '0'),
('MOB', 'LicenseKe', '0'),
('MOB', 'LicenseKey', '0'),
('MOB', 'LicenseKey-', '0'),
('MOB', 'Licenskey', '0'),
('MOB', 'LPPCEMSOFTSWFSFWER', '0'),
('MOB', 'LPPCPGEMISSOFT', '0'),
('MOB', 'LPPCPGENDPSECU', '0'),
('MOB', 'LPPCPGFSAV1SBCO', '0'),
('MOB', 'LPPCPGFSAV1SU17CON', '0'),
('MOB', 'LPPCPGFSAV3', '0'),
('MOB', 'LPPCPGFSAVTPGCON', '0'),
('MOB', 'LPPCPGFSINVGCON', '0'),
('MOB', 'LPPCPGVG1U3Y', '0'),
('MOB', 'LPPVIRUSEMSI', '0'),
('MOB', 'Magneticable', '0'),
('MOB', 'Maintenence', '0'),
('MOB', 'ManagedServices', '0'),
('MOB', 'MH-001', '0'),
('MOB', 'MicroSD16GB', '0'),
('MOB', 'Mobile', '0'),
('MOB', 'NBT', '0'),
('MOB', 'OH', '0'),
('MOB', 'oneyear', '0'),
('MOB', 'P/C', '0'),
('MOB', 'Pouch', '0'),
('MOB', 'RtnCheque', '0'),
('MOB', 'S/P', '0'),
('MOB', 'Sec-Key', '0'),
('MOB', 'SKY-RE', '0'),
('MOB', 'SOPHOS', '0'),
('MOB', 'SOPHOS.', '0'),
('MOB', 'SRP-275III', '0'),
('MOB', 'SWIVELUSB16GB', '0'),
('MOB', 'SWIVELUSB32GB', '0'),
('MOB', 'SWIVELUSB8GB', '0'),
('MOB', 'Symantec-Lic', '0'),
('MOB', 'Table', '0'),
('MOB', 'table1', '0'),
('MOB', 'tb2', '0'),
('MOB', 'Threeyearoneuser', '0'),
('MOB', 'Training', '0'),
('MOB', 'VAT', '0'),
('MOB', 'W/H', '0'),
('MOB', 'Water', '0'),
('MOB', 'WIRELES', '0'),
('N P', '0006', '0'),
('N P', '001', '0'),
('N P', '002', '0'),
('N P', '003', '0'),
('N P', '004', '0'),
('N P', '005', '0'),
('N P', '006', '0'),
('N P', '10001', '0'),
('N P', '10002', '0'),
('N P', '16GB2.0', '0'),
('N P', '16GBOTG', '0'),
('N P', '2001', '0'),
('N P', '2002', '0'),
('N P', '2003', '0'),
('N P', '2GB2.0', '0'),
('N P', '32GB2.0', '0'),
('N P', '32GB3.0', '0'),
('N P', '32GBOTG', '0'),
('N P', '32GBSD', '0'),
('N P', '4GB2.0', '0'),
('N P', '8GB2.0', '0'),
('N P', '8GBSD', '0'),
('N P', 'ACCSERVICE', '0'),
('N P', 'ACCSOFT', '0'),
('N P', 'AP3615', '0'),
('N P', 'B100', '0'),
('N P', 'BW08', '0'),
('N P', 'CASHDRAWER', '0'),
('N P', 'CDs', '0'),
('N P', 'CPU', '0'),
('N P', 'Datashur', '0'),
('N P', 'EMSI', '0'),
('N P', 'emsi-enterprice', '0'),
('N P', 'emsi-server', '0'),
('N P', 'EMSI2N1', '0'),
('N P', 'EMSI2N13U3Y', '0'),
('N P', 'EMSI3User', '0'),
('N P', 'EMSIPENDRIVE', '0'),
('N P', 'EMSIPouch', '0'),
('N P', 'EMSISOfT', '0'),
('N P', 'EMSISoft-Box', '0'),
('N P', 'EMSISoft-Disk', '0'),
('N P', 'Export', '0'),
('N P', 'Export01', '0'),
('N P', 'Export02', '0'),
('N P', 'Export03', '0'),
('N P', 'Export04', '0'),
('N P', 'F-Se3User', '0'),
('N P', 'FCCW', '0'),
('N P', 'FCE-MO', '0'),
('N P', 'FCE-PC', '0'),
('N P', 'FCSW', '0'),
('N P', 'Freedome', '0'),
('N P', 'FSe3year', '0'),
('N P', 'FSebox', '0'),
('N P', 'FSePouch', '0'),
('N P', 'FW', '0'),
('N P', 'IN01', '0'),
('N P', 'IS-DA2-256-1000B', '0'),
('N P', 'Keys', '0'),
('N P', 'LicenseKe', '0'),
('N P', 'LicenseKey', '0'),
('N P', 'LicenseKey-', '0'),
('N P', 'Licenskey', '0'),
('N P', 'LPPCEMSOFTSWFSFWER', '0'),
('N P', 'LPPCPGEMISSOFT', '0'),
('N P', 'LPPCPGENDPSECU', '0'),
('N P', 'LPPCPGFSAV1SBCO', '0'),
('N P', 'LPPCPGFSAV1SU17CON', '0'),
('N P', 'LPPCPGFSAV3', '0'),
('N P', 'LPPCPGFSAVTPGCON', '0'),
('N P', 'LPPCPGFSINVGCON', '0'),
('N P', 'LPPCPGVG1U3Y', '0'),
('N P', 'LPPVIRUSEMSI', '0'),
('N P', 'Magneticable', '0'),
('N P', 'Maintenence', '0'),
('N P', 'ManagedServices', '0'),
('N P', 'MH-001', '0'),
('N P', 'MicroSD16GB', '0'),
('N P', 'Mobile', '0'),
('N P', 'NBT', '0'),
('N P', 'OH', '0'),
('N P', 'oneyear', '0'),
('N P', 'P/C', '0'),
('N P', 'Pouch', '0'),
('N P', 'RtnCheque', '0'),
('N P', 'S/P', '0'),
('N P', 'Sec-Key', '0'),
('N P', 'SKY-RE', '0'),
('N P', 'SOPHOS', '0'),
('N P', 'SOPHOS.', '0'),
('N P', 'SRP-275III', '0'),
('N P', 'SWIVELUSB16GB', '0'),
('N P', 'SWIVELUSB32GB', '0'),
('N P', 'SWIVELUSB8GB', '0'),
('N P', 'Symantec-Lic', '0'),
('N P', 'Table', '0'),
('N P', 'table1', '0'),
('N P', 'tb2', '0'),
('N P', 'Threeyearoneuser', '0'),
('N P', 'Training', '0'),
('N P', 'VAT', '0'),
('N P', 'W/H', '0'),
('N P', 'Water', '0'),
('N P', 'WIRELES', '0'),
('WATT', '0006', '0'),
('WATT', '001', '0'),
('WATT', '002', '0'),
('WATT', '003', '0'),
('WATT', '004', '0'),
('WATT', '005', '0'),
('WATT', '006', '0'),
('WATT', '10001', '0'),
('WATT', '10002', '0'),
('WATT', '16GB2.0', '0'),
('WATT', '16GBOTG', '0'),
('WATT', '2001', '0'),
('WATT', '2002', '0'),
('WATT', '2003', '0'),
('WATT', '2GB2.0', '0'),
('WATT', '32GB2.0', '0'),
('WATT', '32GB3.0', '0'),
('WATT', '32GBOTG', '0'),
('WATT', '32GBSD', '0'),
('WATT', '4GB2.0', '0'),
('WATT', '8GB2.0', '0'),
('WATT', '8GBSD', '0'),
('WATT', 'ACCSERVICE', '0'),
('WATT', 'ACCSOFT', '0'),
('WATT', 'AP3615', '0'),
('WATT', 'B100', '0'),
('WATT', 'BW08', '0'),
('WATT', 'CASHDRAWER', '0'),
('WATT', 'CDs', '0'),
('WATT', 'CPU', '0'),
('WATT', 'Datashur', '0'),
('WATT', 'EMSI', '0'),
('WATT', 'emsi-enterprice', '0'),
('WATT', 'emsi-server', '0'),
('WATT', 'EMSI2N1', '0'),
('WATT', 'EMSI2N13U3Y', '0'),
('WATT', 'EMSI3User', '0'),
('WATT', 'EMSIPENDRIVE', '0'),
('WATT', 'EMSIPouch', '0'),
('WATT', 'EMSISOfT', '0'),
('WATT', 'EMSISoft-Box', '0'),
('WATT', 'EMSISoft-Disk', '0'),
('WATT', 'Export', '0'),
('WATT', 'Export01', '0'),
('WATT', 'Export02', '0'),
('WATT', 'Export03', '0'),
('WATT', 'Export04', '0'),
('WATT', 'F-Se3User', '0'),
('WATT', 'FCCW', '0'),
('WATT', 'FCE-MO', '0'),
('WATT', 'FCE-PC', '0'),
('WATT', 'FCSW', '0'),
('WATT', 'Freedome', '0'),
('WATT', 'FSe3year', '0'),
('WATT', 'FSebox', '0'),
('WATT', 'FSePouch', '0'),
('WATT', 'FW', '0'),
('WATT', 'IN01', '0'),
('WATT', 'IS-DA2-256-1000B', '0'),
('WATT', 'Keys', '0'),
('WATT', 'LicenseKe', '0'),
('WATT', 'LicenseKey', '0'),
('WATT', 'LicenseKey-', '0'),
('WATT', 'Licenskey', '0'),
('WATT', 'LPPCEMSOFTSWFSFWER', '0'),
('WATT', 'LPPCPGEMISSOFT', '0'),
('WATT', 'LPPCPGENDPSECU', '0'),
('WATT', 'LPPCPGFSAV1SBCO', '0'),
('WATT', 'LPPCPGFSAV1SU17CON', '0'),
('WATT', 'LPPCPGFSAV3', '0'),
('WATT', 'LPPCPGFSAVTPGCON', '0'),
('WATT', 'LPPCPGFSINVGCON', '0'),
('WATT', 'LPPCPGVG1U3Y', '0'),
('WATT', 'LPPVIRUSEMSI', '0'),
('WATT', 'Magneticable', '0'),
('WATT', 'Maintenence', '0'),
('WATT', 'ManagedServices', '0'),
('WATT', 'MH-001', '0'),
('WATT', 'MicroSD16GB', '0'),
('WATT', 'Mobile', '0'),
('WATT', 'NBT', '0'),
('WATT', 'OH', '0'),
('WATT', 'oneyear', '0'),
('WATT', 'P/C', '0'),
('WATT', 'Pouch', '0'),
('WATT', 'RtnCheque', '0'),
('WATT', 'S/P', '0'),
('WATT', 'Sec-Key', '0'),
('WATT', 'SKY-RE', '0'),
('WATT', 'SOPHOS', '0'),
('WATT', 'SOPHOS.', '0'),
('WATT', 'SRP-275III', '0'),
('WATT', 'SWIVELUSB16GB', '0'),
('WATT', 'SWIVELUSB32GB', '0'),
('WATT', 'SWIVELUSB8GB', '0'),
('WATT', 'Symantec-Lic', '0'),
('WATT', 'Table', '0'),
('WATT', 'table1', '0'),
('WATT', 'tb2', '0'),
('WATT', 'Threeyearoneuser', '0'),
('WATT', 'Training', '0'),
('WATT', 'VAT', '0'),
('WATT', 'W/H', '0'),
('WATT', 'Water', '0'),
('WATT', 'WIRELES', '0');

### Structure of table `0_locations` ###

DROP TABLE IF EXISTS `0_locations`;

CREATE TABLE `0_locations` (
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `location_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fax` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fixed_asset` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `main_loc_id` int(3) NOT NULL,
  PRIMARY KEY (`loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_locations` ###

INSERT INTO `0_locations` VALUES
('01', '2nd Floor', '', '', '', '', '', 'K.P.L.Pintoe', '1', '0', '0'),
('DEF', 'Default Lovcation', '', '', '', '', '', '', '0', '0', '0'),
('EV/S', 'Evolve Store', 'No 82,\nW A D Ramanayake Mawatha,\nColombo 02', '0115936944', '0115936936', '', 'inquiry@evolve-sl.com', 'Evolve', '0', '0', '0'),
('F01', 'Chanaka Location', 'No 293/8,\nUdupila,\nDelgoda', '0778247752', '0778247752', '', '', 'Chanaka Perera', '0', '0', '0'),
('F02', 'Dilruk- F-Secure', 'No 09,\nNew Lane,\nMillidduwa,\nGalle', '0711476919', '0711476919', '', '', 'Dilruk Ranasinghe', '0', '0', '0'),
('F03', 'Sinas - Rathnapura', '', '0779459124', '0779459124', '', '', 'Sinas', '0', '0', '0'),
('F04', 'Abans Stores ', '', '', '', '', '', '', '0', '0', '0'),
('F05', 'Nemindra Location', 'Rose Bank,\nDiyalagoda,\nMaggona', '', '', '', '', '', '0', '0', '0'),
('F06', 'Umasha - F Secure', 'No 82, W A D Ramanayake Mawatha, Colombo 02', '', '', '', '', 'Umasha', '0', '0', '0'),
('F07', 'Trinco', '', '', '', '', '', '', '0', '0', '0'),
('L01', 'location 001 - Mlabe ', '22, test address, malabe', '112908765', '', '', '', '077567896', '1', '0', '0'),
('MOB  ', 'Mobitel Stores', '', '', '', '', '', '', '0', '0', '0'),
('N P', 'Raw Material Stores', '', '', '', '', '', '', '0', '0', '0'),
('WATT', 'Wattala Store', 'Wattala,Sri Lanka', '0115936944', '0115936945', '', 'kplp@evolve-sl.com', '', '0', '0', '0');

### Structure of table `0_main_category` ###

DROP TABLE IF EXISTS `0_main_category`;

CREATE TABLE `0_main_category` (
  `main_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `main_cat_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL,
  PRIMARY KEY (`main_category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_main_category` ###


### Structure of table `0_main_locations` ###

DROP TABLE IF EXISTS `0_main_locations`;

CREATE TABLE `0_main_locations` (
  `main_loc_id` int(11) NOT NULL AUTO_INCREMENT,
  `main_loc_code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `main_loc_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `inactive` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`main_loc_id`),
  UNIQUE KEY `main_loc_code` (`main_loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_main_locations` ###


### Structure of table `0_payment_terms` ###

DROP TABLE IF EXISTS `0_payment_terms`;

CREATE TABLE `0_payment_terms` (
  `terms_indicator` int(11) NOT NULL AUTO_INCREMENT,
  `terms` char(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `days_before_due` smallint(6) NOT NULL DEFAULT '0',
  `day_in_following_month` smallint(6) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`terms_indicator`),
  UNIQUE KEY `terms` (`terms`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payment_terms` ###

INSERT INTO `0_payment_terms` VALUES
('1', 'One Month Credit', '31', '0', '0'),
('2', '14 Days Credit', '14', '0', '0'),
('3', 'Cash/Cheque', '1', '0', '0'),
('4', 'Consignment basis', '1', '0', '0');

### Structure of table `0_payroll_pay_type` ###

DROP TABLE IF EXISTS `0_payroll_pay_type`;

CREATE TABLE `0_payroll_pay_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `taxable` int(11) NOT NULL,
  `cmethod` int(11) NOT NULL,
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `default_rate` float DEFAULT NULL,
  `required` int(11) NOT NULL,
  `automatic` int(11) NOT NULL,
  `inactive` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payroll_pay_type` ###


### Structure of table `0_payroll_pay_types` ###

DROP TABLE IF EXISTS `0_payroll_pay_types`;

CREATE TABLE `0_payroll_pay_types` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ;

### Data of table `0_payroll_pay_types` ###


### Structure of table `0_payroll_tax_rate` ###

DROP TABLE IF EXISTS `0_payroll_tax_rate`;

CREATE TABLE `0_payroll_tax_rate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tt_id` int(11) NOT NULL,
  `bracket` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `value_from` float DEFAULT NULL,
  `value_to` float DEFAULT NULL,
  `tax_amount` float DEFAULT NULL,
  `variable_from` float DEFAULT NULL,
  `fixed_tax_percent` float DEFAULT NULL,
  `variable` float DEFAULT NULL,
  `variable_tax_percent` float DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payroll_tax_rate` ###


### Structure of table `0_prices` ###

DROP TABLE IF EXISTS `0_prices`;

CREATE TABLE `0_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type_id` int(11) NOT NULL DEFAULT '0',
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `price` (`stock_id`,`sales_type_id`,`curr_abrev`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_prices` ###

INSERT INTO `0_prices` VALUES
('1', 'SWIVELUSB16GB', '1', 'LKR', '950'),
('2', 'SWIVELUSB32GB', '1', 'LKR', '1250'),
('3', 'SWIVELUSB8GB', '4', 'LKR', '0'),
('4', '32GB2.0', '1', 'LKR', '0');

### Structure of table `0_print_profiles` ###

DROP TABLE IF EXISTS `0_print_profiles`;

CREATE TABLE `0_print_profiles` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `report` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `printer` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile` (`profile`,`report`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_print_profiles` ###

INSERT INTO `0_print_profiles` VALUES
('1', 'Out of office', NULL, '0'),
('2', 'Sales Department', NULL, '0'),
('3', 'Central', NULL, '2'),
('4', 'Sales Department', '104', '2'),
('5', 'Sales Department', '105', '2'),
('6', 'Sales Department', '107', '2'),
('7', 'Sales Department', '109', '2'),
('8', 'Sales Department', '110', '2'),
('9', 'Sales Department', '201', '2');

### Structure of table `0_printers` ###

DROP TABLE IF EXISTS `0_printers`;

CREATE TABLE `0_printers` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `queue` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `host` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `port` smallint(11) unsigned NOT NULL,
  `timeout` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_printers` ###

INSERT INTO `0_printers` VALUES
('1', 'QL500', 'Label printer', 'QL500', 'server', '127', '20'),
('2', 'Samsung', 'Main network printer', 'scx4521F', 'server', '515', '5'),
('3', 'Local', 'Local print server at user IP', 'lp', '', '515', '10');

### Structure of table `0_products_collections` ###

DROP TABLE IF EXISTS `0_products_collections`;

CREATE TABLE `0_products_collections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pc_code` varchar(4) COLLATE utf8_unicode_ci NOT NULL,
  `pc_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `inactive` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pc_code` (`pc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_products_collections` ###


### Structure of table `0_purch_data` ###

DROP TABLE IF EXISTS `0_purch_data`;

CREATE TABLE `0_purch_data` (
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT '0',
  `suppliers_uom` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `conversion_factor` double NOT NULL DEFAULT '1',
  `supplier_description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`supplier_id`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_data` ###


### Structure of table `0_purch_order_details` ###

DROP TABLE IF EXISTS `0_purch_order_details`;

CREATE TABLE `0_purch_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT '0',
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `act_price` double NOT NULL DEFAULT '0',
  `std_cost_unit` double NOT NULL DEFAULT '0',
  `quantity_ordered` double NOT NULL DEFAULT '0',
  `quantity_received` double NOT NULL DEFAULT '0',
  `line_location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`),
  KEY `itemcode` (`item_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_order_details` ###


### Structure of table `0_purch_order_details_csv` ###

DROP TABLE IF EXISTS `0_purch_order_details_csv`;

CREATE TABLE `0_purch_order_details_csv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_ref` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `price` double(16,2) DEFAULT NULL,
  `order_date` date NOT NULL,
  `requeried_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_order_details_csv` ###


### Structure of table `0_purch_orders` ###

DROP TABLE IF EXISTS `0_purch_orders`;

CREATE TABLE `0_purch_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `comments` tinytext COLLATE utf8_unicode_ci,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `requisition_no` tinytext COLLATE utf8_unicode_ci,
  `into_stock_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `total` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_orders` ###


### Structure of table `0_quick_entries` ###

DROP TABLE IF EXISTS `0_quick_entries`;

CREATE TABLE `0_quick_entries` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `usage` varchar(120) COLLATE utf8_unicode_ci DEFAULT NULL,
  `base_amount` double NOT NULL DEFAULT '0',
  `base_desc` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bal_type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_entries` ###

INSERT INTO `0_quick_entries` VALUES
('1', '1', 'Employee Trust Fund', NULL, '0', 'Employee Trust Fund', '0'),
('2', '1', 'Sri Lanka Telecom PLC', 'Telephone Bil', '210', 'Telephone &amp; Internet', '0'),
('4', '1', 'Ceylon Electricity Board - 0296546321', 'Electricity Bill', '21350', 'Ceylon Electricity Board', '0'),
('6', '1', 'National Water Supply &amp; Draining Board', 'Water bill - September 2017', '5230', 'Water Bill', '0'),
('7', '1', 'Employees Provident Fund', NULL, '0', 'Employees Provident Fund', '0'),
('9', '1', 'Lanka Bell Limited', 'September bill', '0', 'Base Amount', '0'),
('11', '1', 'GENESIIS SOFTWARE PVT LTD', NULL, '0', 'Base Amount', '0'),
('14', '1', 'Digital Mobility Solutions Lanka (Pvt) Ltd', 'Pickme Payment', '9820', 'Pickme Payment', '0'),
('23', '3', 'Salaries control', 'Control A/C', '1', '5410', '1'),
('24', '3', 'Salary distribution', 'distribution', '1', '5410', '1'),
('25', '3', 'EPF  Control', NULL, '1', '2180', '1'),
('26', '3', 'ETF  Control', 'ETF Payable', '0', 'Base Amount', '0'),
('27', '1', 'Ceylon Electricity Board -0296396338', 'Electricity Charges', '100', 'Electricity Charges - ', '0'),
('28', '2', 'Direct deposit to bank', NULL, '1000', 'Sale of Antivirus', '0');

### Structure of table `0_quick_entry_lines` ###

DROP TABLE IF EXISTS `0_quick_entry_lines`;

CREATE TABLE `0_quick_entry_lines` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `qid` smallint(6) unsigned NOT NULL,
  `amount` double DEFAULT '0',
  `memo` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `dest_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` smallint(6) unsigned DEFAULT NULL,
  `dimension2_id` smallint(6) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_entry_lines` ###


### Structure of table `0_recurrent_invoices` ###

DROP TABLE IF EXISTS `0_recurrent_invoices`;

CREATE TABLE `0_recurrent_invoices` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order_no` int(11) unsigned NOT NULL,
  `debtor_no` int(11) unsigned DEFAULT NULL,
  `group_no` smallint(6) unsigned DEFAULT NULL,
  `days` int(11) NOT NULL DEFAULT '0',
  `monthly` int(11) NOT NULL DEFAULT '0',
  `begin` date NOT NULL DEFAULT '0000-00-00',
  `end` date NOT NULL DEFAULT '0000-00-00',
  `last_sent` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_recurrent_invoices` ###


### Structure of table `0_reflines` ###

DROP TABLE IF EXISTS `0_reflines`;

CREATE TABLE `0_reflines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` int(11) NOT NULL,
  `prefix` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pattern` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `prefix` (`trans_type`,`prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_reflines` ###

INSERT INTO `0_reflines` VALUES
('1', '0', '', '00001', '', '1', '0'),
('2', '1', '', '00001', '', '1', '0'),
('3', '2', '', '00001', '', '1', '0'),
('4', '4', '', '00001', '', '1', '0'),
('5', '10', '', '00001', '', '1', '0'),
('6', '11', '', '00001', '', '1', '0'),
('7', '12', '', '00001', '', '1', '0'),
('8', '13', '', '00001', '', '1', '0'),
('9', '16', '', '00001', '', '1', '0'),
('10', '17', '', '00001', '', '1', '0'),
('11', '18', '', '00001', '', '1', '0'),
('12', '20', '', '00001', '', '1', '0'),
('13', '21', '', '00001', '', '1', '0'),
('14', '22', '', '00001', '', '1', '0'),
('15', '25', '', '00001', '', '1', '0'),
('16', '26', '', '00001', '', '1', '0'),
('17', '28', '', '00001', '', '1', '0'),
('18', '29', '', '00001', '', '1', '0'),
('19', '30', '', '00001', '', '1', '0'),
('20', '32', '', '00001', '', '1', '0'),
('21', '35', '', '00001', '', '1', '0'),
('22', '40', '', '00001', '', '1', '0'),
('23', '50', '', '00001', '', '1', '0');

### Structure of table `0_refs` ###

DROP TABLE IF EXISTS `0_refs`;

CREATE TABLE `0_refs` (
  `id` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`type`),
  KEY `Type_and_Reference` (`type`,`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_refs` ###


### Structure of table `0_requisition_details` ###

DROP TABLE IF EXISTS `0_requisition_details`;

CREATE TABLE `0_requisition_details` (
  `requisition_detail_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `requisition_id` int(11) DEFAULT NULL,
  `item_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `lpo_id` int(11) DEFAULT '0',
  `order_quantity` int(11) NOT NULL DEFAULT '0',
  `estimate_price` double NOT NULL DEFAULT '0',
  `quantity` int(11) NOT NULL DEFAULT '0',
  `price` double NOT NULL DEFAULT '0',
  `purpose` varchar(320) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`requisition_detail_id`),
  UNIQUE KEY `requisition_detail_id` (`requisition_detail_id`),
  KEY `0_requisition_details_requisition_id` (`requisition_id`),
  KEY `0_requisition_details_item_code` (`item_code`),
  KEY `0_requisition_details_supplier_id` (`supplier_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_requisition_details` ###


### Structure of table `0_requisitions` ###

DROP TABLE IF EXISTS `0_requisitions`;

CREATE TABLE `0_requisitions` (
  `requisition_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `point_of_use` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `narrative` varchar(240) COLLATE utf8_unicode_ci DEFAULT NULL,
  `application_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `completed` tinyint(4) NOT NULL DEFAULT '0',
  `processed` tinyint(4) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`requisition_id`),
  UNIQUE KEY `requisition_id` (`requisition_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_requisitions` ###

INSERT INTO `0_requisitions` VALUES
('1', 'Purchasing', 'Sony', '2017-10-02 09:18:17', '0', '0', '0', NULL);

### Structure of table `0_sales_order_details` ###

DROP TABLE IF EXISTS `0_sales_order_details`;

CREATE TABLE `0_sales_order_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT '0',
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `stk_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `qty_sent` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `invoiced` double NOT NULL DEFAULT '0',
  `discount_percent` double NOT NULL DEFAULT '0',
  `done_by` int(2) DEFAULT NULL,
  `line_location` char(15) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sorder` (`trans_type`,`order_no`),
  KEY `stkcode` (`stk_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_order_details` ###


### Structure of table `0_sales_order_details_csv` ###

DROP TABLE IF EXISTS `0_sales_order_details_csv`;

CREATE TABLE `0_sales_order_details_csv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cust_ref` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `stock_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `price` double(16,2) DEFAULT NULL,
  `discount_precent` double DEFAULT NULL,
  `order_date` date DEFAULT NULL,
  `delivery_date` date DEFAULT NULL,
  `deliver_addres` tinytext COLLATE utf8_unicode_ci,
  `deliver_branch` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_order_details_csv` ###


### Structure of table `0_sales_orders` ###

DROP TABLE IF EXISTS `0_sales_orders`;

CREATE TABLE `0_sales_orders` (
  `order_no` int(11) NOT NULL,
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `version` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `branch_code` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `customer_ref` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `comments` tinytext COLLATE utf8_unicode_ci,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `order_type` int(11) NOT NULL DEFAULT '0',
  `ship_via` int(11) NOT NULL DEFAULT '0',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `contact_phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `deliver_to` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `freight_cost` double NOT NULL DEFAULT '0',
  `from_stk_loc` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `payment_terms` int(11) DEFAULT NULL,
  `total` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `done_by` int(2) DEFAULT NULL,
  PRIMARY KEY (`order_no`,`trans_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_orders` ###


### Structure of table `0_sales_pos` ###

DROP TABLE IF EXISTS `0_sales_pos`;

CREATE TABLE `0_sales_pos` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `pos_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `cash_sale` tinyint(1) NOT NULL,
  `credit_sale` tinyint(1) NOT NULL,
  `pos_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `pos_account` smallint(6) unsigned NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `pos_name` (`pos_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_pos` ###

INSERT INTO `0_sales_pos` VALUES
('1', 'Default', '1', '1', 'DEF', '2', '0');

### Structure of table `0_sales_types` ###

DROP TABLE IF EXISTS `0_sales_types`;

CREATE TABLE `0_sales_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_type` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_included` int(1) NOT NULL DEFAULT '0',
  `factor` double NOT NULL DEFAULT '1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_type` (`sales_type`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_types` ###

INSERT INTO `0_sales_types` VALUES
('1', 'Retail', '1', '1', '0'),
('2', 'Wholesale', '0', '0.7', '0'),
('3', 'F-Secure', '0', '1', '0'),
('4', 'Exports', '0', '1', '0');

### Structure of table `0_salesman` ###

DROP TABLE IF EXISTS `0_salesman`;

CREATE TABLE `0_salesman` (
  `salesman_code` int(11) NOT NULL AUTO_INCREMENT,
  `salesman_name` char(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_phone` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_fax` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `provision` double NOT NULL DEFAULT '0',
  `break_pt` double NOT NULL DEFAULT '0',
  `provision2` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`salesman_code`),
  UNIQUE KEY `salesman_name` (`salesman_name`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_salesman` ###

INSERT INTO `0_salesman` VALUES
('1', 'Nishantha', '0777329723', ' 7392830', 'nishantha@evolve-sl.com', '0', '0', '0', '0'),
('2', 'Chanaka', '0778247752', '7392830', 'chanaka@evolve-sl.com', '0', '0', '0', '0'),
('3', 'Royston', '0714942025', '7392830', 'royston@evolve-sl.com', '0', '0', '0', '1'),
('4', 'Lal', '', '', 'kplp@evolve-sl.com', '0', '0', '0', '0'),
('5', 'Dilruk', '0770265165', '7392830', 'dilruk@evolve-sl.com', '0', '0', '0', '0'),
('6', 'Asela Priyadharshana', '', '', 'asela@evolve-sl.com', '10', '0', '5', '1'),
('7', 'chaminda', '', '', 'chaminda@evolve-sl.com', '0', '0', '0', '1'),
('8', 'Umasha', '0773382828', '0115936947', 'umasha@evolve-sl.com', '0', '0', '0', '0'),
('9', 'Dishan', '0770552389', '0115936947', 'dishan@evolve-sl.com', '0', '0', '0', '1'),
('10', 'Asanka', '0714409379', '0115936947', 'asanka@evolve-sl.com', '0', '0', '0', '0'),
('11', 'Eliyas', '0774373838', '0115936947', 'eliyas@evolve-sl.com', '0', '0', '0', '0'),
('12', 'Ashan', '', '', '', '0', '0', '0', '0'),
('13', 'Health-Dil', '', '', '', '0', '0', '0', '1'),
('14', 'Health-Prim', '', '', '', '0', '0', '0', '1'),
('15', 'Chamaka', '0775373838', '0115936947', 'chamaka@evolve-sl.com', '0', '0', '0', '0'),
('16', 'Sinas', '0779453124', '0115936947', '', '0', '0', '0', '0'),
('17', 'Dilshan', '0715942581', '0115936947', 'dilshan@evolve-sl.com', '0', '0', '0', '0'),
('18', 'Harsha', '0766885449', '0115936947', 'harsha@evolve-sl.com', '0', '0', '0', '0'),
('19', 'Suneth', '', '', 'suneth@evolvejapan.com', '0', '0', '0', '0'),
('20', 'Mithshana', '0766885449', '0115936947', 'mithshana@evolve-sl.com', '0', '0', '0', '0'),
('21', 'Angelo', '0768085252', '', 'angelo@evolve-sl.com', '0', '0', '0', '0'),
('22', 'Nemindra', '', '', '', '0', '0', '0', '0'),
('23', 'Ijas', '', '', '', '0', '0', '0', '0'),
('24', 'Roshan', '0779648485', '', '', '0', '0', '0', '0'),
('25', 'Chalith', '', '', 'chalith@evolve-sl.com', '0', '0', '0', '0'),
('26', 'Zakin', '0777335750', '', 'zakin@evolve-sl.com', '0', '0', '0', '0'),
('27', 'Kosala', '', '', '', '0', '0', '0', '0');

### Structure of table `0_security_roles` ###

DROP TABLE IF EXISTS `0_security_roles`;

CREATE TABLE `0_security_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sections` text COLLATE utf8_unicode_ci,
  `areas` text COLLATE utf8_unicode_ci,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `role` (`role`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_security_roles` ###

INSERT INTO `0_security_roles` VALUES
('1', 'Inquiries', 'Inquiries', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128;9216;9216;9216;9472;9472;9472;9472;9728', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;773;774;775;2822;3073;3075;3076;3077;3329;3330;3331;3332;3333;3334;3335;5377;5633;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15873;15882;16129;16130;16131;16132', '0'),
('2', 'System Administrator', 'System Administrator', '256;512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;9216;9472;9728;10496;10752;11008;13056;13312;15616;15872;16128;549888;615424;1008640;1074176;1336320;1795072', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;775;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15629;15632;15873;15874;15875;15876;15885;15877;15886;15878;15887;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;549988;549989;549990;615524;615525;1008740;1074276;1336420;1795172', '0'),
('3', 'Salesman', 'Salesman', '768;3072;5632;8192;15872;9216;9216;9216;9472;9472;9472;9472;9728', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;526;773;774;775;2817;2818;2819;2820;2821;2822;2823;3073;3075;3082;3329;3330;3331;3332;3333;3334;3335;5377;5633;5889;5890;5891;7937;7938;7939;7940;8194;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15627;15628;15629;15873;16129;16130;16131;16132;549988;549989;549990;615524;615525;812132;1008740;1074276', '0'),
('4', 'Stock Manager', 'Stock Manager', '2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128;768', '775', '0'),
('5', 'Production Manager', 'Production Manager', '512;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128;768', '775', '0'),
('6', 'Purchase Officer', 'Purchase Officer', '512;5376;5632;5888;8192;8448;10752;11008;13312;768', '775', '0'),
('7', 'AR Officer', 'AR Officer', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;771;773;774;2818;2819;2820;2821;2822;2823;3073;3073;3074;3075;3076;3077;3078;3079;3080;3081;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5633;5634;5637;5638;5639;5640;5640;5889;5890;5891;8193;8194;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0'),
('8', 'AP Officer', 'AP Officer', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;10496;10752;11008;13056;13312;15616;15872;16128;549888;615424', '257;258;259;260;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;7941;7942;7943;8193;8194;8195;8196;8197;8449;8450;8451;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15629;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;549988;549989;549990;615524;615525;812132;1008740;1074276;775', '0'),
('9', 'Accountant', 'New Accountant', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;9216;9472;9728;10496;10752;11008;13056;13312;15616;15872;16128;549888;615424', '513;516;517;518;519;520;521;522;523;524;525;526;769;771;772;773;774;775;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15629;15632;15873;15874;15875;15876;15885;15877;15886;15878;15887;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;549988;549989;549990;615524;615525;257;258;259;260;812132;1008740', '0'),
('10', 'Sub Admin', 'Sub Admin', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;10496;10752;11008;13056;13312;15616;15872;16128;549888;615424;812032;1008640;1074176', '257;258;259;260;519;520;521;522;523;524;525;526;769;770;771;772;773;774;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;7941;7942;7943;8193;8194;8195;8196;8197;8449;8450;8451;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15629;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;549988;549989;549990;615524;615525;812132;1008740;1074276;775', '0');

### Structure of table `0_shippers` ###

DROP TABLE IF EXISTS `0_shippers`;

CREATE TABLE `0_shippers` (
  `shipper_id` int(11) NOT NULL AUTO_INCREMENT,
  `shipper_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`shipper_id`),
  UNIQUE KEY `name` (`shipper_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_shippers` ###

INSERT INTO `0_shippers` VALUES
('1', 'Default', '', '', '', '', '0');

### Structure of table `0_sizes` ###

DROP TABLE IF EXISTS `0_sizes`;

CREATE TABLE `0_sizes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `size_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `size_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `inactive` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sizes` ###


### Structure of table `0_sql_trail` ###

DROP TABLE IF EXISTS `0_sql_trail`;

CREATE TABLE `0_sql_trail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sql` text COLLATE utf8_unicode_ci NOT NULL,
  `result` tinyint(1) NOT NULL,
  `msg` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sql_trail` ###


### Structure of table `0_stock_category` ###

DROP TABLE IF EXISTS `0_stock_category`;

CREATE TABLE `0_stock_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_tax_type` int(11) NOT NULL DEFAULT '1',
  `dflt_units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `dflt_mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `dflt_sales_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_cogs_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_inventory_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_adjustment_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_wip_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_dim1` int(11) DEFAULT NULL,
  `dflt_dim2` int(11) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `dflt_no_sale` tinyint(1) NOT NULL DEFAULT '0',
  `dflt_no_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `done_by` int(2) DEFAULT NULL,
  `main_category_id` int(11) NOT NULL,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_category` ###

INSERT INTO `0_stock_category` VALUES
('1', 'Services', '2', 'ea.', 'D', '4020', '5040', '0150', '0150', '0150', '0', '0', '0', '0', '0', NULL, '0'),
('2', 'Computers', '2', 'ea.', 'D', '4060', '5020', '1510', '5040', '1530', '0', '0', '0', '0', '0', NULL, '0'),
('3', 'Annual Maintenence', '2', 'ea.', 'D', '4020', '5040', '1510', '5040', '1530', '0', '0', '0', '0', '0', NULL, '0'),
('6', 'Evolve Software', '2', 'ea.', 'M', '4015', '5030', '1510', '5030', '1530', '0', '0', '0', '1', '1', NULL, '0'),
('7', 'F-Secure -  Licenses', '1', ' Licenses', 'B', '4060', '5035', '1510', '5035', '1530', '0', '0', '0', '0', '0', NULL, '0'),
('8', 'Mobile Security Cards', '1', 'ea.', 'B', '4060', '5035', '1510', '5035', '1530', '0', '0', '0', '0', '0', NULL, '0'),
('9', 'Packed for Sales', '1', 'ea.', 'M', '4060', '5035', '1510', '1510', '1540', '0', '0', '0', '0', '0', NULL, '0'),
('10', 'Mobitel Services', '1', ' Licenses', 'D', '4060', '5035', '1510', '5040', '1530', '0', '0', '0', '0', '0', NULL, '0'),
('11', 'F-Secure -  Corporate Licenses', '5', ' Licenses', 'B', '4060', '5035', '1510', '5040', '1530', '0', '0', '0', '0', '0', NULL, '0'),
('12', 'Packed for Abans', '1', 'ea.', 'M', '4060', '5035', '1510', '5035', '1530', '0', '0', '0', '0', '0', NULL, '0'),
('13', 'Raw Materials', '1', 'ea.', 'B', '4060', '5035', '1510', '1510', '1530', '0', '0', '0', '0', '0', NULL, '0'),
('14', 'Furniture &amp; Fittings', '1', 'ea.', 'F', '4520', '1920', '1820', '4520', '1530', '0', '0', '0', '1', '1', NULL, '0'),
('15', 'plant catogory', '1', 'Nos', 'F', '4015', '1910', '1810', '4520', '1530', '0', '0', '0', '1', '0', NULL, '0'),
('16', 'Plant', '1', 'Box', 'F', '4010', '5030', '1510', '5040', '1530', '0', '0', '0', '1', '0', NULL, '0'),
('17', 'Chairs', '1', 'ea.', 'F', '4520', '1920', '1820', '4520', '1530', '0', '0', '0', '1', '0', NULL, '0'),
('18', 'Accpac Division', '3', 'ea.', 'D', '4030', '5030', '1510', '5040', '1530', '7', '0', '0', '0', '0', NULL, '0'),
('19', 'USB Flash Drive', '3', 'ea.', 'B', '4060', '5035', '1510', '5035', '1530', '2', '0', '0', '0', '0', NULL, '0'),
('20', 'SD Cards', '3', 'ea.', 'B', '4060', '5035', '1510', '5035', '1530', '0', '0', '0', '0', '0', NULL, '0'),
('21', 'OTG', '3', 'ea.', 'B', '4060', '5035', '1510', '5035', '1530', '18', '0', '0', '0', '0', NULL, '0');

### Structure of table `0_stock_fa_class` ###

DROP TABLE IF EXISTS `0_stock_fa_class`;

CREATE TABLE `0_stock_fa_class` (
  `fa_class_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `long_description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `depreciation_rate` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fa_class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_fa_class` ###

INSERT INTO `0_stock_fa_class` VALUES
('', '', '', '', '0', '0'),
('002', '001', 'plant class ', 'test plant class ', '10', '0'),
('05', '01', 'Furniture &amp; Fittings', '', '10', '0'),
('OE', 'OE', 'Office Equipment', '', '10', '0');

### Structure of table `0_stock_master` ###

DROP TABLE IF EXISTS `0_stock_master`;

CREATE TABLE `0_stock_master` (
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `long_description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cogs_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inventory_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `adjustment_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `wip_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` int(11) DEFAULT NULL,
  `dimension2_id` int(11) DEFAULT NULL,
  `purchase_cost` double NOT NULL DEFAULT '0',
  `material_cost` double NOT NULL DEFAULT '0',
  `labour_cost` double NOT NULL DEFAULT '0',
  `overhead_cost` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `no_sale` tinyint(1) NOT NULL DEFAULT '0',
  `no_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `editable` tinyint(1) NOT NULL DEFAULT '0',
  `depreciation_method` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'S',
  `depreciation_rate` double NOT NULL DEFAULT '0',
  `depreciation_factor` double NOT NULL DEFAULT '0',
  `depreciation_start` date NOT NULL DEFAULT '0000-00-00',
  `depreciation_date` date NOT NULL DEFAULT '0000-00-00',
  `fa_class_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `crm_code` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `done_by` int(2) DEFAULT NULL,
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_master` ###

INSERT INTO `0_stock_master` VALUES
('0006', '1', '2', 'Registration of  Domain name  and Webhosting charges', '', 'ea.', 'D', '4030', '5040', '0150', '0150', '0150', '5', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('001', '6', '2', 'Installation &amp; Configuration Chargers', 'HRM Software', 'ea.', 'D', '4015', '5030', '1510', '5030', '1530', '5', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('002', '6', '2', 'Evolve 360 ERP solution', 'Evolve 360', 'ea.', 'D', '4015', '5030', '1510', '5030', '1530', '5', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('003', '6', '2', 'Evolve HRM Installation', 'Evolve HRM', 'ea.', 'D', '4015', '5030', '1510', '5030', '1530', '5', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('004', '6', '2', 'Evolve Student Management System', 'Evolve SMS', 'ea.', 'D', '4015', '5030', '1510', '5030', '1530', '5', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('005', '6', '2', 'License Fees', 'License Fees', 'ea.', 'D', '4015', '5030', '1510', '5030', '1530', '5', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('006', '6', '2', 'Local Software Development ', 'Evolve Local Software', 'ea.', 'D', '4015', '5030', '1510', '5030', '1530', '5', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('10001', '17', '1', 'Chairs', '', 'ea.', 'F', '4520', '1920', '1820', '4520', '1530', '0', '0', '520', '520', '0', '0', '0', '1', '0', '0', 'D', '10', '0', '2017-10-10', '2017-10-10', '05', NULL, NULL),
('10002', '17', '1', 'Chairs', '', 'ea.', 'F', '4520', '1920', '1820', '4520', '1530', '0', '0', '520', '520', '0', '0', '0', '1', '0', '0', 'D', '10', '0', '2017-10-10', '2017-10-10', '05', NULL, NULL),
('16GB2.0', '19', '3', '16GB 2.0 Flash Drive', '', 'ea.', 'B', '4065', '5036', '1510', '5036', '1530', '14', '0', '535', '536.90909090909', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('16GBOTG', '21', '3', '16 GB OTG', '16 GB OTG', 'ea.', 'B', '4065', '5036', '1510', '5036', '1530', '14', '0', '548', '548', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('2001', '14', '1', 'Table', '', 'ea.', 'F', '4520', '1920', '1820', '4520', '1530', '0', '0', '500', '500', '0', '0', '0', '1', '0', '0', 'D', '10', '1', '2017-10-12', '2017-10-12', '05', NULL, NULL),
('2002', '14', '1', 'Table', '', 'ea.', 'F', '4520', '1920', '1820', '4520', '1530', '0', '0', '500', '500', '0', '0', '0', '1', '0', '0', 'D', '10', '1', '2017-10-12', '2017-10-12', '05', NULL, NULL),
('2003', '14', '1', 'Table', '', 'ea.', 'F', '4520', '1920', '1820', '4520', '1530', '0', '0', '430', '430', '0', '0', '0', '1', '0', '0', 'D', '10', '1', '2017-10-12', '2017-10-12', '05', NULL, NULL),
('2GB2.0', '19', '3', '2 GB 2.0 USB Flash Drive', '2 GB 2.0 USB Flash Drive', 'ea.', 'B', '4065', '5036', '1510', '5036', '1530', '16', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('32GB2.0', '19', '3', '32GB 2.0 Flash Drive', '', 'ea.', 'B', '4065', '5036', '1510', '5036', '1530', '14', '0', '621', '626.94699646643', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('32GB3.0', '19', '3', 'USB 32GB 3.2 Flash Drive', 'USB 32GB 3.2 Flash Drive', 'ea.', 'B', '4065', '5036', '1510', '5036', '1530', '14', '0', '764', '764', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('32GBOTG', '21', '3', '32 GB OTG', '32 GB OTG', 'ea.', 'B', '4065', '5036', '1510', '5036', '1530', '14', '0', '640', '640', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('32GBSD', '20', '3', '32 GB Micro SD Card', '32 GB SD Card', 'ea.', 'B', '4065', '5036', '1510', '5036', '1530', '14', '0', '750', '750', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('4GB2.0', '19', '3', '4 GB 2.0  Flash Drive', '4 GB 2.0 USB Flash Drive', 'ea.', 'B', '4065', '5036', '1510', '5036', '1530', '14', '0', '432', '445.45454545455', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('8GB2.0', '19', '3', '8GB 2.0 Flash Drive', '', 'ea.', 'B', '4065', '5036', '1510', '5036', '1530', '14', '0', '493', '498.9509202454', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('8GBSD', '20', '3', '8 GB Micro SD Card', '8 GB Micro SD Card', 'ea.', 'B', '4065', '5036', '1510', '5036', '1530', '14', '0', '502', '502.540983607', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('ACCSERVICE', '18', '3', 'Accpac Software support service', '', 'ea.', 'D', '4030', '5030', '1510', '5040', '1530', '3', '0', '100', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('ACCSOFT', '18', '3', 'Accpac Software Development &amp; Implimentation Charges', '', 'ea.', 'D', '4030', '5030', '1510', '5040', '1530', '3', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('AP3615', '2', '3', 'HDD All in One Touch Terminal ', 'HDD All in One Touch Terminal ', 'ea.', 'B', '4015', '5020', '1510', '5030', '1530', '5', '0', '189750', '189750', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('B100', '2', '3', 'Mouse', '', 'ea.', 'B', '4060', '5020', '1510', '5040', '1530', '2', '0', '248', '248', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('BW08', '2', '3', 'Keyboard', '', 'ea.', 'B', '4065', '5036', '1510', '5036', '1530', '16', '0', '482', '482', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('CASHDRAWER', '2', '2', 'Cash Drawer', '', 'ea.', 'D', '4030', '5030', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('CDs', '13', '1', 'Compack Disk', '', 'ea.', 'B', '4060', '5035', '1520', '1520', '1530', '0', '0', '38.53', '39.1472228629', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('CPU', '2', '3', 'INTEL-CPU-CORE i5', '', 'ea.', 'D', '4075', '5040', '1510', '5040', '1530', '12', '0', '96000', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Datashur', '2', '1', 'Datashur Flash Drive', 'Datashur Flash Drive-16GB', 'ea.', 'M', '4065', '5036', '1510', '5036', '1510', '16', '0', '120.01', '120.01', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('EMSI', '9', '1', 'EMSI Soft Client Security 1 User 1 Year', 'EMSI Soft Client Security 1 User 1 Year', 'ea.', 'M', '4060', '5035', '1510', '1510', '1540', '14', '0', '2000', '361.046677947', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('emsi-enterprice', '9', '1', 'EMSI SOFT Enterprice Security', '', 'ea.', 'M', '4060', '5035', '1510', '1510', '1540', '14', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('emsi-server', '9', '3', 'EMSI SOFT Server Licence Keys', '', 'ea.', 'M', '4060', '5035', '1510', '1510', '1540', '14', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('EMSI2N1', '9', '1', 'EMSI Soft Client Security 2 In 1 -1 User 1 Year', 'EMSI Soft Client Security 2 In 1 -1 User 1 Year', 'ea.', 'M', '4060', '5035', '1510', '1510', '1540', '14', '0', '424.1', '424.1', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('EMSI2N13U3Y', '9', '1', 'EMSI Soft 2 In 1 3 User 3 Years', 'EMSI Soft 2 In 1 3 User 3 Years', 'ea.', 'B', '4060', '5035', '1510', '1510', '1540', '14', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('EMSI3User', '9', '1', 'EMSI Soft 3 User 1 Year', 'EMSI Soft 3 User 1 Year', 'ea.', 'B', '4060', '5035', '1510', '1510', '1530', '14', '0', '889', '589', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('EMSIPENDRIVE', '13', '1', 'EMSISOFT  Pendrives', '', 'ea.', 'B', '4060', '5035', '1520', '1520', '1530', '0', '0', '484', '484', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('EMSIPouch', '9', '1', 'EMSI 1 User 1 Year Pouch', 'EMSI 1 User 1 Year Pouch', 'ea.', 'B', '4060', '5035', '1510', '1510', '1530', '14', '0', '42', '148.221614544', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('EMSISOfT', '9', '1', 'EMSI SOFT 1 User 1 Year License Key Only', '', 'ea.', 'M', '4060', '5035', '1510', '1510', '1540', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('EMSISoft-Box', '13', '3', 'EMSI Soft Boxes', 'EMSI Soft Boxes', 'ea.', 'B', '4060', '5035', '1510', '1510', '1530', '14', '0', '72', '67.680763667124', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('EMSISoft-Disk', '13', '3', 'EMSI Soft Disk', 'EMSI Soft Disk', 'ea.', 'B', '4060', '5035', '1510', '1510', '1530', '14', '0', '40.5', '36.489446935827', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Export', '1', '3', 'Export of IT Support -Inbay', 'Provide IT support services to customers of Inbay Limited in UK from Sri Lanka for the month.', 'ea.', 'D', '4040', '5040', '0150', '0150', '0150', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Export01', '1', '3', 'Export of Software Development BPO', 'Providing Software Development Services to Australia.', 'ea.', 'D', '4045', '5020', '0150', '0150', '0150', '12', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Export02', '1', '3', 'Export - Call Centre Services', 'Providing call center services for International customers of Euro Icon (Pvt)Ltd.', 'ea.', 'D', '4050', '5040', '0150', '0150', '0150', '15', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Export03', '1', '3', 'Export of Software - One IT', 'Development and Export of software ', 'ea.', 'D', '4045', '5020', '0150', '0150', '0150', '4', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Export04', '1', '3', 'Export of Bookkeeping services for the month', 'Outsourced bookkeeping work for clients in Australia', 'ea.', 'D', '4015', '5040', '0150', '0150', '0150', '12', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('F-Se3User', '9', '1', 'F-Secure Internet Security 3 User License for 01 Year in a Pouch', 'F-Secure Internet Security 3 User License for 01 Year', 'ea.', 'M', '4060', '5035', '1510', '1510', '1540', '14', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('FCCW', '11', '1', 'F-Secure Client Security for Corporate P/C', 'F-Secure Client Security for Corporate P/C for One year', 'Box', 'B', '4060', '5035', '1510', '5035', '1530', '14', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('FCE-MO', '10', '5', 'F-Secure Active Mobile  licenses to Mobitel customers', 'Active Mobile licenses to be invoiced for the month', ' Licenses', 'B', '4060', '5035', '1510', '5035', '1530', '14', '20', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('FCE-PC', '10', '5', 'F-Secure Active PC  licenses to Mobitel customers', 'Active PC licenses to be invoiced for the month', ' Licenses', 'B', '4060', '5035', '1510', '5035', '1530', '14', '20', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('FCSW', '11', '5', 'F-Seure Corporate Security Server License', 'F-Seure Corporate Security Server License ', 'Box', 'B', '4060', '5035', '1510', '5035', '1530', '14', '0', '297.3', '297.3', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Freedome', '9', '1', 'F-Secure Safe  1  User License for 01 Year in a Box', 'F-Secure Safe', 'Box', 'M', '4060', '5035', '1510', '1510', '1540', '14', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('FSe3year', '9', '1', 'F-secure Client Security 1 User 3 Year in a Pouch', '', 'ea.', 'M', '4060', '5035', '1510', '1510', '1540', '14', '0', '0', '446.324', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('FSebox', '9', '1', 'F-Secure Client Security 1 User 1 Year in a box', 'F-Secure 1 User 1 Year Boxes', 'Box', 'M', '4060', '5035', '1510', '1510', '1540', '14', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('FSePouch', '9', '1', 'F-Secure Client Security 1 User 1 Year in a Pouch', 'F-Secure 1 User 1 Year Pouch', 'ea.', 'M', '4060', '5035', '1510', '1510', '1540', '14', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('FW', '1', '5', 'Firewall Services', '', 'ea.', 'D', '4060', '5030', '0150', '0150', '0150', '5', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('IN01', '2', '2', 'Finger Scanner Machine', '', 'ea.', 'D', '4060', '5020', '1510', '5040', '1530', '0', '0', '37500', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('IS-DA2-256-1000B', '2', '1', 'DiskAshur2 256-bit 1TB - Black', 'DiskAshur2 256-bit 1TB - Black', 'ea.', 'M', '4065', '5036', '1510', '1510', '1540', '16', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Keys', '9', '1', 'Emsisoft 3 user 1 year license key only ', 'Emsisoft 3 user 1 year license key only ', 'ea.', 'B', '4060', '5035', '1510', '1510', '1540', '14', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('LicenseKe', '9', '1', 'Emsisoft 10 user 1 year license key only ', '', 'ea.', 'M', '4060', '5035', '1510', '1510', '1540', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('LicenseKey', '9', '1', 'Emsisoft  license key only ', 'Emsisoft license key only ', 'ea.', 'M', '4060', '5035', '1510', '1510', '1540', '14', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('LicenseKey-', '9', '1', 'Emsisoft 5 user 1 year license key only ', 'Emsisoft 5 user 1 year license key only ', 'ea.', 'M', '4060', '5035', '1510', '1510', '1540', '14', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Licenskey', '9', '1', 'EMSISOFT BUSINESS SECURITY ANTIVIRUS SOLUTION', 'EMSISOFT BUSINESS SECURITY ANTIVIRUS SOLUTION', 'ea.', 'M', '4060', '5035', '1510', '1510', '1540', '14', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('LPPCEMSOFTSWFSFWER', '12', '1', 'EMSI-SOFTWARE', 'LPPCEMSOFTSWFSFWER', 'ea.', 'M', '4060', '5035', '1510', '5035', '1530', '14', '19', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('LPPCPGEMISSOFT', '12', '3', 'Emsi Soft Malware Software Ransoomware Production 03 Year', 'Emsi Soft Malware Software Ransoomware Production 03 Year', 'ea.', 'B', '4060', '5035', '1510', '5035', '1530', '14', '19', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('LPPCPGENDPSECU', '12', '1', 'F-Seure Client Security License for one year-	LPPCPGENDPSECU', '', 'ea.', 'B', '4060', '5035', '1510', '5035', '1530', '14', '19', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('LPPCPGFSAV1SBCO', '12', '5', 'F-Seure Client Security License for one year-LPPCPGFSAV1SBCO', '', 'ea.', 'M', '4060', '5035', '1510', '5035', '1530', '14', '19', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('LPPCPGFSAV1SU17CON', '12', '5', 'F-secure Virus Guard-	LPPCPGFSAV1SU17CON', '', 'ea.', 'M', '4060', '5035', '1510', '5035', '1530', '14', '19', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('LPPCPGFSAV3', '12', '1', 'F-secure Client Security 1 User 3 Years License- LPPCPGFSAV3', '', 'Box', 'B', '4060', '5035', '1510', '5035', '1530', '14', '19', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('LPPCPGFSAVTPGCON', '12', '1', 'F-Seure Client Security License for one year- LPPCPGFSAVTPGCON', '', 'Box', 'B', '4060', '5035', '1510', '5035', '1530', '14', '19', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('LPPCPGFSINVGCON', '12', '1', 'F-Seure Client Security License for one year-	LPPCPGFSINVGCON', '', 'Box', 'B', '4060', '5035', '1510', '5035', '1530', '14', '19', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('LPPCPGVG1U3Y', '12', '1', 'F-secure Client Security 1 User 3 Years License-LPPCPGVG1U3Y', 'F-secure Client Security 1 User 3 Years License-LPPCPGVG1U3Y', 'ea.', 'B', '4060', '5035', '1510', '5035', '1530', '14', '19', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('LPPVIRUSEMSI', '12', '1', 'EMSI SOFT-EMSI Virus Guard', 'EMSI SOFT-EMSI Virus Guard', 'ea.', 'M', '4060', '5035', '1510', '5035', '1530', '14', '19', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Magneticable', '19', '3', 'Magnetic Cable', '', 'ea.', 'B', '4065', '5036', '1510', '5036', '1530', '14', '0', '452', '452', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Maintenence', '1', '2', 'Annual Maintenence Fees', '', 'ea.', 'D', '4030', '5030', '0150', '0150', '0150', '3', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('ManagedServices', '1', '1', 'Managed IT Support Services  Local', 'Providing of IT support services', 'ea.', 'D', '4060', '5040', '0150', '0150', '0150', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('MH-001', '15', '1', 'Grinding Machine', 'test Machine ', 'Nos', 'F', '4015', '1910', '1810', '4520', '1530', '0', '0', '20000', '20000', '0', '0', '0', '1', '0', '0', 'D', '10', '0', '2017-09-01', '2017-09-01', '002', NULL, NULL),
('MicroSD16GB', '20', '3', 'Micro SD 16GB C10', 'Micro SD 16GB C10', 'ea.', 'B', '4065', '5036', '1510', '5036', '1530', '14', '0', '620', '620', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Mobile', '8', '1', 'Mobile Security Licenses for one year', 'Mobile Security Licenses for one year', 'ea.', 'B', '4060', '5035', '1510', '5035', '1530', '2', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('NBT', '1', '3', 'NBT', '', 'ea.', 'D', '2155', '2155', '0150', '0150', '0150', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('OH', '13', '1', 'Overhead cost - Sorting', '', 'ea.', 'B', '4060', '5035', '1510', '1510', '1530', '14', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('oneyear', '13', '3', 'License - 1 year 1 user EMSI', '', 'ea.', 'B', '4060', '5035', '1520', '1520', '1530', '14', '0', '325197.75', '20414.432278667', '0', '0', '0', '1', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('P/C', '1', '2', 'Positive Charges', 'Positive Charges', 'ea.', 'D', '4060', '5035', '0150', '0150', '0150', '0', '0', '1150', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Pouch', '13', '3', 'Cost of Pouch', '', 'ea.', 'B', '4060', '5035', '1520', '1520', '1530', '14', '0', '47.3', '45.8743985819', '0', '0', '0', '1', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('RtnCheque', '1', '3', 'Cheque Returns', '', 'ea.', 'D', '1060', '1060', '0150', '0150', '0150', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('S/P', '13', '5', 'Sticker Pasting', 'Sticker Pasting', 'ea.', 'D', '4060', '5035', '0150', '0150', '0150', '14', '0', '1', '10', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Sec-Key', '9', '2', 'F-Secure Security Key', 'F-Secure Security Key', 'ea.', 'D', '4060', '5035', '0150', '0150', '0150', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('SKY-RE', '1', '1', 'Repacking-Sky Print', '', 'ea.', 'D', '4060', '5035', '0150', '0150', '0150', '0', '0', '30', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('SOPHOS', '11', '5', 'Sophos Central Endpoint Protection (formerly Central Endpoint Advanced) -1 yr. support', '(formerly Central Endpoint Advanced) -1 yr. support', ' Licenses', 'B', '4060', '5035', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('SOPHOS.', '11', '5', 'Sophos Central Intercept X Advanced for Server (formerly Central Server Protection Advanced) - 1 yr. support', '(formerly Central Server Protection Advanced) - 1 yr. support', ' Licenses', 'B', '4060', '5035', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('SRP-275III', '2', '3', 'SRP-275III Dot-matrix Receipt ', 'SRP-275III Dot-matrix Receipt ', 'ea.', 'B', '4015', '5020', '1510', '5030', '1530', '5', '0', '27000', '27000', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('SWIVELUSB16GB', '19', '3', ' USB 16GB 2.0  Flash Drive', 'Black print on front side only', 'ea.', 'B', '4065', '5036', '1510', '5036', '1540', '16', '0', '511', '462.5', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('SWIVELUSB32GB', '19', '3', 'USB 32GB 2.0 Flash Drive', 'Black print on front side only', 'ea.', 'B', '4065', '5036', '1510', '5036', '1540', '16', '0', '630', '625.33898305085', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('SWIVELUSB8GB', '19', '3', 'USB 8GB 2.0 Flash Drive', 'Black print on front side only', 'ea.', 'B', '4065', '5036', '1510', '5036', '1530', '16', '0', '491', '508', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Symantec-Lic', '9', '1', 'Symantec End Point Protection License', '', ' Licenses', 'B', '4060', '5035', '1510', '5035', '1530', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Table', '14', '1', 'Office Tables', '', 'ea.', 'F', '4520', '1920', '1820', '4520', '1530', '0', '0', '500', '500', '0', '0', '0', '1', '0', '0', 'D', '10', '0', '2017-09-01', '2017-09-01', '05', NULL, NULL),
('table1', '16', '1', 'Table 1', '', 'ea.', 'F', '4520', '1920', '1820', '4520', '1530', '0', '0', '25000', '25000', '0', '0', '0', '1', '1', '0', 'D', '10', '0', '2017-10-09', '2017-10-09', '05', NULL, NULL),
('tb2', '14', '1', 'Table 2', '', 'ea.', 'F', '4520', '1920', '1820', '4520', '1530', '0', '0', '214', '214', '0', '0', '0', '1', '1', '1', 'D', '10', '1', '2017-10-10', '2017-10-10', '05', NULL, NULL),
('Threeyearoneuser', '13', '1', 'Emsisoft license - 3 year 1 user', '', 'ea.', 'B', '4060', '5035', '1520', '1520', '1530', '14', '0', '73', '73', '0', '0', '0', '1', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Training', '1', '3', 'Training Programmes', 'Providing training for customers and staff', 'ea.', 'D', '4030', '5030', '0150', '0150', '0150', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('VAT', '1', '3', 'VAT', '', 'ea.', 'D', '2150', '2150', '0150', '0150', '0150', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('W/H', '1', '2', 'Web Hosting Charges', 'Web Hosting Charges', 'ea.', 'D', '4030', '5030', '0150', '0150', '0150', '3', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('Water', '1', '3', 'Water Bottles', 'Water Bottles', 'ea.', 'D', '5815', '5040', '0150', '0150', '0150', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL),
('WIRELES', '19', '3', 'Wireless Charger', 'Wireless Charger', 'ea.', 'B', '4065', '5036', '1510', '5036', '1530', '16', '0', '10', '1212.14285714', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', NULL, NULL);

### Structure of table `0_stock_moves` ###

DROP TABLE IF EXISTS `0_stock_moves`;

CREATE TABLE `0_stock_moves` (
  `trans_id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` smallint(6) NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `price` double NOT NULL DEFAULT '0',
  `reference` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT '1',
  `standard_cost` double NOT NULL DEFAULT '0',
  `line_location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`trans_id`),
  KEY `type` (`type`,`trans_no`),
  KEY `Move` (`stock_id`,`loc_code`,`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_moves` ###


### Structure of table `0_stock_serial` ###

DROP TABLE IF EXISTS `0_stock_serial`;

CREATE TABLE `0_stock_serial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serial_key` int(4) DEFAULT NULL,
  `year_month` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serial_no` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `manufacture_date` date DEFAULT NULL,
  `stock_in_date` timestamp NULL DEFAULT NULL,
  `type_no_in` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_no_in` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `stock_out_date` datetime DEFAULT NULL,
  `type_no_out` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_no_out` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `availability` int(1) DEFAULT '1',
  `serial_status` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` int(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `serial_number` (`serial_no`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_serial` ###


### Structure of table `0_stock_serial_genarate_log` ###

DROP TABLE IF EXISTS `0_stock_serial_genarate_log`;

CREATE TABLE `0_stock_serial_genarate_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serial_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `commnet` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `genarate_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_serial_genarate_log` ###


### Structure of table `0_supp_allocations` ###

DROP TABLE IF EXISTS `0_supp_allocations`;

CREATE TABLE `0_supp_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_allocations` ###


### Structure of table `0_supp_invoice_items` ###

DROP TABLE IF EXISTS `0_supp_invoice_items`;

CREATE TABLE `0_supp_invoice_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_trans_no` int(11) DEFAULT NULL,
  `supp_trans_type` int(11) DEFAULT NULL,
  `gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `grn_item_id` int(11) DEFAULT NULL,
  `po_detail_item_id` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `quantity` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `unit_tax` double NOT NULL DEFAULT '0',
  `memo_` tinytext COLLATE utf8_unicode_ci,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `line_location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`supp_trans_type`,`supp_trans_no`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_invoice_items` ###


### Structure of table `0_supp_trans` ###

DROP TABLE IF EXISTS `0_supp_trans`;

CREATE TABLE `0_supp_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `supplier_id` int(11) unsigned NOT NULL,
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `ov_amount` double NOT NULL DEFAULT '0',
  `ov_discount` double NOT NULL DEFAULT '0',
  `ov_gst` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  `alloc` double NOT NULL DEFAULT '0',
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`type`,`trans_no`,`supplier_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_trans` ###


### Structure of table `0_supplier_areas` ###

DROP TABLE IF EXISTS `0_supplier_areas`;

CREATE TABLE `0_supplier_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supplier_areas` ###


### Structure of table `0_suppliers` ###

DROP TABLE IF EXISTS `0_suppliers`;

CREATE TABLE `0_suppliers` (
  `supplier_id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supp_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `gst_no` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supp_account_no` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `website` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  `dimension_id` int(11) DEFAULT '0',
  `dimension2_id` int(11) DEFAULT '0',
  `tax_group_id` int(11) DEFAULT NULL,
  `credit_limit` double NOT NULL DEFAULT '0',
  `purchase_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payable_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `area` int(11) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `supp_ref` (`supp_ref`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_suppliers` ###

INSERT INTO `0_suppliers` VALUES
('7', 'PEE BEE MANAGEMENT SERVICES (PVT) LTD', 'peebee', 'peebeemanagement@peebeegroup.com', 'No.55,Chattam Street,\nColombo 01.', '', '', '', 'www.floratissues.com', '', 'LKR', '2', '0', '0', '0', '1', '200000', '5770', '2100', '5060', '', '0', '0'),
('15', 'Dilshee Enterprises ', 'Dilshee', '', '', '', '', '001', '', '', 'LKR', '3', '1', '0', '0', '2', '200000', '5480', '2100', '5060', '', '0', '0'),
('16', 'Kangaroo Cabs (Pvt) Ltd', 'Kangaroo', '', 'No.91 1/6, Galle Road,\nColombo 04.', '', '', '', '', '', 'LKR', '1', '1', '0', '0', '1', '100000', '5500', '2100', '5060', '', '1', '0'),
('20', 'Genesiis Software ( Pvt ) Ltd', 'Genesiis', '49/16,\nIceland Building\nGalle road\nColombo 03', '49/16,\nIceland Building\nGalle road\nColombo 03', '', '', '', '', '', 'LKR', '3', '0', '0', '0', '2', '0', '5520', '2100', '5060', '', '0', '0'),
('27', 'Kangaroo Cabs (Pvt) Ltd', 'Kangaroo Cabs (Pvt) Ltd', 'Galle Road, Colombo 3.', '', '', '', '', '', '', 'LKR', '2', '0', '0', '0', '1', '100000', '5500', '2100', '5060', '', '0', '0'),
('34', 'Sage Software  Asia Private Limited', 'Sage  Software ', '', 'SAGE SOFTWARE ASIA PTE LTD\nSingapore', '', '', '', '', '', 'AUD', '3', '0', '0', '0', '2', '0', '5010', '2100', '5060', '', '0', '0'),
('36', 'Penguin Industries (Pvt)Ltd.', 'penguin', '115, Maya Avenue, Colombo 6.', '', '', '', '', '', '', 'LKR', '1', '0', '0', '0', '3', '500000', '', '2100', '5060', '', '0', '0'),
('38', 'SKY PRINT SOLUTIONS', 'SKY', '', '', '', '', '', '', '', 'LKR', '1', '0', '0', '0', '1', '0', '', '2100', '5035', '', '0', '0'),
('40', 'John Keells Office Automation (PVT) LTD', 'John Keells', '', '', '', '', '', '', '', 'LKR', '3', '0', '0', '0', '2', '0', '', '2100', '5030', '', '0', '0'),
('42', 'F-Secure Corporation', 'F-Secure Corporation', 'Tammasaarenkatu 7,\n00180 Helsinki,\nFinland', 'Tammasaarenkatu 7,\n00180 Helsinki,\nFinland', '', '', '', '', '', 'USD', '3', '0', '13', '0', '2', '5000000', '', '2100', '2650', '', '0', '0'),
('43', 'Abans PLC', 'Abans', '', '', '', '', '0005', '', '', 'LKR', '1', '0', '0', '0', '2', '0', '', '2100', '5030', '', '0', '0'),
('49', 'Softlogic Information Technologies (Pvt) Ltd', 'Softlogic ', 'Mr Dinith Kurukulasuriya,\nNo 14\n2nd Floor,\nDe Fonseka Place,\nColombo 05', 'Mr Dinith Kurukulasuriya,\nNo 14\n2nd Floor,\nDe Fonseka Place,\nColombo 05', '', '', '', '', '', 'LKR', '7', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0', '0'),
('50', 'ShareColombo Services (Pvt) Ltd', 'ShareColombo ', '', '', '', '', '', '', '', 'LKR', '2', '0', '0', '0', '2', '0', '1840', '2100', '4430', '', '0', '0'),
('51', 'Expense Creditors', 'expense', '', '', '', '', '', '', '', 'LKR', '2', '0', '0', '0', '1', '5000000', '1550', '2110', '5060', '', '0', '0'),
('52', 'Onetma Solutions', 'Onetma', '', '', '', '', '', '', '', 'LKR', '1', '0', '0', '0', '2', '0', '', '2100', '5030', '', '0', '0'),
('53', 'C.W Mackie PLC', 'C.W Mackie PLC', 'P O Box 161,\nNo 36,\nD R Wijewardana Mawatha,\nColombo 10', 'P O Box 161,\nNo 36,\nD R Wijewardana Mawatha,\nColombo 10', '', '', '', '', '', 'LKR', '2', '0', '0', '0', '2', '0', '', '2100', '5815', '', '0', '0'),
('54', 'Standard Chartered Bank A/C No:4199820000624027', 'Standard Chartered Bank', '', '', '', '', '', '', '', 'LKR', '2', '0', '14', '0', '2', '0', '', '2100', '5035', '', '0', '0'),
('55', 'Shenzhen Konchang Electronic Technology Co.Ltd.', 'Shenzhen', '', '', '', '', '', 'alistah@konchang.com', '', 'LKR', '2', '0', '16', '0', '2', '0', '', '2100', '5035', '', '0', '0'),
('56', 'HSBC O/A Card No:4910149950824306', 'HSBC Credit Crad', '', '', '', '', '', '', '', 'LKR', '2', '0', '0', '0', '2', '0', '', '2100', '5035', '', '0', '0'),
('57', 'ICEMAN LOGISTICS (PVT) LTD', 'ICEMAN', '', '', '', '', '', '', '', 'LKR', '2', '0', '0', '0', '2', '0', '5480', '2100', '5060', '', '0', '0'),
('58', 'Cash', 'Cash purchases', '', '', '', '', '', '', '', 'LKR', '3', '0', '0', '0', '2', '100000', '', '1070', '5060', '', '0', '0'),
('59', 'Ceilao Logistics Group (Pvt) Ltd', 'Ceilao ', '', '', '', '', '', '', '', 'LKR', '2', '0', '0', '0', '2', '0', '5480', '2100', '5060', '', '0', '0'),
('60', 'TECHZONE (PVT) LTD', 'TECHZONE ', '', '', '', '', '', '', '', 'LKR', '2', '0', '0', '0', '2', '0', '1845', '2100', '5040', '', '0', '0'),
('61', 'Computer Superstore (Pte) Ltd', 'Computer Superstore', 'No:542, Duplication Road,\nColombo 03', 'No:542, Duplication Road,\nColombo 03', '', '', '', '', '', 'LKR', '1', '0', '0', '0', '2', '0', '5772', '2100', '5060', '', '0', '0'),
('62', 'RENTOKIL INITIAL CEYLON (PVT) LIMITED', 'Rentokil', 'No:186, Vausxhall Street,\nColombo 02.', '', '', '', '', '', '', 'LKR', '2', '0', '0', '0', '1', '0', '5770', '2100', '5060', '', '0', '0'),
('63', 'Prompt Xpress (Private) Ltd', 'Promt', 'No 40, Ferry Road, Rathmalana', '', '', '', '', '', '', 'LKR', '1', '0', '0', '0', '2', '0', '5090', '2100', '5090', '', '0', '0'),
('64', 'Sesiro Enterprise', 'Sesiro Enterprise', 'No 433 E3, Galle Raod,Ratmalana.', '', '', '', '', '', '', 'LKR', '1', '0', '0', '0', '2', '0', '5815', '2100', '5815', '', '0', '0'),
('65', 'Shenzhen Konchang Electronic Technology Co.Ltd.', 'S', 'Shenzhen', '', '', '', '', '', 'Standard Chartered', 'USD', '2', '0', '0', '0', '1', '1000000', '', '2100', '1510', '', '1', '0'),
('66', 'EMSISOFT Ltd.', 'Emsisoft', '', '', '', '', '', '', '', 'USD', '2', '0', '0', '0', '2', '1000000', '1520', '2100', '5060', '', '0', '0'),
('67', 'Nescafe Station', 'Nescafe Station', '', '', '', '', '', '', '', 'LKR', '2', '0', '0', '0', '2', '0', '5480', '2100', '5480', '', '0', '0');

### Structure of table `0_sys_prefs` ###

DROP TABLE IF EXISTS `0_sys_prefs`;

CREATE TABLE `0_sys_prefs` (
  `name` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `length` smallint(6) DEFAULT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`name`),
  KEY `category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sys_prefs` ###

INSERT INTO `0_sys_prefs` VALUES
('accounts_alpha', 'glsetup.general', 'tinyint', '1', '0'),
('accumulate_shipping', 'glsetup.customer', 'tinyint', '1', '0'),
('add_pct', 'setup.company', 'int', '5', '-1'),
('allow_negative_prices', 'glsetup.inventory', 'tinyint', '1', ''),
('allow_negative_stock', 'glsetup.inventory', 'tinyint', '1', '1'),
('alternative_tax_include_on_docs', 'setup.company', 'tinyint', '1', ''),
('auto_curr_reval', 'setup.company', 'smallint', '6', ''),
('bank_charge_act', 'glsetup.general', 'varchar', '15', '5805'),
('base_sales', 'setup.company', 'int', '11', '0'),
('bcc_email', 'setup.company', 'varchar', '100', ''),
('coy_logo', 'setup.company', 'varchar', '100', 'evolve_logo_small.png'),
('coy_name', 'setup.company', 'varchar', '60', 'Evolve Technologies (Pvt)Ltd.'),
('coy_no', 'setup.company', 'varchar', '25', 'PV  67945'),
('creditors_act', 'glsetup.purchase', 'varchar', '15', '2100'),
('curr_default', 'setup.company', 'char', '3', 'LKR'),
('debtors_act', 'glsetup.sales', 'varchar', '15', '1200'),
('default_adj_act', 'glsetup.items', 'varchar', '15', '5040'),
('default_cogs_act', 'glsetup.items', 'varchar', '15', '5030'),
('default_credit_limit', 'glsetup.customer', 'int', '11', '1000000'),
('default_delivery_required', 'glsetup.sales', 'smallint', '6', '1'),
('default_dim_required', 'glsetup.dims', 'int', '11', '20'),
('default_inv_sales_act', 'glsetup.items', 'varchar', '15', '4010'),
('default_inventory_act', 'glsetup.items', 'varchar', '15', '1510'),
('default_loss_on_asset_disposal_act', 'glsetup.items', 'varchar', '15', '4520'),
('default_prompt_payment_act', 'glsetup.sales', 'varchar', '15', '4500'),
('default_quote_valid_days', 'glsetup.sales', 'smallint', '6', '30'),
('default_receival_required', 'glsetup.purchase', 'smallint', '6', '10'),
('default_sales_act', 'glsetup.sales', 'varchar', '15', '4010'),
('default_sales_discount_act', 'glsetup.sales', 'varchar', '15', '4510'),
('default_wip_act', 'glsetup.items', 'varchar', '15', '1530'),
('default_workorder_required', 'glsetup.manuf', 'int', '11', '20'),
('deferred_income_act', 'glsetup.sales', 'varchar', '15', ''),
('depreciation_period', 'glsetup.company', 'tinyint', '1', '1'),
('domicile', 'setup.company', 'varchar', '55', 'Sri Lanka'),
('email', 'setup.company', 'varchar', '100', 'kplp@evolve-sl.com'),
('exchange_diff_act', 'glsetup.general', 'varchar', '15', '4450'),
('f_year', 'setup.company', 'int', '11', '7'),
('fax', 'setup.company', 'varchar', '30', '0115936947'),
('freight_act', 'glsetup.customer', 'varchar', '15', '4430'),
('gl_closing_date', 'setup.closing_date', 'date', '8', '2020-03-31'),
('grn_clearing_act', 'glsetup.purchase', 'varchar', '15', '1550'),
('gst_no', 'setup.company', 'varchar', '25', ''),
('legal_text', 'glsetup.customer', 'tinytext', '0', 'Cheques in favour of &quot; Evolve Technologies (Pvt)Ltd.&quot;'),
('loc_notification', 'glsetup.inventory', 'tinyint', '1', ''),
('login_tout', 'setup.company', 'smallint', '6', '600000'),
('no_customer_list', 'setup.company', 'tinyint', '1', '0'),
('no_item_list', 'setup.company', 'tinyint', '1', '0'),
('no_supplier_list', 'setup.company', 'tinyint', '1', '0'),
('no_zero_lines_amount', 'glsetup.sales', 'tinyint', '1', ''),
('past_due_days', 'glsetup.general', 'int', '11', '30'),
('phone', 'setup.company', 'varchar', '30', '0115936945'),
('po_over_charge', 'glsetup.purchase', 'int', '11', '10'),
('po_over_receive', 'glsetup.purchase', 'int', '11', '10'),
('postal_address', 'setup.company', 'tinytext', '0', 'Evolve Technologies(Pvt)Ltd.\r\nNo.82,W.A.D.Ramanayake Mawatha\r\nColombo 02., VAT No:114679453-7000'),
('print_invoice_no', 'glsetup.sales', 'tinyint', '1', '1'),
('print_item_images_on_quote', 'glsetup.inventory', 'tinyint', '1', ''),
('profit_loss_year_act', 'glsetup.general', 'varchar', '15', '9990'),
('pyt_discount_act', 'glsetup.purchase', 'varchar', '15', '5060'),
('retained_earnings_act', 'glsetup.general', 'varchar', '15', '3590'),
('round_to', 'setup.company', 'int', '5', '1'),
('show_po_item_codes', 'glsetup.purchase', 'tinyint', '1', '1'),
('suppress_tax_rates', 'setup.company', 'tinyint', '1', ''),
('tax_algorithm', 'glsetup.customer', 'tinyint', '1', '1'),
('tax_last', 'setup.company', 'int', '11', '1'),
('tax_prd', 'setup.company', 'int', '11', '1'),
('time_zone', 'setup.company', 'tinyint', '1', '0'),
('use_dimension', 'setup.company', 'tinyint', '1', '2'),
('use_fixed_assets', 'setup.company', 'tinyint', '1', '1'),
('use_manufacturing', 'setup.company', 'tinyint', '1', '1'),
('version_id', 'system', 'varchar', '11', '2.4.1');

### Structure of table `0_sys_types` ###

DROP TABLE IF EXISTS `0_sys_types`;

CREATE TABLE `0_sys_types` (
  `type_id` smallint(6) NOT NULL DEFAULT '0',
  `type_no` int(11) NOT NULL DEFAULT '1',
  `next_reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sys_types` ###

INSERT INTO `0_sys_types` VALUES
('0', '19', '00001'),
('1', '8', '00001'),
('2', '5', '00001'),
('4', '3', '00001'),
('10', '19', '00001'),
('11', '3', '00001'),
('12', '6', '00001'),
('13', '5', '00001'),
('16', '2', '00001'),
('17', '2', '00001'),
('18', '1', '00001'),
('20', '8', '00001'),
('21', '1', '00001'),
('22', '4', '00001'),
('25', '1', '00001'),
('26', '1', '00001'),
('28', '1', '00001'),
('29', '1', '00001'),
('30', '5', '00001'),
('32', '0', '00001'),
('35', '1', '00001'),
('40', '1', '00001'),
('50', '1', '');

### Structure of table `0_tag_associations` ###

DROP TABLE IF EXISTS `0_tag_associations`;

CREATE TABLE `0_tag_associations` (
  `record_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `tag_id` int(11) NOT NULL,
  UNIQUE KEY `record_id` (`record_id`,`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tag_associations` ###


### Structure of table `0_tags` ###

DROP TABLE IF EXISTS `0_tags`;

CREATE TABLE `0_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tags` ###


### Structure of table `0_tax_group_items` ###

DROP TABLE IF EXISTS `0_tax_group_items`;

CREATE TABLE `0_tax_group_items` (
  `tax_group_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `tax_shipping` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tax_group_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_group_items` ###

INSERT INTO `0_tax_group_items` VALUES
('1', '2', '0'),
('1', '3', '0'),
('3', '4', '0'),
('4', '2', '0');

### Structure of table `0_tax_groups` ###

DROP TABLE IF EXISTS `0_tax_groups`;

CREATE TABLE `0_tax_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_groups` ###

INSERT INTO `0_tax_groups` VALUES
('1', 'Tax', '0'),
('2', 'Tax Exempt', '0'),
('3', 'V.A.T only', '0'),
('4', 'NBT Only', '0');

### Structure of table `0_tax_types` ###

DROP TABLE IF EXISTS `0_tax_types`;

CREATE TABLE `0_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rate` double NOT NULL DEFAULT '0',
  `sales_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `purchasing_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_types` ###

INSERT INTO `0_tax_types` VALUES
('2', '0', '2155', '2155', 'N.B.T Tax', '0'),
('3', '8', '2150', '2150', 'V.A.T Total ', '0'),
('4', '8', '2151', '2151', 'V.A.T only', '0');

### Structure of table `0_trans_tax_details` ###

DROP TABLE IF EXISTS `0_trans_tax_details`;

CREATE TABLE `0_trans_tax_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `tran_date` date NOT NULL,
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '0',
  `ex_rate` double NOT NULL DEFAULT '1',
  `included_in_price` tinyint(1) NOT NULL DEFAULT '0',
  `net_amount` double NOT NULL DEFAULT '0',
  `amount` double NOT NULL DEFAULT '0',
  `memo` tinytext COLLATE utf8_unicode_ci,
  `reg_type` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Type_and_Number` (`trans_type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_trans_tax_details` ###


### Structure of table `0_type_styles` ###

DROP TABLE IF EXISTS `0_type_styles`;

CREATE TABLE `0_type_styles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ts_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `ts_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `inactive` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_type_styles` ###


### Structure of table `0_useronline` ###

DROP TABLE IF EXISTS `0_useronline`;

CREATE TABLE `0_useronline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` int(15) NOT NULL DEFAULT '0',
  `ip` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `file` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB AUTO_INCREMENT=2435 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_useronline` ###

INSERT INTO `0_useronline` VALUES
('2427', '1478005730', '124.43.16.168', '/index.php'),
('2428', '1478005734', '124.43.16.168', '/index.php'),
('2429', '1478005737', '124.43.16.168', '/admin/company_preferences.php'),
('2430', '1478005737', '124.43.16.168', '/admin/company_preferences.php'),
('2431', '1478005817', '124.43.16.168', '/index.php'),
('2432', '1478005817', '124.43.16.168', '/index.php'),
('2433', '1478005821', '124.43.16.168', '/admin/backups.php'),
('2434', '1478005821', '124.43.16.168', '/admin/backups.php');

### Structure of table `0_users` ###

DROP TABLE IF EXISTS `0_users`;

CREATE TABLE `0_users` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `real_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `role_id` int(11) NOT NULL DEFAULT '1',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_format` tinyint(1) NOT NULL DEFAULT '0',
  `date_sep` tinyint(1) NOT NULL DEFAULT '0',
  `tho_sep` tinyint(1) NOT NULL DEFAULT '0',
  `dec_sep` tinyint(1) NOT NULL DEFAULT '0',
  `theme` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'default',
  `page_size` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'A4',
  `prices_dec` smallint(6) NOT NULL DEFAULT '2',
  `qty_dec` smallint(6) NOT NULL DEFAULT '2',
  `rates_dec` smallint(6) NOT NULL DEFAULT '4',
  `percent_dec` smallint(6) NOT NULL DEFAULT '1',
  `show_gl` tinyint(1) NOT NULL DEFAULT '1',
  `show_codes` tinyint(1) NOT NULL DEFAULT '0',
  `show_hints` tinyint(1) NOT NULL DEFAULT '0',
  `last_visit_date` datetime DEFAULT NULL,
  `query_size` tinyint(1) unsigned NOT NULL DEFAULT '10',
  `graphic_links` tinyint(1) DEFAULT '1',
  `pos` smallint(6) DEFAULT '1',
  `print_profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `rep_popup` tinyint(1) DEFAULT '1',
  `sticky_doc_date` tinyint(1) DEFAULT '0',
  `startup_tab` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `transaction_days` int(6) NOT NULL DEFAULT '30' COMMENT 'Transaction days',
  `save_report_selections` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Save Report Selection Days',
  `use_date_picker` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Use Date Picker for all Date Values',
  `def_print_destination` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Default Report Destination',
  `def_print_orientation` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Default Report Orientation',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_users` ###

INSERT INTO `0_users` VALUES
('1', 'admin', '5e673704a558e3158e601995fe9fad87', 'Administrator', '2', '', 'Eotnip@123', 'C', '0', '0', '0', '0', 'bluecollar', 'A4', '2', '2', '4', '1', '1', '1', '1', '2021-10-29 04:41:19', '50', '0', '1', '', '0', '1', 'assets', '31', '30', '1', '0', '0', '0'),
('10', 'Accountant', 'ef0e390bdff8c050c458194297cafc80', 'Wellcome Accountant', '9', '', 'kAushalya', 'C', '1', '0', '0', '0', 'bluecollar', 'A4', '2', '2', '4', '1', '1', '0', '1', '2021-10-28 01:01:27', '127', '1', '1', '', '1', '1', 'orders', '30', '0', '1', '0', '0', '0'),
('11', 'admin 1', '21232f297a57a5a743894a0e4a801fc3', 'Sri', '10', '', NULL, 'C', '0', '0', '0', '0', 'aqua', 'A4', '2', '2', '4', '1', '1', '0', '1', '2015-05-18 04:24:57', '10', '1', '1', '', '1', '1', 'orders', '30', '0', '1', '0', '0', '0'),
('13', 'Account2', '5c02b099ae7217e11346a4fb40dbe817', 'Wellcome Shameen', '9', '', 'shameen', 'C', '0', '0', '0', '0', 'bluecollar', 'A4', '2', '2', '4', '1', '1', '0', '1', '2021-10-28 00:12:46', '50', '1', '1', '', '1', '1', 'assets', '30', '30', '1', '0', '0', '0'),
('14', 'Evolve1', '350316633ea950e79fe09b05da67a9bf', '', '10', '', NULL, 'C', '0', '0', '0', '0', 'bluecollar', 'A4', '2', '2', '4', '1', '1', '0', '1', '2020-06-29 23:19:37', '50', '1', '1', '', '1', '1', 'assets', '30', '30', '1', '0', '0', '0');

### Structure of table `0_voided` ###

DROP TABLE IF EXISTS `0_voided`;

CREATE TABLE `0_voided` (
  `type` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_voided` ###


### Structure of table `0_wo_costing` ###

DROP TABLE IF EXISTS `0_wo_costing`;

CREATE TABLE `0_wo_costing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `cost_type` tinyint(1) NOT NULL DEFAULT '0',
  `trans_type` int(11) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `factor` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_costing` ###


### Structure of table `0_wo_issue_items` ###

DROP TABLE IF EXISTS `0_wo_issue_items`;

CREATE TABLE `0_wo_issue_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_id` int(11) DEFAULT NULL,
  `qty_issued` double DEFAULT NULL,
  `unit_cost` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_issue_items` ###


### Structure of table `0_wo_issues` ###

DROP TABLE IF EXISTS `0_wo_issues`;

CREATE TABLE `0_wo_issues` (
  `issue_no` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workcentre_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`issue_no`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_issues` ###


### Structure of table `0_wo_manufacture` ###

DROP TABLE IF EXISTS `0_wo_manufacture`;

CREATE TABLE `0_wo_manufacture` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_manufacture` ###


### Structure of table `0_wo_requirements` ###

DROP TABLE IF EXISTS `0_wo_requirements`;

CREATE TABLE `0_wo_requirements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre` int(11) NOT NULL DEFAULT '0',
  `units_req` double NOT NULL DEFAULT '1',
  `unit_cost` double NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_issued` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_requirements` ###


### Structure of table `0_workcentres` ###

DROP TABLE IF EXISTS `0_workcentres`;

CREATE TABLE `0_workcentres` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_workcentres` ###

INSERT INTO `0_workcentres` VALUES
('1', 'Workshop', 'Workshop in Evolve', '0');

### Structure of table `0_workorders` ###

DROP TABLE IF EXISTS `0_workorders`;

CREATE TABLE `0_workorders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wo_ref` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_reqd` double NOT NULL DEFAULT '1',
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `required_by` date NOT NULL DEFAULT '0000-00-00',
  `released_date` date NOT NULL DEFAULT '0000-00-00',
  `units_issued` double NOT NULL DEFAULT '0',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `released` tinyint(1) NOT NULL DEFAULT '0',
  `additional_costs` double NOT NULL DEFAULT '0',
  `budjet_labour` double NOT NULL,
  `budjet_orverhead` double NOT NULL,
  `labour_cost` double NOT NULL,
  `orverhead_cost` double NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wo_ref` (`wo_ref`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_workorders` ###
