/*
Navicat MySQL Data Transfer

Source Server         : Ceylon Trading
Source Server Version : 50505
Source Host           : 184.171.245.138:3306
Source Database       : ceylontrad20173_erp360

Target Server Type    : MYSQL
Target Server Version : 50505
File Encoding         : 65001

Date: 2017-06-01 11:04:44
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for `0_amortisation`
-- ----------------------------
DROP TABLE IF EXISTS `0_amortisation`;
CREATE TABLE `0_amortisation` (
  `amortisation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `amortisation_year` int(11) DEFAULT NULL,
  `asset_value` double DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `posted` int(11) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`amortisation_id`),
  UNIQUE KEY `amortisation_id` (`amortisation_id`),
  KEY `0_amortisation_asset_id` (`asset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_amortisation
-- ----------------------------

-- ----------------------------
-- Table structure for `0_areas`
-- ----------------------------
DROP TABLE IF EXISTS `0_areas`;
CREATE TABLE `0_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_areas
-- ----------------------------
INSERT INTO 0_areas VALUES ('1', 'Global', '0');
INSERT INTO 0_areas VALUES ('2', 'colombo', '0');

-- ----------------------------
-- Table structure for `0_assets`
-- ----------------------------
DROP TABLE IF EXISTS `0_assets`;
CREATE TABLE `0_assets` (
  `asset_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_type_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `asset_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_serial` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `purchase_date` date NOT NULL,
  `purchase_value` double NOT NULL,
  `disposal_amount` double DEFAULT NULL,
  `disposal_date` date DEFAULT NULL,
  `disposal_posting` int(11) DEFAULT '0',
  `tag_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_location` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_condition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_acquisition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_id`),
  UNIQUE KEY `asset_id` (`asset_id`),
  KEY `0_assets_asset_type_id` (`asset_type_id`),
  KEY `0_assets_item_id` (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_assets
-- ----------------------------

-- ----------------------------
-- Table structure for `0_asset_types`
-- ----------------------------
DROP TABLE IF EXISTS `0_asset_types`;
CREATE TABLE `0_asset_types` (
  `asset_type_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_type_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `depreciation_type` int(11) NOT NULL DEFAULT '1',
  `depreciation_rate` double NOT NULL DEFAULT '10',
  `asset_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `depreciation_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `accumulated_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `valuation_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `disposal_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_type_id`),
  UNIQUE KEY `asset_type_id` (`asset_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_asset_types
-- ----------------------------

-- ----------------------------
-- Table structure for `0_asset_valuations`
-- ----------------------------
DROP TABLE IF EXISTS `0_asset_valuations`;
CREATE TABLE `0_asset_valuations` (
  `asset_valuation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `valuation_year` int(11) DEFAULT NULL,
  `asset_value` double NOT NULL DEFAULT '0',
  `value_change` double NOT NULL DEFAULT '0',
  `posted` int(11) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_valuation_id`),
  UNIQUE KEY `asset_valuation_id` (`asset_valuation_id`),
  UNIQUE KEY `asset_id` (`asset_id`,`valuation_year`),
  KEY `0_asset_valuations_asset_id` (`asset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_asset_valuations
-- ----------------------------

-- ----------------------------
-- Table structure for `0_attachments`
-- ----------------------------
DROP TABLE IF EXISTS `0_attachments`;
CREATE TABLE `0_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_no` int(11) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `unique_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT '0',
  `filetype` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_attachments
-- ----------------------------

-- ----------------------------
-- Table structure for `0_audit_trail`
-- ----------------------------
DROP TABLE IF EXISTS `0_audit_trail`;
CREATE TABLE `0_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `user` smallint(6) unsigned NOT NULL DEFAULT '0',
  `stamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL DEFAULT '0',
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_audit_trail
-- ----------------------------
INSERT INTO 0_audit_trail VALUES ('1', '1', '48', '1', '2017-05-09 00:40:06', '', '3', '2017-05-09', null);
INSERT INTO 0_audit_trail VALUES ('2', '1', '48', '1', '2017-06-01 01:35:25', '', '3', '2017-05-09', null);
INSERT INTO 0_audit_trail VALUES ('3', '4', '1', '1', '2017-06-01 00:39:02', '', '3', '2017-01-06', '0');
INSERT INTO 0_audit_trail VALUES ('4', '1', '49', '1', '2017-06-01 00:43:27', '', '3', '2017-01-04', '0');
INSERT INTO 0_audit_trail VALUES ('5', '1', '50', '1', '2017-06-01 00:46:50', '', '3', '2017-01-04', '0');
INSERT INTO 0_audit_trail VALUES ('6', '1', '51', '1', '2017-06-01 00:47:27', '', '3', '2017-01-04', '0');
INSERT INTO 0_audit_trail VALUES ('7', '1', '52', '1', '2017-06-01 00:53:14', '', '3', '2017-01-09', '0');
INSERT INTO 0_audit_trail VALUES ('8', '1', '53', '1', '2017-06-01 00:57:17', '', '3', '2017-01-10', '0');
INSERT INTO 0_audit_trail VALUES ('9', '4', '2', '1', '2017-06-01 01:02:50', '', '3', '2017-01-16', '0');
INSERT INTO 0_audit_trail VALUES ('10', '1', '54', '1', '2017-06-01 01:04:08', '', '3', '2017-01-17', '0');
INSERT INTO 0_audit_trail VALUES ('11', '1', '55', '1', '2017-06-01 01:04:50', '', '3', '2017-01-17', '0');
INSERT INTO 0_audit_trail VALUES ('12', '1', '56', '1', '2017-06-01 01:13:22', '', '3', '2017-01-18', '0');
INSERT INTO 0_audit_trail VALUES ('13', '1', '57', '1', '2017-06-01 01:15:33', '', '3', '2017-01-19', '0');
INSERT INTO 0_audit_trail VALUES ('14', '4', '3', '1', '2017-06-01 01:16:09', '', '3', '2017-01-19', '0');
INSERT INTO 0_audit_trail VALUES ('15', '1', '58', '1', '2017-06-01 01:28:30', '', '3', '2017-01-24', '0');
INSERT INTO 0_audit_trail VALUES ('16', '1', '59', '1', '2017-06-01 01:29:15', '', '3', '2017-01-24', '0');
INSERT INTO 0_audit_trail VALUES ('17', '1', '60', '1', '2017-06-01 01:30:08', '', '3', '2017-01-24', '0');
INSERT INTO 0_audit_trail VALUES ('18', '4', '4', '1', '2017-06-01 01:30:51', '', '3', '2017-01-25', '0');
INSERT INTO 0_audit_trail VALUES ('19', '1', '61', '1', '2017-06-01 01:32:33', '', '3', '2017-01-26', '0');
INSERT INTO 0_audit_trail VALUES ('20', '4', '5', '1', '2017-06-01 01:33:16', '', '3', '2017-01-27', '0');
INSERT INTO 0_audit_trail VALUES ('21', '4', '6', '1', '2017-06-01 01:34:35', '', '3', '2017-01-31', '0');
INSERT INTO 0_audit_trail VALUES ('22', '1', '48', '1', '2017-06-01 01:35:25', 'Voided.\n', '3', '2017-06-01', '0');

-- ----------------------------
-- Table structure for `0_bank_accounts`
-- ----------------------------
DROP TABLE IF EXISTS `0_bank_accounts`;
CREATE TABLE `0_bank_accounts` (
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT '0',
  `bank_account_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_address` tinytext COLLATE utf8_unicode_ci,
  `bank_curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT '0',
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `bank_charge_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `bank_short_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_bank_accounts
-- ----------------------------
INSERT INTO 0_bank_accounts VALUES ('301', '3', 'Petty Cash', '', 'Petty Cash', null, 'LKR', '0', '2', '6403', '2016-11-09 00:00:00', '0', '0', 'PC');
INSERT INTO 0_bank_accounts VALUES ('1612', '0', 'National development Bank', '1010-000534-07', 'National development bank', null, 'LKR', '0', '4', '5431', '0000-00-00 00:00:00', '0', '0', '1612');
INSERT INTO 0_bank_accounts VALUES ('1613', '1', 'Standared Chartered Bank - Private Ledger', '', '', null, 'LKR', '0', '5', '4350', '0000-00-00 00:00:00', '0', '0', null);
INSERT INTO 0_bank_accounts VALUES ('1618', '0', 'Standered Charted Bank -General', '01119087301', 'Standered Charted Bank -General', 'Colombo', 'LKR', '0', '6', '5431', '0000-00-00 00:00:00', '0', '0', '1618');
INSERT INTO 0_bank_accounts VALUES ('1801', '3', 'Petty Cash', '', 'Petty Cash', '', 'LKR', '1', '7', '5431', '0000-00-00 00:00:00', '0', '0', '1801');

-- ----------------------------
-- Table structure for `0_bank_trans`
-- ----------------------------
DROP TABLE IF EXISTS `0_bank_trans`;
CREATE TABLE `0_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ref` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `person_type_id` int(11) NOT NULL DEFAULT '0',
  `person_id` tinyblob,
  `reconciled` date DEFAULT NULL,
  `pay_mode` int(1) DEFAULT NULL,
  `cheque_reference` int(10) DEFAULT NULL,
  `payment_increment` int(11) DEFAULT NULL,
  `payment_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_bank_trans
-- ----------------------------
INSERT INTO 0_bank_trans VALUES ('1', '1', '48', '4', 'P00004', '2017-05-09', '0', '0', '0', '3', 0x31, null, '0', '1', '1', '1612/05/2017/P/1');
INSERT INTO 0_bank_trans VALUES ('2', '4', '1', '4', 'T00001', '2017-01-06', '-50000', '0', '0', '0', 0x46726F6D204E6174696F6E616C20646576656C6F706D656E742042616E6B20546F2050657474792043617368, null, '0', '0', '0', '0');
INSERT INTO 0_bank_trans VALUES ('3', '4', '1', '2', 'T00001', '2017-01-06', '50000', '0', '0', '0', 0x46726F6D204E6174696F6E616C20646576656C6F706D656E742042616E6B20546F2050657474792043617368, null, '0', '0', '0', '0');
INSERT INTO 0_bank_trans VALUES ('4', '1', '49', '4', 'P00005', '2017-01-04', '-21000', '0', '0', '0', 0x4B2E2056616E6E69796173696E676865, null, '1', '1570', '2', '1612/06/2017/P/2');
INSERT INTO 0_bank_trans VALUES ('5', '1', '50', '4', 'P00006', '2017-01-04', '-27742', '0', '0', '0', 0x4520502053205420456469726973697269, null, '1', '1571', '3', '1612/06/2017/P/3');
INSERT INTO 0_bank_trans VALUES ('6', '1', '51', '4', 'P00007', '2017-01-04', '-23474', '0', '0', '0', 0x4B204720532052616A6173697269, null, '1', '1572', '4', '1612/06/2017/P/4');
INSERT INTO 0_bank_trans VALUES ('7', '1', '52', '4', 'P00008', '2017-01-09', '-108249', '0', '0', '0', 0x54686520436F6D6D697373696F6E65722047656E6572616C206F6620496E6C616E6420526576656E7565, null, '0', '1573', '5', '1612/06/2017/P/5');
INSERT INTO 0_bank_trans VALUES ('8', '1', '53', '4', 'P00009', '2017-01-10', '-34576', '0', '0', '0', 0x4E2053204E20456E746572707269736573, null, '0', '1575', '6', '1612/06/2017/P/6');
INSERT INTO 0_bank_trans VALUES ('9', '4', '2', '4', 'T00002', '2017-01-16', '-23037', '0', '0', '0', 0x46726F6D204E6174696F6E616C20646576656C6F706D656E742042616E6B20546F2050657474792043617368, null, '0', '0', '0', '0');
INSERT INTO 0_bank_trans VALUES ('10', '4', '2', '2', 'T00002', '2017-01-16', '23037', '0', '0', '0', 0x46726F6D204E6174696F6E616C20646576656C6F706D656E742042616E6B20546F2050657474792043617368, null, '0', '0', '0', '0');
INSERT INTO 0_bank_trans VALUES ('11', '1', '54', '4', 'P00010', '2017-01-17', '-392775.73', '0', '0', '0', 0x54686520436F6D6D697373696F6E65722047656E6572616C206F6620496E6C616E6420526576656E7565, null, '0', '1577', '7', '1612/06/2017/P/7');
INSERT INTO 0_bank_trans VALUES ('12', '1', '55', '4', 'P00011', '2017-01-17', '-52966.5', '0', '0', '0', 0x54686520436F6D6D697373696F6E65722047656E6572616C206F6620496E6C616E6420526576656E7565, null, '0', '1578', '8', '1612/06/2017/P/8');
INSERT INTO 0_bank_trans VALUES ('13', '1', '56', '4', 'P00012', '2017-01-18', '-221105', '0', '0', '0', 0x4B504D47, null, '1', '1580', '9', '1612/06/2017/P/9');
INSERT INTO 0_bank_trans VALUES ('14', '1', '57', '4', 'P00013', '2017-01-19', '-84007.16', '0', '0', '0', 0x432E572E4D61636B696520504C43, null, '0', '1581', '10', '1612/06/2017/P/10');
INSERT INTO 0_bank_trans VALUES ('15', '4', '3', '4', 'T00003', '2017-01-19', '-30000', '0', '0', '0', 0x46726F6D204E6174696F6E616C20646576656C6F706D656E742042616E6B20546F2050657474792043617368, null, '0', '0', '0', '0');
INSERT INTO 0_bank_trans VALUES ('16', '4', '3', '2', 'T00003', '2017-01-19', '30000', '0', '0', '0', 0x46726F6D204E6174696F6E616C20646576656C6F706D656E742042616E6B20546F2050657474792043617368, null, '0', '0', '0', '0');
INSERT INTO 0_bank_trans VALUES ('17', '1', '58', '4', 'P00014', '2017-01-24', '-77217', '0', '0', '0', 0x4520502053205420456469726973697269, null, '1', '1583', '11', '1612/06/2017/P/11');
INSERT INTO 0_bank_trans VALUES ('18', '1', '59', '4', 'P00015', '2017-01-24', '-42603.75', '0', '0', '0', 0x4B2E2056616E6E69796173696E676865, null, '1', '1584', '12', '1612/06/2017/P/12');
INSERT INTO 0_bank_trans VALUES ('19', '1', '60', '4', 'P00016', '2017-01-24', '-40905', '0', '0', '0', 0x4B204720532052616A6173697269, null, '1', '1585', '13', '1612/06/2017/P/13');
INSERT INTO 0_bank_trans VALUES ('20', '4', '4', '4', 'T00004', '2017-01-25', '-50000', '0', '0', '0', 0x46726F6D204E6174696F6E616C20646576656C6F706D656E742042616E6B20546F2050657474792043617368, null, '0', '0', '0', '0');
INSERT INTO 0_bank_trans VALUES ('21', '4', '4', '2', 'T00004', '2017-01-25', '50000', '0', '0', '0', 0x46726F6D204E6174696F6E616C20646576656C6F706D656E742042616E6B20546F2050657474792043617368, null, '0', '0', '0', '0');
INSERT INTO 0_bank_trans VALUES ('22', '1', '61', '4', 'P00017', '2017-01-26', '-1000', '0', '0', '0', 0x42616E6B2043686172676573, null, '0', '1586', '14', '1612/06/2017/P/14');
INSERT INTO 0_bank_trans VALUES ('23', '4', '5', '4', 'T00005', '2017-01-27', '-15000', '0', '0', '0', 0x46726F6D204E6174696F6E616C20646576656C6F706D656E742042616E6B20546F2050657474792043617368, null, '0', '0', '0', '0');
INSERT INTO 0_bank_trans VALUES ('24', '4', '5', '2', 'T00005', '2017-01-27', '15000', '0', '0', '0', 0x46726F6D204E6174696F6E616C20646576656C6F706D656E742042616E6B20546F2050657474792043617368, null, '0', '0', '0', '0');
INSERT INTO 0_bank_trans VALUES ('25', '4', '6', '4', 'T00006', '2017-01-31', '-22216', '0', '0', '0', 0x46726F6D204E6174696F6E616C20646576656C6F706D656E742042616E6B20546F2050657474792043617368, null, '0', '0', '0', '0');
INSERT INTO 0_bank_trans VALUES ('26', '4', '6', '2', 'T00006', '2017-01-31', '22216', '0', '0', '0', 0x46726F6D204E6174696F6E616C20646576656C6F706D656E742042616E6B20546F2050657474792043617368, null, '0', '0', '0', '0');

-- ----------------------------
-- Table structure for `0_bom`
-- ----------------------------
DROP TABLE IF EXISTS `0_bom`;
CREATE TABLE `0_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `component` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT '1',
  `budjet_cost` double NOT NULL,
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_bom
-- ----------------------------

-- ----------------------------
-- Table structure for `0_budget_trans`
-- ----------------------------
DROP TABLE IF EXISTS `0_budget_trans`;
CREATE TABLE `0_budget_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `dimension_id` int(11) DEFAULT '0',
  `dimension2_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_budget_trans
-- ----------------------------

-- ----------------------------
-- Table structure for `0_chart_class`
-- ----------------------------
DROP TABLE IF EXISTS `0_chart_class`;
CREATE TABLE `0_chart_class` (
  `cid` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `class_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_chart_class
-- ----------------------------
INSERT INTO 0_chart_class VALUES ('1', 'Assets', '1', '0');
INSERT INTO 0_chart_class VALUES ('2', 'Liabilities', '2', '0');
INSERT INTO 0_chart_class VALUES ('2.5', 'Equity ', '3', '0');
INSERT INTO 0_chart_class VALUES ('3', 'Income', '4', '0');
INSERT INTO 0_chart_class VALUES ('4', 'Expenses', '6', '0');

-- ----------------------------
-- Table structure for `0_chart_master`
-- ----------------------------
DROP TABLE IF EXISTS `0_chart_master`;
CREATE TABLE `0_chart_master` (
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_code2` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_chart_master
-- ----------------------------
INSERT INTO 0_chart_master VALUES ('1101', '', 'Land-Freehold Cost', '250', '0');
INSERT INTO 0_chart_master VALUES ('1102', '', 'Land-Leasehold Cost', '250', '0');
INSERT INTO 0_chart_master VALUES ('1103', '', 'Buildings', '250', '0');
INSERT INTO 0_chart_master VALUES ('1104', '', 'Motor Vehicles Cost', '250', '0');
INSERT INTO 0_chart_master VALUES ('1105', '', 'Plant Machinery - Cost', '250', '0');
INSERT INTO 0_chart_master VALUES ('1106', '', 'Radio Tele/Equipments', '250', '0');
INSERT INTO 0_chart_master VALUES ('1107', '', 'Computers', '250', '0');
INSERT INTO 0_chart_master VALUES ('1108', '', 'Tools &amp; Utencils', '250', '0');
INSERT INTO 0_chart_master VALUES ('1109', '', 'T.V.&amp; Other Equip.', '250', '0');
INSERT INTO 0_chart_master VALUES ('1110', '', 'Furniture &amp; Fittings', '250', '0');
INSERT INTO 0_chart_master VALUES ('1111', '', 'Capital Work In Prog', '250', '0');
INSERT INTO 0_chart_master VALUES ('1112', '', 'Land Freehold Valu', '250', '0');
INSERT INTO 0_chart_master VALUES ('1113', '', 'Land Leasehold Valu', '250', '0');
INSERT INTO 0_chart_master VALUES ('1114', '', 'Motor Vehicle-F/Lea', '250', '0');
INSERT INTO 0_chart_master VALUES ('1115', '', 'Plant &amp; Mac-F/Lease', '250', '0');
INSERT INTO 0_chart_master VALUES ('1201', '', 'C.W.Mackie &amp; Co Ltd', '350', '0');
INSERT INTO 0_chart_master VALUES ('1202', '', 'Scan Exports Ltd', '350', '0');
INSERT INTO 0_chart_master VALUES ('1203', '', 'Scan Consulate Ltd', '350', '0');
INSERT INTO 0_chart_master VALUES ('1204', '', 'Scan Ship Ltd', '350', '0');
INSERT INTO 0_chart_master VALUES ('1205', '', 'Mearsk Ship Ltd', '350', '0');
INSERT INTO 0_chart_master VALUES ('1206', '', 'G.S.C Ltd', '350', '0');
INSERT INTO 0_chart_master VALUES ('1207', '', 'K.C.F.M.C.Ltd', '350', '0');
INSERT INTO 0_chart_master VALUES ('1208', '', 'Maxkgrains Ltd', '350', '0');
INSERT INTO 0_chart_master VALUES ('1209', '', 'Orient Silver Co.Ltd', '350', '0');
INSERT INTO 0_chart_master VALUES ('1210', '', 'Ceytra Ltd', '350', '0');
INSERT INTO 0_chart_master VALUES ('1211', '', 'Scan Imports Ltd', '350', '0');
INSERT INTO 0_chart_master VALUES ('1212', '', 'Pelwate Sugar Co Ltd', '350', '0');
INSERT INTO 0_chart_master VALUES ('1213', '', 'Invest.at Value-subs', '350', '0');
INSERT INTO 0_chart_master VALUES ('1214', '', 'Invest.at Value-asso', '350', '0');
INSERT INTO 0_chart_master VALUES ('1215', '', 'Invest.at Value-Ceytra', '350', '0');
INSERT INTO 0_chart_master VALUES ('1250', '', 'Other Investments', '350', '0');
INSERT INTO 0_chart_master VALUES ('1331', '', 'Prepayments', '510', '0');
INSERT INTO 0_chart_master VALUES ('1332', '', 'Deposits', '510', '0');
INSERT INTO 0_chart_master VALUES ('1333', '', 'BIlls Recievable', '510', '0');
INSERT INTO 0_chart_master VALUES ('1335', '', 'Sundry Debtors', '510', '0');
INSERT INTO 0_chart_master VALUES ('1336', '', 'Advances', '510', '0');
INSERT INTO 0_chart_master VALUES ('1337', '', 'Interest In Suspense', '510', '0');
INSERT INTO 0_chart_master VALUES ('1338', '', 'T.V. Debtors', '510', '0');
INSERT INTO 0_chart_master VALUES ('1339', '', 'Salaries/Wages Cont', '510', '0');
INSERT INTO 0_chart_master VALUES ('1341', '', 'Deposits &amp; Securities', '710', '0');
INSERT INTO 0_chart_master VALUES ('1346', '', 'Dividend Recievable', '510', '0');
INSERT INTO 0_chart_master VALUES ('1349', '', 'Call Deposits at NDB', '710', '0');
INSERT INTO 0_chart_master VALUES ('1392', '', 'Mr . WTE-Personal A/C', '510', '0');
INSERT INTO 0_chart_master VALUES ('1393', '', 'CWM-Office Refur . Acc', '510', '0');
INSERT INTO 0_chart_master VALUES ('1394', '', 'MLPL-Directors&#039; Fees', '510', '0');
INSERT INTO 0_chart_master VALUES ('1395', '', 'Mr.K Ranum-Personal', '510', '0');
INSERT INTO 0_chart_master VALUES ('1396', '', 'C.W.Mackie PLC', '510', '0');
INSERT INTO 0_chart_master VALUES ('1400', '', 'VAT Control Account', '510', '0');
INSERT INTO 0_chart_master VALUES ('1401', '', 'C.W. Mackie (CP) Ltd', '550', '0');
INSERT INTO 0_chart_master VALUES ('1402', '', 'C.W.Mackie (NTP) Ltd', '550', '0');
INSERT INTO 0_chart_master VALUES ('1403', '', 'C.W.Mackie (MA) Ltd', '550', '0');
INSERT INTO 0_chart_master VALUES ('1404', '', 'Cocomac (PVT) Ltd', '550', '0');
INSERT INTO 0_chart_master VALUES ('1405', '', 'Mackgrains Ltd', '550', '0');
INSERT INTO 0_chart_master VALUES ('1406', '', 'C.W.Mackie (Agrol)Ltd', '550', '0');
INSERT INTO 0_chart_master VALUES ('1407', '', 'KCFM Company Ltd', '550', '0');
INSERT INTO 0_chart_master VALUES ('1408', '', 'Mackgrains(DB)Ltd', '550', '0');
INSERT INTO 0_chart_master VALUES ('1409', '', 'Dormant A/C Balances', '550', '0');
INSERT INTO 0_chart_master VALUES ('1410', '', 'Scan Tours &amp; Travels', '550', '0');
INSERT INTO 0_chart_master VALUES ('1411', '', 'C.W.M. Gratuity Fund', '550', '0');
INSERT INTO 0_chart_master VALUES ('1412', '', 'Scan IMP.Holdings Ltd', '550', '0');
INSERT INTO 0_chart_master VALUES ('1413', '', 'Scan Prod.Manuf. Ltd', '550', '0');
INSERT INTO 0_chart_master VALUES ('1414', '', 'CW.Mackie &amp; Co. Ltd', '550', '0');
INSERT INTO 0_chart_master VALUES ('1415', '', 'Ceytra Limited', '550', '0');
INSERT INTO 0_chart_master VALUES ('1416', '', 'G.S.C. CO. LTD.', '550', '0');
INSERT INTO 0_chart_master VALUES ('1417', '', 'Serendib Coconut', '550', '0');
INSERT INTO 0_chart_master VALUES ('1418', '', 'Maersk Lanka', '550', '0');
INSERT INTO 0_chart_master VALUES ('1420', '', 'Ceymac Rubber Co.', '550', '0');
INSERT INTO 0_chart_master VALUES ('1421', '', 'Prodcarry (CI)', '550', '0');
INSERT INTO 0_chart_master VALUES ('1422', '', 'Rubber Convertors', '550', '0');
INSERT INTO 0_chart_master VALUES ('1423', '', 'Woodmac Limited', '550', '0');
INSERT INTO 0_chart_master VALUES ('1424', '', 'Prodacarry (UK) Ltd', '550', '0');
INSERT INTO 0_chart_master VALUES ('1425', '', 'Ceylon Trading Co.', '550', '0');
INSERT INTO 0_chart_master VALUES ('1426', '', 'Orient Silver Co', '550', '0');
INSERT INTO 0_chart_master VALUES ('1427', '', 'Scan Exports Ltd', '550', '0');
INSERT INTO 0_chart_master VALUES ('1428', '', 'Asso Intercon Group', '550', '0');
INSERT INTO 0_chart_master VALUES ('1429', '', 'Scan Consultants ', '550', '0');
INSERT INTO 0_chart_master VALUES ('1430', '', 'Serendib_Commission ', '550', '0');
INSERT INTO 0_chart_master VALUES ('1501', '', 'Crc-R.S.S. Division', '550', '0');
INSERT INTO 0_chart_master VALUES ('1510', '', 'Inventory Account', '690', '0');
INSERT INTO 0_chart_master VALUES ('1612', '', 'National development bank', '700', '0');
INSERT INTO 0_chart_master VALUES ('1613', '', 'Standered Charted bank - Private', '700', '0');
INSERT INTO 0_chart_master VALUES ('1618', '', 'Standered Charted bank - General', '700', '0');
INSERT INTO 0_chart_master VALUES ('1801', '', 'Petty cash - Office', '700', '0');
INSERT INTO 0_chart_master VALUES ('1901', '', 'Loan-Scan Imports', '360', '0');
INSERT INTO 0_chart_master VALUES ('1902', '', 'Loan-K.C.F.M.C.Ltd', '360', '0');
INSERT INTO 0_chart_master VALUES ('1903', '', 'Loan-Serendib', '360', '0');
INSERT INTO 0_chart_master VALUES ('1904', '', 'Loan-Ceytra', '360', '0');
INSERT INTO 0_chart_master VALUES ('1905', '', 'Sub Loan-Aarhus Olie', '360', '0');
INSERT INTO 0_chart_master VALUES ('1906', '', 'Sub Loan -KCFMC', '360', '0');
INSERT INTO 0_chart_master VALUES ('1907', '', 'Loan-C W Mackie &amp; Co', '360', '0');
INSERT INTO 0_chart_master VALUES ('2102', '', 'Acc. Depn - F/Hold Cost', '260', '0');
INSERT INTO 0_chart_master VALUES ('2103', '', 'Acc.Dep-L/Hold Cost', '260', '0');
INSERT INTO 0_chart_master VALUES ('2104', '', 'Acc.Dep-Mv Cost', '260', '0');
INSERT INTO 0_chart_master VALUES ('2105', '', 'Acc.Dep-Plant Cost', '260', '0');
INSERT INTO 0_chart_master VALUES ('2106', '', 'Acc.Dep-Radio Tele', '260', '0');
INSERT INTO 0_chart_master VALUES ('2107', '', 'Acc.Dep-Computers', '260', '0');
INSERT INTO 0_chart_master VALUES ('2108', '', 'Acc Dep-Tools/Uten', '260', '0');
INSERT INTO 0_chart_master VALUES ('2109', '', 'Acc Dep-Tv &amp; Equip', '260', '0');
INSERT INTO 0_chart_master VALUES ('2110', '', 'Acc Depn-Furni.&amp; Fitt', '260', '0');
INSERT INTO 0_chart_master VALUES ('2111', '', 'Acc Depn F/Hold Valu', '260', '0');
INSERT INTO 0_chart_master VALUES ('2112', '', 'Acc Depn L/H Valu', '260', '0');
INSERT INTO 0_chart_master VALUES ('2113', '', 'Acc Depn Mv Lease', '260', '0');
INSERT INTO 0_chart_master VALUES ('2114', '', 'Acc Dep-P&amp;M F/Lease', '260', '0');
INSERT INTO 0_chart_master VALUES ('3101', '', 'Sundry Creditiors', '750', '0');
INSERT INTO 0_chart_master VALUES ('3102', '', 'Current Taxes', '850', '0');
INSERT INTO 0_chart_master VALUES ('3103', '', 'G.S.T Payable', '750', '0');
INSERT INTO 0_chart_master VALUES ('3104', '', 'Dividends', '850', '0');
INSERT INTO 0_chart_master VALUES ('3105', '', 'Commision Payable', '750', '0');
INSERT INTO 0_chart_master VALUES ('3106', '', 'Pre-Paid Advances', '750', '0');
INSERT INTO 0_chart_master VALUES ('3108', '', 'Accruals', '750', '0');
INSERT INTO 0_chart_master VALUES ('3109', '', 'Claims Payable', '750', '0');
INSERT INTO 0_chart_master VALUES ('3110', '', 'Expense Creditors', '750', '0');
INSERT INTO 0_chart_master VALUES ('3111', '', 'Union Fees', '750', '0');
INSERT INTO 0_chart_master VALUES ('3112', '', 'Funeral Aid', '750', '0');
INSERT INTO 0_chart_master VALUES ('3113', '', 'P.A.Y.E Tax People', '750', '0');
INSERT INTO 0_chart_master VALUES ('3114', '', 'E.P.F.-No 2 a/c', '750', '0');
INSERT INTO 0_chart_master VALUES ('3116', '', 'Group Insur.Scheme', '750', '0');
INSERT INTO 0_chart_master VALUES ('3117', '', 'Sports Club', '750', '0');
INSERT INTO 0_chart_master VALUES ('3118', '', 'Thirft Society', '750', '0');
INSERT INTO 0_chart_master VALUES ('3119', '', 'Bonus Payable', '750', '0');
INSERT INTO 0_chart_master VALUES ('3120', '', 'Workmen Compensation', '750', '0');
INSERT INTO 0_chart_master VALUES ('3126', '', 'A O Current Accounts', '750', '0');
INSERT INTO 0_chart_master VALUES ('3127', '', 'Medical Fund', '750', '0');
INSERT INTO 0_chart_master VALUES ('3128', '', 'Distress Loan Fund', '750', '0');
INSERT INTO 0_chart_master VALUES ('3130', '', 'Trade Creditiors', '750', '0');
INSERT INTO 0_chart_master VALUES ('3136', '', 'Withholding Tax Paya', '750', '0');
INSERT INTO 0_chart_master VALUES ('3401', '', 'Pro.for Bad Debts Tv', '750', '0');
INSERT INTO 0_chart_master VALUES ('3402', '', 'Pro.For Bad Debts Mi', '750', '0');
INSERT INTO 0_chart_master VALUES ('3403', '', 'Provision for Gratuity', '995', '0');
INSERT INTO 0_chart_master VALUES ('3404', '', 'Pro.For Invest.W/Off', '350', '0');
INSERT INTO 0_chart_master VALUES ('4151', '', 'Donation', '7', '0');
INSERT INTO 0_chart_master VALUES ('4152', '', 'Directors Traveling', '7', '0');
INSERT INTO 0_chart_master VALUES ('4153', '', 'Newspapers &amp; Periodicals', '7', '0');
INSERT INTO 0_chart_master VALUES ('4154', '', 'Seasonal Gift', '7', '0');
INSERT INTO 0_chart_master VALUES ('4155', '', 'Television Bill', '7', '0');
INSERT INTO 0_chart_master VALUES ('4156', '', 'Depreciation', '7', '0');
INSERT INTO 0_chart_master VALUES ('4157', '', 'Company Registration Fees', '7', '0');
INSERT INTO 0_chart_master VALUES ('4158', '', 'Secretarial Fees', '7', '0');
INSERT INTO 0_chart_master VALUES ('4159', '', 'Gratuity', '7', '0');
INSERT INTO 0_chart_master VALUES ('4160', '', 'Overtime', '7', '0');
INSERT INTO 0_chart_master VALUES ('4161', '', 'Surcharge', '7', '0');
INSERT INTO 0_chart_master VALUES ('4162', '', 'Entertaining Charges ', '7', '0');
INSERT INTO 0_chart_master VALUES ('4163', '', 'Tea Expenses', '7', '0');
INSERT INTO 0_chart_master VALUES ('4164', '', 'Office Cleaning Expenses', '7', '0');
INSERT INTO 0_chart_master VALUES ('4165', '', 'Traveling expenses', '7', '0');
INSERT INTO 0_chart_master VALUES ('4166', '', 'Salary', '7', '0');
INSERT INTO 0_chart_master VALUES ('4300', '', 'Capital Reserve', '100', '0');
INSERT INTO 0_chart_master VALUES ('4350', '', 'Bank Charges', '9', '0');
INSERT INTO 0_chart_master VALUES ('4400', '', 'Property Dev Reserve', '150', '0');
INSERT INTO 0_chart_master VALUES ('4450', '', 'Stamp Duty', '650', '0');
INSERT INTO 0_chart_master VALUES ('4600', '', 'General Reserve', '150', '0');
INSERT INTO 0_chart_master VALUES ('4601', '', 'Revenue Reserve', '150', '0');
INSERT INTO 0_chart_master VALUES ('4700', '', 'Profit &amp; Loss Appon', '160', '0');
INSERT INTO 0_chart_master VALUES ('4701', '', 'Retained Earn - MLPL', '160', '0');
INSERT INTO 0_chart_master VALUES ('4702', '', 'Retained Earn - Ceytra', '160', '0');
INSERT INTO 0_chart_master VALUES ('4800', '', 'Invs.Rev.Reserve', '150', '0');
INSERT INTO 0_chart_master VALUES ('5307', '', 'Travelling &amp; Subsistance', '600', '0');
INSERT INTO 0_chart_master VALUES ('5308', '', 'Stores Rent', '560', '0');
INSERT INTO 0_chart_master VALUES ('5309', '', 'Transport', '560', '0');
INSERT INTO 0_chart_master VALUES ('5312', '', 'Shipping &amp; Handl Chg', '560', '0');
INSERT INTO 0_chart_master VALUES ('5315', '', 'Claims', '560', '0');
INSERT INTO 0_chart_master VALUES ('5316', '', 'Postages &amp; Telegrams', '560', '0');
INSERT INTO 0_chart_master VALUES ('5317', '', 'Insurance', '560', '0');
INSERT INTO 0_chart_master VALUES ('5318', '', 'Export Expenses', '560', '0');
INSERT INTO 0_chart_master VALUES ('5319', '', 'Commision', '560', '0');
INSERT INTO 0_chart_master VALUES ('5320', '', 'Others', '560', '0');
INSERT INTO 0_chart_master VALUES ('5321', '', 'Sals Promotion', '560', '0');
INSERT INTO 0_chart_master VALUES ('5322', '', 'Advertising', '560', '0');
INSERT INTO 0_chart_master VALUES ('5401', '', 'Salaries', '650', '0');
INSERT INTO 0_chart_master VALUES ('5402', '', 'Bonus', '650', '0');
INSERT INTO 0_chart_master VALUES ('5403', '', 'M S P S, E P F,E T F', '650', '0');
INSERT INTO 0_chart_master VALUES ('5406', '', 'Welfare', '650', '0');
INSERT INTO 0_chart_master VALUES ('5407', '', 'Gratuity', '650', '0');
INSERT INTO 0_chart_master VALUES ('5408', '', 'Director&#039;s Fees', '650', '0');
INSERT INTO 0_chart_master VALUES ('5410', '', 'Rent', '650', '0');
INSERT INTO 0_chart_master VALUES ('5411', '', 'Audit Fees', '650', '0');
INSERT INTO 0_chart_master VALUES ('5412', '', 'Accounting Charges', '650', '0');
INSERT INTO 0_chart_master VALUES ('5414', '', 'Computer Expenses', '650', '0');
INSERT INTO 0_chart_master VALUES ('5415', '', 'Travelling &amp; Subsistance', '600', '0');
INSERT INTO 0_chart_master VALUES ('5416', '', 'Staff Training', '650', '0');
INSERT INTO 0_chart_master VALUES ('5417', '', 'Depreciation', '650', '0');
INSERT INTO 0_chart_master VALUES ('5418', '', 'Building Repairs/Mai', '650', '0');
INSERT INTO 0_chart_master VALUES ('5419', '', 'Office Equipment Mai', '650', '0');
INSERT INTO 0_chart_master VALUES ('5420', '', 'Insurance', '650', '0');
INSERT INTO 0_chart_master VALUES ('5423', '', 'General Trade Expens', '650', '0');
INSERT INTO 0_chart_master VALUES ('5424', '', 'Telephone', '650', '0');
INSERT INTO 0_chart_master VALUES ('5425', '', 'Electricity Charges', '650', '0');
INSERT INTO 0_chart_master VALUES ('5426', '', 'Water Charges', '650', '0');
INSERT INTO 0_chart_master VALUES ('5427', '', 'Property Taxes/Rates', '650', '0');
INSERT INTO 0_chart_master VALUES ('5428', '', 'Secretarial Expenses', '650', '0');
INSERT INTO 0_chart_master VALUES ('5431', '', 'Bank Charges', '650', '0');
INSERT INTO 0_chart_master VALUES ('5434', '', 'Meals &amp; Tea', '650', '0');
INSERT INTO 0_chart_master VALUES ('5435', '', 'Postage &amp; Telegrams', '650', '0');
INSERT INTO 0_chart_master VALUES ('5436', '', 'Telex Charges', '650', '0');
INSERT INTO 0_chart_master VALUES ('5437', '', 'Motor Vehicle Workin', '600', '0');
INSERT INTO 0_chart_master VALUES ('5438', '', 'Printing &amp; Stationer', '650', '0');
INSERT INTO 0_chart_master VALUES ('5439', '', 'Entertainment', '650', '0');
INSERT INTO 0_chart_master VALUES ('5440', '', 'Trade Subscription', '600', '0');
INSERT INTO 0_chart_master VALUES ('5441', '', 'Donations', '650', '0');
INSERT INTO 0_chart_master VALUES ('5442', '', 'Security', '650', '0');
INSERT INTO 0_chart_master VALUES ('5443', '', 'Legal Expenses', '650', '0');
INSERT INTO 0_chart_master VALUES ('5444', '', 'Management Fees', '650', '0');
INSERT INTO 0_chart_master VALUES ('5447', '', 'Misc Office Expenses', '650', '0');
INSERT INTO 0_chart_master VALUES ('5451', '', 'Bungalow Expenses', '650', '0');
INSERT INTO 0_chart_master VALUES ('5452', '', 'Administration', '650', '0');
INSERT INTO 0_chart_master VALUES ('5453', '', 'Professional Fees', '650', '0');
INSERT INTO 0_chart_master VALUES ('5454', '', 'Bunglow Exps-Digana', '650', '0');
INSERT INTO 0_chart_master VALUES ('5455', '', 'Bunglow Exps-N&#039;Eliya', '7', '0');
INSERT INTO 0_chart_master VALUES ('5456', '', 'Bunglow Exps-Ceytra', '650', '0');
INSERT INTO 0_chart_master VALUES ('5457', '', 'Pension Fund', '650', '0');
INSERT INTO 0_chart_master VALUES ('5458', '', 'Secretarial Fees', '650', '0');
INSERT INTO 0_chart_master VALUES ('5459', '', 'Human Resou.Develop.', '650', '0');
INSERT INTO 0_chart_master VALUES ('5501', '', 'Advertising', '650', '0');
INSERT INTO 0_chart_master VALUES ('5502', '', 'Export Expenses', '600', '0');
INSERT INTO 0_chart_master VALUES ('5503', '', 'Business Meeting', '600', '0');
INSERT INTO 0_chart_master VALUES ('5504', '', 'Bad Debts', '600', '0');
INSERT INTO 0_chart_master VALUES ('5505', '', 'Salaries', '600', '0');
INSERT INTO 0_chart_master VALUES ('5506', '', 'MSPS &amp; ETF', '600', '0');
INSERT INTO 0_chart_master VALUES ('5507', '', 'Sales Div - Rent/E1/Wa', '600', '0');
INSERT INTO 0_chart_master VALUES ('5508', '', 'Vehicle Maint/travel', '600', '0');
INSERT INTO 0_chart_master VALUES ('5516', '', 'Investment Write off', '600', '0');
INSERT INTO 0_chart_master VALUES ('5601', '', 'External Interest', '730', '0');
INSERT INTO 0_chart_master VALUES ('5602', '', 'Internal Interest', '730', '0');
INSERT INTO 0_chart_master VALUES ('5703', '', 'P/L on Sale o F/A', '720', '0');
INSERT INTO 0_chart_master VALUES ('5705', '', 'Fixed Assets Disposa', '720', '0');
INSERT INTO 0_chart_master VALUES ('5706', '', 'Exchange Rate Differ', '800', '0');
INSERT INTO 0_chart_master VALUES ('5708', '', 'P/L Sale of Investme', '720', '0');
INSERT INTO 0_chart_master VALUES ('5709', '', 'Sale of Investment', '850', '0');
INSERT INTO 0_chart_master VALUES ('5720', '', 'Exceptional Items', '850', '0');
INSERT INTO 0_chart_master VALUES ('5801', '', 'Income Tax/Surcharge', '800', '0');
INSERT INTO 0_chart_master VALUES ('5901', '', 'Currency Gain/Loss', '800', '0');
INSERT INTO 0_chart_master VALUES ('6103', '', 'Group Sales - Scan', '50', '0');
INSERT INTO 0_chart_master VALUES ('6104', '', 'Group Sales - CWM', '50', '0');
INSERT INTO 0_chart_master VALUES ('6105', '', 'Group Sales - CTC', '50', '0');
INSERT INTO 0_chart_master VALUES ('6108', '', 'Group Sec Income CTC', '720', '0');
INSERT INTO 0_chart_master VALUES ('6167', '', 'Advertisment Charges', '7', '0');
INSERT INTO 0_chart_master VALUES ('6168', '', 'Bonus &amp; Exgratia', '7', '0');
INSERT INTO 0_chart_master VALUES ('6169', '', 'Compensation', '7', '0');
INSERT INTO 0_chart_master VALUES ('6170', '', 'Electricity', '7', '0');
INSERT INTO 0_chart_master VALUES ('6171', '', 'Employees Trust Fund', '7', '0');
INSERT INTO 0_chart_master VALUES ('6172', '', 'Income Tax', '7', '0');
INSERT INTO 0_chart_master VALUES ('6173', '', 'Insurance', '7', '0');
INSERT INTO 0_chart_master VALUES ('6174', '', 'Newspaper &amp; Periodicals', '7', '0');
INSERT INTO 0_chart_master VALUES ('6175', '', 'Office Equipment Maintenance', '7', '0');
INSERT INTO 0_chart_master VALUES ('6176', '', 'Office Expenses', '7', '0');
INSERT INTO 0_chart_master VALUES ('6177', '', 'Postage', '7', '0');
INSERT INTO 0_chart_master VALUES ('6178', '', 'Employees Provident Fund', '7', '0');
INSERT INTO 0_chart_master VALUES ('6179', '', 'Printing &amp; Stationery', '7', '0');
INSERT INTO 0_chart_master VALUES ('6180', '', 'Professional Fees', '7', '0');
INSERT INTO 0_chart_master VALUES ('6181', '', 'Reimbursement of Traveling', '7', '0');
INSERT INTO 0_chart_master VALUES ('6182', '', 'Reimbursement of Mobile Charges', '7', '0');
INSERT INTO 0_chart_master VALUES ('6183', '', 'Staff Welfare', '7', '0');
INSERT INTO 0_chart_master VALUES ('6184', '', 'Sundry Expenses', '7', '0');
INSERT INTO 0_chart_master VALUES ('6185', '', 'Telephone Charges', '7', '0');
INSERT INTO 0_chart_master VALUES ('6186', '', 'Water', '7', '0');
INSERT INTO 0_chart_master VALUES ('6302', '', 'Rent Received', '720', '0');
INSERT INTO 0_chart_master VALUES ('6305', '', 'Interest Income-Inte', '730', '0');
INSERT INTO 0_chart_master VALUES ('6306', '', 'Interest Income-Exte', '720', '0');
INSERT INTO 0_chart_master VALUES ('6307', '', 'Other Income', '720', '0');
INSERT INTO 0_chart_master VALUES ('6308', '', 'Income-Professi.Serv', '720', '0');
INSERT INTO 0_chart_master VALUES ('6401', '', 'Sundry Dividents', '720', '0');
INSERT INTO 0_chart_master VALUES ('6402', '', 'Dividend Recd Subsi', '720', '0');
INSERT INTO 0_chart_master VALUES ('6403', '', 'Debit Tax', '730', '0');
INSERT INTO 0_chart_master VALUES ('6450', '', 'Associate co.profits', '720', '0');
INSERT INTO 0_chart_master VALUES ('8000', '', 'Profit &amp; Loss B.FWD.', '160', '0');

-- ----------------------------
-- Table structure for `0_chart_types`
-- ----------------------------
DROP TABLE IF EXISTS `0_chart_types`;
CREATE TABLE `0_chart_types` (
  `id` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `class_id` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '-1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_chart_types
-- ----------------------------
INSERT INTO 0_chart_types VALUES ('100', 'Equity ', '2.5', '', '0');
INSERT INTO 0_chart_types VALUES ('150', 'Reserve &amp; Surpuls', '2.5', '', '0');
INSERT INTO 0_chart_types VALUES ('160', 'Retained Earnings', '2.5', '', '0');
INSERT INTO 0_chart_types VALUES ('250', 'Fixed Assets', '1', '', '0');
INSERT INTO 0_chart_types VALUES ('260', 'Accumulated Depreciation', '1', '', '0');
INSERT INTO 0_chart_types VALUES ('350', 'Investments', '1', '', '0');
INSERT INTO 0_chart_types VALUES ('360', 'Term Loan  Receivables', '1', '', '0');
INSERT INTO 0_chart_types VALUES ('50', 'Turnover', '3', '', '0');
INSERT INTO 0_chart_types VALUES ('510', 'Accounts  Receivables', '1', '', '0');
INSERT INTO 0_chart_types VALUES ('550', 'Intercompany Balances', '1', '', '0');
INSERT INTO 0_chart_types VALUES ('560', 'Operating Expenses', '4', '', '0');
INSERT INTO 0_chart_types VALUES ('600', 'Selling Expenses', '4', '', '0');
INSERT INTO 0_chart_types VALUES ('650', 'Administration Expenses', '4', '', '0');
INSERT INTO 0_chart_types VALUES ('690', 'Inventory', '1', '', '0');
INSERT INTO 0_chart_types VALUES ('7', 'Administrative Expenses', '4', '', '0');
INSERT INTO 0_chart_types VALUES ('700', 'Cash &amp; Cash Equivalents', '1', '', '0');
INSERT INTO 0_chart_types VALUES ('710', 'Fixed Deposits', '1', '', '0');
INSERT INTO 0_chart_types VALUES ('720', 'Other Income', '3', '', '0');
INSERT INTO 0_chart_types VALUES ('730', 'Interest Expense', '4', '', '0');
INSERT INTO 0_chart_types VALUES ('750', 'Accounts Payable', '2', '', '0');
INSERT INTO 0_chart_types VALUES ('800', 'Exchange Gain/(Loss)', '4', '', '0');
INSERT INTO 0_chart_types VALUES ('850', 'Taxation', '4', '', '0');
INSERT INTO 0_chart_types VALUES ('9', 'Finance Cost', '4', '', '0');
INSERT INTO 0_chart_types VALUES ('995', 'Long Term Liabilities', '2', '', '0');

-- ----------------------------
-- Table structure for `0_comments`
-- ----------------------------
DROP TABLE IF EXISTS `0_comments`;
CREATE TABLE `0_comments` (
  `type` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_comments
-- ----------------------------
INSERT INTO 0_comments VALUES ('4', '1', '2017-01-06', 'Petty Cash Expenses');
INSERT INTO 0_comments VALUES ('4', '2', '2017-01-16', 'Petty Cash Expenses');
INSERT INTO 0_comments VALUES ('4', '3', '2017-01-19', 'Petty Cash Expenses');
INSERT INTO 0_comments VALUES ('4', '4', '2017-01-25', 'petty Cash Expenses');
INSERT INTO 0_comments VALUES ('4', '5', '2017-01-27', 'Petty Cash Expenses');
INSERT INTO 0_comments VALUES ('4', '6', '2017-01-31', 'Petty Cash Expenses');

-- ----------------------------
-- Table structure for `0_credit_status`
-- ----------------------------
DROP TABLE IF EXISTS `0_credit_status`;
CREATE TABLE `0_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_credit_status
-- ----------------------------
INSERT INTO 0_credit_status VALUES ('1', 'Good History', '0', '0');
INSERT INTO 0_credit_status VALUES ('3', 'No more work until payment received', '1', '0');
INSERT INTO 0_credit_status VALUES ('4', 'In liquidation', '1', '0');

-- ----------------------------
-- Table structure for `0_crm_categories`
-- ----------------------------
DROP TABLE IF EXISTS `0_crm_categories`;
CREATE TABLE `0_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `system` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_crm_categories
-- ----------------------------
INSERT INTO 0_crm_categories VALUES ('1', 'cust_branch', 'general', 'General', 'General contact data for customer branch (overrides company setting)', '1', '0');
INSERT INTO 0_crm_categories VALUES ('2', 'cust_branch', 'invoice', 'Invoices', 'Invoice posting (overrides company setting)', '1', '0');
INSERT INTO 0_crm_categories VALUES ('3', 'cust_branch', 'order', 'Orders', 'Order confirmation (overrides company setting)', '1', '0');
INSERT INTO 0_crm_categories VALUES ('4', 'cust_branch', 'delivery', 'Deliveries', 'Delivery coordination (overrides company setting)', '1', '0');
INSERT INTO 0_crm_categories VALUES ('5', 'customer', 'general', 'General', 'General contact data for customer', '1', '0');
INSERT INTO 0_crm_categories VALUES ('6', 'customer', 'order', 'Orders', 'Order confirmation', '1', '0');
INSERT INTO 0_crm_categories VALUES ('7', 'customer', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0');
INSERT INTO 0_crm_categories VALUES ('8', 'customer', 'invoice', 'Invoices', 'Invoice posting', '1', '0');
INSERT INTO 0_crm_categories VALUES ('9', 'supplier', 'general', 'General', 'General contact data for supplier', '1', '0');
INSERT INTO 0_crm_categories VALUES ('10', 'supplier', 'order', 'Orders', 'Order confirmation', '1', '0');
INSERT INTO 0_crm_categories VALUES ('11', 'supplier', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0');
INSERT INTO 0_crm_categories VALUES ('12', 'supplier', 'invoice', 'Invoices', 'Invoice posting', '1', '0');

-- ----------------------------
-- Table structure for `0_crm_contacts`
-- ----------------------------
DROP TABLE IF EXISTS `0_crm_contacts`;
CREATE TABLE `0_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT '0' COMMENT 'foreign key to crm_contacts',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `entity_id` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_crm_contacts
-- ----------------------------
INSERT INTO 0_crm_contacts VALUES ('1', '1', 'cust_branch', 'general', '1');
INSERT INTO 0_crm_contacts VALUES ('2', '1', 'customer', 'general', '1');

-- ----------------------------
-- Table structure for `0_crm_persons`
-- ----------------------------
DROP TABLE IF EXISTS `0_crm_persons`;
CREATE TABLE `0_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `name2` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` tinytext COLLATE utf8_unicode_ci,
  `phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone2` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lang` char(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_crm_persons
-- ----------------------------
INSERT INTO 0_crm_persons VALUES ('1', 'C W MAKEE', 'C W MAKEE', '', 'COLOMBO', '', '', '', '', '', '', '0');

-- ----------------------------
-- Table structure for `0_currencies`
-- ----------------------------
DROP TABLE IF EXISTS `0_currencies`;
CREATE TABLE `0_currencies` (
  `currency` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `auto_update` tinyint(1) NOT NULL DEFAULT '1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_currencies
-- ----------------------------
INSERT INTO 0_currencies VALUES ('Sri Lanka Rupee', 'LKR', 'Rs', 'Sri Lanka', 'Cents', '1', '0');

-- ----------------------------
-- Table structure for `0_cust_allocations`
-- ----------------------------
DROP TABLE IF EXISTS `0_cust_allocations`;
CREATE TABLE `0_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_cust_allocations
-- ----------------------------

-- ----------------------------
-- Table structure for `0_cust_branch`
-- ----------------------------
DROP TABLE IF EXISTS `0_cust_branch`;
CREATE TABLE `0_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `br_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `branch_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `br_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT '0',
  `default_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `receivables_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT '1',
  `br_post_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT '0',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `bank_account` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_cust_branch
-- ----------------------------
INSERT INTO 0_cust_branch VALUES ('1', '1', 'C W MAKEE', 'C W MAKEE', 'COLOMBO', '2', '3', 'LOC', '1', '', '4510', '1200', '4500', '1', 'COLOMBO', '0', '', null, '0');

-- ----------------------------
-- Table structure for `0_debtors_master`
-- ----------------------------
DROP TABLE IF EXISTS `0_debtors_master`;
CREATE TABLE `0_debtors_master` (
  `debtor_no` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `debtor_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `address` tinytext COLLATE utf8_unicode_ci,
  `tax_id` varchar(55) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type` int(11) NOT NULL DEFAULT '1',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `credit_status` int(11) NOT NULL DEFAULT '0',
  `payment_terms` int(11) DEFAULT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `pymt_discount` double NOT NULL DEFAULT '0',
  `credit_limit` float NOT NULL DEFAULT '1000',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `crm_no` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`debtor_no`),
  UNIQUE KEY `debtor_ref` (`debtor_ref`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_debtors_master
-- ----------------------------
INSERT INTO 0_debtors_master VALUES ('1', 'C W MAKEE', 'C W MAKEE', 'COLOMBO', '', 'LKR', '1', '0', '0', '1', '1', '0', '0', '1000000', '', '0', '');

-- ----------------------------
-- Table structure for `0_debtor_trans`
-- ----------------------------
DROP TABLE IF EXISTS `0_debtor_trans`;
CREATE TABLE `0_debtor_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `version` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `debtor_no` int(11) unsigned NOT NULL,
  `branch_code` int(11) NOT NULL DEFAULT '-1',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT '0',
  `order_` int(11) NOT NULL DEFAULT '0',
  `ov_amount` double NOT NULL DEFAULT '0',
  `ov_gst` double NOT NULL DEFAULT '0',
  `ov_freight` double NOT NULL DEFAULT '0',
  `ov_freight_tax` double NOT NULL DEFAULT '0',
  `ov_discount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  `ship_via` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `done_by` int(2) DEFAULT NULL,
  PRIMARY KEY (`type`,`trans_no`,`debtor_no`),
  KEY `debtor_no` (`debtor_no`,`branch_code`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_debtor_trans
-- ----------------------------
INSERT INTO 0_debtor_trans VALUES ('1', '10', '0', '1', '1', '2017-04-26', '2017-04-26', 'S0001', '1', '1', '150000', '0', '0', '0', '0', '150000', '0', '1', '1', '0', '0', '1', '1', null);
INSERT INTO 0_debtor_trans VALUES ('2', '10', '0', '1', '1', '2017-04-27', '2017-04-27', 'S0002', '1', '2', '1000', '173', '0', '0', '0', '1173', '0', '1', '1', '0', '0', '1', '1', null);
INSERT INTO 0_debtor_trans VALUES ('3', '10', '0', '1', '1', '2017-04-27', '2017-04-27', 'S0003', '1', '3', '1000', '132.2', '0', '0', '0', '1132.2', '0', '1', '1', '0', '0', '1', '0', null);
INSERT INTO 0_debtor_trans VALUES ('1', '12', '0', '1', '1', '2017-04-26', '0000-00-00', '', '0', '0', '150000', '0', '0', '0', '0', '150000', '0', '1', '0', '0', '0', null, '0', null);
INSERT INTO 0_debtor_trans VALUES ('2', '12', '0', '1', '1', '2017-04-27', '0000-00-00', '', '0', '0', '1173', '0', '0', '0', '0', '1173', '0', '1', '0', '0', '0', null, '0', null);
INSERT INTO 0_debtor_trans VALUES ('3', '12', '0', '1', '1', '2017-04-27', '0000-00-00', '', '0', '0', '1132.2', '0', '0', '0', '0', '1132.2', '0', '1', '0', '0', '0', null, '0', null);
INSERT INTO 0_debtor_trans VALUES ('1', '13', '1', '1', '1', '2017-04-26', '2017-04-26', 'auto', '1', '1', '150000', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '1', null);
INSERT INTO 0_debtor_trans VALUES ('2', '13', '1', '1', '1', '2017-04-27', '2017-04-27', 'auto', '1', '2', '1000', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '1', null);
INSERT INTO 0_debtor_trans VALUES ('3', '13', '1', '1', '1', '2017-04-27', '2017-04-27', 'auto', '1', '3', '1000', '132.2', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0', null);

-- ----------------------------
-- Table structure for `0_debtor_trans_details`
-- ----------------------------
DROP TABLE IF EXISTS `0_debtor_trans_details`;
CREATE TABLE `0_debtor_trans_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_trans_no` int(11) DEFAULT NULL,
  `debtor_trans_type` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `unit_price` double NOT NULL DEFAULT '0',
  `unit_tax` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `discount_percent` double NOT NULL DEFAULT '0',
  `standard_cost` double NOT NULL DEFAULT '0',
  `qty_done` double NOT NULL DEFAULT '0',
  `src_id` int(11) NOT NULL,
  `done_by` int(2) DEFAULT NULL,
  `line_location` char(15) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`debtor_trans_type`,`debtor_trans_no`),
  KEY `src_id` (`src_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_debtor_trans_details
-- ----------------------------
INSERT INTO 0_debtor_trans_details VALUES ('1', '1', '13', '01', 'Management Service', '150000', '0', '1', '0', '0', '1', '1', null, '');
INSERT INTO 0_debtor_trans_details VALUES ('2', '1', '10', '01', 'Management Service', '150000', '0', '1', '0', '0', '0', '1', null, '');
INSERT INTO 0_debtor_trans_details VALUES ('3', '2', '13', '01', 'Management Service', '1000', '173', '1', '0', '0', '1', '2', null, '');
INSERT INTO 0_debtor_trans_details VALUES ('4', '2', '10', '01', 'Management Service', '1000', '173', '1', '0', '0', '0', '3', null, '');
INSERT INTO 0_debtor_trans_details VALUES ('5', '3', '13', '01', 'Management Service', '1000', '132.2', '1', '0', '0', '1', '3', null, '');
INSERT INTO 0_debtor_trans_details VALUES ('6', '3', '10', '01', 'Management Service', '1000', '132.2', '1', '0', '0', '0', '5', null, '');

-- ----------------------------
-- Table structure for `0_dimensions`
-- ----------------------------
DROP TABLE IF EXISTS `0_dimensions`;
CREATE TABLE `0_dimensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_` tinyint(1) NOT NULL DEFAULT '1',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  KEY `date_` (`date_`),
  KEY `due_date` (`due_date`),
  KEY `type_` (`type_`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_dimensions
-- ----------------------------
INSERT INTO 0_dimensions VALUES ('1', '00001', 'Golden Palm Rest', '1', '0', '2016-09-23', '2016-10-13');

-- ----------------------------
-- Table structure for `0_exchange_rates`
-- ----------------------------
DROP TABLE IF EXISTS `0_exchange_rates`;
CREATE TABLE `0_exchange_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rate_buy` double NOT NULL DEFAULT '0',
  `rate_sell` double NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `curr_code` (`curr_code`,`date_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_exchange_rates
-- ----------------------------

-- ----------------------------
-- Table structure for `0_fiscal_year`
-- ----------------------------
DROP TABLE IF EXISTS `0_fiscal_year`;
CREATE TABLE `0_fiscal_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `begin` date DEFAULT '0000-00-00',
  `end` date DEFAULT '0000-00-00',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `begin` (`begin`),
  UNIQUE KEY `end` (`end`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_fiscal_year
-- ----------------------------
INSERT INTO 0_fiscal_year VALUES ('1', '2015-01-01', '2015-12-31', '0');
INSERT INTO 0_fiscal_year VALUES ('2', '2016-04-01', '2016-12-31', '0');
INSERT INTO 0_fiscal_year VALUES ('3', '2017-01-01', '2017-12-31', '0');

-- ----------------------------
-- Table structure for `0_gl_trans`
-- ----------------------------
DROP TABLE IF EXISTS `0_gl_trans`;
CREATE TABLE `0_gl_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT '0',
  `type_no` int(11) NOT NULL DEFAULT '0',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `amount` double NOT NULL DEFAULT '0',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob,
  `cheque_no` int(6) DEFAULT NULL,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `dimension_id` (`dimension_id`),
  KEY `dimension2_id` (`dimension2_id`),
  KEY `tran_date` (`tran_date`),
  KEY `account_and_tran_date` (`account`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_gl_trans
-- ----------------------------
INSERT INTO 0_gl_trans VALUES ('1', '1', '44', '2017-04-04', '1101', '', '10', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('2', '1', '44', '2017-04-04', '1612', '', '-10', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('3', '1', '45', '2017-04-04', '1101', '', '45', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('4', '1', '45', '2017-04-04', '1613', '', '-45', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('5', '1', '46', '2017-04-06', '5441', 'Donation', '1500000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('6', '1', '46', '2017-04-06', '1613', '', '-1500000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('7', '1', '47', '2017-04-26', '5453', 'CONSULTANCY FEES', '0', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('8', '1', '47', '2017-04-26', '1613', '', '0', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('9', '1', '48', '2017-04-26', '5453', 'CONSULTANCY FEES', '0', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('10', '1', '48', '2017-04-26', '1613', '', '0', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('11', '10', '1', '2017-04-26', '6108', '', '-150000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('12', '10', '1', '2017-04-26', '1200', '', '150000', '0', '0', '2', 0x31, null);
INSERT INTO 0_gl_trans VALUES ('13', '12', '1', '2017-04-26', '301', '', '150000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('14', '12', '1', '2017-04-26', '1200', '', '-150000', '0', '0', '2', 0x31, null);
INSERT INTO 0_gl_trans VALUES ('15', '10', '2', '2017-04-27', '6108', '', '-854.7', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('16', '10', '2', '2017-04-27', '1200', '', '1173', '0', '0', '2', 0x31, null);
INSERT INTO 0_gl_trans VALUES ('17', '10', '2', '2017-04-27', '1112', '', '-20', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('18', '10', '2', '2017-04-27', '1101', '', '-153', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('19', '10', '2', '2017-04-27', '4450', '', '-145.3', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('20', '12', '2', '2017-04-27', '301', '', '1173', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('21', '12', '2', '2017-04-27', '1200', '', '-1173', '0', '0', '2', 0x31, null);
INSERT INTO 0_gl_trans VALUES ('22', '10', '3', '2017-04-27', '6108', '', '-1000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('23', '10', '3', '2017-04-27', '1200', '', '1132.2', '0', '0', '2', 0x31, null);
INSERT INTO 0_gl_trans VALUES ('24', '10', '3', '2017-04-27', '1101', '', '-20', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('25', '10', '3', '2017-04-27', '1112', '', '-112.2', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('26', '12', '3', '2017-04-27', '301', '', '1132.2', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('27', '12', '3', '2017-04-27', '1200', '', '-1132.2', '0', '0', '2', 0x31, null);
INSERT INTO 0_gl_trans VALUES ('28', '1', '48', '2017-05-09', '1101', '', '0', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('29', '1', '48', '2017-05-09', '1612', '', '0', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('30', '4', '1', '2017-01-06', '1612', 'From National development Bank To Petty Cash', '-50000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('31', '4', '1', '2017-01-06', '301', 'From National development Bank To Petty Cash', '50000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('32', '1', '49', '2017-01-04', '5401', 'Salary Payment for the Month of December 2016', '21000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('33', '1', '49', '2017-01-04', '1612', '', '-21000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('34', '1', '50', '2017-01-04', '5401', 'Salary Payment for the Month of December 2016', '27742', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('35', '1', '50', '2017-01-04', '1612', '', '-27742', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('36', '1', '51', '2017-01-04', '5401', 'Salary Payment for the Month of December 2016', '23474', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('37', '1', '51', '2017-01-04', '1612', '', '-23474', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('38', '1', '52', '2017-01-09', '3108', 'P.A.Y.E Tax for the Month of December 2016', '108249', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('39', '1', '52', '2017-01-09', '1612', '', '-108249', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('40', '1', '53', '2017-01-10', '5437', 'Motor Vehicle Maintanance Expenses', '34576', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('41', '1', '53', '2017-01-10', '1612', '', '-34576', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('42', '4', '2', '2017-01-16', '1612', 'From National development Bank To Petty Cash', '-23037', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('43', '4', '2', '2017-01-16', '301', 'From National development Bank To Petty Cash', '23037', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('44', '1', '54', '2017-01-17', '3108', 'P.A.Y.E Tax  Expenses', '392775.73', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('45', '1', '54', '2017-01-17', '1612', '', '-392775.73', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('46', '1', '55', '2017-01-17', '3108', 'P.A.Y.E Tax  Expenses', '52966.5', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('47', '1', '55', '2017-01-17', '1612', '', '-52966.5', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('48', '1', '56', '2017-01-18', '5453', 'Professional Fee expenses', '192265', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('49', '1', '56', '2017-01-18', '1400', 'VAT', '28840', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('50', '1', '56', '2017-01-18', '1612', '', '-221105', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('51', '1', '57', '2017-01-19', '1414', 'Transfer to C.W Mackie C/A', '84007.16', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('52', '1', '57', '2017-01-19', '1612', '', '-84007.16', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('53', '4', '3', '2017-01-19', '1612', 'From National development Bank To Petty Cash', '-30000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('54', '4', '3', '2017-01-19', '301', 'From National development Bank To Petty Cash', '30000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('55', '1', '58', '2017-01-24', '5401', 'Salary Payment for the Month of January 2017', '77217', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('56', '1', '58', '2017-01-24', '1612', '', '-77217', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('57', '1', '59', '2017-01-24', '5401', 'Salary Payment for the Month of January 2017', '42603.75', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('58', '1', '59', '2017-01-24', '1612', '', '-42603.75', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('59', '1', '60', '2017-01-24', '5401', 'Salary Payment for the Month of January 2017', '40905', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('60', '1', '60', '2017-01-24', '1612', '', '-40905', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('61', '4', '4', '2017-01-25', '1612', 'From National development Bank To Petty Cash', '-50000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('62', '4', '4', '2017-01-25', '301', 'From National development Bank To Petty Cash', '50000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('63', '1', '61', '2017-01-26', '4350', 'Bank Charges-EB Charge', '1000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('64', '1', '61', '2017-01-26', '1612', '', '-1000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('65', '4', '5', '2017-01-27', '1612', 'From National development Bank To Petty Cash', '-15000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('66', '4', '5', '2017-01-27', '301', 'From National development Bank To Petty Cash', '15000', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('67', '4', '6', '2017-01-31', '1612', 'From National development Bank To Petty Cash', '-22216', '0', '0', null, null, null);
INSERT INTO 0_gl_trans VALUES ('68', '4', '6', '2017-01-31', '301', 'From National development Bank To Petty Cash', '22216', '0', '0', null, null, null);

-- ----------------------------
-- Table structure for `0_grn_batch`
-- ----------------------------
DROP TABLE IF EXISTS `0_grn_batch`;
CREATE TABLE `0_grn_batch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `purch_order_no` int(11) DEFAULT NULL,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rate` double DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `delivery_date` (`delivery_date`),
  KEY `purch_order_no` (`purch_order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_grn_batch
-- ----------------------------

-- ----------------------------
-- Table structure for `0_grn_items`
-- ----------------------------
DROP TABLE IF EXISTS `0_grn_items`;
CREATE TABLE `0_grn_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_batch_id` int(11) DEFAULT NULL,
  `po_detail_item` int(11) NOT NULL DEFAULT '0',
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `qty_recd` double NOT NULL DEFAULT '0',
  `quantity_inv` double NOT NULL DEFAULT '0',
  `line_location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `grn_batch_id` (`grn_batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_grn_items
-- ----------------------------

-- ----------------------------
-- Table structure for `0_groups`
-- ----------------------------
DROP TABLE IF EXISTS `0_groups`;
CREATE TABLE `0_groups` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_groups
-- ----------------------------
INSERT INTO 0_groups VALUES ('1', 'Small', '0');
INSERT INTO 0_groups VALUES ('2', 'Medium', '0');
INSERT INTO 0_groups VALUES ('3', 'Large', '0');

-- ----------------------------
-- Table structure for `0_import_paypal`
-- ----------------------------
DROP TABLE IF EXISTS `0_import_paypal`;
CREATE TABLE `0_import_paypal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date` date NOT NULL DEFAULT '0000-00-00',
  `ref` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `person` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `confirmed` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_import_paypal
-- ----------------------------

-- ----------------------------
-- Table structure for `0_import_paypal_accounts`
-- ----------------------------
DROP TABLE IF EXISTS `0_import_paypal_accounts`;
CREATE TABLE `0_import_paypal_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `person` (`person`),
  KEY `memo` (`memo`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_import_paypal_accounts
-- ----------------------------

-- ----------------------------
-- Table structure for `0_item_codes`
-- ----------------------------
DROP TABLE IF EXISTS `0_item_codes`;
CREATE TABLE `0_item_codes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` smallint(6) unsigned NOT NULL,
  `quantity` double NOT NULL DEFAULT '1',
  `is_foreign` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `stock_id` (`stock_id`,`item_code`),
  KEY `item_code` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_item_codes
-- ----------------------------
INSERT INTO 0_item_codes VALUES ('1', '00012', '00012', 'Electricity', '1', '1', '0', '0');
INSERT INTO 0_item_codes VALUES ('2', '01', '01', 'Management Service', '1', '1', '0', '0');

-- ----------------------------
-- Table structure for `0_item_tax_types`
-- ----------------------------
DROP TABLE IF EXISTS `0_item_tax_types`;
CREATE TABLE `0_item_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `exempt` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_item_tax_types
-- ----------------------------
INSERT INTO 0_item_tax_types VALUES ('1', 'Regular', '0', '0');

-- ----------------------------
-- Table structure for `0_item_tax_type_exemptions`
-- ----------------------------
DROP TABLE IF EXISTS `0_item_tax_type_exemptions`;
CREATE TABLE `0_item_tax_type_exemptions` (
  `item_tax_type_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_tax_type_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_item_tax_type_exemptions
-- ----------------------------

-- ----------------------------
-- Table structure for `0_item_units`
-- ----------------------------
DROP TABLE IF EXISTS `0_item_units`;
CREATE TABLE `0_item_units` (
  `abbr` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `decimals` tinyint(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`abbr`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_item_units
-- ----------------------------
INSERT INTO 0_item_units VALUES ('Cone', 'Cone', '-1', '0');
INSERT INTO 0_item_units VALUES ('ea.', 'Each', '1', '0');
INSERT INTO 0_item_units VALUES ('hrs', 'Hours', '1', '0');
INSERT INTO 0_item_units VALUES ('Kg', 'Kilogram', '-1', '0');
INSERT INTO 0_item_units VALUES ('l', 'Liter', '3', '0');
INSERT INTO 0_item_units VALUES ('Mtr', 'Meters', '-1', '0');
INSERT INTO 0_item_units VALUES ('Nos', 'Numbers', '0', '0');
INSERT INTO 0_item_units VALUES ('Yard', 'Yard', '-1', '0');

-- ----------------------------
-- Table structure for `0_journal`
-- ----------------------------
DROP TABLE IF EXISTS `0_journal`;
CREATE TABLE `0_journal` (
  `type` smallint(6) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `tran_date` date DEFAULT '0000-00-00',
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `source_ref` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `event_date` date DEFAULT '0000-00-00',
  `doc_date` date NOT NULL DEFAULT '0000-00-00',
  `currency` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_journal
-- ----------------------------

-- ----------------------------
-- Table structure for `0_locations`
-- ----------------------------
DROP TABLE IF EXISTS `0_locations`;
CREATE TABLE `0_locations` (
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `location_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fax` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fixed_asset` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `main_loc_id` int(3) NOT NULL,
  PRIMARY KEY (`loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_locations
-- ----------------------------
INSERT INTO 0_locations VALUES ('LOC', 'Main Location', '', '', '', '', '', '', '0', '0', '0');

-- ----------------------------
-- Table structure for `0_loc_stock`
-- ----------------------------
DROP TABLE IF EXISTS `0_loc_stock`;
CREATE TABLE `0_loc_stock` (
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `reorder_level` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`loc_code`,`stock_id`),
  KEY `stock_id` (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_loc_stock
-- ----------------------------
INSERT INTO 0_loc_stock VALUES ('LOC', '01', '0');

-- ----------------------------
-- Table structure for `0_main_category`
-- ----------------------------
DROP TABLE IF EXISTS `0_main_category`;
CREATE TABLE `0_main_category` (
  `main_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `main_cat_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL,
  PRIMARY KEY (`main_category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_main_category
-- ----------------------------

-- ----------------------------
-- Table structure for `0_main_locations`
-- ----------------------------
DROP TABLE IF EXISTS `0_main_locations`;
CREATE TABLE `0_main_locations` (
  `main_loc_id` int(11) NOT NULL AUTO_INCREMENT,
  `main_loc_code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `main_loc_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `inactive` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`main_loc_id`),
  UNIQUE KEY `main_loc_code` (`main_loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_main_locations
-- ----------------------------

-- ----------------------------
-- Table structure for `0_payment_terms`
-- ----------------------------
DROP TABLE IF EXISTS `0_payment_terms`;
CREATE TABLE `0_payment_terms` (
  `terms_indicator` int(11) NOT NULL AUTO_INCREMENT,
  `terms` char(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `days_before_due` smallint(6) NOT NULL DEFAULT '0',
  `day_in_following_month` smallint(6) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`terms_indicator`),
  UNIQUE KEY `terms` (`terms`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_payment_terms
-- ----------------------------
INSERT INTO 0_payment_terms VALUES ('1', '30 days only', '0', '0', '0');

-- ----------------------------
-- Table structure for `0_prices`
-- ----------------------------
DROP TABLE IF EXISTS `0_prices`;
CREATE TABLE `0_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type_id` int(11) NOT NULL DEFAULT '0',
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `price` (`stock_id`,`sales_type_id`,`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_prices
-- ----------------------------

-- ----------------------------
-- Table structure for `0_printers`
-- ----------------------------
DROP TABLE IF EXISTS `0_printers`;
CREATE TABLE `0_printers` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `queue` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `host` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `port` smallint(11) unsigned NOT NULL,
  `timeout` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_printers
-- ----------------------------
INSERT INTO 0_printers VALUES ('1', 'QL500', 'Label printer', 'QL500', 'server', '127', '20');
INSERT INTO 0_printers VALUES ('2', 'Samsung', 'Main network printer', 'scx4521F', 'server', '515', '5');
INSERT INTO 0_printers VALUES ('3', 'Local', 'Local print server at user IP', 'lp', '', '515', '10');

-- ----------------------------
-- Table structure for `0_print_profiles`
-- ----------------------------
DROP TABLE IF EXISTS `0_print_profiles`;
CREATE TABLE `0_print_profiles` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `report` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `printer` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile` (`profile`,`report`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_print_profiles
-- ----------------------------
INSERT INTO 0_print_profiles VALUES ('1', 'Out of office', null, '0');
INSERT INTO 0_print_profiles VALUES ('2', 'Sales Department', null, '0');
INSERT INTO 0_print_profiles VALUES ('3', 'Central', null, '2');
INSERT INTO 0_print_profiles VALUES ('4', 'Sales Department', '104', '2');
INSERT INTO 0_print_profiles VALUES ('5', 'Sales Department', '105', '2');
INSERT INTO 0_print_profiles VALUES ('6', 'Sales Department', '107', '2');
INSERT INTO 0_print_profiles VALUES ('7', 'Sales Department', '109', '2');
INSERT INTO 0_print_profiles VALUES ('8', 'Sales Department', '110', '2');
INSERT INTO 0_print_profiles VALUES ('9', 'Sales Department', '201', '2');

-- ----------------------------
-- Table structure for `0_products_collections`
-- ----------------------------
DROP TABLE IF EXISTS `0_products_collections`;
CREATE TABLE `0_products_collections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pc_code` varchar(4) COLLATE utf8_unicode_ci NOT NULL,
  `pc_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `inactive` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pc_code` (`pc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_products_collections
-- ----------------------------

-- ----------------------------
-- Table structure for `0_purch_data`
-- ----------------------------
DROP TABLE IF EXISTS `0_purch_data`;
CREATE TABLE `0_purch_data` (
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT '0',
  `suppliers_uom` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `conversion_factor` double NOT NULL DEFAULT '1',
  `supplier_description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`supplier_id`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_purch_data
-- ----------------------------

-- ----------------------------
-- Table structure for `0_purch_orders`
-- ----------------------------
DROP TABLE IF EXISTS `0_purch_orders`;
CREATE TABLE `0_purch_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `comments` tinytext COLLATE utf8_unicode_ci,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `requisition_no` tinytext COLLATE utf8_unicode_ci,
  `into_stock_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `total` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_purch_orders
-- ----------------------------

-- ----------------------------
-- Table structure for `0_purch_order_details`
-- ----------------------------
DROP TABLE IF EXISTS `0_purch_order_details`;
CREATE TABLE `0_purch_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT '0',
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `act_price` double NOT NULL DEFAULT '0',
  `std_cost_unit` double NOT NULL DEFAULT '0',
  `quantity_ordered` double NOT NULL DEFAULT '0',
  `quantity_received` double NOT NULL DEFAULT '0',
  `line_location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`),
  KEY `itemcode` (`item_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_purch_order_details
-- ----------------------------

-- ----------------------------
-- Table structure for `0_purch_order_details_csv`
-- ----------------------------
DROP TABLE IF EXISTS `0_purch_order_details_csv`;
CREATE TABLE `0_purch_order_details_csv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_ref` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `price` double(16,2) DEFAULT NULL,
  `order_date` date NOT NULL,
  `requeried_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_purch_order_details_csv
-- ----------------------------

-- ----------------------------
-- Table structure for `0_quick_entries`
-- ----------------------------
DROP TABLE IF EXISTS `0_quick_entries`;
CREATE TABLE `0_quick_entries` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `usage` varchar(120) COLLATE utf8_unicode_ci DEFAULT NULL,
  `base_amount` double NOT NULL DEFAULT '0',
  `base_desc` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bal_type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_quick_entries
-- ----------------------------
INSERT INTO 0_quick_entries VALUES ('1', '1', 'Employee Trust Fund', null, '0', 'Employee trust fund', '0');
INSERT INTO 0_quick_entries VALUES ('4', '1', 'The General Manager,Ceylon Electricity Board', null, '0', 'Electricity bill payment', '0');
INSERT INTO 0_quick_entries VALUES ('6', '1', 'National Water Supply &amp; Draining Board', null, '0', 'Water Bill', '0');
INSERT INTO 0_quick_entries VALUES ('7', '1', 'Employees Provident Fund', null, '0', 'E.P.F', '0');
INSERT INTO 0_quick_entries VALUES ('8', '1', 'THE COMMISSIONER GENERAL OF INLAND REVENUE', 'Tax', '0', 'Remittance of PAYE - January', '0');
INSERT INTO 0_quick_entries VALUES ('9', '1', 'N.S.N. ENTERPRISES', null, '0', 'Fuel expenses for the month December', '0');
INSERT INTO 0_quick_entries VALUES ('10', '1', 'THE MERCANTILE SERVICE PROVIDENT SOCIETY', 'Remittance of MSPS', '0', 'Remitance of MSPS', '0');

-- ----------------------------
-- Table structure for `0_quick_entry_lines`
-- ----------------------------
DROP TABLE IF EXISTS `0_quick_entry_lines`;
CREATE TABLE `0_quick_entry_lines` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `qid` smallint(6) unsigned NOT NULL,
  `amount` double DEFAULT '0',
  `memo` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `dest_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` smallint(6) unsigned DEFAULT NULL,
  `dimension2_id` smallint(6) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_quick_entry_lines
-- ----------------------------
INSERT INTO 0_quick_entry_lines VALUES ('7', '6', '0', '', '=', '6186', '0', '0');
INSERT INTO 0_quick_entry_lines VALUES ('8', '4', '0', '', '=', '6170', '0', '0');
INSERT INTO 0_quick_entry_lines VALUES ('9', '7', '0', '', '=', '5403', '0', '0');
INSERT INTO 0_quick_entry_lines VALUES ('10', '1', '0', '', '=', '5403', '0', '0');
INSERT INTO 0_quick_entry_lines VALUES ('11', '8', '0', 'Remittance of PAYE - January', '=', '3108', '0', '0');
INSERT INTO 0_quick_entry_lines VALUES ('12', '9', '0', 'Fuel expenses for the month December', '=', '5437', '0', '0');
INSERT INTO 0_quick_entry_lines VALUES ('13', '10', '0', 'Remitance of MSPS', '=', '3108', '0', '0');

-- ----------------------------
-- Table structure for `0_recurrent_invoices`
-- ----------------------------
DROP TABLE IF EXISTS `0_recurrent_invoices`;
CREATE TABLE `0_recurrent_invoices` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order_no` int(11) unsigned NOT NULL,
  `debtor_no` int(11) unsigned DEFAULT NULL,
  `group_no` smallint(6) unsigned DEFAULT NULL,
  `days` int(11) NOT NULL DEFAULT '0',
  `monthly` int(11) NOT NULL DEFAULT '0',
  `begin` date NOT NULL DEFAULT '0000-00-00',
  `end` date NOT NULL DEFAULT '0000-00-00',
  `last_sent` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_recurrent_invoices
-- ----------------------------

-- ----------------------------
-- Table structure for `0_reflines`
-- ----------------------------
DROP TABLE IF EXISTS `0_reflines`;
CREATE TABLE `0_reflines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` int(11) NOT NULL,
  `prefix` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pattern` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `prefix` (`trans_type`,`prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_reflines
-- ----------------------------
INSERT INTO 0_reflines VALUES ('1', '1', '', 'P00018', '', '0', '0');
INSERT INTO 0_reflines VALUES ('2', '10', '', 'S0004', '', '1', '0');
INSERT INTO 0_reflines VALUES ('3', '0', '', 'J000001', '', '0', '0');
INSERT INTO 0_reflines VALUES ('4', '4', '', 'T00007', '', '0', '0');

-- ----------------------------
-- Table structure for `0_refs`
-- ----------------------------
DROP TABLE IF EXISTS `0_refs`;
CREATE TABLE `0_refs` (
  `id` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`type`),
  KEY `Type_and_Reference` (`type`,`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_refs
-- ----------------------------
INSERT INTO 0_refs VALUES ('44', '1', 'P00001');
INSERT INTO 0_refs VALUES ('45', '1', 'P00002');
INSERT INTO 0_refs VALUES ('46', '1', 'P00003');
INSERT INTO 0_refs VALUES ('47', '1', 'P00004');
INSERT INTO 0_refs VALUES ('48', '1', 'P00004');
INSERT INTO 0_refs VALUES ('49', '1', 'P00005');
INSERT INTO 0_refs VALUES ('50', '1', 'P00006');
INSERT INTO 0_refs VALUES ('51', '1', 'P00007');
INSERT INTO 0_refs VALUES ('52', '1', 'P00008');
INSERT INTO 0_refs VALUES ('53', '1', 'P00009');
INSERT INTO 0_refs VALUES ('54', '1', 'P00010');
INSERT INTO 0_refs VALUES ('55', '1', 'P00011');
INSERT INTO 0_refs VALUES ('56', '1', 'P00012');
INSERT INTO 0_refs VALUES ('57', '1', 'P00013');
INSERT INTO 0_refs VALUES ('58', '1', 'P00014');
INSERT INTO 0_refs VALUES ('59', '1', 'P00015');
INSERT INTO 0_refs VALUES ('60', '1', 'P00016');
INSERT INTO 0_refs VALUES ('61', '1', 'P00017');
INSERT INTO 0_refs VALUES ('1', '4', 'T00001');
INSERT INTO 0_refs VALUES ('2', '4', 'T00002');
INSERT INTO 0_refs VALUES ('3', '4', 'T00003');
INSERT INTO 0_refs VALUES ('4', '4', 'T00004');
INSERT INTO 0_refs VALUES ('5', '4', 'T00005');
INSERT INTO 0_refs VALUES ('6', '4', 'T00006');
INSERT INTO 0_refs VALUES ('1', '10', 'S0001');
INSERT INTO 0_refs VALUES ('2', '10', 'S0002');
INSERT INTO 0_refs VALUES ('3', '10', 'S0003');
INSERT INTO 0_refs VALUES ('1', '12', '');
INSERT INTO 0_refs VALUES ('2', '12', '');
INSERT INTO 0_refs VALUES ('3', '12', '');
INSERT INTO 0_refs VALUES ('49', '50', '001570');
INSERT INTO 0_refs VALUES ('48', '50', '1');
INSERT INTO 0_refs VALUES ('44', '50', '124563');
INSERT INTO 0_refs VALUES ('50', '50', '1571');
INSERT INTO 0_refs VALUES ('51', '50', '1572');
INSERT INTO 0_refs VALUES ('52', '50', '1573');
INSERT INTO 0_refs VALUES ('53', '50', '1575');
INSERT INTO 0_refs VALUES ('54', '50', '1577');
INSERT INTO 0_refs VALUES ('55', '50', '1578');
INSERT INTO 0_refs VALUES ('56', '50', '1580');
INSERT INTO 0_refs VALUES ('57', '50', '1581');
INSERT INTO 0_refs VALUES ('58', '50', '1583');
INSERT INTO 0_refs VALUES ('59', '50', '1584');
INSERT INTO 0_refs VALUES ('60', '50', '1585');
INSERT INTO 0_refs VALUES ('61', '50', '1586');
INSERT INTO 0_refs VALUES ('45', '50', '789456');
INSERT INTO 0_refs VALUES ('46', '50', '789457');
INSERT INTO 0_refs VALUES ('47', '50', '789458');

-- ----------------------------
-- Table structure for `0_requisitions`
-- ----------------------------
DROP TABLE IF EXISTS `0_requisitions`;
CREATE TABLE `0_requisitions` (
  `requisition_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `point_of_use` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `narrative` varchar(240) COLLATE utf8_unicode_ci DEFAULT NULL,
  `application_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `completed` tinyint(4) NOT NULL DEFAULT '0',
  `processed` tinyint(4) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`requisition_id`),
  UNIQUE KEY `requisition_id` (`requisition_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_requisitions
-- ----------------------------

-- ----------------------------
-- Table structure for `0_requisition_details`
-- ----------------------------
DROP TABLE IF EXISTS `0_requisition_details`;
CREATE TABLE `0_requisition_details` (
  `requisition_detail_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `requisition_id` int(11) DEFAULT NULL,
  `item_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `lpo_id` int(11) DEFAULT '0',
  `order_quantity` int(11) NOT NULL DEFAULT '0',
  `estimate_price` double NOT NULL DEFAULT '0',
  `quantity` int(11) NOT NULL DEFAULT '0',
  `price` double NOT NULL DEFAULT '0',
  `purpose` varchar(320) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`requisition_detail_id`),
  UNIQUE KEY `requisition_detail_id` (`requisition_detail_id`),
  KEY `0_requisition_details_requisition_id` (`requisition_id`),
  KEY `0_requisition_details_item_code` (`item_code`),
  KEY `0_requisition_details_supplier_id` (`supplier_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_requisition_details
-- ----------------------------

-- ----------------------------
-- Table structure for `0_salesman`
-- ----------------------------
DROP TABLE IF EXISTS `0_salesman`;
CREATE TABLE `0_salesman` (
  `salesman_code` int(11) NOT NULL AUTO_INCREMENT,
  `salesman_name` char(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_phone` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_fax` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `provision` double NOT NULL DEFAULT '0',
  `break_pt` double NOT NULL DEFAULT '0',
  `provision2` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`salesman_code`),
  UNIQUE KEY `salesman_name` (`salesman_name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_salesman
-- ----------------------------
INSERT INTO 0_salesman VALUES ('1', 'Sales Person', '', '', '', '5', '20000', '4', '0');
INSERT INTO 0_salesman VALUES ('3', 'De Mel', '0112326191', '0114719891', 'hldemelcoltd@sltnet.lk', '0', '0', '0', '0');

-- ----------------------------
-- Table structure for `0_sales_orders`
-- ----------------------------
DROP TABLE IF EXISTS `0_sales_orders`;
CREATE TABLE `0_sales_orders` (
  `order_no` int(11) NOT NULL,
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `version` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `branch_code` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `customer_ref` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `comments` tinytext COLLATE utf8_unicode_ci,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `order_type` int(11) NOT NULL DEFAULT '0',
  `ship_via` int(11) NOT NULL DEFAULT '0',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `contact_phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `deliver_to` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `freight_cost` double NOT NULL DEFAULT '0',
  `from_stk_loc` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `payment_terms` int(11) DEFAULT NULL,
  `total` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `done_by` int(2) DEFAULT NULL,
  PRIMARY KEY (`order_no`,`trans_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_sales_orders
-- ----------------------------
INSERT INTO 0_sales_orders VALUES ('1', '30', '1', '0', '1', '1', 'auto', '', '', '2017-04-26', '1', '1', 'COLOMBO', '', null, 'C W MAKEE', '0', 'LOC', '2017-04-26', '1', '150000', '0', '0', null);
INSERT INTO 0_sales_orders VALUES ('2', '30', '1', '0', '1', '1', 'auto', '', '', '2017-04-27', '1', '1', 'COLOMBO', '', null, 'C W MAKEE', '0', 'LOC', '2017-04-27', '1', '1000', '0', '0', null);
INSERT INTO 0_sales_orders VALUES ('3', '30', '1', '0', '1', '1', 'auto', '', '', '2017-04-27', '1', '1', 'COLOMBO', '', null, 'C W MAKEE', '0', 'LOC', '2017-04-27', '1', '1130', '0', '0', null);

-- ----------------------------
-- Table structure for `0_sales_order_details`
-- ----------------------------
DROP TABLE IF EXISTS `0_sales_order_details`;
CREATE TABLE `0_sales_order_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT '0',
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `stk_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `qty_sent` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `invoiced` double NOT NULL DEFAULT '0',
  `discount_percent` double NOT NULL DEFAULT '0',
  `done_by` int(2) DEFAULT NULL,
  `line_location` char(15) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sorder` (`trans_type`,`order_no`),
  KEY `stkcode` (`stk_code`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_sales_order_details
-- ----------------------------
INSERT INTO 0_sales_order_details VALUES ('1', '1', '30', '01', 'Management Service', '1', '150000', '1', '0', '0', null, '');
INSERT INTO 0_sales_order_details VALUES ('2', '2', '30', '01', 'Management Service', '1', '1000', '1', '0', '0', null, '');
INSERT INTO 0_sales_order_details VALUES ('3', '3', '30', '01', 'Management Service', '1', '1000', '1', '0', '0', null, '');

-- ----------------------------
-- Table structure for `0_sales_order_details_csv`
-- ----------------------------
DROP TABLE IF EXISTS `0_sales_order_details_csv`;
CREATE TABLE `0_sales_order_details_csv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cust_ref` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `stock_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `price` double(16,2) DEFAULT NULL,
  `discount_precent` double DEFAULT NULL,
  `order_date` date DEFAULT NULL,
  `delivery_date` date DEFAULT NULL,
  `deliver_addres` tinytext COLLATE utf8_unicode_ci,
  `deliver_branch` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_sales_order_details_csv
-- ----------------------------

-- ----------------------------
-- Table structure for `0_sales_pos`
-- ----------------------------
DROP TABLE IF EXISTS `0_sales_pos`;
CREATE TABLE `0_sales_pos` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `pos_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `cash_sale` tinyint(1) NOT NULL,
  `credit_sale` tinyint(1) NOT NULL,
  `pos_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `pos_account` smallint(6) unsigned NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `pos_name` (`pos_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_sales_pos
-- ----------------------------
INSERT INTO 0_sales_pos VALUES ('1', 'Default', '1', '1', 'DEF', '2', '0');

-- ----------------------------
-- Table structure for `0_sales_types`
-- ----------------------------
DROP TABLE IF EXISTS `0_sales_types`;
CREATE TABLE `0_sales_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_type` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_included` int(1) NOT NULL DEFAULT '0',
  `factor` double NOT NULL DEFAULT '1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_type` (`sales_type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_sales_types
-- ----------------------------
INSERT INTO 0_sales_types VALUES ('1', 'Retail', '0', '1', '0');
INSERT INTO 0_sales_types VALUES ('2', 'Wholesale', '0', '0.7', '0');

-- ----------------------------
-- Table structure for `0_security_roles`
-- ----------------------------
DROP TABLE IF EXISTS `0_security_roles`;
CREATE TABLE `0_security_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sections` text COLLATE utf8_unicode_ci,
  `areas` text COLLATE utf8_unicode_ci,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `role` (`role`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_security_roles
-- ----------------------------
INSERT INTO 0_security_roles VALUES ('1', 'Inquiries', 'Inquiries', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128;9216;9216;9216;9472;9472;9472;9472;9728', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;773;774;775;2822;3073;3075;3076;3077;3329;3330;3331;3332;3333;3334;3335;5377;5633;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15873;15882;16129;16130;16131;16132', '0');
INSERT INTO 0_security_roles VALUES ('2', 'System Administrator', 'System Administrator', '256;512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;10496;10752;11008;13056;13312;15616;15872;16128;549888;615424;812032;1008640;1074176;1205248;1270784;1336320;9216;9216;9216;9472;9472;9472;9472;9728', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;775;2817;2818;2819;2820;2821;2822;2823;3073;3074;3075;3076;3077;3078;3079;3080;3081;3082;3329;3330;3331;3332;3333;3334;3335;5377;5385;5633;5634;5635;5636;5637;5638;5639;5640;5641;5889;5890;5891;7937;7938;7939;7940;7941;7942;7943;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15627;15628;15629;15873;15874;15875;15876;15877;15878;15879;15880;15881;15882;15883;15884;16129;16130;16131;16132;549988;549989;549990;615524;615525;812132;1008740;1074276;1205348;1270884;1336420', '0');
INSERT INTO 0_security_roles VALUES ('3', 'Salesman', 'Salesman', '768;3072;5632;8192;15872;9216;9216;9216;9472;9472;9472;9472;9728', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;526;773;774;775;2817;2818;2819;2820;2821;2822;2823;3073;3075;3082;3329;3330;3331;3332;3333;3334;3335;5377;5633;5889;5890;5891;7937;7938;7939;7940;8194;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15627;15628;15629;15873;16129;16130;16131;16132;549988;549989;549990;615524;615525;812132;1008740;1074276', '0');
INSERT INTO 0_security_roles VALUES ('4', 'Stock Manager', 'Stock Manager', '2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128;768', '775', '0');
INSERT INTO 0_security_roles VALUES ('5', 'Production Manager', 'Production Manager', '512;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128;768', '775', '0');
INSERT INTO 0_security_roles VALUES ('6', 'Purchase Officer', 'Purchase Officer', '512;5376;5632;5888;8192;8448;10752;11008;13312;768', '775', '0');
INSERT INTO 0_security_roles VALUES ('7', 'AR Officer', 'AR Officer', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;771;773;774;2818;2819;2820;2821;2822;2823;3073;3073;3074;3075;3076;3077;3078;3079;3080;3081;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5633;5634;5637;5638;5639;5640;5640;5889;5890;5891;8193;8194;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0');
INSERT INTO 0_security_roles VALUES ('8', 'AP Officer', 'AP Officer', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;10496;10752;11008;13056;13312;15616;15872;16128;549888;615424', '257;258;259;260;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;7941;7942;7943;8193;8194;8195;8196;8197;8449;8450;8451;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15629;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;549988;549989;549990;615524;615525;812132;1008740;1074276;775', '0');
INSERT INTO 0_security_roles VALUES ('9', 'Accountant', 'New Accountant', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;9216;9472;9728;10496;10752;11008;13056;13312;15616;15872;16128;549888;615424;812032;1008640', '513;514;515;516;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;775;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15629;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;549988;549989;549990;615524;615525;812132;1008740;257;258;259;260', '0');
INSERT INTO 0_security_roles VALUES ('10', 'Sub Admin', 'Sub Admin', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;10496;10752;11008;13056;13312;15616;15872;16128;549888;615424;812032;1008640;1074176', '257;258;259;260;519;520;521;522;523;524;525;526;769;770;771;772;773;774;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;7941;7942;7943;8193;8194;8195;8196;8197;8449;8450;8451;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15629;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;549988;549989;549990;615524;615525;812132;1008740;1074276;775', '0');

-- ----------------------------
-- Table structure for `0_shippers`
-- ----------------------------
DROP TABLE IF EXISTS `0_shippers`;
CREATE TABLE `0_shippers` (
  `shipper_id` int(11) NOT NULL AUTO_INCREMENT,
  `shipper_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`shipper_id`),
  UNIQUE KEY `name` (`shipper_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_shippers
-- ----------------------------
INSERT INTO 0_shippers VALUES ('1', 'Default', '', '', '', '', '0');

-- ----------------------------
-- Table structure for `0_sizes`
-- ----------------------------
DROP TABLE IF EXISTS `0_sizes`;
CREATE TABLE `0_sizes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `size_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `size_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `inactive` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_sizes
-- ----------------------------

-- ----------------------------
-- Table structure for `0_sql_trail`
-- ----------------------------
DROP TABLE IF EXISTS `0_sql_trail`;
CREATE TABLE `0_sql_trail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sql` text COLLATE utf8_unicode_ci NOT NULL,
  `result` tinyint(1) NOT NULL,
  `msg` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_sql_trail
-- ----------------------------

-- ----------------------------
-- Table structure for `0_stock_category`
-- ----------------------------
DROP TABLE IF EXISTS `0_stock_category`;
CREATE TABLE `0_stock_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_tax_type` int(11) NOT NULL DEFAULT '1',
  `dflt_units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `dflt_mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `dflt_sales_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_cogs_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_inventory_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_adjustment_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_wip_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_dim1` int(11) DEFAULT NULL,
  `dflt_dim2` int(11) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `dflt_no_sale` tinyint(1) NOT NULL DEFAULT '0',
  `dflt_no_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `done_by` int(2) DEFAULT NULL,
  `main_category_id` int(11) NOT NULL,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_stock_category
-- ----------------------------
INSERT INTO 0_stock_category VALUES ('1', 'Services', '1', 'Cone', 'D', '6108', '1101', '0150', '0150', '0150', '0', '0', '0', '0', '0', null, '0');

-- ----------------------------
-- Table structure for `0_stock_fa_class`
-- ----------------------------
DROP TABLE IF EXISTS `0_stock_fa_class`;
CREATE TABLE `0_stock_fa_class` (
  `fa_class_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `long_description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `depreciation_rate` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fa_class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_stock_fa_class
-- ----------------------------

-- ----------------------------
-- Table structure for `0_stock_master`
-- ----------------------------
DROP TABLE IF EXISTS `0_stock_master`;
CREATE TABLE `0_stock_master` (
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `long_description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cogs_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inventory_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `adjustment_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `wip_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` int(11) DEFAULT NULL,
  `dimension2_id` int(11) DEFAULT NULL,
  `purchase_cost` double NOT NULL DEFAULT '0',
  `material_cost` double NOT NULL DEFAULT '0',
  `labour_cost` double NOT NULL DEFAULT '0',
  `overhead_cost` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `no_sale` tinyint(1) NOT NULL DEFAULT '0',
  `no_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `editable` tinyint(1) NOT NULL DEFAULT '0',
  `depreciation_method` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'S',
  `depreciation_rate` double NOT NULL DEFAULT '0',
  `depreciation_factor` double NOT NULL DEFAULT '0',
  `depreciation_start` date NOT NULL DEFAULT '0000-00-00',
  `depreciation_date` date NOT NULL DEFAULT '0000-00-00',
  `fa_class_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `crm_code` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `done_by` int(2) DEFAULT NULL,
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_stock_master
-- ----------------------------
INSERT INTO 0_stock_master VALUES ('01', '1', '1', 'Management Service', '', 'Cone', 'D', '6108', '1101', '0150', '0150', '0150', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', null, null);

-- ----------------------------
-- Table structure for `0_stock_moves`
-- ----------------------------
DROP TABLE IF EXISTS `0_stock_moves`;
CREATE TABLE `0_stock_moves` (
  `trans_id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` smallint(6) NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `price` double NOT NULL DEFAULT '0',
  `reference` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT '1',
  `standard_cost` double NOT NULL DEFAULT '0',
  `line_location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`trans_id`),
  KEY `type` (`type`,`trans_no`),
  KEY `Move` (`stock_id`,`loc_code`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_stock_moves
-- ----------------------------
INSERT INTO 0_stock_moves VALUES ('1', '1', '01', '13', 'LOC', '2017-04-26', '150000', 'auto', '-1', '0', '');
INSERT INTO 0_stock_moves VALUES ('2', '2', '01', '13', 'LOC', '2017-04-27', '1000', 'auto', '-1', '0', '');
INSERT INTO 0_stock_moves VALUES ('3', '3', '01', '13', 'LOC', '2017-04-27', '1000', 'auto', '-1', '0', '');

-- ----------------------------
-- Table structure for `0_stock_serial`
-- ----------------------------
DROP TABLE IF EXISTS `0_stock_serial`;
CREATE TABLE `0_stock_serial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serial_key` int(4) DEFAULT NULL,
  `year_month` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serial_no` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `manufacture_date` date DEFAULT NULL,
  `stock_in_date` timestamp NULL DEFAULT NULL,
  `type_no_in` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_no_in` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `stock_out_date` datetime DEFAULT NULL,
  `type_no_out` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_no_out` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `availability` int(1) DEFAULT '1',
  `serial_status` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` int(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `serial_number` (`serial_no`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_stock_serial
-- ----------------------------

-- ----------------------------
-- Table structure for `0_stock_serial_genarate_log`
-- ----------------------------
DROP TABLE IF EXISTS `0_stock_serial_genarate_log`;
CREATE TABLE `0_stock_serial_genarate_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serial_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `commnet` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `genarate_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_stock_serial_genarate_log
-- ----------------------------

-- ----------------------------
-- Table structure for `0_suppliers`
-- ----------------------------
DROP TABLE IF EXISTS `0_suppliers`;
CREATE TABLE `0_suppliers` (
  `supplier_id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supp_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `gst_no` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supp_account_no` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `website` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  `dimension_id` int(11) DEFAULT '0',
  `dimension2_id` int(11) DEFAULT '0',
  `tax_group_id` int(11) DEFAULT NULL,
  `credit_limit` double NOT NULL DEFAULT '0',
  `purchase_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payable_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `area` int(11) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `supp_ref` (`supp_ref`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_suppliers
-- ----------------------------
INSERT INTO 0_suppliers VALUES ('1', 'Sri lanka Telecom', 'Sri lanka Telecom', '', '', '', '', '', '', '', 'LKR', '0', '0', '0', '0', '1', '0', '4155', '0353', '0150', '', '0', '0');

-- ----------------------------
-- Table structure for `0_supplier_areas`
-- ----------------------------
DROP TABLE IF EXISTS `0_supplier_areas`;
CREATE TABLE `0_supplier_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_supplier_areas
-- ----------------------------

-- ----------------------------
-- Table structure for `0_supp_allocations`
-- ----------------------------
DROP TABLE IF EXISTS `0_supp_allocations`;
CREATE TABLE `0_supp_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_supp_allocations
-- ----------------------------

-- ----------------------------
-- Table structure for `0_supp_invoice_items`
-- ----------------------------
DROP TABLE IF EXISTS `0_supp_invoice_items`;
CREATE TABLE `0_supp_invoice_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_trans_no` int(11) DEFAULT NULL,
  `supp_trans_type` int(11) DEFAULT NULL,
  `gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `grn_item_id` int(11) DEFAULT NULL,
  `po_detail_item_id` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `quantity` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `unit_tax` double NOT NULL DEFAULT '0',
  `memo_` tinytext COLLATE utf8_unicode_ci,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `line_location` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`supp_trans_type`,`supp_trans_no`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_supp_invoice_items
-- ----------------------------

-- ----------------------------
-- Table structure for `0_supp_trans`
-- ----------------------------
DROP TABLE IF EXISTS `0_supp_trans`;
CREATE TABLE `0_supp_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `supplier_id` int(11) unsigned NOT NULL,
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `ov_amount` double NOT NULL DEFAULT '0',
  `ov_discount` double NOT NULL DEFAULT '0',
  `ov_gst` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  `alloc` double NOT NULL DEFAULT '0',
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`type`,`trans_no`,`supplier_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_supp_trans
-- ----------------------------
INSERT INTO 0_supp_trans VALUES ('48', '1', '1', 'P00004', '', '2017-05-09', '0000-00-00', '0', '0', '0', '1', '0', '0');

-- ----------------------------
-- Table structure for `0_sys_prefs`
-- ----------------------------
DROP TABLE IF EXISTS `0_sys_prefs`;
CREATE TABLE `0_sys_prefs` (
  `name` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `length` smallint(6) DEFAULT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`name`),
  KEY `category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_sys_prefs
-- ----------------------------
INSERT INTO 0_sys_prefs VALUES ('accounts_alpha', 'glsetup.general', 'tinyint', '1', '0');
INSERT INTO 0_sys_prefs VALUES ('accumulate_shipping', 'glsetup.customer', 'tinyint', '1', '0');
INSERT INTO 0_sys_prefs VALUES ('add_pct', 'setup.company', 'int', '5', '-1');
INSERT INTO 0_sys_prefs VALUES ('allow_negative_prices', 'glsetup.inventory', 'tinyint', '1', '1');
INSERT INTO 0_sys_prefs VALUES ('allow_negative_stock', 'glsetup.inventory', 'tinyint', '1', '1');
INSERT INTO 0_sys_prefs VALUES ('alternative_tax_include_on_docs', 'setup.company', 'tinyint', '1', '');
INSERT INTO 0_sys_prefs VALUES ('auto_curr_reval', 'setup.company', 'smallint', '6', '1');
INSERT INTO 0_sys_prefs VALUES ('bank_charge_act', 'glsetup.general', 'varchar', '15', '5690');
INSERT INTO 0_sys_prefs VALUES ('base_sales', 'setup.company', 'int', '11', '0');
INSERT INTO 0_sys_prefs VALUES ('bcc_email', 'setup.company', 'varchar', '100', '');
INSERT INTO 0_sys_prefs VALUES ('coy_logo', 'setup.company', 'varchar', '100', '');
INSERT INTO 0_sys_prefs VALUES ('coy_name', 'setup.company', 'varchar', '60', 'Ceylon Trading Co.Ltd');
INSERT INTO 0_sys_prefs VALUES ('coy_no', 'setup.company', 'varchar', '25', 'PB 25');
INSERT INTO 0_sys_prefs VALUES ('creditors_act', 'glsetup.purchase', 'varchar', '15', '2100');
INSERT INTO 0_sys_prefs VALUES ('curr_default', 'setup.company', 'char', '3', 'LKR');
INSERT INTO 0_sys_prefs VALUES ('debtors_act', 'glsetup.sales', 'varchar', '15', '1200');
INSERT INTO 0_sys_prefs VALUES ('default_adj_act', 'glsetup.items', 'varchar', '15', '5040');
INSERT INTO 0_sys_prefs VALUES ('default_cogs_act', 'glsetup.items', 'varchar', '15', '5010');
INSERT INTO 0_sys_prefs VALUES ('default_credit_limit', 'glsetup.customer', 'int', '11', '1000000');
INSERT INTO 0_sys_prefs VALUES ('default_delivery_required', 'glsetup.sales', 'smallint', '6', '1');
INSERT INTO 0_sys_prefs VALUES ('default_dim_required', 'glsetup.dims', 'int', '11', '20');
INSERT INTO 0_sys_prefs VALUES ('default_inv_sales_act', 'glsetup.items', 'varchar', '15', '4010');
INSERT INTO 0_sys_prefs VALUES ('default_inventory_act', 'glsetup.items', 'varchar', '15', '1510');
INSERT INTO 0_sys_prefs VALUES ('default_loss_on_asset_disposal_act', 'glsetup.items', 'varchar', '15', '5660');
INSERT INTO 0_sys_prefs VALUES ('default_prompt_payment_act', 'glsetup.sales', 'varchar', '15', '4500');
INSERT INTO 0_sys_prefs VALUES ('default_quote_valid_days', 'glsetup.sales', 'smallint', '6', '30');
INSERT INTO 0_sys_prefs VALUES ('default_receival_required', 'glsetup.purchase', 'smallint', '6', '10');
INSERT INTO 0_sys_prefs VALUES ('default_sales_act', 'glsetup.sales', 'varchar', '15', '4010');
INSERT INTO 0_sys_prefs VALUES ('default_sales_discount_act', 'glsetup.sales', 'varchar', '15', '4510');
INSERT INTO 0_sys_prefs VALUES ('default_wip_act', 'glsetup.items', 'varchar', '15', '1530');
INSERT INTO 0_sys_prefs VALUES ('default_workorder_required', 'glsetup.manuf', 'int', '11', '20');
INSERT INTO 0_sys_prefs VALUES ('deferred_income_act', 'glsetup.sales', 'varchar', '15', '');
INSERT INTO 0_sys_prefs VALUES ('depreciation_period', 'glsetup.company', 'tinyint', '1', '1');
INSERT INTO 0_sys_prefs VALUES ('domicile', 'setup.company', 'varchar', '55', '');
INSERT INTO 0_sys_prefs VALUES ('email', 'setup.company', 'varchar', '100', 'nolyec@ceylontrading.com');
INSERT INTO 0_sys_prefs VALUES ('exchange_diff_act', 'glsetup.general', 'varchar', '15', '4450');
INSERT INTO 0_sys_prefs VALUES ('f_year', 'setup.company', 'int', '11', '2');
INSERT INTO 0_sys_prefs VALUES ('fax', 'setup.company', 'varchar', '30', '2449586');
INSERT INTO 0_sys_prefs VALUES ('freight_act', 'glsetup.customer', 'varchar', '15', '4430');
INSERT INTO 0_sys_prefs VALUES ('gl_closing_date', 'setup.closing_date', 'date', '8', '');
INSERT INTO 0_sys_prefs VALUES ('grn_clearing_act', 'glsetup.purchase', 'varchar', '15', '1550');
INSERT INTO 0_sys_prefs VALUES ('gst_no', 'setup.company', 'varchar', '25', '204003335 7000');
INSERT INTO 0_sys_prefs VALUES ('legal_text', 'glsetup.customer', 'tinytext', '0', '');
INSERT INTO 0_sys_prefs VALUES ('loc_notification', 'glsetup.inventory', 'tinyint', '1', '0');
INSERT INTO 0_sys_prefs VALUES ('login_tout', 'setup.company', 'smallint', '6', '60000');
INSERT INTO 0_sys_prefs VALUES ('no_customer_list', 'setup.company', 'tinyint', '1', '1');
INSERT INTO 0_sys_prefs VALUES ('no_item_list', 'setup.company', 'tinyint', '1', '0');
INSERT INTO 0_sys_prefs VALUES ('no_supplier_list', 'setup.company', 'tinyint', '1', '0');
INSERT INTO 0_sys_prefs VALUES ('no_zero_lines_amount', 'glsetup.sales', 'tinyint', '1', '1');
INSERT INTO 0_sys_prefs VALUES ('past_due_days', 'glsetup.general', 'int', '11', '30');
INSERT INTO 0_sys_prefs VALUES ('phone', 'setup.company', 'varchar', '30', '2327336-9 / 2449585');
INSERT INTO 0_sys_prefs VALUES ('po_over_charge', 'glsetup.purchase', 'int', '11', '10');
INSERT INTO 0_sys_prefs VALUES ('po_over_receive', 'glsetup.purchase', 'int', '11', '10');
INSERT INTO 0_sys_prefs VALUES ('postal_address', 'setup.company', 'tinytext', '0', 'No. 36, D.R. Wijewardena Mawatha,\r\nColombo 10.');
INSERT INTO 0_sys_prefs VALUES ('print_invoice_no', 'glsetup.sales', 'tinyint', '1', '0');
INSERT INTO 0_sys_prefs VALUES ('print_item_images_on_quote', 'glsetup.inventory', 'tinyint', '1', '0');
INSERT INTO 0_sys_prefs VALUES ('profit_loss_year_act', 'glsetup.general', 'varchar', '15', '9990');
INSERT INTO 0_sys_prefs VALUES ('pyt_discount_act', 'glsetup.purchase', 'varchar', '15', '5060');
INSERT INTO 0_sys_prefs VALUES ('retained_earnings_act', 'glsetup.general', 'varchar', '15', '3590');
INSERT INTO 0_sys_prefs VALUES ('round_to', 'setup.company', 'int', '5', '1');
INSERT INTO 0_sys_prefs VALUES ('show_po_item_codes', 'glsetup.purchase', 'tinyint', '1', '0');
INSERT INTO 0_sys_prefs VALUES ('suppress_tax_rates', 'setup.company', 'tinyint', '1', '');
INSERT INTO 0_sys_prefs VALUES ('tax_algorithm', 'glsetup.customer', 'tinyint', '1', '1');
INSERT INTO 0_sys_prefs VALUES ('tax_last', 'setup.company', 'int', '11', '1');
INSERT INTO 0_sys_prefs VALUES ('tax_prd', 'setup.company', 'int', '11', '1');
INSERT INTO 0_sys_prefs VALUES ('time_zone', 'setup.company', 'tinyint', '1', '1');
INSERT INTO 0_sys_prefs VALUES ('use_dimension', 'setup.company', 'tinyint', '1', '2');
INSERT INTO 0_sys_prefs VALUES ('use_fixed_assets', 'setup.company', 'tinyint', '1', '1');
INSERT INTO 0_sys_prefs VALUES ('use_manufacturing', 'setup.company', 'tinyint', '1', '');
INSERT INTO 0_sys_prefs VALUES ('version_id', 'system', 'varchar', '11', '2.4.1');

-- ----------------------------
-- Table structure for `0_sys_types`
-- ----------------------------
DROP TABLE IF EXISTS `0_sys_types`;
CREATE TABLE `0_sys_types` (
  `type_id` smallint(6) NOT NULL DEFAULT '0',
  `type_no` int(11) NOT NULL DEFAULT '1',
  `next_reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_sys_types
-- ----------------------------
INSERT INTO 0_sys_types VALUES ('0', '19', '00014');
INSERT INTO 0_sys_types VALUES ('1', '8', '00031');
INSERT INTO 0_sys_types VALUES ('2', '5', '00008');
INSERT INTO 0_sys_types VALUES ('4', '3', '00001');
INSERT INTO 0_sys_types VALUES ('10', '19', '00001');
INSERT INTO 0_sys_types VALUES ('11', '3', '00001');
INSERT INTO 0_sys_types VALUES ('12', '6', '00001');
INSERT INTO 0_sys_types VALUES ('13', '5', '00001');
INSERT INTO 0_sys_types VALUES ('16', '2', '00001');
INSERT INTO 0_sys_types VALUES ('17', '2', '00001');
INSERT INTO 0_sys_types VALUES ('18', '1', '00001');
INSERT INTO 0_sys_types VALUES ('20', '8', '00001');
INSERT INTO 0_sys_types VALUES ('21', '1', '00001');
INSERT INTO 0_sys_types VALUES ('22', '4', '00031');
INSERT INTO 0_sys_types VALUES ('25', '1', '00001');
INSERT INTO 0_sys_types VALUES ('26', '1', '00001');
INSERT INTO 0_sys_types VALUES ('28', '1', '00001');
INSERT INTO 0_sys_types VALUES ('29', '1', '00001');
INSERT INTO 0_sys_types VALUES ('30', '5', '00001');
INSERT INTO 0_sys_types VALUES ('32', '0', '00001');
INSERT INTO 0_sys_types VALUES ('35', '1', '00001');
INSERT INTO 0_sys_types VALUES ('40', '1', '00001');
INSERT INTO 0_sys_types VALUES ('50', '1', '');

-- ----------------------------
-- Table structure for `0_tags`
-- ----------------------------
DROP TABLE IF EXISTS `0_tags`;
CREATE TABLE `0_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_tags
-- ----------------------------

-- ----------------------------
-- Table structure for `0_tag_associations`
-- ----------------------------
DROP TABLE IF EXISTS `0_tag_associations`;
CREATE TABLE `0_tag_associations` (
  `record_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `tag_id` int(11) NOT NULL,
  UNIQUE KEY `record_id` (`record_id`,`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_tag_associations
-- ----------------------------

-- ----------------------------
-- Table structure for `0_tax_groups`
-- ----------------------------
DROP TABLE IF EXISTS `0_tax_groups`;
CREATE TABLE `0_tax_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_tax_groups
-- ----------------------------
INSERT INTO 0_tax_groups VALUES ('1', 'Tax', '0');
INSERT INTO 0_tax_groups VALUES ('2', 'Tax Exempt', '0');

-- ----------------------------
-- Table structure for `0_tax_group_items`
-- ----------------------------
DROP TABLE IF EXISTS `0_tax_group_items`;
CREATE TABLE `0_tax_group_items` (
  `tax_group_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `tax_shipping` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tax_group_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_tax_group_items
-- ----------------------------
INSERT INTO 0_tax_group_items VALUES ('1', '2', '0');
INSERT INTO 0_tax_group_items VALUES ('1', '3', '0');

-- ----------------------------
-- Table structure for `0_tax_types`
-- ----------------------------
DROP TABLE IF EXISTS `0_tax_types`;
CREATE TABLE `0_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rate` double NOT NULL DEFAULT '0',
  `sales_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `purchasing_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_tax_types
-- ----------------------------
INSERT INTO 0_tax_types VALUES ('1', '5', '2150', '2150', 'Tax', '0');
INSERT INTO 0_tax_types VALUES ('2', '2', '1101', '1101', 'NBT', '0');
INSERT INTO 0_tax_types VALUES ('3', '11', '1112', '1115', 'VAT', '0');

-- ----------------------------
-- Table structure for `0_trans_tax_details`
-- ----------------------------
DROP TABLE IF EXISTS `0_trans_tax_details`;
CREATE TABLE `0_trans_tax_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `tran_date` date NOT NULL,
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '0',
  `ex_rate` double NOT NULL DEFAULT '1',
  `included_in_price` tinyint(1) NOT NULL DEFAULT '0',
  `net_amount` double NOT NULL DEFAULT '0',
  `amount` double NOT NULL DEFAULT '0',
  `memo` tinytext COLLATE utf8_unicode_ci,
  `reg_type` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Type_and_Number` (`trans_type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_trans_tax_details
-- ----------------------------
INSERT INTO 0_trans_tax_details VALUES ('1', '13', '1', '2017-04-26', '0', '0', '1', '1', '150000', '0', 'auto', null);
INSERT INTO 0_trans_tax_details VALUES ('2', '13', '1', '2017-04-26', '0', '0', '1', '1', '150000', '0', 'auto', null);
INSERT INTO 0_trans_tax_details VALUES ('3', '10', '1', '2017-04-26', '0', '0', '1', '1', '150000', '0', 'S0001', '0');
INSERT INTO 0_trans_tax_details VALUES ('4', '10', '1', '2017-04-26', '0', '0', '1', '1', '150000', '0', 'S0001', '0');
INSERT INTO 0_trans_tax_details VALUES ('5', '13', '2', '2017-04-27', '3', '2', '1', '1', '1000', '20', 'auto', null);
INSERT INTO 0_trans_tax_details VALUES ('6', '13', '2', '2017-04-27', '3', '2', '1', '1', '1020', '153', 'auto', null);
INSERT INTO 0_trans_tax_details VALUES ('7', '10', '2', '2017-04-27', '3', '2', '1', '1', '1000', '20', 'S0002', '0');
INSERT INTO 0_trans_tax_details VALUES ('8', '10', '2', '2017-04-27', '2', '15', '1', '1', '1020', '153', 'S0002', '0');
INSERT INTO 0_trans_tax_details VALUES ('9', '13', '3', '2017-04-27', '2', '2', '1', '0', '1000', '20', 'auto', null);
INSERT INTO 0_trans_tax_details VALUES ('10', '13', '3', '2017-04-27', '2', '2', '1', '0', '1020', '112.2', 'auto', null);
INSERT INTO 0_trans_tax_details VALUES ('11', '10', '3', '2017-04-27', '2', '2', '1', '0', '1000', '20', 'S0003', '0');
INSERT INTO 0_trans_tax_details VALUES ('12', '10', '3', '2017-04-27', '3', '11', '1', '0', '1020', '112.2', 'S0003', '0');
INSERT INTO 0_trans_tax_details VALUES ('13', '1', '48', '2017-05-09', '2', '2', '1', '0', '0', '0', '', null);

-- ----------------------------
-- Table structure for `0_type_styles`
-- ----------------------------
DROP TABLE IF EXISTS `0_type_styles`;
CREATE TABLE `0_type_styles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ts_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `ts_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `inactive` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_type_styles
-- ----------------------------

-- ----------------------------
-- Table structure for `0_useronline`
-- ----------------------------
DROP TABLE IF EXISTS `0_useronline`;
CREATE TABLE `0_useronline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` int(15) NOT NULL DEFAULT '0',
  `ip` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `file` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB AUTO_INCREMENT=2435 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_useronline
-- ----------------------------
INSERT INTO 0_useronline VALUES ('2427', '1478005730', '124.43.16.168', '/index.php');
INSERT INTO 0_useronline VALUES ('2428', '1478005734', '124.43.16.168', '/index.php');
INSERT INTO 0_useronline VALUES ('2429', '1478005737', '124.43.16.168', '/admin/company_preferences.php');
INSERT INTO 0_useronline VALUES ('2430', '1478005737', '124.43.16.168', '/admin/company_preferences.php');
INSERT INTO 0_useronline VALUES ('2431', '1478005817', '124.43.16.168', '/index.php');
INSERT INTO 0_useronline VALUES ('2432', '1478005817', '124.43.16.168', '/index.php');
INSERT INTO 0_useronline VALUES ('2433', '1478005821', '124.43.16.168', '/admin/backups.php');
INSERT INTO 0_useronline VALUES ('2434', '1478005821', '124.43.16.168', '/admin/backups.php');

-- ----------------------------
-- Table structure for `0_users`
-- ----------------------------
DROP TABLE IF EXISTS `0_users`;
CREATE TABLE `0_users` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `real_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `role_id` int(11) NOT NULL DEFAULT '1',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_format` tinyint(1) NOT NULL DEFAULT '0',
  `date_sep` tinyint(1) NOT NULL DEFAULT '0',
  `tho_sep` tinyint(1) NOT NULL DEFAULT '0',
  `dec_sep` tinyint(1) NOT NULL DEFAULT '0',
  `theme` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'default',
  `page_size` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'A4',
  `prices_dec` smallint(6) NOT NULL DEFAULT '2',
  `qty_dec` smallint(6) NOT NULL DEFAULT '2',
  `rates_dec` smallint(6) NOT NULL DEFAULT '4',
  `percent_dec` smallint(6) NOT NULL DEFAULT '1',
  `show_gl` tinyint(1) NOT NULL DEFAULT '1',
  `show_codes` tinyint(1) NOT NULL DEFAULT '0',
  `show_hints` tinyint(1) NOT NULL DEFAULT '0',
  `last_visit_date` datetime DEFAULT NULL,
  `query_size` tinyint(1) unsigned NOT NULL DEFAULT '10',
  `graphic_links` tinyint(1) DEFAULT '1',
  `pos` smallint(6) DEFAULT '1',
  `print_profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `rep_popup` tinyint(1) DEFAULT '1',
  `sticky_doc_date` tinyint(1) DEFAULT '0',
  `startup_tab` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `transaction_days` int(6) NOT NULL DEFAULT '30' COMMENT 'Transaction days',
  `save_report_selections` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Save Report Selection Days',
  `use_date_picker` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Use Date Picker for all Date Values',
  `def_print_destination` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Default Report Destination',
  `def_print_orientation` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Default Report Orientation',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_users
-- ----------------------------
INSERT INTO 0_users VALUES ('1', 'admin', 'df1dff8d3728f6269822f0a2bfe3b9ae', 'Administrator', '2', '', 'evolve@3', 'C', '0', '0', '0', '0', 'bluecollar', 'A4', '2', '2', '4', '1', '1', '1', '1', '2017-06-01 01:26:12', '30', '1', '1', '', '1', '1', 'orders', '30', '0', '1', '0', '0', '0');
INSERT INTO 0_users VALUES ('14', 'gayan', '527ddb0fb00bac6dfcac3ba771f956f3', 'G.S.G. Perera', '9', '', 'gayan@corporate.cwmackie.com', 'C', '0', '0', '0', '0', 'bluecollar', 'A4', '2', '2', '4', '1', '1', '1', '1', '2017-04-26 05:02:57', '30', '1', '1', '', '1', '1', 'orders', '30', '0', '1', '0', '0', '0');

-- ----------------------------
-- Table structure for `0_voided`
-- ----------------------------
DROP TABLE IF EXISTS `0_voided`;
CREATE TABLE `0_voided` (
  `type` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_voided
-- ----------------------------
INSERT INTO 0_voided VALUES ('1', '15', '2017-03-31', 'Document reentered.');
INSERT INTO 0_voided VALUES ('1', '43', '2017-03-31', 'Document reentered.');
INSERT INTO 0_voided VALUES ('1', '47', '2017-04-26', 'Document reentered.');
INSERT INTO 0_voided VALUES ('1', '48', '2017-06-01', '');
INSERT INTO 0_voided VALUES ('2', '1', '2017-03-27', 'Document reentered.');

-- ----------------------------
-- Table structure for `0_workcentres`
-- ----------------------------
DROP TABLE IF EXISTS `0_workcentres`;
CREATE TABLE `0_workcentres` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_workcentres
-- ----------------------------
INSERT INTO 0_workcentres VALUES ('1', 'Workshop', 'Workshop in Alabama', '0');

-- ----------------------------
-- Table structure for `0_workorders`
-- ----------------------------
DROP TABLE IF EXISTS `0_workorders`;
CREATE TABLE `0_workorders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wo_ref` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_reqd` double NOT NULL DEFAULT '1',
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `required_by` date NOT NULL DEFAULT '0000-00-00',
  `released_date` date NOT NULL DEFAULT '0000-00-00',
  `units_issued` double NOT NULL DEFAULT '0',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `released` tinyint(1) NOT NULL DEFAULT '0',
  `additional_costs` double NOT NULL DEFAULT '0',
  `budjet_labour` double NOT NULL,
  `budjet_orverhead` double NOT NULL,
  `labour_cost` double NOT NULL,
  `orverhead_cost` double NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wo_ref` (`wo_ref`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_workorders
-- ----------------------------

-- ----------------------------
-- Table structure for `0_wo_costing`
-- ----------------------------
DROP TABLE IF EXISTS `0_wo_costing`;
CREATE TABLE `0_wo_costing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `cost_type` tinyint(1) NOT NULL DEFAULT '0',
  `trans_type` int(11) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `factor` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_wo_costing
-- ----------------------------

-- ----------------------------
-- Table structure for `0_wo_issues`
-- ----------------------------
DROP TABLE IF EXISTS `0_wo_issues`;
CREATE TABLE `0_wo_issues` (
  `issue_no` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workcentre_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`issue_no`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_wo_issues
-- ----------------------------

-- ----------------------------
-- Table structure for `0_wo_issue_items`
-- ----------------------------
DROP TABLE IF EXISTS `0_wo_issue_items`;
CREATE TABLE `0_wo_issue_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_id` int(11) DEFAULT NULL,
  `qty_issued` double DEFAULT NULL,
  `unit_cost` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_wo_issue_items
-- ----------------------------

-- ----------------------------
-- Table structure for `0_wo_manufacture`
-- ----------------------------
DROP TABLE IF EXISTS `0_wo_manufacture`;
CREATE TABLE `0_wo_manufacture` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_wo_manufacture
-- ----------------------------

-- ----------------------------
-- Table structure for `0_wo_requirements`
-- ----------------------------
DROP TABLE IF EXISTS `0_wo_requirements`;
CREATE TABLE `0_wo_requirements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre` int(11) NOT NULL DEFAULT '0',
  `units_req` double NOT NULL DEFAULT '1',
  `unit_cost` double NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_issued` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of 0_wo_requirements
-- ----------------------------

DELIMITER $$
CREATE DEFINER=`evolve8`@`localhost` FUNCTION `0_amortise`(assetid integer) RETURNS varchar(50) CHARSET latin1
    DETERMINISTIC
BEGIN
	declare periodid int;
	declare rate real;
	declare pvalue real;
	declare cvalue real;
	declare depreciation real;

	SELECT 0_asset_types.Depreciation_rate, 0_assets.purchase_value, YEAR(0_assets.purchase_date) INTO rate, pvalue, periodid
	FROM 0_asset_types INNER JOIN 0_assets ON 0_asset_types.asset_type_id = 0_assets.asset_type_id
	WHERE asset_id = assetid;

	DELETE FROM 0_amortisation WHERE (asset_id = assetid);

	set cvalue = pvalue;
	set depreciation = pvalue * rate / 100;
	WHILE (cvalue > 0) DO
		SET pvalue = 0;
		SELECT asset_value INTO pvalue
		FROM 0_asset_valuations
		WHERE (asset_id = assetid) AND (valuation_year = periodid);
		IF(pvalue > 1) THEN
			SET cvalue = pvalue;
			SET depreciation = pvalue * rate / 100;
		END IF;

		IF (cvalue < depreciation) THEN
			SET depreciation = cvalue;
		END IF;
		IF(depreciation > 1) THEN
			INSERT INTO 0_amortisation (asset_id, amortisation_year, asset_value, amount)
			VALUES (assetid, periodid, cvalue, depreciation);
		END IF;

		SET periodid = periodid + 1;
		SET cvalue = cvalue - depreciation;
	END WHILE;

	RETURN 'Done';
END$$
DELIMITER ;

DELIMITER $$
CREATE DEFINER=`evolve8`@`localhost` FUNCTION `0_get_item_tax`(itemcode varchar(20)) RETURNS double
    DETERMINISTIC
BEGIN
	DECLARE it_id int;
	DECLARE it_ex int;
	DECLARE itemtax real;

	SELECT 0_item_tax_types.id, 0_item_tax_types.exempt INTO it_id, it_ex
	FROM 0_stock_master INNER JOIN 0_item_tax_types ON 0_stock_master.tax_type_id = 0_item_tax_types.id
	WHERE (0_stock_master.stock_id = itemcode);

	SET itemtax = 0;
	IF (it_ex = 0) THEN
		SELECT SUM(0_tax_types.rate) INTO itemtax
		FROM  0_tax_types LEFT JOIN 0_item_tax_type_exemptions ON 0_tax_types.id = 0_item_tax_type_exemptions.tax_type_id
		WHERE 0_item_tax_type_exemptions.tax_type_id is null;
	END IF;

	RETURN itemtax;
END$$
DELIMITER ;

DELIMITER $$
CREATE DEFINER=`evolve8`@`localhost` FUNCTION `0_generate_po`() RETURNS varchar(50) CHARSET latin1
    DETERMINISTIC
BEGIN
	DECLARE u_gl decimal(5,0);
	DECLARE flag1 varchar(5) DEFAULT 'START';
	DECLARE rst varchar(50);
	DECLARE s_id integer;
	DECLARE i_c real;

	DECLARE cur1 CURSOR FOR SELECT 0_requisition_details.supplier_id, 
		sum(0_requisition_details.quantity * 0_requisition_details.price *
			(100 + 0_get_item_tax(0_requisition_details.item_code)) / 100)
	FROM 0_requisition_details
	WHERE (0_requisition_details.lpo_id = 0) AND (0_requisition_details.supplier_id > 0)
	GROUP BY 0_requisition_details.supplier_id
	ORDER BY 0_requisition_details.supplier_id;

	DECLARE CONTINUE HANDLER FOR NOT FOUND SET flag1 = 'END';
	SELECT CAST(next_reference as decimal(5,0)) INTO u_gl FROM 0_sys_types WHERE type_id = 18;

	-- Posting for po generation
	OPEN cur1;
	WHILE (flag1<>'END') DO
		FETCH cur1 INTO s_id, i_c;
		
		IF (flag1<>'END') THEN
			INSERT INTO 0_purch_orders (supplier_id, comments, ord_date, reference, requisition_no,
				into_stock_location, delivery_address, total, tax_included)
			VALUES (s_id, '', current_date(), u_gl, '', 'DEF', 'Address', i_c, 0);

			SET rst = 0_generate_po_items(LAST_INSERT_ID(), s_id);
			SET u_gl = u_gl + 1;
		END IF;
	END WHILE;
	CLOSE cur1;

	UPDATE 0_sys_types SET next_reference = u_gl WHERE type_id = 18;

	RETURN 'Done';
END$$
DELIMITER ;

DELIMITER $$
CREATE DEFINER=`evolve8`@`localhost` FUNCTION `0_generate_po_items`(po_id integer, s_id integer) RETURNS varchar(50) CHARSET latin1
    DETERMINISTIC
BEGIN
	DECLARE u_gl decimal(5,0);
	DECLARE flag2 varchar(5) DEFAULT 'START';
	DECLARE i_id varchar(20);
	DECLARE r_id integer;
	DECLARE i_q integer;
	DECLARE i_p real;
	DECLARE i_d varchar(200);

	DECLARE cur2 CURSOR FOR SELECT 0_item_codes.item_code, 0_item_codes.description,
		0_requisition_details.requisition_detail_id, 0_requisition_details.quantity, 0_requisition_details.price
	FROM 0_requisition_details INNER JOIN 0_item_codes ON 0_requisition_details.item_code = 0_item_codes.item_code
	WHERE (0_requisition_details.lpo_id = 0) AND (0_requisition_details.supplier_id = s_id);

	DECLARE CONTINUE HANDLER FOR NOT FOUND SET flag2 = 'END';

	-- Posting for po generation
	OPEN cur2;
	WHILE (flag2<>'END') DO
		FETCH cur2 INTO i_id, i_d, r_id, i_q, i_p;

		IF (flag2<>'END') THEN
			INSERT INTO 0_purch_order_details (order_no, item_code, description, delivery_date, qty_invoiced,
				unit_price, act_price, std_cost_unit, quantity_ordered, quantity_received)
			VALUES (po_id, i_id, i_d, current_date()+INTERVAL 14 day, 0, i_p, 0, 0, i_q, 0);

			UPDATE 0_requisition_details SET lpo_id = po_id WHERE requisition_detail_id = r_id;
		END IF;
	END WHILE;
	CLOSE cur2;

	RETURN 'Done';
END$$
DELIMITER ;

DELIMITER $$
CREATE DEFINER=`evolve8`@`localhost` FUNCTION `0_amortise_post`(yearid integer) RETURNS varchar(50) CHARSET latin1
    DETERMINISTIC
BEGIN
	DECLARE u_gl decimal(5,0);
	DECLARE flag1 varchar(5) DEFAULT 'START';
	DECLARE a_id integer;
	DECLARE a_a varchar(15);
	DECLARE a_b varchar(15);
	DECLARE a_c varchar(15);
	DECLARE da real;
	DECLARE pv real;
	DECLARE vc real;

	DECLARE cur1 CURSOR FOR SELECT 0_asset_types.depreciation_account, 0_asset_types.accumulated_account, 
		0_amortisation.amortisation_id, 0_amortisation.amount
	FROM 0_asset_types INNER JOIN 0_assets ON 0_asset_types.asset_type_id = 0_assets.asset_type_id
		INNER JOIN 0_amortisation ON 0_assets.asset_id = 0_amortisation.asset_id
	WHERE (0_amortisation.posted = 0) AND (amortisation_year = yearid);

	DECLARE cur2 CURSOR FOR SELECT 0_asset_types.asset_account, 0_asset_types.valuation_account, 
		0_asset_valuations.asset_valuation_id, 0_asset_valuations.value_change
	FROM 0_asset_types INNER JOIN 0_assets ON 0_asset_types.asset_type_id = 0_assets.asset_type_id
		INNER JOIN 0_asset_valuations ON 0_assets.asset_id = 0_asset_valuations.asset_id
	WHERE (0_asset_valuations.posted = 0) AND (0_asset_valuations.valuation_year = yearid);

	DECLARE cur3 CURSOR FOR SELECT 0_asset_types.asset_account, 0_asset_types.accumulated_account, 
		0_asset_types.disposal_account, 0_assets.asset_id,
		0_assets.disposal_amount, 0_assets.purchase_value,
		IFNULL(sum(0_asset_valuations.value_change), 0) as sum_value_change
	FROM 0_asset_types INNER JOIN 0_assets ON 0_asset_types.asset_type_id = 0_assets.asset_type_id
		LEFT JOIN 0_asset_valuations ON 0_assets.asset_id = 0_asset_valuations.asset_id
	WHERE (0_assets.disposal_posting = 0) AND (YEAR(disposal_date) = yearid)
	GROUP BY 0_asset_types.asset_account, 0_asset_types.accumulated_account, 
		0_asset_types.disposal_account, 0_assets.disposal_amount, 0_assets.purchase_value;

	DECLARE CONTINUE HANDLER FOR NOT FOUND SET flag1 = 'END';
	SELECT CAST(next_reference as decimal(5,0)) INTO u_gl FROM 0_sys_types WHERE type_id = 0;

	-- Depreciation posting
	OPEN cur1;
	WHILE flag1<>'END' DO
		FETCH cur1 INTO a_a, a_b, a_id, da;

		IF(flag1<>'END') THEN
			INSERT INTO 0_gl_trans (type, type_no, tran_date, account, memo_,
				amount, dimension_id, dimension2_id)
			VALUES (0, u_gl, current_date(), a_a, '', da, 0, 0); 

			INSERT INTO 0_gl_trans (type, type_no, tran_date, account, memo_,
				amount, dimension_id, dimension2_id)
			VALUES (0, u_gl, current_date(), a_b, '', da * (-1), 0, 0); 

			UPDATE 0_amortisation SET posted = u_gl WHERE amortisation_id = a_id;
			SET u_gl = u_gl + 1;
		END IF;
	END WHILE;
	CLOSE cur1;

	-- Re-valuation posting
	SET flag1 = 'START';
	OPEN cur2;
	WHILE flag1<>'END' DO
		FETCH cur2 INTO a_a, a_b, a_id, da;

		IF(flag1<>'END') THEN
			INSERT INTO 0_gl_trans (type, type_no, tran_date, account, memo_,
				amount, dimension_id, dimension2_id)
			VALUES (0, u_gl, current_date(), a_a, '', da, 0, 0); 

			INSERT INTO 0_gl_trans (type, type_no, tran_date, account, memo_,
				amount, dimension_id, dimension2_id)
			VALUES (0, u_gl, current_date(), a_b, '', da * (-1), 0, 0); 

			UPDATE 0_asset_valuations SET posted = u_gl WHERE asset_valuation_id = a_id;
			SET u_gl = u_gl + 1;
		END IF;
	END WHILE;
	CLOSE cur2;

	-- Disposal posting
	SET flag1 = 'START';
	OPEN cur3;
	WHILE flag1<>'END' DO
		FETCH cur3 INTO a_a, a_b, a_c, a_id, da, pv, vc;

		IF(flag1<>'END') THEN
			INSERT INTO 0_gl_trans (type, type_no, tran_date, account, memo_,
				amount, dimension_id, dimension2_id)
			VALUES (0, u_gl, current_date(), a_a, '', (pv + vc) * (-1) , 0, 0); 

			INSERT INTO 0_gl_trans (type, type_no, tran_date, account, memo_,
				amount, dimension_id, dimension2_id)
			VALUES (0, u_gl, current_date(), a_c, '', da, 0, 0); 

			INSERT INTO 0_gl_trans (type, type_no, tran_date, account, memo_,
				amount, dimension_id, dimension2_id)
			VALUES (0, u_gl, current_date(), a_b, '', (pv + vc - da), 0, 0); 

			UPDATE 0_assets SET disposal_posting = u_gl WHERE asset_id = a_id;
			SET u_gl = u_gl + 1;
		END IF;
	END WHILE;
	CLOSE cur3;

	UPDATE 0_sys_types SET next_reference = u_gl WHERE type_id = 0;

	RETURN 'Done';
END$$
DELIMITER ;

