<?php
/**********************************************************************
	Copyright (C) Evolve Techniologies
	Author : Danushka Widanage
	Email : dwidanage@gmail.com
	Company : Evolve Technologies(pvt)Ltd
***********************************************************************/
$page_security = 'SA_CUSTOMER';
$path_to_root = "../..";
include_once($path_to_root . "/includes/session.inc");

page(_($help_context = "Course Registration"));

include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/sales/includes/db/courses_db.inc");

simple_page_mode(true);
//----------------------------------------------------------------------------------------------------

function can_process()
{
	/*if (strlen($_POST['sales_type']) == 0)
	{
		display_error(_("The sales type description cannot be empty."));
		set_focus('sales_type');
		return false;
	}

	if (!check_num('factor', 0))
	{
		display_error(_("Calculation factor must be valid positive number."));
		set_focus('factor');
		return false;
	}*/
	return true;
}

//----------------------------------------------------------------------------------------------------

if ($Mode=='ADD_ITEM' && can_process())
{	
	add_courses($_POST['courseName'], $_POST['courseShortName'], $_POST['courseDuration'],input_num('courseRegFee'));
	display_notification(_('New course has been added'));
	$Mode = 'RESET';
}

//----------------------------------------------------------------------------------------------------

if ($Mode=='UPDATE_ITEM' && can_process())
{

	update_courses($selected_id, $_POST['courseName'], $_POST['courseShortName'], $_POST['courseDuration'],input_num('courseRegFee'));
	display_notification(_('Selected course has been updated'));
	$Mode = 'RESET';
}

//----------------------------------------------------------------------------------------------------

if ($Mode == 'Delete')
{
	// PREVENT DELETES IF DEPENDENT RECORDS IN 'debtor_trans'
	
	/*if (key_in_foreign_table($selected_id, 'debtor_trans', 'tpe'))
	{
		display_error(_("Cannot delete this course because student transactions have been created using this course."));

	}
	else
	{*/
		if (key_in_foreign_table($selected_id, 'cust_branch', 'course_id'))
		{
			display_error(_("Cannot delete this course because students are currently registered to the course."));
		}
		else
		{
			delete_courses($selected_id);
			display_notification(_('Selected course has been deleted'));
		}
	//} //end if sales type used in debtor transactions or in customers set up
	$Mode = 'RESET';
}

if ($Mode == 'RESET')
{
	$selected_id = -1;
	
	
	
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}
//----------------------------------------------------------------------------------------------------

$result = get_all_courses(check_value('show_inactive'));

start_form();
start_table(TABLESTYLE, "width=50%");

$th = array (_('Course Full Name'), _('Course Short Name'), _('Total Duration (Years)'),_('Total Course Fee'), '','');
inactive_control_column($th);
table_header($th);
$k = 0;
$base_sales = get_base_sales_type();

while ($myrow = db_fetch($result))
{
	if ($myrow["id"] == $base_sales)
	    start_row("class='overduebg'");
	else
	    alt_table_row_color($k);
	label_cell($myrow["course_full_name"]);
	label_cell($myrow["course_short_name"]);
	label_cell($myrow["total_duration"]);
	amount_cell($myrow["total_course_fee"]);
	inactive_control_cell($myrow["id"], $myrow["inactive"], 'courses', 'id');
 	edit_button_cell("Edit".$myrow['id'], _("Edit"));
 	delete_button_cell("Delete".$myrow['id'], _("Delete"));
	end_row();
}
inactive_control_row($th);
end_table();

//display_note(_("Marked sales type is the company base pricelist for prices calculations."), 0, 0, "class='overduefg'");

//----------------------------------------------------------------------------------------------------
 if (!isset($_POST['base']))
	$_POST['base'] = 0;

start_table(TABLESTYLE2);

if ($selected_id != -1)
{

 	if ($Mode == 'Edit') {
		//$myrow = get_sales_type($selected_id);
		$myrow = get_courses($selected_id);
		$_POST['courseName']  = $myrow["course_full_name"];
		$_POST['courseShortName']  = $myrow["course_short_name"];
		$_POST['courseDuration']  = $myrow["total_duration"];
		$_POST['courseRegFee']  = number_format2($myrow["total_course_fee"],2);
	}
	hidden('selected_id', $selected_id);
} else {
		$_POST['courseRegFee']  = number_format2(1,2);
}

text_row(_("Course Full Name").':', 'courseName', null);
text_row(_("Course Short Name").':', 'courseShortName', null);
totDuration_list_row(_("Course Duration:"), 'courseDuration', null);
amount_row(_("Total Course Fee:"), 'courseRegFee', null);



end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();

?>
