<?php
/**********************************************************************
	Copyright (C) Evolve Techniologies
	Author : Danushka Widanage
	Email : dwidanage@gmail.com
	Company : Evolve Technologies(pvt)Ltd
***********************************************************************/
$page_security = 'SA_CUSTPAYMREP';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	evolve
// date_:	2005-05-19
// Title:	Aged Customer Balances
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//----------------------------------------------------------------------------------------------------

print_aged_customer_analysis();



function get_customer_details_report($customer_id, $to=null, $from, $all=true)
{
	if ($to == null)
		$todate = date("Y-m-d");
	else
		$todate = date2sql($to);
		
		$from_date = date2sql($from);
		
		
	$past1 = get_company_pref('past_due_days');
	$past2 = 2 * $past1;
	// removed - debtor_trans.alloc from all summations

	if ($all)
  		$value = "(trans.ov_amount + trans.ov_gst + trans.ov_freight + trans.ov_freight_tax + trans.ov_discount)";
	else
    	$value = "(trans.ov_amount + trans.ov_gst + trans.ov_freight + trans.ov_freight_tax + trans.ov_discount - IFNULL(
			(SELECT SUM(amt) AS settlement FROM ".TB_PREF."cust_allocations WHERE ".TB_PREF."cust_allocations.trans_no_to = trans.trans_no AND date_alloc <= '$todate' AND date_alloc >= '$from_date'),0))";

	$due = "IF ((trans.type =".ST_SALESINVOICE."  OR ( trans.type=".ST_BANKPAYMENT." AND (trans.alloc + trans.ov_amount) != 0)), trans.due_date, trans.tran_date)";

    $sql = "SELECT ".TB_PREF."debtors_master.name, ".TB_PREF."debtors_master.curr_code, ".TB_PREF."payment_terms.terms,
		".TB_PREF."debtors_master.credit_limit, ".TB_PREF."credit_status.dissallow_invoices, ".TB_PREF."credit_status.reason_description,

		Sum(IFNULL($value,0)) AS Balance,
		Sum(IF ((TO_DAYS('$todate') - TO_DAYS($due)) >= 0,$value,0)) AS Due,
		Sum(IF ((TO_DAYS('$todate') - TO_DAYS($due)) >= $past1,$value,0)) AS Overdue1,
		Sum(IF ((TO_DAYS('$todate') - TO_DAYS($due)) >= $past2,$value,0)) AS Overdue2

		FROM ".TB_PREF."debtors_master
			 LEFT JOIN ".TB_PREF."debtor_trans trans ON 
			 trans.tran_date <= '$todate'  
			 AND trans.tran_date >= '$from_date'
			 AND ".TB_PREF."debtors_master.debtor_no = trans.debtor_no 
			 AND (trans.type =".ST_SALESINVOICE."  OR ( trans.type=".ST_BANKPAYMENT." AND (trans.ov_amount - trans.alloc) > 0)),
			 ".TB_PREF."payment_terms,
			 ".TB_PREF."credit_status

		WHERE
			 ".TB_PREF."debtors_master.payment_terms = ".TB_PREF."payment_terms.terms_indicator
 			 AND ".TB_PREF."debtors_master.credit_status = ".TB_PREF."credit_status.id
			 AND ".TB_PREF."debtors_master.debtor_no = ".db_escape($customer_id)."";
	if (!$all)
		$sql .= "AND ABS(trans.ov_amount + trans.ov_gst + trans.ov_freight + trans.ov_freight_tax + trans.ov_discount - trans.alloc) > ".FLOAT_COMP_DELTA." ";  

	$sql .=	" GROUP BY
			  ".TB_PREF."debtors_master.name,
			  ".TB_PREF."payment_terms.terms,
			  ".TB_PREF."payment_terms.days_before_due,
			  ".TB_PREF."payment_terms.day_in_following_month,
			  ".TB_PREF."debtors_master.credit_limit,
			  ".TB_PREF."credit_status.dissallow_invoices,
			  ".TB_PREF."credit_status.reason_description";
    $result = db_query($sql,"The customer details could not be retrieved");

    $customer_record = db_fetch($result);

    return $customer_record;

}


function get_invoices($customer_id, $to, $from, $all=true)
{
	$todate = date2sql($to);
	$from_date = date2sql($from);
	
	$PastDueDays1 = get_company_pref('past_due_days');
	$PastDueDays2 = 2 * $PastDueDays1;

	// Revomed allocated from sql
    $value = "(".TB_PREF."debtor_trans.ov_amount + ".TB_PREF."debtor_trans.ov_gst + "
		.TB_PREF."debtor_trans.ov_freight + ".TB_PREF."debtor_trans.ov_freight_tax + "
		.TB_PREF."debtor_trans.ov_discount - IFNULL(
		(SELECT SUM(amt) AS settlement FROM ".TB_PREF."cust_allocations WHERE ".TB_PREF."cust_allocations.trans_no_to = ".TB_PREF."debtor_trans.trans_no 
		AND date_alloc <= '$todate' AND date_alloc >= '$from_date'),0))";
	
	$due = "IF ((".TB_PREF."debtor_trans.type=".ST_SALESINVOICE." 
				OR ( ".TB_PREF."debtor_trans.type=".ST_BANKPAYMENT." AND (".TB_PREF."debtor_trans.alloc + ".TB_PREF."debtor_trans.ov_amount) != 0)),
				".TB_PREF."debtor_trans.due_date,".TB_PREF."debtor_trans.tran_date)";
	
	$sql = "SELECT DISTINCT ".TB_PREF."debtor_trans.reference, ".TB_PREF."debtor_trans.type, 
		".TB_PREF."debtor_trans.tran_date, ".TB_PREF."debtor_trans.trans_no,
		$value as Balance,
		IF ((TO_DAYS('$todate') - TO_DAYS($due)) >= 0,$value,0) AS Due,
		IF ((TO_DAYS('$todate') - TO_DAYS($due)) >= $PastDueDays1,$value,0) AS Overdue1,
		IF ((TO_DAYS('$todate') - TO_DAYS($due)) >= $PastDueDays2,$value,0) AS Overdue2

		FROM ".TB_PREF."debtors_master,
			".TB_PREF."payment_terms,
			".TB_PREF."debtor_trans

		WHERE (".TB_PREF."debtor_trans.type = ".ST_SALESINVOICE." 
					OR ( ".TB_PREF."debtor_trans.type=".ST_BANKPAYMENT." AND ((".TB_PREF."debtor_trans.alloc + ".TB_PREF."debtor_trans.ov_amount) != 0)))
		
			AND ((".TB_PREF."debtor_trans.payment_terms = ".TB_PREF."payment_terms.terms_indicator) OR ".TB_PREF."debtor_trans.payment_terms is null)
			AND ".TB_PREF."debtors_master.debtor_no = ".TB_PREF."debtor_trans.debtor_no
			AND ".TB_PREF."debtor_trans.debtor_no = $customer_id 
			AND ".TB_PREF."debtor_trans.tran_date <= '$todate'
			AND ".TB_PREF."debtor_trans.tran_date >= '$from_date'
			AND ".TB_PREF."debtor_trans.ov_amount != ".TB_PREF."debtor_trans.alloc
			AND ABS($value) > ".FLOAT_COMP_DELTA."";
		
			
		$sql .=	" ORDER BY ".TB_PREF."debtor_trans.tran_date";

	return db_query($sql, "The customer details could not be retrieved");
}

//----old
/*function get_invoices($customer_id, $to, $all=true)
{
	$todate = date2sql($to);
	$PastDueDays1 = get_company_pref('past_due_days');
	$PastDueDays2 = 2 * $PastDueDays1;

	// Revomed allocated from sql
	if ($all)
    	$value = "(".TB_PREF."debtor_trans.ov_amount + ".TB_PREF."debtor_trans.ov_gst + "
			.TB_PREF."debtor_trans.ov_freight + ".TB_PREF."debtor_trans.ov_freight_tax + "
			.TB_PREF."debtor_trans.ov_discount - ".TB_PREF."debtor_trans.alloc)";
	else		
    	$value = "(".TB_PREF."debtor_trans.ov_amount + ".TB_PREF."debtor_trans.ov_gst + "
			.TB_PREF."debtor_trans.ov_freight + ".TB_PREF."debtor_trans.ov_freight_tax + "
			.TB_PREF."debtor_trans.ov_discount - ".TB_PREF."debtor_trans.alloc)";
			
	$due = "IF (".TB_PREF."debtor_trans.type=".ST_SALESINVOICE.",".TB_PREF."debtor_trans.due_date,".TB_PREF."debtor_trans.tran_date)";
	$sql = "SELECT ".TB_PREF."debtor_trans.type, ".TB_PREF."debtor_trans.reference,
		".TB_PREF."debtor_trans.tran_date,
		$value as Balance,
		IF ((TO_DAYS('$todate') - TO_DAYS($due)) >= 0,$value,0) AS Due,
		IF ((TO_DAYS('$todate') - TO_DAYS($due)) >= $PastDueDays1,$value,0) AS Overdue1,
		IF ((TO_DAYS('$todate') - TO_DAYS($due)) >= $PastDueDays2,$value,0) AS Overdue2

		FROM ".TB_PREF."debtors_master,
			".TB_PREF."debtor_trans

		WHERE ".TB_PREF."debtor_trans.type <> ".ST_CUSTDELIVERY."
		
			AND ".TB_PREF."debtor_trans.alloc >= 0
		
			AND (".TB_PREF."debtor_trans.alloc != (".TB_PREF."debtor_trans.ov_amount + 
													".TB_PREF."debtor_trans.ov_gst + 
													".TB_PREF."debtor_trans.ov_freight + 
													".TB_PREF."debtor_trans.ov_freight_tax + 
													".TB_PREF."debtor_trans.ov_discount))
													
			AND ".TB_PREF."debtors_master.debtor_no = ".TB_PREF."debtor_trans.debtor_no
			AND ".TB_PREF."debtor_trans.debtor_no = $customer_id 
			AND ".TB_PREF."debtor_trans.tran_date <= '$todate'
			AND ABS(".TB_PREF."debtor_trans.ov_amount + ".TB_PREF."debtor_trans.ov_gst + ".TB_PREF."debtor_trans.ov_freight + ".TB_PREF."debtor_trans.ov_freight_tax + ".TB_PREF."debtor_trans.ov_discount) > ".FLOAT_COMP_DELTA." ";
	if (!$all)
		$sql .= "AND ABS(".TB_PREF."debtor_trans.ov_amount + ".TB_PREF."debtor_trans.ov_gst + ".TB_PREF."debtor_trans.ov_freight + ".TB_PREF."debtor_trans.ov_freight_tax + ".TB_PREF."debtor_trans.ov_discount - ".TB_PREF."debtor_trans.alloc) > ".FLOAT_COMP_DELTA." ";  
	$sql .= "ORDER BY ".TB_PREF."debtor_trans.tran_date";

	return db_query($sql, "The customer details could not be retrieved");
}
*/
//----------------------------------------------------------------------------------------------------

function print_aged_customer_analysis()
{
    global $path_to_root, $systypes_array;

    	$from_date			= $_POST['PARAM_0'];
		$to					= $_POST['PARAM_1'];
    	$fromcust			= $_POST['PARAM_2'];
    	$currency			= $_POST['PARAM_3'];
    	$show_all			= $_POST['PARAM_4'];
		$summaryOnly		= $_POST['PARAM_5'];
    	$no_zeros 			= $_POST['PARAM_6'];
		
		$sales_men 			= $_POST['PARAM_7'];//-----dwidanage----
		$gl_codes 			= $_POST['PARAM_8'];//-----dwidanage----
		
    	$graphics 			= $_POST['PARAM_9'];
    	$comments 			= $_POST['PARAM_10'];
		$destination		= $_POST['PARAM_11'];
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	if ($graphics)
	{
		include_once($path_to_root . "/reporting/includes/class.graphic.inc");
		$pg = new graph();
	}

	if ($fromcust == ALL_TEXT)
		$from = _('All');
	else
		$from = get_customer_name($fromcust);
    	$dec = user_price_dec();

	if ($summaryOnly == 1)
		$summary = _('Summary Only');
	else
		$summary = _('Detailed Report');
	if ($currency == ALL_TEXT)
	{
		$convert = true;
		$currency = _('Balances in Home Currency');
	}
	else
		$convert = false;

	if ($no_zeros) $nozeros = _('Yes');
	else $nozeros = _('No');
	if ($show_all) $show = _('Yes');
	else $show = _('No');

	$PastDueDays1 = get_company_pref('past_due_days');
	$PastDueDays2 = 2 * $PastDueDays1;
	$nowdue = "1-" . $PastDueDays1 . " " . _('Days');
	$pastdue1 = $PastDueDays1 + 1 . "-" . $PastDueDays2 . " " . _('Days');
	$pastdue2 = _('Over') . " " . $PastDueDays2 . " " . _('Days');

	$cols = array(0, 100, 130, 190,	250, 320, 385, 450,	515);
	$headers = array(_('Customer'),	'',	'',	_('Current'), $nowdue, $pastdue1, $pastdue2, _('Total Balance'));

	$aligns = array('left',	'left',	'left',	'right', 'right', 'right', 'right',	'right');

    	$params =   array( 	0 => $comments,
    				1 => array('text' => _('Date Range'), 'from' => $from_date.' - '.$to, 'to' => ''),
    				2 => array('text' => _('Customer'),	'from' => $from, 'to' => ''),
    				3 => array('text' => _('Currency'), 'from' => $currency, 'to' => ''),
                    4 => array('text' => _('Type'),		'from' => $summary,'to' => ''),
                    5 => array('text' => _('Show Also Allocated'), 'from' => $show, 'to' => ''),		
					6 => array('text' => _('Suppress Zeros'), 'from' => $nozeros, 'to' => ''));

	if ($convert)
		$headers[2] = _('Currency');
    	$rep = new FrontReport(_('Aged Customer Analysis'), "AgedCustomerAnalysis", user_pagesize());

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

	$total = array(0,0,0,0, 0);

	
	$sql = "SELECT ".TB_PREF."debtors_master.debtor_no, name, curr_code, ".TB_PREF."salesman.salesman_code, ".TB_PREF."debtors_master.debtor_ref
			FROM ".TB_PREF."debtors_master, ".TB_PREF."cust_branch, ".TB_PREF."salesman
			WHERE ".TB_PREF."cust_branch.debtor_no = ".TB_PREF."debtors_master.debtor_no 
			AND ".TB_PREF."salesman.salesman_code = ".TB_PREF."cust_branch.salesman ";
	if ($fromcust != ALL_TEXT)
		$sql .= " AND ".TB_PREF."debtors_master.debtor_no=".db_escape($fromcust);
		
//------@widanage add new code for salesmen listing report	-----03.07.2013-------	
	if ($sales_men != -1)
		$sql .= " AND ".TB_PREF."salesman.salesman_code =".db_escape($sales_men);
	if ($gl_codes != '')
		$sql .= " AND ".TB_PREF."cust_branch.receivables_account =".db_escape($gl_codes);
		
		
	$sql .= " ORDER BY salesman_code";


	/*$sql = "SELECT debtor_no, name, curr_code FROM ".TB_PREF."debtors_master";
	if ($fromcust != ALL_TEXT)
		$sql .= " WHERE debtor_no=".db_escape($fromcust);
	$sql .= " ORDER BY name";*/
	
	$result = db_query($sql, "The customers could not be retrieved");

	while ($myrow=db_fetch($result))
	{
		if (!$convert && $currency != $myrow['curr_code'])
			continue;

		if ($convert) $rate = get_exchange_rate_from_home_currency($myrow['curr_code'], $to);
		else $rate = 1.0;
		//$custrec = get_customer_details($myrow['debtor_no'], $to, $show_all);
		$custrec = get_customer_details_report($myrow['debtor_no'], $to, $from_date, $show_all);//-------dwidanage add new code-----
		
		if (!$custrec)
			continue;
		$custrec['Balance'] *= $rate;
		$custrec['Due'] *= $rate;
		$custrec['Overdue1'] *= $rate;
		$custrec['Overdue2'] *= $rate;
		$str = array($custrec["Balance"] - $custrec["Due"],
			$custrec["Due"]-$custrec["Overdue1"],
			$custrec["Overdue1"]-$custrec["Overdue2"],
			$custrec["Overdue2"],
			$custrec["Balance"]);
		if ($no_zeros && floatcmp(array_sum($str), 0) == 0) continue;

		$rep->fontSize += 2;
		$rep->TextCol(0, 2, $myrow['name']);
		if ($convert) $rep->TextCol(2, 3,	$myrow['curr_code'].'-'.$myrow['debtor_ref']);
		$rep->fontSize -= 2;
		$total[0] += ($custrec["Balance"] - $custrec["Due"]);
		$total[1] += ($custrec["Due"]-$custrec["Overdue1"]);
		$total[2] += ($custrec["Overdue1"]-$custrec["Overdue2"]);
		$total[3] += $custrec["Overdue2"];
		$total[4] += $custrec["Balance"];
		for ($i = 0; $i < count($str); $i++)
			$rep->AmountCol($i + 3, $i + 4, $str[$i], $dec);
		$rep->NewLine(1, 2);
		if (!$summaryOnly)
		{
			$res = get_invoices($myrow['debtor_no'], $to, $from_date, $show_all);
    		if (db_num_rows($res)==0)
				continue;
    		$rep->Line($rep->row + 4);
			while ($trans=db_fetch($res))
			{
				$rep->NewLine(1, 2);
        		$rep->TextCol(0, 1, $systypes_array[$trans['type']], -2);
				$rep->TextCol(1, 2,	$trans['reference'], -2);
				$rep->DateCol(2, 3, $trans['tran_date'], true, -2);
				if ($trans['type'] == ST_CUSTCREDIT || $trans['type'] == ST_CUSTPAYMENT || $trans['type'] == ST_BANKDEPOSIT)
				{
					$trans['Balance'] *= -1;
					$trans['Due'] *= -1;
					$trans['Overdue1'] *= -1;
					$trans['Overdue2'] *= -1;
				}
				foreach ($trans as $i => $value)
					$trans[$i] *= $rate;
				$str = array($trans["Balance"] - $trans["Due"],
					$trans["Due"]-$trans["Overdue1"],
					$trans["Overdue1"]-$trans["Overdue2"],
					$trans["Overdue2"],
					$trans["Balance"]);
				for ($i = 0; $i < count($str); $i++)
					$rep->AmountCol($i + 3, $i + 4, $str[$i], $dec);
			}
			$rep->Line($rep->row - 8);
			$rep->NewLine(2);
		}
	}
	if ($summaryOnly)
	{
    	$rep->Line($rep->row  + 4);
    	$rep->NewLine();
	}
	$rep->fontSize += 2;
	$rep->TextCol(0, 3, _('Grand Total'));
	$rep->fontSize -= 2;
	for ($i = 0; $i < count($total); $i++)
	{
		$rep->AmountCol($i + 3, $i + 4, $total[$i], $dec);
		if ($graphics && $i < count($total) - 1)
		{
			$pg->y[$i] = abs($total[$i]);
		}
	}
   	$rep->Line($rep->row - 8);
   	if ($graphics)
   	{
   		global $decseps, $graph_skin;
		$pg->x = array(_('Current'), $nowdue, $pastdue1, $pastdue2);
		$pg->title     = $rep->title;
		$pg->axis_x    = _("Days");
		$pg->axis_y    = _("Amount");
		$pg->graphic_1 = $to;
		$pg->type      = $graphics;
		$pg->skin      = $graph_skin;
		$pg->built_in  = false;
		$pg->latin_notation = ($decseps[$_SESSION["wa_current_user"]->prefs->dec_sep()] != ".");
		$filename = company_path(). "/pdf_files/". uniqid("").".png";
		$pg->display($filename, true);
		$w = $pg->width / 1.5;
		$h = $pg->height / 1.5;
		$x = ($rep->pageWidth - $w) / 2;
		$rep->NewLine(2);
		if ($rep->row - $h < $rep->bottomMargin)
			$rep->NewPage();
		$rep->AddImage($filename, $x, $rep->row - $h, $w, $h);
	}
	$rep->NewLine();
    $rep->End();
}

?>
