# MySQL dump of database 'demeland_evolve6' on host 'localhost'
# Backup Date and Time: 2016-12-15 00:35
# Built by EvolveAccounting EVOLVE360v6
# http://evolve-sl.com
# Company: The Golden Palm
# User: Administrator

# Compatibility: 2.4.1


SET NAMES latin1;


### Structure of table `6_amortisation` ###

DROP TABLE IF EXISTS `6_amortisation`;

CREATE TABLE `6_amortisation` (
  `amortisation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `amortisation_year` int(11) DEFAULT NULL,
  `asset_value` double DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `posted` int(11) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`amortisation_id`),
  UNIQUE KEY `amortisation_id` (`amortisation_id`),
  KEY `6_amortisation_asset_id` (`asset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_amortisation` ###


### Structure of table `6_areas` ###

DROP TABLE IF EXISTS `6_areas`;

CREATE TABLE `6_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_areas` ###

INSERT INTO `6_areas` VALUES
('1', 'Global', '0'),
('2', 'Colombo', '0');

### Structure of table `6_asset_types` ###

DROP TABLE IF EXISTS `6_asset_types`;

CREATE TABLE `6_asset_types` (
  `asset_type_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_type_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `depreciation_type` int(11) NOT NULL DEFAULT '1',
  `depreciation_rate` double NOT NULL DEFAULT '10',
  `asset_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `depreciation_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `accumulated_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `valuation_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `disposal_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_type_id`),
  UNIQUE KEY `asset_type_id` (`asset_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_asset_types` ###


### Structure of table `6_asset_valuations` ###

DROP TABLE IF EXISTS `6_asset_valuations`;

CREATE TABLE `6_asset_valuations` (
  `asset_valuation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `valuation_year` int(11) DEFAULT NULL,
  `asset_value` double NOT NULL DEFAULT '0',
  `value_change` double NOT NULL DEFAULT '0',
  `posted` int(11) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_valuation_id`),
  UNIQUE KEY `asset_valuation_id` (`asset_valuation_id`),
  UNIQUE KEY `asset_id` (`asset_id`,`valuation_year`),
  KEY `6_asset_valuations_asset_id` (`asset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_asset_valuations` ###


### Structure of table `6_assets` ###

DROP TABLE IF EXISTS `6_assets`;

CREATE TABLE `6_assets` (
  `asset_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_type_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `asset_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_serial` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `purchase_date` date NOT NULL,
  `purchase_value` double NOT NULL,
  `disposal_amount` double DEFAULT NULL,
  `disposal_date` date DEFAULT NULL,
  `disposal_posting` int(11) DEFAULT '0',
  `tag_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_location` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_condition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_acquisition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_id`),
  UNIQUE KEY `asset_id` (`asset_id`),
  KEY `6_assets_asset_type_id` (`asset_type_id`),
  KEY `6_assets_item_id` (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_assets` ###


### Structure of table `6_attachments` ###

DROP TABLE IF EXISTS `6_attachments`;

CREATE TABLE `6_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_no` int(11) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `unique_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT '0',
  `filetype` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_attachments` ###


### Structure of table `6_audit_trail` ###

DROP TABLE IF EXISTS `6_audit_trail`;

CREATE TABLE `6_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `user` smallint(6) unsigned NOT NULL DEFAULT '0',
  `stamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL DEFAULT '0',
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=816 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_audit_trail` ###

INSERT INTO `6_audit_trail` VALUES
('1', '1', '1', '1', '2016-11-17 04:47:07', NULL, '1', '2015-07-24', '0'),
('2', '2', '1', '1', '2016-11-18 05:20:32', NULL, '1', '2015-07-24', NULL),
('3', '2', '2', '1', '2016-11-21 03:42:59', NULL, '2', '2015-07-24', NULL),
('4', '0', '1', '1', '2016-11-18 05:19:38', NULL, '1', '2015-07-24', NULL),
('5', '2', '3', '1', '2016-11-21 03:41:53', NULL, '1', '2015-07-24', NULL),
('6', '1', '2', '1', '2016-11-17 05:03:19', NULL, '1', '2015-08-06', '0'),
('7', '1', '3', '1', '2016-11-17 05:04:54', NULL, '1', '2015-08-20', '0'),
('8', '0', '1', '1', '2016-11-18 05:19:38', 'Voided.\n', '1', '2016-03-31', '0'),
('9', '2', '1', '1', '2016-11-18 05:20:32', 'Voided.\n', '1', '2016-02-15', '0'),
('10', '2', '3', '1', '2016-11-21 03:41:53', 'Voided.\n', '1', '2016-03-31', '0'),
('11', '2', '4', '1', '2016-11-21 03:45:17', NULL, '2', '2015-07-24', NULL),
('12', '2', '2', '1', '2016-11-21 03:42:59', 'Voided.\nDocument reentered.', '2', '2016-11-21', '0'),
('13', '2', '5', '1', '2016-11-21 03:45:17', NULL, '1', '2015-07-24', '0'),
('14', '2', '4', '1', '2016-11-21 03:45:17', 'Voided.\nDocument reentered.', '2', '2016-11-21', '0'),
('15', '4', '1', '1', '2016-11-21 03:47:34', NULL, '1', '2015-07-29', '0'),
('16', '4', '2', '1', '2016-11-21 03:51:24', NULL, '1', '2015-08-04', '0'),
('17', '4', '3', '1', '2016-11-21 03:53:07', NULL, '1', '2015-08-05', '0'),
('18', '4', '4', '1', '2016-11-21 03:53:56', NULL, '1', '2015-08-05', '0'),
('19', '4', '5', '1', '2016-11-21 03:55:26', NULL, '1', '2015-08-06', '0'),
('20', '4', '6', '1', '2016-11-21 03:57:58', NULL, '1', '2015-08-12', '0'),
('21', '4', '7', '1', '2016-11-21 03:58:51', NULL, '1', '2015-08-14', '0'),
('22', '4', '8', '1', '2016-11-21 03:59:31', NULL, '1', '2015-08-14', '0'),
('23', '4', '9', '1', '2016-11-22 00:44:25', NULL, '1', '2015-08-14', '0'),
('24', '4', '10', '1', '2016-11-22 00:45:07', NULL, '1', '2015-08-14', '0'),
('25', '4', '11', '1', '2016-11-22 00:45:56', NULL, '1', '2015-08-20', '0'),
('26', '4', '12', '1', '2016-11-22 00:54:10', NULL, '1', '2015-08-25', '0'),
('27', '1', '4', '1', '2016-11-30 06:17:59', NULL, '2', '2015-08-26', NULL),
('28', '4', '13', '1', '2016-11-22 00:57:47', NULL, '1', '2015-08-27', '0'),
('29', '4', '14', '1', '2016-11-22 00:58:54', NULL, '1', '2015-08-31', '0'),
('30', '1', '5', '1', '2016-11-22 01:06:49', NULL, '1', '2015-08-31', '0'),
('31', '1', '6', '1', '2016-11-22 01:21:18', NULL, '1', '2015-09-01', '0'),
('32', '4', '15', '1', '2016-11-22 01:23:08', NULL, '1', '2015-09-02', '0'),
('33', '4', '16', '1', '2016-11-22 01:24:39', NULL, '1', '2015-09-03', '0'),
('34', '4', '17', '1', '2016-11-22 01:25:49', NULL, '1', '2015-09-07', '0'),
('35', '4', '18', '1', '2016-11-22 01:34:23', NULL, '1', '2015-09-09', '0'),
('36', '4', '19', '1', '2016-11-22 01:35:36', NULL, '1', '2015-09-09', '0'),
('37', '4', '20', '1', '2016-11-22 01:36:22', NULL, '1', '2015-09-09', '0'),
('38', '1', '7', '1', '2016-11-22 01:50:56', NULL, '1', '2015-09-09', '0'),
('39', '4', '21', '1', '2016-11-22 01:53:07', NULL, '1', '2015-09-10', '0'),
('40', '4', '22', '1', '2016-11-22 01:54:31', NULL, '1', '2015-09-10', '0'),
('41', '4', '23', '1', '2016-11-22 02:18:18', NULL, '1', '2015-09-11', '0'),
('42', '4', '24', '1', '2016-11-22 02:19:08', NULL, '1', '2015-09-14', '0'),
('43', '1', '8', '1', '2016-11-22 02:20:57', NULL, '1', '2015-09-17', '0'),
('44', '4', '25', '1', '2016-11-22 02:22:28', NULL, '1', '2015-09-18', '0'),
('45', '4', '26', '1', '2016-11-22 02:23:06', NULL, '1', '2015-09-21', '0'),
('46', '4', '27', '1', '2016-11-22 02:23:34', NULL, '1', '2016-03-31', '0'),
('47', '4', '28', '1', '2016-11-22 02:23:59', NULL, '1', '2015-09-21', '0'),
('48', '4', '29', '1', '2016-11-22 02:25:53', NULL, '1', '2015-09-22', '0'),
('49', '4', '30', '1', '2016-11-22 02:26:31', NULL, '1', '2015-09-23', '0'),
('50', '4', '31', '1', '2016-11-22 02:27:12', NULL, '1', '2015-09-25', '0'),
('51', '4', '32', '1', '2016-11-22 02:40:08', NULL, '1', '2015-09-30', '0'),
('52', '4', '33', '1', '2016-11-22 02:40:43', NULL, '1', '2015-09-30', '0'),
('53', '4', '34', '1', '2016-11-22 02:41:17', NULL, '1', '2016-03-31', '0'),
('54', '4', '35', '1', '2016-11-22 02:41:46', NULL, '1', '2015-10-05', '0'),
('55', '4', '36', '1', '2016-11-23 00:26:47', NULL, '1', '2015-10-01', '0'),
('56', '4', '37', '1', '2016-11-23 00:33:34', NULL, '1', '2015-10-06', '0'),
('57', '4', '38', '1', '2016-11-23 00:34:56', NULL, '1', '2015-10-08', '0'),
('58', '4', '39', '1', '2016-11-23 00:35:54', NULL, '1', '2015-10-09', '0'),
('59', '4', '40', '1', '2016-11-23 00:36:58', NULL, '1', '2015-10-12', '0'),
('60', '4', '41', '1', '2016-11-23 00:37:38', NULL, '1', '2015-10-12', '0'),
('61', '4', '42', '1', '2016-11-23 00:43:08', NULL, '1', '2015-10-15', '0'),
('62', '1', '9', '1', '2016-11-23 00:47:33', NULL, '1', '2015-10-15', '0'),
('63', '4', '43', '1', '2016-11-23 00:48:53', NULL, '1', '2015-10-16', '0'),
('64', '4', '44', '1', '2016-11-23 00:49:39', NULL, '1', '2015-10-16', '0'),
('65', '2', '6', '1', '2016-11-23 00:55:20', NULL, '1', '2015-10-16', '0'),
('66', '1', '10', '1', '2016-11-23 00:58:26', NULL, '1', '2015-10-16', '0'),
('67', '4', '45', '1', '2016-11-23 00:59:52', NULL, '1', '2015-10-19', '0'),
('68', '1', '11', '1', '2016-11-23 01:01:30', NULL, '1', '2015-10-19', '0'),
('69', '1', '12', '1', '2016-11-23 01:03:06', NULL, '1', '2015-10-19', '0'),
('70', '4', '46', '1', '2016-11-23 01:23:11', NULL, '1', '2015-10-21', '0'),
('71', '2', '7', '1', '2016-11-23 01:31:19', NULL, '1', '2015-10-22', '0'),
('72', '4', '47', '1', '2016-11-23 01:32:56', NULL, '1', '2015-10-23', '0'),
('73', '4', '48', '1', '2016-11-23 01:33:51', NULL, '1', '2015-10-23', '0'),
('74', '4', '49', '1', '2016-11-23 01:34:29', NULL, '1', '2015-10-26', '0'),
('75', '4', '50', '1', '2016-11-23 01:35:02', NULL, '1', '2015-10-26', '0'),
('76', '4', '51', '1', '2016-11-23 01:35:52', NULL, '1', '2015-10-26', '0'),
('77', '4', '52', '1', '2016-11-23 01:36:33', NULL, '1', '2015-10-29', '0'),
('78', '4', '53', '1', '2016-11-23 01:37:13', NULL, '1', '2015-10-30', '0'),
('79', '4', '54', '1', '2016-11-23 01:37:58', NULL, '1', '2015-11-02', '0'),
('80', '4', '55', '1', '2016-11-23 01:39:28', NULL, '1', '2015-11-03', '0'),
('81', '2', '8', '1', '2016-11-23 02:03:06', NULL, '1', '2015-11-05', '0'),
('82', '1', '13', '1', '2016-11-23 02:05:20', NULL, '1', '2015-11-05', '0'),
('83', '4', '56', '1', '2016-11-23 02:06:20', NULL, '1', '2015-11-06', '0'),
('84', '4', '57', '1', '2016-11-23 02:07:01', NULL, '1', '2015-11-09', '0'),
('85', '4', '58', '1', '2016-11-23 02:07:36', NULL, '1', '2015-11-09', '0'),
('86', '1', '14', '1', '2016-11-23 02:10:55', NULL, '1', '2015-11-09', '0'),
('87', '4', '59', '1', '2016-11-23 02:13:50', NULL, '1', '2015-11-11', '0'),
('88', '4', '60', '1', '2016-11-23 02:14:24', NULL, '1', '2015-11-11', '0'),
('89', '4', '61', '1', '2016-11-23 02:16:10', NULL, '1', '2015-11-12', '0'),
('90', '1', '15', '1', '2016-11-23 02:17:50', NULL, '1', '2015-11-12', '0'),
('91', '4', '62', '1', '2016-11-23 02:18:41', NULL, '1', '2015-11-13', '0'),
('92', '1', '16', '1', '2016-11-23 02:22:15', NULL, '1', '2015-11-17', '0'),
('93', '4', '63', '1', '2016-11-23 02:23:31', NULL, '1', '2015-11-18', '0'),
('94', '4', '64', '1', '2016-11-23 02:24:33', NULL, '1', '2015-11-18', '0'),
('95', '4', '65', '1', '2016-11-23 02:25:42', NULL, '1', '2015-11-20', '0'),
('96', '1', '17', '1', '2016-11-23 02:27:14', NULL, '1', '2015-11-20', '0'),
('97', '4', '66', '1', '2016-11-23 02:53:48', NULL, '1', '2015-11-23', '0'),
('98', '4', '67', '1', '2016-11-23 02:54:33', NULL, '1', '2015-11-23', '0'),
('99', '4', '68', '1', '2016-11-23 02:55:11', NULL, '1', '2015-11-24', '0'),
('100', '1', '18', '1', '2016-11-23 02:56:26', NULL, '1', '2015-11-26', '0'),
('101', '1', '19', '1', '2016-11-23 02:57:29', NULL, '1', '2015-11-26', '0'),
('102', '4', '69', '1', '2016-11-23 02:58:21', NULL, '1', '2015-11-30', '0'),
('103', '4', '70', '1', '2016-11-23 02:59:02', NULL, '1', '2016-03-31', '0'),
('104', '1', '20', '1', '2016-11-23 03:00:08', NULL, '1', '2015-11-30', '0'),
('105', '4', '71', '1', '2016-11-23 03:00:46', NULL, '1', '2015-12-01', '0'),
('106', '4', '72', '1', '2016-11-23 03:01:35', NULL, '1', '2015-11-30', '0'),
('107', '1', '21', '1', '2016-11-23 03:03:25', NULL, '1', '2015-12-01', '0'),
('108', '4', '73', '1', '2016-11-23 03:04:06', NULL, '1', '2015-12-04', '0'),
('109', '4', '74', '1', '2016-11-23 03:04:46', NULL, '1', '2015-12-07', '0'),
('110', '2', '9', '1', '2016-11-23 03:05:59', NULL, '1', '2015-12-07', '0'),
('111', '1', '22', '1', '2016-11-23 03:07:02', NULL, '1', '2015-12-08', '0'),
('112', '2', '10', '1', '2016-11-23 03:08:04', NULL, '1', '2015-12-08', '0'),
('113', '1', '23', '1', '2016-11-23 03:10:30', NULL, '1', '2015-12-09', '0'),
('114', '4', '75', '1', '2016-11-23 03:29:20', NULL, '1', '2015-12-09', '0'),
('115', '4', '76', '1', '2016-11-23 03:30:12', NULL, '1', '2015-12-09', '0'),
('116', '4', '77', '1', '2016-11-23 03:30:52', NULL, '1', '2015-12-09', '0'),
('117', '4', '78', '1', '2016-11-23 03:31:21', NULL, '1', '2015-12-10', '0'),
('118', '4', '79', '1', '2016-11-23 03:31:46', NULL, '1', '2015-12-10', '0'),
('119', '4', '80', '1', '2016-11-23 03:33:41', NULL, '1', '2015-12-14', '0'),
('120', '4', '81', '1', '2016-11-23 03:35:58', NULL, '1', '2016-03-31', '0'),
('121', '2', '11', '1', '2016-11-23 03:36:54', NULL, '1', '2015-12-16', '0'),
('122', '4', '82', '1', '2016-11-23 03:37:26', NULL, '1', '2015-12-14', '0'),
('123', '4', '83', '1', '2016-11-23 03:38:28', NULL, '1', '2015-12-16', '0'),
('124', '1', '24', '1', '2016-11-23 03:39:19', NULL, '1', '2015-12-17', '0'),
('125', '4', '84', '1', '2016-11-23 03:39:46', NULL, '1', '2015-12-17', '0'),
('126', '4', '85', '1', '2016-11-23 03:40:29', NULL, '1', '2015-12-17', '0'),
('127', '1', '25', '1', '2016-11-23 03:41:33', NULL, '1', '2015-12-18', '0'),
('128', '4', '86', '1', '2016-11-23 03:42:14', NULL, '1', '2015-12-20', '0'),
('129', '0', '2', '1', '2016-11-23 03:45:20', NULL, '1', '2015-12-20', '0'),
('130', '1', '26', '1', '2016-11-23 04:11:55', NULL, '1', '2015-12-21', '0'),
('131', '4', '87', '1', '2016-11-23 04:12:50', NULL, '1', '2015-12-21', '0'),
('132', '4', '88', '1', '2016-11-23 04:13:39', NULL, '1', '2015-12-21', '0'),
('133', '2', '12', '1', '2016-11-23 04:16:07', NULL, '1', '2015-12-22', '0'),
('134', '1', '27', '1', '2016-11-23 04:17:30', NULL, '1', '2015-12-22', '0'),
('135', '4', '89', '1', '2016-11-23 04:18:53', NULL, '1', '2015-12-25', '0'),
('136', '0', '3', '1', '2016-11-23 04:21:47', NULL, '1', '2015-12-25', '0'),
('137', '4', '90', '1', '2016-11-23 04:22:46', NULL, '1', '2015-12-30', '0'),
('138', '4', '91', '1', '2016-11-23 04:23:10', NULL, '1', '2015-12-30', '0'),
('139', '2', '13', '1', '2016-11-23 04:24:20', NULL, '1', '2015-12-31', '0'),
('140', '4', '92', '1', '2016-11-23 04:25:00', NULL, '1', '2016-01-01', '0'),
('141', '1', '28', '1', '2016-11-23 04:37:53', NULL, '1', '2016-01-03', '0'),
('142', '2', '14', '1', '2016-11-23 04:38:59', NULL, '1', '2016-01-03', '0'),
('143', '2', '15', '1', '2016-11-23 04:40:48', NULL, '1', '2016-01-06', '0'),
('144', '1', '29', '1', '2016-11-23 04:43:26', NULL, '2', '2015-12-07', NULL),
('145', '1', '30', '1', '2016-11-23 04:43:26', NULL, '1', '2016-01-07', '0'),
('146', '1', '29', '1', '2016-11-23 04:43:26', 'Voided.\nDocument reentered.', '2', '2016-11-23', '0'),
('147', '2', '16', '1', '2016-11-23 05:04:37', NULL, '2', '2016-01-07', NULL),
('148', '2', '17', '1', '2016-11-23 05:04:37', NULL, '1', '2016-01-07', '0'),
('149', '2', '16', '1', '2016-11-23 05:04:37', 'Voided.\nDocument reentered.', '2', '2016-11-23', '0'),
('150', '2', '18', '1', '2016-11-23 05:06:10', NULL, '1', '2016-01-07', '0'),
('151', '4', '93', '1', '2016-11-23 05:08:41', NULL, '1', '2016-01-08', '0'),
('152', '4', '94', '1', '2016-11-23 05:11:55', NULL, '1', '2016-01-11', '0'),
('153', '2', '19', '1', '2016-11-23 05:12:51', NULL, '1', '2016-01-18', '0'),
('154', '4', '95', '1', '2016-11-23 05:13:45', NULL, '1', '2016-01-19', '0'),
('155', '4', '96', '1', '2016-11-23 05:14:28', NULL, '1', '2016-01-19', '0'),
('156', '1', '31', '1', '2016-11-23 05:18:38', NULL, '1', '2016-01-19', '0'),
('157', '2', '20', '1', '2016-11-23 05:20:39', NULL, '1', '2016-01-21', '0'),
('158', '4', '97', '1', '2016-11-23 05:21:08', NULL, '1', '2016-01-22', '0'),
('159', '4', '98', '1', '2016-12-05 01:41:07', NULL, '1', '2016-01-22', NULL),
('160', '4', '99', '1', '2016-11-23 05:24:46', NULL, '1', '2016-01-22', '0'),
('161', '1', '32', '1', '2016-11-23 05:25:56', NULL, '1', '2016-01-24', '0'),
('162', '4', '100', '1', '2016-11-23 05:26:36', NULL, '1', '2016-01-29', '0'),
('163', '4', '101', '1', '2016-11-23 05:27:11', NULL, '1', '2016-01-26', '0'),
('164', '4', '102', '1', '2016-11-23 05:27:28', NULL, '1', '2016-01-25', '0'),
('165', '4', '103', '1', '2016-11-23 05:28:23', NULL, '1', '2016-01-27', '0'),
('166', '1', '33', '1', '2016-11-23 05:29:27', NULL, '1', '2016-01-27', '0'),
('167', '4', '104', '1', '2016-11-23 05:30:12', NULL, '1', '2016-02-01', '0'),
('168', '4', '105', '1', '2016-11-23 05:30:43', NULL, '1', '2016-02-01', '0'),
('169', '2', '21', '1', '2016-11-23 05:31:27', NULL, '1', '2016-02-01', '0'),
('170', '4', '106', '1', '2016-11-23 05:32:40', NULL, '1', '2016-02-03', '0'),
('171', '1', '34', '1', '2016-11-23 05:33:49', NULL, '1', '2016-02-05', '0'),
('172', '4', '107', '1', '2016-11-23 05:34:25', NULL, '1', '2016-03-31', '0'),
('173', '2', '22', '1', '2016-11-23 05:35:01', NULL, '1', '2016-02-08', '0'),
('174', '2', '23', '1', '2016-11-23 05:35:37', NULL, '1', '2016-02-08', '0'),
('175', '4', '108', '1', '2016-11-23 05:36:11', NULL, '1', '2016-02-08', '0'),
('176', '4', '109', '1', '2016-11-23 05:36:39', NULL, '1', '2016-02-09', '0'),
('177', '1', '35', '1', '2016-11-23 05:38:01', NULL, '1', '2016-02-09', '0'),
('178', '4', '110', '1', '2016-11-23 05:38:35', NULL, '1', '2016-02-11', '0'),
('179', '4', '111', '1', '2016-11-23 05:39:06', NULL, '1', '2016-02-12', '0'),
('180', '4', '112', '1', '2016-11-23 05:40:06', NULL, '1', '2016-02-08', '0'),
('181', '4', '113', '1', '2016-11-23 05:40:53', NULL, '1', '2016-02-12', '0'),
('182', '4', '114', '1', '2016-11-23 05:42:19', NULL, '1', '2016-02-15', '0'),
('183', '4', '115', '1', '2016-11-23 05:42:54', NULL, '1', '2016-02-16', '0'),
('184', '4', '116', '1', '2016-11-23 05:44:01', NULL, '1', '2016-02-17', '0'),
('185', '4', '117', '1', '2016-11-23 05:44:26', NULL, '1', '2016-02-18', '0'),
('186', '1', '36', '1', '2016-11-23 05:45:19', NULL, '1', '2016-02-19', '0'),
('187', '4', '118', '1', '2016-11-23 05:45:48', NULL, '1', '2016-02-23', '0'),
('188', '4', '119', '1', '2016-11-23 05:46:25', NULL, '1', '2016-02-23', '0'),
('189', '4', '120', '1', '2016-11-23 05:47:46', NULL, '1', '2016-02-23', '0'),
('190', '4', '121', '1', '2016-11-23 05:48:30', NULL, '1', '2016-02-25', '0'),
('191', '4', '122', '1', '2016-11-23 05:48:56', NULL, '1', '2016-02-26', '0'),
('192', '1', '37', '1', '2016-11-23 05:50:05', NULL, '1', '2016-02-26', '0'),
('193', '1', '38', '1', '2016-11-23 05:50:50', NULL, '1', '2016-02-26', '0'),
('194', '1', '39', '1', '2016-11-23 05:51:39', NULL, '1', '2016-02-26', '0'),
('195', '4', '123', '1', '2016-11-23 05:52:28', NULL, '1', '2016-02-26', '0'),
('196', '4', '124', '1', '2016-11-23 05:52:53', NULL, '1', '2016-03-01', '0'),
('197', '2', '24', '1', '2016-11-23 05:53:45', NULL, '1', '2016-03-01', '0'),
('198', '4', '125', '1', '2016-11-23 05:54:11', NULL, '1', '2016-03-02', '0'),
('199', '4', '126', '1', '2016-11-23 05:54:33', NULL, '1', '2016-03-31', '0'),
('200', '4', '127', '1', '2016-11-23 05:54:59', NULL, '1', '2016-03-31', '0'),
('201', '2', '25', '1', '2016-11-23 05:55:44', NULL, '1', '2016-03-03', '0'),
('202', '4', '128', '1', '2016-11-23 05:56:17', NULL, '1', '2016-03-31', '0'),
('203', '4', '129', '1', '2016-11-23 05:56:44', NULL, '1', '2016-03-04', '0'),
('204', '2', '26', '1', '2016-11-23 05:57:18', NULL, '1', '2016-03-04', '0'),
('205', '4', '130', '1', '2016-11-23 05:58:09', NULL, '1', '2016-03-03', '0'),
('206', '4', '131', '1', '2016-11-23 05:59:16', NULL, '1', '2016-03-08', '0'),
('207', '4', '132', '1', '2016-11-23 05:59:40', NULL, '1', '2016-03-31', '0'),
('208', '4', '133', '1', '2016-11-23 06:00:21', NULL, '1', '2016-03-10', '0'),
('209', '4', '134', '1', '2016-11-23 06:00:46', NULL, '1', '2016-03-11', '0'),
('210', '4', '135', '1', '2016-11-23 06:01:14', NULL, '1', '2016-03-14', '0'),
('211', '2', '27', '1', '2016-11-23 06:01:51', NULL, '1', '2016-03-14', '0'),
('212', '4', '136', '1', '2016-11-23 06:02:18', NULL, '1', '2016-03-16', '0'),
('213', '4', '137', '1', '2016-11-23 06:02:53', NULL, '1', '2016-03-17', '0'),
('214', '1', '40', '1', '2016-11-23 06:09:43', NULL, '1', '2016-03-17', '0'),
('215', '4', '138', '1', '2016-11-23 06:10:14', NULL, '1', '2016-03-21', '0'),
('216', '4', '139', '1', '2016-11-23 06:10:43', NULL, '1', '2016-03-23', '0'),
('217', '4', '140', '1', '2016-11-23 06:11:11', NULL, '1', '2016-03-28', '0'),
('218', '1', '41', '1', '2016-11-23 06:12:08', NULL, '1', '2016-03-28', '0'),
('219', '4', '141', '1', '2016-11-23 06:12:37', NULL, '1', '2016-03-29', '0'),
('220', '4', '142', '1', '2016-11-23 06:13:00', NULL, '1', '2016-03-29', '0'),
('221', '2', '28', '1', '2016-11-23 06:13:56', NULL, '1', '2016-03-30', '0'),
('222', '2', '29', '1', '2016-11-23 06:14:36', NULL, '1', '2016-03-31', '0'),
('223', '1', '42', '1', '2016-11-23 06:15:29', NULL, '1', '2016-03-31', '0'),
('224', '4', '143', '1', '2016-11-30 05:32:18', NULL, '1', '2015-08-13', '0'),
('225', '4', '144', '1', '2016-11-30 05:33:46', NULL, '1', '2015-08-24', '0'),
('226', '4', '145', '1', '2016-11-30 05:34:38', NULL, '1', '2015-08-25', '0'),
('227', '4', '146', '1', '2016-11-30 05:35:24', NULL, '1', '2015-08-28', '0'),
('228', '4', '147', '1', '2016-11-30 05:36:14', NULL, '1', '2015-09-01', '0'),
('229', '4', '148', '1', '2016-11-30 05:37:31', NULL, '1', '2015-09-02', '0'),
('230', '4', '149', '1', '2016-11-30 05:38:29', NULL, '1', '2015-09-09', '0'),
('231', '4', '150', '1', '2016-11-30 05:39:16', NULL, '1', '2016-03-31', '0'),
('232', '4', '151', '1', '2016-11-30 05:40:04', NULL, '1', '2015-09-25', '0'),
('233', '4', '152', '1', '2016-11-30 05:40:57', NULL, '1', '2015-10-09', '0'),
('234', '4', '153', '1', '2016-11-30 05:42:07', NULL, '1', '2015-10-12', '0'),
('235', '4', '154', '1', '2016-11-30 05:43:23', NULL, '1', '2015-10-22', '0'),
('236', '4', '155', '1', '2016-11-30 05:44:09', NULL, '1', '2016-03-31', '0'),
('237', '4', '156', '1', '2016-11-30 05:44:40', NULL, '1', '2015-11-12', '0'),
('238', '4', '157', '1', '2016-11-30 05:45:04', NULL, '1', '2015-11-20', '0'),
('239', '4', '158', '1', '2016-11-30 05:47:03', NULL, '1', '2015-12-01', '0'),
('240', '4', '159', '1', '2016-11-30 05:48:04', NULL, '1', '2015-12-09', '0'),
('241', '1', '43', '1', '2016-11-30 05:48:41', NULL, '1', '2015-12-09', '0'),
('242', '4', '160', '1', '2016-11-30 05:49:43', NULL, '1', '2015-12-14', '0'),
('243', '4', '161', '1', '2016-11-30 05:50:04', NULL, '1', '2015-12-18', '0'),
('244', '4', '162', '1', '2016-11-30 05:51:12', NULL, '1', '2015-12-31', '0'),
('245', '4', '163', '1', '2016-11-30 05:51:49', NULL, '1', '2016-01-19', '0'),
('246', '4', '164', '1', '2016-11-30 05:52:45', NULL, '1', '2016-01-22', '0'),
('247', '1', '44', '1', '2016-11-30 05:54:05', NULL, '1', '2016-01-22', '0'),
('248', '4', '165', '1', '2016-11-30 05:54:48', NULL, '1', '2016-01-31', '0'),
('249', '4', '166', '1', '2016-11-30 05:55:11', NULL, '1', '2016-02-05', '0'),
('250', '4', '167', '1', '2016-11-30 05:56:22', NULL, '1', '2016-02-08', '0'),
('251', '4', '168', '1', '2016-11-30 05:57:01', NULL, '1', '2016-02-15', '0'),
('252', '4', '169', '1', '2016-11-30 05:57:50', NULL, '1', '2016-02-16', '0'),
('253', '1', '45', '1', '2016-11-30 05:58:56', NULL, '1', '2016-02-16', '0'),
('254', '4', '170', '1', '2016-11-30 06:02:12', NULL, '1', '2016-02-25', '0'),
('255', '4', '171', '1', '2016-11-30 06:02:34', NULL, '1', '2016-03-08', '0'),
('256', '4', '172', '1', '2016-11-30 06:03:03', NULL, '1', '2016-03-17', '0'),
('257', '4', '173', '1', '2016-11-30 06:03:30', NULL, '1', '2016-03-23', '0'),
('258', '4', '174', '1', '2016-11-30 06:04:18', NULL, '1', '2016-03-29', '0'),
('259', '4', '175', '1', '2016-11-30 06:05:02', NULL, '1', '2016-03-29', '0'),
('260', '1', '46', '1', '2016-11-30 06:05:35', NULL, '1', '2016-03-29', '0'),
('261', '4', '176', '1', '2016-11-30 06:06:29', NULL, '1', '2016-03-23', '0'),
('262', '1', '47', '1', '2016-11-30 06:07:27', NULL, '1', '2016-03-23', '0'),
('263', '4', '177', '1', '2016-11-30 06:08:45', NULL, '1', '2016-03-11', '0'),
('264', '4', '178', '1', '2016-11-30 06:09:35', NULL, '1', '2016-03-08', '0'),
('265', '1', '48', '1', '2016-11-30 06:10:22', NULL, '1', '2016-03-08', '0'),
('266', '1', '49', '1', '2016-11-30 06:17:59', NULL, '1', '2015-08-26', '0'),
('267', '1', '4', '1', '2016-11-30 06:17:59', 'Voided.\nDocument reentered.', '2', '2016-11-30', '0'),
('268', '4', '179', '1', '2016-11-30 06:19:44', NULL, '1', '2015-09-10', '0'),
('269', '4', '180', '1', '2016-11-30 06:27:11', NULL, '1', '2015-11-02', '0'),
('270', '4', '181', '1', '2016-12-01 01:28:10', NULL, '1', '2016-01-08', '0'),
('271', '4', '182', '1', '2016-12-01 01:36:22', NULL, '1', '2016-02-08', '0'),
('272', '0', '4', '1', '2016-12-02 02:39:39', NULL, '1', '2015-04-01', '0'),
('273', '4', '183', '1', '2016-12-02 02:41:06', NULL, '1', '2015-04-02', '0'),
('274', '4', '184', '1', '2016-12-02 02:41:29', NULL, '1', '2015-04-02', '0'),
('275', '4', '185', '1', '2016-12-02 02:41:58', NULL, '1', '2015-04-24', '0'),
('276', '4', '186', '1', '2016-12-02 02:44:44', NULL, '1', '2015-04-30', '0'),
('277', '4', '187', '1', '2016-12-02 02:45:13', NULL, '1', '2015-05-14', '0'),
('278', '4', '188', '1', '2016-12-02 02:45:40', NULL, '1', '2015-05-22', '0'),
('279', '4', '189', '1', '2016-12-02 02:46:12', NULL, '1', '2015-05-30', '0'),
('280', '4', '190', '1', '2016-12-02 02:46:43', NULL, '1', '2015-05-31', '0'),
('281', '4', '191', '1', '2016-12-02 02:47:08', NULL, '1', '2016-03-31', '0'),
('282', '4', '192', '1', '2016-12-02 02:47:40', NULL, '1', '2015-06-12', '0'),
('283', '4', '193', '1', '2016-12-02 02:48:08', NULL, '1', '2015-06-18', '0'),
('284', '4', '194', '1', '2016-12-02 02:48:43', NULL, '1', '2015-06-24', '0'),
('285', '4', '195', '1', '2016-12-02 02:49:19', NULL, '1', '2015-06-29', '0'),
('286', '4', '196', '1', '2016-12-02 02:50:02', NULL, '1', '2015-07-06', '0'),
('287', '4', '197', '1', '2016-12-02 02:50:28', NULL, '1', '2015-07-14', '0'),
('288', '4', '198', '1', '2016-12-02 02:51:45', NULL, '1', '2015-07-31', '0'),
('289', '4', '199', '1', '2016-12-02 02:52:24', NULL, '1', '2015-08-28', '0'),
('290', '4', '200', '1', '2016-12-02 02:53:18', NULL, '1', '2015-12-01', '0'),
('291', '4', '201', '1', '2016-12-02 02:53:45', NULL, '1', '2015-12-17', '0'),
('292', '4', '202', '1', '2016-12-02 02:54:17', NULL, '1', '2016-01-21', '0'),
('293', '4', '203', '1', '2016-12-02 02:54:53', NULL, '1', '2016-01-22', '0'),
('294', '30', '1', '1', '2016-12-02 03:27:11', NULL, '1', '2015-04-30', '0'),
('295', '13', '1', '1', '2016-12-02 03:50:25', NULL, '2', '2015-04-30', NULL),
('296', '10', '1', '1', '2016-12-02 03:50:25', NULL, '1', '2015-04-30', NULL),
('297', '12', '1', '1', '2016-12-02 06:20:50', NULL, '1', '2015-04-30', NULL),
('298', '13', '1', '1', '2016-12-02 03:50:25', 'Voided.', '2', '2016-12-02', '0'),
('299', '10', '1', '1', '2016-12-02 03:50:25', 'Voided.\n', '1', '2016-03-31', '0'),
('300', '30', '2', '1', '2016-12-02 03:52:03', NULL, '1', '2015-04-30', '0'),
('301', '13', '2', '1', '2016-12-02 03:53:27', NULL, '2', '2015-04-30', NULL),
('302', '10', '2', '1', '2016-12-02 03:53:27', NULL, '1', '2015-04-30', NULL),
('303', '12', '2', '1', '2016-12-02 05:23:02', NULL, '1', '2015-04-30', NULL),
('304', '13', '2', '1', '2016-12-02 03:53:27', 'Voided.', '2', '2016-12-02', '0'),
('305', '10', '2', '1', '2016-12-02 03:53:27', 'Voided.\n', '1', '2016-03-31', '0'),
('306', '12', '2', '1', '2016-12-02 06:21:22', 'Updated.', '1', '2015-04-30', NULL),
('307', '30', '3', '1', '2016-12-02 06:00:43', NULL, '1', '2016-03-31', '0'),
('308', '13', '3', '1', '2016-12-05 00:58:26', NULL, '2', '2016-03-31', NULL),
('309', '10', '3', '1', '2016-12-05 00:58:26', NULL, '1', '2016-03-31', NULL),
('310', '12', '3', '1', '2016-12-05 00:59:32', NULL, '1', '2016-03-31', NULL),
('311', '30', '4', '1', '2016-12-02 06:13:29', NULL, '1', '2016-03-31', '0'),
('312', '13', '4', '1', '2016-12-05 00:58:49', NULL, '2', '2016-03-31', NULL),
('313', '10', '4', '1', '2016-12-05 00:58:49', NULL, '1', '2016-03-31', NULL),
('314', '12', '4', '1', '2016-12-05 00:59:48', NULL, '1', '2016-03-31', NULL),
('315', '12', '1', '1', '2016-12-02 06:20:50', 'Updated.', '1', '2015-04-30', '0'),
('316', '12', '2', '1', '2016-12-02 06:21:22', 'Updated.', '1', '2015-04-30', '0'),
('317', '30', '5', '1', '2016-12-04 23:41:16', NULL, '1', '2015-04-30', '0'),
('318', '13', '5', '1', '2016-12-04 23:41:16', NULL, '1', '2015-04-30', '0'),
('319', '10', '5', '1', '2016-12-04 23:42:19', NULL, '1', '2015-04-30', '0'),
('320', '12', '5', '1', '2016-12-04 23:42:19', NULL, '1', '2015-04-30', '0'),
('321', '30', '6', '1', '2016-12-04 23:43:32', NULL, '1', '2015-05-31', '0'),
('322', '13', '6', '1', '2016-12-04 23:43:32', NULL, '1', '2015-05-31', '0'),
('323', '10', '6', '1', '2016-12-04 23:43:32', NULL, '1', '2015-05-31', '0'),
('324', '12', '6', '1', '2016-12-04 23:43:32', NULL, '1', '2015-05-31', '0'),
('325', '30', '7', '1', '2016-12-04 23:45:25', NULL, '1', '2015-06-30', '0'),
('326', '13', '7', '1', '2016-12-04 23:45:25', NULL, '1', '2015-06-30', '0'),
('327', '10', '7', '1', '2016-12-04 23:45:25', NULL, '1', '2015-06-30', '0'),
('328', '12', '7', '1', '2016-12-04 23:45:25', NULL, '1', '2015-06-30', '0'),
('329', '30', '8', '1', '2016-12-04 23:46:51', NULL, '1', '2015-07-03', '0'),
('330', '13', '8', '1', '2016-12-04 23:46:51', NULL, '1', '2015-07-03', '0'),
('331', '10', '8', '1', '2016-12-04 23:46:51', NULL, '1', '2015-07-03', '0'),
('332', '12', '8', '1', '2016-12-04 23:46:51', NULL, '1', '2015-07-03', '0'),
('333', '30', '9', '1', '2016-12-04 23:47:32', NULL, '1', '2015-07-10', '0'),
('334', '13', '9', '1', '2016-12-04 23:47:32', NULL, '1', '2015-07-10', '0'),
('335', '10', '9', '1', '2016-12-04 23:47:32', NULL, '1', '2015-07-10', '0'),
('336', '12', '9', '1', '2016-12-04 23:47:32', NULL, '1', '2015-07-10', '0'),
('337', '30', '10', '1', '2016-12-04 23:48:30', NULL, '1', '2015-07-17', '0'),
('338', '13', '10', '1', '2016-12-04 23:48:30', NULL, '1', '2015-07-17', '0'),
('339', '10', '10', '1', '2016-12-04 23:48:30', NULL, '1', '2015-07-17', '0'),
('340', '12', '10', '1', '2016-12-04 23:48:30', NULL, '1', '2015-07-17', '0'),
('341', '30', '11', '1', '2016-12-04 23:49:19', NULL, '1', '2015-07-24', '0'),
('342', '13', '11', '1', '2016-12-04 23:49:19', NULL, '1', '2015-07-24', '0'),
('343', '10', '11', '1', '2016-12-04 23:49:19', NULL, '1', '2015-07-24', '0'),
('344', '12', '11', '1', '2016-12-04 23:49:19', NULL, '1', '2015-07-24', '0'),
('345', '30', '12', '1', '2016-12-04 23:49:55', NULL, '1', '2015-07-31', '0'),
('346', '13', '12', '1', '2016-12-04 23:49:55', NULL, '1', '2015-07-31', '0'),
('347', '10', '12', '1', '2016-12-04 23:49:55', NULL, '1', '2015-07-31', '0'),
('348', '12', '12', '1', '2016-12-04 23:49:55', NULL, '1', '2015-07-31', '0'),
('349', '30', '13', '1', '2016-12-04 23:50:43', NULL, '1', '2015-08-07', '0'),
('350', '13', '13', '1', '2016-12-04 23:50:43', NULL, '1', '2015-08-07', '0'),
('351', '10', '13', '1', '2016-12-04 23:50:43', NULL, '1', '2015-08-07', '0'),
('352', '12', '13', '1', '2016-12-04 23:50:43', NULL, '1', '2015-08-07', '0'),
('353', '30', '14', '1', '2016-12-04 23:51:21', NULL, '1', '2015-08-14', '0'),
('354', '13', '14', '1', '2016-12-04 23:51:21', NULL, '1', '2015-08-14', '0'),
('355', '10', '14', '1', '2016-12-04 23:51:21', NULL, '1', '2015-08-14', '0'),
('356', '12', '14', '1', '2016-12-04 23:51:21', NULL, '1', '2015-08-14', '0'),
('357', '30', '15', '1', '2016-12-04 23:51:55', NULL, '1', '2015-08-21', '0'),
('358', '13', '15', '1', '2016-12-04 23:51:55', NULL, '1', '2015-08-21', '0'),
('359', '10', '15', '1', '2016-12-04 23:51:55', NULL, '1', '2015-08-21', '0'),
('360', '12', '15', '1', '2016-12-04 23:51:55', NULL, '1', '2015-08-21', '0'),
('361', '30', '16', '1', '2016-12-04 23:52:30', NULL, '1', '2015-08-28', '0'),
('362', '13', '16', '1', '2016-12-04 23:52:30', NULL, '1', '2015-08-28', '0'),
('363', '10', '16', '1', '2016-12-04 23:52:30', NULL, '1', '2015-08-28', '0'),
('364', '12', '16', '1', '2016-12-04 23:52:30', NULL, '1', '2015-08-28', '0'),
('365', '30', '17', '1', '2016-12-04 23:52:57', NULL, '1', '2015-08-31', '0'),
('366', '13', '17', '1', '2016-12-04 23:52:57', NULL, '1', '2015-08-31', '0'),
('367', '10', '17', '1', '2016-12-04 23:52:57', NULL, '1', '2015-08-31', '0'),
('368', '12', '17', '1', '2016-12-04 23:52:57', NULL, '1', '2015-08-31', '0'),
('369', '30', '18', '1', '2016-12-04 23:53:55', NULL, '1', '2015-09-04', '0'),
('370', '13', '18', '1', '2016-12-04 23:53:55', NULL, '1', '2015-09-04', '0'),
('371', '10', '18', '1', '2016-12-04 23:53:55', NULL, '1', '2015-09-04', '0'),
('372', '12', '18', '1', '2016-12-04 23:53:55', NULL, '1', '2015-09-04', '0'),
('373', '30', '19', '1', '2016-12-04 23:54:38', NULL, '1', '2015-09-11', '0'),
('374', '13', '19', '1', '2016-12-04 23:54:38', NULL, '1', '2015-09-11', '0'),
('375', '10', '19', '1', '2016-12-04 23:54:38', NULL, '1', '2015-09-11', '0'),
('376', '12', '19', '1', '2016-12-04 23:54:38', NULL, '1', '2015-09-11', '0'),
('377', '30', '20', '1', '2016-12-04 23:55:08', NULL, '1', '2015-09-18', '0'),
('378', '13', '20', '1', '2016-12-04 23:55:08', NULL, '1', '2015-09-18', '0'),
('379', '10', '20', '1', '2016-12-04 23:55:08', NULL, '1', '2015-09-18', '0'),
('380', '12', '20', '1', '2016-12-04 23:55:08', NULL, '1', '2015-09-18', '0'),
('381', '30', '21', '1', '2016-12-04 23:55:36', NULL, '1', '2015-09-25', '0'),
('382', '13', '21', '1', '2016-12-04 23:55:36', NULL, '1', '2015-09-25', '0'),
('383', '10', '21', '1', '2016-12-04 23:55:36', NULL, '1', '2015-09-25', '0'),
('384', '12', '21', '1', '2016-12-04 23:55:36', NULL, '1', '2015-09-25', '0'),
('385', '30', '22', '1', '2016-12-04 23:56:14', NULL, '1', '2015-09-30', '0'),
('386', '13', '22', '1', '2016-12-04 23:56:14', NULL, '1', '2015-09-30', '0'),
('387', '10', '22', '1', '2016-12-04 23:56:14', NULL, '1', '2015-09-30', '0'),
('388', '12', '22', '1', '2016-12-04 23:56:14', NULL, '1', '2015-09-30', '0'),
('389', '30', '23', '1', '2016-12-04 23:57:05', NULL, '1', '2015-10-04', '0'),
('390', '13', '23', '1', '2016-12-04 23:57:05', NULL, '1', '2015-10-04', '0'),
('391', '10', '23', '1', '2016-12-04 23:57:05', NULL, '1', '2015-10-04', '0'),
('392', '12', '23', '1', '2016-12-04 23:57:05', NULL, '1', '2015-10-04', '0'),
('393', '30', '24', '1', '2016-12-05 00:03:23', NULL, '1', '2015-10-09', '0'),
('394', '13', '24', '1', '2016-12-05 00:03:23', NULL, '1', '2015-10-09', '0'),
('395', '10', '24', '1', '2016-12-05 00:03:23', NULL, '1', '2015-10-09', '0'),
('396', '12', '24', '1', '2016-12-05 00:03:23', NULL, '1', '2015-10-09', '0'),
('397', '30', '25', '1', '2016-12-05 00:04:12', NULL, '1', '2015-10-16', '0'),
('398', '13', '25', '1', '2016-12-05 00:04:12', NULL, '1', '2015-10-16', '0'),
('399', '10', '25', '1', '2016-12-05 00:04:12', NULL, '1', '2015-10-16', '0'),
('400', '12', '25', '1', '2016-12-05 00:04:12', NULL, '1', '2015-10-16', '0'),
('401', '30', '26', '1', '2016-12-05 00:04:46', NULL, '1', '2015-10-23', '0'),
('402', '13', '26', '1', '2016-12-05 00:04:46', NULL, '1', '2015-10-23', '0'),
('403', '10', '26', '1', '2016-12-05 00:04:46', NULL, '1', '2015-10-23', '0'),
('404', '12', '26', '1', '2016-12-05 00:04:46', NULL, '1', '2015-10-23', '0'),
('405', '30', '27', '1', '2016-12-05 00:05:12', NULL, '1', '2015-10-31', '0'),
('406', '13', '27', '1', '2016-12-05 00:05:12', NULL, '1', '2015-10-31', '0'),
('407', '10', '27', '1', '2016-12-05 00:05:12', NULL, '1', '2015-10-31', '0'),
('408', '12', '27', '1', '2016-12-05 00:05:12', NULL, '1', '2015-10-31', '0'),
('409', '30', '28', '1', '2016-12-05 00:05:56', NULL, '1', '2015-11-06', '0'),
('410', '13', '28', '1', '2016-12-05 00:05:56', NULL, '1', '2015-11-06', '0'),
('411', '10', '28', '1', '2016-12-05 00:05:56', NULL, '1', '2015-11-06', '0'),
('412', '12', '28', '1', '2016-12-05 00:05:56', NULL, '1', '2015-11-06', '0'),
('413', '30', '29', '1', '2016-12-05 00:06:29', NULL, '1', '2015-11-13', '0'),
('414', '13', '29', '1', '2016-12-05 00:06:29', NULL, '1', '2015-11-13', '0'),
('415', '10', '29', '1', '2016-12-05 00:06:29', NULL, '1', '2015-11-13', '0'),
('416', '12', '29', '1', '2016-12-05 00:06:29', NULL, '1', '2015-11-13', '0'),
('417', '30', '30', '1', '2016-12-05 00:07:00', NULL, '1', '2015-11-20', '0'),
('418', '13', '30', '1', '2016-12-05 00:07:00', NULL, '1', '2015-11-20', '0'),
('419', '10', '30', '1', '2016-12-05 00:07:00', NULL, '1', '2015-11-20', '0'),
('420', '12', '30', '1', '2016-12-05 00:07:00', NULL, '1', '2015-11-20', '0'),
('421', '30', '31', '1', '2016-12-05 00:07:29', NULL, '1', '2015-11-27', '0'),
('422', '13', '31', '1', '2016-12-05 00:07:29', NULL, '1', '2015-11-27', '0'),
('423', '10', '31', '1', '2016-12-05 00:07:29', NULL, '1', '2015-11-27', '0'),
('424', '12', '31', '1', '2016-12-05 00:07:29', NULL, '1', '2015-11-27', '0'),
('425', '30', '32', '1', '2016-12-05 00:08:08', NULL, '1', '2015-11-30', '0'),
('426', '13', '32', '1', '2016-12-05 00:08:08', NULL, '1', '2015-11-30', '0'),
('427', '10', '32', '1', '2016-12-05 00:08:08', NULL, '1', '2015-11-30', '0'),
('428', '12', '32', '1', '2016-12-05 00:08:08', NULL, '1', '2015-11-30', '0'),
('429', '30', '33', '1', '2016-12-05 00:08:58', NULL, '1', '2015-12-04', '0'),
('430', '13', '33', '1', '2016-12-05 00:08:58', NULL, '1', '2015-12-04', '0'),
('431', '10', '33', '1', '2016-12-05 00:08:58', NULL, '1', '2015-12-04', '0'),
('432', '12', '33', '1', '2016-12-05 00:08:58', NULL, '1', '2015-12-04', '0'),
('433', '30', '34', '1', '2016-12-05 00:09:34', NULL, '1', '2015-12-11', '0'),
('434', '13', '34', '1', '2016-12-05 00:09:34', NULL, '1', '2015-12-11', '0'),
('435', '10', '34', '1', '2016-12-05 00:09:34', NULL, '1', '2015-12-11', '0'),
('436', '12', '34', '1', '2016-12-05 00:09:34', NULL, '1', '2015-12-11', '0'),
('437', '30', '35', '1', '2016-12-05 00:10:03', NULL, '1', '2015-12-18', '0'),
('438', '13', '35', '1', '2016-12-05 00:10:03', NULL, '1', '2015-12-18', '0'),
('439', '10', '35', '1', '2016-12-05 00:10:03', NULL, '1', '2015-12-18', '0'),
('440', '12', '35', '1', '2016-12-05 00:10:03', NULL, '1', '2015-12-18', '0'),
('441', '30', '36', '1', '2016-12-05 00:10:34', NULL, '1', '2015-12-25', '0'),
('442', '13', '36', '1', '2016-12-05 00:10:34', NULL, '1', '2015-12-25', '0'),
('443', '10', '36', '1', '2016-12-05 00:10:34', NULL, '1', '2015-12-25', '0'),
('444', '12', '36', '1', '2016-12-05 00:10:34', NULL, '1', '2015-12-25', '0'),
('445', '30', '37', '1', '2016-12-05 00:12:41', NULL, '1', '2015-12-31', '0'),
('446', '13', '37', '1', '2016-12-05 00:12:41', NULL, '1', '2015-12-31', '0'),
('447', '10', '37', '1', '2016-12-05 00:12:41', NULL, '1', '2015-12-31', '0'),
('448', '12', '37', '1', '2016-12-05 00:12:41', NULL, '1', '2015-12-31', '0'),
('449', '30', '38', '1', '2016-12-05 00:13:16', NULL, '1', '2016-01-01', '0'),
('450', '13', '38', '1', '2016-12-05 00:13:16', NULL, '1', '2016-01-01', '0'),
('451', '10', '38', '1', '2016-12-05 00:13:16', NULL, '1', '2016-01-01', '0'),
('452', '12', '38', '1', '2016-12-05 00:13:16', NULL, '1', '2016-01-01', '0'),
('453', '30', '39', '1', '2016-12-05 00:13:45', NULL, '1', '2016-01-08', '0'),
('454', '13', '39', '1', '2016-12-05 00:13:45', NULL, '1', '2016-01-08', '0'),
('455', '10', '39', '1', '2016-12-05 00:13:45', NULL, '1', '2016-01-08', '0'),
('456', '12', '39', '1', '2016-12-05 00:13:45', NULL, '1', '2016-01-08', '0'),
('457', '30', '40', '1', '2016-12-05 00:14:21', NULL, '1', '2016-01-15', '0'),
('458', '13', '40', '1', '2016-12-05 00:14:21', NULL, '1', '2016-01-15', '0'),
('459', '10', '40', '1', '2016-12-05 00:14:21', NULL, '1', '2016-01-15', '0'),
('460', '12', '40', '1', '2016-12-05 00:14:21', NULL, '1', '2016-01-15', '0'),
('461', '30', '41', '1', '2016-12-05 00:14:55', NULL, '1', '2016-01-22', '0'),
('462', '13', '41', '1', '2016-12-05 00:14:55', NULL, '1', '2016-01-22', '0'),
('463', '10', '41', '1', '2016-12-05 00:14:55', NULL, '1', '2016-01-22', '0'),
('464', '12', '41', '1', '2016-12-05 00:14:55', NULL, '1', '2016-01-22', '0'),
('465', '30', '42', '1', '2016-12-05 00:15:26', NULL, '1', '2016-01-29', '0'),
('466', '13', '42', '1', '2016-12-05 00:15:26', NULL, '1', '2016-01-29', '0'),
('467', '10', '42', '1', '2016-12-05 00:15:26', NULL, '1', '2016-01-29', '0'),
('468', '12', '42', '1', '2016-12-05 00:15:26', NULL, '1', '2016-01-29', '0'),
('469', '30', '43', '1', '2016-12-05 00:15:56', NULL, '1', '2016-01-31', '0'),
('470', '13', '43', '1', '2016-12-05 00:15:56', NULL, '1', '2016-01-31', '0'),
('471', '10', '43', '1', '2016-12-05 00:15:56', NULL, '1', '2016-01-31', '0'),
('472', '12', '43', '1', '2016-12-05 00:15:56', NULL, '1', '2016-01-31', '0'),
('473', '30', '44', '1', '2016-12-05 00:16:45', NULL, '1', '2016-02-05', '0'),
('474', '13', '44', '1', '2016-12-05 00:16:45', NULL, '1', '2016-02-05', '0'),
('475', '10', '44', '1', '2016-12-05 00:16:45', NULL, '1', '2016-02-05', '0'),
('476', '12', '44', '1', '2016-12-05 00:16:45', NULL, '1', '2016-02-05', '0'),
('477', '30', '45', '1', '2016-12-05 00:17:16', NULL, '1', '2016-02-12', '0'),
('478', '13', '45', '1', '2016-12-05 00:17:16', NULL, '1', '2016-02-12', '0'),
('479', '10', '45', '1', '2016-12-05 00:17:16', NULL, '1', '2016-02-12', '0'),
('480', '12', '45', '1', '2016-12-05 00:17:16', NULL, '1', '2016-02-12', '0'),
('481', '30', '46', '1', '2016-12-05 00:17:49', NULL, '1', '2016-02-19', '0'),
('482', '13', '46', '1', '2016-12-05 00:17:49', NULL, '1', '2016-02-19', '0'),
('483', '10', '46', '1', '2016-12-05 00:17:49', NULL, '1', '2016-02-19', '0'),
('484', '12', '46', '1', '2016-12-05 00:17:49', NULL, '1', '2016-02-19', '0'),
('485', '30', '47', '1', '2016-12-05 00:18:20', NULL, '1', '2016-02-26', '0'),
('486', '13', '47', '1', '2016-12-05 00:18:20', NULL, '1', '2016-02-26', '0'),
('487', '10', '47', '1', '2016-12-05 00:18:20', NULL, '1', '2016-02-26', '0'),
('488', '12', '47', '1', '2016-12-05 00:18:20', NULL, '1', '2016-02-26', '0'),
('489', '30', '48', '1', '2016-12-05 00:18:56', NULL, '1', '2016-02-29', '0'),
('490', '13', '48', '1', '2016-12-05 00:18:56', NULL, '1', '2016-02-29', '0'),
('491', '10', '48', '1', '2016-12-05 00:18:56', NULL, '1', '2016-02-29', '0'),
('492', '12', '48', '1', '2016-12-05 00:18:56', NULL, '1', '2016-02-29', '0'),
('493', '30', '49', '1', '2016-12-05 00:19:40', NULL, '1', '2016-03-04', '0'),
('494', '13', '49', '1', '2016-12-05 00:19:40', NULL, '1', '2016-03-04', '0'),
('495', '10', '49', '1', '2016-12-05 00:19:40', NULL, '1', '2016-03-04', '0'),
('496', '12', '49', '1', '2016-12-05 00:19:40', NULL, '1', '2016-03-04', '0'),
('497', '30', '50', '1', '2016-12-05 00:20:08', NULL, '1', '2016-03-11', '0'),
('498', '13', '50', '1', '2016-12-05 00:20:08', NULL, '1', '2016-03-11', '0'),
('499', '10', '50', '1', '2016-12-05 00:20:08', NULL, '1', '2016-03-11', '0'),
('500', '12', '50', '1', '2016-12-05 00:20:08', NULL, '1', '2016-03-11', '0'),
('501', '30', '51', '1', '2016-12-05 00:21:13', NULL, '1', '2016-03-18', '0'),
('502', '13', '51', '1', '2016-12-05 00:21:13', NULL, '1', '2016-03-18', '0'),
('503', '10', '51', '1', '2016-12-05 00:21:13', NULL, '1', '2016-03-18', '0'),
('504', '12', '51', '1', '2016-12-05 00:21:13', NULL, '1', '2016-03-18', '0'),
('505', '30', '52', '1', '2016-12-05 00:21:38', NULL, '1', '2016-03-25', '0'),
('506', '13', '52', '1', '2016-12-05 00:21:38', NULL, '1', '2016-03-25', '0'),
('507', '10', '52', '1', '2016-12-05 00:21:38', NULL, '1', '2016-03-25', '0'),
('508', '12', '52', '1', '2016-12-05 00:21:38', NULL, '1', '2016-03-25', '0'),
('509', '30', '53', '1', '2016-12-05 00:22:14', NULL, '1', '2016-03-31', '0'),
('510', '13', '53', '1', '2016-12-05 00:22:14', NULL, '1', '2016-03-31', '0'),
('511', '10', '53', '1', '2016-12-05 00:22:14', NULL, '1', '2016-03-31', '0'),
('512', '12', '53', '1', '2016-12-05 00:22:14', NULL, '1', '2016-03-31', '0'),
('513', '30', '54', '1', '2016-12-05 00:31:10', NULL, '1', '2016-01-15', '0'),
('514', '13', '54', '1', '2016-12-05 00:31:10', NULL, '1', '2016-01-15', '0'),
('515', '10', '54', '1', '2016-12-05 00:31:10', NULL, '1', '2016-01-15', '0'),
('516', '12', '54', '1', '2016-12-05 00:31:10', NULL, '1', '2016-01-15', '0'),
('517', '30', '55', '1', '2016-12-05 00:33:21', NULL, '1', '2016-01-22', '0'),
('518', '13', '55', '1', '2016-12-05 00:33:21', NULL, '1', '2016-01-22', '0'),
('519', '10', '55', '1', '2016-12-05 00:33:21', NULL, '1', '2016-01-22', '0'),
('520', '12', '55', '1', '2016-12-05 00:33:21', NULL, '1', '2016-01-22', '0'),
('521', '30', '56', '1', '2016-12-05 00:34:00', NULL, '1', '2016-01-29', '0'),
('522', '13', '56', '1', '2016-12-05 00:34:00', NULL, '1', '2016-01-29', '0'),
('523', '10', '56', '1', '2016-12-05 00:34:00', NULL, '1', '2016-01-29', '0'),
('524', '12', '56', '1', '2016-12-05 00:34:00', NULL, '1', '2016-01-29', '0'),
('525', '30', '57', '1', '2016-12-05 00:34:38', NULL, '1', '2016-01-31', '0'),
('526', '13', '57', '1', '2016-12-05 00:34:38', NULL, '1', '2016-01-31', '0'),
('527', '10', '57', '1', '2016-12-05 00:34:38', NULL, '1', '2016-01-31', '0'),
('528', '12', '57', '1', '2016-12-05 00:34:38', NULL, '1', '2016-01-31', '0'),
('529', '30', '58', '1', '2016-12-05 00:35:09', NULL, '1', '2016-02-05', '0'),
('530', '13', '58', '1', '2016-12-05 00:35:09', NULL, '1', '2016-02-05', '0'),
('531', '10', '58', '1', '2016-12-05 00:35:09', NULL, '1', '2016-02-05', '0'),
('532', '12', '58', '1', '2016-12-05 00:35:09', NULL, '1', '2016-02-05', '0'),
('533', '30', '59', '1', '2016-12-05 00:35:41', NULL, '1', '2016-02-12', '0'),
('534', '13', '59', '1', '2016-12-05 00:35:41', NULL, '1', '2016-02-12', '0'),
('535', '10', '59', '1', '2016-12-05 00:35:41', NULL, '1', '2016-02-12', '0'),
('536', '12', '59', '1', '2016-12-05 00:35:41', NULL, '1', '2016-02-12', '0'),
('537', '30', '60', '1', '2016-12-05 00:36:09', NULL, '1', '2016-02-19', '0'),
('538', '13', '60', '1', '2016-12-05 00:36:09', NULL, '1', '2016-02-19', '0'),
('539', '10', '60', '1', '2016-12-05 00:36:09', NULL, '1', '2016-02-19', '0'),
('540', '12', '60', '1', '2016-12-05 00:36:09', NULL, '1', '2016-02-19', '0'),
('541', '30', '61', '1', '2016-12-05 00:36:36', NULL, '1', '2016-02-26', '0'),
('542', '13', '61', '1', '2016-12-05 00:36:36', NULL, '1', '2016-02-26', '0'),
('543', '10', '61', '1', '2016-12-05 00:36:36', NULL, '1', '2016-02-26', '0'),
('544', '12', '61', '1', '2016-12-05 00:36:36', NULL, '1', '2016-02-26', '0'),
('545', '30', '62', '1', '2016-12-05 00:37:02', NULL, '1', '2016-02-29', '0'),
('546', '13', '62', '1', '2016-12-05 00:37:03', NULL, '1', '2016-02-29', '0'),
('547', '10', '62', '1', '2016-12-05 00:37:03', NULL, '1', '2016-02-29', '0'),
('548', '12', '62', '1', '2016-12-05 00:37:03', NULL, '1', '2016-02-29', '0'),
('549', '30', '63', '1', '2016-12-05 00:37:29', NULL, '1', '2016-03-04', '0'),
('550', '13', '63', '1', '2016-12-05 00:37:29', NULL, '1', '2016-03-04', '0'),
('551', '10', '63', '1', '2016-12-05 00:37:29', NULL, '1', '2016-03-04', '0'),
('552', '12', '63', '1', '2016-12-05 00:37:29', NULL, '1', '2016-03-04', '0'),
('553', '30', '64', '1', '2016-12-05 00:38:08', NULL, '1', '2016-03-11', '0'),
('554', '13', '64', '1', '2016-12-05 00:38:08', NULL, '1', '2016-03-11', '0'),
('555', '10', '64', '1', '2016-12-05 00:38:08', NULL, '1', '2016-03-11', '0'),
('556', '12', '64', '1', '2016-12-05 00:38:08', NULL, '1', '2016-03-11', '0'),
('557', '30', '65', '1', '2016-12-05 00:38:37', NULL, '1', '2016-03-18', '0'),
('558', '13', '65', '1', '2016-12-05 00:38:37', NULL, '1', '2016-03-18', '0'),
('559', '10', '65', '1', '2016-12-05 00:38:37', NULL, '1', '2016-03-18', '0'),
('560', '12', '65', '1', '2016-12-05 00:38:37', NULL, '1', '2016-03-18', '0'),
('561', '30', '66', '1', '2016-12-05 00:39:09', NULL, '1', '2016-03-25', '0'),
('562', '13', '66', '1', '2016-12-05 00:39:09', NULL, '1', '2016-03-25', '0'),
('563', '10', '66', '1', '2016-12-05 00:39:09', NULL, '1', '2016-03-25', '0'),
('564', '12', '66', '1', '2016-12-05 00:39:09', NULL, '1', '2016-03-25', '0'),
('565', '30', '67', '1', '2016-12-05 00:39:34', NULL, '1', '2016-03-31', '0'),
('566', '13', '67', '1', '2016-12-05 00:39:34', NULL, '1', '2016-03-31', '0'),
('567', '10', '67', '1', '2016-12-05 00:39:34', NULL, '1', '2016-03-31', '0'),
('568', '12', '67', '1', '2016-12-05 00:39:34', NULL, '1', '2016-03-31', '0'),
('569', '13', '3', '1', '2016-12-05 00:58:26', 'Voided.', '2', '2016-12-05', '0'),
('570', '10', '3', '1', '2016-12-05 00:58:26', 'Voided.\n', '1', '2016-03-31', '0'),
('571', '13', '4', '1', '2016-12-05 00:58:49', 'Voided.', '2', '2016-12-05', '0'),
('572', '10', '4', '1', '2016-12-05 00:58:49', 'Voided.\n', '1', '2015-12-08', '0'),
('573', '12', '3', '1', '2016-12-05 00:59:32', 'Voided.\n', '1', '2015-12-08', '0'),
('574', '12', '4', '1', '2016-12-05 00:59:48', 'Voided.\n', '1', '2015-12-24', '0'),
('575', '2', '30', '1', '2016-12-05 01:38:18', NULL, '2', '2016-01-22', NULL),
('581', '2', '31', '1', '2016-12-05 01:38:18', NULL, '1', '2016-01-22', '0'),
('582', '2', '30', '1', '2016-12-05 01:38:18', 'Voided.\nDocument reentered.', '2', '2016-12-05', '0'),
('584', '4', '98', '1', '2016-12-05 01:41:07', 'Voided.\n', '1', '2016-03-31', '0'),
('585', '0', '5', '1', '2016-12-05 01:52:08', NULL, '1', '2015-04-02', '0'),
('586', '1', '50', '1', '2016-12-05 01:53:03', NULL, '1', '2015-04-09', '0'),
('587', '0', '6', '1', '2016-12-05 01:54:07', NULL, '1', '2015-07-09', '0'),
('588', '0', '7', '1', '2016-12-05 01:55:06', NULL, '1', '2015-09-29', '0'),
('589', '0', '8', '1', '2016-12-05 01:55:58', NULL, '1', '2016-01-08', '0'),
('590', '0', '9', '1', '2016-12-05 01:56:45', NULL, '1', '2016-01-19', '0'),
('591', '0', '10', '1', '2016-12-05 01:57:31', NULL, '1', '2016-02-09', '0'),
('592', '0', '11', '1', '2016-12-05 01:59:33', NULL, '1', '2016-02-18', '0'),
('593', '0', '12', '1', '2016-12-05 02:03:18', NULL, '1', '2015-09-14', '0'),
('594', '0', '13', '1', '2016-12-05 02:04:34', NULL, '1', '2015-09-26', '0'),
('595', '0', '14', '1', '2016-12-05 02:05:17', NULL, '1', '2015-09-30', '0'),
('596', '0', '15', '1', '2016-12-05 02:07:20', NULL, '1', '2015-11-09', '0'),
('597', '0', '16', '1', '2016-12-05 02:07:54', NULL, '1', '2015-11-09', '0'),
('598', '0', '17', '1', '2016-12-05 02:08:49', NULL, '1', '2015-11-09', '0'),
('599', '0', '18', '1', '2016-12-05 02:09:33', NULL, '1', '2015-11-10', '0'),
('600', '0', '19', '1', '2016-12-05 02:10:07', NULL, '1', '2015-11-11', '0'),
('601', '0', '20', '1', '2016-12-05 02:11:29', NULL, '1', '2015-11-13', '0'),
('602', '0', '21', '1', '2016-12-05 02:12:28', NULL, '1', '2015-12-13', '0'),
('603', '0', '22', '1', '2016-12-05 02:13:35', NULL, '1', '2015-11-13', '0'),
('604', '0', '23', '1', '2016-12-05 02:14:41', NULL, '1', '2015-11-20', '0'),
('605', '0', '24', '1', '2016-12-05 02:15:45', NULL, '1', '2015-11-20', '0'),
('606', '0', '25', '1', '2016-12-05 02:16:36', NULL, '1', '2015-11-23', '0'),
('607', '0', '26', '1', '2016-12-05 02:18:39', NULL, '1', '2015-11-23', '0'),
('608', '0', '27', '1', '2016-12-05 02:19:17', NULL, '1', '2015-11-23', '0'),
('609', '0', '28', '1', '2016-12-05 02:20:09', NULL, '1', '2015-11-23', '0'),
('610', '0', '29', '1', '2016-12-06 01:06:23', NULL, '1', '2015-04-01', '0'),
('611', '0', '30', '1', '2016-12-06 01:10:17', NULL, '1', '2015-04-08', '0'),
('612', '0', '31', '1', '2016-12-06 01:11:04', NULL, '1', '2015-04-08', '0'),
('613', '0', '32', '1', '2016-12-06 01:11:42', NULL, '1', '2015-04-09', '0'),
('614', '0', '33', '1', '2016-12-06 01:12:23', NULL, '1', '2015-04-09', '0'),
('615', '0', '34', '1', '2016-12-06 01:13:17', NULL, '1', '2015-04-10', '0'),
('616', '0', '35', '1', '2016-12-06 01:14:10', NULL, '1', '2015-04-10', '0'),
('617', '0', '36', '1', '2016-12-06 01:14:58', NULL, '1', '2015-04-20', '0'),
('618', '0', '37', '1', '2016-12-06 01:15:59', NULL, '1', '2015-04-23', '0'),
('619', '0', '38', '1', '2016-12-06 01:17:34', NULL, '1', '2015-04-24', '0'),
('620', '0', '39', '1', '2016-12-06 01:19:02', NULL, '1', '2015-04-29', '0'),
('621', '0', '40', '1', '2016-12-06 01:21:01', NULL, '1', '2015-05-11', '0'),
('622', '0', '41', '1', '2016-12-06 01:21:50', NULL, '1', '2015-05-11', '0'),
('623', '0', '42', '1', '2016-12-06 01:22:55', NULL, '1', '2015-05-11', '0'),
('624', '0', '43', '1', '2016-12-06 01:23:52', NULL, '1', '2015-05-15', '0'),
('625', '0', '44', '1', '2016-12-06 01:24:46', NULL, '1', '2015-05-15', '0'),
('626', '0', '45', '1', '2016-12-06 01:25:35', NULL, '1', '2015-05-21', '0'),
('627', '0', '46', '1', '2016-12-06 01:26:37', NULL, '1', '2015-05-21', '0'),
('628', '0', '47', '1', '2016-12-06 01:27:26', NULL, '1', '2015-05-22', '0'),
('629', '0', '48', '1', '2016-12-06 01:28:34', NULL, '1', '2015-05-22', '0'),
('630', '0', '49', '1', '2016-12-06 01:29:50', NULL, '1', '2015-06-08', '0'),
('631', '0', '50', '1', '2016-12-06 01:30:35', NULL, '1', '2015-06-10', '0'),
('632', '0', '51', '1', '2016-12-06 01:31:34', NULL, '1', '2015-06-18', '0'),
('633', '0', '52', '1', '2016-12-06 01:32:44', NULL, '1', '2015-06-18', '0'),
('634', '0', '53', '1', '2016-12-06 01:33:40', NULL, '1', '2015-06-24', '0'),
('635', '0', '54', '1', '2016-12-06 01:34:38', NULL, '1', '2015-07-08', '0'),
('636', '0', '55', '1', '2016-12-06 01:35:17', NULL, '1', '2015-07-08', '0'),
('637', '0', '56', '1', '2016-12-06 01:36:17', NULL, '1', '2015-08-11', '0'),
('638', '0', '57', '1', '2016-12-06 01:36:57', NULL, '1', '2015-08-11', '0'),
('639', '0', '58', '1', '2016-12-06 01:37:56', NULL, '1', '2015-08-20', '0'),
('640', '0', '59', '1', '2016-12-06 01:38:43', NULL, '1', '2015-08-27', '0'),
('641', '0', '60', '1', '2016-12-06 01:39:17', NULL, '1', '2015-09-16', '0'),
('642', '0', '61', '1', '2016-12-06 01:39:54', NULL, '1', '2015-09-18', '0'),
('643', '0', '62', '1', '2016-12-06 01:40:31', NULL, '1', '2015-09-25', '0'),
('644', '0', '63', '1', '2016-12-06 01:41:29', NULL, '1', '2015-09-29', '0'),
('645', '0', '64', '1', '2016-12-06 01:42:24', NULL, '1', '2015-10-01', '0'),
('646', '0', '65', '1', '2016-12-06 01:43:12', NULL, '1', '2015-10-15', '0'),
('647', '0', '66', '1', '2016-12-06 01:43:52', NULL, '1', '2015-10-26', '0'),
('648', '0', '67', '1', '2016-12-06 01:44:31', NULL, '1', '2015-10-26', '0'),
('649', '0', '68', '1', '2016-12-06 01:45:28', NULL, '1', '2016-02-01', '0'),
('650', '0', '69', '1', '2016-12-06 01:49:16', NULL, '1', '2015-04-08', '0'),
('651', '0', '70', '1', '2016-12-06 01:50:05', NULL, '1', '2015-04-09', '0'),
('652', '0', '71', '1', '2016-12-06 01:51:03', NULL, '1', '2015-07-02', '0'),
('653', '0', '72', '1', '2016-12-06 01:51:46', NULL, '1', '2015-07-09', '0'),
('654', '0', '73', '1', '2016-12-06 01:52:32', NULL, '1', '2015-07-29', '0'),
('655', '0', '74', '1', '2016-12-06 01:53:25', NULL, '1', '2016-02-09', '0'),
('656', '0', '75', '1', '2016-12-06 01:54:07', NULL, '1', '2016-02-16', '0'),
('657', '0', '76', '1', '2016-12-06 01:57:00', NULL, '1', '2015-09-01', '0');
INSERT INTO `6_audit_trail` VALUES
('658', '0', '77', '1', '2016-12-06 01:58:21', NULL, '1', '2016-03-14', '0'),
('659', '0', '78', '1', '2016-12-06 01:58:55', NULL, '1', '2016-03-14', '0'),
('660', '0', '79', '1', '2016-12-06 02:03:22', NULL, '1', '2015-09-21', '0'),
('661', '0', '80', '1', '2016-12-06 02:04:07', NULL, '1', '2015-11-05', '0'),
('662', '0', '81', '1', '2016-12-06 02:04:53', NULL, '1', '2015-11-09', '0'),
('663', '0', '82', '1', '2016-12-06 02:05:28', NULL, '1', '2015-11-09', '0'),
('664', '0', '83', '1', '2016-12-06 02:06:04', NULL, '1', '2016-03-30', '0'),
('665', '0', '84', '1', '2016-12-06 02:07:47', NULL, '1', '2015-05-29', '0'),
('666', '0', '85', '1', '2016-12-06 02:08:41', NULL, '1', '2015-06-01', '0'),
('667', '0', '86', '1', '2016-12-06 02:09:24', NULL, '1', '2015-06-08', '0'),
('668', '0', '87', '1', '2016-12-06 23:37:36', NULL, '1', '2015-04-24', '0'),
('669', '0', '88', '1', '2016-12-06 23:39:09', NULL, '1', '2015-09-29', '0'),
('670', '0', '89', '1', '2016-12-06 23:40:25', NULL, '1', '2015-10-02', '0'),
('671', '0', '90', '1', '2016-12-06 23:41:30', NULL, '1', '2016-01-07', '0'),
('672', '0', '91', '1', '2016-12-06 23:42:11', NULL, '1', '2016-01-22', '0'),
('673', '1', '51', '1', '2016-12-07 01:20:46', NULL, '1', '2015-04-01', '0'),
('674', '1', '52', '1', '2016-12-07 01:22:08', NULL, '1', '2015-04-01', '0'),
('675', '0', '92', '1', '2016-12-07 01:28:30', NULL, '2', '2015-04-01', NULL),
('676', '0', '92', '1', '2016-12-07 01:28:30', 'Voided.\nDocument reentered.', '2', '2016-12-07', '0'),
('677', '0', '93', '1', '2016-12-07 01:28:30', NULL, '1', '2015-04-01', '0'),
('678', '1', '53', '1', '2016-12-07 01:30:31', NULL, '1', '2015-04-01', '0'),
('679', '1', '54', '1', '2016-12-07 01:32:35', NULL, '1', '2015-04-06', '0'),
('680', '1', '55', '1', '2016-12-07 01:35:38', NULL, '1', '2015-04-07', '0'),
('681', '1', '56', '1', '2016-12-07 01:36:36', NULL, '1', '2015-04-09', '0'),
('682', '1', '57', '1', '2016-12-07 01:44:22', NULL, '1', '2015-04-15', '0'),
('683', '1', '58', '1', '2016-12-07 01:45:08', NULL, '1', '2015-04-15', '0'),
('684', '1', '59', '1', '2016-12-07 01:46:03', NULL, '1', '2015-04-16', '0'),
('685', '1', '60', '1', '2016-12-07 01:47:01', NULL, '1', '2015-04-16', '0'),
('686', '1', '61', '1', '2016-12-07 01:49:23', NULL, '1', '2015-04-17', '0'),
('687', '1', '62', '1', '2016-12-07 01:51:12', NULL, '1', '2015-04-22', '0'),
('688', '1', '63', '1', '2016-12-07 01:52:57', NULL, '1', '2015-04-22', '0'),
('689', '1', '64', '1', '2016-12-07 01:54:36', NULL, '1', '2015-04-22', '0'),
('690', '1', '65', '1', '2016-12-07 01:55:49', NULL, '1', '2015-04-24', '0'),
('691', '1', '66', '1', '2016-12-07 02:02:54', NULL, '1', '2015-04-29', '0'),
('692', '1', '67', '1', '2016-12-07 02:04:43', NULL, '1', '2015-05-05', '0'),
('693', '1', '68', '1', '2016-12-07 02:05:16', NULL, '1', '2015-05-07', '0'),
('694', '1', '69', '1', '2016-12-07 02:06:30', NULL, '1', '2015-05-07', '0'),
('695', '2', '32', '1', '2016-12-07 02:08:40', NULL, '1', '2015-04-24', '0'),
('696', '2', '33', '1', '2016-12-07 02:09:49', NULL, '1', '2015-05-12', '0'),
('697', '1', '70', '1', '2016-12-07 02:10:52', NULL, '1', '2015-05-15', '0'),
('698', '1', '71', '1', '2016-12-07 02:12:30', NULL, '1', '2015-05-20', '0'),
('699', '1', '72', '1', '2016-12-07 02:15:35', NULL, '1', '2015-05-22', '0'),
('700', '2', '34', '1', '2016-12-07 02:25:28', NULL, '1', '2015-05-22', '0'),
('701', '1', '73', '1', '2016-12-07 02:36:45', NULL, '1', '2015-05-23', '0'),
('702', '2', '35', '1', '2016-12-07 02:38:03', NULL, '1', '2015-05-23', '0'),
('703', '1', '74', '1', '2016-12-07 02:49:19', NULL, '1', '2015-05-26', '0'),
('704', '1', '75', '1', '2016-12-07 02:50:20', NULL, '1', '2015-05-26', '0'),
('705', '1', '76', '1', '2016-12-07 02:50:59', NULL, '1', '2015-05-29', '0'),
('706', '1', '77', '1', '2016-12-07 02:55:53', NULL, '1', '2015-06-08', '0'),
('707', '1', '78', '1', '2016-12-07 03:01:36', NULL, '1', '2015-06-09', '0'),
('708', '4', '204', '1', '2016-12-07 03:02:05', NULL, '1', '2015-06-09', '0'),
('709', '4', '205', '1', '2016-12-07 03:03:53', NULL, '1', '2015-06-09', '0'),
('710', '1', '79', '1', '2016-12-07 03:14:48', NULL, '2', '2016-03-31', NULL),
('711', '2', '36', '1', '2016-12-07 03:12:26', NULL, '1', '2015-06-24', '0'),
('712', '1', '80', '1', '2016-12-07 03:14:48', NULL, '1', '2015-06-17', '0'),
('713', '1', '79', '1', '2016-12-07 03:14:48', 'Voided.\nDocument reentered.', '2', '2016-12-07', '0'),
('714', '1', '81', '1', '2016-12-07 03:17:03', NULL, '1', '2015-06-25', '0'),
('715', '1', '82', '1', '2016-12-07 03:22:00', NULL, '1', '2015-06-25', '0'),
('716', '2', '37', '1', '2016-12-08 02:09:29', NULL, '1', '2015-07-02', NULL),
('717', '4', '206', '1', '2016-12-08 02:10:04', NULL, '1', '2015-06-29', NULL),
('718', '2', '38', '1', '2016-12-08 02:07:26', NULL, '1', '2015-07-02', '0'),
('719', '2', '37', '1', '2016-12-08 02:09:29', 'Voided.\n', '1', '2016-03-31', '0'),
('720', '4', '206', '1', '2016-12-08 02:10:04', 'Voided.\n', '1', '2016-03-14', '0'),
('721', '1', '83', '1', '2016-12-08 02:25:29', NULL, '2', '2016-03-31', NULL),
('722', '1', '84', '1', '2016-12-08 02:12:19', NULL, '1', '2015-07-09', '0'),
('723', '1', '85', '1', '2016-12-08 02:13:36', NULL, '1', '2015-07-09', '0'),
('724', '1', '86', '1', '2016-12-08 02:16:18', NULL, '2', '2016-03-31', NULL),
('725', '1', '87', '1', '2016-12-08 02:16:18', NULL, '1', '2015-07-10', '0'),
('726', '1', '86', '1', '2016-12-08 02:16:18', 'Voided.\nDocument reentered.', '2', '2016-12-08', '0'),
('727', '1', '88', '1', '2016-12-08 02:17:24', NULL, '1', '2015-07-18', '0'),
('728', '2', '39', '1', '2016-12-08 02:18:12', NULL, '1', '2015-07-21', '0'),
('729', '4', '207', '1', '2016-12-08 02:19:13', NULL, '1', '2015-07-29', '0'),
('730', '1', '89', '1', '2016-12-08 02:20:17', NULL, '1', '2015-07-24', '0'),
('731', '1', '90', '1', '2016-12-08 02:21:18', NULL, '1', '2015-07-24', '0'),
('732', '4', '208', '1', '2016-12-08 02:23:22', NULL, '1', '2015-07-29', '0'),
('733', '1', '91', '1', '2016-12-08 02:25:29', NULL, '1', '2015-07-06', '0'),
('734', '1', '83', '1', '2016-12-08 02:25:29', 'Voided.\nDocument reentered.', '2', '2016-12-08', '0'),
('735', '1', '92', '1', '2016-12-08 02:37:40', NULL, '1', '2015-07-25', '0'),
('736', '2', '40', '1', '2016-12-08 07:21:53', NULL, '1', '2015-07-25', '0'),
('737', '1', '93', '1', '2016-12-08 07:23:38', NULL, '1', '2015-07-30', '0'),
('738', '1', '94', '1', '2016-12-08 07:25:48', NULL, '1', '2015-08-11', '0'),
('739', '1', '95', '1', '2016-12-08 07:27:04', NULL, '1', '2015-08-12', '0'),
('740', '1', '96', '1', '2016-12-08 07:27:53', NULL, '1', '2015-08-12', '0'),
('741', '2', '41', '1', '2016-12-08 07:28:50', NULL, '1', '2015-08-12', '0'),
('742', '1', '97', '1', '2016-12-08 07:29:41', NULL, '1', '2015-08-13', '0'),
('743', '2', '42', '1', '2016-12-08 07:30:27', NULL, '1', '2015-08-25', '0'),
('744', '1', '98', '1', '2016-12-08 07:32:27', NULL, '1', '2015-08-25', '0'),
('745', '1', '99', '1', '2016-12-08 07:33:21', NULL, '1', '2015-08-26', '0'),
('746', '1', '100', '1', '2016-12-08 07:34:22', NULL, '1', '2015-08-26', '0'),
('747', '1', '101', '1', '2016-12-08 07:35:15', NULL, '1', '2015-08-26', '0'),
('748', '1', '102', '1', '2016-12-08 07:36:03', NULL, '1', '2015-08-26', '0'),
('749', '1', '103', '1', '2016-12-08 07:37:59', NULL, '1', '2015-09-02', '0'),
('750', '1', '104', '1', '2016-12-08 07:41:47', NULL, '1', '2015-09-02', '0'),
('751', '1', '105', '1', '2016-12-08 07:44:32', NULL, '1', '2015-09-07', '0'),
('752', '1', '106', '1', '2016-12-08 07:46:05', NULL, '1', '2015-09-11', '0'),
('753', '1', '107', '1', '2016-12-09 03:42:42', NULL, '1', '2015-09-18', '0'),
('754', '4', '209', '1', '2016-12-09 03:43:06', NULL, '1', '2015-09-18', '0'),
('755', '2', '43', '1', '2016-12-09 03:44:08', NULL, '1', '2015-09-18', '0'),
('756', '1', '108', '1', '2016-12-09 03:52:20', NULL, '1', '2015-09-25', '0'),
('757', '2', '44', '1', '2016-12-09 04:06:26', NULL, '1', '2015-09-25', '0'),
('758', '1', '109', '1', '2016-12-09 04:07:19', NULL, '1', '2015-09-25', '0'),
('759', '2', '45', '1', '2016-12-09 04:08:20', NULL, '1', '2015-09-25', '0'),
('760', '2', '46', '1', '2016-12-09 04:12:01', NULL, '1', '2015-09-28', NULL),
('761', '2', '46', '1', '2016-12-09 04:12:01', 'Voided.\n', '1', '2016-03-31', '0'),
('762', '1', '110', '1', '2016-12-09 04:13:09', NULL, '1', '2015-09-28', '0'),
('763', '1', '111', '1', '2016-12-09 04:13:43', NULL, '1', '2015-09-28', '0'),
('764', '2', '47', '1', '2016-12-09 04:14:45', NULL, '1', '2015-09-30', '0'),
('765', '1', '112', '1', '2016-12-09 04:15:44', NULL, '1', '2015-10-09', '0'),
('766', '1', '113', '1', '2016-12-09 04:16:18', NULL, '1', '2015-10-12', '0'),
('767', '1', '114', '1', '2016-12-09 04:16:55', NULL, '1', '2015-10-12', '0'),
('768', '1', '115', '1', '2016-12-09 04:17:47', NULL, '1', '2015-10-15', '0'),
('769', '2', '48', '1', '2016-12-09 04:29:13', NULL, '1', '2015-10-21', '0'),
('770', '2', '49', '1', '2016-12-09 04:29:46', NULL, '1', '2015-10-21', '0'),
('771', '1', '116', '1', '2016-12-09 05:13:51', NULL, '1', '2015-10-23', '0'),
('772', '1', '117', '1', '2016-12-09 05:14:53', NULL, '1', '2015-10-28', '0'),
('773', '1', '118', '1', '2016-12-09 05:15:36', NULL, '1', '2015-10-31', '0'),
('774', '1', '119', '1', '2016-12-09 05:16:15', NULL, '1', '2015-11-04', '0'),
('775', '1', '120', '1', '2016-12-09 05:17:02', NULL, '1', '2015-11-04', '0'),
('776', '1', '121', '1', '2016-12-09 05:17:57', NULL, '1', '2015-11-05', '0'),
('777', '1', '122', '1', '2016-12-09 05:19:06', NULL, '1', '2015-11-12', '0'),
('778', '2', '50', '1', '2016-12-09 05:20:06', NULL, '1', '2015-11-12', '0'),
('779', '1', '123', '1', '2016-12-09 05:20:41', NULL, '1', '2015-11-13', '0'),
('780', '1', '124', '1', '2016-12-09 05:21:46', NULL, '1', '2015-11-19', '0'),
('781', '1', '125', '1', '2016-12-09 05:22:22', NULL, '1', '2015-11-19', '0'),
('782', '1', '126', '1', '2016-12-09 05:23:20', NULL, '1', '2015-11-20', '0'),
('783', '1', '127', '1', '2016-12-09 05:23:59', NULL, '1', '2015-11-20', '0'),
('784', '1', '128', '1', '2016-12-09 05:24:36', NULL, '1', '2015-11-20', '0'),
('785', '2', '51', '1', '2016-12-09 05:25:20', NULL, '1', '2015-11-23', '0'),
('786', '1', '129', '1', '2016-12-09 05:26:14', NULL, '1', '2015-11-24', '0'),
('787', '1', '130', '1', '2016-12-09 05:27:02', NULL, '1', '2015-11-26', '0'),
('788', '1', '131', '1', '2016-12-09 05:27:49', NULL, '1', '2015-11-26', '0'),
('789', '1', '132', '1', '2016-12-09 05:28:26', NULL, '1', '2015-11-30', '0'),
('790', '1', '133', '1', '2016-12-09 05:28:55', NULL, '1', '2015-11-30', '0'),
('791', '1', '134', '1', '2016-12-09 05:31:12', NULL, '1', '2015-11-30', '0'),
('792', '1', '135', '1', '2016-12-14 23:34:05', NULL, '1', '2015-12-01', '0'),
('793', '1', '136', '1', '2016-12-14 23:34:56', NULL, '1', '2015-12-01', '0'),
('794', '1', '137', '1', '2016-12-14 23:35:31', NULL, '1', '2015-12-01', '0'),
('795', '1', '138', '1', '2016-12-14 23:36:18', NULL, '1', '2015-12-07', '0'),
('796', '1', '139', '1', '2016-12-14 23:37:17', NULL, '1', '2015-12-07', '0'),
('797', '1', '140', '1', '2016-12-14 23:38:23', NULL, '1', '2015-12-15', '0'),
('798', '1', '141', '1', '2016-12-14 23:39:13', NULL, '1', '2015-12-16', '0'),
('799', '1', '142', '1', '2016-12-14 23:40:03', NULL, '1', '2015-12-16', '0'),
('800', '2', '52', '1', '2016-12-14 23:46:20', NULL, '1', '2015-12-21', '0'),
('801', '2', '53', '1', '2016-12-14 23:47:12', NULL, '1', '2015-12-21', '0'),
('802', '1', '143', '1', '2016-12-14 23:48:00', NULL, '1', '2015-12-26', '0'),
('803', '1', '144', '1', '2016-12-14 23:55:01', NULL, '1', '2015-12-22', '0'),
('804', '1', '145', '1', '2016-12-14 23:55:38', NULL, '1', '2015-12-23', '0'),
('805', '1', '146', '1', '2016-12-14 23:56:15', NULL, '1', '2015-12-23', '0'),
('806', '1', '147', '1', '2016-12-14 23:56:50', NULL, '1', '2015-12-23', '0'),
('807', '1', '148', '1', '2016-12-14 23:57:19', NULL, '1', '2015-12-29', '0'),
('808', '1', '149', '1', '2016-12-14 23:58:05', NULL, '1', '2015-12-31', '0'),
('809', '2', '54', '1', '2016-12-15 00:08:48', NULL, '1', '2015-12-31', '0'),
('810', '1', '150', '1', '2016-12-15 00:10:53', NULL, '1', '2016-01-04', '0'),
('811', '1', '151', '1', '2016-12-15 00:11:40', NULL, '1', '2016-01-07', '0'),
('812', '1', '152', '1', '2016-12-15 00:12:38', NULL, '1', '2016-01-11', '0'),
('813', '1', '153', '1', '2016-12-15 00:14:16', NULL, '1', '2016-01-11', '0'),
('814', '1', '154', '1', '2016-12-15 00:15:14', NULL, '1', '2016-01-18', '0'),
('815', '2', '55', '1', '2016-12-15 00:20:34', NULL, '1', '2016-01-20', '0');

### Structure of table `6_bank_accounts` ###

DROP TABLE IF EXISTS `6_bank_accounts`;

CREATE TABLE `6_bank_accounts` (
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT '0',
  `bank_account_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_address` tinytext COLLATE utf8_unicode_ci,
  `bank_curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT '0',
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `bank_charge_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `bank_short_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_bank_accounts` ###

INSERT INTO `6_bank_accounts` VALUES
('0303', '3', 'Bank Of Celyon', '', 'Bank Of Celyon', NULL, 'LKR', '0', '3', '4350', '2015-09-30 00:00:00', '-20896', '0', 'BOC'),
('0301', '3', 'Cash In Hand', '', 'Cash In Hand', NULL, 'LKR', '0', '4', '4350', '0000-00-00 00:00:00', '0', '0', 'CIH'),
('0302', '0', 'Petty Cash', '', 'Petty Cash', NULL, 'LKR', '0', '5', '4350', '0000-00-00 00:00:00', '0', '0', 'PC'),
('0300', '1', 'Sampath Bank', '', '', NULL, 'LKR', '0', '6', '4350', '0000-00-00 00:00:00', '0', '0', 'SB');

### Structure of table `6_bank_trans` ###

DROP TABLE IF EXISTS `6_bank_trans`;

CREATE TABLE `6_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ref` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `person_type_id` int(11) NOT NULL DEFAULT '0',
  `person_id` tinyblob,
  `reconciled` date DEFAULT NULL,
  `pay_mode` int(1) NOT NULL,
  `cheque_reference` int(6) NOT NULL,
  `payment_increment` int(11) NOT NULL,
  `payment_number` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB AUTO_INCREMENT=714 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_bank_trans` ###

INSERT INTO `6_bank_trans` VALUES
('1', '1', '1', '3', '001/2015', '2015-07-24', '-750', '0', '0', '0', 'Bank Charges', '2015-07-31', '0', '0', '1', 'BOC/11/2016/P/1'),
('2', '2', '1', '3', '001/2015', '2015-07-24', '0', '0', '0', '0', 'Cash', NULL, '0', '0', '1', 'BOC/11/2016/D/1'),
('3', '2', '2', '3', '002/2015', '2015-07-24', '0', '0', '0', '0', 'Cash', NULL, '0', '0', '2', 'BOC/11/2016/D/2'),
('4', '0', '1', '3', '001/2015', '2015-07-24', '0', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('5', '2', '3', '3', '003/2015', '2015-07-24', '0', '0', '0', '0', 'Cash', NULL, '0', '0', '3', 'BOC/11/2016/D/3'),
('6', '1', '2', '3', '002/2015', '2015-08-06', '-6557', '0', '0', '0', 'Cash', '2015-08-31', '0', '245151', '2', 'BOC/11/2016/P/2'),
('7', '1', '3', '3', '003/2015', '2015-08-20', '-200', '0', '0', '0', 'Cash', '2015-08-31', '0', '0', '3', 'BOC/11/2016/P/3'),
('8', '2', '4', '3', '002/2015', '2015-07-24', '0', '0', '0', '0', 'Cash', NULL, '0', '0', '3', 'BOC/11/2016/D/3'),
('9', '2', '5', '3', '002/2015', '2015-07-24', '25000', '0', '0', '0', 'Cash', '2015-07-24', '0', '0', '4', 'BOC/11/2016/D/4'),
('10', '4', '1', '4', '001/2015', '2015-07-29', '-48658', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('11', '4', '1', '3', '001/2015', '2015-07-29', '48658', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-07-31', '0', '0', '0', '0'),
('12', '4', '2', '4', '002/2015', '2015-08-04', '-51604', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('13', '4', '2', '3', '002/2015', '2015-08-04', '51604', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-08-31', '0', '0', '0', '0'),
('14', '4', '3', '4', '003/2015', '2015-08-05', '-12250', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('15', '4', '3', '3', '003/2015', '2015-08-05', '12250', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-08-31', '0', '0', '0', '0'),
('16', '4', '4', '4', '004/2015', '2015-08-05', '-6547', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('17', '4', '4', '3', '004/2015', '2015-08-05', '6547', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-08-31', '0', '0', '0', '0'),
('18', '4', '5', '4', '005/2015', '2015-08-06', '-6855', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('19', '4', '5', '3', '005/2015', '2015-08-06', '6855', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-08-31', '0', '0', '0', '0'),
('20', '4', '6', '4', '006/2015', '2015-08-12', '-36990', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('21', '4', '6', '3', '006/2015', '2015-08-12', '36990', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-08-31', '0', '0', '0', '0'),
('22', '4', '7', '4', '007/2015', '2015-08-14', '-8100', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('23', '4', '7', '3', '007/2015', '2015-08-14', '8100', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-08-31', '0', '0', '0', '0'),
('24', '4', '8', '4', '008/2015', '2015-08-14', '-7680', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('25', '4', '8', '3', '008/2015', '2015-08-14', '7680', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-08-31', '0', '0', '0', '0'),
('26', '4', '9', '4', '009/2015', '2015-08-14', '-5985', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('27', '4', '9', '3', '009/2015', '2015-08-14', '5985', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-08-31', '0', '0', '0', '0'),
('28', '4', '10', '4', '010/2015', '2015-08-14', '-200', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('29', '4', '10', '3', '010/2015', '2015-08-14', '200', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-08-31', '0', '0', '0', '0'),
('30', '4', '11', '4', '011/2015', '2015-08-20', '-51950', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('31', '4', '11', '3', '011/2015', '2015-08-20', '51950', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-08-31', '0', '0', '0', '0'),
('32', '4', '12', '4', '012/2015', '2015-08-25', '-33460', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('33', '4', '12', '3', '012/2015', '2015-08-25', '33460', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-08-31', '0', '0', '0', '0'),
('34', '1', '4', '3', '004/2015', '2015-08-26', '0', '0', '0', '0', 'Cash', NULL, '1', '245155', '4', 'BOC/11/2016/P/4'),
('35', '4', '13', '4', '013/2015', '2015-08-27', '-26300', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('36', '4', '13', '3', '013/2015', '2015-08-27', '26300', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-08-31', '0', '0', '0', '0'),
('37', '4', '14', '4', '014/2015', '2015-08-31', '-51030', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('38', '4', '14', '3', '014/2015', '2015-08-31', '51030', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-08-31', '0', '0', '0', '0'),
('39', '1', '5', '3', '005/2015', '2015-08-31', '-86546', '0', '0', '0', 'Cash', '2015-08-31', '0', '0', '5', 'BOC/11/2016/P/5'),
('40', '1', '6', '3', '006/2015', '2015-09-01', '-3415', '0', '0', '0', 'Cash', NULL, '0', '0', '6', 'BOC/11/2016/P/6'),
('41', '4', '15', '4', '015/2015', '2015-09-02', '-14825', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('42', '4', '15', '3', '015/2015', '2015-09-02', '14825', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-09-30', '0', '0', '0', '0'),
('43', '4', '16', '4', '016/2015', '2015-09-03', '-26885', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('44', '4', '16', '3', '016/2015', '2015-09-03', '26885', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-09-30', '0', '0', '0', '0'),
('45', '4', '17', '4', '017/2015', '2015-09-07', '-31780', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('46', '4', '17', '3', '017/2015', '2015-09-07', '31780', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', '2015-09-30', '0', '0', '0', '0'),
('47', '4', '18', '4', '018/2015', '2015-09-09', '-11000', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('48', '4', '18', '3', '018/2015', '2015-09-09', '11000', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('49', '4', '19', '4', '019/2015', '2015-09-09', '-5050', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('50', '4', '19', '3', '019/2015', '2015-09-09', '5050', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('51', '4', '20', '4', '020/2015', '2015-09-09', '-8500', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('52', '4', '20', '3', '020/2015', '2015-09-09', '8500', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('53', '1', '7', '3', '007/2015', '2015-09-09', '-8500', '0', '0', '0', 'consultancy fee', NULL, '0', '0', '7', 'BOC/11/2016/P/7'),
('54', '4', '21', '4', '021/2015', '2015-09-10', '-7380', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('55', '4', '21', '3', '021/2015', '2015-09-10', '7380', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('56', '4', '22', '4', '022/2015', '2015-09-10', '-14150', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('57', '4', '22', '3', '022/2015', '2015-09-10', '14150', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('58', '4', '23', '4', '023/2015', '2015-09-11', '-76250', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('59', '4', '23', '3', '023/2015', '2015-09-11', '76250', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('60', '4', '24', '4', '024/2015', '2015-09-14', '-28074', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('61', '4', '24', '3', '024/2015', '2015-09-14', '28074', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('62', '1', '8', '3', '008/2015', '2015-09-17', '-76251', '0', '0', '0', 'Cash', NULL, '1', '245162', '8', 'BOC/11/2016/P/8'),
('63', '4', '25', '4', '025/2015', '2015-09-18', '-26150', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('64', '4', '25', '3', '025/2015', '2015-09-18', '26150', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('65', '4', '26', '4', '026/2015', '2015-09-21', '-20640', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('66', '4', '26', '3', '026/2015', '2015-09-21', '20640', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('67', '4', '27', '4', '001/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('68', '4', '27', '3', '001/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('69', '4', '28', '4', '002/2016', '2015-09-21', '-10890', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('70', '4', '28', '3', '002/2016', '2015-09-21', '10890', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('71', '4', '29', '4', '027/2015', '2015-09-22', '-2165', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('72', '4', '29', '3', '027/2015', '2015-09-22', '2165', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('73', '4', '30', '4', '028/2015', '2015-09-23', '-7935', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('74', '4', '30', '3', '028/2015', '2015-09-23', '7935', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('75', '4', '31', '4', '029/2015', '2015-09-25', '-3775', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('76', '4', '31', '3', '029/2015', '2015-09-25', '3775', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('77', '4', '32', '4', '030/2015', '2015-09-30', '-44483', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('78', '4', '32', '3', '030/2015', '2015-09-30', '44483', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('79', '4', '33', '4', '031/2015', '2015-09-30', '-7605', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('80', '4', '33', '3', '031/2015', '2015-09-30', '7605', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('81', '4', '34', '4', '003/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('82', '4', '34', '3', '003/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('83', '4', '35', '4', '032/2015', '2015-10-05', '-29792', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('84', '4', '35', '3', '032/2015', '2015-10-05', '29792', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('85', '4', '36', '4', '004/2016', '2015-10-01', '-6960', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('86', '4', '36', '3', '004/2016', '2015-10-01', '6960', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('87', '4', '37', '4', '033/2015', '2015-10-06', '-12315', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('88', '4', '37', '3', '033/2015', '2015-10-06', '12315', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('89', '4', '38', '4', '034/2015', '2015-10-08', '-28180', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('90', '4', '38', '3', '034/2015', '2015-10-08', '28180', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('91', '4', '39', '4', '035/2015', '2015-10-09', '-7255', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('92', '4', '39', '3', '035/2015', '2015-10-09', '7255', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('93', '4', '40', '4', '036/2015', '2015-10-12', '-9166', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('94', '4', '40', '3', '036/2015', '2015-10-12', '9166', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('95', '4', '41', '4', '037/2015', '2015-10-12', '-48960', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('96', '4', '41', '3', '037/2015', '2015-10-12', '48960', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('97', '4', '42', '4', '038/2015', '2015-10-15', '-13640', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('98', '4', '42', '3', '038/2015', '2015-10-15', '13640', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('99', '1', '9', '3', '009/2015', '2015-10-15', '-200', '0', '0', '0', 'Cash', NULL, '0', '0', '9', 'BOC/11/2016/P/9'),
('100', '4', '43', '4', '039/2015', '2015-10-16', '-38131', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('101', '4', '43', '3', '039/2015', '2015-10-16', '38131', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('102', '4', '44', '4', '040/2015', '2015-10-16', '-2280', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('103', '4', '44', '3', '040/2015', '2015-10-16', '2280', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('104', '2', '6', '3', '003/2015', '2015-10-16', '50000', '0', '0', '0', 'Cash', NULL, '0', '0', '5', 'BOC/11/2016/D/5'),
('105', '1', '10', '3', '010/2015', '2015-10-16', '-75406', '0', '0', '0', 'Cash', NULL, '0', '0', '10', 'BOC/11/2016/P/10'),
('106', '4', '45', '4', '041/2015', '2015-10-19', '-20748', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('107', '4', '45', '3', '041/2015', '2015-10-19', '20748', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('108', '1', '11', '3', '011/2015', '2015-10-19', '-50000', '0', '0', '0', 'Cash', NULL, '0', '0', '11', 'BOC/11/2016/P/11'),
('109', '1', '12', '3', '012/2015', '2015-10-19', '-5320', '0', '0', '0', 'Cash', NULL, '0', '0', '12', 'BOC/11/2016/P/12'),
('110', '4', '46', '4', '042/2015', '2015-10-21', '-11261', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('111', '4', '46', '3', '042/2015', '2015-10-21', '11261', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('112', '2', '7', '3', '004/2015', '2015-10-22', '22000', '0', '0', '0', 'Cash', NULL, '0', '0', '6', 'BOC/11/2016/D/6'),
('113', '4', '47', '4', '043/2015', '2015-10-23', '-30290', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('114', '4', '47', '3', '043/2015', '2015-10-23', '30290', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('115', '4', '48', '4', '044/2015', '2015-10-23', '-24611', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('116', '4', '48', '3', '044/2015', '2015-10-23', '24611', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('117', '4', '49', '4', '045/2015', '2015-10-26', '-3160', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('118', '4', '49', '3', '045/2015', '2015-10-26', '3160', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('119', '4', '50', '4', '046/2015', '2015-10-26', '-12385', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('120', '4', '50', '3', '046/2015', '2015-10-26', '12385', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('121', '4', '51', '4', '047/2015', '2015-10-26', '-15851', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('122', '4', '51', '3', '047/2015', '2015-10-26', '15851', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('123', '4', '52', '4', '048/2015', '2015-10-29', '-19825', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('124', '4', '52', '3', '048/2015', '2015-10-29', '19825', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('125', '4', '53', '4', '049/2015', '2015-10-30', '-22200', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('126', '4', '53', '3', '049/2015', '2015-10-30', '22200', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('127', '4', '54', '4', '050/2015', '2015-11-02', '-21989', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('128', '4', '54', '3', '050/2015', '2015-11-02', '21989', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('129', '4', '55', '4', '051/2015', '2015-11-03', '-16095', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('130', '4', '55', '3', '051/2015', '2015-11-03', '16095', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('131', '2', '8', '3', '005/2015', '2015-11-05', '43812', '0', '0', '0', 'Cash', NULL, '0', '0', '7', 'BOC/11/2016/D/7'),
('132', '1', '13', '3', '013/2015', '2015-11-05', '-43812', '0', '0', '0', 'Ceylon Electricity Board ', NULL, '0', '0', '13', 'BOC/11/2016/P/13'),
('133', '4', '56', '4', '052/2015', '2015-11-06', '-5940', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('134', '4', '56', '3', '052/2015', '2015-11-06', '5940', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('135', '4', '57', '4', '053/2015', '2015-11-09', '-59550', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('136', '4', '57', '3', '053/2015', '2015-11-09', '59550', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('137', '4', '58', '4', '054/2015', '2015-11-09', '-620', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('138', '4', '58', '3', '054/2015', '2015-11-09', '620', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('139', '1', '14', '3', '014/2015', '2015-11-09', '-59550', '0', '0', '0', 'Cash ', NULL, '0', '0', '14', 'BOC/11/2016/P/14'),
('140', '4', '59', '4', '055/2015', '2015-11-11', '-27194', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('141', '4', '59', '3', '055/2015', '2015-11-11', '27194', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('142', '4', '60', '4', '056/2015', '2015-11-11', '-15850', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('143', '4', '60', '3', '056/2015', '2015-11-11', '15850', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('144', '4', '61', '4', '057/2015', '2015-11-12', '-4629', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('145', '4', '61', '3', '057/2015', '2015-11-12', '4629', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('146', '1', '15', '3', '015/2015', '2015-11-12', '-15850', '0', '0', '0', 'Cash', NULL, '0', '0', '15', 'BOC/11/2016/P/15'),
('147', '4', '62', '4', '058/2015', '2015-11-13', '-83999', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('148', '4', '62', '3', '058/2015', '2015-11-13', '83999', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('149', '1', '16', '3', '016/2015', '2015-11-17', '-214999', '0', '0', '0', 'Cash', NULL, '0', '0', '16', 'BOC/11/2016/P/16'),
('150', '4', '63', '4', '005/2016', '2015-11-18', '-19127', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('151', '4', '63', '3', '005/2016', '2015-11-18', '19127', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('152', '4', '64', '4', '059/2015', '2015-11-18', '-10616', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('153', '4', '64', '3', '059/2015', '2015-11-18', '10616', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('154', '4', '65', '4', '060/2015', '2015-11-20', '-196790', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('155', '4', '65', '3', '060/2015', '2015-11-20', '196790', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('156', '1', '17', '3', '017/2015', '2015-11-20', '-196790', '0', '0', '0', 'Cash', NULL, '0', '0', '17', 'BOC/11/2016/P/17'),
('157', '4', '66', '4', '061/2015', '2015-11-23', '-99271', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('158', '4', '66', '3', '061/2015', '2015-11-23', '99271', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('159', '4', '67', '4', '062/2015', '2015-11-23', '-14819', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('160', '4', '67', '3', '062/2015', '2015-11-23', '14819', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('161', '4', '68', '4', '063/2015', '2015-11-24', '-30910', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('162', '4', '68', '3', '063/2015', '2015-11-24', '30910', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('163', '1', '18', '3', '018/2015', '2015-11-26', '-6740', '0', '0', '0', 'Cash', NULL, '0', '0', '18', 'BOC/11/2016/P/18'),
('164', '1', '19', '3', '019/2015', '2015-11-26', '-30910', '0', '0', '0', 'Cash', NULL, '0', '0', '19', 'BOC/11/2016/P/19'),
('165', '4', '69', '4', '064/2015', '2015-11-30', '-47550', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('166', '4', '69', '3', '064/2015', '2015-11-30', '47550', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('167', '4', '70', '4', '006/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('168', '4', '70', '3', '006/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('169', '1', '20', '3', '020/2015', '2015-11-30', '-43650', '0', '0', '0', 'Cash', NULL, '0', '0', '20', 'BOC/11/2016/P/20'),
('170', '4', '71', '4', '065/2015', '2015-12-01', '-10651', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('171', '4', '71', '3', '065/2015', '2015-12-01', '10651', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('172', '4', '72', '4', '007/2016', '2015-11-30', '-56669', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('173', '4', '72', '3', '007/2016', '2015-11-30', '56669', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('174', '1', '21', '3', '001/2016', '2015-12-01', '-400', '0', '0', '0', 'Cash', NULL, '0', '0', '21', 'BOC/11/2016/P/21'),
('175', '4', '73', '4', '066/2015', '2015-12-04', '-33294', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('176', '4', '73', '3', '066/2015', '2015-12-04', '33294', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('177', '4', '74', '4', '067/2015', '2015-12-07', '-12860', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('178', '4', '74', '3', '067/2015', '2015-12-07', '12860', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('179', '2', '9', '3', '006/2015', '2015-12-07', '96355', '0', '0', '0', 'Cash Deposit', NULL, '0', '0', '8', 'BOC/11/2016/D/8'),
('180', '1', '22', '3', '021/2015', '2015-12-08', '-77215', '0', '0', '0', 'Cash', NULL, '0', '0', '22', 'BOC/11/2016/P/22'),
('181', '2', '10', '3', '007/2015', '2015-12-08', '90978', '0', '0', '0', 'Cash', NULL, '0', '0', '9', 'BOC/11/2016/D/9'),
('182', '1', '23', '3', '022/2015', '2015-12-09', '-7500', '0', '0', '0', 'Cash', NULL, '0', '0', '23', 'BOC/11/2016/P/23'),
('183', '4', '75', '4', '068/2015', '2015-12-09', '-5025', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('184', '4', '75', '3', '068/2015', '2015-12-09', '5025', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('185', '4', '76', '4', '069/2015', '2015-12-09', '-10936', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('186', '4', '76', '3', '069/2015', '2015-12-09', '10936', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('187', '4', '77', '4', '070/2015', '2015-12-09', '-25290', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('188', '4', '77', '3', '070/2015', '2015-12-09', '25290', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('189', '4', '78', '4', '071/2015', '2015-12-10', '-9410', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('190', '4', '78', '3', '071/2015', '2015-12-10', '9410', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('191', '4', '79', '4', '072/2015', '2015-12-10', '-5025', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('192', '4', '79', '3', '072/2015', '2015-12-10', '5025', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('193', '4', '80', '4', '008/2016', '2015-12-14', '-11335', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('194', '4', '80', '3', '008/2016', '2015-12-14', '11335', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('195', '4', '81', '4', '009/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('196', '4', '81', '3', '009/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('197', '2', '11', '3', '008/2015', '2015-12-16', '60926', '0', '0', '0', 'Cash', NULL, '0', '0', '10', 'BOC/11/2016/D/10'),
('198', '4', '82', '4', '010/2016', '2015-12-14', '-23406', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('199', '4', '82', '3', '010/2016', '2015-12-14', '23406', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('200', '4', '83', '4', '073/2015', '2015-12-16', '-10676', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('201', '4', '83', '3', '073/2015', '2015-12-16', '10676', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('202', '1', '24', '3', '023/2015', '2015-12-17', '-400', '0', '0', '0', 'Cash', NULL, '0', '0', '24', 'BOC/11/2016/P/24'),
('203', '4', '84', '4', '074/2015', '2015-12-17', '-6340', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('204', '4', '84', '3', '074/2015', '2015-12-17', '6340', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('205', '4', '85', '4', '075/2015', '2015-12-17', '-2000', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('206', '4', '85', '3', '075/2015', '2015-12-17', '2000', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('207', '1', '25', '3', '024/2015', '2015-12-18', '-750', '0', '0', '0', 'Cash', NULL, '0', '0', '25', 'BOC/11/2016/P/25'),
('208', '4', '86', '4', '076/2015', '2015-12-20', '-132229', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('209', '4', '86', '3', '076/2015', '2015-12-20', '132229', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('210', '0', '2', '3', '001/2015', '2015-12-20', '-132229', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('211', '0', '2', '4', '001/2015', '2015-12-20', '132229', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('212', '1', '26', '3', '025/2015', '2015-12-21', '-54425', '0', '0', '0', 'Cash', NULL, '0', '245192', '26', 'BOC/11/2016/P/26'),
('213', '4', '87', '4', '077/2015', '2015-12-21', '-48187', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('214', '4', '87', '3', '077/2015', '2015-12-21', '48187', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('215', '4', '88', '4', '078/2015', '2015-12-21', '-500', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('216', '4', '88', '3', '078/2015', '2015-12-21', '500', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('217', '2', '12', '3', '009/2015', '2015-12-22', '39704', '0', '0', '0', 'Cash', NULL, '0', '0', '11', 'BOC/11/2016/D/11'),
('218', '1', '27', '3', '026/2015', '2015-12-22', '-39704', '0', '0', '0', 'Cash', NULL, '0', '245194', '27', 'BOC/11/2016/P/27'),
('219', '4', '89', '4', '079/2015', '2015-12-25', '-117783', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('220', '4', '89', '3', '079/2015', '2015-12-25', '117783', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('221', '0', '3', '3', '002/2015', '2015-12-25', '-117783', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('222', '0', '3', '4', '002/2015', '2015-12-25', '117783', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('223', '4', '90', '4', '080/2015', '2015-12-30', '-89416', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('224', '4', '90', '3', '080/2015', '2015-12-30', '89416', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('225', '4', '91', '4', '081/2015', '2015-12-30', '-8113', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('226', '4', '91', '3', '081/2015', '2015-12-30', '8113', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('227', '2', '13', '3', '010/2015', '2015-12-31', '14105', '0', '0', '0', 'Cash', NULL, '0', '0', '12', 'BOC/11/2016/D/12'),
('228', '4', '92', '4', '011/2016', '2016-01-01', '-25788', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('229', '4', '92', '3', '011/2016', '2016-01-01', '25788', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('230', '1', '28', '3', '002/2016', '2016-01-03', '-14105', '0', '0', '0', 'Cash', NULL, '0', '0', '28', 'BOC/11/2016/P/28'),
('231', '2', '14', '3', '001/2016', '2016-01-03', '7295', '0', '0', '0', 'Cash', NULL, '0', '0', '13', 'BOC/11/2016/D/13'),
('232', '2', '15', '3', '002/2016', '2016-01-06', '24910', '0', '0', '0', 'Cash', NULL, '0', '0', '14', 'BOC/11/2016/D/14'),
('233', '1', '29', '3', '027/2015', '2015-12-07', '0', '0', '0', '0', 'Cash', NULL, '0', '245198', '29', 'BOC/11/2016/P/29'),
('234', '1', '30', '3', '027/2015', '2016-01-07', '-24910', '0', '0', '0', 'Cash', NULL, '0', '0', '30', 'BOC/11/2016/P/30'),
('235', '2', '16', '3', '003/2016', '2016-01-07', '0', '0', '0', '0', 'Cash', NULL, '0', '0', '15', 'BOC/11/2016/D/15'),
('236', '2', '17', '3', '003/2016', '2016-01-07', '77736', '0', '0', '0', 'Cash', NULL, '0', '0', '16', 'BOC/11/2016/D/16'),
('237', '2', '18', '3', '004/2016', '2016-01-07', '126479', '0', '0', '0', 'Cash', NULL, '0', '0', '17', 'BOC/11/2016/D/17'),
('238', '4', '93', '4', '012/2016', '2016-01-08', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('239', '4', '93', '3', '012/2016', '2016-01-08', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('240', '4', '94', '4', '013/2016', '2016-01-11', '-25315', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('241', '4', '94', '3', '013/2016', '2016-01-11', '25315', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('242', '2', '19', '3', '005/2016', '2016-01-18', '39500', '0', '0', '0', 'Cash', NULL, '0', '0', '18', 'BOC/11/2016/D/18'),
('243', '4', '95', '4', '014/2016', '2016-01-19', '-14904', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('244', '4', '95', '3', '014/2016', '2016-01-19', '14904', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('245', '4', '96', '4', '015/2016', '2016-01-19', '-11136', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('246', '4', '96', '3', '015/2016', '2016-01-19', '11136', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('247', '1', '31', '3', '003/2016', '2016-01-19', '-85031', '0', '0', '0', 'Cash', NULL, '0', '265751', '31', 'BOC/11/2016/P/31'),
('248', '2', '20', '3', '006/2016', '2016-01-21', '31467', '0', '0', '0', 'Cash', NULL, '0', '0', '19', 'BOC/11/2016/D/19'),
('249', '4', '97', '4', '016/2016', '2016-01-22', '-13314', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('250', '4', '97', '3', '016/2016', '2016-01-22', '13314', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('251', '4', '98', '4', '017/2016', '2016-01-22', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('252', '4', '98', '3', '017/2016', '2016-01-22', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('253', '4', '99', '4', '018/2016', '2016-01-22', '-20', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('254', '4', '99', '3', '018/2016', '2016-01-22', '20', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('255', '1', '32', '3', '004/2016', '2016-01-24', '-31467', '0', '0', '0', 'Cash', NULL, '0', '265754', '32', 'BOC/11/2016/P/32'),
('256', '4', '100', '4', '019/2016', '2016-01-29', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('257', '4', '100', '3', '019/2016', '2016-01-29', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('258', '4', '101', '4', '020/2016', '2016-01-26', '-600', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('259', '4', '101', '3', '020/2016', '2016-01-26', '600', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('260', '4', '102', '4', '021/2016', '2016-01-25', '-37979', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('261', '4', '102', '3', '021/2016', '2016-01-25', '37979', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('262', '4', '103', '4', '022/2016', '2016-01-27', '-17041', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('263', '4', '103', '3', '022/2016', '2016-01-27', '17041', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('264', '1', '33', '3', '005/2016', '2016-01-27', '-7830', '0', '0', '0', 'Cash', NULL, '0', '265757', '33', 'BOC/11/2016/P/33'),
('265', '4', '104', '4', '023/2016', '2016-02-01', '-47450', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('266', '4', '104', '3', '023/2016', '2016-02-01', '47450', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('267', '4', '105', '4', '024/2016', '2016-02-01', '-42932', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('268', '4', '105', '3', '024/2016', '2016-02-01', '42932', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('269', '2', '21', '3', '007/2016', '2016-02-01', '21252', '0', '0', '0', 'Cash', NULL, '0', '0', '20', 'BOC/11/2016/D/20'),
('270', '4', '106', '4', '025/2016', '2016-02-03', '-52975', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('271', '4', '106', '3', '025/2016', '2016-02-03', '52975', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('272', '1', '34', '3', '006/2016', '2016-02-05', '-5980', '0', '0', '0', 'Cash', NULL, '0', '265760', '34', 'BOC/11/2016/P/34'),
('273', '4', '107', '4', '026/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('274', '4', '107', '3', '026/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('275', '2', '22', '3', '008/2016', '2016-02-08', '6275', '0', '0', '0', 'Cash', NULL, '0', '0', '21', 'BOC/11/2016/D/21'),
('276', '2', '23', '3', '009/2016', '2016-02-08', '8195', '0', '0', '0', 'Cash', NULL, '0', '0', '22', 'BOC/11/2016/D/22'),
('277', '4', '108', '4', '027/2016', '2016-02-08', '-750', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('278', '4', '108', '3', '027/2016', '2016-02-08', '750', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('279', '4', '109', '4', '028/2016', '2016-02-09', '-15775', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('280', '4', '109', '3', '028/2016', '2016-02-09', '15775', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('281', '1', '35', '3', '007/2016', '2016-02-09', '-10000', '0', '0', '0', 'Cash', NULL, '0', '0', '35', 'BOC/11/2016/P/35'),
('282', '4', '110', '4', '029/2016', '2016-02-11', '-11941', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('283', '4', '110', '3', '029/2016', '2016-02-11', '11941', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('284', '4', '111', '4', '030/2016', '2016-02-12', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('285', '4', '111', '3', '030/2016', '2016-02-12', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('286', '4', '112', '4', '031/2016', '2016-02-08', '-51886', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('287', '4', '112', '3', '031/2016', '2016-02-08', '51886', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('288', '4', '113', '4', '032/2016', '2016-02-12', '-15674', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('289', '4', '113', '3', '032/2016', '2016-02-12', '15674', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('290', '4', '114', '4', '033/2016', '2016-02-15', '-36862', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('291', '4', '114', '3', '033/2016', '2016-02-15', '36862', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('292', '4', '115', '4', '034/2016', '2016-02-16', '-12850', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('293', '4', '115', '3', '034/2016', '2016-02-16', '12850', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('294', '4', '116', '4', '035/2016', '2016-02-17', '-11817', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('295', '4', '116', '3', '035/2016', '2016-02-17', '11817', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('296', '4', '117', '4', '036/2016', '2016-02-18', '-8470', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('297', '4', '117', '3', '036/2016', '2016-02-18', '8470', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('298', '1', '36', '3', '008/2016', '2016-02-19', '-6275', '0', '0', '0', 'Cash', NULL, '0', '265764', '36', 'BOC/11/2016/P/36'),
('299', '4', '118', '4', '037/2016', '2016-02-23', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('300', '4', '118', '3', '037/2016', '2016-02-23', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('301', '4', '119', '4', '038/2016', '2016-02-23', '-13970', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('302', '4', '119', '3', '038/2016', '2016-02-23', '13970', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('303', '4', '120', '4', '039/2016', '2016-02-23', '-64400', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('304', '4', '120', '3', '039/2016', '2016-02-23', '64400', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('305', '4', '121', '4', '040/2016', '2016-02-25', '-31700', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('306', '4', '121', '3', '040/2016', '2016-02-25', '31700', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('307', '4', '122', '4', '041/2016', '2016-02-26', '-19335', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('308', '4', '122', '3', '041/2016', '2016-02-26', '19335', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('309', '1', '37', '3', '009/2016', '2016-02-26', '-4590', '0', '0', '0', 'Cash', NULL, '0', '265767', '37', 'BOC/11/2016/P/37'),
('310', '1', '38', '3', '010/2016', '2016-02-26', '-14451', '0', '0', '0', 'Cash', NULL, '0', '265768', '38', 'BOC/11/2016/P/38'),
('311', '1', '39', '3', '011/2016', '2016-02-26', '-146960', '0', '0', '0', 'Cash', NULL, '0', '265769', '39', 'BOC/11/2016/P/39'),
('312', '4', '123', '4', '042/2016', '2016-02-26', '-15590', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('313', '4', '123', '3', '042/2016', '2016-02-26', '15590', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('314', '4', '124', '4', '043/2016', '2016-03-01', '-24460', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('315', '4', '124', '3', '043/2016', '2016-03-01', '24460', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('316', '2', '24', '3', '010/2016', '2016-03-01', '83483', '0', '0', '0', 'Cash', NULL, '0', '0', '23', 'BOC/11/2016/D/23'),
('317', '4', '125', '4', '044/2016', '2016-03-02', '-38415', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('318', '4', '125', '3', '044/2016', '2016-03-02', '38415', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('319', '4', '126', '4', '045/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('320', '4', '126', '3', '045/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('321', '4', '127', '4', '046/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('322', '4', '127', '3', '046/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('323', '2', '25', '3', '011/2016', '2016-03-03', '63477', '0', '0', '0', 'Cash', NULL, '0', '0', '24', 'BOC/11/2016/D/24'),
('324', '4', '128', '4', '047/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('325', '4', '128', '3', '047/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('326', '4', '129', '4', '048/2016', '2016-03-04', '-52557', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('327', '4', '129', '3', '048/2016', '2016-03-04', '52557', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('328', '2', '26', '3', '012/2016', '2016-03-04', '30174', '0', '0', '0', 'Cash', NULL, '0', '0', '25', 'BOC/11/2016/D/25'),
('329', '4', '130', '4', '049/2016', '2016-03-03', '-11340', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('330', '4', '130', '3', '049/2016', '2016-03-03', '11340', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('331', '4', '131', '4', '050/2016', '2016-03-08', '-63197', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('332', '4', '131', '3', '050/2016', '2016-03-08', '63197', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('333', '4', '132', '4', '051/2016', '2016-03-31', '-1080', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('334', '4', '132', '3', '051/2016', '2016-03-31', '1080', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('335', '4', '133', '4', '052/2016', '2016-03-10', '-10082', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('336', '4', '133', '3', '052/2016', '2016-03-10', '10082', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('337', '4', '134', '4', '053/2016', '2016-03-11', '-14880', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('338', '4', '134', '3', '053/2016', '2016-03-11', '14880', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('339', '4', '135', '4', '054/2016', '2016-03-14', '-49270', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('340', '4', '135', '3', '054/2016', '2016-03-14', '49270', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('341', '2', '27', '3', '013/2016', '2016-03-14', '128477', '0', '0', '0', 'Cash', NULL, '0', '0', '26', 'BOC/11/2016/D/26'),
('342', '4', '136', '4', '055/2016', '2016-03-16', '-25880', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('343', '4', '136', '3', '055/2016', '2016-03-16', '25880', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('344', '4', '137', '4', '056/2016', '2016-03-17', '-30110', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('345', '4', '137', '3', '056/2016', '2016-03-17', '30110', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('346', '1', '40', '3', '012/2016', '2016-03-17', '-113044', '0', '0', '0', 'Cash', NULL, '0', '265774', '40', 'BOC/11/2016/P/40'),
('347', '4', '138', '4', '057/2016', '2016-03-21', '-33678', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('348', '4', '138', '3', '057/2016', '2016-03-21', '33678', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('349', '4', '139', '4', '058/2016', '2016-03-23', '-53894', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('350', '4', '139', '3', '058/2016', '2016-03-23', '53894', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('351', '4', '140', '4', '059/2016', '2016-03-28', '-43815', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('352', '4', '140', '3', '059/2016', '2016-03-28', '43815', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('353', '1', '41', '3', '013/2016', '2016-03-28', '-3000', '0', '0', '0', 'Cash', NULL, '0', '265778', '41', 'BOC/11/2016/P/41'),
('354', '4', '141', '4', '060/2016', '2016-03-29', '-18565', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('355', '4', '141', '3', '060/2016', '2016-03-29', '18565', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('356', '4', '142', '4', '061/2016', '2016-03-29', '-44727', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('357', '4', '142', '3', '061/2016', '2016-03-29', '44727', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('358', '2', '28', '3', '014/2016', '2016-03-30', '27602', '0', '0', '0', 'Cash', NULL, '0', '0', '27', 'BOC/11/2016/D/27'),
('359', '2', '29', '3', '015/2016', '2016-03-31', '154059', '0', '0', '0', 'Cash', NULL, '0', '0', '28', 'BOC/11/2016/D/28'),
('360', '1', '42', '3', '014/2016', '2016-03-31', '-10625', '0', '0', '0', 'Cash', NULL, '0', '265779', '42', 'BOC/11/2016/P/42'),
('361', '4', '143', '3', '082/2015', '2015-08-13', '-155597', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', '2015-08-31', '0', '0', '0', '0'),
('362', '4', '143', '6', '082/2015', '2015-08-13', '155597', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('363', '4', '144', '6', '083/2015', '2015-08-24', '-96626', '0', '0', '0', 'From Sampath Bank To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('364', '4', '144', '3', '083/2015', '2015-08-24', '96626', '0', '0', '0', 'From Sampath Bank To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('365', '4', '145', '3', '084/2015', '2015-08-25', '-73715', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', '2015-08-31', '0', '0', '0', '0'),
('366', '4', '145', '6', '084/2015', '2015-08-25', '73715', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('367', '4', '146', '3', '085/2015', '2015-08-28', '-59700', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', '2015-08-31', '0', '0', '0', '0'),
('368', '4', '146', '6', '085/2015', '2015-08-28', '59700', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('369', '4', '147', '6', '086/2015', '2015-09-01', '-3415', '0', '0', '0', 'From Sampath Bank To Bank Of Celyon', NULL, '0', '0', '0', '0');
INSERT INTO `6_bank_trans` VALUES
('370', '4', '147', '3', '086/2015', '2015-09-01', '3415', '0', '0', '0', 'From Sampath Bank To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('371', '4', '148', '6', '087/2015', '2015-09-02', '-14825', '0', '0', '0', 'From Sampath Bank To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('372', '4', '148', '3', '087/2015', '2015-09-02', '14825', '0', '0', '0', 'From Sampath Bank To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('373', '4', '149', '6', '088/2015', '2015-09-09', '-8500', '0', '0', '0', 'From Sampath Bank To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('374', '4', '149', '3', '088/2015', '2015-09-09', '8500', '0', '0', '0', 'From Sampath Bank To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('375', '4', '150', '3', '062/2016', '2016-03-31', '0', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('376', '4', '150', '6', '062/2016', '2016-03-31', '0', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('377', '4', '151', '3', '063/2016', '2015-09-25', '-85700', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('378', '4', '151', '6', '063/2016', '2015-09-25', '85700', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('379', '4', '152', '3', '089/2015', '2015-10-09', '-143258', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('380', '4', '152', '6', '089/2015', '2015-10-09', '143258', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('381', '4', '153', '6', '090/2015', '2015-10-12', '-8500', '0', '0', '0', 'From Sampath Bank To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('382', '4', '153', '3', '090/2015', '2015-10-12', '8500', '0', '0', '0', 'From Sampath Bank To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('383', '4', '154', '3', '091/2015', '2015-10-22', '-62015', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('384', '4', '154', '6', '091/2015', '2015-10-22', '62015', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('385', '4', '155', '3', '064/2016', '2016-03-31', '0', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('386', '4', '155', '6', '064/2016', '2016-03-31', '0', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('387', '4', '156', '3', '092/2015', '2015-11-12', '-71838', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('388', '4', '156', '6', '092/2015', '2015-11-12', '71838', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('389', '4', '157', '3', '093/2015', '2015-11-20', '-42872', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('390', '4', '157', '6', '093/2015', '2015-11-20', '42872', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('391', '4', '158', '3', '094/2015', '2015-12-01', '-97265', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('392', '4', '158', '6', '094/2015', '2015-12-01', '97265', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('393', '4', '159', '3', '065/2016', '2015-12-09', '-11335', '0', '0', '0', 'From Bank Of Celyon To Petty Cash', NULL, '0', '0', '0', '0'),
('394', '4', '159', '5', '065/2016', '2015-12-09', '11335', '0', '0', '0', 'From Bank Of Celyon To Petty Cash', NULL, '0', '0', '0', '0'),
('395', '1', '43', '3', '028/2015', '2015-12-09', '-90978', '0', '0', '0', 'Cash', NULL, '0', '0', '43', 'BOC/11/2016/P/43'),
('396', '4', '160', '3', '095/2015', '2015-12-14', '-91789', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('397', '4', '160', '6', '095/2015', '2015-12-14', '91789', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('398', '4', '161', '3', '096/2015', '2015-12-18', '-48922', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('399', '4', '161', '6', '096/2015', '2015-12-18', '48922', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('400', '4', '162', '3', '097/2015', '2015-12-31', '-146216', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('401', '4', '162', '6', '097/2015', '2015-12-31', '146216', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('402', '4', '163', '3', '066/2016', '2016-01-19', '-140343', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('403', '4', '163', '6', '066/2016', '2016-01-19', '140343', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('404', '4', '164', '3', '067/2016', '2016-01-22', '-18740', '0', '0', '0', 'From Bank Of Celyon To Petty Cash', NULL, '0', '0', '0', '0'),
('405', '4', '164', '5', '067/2016', '2016-01-22', '18740', '0', '0', '0', 'From Bank Of Celyon To Petty Cash', NULL, '0', '0', '0', '0'),
('406', '1', '44', '3', '015/2016', '2016-01-22', '-93533', '0', '0', '0', 'Cash', NULL, '0', '0', '44', 'BOC/11/2016/P/44'),
('407', '4', '165', '3', '068/2016', '2016-01-31', '-68954', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('408', '4', '165', '6', '068/2016', '2016-01-31', '68954', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('409', '4', '166', '3', '069/2016', '2016-02-05', '-98122', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('410', '4', '166', '6', '069/2016', '2016-02-05', '98122', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('411', '4', '167', '4', '070/2016', '2016-02-08', '-51886', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('412', '4', '167', '3', '070/2016', '2016-02-08', '51886', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('413', '4', '168', '3', '071/2016', '2016-02-15', '-95616', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('414', '4', '168', '6', '071/2016', '2016-02-15', '95616', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('415', '4', '169', '3', '072/2016', '2016-02-16', '-12594', '0', '0', '0', 'From Bank Of Celyon To Petty Cash', NULL, '0', '0', '0', '0'),
('416', '4', '169', '5', '072/2016', '2016-02-16', '12594', '0', '0', '0', 'From Bank Of Celyon To Petty Cash', NULL, '0', '0', '0', '0'),
('417', '1', '45', '3', '016/2016', '2016-02-16', '-8500', '0', '0', '0', 'Cash', NULL, '0', '0', '45', 'BOC/11/2016/P/45'),
('418', '4', '170', '3', '073/2016', '2016-02-25', '-180069', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('419', '4', '170', '6', '073/2016', '2016-02-25', '180069', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('420', '4', '171', '3', '074/2016', '2016-03-08', '-166177', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('421', '4', '171', '6', '074/2016', '2016-03-08', '166177', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('422', '4', '172', '3', '075/2016', '2016-03-17', '-194500', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('423', '4', '172', '6', '075/2016', '2016-03-17', '194500', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('424', '4', '173', '3', '076/2016', '2016-03-23', '-87572', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('425', '4', '173', '6', '076/2016', '2016-03-23', '87572', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('426', '4', '174', '3', '077/2016', '2016-03-29', '-66560', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('427', '4', '174', '6', '077/2016', '2016-03-29', '66560', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('428', '4', '175', '3', '078/2016', '2016-03-29', '-34059', '0', '0', '0', 'From Bank Of Celyon To Petty Cash', NULL, '0', '0', '0', '0'),
('429', '4', '175', '5', '078/2016', '2016-03-29', '34059', '0', '0', '0', 'From Bank Of Celyon To Petty Cash', NULL, '0', '0', '0', '0'),
('430', '1', '46', '3', '017/2016', '2016-03-29', '-120000', '0', '0', '0', 'Cash', NULL, '0', '0', '46', 'BOC/11/2016/P/46'),
('431', '4', '176', '3', '079/2016', '2016-03-23', '-23449', '0', '0', '0', 'From Bank Of Celyon To Petty Cash', NULL, '0', '0', '0', '0'),
('432', '4', '176', '5', '079/2016', '2016-03-23', '23449', '0', '0', '0', 'From Bank Of Celyon To Petty Cash', NULL, '0', '0', '0', '0'),
('433', '1', '47', '3', '018/2016', '2016-03-23', '-25100', '0', '0', '0', 'Staff Salaries &amp; Wages', NULL, '0', '0', '47', 'BOC/11/2016/P/47'),
('434', '4', '177', '3', '080/2016', '2016-03-11', '-15433', '0', '0', '0', 'From Bank Of Celyon To Petty Cash', NULL, '0', '0', '0', '0'),
('435', '4', '177', '5', '080/2016', '2016-03-11', '15433', '0', '0', '0', 'From Bank Of Celyon To Petty Cash', NULL, '0', '0', '0', '0'),
('436', '4', '178', '3', '081/2016', '2016-03-08', '-29910', '0', '0', '0', 'From Bank Of Celyon To Petty Cash', NULL, '0', '0', '0', '0'),
('437', '4', '178', '5', '081/2016', '2016-03-08', '29910', '0', '0', '0', 'From Bank Of Celyon To Petty Cash', NULL, '0', '0', '0', '0'),
('438', '1', '48', '3', '019/2016', '2016-03-08', '-11783', '0', '0', '0', 'Cash', NULL, '0', '0', '48', 'BOC/11/2016/P/48'),
('439', '1', '49', '3', '004/2015', '2015-08-26', '-10440', '0', '0', '0', 'Cash', '2015-08-31', '0', '0', '49', 'BOC/11/2016/P/49'),
('440', '4', '179', '3', '098/2015', '2015-09-10', '-146980', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('441', '4', '179', '6', '098/2015', '2015-09-10', '146980', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('442', '4', '180', '3', '082/2016', '2015-11-02', '-56607', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('443', '4', '180', '6', '082/2016', '2015-11-02', '56607', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('444', '4', '181', '4', '083/2016', '2016-01-08', '-18110', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('445', '4', '181', '3', '083/2016', '2016-01-08', '18110', '0', '0', '0', 'From Cash In Hand To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('446', '4', '182', '3', '084/2016', '2016-02-08', '-51886', '0', '0', '0', 'From Bank Of Celyon To Cash In Hand', NULL, '0', '0', '0', '0'),
('447', '4', '182', '4', '084/2016', '2016-02-08', '51886', '0', '0', '0', 'From Bank Of Celyon To Cash In Hand', NULL, '0', '0', '0', '0'),
('448', '0', '4', '4', '003/2015', '2015-04-01', '92209', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('449', '0', '4', '6', '003/2015', '2015-04-01', '259938.26', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('450', '0', '4', '5', '003/2015', '2015-04-01', '3000', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('451', '4', '183', '4', '099/2015', '2015-04-02', '-34044', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('452', '4', '183', '6', '099/2015', '2015-04-02', '34044', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('453', '4', '184', '4', '100/2015', '2015-04-02', '-38100', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('454', '4', '184', '6', '100/2015', '2015-04-02', '38100', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('455', '4', '185', '4', '101/2015', '2015-04-24', '-61278', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('456', '4', '185', '6', '101/2015', '2015-04-24', '61278', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('457', '4', '186', '4', '102/2015', '2015-04-30', '-82200', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('458', '4', '186', '6', '102/2015', '2015-04-30', '82200', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('459', '4', '187', '4', '103/2015', '2015-05-14', '-69120', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('460', '4', '187', '6', '103/2015', '2015-05-14', '69120', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('461', '4', '188', '4', '104/2015', '2015-05-22', '-2770', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('462', '4', '188', '6', '104/2015', '2015-05-22', '2770', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('463', '4', '189', '4', '105/2015', '2015-05-30', '-53500', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('464', '4', '189', '6', '105/2015', '2015-05-30', '53500', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('465', '4', '190', '4', '106/2015', '2015-05-31', '-49960', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('466', '4', '190', '6', '106/2015', '2015-05-31', '49960', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('467', '4', '191', '4', '085/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('468', '4', '191', '6', '085/2016', '2016-03-31', '0', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('469', '4', '192', '4', '107/2015', '2015-06-12', '-2340', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('470', '4', '192', '6', '107/2015', '2015-06-12', '2340', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('471', '4', '193', '4', '108/2015', '2015-06-18', '-156092', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('472', '4', '193', '6', '108/2015', '2015-06-18', '156092', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('473', '4', '194', '4', '109/2015', '2015-06-24', '-61410', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('474', '4', '194', '6', '109/2015', '2015-06-24', '61410', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('475', '4', '195', '4', '110/2015', '2015-06-29', '-160', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('476', '4', '195', '6', '110/2015', '2015-06-29', '160', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('477', '4', '196', '4', '111/2015', '2015-07-06', '-93270', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('478', '4', '196', '6', '111/2015', '2015-07-06', '93270', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('479', '4', '197', '4', '112/2015', '2015-07-14', '-56334', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('480', '4', '197', '6', '112/2015', '2015-07-14', '56334', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('481', '4', '198', '4', '113/2015', '2015-07-31', '-55830', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('482', '4', '198', '6', '113/2015', '2015-07-31', '55830', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('483', '4', '199', '4', '114/2015', '2015-08-28', '-520', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('484', '4', '199', '6', '114/2015', '2015-08-28', '520', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('485', '4', '200', '4', '115/2015', '2015-12-01', '-50000', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('486', '4', '200', '6', '115/2015', '2015-12-01', '50000', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('487', '4', '201', '4', '116/2015', '2015-12-17', '-50000', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('488', '4', '201', '6', '116/2015', '2015-12-17', '50000', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('489', '4', '202', '4', '086/2016', '2016-01-21', '-39320', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('490', '4', '202', '6', '086/2016', '2016-01-21', '39320', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('491', '4', '203', '4', '087/2016', '2016-01-22', '-30000', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('492', '4', '203', '6', '087/2016', '2016-01-22', '30000', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('493', '12', '1', '4', '001/2015', '2015-04-30', '0', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('494', '12', '2', '4', '002/2015', '2015-04-30', '0', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('495', '12', '2', '4', '001/2016', '2015-04-30', '0', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('496', '12', '3', '4', '002/2016', '2016-03-31', '0', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('497', '12', '4', '4', '003/2016', '2016-03-31', '0', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('498', '12', '1', '4', '004/2016', '2015-04-30', '1', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('499', '12', '2', '4', '005/2016', '2015-04-30', '1', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('500', '12', '5', '4', '001/2015', '2015-04-30', '272659', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('501', '12', '6', '4', '002/2015', '2015-05-31', '303185', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('502', '12', '7', '4', '003/2015', '2015-06-30', '322814', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('503', '12', '8', '4', '004/2015', '2015-07-03', '26905', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('504', '12', '9', '4', '005/2015', '2015-07-10', '62453', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('505', '12', '10', '4', '006/2015', '2015-07-17', '62364', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('506', '12', '11', '4', '007/2015', '2015-07-24', '61302', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('507', '12', '12', '4', '008/2015', '2015-07-31', '79320', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('508', '12', '13', '4', '009/2015', '2015-08-07', '72048', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('509', '12', '14', '4', '010/2015', '2015-08-14', '74651', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('510', '12', '15', '4', '011/2015', '2015-08-21', '67860', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('511', '12', '16', '4', '012/2015', '2015-08-28', '80505', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('512', '12', '17', '4', '013/2015', '2015-08-31', '48025', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('513', '12', '18', '4', '014/2015', '2015-09-04', '48607', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('514', '12', '19', '4', '015/2015', '2015-09-11', '74533', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('515', '12', '20', '4', '016/2015', '2015-09-18', '79045', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('516', '12', '21', '4', '017/2015', '2015-09-25', '86405', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('517', '12', '22', '4', '018/2015', '2015-09-30', '60248', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('518', '12', '23', '4', '019/2015', '2015-10-04', '23010', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('519', '12', '24', '4', '020/2015', '2015-10-09', '91729', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('520', '12', '25', '4', '021/2015', '2015-10-16', '63100', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('521', '12', '26', '4', '022/2015', '2015-10-23', '76586', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('522', '12', '27', '4', '023/2015', '2015-10-31', '73678', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('523', '12', '28', '4', '024/2015', '2015-11-06', '50375', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('524', '12', '29', '4', '025/2015', '2015-11-13', '65880', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('525', '12', '30', '4', '026/2015', '2015-11-20', '68189', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('526', '12', '31', '4', '027/2015', '2015-11-27', '89000', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('527', '12', '32', '4', '028/2015', '2015-11-30', '40958', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('528', '12', '33', '4', '029/2015', '2015-12-04', '53924', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('529', '12', '34', '4', '030/2015', '2015-12-11', '82963', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('530', '12', '35', '4', '031/2015', '2015-12-18', '71768', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('531', '12', '36', '4', '032/2015', '2015-12-25', '120771', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('532', '12', '37', '4', '033/2015', '2015-12-31', '89350', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('533', '12', '38', '4', '006/2016', '2016-01-01', '9835', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('534', '12', '39', '4', '007/2016', '2016-01-08', '64306', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('535', '12', '40', '4', '008/2016', '2016-01-15', '95720', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('536', '12', '41', '4', '009/2016', '2016-01-22', '62295', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('537', '12', '42', '4', '010/2016', '2016-01-29', '113045', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('538', '12', '43', '4', '011/2016', '2016-01-31', '47945', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('539', '12', '44', '4', '012/2016', '2016-02-05', '64565', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('540', '12', '45', '4', '013/2016', '2016-02-12', '103935', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('541', '12', '46', '4', '014/2016', '2016-02-19', '97114', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('542', '12', '47', '4', '015/2016', '2016-02-26', '110807', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('543', '12', '48', '4', '016/2016', '2016-02-29', '46100', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('544', '12', '49', '4', '017/2016', '2016-03-04', '46887', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('545', '12', '50', '4', '018/2016', '2016-03-11', '107384', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('546', '12', '51', '4', '019/2016', '2016-03-18', '111432', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('547', '12', '52', '4', '020/2016', '2016-03-25', '92910', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('548', '12', '53', '4', '021/2016', '2016-03-31', '74215', '0', '0', '2', '3', NULL, '0', '0', '0', ''),
('549', '12', '54', '4', '022/2016', '2016-01-15', '12635', '0', '0', '2', '4', NULL, '0', '0', '0', ''),
('550', '12', '55', '4', '023/2016', '2016-01-22', '10430', '0', '0', '2', '4', NULL, '0', '0', '0', ''),
('551', '12', '56', '4', '024/2016', '2016-01-29', '6745', '0', '0', '2', '4', NULL, '0', '0', '0', ''),
('552', '12', '57', '4', '025/2016', '2016-01-31', '2310', '0', '0', '2', '4', NULL, '0', '0', '0', ''),
('553', '12', '58', '4', '026/2016', '2016-02-05', '5110', '0', '0', '2', '4', NULL, '0', '0', '0', ''),
('554', '12', '59', '4', '027/2016', '2016-02-12', '12205', '0', '0', '2', '4', NULL, '0', '0', '0', ''),
('555', '12', '60', '4', '028/2016', '2016-02-19', '10485', '0', '0', '2', '4', NULL, '0', '0', '0', ''),
('556', '12', '61', '4', '029/2016', '2016-02-26', '17820', '0', '0', '2', '4', NULL, '0', '0', '0', ''),
('557', '12', '62', '4', '030/2016', '2016-02-29', '5565', '0', '0', '2', '4', NULL, '0', '0', '0', ''),
('558', '12', '63', '4', '031/2016', '2016-03-04', '6750', '0', '0', '2', '4', NULL, '0', '0', '0', ''),
('559', '12', '64', '4', '032/2016', '2016-03-11', '10790', '0', '0', '2', '4', NULL, '0', '0', '0', ''),
('560', '12', '65', '4', '033/2016', '2016-03-18', '13605', '0', '0', '2', '4', NULL, '0', '0', '0', ''),
('561', '12', '66', '4', '034/2016', '2016-03-25', '11435', '0', '0', '2', '4', NULL, '0', '0', '0', ''),
('562', '12', '67', '4', '035/2016', '2016-03-31', '6445', '0', '0', '2', '4', NULL, '0', '0', '0', ''),
('563', '2', '30', '3', '016/2016', '2016-01-22', '0', '0', '0', '0', 'Cash', NULL, '0', '0', '29', 'BOC/12/2016/D/29'),
('569', '2', '31', '3', '016/2016', '2016-01-22', '64828', '0', '0', '0', 'Cash', NULL, '0', '0', '30', 'BOC/12/2016/D/30'),
('571', '1', '50', '6', '029/2015', '2015-04-09', '-40000', '0', '0', '0', 'Cash', NULL, '0', '0', '1', 'SB/12/2016/P/1'),
('572', '0', '11', '6', '004/2016', '2016-02-18', '-6930', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('573', '1', '51', '6', '030/2015', '2015-04-01', '-75700', '0', '0', '0', ' 	Citizen electricals', NULL, '0', '0', '2', 'SB/12/2016/P/2'),
('574', '1', '52', '6', '020/2016', '2015-04-01', '-20000', '0', '0', '0', 'Ramesh', NULL, '0', '0', '3', 'SB/12/2016/P/3'),
('575', '0', '93', '6', '079/2015', '2015-04-01', '-24384', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('576', '1', '53', '6', '031/2015', '2015-04-01', '-912', '0', '0', '0', 'Cash', NULL, '0', '0', '4', 'SB/12/2016/P/4'),
('577', '1', '54', '6', '032/2015', '2015-04-06', '-4620', '0', '0', '0', 'Cash', NULL, '0', '0', '5', 'SB/12/2016/P/5'),
('578', '1', '55', '6', '033/2015', '2015-04-07', '-34800', '0', '0', '0', 'Cash', NULL, '0', '0', '6', 'SB/12/2016/P/6'),
('579', '1', '56', '6', '034/2015', '2015-04-09', '-7000', '0', '0', '0', 'Cash', NULL, '0', '0', '7', 'SB/12/2016/P/7'),
('580', '1', '57', '6', '035/2015', '2015-04-15', '-50313.71', '0', '0', '0', ' 	EPF', NULL, '0', '0', '8', 'SB/12/2016/P/8'),
('581', '1', '58', '6', '036/2015', '2015-04-15', '-7547.06', '0', '0', '0', 'ETF', NULL, '0', '0', '9', 'SB/12/2016/P/9'),
('582', '1', '59', '6', '037/2015', '2015-04-16', '-46900', '0', '0', '0', 'EPF', NULL, '0', '0', '10', 'SB/12/2016/P/10'),
('583', '1', '60', '6', '038/2015', '2015-04-16', '-7035', '0', '0', '0', 'ETF', NULL, '0', '111116', '11', 'SB/12/2016/P/11'),
('584', '1', '61', '6', '039/2015', '2015-04-17', '-23843', '0', '0', '0', 'Cash', NULL, '0', '0', '12', 'SB/12/2016/P/12'),
('585', '1', '62', '6', '040/2015', '2015-04-22', '-2595', '0', '0', '0', 'Cash', NULL, '0', '111117', '13', 'SB/12/2016/P/13'),
('586', '1', '63', '6', '041/2015', '2015-04-22', '-20895', '0', '0', '0', 'Cash', NULL, '0', '0', '14', 'SB/12/2016/P/14'),
('587', '1', '64', '6', '042/2015', '2015-04-22', '-1420', '0', '0', '0', 'Cash', NULL, '0', '0', '15', 'SB/12/2016/P/15'),
('588', '1', '65', '6', '043/2015', '2015-04-24', '-253797.14', '0', '0', '0', 'Cash', NULL, '0', '0', '16', 'SB/12/2016/P/16'),
('589', '1', '66', '6', '044/2015', '2015-04-29', '-30031', '0', '0', '0', 'Cash', NULL, '0', '111118', '17', 'SB/12/2016/P/17'),
('590', '1', '67', '6', '045/2015', '2015-05-05', '-3000', '0', '0', '0', 'Cash', NULL, '0', '0', '18', 'SB/12/2016/P/18'),
('591', '1', '68', '6', '046/2015', '2015-05-07', '-24057', '0', '0', '0', 'Cash', NULL, '0', '0', '19', 'SB/12/2016/P/19'),
('592', '1', '69', '6', '047/2015', '2015-05-07', '-8000', '0', '0', '0', 'Cash', NULL, '0', '0', '20', 'SB/12/2016/P/20'),
('593', '2', '32', '6', '011/2015', '2015-04-24', '150000', '0', '0', '0', 'Cash', NULL, '0', '0', '1', 'SB/12/2016/D/1'),
('594', '2', '33', '6', '012/2015', '2015-05-12', '1975.07', '0', '0', '0', 'Interest', NULL, '0', '0', '2', 'SB/12/2016/D/2'),
('595', '1', '70', '6', '048/2015', '2015-05-15', '-7000', '0', '0', '0', 'Cash', NULL, '0', '0', '21', 'SB/12/2016/P/21'),
('596', '1', '71', '6', '049/2015', '2015-05-20', '-44956', '0', '0', '0', 'Cash', NULL, '0', '0', '22', 'SB/12/2016/P/22'),
('597', '1', '72', '6', '050/2015', '2015-05-22', '-5000', '0', '0', '0', 'Hasantha', NULL, '0', '0', '23', 'SB/12/2016/P/23'),
('598', '2', '34', '6', '013/2015', '2015-05-22', '641445.77', '0', '0', '0', 'Cash', NULL, '0', '0', '3', 'SB/12/2016/D/3'),
('599', '1', '73', '6', '051/2015', '2015-05-23', '-725117.1', '0', '0', '0', 'Cash', NULL, '0', '0', '24', 'SB/12/2016/P/24'),
('600', '2', '35', '6', '014/2015', '2015-05-23', '17750.24', '0', '0', '0', 'Cash', NULL, '0', '0', '4', 'SB/12/2016/D/4'),
('601', '1', '74', '6', '052/2015', '2015-05-26', '-9845', '0', '0', '0', 'Cash', NULL, '0', '0', '25', 'SB/12/2016/P/25'),
('602', '1', '75', '6', '053/2015', '2015-05-26', '-46900', '0', '0', '0', 'EPF', NULL, '0', '0', '26', 'SB/12/2016/P/26'),
('603', '1', '76', '6', '054/2015', '2015-05-29', '-7035', '0', '0', '0', 'ETF', NULL, '0', '0', '27', 'SB/12/2016/P/27'),
('604', '1', '77', '6', '055/2015', '2015-06-08', '-50532', '0', '0', '0', 'Cash', NULL, '0', '0', '28', 'SB/12/2016/P/28'),
('605', '1', '78', '6', '056/2015', '2015-06-09', '-7000', '0', '0', '0', 'Cash', NULL, '0', '0', '29', 'SB/12/2016/P/29'),
('606', '4', '204', '6', '117/2015', '2015-06-09', '-15000', '0', '0', '0', 'From Sampath Bank To Petty Cash', NULL, '0', '0', '0', '0'),
('607', '4', '204', '5', '117/2015', '2015-06-09', '15000', '0', '0', '0', 'From Sampath Bank To Petty Cash', NULL, '0', '0', '0', '0'),
('608', '4', '205', '4', '088/2016', '2015-06-09', '-81650', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('609', '4', '205', '6', '088/2016', '2015-06-09', '81650', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('610', '1', '79', '6', '021/2016', '2016-03-31', '0', '0', '0', '0', 'Cash', NULL, '0', '0', '30', 'SB/12/2016/P/30'),
('611', '2', '36', '6', '015/2015', '2015-06-24', '635732.2', '0', '0', '0', 'Cash', NULL, '0', '0', '5', 'SB/12/2016/D/5'),
('612', '1', '80', '6', '057/2015', '2015-06-17', '-20195', '0', '0', '0', 'Cash', NULL, '0', '0', '31', 'SB/12/2016/P/31'),
('613', '1', '81', '6', '058/2015', '2015-06-25', '-53935', '0', '0', '0', 'Cash', NULL, '0', '0', '32', 'SB/12/2016/P/32'),
('614', '1', '82', '6', '059/2015', '2015-06-25', '-760318.87', '0', '0', '0', 'Cash', NULL, '0', '0', '33', 'SB/12/2016/P/33'),
('615', '2', '37', '6', '016/2015', '2015-07-02', '0', '0', '0', '0', 'Cash', NULL, '0', '0', '6', 'SB/12/2016/D/6'),
('616', '4', '206', '4', '118/2015', '2015-06-29', '0', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('617', '4', '206', '6', '118/2015', '2015-06-29', '0', '0', '0', '0', 'From Cash In Hand To Sampath Bank', NULL, '0', '0', '0', '0'),
('618', '2', '38', '6', '017/2015', '2015-07-02', '4016.71', '0', '0', '0', 'Cash', NULL, '0', '0', '7', 'SB/12/2016/D/7'),
('619', '1', '83', '6', '021/2016', '2016-03-31', '0', '0', '0', '0', 'Cash', NULL, '0', '255543', '34', 'SB/12/2016/P/34'),
('620', '1', '84', '6', '060/2015', '2015-07-09', '-7000', '0', '0', '0', 'Cash', NULL, '0', '255544', '35', 'SB/12/2016/P/35'),
('621', '1', '85', '6', '061/2015', '2015-07-09', '-6870', '0', '0', '0', 'Cash', NULL, '0', '255545', '36', 'SB/12/2016/P/36'),
('622', '1', '86', '6', '022/2016', '2016-03-31', '0', '0', '0', '0', 'Cash', NULL, '0', '255546', '37', 'SB/12/2016/P/37'),
('623', '1', '87', '6', '062/2015', '2015-07-10', '-13559.74', '0', '0', '0', 'Cash', NULL, '0', '0', '38', 'SB/12/2016/P/38'),
('624', '1', '88', '6', '063/2015', '2015-07-18', '-67698', '0', '0', '0', 'Cash', NULL, '0', '255547', '39', 'SB/12/2016/P/39'),
('625', '2', '39', '6', '018/2015', '2015-07-21', '200000', '0', '0', '0', 'Cash', NULL, '0', '0', '8', 'SB/12/2016/D/8'),
('626', '4', '207', '6', '118/2015', '2015-07-29', '-25000', '0', '0', '0', 'From Sampath Bank To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('627', '4', '207', '3', '118/2015', '2015-07-29', '25000', '0', '0', '0', 'From Sampath Bank To Bank Of Celyon', NULL, '0', '0', '0', '0'),
('628', '1', '89', '6', '064/2015', '2015-07-24', '-48366.67', '0', '0', '0', 'EPF', NULL, '0', '255548', '40', 'SB/12/2016/P/40'),
('629', '1', '90', '6', '065/2015', '2015-07-24', '-7255', '0', '0', '0', 'ETF', NULL, '0', '255549', '41', 'SB/12/2016/P/41'),
('630', '4', '208', '3', '119/2015', '2015-07-29', '-25000', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('631', '4', '208', '6', '119/2015', '2015-07-29', '25000', '0', '0', '0', 'From Bank Of Celyon To Sampath Bank', NULL, '0', '0', '0', '0'),
('632', '1', '91', '6', '066/2015', '2015-07-06', '-2340', '0', '0', '0', 'Cash', NULL, '0', '0', '42', 'SB/12/2016/P/42'),
('633', '1', '92', '6', '067/2015', '2015-07-25', '-761361.53', '0', '0', '0', 'Cash', NULL, '0', '0', '43', 'SB/12/2016/P/43'),
('634', '2', '40', '6', '019/2015', '2015-07-25', '485732.2', '0', '0', '0', 'Cash', NULL, '0', '0', '9', 'SB/12/2016/D/9'),
('635', '1', '93', '6', '068/2015', '2015-07-30', '-600', '0', '0', '0', 'Cash', NULL, '0', '0', '44', 'SB/12/2016/P/44'),
('636', '1', '94', '6', '069/2015', '2015-08-11', '-11800', '0', '0', '0', 'Cash', NULL, '0', '0', '45', 'SB/12/2016/P/45'),
('637', '1', '95', '6', '070/2015', '2015-08-12', '-20000', '0', '0', '0', 'Nalindra', NULL, '0', '0', '46', 'SB/12/2016/P/46'),
('638', '1', '96', '6', '071/2015', '2015-08-12', '-1000', '0', '0', '0', 'Cash', NULL, '0', '0', '47', 'SB/12/2016/P/47'),
('639', '2', '41', '6', '020/2015', '2015-08-12', '2041.64', '0', '0', '0', 'Cash', NULL, '0', '0', '10', 'SB/12/2016/D/10'),
('640', '1', '97', '6', '072/2015', '2015-08-13', '-8500', '0', '0', '0', 'Cash', NULL, '0', '0', '48', 'SB/12/2016/P/48'),
('641', '2', '42', '6', '021/2015', '2015-08-25', '684732', '0', '0', '0', 'Cash', NULL, '0', '0', '11', 'SB/12/2016/D/11'),
('642', '1', '98', '6', '073/2015', '2015-08-25', '-756772.2', '0', '0', '0', 'Cash', NULL, '0', '0', '49', 'SB/12/2016/P/49'),
('643', '1', '99', '6', '074/2015', '2015-08-26', '-455', '0', '0', '0', 'Cash', NULL, '0', '0', '50', 'SB/12/2016/P/50'),
('644', '1', '100', '6', '075/2015', '2015-08-26', '-48595.33', '0', '0', '0', 'EPF', NULL, '0', '0', '51', 'SB/12/2016/P/51'),
('645', '1', '101', '6', '076/2015', '2015-08-26', '-7289', '0', '0', '0', 'ETF', NULL, '0', '0', '52', 'SB/12/2016/P/52'),
('646', '1', '102', '6', '077/2015', '2015-08-26', '-50', '0', '0', '0', 'Cash', NULL, '0', '111119', '53', 'SB/12/2016/P/53'),
('647', '1', '103', '6', '078/2015', '2015-09-02', '-4876.25', '0', '0', '0', 'Cash', NULL, '0', '0', '54', 'SB/12/2016/P/54'),
('648', '1', '104', '6', '079/2015', '2015-09-02', '-3090', '0', '0', '0', 'Cash', NULL, '0', '0', '55', 'SB/12/2016/P/55'),
('649', '1', '105', '6', '080/2015', '2015-09-07', '-2960', '0', '0', '0', 'Cash', NULL, '0', '0', '56', 'SB/12/2016/P/56'),
('650', '1', '106', '6', '081/2015', '2015-09-11', '-76251', '0', '0', '0', 'Cash', NULL, '0', '0', '57', 'SB/12/2016/P/57'),
('651', '1', '107', '6', '082/2015', '2015-09-18', '-13000', '0', '0', '0', 'Cash', NULL, '0', '0', '58', 'SB/12/2016/P/58'),
('652', '4', '209', '6', '120/2015', '2015-09-18', '-17000', '0', '0', '0', 'From Sampath Bank To Cash In Hand', NULL, '0', '0', '0', '0'),
('653', '4', '209', '4', '120/2015', '2015-09-18', '17000', '0', '0', '0', 'From Sampath Bank To Cash In Hand', NULL, '0', '0', '0', '0'),
('654', '2', '43', '6', '022/2015', '2015-09-18', '17000', '0', '0', '0', 'Interest', NULL, '0', '0', '12', 'SB/12/2016/D/12'),
('655', '1', '108', '6', '083/2015', '2015-09-25', '-732072.2', '0', '0', '0', 'Cash', NULL, '0', '0', '59', 'SB/12/2016/P/59'),
('656', '2', '44', '6', '023/2015', '2015-09-25', '460032.2', '0', '0', '0', 'Cash', NULL, '0', '0', '13', 'SB/12/2016/D/13'),
('657', '1', '109', '6', '084/2015', '2015-09-25', '-2600', '0', '0', '0', 'Cash', NULL, '0', '0', '60', 'SB/12/2016/P/60'),
('658', '2', '45', '6', '024/2015', '2015-09-25', '175000', '0', '0', '0', 'Cash', NULL, '0', '0', '14', 'SB/12/2016/D/14'),
('659', '2', '46', '6', '025/2015', '2015-09-28', '0', '0', '0', '0', 'EPF', NULL, '0', '0', '15', 'SB/12/2016/D/15'),
('660', '1', '110', '6', '085/2015', '2015-09-28', '-48900', '0', '0', '0', 'Cash', NULL, '0', '0', '61', 'SB/12/2016/P/61'),
('661', '1', '111', '6', '086/2015', '2015-09-28', '-7335', '0', '0', '0', 'ETF', NULL, '0', '0', '62', 'SB/12/2016/P/62'),
('662', '2', '47', '6', '025/2015', '2015-09-30', '2', '0', '0', '0', 'Error Correction', NULL, '0', '0', '15', 'SB/12/2016/D/15'),
('663', '1', '112', '6', '087/2015', '2015-10-09', '-955', '0', '0', '0', 'Cash', NULL, '0', '0', '63', 'SB/12/2016/P/63'),
('664', '1', '113', '6', '088/2015', '2015-10-12', '-2720', '0', '0', '0', 'Cash', NULL, '0', '0', '64', 'SB/12/2016/P/64'),
('665', '1', '114', '6', '089/2015', '2015-10-12', '-37745', '0', '0', '0', 'Cash', NULL, '0', '0', '65', 'SB/12/2016/P/65'),
('666', '1', '115', '6', '090/2015', '2015-10-15', '-37661', '0', '0', '0', 'Cash', NULL, '0', '0', '66', 'SB/12/2016/P/66'),
('667', '2', '48', '6', '026/2015', '2015-10-21', '460032.2', '0', '0', '0', 'Cash', NULL, '0', '0', '16', 'SB/12/2016/D/16'),
('668', '2', '49', '6', '027/2015', '2015-10-21', '200000', '0', '0', '0', 'Cash', NULL, '0', '0', '17', 'SB/12/2016/D/17'),
('669', '1', '116', '6', '091/2015', '2015-10-23', '-732072.2', '0', '0', '0', 'Cash', NULL, '0', '0', '67', 'SB/12/2016/P/67'),
('670', '1', '117', '6', '092/2015', '2015-10-28', '-4430', '0', '0', '0', 'Cash', NULL, '0', '0', '68', 'SB/12/2016/P/68'),
('671', '1', '118', '6', '093/2015', '2015-10-31', '-650', '0', '0', '0', 'Cash', NULL, '0', '0', '69', 'SB/12/2016/P/69'),
('672', '1', '119', '6', '094/2015', '2015-11-04', '-5280', '0', '0', '0', 'Cash', NULL, '0', '0', '70', 'SB/12/2016/P/70'),
('673', '1', '120', '6', '095/2015', '2015-11-04', '-5000', '0', '0', '0', 'NALINDA&#039;S ', NULL, '0', '111120', '71', 'SB/12/2016/P/71'),
('674', '1', '121', '6', '096/2015', '2015-11-05', '-4920', '0', '0', '0', 'Cash', NULL, '0', '0', '72', 'SB/12/2016/P/72'),
('675', '1', '122', '6', '097/2015', '2015-11-12', '-8500', '0', '0', '0', 'Cash', NULL, '0', '0', '73', 'SB/12/2016/P/73'),
('676', '2', '50', '6', '028/2015', '2015-11-12', '2495.34', '0', '0', '0', 'Cash', NULL, '0', '0', '18', 'SB/12/2016/D/18'),
('677', '1', '123', '6', '098/2015', '2015-11-13', '-15499', '0', '0', '0', 'Cash', NULL, '0', '0', '74', 'SB/12/2016/P/74'),
('678', '1', '124', '6', '099/2015', '2015-11-19', '-88046', '0', '0', '0', 'Cash', NULL, '0', '0', '75', 'SB/12/2016/P/75'),
('679', '1', '125', '6', '100/2015', '2015-11-19', '-11225.5', '0', '0', '0', 'Cash', NULL, '0', '0', '76', 'SB/12/2016/P/76'),
('680', '1', '126', '6', '101/2015', '2015-11-20', '-1565.09', '0', '0', '0', 'ETF ', NULL, '0', '0', '77', 'SB/12/2016/P/77'),
('681', '1', '127', '6', '102/2015', '2015-11-20', '-48900', '0', '0', '0', 'EPF', NULL, '0', '0', '78', 'SB/12/2016/P/78'),
('682', '1', '128', '6', '103/2015', '2015-11-20', '-8435.25', '0', '0', '0', 'ETF', NULL, '0', '0', '79', 'SB/12/2016/P/79'),
('683', '2', '51', '6', '029/2015', '2015-11-23', '656532.2', '0', '0', '0', 'Cash', NULL, '0', '0', '19', 'SB/12/2016/D/19'),
('684', '1', '129', '6', '104/2015', '2015-11-24', '-86000', '0', '0', '0', ' 	Ramesh Salary', NULL, '0', '0', '80', 'SB/12/2016/P/80'),
('685', '1', '130', '6', '105/2015', '2015-11-26', '-48900', '0', '0', '0', 'EPF', NULL, '0', '0', '81', 'SB/12/2016/P/81'),
('686', '1', '131', '6', '106/2015', '2015-11-26', '-7335', '0', '0', '0', 'ETF', NULL, '0', '0', '82', 'SB/12/2016/P/82'),
('687', '1', '132', '6', '107/2015', '2015-11-30', '-3900', '0', '0', '0', 'Cash', NULL, '0', '0', '83', 'SB/12/2016/P/83'),
('688', '1', '133', '6', '108/2015', '2015-11-30', '-600', '0', '0', '0', 'Cash', NULL, '0', '0', '84', 'SB/12/2016/P/84'),
('689', '1', '134', '6', '109/2015', '2015-11-30', '-633772.2', '0', '0', '0', 'Cash', NULL, '0', '0', '85', 'SB/12/2016/P/85'),
('690', '1', '135', '6', '110/2015', '2015-12-01', '-8500', '0', '0', '0', 'Cash', NULL, '0', '0', '86', 'SB/12/2016/P/86'),
('691', '1', '136', '6', '111/2015', '2015-12-01', '-50000', '0', '0', '0', 'Cash', NULL, '0', '0', '87', 'SB/12/2016/P/87'),
('692', '1', '137', '6', '112/2015', '2015-12-01', '-11335', '0', '0', '0', 'Cash', NULL, '0', '0', '88', 'SB/12/2016/P/88'),
('693', '1', '138', '6', '113/2015', '2015-12-07', '-610', '0', '0', '0', 'Cash', NULL, '0', '0', '89', 'SB/12/2016/P/89'),
('694', '1', '139', '6', '114/2015', '2015-12-07', '-7500', '0', '0', '0', 'Amilas', NULL, '0', '0', '90', 'SB/12/2016/P/90'),
('695', '1', '140', '6', '115/2015', '2015-12-15', '-8500', '0', '0', '0', 'Cash', NULL, '0', '0', '91', 'SB/12/2016/P/91'),
('696', '1', '141', '6', '116/2015', '2015-12-16', '-500', '0', '0', '0', 'Cash', NULL, '0', '0', '92', 'SB/12/2016/P/92'),
('697', '1', '142', '6', '117/2015', '2015-12-16', '-90978', '0', '0', '0', 'Cash', NULL, '0', '0', '93', 'SB/12/2016/P/93'),
('698', '2', '52', '6', '030/2015', '2015-12-21', '461531.2', '0', '0', '0', 'Cash', NULL, '0', '0', '20', 'SB/12/2016/D/20'),
('699', '2', '53', '6', '031/2015', '2015-12-21', '250000', '0', '0', '0', 'Cash', NULL, '0', '0', '21', 'SB/12/2016/D/21'),
('700', '1', '143', '6', '118/2015', '2015-12-26', '-86000', '0', '0', '0', 'Ramesh Salary', NULL, '0', '0', '94', 'SB/12/2016/P/94'),
('701', '1', '144', '6', '119/2015', '2015-12-22', '-664547.2', '0', '0', '0', 'Cash', NULL, '0', '1', '95', 'SB/12/2016/P/95'),
('702', '1', '145', '6', '120/2015', '2015-12-23', '-6885', '0', '0', '0', 'ETF', NULL, '0', '0', '96', 'SB/12/2016/P/96'),
('703', '1', '146', '6', '121/2015', '2015-12-23', '-45900', '0', '0', '0', 'EPF', NULL, '0', '0', '97', 'SB/12/2016/P/97'),
('704', '1', '147', '6', '122/2015', '2015-12-23', '-2500', '0', '0', '0', 'Cash', NULL, '0', '0', '98', 'SB/12/2016/P/98'),
('705', '1', '148', '6', '123/2015', '2015-12-29', '-1850', '0', '0', '0', 'Cash', NULL, '0', '0', '99', 'SB/12/2016/P/99'),
('706', '1', '149', '6', '124/2015', '2015-12-31', '-600', '0', '0', '0', 'Cash', NULL, '0', '0', '100', 'SB/12/2016/P/100'),
('707', '2', '54', '6', '032/2015', '2015-12-31', '1', '0', '0', '0', 'Error Correction', NULL, '0', '0', '22', 'SB/12/2016/D/22'),
('708', '1', '150', '6', '021/2016', '2016-01-04', '-7295', '0', '0', '0', 'Cash', NULL, '0', '0', '101', 'SB/12/2016/P/101'),
('709', '1', '151', '6', '022/2016', '2016-01-07', '-77736', '0', '0', '0', 'Cash', NULL, '0', '0', '102', 'SB/12/2016/P/102'),
('710', '1', '152', '6', '023/2016', '2016-01-11', '-8500', '0', '0', '0', 'Cash', NULL, '0', '0', '103', 'SB/12/2016/P/103'),
('711', '1', '153', '6', '024/2016', '2016-01-11', '-20000', '0', '0', '0', 'NALINDA&#039;S', NULL, '0', '0', '104', 'SB/12/2016/P/104'),
('712', '1', '154', '6', '025/2016', '2016-01-18', '-50000', '0', '0', '0', 'Cash', NULL, '0', '0', '105', 'SB/12/2016/P/105'),
('713', '2', '55', '6', '017/2016', '2016-01-20', '431532.2', '0', '0', '0', 'Cash', NULL, '0', '0', '23', 'SB/12/2016/D/23');

### Structure of table `6_bom` ###

DROP TABLE IF EXISTS `6_bom`;

CREATE TABLE `6_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `component` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_bom` ###

INSERT INTO `6_bom` VALUES
('1', '201', '101', '1', 'DEF', '1'),
('2', '201', '102', '1', 'DEF', '1'),
('3', '201', '103', '1', 'DEF', '1'),
('4', '201', '301', '1', 'DEF', '1');

### Structure of table `6_budget_trans` ###

DROP TABLE IF EXISTS `6_budget_trans`;

CREATE TABLE `6_budget_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `amount` double NOT NULL DEFAULT '0',
  `dimension_id` int(11) DEFAULT '0',
  `dimension2_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_budget_trans` ###


### Structure of table `6_chart_class` ###

DROP TABLE IF EXISTS `6_chart_class`;

CREATE TABLE `6_chart_class` (
  `cid` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `class_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_chart_class` ###

INSERT INTO `6_chart_class` VALUES
('1', 'Assets', '1', '0'),
('2', 'Liabilities', '2', '0'),
('3', 'Income', '4', '0'),
('4', 'Expenses', '6', '0'),
('5', 'Equity', '3', '0');

### Structure of table `6_chart_master` ###

DROP TABLE IF EXISTS `6_chart_master`;

CREATE TABLE `6_chart_master` (
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_code2` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_chart_master` ###

INSERT INTO `6_chart_master` VALUES
('0001', '', 'Outlet Building', '1.2', '0'),
('0002', '', 'Kitchen Equipment', '1.2', '0'),
('0003', '', 'Restaurant Building ', '1.2', '0'),
('0004', '', 'Ceptic tank', '1.2', '0'),
('0005', '', 'Resturent Equipment', '1.2', '0'),
('0006', '', 'Vacume cleaner', '1.2', '0'),
('0007', '', 'Generator', '1.2', '0'),
('0008', '', 'Motor Bike', '1.2', '0'),
('0009', '', 'Foot Bicycle', '1.2', '0'),
('0010', '', 'CCTV Camera', '1.2', '0'),
('0011', '', 'Canopy', '1.2', '0'),
('0012', '', 'Intangible assets-Website', '1.2', '0'),
('0013', '', 'Rotor Slasher', '1.2', '0'),
('0014', '', 'Computer', '1.2', '0'),
('0100', '', 'Inventory', '10', '0'),
('0250', '', 'Account Receivable', '2.1', '0'),
('0251', '', 'H L DE Mel &amp; Co (PVT) LTD', '2.1', '0'),
('0252', '', 'RATRANKOTUWA ESTATE A/C', '11', '0'),
('0253', '', 'GALPOTHAYAYA   ESTATE', '2.1', '0'),
('0254', '', 'H L DE Mel (PVT) LTD', '11', '0'),
('0255', '', 'DEMATAGOLLA     ESTATE', '2.1', '0'),
('0256', '', 'RAGEDARA    ESTATE', '2.1', '0'),
('0257', '', 'DIYETHURE 1.ESTATE', '2.1', '0'),
('0258', '', 'DIYETHURE 11.ESTATE', '2.1', '0'),
('0259', '', 'DIYETHURE 111.ESTATE', '2.1', '0'),
('0260', '', 'MILLAWAANA    ESTATE', '2.1', '0'),
('0261', '', 'WALPOLAYAYA ESTATE', '2.1', '0'),
('0262', '', 'JECOB DE MEL TRUST', '2.1', '0'),
('0263', '', 'MARANDAWILLA ESTATE', '2.1', '0'),
('0264', '', 'MARANDAPITIYA  ESTATE', '2.1', '0'),
('0300', '', 'Sampath Bank.', '2.2', '0'),
('0301', '', 'Cash In Hand', '2.2', '0'),
('0302', '', 'Petty cash', '2.2', '0'),
('0303', '', 'Bank Of Ceylon', '2.2', '0'),
('0350', '', 'Account Payable', '3.1', '0'),
('0351', '', 'EPF Payable', '3.1', '0'),
('0352', '', 'ETF Payable', '3.1', '0'),
('0353', '', 'Salary Payable', '3.1', '0'),
('0534', '', 'PAYE Payable', '3.1', '0'),
('1510', '', 'Inventory', '10', '0'),
('2000', '', 'Cost Of Sales- foods', '13', '0'),
('2110', '', 'Cost Of sales - Beverage', '13', '0'),
('3000', '', 'Retained Earning', '11', '0'),
('3400', '', 'Suspense Account', '11', '0'),
('3500', '', 'Profit &amp; Loss', '11', '0'),
('4050', '', 'ROMESH DE MEL', '11', '0'),
('4100', '', 'Sales Income', '6', '0'),
('4151', '', 'Donation', '7', '0'),
('4152', '', 'Directors Traveling', '7', '0'),
('4153', '', 'Elecrtical expenses', '7', '0'),
('4154', '', 'Advertising Expenses', '7', '0'),
('4155', '', 'Management fee', '7', '0'),
('4156', '', 'Depreciation', '7', '0'),
('4157', '', 'Telephone &amp; Internet', '7', '0'),
('4158', '', 'Secretarial Fees', '7', '0'),
('4159', '', 'Festival Advance', '7', '0'),
('4160', '', 'Insurance expenses', '7', '0'),
('4161', '', 'Outlet Glass insurance', '7', '0'),
('4162', '', 'Packing Materials', '7', '0'),
('4163', '', 'Traveling and transport expenses', '7', '0'),
('4164', '', 'Office Cleaning Expenses', '7', '0'),
('4165', '', 'stationery expenses', '7', '0'),
('4166', '', 'Maintain expenses', '7', '0'),
('4167', '', 'Miscellaneous expenses', '7', '0'),
('4168', '', 'Gas &amp; energy expenses', '7', '0'),
('4169', '', 'Staff transport', '7', '0'),
('4170', '', 'EPF', '7', '0'),
('4171', '', 'ETF', '7', '0'),
('4200', '', 'Salary and wages', '7', '0'),
('4250', '', 'Staff Welfare', '7', '0'),
('4270', '', 'Staff Loan', '2.1', '0'),
('4300', '', 'FD Interest Income', '8', '0'),
('4350', '', 'Bank Charges', '9', '0'),
('4351', '', 'W.H.T', '8', '0'),
('5040', '', 'Purchase price Variance', '13', '0'),
('535', '', 'V.A.T Payable', '3', '0'),
('9990', '', 'Year Profit/Loss', '7', '0');

### Structure of table `6_chart_types` ###

DROP TABLE IF EXISTS `6_chart_types`;

CREATE TABLE `6_chart_types` (
  `id` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `class_id` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '-1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_chart_types` ###

INSERT INTO `6_chart_types` VALUES
('1', 'Non Current Assets', '1', '', '0'),
('1.2', 'Property Plant &amp; Equipment', '1', '1', '0'),
('1.3', 'Investments on Shares', '1', '1', '0'),
('1.4', 'Fixed Deposits', '1', '1', '0'),
('10', 'Inventory Assets', '1', '', '0'),
('11', 'Equity', '5', '', '0'),
('12', 'Distribution expenses', '1', '', '0'),
('13', 'Cost Of Sale', '4', '', '0'),
('2', 'Current Asset', '1', '', '0'),
('2.1', 'Other Receivables', '1', '2', '0'),
('2.2', 'Cash &amp; Cash Equivalents', '1', '2', '0'),
('2.3', 'Temporary Loan', '1', '2', '0'),
('2.4', 'Refundable Deposit', '1', '2', '0'),
('2.5', 'Amounts Due From Related Parties', '1', '2', '0'),
('3', 'Current Liabilities', '2', '', '0'),
('3.1', 'Other Payables', '2', '3', '0'),
('6', 'Revenue', '3', '', '0'),
('6.1', 'Agent Commission', '3', '6', '0'),
('6.2', 'Other Operating Income', '3', '6', '0'),
('6.3', 'Restaurant Project Profit or Loss', '3', '6', '0'),
('7', 'Administrative Expenses', '4', '', '0'),
('7.', 'Retained Earnings', '2', '', '0'),
('8', 'Finance Income', '3', '', '0'),
('9', 'Finance Cost', '4', '', '0'),
('9.', 'Other Revenue', '3', '', '0');

### Structure of table `6_comments` ###

DROP TABLE IF EXISTS `6_comments`;

CREATE TABLE `6_comments` (
  `type` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_comments` ###

INSERT INTO `6_comments` VALUES
('0', '1', '2015-07-24', 'Error Correction'),
('4', '1', '2015-07-29', 'From Cash In Hand To Bank Of Celyon'),
('4', '2', '2015-08-04', 'From Cash In Hand To Bank Of Celyon'),
('4', '3', '2015-08-05', 'From Cash In Hand To Bank Of Celyon'),
('4', '4', '2015-08-05', 'From Cash In Hand To Bank Of Celyon'),
('4', '5', '2015-08-06', 'From Cash In Hand To Bank Of Celyon'),
('4', '6', '2015-08-12', 'From Cash In Hand To Bank Of Celyon'),
('4', '7', '2015-08-14', 'From Cash In Hand To Bank Of Celyon'),
('4', '8', '2015-08-14', 'From Cash In Hand To Bank Of Celyon'),
('4', '9', '2015-08-14', 'From Cash In Hand To Bank Of Celyon'),
('4', '10', '2015-08-14', 'From Cash In Hand To Bank Of Celyon'),
('4', '11', '2015-08-20', 'From Cash In Hand To Bank Of Celyon'),
('4', '12', '2015-08-25', 'From Cash In Hand To Bank Of Celyon'),
('4', '13', '2015-08-27', 'From Cash In Hand To Bank Of Celyon'),
('4', '14', '2015-08-31', 'From Cash In Hand To Bank Of Celyon'),
('4', '15', '2015-09-02', 'From Cash In Hand To Bank Of Celyon'),
('4', '16', '2015-09-03', 'From Cash In Hand To Bank Of Celyon'),
('4', '17', '2015-09-07', 'From Cash In Hand To Bank Of Celyon'),
('4', '18', '2015-09-09', 'From Cash In Hand To Bank Of Celyon'),
('4', '19', '2015-09-09', 'From Cash In Hand To Bank Of Celyon'),
('4', '20', '2015-09-09', 'From Cash In Hand To Bank Of Celyon'),
('4', '21', '2015-09-10', 'From Cash In Hand To Bank Of Celyon'),
('4', '22', '2015-09-10', 'From Cash In Hand To Bank Of Celyon'),
('4', '23', '2015-09-11', 'From Cash In Hand To Bank Of Celyon'),
('4', '24', '2015-09-14', 'From Cash In Hand To Bank Of Celyon'),
('4', '25', '2015-09-18', 'From Cash In Hand To Bank Of Celyon'),
('4', '26', '2015-09-21', 'From Cash In Hand To Bank Of Celyon'),
('4', '28', '2015-09-21', 'From Cash In Hand To Bank Of Celyon'),
('4', '29', '2015-09-22', 'From Cash In Hand To Bank Of Celyon'),
('4', '30', '2015-09-23', 'From Cash In Hand To Bank Of Celyon'),
('4', '31', '2015-09-25', 'From Cash In Hand To Bank Of Celyon'),
('4', '32', '2015-09-30', 'From Cash In Hand To Bank Of Celyon'),
('4', '33', '2015-09-30', 'From Cash In Hand To Bank Of Celyon'),
('4', '35', '2015-10-05', 'From Cash In Hand To Bank Of Celyon'),
('4', '36', '2015-10-01', 'From Cash In Hand To Bank Of Celyon'),
('4', '37', '2015-10-06', 'From Cash In Hand To Bank Of Ceylon'),
('4', '38', '2015-10-08', 'From Cash In Hand To Bank Of Ceylon'),
('4', '39', '2015-10-09', 'From Cash In Hand To Bank Of Ceylon'),
('4', '40', '2015-10-12', 'From Cash In Hand To Bank Of Ceylon'),
('4', '41', '2015-10-12', 'From Cash In Hand To Bank Of Ceylon'),
('4', '42', '2015-10-15', 'From Cash In Hand To Bank Of Ceylon'),
('4', '43', '2015-10-16', 'From Cash In Hand To Bank Of Ceylon'),
('4', '44', '2015-10-16', 'From Cash In Hand To Bank Of Ceylon'),
('4', '45', '2015-10-19', 'From Cash In Hand To Bank Of Ceylon'),
('4', '46', '2015-10-21', 'From Cash In Hand To Bank Of Ceylon'),
('4', '47', '2015-10-23', 'From Cash In Hand To Bank Of Ceylon'),
('4', '48', '2015-10-23', 'From Cash In Hand To Bank Of Ceylon'),
('4', '49', '2015-10-26', 'From Cash In Hand To Bank Of Ceylon'),
('4', '50', '2015-10-26', 'From Cash In Hand To Bank Of Ceylon'),
('4', '51', '2015-10-26', 'From Cash In Hand To Bank Of Ceylon'),
('4', '52', '2015-10-29', 'From Cash In Hand To Bank Of Ceylon'),
('4', '53', '2015-10-30', 'From Cash In Hand To Bank Of Ceylon'),
('4', '54', '2015-11-02', 'From Cash In Hand To Bank Of Ceylon'),
('4', '55', '2015-11-03', 'From Cash In Hand To Bank Of Ceylon'),
('4', '56', '2015-11-06', 'From Cash In Hand To Bank Of Ceylon'),
('4', '57', '2015-11-09', 'From Cash In Hand To Bank Of Ceylon'),
('4', '58', '2015-11-09', 'From Cash In Hand To Bank Of Ceylon'),
('4', '59', '2015-11-11', 'From Cash In Hand To Bank Of Ceylon'),
('4', '60', '2015-11-11', 'From Cash In Hand To Bank Of Ceylon'),
('4', '61', '2015-11-12', 'From Cash In Hand To Bank Of Ceylon'),
('4', '62', '2015-11-13', 'From Cash In Hand To Bank Of Ceylon'),
('4', '63', '2015-11-18', 'From Cash In Hand To Bank Of Ceylon'),
('4', '64', '2015-11-18', 'From Cash In Hand To Bank Of Ceylon'),
('4', '65', '2015-11-20', 'From Cash In Hand To Bank Of Ceylon'),
('4', '66', '2015-11-23', 'From Cash In Hand To Bank Of Ceylon'),
('4', '67', '2015-11-23', 'From Cash In Hand To Bank Of Ceylon'),
('4', '68', '2015-11-24', 'From Cash In Hand To Bank Of Ceylon'),
('4', '69', '2015-11-30', 'From Cash In Hand To Bank Of Ceylon'),
('4', '71', '2015-12-01', 'From Cash In Hand To Bank Of Ceylon'),
('4', '72', '2015-11-30', 'From Cash In Hand To Bank Of Ceylon'),
('4', '73', '2015-12-04', 'From Cash In Hand To Bank Of Ceylon'),
('4', '74', '2015-12-07', 'From Cash In Hand To Bank Of Ceylon'),
('4', '75', '2015-12-09', 'From Cash In Hand To Bank Of Ceylon'),
('4', '76', '2015-12-09', 'From Cash In Hand To Bank Of Ceylon'),
('4', '77', '2015-12-09', 'From Cash In Hand To Bank Of Ceylon'),
('4', '78', '2015-12-10', 'From Cash In Hand To Bank Of Ceylon'),
('4', '79', '2015-12-10', 'From Cash In Hand To Bank Of Ceylon'),
('4', '80', '2015-12-14', 'From Cash In Hand To Bank Of Ceylon'),
('4', '82', '2015-12-14', 'From Cash In Hand To Bank Of Ceylon'),
('4', '83', '2015-12-16', 'From Cash In Hand To Bank Of Ceylon'),
('4', '84', '2015-12-17', 'From Cash In Hand To Bank Of Ceylon'),
('4', '85', '2015-12-17', 'From Cash In Hand To Bank Of Ceylon'),
('4', '86', '2015-12-20', 'From Cash In Hand To Bank Of Ceylon'),
('4', '87', '2015-12-21', 'From Cash In Hand To Bank Of Ceylon'),
('4', '88', '2015-12-21', 'From Cash In Hand To Bank Of Ceylon'),
('4', '89', '2015-12-25', 'From Cash In Hand To Bank Of Ceylon'),
('4', '90', '2015-12-30', 'From Cash In Hand To Bank Of Ceylon'),
('4', '91', '2015-12-30', 'From Cash In Hand To Bank Of Ceylon'),
('4', '92', '2016-01-01', 'From Cash In Hand To Bank Of Ceylon'),
('4', '94', '2016-01-11', 'From Cash In Hand To Bank Of Celyon'),
('4', '95', '2016-01-19', 'From Cash In Hand To Bank Of Celyon'),
('4', '96', '2016-01-19', 'From Cash In Hand To Bank Of Celyon'),
('4', '97', '2016-01-22', 'From Cash In Hand To Bank Of Celyon'),
('4', '98', '2016-01-22', 'Fund transfer to golden Plam'),
('4', '99', '2016-01-22', 'From Cash In Hand To Bank Of Celyon'),
('4', '101', '2016-01-26', 'From Cash In Hand To Bank Of Celyon'),
('4', '102', '2016-01-25', 'From Cash In Hand To Bank Of Celyon'),
('4', '103', '2016-01-27', 'From Cash In Hand To Bank Of Celyon'),
('4', '104', '2016-02-01', 'From Cash In Hand To Bank Of Celyon'),
('4', '105', '2016-02-01', 'From Cash In Hand To Bank Of Celyon'),
('4', '106', '2016-02-03', 'Fund transfer to golden Plam'),
('4', '108', '2016-02-08', 'From Cash In Hand To Bank Of Celyon'),
('4', '109', '2016-02-09', 'From Cash In Hand To Bank Of Celyon'),
('4', '110', '2016-02-11', 'From Cash In Hand To Bank Of Celyon'),
('4', '112', '2016-02-08', 'From Cash In Hand To Bank Of Celyon'),
('4', '113', '2016-02-12', 'From Cash In Hand To Bank Of Celyon'),
('4', '114', '2016-02-15', 'From Cash In Hand To Bank Of Celyon'),
('4', '115', '2016-02-16', 'From Cash In Hand To Bank Of Celyon'),
('4', '116', '2016-02-17', 'From Cash In Hand To Bank Of Celyon'),
('4', '117', '2016-02-18', 'From Cash In Hand To Bank Of Celyon'),
('4', '119', '2016-02-23', 'From Cash In Hand To Bank Of Celyon'),
('4', '120', '2016-02-23', 'From Cash In Hand To Bank Of Celyon'),
('4', '121', '2016-02-25', 'From Cash In Hand To Bank Of Celyon'),
('4', '122', '2016-02-26', 'From Cash In Hand To Bank Of Celyon'),
('4', '123', '2016-02-26', 'From Cash In Hand To Bank Of Celyon'),
('4', '124', '2016-03-01', 'From Cash In Hand To Bank Of Celyon'),
('4', '125', '2016-03-02', 'From Cash In Hand To Bank Of Celyon'),
('4', '129', '2016-03-04', 'From Cash In Hand To Bank Of Celyon'),
('4', '130', '2016-03-03', 'From Cash In Hand To Bank Of Celyon'),
('4', '131', '2016-03-08', 'From Cash In Hand To Bank Of Celyon'),
('4', '132', '2016-03-31', 'From Cash In Hand To Bank Of Celyon'),
('4', '133', '2016-03-10', 'From Cash In Hand To Bank Of Celyon'),
('4', '134', '2016-03-11', 'From Cash In Hand To Bank Of Celyon'),
('4', '135', '2016-03-14', 'From Cash In Hand To Bank Of Celyon'),
('4', '136', '2016-03-16', 'From Cash In Hand To Bank Of Celyon'),
('4', '137', '2016-03-17', 'From Cash In Hand To Bank Of Celyon'),
('4', '138', '2016-03-21', 'From Cash In Hand To Bank Of Celyon'),
('4', '139', '2016-03-23', 'From Cash In Hand To Bank Of Celyon'),
('4', '140', '2016-03-28', 'From Cash In Hand To Bank Of Celyon'),
('4', '141', '2016-03-29', 'From Cash In Hand To Bank Of Celyon'),
('4', '142', '2016-03-29', 'From Cash In Hand To Bank Of Celyon'),
('4', '143', '2015-08-13', 'From Bank Of Celyon To Sampath Bank'),
('4', '144', '2015-08-24', 'Fund Transfer to golden plam'),
('4', '145', '2015-08-25', 'From Bank Of Celyon To Sampath Bank'),
('4', '146', '2015-08-28', 'From Bank Of Celyon To Sampath Bank'),
('4', '147', '2015-09-01', 'Food item purchase'),
('4', '148', '2015-09-02', 'Food item purchase'),
('4', '149', '2015-09-09', 'Fund Transfer to golden plam'),
('4', '151', '2015-09-25', 'From Bank Of Celyon To Sampath Bank'),
('4', '152', '2015-10-09', 'From Bank Of Celyon To Sampath Bank'),
('4', '153', '2015-10-12', 'Fund Transfer to golden plam'),
('4', '154', '2015-10-22', 'From Bank Of Celyon To Sampath Bank'),
('4', '156', '2015-11-12', 'From Bank Of Celyon To Sampath Bank'),
('4', '157', '2015-11-20', 'From Bank Of Celyon To Sampath Bank'),
('4', '158', '2015-12-01', 'From Bank Of Celyon To Sampath Bank'),
('4', '159', '2015-12-09', 'petty cash flot fillup'),
('4', '160', '2015-12-14', 'From Bank Of Celyon To Sampath Bank'),
('4', '161', '2015-12-18', 'From Bank Of Celyon To Sampath Bank'),
('4', '162', '2015-12-31', 'From Bank Of Celyon To Sampath Bank'),
('4', '163', '2016-01-19', 'From Bank Of Celyon To Sampath Bank'),
('4', '164', '2016-01-22', 'petty cash flot fillup'),
('4', '165', '2016-01-31', 'From Bank Of Celyon To Sampath Bank'),
('4', '166', '2016-02-05', 'From Bank Of Celyon To Sampath Bank'),
('4', '167', '2016-02-08', 'From Bank Of Cash in Hand To BOC'),
('4', '168', '2016-02-15', 'From Bank Of Celyon To Sampath Bank'),
('4', '169', '2016-02-16', 'petty cash flot ill up'),
('4', '170', '2016-02-25', 'From Bank Of Celyon To Sampath Bank'),
('4', '171', '2016-03-08', 'From Bank Of Celyon To Sampath Bank'),
('4', '172', '2016-03-17', 'From Bank Of Celyon To Sampath Bank'),
('4', '173', '2016-03-23', 'From Bank Of Celyon To Sampath Bank'),
('4', '174', '2016-03-29', 'From Bank Of Celyon To Sampath Bank'),
('4', '175', '2016-03-29', 'petty cash flot fillup'),
('4', '176', '2016-03-23', 'Equipment purchase'),
('4', '177', '2016-03-11', 'petty cash flot fillup'),
('4', '178', '2016-03-08', 'petty cash flot fillup'),
('4', '179', '2015-09-10', 'BOC to sampath'),
('4', '180', '2015-11-02', 'From Bank Of Celyon To Sampath Bank'),
('4', '181', '2016-01-08', 'From Cash In Hand To Bank Of Celyon'),
('4', '182', '2016-02-08', 'From BOC TO Cash In Hand '),
('4', '183', '2015-04-02', 'From Cash In Hand To Sampath Bank'),
('4', '184', '2015-04-02', 'From Cash In Hand To Sampath Bank'),
('4', '185', '2015-04-24', 'From Cash In Hand To Sampath Bank'),
('4', '186', '2015-04-30', 'From Cash In Hand To Sampath Bank'),
('4', '187', '2015-05-14', 'From Cash In Hand To Sampath Bank'),
('4', '188', '2015-05-22', 'From Cash In Hand To Sampath Bank'),
('4', '189', '2015-05-30', 'From Cash In Hand To Sampath Bank'),
('4', '190', '2015-05-31', 'From Cash In Hand To Sampath Bank'),
('4', '192', '2015-06-12', 'From Cash In Hand To Sampath Bank'),
('4', '193', '2015-06-18', 'From Cash In Hand To Sampath Bank'),
('4', '194', '2015-06-24', 'From Cash In Hand To Sampath Bank'),
('4', '195', '2015-06-29', 'From Cash In Hand To Sampath Bank'),
('4', '196', '2015-07-06', 'From Cash In Hand To Sampath Bank'),
('4', '197', '2015-07-14', 'From Cash In Hand To Sampath Bank'),
('4', '198', '2015-07-31', 'From Cash In Hand To Sampath Bank'),
('4', '199', '2015-08-28', 'From Cash In Hand To Sampath Bank'),
('4', '200', '2015-12-01', 'From Cash In Hand To Sampath Bank'),
('4', '201', '2015-12-17', 'From Cash In Hand To Sampath Bank'),
('4', '202', '2016-01-21', 'From Cash In Hand To Sampath Bank'),
('4', '203', '2016-01-22', 'From Cash In Hand To Sampath Bank'),
('12', '3', '2016-03-31', 'Cash invoice 3'),
('12', '4', '2016-03-31', 'Cash invoice 4'),
('12', '1', '2015-04-30', 'Cash invoice 1'),
('12', '2', '2015-04-30', 'Cash invoice 2'),
('12', '5', '2015-04-30', 'Cash invoice 5'),
('12', '6', '2015-05-31', 'Cash invoice 6'),
('12', '7', '2015-06-30', 'Cash invoice 7'),
('12', '8', '2015-07-03', 'Cash invoice 8'),
('12', '9', '2015-07-10', 'Cash invoice 9'),
('12', '10', '2015-07-17', 'Cash invoice 10'),
('12', '11', '2015-07-24', 'Cash invoice 11'),
('12', '12', '2015-07-31', 'Cash invoice 12'),
('12', '13', '2015-08-07', 'Cash invoice 13'),
('12', '14', '2015-08-14', 'Cash invoice 14'),
('12', '15', '2015-08-21', 'Cash invoice 15'),
('12', '16', '2015-08-28', 'Cash invoice 16'),
('12', '17', '2015-08-31', 'Cash invoice 17'),
('12', '18', '2015-09-04', 'Cash invoice 18'),
('12', '19', '2015-09-11', 'Cash invoice 19'),
('12', '20', '2015-09-18', 'Cash invoice 20'),
('12', '21', '2015-09-25', 'Cash invoice 21'),
('12', '22', '2015-09-30', 'Cash invoice 22'),
('12', '23', '2015-10-04', 'Cash invoice 23'),
('12', '24', '2015-10-09', 'Cash invoice 24'),
('12', '25', '2015-10-16', 'Cash invoice 25'),
('12', '26', '2015-10-23', 'Cash invoice 26'),
('12', '27', '2015-10-31', 'Cash invoice 27'),
('12', '28', '2015-11-06', 'Cash invoice 28'),
('12', '29', '2015-11-13', 'Cash invoice 29'),
('12', '30', '2015-11-20', 'Cash invoice 30'),
('12', '31', '2015-11-27', 'Cash invoice 31'),
('12', '32', '2015-11-30', 'Cash invoice 32'),
('12', '33', '2015-12-04', 'Cash invoice 33'),
('12', '34', '2015-12-11', 'Cash invoice 34'),
('12', '35', '2015-12-18', 'Cash invoice 35'),
('12', '36', '2015-12-25', 'Cash invoice 36'),
('12', '37', '2015-12-31', 'Cash invoice 37'),
('12', '38', '2016-01-01', 'Cash invoice 38'),
('12', '39', '2016-01-08', 'Cash invoice 39'),
('12', '40', '2016-01-15', 'Cash invoice 40'),
('12', '41', '2016-01-22', 'Cash invoice 41'),
('12', '42', '2016-01-29', 'Cash invoice 42'),
('12', '43', '2016-01-31', 'Cash invoice 43'),
('12', '44', '2016-02-05', 'Cash invoice 44'),
('12', '45', '2016-02-12', 'Cash invoice 45'),
('12', '46', '2016-02-19', 'Cash invoice 46'),
('12', '47', '2016-02-26', 'Cash invoice 47'),
('12', '48', '2016-02-29', 'Cash invoice 48'),
('12', '49', '2016-03-04', 'Cash invoice 49'),
('12', '50', '2016-03-11', 'Cash invoice 50'),
('12', '51', '2016-03-18', 'Cash invoice 51'),
('12', '52', '2016-03-25', 'Cash invoice 52'),
('12', '53', '2016-03-31', 'Cash invoice 53'),
('12', '54', '2016-01-15', 'Cash invoice 54'),
('12', '55', '2016-01-22', 'Cash invoice 55'),
('12', '56', '2016-01-29', 'Cash invoice 56'),
('12', '57', '2016-01-31', 'Cash invoice 57'),
('12', '58', '2016-02-05', 'Cash invoice 58'),
('12', '59', '2016-02-12', 'Cash invoice 59'),
('12', '60', '2016-02-19', 'Cash invoice 60'),
('12', '61', '2016-02-26', 'Cash invoice 61'),
('12', '62', '2016-02-29', 'Cash invoice 62'),
('12', '63', '2016-03-04', 'Cash invoice 63'),
('12', '64', '2016-03-11', 'Cash invoice 64'),
('12', '65', '2016-03-18', 'Cash invoice 65'),
('12', '66', '2016-03-25', 'Cash invoice 66'),
('12', '67', '2016-03-31', 'Cash invoice 67'),
('4', '204', '2015-06-09', 'Petty cash flote fillup'),
('4', '205', '2015-06-09', 'From Cash In Hand To Sampath Bank'),
('4', '206', '2015-06-29', 'From Cash In Hand To Sampath Bank'),
('4', '207', '2015-07-29', 'Cash Deposite'),
('4', '208', '2015-07-29', 'Error Correction'),
('4', '209', '2015-09-18', 'Petty cash flote fillup'),
('2', '46', '2015-09-28', ' 	EP');

### Structure of table `6_credit_status` ###

DROP TABLE IF EXISTS `6_credit_status`;

CREATE TABLE `6_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_credit_status` ###

INSERT INTO `6_credit_status` VALUES
('1', 'Good History', '0', '0'),
('3', 'No more work until payment received', '1', '0'),
('4', 'In liquidation', '1', '0');

### Structure of table `6_crm_categories` ###

DROP TABLE IF EXISTS `6_crm_categories`;

CREATE TABLE `6_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT 'contact type e.g. customer',
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT 'detailed usage e.g. department',
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL COMMENT 'for category selector',
  `description` tinytext COLLATE utf8_unicode_ci NOT NULL COMMENT 'usage description',
  `system` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_crm_categories` ###

INSERT INTO `6_crm_categories` VALUES
('1', 'cust_branch', 'general', 'General', 'General contact data for customer branch (overrides company setting)', '1', '0'),
('2', 'cust_branch', 'invoice', 'Invoices', 'Invoice posting (overrides company setting)', '1', '0'),
('3', 'cust_branch', 'order', 'Orders', 'Order confirmation (overrides company setting)', '1', '0'),
('4', 'cust_branch', 'delivery', 'Deliveries', 'Delivery coordination (overrides company setting)', '1', '0'),
('5', 'customer', 'general', 'General', 'General contact data for customer', '1', '0'),
('6', 'customer', 'order', 'Orders', 'Order confirmation', '1', '0'),
('7', 'customer', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('8', 'customer', 'invoice', 'Invoices', 'Invoice posting', '1', '0'),
('9', 'supplier', 'general', 'General', 'General contact data for supplier', '1', '0'),
('10', 'supplier', 'order', 'Orders', 'Order confirmation', '1', '0'),
('11', 'supplier', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('12', 'supplier', 'invoice', 'Invoices', 'Invoice posting', '1', '0');

### Structure of table `6_crm_contacts` ###

DROP TABLE IF EXISTS `6_crm_contacts`;

CREATE TABLE `6_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT '0' COMMENT 'foreign key to crm_contacts',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT 'foreign key to crm_categories',
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT 'foreign key to crm_categories',
  `entity_id` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'entity id in related class table',
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_crm_contacts` ###

INSERT INTO `6_crm_contacts` VALUES
('4', '2', 'supplier', 'general', '2'),
('8', '1', 'supplier', 'general', '1'),
('11', '5', 'cust_branch', 'general', '3'),
('12', '5', 'customer', 'general', '3'),
('13', '6', 'cust_branch', 'general', '4'),
('14', '6', 'customer', 'general', '4'),
('15', '7', 'cust_branch', 'general', '5'),
('16', '7', 'customer', 'general', '5');

### Structure of table `6_crm_persons` ###

DROP TABLE IF EXISTS `6_crm_persons`;

CREATE TABLE `6_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `name2` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` tinytext COLLATE utf8_unicode_ci,
  `phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone2` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lang` char(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_crm_persons` ###

INSERT INTO `6_crm_persons` VALUES
('1', 'Dino Saurius', 'John Doe', NULL, 'N/A', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2', 'Beefeater', 'Joe Oversea', NULL, 'N/A', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3', 'Donald Easter', 'Donald Easter LLC', NULL, 'N/A', NULL, NULL, NULL, NULL, NULL, '', '0'),
('4', 'MoneyMaker', 'MoneyMaker Ltd.', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('5', 'Cash', 'Cash', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('6', 'Cash-outlet', 'Cash-outlet', NULL, 'Colombo', NULL, NULL, NULL, NULL, NULL, '', '0'),
('7', 'TVP', 'Tuder V Perera &amp; Co', NULL, 'No -103,Chatham Street,Colombo 01', NULL, NULL, NULL, NULL, NULL, '', '0');

### Structure of table `6_currencies` ###

DROP TABLE IF EXISTS `6_currencies`;

CREATE TABLE `6_currencies` (
  `currency` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `auto_update` tinyint(1) NOT NULL DEFAULT '1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_currencies` ###

INSERT INTO `6_currencies` VALUES
('Sri Lanka Rupee', 'LKR', 'Rs', 'Sri Lanka', 'Cents', '1', '0');

### Structure of table `6_cust_allocations` ###

DROP TABLE IF EXISTS `6_cust_allocations`;

CREATE TABLE `6_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trans_type_from` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_cust_allocations` ###

INSERT INTO `6_cust_allocations` VALUES
('5', '3', '272659', '2015-04-30', '5', '12', '5', '10'),
('6', '3', '303185', '2015-05-31', '6', '12', '6', '10'),
('7', '3', '322814', '2015-06-30', '7', '12', '7', '10'),
('8', '3', '26905', '2015-07-03', '8', '12', '8', '10'),
('9', '3', '62453', '2015-07-10', '9', '12', '9', '10'),
('10', '3', '62364', '2015-07-17', '10', '12', '10', '10'),
('11', '3', '61302', '2015-07-24', '11', '12', '11', '10'),
('12', '3', '79320', '2015-07-31', '12', '12', '12', '10'),
('13', '3', '72048', '2015-08-07', '13', '12', '13', '10'),
('14', '3', '74651', '2015-08-14', '14', '12', '14', '10'),
('15', '3', '67860', '2015-08-21', '15', '12', '15', '10'),
('16', '3', '80505', '2015-08-28', '16', '12', '16', '10'),
('17', '3', '48025', '2015-08-31', '17', '12', '17', '10'),
('18', '3', '48607', '2015-09-04', '18', '12', '18', '10'),
('19', '3', '74533', '2015-09-11', '19', '12', '19', '10'),
('20', '3', '79045', '2015-09-18', '20', '12', '20', '10'),
('21', '3', '86405', '2015-09-25', '21', '12', '21', '10'),
('22', '3', '60248', '2015-09-30', '22', '12', '22', '10'),
('23', '3', '23010', '2015-10-04', '23', '12', '23', '10'),
('24', '3', '91729', '2015-10-09', '24', '12', '24', '10'),
('25', '3', '63100', '2015-10-16', '25', '12', '25', '10'),
('26', '3', '76586', '2015-10-23', '26', '12', '26', '10'),
('27', '3', '73678', '2015-10-31', '27', '12', '27', '10'),
('28', '3', '50375', '2015-11-06', '28', '12', '28', '10'),
('29', '3', '65880', '2015-11-13', '29', '12', '29', '10'),
('30', '3', '68189', '2015-11-20', '30', '12', '30', '10'),
('31', '3', '89000', '2015-11-27', '31', '12', '31', '10'),
('32', '3', '40958', '2015-11-30', '32', '12', '32', '10'),
('33', '3', '53924', '2015-12-04', '33', '12', '33', '10'),
('34', '3', '82963', '2015-12-11', '34', '12', '34', '10'),
('35', '3', '71768', '2015-12-18', '35', '12', '35', '10'),
('36', '3', '120771', '2015-12-25', '36', '12', '36', '10'),
('37', '3', '89350', '2015-12-31', '37', '12', '37', '10'),
('38', '3', '9835', '2016-01-01', '38', '12', '38', '10'),
('39', '3', '64306', '2016-01-08', '39', '12', '39', '10'),
('40', '3', '95720', '2016-01-15', '40', '12', '40', '10'),
('41', '3', '62295', '2016-01-22', '41', '12', '41', '10'),
('42', '3', '113045', '2016-01-29', '42', '12', '42', '10'),
('43', '3', '47945', '2016-01-31', '43', '12', '43', '10'),
('44', '3', '64565', '2016-02-05', '44', '12', '44', '10'),
('45', '3', '103935', '2016-02-12', '45', '12', '45', '10'),
('46', '3', '97114', '2016-02-19', '46', '12', '46', '10'),
('47', '3', '110807', '2016-02-26', '47', '12', '47', '10'),
('48', '3', '46100', '2016-02-29', '48', '12', '48', '10'),
('49', '3', '46887', '2016-03-04', '49', '12', '49', '10'),
('50', '3', '107384', '2016-03-11', '50', '12', '50', '10'),
('51', '3', '111432', '2016-03-18', '51', '12', '51', '10'),
('52', '3', '92910', '2016-03-25', '52', '12', '52', '10'),
('53', '3', '74215', '2016-03-31', '53', '12', '53', '10'),
('54', '4', '12635', '2016-01-15', '54', '12', '54', '10'),
('55', '4', '10430', '2016-01-22', '55', '12', '55', '10'),
('56', '4', '6745', '2016-01-29', '56', '12', '56', '10'),
('57', '4', '2310', '2016-01-31', '57', '12', '57', '10'),
('58', '4', '5110', '2016-02-05', '58', '12', '58', '10'),
('59', '4', '12205', '2016-02-12', '59', '12', '59', '10'),
('60', '4', '10485', '2016-02-19', '60', '12', '60', '10'),
('61', '4', '17820', '2016-02-26', '61', '12', '61', '10'),
('62', '4', '5565', '2016-02-29', '62', '12', '62', '10'),
('63', '4', '6750', '2016-03-04', '63', '12', '63', '10'),
('64', '4', '10790', '2016-03-11', '64', '12', '64', '10'),
('65', '4', '13605', '2016-03-18', '65', '12', '65', '10'),
('66', '4', '11435', '2016-03-25', '66', '12', '66', '10'),
('67', '4', '6445', '2016-03-31', '67', '12', '67', '10');

### Structure of table `6_cust_branch` ###

DROP TABLE IF EXISTS `6_cust_branch`;

CREATE TABLE `6_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `br_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `branch_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `br_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT '0',
  `default_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `receivables_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT '1',
  `br_post_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT '0',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `bank_account` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_cust_branch` ###

INSERT INTO `6_cust_branch` VALUES
('3', '3', 'Cash', 'Cash', 'Colombo', '2', '2', 'LOC1', '2', '', '4100', '0250', '4100', '1', 'Colombo', '0', '', NULL, '0'),
('4', '4', 'Cash-outlet', 'Cash-outlet', 'Colombo', '2', '2', 'LOC1', '2', '', '0001', '0250', '0001', '1', 'Colombo', '0', '', NULL, '0'),
('5', '5', 'Tuder V Perera &amp; Co', 'TVP', 'No -103,Chatham Street,Colombo 01', '2', '2', 'LOC1', '2', '', '0001', '0250', '0001', '1', 'No -103,Chatham Street,Colombo 01', '0', '', NULL, '0');

### Structure of table `6_debtor_trans` ###

DROP TABLE IF EXISTS `6_debtor_trans`;

CREATE TABLE `6_debtor_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `version` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `debtor_no` int(11) unsigned DEFAULT NULL,
  `branch_code` int(11) NOT NULL DEFAULT '-1',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT '0',
  `order_` int(11) NOT NULL DEFAULT '0',
  `ov_amount` double NOT NULL DEFAULT '0',
  `ov_gst` double NOT NULL DEFAULT '0',
  `ov_freight` double NOT NULL DEFAULT '0',
  `ov_freight_tax` double NOT NULL DEFAULT '0',
  `ov_discount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  `ship_via` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`type`,`trans_no`),
  KEY `debtor_no` (`debtor_no`,`branch_code`),
  KEY `tran_date` (`tran_date`),
  KEY `order_` (`order_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_debtor_trans` ###

INSERT INTO `6_debtor_trans` VALUES
('1', '10', '2', '3', '3', '2015-04-30', '2016-03-31', '001/2015', '1', '1', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('2', '10', '2', '3', '3', '2015-04-30', '2016-03-31', '001/2015', '1', '2', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('3', '10', '2', '3', '3', '2016-03-31', '2016-03-31', '001/2016', '1', '3', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('4', '10', '2', '3', '3', '2016-03-31', '2016-03-31', '002/2016', '1', '4', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('5', '10', '0', '3', '3', '2015-04-30', '2015-04-30', '001/2015', '1', '5', '272659', '0', '0', '0', '0', '272659', '272659', '1', '1', '0', '0', '4', '1'),
('6', '10', '0', '3', '3', '2015-05-31', '2016-03-31', '002/2015', '1', '6', '303185', '0', '0', '0', '0', '303185', '0', '1', '1', '0', '0', '4', '1'),
('7', '10', '0', '3', '3', '2015-06-30', '2016-03-31', '003/2015', '1', '7', '322814', '0', '0', '0', '0', '322814', '0', '1', '1', '0', '0', '4', '1'),
('8', '10', '0', '3', '3', '2015-07-03', '2016-03-31', '004/2015', '1', '8', '26905', '0', '0', '0', '0', '26905', '0', '1', '1', '0', '0', '4', '1'),
('9', '10', '0', '3', '3', '2015-07-10', '2016-03-31', '005/2015', '1', '9', '62453', '0', '0', '0', '0', '62453', '0', '1', '1', '0', '0', '4', '1'),
('10', '10', '0', '3', '3', '2015-07-17', '2016-03-31', '006/2015', '1', '10', '62364', '0', '0', '0', '0', '62364', '0', '1', '1', '0', '0', '4', '1'),
('11', '10', '0', '3', '3', '2015-07-24', '2016-03-31', '007/2015', '1', '11', '61302', '0', '0', '0', '0', '61302', '0', '1', '1', '0', '0', '4', '1'),
('12', '10', '0', '3', '3', '2015-07-31', '2016-03-31', '008/2015', '1', '12', '79320', '0', '0', '0', '0', '79320', '0', '1', '1', '0', '0', '4', '1'),
('13', '10', '0', '3', '3', '2015-08-07', '2016-03-31', '009/2015', '1', '13', '72048', '0', '0', '0', '0', '72048', '0', '1', '1', '0', '0', '4', '1'),
('14', '10', '0', '3', '3', '2015-08-14', '2016-03-31', '010/2015', '1', '14', '74651', '0', '0', '0', '0', '74651', '0', '1', '1', '0', '0', '4', '1'),
('15', '10', '0', '3', '3', '2015-08-21', '2016-03-31', '011/2015', '1', '15', '67860', '0', '0', '0', '0', '67860', '0', '1', '1', '0', '0', '4', '1'),
('16', '10', '0', '3', '3', '2015-08-28', '2016-03-31', '012/2015', '1', '16', '80505', '0', '0', '0', '0', '80505', '0', '1', '1', '0', '0', '4', '1'),
('17', '10', '0', '3', '3', '2015-08-31', '2016-03-31', '013/2015', '1', '17', '48025', '0', '0', '0', '0', '48025', '0', '1', '1', '0', '0', '4', '1'),
('18', '10', '0', '3', '3', '2015-09-04', '2016-03-31', '014/2015', '1', '18', '48607', '0', '0', '0', '0', '48607', '0', '1', '1', '0', '0', '4', '1'),
('19', '10', '0', '3', '3', '2015-09-11', '2016-03-31', '015/2015', '1', '19', '74533', '0', '0', '0', '0', '74533', '0', '1', '1', '0', '0', '4', '1'),
('20', '10', '0', '3', '3', '2015-09-18', '2016-03-31', '016/2015', '1', '20', '79045', '0', '0', '0', '0', '79045', '0', '1', '1', '0', '0', '4', '1'),
('21', '10', '0', '3', '3', '2015-09-25', '2016-03-31', '017/2015', '1', '21', '86405', '0', '0', '0', '0', '86405', '0', '1', '1', '0', '0', '4', '1'),
('22', '10', '0', '3', '3', '2015-09-30', '2016-03-31', '018/2015', '1', '22', '60248', '0', '0', '0', '0', '60248', '0', '1', '1', '0', '0', '4', '1'),
('23', '10', '0', '3', '3', '2015-10-04', '2016-03-31', '019/2015', '1', '23', '23010', '0', '0', '0', '0', '23010', '0', '1', '1', '0', '0', '4', '1'),
('24', '10', '0', '3', '3', '2015-10-09', '2016-03-31', '020/2015', '1', '24', '91729', '0', '0', '0', '0', '91729', '0', '1', '1', '0', '0', '4', '1'),
('25', '10', '0', '3', '3', '2015-10-16', '2016-03-31', '021/2015', '1', '25', '63100', '0', '0', '0', '0', '63100', '0', '1', '1', '0', '0', '4', '1'),
('26', '10', '0', '3', '3', '2015-10-23', '2016-03-31', '022/2015', '1', '26', '76586', '0', '0', '0', '0', '76586', '0', '1', '1', '0', '0', '4', '1'),
('27', '10', '0', '3', '3', '2015-10-31', '2016-03-31', '023/2015', '1', '27', '73678', '0', '0', '0', '0', '73678', '0', '1', '1', '0', '0', '4', '1'),
('28', '10', '0', '3', '3', '2015-11-06', '2016-03-31', '024/2015', '1', '28', '50375', '0', '0', '0', '0', '50375', '0', '1', '1', '0', '0', '4', '1'),
('29', '10', '0', '3', '3', '2015-11-13', '2016-03-31', '025/2015', '1', '29', '65880', '0', '0', '0', '0', '65880', '0', '1', '1', '0', '0', '4', '1'),
('30', '10', '0', '3', '3', '2015-11-20', '2016-03-31', '026/2015', '1', '30', '68189', '0', '0', '0', '0', '68189', '0', '1', '1', '0', '0', '4', '1'),
('31', '10', '0', '3', '3', '2015-11-27', '2016-03-31', '027/2015', '1', '31', '89000', '0', '0', '0', '0', '89000', '0', '1', '1', '0', '0', '4', '1'),
('32', '10', '0', '3', '3', '2015-11-30', '2016-03-31', '028/2015', '1', '32', '40958', '0', '0', '0', '0', '40958', '0', '1', '1', '0', '0', '4', '1'),
('33', '10', '0', '3', '3', '2015-12-04', '2016-03-31', '029/2015', '1', '33', '53924', '0', '0', '0', '0', '53924', '0', '1', '1', '0', '0', '4', '1'),
('34', '10', '0', '3', '3', '2015-12-11', '2016-03-31', '030/2015', '1', '34', '82963', '0', '0', '0', '0', '82963', '0', '1', '1', '0', '0', '4', '1'),
('35', '10', '0', '3', '3', '2015-12-18', '2016-03-31', '031/2015', '1', '35', '71768', '0', '0', '0', '0', '71768', '0', '1', '1', '0', '0', '4', '1'),
('36', '10', '0', '3', '3', '2015-12-25', '2016-03-31', '032/2015', '1', '36', '120771', '0', '0', '0', '0', '120771', '0', '1', '1', '0', '0', '4', '1'),
('37', '10', '0', '3', '3', '2015-12-31', '2016-03-31', '033/2015', '1', '37', '89350', '0', '0', '0', '0', '89350', '0', '1', '1', '0', '0', '4', '1'),
('38', '10', '0', '3', '3', '2016-01-01', '2016-03-31', '003/2016', '1', '38', '9835', '0', '0', '0', '0', '9835', '0', '1', '1', '0', '0', '4', '1'),
('39', '10', '0', '3', '3', '2016-01-08', '2016-03-31', '004/2016', '1', '39', '64306', '0', '0', '0', '0', '64306', '0', '1', '1', '0', '0', '4', '1'),
('40', '10', '0', '3', '3', '2016-01-15', '2016-03-31', '005/2016', '1', '40', '95720', '0', '0', '0', '0', '95720', '0', '1', '1', '0', '0', '4', '1'),
('41', '10', '0', '3', '3', '2016-01-22', '2016-03-31', '006/2016', '1', '41', '62295', '0', '0', '0', '0', '62295', '0', '1', '1', '0', '0', '4', '1'),
('42', '10', '0', '3', '3', '2016-01-29', '2016-03-31', '007/2016', '1', '42', '113045', '0', '0', '0', '0', '113045', '0', '1', '1', '0', '0', '4', '1'),
('43', '10', '0', '3', '3', '2016-01-31', '2016-03-31', '008/2016', '1', '43', '47945', '0', '0', '0', '0', '47945', '0', '1', '1', '0', '0', '4', '1'),
('44', '10', '0', '3', '3', '2016-02-05', '2016-03-31', '009/2016', '1', '44', '64565', '0', '0', '0', '0', '64565', '0', '1', '1', '0', '0', '4', '1'),
('45', '10', '0', '3', '3', '2016-02-12', '2016-03-31', '010/2016', '1', '45', '103935', '0', '0', '0', '0', '103935', '0', '1', '1', '0', '0', '4', '1'),
('46', '10', '0', '3', '3', '2016-02-19', '2016-03-31', '011/2016', '1', '46', '97114', '0', '0', '0', '0', '97114', '0', '1', '1', '0', '0', '4', '1'),
('47', '10', '0', '3', '3', '2016-02-26', '2016-03-31', '012/2016', '1', '47', '110807', '0', '0', '0', '0', '110807', '0', '1', '1', '0', '0', '4', '1'),
('48', '10', '0', '3', '3', '2016-02-29', '2016-03-31', '013/2016', '1', '48', '46100', '0', '0', '0', '0', '46100', '0', '1', '1', '0', '0', '4', '1'),
('49', '10', '0', '3', '3', '2016-03-04', '2016-03-31', '014/2016', '1', '49', '46887', '0', '0', '0', '0', '46887', '0', '1', '1', '0', '0', '4', '1'),
('50', '10', '0', '3', '3', '2016-03-11', '2016-03-31', '015/2016', '1', '50', '107384', '0', '0', '0', '0', '107384', '0', '1', '1', '0', '0', '4', '1'),
('51', '10', '0', '3', '3', '2016-03-18', '2016-03-31', '016/2016', '1', '51', '111432', '0', '0', '0', '0', '111432', '0', '1', '1', '0', '0', '4', '1'),
('52', '10', '0', '3', '3', '2016-03-25', '2016-03-31', '017/2016', '1', '52', '92910', '0', '0', '0', '0', '92910', '0', '1', '1', '0', '0', '4', '1'),
('53', '10', '0', '3', '3', '2016-03-31', '2016-03-31', '018/2016', '1', '53', '74215', '0', '0', '0', '0', '74215', '0', '1', '1', '0', '0', '4', '1'),
('54', '10', '0', '4', '4', '2016-01-15', '2016-03-31', '019/2016', '1', '54', '12635', '0', '0', '0', '0', '12635', '0', '1', '1', '0', '0', '4', '1'),
('55', '10', '0', '4', '4', '2016-01-22', '2016-03-31', '020/2016', '1', '55', '10430', '0', '0', '0', '0', '10430', '0', '1', '1', '0', '0', '4', '1'),
('56', '10', '0', '4', '4', '2016-01-29', '2016-03-31', '021/2016', '1', '56', '6745', '0', '0', '0', '0', '6745', '0', '1', '1', '0', '0', '4', '1'),
('57', '10', '0', '4', '4', '2016-01-31', '2016-03-31', '022/2016', '1', '57', '2310', '0', '0', '0', '0', '2310', '0', '1', '1', '0', '0', '4', '1'),
('58', '10', '0', '4', '4', '2016-02-05', '2016-03-31', '023/2016', '1', '58', '5110', '0', '0', '0', '0', '5110', '0', '1', '1', '0', '0', '4', '1'),
('59', '10', '0', '4', '4', '2016-02-12', '2016-03-31', '024/2016', '1', '59', '12205', '0', '0', '0', '0', '12205', '0', '1', '1', '0', '0', '4', '1'),
('60', '10', '0', '4', '4', '2016-02-19', '2016-03-31', '025/2016', '1', '60', '10485', '0', '0', '0', '0', '10485', '0', '1', '1', '0', '0', '4', '1'),
('61', '10', '0', '4', '4', '2016-02-26', '2016-03-31', '026/2016', '1', '61', '17820', '0', '0', '0', '0', '17820', '0', '1', '1', '0', '0', '4', '1'),
('62', '10', '0', '4', '4', '2016-02-29', '2016-03-31', '027/2016', '1', '62', '5565', '0', '0', '0', '0', '5565', '0', '1', '1', '0', '0', '4', '1'),
('63', '10', '0', '4', '4', '2016-03-04', '2016-03-31', '028/2016', '1', '63', '6750', '0', '0', '0', '0', '6750', '0', '1', '1', '0', '0', '4', '1'),
('64', '10', '0', '4', '4', '2016-03-11', '2016-03-31', '029/2016', '1', '64', '10790', '0', '0', '0', '0', '10790', '0', '1', '1', '0', '0', '4', '1'),
('65', '10', '0', '4', '4', '2016-03-18', '2016-03-31', '030/2016', '1', '65', '13605', '0', '0', '0', '0', '13605', '0', '1', '1', '0', '0', '4', '1'),
('66', '10', '0', '4', '4', '2016-03-25', '2016-03-31', '031/2016', '1', '66', '11435', '0', '0', '0', '0', '11435', '0', '1', '1', '0', '0', '4', '1'),
('67', '10', '0', '4', '4', '2016-03-31', '2016-03-31', '032/2016', '1', '67', '6445', '0', '0', '0', '0', '6445', '0', '1', '1', '0', '0', '4', '1'),
('1', '12', '1', '3', '3', '2015-04-30', '0000-00-00', '004/2016', '0', '0', '1', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', NULL, '0'),
('2', '12', '2', '3', '3', '2015-04-30', '0000-00-00', '005/2016', '0', '0', '1', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', NULL, '0'),
('3', '12', '2', '3', '3', '2016-03-31', '0000-00-00', '002/2016', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', NULL, '0'),
('4', '12', '2', '3', '3', '2016-03-31', '0000-00-00', '003/2016', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', NULL, '0'),
('5', '12', '0', '3', '3', '2015-04-30', '0000-00-00', '001/2015', '0', '0', '272659', '0', '0', '0', '0', '272659', '0', '1', '0', '0', '0', NULL, '0'),
('6', '12', '0', '3', '3', '2015-05-31', '0000-00-00', '002/2015', '0', '0', '303185', '0', '0', '0', '0', '303185', '0', '1', '0', '0', '0', NULL, '0'),
('7', '12', '0', '3', '3', '2015-06-30', '0000-00-00', '003/2015', '0', '0', '322814', '0', '0', '0', '0', '322814', '0', '1', '0', '0', '0', NULL, '0'),
('8', '12', '0', '3', '3', '2015-07-03', '0000-00-00', '004/2015', '0', '0', '26905', '0', '0', '0', '0', '26905', '0', '1', '0', '0', '0', NULL, '0'),
('9', '12', '0', '3', '3', '2015-07-10', '0000-00-00', '005/2015', '0', '0', '62453', '0', '0', '0', '0', '62453', '0', '1', '0', '0', '0', NULL, '0'),
('10', '12', '0', '3', '3', '2015-07-17', '0000-00-00', '006/2015', '0', '0', '62364', '0', '0', '0', '0', '62364', '0', '1', '0', '0', '0', NULL, '0'),
('11', '12', '0', '3', '3', '2015-07-24', '0000-00-00', '007/2015', '0', '0', '61302', '0', '0', '0', '0', '61302', '0', '1', '0', '0', '0', NULL, '0'),
('12', '12', '0', '3', '3', '2015-07-31', '0000-00-00', '008/2015', '0', '0', '79320', '0', '0', '0', '0', '79320', '0', '1', '0', '0', '0', NULL, '0'),
('13', '12', '0', '3', '3', '2015-08-07', '0000-00-00', '009/2015', '0', '0', '72048', '0', '0', '0', '0', '72048', '0', '1', '0', '0', '0', NULL, '0'),
('14', '12', '0', '3', '3', '2015-08-14', '0000-00-00', '010/2015', '0', '0', '74651', '0', '0', '0', '0', '74651', '0', '1', '0', '0', '0', NULL, '0'),
('15', '12', '0', '3', '3', '2015-08-21', '0000-00-00', '011/2015', '0', '0', '67860', '0', '0', '0', '0', '67860', '0', '1', '0', '0', '0', NULL, '0'),
('16', '12', '0', '3', '3', '2015-08-28', '0000-00-00', '012/2015', '0', '0', '80505', '0', '0', '0', '0', '80505', '0', '1', '0', '0', '0', NULL, '0'),
('17', '12', '0', '3', '3', '2015-08-31', '0000-00-00', '013/2015', '0', '0', '48025', '0', '0', '0', '0', '48025', '0', '1', '0', '0', '0', NULL, '0'),
('18', '12', '0', '3', '3', '2015-09-04', '0000-00-00', '014/2015', '0', '0', '48607', '0', '0', '0', '0', '48607', '0', '1', '0', '0', '0', NULL, '0'),
('19', '12', '0', '3', '3', '2015-09-11', '0000-00-00', '015/2015', '0', '0', '74533', '0', '0', '0', '0', '74533', '0', '1', '0', '0', '0', NULL, '0'),
('20', '12', '0', '3', '3', '2015-09-18', '0000-00-00', '016/2015', '0', '0', '79045', '0', '0', '0', '0', '79045', '0', '1', '0', '0', '0', NULL, '0'),
('21', '12', '0', '3', '3', '2015-09-25', '0000-00-00', '017/2015', '0', '0', '86405', '0', '0', '0', '0', '86405', '0', '1', '0', '0', '0', NULL, '0'),
('22', '12', '0', '3', '3', '2015-09-30', '0000-00-00', '018/2015', '0', '0', '60248', '0', '0', '0', '0', '60248', '0', '1', '0', '0', '0', NULL, '0'),
('23', '12', '0', '3', '3', '2015-10-04', '0000-00-00', '019/2015', '0', '0', '23010', '0', '0', '0', '0', '23010', '0', '1', '0', '0', '0', NULL, '0'),
('24', '12', '0', '3', '3', '2015-10-09', '0000-00-00', '020/2015', '0', '0', '91729', '0', '0', '0', '0', '91729', '0', '1', '0', '0', '0', NULL, '0'),
('25', '12', '0', '3', '3', '2015-10-16', '0000-00-00', '021/2015', '0', '0', '63100', '0', '0', '0', '0', '63100', '0', '1', '0', '0', '0', NULL, '0'),
('26', '12', '0', '3', '3', '2015-10-23', '0000-00-00', '022/2015', '0', '0', '76586', '0', '0', '0', '0', '76586', '0', '1', '0', '0', '0', NULL, '0'),
('27', '12', '0', '3', '3', '2015-10-31', '0000-00-00', '023/2015', '0', '0', '73678', '0', '0', '0', '0', '73678', '0', '1', '0', '0', '0', NULL, '0'),
('28', '12', '0', '3', '3', '2015-11-06', '0000-00-00', '024/2015', '0', '0', '50375', '0', '0', '0', '0', '50375', '0', '1', '0', '0', '0', NULL, '0'),
('29', '12', '0', '3', '3', '2015-11-13', '0000-00-00', '025/2015', '0', '0', '65880', '0', '0', '0', '0', '65880', '0', '1', '0', '0', '0', NULL, '0'),
('30', '12', '0', '3', '3', '2015-11-20', '0000-00-00', '026/2015', '0', '0', '68189', '0', '0', '0', '0', '68189', '0', '1', '0', '0', '0', NULL, '0'),
('31', '12', '0', '3', '3', '2015-11-27', '0000-00-00', '027/2015', '0', '0', '89000', '0', '0', '0', '0', '89000', '0', '1', '0', '0', '0', NULL, '0'),
('32', '12', '0', '3', '3', '2015-11-30', '0000-00-00', '028/2015', '0', '0', '40958', '0', '0', '0', '0', '40958', '0', '1', '0', '0', '0', NULL, '0'),
('33', '12', '0', '3', '3', '2015-12-04', '0000-00-00', '029/2015', '0', '0', '53924', '0', '0', '0', '0', '53924', '0', '1', '0', '0', '0', NULL, '0'),
('34', '12', '0', '3', '3', '2015-12-11', '0000-00-00', '030/2015', '0', '0', '82963', '0', '0', '0', '0', '82963', '0', '1', '0', '0', '0', NULL, '0'),
('35', '12', '0', '3', '3', '2015-12-18', '0000-00-00', '031/2015', '0', '0', '71768', '0', '0', '0', '0', '71768', '0', '1', '0', '0', '0', NULL, '0'),
('36', '12', '0', '3', '3', '2015-12-25', '0000-00-00', '032/2015', '0', '0', '120771', '0', '0', '0', '0', '120771', '0', '1', '0', '0', '0', NULL, '0'),
('37', '12', '0', '3', '3', '2015-12-31', '0000-00-00', '033/2015', '0', '0', '89350', '0', '0', '0', '0', '89350', '0', '1', '0', '0', '0', NULL, '0'),
('38', '12', '0', '3', '3', '2016-01-01', '0000-00-00', '006/2016', '0', '0', '9835', '0', '0', '0', '0', '9835', '0', '1', '0', '0', '0', NULL, '0'),
('39', '12', '0', '3', '3', '2016-01-08', '0000-00-00', '007/2016', '0', '0', '64306', '0', '0', '0', '0', '64306', '0', '1', '0', '0', '0', NULL, '0'),
('40', '12', '0', '3', '3', '2016-01-15', '0000-00-00', '008/2016', '0', '0', '95720', '0', '0', '0', '0', '95720', '0', '1', '0', '0', '0', NULL, '0'),
('41', '12', '0', '3', '3', '2016-01-22', '0000-00-00', '009/2016', '0', '0', '62295', '0', '0', '0', '0', '62295', '0', '1', '0', '0', '0', NULL, '0'),
('42', '12', '0', '3', '3', '2016-01-29', '0000-00-00', '010/2016', '0', '0', '113045', '0', '0', '0', '0', '113045', '0', '1', '0', '0', '0', NULL, '0'),
('43', '12', '0', '3', '3', '2016-01-31', '0000-00-00', '011/2016', '0', '0', '47945', '0', '0', '0', '0', '47945', '0', '1', '0', '0', '0', NULL, '0'),
('44', '12', '0', '3', '3', '2016-02-05', '0000-00-00', '012/2016', '0', '0', '64565', '0', '0', '0', '0', '64565', '0', '1', '0', '0', '0', NULL, '0'),
('45', '12', '0', '3', '3', '2016-02-12', '0000-00-00', '013/2016', '0', '0', '103935', '0', '0', '0', '0', '103935', '0', '1', '0', '0', '0', NULL, '0'),
('46', '12', '0', '3', '3', '2016-02-19', '0000-00-00', '014/2016', '0', '0', '97114', '0', '0', '0', '0', '97114', '0', '1', '0', '0', '0', NULL, '0'),
('47', '12', '0', '3', '3', '2016-02-26', '0000-00-00', '015/2016', '0', '0', '110807', '0', '0', '0', '0', '110807', '0', '1', '0', '0', '0', NULL, '0'),
('48', '12', '0', '3', '3', '2016-02-29', '0000-00-00', '016/2016', '0', '0', '46100', '0', '0', '0', '0', '46100', '0', '1', '0', '0', '0', NULL, '0'),
('49', '12', '0', '3', '3', '2016-03-04', '0000-00-00', '017/2016', '0', '0', '46887', '0', '0', '0', '0', '46887', '0', '1', '0', '0', '0', NULL, '0'),
('50', '12', '0', '3', '3', '2016-03-11', '0000-00-00', '018/2016', '0', '0', '107384', '0', '0', '0', '0', '107384', '0', '1', '0', '0', '0', NULL, '0'),
('51', '12', '0', '3', '3', '2016-03-18', '0000-00-00', '019/2016', '0', '0', '111432', '0', '0', '0', '0', '111432', '0', '1', '0', '0', '0', NULL, '0'),
('52', '12', '0', '3', '3', '2016-03-25', '0000-00-00', '020/2016', '0', '0', '92910', '0', '0', '0', '0', '92910', '0', '1', '0', '0', '0', NULL, '0'),
('53', '12', '0', '3', '3', '2016-03-31', '0000-00-00', '021/2016', '0', '0', '74215', '0', '0', '0', '0', '74215', '0', '1', '0', '0', '0', NULL, '0'),
('54', '12', '0', '4', '4', '2016-01-15', '0000-00-00', '022/2016', '0', '0', '12635', '0', '0', '0', '0', '12635', '0', '1', '0', '0', '0', NULL, '0'),
('55', '12', '0', '4', '4', '2016-01-22', '0000-00-00', '023/2016', '0', '0', '10430', '0', '0', '0', '0', '10430', '0', '1', '0', '0', '0', NULL, '0'),
('56', '12', '0', '4', '4', '2016-01-29', '0000-00-00', '024/2016', '0', '0', '6745', '0', '0', '0', '0', '6745', '0', '1', '0', '0', '0', NULL, '0'),
('57', '12', '0', '4', '4', '2016-01-31', '0000-00-00', '025/2016', '0', '0', '2310', '0', '0', '0', '0', '2310', '0', '1', '0', '0', '0', NULL, '0'),
('58', '12', '0', '4', '4', '2016-02-05', '0000-00-00', '026/2016', '0', '0', '5110', '0', '0', '0', '0', '5110', '0', '1', '0', '0', '0', NULL, '0'),
('59', '12', '0', '4', '4', '2016-02-12', '0000-00-00', '027/2016', '0', '0', '12205', '0', '0', '0', '0', '12205', '0', '1', '0', '0', '0', NULL, '0'),
('60', '12', '0', '4', '4', '2016-02-19', '0000-00-00', '028/2016', '0', '0', '10485', '0', '0', '0', '0', '10485', '0', '1', '0', '0', '0', NULL, '0'),
('61', '12', '0', '4', '4', '2016-02-26', '0000-00-00', '029/2016', '0', '0', '17820', '0', '0', '0', '0', '17820', '0', '1', '0', '0', '0', NULL, '0'),
('62', '12', '0', '4', '4', '2016-02-29', '0000-00-00', '030/2016', '0', '0', '5565', '0', '0', '0', '0', '5565', '0', '1', '0', '0', '0', NULL, '0'),
('63', '12', '0', '4', '4', '2016-03-04', '0000-00-00', '031/2016', '0', '0', '6750', '0', '0', '0', '0', '6750', '0', '1', '0', '0', '0', NULL, '0'),
('64', '12', '0', '4', '4', '2016-03-11', '0000-00-00', '032/2016', '0', '0', '10790', '0', '0', '0', '0', '10790', '0', '1', '0', '0', '0', NULL, '0'),
('65', '12', '0', '4', '4', '2016-03-18', '0000-00-00', '033/2016', '0', '0', '13605', '0', '0', '0', '0', '13605', '0', '1', '0', '0', '0', NULL, '0'),
('66', '12', '0', '4', '4', '2016-03-25', '0000-00-00', '034/2016', '0', '0', '11435', '0', '0', '0', '0', '11435', '0', '1', '0', '0', '0', NULL, '0'),
('67', '12', '0', '4', '4', '2016-03-31', '0000-00-00', '035/2016', '0', '0', '6445', '0', '0', '0', '0', '6445', '0', '1', '0', '0', '0', NULL, '0'),
('1', '13', '2', '3', '3', '2015-04-30', '2016-03-31', 'auto', '1', '1', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('2', '13', '2', '3', '3', '2015-04-30', '2016-03-31', 'auto', '1', '2', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('3', '13', '2', '3', '3', '2016-03-31', '2016-03-31', 'auto', '1', '3', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('4', '13', '2', '3', '3', '2016-03-31', '2016-03-31', 'auto', '1', '4', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('5', '13', '1', '3', '3', '2015-04-30', '2016-04-01', '001/2015', '1', '5', '272659', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('6', '13', '1', '3', '3', '2015-05-31', '2016-03-31', 'auto', '1', '6', '303185', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('7', '13', '1', '3', '3', '2015-06-30', '2016-03-31', 'auto', '1', '7', '322814', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('8', '13', '1', '3', '3', '2015-07-03', '2016-03-31', 'auto', '1', '8', '26905', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('9', '13', '1', '3', '3', '2015-07-10', '2016-03-31', 'auto', '1', '9', '62453', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('10', '13', '1', '3', '3', '2015-07-17', '2016-03-31', 'auto', '1', '10', '62364', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('11', '13', '1', '3', '3', '2015-07-24', '2016-03-31', 'auto', '1', '11', '61302', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('12', '13', '1', '3', '3', '2015-07-31', '2016-03-31', 'auto', '1', '12', '79320', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('13', '13', '1', '3', '3', '2015-08-07', '2016-03-31', 'auto', '1', '13', '72048', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('14', '13', '1', '3', '3', '2015-08-14', '2016-03-31', 'auto', '1', '14', '74651', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('15', '13', '1', '3', '3', '2015-08-21', '2016-03-31', 'auto', '1', '15', '67860', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('16', '13', '1', '3', '3', '2015-08-28', '2016-03-31', 'auto', '1', '16', '80505', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('17', '13', '1', '3', '3', '2015-08-31', '2016-03-31', 'auto', '1', '17', '48025', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('18', '13', '1', '3', '3', '2015-09-04', '2016-03-31', 'auto', '1', '18', '48607', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('19', '13', '1', '3', '3', '2015-09-11', '2016-03-31', 'auto', '1', '19', '74533', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('20', '13', '1', '3', '3', '2015-09-18', '2016-03-31', 'auto', '1', '20', '79045', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('21', '13', '1', '3', '3', '2015-09-25', '2016-03-31', 'auto', '1', '21', '86405', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('22', '13', '1', '3', '3', '2015-09-30', '2016-03-31', 'auto', '1', '22', '60248', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('23', '13', '1', '3', '3', '2015-10-04', '2016-03-31', 'auto', '1', '23', '23010', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('24', '13', '1', '3', '3', '2015-10-09', '2016-03-31', 'auto', '1', '24', '91729', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('25', '13', '1', '3', '3', '2015-10-16', '2016-03-31', 'auto', '1', '25', '63100', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('26', '13', '1', '3', '3', '2015-10-23', '2016-03-31', 'auto', '1', '26', '76586', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('27', '13', '1', '3', '3', '2015-10-31', '2016-03-31', 'auto', '1', '27', '73678', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('28', '13', '1', '3', '3', '2015-11-06', '2016-03-31', 'auto', '1', '28', '50375', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('29', '13', '1', '3', '3', '2015-11-13', '2016-03-31', 'auto', '1', '29', '65880', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('30', '13', '1', '3', '3', '2015-11-20', '2016-03-31', 'auto', '1', '30', '68189', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('31', '13', '1', '3', '3', '2015-11-27', '2016-03-31', 'auto', '1', '31', '89000', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('32', '13', '1', '3', '3', '2015-11-30', '2016-03-31', 'auto', '1', '32', '40958', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('33', '13', '1', '3', '3', '2015-12-04', '2016-03-31', 'auto', '1', '33', '53924', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('34', '13', '1', '3', '3', '2015-12-11', '2016-03-31', 'auto', '1', '34', '82963', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('35', '13', '1', '3', '3', '2015-12-18', '2016-03-31', 'auto', '1', '35', '71768', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('36', '13', '1', '3', '3', '2015-12-25', '2016-03-31', 'auto', '1', '36', '120771', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('37', '13', '1', '3', '3', '2015-12-31', '2016-03-31', 'auto', '1', '37', '89350', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('38', '13', '1', '3', '3', '2016-01-01', '2016-03-31', 'auto', '1', '38', '9835', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('39', '13', '1', '3', '3', '2016-01-08', '2016-03-31', 'auto', '1', '39', '64306', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('40', '13', '1', '3', '3', '2016-01-15', '2016-03-31', 'auto', '1', '40', '95720', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('41', '13', '1', '3', '3', '2016-01-22', '2016-03-31', 'auto', '1', '41', '62295', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('42', '13', '1', '3', '3', '2016-01-29', '2016-03-31', 'auto', '1', '42', '113045', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('43', '13', '1', '3', '3', '2016-01-31', '2016-03-31', 'auto', '1', '43', '47945', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('44', '13', '1', '3', '3', '2016-02-05', '2016-03-31', 'auto', '1', '44', '64565', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('45', '13', '1', '3', '3', '2016-02-12', '2016-03-31', 'auto', '1', '45', '103935', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('46', '13', '1', '3', '3', '2016-02-19', '2016-03-31', 'auto', '1', '46', '97114', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('47', '13', '1', '3', '3', '2016-02-26', '2016-03-31', 'auto', '1', '47', '110807', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('48', '13', '1', '3', '3', '2016-02-29', '2016-03-31', 'auto', '1', '48', '46100', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('49', '13', '1', '3', '3', '2016-03-04', '2016-03-31', 'auto', '1', '49', '46887', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('50', '13', '1', '3', '3', '2016-03-11', '2016-03-31', 'auto', '1', '50', '107384', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('51', '13', '1', '3', '3', '2016-03-18', '2016-03-31', 'auto', '1', '51', '111432', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('52', '13', '1', '3', '3', '2016-03-25', '2016-03-31', 'auto', '1', '52', '92910', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('53', '13', '1', '3', '3', '2016-03-31', '2016-03-31', 'auto', '1', '53', '74215', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('54', '13', '1', '4', '4', '2016-01-15', '2016-03-31', 'auto', '1', '54', '12635', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('55', '13', '1', '4', '4', '2016-01-22', '2016-03-31', 'auto', '1', '55', '10430', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('56', '13', '1', '4', '4', '2016-01-29', '2016-03-31', 'auto', '1', '56', '6745', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('57', '13', '1', '4', '4', '2016-01-31', '2016-03-31', 'auto', '1', '57', '2310', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('58', '13', '1', '4', '4', '2016-02-05', '2016-03-31', 'auto', '1', '58', '5110', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('59', '13', '1', '4', '4', '2016-02-12', '2016-03-31', 'auto', '1', '59', '12205', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('60', '13', '1', '4', '4', '2016-02-19', '2016-03-31', 'auto', '1', '60', '10485', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('61', '13', '1', '4', '4', '2016-02-26', '2016-03-31', 'auto', '1', '61', '17820', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('62', '13', '1', '4', '4', '2016-02-29', '2016-03-31', 'auto', '1', '62', '5565', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('63', '13', '1', '4', '4', '2016-03-04', '2016-03-31', 'auto', '1', '63', '6750', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('64', '13', '1', '4', '4', '2016-03-11', '2016-03-31', 'auto', '1', '64', '10790', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('65', '13', '1', '4', '4', '2016-03-18', '2016-03-31', 'auto', '1', '65', '13605', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('66', '13', '1', '4', '4', '2016-03-25', '2016-03-31', 'auto', '1', '66', '11435', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1'),
('67', '13', '1', '4', '4', '2016-03-31', '2016-03-31', 'auto', '1', '67', '6445', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '1');

### Structure of table `6_debtor_trans_details` ###

DROP TABLE IF EXISTS `6_debtor_trans_details`;

CREATE TABLE `6_debtor_trans_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_trans_no` int(11) DEFAULT NULL,
  `debtor_trans_type` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `unit_price` double NOT NULL DEFAULT '0',
  `unit_tax` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `discount_percent` double NOT NULL DEFAULT '0',
  `standard_cost` double NOT NULL DEFAULT '0',
  `qty_done` double NOT NULL DEFAULT '0',
  `src_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`debtor_trans_type`,`debtor_trans_no`),
  KEY `src_id` (`src_id`)
) ENGINE=InnoDB AUTO_INCREMENT=153 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_debtor_trans_details` ###

INSERT INTO `6_debtor_trans_details` VALUES
('1', '1', '13', '001', 'Food', '0', '0', '0', '0', '0', '1', '0'),
('2', '1', '10', '001', 'Food', '0', '0', '0', '0', '0', '0', '0'),
('3', '2', '13', '001', 'Food', '0', '0', '0', '0', '0', '1', '0'),
('4', '2', '10', '001', 'Food', '0', '0', '0', '0', '0', '0', '0'),
('5', '3', '13', '001', 'Food', '0', '0', '0', '0', '0', '1', '0'),
('6', '3', '10', '001', 'Food', '0', '0', '0', '0', '0', '0', '0'),
('7', '4', '13', '002', ' 	Beverage', '0', '0', '0', '0', '0', '1', '0'),
('8', '4', '10', '002', ' 	Beverage', '0', '0', '0', '0', '0', '0', '0'),
('9', '5', '13', '001', 'Food', '272659', '0', '1', '0', '0', '1', '5'),
('10', '5', '10', '001', 'Food', '272659', '0', '1', '0', '0', '0', '9'),
('11', '6', '13', '001', 'Food', '303185', '0', '1', '0', '0', '1', '6'),
('12', '6', '10', '001', 'Food', '303185', '0', '1', '0', '0', '0', '11'),
('13', '7', '13', '001', 'Food', '322814', '0', '1', '0', '0', '1', '7'),
('14', '7', '10', '001', 'Food', '322814', '0', '1', '0', '0', '0', '13'),
('15', '8', '13', '001', 'Food', '20200', '0', '1', '0', '0', '1', '8'),
('16', '8', '13', '002', ' 	Beverage', '6705', '0', '1', '0', '0', '1', '9'),
('17', '8', '10', '001', 'Food', '20200', '0', '1', '0', '0', '0', '15'),
('18', '8', '10', '002', ' 	Beverage', '6705', '0', '1', '0', '0', '0', '16'),
('19', '9', '13', '001', 'Food', '62453', '0', '1', '0', '0', '1', '10'),
('20', '9', '10', '001', 'Food', '62453', '0', '1', '0', '0', '0', '19'),
('21', '10', '13', '001', 'Food', '62364', '0', '1', '0', '0', '1', '11'),
('22', '10', '10', '001', 'Food', '62364', '0', '1', '0', '0', '0', '21'),
('23', '11', '13', '001', 'Food', '61302', '0', '1', '0', '0', '1', '12'),
('24', '11', '10', '001', 'Food', '61302', '0', '1', '0', '0', '0', '23'),
('25', '12', '13', '001', 'Food', '79320', '0', '1', '0', '0', '1', '13'),
('26', '12', '10', '001', 'Food', '79320', '0', '1', '0', '0', '0', '25'),
('27', '13', '13', '001', 'Food', '62403', '0', '1', '0', '0', '1', '14'),
('28', '13', '13', '002', ' 	Beverage', '9645', '0', '1', '0', '0', '1', '15'),
('29', '13', '10', '001', 'Food', '62403', '0', '1', '0', '0', '0', '27'),
('30', '13', '10', '002', ' 	Beverage', '9645', '0', '1', '0', '0', '0', '28'),
('31', '14', '13', '001', 'Food', '74651', '0', '1', '0', '0', '1', '16'),
('32', '14', '10', '001', 'Food', '74651', '0', '1', '0', '0', '0', '31'),
('33', '15', '13', '001', 'Food', '67860', '0', '1', '0', '0', '1', '17'),
('34', '15', '10', '001', 'Food', '67860', '0', '1', '0', '0', '0', '33'),
('35', '16', '13', '001', 'Food', '80505', '0', '1', '0', '0', '1', '18'),
('36', '16', '10', '001', 'Food', '80505', '0', '1', '0', '0', '0', '35'),
('37', '17', '13', '001', 'Food', '48025', '0', '1', '0', '0', '1', '19'),
('38', '17', '10', '001', 'Food', '48025', '0', '1', '0', '0', '0', '37'),
('39', '18', '13', '001', 'Food', '41292', '0', '1', '0', '0', '1', '20'),
('40', '18', '13', '002', ' 	Beverage', '7315', '0', '1', '0', '0', '1', '21'),
('41', '18', '10', '001', 'Food', '41292', '0', '1', '0', '0', '0', '39'),
('42', '18', '10', '002', ' 	Beverage', '7315', '0', '1', '0', '0', '0', '40'),
('43', '19', '13', '001', 'Food', '74533', '0', '1', '0', '0', '1', '22'),
('44', '19', '10', '001', 'Food', '74533', '0', '1', '0', '0', '0', '43'),
('45', '20', '13', '001', 'Food', '79045', '0', '1', '0', '0', '1', '23'),
('46', '20', '10', '001', 'Food', '79045', '0', '1', '0', '0', '0', '45'),
('47', '21', '13', '001', 'Food', '86405', '0', '1', '0', '0', '1', '24'),
('48', '21', '10', '001', 'Food', '86405', '0', '1', '0', '0', '0', '47'),
('49', '22', '13', '001', 'Food', '60248', '0', '1', '0', '0', '1', '25'),
('50', '22', '10', '001', 'Food', '60248', '0', '1', '0', '0', '0', '49'),
('51', '23', '13', '001', 'Food', '14500', '0', '1', '0', '0', '1', '26'),
('52', '23', '13', '002', ' 	Beverage', '8510', '0', '1', '0', '0', '1', '27'),
('53', '23', '10', '001', 'Food', '14500', '0', '1', '0', '0', '0', '51'),
('54', '23', '10', '002', ' 	Beverage', '8510', '0', '1', '0', '0', '0', '52'),
('55', '24', '13', '001', 'Food', '91729', '0', '1', '0', '0', '1', '28'),
('56', '24', '10', '001', 'Food', '91729', '0', '1', '0', '0', '0', '55'),
('57', '25', '13', '001', 'Food', '63100', '0', '1', '0', '0', '1', '29'),
('58', '25', '10', '001', 'Food', '63100', '0', '1', '0', '0', '0', '57'),
('59', '26', '13', '001', 'Food', '76586', '0', '1', '0', '0', '1', '30'),
('60', '26', '10', '001', 'Food', '76586', '0', '1', '0', '0', '0', '59'),
('61', '27', '13', '001', 'Food', '73678', '0', '1', '0', '0', '1', '31'),
('62', '27', '10', '001', 'Food', '73678', '0', '1', '0', '0', '0', '61'),
('63', '28', '13', '001', 'Food', '44235', '0', '1', '0', '0', '1', '32'),
('64', '28', '13', '002', ' 	Beverage', '6140', '0', '1', '0', '0', '1', '33'),
('65', '28', '10', '001', 'Food', '44235', '0', '1', '0', '0', '0', '63'),
('66', '28', '10', '002', ' 	Beverage', '6140', '0', '1', '0', '0', '0', '64'),
('67', '29', '13', '001', 'Food', '65880', '0', '1', '0', '0', '1', '34'),
('68', '29', '10', '001', 'Food', '65880', '0', '1', '0', '0', '0', '67'),
('69', '30', '13', '001', 'Food', '68189', '0', '1', '0', '0', '1', '35'),
('70', '30', '10', '001', 'Food', '68189', '0', '1', '0', '0', '0', '69'),
('71', '31', '13', '001', 'Food', '89000', '0', '1', '0', '0', '1', '36'),
('72', '31', '10', '001', 'Food', '89000', '0', '1', '0', '0', '0', '71'),
('73', '32', '13', '001', 'Food', '40958', '0', '1', '0', '0', '1', '37'),
('74', '32', '10', '001', 'Food', '40958', '0', '1', '0', '0', '0', '73'),
('75', '33', '13', '001', 'Food', '47669', '0', '1', '0', '0', '1', '38'),
('76', '33', '13', '002', ' 	Beverage', '6255', '0', '1', '0', '0', '1', '39'),
('77', '33', '10', '001', 'Food', '47669', '0', '1', '0', '0', '0', '75'),
('78', '33', '10', '002', ' 	Beverage', '6255', '0', '1', '0', '0', '0', '76'),
('79', '34', '13', '001', 'Food', '82963', '0', '1', '0', '0', '1', '40'),
('80', '34', '10', '001', 'Food', '82963', '0', '1', '0', '0', '0', '79'),
('81', '35', '13', '001', 'Food', '71768', '0', '1', '0', '0', '1', '41'),
('82', '35', '10', '001', 'Food', '71768', '0', '1', '0', '0', '0', '81'),
('83', '36', '13', '001', 'Food', '120771', '0', '1', '0', '0', '1', '42'),
('84', '36', '10', '001', 'Food', '120771', '0', '1', '0', '0', '0', '83'),
('85', '37', '13', '001', 'Food', '89350', '0', '1', '0', '0', '1', '43'),
('86', '37', '10', '001', 'Food', '89350', '0', '1', '0', '0', '0', '85'),
('87', '38', '13', '001', 'Food', '1790', '0', '1', '0', '0', '1', '44'),
('88', '38', '13', '002', ' 	Beverage', '8045', '0', '1', '0', '0', '1', '45'),
('89', '38', '10', '001', 'Food', '1790', '0', '1', '0', '0', '0', '87'),
('90', '38', '10', '002', ' 	Beverage', '8045', '0', '1', '0', '0', '0', '88'),
('91', '39', '13', '002', ' 	Beverage', '64306', '0', '1', '0', '0', '1', '46'),
('92', '39', '10', '002', ' 	Beverage', '64306', '0', '1', '0', '0', '0', '91'),
('93', '40', '13', '001', 'Food', '95720', '0', '1', '0', '0', '1', '47'),
('94', '40', '10', '001', 'Food', '95720', '0', '1', '0', '0', '0', '93'),
('95', '41', '13', '001', 'Food', '62295', '0', '1', '0', '0', '1', '48'),
('96', '41', '10', '001', 'Food', '62295', '0', '1', '0', '0', '0', '95'),
('97', '42', '13', '001', 'Food', '113045', '0', '1', '0', '0', '1', '49'),
('98', '42', '10', '001', 'Food', '113045', '0', '1', '0', '0', '0', '97'),
('99', '43', '13', '001', 'Food', '47945', '0', '1', '0', '0', '1', '50'),
('100', '43', '10', '001', 'Food', '47945', '0', '1', '0', '0', '0', '99'),
('101', '44', '13', '001', 'Food', '53980', '0', '1', '0', '0', '1', '51'),
('102', '44', '13', '002', ' 	Beverage', '10585', '0', '1', '0', '0', '1', '52'),
('103', '44', '10', '001', 'Food', '53980', '0', '1', '0', '0', '0', '101'),
('104', '44', '10', '002', ' 	Beverage', '10585', '0', '1', '0', '0', '0', '102'),
('105', '45', '13', '001', 'Food', '103935', '0', '1', '0', '0', '1', '53'),
('106', '45', '10', '001', 'Food', '103935', '0', '1', '0', '0', '0', '105'),
('107', '46', '13', '001', 'Food', '97114', '0', '1', '0', '0', '1', '54'),
('108', '46', '10', '001', 'Food', '97114', '0', '1', '0', '0', '0', '107'),
('109', '47', '13', '001', 'Food', '110807', '0', '1', '0', '0', '1', '55'),
('110', '47', '10', '001', 'Food', '110807', '0', '1', '0', '0', '0', '109'),
('111', '48', '13', '001', 'Food', '46100', '0', '1', '0', '0', '1', '56'),
('112', '48', '10', '001', 'Food', '46100', '0', '1', '0', '0', '0', '111'),
('113', '49', '13', '001', 'Food', '31687', '0', '1', '0', '0', '1', '57'),
('114', '49', '13', '002', ' 	Beverage', '15200', '0', '1', '0', '0', '1', '58'),
('115', '49', '10', '001', 'Food', '31687', '0', '1', '0', '0', '0', '113'),
('116', '49', '10', '002', ' 	Beverage', '15200', '0', '1', '0', '0', '0', '114'),
('117', '50', '13', '001', 'Food', '107384', '0', '1', '0', '0', '1', '59'),
('118', '50', '10', '001', 'Food', '107384', '0', '1', '0', '0', '0', '117'),
('119', '51', '13', '001', 'Food', '111432', '0', '1', '0', '0', '1', '60'),
('120', '51', '10', '001', 'Food', '111432', '0', '1', '0', '0', '0', '119'),
('121', '52', '13', '001', 'Food', '92910', '0', '1', '0', '0', '1', '61'),
('122', '52', '10', '001', 'Food', '92910', '0', '1', '0', '0', '0', '121'),
('123', '53', '13', '001', 'Food', '74215', '0', '1', '0', '0', '1', '62'),
('124', '53', '10', '001', 'Food', '74215', '0', '1', '0', '0', '0', '123'),
('125', '54', '13', '001', 'Food', '12635', '0', '1', '0', '0', '1', '63'),
('126', '54', '10', '001', 'Food', '12635', '0', '1', '0', '0', '0', '125'),
('127', '55', '13', '001', 'Food', '10430', '0', '1', '0', '0', '1', '64'),
('128', '55', '10', '001', 'Food', '10430', '0', '1', '0', '0', '0', '127'),
('129', '56', '13', '001', 'Food', '6745', '0', '1', '0', '0', '1', '65'),
('130', '56', '10', '001', 'Food', '6745', '0', '1', '0', '0', '0', '129'),
('131', '57', '13', '001', 'Food', '2310', '0', '1', '0', '0', '1', '66'),
('132', '57', '10', '001', 'Food', '2310', '0', '1', '0', '0', '0', '131'),
('133', '58', '13', '001', 'Food', '5110', '0', '1', '0', '0', '1', '67'),
('134', '58', '10', '001', 'Food', '5110', '0', '1', '0', '0', '0', '133'),
('135', '59', '13', '002', ' 	Beverage', '12205', '0', '1', '0', '0', '1', '68'),
('136', '59', '10', '002', ' 	Beverage', '12205', '0', '1', '0', '0', '0', '135'),
('137', '60', '13', '001', 'Food', '10485', '0', '1', '0', '0', '1', '69'),
('138', '60', '10', '001', 'Food', '10485', '0', '1', '0', '0', '0', '137'),
('139', '61', '13', '001', 'Food', '17820', '0', '1', '0', '0', '1', '70'),
('140', '61', '10', '001', 'Food', '17820', '0', '1', '0', '0', '0', '139'),
('141', '62', '13', '001', 'Food', '5565', '0', '1', '0', '0', '1', '71'),
('142', '62', '10', '001', 'Food', '5565', '0', '1', '0', '0', '0', '141'),
('143', '63', '13', '001', 'Food', '6750', '0', '1', '0', '0', '1', '72'),
('144', '63', '10', '001', 'Food', '6750', '0', '1', '0', '0', '0', '143'),
('145', '64', '13', '001', 'Food', '10790', '0', '1', '0', '0', '1', '73'),
('146', '64', '10', '001', 'Food', '10790', '0', '1', '0', '0', '0', '145'),
('147', '65', '13', '001', 'Food', '13605', '0', '1', '0', '0', '1', '74'),
('148', '65', '10', '001', 'Food', '13605', '0', '1', '0', '0', '0', '147'),
('149', '66', '13', '001', 'Food', '11435', '0', '1', '0', '0', '1', '75'),
('150', '66', '10', '001', 'Food', '11435', '0', '1', '0', '0', '0', '149'),
('151', '67', '13', '001', 'Food', '6445', '0', '1', '0', '0', '1', '76'),
('152', '67', '10', '001', 'Food', '6445', '0', '1', '0', '0', '0', '151');

### Structure of table `6_debtors_master` ###

DROP TABLE IF EXISTS `6_debtors_master`;

CREATE TABLE `6_debtors_master` (
  `debtor_no` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `debtor_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `address` tinytext COLLATE utf8_unicode_ci,
  `tax_id` varchar(55) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type` int(11) NOT NULL DEFAULT '1',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `credit_status` int(11) NOT NULL DEFAULT '0',
  `payment_terms` int(11) DEFAULT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `pymt_discount` double NOT NULL DEFAULT '0',
  `credit_limit` float NOT NULL DEFAULT '1000',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`debtor_no`),
  UNIQUE KEY `debtor_ref` (`debtor_ref`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_debtors_master` ###

INSERT INTO `6_debtors_master` VALUES
('3', 'Cash', 'Cash', 'Colombo', '', 'LKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('4', 'Cash-outlet', 'Cash-outlet', 'Colombo', '', 'LKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('5', 'Tuder V Perera &amp; Co', 'TVP', 'No -103,Chatham Street,Colombo 01', '', 'LKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0');

### Structure of table `6_dimensions` ###

DROP TABLE IF EXISTS `6_dimensions`;

CREATE TABLE `6_dimensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_` tinyint(1) NOT NULL DEFAULT '1',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  KEY `date_` (`date_`),
  KEY `due_date` (`due_date`),
  KEY `type_` (`type_`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_dimensions` ###

INSERT INTO `6_dimensions` VALUES
('1', '001/2015', 'Cost Centre', '1', '0', '2015-05-05', '2015-05-25');

### Structure of table `6_exchange_rates` ###

DROP TABLE IF EXISTS `6_exchange_rates`;

CREATE TABLE `6_exchange_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rate_buy` double NOT NULL DEFAULT '0',
  `rate_sell` double NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `curr_code` (`curr_code`,`date_`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_exchange_rates` ###

INSERT INTO `6_exchange_rates` VALUES
('1', 'LKR', '1.123', '1.123', '2015-05-07');

### Structure of table `6_fiscal_year` ###

DROP TABLE IF EXISTS `6_fiscal_year`;

CREATE TABLE `6_fiscal_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `begin` date DEFAULT '0000-00-00',
  `end` date DEFAULT '0000-00-00',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `begin` (`begin`),
  UNIQUE KEY `end` (`end`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_fiscal_year` ###

INSERT INTO `6_fiscal_year` VALUES
('1', '2015-04-01', '2016-03-31', '0'),
('2', '2016-04-01', '2017-03-31', '0'),
('3', '2014-04-01', '2015-03-31', '0');

### Structure of table `6_gl_trans` ###

DROP TABLE IF EXISTS `6_gl_trans`;

CREATE TABLE `6_gl_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT '0',
  `type_no` int(11) NOT NULL DEFAULT '0',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `amount` double NOT NULL DEFAULT '0',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `dimension_id` (`dimension_id`),
  KEY `dimension2_id` (`dimension2_id`),
  KEY `tran_date` (`tran_date`),
  KEY `account_and_tran_date` (`account`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=1563 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_gl_trans` ###

INSERT INTO `6_gl_trans` VALUES
('1', '1', '1', '2015-07-24', '4350', 'Cheque book charges', '750', '0', '0', NULL, NULL),
('2', '1', '1', '2015-07-24', '0303', '', '-750', '0', '0', NULL, NULL),
('3', '2', '1', '2015-07-24', '4350', 'Cash Deposit', '0', '0', '0', NULL, NULL),
('4', '2', '1', '2015-07-24', '0303', '', '0', '0', '0', NULL, NULL),
('5', '2', '2', '2015-07-24', '0254', 'Cash Deposit', '0', '0', '0', NULL, NULL),
('6', '2', '2', '2015-07-24', '0303', '', '0', '0', '0', NULL, NULL),
('7', '0', '1', '2015-07-24', '4350', 'Error Correction', '0', '0', '0', NULL, NULL),
('8', '0', '1', '2015-07-24', '0254', 'Error Correction', '0', '0', '0', NULL, NULL),
('9', '0', '1', '2015-07-24', '0303', 'Error Correction', '0', '0', '0', NULL, NULL),
('10', '2', '3', '2015-07-24', '0256', 'Opening balance', '0', '0', '0', NULL, NULL),
('11', '2', '3', '2015-07-24', '0303', '', '0', '0', '0', NULL, NULL),
('12', '1', '2', '2015-08-06', '4162', 'Packing matrials', '6557', '0', '0', NULL, NULL),
('13', '1', '2', '2015-08-06', '0303', '', '-6557', '0', '0', NULL, NULL),
('14', '1', '3', '2015-08-20', '4350', 'Bank Charges', '200', '0', '0', NULL, NULL),
('15', '1', '3', '2015-08-20', '0303', '', '-200', '0', '0', NULL, NULL),
('16', '2', '4', '2015-07-24', '0254', 'Cash Deposit', '0', '0', '0', NULL, NULL),
('17', '2', '4', '2015-07-24', '0303', '', '0', '0', '0', NULL, NULL),
('18', '2', '5', '2015-07-24', '0256', 'Cash Deposit', '-25000', '0', '0', NULL, NULL),
('19', '2', '5', '2015-07-24', '0303', '', '25000', '0', '0', NULL, NULL),
('20', '4', '1', '2015-07-29', '0301', 'From Cash In Hand To Bank Of Celyon', '-48658', '0', '0', NULL, NULL),
('21', '4', '1', '2015-07-29', '0303', 'From Cash In Hand To Bank Of Celyon', '48658', '0', '0', NULL, NULL),
('22', '4', '2', '2015-08-04', '0301', 'From Cash In Hand To Bank Of Celyon', '-51604', '0', '0', NULL, NULL),
('23', '4', '2', '2015-08-04', '0303', 'From Cash In Hand To Bank Of Celyon', '51604', '0', '0', NULL, NULL),
('24', '4', '3', '2015-08-05', '0301', 'From Cash In Hand To Bank Of Celyon', '-12250', '0', '0', NULL, NULL),
('25', '4', '3', '2015-08-05', '0303', 'From Cash In Hand To Bank Of Celyon', '12250', '0', '0', NULL, NULL),
('26', '4', '4', '2015-08-05', '0301', 'From Cash In Hand To Bank Of Celyon', '-6547', '0', '0', NULL, NULL),
('27', '4', '4', '2015-08-05', '0303', 'From Cash In Hand To Bank Of Celyon', '6547', '0', '0', NULL, NULL),
('28', '4', '5', '2015-08-06', '0301', 'From Cash In Hand To Bank Of Celyon', '-6855', '0', '0', NULL, NULL),
('29', '4', '5', '2015-08-06', '0303', 'From Cash In Hand To Bank Of Celyon', '6855', '0', '0', NULL, NULL),
('30', '4', '6', '2015-08-12', '0301', 'From Cash In Hand To Bank Of Celyon', '-36990', '0', '0', NULL, NULL),
('31', '4', '6', '2015-08-12', '0303', 'From Cash In Hand To Bank Of Celyon', '36990', '0', '0', NULL, NULL),
('32', '4', '7', '2015-08-14', '0301', 'From Cash In Hand To Bank Of Celyon', '-8100', '0', '0', NULL, NULL),
('33', '4', '7', '2015-08-14', '0303', 'From Cash In Hand To Bank Of Celyon', '8100', '0', '0', NULL, NULL),
('34', '4', '8', '2015-08-14', '0301', 'From Cash In Hand To Bank Of Celyon', '-7680', '0', '0', NULL, NULL),
('35', '4', '8', '2015-08-14', '0303', 'From Cash In Hand To Bank Of Celyon', '7680', '0', '0', NULL, NULL),
('36', '4', '9', '2015-08-14', '0301', 'From Cash In Hand To Bank Of Celyon', '-5985', '0', '0', NULL, NULL),
('37', '4', '9', '2015-08-14', '0303', 'From Cash In Hand To Bank Of Celyon', '5985', '0', '0', NULL, NULL),
('38', '4', '10', '2015-08-14', '0301', 'From Cash In Hand To Bank Of Celyon', '-200', '0', '0', NULL, NULL),
('39', '4', '10', '2015-08-14', '0303', 'From Cash In Hand To Bank Of Celyon', '200', '0', '0', NULL, NULL),
('40', '4', '11', '2015-08-20', '0301', 'From Cash In Hand To Bank Of Celyon', '-51950', '0', '0', NULL, NULL),
('41', '4', '11', '2015-08-20', '0303', 'From Cash In Hand To Bank Of Celyon', '51950', '0', '0', NULL, NULL),
('42', '4', '12', '2015-08-25', '0301', 'From Cash In Hand To Bank Of Celyon', '-33460', '0', '0', NULL, NULL),
('43', '4', '12', '2015-08-25', '0303', 'From Cash In Hand To Bank Of Celyon', '33460', '0', '0', NULL, NULL),
('44', '1', '4', '2015-08-26', '4168', 'Gas Tank Purchased', '0', '0', '0', NULL, NULL),
('45', '1', '4', '2015-08-26', '0303', '', '0', '0', '0', NULL, NULL),
('46', '4', '13', '2015-08-27', '0301', 'From Cash In Hand To Bank Of Celyon', '-26300', '0', '0', NULL, NULL),
('47', '4', '13', '2015-08-27', '0303', 'From Cash In Hand To Bank Of Celyon', '26300', '0', '0', NULL, NULL),
('48', '4', '14', '2015-08-31', '0301', 'From Cash In Hand To Bank Of Celyon', '-51030', '0', '0', NULL, NULL),
('49', '4', '14', '2015-08-31', '0303', 'From Cash In Hand To Bank Of Celyon', '51030', '0', '0', NULL, NULL),
('50', '1', '5', '2015-08-31', '2000', 'Food item purchase', '57346', '0', '0', NULL, NULL),
('51', '1', '5', '2015-08-31', '4162', 'Packing matrials', '2717', '0', '0', NULL, NULL),
('52', '1', '5', '2015-08-31', '2000', 'Food item purchase', '25788', '0', '0', NULL, NULL),
('53', '1', '5', '2015-08-31', '4166', 'Maintain expenses', '695', '0', '0', NULL, NULL),
('54', '1', '5', '2015-08-31', '0303', '', '-86546', '0', '0', NULL, NULL),
('55', '1', '6', '2015-09-01', '4166', 'Maintain expenses', '3415', '0', '0', NULL, NULL),
('56', '1', '6', '2015-09-01', '0303', '', '-3415', '0', '0', NULL, NULL),
('57', '4', '15', '2015-09-02', '0301', 'From Cash In Hand To Bank Of Celyon', '-14825', '0', '0', NULL, NULL),
('58', '4', '15', '2015-09-02', '0303', 'From Cash In Hand To Bank Of Celyon', '14825', '0', '0', NULL, NULL),
('59', '4', '16', '2015-09-03', '0301', 'From Cash In Hand To Bank Of Celyon', '-26885', '0', '0', NULL, NULL),
('60', '4', '16', '2015-09-03', '0303', 'From Cash In Hand To Bank Of Celyon', '26885', '0', '0', NULL, NULL),
('61', '4', '17', '2015-09-07', '0301', 'From Cash In Hand To Bank Of Celyon', '-31780', '0', '0', NULL, NULL),
('62', '4', '17', '2015-09-07', '0303', 'From Cash In Hand To Bank Of Celyon', '31780', '0', '0', NULL, NULL),
('63', '4', '18', '2015-09-09', '0301', 'From Cash In Hand To Bank Of Celyon', '-11000', '0', '0', NULL, NULL),
('64', '4', '18', '2015-09-09', '0303', 'From Cash In Hand To Bank Of Celyon', '11000', '0', '0', NULL, NULL),
('65', '4', '19', '2015-09-09', '0301', 'From Cash In Hand To Bank Of Celyon', '-5050', '0', '0', NULL, NULL),
('66', '4', '19', '2015-09-09', '0303', 'From Cash In Hand To Bank Of Celyon', '5050', '0', '0', NULL, NULL),
('67', '4', '20', '2015-09-09', '0301', 'From Cash In Hand To Bank Of Celyon', '-8500', '0', '0', NULL, NULL),
('68', '4', '20', '2015-09-09', '0303', 'From Cash In Hand To Bank Of Celyon', '8500', '0', '0', NULL, NULL),
('69', '1', '7', '2015-09-09', '4167', 'consultancy fee', '8500', '0', '0', NULL, NULL),
('70', '1', '7', '2015-09-09', '0303', '', '-8500', '0', '0', NULL, NULL),
('71', '4', '21', '2015-09-10', '0301', 'From Cash In Hand To Bank Of Celyon', '-7380', '0', '0', NULL, NULL),
('72', '4', '21', '2015-09-10', '0303', 'From Cash In Hand To Bank Of Celyon', '7380', '0', '0', NULL, NULL),
('73', '4', '22', '2015-09-10', '0301', 'From Cash In Hand To Bank Of Celyon', '-14150', '0', '0', NULL, NULL),
('74', '4', '22', '2015-09-10', '0303', 'From Cash In Hand To Bank Of Celyon', '14150', '0', '0', NULL, NULL),
('75', '4', '23', '2015-09-11', '0301', 'From Cash In Hand To Bank Of Celyon', '-76250', '0', '0', NULL, NULL),
('76', '4', '23', '2015-09-11', '0303', 'From Cash In Hand To Bank Of Celyon', '76250', '0', '0', NULL, NULL),
('77', '4', '24', '2015-09-14', '0301', 'From Cash In Hand To Bank Of Celyon', '-28074', '0', '0', NULL, NULL),
('78', '4', '24', '2015-09-14', '0303', 'From Cash In Hand To Bank Of Celyon', '28074', '0', '0', NULL, NULL),
('79', '1', '8', '2015-09-17', '2000', 'Food item purchase', '72446', '0', '0', NULL, NULL),
('80', '1', '8', '2015-09-17', '4166', 'Maintain expenses', '3805', '0', '0', NULL, NULL),
('81', '1', '8', '2015-09-17', '0303', '', '-76251', '0', '0', NULL, NULL),
('82', '4', '25', '2015-09-18', '0301', 'From Cash In Hand To Bank Of Celyon', '-26150', '0', '0', NULL, NULL),
('83', '4', '25', '2015-09-18', '0303', 'From Cash In Hand To Bank Of Celyon', '26150', '0', '0', NULL, NULL),
('84', '4', '26', '2015-09-21', '0301', 'From Cash In Hand To Bank Of Celyon', '-20640', '0', '0', NULL, NULL),
('85', '4', '26', '2015-09-21', '0303', 'From Cash In Hand To Bank Of Celyon', '20640', '0', '0', NULL, NULL),
('86', '4', '27', '2016-03-31', '0301', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('87', '4', '27', '2016-03-31', '0303', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('88', '4', '28', '2015-09-21', '0301', 'From Cash In Hand To Bank Of Celyon', '-10890', '0', '0', NULL, NULL),
('89', '4', '28', '2015-09-21', '0303', 'From Cash In Hand To Bank Of Celyon', '10890', '0', '0', NULL, NULL),
('90', '4', '29', '2015-09-22', '0301', 'From Cash In Hand To Bank Of Celyon', '-2165', '0', '0', NULL, NULL),
('91', '4', '29', '2015-09-22', '0303', 'From Cash In Hand To Bank Of Celyon', '2165', '0', '0', NULL, NULL),
('92', '4', '30', '2015-09-23', '0301', 'From Cash In Hand To Bank Of Celyon', '-7935', '0', '0', NULL, NULL),
('93', '4', '30', '2015-09-23', '0303', 'From Cash In Hand To Bank Of Celyon', '7935', '0', '0', NULL, NULL),
('94', '4', '31', '2015-09-25', '0301', 'From Cash In Hand To Bank Of Celyon', '-3775', '0', '0', NULL, NULL),
('95', '4', '31', '2015-09-25', '0303', 'From Cash In Hand To Bank Of Celyon', '3775', '0', '0', NULL, NULL),
('96', '4', '32', '2015-09-30', '0301', 'From Cash In Hand To Bank Of Celyon', '-44483', '0', '0', NULL, NULL),
('97', '4', '32', '2015-09-30', '0303', 'From Cash In Hand To Bank Of Celyon', '44483', '0', '0', NULL, NULL),
('98', '4', '33', '2015-09-30', '0301', 'From Cash In Hand To Bank Of Celyon', '-7605', '0', '0', NULL, NULL),
('99', '4', '33', '2015-09-30', '0303', 'From Cash In Hand To Bank Of Celyon', '7605', '0', '0', NULL, NULL),
('100', '4', '34', '2016-03-31', '0301', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('101', '4', '34', '2016-03-31', '0303', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('102', '4', '35', '2015-10-05', '0301', 'From Cash In Hand To Bank Of Celyon', '-29792', '0', '0', NULL, NULL),
('103', '4', '35', '2015-10-05', '0303', 'From Cash In Hand To Bank Of Celyon', '29792', '0', '0', NULL, NULL),
('104', '4', '36', '2015-10-01', '0301', 'From Cash In Hand To Bank Of Celyon', '-6960', '0', '0', NULL, NULL),
('105', '4', '36', '2015-10-01', '0303', 'From Cash In Hand To Bank Of Celyon', '6960', '0', '0', NULL, NULL),
('106', '4', '37', '2015-10-06', '0301', 'From Cash In Hand To Bank Of Celyon', '-12315', '0', '0', NULL, NULL),
('107', '4', '37', '2015-10-06', '0303', 'From Cash In Hand To Bank Of Celyon', '12315', '0', '0', NULL, NULL),
('108', '4', '38', '2015-10-08', '0301', 'From Cash In Hand To Bank Of Celyon', '-28180', '0', '0', NULL, NULL),
('109', '4', '38', '2015-10-08', '0303', 'From Cash In Hand To Bank Of Celyon', '28180', '0', '0', NULL, NULL),
('110', '4', '39', '2015-10-09', '0301', 'From Cash In Hand To Bank Of Celyon', '-7255', '0', '0', NULL, NULL),
('111', '4', '39', '2015-10-09', '0303', 'From Cash In Hand To Bank Of Celyon', '7255', '0', '0', NULL, NULL),
('112', '4', '40', '2015-10-12', '0301', 'From Cash In Hand To Bank Of Celyon', '-9166', '0', '0', NULL, NULL),
('113', '4', '40', '2015-10-12', '0303', 'From Cash In Hand To Bank Of Celyon', '9166', '0', '0', NULL, NULL),
('114', '4', '41', '2015-10-12', '0301', 'From Cash In Hand To Bank Of Celyon', '-48960', '0', '0', NULL, NULL),
('115', '4', '41', '2015-10-12', '0303', 'From Cash In Hand To Bank Of Celyon', '48960', '0', '0', NULL, NULL),
('116', '4', '42', '2015-10-15', '0301', 'From Cash In Hand To Bank Of Celyon', '-13640', '0', '0', NULL, NULL),
('117', '4', '42', '2015-10-15', '0303', 'From Cash In Hand To Bank Of Celyon', '13640', '0', '0', NULL, NULL),
('118', '1', '9', '2015-10-15', '4350', 'Bank Charges', '200', '0', '0', NULL, NULL),
('119', '1', '9', '2015-10-15', '0303', '', '-200', '0', '0', NULL, NULL),
('120', '4', '43', '2015-10-16', '0301', 'From Cash In Hand To Bank Of Celyon', '-38131', '0', '0', NULL, NULL),
('121', '4', '43', '2015-10-16', '0303', 'From Cash In Hand To Bank Of Celyon', '38131', '0', '0', NULL, NULL),
('122', '4', '44', '2015-10-16', '0301', 'From Cash In Hand To Bank Of Celyon', '-2280', '0', '0', NULL, NULL),
('123', '4', '44', '2015-10-16', '0303', 'From Cash In Hand To Bank Of Celyon', '2280', '0', '0', NULL, NULL),
('124', '2', '6', '2015-10-16', '0252', 'Fund Transfer to golden plam', '-50000', '0', '0', NULL, NULL),
('125', '2', '6', '2015-10-16', '0303', '', '50000', '0', '0', NULL, NULL),
('126', '1', '10', '2015-10-16', '2000', 'Food Item purchase ', '36641', '0', '0', NULL, NULL),
('127', '1', '10', '2015-10-16', '2000', 'Food Item purchase ', '36725', '0', '0', NULL, NULL),
('128', '1', '10', '2015-10-16', '4166', 'Maintenance Expenses ', '1020', '0', '0', NULL, NULL),
('129', '1', '10', '2015-10-16', '4166', 'Maintenance Expenses ', '1020', '0', '0', NULL, NULL),
('130', '1', '10', '2015-10-16', '0303', '', '-75406', '0', '0', NULL, NULL),
('131', '4', '45', '2015-10-19', '0301', 'From Cash In Hand To Bank Of Celyon', '-20748', '0', '0', NULL, NULL),
('132', '4', '45', '2015-10-19', '0303', 'From Cash In Hand To Bank Of Celyon', '20748', '0', '0', NULL, NULL),
('133', '1', '11', '2015-10-19', '0001', 'MANJULA BASS 1SR ADVANCE ', '50000', '0', '0', NULL, NULL),
('134', '1', '11', '2015-10-19', '0303', '', '-50000', '0', '0', NULL, NULL),
('135', '1', '12', '2015-10-19', '4162', 'Packing Materials ', '5320', '0', '0', NULL, NULL),
('136', '1', '12', '2015-10-19', '0303', '', '-5320', '0', '0', NULL, NULL),
('137', '4', '46', '2015-10-21', '0301', 'From Cash In Hand To Bank Of Celyon', '-11261', '0', '0', NULL, NULL),
('138', '4', '46', '2015-10-21', '0303', 'From Cash In Hand To Bank Of Celyon', '11261', '0', '0', NULL, NULL),
('139', '2', '7', '2015-10-22', '0252', 'Fund Transfer to golden plam', '-22000', '0', '0', NULL, NULL),
('140', '2', '7', '2015-10-22', '0303', '', '22000', '0', '0', NULL, NULL),
('141', '4', '47', '2015-10-23', '0301', 'From Cash In Hand To Bank Of Celyon', '-30290', '0', '0', NULL, NULL),
('142', '4', '47', '2015-10-23', '0303', 'From Cash In Hand To Bank Of Celyon', '30290', '0', '0', NULL, NULL),
('143', '4', '48', '2015-10-23', '0301', 'From Cash In Hand To Bank Of Celyon', '-24611', '0', '0', NULL, NULL),
('144', '4', '48', '2015-10-23', '0303', 'From Cash In Hand To Bank Of Celyon', '24611', '0', '0', NULL, NULL),
('145', '4', '49', '2015-10-26', '0301', 'From Cash In Hand To Bank Of Celyon', '-3160', '0', '0', NULL, NULL),
('146', '4', '49', '2015-10-26', '0303', 'From Cash In Hand To Bank Of Celyon', '3160', '0', '0', NULL, NULL),
('147', '4', '50', '2015-10-26', '0301', 'From Cash In Hand To Bank Of Celyon', '-12385', '0', '0', NULL, NULL),
('148', '4', '50', '2015-10-26', '0303', 'From Cash In Hand To Bank Of Celyon', '12385', '0', '0', NULL, NULL),
('149', '4', '51', '2015-10-26', '0301', 'From Cash In Hand To Bank Of Celyon', '-15851', '0', '0', NULL, NULL),
('150', '4', '51', '2015-10-26', '0303', 'From Cash In Hand To Bank Of Celyon', '15851', '0', '0', NULL, NULL),
('151', '4', '52', '2015-10-29', '0301', 'From Cash In Hand To Bank Of Celyon', '-19825', '0', '0', NULL, NULL),
('152', '4', '52', '2015-10-29', '0303', 'From Cash In Hand To Bank Of Celyon', '19825', '0', '0', NULL, NULL),
('153', '4', '53', '2015-10-30', '0301', 'From Cash In Hand To Bank Of Celyon', '-22200', '0', '0', NULL, NULL),
('154', '4', '53', '2015-10-30', '0303', 'From Cash In Hand To Bank Of Celyon', '22200', '0', '0', NULL, NULL),
('155', '4', '54', '2015-11-02', '0301', 'From Cash In Hand To Bank Of Celyon', '-21989', '0', '0', NULL, NULL),
('156', '4', '54', '2015-11-02', '0303', 'From Cash In Hand To Bank Of Celyon', '21989', '0', '0', NULL, NULL),
('157', '4', '55', '2015-11-03', '0301', 'From Cash In Hand To Bank Of Celyon', '-16095', '0', '0', NULL, NULL),
('158', '4', '55', '2015-11-03', '0303', 'From Cash In Hand To Bank Of Celyon', '16095', '0', '0', NULL, NULL),
('159', '2', '8', '2015-11-05', '0252', 'Fund Transfer to golden plam', '-43812', '0', '0', NULL, NULL),
('160', '2', '8', '2015-11-05', '0303', '', '43812', '0', '0', NULL, NULL),
('161', '1', '13', '2015-11-05', '4153', 'Payment for electrical expenses ', '43812', '0', '0', NULL, NULL),
('162', '1', '13', '2015-11-05', '0303', '', '-43812', '0', '0', NULL, NULL),
('163', '4', '56', '2015-11-06', '0301', 'From Cash In Hand To Bank Of Celyon', '-5940', '0', '0', NULL, NULL),
('164', '4', '56', '2015-11-06', '0303', 'From Cash In Hand To Bank Of Celyon', '5940', '0', '0', NULL, NULL),
('165', '4', '57', '2015-11-09', '0301', 'From Cash In Hand To Bank Of Celyon', '-59550', '0', '0', NULL, NULL),
('166', '4', '57', '2015-11-09', '0303', 'From Cash In Hand To Bank Of Celyon', '59550', '0', '0', NULL, NULL),
('167', '4', '58', '2015-11-09', '0301', 'From Cash In Hand To Bank Of Celyon', '-620', '0', '0', NULL, NULL),
('168', '4', '58', '2015-11-09', '0303', 'From Cash In Hand To Bank Of Celyon', '620', '0', '0', NULL, NULL),
('169', '1', '14', '2015-11-09', '0001', 'Capital Expenditure', '59550', '0', '0', NULL, NULL),
('170', '1', '14', '2015-11-09', '0303', '', '-59550', '0', '0', NULL, NULL),
('171', '4', '59', '2015-11-11', '0301', 'From Cash In Hand To Bank Of Celyon', '-27194', '0', '0', NULL, NULL),
('172', '4', '59', '2015-11-11', '0303', 'From Cash In Hand To Bank Of Celyon', '27194', '0', '0', NULL, NULL),
('173', '4', '60', '2015-11-11', '0301', 'From Cash In Hand To Bank Of Celyon', '-15850', '0', '0', NULL, NULL),
('174', '4', '60', '2015-11-11', '0303', 'From Cash In Hand To Bank Of Celyon', '15850', '0', '0', NULL, NULL),
('175', '4', '61', '2015-11-12', '0301', 'From Cash In Hand To Bank Of Celyon', '-4629', '0', '0', NULL, NULL),
('176', '4', '61', '2015-11-12', '0303', 'From Cash In Hand To Bank Of Celyon', '4629', '0', '0', NULL, NULL),
('177', '1', '15', '2015-11-12', '0001', 'Capital Expenditure', '15850', '0', '0', NULL, NULL),
('178', '1', '15', '2015-11-12', '0303', '', '-15850', '0', '0', NULL, NULL),
('179', '4', '62', '2015-11-13', '0301', 'From Cash In Hand To Bank Of Celyon', '-83999', '0', '0', NULL, NULL),
('180', '4', '62', '2015-11-13', '0303', 'From Cash In Hand To Bank Of Celyon', '83999', '0', '0', NULL, NULL),
('181', '1', '16', '2015-11-17', '2000', 'Food Item purchase', '154999', '0', '0', NULL, NULL),
('182', '1', '16', '2015-11-17', '0001', 'Capital Expenditure', '60000', '0', '0', NULL, NULL),
('183', '1', '16', '2015-11-17', '0303', '', '-214999', '0', '0', NULL, NULL),
('184', '4', '63', '2015-11-18', '0301', 'From Cash In Hand To Bank Of Celyon', '-19127', '0', '0', NULL, NULL),
('185', '4', '63', '2015-11-18', '0303', 'From Cash In Hand To Bank Of Celyon', '19127', '0', '0', NULL, NULL),
('186', '4', '64', '2015-11-18', '0301', 'From Cash In Hand To Bank Of Celyon', '-10616', '0', '0', NULL, NULL),
('187', '4', '64', '2015-11-18', '0303', 'From Cash In Hand To Bank Of Celyon', '10616', '0', '0', NULL, NULL),
('188', '4', '65', '2015-11-20', '0301', 'From Cash In Hand To Bank Of Celyon', '-196790', '0', '0', NULL, NULL),
('189', '4', '65', '2015-11-20', '0303', 'From Cash In Hand To Bank Of Celyon', '196790', '0', '0', NULL, NULL),
('190', '1', '17', '2015-11-20', '0001', 'Capital Expenditure', '196790', '0', '0', NULL, NULL),
('191', '1', '17', '2015-11-20', '0303', '', '-196790', '0', '0', NULL, NULL),
('192', '4', '66', '2015-11-23', '0301', 'From Cash In Hand To Bank Of Celyon', '-99271', '0', '0', NULL, NULL),
('193', '4', '66', '2015-11-23', '0303', 'From Cash In Hand To Bank Of Celyon', '99271', '0', '0', NULL, NULL),
('194', '4', '67', '2015-11-23', '0301', 'From Cash In Hand To Bank Of Celyon', '-14819', '0', '0', NULL, NULL),
('195', '4', '67', '2015-11-23', '0303', 'From Cash In Hand To Bank Of Celyon', '14819', '0', '0', NULL, NULL),
('196', '4', '68', '2015-11-24', '0301', 'From Cash In Hand To Bank Of Celyon', '-30910', '0', '0', NULL, NULL),
('197', '4', '68', '2015-11-24', '0303', 'From Cash In Hand To Bank Of Celyon', '30910', '0', '0', NULL, NULL),
('198', '1', '18', '2015-11-26', '4162', 'Packing Materials', '6740', '0', '0', NULL, NULL),
('199', '1', '18', '2015-11-26', '0303', '', '-6740', '0', '0', NULL, NULL),
('200', '1', '19', '2015-11-26', '0001', 'Capital Expenditure', '30910', '0', '0', NULL, NULL),
('201', '1', '19', '2015-11-26', '0303', '', '-30910', '0', '0', NULL, NULL),
('202', '4', '69', '2015-11-30', '0301', 'From Cash In Hand To Bank Of Celyon', '-47550', '0', '0', NULL, NULL),
('203', '4', '69', '2015-11-30', '0303', 'From Cash In Hand To Bank Of Celyon', '47550', '0', '0', NULL, NULL),
('204', '4', '70', '2016-03-31', '0301', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('205', '4', '70', '2016-03-31', '0303', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('206', '1', '20', '2015-11-30', '0001', 'Capital Expenditure', '43650', '0', '0', NULL, NULL),
('207', '1', '20', '2015-11-30', '0303', '', '-43650', '0', '0', NULL, NULL),
('208', '4', '71', '2015-12-01', '0301', 'From Cash In Hand To Bank Of Celyon', '-10651', '0', '0', NULL, NULL),
('209', '4', '71', '2015-12-01', '0303', 'From Cash In Hand To Bank Of Celyon', '10651', '0', '0', NULL, NULL),
('210', '4', '72', '2015-11-30', '0301', 'From Cash In Hand To Bank Of Celyon', '-56669', '0', '0', NULL, NULL),
('211', '4', '72', '2015-11-30', '0303', 'From Cash In Hand To Bank Of Celyon', '56669', '0', '0', NULL, NULL),
('212', '1', '21', '2015-12-01', '4350', 'Bank Charges', '400', '0', '0', NULL, NULL),
('213', '1', '21', '2015-12-01', '0303', '', '-400', '0', '0', NULL, NULL),
('214', '4', '73', '2015-12-04', '0301', 'From Cash In Hand To Bank Of Celyon', '-33294', '0', '0', NULL, NULL),
('215', '4', '73', '2015-12-04', '0303', 'From Cash In Hand To Bank Of Celyon', '33294', '0', '0', NULL, NULL),
('216', '4', '74', '2015-12-07', '0301', 'From Cash In Hand To Bank Of Celyon', '-12860', '0', '0', NULL, NULL),
('217', '4', '74', '2015-12-07', '0303', 'From Cash In Hand To Bank Of Celyon', '12860', '0', '0', NULL, NULL),
('218', '2', '9', '2015-12-07', '0252', 'Fund Transfer to golden plam', '-96355', '0', '0', NULL, NULL),
('219', '2', '9', '2015-12-07', '0303', '', '96355', '0', '0', NULL, NULL),
('220', '1', '22', '2015-12-08', '0001', 'Capital Expenditure', '77215', '0', '0', NULL, NULL),
('221', '1', '22', '2015-12-08', '0303', '', '-77215', '0', '0', NULL, NULL),
('222', '2', '10', '2015-12-08', '0253', 'Fund Transfer to golden plam', '-90978', '0', '0', NULL, NULL),
('223', '2', '10', '2015-12-08', '0303', '', '90978', '0', '0', NULL, NULL),
('224', '1', '23', '2015-12-09', '4200', 'Salary &amp; wages ', '7500', '0', '0', NULL, NULL),
('225', '1', '23', '2015-12-09', '0303', '', '-7500', '0', '0', NULL, NULL),
('226', '4', '75', '2015-12-09', '0301', 'From Cash In Hand To Bank Of Celyon', '-5025', '0', '0', NULL, NULL),
('227', '4', '75', '2015-12-09', '0303', 'From Cash In Hand To Bank Of Celyon', '5025', '0', '0', NULL, NULL),
('228', '4', '76', '2015-12-09', '0301', 'From Cash In Hand To Bank Of Celyon', '-10936', '0', '0', NULL, NULL),
('229', '4', '76', '2015-12-09', '0303', 'From Cash In Hand To Bank Of Celyon', '10936', '0', '0', NULL, NULL),
('230', '4', '77', '2015-12-09', '0301', 'From Cash In Hand To Bank Of Celyon', '-25290', '0', '0', NULL, NULL),
('231', '4', '77', '2015-12-09', '0303', 'From Cash In Hand To Bank Of Celyon', '25290', '0', '0', NULL, NULL),
('232', '4', '78', '2015-12-10', '0301', 'From Cash In Hand To Bank Of Celyon', '-9410', '0', '0', NULL, NULL),
('233', '4', '78', '2015-12-10', '0303', 'From Cash In Hand To Bank Of Celyon', '9410', '0', '0', NULL, NULL),
('234', '4', '79', '2015-12-10', '0301', 'From Cash In Hand To Bank Of Celyon', '-5025', '0', '0', NULL, NULL),
('235', '4', '79', '2015-12-10', '0303', 'From Cash In Hand To Bank Of Celyon', '5025', '0', '0', NULL, NULL),
('236', '4', '80', '2015-12-14', '0301', 'From Cash In Hand To Bank Of Celyon', '-11335', '0', '0', NULL, NULL),
('237', '4', '80', '2015-12-14', '0303', 'From Cash In Hand To Bank Of Celyon', '11335', '0', '0', NULL, NULL),
('238', '4', '81', '2016-03-31', '0301', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('239', '4', '81', '2016-03-31', '0303', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('240', '2', '11', '2015-12-16', '0254', 'Fund Transfer to golden plam', '-60926', '0', '0', NULL, NULL),
('241', '2', '11', '2015-12-16', '0303', '', '60926', '0', '0', NULL, NULL),
('242', '4', '82', '2015-12-14', '0301', 'From Cash In Hand To Bank Of Celyon', '-23406', '0', '0', NULL, NULL),
('243', '4', '82', '2015-12-14', '0303', 'From Cash In Hand To Bank Of Celyon', '23406', '0', '0', NULL, NULL),
('244', '4', '83', '2015-12-16', '0301', 'From Cash In Hand To Bank Of Celyon', '-10676', '0', '0', NULL, NULL),
('245', '4', '83', '2015-12-16', '0303', 'From Cash In Hand To Bank Of Celyon', '10676', '0', '0', NULL, NULL),
('246', '1', '24', '2015-12-17', '4350', 'Bank Charges', '400', '0', '0', NULL, NULL),
('247', '1', '24', '2015-12-17', '0303', '', '-400', '0', '0', NULL, NULL),
('248', '4', '84', '2015-12-17', '0301', 'From Cash In Hand To Bank Of Celyon', '-6340', '0', '0', NULL, NULL),
('249', '4', '84', '2015-12-17', '0303', 'From Cash In Hand To Bank Of Celyon', '6340', '0', '0', NULL, NULL),
('250', '4', '85', '2015-12-17', '0301', 'From Cash In Hand To Bank Of Celyon', '-2000', '0', '0', NULL, NULL),
('251', '4', '85', '2015-12-17', '0303', 'From Cash In Hand To Bank Of Celyon', '2000', '0', '0', NULL, NULL),
('252', '1', '25', '2015-12-18', '4350', 'Bank Charges', '750', '0', '0', NULL, NULL),
('253', '1', '25', '2015-12-18', '0303', '', '-750', '0', '0', NULL, NULL),
('254', '4', '86', '2015-12-20', '0301', 'From Cash In Hand To Bank Of Celyon', '-132229', '0', '0', NULL, NULL),
('255', '4', '86', '2015-12-20', '0303', 'From Cash In Hand To Bank Of Celyon', '132229', '0', '0', NULL, NULL),
('256', '0', '2', '2015-12-20', '0303', 'Error Correction ', '-132229', '0', '0', NULL, NULL),
('257', '0', '2', '2015-12-20', '0301', 'Error Correction ', '132229', '0', '0', NULL, NULL),
('258', '1', '26', '2015-12-21', '0001', 'Capital Expenditure', '54425', '0', '0', NULL, NULL),
('259', '1', '26', '2015-12-21', '0303', '', '-54425', '0', '0', NULL, NULL),
('260', '4', '87', '2015-12-21', '0301', 'From Cash In Hand To Bank Of Celyon', '-48187', '0', '0', NULL, NULL),
('261', '4', '87', '2015-12-21', '0303', 'From Cash In Hand To Bank Of Celyon', '48187', '0', '0', NULL, NULL),
('262', '4', '88', '2015-12-21', '0301', 'From Cash In Hand To Bank Of Celyon', '-500', '0', '0', NULL, NULL),
('263', '4', '88', '2015-12-21', '0303', 'From Cash In Hand To Bank Of Celyon', '500', '0', '0', NULL, NULL),
('264', '2', '12', '2015-12-22', '0252', 'Fund Transfer to golden plam', '-39704', '0', '0', NULL, NULL),
('265', '2', '12', '2015-12-22', '0303', '', '39704', '0', '0', NULL, NULL),
('266', '1', '27', '2015-12-22', '0001', 'Capital Expenditure', '39704', '0', '0', NULL, NULL),
('267', '1', '27', '2015-12-22', '0303', '', '-39704', '0', '0', NULL, NULL),
('268', '4', '89', '2015-12-25', '0301', 'From Cash In Hand To Bank Of Celyon', '-117783', '0', '0', NULL, NULL),
('269', '4', '89', '2015-12-25', '0303', 'From Cash In Hand To Bank Of Celyon', '117783', '0', '0', NULL, NULL),
('270', '0', '3', '2015-12-25', '0303', 'Error Correction', '-117783', '0', '0', NULL, NULL),
('271', '0', '3', '2015-12-25', '0301', 'Error Correction', '117783', '0', '0', NULL, NULL),
('272', '4', '90', '2015-12-30', '0301', 'From Cash In Hand To Bank Of Celyon', '-89416', '0', '0', NULL, NULL),
('273', '4', '90', '2015-12-30', '0303', 'From Cash In Hand To Bank Of Celyon', '89416', '0', '0', NULL, NULL),
('274', '4', '91', '2015-12-30', '0301', 'From Cash In Hand To Bank Of Celyon', '-8113', '0', '0', NULL, NULL),
('275', '4', '91', '2015-12-30', '0303', 'From Cash In Hand To Bank Of Celyon', '8113', '0', '0', NULL, NULL),
('276', '2', '13', '2015-12-31', '0252', 'Fund Transfer to golden plam', '-14105', '0', '0', NULL, NULL),
('277', '2', '13', '2015-12-31', '0303', '', '14105', '0', '0', NULL, NULL),
('278', '4', '92', '2016-01-01', '0301', 'From Cash In Hand To Bank Of Celyon', '-25788', '0', '0', NULL, NULL),
('279', '4', '92', '2016-01-01', '0303', 'From Cash In Hand To Bank Of Celyon', '25788', '0', '0', NULL, NULL),
('280', '1', '28', '2016-01-03', '0001', 'Capital Expenditure', '14105', '0', '0', NULL, NULL),
('281', '1', '28', '2016-01-03', '0303', '', '-14105', '0', '0', NULL, NULL),
('282', '2', '14', '2016-01-03', '0251', 'Fund Transfer to golden plam', '-7295', '0', '0', NULL, NULL),
('283', '2', '14', '2016-01-03', '0303', '', '7295', '0', '0', NULL, NULL),
('284', '2', '15', '2016-01-06', '0252', 'Fund Transfer to golden plam', '-24910', '0', '0', NULL, NULL),
('285', '2', '15', '2016-01-06', '0303', '', '24910', '0', '0', NULL, NULL),
('286', '1', '29', '2015-12-07', '0001', 'Capital Expenditure', '0', '0', '0', NULL, NULL),
('287', '1', '29', '2015-12-07', '0303', '', '0', '0', '0', NULL, NULL),
('288', '1', '30', '2016-01-07', '0001', 'Capital Expenditure', '24910', '0', '0', NULL, NULL),
('289', '1', '30', '2016-01-07', '0303', '', '-24910', '0', '0', NULL, NULL),
('290', '2', '16', '2016-01-07', '0254', 'Fund transfer to golden Plam', '0', '0', '0', NULL, NULL),
('291', '2', '16', '2016-01-07', '0303', '', '0', '0', '0', NULL, NULL),
('292', '2', '17', '2016-01-07', '0254', 'Fund transfer to golden Plam', '-77736', '0', '0', NULL, NULL),
('293', '2', '17', '2016-01-07', '0303', '', '77736', '0', '0', NULL, NULL),
('294', '2', '18', '2016-01-07', '0254', 'Fund transfer to golden Plam', '-126479', '0', '0', NULL, NULL),
('295', '2', '18', '2016-01-07', '0303', '', '126479', '0', '0', NULL, NULL),
('296', '4', '93', '2016-01-08', '0301', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('297', '4', '93', '2016-01-08', '0303', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('298', '4', '94', '2016-01-11', '0301', 'From Cash In Hand To Bank Of Celyon', '-25315', '0', '0', NULL, NULL),
('299', '4', '94', '2016-01-11', '0303', 'From Cash In Hand To Bank Of Celyon', '25315', '0', '0', NULL, NULL),
('300', '2', '19', '2016-01-18', '0254', 'Fund transfer to golden Plam', '-39500', '0', '0', NULL, NULL),
('301', '2', '19', '2016-01-18', '0303', '', '39500', '0', '0', NULL, NULL),
('302', '4', '95', '2016-01-19', '0301', 'From Cash In Hand To Bank Of Celyon', '-14904', '0', '0', NULL, NULL),
('303', '4', '95', '2016-01-19', '0303', 'From Cash In Hand To Bank Of Celyon', '14904', '0', '0', NULL, NULL),
('304', '4', '96', '2016-01-19', '0301', 'From Cash In Hand To Bank Of Celyon', '-11136', '0', '0', NULL, NULL),
('305', '4', '96', '2016-01-19', '0303', 'From Cash In Hand To Bank Of Celyon', '11136', '0', '0', NULL, NULL),
('306', '1', '31', '2016-01-19', '2000', 'Food Item purchased', '77736', '0', '0', NULL, NULL),
('307', '1', '31', '2016-01-19', '4162', 'Food Item purchased', '7295', '0', '0', NULL, NULL),
('308', '1', '31', '2016-01-19', '0303', '', '-85031', '0', '0', NULL, NULL),
('309', '2', '20', '2016-01-21', '0254', 'Fund transfer to golden Plam', '-31467', '0', '0', NULL, NULL),
('310', '2', '20', '2016-01-21', '0303', '', '31467', '0', '0', NULL, NULL),
('311', '4', '97', '2016-01-22', '0301', 'From Cash In Hand To Bank Of Celyon', '-13314', '0', '0', NULL, NULL),
('312', '4', '97', '2016-01-22', '0303', 'From Cash In Hand To Bank Of Celyon', '13314', '0', '0', NULL, NULL),
('313', '4', '98', '2016-01-22', '0301', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('314', '4', '98', '2016-01-22', '0303', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('315', '4', '99', '2016-01-22', '0301', 'From Cash In Hand To Bank Of Celyon', '-20', '0', '0', NULL, NULL),
('316', '4', '99', '2016-01-22', '0303', 'From Cash In Hand To Bank Of Celyon', '20', '0', '0', NULL, NULL),
('317', '1', '32', '2016-01-24', '0001', 'outlet expenses', '31467', '0', '0', NULL, NULL),
('318', '1', '32', '2016-01-24', '0303', '', '-31467', '0', '0', NULL, NULL),
('319', '4', '100', '2016-01-29', '0301', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('320', '4', '100', '2016-01-29', '0303', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('321', '4', '101', '2016-01-26', '0301', 'From Cash In Hand To Bank Of Celyon', '-600', '0', '0', NULL, NULL),
('322', '4', '101', '2016-01-26', '0303', 'From Cash In Hand To Bank Of Celyon', '600', '0', '0', NULL, NULL),
('323', '4', '102', '2016-01-25', '0301', 'From Cash In Hand To Bank Of Celyon', '-37979', '0', '0', NULL, NULL),
('324', '4', '102', '2016-01-25', '0303', 'From Cash In Hand To Bank Of Celyon', '37979', '0', '0', NULL, NULL),
('325', '4', '103', '2016-01-27', '0301', 'From Cash In Hand To Bank Of Celyon', '-17041', '0', '0', NULL, NULL),
('326', '4', '103', '2016-01-27', '0303', 'From Cash In Hand To Bank Of Celyon', '17041', '0', '0', NULL, NULL),
('327', '1', '33', '2016-01-27', '0001', 'outlet expenses', '7830', '0', '0', NULL, NULL),
('328', '1', '33', '2016-01-27', '0303', '', '-7830', '0', '0', NULL, NULL),
('329', '4', '104', '2016-02-01', '0301', 'From Cash In Hand To Bank Of Celyon', '-47450', '0', '0', NULL, NULL),
('330', '4', '104', '2016-02-01', '0303', 'From Cash In Hand To Bank Of Celyon', '47450', '0', '0', NULL, NULL),
('331', '4', '105', '2016-02-01', '0301', 'From Cash In Hand To Bank Of Celyon', '-42932', '0', '0', NULL, NULL),
('332', '4', '105', '2016-02-01', '0303', 'From Cash In Hand To Bank Of Celyon', '42932', '0', '0', NULL, NULL),
('333', '2', '21', '2016-02-01', '0254', 'Fund transfer to golden Plam', '-21252', '0', '0', NULL, NULL),
('334', '2', '21', '2016-02-01', '0303', '', '21252', '0', '0', NULL, NULL),
('335', '4', '106', '2016-02-03', '0301', 'From Cash In Hand To Bank Of Celyon', '-52975', '0', '0', NULL, NULL),
('336', '4', '106', '2016-02-03', '0303', 'From Cash In Hand To Bank Of Celyon', '52975', '0', '0', NULL, NULL),
('337', '1', '34', '2016-02-05', '4168', 'Gas tank purchased', '5980', '0', '0', NULL, NULL),
('338', '1', '34', '2016-02-05', '0303', '', '-5980', '0', '0', NULL, NULL),
('339', '4', '107', '2016-03-31', '0301', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('340', '4', '107', '2016-03-31', '0303', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('341', '2', '22', '2016-02-08', '0254', 'Fund transfer to golden Plam', '-6275', '0', '0', NULL, NULL),
('342', '2', '22', '2016-02-08', '0303', '', '6275', '0', '0', NULL, NULL),
('343', '2', '23', '2016-02-08', '0254', 'Fund transfer to golden Plam', '-8195', '0', '0', NULL, NULL),
('344', '2', '23', '2016-02-08', '0303', '', '8195', '0', '0', NULL, NULL),
('345', '4', '108', '2016-02-08', '0301', 'From Cash In Hand To Bank Of Celyon', '-750', '0', '0', NULL, NULL),
('346', '4', '108', '2016-02-08', '0303', 'From Cash In Hand To Bank Of Celyon', '750', '0', '0', NULL, NULL),
('347', '4', '109', '2016-02-09', '0301', 'From Cash In Hand To Bank Of Celyon', '-15775', '0', '0', NULL, NULL),
('348', '4', '109', '2016-02-09', '0303', 'From Cash In Hand To Bank Of Celyon', '15775', '0', '0', NULL, NULL),
('349', '1', '35', '2016-02-09', '0005', 'Equipment purchase', '10000', '0', '0', NULL, NULL),
('350', '1', '35', '2016-02-09', '0303', '', '-10000', '0', '0', NULL, NULL),
('351', '4', '110', '2016-02-11', '0301', 'From Cash In Hand To Bank Of Celyon', '-11941', '0', '0', NULL, NULL),
('352', '4', '110', '2016-02-11', '0303', 'From Cash In Hand To Bank Of Celyon', '11941', '0', '0', NULL, NULL),
('353', '4', '111', '2016-02-12', '0301', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('354', '4', '111', '2016-02-12', '0303', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('355', '4', '112', '2016-02-08', '0301', 'From Cash In Hand To Bank Of Celyon', '-51886', '0', '0', NULL, NULL),
('356', '4', '112', '2016-02-08', '0303', 'From Cash In Hand To Bank Of Celyon', '51886', '0', '0', NULL, NULL),
('357', '4', '113', '2016-02-12', '0301', 'From Cash In Hand To Bank Of Celyon', '-15674', '0', '0', NULL, NULL),
('358', '4', '113', '2016-02-12', '0303', 'From Cash In Hand To Bank Of Celyon', '15674', '0', '0', NULL, NULL),
('359', '4', '114', '2016-02-15', '0301', 'From Cash In Hand To Bank Of Celyon', '-36862', '0', '0', NULL, NULL),
('360', '4', '114', '2016-02-15', '0303', 'From Cash In Hand To Bank Of Celyon', '36862', '0', '0', NULL, NULL),
('361', '4', '115', '2016-02-16', '0301', 'From Cash In Hand To Bank Of Celyon', '-12850', '0', '0', NULL, NULL),
('362', '4', '115', '2016-02-16', '0303', 'From Cash In Hand To Bank Of Celyon', '12850', '0', '0', NULL, NULL),
('363', '4', '116', '2016-02-17', '0301', 'From Cash In Hand To Bank Of Celyon', '-11817', '0', '0', NULL, NULL),
('364', '4', '116', '2016-02-17', '0303', 'From Cash In Hand To Bank Of Celyon', '11817', '0', '0', NULL, NULL),
('365', '4', '117', '2016-02-18', '0301', 'From Cash In Hand To Bank Of Celyon', '-8470', '0', '0', NULL, NULL),
('366', '4', '117', '2016-02-18', '0303', 'From Cash In Hand To Bank Of Celyon', '8470', '0', '0', NULL, NULL),
('367', '1', '36', '2016-02-19', '0001', 'Capital expenditure', '6275', '0', '0', NULL, NULL),
('368', '1', '36', '2016-02-19', '0303', '', '-6275', '0', '0', NULL, NULL),
('369', '4', '118', '2016-02-23', '0301', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('370', '4', '118', '2016-02-23', '0303', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('371', '4', '119', '2016-02-23', '0301', 'From Cash In Hand To Bank Of Celyon', '-13970', '0', '0', NULL, NULL),
('372', '4', '119', '2016-02-23', '0303', 'From Cash In Hand To Bank Of Celyon', '13970', '0', '0', NULL, NULL),
('373', '4', '120', '2016-02-23', '0301', 'From Cash In Hand To Bank Of Celyon', '-64400', '0', '0', NULL, NULL),
('374', '4', '120', '2016-02-23', '0303', 'From Cash In Hand To Bank Of Celyon', '64400', '0', '0', NULL, NULL),
('375', '4', '121', '2016-02-25', '0301', 'From Cash In Hand To Bank Of Celyon', '-31700', '0', '0', NULL, NULL),
('376', '4', '121', '2016-02-25', '0303', 'From Cash In Hand To Bank Of Celyon', '31700', '0', '0', NULL, NULL),
('377', '4', '122', '2016-02-26', '0301', 'From Cash In Hand To Bank Of Celyon', '-19335', '0', '0', NULL, NULL),
('378', '4', '122', '2016-02-26', '0303', 'From Cash In Hand To Bank Of Celyon', '19335', '0', '0', NULL, NULL),
('379', '1', '37', '2016-02-26', '4168', 'Gas tank purchased', '4590', '0', '0', NULL, NULL),
('380', '1', '37', '2016-02-26', '0303', '', '-4590', '0', '0', NULL, NULL),
('381', '1', '38', '2016-02-26', '4167', 'other expenses', '14451', '0', '0', NULL, NULL),
('382', '1', '38', '2016-02-26', '0303', '', '-14451', '0', '0', NULL, NULL),
('383', '1', '39', '2016-02-26', '2000', 'Food Item purchased', '146960', '0', '0', NULL, NULL),
('384', '1', '39', '2016-02-26', '0303', '', '-146960', '0', '0', NULL, NULL),
('385', '4', '123', '2016-02-26', '0301', 'From Cash In Hand To Bank Of Celyon', '-15590', '0', '0', NULL, NULL),
('386', '4', '123', '2016-02-26', '0303', 'From Cash In Hand To Bank Of Celyon', '15590', '0', '0', NULL, NULL),
('387', '4', '124', '2016-03-01', '0301', 'From Cash In Hand To Bank Of Celyon', '-24460', '0', '0', NULL, NULL),
('388', '4', '124', '2016-03-01', '0303', 'From Cash In Hand To Bank Of Celyon', '24460', '0', '0', NULL, NULL),
('389', '2', '24', '2016-03-01', '0254', 'Fund transfer to golden Plam', '-83483', '0', '0', NULL, NULL),
('390', '2', '24', '2016-03-01', '0303', '', '83483', '0', '0', NULL, NULL),
('391', '4', '125', '2016-03-02', '0301', 'From Cash In Hand To Bank Of Celyon', '-38415', '0', '0', NULL, NULL),
('392', '4', '125', '2016-03-02', '0303', 'From Cash In Hand To Bank Of Celyon', '38415', '0', '0', NULL, NULL),
('393', '4', '126', '2016-03-31', '0301', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('394', '4', '126', '2016-03-31', '0303', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('395', '4', '127', '2016-03-31', '0301', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('396', '4', '127', '2016-03-31', '0303', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('397', '2', '25', '2016-03-03', '0254', 'Fund transfer to golden Plam', '-63477', '0', '0', NULL, NULL),
('398', '2', '25', '2016-03-03', '0303', '', '63477', '0', '0', NULL, NULL),
('399', '4', '128', '2016-03-31', '0301', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('400', '4', '128', '2016-03-31', '0303', 'From Cash In Hand To Bank Of Celyon', '0', '0', '0', NULL, NULL),
('401', '4', '129', '2016-03-04', '0301', 'From Cash In Hand To Bank Of Celyon', '-52557', '0', '0', NULL, NULL),
('402', '4', '129', '2016-03-04', '0303', 'From Cash In Hand To Bank Of Celyon', '52557', '0', '0', NULL, NULL),
('403', '2', '26', '2016-03-04', '0254', 'Fund transfer to golden Plam', '-30174', '0', '0', NULL, NULL),
('404', '2', '26', '2016-03-04', '0303', '', '30174', '0', '0', NULL, NULL),
('405', '4', '130', '2016-03-03', '0301', 'From Cash In Hand To Bank Of Celyon', '-11340', '0', '0', NULL, NULL),
('406', '4', '130', '2016-03-03', '0303', 'From Cash In Hand To Bank Of Celyon', '11340', '0', '0', NULL, NULL),
('407', '4', '131', '2016-03-08', '0301', 'From Cash In Hand To Bank Of Celyon', '-63197', '0', '0', NULL, NULL),
('408', '4', '131', '2016-03-08', '0303', 'From Cash In Hand To Bank Of Celyon', '63197', '0', '0', NULL, NULL),
('409', '4', '132', '2016-03-31', '0301', 'From Cash In Hand To Bank Of Celyon', '-1080', '0', '0', NULL, NULL),
('410', '4', '132', '2016-03-31', '0303', 'From Cash In Hand To Bank Of Celyon', '1080', '0', '0', NULL, NULL),
('411', '4', '133', '2016-03-10', '0301', 'From Cash In Hand To Bank Of Celyon', '-10082', '0', '0', NULL, NULL),
('412', '4', '133', '2016-03-10', '0303', 'From Cash In Hand To Bank Of Celyon', '10082', '0', '0', NULL, NULL),
('413', '4', '134', '2016-03-11', '0301', 'From Cash In Hand To Bank Of Celyon', '-14880', '0', '0', NULL, NULL),
('414', '4', '134', '2016-03-11', '0303', 'From Cash In Hand To Bank Of Celyon', '14880', '0', '0', NULL, NULL),
('415', '4', '135', '2016-03-14', '0301', 'From Cash In Hand To Bank Of Celyon', '-49270', '0', '0', NULL, NULL),
('416', '4', '135', '2016-03-14', '0303', 'From Cash In Hand To Bank Of Celyon', '49270', '0', '0', NULL, NULL),
('417', '2', '27', '2016-03-14', '0254', 'Fund transfer to golden Plam', '-128477', '0', '0', NULL, NULL),
('418', '2', '27', '2016-03-14', '0303', '', '128477', '0', '0', NULL, NULL),
('419', '4', '136', '2016-03-16', '0301', 'From Cash In Hand To Bank Of Celyon', '-25880', '0', '0', NULL, NULL),
('420', '4', '136', '2016-03-16', '0303', 'From Cash In Hand To Bank Of Celyon', '25880', '0', '0', NULL, NULL),
('421', '4', '137', '2016-03-17', '0301', 'From Cash In Hand To Bank Of Celyon', '-30110', '0', '0', NULL, NULL),
('422', '4', '137', '2016-03-17', '0303', 'From Cash In Hand To Bank Of Celyon', '30110', '0', '0', NULL, NULL),
('423', '1', '40', '2016-03-17', '2000', 'Food item purchase', '113044', '0', '0', NULL, NULL),
('424', '1', '40', '2016-03-17', '0303', '', '-113044', '0', '0', NULL, NULL),
('425', '4', '138', '2016-03-21', '0301', 'From Cash In Hand To Bank Of Celyon', '-33678', '0', '0', NULL, NULL),
('426', '4', '138', '2016-03-21', '0303', 'From Cash In Hand To Bank Of Celyon', '33678', '0', '0', NULL, NULL),
('427', '4', '139', '2016-03-23', '0301', 'From Cash In Hand To Bank Of Celyon', '-53894', '0', '0', NULL, NULL),
('428', '4', '139', '2016-03-23', '0303', 'From Cash In Hand To Bank Of Celyon', '53894', '0', '0', NULL, NULL),
('429', '4', '140', '2016-03-28', '0301', 'From Cash In Hand To Bank Of Celyon', '-43815', '0', '0', NULL, NULL),
('430', '4', '140', '2016-03-28', '0303', 'From Cash In Hand To Bank Of Celyon', '43815', '0', '0', NULL, NULL),
('431', '1', '41', '2016-03-28', '4151', 'Donation', '3000', '0', '0', NULL, NULL),
('432', '1', '41', '2016-03-28', '0303', '', '-3000', '0', '0', NULL, NULL),
('433', '4', '141', '2016-03-29', '0301', 'From Cash In Hand To Bank Of Celyon', '-18565', '0', '0', NULL, NULL),
('434', '4', '141', '2016-03-29', '0303', 'From Cash In Hand To Bank Of Celyon', '18565', '0', '0', NULL, NULL),
('435', '4', '142', '2016-03-29', '0301', 'From Cash In Hand To Bank Of Celyon', '-44727', '0', '0', NULL, NULL),
('436', '4', '142', '2016-03-29', '0303', 'From Cash In Hand To Bank Of Celyon', '44727', '0', '0', NULL, NULL),
('437', '2', '28', '2016-03-30', '0254', 'Fund transfer to golden Plam', '-27602', '0', '0', NULL, NULL),
('438', '2', '28', '2016-03-30', '0303', '', '27602', '0', '0', NULL, NULL),
('439', '2', '29', '2016-03-31', '0254', 'Fund transfer to golden Plam', '-154059', '0', '0', NULL, NULL),
('440', '2', '29', '2016-03-31', '0303', '', '154059', '0', '0', NULL, NULL),
('441', '1', '42', '2016-03-31', '4157', 'Telephone bill', '10625', '0', '0', NULL, NULL),
('442', '1', '42', '2016-03-31', '0303', '', '-10625', '0', '0', NULL, NULL),
('443', '4', '143', '2015-08-13', '0303', 'From Bank Of Celyon To Sampath Bank', '-155597', '0', '0', NULL, NULL),
('444', '4', '143', '2015-08-13', '0300', 'From Bank Of Celyon To Sampath Bank', '155597', '0', '0', NULL, NULL),
('445', '4', '144', '2015-08-24', '0300', 'From Sampath Bank To Bank Of Celyon', '-96626', '0', '0', NULL, NULL),
('446', '4', '144', '2015-08-24', '0303', 'From Sampath Bank To Bank Of Celyon', '96626', '0', '0', NULL, NULL),
('447', '4', '145', '2015-08-25', '0303', 'From Bank Of Celyon To Sampath Bank', '-73715', '0', '0', NULL, NULL),
('448', '4', '145', '2015-08-25', '0300', 'From Bank Of Celyon To Sampath Bank', '73715', '0', '0', NULL, NULL),
('449', '4', '146', '2015-08-28', '0303', 'From Bank Of Celyon To Sampath Bank', '-59700', '0', '0', NULL, NULL),
('450', '4', '146', '2015-08-28', '0300', 'From Bank Of Celyon To Sampath Bank', '59700', '0', '0', NULL, NULL),
('451', '4', '147', '2015-09-01', '0300', 'From Sampath Bank To Bank Of Celyon', '-3415', '0', '0', NULL, NULL),
('452', '4', '147', '2015-09-01', '0303', 'From Sampath Bank To Bank Of Celyon', '3415', '0', '0', NULL, NULL),
('453', '4', '148', '2015-09-02', '0300', 'From Sampath Bank To Bank Of Celyon', '-14825', '0', '0', NULL, NULL),
('454', '4', '148', '2015-09-02', '0303', 'From Sampath Bank To Bank Of Celyon', '14825', '0', '0', NULL, NULL),
('455', '4', '149', '2015-09-09', '0300', 'From Sampath Bank To Bank Of Celyon', '-8500', '0', '0', NULL, NULL),
('456', '4', '149', '2015-09-09', '0303', 'From Sampath Bank To Bank Of Celyon', '8500', '0', '0', NULL, NULL),
('457', '4', '150', '2016-03-31', '0303', 'From Bank Of Celyon To Sampath Bank', '0', '0', '0', NULL, NULL),
('458', '4', '150', '2016-03-31', '0300', 'From Bank Of Celyon To Sampath Bank', '0', '0', '0', NULL, NULL),
('459', '4', '151', '2015-09-25', '0303', 'From Bank Of Celyon To Sampath Bank', '-85700', '0', '0', NULL, NULL),
('460', '4', '151', '2015-09-25', '0300', 'From Bank Of Celyon To Sampath Bank', '85700', '0', '0', NULL, NULL),
('461', '4', '152', '2015-10-09', '0303', 'From Bank Of Celyon To Sampath Bank', '-143258', '0', '0', NULL, NULL),
('462', '4', '152', '2015-10-09', '0300', 'From Bank Of Celyon To Sampath Bank', '143258', '0', '0', NULL, NULL),
('463', '4', '153', '2015-10-12', '0300', 'From Sampath Bank To Bank Of Celyon', '-8500', '0', '0', NULL, NULL),
('464', '4', '153', '2015-10-12', '0303', 'From Sampath Bank To Bank Of Celyon', '8500', '0', '0', NULL, NULL),
('465', '4', '154', '2015-10-22', '0303', 'From Bank Of Celyon To Sampath Bank', '-62015', '0', '0', NULL, NULL),
('466', '4', '154', '2015-10-22', '0300', 'From Bank Of Celyon To Sampath Bank', '62015', '0', '0', NULL, NULL),
('467', '4', '155', '2016-03-31', '0303', 'From Bank Of Celyon To Sampath Bank', '0', '0', '0', NULL, NULL),
('468', '4', '155', '2016-03-31', '0300', 'From Bank Of Celyon To Sampath Bank', '0', '0', '0', NULL, NULL),
('469', '4', '156', '2015-11-12', '0303', 'From Bank Of Celyon To Sampath Bank', '-71838', '0', '0', NULL, NULL),
('470', '4', '156', '2015-11-12', '0300', 'From Bank Of Celyon To Sampath Bank', '71838', '0', '0', NULL, NULL),
('471', '4', '157', '2015-11-20', '0303', 'From Bank Of Celyon To Sampath Bank', '-42872', '0', '0', NULL, NULL),
('472', '4', '157', '2015-11-20', '0300', 'From Bank Of Celyon To Sampath Bank', '42872', '0', '0', NULL, NULL),
('473', '4', '158', '2015-12-01', '0303', 'From Bank Of Celyon To Sampath Bank', '-97265', '0', '0', NULL, NULL),
('474', '4', '158', '2015-12-01', '0300', 'From Bank Of Celyon To Sampath Bank', '97265', '0', '0', NULL, NULL),
('475', '4', '159', '2015-12-09', '0303', 'From Bank Of Celyon To Petty Cash', '-11335', '0', '0', NULL, NULL),
('476', '4', '159', '2015-12-09', '0302', 'From Bank Of Celyon To Petty Cash', '11335', '0', '0', NULL, NULL),
('477', '1', '43', '2015-12-09', '2000', 'Food Item purchased', '90978', '0', '0', NULL, NULL),
('478', '1', '43', '2015-12-09', '0303', '', '-90978', '0', '0', NULL, NULL),
('479', '4', '160', '2015-12-14', '0303', 'From Bank Of Celyon To Sampath Bank', '-91789', '0', '0', NULL, NULL),
('480', '4', '160', '2015-12-14', '0300', 'From Bank Of Celyon To Sampath Bank', '91789', '0', '0', NULL, NULL),
('481', '4', '161', '2015-12-18', '0303', 'From Bank Of Celyon To Sampath Bank', '-48922', '0', '0', NULL, NULL),
('482', '4', '161', '2015-12-18', '0300', 'From Bank Of Celyon To Sampath Bank', '48922', '0', '0', NULL, NULL),
('483', '4', '162', '2015-12-31', '0303', 'From Bank Of Celyon To Sampath Bank', '-146216', '0', '0', NULL, NULL),
('484', '4', '162', '2015-12-31', '0300', 'From Bank Of Celyon To Sampath Bank', '146216', '0', '0', NULL, NULL),
('485', '4', '163', '2016-01-19', '0303', 'From Bank Of Celyon To Sampath Bank', '-140343', '0', '0', NULL, NULL),
('486', '4', '163', '2016-01-19', '0300', 'From Bank Of Celyon To Sampath Bank', '140343', '0', '0', NULL, NULL),
('487', '4', '164', '2016-01-22', '0303', 'From Bank Of Celyon To Petty Cash', '-18740', '0', '0', NULL, NULL),
('488', '4', '164', '2016-01-22', '0302', 'From Bank Of Celyon To Petty Cash', '18740', '0', '0', NULL, NULL),
('489', '1', '44', '2016-01-22', '4153', 'Electricity bill payment', '46088', '0', '0', NULL, NULL),
('490', '1', '44', '2016-01-22', '0001', 'outlet expenses', '47445', '0', '0', NULL, NULL);
INSERT INTO `6_gl_trans` VALUES
('491', '1', '44', '2016-01-22', '0303', '', '-93533', '0', '0', NULL, NULL),
('492', '4', '165', '2016-01-31', '0303', 'From Bank Of Celyon To Sampath Bank', '-68954', '0', '0', NULL, NULL),
('493', '4', '165', '2016-01-31', '0300', 'From Bank Of Celyon To Sampath Bank', '68954', '0', '0', NULL, NULL),
('494', '4', '166', '2016-02-05', '0303', 'From Bank Of Celyon To Sampath Bank', '-98122', '0', '0', NULL, NULL),
('495', '4', '166', '2016-02-05', '0300', 'From Bank Of Celyon To Sampath Bank', '98122', '0', '0', NULL, NULL),
('496', '4', '167', '2016-02-08', '0301', 'From Cash In Hand To Bank Of Celyon', '-51886', '0', '0', NULL, NULL),
('497', '4', '167', '2016-02-08', '0303', 'From Cash In Hand To Bank Of Celyon', '51886', '0', '0', NULL, NULL),
('498', '4', '168', '2016-02-15', '0303', 'From Bank Of Celyon To Sampath Bank', '-95616', '0', '0', NULL, NULL),
('499', '4', '168', '2016-02-15', '0300', 'From Bank Of Celyon To Sampath Bank', '95616', '0', '0', NULL, NULL),
('500', '4', '169', '2016-02-16', '0303', 'From Bank Of Celyon To Petty Cash', '-12594', '0', '0', NULL, NULL),
('501', '4', '169', '2016-02-16', '0302', 'From Bank Of Celyon To Petty Cash', '12594', '0', '0', NULL, NULL),
('502', '1', '45', '2016-02-16', '4169', 'staff transport', '8500', '0', '0', NULL, NULL),
('503', '1', '45', '2016-02-16', '0303', '', '-8500', '0', '0', NULL, NULL),
('504', '4', '170', '2016-02-25', '0303', 'From Bank Of Celyon To Sampath Bank', '-180069', '0', '0', NULL, NULL),
('505', '4', '170', '2016-02-25', '0300', 'From Bank Of Celyon To Sampath Bank', '180069', '0', '0', NULL, NULL),
('506', '4', '171', '2016-03-08', '0303', 'From Bank Of Celyon To Sampath Bank', '-166177', '0', '0', NULL, NULL),
('507', '4', '171', '2016-03-08', '0300', 'From Bank Of Celyon To Sampath Bank', '166177', '0', '0', NULL, NULL),
('508', '4', '172', '2016-03-17', '0303', 'From Bank Of Celyon To Sampath Bank', '-194500', '0', '0', NULL, NULL),
('509', '4', '172', '2016-03-17', '0300', 'From Bank Of Celyon To Sampath Bank', '194500', '0', '0', NULL, NULL),
('510', '4', '173', '2016-03-23', '0303', 'From Bank Of Celyon To Sampath Bank', '-87572', '0', '0', NULL, NULL),
('511', '4', '173', '2016-03-23', '0300', 'From Bank Of Celyon To Sampath Bank', '87572', '0', '0', NULL, NULL),
('512', '4', '174', '2016-03-29', '0303', 'From Bank Of Celyon To Sampath Bank', '-66560', '0', '0', NULL, NULL),
('513', '4', '174', '2016-03-29', '0300', 'From Bank Of Celyon To Sampath Bank', '66560', '0', '0', NULL, NULL),
('514', '4', '175', '2016-03-29', '0303', 'From Bank Of Celyon To Petty Cash', '-34059', '0', '0', NULL, NULL),
('515', '4', '175', '2016-03-29', '0302', 'From Bank Of Celyon To Petty Cash', '34059', '0', '0', NULL, NULL),
('516', '1', '46', '2016-03-29', '4159', 'Festival Advance', '120000', '0', '0', NULL, NULL),
('517', '1', '46', '2016-03-29', '0303', '', '-120000', '0', '0', NULL, NULL),
('518', '4', '176', '2016-03-23', '0303', 'From Bank Of Celyon To Petty Cash', '-23449', '0', '0', NULL, NULL),
('519', '4', '176', '2016-03-23', '0302', 'From Bank Of Celyon To Petty Cash', '23449', '0', '0', NULL, NULL),
('520', '1', '47', '2016-03-23', '4169', 'staff transport', '10100', '0', '0', NULL, NULL),
('521', '1', '47', '2016-03-23', '0005', 'Equipment purchase', '15000', '0', '0', NULL, NULL),
('522', '1', '47', '2016-03-23', '0303', '', '-25100', '0', '0', NULL, NULL),
('523', '4', '177', '2016-03-11', '0303', 'From Bank Of Celyon To Petty Cash', '-15433', '0', '0', NULL, NULL),
('524', '4', '177', '2016-03-11', '0302', 'From Bank Of Celyon To Petty Cash', '15433', '0', '0', NULL, NULL),
('525', '4', '178', '2016-03-08', '0303', 'From Bank Of Celyon To Petty Cash', '-29910', '0', '0', NULL, NULL),
('526', '4', '178', '2016-03-08', '0302', 'From Bank Of Celyon To Petty Cash', '29910', '0', '0', NULL, NULL),
('527', '1', '48', '2016-03-08', '4153', 'Electricity bill payment', '11783', '0', '0', NULL, NULL),
('528', '1', '48', '2016-03-08', '0303', '', '-11783', '0', '0', NULL, NULL),
('529', '1', '49', '2015-08-26', '4168', 'Gas Tank Purchased', '10440', '0', '0', NULL, NULL),
('530', '1', '49', '2015-08-26', '0303', '', '-10440', '0', '0', NULL, NULL),
('531', '4', '179', '2015-09-10', '0303', 'From Bank Of Celyon To Sampath Bank', '-146980', '0', '0', NULL, NULL),
('532', '4', '179', '2015-09-10', '0300', 'From Bank Of Celyon To Sampath Bank', '146980', '0', '0', NULL, NULL),
('533', '4', '180', '2015-11-02', '0303', 'From Bank Of Celyon To Sampath Bank', '-56607', '0', '0', NULL, NULL),
('534', '4', '180', '2015-11-02', '0300', 'From Bank Of Celyon To Sampath Bank', '56607', '0', '0', NULL, NULL),
('535', '4', '181', '2016-01-08', '0301', 'From Cash In Hand To Bank Of Celyon', '-18110', '0', '0', NULL, NULL),
('536', '4', '181', '2016-01-08', '0303', 'From Cash In Hand To Bank Of Celyon', '18110', '0', '0', NULL, NULL),
('537', '4', '182', '2016-02-08', '0303', 'From Bank Of Celyon To Cash In Hand', '-51886', '0', '0', NULL, NULL),
('538', '4', '182', '2016-02-08', '0301', 'From Bank Of Celyon To Cash In Hand', '51886', '0', '0', NULL, NULL),
('539', '0', '4', '2015-04-01', '0301', 'Opening Balance', '92209', '0', '0', NULL, NULL),
('540', '0', '4', '2015-04-01', '3400', 'Opening Balance', '-95700.26', '0', '0', NULL, NULL),
('541', '0', '4', '2015-04-01', '0300', 'Opening Balance', '259938.26', '0', '0', NULL, NULL),
('542', '0', '4', '2015-04-01', '0302', 'Opening Balance', '3000', '0', '0', NULL, NULL),
('543', '0', '4', '2015-04-01', '0003', 'Opening Balance', '15474630', '0', '0', NULL, NULL),
('544', '0', '4', '2015-04-01', '0351', 'Opening Balance', '-97214', '0', '0', NULL, NULL),
('545', '0', '4', '2015-04-01', '0352', 'Opening Balance', '-14582', '0', '0', NULL, NULL),
('546', '0', '4', '2015-04-01', '0353', 'Opening Balance', '-2057', '0', '0', NULL, NULL),
('547', '0', '4', '2015-04-01', '0252', 'Opening Balance', '-10596148', '0', '0', NULL, NULL),
('548', '0', '4', '2015-04-01', '3500', 'Opening Balance', '512039', '0', '0', NULL, NULL),
('549', '0', '4', '2015-04-01', '0254', 'Opening Balance', '-4474138', '0', '0', NULL, NULL),
('550', '0', '4', '2015-04-01', '3500', 'Opening Balance', '216017', '0', '0', NULL, NULL),
('551', '0', '4', '2015-04-01', '4050', 'Opening Balance', '-1350000', '0', '0', NULL, NULL),
('552', '0', '4', '2015-04-01', '3500', 'Opening Balance', '72006', '0', '0', NULL, NULL),
('553', '4', '183', '2015-04-02', '0301', 'From Cash In Hand To Sampath Bank', '-34044', '0', '0', NULL, NULL),
('554', '4', '183', '2015-04-02', '0300', 'From Cash In Hand To Sampath Bank', '34044', '0', '0', NULL, NULL),
('555', '4', '184', '2015-04-02', '0301', 'From Cash In Hand To Sampath Bank', '-38100', '0', '0', NULL, NULL),
('556', '4', '184', '2015-04-02', '0300', 'From Cash In Hand To Sampath Bank', '38100', '0', '0', NULL, NULL),
('557', '4', '185', '2015-04-24', '0301', 'From Cash In Hand To Sampath Bank', '-61278', '0', '0', NULL, NULL),
('558', '4', '185', '2015-04-24', '0300', 'From Cash In Hand To Sampath Bank', '61278', '0', '0', NULL, NULL),
('559', '4', '186', '2015-04-30', '0301', 'From Cash In Hand To Sampath Bank', '-82200', '0', '0', NULL, NULL),
('560', '4', '186', '2015-04-30', '0300', 'From Cash In Hand To Sampath Bank', '82200', '0', '0', NULL, NULL),
('561', '4', '187', '2015-05-14', '0301', 'From Cash In Hand To Sampath Bank', '-69120', '0', '0', NULL, NULL),
('562', '4', '187', '2015-05-14', '0300', 'From Cash In Hand To Sampath Bank', '69120', '0', '0', NULL, NULL),
('563', '4', '188', '2015-05-22', '0301', 'From Cash In Hand To Sampath Bank', '-2770', '0', '0', NULL, NULL),
('564', '4', '188', '2015-05-22', '0300', 'From Cash In Hand To Sampath Bank', '2770', '0', '0', NULL, NULL),
('565', '4', '189', '2015-05-30', '0301', 'From Cash In Hand To Sampath Bank', '-53500', '0', '0', NULL, NULL),
('566', '4', '189', '2015-05-30', '0300', 'From Cash In Hand To Sampath Bank', '53500', '0', '0', NULL, NULL),
('567', '4', '190', '2015-05-31', '0301', 'From Cash In Hand To Sampath Bank', '-49960', '0', '0', NULL, NULL),
('568', '4', '190', '2015-05-31', '0300', 'From Cash In Hand To Sampath Bank', '49960', '0', '0', NULL, NULL),
('569', '4', '191', '2016-03-31', '0301', 'From Cash In Hand To Sampath Bank', '0', '0', '0', NULL, NULL),
('570', '4', '191', '2016-03-31', '0300', 'From Cash In Hand To Sampath Bank', '0', '0', '0', NULL, NULL),
('571', '4', '192', '2015-06-12', '0301', 'From Cash In Hand To Sampath Bank', '-2340', '0', '0', NULL, NULL),
('572', '4', '192', '2015-06-12', '0300', 'From Cash In Hand To Sampath Bank', '2340', '0', '0', NULL, NULL),
('573', '4', '193', '2015-06-18', '0301', 'From Cash In Hand To Sampath Bank', '-156092', '0', '0', NULL, NULL),
('574', '4', '193', '2015-06-18', '0300', 'From Cash In Hand To Sampath Bank', '156092', '0', '0', NULL, NULL),
('575', '4', '194', '2015-06-24', '0301', 'From Cash In Hand To Sampath Bank', '-61410', '0', '0', NULL, NULL),
('576', '4', '194', '2015-06-24', '0300', 'From Cash In Hand To Sampath Bank', '61410', '0', '0', NULL, NULL),
('577', '4', '195', '2015-06-29', '0301', 'From Cash In Hand To Sampath Bank', '-160', '0', '0', NULL, NULL),
('578', '4', '195', '2015-06-29', '0300', 'From Cash In Hand To Sampath Bank', '160', '0', '0', NULL, NULL),
('579', '4', '196', '2015-07-06', '0301', 'From Cash In Hand To Sampath Bank', '-93270', '0', '0', NULL, NULL),
('580', '4', '196', '2015-07-06', '0300', 'From Cash In Hand To Sampath Bank', '93270', '0', '0', NULL, NULL),
('581', '4', '197', '2015-07-14', '0301', 'From Cash In Hand To Sampath Bank', '-56334', '0', '0', NULL, NULL),
('582', '4', '197', '2015-07-14', '0300', 'From Cash In Hand To Sampath Bank', '56334', '0', '0', NULL, NULL),
('583', '4', '198', '2015-07-31', '0301', 'From Cash In Hand To Sampath Bank', '-55830', '0', '0', NULL, NULL),
('584', '4', '198', '2015-07-31', '0300', 'From Cash In Hand To Sampath Bank', '55830', '0', '0', NULL, NULL),
('585', '4', '199', '2015-08-28', '0301', 'From Cash In Hand To Sampath Bank', '-520', '0', '0', NULL, NULL),
('586', '4', '199', '2015-08-28', '0300', 'From Cash In Hand To Sampath Bank', '520', '0', '0', NULL, NULL),
('587', '4', '200', '2015-12-01', '0301', 'From Cash In Hand To Sampath Bank', '-50000', '0', '0', NULL, NULL),
('588', '4', '200', '2015-12-01', '0300', 'From Cash In Hand To Sampath Bank', '50000', '0', '0', NULL, NULL),
('589', '4', '201', '2015-12-17', '0301', 'From Cash In Hand To Sampath Bank', '-50000', '0', '0', NULL, NULL),
('590', '4', '201', '2015-12-17', '0300', 'From Cash In Hand To Sampath Bank', '50000', '0', '0', NULL, NULL),
('591', '4', '202', '2016-01-21', '0301', 'From Cash In Hand To Sampath Bank', '-39320', '0', '0', NULL, NULL),
('592', '4', '202', '2016-01-21', '0300', 'From Cash In Hand To Sampath Bank', '39320', '0', '0', NULL, NULL),
('593', '4', '203', '2016-01-22', '0301', 'From Cash In Hand To Sampath Bank', '-30000', '0', '0', NULL, NULL),
('594', '4', '203', '2016-01-22', '0300', 'From Cash In Hand To Sampath Bank', '30000', '0', '0', NULL, NULL),
('595', '10', '1', '2015-04-30', '4100', '', '0', '0', '0', NULL, NULL),
('596', '10', '1', '2015-04-30', '0250', '', '0', '0', '0', '2', '3'),
('597', '10', '1', '2015-04-30', '0001', '', '0', '0', '0', NULL, NULL),
('598', '12', '1', '2015-04-30', '0301', '', '0', '0', '0', NULL, NULL),
('599', '12', '1', '2015-04-30', '0250', '', '0', '0', '0', '2', '3'),
('600', '10', '2', '2015-04-30', '4100', '', '0', '0', '0', NULL, NULL),
('601', '10', '2', '2015-04-30', '0250', '', '0', '0', '0', '2', '3'),
('602', '10', '2', '2015-04-30', '0001', '', '0', '0', '0', NULL, NULL),
('603', '12', '2', '2015-04-30', '0301', '', '0', '0', '0', NULL, NULL),
('604', '12', '2', '2015-04-30', '0250', '', '0', '0', '0', '2', '3'),
('605', '12', '2', '2015-04-30', '0301', '', '0', '0', '0', NULL, NULL),
('606', '12', '2', '2015-04-30', '0250', '', '0', '0', '0', '2', '3'),
('607', '10', '3', '2016-03-31', '4100', '', '0', '0', '0', NULL, NULL),
('608', '10', '3', '2016-03-31', '0250', '', '0', '0', '0', '2', '3'),
('609', '10', '3', '2016-03-31', '0001', '', '0', '0', '0', NULL, NULL),
('610', '12', '3', '2016-03-31', '0301', '', '0', '0', '0', NULL, NULL),
('611', '12', '3', '2016-03-31', '0250', '', '0', '0', '0', '2', '3'),
('612', '10', '4', '2016-03-31', '4100', '', '0', '0', '0', NULL, NULL),
('613', '10', '4', '2016-03-31', '0250', '', '0', '0', '0', '2', '3'),
('614', '12', '4', '2016-03-31', '0301', '', '0', '0', '0', NULL, NULL),
('615', '12', '4', '2016-03-31', '0250', '', '0', '0', '0', '2', '3'),
('616', '12', '1', '2015-04-30', '0301', '', '1', '0', '0', NULL, NULL),
('617', '12', '1', '2015-04-30', '0250', '', '-1', '0', '0', '2', '3'),
('618', '12', '2', '2015-04-30', '0301', '', '1', '0', '0', NULL, NULL),
('619', '12', '2', '2015-04-30', '0250', '', '-1', '0', '0', '2', '3'),
('620', '10', '5', '2015-04-30', '4100', '', '-272659', '0', '0', NULL, NULL),
('621', '10', '5', '2015-04-30', '0250', '', '272659', '0', '0', '2', '3'),
('622', '12', '5', '2015-04-30', '0301', '', '272659', '0', '0', NULL, NULL),
('623', '12', '5', '2015-04-30', '0250', '', '-272659', '0', '0', '2', '3'),
('624', '10', '6', '2015-05-31', '4100', '', '-303185', '0', '0', NULL, NULL),
('625', '10', '6', '2015-05-31', '0250', '', '303185', '0', '0', '2', '3'),
('626', '12', '6', '2015-05-31', '0301', '', '303185', '0', '0', NULL, NULL),
('627', '12', '6', '2015-05-31', '0250', '', '-303185', '0', '0', '2', '3'),
('628', '10', '7', '2015-06-30', '4100', '', '-322814', '0', '0', NULL, NULL),
('629', '10', '7', '2015-06-30', '0250', '', '322814', '0', '0', '2', '3'),
('630', '12', '7', '2015-06-30', '0301', '', '322814', '0', '0', NULL, NULL),
('631', '12', '7', '2015-06-30', '0250', '', '-322814', '0', '0', '2', '3'),
('632', '10', '8', '2015-07-03', '4100', '', '-20200', '0', '0', NULL, NULL),
('633', '10', '8', '2015-07-03', '4100', '', '-6705', '0', '0', NULL, NULL),
('634', '10', '8', '2015-07-03', '0250', '', '26905', '0', '0', '2', '3'),
('635', '12', '8', '2015-07-03', '0301', '', '26905', '0', '0', NULL, NULL),
('636', '12', '8', '2015-07-03', '0250', '', '-26905', '0', '0', '2', '3'),
('637', '10', '9', '2015-07-10', '4100', '', '-62453', '0', '0', NULL, NULL),
('638', '10', '9', '2015-07-10', '0250', '', '62453', '0', '0', '2', '3'),
('639', '12', '9', '2015-07-10', '0301', '', '62453', '0', '0', NULL, NULL),
('640', '12', '9', '2015-07-10', '0250', '', '-62453', '0', '0', '2', '3'),
('641', '10', '10', '2015-07-17', '4100', '', '-62364', '0', '0', NULL, NULL),
('642', '10', '10', '2015-07-17', '0250', '', '62364', '0', '0', '2', '3'),
('643', '12', '10', '2015-07-17', '0301', '', '62364', '0', '0', NULL, NULL),
('644', '12', '10', '2015-07-17', '0250', '', '-62364', '0', '0', '2', '3'),
('645', '10', '11', '2015-07-24', '4100', '', '-61302', '0', '0', NULL, NULL),
('646', '10', '11', '2015-07-24', '0250', '', '61302', '0', '0', '2', '3'),
('647', '12', '11', '2015-07-24', '0301', '', '61302', '0', '0', NULL, NULL),
('648', '12', '11', '2015-07-24', '0250', '', '-61302', '0', '0', '2', '3'),
('649', '10', '12', '2015-07-31', '4100', '', '-79320', '0', '0', NULL, NULL),
('650', '10', '12', '2015-07-31', '0250', '', '79320', '0', '0', '2', '3'),
('651', '12', '12', '2015-07-31', '0301', '', '79320', '0', '0', NULL, NULL),
('652', '12', '12', '2015-07-31', '0250', '', '-79320', '0', '0', '2', '3'),
('653', '10', '13', '2015-08-07', '4100', '', '-62403', '0', '0', NULL, NULL),
('654', '10', '13', '2015-08-07', '4100', '', '-9645', '0', '0', NULL, NULL),
('655', '10', '13', '2015-08-07', '0250', '', '72048', '0', '0', '2', '3'),
('656', '12', '13', '2015-08-07', '0301', '', '72048', '0', '0', NULL, NULL),
('657', '12', '13', '2015-08-07', '0250', '', '-72048', '0', '0', '2', '3'),
('658', '10', '14', '2015-08-14', '4100', '', '-74651', '0', '0', NULL, NULL),
('659', '10', '14', '2015-08-14', '0250', '', '74651', '0', '0', '2', '3'),
('660', '12', '14', '2015-08-14', '0301', '', '74651', '0', '0', NULL, NULL),
('661', '12', '14', '2015-08-14', '0250', '', '-74651', '0', '0', '2', '3'),
('662', '10', '15', '2015-08-21', '4100', '', '-67860', '0', '0', NULL, NULL),
('663', '10', '15', '2015-08-21', '0250', '', '67860', '0', '0', '2', '3'),
('664', '12', '15', '2015-08-21', '0301', '', '67860', '0', '0', NULL, NULL),
('665', '12', '15', '2015-08-21', '0250', '', '-67860', '0', '0', '2', '3'),
('666', '10', '16', '2015-08-28', '4100', '', '-80505', '0', '0', NULL, NULL),
('667', '10', '16', '2015-08-28', '0250', '', '80505', '0', '0', '2', '3'),
('668', '12', '16', '2015-08-28', '0301', '', '80505', '0', '0', NULL, NULL),
('669', '12', '16', '2015-08-28', '0250', '', '-80505', '0', '0', '2', '3'),
('670', '10', '17', '2015-08-31', '4100', '', '-48025', '0', '0', NULL, NULL),
('671', '10', '17', '2015-08-31', '0250', '', '48025', '0', '0', '2', '3'),
('672', '12', '17', '2015-08-31', '0301', '', '48025', '0', '0', NULL, NULL),
('673', '12', '17', '2015-08-31', '0250', '', '-48025', '0', '0', '2', '3'),
('674', '10', '18', '2015-09-04', '4100', '', '-41292', '0', '0', NULL, NULL),
('675', '10', '18', '2015-09-04', '4100', '', '-7315', '0', '0', NULL, NULL),
('676', '10', '18', '2015-09-04', '0250', '', '48607', '0', '0', '2', '3'),
('677', '12', '18', '2015-09-04', '0301', '', '48607', '0', '0', NULL, NULL),
('678', '12', '18', '2015-09-04', '0250', '', '-48607', '0', '0', '2', '3'),
('679', '10', '19', '2015-09-11', '4100', '', '-74533', '0', '0', NULL, NULL),
('680', '10', '19', '2015-09-11', '0250', '', '74533', '0', '0', '2', '3'),
('681', '12', '19', '2015-09-11', '0301', '', '74533', '0', '0', NULL, NULL),
('682', '12', '19', '2015-09-11', '0250', '', '-74533', '0', '0', '2', '3'),
('683', '10', '20', '2015-09-18', '4100', '', '-79045', '0', '0', NULL, NULL),
('684', '10', '20', '2015-09-18', '0250', '', '79045', '0', '0', '2', '3'),
('685', '12', '20', '2015-09-18', '0301', '', '79045', '0', '0', NULL, NULL),
('686', '12', '20', '2015-09-18', '0250', '', '-79045', '0', '0', '2', '3'),
('687', '10', '21', '2015-09-25', '4100', '', '-86405', '0', '0', NULL, NULL),
('688', '10', '21', '2015-09-25', '0250', '', '86405', '0', '0', '2', '3'),
('689', '12', '21', '2015-09-25', '0301', '', '86405', '0', '0', NULL, NULL),
('690', '12', '21', '2015-09-25', '0250', '', '-86405', '0', '0', '2', '3'),
('691', '10', '22', '2015-09-30', '4100', '', '-60248', '0', '0', NULL, NULL),
('692', '10', '22', '2015-09-30', '0250', '', '60248', '0', '0', '2', '3'),
('693', '12', '22', '2015-09-30', '0301', '', '60248', '0', '0', NULL, NULL),
('694', '12', '22', '2015-09-30', '0250', '', '-60248', '0', '0', '2', '3'),
('695', '10', '23', '2015-10-04', '4100', '', '-14500', '0', '0', NULL, NULL),
('696', '10', '23', '2015-10-04', '4100', '', '-8510', '0', '0', NULL, NULL),
('697', '10', '23', '2015-10-04', '0250', '', '23010', '0', '0', '2', '3'),
('698', '12', '23', '2015-10-04', '0301', '', '23010', '0', '0', NULL, NULL),
('699', '12', '23', '2015-10-04', '0250', '', '-23010', '0', '0', '2', '3'),
('700', '10', '24', '2015-10-09', '4100', '', '-91729', '0', '0', NULL, NULL),
('701', '10', '24', '2015-10-09', '0250', '', '91729', '0', '0', '2', '3'),
('702', '12', '24', '2015-10-09', '0301', '', '91729', '0', '0', NULL, NULL),
('703', '12', '24', '2015-10-09', '0250', '', '-91729', '0', '0', '2', '3'),
('704', '10', '25', '2015-10-16', '4100', '', '-63100', '0', '0', NULL, NULL),
('705', '10', '25', '2015-10-16', '0250', '', '63100', '0', '0', '2', '3'),
('706', '12', '25', '2015-10-16', '0301', '', '63100', '0', '0', NULL, NULL),
('707', '12', '25', '2015-10-16', '0250', '', '-63100', '0', '0', '2', '3'),
('708', '10', '26', '2015-10-23', '4100', '', '-76586', '0', '0', NULL, NULL),
('709', '10', '26', '2015-10-23', '0250', '', '76586', '0', '0', '2', '3'),
('710', '12', '26', '2015-10-23', '0301', '', '76586', '0', '0', NULL, NULL),
('711', '12', '26', '2015-10-23', '0250', '', '-76586', '0', '0', '2', '3'),
('712', '10', '27', '2015-10-31', '4100', '', '-73678', '0', '0', NULL, NULL),
('713', '10', '27', '2015-10-31', '0250', '', '73678', '0', '0', '2', '3'),
('714', '12', '27', '2015-10-31', '0301', '', '73678', '0', '0', NULL, NULL),
('715', '12', '27', '2015-10-31', '0250', '', '-73678', '0', '0', '2', '3'),
('716', '10', '28', '2015-11-06', '4100', '', '-44235', '0', '0', NULL, NULL),
('717', '10', '28', '2015-11-06', '4100', '', '-6140', '0', '0', NULL, NULL),
('718', '10', '28', '2015-11-06', '0250', '', '50375', '0', '0', '2', '3'),
('719', '12', '28', '2015-11-06', '0301', '', '50375', '0', '0', NULL, NULL),
('720', '12', '28', '2015-11-06', '0250', '', '-50375', '0', '0', '2', '3'),
('721', '10', '29', '2015-11-13', '4100', '', '-65880', '0', '0', NULL, NULL),
('722', '10', '29', '2015-11-13', '0250', '', '65880', '0', '0', '2', '3'),
('723', '12', '29', '2015-11-13', '0301', '', '65880', '0', '0', NULL, NULL),
('724', '12', '29', '2015-11-13', '0250', '', '-65880', '0', '0', '2', '3'),
('725', '10', '30', '2015-11-20', '4100', '', '-68189', '0', '0', NULL, NULL),
('726', '10', '30', '2015-11-20', '0250', '', '68189', '0', '0', '2', '3'),
('727', '12', '30', '2015-11-20', '0301', '', '68189', '0', '0', NULL, NULL),
('728', '12', '30', '2015-11-20', '0250', '', '-68189', '0', '0', '2', '3'),
('729', '10', '31', '2015-11-27', '4100', '', '-89000', '0', '0', NULL, NULL),
('730', '10', '31', '2015-11-27', '0250', '', '89000', '0', '0', '2', '3'),
('731', '12', '31', '2015-11-27', '0301', '', '89000', '0', '0', NULL, NULL),
('732', '12', '31', '2015-11-27', '0250', '', '-89000', '0', '0', '2', '3'),
('733', '10', '32', '2015-11-30', '4100', '', '-40958', '0', '0', NULL, NULL),
('734', '10', '32', '2015-11-30', '0250', '', '40958', '0', '0', '2', '3'),
('735', '12', '32', '2015-11-30', '0301', '', '40958', '0', '0', NULL, NULL),
('736', '12', '32', '2015-11-30', '0250', '', '-40958', '0', '0', '2', '3'),
('737', '10', '33', '2015-12-04', '4100', '', '-47669', '0', '0', NULL, NULL),
('738', '10', '33', '2015-12-04', '4100', '', '-6255', '0', '0', NULL, NULL),
('739', '10', '33', '2015-12-04', '0250', '', '53924', '0', '0', '2', '3'),
('740', '12', '33', '2015-12-04', '0301', '', '53924', '0', '0', NULL, NULL),
('741', '12', '33', '2015-12-04', '0250', '', '-53924', '0', '0', '2', '3'),
('742', '10', '34', '2015-12-11', '4100', '', '-82963', '0', '0', NULL, NULL),
('743', '10', '34', '2015-12-11', '0250', '', '82963', '0', '0', '2', '3'),
('744', '12', '34', '2015-12-11', '0301', '', '82963', '0', '0', NULL, NULL),
('745', '12', '34', '2015-12-11', '0250', '', '-82963', '0', '0', '2', '3'),
('746', '10', '35', '2015-12-18', '4100', '', '-71768', '0', '0', NULL, NULL),
('747', '10', '35', '2015-12-18', '0250', '', '71768', '0', '0', '2', '3'),
('748', '12', '35', '2015-12-18', '0301', '', '71768', '0', '0', NULL, NULL),
('749', '12', '35', '2015-12-18', '0250', '', '-71768', '0', '0', '2', '3'),
('750', '10', '36', '2015-12-25', '4100', '', '-120771', '0', '0', NULL, NULL),
('751', '10', '36', '2015-12-25', '0250', '', '120771', '0', '0', '2', '3'),
('752', '12', '36', '2015-12-25', '0301', '', '120771', '0', '0', NULL, NULL),
('753', '12', '36', '2015-12-25', '0250', '', '-120771', '0', '0', '2', '3'),
('754', '10', '37', '2015-12-31', '4100', '', '-89350', '0', '0', NULL, NULL),
('755', '10', '37', '2015-12-31', '0250', '', '89350', '0', '0', '2', '3'),
('756', '12', '37', '2015-12-31', '0301', '', '89350', '0', '0', NULL, NULL),
('757', '12', '37', '2015-12-31', '0250', '', '-89350', '0', '0', '2', '3'),
('758', '10', '38', '2016-01-01', '4100', '', '-1790', '0', '0', NULL, NULL),
('759', '10', '38', '2016-01-01', '4100', '', '-8045', '0', '0', NULL, NULL),
('760', '10', '38', '2016-01-01', '0250', '', '9835', '0', '0', '2', '3'),
('761', '12', '38', '2016-01-01', '0301', '', '9835', '0', '0', NULL, NULL),
('762', '12', '38', '2016-01-01', '0250', '', '-9835', '0', '0', '2', '3'),
('763', '10', '39', '2016-01-08', '4100', '', '-64306', '0', '0', NULL, NULL),
('764', '10', '39', '2016-01-08', '0250', '', '64306', '0', '0', '2', '3'),
('765', '12', '39', '2016-01-08', '0301', '', '64306', '0', '0', NULL, NULL),
('766', '12', '39', '2016-01-08', '0250', '', '-64306', '0', '0', '2', '3'),
('767', '10', '40', '2016-01-15', '4100', '', '-95720', '0', '0', NULL, NULL),
('768', '10', '40', '2016-01-15', '0250', '', '95720', '0', '0', '2', '3'),
('769', '12', '40', '2016-01-15', '0301', '', '95720', '0', '0', NULL, NULL),
('770', '12', '40', '2016-01-15', '0250', '', '-95720', '0', '0', '2', '3'),
('771', '10', '41', '2016-01-22', '4100', '', '-62295', '0', '0', NULL, NULL),
('772', '10', '41', '2016-01-22', '0250', '', '62295', '0', '0', '2', '3'),
('773', '12', '41', '2016-01-22', '0301', '', '62295', '0', '0', NULL, NULL),
('774', '12', '41', '2016-01-22', '0250', '', '-62295', '0', '0', '2', '3'),
('775', '10', '42', '2016-01-29', '4100', '', '-113045', '0', '0', NULL, NULL),
('776', '10', '42', '2016-01-29', '0250', '', '113045', '0', '0', '2', '3'),
('777', '12', '42', '2016-01-29', '0301', '', '113045', '0', '0', NULL, NULL),
('778', '12', '42', '2016-01-29', '0250', '', '-113045', '0', '0', '2', '3'),
('779', '10', '43', '2016-01-31', '4100', '', '-47945', '0', '0', NULL, NULL),
('780', '10', '43', '2016-01-31', '0250', '', '47945', '0', '0', '2', '3'),
('781', '12', '43', '2016-01-31', '0301', '', '47945', '0', '0', NULL, NULL),
('782', '12', '43', '2016-01-31', '0250', '', '-47945', '0', '0', '2', '3'),
('783', '10', '44', '2016-02-05', '4100', '', '-53980', '0', '0', NULL, NULL),
('784', '10', '44', '2016-02-05', '4100', '', '-10585', '0', '0', NULL, NULL),
('785', '10', '44', '2016-02-05', '0250', '', '64565', '0', '0', '2', '3'),
('786', '12', '44', '2016-02-05', '0301', '', '64565', '0', '0', NULL, NULL),
('787', '12', '44', '2016-02-05', '0250', '', '-64565', '0', '0', '2', '3'),
('788', '10', '45', '2016-02-12', '4100', '', '-103935', '0', '0', NULL, NULL),
('789', '10', '45', '2016-02-12', '0250', '', '103935', '0', '0', '2', '3'),
('790', '12', '45', '2016-02-12', '0301', '', '103935', '0', '0', NULL, NULL),
('791', '12', '45', '2016-02-12', '0250', '', '-103935', '0', '0', '2', '3'),
('792', '10', '46', '2016-02-19', '4100', '', '-97114', '0', '0', NULL, NULL),
('793', '10', '46', '2016-02-19', '0250', '', '97114', '0', '0', '2', '3'),
('794', '12', '46', '2016-02-19', '0301', '', '97114', '0', '0', NULL, NULL),
('795', '12', '46', '2016-02-19', '0250', '', '-97114', '0', '0', '2', '3'),
('796', '10', '47', '2016-02-26', '4100', '', '-110807', '0', '0', NULL, NULL),
('797', '10', '47', '2016-02-26', '0250', '', '110807', '0', '0', '2', '3'),
('798', '12', '47', '2016-02-26', '0301', '', '110807', '0', '0', NULL, NULL),
('799', '12', '47', '2016-02-26', '0250', '', '-110807', '0', '0', '2', '3'),
('800', '10', '48', '2016-02-29', '4100', '', '-46100', '0', '0', NULL, NULL),
('801', '10', '48', '2016-02-29', '0250', '', '46100', '0', '0', '2', '3'),
('802', '12', '48', '2016-02-29', '0301', '', '46100', '0', '0', NULL, NULL),
('803', '12', '48', '2016-02-29', '0250', '', '-46100', '0', '0', '2', '3'),
('804', '10', '49', '2016-03-04', '4100', '', '-31687', '0', '0', NULL, NULL),
('805', '10', '49', '2016-03-04', '4100', '', '-15200', '0', '0', NULL, NULL),
('806', '10', '49', '2016-03-04', '0250', '', '46887', '0', '0', '2', '3'),
('807', '12', '49', '2016-03-04', '0301', '', '46887', '0', '0', NULL, NULL),
('808', '12', '49', '2016-03-04', '0250', '', '-46887', '0', '0', '2', '3'),
('809', '10', '50', '2016-03-11', '4100', '', '-107384', '0', '0', NULL, NULL),
('810', '10', '50', '2016-03-11', '0250', '', '107384', '0', '0', '2', '3'),
('811', '12', '50', '2016-03-11', '0301', '', '107384', '0', '0', NULL, NULL),
('812', '12', '50', '2016-03-11', '0250', '', '-107384', '0', '0', '2', '3'),
('813', '10', '51', '2016-03-18', '4100', '', '-111432', '0', '0', NULL, NULL),
('814', '10', '51', '2016-03-18', '0250', '', '111432', '0', '0', '2', '3'),
('815', '12', '51', '2016-03-18', '0301', '', '111432', '0', '0', NULL, NULL),
('816', '12', '51', '2016-03-18', '0250', '', '-111432', '0', '0', '2', '3'),
('817', '10', '52', '2016-03-25', '4100', '', '-92910', '0', '0', NULL, NULL),
('818', '10', '52', '2016-03-25', '0250', '', '92910', '0', '0', '2', '3'),
('819', '12', '52', '2016-03-25', '0301', '', '92910', '0', '0', NULL, NULL),
('820', '12', '52', '2016-03-25', '0250', '', '-92910', '0', '0', '2', '3'),
('821', '10', '53', '2016-03-31', '4100', '', '-74215', '0', '0', NULL, NULL),
('822', '10', '53', '2016-03-31', '0250', '', '74215', '0', '0', '2', '3'),
('823', '12', '53', '2016-03-31', '0301', '', '74215', '0', '0', NULL, NULL),
('824', '12', '53', '2016-03-31', '0250', '', '-74215', '0', '0', '2', '3'),
('825', '10', '54', '2016-01-15', '4100', '', '-12635', '0', '0', NULL, NULL),
('826', '10', '54', '2016-01-15', '0250', '', '12635', '0', '0', '2', '4'),
('827', '12', '54', '2016-01-15', '0301', '', '12635', '0', '0', NULL, NULL),
('828', '12', '54', '2016-01-15', '0250', '', '-12635', '0', '0', '2', '4'),
('829', '10', '55', '2016-01-22', '4100', '', '-10430', '0', '0', NULL, NULL),
('830', '10', '55', '2016-01-22', '0250', '', '10430', '0', '0', '2', '4'),
('831', '12', '55', '2016-01-22', '0301', '', '10430', '0', '0', NULL, NULL),
('832', '12', '55', '2016-01-22', '0250', '', '-10430', '0', '0', '2', '4'),
('833', '10', '56', '2016-01-29', '4100', '', '-6745', '0', '0', NULL, NULL),
('834', '10', '56', '2016-01-29', '0250', '', '6745', '0', '0', '2', '4'),
('835', '12', '56', '2016-01-29', '0301', '', '6745', '0', '0', NULL, NULL),
('836', '12', '56', '2016-01-29', '0250', '', '-6745', '0', '0', '2', '4'),
('837', '10', '57', '2016-01-31', '4100', '', '-2310', '0', '0', NULL, NULL),
('838', '10', '57', '2016-01-31', '0250', '', '2310', '0', '0', '2', '4'),
('839', '12', '57', '2016-01-31', '0301', '', '2310', '0', '0', NULL, NULL),
('840', '12', '57', '2016-01-31', '0250', '', '-2310', '0', '0', '2', '4'),
('841', '10', '58', '2016-02-05', '4100', '', '-5110', '0', '0', NULL, NULL),
('842', '10', '58', '2016-02-05', '0250', '', '5110', '0', '0', '2', '4'),
('843', '12', '58', '2016-02-05', '0301', '', '5110', '0', '0', NULL, NULL),
('844', '12', '58', '2016-02-05', '0250', '', '-5110', '0', '0', '2', '4'),
('845', '10', '59', '2016-02-12', '4100', '', '-12205', '0', '0', NULL, NULL),
('846', '10', '59', '2016-02-12', '0250', '', '12205', '0', '0', '2', '4'),
('847', '12', '59', '2016-02-12', '0301', '', '12205', '0', '0', NULL, NULL),
('848', '12', '59', '2016-02-12', '0250', '', '-12205', '0', '0', '2', '4'),
('849', '10', '60', '2016-02-19', '4100', '', '-10485', '0', '0', NULL, NULL),
('850', '10', '60', '2016-02-19', '0250', '', '10485', '0', '0', '2', '4'),
('851', '12', '60', '2016-02-19', '0301', '', '10485', '0', '0', NULL, NULL),
('852', '12', '60', '2016-02-19', '0250', '', '-10485', '0', '0', '2', '4'),
('853', '10', '61', '2016-02-26', '4100', '', '-17820', '0', '0', NULL, NULL),
('854', '10', '61', '2016-02-26', '0250', '', '17820', '0', '0', '2', '4'),
('855', '12', '61', '2016-02-26', '0301', '', '17820', '0', '0', NULL, NULL),
('856', '12', '61', '2016-02-26', '0250', '', '-17820', '0', '0', '2', '4'),
('857', '10', '62', '2016-02-29', '4100', '', '-5565', '0', '0', NULL, NULL),
('858', '10', '62', '2016-02-29', '0250', '', '5565', '0', '0', '2', '4'),
('859', '12', '62', '2016-02-29', '0301', '', '5565', '0', '0', NULL, NULL),
('860', '12', '62', '2016-02-29', '0250', '', '-5565', '0', '0', '2', '4'),
('861', '10', '63', '2016-03-04', '4100', '', '-6750', '0', '0', NULL, NULL),
('862', '10', '63', '2016-03-04', '0250', '', '6750', '0', '0', '2', '4'),
('863', '12', '63', '2016-03-04', '0301', '', '6750', '0', '0', NULL, NULL),
('864', '12', '63', '2016-03-04', '0250', '', '-6750', '0', '0', '2', '4'),
('865', '10', '64', '2016-03-11', '4100', '', '-10790', '0', '0', NULL, NULL),
('866', '10', '64', '2016-03-11', '0250', '', '10790', '0', '0', '2', '4'),
('867', '12', '64', '2016-03-11', '0301', '', '10790', '0', '0', NULL, NULL),
('868', '12', '64', '2016-03-11', '0250', '', '-10790', '0', '0', '2', '4'),
('869', '10', '65', '2016-03-18', '4100', '', '-13605', '0', '0', NULL, NULL),
('870', '10', '65', '2016-03-18', '0250', '', '13605', '0', '0', '2', '4'),
('871', '12', '65', '2016-03-18', '0301', '', '13605', '0', '0', NULL, NULL),
('872', '12', '65', '2016-03-18', '0250', '', '-13605', '0', '0', '2', '4'),
('873', '10', '66', '2016-03-25', '4100', '', '-11435', '0', '0', NULL, NULL),
('874', '10', '66', '2016-03-25', '0250', '', '11435', '0', '0', '2', '4'),
('875', '12', '66', '2016-03-25', '0301', '', '11435', '0', '0', NULL, NULL),
('876', '12', '66', '2016-03-25', '0250', '', '-11435', '0', '0', '2', '4'),
('877', '10', '67', '2016-03-31', '4100', '', '-6445', '0', '0', NULL, NULL),
('878', '10', '67', '2016-03-31', '0250', '', '6445', '0', '0', '2', '4'),
('879', '12', '67', '2016-03-31', '0301', '', '6445', '0', '0', NULL, NULL),
('880', '12', '67', '2016-03-31', '0250', '', '-6445', '0', '0', '2', '4'),
('881', '2', '30', '2016-01-22', '0251', 'Fund transfer to golden Plam', '0', '0', '0', NULL, NULL),
('882', '2', '30', '2016-01-22', '0303', '', '0', '0', '0', NULL, NULL),
('893', '2', '31', '2016-01-22', '0251', 'Fund transfer to golden Plam', '-64828', '0', '0', NULL, NULL),
('894', '2', '31', '2016-01-22', '0303', '', '64828', '0', '0', NULL, NULL),
('897', '0', '5', '2015-04-02', '0002', 'REST CUPBORD MAKING SAMAN ', '8500', '0', '0', NULL, NULL),
('898', '0', '5', '2015-04-02', '0252', 'REST CUPBORD MAKING SAMAN ', '-8500', '0', '0', NULL, NULL),
('899', '1', '50', '2015-04-09', '0002', 'Kitchen equipment purchase', '40000', '0', '0', NULL, NULL),
('900', '1', '50', '2015-04-09', '0300', '', '-40000', '0', '0', NULL, NULL),
('901', '0', '6', '2015-07-09', '0002', 'KITCHEN UTENCILS ', '10000', '0', '0', NULL, NULL),
('902', '0', '6', '2015-07-09', '0252', 'KITCHEN UTENCILS ', '-10000', '0', '0', NULL, NULL),
('903', '0', '7', '2015-09-29', '0002', 'PURCHASING DUSTBINS CURRY BALLS', '20000', '0', '0', NULL, NULL),
('904', '0', '7', '2015-09-29', '0252', 'PURCHASING DUSTBINS CURRY BALLS', '-20000', '0', '0', NULL, NULL),
('905', '0', '8', '2016-01-08', '0002', 'PUR KITCHEN EQIPMENT OUTLET', '75000', '0', '0', NULL, NULL),
('906', '0', '8', '2016-01-08', '0252', 'PUR KITCHEN EQIPMENT OUTLET', '-75000', '0', '0', NULL, NULL),
('907', '0', '9', '2016-01-19', '0002', 'REFREGIRATOR GAS COOKER CUTTING BD', '81710', '0', '0', NULL, NULL),
('908', '0', '9', '2016-01-19', '0252', 'REFREGIRATOR GAS COOKER CUTTING BD', '-81710', '0', '0', NULL, NULL),
('909', '0', '10', '2016-02-09', '0002', 'REST CLAY POTS BUFFERT SET', '10000', '0', '0', NULL, NULL),
('910', '0', '10', '2016-02-09', '0252', 'REST CLAY POTS BUFFERT SET', '-10000', '0', '0', NULL, NULL),
('911', '0', '11', '2016-02-18', '2000', 'Food item purchase', '5700', '0', '0', NULL, NULL),
('912', '0', '11', '2016-02-18', '4163', 'Traviling and transport expenses', '280', '0', '0', NULL, NULL),
('913', '0', '11', '2016-02-18', '0002', 'Kitchen equipment purchase', '950', '0', '0', NULL, NULL),
('914', '0', '11', '2016-02-18', '0300', 'Kitchen equipment purchase', '-6930', '0', '0', NULL, NULL),
('915', '0', '12', '2015-09-14', '0001', 'CONSULTANCY FEES MR. SHANTHA REST.', '8500', '0', '0', NULL, NULL),
('916', '0', '12', '2015-09-14', '0252', 'CONSULTANCY FEES MR. SHANTHA REST.', '-8500', '0', '0', NULL, NULL),
('917', '0', '13', '2015-09-26', '0001', 'OUTLET 2ND ADVANCE PER SCHEDULE ', '19825', '0', '0', NULL, NULL),
('918', '0', '13', '2015-09-26', '0252', 'OUTLET 2ND ADVANCE PER SCHEDULE ', '-19825', '0', '0', NULL, NULL),
('919', '0', '14', '2015-09-30', '0001', 'OUTLET EXPENCES ', '22200', '0', '0', NULL, NULL),
('920', '0', '14', '2015-09-30', '0252', 'OUTLET EXPENCES ', '-22200', '0', '0', NULL, NULL),
('921', '0', '15', '2015-11-09', '0001', 'CEMENT SS HARD WERE ', '18530', '0', '0', NULL, NULL),
('922', '0', '15', '2015-11-09', '0252', 'CEMENT SS HARD WERE ', '-18530', '0', '0', NULL, NULL),
('923', '0', '16', '2015-11-09', '0001', 'MANGULA 3RD ADVANCE OUTLET', '22500', '0', '0', NULL, NULL),
('924', '0', '16', '2015-11-09', '0252', 'MANGULA 3RD ADVANCE OUTLET', '-22500', '0', '0', NULL, NULL),
('925', '0', '17', '2015-11-09', '0001', 'INSPECTION FEES MR. SHANTHA OUTLET', '3500', '0', '0', NULL, NULL),
('926', '0', '17', '2015-11-09', '0252', 'INSPECTION FEES MR. SHANTHA OUTLET', '-3500', '0', '0', NULL, NULL),
('927', '0', '18', '2015-11-10', '0001', 'INSURANCE POLICY GENERATOR REST.', '6271.1', '0', '0', NULL, NULL),
('928', '0', '18', '2015-11-10', '0252', 'INSURANCE POLICY GENERATOR REST.', '-6271.1', '0', '0', NULL, NULL),
('929', '0', '19', '2015-11-11', '0001', 'BACCO work FOR OUTLET ', '15850', '0', '0', NULL, NULL),
('930', '0', '19', '2015-11-11', '0252', 'BACCO work FOR OUTLET ', '-15850', '0', '0', NULL, NULL),
('931', '0', '20', '2015-11-13', '0001', 'OUTLET METERIAL ADVANCE 2ND', '60000', '0', '0', NULL, NULL),
('932', '0', '20', '2015-11-13', '0252', 'OUTLET METERIAL ADVANCE 2ND', '-60000', '0', '0', NULL, NULL),
('933', '0', '21', '2015-12-13', '0001', 'IRON DOOR FOR GENERATOR ROOM', '8000', '0', '0', NULL, NULL),
('934', '0', '21', '2015-12-13', '0252', 'IRON DOOR FOR GENERATOR ROOM', '-8000', '0', '0', NULL, NULL),
('935', '0', '22', '2015-11-13', '0001', 'MR.SHANTHA CONSULTANCY FEES', '4000', '0', '0', NULL, NULL),
('936', '0', '22', '2015-11-13', '0252', 'MR.SHANTHA CONSULTANCY FEES', '-4000', '0', '0', NULL, NULL),
('937', '0', '23', '2015-11-20', '0001', 'ALUMINIUM SHEET COVER KIT GALLY ', '7500', '0', '0', NULL, NULL),
('938', '0', '23', '2015-11-20', '0252', 'ALUMINIUM SHEET COVER KIT GALLY ', '-7500', '0', '0', NULL, NULL),
('939', '0', '24', '2015-11-20', '0001', 'PUR METERIALS TIMBER HUT PLANING', '189290', '0', '0', NULL, NULL),
('940', '0', '24', '2015-11-20', '0252', 'PUR METERIALS TIMBER HUT PLANING', '-189290', '0', '0', NULL, NULL),
('941', '0', '25', '2015-11-23', '0001', 'PUR WIRE CUT BRICKS ', '13650', '0', '0', NULL, NULL),
('942', '0', '25', '2015-11-23', '0252', 'PUR WIRE CUT BRICKS ', '-13650', '0', '0', NULL, NULL),
('943', '0', '26', '2015-11-23', '0001', 'COVER TATS ', '10000', '0', '0', NULL, NULL),
('944', '0', '26', '2015-11-23', '0252', 'COVER TATS ', '-10000', '0', '0', NULL, NULL),
('945', '0', '27', '2015-11-23', '0001', 'OUTLET METERIAL COST', '30910', '0', '0', NULL, NULL),
('946', '0', '27', '2015-11-23', '0252', 'OUTLET METERIAL COST', '-30910', '0', '0', NULL, NULL),
('947', '0', '28', '2015-11-23', '0001', 'BRICKS TRASPORTING CHARGES', '9500', '0', '0', NULL, NULL),
('948', '0', '28', '2015-11-23', '0252', 'BRICKS TRASPORTING CHARGES', '-9500', '0', '0', NULL, NULL),
('949', '0', '29', '2015-04-01', '0003', 'Road construction', '10750', '0', '0', NULL, NULL),
('950', '0', '29', '2015-04-01', '0252', 'Road construction', '-10750', '0', '0', NULL, NULL),
('951', '0', '30', '2015-04-08', '0003', 'ALUMINIUM WORK PASAN 12MM DD UNIT', '165000', '0', '0', NULL, NULL),
('952', '0', '30', '2015-04-08', '0252', 'ALUMINIUM WORK PASAN 12MM DD UNIT', '-165000', '0', '0', NULL, NULL),
('953', '0', '31', '2015-04-08', '0003', 'REST LABOUR FINAL PAYMENT CONSTRU', '10000', '0', '0', NULL, NULL),
('954', '0', '31', '2015-04-08', '0252', 'REST LABOUR FINAL PAYMENT CONSTRU', '-10000', '0', '0', NULL, NULL),
('955', '0', '32', '2015-04-09', '0003', 'CITIZEN ELECTRICALS LIGHT ADVANCE', '20000', '0', '0', NULL, NULL),
('956', '0', '32', '2015-04-09', '0252', 'CITIZEN ELECTRICALS LIGHT ADVANCE', '-20000', '0', '0', NULL, NULL),
('957', '0', '33', '2015-04-09', '0003', 'LUCKY CENTRE &amp; WATCHER SALARY ', '12600', '0', '0', NULL, NULL),
('958', '0', '33', '2015-04-09', '0252', 'LUCKY CENTRE &amp; WATCHER SALARY ', '-12600', '0', '0', NULL, NULL),
('959', '0', '34', '2015-04-10', '0003', 'PANAL BORD AND LIGHTING ADVANCE', '75000', '0', '0', NULL, NULL),
('960', '0', '34', '2015-04-10', '0252', 'PANAL BORD AND LIGHTING ADVANCE', '-75000', '0', '0', NULL, NULL),
('961', '0', '35', '2015-04-10', '0003', 'A.S.K IRON WORKS', '118723', '0', '0', NULL, NULL),
('962', '0', '35', '2015-04-10', '0252', 'A.S.K IRON WORKS', '-118723', '0', '0', NULL, NULL),
('963', '0', '36', '2015-04-20', '0003', 'ADDI CEPTIC TANK', '2850', '0', '0', NULL, NULL),
('964', '0', '36', '2015-04-20', '0252', 'ADDI CEPTIC TANK', '-2850', '0', '0', NULL, NULL),
('965', '0', '37', '2015-04-23', '0003', 'Investment to resturent building', '500000', '0', '0', NULL, NULL),
('966', '0', '37', '2015-04-23', '0253', 'Investment to resturent building', '-500000', '0', '0', NULL, NULL),
('967', '0', '38', '2015-04-24', '0003', 'BACHOE CHR. TRASPORT ', '54295', '0', '0', NULL, NULL),
('968', '0', '38', '2015-04-24', '0252', 'BACHOE CHR. TRASPORT ', '-54295', '0', '0', NULL, NULL),
('969', '0', '39', '2015-04-29', '0003', 'SETTLEMENT OF LUCKY STORE BILLS', '12877', '0', '0', NULL, NULL),
('970', '0', '39', '2015-04-29', '0252', 'SETTLEMENT OF LUCKY STORE BILLS', '-12877', '0', '0', NULL, NULL),
('971', '0', '40', '2015-05-11', '0003', 'PAYMENT FOR MOTOR PUMP', '40000', '0', '0', NULL, NULL),
('972', '0', '40', '2015-05-11', '0252', 'PAYMENT FOR MOTOR PUMP', '-40000', '0', '0', NULL, NULL),
('973', '0', '41', '2015-05-11', '0003', 'REST NAME BOARD BALACE PAYMENT', '20000', '0', '0', NULL, NULL),
('974', '0', '41', '2015-05-11', '0252', 'REST NAME BOARD BALACE PAYMENT', '-20000', '0', '0', NULL, NULL),
('975', '0', '42', '2015-05-11', '0003', 'POLLY CARBONATE SOLID SHEET', '267903.75', '0', '0', NULL, NULL),
('976', '0', '42', '2015-05-11', '0252', 'POLLY CARBONATE SOLID SHEET', '-267903.75', '0', '0', NULL, NULL),
('977', '0', '43', '2015-05-15', '0003', 'FIST AND GROUND FLOOR DOOR BALNCE', '19788', '0', '0', NULL, NULL),
('978', '0', '43', '2015-05-15', '0252', 'FIST AND GROUND FLOOR DOOR BALNCE', '-19788', '0', '0', NULL, NULL),
('979', '0', '44', '2015-05-15', '0003', 'WATCHER PAYMENT TELCOM DISS BILL', '8040', '0', '0', NULL, NULL),
('980', '0', '44', '2015-05-15', '0252', 'WATCHER PAYMENT TELCOM DISS BILL', '-8040', '0', '0', NULL, NULL),
('981', '0', '45', '2015-05-21', '0003', 'TRANSFER OF DUES 1499 AC ', '200000', '0', '0', NULL, NULL),
('982', '0', '45', '2015-05-21', '0253', 'TRANSFER OF DUES 1499 AC ', '-200000', '0', '0', NULL, NULL),
('983', '0', '46', '2015-05-21', '0003', 'PURCHASES OF MIRRORS ', '12000', '0', '0', NULL, NULL),
('984', '0', '46', '2015-05-21', '0256', 'PURCHASES OF MIRRORS ', '-12000', '0', '0', NULL, NULL),
('985', '0', '47', '2015-05-22', '0003', 'MR. SHANTHA MELSIRIPURA VISIT', '3500', '0', '0', NULL, NULL),
('986', '0', '47', '2015-05-22', '0252', 'MR. SHANTHA MELSIRIPURA VISIT', '-3500', '0', '0', NULL, NULL),
('987', '0', '48', '2015-05-22', '0003', 'BAMBOSTIC FOR ROOF WORK', '15000', '0', '0', NULL, NULL),
('988', '0', '48', '2015-05-22', '0252', 'BAMBOSTIC FOR ROOF WORK', '-15000', '0', '0', NULL, NULL),
('989', '0', '49', '2015-06-08', '0003', 'L&amp; S ENGINEERING FINAL PAYMENT', '191538.75', '0', '0', NULL, NULL),
('990', '0', '49', '2015-06-08', '0252', 'L&amp; S ENGINEERING FINAL PAYMENT', '-191538.75', '0', '0', NULL, NULL),
('991', '0', '50', '2015-06-10', '0003', 'GALLY BUSER AND BACHOE CHARGES', '10000', '0', '0', NULL, NULL),
('992', '0', '50', '2015-06-10', '0252', 'GALLY BUSER AND BACHOE CHARGES', '-10000', '0', '0', NULL, NULL),
('993', '0', '51', '2015-06-18', '0003', 'WATER LEACK TOP OF REST REAEAR ', '5877', '0', '0', NULL, NULL),
('994', '0', '51', '2015-06-18', '0252', 'WATER LEACK TOP OF REST REAEAR ', '-5877', '0', '0', NULL, NULL),
('995', '0', '52', '2015-06-18', '0003', 'CONTRIBUTION TOWARDS REST NAME BOARD', '65000', '0', '0', NULL, NULL),
('996', '0', '52', '2015-06-18', '0252', 'CONTRIBUTION TOWARDS REST NAME BOARD', '-65000', '0', '0', NULL, NULL),
('997', '0', '53', '2015-06-24', '0003', 'STAFF JAYARATHNE WATER PUMP REP', '23128', '0', '0', NULL, NULL),
('998', '0', '53', '2015-06-24', '0252', 'STAFF JAYARATHNE WATER PUMP REP', '-23128', '0', '0', NULL, NULL),
('999', '0', '54', '2015-07-08', '0003', 'REST FRONT WATCHER TEMP', '22050', '0', '0', NULL, NULL),
('1000', '0', '54', '2015-07-08', '0252', 'REST FRONT WATCHER TEMP', '-22050', '0', '0', NULL, NULL),
('1001', '0', '55', '2015-07-08', '0003', 'DISPLAY BOARD', '4000', '0', '0', NULL, NULL),
('1002', '0', '55', '2015-07-08', '0252', 'DISPLAY BOARD', '-4000', '0', '0', NULL, NULL),
('1003', '0', '56', '2015-08-11', '0003', 'ASLIYA PRINTERS FOOD ALL DAY BOARD', '9500', '0', '0', NULL, NULL),
('1004', '0', '56', '2015-08-11', '0252', 'ASLIYA PRINTERS FOOD ALL DAY BOARD', '-9500', '0', '0', NULL, NULL),
('1005', '0', '57', '2015-08-11', '0003', 'ASLIYA PRINTERS 2ND PAYMENT ', '9500', '0', '0', NULL, NULL),
('1006', '0', '57', '2015-08-11', '0252', 'ASLIYA PRINTERS 2ND PAYMENT ', '-9500', '0', '0', NULL, NULL),
('1007', '0', '58', '2015-08-20', '0003', 'MAKING NON VEG BENIFIT BOARD WATCHER SALARY', '22249', '0', '0', NULL, NULL),
('1008', '0', '58', '2015-08-20', '0252', 'MAKING NON VEG BENIFIT BOARD WATCHER SALARY', '-22249', '0', '0', NULL, NULL),
('1009', '0', '59', '2015-08-27', '0003', 'MR.SHANTHA VISIT TO MELSIRIPURA REST', '5000', '0', '0', NULL, NULL),
('1010', '0', '59', '2015-08-27', '0252', 'MR.SHANTHA VISIT TO MELSIRIPURA REST', '-5000', '0', '0', NULL, NULL),
('1011', '0', '60', '2015-09-16', '0003', 'MR.DAYA&#039;S TRAVELLING OUTLET INSPECTION ', '2000', '0', '0', NULL, NULL),
('1012', '0', '60', '2015-09-16', '0252', 'MR.DAYA&#039;S TRAVELLING OUTLET INSPECTION ', '-2000', '0', '0', NULL, NULL),
('1013', '0', '61', '2015-09-18', '0003', 'MR.SHANTHA OUTLET T.O. FEES', '3000', '0', '0', NULL, NULL),
('1014', '0', '61', '2015-09-18', '0252', 'MR.SHANTHA OUTLET T.O. FEES', '-3000', '0', '0', NULL, NULL),
('1015', '0', '62', '2015-09-25', '0003', 'SALES BILL SETTELMENT MR. PERCY ', '890', '0', '0', NULL, NULL),
('1016', '0', '62', '2015-09-25', '0252', 'SALES BILL SETTELMENT MR. PERCY ', '-890', '0', '0', NULL, NULL),
('1017', '0', '63', '2015-09-29', '0003', 'WALL MONTED 2 FANS AND FIXING CHAGE', '18000', '0', '0', NULL, NULL),
('1018', '0', '63', '2015-09-29', '0253', 'WALL MONTED 2 FANS AND FIXING CHAGE', '-18000', '0', '0', NULL, NULL),
('1019', '0', '64', '2015-10-01', '0003', 'TRAVELLING SHANTHA FEES REST ME PUR.', '5000', '0', '0', NULL, NULL),
('1020', '0', '64', '2015-10-01', '0252', 'TRAVELLING SHANTHA FEES REST ME PUR.', '-5000', '0', '0', NULL, NULL),
('1021', '0', '65', '2015-10-15', '0003', 'MANJULA BASS 1ST ADVANCE OUTLET ', '50000', '0', '0', NULL, NULL),
('1022', '0', '65', '2015-10-15', '0252', 'MANJULA BASS 1ST ADVANCE OUTLET ', '-50000', '0', '0', NULL, NULL),
('1023', '0', '66', '2015-10-26', '0003', 'MULGALA EXPENSES', '4750', '0', '0', NULL, NULL),
('1024', '0', '66', '2015-10-26', '0252', 'MULGALA EXPENSES', '-4750', '0', '0', NULL, NULL),
('1025', '0', '67', '2015-10-26', '0003', 'MR.SHANTHA CONSULTATION FOR OUTLET', '4500', '0', '0', NULL, NULL),
('1026', '0', '67', '2015-10-26', '0252', 'MR.SHANTHA CONSULTATION FOR OUTLET', '-4500', '0', '0', NULL, NULL),
('1027', '0', '68', '2016-02-01', '0003', 'REST PAINTING BR FITTING BASS FINAL PAY', '19890', '0', '0', NULL, NULL),
('1028', '0', '68', '2016-02-01', '0252', 'REST PAINTING BR FITTING BASS FINAL PAY', '-19890', '0', '0', NULL, NULL),
('1029', '0', '69', '2015-04-08', '0004', 'CEPTIC TANK NEWLY REPLACED ', '146000', '0', '0', NULL, NULL),
('1030', '0', '69', '2015-04-08', '0252', 'CEPTIC TANK NEWLY REPLACED ', '-146000', '0', '0', NULL, NULL),
('1031', '0', '70', '2015-04-09', '0004', 'CONCULTANCY FEES MR. SHANTHA', '3000', '0', '0', NULL, NULL),
('1032', '0', '70', '2015-04-09', '0252', 'CONCULTANCY FEES MR. SHANTHA', '-3000', '0', '0', NULL, NULL),
('1033', '0', '71', '2015-07-02', '0004', 'CONSTRUCTION OF NEW SEPTIC TANK', '90596', '0', '0', NULL, NULL),
('1034', '0', '71', '2015-07-02', '0252', 'CONSTRUCTION OF NEW SEPTIC TANK', '-90596', '0', '0', NULL, NULL),
('1035', '0', '72', '2015-07-09', '0004', 'CONSTRUCTION OF NEW SEPTIC TANK', '2000', '0', '0', NULL, NULL),
('1036', '0', '72', '2015-07-09', '0252', 'CONSTRUCTION OF NEW SEPTIC TANK', '-2000', '0', '0', NULL, NULL),
('1037', '0', '73', '2015-07-29', '0004', 'NEW SEPTIC TANK AND PIPE LINE GOLDEN PALM', '17495', '0', '0', NULL, NULL),
('1038', '0', '73', '2015-07-29', '0252', 'NEW SEPTIC TANK AND PIPE LINE GOLDEN PALM', '-17495', '0', '0', NULL, NULL),
('1039', '0', '74', '2016-02-09', '0004', 'SEPTIC TANK EXPENSES', '53636', '0', '0', NULL, NULL),
('1040', '0', '74', '2016-02-09', '0252', 'SEPTIC TANK EXPENSES', '-53636', '0', '0', NULL, NULL),
('1041', '0', '75', '2016-02-16', '0004', 'SEPTIC TANK EXPENSES TABLE FOR UMBRELLA', '18115', '0', '0', NULL, NULL),
('1042', '0', '75', '2016-02-16', '0252', 'SEPTIC TANK EXPENSES TABLE FOR UMBRELLA', '-18115', '0', '0', NULL, NULL),
('1043', '0', '76', '2015-09-01', '0005', 'SHOW CASE DISPLAY CUPBOARD', '38000', '0', '0', NULL, NULL),
('1044', '0', '76', '2015-09-01', '0252', 'SHOW CASE DISPLAY CUPBOARD', '-38000', '0', '0', NULL, NULL),
('1045', '0', '77', '2016-03-14', '0005', 'EXPENSES FOR BUFFET TABLE ', '13000', '0', '0', NULL, NULL),
('1046', '0', '77', '2016-03-14', '0252', 'EXPENSES FOR BUFFET TABLE ', '-13000', '0', '0', NULL, NULL),
('1047', '0', '78', '2016-03-14', '0005', 'BALANCE PAY BUFFET TABLE ', '2000', '0', '0', NULL, NULL),
('1048', '0', '78', '2016-03-14', '0252', 'BALANCE PAY BUFFET TABLE ', '-2000', '0', '0', NULL, NULL),
('1049', '0', '79', '2015-09-21', '0007', 'ELECTRICITY AND GENERATOR INSPECTION ', '2500', '0', '0', NULL, NULL),
('1050', '0', '79', '2015-09-21', '0252', 'ELECTRICITY AND GENERATOR INSPECTION ', '-2500', '0', '0', NULL, NULL),
('1051', '0', '80', '2015-11-05', '0007', 'PURCHASE OF GENERATOR ', '430000', '0', '0', NULL, NULL),
('1052', '0', '80', '2015-11-05', '0252', 'PURCHASE OF GENERATOR ', '-430000', '0', '0', NULL, NULL),
('1053', '0', '81', '2015-11-09', '0007', 'GENERATOR ISTALATION EXPENSES', '1520', '0', '0', NULL, NULL),
('1054', '0', '81', '2015-11-09', '0252', 'GENERATOR ISTALATION EXPENSES', '-1520', '0', '0', NULL, NULL),
('1055', '0', '82', '2015-11-09', '0007', 'INSTALATION OF GENERATOR', '17000', '0', '0', NULL, NULL),
('1056', '0', '82', '2015-11-09', '0252', 'INSTALATION OF GENERATOR', '-17000', '0', '0', NULL, NULL),
('1057', '0', '83', '2016-03-30', '0007', 'GENERATOR ROOM CONSTRUC METERIAL', '3480', '0', '0', NULL, NULL),
('1058', '0', '83', '2016-03-30', '0252', 'GENERATOR ROOM CONSTRUC METERIAL', '-3480', '0', '0', NULL, NULL),
('1059', '0', '84', '2015-05-29', '0010', 'CCTV SYSTEM CAMARAS ', '90000', '0', '0', NULL, NULL),
('1060', '0', '84', '2015-05-29', '0252', 'CCTV SYSTEM CAMARAS ', '-90000', '0', '0', NULL, NULL),
('1061', '0', '85', '2015-06-01', '0010', 'CCTV REST.CAMARA SYSTEM ', '10000', '0', '0', NULL, NULL),
('1062', '0', '85', '2015-06-01', '0252', 'CCTV REST.CAMARA SYSTEM ', '-10000', '0', '0', NULL, NULL),
('1063', '0', '86', '2015-06-08', '0010', 'BALANCE PAYMENT CCTV CAMARA', '39470', '0', '0', NULL, NULL);
INSERT INTO `6_gl_trans` VALUES
('1064', '0', '86', '2015-06-08', '0252', 'BALANCE PAYMENT CCTV CAMARA', '-39470', '0', '0', NULL, NULL),
('1065', '0', '87', '2015-04-24', '0011', 'CANOPY FRONT LIGHT SHADE ', '104212.5', '0', '0', NULL, NULL),
('1066', '0', '87', '2015-04-24', '0252', 'CANOPY FRONT LIGHT SHADE ', '-104212.5', '0', '0', NULL, NULL),
('1067', '0', '88', '2015-09-29', '0012', 'ADVANCE PAY WEB SITE CREATION ROGERS', '10000', '0', '0', NULL, NULL),
('1068', '0', '88', '2015-09-29', '0252', 'ADVANCE PAY WEB SITE CREATION ROGERS', '-10000', '0', '0', NULL, NULL),
('1069', '0', '89', '2015-10-02', '0012', 'WEBSITE BAL PAYMENT TO ROGERS', '20000', '0', '0', NULL, NULL),
('1070', '0', '89', '2015-10-02', '0252', 'WEBSITE BAL PAYMENT TO ROGERS', '-20000', '0', '0', NULL, NULL),
('1071', '0', '90', '2016-01-07', '0014', 'MYCOM LANKA SYSTEM FOR OUTLET', '100000', '0', '0', NULL, NULL),
('1072', '0', '90', '2016-01-07', '0252', 'MYCOM LANKA SYSTEM FOR OUTLET', '-100000', '0', '0', NULL, NULL),
('1073', '0', '91', '2016-01-22', '0014', 'MYCOM LANKA SYSTEM BAL PAYMENT', '30000', '0', '0', NULL, NULL),
('1074', '0', '91', '2016-01-22', '0252', 'MYCOM LANKA SYSTEM BAL PAYMENT', '-30000', '0', '0', NULL, NULL),
('1075', '1', '51', '2015-04-01', '4153', 'Payment for electricity expenses', '75700', '0', '0', NULL, NULL),
('1076', '1', '51', '2015-04-01', '0300', '', '-75700', '0', '0', NULL, NULL),
('1077', '1', '52', '2015-04-01', '4200', 'Loan settlement amount for 2 month', '20000', '0', '0', NULL, NULL),
('1078', '1', '52', '2015-04-01', '0300', '', '-20000', '0', '0', NULL, NULL),
('1079', '0', '92', '2015-04-01', '2000', 'Food item purchase', '0', '0', '0', NULL, NULL),
('1080', '0', '92', '2015-04-01', '4168', 'Gas Tank Purchased', '0', '0', '0', NULL, NULL),
('1081', '0', '92', '2015-04-01', '4163', 'Traviling and transport expenses', '0', '0', '0', NULL, NULL),
('1082', '0', '92', '2015-04-01', '4165', 'stationery purchsed expenses', '0', '0', '0', NULL, NULL),
('1083', '0', '92', '2015-04-01', '4167', 'Other expenses', '0', '0', '0', NULL, NULL),
('1084', '0', '92', '2015-04-01', '4166', 'Maitain expenses', '0', '0', '0', NULL, NULL),
('1085', '0', '92', '2015-04-01', '3000', '', '0', '0', '0', NULL, NULL),
('1086', '0', '93', '2015-04-01', '2000', 'Food item purchase', '16888', '0', '0', NULL, NULL),
('1087', '0', '93', '2015-04-01', '4168', 'Gas Tank Purchased', '5219', '0', '0', NULL, NULL),
('1088', '0', '93', '2015-04-01', '4163', 'Traviling and transport expenses', '200', '0', '0', NULL, NULL),
('1089', '0', '93', '2015-04-01', '4165', 'stationery purchsed expenses', '175', '0', '0', NULL, NULL),
('1090', '0', '93', '2015-04-01', '4167', 'Other expenses', '1067', '0', '0', NULL, NULL),
('1091', '0', '93', '2015-04-01', '4166', 'Maitain expenses', '835', '0', '0', NULL, NULL),
('1092', '0', '93', '2015-04-01', '0300', '', '-24384', '0', '0', NULL, NULL),
('1093', '1', '53', '2015-04-01', '4167', 'Other expenses', '912', '0', '0', NULL, NULL),
('1094', '1', '53', '2015-04-01', '0300', '', '-912', '0', '0', NULL, NULL),
('1095', '1', '54', '2015-04-06', '2000', 'Food item purchase', '4620', '0', '0', NULL, NULL),
('1096', '1', '54', '2015-04-06', '0300', '', '-4620', '0', '0', NULL, NULL),
('1097', '1', '55', '2015-04-07', '2000', 'Food item purchase', '21652', '0', '0', NULL, NULL),
('1098', '1', '55', '2015-04-07', '4168', 'Gas Tank Purchased', '10438', '0', '0', NULL, NULL),
('1099', '1', '55', '2015-04-07', '4163', 'Traviling and transport expenses', '80', '0', '0', NULL, NULL),
('1100', '1', '55', '2015-04-07', '4166', 'Maitain expenses', '2630', '0', '0', NULL, NULL),
('1101', '1', '55', '2015-04-07', '0300', '', '-34800', '0', '0', NULL, NULL),
('1102', '1', '56', '2015-04-09', '4169', 'Staff transport expenses', '7000', '0', '0', NULL, NULL),
('1103', '1', '56', '2015-04-09', '0300', '', '-7000', '0', '0', NULL, NULL),
('1104', '1', '57', '2015-04-15', '4170', 'EPF payment for JANUARY &amp; FEBRUARY 2015', '50313.71', '0', '0', NULL, NULL),
('1105', '1', '57', '2015-04-15', '0300', '', '-50313.71', '0', '0', NULL, NULL),
('1106', '1', '58', '2015-04-15', '4171', 'ETF payment for JAN &amp; FEB 2015', '7547.06', '0', '0', NULL, NULL),
('1107', '1', '58', '2015-04-15', '0300', '', '-7547.06', '0', '0', NULL, NULL),
('1108', '1', '59', '2015-04-16', '4170', 'EPF payment for MARCH 2015', '46900', '0', '0', NULL, NULL),
('1109', '1', '59', '2015-04-16', '0300', '', '-46900', '0', '0', NULL, NULL),
('1110', '1', '60', '2015-04-16', '4171', 'ETF payment for MARCH 2015', '7035', '0', '0', NULL, NULL),
('1111', '1', '60', '2015-04-16', '0300', '', '-7035', '0', '0', NULL, NULL),
('1112', '1', '61', '2015-04-17', '2000', 'Food item purchase', '12525', '0', '0', NULL, NULL),
('1113', '1', '61', '2015-04-17', '4168', 'Gas Tank Purchased', '10438', '0', '0', NULL, NULL),
('1114', '1', '61', '2015-04-17', '4163', 'Traviling and transport expenses', '230', '0', '0', NULL, NULL),
('1115', '1', '61', '2015-04-17', '4166', 'Maitain expenses', '650', '0', '0', NULL, NULL),
('1116', '1', '61', '2015-04-17', '0300', '', '-23843', '0', '0', NULL, NULL),
('1117', '1', '62', '2015-04-22', '2000', 'Food item purchase', '2325', '0', '0', NULL, NULL),
('1118', '1', '62', '2015-04-22', '4163', 'Traviling and transport expenses', '270', '0', '0', NULL, NULL),
('1119', '1', '62', '2015-04-22', '0300', '', '-2595', '0', '0', NULL, NULL),
('1120', '1', '63', '2015-04-22', '2000', 'Food item purchase', '18295', '0', '0', NULL, NULL),
('1121', '1', '63', '2015-04-22', '4163', 'Traviling and transport expenses', '200', '0', '0', NULL, NULL),
('1122', '1', '63', '2015-04-22', '4166', 'Maintain expenses', '900', '0', '0', NULL, NULL),
('1123', '1', '63', '2015-04-22', '4169', 'Staff transport expenses', '400', '0', '0', NULL, NULL),
('1124', '1', '63', '2015-04-22', '4162', 'Packing matrials', '1100', '0', '0', NULL, NULL),
('1125', '1', '63', '2015-04-22', '0300', '', '-20895', '0', '0', NULL, NULL),
('1126', '1', '64', '2015-04-22', '4164', 'Office cleaning expenses', '1420', '0', '0', NULL, NULL),
('1127', '1', '64', '2015-04-22', '0300', '', '-1420', '0', '0', NULL, NULL),
('1128', '1', '65', '2015-04-24', '4200', 'Salary Payment for the month of april - Golden Palm', '253797.14', '0', '0', NULL, NULL),
('1129', '1', '65', '2015-04-24', '0300', '', '-253797.14', '0', '0', NULL, NULL),
('1130', '1', '66', '2015-04-29', '2000', 'Food item purchase', '20679', '0', '0', NULL, NULL),
('1131', '1', '66', '2015-04-29', '0001', 'Beverage item purchase', '1600', '0', '0', NULL, NULL),
('1132', '1', '66', '2015-04-29', '4168', 'Gas Tank Purchased', '5559', '0', '0', NULL, NULL),
('1133', '1', '66', '2015-04-29', '4163', 'Traviling and transport expenses', '300', '0', '0', NULL, NULL),
('1134', '1', '66', '2015-04-29', '4165', 'stationery purchsed expenses', '618', '0', '0', NULL, NULL),
('1135', '1', '66', '2015-04-29', '4166', 'Maintain expenses', '825', '0', '0', NULL, NULL),
('1136', '1', '66', '2015-04-29', '4167', 'Other expenses', '250', '0', '0', NULL, NULL),
('1137', '1', '66', '2015-04-29', '4169', 'Staff transport expenses', '200', '0', '0', NULL, NULL),
('1138', '1', '66', '2015-04-29', '0300', '', '-30031', '0', '0', NULL, NULL),
('1139', '1', '67', '2015-05-05', '2000', 'Food item purchase', '2700', '0', '0', NULL, NULL),
('1140', '1', '67', '2015-05-05', '4163', 'Traviling and transport expenses', '300', '0', '0', NULL, NULL),
('1141', '1', '67', '2015-05-05', '0300', '', '-3000', '0', '0', NULL, NULL),
('1142', '1', '68', '2015-05-07', '2000', 'Food item purchase', '24057', '0', '0', NULL, NULL),
('1143', '1', '68', '2015-05-07', '0300', '', '-24057', '0', '0', NULL, NULL),
('1144', '1', '69', '2015-05-07', '2000', 'Food item purchase', '8000', '0', '0', NULL, NULL),
('1145', '1', '69', '2015-05-07', '0300', '', '-8000', '0', '0', NULL, NULL),
('1146', '2', '32', '2015-04-24', '0251', 'Inter company Transfers', '-150000', '0', '0', NULL, NULL),
('1147', '2', '32', '2015-04-24', '0300', '', '150000', '0', '0', NULL, NULL),
('1148', '2', '33', '2015-05-12', '0251', 'Interest recived', '-1975.07', '0', '0', NULL, NULL),
('1149', '2', '33', '2015-05-12', '0300', '', '1975.07', '0', '0', NULL, NULL),
('1150', '1', '70', '2015-05-15', '4169', 'Staff transport expenses', '7000', '0', '0', NULL, NULL),
('1151', '1', '70', '2015-05-15', '0300', '', '-7000', '0', '0', NULL, NULL),
('1152', '1', '71', '2015-05-20', '2000', 'Food item purchase', '30893', '0', '0', NULL, NULL),
('1153', '1', '71', '2015-05-20', '4168', 'Gas Tank Purchased', '10438', '0', '0', NULL, NULL),
('1154', '1', '71', '2015-05-20', '4166', 'Maintain expenses', '1320', '0', '0', NULL, NULL),
('1155', '1', '71', '2015-05-20', '4162', 'Packing matrials', '2305', '0', '0', NULL, NULL),
('1156', '1', '71', '2015-05-20', '0300', '', '-44956', '0', '0', NULL, NULL),
('1157', '1', '72', '2015-05-22', '4200', 'Balance salary payment', '5000', '0', '0', NULL, NULL),
('1158', '1', '72', '2015-05-22', '0300', '', '-5000', '0', '0', NULL, NULL),
('1159', '2', '34', '2015-05-22', '0264', 'Deposite -47573', '-5068.57', '0', '0', NULL, NULL),
('1160', '2', '34', '2015-05-22', '0256', ' 	Deposite - 951533', '-9591.07', '0', '0', NULL, NULL),
('1161', '2', '34', '2015-05-22', '0263', ' 	Deposite - 47490', '-9841.07', '0', '0', NULL, NULL),
('1162', '2', '34', '2015-05-22', '0260', 'Deposite - 47490', '-91569.4', '0', '0', NULL, NULL),
('1163', '2', '34', '2015-05-22', '0251', 'Deposite - 54420', '-167515.67', '0', '0', NULL, NULL),
('1164', '2', '34', '2015-05-22', '0257', 'Deposite - 56704', '-17000.24', '0', '0', NULL, NULL),
('1165', '2', '34', '2015-05-22', '0259', 'Deposite - 852165', '-17000.24', '0', '0', NULL, NULL),
('1166', '2', '34', '2015-05-22', '0255', 'Deposite - 960641', '-24098.57', '0', '0', NULL, NULL),
('1167', '2', '34', '2015-05-22', '0253', 'Deposite - 960887', '-15916.9', '0', '0', NULL, NULL),
('1168', '2', '34', '2015-05-22', '0261', 'Deposite - 984279', '-15916.9', '0', '0', NULL, NULL),
('1169', '2', '34', '2015-05-22', '0254', 'Deposite - 984279', '-200000', '0', '0', NULL, NULL),
('1170', '2', '34', '2015-05-22', '0252', 'Deposite - 984363', '-53836.07', '0', '0', NULL, NULL),
('1171', '2', '34', '2015-05-22', '0262', 'Deposite - 47208', '-14091.07', '0', '0', NULL, NULL),
('1172', '2', '34', '2015-05-22', '0300', '', '641445.77', '0', '0', NULL, NULL),
('1173', '1', '73', '2015-05-23', '0252', 'Salary Payment for the month of may 2015', '53836.07', '0', '0', NULL, NULL),
('1174', '1', '73', '2015-05-23', '0253', 'Salary Payment for the month of may 2015', '15916.9', '0', '0', NULL, NULL),
('1175', '1', '73', '2015-05-23', '0255', 'Salary Payment for the month of may 2015', '24098.57', '0', '0', NULL, NULL),
('1176', '1', '73', '2015-05-23', '0256', 'Salary Payment for the month of may 2015', '9591.07', '0', '0', NULL, NULL),
('1177', '1', '73', '2015-05-23', '0257', 'Salary Payment for the month of may 2015', '17000.24', '0', '0', NULL, NULL),
('1178', '1', '73', '2015-05-23', '0258', 'Salary Payment for the month of may 2015', '17750.24', '0', '0', NULL, NULL),
('1179', '1', '73', '2015-05-23', '0260', 'Salary Payment for the month of may 2015', '91569.4', '0', '0', NULL, NULL),
('1180', '1', '73', '2015-05-23', '0261', 'Salary Payment for the month of may 2015', '15916.9', '0', '0', NULL, NULL),
('1181', '1', '73', '2015-05-23', '0262', 'Salary Payment for the month of may 2015', '14091.07', '0', '0', NULL, NULL),
('1182', '1', '73', '2015-05-23', '0263', 'Salary Payment for the month of may 2015', '9841.07', '0', '0', NULL, NULL),
('1183', '1', '73', '2015-05-23', '0264', 'Salary Payment for the month of may 2015', '5068.57', '0', '0', NULL, NULL),
('1184', '1', '73', '2015-05-23', '0251', 'Salary Payment for the month of may 2015', '167515.67', '0', '0', NULL, NULL),
('1185', '1', '73', '2015-05-23', '4200', 'Salary Payment for the month of may 2015', '263686.07', '0', '0', NULL, NULL),
('1186', '1', '73', '2015-05-23', '4350', 'Bank Charges', '1485.02', '0', '0', NULL, NULL),
('1187', '1', '73', '2015-05-23', '0259', 'Salary Payment for the month of may 2015', '17000.24', '0', '0', NULL, NULL),
('1188', '1', '73', '2015-05-23', '4350', 'Bank Charges', '750', '0', '0', NULL, NULL),
('1189', '1', '73', '2015-05-23', '0300', '', '-725117.1', '0', '0', NULL, NULL),
('1190', '2', '35', '2015-05-23', '0258', 'Deposite -47249', '-17750.24', '0', '0', NULL, NULL),
('1191', '2', '35', '2015-05-23', '0300', '', '17750.24', '0', '0', NULL, NULL),
('1192', '1', '74', '2015-05-26', '2000', 'Food item purchase', '7695', '0', '0', NULL, NULL),
('1193', '1', '74', '2015-05-26', '4163', 'Traviling and transport expenses', '450', '0', '0', NULL, NULL),
('1194', '1', '74', '2015-05-26', '4162', 'Packing matrials', '1700', '0', '0', NULL, NULL),
('1195', '1', '74', '2015-05-26', '0300', '', '-9845', '0', '0', NULL, NULL),
('1196', '1', '75', '2015-05-26', '4170', 'EPF payment for APRIL 2015', '46900', '0', '0', NULL, NULL),
('1197', '1', '75', '2015-05-26', '0300', '', '-46900', '0', '0', NULL, NULL),
('1198', '1', '76', '2015-05-29', '4171', 'ETF payment for APRIL 2015', '7035', '0', '0', NULL, NULL),
('1199', '1', '76', '2015-05-29', '0300', '', '-7035', '0', '0', NULL, NULL),
('1200', '1', '77', '2015-06-08', '2000', 'Food item purchase', '36444', '0', '0', NULL, NULL),
('1201', '1', '77', '2015-06-08', '4168', 'Gas Tank Purchased', '10438', '0', '0', NULL, NULL),
('1202', '1', '77', '2015-06-08', '4166', 'Maintain expenses', '1270', '0', '0', NULL, NULL),
('1203', '1', '77', '2015-06-08', '4162', 'Maintain expenses', '2380', '0', '0', NULL, NULL),
('1204', '1', '77', '2015-06-08', '0300', '', '-50532', '0', '0', NULL, NULL),
('1205', '1', '78', '2015-06-09', '4169', 'Staff transport expenses', '7000', '0', '0', NULL, NULL),
('1206', '1', '78', '2015-06-09', '0300', '', '-7000', '0', '0', NULL, NULL),
('1207', '4', '204', '2015-06-09', '0300', 'From Sampath Bank To Petty Cash', '-15000', '0', '0', NULL, NULL),
('1208', '4', '204', '2015-06-09', '0302', 'From Sampath Bank To Petty Cash', '15000', '0', '0', NULL, NULL),
('1209', '4', '205', '2015-06-09', '0301', 'From Cash In Hand To Sampath Bank', '-81650', '0', '0', NULL, NULL),
('1210', '4', '205', '2015-06-09', '0300', 'From Cash In Hand To Sampath Bank', '81650', '0', '0', NULL, NULL),
('1211', '1', '79', '2016-03-31', '4250', 'Staff uniform', '0', '0', '0', NULL, NULL),
('1212', '1', '79', '2016-03-31', '0300', '', '0', '0', '0', NULL, NULL),
('1213', '2', '36', '2015-06-24', '0251', 'Deposite for salary ', '-199082.2', '0', '0', NULL, NULL),
('1214', '2', '36', '2015-06-24', '0252', 'Deposite for salary ', '-52750', '0', '0', NULL, NULL),
('1215', '2', '36', '2015-06-24', '0253', 'Deposite for salary', '-15883.34', '0', '0', NULL, NULL),
('1216', '2', '36', '2015-06-24', '0255', 'Deposite for salary ', '-23050', '0', '0', NULL, NULL),
('1217', '2', '36', '2015-06-24', '0256', 'Deposite for salary', '-9550', '0', '0', NULL, NULL),
('1218', '2', '36', '2015-06-24', '0257', 'Deposite for salary ', '-16133.33', '0', '0', NULL, NULL),
('1219', '2', '36', '2015-06-24', '0258', 'Deposite for salary ', '-16883.34', '0', '0', NULL, NULL),
('1220', '2', '36', '2015-06-24', '0259', 'Deposite for salary ', '-16133.33', '0', '0', NULL, NULL),
('1221', '2', '36', '2015-06-24', '0260', 'Deposite for salary ', '-91483.33', '0', '0', NULL, NULL),
('1222', '2', '36', '2015-06-24', '0261', 'Deposite for salary ', '-15883.33', '0', '0', NULL, NULL),
('1223', '2', '36', '2015-06-24', '0262', 'Deposite for salary ', '-14050', '0', '0', NULL, NULL),
('1224', '2', '36', '2015-06-24', '0263', ' 	Deposite for salary ', '-9800', '0', '0', NULL, NULL),
('1225', '2', '36', '2015-06-24', '0264', 'Deposite for salary ', '-5050', '0', '0', NULL, NULL),
('1226', '2', '36', '2015-06-24', '0253', 'Fund Transfer to golden plam', '-150000', '0', '0', NULL, NULL),
('1227', '2', '36', '2015-06-24', '0300', '', '635732.2', '0', '0', NULL, NULL),
('1228', '1', '80', '2015-06-17', '4250', 'Staff uniform', '20195', '0', '0', NULL, NULL),
('1229', '1', '80', '2015-06-17', '0300', '', '-20195', '0', '0', NULL, NULL),
('1230', '1', '81', '2015-06-25', '4170', 'EPF payment for MAY 2015', '46900', '0', '0', NULL, NULL),
('1231', '1', '81', '2015-06-25', '4171', 'ETF payment for MAY 2015', '7035', '0', '0', NULL, NULL),
('1232', '1', '81', '2015-06-25', '0300', '', '-53935', '0', '0', NULL, NULL),
('1233', '1', '82', '2015-06-25', '0251', 'Salary and wages', '199082.2', '0', '0', NULL, NULL),
('1234', '1', '82', '2015-06-25', '0252', 'Salary and wages', '52750', '0', '0', NULL, NULL),
('1235', '1', '82', '2015-06-25', '0253', 'Salary and wages', '15883.34', '0', '0', NULL, NULL),
('1236', '1', '82', '2015-06-25', '0255', 'Salary and wages', '23050', '0', '0', NULL, NULL),
('1237', '1', '82', '2015-06-25', '0256', 'Salary and wages', '9550', '0', '0', NULL, NULL),
('1238', '1', '82', '2015-06-25', '0257', 'Salary and wages', '16133.33', '0', '0', NULL, NULL),
('1239', '1', '82', '2015-06-25', '0258', 'Salary and wages', '16883.34', '0', '0', NULL, NULL),
('1240', '1', '82', '2015-06-25', '0259', 'Salary and wages', '16133.33', '0', '0', NULL, NULL),
('1241', '1', '82', '2015-06-25', '0260', 'Salary and wages', '91483.33', '0', '0', NULL, NULL),
('1242', '1', '82', '2015-06-25', '0261', 'Salary and wages', '15883.33', '0', '0', NULL, NULL),
('1243', '1', '82', '2015-06-25', '0262', 'Salary and wages', '14050', '0', '0', NULL, NULL),
('1244', '1', '82', '2015-06-25', '0263', 'Salary and wages', '9800', '0', '0', NULL, NULL),
('1245', '1', '82', '2015-06-25', '0264', 'Salary and wages', '5050', '0', '0', NULL, NULL),
('1246', '1', '82', '2015-06-25', '4200', 'Salary and wages', '274486.67', '0', '0', NULL, NULL),
('1247', '1', '82', '2015-06-25', '4350', 'Bank Charges', '100', '0', '0', NULL, NULL),
('1248', '1', '82', '2015-06-25', '0300', '', '-760318.87', '0', '0', NULL, NULL),
('1249', '2', '37', '2015-07-02', '0251', 'Interest recived', '0', '0', '0', NULL, NULL),
('1250', '2', '37', '2015-07-02', '0300', '', '0', '0', '0', NULL, NULL),
('1251', '4', '206', '2015-06-29', '0301', 'From Cash In Hand To Sampath Bank', '0', '0', '0', NULL, NULL),
('1252', '4', '206', '2015-06-29', '0300', 'From Cash In Hand To Sampath Bank', '0', '0', '0', NULL, NULL),
('1253', '2', '38', '2015-07-02', '0251', '	Interest recived', '-4016.71', '0', '0', NULL, NULL),
('1254', '2', '38', '2015-07-02', '0300', '', '4016.71', '0', '0', NULL, NULL),
('1255', '1', '83', '2016-03-31', '4167', 'Business card print for the chief', '0', '0', '0', NULL, NULL),
('1256', '1', '83', '2016-03-31', '0300', '', '0', '0', '0', NULL, NULL),
('1257', '1', '84', '2015-07-09', '4169', 'Staff transport expenses', '7000', '0', '0', NULL, NULL),
('1258', '1', '84', '2015-07-09', '0300', '', '-7000', '0', '0', NULL, NULL),
('1259', '1', '85', '2015-07-09', '4250', 'Staff uniform', '6870', '0', '0', NULL, NULL),
('1260', '1', '85', '2015-07-09', '0300', '', '-6870', '0', '0', NULL, NULL),
('1261', '1', '86', '2016-03-31', '4157', 'Telephone &amp; Internet expenses', '0', '0', '0', NULL, NULL),
('1262', '1', '86', '2016-03-31', '0300', '', '0', '0', '0', NULL, NULL),
('1263', '1', '87', '2015-07-10', '4157', 'Telephone &amp; Internet expenses', '13559.74', '0', '0', NULL, NULL),
('1264', '1', '87', '2015-07-10', '0300', '', '-13559.74', '0', '0', NULL, NULL),
('1265', '1', '88', '2015-07-18', '2000', 'Food item purchase', '67698', '0', '0', NULL, NULL),
('1266', '1', '88', '2015-07-18', '0300', '', '-67698', '0', '0', NULL, NULL),
('1267', '2', '39', '2015-07-21', '0253', 'Fund Transfer to golden plam', '-200000', '0', '0', NULL, NULL),
('1268', '2', '39', '2015-07-21', '0300', '', '200000', '0', '0', NULL, NULL),
('1269', '4', '207', '2015-07-29', '0300', 'From Sampath Bank To Bank Of Celyon', '-25000', '0', '0', NULL, NULL),
('1270', '4', '207', '2015-07-29', '0303', 'From Sampath Bank To Bank Of Celyon', '25000', '0', '0', NULL, NULL),
('1271', '1', '89', '2015-07-24', '4170', 'payment for JUNE 2015', '48366.67', '0', '0', NULL, NULL),
('1272', '1', '89', '2015-07-24', '0300', '', '-48366.67', '0', '0', NULL, NULL),
('1273', '1', '90', '2015-07-24', '4171', 'ETF payment for JUNE 2015', '7255', '0', '0', NULL, NULL),
('1274', '1', '90', '2015-07-24', '0300', '', '-7255', '0', '0', NULL, NULL),
('1275', '4', '208', '2015-07-29', '0303', 'From Bank Of Celyon To Sampath Bank', '-25000', '0', '0', NULL, NULL),
('1276', '4', '208', '2015-07-29', '0300', 'From Bank Of Celyon To Sampath Bank', '25000', '0', '0', NULL, NULL),
('1277', '1', '91', '2015-07-06', '4167', 'Business card print for the chief', '2340', '0', '0', NULL, NULL),
('1278', '1', '91', '2015-07-06', '0300', '', '-2340', '0', '0', NULL, NULL),
('1279', '1', '92', '2015-07-25', '0251', 'Salary and wages', '199082.2', '0', '0', NULL, NULL),
('1280', '1', '92', '2015-07-25', '0252', 'Salary and wages', '52750', '0', '0', NULL, NULL),
('1281', '1', '92', '2015-07-25', '0253', 'Salary and wages', '15883.34', '0', '0', NULL, NULL),
('1282', '1', '92', '2015-07-25', '0255', 'Salary and wages', '23050', '0', '0', NULL, NULL),
('1283', '1', '92', '2015-07-25', '0256', 'Salary and wages', '9550', '0', '0', NULL, NULL),
('1284', '1', '92', '2015-07-25', '0257', 'Salary and wages', '16133.33', '0', '0', NULL, NULL),
('1285', '1', '92', '2015-07-25', '0258', 'Salary and wages', '16883.34', '0', '0', NULL, NULL),
('1286', '1', '92', '2015-07-25', '0259', 'Salary and wages', '16133.33', '0', '0', NULL, NULL),
('1287', '1', '92', '2015-07-25', '0260', 'Salary and wages', '91483.33', '0', '0', NULL, NULL),
('1288', '1', '92', '2015-07-25', '0261', 'Salary and wages', '15883.33', '0', '0', NULL, NULL),
('1289', '1', '92', '2015-07-25', '0262', 'Salary and wages', '14050', '0', '0', NULL, NULL),
('1290', '1', '92', '2015-07-25', '0263', 'Salary and wages', '9800', '0', '0', NULL, NULL),
('1291', '1', '92', '2015-07-25', '0264', 'Salary and wages', '5050', '0', '0', NULL, NULL),
('1292', '1', '92', '2015-07-25', '4200', 'Salary and wages', '275529.33', '0', '0', NULL, NULL),
('1293', '1', '92', '2015-07-25', '4350', 'Bank Charges', '100', '0', '0', NULL, NULL),
('1294', '1', '92', '2015-07-25', '0300', '', '-761361.53', '0', '0', NULL, NULL),
('1295', '2', '40', '2015-07-25', '0251', 'Salary and wages', '-199082.2', '0', '0', NULL, NULL),
('1296', '2', '40', '2015-07-25', '0252', 'Salary and wages', '-52750', '0', '0', NULL, NULL),
('1297', '2', '40', '2015-07-25', '0253', 'Salary and wages', '-15883.34', '0', '0', NULL, NULL),
('1298', '2', '40', '2015-07-25', '0255', 'Salary and wages', '-23050', '0', '0', NULL, NULL),
('1299', '2', '40', '2015-07-25', '0256', 'Salary and wages', '-9550', '0', '0', NULL, NULL),
('1300', '2', '40', '2015-07-25', '0257', 'Salary and wages', '-16133.33', '0', '0', NULL, NULL),
('1301', '2', '40', '2015-07-25', '0258', 'Salary and wages', '-16883.34', '0', '0', NULL, NULL),
('1302', '2', '40', '2015-07-25', '0259', 'Salary and wages', '-16133.33', '0', '0', NULL, NULL),
('1303', '2', '40', '2015-07-25', '0260', 'Salary and wages', '-91483.33', '0', '0', NULL, NULL),
('1304', '2', '40', '2015-07-25', '0261', 'Salary and wages', '-15883.33', '0', '0', NULL, NULL),
('1305', '2', '40', '2015-07-25', '0262', 'Salary and wages', '-14050', '0', '0', NULL, NULL),
('1306', '2', '40', '2015-07-25', '0263', ' 	Salary and wages', '-9800', '0', '0', NULL, NULL),
('1307', '2', '40', '2015-07-25', '0264', 'Salary and wages', '-5050', '0', '0', NULL, NULL),
('1308', '2', '40', '2015-07-25', '0300', '', '485732.2', '0', '0', NULL, NULL),
('1309', '1', '93', '2015-07-30', '0251', 'OD interest', '600', '0', '0', NULL, NULL),
('1310', '1', '93', '2015-07-30', '0300', '', '-600', '0', '0', NULL, NULL),
('1311', '1', '94', '2015-08-11', '2000', 'Food item purchase', '11800', '0', '0', NULL, NULL),
('1312', '1', '94', '2015-08-11', '0300', '', '-11800', '0', '0', NULL, NULL),
('1313', '1', '95', '2015-08-12', '2000', 'Staff Loan', '20000', '0', '0', NULL, NULL),
('1314', '1', '95', '2015-08-12', '0300', '', '-20000', '0', '0', NULL, NULL),
('1315', '1', '96', '2015-08-12', '4350', 'Bank Charges', '1000', '0', '0', NULL, NULL),
('1316', '1', '96', '2015-08-12', '0300', '', '-1000', '0', '0', NULL, NULL),
('1317', '2', '41', '2015-08-12', '0251', 'Interest recived', '-2041.64', '0', '0', NULL, NULL),
('1318', '2', '41', '2015-08-12', '0300', '', '2041.64', '0', '0', NULL, NULL),
('1319', '1', '97', '2015-08-13', '4169', 'Staff transport expenses', '8500', '0', '0', NULL, NULL),
('1320', '1', '97', '2015-08-13', '0300', '', '-8500', '0', '0', NULL, NULL),
('1321', '2', '42', '2015-08-25', '0254', 'Salary and wages', '-684732', '0', '0', NULL, NULL),
('1322', '2', '42', '2015-08-25', '0300', '', '684732', '0', '0', NULL, NULL),
('1323', '1', '98', '2015-08-25', '4200', 'Salary and wages', '286620', '0', '0', NULL, NULL),
('1324', '1', '98', '2015-08-25', '0254', 'Salary and wages', '469402.2', '0', '0', NULL, NULL),
('1325', '1', '98', '2015-08-25', '4350', 'Bank Charges', '750', '0', '0', NULL, NULL),
('1326', '1', '98', '2015-08-25', '0300', '', '-756772.2', '0', '0', NULL, NULL),
('1327', '1', '99', '2015-08-26', '4164', 'Office cleaning expenses', '455', '0', '0', NULL, NULL),
('1328', '1', '99', '2015-08-26', '0300', '', '-455', '0', '0', NULL, NULL),
('1329', '1', '100', '2015-08-26', '4170', 'EPF payment for July 2015', '48595.33', '0', '0', NULL, NULL),
('1330', '1', '100', '2015-08-26', '0300', '', '-48595.33', '0', '0', NULL, NULL),
('1331', '1', '101', '2015-08-26', '4171', 'ETF payment for JULY 2015', '7289', '0', '0', NULL, NULL),
('1332', '1', '101', '2015-08-26', '0300', '', '-7289', '0', '0', NULL, NULL),
('1333', '1', '102', '2015-08-26', '4350', 'OD Charges', '50', '0', '0', NULL, NULL),
('1334', '1', '102', '2015-08-26', '0300', '', '-50', '0', '0', NULL, NULL),
('1335', '1', '103', '2015-09-02', '4165', 'stationery purchsed expenses', '4876.25', '0', '0', NULL, NULL),
('1336', '1', '103', '2015-09-02', '0300', '', '-4876.25', '0', '0', NULL, NULL),
('1337', '1', '104', '2015-09-02', '2000', 'Food item purchase', '2370', '0', '0', NULL, NULL),
('1338', '1', '104', '2015-09-02', '4163', 'Traviling and transport expenses', '300', '0', '0', NULL, NULL),
('1339', '1', '104', '2015-09-02', '4166', 'Maintain expenses', '420', '0', '0', NULL, NULL),
('1340', '1', '104', '2015-09-02', '0300', '', '-3090', '0', '0', NULL, NULL),
('1341', '1', '105', '2015-09-07', '4250', 'Staff uniform', '2960', '0', '0', NULL, NULL),
('1342', '1', '105', '2015-09-07', '0300', '', '-2960', '0', '0', NULL, NULL),
('1343', '1', '106', '2015-09-11', '2000', 'Food item purchase', '76251', '0', '0', NULL, NULL),
('1344', '1', '106', '2015-09-11', '0300', '', '-76251', '0', '0', NULL, NULL),
('1345', '1', '107', '2015-09-18', '2000', 'Food item purchase', '13000', '0', '0', NULL, NULL),
('1346', '1', '107', '2015-09-18', '0300', '', '-13000', '0', '0', NULL, NULL),
('1347', '4', '209', '2015-09-18', '0300', 'From Sampath Bank To Cash In Hand', '-17000', '0', '0', NULL, NULL),
('1348', '4', '209', '2015-09-18', '0301', 'From Sampath Bank To Cash In Hand', '17000', '0', '0', NULL, NULL),
('1349', '2', '43', '2015-09-18', '0251', 'interest Recived', '-17000', '0', '0', NULL, NULL),
('1350', '2', '43', '2015-09-18', '0300', '', '17000', '0', '0', NULL, NULL),
('1351', '1', '108', '2015-09-25', '0251', 'Salary and wages', '199082.2', '0', '0', NULL, NULL),
('1352', '1', '108', '2015-09-25', '0252', 'Salary and wages', '27050', '0', '0', NULL, NULL),
('1353', '1', '108', '2015-09-25', '0253', 'Salary and wages', '15883.34', '0', '0', NULL, NULL),
('1354', '1', '108', '2015-09-25', '0255', 'Salary and wage', '23050', '0', '0', NULL, NULL),
('1355', '1', '108', '2015-09-25', '0256', 'Salary and wages', '9550', '0', '0', NULL, NULL),
('1356', '1', '108', '2015-09-25', '0257', 'Salary and wages', '16133.33', '0', '0', NULL, NULL),
('1357', '1', '108', '2015-09-25', '0258', 'Salary and wages', '16883.34', '0', '0', NULL, NULL),
('1358', '1', '108', '2015-09-25', '0259', 'Salary and wages', '16133.33', '0', '0', NULL, NULL),
('1359', '1', '108', '2015-09-25', '0260', 'Salary and wages', '91483.33', '0', '0', NULL, NULL),
('1360', '1', '108', '2015-09-25', '0261', 'Salary and wages', '15883.33', '0', '0', NULL, NULL),
('1361', '1', '108', '2015-09-25', '0262', 'Salary and wages', '14050', '0', '0', NULL, NULL),
('1362', '1', '108', '2015-09-25', '0263', 'Salary and wages', '9800', '0', '0', NULL, NULL),
('1363', '1', '108', '2015-09-25', '0264', 'Salary and wages', '5050', '0', '0', NULL, NULL),
('1364', '1', '108', '2015-09-25', '4200', 'Salary and wages', '271940', '0', '0', NULL, NULL),
('1365', '1', '108', '2015-09-25', '4350', 'Salary and wages', '100', '0', '0', NULL, NULL),
('1366', '1', '108', '2015-09-25', '0300', '', '-732072.2', '0', '0', NULL, NULL),
('1367', '2', '44', '2015-09-25', '0251', 'Salary and wages', '-199082.2', '0', '0', NULL, NULL),
('1368', '2', '44', '2015-09-25', '0252', 'Salary and wages', '-27050', '0', '0', NULL, NULL),
('1369', '2', '44', '2015-09-25', '0253', 'Salary and wages', '-15883.34', '0', '0', NULL, NULL),
('1370', '2', '44', '2015-09-25', '0255', 'Salary and wages', '-23050', '0', '0', NULL, NULL),
('1371', '2', '44', '2015-09-25', '0256', '	Salary and wages', '-9550', '0', '0', NULL, NULL),
('1372', '2', '44', '2015-09-25', '0257', 'Salary and wages', '-16133.33', '0', '0', NULL, NULL),
('1373', '2', '44', '2015-09-25', '0258', 'Salary and wages', '-16883.34', '0', '0', NULL, NULL),
('1374', '2', '44', '2015-09-25', '0259', 'Salary and wages', '-16133.33', '0', '0', NULL, NULL),
('1375', '2', '44', '2015-09-25', '0260', 'Salary and wages', '-91483.33', '0', '0', NULL, NULL),
('1376', '2', '44', '2015-09-25', '0261', 'Salary and wages', '-15883.33', '0', '0', NULL, NULL),
('1377', '2', '44', '2015-09-25', '0262', 'Salary and wages', '-14050', '0', '0', NULL, NULL),
('1378', '2', '44', '2015-09-25', '0263', ' 	Salary and wages', '-9800', '0', '0', NULL, NULL),
('1379', '2', '44', '2015-09-25', '0264', 'Salary and wages', '-5050', '0', '0', NULL, NULL),
('1380', '2', '44', '2015-09-25', '0300', '', '460032.2', '0', '0', NULL, NULL),
('1381', '1', '109', '2015-09-25', '2000', 'Food item purchase', '2600', '0', '0', NULL, NULL),
('1382', '1', '109', '2015-09-25', '0300', '', '-2600', '0', '0', NULL, NULL),
('1383', '2', '45', '2015-09-25', '0252', 'Fund Transfer to golden plam', '-175000', '0', '0', NULL, NULL),
('1384', '2', '45', '2015-09-25', '0300', '', '175000', '0', '0', NULL, NULL),
('1385', '2', '46', '2015-09-28', '4170', 'EPF payment for AUG 2015', '0', '0', '0', NULL, NULL),
('1386', '2', '46', '2015-09-28', '0300', ' 	EP', '0', '0', '0', NULL, NULL),
('1387', '1', '110', '2015-09-28', '4170', 'EPF payment for AUG 2015', '48900', '0', '0', NULL, NULL),
('1388', '1', '110', '2015-09-28', '0300', '', '-48900', '0', '0', NULL, NULL),
('1389', '1', '111', '2015-09-28', '4171', 'ETF payment for AUG 2015', '7335', '0', '0', NULL, NULL),
('1390', '1', '111', '2015-09-28', '0300', '', '-7335', '0', '0', NULL, NULL),
('1391', '2', '47', '2015-09-30', '0251', 'Error Correction', '-2', '0', '0', NULL, NULL),
('1392', '2', '47', '2015-09-30', '0300', '', '2', '0', '0', NULL, NULL),
('1393', '1', '112', '2015-10-09', '4164', 'Office cleaning expenses', '955', '0', '0', NULL, NULL),
('1394', '1', '112', '2015-10-09', '0300', '', '-955', '0', '0', NULL, NULL),
('1395', '1', '113', '2015-10-12', '2000', 'Food item purchase', '2720', '0', '0', NULL, NULL),
('1396', '1', '113', '2015-10-12', '0300', '', '-2720', '0', '0', NULL, NULL),
('1397', '1', '114', '2015-10-12', '2000', 'Food item purchase', '37745', '0', '0', NULL, NULL),
('1398', '1', '114', '2015-10-12', '0300', '', '-37745', '0', '0', NULL, NULL),
('1399', '1', '115', '2015-10-15', '2000', 'Food item purchase', '37661', '0', '0', NULL, NULL),
('1400', '1', '115', '2015-10-15', '0300', '', '-37661', '0', '0', NULL, NULL),
('1401', '2', '48', '2015-10-21', '0251', 'Salary and wages', '-199082.2', '0', '0', NULL, NULL),
('1402', '2', '48', '2015-10-21', '0252', 'Salary and wages', '-27050', '0', '0', NULL, NULL),
('1403', '2', '48', '2015-10-21', '0253', 'Salary and wages', '-15883.34', '0', '0', NULL, NULL),
('1404', '2', '48', '2015-10-21', '0255', 'Salary and wages', '-23050', '0', '0', NULL, NULL),
('1405', '2', '48', '2015-10-21', '0256', ' 	Salary and wages', '-9550', '0', '0', NULL, NULL),
('1406', '2', '48', '2015-10-21', '0257', 'Salary and wages', '-16133.33', '0', '0', NULL, NULL),
('1407', '2', '48', '2015-10-21', '0260', 'Salary and wages', '-16883.34', '0', '0', NULL, NULL),
('1408', '2', '48', '2015-10-21', '0259', 'Salary and wages', '-16133.33', '0', '0', NULL, NULL),
('1409', '2', '48', '2015-10-21', '0260', 'Salary and wages', '-91483.33', '0', '0', NULL, NULL),
('1410', '2', '48', '2015-10-21', '0261', 'Salary and wages', '-15883.33', '0', '0', NULL, NULL),
('1411', '2', '48', '2015-10-21', '0262', 'Salary and wages', '-14050', '0', '0', NULL, NULL),
('1412', '2', '48', '2015-10-21', '0263', 'Salary and wages', '-9800', '0', '0', NULL, NULL),
('1413', '2', '48', '2015-10-21', '0264', 'Salary and wages', '-5050', '0', '0', NULL, NULL),
('1414', '2', '48', '2015-10-21', '0300', '', '460032.2', '0', '0', NULL, NULL),
('1415', '2', '49', '2015-10-21', '0252', 'Fund Transfer to golden plam', '-200000', '0', '0', NULL, NULL),
('1416', '2', '49', '2015-10-21', '0300', '', '200000', '0', '0', NULL, NULL),
('1417', '1', '116', '2015-10-23', '0251', 'Salary and wages', '199082.2', '0', '0', NULL, NULL),
('1418', '1', '116', '2015-10-23', '0252', 'Salary and wages', '27050', '0', '0', NULL, NULL),
('1419', '1', '116', '2015-10-23', '0253', 'Salary and wages', '15883.34', '0', '0', NULL, NULL),
('1420', '1', '116', '2015-10-23', '0255', 'Salary and wages', '23050', '0', '0', NULL, NULL),
('1421', '1', '116', '2015-10-23', '0256', 'Salary and wages', '9550', '0', '0', NULL, NULL),
('1422', '1', '116', '2015-10-23', '0257', 'Salary and wages', '16133.33', '0', '0', NULL, NULL),
('1423', '1', '116', '2015-10-23', '0258', 'Salary and wages', '16883.34', '0', '0', NULL, NULL),
('1424', '1', '116', '2015-10-23', '0259', 'Salary and wages', '16133.33', '0', '0', NULL, NULL),
('1425', '1', '116', '2015-10-23', '0260', 'Salary and wages', '91483.33', '0', '0', NULL, NULL),
('1426', '1', '116', '2015-10-23', '0261', 'Salary and wages', '15883.33', '0', '0', NULL, NULL),
('1427', '1', '116', '2015-10-23', '0262', 'Salary and wages', '14050', '0', '0', NULL, NULL),
('1428', '1', '116', '2015-10-23', '0263', 'Salary and wages', '9800', '0', '0', NULL, NULL),
('1429', '1', '116', '2015-10-23', '0264', 'Salary and wages', '5050', '0', '0', NULL, NULL),
('1430', '1', '116', '2015-10-23', '4200', 'Salary and wages', '271940', '0', '0', NULL, NULL),
('1431', '1', '116', '2015-10-23', '4350', 'Bank Charges', '100', '0', '0', NULL, NULL),
('1432', '1', '116', '2015-10-23', '0300', '', '-732072.2', '0', '0', NULL, NULL),
('1433', '1', '117', '2015-10-28', '2000', 'Food item purchase', '4430', '0', '0', NULL, NULL),
('1434', '1', '117', '2015-10-28', '0300', '', '-4430', '0', '0', NULL, NULL),
('1435', '1', '118', '2015-10-31', '4350', 'OD Charges', '650', '0', '0', NULL, NULL),
('1436', '1', '118', '2015-10-31', '0300', '', '-650', '0', '0', NULL, NULL),
('1437', '1', '119', '2015-11-04', '4165', 'stationery purchsed expenses', '5280', '0', '0', NULL, NULL),
('1438', '1', '119', '2015-11-04', '0300', '', '-5280', '0', '0', NULL, NULL),
('1439', '1', '120', '2015-11-04', '4200', 'NALINDA&#039;S TRAVELLING REIMBESEMENT', '5000', '0', '0', NULL, NULL),
('1440', '1', '120', '2015-11-04', '0300', '', '-5000', '0', '0', NULL, NULL),
('1441', '1', '121', '2015-11-05', '2000', 'Food item purchase', '4440', '0', '0', NULL, NULL),
('1442', '1', '121', '2015-11-05', '4163', 'Traviling and transport expenses', '480', '0', '0', NULL, NULL),
('1443', '1', '121', '2015-11-05', '0300', '', '-4920', '0', '0', NULL, NULL),
('1444', '1', '122', '2015-11-12', '4169', 'Staff transport expenses', '8500', '0', '0', NULL, NULL),
('1445', '1', '122', '2015-11-12', '0300', '', '-8500', '0', '0', NULL, NULL),
('1446', '2', '50', '2015-11-12', '0251', '	Interest recived', '-2495.34', '0', '0', NULL, NULL),
('1447', '2', '50', '2015-11-12', '0300', '', '2495.34', '0', '0', NULL, NULL),
('1448', '1', '123', '2015-11-13', '2000', '	Food item purchase', '15499', '0', '0', NULL, NULL),
('1449', '1', '123', '2015-11-13', '0300', '', '-15499', '0', '0', NULL, NULL),
('1450', '1', '124', '2015-11-19', '2000', 'Food item purchase', '81306', '0', '0', NULL, NULL),
('1451', '1', '124', '2015-11-19', '4162', 'Packing matrials', '6740', '0', '0', NULL, NULL),
('1452', '1', '124', '2015-11-19', '0300', '', '-88046', '0', '0', NULL, NULL),
('1453', '1', '125', '2015-11-19', '4157', 'Telephone &amp; Internet expenses', '11225.5', '0', '0', NULL, NULL),
('1454', '1', '125', '2015-11-19', '0300', '', '-11225.5', '0', '0', NULL, NULL),
('1455', '1', '126', '2015-11-20', '4171', 'ETF Delay charges', '1565.09', '0', '0', NULL, NULL),
('1456', '1', '126', '2015-11-20', '0300', '', '-1565.09', '0', '0', NULL, NULL),
('1457', '1', '127', '2015-11-20', '4170', 'EPF payment for SEP 2015', '48900', '0', '0', NULL, NULL),
('1458', '1', '127', '2015-11-20', '0300', '', '-48900', '0', '0', NULL, NULL),
('1459', '1', '128', '2015-11-20', '4171', 'ETF payment for SEP 2015', '8435.25', '0', '0', NULL, NULL),
('1460', '1', '128', '2015-11-20', '0300', '', '-8435.25', '0', '0', NULL, NULL),
('1461', '2', '51', '2015-11-23', '0254', 'Salary and wages', '-656532.2', '0', '0', NULL, NULL),
('1462', '2', '51', '2015-11-23', '0300', '', '656532.2', '0', '0', NULL, NULL),
('1463', '1', '129', '2015-11-24', '4200', 'Salary and wages ', '86000', '0', '0', NULL, NULL),
('1464', '1', '129', '2015-11-24', '0300', '', '-86000', '0', '0', NULL, NULL),
('1465', '1', '130', '2015-11-26', '4170', 'EPF payment for OCT 2015', '48900', '0', '0', NULL, NULL),
('1466', '1', '130', '2015-11-26', '0300', '', '-48900', '0', '0', NULL, NULL),
('1467', '1', '131', '2015-11-26', '4171', 'ETF payment for OCT 2015', '7335', '0', '0', NULL, NULL),
('1468', '1', '131', '2015-11-26', '0300', '', '-7335', '0', '0', NULL, NULL),
('1469', '1', '132', '2015-11-30', '4250', 'Staff uniform', '3900', '0', '0', NULL, NULL),
('1470', '1', '132', '2015-11-30', '0300', '', '-3900', '0', '0', NULL, NULL),
('1471', '1', '133', '2015-11-30', '4350', 'OD Charges', '600', '0', '0', NULL, NULL),
('1472', '1', '133', '2015-11-30', '0300', '', '-600', '0', '0', NULL, NULL),
('1473', '1', '134', '2015-11-30', '4200', 'Salary and wages', '177140', '0', '0', NULL, NULL),
('1474', '1', '134', '2015-11-30', '4350', 'Bank Charges', '750', '0', '0', NULL, NULL),
('1475', '1', '134', '2015-11-30', '2000', 'Food item purchase', '455882.2', '0', '0', NULL, NULL),
('1476', '1', '134', '2015-11-30', '0300', '', '-633772.2', '0', '0', NULL, NULL),
('1477', '1', '135', '2015-12-01', '2000', 'Food item purchase', '8500', '0', '0', NULL, NULL),
('1478', '1', '135', '2015-12-01', '0300', '', '-8500', '0', '0', NULL, NULL),
('1479', '1', '136', '2015-12-01', '0260', '	Loan repayment', '50000', '0', '0', NULL, NULL),
('1480', '1', '136', '2015-12-01', '0300', '', '-50000', '0', '0', NULL, NULL),
('1481', '1', '137', '2015-12-01', '2000', 'Food item purchase', '11335', '0', '0', NULL, NULL),
('1482', '1', '137', '2015-12-01', '0300', '', '-11335', '0', '0', NULL, NULL),
('1483', '1', '138', '2015-12-07', '2000', 'Food item purchase', '610', '0', '0', NULL, NULL),
('1484', '1', '138', '2015-12-07', '0300', '', '-610', '0', '0', NULL, NULL),
('1485', '1', '139', '2015-12-07', '4200', 'Salary and wages', '7500', '0', '0', NULL, NULL),
('1486', '1', '139', '2015-12-07', '0300', '', '-7500', '0', '0', NULL, NULL),
('1487', '1', '140', '2015-12-15', '4169', 'Food item purchase', '8500', '0', '0', NULL, NULL),
('1488', '1', '140', '2015-12-15', '0300', '', '-8500', '0', '0', NULL, NULL),
('1489', '1', '141', '2015-12-16', '4167', 'Lunch Expenses', '500', '0', '0', NULL, NULL),
('1490', '1', '141', '2015-12-16', '0300', '', '-500', '0', '0', NULL, NULL),
('1491', '1', '142', '2015-12-16', '0253', '	Fund transfer to golden Plam', '90978', '0', '0', NULL, NULL),
('1492', '1', '142', '2015-12-16', '0300', '', '-90978', '0', '0', NULL, NULL),
('1493', '2', '52', '2015-12-21', '0251', 'Salary and wages', '-200582.2', '0', '0', NULL, NULL),
('1494', '2', '52', '2015-12-21', '0252', 'Salary and wages', '-27050', '0', '0', NULL, NULL),
('1495', '2', '52', '2015-12-21', '0253', 'Salary and wages', '-15882.34', '0', '0', NULL, NULL),
('1496', '2', '52', '2015-12-21', '0255', 'Salary and wages', '-23050', '0', '0', NULL, NULL),
('1497', '2', '52', '2015-12-21', '0256', 'Salary and wages', '-9550', '0', '0', NULL, NULL),
('1498', '2', '52', '2015-12-21', '0257', 'Salary and wages', '-16133.33', '0', '0', NULL, NULL),
('1499', '2', '52', '2015-12-21', '0258', 'Salary and wages', '-16883.34', '0', '0', NULL, NULL),
('1500', '2', '52', '2015-12-21', '0259', 'Salary and wages', '-16133.33', '0', '0', NULL, NULL),
('1501', '2', '52', '2015-12-21', '0260', 'Salary and wages', '-91483.33', '0', '0', NULL, NULL),
('1502', '2', '52', '2015-12-21', '0261', 'Salary and wages', '-15883.33', '0', '0', NULL, NULL),
('1503', '2', '52', '2015-12-21', '0262', 'Salary and wages', '-14050', '0', '0', NULL, NULL),
('1504', '2', '52', '2015-12-21', '0263', 'Salary and wages', '-9800', '0', '0', NULL, NULL),
('1505', '2', '52', '2015-12-21', '0264', 'Salary and wages', '-5050', '0', '0', NULL, NULL),
('1506', '2', '52', '2015-12-21', '0300', '', '461531.2', '0', '0', NULL, NULL),
('1507', '2', '53', '2015-12-21', '0253', 'MANGEMENT FEES', '-250000', '0', '0', NULL, NULL),
('1508', '2', '53', '2015-12-21', '0300', '', '250000', '0', '0', NULL, NULL),
('1509', '1', '143', '2015-12-26', '4200', 'Salary and wages', '86000', '0', '0', NULL, NULL),
('1510', '1', '143', '2015-12-26', '0300', '', '-86000', '0', '0', NULL, NULL),
('1511', '1', '144', '2015-12-22', '0251', 'Salary and wages', '200582.2', '0', '0', NULL, NULL),
('1512', '1', '144', '2015-12-22', '0252', 'Salary and wages', '27050', '0', '0', NULL, NULL),
('1513', '1', '144', '2015-12-22', '0253', 'Salary and wages', '15883.34', '0', '0', NULL, NULL),
('1514', '1', '144', '2015-12-22', '0255', 'Salary and wages', '23050', '0', '0', NULL, NULL),
('1515', '1', '144', '2015-12-22', '0256', 'Salary and wages', '9550', '0', '0', NULL, NULL),
('1516', '1', '144', '2015-12-22', '0257', '	Salary and wages', '16133.33', '0', '0', NULL, NULL),
('1517', '1', '144', '2015-12-22', '0258', 'Salary and wages', '16883.34', '0', '0', NULL, NULL),
('1518', '1', '144', '2015-12-22', '0259', 'Salary and wages', '16133.33', '0', '0', NULL, NULL),
('1519', '1', '144', '2015-12-22', '0260', 'Salary and wages', '91483.33', '0', '0', NULL, NULL),
('1520', '1', '144', '2015-12-22', '0261', 'Salary and wages', '15883.33', '0', '0', NULL, NULL),
('1521', '1', '144', '2015-12-22', '0262', ' 		Salary and wages', '14050', '0', '0', NULL, NULL),
('1522', '1', '144', '2015-12-22', '0263', 'Salary and wages', '9800', '0', '0', NULL, NULL),
('1523', '1', '144', '2015-12-22', '0264', 'Salary and wages', '5050', '0', '0', NULL, NULL),
('1524', '1', '144', '2015-12-22', '4200', 'Salary and wages', '202915', '0', '0', NULL, NULL),
('1525', '1', '144', '2015-12-22', '4350', 'Bank Charges', '100', '0', '0', NULL, NULL),
('1526', '1', '144', '2015-12-22', '0300', '', '-664547.2', '0', '0', NULL, NULL),
('1527', '1', '145', '2015-12-23', '4171', 'ETF payment for NOV 2015', '6885', '0', '0', NULL, NULL),
('1528', '1', '145', '2015-12-23', '0300', '', '-6885', '0', '0', NULL, NULL),
('1529', '1', '146', '2015-12-23', '4170', 'EPF payment for NOV 2015', '45900', '0', '0', NULL, NULL),
('1530', '1', '146', '2015-12-23', '0300', '', '-45900', '0', '0', NULL, NULL),
('1531', '1', '147', '2015-12-23', '4158', 'Audit fee', '2500', '0', '0', NULL, NULL),
('1532', '1', '147', '2015-12-23', '0300', '', '-2500', '0', '0', NULL, NULL),
('1533', '1', '148', '2015-12-29', '2000', 'Food item purchase', '1850', '0', '0', NULL, NULL),
('1534', '1', '148', '2015-12-29', '0300', '', '-1850', '0', '0', NULL, NULL),
('1535', '1', '149', '2015-12-31', '4350', 'Bank Charges', '600', '0', '0', NULL, NULL),
('1536', '1', '149', '2015-12-31', '0300', '', '-600', '0', '0', NULL, NULL),
('1537', '2', '54', '2015-12-31', '0254', 'Error Correction', '-1', '0', '0', NULL, NULL),
('1538', '2', '54', '2015-12-31', '0300', '', '1', '0', '0', NULL, NULL),
('1539', '1', '150', '2016-01-04', '2000', 'Food item purchase', '7295', '0', '0', NULL, NULL),
('1540', '1', '150', '2016-01-04', '0300', '', '-7295', '0', '0', NULL, NULL),
('1541', '1', '151', '2016-01-07', '2000', 'Food item purchase', '77736', '0', '0', NULL, NULL),
('1542', '1', '151', '2016-01-07', '0300', '', '-77736', '0', '0', NULL, NULL),
('1543', '1', '152', '2016-01-11', '4169', 'Staff transport expenses', '8500', '0', '0', NULL, NULL),
('1544', '1', '152', '2016-01-11', '0300', '', '-8500', '0', '0', NULL, NULL),
('1545', '1', '153', '2016-01-11', '4270', 'Staff Loan', '20000', '0', '0', NULL, NULL),
('1546', '1', '153', '2016-01-11', '0300', '', '-20000', '0', '0', NULL, NULL),
('1547', '1', '154', '2016-01-18', '4200', 'Salary Advance ', '50000', '0', '0', NULL, NULL),
('1548', '1', '154', '2016-01-18', '0300', '', '-50000', '0', '0', NULL, NULL),
('1549', '2', '55', '2016-01-20', '0251', 'Salary and wages', '-170582.2', '0', '0', NULL, NULL),
('1550', '2', '55', '2016-01-20', '0252', 'Salary and wages', '-27050', '0', '0', NULL, NULL),
('1551', '2', '55', '2016-01-20', '0253', 'Salary and wages', '-15883.34', '0', '0', NULL, NULL),
('1552', '2', '55', '2016-01-20', '0255', ' 	Salary and wages', '-23050', '0', '0', NULL, NULL),
('1553', '2', '55', '2016-01-20', '0256', ' 	Salary and wages', '-9550', '0', '0', NULL, NULL),
('1554', '2', '55', '2016-01-20', '0257', 'Salary and wages', '-16133.33', '0', '0', NULL, NULL),
('1555', '2', '55', '2016-01-20', '0258', 'Salary and wages', '-16883.34', '0', '0', NULL, NULL),
('1556', '2', '55', '2016-01-20', '0259', 'Salary and wages', '-16133.33', '0', '0', NULL, NULL),
('1557', '2', '55', '2016-01-20', '0260', 'Salary and wages', '-91483.33', '0', '0', NULL, NULL),
('1558', '2', '55', '2016-01-20', '0261', 'Salary and wages', '-15883.33', '0', '0', NULL, NULL),
('1559', '2', '55', '2016-01-20', '0262', 'Salary and wages', '-14050', '0', '0', NULL, NULL),
('1560', '2', '55', '2016-01-20', '0263', 'Salary and wages', '-9800', '0', '0', NULL, NULL),
('1561', '2', '55', '2016-01-20', '0264', 'Salary and wages', '-5050', '0', '0', NULL, NULL),
('1562', '2', '55', '2016-01-20', '0300', '', '431532.2', '0', '0', NULL, NULL);

### Structure of table `6_grn_batch` ###

DROP TABLE IF EXISTS `6_grn_batch`;

CREATE TABLE `6_grn_batch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `purch_order_no` int(11) DEFAULT NULL,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rate` double DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `delivery_date` (`delivery_date`),
  KEY `purch_order_no` (`purch_order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_grn_batch` ###


### Structure of table `6_grn_items` ###

DROP TABLE IF EXISTS `6_grn_items`;

CREATE TABLE `6_grn_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_batch_id` int(11) DEFAULT NULL,
  `po_detail_item` int(11) NOT NULL DEFAULT '0',
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `qty_recd` double NOT NULL DEFAULT '0',
  `quantity_inv` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `grn_batch_id` (`grn_batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_grn_items` ###


### Structure of table `6_groups` ###

DROP TABLE IF EXISTS `6_groups`;

CREATE TABLE `6_groups` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_groups` ###

INSERT INTO `6_groups` VALUES
('1', 'Small', '0'),
('2', 'Medium', '0'),
('3', 'Large', '0');

### Structure of table `6_import_paypal` ###

DROP TABLE IF EXISTS `6_import_paypal`;

CREATE TABLE `6_import_paypal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date` date NOT NULL DEFAULT '0000-00-00',
  `ref` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `person` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `confirmed` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_import_paypal` ###


### Structure of table `6_import_paypal_accounts` ###

DROP TABLE IF EXISTS `6_import_paypal_accounts`;

CREATE TABLE `6_import_paypal_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `person` (`person`),
  KEY `memo` (`memo`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_import_paypal_accounts` ###


### Structure of table `6_item_codes` ###

DROP TABLE IF EXISTS `6_item_codes`;

CREATE TABLE `6_item_codes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` smallint(6) unsigned NOT NULL,
  `quantity` double NOT NULL DEFAULT '1',
  `is_foreign` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `stock_id` (`stock_id`,`item_code`),
  KEY `item_code` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_item_codes` ###

INSERT INTO `6_item_codes` VALUES
('1', '002', '002', ' 	Beverage', '6', '1', '0', '0'),
('2', '001', '001', 'Food', '5', '1', '0', '0');

### Structure of table `6_item_tax_type_exemptions` ###

DROP TABLE IF EXISTS `6_item_tax_type_exemptions`;

CREATE TABLE `6_item_tax_type_exemptions` (
  `item_tax_type_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_tax_type_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_item_tax_type_exemptions` ###


### Structure of table `6_item_tax_types` ###

DROP TABLE IF EXISTS `6_item_tax_types`;

CREATE TABLE `6_item_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `exempt` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_item_tax_types` ###

INSERT INTO `6_item_tax_types` VALUES
('1', 'Regular', '0', '0'),
('2', 'Non tax', '1', '0');

### Structure of table `6_item_units` ###

DROP TABLE IF EXISTS `6_item_units`;

CREATE TABLE `6_item_units` (
  `abbr` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `decimals` tinyint(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`abbr`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_item_units` ###

INSERT INTO `6_item_units` VALUES
(' 	Cone', ' 	Cone', '-1', '0'),
('ea.', ' 	Each', '1', '0'),
('hrs.', 'Hours', '1', '0'),
('kg', 'Kilogram', '-1', '0'),
('l', ' 	Liter', '3', '0'),
('mtr', 'Meters', '-1', '0'),
('nos', ' 	Numbers', '0', '0'),
('Yard', 'Yard', '-1', '0');

### Structure of table `6_journal` ###

DROP TABLE IF EXISTS `6_journal`;

CREATE TABLE `6_journal` (
  `type` smallint(6) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `tran_date` date DEFAULT '0000-00-00',
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `source_ref` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `event_date` date DEFAULT '0000-00-00',
  `doc_date` date NOT NULL DEFAULT '0000-00-00',
  `currency` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_journal` ###

INSERT INTO `6_journal` VALUES
('0', '1', '2015-07-24', '001/2015', '', '2016-11-17', '2015-07-24', 'LKR', '0', '1'),
('0', '2', '2015-12-20', '001/2015', 'Error Correction ', '2015-12-20', '2015-12-21', 'LKR', '132229', '1'),
('0', '3', '2015-12-25', '002/2015', '', '2015-12-25', '2015-12-25', 'LKR', '117783', '1'),
('0', '4', '2015-04-01', '003/2015', '', '2015-03-31', '2015-03-31', 'LKR', '16629839.26', '1'),
('0', '5', '2015-04-02', '004/2015', '', '2016-12-05', '2016-12-05', 'LKR', '8500', '1'),
('0', '6', '2015-07-09', '005/2015', '', '2016-12-05', '2016-12-05', 'LKR', '10000', '1'),
('0', '7', '2015-09-29', '006/2015', '', '2016-12-05', '2016-12-05', 'LKR', '20000', '1'),
('0', '8', '2016-01-08', '001/2016', '', '2016-12-05', '2016-12-05', 'LKR', '75000', '1'),
('0', '9', '2016-01-19', '002/2016', '', '2016-12-05', '2016-12-05', 'LKR', '81710', '1'),
('0', '10', '2016-02-09', '003/2016', '', '2016-12-05', '2016-12-05', 'LKR', '10000', '1'),
('0', '11', '2016-02-18', '004/2016', '', '2016-12-05', '2016-12-05', 'LKR', '6930', '1'),
('0', '12', '2015-09-14', '007/2015', '', '2016-12-05', '2016-12-05', 'LKR', '8500', '1'),
('0', '13', '2015-09-26', '008/2015', '', '2016-12-05', '2016-12-05', 'LKR', '19825', '1'),
('0', '14', '2015-09-30', '009/2015', '', '2016-12-05', '2016-12-05', 'LKR', '22200', '1'),
('0', '15', '2015-11-09', '010/2015', '', '2016-12-05', '2016-12-05', 'LKR', '18530', '1'),
('0', '16', '2015-11-09', '011/2015', '', '2016-12-05', '2016-12-05', 'LKR', '22500', '1'),
('0', '17', '2015-11-09', '012/2015', '', '2016-12-05', '2016-12-05', 'LKR', '3500', '1'),
('0', '18', '2015-11-10', '013/2015', '', '2016-12-05', '2016-12-05', 'LKR', '6271.1', '1'),
('0', '19', '2015-11-11', '014/2015', '', '2016-12-05', '2016-12-05', 'LKR', '15850', '1'),
('0', '20', '2015-11-13', '015/2015', '', '2016-12-05', '2016-12-05', 'LKR', '60000', '1'),
('0', '21', '2015-12-13', '016/2015', '', '2016-12-05', '2016-12-05', 'LKR', '8000', '1'),
('0', '22', '2015-11-13', '017/2015', '', '2016-12-05', '2016-12-05', 'LKR', '4000', '1'),
('0', '23', '2015-11-20', '018/2015', '', '2016-12-05', '2016-12-05', 'LKR', '7500', '1'),
('0', '24', '2015-11-20', '019/2015', '', '2016-12-05', '2016-12-05', 'LKR', '189290', '1'),
('0', '25', '2015-11-23', '020/2015', '', '2016-12-05', '2016-12-05', 'LKR', '13650', '1'),
('0', '26', '2015-11-23', '021/2015', '', '2016-12-05', '2016-12-05', 'LKR', '10000', '1'),
('0', '27', '2015-11-23', '022/2015', '', '2016-12-05', '2016-12-05', 'LKR', '30910', '1'),
('0', '28', '2015-11-23', '023/2015', '', '2016-12-05', '2016-12-05', 'LKR', '9500', '1'),
('0', '29', '2015-04-01', '024/2015', '', '2016-12-06', '2016-12-06', 'LKR', '10750', '1'),
('0', '30', '2015-04-08', '025/2015', '', '2016-12-06', '2016-12-06', 'LKR', '165000', '1'),
('0', '31', '2015-04-08', '026/2015', '', '2016-12-06', '2016-12-06', 'LKR', '10000', '1'),
('0', '32', '2015-04-09', '027/2015', '', '2016-12-06', '2016-12-06', 'LKR', '20000', '1'),
('0', '33', '2015-04-09', '028/2015', '', '2016-12-06', '2016-12-06', 'LKR', '12600', '1'),
('0', '34', '2015-04-10', '029/2015', '', '2016-12-06', '2016-12-06', 'LKR', '75000', '1'),
('0', '35', '2015-04-10', '030/2015', '', '2016-12-06', '2016-12-06', 'LKR', '118723', '1'),
('0', '36', '2015-04-20', '031/2015', '', '2016-12-06', '2016-12-06', 'LKR', '2850', '1'),
('0', '37', '2015-04-23', '032/2015', '', '2016-12-06', '2016-12-06', 'LKR', '500000', '1'),
('0', '38', '2015-04-24', '033/2015', '', '2016-12-06', '2016-12-06', 'LKR', '54295', '1'),
('0', '39', '2015-04-29', '034/2015', '', '2016-12-06', '2016-12-06', 'LKR', '12877', '1'),
('0', '40', '2015-05-11', '035/2015', '', '2016-12-06', '2016-12-06', 'LKR', '40000', '1'),
('0', '41', '2015-05-11', '036/2015', '', '2016-12-06', '2016-12-06', 'LKR', '20000', '1'),
('0', '42', '2015-05-11', '037/2015', '', '2016-12-06', '2016-12-06', 'LKR', '267903.75', '1'),
('0', '43', '2015-05-15', '038/2015', '', '2016-12-06', '2016-12-06', 'LKR', '19788', '1'),
('0', '44', '2015-05-15', '039/2015', '', '2016-12-06', '2016-12-06', 'LKR', '8040', '1'),
('0', '45', '2015-05-21', '040/2015', '', '2016-12-06', '2016-12-06', 'LKR', '200000', '1'),
('0', '46', '2015-05-21', '041/2015', '', '2016-12-06', '2016-12-06', 'LKR', '12000', '1'),
('0', '47', '2015-05-22', '042/2015', '', '2016-12-06', '2016-12-06', 'LKR', '3500', '1'),
('0', '48', '2015-05-22', '043/2015', '', '2016-12-06', '2016-12-06', 'LKR', '15000', '1'),
('0', '49', '2015-06-08', '044/2015', '', '2016-12-06', '2016-12-06', 'LKR', '191538.75', '1'),
('0', '50', '2015-06-10', '045/2015', '', '2016-12-06', '2016-12-06', 'LKR', '10000', '1'),
('0', '51', '2015-06-18', '046/2015', '', '2016-12-06', '2016-12-06', 'LKR', '5877', '1'),
('0', '52', '2015-06-18', '047/2015', '', '2016-12-06', '2016-12-06', 'LKR', '65000', '1'),
('0', '53', '2015-06-24', '048/2015', '', '2016-12-06', '2016-12-06', 'LKR', '23128', '1'),
('0', '54', '2015-07-08', '049/2015', '', '2016-12-06', '2016-12-06', 'LKR', '22050', '1'),
('0', '55', '2015-07-08', '050/2015', '', '2016-12-06', '2016-12-06', 'LKR', '4000', '1'),
('0', '56', '2015-08-11', '051/2015', '', '2016-12-06', '2016-12-06', 'LKR', '9500', '1'),
('0', '57', '2015-08-11', '052/2015', '', '2016-12-06', '2016-12-06', 'LKR', '9500', '1'),
('0', '58', '2015-08-20', '053/2015', '', '2016-12-06', '2016-12-06', 'LKR', '22249', '1'),
('0', '59', '2015-08-27', '054/2015', '', '2016-12-06', '2016-12-06', 'LKR', '5000', '1'),
('0', '60', '2015-09-16', '055/2015', '', '2016-12-06', '2016-12-06', 'LKR', '2000', '1'),
('0', '61', '2015-09-18', '056/2015', '', '2016-12-06', '2016-12-06', 'LKR', '3000', '1'),
('0', '62', '2015-09-25', '057/2015', '', '2016-12-06', '2016-12-06', 'LKR', '890', '1'),
('0', '63', '2015-09-29', '058/2015', '', '2016-12-06', '2016-12-06', 'LKR', '18000', '1'),
('0', '64', '2015-10-01', '059/2015', '', '2016-12-06', '2016-12-06', 'LKR', '5000', '1'),
('0', '65', '2015-10-15', '060/2015', '', '2016-12-06', '2016-12-06', 'LKR', '50000', '1'),
('0', '66', '2015-10-26', '061/2015', '', '2016-12-06', '2016-12-06', 'LKR', '4750', '1'),
('0', '67', '2015-10-26', '062/2015', '', '2016-12-06', '2016-12-06', 'LKR', '4500', '1'),
('0', '68', '2016-02-01', '005/2016', '', '2016-12-06', '2016-12-06', 'LKR', '19890', '1'),
('0', '69', '2015-04-08', '063/2015', '', '2016-12-06', '2016-12-06', 'LKR', '146000', '1'),
('0', '70', '2015-04-09', '064/2015', '', '2016-12-06', '2016-12-06', 'LKR', '3000', '1'),
('0', '71', '2015-07-02', '065/2015', '', '2016-12-06', '2016-12-06', 'LKR', '90596', '1'),
('0', '72', '2015-07-09', '066/2015', '', '2016-12-06', '2016-12-06', 'LKR', '2000', '1'),
('0', '73', '2015-07-29', '067/2015', '', '2016-12-06', '2016-12-06', 'LKR', '17495', '1'),
('0', '74', '2016-02-09', '006/2016', '', '2016-12-06', '2016-12-06', 'LKR', '53636', '1'),
('0', '75', '2016-02-16', '007/2016', '', '2016-12-06', '2016-12-06', 'LKR', '18115', '1'),
('0', '76', '2015-09-01', '068/2015', '', '2016-12-06', '2016-12-06', 'LKR', '38000', '1'),
('0', '77', '2016-03-14', '008/2016', '', '2016-12-06', '2016-12-06', 'LKR', '13000', '1'),
('0', '78', '2016-03-14', '009/2016', '', '2016-12-06', '2016-12-06', 'LKR', '2000', '1'),
('0', '79', '2015-09-21', '069/2015', '', '2016-12-06', '2016-12-06', 'LKR', '2500', '1'),
('0', '80', '2015-11-05', '070/2015', '', '2016-12-06', '2016-12-06', 'LKR', '430000', '1'),
('0', '81', '2015-11-09', '071/2015', '', '2016-12-06', '2016-12-06', 'LKR', '1520', '1'),
('0', '82', '2015-11-09', '072/2015', '', '2016-12-06', '2016-12-06', 'LKR', '17000', '1'),
('0', '83', '2016-03-30', '010/2016', '', '2016-12-06', '2016-12-06', 'LKR', '3480', '1'),
('0', '84', '2015-05-29', '073/2015', '', '2016-12-06', '2016-12-06', 'LKR', '90000', '1'),
('0', '85', '2015-06-01', '074/2015', '', '2016-12-06', '2016-12-06', 'LKR', '10000', '1'),
('0', '86', '2015-06-08', '075/2015', '', '2016-12-06', '2016-12-06', 'LKR', '39470', '1'),
('0', '87', '2015-04-24', '076/2015', '', '2016-12-06', '2016-12-06', 'LKR', '104212.5', '1'),
('0', '88', '2015-09-29', '077/2015', '', '2016-12-06', '2016-12-06', 'LKR', '10000', '1'),
('0', '89', '2015-10-02', '078/2015', '', '2016-12-06', '2016-12-06', 'LKR', '20000', '1'),
('0', '90', '2016-01-07', '011/2016', '', '2016-12-06', '2016-12-06', 'LKR', '100000', '1'),
('0', '91', '2016-01-22', '012/2016', '', '2016-12-06', '2016-12-06', 'LKR', '30000', '1'),
('0', '92', '2015-04-01', '079/2015', '', '2016-12-07', '2016-12-07', 'LKR', '0', '1'),
('0', '93', '2015-04-01', '079/2015', '', '2016-12-07', '2016-12-07', 'LKR', '24384', '1');

### Structure of table `6_loc_stock` ###

DROP TABLE IF EXISTS `6_loc_stock`;

CREATE TABLE `6_loc_stock` (
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `reorder_level` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`loc_code`,`stock_id`),
  KEY `stock_id` (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_loc_stock` ###

INSERT INTO `6_loc_stock` VALUES
('DEF', '001', '0'),
('DEF', '002', '0'),
('LOC1', '001', '0'),
('LOC1', '002', '0');

### Structure of table `6_locations` ###

DROP TABLE IF EXISTS `6_locations`;

CREATE TABLE `6_locations` (
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `location_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fax` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fixed_asset` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_locations` ###

INSERT INTO `6_locations` VALUES
('DEF', 'Default', 'N/A', '', '', '', '', '', '0', '0'),
('LOC1', 'Location 01', '', '', '', '', '', '', '0', '0');

### Structure of table `6_main_category` ###

DROP TABLE IF EXISTS `6_main_category`;

CREATE TABLE `6_main_category` (
  `main_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `main_cat_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL,
  PRIMARY KEY (`main_category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_main_category` ###


### Structure of table `6_main_locations` ###

DROP TABLE IF EXISTS `6_main_locations`;

CREATE TABLE `6_main_locations` (
  `main_loc_id` int(11) NOT NULL AUTO_INCREMENT,
  `main_loc_code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `main_loc_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `inactive` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`main_loc_id`),
  UNIQUE KEY `main_loc_code` (`main_loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_main_locations` ###


### Structure of table `6_payment_terms` ###

DROP TABLE IF EXISTS `6_payment_terms`;

CREATE TABLE `6_payment_terms` (
  `terms_indicator` int(11) NOT NULL AUTO_INCREMENT,
  `terms` char(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `days_before_due` smallint(6) NOT NULL DEFAULT '0',
  `day_in_following_month` smallint(6) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`terms_indicator`),
  UNIQUE KEY `terms` (`terms`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_payment_terms` ###

INSERT INTO `6_payment_terms` VALUES
('1', 'Due 15th Of the Following Month', '0', '17', '0'),
('2', 'Due By End Of The Following Month', '0', '30', '0'),
('3', 'Payment due within 10 days', '10', '0', '0'),
('4', 'Cash Only', '0', '0', '0');

### Structure of table `6_prices` ###

DROP TABLE IF EXISTS `6_prices`;

CREATE TABLE `6_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type_id` int(11) NOT NULL DEFAULT '0',
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `price` (`stock_id`,`sales_type_id`,`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_prices` ###


### Structure of table `6_print_profiles` ###

DROP TABLE IF EXISTS `6_print_profiles`;

CREATE TABLE `6_print_profiles` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `report` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `printer` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile` (`profile`,`report`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_print_profiles` ###

INSERT INTO `6_print_profiles` VALUES
('1', 'Out of office', NULL, '0'),
('2', 'Sales Department', NULL, '0'),
('3', 'Central', NULL, '2'),
('4', 'Sales Department', '104', '2'),
('5', 'Sales Department', '105', '2'),
('6', 'Sales Department', '107', '2'),
('7', 'Sales Department', '109', '2'),
('8', 'Sales Department', '110', '2'),
('9', 'Sales Department', '201', '2');

### Structure of table `6_printers` ###

DROP TABLE IF EXISTS `6_printers`;

CREATE TABLE `6_printers` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `queue` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `host` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `port` smallint(11) unsigned NOT NULL,
  `timeout` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_printers` ###

INSERT INTO `6_printers` VALUES
('1', 'QL500', 'Label printer', 'QL500', 'server', '127', '20'),
('2', 'Samsung', 'Main network printer', 'scx4521F', 'server', '515', '5'),
('3', 'Local', 'Local print server at user IP', 'lp', '', '515', '10');

### Structure of table `6_products_collections` ###

DROP TABLE IF EXISTS `6_products_collections`;

CREATE TABLE `6_products_collections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pc_code` varchar(4) COLLATE utf8_unicode_ci NOT NULL,
  `pc_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `inactive` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pc_code` (`pc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_products_collections` ###


### Structure of table `6_purch_data` ###

DROP TABLE IF EXISTS `6_purch_data`;

CREATE TABLE `6_purch_data` (
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT '0',
  `suppliers_uom` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `conversion_factor` double NOT NULL DEFAULT '1',
  `supplier_description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`supplier_id`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_purch_data` ###


### Structure of table `6_purch_order_details` ###

DROP TABLE IF EXISTS `6_purch_order_details`;

CREATE TABLE `6_purch_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT '0',
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `act_price` double NOT NULL DEFAULT '0',
  `std_cost_unit` double NOT NULL DEFAULT '0',
  `quantity_ordered` double NOT NULL DEFAULT '0',
  `quantity_received` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`),
  KEY `itemcode` (`item_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_purch_order_details` ###


### Structure of table `6_purch_order_details_csv` ###

DROP TABLE IF EXISTS `6_purch_order_details_csv`;

CREATE TABLE `6_purch_order_details_csv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_ref` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `price` double(16,2) DEFAULT NULL,
  `order_date` date NOT NULL,
  `requeried_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_purch_order_details_csv` ###


### Structure of table `6_purch_orders` ###

DROP TABLE IF EXISTS `6_purch_orders`;

CREATE TABLE `6_purch_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `comments` tinytext COLLATE utf8_unicode_ci,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `requisition_no` tinytext COLLATE utf8_unicode_ci,
  `into_stock_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `total` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_purch_orders` ###


### Structure of table `6_quick_entries` ###

DROP TABLE IF EXISTS `6_quick_entries`;

CREATE TABLE `6_quick_entries` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `usage` varchar(120) COLLATE utf8_unicode_ci DEFAULT NULL,
  `base_amount` double NOT NULL DEFAULT '0',
  `base_desc` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bal_type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_quick_entries` ###

INSERT INTO `6_quick_entries` VALUES
('1', '1', 'Maintenance', NULL, '0', 'Amount', '0'),
('2', '4', 'Phone', NULL, '0', 'Amount', '0'),
('3', '2', 'Cash Sales', 'Retail sales without invoice', '0', 'Amount', '0');

### Structure of table `6_quick_entry_lines` ###

DROP TABLE IF EXISTS `6_quick_entry_lines`;

CREATE TABLE `6_quick_entry_lines` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `qid` smallint(6) unsigned NOT NULL,
  `amount` double DEFAULT '0',
  `memo` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `dest_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` smallint(6) unsigned DEFAULT NULL,
  `dimension2_id` smallint(6) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_quick_entry_lines` ###

INSERT INTO `6_quick_entry_lines` VALUES
('1', '1', '0', '', 't-', '1', '0', '0'),
('2', '2', '0', '', 't-', '1', '0', '0'),
('3', '3', '0', '', 't-', '1', '0', '0'),
('4', '3', '0', '', '=', '4100', '0', '0'),
('5', '1', '0', '', '=', '4166', '0', '0'),
('6', '2', '0', '', '=', '4157', '0', '0');

### Structure of table `6_recurrent_invoices` ###

DROP TABLE IF EXISTS `6_recurrent_invoices`;

CREATE TABLE `6_recurrent_invoices` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order_no` int(11) unsigned NOT NULL,
  `debtor_no` int(11) unsigned DEFAULT NULL,
  `group_no` smallint(6) unsigned DEFAULT NULL,
  `days` int(11) NOT NULL DEFAULT '0',
  `monthly` int(11) NOT NULL DEFAULT '0',
  `begin` date NOT NULL DEFAULT '0000-00-00',
  `end` date NOT NULL DEFAULT '0000-00-00',
  `last_sent` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_recurrent_invoices` ###

INSERT INTO `6_recurrent_invoices` VALUES
('1', 'Weekly Maintenance', '6', '1', '1', '7', '0', '2015-04-01', '2020-05-07', '2015-04-08');

### Structure of table `6_reflines` ###

DROP TABLE IF EXISTS `6_reflines`;

CREATE TABLE `6_reflines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` int(11) NOT NULL,
  `prefix` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pattern` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `prefix` (`trans_type`,`prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_reflines` ###

INSERT INTO `6_reflines` VALUES
('1', '0', '', '{001}/{YYYY}', '', '1', '0'),
('2', '1', '', '{001}/{YYYY}', '', '1', '0'),
('3', '2', '', '{001}/{YYYY}', '', '1', '0'),
('4', '4', '', '{001}/{YYYY}', '', '1', '0'),
('5', '10', '', '{001}/{YYYY}', '', '1', '0'),
('6', '11', '', '{001}/{YYYY}', '', '1', '0'),
('7', '12', '', '{001}/{YYYY}', '', '1', '0'),
('8', '13', '', '{001}/{YYYY}', '', '1', '0'),
('9', '16', '', '{001}/{YYYY}', '', '1', '0'),
('10', '17', '', '{001}/{YYYY}', '', '1', '0'),
('11', '18', '', '{001}/{YYYY}', '', '1', '0'),
('12', '20', '', '{001}/{YYYY}', '', '1', '0'),
('13', '21', '', '{001}/{YYYY}', '', '1', '0'),
('14', '22', '', '{001}/{YYYY}', '', '1', '0'),
('15', '25', '', '{001}/{YYYY}', '', '1', '0'),
('16', '26', '', '{001}/{YYYY}', '', '1', '0'),
('17', '28', '', '{001}/{YYYY}', '', '1', '0'),
('18', '29', '', '{001}/{YYYY}', '', '1', '0'),
('19', '30', '', '{001}/{YYYY}', '', '1', '0'),
('20', '32', '', '{001}/{YYYY}', '', '1', '0'),
('21', '35', '', '{001}/{YYYY}', '', '1', '0'),
('22', '40', '', '{001}/{YYYY}', '', '1', '0'),
('23', '50', '', '111121', '', '1', '0');

### Structure of table `6_refs` ###

DROP TABLE IF EXISTS `6_refs`;

CREATE TABLE `6_refs` (
  `id` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`type`),
  KEY `Type_and_Reference` (`type`,`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_refs` ###

INSERT INTO `6_refs` VALUES
('1', '0', '001/2015'),
('2', '0', '001/2015'),
('8', '0', '001/2016'),
('3', '0', '002/2015'),
('9', '0', '002/2016'),
('4', '0', '003/2015'),
('10', '0', '003/2016'),
('5', '0', '004/2015'),
('11', '0', '004/2016'),
('6', '0', '005/2015'),
('68', '0', '005/2016'),
('7', '0', '006/2015'),
('74', '0', '006/2016'),
('12', '0', '007/2015'),
('75', '0', '007/2016'),
('13', '0', '008/2015'),
('77', '0', '008/2016'),
('14', '0', '009/2015'),
('78', '0', '009/2016'),
('15', '0', '010/2015'),
('83', '0', '010/2016'),
('16', '0', '011/2015'),
('90', '0', '011/2016'),
('17', '0', '012/2015'),
('91', '0', '012/2016'),
('18', '0', '013/2015'),
('19', '0', '014/2015'),
('20', '0', '015/2015'),
('21', '0', '016/2015'),
('22', '0', '017/2015'),
('23', '0', '018/2015'),
('24', '0', '019/2015'),
('25', '0', '020/2015'),
('26', '0', '021/2015'),
('27', '0', '022/2015'),
('28', '0', '023/2015'),
('29', '0', '024/2015'),
('30', '0', '025/2015'),
('31', '0', '026/2015'),
('32', '0', '027/2015'),
('33', '0', '028/2015'),
('34', '0', '029/2015'),
('35', '0', '030/2015'),
('36', '0', '031/2015'),
('37', '0', '032/2015'),
('38', '0', '033/2015'),
('39', '0', '034/2015'),
('40', '0', '035/2015'),
('41', '0', '036/2015'),
('42', '0', '037/2015'),
('43', '0', '038/2015'),
('44', '0', '039/2015'),
('45', '0', '040/2015'),
('46', '0', '041/2015'),
('47', '0', '042/2015'),
('48', '0', '043/2015'),
('49', '0', '044/2015'),
('50', '0', '045/2015'),
('51', '0', '046/2015'),
('52', '0', '047/2015'),
('53', '0', '048/2015'),
('54', '0', '049/2015'),
('55', '0', '050/2015'),
('56', '0', '051/2015'),
('57', '0', '052/2015'),
('58', '0', '053/2015'),
('59', '0', '054/2015'),
('60', '0', '055/2015'),
('61', '0', '056/2015'),
('62', '0', '057/2015'),
('63', '0', '058/2015'),
('64', '0', '059/2015'),
('65', '0', '060/2015'),
('66', '0', '061/2015'),
('67', '0', '062/2015'),
('69', '0', '063/2015'),
('70', '0', '064/2015'),
('71', '0', '065/2015'),
('72', '0', '066/2015'),
('73', '0', '067/2015'),
('76', '0', '068/2015'),
('79', '0', '069/2015'),
('80', '0', '070/2015'),
('81', '0', '071/2015'),
('82', '0', '072/2015'),
('84', '0', '073/2015'),
('85', '0', '074/2015'),
('86', '0', '075/2015'),
('87', '0', '076/2015'),
('88', '0', '077/2015'),
('89', '0', '078/2015'),
('92', '0', '079/2015'),
('93', '0', '079/2015'),
('1', '1', '001/2015'),
('21', '1', '001/2016'),
('2', '1', '002/2015'),
('28', '1', '002/2016'),
('3', '1', '003/2015'),
('31', '1', '003/2016'),
('4', '1', '004/2015'),
('49', '1', '004/2015'),
('32', '1', '004/2016'),
('5', '1', '005/2015'),
('33', '1', '005/2016'),
('6', '1', '006/2015'),
('34', '1', '006/2016'),
('7', '1', '007/2015'),
('35', '1', '007/2016'),
('8', '1', '008/2015'),
('36', '1', '008/2016'),
('9', '1', '009/2015'),
('37', '1', '009/2016'),
('10', '1', '010/2015'),
('38', '1', '010/2016'),
('11', '1', '011/2015'),
('39', '1', '011/2016'),
('12', '1', '012/2015'),
('40', '1', '012/2016'),
('13', '1', '013/2015'),
('41', '1', '013/2016'),
('14', '1', '014/2015'),
('42', '1', '014/2016'),
('15', '1', '015/2015'),
('44', '1', '015/2016'),
('16', '1', '016/2015'),
('45', '1', '016/2016'),
('17', '1', '017/2015'),
('46', '1', '017/2016'),
('18', '1', '018/2015'),
('47', '1', '018/2016'),
('19', '1', '019/2015'),
('48', '1', '019/2016'),
('20', '1', '020/2015'),
('52', '1', '020/2016'),
('22', '1', '021/2015'),
('79', '1', '021/2016'),
('83', '1', '021/2016'),
('150', '1', '021/2016'),
('23', '1', '022/2015'),
('86', '1', '022/2016'),
('151', '1', '022/2016'),
('24', '1', '023/2015'),
('152', '1', '023/2016'),
('25', '1', '024/2015'),
('153', '1', '024/2016'),
('26', '1', '025/2015'),
('154', '1', '025/2016'),
('27', '1', '026/2015'),
('29', '1', '027/2015'),
('30', '1', '027/2015'),
('43', '1', '028/2015'),
('50', '1', '029/2015'),
('51', '1', '030/2015'),
('53', '1', '031/2015'),
('54', '1', '032/2015'),
('55', '1', '033/2015'),
('56', '1', '034/2015'),
('57', '1', '035/2015'),
('58', '1', '036/2015'),
('59', '1', '037/2015'),
('60', '1', '038/2015'),
('61', '1', '039/2015'),
('62', '1', '040/2015'),
('63', '1', '041/2015'),
('64', '1', '042/2015'),
('65', '1', '043/2015'),
('66', '1', '044/2015'),
('67', '1', '045/2015'),
('68', '1', '046/2015'),
('69', '1', '047/2015'),
('70', '1', '048/2015'),
('71', '1', '049/2015'),
('72', '1', '050/2015'),
('73', '1', '051/2015'),
('74', '1', '052/2015'),
('75', '1', '053/2015'),
('76', '1', '054/2015'),
('77', '1', '055/2015'),
('78', '1', '056/2015'),
('80', '1', '057/2015'),
('81', '1', '058/2015'),
('82', '1', '059/2015'),
('84', '1', '060/2015'),
('85', '1', '061/2015'),
('87', '1', '062/2015'),
('88', '1', '063/2015'),
('89', '1', '064/2015'),
('90', '1', '065/2015'),
('91', '1', '066/2015'),
('92', '1', '067/2015'),
('93', '1', '068/2015'),
('94', '1', '069/2015'),
('95', '1', '070/2015'),
('96', '1', '071/2015'),
('97', '1', '072/2015'),
('98', '1', '073/2015'),
('99', '1', '074/2015'),
('100', '1', '075/2015'),
('101', '1', '076/2015'),
('102', '1', '077/2015'),
('103', '1', '078/2015'),
('104', '1', '079/2015'),
('105', '1', '080/2015'),
('106', '1', '081/2015'),
('107', '1', '082/2015'),
('108', '1', '083/2015'),
('109', '1', '084/2015'),
('110', '1', '085/2015'),
('111', '1', '086/2015'),
('112', '1', '087/2015'),
('113', '1', '088/2015'),
('114', '1', '089/2015'),
('115', '1', '090/2015'),
('116', '1', '091/2015'),
('117', '1', '092/2015'),
('118', '1', '093/2015'),
('119', '1', '094/2015'),
('120', '1', '095/2015'),
('121', '1', '096/2015'),
('122', '1', '097/2015'),
('123', '1', '098/2015'),
('124', '1', '099/2015'),
('125', '1', '100/2015'),
('126', '1', '101/2015'),
('127', '1', '102/2015'),
('128', '1', '103/2015'),
('129', '1', '104/2015'),
('130', '1', '105/2015'),
('131', '1', '106/2015'),
('132', '1', '107/2015'),
('133', '1', '108/2015'),
('134', '1', '109/2015'),
('135', '1', '110/2015'),
('136', '1', '111/2015'),
('137', '1', '112/2015'),
('138', '1', '113/2015'),
('139', '1', '114/2015'),
('140', '1', '115/2015'),
('141', '1', '116/2015'),
('142', '1', '117/2015'),
('143', '1', '118/2015'),
('144', '1', '119/2015'),
('145', '1', '120/2015'),
('146', '1', '121/2015'),
('147', '1', '122/2015'),
('148', '1', '123/2015'),
('149', '1', '124/2015'),
('1', '2', '001/2015'),
('14', '2', '001/2016'),
('2', '2', '002/2015'),
('4', '2', '002/2015'),
('5', '2', '002/2015'),
('15', '2', '002/2016'),
('3', '2', '003/2015'),
('6', '2', '003/2015'),
('16', '2', '003/2016'),
('17', '2', '003/2016'),
('7', '2', '004/2015'),
('18', '2', '004/2016'),
('8', '2', '005/2015'),
('19', '2', '005/2016'),
('9', '2', '006/2015'),
('20', '2', '006/2016'),
('10', '2', '007/2015'),
('21', '2', '007/2016'),
('11', '2', '008/2015'),
('22', '2', '008/2016'),
('12', '2', '009/2015'),
('23', '2', '009/2016'),
('13', '2', '010/2015'),
('24', '2', '010/2016'),
('32', '2', '011/2015'),
('25', '2', '011/2016'),
('33', '2', '012/2015'),
('26', '2', '012/2016'),
('34', '2', '013/2015'),
('27', '2', '013/2016'),
('35', '2', '014/2015'),
('28', '2', '014/2016'),
('36', '2', '015/2015'),
('29', '2', '015/2016'),
('37', '2', '016/2015'),
('30', '2', '016/2016'),
('31', '2', '016/2016'),
('38', '2', '017/2015'),
('55', '2', '017/2016'),
('39', '2', '018/2015'),
('40', '2', '019/2015'),
('41', '2', '020/2015'),
('42', '2', '021/2015'),
('43', '2', '022/2015'),
('44', '2', '023/2015'),
('45', '2', '024/2015'),
('46', '2', '025/2015'),
('47', '2', '025/2015'),
('48', '2', '026/2015'),
('49', '2', '027/2015'),
('50', '2', '028/2015'),
('51', '2', '029/2015'),
('52', '2', '030/2015'),
('53', '2', '031/2015'),
('54', '2', '032/2015'),
('1', '4', '001/2015'),
('27', '4', '001/2016'),
('2', '4', '002/2015'),
('28', '4', '002/2016'),
('3', '4', '003/2015'),
('34', '4', '003/2016'),
('4', '4', '004/2015'),
('36', '4', '004/2016'),
('5', '4', '005/2015'),
('63', '4', '005/2016'),
('6', '4', '006/2015'),
('70', '4', '006/2016'),
('7', '4', '007/2015'),
('72', '4', '007/2016'),
('8', '4', '008/2015'),
('80', '4', '008/2016'),
('9', '4', '009/2015'),
('81', '4', '009/2016'),
('10', '4', '010/2015'),
('82', '4', '010/2016'),
('11', '4', '011/2015'),
('92', '4', '011/2016'),
('12', '4', '012/2015'),
('93', '4', '012/2016'),
('13', '4', '013/2015'),
('94', '4', '013/2016'),
('14', '4', '014/2015'),
('95', '4', '014/2016'),
('15', '4', '015/2015'),
('96', '4', '015/2016'),
('16', '4', '016/2015'),
('97', '4', '016/2016'),
('17', '4', '017/2015'),
('98', '4', '017/2016'),
('18', '4', '018/2015'),
('99', '4', '018/2016'),
('19', '4', '019/2015'),
('100', '4', '019/2016'),
('20', '4', '020/2015'),
('101', '4', '020/2016'),
('21', '4', '021/2015'),
('102', '4', '021/2016'),
('22', '4', '022/2015'),
('103', '4', '022/2016'),
('23', '4', '023/2015'),
('104', '4', '023/2016'),
('24', '4', '024/2015'),
('105', '4', '024/2016'),
('25', '4', '025/2015'),
('106', '4', '025/2016'),
('26', '4', '026/2015'),
('107', '4', '026/2016'),
('29', '4', '027/2015'),
('108', '4', '027/2016'),
('30', '4', '028/2015'),
('109', '4', '028/2016'),
('31', '4', '029/2015'),
('110', '4', '029/2016'),
('32', '4', '030/2015'),
('111', '4', '030/2016'),
('33', '4', '031/2015'),
('112', '4', '031/2016'),
('35', '4', '032/2015'),
('113', '4', '032/2016'),
('37', '4', '033/2015'),
('114', '4', '033/2016'),
('38', '4', '034/2015'),
('115', '4', '034/2016'),
('39', '4', '035/2015'),
('116', '4', '035/2016'),
('40', '4', '036/2015'),
('117', '4', '036/2016'),
('41', '4', '037/2015'),
('118', '4', '037/2016'),
('42', '4', '038/2015'),
('119', '4', '038/2016'),
('43', '4', '039/2015'),
('120', '4', '039/2016'),
('44', '4', '040/2015'),
('121', '4', '040/2016'),
('45', '4', '041/2015'),
('122', '4', '041/2016'),
('46', '4', '042/2015'),
('123', '4', '042/2016'),
('47', '4', '043/2015'),
('124', '4', '043/2016'),
('48', '4', '044/2015'),
('125', '4', '044/2016'),
('49', '4', '045/2015'),
('126', '4', '045/2016'),
('50', '4', '046/2015'),
('127', '4', '046/2016'),
('51', '4', '047/2015'),
('128', '4', '047/2016'),
('52', '4', '048/2015'),
('129', '4', '048/2016'),
('53', '4', '049/2015'),
('130', '4', '049/2016'),
('54', '4', '050/2015'),
('131', '4', '050/2016'),
('55', '4', '051/2015'),
('132', '4', '051/2016'),
('56', '4', '052/2015'),
('133', '4', '052/2016'),
('57', '4', '053/2015'),
('134', '4', '053/2016'),
('58', '4', '054/2015'),
('135', '4', '054/2016'),
('59', '4', '055/2015'),
('136', '4', '055/2016'),
('60', '4', '056/2015'),
('137', '4', '056/2016'),
('61', '4', '057/2015'),
('138', '4', '057/2016'),
('62', '4', '058/2015'),
('139', '4', '058/2016'),
('64', '4', '059/2015'),
('140', '4', '059/2016'),
('65', '4', '060/2015'),
('141', '4', '060/2016'),
('66', '4', '061/2015'),
('142', '4', '061/2016'),
('67', '4', '062/2015'),
('150', '4', '062/2016'),
('68', '4', '063/2015'),
('151', '4', '063/2016'),
('69', '4', '064/2015'),
('155', '4', '064/2016'),
('71', '4', '065/2015'),
('159', '4', '065/2016'),
('73', '4', '066/2015'),
('163', '4', '066/2016'),
('74', '4', '067/2015'),
('164', '4', '067/2016'),
('75', '4', '068/2015'),
('165', '4', '068/2016'),
('76', '4', '069/2015'),
('166', '4', '069/2016'),
('77', '4', '070/2015'),
('167', '4', '070/2016'),
('78', '4', '071/2015'),
('168', '4', '071/2016'),
('79', '4', '072/2015'),
('169', '4', '072/2016'),
('83', '4', '073/2015'),
('170', '4', '073/2016'),
('84', '4', '074/2015'),
('171', '4', '074/2016'),
('85', '4', '075/2015'),
('172', '4', '075/2016'),
('86', '4', '076/2015'),
('173', '4', '076/2016'),
('87', '4', '077/2015'),
('174', '4', '077/2016'),
('88', '4', '078/2015'),
('175', '4', '078/2016'),
('89', '4', '079/2015'),
('176', '4', '079/2016'),
('90', '4', '080/2015'),
('177', '4', '080/2016'),
('91', '4', '081/2015'),
('178', '4', '081/2016'),
('143', '4', '082/2015'),
('180', '4', '082/2016'),
('144', '4', '083/2015'),
('181', '4', '083/2016'),
('145', '4', '084/2015'),
('182', '4', '084/2016'),
('146', '4', '085/2015'),
('191', '4', '085/2016'),
('147', '4', '086/2015'),
('202', '4', '086/2016'),
('148', '4', '087/2015'),
('203', '4', '087/2016'),
('149', '4', '088/2015'),
('205', '4', '088/2016'),
('152', '4', '089/2015'),
('153', '4', '090/2015'),
('154', '4', '091/2015'),
('156', '4', '092/2015'),
('157', '4', '093/2015'),
('158', '4', '094/2015'),
('160', '4', '095/2015'),
('161', '4', '096/2015'),
('162', '4', '097/2015'),
('179', '4', '098/2015'),
('183', '4', '099/2015'),
('184', '4', '100/2015'),
('185', '4', '101/2015'),
('186', '4', '102/2015'),
('187', '4', '103/2015'),
('188', '4', '104/2015'),
('189', '4', '105/2015'),
('190', '4', '106/2015'),
('192', '4', '107/2015'),
('193', '4', '108/2015'),
('194', '4', '109/2015'),
('195', '4', '110/2015'),
('196', '4', '111/2015'),
('197', '4', '112/2015'),
('198', '4', '113/2015'),
('199', '4', '114/2015'),
('200', '4', '115/2015'),
('201', '4', '116/2015'),
('204', '4', '117/2015'),
('206', '4', '118/2015'),
('207', '4', '118/2015'),
('208', '4', '119/2015'),
('209', '4', '120/2015'),
('1', '10', '001/2015'),
('2', '10', '001/2015'),
('5', '10', '001/2015'),
('3', '10', '001/2016'),
('6', '10', '002/2015'),
('4', '10', '002/2016'),
('7', '10', '003/2015'),
('38', '10', '003/2016'),
('8', '10', '004/2015'),
('39', '10', '004/2016'),
('9', '10', '005/2015'),
('40', '10', '005/2016'),
('10', '10', '006/2015'),
('41', '10', '006/2016'),
('11', '10', '007/2015'),
('42', '10', '007/2016'),
('12', '10', '008/2015'),
('43', '10', '008/2016'),
('13', '10', '009/2015'),
('44', '10', '009/2016'),
('14', '10', '010/2015'),
('45', '10', '010/2016'),
('15', '10', '011/2015'),
('46', '10', '011/2016'),
('16', '10', '012/2015'),
('47', '10', '012/2016'),
('17', '10', '013/2015'),
('48', '10', '013/2016'),
('18', '10', '014/2015'),
('49', '10', '014/2016'),
('19', '10', '015/2015'),
('50', '10', '015/2016'),
('20', '10', '016/2015'),
('51', '10', '016/2016'),
('21', '10', '017/2015'),
('52', '10', '017/2016'),
('22', '10', '018/2015'),
('53', '10', '018/2016'),
('23', '10', '019/2015'),
('54', '10', '019/2016'),
('24', '10', '020/2015'),
('55', '10', '020/2016'),
('25', '10', '021/2015'),
('56', '10', '021/2016'),
('26', '10', '022/2015'),
('57', '10', '022/2016'),
('27', '10', '023/2015'),
('58', '10', '023/2016'),
('28', '10', '024/2015'),
('59', '10', '024/2016'),
('29', '10', '025/2015'),
('60', '10', '025/2016'),
('30', '10', '026/2015'),
('61', '10', '026/2016'),
('31', '10', '027/2015'),
('62', '10', '027/2016'),
('32', '10', '028/2015'),
('63', '10', '028/2016'),
('33', '10', '029/2015'),
('64', '10', '029/2016'),
('34', '10', '030/2015'),
('65', '10', '030/2016'),
('35', '10', '031/2015'),
('66', '10', '031/2016'),
('36', '10', '032/2015'),
('67', '10', '032/2016'),
('37', '10', '033/2015'),
('5', '12', '001/2015'),
('6', '12', '002/2015'),
('3', '12', '002/2016'),
('7', '12', '003/2015'),
('4', '12', '003/2016'),
('8', '12', '004/2015'),
('1', '12', '004/2016'),
('9', '12', '005/2015'),
('2', '12', '005/2016'),
('10', '12', '006/2015'),
('38', '12', '006/2016'),
('11', '12', '007/2015'),
('39', '12', '007/2016'),
('12', '12', '008/2015'),
('40', '12', '008/2016'),
('13', '12', '009/2015'),
('41', '12', '009/2016'),
('14', '12', '010/2015'),
('42', '12', '010/2016'),
('15', '12', '011/2015'),
('43', '12', '011/2016'),
('16', '12', '012/2015'),
('44', '12', '012/2016'),
('17', '12', '013/2015'),
('45', '12', '013/2016'),
('18', '12', '014/2015'),
('46', '12', '014/2016'),
('19', '12', '015/2015'),
('47', '12', '015/2016'),
('20', '12', '016/2015'),
('48', '12', '016/2016'),
('21', '12', '017/2015'),
('49', '12', '017/2016'),
('22', '12', '018/2015'),
('50', '12', '018/2016'),
('23', '12', '019/2015'),
('51', '12', '019/2016'),
('24', '12', '020/2015'),
('52', '12', '020/2016'),
('25', '12', '021/2015'),
('53', '12', '021/2016'),
('26', '12', '022/2015'),
('54', '12', '022/2016'),
('27', '12', '023/2015'),
('55', '12', '023/2016'),
('28', '12', '024/2015'),
('56', '12', '024/2016'),
('29', '12', '025/2015'),
('57', '12', '025/2016'),
('30', '12', '026/2015'),
('58', '12', '026/2016'),
('31', '12', '027/2015'),
('59', '12', '027/2016'),
('32', '12', '028/2015'),
('60', '12', '028/2016'),
('33', '12', '029/2015'),
('61', '12', '029/2016'),
('34', '12', '030/2015'),
('62', '12', '030/2016'),
('35', '12', '031/2015'),
('63', '12', '031/2016'),
('36', '12', '032/2015'),
('64', '12', '032/2016'),
('37', '12', '033/2015'),
('65', '12', '033/2016'),
('66', '12', '034/2016'),
('67', '12', '035/2016'),
('5', '13', '001/2015'),
('85', '50', ' 	255545 	'),
('88', '50', ' 	255547'),
('89', '50', ' 	255548'),
('90', '50', ' 	255549 	'),
('1', '50', ''),
('3', '50', ''),
('5', '50', ''),
('6', '50', ''),
('7', '50', ''),
('9', '50', ''),
('10', '50', ''),
('11', '50', ''),
('12', '50', ''),
('13', '50', ''),
('14', '50', ''),
('15', '50', ''),
('16', '50', ''),
('17', '50', ''),
('18', '50', ''),
('19', '50', ''),
('20', '50', ''),
('21', '50', ''),
('22', '50', ''),
('23', '50', ''),
('24', '50', ''),
('25', '50', ''),
('28', '50', ''),
('30', '50', ''),
('35', '50', ''),
('43', '50', ''),
('44', '50', ''),
('45', '50', ''),
('46', '50', ''),
('47', '50', ''),
('48', '50', ''),
('49', '50', ''),
('50', '50', ''),
('51', '50', ''),
('52', '50', ''),
('53', '50', ''),
('54', '50', ''),
('55', '50', ''),
('56', '50', ''),
('57', '50', ''),
('58', '50', ''),
('59', '50', ''),
('61', '50', ''),
('63', '50', ''),
('64', '50', ''),
('65', '50', ''),
('67', '50', ''),
('68', '50', ''),
('69', '50', ''),
('70', '50', ''),
('71', '50', ''),
('72', '50', ''),
('73', '50', ''),
('74', '50', ''),
('75', '50', ''),
('76', '50', ''),
('77', '50', ''),
('78', '50', ''),
('79', '50', ''),
('80', '50', ''),
('81', '50', ''),
('82', '50', ''),
('87', '50', ''),
('91', '50', ''),
('92', '50', ''),
('93', '50', ''),
('94', '50', ''),
('95', '50', ''),
('96', '50', ''),
('97', '50', ''),
('98', '50', ''),
('99', '50', ''),
('100', '50', ''),
('101', '50', ''),
('103', '50', ''),
('104', '50', ''),
('105', '50', ''),
('106', '50', ''),
('107', '50', ''),
('108', '50', ''),
('109', '50', ''),
('110', '50', ''),
('111', '50', ''),
('112', '50', ''),
('113', '50', ''),
('114', '50', ''),
('115', '50', ''),
('116', '50', ''),
('117', '50', ''),
('118', '50', ''),
('119', '50', ''),
('121', '50', ''),
('122', '50', ''),
('123', '50', ''),
('124', '50', ''),
('125', '50', ''),
('126', '50', ''),
('127', '50', ''),
('128', '50', ''),
('129', '50', ''),
('130', '50', ''),
('131', '50', ''),
('132', '50', ''),
('133', '50', ''),
('134', '50', ''),
('135', '50', ''),
('136', '50', ''),
('137', '50', ''),
('138', '50', ''),
('139', '50', ''),
('140', '50', ''),
('141', '50', ''),
('142', '50', ''),
('143', '50', ''),
('145', '50', ''),
('146', '50', ''),
('147', '50', ''),
('148', '50', ''),
('149', '50', ''),
('150', '50', ''),
('151', '50', ''),
('152', '50', ''),
('153', '50', ''),
('154', '50', ''),
('144', '50', '1'),
('60', '50', '111116'),
('62', '50', '111117'),
('66', '50', '111118'),
('102', '50', '111119'),
('120', '50', '111120'),
('2', '50', '245151'),
('4', '50', '245155'),
('8', '50', '245162'),
('26', '50', '245192'),
('27', '50', '245194'),
('29', '50', '245198'),
('83', '50', '255543'),
('84', '50', '255544'),
('86', '50', '255546'),
('31', '50', '265751'),
('32', '50', '265754'),
('33', '50', '265757'),
('34', '50', '265760'),
('36', '50', '265764'),
('37', '50', '265767'),
('38', '50', '265768'),
('39', '50', '265769'),
('40', '50', '265774'),
('41', '50', '265778'),
('42', '50', '265779');

### Structure of table `6_requisition_details` ###

DROP TABLE IF EXISTS `6_requisition_details`;

CREATE TABLE `6_requisition_details` (
  `requisition_detail_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `requisition_id` int(11) DEFAULT NULL,
  `item_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `lpo_id` int(11) DEFAULT '0',
  `order_quantity` int(11) NOT NULL DEFAULT '0',
  `estimate_price` double NOT NULL DEFAULT '0',
  `quantity` int(11) NOT NULL DEFAULT '0',
  `price` double NOT NULL DEFAULT '0',
  `purpose` varchar(320) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`requisition_detail_id`),
  UNIQUE KEY `requisition_detail_id` (`requisition_detail_id`),
  KEY `6_requisition_details_requisition_id` (`requisition_id`),
  KEY `6_requisition_details_item_code` (`item_code`),
  KEY `6_requisition_details_supplier_id` (`supplier_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_requisition_details` ###


### Structure of table `6_requisitions` ###

DROP TABLE IF EXISTS `6_requisitions`;

CREATE TABLE `6_requisitions` (
  `requisition_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `point_of_use` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `narrative` varchar(240) COLLATE utf8_unicode_ci DEFAULT NULL,
  `application_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `completed` tinyint(4) NOT NULL DEFAULT '0',
  `processed` tinyint(4) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`requisition_id`),
  UNIQUE KEY `requisition_id` (`requisition_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_requisitions` ###


### Structure of table `6_sales_order_details` ###

DROP TABLE IF EXISTS `6_sales_order_details`;

CREATE TABLE `6_sales_order_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT '0',
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `stk_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `qty_sent` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `invoiced` double NOT NULL DEFAULT '0',
  `discount_percent` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `sorder` (`trans_type`,`order_no`),
  KEY `stkcode` (`stk_code`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_sales_order_details` ###

INSERT INTO `6_sales_order_details` VALUES
('1', '1', '30', '001', 'Food', '0', '272659', '0', '0', '0'),
('2', '2', '30', '001', 'Food', '0', '272659', '0', '0', '0'),
('3', '3', '30', '001', 'Food', '0', '1000', '0', '0', '0'),
('4', '4', '30', '002', ' 	Beverage', '0', '300', '0', '0', '0'),
('5', '5', '30', '001', 'Food', '1', '272659', '1', '0', '0'),
('6', '6', '30', '001', 'Food', '1', '303185', '1', '0', '0'),
('7', '7', '30', '001', 'Food', '1', '322814', '1', '0', '0'),
('8', '8', '30', '001', 'Food', '1', '20200', '1', '0', '0'),
('9', '8', '30', '002', ' 	Beverage', '1', '6705', '1', '0', '0'),
('10', '9', '30', '001', 'Food', '1', '62453', '1', '0', '0'),
('11', '10', '30', '001', 'Food', '1', '62364', '1', '0', '0'),
('12', '11', '30', '001', 'Food', '1', '61302', '1', '0', '0'),
('13', '12', '30', '001', 'Food', '1', '79320', '1', '0', '0'),
('14', '13', '30', '001', 'Food', '1', '62403', '1', '0', '0'),
('15', '13', '30', '002', ' 	Beverage', '1', '9645', '1', '0', '0'),
('16', '14', '30', '001', 'Food', '1', '74651', '1', '0', '0'),
('17', '15', '30', '001', 'Food', '1', '67860', '1', '0', '0'),
('18', '16', '30', '001', 'Food', '1', '80505', '1', '0', '0'),
('19', '17', '30', '001', 'Food', '1', '48025', '1', '0', '0'),
('20', '18', '30', '001', 'Food', '1', '41292', '1', '0', '0'),
('21', '18', '30', '002', ' 	Beverage', '1', '7315', '1', '0', '0'),
('22', '19', '30', '001', 'Food', '1', '74533', '1', '0', '0'),
('23', '20', '30', '001', 'Food', '1', '79045', '1', '0', '0'),
('24', '21', '30', '001', 'Food', '1', '86405', '1', '0', '0'),
('25', '22', '30', '001', 'Food', '1', '60248', '1', '0', '0'),
('26', '23', '30', '001', 'Food', '1', '14500', '1', '0', '0'),
('27', '23', '30', '002', ' 	Beverage', '1', '8510', '1', '0', '0'),
('28', '24', '30', '001', 'Food', '1', '91729', '1', '0', '0'),
('29', '25', '30', '001', 'Food', '1', '63100', '1', '0', '0'),
('30', '26', '30', '001', 'Food', '1', '76586', '1', '0', '0'),
('31', '27', '30', '001', 'Food', '1', '73678', '1', '0', '0'),
('32', '28', '30', '001', 'Food', '1', '44235', '1', '0', '0'),
('33', '28', '30', '002', ' 	Beverage', '1', '6140', '1', '0', '0'),
('34', '29', '30', '001', 'Food', '1', '65880', '1', '0', '0'),
('35', '30', '30', '001', 'Food', '1', '68189', '1', '0', '0'),
('36', '31', '30', '001', 'Food', '1', '89000', '1', '0', '0'),
('37', '32', '30', '001', 'Food', '1', '40958', '1', '0', '0'),
('38', '33', '30', '001', 'Food', '1', '47669', '1', '0', '0'),
('39', '33', '30', '002', ' 	Beverage', '1', '6255', '1', '0', '0'),
('40', '34', '30', '001', 'Food', '1', '82963', '1', '0', '0'),
('41', '35', '30', '001', 'Food', '1', '71768', '1', '0', '0'),
('42', '36', '30', '001', 'Food', '1', '120771', '1', '0', '0'),
('43', '37', '30', '001', 'Food', '1', '89350', '1', '0', '0'),
('44', '38', '30', '001', 'Food', '1', '1790', '1', '0', '0'),
('45', '38', '30', '002', ' 	Beverage', '1', '8045', '1', '0', '0'),
('46', '39', '30', '002', ' 	Beverage', '1', '64306', '1', '0', '0'),
('47', '40', '30', '001', 'Food', '1', '95720', '1', '0', '0'),
('48', '41', '30', '001', 'Food', '1', '62295', '1', '0', '0'),
('49', '42', '30', '001', 'Food', '1', '113045', '1', '0', '0'),
('50', '43', '30', '001', 'Food', '1', '47945', '1', '0', '0'),
('51', '44', '30', '001', 'Food', '1', '53980', '1', '0', '0'),
('52', '44', '30', '002', ' 	Beverage', '1', '10585', '1', '0', '0'),
('53', '45', '30', '001', 'Food', '1', '103935', '1', '0', '0'),
('54', '46', '30', '001', 'Food', '1', '97114', '1', '0', '0'),
('55', '47', '30', '001', 'Food', '1', '110807', '1', '0', '0'),
('56', '48', '30', '001', 'Food', '1', '46100', '1', '0', '0'),
('57', '49', '30', '001', 'Food', '1', '31687', '1', '0', '0'),
('58', '49', '30', '002', ' 	Beverage', '1', '15200', '1', '0', '0'),
('59', '50', '30', '001', 'Food', '1', '107384', '1', '0', '0'),
('60', '51', '30', '001', 'Food', '1', '111432', '1', '0', '0'),
('61', '52', '30', '001', 'Food', '1', '92910', '1', '0', '0'),
('62', '53', '30', '001', 'Food', '1', '74215', '1', '0', '0'),
('63', '54', '30', '001', 'Food', '1', '12635', '1', '0', '0'),
('64', '55', '30', '001', 'Food', '1', '10430', '1', '0', '0'),
('65', '56', '30', '001', 'Food', '1', '6745', '1', '0', '0'),
('66', '57', '30', '001', 'Food', '1', '2310', '1', '0', '0'),
('67', '58', '30', '001', 'Food', '1', '5110', '1', '0', '0'),
('68', '59', '30', '002', ' 	Beverage', '1', '12205', '1', '0', '0'),
('69', '60', '30', '001', 'Food', '1', '10485', '1', '0', '0'),
('70', '61', '30', '001', 'Food', '1', '17820', '1', '0', '0'),
('71', '62', '30', '001', 'Food', '1', '5565', '1', '0', '0'),
('72', '63', '30', '001', 'Food', '1', '6750', '1', '0', '0'),
('73', '64', '30', '001', 'Food', '1', '10790', '1', '0', '0'),
('74', '65', '30', '001', 'Food', '1', '13605', '1', '0', '0'),
('75', '66', '30', '001', 'Food', '1', '11435', '1', '0', '0'),
('76', '67', '30', '001', 'Food', '1', '6445', '1', '0', '0');

### Structure of table `6_sales_order_details_csv` ###

DROP TABLE IF EXISTS `6_sales_order_details_csv`;

CREATE TABLE `6_sales_order_details_csv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cust_ref` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `stock_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `price` double(16,2) DEFAULT NULL,
  `discount_precent` double DEFAULT NULL,
  `order_date` date DEFAULT NULL,
  `delivery_date` date DEFAULT NULL,
  `deliver_addres` tinytext COLLATE utf8_unicode_ci,
  `deliver_branch` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_sales_order_details_csv` ###


### Structure of table `6_sales_orders` ###

DROP TABLE IF EXISTS `6_sales_orders`;

CREATE TABLE `6_sales_orders` (
  `order_no` int(11) NOT NULL,
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `version` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `branch_code` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `customer_ref` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `comments` tinytext COLLATE utf8_unicode_ci,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `order_type` int(11) NOT NULL DEFAULT '0',
  `ship_via` int(11) NOT NULL DEFAULT '0',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `contact_phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `deliver_to` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `freight_cost` double NOT NULL DEFAULT '0',
  `from_stk_loc` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `payment_terms` int(11) DEFAULT NULL,
  `total` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`trans_type`,`order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_sales_orders` ###

INSERT INTO `6_sales_orders` VALUES
('1', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-04-30', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'DEF', '2016-03-31', '4', '272659', '0', '0'),
('2', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-04-30', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'DEF', '2016-03-31', '4', '272659', '0', '0'),
('3', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-03-31', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'DEF', '2016-03-31', '4', '1000', '0', '0'),
('4', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-03-31', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'DEF', '2016-03-31', '4', '300', '0', '0'),
('5', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-04-30', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-04-01', '4', '272659', '0', '0'),
('6', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-05-31', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '303185', '0', '0'),
('7', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-06-30', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '322814', '0', '0'),
('8', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-07-03', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '26905', '0', '0'),
('9', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-07-10', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '62453', '0', '0'),
('10', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-07-17', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '62364', '0', '0'),
('11', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-07-24', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '61302', '0', '0'),
('12', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-07-31', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'DEF', '2016-03-31', '4', '79320', '0', '0'),
('13', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-08-07', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '72048', '0', '0'),
('14', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-08-14', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '74651', '0', '0'),
('15', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-08-21', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '67860', '0', '0'),
('16', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-08-28', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '80505', '0', '0'),
('17', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-08-31', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '48025', '0', '0'),
('18', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-09-04', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '48607', '0', '0'),
('19', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-09-11', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '74533', '0', '0'),
('20', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-09-18', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '79045', '0', '0'),
('21', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-09-25', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '86405', '0', '0'),
('22', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-09-30', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '60248', '0', '0'),
('23', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-10-04', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '23010', '0', '0'),
('24', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-10-09', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '91729', '0', '0'),
('25', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-10-16', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '63100', '0', '0'),
('26', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-10-23', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '76586', '0', '0'),
('27', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-10-31', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '73678', '0', '0'),
('28', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-11-06', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '50375', '0', '0'),
('29', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-11-13', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '65880', '0', '0'),
('30', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-11-20', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '68189', '0', '0'),
('31', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-11-27', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '89000', '0', '0'),
('32', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-11-30', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '40958', '0', '0'),
('33', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-12-04', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '53924', '0', '0'),
('34', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-12-11', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '82963', '0', '0'),
('35', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-12-18', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '71768', '0', '0'),
('36', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-12-25', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '120771', '0', '0'),
('37', '30', '1', '0', '3', '3', 'auto', '', NULL, '2015-12-31', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '89350', '0', '0'),
('38', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-01-01', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '9835', '0', '0'),
('39', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-01-08', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '64306', '0', '0'),
('40', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-01-15', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '95720', '0', '0'),
('41', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-01-22', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '62295', '0', '0'),
('42', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-01-29', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '113045', '0', '0'),
('43', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-01-31', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '47945', '0', '0'),
('44', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-02-05', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '64565', '0', '0'),
('45', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-02-12', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '103935', '0', '0'),
('46', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-02-19', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '97114', '0', '0'),
('47', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-02-26', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '110807', '0', '0'),
('48', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-02-29', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '46100', '0', '0'),
('49', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-03-04', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '46887', '0', '0'),
('50', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-03-11', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '107384', '0', '0'),
('51', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-03-18', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '111432', '0', '0'),
('52', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-03-25', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '92910', '0', '0'),
('53', '30', '1', '0', '3', '3', 'auto', '', NULL, '2016-03-31', '1', '1', 'Colombo', NULL, NULL, 'Cash', '0', 'LOC1', '2016-03-31', '4', '74215', '0', '0'),
('54', '30', '1', '0', '4', '4', 'auto', '', NULL, '2016-01-15', '1', '1', 'Colombo', NULL, NULL, 'Cash-outlet', '0', 'LOC1', '2016-03-31', '4', '12635', '0', '0'),
('55', '30', '1', '0', '4', '4', 'auto', '', NULL, '2016-01-22', '1', '1', 'Colombo', NULL, NULL, 'Cash-outlet', '0', 'LOC1', '2016-03-31', '4', '10430', '0', '0'),
('56', '30', '1', '0', '4', '4', 'auto', '', NULL, '2016-01-29', '1', '1', 'Colombo', NULL, NULL, 'Cash-outlet', '0', 'LOC1', '2016-03-31', '4', '6745', '0', '0'),
('57', '30', '1', '0', '4', '4', 'auto', '', NULL, '2016-01-31', '1', '1', 'Colombo', NULL, NULL, 'Cash-outlet', '0', 'LOC1', '2016-03-31', '4', '2310', '0', '0'),
('58', '30', '1', '0', '4', '4', 'auto', '', NULL, '2016-02-05', '1', '1', 'Colombo', NULL, NULL, 'Cash-outlet', '0', 'LOC1', '2016-03-31', '4', '5110', '0', '0'),
('59', '30', '1', '0', '4', '4', 'auto', '', NULL, '2016-02-12', '1', '1', 'Colombo', NULL, NULL, 'Cash-outlet', '0', 'LOC1', '2016-03-31', '4', '12205', '0', '0'),
('60', '30', '1', '0', '4', '4', 'auto', '', NULL, '2016-02-19', '1', '1', 'Colombo', NULL, NULL, 'Cash-outlet', '0', 'LOC1', '2016-03-31', '4', '10485', '0', '0'),
('61', '30', '1', '0', '4', '4', 'auto', '', NULL, '2016-02-26', '1', '1', 'Colombo', NULL, NULL, 'Cash-outlet', '0', 'LOC1', '2016-03-31', '4', '17820', '0', '0'),
('62', '30', '1', '0', '4', '4', 'auto', '', NULL, '2016-02-29', '1', '1', 'Colombo', NULL, NULL, 'Cash-outlet', '0', 'LOC1', '2016-03-31', '4', '5565', '0', '0'),
('63', '30', '1', '0', '4', '4', 'auto', '', NULL, '2016-03-04', '1', '1', 'Colombo', NULL, NULL, 'Cash-outlet', '0', 'LOC1', '2016-03-31', '4', '6750', '0', '0'),
('64', '30', '1', '0', '4', '4', 'auto', '', NULL, '2016-03-11', '1', '1', 'Colombo', NULL, NULL, 'Cash-outlet', '0', 'LOC1', '2016-03-31', '4', '10790', '0', '0'),
('65', '30', '1', '0', '4', '4', 'auto', '', NULL, '2016-03-18', '1', '1', 'Colombo', NULL, NULL, 'Cash-outlet', '0', 'LOC1', '2016-03-31', '4', '13605', '0', '0'),
('66', '30', '1', '0', '4', '4', 'auto', '', NULL, '2016-03-25', '1', '1', 'Colombo', NULL, NULL, 'Cash-outlet', '0', 'LOC1', '2016-03-31', '4', '11435', '0', '0'),
('67', '30', '1', '0', '4', '4', 'auto', '', NULL, '2016-03-31', '1', '1', 'Colombo', NULL, NULL, 'Cash-outlet', '0', 'LOC1', '2016-03-31', '4', '6445', '0', '0');

### Structure of table `6_sales_pos` ###

DROP TABLE IF EXISTS `6_sales_pos`;

CREATE TABLE `6_sales_pos` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `pos_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `cash_sale` tinyint(1) NOT NULL,
  `credit_sale` tinyint(1) NOT NULL,
  `pos_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `pos_account` smallint(6) unsigned NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `pos_name` (`pos_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_sales_pos` ###

INSERT INTO `6_sales_pos` VALUES
('1', 'Default', '1', '1', 'DEF', '4', '0');

### Structure of table `6_sales_types` ###

DROP TABLE IF EXISTS `6_sales_types`;

CREATE TABLE `6_sales_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_type` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_included` int(1) NOT NULL DEFAULT '0',
  `factor` double NOT NULL DEFAULT '1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_type` (`sales_type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_sales_types` ###

INSERT INTO `6_sales_types` VALUES
('1', 'Retail', '1', '1', '0'),
('2', 'Wholesale', '0', '0.7', '0');

### Structure of table `6_salesman` ###

DROP TABLE IF EXISTS `6_salesman`;

CREATE TABLE `6_salesman` (
  `salesman_code` int(11) NOT NULL AUTO_INCREMENT,
  `salesman_name` char(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_phone` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_fax` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `provision` double NOT NULL DEFAULT '0',
  `break_pt` double NOT NULL DEFAULT '0',
  `provision2` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`salesman_code`),
  UNIQUE KEY `salesman_name` (`salesman_name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_salesman` ###

INSERT INTO `6_salesman` VALUES
('1', 'Sales Person', '', '', '', '5', '1000', '4', '0'),
('2', 'De Mel', ' 	0112326191', ' 	0114719891', ' 	hldemelcoltd@sltnet.lk', '0', '0', '0', '0');

### Structure of table `6_security_roles` ###

DROP TABLE IF EXISTS `6_security_roles`;

CREATE TABLE `6_security_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sections` text COLLATE utf8_unicode_ci,
  `areas` text COLLATE utf8_unicode_ci,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `role` (`role`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_security_roles` ###

INSERT INTO `6_security_roles` VALUES
('1', 'Inquiries', 'Inquiries', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;773;774;2822;3073;3075;3076;3077;3329;3330;3331;3332;3333;3334;3335;5377;5633;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8450;8451;10497;10753;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15873;15882;16129;16130;16131;16132;775', '0'),
('2', 'System Administrator', 'System Administrator', '256;512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;9472;9728;10496;10752;11008;13056;13312;15616;15872;16128', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;16129;16130;16131;16132;775', '0'),
('3', 'Salesman', 'Salesman', '768;3072;5632;8192;15872', '773;774;3073;3075;3081;5633;8194;15873;775', '0'),
('4', 'Stock Manager', 'Stock Manager', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128', '2818;2822;3073;3076;3077;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5640;5889;5890;5891;8193;8194;8450;8451;10753;11009;11010;11012;13313;13315;15882;16129;16130;16131;16132;775', '0'),
('5', 'Production Manager', 'Production Manager', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;2818;2819;2820;2821;2822;2823;3073;3074;3076;3077;3078;3079;3080;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5640;5640;5889;5890;5891;8193;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15876;15877;15880;15882;16129;16130;16131;16132;775', '0'),
('6', 'Purchase Officer', 'Purchase Officer', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;2818;2819;2820;2821;2822;2823;3073;3074;3076;3077;3078;3079;3080;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5377;5633;5635;5640;5640;5889;5890;5891;8193;8194;8196;8197;8449;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15876;15877;15880;15882;16129;16130;16131;16132;775', '0'),
('7', 'AR Officer', 'AR Officer', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;771;773;774;2818;2819;2820;2821;2822;2823;3073;3073;3074;3075;3076;3077;3078;3079;3080;3081;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5633;5634;5637;5638;5639;5640;5640;5889;5890;5891;8193;8194;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0'),
('8', 'AP Officer', 'AP Officer', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;769;770;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5635;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15876;15877;15880;15882;16129;16130;16131;16132;775', '0'),
('9', 'Accountant', 'New Accountant', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5637;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0'),
('10', 'Sub Admin', 'Sub Admin', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5637;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15873;15874;15876;15877;15878;15879;15880;15882;16129;16130;16131;16132;775', '0');

### Structure of table `6_shippers` ###

DROP TABLE IF EXISTS `6_shippers`;

CREATE TABLE `6_shippers` (
  `shipper_id` int(11) NOT NULL AUTO_INCREMENT,
  `shipper_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`shipper_id`),
  UNIQUE KEY `name` (`shipper_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_shippers` ###

INSERT INTO `6_shippers` VALUES
('1', 'Default', '', '', '', '', '0');

### Structure of table `6_sizes` ###

DROP TABLE IF EXISTS `6_sizes`;

CREATE TABLE `6_sizes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `size_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `size_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `inactive` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_sizes` ###


### Structure of table `6_sql_trail` ###

DROP TABLE IF EXISTS `6_sql_trail`;

CREATE TABLE `6_sql_trail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sql` text COLLATE utf8_unicode_ci NOT NULL,
  `result` tinyint(1) NOT NULL,
  `msg` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_sql_trail` ###


### Structure of table `6_stock_category` ###

DROP TABLE IF EXISTS `6_stock_category`;

CREATE TABLE `6_stock_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_tax_type` int(11) NOT NULL DEFAULT '1',
  `dflt_units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `dflt_mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `dflt_sales_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_cogs_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_inventory_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_adjustment_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_wip_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_dim1` int(11) DEFAULT NULL,
  `dflt_dim2` int(11) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `dflt_no_sale` tinyint(1) NOT NULL DEFAULT '0',
  `dflt_no_purchase` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_stock_category` ###

INSERT INTO `6_stock_category` VALUES
('5', ' 	Food', '1', ' 	Cone', 'B', '4100', '2000', '0100', '0100', '0100', '0', '0', '0', '0', '0'),
('6', ' 	Beverage', '1', ' 	Cone', 'B', '4100', '2000', '0100', '0100', '0100', '0', '0', '0', '0', '0');

### Structure of table `6_stock_fa_class` ###

DROP TABLE IF EXISTS `6_stock_fa_class`;

CREATE TABLE `6_stock_fa_class` (
  `fa_class_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `long_description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `depreciation_rate` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fa_class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_stock_fa_class` ###


### Structure of table `6_stock_master` ###

DROP TABLE IF EXISTS `6_stock_master`;

CREATE TABLE `6_stock_master` (
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `long_description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cogs_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inventory_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `adjustment_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `wip_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` int(11) DEFAULT NULL,
  `dimension2_id` int(11) DEFAULT NULL,
  `purchase_cost` double NOT NULL DEFAULT '0',
  `material_cost` double NOT NULL DEFAULT '0',
  `labour_cost` double NOT NULL DEFAULT '0',
  `overhead_cost` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `no_sale` tinyint(1) NOT NULL DEFAULT '0',
  `no_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `editable` tinyint(1) NOT NULL DEFAULT '0',
  `depreciation_method` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'S',
  `depreciation_rate` double NOT NULL DEFAULT '0',
  `depreciation_factor` double NOT NULL DEFAULT '1',
  `depreciation_start` date NOT NULL DEFAULT '0000-00-00',
  `depreciation_date` date NOT NULL DEFAULT '0000-00-00',
  `fa_class_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_stock_master` ###

INSERT INTO `6_stock_master` VALUES
('001', '5', '1', 'Food', '', ' 	Cone', 'B', '4100', '2000', '0100', '0100', '0100', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('002', '6', '1', ' 	Beverage', '', ' 	Cone', 'B', '4100', '2110', '0100', '0100', '0100', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '');

### Structure of table `6_stock_moves` ###

DROP TABLE IF EXISTS `6_stock_moves`;

CREATE TABLE `6_stock_moves` (
  `trans_id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` smallint(6) NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `price` double NOT NULL DEFAULT '0',
  `reference` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT '1',
  `standard_cost` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`trans_id`),
  KEY `type` (`type`,`trans_no`),
  KEY `Move` (`stock_id`,`loc_code`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_stock_moves` ###

INSERT INTO `6_stock_moves` VALUES
('5', '5', '001', '13', 'LOC1', '2015-04-30', '272659', '001/2015', '-1', '0'),
('6', '6', '001', '13', 'LOC1', '2015-05-31', '303185', 'auto', '-1', '0'),
('7', '7', '001', '13', 'LOC1', '2015-06-30', '322814', 'auto', '-1', '0'),
('8', '8', '001', '13', 'LOC1', '2015-07-03', '20200', 'auto', '-1', '0'),
('9', '8', '002', '13', 'LOC1', '2015-07-03', '6705', 'auto', '-1', '0'),
('10', '9', '001', '13', 'LOC1', '2015-07-10', '62453', 'auto', '-1', '0'),
('11', '10', '001', '13', 'LOC1', '2015-07-17', '62364', 'auto', '-1', '0'),
('12', '11', '001', '13', 'LOC1', '2015-07-24', '61302', 'auto', '-1', '0'),
('13', '12', '001', '13', 'DEF', '2015-07-31', '79320', 'auto', '-1', '0'),
('14', '13', '001', '13', 'LOC1', '2015-08-07', '62403', 'auto', '-1', '0'),
('15', '13', '002', '13', 'LOC1', '2015-08-07', '9645', 'auto', '-1', '0'),
('16', '14', '001', '13', 'LOC1', '2015-08-14', '74651', 'auto', '-1', '0'),
('17', '15', '001', '13', 'LOC1', '2015-08-21', '67860', 'auto', '-1', '0'),
('18', '16', '001', '13', 'LOC1', '2015-08-28', '80505', 'auto', '-1', '0'),
('19', '17', '001', '13', 'LOC1', '2015-08-31', '48025', 'auto', '-1', '0'),
('20', '18', '001', '13', 'LOC1', '2015-09-04', '41292', 'auto', '-1', '0'),
('21', '18', '002', '13', 'LOC1', '2015-09-04', '7315', 'auto', '-1', '0'),
('22', '19', '001', '13', 'LOC1', '2015-09-11', '74533', 'auto', '-1', '0'),
('23', '20', '001', '13', 'LOC1', '2015-09-18', '79045', 'auto', '-1', '0'),
('24', '21', '001', '13', 'LOC1', '2015-09-25', '86405', 'auto', '-1', '0'),
('25', '22', '001', '13', 'LOC1', '2015-09-30', '60248', 'auto', '-1', '0'),
('26', '23', '001', '13', 'LOC1', '2015-10-04', '14500', 'auto', '-1', '0'),
('27', '23', '002', '13', 'LOC1', '2015-10-04', '8510', 'auto', '-1', '0'),
('28', '24', '001', '13', 'LOC1', '2015-10-09', '91729', 'auto', '-1', '0'),
('29', '25', '001', '13', 'LOC1', '2015-10-16', '63100', 'auto', '-1', '0'),
('30', '26', '001', '13', 'LOC1', '2015-10-23', '76586', 'auto', '-1', '0'),
('31', '27', '001', '13', 'LOC1', '2015-10-31', '73678', 'auto', '-1', '0'),
('32', '28', '001', '13', 'LOC1', '2015-11-06', '44235', 'auto', '-1', '0'),
('33', '28', '002', '13', 'LOC1', '2015-11-06', '6140', 'auto', '-1', '0'),
('34', '29', '001', '13', 'LOC1', '2015-11-13', '65880', 'auto', '-1', '0'),
('35', '30', '001', '13', 'LOC1', '2015-11-20', '68189', 'auto', '-1', '0'),
('36', '31', '001', '13', 'LOC1', '2015-11-27', '89000', 'auto', '-1', '0'),
('37', '32', '001', '13', 'LOC1', '2015-11-30', '40958', 'auto', '-1', '0'),
('38', '33', '001', '13', 'LOC1', '2015-12-04', '47669', 'auto', '-1', '0'),
('39', '33', '002', '13', 'LOC1', '2015-12-04', '6255', 'auto', '-1', '0'),
('40', '34', '001', '13', 'LOC1', '2015-12-11', '82963', 'auto', '-1', '0'),
('41', '35', '001', '13', 'LOC1', '2015-12-18', '71768', 'auto', '-1', '0'),
('42', '36', '001', '13', 'LOC1', '2015-12-25', '120771', 'auto', '-1', '0'),
('43', '37', '001', '13', 'LOC1', '2015-12-31', '89350', 'auto', '-1', '0'),
('44', '38', '001', '13', 'LOC1', '2016-01-01', '1790', 'auto', '-1', '0'),
('45', '38', '002', '13', 'LOC1', '2016-01-01', '8045', 'auto', '-1', '0'),
('46', '39', '002', '13', 'LOC1', '2016-01-08', '64306', 'auto', '-1', '0'),
('47', '40', '001', '13', 'LOC1', '2016-01-15', '95720', 'auto', '-1', '0'),
('48', '41', '001', '13', 'LOC1', '2016-01-22', '62295', 'auto', '-1', '0'),
('49', '42', '001', '13', 'LOC1', '2016-01-29', '113045', 'auto', '-1', '0'),
('50', '43', '001', '13', 'LOC1', '2016-01-31', '47945', 'auto', '-1', '0'),
('51', '44', '001', '13', 'LOC1', '2016-02-05', '53980', 'auto', '-1', '0'),
('52', '44', '002', '13', 'LOC1', '2016-02-05', '10585', 'auto', '-1', '0'),
('53', '45', '001', '13', 'LOC1', '2016-02-12', '103935', 'auto', '-1', '0'),
('54', '46', '001', '13', 'LOC1', '2016-02-19', '97114', 'auto', '-1', '0'),
('55', '47', '001', '13', 'LOC1', '2016-02-26', '110807', 'auto', '-1', '0'),
('56', '48', '001', '13', 'LOC1', '2016-02-29', '46100', 'auto', '-1', '0'),
('57', '49', '001', '13', 'LOC1', '2016-03-04', '31687', 'auto', '-1', '0'),
('58', '49', '002', '13', 'LOC1', '2016-03-04', '15200', 'auto', '-1', '0'),
('59', '50', '001', '13', 'LOC1', '2016-03-11', '107384', 'auto', '-1', '0'),
('60', '51', '001', '13', 'LOC1', '2016-03-18', '111432', 'auto', '-1', '0'),
('61', '52', '001', '13', 'LOC1', '2016-03-25', '92910', 'auto', '-1', '0'),
('62', '53', '001', '13', 'LOC1', '2016-03-31', '74215', 'auto', '-1', '0'),
('63', '54', '001', '13', 'LOC1', '2016-01-15', '12635', 'auto', '-1', '0'),
('64', '55', '001', '13', 'LOC1', '2016-01-22', '10430', 'auto', '-1', '0'),
('65', '56', '001', '13', 'LOC1', '2016-01-29', '6745', 'auto', '-1', '0'),
('66', '57', '001', '13', 'LOC1', '2016-01-31', '2310', 'auto', '-1', '0'),
('67', '58', '001', '13', 'LOC1', '2016-02-05', '5110', 'auto', '-1', '0'),
('68', '59', '002', '13', 'LOC1', '2016-02-12', '12205', 'auto', '-1', '0'),
('69', '60', '001', '13', 'LOC1', '2016-02-19', '10485', 'auto', '-1', '0'),
('70', '61', '001', '13', 'LOC1', '2016-02-26', '17820', 'auto', '-1', '0'),
('71', '62', '001', '13', 'LOC1', '2016-02-29', '5565', 'auto', '-1', '0'),
('72', '63', '001', '13', 'LOC1', '2016-03-04', '6750', 'auto', '-1', '0'),
('73', '64', '001', '13', 'LOC1', '2016-03-11', '10790', 'auto', '-1', '0'),
('74', '65', '001', '13', 'LOC1', '2016-03-18', '13605', 'auto', '-1', '0'),
('75', '66', '001', '13', 'LOC1', '2016-03-25', '11435', 'auto', '-1', '0'),
('76', '67', '001', '13', 'LOC1', '2016-03-31', '6445', 'auto', '-1', '0');

### Structure of table `6_stock_serial` ###

DROP TABLE IF EXISTS `6_stock_serial`;

CREATE TABLE `6_stock_serial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serial_key` int(4) DEFAULT NULL,
  `year_month` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serial_no` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `manufacture_date` date DEFAULT NULL,
  `stock_in_date` timestamp NULL DEFAULT NULL,
  `type_no_in` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_no_in` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `stock_out_date` datetime DEFAULT NULL,
  `type_no_out` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_no_out` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `availability` int(1) DEFAULT '1',
  `serial_status` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` int(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `serial_number` (`serial_no`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_stock_serial` ###


### Structure of table `6_stock_serial_genarate_log` ###

DROP TABLE IF EXISTS `6_stock_serial_genarate_log`;

CREATE TABLE `6_stock_serial_genarate_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serial_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `commnet` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `genarate_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_stock_serial_genarate_log` ###


### Structure of table `6_supp_allocations` ###

DROP TABLE IF EXISTS `6_supp_allocations`;

CREATE TABLE `6_supp_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trans_type_from` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_supp_allocations` ###


### Structure of table `6_supp_invoice_items` ###

DROP TABLE IF EXISTS `6_supp_invoice_items`;

CREATE TABLE `6_supp_invoice_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_trans_no` int(11) DEFAULT NULL,
  `supp_trans_type` int(11) DEFAULT NULL,
  `gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `grn_item_id` int(11) DEFAULT NULL,
  `po_detail_item_id` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `quantity` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `unit_tax` double NOT NULL DEFAULT '0',
  `memo_` tinytext COLLATE utf8_unicode_ci,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `Transaction` (`supp_trans_type`,`supp_trans_no`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_supp_invoice_items` ###


### Structure of table `6_supp_trans` ###

DROP TABLE IF EXISTS `6_supp_trans`;

CREATE TABLE `6_supp_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `supplier_id` int(11) unsigned DEFAULT NULL,
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `ov_amount` double NOT NULL DEFAULT '0',
  `ov_discount` double NOT NULL DEFAULT '0',
  `ov_gst` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  `alloc` double NOT NULL DEFAULT '0',
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`type`,`trans_no`),
  KEY `supplier_id` (`supplier_id`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_supp_trans` ###


### Structure of table `6_supplier_areas` ###

DROP TABLE IF EXISTS `6_supplier_areas`;

CREATE TABLE `6_supplier_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_supplier_areas` ###


### Structure of table `6_suppliers` ###

DROP TABLE IF EXISTS `6_suppliers`;

CREATE TABLE `6_suppliers` (
  `supplier_id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supp_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `gst_no` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supp_account_no` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `website` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  `dimension_id` int(11) DEFAULT '0',
  `dimension2_id` int(11) DEFAULT '0',
  `tax_group_id` int(11) DEFAULT NULL,
  `credit_limit` double NOT NULL DEFAULT '0',
  `purchase_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payable_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`supplier_id`),
  KEY `supp_ref` (`supp_ref`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_suppliers` ###

INSERT INTO `6_suppliers` VALUES
('1', 'Dino Saurius Inc.', 'Dino Saurius', 'N/A', '', '987654321', '', '', '', '', 'LKR', '3', '0', '0', '0', '1', '0', '', '0350', '0001', '', '0'),
('2', 'Beefeater Ltd.', 'Beefeater', 'N/A', '', '67565590', '', '', '', '', 'LKR', '4', '0', '0', '0', '1', '0', '', '0350', '0001', '', '0');

### Structure of table `6_sys_prefs` ###

DROP TABLE IF EXISTS `6_sys_prefs`;

CREATE TABLE `6_sys_prefs` (
  `name` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `length` smallint(6) DEFAULT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`name`),
  KEY `category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_sys_prefs` ###

INSERT INTO `6_sys_prefs` VALUES
('accounts_alpha', 'glsetup.general', 'tinyint', '1', '0'),
('accumulate_shipping', 'glsetup.customer', 'tinyint', '1', '0'),
('add_pct', 'setup.company', 'int', '5', '-1'),
('allow_negative_prices', 'glsetup.inventory', 'tinyint', '1', '1'),
('allow_negative_stock', 'glsetup.inventory', 'tinyint', '1', '1'),
('alternative_tax_include_on_docs', 'setup.company', 'tinyint', '1', ''),
('auto_curr_reval', 'setup.company', 'smallint', '6', '1'),
('bank_charge_act', 'glsetup.general', 'varchar', '15', '4350'),
('base_sales', 'setup.company', 'int', '11', '1'),
('bcc_email', 'setup.company', 'varchar', '100', ''),
('coy_logo', 'setup.company', 'varchar', '100', 'logo.png'),
('coy_name', 'setup.company', 'varchar', '60', 'Golden Palm'),
('coy_no', 'setup.company', 'varchar', '25', ''),
('creditors_act', 'glsetup.purchase', 'varchar', '15', '0350'),
('curr_default', 'setup.company', 'char', '3', 'LKR'),
('debtors_act', 'glsetup.sales', 'varchar', '15', '0250'),
('default_adj_act', 'glsetup.items', 'varchar', '15', '0100'),
('default_cogs_act', 'glsetup.items', 'varchar', '15', '2000'),
('default_credit_limit', 'glsetup.customer', 'int', '11', '1000'),
('default_delivery_required', 'glsetup.sales', 'smallint', '6', '1'),
('default_dim_required', 'glsetup.dims', 'int', '11', '20'),
('default_inv_sales_act', 'glsetup.items', 'varchar', '15', '4100'),
('default_inventory_act', 'glsetup.items', 'varchar', '15', '0100'),
('default_loss_on_asset_disposal_act', 'glsetup.items', 'varchar', '15', '0301'),
('default_prompt_payment_act', 'glsetup.sales', 'varchar', '15', '4100'),
('default_quote_valid_days', 'glsetup.sales', 'smallint', '6', '30'),
('default_receival_required', 'glsetup.purchase', 'smallint', '6', '10'),
('default_sales_act', 'glsetup.sales', 'varchar', '15', ''),
('default_sales_discount_act', 'glsetup.sales', 'varchar', '15', '4100'),
('default_wip_act', 'glsetup.items', 'varchar', '15', '0100'),
('default_workorder_required', 'glsetup.manuf', 'int', '11', '20'),
('deferred_income_act', 'glsetup.sales', 'varchar', '15', ''),
('depreciation_period', 'glsetup.company', 'tinyint', '1', '1'),
('domicile', 'setup.company', 'varchar', '55', ''),
('email', 'setup.company', 'varchar', '100', 'delta@delta.com'),
('exchange_diff_act', 'glsetup.general', 'varchar', '15', '0001'),
('f_year', 'setup.company', 'int', '11', '1'),
('fax', 'setup.company', 'varchar', '30', ''),
('freight_act', 'glsetup.customer', 'varchar', '15', '0001'),
('gl_closing_date', 'setup.closing_date', 'date', '8', '2014-03-31'),
('grn_clearing_act', 'glsetup.purchase', 'varchar', '15', ''),
('gst_no', 'setup.company', 'varchar', '25', '33445566'),
('legal_text', 'glsetup.customer', 'tinytext', '0', ''),
('loc_notification', 'glsetup.inventory', 'tinyint', '1', ''),
('login_tout', 'setup.company', 'smallint', '6', '60000000'),
('no_customer_list', 'setup.company', 'tinyint', '1', '0'),
('no_item_list', 'setup.company', 'tinyint', '1', '0'),
('no_supplier_list', 'setup.company', 'tinyint', '1', '0'),
('no_zero_lines_amount', 'glsetup.sales', 'tinyint', '1', '1'),
('past_due_days', 'glsetup.general', 'int', '11', '30'),
('phone', 'setup.company', 'varchar', '30', ''),
('po_over_charge', 'glsetup.purchase', 'int', '11', '0'),
('po_over_receive', 'glsetup.purchase', 'int', '11', '0'),
('postal_address', 'setup.company', 'tinytext', '0', 'N/A'),
('print_invoice_no', 'glsetup.sales', 'tinyint', '1', '0'),
('print_item_images_on_quote', 'glsetup.inventory', 'tinyint', '1', ''),
('profit_loss_year_act', 'glsetup.general', 'varchar', '15', '9990'),
('pyt_discount_act', 'glsetup.purchase', 'varchar', '15', '0001'),
('retained_earnings_act', 'glsetup.general', 'varchar', '15', '3000'),
('round_to', 'setup.company', 'int', '5', '1'),
('show_po_item_codes', 'glsetup.purchase', 'tinyint', '1', ''),
('suppress_tax_rates', 'setup.company', 'tinyint', '1', ''),
('tax_algorithm', 'glsetup.customer', 'tinyint', '1', '1'),
('tax_last', 'setup.company', 'int', '11', '1'),
('tax_prd', 'setup.company', 'int', '11', '1'),
('time_zone', 'setup.company', 'tinyint', '1', '0'),
('use_dimension', 'setup.company', 'tinyint', '1', '1'),
('use_fixed_assets', 'setup.company', 'tinyint', '1', '1'),
('use_manufacturing', 'setup.company', 'tinyint', '1', '1'),
('version_id', 'system', 'varchar', '11', '2.4.1');

### Structure of table `6_tag_associations` ###

DROP TABLE IF EXISTS `6_tag_associations`;

CREATE TABLE `6_tag_associations` (
  `record_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `tag_id` int(11) NOT NULL,
  UNIQUE KEY `record_id` (`record_id`,`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_tag_associations` ###


### Structure of table `6_tags` ###

DROP TABLE IF EXISTS `6_tags`;

CREATE TABLE `6_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_tags` ###


### Structure of table `6_tax_group_items` ###

DROP TABLE IF EXISTS `6_tax_group_items`;

CREATE TABLE `6_tax_group_items` (
  `tax_group_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `tax_shipping` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tax_group_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_tax_group_items` ###

INSERT INTO `6_tax_group_items` VALUES
('1', '1', '0');

### Structure of table `6_tax_groups` ###

DROP TABLE IF EXISTS `6_tax_groups`;

CREATE TABLE `6_tax_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_tax_groups` ###

INSERT INTO `6_tax_groups` VALUES
('1', 'Tax', '0'),
('2', 'Tax Exempt', '0');

### Structure of table `6_tax_types` ###

DROP TABLE IF EXISTS `6_tax_types`;

CREATE TABLE `6_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rate` double NOT NULL DEFAULT '0',
  `sales_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `purchasing_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_tax_types` ###

INSERT INTO `6_tax_types` VALUES
('1', '15', '535', '535', 'V.A.T ', '0');

### Structure of table `6_trans_tax_details` ###

DROP TABLE IF EXISTS `6_trans_tax_details`;

CREATE TABLE `6_trans_tax_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `tran_date` date NOT NULL,
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '0',
  `ex_rate` double NOT NULL DEFAULT '1',
  `included_in_price` tinyint(1) NOT NULL DEFAULT '0',
  `net_amount` double NOT NULL DEFAULT '0',
  `amount` double NOT NULL DEFAULT '0',
  `memo` tinytext COLLATE utf8_unicode_ci,
  `reg_type` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Type_and_Number` (`trans_type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_trans_tax_details` ###

INSERT INTO `6_trans_tax_details` VALUES
('1', '1', '11', '2015-10-19', '1', '5', '1', '0', '-1000000', '-50000', NULL, NULL),
('2', '1', '14', '2015-11-09', '1', '5', '1', '0', '-1191000', '-59550', NULL, NULL),
('3', '1', '15', '2015-11-12', '1', '5', '1', '0', '-317000', '-15850', NULL, NULL),
('4', '1', '16', '2015-11-17', '1', '5', '1', '0', '-1200000', '-60000', NULL, NULL),
('5', '1', '17', '2015-11-20', '1', '5', '1', '0', '-3935800', '-196790', NULL, NULL),
('6', '1', '19', '2015-11-26', '1', '5', '1', '0', '-618200', '-30910', NULL, NULL),
('7', '1', '20', '2015-11-30', '1', '5', '1', '0', '-873000', '-43650', NULL, NULL),
('8', '1', '22', '2015-12-08', '1', '5', '1', '0', '-1544300', '-77215', NULL, NULL),
('9', '1', '26', '2015-12-21', '1', '5', '1', '0', '-1088500', '-54425', NULL, NULL),
('10', '1', '27', '2015-12-22', '1', '5', '1', '0', '-794080', '-39704', NULL, NULL),
('11', '1', '28', '2016-01-03', '1', '5', '1', '0', '-282100', '-14105', NULL, NULL),
('12', '1', '29', '2015-12-07', '1', '5', '1', '0', '0', '0', NULL, NULL),
('13', '1', '30', '2016-01-07', '1', '5', '1', '0', '-498200', '-24910', NULL, NULL),
('14', '1', '32', '2016-01-24', '1', '5', '1', '0', '-629340', '-31467', NULL, NULL),
('15', '1', '33', '2016-01-27', '1', '5', '1', '0', '-156600', '-7830', NULL, NULL),
('16', '1', '36', '2016-02-19', '1', '5', '1', '0', '-125500', '-6275', NULL, NULL),
('17', '1', '44', '2016-01-22', '1', '5', '1', '0', '-948900', '-47445', NULL, NULL),
('18', '13', '1', '2015-04-30', '1', '5', '1', '1', '0', '0', 'auto', NULL),
('19', '10', '1', '2015-04-30', '1', '5', '1', '1', '0', '0', '001/2015', '0'),
('20', '13', '2', '2015-04-30', '1', '5', '1', '1', '0', '0', 'auto', NULL),
('21', '10', '2', '2015-04-30', '1', '5', '1', '1', '0', '0', '001/2015', '0'),
('22', '13', '3', '2016-03-31', '1', '5', '1', '1', '0', '0', 'auto', NULL),
('23', '10', '3', '2016-03-31', '1', '5', '1', '1', '0', '0', '001/2016', '0'),
('24', '13', '4', '2016-03-31', '0', '0', '1', '1', '0', '0', 'auto', NULL),
('25', '10', '4', '2016-03-31', '0', '0', '1', '1', '0', '0', '002/2016', '0'),
('26', '13', '5', '2015-04-30', '0', '0', '1', '1', '272659', '0', '001/2015', NULL),
('27', '10', '5', '2015-04-30', '0', '0', '1', '1', '272659', '0', '001/2015', '0'),
('28', '13', '6', '2015-05-31', '0', '0', '1', '1', '303185', '0', 'auto', NULL),
('29', '10', '6', '2015-05-31', '0', '0', '1', '1', '303185', '0', '002/2015', '0'),
('30', '13', '7', '2015-06-30', '0', '0', '1', '1', '322814', '0', 'auto', NULL),
('31', '10', '7', '2015-06-30', '0', '0', '1', '1', '322814', '0', '003/2015', '0'),
('32', '13', '8', '2015-07-03', '0', '0', '1', '1', '26905', '0', 'auto', NULL),
('33', '10', '8', '2015-07-03', '0', '0', '1', '1', '26905', '0', '004/2015', '0'),
('34', '13', '9', '2015-07-10', '0', '0', '1', '1', '62453', '0', 'auto', NULL),
('35', '10', '9', '2015-07-10', '0', '0', '1', '1', '62453', '0', '005/2015', '0'),
('36', '13', '10', '2015-07-17', '0', '0', '1', '1', '62364', '0', 'auto', NULL),
('37', '10', '10', '2015-07-17', '0', '0', '1', '1', '62364', '0', '006/2015', '0'),
('38', '13', '11', '2015-07-24', '0', '0', '1', '1', '61302', '0', 'auto', NULL),
('39', '10', '11', '2015-07-24', '0', '0', '1', '1', '61302', '0', '007/2015', '0'),
('40', '13', '12', '2015-07-31', '0', '0', '1', '1', '79320', '0', 'auto', NULL),
('41', '10', '12', '2015-07-31', '0', '0', '1', '1', '79320', '0', '008/2015', '0'),
('42', '13', '13', '2015-08-07', '0', '0', '1', '1', '72048', '0', 'auto', NULL),
('43', '10', '13', '2015-08-07', '0', '0', '1', '1', '72048', '0', '009/2015', '0'),
('44', '13', '14', '2015-08-14', '0', '0', '1', '1', '74651', '0', 'auto', NULL),
('45', '10', '14', '2015-08-14', '0', '0', '1', '1', '74651', '0', '010/2015', '0'),
('46', '13', '15', '2015-08-21', '0', '0', '1', '1', '67860', '0', 'auto', NULL),
('47', '10', '15', '2015-08-21', '0', '0', '1', '1', '67860', '0', '011/2015', '0'),
('48', '13', '16', '2015-08-28', '0', '0', '1', '1', '80505', '0', 'auto', NULL),
('49', '10', '16', '2015-08-28', '0', '0', '1', '1', '80505', '0', '012/2015', '0'),
('50', '13', '17', '2015-08-31', '0', '0', '1', '1', '48025', '0', 'auto', NULL),
('51', '10', '17', '2015-08-31', '0', '0', '1', '1', '48025', '0', '013/2015', '0'),
('52', '13', '18', '2015-09-04', '0', '0', '1', '1', '48607', '0', 'auto', NULL),
('53', '10', '18', '2015-09-04', '0', '0', '1', '1', '48607', '0', '014/2015', '0'),
('54', '13', '19', '2015-09-11', '0', '0', '1', '1', '74533', '0', 'auto', NULL),
('55', '10', '19', '2015-09-11', '0', '0', '1', '1', '74533', '0', '015/2015', '0'),
('56', '13', '20', '2015-09-18', '0', '0', '1', '1', '79045', '0', 'auto', NULL),
('57', '10', '20', '2015-09-18', '0', '0', '1', '1', '79045', '0', '016/2015', '0'),
('58', '13', '21', '2015-09-25', '0', '0', '1', '1', '86405', '0', 'auto', NULL),
('59', '10', '21', '2015-09-25', '0', '0', '1', '1', '86405', '0', '017/2015', '0'),
('60', '13', '22', '2015-09-30', '0', '0', '1', '1', '60248', '0', 'auto', NULL),
('61', '10', '22', '2015-09-30', '0', '0', '1', '1', '60248', '0', '018/2015', '0'),
('62', '13', '23', '2015-10-04', '0', '0', '1', '1', '23010', '0', 'auto', NULL),
('63', '10', '23', '2015-10-04', '0', '0', '1', '1', '23010', '0', '019/2015', '0'),
('64', '13', '24', '2015-10-09', '0', '0', '1', '1', '91729', '0', 'auto', NULL),
('65', '10', '24', '2015-10-09', '0', '0', '1', '1', '91729', '0', '020/2015', '0'),
('66', '13', '25', '2015-10-16', '0', '0', '1', '1', '63100', '0', 'auto', NULL),
('67', '10', '25', '2015-10-16', '0', '0', '1', '1', '63100', '0', '021/2015', '0'),
('68', '13', '26', '2015-10-23', '0', '0', '1', '1', '76586', '0', 'auto', NULL),
('69', '10', '26', '2015-10-23', '0', '0', '1', '1', '76586', '0', '022/2015', '0'),
('70', '13', '27', '2015-10-31', '0', '0', '1', '1', '73678', '0', 'auto', NULL),
('71', '10', '27', '2015-10-31', '0', '0', '1', '1', '73678', '0', '023/2015', '0'),
('72', '13', '28', '2015-11-06', '0', '0', '1', '1', '50375', '0', 'auto', NULL),
('73', '10', '28', '2015-11-06', '0', '0', '1', '1', '50375', '0', '024/2015', '0'),
('74', '13', '29', '2015-11-13', '0', '0', '1', '1', '65880', '0', 'auto', NULL),
('75', '10', '29', '2015-11-13', '0', '0', '1', '1', '65880', '0', '025/2015', '0'),
('76', '13', '30', '2015-11-20', '0', '0', '1', '1', '68189', '0', 'auto', NULL),
('77', '10', '30', '2015-11-20', '0', '0', '1', '1', '68189', '0', '026/2015', '0'),
('78', '13', '31', '2015-11-27', '0', '0', '1', '1', '89000', '0', 'auto', NULL),
('79', '10', '31', '2015-11-27', '0', '0', '1', '1', '89000', '0', '027/2015', '0'),
('80', '13', '32', '2015-11-30', '0', '0', '1', '1', '40958', '0', 'auto', NULL),
('81', '10', '32', '2015-11-30', '0', '0', '1', '1', '40958', '0', '028/2015', '0'),
('82', '13', '33', '2015-12-04', '0', '0', '1', '1', '53924', '0', 'auto', NULL),
('83', '10', '33', '2015-12-04', '0', '0', '1', '1', '53924', '0', '029/2015', '0'),
('84', '13', '34', '2015-12-11', '0', '0', '1', '1', '82963', '0', 'auto', NULL),
('85', '10', '34', '2015-12-11', '0', '0', '1', '1', '82963', '0', '030/2015', '0'),
('86', '13', '35', '2015-12-18', '0', '0', '1', '1', '71768', '0', 'auto', NULL),
('87', '10', '35', '2015-12-18', '0', '0', '1', '1', '71768', '0', '031/2015', '0'),
('88', '13', '36', '2015-12-25', '0', '0', '1', '1', '120771', '0', 'auto', NULL),
('89', '10', '36', '2015-12-25', '0', '0', '1', '1', '120771', '0', '032/2015', '0'),
('90', '13', '37', '2015-12-31', '0', '0', '1', '1', '89350', '0', 'auto', NULL),
('91', '10', '37', '2015-12-31', '0', '0', '1', '1', '89350', '0', '033/2015', '0'),
('92', '13', '38', '2016-01-01', '0', '0', '1', '1', '9835', '0', 'auto', NULL),
('93', '10', '38', '2016-01-01', '0', '0', '1', '1', '9835', '0', '003/2016', '0'),
('94', '13', '39', '2016-01-08', '0', '0', '1', '1', '64306', '0', 'auto', NULL),
('95', '10', '39', '2016-01-08', '0', '0', '1', '1', '64306', '0', '004/2016', '0'),
('96', '13', '40', '2016-01-15', '0', '0', '1', '1', '95720', '0', 'auto', NULL),
('97', '10', '40', '2016-01-15', '0', '0', '1', '1', '95720', '0', '005/2016', '0'),
('98', '13', '41', '2016-01-22', '0', '0', '1', '1', '62295', '0', 'auto', NULL),
('99', '10', '41', '2016-01-22', '0', '0', '1', '1', '62295', '0', '006/2016', '0'),
('100', '13', '42', '2016-01-29', '0', '0', '1', '1', '113045', '0', 'auto', NULL),
('101', '10', '42', '2016-01-29', '0', '0', '1', '1', '113045', '0', '007/2016', '0'),
('102', '13', '43', '2016-01-31', '0', '0', '1', '1', '47945', '0', 'auto', NULL),
('103', '10', '43', '2016-01-31', '0', '0', '1', '1', '47945', '0', '008/2016', '0'),
('104', '13', '44', '2016-02-05', '0', '0', '1', '1', '64565', '0', 'auto', NULL),
('105', '10', '44', '2016-02-05', '0', '0', '1', '1', '64565', '0', '009/2016', '0'),
('106', '13', '45', '2016-02-12', '0', '0', '1', '1', '103935', '0', 'auto', NULL),
('107', '10', '45', '2016-02-12', '0', '0', '1', '1', '103935', '0', '010/2016', '0'),
('108', '13', '46', '2016-02-19', '0', '0', '1', '1', '97114', '0', 'auto', NULL),
('109', '10', '46', '2016-02-19', '0', '0', '1', '1', '97114', '0', '011/2016', '0'),
('110', '13', '47', '2016-02-26', '0', '0', '1', '1', '110807', '0', 'auto', NULL),
('111', '10', '47', '2016-02-26', '0', '0', '1', '1', '110807', '0', '012/2016', '0'),
('112', '13', '48', '2016-02-29', '0', '0', '1', '1', '46100', '0', 'auto', NULL),
('113', '10', '48', '2016-02-29', '0', '0', '1', '1', '46100', '0', '013/2016', '0'),
('114', '13', '49', '2016-03-04', '0', '0', '1', '1', '46887', '0', 'auto', NULL),
('115', '10', '49', '2016-03-04', '0', '0', '1', '1', '46887', '0', '014/2016', '0'),
('116', '13', '50', '2016-03-11', '0', '0', '1', '1', '107384', '0', 'auto', NULL),
('117', '10', '50', '2016-03-11', '0', '0', '1', '1', '107384', '0', '015/2016', '0'),
('118', '13', '51', '2016-03-18', '0', '0', '1', '1', '111432', '0', 'auto', NULL),
('119', '10', '51', '2016-03-18', '0', '0', '1', '1', '111432', '0', '016/2016', '0'),
('120', '13', '52', '2016-03-25', '0', '0', '1', '1', '92910', '0', 'auto', NULL),
('121', '10', '52', '2016-03-25', '0', '0', '1', '1', '92910', '0', '017/2016', '0'),
('122', '13', '53', '2016-03-31', '0', '0', '1', '1', '74215', '0', 'auto', NULL),
('123', '10', '53', '2016-03-31', '0', '0', '1', '1', '74215', '0', '018/2016', '0'),
('124', '13', '54', '2016-01-15', '0', '0', '1', '1', '12635', '0', 'auto', NULL),
('125', '10', '54', '2016-01-15', '0', '0', '1', '1', '12635', '0', '019/2016', '0'),
('126', '13', '55', '2016-01-22', '0', '0', '1', '1', '10430', '0', 'auto', NULL),
('127', '10', '55', '2016-01-22', '0', '0', '1', '1', '10430', '0', '020/2016', '0'),
('128', '13', '56', '2016-01-29', '0', '0', '1', '1', '6745', '0', 'auto', NULL),
('129', '10', '56', '2016-01-29', '0', '0', '1', '1', '6745', '0', '021/2016', '0'),
('130', '13', '57', '2016-01-31', '0', '0', '1', '1', '2310', '0', 'auto', NULL),
('131', '10', '57', '2016-01-31', '0', '0', '1', '1', '2310', '0', '022/2016', '0'),
('132', '13', '58', '2016-02-05', '0', '0', '1', '1', '5110', '0', 'auto', NULL),
('133', '10', '58', '2016-02-05', '0', '0', '1', '1', '5110', '0', '023/2016', '0'),
('134', '13', '59', '2016-02-12', '0', '0', '1', '1', '12205', '0', 'auto', NULL),
('135', '10', '59', '2016-02-12', '0', '0', '1', '1', '12205', '0', '024/2016', '0'),
('136', '13', '60', '2016-02-19', '0', '0', '1', '1', '10485', '0', 'auto', NULL),
('137', '10', '60', '2016-02-19', '0', '0', '1', '1', '10485', '0', '025/2016', '0'),
('138', '13', '61', '2016-02-26', '0', '0', '1', '1', '17820', '0', 'auto', NULL),
('139', '10', '61', '2016-02-26', '0', '0', '1', '1', '17820', '0', '026/2016', '0'),
('140', '13', '62', '2016-02-29', '0', '0', '1', '1', '5565', '0', 'auto', NULL),
('141', '10', '62', '2016-02-29', '0', '0', '1', '1', '5565', '0', '027/2016', '0'),
('142', '13', '63', '2016-03-04', '0', '0', '1', '1', '6750', '0', 'auto', NULL),
('143', '10', '63', '2016-03-04', '0', '0', '1', '1', '6750', '0', '028/2016', '0'),
('144', '13', '64', '2016-03-11', '0', '0', '1', '1', '10790', '0', 'auto', NULL),
('145', '10', '64', '2016-03-11', '0', '0', '1', '1', '10790', '0', '029/2016', '0'),
('146', '13', '65', '2016-03-18', '0', '0', '1', '1', '13605', '0', 'auto', NULL),
('147', '10', '65', '2016-03-18', '0', '0', '1', '1', '13605', '0', '030/2016', '0'),
('148', '13', '66', '2016-03-25', '0', '0', '1', '1', '11435', '0', 'auto', NULL),
('149', '10', '66', '2016-03-25', '0', '0', '1', '1', '11435', '0', '031/2016', '0'),
('150', '13', '67', '2016-03-31', '0', '0', '1', '1', '6445', '0', 'auto', NULL),
('151', '10', '67', '2016-03-31', '0', '0', '1', '1', '6445', '0', '032/2016', '0');

### Structure of table `6_type_styles` ###

DROP TABLE IF EXISTS `6_type_styles`;

CREATE TABLE `6_type_styles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ts_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `ts_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `inactive` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_type_styles` ###


### Structure of table `6_useronline` ###

DROP TABLE IF EXISTS `6_useronline`;

CREATE TABLE `6_useronline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` int(15) NOT NULL DEFAULT '0',
  `ip` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `file` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_useronline` ###


### Structure of table `6_users` ###

DROP TABLE IF EXISTS `6_users`;

CREATE TABLE `6_users` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `real_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `role_id` int(11) NOT NULL DEFAULT '1',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_format` tinyint(1) NOT NULL DEFAULT '0',
  `date_sep` tinyint(1) NOT NULL DEFAULT '0',
  `tho_sep` tinyint(1) NOT NULL DEFAULT '0',
  `dec_sep` tinyint(1) NOT NULL DEFAULT '0',
  `theme` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'default',
  `page_size` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'A4',
  `prices_dec` smallint(6) NOT NULL DEFAULT '2',
  `qty_dec` smallint(6) NOT NULL DEFAULT '2',
  `rates_dec` smallint(6) NOT NULL DEFAULT '4',
  `percent_dec` smallint(6) NOT NULL DEFAULT '1',
  `show_gl` tinyint(1) NOT NULL DEFAULT '1',
  `show_codes` tinyint(1) NOT NULL DEFAULT '0',
  `show_hints` tinyint(1) NOT NULL DEFAULT '0',
  `last_visit_date` datetime DEFAULT NULL,
  `query_size` tinyint(1) unsigned NOT NULL DEFAULT '10',
  `graphic_links` tinyint(1) DEFAULT '1',
  `pos` smallint(6) DEFAULT '1',
  `print_profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rep_popup` tinyint(1) DEFAULT '1',
  `sticky_doc_date` tinyint(1) DEFAULT '0',
  `startup_tab` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `transaction_days` smallint(6) NOT NULL DEFAULT '30',
  `save_report_selections` smallint(6) NOT NULL DEFAULT '0',
  `use_date_picker` tinyint(1) NOT NULL DEFAULT '1',
  `def_print_destination` tinyint(1) NOT NULL DEFAULT '0',
  `def_print_orientation` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_users` ###

INSERT INTO `6_users` VALUES
('1', 'admin', '5f4dcc3b5aa765d61d8327deb882cf99', 'Administrator', '2', '', 'adm@example.com', 'C', '0', '0', '0', '0', 'bluecollar', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2016-12-14 22:53:19', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0');

### Structure of table `6_voided` ###

DROP TABLE IF EXISTS `6_voided`;

CREATE TABLE `6_voided` (
  `type` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_voided` ###

INSERT INTO `6_voided` VALUES
('0', '1', '2016-03-31', ''),
('0', '92', '2016-12-07', 'Document reentered.'),
('1', '4', '2016-11-30', 'Document reentered.'),
('1', '29', '2016-11-23', 'Document reentered.'),
('1', '79', '2016-12-07', 'Document reentered.'),
('1', '83', '2016-12-08', 'Document reentered.'),
('1', '86', '2016-12-08', 'Document reentered.'),
('2', '1', '2016-02-15', ''),
('2', '2', '2016-11-21', 'Document reentered.'),
('2', '3', '2016-03-31', ''),
('2', '4', '2016-11-21', 'Document reentered.'),
('2', '16', '2016-11-23', 'Document reentered.'),
('2', '30', '2016-12-05', 'Document reentered.'),
('2', '37', '2016-03-31', ''),
('2', '46', '2016-03-31', ''),
('4', '98', '2016-03-31', ''),
('4', '206', '2016-03-14', ''),
('10', '1', '2016-03-31', ''),
('10', '2', '2016-03-31', ''),
('10', '3', '2016-03-31', ''),
('10', '4', '2015-12-08', ''),
('12', '3', '2015-12-08', ''),
('12', '4', '2015-12-24', ''),
('13', '1', '2016-12-02', ''),
('13', '2', '2016-12-02', ''),
('13', '3', '2016-12-05', ''),
('13', '4', '2016-12-05', '');

### Structure of table `6_wo_costing` ###

DROP TABLE IF EXISTS `6_wo_costing`;

CREATE TABLE `6_wo_costing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `cost_type` tinyint(1) NOT NULL DEFAULT '0',
  `trans_type` int(11) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `factor` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_wo_costing` ###


### Structure of table `6_wo_issue_items` ###

DROP TABLE IF EXISTS `6_wo_issue_items`;

CREATE TABLE `6_wo_issue_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_id` int(11) DEFAULT NULL,
  `qty_issued` double DEFAULT NULL,
  `unit_cost` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_wo_issue_items` ###


### Structure of table `6_wo_issues` ###

DROP TABLE IF EXISTS `6_wo_issues`;

CREATE TABLE `6_wo_issues` (
  `issue_no` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workcentre_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`issue_no`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_wo_issues` ###


### Structure of table `6_wo_manufacture` ###

DROP TABLE IF EXISTS `6_wo_manufacture`;

CREATE TABLE `6_wo_manufacture` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_wo_manufacture` ###


### Structure of table `6_wo_requirements` ###

DROP TABLE IF EXISTS `6_wo_requirements`;

CREATE TABLE `6_wo_requirements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre` int(11) NOT NULL DEFAULT '0',
  `units_req` double NOT NULL DEFAULT '1',
  `unit_cost` double NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_issued` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_wo_requirements` ###


### Structure of table `6_workcentres` ###

DROP TABLE IF EXISTS `6_workcentres`;

CREATE TABLE `6_workcentres` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_workcentres` ###

INSERT INTO `6_workcentres` VALUES
('1', 'Work Centre', '', '0');

### Structure of table `6_workorders` ###

DROP TABLE IF EXISTS `6_workorders`;

CREATE TABLE `6_workorders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wo_ref` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_reqd` double NOT NULL DEFAULT '1',
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `required_by` date NOT NULL DEFAULT '0000-00-00',
  `released_date` date NOT NULL DEFAULT '0000-00-00',
  `units_issued` double NOT NULL DEFAULT '0',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `released` tinyint(1) NOT NULL DEFAULT '0',
  `additional_costs` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `wo_ref` (`wo_ref`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `6_workorders` ###
