# MySQL dump of database 'evolve8_accounts' on host 'localhost'
# Backup Date and Time: 2016-10-06 03:42
# Built by evolve360 
# http://evolve-sl.com
# Company: Involve 360 (Pvt) Ltd.
# User: Administrator



### Structure of table `1_amortisation` ###

DROP TABLE IF EXISTS `1_amortisation`;

CREATE TABLE `1_amortisation` (
  `amortisation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `amortisation_year` int(11) DEFAULT NULL,
  `asset_value` double DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `posted` int(11) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`amortisation_id`),
  UNIQUE KEY `amortisation_id` (`amortisation_id`),
  KEY `1_amortisation_asset_id` (`asset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_amortisation` ###


### Structure of table `1_areas` ###

DROP TABLE IF EXISTS `1_areas`;

CREATE TABLE `1_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_areas` ###

INSERT INTO `1_areas` VALUES
('1', 'Global', '0');

### Structure of table `1_asset_types` ###

DROP TABLE IF EXISTS `1_asset_types`;

CREATE TABLE `1_asset_types` (
  `asset_type_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_type_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `depreciation_type` int(11) NOT NULL DEFAULT '1',
  `depreciation_rate` double NOT NULL DEFAULT '10',
  `asset_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `depreciation_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `accumulated_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `valuation_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `disposal_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_type_id`),
  UNIQUE KEY `asset_type_id` (`asset_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_asset_types` ###


### Structure of table `1_asset_valuations` ###

DROP TABLE IF EXISTS `1_asset_valuations`;

CREATE TABLE `1_asset_valuations` (
  `asset_valuation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `valuation_year` int(11) DEFAULT NULL,
  `asset_value` double NOT NULL DEFAULT '0',
  `value_change` double NOT NULL DEFAULT '0',
  `posted` int(11) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_valuation_id`),
  UNIQUE KEY `asset_valuation_id` (`asset_valuation_id`),
  UNIQUE KEY `asset_id` (`asset_id`,`valuation_year`),
  KEY `1_asset_valuations_asset_id` (`asset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_asset_valuations` ###


### Structure of table `1_assets` ###

DROP TABLE IF EXISTS `1_assets`;

CREATE TABLE `1_assets` (
  `asset_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_type_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `asset_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_serial` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `purchase_date` date NOT NULL,
  `purchase_value` double NOT NULL,
  `disposal_amount` double DEFAULT NULL,
  `disposal_date` date DEFAULT NULL,
  `disposal_posting` int(11) DEFAULT '0',
  `tag_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_location` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_condition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_acquisition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_id`),
  UNIQUE KEY `asset_id` (`asset_id`),
  KEY `1_assets_asset_type_id` (`asset_type_id`),
  KEY `1_assets_item_id` (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_assets` ###


### Structure of table `1_attachments` ###

DROP TABLE IF EXISTS `1_attachments`;

CREATE TABLE `1_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_no` int(11) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `unique_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT '0',
  `filetype` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_attachments` ###


### Structure of table `1_audit_trail` ###

DROP TABLE IF EXISTS `1_audit_trail`;

CREATE TABLE `1_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `user` smallint(6) unsigned NOT NULL DEFAULT '0',
  `stamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL,
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=1829 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_audit_trail` ###

INSERT INTO `1_audit_trail` VALUES
('1', '1', '1', '1', '2012-02-18 14:06:41', NULL, '4', '2010-12-15', NULL),
('2', '1', '2', '1', '2012-02-18 14:03:58', NULL, '4', '2011-03-31', NULL),
('3', '1', '3', '1', '2012-02-18 14:08:14', NULL, '4', '2011-03-31', NULL),
('4', '1', '4', '1', '2012-02-18 14:08:43', NULL, '4', '2010-12-30', NULL),
('5', '1', '2', '1', '2012-02-18 14:07:29', NULL, '4', '2011-03-31', NULL),
('6', '1', '1', '1', '2012-02-27 17:42:03', NULL, '4', '2010-12-15', NULL),
('7', '1', '2', '1', '2013-08-03 02:58:39', NULL, '4', '2010-12-29', '31'),
('8', '1', '3', '1', '2012-02-27 17:43:51', NULL, '4', '2010-12-30', NULL),
('9', '1', '4', '1', '2013-08-03 02:58:39', NULL, '4', '2010-12-30', '32'),
('10', '1', '5', '1', '2013-08-03 02:58:39', NULL, '4', '2010-12-30', '33'),
('11', '1', '6', '1', '2012-02-28 16:55:04', NULL, '4', '2010-12-30', NULL),
('12', '1', '7', '1', '2012-02-28 16:55:42', NULL, '4', '2010-12-30', NULL),
('13', '1', '8', '1', '2013-08-03 02:58:39', NULL, '4', '2011-02-02', '44'),
('14', '1', '9', '1', '2013-08-03 02:58:39', NULL, '4', '2011-02-02', '45'),
('15', '1', '10', '1', '2013-08-03 02:58:39', NULL, '4', '2011-02-10', '47'),
('16', '1', '11', '1', '2012-02-22 14:13:41', NULL, '4', '2011-02-15', NULL),
('17', '1', '12', '1', '2012-02-22 14:13:13', NULL, '4', '2011-02-15', NULL),
('18', '1', '13', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-01', '55'),
('19', '1', '14', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-01', '56'),
('20', '1', '15', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-01', '57'),
('21', '1', '16', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-17', '59'),
('22', '1', '17', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-31', '65'),
('23', '1', '18', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-31', '66'),
('24', '0', '1', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-31', '67'),
('25', '30', '1', '1', '2012-02-19 10:37:59', NULL, '4', '2010-11-23', '0'),
('26', '13', '1', '1', '2012-02-19 10:37:59', NULL, '4', '2010-11-23', '0'),
('27', '10', '1', '1', '2013-08-03 02:58:39', NULL, '4', '2010-11-23', '12'),
('28', '30', '2', '1', '2012-02-19 10:39:33', NULL, '4', '2010-12-13', '0'),
('29', '13', '2', '1', '2012-02-19 10:39:33', NULL, '4', '2010-12-13', '0'),
('30', '10', '2', '1', '2013-08-03 02:58:39', NULL, '4', '2010-12-13', '27'),
('31', '30', '3', '1', '2012-02-19 10:41:04', NULL, '4', '2011-01-14', '0'),
('32', '13', '3', '1', '2012-02-19 10:41:04', NULL, '4', '2011-01-14', '0'),
('33', '10', '3', '1', '2013-08-03 02:58:39', NULL, '4', '2011-01-14', '40'),
('34', '30', '4', '1', '2012-02-19 10:41:43', NULL, '4', '2011-01-14', '0'),
('35', '13', '4', '1', '2012-02-19 10:41:43', NULL, '4', '2011-01-14', '0'),
('36', '10', '4', '1', '2012-02-19 10:45:17', NULL, '4', '2011-01-14', NULL),
('37', '30', '5', '1', '2012-02-19 10:42:17', NULL, '4', '2011-01-14', '0'),
('38', '13', '5', '1', '2012-02-19 10:42:17', NULL, '4', '2011-01-14', '0'),
('39', '10', '5', '1', '2012-02-19 10:44:26', NULL, '4', '2011-01-14', NULL),
('40', '10', '5', '1', '2013-08-03 02:58:39', 'Updated.', '4', '2011-03-17', '60'),
('41', '10', '4', '1', '2013-08-03 02:58:39', 'Updated.', '4', '2011-02-18', '51'),
('42', '1', '12', '1', '2013-08-03 02:58:39', NULL, '4', '2011-02-15', '48'),
('43', '1', '11', '1', '2013-08-03 02:58:39', NULL, '4', '2011-02-15', '49'),
('44', '2', '1', '1', '2013-08-03 02:58:39', NULL, '4', '2011-02-15', '50'),
('45', '12', '1', '1', '2013-08-03 02:58:39', NULL, '4', '2010-11-29', '18'),
('46', '12', '2', '1', '2012-02-22 16:39:54', NULL, '4', '2010-11-29', NULL),
('47', '12', '3', '1', '2013-08-03 02:58:39', NULL, '4', '2010-11-24', '13'),
('48', '12', '4', '1', '2013-08-03 02:58:39', NULL, '4', '2011-01-25', '41'),
('49', '12', '5', '1', '2013-08-03 02:58:39', NULL, '4', '2011-02-25', '52'),
('50', '12', '6', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-25', '61'),
('51', '2', '2', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-31', '68'),
('52', '1', '19', '1', '2012-02-22 15:51:24', NULL, '4', '2010-11-24', NULL),
('53', '1', '19', '1', '2012-02-22 16:05:33', NULL, '4', '2010-11-24', NULL),
('54', '1', '20', '1', '2013-08-03 02:58:39', NULL, '4', '2010-11-24', '14'),
('55', '1', '21', '1', '2012-02-22 16:23:34', NULL, '4', '2010-11-30', NULL),
('56', '1', '22', '1', '2013-08-03 02:58:39', NULL, '4', '2010-11-30', '23'),
('57', '1', '23', '1', '2013-08-03 02:58:39', NULL, '4', '2010-11-30', '24'),
('58', '1', '24', '1', '2013-08-03 02:58:39', NULL, '4', '2010-12-23', '29'),
('59', '1', '25', '1', '2013-08-03 02:58:39', NULL, '4', '2010-12-23', '30'),
('60', '1', '26', '1', '2013-08-03 02:58:39', NULL, '4', '2010-12-30', '34'),
('61', '1', '27', '1', '2013-08-03 02:58:39', NULL, '4', '2011-01-03', '38'),
('62', '1', '28', '1', '2013-08-03 02:58:39', NULL, '4', '2011-01-27', '42'),
('63', '1', '29', '1', '2013-08-03 02:58:39', NULL, '4', '2011-01-27', '43'),
('64', '1', '30', '1', '2013-08-03 02:58:39', NULL, '4', '2011-02-03', '46'),
('65', '1', '31', '1', '2013-08-03 02:58:39', NULL, '4', '2011-02-28', '53'),
('66', '1', '32', '1', '2013-08-03 02:58:39', NULL, '4', '2011-02-28', '54'),
('67', '1', '33', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-01', '58'),
('68', '1', '34', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-25', '62'),
('69', '1', '35', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-25', '63'),
('70', '1', '19', '1', '2013-08-03 02:58:39', NULL, '4', '2010-11-24', '15'),
('71', '1', '36', '1', '2012-02-29 16:47:50', NULL, '4', '2010-11-24', NULL),
('72', '1', '21', '1', '2013-08-03 02:58:39', NULL, '4', '2010-11-30', '25'),
('73', '0', '2', '1', '2013-08-03 02:58:39', NULL, '4', '2010-08-31', '9'),
('74', '0', '3', '1', '2013-08-03 02:58:39', NULL, '4', '2010-09-30', '10'),
('75', '0', '4', '1', '2013-08-03 02:58:39', NULL, '4', '2010-09-30', '11'),
('76', '0', '5', '1', '2013-08-03 02:58:39', NULL, '4', '2011-01-04', '39'),
('77', '12', '2', '1', '2013-08-03 02:58:39', 'Voided.\n', '4', '2010-11-29', '19'),
('78', '12', '7', '1', '2013-08-03 02:58:39', NULL, '4', '2010-11-29', '20'),
('79', '2', '3', '1', '2012-02-22 17:12:12', NULL, '4', '2010-11-29', NULL),
('80', '2', '4', '1', '2012-02-22 17:13:06', NULL, '4', '2010-11-29', NULL),
('81', '12', '8', '1', '2013-08-03 02:58:39', NULL, '4', '2010-11-30', '26'),
('82', '2', '3', '1', '2013-08-03 02:58:39', NULL, '4', '2010-11-29', '21'),
('83', '2', '4', '1', '2013-08-03 02:58:39', NULL, '4', '2010-11-29', '22'),
('84', '1', '37', '1', '2013-08-03 02:58:39', NULL, '4', '2010-05-17', '1'),
('85', '1', '38', '1', '2013-08-03 02:58:39', NULL, '4', '2010-08-06', '8'),
('86', '1', '39', '1', '2013-08-03 02:58:39', NULL, '4', '2010-07-21', '5'),
('87', '1', '40', '1', '2013-08-03 02:58:39', NULL, '4', '2010-07-21', '6'),
('88', '1', '41', '1', '2013-08-03 02:58:39', NULL, '4', '2010-07-21', '7'),
('89', '1', '42', '1', '2013-08-03 02:58:39', NULL, '4', '2010-11-28', '17'),
('90', '1', '43', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-25', '64'),
('91', '0', '6', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-31', '69'),
('92', '1', '44', '1', '2012-02-24 18:14:01', NULL, '4', '2010-06-01', NULL),
('93', '1', '45', '1', '2012-02-24 18:17:55', NULL, '4', '2010-06-01', NULL),
('94', '1', '44', '1', '2013-08-03 02:58:39', 'Voided.\n', '4', '2011-03-31', '70'),
('95', '2', '5', '1', '2013-08-03 02:58:39', NULL, '4', '2010-06-01', '2'),
('96', '2', '6', '1', '2013-08-03 02:58:39', NULL, '4', '2010-06-01', '3'),
('97', '1', '45', '1', '2013-08-03 02:58:39', 'Voided.\n', '4', '2011-03-31', '71'),
('98', '0', '7', '1', '2012-02-29 16:25:40', NULL, '4', '2011-03-31', NULL),
('99', '1', '1', '1', '2013-08-03 02:58:39', NULL, '4', '2010-12-15', '28'),
('100', '1', '3', '1', '2013-08-03 02:58:39', NULL, '4', '2010-12-30', '35'),
('101', '1', '6', '1', '2013-08-03 02:58:39', NULL, '4', '2010-12-30', '36'),
('102', '1', '7', '1', '2013-08-03 02:58:39', NULL, '4', '2010-12-30', '37'),
('103', '1', '46', '1', '2014-07-31 06:35:16', NULL, '1', '2012-02-29', '109'),
('104', '1', '47', '1', '2014-07-31 06:35:16', NULL, '1', '2012-02-29', '110'),
('105', '1', '48', '1', '2013-08-03 02:58:39', NULL, '4', '2010-07-02', '4'),
('106', '0', '7', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-31', '72'),
('107', '0', '8', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-31', '73'),
('108', '0', '9', '1', '2013-08-03 02:58:39', NULL, '4', '2011-03-31', '74'),
('109', '1', '36', '1', '2013-08-03 02:58:39', NULL, '4', '2010-11-24', '16'),
('110', '1', '49', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-09', '111'),
('111', '1', '50', '1', '2013-08-04 00:57:29', NULL, '1', '2012-03-09', NULL),
('112', '20', '1', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-20', '113'),
('113', '20', '2', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-20', '114'),
('114', '20', '3', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-20', '115'),
('115', '20', '4', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-20', '116'),
('116', '20', '5', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-20', '117'),
('117', '20', '6', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-20', '118'),
('118', '20', '7', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-20', '119'),
('119', '20', '8', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-20', '120'),
('120', '20', '9', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-20', '121'),
('121', '22', '1', '1', '2012-03-20 19:22:43', NULL, '1', '2012-03-20', NULL),
('122', '22', '1', '1', '2014-07-31 06:35:16', 'Voided.\n', '1', '2012-03-20', '122'),
('123', '22', '2', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-20', '123'),
('124', '1', '51', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-26', '127'),
('125', '1', '52', '1', '2013-08-04 00:58:51', 'Edited', '1', '2012-03-27', NULL),
('126', '1', '53', '1', '2012-03-30 12:07:09', NULL, '1', '2012-03-30', NULL),
('127', '1', '53', '1', '2013-03-06 15:15:46', NULL, '1', '2012-03-30', NULL),
('128', '1', '54', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-31', '136'),
('129', '1', '55', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-31', '137'),
('130', '1', '56', '1', '2012-05-04 13:59:59', NULL, '1', '2012-03-31', NULL),
('131', '1', '57', '1', '2012-05-04 14:00:38', NULL, '1', '2012-03-31', NULL),
('132', '1', '58', '1', '2012-05-04 13:46:38', NULL, '1', '2012-03-31', NULL),
('133', '1', '58', '1', '2015-03-02 04:58:24', NULL, '2', '2012-05-03', '5'),
('134', '1', '56', '1', '2015-03-02 04:58:24', NULL, '2', '2012-04-30', '3'),
('135', '1', '57', '1', '2015-03-02 04:58:24', NULL, '2', '2012-04-30', '4'),
('136', '1', '59', '1', '2015-03-02 04:58:24', NULL, '2', '2012-05-16', '6'),
('137', '1', '60', '1', '2015-03-02 04:58:24', NULL, '2', '2012-05-28', '8'),
('138', '1', '61', '1', '2015-03-02 04:58:24', NULL, '2', '2012-05-28', '9'),
('139', '1', '62', '1', '2015-03-02 04:58:24', 'Edited', '2', '2012-04-27', '2'),
('140', '1', '63', '1', '2015-03-02 04:58:24', NULL, '2', '2012-05-25', '7'),
('141', '1', '64', '1', '2015-03-02 04:58:24', NULL, '2', '2012-06-15', '10'),
('142', '1', '65', '1', '2015-03-02 04:58:24', NULL, '2', '2012-06-29', '11'),
('143', '1', '66', '1', '2015-03-02 04:58:24', NULL, '2', '2012-06-29', '12'),
('144', '1', '67', '1', '2015-03-02 04:58:24', NULL, '2', '2012-07-12', '13'),
('145', '1', '68', '1', '2015-03-02 04:58:24', NULL, '2', '2012-07-23', '14'),
('146', '1', '69', '1', '2015-03-02 04:58:24', NULL, '2', '2012-07-26', '15'),
('147', '1', '70', '1', '2015-03-02 04:58:24', NULL, '2', '2012-07-31', '16'),
('148', '1', '71', '1', '2012-07-31 16:00:04', NULL, '2', '2012-07-31', NULL),
('149', '1', '71', '1', '2012-08-07 15:20:32', NULL, '2', '2012-07-31', NULL),
('150', '1', '72', '1', '2015-03-02 04:58:24', NULL, '2', '2012-08-07', '17'),
('151', '1', '73', '1', '2014-02-05 05:16:01', 'Edited', '2', '2012-08-28', NULL),
('152', '1', '73', '1', '2015-03-02 04:58:24', 'Edited', '2', '2012-08-28', '19'),
('153', '1', '71', '1', '2015-03-02 04:58:24', 'Voided.\n', '2', '2012-08-07', '18'),
('154', '1', '74', '1', '2015-02-24 05:38:17', NULL, '2', '2012-08-22', NULL),
('155', '1', '75', '1', '2015-03-02 04:58:24', NULL, '2', '2012-08-30', '20'),
('156', '1', '76', '1', '2015-03-02 04:58:24', NULL, '2', '2012-08-30', '21'),
('157', '1', '77', '1', '2015-03-02 04:58:24', 'Edited', '2', '2012-08-30', '22'),
('158', '1', '78', '1', '2012-09-28 14:16:19', NULL, '2', '2012-09-28', NULL),
('159', '1', '78', '1', '2014-02-06 02:21:36', NULL, '2', '2012-09-28', NULL),
('160', '1', '79', '1', '2015-03-02 04:58:24', NULL, '2', '2012-10-01', '23'),
('161', '1', '80', '1', '2015-03-02 04:58:24', NULL, '2', '2012-10-01', '24'),
('162', '1', '81', '1', '2015-03-02 04:58:24', NULL, '2', '2012-10-04', '25'),
('163', '1', '82', '1', '2015-03-02 04:58:24', 'Edited', '2', '2012-10-25', '28'),
('164', '1', '83', '1', '2015-03-02 04:58:24', NULL, '2', '2012-10-05', '26'),
('165', '1', '84', '1', '2015-03-02 04:58:24', NULL, '2', '2012-10-08', '27'),
('166', '1', '85', '1', '2015-03-02 04:58:24', NULL, '2', '2012-10-31', '29'),
('167', '1', '86', '1', '2015-03-02 04:58:24', NULL, '2', '2012-10-31', '30'),
('168', '1', '87', '1', '2015-03-02 04:58:24', NULL, '2', '2012-10-31', '31'),
('169', '1', '88', '1', '2015-03-02 04:58:24', NULL, '2', '2012-11-02', '32'),
('170', '1', '89', '1', '2015-03-02 04:58:24', NULL, '2', '2012-11-30', '33'),
('171', '1', '90', '1', '2015-03-02 04:58:24', NULL, '2', '2012-11-30', '34'),
('172', '1', '91', '1', '2015-03-02 04:58:24', NULL, '2', '2012-12-05', '35'),
('173', '1', '92', '1', '2015-03-02 04:58:24', NULL, '2', '2012-12-10', '36'),
('174', '1', '93', '1', '2015-03-02 04:58:24', NULL, '2', '2012-12-10', '37'),
('175', '1', '94', '1', '2015-03-02 04:58:24', NULL, '2', '2012-12-18', '38'),
('176', '1', '95', '1', '2015-03-02 04:58:24', NULL, '2', '2012-12-20', '39'),
('177', '2', '7', '1', '2015-03-02 04:58:24', NULL, '2', '2013-01-07', '40'),
('178', '1', '96', '1', '2013-04-19 15:35:42', NULL, '2', '2013-01-07', NULL),
('179', '1', '97', '1', '2015-03-02 04:58:24', NULL, '2', '2013-01-07', '41'),
('180', '1', '98', '1', '2015-03-02 04:58:24', NULL, '2', '2013-01-07', '42'),
('181', '1', '99', '1', '2015-03-02 04:58:24', NULL, '2', '2013-01-10', '43'),
('182', '1', '100', '1', '2013-01-15 13:33:43', NULL, '2', '2013-01-15', NULL),
('183', '1', '100', '1', '2013-01-15 13:34:57', NULL, '2', '2013-01-15', NULL),
('184', '1', '100', '1', '2015-03-02 04:58:24', NULL, '2', '2013-01-15', '44'),
('185', '1', '101', '1', '2013-01-15 14:23:40', NULL, '2', '2013-01-15', NULL),
('186', '1', '101', '1', '2015-03-02 04:58:24', NULL, '2', '2013-01-15', '45'),
('187', '1', '102', '1', '2015-03-02 04:58:24', NULL, '2', '2013-01-16', '46'),
('188', '1', '103', '1', '2015-03-02 04:58:24', NULL, '2', '2013-01-16', '47'),
('189', '1', '104', '1', '2015-03-02 04:58:24', NULL, '2', '2013-01-30', '48'),
('190', '1', '105', '1', '2015-03-02 04:58:24', NULL, '2', '2013-01-31', '49'),
('191', '1', '106', '1', '2015-03-02 04:58:24', NULL, '2', '2013-01-31', '50'),
('192', '1', '107', '1', '2015-03-02 04:58:24', 'Edited', '2', '2013-02-18', '51'),
('193', '1', '108', '1', '2015-03-02 04:58:24', NULL, '2', '2013-02-26', '52'),
('194', '1', '109', '1', '2015-03-02 04:58:24', NULL, '2', '2013-02-26', '53'),
('195', '1', '110', '1', '2015-03-02 04:58:24', NULL, '2', '2013-03-06', '54'),
('196', '1', '53', '1', '2013-03-06 15:22:55', NULL, '2', '2012-04-01', NULL),
('197', '1', '53', '1', '2015-03-02 04:58:24', NULL, '2', '2012-04-01', '1'),
('198', '1', '111', '1', '2015-03-02 04:58:24', NULL, '2', '2013-03-08', '55'),
('199', '1', '112', '1', '2015-03-02 04:58:24', NULL, '2', '2013-03-08', '56'),
('200', '1', '113', '1', '2015-03-02 04:58:24', NULL, '2', '2013-03-08', '57'),
('201', '1', '114', '1', '2015-03-02 04:58:24', NULL, '2', '2013-03-08', '58'),
('202', '1', '115', '1', '2015-03-02 04:58:24', NULL, '2', '2013-03-08', '59'),
('203', '1', '116', '1', '2015-03-02 04:58:24', NULL, '2', '2013-03-08', '60'),
('204', '1', '117', '1', '2015-03-02 04:58:24', NULL, '2', '2013-03-08', '61'),
('205', '1', '118', '1', '2015-03-02 04:58:24', NULL, '2', '2013-03-28', '62'),
('206', '1', '119', '1', '2015-03-02 04:58:24', NULL, '2', '2013-03-28', '63'),
('207', '1', '120', '1', '2015-03-02 04:58:24', NULL, '2', '2013-03-28', '64'),
('208', '1', '121', '1', '2015-03-02 04:58:24', NULL, '2', '2013-03-31', '65'),
('209', '1', '122', '1', '2015-02-24 01:33:45', NULL, '5', '2013-04-04', NULL),
('210', '1', '123', '1', '2013-04-09 16:17:43', NULL, '5', '2013-04-09', NULL),
('211', '1', '124', '1', '2013-04-09 16:18:29', NULL, '5', '2013-04-04', NULL),
('212', '1', '125', '1', '2013-04-09 16:18:48', NULL, '5', '2013-04-04', NULL),
('213', '1', '126', '1', '2015-02-25 06:30:58', 'Edited', '5', '2013-04-09', NULL),
('214', '1', '127', '1', '2016-01-19 04:37:20', NULL, '5', '2013-04-09', '4'),
('215', '1', '123', '1', '2016-01-19 04:37:20', NULL, '5', '2013-04-09', '5'),
('216', '1', '124', '1', '2016-01-19 04:37:20', NULL, '5', '2013-04-04', '2'),
('217', '1', '125', '1', '2016-01-19 04:37:20', NULL, '5', '2013-04-04', '3'),
('218', '1', '96', '1', '2013-04-29 15:23:47', NULL, '5', '2013-01-07', NULL),
('219', '1', '96', '1', '2016-01-19 04:37:20', NULL, '5', '2013-04-29', '6'),
('220', '1', '128', '1', '2016-01-19 04:37:20', NULL, '5', '2013-04-29', '7'),
('221', '1', '129', '1', '2016-01-19 04:37:20', NULL, '5', '2013-04-29', '8'),
('222', '1', '130', '1', '2013-04-29 18:10:11', NULL, '5', '2013-04-29', NULL),
('223', '1', '130', '1', '2013-04-29 18:10:43', NULL, '5', '2013-04-29', NULL),
('224', '1', '130', '1', '2013-04-29 18:12:02', NULL, '5', '2013-04-29', NULL),
('225', '1', '130', '1', '2016-01-19 04:37:20', NULL, '5', '2013-04-29', '9'),
('226', '1', '131', '1', '2016-01-19 04:37:20', NULL, '5', '2013-04-30', '10'),
('227', '1', '132', '1', '2016-01-19 04:37:20', NULL, '5', '2013-04-30', '11'),
('228', '1', '133', '1', '2016-01-19 04:37:20', NULL, '5', '2013-05-02', '12'),
('229', '1', '134', '1', '2016-01-19 04:37:20', NULL, '5', '2013-05-13', '13'),
('230', '1', '135', '1', '2016-01-19 04:37:20', NULL, '5', '2013-05-28', '16'),
('231', '1', '136', '1', '2016-01-19 04:37:20', NULL, '5', '2013-05-28', '17'),
('232', '1', '137', '1', '2016-01-19 04:37:20', NULL, '5', '2013-05-28', '18'),
('233', '1', '138', '1', '2016-01-19 04:37:20', NULL, '5', '2013-05-28', '19'),
('234', '1', '139', '1', '2016-01-19 04:37:20', NULL, '5', '2013-06-03', '20'),
('235', '1', '140', '1', '2016-01-19 04:37:20', NULL, '5', '2013-06-04', '21'),
('236', '1', '141', '1', '2016-01-19 04:37:20', NULL, '5', '2013-06-04', '22'),
('237', '1', '142', '1', '2016-01-19 04:37:20', NULL, '5', '2013-06-19', '23'),
('238', '1', '143', '1', '2016-01-19 04:37:20', NULL, '5', '2013-06-21', '24'),
('239', '1', '144', '1', '2016-01-19 04:37:20', NULL, '5', '2013-06-21', '25'),
('240', '1', '145', '1', '2016-01-19 04:37:20', 'Edited', '5', '2013-07-03', '26'),
('241', '1', '146', '1', '2016-01-19 04:37:20', NULL, '5', '2013-07-03', '27'),
('242', '1', '147', '1', '2016-01-19 04:37:20', NULL, '5', '2013-07-03', '28'),
('243', '1', '148', '1', '2016-01-19 04:37:20', 'Edited', '5', '2013-07-03', '29'),
('244', '1', '149', '1', '2016-01-19 04:37:20', NULL, '5', '2013-07-03', '30'),
('245', '1', '150', '1', '2016-01-19 04:37:20', NULL, '5', '2013-07-10', '31'),
('246', '1', '151', '1', '2016-01-19 04:37:20', NULL, '5', '2013-07-12', '32'),
('247', '1', '152', '1', '2016-01-19 04:37:20', NULL, '5', '2013-07-12', '33'),
('248', '1', '153', '1', '2016-01-19 04:37:20', NULL, '5', '2013-07-25', '34'),
('249', '1', '154', '1', '2016-01-19 04:37:20', NULL, '5', '2013-07-25', '35'),
('250', '1', '155', '1', '2016-01-19 04:37:20', NULL, '5', '2013-07-30', '36'),
('251', '1', '156', '1', '2016-01-19 04:37:20', NULL, '5', '2013-07-31', '37'),
('252', '1', '157', '1', '2016-01-19 04:37:20', NULL, '5', '2013-08-02', '38'),
('253', '1', '158', '1', '2016-01-19 04:37:20', NULL, '5', '2013-08-02', '39'),
('254', '1', '159', '1', '2016-01-19 04:37:20', NULL, '5', '2013-08-02', '40'),
('255', '1', '160', '1', '2016-01-19 04:37:20', NULL, '5', '2013-08-02', '41'),
('256', '0', '10', '1', '2013-08-03 02:58:39', NULL, '5', '2011-03-31', '1'),
('257', '1', '161', '1', '2014-07-31 06:35:15', NULL, '1', '2011-04-07', '3'),
('258', '1', '162', '1', '2014-07-31 06:35:15', NULL, '1', '2011-04-07', '4'),
('259', '1', '163', '1', '2014-07-31 06:35:15', NULL, '1', '2011-04-07', '5'),
('260', '1', '164', '1', '2014-07-31 06:35:15', NULL, '1', '2011-04-07', '6'),
('261', '2', '8', '1', '2014-07-31 06:35:15', NULL, '1', '2011-04-07', '7'),
('262', '2', '9', '1', '2014-07-31 06:35:15', NULL, '1', '2011-05-16', '10'),
('263', '2', '10', '1', '2014-07-31 06:35:15', NULL, '1', '2011-05-24', '16'),
('264', '2', '11', '1', '2014-07-31 06:35:15', NULL, '1', '2011-06-01', '18'),
('265', '2', '12', '1', '2013-08-07 08:02:13', NULL, '1', '2011-06-27', NULL),
('266', '2', '13', '1', '2014-07-31 06:35:15', NULL, '1', '2011-06-29', '28'),
('267', '2', '14', '1', '2014-07-31 06:35:15', NULL, '1', '2011-07-05', '30'),
('268', '2', '15', '1', '2014-07-31 06:35:15', NULL, '1', '2011-07-26', '35'),
('269', '2', '16', '1', '2013-08-03 03:53:44', NULL, '1', '2011-07-28', NULL),
('270', '1', '165', '1', '2014-07-31 06:35:15', NULL, '1', '2011-05-23', '12'),
('271', '1', '166', '1', '2014-07-31 06:35:15', NULL, '1', '2011-05-23', '13'),
('272', '1', '167', '1', '2014-07-31 06:35:15', NULL, '1', '2011-05-23', '14'),
('273', '1', '168', '1', '2014-07-31 06:35:15', NULL, '1', '2011-05-23', '15'),
('274', '1', '169', '1', '2014-07-31 06:35:15', NULL, '1', '2011-06-27', '23'),
('275', '1', '170', '1', '2014-07-31 06:35:15', NULL, '1', '2011-06-27', '24'),
('276', '1', '171', '1', '2014-07-31 06:35:15', NULL, '1', '2011-06-27', '25'),
('277', '1', '172', '1', '2014-07-31 06:35:15', NULL, '1', '2011-06-03', '19'),
('278', '1', '173', '1', '2014-07-31 06:35:15', NULL, '1', '2011-06-03', '20'),
('279', '1', '174', '1', '2014-07-31 06:35:15', NULL, '1', '2011-06-03', '21'),
('280', '1', '175', '1', '2014-07-31 06:35:15', NULL, '1', '2011-06-30', '29'),
('281', '1', '176', '1', '2014-07-31 06:35:15', NULL, '1', '2011-07-05', '31'),
('282', '1', '177', '1', '2014-07-31 06:35:15', NULL, '1', '2011-07-05', '32'),
('283', '1', '178', '1', '2014-07-31 06:35:15', NULL, '1', '2011-07-27', '36'),
('284', '1', '179', '1', '2014-07-31 06:35:16', NULL, '1', '2011-07-27', '37'),
('285', '1', '180', '1', '2014-07-31 06:35:16', NULL, '1', '2011-08-01', '39'),
('286', '1', '181', '1', '2014-07-31 06:35:16', NULL, '1', '2011-08-01', '40'),
('287', '1', '182', '1', '2014-07-31 06:35:16', NULL, '1', '2011-08-04', '43'),
('288', '1', '183', '1', '2014-07-31 06:35:16', NULL, '1', '2011-08-04', '44'),
('289', '1', '184', '1', '2014-07-31 06:35:16', NULL, '1', '2011-08-28', '48'),
('290', '1', '185', '1', '2014-07-31 06:35:16', NULL, '1', '2011-08-28', '49'),
('291', '2', '16', '1', '2016-01-19 04:37:20', 'Voided.\n', '1', '2013-08-03', '165'),
('292', '2', '17', '1', '2014-07-31 06:35:16', NULL, '1', '2011-08-01', '41'),
('293', '2', '18', '1', '2014-07-31 06:35:16', NULL, '1', '2011-08-01', '42'),
('294', '2', '19', '1', '2014-07-31 06:35:16', NULL, '1', '2011-08-29', '51'),
('295', '1', '186', '1', '2014-07-31 06:35:16', NULL, '1', '2011-09-05', '52'),
('296', '1', '187', '1', '2014-07-31 06:35:16', NULL, '1', '2011-09-05', '53'),
('297', '1', '188', '1', '2014-07-31 06:35:16', NULL, '1', '2011-09-05', '54'),
('298', '1', '189', '1', '2014-07-31 06:35:16', NULL, '1', '2011-09-05', '55'),
('299', '1', '190', '1', '2014-07-31 06:35:16', NULL, '1', '2011-09-29', '60'),
('300', '2', '20', '1', '2014-07-31 06:35:16', NULL, '1', '2011-09-05', '56'),
('301', '2', '21', '1', '2014-07-31 06:35:16', NULL, '1', '2011-09-28', '58'),
('302', '1', '191', '1', '2014-07-31 06:35:16', NULL, '1', '2011-10-03', '61'),
('303', '1', '192', '1', '2014-07-31 06:35:16', NULL, '1', '2011-10-03', '62'),
('304', '1', '193', '1', '2014-07-31 06:35:16', 'Edited', '1', '2011-10-27', '64'),
('305', '2', '22', '1', '2014-07-31 06:35:16', NULL, '1', '2011-10-27', '65'),
('306', '2', '23', '1', '2014-07-31 06:35:16', NULL, '1', '2011-11-09', '67'),
('307', '2', '24', '1', '2014-07-31 06:35:16', NULL, '1', '2011-11-09', '68'),
('308', '2', '25', '1', '2014-07-31 06:35:16', NULL, '1', '2011-11-28', '74'),
('309', '1', '194', '1', '2014-07-31 06:35:16', NULL, '1', '2011-11-10', '69'),
('310', '1', '195', '1', '2014-07-31 06:35:16', NULL, '1', '2011-11-10', '70'),
('311', '1', '196', '1', '2014-07-31 06:35:16', NULL, '1', '2011-11-10', '71'),
('312', '1', '197', '1', '2014-07-31 06:35:16', NULL, '1', '2011-11-28', '75'),
('313', '1', '198', '1', '2014-07-31 06:35:16', NULL, '1', '2011-11-28', '76'),
('314', '1', '199', '1', '2014-07-31 06:35:16', NULL, '1', '2011-11-28', '77'),
('315', '1', '200', '1', '2014-07-31 06:35:16', NULL, '1', '2011-12-02', '78'),
('316', '1', '201', '1', '2014-07-31 06:35:16', NULL, '1', '2011-12-02', '79'),
('317', '1', '202', '1', '2014-07-31 06:35:16', NULL, '1', '2011-12-19', '80'),
('318', '1', '203', '1', '2014-07-31 06:35:16', NULL, '1', '2011-12-19', '81'),
('319', '1', '204', '1', '2014-07-31 06:35:16', NULL, '1', '2011-12-22', '83'),
('320', '1', '205', '1', '2014-07-31 06:35:16', NULL, '1', '2011-12-22', '84'),
('321', '1', '206', '1', '2014-07-31 06:35:16', NULL, '1', '2011-12-22', '85'),
('322', '2', '26', '1', '2014-07-31 06:35:16', NULL, '1', '2011-12-22', '86'),
('323', '2', '27', '1', '2014-07-31 06:35:16', NULL, '1', '2011-12-22', '87'),
('324', '2', '28', '1', '2014-07-31 06:35:16', NULL, '1', '2012-01-04', '90'),
('325', '2', '29', '1', '2014-07-31 06:35:16', NULL, '1', '2012-01-24', '92'),
('326', '2', '30', '1', '2014-07-31 06:35:16', NULL, '1', '2012-01-31', '100'),
('327', '1', '207', '1', '2014-07-31 06:35:16', NULL, '1', '2012-01-31', '101'),
('328', '1', '208', '1', '2014-07-31 06:35:16', NULL, '1', '2012-01-31', '102'),
('329', '1', '209', '1', '2014-07-31 06:35:16', NULL, '1', '2012-01-03', '89'),
('330', '1', '210', '1', '2014-07-31 06:35:16', NULL, '1', '2012-01-27', '94'),
('331', '1', '211', '1', '2014-07-31 06:35:16', NULL, '1', '2012-01-27', '95'),
('332', '1', '212', '1', '2014-07-31 06:35:16', NULL, '1', '2012-01-27', '96'),
('333', '1', '213', '1', '2014-07-31 06:35:16', NULL, '1', '2012-01-27', '97'),
('334', '1', '214', '1', '2014-07-31 06:35:16', NULL, '1', '2012-01-27', '98'),
('335', '2', '31', '1', '2014-07-31 06:35:16', NULL, '1', '2012-02-27', '107'),
('336', '2', '32', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-20', '124'),
('337', '2', '33', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-20', '125'),
('338', '1', '215', '1', '2014-07-31 06:35:16', NULL, '1', '2012-02-26', '105'),
('339', '1', '216', '1', '2014-07-31 06:35:16', NULL, '1', '2012-02-26', '106'),
('340', '1', '217', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-27', '128'),
('341', '1', '218', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-27', '129'),
('342', '1', '219', '1', '2014-07-31 06:35:16', NULL, '1', '2012-02-15', '103'),
('343', '1', '220', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-09', '112'),
('344', '1', '50', '1', '2016-01-19 04:37:20', 'Voided.\nDocument reentered.', '1', '2013-08-04', '166'),
('345', '1', '52', '1', '2016-01-19 04:37:20', 'Voided.\n', '1', '2013-08-04', '167'),
('346', '30', '6', '1', '2013-08-07 02:53:50', NULL, '1', '2011-04-27', '0'),
('347', '13', '6', '1', '2013-08-07 02:53:50', NULL, '1', '2011-04-27', '0'),
('348', '10', '6', '1', '2014-07-31 06:35:15', NULL, '1', '2011-04-27', '8'),
('349', '30', '7', '1', '2013-08-07 03:00:23', NULL, '1', '2011-05-20', '0'),
('350', '13', '7', '1', '2013-08-07 03:00:23', NULL, '1', '2011-05-20', '0'),
('351', '10', '7', '1', '2014-07-31 06:35:15', NULL, '1', '2011-05-20', '11'),
('352', '30', '8', '1', '2013-08-07 03:01:34', NULL, '1', '2011-06-20', '0'),
('353', '13', '8', '1', '2013-08-07 03:01:34', NULL, '1', '2011-06-20', '0'),
('354', '10', '8', '1', '2014-07-31 06:35:15', NULL, '1', '2011-06-20', '22'),
('355', '30', '9', '1', '2013-08-07 03:03:03', NULL, '1', '2011-07-21', '0'),
('356', '13', '9', '1', '2013-08-07 03:03:03', NULL, '1', '2011-07-21', '0'),
('357', '10', '9', '1', '2014-07-31 06:35:15', NULL, '1', '2011-07-21', '34'),
('358', '30', '10', '1', '2013-08-07 03:06:42', NULL, '1', '2011-08-22', '0'),
('359', '13', '10', '1', '2013-08-07 03:06:42', NULL, '1', '2011-08-22', '0'),
('360', '10', '10', '1', '2014-07-31 06:35:16', NULL, '1', '2011-08-22', '45'),
('361', '30', '11', '1', '2013-08-07 03:07:37', NULL, '1', '2011-09-21', '0'),
('362', '13', '11', '1', '2013-08-07 03:07:37', NULL, '1', '2011-09-21', '0'),
('363', '10', '11', '1', '2014-07-31 06:35:16', NULL, '1', '2011-09-21', '57'),
('364', '30', '12', '1', '2013-08-07 03:08:30', NULL, '1', '2011-10-21', '0'),
('365', '13', '12', '1', '2013-08-07 03:08:30', NULL, '1', '2011-10-21', '0'),
('366', '10', '12', '1', '2014-07-31 06:35:16', NULL, '1', '2011-10-21', '63'),
('367', '30', '13', '1', '2013-08-07 03:09:31', NULL, '1', '2011-11-21', '0'),
('368', '13', '13', '1', '2013-08-07 03:09:31', NULL, '1', '2011-11-21', '0'),
('369', '10', '13', '1', '2014-07-31 06:35:16', NULL, '1', '2011-11-21', '72'),
('370', '30', '14', '1', '2013-08-07 03:24:24', NULL, '1', '2011-12-20', '0'),
('371', '13', '14', '1', '2013-08-07 03:24:24', NULL, '1', '2011-12-20', '0'),
('372', '10', '14', '1', '2014-07-31 06:35:16', NULL, '1', '2011-12-20', '82'),
('373', '30', '15', '1', '2013-08-07 03:25:16', NULL, '1', '2012-01-23', '0'),
('374', '13', '15', '1', '2013-08-07 03:25:16', NULL, '1', '2012-01-23', '0'),
('375', '10', '15', '1', '2014-07-31 06:35:16', NULL, '1', '2012-01-23', '91'),
('376', '30', '16', '1', '2013-08-07 03:26:02', NULL, '1', '2012-02-20', '0'),
('377', '13', '16', '1', '2013-08-07 03:26:02', NULL, '1', '2012-02-20', '0'),
('378', '10', '16', '1', '2014-07-31 06:35:16', NULL, '1', '2012-02-20', '104'),
('379', '30', '17', '1', '2013-08-07 03:28:09', NULL, '1', '2012-03-20', '0'),
('380', '13', '17', '1', '2013-08-07 03:28:09', NULL, '1', '2012-03-20', '0'),
('381', '10', '17', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-20', '126'),
('382', '12', '9', '1', '2014-07-31 06:35:15', NULL, '1', '2011-04-30', '9'),
('383', '12', '10', '1', '2014-07-31 06:35:15', NULL, '1', '2011-05-27', '17'),
('384', '12', '11', '1', '2014-07-31 06:35:15', NULL, '1', '2011-06-28', '27'),
('385', '12', '12', '1', '2014-07-31 06:35:16', NULL, '1', '2011-07-28', '38'),
('386', '12', '13', '1', '2014-07-31 06:35:16', NULL, '1', '2011-08-28', '50'),
('387', '12', '14', '1', '2014-07-31 06:35:16', NULL, '1', '2011-09-28', '59'),
('388', '12', '15', '1', '2014-07-31 06:35:16', NULL, '1', '2011-10-27', '66'),
('389', '12', '16', '1', '2014-07-31 06:35:16', NULL, '1', '2011-11-27', '73'),
('390', '12', '17', '1', '2014-07-31 06:35:16', NULL, '1', '2011-12-27', '88'),
('391', '12', '18', '1', '2014-07-31 06:35:16', NULL, '1', '2012-01-27', '99'),
('392', '12', '19', '1', '2014-07-31 06:35:16', NULL, '1', '2012-02-27', '108'),
('393', '12', '20', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-29', '130'),
('394', '2', '34', '1', '2014-07-31 06:35:15', NULL, '1', '2011-06-27', '26'),
('395', '2', '12', '1', '2016-01-19 04:37:20', 'Voided.\nDocument reentered.', '1', '2013-08-07', '168'),
('396', '1', '221', '1', '2014-07-31 06:35:15', NULL, '1', '2011-07-11', '33'),
('397', '1', '222', '1', '2014-07-31 06:35:16', NULL, '1', '2011-08-23', '46'),
('398', '1', '223', '1', '2014-07-31 06:35:16', NULL, '1', '2011-08-23', '47'),
('399', '1', '224', '1', '2014-07-31 06:35:16', NULL, '1', '2012-01-25', '93'),
('400', '1', '225', '1', '2016-01-19 04:37:20', 'Edited', '1', '2013-08-22', '169'),
('401', '1', '226', '1', '2016-01-19 04:37:20', NULL, '1', '2013-08-22', '170'),
('402', '1', '227', '1', '2015-03-02 02:04:19', 'Edited', '1', '2013-08-22', NULL),
('403', '0', '12', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-30', '131'),
('404', '0', '13', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-30', '132'),
('405', '0', '14', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-30', '133'),
('406', '0', '15', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-30', '134'),
('407', '1', '228', '1', '2016-01-19 04:37:20', 'Edited', '1', '2013-08-30', '171'),
('408', '1', '229', '1', '2016-01-19 04:37:20', 'Edited', '1', '2013-08-30', '172'),
('409', '1', '230', '1', '2016-01-19 04:37:20', NULL, '1', '2013-09-03', '173'),
('410', '0', '16', '1', '2013-09-03 05:50:21', NULL, '1', '2012-03-31', NULL),
('411', '0', '17', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-31', '138'),
('412', '0', '18', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-31', '139'),
('413', '0', '16', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-31', '140'),
('414', '1', '231', '1', '2013-09-06 01:20:55', 'Edited', '1', '2013-09-06', NULL),
('415', '1', '232', '1', '2016-01-19 04:37:20', NULL, '1', '2013-09-06', '174'),
('416', '1', '231', '1', '2016-01-19 04:37:20', 'Voided.\nDocument reentered.', '1', '2013-09-06', '175'),
('417', '1', '233', '1', '2016-01-19 04:37:20', NULL, '1', '2013-09-20', '176'),
('418', '1', '234', '1', '2016-01-19 04:37:20', NULL, '1', '2013-09-26', '177'),
('419', '1', '235', '1', '2016-01-19 04:37:20', NULL, '1', '2013-09-26', '178'),
('420', '1', '236', '1', '2016-01-19 04:37:20', NULL, '1', '2013-10-03', '179'),
('421', '1', '237', '1', '2015-02-25 06:32:49', 'Edited', '1', '2013-10-08', NULL),
('422', '1', '238', '1', '2016-01-19 04:37:20', NULL, '1', '2013-10-08', '180'),
('423', '1', '239', '1', '2016-01-19 04:37:20', NULL, '1', '2013-10-10', '181'),
('424', '1', '240', '1', '2016-01-19 04:37:20', NULL, '1', '2013-10-10', '182'),
('425', '1', '241', '1', '2016-01-19 04:37:20', NULL, '1', '2013-10-14', '183'),
('426', '1', '242', '1', '2016-01-19 04:37:20', NULL, '1', '2013-10-17', '184'),
('427', '1', '243', '1', '2016-01-19 04:37:20', NULL, '1', '2013-10-30', '185'),
('428', '1', '244', '1', '2016-01-19 04:37:20', NULL, '1', '2013-10-30', '186'),
('429', '1', '245', '1', '2016-01-19 04:37:20', NULL, '1', '2013-10-30', '187'),
('430', '1', '246', '1', '2016-01-19 04:37:20', NULL, '1', '2013-11-01', '188'),
('431', '1', '247', '1', '2016-01-19 04:37:20', NULL, '1', '2013-11-06', '189'),
('432', '1', '248', '1', '2015-02-25 06:35:16', 'Edited', '1', '2013-11-06', NULL),
('433', '1', '249', '1', '2016-01-19 04:37:20', NULL, '1', '2013-11-11', '190'),
('434', '1', '250', '1', '2016-01-19 04:37:20', NULL, '1', '2013-11-11', '191'),
('435', '1', '251', '1', '2016-01-19 04:37:20', NULL, '1', '2013-11-20', '192'),
('436', '1', '252', '1', '2016-01-19 04:37:20', 'Edited', '1', '2013-11-20', '193'),
('437', '1', '253', '1', '2016-01-19 04:37:20', NULL, '1', '2013-11-21', '194'),
('438', '1', '254', '1', '2016-01-19 04:37:20', NULL, '1', '2013-11-28', '195'),
('439', '1', '255', '1', '2016-01-19 04:37:20', NULL, '1', '2013-11-28', '196'),
('440', '1', '256', '1', '2016-01-19 04:37:20', NULL, '1', '2013-11-28', '197'),
('441', '1', '257', '1', '2016-01-19 04:37:20', NULL, '1', '2013-11-28', '198'),
('442', '1', '258', '1', '2016-01-19 04:37:20', NULL, '1', '2013-12-04', '199'),
('443', '1', '259', '1', '2016-01-19 04:37:20', 'Edited', '1', '2013-12-06', '200'),
('444', '1', '260', '1', '2016-01-19 04:37:20', NULL, '1', '2013-12-10', '201'),
('445', '1', '261', '1', '2016-01-19 04:37:20', NULL, '1', '2013-12-31', '202'),
('446', '1', '262', '1', '2016-01-19 04:37:20', NULL, '1', '2013-12-31', '203'),
('447', '1', '263', '1', '2016-01-19 04:37:20', 'Edited', '1', '2014-01-06', '204'),
('448', '1', '264', '1', '2016-01-19 04:37:20', NULL, '1', '2014-01-06', '205'),
('449', '1', '265', '1', '2016-01-19 04:37:20', NULL, '1', '2014-01-06', '206'),
('450', '1', '266', '1', '2016-01-19 04:37:20', 'Edited', '1', '2014-01-06', '207'),
('451', '1', '267', '1', '2016-01-19 04:37:20', NULL, '1', '2014-01-09', '208'),
('452', '1', '268', '1', '2016-01-19 04:37:20', NULL, '1', '2014-01-13', '209'),
('453', '1', '269', '1', '2016-01-19 04:37:20', 'Edited', '1', '2014-01-13', '210'),
('454', '1', '270', '1', '2016-01-19 04:37:20', NULL, '1', '2014-01-13', '211'),
('455', '1', '271', '1', '2016-01-19 04:37:20', NULL, '1', '2014-01-17', '212'),
('456', '1', '272', '1', '2016-01-19 04:37:20', NULL, '1', '2014-01-17', '213'),
('457', '1', '273', '1', '2016-01-19 04:37:20', NULL, '1', '2014-01-17', '214'),
('458', '1', '274', '1', '2016-01-19 04:37:20', NULL, '1', '2014-01-17', '215'),
('459', '1', '275', '1', '2016-01-19 04:37:20', 'Edited', '1', '2014-01-21', '216'),
('460', '1', '276', '1', '2016-01-19 04:37:20', NULL, '1', '2014-01-24', '217'),
('461', '1', '277', '1', '2016-01-19 04:37:20', NULL, '1', '2014-01-24', '218'),
('462', '1', '278', '1', '2016-01-19 04:37:20', NULL, '1', '2014-01-31', '219'),
('463', '1', '279', '1', '2016-01-19 04:37:20', 'Edited', '1', '2014-01-31', '220'),
('464', '1', '280', '1', '2016-01-19 04:37:20', NULL, '1', '2014-02-03', '221'),
('465', '1', '281', '1', '2015-02-23 04:10:19', NULL, '1', '2014-02-03', NULL),
('466', '2', '35', '1', '2014-07-14 06:14:28', NULL, '1', '2011-04-27', NULL),
('467', '1', '282', '1', '2015-03-02 04:58:24', 'Edited', '1', '2012-04-27', '141'),
('468', '2', '36', '1', '2015-03-02 04:58:24', NULL, '1', '2012-05-08', '142'),
('469', '2', '37', '1', '2014-02-04 21:57:36', NULL, '1', '2012-05-25', NULL),
('470', '2', '38', '1', '2015-03-02 04:58:24', NULL, '1', '2012-05-08', '143'),
('471', '2', '39', '1', '2015-03-02 04:58:24', NULL, '1', '2012-05-25', '144'),
('472', '2', '40', '1', '2015-03-02 04:58:24', NULL, '1', '2012-06-15', '145'),
('473', '1', '283', '1', '2014-07-15 02:15:01', 'Edited', '1', '2012-06-27', NULL),
('474', '2', '41', '1', '2014-08-25 06:03:18', NULL, '1', '2012-06-27', NULL),
('475', '2', '42', '1', '2015-03-02 04:58:24', NULL, '1', '2012-06-27', '146'),
('476', '2', '43', '1', '2014-07-15 02:22:06', NULL, '1', '2012-06-27', NULL),
('477', '2', '37', '1', '2016-01-19 04:37:20', 'Voided.\nVoided By Danushka On request Sampath(Duplicate tran', '1', '2014-02-05', '222'),
('478', '2', '44', '1', '2015-03-02 04:58:24', NULL, '1', '2012-07-23', '147'),
('479', '2', '45', '1', '2014-08-25 06:03:52', NULL, '1', '2012-07-27', NULL),
('480', '2', '46', '1', '2015-03-02 04:58:24', NULL, '1', '2012-07-27', '148'),
('481', '2', '47', '1', '2014-02-05 04:38:00', NULL, '1', '2012-06-18', NULL),
('482', '1', '284', '1', '2014-07-15 02:13:23', NULL, '1', '2012-06-18', NULL),
('483', '2', '47', '1', '2016-01-19 04:37:20', 'Voided.\n', '1', '2014-02-05', '223'),
('484', '1', '285', '1', '2014-07-31 06:25:32', 'Edited', '1', '0000-00-00', '1'),
('485', '2', '48', '1', '2015-03-02 04:58:24', NULL, '1', '2012-08-28', '149'),
('486', '2', '49', '1', '2015-03-02 04:58:24', NULL, '1', '2012-08-28', '150'),
('487', '2', '50', '1', '2015-03-02 04:58:24', NULL, '1', '2012-09-04', '151'),
('488', '2', '51', '1', '2014-09-03 08:27:05', NULL, '1', '2012-09-04', NULL),
('489', '2', '52', '1', '2015-03-02 04:58:24', NULL, '1', '2012-09-27', '155'),
('490', '2', '53', '1', '2015-03-02 04:58:24', NULL, '1', '2012-09-05', '152'),
('491', '2', '54', '1', '2015-03-02 04:58:24', NULL, '1', '2012-09-24', '154'),
('492', '1', '286', '1', '2015-03-02 04:58:24', 'Edited', '1', '2012-09-05', '153'),
('493', '2', '55', '1', '2015-03-02 04:58:24', NULL, '1', '2012-10-25', '158'),
('494', '2', '56', '1', '2014-02-05 22:15:08', NULL, '1', '2012-10-04', NULL),
('495', '2', '57', '1', '2015-03-02 04:58:24', NULL, '1', '2012-10-04', '157'),
('496', '1', '287', '1', '2014-02-05 22:17:07', NULL, '1', '2012-10-05', NULL),
('497', '2', '56', '1', '2016-01-19 04:37:20', 'Voided.\n', '1', '2014-02-06', '224'),
('498', '1', '287', '1', '2016-01-19 04:37:20', 'Voided.\n', '1', '2014-02-06', '225'),
('499', '1', '288', '1', '2016-01-19 04:37:20', NULL, '1', '2014-02-06', '226'),
('500', '1', '289', '1', '2015-03-02 04:58:24', NULL, '1', '2012-09-27', '156'),
('501', '1', '78', '1', '2016-01-19 04:37:20', 'Voided.\n', '1', '2014-02-06', '227'),
('502', '2', '58', '1', '2015-03-02 04:58:24', NULL, '1', '2012-11-26', '159'),
('503', '1', '290', '1', '2015-03-02 04:58:24', NULL, '1', '2012-11-26', '160'),
('504', '2', '59', '1', '2015-03-02 04:58:24', NULL, '1', '2012-12-06', '161'),
('505', '1', '291', '1', '2015-03-02 04:58:24', NULL, '1', '2012-12-17', '162'),
('506', '2', '60', '1', '2015-03-02 04:58:24', NULL, '1', '2012-12-18', '163'),
('507', '2', '61', '1', '2015-03-02 04:58:24', NULL, '1', '2012-12-19', '164'),
('508', '1', '292', '1', '2016-01-19 04:37:20', NULL, '1', '2014-02-11', '228'),
('509', '1', '293', '1', '2016-01-19 04:37:20', NULL, '1', '2014-02-21', '229'),
('510', '1', '294', '1', '2016-01-19 04:37:20', NULL, '1', '2014-02-24', '230'),
('511', '1', '295', '1', '2016-01-19 04:37:20', NULL, '1', '2014-02-28', '231'),
('512', '1', '296', '1', '2016-01-19 04:37:20', NULL, '1', '2014-03-03', '232'),
('513', '1', '297', '1', '2016-01-19 04:37:20', NULL, '1', '2014-03-03', '233'),
('514', '1', '298', '1', '2016-01-19 04:37:20', NULL, '1', '2014-03-03', '234'),
('515', '1', '299', '1', '2016-01-19 04:37:20', NULL, '1', '2014-03-03', '235'),
('516', '1', '300', '1', '2016-01-19 04:37:20', NULL, '1', '2014-03-10', '236'),
('517', '1', '301', '1', '2016-01-19 04:37:20', NULL, '1', '2014-03-13', '237'),
('518', '1', '302', '1', '2016-01-19 04:37:20', NULL, '1', '2014-03-19', '238'),
('519', '1', '303', '1', '2016-01-19 04:37:20', 'Edited', '1', '2014-03-20', '239'),
('520', '1', '304', '1', '2016-01-19 04:37:20', NULL, '1', '2014-03-20', '240'),
('521', '1', '305', '1', '2016-01-19 04:37:20', NULL, '1', '2014-03-25', '241'),
('522', '1', '306', '1', '2014-07-31 06:25:32', 'Edited', '1', '0000-00-00', '2'),
('523', '1', '307', '1', '2016-01-19 04:37:20', NULL, '1', '2014-03-25', '242'),
('524', '1', '308', '1', '2016-01-19 04:37:20', NULL, '1', '2014-03-25', '243'),
('525', '1', '309', '1', '2016-01-19 04:37:20', NULL, '1', '2014-03-25', '244'),
('526', '1', '310', '1', '2016-01-19 04:37:20', NULL, '1', '2014-03-27', '245'),
('527', '1', '311', '1', '2016-09-12 03:35:50', NULL, '6', '2014-04-02', '186'),
('528', '1', '312', '1', '2016-09-12 03:35:50', NULL, '6', '2014-04-11', '187'),
('529', '1', '313', '1', '2016-09-12 03:35:50', NULL, '6', '2014-04-16', '188'),
('530', '1', '314', '1', '2016-09-12 03:35:50', NULL, '6', '2014-04-21', '189'),
('531', '1', '315', '1', '2014-04-28 01:27:22', 'Edited', '6', '2014-04-25', NULL),
('532', '1', '316', '1', '2016-09-12 03:35:50', NULL, '6', '2014-04-25', '190'),
('533', '1', '315', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2014-04-28', '191'),
('534', '1', '317', '1', '2016-09-12 03:35:50', NULL, '6', '2014-04-28', '192'),
('535', '1', '318', '1', '2016-01-19 06:09:31', 'Edited', '6', '2014-04-29', NULL),
('536', '1', '319', '1', '2016-01-19 06:09:57', 'Edited', '6', '2014-04-29', NULL),
('537', '1', '320', '1', '2016-09-12 03:35:50', NULL, '6', '2014-04-30', '193'),
('538', '1', '321', '1', '2016-09-12 03:35:50', NULL, '6', '2014-05-02', '194'),
('539', '1', '322', '1', '2016-09-12 03:35:50', NULL, '6', '2014-05-02', '195'),
('540', '1', '323', '1', '2016-09-12 03:35:50', NULL, '6', '2014-05-16', '196'),
('541', '1', '324', '1', '2016-09-12 03:35:50', NULL, '6', '2014-05-16', '197'),
('542', '1', '325', '1', '2016-09-12 03:35:50', NULL, '6', '2014-05-22', '198'),
('543', '1', '326', '1', '2016-09-12 03:35:50', NULL, '6', '2014-05-26', '199'),
('544', '1', '327', '1', '2016-09-12 03:35:50', NULL, '6', '2014-05-28', '200'),
('545', '1', '328', '1', '2016-09-12 03:35:50', NULL, '6', '2014-05-30', '201'),
('546', '1', '329', '1', '2016-09-12 03:35:50', NULL, '6', '2014-05-30', '202'),
('547', '1', '330', '1', '2016-09-12 03:35:50', NULL, '6', '2014-06-03', '203'),
('548', '1', '331', '1', '2016-09-12 03:35:50', NULL, '6', '2014-06-11', '204'),
('549', '1', '332', '1', '2016-09-12 03:35:50', NULL, '6', '2014-06-20', '205'),
('550', '1', '333', '1', '2016-09-12 03:35:50', NULL, '6', '2014-06-25', '206'),
('551', '1', '334', '1', '2016-09-12 03:35:50', NULL, '6', '2014-06-25', '207'),
('552', '1', '335', '1', '2016-09-12 03:35:50', NULL, '6', '2014-06-25', '208'),
('553', '1', '336', '1', '2016-09-12 03:35:50', NULL, '6', '2014-06-25', '209'),
('554', '1', '337', '1', '2016-09-12 03:35:50', NULL, '6', '2014-06-25', '210'),
('555', '1', '338', '1', '2016-09-12 03:35:50', NULL, '6', '2014-06-30', '211'),
('556', '1', '339', '1', '2016-09-12 03:35:50', NULL, '6', '2014-06-30', '212'),
('557', '1', '340', '1', '2016-09-12 03:35:50', NULL, '6', '2014-07-09', '213'),
('558', '1', '341', '1', '2015-03-02 04:58:24', NULL, '6', '2013-01-07', '53'),
('559', '1', '342', '1', '2015-03-02 04:58:24', NULL, '6', '2013-01-29', '57'),
('560', '1', '343', '1', '2015-03-02 04:58:24', NULL, '6', '2013-01-29', '58'),
('561', '1', '344', '1', '2014-07-31 06:25:32', 'Edited', '6', '0000-00-00', '1'),
('562', '2', '62', '1', '2014-07-14 05:27:56', NULL, '6', '2013-01-29', NULL),
('563', '1', '345', '1', '2015-03-02 04:58:24', NULL, '6', '2013-02-28', '70'),
('564', '1', '346', '1', '2015-03-02 04:58:24', NULL, '6', '2013-02-26', '66'),
('565', '1', '347', '1', '2015-03-02 04:58:24', NULL, '6', '2013-02-26', '67'),
('566', '2', '63', '1', '2015-03-02 04:58:24', NULL, '6', '2013-02-06', '61'),
('567', '1', '348', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-27', '76'),
('568', '1', '349', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-27', '77'),
('569', '2', '64', '1', '2015-03-02 04:58:24', NULL, '6', '2012-12-20', '48'),
('570', '2', '65', '1', '2014-07-14 05:28:58', NULL, '6', '2013-01-29', NULL),
('571', '2', '62', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2014-07-14', '214'),
('572', '2', '66', '1', '2014-07-14 05:33:43', NULL, '6', '2013-01-29', NULL),
('573', '2', '65', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2014-07-14', '215'),
('574', '2', '67', '1', '2015-03-02 04:58:24', NULL, '6', '2013-01-29', '59'),
('575', '2', '66', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2014-07-14', '216'),
('576', '2', '68', '1', '2015-03-02 04:58:24', NULL, '6', '2013-02-26', '68'),
('577', '2', '69', '1', '2015-03-02 04:58:24', NULL, '6', '2013-02-27', '69'),
('578', '2', '70', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-08', '73'),
('579', '2', '71', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-27', '78'),
('580', '2', '35', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2014-07-14', '217'),
('581', '2', '72', '1', '2015-03-02 04:58:24', NULL, '6', '2012-04-26', '9'),
('582', '1', '350', '1', '2014-07-15 02:22:57', NULL, '6', '2012-06-27', NULL),
('583', '1', '284', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2014-07-15', '218'),
('584', '1', '351', '1', '2015-03-02 04:58:24', NULL, '6', '2012-06-27', '18'),
('585', '1', '283', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2014-07-15', '219'),
('586', '1', '352', '1', '2015-03-02 04:58:24', NULL, '6', '2012-06-18', '15'),
('587', '2', '43', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2014-07-15', '220'),
('588', '1', '350', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2014-07-15', '221'),
('589', '2', '73', '1', '2014-09-03 08:12:13', NULL, '6', '2012-07-23', NULL),
('590', '1', '353', '1', '2016-09-12 03:35:50', NULL, '6', '2014-07-18', '222'),
('591', '2', '74', '1', '2016-01-19 04:37:20', NULL, '6', '2013-04-29', '97'),
('592', '1', '354', '1', '2016-01-19 04:37:20', NULL, '6', '2013-04-29', '98'),
('593', '2', '75', '1', '2016-01-19 04:37:20', NULL, '6', '2013-05-28', '103'),
('594', '2', '76', '1', '2016-01-19 04:37:20', NULL, '6', '2013-05-03', '100'),
('595', '1', '355', '1', '2016-01-19 04:37:20', 'Edited', '6', '2013-05-28', '104'),
('596', '2', '77', '1', '2016-01-19 04:37:20', NULL, '6', '2013-06-05', '105'),
('597', '2', '78', '1', '2016-01-19 04:37:20', NULL, '6', '2013-06-27', '111'),
('598', '1', '356', '1', '2016-01-19 04:37:20', NULL, '6', '2013-06-17', '106'),
('599', '1', '357', '1', '2016-01-19 04:37:20', NULL, '6', '2013-06-25', '109'),
('600', '1', '358', '1', '2016-01-19 04:37:20', NULL, '6', '2013-06-27', '112'),
('601', '1', '359', '1', '2016-01-19 04:37:20', NULL, '6', '2013-07-26', '117'),
('602', '2', '79', '1', '2016-01-19 04:37:20', NULL, '6', '2013-07-04', '113'),
('603', '2', '80', '1', '2016-01-19 04:37:20', NULL, '6', '2013-07-26', '118'),
('604', '1', '360', '1', '2014-07-21 02:19:00', NULL, '6', '2013-07-05', NULL),
('605', '1', '361', '1', '2016-01-19 04:37:20', 'Edited', '6', '2013-07-05', '114'),
('606', '1', '360', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2014-07-21', '223'),
('607', '2', '81', '1', '2016-01-19 04:37:20', NULL, '6', '2013-07-31', '120'),
('608', '1', '362', '1', '2016-09-12 03:35:50', NULL, '6', '2014-07-22', '224'),
('609', '1', '363', '1', '2016-09-12 03:35:50', NULL, '6', '2014-07-24', '225'),
('610', '1', '364', '1', '2016-09-12 03:35:50', NULL, '6', '2014-07-28', '227'),
('611', '1', '365', '1', '2016-09-12 03:35:50', NULL, '6', '2014-07-28', '228'),
('612', '30', '18', '1', '2014-07-29 05:30:53', NULL, '6', '2012-04-20', '0'),
('613', '13', '18', '1', '2014-09-03 06:21:00', NULL, '6', '2012-04-20', NULL),
('614', '10', '18', '1', '2014-09-03 06:21:00', NULL, '6', '2012-04-20', NULL),
('615', '30', '19', '1', '2014-07-29 05:32:18', NULL, '6', '2012-04-20', '0'),
('616', '13', '19', '1', '2014-07-29 05:32:18', NULL, '6', '2012-04-20', '0'),
('617', '10', '19', '1', '2015-03-02 04:58:24', NULL, '6', '2012-04-20', '7'),
('618', '11', '1', '1', '2015-03-02 04:58:24', NULL, '6', '2012-04-20', '8'),
('619', '30', '20', '1', '2014-07-29 05:47:31', NULL, '6', '2012-05-20', '0'),
('620', '13', '20', '1', '2014-07-29 05:47:31', NULL, '6', '2012-05-20', '0'),
('621', '10', '20', '1', '2015-03-02 04:58:24', NULL, '6', '2012-05-20', '11'),
('622', '30', '21', '1', '2014-07-29 05:48:26', NULL, '6', '2012-05-20', '0'),
('623', '13', '21', '1', '2014-07-29 05:48:26', NULL, '6', '2012-05-20', '0'),
('624', '10', '21', '1', '2015-03-02 04:58:24', NULL, '6', '2012-05-20', '12'),
('625', '30', '22', '1', '2014-07-29 05:49:36', NULL, '6', '2012-06-20', '0'),
('626', '13', '22', '1', '2014-07-29 05:49:37', NULL, '6', '2012-06-20', '0'),
('627', '10', '22', '1', '2015-03-02 04:58:24', NULL, '6', '2012-06-20', '16'),
('628', '30', '23', '1', '2014-07-29 05:50:50', NULL, '6', '2012-06-20', '0'),
('629', '13', '23', '1', '2014-07-29 05:50:50', NULL, '6', '2012-06-20', '0'),
('630', '10', '23', '1', '2015-03-02 04:58:24', NULL, '6', '2012-06-20', '17'),
('631', '30', '24', '1', '2014-07-29 05:52:04', NULL, '6', '2012-07-20', '0'),
('632', '13', '24', '1', '2014-07-29 05:52:04', NULL, '6', '2012-07-20', '0'),
('633', '10', '24', '1', '2015-03-02 04:58:24', NULL, '6', '2012-07-20', '22'),
('634', '30', '25', '1', '2014-07-29 05:52:51', NULL, '6', '2012-07-20', '0'),
('635', '13', '25', '1', '2014-07-29 05:52:51', NULL, '6', '2012-07-20', '0'),
('636', '10', '25', '1', '2015-03-02 04:58:24', NULL, '6', '2012-07-20', '23'),
('637', '30', '26', '1', '2014-07-29 05:55:04', NULL, '6', '2012-08-20', '0');
INSERT INTO `1_audit_trail` VALUES
('638', '13', '26', '1', '2014-07-29 05:55:04', NULL, '6', '2012-08-20', '0'),
('639', '10', '26', '1', '2015-03-02 04:58:24', NULL, '6', '2012-08-20', '27'),
('640', '30', '27', '1', '2014-07-29 05:55:44', NULL, '6', '2012-08-20', '0'),
('641', '13', '27', '1', '2014-07-29 05:55:44', NULL, '6', '2012-08-20', '0'),
('642', '10', '27', '1', '2015-03-02 04:58:24', NULL, '6', '2012-08-20', '28'),
('643', '30', '28', '1', '2014-07-29 05:56:39', NULL, '6', '2012-09-20', '0'),
('644', '13', '28', '1', '2014-07-29 05:56:39', NULL, '6', '2012-09-20', '0'),
('645', '10', '28', '1', '2015-03-02 04:58:24', NULL, '6', '2012-09-20', '33'),
('646', '30', '29', '1', '2014-07-29 05:57:32', NULL, '6', '2012-09-20', '0'),
('647', '13', '29', '1', '2014-07-29 05:57:32', NULL, '6', '2012-09-20', '0'),
('648', '10', '29', '1', '2015-03-02 04:58:24', NULL, '6', '2012-09-20', '34'),
('649', '30', '30', '1', '2014-07-29 05:58:16', NULL, '6', '2012-10-20', '0'),
('650', '13', '30', '1', '2014-07-29 05:58:16', NULL, '6', '2012-10-20', '0'),
('651', '10', '30', '1', '2015-03-02 04:58:24', NULL, '6', '2012-10-20', '37'),
('652', '30', '31', '1', '2014-07-29 05:59:06', NULL, '6', '2012-10-20', '0'),
('653', '13', '31', '1', '2014-07-29 05:59:06', NULL, '6', '2012-10-20', '0'),
('654', '10', '31', '1', '2015-03-02 04:58:24', NULL, '6', '2012-10-20', '38'),
('655', '30', '32', '1', '2014-07-29 06:00:05', NULL, '6', '2012-11-20', '0'),
('656', '13', '32', '1', '2014-07-29 06:00:05', NULL, '6', '2012-11-20', '0'),
('657', '10', '32', '1', '2015-03-02 04:58:24', NULL, '6', '2012-11-20', '41'),
('658', '30', '33', '1', '2014-07-29 06:00:45', NULL, '6', '2012-11-20', '0'),
('659', '13', '33', '1', '2014-07-29 06:00:45', NULL, '6', '2012-11-20', '0'),
('660', '10', '33', '1', '2015-03-02 04:58:24', NULL, '6', '2012-11-20', '42'),
('661', '30', '34', '1', '2014-07-29 06:17:12', NULL, '6', '2012-12-20', '0'),
('662', '13', '34', '1', '2014-07-29 06:17:12', NULL, '6', '2012-12-20', '0'),
('663', '10', '34', '1', '2015-03-02 04:58:24', NULL, '6', '2012-12-20', '49'),
('664', '30', '35', '1', '2014-07-29 06:17:55', NULL, '6', '2012-12-20', '0'),
('665', '13', '35', '1', '2014-07-29 06:17:55', NULL, '6', '2012-12-20', '0'),
('666', '10', '35', '1', '2015-03-02 04:58:24', NULL, '6', '2012-12-20', '50'),
('667', '30', '36', '1', '2014-07-29 06:18:35', NULL, '6', '2013-01-20', '0'),
('668', '13', '36', '1', '2014-07-29 06:18:35', NULL, '6', '2013-01-20', '0'),
('669', '10', '36', '1', '2015-03-02 04:58:24', NULL, '6', '2013-01-20', '56'),
('670', '30', '37', '1', '2014-07-29 06:19:27', NULL, '6', '2013-01-20', '0'),
('671', '13', '37', '1', '2014-09-04 06:55:26', NULL, '6', '2013-01-20', NULL),
('672', '10', '37', '1', '2014-09-04 06:55:26', NULL, '6', '2013-01-20', NULL),
('673', '30', '38', '1', '2014-07-29 06:20:58', NULL, '6', '2013-02-20', '0'),
('674', '13', '38', '1', '2014-09-04 06:55:37', NULL, '6', '2013-02-20', NULL),
('675', '10', '38', '1', '2014-09-04 06:55:37', NULL, '6', '2013-02-20', NULL),
('676', '30', '39', '1', '2014-07-29 06:21:42', NULL, '6', '2013-02-20', '0'),
('677', '13', '39', '1', '2014-07-29 06:21:42', NULL, '6', '2013-02-20', '0'),
('678', '10', '39', '1', '2015-03-02 04:58:24', NULL, '6', '2013-02-20', '64'),
('679', '30', '40', '1', '2014-07-29 06:22:33', NULL, '6', '2013-03-20', '0'),
('680', '13', '40', '1', '2014-07-29 06:22:33', NULL, '6', '2013-03-20', '0'),
('681', '10', '40', '1', '2014-07-31 05:41:45', NULL, '6', '2013-03-20', NULL),
('682', '30', '41', '1', '2014-07-29 06:23:05', NULL, '6', '2013-03-20', '0'),
('683', '13', '41', '1', '2014-07-29 06:23:05', NULL, '6', '2013-03-20', '0'),
('684', '10', '41', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-20', '74'),
('685', '1', '366', '1', '2016-09-12 03:35:50', NULL, '6', '2014-07-30', '229'),
('686', '1', '367', '1', '2016-09-12 03:35:50', NULL, '6', '2014-07-30', '230'),
('687', '1', '368', '1', '2016-09-12 03:35:50', NULL, '6', '2014-07-31', '231'),
('688', '0', '19', '1', '2016-09-12 03:35:50', NULL, '6', '2014-07-31', '232'),
('689', '10', '40', '1', '2015-03-02 04:58:24', 'Updated.', '6', '2013-03-20', '75'),
('690', '12', '21', '1', '2015-03-02 04:58:24', NULL, '6', '2012-04-30', '10'),
('691', '12', '22', '1', '2015-03-02 04:58:24', NULL, '6', '2012-05-31', '13'),
('692', '12', '23', '1', '2015-03-02 04:58:24', NULL, '6', '2012-05-31', '14'),
('693', '12', '24', '1', '2015-03-02 04:58:24', NULL, '6', '2012-06-30', '20'),
('694', '12', '25', '1', '2015-03-02 04:58:24', NULL, '6', '2012-06-30', '21'),
('695', '12', '26', '1', '2015-03-02 04:58:24', NULL, '6', '2012-07-31', '25'),
('696', '12', '27', '1', '2015-03-02 04:58:24', NULL, '6', '2012-07-31', '26'),
('697', '12', '28', '1', '2015-03-02 04:58:24', NULL, '6', '2012-08-31', '30'),
('698', '12', '29', '1', '2015-03-02 04:58:24', NULL, '6', '2012-08-31', '31'),
('699', '12', '30', '1', '2015-03-02 04:58:24', NULL, '6', '2012-09-30', '35'),
('700', '12', '31', '1', '2015-03-02 04:58:24', NULL, '6', '2012-09-30', '36'),
('701', '12', '32', '1', '2015-03-02 04:58:24', NULL, '6', '2012-10-31', '39'),
('702', '12', '33', '1', '2015-03-02 04:58:24', NULL, '6', '2012-10-31', '40'),
('703', '12', '34', '1', '2015-03-02 04:58:24', NULL, '6', '2012-11-30', '44'),
('704', '12', '35', '1', '2015-03-02 04:58:24', NULL, '6', '2012-11-30', '45'),
('705', '12', '36', '1', '2015-03-02 04:58:24', NULL, '6', '2012-12-31', '51'),
('706', '12', '37', '1', '2015-03-02 04:58:24', NULL, '6', '2012-12-31', '52'),
('707', '12', '38', '1', '2015-03-02 04:58:24', NULL, '6', '2013-01-31', '60'),
('708', '12', '39', '1', '2014-09-04 06:53:49', NULL, '6', '2013-01-31', NULL),
('709', '12', '40', '1', '2014-09-04 06:53:59', NULL, '6', '2013-02-28', NULL),
('710', '12', '41', '1', '2015-03-02 04:58:24', NULL, '6', '2013-02-28', '71'),
('711', '12', '42', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-31', '81'),
('712', '12', '43', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-31', '82'),
('713', '0', '21', '1', '2014-07-31 06:35:16', NULL, '1', '2012-03-30', '135'),
('714', '1', '369', '1', '2016-09-12 03:35:50', NULL, '6', '2014-08-04', '233'),
('715', '1', '370', '1', '2016-09-12 03:35:50', NULL, '6', '2014-08-04', '234'),
('716', '1', '371', '1', '2015-12-31 05:59:57', NULL, '6', '2014-08-05', NULL),
('717', '1', '372', '1', '2016-09-12 03:35:50', NULL, '6', '2014-08-11', '235'),
('718', '1', '373', '1', '2016-09-12 03:35:50', NULL, '6', '2014-08-11', '236'),
('719', '1', '374', '1', '2016-09-12 03:35:50', NULL, '6', '2014-08-11', '237'),
('720', '1', '375', '1', '2016-09-12 03:35:50', NULL, '6', '2014-08-11', '238'),
('721', '1', '376', '1', '2016-09-12 03:35:50', NULL, '6', '2014-08-11', '239'),
('722', '1', '377', '1', '2016-09-12 03:35:50', NULL, '6', '2014-08-20', '240'),
('723', '1', '378', '1', '2016-09-12 03:35:50', NULL, '6', '2014-08-21', '241'),
('724', '1', '379', '1', '2016-09-12 03:35:50', NULL, '6', '2014-08-21', '242'),
('725', '2', '41', '1', '2015-03-02 04:58:24', 'Voided.\n', '6', '2012-06-27', '19'),
('726', '2', '45', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2014-07-27', '226'),
('727', '0', '23', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-31', '83'),
('728', '1', '380', '1', '2016-09-12 03:35:50', NULL, '6', '2014-08-27', '243'),
('729', '1', '381', '1', '2016-09-12 03:35:50', NULL, '6', '2014-08-29', '244'),
('730', '1', '382', '1', '2016-09-12 03:35:50', NULL, '6', '2014-08-29', '245'),
('731', '1', '383', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-01', '246'),
('732', '0', '24', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-30', '79'),
('733', '1', '384', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-03', '247'),
('734', '13', '18', '1', '2014-09-03 06:21:00', 'Voided.', '6', '2014-09-03', '0'),
('735', '10', '18', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2014-09-03', '248'),
('736', '1', '385', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-03', '249'),
('740', '0', '25', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-31', '84'),
('741', '0', '26', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-31', '85'),
('742', '2', '82', '1', '2015-03-02 04:58:24', NULL, '6', '2012-07-23', '24'),
('743', '2', '73', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2014-09-03', '250'),
('744', '2', '83', '1', '2015-03-02 04:58:24', NULL, '6', '2012-09-04', '32'),
('745', '2', '51', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2014-09-03', '251'),
('746', '1', '386', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-04', '252'),
('748', '1', '387', '1', '2015-02-24 04:34:58', NULL, '6', '2012-08-22', NULL),
('749', '1', '388', '1', '2015-03-02 04:58:24', NULL, '6', '2012-11-21', '43'),
('750', '1', '389', '1', '2015-03-02 04:58:24', NULL, '6', '2012-11-30', '46'),
('751', '1', '390', '1', '2015-03-02 04:58:24', NULL, '6', '2013-01-16', '55'),
('752', '1', '391', '1', '2014-09-04 06:42:27', NULL, '6', '2013-01-29', NULL),
('753', '1', '392', '1', '2015-03-02 04:58:24', NULL, '6', '2013-02-15', '63'),
('754', '1', '393', '1', '2015-03-02 04:58:24', NULL, '6', '2012-12-14', '47'),
('755', '1', '394', '1', '2015-03-02 04:58:24', NULL, '6', '2013-02-14', '62'),
('756', '1', '395', '1', '2015-03-02 04:58:24', NULL, '6', '2013-01-09', '54'),
('757', '1', '391', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2014-09-04', '253'),
('758', '12', '39', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2014-09-04', '254'),
('759', '12', '40', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2014-09-04', '255'),
('760', '13', '37', '1', '2014-09-04 06:55:26', 'Voided.', '6', '2014-09-04', '0'),
('761', '10', '37', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2014-09-04', '256'),
('762', '13', '38', '1', '2014-09-04 06:55:37', 'Voided.', '6', '2014-09-04', '0'),
('763', '10', '38', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2014-09-04', '257'),
('764', '0', '27', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-31', '86'),
('765', '0', '28', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-31', '87'),
('766', '1', '396', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-10', '258'),
('767', '1', '397', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-11', '259'),
('768', '1', '398', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-11', '260'),
('769', '1', '399', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-11', '261'),
('770', '1', '400', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-12', '262'),
('771', '1', '401', '1', '2014-09-16 04:54:40', NULL, '6', '2014-09-15', NULL),
('772', '1', '402', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-15', '263'),
('773', '1', '403', '1', '2015-03-02 04:58:24', 'Edited', '6', '0000-00-00', '2'),
('774', '1', '401', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2014-09-16', '265'),
('775', '1', '404', '1', '2014-09-17 03:15:11', NULL, '6', '2014-09-15', NULL),
('776', '1', '405', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-15', '264'),
('777', '1', '404', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2014-09-17', '266'),
('778', '1', '406', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-29', '267'),
('779', '1', '407', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-29', '268'),
('780', '1', '408', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-29', '269'),
('781', '1', '409', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-30', '270'),
('782', '1', '410', '1', '2016-09-12 03:35:50', NULL, '6', '2014-09-30', '271'),
('783', '1', '411', '1', '2016-09-12 03:35:50', NULL, '6', '2014-10-02', '272'),
('784', '1', '412', '1', '2016-09-12 03:35:50', NULL, '6', '2014-10-14', '273'),
('785', '1', '413', '1', '2016-09-12 03:35:50', NULL, '6', '2014-10-14', '274'),
('786', '1', '414', '1', '2015-03-02 04:58:24', 'Edited', '6', '0000-00-00', '3'),
('787', '1', '415', '1', '2016-09-12 03:35:50', NULL, '6', '2014-10-24', '275'),
('788', '1', '416', '1', '2016-09-12 03:35:50', NULL, '6', '2014-10-28', '276'),
('789', '1', '417', '1', '2016-09-12 03:35:50', NULL, '6', '2014-10-28', '277'),
('790', '1', '418', '1', '2016-09-12 03:35:50', NULL, '6', '2014-11-04', '278'),
('791', '1', '419', '1', '2016-09-12 03:35:50', NULL, '6', '2014-11-04', '279'),
('792', '1', '420', '1', '2016-09-12 03:35:50', NULL, '6', '2014-11-04', '280'),
('793', '1', '421', '1', '2016-09-12 03:35:50', NULL, '6', '2014-11-04', '281'),
('794', '1', '422', '1', '2016-09-12 03:35:50', NULL, '6', '2014-11-26', '282'),
('795', '1', '423', '1', '2016-09-12 03:35:50', NULL, '6', '2014-11-27', '283'),
('796', '1', '424', '1', '2016-09-12 03:35:50', NULL, '6', '2014-11-28', '284'),
('797', '1', '425', '1', '2016-09-12 03:35:50', NULL, '6', '2014-11-28', '285'),
('798', '1', '426', '1', '2016-09-12 03:35:50', NULL, '6', '2014-12-05', '286'),
('799', '1', '427', '1', '2016-09-12 03:35:50', NULL, '6', '2014-12-05', '287'),
('800', '1', '428', '1', '2016-09-12 03:35:50', NULL, '6', '2014-12-09', '288'),
('801', '1', '429', '1', '2016-09-12 03:35:50', NULL, '6', '2014-12-31', '289'),
('802', '1', '430', '1', '2016-09-12 03:35:50', NULL, '6', '2014-12-31', '290'),
('803', '1', '431', '1', '2016-09-12 03:35:50', NULL, '6', '2015-01-13', '291'),
('804', '1', '432', '1', '2016-09-12 03:35:50', NULL, '6', '2015-01-13', '292'),
('805', '1', '433', '1', '2016-09-12 03:35:50', NULL, '6', '2015-01-13', '293'),
('806', '1', '434', '1', '2016-09-12 03:35:50', NULL, '6', '2015-01-13', '294'),
('807', '1', '435', '1', '2016-09-12 03:35:50', NULL, '6', '2015-01-16', '295'),
('808', '1', '436', '1', '2016-09-12 03:35:50', NULL, '6', '2015-01-21', '296'),
('809', '1', '437', '1', '2016-09-12 03:35:50', NULL, '6', '2015-01-26', '297'),
('810', '1', '438', '1', '2016-09-12 03:35:50', NULL, '6', '2015-01-27', '298'),
('811', '1', '439', '1', '2016-09-12 03:35:50', 'Edited', '6', '2015-01-27', '299'),
('812', '1', '440', '1', '2015-03-02 04:58:24', 'Edited', '6', '0000-00-00', '4'),
('813', '1', '441', '1', '2016-09-12 03:35:50', NULL, '6', '2015-01-29', '300'),
('814', '1', '442', '1', '2016-09-12 03:35:50', NULL, '6', '2015-01-29', '301'),
('815', '1', '443', '1', '2016-09-12 03:35:50', NULL, '6', '2015-01-29', '302'),
('816', '1', '444', '1', '2016-09-12 03:35:50', NULL, '6', '2015-02-06', '303'),
('817', '1', '445', '1', '2016-09-12 03:35:50', NULL, '6', '2015-02-06', '304'),
('818', '1', '446', '1', '2016-09-12 03:35:50', NULL, '6', '2015-02-06', '305'),
('819', '1', '447', '1', '2016-09-12 03:35:50', NULL, '6', '2015-02-06', '306'),
('820', '1', '448', '1', '2016-09-12 03:35:50', NULL, '6', '2015-02-06', '307'),
('821', '1', '449', '1', '2016-09-12 03:35:50', NULL, '6', '2015-02-10', '308'),
('822', '1', '450', '1', '2016-09-12 03:35:50', NULL, '6', '2015-02-16', '309'),
('823', '1', '451', '1', '2016-01-19 04:37:20', 'Edited', '6', '2013-08-27', '127'),
('824', '2', '84', '1', '2016-01-19 04:37:20', NULL, '6', '2013-08-08', '122'),
('825', '2', '85', '1', '2016-01-19 04:37:20', NULL, '6', '2013-08-22', '124'),
('826', '2', '86', '1', '2016-01-19 04:37:20', NULL, '6', '2013-09-02', '129'),
('827', '2', '87', '1', '2016-01-19 04:37:20', NULL, '6', '2013-09-02', '130'),
('828', '2', '88', '1', '2016-01-19 04:37:20', NULL, '6', '2013-09-27', '135'),
('829', '1', '452', '1', '2016-01-19 04:37:20', NULL, '6', '2013-09-27', '136'),
('830', '2', '89', '1', '2016-01-19 04:37:20', NULL, '6', '2013-09-18', '133'),
('831', '2', '90', '1', '2016-01-19 04:37:20', NULL, '6', '2013-10-28', '142'),
('832', '1', '453', '1', '2016-01-19 04:37:20', NULL, '6', '2013-10-28', '143'),
('833', '1', '454', '1', '2016-01-19 04:37:20', NULL, '6', '2013-10-28', '144'),
('834', '1', '455', '1', '2016-01-19 04:37:20', NULL, '6', '2013-11-22', '149'),
('835', '1', '456', '1', '2016-01-19 04:37:20', NULL, '6', '2013-11-27', '151'),
('836', '2', '91', '1', '2016-01-19 04:37:20', NULL, '6', '2013-11-01', '146'),
('837', '2', '92', '1', '2016-01-19 04:37:20', NULL, '6', '2013-11-27', '152'),
('838', '2', '93', '1', '2016-01-19 04:37:20', NULL, '6', '2013-12-10', '154'),
('839', '2', '94', '1', '2016-01-19 04:37:20', NULL, '6', '2013-12-10', '155'),
('840', '1', '457', '1', '2016-01-19 04:37:20', 'Edited', '6', '2013-12-11', '156'),
('841', '1', '458', '1', '2016-01-19 04:37:20', NULL, '6', '2013-12-17', '157'),
('842', '1', '459', '1', '2016-01-19 04:37:20', NULL, '6', '2013-12-24', '161'),
('843', '1', '460', '1', '2016-01-19 04:37:20', NULL, '6', '2014-01-27', '168'),
('844', '2', '95', '1', '2016-01-19 04:37:20', NULL, '6', '2013-12-23', '159'),
('845', '2', '96', '1', '2016-01-19 04:37:20', NULL, '6', '2014-01-17', '164'),
('846', '2', '97', '1', '2016-01-19 04:37:20', NULL, '6', '2014-01-21', '166'),
('847', '2', '98', '1', '2016-01-19 04:37:20', NULL, '6', '2014-01-27', '169'),
('848', '2', '99', '1', '2016-01-19 04:37:20', NULL, '6', '2014-02-28', '172'),
('849', '1', '461', '1', '2016-01-19 04:37:20', NULL, '6', '2014-02-28', '173'),
('850', '1', '462', '1', '2015-03-02 04:58:24', 'Edited', '6', '0000-00-00', '5'),
('851', '2', '100', '1', '2016-01-19 04:37:20', NULL, '6', '2014-03-19', '176'),
('852', '2', '101', '1', '2016-01-19 04:37:20', NULL, '6', '2014-03-27', '181'),
('853', '1', '463', '1', '2016-01-19 04:37:20', NULL, '6', '2014-03-20', '177'),
('854', '2', '102', '1', '2016-01-19 04:37:20', NULL, '6', '2014-03-25', '180'),
('855', '1', '464', '1', '2016-01-19 04:37:20', NULL, '6', '2014-03-27', '182'),
('856', '2', '103', '1', '2016-01-19 04:37:20', NULL, '6', '2014-03-14', '175'),
('857', '0', '29', '1', '2016-01-19 04:37:20', NULL, '6', '2014-03-31', '184'),
('858', '1', '281', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2015-02-23', '310'),
('859', '1', '465', '1', '2016-09-12 03:35:50', NULL, '6', '2015-02-23', '311'),
('860', '0', '30', '1', '2016-01-19 04:37:20', NULL, '6', '2013-04-01', '90'),
('861', '30', '42', '1', '2015-02-24 00:15:42', NULL, '6', '2013-04-25', '0'),
('862', '13', '42', '1', '2015-02-24 00:15:42', NULL, '6', '2013-04-25', '0'),
('863', '10', '42', '1', '2016-01-19 04:37:20', NULL, '6', '2013-04-25', '95'),
('864', '30', '43', '1', '2015-02-24 00:22:05', NULL, '6', '2013-04-25', '0'),
('865', '13', '43', '1', '2015-02-24 00:22:06', NULL, '6', '2013-04-25', '0'),
('866', '10', '43', '1', '2016-01-19 04:37:20', NULL, '6', '2013-04-25', '96'),
('867', '30', '44', '1', '2015-02-24 00:37:09', NULL, '6', '2013-05-21', '0'),
('868', '13', '44', '1', '2015-02-24 00:37:09', NULL, '6', '2013-05-21', '0'),
('869', '10', '44', '1', '2016-01-19 04:37:20', NULL, '6', '2013-05-21', '101'),
('870', '30', '45', '1', '2015-02-24 00:38:11', NULL, '6', '2013-05-21', '0'),
('871', '13', '45', '1', '2015-03-02 04:47:02', NULL, '6', '2013-05-21', NULL),
('872', '10', '45', '1', '2015-03-02 04:47:02', NULL, '6', '2013-05-21', NULL),
('873', '30', '46', '1', '2015-02-24 00:39:37', NULL, '6', '2013-06-21', '0'),
('874', '13', '46', '1', '2015-02-24 00:39:38', NULL, '6', '2013-06-21', '0'),
('875', '10', '46', '1', '2016-01-19 04:37:20', NULL, '6', '2013-06-21', '107'),
('876', '30', '47', '1', '2015-02-24 00:41:58', NULL, '6', '2013-07-22', '0'),
('877', '13', '47', '1', '2015-02-24 00:41:58', NULL, '6', '2013-07-22', '0'),
('878', '10', '47', '1', '2016-01-19 04:37:20', NULL, '6', '2013-07-22', '116'),
('879', '30', '48', '1', '2015-02-24 00:43:23', NULL, '6', '2013-08-21', '0'),
('880', '13', '48', '1', '2015-02-24 00:43:23', NULL, '6', '2013-08-21', '0'),
('881', '10', '48', '1', '2016-01-19 04:37:20', NULL, '6', '2013-08-21', '123'),
('882', '30', '49', '1', '2015-02-24 00:44:33', NULL, '6', '2013-09-20', '0'),
('883', '13', '49', '1', '2015-02-24 00:44:33', NULL, '6', '2013-09-20', '0'),
('884', '10', '49', '1', '2016-01-19 04:37:20', NULL, '6', '2013-09-20', '134'),
('885', '30', '50', '1', '2015-02-24 00:45:36', NULL, '6', '2013-10-21', '0'),
('886', '13', '50', '1', '2015-02-24 00:45:36', NULL, '6', '2013-10-21', '0'),
('887', '10', '50', '1', '2016-01-19 04:37:20', NULL, '6', '2013-10-21', '140'),
('888', '30', '51', '1', '2015-02-24 00:46:38', NULL, '6', '2013-11-22', '0'),
('889', '13', '51', '1', '2015-02-24 00:46:38', NULL, '6', '2013-11-22', '0'),
('890', '10', '51', '1', '2016-01-19 04:37:20', NULL, '6', '2013-11-22', '150'),
('891', '30', '52', '1', '2015-02-24 00:47:35', NULL, '6', '2013-12-23', '0'),
('892', '13', '52', '1', '2015-02-24 00:47:35', NULL, '6', '2013-12-23', '0'),
('893', '10', '52', '1', '2016-01-19 04:37:20', NULL, '6', '2013-12-23', '160'),
('894', '30', '53', '1', '2015-02-24 00:48:41', NULL, '6', '2014-01-22', '0'),
('895', '13', '53', '1', '2015-02-24 00:48:41', NULL, '6', '2014-01-22', '0'),
('896', '10', '53', '1', '2016-01-19 04:37:20', NULL, '6', '2014-01-22', '167'),
('897', '30', '54', '1', '2015-02-24 00:49:59', NULL, '6', '2014-02-21', '0'),
('898', '13', '54', '1', '2015-02-24 00:49:59', NULL, '6', '2014-02-21', '0'),
('899', '10', '54', '1', '2016-01-19 04:37:20', NULL, '6', '2014-02-21', '170'),
('900', '12', '44', '1', '2016-01-19 04:37:20', NULL, '6', '2013-04-29', '99'),
('901', '12', '45', '1', '2015-03-02 04:52:25', NULL, '6', '2013-05-27', NULL),
('902', '12', '46', '1', '2016-01-19 04:37:20', NULL, '6', '2013-06-26', '110'),
('903', '12', '47', '1', '2016-01-19 04:37:20', NULL, '6', '2013-07-30', '119'),
('904', '12', '48', '1', '2016-01-19 04:37:20', NULL, '6', '2013-08-29', '128'),
('905', '12', '49', '1', '2016-01-19 04:37:20', NULL, '6', '2013-09-30', '137'),
('906', '12', '50', '1', '2016-01-19 04:37:20', NULL, '6', '2013-10-30', '145'),
('907', '12', '51', '1', '2016-01-19 04:37:20', NULL, '6', '2013-11-28', '153'),
('908', '12', '52', '1', '2016-01-19 04:37:20', NULL, '6', '2013-12-30', '162'),
('909', '12', '53', '1', '2016-01-19 04:37:20', NULL, '6', '2013-12-30', '163'),
('910', '12', '54', '1', '2016-01-19 04:37:20', NULL, '6', '2014-02-28', '174'),
('911', '30', '55', '1', '2015-02-24 01:13:45', NULL, '6', '2014-03-21', '0'),
('912', '13', '55', '1', '2015-02-24 01:13:45', NULL, '6', '2014-03-21', '0'),
('913', '10', '55', '1', '2016-01-19 04:37:20', NULL, '6', '2014-03-21', '179'),
('914', '0', '31', '1', '2015-02-25 06:39:28', NULL, '6', '2013-04-04', NULL),
('915', '1', '466', '1', '2015-02-24 02:09:51', NULL, '6', '2013-04-04', NULL),
('916', '1', '122', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2015-02-24', '312'),
('917', '0', '32', '1', '2015-02-24 02:07:09', NULL, '6', '2013-03-30', NULL),
('918', '0', '32', '1', '2015-02-24 05:54:34', NULL, '6', '2013-03-30', NULL),
('919', '0', '33', '1', '2015-02-25 06:39:37', NULL, '6', '2013-04-04', NULL),
('920', '1', '467', '1', '2016-01-19 04:37:20', 'Edited', '6', '2013-04-04', '91'),
('921', '1', '466', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2015-02-24', '313'),
('922', '30', '56', '1', '2015-02-24 02:14:50', NULL, '6', '2013-02-20', '0'),
('923', '13', '56', '1', '2015-02-24 02:14:50', NULL, '6', '2013-02-20', '0'),
('924', '10', '56', '1', '2015-03-02 04:58:24', NULL, '6', '2013-02-20', '65'),
('925', '12', '55', '1', '2015-02-24 07:08:16', NULL, '6', '2013-02-28', NULL),
('926', '12', '56', '1', '2016-01-19 04:37:20', NULL, '6', '2014-03-30', '183'),
('927', '1', '468', '1', '2015-02-24 05:36:34', NULL, '6', '2012-08-22', NULL),
('928', '1', '387', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2015-02-24', '314'),
('929', '0', '34', '1', '2015-02-24 05:18:51', NULL, '6', '2013-04-23', NULL),
('930', '1', '469', '1', '2015-03-02 04:58:24', 'Edited', '6', '0000-00-00', '6'),
('931', '0', '34', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2015-02-24', '315'),
('932', '1', '470', '1', '2016-01-19 04:37:20', NULL, '6', '2013-04-23', '94'),
('933', '1', '471', '1', '2016-01-19 04:37:20', NULL, '6', '2013-05-22', '102'),
('934', '1', '472', '1', '2016-01-19 04:37:20', NULL, '6', '2013-06-21', '108'),
('935', '1', '473', '1', '2016-01-19 04:37:20', NULL, '6', '2013-07-19', '115'),
('936', '1', '474', '1', '2016-01-19 04:37:20', NULL, '6', '2013-08-06', '121'),
('937', '1', '475', '1', '2016-01-19 04:37:20', NULL, '6', '2013-08-22', '125'),
('938', '1', '476', '1', '2016-01-19 04:37:20', NULL, '6', '2013-10-05', '138'),
('939', '1', '477', '1', '2016-01-19 04:37:20', NULL, '6', '2013-10-24', '141'),
('940', '1', '478', '1', '2016-01-19 04:37:20', NULL, '6', '2013-12-18', '158'),
('941', '1', '479', '1', '2016-01-19 04:37:20', NULL, '6', '2014-01-17', '165'),
('942', '1', '480', '1', '2016-01-19 04:37:20', NULL, '6', '2014-02-21', '171'),
('943', '1', '481', '1', '2016-01-19 04:37:20', NULL, '6', '2014-03-20', '178'),
('944', '1', '468', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2015-02-24', '316'),
('945', '1', '74', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2015-02-24', '317'),
('946', '0', '32', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-30', '80'),
('947', '0', '35', '1', '2015-03-02 04:58:24', NULL, '6', '2012-08-22', '29'),
('948', '12', '55', '1', '2015-02-24 07:20:44', 'Updated.', '6', '2013-02-28', NULL),
('949', '12', '55', '1', '2015-03-02 04:58:24', 'Updated.', '6', '2013-02-28', '72'),
('950', '0', '36', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-31', '88'),
('951', '1', '482', '1', '2016-01-19 04:37:20', NULL, '6', '2013-04-09', '92'),
('952', '1', '126', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2015-02-25', '318'),
('953', '1', '483', '1', '2016-01-19 04:37:20', NULL, '6', '2013-10-08', '139'),
('954', '1', '237', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2015-02-25', '319'),
('955', '1', '484', '1', '2016-01-19 04:37:20', NULL, '6', '2013-11-06', '147'),
('956', '1', '248', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2015-02-25', '320'),
('957', '0', '31', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2015-02-25', '321'),
('958', '0', '33', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2015-02-25', '322'),
('959', '1', '485', '1', '2016-01-19 04:37:20', NULL, '6', '2013-09-06', '131'),
('960', '1', '486', '1', '2016-01-19 04:37:20', NULL, '6', '2013-11-14', '148'),
('961', '1', '487', '1', '2016-01-19 04:37:20', NULL, '6', '2013-04-17', '93'),
('962', '1', '488', '1', '2016-01-19 04:37:20', NULL, '6', '2013-09-06', '132'),
('963', '1', '489', '1', '2016-09-12 03:35:50', NULL, '6', '2015-02-26', '323'),
('964', '1', '490', '1', '2016-09-12 03:35:50', NULL, '6', '2015-02-27', '324'),
('965', '1', '491', '1', '2016-09-12 03:35:50', NULL, '6', '2015-02-27', '325'),
('966', '1', '492', '1', '2016-09-12 03:35:50', NULL, '6', '2015-03-02', '326'),
('967', '1', '493', '1', '2016-01-19 04:37:20', NULL, '6', '2013-08-22', '126'),
('968', '1', '227', '1', '2016-09-12 03:35:50', 'Voided.\nDocument reentered.', '6', '2015-03-02', '327'),
('969', '0', '37', '1', '2015-03-06 00:27:39', NULL, '6', '2014-03-31', NULL),
('970', '0', '38', '1', '2015-03-03 05:56:25', NULL, '6', '2014-03-31', NULL),
('971', '0', '39', '1', '2015-03-02 05:01:21', NULL, '6', '2014-03-31', NULL),
('972', '13', '45', '1', '2015-03-02 04:47:02', 'Voided.', '6', '2015-03-02', '0'),
('973', '10', '45', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2015-03-02', '328'),
('974', '30', '57', '1', '2015-03-02 04:48:28', NULL, '6', '2013-05-21', '0'),
('975', '13', '57', '1', '2015-03-02 04:49:43', NULL, '6', '2013-05-21', NULL),
('976', '10', '57', '1', '2015-03-02 04:49:43', NULL, '6', '2013-05-21', NULL),
('977', '13', '57', '1', '2015-03-02 04:49:43', 'Voided.', '6', '2015-03-02', '0'),
('978', '10', '57', '1', '2016-09-12 03:35:50', 'Voided.\n', '6', '2015-03-02', '329'),
('979', '30', '58', '1', '2015-03-02 04:50:38', NULL, '6', '2013-05-21', '0'),
('980', '13', '58', '1', '2015-03-03 07:05:18', NULL, '6', '2013-05-21', NULL),
('981', '10', '58', '1', '2015-03-03 07:05:18', NULL, '6', '2013-05-21', NULL),
('982', '12', '45', '1', '2015-03-03 07:08:03', 'Updated.', '6', '2013-05-27', NULL),
('983', '0', '40', '1', '2015-03-02 04:58:24', NULL, '6', '2013-03-31', '89'),
('984', '0', '39', '1', '2015-03-03 06:01:02', NULL, '5', '2014-03-31', NULL),
('985', '0', '38', '1', '2016-01-19 04:37:20', NULL, '5', '2014-03-31', '42'),
('986', '0', '39', '1', '2016-01-19 04:37:20', NULL, '5', '2014-03-31', '43'),
('987', '0', '42', '1', '2016-01-19 04:37:20', NULL, '5', '2014-03-31', '44'),
('988', '13', '58', '1', '2015-03-03 07:05:18', 'Voided.', '5', '2015-03-03', '0'),
('989', '10', '58', '1', '2016-09-12 03:35:50', 'Voided.\n', '5', '2015-03-03', '46'),
('990', '30', '59', '1', '2015-03-03 07:07:07', NULL, '5', '2013-05-21', '0'),
('991', '13', '59', '1', '2015-03-03 07:07:07', NULL, '5', '2013-05-21', '0'),
('992', '10', '59', '1', '2016-01-19 04:37:20', NULL, '5', '2013-05-21', '14'),
('993', '12', '45', '1', '2016-01-19 04:37:20', 'Updated.', '5', '2013-05-27', '15'),
('994', '0', '37', '1', '2016-01-19 04:37:20', NULL, '5', '2014-03-31', '45'),
('995', '1', '494', '1', '2016-09-12 03:35:50', NULL, '5', '2015-03-11', '47'),
('996', '1', '495', '1', '2016-09-12 03:35:50', NULL, '5', '2015-03-30', '48'),
('997', '1', '496', '1', '2016-09-12 03:35:50', NULL, '5', '2015-03-30', '49'),
('998', '1', '497', '1', '2016-09-12 03:35:50', NULL, '5', '2015-03-30', '50'),
('999', '1', '498', '1', '2016-09-12 03:35:50', NULL, '5', '2015-03-30', '51'),
('1000', '1', '499', '1', '2015-04-01 01:35:20', NULL, '7', '2015-04-01', '0'),
('1001', '1', '500', '1', '2015-04-10 05:06:30', NULL, '7', '2015-04-10', '0'),
('1002', '1', '501', '1', '2015-04-10 05:07:31', NULL, '7', '2015-04-10', '0'),
('1003', '1', '502', '1', '2015-04-10 05:53:55', NULL, '7', '2015-04-10', '0'),
('1004', '1', '503', '1', '2015-04-28 23:02:41', 'Edited', '7', '2015-04-29', '0'),
('1005', '1', '504', '1', '2016-02-29 00:32:44', NULL, '7', '2015-04-29', NULL),
('1006', '1', '505', '1', '2016-02-29 00:04:01', NULL, '7', '2015-04-29', NULL),
('1007', '1', '506', '1', '2015-04-29 06:38:28', NULL, '7', '2015-04-29', '0'),
('1008', '1', '507', '1', '2015-05-05 05:32:31', NULL, '7', '2015-05-05', '0'),
('1009', '1', '508', '1', '2015-05-13 04:41:05', NULL, '7', '2015-05-13', '0'),
('1010', '1', '509', '1', '2015-05-21 03:48:27', NULL, '7', '2015-05-21', '0'),
('1011', '1', '510', '1', '2015-05-21 03:53:42', 'Edited', '7', '2015-05-21', '0'),
('1012', '1', '511', '1', '2016-02-29 00:05:43', NULL, '7', '2015-06-01', NULL),
('1013', '1', '512', '1', '2016-02-29 00:30:42', NULL, '7', '2015-06-01', NULL),
('1014', '1', '513', '1', '2015-06-10 05:47:16', NULL, '7', '2015-06-10', '0'),
('1015', '1', '514', '1', '2016-05-09 04:23:37', 'Edited', '7', '2015-06-10', NULL),
('1016', '1', '515', '1', '2015-06-15 00:46:07', NULL, '7', '2015-06-15', '0'),
('1017', '1', '516', '1', '2015-06-18 04:55:13', NULL, '7', '2015-06-18', '0'),
('1018', '1', '517', '1', '2015-06-18 04:59:55', NULL, '7', '2015-06-18', '0'),
('1019', '1', '518', '1', '2015-06-18 05:05:51', NULL, '7', '2015-06-18', '0'),
('1020', '1', '519', '1', '2016-02-29 00:07:00', NULL, '7', '2015-06-30', NULL),
('1021', '1', '520', '1', '2016-02-29 00:29:10', 'Edited', '7', '2015-06-30', NULL),
('1022', '1', '521', '1', '2015-07-02 05:56:37', NULL, '7', '2015-07-02', '0'),
('1023', '1', '522', '1', '2015-07-09 01:20:36', NULL, '7', '2015-07-09', '0'),
('1024', '1', '523', '1', '2015-07-09 01:23:10', NULL, '7', '2015-07-09', '0'),
('1025', '1', '524', '1', '2015-07-10 01:53:04', NULL, '7', '2015-07-10', '0'),
('1026', '1', '525', '1', '2015-07-10 01:55:09', NULL, '7', '2015-07-10', '0'),
('1027', '1', '526', '1', '2015-07-24 06:30:48', NULL, '7', '2015-07-27', '0'),
('1028', '1', '527', '1', '2015-07-29 02:01:56', NULL, '7', '2015-07-29', '0'),
('1029', '1', '528', '1', '2016-02-29 00:08:50', NULL, '7', '2015-07-29', NULL),
('1030', '1', '529', '1', '2016-02-29 00:27:44', NULL, '7', '2015-07-29', NULL),
('1031', '1', '530', '1', '2015-08-12 05:02:34', NULL, '7', '2015-08-12', '0'),
('1032', '1', '531', '1', '2015-08-12 06:57:38', NULL, '7', '2015-08-12', '0'),
('1033', '1', '532', '1', '2015-08-19 04:15:11', NULL, '7', '2015-08-19', NULL),
('1034', '1', '533', '1', '2015-08-19 04:15:10', NULL, '7', '2015-08-19', '0'),
('1035', '1', '532', '1', '2015-08-19 04:15:11', 'Voided.\nDocument reentered.', '7', '2015-08-19', '0'),
('1036', '1', '534', '1', '2015-08-24 05:05:07', NULL, '7', '2015-08-24', '0'),
('1037', '1', '535', '1', '2016-02-29 00:09:59', NULL, '7', '2015-08-31', NULL),
('1038', '1', '536', '1', '2016-02-29 00:26:03', NULL, '7', '2015-08-31', NULL),
('1039', '1', '537', '1', '2015-08-31 01:48:08', NULL, '7', '2015-08-31', '0'),
('1040', '1', '538', '1', '2015-08-31 01:52:22', NULL, '7', '2015-08-31', '0'),
('1041', '1', '539', '1', '2015-09-02 05:23:19', NULL, '7', '2015-09-02', NULL),
('1042', '1', '540', '1', '2015-09-02 05:24:56', NULL, '7', '2015-09-02', NULL),
('1043', '1', '539', '1', '2015-09-02 05:23:19', 'Voided.\nDocument reentered.', '7', '2015-09-02', '0'),
('1044', '1', '541', '1', '2015-09-02 05:24:56', NULL, '7', '2015-09-02', '0'),
('1045', '1', '540', '1', '2015-09-02 05:24:56', 'Voided.\nDocument reentered.', '7', '2015-09-02', '0'),
('1046', '1', '542', '1', '2015-09-09 05:48:20', NULL, '7', '2015-09-09', '0'),
('1047', '1', '543', '1', '2015-09-09 05:50:54', NULL, '7', '2015-09-09', '0'),
('1048', '1', '544', '1', '2015-09-09 06:00:30', NULL, '7', '2015-09-09', '0'),
('1049', '1', '545', '1', '2015-09-11 03:36:13', NULL, '7', '2015-09-11', '0'),
('1050', '1', '546', '1', '2015-09-22 02:21:37', NULL, '7', '2015-09-22', '0'),
('1051', '1', '547', '1', '2015-09-22 02:28:14', NULL, '7', '2015-09-22', '0'),
('1052', '1', '548', '1', '2015-09-23 01:40:17', NULL, '7', '2015-09-23', '0'),
('1053', '1', '549', '1', '2015-12-30 00:38:54', NULL, '7', '2015-09-30', NULL),
('1054', '1', '550', '1', '2015-12-30 00:40:03', NULL, '7', '2015-09-30', NULL),
('1055', '1', '551', '2', '2016-09-12 03:35:50', 'Edited', '7', '2014-04-16', '4'),
('1056', '1', '552', '2', '2016-01-19 04:39:14', NULL, '7', '2014-04-22', NULL),
('1057', '1', '553', '2', '2016-09-12 03:35:50', NULL, '7', '2014-04-28', '8'),
('1058', '1', '554', '2', '2016-09-12 03:35:50', NULL, '7', '2014-04-28', '9'),
('1059', '2', '104', '2', '2016-09-12 03:35:50', NULL, '7', '2014-04-03', '2'),
('1060', '2', '105', '2', '2016-09-12 03:35:50', NULL, '7', '2014-04-11', '3'),
('1061', '2', '106', '2', '2016-09-12 03:35:50', NULL, '7', '2014-04-28', '10'),
('1062', '1', '555', '2', '2016-09-12 03:35:50', 'Edited', '7', '2014-05-28', '15'),
('1063', '1', '556', '2', '2016-09-12 03:35:50', NULL, '7', '2014-05-28', '16'),
('1064', '1', '557', '2', '2016-09-12 03:35:50', NULL, '7', '2014-05-31', '21'),
('1065', '2', '107', '2', '2016-09-12 03:35:50', NULL, '7', '2014-05-26', '14'),
('1066', '2', '108', '2', '2016-09-12 03:35:50', NULL, '7', '2014-05-28', '17'),
('1067', '2', '109', '2', '2016-09-12 03:35:50', NULL, '7', '2014-05-30', '20'),
('1068', '2', '110', '2', '2016-09-12 03:35:50', NULL, '7', '2014-05-28', '18'),
('1069', '1', '558', '2', '2016-09-12 03:35:50', NULL, '7', '2014-06-17', '22'),
('1070', '1', '559', '2', '2016-09-12 03:35:50', NULL, '7', '2014-06-27', '24'),
('1071', '1', '560', '2', '2016-09-12 03:35:50', NULL, '7', '2014-06-27', '25'),
('1072', '2', '111', '2', '2016-09-12 03:35:50', NULL, '7', '2014-06-20', '23'),
('1073', '2', '112', '2', '2016-09-12 03:35:50', NULL, '7', '2014-06-27', '26'),
('1074', '2', '113', '2', '2016-09-12 03:35:50', NULL, '7', '2014-06-30', '29'),
('1075', '1', '561', '2', '2016-02-15 06:14:06', NULL, '7', '2014-07-01', NULL),
('1076', '1', '562', '2', '2016-09-12 03:35:50', NULL, '7', '2014-07-28', '33'),
('1077', '1', '563', '2', '2016-09-12 03:35:50', NULL, '7', '2014-07-28', '34'),
('1078', '2', '114', '2', '2016-09-12 03:35:50', NULL, '7', '2014-07-18', '30'),
('1079', '2', '115', '2', '2016-09-12 03:35:50', NULL, '7', '2014-07-28', '35'),
('1080', '2', '116', '2', '2016-09-12 03:35:50', NULL, '7', '2014-07-31', '36'),
('1081', '1', '564', '2', '2016-09-12 03:35:50', NULL, '7', '2014-08-27', '44'),
('1082', '1', '565', '2', '2016-09-12 03:35:50', NULL, '7', '2014-08-27', '45'),
('1083', '1', '566', '2', '2016-09-12 03:35:50', NULL, '7', '2014-08-28', '47'),
('1084', '1', '567', '2', '2015-10-01 05:49:15', 'Edited', '7', '2014-08-31', NULL),
('1085', '2', '117', '2', '2016-09-12 03:35:50', NULL, '7', '2014-08-08', '40'),
('1086', '2', '118', '2', '2016-09-12 03:35:50', NULL, '7', '2014-08-12', '41'),
('1087', '2', '119', '2', '2016-09-12 03:35:50', NULL, '7', '2014-08-27', '46'),
('1088', '1', '568', '2', '2015-10-01 01:48:43', NULL, '7', '2014-09-01', NULL),
('1089', '1', '569', '2', '2016-09-12 03:35:50', NULL, '7', '2014-09-29', '53'),
('1090', '1', '570', '2', '2016-09-12 03:35:50', NULL, '7', '2014-09-29', '54'),
('1091', '1', '571', '2', '2016-09-12 03:35:50', NULL, '7', '2014-09-30', '57'),
('1092', '2', '120', '2', '2016-09-12 03:35:50', NULL, '7', '2014-09-04', '49'),
('1093', '2', '121', '2', '2016-09-12 03:35:50', NULL, '7', '2014-09-16', '50'),
('1094', '2', '122', '2', '2016-09-12 03:35:50', NULL, '7', '2014-09-29', '55'),
('1095', '1', '568', '2', '2015-10-01 01:48:43', 'Voided.\n', '7', '2015-10-01', '0'),
('1096', '1', '572', '2', '2016-09-12 03:35:50', NULL, '7', '2014-10-27', '60'),
('1097', '1', '573', '2', '2016-01-19 04:40:10', NULL, '7', '2014-10-27', NULL),
('1098', '2', '123', '2', '2016-09-12 03:35:50', NULL, '7', '2014-10-14', '58'),
('1099', '2', '124', '2', '2016-09-12 03:35:50', NULL, '7', '2014-10-27', '61'),
('1100', '1', '574', '2', '2016-09-12 03:35:50', NULL, '7', '2014-11-27', '67'),
('1101', '1', '575', '2', '2016-09-12 03:35:50', NULL, '7', '2014-11-27', '68'),
('1102', '2', '125', '2', '2016-09-12 03:35:50', NULL, '7', '2014-11-04', '64'),
('1103', '2', '126', '2', '2016-09-12 03:35:50', NULL, '7', '2014-11-26', '66'),
('1104', '2', '127', '2', '2016-09-12 03:35:50', NULL, '7', '2014-11-27', '69'),
('1105', '1', '576', '1', '2015-10-01 02:55:15', NULL, '7', '2015-10-01', '0'),
('1106', '1', '577', '2', '2016-09-12 03:35:50', NULL, '7', '2014-12-17', '73'),
('1107', '1', '578', '2', '2015-10-01 06:03:25', 'Edited', '7', '2014-12-22', NULL),
('1108', '1', '579', '2', '2015-10-01 06:18:34', 'Edited', '7', '2014-12-22', NULL),
('1109', '2', '128', '2', '2015-10-01 03:09:43', NULL, '7', '2014-12-10', NULL),
('1110', '2', '129', '2', '2016-09-12 03:35:50', NULL, '7', '2014-12-10', '72'),
('1111', '2', '128', '2', '2015-10-01 03:09:43', 'Voided.\nDocument reentered.', '7', '2015-10-01', '0'),
('1112', '2', '130', '2', '2016-09-12 03:35:50', NULL, '7', '2014-12-29', '80'),
('1113', '2', '131', '2', '2016-09-12 03:35:50', NULL, '7', '2014-12-22', '75'),
('1114', '1', '580', '2', '2016-09-12 03:35:50', NULL, '7', '2015-01-27', '84'),
('1115', '1', '581', '2', '2016-09-12 03:35:50', NULL, '7', '2015-01-27', '85'),
('1116', '1', '582', '2', '2016-09-12 03:35:50', NULL, '7', '2015-01-30', '89'),
('1117', '2', '132', '2', '2016-09-12 03:35:50', NULL, '7', '2015-01-20', '82'),
('1118', '2', '133', '2', '2016-09-12 03:35:50', NULL, '7', '2015-01-27', '86'),
('1119', '2', '134', '2', '2016-09-12 03:35:50', NULL, '7', '2015-01-29', '88'),
('1120', '1', '583', '2', '2016-09-12 03:35:50', NULL, '7', '2015-02-27', '94'),
('1121', '1', '584', '2', '2016-09-12 03:35:50', NULL, '7', '2015-02-27', '95'),
('1122', '1', '585', '2', '2016-09-12 03:35:50', NULL, '7', '2015-02-28', '97'),
('1123', '2', '135', '2', '2016-09-12 03:35:50', NULL, '7', '2015-02-10', '90'),
('1124', '2', '136', '2', '2016-09-12 03:35:50', NULL, '7', '2015-02-20', '91'),
('1125', '2', '137', '2', '2016-09-12 03:35:50', NULL, '7', '2015-02-24', '92'),
('1126', '2', '138', '2', '2016-09-12 03:35:50', NULL, '7', '2015-02-27', '96'),
('1127', '2', '139', '2', '2016-09-12 03:35:50', NULL, '7', '2015-03-27', '100'),
('1128', '1', '586', '2', '2016-09-12 03:35:50', NULL, '7', '2015-03-27', '101'),
('1129', '1', '587', '2', '2016-09-12 03:35:50', NULL, '7', '2015-03-27', '102'),
('1130', '1', '588', '2', '2015-10-01 05:51:00', NULL, '7', '2014-08-31', NULL),
('1131', '1', '567', '2', '2015-10-01 05:49:15', 'Voided.\nDocument reentered.', '7', '2015-10-01', '0'),
('1132', '1', '588', '2', '2015-10-01 05:51:00', 'Voided.\n', '7', '2015-10-01', '0'),
('1133', '1', '589', '2', '2016-09-12 03:35:50', NULL, '7', '2014-08-31', '48'),
('1134', '1', '578', '2', '2015-10-01 06:03:25', 'Voided.\n', '7', '2015-10-01', '0'),
('1135', '1', '590', '2', '2016-09-12 03:35:50', NULL, '7', '2014-12-22', '76'),
('1136', '1', '579', '2', '2015-10-01 06:18:34', 'Voided.\n', '7', '2015-10-01', '0'),
('1137', '1', '591', '2', '2016-09-12 03:35:50', NULL, '7', '2014-12-22', '77'),
('1138', '1', '592', '1', '2015-10-02 01:10:52', NULL, '7', '2015-10-02', '0'),
('1139', '1', '593', '1', '2015-10-12 06:19:22', NULL, '7', '2015-10-12', '0'),
('1140', '1', '594', '1', '2015-10-13 05:21:32', NULL, '7', '2015-10-13', '0'),
('1141', '1', '595', '1', '2015-11-11 21:48:27', NULL, '7', '2015-10-14', NULL),
('1142', '30', '60', '2', '2015-10-19 06:14:24', NULL, '7', '2014-04-25', '0'),
('1143', '13', '60', '2', '2015-10-19 06:14:25', NULL, '7', '2014-04-25', '0'),
('1144', '10', '60', '2', '2016-09-12 03:35:50', NULL, '7', '2014-04-25', '6'),
('1145', '30', '61', '2', '2015-10-19 06:16:35', NULL, '7', '2014-05-25', '0'),
('1146', '13', '61', '2', '2015-10-19 06:16:35', NULL, '7', '2014-05-25', '0'),
('1147', '10', '61', '2', '2016-09-12 03:35:50', NULL, '7', '2014-05-25', '13'),
('1148', '30', '62', '2', '2015-10-19 06:18:16', NULL, '7', '2014-06-25', '0'),
('1149', '13', '62', '2', '2016-01-13 04:56:07', NULL, '7', '2014-06-25', NULL),
('1150', '10', '62', '2', '2016-01-13 04:56:07', NULL, '7', '2014-06-25', NULL),
('1151', '30', '63', '2', '2015-10-19 06:19:51', NULL, '7', '2014-07-25', '0'),
('1152', '13', '63', '2', '2015-10-21 05:52:08', NULL, '7', '2014-07-25', NULL),
('1153', '10', '63', '2', '2015-10-21 05:52:08', NULL, '7', '2014-07-25', NULL),
('1154', '30', '64', '2', '2015-10-19 06:21:18', NULL, '7', '2014-08-25', '0'),
('1155', '13', '64', '2', '2015-10-19 06:21:18', NULL, '7', '2014-08-25', '0'),
('1156', '10', '64', '2', '2016-09-12 03:35:50', NULL, '7', '2014-08-25', '42'),
('1157', '30', '65', '2', '2015-10-19 06:23:17', NULL, '7', '2014-09-25', '0'),
('1158', '13', '65', '2', '2015-10-19 06:23:17', NULL, '7', '2014-09-25', '0'),
('1159', '10', '65', '2', '2015-10-21 02:12:30', NULL, '7', '2014-09-25', NULL),
('1160', '30', '66', '2', '2015-10-19 06:24:37', NULL, '7', '2014-10-25', '0'),
('1161', '13', '66', '2', '2015-10-19 06:24:37', NULL, '7', '2014-10-25', '0'),
('1162', '10', '66', '2', '2016-09-12 03:35:50', NULL, '7', '2014-10-25', '59'),
('1163', '30', '67', '2', '2015-10-19 06:25:55', NULL, '7', '2014-11-25', '0'),
('1164', '13', '67', '2', '2016-01-13 05:35:57', NULL, '7', '2014-11-25', NULL),
('1165', '10', '67', '2', '2016-01-13 05:35:57', NULL, '7', '2014-11-25', NULL),
('1166', '30', '68', '2', '2015-10-19 06:27:42', NULL, '7', '2014-12-24', '0'),
('1167', '13', '68', '2', '2015-10-19 06:27:42', NULL, '7', '2014-12-24', '0'),
('1168', '10', '68', '2', '2016-09-12 03:35:50', NULL, '7', '2014-12-24', '79'),
('1169', '30', '69', '2', '2015-10-19 06:28:59', NULL, '7', '2015-01-25', '0'),
('1170', '13', '69', '2', '2015-10-19 06:28:59', NULL, '7', '2015-01-25', '0'),
('1171', '10', '69', '2', '2016-09-12 03:35:50', NULL, '7', '2015-01-25', '83'),
('1172', '30', '70', '2', '2015-10-19 06:29:56', NULL, '7', '2015-02-25', '0'),
('1173', '13', '70', '2', '2015-10-19 06:29:56', NULL, '7', '2015-02-25', '0'),
('1174', '10', '70', '2', '2016-09-12 03:35:50', NULL, '7', '2015-02-25', '93'),
('1175', '2', '140', '2', '2016-07-27 07:02:09', NULL, '7', '2015-10-19', NULL),
('1176', '30', '71', '2', '2015-10-20 05:53:20', NULL, '7', '2015-10-20', '0'),
('1177', '13', '71', '2', '2015-10-20 06:00:18', NULL, '7', '2015-10-20', NULL),
('1178', '10', '71', '2', '2015-10-20 06:00:19', NULL, '7', '2015-10-20', NULL),
('1179', '13', '71', '2', '2015-10-20 06:00:18', 'Voided.', '7', '2015-10-20', '0'),
('1180', '10', '71', '2', '2015-10-20 06:00:19', 'Voided.\n', '7', '2015-10-20', '0'),
('1181', '10', '65', '1', '2016-09-12 03:35:50', 'Updated.', '7', '2014-09-25', '52'),
('1182', '30', '72', '2', '2015-10-21 02:35:41', NULL, '7', '2015-03-25', '0'),
('1183', '13', '72', '2', '2015-10-21 02:35:41', NULL, '7', '2015-03-25', '0'),
('1184', '10', '72', '2', '2016-09-12 03:35:50', NULL, '7', '2015-03-25', '99'),
('1185', '12', '57', '2', '2015-10-29 05:54:30', NULL, '7', '2014-04-28', NULL),
('1186', '12', '58', '2', '2016-09-12 03:35:50', NULL, '7', '2014-05-28', '19'),
('1187', '12', '59', '2', '2016-01-13 04:52:18', NULL, '7', '2014-06-28', NULL),
('1188', '12', '60', '2', '2015-10-29 06:19:58', NULL, '7', '2014-08-28', NULL),
('1189', '12', '61', '2', '2015-10-29 06:21:09', NULL, '7', '2014-09-28', NULL),
('1190', '12', '62', '2', '2016-09-12 03:35:50', NULL, '7', '2014-10-28', '63'),
('1191', '12', '63', '2', '2016-01-13 06:14:35', NULL, '7', '2014-11-28', NULL),
('1192', '12', '64', '2', '2015-10-29 06:22:48', NULL, '7', '2014-12-28', NULL),
('1193', '12', '65', '2', '2016-09-12 03:35:50', NULL, '7', '2015-01-28', '87'),
('1194', '12', '66', '2', '2016-09-12 03:35:50', NULL, '7', '2015-02-28', '98'),
('1195', '12', '67', '2', '2016-01-13 06:53:45', NULL, '7', '2015-03-28', NULL),
('1196', '13', '63', '1', '2015-10-21 05:52:08', 'Voided.', '7', '2015-10-21', '0'),
('1197', '10', '63', '1', '2015-10-21 05:52:08', 'Voided.\n', '7', '2015-10-21', '0'),
('1198', '30', '73', '2', '2015-10-21 05:59:08', NULL, '7', '2014-07-25', '0'),
('1199', '13', '73', '2', '2016-01-13 05:35:30', NULL, '7', '2014-07-25', NULL),
('1200', '10', '73', '2', '2016-01-13 05:35:30', NULL, '7', '2014-07-25', NULL),
('1201', '12', '68', '2', '2015-10-29 06:18:12', NULL, '7', '2014-07-28', NULL),
('1202', '2', '141', '2', '2015-10-22 06:47:51', NULL, '7', '2014-06-28', NULL),
('1203', '0', '43', '1', '2015-10-29 05:39:54', NULL, '7', '2014-06-28', NULL),
('1204', '2', '142', '1', '2015-10-30 01:21:38', NULL, '7', '2014-06-28', NULL),
('1205', '2', '141', '1', '2015-10-22 06:47:51', 'Voided.\nDocument reentered.', '7', '2015-10-22', '0'),
('1206', '1', '596', '1', '2015-10-26 02:10:47', NULL, '7', '2015-10-26', '0'),
('1207', '1', '597', '1', '2015-10-28 01:13:26', NULL, '7', '2015-10-28', '0'),
('1208', '1', '598', '1', '2015-10-28 03:21:48', NULL, '7', '2015-10-28', '0'),
('1209', '0', '43', '1', '2015-10-29 05:39:54', 'Voided.\n', '7', '2015-10-29', '0'),
('1210', '12', '57', '1', '2016-09-12 03:35:50', 'Updated.', '7', '2014-04-25', '7'),
('1211', '12', '68', '2', '2016-01-13 06:13:17', 'Updated.', '7', '2014-07-25', NULL),
('1212', '12', '60', '2', '2016-09-12 03:35:50', 'Updated.', '7', '2014-08-25', '43'),
('1213', '12', '61', '2', '2015-10-29 21:46:45', 'Updated.', '7', '2014-09-25', NULL),
('1214', '12', '64', '2', '2015-10-29 06:37:37', 'Updated.', '7', '2014-12-25', NULL),
('1215', '12', '64', '2', '2015-10-30 00:05:03', 'Updated.', '7', '2014-12-29', NULL),
('1216', '1', '599', '1', '2016-02-29 00:12:27', NULL, '7', '2015-10-29', NULL),
('1217', '1', '600', '1', '2016-02-29 00:20:32', NULL, '7', '2015-10-29', NULL),
('1218', '12', '61', '2', '2016-09-12 03:35:50', 'Updated.', '7', '2014-09-29', '56'),
('1219', '12', '64', '2', '2015-10-30 00:08:23', 'Updated.', '7', '2014-12-28', NULL),
('1220', '12', '64', '2', '2016-09-12 03:35:50', 'Updated.', '7', '2014-12-29', '81'),
('1221', '2', '142', '1', '2015-10-30 01:21:38', 'Voided.\n', '7', '2015-10-30', '0'),
('1222', '1', '601', '1', '2016-07-27 05:42:21', NULL, '7', '2015-09-29', NULL),
('1223', '1', '602', '1', '2015-11-05 05:18:50', NULL, '7', '2015-11-05', '0'),
('1224', '1', '603', '1', '2015-11-05 05:22:18', NULL, '7', '2015-11-05', '0'),
('1225', '1', '604', '1', '2015-11-11 04:53:00', NULL, '7', '2015-11-11', '0'),
('1226', '1', '605', '1', '2015-11-11 21:48:27', NULL, '7', '2015-10-14', '0'),
('1227', '1', '595', '1', '2015-11-11 21:48:27', 'Voided.\nDocument reentered.', '7', '2015-11-11', '0'),
('1228', '1', '606', '1', '2015-11-13 00:55:59', NULL, '7', '2015-11-13', '0'),
('1229', '1', '607', '1', '2015-11-23 22:40:24', NULL, '7', '2015-11-24', '0'),
('1230', '1', '608', '1', '2015-11-30 23:03:25', NULL, '7', '2015-12-01', '0'),
('1231', '1', '609', '1', '2016-02-29 00:19:04', NULL, '7', '2015-12-02', NULL),
('1232', '1', '610', '1', '2015-12-02 00:25:23', NULL, '7', '2015-12-02', NULL),
('1233', '1', '611', '1', '2016-02-29 00:13:53', NULL, '7', '2015-12-02', NULL),
('1234', '1', '610', '1', '2015-12-02 00:25:23', 'Voided.\nDocument reentered.', '7', '2015-12-02', '0'),
('1235', '1', '612', '1', '2015-12-04 02:26:49', NULL, '7', '2015-12-04', '0'),
('1236', '1', '613', '1', '2016-01-28 02:47:34', NULL, '7', '2015-12-04', NULL),
('1237', '1', '614', '1', '2015-12-11 05:40:27', NULL, '7', '2015-12-11', '0'),
('1238', '1', '615', '1', '2015-12-11 05:43:36', NULL, '7', '2015-12-11', '0'),
('1239', '1', '616', '1', '2015-12-21 00:51:57', NULL, '7', '2015-12-21', '0'),
('1240', '1', '617', '1', '2016-02-28 23:51:04', NULL, '7', '2015-12-30', NULL),
('1241', '1', '618', '1', '2016-02-28 23:51:39', NULL, '7', '2015-12-30', NULL),
('1242', '1', '619', '1', '2016-02-29 00:11:12', NULL, '7', '2015-09-30', NULL),
('1243', '1', '549', '1', '2015-12-30 00:38:54', 'Voided.\nDocument reentered.', '7', '2015-12-30', '0'),
('1244', '1', '620', '1', '2016-02-29 00:22:58', NULL, '7', '2015-09-30', NULL),
('1245', '1', '550', '1', '2015-12-30 00:40:03', 'Voided.\nDocument reentered.', '7', '2015-12-30', '0'),
('1246', '1', '621', '1', '2016-09-12 03:35:50', 'Edited', '7', '2014-07-31', '37'),
('1247', '1', '622', '1', '2015-12-31 05:38:27', NULL, '7', '2014-08-05', NULL),
('1248', '1', '623', '1', '2015-12-31 05:41:02', NULL, '7', '2014-08-05', NULL),
('1249', '1', '624', '1', '2015-12-31 05:41:53', NULL, '7', '2014-09-16', NULL),
('1250', '1', '625', '1', '2015-12-31 05:42:23', NULL, '7', '2014-11-14', NULL),
('1251', '1', '626', '1', '2015-12-31 05:42:47', NULL, '7', '2014-12-12', NULL),
('1252', '1', '627', '1', '2015-12-31 05:43:17', NULL, '7', '2014-12-23', NULL),
('1253', '1', '628', '1', '2015-12-31 05:40:16', NULL, '7', '2014-08-05', NULL),
('1254', '1', '622', '1', '2015-12-31 05:38:27', 'Voided.\nDocument reentered.', '7', '2015-12-31', '0'),
('1255', '1', '629', '1', '2015-12-31 05:58:16', NULL, '7', '2014-08-05', NULL),
('1256', '1', '628', '1', '2015-12-31 05:40:16', 'Voided.\nDocument reentered.', '7', '2015-12-31', '0'),
('1257', '1', '630', '1', '2016-09-12 03:35:50', NULL, '7', '2014-08-05', '38'),
('1258', '1', '623', '1', '2015-12-31 05:41:02', 'Voided.\nDocument reentered.', '7', '2015-12-31', '0'),
('1259', '1', '631', '1', '2016-09-12 03:35:50', NULL, '7', '2014-09-16', '51'),
('1260', '1', '624', '1', '2015-12-31 05:41:53', 'Voided.\nDocument reentered.', '7', '2015-12-31', '0'),
('1261', '1', '632', '1', '2016-09-12 03:35:50', NULL, '7', '2014-11-14', '65'),
('1262', '1', '625', '1', '2015-12-31 05:42:23', 'Voided.\nDocument reentered.', '7', '2015-12-31', '0'),
('1263', '1', '633', '1', '2016-02-12 00:53:13', NULL, '7', '2014-12-12', NULL),
('1264', '1', '626', '1', '2015-12-31 05:42:47', 'Voided.\nDocument reentered.', '7', '2015-12-31', '0'),
('1265', '1', '634', '1', '2016-02-12 00:52:03', NULL, '7', '2014-12-23', NULL);
INSERT INTO `1_audit_trail` VALUES
('1266', '1', '627', '1', '2015-12-31 05:43:17', 'Voided.\nDocument reentered.', '7', '2015-12-31', '0'),
('1267', '1', '635', '1', '2016-09-12 03:35:50', NULL, '7', '2014-08-05', '39'),
('1268', '1', '629', '1', '2015-12-31 05:58:16', 'Voided.\nDocument reentered.', '7', '2015-12-31', '0'),
('1269', '1', '636', '1', '2016-01-04 06:06:42', NULL, '7', '2014-08-05', NULL),
('1270', '1', '371', '1', '2015-12-31 05:59:57', 'Voided.\nDocument reentered.', '7', '2015-12-31', '0'),
('1271', '30', '74', '1', '2016-01-04 05:53:14', NULL, '7', '2014-12-29', '0'),
('1272', '13', '74', '1', '2016-01-13 06:08:34', NULL, '7', '2014-12-29', NULL),
('1273', '10', '74', '1', '2016-01-13 06:08:34', NULL, '7', '2014-12-29', NULL),
('1274', '12', '69', '1', '2016-01-13 06:15:00', NULL, '7', '2014-12-29', NULL),
('1275', '1', '636', '1', '2016-01-04 06:06:42', 'Voided.\n', '7', '2016-01-04', '0'),
('1276', '1', '637', '1', '2016-01-06 05:08:23', NULL, '7', '2016-01-06', '0'),
('1277', '1', '638', '1', '2016-01-06 05:10:15', NULL, '7', '2016-01-06', '0'),
('1278', '1', '639', '1', '2016-01-12 04:21:49', NULL, '7', '2016-01-12', '0'),
('1279', '12', '59', '1', '2016-01-13 04:52:18', 'Voided.\n', '7', '2016-01-13', '0'),
('1280', '13', '62', '1', '2016-01-13 04:56:07', 'Voided.', '7', '2016-01-13', '0'),
('1281', '10', '62', '1', '2016-01-13 04:56:07', 'Voided.\n', '7', '2016-01-13', '0'),
('1282', '13', '73', '1', '2016-01-13 05:35:30', 'Voided.', '7', '2016-01-13', '0'),
('1283', '10', '73', '1', '2016-01-13 05:35:30', 'Voided.\n', '7', '2016-01-13', '0'),
('1284', '13', '67', '1', '2016-01-13 05:35:57', 'Voided.', '7', '2016-01-13', '0'),
('1285', '10', '67', '1', '2016-01-13 05:35:57', 'Voided.\n', '7', '2016-01-13', '0'),
('1286', '30', '75', '1', '2016-01-13 05:37:22', NULL, '7', '2014-06-28', '0'),
('1287', '13', '75', '1', '2016-01-13 05:37:22', NULL, '7', '2014-06-28', '0'),
('1288', '10', '75', '1', '2016-09-12 03:35:50', NULL, '7', '2014-06-28', '27'),
('1289', '30', '76', '1', '2016-01-13 05:38:01', NULL, '7', '2014-07-25', '0'),
('1290', '13', '76', '1', '2016-01-13 05:38:02', NULL, '7', '2014-07-25', '0'),
('1291', '10', '76', '1', '2016-09-12 03:35:50', NULL, '7', '2014-07-25', '31'),
('1292', '30', '77', '1', '2016-01-13 05:38:35', NULL, '7', '2014-11-28', '0'),
('1293', '13', '77', '1', '2016-01-13 05:38:35', NULL, '7', '2014-11-28', '0'),
('1294', '10', '77', '1', '2016-09-12 03:35:50', NULL, '7', '2014-11-28', '70'),
('1295', '12', '70', '1', '2016-09-12 03:35:50', NULL, '7', '2014-06-28', '28'),
('1296', '12', '71', '1', '2016-09-12 03:35:50', NULL, '7', '2014-07-25', '32'),
('1297', '12', '72', '1', '2016-09-12 03:35:50', NULL, '7', '2014-11-28', '71'),
('1298', '13', '74', '1', '2016-01-13 06:08:34', 'Voided.', '7', '2016-01-13', '0'),
('1299', '10', '74', '1', '2016-01-13 06:08:34', 'Voided.\n', '7', '2016-01-13', '0'),
('1300', '12', '68', '1', '2016-01-13 06:13:17', 'Voided.\n', '7', '2016-01-13', '0'),
('1301', '12', '63', '1', '2016-01-13 06:14:35', 'Voided.\n', '7', '2016-01-13', '0'),
('1302', '12', '69', '1', '2016-01-13 06:15:00', 'Voided.\n', '7', '2016-01-13', '0'),
('1303', '11', '2', '1', '2016-01-13 06:51:34', NULL, '7', '2016-03-28', NULL),
('1304', '11', '2', '1', '2016-01-13 06:51:34', 'Voided.\n', '7', '2016-01-13', '0'),
('1305', '11', '3', '1', '2016-09-12 03:35:50', NULL, '7', '2015-03-28', '103'),
('1306', '12', '67', '1', '2016-09-12 03:35:50', 'Updated.', '7', '2015-03-28', '104'),
('1307', '1', '640', '1', '2016-01-18 05:00:55', NULL, '7', '2016-01-18', '0'),
('1308', '1', '641', '1', '2016-09-12 03:35:50', NULL, '7', '2014-04-22', '5'),
('1309', '1', '552', '1', '2016-01-19 04:39:14', 'Voided.\nDocument reentered.', '7', '2016-01-19', '0'),
('1310', '1', '642', '1', '2016-09-12 03:35:50', NULL, '7', '2014-10-27', '62'),
('1311', '1', '573', '1', '2016-01-19 04:40:10', 'Voided.\nDocument reentered.', '7', '2016-01-19', '0'),
('1312', '0', '45', '1', '2016-09-12 03:35:50', NULL, '7', '2015-03-31', '105'),
('1313', '1', '643', '1', '2016-09-12 03:35:50', NULL, '7', '2014-04-29', '11'),
('1314', '1', '318', '1', '2016-01-19 06:09:31', 'Voided.\nDocument reentered.', '7', '2016-01-19', '0'),
('1315', '1', '644', '1', '2016-09-12 03:35:50', NULL, '7', '2014-04-29', '12'),
('1316', '1', '319', '1', '2016-01-19 06:09:57', 'Voided.\nDocument reentered.', '7', '2016-01-19', '0'),
('1317', '2', '143', '1', '2016-07-27 05:34:59', NULL, '7', '2016-01-25', NULL),
('1318', '1', '645', '1', '2016-01-25 02:55:03', NULL, '7', '2016-01-25', '0'),
('1319', '1', '646', '1', '2016-01-26 02:21:56', NULL, '7', '2016-01-26', '0'),
('1320', '1', '647', '1', '2016-01-26 02:23:10', NULL, '7', '2016-01-26', '0'),
('1321', '1', '648', '1', '2016-01-28 00:50:56', NULL, '7', '2016-01-28', '0'),
('1322', '1', '649', '1', '2016-01-28 02:43:01', NULL, '7', '2016-01-28', NULL),
('1323', '1', '650', '1', '2016-01-28 01:39:34', NULL, '7', '2016-01-28', NULL),
('1324', '1', '651', '1', '2016-01-28 02:44:49', NULL, '7', '2016-01-28', NULL),
('1325', '1', '652', '1', '2016-01-28 02:55:41', NULL, '7', '2016-01-28', NULL),
('1326', '1', '653', '1', '2016-01-28 01:33:38', NULL, '7', '2016-01-28', '0'),
('1327', '1', '654', '1', '2016-01-28 01:35:24', NULL, '7', '2016-01-28', '0'),
('1328', '1', '655', '1', '2016-01-28 01:37:16', NULL, '7', '2016-01-28', '0'),
('1329', '1', '656', '1', '2016-01-28 02:44:11', NULL, '7', '2016-01-28', NULL),
('1330', '1', '650', '1', '2016-01-28 01:39:34', 'Voided.\nDocument reentered.', '7', '2016-01-28', '0'),
('1331', '1', '657', '1', '2016-01-28 02:46:01', NULL, '7', '2016-01-28', NULL),
('1332', '1', '649', '1', '2016-01-28 02:43:01', 'Voided.\nDocument reentered.', '7', '2016-01-28', '0'),
('1333', '1', '658', '1', '2016-01-28 02:44:11', NULL, '7', '2016-01-28', '0'),
('1334', '1', '656', '1', '2016-01-28 02:44:11', 'Voided.\nDocument reentered.', '7', '2016-01-28', '0'),
('1335', '1', '659', '1', '2016-01-28 02:44:49', NULL, '7', '2016-01-28', '0'),
('1336', '1', '651', '1', '2016-01-28 02:44:49', 'Voided.\nDocument reentered.', '7', '2016-01-28', '0'),
('1337', '1', '660', '1', '2016-02-16 05:16:38', NULL, '7', '2016-01-28', NULL),
('1338', '1', '657', '1', '2016-01-28 02:46:01', 'Voided.\nDocument reentered.', '7', '2016-01-28', '0'),
('1339', '1', '661', '1', '2016-03-01 02:55:29', 'Edited', '7', '2015-12-04', '0'),
('1340', '1', '613', '1', '2016-01-28 02:47:34', 'Voided.\nDocument reentered.', '7', '2016-01-28', '0'),
('1341', '1', '662', '1', '2016-01-28 02:55:40', NULL, '7', '2016-01-28', '0'),
('1342', '1', '652', '1', '2016-01-28 02:55:41', 'Voided.\nDocument reentered.', '7', '2016-01-28', '0'),
('1343', '1', '663', '1', '2016-02-28 23:49:06', NULL, '7', '2016-01-29', NULL),
('1344', '1', '664', '1', '2016-02-28 23:48:20', NULL, '7', '2016-01-29', NULL),
('1345', '1', '665', '1', '2016-02-05 00:45:22', NULL, '7', '2016-02-05', NULL),
('1346', '1', '666', '1', '2016-02-05 00:45:22', NULL, '7', '2016-02-05', '0'),
('1347', '1', '665', '1', '2016-02-05 00:45:22', 'Voided.\nDocument reentered.', '7', '2016-02-05', '0'),
('1348', '0', '46', '1', '2016-02-05 05:17:27', NULL, '7', '2015-03-31', NULL),
('1349', '30', '78', '1', '2016-02-05 04:34:31', NULL, '7', '2015-12-20', '0'),
('1350', '13', '78', '1', '2016-02-05 04:46:06', NULL, '7', '2015-12-20', NULL),
('1351', '10', '78', '1', '2016-02-05 04:36:37', NULL, '7', '2015-12-20', NULL),
('1352', '10', '78', '1', '2016-02-05 04:46:06', 'Updated.', '7', '2015-12-20', NULL),
('1353', '0', '47', '1', '2016-09-12 03:35:50', NULL, '7', '2015-03-31', '106'),
('1354', '1', '667', '1', '2016-09-12 03:35:50', 'Edited', '7', '2015-03-31', '107'),
('1355', '30', '79', '1', '2016-02-05 04:39:28', NULL, '7', '2014-12-21', '0'),
('1356', '13', '79', '1', '2016-02-05 04:46:20', NULL, '7', '2014-12-21', NULL),
('1357', '10', '79', '1', '2016-02-05 04:42:49', NULL, '7', '2014-12-21', NULL),
('1358', '10', '79', '1', '2016-02-05 04:46:20', 'Updated.', '7', '2014-12-21', NULL),
('1359', '30', '80', '1', '2016-02-05 04:45:06', NULL, '7', '2014-12-21', '0'),
('1360', '13', '80', '1', '2016-02-05 04:45:06', NULL, '7', '2014-12-21', '0'),
('1361', '10', '80', '1', '2016-09-12 03:35:50', NULL, '7', '2014-12-21', '74'),
('1362', '13', '78', '1', '2016-02-05 04:46:06', 'Voided.', '7', '2016-02-05', '0'),
('1363', '10', '78', '1', '2016-02-05 04:46:06', 'Voided.\n', '7', '2016-02-05', '0'),
('1364', '13', '79', '1', '2016-02-05 04:46:20', 'Voided.', '7', '2016-02-05', '0'),
('1365', '10', '79', '1', '2016-02-05 04:46:20', 'Voided.\n', '7', '2016-02-05', '0'),
('1366', '12', '73', '1', '2016-09-12 03:35:50', NULL, '7', '2014-12-23', '78'),
('1367', '0', '48', '1', '2016-02-05 04:56:14', NULL, '7', '2015-04-01', NULL),
('1368', '0', '48', '1', '2016-09-12 03:35:50', NULL, '7', '2014-04-01', '1'),
('1369', '0', '46', '1', '2016-09-12 03:35:50', NULL, '7', '2015-03-31', '108'),
('1370', '1', '668', '1', '2016-02-08 23:37:41', NULL, '7', '2016-02-09', '0'),
('1371', '1', '669', '1', '2016-02-08 23:39:05', NULL, '7', '2016-02-09', '0'),
('1372', '1', '670', '1', '2016-02-09 00:36:24', NULL, '7', '2016-02-09', '0'),
('1373', '1', '671', '1', '2016-02-15 06:08:41', 'Edited', '7', '2016-12-02', '0'),
('1374', '1', '634', '1', '2016-02-12 00:52:03', 'Voided.\nDocument reentered.', '7', '2016-02-12', '0'),
('1375', '1', '672', '1', '2016-02-15 06:09:20', 'Edited', '7', '2016-12-02', '0'),
('1376', '1', '633', '1', '2016-02-12 00:53:13', 'Voided.\nDocument reentered.', '7', '2016-02-12', '0'),
('1377', '0', '49', '1', '2016-09-12 03:35:50', NULL, '7', '2015-03-31', '109'),
('1378', '0', '50', '1', '2016-02-15 06:27:28', NULL, '7', '2015-03-31', NULL),
('1379', '1', '673', '1', '2016-02-15 02:02:59', NULL, '7', '2016-02-15', '0'),
('1380', '1', '674', '1', '2016-02-15 04:27:29', NULL, '7', '2016-02-15', '0'),
('1381', '1', '675', '1', '2016-02-15 04:31:32', NULL, '7', '2016-02-15', NULL),
('1382', '1', '676', '1', '2016-02-15 04:31:32', NULL, '7', '2016-02-15', '0'),
('1383', '1', '675', '1', '2016-02-15 04:31:32', 'Voided.\nDocument reentered.', '7', '2016-02-15', '0'),
('1384', '1', '561', '1', '2016-02-15 06:14:06', 'Voided.\n', '7', '2016-02-15', '0'),
('1385', '0', '50', '1', '2016-09-12 03:35:50', NULL, '7', '2015-03-31', '110'),
('1386', '0', '51', '1', '2016-09-12 03:28:58', NULL, '7', '2015-03-31', NULL),
('1387', '1', '677', '1', '2016-02-16 05:16:38', NULL, '7', '2016-02-16', '0'),
('1388', '1', '660', '1', '2016-02-16 05:16:38', 'Voided.\nDocument reentered.', '7', '2016-02-16', '0'),
('1389', '1', '678', '1', '2016-02-28 23:42:17', NULL, '7', '2016-02-29', '0'),
('1390', '1', '679', '1', '2016-02-28 23:43:06', NULL, '7', '2016-02-29', '0'),
('1391', '1', '680', '1', '2016-02-28 23:48:20', NULL, '7', '2016-01-29', '0'),
('1392', '1', '664', '1', '2016-02-28 23:48:20', 'Voided.\nDocument reentered.', '7', '2016-02-28', '0'),
('1393', '1', '681', '1', '2016-02-28 23:49:06', NULL, '7', '2016-01-29', '0'),
('1394', '1', '663', '1', '2016-02-28 23:49:06', 'Voided.\nDocument reentered.', '7', '2016-02-28', '0'),
('1395', '1', '682', '1', '2016-02-28 23:51:04', NULL, '7', '2015-12-30', '0'),
('1396', '1', '617', '1', '2016-02-28 23:51:04', 'Voided.\nDocument reentered.', '7', '2016-02-28', '0'),
('1397', '1', '683', '1', '2016-02-28 23:51:39', NULL, '7', '2015-12-30', '0'),
('1398', '1', '618', '1', '2016-02-28 23:51:39', 'Voided.\nDocument reentered.', '7', '2016-02-28', '0'),
('1399', '1', '684', '1', '2016-02-29 00:04:00', NULL, '7', '2015-04-29', '0'),
('1400', '1', '505', '1', '2016-02-29 00:04:01', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1401', '1', '685', '1', '2016-02-29 00:05:42', NULL, '7', '2015-06-01', '0'),
('1402', '1', '511', '1', '2016-02-29 00:05:43', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1403', '1', '686', '1', '2016-02-29 00:07:00', NULL, '7', '2015-06-30', '0'),
('1404', '1', '519', '1', '2016-02-29 00:07:00', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1405', '1', '687', '1', '2016-02-29 00:08:50', NULL, '7', '2015-07-29', '0'),
('1406', '1', '528', '1', '2016-02-29 00:08:50', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1407', '1', '688', '1', '2016-02-29 00:09:59', NULL, '7', '2015-08-31', '0'),
('1408', '1', '535', '1', '2016-02-29 00:09:59', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1409', '1', '689', '1', '2016-02-29 00:11:12', NULL, '7', '2015-09-30', '0'),
('1410', '1', '619', '1', '2016-02-29 00:11:12', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1411', '1', '690', '1', '2016-02-29 00:12:27', NULL, '7', '2015-10-29', '0'),
('1412', '1', '599', '1', '2016-02-29 00:12:27', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1413', '1', '691', '1', '2016-02-29 00:13:53', NULL, '7', '2015-12-02', '0'),
('1414', '1', '611', '1', '2016-02-29 00:13:53', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1415', '1', '692', '1', '2016-02-29 00:19:04', NULL, '7', '2015-12-02', '0'),
('1416', '1', '609', '1', '2016-02-29 00:19:04', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1417', '1', '693', '1', '2016-02-29 00:20:32', NULL, '7', '2015-10-29', '0'),
('1418', '1', '600', '1', '2016-02-29 00:20:32', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1419', '1', '694', '1', '2016-02-29 00:22:57', NULL, '7', '2015-09-30', '0'),
('1420', '1', '620', '1', '2016-02-29 00:22:58', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1421', '1', '695', '1', '2016-02-29 00:26:03', NULL, '7', '2015-08-31', '0'),
('1422', '1', '536', '1', '2016-02-29 00:26:03', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1423', '1', '696', '1', '2016-02-29 00:27:44', NULL, '7', '2015-07-29', '0'),
('1424', '1', '529', '1', '2016-02-29 00:27:44', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1425', '1', '697', '1', '2016-02-29 00:29:10', NULL, '7', '2015-06-30', '0'),
('1426', '1', '520', '1', '2016-02-29 00:29:10', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1427', '1', '698', '1', '2016-02-29 00:30:42', NULL, '7', '2015-06-01', '0'),
('1428', '1', '512', '1', '2016-02-29 00:30:42', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1429', '1', '699', '1', '2016-02-29 00:32:44', NULL, '7', '2015-04-29', '0'),
('1430', '1', '504', '1', '2016-02-29 00:32:44', 'Voided.\nDocument reentered.', '7', '2016-02-29', '0'),
('1431', '1', '700', '1', '2016-03-02 04:48:18', NULL, '7', '2016-03-02', '0'),
('1432', '1', '701', '1', '2016-03-02 22:06:25', NULL, '7', '2016-03-02', '0'),
('1433', '1', '702', '1', '2016-03-07 03:57:06', NULL, '7', '2016-03-07', '0'),
('1434', '1', '703', '1', '2016-03-07 04:00:31', NULL, '7', '2016-03-07', '0'),
('1435', '1', '704', '1', '2016-03-07 04:01:33', NULL, '7', '2016-03-07', '0'),
('1436', '1', '705', '1', '2016-09-06 06:39:01', NULL, '7', '2016-03-09', NULL),
('1437', '1', '706', '1', '2016-03-15 03:15:13', NULL, '7', '2016-03-15', '0'),
('1438', '1', '707', '1', '2016-03-16 03:22:07', NULL, '7', '2016-03-16', '0'),
('1439', '1', '708', '1', '2016-09-12 03:49:37', 'Edited', '7', '2016-03-16', '0'),
('1440', '1', '709', '1', '2016-03-25 01:00:59', NULL, '7', '2016-03-25', '0'),
('1441', '1', '710', '1', '2016-03-25 01:03:17', NULL, '7', '2016-03-25', '0'),
('1442', '1', '711', '1', '2016-03-31 00:53:32', NULL, '7', '2016-03-31', '0'),
('1443', '1', '712', '1', '2016-03-31 00:54:27', NULL, '7', '2016-03-31', '0'),
('1444', '1', '713', '1', '2016-03-31 04:01:29', NULL, '7', '2016-03-31', '0'),
('1445', '1', '714', '1', '2016-03-31 06:24:28', NULL, '7', '2016-03-31', '0'),
('1446', '1', '715', '1', '2016-04-20 01:37:10', NULL, '8', '2016-04-20', '0'),
('1447', '1', '716', '1', '2016-04-20 01:38:26', NULL, '8', '2016-04-20', '0'),
('1448', '1', '717', '1', '2016-04-22 06:03:54', NULL, '8', '2016-04-22', '0'),
('1449', '1', '718', '1', '2016-04-27 23:42:49', NULL, '8', '2016-04-27', '0'),
('1450', '1', '719', '1', '2016-04-28 02:53:12', NULL, '8', '2016-04-28', '0'),
('1451', '1', '720', '1', '2016-04-28 02:54:01', NULL, '8', '2016-04-28', '0'),
('1452', '30', '81', '1', '2016-04-28 06:30:28', NULL, '8', '2015-04-20', '0'),
('1453', '13', '81', '1', '2016-09-29 04:17:11', NULL, '8', '2015-04-20', NULL),
('1454', '10', '81', '1', '2016-09-29 04:17:11', NULL, '8', '2015-04-20', NULL),
('1455', '12', '74', '1', '2016-09-29 05:27:01', NULL, '8', '2015-04-28', NULL),
('1456', '30', '82', '1', '2016-04-28 23:32:54', NULL, '8', '2015-05-20', '0'),
('1457', '13', '82', '1', '2016-09-29 04:19:48', NULL, '8', '2015-05-20', NULL),
('1458', '10', '82', '1', '2016-09-29 04:19:48', NULL, '8', '2015-05-20', NULL),
('1459', '30', '83', '1', '2016-04-28 23:33:34', NULL, '8', '2015-06-20', '0'),
('1460', '13', '83', '1', '2016-09-29 04:49:50', NULL, '8', '2015-06-20', NULL),
('1461', '10', '83', '1', '2016-09-29 04:49:50', NULL, '8', '2015-06-20', NULL),
('1462', '30', '84', '1', '2016-04-28 23:34:04', NULL, '8', '2015-07-20', '0'),
('1463', '13', '84', '1', '2016-09-29 04:52:08', NULL, '8', '2015-07-20', NULL),
('1464', '10', '84', '1', '2016-09-29 04:52:08', NULL, '8', '2015-07-20', NULL),
('1465', '30', '85', '1', '2016-04-28 23:34:42', NULL, '8', '2015-08-20', '0'),
('1466', '13', '85', '1', '2016-09-29 04:54:59', NULL, '8', '2015-08-20', NULL),
('1467', '10', '85', '1', '2016-09-29 04:54:59', NULL, '8', '2015-08-20', NULL),
('1468', '30', '86', '1', '2016-04-28 23:38:03', NULL, '8', '2015-09-20', '0'),
('1469', '13', '86', '1', '2016-09-29 04:56:42', NULL, '8', '2015-09-20', NULL),
('1470', '10', '86', '1', '2016-09-29 04:56:42', NULL, '8', '2015-09-20', NULL),
('1471', '30', '87', '1', '2016-04-28 23:38:42', NULL, '8', '2015-10-20', '0'),
('1472', '13', '87', '1', '2016-09-29 04:58:00', NULL, '8', '2015-10-20', NULL),
('1473', '10', '87', '1', '2016-09-29 04:58:00', NULL, '8', '2015-10-20', NULL),
('1474', '30', '88', '1', '2016-04-28 23:43:31', NULL, '8', '2015-11-20', '0'),
('1475', '13', '88', '1', '2016-09-29 04:59:12', NULL, '8', '2015-11-20', NULL),
('1476', '10', '88', '1', '2016-09-29 04:59:12', NULL, '8', '2015-11-20', NULL),
('1477', '30', '89', '1', '2016-04-28 23:44:04', NULL, '8', '2015-12-20', '0'),
('1478', '13', '89', '1', '2016-09-29 05:00:33', NULL, '8', '2015-12-20', NULL),
('1479', '10', '89', '1', '2016-09-29 05:00:33', NULL, '8', '2015-12-20', NULL),
('1480', '30', '90', '1', '2016-04-28 23:44:48', NULL, '8', '2016-01-20', '0'),
('1481', '13', '90', '1', '2016-09-29 05:01:47', NULL, '8', '2016-01-20', NULL),
('1482', '10', '90', '1', '2016-09-29 05:01:47', NULL, '8', '2016-01-20', NULL),
('1483', '30', '91', '1', '2016-04-28 23:45:29', NULL, '8', '2016-02-20', '0'),
('1484', '13', '91', '1', '2016-09-29 05:03:07', NULL, '8', '2016-02-20', NULL),
('1485', '10', '91', '1', '2016-09-29 05:03:07', NULL, '8', '2016-02-20', NULL),
('1486', '30', '92', '1', '2016-04-28 23:46:15', NULL, '8', '2016-03-20', '0'),
('1487', '13', '92', '1', '2016-09-29 05:04:20', NULL, '8', '2016-03-20', NULL),
('1488', '10', '92', '1', '2016-09-29 05:04:20', NULL, '8', '2016-03-20', NULL),
('1489', '12', '75', '1', '2016-09-13 02:18:28', NULL, '8', '2015-05-25', NULL),
('1490', '12', '76', '1', '2016-09-19 01:47:47', NULL, '8', '2015-06-25', NULL),
('1491', '12', '77', '1', '2016-09-19 02:14:20', NULL, '8', '2015-07-27', NULL),
('1492', '12', '78', '1', '2016-09-19 02:15:06', NULL, '8', '2015-08-26', NULL),
('1493', '12', '79', '1', '2016-09-19 02:15:34', NULL, '8', '2015-09-28', NULL),
('1494', '12', '80', '1', '2016-09-19 02:15:50', NULL, '8', '2015-10-28', NULL),
('1495', '12', '81', '1', '2016-09-19 02:16:36', NULL, '8', '2015-11-26', NULL),
('1496', '12', '82', '1', '2016-09-19 02:17:04', NULL, '8', '2015-12-23', NULL),
('1497', '12', '83', '1', '2016-09-19 02:17:26', NULL, '8', '2016-01-27', NULL),
('1498', '12', '84', '1', '2016-09-19 02:17:43', NULL, '8', '2016-03-01', NULL),
('1499', '12', '85', '1', '2016-09-19 02:18:01', NULL, '8', '2016-03-28', NULL),
('1500', '1', '721', '1', '2016-04-29 01:41:40', NULL, '8', '2016-04-29', '0'),
('1501', '1', '722', '1', '2016-05-04 06:09:33', NULL, '8', '2016-05-04', '0'),
('1502', '1', '723', '1', '2016-05-05 03:38:25', NULL, '8', '2016-05-05', '0'),
('1503', '1', '724', '1', '2016-06-07 05:47:08', NULL, '8', '2016-05-09', NULL),
('1504', '1', '725', '1', '2016-05-09 04:23:37', NULL, '8', '2015-06-10', '0'),
('1505', '1', '514', '1', '2016-05-09 04:23:37', 'Voided.\nDocument reentered.', '8', '2016-05-09', '0'),
('1506', '1', '726', '1', '2016-05-11 05:17:04', NULL, '8', '2016-05-11', '0'),
('1507', '1', '727', '1', '2016-05-18 05:51:52', NULL, '8', '2016-05-18', '0'),
('1508', '1', '728', '1', '2016-05-18 05:52:56', NULL, '8', '2016-05-18', '0'),
('1509', '1', '729', '1', '2016-05-19 00:53:04', NULL, '8', '2016-05-19', '0'),
('1510', '1', '730', '1', '2016-05-22 23:04:46', NULL, '8', '2016-05-23', '0'),
('1511', '2', '144', '1', '2016-05-27 05:12:58', NULL, '8', '2016-05-27', '0'),
('1512', '1', '731', '1', '2016-05-30 05:38:55', NULL, '8', '2016-05-30', '0'),
('1513', '1', '732', '1', '2016-05-30 05:39:59', NULL, '8', '2016-05-30', '0'),
('1514', '1', '733', '1', '2016-05-31 02:42:00', NULL, '8', '2016-05-31', NULL),
('1515', '1', '734', '1', '2016-05-31 02:46:22', NULL, '8', '2016-05-31', NULL),
('1516', '1', '733', '1', '2016-05-31 02:42:00', 'Voided.\nDocument reentered.', '8', '2016-05-31', '0'),
('1517', '1', '735', '1', '2016-06-13 23:48:16', NULL, '8', '2016-05-31', NULL),
('1518', '1', '734', '1', '2016-05-31 02:46:22', 'Voided.\nDocument reentered.', '8', '2016-05-31', '0'),
('1519', '1', '736', '1', '2016-06-07 05:39:16', NULL, '8', '2016-06-07', '0'),
('1520', '1', '737', '1', '2016-06-07 05:40:48', NULL, '8', '2016-06-07', '0'),
('1521', '1', '738', '1', '2016-06-07 06:20:12', NULL, '8', '2016-05-09', NULL),
('1522', '1', '724', '1', '2016-06-07 05:47:08', 'Voided.\nDocument reentered.', '8', '2016-06-07', '0'),
('1523', '1', '739', '1', '2016-06-07 06:22:51', NULL, '8', '2016-05-09', NULL),
('1524', '1', '738', '1', '2016-06-07 06:20:12', 'Voided.\nDocument reentered.', '8', '2016-06-07', '0'),
('1525', '1', '740', '1', '2016-06-07 06:22:51', NULL, '8', '2016-05-09', '0'),
('1526', '1', '739', '1', '2016-06-07 06:22:51', 'Voided.\nDocument reentered.', '8', '2016-06-07', '0'),
('1527', '1', '741', '1', '2016-06-09 02:46:18', NULL, '8', '2016-06-09', '0'),
('1528', '1', '742', '1', '2016-06-13 06:09:50', NULL, '8', '2016-06-13', '0'),
('1529', '1', '735', '1', '2016-06-13 23:48:16', 'Voided.\n', '8', '2016-06-13', '0'),
('1530', '4', '1', '1', '2016-06-14 01:14:33', NULL, '8', '2016-05-31', NULL),
('1531', '4', '1', '1', '2016-06-14 01:14:33', 'Voided.\n', '8', '2016-05-31', '0'),
('1532', '1', '743', '1', '2016-06-14 01:27:10', NULL, '8', '2016-05-31', NULL),
('1533', '1', '744', '1', '2016-06-14 01:27:09', NULL, '8', '2016-05-31', '0'),
('1534', '1', '743', '1', '2016-06-14 01:27:10', 'Voided.\nDocument reentered.', '8', '2016-06-14', '0'),
('1535', '1', '745', '1', '2016-06-17 01:24:20', NULL, '8', '2016-06-17', '0'),
('1536', '1', '746', '1', '2016-06-17 01:25:38', NULL, '8', '2016-06-17', '0'),
('1537', '1', '747', '1', '2016-06-21 00:49:49', NULL, '8', '2016-06-21', '0'),
('1538', '1', '748', '1', '2016-06-24 02:06:56', NULL, '8', '2016-06-24', '0'),
('1539', '1', '749', '1', '2016-06-24 02:35:13', NULL, '8', '2016-06-24', '0'),
('1540', '1', '750', '1', '2016-06-27 00:53:30', NULL, '8', '2016-04-27', '0'),
('1541', '1', '751', '1', '2016-06-27 00:54:47', NULL, '8', '2016-04-27', '0'),
('1542', '1', '752', '1', '2016-06-27 01:30:56', NULL, '8', '2016-05-27', '0'),
('1543', '1', '753', '1', '2016-06-27 01:32:43', NULL, '8', '2016-05-27', '0'),
('1544', '1', '754', '1', '2016-06-27 01:34:18', NULL, '8', '2016-05-20', '0'),
('1545', '2', '145', '1', '2016-06-27 01:41:10', NULL, '8', '2016-04-20', '0'),
('1546', '1', '755', '1', '2016-06-29 02:11:13', NULL, '8', '2016-06-29', '0'),
('1547', '1', '756', '1', '2016-06-29 02:12:17', NULL, '8', '2016-06-29', '0'),
('1548', '1', '757', '1', '2016-06-29 02:13:08', NULL, '8', '2016-06-29', '0'),
('1549', '1', '758', '1', '2016-06-29 04:12:50', NULL, '8', '2016-06-29', '0'),
('1550', '30', '93', '1', '2016-06-30 06:10:52', NULL, '8', '2016-04-26', '0'),
('1551', '13', '93', '1', '2016-06-30 06:10:52', NULL, '8', '2016-04-26', '0'),
('1552', '10', '93', '1', '2016-07-01 02:05:01', NULL, '8', '2016-04-26', NULL),
('1553', '12', '86', '1', '2016-06-30 06:17:52', NULL, '8', '2016-04-26', NULL),
('1554', '30', '94', '1', '2016-06-30 06:15:23', NULL, '8', '2016-04-26', '0'),
('1555', '13', '94', '1', '2016-06-30 06:17:23', NULL, '8', '2016-04-26', NULL),
('1556', '10', '94', '1', '2016-06-30 06:17:23', NULL, '8', '2016-04-26', NULL),
('1557', '12', '87', '1', '2016-06-30 06:16:35', NULL, '8', '2016-04-26', NULL),
('1558', '12', '87', '1', '2016-06-30 06:16:35', 'Voided.\n', '8', '2016-06-30', '0'),
('1559', '13', '94', '1', '2016-06-30 06:17:23', 'Voided.', '8', '2016-06-30', '0'),
('1560', '10', '94', '1', '2016-06-30 06:17:23', 'Voided.\n', '8', '2016-06-30', '0'),
('1561', '12', '86', '1', '2016-06-30 06:17:52', 'Voided.\n', '8', '2016-06-30', '0'),
('1562', '12', '88', '1', '2016-07-01 02:04:25', NULL, '8', '2016-04-26', NULL),
('1563', '12', '88', '1', '2016-07-01 02:04:25', 'Voided.\n', '8', '2016-07-01', '0'),
('1564', '10', '93', '1', '2016-07-01 02:05:01', 'Updated.', '8', '2016-04-26', '0'),
('1565', '12', '89', '1', '2016-07-01 02:08:07', NULL, '8', '2016-04-26', NULL),
('1566', '12', '89', '1', '2016-07-01 02:08:07', 'Voided.\n', '8', '2016-07-01', '0'),
('1567', '12', '90', '1', '2016-07-01 02:08:32', NULL, '8', '2016-04-26', '0'),
('1568', '4', '2', '1', '2016-07-01 02:10:30', NULL, '8', '2016-04-26', '0'),
('1569', '1', '759', '1', '2016-07-01 02:11:32', NULL, '8', '2016-04-26', '0'),
('1570', '1', '760', '1', '2016-07-06 06:12:31', NULL, '8', '2015-04-27', '0'),
('1571', '1', '761', '1', '2016-07-06 06:13:01', NULL, '8', '2015-04-27', '0'),
('1572', '1', '762', '1', '2016-07-06 06:14:13', NULL, '8', '2015-04-30', '0'),
('1573', '2', '146', '1', '2016-07-06 23:23:40', NULL, '8', '2015-04-10', '0'),
('1574', '2', '147', '1', '2016-07-06 23:24:10', NULL, '8', '2015-04-27', '0'),
('1575', '2', '148', '1', '2016-07-06 23:24:33', NULL, '8', '2015-04-30', '0'),
('1576', '1', '763', '1', '2016-07-06 23:28:40', NULL, '8', '2015-05-28', '0'),
('1577', '1', '764', '1', '2016-07-06 23:29:13', NULL, '8', '2015-05-28', '0'),
('1578', '2', '149', '1', '2016-07-06 23:29:40', NULL, '8', '2015-05-15', '0'),
('1579', '2', '150', '1', '2016-07-06 23:30:05', NULL, '8', '2015-05-28', '0'),
('1580', '1', '765', '1', '2016-07-06 23:33:47', NULL, '8', '2015-06-29', '0'),
('1581', '1', '766', '1', '2016-07-06 23:34:27', NULL, '8', '2015-06-29', '0'),
('1582', '2', '151', '1', '2016-07-06 23:34:56', NULL, '8', '2015-06-15', '0'),
('1583', '2', '152', '1', '2016-07-06 23:35:20', NULL, '8', '2015-06-19', '0'),
('1584', '2', '153', '1', '2016-07-06 23:35:44', NULL, '8', '2015-06-29', '0'),
('1585', '1', '767', '1', '2016-07-06 23:36:27', NULL, '8', '2015-06-17', '0'),
('1586', '1', '768', '1', '2016-07-06 23:40:32', NULL, '8', '2015-07-28', '0'),
('1587', '1', '769', '1', '2016-07-07 00:37:20', NULL, '8', '2015-07-28', '0'),
('1588', '2', '154', '1', '2016-07-07 00:37:47', NULL, '8', '2015-07-10', '0'),
('1589', '2', '155', '1', '2016-07-07 00:38:08', NULL, '8', '2015-07-28', '0'),
('1590', '1', '770', '1', '2016-07-07 00:41:20', NULL, '8', '2015-08-03', '0'),
('1591', '1', '771', '1', '2016-07-07 00:42:20', NULL, '8', '2015-08-04', '0'),
('1592', '1', '772', '1', '2016-07-07 00:43:38', NULL, '8', '2015-08-04', '0'),
('1593', '1', '773', '1', '2016-07-07 00:44:16', NULL, '8', '2015-08-27', '0'),
('1594', '1', '774', '1', '2016-07-07 00:44:45', NULL, '8', '2015-08-27', '0'),
('1595', '2', '156', '1', '2016-07-07 00:45:56', NULL, '8', '2015-08-03', '0'),
('1596', '2', '157', '1', '2016-07-07 00:46:17', NULL, '8', '2015-08-20', '0'),
('1597', '2', '158', '1', '2016-07-07 00:46:47', NULL, '8', '2015-08-27', '0'),
('1598', '2', '159', '1', '2016-07-07 00:47:38', NULL, '8', '2015-08-31', '0'),
('1599', '2', '160', '1', '2016-07-07 00:50:51', NULL, '8', '2015-09-10', '0'),
('1600', '2', '161', '1', '2016-07-07 00:51:13', NULL, '8', '2015-09-23', '0'),
('1601', '2', '162', '1', '2016-07-07 00:51:35', NULL, '8', '2015-09-28', '0'),
('1602', '1', '775', '1', '2016-07-07 00:52:21', NULL, '8', '2015-09-28', '0'),
('1603', '1', '776', '1', '2016-07-07 00:52:59', NULL, '8', '2015-09-28', '0'),
('1604', '1', '777', '1', '2016-07-07 00:57:29', NULL, '8', '2015-11-30', '0'),
('1605', '1', '778', '1', '2016-07-07 00:58:10', NULL, '8', '2015-11-30', '0'),
('1606', '1', '779', '1', '2016-07-07 00:58:32', NULL, '8', '2015-11-30', '0'),
('1607', '2', '163', '1', '2016-07-07 00:58:55', NULL, '8', '2015-11-06', '0'),
('1608', '2', '164', '1', '2016-07-07 00:59:22', NULL, '8', '2015-11-11', '0'),
('1609', '2', '165', '1', '2016-07-07 00:59:49', NULL, '8', '2015-11-24', '0'),
('1610', '2', '166', '1', '2016-07-07 01:00:14', NULL, '8', '2015-11-30', '0'),
('1611', '2', '167', '1', '2016-07-07 01:07:52', NULL, '8', '2015-12-04', '0'),
('1612', '2', '168', '1', '2016-07-07 01:08:13', NULL, '8', '2015-12-22', '0'),
('1613', '1', '780', '1', '2016-07-07 01:08:56', NULL, '8', '2015-12-22', '0'),
('1614', '1', '781', '1', '2016-07-07 01:09:31', NULL, '8', '2015-12-22', '0'),
('1615', '1', '782', '1', '2016-07-07 01:16:00', NULL, '8', '2015-12-17', '0'),
('1616', '1', '783', '1', '2016-07-07 01:26:33', NULL, '8', '2016-01-20', '0'),
('1617', '1', '784', '1', '2016-07-07 01:27:58', NULL, '8', '2016-01-27', '0'),
('1618', '1', '785', '1', '2016-07-07 01:28:27', NULL, '8', '2016-01-27', '0'),
('1619', '2', '169', '1', '2016-07-07 01:30:16', NULL, '8', '2016-01-27', NULL),
('1620', '2', '170', '1', '2016-07-07 01:30:16', NULL, '8', '2016-01-18', '0'),
('1621', '2', '169', '1', '2016-07-07 01:30:16', 'Voided.\nDocument reentered.', '8', '2016-07-07', '0'),
('1622', '2', '171', '1', '2016-07-07 01:30:41', NULL, '8', '2016-01-27', '0'),
('1623', '2', '172', '1', '2016-07-07 01:31:07', NULL, '8', '2016-01-28', '0'),
('1624', '1', '786', '1', '2016-07-07 01:33:42', NULL, '8', '2016-01-18', '0'),
('1625', '2', '173', '1', '2016-07-07 01:42:50', NULL, '8', '2016-02-16', '0'),
('1626', '1', '787', '1', '2016-07-07 01:46:30', NULL, '8', '2016-03-01', '0'),
('1627', '1', '788', '1', '2016-07-07 01:47:07', NULL, '8', '2016-03-01', '0'),
('1628', '1', '789', '1', '2016-07-07 01:47:52', NULL, '8', '2016-03-29', '0'),
('1629', '1', '790', '1', '2016-07-07 01:48:21', NULL, '8', '2016-03-29', '0'),
('1630', '2', '174', '1', '2016-07-07 01:48:45', NULL, '8', '2016-03-01', '0'),
('1631', '2', '175', '1', '2016-07-07 01:49:17', NULL, '8', '2016-03-03', '0'),
('1632', '2', '176', '1', '2016-07-07 01:49:40', NULL, '8', '2016-03-09', '0'),
('1633', '2', '177', '1', '2016-07-07 01:50:17', NULL, '8', '2016-03-14', '0'),
('1634', '2', '178', '1', '2016-07-07 01:50:40', NULL, '8', '2016-03-25', '0'),
('1635', '2', '179', '1', '2016-07-07 01:51:07', NULL, '8', '2016-03-29', '0'),
('1636', '2', '180', '1', '2016-07-07 01:51:32', NULL, '8', '2016-03-31', '0'),
('1637', '1', '791', '1', '2016-07-11 05:41:37', NULL, '8', '2015-10-28', '0'),
('1638', '1', '792', '1', '2016-07-11 05:42:15', NULL, '8', '2015-10-28', '0'),
('1639', '2', '181', '1', '2016-07-11 05:43:05', NULL, '8', '2015-10-01', '0'),
('1640', '2', '182', '1', '2016-07-11 05:43:28', NULL, '8', '2015-10-05', '0'),
('1641', '2', '183', '1', '2016-07-11 05:43:47', NULL, '8', '2015-10-13', '0'),
('1642', '2', '184', '1', '2016-07-11 05:44:06', NULL, '8', '2015-10-15', '0'),
('1643', '2', '185', '1', '2016-07-11 05:44:29', NULL, '8', '2015-10-28', '0'),
('1644', '2', '186', '1', '2016-07-14 05:28:09', NULL, '8', '2016-03-09', NULL),
('1645', '0', '52', '1', '2016-07-13 03:54:52', NULL, '8', '2016-05-27', '0'),
('1646', '4', '3', '1', '2016-07-13 03:56:43', NULL, '8', '2016-05-27', NULL),
('1647', '4', '3', '1', '2016-07-13 03:56:43', 'Voided.\n', '8', '2016-07-13', '0'),
('1648', '4', '4', '1', '2016-07-13 03:57:18', NULL, '8', '2016-05-27', '0'),
('1649', '1', '793', '1', '2016-07-13 03:59:11', NULL, '8', '2016-05-27', '0'),
('1650', '1', '794', '1', '2016-07-14 04:42:03', NULL, '8', '2016-07-14', '0'),
('1651', '1', '795', '1', '2016-07-14 04:43:12', NULL, '8', '2016-07-14', '0'),
('1652', '1', '796', '1', '2016-07-14 04:45:48', NULL, '8', '2016-07-14', '0'),
('1653', '2', '187', '1', '2016-09-06 06:36:51', NULL, '8', '2016-03-09', NULL),
('1654', '2', '186', '1', '2016-07-14 05:28:09', 'Voided.\nDocument reentered.', '8', '2016-07-14', '0'),
('1655', '1', '797', '1', '2016-07-14 06:29:26', NULL, '8', '2016-07-14', '0'),
('1656', '1', '798', '1', '2016-07-20 06:14:53', NULL, '8', '2016-07-20', '0'),
('1657', '1', '799', '1', '2016-07-22 00:48:34', NULL, '8', '2016-07-22', '0'),
('1658', '1', '800', '1', '2016-07-22 02:39:52', NULL, '8', '2016-07-22', '0'),
('1659', '1', '801', '1', '2016-07-26 05:48:14', NULL, '8', '2016-07-26', '0'),
('1660', '2', '188', '1', '2016-07-27 05:34:59', NULL, '8', '2016-01-25', '0'),
('1661', '2', '143', '1', '2016-07-27 05:34:59', 'Voided.\nDocument reentered.', '8', '2016-07-27', '0'),
('1662', '1', '802', '1', '2016-07-27 07:05:22', NULL, '8', '2015-09-29', NULL),
('1663', '1', '601', '1', '2016-07-27 05:42:21', 'Voided.\nDocument reentered.', '8', '2016-07-27', '0'),
('1664', '0', '53', '1', '2016-07-27 05:54:16', NULL, '8', '2015-04-01', '0'),
('1665', '0', '54', '1', '2016-07-27 06:05:19', NULL, '8', '2016-03-31', '0'),
('1666', '0', '55', '1', '2016-07-27 06:38:51', NULL, '8', '2016-03-31', '0'),
('1667', '0', '56', '1', '2016-07-27 06:42:31', NULL, '8', '2016-03-31', '0'),
('1668', '0', '57', '1', '2016-07-27 06:49:36', NULL, '8', '2016-03-31', '0'),
('1669', '0', '58', '1', '2016-07-27 06:56:31', NULL, '8', '2016-03-31', '0'),
('1670', '2', '140', '1', '2016-07-27 07:02:09', 'Voided.\n', '8', '2016-07-27', '0'),
('1671', '1', '802', '1', '2016-07-27 07:05:22', 'Voided.\n', '8', '2016-07-27', '0'),
('1672', '1', '803', '1', '2016-07-28 05:41:46', NULL, '8', '2016-07-28', '0'),
('1673', '1', '804', '1', '2016-07-28 05:42:44', NULL, '8', '2016-07-28', '0'),
('1674', '0', '59', '1', '2016-07-29 01:47:41', NULL, '8', '2015-03-31', NULL),
('1675', '0', '60', '1', '2016-09-12 03:35:50', NULL, '8', '2015-03-31', '1'),
('1676', '0', '59', '1', '2016-07-29 01:49:54', NULL, '8', '2015-03-31', NULL),
('1677', '0', '59', '1', '2016-09-12 03:35:50', NULL, '8', '2015-03-31', '2'),
('1678', '1', '805', '1', '2016-08-03 02:26:03', NULL, '8', '2016-08-03', '0'),
('1679', '1', '806', '1', '2016-08-03 02:27:56', NULL, '8', '2016-08-03', '0'),
('1680', '1', '807', '1', '2016-08-03 02:29:27', NULL, '8', '2016-08-03', '0'),
('1681', '2', '189', '1', '2016-08-03 23:55:23', NULL, '8', '2016-08-03', '0'),
('1682', '1', '808', '1', '2016-08-03 23:56:57', NULL, '8', '2016-08-03', '0'),
('1683', '1', '809', '1', '2016-08-18 05:17:51', NULL, '8', '2016-08-18', NULL),
('1684', '1', '810', '1', '2016-08-18 05:17:51', NULL, '8', '2016-08-18', '0'),
('1685', '1', '809', '1', '2016-08-18 05:17:51', 'Voided.\nDocument reentered.', '8', '2016-08-18', '0'),
('1686', '1', '811', '1', '2016-08-18 05:58:50', NULL, '8', '2016-08-18', '0'),
('1687', '1', '812', '1', '2016-08-19 00:46:07', NULL, '8', '2016-08-19', '0'),
('1688', '1', '813', '1', '2016-08-19 00:47:59', NULL, '8', '2016-08-19', '0'),
('1689', '1', '814', '1', '2016-08-22 02:32:34', NULL, '8', '2016-08-22', '0'),
('1690', '1', '815', '1', '2016-08-26 06:43:23', NULL, '8', '2016-08-26', '0'),
('1691', '1', '816', '1', '2016-08-29 03:43:03', NULL, '8', '2016-08-29', '0'),
('1692', '1', '817', '1', '2016-08-29 03:44:00', NULL, '8', '2016-08-29', '0'),
('1693', '1', '818', '1', '2016-09-06 04:58:52', NULL, '8', '2016-09-06', '0'),
('1694', '2', '190', '1', '2016-09-06 06:36:51', NULL, '8', '2016-03-09', '0'),
('1695', '2', '187', '1', '2016-09-06 06:36:51', 'Voided.\nDocument reentered.', '8', '2016-09-06', '0'),
('1696', '1', '819', '1', '2016-09-06 06:39:01', NULL, '8', '2016-03-09', '0'),
('1697', '1', '705', '1', '2016-09-06 06:39:01', 'Voided.\nDocument reentered.', '8', '2016-09-06', '0'),
('1698', '1', '820', '1', '2016-09-07 05:34:17', NULL, '8', '2016-09-07', '0'),
('1699', '1', '821', '1', '2016-09-07 05:35:19', NULL, '8', '2016-09-07', '0'),
('1700', '1', '822', '1', '2016-09-07 05:36:10', NULL, '8', '2016-09-07', '0'),
('1701', '0', '51', '1', '2016-09-12 03:35:50', NULL, '6', '2014-04-01', '185'),
('1702', '0', '61', '1', '2016-09-12 03:35:50', NULL, '6', '2015-03-31', '330'),
('1703', '0', '63', '1', '2016-09-12 03:44:32', NULL, '7', '2016-03-31', '0'),
('1704', '0', '64', '1', '2016-09-12 04:38:18', NULL, '7', '2016-03-31', '0'),
('1705', '12', '75', '1', '2016-09-13 02:18:28', 'Updated.', '7', '2015-05-25', '0'),
('1706', '1', '823', '1', '2016-09-13 06:03:40', NULL, '7', '2016-09-13', '0'),
('1707', '1', '824', '1', '2016-09-13 06:06:14', NULL, '7', '2016-09-13', '0'),
('1708', '12', '76', '1', '2016-09-19 01:47:47', 'Updated.', '7', '2015-06-25', '0'),
('1709', '12', '91', '1', '2016-09-19 02:08:21', NULL, '7', '2015-06-25', NULL),
('1710', '12', '92', '1', '2016-09-29 05:27:21', NULL, '7', '2015-05-25', NULL),
('1711', '12', '91', '1', '2016-09-29 05:24:36', 'Updated.', '7', '2015-06-25', NULL),
('1712', '12', '77', '1', '2016-09-29 05:25:33', 'Updated.', '7', '2015-07-27', NULL),
('1713', '12', '78', '1', '2016-09-29 05:28:04', 'Updated.', '7', '2015-08-26', NULL),
('1714', '12', '79', '1', '2016-09-29 05:28:19', 'Updated.', '7', '2015-09-28', NULL),
('1715', '12', '80', '1', '2016-09-19 02:16:16', 'Updated.', '7', '2015-10-28', NULL),
('1716', '12', '80', '1', '2016-09-29 05:31:10', 'Updated.', '7', '2015-10-28', NULL),
('1717', '12', '81', '1', '2016-09-29 05:31:25', 'Updated.', '7', '2015-11-26', NULL),
('1718', '12', '82', '1', '2016-09-29 05:31:39', 'Updated.', '7', '2015-12-23', NULL),
('1719', '12', '83', '1', '2016-09-29 05:31:52', 'Updated.', '7', '2016-01-27', NULL),
('1720', '12', '84', '1', '2016-09-29 05:32:21', 'Updated.', '7', '2016-03-01', NULL),
('1721', '12', '85', '1', '2016-09-29 05:33:22', 'Updated.', '7', '2016-03-28', NULL),
('1722', '0', '65', '1', '2016-09-19 03:33:44', NULL, '7', '2015-04-06', '0'),
('1723', '0', '66', '1', '2016-09-19 03:36:25', NULL, '7', '2015-09-28', '0'),
('1724', '0', '67', '1', '2016-09-19 03:39:25', NULL, '7', '2015-09-29', '0'),
('1725', '1', '825', '1', '2016-09-19 05:00:57', NULL, '7', '2016-09-19', '0'),
('1726', '1', '826', '1', '2016-09-22 06:23:21', NULL, '7', '2016-09-22', '0'),
('1727', '1', '827', '1', '2016-09-23 02:30:31', NULL, '7', '2016-09-23', '0'),
('1728', '1', '828', '1', '2016-09-26 05:21:20', NULL, '7', '2016-09-26', '0'),
('1729', '1', '829', '1', '2016-09-28 05:56:47', NULL, '7', '2016-09-28', '0'),
('1730', '1', '830', '1', '2016-09-28 05:58:12', NULL, '7', '2016-09-28', '0'),
('1731', '1', '831', '1', '2016-09-28 05:59:09', NULL, '7', '2016-09-28', '0'),
('1732', '1', '832', '1', '2016-09-28 06:00:04', NULL, '7', '2016-09-28', '0'),
('1733', '13', '81', '1', '2016-09-29 04:17:11', 'Voided.', '7', '2016-09-29', '0'),
('1734', '10', '81', '1', '2016-09-29 04:17:11', 'Voided.\n', '7', '2016-09-29', '0'),
('1735', '30', '95', '1', '2016-09-29 04:19:12', NULL, '7', '2015-04-20', '0'),
('1736', '13', '95', '1', '2016-09-29 04:19:12', NULL, '7', '2015-04-20', '0'),
('1737', '10', '95', '1', '2016-09-29 04:19:12', NULL, '7', '2015-04-20', '0'),
('1738', '13', '82', '1', '2016-09-29 04:19:48', 'Voided.', '7', '2016-09-29', '0'),
('1739', '10', '82', '1', '2016-09-29 04:19:48', 'Voided.\n', '7', '2016-09-29', '0'),
('1740', '30', '96', '1', '2016-09-29 04:20:25', NULL, '7', '2015-05-20', '0'),
('1741', '13', '96', '1', '2016-09-29 04:20:25', NULL, '7', '2015-05-20', '0'),
('1742', '10', '96', '1', '2016-09-29 04:20:25', NULL, '7', '2015-05-20', '0'),
('1743', '13', '83', '1', '2016-09-29 04:49:50', 'Voided.', '7', '2016-09-29', '0'),
('1744', '10', '83', '1', '2016-09-29 04:49:50', 'Voided.\n', '7', '2016-09-29', '0'),
('1745', '30', '97', '1', '2016-09-29 04:51:20', NULL, '7', '2015-06-20', '0'),
('1746', '13', '97', '1', '2016-09-29 04:51:20', NULL, '7', '2015-06-20', '0'),
('1747', '10', '97', '1', '2016-09-29 04:51:20', NULL, '7', '2015-06-20', '0'),
('1748', '13', '84', '1', '2016-09-29 04:52:08', 'Voided.', '7', '2016-09-29', '0'),
('1749', '10', '84', '1', '2016-09-29 04:52:08', 'Voided.\n', '7', '2016-09-29', '0'),
('1750', '30', '98', '1', '2016-09-29 04:53:12', NULL, '7', '2015-07-20', '0'),
('1751', '13', '98', '1', '2016-09-29 04:53:12', NULL, '7', '2015-07-20', '0'),
('1752', '10', '98', '1', '2016-09-29 04:53:12', NULL, '7', '2015-07-20', '0'),
('1753', '13', '85', '1', '2016-09-29 04:54:59', 'Voided.', '7', '2016-09-29', '0'),
('1754', '10', '85', '1', '2016-09-29 04:54:59', 'Voided.\n', '7', '2016-09-29', '0'),
('1755', '30', '99', '1', '2016-09-29 04:55:46', NULL, '7', '2015-08-20', '0'),
('1756', '13', '99', '1', '2016-09-29 04:55:46', NULL, '7', '2015-08-20', '0'),
('1757', '10', '99', '1', '2016-09-29 04:55:46', NULL, '7', '2015-08-20', '0'),
('1758', '13', '86', '1', '2016-09-29 04:56:42', 'Voided.', '7', '2016-09-29', '0'),
('1759', '10', '86', '1', '2016-09-29 04:56:42', 'Voided.\n', '7', '2016-09-29', '0'),
('1760', '30', '100', '1', '2016-09-29 04:57:34', NULL, '7', '2015-09-20', '0'),
('1761', '13', '100', '1', '2016-09-29 04:57:34', NULL, '7', '2015-09-20', '0'),
('1762', '10', '100', '1', '2016-09-29 04:57:34', NULL, '7', '2015-09-20', '0'),
('1763', '13', '87', '1', '2016-09-29 04:58:00', 'Voided.', '7', '2016-09-29', '0'),
('1764', '10', '87', '1', '2016-09-29 04:58:00', 'Voided.\n', '7', '2016-09-29', '0'),
('1765', '30', '101', '1', '2016-09-29 04:58:47', NULL, '7', '2015-10-20', '0'),
('1766', '13', '101', '1', '2016-09-29 04:58:47', NULL, '7', '2015-10-20', '0'),
('1767', '10', '101', '1', '2016-09-29 04:58:47', NULL, '7', '2015-10-20', '0'),
('1768', '13', '88', '1', '2016-09-29 04:59:12', 'Voided.', '7', '2016-09-29', '0'),
('1769', '10', '88', '1', '2016-09-29 04:59:12', 'Voided.\n', '7', '2016-09-29', '0'),
('1770', '30', '102', '1', '2016-09-29 05:00:02', NULL, '7', '2015-11-20', '0'),
('1771', '13', '102', '1', '2016-09-29 05:00:02', NULL, '7', '2015-11-20', '0'),
('1772', '10', '102', '1', '2016-09-29 05:00:02', NULL, '7', '2015-11-20', '0'),
('1773', '13', '89', '1', '2016-09-29 05:00:33', 'Voided.', '7', '2016-09-29', '0'),
('1774', '10', '89', '1', '2016-09-29 05:00:33', 'Voided.\n', '7', '2016-09-29', '0'),
('1775', '30', '103', '1', '2016-09-29 05:01:20', NULL, '7', '2015-12-20', '0'),
('1776', '13', '103', '1', '2016-09-29 05:01:20', NULL, '7', '2015-12-20', '0'),
('1777', '10', '103', '1', '2016-09-29 05:01:20', NULL, '7', '2015-12-20', '0'),
('1778', '13', '90', '1', '2016-09-29 05:01:47', 'Voided.', '7', '2016-09-29', '0'),
('1779', '10', '90', '1', '2016-09-29 05:01:47', 'Voided.\n', '7', '2016-09-29', '0'),
('1780', '30', '104', '1', '2016-09-29 05:02:31', NULL, '7', '2016-01-20', '0'),
('1781', '13', '104', '1', '2016-10-03 01:12:14', NULL, '7', '2016-01-20', NULL),
('1782', '10', '104', '1', '2016-10-03 01:12:14', NULL, '7', '2016-01-20', NULL),
('1783', '13', '91', '1', '2016-09-29 05:03:07', 'Voided.', '7', '2016-09-29', '0'),
('1784', '10', '91', '1', '2016-09-29 05:03:07', 'Voided.\n', '7', '2016-09-29', '0'),
('1785', '30', '105', '1', '2016-09-29 05:03:54', NULL, '7', '2016-02-20', '0'),
('1786', '13', '105', '1', '2016-09-29 05:03:54', NULL, '7', '2016-02-20', '0'),
('1787', '10', '105', '1', '2016-09-29 05:03:54', NULL, '7', '2016-02-20', '0'),
('1788', '13', '92', '1', '2016-09-29 05:04:20', 'Voided.', '7', '2016-09-29', '0'),
('1789', '10', '92', '1', '2016-09-29 05:04:20', 'Voided.\n', '7', '2016-09-29', '0'),
('1790', '30', '106', '1', '2016-09-29 05:05:13', NULL, '7', '2016-03-20', '0'),
('1791', '13', '106', '1', '2016-09-29 05:05:13', NULL, '7', '2016-03-20', '0'),
('1792', '10', '106', '1', '2016-09-29 05:05:13', NULL, '7', '2016-03-20', '0'),
('1793', '12', '91', '1', '2016-09-29 05:27:37', 'Updated.', '7', '2015-06-25', NULL),
('1794', '12', '77', '1', '2016-09-29 05:27:51', 'Updated.', '7', '2015-07-27', NULL),
('1795', '12', '74', '1', '2016-09-29 05:27:01', 'Updated.', '7', '2015-04-28', '0'),
('1796', '12', '92', '1', '2016-09-29 05:27:21', 'Updated.', '7', '2015-05-25', '0'),
('1797', '12', '91', '1', '2016-09-29 05:27:37', 'Updated.', '7', '2015-06-25', '0'),
('1798', '12', '77', '1', '2016-09-29 05:27:51', 'Updated.', '7', '2015-07-27', '0'),
('1799', '12', '78', '1', '2016-09-29 05:28:04', 'Updated.', '7', '2015-08-26', '0'),
('1800', '12', '79', '1', '2016-09-29 05:30:26', 'Updated.', '7', '2015-09-28', NULL),
('1801', '12', '79', '1', '2016-09-29 05:36:14', 'Updated.', '7', '2015-09-28', NULL),
('1802', '12', '80', '1', '2016-09-29 05:34:17', 'Updated.', '7', '2015-10-28', NULL),
('1803', '12', '81', '1', '2016-09-29 05:31:25', 'Updated.', '7', '2015-11-26', '0'),
('1804', '12', '82', '1', '2016-09-29 05:31:39', 'Updated.', '7', '2015-12-23', '0'),
('1805', '12', '83', '1', '2016-09-29 05:32:08', 'Updated.', '7', '2016-01-27', NULL),
('1806', '12', '83', '1', '2016-10-03 01:09:50', 'Updated.', '7', '2016-01-27', NULL),
('1807', '12', '84', '1', '2016-09-29 05:32:38', 'Updated.', '7', '2016-03-01', NULL),
('1808', '12', '84', '1', '2016-09-29 05:32:38', 'Updated.', '7', '2016-03-01', '0'),
('1809', '12', '85', '1', '2016-09-29 05:35:37', 'Updated.', '7', '2016-03-28', NULL),
('1810', '12', '80', '1', '2016-09-29 05:36:43', 'Updated.', '7', '2015-10-28', NULL),
('1811', '12', '85', '1', '2016-09-29 05:35:37', 'Updated.', '7', '2016-03-28', '0'),
('1812', '12', '79', '1', '2016-09-29 05:36:14', 'Updated.', '7', '2015-09-28', '0'),
('1813', '12', '80', '1', '2016-09-29 05:36:43', 'Updated.', '7', '2015-10-28', '0'),
('1814', '1', '833', '1', '2016-09-30 01:04:06', NULL, '7', '2016-09-30', '0'),
('1815', '1', '834', '1', '2016-09-30 01:05:01', NULL, '7', '2016-09-30', '0'),
('1816', '1', '835', '1', '2016-09-30 01:27:27', NULL, '7', '2016-09-30', '0'),
('1817', '12', '83', '1', '2016-10-03 01:09:50', 'Voided.\n', '7', '2016-10-03', '0'),
('1818', '13', '104', '1', '2016-10-03 01:12:14', 'Voided.', '7', '2016-10-03', '0'),
('1819', '10', '104', '1', '2016-10-03 01:12:14', 'Voided.\n', '7', '2016-10-03', '0'),
('1820', '30', '107', '1', '2016-10-03 01:13:41', NULL, '7', '2016-01-20', '0'),
('1821', '13', '107', '1', '2016-10-03 01:13:41', NULL, '7', '2016-01-20', '0'),
('1822', '10', '107', '1', '2016-10-03 01:13:41', NULL, '7', '2016-01-20', '0'),
('1823', '12', '93', '1', '2016-10-03 01:20:36', NULL, '7', '2016-01-27', '0'),
('1824', '1', '836', '1', '2016-10-03 04:42:14', NULL, '7', '2016-10-03', '0'),
('1825', '1', '837', '1', '2016-10-04 06:14:13', NULL, '7', '2016-10-04', '0'),
('1826', '1', '838', '1', '2016-10-04 06:16:27', NULL, '7', '2016-10-04', '0'),
('1827', '1', '839', '1', '2016-10-05 00:51:47', NULL, '7', '2016-10-05', '0'),
('1828', '1', '840', '1', '2016-10-05 02:10:52', NULL, '7', '2016-10-05', '0');

### Structure of table `1_bank_accounts` ###

DROP TABLE IF EXISTS `1_bank_accounts`;

CREATE TABLE `1_bank_accounts` (
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT '0',
  `bank_account_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_address` tinytext COLLATE utf8_unicode_ci,
  `bank_curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT '0',
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `bank_short_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_bank_accounts` ###

INSERT INTO `1_bank_accounts` VALUES
('1060', '1', 'Sampath Bank - Current Account', 'N/A', 'N/A', NULL, 'Rs.', '1', '1', '2016-09-30 00:00:00', '2364273.56', '0', 'SB/CA'),
('1065', '3', 'Petty Cash account', 'N/A', 'N/A', NULL, 'Rs.', '0', '2', '0000-00-00 00:00:00', '0', '0', 'PettyCash'),
('1230', '3', 'Inbay Limited - Current Account', '', '', NULL, 'Rs.', '0', '3', '0000-00-00 00:00:00', '0', '1', 'IL/CA'),
('1220', '2', 'Evolve Technologies (Pvt) Ltd.', '', '', NULL, 'Rs.', '0', '5', '0000-00-00 00:00:00', '0', '0', 'ET'),
('1065', '3', 'Petty Cash', '', '', NULL, 'Rs.', '0', '6', '0000-00-00 00:00:00', '0', '0', 'Petty'),
('1221', '2', 'Evolve Technologies (Pvt)Ltd.', '', '', NULL, 'GBP', '0', '7', '0000-00-00 00:00:00', '0', '0', 'ET/GBP'),
('1061', '1', 'Sampath Bank - GBP Account', '', '', NULL, 'GBP', '0', '8', '0000-00-00 00:00:00', '0', '0', '');

### Structure of table `1_bank_trans` ###

DROP TABLE IF EXISTS `1_bank_trans`;

CREATE TABLE `1_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ref` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `person_type_id` int(11) NOT NULL DEFAULT '0',
  `person_id` tinyblob,
  `reconciled` date DEFAULT NULL,
  `pay_mode` int(1) DEFAULT NULL,
  `cheque_no` int(6) DEFAULT NULL,
  `payment_increment` int(11) NOT NULL,
  `payment_number` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB AUTO_INCREMENT=1424 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_bank_trans` ###

INSERT INTO `1_bank_trans` VALUES
('7', '1', '2', '1', '2', '2010-12-29', '-32312.66', '0', '0', '0', 'Ceylinco Insurance Plc.', '2011-03-31', '0', '14952', '0', ''),
('9', '1', '4', '1', '4', '2010-12-30', '-161000', '0', '0', '4', '4', '2011-03-31', '0', '14954', '0', ''),
('10', '1', '5', '1', '5', '2010-12-30', '-24150', '0', '0', '4', '5', '2011-03-31', '0', '14955', '0', ''),
('13', '1', '8', '1', '8', '2011-02-02', '-161000', '0', '0', '4', '4', '2011-03-31', '0', '14958', '0', ''),
('14', '1', '9', '1', '9', '2011-02-02', '-24150', '0', '0', '4', '5', '2011-03-31', '0', '14959', '0', ''),
('15', '1', '10', '1', '10', '2011-02-10', '-36388.57', '0', '0', '0', 'Highlevel express', '2011-03-31', '0', '14960', '0', ''),
('18', '1', '13', '1', '13', '2011-03-01', '-24150', '0', '0', '4', '5', '2011-03-31', '0', '14964', '0', ''),
('19', '1', '14', '1', '14', '2011-03-01', '-161000', '0', '0', '4', '4', '2011-03-31', '0', '14965', '0', ''),
('20', '1', '15', '1', '15', '2011-03-01', '-250000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2011-03-31', '0', '14966', '0', ''),
('21', '1', '16', '1', '16', '2011-03-17', '-250000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2011-03-31', '0', '14967', '0', ''),
('22', '1', '17', '1', '17', '2011-03-31', '-161000', '0', '0', '4', '4', '2011-04-30', '0', '14969', '0', ''),
('23', '1', '18', '1', '18', '2011-03-31', '-24150', '0', '0', '4', '5', '2011-04-30', '0', '14970', '0', ''),
('24', '1', '12', '1', '12', '2011-02-15', '-280000', '0', '0', '0', 'K.P.L.Pintoe', '2011-03-31', '0', '14971', '0', ''),
('25', '1', '11', '1', '11', '2011-02-15', '-120000', '0', '0', '0', 'K.P.L.Pintoe', '2011-03-31', '0', '14972', '0', ''),
('26', '2', '1', '1', '1', '2011-02-15', '25000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2011-03-31', '0', '1', '0', ''),
('27', '12', '1', '1', '1', '2010-11-29', '1100325', '0', '0', '2', '1', '2011-03-31', '0', '0', '0', ''),
('28', '12', '2', '1', '2', '2010-11-29', '0', '0', '0', '2', '1', '2010-11-24', '0', '0', '0', ''),
('29', '12', '3', '1', '3', '2010-11-24', '1600', '0', '0', '2', '1', '2010-11-24', '0', '0', '0', ''),
('30', '12', '4', '1', '4', '2011-01-25', '1434815', '0', '0', '2', '1', '2011-03-31', '0', '0', '0', ''),
('31', '12', '5', '1', '5', '2011-02-25', '1405315', '0', '0', '2', '1', '2011-03-31', '0', '0', '0', ''),
('32', '12', '6', '1', '6', '2011-03-25', '1414315', '0', '0', '2', '1', '2011-03-31', '0', '0', '0', ''),
('33', '2', '2', '1', '2', '2011-03-31', '250000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2011-03-31', '0', '2', '0', ''),
('36', '1', '20', '1', '13', '2010-11-24', '-750', '0', '0', '0', 'Bank charges', '2011-03-31', '0', '5', '0', ''),
('38', '1', '22', '1', '15', '2010-11-30', '-1300', '0', '0', '0', 'Bank charges', '2011-03-31', '0', '7', '0', ''),
('39', '1', '23', '1', '16', '2010-11-30', '-826.9', '0', '0', '0', 'Bank charges', '2011-03-31', '0', '8', '0', ''),
('40', '1', '24', '1', '17', '2010-12-23', '-954816', '0', '0', '0', 'Staff Salaries -', '2011-03-31', '0', '9', '0', ''),
('41', '1', '25', '1', '18', '2010-12-23', '-1600', '0', '0', '0', 'Bank charges', '2011-03-31', '0', '10', '0', ''),
('42', '1', '26', '1', '19', '2010-12-30', '-100', '0', '0', '0', 'Bank charges', '2011-03-31', '0', '11', '0', ''),
('43', '1', '27', '1', '20', '2011-01-03', '-1158.6', '0', '0', '0', 'Bank charges', '2011-03-31', '0', '12', '0', ''),
('44', '1', '28', '1', '21', '2011-01-27', '-954816', '0', '0', '0', 'Staff Salaries -', '2011-03-31', '0', '13', '0', ''),
('45', '1', '29', '1', '22', '2011-01-27', '-500', '0', '0', '0', 'Bank charges', '2011-03-31', '0', '14', '0', ''),
('46', '1', '30', '1', '23', '2011-02-03', '-1382.08', '0', '0', '0', 'Bank charges', '2011-03-31', '0', '15', '0', ''),
('47', '1', '31', '1', '24', '2011-02-28', '-954816', '0', '0', '0', 'Staff Salaries -', '2011-03-31', '0', '16', '0', ''),
('48', '1', '32', '1', '25', '2011-02-28', '-1600', '0', '0', '0', 'Bank charges', '2011-03-31', '0', '17', '0', ''),
('49', '1', '33', '1', '26', '2011-03-01', '-1577.95', '0', '0', '0', 'Bank charges', '2011-03-31', '0', '18', '0', ''),
('50', '1', '34', '1', '27', '2011-03-25', '-962816', '0', '0', '0', 'Staff Salaries -', '2011-03-31', '0', '19', '0', ''),
('51', '1', '35', '1', '28', '2011-03-25', '-1600', '0', '0', '0', 'Bank charges', '2011-03-31', '0', '20', '0', ''),
('52', '1', '19', '1', '12', '2010-11-24', '-500', '0', '0', '0', 'Bank charges', '2011-03-31', '0', '21', '0', ''),
('54', '1', '21', '1', '14', '2010-11-30', '-824849', '0', '0', '0', 'Staff Salaries ', '2011-03-31', '0', '23', '0', ''),
('55', '12', '7', '1', '7', '2010-11-29', '1089045', '0', '0', '2', '1', '2011-03-31', '0', '0', '0', ''),
('58', '12', '8', '3', '8', '2010-11-30', '343400', '0', '0', '2', '1', NULL, '0', '0', '0', ''),
('59', '2', '3', '1', '3', '2010-11-29', '171700', '0', '0', '0', 'Share Capiatl - Kristian Wright', '2011-03-31', '0', '26', '0', ''),
('60', '2', '4', '1', '4', '2010-11-29', '171700', '0', '0', '0', 'Share Capiatl - Mark Duke', '2011-03-31', '0', '27', '0', ''),
('61', '1', '37', '2', '15', '2010-05-17', '-12190', '0', '0', '0', 'Registrar of companies', NULL, '0', '28', '0', ''),
('62', '1', '38', '2', '16', '2010-08-06', '-1857.25', '0', '0', '0', 'Registrar of companies', NULL, '0', '29', '0', ''),
('63', '1', '39', '2', '17', '2010-07-21', '-2912', '0', '0', '0', 'News paper advertisements', NULL, '0', '30', '0', ''),
('64', '1', '40', '2', '18', '2010-07-21', '-4659', '0', '0', '0', 'News paper advertisements', NULL, '0', '31', '0', ''),
('65', '1', '41', '2', '19', '2010-07-21', '-20000', '0', '0', '0', 'Company Secretaries', NULL, '0', '32', '0', ''),
('66', '1', '42', '5', '20', '2010-11-28', '-57040', '0', '0', '0', 'Highlevel express', NULL, '0', '33', '0', ''),
('67', '1', '43', '5', '21', '2011-03-25', '-106925.71', '0', '0', '0', 'Highlevel express', NULL, '0', '34', '0', ''),
('68', '1', '44', '5', '22', '2010-06-01', '0', '0', '0', '0', 'K.P.L.Pintoe', NULL, '0', '35', '0', ''),
('69', '1', '45', '5', '23', '2010-06-01', '0', '0', '0', '0', 'K.N.S.Pintoe', NULL, '0', '36', '0', ''),
('70', '2', '5', '5', '5', '2010-06-01', '40000', '0', '0', '0', 'K.P.L.Pintoe', NULL, '0', '37', '0', ''),
('71', '2', '6', '5', '6', '2010-06-01', '40000', '0', '0', '0', 'K.N.S.Pintoe', NULL, '0', '38', '0', ''),
('72', '1', '1', '1', '1', '2010-12-15', '-161000', '0', '0', '0', 'Superientendant, Employees Provident Fund ', '2011-03-31', '0', '14951', '0', ''),
('73', '1', '1', '5', '1', '2010-12-15', '161000', '0', '0', '0', 'Superientendant, Employees Provident Fund ', NULL, '0', '14951', '0', ''),
('74', '1', '3', '1', '3', '2010-12-30', '-161000', '0', '0', '4', '4', '2011-03-31', '0', '14953', '0', ''),
('75', '1', '3', '5', '3', '2010-12-30', '161000', '0', '0', '4', '4', NULL, '0', '14953', '0', ''),
('76', '1', '6', '1', '6', '2010-12-30', '-24150', '0', '0', '4', '5', '2011-03-31', '0', '14954', '0', ''),
('77', '1', '6', '5', '6', '2010-12-30', '24150', '0', '0', '4', '5', NULL, '0', '14954', '0', ''),
('78', '1', '7', '1', '7', '2010-12-30', '-24150', '0', '0', '4', '5', '2011-03-31', '0', '14955', '0', ''),
('79', '1', '7', '5', '7', '2010-12-30', '24150', '0', '0', '4', '5', NULL, '0', '14955', '0', ''),
('80', '1', '46', '1', '8', '2012-02-29', '-166940', '0', '0', '4', '4', '2012-03-31', '0', '257204', '0', ''),
('81', '1', '47', '1', '9', '2012-02-29', '-25041', '0', '0', '4', '5', '2012-03-31', '0', '257205', '0', ''),
('82', '1', '48', '5', '10', '2010-07-02', '-45000', '0', '0', '0', 'Cash', NULL, '0', '32', '0', ''),
('83', '1', '48', '2', '10', '2010-07-02', '45000', '0', '0', '0', 'Cash', NULL, '0', '32', '0', ''),
('84', '1', '36', '1', '13', '2010-11-24', '-1600', '0', '0', '0', 'Bank charges', '2011-03-31', '0', '33', '0', ''),
('85', '1', '49', '1', '14', '2012-03-09', '-17543', '0', '0', '4', '6', '2012-03-31', '0', '257206', '0', ''),
('86', '1', '50', '5', '15', '2012-03-09', '0', '0', '0', '4', '6', NULL, '0', '257207', '0', ''),
('87', '22', '1', '5', '16', '2012-03-20', '0', '0', '0', '3', '1', NULL, '0', '257208', '0', ''),
('88', '22', '2', '1', '16', '2012-03-20', '-220926.75', '0', '0', '3', '1', '2012-03-31', '0', '257209', '0', ''),
('89', '1', '51', '1', '17', '2012-03-26', '-124083.58', '0', '0', '0', 'Union Assurance Plc.', '2012-03-31', '0', '257209', '0', ''),
('90', '1', '52', '1', '18', '2012-03-27', '0', '0', '0', '0', 'Staff Salaries', NULL, '0', '257210', '0', ''),
('93', '1', '54', '1', '20', '2012-03-31', '-23788.5', '0', '0', '4', '5', '2012-04-30', '0', '257212', '0', ''),
('94', '1', '55', '1', '21', '2012-03-31', '-158590', '0', '0', '4', '4', '2012-04-30', '0', '257213', '0', ''),
('98', '1', '58', '1', '24', '2012-05-03', '-246402.36', '0', '0', '0', 'Highlevel Express (Pvt)Ltd. ', '2012-05-30', '0', '257217', '0', ''),
('99', '1', '56', '1', '22', '2012-04-30', '-29638.5', '0', '0', '4', '5', '2012-05-30', '0', '257218', '0', ''),
('100', '1', '57', '1', '23', '2012-04-30', '-197590', '0', '0', '4', '4', '2012-05-30', '0', '257219', '0', ''),
('101', '1', '59', '1', '24', '2012-05-16', '-2369.55', '0', '0', '0', 'Employees Trust Fund Board', '2012-05-30', '0', '257220', '0', ''),
('102', '1', '60', '1', '25', '2012-05-28', '-207223', '0', '0', '4', '4', '2012-05-30', '0', '257219', '0', ''),
('103', '1', '61', '1', '26', '2012-05-28', '-31083.5', '0', '0', '4', '5', '2012-05-30', '0', '257220', '0', ''),
('104', '1', '62', '1', '27', '2012-04-27', '-1195388.33', '0', '0', '0', 'Staff Salaries - April 2012', '2012-04-30', '0', '0', '0', ''),
('105', '1', '63', '1', '28', '2012-05-25', '-1501776.9', '0', '0', '0', 'Staff Salaries -', '2012-05-30', '0', '0', '0', ''),
('106', '1', '64', '1', '29', '2012-06-15', '-396074', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '2012-06-30', '0', '257221', '0', ''),
('107', '1', '65', '1', '30', '2012-06-29', '-263923', '0', '0', '4', '4', '2012-07-31', '0', '257222', '0', ''),
('108', '1', '66', '1', '31', '2012-06-29', '-39588.5', '0', '0', '4', '5', '2012-07-31', '0', '257223', '0', ''),
('109', '1', '67', '1', '32', '2012-07-12', '-25608.29', '0', '0', '0', 'Dilshee Enterprises', '2012-07-31', '0', '257224', '0', ''),
('110', '1', '68', '1', '33', '2012-07-23', '-430423.68', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '2012-07-31', '0', '257225', '0', ''),
('111', '1', '69', '1', '34', '2012-07-26', '-1823091.28', '0', '0', '0', 'Staff Salaries - July 2012', '2012-07-31', '0', '257226', '0', ''),
('112', '1', '70', '1', '35', '2012-07-31', '-39588.5', '0', '0', '4', '5', '2012-08-31', '0', '257227', '0', ''),
('114', '1', '71', '1', '36', '2012-07-31', '0', '0', '0', '0', 'Cash', NULL, '1', '257229', '0', ''),
('115', '1', '72', '1', '37', '2012-08-07', '-263923', '0', '0', '4', '4', '2012-08-31', '0', '257230', '0', ''),
('117', '1', '73', '1', '38', '2012-08-28', '-1879236.56', '0', '0', '0', 'Staff Salaries - July 2012', '2012-08-31', '0', '39', '0', ''),
('118', '1', '74', '1', '39', '2012-08-22', '0', '0', '0', '0', 'Cash', NULL, '1', '257229', '0', ''),
('119', '1', '75', '1', '40', '2012-08-30', '-350590', '0', '0', '4', '4', '2012-09-30', '0', '257229', '0', ''),
('120', '1', '76', '1', '41', '2012-08-30', '-52588.5', '0', '0', '4', '5', '2012-09-30', '0', '257230', '0', ''),
('121', '1', '77', '1', '42', '2012-08-30', '-39000', '0', '0', '0', 'IAS Solutions', '2012-09-30', '0', '257231', '0', ''),
('123', '1', '78', '1', '43', '2012-09-28', '0', '0', '0', '4', '5', NULL, '0', '257234', '0', ''),
('124', '1', '79', '1', '44', '2012-10-01', '-54088.5', '0', '0', '4', '5', '2012-10-31', '0', '257234', '0', ''),
('125', '1', '80', '1', '45', '2012-10-01', '-360590', '0', '0', '4', '4', '2012-10-31', '0', '257233', '0', ''),
('126', '1', '81', '1', '46', '2012-10-04', '-265024', '0', '0', '0', 'High Level Express (Pvt)Ltd.', '2012-10-31', '0', '257235', '0', ''),
('127', '1', '82', '1', '47', '2012-10-25', '-2022395.14', '0', '0', '0', 'Salaries', '2012-10-31', '1', '47', '0', ''),
('128', '1', '83', '1', '48', '2012-10-05', '-60000', '0', '0', '0', 'Cash', '2012-10-31', '1', '48', '0', ''),
('129', '1', '84', '1', '49', '2012-10-08', '-7500', '0', '0', '0', 'Cash', '2012-10-31', '1', '49', '0', ''),
('130', '1', '85', '1', '50', '2012-10-31', '-378590', '0', '0', '4', '4', '2012-11-30', '0', '257238', '0', ''),
('131', '1', '86', '1', '51', '2012-10-31', '-56788.5', '0', '0', '4', '5', '2012-11-30', '0', '257239', '0', ''),
('132', '1', '87', '1', '52', '2012-10-31', '-2671.34', '0', '0', '4', '5', '2012-11-30', '0', '257240', '0', ''),
('133', '1', '88', '1', '53', '2012-11-02', '-60000', '0', '0', '0', 'Cash', '2012-11-30', '1', '257241', '0', ''),
('134', '1', '89', '1', '54', '2012-11-30', '-57669.75', '0', '0', '4', '5', '2012-12-31', '0', '257243', '0', ''),
('135', '1', '90', '1', '55', '2012-11-30', '-384465', '0', '0', '4', '4', '2012-12-31', '0', '257242', '0', ''),
('136', '1', '91', '1', '56', '2012-12-05', '-60000', '0', '0', '0', 'Cash', '2012-12-31', '1', '257244', '0', ''),
('137', '1', '92', '1', '57', '2012-12-10', '-115500', '0', '0', '0', 'Cash', '2012-12-31', '1', '257245', '0', ''),
('138', '1', '93', '1', '58', '2012-12-10', '-41120', '0', '0', '0', 'Cash', '2012-12-31', '1', '257246', '0', ''),
('139', '1', '94', '1', '59', '2012-12-18', '-315065.76', '0', '0', '0', 'High Level Express (Pvt)Ltd.', '2012-12-31', '0', '257247', '0', ''),
('140', '1', '95', '1', '60', '2012-12-20', '-2220511.67', '0', '0', '0', 'Salaries', '2012-12-31', '0', '60', '0', ''),
('141', '2', '7', '1', '7', '2013-01-07', '400000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2013-01-31', '0', '61', '0', ''),
('142', '2', '7', '5', '7', '2013-01-07', '-400000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '61', '0', ''),
('144', '1', '97', '1', '62', '2013-01-07', '-60000', '0', '0', '0', 'Cash', '2013-01-31', '1', '63', '0', ''),
('145', '1', '98', '1', '63', '2013-01-07', '-14000', '0', '0', '0', 'Mewan Samarasinghe', '2013-01-31', '1', '64', '0', ''),
('146', '1', '99', '1', '64', '2013-01-10', '-32725', '0', '0', '0', 'S. T. Hapangama', '2013-01-31', '0', '465253', '0', ''),
('149', '1', '100', '1', '65', '2013-01-15', '-7500', '0', '0', '0', 'Cash', '2013-01-31', '1', '465254', '0', ''),
('151', '1', '101', '1', '66', '2013-01-15', '-142780', '0', '0', '0', 'Grand Taxi ', '2013-01-31', '0', '465256', '0', ''),
('152', '1', '102', '1', '67', '2013-01-16', '-60670', '0', '0', '4', '5', '2013-01-31', '0', '465258', '0', ''),
('153', '1', '103', '1', '68', '2013-01-16', '-404465', '0', '0', '4', '4', '2013-01-31', '0', '465258', '0', ''),
('154', '1', '104', '1', '69', '2013-01-30', '-159582', '0', '0', '0', 'Grand Taxi ', '2013-01-31', '0', '465259', '0', ''),
('155', '1', '105', '1', '70', '2013-01-31', '-64719.75', '0', '0', '4', '5', '2013-02-28', '0', '465260', '0', ''),
('156', '1', '106', '1', '71', '2013-01-31', '-431465', '0', '0', '4', '4', '2013-02-28', '0', '465261', '0', ''),
('157', '1', '107', '5', '72', '2013-02-18', '-7500', '0', '0', '0', 'Uddeshika Jayawardena', NULL, '0', '72', '0', ''),
('158', '1', '108', '1', '73', '2013-02-26', '-67830', '0', '0', '4', '5', '2013-02-28', '0', '465263', '0', ''),
('159', '1', '109', '1', '74', '2013-02-26', '-452198', '0', '0', '4', '4', '2013-02-28', '0', '465262', '0', ''),
('160', '1', '110', '1', '75', '2013-03-06', '-217312', '0', '0', '0', 'Grand Taxi', '2013-03-31', '0', '465264', '0', ''),
('162', '1', '53', '1', '19', '2012-04-01', '-22400', '0', '0', '0', 'Pope and Company', '2012-04-30', '0', '257216', '0', ''),
('163', '1', '111', '1', '20', '2013-03-08', '-15600', '0', '0', '0', 'Cash', '2013-03-31', '1', '257217', '0', ''),
('164', '1', '112', '1', '21', '2013-03-08', '-20000', '0', '0', '0', 'Ishan Ariyaratna', '2013-03-31', '1', '257218', '0', ''),
('165', '1', '113', '1', '22', '2013-03-08', '-15597', '0', '0', '0', 'Kapila Silwathge', '2013-03-31', '1', '257219', '0', ''),
('166', '1', '114', '1', '23', '2013-03-08', '-60000', '0', '0', '0', 'Cash', '2013-03-31', '1', '257220', '0', ''),
('167', '1', '115', '1', '24', '2013-03-08', '-12762', '0', '0', '4', '6', '2013-03-31', '0', '257221', '0', ''),
('168', '1', '116', '1', '25', '2013-03-08', '-37811', '0', '0', '4', '6', '2013-03-31', '0', '257222', '0', ''),
('169', '1', '117', '1', '26', '2013-03-08', '-148963', '0', '0', '4', '6', '2013-03-31', '0', '257223', '0', ''),
('170', '1', '118', '1', '27', '2013-03-28', '-473463', '0', '0', '4', '4', '2013-04-30', '0', '465272', '0', ''),
('171', '1', '119', '1', '28', '2013-03-28', '-71019', '0', '0', '4', '5', '2013-04-30', '0', '465273', '0', ''),
('172', '1', '120', '1', '29', '2013-03-28', '-156244', '0', '0', '4', '6', '2013-04-30', '0', '465274', '0', ''),
('173', '1', '121', '1', '30', '2013-03-31', '-7523.26', '0', '0', '4', '5', '2013-04-30', '0', '465275', '0', ''),
('174', '1', '122', '5', '31', '2013-04-04', '0', '0', '0', '0', 'Grand Taxi Company', NULL, '0', '31', '0', ''),
('178', '1', '126', '1', '35', '2013-04-09', '0', '0', '0', '0', 'Cash', '2013-04-30', '1', '465279', '0', ''),
('179', '1', '126', '1', '35', '2013-04-09', '0', '0', '0', '0', 'Cash', NULL, '1', '465279', '0', ''),
('180', '1', '127', '1', '36', '2013-04-09', '-4850', '0', '0', '0', 'Cash', '2013-04-30', '1', '465280', '0', ''),
('181', '1', '123', '1', '32', '2013-04-09', '-60000', '0', '0', '0', 'Cash', '2013-04-30', '0', '465278', '0', ''),
('182', '1', '124', '1', '33', '2013-04-04', '-7500', '0', '0', '0', 'Cash', '2013-04-30', '1', '465276', '0', ''),
('183', '1', '125', '1', '34', '2013-04-04', '-15000', '0', '0', '0', 'Cash', '2013-04-30', '0', '465277', '0', ''),
('185', '1', '96', '1', '61', '2013-04-29', '-80000', '0', '0', '0', 'Genesiis Software (Pvt)Ltd', '2013-05-31', '0', '465281', '0', ''),
('186', '1', '128', '1', '62', '2013-04-29', '-7500', '0', '0', '0', 'Cash', '2013-05-31', '1', '465282', '0', ''),
('187', '1', '129', '1', '63', '2013-04-29', '-488523', '0', '0', '4', '4', '2013-05-31', '0', '465283', '0', ''),
('191', '1', '130', '1', '64', '2013-04-29', '-73278', '0', '0', '4', '5', '2013-05-31', '0', '465284', '0', ''),
('192', '1', '131', '1', '65', '2013-04-30', '-5333', '0', '0', '0', 'Arshad Zackeriya', '2013-05-31', '1', '465285', '0', ''),
('193', '1', '132', '1', '66', '2013-04-30', '-6025', '0', '0', '0', 'Cash', '2013-05-31', '1', '465286', '0', ''),
('194', '1', '133', '1', '67', '2013-05-02', '-164520', '0', '0', '0', 'Grand Taxi', '2013-05-31', '0', '465287', '0', ''),
('195', '1', '134', '1', '68', '2013-05-13', '-60000', '0', '0', '0', 'Cash', '2013-05-31', '1', '465288', '0', ''),
('196', '1', '135', '1', '69', '2013-05-28', '-180492', '0', '0', '0', '  K.S.N. Silwathge', '2013-06-30', '1', '465289', '0', ''),
('197', '1', '136', '1', '70', '2013-05-28', '-155400', '0', '0', '0', '        U. K. T. Fernando', '2013-06-30', '1', '465290', '0', ''),
('198', '1', '137', '1', '71', '2013-05-28', '-117600', '0', '0', '0', '       J. M. D. C. Jayasinghe', '2013-06-30', '1', '465291', '0', ''),
('199', '1', '138', '1', '72', '2013-05-28', '-113400', '0', '0', '0', 'Rasanka Indrajith Jayawardhana', '2013-05-31', '1', '465292', '0', ''),
('200', '1', '139', '1', '73', '2013-06-03', '-349276', '0', '0', '0', 'New Grand Taxi', '2013-06-30', '0', '465293', '0', ''),
('201', '1', '140', '1', '74', '2013-06-04', '-508295', '0', '0', '4', '4', '2013-06-30', '0', '465294', '0', ''),
('202', '1', '141', '1', '75', '2013-06-04', '-76244', '0', '0', '4', '5', '2013-06-30', '0', '465295', '0', ''),
('203', '1', '142', '1', '76', '2013-06-19', '-23256', '0', '0', '4', '6', '2013-06-30', '0', '465296', '0', ''),
('204', '1', '143', '1', '77', '2013-06-21', '-12500', '0', '0', '0', 'Cash', '2013-08-31', '1', '465297', '0', ''),
('205', '1', '144', '1', '78', '2013-06-21', '-13000', '0', '0', '0', 'Cash', '2013-06-30', '1', '465298', '0', ''),
('206', '1', '145', '1', '79', '2013-07-03', '-343535', '0', '0', '4', NULL, '2013-07-31', '0', '465299', '1', 'SB/CA/07/2013/P/1'),
('207', '1', '146', '1', '80', '2013-07-03', '-51530', '0', '0', '4', '5', '2013-07-31', '0', '554501', '2', 'SB/CA/07/2013/P/2'),
('208', '1', '147', '1', '81', '2013-07-03', '-360315', '0', '0', '0', 'New Grand Taxi', '2013-07-31', '0', '465300', '3', 'SB/CA/07/2013/P/3'),
('209', '1', '148', '1', '82', '2013-07-03', '-35000', '0', '0', '0', 'Uddeshika Jayawardena', '2013-07-31', '1', '465301', '4', 'SB/CA/07/2013/P/4'),
('210', '1', '149', '1', '83', '2013-07-03', '-50000', '0', '0', '0', 'Manoj Fernando', '2013-07-31', '1', '465302', '5', 'SB/CA/07/2013/P/5'),
('211', '1', '150', '1', '84', '2013-07-10', '-20000', '0', '0', '0', 'Nishan Jinadasa', '2013-07-31', '1', '465303', '6', 'SB/CA/07/2013/P/6'),
('212', '1', '151', '1', '85', '2013-07-12', '-60000', '0', '0', '0', 'Cash', '2013-07-31', '1', '554506', '7', 'SB/CA/07/2013/P/7'),
('213', '1', '152', '1', '86', '2013-07-12', '-13000', '0', '0', '0', 'Cash', '2013-07-31', '1', '554507', '8', 'SB/CA/07/2013/P/8'),
('214', '1', '153', '1', '87', '2013-07-25', '-7500', '0', '0', '0', 'Cash', '2013-08-31', '1', '554508', '9', 'SB/CA/07/2013/P/9'),
('215', '1', '154', '1', '88', '2013-07-25', '-5000', '0', '0', '0', 'Nishan Jinadasa', '2013-07-31', '1', '554509', '10', 'SB/CA/07/2013/P/10'),
('216', '1', '155', '1', '89', '2013-07-30', '-100000', '0', '0', '0', 'New Grand Taxi', '2013-07-31', '0', '554510', '11', 'SB/CA/07/2013/P/11'),
('217', '1', '156', '1', '90', '2013-07-31', '-222598', '0', '0', '0', 'New Grand Taxi', '2013-08-31', '0', '554511', '12', 'SB/CA/07/2013/P/12'),
('218', '1', '157', '1', '91', '2013-08-02', '-406535', '0', '0', '4', '4', '2013-08-31', '0', '554512', '13', 'SB/CA/08/2013/P/13'),
('219', '1', '158', '1', '92', '2013-08-02', '-60980', '0', '0', '4', '5', '2013-08-31', '0', '554513', '14', 'SB/CA/08/2013/P/14'),
('220', '1', '159', '1', '93', '2013-08-02', '-60000', '0', '0', '0', 'Uddeshika Jayawardena', '2013-08-31', '1', '554514', '15', 'SB/CA/08/2013/P/15'),
('221', '1', '160', '1', '94', '2013-08-02', '-13000', '0', '0', '0', 'Uddeshika Jayawardena', '2013-08-31', '1', '554515', '16', 'SB/CA/08/2013/P/16'),
('222', '1', '161', '1', '1001', '2011-04-07', '-300000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2011-04-30', '0', '14968', '17', 'SB/CA/08/2013/P/17'),
('223', '1', '161', '5', '1001', '2011-04-07', '300000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '14968', '17', 'SB/CA/08/2013/P/17'),
('224', '1', '162', '1', '1002', '2011-04-07', '-1649.57', '0', '0', '0', 'Bank charges', '2011-04-30', '0', '1002', '18', 'SB/CA/08/2013/P/18'),
('225', '1', '163', '1', '1003', '2011-04-07', '-981467', '0', '0', '0', 'Staff Salaries', '2011-04-30', '0', '14971', '19', 'SB/CA/08/2013/P/19'),
('226', '1', '164', '1', '95', '2011-04-07', '-1600', '0', '0', '0', 'Bank charges', '2011-04-30', '0', '14972', '20', 'SB/CA/08/2013/P/20'),
('227', '2', '8', '1', '8', '2011-04-07', '1000000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2011-04-30', '0', '0', '1', 'SB/CA/08/2013/D/1'),
('228', '2', '8', '5', '8', '2011-04-07', '-1000000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '0', '1', 'SB/CA/08/2013/D/1'),
('229', '2', '9', '1', '9', '2011-05-16', '210000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2011-05-31', '0', '0', '2', 'SB/CA/08/2013/D/2'),
('230', '2', '9', '5', '9', '2011-05-16', '-210000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '0', '2', 'SB/CA/08/2013/D/2'),
('231', '2', '10', '1', '10', '2011-05-24', '1200000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2011-05-31', '0', '0', '3', 'SB/CA/08/2013/D/3'),
('232', '2', '10', '5', '10', '2011-05-24', '-1200000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '0', '3', 'SB/CA/08/2013/D/3'),
('233', '2', '11', '1', '11', '2011-06-01', '50000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2011-06-30', '0', '0', '4', 'SB/CA/08/2013/D/4'),
('234', '2', '11', '5', '11', '2011-06-01', '-50000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '0', '4', 'SB/CA/08/2013/D/4'),
('235', '2', '12', '1', '12', '2011-06-27', '0', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2011-06-30', '0', '0', '5', 'SB/CA/08/2013/D/5'),
('236', '2', '13', '1', '13', '2011-06-29', '300000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2011-06-30', '0', '0', '6', 'SB/CA/08/2013/D/6'),
('237', '2', '13', '5', '13', '2011-06-29', '-300000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '0', '6', 'SB/CA/08/2013/D/6'),
('238', '2', '14', '1', '14', '2011-07-05', '20000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2011-07-31', '0', '0', '7', 'SB/CA/08/2013/D/7'),
('239', '2', '14', '5', '14', '2011-07-05', '-20000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '0', '7', 'SB/CA/08/2013/D/7'),
('240', '2', '15', '1', '15', '2011-07-26', '1000000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2011-07-31', '0', '0', '8', 'SB/CA/08/2013/D/8'),
('241', '2', '15', '5', '15', '2011-07-26', '-1000000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '0', '8', 'SB/CA/08/2013/D/8'),
('242', '2', '16', '1', '16', '2011-07-28', '0', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2011-07-31', '0', '0', '9', 'SB/CA/08/2013/D/9'),
('243', '2', '16', '5', '16', '2011-07-28', '0', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '0', '9', 'SB/CA/08/2013/D/9'),
('244', '1', '165', '1', '96', '2011-05-23', '-188000', '0', '0', '4', '4', '2011-05-31', '0', '14971', '21', 'SB/CA/08/2013/P/21'),
('245', '1', '166', '1', '97', '2011-05-23', '-28200', '0', '0', '4', '5', '2011-05-31', '0', '14972', '22', 'SB/CA/08/2013/P/22'),
('246', '1', '167', '1', '98', '2011-05-23', '-50000', '0', '0', '0', 'Lakpriya Edirisinghe', '2011-05-31', '0', '14973', '23', 'SB/CA/08/2013/P/23'),
('247', '1', '168', '1', '99', '2011-05-23', '-1007495.8', '0', '0', '0', 'Staff Salaries', '2011-05-31', '0', '14974', '24', 'SB/CA/08/2013/P/24'),
('248', '1', '169', '1', '100', '2011-06-27', '-958518', '0', '0', '0', 'Staff Salaries', '2011-06-30', '0', '14975', '25', 'SB/CA/08/2013/P/25'),
('249', '1', '170', '1', '101', '2011-06-27', '-500', '0', '0', '0', 'Bank charges', '2011-06-30', '0', '14976', '26', 'SB/CA/08/2013/P/26'),
('250', '1', '171', '1', '102', '2011-06-27', '-1500', '0', '0', '0', 'Bank charges', '2011-06-30', '0', '14977', '27', 'SB/CA/08/2013/P/27'),
('251', '1', '172', '1', '103', '2011-06-03', '-188000', '0', '0', '4', '4', '2011-06-30', '0', '14974', '28', 'SB/CA/08/2013/P/28'),
('252', '1', '173', '1', '104', '2011-06-03', '-28200', '0', '0', '4', '5', '2011-06-30', '0', '14975', '29', 'SB/CA/08/2013/P/29'),
('253', '1', '174', '1', '105', '2011-06-03', '-195000', '0', '0', '0', 'Mr.Kevin Vaz', '2011-06-30', '0', '14978', '30', 'SB/CA/08/2013/P/30'),
('254', '1', '175', '1', '106', '2011-06-30', '-165000', '0', '0', '0', 'Harsha Edirisinghe', '2011-06-30', '0', '14977', '31', 'SB/CA/08/2013/P/31'),
('255', '1', '176', '1', '107', '2011-07-05', '-172000', '0', '0', '4', '4', '2011-07-31', '0', '14978', '32', 'SB/CA/08/2013/P/32'),
('256', '1', '177', '1', '108', '2011-07-05', '-25800', '0', '0', '4', '5', '2011-07-31', '0', '14980', '33', 'SB/CA/08/2013/P/33'),
('257', '1', '178', '1', '109', '2011-07-27', '-808743', '0', '0', '0', 'Staff Salaries', '2011-07-31', '0', '14979', '34', 'SB/CA/08/2013/P/34'),
('258', '1', '179', '1', '110', '2011-07-27', '-1200', '0', '0', '0', 'Bank charges', '2011-07-31', '0', '14980', '35', 'SB/CA/08/2013/P/35'),
('259', '1', '180', '1', '111', '2011-08-01', '-66833', '0', '0', '0', 'Staff Salaries', '2011-08-31', '0', '14981', '36', 'SB/CA/08/2013/P/36'),
('260', '1', '181', '1', '112', '2011-08-01', '-50', '0', '0', '0', 'Bank charges', '2011-08-31', '0', '14982', '37', 'SB/CA/08/2013/P/37'),
('261', '1', '182', '1', '113', '2011-08-04', '-148000', '0', '0', '4', '4', '2011-08-31', '0', '14983', '38', 'SB/CA/08/2013/P/38'),
('262', '1', '183', '1', '114', '2011-08-04', '-22200', '0', '0', '4', '5', '2011-08-31', '0', '14982', '39', 'SB/CA/08/2013/P/39'),
('263', '1', '184', '1', '115', '2011-08-28', '-808743', '0', '0', '0', 'Staff Salaries', '2011-08-31', '0', '14984', '40', 'SB/CA/08/2013/P/40'),
('264', '1', '185', '1', '116', '2011-08-28', '-1300', '0', '0', '0', 'Bank charges', '2011-08-31', '0', '14985', '41', 'SB/CA/08/2013/P/41'),
('265', '2', '17', '1', '16', '2011-08-01', '50000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2011-08-31', '0', '0', '10', 'SB/CA/08/2013/D/10'),
('266', '2', '17', '5', '16', '2011-08-01', '-50000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '0', '10', 'SB/CA/08/2013/D/10'),
('267', '2', '18', '1', '17', '2011-08-01', '700000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2011-08-31', '0', '0', '11', 'SB/CA/08/2013/D/11'),
('268', '2', '18', '5', '17', '2011-08-01', '-700000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '0', '11', 'SB/CA/08/2013/D/11'),
('269', '2', '19', '1', '18', '2011-08-29', '274400', '0', '0', '0', 'Institute of IT', '2011-08-31', '0', '0', '12', 'SB/CA/08/2013/D/12'),
('270', '1', '186', '1', '117', '2011-09-05', '-167940', '0', '0', '4', '4', '2011-09-30', '0', '14983', '42', 'SB/CA/08/2013/P/42'),
('271', '1', '187', '1', '118', '2011-09-05', '-25191', '0', '0', '4', '5', '2011-09-30', '0', '14984', '43', 'SB/CA/08/2013/P/43'),
('272', '1', '188', '1', '119', '2011-09-05', '-820303', '0', '0', '0', 'Staff Salaries', '2011-09-30', '0', '14986', '44', 'SB/CA/08/2013/P/44'),
('273', '1', '189', '1', '120', '2011-09-05', '-1500', '0', '0', '0', 'Bank charges', '2011-09-30', '0', '14987', '45', 'SB/CA/08/2013/P/45'),
('274', '1', '190', '1', '121', '2011-09-29', '-300', '0', '0', '0', 'Bank charges', '2011-09-30', '0', '14988', '46', 'SB/CA/08/2013/P/46'),
('275', '2', '20', '1', '19', '2011-09-05', '50000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2011-09-30', '0', '0', '13', 'SB/CA/08/2013/D/13'),
('276', '2', '20', '5', '19', '2011-09-05', '-50000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '0', '13', 'SB/CA/08/2013/D/13'),
('277', '2', '21', '1', '20', '2011-09-28', '1047350', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2011-09-30', '0', '0', '14', 'SB/CA/08/2013/D/14'),
('278', '2', '21', '5', '20', '2011-09-28', '-1047350', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '0', '14', 'SB/CA/08/2013/D/14'),
('279', '1', '191', '1', '122', '2011-10-03', '-25191', '0', '0', '4', '5', '2011-10-31', '0', '14985', '47', 'SB/CA/08/2013/P/47'),
('280', '1', '192', '1', '123', '2011-10-03', '-167940', '0', '0', '4', '4', '2011-10-31', '0', '14986', '48', 'SB/CA/08/2013/P/48'),
('281', '1', '193', '1', '124', '2011-10-27', '-909843', '0', '0', '0', 'Staff Salaries', '2011-10-31', '0', '14989', '49', 'SB/CA/08/2013/P/49'),
('282', '2', '22', '1', '21', '2011-10-27', '1000000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2011-10-31', '0', '0', '15', 'SB/CA/08/2013/D/15'),
('283', '2', '22', '5', '21', '2011-10-27', '-1000000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', NULL, '0', '0', '15', 'SB/CA/08/2013/D/15'),
('284', '2', '23', '1', '22', '2011-11-09', '50000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2011-11-30', '0', '0', '16', 'SB/CA/08/2013/D/16'),
('285', '2', '23', '5', '22', '2011-11-09', '-50000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', NULL, '0', '0', '16', 'SB/CA/08/2013/D/16'),
('286', '2', '24', '1', '23', '2011-11-09', '100000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2011-11-30', '0', '0', '17', 'SB/CA/08/2013/D/17'),
('287', '2', '24', '5', '23', '2011-11-09', '-100000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', NULL, '0', '0', '17', 'SB/CA/08/2013/D/17'),
('288', '2', '25', '1', '24', '2011-11-28', '900000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2011-11-30', '0', '0', '18', 'SB/CA/08/2013/D/18'),
('289', '2', '25', '5', '24', '2011-11-28', '-900000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', NULL, '0', '0', '18', 'SB/CA/08/2013/D/18'),
('290', '1', '194', '1', '125', '2011-11-10', '-166140', '0', '0', '4', '4', '2011-11-30', '0', '14990', '50', 'SB/CA/08/2013/P/50'),
('291', '1', '195', '1', '126', '2011-11-10', '-24921', '0', '0', '4', '5', '2011-11-30', '0', '14991', '51', 'SB/CA/08/2013/P/51'),
('292', '1', '196', '1', '127', '2011-11-10', '-99991.22', '0', '0', '0', 'High Level Express', '2011-11-30', '0', '14992', '52', 'SB/CA/08/2013/P/52'),
('293', '1', '197', '1', '128', '2011-11-28', '-850343', '0', '0', '0', 'Staff Salaries', '2011-11-30', '0', '14993', '53', 'SB/CA/08/2013/P/53'),
('294', '1', '198', '1', '129', '2011-11-28', '-1450', '0', '0', '0', 'Bank commission', '2011-11-30', '0', '14994', '54', 'SB/CA/08/2013/P/54'),
('295', '1', '199', '1', '130', '2011-11-28', '-750', '0', '0', '0', 'Bank charges', '2011-12-31', '0', '14995', '55', 'SB/CA/08/2013/P/55'),
('296', '1', '200', '1', '131', '2011-12-02', '-22521', '0', '0', '4', '5', '2011-12-31', '0', '14995', '56', 'SB/CA/08/2013/P/56'),
('297', '1', '201', '1', '132', '2011-12-02', '-150140', '0', '0', '4', '4', '2011-12-31', '0', '14996', '57', 'SB/CA/08/2013/P/57'),
('298', '1', '202', '1', '133', '2011-12-19', '-500', '0', '0', '0', 'Bank charges', '2011-12-31', '0', '14997', '58', 'SB/CA/08/2013/P/58'),
('299', '1', '203', '1', '134', '2011-12-19', '-816943', '0', '0', '0', 'Staff Salaries', '2011-12-31', '0', '14998', '59', 'SB/CA/08/2013/P/59'),
('300', '1', '204', '1', '135', '2011-12-22', '-1400', '0', '0', '0', 'Bank commission', '2011-12-31', '0', '14999', '60', 'SB/CA/08/2013/P/60'),
('301', '1', '205', '1', '136', '2011-12-22', '-80452', '0', '0', '0', 'Staff Salaries', '2011-12-31', '0', '15000', '61', 'SB/CA/08/2013/P/61'),
('302', '1', '206', '1', '137', '2011-12-22', '-500', '0', '0', '0', 'Bank commission', '2011-12-31', '0', '15001', '62', 'SB/CA/08/2013/P/62'),
('303', '2', '26', '1', '25', '2011-12-22', '150000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2011-12-31', '0', '0', '19', 'SB/CA/08/2013/D/19'),
('304', '2', '26', '5', '25', '2011-12-22', '-150000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', NULL, '0', '0', '19', 'SB/CA/08/2013/D/19'),
('305', '2', '27', '1', '26', '2011-12-22', '1000000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2011-12-31', '0', '0', '20', 'SB/CA/08/2013/D/20'),
('306', '2', '27', '5', '26', '2011-12-22', '-1000000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', NULL, '0', '0', '20', 'SB/CA/08/2013/D/20'),
('307', '2', '28', '1', '27', '2012-01-04', '200000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2012-01-31', '0', '0', '21', 'SB/CA/08/2013/D/21'),
('308', '2', '28', '5', '27', '2012-01-04', '-200000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', NULL, '0', '0', '21', 'SB/CA/08/2013/D/21'),
('309', '2', '29', '1', '28', '2012-01-24', '1100000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2012-01-31', '0', '0', '22', 'SB/CA/08/2013/D/22'),
('310', '2', '29', '5', '28', '2012-01-24', '-1100000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', NULL, '0', '0', '22', 'SB/CA/08/2013/D/22'),
('311', '2', '30', '1', '29', '2012-01-31', '200000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2012-01-31', '0', '0', '23', 'SB/CA/08/2013/D/23'),
('312', '2', '30', '5', '29', '2012-01-31', '-200000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', NULL, '0', '0', '23', 'SB/CA/08/2013/D/23'),
('313', '1', '207', '1', '138', '2012-01-31', '-26391', '0', '0', '4', '5', '2012-01-31', '0', '14997', '63', 'SB/CA/08/2013/P/63'),
('314', '1', '208', '1', '139', '2012-01-31', '-150140', '0', '0', '4', '4', '2012-01-31', '0', '114998', '64', 'SB/CA/08/2013/P/64'),
('315', '1', '209', '1', '140', '2012-01-03', '-145348', '0', '0', '4', '6', '2012-01-31', '0', '15002', '65', 'SB/CA/08/2013/P/65'),
('316', '1', '210', '1', '141', '2012-01-27', '-155940', '0', '0', '4', '4', '2012-01-31', '0', '257201', '66', 'SB/CA/08/2013/P/66'),
('317', '1', '211', '1', '142', '2012-01-27', '-20241', '0', '0', '4', '5', '2012-01-31', '0', '257202', '67', 'SB/CA/08/2013/P/67'),
('318', '1', '212', '1', '143', '2012-01-27', '-148446.97', '0', '0', '0', 'High Level Express', '2012-02-29', '0', '15003', '68', 'SB/CA/08/2013/P/68'),
('319', '1', '213', '1', '144', '2012-01-27', '-922588', '0', '0', '0', 'Staff Salaries', '2012-01-31', '0', '15004', '69', 'SB/CA/08/2013/P/69'),
('320', '1', '214', '1', '145', '2012-01-27', '-500', '0', '0', '0', 'Bank commission', '2012-01-31', '0', '15005', '70', 'SB/CA/08/2013/P/70'),
('321', '2', '31', '1', '30', '2012-02-27', '1100000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2012-02-29', '0', '0', '24', 'SB/CA/08/2013/D/24'),
('322', '2', '31', '5', '30', '2012-02-27', '-1100000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', NULL, '0', '0', '24', 'SB/CA/08/2013/D/24'),
('323', '2', '32', '1', '31', '2012-03-20', '250000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2012-03-31', '0', '0', '25', 'SB/CA/08/2013/D/25'),
('324', '2', '32', '5', '31', '2012-03-20', '-250000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', NULL, '0', '0', '25', 'SB/CA/08/2013/D/25'),
('325', '2', '33', '1', '32', '2012-03-20', '1500000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2012-03-31', '0', '0', '26', 'SB/CA/08/2013/D/26'),
('326', '2', '33', '5', '32', '2012-03-20', '-1500000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', NULL, '0', '0', '26', 'SB/CA/08/2013/D/26'),
('327', '1', '215', '1', '146', '2012-02-26', '-929788', '0', '0', '0', 'Staff Salaries', '2012-02-29', '0', '15006', '71', 'SB/CA/08/2013/P/71'),
('328', '1', '216', '1', '147', '2012-02-26', '-500', '0', '0', '0', 'Bank commission', '2012-02-29', '0', '15007', '72', 'SB/CA/08/2013/P/72'),
('329', '1', '217', '1', '148', '2012-03-27', '-1005706', '0', '0', '0', 'Staff Salaries', '2012-03-31', '0', '15008', '73', 'SB/CA/08/2013/P/73'),
('330', '1', '218', '1', '149', '2012-03-27', '-500', '0', '0', '0', 'Bank charges', '2012-03-31', '0', '15009', '74', 'SB/CA/08/2013/P/74'),
('331', '1', '219', '1', '150', '2012-02-15', '-200', '0', '0', '0', 'Bank charges', '2012-02-29', '0', '15010', '75', 'SB/CA/08/2013/P/75'),
('332', '1', '220', '1', '15', '2012-03-09', '-17943', '0', '0', '4', '6', '2012-03-31', '0', '257207', '76', 'SB/CA/08/2013/P/76'),
('333', '12', '9', '5', '9', '2011-04-30', '1432415', '0', '0', '2', '1', NULL, '0', '0', '27', 'ET/08/2013/D/27'),
('334', '12', '10', '5', '10', '2011-05-27', '1451439', '0', '0', '2', '1', NULL, '0', '0', '28', 'ET/08/2013/D/28'),
('335', '12', '11', '5', '11', '2011-06-28', '1378415', '0', '0', '2', '1', NULL, '0', '0', '29', 'ET/08/2013/D/29'),
('336', '12', '12', '5', '12', '2011-07-28', '1226434', '0', '0', '2', '1', NULL, '0', '0', '30', 'ET/08/2013/D/30'),
('337', '12', '13', '5', '13', '2011-08-28', '1273934', '0', '0', '2', '1', NULL, '0', '0', '31', 'ET/08/2013/D/31'),
('338', '12', '14', '5', '14', '2011-09-28', '1049751', '0', '0', '2', '1', NULL, '0', '0', '32', 'ET/08/2013/D/32'),
('339', '12', '15', '5', '15', '2011-10-27', '1417608', '0', '0', '2', '1', NULL, '0', '0', '33', 'ET/08/2013/D/33'),
('340', '12', '16', '5', '16', '2011-11-27', '1278308', '0', '0', '2', '1', NULL, '0', '0', '34', 'ET/08/2013/D/34'),
('341', '12', '17', '5', '17', '2011-12-27', '1250308', '0', '0', '2', '1', NULL, '0', '0', '35', 'ET/08/2013/D/35'),
('342', '12', '18', '5', '18', '2012-01-27', '1385911', '0', '0', '2', '1', NULL, '0', '0', '36', 'ET/08/2013/D/36'),
('343', '12', '19', '5', '19', '2012-02-27', '1470462', '0', '0', '2', '1', NULL, '0', '0', '37', 'ET/08/2013/D/37'),
('344', '12', '20', '5', '20', '2012-03-29', '1594273', '0', '0', '2', '1', NULL, '0', '0', '38', 'ET/08/2013/D/38'),
('345', '2', '34', '1', '12', '2011-06-27', '1200000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2012-03-31', '0', '0', '27', 'SB/CA/08/2013/D/27'),
('346', '2', '34', '5', '12', '2011-06-27', '-1200000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '0', '27', 'SB/CA/08/2013/D/27'),
('347', '1', '221', '5', '151', '2011-07-11', '-15594', '0', '0', '0', 'P.A.Y.E', NULL, '0', '15011', '18', 'ET/08/2013/P/18'),
('348', '1', '222', '5', '152', '2011-08-23', '-5781', '0', '0', '0', 'P.A.Y.E', NULL, '0', '15012', '19', 'ET/08/2013/P/19'),
('349', '1', '223', '5', '153', '2011-08-23', '-69530', '0', '0', '0', 'Chanaka Padmaperuma', NULL, '0', '15013', '20', 'ET/08/2013/P/20'),
('350', '1', '224', '5', '154', '2012-01-25', '-181944', '0', '0', '0', 'Flex Advertising', NULL, '0', '15014', '21', 'ET/08/2013/P/21'),
('351', '1', '225', '7', '155', '2013-08-22', '-7500', '0', '0', '0', 'Cash', NULL, '1', '15015', '77', 'SB/CA/08/2013/P/77'),
('352', '1', '226', '1', '156', '2013-08-22', '-162925', '0', '0', '0', 'New Grand Taxi', '2013-08-31', '0', '554520', '78', 'SB/CA/08/2013/P/78'),
('353', '1', '227', '1', '157', '2013-08-22', '0', '0', '0', '0', 'IAS Solutions (Pvt)Ltd.', '2013-08-31', '0', '554521', '79', 'SB/CA/08/2013/P/79'),
('354', '0', '12', '5', '11', '2012-03-30', '-1468661.8', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('355', '0', '14', '5', '13', '2012-03-30', '-92895.41', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('356', '1', '228', '1', '158', '2013-08-30', '-385535', '0', '0', '4', 'Quick Entry The Superintendent, Employees Provident Fund', '2013-09-30', '0', '554522', '78', 'ET/08/2013/P/78'),
('357', '1', '229', '1', '159', '2013-08-30', '-57830.25', '0', '0', '4', 'Quick Entry Employees Trust Fund', '2013-09-30', '0', '554523', '79', 'ET/08/2013/P/79'),
('358', '1', '230', '1', '160', '2013-09-03', '-194471', '0', '0', '0', 'New Grand Taxi', '2013-09-30', '0', '554524', '80', 'SB/CA/09/2013/P/80'),
('359', '1', '231', '5', '161', '2013-09-06', '0', '0', '0', '0', 'Cash', NULL, '0', '554525', '78', 'ET/09/2013/P/78'),
('360', '1', '232', '1', '161', '2013-09-06', '-5919', '0', '0', '0', 'Cash', '2013-09-30', '1', '554526', '81', 'SB/CA/09/2013/P/81'),
('361', '1', '233', '1', '161', '2013-09-20', '-194749', '0', '0', '0', 'New Grand Taxi', '2013-09-30', '0', '554527', '82', 'SB/CA/09/2013/P/82'),
('362', '1', '234', '1', '162', '2013-09-26', '-358535', '0', '0', '4', '4', '2013-10-31', '0', '554527', '83', 'SB/CA/09/2013/P/83'),
('363', '1', '235', '1', '163', '2013-09-26', '-53780', '0', '0', '4', '5', '2013-10-31', '0', '554528', '84', 'SB/CA/09/2013/P/84'),
('364', '1', '236', '1', '164', '2013-10-03', '-171455', '0', '0', '0', 'New Grand Taxi', '2013-10-31', '0', '554529', '85', 'SB/CA/10/2013/P/85'),
('365', '1', '237', '1', '165', '2013-10-08', '0', '0', '0', '0', 'Cash', '2013-10-31', '1', '554530', '86', 'SB/CA/10/2013/P/86'),
('366', '1', '237', '1', '165', '2013-10-08', '0', '0', '0', '0', 'Cash', NULL, '1', '554530', '86', 'SB/CA/10/2013/P/86'),
('367', '1', '238', '1', '166', '2013-10-08', '-10513.6', '0', '0', '0', 'Cash', '2013-10-31', '1', '554531', '87', 'SB/CA/10/2013/P/87'),
('368', '1', '239', '1', '167', '2013-10-10', '-7706.5', '0', '0', '0', 'Cash', '2013-10-31', '1', '554532', '88', 'SB/CA/10/2013/P/88'),
('369', '1', '240', '1', '168', '2013-10-10', '-3500', '0', '0', '0', 'Cash', '2013-10-31', '1', '554533', '89', 'SB/CA/10/2013/P/89'),
('370', '1', '241', '1', '169', '2013-10-14', '-12912.7', '0', '0', '0', 'Employees&#039; Trust Fund', '2013-10-31', '0', '554534', '90', 'SB/CA/10/2013/P/90'),
('371', '1', '242', '1', '170', '2013-10-17', '-134496', '0', '0', '0', 'New Grand Taxi', '2013-10-31', '0', '554535', '91', 'SB/CA/10/2013/P/91'),
('372', '1', '243', '1', '171', '2013-10-30', '-414135', '0', '0', '4', '4', '2013-11-30', '0', '554536', '92', 'SB/CA/10/2013/P/92'),
('373', '1', '244', '1', '172', '2013-10-30', '-62120', '0', '0', '4', '5', '2013-10-31', '0', '554537', '93', 'SB/CA/10/2013/P/93'),
('374', '1', '245', '1', '173', '2013-10-30', '-5487', '0', '0', '0', 'Cash', '2013-11-30', '1', '554538', '94', 'SB/CA/10/2013/P/94'),
('375', '1', '246', '1', '174', '2013-11-01', '-143207', '0', '0', '0', 'New Grand Taxi', '2013-11-30', '0', '554539', '95', 'SB/CA/11/2013/P/95'),
('376', '1', '247', '1', '175', '2013-11-06', '-20000', '0', '0', '0', 'Cash', '2013-11-30', '1', '554540', '96', 'SB/CA/11/2013/P/96'),
('377', '1', '248', '1', '176', '2013-11-06', '0', '0', '0', '0', 'Cash', '2013-11-30', '1', '554541', '97', 'SB/CA/11/2013/P/97'),
('378', '1', '248', '1', '176', '2013-11-06', '0', '0', '0', '0', 'Cash', NULL, '1', '554541', '97', 'SB/CA/11/2013/P/97'),
('379', '1', '249', '1', '177', '2013-11-11', '-4300', '0', '0', '0', 'Uddeshika Jayawardhane', '2013-11-30', '1', '554542', '98', 'SB/CA/11/2013/P/98'),
('380', '1', '250', '1', '178', '2013-11-11', '-5487', '0', '0', '0', 'Lahiru Kumarasiri', '2013-12-31', '1', '554543', '99', 'SB/CA/11/2013/P/99'),
('381', '1', '251', '1', '179', '2013-11-20', '-15000', '0', '0', '0', 'Cash', '2013-11-30', '1', '554544', '100', 'SB/CA/11/2013/P/100'),
('382', '1', '252', '1', '180', '2013-11-20', '-3143.92', '0', '0', '0', 'Aadil Thowfeek', '2013-12-31', '1', '554545', '79', 'ET/11/2013/P/79'),
('383', '1', '253', '1', '181', '2013-11-21', '-2370', '0', '0', '0', 'Sanjaya Udara Pathirana', '2013-11-30', '1', '554547', '101', 'SB/CA/11/2013/P/101'),
('384', '1', '254', '1', '182', '2013-11-28', '-66658', '0', '0', '4', '5', '2013-11-30', '0', '554548', '102', 'SB/CA/11/2013/P/102'),
('385', '1', '255', '1', '183', '2013-11-28', '-444385', '0', '0', '4', '4', '2013-12-31', '0', '554549', '103', 'SB/CA/11/2013/P/103'),
('386', '1', '256', '1', '184', '2013-11-28', '-30000', '0', '0', '0', 'Cash', '2013-12-31', '1', '554550', '104', 'SB/CA/11/2013/P/104'),
('387', '1', '257', '1', '185', '2013-11-28', '-15000', '0', '0', '0', 'Casons taxi company(pvt) ltd', '2013-12-31', '0', '638701', '105', 'SB/CA/11/2013/P/105'),
('388', '1', '258', '1', '186', '2013-12-04', '-181210', '0', '0', '0', 'Highlevel Express (PVT) LTD', '2013-12-31', '0', '554546', '106', 'SB/CA/12/2013/P/106'),
('389', '1', '259', '1', '187', '2013-12-06', '-100000', '0', '0', '0', 'Cash', '2013-12-31', '1', '638703', '107', 'SB/CA/12/2013/P/107'),
('390', '1', '260', '1', '188', '2013-12-10', '-210000', '0', '0', '0', 'Cash', '2013-12-31', '1', '638704', '108', 'SB/CA/12/2013/P/108'),
('391', '1', '261', '1', '189', '2013-12-31', '-478305', '0', '0', '4', '4', '2014-01-31', '0', '638705', '109', 'SB/CA/12/2013/P/109'),
('392', '1', '262', '1', '190', '2013-12-31', '-71745', '0', '0', '4', '5', '2014-01-31', '0', '638706', '110', 'SB/CA/12/2013/P/110'),
('393', '1', '263', '1', '191', '2014-01-06', '-80000', '0', '0', '0', 'GENESIIS SOFTWARE (PVT) LTD', '2014-01-31', '0', '638707', '111', 'SB/CA/01/2014/P/111'),
('394', '1', '264', '1', '192', '2014-01-06', '-7500', '0', '0', '0', 'Malka Weerasinghe', '2014-01-31', '1', '638708', '112', 'SB/CA/01/2014/P/112'),
('395', '1', '265', '1', '193', '2014-01-06', '-12500', '0', '0', '0', 'Dylan Beekmeyer ', '2014-01-31', '1', '638709', '113', 'SB/CA/01/2014/P/113'),
('396', '1', '266', '1', '194', '2014-01-06', '-8333', '0', '0', '0', 'Cash', '2014-01-31', '1', '638710', '114', 'SB/CA/01/2014/P/114'),
('397', '1', '267', '1', '195', '2014-01-09', '-35000', '0', '0', '0', 'Nishan Jinadasa', '2014-01-31', '1', '638712', '115', 'SB/CA/01/2014/P/115'),
('398', '1', '268', '1', '196', '2014-01-13', '-100000', '0', '0', '0', 'Cash', '2014-01-31', '1', '638713', '116', 'SB/CA/01/2014/P/116'),
('399', '1', '269', '1', '197', '2014-01-13', '-50000', '0', '0', '0', 'Nishan Jinadasa', '2014-01-31', '1', '638714', '80', 'ET/01/2014/P/80'),
('400', '1', '270', '1', '198', '2014-01-13', '-22400', '0', '0', '0', 'Cash', '2014-01-31', '1', '638715', '117', 'SB/CA/01/2014/P/117'),
('401', '1', '271', '1', '199', '2014-01-17', '-2000', '0', '0', '0', 'Uddeshika Jayawardhane', '2014-01-31', '1', '638716', '118', 'SB/CA/01/2014/P/118'),
('402', '1', '272', '1', '200', '2014-01-17', '-5048', '0', '0', '0', 'Manoj Fernando', '2014-01-31', '1', '638717', '119', 'SB/CA/01/2014/P/119'),
('403', '1', '273', '1', '201', '2014-01-17', '-2525', '0', '0', '0', 'Arshad Zackeriya', '2014-01-31', '1', '638718', '120', 'SB/CA/01/2014/P/120'),
('404', '1', '274', '1', '202', '2014-01-17', '-238064.3', '0', '0', '0', 'CASONS TAXI COMPANY (PVT) LTD', '2014-01-31', '0', '638719', '121', 'SB/CA/01/2014/P/121'),
('405', '1', '275', '1', '203', '2014-01-21', '-319880.4', '0', '0', '4', 'Quick Entry The Superintendent, Employees Provident Fund', '2014-02-28', '0', '638720', '80', 'ET/01/2014/P/80'),
('406', '1', '276', '1', '204', '2014-01-24', '-7500', '0', '0', '0', 'Mewan Samarasinghe', '2014-01-31', '1', '638721', '122', 'SB/CA/01/2014/P/122'),
('407', '1', '277', '1', '205', '2014-01-24', '-7500', '0', '0', '0', 'Dylan Beekmeyer', '2014-01-31', '1', '638722', '123', 'SB/CA/01/2014/P/123'),
('408', '1', '278', '1', '206', '2014-01-31', '-446545', '0', '0', '4', '4', '2014-02-28', '0', '638723', '124', 'SB/CA/01/2014/P/124'),
('409', '1', '279', '1', '207', '2014-01-31', '-66982', '0', '0', '4', 'Quick Entry ', '2014-02-28', '0', '638724', '81', 'ET/01/2014/P/81'),
('410', '1', '280', '1', '208', '2014-02-03', '-54235', '0', '0', '0', 'HIGHLEVEL EXPRESS (PVT) LTD', '2014-02-28', '0', '638725', '125', 'SB/CA/02/2014/P/125'),
('411', '1', '281', '1', '209', '2014-02-03', '0', '0', '0', '0', 'Cash', NULL, '0', '0', '126', 'SB/CA/02/2014/P/126'),
('412', '2', '35', '1', '33', '2011-04-27', '0', '0', '0', '0', 'Cash', '2012-04-30', '0', '0', '28', 'SB/CA/02/2014/D/28'),
('413', '2', '35', '5', '33', '2011-04-27', '0', '0', '0', '0', 'Cash', NULL, '0', '0', '28', 'SB/CA/02/2014/D/28'),
('414', '1', '282', '1', '210', '2012-04-27', '-0.01', '0', '0', '0', 'Cash', '2012-04-30', '0', '0', '127', 'SB/CA/02/2014/P/127'),
('415', '2', '36', '5', '34', '2012-05-08', '200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '39', 'ET/02/2014/D/39'),
('416', '2', '36', '5', '34', '2012-05-08', '-200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '39', 'ET/02/2014/D/39'),
('417', '2', '37', '5', '35', '2012-05-25', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '40', 'ET/02/2014/D/40'),
('418', '2', '37', '5', '35', '2012-05-25', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '40', 'ET/02/2014/D/40'),
('419', '2', '38', '1', '36', '2012-05-08', '200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-05-30', '0', '0', '29', 'SB/CA/02/2014/D/29'),
('420', '2', '38', '5', '36', '2012-05-08', '-200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '29', 'SB/CA/02/2014/D/29');
INSERT INTO `1_bank_trans` VALUES
('421', '2', '39', '1', '37', '2012-05-25', '1800000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-05-30', '0', '0', '30', 'SB/CA/02/2014/D/30'),
('422', '2', '39', '5', '37', '2012-05-25', '-1800000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '30', 'SB/CA/02/2014/D/30'),
('423', '2', '40', '1', '38', '2012-06-15', '400000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-06-30', '0', '0', '31', 'SB/CA/02/2014/D/31'),
('424', '2', '40', '5', '38', '2012-06-15', '-400000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '31', 'SB/CA/02/2014/D/31'),
('425', '1', '283', '1', '211', '2012-06-27', '0', '0', '0', '0', 'Cash', '2012-06-30', '0', '0', '80', 'ET/02/2014/P/80'),
('426', '2', '41', '5', '39', '2012-06-27', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '41', 'ET/02/2014/D/41'),
('427', '2', '41', '5', '39', '2012-06-27', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '41', 'ET/02/2014/D/41'),
('428', '2', '42', '1', '40', '2012-06-27', '1750000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-06-30', '0', '0', '32', 'SB/CA/02/2014/D/32'),
('429', '2', '42', '5', '40', '2012-06-27', '-1750000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '32', 'SB/CA/02/2014/D/32'),
('430', '2', '43', '1', '41', '2012-07-23', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-07-31', '0', '0', '33', 'SB/CA/02/2014/D/33'),
('431', '2', '43', '5', '41', '2012-07-23', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '33', 'SB/CA/02/2014/D/33'),
('432', '2', '44', '1', '42', '2012-07-23', '400000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-07-31', '0', '0', '34', 'SB/CA/02/2014/D/34'),
('433', '2', '44', '5', '42', '2012-07-23', '-400000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '34', 'SB/CA/02/2014/D/34'),
('434', '2', '45', '5', '43', '2012-07-27', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '42', 'ET/02/2014/D/42'),
('435', '2', '45', '5', '43', '2012-07-27', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '42', 'ET/02/2014/D/42'),
('436', '2', '46', '1', '44', '2012-07-27', '2000000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-07-31', '0', '0', '35', 'SB/CA/02/2014/D/35'),
('437', '2', '46', '5', '44', '2012-07-27', '-2000000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '35', 'SB/CA/02/2014/D/35'),
('438', '2', '47', '1', '45', '2012-06-18', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '36', 'SB/CA/02/2014/D/36'),
('439', '2', '47', '5', '45', '2012-06-18', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '36', 'SB/CA/02/2014/D/36'),
('440', '1', '284', '1', '212', '2012-06-18', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-06-30', '0', '0', '128', 'SB/CA/02/2014/P/128'),
('441', '1', '285', '', '213', '0000-00-00', '0', '0', '0', '0', NULL, NULL, '0', '0', '129', 'SB/CA/02/2014/P/129'),
('442', '2', '48', '1', '45', '2012-08-28', '200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-08-31', '0', '0', '37', 'SB/CA/02/2014/D/37'),
('443', '2', '48', '5', '45', '2012-08-28', '-200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '37', 'SB/CA/02/2014/D/37'),
('444', '2', '49', '1', '46', '2012-08-28', '2200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-08-31', '0', '0', '38', 'SB/CA/02/2014/D/38'),
('445', '2', '49', '5', '46', '2012-08-28', '-2200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '38', 'SB/CA/02/2014/D/38'),
('446', '2', '50', '1', '47', '2012-09-04', '50000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-09-30', '0', '0', '39', 'SB/CA/02/2014/D/39'),
('447', '2', '50', '5', '47', '2012-09-04', '-50000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '39', 'SB/CA/02/2014/D/39'),
('448', '2', '51', '1', '48', '2012-09-04', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-09-30', '0', '0', '40', 'SB/CA/02/2014/D/40'),
('449', '2', '51', '5', '48', '2012-09-04', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '40', 'SB/CA/02/2014/D/40'),
('450', '2', '52', '1', '49', '2012-09-27', '2300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-09-30', '0', '0', '41', 'SB/CA/02/2014/D/41'),
('451', '2', '52', '5', '49', '2012-09-27', '-2300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '41', 'SB/CA/02/2014/D/41'),
('452', '2', '53', '1', '50', '2012-09-05', '300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-09-30', '0', '0', '42', 'SB/CA/02/2014/D/42'),
('453', '2', '53', '5', '50', '2012-09-05', '-300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '42', 'SB/CA/02/2014/D/42'),
('454', '2', '54', '1', '51', '2012-09-24', '300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-09-30', '0', '0', '43', 'SB/CA/02/2014/D/43'),
('455', '2', '54', '5', '51', '2012-09-24', '-300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '43', 'SB/CA/02/2014/D/43'),
('456', '1', '286', '1', '214', '2012-09-05', '-312563', '0', '0', '0', 'Cash', '2012-09-30', '0', '257232', '129', 'SB/CA/02/2014/P/129'),
('457', '2', '55', '1', '52', '2012-10-25', '2500000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-10-31', '0', '0', '44', 'SB/CA/02/2014/D/44'),
('458', '2', '55', '5', '52', '2012-10-25', '-2500000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '44', 'SB/CA/02/2014/D/44'),
('459', '2', '56', '5', '53', '2012-10-04', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '45', 'ET/02/2014/D/45'),
('460', '2', '56', '5', '53', '2012-10-04', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '45', 'ET/02/2014/D/45'),
('461', '2', '57', '1', '54', '2012-10-04', '300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-10-31', '0', '0', '45', 'SB/CA/02/2014/D/45'),
('462', '2', '57', '5', '54', '2012-10-04', '-300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '45', 'SB/CA/02/2014/D/45'),
('463', '1', '287', '1', '215', '2012-10-05', '0', '0', '0', '0', 'Cash', NULL, '0', '554547', '130', 'SB/CA/02/2014/P/130'),
('464', '1', '288', '1', '215', '2014-02-06', '-100000', '0', '0', '0', 'Cash', '2014-02-28', '1', '638726', '131', 'SB/CA/02/2014/P/131'),
('465', '1', '289', '1', '216', '2012-09-27', '-2093677.12', '0', '0', '0', 'Salaries', '2012-09-30', '0', '0', '132', 'SB/CA/02/2014/P/132'),
('466', '2', '58', '1', '55', '2012-11-26', '2500000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-11-30', '0', '0', '46', 'SB/CA/02/2014/D/46'),
('467', '2', '58', '5', '55', '2012-11-26', '-2500000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '46', 'SB/CA/02/2014/D/46'),
('468', '1', '290', '1', '217', '2012-11-26', '-2051038', '0', '0', '0', 'Salaries', '2012-11-30', '0', '0', '133', 'SB/CA/02/2014/P/133'),
('469', '2', '59', '1', '56', '2012-12-06', '200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-12-31', '0', '0', '47', 'SB/CA/02/2014/D/47'),
('470', '2', '59', '5', '56', '2012-12-06', '-200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '0', '47', 'SB/CA/02/2014/D/47'),
('471', '1', '291', '1', '218', '2012-12-17', '-500', '0', '0', '0', 'Cash', '2012-12-31', '0', '0', '134', 'SB/CA/02/2014/P/134'),
('472', '2', '60', '1', '57', '2012-12-18', '200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-12-31', '0', '0', '48', 'SB/CA/02/2014/D/48'),
('473', '2', '61', '1', '58', '2012-12-19', '100000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-12-31', '0', '0', '49', 'SB/CA/02/2014/D/49'),
('474', '1', '292', '1', '219', '2014-02-11', '-25000', '0', '0', '0', 'Uddeshika Jayawardhane', '2014-02-28', '1', '638727', '135', 'SB/CA/02/2014/P/135'),
('475', '1', '293', '1', '220', '2014-02-21', '-2779', '0', '0', '0', 'Prasanna Vivekanandarjah', '2014-03-31', '1', '638728', '136', 'SB/CA/02/2014/P/136'),
('476', '1', '294', '1', '221', '2014-02-24', '-6215', '0', '0', '0', 'Cash', '2014-02-28', '1', '638729', '137', 'SB/CA/02/2014/P/137'),
('477', '1', '295', '1', '222', '2014-02-28', '-295632.4', '0', '0', '0', 'CASONS TAXI COMPANY (PVT) LTD', '2014-03-31', '0', '638730', '138', 'SB/CA/02/2014/P/138'),
('478', '1', '296', '1', '223', '2014-03-03', '-12500', '0', '0', '0', 'Jude padidilian', '2014-03-31', '1', '638371', '139', 'SB/CA/03/2014/P/139'),
('479', '1', '297', '1', '224', '2014-03-03', '-7500', '0', '0', '0', 'Mewan Samarasinghe', '2014-03-31', '1', '638732', '140', 'SB/CA/03/2014/P/140'),
('480', '1', '298', '1', '225', '2014-03-03', '-67882', '0', '0', '4', '5', '2014-03-31', '0', '638733', '141', 'SB/CA/03/2014/P/141'),
('481', '1', '299', '1', '226', '2014-03-03', '-452545', '0', '0', '4', '4', '2014-03-31', '0', '638734', '142', 'SB/CA/03/2014/P/142'),
('482', '1', '300', '1', '227', '2014-03-10', '-10000', '0', '0', '0', 'Bershan Mendis', '2014-03-31', '1', '638735', '143', 'SB/CA/03/2014/P/143'),
('483', '1', '301', '1', '228', '2014-03-13', '-100000', '0', '0', '0', 'Cash', '2014-03-31', '1', '638736', '144', 'SB/CA/03/2014/P/144'),
('484', '1', '302', '1', '229', '2014-03-19', '-50000', '0', '0', '0', 'K P L Pintoe', '2014-03-31', '0', '638737', '145', 'SB/CA/03/2014/P/145'),
('485', '1', '303', '1', '230', '2014-03-20', '-50000', '0', '0', '0', 'Uddehika Jayawardhane', '2014-03-31', '1', '638738', '146', 'SB/CA/03/2014/P/146'),
('486', '1', '304', '1', '231', '2014-03-20', '-20000', '0', '0', '0', 'Cash', '2014-03-31', '1', '638739', '147', 'SB/CA/03/2014/P/147'),
('487', '1', '305', '1', '232', '2014-03-25', '-452545', '0', '0', '4', '4', '2014-03-31', '0', '638740', '148', 'SB/CA/03/2014/P/148'),
('488', '1', '306', '', '233', '0000-00-00', '0', '0', '0', '4', NULL, NULL, '0', '638741', '149', 'SB/CA/03/2014/P/149'),
('489', '1', '307', '1', '234', '2014-03-25', '-67882', '0', '0', '4', '5', '2014-03-31', '0', '638742', '149', 'SB/CA/03/2014/P/149'),
('490', '1', '308', '1', '235', '2014-03-25', '-7500', '0', '0', '0', 'Asantha Rathnasekara', '2014-03-31', '1', '638743', '150', 'SB/CA/03/2014/P/150'),
('491', '1', '309', '1', '236', '2014-03-25', '-7500', '0', '0', '0', 'Dylan Beekmeyer', '2014-03-31', '1', '638744', '151', 'SB/CA/03/2014/P/151'),
('492', '1', '310', '1', '237', '2014-03-27', '-25500', '0', '0', '0', 'Cash', '2014-03-31', '1', '638745', '152', 'SB/CA/03/2014/P/152'),
('493', '1', '311', '1', '238', '2014-04-02', '-253168.4', '0', '0', '0', 'CASONS TAXI COMPANY (PVT) LTD', '2014-04-30', '0', '638746', '153', 'SB/CA/04/2014/P/153'),
('494', '1', '312', '1', '239', '2014-04-11', '-100000', '0', '0', '0', 'Cash', '2014-04-30', '1', '638747', '154', 'SB/CA/04/2014/P/154'),
('495', '1', '313', '1', '240', '2014-04-16', '-15840', '0', '0', '0', 'Cash', '2014-04-30', '1', '638748', '155', 'SB/CA/04/2014/P/155'),
('496', '1', '314', '1', '241', '2014-04-21', '-10000', '0', '0', '0', 'Cash', '2014-04-30', '1', '638749', '156', 'SB/CA/04/2014/P/156'),
('497', '1', '315', '1', '242', '2014-04-25', '0', '0', '0', '0', 'Cash', NULL, '0', '638750', '157', 'SB/CA/04/2014/P/157'),
('498', '1', '316', '1', '242', '2014-04-25', '-50000', '0', '0', '0', 'Cash', '2014-04-30', '1', '554548', '158', 'SB/CA/04/2014/P/158'),
('499', '1', '317', '1', '242', '2014-04-28', '-36800', '0', '0', '0', 'Mohomad Yoosuf', '2014-04-30', '1', '690402', '159', 'SB/CA/04/2014/P/159'),
('500', '1', '318', '1', '243', '2014-04-29', '0', '0', '0', '4', NULL, '2014-05-31', '0', '690403', '160', 'SB/CA/04/2014/P/160'),
('501', '1', '319', '1', '244', '2014-04-29', '0', '0', '0', '4', NULL, '2014-05-31', '0', '690404', '161', 'SB/CA/04/2014/P/161'),
('502', '1', '320', '1', '245', '2014-04-30', '-306652.4', '0', '0', '0', 'CASONS TAXI COMPANY (PVT) LTD', '2014-05-31', '0', '690405', '162', 'SB/CA/04/2014/P/162'),
('503', '1', '321', '1', '246', '2014-05-02', '-12500', '0', '0', '0', 'Bershan Mendis', '2014-05-31', '1', '690406', '163', 'SB/CA/05/2014/P/163'),
('504', '1', '322', '1', '247', '2014-05-02', '-7500', '0', '0', '0', 'Mewan Samarasinghe', '2014-05-31', '1', '690407', '164', 'SB/CA/05/2014/P/164'),
('505', '1', '323', '1', '248', '2014-05-16', '-130000', '0', '0', '0', 'Cash', '2014-05-31', '1', '690408', '165', 'SB/CA/05/2014/P/165'),
('506', '1', '324', '1', '249', '2014-05-16', '-1970', '0', '0', '0', 'Cash', '2014-05-31', '1', '690409', '166', 'SB/CA/05/2014/P/166'),
('507', '1', '325', '1', '250', '2014-05-22', '-9090.75', '0', '0', '4', '5', '2014-06-30', '0', '690410', '167', 'SB/CA/05/2014/P/167'),
('508', '1', '326', '1', '251', '2014-05-26', '-376717.75', '0', '0', '0', 'Casons taxi Company (PVT) LTD', '2014-05-31', '0', '690411', '168', 'SB/CA/05/2014/P/168'),
('509', '1', '327', '1', '252', '2014-05-28', '-1283', '0', '0', '0', 'Cash', '2014-06-30', '1', '690412', '169', 'SB/CA/05/2014/P/169'),
('510', '1', '328', '1', '253', '2014-05-30', '-68182', '0', '0', '4', '5', '2014-06-30', '0', '690413', '170', 'SB/CA/05/2014/P/170'),
('511', '1', '329', '1', '254', '2014-05-30', '-454545', '0', '0', '4', '4', '2014-06-30', '0', '690414', '171', 'SB/CA/05/2014/P/171'),
('512', '1', '330', '1', '255', '2014-06-03', '-65103.45', '0', '0', '0', 'Cash', '2014-06-30', '1', '690415', '172', 'SB/CA/06/2014/P/172'),
('513', '1', '331', '1', '256', '2014-06-11', '-2588', '0', '0', '0', 'Nuwan Hasitha Dias', '2014-06-30', '1', '690416', '173', 'SB/CA/06/2014/P/173'),
('514', '1', '332', '1', '257', '2014-06-20', '-130000', '0', '0', '0', 'Cash', '2014-06-30', '1', '690417', '174', 'SB/CA/06/2014/P/174'),
('515', '1', '333', '1', '258', '2014-06-25', '-7500', '0', '0', '0', 'Asantha Rathnasekara', '2014-07-31', '1', '690418', '175', 'SB/CA/06/2014/P/175'),
('516', '1', '334', '1', '259', '2014-06-25', '-12500', '0', '0', '0', 'Prasanna Vivekanandarajah', '2014-08-31', '1', '690419', '176', 'SB/CA/06/2014/P/176'),
('517', '1', '335', '1', '260', '2014-06-25', '-12500', '0', '0', '0', 'Praveen Nanayakkara', '2014-07-31', '1', '690420', '177', 'SB/CA/06/2014/P/177'),
('518', '1', '336', '1', '261', '2014-06-25', '-12500', '0', '0', '0', 'Gayanga herath', '2014-07-31', '1', '690421', '178', 'SB/CA/06/2014/P/178'),
('519', '1', '337', '1', '262', '2014-06-25', '-292110.75', '0', '0', '0', 'Casons taxi Company (PVT) LTD', '2014-07-31', '0', '690422', '179', 'SB/CA/06/2014/P/179'),
('520', '1', '338', '1', '263', '2014-06-30', '-420495', '0', '0', '4', '4', '2014-07-31', '0', '690423', '180', 'SB/CA/06/2014/P/180'),
('521', '1', '339', '1', '264', '2014-06-30', '-63074', '0', '0', '4', '5', '2014-07-31', '0', '690424', '181', 'SB/CA/06/2014/P/181'),
('522', '1', '340', '1', '265', '2014-07-09', '-175815', '0', '0', '4', '6', '2014-07-31', '0', '690425', '182', 'SB/CA/07/2014/P/182'),
('523', '1', '341', '1', '266', '2013-01-07', '-750', '0', '0', '0', 'Sampath bank', '2013-01-31', '0', '0', '183', 'SB/CA/07/2014/P/183'),
('524', '1', '342', '1', '267', '2013-01-29', '-500', '0', '0', '0', 'Sampath bank', '2013-01-31', '0', '0', '184', 'SB/CA/07/2014/P/184'),
('525', '1', '343', '1', '268', '2013-01-29', '-2422550.13', '0', '0', '0', 'Cash', '2013-01-31', '0', '0', '185', 'SB/CA/07/2014/P/185'),
('526', '1', '344', '', '269', '0000-00-00', '0', '0', '0', '0', NULL, NULL, '0', '0', '186', 'SB/CA/07/2014/P/186'),
('527', '2', '62', '1', '59', '2013-01-29', '0', '0', '0', '0', 'Cash', '2013-01-31', '0', '0', '50', 'SB/CA/07/2014/D/50'),
('528', '1', '345', '1', '270', '2013-02-28', '-250', '0', '0', '0', 'Sampath bank', '2013-02-28', '0', '0', '186', 'SB/CA/07/2014/P/186'),
('529', '1', '346', '1', '271', '2013-02-26', '-500', '0', '0', '0', 'Sampath bank', '2013-02-28', '0', '0', '187', 'SB/CA/07/2014/P/187'),
('530', '1', '347', '1', '272', '2013-02-26', '-2656945.96', '0', '0', '0', 'Cash', '2013-02-28', '0', '0', '188', 'SB/CA/07/2014/P/188'),
('531', '2', '63', '1', '60', '2013-02-06', '10000', '0', '0', '0', 'Cash', '2013-02-28', '0', '0', '51', 'SB/CA/07/2014/D/51'),
('532', '1', '348', '1', '273', '2013-03-27', '-2737541.92', '0', '0', '0', 'Cash', '2013-03-31', '0', '0', '189', 'SB/CA/07/2014/P/189'),
('533', '1', '349', '1', '274', '2013-03-27', '-500', '0', '0', '0', 'Sampath bank', '2013-03-31', '0', '0', '190', 'SB/CA/07/2014/P/190'),
('534', '2', '64', '1', '61', '2012-12-20', '2600000', '0', '0', '0', 'Cash', '2012-12-31', '0', '0', '52', 'SB/CA/07/2014/D/52'),
('535', '2', '64', '5', '61', '2012-12-20', '-2600000', '0', '0', '0', 'Cash', NULL, '0', '0', '52', 'SB/CA/07/2014/D/52'),
('536', '2', '65', '1', '59', '2013-01-29', '0', '0', '0', '0', 'Cash', '2013-01-31', '0', '0', '53', 'SB/CA/07/2014/D/53'),
('537', '2', '66', '1', '59', '2013-01-29', '0', '0', '0', '0', 'Cash', NULL, '0', '0', '54', 'SB/CA/07/2014/D/54'),
('538', '2', '67', '1', '59', '2013-01-29', '3000000', '0', '0', '0', 'Cash', '2013-01-31', '0', '0', '55', 'SB/CA/07/2014/D/55'),
('539', '2', '67', '5', '59', '2013-01-29', '-3000000', '0', '0', '0', 'Cash', NULL, '0', '0', '55', 'SB/CA/07/2014/D/55'),
('540', '2', '68', '1', '62', '2013-02-26', '2700000', '0', '0', '0', 'Cash', '2013-02-28', '0', '0', '56', 'SB/CA/07/2014/D/56'),
('541', '2', '68', '5', '62', '2013-02-26', '-2700000', '0', '0', '0', 'Cash', NULL, '0', '0', '56', 'SB/CA/07/2014/D/56'),
('542', '2', '69', '1', '63', '2013-02-27', '700000', '0', '0', '0', 'Cash', '2013-02-28', '0', '0', '57', 'SB/CA/07/2014/D/57'),
('543', '2', '69', '5', '63', '2013-02-27', '-700000', '0', '0', '0', 'Cash', NULL, '0', '0', '57', 'SB/CA/07/2014/D/57'),
('544', '2', '70', '1', '64', '2013-03-08', '400000', '0', '0', '0', 'Cash', '2013-03-31', '0', '0', '58', 'SB/CA/07/2014/D/58'),
('545', '2', '70', '5', '64', '2013-03-08', '-400000', '0', '0', '0', 'Cash', NULL, '0', '0', '58', 'SB/CA/07/2014/D/58'),
('546', '2', '71', '1', '65', '2013-03-27', '3500000', '0', '0', '0', 'Cash', '2013-03-31', '0', '0', '59', 'SB/CA/07/2014/D/59'),
('547', '2', '71', '5', '65', '2013-03-27', '-3500000', '0', '0', '0', 'Cash', NULL, '0', '0', '59', 'SB/CA/07/2014/D/59'),
('548', '2', '72', '1', '66', '2012-04-26', '1350000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '2012-04-30', '0', '0', '60', 'SB/CA/07/2014/D/60'),
('549', '2', '72', '5', '66', '2012-04-26', '-1350000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', NULL, '0', '0', '60', 'SB/CA/07/2014/D/60'),
('550', '1', '350', '1', '212', '2012-06-27', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', NULL, '0', '554549', '191', 'SB/CA/07/2014/P/191'),
('551', '1', '351', '1', '211', '2012-06-27', '-1559002.51', '0', '0', '0', 'Cash', '2012-06-30', '0', '554550', '192', 'SB/CA/07/2014/P/192'),
('552', '1', '352', '1', '212', '2012-06-18', '-500', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '2012-06-30', '0', '554551', '193', 'SB/CA/07/2014/P/193'),
('553', '2', '73', '1', '67', '2012-07-23', '0', '0', '0', '0', 'Cash', '2012-07-31', '0', '0', '61', 'SB/CA/07/2014/D/61'),
('554', '2', '73', '5', '67', '2012-07-23', '0', '0', '0', '0', 'Cash', NULL, '0', '0', '61', 'SB/CA/07/2014/D/61'),
('555', '1', '353', '1', '275', '2014-07-18', '-130000', '0', '0', '0', 'Cash', '2014-07-31', '1', '690426', '194', 'SB/CA/07/2014/P/194'),
('556', '2', '74', '1', '68', '2013-04-29', '3500000', '0', '0', '0', 'Cash', '2013-04-30', '0', '0', '62', 'SB/CA/07/2014/D/62'),
('557', '2', '74', '7', '68', '2013-04-29', '-3500000', '0', '0', '0', 'Cash', NULL, '0', '0', '62', 'SB/CA/07/2014/D/62'),
('558', '1', '354', '1', '276', '2013-04-29', '-2689273.33', '0', '0', '0', 'Cash', '2013-04-30', '0', '0', '195', 'SB/CA/07/2014/P/195'),
('559', '2', '75', '1', '69', '2013-05-28', '4000000', '0', '0', '0', 'Cash', '2013-05-31', '0', '0', '63', 'SB/CA/07/2014/D/63'),
('560', '2', '75', '7', '69', '2013-05-28', '-4000000', '0', '0', '0', 'Cash', NULL, '0', '0', '63', 'SB/CA/07/2014/D/63'),
('561', '2', '76', '1', '70', '2013-05-03', '27600', '0', '0', '0', 'Cash', '2013-05-31', '0', '0', '64', 'SB/CA/07/2014/D/64'),
('563', '1', '355', '1', '277', '2013-05-28', '-2748431.31', '0', '0', '0', 'Cash', '2013-05-31', '0', '0', '196', 'SB/CA/07/2014/P/196'),
('564', '2', '77', '1', '71', '2013-06-05', '300000', '0', '0', '0', 'Cash', '2013-06-30', '0', '0', '65', 'SB/CA/07/2014/D/65'),
('565', '2', '77', '7', '71', '2013-06-05', '-300000', '0', '0', '0', 'Cash', NULL, '0', '0', '65', 'SB/CA/07/2014/D/65'),
('566', '2', '78', '1', '72', '2013-06-27', '3000000', '0', '0', '0', 'Cash', '2013-06-30', '0', '0', '66', 'SB/CA/07/2014/D/66'),
('567', '2', '78', '7', '72', '2013-06-27', '-3000000', '0', '0', '0', 'Cash', NULL, '0', '0', '66', 'SB/CA/07/2014/D/66'),
('568', '1', '356', '1', '278', '2013-06-17', '-500', '0', '0', '0', 'Cash', '2013-06-30', '0', '0', '197', 'SB/CA/07/2014/P/197'),
('569', '1', '357', '1', '279', '2013-06-25', '-750', '0', '0', '0', 'Cash', '2013-06-30', '0', '0', '198', 'SB/CA/07/2014/P/198'),
('570', '1', '358', '1', '280', '2013-06-27', '-2217809.36', '0', '0', '0', 'Cash', '2013-06-30', '0', '0', '199', 'SB/CA/07/2014/P/199'),
('571', '1', '359', '1', '281', '2013-07-26', '-2101766', '0', '0', '0', 'Cash', '2013-07-31', '0', '0', '200', 'SB/CA/07/2014/P/200'),
('572', '2', '79', '1', '73', '2013-07-04', '150000', '0', '0', '0', 'Cash', '2013-07-31', '0', '0', '67', 'SB/CA/07/2014/D/67'),
('573', '2', '79', '7', '73', '2013-07-04', '-150000', '0', '0', '0', 'Cash', NULL, '0', '0', '67', 'SB/CA/07/2014/D/67'),
('574', '2', '80', '1', '74', '2013-07-26', '2620000', '0', '0', '0', 'Cash', '2013-07-31', '0', '0', '68', 'SB/CA/07/2014/D/68'),
('575', '2', '80', '7', '74', '2013-07-26', '-20000', '0', '0', '0', 'Cash', NULL, '0', '0', '68', 'SB/CA/07/2014/D/68'),
('576', '2', '80', '7', '74', '2013-07-26', '-2600000', '0', '0', '0', 'Cash', NULL, '0', '0', '68', 'SB/CA/07/2014/D/68'),
('577', '1', '360', '1', '282', '2013-07-05', '0', '0', '0', '0', 'Cash', '2013-07-31', '0', '0', '201', 'SB/CA/07/2014/P/201'),
('578', '1', '361', '1', '282', '2013-07-05', '-12733.19', '0', '0', '0', 'Kangaroo Cabs', '2013-07-31', '0', '554504', '202', 'SB/CA/07/2014/P/202'),
('579', '2', '81', '1', '75', '2013-07-31', '300000', '0', '0', '0', 'Cash', '2013-07-31', '0', '0', '69', 'SB/CA/07/2014/D/69'),
('580', '2', '81', '7', '75', '2013-07-31', '-300000', '0', '0', '0', 'Cash', NULL, '0', '0', '69', 'SB/CA/07/2014/D/69'),
('581', '1', '362', '1', '282', '2014-07-22', '-25000', '0', '0', '0', 'Cash', '2014-07-31', '1', '690427', '203', 'SB/CA/07/2014/P/203'),
('582', '1', '363', '1', '283', '2014-07-24', '-30000', '0', '0', '0', 'Cash', '2014-07-31', '1', '690428', '204', 'SB/CA/07/2014/P/204'),
('583', '1', '364', '1', '284', '2014-07-28', '-295038.65', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2014-08-31', '0', '690429', '205', 'SB/CA/07/2014/P/205'),
('584', '1', '365', '1', '285', '2014-07-28', '-286513.92', '0', '0', '0', 'Frostaire Industries (PVT) LTD', '2014-07-31', '0', '690430', '206', 'SB/CA/07/2014/P/206'),
('585', '1', '366', '1', '286', '2014-07-30', '-367400', '0', '0', '4', '4', '2014-07-31', '0', '690431', '207', 'SB/CA/07/2014/P/207'),
('586', '1', '367', '1', '287', '2014-07-30', '-55110', '0', '0', '4', '5', '2014-07-31', '0', '690432', '208', 'SB/CA/07/2014/P/208'),
('587', '1', '368', '1', '288', '2014-07-31', '-25000', '0', '0', '0', 'POPE &amp; COMPANY', '2014-08-31', '0', '690433', '209', 'SB/CA/07/2014/P/209'),
('588', '0', '19', '5', '18', '2014-07-31', '-110510', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('589', '12', '21', '7', '21', '2012-04-30', '10900', '0', '0', '2', '2', NULL, '0', '0', '1', '/07/2014/D/1'),
('590', '12', '22', '7', '22', '2012-05-31', '9032', '0', '0', '2', '2', NULL, '0', '0', '2', '/07/2014/D/2'),
('591', '12', '23', '7', '23', '2012-05-31', '1196', '0', '0', '2', '2', NULL, '0', '0', '3', '/07/2014/D/3'),
('592', '12', '24', '7', '24', '2012-06-30', '10722', '0', '0', '2', '2', NULL, '0', '0', '4', '/07/2014/D/4'),
('593', '12', '25', '7', '25', '2012-06-30', '2193', '0', '0', '2', '2', NULL, '0', '0', '5', '/07/2014/D/5'),
('594', '12', '26', '7', '26', '2012-07-31', '10620', '0', '0', '2', '2', NULL, '0', '0', '6', '/07/2014/D/6'),
('595', '12', '27', '7', '27', '2012-07-31', '4380', '0', '0', '2', '2', NULL, '0', '0', '7', '/07/2014/D/7'),
('596', '12', '28', '7', '28', '2012-08-31', '10699', '0', '0', '2', '2', NULL, '0', '0', '8', '/07/2014/D/8'),
('597', '12', '29', '7', '29', '2012-08-31', '4344', '0', '0', '2', '2', NULL, '0', '0', '9', '/07/2014/D/9'),
('598', '12', '30', '7', '30', '2012-09-30', '11008', '0', '0', '2', '2', NULL, '0', '0', '10', '/07/2014/D/10'),
('599', '12', '31', '7', '31', '2012-09-30', '4418', '0', '0', '2', '2', NULL, '0', '0', '11', '/07/2014/D/11'),
('600', '12', '32', '7', '32', '2012-10-31', '10302', '0', '0', '2', '2', NULL, '0', '0', '12', '/07/2014/D/12'),
('601', '12', '33', '7', '33', '2012-10-31', '4386', '0', '0', '2', '2', NULL, '0', '0', '13', '/07/2014/D/13'),
('602', '12', '34', '7', '34', '2012-11-30', '11165', '0', '0', '2', '2', NULL, '0', '0', '14', '/07/2014/D/14'),
('603', '12', '35', '7', '35', '2012-11-30', '4615', '0', '0', '2', '2', NULL, '0', '0', '15', '/07/2014/D/15'),
('604', '12', '36', '7', '36', '2012-12-31', '12004', '0', '0', '2', '2', NULL, '0', '0', '16', '/07/2014/D/16'),
('605', '12', '37', '7', '37', '2012-12-31', '4747', '0', '0', '2', '2', NULL, '0', '0', '17', '/07/2014/D/17'),
('606', '12', '38', '7', '38', '2013-01-31', '15924', '0', '0', '2', '2', NULL, '0', '0', '18', '/07/2014/D/18'),
('607', '12', '39', '7', '39', '2013-01-31', '0', '0', '0', '2', '2', NULL, '0', '0', '19', '/07/2014/D/19'),
('608', '12', '40', '7', '40', '2013-02-28', '0', '0', '0', '2', '2', NULL, '0', '0', '20', '/07/2014/D/20'),
('609', '12', '41', '7', '41', '2013-02-28', '5097', '0', '0', '2', '2', NULL, '0', '0', '21', '/07/2014/D/21'),
('610', '12', '42', '7', '42', '2013-03-31', '17396', '0', '0', '2', '2', NULL, '0', '0', '22', '/07/2014/D/22'),
('611', '12', '43', '7', '43', '2013-03-31', '4665', '0', '0', '2', '2', NULL, '0', '0', '23', '/07/2014/D/23'),
('612', '1', '369', '1', '289', '2014-08-04', '-79500', '0', '0', '0', 'Cash', '2014-08-31', '1', '690434', '210', 'SB/CA/08/2014/P/210'),
('613', '1', '370', '1', '290', '2014-08-04', '-130000', '0', '0', '0', 'Cash', '2014-08-31', '1', '690435', '211', 'SB/CA/08/2014/P/211'),
('614', '1', '371', '1', '291', '2014-08-05', '0', '0', '0', '0', 'Chanaka Padmaperuma', '2014-08-31', '1', '690436', '212', 'SB/CA/08/2014/P/212'),
('615', '1', '372', '1', '292', '2014-08-11', '-8500', '0', '0', '0', 'Cash', '2014-08-31', '1', '690437', '213', 'SB/CA/08/2014/P/213'),
('616', '1', '373', '1', '293', '2014-08-11', '-40000', '0', '0', '0', 'Cash', '2014-08-31', '1', '690438', '214', 'SB/CA/08/2014/P/214'),
('617', '1', '374', '1', '294', '2014-08-11', '-12500', '0', '0', '0', 'Dulanjaya Athulakeerthi', '2014-09-30', '1', '690439', '215', 'SB/CA/08/2014/P/215'),
('618', '1', '375', '1', '295', '2014-08-11', '-12500', '0', '0', '0', 'Jude Padidilian', '2014-08-31', '1', '690440', '216', 'SB/CA/08/2014/P/216'),
('619', '1', '376', '1', '296', '2014-08-11', '-12500', '0', '0', '0', 'Prasanna Vivekanandarajah', '2014-09-30', '1', '690441', '217', 'SB/CA/08/2014/P/217'),
('620', '1', '377', '1', '297', '2014-08-20', '-5000', '0', '0', '0', 'Naushad Ameer', '2014-08-31', '1', '690442', '218', 'SB/CA/08/2014/P/218'),
('621', '1', '378', '1', '298', '2014-08-21', '-296505.45', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2014-09-30', '0', '690443', '219', 'SB/CA/08/2014/P/219'),
('622', '1', '379', '1', '299', '2014-08-21', '-5000', '0', '0', '0', 'Manoj Fernando', '2014-08-31', '1', '690444', '220', 'SB/CA/08/2014/P/220'),
('623', '1', '380', '1', '300', '2014-08-27', '-75000', '0', '0', '0', 'Cash', '2014-08-31', '1', '690445', '221', 'SB/CA/08/2014/P/221'),
('624', '1', '381', '1', '301', '2014-08-29', '-459495', '0', '0', '4', '4', '2014-09-30', '0', '690446', '222', 'SB/CA/08/2014/P/222'),
('625', '1', '382', '1', '302', '2014-08-29', '-68924', '0', '0', '4', '5', '2014-09-30', '0', '690447', '223', 'SB/CA/08/2014/P/223'),
('626', '1', '383', '1', '303', '2014-09-01', '-93600', '0', '0', '0', 'Nishan Jinadasa', '2014-09-30', '1', '690448', '224', 'SB/CA/09/2014/P/224'),
('627', '1', '384', '1', '304', '2014-09-03', '-4221', '0', '0', '0', 'Cash', '2014-09-30', '1', '690449', '225', 'SB/CA/09/2014/P/225'),
('628', '1', '385', '1', '305', '2014-09-03', '-20000', '0', '0', '0', 'Nishan Jinadasa', '2014-09-30', '1', '690450', '226', 'SB/CA/09/2014/P/226'),
('629', '2', '82', '1', '67', '2012-07-23', '30000', '0', '0', '0', 'Cash', '2012-07-31', '0', '0', '70', 'SB/CA/09/2014/D/70'),
('630', '2', '83', '1', '48', '2012-09-04', '10000', '0', '0', '0', 'K.P.L.Pintoe', '2012-09-30', '0', '0', '71', 'SB/CA/09/2014/D/71'),
('631', '1', '386', '1', '306', '2014-09-04', '-747.63', '0', '0', '0', 'Abdul Aziz bin Navaz', '2014-10-31', '1', '727451', '227', 'SB/CA/09/2014/P/227'),
('632', '1', '387', '5', '307', '2012-08-22', '0', '0', '0', '0', 'Pope &amp; Co;', NULL, '0', '554552', '80', 'ET/09/2014/P/80'),
('633', '1', '388', '5', '308', '2012-11-21', '-354532.62', '0', '0', '0', 'Highlevel Express', NULL, '0', '554553', '81', 'ET/09/2014/P/81'),
('634', '1', '389', '5', '309', '2012-11-30', '-46000', '0', '0', '0', 'Daham Perera', NULL, '0', '554554', '82', 'ET/09/2014/P/82'),
('635', '1', '390', '5', '310', '2013-01-16', '-303635', '0', '0', '0', 'Highlevel Express', NULL, '0', '554555', '83', 'ET/09/2014/P/83'),
('636', '1', '391', '5', '311', '2013-01-29', '0', '0', '0', '0', 'Tech Information systems', NULL, '0', '554556', '84', 'ET/09/2014/P/84'),
('637', '1', '392', '5', '312', '2013-02-15', '-154158', '0', '0', '0', 'Grand Taxi', NULL, '0', '554557', '85', 'ET/09/2014/P/85'),
('638', '1', '393', '5', '313', '2012-12-14', '-35000', '0', '0', '0', 'Nishan Jinadasa', NULL, '0', '554558', '86', 'ET/09/2014/P/86'),
('639', '1', '394', '5', '314', '2013-02-14', '-60000', '0', '0', '0', 'Cash', NULL, '0', '554559', '87', 'ET/09/2014/P/87'),
('640', '1', '395', '5', '315', '2013-01-09', '-300000', '0', '0', '0', 'K.P.L.Pintoe', NULL, '0', '554560', '88', 'ET/09/2014/P/88'),
('641', '0', '27', '5', '24', '2013-03-31', '32268173.29', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('642', '0', '27', '7', '24', '2013-03-31', '-32268173.29', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('643', '1', '396', '1', '316', '2014-09-10', '-7000', '0', '0', '0', 'Uddeshika Jayawardhane', '2014-09-30', '1', '727452', '228', 'SB/CA/09/2014/P/228'),
('644', '1', '397', '1', '317', '2014-09-11', '-12500', '0', '0', '0', 'Bershan Mendis', '2014-09-30', '1', '727453', '229', 'SB/CA/09/2014/P/229'),
('645', '1', '398', '1', '318', '2014-09-11', '-12500', '0', '0', '0', 'Fazeem Jaufer Hathy', '2014-09-30', '1', '727454', '230', 'SB/CA/09/2014/P/230'),
('646', '1', '399', '1', '319', '2014-09-11', '-12500', '0', '0', '0', 'Kanchuka Weeranga', '2014-09-30', '1', '727455', '231', 'SB/CA/09/2014/P/231'),
('647', '1', '400', '1', '320', '2014-09-12', '-3394.1', '0', '0', '4', '5', '2014-09-30', '0', '727456', '232', 'SB/CA/09/2014/P/232'),
('648', '1', '401', '1', '321', '2014-09-15', '0', '0', '0', '0', 'Cash', NULL, '1', '727457', '233', 'SB/CA/09/2014/P/233'),
('649', '1', '402', '1', '322', '2014-09-15', '-313093.4', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2014-09-30', '0', '727457', '234', 'SB/CA/09/2014/P/234'),
('650', '1', '403', '', '321', '0000-00-00', '0', '0', '0', '0', NULL, NULL, '1', '554561', '235', 'SB/CA/09/2014/P/235'),
('651', '1', '404', '1', '321', '2014-09-15', '0', '0', '0', '0', 'Cash', NULL, '1', '727459', '236', 'SB/CA/09/2014/P/236'),
('652', '1', '405', '1', '321', '2014-09-15', '-170000', '0', '0', '0', 'Cash', '2014-09-30', '1', '554562', '237', 'SB/CA/09/2014/P/237'),
('653', '1', '406', '1', '323', '2014-09-29', '-7500', '0', '0', '0', 'Dulanjaya Athulakeerthi', '2014-10-31', '1', '727460', '238', 'SB/CA/09/2014/P/238'),
('654', '1', '407', '1', '324', '2014-09-29', '-12500', '0', '0', '0', 'Prashanth Shriselwam', '2014-10-31', '1', '727461', '239', 'SB/CA/09/2014/P/239'),
('655', '1', '408', '1', '325', '2014-09-29', '-12500', '0', '0', '0', 'Dylan Beekmeyer', '2014-10-31', '1', '727462', '240', 'SB/CA/09/2014/P/240'),
('656', '1', '409', '1', '326', '2014-09-30', '-434520', '0', '0', '4', '4', '2014-10-31', '0', '727463', '241', 'SB/CA/09/2014/P/241'),
('657', '1', '410', '1', '327', '2014-09-30', '-65178', '0', '0', '4', '5', '2014-10-31', '0', '727464', '242', 'SB/CA/09/2014/P/242'),
('658', '1', '411', '1', '328', '2014-10-02', '-5000', '0', '0', '0', 'Lahiru Kumarasiri', '2014-10-31', '1', '727465', '243', 'SB/CA/10/2014/P/243'),
('659', '1', '412', '1', '329', '2014-10-14', '-15840', '0', '0', '0', 'Cash', '2014-10-31', '1', '727466', '244', 'SB/CA/10/2014/P/244'),
('660', '1', '413', '1', '330', '2014-10-14', '-170000', '0', '0', '0', 'Cash', '2014-10-31', '1', '727467', '245', 'SB/CA/10/2014/P/245'),
('661', '1', '414', '', '331', '0000-00-00', '0', '0', '0', '0', NULL, NULL, '0', '727468', '246', 'SB/CA/10/2014/P/246'),
('662', '1', '415', '1', '332', '2014-10-24', '-321114.9', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2014-10-31', '0', '727469', '247', 'SB/CA/10/2014/P/247'),
('663', '1', '416', '1', '333', '2014-10-28', '-481995', '0', '0', '4', '4', '2014-11-30', '0', '727470', '248', 'SB/CA/10/2014/P/248'),
('664', '1', '417', '1', '334', '2014-10-28', '-72299.25', '0', '0', '4', '5', '2014-11-30', '0', '727471', '249', 'SB/CA/10/2014/P/249'),
('665', '1', '418', '1', '335', '2014-11-04', '-12500', '0', '0', '0', 'Bershan Mendis', '2014-11-30', '1', '727472', '250', 'SB/CA/11/2014/P/250'),
('666', '1', '419', '1', '336', '2014-11-04', '-12500', '0', '0', '0', 'Dulanjaya Athulakeerthi', '2014-11-30', '1', '727472', '251', 'SB/CA/11/2014/P/251'),
('667', '1', '420', '1', '337', '2014-11-04', '-12500', '0', '0', '0', 'Jude Padidilian', '2014-11-30', '1', '727474', '252', 'SB/CA/11/2014/P/252'),
('668', '1', '421', '1', '338', '2014-11-04', '-41055', '0', '0', '0', 'Cash', '2014-11-30', '1', '727475', '253', 'SB/CA/11/2014/P/253'),
('669', '1', '422', '1', '339', '2014-11-26', '-140000', '0', '0', '0', 'Cash', '2014-11-30', '1', '727476', '254', 'SB/CA/11/2014/P/254'),
('670', '1', '423', '1', '340', '2014-11-27', '-401014', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2014-12-31', '0', '727477', '255', 'SB/CA/11/2014/P/255'),
('671', '1', '424', '1', '341', '2014-11-28', '-488625', '0', '0', '4', '4', '2014-12-31', '0', '727478', '256', 'SB/CA/11/2014/P/256'),
('672', '1', '425', '1', '342', '2014-11-28', '-73294', '0', '0', '4', '5', '2014-12-31', '0', '727479', '257', 'SB/CA/11/2014/P/257'),
('673', '1', '426', '1', '343', '2014-12-05', '-12500', '0', '0', '0', 'Prasanna Vivekanandarajah', '2015-02-28', '1', '727480', '258', 'SB/CA/12/2014/P/258'),
('674', '1', '427', '1', '344', '2014-12-05', '-12500', '0', '0', '0', 'Fazeem Hathy', '2014-12-31', '1', '727481', '259', 'SB/CA/12/2014/P/259'),
('675', '1', '428', '1', '345', '2014-12-09', '-458750', '0', '0', '0', 'Uddeshika Jayawardhane', '2014-12-31', '1', '727482', '260', 'SB/CA/12/2014/P/260'),
('676', '1', '429', '1', '346', '2014-12-31', '-73294', '0', '0', '4', '5', '2015-01-31', '0', '727483', '261', 'SB/CA/12/2014/P/261'),
('677', '1', '430', '1', '347', '2014-12-31', '-488625', '0', '0', '4', '4', '2015-01-31', '0', '727484', '262', 'SB/CA/12/2014/P/262'),
('678', '1', '431', '1', '348', '2015-01-13', '-86250', '0', '0', '0', 'Genesiis Software (PVT) LTD', '2015-01-31', '0', '727485', '263', 'SB/CA/01/2015/P/263'),
('679', '1', '432', '1', '349', '2015-01-13', '-12500', '0', '0', '0', 'Prasanna Vivekanandarajah', '2015-02-28', '1', '727486', '264', 'SB/CA/01/2015/P/264'),
('680', '1', '433', '1', '350', '2015-01-13', '-12500', '0', '0', '0', 'Gayan Edirisinghe', '2015-01-31', '1', '727487', '265', 'SB/CA/01/2015/P/265'),
('681', '1', '434', '1', '351', '2015-01-13', '-140000', '0', '0', '0', 'Cash', '2015-01-31', '1', '727488', '266', 'SB/CA/01/2015/P/266'),
('682', '1', '435', '1', '352', '2015-01-16', '-27408.8', '0', '0', '4', '5', '2015-01-31', '0', '727491', '267', 'SB/CA/01/2015/P/267'),
('683', '1', '436', '1', '353', '2015-01-21', '-12500', '0', '0', '0', 'Safa Afrak', '2015-01-31', '0', '727492', '268', 'SB/CA/01/2015/P/268'),
('684', '1', '437', '1', '354', '2015-01-26', '-5000', '0', '0', '0', 'Manoj Fernando', '2015-01-31', '1', '727493', '269', 'SB/CA/01/2015/P/269'),
('685', '1', '438', '1', '355', '2015-01-27', '-22920.36', '0', '0', '0', 'Cash', '2015-01-31', '1', '727494', '270', 'SB/CA/01/2015/P/270'),
('686', '1', '439', '1', '356', '2015-01-27', '-105480', '0', '0', '0', 'Design imprints', '2015-01-31', '0', '727495', '271', 'SB/CA/01/2015/P/271'),
('687', '1', '440', '', '357', '0000-00-00', '0', '0', '0', '0', NULL, NULL, '1', '727496', '272', 'SB/CA/01/2015/P/272'),
('688', '1', '441', '1', '358', '2015-01-29', '-449591.3', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2015-02-28', '0', '727497', '272', 'SB/CA/01/2015/P/272'),
('689', '1', '442', '1', '359', '2015-01-29', '-545000', '0', '0', '4', '4', '2015-02-28', '0', '727498', '273', 'SB/CA/01/2015/P/273'),
('690', '1', '443', '1', '360', '2015-01-29', '-81750', '0', '0', '4', '5', '2015-02-28', '0', '727499', '274', 'SB/CA/01/2015/P/274'),
('691', '1', '444', '1', '361', '2015-02-06', '-12500', '0', '0', '0', 'Sahan Senevirathne', '2015-02-28', '1', '727500', '275', 'SB/CA/02/2015/P/275'),
('692', '1', '445', '1', '362', '2015-02-06', '-12500', '0', '0', '0', 'Jude Shanaka', '2015-02-28', '1', '779551', '276', 'SB/CA/02/2015/P/276'),
('693', '1', '446', '1', '363', '2015-02-06', '-17500', '0', '0', '0', 'Prasanna Vivekanandarajah', '2015-02-28', '1', '779552', '277', 'SB/CA/02/2015/P/277'),
('694', '1', '447', '1', '364', '2015-02-06', '-2490', '0', '0', '0', 'Uddeshika Jayawardhane', '2015-02-28', '1', '779553', '278', 'SB/CA/02/2015/P/278'),
('695', '1', '448', '1', '365', '2015-02-06', '-17600', '0', '0', '0', 'POPE &amp; COMPANY CONSULTANTS (PVT) LTD', '2015-02-28', '0', '779554', '279', 'SB/CA/02/2015/P/279'),
('696', '1', '449', '1', '366', '2015-02-10', '-500000', '0', '0', '0', 'Chanaka Padmaperuma ', '2015-02-28', '1', '779555', '280', 'SB/CA/02/2015/P/280'),
('697', '1', '450', '1', '367', '2015-02-16', '-140000', '0', '0', '0', 'Cash', '2015-02-28', '1', '779556', '281', 'SB/CA/02/2015/P/281'),
('698', '1', '451', '1', '368', '2013-08-27', '-2280912.67', '0', '0', '0', 'Cash', '2013-08-31', '0', '0', '282', 'SB/CA/02/2015/P/282'),
('699', '2', '84', '1', '76', '2013-08-08', '150000', '0', '0', '0', 'Fund transfer', '2013-08-31', '0', '0', '72', 'SB/CA/02/2015/D/72'),
('700', '2', '84', '7', '76', '2013-08-08', '-784.52', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '72', 'SB/CA/02/2015/D/72'),
('701', '2', '85', '1', '77', '2013-08-22', '2800000', '0', '0', '0', 'Fund transfer', '2013-08-31', '0', '0', '73', 'SB/CA/02/2015/D/73'),
('702', '2', '85', '7', '77', '2013-08-22', '-14644.35', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '73', 'SB/CA/02/2015/D/73'),
('703', '2', '86', '1', '78', '2013-09-02', '200000', '0', '0', '0', 'Fund transfer', '2013-09-30', '0', '0', '74', 'SB/CA/02/2015/D/74'),
('704', '2', '86', '7', '78', '2013-09-02', '-1046.03', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '74', 'SB/CA/02/2015/D/74'),
('705', '2', '87', '1', '79', '2013-09-02', '100000', '0', '0', '0', 'Fund transfer', '2013-09-30', '0', '0', '75', 'SB/CA/02/2015/D/75'),
('706', '2', '87', '7', '79', '2013-09-02', '-523.01', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '75', 'SB/CA/02/2015/D/75'),
('707', '2', '88', '1', '80', '2013-09-27', '2800000', '0', '0', '0', 'Fund transfer', '2013-09-30', '0', '0', '76', 'SB/CA/02/2015/D/76'),
('708', '2', '88', '7', '80', '2013-09-27', '-14644.35', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '76', 'SB/CA/02/2015/D/76'),
('709', '1', '452', '1', '369', '2013-09-27', '-2286760', '0', '0', '0', 'Salaries', '2013-09-30', '0', '0', '283', 'SB/CA/02/2015/P/283'),
('710', '2', '89', '1', '81', '2013-09-18', '500000', '0', '0', '0', 'Fund transfer', '2013-09-30', '0', '0', '77', 'SB/CA/02/2015/D/77'),
('711', '2', '89', '7', '81', '2013-09-18', '-2615.06', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '77', 'SB/CA/02/2015/D/77'),
('712', '2', '90', '1', '82', '2013-10-28', '3000000', '0', '0', '0', 'Fund transfer', '2013-10-31', '0', '0', '78', 'SB/CA/02/2015/D/78'),
('713', '2', '90', '7', '82', '2013-10-28', '-15690.38', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '78', 'SB/CA/02/2015/D/78'),
('714', '1', '453', '1', '370', '2013-10-28', '-2401821.83', '0', '0', '0', 'Salaries', '2013-10-31', '0', '0', '284', 'SB/CA/02/2015/P/284'),
('715', '1', '454', '1', '371', '2013-10-28', '-250', '0', '0', '0', 'OD Interest', '2013-10-31', '0', '0', '285', 'SB/CA/02/2015/P/285'),
('716', '1', '455', '1', '372', '2013-11-22', '-750', '0', '0', '0', 'Bank Charges', '2013-11-30', '0', '0', '286', 'SB/CA/02/2015/P/286'),
('717', '1', '456', '1', '373', '2013-11-27', '-2501527.64', '0', '0', '0', 'Salaries', '2013-11-30', '0', '0', '287', 'SB/CA/02/2015/P/287'),
('718', '2', '91', '1', '83', '2013-11-01', '200000', '0', '0', '0', 'Fund transfer', '2013-11-30', '0', '0', '79', 'SB/CA/02/2015/D/79'),
('719', '2', '91', '7', '83', '2013-11-01', '-1046.03', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '79', 'SB/CA/02/2015/D/79'),
('720', '2', '92', '1', '84', '2013-11-27', '3200000', '0', '0', '0', 'Fund transfer', '2013-11-30', '0', '0', '80', 'SB/CA/02/2015/D/80'),
('721', '2', '92', '7', '84', '2013-11-27', '-16736.4', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '80', 'SB/CA/02/2015/D/80'),
('722', '2', '93', '1', '85', '2013-12-10', '200000', '0', '0', '0', 'Fund transfer', '2013-12-31', '0', '0', '81', 'SB/CA/02/2015/D/81'),
('723', '2', '93', '7', '85', '2013-12-10', '-1046.03', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '81', 'SB/CA/02/2015/D/81'),
('724', '2', '94', '1', '86', '2013-12-10', '200000', '0', '0', '0', 'Fund transfer', '2013-12-31', '0', '0', '82', 'SB/CA/02/2015/D/82'),
('725', '2', '94', '7', '86', '2013-12-10', '-1046.03', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '82', 'SB/CA/02/2015/D/82'),
('726', '1', '457', '1', '374', '2013-12-11', '-50', '0', '0', '0', 'Sampath Bank', '2013-12-31', '0', '0', '288', 'SB/CA/02/2015/P/288'),
('727', '1', '458', '1', '375', '2013-12-17', '-500', '0', '0', '0', 'Bank Charges', '2013-12-31', '0', '0', '289', 'SB/CA/02/2015/P/289'),
('728', '1', '459', '1', '376', '2013-12-24', '-2361185.64', '0', '0', '0', 'Salaries', '2014-03-31', '0', '0', '290', 'SB/CA/02/2015/P/290'),
('729', '1', '460', '1', '377', '2014-01-27', '-2308855.02', '0', '0', '0', 'Salaries', '2014-01-31', '0', '0', '291', 'SB/CA/02/2015/P/291'),
('730', '2', '95', '1', '87', '2013-12-23', '3200000', '0', '0', '0', 'Fund transfer', '2013-12-31', '0', '0', '83', 'SB/CA/02/2015/D/83'),
('731', '2', '95', '7', '87', '2013-12-23', '-16736.4', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '83', 'SB/CA/02/2015/D/83'),
('732', '2', '96', '1', '88', '2014-01-17', '500000', '0', '0', '0', 'Fund transfer', '2014-01-31', '0', '0', '84', 'SB/CA/02/2015/D/84'),
('733', '2', '96', '7', '88', '2014-01-17', '-2615.06', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '84', 'SB/CA/02/2015/D/84'),
('734', '2', '97', '1', '89', '2014-01-21', '500000', '0', '0', '0', 'Fund transfer', '2014-01-31', '0', '0', '85', 'SB/CA/02/2015/D/85'),
('735', '2', '97', '7', '89', '2014-01-21', '-2615.06', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '85', 'SB/CA/02/2015/D/85'),
('736', '2', '98', '1', '90', '2014-01-27', '2600000', '0', '0', '0', 'Fund transfer', '2014-01-31', '0', '0', '86', 'SB/CA/02/2015/D/86'),
('737', '2', '98', '7', '90', '2014-01-27', '-13598.33', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '86', 'SB/CA/02/2015/D/86'),
('738', '2', '99', '1', '91', '2014-02-28', '3200000', '0', '0', '0', 'Fund transfer', '2014-02-28', '0', '0', '87', 'SB/CA/02/2015/D/87'),
('739', '2', '99', '7', '91', '2014-02-28', '-16736.4', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '87', 'SB/CA/02/2015/D/87'),
('740', '1', '461', '1', '378', '2014-02-28', '-2351149.29', '0', '0', '0', 'Salaries', '2014-02-28', '0', '0', '292', 'SB/CA/02/2015/P/292'),
('741', '1', '462', '', '379', '0000-00-00', '0', '0', '0', '0', NULL, NULL, '0', '554563', '293', 'SB/CA/02/2015/P/293'),
('742', '1', '462', '', '379', '0000-00-00', '0', '0', '0', '0', NULL, NULL, '0', '554563', '293', 'SB/CA/02/2015/P/293'),
('743', '2', '100', '1', '92', '2014-03-19', '400000', '0', '0', '0', 'Fund transfer', '2014-03-31', '0', '0', '88', 'SB/CA/02/2015/D/88'),
('744', '2', '100', '7', '92', '2014-03-19', '-2092.05', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '88', 'SB/CA/02/2015/D/88'),
('745', '2', '101', '1', '93', '2014-03-27', '2400000', '0', '0', '0', 'Fund transfer', '2014-03-31', '0', '0', '89', 'SB/CA/02/2015/D/89'),
('746', '2', '101', '7', '93', '2014-03-27', '-12552.3', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '89', 'SB/CA/02/2015/D/89'),
('747', '1', '463', '1', '380', '2014-03-20', '-50', '0', '0', '0', 'Sampath Bank', '2014-03-31', '0', '554564', '293', 'SB/CA/02/2015/P/293'),
('748', '2', '102', '1', '94', '2014-03-25', '400000', '0', '0', '0', 'Fund transfer', '2014-03-31', '0', '0', '90', 'SB/CA/02/2015/D/90'),
('749', '2', '102', '7', '94', '2014-03-25', '-2092.05', '0', '0', '0', 'Fund transfer', NULL, '0', '0', '90', 'SB/CA/02/2015/D/90'),
('750', '1', '464', '1', '381', '2014-03-27', '-2377047.34', '0', '0', '0', 'Salaries', '2014-03-31', '0', '0', '294', 'SB/CA/02/2015/P/294'),
('751', '2', '103', '1', '95', '2014-03-14', '50000', '0', '0', '0', 'Fund transfer', '2014-03-31', '0', '0', '91', 'SB/CA/02/2015/D/91'),
('752', '1', '465', '1', '382', '2015-02-23', '-609085', '0', '0', '0', 'Chanaka Padmaperuma', '2015-02-28', '1', '779557', '295', 'SB/CA/02/2015/P/295'),
('753', '12', '44', '7', '44', '2013-04-29', '20619', '0', '0', '2', '2', NULL, '0', '0', '91', 'ET/GBP/02/2015/D/91'),
('754', '12', '45', '7', '45', '2013-05-27', '0', '0', '0', '2', '2', NULL, '0', '0', '92', 'ET/GBP/02/2015/D/92'),
('755', '12', '46', '7', '46', '2013-06-26', '19169', '0', '0', '2', '2', NULL, '0', '0', '93', 'ET/GBP/02/2015/D/93'),
('756', '12', '47', '7', '47', '2013-07-30', '17178', '0', '0', '2', '2', NULL, '0', '0', '94', 'ET/GBP/02/2015/D/94'),
('757', '12', '48', '7', '48', '2013-08-29', '19708', '0', '0', '2', '2', NULL, '0', '0', '95', 'ET/GBP/02/2015/D/95'),
('758', '12', '49', '7', '49', '2013-09-30', '18502', '0', '0', '2', '2', NULL, '0', '0', '96', 'ET/GBP/02/2015/D/96'),
('759', '12', '50', '7', '50', '2013-10-30', '18828', '0', '0', '2', '2', NULL, '0', '0', '97', 'ET/GBP/02/2015/D/97'),
('760', '12', '51', '7', '51', '2013-11-28', '18134', '0', '0', '2', '2', NULL, '0', '0', '98', 'ET/GBP/02/2015/D/98'),
('761', '12', '52', '7', '52', '2013-12-30', '17960', '0', '0', '2', '2', NULL, '0', '0', '99', 'ET/GBP/02/2015/D/99'),
('762', '12', '53', '7', '53', '2013-12-30', '17056', '0', '0', '2', '2', NULL, '0', '0', '100', 'ET/GBP/02/2015/D/100'),
('763', '12', '54', '7', '54', '2014-02-28', '15864', '0', '0', '2', '2', NULL, '0', '0', '101', 'ET/GBP/02/2015/D/101'),
('764', '1', '466', '7', '31', '2013-04-04', '0', '0', '0', '0', 'Grand Taxi Company', NULL, '0', '554565', '1', 'ET/GBP/02/2015/P/1'),
('765', '0', '32', '7', '29', '2013-03-30', '0', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('766', '0', '32', '7', '29', '2013-03-30', '0', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('767', '1', '467', '7', '31', '2013-04-04', '-261671', '0', '0', '0', 'Grand Taxi Company', NULL, '0', '554566', '78', 'ET/GBP/02/2015/P/78'),
('768', '12', '55', '7', '55', '2013-02-28', '0', '0', '0', '2', '2', NULL, '0', '0', '102', 'ET/GBP/02/2015/D/102'),
('769', '12', '56', '7', '56', '2014-03-30', '20027', '0', '0', '2', '2', NULL, '0', '0', '103', 'ET/GBP/02/2015/D/103'),
('770', '1', '468', '5', '307', '2012-08-22', '0', '0', '0', '0', 'Pope &amp; Co;', NULL, '0', '554567', '89', 'ET/02/2015/P/89'),
('771', '1', '469', '', '383', '0000-00-00', '0', '0', '0', '0', NULL, NULL, '0', '0', '79', 'ET/GBP/02/2015/P/79'),
('772', '1', '470', '5', '384', '2013-04-23', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', NULL, '0', '0', '90', 'ET/02/2015/P/90'),
('773', '1', '471', '5', '385', '2013-05-22', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', NULL, '0', '0', '91', 'ET/02/2015/P/91'),
('774', '1', '472', '5', '386', '2013-06-21', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', NULL, '0', '0', '92', 'ET/02/2015/P/92'),
('775', '1', '473', '5', '387', '2013-07-19', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', NULL, '0', '0', '93', 'ET/02/2015/P/93'),
('776', '1', '474', '5', '388', '2013-08-06', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', NULL, '0', '0', '94', 'ET/02/2015/P/94'),
('777', '1', '475', '5', '389', '2013-08-22', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', NULL, '0', '0', '95', 'ET/02/2015/P/95'),
('778', '1', '476', '5', '390', '2013-10-05', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', NULL, '0', '0', '96', 'ET/02/2015/P/96'),
('779', '1', '477', '5', '391', '2013-10-24', '-167139.71', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', NULL, '0', '0', '97', 'ET/02/2015/P/97'),
('780', '1', '478', '5', '392', '2013-12-18', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', NULL, '0', '0', '98', 'ET/02/2015/P/98'),
('781', '1', '479', '5', '393', '2014-01-17', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', NULL, '0', '0', '99', 'ET/02/2015/P/99'),
('782', '1', '480', '5', '394', '2014-02-21', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', NULL, '0', '0', '100', 'ET/02/2015/P/100'),
('783', '1', '481', '5', '395', '2014-03-20', '-197704.05', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', NULL, '0', '0', '101', 'ET/02/2015/P/101'),
('784', '0', '32', '7', '29', '2013-03-30', '-2126006.6', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('785', '0', '35', '5', '31', '2012-08-22', '-19180', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('786', '12', '55', '7', '55', '2013-02-28', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('787', '12', '55', '7', '55', '2013-02-28', '10560', '0', '0', '2', '2', NULL, '0', '0', '0', '');
INSERT INTO `1_bank_trans` VALUES
('788', '1', '482', '1', '35', '2013-04-09', '-13000', '0', '0', '0', 'Cash', '2013-04-30', '0', '554568', '296', 'SB/CA/02/2015/P/296'),
('789', '1', '483', '1', '165', '2013-10-08', '-100000', '0', '0', '0', 'Cash', '2013-10-31', '0', '554569', '297', 'SB/CA/02/2015/P/297'),
('790', '1', '484', '1', '176', '2013-11-06', '-100000', '0', '0', '0', 'Cash', '2013-11-30', '0', '554570', '298', 'SB/CA/02/2015/P/298'),
('791', '1', '485', '5', '396', '2013-09-06', '-60000', '0', '0', '0', 'Cash', NULL, '0', '0', '102', 'ET/02/2015/P/102'),
('792', '1', '486', '5', '397', '2013-11-14', '-129557', '0', '0', '0', 'Grand Taxi', NULL, '0', '0', '103', 'ET/02/2015/P/103'),
('793', '1', '487', '5', '398', '2013-04-17', '-100000', '0', '0', '0', 'Grand Taxi', NULL, '0', '0', '104', 'ET/02/2015/P/104'),
('794', '1', '488', '5', '399', '2013-09-06', '-13000', '0', '0', '0', 'Cash', NULL, '0', '0', '105', 'ET/02/2015/P/105'),
('795', '1', '489', '1', '400', '2015-02-26', '-2490', '0', '0', '0', 'Cash', '2015-02-28', '1', '779558', '106', 'ET/02/2015/P/106'),
('796', '1', '490', '1', '401', '2015-02-27', '-553066.6', '0', '0', '4', '4', '2015-03-31', '0', '779559', '299', 'SB/CA/02/2015/P/299'),
('797', '1', '491', '1', '402', '2015-02-27', '-82960', '0', '0', '4', '5', '2015-03-31', '0', '779560', '300', 'SB/CA/02/2015/P/300'),
('798', '1', '492', '1', '403', '2015-03-02', '-449549.85', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2015-03-31', '0', '779561', '301', 'SB/CA/03/2015/P/301'),
('799', '1', '493', '1', '157', '2013-08-22', '-66000', '0', '0', '0', 'IAS Solutions (Pvt)Ltd.', '2014-03-31', '0', '554571', '302', 'SB/CA/03/2015/P/302'),
('800', '0', '38', '5', '34', '2014-03-31', '0', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('801', '0', '39', '5', '35', '2014-03-31', '0', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('802', '0', '39', '7', '35', '2014-03-31', '0', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('803', '12', '45', '7', '45', '2013-05-27', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('804', '0', '40', '5', '36', '2013-03-31', '-128000', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('805', '0', '39', '5', '35', '2014-03-31', '0', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('806', '0', '39', '7', '35', '2014-03-31', '0', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('807', '0', '38', '5', '34', '2014-03-31', '-1245000', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('808', '0', '39', '5', '35', '2014-03-31', '3938360.26', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('809', '0', '39', '7', '35', '2014-03-31', '-3938360.26', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('810', '12', '45', '7', '45', '2013-05-27', '17994', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('811', '1', '494', '1', '404', '2015-03-11', '-10000', '0', '0', '0', 'Uddeshika Jayawardhane', '2015-03-31', '1', '779562', '303', 'SB/CA/03/2015/P/303'),
('812', '1', '495', '1', '405', '2015-03-30', '-25000', '0', '0', '0', 'POPE &amp; COMPANY CONSULTANTS (PVT) LTD', '2015-04-30', '0', '779563', '304', 'SB/CA/03/2015/P/304'),
('813', '1', '496', '1', '406', '2015-03-30', '-85200', '0', '0', '4', '5', '2015-04-30', '0', '779564', '305', 'SB/CA/03/2015/P/305'),
('814', '1', '497', '1', '407', '2015-03-30', '-568000', '0', '0', '4', '4', '2015-04-30', '0', '779565', '306', 'SB/CA/03/2015/P/306'),
('815', '1', '498', '1', '408', '2015-03-30', '-451176.85', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2015-04-30', '0', '779566', '307', 'SB/CA/03/2015/P/307'),
('816', '1', '499', '1', '409', '2015-04-01', '-140000', '0', '0', '0', 'Cash', '2015-04-30', '1', '779567', '308', 'SB/CA/04/2015/P/308'),
('817', '1', '500', '1', '410', '2015-04-10', '-4810', '0', '0', '0', 'Prasanna Vivek', '2015-05-31', '1', '779568', '309', 'SB/CA/04/2015/P/309'),
('818', '1', '501', '1', '411', '2015-04-10', '-3734', '0', '0', '0', 'Uddeshika Jayawardhane', '2015-04-30', '1', '779569', '310', 'SB/CA/04/2015/P/310'),
('819', '1', '502', '1', '412', '2015-04-10', '-80000', '0', '0', '0', 'Uddeshika Jayawardhane', '2015-04-30', '1', '779570', '311', 'SB/CA/04/2015/P/311'),
('820', '1', '503', '1', '413', '2015-04-29', '-26720', '0', '0', '0', 'Cash', '2015-04-30', '1', '779571', '312', 'SB/CA/04/2015/P/312'),
('821', '1', '504', '1', '414', '2015-04-29', '0', '0', '0', '4', '5', NULL, '0', '779572', '313', 'SB/CA/04/2015/P/313'),
('822', '1', '505', '1', '415', '2015-04-29', '0', '0', '0', '4', '4', NULL, '0', '779573', '314', 'SB/CA/04/2015/P/314'),
('823', '1', '506', '1', '416', '2015-04-29', '-140000', '0', '0', '0', 'Cash', '2015-04-30', '1', '779574', '315', 'SB/CA/04/2015/P/315'),
('824', '1', '507', '1', '417', '2015-05-05', '-60000', '0', '0', '0', 'Cash', '2015-05-31', '1', '779575', '316', 'SB/CA/05/2015/P/316'),
('825', '1', '508', '1', '418', '2015-05-13', '-518957', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2015-05-31', '0', '779576', '317', 'SB/CA/05/2015/P/317'),
('826', '1', '509', '1', '419', '2015-05-21', '-140000', '0', '0', '0', 'Cash', '2015-05-31', '1', '779577', '318', 'SB/CA/05/2015/P/318'),
('827', '1', '510', '1', '420', '2015-05-21', '-3313', '0', '0', '0', 'Amila Palihawadana', '2015-05-31', '1', '779578', '319', 'SB/CA/05/2015/P/319'),
('828', '1', '511', '1', '421', '2015-06-01', '0', '0', '0', '4', '4', NULL, '0', '779579', '320', 'SB/CA/06/2015/P/320'),
('829', '1', '512', '1', '422', '2015-06-01', '0', '0', '0', '4', '5', NULL, '0', '779580', '321', 'SB/CA/06/2015/P/321'),
('830', '1', '513', '1', '423', '2015-06-10', '-61931.75', '0', '0', '0', 'Chanaka Padmaperuma', '2015-06-30', '1', '779581', '322', 'SB/CA/06/2015/P/322'),
('831', '1', '514', '1', '424', '2015-06-10', '0', '0', '0', '0', 'Chanaka Padmaperuma', NULL, '1', '779582', '323', 'SB/CA/06/2015/P/323'),
('832', '1', '515', '1', '425', '2015-06-15', '-501039.5', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2015-06-30', '0', '779583', '324', 'SB/CA/06/2015/P/324'),
('833', '1', '516', '1', '426', '2015-06-18', '-140000', '0', '0', '0', 'Cash', '2015-06-30', '1', '779584', '325', 'SB/CA/06/2015/P/325'),
('834', '1', '517', '1', '427', '2015-06-18', '-2380', '0', '0', '0', 'Sahan Senevirathna', '2015-07-31', '1', '779585', '326', 'SB/CA/06/2015/P/326'),
('835', '1', '518', '1', '428', '2015-06-18', '-2460', '0', '0', '0', 'Uddeshika Jayawardhane', '2015-06-30', '1', '779586', '327', 'SB/CA/06/2015/P/327'),
('836', '1', '519', '1', '429', '2015-06-30', '0', '0', '0', '4', '4', NULL, '0', '779587', '328', 'SB/CA/06/2015/P/328'),
('837', '1', '520', '1', '430', '2015-06-30', '0', '0', '0', '4', 'Employees Trust Fund', NULL, '0', '779588', '329', 'SB/CA/06/2015/P/329'),
('838', '1', '521', '1', '431', '2015-07-02', '-18400', '0', '0', '0', 'Lahiru Sampath', '2015-07-31', '1', '779589', '330', 'SB/CA/07/2015/P/330'),
('839', '1', '522', '1', '432', '2015-07-09', '-5500', '0', '0', '0', 'Abdul Aziz bin navaz', '2015-07-31', '1', '779590', '331', 'SB/CA/07/2015/P/331'),
('840', '1', '523', '1', '433', '2015-07-09', '-10000', '0', '0', '0', 'Shaaron Nadarajah', '2015-07-31', '1', '779591', '332', 'SB/CA/07/2015/P/332'),
('841', '1', '524', '1', '434', '2015-07-10', '-72800', '0', '0', '0', 'Chanaka Padmaperuma', '2015-07-31', '1', '779592', '333', 'SB/CA/07/2015/P/333'),
('842', '1', '525', '1', '435', '2015-07-10', '-554071.35', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2015-07-31', '0', '779593', '334', 'SB/CA/07/2015/P/334'),
('843', '1', '526', '1', '436', '2015-07-27', '-140000', '0', '0', '0', 'Cash', '2015-07-31', '1', '779594', '335', 'SB/CA/07/2015/P/335'),
('844', '1', '527', '1', '437', '2015-07-29', '-350000', '0', '0', '0', 'Chanaka Padmaperuma', '2015-07-31', '1', '779595', '336', 'SB/CA/07/2015/P/336'),
('845', '1', '528', '1', '438', '2015-07-29', '0', '0', '0', '4', '4', NULL, '0', '779596', '337', 'SB/CA/07/2015/P/337'),
('846', '1', '529', '1', '439', '2015-07-29', '0', '0', '0', '4', '5', NULL, '0', '779597', '338', 'SB/CA/07/2015/P/338'),
('847', '1', '530', '1', '440', '2015-08-12', '-75000', '0', '0', '0', 'Chanaka Padmaperuma', '2015-08-31', '1', '779598', '339', 'SB/CA/08/2015/P/339'),
('848', '1', '531', '1', '441', '2015-08-12', '-2839', '0', '0', '0', 'Prasanna Vivek', '2015-08-31', '1', '779599', '340', 'SB/CA/08/2015/P/340'),
('849', '1', '532', '1', '442', '2015-08-19', '0', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', NULL, '0', '554572', '341', 'SB/CA/08/2015/P/341'),
('850', '1', '533', '1', '442', '2015-08-19', '-525289.2', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '2015-08-31', '0', '779600', '342', 'SB/CA/08/2015/P/342'),
('851', '1', '534', '1', '442', '2015-08-24', '-1375', '0', '0', '0', 'Mewan Samarasinghe', '2015-08-31', '1', '816701', '343', 'SB/CA/08/2015/P/343'),
('852', '1', '535', '1', '443', '2015-08-31', '0', '0', '0', '4', '4', NULL, '0', '816702', '344', 'SB/CA/08/2015/P/344'),
('853', '1', '536', '1', '444', '2015-08-31', '0', '0', '0', '4', '5', NULL, '0', '816703', '345', 'SB/CA/08/2015/P/345'),
('854', '1', '537', '1', '445', '2015-08-31', '-10000', '0', '0', '0', 'Shanaka Silva', '2015-09-30', '1', '816704', '346', 'SB/CA/08/2015/P/346'),
('855', '1', '538', '1', '446', '2015-08-31', '-9590', '0', '0', '0', 'Asantha Rathnasekara', '2015-09-30', '1', '816705', '347', 'SB/CA/08/2015/P/347'),
('856', '1', '539', '1', '447', '2015-09-02', '0', '0', '0', '0', 'Cash', NULL, '1', '816706', '348', 'SB/CA/09/2015/P/348'),
('857', '1', '540', '1', '447', '2015-09-02', '0', '0', '0', '0', 'Cash', NULL, '1', '816706', '349', 'SB/CA/09/2015/P/349'),
('858', '1', '541', '1', '447', '2015-09-02', '-140000', '0', '0', '0', 'Cash', '2015-09-30', '1', '816706', '350', 'SB/CA/09/2015/P/350'),
('859', '1', '542', '1', '447', '2015-09-09', '-81700', '0', '0', '0', 'Tiron Aravinda ', '2015-09-30', '1', '816707', '351', 'SB/CA/09/2015/P/351'),
('860', '1', '543', '1', '448', '2015-09-09', '-34666', '0', '0', '0', 'Dammika Suranga', '2016-01-31', '1', '816708', '352', 'SB/CA/09/2015/P/352'),
('861', '1', '544', '1', '449', '2015-09-09', '-87250', '0', '0', '0', 'Computer Solutions &amp; Network Private LTD', '2015-09-30', '0', '816709', '353', 'SB/CA/09/2015/P/353'),
('862', '1', '545', '1', '450', '2015-09-11', '-6687', '0', '0', '0', 'Amila Palihawadana', '2015-09-30', '1', '816710', '354', 'SB/CA/09/2015/P/354'),
('863', '1', '546', '1', '451', '2015-09-22', '-553097', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2015-09-30', '0', '816711', '355', 'SB/CA/09/2015/P/355'),
('864', '1', '547', '1', '452', '2015-09-22', '-140000', '0', '0', '0', 'Cash', '2015-09-30', '1', '816712', '356', 'SB/CA/09/2015/P/356'),
('865', '1', '548', '1', '453', '2015-09-23', '-6244', '0', '0', '0', 'Jude Premal Padidilian', '2015-09-30', '1', '816713', '357', 'SB/CA/09/2015/P/357'),
('866', '1', '549', '1', '454', '2015-09-30', '0', '0', '0', '4', '4', NULL, '0', '816715', '358', 'SB/CA/09/2015/P/358'),
('867', '1', '550', '1', '455', '2015-09-30', '0', '0', '0', '4', '5', NULL, '0', '816716', '359', 'SB/CA/09/2015/P/359'),
('868', '1', '551', '1', '456', '2014-04-16', '-50', '0', '0', '0', 'Bank Casual OD Charge', '2014-04-30', '0', '0', '360', 'SB/CA/09/2015/P/360'),
('869', '1', '552', '1', '457', '2014-04-22', '0', '0', '0', '0', 'Bank Cheque Book Charges', '2014-04-30', '0', '0', '361', 'SB/CA/09/2015/P/361'),
('870', '1', '553', '1', '458', '2014-04-28', '-2325310', '0', '0', '0', 'Staff Salaries', '2014-04-30', '0', '0', '362', 'SB/CA/09/2015/P/362'),
('871', '1', '554', '1', '459', '2014-04-28', '-500', '0', '0', '0', 'Salary Commission', '2014-04-30', '0', '0', '363', 'SB/CA/09/2015/P/363'),
('872', '2', '104', '1', '96', '2014-04-03', '110000', '0', '0', '0', 'Fund Transfer - Evolve Technologies', '2014-04-30', '0', '0', '92', 'SB/CA/09/2015/D/92'),
('873', '2', '104', '7', '96', '2014-04-03', '-509.45', '0', '0', '0', 'Fund Transfer - Evolve Technologies', NULL, '0', '0', '92', 'SB/CA/09/2015/D/92'),
('874', '2', '105', '1', '97', '2014-04-11', '150000', '0', '0', '0', 'Fund Transfer - Evolve Technologies', '2014-04-30', '0', '0', '93', 'SB/CA/09/2015/D/93'),
('875', '2', '105', '7', '97', '2014-04-11', '-694.7', '0', '0', '0', 'Fund Transfer - Evolve Technologies', NULL, '0', '0', '93', 'SB/CA/09/2015/D/93'),
('876', '2', '106', '1', '98', '2014-04-28', '3300000', '0', '0', '0', 'Fund Transfer - Evolve Technologies', '2014-04-30', '0', '0', '94', 'SB/CA/09/2015/D/94'),
('877', '2', '106', '7', '98', '2014-04-28', '-15108.51', '0', '0', '0', 'Fund Transfer - Evolve Technologies', NULL, '0', '0', '94', 'SB/CA/09/2015/D/94'),
('878', '1', '555', '1', '460', '2014-05-28', '-2567932.85', '0', '0', '0', 'Staff Salaries', '2014-05-31', '0', '0', '364', 'SB/CA/09/2015/P/364'),
('879', '1', '556', '1', '461', '2014-05-28', '-500', '0', '0', '0', 'Salary Commission', '2014-05-31', '0', '0', '365', 'SB/CA/09/2015/P/365'),
('880', '1', '557', '1', '462', '2014-05-31', '-329.85', '0', '0', '0', 'OD Interest for the month of May', '2014-05-31', '0', '0', '366', 'SB/CA/09/2015/P/366'),
('881', '2', '107', '1', '99', '2014-05-26', '500000', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '2014-05-31', '0', '0', '95', 'SB/CA/09/2015/D/95'),
('882', '2', '107', '7', '99', '2014-05-26', '-2289.17', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '95', 'SB/CA/09/2015/D/95'),
('883', '2', '108', '1', '100', '2014-05-28', '600000', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '2014-05-31', '0', '0', '96', 'SB/CA/09/2015/D/96'),
('884', '2', '108', '7', '100', '2014-05-28', '-2747', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '96', 'SB/CA/09/2015/D/96'),
('885', '2', '109', '1', '101', '2014-05-30', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-05-31', '0', '0', '97', 'SB/CA/09/2015/D/97'),
('886', '2', '109', '7', '101', '2014-05-30', '-2297.58', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '97', 'SB/CA/09/2015/D/97'),
('887', '2', '110', '1', '102', '2014-05-28', '2082400', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-05-31', '0', '0', '98', 'SB/CA/09/2015/D/98'),
('888', '2', '110', '7', '102', '2014-05-28', '-9533.93', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '98', 'SB/CA/09/2015/D/98'),
('889', '1', '558', '1', '463', '2014-06-17', '-500', '0', '0', '0', 'Other expenses', '2014-06-30', '0', '0', '367', 'SB/CA/09/2015/P/367'),
('890', '1', '559', '1', '464', '2014-06-27', '-2952564.44', '0', '0', '0', 'Staff Salaries', '2014-06-30', '0', '0', '368', 'SB/CA/09/2015/P/368'),
('891', '1', '560', '1', '465', '2014-06-27', '-500', '0', '0', '0', 'Salary Commission', '2014-06-30', '0', '0', '369', 'SB/CA/09/2015/P/369'),
('892', '2', '111', '1', '103', '2014-06-20', '80000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-06-30', '0', '0', '99', 'SB/CA/09/2015/D/99'),
('893', '2', '111', '7', '103', '2014-06-20', '-367.61', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '99', 'SB/CA/09/2015/D/99'),
('894', '2', '112', '1', '104', '2014-06-27', '3000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-06-30', '0', '0', '100', 'SB/CA/09/2015/D/100'),
('895', '2', '112', '7', '104', '2014-06-27', '-13785.5', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '100', 'SB/CA/09/2015/D/100'),
('896', '2', '113', '1', '105', '2014-06-30', '1000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-06-30', '0', '0', '101', 'SB/CA/09/2015/D/101'),
('897', '2', '113', '7', '105', '2014-06-30', '-4523.25', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '101', 'SB/CA/09/2015/D/101'),
('898', '1', '561', '1', '466', '2014-07-01', '0', '0', '0', '0', 'Other Payments', NULL, '0', '0', '370', 'SB/CA/09/2015/P/370'),
('899', '1', '562', '1', '467', '2014-07-28', '-2694027', '0', '0', '0', 'Staff Salaries', '2014-07-31', '0', '0', '371', 'SB/CA/09/2015/P/371'),
('900', '1', '563', '1', '468', '2014-07-28', '-500', '0', '0', '0', 'Salary Commission', '2014-07-31', '0', '0', '372', 'SB/CA/09/2015/P/372'),
('901', '2', '114', '1', '106', '2014-07-18', '150000', '0', '0', '0', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '2014-07-31', '0', '0', '102', 'SB/CA/09/2015/D/102'),
('902', '2', '114', '7', '106', '2014-07-18', '-678.49', '0', '0', '0', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '102', 'SB/CA/09/2015/D/102'),
('903', '2', '115', '1', '107', '2014-07-28', '3300000', '0', '0', '0', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '2014-07-31', '0', '0', '103', 'SB/CA/09/2015/D/103'),
('904', '2', '115', '7', '107', '2014-07-28', '-14963.27', '0', '0', '0', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '103', 'SB/CA/09/2015/D/103'),
('905', '2', '116', '1', '108', '2014-07-31', '456916.95', '0', '0', '0', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '2014-07-31', '0', '0', '104', 'SB/CA/09/2015/D/104'),
('906', '2', '116', '7', '108', '2014-07-31', '-2071.81', '0', '0', '0', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '104', 'SB/CA/09/2015/D/104'),
('907', '1', '564', '1', '469', '2014-08-27', '-2566397.5', '0', '0', '0', 'Staff Salaries', '2014-08-31', '0', '0', '373', 'SB/CA/10/2015/P/373'),
('908', '1', '565', '1', '470', '2014-08-27', '-500', '0', '0', '0', 'Salary Commission', '2014-08-31', '0', '0', '374', 'SB/CA/10/2015/P/374'),
('909', '1', '566', '1', 'B', '2014-08-28', '-750', '0', '0', '0', 'Bank Cheque Book Charges', '2014-08-31', '0', '0', '375', 'SB/CA/10/2015/P/375'),
('910', '1', '567', '1', '471', '2014-08-31', '0', '0', '0', '0', 'Bank OD Interest', '2014-08-31', '0', '0', '106', 'ET/10/2015/P/106'),
('911', '2', '117', '1', '109', '2014-08-08', '100000', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '2014-08-31', '0', '0', '105', 'SB/CA/10/2015/D/105'),
('912', '2', '117', '7', '109', '2014-08-08', '-453.43', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '105', 'SB/CA/10/2015/D/105'),
('913', '2', '118', '1', '110', '2014-08-12', '300000', '0', '0', '0', 'Fund Transfer  Evolve Technologies (Pvt) Ltd ', '2014-08-31', '0', '0', '106', 'SB/CA/10/2015/D/106'),
('914', '2', '118', '7', '110', '2014-08-12', '-1360.3', '0', '0', '0', 'Fund Transfer  Evolve Technologies (Pvt) Ltd ', NULL, '0', '0', '106', 'SB/CA/10/2015/D/106'),
('915', '2', '119', '1', '111', '2014-08-27', '3500000', '0', '0', '0', 'Fund Transfer  Evolve Technologies (Pvt) Ltd ', '2014-08-31', '0', '0', '107', 'SB/CA/10/2015/D/107'),
('916', '2', '119', '7', '111', '2014-08-27', '-16279.07', '0', '0', '0', 'Fund Transfer  Evolve Technologies (Pvt) Ltd ', NULL, '0', '0', '107', 'SB/CA/10/2015/D/107'),
('917', '1', '568', '1', '472', '2014-09-01', '0', '0', '0', '0', 'Cheque Payment', NULL, '0', '0', '376', 'SB/CA/10/2015/P/376'),
('918', '1', '569', '1', '473', '2014-09-29', '-2587477', '0', '0', '0', 'Staff Salaries', '2014-09-30', '0', '0', '377', 'SB/CA/10/2015/P/377'),
('919', '1', '570', '1', '474', '2014-09-29', '-500', '0', '0', '0', 'Salary Commission', '2014-09-30', '0', '0', '378', 'SB/CA/10/2015/P/378'),
('920', '1', '571', '1', '475', '2014-09-30', '-250', '0', '0', '0', 'Bank OD Charges', '2014-09-30', '0', '0', '379', 'SB/CA/10/2015/P/379'),
('921', '2', '120', '1', '112', '2014-09-04', '200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-09-30', '0', '0', '108', 'SB/CA/10/2015/D/108'),
('922', '2', '120', '7', '112', '2014-09-04', '-930.23', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '108', 'SB/CA/10/2015/D/108'),
('923', '2', '121', '1', '113', '2014-09-16', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-09-30', '0', '0', '109', 'SB/CA/10/2015/D/109'),
('924', '2', '121', '7', '113', '2014-09-16', '-2325.58', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '109', 'SB/CA/10/2015/D/109'),
('925', '2', '122', '1', '114', '2014-09-29', '3200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-09-30', '0', '0', '110', 'SB/CA/10/2015/D/110'),
('926', '2', '122', '7', '114', '2014-09-29', '-14883.72', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '110', 'SB/CA/10/2015/D/110'),
('927', '1', '572', '1', '476', '2014-10-27', '-2848146', '0', '0', '0', 'Staff Salary', '2014-10-31', '0', '0', '380', 'SB/CA/10/2015/P/380'),
('928', '1', '573', '1', '477', '2014-10-27', '0', '0', '0', '0', 'Salary Commission', '2014-10-31', '0', '0', '381', 'SB/CA/10/2015/P/381'),
('929', '2', '123', '1', '115', '2014-10-14', '100000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-10-31', '0', '0', '111', 'SB/CA/10/2015/D/111'),
('930', '2', '123', '7', '115', '2014-10-14', '-465.12', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '111', 'SB/CA/10/2015/D/111'),
('931', '2', '124', '1', '116', '2014-10-27', '3700000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-10-31', '0', '0', '112', 'SB/CA/10/2015/D/112'),
('932', '2', '124', '7', '116', '2014-10-27', '-17209.3', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '112', 'SB/CA/10/2015/D/112'),
('933', '1', '574', '1', '478', '2014-11-27', '-2725392.01', '0', '0', '0', 'Staff Salaries', '2014-11-30', '0', '0', '382', 'SB/CA/10/2015/P/382'),
('934', '1', '575', '1', '479', '2014-11-27', '-500', '0', '0', '0', 'Salary Commission', '2014-11-30', '0', '554573', '383', 'SB/CA/10/2015/P/383'),
('935', '2', '125', '1', '117', '2014-11-04', '80000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-11-30', '0', '0', '113', 'SB/CA/10/2015/D/113'),
('936', '2', '125', '7', '117', '2014-11-04', '-372.09', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '113', 'SB/CA/10/2015/D/113'),
('937', '2', '126', '1', '118', '2014-11-26', '150000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-11-30', '0', '0', '114', 'SB/CA/10/2015/D/114'),
('938', '2', '126', '7', '118', '2014-11-26', '-697.67', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '114', 'SB/CA/10/2015/D/114'),
('939', '2', '127', '1', '119', '2014-11-27', '3700000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-11-30', '0', '0', '115', 'SB/CA/10/2015/D/115'),
('940', '2', '127', '7', '119', '2014-11-27', '-17209.3', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '115', 'SB/CA/10/2015/D/115'),
('941', '1', '576', '1', '479', '2015-10-01', '-201413', '0', '0', '0', 'Chanaka Padmaperuma', '2015-10-31', '1', '816717', '383', 'SB/CA/10/2015/P/383'),
('942', '1', '577', '1', '480', '2014-12-17', '-500', '0', '0', '0', 'Other expenses', '2014-12-31', '0', '0', '384', 'SB/CA/10/2015/P/384'),
('943', '1', '578', '1', '481', '2014-12-22', '0', '0', '0', '0', 'Staff Salaries', NULL, '0', '0', '106', 'ET/10/2015/P/106'),
('944', '1', '579', '1', '482', '2014-12-22', '0', '0', '0', '0', 'Salary Commission', NULL, '0', '0', '107', 'ET/10/2015/P/107'),
('945', '2', '128', '1', '120', '2014-12-10', '0', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '116', 'SB/CA/10/2015/D/116'),
('946', '2', '129', '1', '120', '2014-12-10', '650000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-12-31', '0', '0', '117', 'SB/CA/10/2015/D/117'),
('947', '2', '129', '7', '120', '2014-12-10', '-3023.26', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '117', 'SB/CA/10/2015/D/117'),
('948', '2', '130', '1', '120', '2014-12-29', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-12-31', '0', '0', '118', 'SB/CA/10/2015/D/118'),
('949', '2', '130', '7', '120', '2014-12-29', '-2325.58', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '118', 'SB/CA/10/2015/D/118'),
('950', '2', '131', '1', '121', '2014-12-22', '3000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2014-12-31', '0', '0', '119', 'SB/CA/10/2015/D/119'),
('951', '2', '131', '7', '121', '2014-12-22', '-13953.49', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '119', 'SB/CA/10/2015/D/119'),
('952', '1', '580', '1', '483', '2015-01-27', '-2884439.05', '0', '0', '0', 'Staff Salaries', '2015-01-31', '0', '0', '385', 'SB/CA/10/2015/P/385'),
('953', '1', '581', '1', '484', '2015-01-27', '-500', '0', '0', '0', 'Salary Commission', '2015-01-31', '0', '554574', '386', 'SB/CA/10/2015/P/386'),
('954', '1', '582', '1', '485', '2015-01-30', '-750', '0', '0', '0', 'Bank Cheque Book Charges  ', '2015-01-31', '0', '0', '387', 'SB/CA/10/2015/P/387'),
('955', '2', '132', '1', '122', '2015-01-20', '150000', '0', '0', '0', 'Fund Transfer Evolve Technologies', '2015-01-31', '0', '0', '120', 'SB/CA/10/2015/D/120'),
('956', '2', '132', '7', '122', '2015-01-20', '-697.67', '0', '0', '0', 'Fund Transfer Evolve Technologies', NULL, '0', '0', '120', 'SB/CA/10/2015/D/120'),
('957', '2', '133', '1', '123', '2015-01-27', '3600000', '0', '0', '0', 'Fund Transfer Evolve Technologies', '2015-01-31', '0', '0', '121', 'SB/CA/10/2015/D/121'),
('958', '2', '133', '7', '123', '2015-01-27', '-16744.19', '0', '0', '0', 'Fund Transfer Evolve Technologies', NULL, '0', '0', '121', 'SB/CA/10/2015/D/121'),
('959', '2', '134', '1', '124', '2015-01-29', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies', '2015-01-31', '0', '0', '122', 'SB/CA/10/2015/D/122'),
('960', '2', '134', '7', '124', '2015-01-29', '-2325.58', '0', '0', '0', 'Fund Transfer Evolve Technologies', NULL, '0', '0', '122', 'SB/CA/10/2015/D/122'),
('961', '1', '583', '1', '486', '2015-02-27', '-3008901.71', '0', '0', '0', 'Staff Salaries', '2015-02-28', '0', '0', '388', 'SB/CA/10/2015/P/388'),
('962', '1', '584', '1', '487', '2015-02-27', '-750', '0', '0', '0', 'Salary Commission', '2015-02-28', '0', '0', '389', 'SB/CA/10/2015/P/389'),
('963', '1', '585', '1', '488', '2015-02-28', '-250', '0', '0', '0', 'Bank OD Charges', '2015-02-28', '0', '0', '390', 'SB/CA/10/2015/P/390'),
('964', '2', '135', '1', '125', '2015-02-10', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '2015-02-28', '0', '0', '123', 'SB/CA/10/2015/D/123'),
('965', '2', '135', '7', '125', '2015-02-10', '-2325.58', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', NULL, '0', '0', '123', 'SB/CA/10/2015/D/123'),
('966', '2', '136', '1', '126', '2015-02-20', '200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '2015-02-28', '0', '0', '124', 'SB/CA/10/2015/D/124'),
('967', '2', '136', '7', '126', '2015-02-20', '-930.23', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', NULL, '0', '0', '124', 'SB/CA/10/2015/D/124'),
('968', '2', '137', '1', '127', '2015-02-24', '1000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '2015-02-28', '0', '0', '125', 'SB/CA/10/2015/D/125'),
('969', '2', '137', '7', '127', '2015-02-24', '-4651.16', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', NULL, '0', '0', '125', 'SB/CA/10/2015/D/125'),
('970', '2', '138', '1', '128', '2015-02-27', '4000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '2015-02-28', '0', '0', '126', 'SB/CA/10/2015/D/126'),
('971', '2', '138', '7', '128', '2015-02-27', '-18604.65', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', NULL, '0', '0', '126', 'SB/CA/10/2015/D/126'),
('972', '2', '139', '1', '129', '2015-03-27', '4000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '2015-03-31', '0', '0', '127', 'SB/CA/10/2015/D/127'),
('973', '2', '139', '7', '129', '2015-03-27', '-18604.65', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', NULL, '0', '0', '127', 'SB/CA/10/2015/D/127'),
('974', '1', '586', '1', '489', '2015-03-27', '-3048692.73', '0', '0', '0', 'Staff Salaries', '2015-03-31', '0', '554575', '391', 'SB/CA/10/2015/P/391'),
('975', '1', '587', '1', '490', '2015-03-27', '-750', '0', '0', '0', 'Salary Commission', '2015-03-31', '0', '554576', '392', 'SB/CA/10/2015/P/392'),
('976', '1', '588', '1', '471', '2014-08-31', '0', '0', '0', '0', 'Bank OD Interest', NULL, '0', '554577', '393', 'SB/CA/10/2015/P/393'),
('977', '1', '589', '1', '491', '2014-08-31', '-887.39', '0', '0', '0', 'Bank OD Charges', '2014-08-31', '0', '554578', '393', 'SB/CA/10/2015/P/393'),
('978', '1', '590', '1', '492', '2014-12-22', '-2993342', '0', '0', '0', 'Staff Salaries', '2014-12-31', '0', '0', '394', 'SB/CA/10/2015/P/394'),
('979', '1', '591', '1', '493', '2014-12-22', '-500', '0', '0', '0', 'Salary Commisssion', '2014-12-31', '0', '554579', '395', 'SB/CA/10/2015/P/395'),
('980', '1', '592', '1', '494', '2015-10-02', '-4117.5', '0', '0', '4', '5', '2015-10-31', '0', '816718', '396', 'SB/CA/10/2015/P/396'),
('981', '1', '593', '1', '495', '2015-10-12', '-659862.4', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '2015-10-31', '0', '816719', '397', 'SB/CA/10/2015/P/397'),
('982', '1', '594', '1', '496', '2015-10-13', '-8250', '0', '0', '0', 'Mewan Samarasinghe', '2015-10-31', '1', '816720', '398', 'SB/CA/10/2015/P/398'),
('983', '1', '595', '1', '497', '2015-10-14', '0', '0', '0', '0', 'Cash', NULL, '1', '816721', '399', 'SB/CA/10/2015/P/399'),
('984', '2', '140', '1', '130', '2015-10-19', '0', '0', '0', '0', 'Transfer from GBP A/C', NULL, '0', '0', '128', 'SB/CA/10/2015/D/128'),
('985', '12', '57', '7', '57', '2014-04-28', '0', '0', '0', '2', '2', NULL, '0', '0', '128', 'ET/GBP/10/2015/D/128'),
('986', '12', '58', '7', '58', '2014-05-28', '17822', '0', '0', '2', '2', NULL, '0', '0', '129', 'ET/GBP/10/2015/D/129'),
('987', '12', '59', '7', '59', '2014-06-28', '0', '0', '0', '2', '2', NULL, '0', '0', '130', 'ET/GBP/10/2015/D/130'),
('988', '12', '60', '7', '60', '2014-08-28', '0', '0', '0', '2', '2', NULL, '0', '0', '131', 'ET/GBP/10/2015/D/131'),
('989', '12', '61', '7', '61', '2014-09-28', '0', '0', '0', '2', '2', NULL, '0', '0', '132', 'ET/GBP/10/2015/D/132'),
('990', '12', '62', '7', '62', '2014-10-28', '20203', '0', '0', '2', '2', NULL, '0', '0', '133', 'ET/GBP/10/2015/D/133'),
('991', '12', '63', '7', '63', '2014-11-28', '0', '0', '0', '2', '2', NULL, '0', '0', '134', 'ET/GBP/10/2015/D/134'),
('992', '12', '64', '7', '64', '2014-12-28', '0', '0', '0', '2', '2', NULL, '0', '0', '135', 'ET/GBP/10/2015/D/135'),
('993', '12', '65', '7', '65', '2015-01-28', '22340', '0', '0', '2', '2', NULL, '0', '0', '136', 'ET/GBP/10/2015/D/136'),
('994', '12', '66', '7', '66', '2015-02-28', '25071', '0', '0', '2', '2', NULL, '0', '0', '137', 'ET/GBP/10/2015/D/137'),
('995', '12', '67', '7', '67', '2015-03-28', '0', '0', '0', '2', '2', NULL, '0', '0', '138', 'ET/GBP/10/2015/D/138'),
('996', '12', '68', '7', '68', '2014-07-28', '0', '0', '0', '2', '2', NULL, '0', '0', '139', 'ET/GBP/10/2015/D/139'),
('997', '2', '141', '5', '131', '2014-06-28', '0', '0', '0', '0', 'Exchange difference', NULL, '0', '0', '61', 'ET/10/2015/D/61'),
('998', '2', '142', '7', '131', '2014-06-28', '0', '0', '0', '0', 'Exchange difference', NULL, '0', '0', '140', 'ET/GBP/10/2015/D/140'),
('999', '1', '596', '1', '498', '2015-10-26', '-64100', '0', '0', '0', 'Cash', '2015-10-31', '1', '816722', '400', 'SB/CA/10/2015/P/400'),
('1000', '1', '597', '1', '499', '2015-10-28', '-512966.25', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2015-10-31', '0', '816723', '401', 'SB/CA/10/2015/P/401'),
('1001', '1', '598', '1', '500', '2015-10-28', '-10000', '0', '0', '0', 'Jeewaani Kokila Perera', '2015-11-30', '1', '816724', '402', 'SB/CA/10/2015/P/402'),
('1002', '12', '57', '7', '57', '2014-04-25', '15962', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1003', '12', '68', '7', '68', '2014-07-25', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1004', '12', '60', '7', '60', '2014-08-25', '19708', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1005', '12', '61', '7', '61', '2014-09-25', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1006', '12', '64', '7', '64', '2014-12-25', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1007', '12', '64', '7', '64', '2014-12-29', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1008', '1', '599', '1', '501', '2015-10-29', '0', '0', '0', '4', '4', NULL, '0', '816725', '403', 'SB/CA/10/2015/P/403'),
('1009', '1', '600', '1', '502', '2015-10-29', '0', '0', '0', '4', '5', NULL, '0', '816726', '404', 'SB/CA/10/2015/P/404'),
('1010', '12', '61', '7', '61', '2014-09-29', '20530', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1011', '12', '64', '7', '64', '2014-12-28', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1012', '12', '64', '7', '64', '2014-12-29', '20147', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1013', '1', '601', '5', '503', '2015-09-29', '0', '0', '0', '0', 'Leema Creations (Pvt)Ltd.', NULL, '0', '554580', '106', 'ET/11/2015/P/106'),
('1014', '1', '602', '1', '504', '2015-11-05', '-979658.65', '0', '0', '0', 'Leema Creation (Pvt) Ltd', '2015-11-30', '0', '816727', '405', 'SB/CA/11/2015/P/405'),
('1015', '1', '603', '1', '505', '2015-11-05', '-295340', '0', '0', '0', 'Cash', '2015-11-30', '1', '816728', '406', 'SB/CA/11/2015/P/406'),
('1016', '1', '604', '1', '506', '2015-11-11', '-140000', '0', '0', '0', 'Cash', '2015-11-30', '1', '816729', '407', 'SB/CA/11/2015/P/407'),
('1017', '1', '605', '1', '497', '2015-10-14', '-140000', '0', '0', '0', 'Cash', '2015-10-31', '1', '816721', '408', 'SB/CA/11/2015/P/408'),
('1018', '1', '606', '1', '507', '2015-11-13', '-10000', '0', '0', '0', 'Uddeshika Jayawardhane', '2015-11-30', '1', '816730', '409', 'SB/CA/11/2015/P/409'),
('1019', '1', '607', '1', '508', '2015-11-24', '-580487.05', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2015-11-30', '0', '816731', '410', 'SB/CA/11/2015/P/410'),
('1020', '1', '608', '1', '509', '2015-12-01', '-3603', '0', '0', '0', 'Aziz Navaz', '2015-12-31', '1', '816732', '411', 'SB/CA/11/2015/P/411'),
('1021', '1', '609', '1', '510', '2015-12-02', '0', '0', '0', '4', '5', NULL, '0', '816733', '412', 'SB/CA/12/2015/P/412'),
('1022', '1', '610', '5', '511', '2015-12-02', '0', '0', '0', '4', '4', NULL, '0', '816734', '107', 'ET/12/2015/P/107'),
('1023', '1', '611', '1', '511', '2015-12-02', '0', '0', '0', '4', '4', NULL, '0', '816734', '413', 'SB/CA/12/2015/P/413'),
('1024', '1', '612', '1', '511', '2015-12-04', '-809500', '0', '0', '0', 'Cash', '2015-12-31', '1', '816735', '414', 'SB/CA/12/2015/P/414'),
('1025', '1', '613', '1', '512', '2015-12-04', '0', '0', '0', '0', 'E-guardian', NULL, '0', '816736', '415', 'SB/CA/12/2015/P/415'),
('1026', '1', '614', '1', '513', '2015-12-11', '-140000', '0', '0', '0', 'Cash', '2015-12-31', '1', '816737', '416', 'SB/CA/12/2015/P/416'),
('1027', '1', '615', '1', '514', '2015-12-11', '-200000', '0', '0', '0', 'Cash', '2015-12-31', '1', '816738', '417', 'SB/CA/12/2015/P/417'),
('1028', '1', '616', '1', '515', '2015-12-21', '-584007.55', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2015-12-31', '0', '816739', '418', 'SB/CA/12/2015/P/418'),
('1029', '1', '617', '1', '516', '2015-12-30', '0', '0', '0', '4', '4', NULL, '0', '816740', '419', 'SB/CA/12/2015/P/419'),
('1030', '1', '618', '1', '517', '2015-12-30', '0', '0', '0', '4', '5', NULL, '0', '816741', '420', 'SB/CA/12/2015/P/420'),
('1031', '1', '619', '1', '454', '2015-09-30', '0', '0', '0', '4', '4', NULL, '0', '816715', '421', 'SB/CA/12/2015/P/421'),
('1032', '1', '620', '1', '455', '2015-09-30', '0', '0', '0', '4', '5', NULL, '0', '816716', '422', 'SB/CA/12/2015/P/422'),
('1033', '1', '621', '1', '518', '2014-07-31', '-170000', '0', '0', '4', NULL, '2014-08-31', '0', '0', '423', 'SB/CA/12/2015/P/423'),
('1034', '1', '622', '1', '519', '2014-08-05', '0', '0', '0', '0', 'Chanaka Padmaperuma', NULL, '0', '0', '424', 'SB/CA/12/2015/P/424'),
('1035', '1', '623', '1', '520', '2014-08-05', '0', '0', '0', '0', 'POPE &amp; COMPANY', NULL, '0', '0', '425', 'SB/CA/12/2015/P/425'),
('1036', '1', '624', '1', '521', '2014-09-16', '0', '0', '0', '0', 'Cash', NULL, '0', '0', '426', 'SB/CA/12/2015/P/426'),
('1037', '1', '625', '1', '522', '2014-11-14', '0', '0', '0', '0', 'Nishan Jinadasa', NULL, '0', '0', '427', 'SB/CA/12/2015/P/427'),
('1038', '1', '626', '1', '523', '2014-12-12', '0', '0', '0', '0', 'Cash', NULL, '0', '0', '428', 'SB/CA/12/2015/P/428'),
('1039', '1', '627', '1', '524', '2014-12-23', '0', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', NULL, '0', '0', '429', 'SB/CA/12/2015/P/429'),
('1040', '1', '628', '5', '519', '2014-08-05', '0', '0', '0', '0', 'Chanaka Padmaperuma', NULL, '0', '554581', '107', 'ET/12/2015/P/107'),
('1041', '1', '629', '5', '519', '2014-08-05', '0', '0', '0', '0', 'Chanaka Padmaperuma', NULL, '0', '554582', '108', 'ET/12/2015/P/108'),
('1042', '1', '630', '5', '520', '2014-08-05', '-18500', '0', '0', '0', 'POPE &amp; COMPANY', NULL, '0', '554583', '109', 'ET/12/2015/P/109'),
('1043', '1', '631', '5', '521', '2014-09-16', '-176000', '0', '0', '0', 'Cash', NULL, '0', '554584', '110', 'ET/12/2015/P/110'),
('1044', '1', '632', '5', '522', '2014-11-14', '-504000', '0', '0', '0', 'Nishan Jinadasa', NULL, '0', '554585', '111', 'ET/12/2015/P/111'),
('1045', '1', '633', '5', '523', '2014-12-12', '0', '0', '0', '0', 'Cash', NULL, '0', '554586', '112', 'ET/12/2015/P/112'),
('1046', '1', '634', '5', '524', '2014-12-23', '0', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', NULL, '0', '554587', '113', 'ET/12/2015/P/113'),
('1047', '1', '635', '5', '519', '2014-08-05', '-22500', '0', '0', '0', 'Chanaka Padmaperuma', NULL, '0', '554588', '114', 'ET/12/2015/P/114'),
('1048', '1', '636', '5', '291', '2014-08-05', '0', '0', '0', '0', 'Chanaka Padmaperuma', NULL, '0', '554589', '115', 'ET/12/2015/P/115'),
('1049', '12', '69', '7', '69', '2014-12-29', '0', '0', '0', '2', '2', NULL, '0', '0', '139', 'ET/GBP/01/2016/D/139'),
('1050', '1', '637', '1', '524', '2016-01-06', '-9935', '0', '0', '0', 'K M A Prasath Perera', '2016-01-31', '1', '816742', '424', 'SB/CA/01/2016/P/424'),
('1051', '1', '638', '1', '525', '2016-01-06', '-9750', '0', '0', '0', 'Fathima Shahaniya Ashif', '2016-01-31', '1', '816743', '425', 'SB/CA/01/2016/P/425'),
('1052', '1', '639', '1', '526', '2016-01-12', '-3806', '0', '0', '0', 'Uddeshika Jayawardhane', '2016-01-31', '1', '816744', '426', 'SB/CA/01/2016/P/426'),
('1053', '12', '70', '7', '70', '2014-06-28', '11298', '0', '0', '2', '2', NULL, '0', '0', '140', 'ET/GBP/01/2016/D/140'),
('1054', '12', '71', '7', '71', '2014-07-25', '11245', '0', '0', '2', '2', NULL, '0', '0', '141', 'ET/GBP/01/2016/D/141'),
('1055', '12', '72', '7', '72', '2014-11-28', '19055', '0', '0', '2', '2', NULL, '0', '0', '142', 'ET/GBP/01/2016/D/142'),
('1056', '12', '67', '7', '67', '2015-03-28', '23038.6', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1057', '1', '640', '1', '527', '2016-01-18', '-140000', '0', '0', '0', 'Cash', '2016-01-31', '1', '816745', '427', 'SB/CA/01/2016/P/427'),
('1058', '1', '641', '1', '457', '2014-04-22', '-750', '0', '0', '0', 'Bank Cheque Book Charges', '2014-04-30', '0', '554590', '428', 'SB/CA/01/2016/P/428'),
('1059', '1', '642', '1', '477', '2014-10-27', '-500', '0', '0', '0', 'Salary Commission', '2014-10-31', '0', '0', '429', 'SB/CA/01/2016/P/429'),
('1060', '1', '643', '1', '243', '2014-04-29', '-67881.75', '0', '0', '4', '5', '2014-06-30', '0', '0', '430', 'SB/CA/01/2016/P/430'),
('1061', '1', '644', '1', '244', '2014-04-29', '-452545', '0', '0', '4', '5', '2014-06-30', '0', '0', '431', 'SB/CA/01/2016/P/431'),
('1062', '2', '143', '1', '131', '2016-01-25', '0', '0', '0', '0', 'Involve 360 (pvt) Ltd', '2016-01-31', '0', '0', '129', 'SB/CA/01/2016/D/129'),
('1063', '1', '645', '1', '528', '2016-01-25', '-9965.58', '0', '0', '0', 'Amila Palihawadana', '2016-01-31', '1', '816746', '432', 'SB/CA/01/2016/P/432'),
('1064', '1', '646', '1', '529', '2016-01-26', '-3756', '0', '0', '0', 'Jude Premal Padidilian', '2016-01-31', '1', '816747', '433', 'SB/CA/01/2016/P/433'),
('1065', '1', '647', '1', '530', '2016-01-26', '-9907', '0', '0', '0', 'Naushad Ameer', '2016-01-31', '1', '816748', '434', 'SB/CA/01/2016/P/434'),
('1066', '1', '648', '1', '531', '2016-01-28', '-580680.85', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2016-02-29', '0', '816749', '435', 'SB/CA/01/2016/P/435'),
('1067', '1', '649', '1', '532', '2016-01-28', '0', '0', '0', '0', 'E-guardian (Pvt) Ltd', NULL, '0', '816750', '436', 'SB/CA/01/2016/P/436'),
('1068', '1', '650', '1', '533', '2016-01-28', '0', '0', '0', '0', 'Bureau VERITAS Lanka (Pvt) Ltd', NULL, '0', '870751', '437', 'SB/CA/01/2016/P/437'),
('1069', '1', '651', '1', '534', '2016-01-28', '0', '0', '0', '0', 'Bureau VERITAS Lanka (Pvt) Ltd', NULL, '0', '870752', '438', 'SB/CA/01/2016/P/438'),
('1070', '1', '652', '1', '535', '2016-01-28', '0', '0', '0', '0', 'Assidua Technologies (Pvt) Ltd', NULL, '0', '870753', '439', 'SB/CA/01/2016/P/439'),
('1071', '1', '653', '1', '536', '2016-01-28', '-86250', '0', '0', '0', 'Genesiis Software (Pvt) Ltd', '2016-02-29', '0', '870754', '440', 'SB/CA/01/2016/P/440'),
('1072', '1', '654', '1', '537', '2016-01-28', '-12500', '0', '0', '0', 'Chanaka Padmaperuma', '2016-02-29', '1', '870755', '441', 'SB/CA/01/2016/P/441'),
('1073', '1', '655', '1', '538', '2016-01-28', '-135000', '0', '0', '0', 'Chanaka Padmaperuma', '2016-02-29', '1', '870756', '442', 'SB/CA/01/2016/P/442'),
('1074', '1', '656', '1', '533', '2016-01-28', '0', '0', '0', '0', 'Bureau VERITAS Lanka (Pvt) Ltd', NULL, '0', '870751', '443', 'SB/CA/01/2016/P/443'),
('1075', '1', '657', '1', '532', '2016-01-28', '0', '0', '0', '0', 'E-guardian (Pvt) Ltd', NULL, '0', '816750', '444', 'SB/CA/01/2016/P/444'),
('1076', '1', '658', '1', '533', '2016-01-28', '-249084', '0', '0', '0', 'Bureau VERITAS Lanka (Pvt) Ltd', '2016-03-31', '0', '870751', '445', 'SB/CA/01/2016/P/445'),
('1077', '1', '659', '1', '534', '2016-01-28', '-45288', '0', '0', '0', 'Bureau VERITAS Lanka (Pvt) Ltd', '2016-03-31', '0', '870752', '446', 'SB/CA/01/2016/P/446'),
('1078', '1', '660', '1', '532', '2016-01-28', '0', '0', '0', '0', 'E-guardian (Pvt) Ltd', NULL, '0', '816750', '447', 'SB/CA/01/2016/P/447'),
('1079', '1', '661', '1', '512', '2015-12-04', '0', '0', '0', '0', 'E-guardian', NULL, '0', '816736', '448', 'SB/CA/01/2016/P/448'),
('1080', '1', '662', '1', '535', '2016-01-28', '-83250', '0', '0', '0', 'Assidua Technologies (Pvt) Ltd', '2016-02-29', '0', '870753', '449', 'SB/CA/01/2016/P/449'),
('1081', '1', '663', '1', '539', '2016-01-29', '0', '0', '0', '4', '5', NULL, '0', '870757', '450', 'SB/CA/01/2016/P/450'),
('1082', '1', '664', '1', '540', '2016-01-29', '0', '0', '0', '4', '4', NULL, '0', '870758', '451', 'SB/CA/01/2016/P/451'),
('1083', '1', '665', '1', '541', '2016-02-05', '0', '0', '0', '0', 'Capital Management Services (Pvt) Ltd', NULL, '0', '870759', '452', 'SB/CA/02/2016/P/452'),
('1084', '1', '666', '1', '541', '2016-02-05', '-20633', '0', '0', '0', 'Capital Management Services (Pvt) Ltd', '2016-02-29', '0', '870759', '453', 'SB/CA/02/2016/P/453'),
('1085', '1', '667', '5', '541', '2015-03-31', '-2400000', '0', '0', '0', 'Cash', NULL, '0', '0', '115', 'ET/02/2016/P/115'),
('1086', '12', '73', '7', '73', '2014-12-23', '28250', '0', '0', '2', '2', NULL, '0', '0', '143', 'ET/GBP/02/2016/D/143'),
('1087', '1', '668', '1', '542', '2016-02-09', '-25000', '0', '0', '0', 'Buddhika Edirimanna', '2016-02-29', '1', '870760', '454', 'SB/CA/02/2016/P/454'),
('1088', '1', '669', '1', '543', '2016-02-09', '-12000', '0', '0', '0', 'Uddeshika Jayawardhane', '2016-02-29', '1', '870761', '455', 'SB/CA/02/2016/P/455'),
('1089', '1', '670', '1', '544', '2016-02-09', '-42261.36', '0', '0', '4', '5', '2016-02-29', '0', '870762', '456', 'SB/CA/02/2016/P/456'),
('1090', '1', '671', '1', '524', '2016-12-02', '-353525.4', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', NULL, '0', '0', '457', 'SB/CA/02/2016/P/457'),
('1091', '1', '672', '1', '523', '2016-12-02', '-140000', '0', '0', '0', 'Cash', NULL, '0', '0', '458', 'SB/CA/02/2016/P/458'),
('1092', '1', '673', '1', '545', '2016-02-15', '-5190', '0', '0', '4', '5', '2016-02-29', '0', '870763', '459', 'SB/CA/02/2016/P/459'),
('1093', '1', '674', '1', '546', '2016-02-15', '-3400', '0', '0', '0', 'Dylan Beekmeyer', '2016-02-29', '1', '870764', '460', 'SB/CA/02/2016/P/460'),
('1094', '1', '675', '1', '547', '2016-02-15', '0', '0', '0', '0', 'cash', NULL, '1', '870765', '461', 'SB/CA/02/2016/P/461'),
('1095', '1', '676', '1', '547', '2016-02-15', '-140000', '0', '0', '0', 'cash', '2016-03-31', '1', '870765', '462', 'SB/CA/02/2016/P/462'),
('1096', '1', '677', '1', '532', '2016-02-16', '-584000', '0', '0', '0', 'E-guardian Lanka Private Limited ', '2016-03-31', '0', '870766', '463', 'SB/CA/02/2016/P/463'),
('1097', '1', '678', '1', '547', '2016-02-29', '-132330', '0', '0', '4', '5', '2016-03-31', '0', '870767', '464', 'SB/CA/02/2016/P/464'),
('1098', '1', '679', '1', '548', '2016-02-29', '-882200', '0', '0', '4', '4', '2016-03-31', '0', '870768', '465', 'SB/CA/02/2016/P/465'),
('1099', '1', '680', '1', '540', '2016-01-29', '-872830.6', '0', '0', '4', '4', '2016-02-29', '0', '870758', '466', 'SB/CA/02/2016/P/466'),
('1100', '1', '681', '1', '539', '2016-01-29', '-130925', '0', '0', '4', '5', '2016-02-29', '0', '870757', '467', 'SB/CA/02/2016/P/467'),
('1101', '1', '682', '1', '516', '2015-12-30', '-726000', '0', '0', '4', '4', '2016-01-31', '0', '816740', '468', 'SB/CA/02/2016/P/468'),
('1102', '1', '683', '1', '517', '2015-12-30', '-108900', '0', '0', '4', '5', '2016-01-31', '0', '816741', '469', 'SB/CA/02/2016/P/469'),
('1103', '1', '684', '1', '415', '2015-04-29', '-570000', '0', '0', '4', '4', '2015-05-31', '0', '779573', '470', 'SB/CA/02/2016/P/470'),
('1104', '1', '685', '1', '421', '2015-06-01', '-549000', '0', '0', '4', '4', '2015-06-30', '0', '779579', '471', 'SB/CA/02/2016/P/471'),
('1105', '1', '686', '1', '429', '2015-06-30', '-582000', '0', '0', '4', '4', '2015-07-31', '0', '779587', '472', 'SB/CA/02/2016/P/472'),
('1106', '1', '687', '1', '438', '2015-07-29', '-613000', '0', '0', '4', '4', '2015-08-31', '0', '779596', '473', 'SB/CA/02/2016/P/473'),
('1107', '1', '688', '1', '443', '2015-08-31', '-659965.4', '0', '0', '4', '4', '2015-09-30', '0', '816702', '474', 'SB/CA/02/2016/P/474'),
('1108', '1', '689', '1', '454', '2015-09-30', '-694000', '0', '0', '4', '4', '2015-10-31', '0', '816715', '475', 'SB/CA/02/2016/P/475'),
('1109', '1', '690', '1', '501', '2015-10-29', '-734000', '0', '0', '4', '4', '2015-11-30', '0', '816725', '476', 'SB/CA/02/2016/P/476'),
('1110', '1', '691', '1', '511', '2015-12-02', '-692000', '0', '0', '4', '4', '2015-12-31', '0', '816734', '477', 'SB/CA/02/2016/P/477'),
('1111', '1', '692', '1', '510', '2015-12-02', '-103800', '0', '0', '4', '5', '2015-12-31', '0', '816734', '478', 'SB/CA/02/2016/P/478'),
('1112', '1', '693', '1', '502', '2015-10-29', '-110100', '0', '0', '4', '5', '2015-11-30', '0', '816726', '479', 'SB/CA/02/2016/P/479'),
('1113', '1', '694', '1', '455', '2015-09-30', '-104100', '0', '0', '4', '5', '2015-10-31', '0', '116716', '480', 'SB/CA/02/2016/P/480'),
('1114', '1', '695', '1', '444', '2015-08-31', '-98995', '0', '0', '4', '5', '2015-09-30', '0', '816703', '481', 'SB/CA/02/2016/P/481'),
('1115', '1', '696', '1', '439', '2015-07-29', '-91950', '0', '0', '4', '5', '2015-08-31', '0', '779597', '482', 'SB/CA/02/2016/P/482'),
('1116', '1', '697', '1', '430', '2015-06-30', '-87300', '0', '0', '4', '5', '2015-07-31', '0', '779588', '483', 'SB/CA/02/2016/P/483'),
('1117', '1', '698', '1', '422', '2015-06-01', '-82350', '0', '0', '4', '5', '2015-06-30', '0', '779580', '484', 'SB/CA/02/2016/P/484'),
('1118', '1', '699', '1', '414', '2015-04-29', '-85500', '0', '0', '4', '5', '2015-05-31', '0', '779572', '485', 'SB/CA/02/2016/P/485'),
('1119', '1', '700', '1', '549', '2016-03-02', '-629817.9', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '2016-03-31', '0', '870769', '486', 'SB/CA/03/2016/P/486'),
('1120', '1', '701', '1', '550', '2016-03-02', '-10000', '0', '0', '0', 'Sajith Chandraratne', '2016-03-31', '1', '870770', '487', 'SB/CA/03/2016/P/487'),
('1121', '1', '702', '1', '551', '2016-03-07', '-312500', '0', '0', '0', 'Chanaka Padmaperuma', '2016-03-31', '1', '870771', '488', 'SB/CA/03/2016/P/488'),
('1122', '1', '703', '1', '552', '2016-03-07', '-10000', '0', '0', '0', 'Amirtharaj Sivakumaran', '2016-03-31', '1', '870772', '489', 'SB/CA/03/2016/P/489'),
('1123', '1', '704', '1', '553', '2016-03-07', '-10000', '0', '0', '0', 'Sheikh Basheer', NULL, '1', '870773', '490', 'SB/CA/03/2016/P/490'),
('1124', '1', '705', '1', '554', '2016-03-09', '0', '0', '0', '0', 'Chanaka Padmaperuma', '2016-03-31', '1', '870774', '491', 'SB/CA/03/2016/P/491'),
('1125', '1', '706', '1', '555', '2016-03-15', '-45000', '0', '0', '0', 'Aziz Navaz', '2016-03-31', '1', '870776', '492', 'SB/CA/03/2016/P/492'),
('1126', '1', '707', '1', '556', '2016-03-16', '-5000', '0', '0', '0', 'Capital Management Services (Pvt) Ltd', '2016-03-31', '0', '870777', '493', 'SB/CA/03/2016/P/493'),
('1127', '1', '708', '1', '557', '2016-03-16', '-35000', '0', '0', '0', 'Shantha Adikari &amp; Co.(Chartered Accountants)', '2016-03-31', '0', '870778', '494', 'SB/CA/03/2016/P/494'),
('1128', '1', '709', '1', '558', '2016-03-25', '-140000', '0', '0', '0', 'Cash', '2016-04-30', '1', '870779', '495', 'SB/CA/03/2016/P/495'),
('1129', '1', '710', '1', '559', '2016-03-25', '-581981.4', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '2016-03-31', '0', '870780', '496', 'SB/CA/03/2016/P/496'),
('1130', '1', '711', '1', '560', '2016-03-31', '-121080', '0', '0', '4', '5', '2016-04-30', '0', '870781', '497', 'SB/CA/03/2016/P/497'),
('1131', '1', '712', '1', '561', '2016-03-31', '-807200', '0', '0', '4', '4', '2016-04-30', '0', '870782', '498', 'SB/CA/03/2016/P/498'),
('1132', '1', '713', '1', '562', '2016-03-31', '-1451968.09', '0', '0', '4', '6', '2016-04-30', '0', '870783', '499', 'SB/CA/03/2016/P/499'),
('1133', '1', '714', '1', '563', '2016-03-31', '-9646', '0', '0', '0', 'Safa Afrak', '2016-04-30', '1', '870784', '500', 'SB/CA/03/2016/P/500'),
('1134', '1', '715', '1', '564', '2016-04-20', '-643974.05', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '2016-04-30', '0', '870785', '501', 'SB/CA/04/2016/P/501'),
('1135', '1', '716', '1', '565', '2016-04-20', '-140000', '0', '0', '0', 'Cash', '2016-04-30', '1', '870786', '502', 'SB/CA/04/2016/P/502'),
('1136', '1', '717', '1', '566', '2016-04-22', '-5000', '0', '0', '0', 'Gayan Edirisinghe', '2016-04-30', '1', '870787', '503', 'SB/CA/04/2016/P/503');
INSERT INTO `1_bank_trans` VALUES
('1137', '1', '718', '1', '567', '2016-04-27', '-197704.05', '0', '0', '0', 'Dialog Broadband Networks (Pvt) Ltd.', '2016-05-31', '0', '870788', '504', 'SB/CA/04/2016/P/504'),
('1138', '1', '719', '1', '568', '2016-04-28', '-124380', '0', '0', '4', '5', '2016-05-31', '0', '870789', '505', 'SB/CA/04/2016/P/505'),
('1139', '1', '720', '1', '569', '2016-04-28', '-829200', '0', '0', '4', '4', '2016-05-31', '0', '870790', '506', 'SB/CA/04/2016/P/506'),
('1140', '12', '74', '7', '74', '2015-04-28', '0', '0', '0', '2', '2', NULL, '0', '0', '144', 'ET/GBP/04/2016/D/144'),
('1141', '12', '75', '7', '75', '2015-05-25', '0', '0', '0', '2', '2', NULL, '0', '0', '145', 'ET/GBP/04/2016/D/145'),
('1142', '12', '76', '7', '76', '2015-06-25', '0', '0', '0', '2', '2', NULL, '0', '0', '146', 'ET/GBP/04/2016/D/146'),
('1143', '12', '77', '7', '77', '2015-07-27', '0', '0', '0', '2', '2', NULL, '0', '0', '147', 'ET/GBP/04/2016/D/147'),
('1144', '12', '78', '7', '78', '2015-08-26', '0', '0', '0', '2', '2', NULL, '0', '0', '148', 'ET/GBP/04/2016/D/148'),
('1145', '12', '79', '7', '79', '2015-09-28', '0', '0', '0', '2', '2', NULL, '0', '0', '149', 'ET/GBP/04/2016/D/149'),
('1146', '12', '80', '7', '80', '2015-10-28', '0', '0', '0', '2', '2', NULL, '0', '0', '150', 'ET/GBP/04/2016/D/150'),
('1147', '12', '81', '7', '81', '2015-11-26', '0', '0', '0', '2', '2', NULL, '0', '0', '151', 'ET/GBP/04/2016/D/151'),
('1148', '12', '82', '7', '82', '2015-12-23', '0', '0', '0', '2', '2', NULL, '0', '0', '152', 'ET/GBP/04/2016/D/152'),
('1149', '12', '83', '7', '83', '2016-01-27', '0', '0', '0', '2', '2', NULL, '0', '0', '153', 'ET/GBP/04/2016/D/153'),
('1150', '12', '84', '7', '84', '2016-03-01', '0', '0', '0', '2', '2', NULL, '0', '0', '154', 'ET/GBP/04/2016/D/154'),
('1151', '12', '85', '7', '85', '2016-03-28', '0', '0', '0', '2', '2', NULL, '0', '0', '155', 'ET/GBP/04/2016/D/155'),
('1152', '1', '721', '1', '570', '2016-04-29', '-200000', '0', '0', '0', 'K.P.L. Pintoe', '2016-04-30', '1', '870791', '507', 'SB/CA/04/2016/P/507'),
('1153', '1', '722', '1', '571', '2016-05-04', '-3600', '0', '0', '0', 'Iheshan Musafer', '2016-05-31', '1', '870792', '508', 'SB/CA/05/2016/P/508'),
('1154', '1', '723', '1', '572', '2016-05-05', '-95000', '0', '0', '0', 'SINGER ( SRILANKA ) PLC', '2016-05-31', '0', '870793', '509', 'SB/CA/05/2016/P/509'),
('1155', '1', '724', '1', '573', '2016-05-09', '0', '0', '0', '0', 'Cash', NULL, '1', '870794', '510', 'SB/CA/05/2016/P/510'),
('1156', '1', '725', '1', '424', '2015-06-10', '-210663.05', '0', '0', '0', 'Chanaka Padmaperuma', '2015-06-30', '0', '554591', '511', 'SB/CA/05/2016/P/511'),
('1157', '1', '726', '1', '574', '2016-05-11', '-10000', '0', '0', '0', 'Uddeshika Jayawardhana', '2016-05-31', '1', '870795', '512', 'SB/CA/05/2016/P/512'),
('1158', '1', '727', '1', '575', '2016-05-18', '-4350', '0', '0', '0', 'Gayan Edirisinghe', '2016-05-31', '1', '870796', '513', 'SB/CA/05/2016/P/513'),
('1159', '1', '728', '1', '576', '2016-05-18', '-140000', '0', '0', '0', 'Cash', '2016-05-31', '1', '870797', '514', 'SB/CA/05/2016/P/514'),
('1160', '1', '729', '1', '577', '2016-05-19', '-147501', '0', '0', '4', '6', '2016-05-31', '0', '870798', '515', 'SB/CA/05/2016/P/515'),
('1161', '1', '730', '1', '578', '2016-05-23', '-629463.35', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '2016-05-31', '0', '870799', '516', 'SB/CA/05/2016/P/516'),
('1162', '2', '144', '1', '132', '2016-05-27', '18185.87', '0', '0', '0', 'Ceylinco General Insuarance ltd', '2016-05-31', '0', '0', '130', 'SB/CA/05/2016/D/130'),
('1163', '1', '731', '1', '579', '2016-05-30', '-124230', '0', '0', '4', '5', '2016-06-30', '0', '870800', '517', 'SB/CA/05/2016/P/517'),
('1164', '1', '732', '1', '580', '2016-05-30', '-828200', '0', '0', '4', '4', '2016-06-30', '0', '910101', '518', 'SB/CA/05/2016/P/518'),
('1165', '1', '733', '1', '581', '2016-05-31', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', NULL, '0', '910102', '519', 'SB/CA/05/2016/P/519'),
('1166', '1', '733', '5', '581', '2016-05-31', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', NULL, '0', '910102', '519', 'SB/CA/05/2016/P/519'),
('1167', '1', '734', '1', '581', '2016-05-31', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', NULL, '0', '910102', '520', 'SB/CA/05/2016/P/520'),
('1168', '1', '734', '1', '581', '2016-05-31', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', NULL, '0', '910102', '520', 'SB/CA/05/2016/P/520'),
('1169', '1', '735', '1', '581', '2016-05-31', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', NULL, '0', '910102', '521', 'SB/CA/05/2016/P/521'),
('1170', '1', '735', '7', '581', '2016-05-31', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', NULL, '0', '910102', '521', 'SB/CA/05/2016/P/521'),
('1171', '1', '736', '1', '581', '2016-06-07', '-200000', '0', '0', '0', 'Ceymplon (Pvt) Ltd', '2016-06-30', '0', '910103', '522', 'SB/CA/06/2016/P/522'),
('1172', '1', '737', '1', '582', '2016-06-07', '-137500', '0', '0', '0', 'Cash', '2016-06-30', '1', '910104', '523', 'SB/CA/06/2016/P/523'),
('1173', '1', '738', '1', '573', '2016-05-09', '0', '0', '0', '0', 'Cash', NULL, '1', '870794', '524', 'SB/CA/06/2016/P/524'),
('1174', '1', '739', '1', '573', '2016-05-09', '0', '0', '0', '0', 'Cash', NULL, '1', '870794', '525', 'SB/CA/06/2016/P/525'),
('1175', '1', '739', '5', '573', '2016-05-09', '0', '0', '0', '0', 'Cash', NULL, '1', '870794', '525', 'SB/CA/06/2016/P/525'),
('1176', '1', '740', '1', '573', '2016-05-09', '-276500', '0', '0', '0', 'Cash', '2016-05-31', '1', '870794', '526', 'SB/CA/06/2016/P/526'),
('1177', '1', '740', '7', '573', '2016-05-09', '443.55', '0', '0', '0', 'Cash', NULL, '1', '870794', '526', 'SB/CA/06/2016/P/526'),
('1178', '1', '741', '1', '583', '2016-06-09', '-243000', '0', '0', '0', 'Tech Information Solution (PVT) Ltd', '2016-06-30', '0', '910105', '527', 'SB/CA/06/2016/P/527'),
('1179', '1', '742', '1', '584', '2016-06-13', '-181636.1', '0', '0', '4', '6', '2016-06-30', '0', '910106', '528', 'SB/CA/06/2016/P/528'),
('1180', '4', '1', '1', '79', '2016-05-31', '0', '0', '0', '0', 'From Sampath Bank - Current Account To Evolve Technologies (Pvt) Ltd.', NULL, '0', '0', '0', ''),
('1181', '4', '1', '5', '79', '2016-05-31', '0', '0', '0', '0', 'From Sampath Bank - Current Account To Evolve Technologies (Pvt) Ltd.', NULL, '0', '0', '0', ''),
('1182', '1', '743', '1', '585', '2016-05-31', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', NULL, '0', '910102', '529', 'SB/CA/06/2016/P/529'),
('1183', '1', '743', '5', '585', '2016-05-31', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', NULL, '0', '910102', '529', 'SB/CA/06/2016/P/529'),
('1184', '1', '744', '1', '585', '2016-05-31', '-2600000', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '2016-05-31', '0', '910101', '530', 'SB/CA/06/2016/P/530'),
('1185', '1', '744', '7', '585', '2016-05-31', '13179.91', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', NULL, '0', '910101', '530', 'SB/CA/06/2016/P/530'),
('1186', '1', '745', '1', '585', '2016-06-17', '-10000', '0', '0', '0', 'Prasanna Vivek', '2016-07-31', '1', '910107', '531', 'SB/CA/06/2016/P/531'),
('1187', '1', '746', '1', '586', '2016-06-17', '-140000', '0', '0', '0', 'Cash', '2016-07-31', '1', '910108', '532', 'SB/CA/06/2016/P/532'),
('1188', '1', '747', '1', '587', '2016-06-21', '-695769.75', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '2016-06-30', '0', '910109', '533', 'SB/CA/06/2016/P/533'),
('1189', '1', '748', '1', '588', '2016-06-24', '-429785.55', '0', '0', '0', 'Dialog Broadband Networks (Pvt) Ltd', '2016-06-30', '0', '910110', '534', 'SB/CA/06/2016/P/534'),
('1190', '1', '749', '1', '589', '2016-06-24', '-171225.34', '0', '0', '0', 'Tata Communications Lanka Ltd', '2016-06-30', '0', '910111', '535', 'SB/CA/06/2016/P/535'),
('1191', '1', '750', '1', '590', '2016-04-27', '-4573014.66', '0', '0', '0', 'Staff Salaries &amp; Wages', '2016-04-30', '0', '0', '536', 'SB/CA/06/2016/P/536'),
('1192', '1', '751', '1', '591', '2016-04-27', '-750', '0', '0', '0', 'Salary Commission', '2016-04-30', '0', '0', '537', 'SB/CA/06/2016/P/537'),
('1193', '1', '752', '1', '592', '2016-05-27', '-750', '0', '0', '0', 'Salary Commission', '2016-05-31', '0', '0', '538', 'SB/CA/06/2016/P/538'),
('1194', '1', '753', '1', '593', '2016-05-27', '-4856567.59', '0', '0', '0', 'Staff Salaries &amp; Wages', '2016-05-31', '0', '0', '539', 'SB/CA/06/2016/P/539'),
('1195', '1', '754', '1', '594', '2016-05-20', '-500', '0', '0', '0', 'Bank Charges', '2016-05-31', '0', '0', '540', 'SB/CA/06/2016/P/540'),
('1196', '2', '145', '1', '133', '2016-04-20', '400000', '0', '0', '0', 'Involve 360 (pvt) Ltd', '2016-04-30', '0', '0', '131', 'SB/CA/06/2016/D/131'),
('1197', '2', '145', '7', '133', '2016-04-20', '-2027.68', '0', '0', '0', 'Involve 360 (pvt) Ltd', NULL, '0', '0', '131', 'SB/CA/06/2016/D/131'),
('1198', '1', '755', '1', '595', '2016-06-29', '-131880', '0', '0', '4', '5', '2016-07-31', '0', '910112', '541', 'SB/CA/06/2016/P/541'),
('1199', '1', '756', '1', '596', '2016-06-29', '-879200', '0', '0', '4', '4', '2016-07-31', '0', '910113', '542', 'SB/CA/06/2016/P/542'),
('1200', '1', '757', '1', '597', '2016-06-29', '-500000', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '2016-06-30', '0', '910114', '543', 'SB/CA/06/2016/P/543'),
('1201', '1', '757', '7', '597', '2016-06-29', '2534.6', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', NULL, '0', '910114', '543', 'SB/CA/06/2016/P/543'),
('1202', '1', '758', '1', '598', '2016-06-29', '-10000', '0', '0', '0', 'Safa Afrak', '2016-07-31', '1', '910115', '544', 'SB/CA/06/2016/P/544'),
('1203', '12', '86', '7', '86', '2016-04-26', '0', '0', '0', '2', '2', NULL, '0', '0', '156', 'ET/GBP/06/2016/D/156'),
('1204', '12', '87', '1', '87', '2016-04-26', '0', '0', '0', '2', '1', NULL, '0', '0', '132', 'SB/CA/06/2016/D/132'),
('1205', '12', '88', '8', '87/1', '2016-04-26', '0', '0', '0', '2', '2', NULL, '0', '0', '1', '/07/2016/D/1'),
('1206', '12', '89', '8', '88', '2016-04-26', '0', '0', '0', '2', '2', NULL, '0', '0', '1', '/07/2016/D/1'),
('1207', '12', '90', '8', '89', '2016-04-26', '35943', '0', '0', '2', '2', NULL, '0', '0', '1', '/07/2016/D/1'),
('1208', '4', '2', '8', '79', '2016-04-26', '-35943', '0', '0', '0', 'From Sampath Bank - GBP Account To Sampath Bank - Current Account', NULL, '0', '0', '0', ''),
('1209', '4', '2', '1', '79', '2016-04-26', '7530058.5', '0', '0', '0', 'From Sampath Bank - GBP Account To Sampath Bank - Current Account', '2016-04-30', '0', '0', '0', ''),
('1210', '1', '759', '1', '599', '2016-04-26', '-575', '0', '0', '0', 'Bank charges', '2016-04-30', '0', '554592', '545', 'SB/CA/07/2016/P/545'),
('1211', '1', '760', '1', '600', '2015-04-27', '-3132381.1', '0', '0', '0', 'Staff Salaries &amp; Wages', '2015-04-30', '0', '0', '546', 'SB/CA/07/2016/P/546'),
('1212', '1', '761', '1', '601', '2015-04-27', '-750', '0', '0', '0', 'Salary Commission', '2015-04-30', '0', '0', '547', 'SB/CA/07/2016/P/547'),
('1213', '1', '762', '1', '602', '2015-04-30', '-600', '0', '0', '0', 'Overdraft Interest', '2015-04-30', '0', '0', '548', 'SB/CA/07/2016/P/548'),
('1214', '2', '146', '1', '134', '2015-04-10', '200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '2015-04-30', '0', '0', '132', 'SB/CA/07/2016/D/132'),
('1215', '2', '146', '7', '134', '2015-04-10', '-1013.84', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', NULL, '0', '0', '132', 'SB/CA/07/2016/D/132'),
('1216', '2', '147', '1', '135', '2015-04-27', '3200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '2015-04-30', '0', '0', '133', 'SB/CA/07/2016/D/133'),
('1217', '2', '147', '7', '135', '2015-04-27', '-16221.42', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', NULL, '0', '0', '133', 'SB/CA/07/2016/D/133'),
('1218', '2', '148', '1', '136', '2015-04-30', '900000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '2015-04-30', '0', '0', '134', 'SB/CA/07/2016/D/134'),
('1219', '2', '148', '7', '136', '2015-04-30', '-4562.28', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', NULL, '0', '0', '134', 'SB/CA/07/2016/D/134'),
('1220', '1', '763', '1', '603', '2015-05-28', '-3679647.41', '0', '0', '0', 'Staff Salaries &amp; Wages', '2015-05-31', '0', '0', '549', 'SB/CA/07/2016/P/549'),
('1221', '1', '764', '1', '604', '2015-05-28', '-750', '0', '0', '0', 'Salary Commission', '2015-05-31', '0', '0', '550', 'SB/CA/07/2016/P/550'),
('1222', '2', '149', '1', '137', '2015-05-15', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '2015-05-31', '0', '0', '135', 'SB/CA/07/2016/D/135'),
('1223', '2', '149', '7', '137', '2015-05-15', '-2534.6', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', NULL, '0', '0', '135', 'SB/CA/07/2016/D/135'),
('1224', '2', '150', '1', '138', '2015-05-28', '4500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '2015-05-31', '0', '0', '136', 'SB/CA/07/2016/D/136'),
('1225', '2', '150', '7', '138', '2015-05-28', '-22811.38', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', NULL, '0', '0', '136', 'SB/CA/07/2016/D/136'),
('1226', '1', '765', '1', '605', '2015-06-29', '-3527216.7', '0', '0', '0', 'Staff Salaries &amp; Wages', '2015-06-30', '0', '0', '551', 'SB/CA/07/2016/P/551'),
('1227', '1', '766', '1', '606', '2015-06-29', '-750', '0', '0', '0', 'Salary Commission', '2015-06-30', '0', '0', '552', 'SB/CA/07/2016/P/552'),
('1228', '2', '151', '1', '139', '2015-06-15', '600000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-06-30', '0', '0', '137', 'SB/CA/07/2016/D/137'),
('1229', '2', '151', '7', '139', '2015-06-15', '-3041.52', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '137', 'SB/CA/07/2016/D/137'),
('1230', '2', '152', '1', '140', '2015-06-19', '150000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-06-30', '0', '0', '138', 'SB/CA/07/2016/D/138'),
('1231', '2', '152', '7', '140', '2015-06-19', '-760.38', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '138', 'SB/CA/07/2016/D/138'),
('1232', '2', '153', '1', '141', '2015-06-29', '4300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-06-30', '0', '0', '139', 'SB/CA/07/2016/D/139'),
('1233', '2', '153', '7', '141', '2015-06-29', '-21797.54', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '139', 'SB/CA/07/2016/D/139'),
('1234', '1', '767', '1', '607', '2015-06-17', '-500', '0', '0', '0', 'Bank Charges', '2015-06-30', '0', '0', '553', 'SB/CA/07/2016/P/553'),
('1235', '1', '768', '1', '608', '2015-07-28', '-3459224.6', '0', '0', '0', 'Staff Salaries &amp; Wages', '2015-07-31', '0', '0', '554', 'SB/CA/07/2016/P/554'),
('1236', '1', '769', '1', '609', '2015-07-28', '-750', '0', '0', '0', 'Salary Commission', '2015-07-31', '0', '0', '555', 'SB/CA/07/2016/P/555'),
('1237', '2', '154', '1', '142', '2015-07-10', '600000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-07-31', '0', '0', '140', 'SB/CA/07/2016/D/140'),
('1238', '2', '154', '7', '142', '2015-07-10', '-3041.52', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '140', 'SB/CA/07/2016/D/140'),
('1239', '2', '155', '1', '143', '2015-07-28', '4300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-07-31', '0', '0', '141', 'SB/CA/07/2016/D/141'),
('1240', '2', '155', '7', '143', '2015-07-28', '-21797.54', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '141', 'SB/CA/07/2016/D/141'),
('1241', '1', '770', '1', '610', '2015-08-03', '-500', '0', '0', '0', 'Bank Charges', '2015-08-31', '0', '0', '556', 'SB/CA/07/2016/P/556'),
('1242', '1', '771', '1', '611', '2015-08-04', '-50', '0', '0', '0', 'Bank Charges', '2015-08-31', '0', '0', '557', 'SB/CA/07/2016/P/557'),
('1243', '1', '772', '1', '612', '2015-08-04', '-115', '0', '0', '0', 'Bank Charges', '2015-08-31', '0', '0', '558', 'SB/CA/07/2016/P/558'),
('1244', '1', '773', '1', '613', '2015-08-27', '-3699062', '0', '0', '0', 'Staff Salaries &amp; Wages', '2015-08-31', '0', '0', '559', 'SB/CA/07/2016/P/559'),
('1245', '1', '774', '1', '614', '2015-08-27', '-750', '0', '0', '0', 'Salary Commission', '2015-08-31', '0', '0', '560', 'SB/CA/07/2016/P/560'),
('1246', '2', '156', '1', '144', '2015-08-03', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-08-31', '0', '0', '142', 'SB/CA/07/2016/D/142'),
('1247', '2', '156', '7', '144', '2015-08-03', '-2534.6', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '142', 'SB/CA/07/2016/D/142'),
('1248', '2', '157', '1', '145', '2015-08-20', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-08-31', '0', '0', '143', 'SB/CA/07/2016/D/143'),
('1249', '2', '157', '7', '145', '2015-08-20', '-2534.6', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '143', 'SB/CA/07/2016/D/143'),
('1250', '2', '158', '1', '146', '2015-08-27', '4300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-08-31', '0', '0', '144', 'SB/CA/07/2016/D/144'),
('1251', '2', '158', '7', '146', '2015-08-27', '-21797.54', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '144', 'SB/CA/07/2016/D/144'),
('1252', '2', '159', '1', '147', '2015-08-31', '200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-08-31', '0', '0', '145', 'SB/CA/07/2016/D/145'),
('1253', '2', '159', '7', '147', '2015-08-31', '-1013.84', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '145', 'SB/CA/07/2016/D/145'),
('1254', '2', '160', '1', '148', '2015-09-10', '200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-09-30', '0', '0', '146', 'SB/CA/07/2016/D/146'),
('1255', '2', '160', '7', '148', '2015-09-10', '-1013.84', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '146', 'SB/CA/07/2016/D/146'),
('1256', '2', '161', '1', '149', '2015-09-23', '700000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-09-30', '0', '0', '147', 'SB/CA/07/2016/D/147'),
('1257', '2', '161', '7', '149', '2015-09-23', '-3548.44', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '147', 'SB/CA/07/2016/D/147'),
('1258', '2', '162', '1', '150', '2015-09-28', '4600000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-09-30', '0', '0', '148', 'SB/CA/07/2016/D/148'),
('1259', '2', '162', '7', '150', '2015-09-28', '-23318.29', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '148', 'SB/CA/07/2016/D/148'),
('1260', '1', '775', '1', '615', '2015-09-28', '-3951061.2', '0', '0', '0', 'Staff Salaries &amp; Wages', '2015-09-30', '0', '0', '561', 'SB/CA/07/2016/P/561'),
('1261', '1', '776', '1', '616', '2015-09-28', '-750', '0', '0', '0', 'Salary Commission', '2015-09-30', '0', '0', '562', 'SB/CA/07/2016/P/562'),
('1262', '1', '777', '1', '617', '2015-11-30', '-3895200.66', '0', '0', '0', 'Staff Salaries &amp; Wages', '2015-11-30', '0', '0', '563', 'SB/CA/07/2016/P/563'),
('1263', '1', '778', '1', '618', '2015-11-30', '-750', '0', '0', '0', 'Salary Commission', '2015-11-30', '0', '0', '564', 'SB/CA/07/2016/P/564'),
('1264', '1', '779', '1', '619', '2015-11-30', '-600', '0', '0', '0', 'Bank Charges', '2015-11-30', '0', '0', '565', 'SB/CA/07/2016/P/565'),
('1265', '2', '163', '1', '151', '2015-11-06', '1300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-11-30', '0', '0', '149', 'SB/CA/07/2016/D/149'),
('1266', '2', '163', '7', '151', '2015-11-06', '-6589.95', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '149', 'SB/CA/07/2016/D/149'),
('1267', '2', '164', '1', '152', '2015-11-11', '300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-11-30', '0', '0', '150', 'SB/CA/07/2016/D/150'),
('1268', '2', '164', '7', '152', '2015-11-11', '-1520.76', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '150', 'SB/CA/07/2016/D/150'),
('1269', '2', '165', '1', '153', '2015-11-24', '1500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-11-30', '0', '0', '151', 'SB/CA/07/2016/D/151'),
('1270', '2', '165', '7', '153', '2015-11-24', '-7603.79', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '151', 'SB/CA/07/2016/D/151'),
('1271', '2', '166', '1', '154', '2015-11-30', '4800000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-11-30', '0', '0', '152', 'SB/CA/07/2016/D/152'),
('1272', '2', '166', '7', '154', '2015-11-30', '-24332.13', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '152', 'SB/CA/07/2016/D/152'),
('1273', '2', '167', '1', '155', '2015-12-04', '1000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-12-31', '0', '0', '153', 'SB/CA/07/2016/D/153'),
('1274', '2', '167', '7', '155', '2015-12-04', '-5069.19', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '153', 'SB/CA/07/2016/D/153'),
('1275', '2', '168', '1', '156', '2015-12-22', '5000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-12-31', '0', '0', '154', 'SB/CA/07/2016/D/154'),
('1276', '2', '168', '7', '156', '2015-12-22', '-25345.97', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '154', 'SB/CA/07/2016/D/154'),
('1277', '1', '780', '1', '620', '2015-12-22', '-4366764.46', '0', '0', '0', 'Staff Salaries &amp; Wages', '2015-12-31', '0', '0', '566', 'SB/CA/07/2016/P/566'),
('1278', '1', '781', '1', '621', '2015-12-22', '-750', '0', '0', '0', 'Salary Commission', '2015-12-31', '0', '0', '567', 'SB/CA/07/2016/P/567'),
('1279', '1', '782', '1', '622', '2015-12-17', '-500', '0', '0', '0', 'Bank Charges', '2015-12-31', '0', '0', '568', 'SB/CA/07/2016/P/568'),
('1280', '1', '783', '1', '623', '2016-01-20', '-500', '0', '0', '0', 'Bank Charges', '2016-01-31', '0', '0', '569', 'SB/CA/07/2016/P/569'),
('1281', '1', '784', '1', '624', '2016-01-27', '-4560767.7', '0', '0', '0', 'Staff Salaries &amp; Wages', '2016-01-31', '0', '0', '570', 'SB/CA/07/2016/P/570'),
('1282', '1', '785', '1', '625', '2016-01-27', '-750', '0', '0', '0', 'Salary Commission', '2016-01-31', '0', '0', '571', 'SB/CA/07/2016/P/571'),
('1283', '2', '169', '1', '157', '2016-01-27', '0', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '155', 'SB/CA/07/2016/D/155'),
('1284', '2', '169', '7', '157', '2016-01-27', '0', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '155', 'SB/CA/07/2016/D/155'),
('1285', '2', '170', '1', '157', '2016-01-18', '150000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2016-01-31', '0', '0', '156', 'SB/CA/07/2016/D/156'),
('1286', '2', '170', '7', '157', '2016-01-18', '-760.38', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '156', 'SB/CA/07/2016/D/156'),
('1287', '2', '171', '1', '157', '2016-01-27', '4600000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2016-01-31', '0', '0', '157', 'SB/CA/07/2016/D/157'),
('1288', '2', '171', '7', '157', '2016-01-27', '-23318.29', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '157', 'SB/CA/07/2016/D/157'),
('1289', '2', '172', '1', '158', '2016-01-28', '2500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2016-01-31', '0', '0', '158', 'SB/CA/07/2016/D/158'),
('1290', '2', '172', '7', '158', '2016-01-28', '-12672.99', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '158', 'SB/CA/07/2016/D/158'),
('1291', '1', '786', '1', '626', '2016-01-18', '-3000', '0', '0', '0', 'Sampath - Vishwa', '2016-01-31', '0', '0', '572', 'SB/CA/07/2016/P/572'),
('1292', '2', '173', '1', '159', '2016-02-16', '100000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2016-02-29', '0', '0', '159', 'SB/CA/07/2016/D/159'),
('1293', '2', '173', '7', '159', '2016-02-16', '-506.92', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '159', 'SB/CA/07/2016/D/159'),
('1294', '1', '787', '1', '627', '2016-03-01', '-4476894.36', '0', '0', '0', 'Staff Salaries &amp; Wages', '2016-03-31', '0', '0', '573', 'SB/CA/07/2016/P/573'),
('1295', '1', '788', '1', '628', '2016-03-01', '-750', '0', '0', '0', 'Salary Commission', '2016-03-31', '0', '0', '574', 'SB/CA/07/2016/P/574'),
('1296', '1', '789', '1', '629', '2016-03-29', '-4227163.55', '0', '0', '0', 'Staff Salaries &amp; Wages', '2016-03-31', '0', '0', '575', 'SB/CA/07/2016/P/575'),
('1297', '1', '790', '1', '630', '2016-03-29', '-750', '0', '0', '0', 'Salary Commission', '2016-03-31', '0', '0', '576', 'SB/CA/07/2016/P/576'),
('1298', '2', '174', '1', '160', '2016-03-01', '6000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2016-03-31', '0', '0', '160', 'SB/CA/07/2016/D/160'),
('1299', '2', '174', '7', '160', '2016-03-01', '-30415.17', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '160', 'SB/CA/07/2016/D/160'),
('1300', '2', '175', '1', '161', '2016-03-03', '300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2016-03-31', '0', '0', '161', 'SB/CA/07/2016/D/161'),
('1301', '2', '175', '7', '161', '2016-03-03', '-1520.76', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '161', 'SB/CA/07/2016/D/161'),
('1302', '2', '176', '1', '162', '2016-03-09', '300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2016-03-31', '0', '0', '162', 'SB/CA/07/2016/D/162'),
('1303', '2', '176', '7', '162', '2016-03-09', '-1520.76', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '162', 'SB/CA/07/2016/D/162'),
('1304', '2', '177', '1', '163', '2016-03-14', '300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2016-03-31', '0', '0', '163', 'SB/CA/07/2016/D/163'),
('1305', '2', '177', '7', '163', '2016-03-14', '-1520.76', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '163', 'SB/CA/07/2016/D/163'),
('1306', '2', '178', '1', '164', '2016-03-25', '750000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2016-03-31', '0', '0', '164', 'SB/CA/07/2016/D/164'),
('1307', '2', '178', '7', '164', '2016-03-25', '-3801.9', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '164', 'SB/CA/07/2016/D/164'),
('1308', '2', '179', '1', '165', '2016-03-29', '5500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2016-03-31', '0', '0', '165', 'SB/CA/07/2016/D/165'),
('1309', '2', '179', '7', '165', '2016-03-29', '-27880.57', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '165', 'SB/CA/07/2016/D/165'),
('1310', '2', '180', '1', '166', '2016-03-31', '1500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2016-03-31', '0', '0', '166', 'SB/CA/07/2016/D/166'),
('1311', '2', '180', '7', '166', '2016-03-31', '-7603.79', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '166', 'SB/CA/07/2016/D/166'),
('1312', '1', '791', '1', '631', '2015-10-28', '-3585535', '0', '0', '0', 'Staff Salaries &amp; Wages', '2015-10-31', '0', '0', '577', 'SB/CA/07/2016/P/577'),
('1313', '1', '792', '1', '632', '2015-10-28', '-750', '0', '0', '0', 'Salary Commission', '2015-10-31', '0', '0', '578', 'SB/CA/07/2016/P/578'),
('1314', '2', '181', '1', '167', '2015-10-01', '150000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-10-31', '0', '0', '167', 'SB/CA/07/2016/D/167'),
('1315', '2', '181', '7', '167', '2015-10-01', '-760.38', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '167', 'SB/CA/07/2016/D/167'),
('1316', '2', '182', '1', '168', '2015-10-05', '200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-10-31', '0', '0', '168', 'SB/CA/07/2016/D/168'),
('1317', '2', '182', '7', '168', '2015-10-05', '-1013.84', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '168', 'SB/CA/07/2016/D/168'),
('1318', '2', '183', '1', '169', '2015-10-13', '700000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-10-31', '0', '0', '169', 'SB/CA/07/2016/D/169'),
('1319', '2', '183', '7', '169', '2015-10-13', '-3548.44', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '169', 'SB/CA/07/2016/D/169'),
('1320', '2', '184', '1', '170', '2015-10-15', '150000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-10-31', '0', '0', '170', 'SB/CA/07/2016/D/170'),
('1321', '2', '184', '7', '170', '2015-10-15', '-760.38', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '170', 'SB/CA/07/2016/D/170'),
('1322', '2', '185', '1', '171', '2015-10-28', '4800000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2015-10-31', '0', '0', '171', 'SB/CA/07/2016/D/171'),
('1323', '2', '185', '7', '171', '2015-10-28', '-24332.13', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '171', 'SB/CA/07/2016/D/171'),
('1324', '2', '186', '1', '172', '2016-03-09', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '172', 'SB/CA/07/2016/D/172'),
('1325', '2', '186', '7', '172', '2016-03-09', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', NULL, '0', '0', '172', 'SB/CA/07/2016/D/172'),
('1326', '4', '3', '7', '80', '2016-05-27', '0', '0', '0', '0', 'From Evolve Technologies (Pvt)Ltd. To Sampath Bank - Current Account', NULL, '0', '0', '0', ''),
('1327', '4', '3', '1', '80', '2016-05-27', '0', '0', '0', '0', 'From Evolve Technologies (Pvt)Ltd. To Sampath Bank - Current Account', NULL, '0', '0', '0', ''),
('1328', '4', '4', '7', '80', '2016-05-27', '-40165', '0', '0', '0', 'From Evolve Technologies (Pvt)Ltd. To Sampath Bank - Current Account', NULL, '0', '0', '0', ''),
('1329', '4', '4', '1', '80', '2016-05-27', '8635475', '0', '0', '0', 'From Evolve Technologies (Pvt)Ltd. To Sampath Bank - Current Account', '2016-05-31', '0', '0', '0', ''),
('1330', '1', '793', '1', '633', '2016-05-27', '-575', '0', '0', '0', 'Bank Charges', '2016-05-31', '0', '0', '579', 'SB/CA/07/2016/P/579'),
('1331', '1', '794', '1', '634', '2016-07-14', '-140000', '0', '0', '0', 'Cash', '2016-07-31', '1', '910116', '580', 'SB/CA/07/2016/P/580'),
('1332', '1', '795', '1', '635', '2016-07-14', '-10000', '0', '0', '0', 'Jeewani Kokila Perera', '2016-07-31', '1', '910117', '581', 'SB/CA/07/2016/P/581'),
('1333', '1', '796', '1', '636', '2016-07-14', '-101250', '0', '0', '0', 'Tech Information Solution (PVT) Ltd', '2016-07-31', '0', '910118', '582', 'SB/CA/07/2016/P/582'),
('1334', '2', '187', '1', '172', '2016-03-09', '0', '0', '0', '0', 'Schockman &amp; Samarawickrema (Pvt) Ltd', '2016-03-31', '0', '0', '173', 'SB/CA/07/2016/D/173'),
('1335', '1', '797', '1', '637', '2016-07-14', '-181149', '0', '0', '4', '6', '2016-07-31', '0', '910119', '583', 'SB/CA/07/2016/P/583'),
('1336', '1', '798', '1', '638', '2016-07-20', '-262000', '0', '0', '0', 'Cash', '2016-07-31', '1', '910120', '584', 'SB/CA/07/2016/P/584'),
('1337', '1', '799', '1', '639', '2016-07-22', '-20000', '0', '0', '0', 'Uddeshika Jayawardhane', '2016-07-31', '1', '910121', '585', 'SB/CA/07/2016/P/585'),
('1338', '1', '800', '1', '640', '2016-07-22', '-701124.75', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '2016-07-31', '0', '910122', '586', 'SB/CA/07/2016/P/586'),
('1339', '1', '801', '1', '641', '2016-07-26', '-7192', '0', '0', '0', 'Amila Palihawadana', '2016-08-31', '1', '910123', '587', 'SB/CA/07/2016/P/587'),
('1340', '2', '188', '1', '131', '2016-01-25', '9965.58', '0', '0', '0', 'Involve 360 (pvt) Ltd', '2016-01-31', '0', '0', '174', 'SB/CA/07/2016/D/174'),
('1341', '1', '802', '1', '503', '2015-09-29', '0', '0', '0', '0', 'Leema Creations (Pvt)Ltd.', NULL, '0', '554593', '588', 'SB/CA/07/2016/P/588'),
('1342', '0', '57', '5', '50', '2016-03-31', '-1800000', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('1343', '1', '803', '1', '642', '2016-07-28', '-141240', '0', '0', '4', '5', '2016-08-31', '0', '910124', '588', 'SB/CA/07/2016/P/588'),
('1344', '1', '804', '1', '643', '2016-07-28', '-941600', '0', '0', '4', '4', '2016-08-31', '0', '910125', '589', 'SB/CA/07/2016/P/589'),
('1345', '1', '805', '1', '644', '2016-08-03', '-230908', '0', '0', '0', 'Dialog Broadband Networks (Pvt) Ltd', '2016-08-31', '0', '910126', '590', 'SB/CA/08/2016/P/590'),
('1346', '1', '806', '1', '645', '2016-08-03', '-171225.34', '0', '0', '0', 'Tata Communications Lanka Ltd', '2016-08-31', '0', '910127', '591', 'SB/CA/08/2016/P/591'),
('1347', '1', '807', '1', '646', '2016-08-03', '-610334', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '2016-08-31', '0', '910128', '592', 'SB/CA/08/2016/P/592'),
('1348', '2', '189', '1', '172', '2016-08-03', '130877.89', '0', '0', '0', 'Schockman &amp; Samarawickrema (Pvt) Ltd', '2016-08-31', '0', '0', '175', 'SB/CA/08/2016/D/175'),
('1349', '1', '808', '1', '647', '2016-08-03', '-130877.89', '0', '0', '0', 'Cash', '2016-08-31', '1', '910129', '593', 'SB/CA/08/2016/P/593'),
('1350', '1', '809', '1', '648', '2016-08-18', '0', '0', '0', '4', '6', NULL, '0', '925092', '594', 'SB/CA/08/2016/P/594'),
('1351', '1', '810', '1', '648', '2016-08-18', '-170867', '0', '0', '4', '6', '2016-08-31', '0', '910130', '595', 'SB/CA/08/2016/P/595'),
('1352', '1', '811', '1', '648', '2016-08-18', '-140000', '0', '0', '0', 'Cash', '2016-08-31', '1', '910131', '596', 'SB/CA/08/2016/P/596'),
('1353', '1', '812', '1', '649', '2016-08-19', '-84915', '0', '0', '0', 'E-guardian Lanka Private Limited ', '2016-09-30', '0', '910132', '597', 'SB/CA/08/2016/P/597'),
('1354', '1', '813', '1', '650', '2016-08-19', '-307500', '0', '0', '0', 'Cash', '2016-08-31', '1', '910133', '598', 'SB/CA/08/2016/P/598'),
('1355', '1', '814', '1', '651', '2016-08-22', '-10000', '0', '0', '0', 'E M Hemal Isuru', '2016-08-31', '1', '910134', '599', 'SB/CA/08/2016/P/599'),
('1356', '1', '815', '1', '652', '2016-08-26', '-664973.85', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '2016-08-31', '0', '910135', '600', 'SB/CA/08/2016/P/600'),
('1357', '1', '816', '1', '653', '2016-08-29', '-985950', '0', '0', '4', '4', '2016-09-30', '0', '910136', '601', 'SB/CA/08/2016/P/601'),
('1358', '1', '817', '1', '654', '2016-08-29', '-147893', '0', '0', '4', '5', '2016-09-30', '0', '910137', '602', 'SB/CA/08/2016/P/602'),
('1359', '1', '818', '1', '655', '2016-09-06', '-403615.76', '0', '0', '0', 'Cash', '2016-09-30', '1', '910138', '603', 'SB/CA/09/2016/P/603'),
('1360', '2', '190', '1', '172', '2016-03-09', '173505.53', '0', '0', '0', 'Schockman &amp; Samarawickrema (Pvt) Ltd', '2016-03-31', '0', '0', '176', 'SB/CA/09/2016/D/176'),
('1361', '1', '819', '1', '554', '2016-03-09', '-173505.53', '0', '0', '0', 'Chanaka Padmaperuma', '2016-03-31', '1', '870774', '604', 'SB/CA/09/2016/P/604'),
('1362', '1', '820', '1', '656', '2016-09-07', '-197609.5', '0', '0', '0', 'Dialog Broadband Networks (Pvt) Ltd', '2016-09-30', '0', '910139', '605', 'SB/CA/09/2016/P/605'),
('1363', '1', '821', '1', '657', '2016-09-07', '-145977.93', '0', '0', '0', 'Tata Communications Lanka Ltd', '2016-09-30', '0', '910140', '606', 'SB/CA/09/2016/P/606'),
('1364', '1', '822', '1', '658', '2016-09-07', '-10000', '0', '0', '0', 'Shiyam Kamal', '2016-09-30', '1', '910141', '607', 'SB/CA/09/2016/P/607'),
('1365', '0', '63', '3', '55', '2016-03-31', '-343400', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('1366', '12', '75', '7', '75', '2015-05-25', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1367', '1', '823', '1', '659', '2016-09-13', '-140000', '0', '0', '0', 'Cash', '2016-09-30', '1', '910142', '608', 'SB/CA/09/2016/P/608'),
('1368', '1', '824', '1', '660', '2016-09-13', '-2562', '0', '0', '0', 'Amila Palihawadana', '2016-09-30', '1', '910143', '609', 'SB/CA/09/2016/P/609'),
('1369', '12', '76', '7', '76', '2015-06-25', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1370', '12', '91', '7', '79.', '2015-06-25', '0', '0', '0', '2', '2', NULL, '0', '0', '172', 'ET/GBP/09/2016/D/172'),
('1371', '12', '92', '7', '87/2', '2015-05-25', '0', '0', '0', '2', '2', NULL, '0', '0', '173', 'ET/GBP/09/2016/D/173'),
('1372', '12', '91', '7', '79.', '2015-06-25', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1373', '12', '77', '7', '77', '2015-07-27', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1374', '12', '78', '7', '78', '2015-08-26', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1375', '12', '79', '7', '79', '2015-09-28', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1376', '12', '80', '7', '80', '2015-10-28', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1377', '12', '80', '7', '80', '2015-10-28', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1378', '12', '81', '7', '81', '2015-11-26', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1379', '12', '82', '7', '82', '2015-12-23', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1380', '12', '83', '7', '83', '2016-01-27', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1381', '12', '84', '7', '84', '2016-03-01', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1382', '12', '85', '7', '85', '2016-03-28', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1383', '0', '65', '7', '57', '2015-04-06', '-27500', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('1384', '0', '66', '7', '58', '2015-09-28', '-101173.81', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('1385', '0', '67', '7', '59', '2015-09-29', '-775000', '0', '0', '0', NULL, NULL, '0', '0', '0', ''),
('1386', '1', '825', '1', '661', '2016-09-19', '-9321', '0', '0', '0', 'Mallcolm Mahesh', '2016-09-30', '1', '910144', '610', 'SB/CA/09/2016/P/610'),
('1387', '1', '826', '1', '662', '2016-09-22', '-787500', '0', '0', '0', 'Cash', '2016-09-30', '1', '910145', '611', 'SB/CA/09/2016/P/611'),
('1388', '1', '827', '1', '663', '2016-09-23', '-171617', '0', '0', '4', '6', '2016-09-30', '0', '910146', '612', 'SB/CA/09/2016/P/612'),
('1389', '1', '828', '1', '664', '2016-09-26', '-657107.15', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd	', '2016-09-30', '0', '910147', '613', 'SB/CA/09/2016/P/613'),
('1390', '1', '829', '1', '665', '2016-09-28', '-15000', '0', '0', '0', 'Hemal Ekanayake', '2016-09-30', '1', '910148', '614', 'SB/CA/09/2016/P/614'),
('1391', '1', '830', '1', '666', '2016-09-28', '-13500', '0', '0', '0', 'Sandun Gamage', NULL, '1', '910149', '615', 'SB/CA/09/2016/P/615'),
('1392', '1', '831', '1', '667', '2016-09-28', '-10000', '0', '0', '0', 'Angela Roncali', '2016-09-30', '1', '910150', '616', 'SB/CA/09/2016/P/616'),
('1393', '1', '832', '1', '668', '2016-09-28', '-55000', '0', '0', '0', 'Mallcolm Mahesh', '2016-09-30', '1', '946201', '617', 'SB/CA/09/2016/P/617'),
('1394', '12', '91', '7', '79.', '2015-06-25', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1395', '12', '77', '7', '77', '2015-07-27', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1396', '12', '74', '7', '74', '2015-04-28', '26926.69', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1397', '12', '92', '7', '87/2', '2015-05-25', '30933.76', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1398', '12', '91', '7', '79.', '2015-06-25', '28266.76', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1399', '12', '77', '7', '77', '2015-07-27', '29110.73', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1400', '12', '78', '7', '78', '2015-08-26', '28209.78', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1401', '12', '79', '7', '79', '2015-09-28', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1402', '12', '79', '7', '79', '2015-09-28', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1403', '12', '80', '7', '80', '2015-10-28', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1404', '12', '81', '7', '81', '2015-11-26', '31174.63', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1405', '12', '82', '7', '82', '2015-12-23', '32631.57', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1406', '12', '83', '7', '83', '2016-01-27', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1407', '12', '83', '7', '83', '2016-01-27', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1408', '12', '84', '7', '84', '2016-03-01', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1409', '12', '84', '7', '84', '2016-03-01', '36846.36', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1410', '12', '85', '7', '85', '2016-03-28', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1411', '12', '80', '7', '80', '2015-10-28', '0', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1412', '12', '85', '7', '85', '2016-03-28', '34309.4', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1413', '12', '79', '7', '79', '2015-09-28', '27740.63', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1414', '12', '80', '7', '80', '2015-10-28', '27867.67', '0', '0', '2', '2', NULL, '0', '0', '0', ''),
('1415', '1', '833', '1', '669', '2016-09-30', '-157043', '0', '0', '4', '5', NULL, '0', '946202', '618', 'SB/CA/09/2016/P/618'),
('1416', '1', '834', '1', '670', '2016-09-30', '-1046950', '0', '0', '4', '4', NULL, '0', '946203', '619', 'SB/CA/09/2016/P/619'),
('1417', '1', '835', '1', '671', '2016-09-30', '-55200', '0', '0', '0', 'Sanka Liyanage', '2016-09-30', '1', '946204', '620', 'SB/CA/09/2016/P/620'),
('1418', '12', '93', '7', '144/1', '2016-01-27', '20068.45', '0', '0', '2', '2', NULL, '0', '0', '172', 'ET/GBP/10/2016/D/172'),
('1419', '1', '836', '1', '672', '2016-10-03', '-19650', '0', '0', '0', 'Fire Shelter Associate', NULL, '0', '946205', '621', 'SB/CA/10/2016/P/621'),
('1420', '1', '837', '1', '673', '2016-10-04', '-402000', '0', '0', '0', 'Cash', NULL, '1', '946206', '622', 'SB/CA/10/2016/P/622'),
('1421', '1', '838', '1', '674', '2016-10-04', '-9250', '0', '0', '0', 'Lahiru Sampath', NULL, '1', '946207', '623', 'SB/CA/10/2016/P/623'),
('1422', '1', '839', '1', '675', '2016-10-05', '-197702.5', '0', '0', '0', 'Dialog Broadband Networks (Pvt) Ltd	', NULL, '0', '946208', '624', 'SB/CA/10/2016/P/624'),
('1423', '1', '840', '1', '676', '2016-10-05', '-145977.93', '0', '0', '0', 'Tata Communications Lanka Ltd	', NULL, '0', '946209', '625', 'SB/CA/10/2016/P/625');

### Structure of table `1_bom` ###

DROP TABLE IF EXISTS `1_bom`;

CREATE TABLE `1_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `component` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_bom` ###


### Structure of table `1_budget_trans` ###

DROP TABLE IF EXISTS `1_budget_trans`;

CREATE TABLE `1_budget_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT '0',
  `type_no` bigint(16) NOT NULL DEFAULT '1',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `amount` double NOT NULL DEFAULT '0',
  `dimension_id` int(11) DEFAULT '0',
  `dimension2_id` int(11) DEFAULT '0',
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_budget_trans` ###


### Structure of table `1_chart_class` ###

DROP TABLE IF EXISTS `1_chart_class`;

CREATE TABLE `1_chart_class` (
  `cid` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `class_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_chart_class` ###

INSERT INTO `1_chart_class` VALUES
('1', 'Assets', '1', '0'),
('2', 'Liabilities', '2', '0'),
('3', 'Income', '4', '0'),
('4', 'Costs', '6', '0');

### Structure of table `1_chart_master` ###

DROP TABLE IF EXISTS `1_chart_master`;

CREATE TABLE `1_chart_master` (
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_code2` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_chart_master` ###

INSERT INTO `1_chart_master` VALUES
('1060', '', 'Checking Account', '1', '0'),
('1065', '', 'Petty Cash', '1', '0'),
('1200', '', 'Accounts Receivables', '1', '0'),
('1205', '', 'Allowance for doubtful accounts', '1', '0'),
('1510', '', 'Inventory', '2', '0'),
('1520', '', 'Stocks of Raw Materials', '2', '0'),
('1530', '', 'Stocks of Work In Progress', '2', '0'),
('1540', '', 'Stocks of Finsihed Goods', '2', '0'),
('1550', '', 'Goods Received Clearing account', '2', '0'),
('1820', '', 'Computer &amp; Equipment', '3', '0'),
('1825', '', 'Acc. Depreciation  - Computer  Equip.', '3', '0'),
('1840', '', 'Vehicles', '3', '0'),
('1845', '', 'Accum. Depreciation-Vehicles', '3', '0'),
('2100', '', 'Accounts Payable', '4', '0'),
('2110', '', 'Accrued Charges', '4', '0'),
('2140', '', 'Provision for Gratuity', '4', '0'),
('2150', '', 'V.A.T.Control Account', '4', '0'),
('2160', '', 'P.A.Y.E.  Payable', '4', '0'),
('2120', '', 'Audit Fees Payable', '4', '0'),
('2620', '', 'Bank Loans', '5', '0'),
('2680', '', 'Loans from Shareholders', '5', '0'),
('3350', '', 'Common Shares', '6', '0'),
('3590', '', 'Retained Earnings - prior years', '7', '0'),
('4010', '', 'Export of Customer Care IT services', '8', '0'),
('4430', '', 'Other Income', '9', '0'),
('4440', '', 'Interest', '9', '0'),
('4450', '', 'Foreign Exchange Gain/(Loss)', '9', '0'),
('4500', '', 'Prompt Payment Discounts', '9', '0'),
('4510', '', 'Discounts Given', '9', '0'),
('5010', '', 'Cost of Goods Sold - Retail', '10', '0'),
('5020', '', 'Material Usage Varaiance', '10', '0'),
('5030', '', 'Consumable Materials', '10', '0'),
('5040', '', 'Purchase price Variance', '10', '0'),
('5050', '', 'Purchases of materials', '10', '0'),
('5060', '', 'Discounts Received', '10', '0'),
('5100', '', 'Freight', '10', '0'),
('5410', '', 'Salaries &amp; Wages ', '11', '0'),
('5420', '', 'Wages - Overtime', '11', '0'),
('5430', '', 'Staff Tea &amp; Meals expenses', '11', '0'),
('5440', '', 'Staff Medical Expenses', '11', '0'),
('5450', '', 'Employees Provident Fund', '11', '0'),
('5460', '', 'Employees Trust fund', '11', '0'),
('5470', '', 'Staff Transport', '11', '0'),
('5510', '', 'Staff Welfare', '11', '0'),
('5520', '', 'Staff Recruitment', '11', '0'),
('5850', '', 'Depreciation', '12', '0'),
('4460', '', 'Disposal of Assets', '9', '0'),
('5610', '', 'Audit Fees', '12', '0'),
('5615', '', 'Advertising &amp; Promotions', '12', '0'),
('5620', '', 'Bad Debts', '12', '0'),
('5660', '', 'Printing &amp; Stationery', '12', '0'),
('5685', '', 'Insurance', '12', '0'),
('5690', '', 'Bank Charges', '13', '0'),
('5700', '', 'Office Supplies', '12', '0'),
('5760', '', 'Rent', '12', '0'),
('5765', '', 'Repair &amp; Maintenance', '12', '0'),
('5780', '', 'Telephone &amp; Internet', '12', '0'),
('5785', '', 'Travel &amp; Entertainment', '12', '0'),
('5790', '', 'Other expenses', '12', '0'),
('5795', '', 'Registrations &amp; Secretarial fees', '12', '0'),
('5800', '', 'Licenses', '12', '0'),
('5810', '', 'Foreign Exchange Loss', '12', '0'),
('9990', '', 'Year Profit/Loss', '12', '0'),
('1210', '', 'K.P.L.Pintoe - Drawings', '1', '0'),
('1220', '', 'Evolve Technologies (Pvt)Ltd.- Current A/C', '1', '0'),
('1230', '', 'Inbay Limited - Current Account', '1', '0'),
('1180', '', 'Deposits &amp; Advance', '1', '0'),
('5695', '', 'Business Development Expenses', '12', '0'),
('1201', '', 'Staff Loans', '1', '0'),
('1221', '', 'Evolve Technologies (Pvt)Ltd.', '1', '0'),
('5465', '', 'Staff Gratuity', '11', '0'),
('5511', '', 'Staff Training', '11', '0'),
('5811', '', 'Sales Promotion expenses', '12', '0'),
('5521', '', 'Staff Loans', '1', '0'),
('6010', '', 'Overdraft Interest', '13', '0'),
('5415', '', 'Salary Commission', '11', '0'),
('1810', '', 'Furniture &amp; Fittings', '3', '0'),
('1830', '', 'Acc. Depreciation - Furniture &amp; Fittings', '3', '0'),
('5812', '5812', 'Consultancy  Fees', '12', '0'),
('1061', '', 'Sampath Bank - GBP Account', '1', '0');

### Structure of table `1_chart_types` ###

DROP TABLE IF EXISTS `1_chart_types`;

CREATE TABLE `1_chart_types` (
  `id` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `class_id` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '-1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_chart_types` ###

INSERT INTO `1_chart_types` VALUES
('1', 'Current Assets', '1', '', '0'),
('2', 'Inventory Assets', '1', '', '0'),
('3', 'Capital Assets', '1', '', '0'),
('4', 'Current Liabilities', '2', '', '0'),
('5', 'Long Term Liabilities', '2', '', '0'),
('6', 'Share Capital', '2', '', '0'),
('7', 'Retained Earnings', '2', '', '0'),
('8', 'Sales Revenue', '3', '', '0'),
('9', 'Other Revenue', '3', '', '0'),
('10', 'Cost of Goods Sold', '4', '', '0'),
('11', 'Payroll Expenses', '4', '', '0'),
('12', 'General &amp; Administrative expenses', '4', '', '0'),
('13', 'Finance Charges', '4', '', '0');

### Structure of table `1_comments` ###

DROP TABLE IF EXISTS `1_comments`;

CREATE TABLE `1_comments` (
  `type` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_comments` ###

INSERT INTO `1_comments` VALUES
('13', '18', '2012-04-20', 'Invoice for the month of April 2012 '),
('10', '18', '2012-04-20', 'Invoice for the month of April 2012 '),
('13', '19', '2012-04-20', 'Invoice for the month of April 202'),
('10', '19', '2012-04-20', 'Invoice for the month of April 202'),
('11', '1', '2012-04-20', 'Invoice for the month of April 2012 '),
('13', '20', '2012-05-20', 'Invoice For the month of May 2012\n\nInvolve'),
('10', '20', '2012-05-20', 'Invoice For the month of May 2012\n\nInvolve'),
('13', '21', '2012-05-20', 'Invoice for the month of May 2012\nOrange Bus'),
('10', '21', '2012-05-20', 'Invoice for the month of May 2012\nOrange Bus'),
('13', '22', '2012-06-20', 'Invoice for the of June 2012\nInvolve '),
('10', '22', '2012-06-20', 'Invoice for the of June 2012\nInvolve '),
('13', '23', '2012-06-20', 'Invoice for the month of June \nOrange Bus'),
('10', '23', '2012-06-20', 'Invoice for the month of June \nOrange Bus'),
('13', '24', '2012-07-20', 'Invoice for the month of July 2012\nInvolve'),
('10', '24', '2012-07-20', 'Invoice for the month of July 2012\nInvolve'),
('13', '25', '2012-07-20', 'Invoice for the month of July 2012\nOrange Bus'),
('10', '25', '2012-07-20', 'Invoice for the month of July 2012\nOrange Bus'),
('13', '26', '2012-08-20', 'Invoice for the month of Aug 2012\nInvolve '),
('10', '26', '2012-08-20', 'Invoice for the month of Aug 2012\nInvolve '),
('13', '27', '2012-08-20', 'Invoice for the month of Aug 2012\nOrange Bus'),
('10', '27', '2012-08-20', 'Invoice for the month of Aug 2012\nOrange Bus'),
('13', '28', '2012-09-20', 'Invoice for the month of Sep 2012\nInvolve'),
('10', '28', '2012-09-20', 'Invoice for the month of Sep 2012\nInvolve'),
('13', '29', '2012-09-20', 'Invoice for the month of Sep 2012\nOrange bus'),
('10', '29', '2012-09-20', 'Invoice for the month of Sep 2012\nOrange bus'),
('13', '30', '2012-10-20', 'Invoice for the month of Oct 2012\nInvolve'),
('10', '30', '2012-10-20', 'Invoice for the month of Oct 2012\nInvolve'),
('13', '31', '2012-10-20', 'Invoice for the month of Oct 2012\nOrange bus'),
('10', '31', '2012-10-20', 'Invoice for the month of Oct 2012\nOrange bus'),
('13', '32', '2012-11-20', 'Invoice for the month of Nov 2012\nInvolve'),
('10', '32', '2012-11-20', 'Invoice for the month of Nov 2012\nInvolve'),
('13', '33', '2012-11-20', 'Invoice for the month of Nov 2012\nOrange bus'),
('10', '33', '2012-11-20', 'Invoice for the month of Nov 2012\nOrange bus'),
('13', '34', '2012-12-20', 'Invoice for the month of Dec 2012\nInvolve'),
('10', '34', '2012-12-20', 'Invoice for the month of Dec 2012\nInvolve'),
('13', '35', '2012-12-20', 'Invoice for the month of Dec 2012\nOrange Bus'),
('10', '35', '2012-12-20', 'Invoice for the month of Dec 2012\nOrange Bus'),
('13', '36', '2013-01-20', 'Invoice for the month of Jan 2013\nInvolve'),
('10', '36', '2013-01-20', 'Invoice for the month of Jan 2013\nInvolve'),
('13', '37', '2013-01-20', 'Invoice for the month of Jan 2013\nOrange bus'),
('10', '37', '2013-01-20', 'Invoice for the month of Jan 2013\nOrange bus'),
('13', '38', '2013-02-20', 'Invoice for the month of Feb 2013\nInvolve'),
('10', '38', '2013-02-20', 'Invoice for the month of Feb 2013\nInvolve'),
('13', '39', '2013-02-20', 'Invoice for the month of Feb 2013\nOrange Bus'),
('10', '39', '2013-02-20', 'Invoice for the month of Feb 2013\nOrange Bus'),
('13', '40', '2013-03-20', 'Invoice for the month of March 2013\nInvolve'),
('13', '41', '2013-03-20', 'Invoice for the month of March 2013\nOrange bus'),
('10', '41', '2013-03-20', 'Invoice for the month of March 2013\nOrange bus'),
('10', '40', '2013-03-20', 'Invoice for the month of March 2013\nInvolve'),
('12', '21', '2012-04-30', 'Payment from Inbay Limited GBP'),
('12', '22', '2012-05-31', 'Payment from Inbay Limited GBP'),
('12', '23', '2012-05-31', 'Payment from Inbay Limited GBP'),
('12', '24', '2012-06-30', 'Payment from Inbay Limited GBP'),
('12', '25', '2012-06-30', 'Payment from Inbay Limited GBP'),
('12', '26', '2012-07-31', 'Payment from Inbay Limited GBP'),
('12', '27', '2012-07-31', 'Payment from Inbay Limited GBP'),
('12', '28', '2012-08-31', 'Payment from Inbay Limited GBP'),
('12', '29', '2012-08-31', 'Payment from Inbay Limited GBP'),
('12', '30', '2012-09-30', 'Payment from Inbay Limited GBP'),
('12', '31', '2012-09-30', 'Payment from Inbay Limited GBP'),
('12', '32', '2012-10-31', 'Payment from Inbay Limited GBP'),
('12', '33', '2012-10-31', 'Payment from Inbay Limited GBP'),
('12', '34', '2012-11-30', 'Payment from Inbay Limited GBP'),
('12', '35', '2012-11-30', 'Payment from Inbay Limited GBP'),
('12', '36', '2012-12-31', 'Payment from Inbay Limited GBP'),
('12', '37', '2012-12-31', 'Payment from Inbay Limited GBP'),
('12', '38', '2013-01-31', 'Payment from Inbay Limited GBP'),
('12', '39', '2013-01-31', 'Payment from Inbay Limited GBP'),
('12', '40', '2013-02-28', 'Payment from Inbay Limited GBP'),
('12', '41', '2013-02-28', 'Payment from Inbay Limited GBP'),
('12', '42', '2013-03-31', 'Payment from Inbay Limited GBP'),
('12', '43', '2013-03-31', 'Payment from Inbay Limited GBP'),
('13', '42', '2013-04-25', 'IT Support services provided for the month of April 2013.'),
('10', '42', '2013-04-25', 'IT Support services provided for the month of April 2013.'),
('13', '43', '2013-04-25', 'IT services provided during the month of April 2013'),
('10', '43', '2013-04-25', 'IT services provided during the month of April 2013'),
('13', '44', '2013-05-21', 'IT services provided during the month of May 2013 - Orange bus'),
('10', '44', '2013-05-21', 'IT services provided during the month of May 2013 - Orange bus'),
('13', '45', '2013-05-21', 'IT services provided during the month of May 2013'),
('10', '45', '2013-05-21', 'IT services provided during the month of May 2013'),
('13', '46', '2013-06-21', 'IT services provided during the month of June 2013'),
('10', '46', '2013-06-21', 'IT services provided during the month of June 2013'),
('13', '47', '2013-07-22', 'IT services provided during the month of July 2013'),
('10', '47', '2013-07-22', 'IT services provided during the month of July 2013'),
('13', '48', '2013-08-21', 'IT services provided during the month of August 2013'),
('10', '48', '2013-08-21', 'IT services provided during the month of August 2013'),
('13', '49', '2013-09-20', 'IT services provided during the month of September 2013'),
('10', '49', '2013-09-20', 'IT services provided during the month of September 2013'),
('13', '50', '2013-10-21', 'IT services provided during the month of October 2013'),
('10', '50', '2013-10-21', 'IT services provided during the month of October 2013'),
('13', '51', '2013-11-22', 'IT services provided during the month of November 2013'),
('10', '51', '2013-11-22', 'IT services provided during the month of November 2013'),
('13', '52', '2013-12-23', 'IT services provided during the month of December 2013'),
('10', '52', '2013-12-23', 'IT services provided during the month of December 2013'),
('13', '53', '2014-01-22', 'IT services provided during the month of January 2014'),
('10', '53', '2014-01-22', 'IT services provided during the month of January 2014'),
('13', '54', '2014-02-21', 'IT services provided during the month of February 2014'),
('10', '54', '2014-02-21', 'IT services provided during the month of February 2014'),
('13', '55', '2014-03-21', 'IT services provided during the month of March 2014'),
('10', '55', '2014-03-21', 'IT services provided during the month of March 2014'),
('13', '56', '2013-02-20', 'IT services provided during the month of February 2013'),
('10', '56', '2013-02-20', 'IT services provided during the month of February 2013'),
('13', '57', '2013-05-21', 'IT Support services provided during the month of May 2013.'),
('10', '57', '2013-05-21', 'IT Support services provided during the month of May 2013.'),
('13', '58', '2013-05-21', 'IT support services provided during the month of May 2013'),
('10', '58', '2013-05-21', 'IT support services provided during the month of May 2013'),
('13', '59', '2013-05-21', 'IT support services for the month of May 2013.'),
('10', '59', '2013-05-21', 'IT support services for the month of May 2013.'),
('1', '513', '2015-06-10', 'Payment For Mark&#039;s Broadband Connect In to the last Month Additional Payment.'),
('1', '551', '2014-04-16', 'Bank Casual OD Charge'),
('1', '552', '2014-04-22', 'Bank Cheque Book Charges'),
('1', '553', '2014-04-28', 'Staff Salaries for the month of April 2013'),
('1', '554', '2014-04-28', 'Salary Commission'),
('1', '555', '2014-05-28', 'Staff Salaries for the month of May 2014'),
('1', '556', '2014-05-28', 'Salary Commission for the month of May'),
('1', '557', '2014-05-31', 'OD Interest for the month of May'),
('2', '107', '2014-05-26', 'Evolve Technologies (Pvt) Ltd'),
('2', '108', '2014-05-28', 'Evolve Technologies (Pvt) Ltd'),
('2', '110', '2014-05-28', 'Fund Transfer Evolve Technologies (Pvt) Ltd'),
('1', '558', '2014-06-17', 'Other expenses'),
('1', '559', '2014-06-27', 'Staff Salaries for the month of June'),
('1', '560', '2014-06-27', 'Salary Commission for the month of June'),
('2', '111', '2014-06-20', 'Fund Transfer Evolve Technologies (Pvt) Ltd'),
('2', '112', '2014-06-27', 'Fund Transfer Evolve Technologies (Pvt) Ltd'),
('2', '113', '2014-06-30', 'Fund Transfer Evolve Technologies (Pvt) Ltd'),
('1', '561', '2014-07-01', 'Other Payments'),
('1', '562', '2014-07-28', 'Staff Salaries for the month of July.'),
('1', '563', '2014-07-28', 'Salary Commission'),
('2', '114', '2014-07-18', 'Fund Transfer - Evolve Technologies (Pvt) Ltd'),
('2', '115', '2014-07-28', 'Fund Transfer - Evolve Technologies (Pvt) Ltd'),
('2', '116', '2014-07-31', 'Fund Transfer - Evolve Technologies (Pvt) Ltd'),
('1', '564', '2014-08-27', 'Staff Salaries for the month of August'),
('1', '565', '2014-08-27', 'Salary Commission for the month of August'),
('1', '566', '2014-08-28', 'Bank Cheque Book Charges'),
('2', '118', '2014-08-12', 'Fund Transfer  Evolve Technologies (Pvt) Ltd '),
('2', '119', '2014-08-27', 'Fund Transfer  Evolve Technologies (Pvt) Ltd '),
('1', '568', '2014-09-01', 'Cheque Payment'),
('1', '569', '2014-09-29', 'Staff Salaries for the month of September'),
('2', '121', '2014-09-16', 'Fund Transfer Evolve Technologies (Pvt) Ltd'),
('2', '122', '2014-09-29', 'Fund Transfer Evolve Technologies (Pvt) Ltd'),
('1', '572', '2014-10-27', 'Staff Salary for the month of October'),
('2', '123', '2014-10-14', 'Fund Transfer Evolve Technologies (Pvt) Ltd'),
('2', '124', '2014-10-27', 'Fund Transfer Evolve Technologies (Pvt) Ltd'),
('1', '574', '2014-11-27', 'Staff Salaries for the month of November'),
('1', '575', '2014-11-27', 'Salary Commission'),
('2', '125', '2014-11-04', 'Fund Transfer Evolve Technologies (Pvt) Ltd'),
('2', '126', '2014-11-26', 'Fund Transfer Evolve Technologies (Pvt) Ltd'),
('2', '127', '2014-11-27', 'Fund Transfer Evolve Technologies (Pvt) Ltd'),
('1', '579', '2014-12-22', 'Salary Commission'),
('2', '128', '2014-12-10', 'Fund Transfer Evolve Technologies (Pvt) Ltd'),
('2', '129', '2014-12-10', 'Fund Transfer Evolve Technologies (Pvt) Ltd'),
('2', '130', '2014-12-29', 'Fund Transfer Evolve Technologies (Pvt) Ltd'),
('2', '131', '2014-12-22', 'Fund Transfer Evolve Technologies (Pvt) Ltd'),
('1', '580', '2015-01-27', 'Staff Salaries for the month of January'),
('1', '581', '2015-01-27', 'Salary Commission'),
('1', '582', '2015-01-30', 'Bank Cheque Book Charges  '),
('2', '132', '2015-01-20', 'Fund Transfer Evolve Technologies'),
('2', '133', '2015-01-27', 'Fund Transfer Evolve Technologies'),
('2', '134', '2015-01-29', 'Fund Transfer Evolve Technologies'),
('1', '583', '2015-02-27', 'Staff Salaries'),
('1', '584', '2015-02-27', 'Salary Commission'),
('1', '585', '2015-02-28', 'Bank Cheque Book Charges'),
('2', '135', '2015-02-10', 'Fund Transfer Evolve Technologies (Pvt) Ltd '),
('2', '136', '2015-02-20', 'Fund Transfer Evolve Technologies (Pvt) Ltd '),
('2', '137', '2015-02-24', 'Fund Transfer Evolve Technologies (Pvt) Ltd '),
('2', '138', '2015-02-27', 'Fund Transfer Evolve Technologies (Pvt) Ltd '),
('2', '139', '2015-03-27', 'Fund Transfer Evolve Technologies (Pvt) Ltd '),
('1', '586', '2015-03-27', 'Staff Salaries for the month of March'),
('1', '590', '2014-12-22', 'Staff Salaries for the month of December'),
('13', '60', '2014-04-25', 'Services Provided for the month of April 2014'),
('10', '60', '2014-04-25', 'Services Provided for the month of April 2014'),
('13', '61', '2014-05-25', 'Export Services provided for the month of May'),
('10', '61', '2014-05-25', 'Export Services provided for the month of May'),
('13', '62', '2014-06-25', 'Export Services provided for the month of June'),
('10', '62', '2014-06-25', 'Export Services provided for the month of June'),
('13', '63', '2014-07-25', 'Export Services provided for the month of July.'),
('10', '63', '2014-07-25', 'Export Services provided for the month of July.'),
('13', '64', '2014-08-25', 'Export Services provided for the month of August'),
('10', '64', '2014-08-25', 'Export Services provided for the month of August'),
('13', '65', '2014-09-25', 'Export Services provided for the month of September.'),
('13', '66', '2014-10-25', 'Export Services provided for the month of October 2014.'),
('10', '66', '2014-10-25', 'Export Services provided for the month of October 2014.'),
('13', '67', '2014-11-25', 'Export Services provided for the month of November 2014'),
('10', '67', '2014-11-25', 'Export Services provided for the month of November 2014'),
('13', '68', '2014-12-24', 'Export Services provided for the month of December 2014'),
('10', '68', '2014-12-24', 'Export Services provided for the month of December 2014'),
('13', '69', '2015-01-25', 'Export Services provided for the month of January 2015'),
('10', '69', '2015-01-25', 'Export Services provided for the month of January 2015'),
('13', '70', '2015-02-25', 'Export Services provided for the month of February 2015'),
('10', '70', '2015-02-25', 'Export Services provided for the month of February 2015'),
('10', '65', '2014-09-25', 'Export Services provided for the month of September.'),
('13', '72', '2015-03-25', 'Export services for the month of March 2015'),
('10', '72', '2015-03-25', 'Export services for the month of March 2015'),
('12', '58', '2014-05-28', 'Money for the export services provided for the month of May.'),
('12', '59', '2014-06-28', 'Money for the export services provided for the month of June.'),
('12', '62', '2014-10-28', 'Money for the export services provided for the month of October.'),
('12', '63', '2014-11-28', 'Money for the export services provided for the month of November 2014'),
('12', '65', '2015-01-28', 'Money for the export services provided for the month of January 2015'),
('12', '66', '2015-02-28', 'Money for the export services provided for the month of February 2015'),
('13', '73', '2014-07-25', 'Money for the export services provided for the month of July 2014'),
('10', '73', '2014-07-25', 'Money for the export services provided for the month of July 2014'),
('12', '57', '2014-04-25', 'Money for the export services provided. '),
('12', '68', '2014-07-25', 'Money for the export services provided for the month of July 2014'),
('12', '60', '2014-08-25', 'Money for the export services provided for the month of August.'),
('12', '61', '2014-09-29', 'Money for the export services provided for the month of September.'),
('12', '64', '2014-12-29', 'Money for the export services provided for the month of December 2014'),
('13', '74', '2014-12-29', 'Special IT work'),
('10', '74', '2014-12-29', 'Special IT work'),
('12', '67', '2015-03-28', 'Money for the export services provided for the month of March 2015.'),
('1', '641', '2014-04-22', 'Bank Cheque Book Charges'),
('2', '143', '2016-01-25', 'Seylan Bank 968258'),
('13', '78', '2015-12-20', 'Additional support services carried out during the month'),
('10', '78', '2015-12-20', 'Additional support services carried out during the month'),
('13', '79', '2014-12-21', 'Additional IT work carried out during the month.'),
('10', '79', '2014-12-21', 'Additional IT work carried out during the month.'),
('13', '80', '2014-12-21', 'Additional IT services for the month of December 2014'),
('10', '80', '2014-12-21', 'Additional IT services for the month of December 2014'),
('13', '81', '2015-04-20', 'IT Support Services Charge for the Month Of April 2015'),
('10', '81', '2015-04-20', 'IT Support Services Charge for the Month Of April 2015'),
('13', '82', '2015-05-20', 'IT Support Services Charge for the Month Of May 2015'),
('10', '82', '2015-05-20', 'IT Support Services Charge for the Month Of May 2015'),
('13', '83', '2015-06-20', 'IT Support Services Charge for the Month Of June 2015'),
('10', '83', '2015-06-20', 'IT Support Services Charge for the Month Of June 2015'),
('13', '84', '2015-07-20', 'IT Support Services Charge for the Month Of July 2015'),
('10', '84', '2015-07-20', 'IT Support Services Charge for the Month Of July 2015'),
('13', '85', '2015-08-20', 'IT Support Services Charge for the Month Of August 2015'),
('10', '85', '2015-08-20', 'IT Support Services Charge for the Month Of August 2015'),
('13', '86', '2015-09-20', 'IT Support Services Charge for the Month Of September 2015'),
('10', '86', '2015-09-20', 'IT Support Services Charge for the Month Of September 2015'),
('13', '87', '2015-10-20', 'IT Support Services Charge for the Month Of October 2015'),
('10', '87', '2015-10-20', 'IT Support Services Charge for the Month Of October 2015'),
('13', '88', '2015-11-20', 'IT Support Services Charge for the Month Of November 2015'),
('10', '88', '2015-11-20', 'IT Support Services Charge for the Month Of November 2015'),
('13', '89', '2015-12-20', 'IT Support Services Charge for the Month Of December 2015'),
('10', '89', '2015-12-20', 'IT Support Services Charge for the Month Of December 2015'),
('13', '90', '2016-01-20', 'IT Support Services Charge for the Month Of January 2016'),
('10', '90', '2016-01-20', 'IT Support Services Charge for the Month Of January 2016'),
('13', '91', '2016-02-20', 'IT Support Services Charge for the Month Of February 2016'),
('10', '91', '2016-02-20', 'IT Support Services Charge for the Month Of February 2016'),
('13', '92', '2016-03-20', 'IT Support Services Charge for the Month Of March 2016'),
('10', '92', '2016-03-20', 'IT Support Services Charge for the Month Of March 2016'),
('1', '738', '2016-05-09', 'Cash Refunded 87,500/= to Mr .Pintoe  (276,500 - 189,000)'),
('1', '739', '2016-05-09', 'Cash Refunded 87,500/= to Mr .Pintoe  (276,500 - 189,000)'),
('1', '740', '2016-05-09', 'Cash Refunded 87,500/= to Mr .Pintoe  (276,500 - 189,000)'),
('4', '1', '2016-05-31', 'Fund Transfer to Evolve Technologies A/C From Sampath Bank- Current Account'),
('4', '3', '2016-05-27', 'From Sampath Bank - GBP Account To Sampath Bank - Current Account'),
('4', '4', '2016-05-27', 'From Sampath Bank - GBP Account To Sampath Bank - Current Account'),
('2', '188', '2016-01-25', 'Seylan Bank 968258'),
('12', '75', '2015-05-25', 'IT Support Services Payment for the Month Of May 2015'),
('13', '97', '2015-06-20', 'IT Support Services Charge for the Month Of June 2015'),
('10', '97', '2015-06-20', 'IT Support Services Charge for the Month Of June 2015'),
('13', '98', '2015-07-20', 'IT Support Services Payment for the Month Of July 2015'),
('10', '98', '2015-07-20', 'IT Support Services Payment for the Month Of July 2015'),
('13', '99', '2015-08-20', 'IT Support Services Charge for the Month Of August 2015'),
('10', '99', '2015-08-20', 'IT Support Services Charge for the Month Of August 2015'),
('13', '100', '2015-09-20', 'IT Support Services Charge for the Month Of September 2015'),
('10', '100', '2015-09-20', 'IT Support Services Charge for the Month Of September 2015'),
('13', '101', '2015-10-20', 'IT Support Services Charge for the Month Of October 2015'),
('10', '101', '2015-10-20', 'IT Support Services Charge for the Month Of October 2015'),
('13', '102', '2015-11-20', 'IT Support Services Charge for the Month Of November 2015'),
('10', '102', '2015-11-20', 'IT Support Services Charge for the Month Of November 2015'),
('13', '103', '2015-12-20', 'IT Support Services Charge for the Month Of December 2015'),
('10', '103', '2015-12-20', 'IT Support Services Charge for the Month Of December 2015'),
('13', '104', '2016-01-20', 'IT Support Services Charge for the Month Of January 2016'),
('10', '104', '2016-01-20', 'IT Support Services Charge for the Month Of January 2016'),
('13', '105', '2016-02-20', 'IT Support Services Charge for the Month Of February 2016'),
('10', '105', '2016-02-20', 'IT Support Services Charge for the Month Of February 2016'),
('13', '106', '2016-03-20', 'IT Support Services Charge for the Month Of March 2016'),
('10', '106', '2016-03-20', 'IT Support Services Charge for the Month Of March 2016'),
('12', '74', '2015-04-28', 'IT Support Service Payment for the month of April 2015'),
('12', '91', '2015-06-25', 'IT Support Services Payment for the Month Of June 2015'),
('12', '77', '2015-07-27', 'IT Support Services Payment for the Month Of July 2015'),
('12', '78', '2015-08-26', 'IT Support Services Payment for the Month Of August 2015'),
('12', '81', '2015-11-26', 'IT Support Services Payment for the Month Of November 2015'),
('12', '82', '2015-12-23', 'IT Support Services Payment for the Month Of December 2015'),
('12', '83', '2016-01-27', 'IT Support Services Payment for the Month Of January 2016'),
('12', '84', '2016-03-01', 'IT Support Services Payment for the Month Of February 2016'),
('12', '85', '2016-03-28', 'IT Support Services Payment for the Month Of March 2016'),
('12', '79', '2015-09-28', 'IT Support Services Payment for the Month Of September 2015'),
('12', '80', '2015-10-28', 'IT Support Services Payment for the Month Of October 2015'),
('13', '107', '2016-01-20', 'IT support services for the month of January 2016.'),
('10', '107', '2016-01-20', 'IT support services for the month of January 2016.');

### Structure of table `1_credit_status` ###

DROP TABLE IF EXISTS `1_credit_status`;

CREATE TABLE `1_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_credit_status` ###

INSERT INTO `1_credit_status` VALUES
('1', 'Good History', '0', '0'),
('3', 'No more work until payment received', '1', '0'),
('4', 'In liquidation', '1', '0');

### Structure of table `1_crm_categories` ###

DROP TABLE IF EXISTS `1_crm_categories`;

CREATE TABLE `1_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT 'contact type e.g. customer',
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT 'detailed usage e.g. department',
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL COMMENT 'for category selector',
  `description` tinytext COLLATE utf8_unicode_ci NOT NULL COMMENT 'usage description',
  `system` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_crm_categories` ###

INSERT INTO `1_crm_categories` VALUES
('1', 'cust_branch', 'general', 'General', 'General contact data for customer branch (overrides company setting)', '1', '0'),
('2', 'cust_branch', 'invoice', 'Invoices', 'Invoice posting (overrides company setting)', '1', '0'),
('3', 'cust_branch', 'order', 'Orders', 'Order confirmation (overrides company setting)', '1', '0'),
('4', 'cust_branch', 'delivery', 'Deliveries', 'Delivery coordination (overrides company setting)', '1', '0'),
('5', 'customer', 'general', 'General', 'General contact data for customer', '1', '0'),
('6', 'customer', 'order', 'Orders', 'Order confirmation', '1', '0'),
('7', 'customer', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('8', 'customer', 'invoice', 'Invoices', 'Invoice posting', '1', '0'),
('9', 'supplier', 'general', 'General', 'General contact data for supplier', '1', '0'),
('10', 'supplier', 'order', 'Orders', 'Order confirmation', '1', '0'),
('11', 'supplier', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('12', 'supplier', 'invoice', 'Invoices', 'Invoice posting', '1', '0');

### Structure of table `1_crm_contacts` ###

DROP TABLE IF EXISTS `1_crm_contacts`;

CREATE TABLE `1_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT '0' COMMENT 'foreign key to crm_contacts',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT 'foreign key to crm_categories',
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT 'foreign key to crm_categories',
  `entity_id` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'entity id in related class table',
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_crm_contacts` ###

INSERT INTO `1_crm_contacts` VALUES
('1', '1', 'cust_branch', 'general', '1'),
('2', '2', 'supplier', 'general', '1'),
('3', '3', 'cust_branch', 'general', '2');

### Structure of table `1_crm_persons` ###

DROP TABLE IF EXISTS `1_crm_persons`;

CREATE TABLE `1_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `name2` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` tinytext COLLATE utf8_unicode_ci,
  `phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone2` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lang` char(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_crm_persons` ###

INSERT INTO `1_crm_persons` VALUES
('1', 'Main Branch', 'Main Branch', NULL, '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, NULL, NULL, NULL, '', '0'),
('2', 'highlevel', '', NULL, '274, Old Road,\nNawinna\nMaharagama.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('3', 'Inbay Limited', 'Inbay Limited', NULL, 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, NULL, NULL, NULL, '', '0');

### Structure of table `1_currencies` ###

DROP TABLE IF EXISTS `1_currencies`;

CREATE TABLE `1_currencies` (
  `currency` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `auto_update` tinyint(1) NOT NULL DEFAULT '1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`curr_abrev`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_currencies` ###

INSERT INTO `1_currencies` VALUES
('US Dollars', 'USD', '$', 'United States', 'Cents', '1', '0'),
('CA Dollars', 'CAD', '$', 'Canada', 'Cents', '1', '0'),
('Euro', 'EUR', '?', 'Europe', 'Cents', '1', '0'),
('Pounds', 'GBP', '?', 'England', 'Pence', '1', '0'),
('Sri Lanka Rupee', 'Rs.', 'Rs.', 'Sri Lanka', 'Cents.', '1', '0');

### Structure of table `1_cust_allocations` ###

DROP TABLE IF EXISTS `1_cust_allocations`;

CREATE TABLE `1_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`),
  KEY `trans_no_to` (`trans_no_to`)
) ENGINE=InnoDB AUTO_INCREMENT=158 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_cust_allocations` ###

INSERT INTO `1_cust_allocations` VALUES
('1', '1100325', '2012-02-22', '1', '12', '1', '10'),
('3', '1600', '2012-02-22', '3', '12', '2', '10'),
('4', '1435915', '2012-02-22', '4', '12', '3', '10'),
('5', '1406415', '2012-02-22', '5', '12', '4', '10'),
('6', '1415415', '2012-02-22', '6', '12', '5', '10'),
('7', '1089045', '2012-02-22', '7', '12', '2', '10'),
('8', '343400', '2012-02-22', '8', '12', '2', '10'),
('9', '1432415', '2013-08-07', '9', '12', '6', '10'),
('10', '1451439', '2013-08-07', '10', '12', '7', '10'),
('11', '1378415', '2013-08-07', '11', '12', '8', '10'),
('12', '1226434', '2013-08-07', '12', '12', '9', '10'),
('13', '1273934', '2013-08-07', '13', '12', '10', '10'),
('14', '1049751', '2013-08-07', '14', '12', '11', '10'),
('15', '1417608', '2013-08-07', '15', '12', '12', '10'),
('16', '1278308', '2013-08-07', '16', '12', '13', '10'),
('17', '1250308', '2013-08-07', '17', '12', '14', '10'),
('18', '1385911', '2013-08-07', '18', '12', '15', '10'),
('19', '1470462', '2013-08-07', '19', '12', '16', '10'),
('20', '1594273', '2013-08-07', '20', '12', '17', '10'),
('22', '10900', '2014-07-31', '21', '12', '19', '10'),
('23', '9032', '2014-07-31', '22', '12', '20', '10'),
('24', '1196', '2014-07-31', '23', '12', '21', '10'),
('25', '10722', '2014-07-31', '24', '12', '22', '10'),
('26', '2193', '2014-07-31', '25', '12', '23', '10'),
('27', '10620', '2014-07-31', '26', '12', '24', '10'),
('28', '4380', '2014-07-31', '27', '12', '25', '10'),
('29', '10699', '2014-07-31', '28', '12', '26', '10'),
('30', '4344', '2014-07-31', '29', '12', '27', '10'),
('31', '11008', '2014-07-31', '30', '12', '28', '10'),
('32', '4418', '2014-07-31', '31', '12', '29', '10'),
('33', '10302', '2014-07-31', '32', '12', '30', '10'),
('34', '4386', '2014-07-31', '33', '12', '31', '10'),
('35', '11165', '2014-07-31', '34', '12', '32', '10'),
('36', '4615', '2014-07-31', '35', '12', '33', '10'),
('37', '12004', '2014-07-31', '36', '12', '34', '10'),
('38', '4747', '2014-07-31', '37', '12', '35', '10'),
('39', '15924', '2014-07-31', '38', '12', '36', '10'),
('42', '5097', '2014-07-31', '41', '12', '39', '10'),
('43', '17396', '2014-07-31', '42', '12', '40', '10'),
('44', '4665', '2014-07-31', '43', '12', '41', '10'),
('45', '4657', '2015-02-24', '44', '12', '42', '10'),
('46', '15962', '2015-02-24', '44', '12', '43', '10'),
('49', '19169', '2015-02-24', '46', '12', '46', '10'),
('50', '17178', '2015-02-24', '47', '12', '47', '10'),
('51', '19708', '2015-02-24', '48', '12', '48', '10'),
('52', '18502', '2015-02-24', '49', '12', '49', '10'),
('53', '18828', '2015-02-24', '50', '12', '50', '10'),
('54', '18134', '2015-02-24', '51', '12', '51', '10'),
('55', '17960', '2015-02-24', '52', '12', '52', '10'),
('56', '17056', '2015-02-24', '53', '12', '53', '10'),
('57', '15864', '2015-02-24', '54', '12', '54', '10'),
('59', '20027', '2015-02-24', '56', '12', '55', '10'),
('61', '10560', '2015-02-24', '55', '12', '56', '10'),
('64', '10951', '2015-03-03', '45', '12', '59', '10'),
('65', '7043', '2015-03-03', '45', '12', '44', '10'),
('67', '17822', '2015-10-21', '58', '12', '61', '10'),
('71', '20203', '2015-10-21', '62', '12', '66', '10'),
('74', '22340', '2015-10-21', '65', '12', '69', '10'),
('75', '25071', '2015-10-21', '66', '12', '70', '10'),
('78', '15962', '2015-10-29', '57', '12', '60', '10'),
('80', '19708', '2015-10-29', '60', '12', '64', '10'),
('84', '20530', '2015-10-29', '61', '12', '65', '10'),
('86', '20147', '2015-10-30', '64', '12', '68', '10'),
('88', '11298', '2016-01-13', '70', '12', '75', '10'),
('89', '11245', '2016-01-13', '71', '12', '76', '10'),
('90', '19055', '2016-01-13', '72', '12', '77', '10'),
('91', '23038.6', '2016-01-13', '67', '12', '72', '10'),
('92', '3.4', '2016-01-13', '3', '11', '72', '10'),
('93', '28250', '2016-02-05', '73', '12', '80', '10'),
('110', '35943', '2016-07-01', '90', '12', '93', '10'),
('138', '26926.69', '2016-09-29', '74', '12', '95', '10'),
('139', '30933.76', '2016-09-29', '92', '12', '96', '10'),
('140', '28266.76', '2016-09-29', '91', '12', '97', '10'),
('141', '29110.73', '2016-09-29', '77', '12', '98', '10'),
('142', '28209.78', '2016-09-29', '78', '12', '99', '10'),
('146', '31174.63', '2016-09-29', '81', '12', '102', '10'),
('147', '32631.57', '2016-09-29', '82', '12', '103', '10'),
('151', '36846.36', '2016-09-29', '84', '12', '105', '10'),
('154', '34309.4', '2016-09-29', '85', '12', '106', '10'),
('155', '27740.63', '2016-09-29', '79', '12', '100', '10'),
('156', '27867.67', '2016-09-29', '80', '12', '101', '10'),
('157', '20068.45', '2016-10-03', '93', '12', '107', '10');

### Structure of table `1_cust_branch` ###

DROP TABLE IF EXISTS `1_cust_branch`;

CREATE TABLE `1_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `br_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `branch_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `br_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT '0',
  `contact_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `receivables_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT '1',
  `disable_trans` tinyint(4) NOT NULL DEFAULT '0',
  `br_post_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT '0',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_code` (`branch_code`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_cust_branch` ###

INSERT INTO `1_cust_branch` VALUES
('1', '1', 'inbay', 'Inbay Limited', '45, Broadwick Street,\nLondon WIF 9QW', '1', '1', '', 'DEF', '2', '', '4510', '1200', '4500', '1', '0', '45, Broadwick Street,\nLondon WIF 9QW', '0', '', '0'),
('2', '2', 'Inbay Limited', 'Inbay Limited', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', '1', '1', '', 'DEF', '2', '4010', '4010', '1200', '4500', '1', '0', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', '2', '', '0');

### Structure of table `1_debtor_trans` ###

DROP TABLE IF EXISTS `1_debtor_trans`;

CREATE TABLE `1_debtor_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `version` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `debtor_no` int(11) unsigned DEFAULT NULL,
  `branch_code` int(11) NOT NULL DEFAULT '-1',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT '0',
  `order_` int(11) NOT NULL DEFAULT '0',
  `ov_amount` double NOT NULL DEFAULT '0',
  `ov_gst` double NOT NULL DEFAULT '0',
  `ov_freight` double NOT NULL DEFAULT '0',
  `ov_freight_tax` double NOT NULL DEFAULT '0',
  `ov_discount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  `ship_via` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `payment_terms` int(11) DEFAULT NULL,
  `done_by` int(2) NOT NULL,
  PRIMARY KEY (`type`,`trans_no`),
  KEY `debtor_no` (`debtor_no`,`branch_code`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_debtor_trans` ###

INSERT INTO `1_debtor_trans` VALUES
('1', '10', '0', '1', '1', '2010-11-23', '2012-03-17', '1', '1', '1', '1100325', '0', '0', '0', '0', '1100325', '1', '1', '0', '0', '1', '0'),
('2', '10', '0', '1', '1', '2010-12-13', '2010-12-17', '2', '1', '2', '1434045', '0', '0', '0', '0', '1434045', '1', '1', '0', '0', '1', '0'),
('3', '10', '0', '1', '1', '2011-01-14', '2011-01-17', '3', '1', '3', '1435915', '0', '0', '0', '0', '1435915', '1', '1', '0', '0', '1', '0'),
('4', '10', '0', '1', '1', '2011-02-18', '2011-03-17', '4', '1', '4', '1406415', '0', '0', '0', '0', '1406415', '1', '1', '0', '0', '1', '0'),
('5', '10', '0', '1', '1', '2011-03-17', '2011-04-17', '5', '1', '5', '1415415', '0', '0', '0', '0', '1415415', '1', '1', '0', '0', '1', '0'),
('6', '10', '0', '1', '1', '2011-04-27', '2011-05-17', '6', '1', '6', '1432415', '0', '0', '0', '0', '1432415', '1', '1', '0', '0', '1', '0'),
('7', '10', '0', '1', '1', '2011-05-20', '2011-05-30', '7', '1', '7', '1451439', '0', '0', '0', '0', '1451439', '1', '1', '0', '0', '3', '0'),
('8', '10', '0', '1', '1', '2011-06-20', '2011-07-17', '8', '1', '8', '1378415', '0', '0', '0', '0', '1378415', '1', '1', '0', '0', '1', '0'),
('9', '10', '0', '1', '1', '2011-07-21', '2011-08-17', '9', '1', '9', '1226434', '0', '0', '0', '0', '1226434', '1', '1', '0', '0', '1', '0'),
('10', '10', '0', '1', '1', '2011-08-22', '2011-09-17', '10', '1', '10', '1273934', '0', '0', '0', '0', '1273934', '1', '1', '0', '0', '1', '0'),
('11', '10', '0', '1', '1', '2011-09-21', '2011-10-17', '11', '1', '11', '1049751', '0', '0', '0', '0', '1049751', '1', '1', '0', '0', '1', '0'),
('12', '10', '0', '1', '1', '2011-10-21', '2011-11-17', '12', '1', '12', '1417608', '0', '0', '0', '0', '1417608', '1', '1', '0', '0', '1', '0'),
('13', '10', '0', '1', '1', '2011-11-21', '2011-12-17', '13', '1', '13', '1278308', '0', '0', '0', '0', '1278308', '1', '1', '0', '0', '1', '0'),
('14', '10', '0', '1', '1', '2011-12-20', '2012-01-17', '14', '1', '14', '1250308', '0', '0', '0', '0', '1250308', '1', '1', '0', '0', '1', '0'),
('15', '10', '0', '1', '1', '2012-01-23', '2012-02-17', '15', '1', '15', '1385911', '0', '0', '0', '0', '1385911', '1', '1', '0', '0', '1', '0'),
('16', '10', '0', '1', '1', '2012-02-20', '2012-03-17', '16', '1', '16', '1470462', '0', '0', '0', '0', '1470462', '1', '1', '0', '0', '1', '0'),
('17', '10', '0', '1', '1', '2012-03-20', '2012-04-17', '17', '1', '17', '1594273', '0', '0', '0', '0', '1594273', '1', '1', '0', '0', '1', '0'),
('18', '10', '3', '1', '1', '2012-04-20', '2012-05-17', '18', '2', '18', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('19', '10', '0', '2', '2', '2012-04-20', '2012-04-30', '19', '2', '19', '10900', '0', '0', '0', '0', '10900', '200.68', '1', '0', '0', '3', '0'),
('20', '10', '0', '2', '2', '2012-05-20', '2014-08-08', '20', '2', '20', '9032', '0', '0', '0', '0', '9032', '202.75', '1', '0', '0', '3', '0'),
('21', '10', '0', '2', '2', '2012-05-20', '2012-05-30', '21', '2', '21', '1196', '0', '0', '0', '0', '1196', '202.75', '1', '0', '0', '3', '0'),
('22', '10', '0', '2', '2', '2012-06-20', '2012-06-30', '22', '2', '22', '10722', '0', '0', '0', '0', '10722', '207.35', '1', '0', '0', '3', '0'),
('23', '10', '0', '2', '2', '2012-06-20', '2012-06-30', '23', '2', '23', '2193', '0', '0', '0', '0', '2193', '207.35', '1', '0', '0', '3', '0'),
('24', '10', '0', '2', '2', '2012-07-20', '2012-07-30', '24', '2', '24', '10620', '0', '0', '0', '0', '10620', '204.6', '1', '0', '0', '3', '0'),
('25', '10', '0', '2', '2', '2012-07-20', '2012-07-30', '25', '2', '25', '4380', '0', '0', '0', '0', '4380', '204.6', '1', '0', '0', '3', '0'),
('26', '10', '0', '2', '2', '2012-08-20', '2012-08-30', '26', '2', '26', '10699', '0', '0', '0', '0', '10699', '206.23', '1', '0', '0', '3', '0'),
('27', '10', '0', '2', '2', '2012-08-20', '2012-08-30', '27', '2', '27', '4344', '0', '0', '0', '0', '4344', '206.23', '1', '0', '0', '3', '0'),
('28', '10', '0', '2', '2', '2012-09-20', '2012-09-30', '28', '2', '28', '11008', '0', '0', '0', '0', '11008', '207.5', '1', '0', '0', '3', '0'),
('29', '10', '0', '2', '2', '2012-09-20', '2012-09-30', '29', '2', '29', '4418', '0', '0', '0', '0', '4418', '207.5', '1', '0', '0', '3', '0'),
('30', '10', '0', '2', '2', '2012-10-20', '2012-10-30', '30', '2', '30', '10302', '0', '0', '0', '0', '10302', '205.85', '1', '0', '0', '3', '0'),
('31', '10', '0', '2', '2', '2012-10-20', '2012-10-30', '31', '2', '31', '4386', '0', '0', '0', '0', '4386', '205.85', '1', '0', '0', '3', '0'),
('32', '10', '0', '2', '2', '2012-11-20', '2012-11-30', '32', '2', '32', '11165', '0', '0', '0', '0', '11165', '205.47', '1', '0', '0', '3', '0'),
('33', '10', '0', '2', '2', '2012-11-20', '2012-11-30', '33', '2', '33', '4615', '0', '0', '0', '0', '4615', '205.47', '1', '0', '0', '3', '0'),
('34', '10', '0', '2', '2', '2012-12-20', '2012-12-30', '34', '2', '34', '12004', '0', '0', '0', '0', '12004', '202.8', '1', '0', '0', '3', '0'),
('35', '10', '0', '2', '2', '2012-12-20', '2012-12-30', '35', '2', '35', '4747', '0', '0', '0', '0', '4747', '202.8', '1', '0', '0', '3', '0'),
('36', '10', '0', '2', '2', '2013-01-20', '2013-01-30', '36', '2', '36', '15924', '0', '0', '0', '0', '15924', '197.25', '1', '0', '0', '3', '0'),
('37', '10', '2', '2', '2', '2013-01-20', '2013-01-30', '37', '2', '37', '0', '0', '0', '0', '0', '0', '197.25', '1', '0', '0', '3', '0'),
('38', '10', '2', '2', '2', '2013-02-20', '2013-03-02', '38', '2', '38', '0', '0', '0', '0', '0', '0', '191.5', '1', '0', '0', '3', '0'),
('39', '10', '0', '2', '2', '2013-02-20', '2013-03-02', '39', '2', '39', '5097', '0', '0', '0', '0', '5097', '191.5', '1', '0', '0', '3', '0'),
('40', '10', '0', '2', '2', '2013-03-20', '2013-03-30', '40', '2', '40', '17396', '0', '0', '0', '0', '17396', '191.2', '1', '0', '0', '3', '0'),
('41', '10', '0', '2', '2', '2013-03-20', '2013-03-30', '41', '2', '41', '4665', '0', '0', '0', '0', '4665', '191.2', '1', '0', '0', '3', '0'),
('42', '10', '0', '2', '2', '2013-04-25', '2013-05-05', '42', '2', '42', '4657', '0', '0', '0', '0', '4657', '191.2', '1', '0', '0', '3', '0'),
('43', '10', '0', '2', '2', '2013-04-25', '2013-05-05', '43', '2', '43', '15962', '0', '0', '0', '0', '15962', '191.2', '1', '0', '0', '3', '0'),
('44', '10', '0', '2', '2', '2013-05-21', '2013-05-31', '44', '2', '44', '7043', '0', '0', '0', '0', '7043', '194.7', '1', '0', '0', '3', '0'),
('45', '10', '2', '2', '2', '2013-05-21', '2013-05-31', '45', '2', '45', '0', '0', '0', '0', '0', '0', '194.7', '1', '0', '0', '3', '0'),
('46', '10', '0', '2', '2', '2013-06-21', '2013-07-01', '46', '2', '46', '19169', '0', '0', '0', '0', '19169', '190.35', '1', '0', '0', '3', '0'),
('47', '10', '0', '2', '2', '2013-07-22', '2013-08-01', '47', '2', '47', '17178', '0', '0', '0', '0', '17178', '198.77', '1', '0', '0', '3', '0'),
('48', '10', '0', '2', '2', '2013-08-21', '2013-08-31', '48', '2', '48', '19708', '0', '0', '0', '0', '19708', '199.5', '1', '0', '0', '3', '0'),
('49', '10', '0', '2', '2', '2013-09-20', '2013-09-30', '49', '2', '49', '18502', '0', '0', '0', '0', '18502', '206', '1', '0', '0', '3', '0'),
('50', '10', '0', '2', '2', '2013-10-21', '2013-10-31', '50', '2', '50', '18828', '0', '0', '0', '0', '18828', '211.51', '1', '0', '0', '3', '0'),
('51', '10', '0', '2', '2', '2013-11-22', '2013-12-02', '51', '2', '51', '18134', '0', '0', '0', '0', '18134', '209.4', '1', '0', '0', '3', '0'),
('52', '10', '0', '2', '2', '2013-12-23', '2014-01-02', '52', '2', '52', '17960', '0', '0', '0', '0', '17960', '211.85', '1', '0', '0', '3', '0'),
('53', '10', '0', '2', '2', '2014-01-22', '2014-02-01', '53', '2', '53', '17056', '0', '0', '0', '0', '17056', '211.85', '1', '0', '0', '3', '0'),
('54', '10', '0', '2', '2', '2014-02-21', '2014-03-03', '54', '2', '54', '15864', '0', '0', '0', '0', '15864', '213.75', '1', '0', '0', '3', '0'),
('55', '10', '0', '2', '2', '2014-03-21', '2014-03-31', '55', '2', '55', '20027', '0', '0', '0', '0', '20027', '216', '1', '0', '0', '3', '0'),
('56', '10', '0', '2', '2', '2013-02-20', '2013-03-02', '56', '2', '56', '10560', '0', '0', '0', '0', '10560', '191.5', '1', '0', '0', '3', '0'),
('57', '10', '2', '1', '1', '2013-05-21', '2013-06-17', '45/1', '1', '57', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('58', '10', '2', '2', '2', '2013-05-21', '2013-05-31', '45/1', '2', '58', '0', '0', '0', '0', '0', '0', '194.7', '1', '0', '0', '3', '0'),
('59', '10', '0', '2', '2', '2013-05-21', '2013-05-31', '45/1', '2', '59', '10951', '0', '0', '0', '0', '10951', '194.7', '1', '0', '0', '3', '0'),
('60', '10', '0', '2', '2', '2014-04-25', '2014-05-05', '57', '2', '60', '15962', '0', '0', '0', '0', '15962', '215.92', '1', '0', '0', '3', '0'),
('61', '10', '0', '2', '2', '2014-05-25', '2014-06-04', '58', '2', '61', '17822', '0', '0', '0', '0', '17822', '218.42', '1', '0', '0', '3', '0'),
('62', '10', '2', '2', '2', '2014-06-25', '2014-07-05', '59', '2', '62', '0', '0', '0', '0', '0', '0', '217.62', '1', '0', '0', '3', '0'),
('63', '10', '2', '2', '2', '2014-07-25', '2014-08-04', '60', '2', '63', '0', '0', '0', '0', '0', '0', '221.08', '1', '0', '0', '3', '0'),
('64', '10', '0', '2', '2', '2014-08-25', '2014-09-04', '61', '2', '64', '19708', '0', '0', '0', '0', '19708', '220.54', '1', '0', '0', '3', '0'),
('65', '10', '0', '2', '2', '2014-09-25', '2014-10-05', '62', '2', '65', '20530', '0', '0', '0', '0', '20530', '215', '1', '0', '0', '3', '0'),
('66', '10', '0', '2', '2', '2014-10-25', '2014-11-04', '63', '2', '66', '20203', '0', '0', '0', '0', '20203', '215', '1', '0', '0', '3', '0'),
('67', '10', '2', '2', '2', '2014-11-25', '2014-12-05', '64', '2', '67', '0', '0', '0', '0', '0', '0', '215', '1', '0', '0', '3', '0'),
('68', '10', '0', '2', '2', '2014-12-24', '2015-01-03', '65', '2', '68', '20147', '0', '0', '0', '0', '20147', '215', '1', '0', '0', '3', '0'),
('69', '10', '0', '2', '2', '2015-01-25', '2015-02-04', '66', '2', '69', '22340', '0', '0', '0', '0', '22340', '215', '1', '0', '0', '3', '0'),
('70', '10', '0', '2', '2', '2015-02-25', '2015-03-07', '67', '2', '70', '25071', '0', '0', '0', '0', '25071', '215', '1', '0', '0', '3', '0'),
('71', '10', '2', '2', '2', '2015-10-20', '2015-10-30', '68', '2', '71', '0', '0', '0', '0', '0', '0', '215', '1', '0', '0', '3', '0'),
('72', '10', '0', '2', '2', '2015-03-25', '2015-04-04', '68', '2', '72', '23042', '0', '0', '0', '0', '23042', '204.75', '1', '0', '0', '3', '0'),
('73', '10', '2', '2', '2', '2014-07-25', '2014-08-04', '69', '2', '73', '0', '0', '0', '0', '0', '0', '221.08', '1', '0', '0', '3', '0'),
('74', '10', '2', '2', '2', '2014-12-29', '2015-01-08', '70', '2', '74', '0', '0', '0', '0', '0', '0', '204.87', '1', '0', '0', '3', '0'),
('75', '10', '0', '2', '2', '2014-06-28', '2014-07-08', '71', '2', '75', '11298', '0', '0', '0', '0', '11298', '217.62', '1', '0', '0', '3', '0'),
('76', '10', '0', '2', '2', '2014-07-25', '2014-08-04', '72', '2', '76', '11245', '0', '0', '0', '0', '11245', '221.08', '1', '0', '0', '3', '0'),
('77', '10', '0', '2', '2', '2014-11-28', '2014-12-08', '73', '2', '77', '19055', '0', '0', '0', '0', '19055', '207.25', '1', '0', '0', '3', '0'),
('78', '10', '2', '2', '2', '2015-12-20', '2015-12-30', '74', '2', '78', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('79', '10', '2', '2', '2', '2014-12-21', '2014-12-31', '75', '2', '79', '0', '0', '0', '0', '0', '0', '207.25', '1', '0', '0', '3', '0'),
('80', '10', '0', '2', '2', '2014-12-21', '2014-12-31', '76', '2', '80', '28250', '0', '0', '0', '0', '28250', '207.25', '1', '0', '0', '3', '0'),
('81', '10', '2', '2', '2', '2015-04-20', '2015-04-30', '77', '2', '81', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('82', '10', '2', '2', '2', '2015-05-20', '2015-05-30', '78', '2', '82', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('83', '10', '2', '2', '2', '2015-06-20', '2015-06-30', '79', '2', '83', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('84', '10', '2', '2', '2', '2015-07-20', '2015-07-30', '80', '2', '84', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('85', '10', '2', '2', '2', '2015-08-20', '2015-08-30', '81', '2', '85', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('86', '10', '2', '2', '2', '2015-09-20', '2015-09-30', '82', '2', '86', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('87', '10', '2', '2', '2', '2015-10-20', '2015-10-30', '83', '2', '87', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('88', '10', '2', '2', '2', '2015-11-20', '2015-11-30', '84', '2', '88', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('89', '10', '2', '2', '2', '2015-12-20', '2015-12-30', '85', '2', '89', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('90', '10', '2', '2', '2', '2016-01-20', '2016-01-30', '86', '2', '90', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('91', '10', '2', '2', '2', '2016-02-20', '2016-03-01', '87', '2', '91', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('92', '10', '2', '2', '2', '2016-03-20', '2016-03-30', '88', '2', '92', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('93', '10', '0', '2', '2', '2016-04-26', '2016-05-06', '89', '2', '93', '35943', '0', '0', '0', '0', '35943', '209.5', '1', '0', '0', '3', '0'),
('94', '10', '2', '1', '1', '2016-04-26', '2016-05-17', '90', '1', '94', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('95', '10', '0', '2', '2', '2015-04-20', '2015-04-30', '90', '2', '95', '26926.69', '0', '0', '0', '0', '26926.69', '197.27', '1', '0', '0', '3', '0'),
('96', '10', '0', '2', '2', '2015-05-20', '2015-05-30', '91', '2', '96', '30933.76', '0', '0', '0', '0', '30933.76', '204.6', '1', '0', '0', '3', '0'),
('97', '10', '0', '2', '2', '2015-06-20', '2015-06-30', '92', '2', '97', '28266.76', '0', '0', '0', '0', '28266.76', '208.43', '1', '0', '0', '3', '0'),
('98', '10', '0', '2', '2', '2015-07-20', '2015-07-30', '93', '2', '98', '29110.73', '0', '0', '0', '0', '29110.73', '209.25', '1', '0', '0', '3', '0'),
('99', '10', '0', '2', '2', '2015-08-20', '2015-08-30', '94', '2', '99', '28209.78', '0', '0', '0', '0', '28209.78', '206.75', '1', '0', '0', '3', '0'),
('100', '10', '0', '2', '2', '2015-09-20', '2015-09-30', '95', '2', '100', '27740.63', '0', '0', '0', '0', '27740.63', '208', '1', '0', '0', '3', '0'),
('101', '10', '0', '2', '2', '2015-10-20', '2015-10-30', '96', '2', '101', '27867.67', '0', '0', '0', '0', '27867.67', '213', '1', '0', '0', '3', '0'),
('102', '10', '0', '2', '2', '2015-11-20', '2015-11-30', '97', '2', '102', '31174.63', '0', '0', '0', '0', '31174.63', '214.65', '1', '0', '0', '3', '0'),
('103', '10', '0', '2', '2', '2015-12-20', '2015-12-30', '98', '2', '103', '32631.57', '0', '0', '0', '0', '32631.57', '214.65', '1', '0', '0', '3', '0'),
('104', '10', '2', '2', '2', '2016-01-20', '2016-01-30', '99', '2', '104', '0', '0', '0', '0', '0', '0', '213.82', '1', '0', '0', '3', '0'),
('105', '10', '0', '2', '2', '2016-02-20', '2016-03-01', '100', '2', '105', '36846.36', '0', '0', '0', '0', '36846.36', '204.4', '1', '0', '0', '3', '0'),
('106', '10', '0', '2', '2', '2016-03-20', '2016-03-30', '101', '2', '106', '34309.4', '0', '0', '0', '0', '34309.4', '200.71', '1', '0', '0', '3', '0'),
('107', '10', '0', '2', '2', '2016-01-20', '2016-01-30', '102', '2', '107', '20068.45', '0', '0', '0', '0', '20068.45', '213.82', '1', '0', '0', '3', '0'),
('1', '11', '0', '1', '1', '2012-04-20', '0000-00-00', '1', '2', '18', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('2', '11', '2', '2', '2', '2016-03-28', '0000-00-00', '2', '2', '0', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('3', '11', '0', '2', '2', '2015-03-28', '0000-00-00', '2', '2', '0', '3.4', '0', '0', '0', '0', '3.4', '197.27', '1', '0', '0', '3', '0'),
('1', '12', '0', '1', '1', '2010-11-29', '0000-00-00', '1', '0', '0', '1100325', '0', '0', '0', '0', '1100325', '1', '0', '0', '0', NULL, '0'),
('2', '12', '2', '1', '1', '2010-11-29', '0000-00-00', '2', '0', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', NULL, '0'),
('3', '12', '0', '1', '1', '2010-11-24', '0000-00-00', '3', '0', '0', '1600', '0', '0', '0', '0', '1600', '1', '0', '0', '0', NULL, '0'),
('4', '12', '0', '1', '1', '2011-01-25', '0000-00-00', '4', '0', '0', '1435915', '0', '0', '0', '0', '1435915', '1', '0', '0', '0', NULL, '0'),
('5', '12', '0', '1', '1', '2011-02-25', '0000-00-00', '5', '0', '0', '1406415', '0', '0', '0', '0', '1406415', '1', '0', '0', '0', NULL, '0'),
('6', '12', '0', '1', '1', '2011-03-25', '0000-00-00', '6', '0', '0', '1415415', '0', '0', '0', '0', '1415415', '1', '0', '0', '0', NULL, '0'),
('7', '12', '0', '1', '1', '2010-11-29', '0000-00-00', '7', '0', '0', '1089045', '0', '0', '0', '0', '1089045', '1', '0', '0', '0', NULL, '0'),
('8', '12', '0', '1', '1', '2010-11-30', '0000-00-00', '8', '0', '0', '343400', '0', '0', '0', '0', '343400', '1', '0', '0', '0', NULL, '0'),
('9', '12', '0', '1', '1', '2011-04-30', '0000-00-00', '9', '0', '0', '1432415', '0', '0', '0', '0', '1432415', '1', '0', '0', '0', NULL, '0'),
('10', '12', '0', '1', '1', '2011-05-27', '0000-00-00', '10', '0', '0', '1451439', '0', '0', '0', '0', '1451439', '1', '0', '0', '0', NULL, '0'),
('11', '12', '0', '1', '1', '2011-06-28', '0000-00-00', '11', '0', '0', '1378415', '0', '0', '0', '0', '1378415', '1', '0', '0', '0', NULL, '0'),
('12', '12', '0', '1', '1', '2011-07-28', '0000-00-00', '12', '0', '0', '1226434', '0', '0', '0', '0', '1226434', '1', '0', '0', '0', NULL, '0'),
('13', '12', '0', '1', '1', '2011-08-28', '0000-00-00', '13', '0', '0', '1273934', '0', '0', '0', '0', '1273934', '1', '0', '0', '0', NULL, '0'),
('14', '12', '0', '1', '1', '2011-09-28', '0000-00-00', '14', '0', '0', '1049751', '0', '0', '0', '0', '1049751', '1', '0', '0', '0', NULL, '0'),
('15', '12', '0', '1', '1', '2011-10-27', '0000-00-00', '15', '0', '0', '1417608', '0', '0', '0', '0', '1417608', '1', '0', '0', '0', NULL, '0'),
('16', '12', '0', '1', '1', '2011-11-27', '0000-00-00', '16', '0', '0', '1278308', '0', '0', '0', '0', '1278308', '1', '0', '0', '0', NULL, '0'),
('17', '12', '0', '1', '1', '2011-12-27', '0000-00-00', '17', '0', '0', '1250308', '0', '0', '0', '0', '1250308', '1', '0', '0', '0', NULL, '0'),
('18', '12', '0', '1', '1', '2012-01-27', '0000-00-00', '18', '0', '0', '1385911', '0', '0', '0', '0', '1385911', '1', '0', '0', '0', NULL, '0'),
('19', '12', '0', '1', '1', '2012-02-27', '0000-00-00', '19', '0', '0', '1470462', '0', '0', '0', '0', '1470462', '1', '0', '0', '0', NULL, '0'),
('20', '12', '0', '1', '1', '2012-03-29', '0000-00-00', '20', '0', '0', '1594273', '0', '0', '0', '0', '1594273', '1', '0', '0', '0', NULL, '0'),
('21', '12', '0', '2', '2', '2012-04-30', '0000-00-00', '21', '0', '0', '10900', '0', '0', '0', '0', '10900', '200.68', '0', '0', '0', NULL, '0'),
('22', '12', '0', '2', '2', '2012-05-31', '0000-00-00', '22', '0', '0', '9032', '0', '0', '0', '0', '9032', '202.75', '0', '0', '0', NULL, '0'),
('23', '12', '0', '2', '2', '2012-05-31', '0000-00-00', '23', '0', '0', '1196', '0', '0', '0', '0', '1196', '202.75', '0', '0', '0', NULL, '0'),
('24', '12', '0', '2', '2', '2012-06-30', '0000-00-00', '24', '0', '0', '10722', '0', '0', '0', '0', '10722', '207.35', '0', '0', '0', NULL, '0'),
('25', '12', '0', '2', '2', '2012-06-30', '0000-00-00', '25', '0', '0', '2193', '0', '0', '0', '0', '2193', '207.35', '0', '0', '0', NULL, '0'),
('26', '12', '0', '2', '2', '2012-07-31', '0000-00-00', '26', '0', '0', '10620', '0', '0', '0', '0', '10620', '204.6', '0', '0', '0', NULL, '0'),
('27', '12', '0', '2', '2', '2012-07-31', '0000-00-00', '27', '0', '0', '4380', '0', '0', '0', '0', '4380', '204.6', '0', '0', '0', NULL, '0'),
('28', '12', '0', '2', '2', '2012-08-31', '0000-00-00', '28', '0', '0', '10699', '0', '0', '0', '0', '10699', '206.23', '0', '0', '0', NULL, '0'),
('29', '12', '0', '2', '2', '2012-08-31', '0000-00-00', '29', '0', '0', '4344', '0', '0', '0', '0', '4344', '206.23', '0', '0', '0', NULL, '0'),
('30', '12', '0', '2', '2', '2012-09-30', '0000-00-00', '30', '0', '0', '11008', '0', '0', '0', '0', '11008', '207.5', '0', '0', '0', NULL, '0'),
('31', '12', '0', '2', '2', '2012-09-30', '0000-00-00', '31', '0', '0', '4418', '0', '0', '0', '0', '4418', '207.5', '0', '0', '0', NULL, '0'),
('32', '12', '0', '2', '2', '2012-10-31', '0000-00-00', '32', '0', '0', '10302', '0', '0', '0', '0', '10302', '205.85', '0', '0', '0', NULL, '0'),
('33', '12', '0', '2', '2', '2012-10-31', '0000-00-00', '33', '0', '0', '4386', '0', '0', '0', '0', '4386', '205.85', '0', '0', '0', NULL, '0'),
('34', '12', '0', '2', '2', '2012-11-30', '0000-00-00', '34', '0', '0', '11165', '0', '0', '0', '0', '11165', '205.47', '0', '0', '0', NULL, '0'),
('35', '12', '0', '2', '2', '2012-11-30', '0000-00-00', '35', '0', '0', '4615', '0', '0', '0', '0', '4615', '205.47', '0', '0', '0', NULL, '0'),
('36', '12', '0', '2', '2', '2012-12-31', '0000-00-00', '36', '0', '0', '12004', '0', '0', '0', '0', '12004', '202.8', '0', '0', '0', NULL, '0'),
('37', '12', '0', '2', '2', '2012-12-31', '0000-00-00', '37', '0', '0', '4747', '0', '0', '0', '0', '4747', '202.8', '0', '0', '0', NULL, '0'),
('38', '12', '0', '2', '2', '2013-01-31', '0000-00-00', '38', '0', '0', '15924', '0', '0', '0', '0', '15924', '197.25', '0', '0', '0', NULL, '0'),
('39', '12', '2', '2', '2', '2013-01-31', '0000-00-00', '39', '0', '0', '0', '0', '0', '0', '0', '0', '197.25', '0', '0', '0', NULL, '0'),
('40', '12', '2', '2', '2', '2013-02-28', '0000-00-00', '40', '0', '0', '0', '0', '0', '0', '0', '0', '191.5', '0', '0', '0', NULL, '0'),
('41', '12', '0', '2', '2', '2013-02-28', '0000-00-00', '41', '0', '0', '5097', '0', '0', '0', '0', '5097', '191.5', '0', '0', '0', NULL, '0'),
('42', '12', '0', '2', '2', '2013-03-31', '0000-00-00', '42', '0', '0', '17396', '0', '0', '0', '0', '17396', '191.2', '0', '0', '0', NULL, '0'),
('43', '12', '0', '2', '2', '2013-03-31', '0000-00-00', '43', '0', '0', '4665', '0', '0', '0', '0', '4665', '191.2', '0', '0', '0', NULL, '0'),
('44', '12', '0', '2', '2', '2013-04-29', '0000-00-00', '44', '0', '0', '20619', '0', '0', '0', '0', '20619', '194.7', '0', '0', '0', NULL, '0'),
('45', '12', '2', '2', '2', '2013-05-27', '0000-00-00', '45', '0', '0', '17994', '0', '0', '0', '0', '17994', '194.7', '0', '0', '0', '0', '0'),
('46', '12', '0', '2', '2', '2013-06-26', '0000-00-00', '46', '0', '0', '19169', '0', '0', '0', '0', '19169', '190.35', '0', '0', '0', NULL, '0'),
('47', '12', '0', '2', '2', '2013-07-30', '0000-00-00', '47', '0', '0', '17178', '0', '0', '0', '0', '17178', '198.77', '0', '0', '0', NULL, '0'),
('48', '12', '0', '2', '2', '2013-08-29', '0000-00-00', '48', '0', '0', '19708', '0', '0', '0', '0', '19708', '199.5', '0', '0', '0', NULL, '0'),
('49', '12', '0', '2', '2', '2013-09-30', '0000-00-00', '49', '0', '0', '18502', '0', '0', '0', '0', '18502', '211.51', '0', '0', '0', NULL, '0'),
('50', '12', '0', '2', '2', '2013-10-30', '0000-00-00', '50', '0', '0', '18828', '0', '0', '0', '0', '18828', '209.4', '0', '0', '0', NULL, '0'),
('51', '12', '0', '2', '2', '2013-11-28', '0000-00-00', '51', '0', '0', '18134', '0', '0', '0', '0', '18134', '211.85', '0', '0', '0', NULL, '0'),
('52', '12', '0', '2', '2', '2013-12-30', '0000-00-00', '52', '0', '0', '17960', '0', '0', '0', '0', '17960', '211.85', '0', '0', '0', NULL, '0'),
('53', '12', '0', '2', '2', '2013-12-30', '0000-00-00', '53', '0', '0', '17056', '0', '0', '0', '0', '17056', '211.85', '0', '0', '0', NULL, '0'),
('54', '12', '0', '2', '2', '2014-02-28', '0000-00-00', '54', '0', '0', '15864', '0', '0', '0', '0', '15864', '217.75', '0', '0', '0', NULL, '0'),
('55', '12', '2', '2', '2', '2013-02-28', '0000-00-00', '55', '0', '0', '10560', '0', '0', '0', '0', '10560', '205.5', '0', '0', '0', '0', '0'),
('56', '12', '0', '2', '2', '2014-03-30', '0000-00-00', '56', '0', '0', '20027', '0', '0', '0', '0', '20027', '215.92', '0', '0', '0', NULL, '0'),
('57', '12', '1', '2', '2', '2014-04-25', '0000-00-00', '57', '0', '0', '15962', '0', '0', '0', '0', '15962', '215.92', '0', '0', '0', '0', '0'),
('58', '12', '0', '2', '2', '2014-05-28', '0000-00-00', '58', '0', '0', '17822', '0', '0', '0', '0', '17822', '218.42', '0', '0', '0', NULL, '0'),
('59', '12', '2', '2', '2', '2014-06-28', '0000-00-00', '59', '0', '0', '0', '0', '0', '0', '0', '0', '217.62', '0', '0', '0', NULL, '0'),
('60', '12', '1', '2', '2', '2014-08-25', '0000-00-00', '60', '0', '0', '19708', '0', '0', '0', '0', '19708', '220.54', '0', '0', '0', '0', '0'),
('61', '12', '2', '2', '2', '2014-09-29', '0000-00-00', '61', '0', '0', '20530', '0', '0', '0', '0', '20530', '211.1', '0', '0', '0', '0', '0'),
('62', '12', '0', '2', '2', '2014-10-28', '0000-00-00', '62', '0', '0', '20203', '0', '0', '0', '0', '20203', '209.4', '0', '0', '0', NULL, '0'),
('63', '12', '2', '2', '2', '2014-11-28', '0000-00-00', '63', '0', '0', '0', '0', '0', '0', '0', '0', '207.25', '0', '0', '0', NULL, '0'),
('64', '12', '4', '2', '2', '2014-12-29', '0000-00-00', '64', '0', '0', '20147', '0', '0', '0', '0', '20147', '204.87', '0', '0', '0', '0', '0'),
('65', '12', '0', '2', '2', '2015-01-28', '0000-00-00', '65', '0', '0', '22340', '0', '0', '0', '0', '22340', '199.1', '0', '0', '0', NULL, '0'),
('66', '12', '0', '2', '2', '2015-02-28', '0000-00-00', '66', '0', '0', '25071', '0', '0', '0', '0', '25071', '204.75', '0', '0', '0', NULL, '0'),
('67', '12', '1', '2', '2', '2015-03-28', '0000-00-00', '67', '0', '0', '23038.6', '0', '0', '0', '0', '23038.6', '197.27', '0', '0', '0', '0', '0'),
('68', '12', '3', '2', '2', '2014-07-25', '0000-00-00', '68', '0', '0', '0', '0', '0', '0', '0', '0', '221.08', '0', '0', '0', '0', '0'),
('69', '12', '2', '2', '2', '2014-12-29', '0000-00-00', '69', '0', '0', '0', '0', '0', '0', '0', '0', '204.87', '0', '0', '0', NULL, '0'),
('70', '12', '0', '2', '2', '2014-06-28', '0000-00-00', '70', '0', '0', '11298', '0', '0', '0', '0', '11298', '217.62', '0', '0', '0', NULL, '0'),
('71', '12', '0', '2', '2', '2014-07-25', '0000-00-00', '71', '0', '0', '11245', '0', '0', '0', '0', '11245', '221.08', '0', '0', '0', NULL, '0'),
('72', '12', '0', '2', '2', '2014-11-28', '0000-00-00', '72', '0', '0', '19055', '0', '0', '0', '0', '19055', '207.25', '0', '0', '0', NULL, '0'),
('73', '12', '0', '2', '2', '2014-12-23', '0000-00-00', '73', '0', '0', '28250', '0', '0', '0', '0', '28250', '207.25', '0', '0', '0', NULL, '0'),
('74', '12', '1', '2', '2', '2015-04-28', '0000-00-00', '74', '0', '0', '26926.69', '0', '0', '0', '0', '26926.69', '197.27', '0', '0', '0', '0', '0'),
('75', '12', '1', '2', '2', '2015-05-25', '0000-00-00', '75', '0', '0', '0', '0', '0', '0', '0', '0', '197.27', '0', '0', '0', '0', '0'),
('76', '12', '1', '2', '2', '2015-06-25', '0000-00-00', '76', '0', '0', '0', '0', '0', '0', '0', '0', '208.43', '0', '0', '0', '0', '0'),
('77', '12', '3', '2', '2', '2015-07-27', '0000-00-00', '77', '0', '0', '29110.73', '0', '0', '0', '0', '29110.73', '209.25', '0', '0', '0', '0', '0'),
('78', '12', '2', '2', '2', '2015-08-26', '0000-00-00', '78', '0', '0', '28209.78', '0', '0', '0', '0', '28209.78', '206.75', '0', '0', '0', '0', '0'),
('79', '12', '4', '2', '2', '2015-09-28', '0000-00-00', '79', '0', '0', '27740.63', '0', '0', '0', '0', '27740.63', '213', '0', '0', '0', '0', '0'),
('80', '12', '5', '2', '2', '2015-10-28', '0000-00-00', '80', '0', '0', '27867.67', '0', '0', '0', '0', '27867.67', '214.65', '0', '0', '0', '0', '0'),
('81', '12', '2', '2', '2', '2015-11-26', '0000-00-00', '81', '0', '0', '31174.63', '0', '0', '0', '0', '31174.63', '214.65', '0', '0', '0', '0', '0'),
('82', '12', '2', '2', '2', '2015-12-23', '0000-00-00', '82', '0', '0', '32631.57', '0', '0', '0', '0', '32631.57', '214.65', '0', '0', '0', '0', '0'),
('83', '12', '5', '2', '2', '2016-01-27', '0000-00-00', '83', '0', '0', '0', '0', '0', '0', '0', '0', '213.82', '0', '0', '0', '0', '0'),
('84', '12', '3', '2', '2', '2016-03-01', '0000-00-00', '84', '0', '0', '36846.36', '0', '0', '0', '0', '36846.36', '200.71', '0', '0', '0', '0', '0'),
('85', '12', '3', '2', '2', '2016-03-28', '0000-00-00', '85', '0', '0', '34309.4', '0', '0', '0', '0', '34309.4', '200.71', '0', '0', '0', '0', '0'),
('86', '12', '2', '2', '2', '2016-04-26', '0000-00-00', '86', '0', '0', '0', '0', '0', '0', '0', '0', '209.5', '0', '0', '0', NULL, '0'),
('87', '12', '2', '1', '1', '2016-04-26', '0000-00-00', '87', '0', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', NULL, '0'),
('88', '12', '2', '2', '2', '2016-04-26', '0000-00-00', '87/1', '0', '0', '0', '0', '0', '0', '0', '0', '209.5', '0', '0', '0', NULL, '0'),
('89', '12', '2', '2', '2', '2016-04-26', '0000-00-00', '88', '0', '0', '0', '0', '0', '0', '0', '0', '209.5', '0', '0', '0', NULL, '0'),
('90', '12', '0', '2', '2', '2016-04-26', '0000-00-00', '89', '0', '0', '35943', '0', '0', '0', '0', '35943', '209.5', '0', '0', '0', NULL, '0'),
('91', '12', '3', '2', '2', '2015-06-25', '0000-00-00', '79.', '0', '0', '28266.76', '0', '0', '0', '0', '28266.76', '208.43', '0', '0', '0', '0', '0'),
('92', '12', '1', '2', '2', '2015-05-25', '0000-00-00', '87/2', '0', '0', '30933.76', '0', '0', '0', '0', '30933.76', '204.6', '0', '0', '0', '0', '0'),
('93', '12', '0', '2', '2', '2016-01-27', '0000-00-00', '144/1', '0', '0', '20068.45', '0', '0', '0', '0', '20068.45', '213.82', '0', '0', '0', NULL, '0'),
('1', '13', '1', '1', '1', '2010-11-23', '2010-12-17', 'auto', '1', '1', '1100325', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('2', '13', '1', '1', '1', '2010-12-13', '2011-01-17', 'auto', '1', '2', '1434045', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('3', '13', '1', '1', '1', '2011-01-14', '2011-02-17', 'auto', '1', '3', '1435915', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('4', '13', '2', '1', '1', '2011-01-14', '2011-02-17', 'auto', '1', '4', '1406415', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('5', '13', '2', '1', '1', '2011-01-14', '2011-02-17', 'auto', '1', '5', '1415415', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('6', '13', '1', '1', '1', '2011-04-27', '2011-05-17', 'auto', '1', '6', '1432415', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('7', '13', '1', '1', '1', '2011-05-20', '2011-05-30', 'auto', '1', '7', '1451439', '0', '0', '0', '0', '0', '1', '1', '0', '0', '3', '0'),
('8', '13', '1', '1', '1', '2011-06-20', '2011-07-17', 'auto', '1', '8', '1378415', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('9', '13', '1', '1', '1', '2011-07-21', '2011-08-17', 'auto', '1', '9', '1226434', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('10', '13', '1', '1', '1', '2011-08-22', '2011-09-17', 'auto', '1', '10', '1273934', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('11', '13', '1', '1', '1', '2011-09-21', '2011-10-17', 'auto', '1', '11', '1049751', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('12', '13', '1', '1', '1', '2011-10-21', '2011-11-17', 'auto', '1', '12', '1417608', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('13', '13', '1', '1', '1', '2011-11-21', '2011-12-17', 'auto', '1', '13', '1278308', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('14', '13', '1', '1', '1', '2011-12-20', '2012-01-17', 'auto', '1', '14', '1250308', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('15', '13', '1', '1', '1', '2012-01-23', '2012-02-17', 'auto', '1', '15', '1385911', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('16', '13', '1', '1', '1', '2012-02-20', '2012-03-17', 'auto', '1', '16', '1470462', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('17', '13', '1', '1', '1', '2012-03-20', '2012-04-17', 'auto', '1', '17', '1594273', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('18', '13', '2', '1', '1', '2012-04-20', '2012-05-17', 'auto', '2', '18', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('19', '13', '1', '2', '2', '2012-04-20', '2012-04-30', 'auto', '2', '19', '10900', '0', '0', '0', '0', '0', '200.68', '1', '0', '0', '3', '0'),
('20', '13', '1', '2', '2', '2012-05-20', '2014-08-08', 'auto', '2', '20', '9032', '0', '0', '0', '0', '0', '202.75', '1', '0', '0', '3', '0'),
('21', '13', '1', '2', '2', '2012-05-20', '2012-05-30', 'auto', '2', '21', '1196', '0', '0', '0', '0', '0', '202.75', '1', '0', '0', '3', '0'),
('22', '13', '1', '2', '2', '2012-06-20', '2012-06-30', 'auto', '2', '22', '10722', '0', '0', '0', '0', '0', '207.35', '1', '0', '0', '3', '0'),
('23', '13', '1', '2', '2', '2012-06-20', '2012-06-30', 'auto', '2', '23', '2193', '0', '0', '0', '0', '0', '207.35', '1', '0', '0', '3', '0'),
('24', '13', '1', '2', '2', '2012-07-20', '2012-07-30', 'auto', '2', '24', '10620', '0', '0', '0', '0', '0', '204.6', '1', '0', '0', '3', '0'),
('25', '13', '1', '2', '2', '2012-07-20', '2012-07-30', 'auto', '2', '25', '4380', '0', '0', '0', '0', '0', '204.6', '1', '0', '0', '3', '0'),
('26', '13', '1', '2', '2', '2012-08-20', '2012-08-30', 'auto', '2', '26', '10699', '0', '0', '0', '0', '0', '206.23', '1', '0', '0', '3', '0'),
('27', '13', '1', '2', '2', '2012-08-20', '2012-08-30', 'auto', '2', '27', '4344', '0', '0', '0', '0', '0', '206.23', '1', '0', '0', '3', '0'),
('28', '13', '1', '2', '2', '2012-09-20', '2012-09-30', 'auto', '2', '28', '11008', '0', '0', '0', '0', '0', '207.5', '1', '0', '0', '3', '0'),
('29', '13', '1', '2', '2', '2012-09-20', '2012-09-30', 'auto', '2', '29', '4418', '0', '0', '0', '0', '0', '207.5', '1', '0', '0', '3', '0'),
('30', '13', '1', '2', '2', '2012-10-20', '2012-10-30', 'auto', '2', '30', '10302', '0', '0', '0', '0', '0', '205.85', '1', '0', '0', '3', '0'),
('31', '13', '1', '2', '2', '2012-10-20', '2012-10-30', 'auto', '2', '31', '4386', '0', '0', '0', '0', '0', '205.85', '1', '0', '0', '3', '0'),
('32', '13', '1', '2', '2', '2012-11-20', '2012-11-30', 'auto', '2', '32', '11165', '0', '0', '0', '0', '0', '205.47', '1', '0', '0', '3', '0'),
('33', '13', '1', '2', '2', '2012-11-20', '2012-11-30', 'auto', '2', '33', '4615', '0', '0', '0', '0', '0', '205.47', '1', '0', '0', '3', '0'),
('34', '13', '1', '2', '2', '2012-12-20', '2012-12-30', 'auto', '2', '34', '12004', '0', '0', '0', '0', '0', '202.8', '1', '0', '0', '3', '0'),
('35', '13', '1', '2', '2', '2012-12-20', '2012-12-30', 'auto', '2', '35', '4747', '0', '0', '0', '0', '0', '202.8', '1', '0', '0', '3', '0'),
('36', '13', '1', '2', '2', '2013-01-20', '2013-01-30', 'auto', '2', '36', '15924', '0', '0', '0', '0', '0', '197.25', '1', '0', '0', '3', '0'),
('37', '13', '2', '2', '2', '2013-01-20', '2013-01-30', 'auto', '2', '37', '0', '0', '0', '0', '0', '0', '197.25', '1', '0', '0', '3', '0'),
('38', '13', '2', '2', '2', '2013-02-20', '2013-03-02', 'auto', '2', '38', '0', '0', '0', '0', '0', '0', '191.5', '1', '0', '0', '3', '0'),
('39', '13', '1', '2', '2', '2013-02-20', '2013-03-02', 'auto', '2', '39', '5097', '0', '0', '0', '0', '0', '191.5', '1', '0', '0', '3', '0'),
('40', '13', '2', '2', '2', '2013-03-20', '2013-03-30', 'auto', '2', '40', '17396', '0', '0', '0', '0', '0', '191.2', '1', '0', '0', '3', '0'),
('41', '13', '1', '2', '2', '2013-03-20', '2013-03-30', 'auto', '2', '41', '4665', '0', '0', '0', '0', '0', '191.2', '1', '0', '0', '3', '0'),
('42', '13', '1', '2', '2', '2013-04-25', '2013-05-05', 'auto', '2', '42', '4657', '0', '0', '0', '0', '0', '191.2', '1', '0', '0', '3', '0'),
('43', '13', '1', '2', '2', '2013-04-25', '2013-05-05', 'auto', '2', '43', '15962', '0', '0', '0', '0', '0', '191.2', '1', '0', '0', '3', '0'),
('44', '13', '1', '2', '2', '2013-05-21', '2013-05-31', 'auto', '2', '44', '7043', '0', '0', '0', '0', '0', '194.7', '1', '0', '0', '3', '0'),
('45', '13', '2', '2', '2', '2013-05-21', '2013-05-31', 'auto', '2', '45', '0', '0', '0', '0', '0', '0', '194.7', '1', '0', '0', '3', '0'),
('46', '13', '1', '2', '2', '2013-06-21', '2013-07-01', 'auto', '2', '46', '19169', '0', '0', '0', '0', '0', '190.35', '1', '0', '0', '3', '0'),
('47', '13', '1', '2', '2', '2013-07-22', '2013-08-01', 'auto', '2', '47', '17178', '0', '0', '0', '0', '0', '198.77', '1', '0', '0', '3', '0'),
('48', '13', '1', '2', '2', '2013-08-21', '2013-08-31', 'auto', '2', '48', '19708', '0', '0', '0', '0', '0', '199.5', '1', '0', '0', '3', '0'),
('49', '13', '1', '2', '2', '2013-09-20', '2013-09-30', 'auto', '2', '49', '18502', '0', '0', '0', '0', '0', '206', '1', '0', '0', '3', '0'),
('50', '13', '1', '2', '2', '2013-10-21', '2013-10-31', 'auto', '2', '50', '18828', '0', '0', '0', '0', '0', '211.51', '1', '0', '0', '3', '0'),
('51', '13', '1', '2', '2', '2013-11-22', '2013-12-02', 'auto', '2', '51', '18134', '0', '0', '0', '0', '0', '209.4', '1', '0', '0', '3', '0'),
('52', '13', '1', '2', '2', '2013-12-23', '2014-01-02', 'auto', '2', '52', '17960', '0', '0', '0', '0', '0', '211.85', '1', '0', '0', '3', '0'),
('53', '13', '1', '2', '2', '2014-01-22', '2014-02-01', 'auto', '2', '53', '17056', '0', '0', '0', '0', '0', '211.85', '1', '0', '0', '3', '0'),
('54', '13', '1', '2', '2', '2014-02-21', '2014-03-03', 'auto', '2', '54', '15864', '0', '0', '0', '0', '0', '213.75', '1', '0', '0', '3', '0'),
('55', '13', '1', '2', '2', '2014-03-21', '2014-03-31', 'auto', '2', '55', '20027', '0', '0', '0', '0', '0', '216', '1', '0', '0', '3', '0'),
('56', '13', '1', '2', '2', '2013-02-20', '2013-03-02', 'auto', '2', '56', '10560', '0', '0', '0', '0', '0', '191.5', '1', '0', '0', '3', '0'),
('57', '13', '2', '1', '1', '2013-05-21', '2013-06-17', 'auto', '1', '57', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('58', '13', '2', '2', '2', '2013-05-21', '2013-05-31', 'auto', '2', '58', '0', '0', '0', '0', '0', '0', '194.7', '1', '0', '0', '3', '0'),
('59', '13', '1', '2', '2', '2013-05-21', '2013-05-31', 'auto', '2', '59', '10951', '0', '0', '0', '0', '0', '194.7', '1', '0', '0', '3', '0'),
('60', '13', '1', '2', '2', '2014-04-25', '2014-05-05', 'auto', '2', '60', '15962', '0', '0', '0', '0', '0', '215.92', '1', '0', '0', '3', '0'),
('61', '13', '1', '2', '2', '2014-05-25', '2014-06-04', 'auto', '2', '61', '17822', '0', '0', '0', '0', '0', '218.42', '1', '0', '0', '3', '0'),
('62', '13', '2', '2', '2', '2014-06-25', '2014-07-05', 'auto', '2', '62', '0', '0', '0', '0', '0', '0', '217.62', '1', '0', '0', '3', '0'),
('63', '13', '2', '2', '2', '2014-07-25', '2014-08-04', 'auto', '2', '63', '0', '0', '0', '0', '0', '0', '221.08', '1', '0', '0', '3', '0'),
('64', '13', '1', '2', '2', '2014-08-25', '2014-09-04', 'auto', '2', '64', '19708', '0', '0', '0', '0', '0', '220.54', '1', '0', '0', '3', '0'),
('65', '13', '2', '2', '2', '2014-09-25', '2014-10-05', 'auto', '2', '65', '20530', '0', '0', '0', '0', '0', '215', '1', '0', '0', '3', '0'),
('66', '13', '1', '2', '2', '2014-10-25', '2014-11-04', 'auto', '2', '66', '20203', '0', '0', '0', '0', '0', '215', '1', '0', '0', '3', '0'),
('67', '13', '2', '2', '2', '2014-11-25', '2014-12-05', 'auto', '2', '67', '0', '0', '0', '0', '0', '0', '215', '1', '0', '0', '3', '0'),
('68', '13', '1', '2', '2', '2014-12-24', '2015-01-03', 'auto', '2', '68', '20147', '0', '0', '0', '0', '0', '215', '1', '0', '0', '3', '0'),
('69', '13', '1', '2', '2', '2015-01-25', '2015-02-04', 'auto', '2', '69', '22340', '0', '0', '0', '0', '0', '215', '1', '0', '0', '3', '0'),
('70', '13', '1', '2', '2', '2015-02-25', '2015-03-07', 'auto', '2', '70', '25071', '0', '0', '0', '0', '0', '215', '1', '0', '0', '3', '0'),
('71', '13', '2', '2', '2', '2015-10-20', '2015-10-30', 'auto', '2', '71', '0', '0', '0', '0', '0', '0', '215', '1', '0', '0', '3', '0'),
('72', '13', '1', '2', '2', '2015-03-25', '2015-04-04', 'auto', '2', '72', '23042', '0', '0', '0', '0', '0', '204.75', '1', '0', '0', '3', '0'),
('73', '13', '2', '2', '2', '2014-07-25', '2014-08-04', 'auto', '2', '73', '0', '0', '0', '0', '0', '0', '221.08', '1', '0', '0', '3', '0'),
('74', '13', '2', '2', '2', '2014-12-29', '2015-01-08', 'auto', '2', '74', '0', '0', '0', '0', '0', '0', '204.87', '1', '0', '0', '3', '0'),
('75', '13', '1', '2', '2', '2014-06-28', '2014-07-08', 'auto', '2', '75', '11298', '0', '0', '0', '0', '0', '217.62', '1', '0', '0', '3', '0'),
('76', '13', '1', '2', '2', '2014-07-25', '2014-08-04', 'auto', '2', '76', '11245', '0', '0', '0', '0', '0', '221.08', '1', '0', '0', '3', '0'),
('77', '13', '1', '2', '2', '2014-11-28', '2014-12-08', 'auto', '2', '77', '19055', '0', '0', '0', '0', '0', '207.25', '1', '0', '0', '3', '0'),
('78', '13', '3', '2', '2', '2015-12-20', '2015-12-30', 'auto', '2', '78', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('79', '13', '3', '2', '2', '2014-12-21', '2014-12-31', 'auto', '2', '79', '0', '0', '0', '0', '0', '0', '207.25', '1', '0', '0', '3', '0'),
('80', '13', '1', '2', '2', '2014-12-21', '2014-12-31', 'auto', '2', '80', '28250', '0', '0', '0', '0', '0', '207.25', '1', '0', '0', '3', '0'),
('81', '13', '2', '2', '2', '2015-04-20', '2015-04-30', 'auto', '2', '81', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('82', '13', '2', '2', '2', '2015-05-20', '2015-05-30', 'auto', '2', '82', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('83', '13', '2', '2', '2', '2015-06-20', '2015-06-30', 'auto', '2', '83', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('84', '13', '2', '2', '2', '2015-07-20', '2015-07-30', 'auto', '2', '84', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('85', '13', '2', '2', '2', '2015-08-20', '2015-08-30', 'auto', '2', '85', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('86', '13', '2', '2', '2', '2015-09-20', '2015-09-30', 'auto', '2', '86', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('87', '13', '2', '2', '2', '2015-10-20', '2015-10-30', 'auto', '2', '87', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('88', '13', '2', '2', '2', '2015-11-20', '2015-11-30', 'auto', '2', '88', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('89', '13', '2', '2', '2', '2015-12-20', '2015-12-30', 'auto', '2', '89', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('90', '13', '2', '2', '2', '2016-01-20', '2016-01-30', 'auto', '2', '90', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('91', '13', '2', '2', '2', '2016-02-20', '2016-03-01', 'auto', '2', '91', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('92', '13', '2', '2', '2', '2016-03-20', '2016-03-30', 'auto', '2', '92', '0', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('93', '13', '2', '2', '2', '2016-04-26', '2016-05-06', 'auto', '2', '93', '35943', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('94', '13', '2', '1', '1', '2016-04-26', '2016-05-17', 'auto', '1', '94', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('95', '13', '1', '2', '2', '2015-04-20', '2015-04-30', 'auto', '2', '95', '26926.69', '0', '0', '0', '0', '0', '197.27', '1', '0', '0', '3', '0'),
('96', '13', '1', '2', '2', '2015-05-20', '2015-05-30', 'auto', '2', '96', '30933.76', '0', '0', '0', '0', '0', '204.6', '1', '0', '0', '3', '0'),
('97', '13', '1', '2', '2', '2015-06-20', '2015-06-30', 'auto', '2', '97', '28266.76', '0', '0', '0', '0', '0', '208.43', '1', '0', '0', '3', '0'),
('98', '13', '1', '2', '2', '2015-07-20', '2015-07-30', 'auto', '2', '98', '29110.73', '0', '0', '0', '0', '0', '209.25', '1', '0', '0', '3', '0'),
('99', '13', '1', '2', '2', '2015-08-20', '2015-08-30', 'auto', '2', '99', '28209.78', '0', '0', '0', '0', '0', '206.75', '1', '0', '0', '3', '0'),
('100', '13', '1', '2', '2', '2015-09-20', '2015-09-30', 'auto', '2', '100', '27740.63', '0', '0', '0', '0', '0', '208', '1', '0', '0', '3', '0'),
('101', '13', '1', '2', '2', '2015-10-20', '2015-10-30', 'auto', '2', '101', '27867.67', '0', '0', '0', '0', '0', '213', '1', '0', '0', '3', '0'),
('102', '13', '1', '2', '2', '2015-11-20', '2015-11-30', 'auto', '2', '102', '31174.63', '0', '0', '0', '0', '0', '214.65', '1', '0', '0', '3', '0'),
('103', '13', '1', '2', '2', '2015-12-20', '2015-12-30', 'auto', '2', '103', '32631.57', '0', '0', '0', '0', '0', '214.65', '1', '0', '0', '3', '0'),
('104', '13', '2', '2', '2', '2016-01-20', '2016-01-30', 'auto', '2', '104', '0', '0', '0', '0', '0', '0', '213.82', '1', '0', '0', '3', '0'),
('105', '13', '1', '2', '2', '2016-02-20', '2016-03-01', 'auto', '2', '105', '36846.36', '0', '0', '0', '0', '0', '204.4', '1', '0', '0', '3', '0'),
('106', '13', '1', '2', '2', '2016-03-20', '2016-03-30', 'auto', '2', '106', '34309.4', '0', '0', '0', '0', '0', '200.71', '1', '0', '0', '3', '0'),
('107', '13', '1', '2', '2', '2016-01-20', '2016-01-30', 'auto', '2', '107', '20068.45', '0', '0', '0', '0', '0', '213.82', '1', '0', '0', '3', '0');

### Structure of table `1_debtor_trans_details` ###

DROP TABLE IF EXISTS `1_debtor_trans_details`;

CREATE TABLE `1_debtor_trans_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_trans_no` int(11) DEFAULT NULL,
  `debtor_trans_type` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `unit_price` double NOT NULL DEFAULT '0',
  `unit_tax` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `discount_percent` double NOT NULL DEFAULT '0',
  `standard_cost` double NOT NULL DEFAULT '0',
  `qty_done` double NOT NULL DEFAULT '0',
  `src_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`debtor_trans_type`,`debtor_trans_no`),
  KEY `src_id` (`src_id`)
) ENGINE=InnoDB AUTO_INCREMENT=218 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_debtor_trans_details` ###

INSERT INTO `1_debtor_trans_details` VALUES
('1', '1', '13', 'exports', 'Export of IT &amp; Customer Support Services', '1100325', '0', '1', '0', '0', '1', '1'),
('2', '1', '10', 'exports', 'Export of IT &amp; Customer Support Services', '1100325', '0', '1', '0', '0', '0', '1'),
('3', '2', '13', 'exports', 'Export of IT &amp; Customer Support Services', '1434045', '0', '1', '0', '0', '1', '2'),
('4', '2', '10', 'exports', 'Export of IT &amp; Customer Support Services', '1434045', '0', '1', '0', '0', '0', '3'),
('5', '3', '13', 'exports', 'Export of IT &amp; Customer Support Services', '1435915', '0', '1', '0', '0', '1', '3'),
('6', '3', '10', 'exports', 'Export of IT &amp; Customer Support Services', '1435915', '0', '1', '0', '0', '0', '5'),
('7', '4', '13', 'exports', 'Export of IT &amp; Customer Support Services', '1406415', '0', '1', '0', '0', '1', '4'),
('8', '4', '10', 'exports', 'Export of IT &amp; Customer Support Services', '1406415', '0', '1', '0', '0', '0', '7'),
('9', '5', '13', 'exports', 'Export of IT &amp; Customer Support Services', '1415415', '0', '1', '0', '0', '1', '5'),
('10', '5', '10', 'exports', 'Export of IT &amp; Customer Support Services', '1415415', '0', '1', '0', '0', '0', '9'),
('11', '6', '13', 'exports', 'Export of IT &amp; Customer Support Services', '1432415', '0', '1', '0', '0', '1', '6'),
('12', '6', '10', 'exports', 'Export of IT &amp; Customer Support Services', '1432415', '0', '1', '0', '0', '0', '11'),
('13', '7', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1451439', '0', '1', '0', '0', '1', '7'),
('14', '7', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1451439', '0', '1', '0', '0', '0', '13'),
('15', '8', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1378415', '0', '1', '0', '0', '1', '8'),
('16', '8', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1378415', '0', '1', '0', '0', '0', '15'),
('17', '9', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1226434', '0', '1', '0', '0', '1', '9'),
('18', '9', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1226434', '0', '1', '0', '0', '0', '17'),
('19', '10', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1273934', '0', '1', '0', '0', '1', '10'),
('20', '10', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1273934', '0', '1', '0', '0', '0', '19'),
('21', '11', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1049751', '0', '1', '0', '0', '1', '11'),
('22', '11', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1049751', '0', '1', '0', '0', '0', '21'),
('23', '12', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1417608', '0', '1', '0', '0', '1', '12'),
('24', '12', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1417608', '0', '1', '0', '0', '0', '23'),
('25', '13', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1278308', '0', '1', '0', '0', '1', '13'),
('26', '13', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1278308', '0', '1', '0', '0', '0', '25'),
('27', '14', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1250308', '0', '1', '0', '0', '1', '14'),
('28', '14', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1250308', '0', '1', '0', '0', '0', '27'),
('29', '15', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1385911', '0', '1', '0', '0', '1', '15'),
('30', '15', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1385911', '0', '1', '0', '0', '0', '29'),
('31', '16', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1470462', '0', '1', '0', '0', '1', '16'),
('32', '16', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1470462', '0', '1', '0', '0', '0', '31'),
('33', '17', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1594273', '0', '1', '0', '0', '1', '17'),
('34', '17', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1594273', '0', '1', '0', '0', '0', '33'),
('35', '18', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('36', '18', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('37', '19', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '10900', '0', '1', '0', '0', '1', '19'),
('38', '19', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '10900', '0', '1', '0', '0', '0', '37'),
('39', '1', '11', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '1', '0', '0', '0', '36'),
('40', '20', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '9032', '0', '1', '0', '0', '1', '20'),
('41', '20', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '9032', '0', '1', '0', '0', '0', '40'),
('42', '21', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1196', '0', '1', '0', '0', '1', '21'),
('43', '21', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1196', '0', '1', '0', '0', '0', '42'),
('44', '22', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '10722', '0', '1', '0', '0', '1', '22'),
('45', '22', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '10722', '0', '1', '0', '0', '0', '44'),
('46', '23', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '2193', '0', '1', '0', '0', '1', '23'),
('47', '23', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '2193', '0', '1', '0', '0', '0', '46'),
('48', '24', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '10620', '0', '1', '0', '0', '1', '24'),
('49', '24', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '10620', '0', '1', '0', '0', '0', '48'),
('50', '25', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4380', '0', '1', '0', '0', '1', '25'),
('51', '25', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4380', '0', '1', '0', '0', '0', '50'),
('52', '26', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '10699', '0', '1', '0', '0', '1', '26'),
('53', '26', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '10699', '0', '1', '0', '0', '0', '52'),
('54', '27', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4344', '0', '1', '0', '0', '1', '27'),
('55', '27', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4344', '0', '1', '0', '0', '0', '54'),
('56', '28', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '11008', '0', '1', '0', '0', '1', '28'),
('57', '28', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '11008', '0', '1', '0', '0', '0', '56'),
('58', '29', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4418', '0', '1', '0', '0', '1', '29'),
('59', '29', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4418', '0', '1', '0', '0', '0', '58'),
('60', '30', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '10302', '0', '1', '0', '0', '1', '30'),
('61', '30', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '10302', '0', '1', '0', '0', '0', '60'),
('62', '31', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4386', '0', '1', '0', '0', '1', '31'),
('63', '31', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4386', '0', '1', '0', '0', '0', '62'),
('64', '32', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '11165', '0', '1', '0', '0', '1', '32'),
('65', '32', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '11165', '0', '1', '0', '0', '0', '64'),
('66', '33', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4615', '0', '1', '0', '0', '1', '33'),
('67', '33', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4615', '0', '1', '0', '0', '0', '66'),
('68', '34', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '12004', '0', '1', '0', '0', '1', '34'),
('69', '34', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '12004', '0', '1', '0', '0', '0', '68'),
('70', '35', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4747', '0', '1', '0', '0', '1', '35'),
('71', '35', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4747', '0', '1', '0', '0', '0', '70'),
('72', '36', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '15924', '0', '1', '0', '0', '1', '36'),
('73', '36', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '15924', '0', '1', '0', '0', '0', '72'),
('74', '37', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('75', '37', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('76', '38', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('77', '38', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('78', '39', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '5097', '0', '1', '0', '0', '1', '39'),
('79', '39', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '5097', '0', '1', '0', '0', '0', '78'),
('80', '40', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '17396', '0', '1', '0', '0', '1', '40'),
('81', '40', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '17396', '0', '1', '0', '0', '0', '80'),
('82', '41', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4665', '0', '1', '0', '0', '1', '41'),
('83', '41', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4665', '0', '1', '0', '0', '0', '82'),
('84', '42', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4657', '0', '1', '0', '0', '1', '42'),
('85', '42', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4657', '0', '1', '0', '0', '0', '84'),
('86', '43', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '15962', '0', '1', '0', '0', '1', '43'),
('87', '43', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '15962', '0', '1', '0', '0', '0', '86'),
('88', '44', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '7043', '0', '1', '0', '0', '1', '44'),
('89', '44', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '7043', '0', '1', '0', '0', '0', '88'),
('90', '45', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('91', '45', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('92', '46', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '19169', '0', '1', '0', '0', '1', '46'),
('93', '46', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '19169', '0', '1', '0', '0', '0', '92'),
('94', '47', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '17178', '0', '1', '0', '0', '1', '47'),
('95', '47', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '17178', '0', '1', '0', '0', '0', '94'),
('96', '48', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '19708', '0', '1', '0', '0', '1', '48'),
('97', '48', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '19708', '0', '1', '0', '0', '0', '96'),
('98', '49', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '18502', '0', '1', '0', '0', '1', '49'),
('99', '49', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '18502', '0', '1', '0', '0', '0', '98'),
('100', '50', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '18828', '0', '1', '0', '0', '1', '50'),
('101', '50', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '18828', '0', '1', '0', '0', '0', '100'),
('102', '51', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '18134', '0', '1', '0', '0', '1', '51'),
('103', '51', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '18134', '0', '1', '0', '0', '0', '102'),
('104', '52', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '17960', '0', '1', '0', '0', '1', '52'),
('105', '52', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '17960', '0', '1', '0', '0', '0', '104'),
('106', '53', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '17056', '0', '1', '0', '0', '1', '53'),
('107', '53', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '17056', '0', '1', '0', '0', '0', '106'),
('108', '54', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '15864', '0', '1', '0', '0', '1', '54'),
('109', '54', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '15864', '0', '1', '0', '0', '0', '108'),
('110', '55', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '20027', '0', '1', '0', '0', '1', '55'),
('111', '55', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '20027', '0', '1', '0', '0', '0', '110'),
('112', '56', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '10560', '0', '1', '0', '0', '1', '56'),
('113', '56', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '10560', '0', '1', '0', '0', '0', '112'),
('114', '57', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('115', '57', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('116', '58', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('117', '58', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('118', '59', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '10951', '0', '1', '0', '0', '1', '59'),
('119', '59', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '10951', '0', '1', '0', '0', '0', '118'),
('120', '60', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '15962', '0', '1', '0', '0', '1', '60'),
('121', '60', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '15962', '0', '1', '0', '0', '0', '120'),
('122', '61', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '17822', '0', '1', '0', '0', '1', '61'),
('123', '61', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '17822', '0', '1', '0', '0', '0', '122'),
('124', '62', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('125', '62', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('126', '63', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('127', '63', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('128', '64', '13', 'exports', '19708', '19708', '0', '1', '0', '0', '1', '64'),
('129', '64', '10', 'exports', '19708', '19708', '0', '1', '0', '0', '0', '128'),
('130', '65', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '20530', '0', '1', '0', '0', '1', '65'),
('131', '65', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '20530', '0', '1', '0', '0', '0', '130'),
('132', '66', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '20203', '0', '1', '0', '0', '1', '66'),
('133', '66', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '20203', '0', '1', '0', '0', '0', '132'),
('134', '67', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('135', '67', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('136', '68', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '20147', '0', '1', '0', '0', '1', '68'),
('137', '68', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '20147', '0', '1', '0', '0', '0', '136'),
('138', '69', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '22340', '0', '1', '0', '0', '1', '69'),
('139', '69', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '22340', '0', '1', '0', '0', '0', '138'),
('140', '70', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '25071', '0', '1', '0', '0', '1', '70'),
('141', '70', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '25071', '0', '1', '0', '0', '0', '140'),
('142', '71', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('143', '71', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('144', '72', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '23042', '0', '1', '0', '0', '1', '72'),
('145', '72', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '23042', '0', '1', '0', '0', '0', '144'),
('146', '73', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('147', '73', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('148', '74', '13', 'exports', '400', '0', '0', '0', '0', '0', '1', '0'),
('149', '74', '10', 'exports', '400', '0', '0', '0', '0', '0', '0', '0'),
('150', '75', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '11298', '0', '1', '0', '0', '1', '75'),
('151', '75', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '11298', '0', '1', '0', '0', '0', '150'),
('152', '76', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '11245', '0', '1', '0', '0', '1', '76'),
('153', '76', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '11245', '0', '1', '0', '0', '0', '152'),
('154', '77', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '19055', '0', '1', '0', '0', '1', '77'),
('155', '77', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '19055', '0', '1', '0', '0', '0', '154'),
('156', '2', '11', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('157', '3', '11', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '3.4', '0', '1', '0', '0', '0', '0'),
('158', '78', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('159', '78', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('160', '79', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('161', '79', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('162', '80', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '28250', '0', '1', '0', '0', '1', '80'),
('163', '80', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '28250', '0', '1', '0', '0', '0', '162'),
('164', '81', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('165', '81', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('166', '82', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('167', '82', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('168', '83', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('169', '83', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('170', '84', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('171', '84', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('172', '85', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('173', '85', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('174', '86', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('175', '86', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('176', '87', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('177', '87', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('178', '88', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('179', '88', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('180', '89', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('181', '89', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('182', '90', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('183', '90', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('184', '91', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('185', '91', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('186', '92', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('187', '92', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('188', '93', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '35943', '0', '1', '0', '0', '1', '93'),
('189', '93', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '35943', '0', '1', '0', '0', '0', '188'),
('190', '94', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('191', '94', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('192', '95', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '26926.69', '0', '1', '0', '0', '1', '95'),
('193', '95', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '26926.69', '0', '1', '0', '0', '0', '192'),
('194', '96', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '30933.76', '0', '1', '0', '0', '1', '96'),
('195', '96', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '30933.76', '0', '1', '0', '0', '0', '194'),
('196', '97', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '28266.76', '0', '1', '0', '0', '1', '97'),
('197', '97', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '28266.76', '0', '1', '0', '0', '0', '196'),
('198', '98', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '29110.73', '0', '1', '0', '0', '1', '98'),
('199', '98', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '29110.73', '0', '1', '0', '0', '0', '198'),
('200', '99', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '28209.78', '0', '1', '0', '0', '1', '99'),
('201', '99', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '28209.78', '0', '1', '0', '0', '0', '200'),
('202', '100', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '27740.63', '0', '1', '0', '0', '1', '100'),
('203', '100', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '27740.63', '0', '1', '0', '0', '0', '202'),
('204', '101', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '27867.67', '0', '1', '0', '0', '1', '101'),
('205', '101', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '27867.67', '0', '1', '0', '0', '0', '204'),
('206', '102', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '31174.63', '0', '1', '0', '0', '1', '102'),
('207', '102', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '31174.63', '0', '1', '0', '0', '0', '206'),
('208', '103', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '32631.57', '0', '1', '0', '0', '1', '103'),
('209', '103', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '32631.57', '0', '1', '0', '0', '0', '208'),
('210', '104', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '1', '0'),
('211', '104', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0', '0', '0', '0'),
('212', '105', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '36846.36', '0', '1', '0', '0', '1', '105'),
('213', '105', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '36846.36', '0', '1', '0', '0', '0', '212'),
('214', '106', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '34309.4', '0', '1', '0', '0', '1', '106'),
('215', '106', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '34309.4', '0', '1', '0', '0', '0', '214'),
('216', '107', '13', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '20068.45', '0', '1', '0', '0', '1', '107'),
('217', '107', '10', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '20068.45', '0', '1', '0', '0', '0', '216');

### Structure of table `1_debtors_master` ###

DROP TABLE IF EXISTS `1_debtors_master`;

CREATE TABLE `1_debtors_master` (
  `debtor_no` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `debtor_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `address` tinytext COLLATE utf8_unicode_ci,
  `tax_id` varchar(55) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type` int(11) NOT NULL DEFAULT '1',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `credit_status` int(11) NOT NULL DEFAULT '0',
  `payment_terms` int(11) DEFAULT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `pymt_discount` double NOT NULL DEFAULT '0',
  `credit_limit` float NOT NULL DEFAULT '1000',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`debtor_no`),
  UNIQUE KEY `debtor_ref` (`debtor_ref`),
  KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_debtors_master` ###

INSERT INTO `1_debtors_master` VALUES
('1', 'inbay Limited', 'Inbay ', '45, Broadwick Street,\nLondon WIF 9QW', '', 'Rs.', '1', '0', '0', '1', '1', '0', '0', '10000000', '', '0'),
('2', 'Inbay Limited', 'Inbay Limited', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', '', 'GBP', '2', '0', '0', '1', '3', '0', '0', '100000', '', '0');

### Structure of table `1_dimensions` ###

DROP TABLE IF EXISTS `1_dimensions`;

CREATE TABLE `1_dimensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_` tinyint(1) NOT NULL DEFAULT '1',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  KEY `date_` (`date_`),
  KEY `due_date` (`due_date`),
  KEY `type_` (`type_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_dimensions` ###


### Structure of table `1_exchange_rates` ###

DROP TABLE IF EXISTS `1_exchange_rates`;

CREATE TABLE `1_exchange_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rate_buy` double NOT NULL DEFAULT '0',
  `rate_sell` double NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `curr_code` (`curr_code`,`date_`)
) ENGINE=MyISAM AUTO_INCREMENT=55 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_exchange_rates` ###

INSERT INTO `1_exchange_rates` VALUES
('1', 'GBP', '200.68', '200.68', '2012-04-20'),
('2', 'GBP', '202.75', '202.75', '2012-05-20'),
('3', 'GBP', '207.35', '207.35', '2012-06-20'),
('4', 'GBP', '204.6', '204.6', '2012-07-20'),
('5', 'GBP', '206.23', '206.23', '2012-08-20'),
('6', 'GBP', '207.5', '207.5', '2012-09-20'),
('7', 'GBP', '205.85', '205.85', '2012-10-20'),
('8', 'GBP', '205.47', '205.47', '2012-11-20'),
('9', 'GBP', '202.8', '202.8', '2012-12-20'),
('10', 'GBP', '197.25', '197.25', '2013-01-20'),
('11', 'GBP', '205.5', '205.5', '2013-02-20'),
('12', 'GBP', '191.2', '191.2', '2013-03-20'),
('13', 'GBP', '194.7', '194.7', '2013-04-29'),
('14', 'GBP', '190.35', '190.35', '2013-05-28'),
('15', 'GBP', '198.77', '198.77', '2013-06-27'),
('16', 'GBP', '199.5', '199.5', '2013-07-31'),
('17', 'GBP', '206', '206', '2013-09-02'),
('18', 'GBP', '211.51', '211.51', '2013-09-27'),
('19', 'GBP', '209.4', '209.4', '2013-10-30'),
('20', 'GBP', '211.85', '211.85', '2013-11-27'),
('21', 'GBP', '213.75', '213.75', '2014-02-10'),
('22', 'GBP', '217.75', '217.75', '2014-02-28'),
('23', 'GBP', '216', '216', '2014-03-19'),
('24', 'GBP', '212.8601', '212.8601', '2014-03-25'),
('25', 'GBP', '215.92', '215.92', '2014-03-27'),
('26', 'GBP', '218.42', '218.42', '2014-04-28'),
('27', 'GBP', '217.62', '217.62', '2014-05-30'),
('28', 'GBP', '221.08', '221.08', '2014-06-30'),
('29', 'GBP', '220.54', '220.54', '2014-07-28'),
('30', 'GBP', '215', '215', '2014-08-27'),
('31', 'GBP', '205.5', '205.5', '2013-02-27'),
('32', 'GBP', '211.1', '211.1', '2014-09-29'),
('33', 'GBP', '209.4', '209.4', '2014-10-27'),
('34', 'GBP', '207.25', '207.25', '2014-11-27'),
('35', 'GBP', '204.87', '204.87', '2014-12-29'),
('36', 'GBP', '199.1', '199.1', '2015-01-27'),
('37', 'GBP', '204.75', '204.75', '2015-02-27'),
('38', 'GBP', '197.27', '197.27', '2015-03-27'),
('39', 'GBP', '209.5', '209.5', '2016-04-26'),
('40', 'GBP', '215', '215', '2016-05-27'),
('41', 'GBP', '204.6', '204.6', '2015-04-29'),
('42', 'GBP', '208.43', '208.43', '2015-05-28'),
('43', 'GBP', '209.25', '209.25', '2015-06-29'),
('44', 'GBP', '206.75', '206.75', '2015-07-28'),
('45', 'GBP', '208', '208', '2015-08-27'),
('46', 'GBP', '213', '213', '2015-09-28'),
('47', 'GBP', '214.65', '214.65', '2015-10-28'),
('48', 'GBP', '214.65', '214.65', '2015-11-30'),
('49', 'GBP', '213.82', '213.82', '2015-12-28'),
('51', 'GBP', '204.4', '204.4', '2016-01-28'),
('52', 'GBP', '200.71', '200.71', '2016-03-01'),
('53', 'GBP', '209.64', '209.64', '2016-03-29'),
('54', 'GBP', '212.5', '212.5', '2016-04-27');

### Structure of table `1_fiscal_year` ###

DROP TABLE IF EXISTS `1_fiscal_year`;

CREATE TABLE `1_fiscal_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `begin` date DEFAULT '0000-00-00',
  `end` date DEFAULT '0000-00-00',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `begin` (`begin`),
  UNIQUE KEY `end` (`end`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_fiscal_year` ###

INSERT INTO `1_fiscal_year` VALUES
('1', '2011-04-01', '2012-03-31', '1'),
('2', '2012-04-01', '2013-03-31', '1'),
('4', '2010-04-01', '2011-03-31', '1'),
('5', '2013-04-01', '2014-03-31', '1'),
('6', '2014-04-01', '2015-03-31', '1'),
('7', '2015-04-01', '2016-03-31', '0'),
('8', '2016-04-01', '2017-03-31', '0');

### Structure of table `1_gl_trans` ###

DROP TABLE IF EXISTS `1_gl_trans`;

CREATE TABLE `1_gl_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT '0',
  `type_no` bigint(16) NOT NULL DEFAULT '1',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `amount` double NOT NULL DEFAULT '0',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob,
  `cheque_no` int(6) DEFAULT NULL,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `dimension_id` (`dimension_id`),
  KEY `dimension2_id` (`dimension2_id`),
  KEY `tran_date` (`tran_date`),
  KEY `account_and_tran_date` (`account`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=3142 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_gl_trans` ###

INSERT INTO `1_gl_trans` VALUES
('13', '1', '2', '2010-12-29', '5440', 'Suwa Sampatha Medical Policy', '32312.66', '0', '0', '0', 'Ceylinco Insurance Plc.', '14952'),
('14', '1', '2', '2010-12-29', '1060', '', '-32312.66', '0', '0', '0', 'Ceylinco Insurance Plc.', '14952'),
('17', '1', '4', '2010-12-30', '5450', 'E.P.F for November 2010', '161000', '0', '0', '4', '4', '14954'),
('18', '1', '4', '2010-12-30', '1060', '', '-161000', '0', '0', '4', '4', '14954'),
('19', '1', '5', '2010-12-30', '5460', 'September 2010', '24150', '0', '0', '4', '5', '14955'),
('20', '1', '5', '2010-12-30', '1060', '', '-24150', '0', '0', '4', '5', '14955'),
('25', '1', '8', '2011-02-02', '5450', 'E.P.F for December 2010', '161000', '0', '0', '4', '4', '14958'),
('26', '1', '8', '2011-02-02', '1060', '', '-161000', '0', '0', '4', '4', '14958'),
('27', '1', '9', '2011-02-02', '5460', 'Employees Trust fund-December 2010', '24150', '0', '0', '4', '5', '14959'),
('28', '1', '9', '2011-02-02', '1060', '', '-24150', '0', '0', '4', '5', '14959'),
('29', '1', '10', '2011-02-10', '5470', 'Staff transport', '36388.57', '0', '0', '0', 'Highlevel express', '14960'),
('30', '1', '10', '2011-02-10', '1060', '', '-36388.57', '0', '0', '0', 'Highlevel express', '14960'),
('35', '1', '13', '2011-03-01', '5460', 'Employees Trust Fund-Jan 2011', '24150', '0', '0', '4', '5', '14964'),
('36', '1', '13', '2011-03-01', '1060', '', '-24150', '0', '0', '4', '5', '14964'),
('37', '1', '14', '2011-03-01', '5450', 'E.P.F for January 2011', '161000', '0', '0', '4', '4', '14965'),
('38', '1', '14', '2011-03-01', '1060', '', '-161000', '0', '0', '4', '4', '14965'),
('39', '1', '15', '2011-03-01', '1220', 'Funds transfer', '250000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '14966'),
('40', '1', '15', '2011-03-01', '1060', '', '-250000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '14966'),
('41', '1', '16', '2011-03-17', '1220', 'Cheque in lieu of cheque', '250000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '14967'),
('42', '1', '16', '2011-03-17', '1060', '', '-250000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '14967'),
('43', '1', '17', '2011-03-31', '5450', 'E.P.F for February 2011', '161000', '0', '0', '4', '4', '14969'),
('44', '1', '17', '2011-03-31', '1060', '', '-161000', '0', '0', '4', '4', '14969'),
('45', '1', '18', '2011-03-31', '5460', 'E.T.F  - February 2011', '24150', '0', '0', '4', '5', '14970'),
('46', '1', '18', '2011-03-31', '1060', '', '-24150', '0', '0', '4', '5', '14970'),
('47', '0', '1', '2011-03-31', '5450', 'E.P.F - March 2011', '188000', '0', '0', NULL, NULL, '0'),
('48', '0', '1', '2011-03-31', '5460', 'E.T.F  - March 2011', '28200', '0', '0', NULL, NULL, '0'),
('49', '0', '1', '2011-03-31', '2110', 'Accrued charges', '-216200', '0', '0', NULL, NULL, '0'),
('50', '10', '1', '2010-11-23', '4010', '', '-1100325', '0', '0', '2', '1', '0'),
('51', '10', '1', '2010-11-23', '1200', '', '1100325', '0', '0', '2', '1', '0'),
('52', '10', '2', '2010-12-13', '4010', '', '-1434045', '0', '0', '2', '1', '0'),
('53', '10', '2', '2010-12-13', '1200', '', '1434045', '0', '0', '2', '1', '0'),
('54', '10', '3', '2011-01-14', '4010', '', '-1435915', '0', '0', '2', '1', '0'),
('55', '10', '3', '2011-01-14', '1200', '', '1435915', '0', '0', '2', '1', '0'),
('56', '10', '4', '2011-01-14', '4010', '', '0', '0', '0', '2', '1', '0'),
('57', '10', '4', '2011-01-14', '1200', '', '0', '0', '0', '2', '1', '0'),
('58', '10', '5', '2011-01-14', '4010', '', '0', '0', '0', '2', '1', '0'),
('59', '10', '5', '2011-01-14', '1200', '', '0', '0', '0', '2', '1', '0'),
('60', '10', '5', '2011-03-17', '4010', '', '-1415415', '0', '0', '2', '1', '0'),
('61', '10', '5', '2011-03-17', '1200', '', '1415415', '0', '0', '2', '1', '0'),
('62', '10', '4', '2011-02-18', '4010', '', '-1406415', '0', '0', '2', '1', '0'),
('63', '10', '4', '2011-02-18', '1200', '', '1406415', '0', '0', '2', '1', '0'),
('64', '1', '12', '2011-02-15', '1220', 'Sampath bank', '280000', '0', '0', '0', 'K.P.L.Pintoe', '14971'),
('65', '1', '12', '2011-02-15', '1060', '', '-280000', '0', '0', '0', 'K.P.L.Pintoe', '14971'),
('66', '1', '11', '2011-02-15', '1220', 'Seylan Bank', '120000', '0', '0', '0', 'K.P.L.Pintoe', '14972'),
('67', '1', '11', '2011-02-15', '1060', '', '-120000', '0', '0', '0', 'K.P.L.Pintoe', '14972'),
('68', '2', '1', '2011-02-15', '1220', 'Initial deposit to open bank account', '-25000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '1'),
('69', '2', '1', '2011-02-15', '1060', '', '25000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '1'),
('70', '12', '1', '2010-11-29', '1060', '', '1100325', '0', '0', '2', '1', '0'),
('71', '12', '1', '2010-11-29', '1200', '', '-1100325', '0', '0', '2', '1', '0'),
('72', '12', '2', '2010-11-29', '1060', '', '0', '0', '0', '2', '1', '0'),
('73', '12', '2', '2010-11-29', '1200', '', '0', '0', '0', '2', '1', '0'),
('74', '12', '2', '2010-11-29', '5690', '', '0', '0', '0', '2', '1', '0'),
('75', '12', '3', '2010-11-24', '1060', '', '1600', '0', '0', '2', '1', '0'),
('76', '12', '3', '2010-11-24', '1200', '', '-1600', '0', '0', '2', '1', '0'),
('77', '12', '4', '2011-01-25', '1060', '', '1434815', '0', '0', '2', '1', '0'),
('78', '12', '4', '2011-01-25', '1200', '', '-1435915', '0', '0', '2', '1', '0'),
('79', '12', '4', '2011-01-25', '5690', '', '1100', '0', '0', '2', '1', '0'),
('80', '12', '5', '2011-02-25', '1060', '', '1405315', '0', '0', '2', '1', '0'),
('81', '12', '5', '2011-02-25', '1200', '', '-1406415', '0', '0', '2', '1', '0'),
('82', '12', '5', '2011-02-25', '5690', '', '1100', '0', '0', '2', '1', '0'),
('83', '12', '6', '2011-03-25', '1060', '', '1414315', '0', '0', '2', '1', '0'),
('84', '12', '6', '2011-03-25', '1200', '', '-1415415', '0', '0', '2', '1', '0'),
('85', '12', '6', '2011-03-25', '5690', '', '1100', '0', '0', '2', '1', '0'),
('86', '2', '2', '2011-03-31', '1220', 'Bank transfer', '-250000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2'),
('87', '2', '2', '2011-03-31', '1060', '', '250000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '2'),
('92', '1', '20', '2010-11-24', '5690', 'Cheque book', '750', '0', '0', '0', 'Bank charges', '5'),
('93', '1', '20', '2010-11-24', '1060', '', '-750', '0', '0', '0', 'Bank charges', '5'),
('96', '1', '22', '2010-11-30', '5690', 'Commission - bank', '1300', '0', '0', '0', 'Bank charges', '7'),
('97', '1', '22', '2010-11-30', '1060', '', '-1300', '0', '0', '0', 'Bank charges', '7'),
('98', '1', '23', '2010-11-30', '5690', 'Debit tax', '826.9', '0', '0', '0', 'Bank charges', '8'),
('99', '1', '23', '2010-11-30', '1060', '', '-826.9', '0', '0', '0', 'Bank charges', '8'),
('100', '1', '24', '2010-12-23', '5410', 'December  2010 - Salary', '954816', '0', '0', '0', 'Staff Salaries -', '9'),
('101', '1', '24', '2010-12-23', '1060', '', '-954816', '0', '0', '0', 'Staff Salaries -', '9'),
('102', '1', '25', '2010-12-23', '5690', 'Commission - bank', '1600', '0', '0', '0', 'Bank charges', '10'),
('103', '1', '25', '2010-12-23', '1060', '', '-1600', '0', '0', '0', 'Bank charges', '10'),
('104', '1', '26', '2010-12-30', '5690', 'Charges on return salary slips', '100', '0', '0', '0', 'Bank charges', '11'),
('105', '1', '26', '2010-12-30', '1060', '', '-100', '0', '0', '0', 'Bank charges', '11'),
('106', '1', '27', '2011-01-03', '5690', 'Debit tax', '1158.6', '0', '0', '0', 'Bank charges', '12'),
('107', '1', '27', '2011-01-03', '1060', '', '-1158.6', '0', '0', '0', 'Bank charges', '12'),
('108', '1', '28', '2011-01-27', '5410', 'January 2011 - Salary', '954816', '0', '0', '0', 'Staff Salaries -', '13'),
('109', '1', '28', '2011-01-27', '1060', '', '-954816', '0', '0', '0', 'Staff Salaries -', '13'),
('110', '1', '29', '2011-01-27', '5690', 'Commission - bank', '500', '0', '0', '0', 'Bank charges', '14'),
('111', '1', '29', '2011-01-27', '1060', '', '-500', '0', '0', '0', 'Bank charges', '14'),
('112', '1', '30', '2011-02-03', '5690', 'Debit tax', '1382.08', '0', '0', '0', 'Bank charges', '15'),
('113', '1', '30', '2011-02-03', '1060', '', '-1382.08', '0', '0', '0', 'Bank charges', '15'),
('114', '1', '31', '2011-02-28', '5410', 'Salary - February 2011', '954816', '0', '0', '0', 'Staff Salaries -', '16'),
('115', '1', '31', '2011-02-28', '1060', '', '-954816', '0', '0', '0', 'Staff Salaries -', '16'),
('116', '1', '32', '2011-02-28', '5690', 'Commission - bank', '1600', '0', '0', '0', 'Bank charges', '17'),
('117', '1', '32', '2011-02-28', '1060', '', '-1600', '0', '0', '0', 'Bank charges', '17'),
('118', '1', '33', '2011-03-01', '5690', 'Debit tax', '1577.95', '0', '0', '0', 'Bank charges', '18'),
('119', '1', '33', '2011-03-01', '1060', '', '-1577.95', '0', '0', '0', 'Bank charges', '18'),
('120', '1', '34', '2011-03-25', '5410', 'Salary - March 2011', '962816', '0', '0', '0', 'Staff Salaries -', '19'),
('121', '1', '34', '2011-03-25', '1060', '', '-962816', '0', '0', '0', 'Staff Salaries -', '19'),
('122', '1', '35', '2011-03-25', '5690', 'Commission - bank', '1600', '0', '0', '0', 'Bank charges', '20'),
('123', '1', '35', '2011-03-25', '1060', '', '-1600', '0', '0', '0', 'Bank charges', '20'),
('124', '1', '19', '2010-11-24', '5690', 'Bank charges over charged', '500', '0', '0', '0', 'Bank charges', '21'),
('125', '1', '19', '2010-11-24', '1060', '', '-500', '0', '0', '0', 'Bank charges', '21'),
('128', '1', '21', '2010-11-30', '5410', 'November 2010 Inbay', '824849', '0', '0', '0', 'Staff Salaries ', '23'),
('129', '1', '21', '2010-11-30', '1060', '', '-824849', '0', '0', '0', 'Staff Salaries ', '23'),
('130', '0', '2', '2010-08-31', '5615', 'Topjobs advertisement', '15471.75', '0', '0', NULL, NULL, '0'),
('131', '0', '2', '2010-08-31', '1220', 'Topjobs advertisement', '-15471.75', '0', '0', NULL, NULL, '0'),
('132', '0', '3', '2010-09-30', '5470', 'Cab charges - Staff Night drop', '27840', '0', '0', NULL, NULL, '0'),
('133', '0', '3', '2010-09-30', '1220', 'Cab charges - Staff Night drop', '-27840', '0', '0', NULL, NULL, '0'),
('134', '0', '4', '2010-09-30', '5660', 'Printing letter heads', '13250', '0', '0', NULL, NULL, '0'),
('135', '0', '4', '2010-09-30', '1220', 'Printing letter heads', '-13250', '0', '0', NULL, NULL, '0'),
('136', '0', '5', '2011-01-04', '5470', 'Highlevel express- December 2010', '59930', '0', '0', NULL, NULL, '0'),
('137', '0', '5', '2011-01-04', '1220', 'Highlevel express- December 2010', '-59930', '0', '0', NULL, NULL, '0'),
('138', '12', '7', '2010-11-29', '1060', '', '1089045', '0', '0', '2', '1', '0'),
('139', '12', '7', '2010-11-29', '1200', '', '-1089045', '0', '0', '2', '1', '0'),
('144', '12', '8', '2010-11-30', '1230', '', '343400', '0', '0', '2', '1', '0'),
('145', '12', '8', '2010-11-30', '1200', '', '-343400', '0', '0', '2', '1', '0'),
('146', '2', '3', '2010-11-29', '3350', 'Kristian Wright', '-160000', '0', '0', '0', 'Share Capiatl - Kristian Wright', '26'),
('147', '2', '3', '2010-11-29', '5795', 'Kristian Wright - Share issue expenses', '-11700', '0', '0', '0', 'Share Capiatl - Kristian Wright', '26'),
('148', '2', '3', '2010-11-29', '1060', '', '171700', '0', '0', '0', 'Share Capiatl - Kristian Wright', '26'),
('149', '2', '4', '2010-11-29', '3350', 'Mark Duke', '-160000', '0', '0', '0', 'Share Capiatl - Mark Duke', '27'),
('150', '2', '4', '2010-11-29', '5795', 'Mark Duke', '-11700', '0', '0', '0', 'Share Capiatl - Mark Duke', '27'),
('151', '2', '4', '2010-11-29', '1060', '', '171700', '0', '0', '0', 'Share Capiatl - Mark Duke', '27'),
('152', '1', '37', '2010-05-17', '5795', 'Business registration fees', '12190', '0', '0', '0', 'Registrar of companies', '28'),
('153', '1', '37', '2010-05-17', '1065', '', '-12190', '0', '0', '0', 'Registrar of companies', '28'),
('154', '1', '38', '2010-08-06', '5795', 'Business registration fees', '1857.25', '0', '0', '0', 'Registrar of companies', '29'),
('155', '1', '38', '2010-08-06', '1065', '', '-1857.25', '0', '0', '0', 'Registrar of companies', '29'),
('156', '1', '39', '2010-07-21', '5795', 'Business registration ', '2912', '0', '0', '0', 'News paper advertisements', '30'),
('157', '1', '39', '2010-07-21', '1065', '', '-2912', '0', '0', '0', 'News paper advertisements', '30'),
('158', '1', '40', '2010-07-21', '5795', 'Paper advertisement', '4659', '0', '0', '0', 'News paper advertisements', '31'),
('159', '1', '40', '2010-07-21', '1065', '', '-4659', '0', '0', '0', 'News paper advertisements', '31'),
('160', '1', '41', '2010-07-21', '5795', 'Business registration expenses', '20000', '0', '0', '0', 'Company Secretaries', '32'),
('161', '1', '41', '2010-07-21', '1065', '', '-20000', '0', '0', '0', 'Company Secretaries', '32'),
('162', '1', '42', '2010-11-28', '5470', 'Staff transport', '57040', '0', '0', '0', 'Highlevel express', '33'),
('163', '1', '42', '2010-11-28', '1220', '', '-57040', '0', '0', '0', 'Highlevel express', '33'),
('164', '1', '43', '2011-03-25', '5470', 'Staff transport', '106925.71', '0', '0', '0', 'Highlevel express', '34'),
('165', '1', '43', '2011-03-25', '1220', '', '-106925.71', '0', '0', '0', 'Highlevel express', '34'),
('166', '0', '6', '2011-03-31', '5470', 'Highlevel express payment - March 2010', '79160', '0', '0', NULL, NULL, '0'),
('167', '0', '6', '2011-03-31', '2110', 'Highlevel express payment - March 2010', '-79160', '0', '0', NULL, NULL, '0'),
('168', '1', '44', '2010-06-01', '3350', 'Contribution for issued share capital', '0', '0', '0', '0', 'K.P.L.Pintoe', '35'),
('169', '1', '44', '2010-06-01', '1220', '', '0', '0', '0', '0', 'K.P.L.Pintoe', '35'),
('170', '1', '45', '2010-06-01', '3350', 'Contribution for issued share capital', '0', '0', '0', '0', 'K.N.S.Pintoe', '36'),
('171', '1', '45', '2010-06-01', '1220', '', '0', '0', '0', '0', 'K.N.S.Pintoe', '36'),
('172', '2', '5', '2010-06-01', '3350', 'Contribution for issued share capital', '-40000', '0', '0', '0', 'K.P.L.Pintoe', '37'),
('173', '2', '5', '2010-06-01', '1220', '', '40000', '0', '0', '0', 'K.P.L.Pintoe', '37'),
('174', '2', '6', '2010-06-01', '3350', 'Contribution for issued share capital', '-40000', '0', '0', '0', 'K.N.S.Pintoe', '38'),
('175', '2', '6', '2010-06-01', '1220', '', '40000', '0', '0', '0', 'K.N.S.Pintoe', '38'),
('176', '0', '7', '2011-03-31', '5410', 'P.A.Y.E payable', '0', '0', '0', NULL, NULL, '0'),
('177', '0', '7', '2011-03-31', '2160', 'P.A.Y.E payable', '0', '0', '0', NULL, NULL, '0'),
('178', '1', '1', '2010-12-15', '1220', 'E.P.F for September 2010', '161000', '0', '0', '0', 'Superientendant, Employees Provident Fund ', '14951'),
('179', '1', '1', '2010-12-15', '1060', '', '-161000', '0', '0', '0', 'Superientendant, Employees Provident Fund ', '14951'),
('180', '1', '3', '2010-12-30', '1220', 'E.P.F - October 2010', '161000', '0', '0', '4', '4', '14953'),
('181', '1', '3', '2010-12-30', '1060', '', '-161000', '0', '0', '4', '4', '14953'),
('182', '1', '6', '2010-12-30', '1220', 'Employees Trust Fund-October 2010', '24150', '0', '0', '4', '5', '14954'),
('183', '1', '6', '2010-12-30', '1060', '', '-24150', '0', '0', '4', '5', '14954'),
('184', '1', '7', '2010-12-30', '1220', 'Employees Trust fund - November 2010', '24150', '0', '0', '4', '5', '14955'),
('185', '1', '7', '2010-12-30', '1060', '', '-24150', '0', '0', '4', '5', '14955'),
('186', '1', '46', '2012-02-29', '5450', 'E.P.F - January 2012', '166940', '0', '0', '4', '4', '257204'),
('187', '1', '46', '2012-02-29', '1060', '', '-166940', '0', '0', '4', '4', '257204'),
('188', '1', '47', '2012-02-29', '5460', 'Employees Trust Fund-Jan 2012', '25041', '0', '0', '4', '5', '257205'),
('189', '1', '47', '2012-02-29', '1060', '', '-25041', '0', '0', '4', '5', '257205'),
('190', '1', '48', '2010-07-02', '1065', 'Petty cash-Reimbursement', '45000', '0', '0', '0', 'Cash', '32'),
('191', '1', '48', '2010-07-02', '1220', '', '-45000', '0', '0', '0', 'Cash', '32'),
('192', '0', '7', '2011-03-31', '5410', 'P.A.Y.E payable', '102040', '0', '0', NULL, NULL, '0'),
('193', '0', '7', '2011-03-31', '2160', 'P.A.Y.E payable', '-102040', '0', '0', NULL, NULL, '0'),
('194', '0', '8', '2011-03-31', '5440', 'Suwa Sampatha Medical Policy', '92895.41', '0', '0', NULL, NULL, '0'),
('195', '0', '8', '2011-03-31', '2110', 'Suwa Sampatha Medical Policy', '-92895.41', '0', '0', NULL, NULL, '0'),
('196', '0', '9', '2011-03-31', '5430', 'Provision for gratuity', '486100', '0', '0', NULL, NULL, '0'),
('197', '0', '9', '2011-03-31', '2140', 'Provision for gratuity', '-486100', '0', '0', NULL, NULL, '0'),
('198', '1', '36', '2010-11-24', '5690', 'Correction adjustment', '1600', '0', '0', '0', 'Bank charges', '33'),
('199', '1', '36', '2010-11-24', '1060', '', '-1600', '0', '0', '0', 'Bank charges', '33'),
('200', '1', '49', '2012-03-09', '2160', 'P.A.Y.E -August toOctober 2011', '17543', '0', '0', '4', '6', '257206'),
('201', '1', '49', '2012-03-09', '1060', '', '-17543', '0', '0', '4', '6', '257206'),
('202', '1', '50', '2012-03-09', '2160', 'P.A.Y.E -Nov&#039;11,Dec.&#039;11 &amp; Janr 2012', '0', '0', '0', '4', '6', '257207'),
('203', '1', '50', '2012-03-09', '1220', '', '0', '0', '0', '4', '6', '257207'),
('204', '20', '1', '2012-03-20', '2100', '', '-40176.94', '0', '0', '3', '1', '0'),
('205', '20', '1', '2012-03-20', '5470', '', '37454.94', '0', '0', '3', '1', '0'),
('206', '20', '1', '2012-03-20', '1220', '', '2722', '0', '0', '3', '1', '0'),
('207', '20', '2', '2012-03-20', '2100', '', '-8214.29', '0', '0', '3', '1', '0'),
('208', '20', '2', '2012-03-20', '5470', '', '8214.29', '0', '0', '3', '1', '0'),
('209', '20', '3', '2012-03-20', '2100', '', '-21449.54', '0', '0', '3', '1', '0'),
('210', '20', '3', '2012-03-20', '5470', '', '18919.54', '0', '0', '3', '1', '0'),
('211', '20', '3', '2012-03-20', '1220', '', '2530', '0', '0', '3', '1', '0'),
('212', '20', '4', '2012-03-20', '2100', '', '-18183.88', '0', '0', '3', '1', '0'),
('213', '20', '4', '2012-03-20', '5470', '', '18183.88', '0', '0', '3', '1', '0'),
('214', '20', '5', '2012-03-20', '2100', '', '-33263.27', '0', '0', '3', '1', '0'),
('215', '20', '5', '2012-03-20', '5470', '', '29663.27', '0', '0', '3', '1', '0'),
('216', '20', '5', '2012-03-20', '1220', '', '3600', '0', '0', '3', '1', '0'),
('217', '20', '6', '2012-03-20', '2100', '', '-15600', '0', '0', '3', '1', '0'),
('218', '20', '6', '2012-03-20', '5470', '', '13700', '0', '0', '3', '1', '0'),
('219', '20', '6', '2012-03-20', '1220', '', '1900', '0', '0', '3', '1', '0'),
('220', '20', '7', '2012-03-20', '2100', '', '-43444.9', '0', '0', '3', '1', '0'),
('221', '20', '7', '2012-03-20', '5470', '', '41608.9', '0', '0', '3', '1', '0'),
('222', '20', '7', '2012-03-20', '1220', '', '1836', '0', '0', '3', '1', '0'),
('223', '20', '8', '2012-03-20', '2100', '', '-35177.55', '0', '0', '3', '1', '0'),
('224', '20', '8', '2012-03-20', '5470', '', '33277.55', '0', '0', '3', '1', '0'),
('225', '20', '8', '2012-03-20', '1220', '', '1900', '0', '0', '3', '1', '0'),
('226', '20', '9', '2012-03-20', '2100', '', '-5416.38', '0', '0', '3', '1', '0'),
('227', '20', '9', '2012-03-20', '5470', '', '5416.38', '0', '0', '3', '1', '0'),
('228', '22', '1', '2012-03-20', '2100', '', '0', '0', '0', '3', '1', '257208'),
('229', '22', '1', '2012-03-20', '1220', '', '0', '0', '0', '3', '1', '257208'),
('230', '22', '2', '2012-03-20', '2100', '', '220926.75', '0', '0', '3', '1', '257209'),
('231', '22', '2', '2012-03-20', '1060', '', '-220926.75', '0', '0', '3', '1', '257209'),
('232', '1', '51', '2012-03-26', '5440', 'Staff insurance - cover up to 27/01/2013', '124083.58', '0', '0', '0', 'Union Assurance Plc.', '257209'),
('233', '1', '51', '2012-03-26', '1060', '', '-124083.58', '0', '0', '0', 'Union Assurance Plc.', '257209'),
('234', '1', '52', '2012-03-27', '2160', 'Salary - March 2012', '0', '0', '0', '0', 'Staff Salaries', '257210'),
('235', '1', '52', '2012-03-27', '5690', 'Commission - bank', '0', '0', '0', '0', 'Staff Salaries', '257210'),
('236', '1', '52', '2012-03-27', '1060', '', '0', '0', '0', '0', 'Staff Salaries', '257210'),
('241', '1', '54', '2012-03-31', '5460', 'Employees Trust Fund', '23788.5', '0', '0', '4', '5', '257212'),
('242', '1', '54', '2012-03-31', '1060', '', '-23788.5', '0', '0', '4', '5', '257212'),
('243', '1', '55', '2012-03-31', '5450', 'E.P.F for February 2012', '158590', '0', '0', '4', '4', '257213'),
('244', '1', '55', '2012-03-31', '1060', '', '-158590', '0', '0', '4', '4', '257213'),
('259', '1', '58', '2012-05-03', '5470', 'Settlement of invoice no.1203026', '41485.82', '0', '0', '0', 'Highlevel Express (Pvt)Ltd. ', '257217'),
('260', '1', '58', '2012-05-03', '5470', 'Settlement of invoice no.1203027', '27090.66', '0', '0', '0', 'Highlevel Express (Pvt)Ltd. ', '257217'),
('261', '1', '58', '2012-05-03', '5470', 'Settlement of invoice no.1204007', '34334.07', '0', '0', '0', 'Highlevel Express (Pvt)Ltd. ', '257217'),
('262', '1', '58', '2012-05-03', '5470', 'Settlement of invoice no.1204008', '21951.47', '0', '0', '0', 'Highlevel Express (Pvt)Ltd. ', '257217'),
('263', '1', '58', '2012-05-03', '5470', 'Settlement of invoice no.1204019', '5897.21', '0', '0', '0', 'Highlevel Express (Pvt)Ltd. ', '257217'),
('264', '1', '58', '2012-05-03', '5470', 'Settlement of invoice no.1204020', '35948.89', '0', '0', '0', 'Highlevel Express (Pvt)Ltd. ', '257217'),
('265', '1', '58', '2012-05-03', '5470', 'Settlement of invoice no.1204021', '35649.2', '0', '0', '0', 'Highlevel Express (Pvt)Ltd. ', '257217'),
('266', '1', '58', '2012-05-03', '5470', 'Settlement of invoice no.1204022', '22022.52', '0', '0', '0', 'Highlevel Express (Pvt)Ltd. ', '257217'),
('267', '1', '58', '2012-05-03', '5470', 'Settlement of invoice no.1204022', '22022.52', '0', '0', '0', 'Highlevel Express (Pvt)Ltd. ', '257217'),
('268', '1', '58', '2012-05-03', '1060', '', '-246402.36', '0', '0', '0', 'Highlevel Express (Pvt)Ltd. ', '257217'),
('269', '1', '56', '2012-04-30', '5460', 'Employees Trust fund - March 2012', '29638.5', '0', '0', '4', '5', '257218'),
('270', '1', '56', '2012-04-30', '1060', '', '-29638.5', '0', '0', '4', '5', '257218'),
('271', '1', '57', '2012-04-30', '5450', 'E.P.F for March 2012', '197590', '0', '0', '4', '4', '257219'),
('272', '1', '57', '2012-04-30', '1060', '', '-197590', '0', '0', '4', '4', '257219'),
('273', '1', '59', '2012-05-16', '5460', 'ETF surcharges', '2369.55', '0', '0', '0', 'Employees Trust Fund Board', '257220'),
('274', '1', '59', '2012-05-16', '1060', '', '-2369.55', '0', '0', '0', 'Employees Trust Fund Board', '257220'),
('275', '1', '60', '2012-05-28', '5450', 'E.P.F for April 2012', '207223', '0', '0', '4', '4', '257219'),
('276', '1', '60', '2012-05-28', '1060', '', '-207223', '0', '0', '4', '4', '257219'),
('277', '1', '61', '2012-05-28', '5460', 'Employees Trust Fund- April 2012', '31083.5', '0', '0', '4', '5', '257220'),
('278', '1', '61', '2012-05-28', '1060', '', '-31083.5', '0', '0', '4', '5', '257220'),
('279', '1', '62', '2012-04-27', '5410', 'Salary - April 2012', '1194888.33', '0', '0', '0', 'Staff Salaries - April 2012', '0'),
('280', '1', '62', '2012-04-27', '5690', 'Bank charges', '500', '0', '0', '0', 'Staff Salaries - April 2012', '0'),
('281', '1', '62', '2012-04-27', '1060', '', '-1195388.33', '0', '0', '0', 'Staff Salaries - April 2012', '0'),
('282', '1', '63', '2012-05-25', '5410', 'Salary - May 2012', '1501276.9', '0', '0', '0', 'Staff Salaries -', '0'),
('283', '1', '63', '2012-05-25', '5690', 'Bank charges', '500', '0', '0', '0', 'Staff Salaries -', '0'),
('284', '1', '63', '2012-05-25', '1060', '', '-1501776.9', '0', '0', '0', 'Staff Salaries -', '0'),
('285', '1', '64', '2012-06-15', '5470', 'Invoice 4033 to 4036 less o/paid  22,022/=', '84048', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257221'),
('286', '1', '64', '2012-06-15', '5470', 'Invoice 5011', '38795', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257221'),
('287', '1', '64', '2012-06-15', '5470', 'Invoice 5012', '39724', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257221'),
('288', '1', '64', '2012-06-15', '5470', 'Invoice 5013', '48804', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257221'),
('289', '1', '64', '2012-06-15', '5470', 'Invoice 5014', '22255', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257221'),
('290', '1', '64', '2012-06-15', '5470', 'Invoice 5039', '36399', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257221'),
('291', '1', '64', '2012-06-15', '5470', 'Invoice 5040', '25314', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257221'),
('292', '1', '64', '2012-06-15', '5470', 'Invoice 5060', '39749', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257221'),
('293', '1', '64', '2012-06-15', '5470', 'Invoice 5061', '41341', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257221'),
('294', '1', '64', '2012-06-15', '5470', 'Invoice 5062 and 5087', '19645', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257221'),
('295', '1', '64', '2012-06-15', '1060', '', '-396074', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257221'),
('296', '1', '65', '2012-06-29', '5450', 'E.P.F for May 2012', '263923', '0', '0', '4', '4', '257222'),
('297', '1', '65', '2012-06-29', '1060', '', '-263923', '0', '0', '4', '4', '257222'),
('298', '1', '66', '2012-06-29', '5460', 'Employees Trust Fund- May 2012', '39588.5', '0', '0', '4', '5', '257223'),
('299', '1', '66', '2012-06-29', '1060', '', '-39588.5', '0', '0', '4', '5', '257223'),
('300', '1', '67', '2012-07-12', '5430', 'Staff tea - R.A.De Mel Mawatha', '25608.29', '0', '0', '0', 'Dilshee Enterprises', '257224'),
('301', '1', '67', '2012-07-12', '1060', '', '-25608.29', '0', '0', '0', 'Dilshee Enterprises', '257224'),
('302', '1', '68', '2012-07-23', '5470', 'Settlement of invoice no.1206001', '41283.48', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257225'),
('303', '1', '68', '2012-07-23', '5470', 'Settlement of invoice no.1206002', '43212.3', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257225'),
('304', '1', '68', '2012-07-23', '5470', 'Settlement of invoice no.1206015', '42169.86', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257225'),
('305', '1', '68', '2012-07-23', '5470', 'Settlement of invoice no.1206016', '41951.58', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257225'),
('306', '1', '68', '2012-07-23', '5470', 'Settlement of invoice no.1206026', '115983.18', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257225'),
('307', '1', '68', '2012-07-23', '5470', 'Settlement of invoice no.1207008', '145823.28', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257225'),
('308', '1', '68', '2012-07-23', '1060', '', '-430423.68', '0', '0', '0', 'Highlevel Express (Pvt)Ltd.', '257225'),
('309', '1', '69', '2012-07-26', '5410', 'Salary - July 2012', '1822591.28', '0', '0', '0', 'Staff Salaries - July 2012', '257226'),
('310', '1', '69', '2012-07-26', '5690', 'Bank charges', '500', '0', '0', '0', 'Staff Salaries - July 2012', '257226'),
('311', '1', '69', '2012-07-26', '1060', '', '-1823091.28', '0', '0', '0', 'Staff Salaries - July 2012', '257226'),
('312', '1', '70', '2012-07-31', '5460', 'Employees Trust Fund-June 2012', '39588.5', '0', '0', '4', '5', '257227'),
('313', '1', '70', '2012-07-31', '1060', '', '-39588.5', '0', '0', '4', '5', '257227'),
('316', '1', '71', '2012-07-31', '5430', 'Staff refreshment allowance - August 2012', '0', '0', '0', '0', 'Cash', '257229'),
('317', '1', '71', '2012-07-31', '1060', '', '0', '0', '0', '0', 'Cash', '257229'),
('318', '1', '72', '2012-08-07', '5450', 'Employees Provident Fund - June 2012', '263923', '0', '0', '4', '4', '257230'),
('319', '1', '72', '2012-08-07', '1060', '', '-263923', '0', '0', '4', '4', '257230'),
('322', '1', '73', '2012-08-28', '5410', 'Salary for July 2012', '1878736.56', '0', '0', '0', 'Staff Salaries - July 2012', '39'),
('323', '1', '73', '2012-08-28', '5690', 'Bank charges', '500', '0', '0', '0', 'Staff Salaries - July 2012', '39'),
('324', '1', '73', '2012-08-28', '1060', '', '-1879236.56', '0', '0', '0', 'Staff Salaries - July 2012', '39'),
('325', '1', '74', '2012-08-22', '5795', 'Pope &amp; Company - Secretarial fees', '0', '0', '0', '0', 'Cash', '257229'),
('326', '1', '74', '2012-08-22', '1060', '', '0', '0', '0', '0', 'Cash', '257229'),
('327', '1', '75', '2012-08-30', '5450', 'Employees Provident Fund- July 2012', '350590', '0', '0', '4', '4', '257229'),
('328', '1', '75', '2012-08-30', '1060', '', '-350590', '0', '0', '4', '4', '257229'),
('329', '1', '76', '2012-08-30', '5460', 'Employees Trust fund - July 2012', '52588.5', '0', '0', '4', '5', '257230'),
('330', '1', '76', '2012-08-30', '1060', '', '-52588.5', '0', '0', '4', '5', '257230'),
('331', '1', '77', '2012-08-30', '5800', 'Settlement of Invoice 00210 - August 2012', '39000', '0', '0', '0', 'IAS Solutions', '257231'),
('332', '1', '77', '2012-08-30', '1060', '', '-39000', '0', '0', '0', 'IAS Solutions', '257231'),
('335', '1', '78', '2012-09-28', '5460', 'Employees Trust Fund', '0', '0', '0', '4', '5', '257234'),
('336', '1', '78', '2012-09-28', '1060', '', '0', '0', '0', '4', '5', '257234'),
('337', '1', '79', '2012-10-01', '5460', 'Employees Trust Fund - August 2012', '54088.5', '0', '0', '4', '5', '257234'),
('338', '1', '79', '2012-10-01', '1060', '', '-54088.5', '0', '0', '4', '5', '257234'),
('339', '1', '80', '2012-10-01', '5450', 'Employees Provident Fund- August 2012', '360590', '0', '0', '4', '4', '257233'),
('340', '1', '80', '2012-10-01', '1060', '', '-360590', '0', '0', '4', '4', '257233'),
('341', '1', '81', '2012-10-04', '5470', 'Invoice No.1208019', '112519', '0', '0', '0', 'High Level Express (Pvt)Ltd.', '257235'),
('342', '1', '81', '2012-10-04', '5470', 'Invoice No.1209004', '152505', '0', '0', '0', 'High Level Express (Pvt)Ltd.', '257235'),
('343', '1', '81', '2012-10-04', '1060', '', '-265024', '0', '0', '0', 'High Level Express (Pvt)Ltd.', '257235'),
('344', '1', '82', '2012-10-25', '5410', 'Salaries - September 2012', '2021895.14', '0', '0', '0', 'Salaries', '47'),
('345', '1', '82', '2012-10-25', '5690', 'Bank charges', '500', '0', '0', '0', 'Salaries', '47'),
('346', '1', '82', '2012-10-25', '1060', '', '-2022395.14', '0', '0', '0', 'Salaries', '47'),
('347', '1', '83', '2012-10-05', '5430', 'Refreshment allowance - October 2012', '60000', '0', '0', '0', 'Cash', '48'),
('348', '1', '83', '2012-10-05', '1060', '', '-60000', '0', '0', '0', 'Cash', '48'),
('349', '1', '84', '2012-10-08', '5510', 'Engineer of the Month', '7500', '0', '0', '0', 'Cash', '49'),
('350', '1', '84', '2012-10-08', '1060', '', '-7500', '0', '0', '0', 'Cash', '49'),
('351', '1', '85', '2012-10-31', '5450', 'The Superintendent, Employees Provident Fund', '378590', '0', '0', '4', '4', '257238'),
('352', '1', '85', '2012-10-31', '1060', '', '-378590', '0', '0', '4', '4', '257238'),
('353', '1', '86', '2012-10-31', '5460', 'Employees Trust Fund-September 2012', '56788.5', '0', '0', '4', '5', '257239'),
('354', '1', '86', '2012-10-31', '1060', '', '-56788.5', '0', '0', '4', '5', '257239'),
('355', '1', '87', '2012-10-31', '5460', 'Employees Trust Fund- Surcharge', '2671.34', '0', '0', '4', '5', '257240'),
('356', '1', '87', '2012-10-31', '1060', '', '-2671.34', '0', '0', '4', '5', '257240'),
('357', '1', '88', '2012-11-02', '5510', 'Welfare allowance - November 2012', '60000', '0', '0', '0', 'Cash', '257241'),
('358', '1', '88', '2012-11-02', '1060', '', '-60000', '0', '0', '0', 'Cash', '257241'),
('359', '1', '89', '2012-11-30', '5460', 'Employees Trust fund - October 2012', '57669.75', '0', '0', '4', '5', '257243'),
('360', '1', '89', '2012-11-30', '1060', '', '-57669.75', '0', '0', '4', '5', '257243'),
('361', '1', '90', '2012-11-30', '5450', 'The Superintendent, Employees Provident Fund', '384465', '0', '0', '4', '4', '257242'),
('362', '1', '90', '2012-11-30', '1060', '', '-384465', '0', '0', '4', '4', '257242'),
('363', '1', '91', '2012-12-05', '5510', 'Welfare allowance - December 2012', '60000', '0', '0', '0', 'Cash', '257244'),
('364', '1', '91', '2012-12-05', '1060', '', '-60000', '0', '0', '0', 'Cash', '257244'),
('365', '1', '92', '2012-12-10', '5510', 'Christmas Party expenses', '115500', '0', '0', '0', 'Cash', '257245'),
('366', '1', '92', '2012-12-10', '1060', '', '-115500', '0', '0', '0', 'Cash', '257245'),
('367', '1', '93', '2012-12-10', '5510', 'Reimbursement of exam fees- Abdullah Azoor,Fazeem Hathy', '41120', '0', '0', '0', 'Cash', '257246'),
('368', '1', '93', '2012-12-10', '1060', '', '-41120', '0', '0', '0', 'Cash', '257246'),
('369', '1', '94', '2012-12-18', '5470', 'Settlement of Invoice No. 1211002', '157488', '0', '0', '0', 'High Level Express (Pvt)Ltd.', '257247'),
('370', '1', '94', '2012-12-18', '5470', 'Settlement of Invoice No. 1211011', '157577.76', '0', '0', '0', 'High Level Express (Pvt)Ltd.', '257247'),
('371', '1', '94', '2012-12-18', '1060', '', '-315065.76', '0', '0', '0', 'High Level Express (Pvt)Ltd.', '257247'),
('372', '1', '95', '2012-12-20', '5410', 'Salaries - December 2012', '2220011.67', '0', '0', '0', 'Salaries', '60'),
('373', '1', '95', '2012-12-20', '5690', 'Bank charges', '500', '0', '0', '0', 'Salaries', '60'),
('374', '1', '95', '2012-12-20', '1060', '', '-2220511.67', '0', '0', '0', 'Salaries', '60'),
('375', '2', '7', '2013-01-07', '1220', 'Fund transfer', '-400000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '61'),
('376', '2', '7', '2013-01-07', '1060', '', '400000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '61'),
('379', '1', '97', '2013-01-07', '5510', 'Refreshment allowance - January 2013', '60000', '0', '0', '0', 'Cash', '63'),
('380', '1', '97', '2013-01-07', '1060', '', '-60000', '0', '0', '0', 'Cash', '63'),
('381', '1', '98', '2013-01-07', '5410', 'Salary advance - January 2013', '14000', '0', '0', '0', 'Mewan Samarasinghe', '64'),
('382', '1', '98', '2013-01-07', '1060', '', '-14000', '0', '0', '0', 'Mewan Samarasinghe', '64'),
('383', '1', '99', '2013-01-10', '5510', 'Polo T&#039; Shirts', '32725', '0', '0', '0', 'S. T. Hapangama', '465253'),
('384', '1', '99', '2013-01-10', '1060', '', '-32725', '0', '0', '0', 'S. T. Hapangama', '465253'),
('389', '1', '100', '2013-01-15', '5510', 'Engineer of the month award - January 2013', '7500', '0', '0', '0', 'Cash', '465254'),
('390', '1', '100', '2013-01-15', '1060', '', '-7500', '0', '0', '0', 'Cash', '465254'),
('395', '1', '101', '2013-01-15', '5470', 'Invoice No. 001', '60956', '0', '0', '0', 'Grand Taxi ', '465256'),
('396', '1', '101', '2013-01-15', '5470', 'Invoice No. 002', '31787', '0', '0', '0', 'Grand Taxi ', '465256'),
('397', '1', '101', '2013-01-15', '5470', 'Invoice No. 003', '50037', '0', '0', '0', 'Grand Taxi ', '465256'),
('398', '1', '101', '2013-01-15', '1060', '', '-142780', '0', '0', '0', 'Grand Taxi ', '465256'),
('399', '1', '102', '2013-01-16', '5460', 'Employees Trust Fund', '60670', '0', '0', '4', '5', '465258'),
('400', '1', '102', '2013-01-16', '1060', '', '-60670', '0', '0', '4', '5', '465258'),
('401', '1', '103', '2013-01-16', '5450', 'Employees Provident Fund- November 2012', '404465', '0', '0', '4', '4', '465258'),
('402', '1', '103', '2013-01-16', '1060', '', '-404465', '0', '0', '4', '4', '465258'),
('403', '1', '104', '2013-01-30', '5470', 'Invoice No. 004', '43675', '0', '0', '0', 'Grand Taxi ', '465259'),
('404', '1', '104', '2013-01-30', '5470', 'Invoice No. 005', '41533', '0', '0', '0', 'Grand Taxi ', '465259'),
('405', '1', '104', '2013-01-30', '5470', 'Invoice No. 006', '35917', '0', '0', '0', 'Grand Taxi ', '465259'),
('406', '1', '104', '2013-01-30', '5470', 'Invoice No. 007', '38457', '0', '0', '0', 'Grand Taxi ', '465259'),
('407', '1', '104', '2013-01-30', '1060', '', '-159582', '0', '0', '0', 'Grand Taxi ', '465259'),
('408', '1', '105', '2013-01-31', '5460', 'Employees Trust Fund', '64719.75', '0', '0', '4', '5', '465260'),
('409', '1', '105', '2013-01-31', '1060', '', '-64719.75', '0', '0', '4', '5', '465260'),
('410', '1', '106', '2013-01-31', '5450', 'Employees Provident Fund- DEcember 2012', '431465', '0', '0', '4', '4', '465261'),
('411', '1', '106', '2013-01-31', '1060', '', '-431465', '0', '0', '4', '4', '465261'),
('412', '1', '107', '2013-02-18', '5510', 'Engineer of the month award - February 2013', '7500', '0', '0', '0', 'Uddeshika Jayawardena', '72'),
('413', '1', '107', '2013-02-18', '1220', '', '-7500', '0', '0', '0', 'Uddeshika Jayawardena', '72'),
('414', '1', '108', '2013-02-26', '5460', 'Employees Trust fund- January 2013', '67830', '0', '0', '4', '5', '465263'),
('415', '1', '108', '2013-02-26', '1060', '', '-67830', '0', '0', '4', '5', '465263'),
('416', '1', '109', '2013-02-26', '5450', 'Employees Provident Fund- January2013', '452198', '0', '0', '4', '4', '465262'),
('417', '1', '109', '2013-02-26', '1060', '', '-452198', '0', '0', '4', '4', '465262'),
('418', '1', '110', '2013-03-06', '5470', 'Settlement of Invoice No. 11', '42580', '0', '0', '0', 'Grand Taxi', '465264'),
('419', '1', '110', '2013-03-06', '5470', 'Settlement of Invoice No. 13', '35915', '0', '0', '0', 'Grand Taxi', '465264'),
('420', '1', '110', '2013-03-06', '5470', 'Settlement of Invoice No. 14', '44334', '0', '0', '0', 'Grand Taxi', '465264'),
('421', '1', '110', '2013-03-06', '5470', 'Settlement of Invoice No. 15', '40690', '0', '0', '0', 'Grand Taxi', '465264'),
('422', '1', '110', '2013-03-06', '5470', 'Settlement of Invoice No. 16', '34236', '0', '0', '0', 'Grand Taxi', '465264'),
('423', '1', '110', '2013-03-06', '5470', 'Settlement of Invoice No. 17', '19557', '0', '0', '0', 'Grand Taxi', '465264'),
('424', '1', '110', '2013-03-06', '1060', '', '-217312', '0', '0', '0', 'Grand Taxi', '465264'),
('427', '1', '53', '2012-04-01', '2110', 'Audit fees - 31st March 2011', '22400', '0', '0', '0', 'Pope and Company', '257216'),
('428', '1', '53', '2012-04-01', '1060', '', '-22400', '0', '0', '0', 'Pope and Company', '257216'),
('429', '1', '111', '2013-03-08', '5795', 'Secretarial fees to Pope &amp; Co;', '15600', '0', '0', '0', 'Cash', '257217'),
('430', '1', '111', '2013-03-08', '1060', '', '-15600', '0', '0', '0', 'Cash', '257217'),
('431', '1', '112', '2013-03-08', '5410', 'Additional payment', '20000', '0', '0', '0', 'Ishan Ariyaratna', '257218'),
('432', '1', '112', '2013-03-08', '1060', '', '-20000', '0', '0', '0', 'Ishan Ariyaratna', '257218'),
('433', '1', '113', '2013-03-08', '5410', 'Additional payment', '15597', '0', '0', '0', 'Kapila Silwathge', '257219'),
('434', '1', '113', '2013-03-08', '1060', '', '-15597', '0', '0', '0', 'Kapila Silwathge', '257219'),
('435', '1', '114', '2013-03-08', '5510', 'Welfare allowance - March  2013', '60000', '0', '0', '0', 'Cash', '257220'),
('436', '1', '114', '2013-03-08', '5010', 'Welfare allowance - March  2013', '0', '0', '0', '0', 'Cash', '257220'),
('437', '1', '114', '2013-03-08', '1060', '', '-60000', '0', '0', '0', 'Cash', '257220'),
('438', '1', '115', '2013-03-08', '2160', 'P.A.Y.E - Feb &amp; March 2012', '12762', '0', '0', '4', '6', '257221'),
('439', '1', '115', '2013-03-08', '1060', '', '-12762', '0', '0', '4', '6', '257221'),
('440', '1', '116', '2013-03-08', '2160', 'P.A.Y.E - April, May  &amp; June 2012', '37811', '0', '0', '4', '6', '257222'),
('441', '1', '116', '2013-03-08', '1060', '', '-37811', '0', '0', '4', '6', '257222'),
('442', '1', '117', '2013-03-08', '2160', 'P.A.Y.E - July, Aug  &amp; Sept 2012', '148963', '0', '0', '4', '6', '257223'),
('443', '1', '117', '2013-03-08', '1060', '', '-148963', '0', '0', '4', '6', '257223'),
('444', '1', '118', '2013-03-28', '5450', 'Employees Provident Fund- Feb 2013', '473463', '0', '0', '4', '4', '465272'),
('445', '1', '118', '2013-03-28', '1060', '', '-473463', '0', '0', '4', '4', '465272'),
('446', '1', '119', '2013-03-28', '5460', 'Employees Trust fund- Feb  2013', '71019', '0', '0', '4', '5', '465273'),
('447', '1', '119', '2013-03-28', '1060', '', '-71019', '0', '0', '4', '5', '465273'),
('448', '1', '120', '2013-03-28', '2160', 'P.A.Y.E - Oct, Nov  &amp; Dec 2012', '156244', '0', '0', '4', '6', '465274'),
('449', '1', '120', '2013-03-28', '1060', '', '-156244', '0', '0', '4', '6', '465274'),
('450', '1', '121', '2013-03-31', '5460', 'Employees Trust Fund- Surcharge', '7523.26', '0', '0', '4', '5', '465275'),
('451', '1', '121', '2013-03-31', '1060', '', '-7523.26', '0', '0', '4', '5', '465275'),
('452', '1', '122', '2013-04-04', '5470', 'Settlement of invoices No.0018 to 0023', '0', '0', '0', '0', 'Grand Taxi Company', '31'),
('453', '1', '122', '2013-04-04', '1220', '', '0', '0', '0', '0', 'Grand Taxi Company', '31'),
('460', '1', '126', '2013-04-09', '5780', 'Reimbursement of Telephoe expenses ', '0', '0', '0', '0', 'Cash', '465279'),
('461', '1', '126', '2013-04-09', '1060', '', '0', '0', '0', '0', 'Cash', '465279'),
('462', '1', '127', '2013-04-09', '5510', 'Refreshment allowance - Orange Bus', '4850', '0', '0', '0', 'Cash', '465280'),
('463', '1', '127', '2013-04-09', '1060', '', '-4850', '0', '0', '0', 'Cash', '465280'),
('464', '1', '123', '2013-04-09', '5510', 'Welfare allowance - April  2013', '60000', '0', '0', '0', 'Cash', '465278'),
('465', '1', '123', '2013-04-09', '1060', '', '-60000', '0', '0', '0', 'Cash', '465278'),
('466', '1', '124', '2013-04-04', '5510', 'Engineer of the month award - April 2013', '7500', '0', '0', '0', 'Cash', '465276'),
('467', '1', '124', '2013-04-04', '1060', '', '-7500', '0', '0', '0', 'Cash', '465276'),
('468', '1', '125', '2013-04-04', '5410', 'Salary advance - Apri 2013 -Sajith Chandraratne', '15000', '0', '0', '0', 'Cash', '465277'),
('469', '1', '125', '2013-04-04', '1060', '', '-15000', '0', '0', '0', 'Cash', '465277'),
('472', '1', '96', '2013-04-29', '5520', 'Advertise on Top Jobs for year 2013', '80000', '0', '0', '0', 'Genesiis Software (Pvt)Ltd', '465281'),
('473', '1', '96', '2013-04-29', '1060', '', '-80000', '0', '0', '0', 'Genesiis Software (Pvt)Ltd', '465281'),
('474', '1', '128', '2013-04-29', '5510', 'Engineer of the month award - April 2013', '7500', '0', '0', '0', 'Cash', '465282'),
('475', '1', '128', '2013-04-29', '1060', '', '-7500', '0', '0', '0', 'Cash', '465282'),
('476', '1', '129', '2013-04-29', '5450', 'Employees Provident Fund- March 2013', '488523', '0', '0', '4', '4', '465283'),
('477', '1', '129', '2013-04-29', '1060', '', '-488523', '0', '0', '4', '4', '465283'),
('484', '1', '130', '2013-04-29', '5460', 'Employees Trust fund- March  2013', '73278', '0', '0', '4', '5', '465284'),
('485', '1', '130', '2013-04-29', '1060', '', '-73278', '0', '0', '4', '5', '465284'),
('486', '1', '131', '2013-04-30', '5410', 'Salary diference - April 2013', '5333', '0', '0', '0', 'Arshad Zackeriya', '465285'),
('487', '1', '131', '2013-04-30', '1060', '', '-5333', '0', '0', '0', 'Arshad Zackeriya', '465285'),
('488', '1', '132', '2013-04-30', '5430', 'Refreshment allowance - Orange Bus', '6025', '0', '0', '0', 'Cash', '465286'),
('489', '1', '132', '2013-04-30', '1060', '', '-6025', '0', '0', '0', 'Cash', '465286'),
('490', '1', '133', '2013-05-02', '5470', 'Invoice No. 0025', '27001', '0', '0', '0', 'Grand Taxi', '465287'),
('491', '1', '133', '2013-05-02', '5470', 'Invoice No. 0026', '47093', '0', '0', '0', 'Grand Taxi', '465287'),
('492', '1', '133', '2013-05-02', '5470', 'Invoice No. 0027', '41627', '0', '0', '0', 'Grand Taxi', '465287'),
('493', '1', '133', '2013-05-02', '5470', 'Invoice No. 0028', '37232', '0', '0', '0', 'Grand Taxi', '465287'),
('494', '1', '133', '2013-05-02', '5470', 'Invoice No. 0029', '37077', '0', '0', '0', 'Grand Taxi', '465287'),
('495', '1', '133', '2013-05-02', '5470', 'Invoice No. 0030', '38284', '0', '0', '0', 'Grand Taxi', '465287'),
('496', '1', '133', '2013-05-02', '5470', 'Invoice No. 0031', '36206', '0', '0', '0', 'Grand Taxi', '465287'),
('497', '1', '133', '2013-05-02', '5470', 'Less: Advance Payment', '-100000', '0', '0', '0', 'Grand Taxi', '465287'),
('498', '1', '133', '2013-05-02', '1060', '', '-164520', '0', '0', '0', 'Grand Taxi', '465287'),
('499', '1', '134', '2013-05-13', '5510', 'Welfare allowance - May  2013', '60000', '0', '0', '0', 'Cash', '465288'),
('500', '1', '134', '2013-05-13', '1060', '', '-60000', '0', '0', '0', 'Cash', '465288'),
('501', '1', '135', '2013-05-28', '5410', 'One month salary in lieu of notice', '215000', '0', '0', '0', '  K.S.N. Silwathge', '465289'),
('502', '1', '135', '2013-05-28', '2160', 'P.A.Y.E -16% for once and for all payments', '-34508', '0', '0', '0', '  K.S.N. Silwathge', '465289'),
('503', '1', '135', '2013-05-28', '1060', '', '-180492', '0', '0', '0', '  K.S.N. Silwathge', '465289'),
('504', '1', '136', '2013-05-28', '5410', 'One month salary in lieu of notice', '185000', '0', '0', '0', '        U. K. T. Fernando', '465290'),
('505', '1', '136', '2013-05-28', '2160', 'Less : P.A .Y.E deduction', '-29600', '0', '0', '0', '        U. K. T. Fernando', '465290'),
('506', '1', '136', '2013-05-28', '1060', '', '-155400', '0', '0', '0', '        U. K. T. Fernando', '465290'),
('507', '1', '137', '2013-05-28', '5410', 'One month salary in lieu of notice', '140000', '0', '0', '0', '       J. M. D. C. Jayasinghe', '465291'),
('508', '1', '137', '2013-05-28', '2160', 'P.A.Y.E Deduction', '-22400', '0', '0', '0', '       J. M. D. C. Jayasinghe', '465291'),
('509', '1', '137', '2013-05-28', '1060', '', '-117600', '0', '0', '0', '       J. M. D. C. Jayasinghe', '465291'),
('510', '1', '138', '2013-05-28', '5410', 'One month salary in lieu of notice', '135000', '0', '0', '0', 'Rasanka Indrajith Jayawardhana', '465292'),
('511', '1', '138', '2013-05-28', '2160', 'P.A.Y.E -16% for once and for all payments', '-21600', '0', '0', '0', 'Rasanka Indrajith Jayawardhana', '465292'),
('512', '1', '138', '2013-05-28', '1060', '', '-113400', '0', '0', '0', 'Rasanka Indrajith Jayawardhana', '465292'),
('513', '1', '139', '2013-06-03', '5470', 'Settlement of invoices No.0031', '62968', '0', '0', '0', 'New Grand Taxi', '465293'),
('514', '1', '139', '2013-06-03', '5470', 'Settlement of invoices No.0032', '122144', '0', '0', '0', 'New Grand Taxi', '465293'),
('515', '1', '139', '2013-06-03', '5470', 'Settlement of invoices No.0033', '164164', '0', '0', '0', 'New Grand Taxi', '465293'),
('516', '1', '139', '2013-06-03', '1060', '', '-349276', '0', '0', '0', 'New Grand Taxi', '465293'),
('517', '1', '140', '2013-06-04', '5450', 'The Superintendent, Employees Provident Fund', '508295', '0', '0', '4', '4', '465294'),
('518', '1', '140', '2013-06-04', '1060', '', '-508295', '0', '0', '4', '4', '465294'),
('519', '1', '141', '2013-06-04', '5460', 'Employees Trust fund- April 2013', '76244', '0', '0', '4', '5', '465295'),
('520', '1', '141', '2013-06-04', '1060', '', '-76244', '0', '0', '4', '5', '465295'),
('521', '1', '142', '2013-06-19', '2160', 'The Commissioner General of Inland Revenue', '23256', '0', '0', '4', '6', '465296'),
('522', '1', '142', '2013-06-19', '1060', '', '-23256', '0', '0', '4', '6', '465296'),
('523', '1', '143', '2013-06-21', '5510', 'Engineer of the month award - June 2013', '12500', '0', '0', '0', 'Cash', '465297'),
('524', '1', '143', '2013-06-21', '1060', '', '-12500', '0', '0', '0', 'Cash', '465297'),
('525', '1', '144', '2013-06-21', '5780', 'Settlement of staff mobile bills', '13000', '0', '0', '0', 'Cash', '465298'),
('526', '1', '144', '2013-06-21', '1060', '', '-13000', '0', '0', '0', 'Cash', '465298'),
('527', '1', '145', '2013-07-03', '5450', 'E.P.F - May 2013', '343535', '0', '0', '4', NULL, '465299'),
('528', '1', '145', '2013-07-03', '1060', '', '-343535', '0', '0', '4', NULL, '465299'),
('529', '1', '146', '2013-07-03', '5460', 'Employees Trust fund-May 2013', '51530', '0', '0', '4', '5', '554501'),
('530', '1', '146', '2013-07-03', '1060', '', '-51530', '0', '0', '4', '5', '554501'),
('531', '1', '147', '2013-07-03', '5470', 'Settlement of bills', '360315', '0', '0', '0', 'New Grand Taxi', '465300'),
('532', '1', '147', '2013-07-03', '1060', '', '-360315', '0', '0', '0', 'New Grand Taxi', '465300'),
('533', '1', '148', '2013-07-03', '1201', 'Staff Loan', '35000', '0', '0', '0', 'Uddeshika Jayawardena', '465301'),
('534', '1', '148', '2013-07-03', '1060', '', '-35000', '0', '0', '0', 'Uddeshika Jayawardena', '465301'),
('535', '1', '149', '2013-07-03', '5410', 'Salary advance - July 2013', '50000', '0', '0', '0', 'Manoj Fernando', '465302'),
('536', '1', '149', '2013-07-03', '1060', '', '-50000', '0', '0', '0', 'Manoj Fernando', '465302'),
('537', '1', '150', '2013-07-10', '5410', 'Salary advance - July 2013', '20000', '0', '0', '0', 'Nishan Jinadasa', '465303'),
('538', '1', '150', '2013-07-10', '1060', '', '-20000', '0', '0', '0', 'Nishan Jinadasa', '465303'),
('539', '1', '151', '2013-07-12', '5510', 'Staff Welfare Fund - July 2013', '60000', '0', '0', '0', 'Cash', '554506'),
('540', '1', '151', '2013-07-12', '1060', '', '-60000', '0', '0', '0', 'Cash', '554506'),
('541', '1', '152', '2013-07-12', '5510', 'Staff Mobile bills - July 2013', '13000', '0', '0', '0', 'Cash', '554507'),
('542', '1', '152', '2013-07-12', '1060', '', '-13000', '0', '0', '0', 'Cash', '554507'),
('543', '1', '153', '2013-07-25', '5510', 'Engineer of the month award - July 2013', '7500', '0', '0', '0', 'Cash', '554508'),
('544', '1', '153', '2013-07-25', '1060', '', '-7500', '0', '0', '0', 'Cash', '554508'),
('545', '1', '154', '2013-07-25', '5440', 'OPD medical expenses', '5000', '0', '0', '0', 'Nishan Jinadasa', '554509'),
('546', '1', '154', '2013-07-25', '1060', '', '-5000', '0', '0', '0', 'Nishan Jinadasa', '554509'),
('547', '1', '155', '2013-07-30', '5470', 'Advance payment against bills - July 2013', '100000', '0', '0', '0', 'New Grand Taxi', '554510'),
('548', '1', '155', '2013-07-30', '1060', '', '-100000', '0', '0', '0', 'New Grand Taxi', '554510'),
('549', '1', '156', '2013-07-31', '5470', 'Balance payment - Staff Transport', '222598', '0', '0', '0', 'New Grand Taxi', '554511'),
('550', '1', '156', '2013-07-31', '1060', '', '-222598', '0', '0', '0', 'New Grand Taxi', '554511'),
('551', '1', '157', '2013-08-02', '5450', 'Employees Provident Fund-June 2013', '406535', '0', '0', '4', '4', '554512'),
('552', '1', '157', '2013-08-02', '1060', '', '-406535', '0', '0', '4', '4', '554512'),
('553', '1', '158', '2013-08-02', '5460', 'Employees Trust fund -June 2013', '60980', '0', '0', '4', '5', '554513'),
('554', '1', '158', '2013-08-02', '1060', '', '-60980', '0', '0', '4', '5', '554513'),
('555', '1', '159', '2013-08-02', '5510', 'Staff Welfare Fund - August 2013', '60000', '0', '0', '0', 'Uddeshika Jayawardena', '554514'),
('556', '1', '159', '2013-08-02', '1060', '', '-60000', '0', '0', '0', 'Uddeshika Jayawardena', '554514'),
('557', '1', '160', '2013-08-02', '5780', 'Settlement of staff mobile bills - August 13', '13000', '0', '0', '0', 'Uddeshika Jayawardena', '554515'),
('558', '1', '160', '2013-08-02', '1060', '', '-13000', '0', '0', '0', 'Uddeshika Jayawardena', '554515'),
('559', '0', '10', '2011-03-31', '5610', 'Audit Fees for 2010/2011', '22400', '0', '0', NULL, NULL, '0'),
('560', '0', '10', '2011-03-31', '2110', 'Audit Fees for 2010/2011', '-22400', '0', '0', NULL, NULL, '0'),
('561', '0', '11', '2011-03-31', '3590', 'Closing Year', '-15434.12', '0', '0', NULL, NULL, '0');
INSERT INTO `1_gl_trans` VALUES
('562', '0', '11', '2011-03-31', '9990', 'Closing Year', '15434.12', '0', '0', NULL, NULL, '0'),
('563', '1', '161', '2011-04-07', '1220', 'Fund Transfer', '300000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '14968'),
('564', '1', '161', '2011-04-07', '1060', '', '-300000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '14968'),
('565', '1', '162', '2011-04-07', '5690', 'Debit tax', '1649.57', '0', '0', '0', 'Bank charges', '1002'),
('566', '1', '162', '2011-04-07', '1060', '', '-1649.57', '0', '0', '0', 'Bank charges', '1002'),
('567', '1', '163', '2011-04-07', '5410', 'Salary - April 2011', '981467', '0', '0', '0', 'Staff Salaries', '14971'),
('568', '1', '163', '2011-04-07', '1060', '', '-981467', '0', '0', '0', 'Staff Salaries', '14971'),
('569', '1', '164', '2011-04-07', '5690', 'Bank commission', '1600', '0', '0', '0', 'Bank charges', '14972'),
('570', '1', '164', '2011-04-07', '1060', '', '-1600', '0', '0', '0', 'Bank charges', '14972'),
('571', '2', '8', '2011-04-07', '1220', 'Settlement of invoices ', '-1000000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('572', '2', '8', '2011-04-07', '1060', '', '1000000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('573', '2', '9', '2011-05-16', '1220', 'Settlement of invoices ', '-210000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('574', '2', '9', '2011-05-16', '1060', '', '210000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('575', '2', '10', '2011-05-24', '1220', 'Settlement of invoices ', '-1200000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('576', '2', '10', '2011-05-24', '1060', '', '1200000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('577', '2', '11', '2011-06-01', '1220', 'Settlement of invoices', '-50000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('578', '2', '11', '2011-06-01', '1060', '', '50000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('579', '2', '12', '2011-06-27', '1200', 'Settlement of invoices', '0', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('580', '2', '12', '2011-06-27', '1060', '', '0', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('581', '2', '13', '2011-06-29', '1220', 'Settlement of invoices ', '-300000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('582', '2', '13', '2011-06-29', '1060', '', '300000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('583', '2', '14', '2011-07-05', '1220', 'Settlement of invoices ', '-20000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('584', '2', '14', '2011-07-05', '1060', '', '20000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('585', '2', '15', '2011-07-26', '1220', 'Settlement of invoices ', '-1000000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('586', '2', '15', '2011-07-26', '1060', '', '1000000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('587', '2', '16', '2011-07-28', '1220', 'Settlement of invoice', '0', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('588', '2', '16', '2011-07-28', '1060', '', '0', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('589', '1', '165', '2011-05-23', '5450', 'Employees Provident Fund-March 2011', '188000', '0', '0', '4', '4', '14971'),
('590', '1', '165', '2011-05-23', '1060', '', '-188000', '0', '0', '4', '4', '14971'),
('591', '1', '166', '2011-05-23', '5460', 'Employees Trust Fund - March 2011', '28200', '0', '0', '4', '5', '14972'),
('592', '1', '166', '2011-05-23', '1060', '', '-28200', '0', '0', '4', '5', '14972'),
('593', '1', '167', '2011-05-23', '5660', 'Printing Brochures', '50000', '0', '0', '0', 'Lakpriya Edirisinghe', '14973'),
('594', '1', '167', '2011-05-23', '1060', '', '-50000', '0', '0', '0', 'Lakpriya Edirisinghe', '14973'),
('595', '1', '168', '2011-05-23', '5410', 'Salary - May 2011', '1007495.8', '0', '0', '0', 'Staff Salaries', '14974'),
('596', '1', '168', '2011-05-23', '1060', '', '-1007495.8', '0', '0', '0', 'Staff Salaries', '14974'),
('597', '1', '169', '2011-06-27', '5410', 'Salary Advance -June 2011', '958518', '0', '0', '0', 'Staff Salaries', '14975'),
('598', '1', '169', '2011-06-27', '1060', '', '-958518', '0', '0', '0', 'Staff Salaries', '14975'),
('599', '1', '170', '2011-06-27', '5690', 'Bank charges', '500', '0', '0', '0', 'Bank charges', '14976'),
('600', '1', '170', '2011-06-27', '1060', '', '-500', '0', '0', '0', 'Bank charges', '14976'),
('601', '1', '171', '2011-06-27', '5690', 'Bank commission', '1500', '0', '0', '0', 'Bank charges', '14977'),
('602', '1', '171', '2011-06-27', '1060', '', '-1500', '0', '0', '0', 'Bank charges', '14977'),
('603', '1', '172', '2011-06-03', '5450', 'Employees Provident Fund-April 2011', '188000', '0', '0', '4', '4', '14974'),
('604', '1', '172', '2011-06-03', '1060', '', '-188000', '0', '0', '4', '4', '14974'),
('605', '1', '173', '2011-06-03', '5460', 'Employees Trust fund- April 2011', '28200', '0', '0', '4', '5', '14975'),
('606', '1', '173', '2011-06-03', '1060', '', '-28200', '0', '0', '4', '5', '14975'),
('607', '1', '174', '2011-06-03', '5410', '3 Months salary in lieu of notice', '195000', '0', '0', '0', 'Mr.Kevin Vaz', '14978'),
('608', '1', '174', '2011-06-03', '1060', '', '-195000', '0', '0', '0', 'Mr.Kevin Vaz', '14978'),
('609', '1', '175', '2011-06-30', '5410', '3 Months salary in lieu of notice', '165000', '0', '0', '0', 'Harsha Edirisinghe', '14977'),
('610', '1', '175', '2011-06-30', '1060', '', '-165000', '0', '0', '0', 'Harsha Edirisinghe', '14977'),
('611', '1', '176', '2011-07-05', '5450', 'Employees Provident Fund-May 2011', '172000', '0', '0', '4', '4', '14978'),
('612', '1', '176', '2011-07-05', '1060', '', '-172000', '0', '0', '4', '4', '14978'),
('613', '1', '177', '2011-07-05', '5460', 'Employees Trust Fund', '25800', '0', '0', '4', '5', '14980'),
('614', '1', '177', '2011-07-05', '1060', '', '-25800', '0', '0', '4', '5', '14980'),
('615', '1', '178', '2011-07-27', '5410', 'Salary - July 2011', '808743', '0', '0', '0', 'Staff Salaries', '14979'),
('616', '1', '178', '2011-07-27', '1060', '', '-808743', '0', '0', '0', 'Staff Salaries', '14979'),
('617', '1', '179', '2011-07-27', '5690', 'Bank commission', '1200', '0', '0', '0', 'Bank charges', '14980'),
('618', '1', '179', '2011-07-27', '1060', '', '-1200', '0', '0', '0', 'Bank charges', '14980'),
('619', '1', '180', '2011-08-01', '5410', 'Salary - May 2013', '66833', '0', '0', '0', 'Staff Salaries', '14981'),
('620', '1', '180', '2011-08-01', '1060', '', '-66833', '0', '0', '0', 'Staff Salaries', '14981'),
('621', '1', '181', '2011-08-01', '5690', 'Bank commission', '50', '0', '0', '0', 'Bank charges', '14982'),
('622', '1', '181', '2011-08-01', '1060', '', '-50', '0', '0', '0', 'Bank charges', '14982'),
('623', '1', '182', '2011-08-04', '5450', 'Employees Provident Fund-June 2011', '148000', '0', '0', '4', '4', '14983'),
('624', '1', '182', '2011-08-04', '1060', '', '-148000', '0', '0', '4', '4', '14983'),
('625', '1', '183', '2011-08-04', '5460', 'Employees Trust fund-June 2011', '22200', '0', '0', '4', '5', '14982'),
('626', '1', '183', '2011-08-04', '1060', '', '-22200', '0', '0', '4', '5', '14982'),
('627', '1', '184', '2011-08-28', '5410', 'Salary - August 2011', '808743', '0', '0', '0', 'Staff Salaries', '14984'),
('628', '1', '184', '2011-08-28', '1060', '', '-808743', '0', '0', '0', 'Staff Salaries', '14984'),
('629', '1', '185', '2011-08-28', '5690', 'Bank commission', '1300', '0', '0', '0', 'Bank charges', '14985'),
('630', '1', '185', '2011-08-28', '1060', '', '-1300', '0', '0', '0', 'Bank charges', '14985'),
('631', '2', '17', '2011-08-01', '1220', 'Settlement of invoices ', '-50000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('632', '2', '17', '2011-08-01', '1060', '', '50000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('633', '2', '18', '2011-08-01', '1220', 'Settlement of invoice', '-700000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('634', '2', '18', '2011-08-01', '1060', '', '700000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('635', '2', '19', '2011-08-29', '4430', 'IT grant from ICTB', '-274400', '0', '0', '0', 'Institute of IT', '0'),
('636', '2', '19', '2011-08-29', '1060', '', '274400', '0', '0', '0', 'Institute of IT', '0'),
('637', '1', '186', '2011-09-05', '5450', 'Employees Provident Fund-July 2011', '167940', '0', '0', '4', '4', '14983'),
('638', '1', '186', '2011-09-05', '1060', '', '-167940', '0', '0', '4', '4', '14983'),
('639', '1', '187', '2011-09-05', '5460', 'Employees Trust Fund', '25191', '0', '0', '4', '5', '14984'),
('640', '1', '187', '2011-09-05', '1060', '', '-25191', '0', '0', '4', '5', '14984'),
('641', '1', '188', '2011-09-05', '5410', 'Salary - September  2011', '820303', '0', '0', '0', 'Staff Salaries', '14986'),
('642', '1', '188', '2011-09-05', '1060', '', '-820303', '0', '0', '0', 'Staff Salaries', '14986'),
('643', '1', '189', '2011-09-05', '5690', 'Bank commission', '1500', '0', '0', '0', 'Bank charges', '14987'),
('644', '1', '189', '2011-09-05', '1060', '', '-1500', '0', '0', '0', 'Bank charges', '14987'),
('645', '1', '190', '2011-09-29', '5690', 'Bank charges', '300', '0', '0', '0', 'Bank charges', '14988'),
('646', '1', '190', '2011-09-29', '1060', '', '-300', '0', '0', '0', 'Bank charges', '14988'),
('647', '2', '20', '2011-09-05', '1220', 'Settlement of invoice', '-50000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('648', '2', '20', '2011-09-05', '1060', '', '50000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('649', '2', '21', '2011-09-28', '1220', 'Settlement of invoice', '-1047350', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('650', '2', '21', '2011-09-28', '1060', '', '1047350', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('651', '1', '191', '2011-10-03', '5460', 'Employees Trust Fund-August 2011', '25191', '0', '0', '4', '5', '14985'),
('652', '1', '191', '2011-10-03', '1060', '', '-25191', '0', '0', '4', '5', '14985'),
('653', '1', '192', '2011-10-03', '5450', 'Employees Provident Fund-August 2011', '167940', '0', '0', '4', '4', '14986'),
('654', '1', '192', '2011-10-03', '1060', '', '-167940', '0', '0', '4', '4', '14986'),
('655', '1', '193', '2011-10-27', '5410', 'Salaries - October 2011', '909843', '0', '0', '0', 'Staff Salaries', '14989'),
('656', '1', '193', '2011-10-27', '1060', '', '-909843', '0', '0', '0', 'Staff Salaries', '14989'),
('657', '2', '22', '2011-10-27', '1220', 'Settlement of Invoices', '-1000000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('658', '2', '22', '2011-10-27', '1060', '', '1000000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('659', '2', '23', '2011-11-09', '1220', 'Settlement of Invoices', '-50000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('660', '2', '23', '2011-11-09', '1060', '', '50000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('661', '2', '24', '2011-11-09', '1220', 'Settlement of Invoices', '-100000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('662', '2', '24', '2011-11-09', '1060', '', '100000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('663', '2', '25', '2011-11-28', '1220', 'Settlement of Invoices', '-900000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('664', '2', '25', '2011-11-28', '1060', '', '900000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('665', '1', '194', '2011-11-10', '5450', 'Employees Provident Fund-September 2011', '166140', '0', '0', '4', '4', '14990'),
('666', '1', '194', '2011-11-10', '1060', '', '-166140', '0', '0', '4', '4', '14990'),
('667', '1', '195', '2011-11-10', '5460', 'Employees Trust Fund-September 2011', '24921', '0', '0', '4', '5', '14991'),
('668', '1', '195', '2011-11-10', '1060', '', '-24921', '0', '0', '4', '5', '14991'),
('669', '1', '196', '2011-11-10', '5470', 'Settlement of transport Bills', '99991.22', '0', '0', '0', 'High Level Express', '14992'),
('670', '1', '196', '2011-11-10', '1060', '', '-99991.22', '0', '0', '0', 'High Level Express', '14992'),
('671', '1', '197', '2011-11-28', '5410', 'Staff Salaries - November 2011', '850343', '0', '0', '0', 'Staff Salaries', '14993'),
('672', '1', '197', '2011-11-28', '1060', '', '-850343', '0', '0', '0', 'Staff Salaries', '14993'),
('673', '1', '198', '2011-11-28', '5690', 'Bank charges', '1450', '0', '0', '0', 'Bank commission', '14994'),
('674', '1', '198', '2011-11-28', '1060', '', '-1450', '0', '0', '0', 'Bank commission', '14994'),
('675', '1', '199', '2011-11-28', '5690', 'Cheque book', '750', '0', '0', '0', 'Bank charges', '14995'),
('676', '1', '199', '2011-11-28', '1060', '', '-750', '0', '0', '0', 'Bank charges', '14995'),
('677', '1', '200', '2011-12-02', '5460', 'Employees Trust Fund-October 2011', '22521', '0', '0', '4', '5', '14995'),
('678', '1', '200', '2011-12-02', '1060', '', '-22521', '0', '0', '4', '5', '14995'),
('679', '1', '201', '2011-12-02', '5450', 'Employees Provident Fund-October 2011', '150140', '0', '0', '4', '4', '14996'),
('680', '1', '201', '2011-12-02', '1060', '', '-150140', '0', '0', '4', '4', '14996'),
('681', '1', '202', '2011-12-19', '5690', 'Bank charges', '500', '0', '0', '0', 'Bank charges', '14997'),
('682', '1', '202', '2011-12-19', '1060', '', '-500', '0', '0', '0', 'Bank charges', '14997'),
('683', '1', '203', '2011-12-19', '5410', 'Staff Salaries - DEcember 2011', '816943', '0', '0', '0', 'Staff Salaries', '14998'),
('684', '1', '203', '2011-12-19', '1060', '', '-816943', '0', '0', '0', 'Staff Salaries', '14998'),
('685', '1', '204', '2011-12-22', '5690', 'Bank charges', '1400', '0', '0', '0', 'Bank commission', '14999'),
('686', '1', '204', '2011-12-22', '1060', '', '-1400', '0', '0', '0', 'Bank commission', '14999'),
('687', '1', '205', '2011-12-22', '5410', 'Staff Salaries - DEcember 2011', '80452', '0', '0', '0', 'Staff Salaries', '15000'),
('688', '1', '205', '2011-12-22', '1060', '', '-80452', '0', '0', '0', 'Staff Salaries', '15000'),
('689', '1', '206', '2011-12-22', '5690', 'Bank charges', '500', '0', '0', '0', 'Bank commission', '15001'),
('690', '1', '206', '2011-12-22', '1060', '', '-500', '0', '0', '0', 'Bank commission', '15001'),
('691', '2', '26', '2011-12-22', '1220', 'Settlement of Invoices', '-150000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('692', '2', '26', '2011-12-22', '1060', '', '150000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('693', '2', '27', '2011-12-22', '1220', 'Settlement of Invoices', '-1000000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('694', '2', '27', '2011-12-22', '1060', '', '1000000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('695', '2', '28', '2012-01-04', '1220', 'Settlement of Invoices', '-200000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('696', '2', '28', '2012-01-04', '1060', '', '200000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('697', '2', '29', '2012-01-24', '1220', 'Settlement of Invoices', '-1100000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('698', '2', '29', '2012-01-24', '1060', '', '1100000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('699', '2', '30', '2012-01-31', '1220', 'Settlement of Invoices', '-200000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('700', '2', '30', '2012-01-31', '1060', '', '200000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('701', '1', '207', '2012-01-31', '5460', 'Employees Trust Fund-November 2011', '26391', '0', '0', '4', '5', '14997'),
('702', '1', '207', '2012-01-31', '1060', '', '-26391', '0', '0', '4', '5', '14997'),
('703', '1', '208', '2012-01-31', '5450', 'The Superintendent, Employees Provident Fund', '150140', '0', '0', '4', '4', '114998'),
('704', '1', '208', '2012-01-31', '1060', '', '-150140', '0', '0', '4', '4', '114998'),
('705', '1', '209', '2012-01-03', '2160', 'P.A.Y.e for the year 2010/2011', '145348', '0', '0', '4', '6', '15002'),
('706', '1', '209', '2012-01-03', '1060', '', '-145348', '0', '0', '4', '6', '15002'),
('707', '1', '210', '2012-01-27', '5450', 'Employees Provident Fund-November 2011', '155940', '0', '0', '4', '4', '257201'),
('708', '1', '210', '2012-01-27', '1060', '', '-155940', '0', '0', '4', '4', '257201'),
('709', '1', '211', '2012-01-27', '5460', 'Employees Trust Fund-November 2011', '20241', '0', '0', '4', '5', '257202'),
('710', '1', '211', '2012-01-27', '1060', '', '-20241', '0', '0', '4', '5', '257202'),
('711', '1', '212', '2012-01-27', '5470', 'Staff drop', '148446.97', '0', '0', '0', 'High Level Express', '15003'),
('712', '1', '212', '2012-01-27', '1060', '', '-148446.97', '0', '0', '0', 'High Level Express', '15003'),
('713', '1', '213', '2012-01-27', '5410', 'Staff Salaries - January 2012', '922588', '0', '0', '0', 'Staff Salaries', '15004'),
('714', '1', '213', '2012-01-27', '1060', '', '-922588', '0', '0', '0', 'Staff Salaries', '15004'),
('715', '1', '214', '2012-01-27', '5690', 'Bank charges', '500', '0', '0', '0', 'Bank commission', '15005'),
('716', '1', '214', '2012-01-27', '1060', '', '-500', '0', '0', '0', 'Bank commission', '15005'),
('717', '2', '31', '2012-02-27', '1220', 'Settlement of Invoices', '-1100000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('718', '2', '31', '2012-02-27', '1060', '', '1100000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('719', '2', '32', '2012-03-20', '1220', 'Settlement of Invoices', '-250000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('720', '2', '32', '2012-03-20', '1060', '', '250000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('721', '2', '33', '2012-03-20', '1220', 'Settlement of Invoices', '-1500000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('722', '2', '33', '2012-03-20', '1060', '', '1500000', '0', '0', '0', 'Evolve Technologies(Pvt)Ltd.', '0'),
('723', '1', '215', '2012-02-26', '5410', 'Staff Salaries - February 2012', '929788', '0', '0', '0', 'Staff Salaries', '15006'),
('724', '1', '215', '2012-02-26', '1060', '', '-929788', '0', '0', '0', 'Staff Salaries', '15006'),
('725', '1', '216', '2012-02-26', '5690', 'Bank charges', '500', '0', '0', '0', 'Bank commission', '15007'),
('726', '1', '216', '2012-02-26', '1060', '', '-500', '0', '0', '0', 'Bank commission', '15007'),
('727', '1', '217', '2012-03-27', '5410', 'Staff Salaries - March 2012', '1005706', '0', '0', '0', 'Staff Salaries', '15008'),
('728', '1', '217', '2012-03-27', '1060', '', '-1005706', '0', '0', '0', 'Staff Salaries', '15008'),
('729', '1', '218', '2012-03-27', '5690', 'Bank charges', '500', '0', '0', '0', 'Bank charges', '15009'),
('730', '1', '218', '2012-03-27', '1060', '', '-500', '0', '0', '0', 'Bank charges', '15009'),
('731', '1', '219', '2012-02-15', '5690', 'Bank charges', '200', '0', '0', '0', 'Bank charges', '15010'),
('732', '1', '219', '2012-02-15', '1060', '', '-200', '0', '0', '0', 'Bank charges', '15010'),
('733', '1', '220', '2012-03-09', '2160', 'P.A.Y.E -Nov&#039;11,Dec.&#039;11 &amp; Janr 2012', '17943', '0', '0', '4', '6', '257207'),
('734', '1', '220', '2012-03-09', '1060', '', '-17943', '0', '0', '4', '6', '257207'),
('735', '10', '6', '2011-04-27', '4010', '', '-1432415', '0', '0', '2', '1', '0'),
('736', '10', '6', '2011-04-27', '1200', '', '1432415', '0', '0', '2', '1', '0'),
('737', '10', '7', '2011-05-20', '4010', '', '-1451439', '0', '0', '2', '1', '0'),
('738', '10', '7', '2011-05-20', '1200', '', '1451439', '0', '0', '2', '1', '0'),
('739', '10', '8', '2011-06-20', '4010', '', '-1378415', '0', '0', '2', '1', '0'),
('740', '10', '8', '2011-06-20', '1200', '', '1378415', '0', '0', '2', '1', '0'),
('741', '10', '9', '2011-07-21', '4010', '', '-1226434', '0', '0', '2', '1', '0'),
('742', '10', '9', '2011-07-21', '1200', '', '1226434', '0', '0', '2', '1', '0'),
('743', '10', '10', '2011-08-22', '4010', '', '-1273934', '0', '0', '2', '1', '0'),
('744', '10', '10', '2011-08-22', '1200', '', '1273934', '0', '0', '2', '1', '0'),
('745', '10', '11', '2011-09-21', '4010', '', '-1049751', '0', '0', '2', '1', '0'),
('746', '10', '11', '2011-09-21', '1200', '', '1049751', '0', '0', '2', '1', '0'),
('747', '10', '12', '2011-10-21', '4010', '', '-1417608', '0', '0', '2', '1', '0'),
('748', '10', '12', '2011-10-21', '1200', '', '1417608', '0', '0', '2', '1', '0'),
('749', '10', '13', '2011-11-21', '4010', '', '-1278308', '0', '0', '2', '1', '0'),
('750', '10', '13', '2011-11-21', '1200', '', '1278308', '0', '0', '2', '1', '0'),
('751', '10', '14', '2011-12-20', '4010', '', '-1250308', '0', '0', '2', '1', '0'),
('752', '10', '14', '2011-12-20', '1200', '', '1250308', '0', '0', '2', '1', '0'),
('753', '10', '15', '2012-01-23', '4010', '', '-1385911', '0', '0', '2', '1', '0'),
('754', '10', '15', '2012-01-23', '1200', '', '1385911', '0', '0', '2', '1', '0'),
('755', '10', '16', '2012-02-20', '4010', '', '-1470462', '0', '0', '2', '1', '0'),
('756', '10', '16', '2012-02-20', '1200', '', '1470462', '0', '0', '2', '1', '0'),
('757', '10', '17', '2012-03-20', '4010', '', '-1594273', '0', '0', '2', '1', '0'),
('758', '10', '17', '2012-03-20', '1200', '', '1594273', '0', '0', '2', '1', '0'),
('759', '12', '9', '2011-04-30', '1220', '', '1432415', '0', '0', '2', '1', '0'),
('760', '12', '9', '2011-04-30', '1200', '', '-1432415', '0', '0', '2', '1', '0'),
('761', '12', '10', '2011-05-27', '1220', '', '1451439', '0', '0', '2', '1', '0'),
('762', '12', '10', '2011-05-27', '1200', '', '-1451439', '0', '0', '2', '1', '0'),
('763', '12', '11', '2011-06-28', '1220', '', '1378415', '0', '0', '2', '1', '0'),
('764', '12', '11', '2011-06-28', '1200', '', '-1378415', '0', '0', '2', '1', '0'),
('765', '12', '12', '2011-07-28', '1220', '', '1226434', '0', '0', '2', '1', '0'),
('766', '12', '12', '2011-07-28', '1200', '', '-1226434', '0', '0', '2', '1', '0'),
('767', '12', '13', '2011-08-28', '1220', '', '1273934', '0', '0', '2', '1', '0'),
('768', '12', '13', '2011-08-28', '1200', '', '-1273934', '0', '0', '2', '1', '0'),
('769', '12', '14', '2011-09-28', '1220', '', '1049751', '0', '0', '2', '1', '0'),
('770', '12', '14', '2011-09-28', '1200', '', '-1049751', '0', '0', '2', '1', '0'),
('771', '12', '15', '2011-10-27', '1220', '', '1417608', '0', '0', '2', '1', '0'),
('772', '12', '15', '2011-10-27', '1200', '', '-1417608', '0', '0', '2', '1', '0'),
('773', '12', '16', '2011-11-27', '1220', '', '1278308', '0', '0', '2', '1', '0'),
('774', '12', '16', '2011-11-27', '1200', '', '-1278308', '0', '0', '2', '1', '0'),
('775', '12', '17', '2011-12-27', '1220', '', '1250308', '0', '0', '2', '1', '0'),
('776', '12', '17', '2011-12-27', '1200', '', '-1250308', '0', '0', '2', '1', '0'),
('777', '12', '18', '2012-01-27', '1220', '', '1385911', '0', '0', '2', '1', '0'),
('778', '12', '18', '2012-01-27', '1200', '', '-1385911', '0', '0', '2', '1', '0'),
('779', '12', '19', '2012-02-27', '1220', '', '1470462', '0', '0', '2', '1', '0'),
('780', '12', '19', '2012-02-27', '1200', '', '-1470462', '0', '0', '2', '1', '0'),
('781', '12', '20', '2012-03-29', '1220', '', '1594273', '0', '0', '2', '1', '0'),
('782', '12', '20', '2012-03-29', '1200', '', '-1594273', '0', '0', '2', '1', '0'),
('783', '2', '34', '2011-06-27', '1220', 'Settlement of invoices', '-1200000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('784', '2', '34', '2011-06-27', '1060', '', '1200000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('785', '1', '221', '2011-07-11', '2160', 'P.A.Y.E - April &amp; June  2011', '15594', '0', '0', '0', 'P.A.Y.E', '15011'),
('786', '1', '221', '2011-07-11', '1220', '', '-15594', '0', '0', '0', 'P.A.Y.E', '15011'),
('787', '1', '222', '2011-08-23', '2160', 'P.A.Y.E - July  2011', '5781', '0', '0', '0', 'P.A.Y.E', '15012'),
('788', '1', '222', '2011-08-23', '1220', '', '-5781', '0', '0', '0', 'P.A.Y.E', '15012'),
('789', '1', '223', '2011-08-23', '5765', 'Office repairs', '69530', '0', '0', '0', 'Chanaka Padmaperuma', '15013'),
('790', '1', '223', '2011-08-23', '1220', '', '-69530', '0', '0', '0', 'Chanaka Padmaperuma', '15013'),
('791', '1', '224', '2012-01-25', '5615', 'News paper advertisements - Vacancies', '181944', '0', '0', '0', 'Flex Advertising', '15014'),
('792', '1', '224', '2012-01-25', '1220', '', '-181944', '0', '0', '0', 'Flex Advertising', '15014'),
('793', '1', '225', '2013-08-22', '5510', 'Engineer of the month award - August 2013', '7500', '0', '0', '0', 'Cash', '15015'),
('794', '1', '225', '2013-08-22', '1221', '', '-7500', '0', '0', '0', 'Cash', '15015'),
('795', '1', '226', '2013-08-22', '5470', 'Settlement of transport invoices ', '162925', '0', '0', '0', 'New Grand Taxi', '554520'),
('796', '1', '226', '2013-08-22', '1060', '', '-162925', '0', '0', '0', 'New Grand Taxi', '554520'),
('797', '1', '227', '2013-08-22', '5811', 'Black hat link removal project - 30% payt.', '0', '0', '0', '0', 'IAS Solutions (Pvt)Ltd.', '554521'),
('798', '1', '227', '2013-08-22', '1060', '', '0', '0', '0', '0', 'IAS Solutions (Pvt)Ltd.', '554521'),
('799', '0', '12', '2012-03-30', '5470', 'Night transport bills paid by Evolove', '444376', '0', '0', NULL, NULL, '0'),
('800', '0', '12', '2012-03-30', '5760', '50% Office rent charge - 85,000*12*50%', '510000', '0', '0', NULL, NULL, '0'),
('801', '0', '12', '2012-03-30', '5780', 'Suntel internet line paid by Evolve - 42857/15X12', '514285.8', '0', '0', NULL, NULL, '0'),
('802', '0', '12', '2012-03-30', '1220', 'Expenses incurred by Evolve on bealf of Involve', '-1468661.8', '0', '0', NULL, NULL, '0'),
('803', '0', '13', '2012-03-30', '2110', 'March 2011 bills settlement', '295360', '0', '0', NULL, NULL, '0'),
('804', '0', '13', '2012-03-30', '5450', 'E.P.F - March 2011 payment reversed', '-188000', '0', '0', NULL, NULL, '0'),
('805', '0', '13', '2012-03-30', '5460', 'E.T.F - March 2011 payment reversed', '-28200', '0', '0', NULL, NULL, '0'),
('806', '0', '13', '2012-03-30', '5470', 'Highlevel express- March 2011 payment reversed', '-79160', '0', '0', NULL, NULL, '0'),
('807', '0', '14', '2012-03-30', '2110', 'Suwasampatha medical insurance paid by Evolve', '92895.41', '0', '0', NULL, NULL, '0'),
('808', '0', '14', '2012-03-30', '1220', 'Suwasampatha medical insurance paid by Evolve', '-92895.41', '0', '0', NULL, NULL, '0'),
('809', '0', '15', '2012-03-30', '5450', 'E.P.F - March 2012', '197590', '0', '0', NULL, NULL, '0'),
('810', '0', '15', '2012-03-30', '5460', 'E.T.F - March 2012', '29638.5', '0', '0', NULL, NULL, '0'),
('811', '0', '15', '2012-03-30', '5470', 'Highlevel express bill - March 2012', '246402.36', '0', '0', NULL, NULL, '0'),
('812', '0', '15', '2012-03-30', '2110', 'Accrued charges - March 2012', '-473630.86', '0', '0', NULL, NULL, '0'),
('813', '1', '228', '2013-08-30', '5450', 'Employees Provident Fund-July 2013', '385535', '0', '0', '4', 'Quick Entry The Superintendent, Employees Provident Fund', '554522'),
('814', '1', '228', '2013-08-30', '1060', '', '-385535', '0', '0', '4', 'Quick Entry The Superintendent, Employees Provident Fund', '554522'),
('815', '1', '229', '2013-08-30', '5460', 'Employees Trust Fund-July 2013', '57830.25', '0', '0', '4', 'Quick Entry Employees Trust Fund', '554523'),
('816', '1', '229', '2013-08-30', '1060', '', '-57830.25', '0', '0', '4', 'Quick Entry Employees Trust Fund', '554523'),
('817', '1', '230', '2013-09-03', '5470', 'Transport bills - 1/8 to 22/8', '194471', '0', '0', '0', 'New Grand Taxi', '554524'),
('818', '1', '230', '2013-09-03', '1060', '', '-194471', '0', '0', '0', 'New Grand Taxi', '554524'),
('819', '0', '16', '2012-03-31', '5410', 'E.P.F 8% contribution', '0', '0', '0', NULL, NULL, '0'),
('820', '0', '16', '2012-03-31', '5450', 'E.P.F 8% contribution', '0', '0', '0', NULL, NULL, '0'),
('821', '0', '17', '2012-03-31', '5410', 'P.A.Y.E deduction for the year', '70562', '0', '0', NULL, NULL, '0'),
('822', '0', '17', '2012-03-31', '2160', 'P.A.Y.E deduction for the year', '-70562', '0', '0', NULL, NULL, '0'),
('823', '0', '18', '2012-03-31', '5790', 'Penalty on late payment of PAYE', '39768', '0', '0', NULL, NULL, '0'),
('824', '0', '18', '2012-03-31', '2160', 'Penalty on late payment of PAYE', '-39768', '0', '0', NULL, NULL, '0'),
('825', '0', '16', '2012-03-31', '5410', 'E.P.F 8% contribution', '748004', '0', '0', NULL, NULL, '0'),
('826', '0', '16', '2012-03-31', '5450', 'E.P.F 8% contribution', '-748004', '0', '0', NULL, NULL, '0'),
('827', '1', '231', '2013-09-06', '5440', 'OPD medical expenses - Chanaka', '0', '0', '0', '0', 'Cash', '554525'),
('828', '1', '231', '2013-09-06', '5440', 'OPD medical expenses - Uddeshika', '0', '0', '0', '0', 'Cash', '554525'),
('829', '1', '231', '2013-09-06', '1060', '', '0', '0', '0', '0', 'Cash', '554525'),
('830', '1', '232', '2013-09-06', '5440', 'OPD medical expenses - Chanaka', '5279', '0', '0', '0', 'Cash', '554526'),
('831', '1', '232', '2013-09-06', '5440', 'OPD medical expenses - Uddeshika', '640', '0', '0', '0', 'Cash', '554526'),
('832', '1', '232', '2013-09-06', '1060', '', '-5919', '0', '0', '0', 'Cash', '554526'),
('833', '1', '233', '2013-09-20', '5470', 'Staff Transport - Invoice no.0038 up to 15/09', '194749', '0', '0', '0', 'New Grand Taxi', '554527'),
('834', '1', '233', '2013-09-20', '1060', '', '-194749', '0', '0', '0', 'New Grand Taxi', '554527'),
('835', '1', '234', '2013-09-26', '5450', 'EPF for August - 13', '358535', '0', '0', '4', '4', '554527'),
('836', '1', '234', '2013-09-26', '1060', '', '-358535', '0', '0', '4', '4', '554527'),
('837', '1', '235', '2013-09-26', '5460', 'ETF for the month August 2013', '53780', '0', '0', '4', '5', '554528'),
('838', '1', '235', '2013-09-26', '1060', '', '-53780', '0', '0', '4', '5', '554528'),
('839', '1', '236', '2013-10-03', '5470', 'Invoice No.0040', '136392', '0', '0', '0', 'New Grand Taxi', '554529'),
('840', '1', '236', '2013-10-03', '5470', 'Invoice No.0041', '35063', '0', '0', '0', 'New Grand Taxi', '554529'),
('841', '1', '236', '2013-10-03', '1060', '', '-171455', '0', '0', '0', 'New Grand Taxi', '554529'),
('842', '1', '237', '2013-10-08', '5510', 'Cash for Staff Welfare', '0', '0', '0', '0', 'Cash', '554530'),
('843', '1', '237', '2013-10-08', '1060', '', '0', '0', '0', '0', 'Cash', '554530'),
('844', '1', '238', '2013-10-08', '5440', 'Arshad Zakeriya', '824', '0', '0', '0', 'Cash', '554531'),
('845', '1', '238', '2013-10-08', '5440', 'Harsha Wijesinghe', '5000', '0', '0', '0', 'Cash', '554531'),
('846', '1', '238', '2013-10-08', '5440', 'Harsha Wijesinghe', '4689.6', '0', '0', '0', 'Cash', '554531'),
('847', '1', '238', '2013-10-08', '1060', '', '-10513.6', '0', '0', '0', 'Cash', '554531'),
('848', '1', '239', '2013-10-10', '5440', 'Medi Expences of Dunstan Pillai', '3416.5', '0', '0', '0', 'Cash', '554532'),
('849', '1', '239', '2013-10-10', '5440', 'Medi Expences of P.Nanayakkara', '1500', '0', '0', '0', 'Cash', '554532'),
('850', '1', '239', '2013-10-10', '5440', 'Medi Expences of S.U.Pathirana', '2790', '0', '0', '0', 'Cash', '554532'),
('851', '1', '239', '2013-10-10', '1060', '', '-7706.5', '0', '0', '0', 'Cash', '554532'),
('852', '1', '240', '2013-10-10', '5410', 'Additional Wges of Kanchuka Weeranga', '3500', '0', '0', '0', 'Cash', '554533'),
('853', '1', '240', '2013-10-10', '1060', '', '-3500', '0', '0', '0', 'Cash', '554533'),
('854', '1', '241', '2013-10-14', '5460', 'ETF Penalty Charges', '12912.7', '0', '0', '0', 'Employees&#039; Trust Fund', '554534'),
('855', '1', '241', '2013-10-14', '1060', '', '-12912.7', '0', '0', '0', 'Employees&#039; Trust Fund', '554534'),
('856', '1', '242', '2013-10-17', '5470', 'Ocean + Staff transport', '134496', '0', '0', '0', 'New Grand Taxi', '554535'),
('857', '1', '242', '2013-10-17', '1060', '', '-134496', '0', '0', '0', 'New Grand Taxi', '554535'),
('858', '1', '243', '2013-10-30', '5450', 'EPF for September 13', '414135', '0', '0', '4', '4', '554536'),
('859', '1', '243', '2013-10-30', '1060', '', '-414135', '0', '0', '4', '4', '554536'),
('860', '1', '244', '2013-10-30', '5460', 'ETF for the month of September - 13', '62120', '0', '0', '4', '5', '554537'),
('861', '1', '244', '2013-10-30', '1060', '', '-62120', '0', '0', '4', '5', '554537'),
('862', '1', '245', '2013-10-30', '5440', 'Medical Expences of R.L.Satharasinghe', '5487', '0', '0', '0', 'Cash', '554538'),
('863', '1', '245', '2013-10-30', '1060', '', '-5487', '0', '0', '0', 'Cash', '554538'),
('864', '1', '246', '2013-11-01', '5470', 'Staff Transport for October 13', '143207', '0', '0', '0', 'New Grand Taxi', '554539'),
('865', '1', '246', '2013-11-01', '1060', '', '-143207', '0', '0', '0', 'New Grand Taxi', '554539'),
('866', '1', '247', '2013-11-06', '5510', 'Engineer of the month award - Fazeem Hathy', '7500', '0', '0', '0', 'Cash', '554540'),
('867', '1', '247', '2013-11-06', '5510', 'Engineer of the month award - ,alka Weerasinghe', '12500', '0', '0', '0', 'Cash', '554540'),
('868', '1', '247', '2013-11-06', '1060', '', '-20000', '0', '0', '0', 'Cash', '554540'),
('869', '1', '248', '2013-11-06', '5510', 'Petty cash reimbusements for October', '0', '0', '0', '0', 'Cash', '554541'),
('870', '1', '248', '2013-11-06', '1060', '', '0', '0', '0', '0', 'Cash', '554541'),
('871', '1', '249', '2013-11-11', '5440', 'Medical Expences ofUddeshika Jayawardhane', '4300', '0', '0', '0', 'Uddeshika Jayawardhane', '554542'),
('872', '1', '249', '2013-11-11', '1060', '', '-4300', '0', '0', '0', 'Uddeshika Jayawardhane', '554542'),
('873', '1', '250', '2013-11-11', '5440', 'Medical Expences of Lahiru Kumarasiri', '5487', '0', '0', '0', 'Lahiru Kumarasiri', '554543'),
('874', '1', '250', '2013-11-11', '1060', '', '-5487', '0', '0', '0', 'Lahiru Kumarasiri', '554543'),
('875', '1', '251', '2013-11-20', '5510', 'Engineer of the month award - Kanchuka Weeranga', '7500', '0', '0', '0', 'Cash', '554544'),
('876', '1', '251', '2013-11-20', '5510', 'Engineer of the month award - Fazeem Hathy', '7500', '0', '0', '0', 'Cash', '554544'),
('877', '1', '251', '2013-11-20', '1060', '', '-15000', '0', '0', '0', 'Cash', '554544'),
('878', '1', '252', '2013-11-20', '5440', 'Reimbursement of medical bills', '3143.92', '0', '0', '0', 'Aadil Thowfeek', '554545'),
('879', '1', '252', '2013-11-20', '1060', '', '-3143.92', '0', '0', '0', 'Aadil Thowfeek', '554545'),
('880', '1', '253', '2013-11-21', '5440', 'Medical Expences of Sanjaya Udara', '2370', '0', '0', '0', 'Sanjaya Udara Pathirana', '554547'),
('881', '1', '253', '2013-11-21', '1060', '', '-2370', '0', '0', '0', 'Sanjaya Udara Pathirana', '554547'),
('882', '1', '254', '2013-11-28', '5460', 'Employees Trust Fund for OCT 2013', '66658', '0', '0', '4', '5', '554548'),
('883', '1', '254', '2013-11-28', '1060', '', '-66658', '0', '0', '4', '5', '554548'),
('884', '1', '255', '2013-11-28', '5450', 'Employees Provident Fund for OCT 2013', '444385', '0', '0', '4', '4', '554549'),
('885', '1', '255', '2013-11-28', '1060', '', '-444385', '0', '0', '4', '4', '554549'),
('886', '1', '256', '2013-11-28', '5695', 'Mr Kristian Expenses', '30000', '0', '0', '0', 'Cash', '554550'),
('887', '1', '256', '2013-11-28', '1060', '', '-30000', '0', '0', '0', 'Cash', '554550'),
('888', '1', '257', '2013-11-28', '1180', 'Deposit for vehcial charge', '15000', '0', '0', '0', 'Casons taxi company(pvt) ltd', '638701'),
('889', '1', '257', '2013-11-28', '1060', '', '-15000', '0', '0', '0', 'Casons taxi company(pvt) ltd', '638701'),
('890', '1', '258', '2013-12-04', '5470', 'Staff Travelling &amp; Transport', '181210', '0', '0', '0', 'Highlevel Express (PVT) LTD', '554546'),
('891', '1', '258', '2013-12-04', '1060', '', '-181210', '0', '0', '0', 'Highlevel Express (PVT) LTD', '554546'),
('892', '1', '259', '2013-12-06', '5510', 'Peti cash expenses ', '100000', '0', '0', '0', 'Cash', '638703'),
('893', '1', '259', '2013-12-06', '1060', '', '-100000', '0', '0', '0', 'Cash', '638703'),
('894', '1', '260', '2013-12-10', '5510', 'Christmas card expenses', '210000', '0', '0', '0', 'Cash', '638704'),
('895', '1', '260', '2013-12-10', '1060', '', '-210000', '0', '0', '0', 'Cash', '638704'),
('896', '1', '261', '2013-12-31', '5450', 'EPF for Nov 2013', '478305', '0', '0', '4', '4', '638705'),
('897', '1', '261', '2013-12-31', '1060', '', '-478305', '0', '0', '4', '4', '638705'),
('898', '1', '262', '2013-12-31', '5460', 'ETF For Nov 2013', '71745', '0', '0', '4', '5', '638706'),
('899', '1', '262', '2013-12-31', '1060', '', '-71745', '0', '0', '4', '5', '638706'),
('900', '1', '263', '2014-01-06', '5520', 'Staff recruitment Subscription', '80000', '0', '0', '0', 'GENESIIS SOFTWARE (PVT) LTD', '638707'),
('901', '1', '263', '2014-01-06', '1060', '', '-80000', '0', '0', '0', 'GENESIIS SOFTWARE (PVT) LTD', '638707'),
('902', '1', '264', '2014-01-06', '5510', 'Engineer of the month award expenses', '7500', '0', '0', '0', 'Malka Weerasinghe', '638708'),
('903', '1', '264', '2014-01-06', '1060', '', '-7500', '0', '0', '0', 'Malka Weerasinghe', '638708'),
('904', '1', '265', '2014-01-06', '5510', 'Engineer of the month award expenses', '12500', '0', '0', '0', 'Dylan Beekmeyer ', '638709'),
('905', '1', '265', '2014-01-06', '1060', '', '-12500', '0', '0', '0', 'Dylan Beekmeyer ', '638709'),
('906', '1', '266', '2014-01-06', '5410', 'Salary Underpayment for prashmath Sriselvam', '8333', '0', '0', '0', 'Cash', '638710'),
('907', '1', '266', '2014-01-06', '1060', '', '-8333', '0', '0', '0', 'Cash', '638710'),
('908', '1', '267', '2014-01-09', '5410', 'Salaries &amp; Wages for Nishan Jinadasa', '35000', '0', '0', '0', 'Nishan Jinadasa', '638712'),
('909', '1', '267', '2014-01-09', '1060', '', '-35000', '0', '0', '0', 'Nishan Jinadasa', '638712'),
('910', '1', '268', '2014-01-13', '5510', 'Staff welfare for the month of Jan', '100000', '0', '0', '0', 'Cash', '638713'),
('911', '1', '268', '2014-01-13', '1060', '', '-100000', '0', '0', '0', 'Cash', '638713'),
('912', '1', '269', '2014-01-13', '5510', 'Marks day to day expenses', '50000', '0', '0', '0', 'Nishan Jinadasa', '638714'),
('913', '1', '269', '2014-01-13', '1060', '', '-50000', '0', '0', '0', 'Nishan Jinadasa', '638714'),
('914', '1', '270', '2014-01-13', '5765', 'Customer duty for computer servers', '22400', '0', '0', '0', 'Cash', '638715'),
('915', '1', '270', '2014-01-13', '1060', '', '-22400', '0', '0', '0', 'Cash', '638715'),
('916', '1', '271', '2014-01-17', '5440', 'Uddeshika Jayawardhane medical expenses', '2000', '0', '0', '0', 'Uddeshika Jayawardhane', '638716'),
('917', '1', '271', '2014-01-17', '1060', '', '-2000', '0', '0', '0', 'Uddeshika Jayawardhane', '638716'),
('918', '1', '272', '2014-01-17', '5440', 'Manoj Fernando Medical expenses ', '5048', '0', '0', '0', 'Manoj Fernando', '638717'),
('919', '1', '272', '2014-01-17', '1060', '', '-5048', '0', '0', '0', 'Manoj Fernando', '638717'),
('920', '1', '273', '2014-01-17', '5440', 'Arshad Zackeriya Medical expenses', '2525', '0', '0', '0', 'Arshad Zackeriya', '638718'),
('921', '1', '273', '2014-01-17', '1060', '', '-2525', '0', '0', '0', 'Arshad Zackeriya', '638718'),
('922', '1', '274', '2014-01-17', '5470', 'Staff transport expenses', '238064.3', '0', '0', '0', 'CASONS TAXI COMPANY (PVT) LTD', '638719'),
('923', '1', '274', '2014-01-17', '1060', '', '-238064.3', '0', '0', '0', 'CASONS TAXI COMPANY (PVT) LTD', '638719'),
('924', '1', '275', '2014-01-21', '5450', 'The Superintendent, Employees Provident Fund', '319880.4', '0', '0', '4', 'Quick Entry The Superintendent, Employees Provident Fund', '638720'),
('925', '1', '275', '2014-01-21', '1060', '', '-319880.4', '0', '0', '4', 'Quick Entry The Superintendent, Employees Provident Fund', '638720'),
('926', '1', '276', '2014-01-24', '5510', 'Engineer of the month award expenses', '7500', '0', '0', '0', 'Mewan Samarasinghe', '638721'),
('927', '1', '276', '2014-01-24', '1060', '', '-7500', '0', '0', '0', 'Mewan Samarasinghe', '638721'),
('928', '1', '277', '2014-01-24', '5510', 'Engineer of the month award expenses', '7500', '0', '0', '0', 'Dylan Beekmeyer', '638722'),
('929', '1', '277', '2014-01-24', '1060', '', '-7500', '0', '0', '0', 'Dylan Beekmeyer', '638722'),
('930', '1', '278', '2014-01-31', '5450', 'The Superintendent, Employees Provident Fund', '446545', '0', '0', '4', '4', '638723'),
('931', '1', '278', '2014-01-31', '1060', '', '-446545', '0', '0', '4', '4', '638723'),
('932', '1', '279', '2014-01-31', '5460', 'Employees Trust Fund', '66982', '0', '0', '4', 'Quick Entry ', '638724'),
('933', '1', '279', '2014-01-31', '1060', '', '-66982', '0', '0', '4', 'Quick Entry ', '638724'),
('934', '1', '280', '2014-02-03', '5470', 'Travelling expenses', '54235', '0', '0', '0', 'HIGHLEVEL EXPRESS (PVT) LTD', '638725'),
('935', '1', '280', '2014-02-03', '1060', '', '-54235', '0', '0', '0', 'HIGHLEVEL EXPRESS (PVT) LTD', '638725'),
('936', '1', '281', '2014-02-03', '5410', 'Bank Charges SCPC Commission ', '0', '0', '0', '0', 'Cash', '0'),
('937', '1', '281', '2014-02-03', '1060', '', '0', '0', '0', '0', 'Cash', '0'),
('938', '2', '35', '2011-04-27', '1220', 'Bank Transfers', '0', '0', '0', '0', 'Cash', '0'),
('939', '2', '35', '2011-04-27', '1060', '', '0', '0', '0', '0', 'Cash', '0'),
('940', '1', '282', '2012-04-27', '5690', 'Bank Charges SCPC Commission', '0.01', '0', '0', '0', 'Cash', '0'),
('941', '1', '282', '2012-04-27', '1060', '', '-0.01', '0', '0', '0', 'Cash', '0'),
('942', '2', '36', '2012-05-08', '1220', 'Bank Transfers', '-200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('943', '2', '36', '2012-05-08', '1220', '', '200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('944', '2', '37', '2012-05-25', '1220', 'Bank Transfers', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('945', '2', '37', '2012-05-25', '1220', '', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('946', '2', '38', '2012-05-08', '1220', 'Bank Transfers', '-200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('947', '2', '38', '2012-05-08', '1060', '', '200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('948', '2', '39', '2012-05-25', '1220', 'Bank Transfers', '-1800000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('949', '2', '39', '2012-05-25', '1060', '', '1800000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('950', '2', '40', '2012-06-15', '1220', 'Bank Transfers', '-400000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('951', '2', '40', '2012-06-15', '1060', '', '400000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('952', '1', '283', '2012-06-27', '5410', 'Saries and wages for june 2012', '0', '0', '0', '0', 'Cash', '0'),
('953', '1', '283', '2012-06-27', '5690', 'Bank Charges SCPC Commission', '0', '0', '0', '0', 'Cash', '0'),
('954', '1', '283', '2012-06-27', '1220', '', '0', '0', '0', '0', 'Cash', '0'),
('955', '2', '41', '2012-06-27', '1220', 'Bank Transfers', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('956', '2', '41', '2012-06-27', '1220', '', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('957', '2', '42', '2012-06-27', '1220', 'Bank Transfers', '-1750000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('958', '2', '42', '2012-06-27', '1060', '', '1750000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('959', '2', '43', '2012-06-27', '1220', 'Bank Transfers', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('960', '2', '43', '2012-06-27', '1060', '', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('961', '2', '44', '2012-07-23', '1220', 'Bank Transfers', '-400000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('962', '2', '44', '2012-07-23', '1060', '', '400000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('963', '2', '45', '2012-07-27', '1220', 'Bank Transfers', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('964', '2', '45', '2012-07-27', '1220', '', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('965', '2', '46', '2012-07-27', '1220', 'Bank Transfers', '-2000000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('966', '2', '46', '2012-07-27', '1060', '', '2000000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('967', '2', '47', '2012-06-18', '1220', 'Bank Transfers', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('968', '2', '47', '2012-06-18', '1060', '', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('969', '1', '284', '2012-06-18', '5690', 'Bank Charges ', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('970', '1', '284', '2012-06-18', '1060', '', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('971', '1', '285', '2012-09-29', '5410', 'Salries for Aug', '0', '0', '0', '0', 'Cash', '0'),
('972', '1', '285', '2012-09-29', '5690', 'Bank Charges SCPC Commission', '0', '0', '0', '0', 'Cash', '0'),
('973', '1', '285', '2012-09-29', '1060', '', '0', '0', '0', '0', 'Cash', '0'),
('974', '2', '48', '2012-08-28', '1220', 'Bank Transfers', '-200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('975', '2', '48', '2012-08-28', '1060', '', '200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('976', '2', '49', '2012-08-28', '1220', 'Bank Transfers', '-2200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('977', '2', '49', '2012-08-28', '1060', '', '2200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('978', '2', '50', '2012-09-04', '1220', 'Bank Transfers', '-50000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('979', '2', '50', '2012-09-04', '1060', '', '50000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('980', '2', '51', '2012-09-04', '1220', 'Bank Transfers - VISHWA', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('981', '2', '51', '2012-09-04', '1060', '', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('982', '2', '52', '2012-09-27', '1220', 'Bank Transfers', '-2300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('983', '2', '52', '2012-09-27', '1060', '', '2300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('984', '2', '53', '2012-09-05', '1220', 'Bank Transfers', '-300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('985', '2', '53', '2012-09-05', '1060', '', '300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('986', '2', '54', '2012-09-24', '1220', 'Bank Transfers', '-300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('987', '2', '54', '2012-09-24', '1060', '', '300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('988', '1', '286', '2012-09-05', '5470', 'Payment', '312063', '0', '0', '0', 'Cash', '257232'),
('989', '1', '286', '2012-09-05', '5690', 'Bank Charges', '500', '0', '0', '0', 'Cash', '257232'),
('990', '1', '286', '2012-09-05', '1060', '', '-312563', '0', '0', '0', 'Cash', '257232'),
('991', '2', '55', '2012-10-25', '1220', 'Bank Transfers', '-2500000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('992', '2', '55', '2012-10-25', '1060', '', '2500000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('993', '2', '56', '2012-10-04', '1220', 'Bank Transfers', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('994', '2', '56', '2012-10-04', '1220', '', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('995', '2', '57', '2012-10-04', '1220', 'Bank Transfers', '-300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('996', '2', '57', '2012-10-04', '1060', '', '300000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('997', '1', '287', '2012-10-05', '5790', 'Payment', '0', '0', '0', '0', 'Cash', '554547'),
('998', '1', '287', '2012-10-05', '1060', '', '0', '0', '0', '0', 'Cash', '554547'),
('999', '1', '288', '2014-02-06', '5510', 'Staff welfare for the month of Feb', '100000', '0', '0', '0', 'Cash', '638726'),
('1000', '1', '288', '2014-02-06', '1060', '', '-100000', '0', '0', '0', 'Cash', '638726'),
('1001', '1', '289', '2012-09-27', '5410', 'Salaries payment', '2093677.12', '0', '0', '0', 'Salaries', '0'),
('1002', '1', '289', '2012-09-27', '1060', '', '-2093677.12', '0', '0', '0', 'Salaries', '0'),
('1003', '2', '58', '2012-11-26', '1220', 'Bank Transfers', '-2500000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('1004', '2', '58', '2012-11-26', '1060', '', '2500000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('1005', '1', '290', '2012-11-26', '5410', 'Salaries payment', '2050538', '0', '0', '0', 'Salaries', '0'),
('1006', '1', '290', '2012-11-26', '5690', 'Bank Charges SCPC Commission', '500', '0', '0', '0', 'Salaries', '0'),
('1007', '1', '290', '2012-11-26', '1060', '', '-2051038', '0', '0', '0', 'Salaries', '0'),
('1008', '2', '59', '2012-12-06', '1220', 'Bank Transfers', '-200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('1009', '2', '59', '2012-12-06', '1060', '', '200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('1010', '1', '291', '2012-12-17', '5690', 'Bank Charges SCPC Commission', '500', '0', '0', '0', 'Cash', '0'),
('1011', '1', '291', '2012-12-17', '1060', '', '-500', '0', '0', '0', 'Cash', '0'),
('1012', '2', '60', '2012-12-18', '1210', 'Bank Transfers', '-200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('1013', '2', '60', '2012-12-18', '1060', '', '200000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('1014', '2', '61', '2012-12-19', '1210', 'Bank Transfers', '-100000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('1015', '2', '61', '2012-12-19', '1060', '', '100000', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '0'),
('1016', '1', '292', '2014-02-11', '5410', 'Salary Advance for Uddeshika Jayawardhane', '25000', '0', '0', '0', 'Uddeshika Jayawardhane', '638727'),
('1017', '1', '292', '2014-02-11', '1060', '', '-25000', '0', '0', '0', 'Uddeshika Jayawardhane', '638727'),
('1018', '1', '293', '2014-02-21', '5440', 'Medical expenses - Prasanna Vivekanandarjah', '2779', '0', '0', '0', 'Prasanna Vivekanandarjah', '638728'),
('1019', '1', '293', '2014-02-21', '1060', '', '-2779', '0', '0', '0', 'Prasanna Vivekanandarjah', '638728'),
('1020', '1', '294', '2014-02-24', '5785', 'Travelling expenses ', '6215', '0', '0', '0', 'Cash', '638729'),
('1021', '1', '294', '2014-02-24', '1060', '', '-6215', '0', '0', '0', 'Cash', '638729'),
('1022', '1', '295', '2014-02-28', '5470', 'Travelling expenses', '295632.4', '0', '0', '0', 'CASONS TAXI COMPANY (PVT) LTD', '638730'),
('1023', '1', '295', '2014-02-28', '1060', '', '-295632.4', '0', '0', '0', 'CASONS TAXI COMPANY (PVT) LTD', '638730'),
('1024', '1', '296', '2014-03-03', '5510', 'Engineer of the month award expenses', '12500', '0', '0', '0', 'Jude padidilian', '638371'),
('1025', '1', '296', '2014-03-03', '1060', '', '-12500', '0', '0', '0', 'Jude padidilian', '638371'),
('1026', '1', '297', '2014-03-03', '5510', 'Engineer of the month award expenses', '7500', '0', '0', '0', 'Mewan Samarasinghe', '638732'),
('1027', '1', '297', '2014-03-03', '1060', '', '-7500', '0', '0', '0', 'Mewan Samarasinghe', '638732'),
('1028', '1', '298', '2014-03-03', '5460', 'Employees Trust Fund', '67882', '0', '0', '4', '5', '638733');
INSERT INTO `1_gl_trans` VALUES
('1029', '1', '298', '2014-03-03', '1060', '', '-67882', '0', '0', '4', '5', '638733'),
('1030', '1', '299', '2014-03-03', '5450', 'The Superintendent, Employees Provident Fund', '452545', '0', '0', '4', '4', '638734'),
('1031', '1', '299', '2014-03-03', '1060', '', '-452545', '0', '0', '4', '4', '638734'),
('1032', '1', '300', '2014-03-10', '5410', 'Salary Advance for Bershan Mendis', '10000', '0', '0', '0', 'Bershan Mendis', '638735'),
('1033', '1', '300', '2014-03-10', '1060', '', '-10000', '0', '0', '0', 'Bershan Mendis', '638735'),
('1034', '1', '301', '2014-03-13', '5510', 'Staff refreshment expenses', '100000', '0', '0', '0', 'Cash', '638736'),
('1035', '1', '301', '2014-03-13', '1060', '', '-100000', '0', '0', '0', 'Cash', '638736'),
('1036', '1', '302', '2014-03-19', '1210', 'Refund a loan ', '50000', '0', '0', '0', 'K P L Pintoe', '638737'),
('1037', '1', '302', '2014-03-19', '1060', '', '-50000', '0', '0', '0', 'K P L Pintoe', '638737'),
('1038', '1', '303', '2014-03-20', '1201', 'Staff Loan For Uddehika Jayawardhane (Loan will be deducted in 10 monthly Instalments)', '50000', '0', '0', '0', 'Uddehika Jayawardhane', '638738'),
('1039', '1', '303', '2014-03-20', '1060', '', '-50000', '0', '0', '0', 'Uddehika Jayawardhane', '638738'),
('1040', '1', '304', '2014-03-20', '5410', 'Salary Advance for Mathaharuban Somaskandan', '20000', '0', '0', '0', 'Cash', '638739'),
('1041', '1', '304', '2014-03-20', '1060', '', '-20000', '0', '0', '0', 'Cash', '638739'),
('1042', '1', '305', '2014-03-25', '5450', 'The Superintendent, Employees Provident Fund for Feb 2014', '452545', '0', '0', '4', '4', '638740'),
('1043', '1', '305', '2014-03-25', '1060', '', '-452545', '0', '0', '4', '4', '638740'),
('1044', '1', '306', '2014-03-25', '5460', 'Employees Trust Fund', '0', '0', '0', '4', 'Quick Entry ', '638741'),
('1045', '1', '306', '2014-03-25', '1060', '', '0', '0', '0', '4', 'Quick Entry ', '638741'),
('1046', '1', '307', '2014-03-25', '5460', 'Employees Trust Fund for Feb 2014', '67882', '0', '0', '4', '5', '638742'),
('1047', '1', '307', '2014-03-25', '1060', '', '-67882', '0', '0', '4', '5', '638742'),
('1048', '1', '308', '2014-03-25', '5510', 'Engineer of the month award expenses', '7500', '0', '0', '0', 'Asantha Rathnasekara', '638743'),
('1049', '1', '308', '2014-03-25', '1060', '', '-7500', '0', '0', '0', 'Asantha Rathnasekara', '638743'),
('1050', '1', '309', '2014-03-25', '5510', 'Engineer of the month award expenses', '7500', '0', '0', '0', 'Dylan Beekmeyer', '638744'),
('1051', '1', '309', '2014-03-25', '1060', '', '-7500', '0', '0', '0', 'Dylan Beekmeyer', '638744'),
('1052', '1', '310', '2014-03-27', '5765', 'Replace Power Plant', '15500', '0', '0', '0', 'Cash', '638745'),
('1053', '1', '310', '2014-03-27', '5765', 'Additional Folate', '10000', '0', '0', '0', 'Cash', '638745'),
('1054', '1', '310', '2014-03-27', '1060', '', '-25500', '0', '0', '0', 'Cash', '638745'),
('1055', '1', '311', '2014-04-02', '5470', 'Staff transport expenses', '253168.4', '0', '0', '0', 'CASONS TAXI COMPANY (PVT) LTD', '638746'),
('1056', '1', '311', '2014-04-02', '1060', '', '-253168.4', '0', '0', '0', 'CASONS TAXI COMPANY (PVT) LTD', '638746'),
('1057', '1', '312', '2014-04-11', '5510', 'Reimbursement of expenses - Involve 360', '100000', '0', '0', '0', 'Cash', '638747'),
('1058', '1', '312', '2014-04-11', '1060', '', '-100000', '0', '0', '0', 'Cash', '638747'),
('1059', '1', '313', '2014-04-16', '5785', 'Parking fee for Januray - March 2014', '15840', '0', '0', '0', 'Cash', '638748'),
('1060', '1', '313', '2014-04-16', '1060', '', '-15840', '0', '0', '0', 'Cash', '638748'),
('1061', '1', '314', '2014-04-21', '5790', 'Additional float to Involve 360', '10000', '0', '0', '0', 'Cash', '638749'),
('1062', '1', '314', '2014-04-21', '1060', '', '-10000', '0', '0', '0', 'Cash', '638749'),
('1063', '1', '315', '2014-04-25', '5790', 'Mark &amp; kristian`s day to day expenses', '0', '0', '0', '0', 'Cash', '638750'),
('1064', '1', '315', '2014-04-25', '1060', '', '0', '0', '0', '0', 'Cash', '638750'),
('1065', '1', '316', '2014-04-25', '5790', 'Mark &amp; kristian`s day to day expenses', '50000', '0', '0', '0', 'Cash', '554548'),
('1066', '1', '316', '2014-04-25', '1060', '', '-50000', '0', '0', '0', 'Cash', '554548'),
('1067', '1', '317', '2014-04-28', '5410', 'Salary for Mohomad Yoosuf', '36800', '0', '0', '0', 'Mohomad Yoosuf', '690402'),
('1068', '1', '317', '2014-04-28', '1060', '', '-36800', '0', '0', '0', 'Mohomad Yoosuf', '690402'),
('1069', '1', '318', '2014-04-29', '2110', 'Employees Trust Fund for March 2014', '0', '0', '0', '4', NULL, '690403'),
('1070', '1', '318', '2014-04-29', '1060', '', '0', '0', '0', '4', NULL, '690403'),
('1071', '1', '319', '2014-04-29', '2110', 'The Superintendent, Employees Provident Fund for March 2014', '0', '0', '0', '4', NULL, '690404'),
('1072', '1', '319', '2014-04-29', '1060', '', '0', '0', '0', '4', NULL, '690404'),
('1073', '1', '320', '2014-04-30', '5470', 'STAFF TRANSPORT EXPENSES', '306652.4', '0', '0', '0', 'CASONS TAXI COMPANY (PVT) LTD', '690405'),
('1074', '1', '320', '2014-04-30', '1060', '', '-306652.4', '0', '0', '0', 'CASONS TAXI COMPANY (PVT) LTD', '690405'),
('1075', '1', '321', '2014-05-02', '5510', 'Engineer of the month award', '12500', '0', '0', '0', 'Bershan Mendis', '690406'),
('1076', '1', '321', '2014-05-02', '1060', '', '-12500', '0', '0', '0', 'Bershan Mendis', '690406'),
('1077', '1', '322', '2014-05-02', '5510', 'Engineer of the month award', '7500', '0', '0', '0', 'Mewan Samarasinghe', '690407'),
('1078', '1', '322', '2014-05-02', '1060', '', '-7500', '0', '0', '0', 'Mewan Samarasinghe', '690407'),
('1079', '1', '323', '2014-05-16', '5510', 'Refreshment expenses for  Apr', '130000', '0', '0', '0', 'Cash', '690408'),
('1080', '1', '323', '2014-05-16', '1060', '', '-130000', '0', '0', '0', 'Cash', '690408'),
('1081', '1', '324', '2014-05-16', '5440', 'Staff Medical expenses', '1970', '0', '0', '0', 'Cash', '690409'),
('1082', '1', '324', '2014-05-16', '1060', '', '-1970', '0', '0', '0', 'Cash', '690409'),
('1083', '1', '325', '2014-05-22', '5460', 'Service charge for Delaied payment', '3465.25', '0', '0', '4', '5', '690410'),
('1084', '1', '325', '2014-05-22', '5460', 'Service charge for Delaied payment', '5625.5', '0', '0', '4', '5', '690410'),
('1085', '1', '325', '2014-05-22', '1060', '', '-9090.75', '0', '0', '4', '5', '690410'),
('1086', '1', '326', '2014-05-26', '5470', 'Staff Transport expenses', '376717.75', '0', '0', '0', 'Casons taxi Company (PVT) LTD', '690411'),
('1087', '1', '326', '2014-05-26', '1060', '', '-376717.75', '0', '0', '0', 'Casons taxi Company (PVT) LTD', '690411'),
('1088', '1', '327', '2014-05-28', '5440', 'Staff Medical expenses  for Aziz Navaz', '1283', '0', '0', '0', 'Cash', '690412'),
('1089', '1', '327', '2014-05-28', '1060', '', '-1283', '0', '0', '0', 'Cash', '690412'),
('1090', '1', '328', '2014-05-30', '5460', 'Employees Trust fund- April 2014', '68182', '0', '0', '4', '5', '690413'),
('1091', '1', '328', '2014-05-30', '1060', '', '-68182', '0', '0', '4', '5', '690413'),
('1092', '1', '329', '2014-05-30', '5450', 'Employees Provident Fund-April 2014', '454545', '0', '0', '4', '4', '690414'),
('1093', '1', '329', '2014-05-30', '1060', '', '-454545', '0', '0', '4', '4', '690414'),
('1094', '1', '330', '2014-06-03', '5410', 'Salary for Hareendra Ranasinghe', '65103.45', '0', '0', '0', 'Cash', '690415'),
('1095', '1', '330', '2014-06-03', '1060', '', '-65103.45', '0', '0', '0', 'Cash', '690415'),
('1096', '1', '331', '2014-06-11', '5440', 'Staff Medical expenses  for Nuwan Hasitha Dias', '2588', '0', '0', '0', 'Nuwan Hasitha Dias', '690416'),
('1097', '1', '331', '2014-06-11', '1060', '', '-2588', '0', '0', '0', 'Nuwan Hasitha Dias', '690416'),
('1098', '1', '332', '2014-06-20', '5510', 'Refreshment expenses ', '130000', '0', '0', '0', 'Cash', '690417'),
('1099', '1', '332', '2014-06-20', '1060', '', '-130000', '0', '0', '0', 'Cash', '690417'),
('1100', '1', '333', '2014-06-25', '5510', 'Payment for Engineer for the month of April', '7500', '0', '0', '0', 'Asantha Rathnasekara', '690418'),
('1101', '1', '333', '2014-06-25', '1060', '', '-7500', '0', '0', '0', 'Asantha Rathnasekara', '690418'),
('1102', '1', '334', '2014-06-25', '5510', 'Payment for Engineer of the month of April', '12500', '0', '0', '0', 'Prasanna Vivekanandarajah', '690419'),
('1103', '1', '334', '2014-06-25', '1060', '', '-12500', '0', '0', '0', 'Prasanna Vivekanandarajah', '690419'),
('1104', '1', '335', '2014-06-25', '5510', 'Payment for Engineer of the month of May', '12500', '0', '0', '0', 'Praveen Nanayakkara', '690420'),
('1105', '1', '335', '2014-06-25', '1060', '', '-12500', '0', '0', '0', 'Praveen Nanayakkara', '690420'),
('1106', '1', '336', '2014-06-25', '5510', 'Payment for Engineer of the month of May', '12500', '0', '0', '0', 'Gayanga herath', '690421'),
('1107', '1', '336', '2014-06-25', '1060', '', '-12500', '0', '0', '0', 'Gayanga herath', '690421'),
('1108', '1', '337', '2014-06-25', '5470', 'Staff Transport expenses ', '292110.75', '0', '0', '0', 'Casons taxi Company (PVT) LTD', '690422'),
('1109', '1', '337', '2014-06-25', '1060', '', '-292110.75', '0', '0', '0', 'Casons taxi Company (PVT) LTD', '690422'),
('1110', '1', '338', '2014-06-30', '5450', 'The Superintendent, Employees Provident Fund', '420495', '0', '0', '4', '4', '690423'),
('1111', '1', '338', '2014-06-30', '1060', '', '-420495', '0', '0', '4', '4', '690423'),
('1112', '1', '339', '2014-06-30', '5460', 'Employees Trust Fund', '63074', '0', '0', '4', '5', '690424'),
('1113', '1', '339', '2014-06-30', '1060', '', '-63074', '0', '0', '4', '5', '690424'),
('1114', '1', '340', '2014-07-09', '2160', ' P A Y E payment for 2013 Jan to 2013 March', '175815', '0', '0', '4', '6', '690425'),
('1115', '1', '340', '2014-07-09', '1060', '', '-175815', '0', '0', '4', '6', '690425'),
('1116', '1', '341', '2013-01-07', '5690', 'Cheque book charges', '750', '0', '0', '0', 'Sampath bank', '0'),
('1117', '1', '341', '2013-01-07', '1060', '', '-750', '0', '0', '0', 'Sampath bank', '0'),
('1118', '1', '342', '2013-01-29', '5690', 'Bank Charges', '500', '0', '0', '0', 'Sampath bank', '0'),
('1119', '1', '342', '2013-01-29', '1060', '', '-500', '0', '0', '0', 'Sampath bank', '0'),
('1120', '1', '343', '2013-01-29', '5410', 'Salary payment Jan', '2422550.13', '0', '0', '0', 'Cash', '0'),
('1121', '1', '343', '2013-01-29', '1060', '', '-2422550.13', '0', '0', '0', 'Cash', '0'),
('1122', '1', '344', '2013-01-29', '1210', 'TFR', '0', '0', '0', '0', 'Cash', '0'),
('1123', '1', '344', '2013-01-29', '1060', '', '0', '0', '0', '0', 'Cash', '0'),
('1124', '2', '62', '2013-01-29', '1210', 'TFR', '0', '0', '0', '0', 'Cash', '0'),
('1125', '2', '62', '2013-01-29', '1060', '', '0', '0', '0', '0', 'Cash', '0'),
('1126', '1', '345', '2013-02-28', '5690', 'OD interset', '250', '0', '0', '0', 'Sampath bank', '0'),
('1127', '1', '345', '2013-02-28', '1060', '', '-250', '0', '0', '0', 'Sampath bank', '0'),
('1128', '1', '346', '2013-02-26', '5690', 'Bank Charges', '500', '0', '0', '0', 'Sampath bank', '0'),
('1129', '1', '346', '2013-02-26', '1060', '', '-500', '0', '0', '0', 'Sampath bank', '0'),
('1130', '1', '347', '2013-02-26', '5410', 'Salary payment Feb', '2656945.96', '0', '0', '0', 'Cash', '0'),
('1131', '1', '347', '2013-02-26', '1060', '', '-2656945.96', '0', '0', '0', 'Cash', '0'),
('1132', '2', '63', '2013-02-06', '1210', 'Fund Transfer', '-10000', '0', '0', '0', 'Cash', '0'),
('1133', '2', '63', '2013-02-06', '1060', '', '10000', '0', '0', '0', 'Cash', '0'),
('1134', '1', '348', '2013-03-27', '5410', 'Salary payment March', '2737541.92', '0', '0', '0', 'Cash', '0'),
('1135', '1', '348', '2013-03-27', '1060', '', '-2737541.92', '0', '0', '0', 'Cash', '0'),
('1136', '1', '349', '2013-03-27', '5690', 'Bank Charges', '500', '0', '0', '0', 'Sampath bank', '0'),
('1137', '1', '349', '2013-03-27', '1060', '', '-500', '0', '0', '0', 'Sampath bank', '0'),
('1138', '2', '64', '2012-12-20', '1220', 'TFR', '-2600000', '0', '0', '0', 'Cash', '0'),
('1139', '2', '64', '2012-12-20', '1060', '', '2600000', '0', '0', '0', 'Cash', '0'),
('1140', '2', '65', '2013-01-29', '1210', 'TFR', '0', '0', '0', '0', 'Cash', '0'),
('1141', '2', '65', '2013-01-29', '1060', '', '0', '0', '0', '0', 'Cash', '0'),
('1142', '2', '66', '2013-01-29', '1210', 'TFR', '0', '0', '0', '0', 'Cash', '0'),
('1143', '2', '66', '2013-01-29', '1060', '', '0', '0', '0', '0', 'Cash', '0'),
('1144', '2', '67', '2013-01-29', '1220', 'TFR', '-3000000', '0', '0', '0', 'Cash', '0'),
('1145', '2', '67', '2013-01-29', '1060', '', '3000000', '0', '0', '0', 'Cash', '0'),
('1146', '2', '68', '2013-02-26', '1220', 'TFR', '-2700000', '0', '0', '0', 'Cash', '0'),
('1147', '2', '68', '2013-02-26', '1060', '', '2700000', '0', '0', '0', 'Cash', '0'),
('1148', '2', '69', '2013-02-27', '1220', 'TFR', '-700000', '0', '0', '0', 'Cash', '0'),
('1149', '2', '69', '2013-02-27', '1060', '', '700000', '0', '0', '0', 'Cash', '0'),
('1150', '2', '70', '2013-03-08', '1220', 'fund Recived', '-400000', '0', '0', '0', 'Cash', '0'),
('1151', '2', '70', '2013-03-08', '1060', '', '400000', '0', '0', '0', 'Cash', '0'),
('1152', '2', '71', '2013-03-27', '1220', 'TFR', '-3500000', '0', '0', '0', 'Cash', '0'),
('1153', '2', '71', '2013-03-27', '1060', '', '3500000', '0', '0', '0', 'Cash', '0'),
('1154', '2', '72', '2012-04-26', '1220', 'Fund transfer', '-1350000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('1155', '2', '72', '2012-04-26', '1060', '', '1350000', '0', '0', '0', 'Evolve Technologies (Pvt)Ltd.', '0'),
('1156', '1', '350', '2012-06-27', '5690', 'Bank Charges ', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '554549'),
('1157', '1', '350', '2012-06-27', '1060', '', '0', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '554549'),
('1158', '1', '351', '2012-06-27', '5410', 'Saries and wages for june 2012', '1558502.51', '0', '0', '0', 'Cash', '554550'),
('1159', '1', '351', '2012-06-27', '5690', 'Bank Charges SCPC Commission', '500', '0', '0', '0', 'Cash', '554550'),
('1160', '1', '351', '2012-06-27', '1060', '', '-1559002.51', '0', '0', '0', 'Cash', '554550'),
('1161', '1', '352', '2012-06-18', '5690', 'Bank Charges ', '500', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '554551'),
('1162', '1', '352', '2012-06-18', '1060', '', '-500', '0', '0', '0', 'Evolve Technologies (PVT) LTD', '554551'),
('1163', '2', '73', '2012-07-23', '1220', 'TFR', '0', '0', '0', '0', 'Cash', '0'),
('1164', '2', '73', '2012-07-23', '1060', '', '0', '0', '0', '0', 'Cash', '0'),
('1165', '1', '353', '2014-07-18', '5510', 'Staff Refreshment expenses', '130000', '0', '0', '0', 'Cash', '690426'),
('1166', '1', '353', '2014-07-18', '1060', '', '-130000', '0', '0', '0', 'Cash', '690426'),
('1167', '2', '74', '2013-04-29', '1221', 'TFR', '-3500000', '0', '0', '0', 'Cash', '0'),
('1168', '2', '74', '2013-04-29', '1060', '', '3500000', '0', '0', '0', 'Cash', '0'),
('1169', '1', '354', '2013-04-29', '5410', 'Salries for Apr', '2688773.33', '0', '0', '0', 'Cash', '0'),
('1170', '1', '354', '2013-04-29', '5690', 'Bank Charges', '500', '0', '0', '0', 'Cash', '0'),
('1171', '1', '354', '2013-04-29', '1060', '', '-2689273.33', '0', '0', '0', 'Cash', '0'),
('1172', '2', '75', '2013-05-28', '1221', 'TFR', '-4000000', '0', '0', '0', 'Cash', '0'),
('1173', '2', '75', '2013-05-28', '1060', '', '4000000', '0', '0', '0', 'Cash', '0'),
('1174', '2', '76', '2013-05-03', '5410', 'Deposit', '-27600', '0', '0', '0', 'Cash', '0'),
('1175', '2', '76', '2013-05-03', '1060', '', '27600', '0', '0', '0', 'Cash', '0'),
('1176', '1', '355', '2013-05-28', '5410', 'Salries for May', '2747931.31', '0', '0', '0', 'Cash', '0'),
('1177', '1', '355', '2013-05-28', '5690', 'Bank Charges', '500', '0', '0', '0', 'Cash', '0'),
('1178', '1', '355', '2013-05-28', '1060', '', '-2748431.31', '0', '0', '0', 'Cash', '0'),
('1179', '2', '77', '2013-06-05', '1221', 'Deposit', '-300000', '0', '0', '0', 'Cash', '0'),
('1180', '2', '77', '2013-06-05', '1060', '', '300000', '0', '0', '0', 'Cash', '0'),
('1181', '2', '78', '2013-06-27', '1221', 'TFR', '-3000000', '0', '0', '0', 'Cash', '0'),
('1182', '2', '78', '2013-06-27', '1060', '', '3000000', '0', '0', '0', 'Cash', '0'),
('1183', '1', '356', '2013-06-17', '5690', 'Bank Charges', '500', '0', '0', '0', 'Cash', '0'),
('1184', '1', '356', '2013-06-17', '1060', '', '-500', '0', '0', '0', 'Cash', '0'),
('1185', '1', '357', '2013-06-25', '5690', 'Cheq book charges', '750', '0', '0', '0', 'Cash', '0'),
('1186', '1', '357', '2013-06-25', '1060', '', '-750', '0', '0', '0', 'Cash', '0'),
('1187', '1', '358', '2013-06-27', '5410', 'Salries for Jun', '2217309.36', '0', '0', '0', 'Cash', '0'),
('1188', '1', '358', '2013-06-27', '5690', 'Bank Charges', '500', '0', '0', '0', 'Cash', '0'),
('1189', '1', '358', '2013-06-27', '1060', '', '-2217809.36', '0', '0', '0', 'Cash', '0'),
('1190', '1', '359', '2013-07-26', '5410', 'Salries for July', '2101266', '0', '0', '0', 'Cash', '0'),
('1191', '1', '359', '2013-07-26', '5690', 'Bank Charges', '500', '0', '0', '0', 'Cash', '0'),
('1192', '1', '359', '2013-07-26', '1060', '', '-2101766', '0', '0', '0', 'Cash', '0'),
('1193', '2', '79', '2013-07-04', '1221', 'Deposit', '-150000', '0', '0', '0', 'Cash', '0'),
('1194', '2', '79', '2013-07-04', '1060', '', '150000', '0', '0', '0', 'Cash', '0'),
('1195', '2', '80', '2013-07-26', '1221', 'Deposit', '-20000', '0', '0', '0', 'Cash', '0'),
('1196', '2', '80', '2013-07-26', '1221', 'TFR', '-2600000', '0', '0', '0', 'Cash', '0'),
('1197', '2', '80', '2013-07-26', '1060', '', '2620000', '0', '0', '0', 'Cash', '0'),
('1198', '1', '360', '2013-07-05', '5790', 'Expenses', '0', '0', '0', '0', 'Cash', '0'),
('1199', '1', '360', '2013-07-05', '1060', '', '0', '0', '0', '0', 'Cash', '0'),
('1200', '1', '361', '2013-07-05', '5470', 'Expenses', '12733.19', '0', '0', '0', 'Kangaroo Cabs', '554504'),
('1201', '1', '361', '2013-07-05', '1060', '', '-12733.19', '0', '0', '0', 'Kangaroo Cabs', '554504'),
('1202', '2', '81', '2013-07-31', '1221', 'Deposit', '-300000', '0', '0', '0', 'Cash', '0'),
('1203', '2', '81', '2013-07-31', '1060', '', '300000', '0', '0', '0', 'Cash', '0'),
('1204', '1', '362', '2014-07-22', '5790', 'Mark`s day to day expenses', '25000', '0', '0', '0', 'Cash', '690427'),
('1205', '1', '362', '2014-07-22', '1060', '', '-25000', '0', '0', '0', 'Cash', '690427'),
('1206', '1', '363', '2014-07-24', '5410', 'Salary Advance for Safa Afrak', '10000', '0', '0', '0', 'Cash', '690428'),
('1207', '1', '363', '2014-07-24', '5410', 'Salary Advance for Abdul Aziz', '10000', '0', '0', '0', 'Cash', '690428'),
('1208', '1', '363', '2014-07-24', '5410', 'Salary Advance for Fazeem Hathy', '10000', '0', '0', '0', 'Cash', '690428'),
('1209', '1', '363', '2014-07-24', '1060', '', '-30000', '0', '0', '0', 'Cash', '690428'),
('1210', '1', '364', '2014-07-28', '5470', 'Staff Transport', '295038.65', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '690429'),
('1211', '1', '364', '2014-07-28', '1060', '', '-295038.65', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '690429'),
('1212', '1', '365', '2014-07-28', '1820', 'Purchased A/C Machine', '286513.92', '0', '0', '0', 'Frostaire Industries (PVT) LTD', '690430'),
('1213', '1', '365', '2014-07-28', '1060', '', '-286513.92', '0', '0', '0', 'Frostaire Industries (PVT) LTD', '690430'),
('1214', '10', '18', '2012-04-20', '4010', '', '0', '0', '0', '2', '1', '0'),
('1215', '10', '18', '2012-04-20', '1200', '', '0', '0', '0', '2', '1', '0'),
('1216', '10', '19', '2012-04-20', '4010', '', '-2187412', '0', '0', '2', '2', '0'),
('1217', '10', '19', '2012-04-20', '1200', '', '2187412', '0', '0', '2', '2', '0'),
('1218', '11', '1', '2012-04-20', '4010', '', '0', '0', '0', '2', '1', '0'),
('1219', '11', '1', '2012-04-20', '1200', '', '0', '0', '0', '2', '1', '0'),
('1220', '10', '20', '2012-05-20', '4010', '', '-1831238', '0', '0', '2', '2', '0'),
('1221', '10', '20', '2012-05-20', '1200', '', '1831238', '0', '0', '2', '2', '0'),
('1222', '10', '21', '2012-05-20', '4010', '', '-242489', '0', '0', '2', '2', '0'),
('1223', '10', '21', '2012-05-20', '1200', '', '242489', '0', '0', '2', '2', '0'),
('1224', '10', '22', '2012-06-20', '4010', '', '-2223206.7', '0', '0', '2', '2', '0'),
('1225', '10', '22', '2012-06-20', '1200', '', '2223206.7', '0', '0', '2', '2', '0'),
('1226', '10', '23', '2012-06-20', '4010', '', '-454718.55', '0', '0', '2', '2', '0'),
('1227', '10', '23', '2012-06-20', '1200', '', '454718.55', '0', '0', '2', '2', '0'),
('1228', '10', '24', '2012-07-20', '4010', '', '-2172852', '0', '0', '2', '2', '0'),
('1229', '10', '24', '2012-07-20', '1200', '', '2172852', '0', '0', '2', '2', '0'),
('1230', '10', '25', '2012-07-20', '4010', '', '-896148', '0', '0', '2', '2', '0'),
('1231', '10', '25', '2012-07-20', '1200', '', '896148', '0', '0', '2', '2', '0'),
('1232', '10', '26', '2012-08-20', '4010', '', '-2206454.77', '0', '0', '2', '2', '0'),
('1233', '10', '26', '2012-08-20', '1200', '', '2206454.77', '0', '0', '2', '2', '0'),
('1234', '10', '27', '2012-08-20', '4010', '', '-895863.12', '0', '0', '2', '2', '0'),
('1235', '10', '27', '2012-08-20', '1200', '', '895863.12', '0', '0', '2', '2', '0'),
('1236', '10', '28', '2012-09-20', '4010', '', '-2284160', '0', '0', '2', '2', '0'),
('1237', '10', '28', '2012-09-20', '1200', '', '2284160', '0', '0', '2', '2', '0'),
('1238', '10', '29', '2012-09-20', '4010', '', '-916735', '0', '0', '2', '2', '0'),
('1239', '10', '29', '2012-09-20', '1200', '', '916735', '0', '0', '2', '2', '0'),
('1240', '10', '30', '2012-10-20', '4010', '', '-2120666.7', '0', '0', '2', '2', '0'),
('1241', '10', '30', '2012-10-20', '1200', '', '2120666.7', '0', '0', '2', '2', '0'),
('1242', '10', '31', '2012-10-20', '4010', '', '-902858.1', '0', '0', '2', '2', '0'),
('1243', '10', '31', '2012-10-20', '1200', '', '902858.1', '0', '0', '2', '2', '0'),
('1244', '10', '32', '2012-11-20', '4010', '', '-2294072.55', '0', '0', '2', '2', '0'),
('1245', '10', '32', '2012-11-20', '1200', '', '2294072.55', '0', '0', '2', '2', '0'),
('1246', '10', '33', '2012-11-20', '4010', '', '-948244.05', '0', '0', '2', '2', '0'),
('1247', '10', '33', '2012-11-20', '1200', '', '948244.05', '0', '0', '2', '2', '0'),
('1248', '10', '34', '2012-12-20', '4010', '', '-2434411.2', '0', '0', '2', '2', '0'),
('1249', '10', '34', '2012-12-20', '1200', '', '2434411.2', '0', '0', '2', '2', '0'),
('1250', '10', '35', '2012-12-20', '4010', '', '-962691.6', '0', '0', '2', '2', '0'),
('1251', '10', '35', '2012-12-20', '1200', '', '962691.6', '0', '0', '2', '2', '0'),
('1252', '10', '36', '2013-01-20', '4010', '', '-3141009', '0', '0', '2', '2', '0'),
('1253', '10', '36', '2013-01-20', '1200', '', '3141009', '0', '0', '2', '2', '0'),
('1254', '10', '37', '2013-01-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('1255', '10', '37', '2013-01-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('1256', '10', '38', '2013-02-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('1257', '10', '38', '2013-02-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('1258', '10', '39', '2013-02-20', '4010', '', '-976075.5', '0', '0', '2', '2', '0'),
('1259', '10', '39', '2013-02-20', '1200', '', '976075.5', '0', '0', '2', '2', '0'),
('1260', '10', '40', '2013-03-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('1261', '10', '40', '2013-03-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('1262', '10', '41', '2013-03-20', '4010', '', '-891948', '0', '0', '2', '2', '0'),
('1263', '10', '41', '2013-03-20', '1200', '', '891948', '0', '0', '2', '2', '0'),
('1264', '1', '366', '2014-07-30', '5450', 'E.P.F - June 2014', '367400', '0', '0', '4', '4', '690431'),
('1265', '1', '366', '2014-07-30', '1060', '', '-367400', '0', '0', '4', '4', '690431'),
('1266', '1', '367', '2014-07-30', '5460', 'Employees Trust fund-June 2014', '55110', '0', '0', '4', '5', '690432'),
('1267', '1', '367', '2014-07-30', '1060', '', '-55110', '0', '0', '4', '5', '690432'),
('1268', '1', '368', '2014-07-31', '5610', 'Audit fees for the year of 2011', '25000', '0', '0', '0', 'POPE &amp; COMPANY', '690433'),
('1269', '1', '368', '2014-07-31', '1060', '', '-25000', '0', '0', '0', 'POPE &amp; COMPANY', '690433'),
('1270', '0', '19', '2014-07-31', '5450', 'EPF and ETF paid from wrong bank account', '96095', '0', '0', NULL, NULL, '0'),
('1271', '0', '19', '2014-07-31', '5460', 'EPF and ETF paid from wrong bank account', '14415', '0', '0', NULL, NULL, '0'),
('1272', '0', '19', '2014-07-31', '1220', 'EPF and ETF paid from wrong bank account', '-110510', '0', '0', NULL, NULL, '0'),
('1273', '10', '40', '2013-03-20', '4010', '', '-3326115.2', '0', '0', '2', '2', '0'),
('1274', '10', '40', '2013-03-20', '1200', '', '3326115.2', '0', '0', '2', '2', '0'),
('1275', '12', '21', '2012-04-30', '1221', '', '2187412', '0', '0', '2', '2', '0'),
('1276', '12', '21', '2012-04-30', '1200', '', '-2187412', '0', '0', '2', '2', '0'),
('1277', '12', '22', '2012-05-31', '1221', '', '1831238', '0', '0', '2', '2', '0'),
('1278', '12', '22', '2012-05-31', '1200', '', '-1831238', '0', '0', '2', '2', '0'),
('1279', '12', '23', '2012-05-31', '1221', '', '242489', '0', '0', '2', '2', '0'),
('1280', '12', '23', '2012-05-31', '1200', '', '-242489', '0', '0', '2', '2', '0'),
('1281', '12', '24', '2012-06-30', '1221', '', '2223206.7', '0', '0', '2', '2', '0'),
('1282', '12', '24', '2012-06-30', '1200', '', '-2223206.7', '0', '0', '2', '2', '0'),
('1283', '12', '25', '2012-06-30', '1221', '', '454718.55', '0', '0', '2', '2', '0'),
('1284', '12', '25', '2012-06-30', '1200', '', '-454718.55', '0', '0', '2', '2', '0'),
('1285', '12', '26', '2012-07-31', '1221', '', '2172852', '0', '0', '2', '2', '0'),
('1286', '12', '26', '2012-07-31', '1200', '', '-2172852', '0', '0', '2', '2', '0'),
('1287', '12', '27', '2012-07-31', '1221', '', '896148', '0', '0', '2', '2', '0'),
('1288', '12', '27', '2012-07-31', '1200', '', '-896148', '0', '0', '2', '2', '0'),
('1289', '12', '28', '2012-08-31', '1221', '', '2206454.77', '0', '0', '2', '2', '0'),
('1290', '12', '28', '2012-08-31', '1200', '', '-2206454.77', '0', '0', '2', '2', '0'),
('1291', '12', '29', '2012-08-31', '1221', '', '895863.12', '0', '0', '2', '2', '0'),
('1292', '12', '29', '2012-08-31', '1200', '', '-895863.12', '0', '0', '2', '2', '0'),
('1293', '12', '30', '2012-09-30', '1221', '', '2284160', '0', '0', '2', '2', '0'),
('1294', '12', '30', '2012-09-30', '1200', '', '-2284160', '0', '0', '2', '2', '0'),
('1295', '12', '31', '2012-09-30', '1221', '', '916735', '0', '0', '2', '2', '0'),
('1296', '12', '31', '2012-09-30', '1200', '', '-916735', '0', '0', '2', '2', '0'),
('1297', '12', '32', '2012-10-31', '1221', '', '2120666.7', '0', '0', '2', '2', '0'),
('1298', '12', '32', '2012-10-31', '1200', '', '-2120666.7', '0', '0', '2', '2', '0'),
('1299', '12', '33', '2012-10-31', '1221', '', '902858.1', '0', '0', '2', '2', '0'),
('1300', '12', '33', '2012-10-31', '1200', '', '-902858.1', '0', '0', '2', '2', '0'),
('1301', '12', '34', '2012-11-30', '1221', '', '2294072.55', '0', '0', '2', '2', '0'),
('1302', '12', '34', '2012-11-30', '1200', '', '-2294072.55', '0', '0', '2', '2', '0'),
('1303', '12', '35', '2012-11-30', '1221', '', '948244.05', '0', '0', '2', '2', '0'),
('1304', '12', '35', '2012-11-30', '1200', '', '-948244.05', '0', '0', '2', '2', '0'),
('1305', '0', '20', '2012-03-31', '3590', 'Closing Year', '-224839.95', '0', '0', NULL, NULL, '0'),
('1306', '0', '20', '2012-03-31', '9990', 'Closing Year', '224839.95', '0', '0', NULL, NULL, '0'),
('1307', '12', '36', '2012-12-31', '1221', '', '2434411.2', '0', '0', '2', '2', '0'),
('1308', '12', '36', '2012-12-31', '1200', '', '-2434411.2', '0', '0', '2', '2', '0'),
('1309', '12', '37', '2012-12-31', '1221', '', '962691.6', '0', '0', '2', '2', '0'),
('1310', '12', '37', '2012-12-31', '1200', '', '-962691.6', '0', '0', '2', '2', '0'),
('1311', '12', '38', '2013-01-31', '1221', '', '3141009', '0', '0', '2', '2', '0'),
('1312', '12', '38', '2013-01-31', '1200', '', '-3141009', '0', '0', '2', '2', '0'),
('1313', '12', '39', '2013-01-31', '1221', '', '0', '0', '0', '2', '2', '0'),
('1314', '12', '39', '2013-01-31', '1200', '', '0', '0', '0', '2', '2', '0'),
('1315', '12', '40', '2013-02-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('1316', '12', '40', '2013-02-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('1317', '12', '41', '2013-02-28', '1221', '', '976075.5', '0', '0', '2', '2', '0'),
('1318', '12', '41', '2013-02-28', '1200', '', '-976075.5', '0', '0', '2', '2', '0'),
('1319', '12', '42', '2013-03-31', '1221', '', '3326115.2', '0', '0', '2', '2', '0'),
('1320', '12', '42', '2013-03-31', '1200', '', '-3326115.2', '0', '0', '2', '2', '0'),
('1321', '12', '43', '2013-03-31', '1221', '', '891948', '0', '0', '2', '2', '0'),
('1322', '12', '43', '2013-03-31', '1200', '', '-891948', '0', '0', '2', '2', '0'),
('1323', '0', '21', '2012-03-30', '5465', 'Gratuity provision for 2012', '101850', '0', '0', NULL, NULL, '0'),
('1324', '0', '21', '2012-03-30', '5610', 'Audit fees  provision for 2012', '25000', '0', '0', NULL, NULL, '0'),
('1325', '0', '21', '2012-03-30', '2140', 'Grtuity  provision for 2012', '-101850', '0', '0', NULL, NULL, '0'),
('1326', '0', '21', '2012-03-30', '2110', 'Audit fees  provision for 2012', '-25000', '0', '0', NULL, NULL, '0'),
('1327', '0', '22', '2012-03-31', '3590', 'Closing Year', '126850', '0', '0', NULL, NULL, '0'),
('1328', '0', '22', '2012-03-31', '9990', 'Closing Year', '-126850', '0', '0', NULL, NULL, '0'),
('1329', '1', '369', '2014-08-04', '1820', 'Purchased LED TV from Laabai.lk', '79500', '0', '0', '0', 'Cash', '690434'),
('1330', '1', '369', '2014-08-04', '1060', '', '-79500', '0', '0', '0', 'Cash', '690434'),
('1331', '1', '370', '2014-08-04', '5510', 'Staff Refreshment expenses', '130000', '0', '0', '0', 'Cash', '690435'),
('1332', '1', '370', '2014-08-04', '1060', '', '-130000', '0', '0', '0', 'Cash', '690435'),
('1333', '1', '371', '2014-08-05', '5510', 'The company annual trip expenses', '0', '0', '0', '0', 'Chanaka Padmaperuma', '690436'),
('1334', '1', '371', '2014-08-05', '1060', '', '0', '0', '0', '0', 'Chanaka Padmaperuma', '690436'),
('1335', '1', '372', '2014-08-11', '5511', 'Staff Training', '5000', '0', '0', '0', 'Cash', '690437'),
('1336', '1', '372', '2014-08-11', '5765', 'Maintains of Equipment', '3500', '0', '0', '0', 'Cash', '690437'),
('1337', '1', '372', '2014-08-11', '1060', '', '-8500', '0', '0', '0', 'Cash', '690437'),
('1338', '1', '373', '2014-08-11', '5430', 'Tea Expenses for Involve 360 PVT LTD for Aug 2014', '40000', '0', '0', '0', 'Cash', '690438'),
('1339', '1', '373', '2014-08-11', '1060', '', '-40000', '0', '0', '0', 'Cash', '690438'),
('1340', '1', '374', '2014-08-11', '5510', 'Payments for engineer of the month award for the month of june', '12500', '0', '0', '0', 'Dulanjaya Athulakeerthi', '690439'),
('1341', '1', '374', '2014-08-11', '1060', '', '-12500', '0', '0', '0', 'Dulanjaya Athulakeerthi', '690439'),
('1342', '1', '375', '2014-08-11', '5510', 'Payments for engineer of the month award for the month of june', '12500', '0', '0', '0', 'Jude Padidilian', '690440'),
('1343', '1', '375', '2014-08-11', '1060', '', '-12500', '0', '0', '0', 'Jude Padidilian', '690440'),
('1344', '1', '376', '2014-08-11', '5510', 'Payments for engineer of the month award for the month of june', '12500', '0', '0', '0', 'Prasanna Vivekanandarajah', '690441'),
('1345', '1', '376', '2014-08-11', '1060', '', '-12500', '0', '0', '0', 'Prasanna Vivekanandarajah', '690441'),
('1346', '1', '377', '2014-08-20', '5510', 'Staff medical expenses', '5000', '0', '0', '0', 'Naushad Ameer', '690442'),
('1347', '1', '377', '2014-08-20', '1060', '', '-5000', '0', '0', '0', 'Naushad Ameer', '690442'),
('1348', '1', '378', '2014-08-21', '5470', 'Staff Transport', '296505.45', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '690443'),
('1349', '1', '378', '2014-08-21', '1060', '', '-296505.45', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '690443'),
('1350', '1', '379', '2014-08-21', '5440', 'Staff Medical expenses (Max 5000)', '5000', '0', '0', '0', 'Manoj Fernando', '690444'),
('1351', '1', '379', '2014-08-21', '1060', '', '-5000', '0', '0', '0', 'Manoj Fernando', '690444'),
('1352', '0', '23', '2013-03-31', '2110', 'Accrued Charges', '473630.86', '0', '0', NULL, NULL, '0'),
('1353', '0', '23', '2013-03-31', '5450', 'EPF -March 2012', '-197590', '0', '0', NULL, NULL, '0'),
('1354', '0', '23', '2013-03-31', '5460', 'ETF -March 2012', '-29638.5', '0', '0', NULL, NULL, '0'),
('1355', '0', '23', '2013-03-31', '5470', 'Staff Transport', '-246402.36', '0', '0', NULL, NULL, '0'),
('1356', '1', '380', '2014-08-27', '5765', 'Office Maintain expenses (Chanaka Padmaperuma)', '75000', '0', '0', '0', 'Cash', '690445'),
('1357', '1', '380', '2014-08-27', '1060', '', '-75000', '0', '0', '0', 'Cash', '690445'),
('1358', '1', '381', '2014-08-29', '5450', 'The Superintendent, Employees Provident Fund for july 2014', '459495', '0', '0', '4', '4', '690446'),
('1359', '1', '381', '2014-08-29', '1060', '', '-459495', '0', '0', '4', '4', '690446'),
('1360', '1', '382', '2014-08-29', '5460', 'Employees Trust Fund July 2014', '68924', '0', '0', '4', '5', '690447'),
('1361', '1', '382', '2014-08-29', '1060', '', '-68924', '0', '0', '4', '5', '690447'),
('1362', '1', '383', '2014-09-01', '5790', 'marks day to day expenses', '50000', '0', '0', '0', 'Nishan Jinadasa', '690448'),
('1363', '1', '383', '2014-09-01', '5785', 'Marks Business Visa processing expenses', '7100', '0', '0', '0', 'Nishan Jinadasa', '690448'),
('1364', '1', '383', '2014-09-01', '5765', 'Office Maintain expenses', '36500', '0', '0', '0', 'Nishan Jinadasa', '690448'),
('1365', '1', '383', '2014-09-01', '1060', '', '-93600', '0', '0', '0', 'Nishan Jinadasa', '690448'),
('1366', '0', '24', '2013-03-30', '5450', 'Employees Provident fund-march 2013', '488523', '0', '0', NULL, NULL, '0'),
('1367', '0', '24', '2013-03-30', '5460', 'Employees Trust fund-march 2013', '73278', '0', '0', NULL, NULL, '0'),
('1368', '0', '24', '2013-03-30', '5470', 'Grand Taxi bill -march 2013', '164520', '0', '0', NULL, NULL, '0'),
('1369', '0', '24', '2013-03-30', '2110', 'Accrued Charges-march 2013', '-726321', '0', '0', NULL, NULL, '0'),
('1370', '1', '384', '2014-09-03', '5440', 'Staff Medical expenses ', '4221', '0', '0', '0', 'Cash', '690449'),
('1371', '1', '384', '2014-09-03', '1060', '', '-4221', '0', '0', '0', 'Cash', '690449'),
('1372', '1', '385', '2014-09-03', '5410', 'Salary Advance for Nishan Jinadasa', '20000', '0', '0', '0', 'Nishan Jinadasa', '690450'),
('1373', '1', '385', '2014-09-03', '1060', '', '-20000', '0', '0', '0', 'Nishan Jinadasa', '690450'),
('1374', '0', '25', '2013-03-31', '5410', 'P.A.Y.E deductions for the year', '521434', '0', '0', NULL, NULL, '0'),
('1375', '0', '25', '2013-03-31', '2160', 'P.A.Y.E deductions for the year', '-521434', '0', '0', NULL, NULL, '0'),
('1376', '0', '26', '2013-03-31', '5410', 'Employee EPF contributions for the year', '1783757.2', '0', '0', NULL, NULL, '0'),
('1377', '0', '26', '2013-03-31', '5450', 'Employee EPF contributions for the year', '-1783757.2', '0', '0', NULL, NULL, '0'),
('1378', '2', '82', '2012-07-23', '1210', 'Cash from K.P.L.Pintoe', '-30000', '0', '0', '0', 'Cash', '0'),
('1379', '2', '82', '2012-07-23', '1060', '', '30000', '0', '0', '0', 'Cash', '0'),
('1380', '2', '83', '2012-09-04', '1210', 'Fund transfer', '-10000', '0', '0', '0', 'K.P.L.Pintoe', '0'),
('1381', '2', '83', '2012-09-04', '1060', '', '10000', '0', '0', '0', 'K.P.L.Pintoe', '0'),
('1382', '1', '386', '2014-09-04', '5440', 'Staff Medical expenses', '747.63', '0', '0', '0', 'Abdul Aziz bin Navaz', '727451'),
('1383', '1', '386', '2014-09-04', '1060', '', '-747.63', '0', '0', '0', 'Abdul Aziz bin Navaz', '727451'),
('1384', '1', '387', '2012-08-22', '5795', 'Secretarial fees for 2012', '0', '0', '0', '0', 'Pope &amp; Co;', '554552'),
('1385', '1', '387', '2012-08-22', '1220', '', '0', '0', '0', '0', 'Pope &amp; Co;', '554552'),
('1386', '1', '388', '2012-11-21', '5470', 'Night Drop bills', '54300.72', '0', '0', '0', 'Highlevel Express', '554553'),
('1387', '1', '388', '2012-11-21', '5470', 'Night Drop bills', '164080.26', '0', '0', '0', 'Highlevel Express', '554553'),
('1388', '1', '388', '2012-11-21', '5470', 'Night Drop bills', '136151.64', '0', '0', '0', 'Highlevel Express', '554553'),
('1389', '1', '388', '2012-11-21', '1220', '', '-354532.62', '0', '0', '0', 'Highlevel Express', '554553'),
('1390', '1', '389', '2012-11-30', '5510', 'Welfare expenses', '46000', '0', '0', '0', 'Daham Perera', '554554'),
('1391', '1', '389', '2012-11-30', '1220', '', '-46000', '0', '0', '0', 'Daham Perera', '554554'),
('1392', '1', '390', '2013-01-16', '5470', 'Night Drop bills', '106660', '0', '0', '0', 'Highlevel Express', '554555'),
('1393', '1', '390', '2013-01-16', '5470', 'Night Drop bills', '196975', '0', '0', '0', 'Highlevel Express', '554555'),
('1394', '1', '390', '2013-01-16', '1220', '', '-303635', '0', '0', '0', 'Highlevel Express', '554555'),
('1395', '1', '391', '2013-01-29', '1820', 'Laptop computer', '0', '0', '0', '0', 'Tech Information systems', '554556'),
('1396', '1', '391', '2013-01-29', '1820', 'Laptop computer', '0', '0', '0', '0', 'Tech Information systems', '554556'),
('1397', '1', '391', '2013-01-29', '1220', '', '0', '0', '0', '0', 'Tech Information systems', '554556'),
('1398', '1', '392', '2013-02-15', '5470', 'Night Drop bills', '46931', '0', '0', '0', 'Grand Taxi', '554557'),
('1399', '1', '392', '2013-02-15', '5470', 'Night Drop bills', '47605', '0', '0', '0', 'Grand Taxi', '554557'),
('1400', '1', '392', '2013-02-15', '5470', 'Night Drop bills', '26200', '0', '0', '0', 'Grand Taxi', '554557'),
('1401', '1', '392', '2013-02-15', '5470', 'Night Drop bills', '33422', '0', '0', '0', 'Grand Taxi', '554557'),
('1402', '1', '392', '2013-02-15', '1220', '', '-154158', '0', '0', '0', 'Grand Taxi', '554557'),
('1403', '1', '393', '2012-12-14', '5410', 'Salary advance', '35000', '0', '0', '0', 'Nishan Jinadasa', '554558'),
('1404', '1', '393', '2012-12-14', '1220', '', '-35000', '0', '0', '0', 'Nishan Jinadasa', '554558'),
('1405', '1', '394', '2013-02-14', '5510', 'Welfare allowance - February 2013', '60000', '0', '0', '0', 'Cash', '554559'),
('1406', '1', '394', '2013-02-14', '1220', '', '-60000', '0', '0', '0', 'Cash', '554559'),
('1407', '1', '395', '2013-01-09', '1210', 'Loan repayment', '300000', '0', '0', '0', 'K.P.L.Pintoe', '554560'),
('1408', '1', '395', '2013-01-09', '1220', '', '-300000', '0', '0', '0', 'K.P.L.Pintoe', '554560'),
('1409', '0', '27', '2013-03-31', '1220', 'Beeing transfer', '32268173.29', '0', '0', NULL, NULL, '0'),
('1410', '0', '27', '2013-03-31', '1221', 'Beeing transfer', '-32268173.29', '0', '0', NULL, NULL, '0'),
('1411', '0', '28', '2013-03-31', '5465', 'Gratuity provision for 2013', '247240', '0', '0', NULL, NULL, '0'),
('1412', '0', '28', '2013-03-31', '2140', 'Gratuity provision for 2013', '-247240', '0', '0', NULL, NULL, '0'),
('1413', '1', '396', '2014-09-10', '5410', 'Salary Advance for Uddeshika Jayawardhane', '7000', '0', '0', '0', 'Uddeshika Jayawardhane', '727452'),
('1414', '1', '396', '2014-09-10', '1060', '', '-7000', '0', '0', '0', 'Uddeshika Jayawardhane', '727452'),
('1415', '1', '397', '2014-09-11', '5510', 'Payments for engineer of the month award for the month of july', '12500', '0', '0', '0', 'Bershan Mendis', '727453'),
('1416', '1', '397', '2014-09-11', '1060', '', '-12500', '0', '0', '0', 'Bershan Mendis', '727453'),
('1417', '1', '398', '2014-09-11', '5510', 'Payments for engineer of the month award for the month of july', '12500', '0', '0', '0', 'Fazeem Jaufer Hathy', '727454'),
('1418', '1', '398', '2014-09-11', '1060', '', '-12500', '0', '0', '0', 'Fazeem Jaufer Hathy', '727454'),
('1419', '1', '399', '2014-09-11', '5510', 'Payments for engineer of the month award for the month of july', '12500', '0', '0', '0', 'Kanchuka Weeranga', '727455'),
('1420', '1', '399', '2014-09-11', '1060', '', '-12500', '0', '0', '0', 'Kanchuka Weeranga', '727455'),
('1421', '1', '400', '2014-09-12', '5460', 'Penalty for late payment', '3394.1', '0', '0', '4', '5', '727456'),
('1422', '1', '400', '2014-09-12', '1060', '', '-3394.1', '0', '0', '4', '5', '727456'),
('1423', '1', '401', '2014-09-15', '5510', 'Staff Refreshment expenses Aug (Tea expenses also inculded)', '0', '0', '0', '0', 'Cash', '727457'),
('1424', '1', '401', '2014-09-15', '1060', '', '0', '0', '0', '0', 'Cash', '727457'),
('1425', '1', '402', '2014-09-15', '5470', 'Staff Transport expenses', '313093.4', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '727457'),
('1426', '1', '402', '2014-09-15', '1060', '', '-313093.4', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '727457'),
('1427', '1', '403', '2014-09-15', '5510', 'Staff Refreshment expenses Aug (Tea expenses also inculded)', '0', '0', '0', '0', 'Cash', '554561'),
('1428', '1', '403', '2014-09-15', '1060', '', '0', '0', '0', '0', 'Cash', '554561'),
('1429', '1', '404', '2014-09-15', '5510', 'Staff Refreshment expenses Aug (Tea expenses also inculded)', '0', '0', '0', '0', 'Cash', '727459'),
('1430', '1', '404', '2014-09-15', '1060', '', '0', '0', '0', '0', 'Cash', '727459'),
('1431', '1', '405', '2014-09-15', '5510', 'Staff Refreshment expenses Aug (Tea expenses also inculded)', '170000', '0', '0', '0', 'Cash', '554562'),
('1432', '1', '405', '2014-09-15', '1060', '', '-170000', '0', '0', '0', 'Cash', '554562'),
('1433', '1', '406', '2014-09-29', '5510', 'Payments for engineer of the month award for the month of Aug 2014', '7500', '0', '0', '0', 'Dulanjaya Athulakeerthi', '727460'),
('1434', '1', '406', '2014-09-29', '1060', '', '-7500', '0', '0', '0', 'Dulanjaya Athulakeerthi', '727460'),
('1435', '1', '407', '2014-09-29', '5510', 'Payments for engineer of the month award for the month of Aug 2014', '12500', '0', '0', '0', 'Prashanth Shriselwam', '727461'),
('1436', '1', '407', '2014-09-29', '1060', '', '-12500', '0', '0', '0', 'Prashanth Shriselwam', '727461'),
('1437', '1', '408', '2014-09-29', '5510', 'Payments for engineer of the month award for the month of Aug 2014', '12500', '0', '0', '0', 'Dylan Beekmeyer', '727462'),
('1438', '1', '408', '2014-09-29', '1060', '', '-12500', '0', '0', '0', 'Dylan Beekmeyer', '727462'),
('1439', '1', '409', '2014-09-30', '5450', 'The Superintendent, Employees Provident Fund sep 2014', '434520', '0', '0', '4', '4', '727463'),
('1440', '1', '409', '2014-09-30', '1060', '', '-434520', '0', '0', '4', '4', '727463'),
('1441', '1', '410', '2014-09-30', '5460', 'Employees Trust Fund sep 2014', '65178', '0', '0', '4', '5', '727464'),
('1442', '1', '410', '2014-09-30', '1060', '', '-65178', '0', '0', '4', '5', '727464'),
('1443', '1', '411', '2014-10-02', '5440', 'Staff Medical expenses', '5000', '0', '0', '0', 'Lahiru Kumarasiri', '727465'),
('1444', '1', '411', '2014-10-02', '1060', '', '-5000', '0', '0', '0', 'Lahiru Kumarasiri', '727465'),
('1445', '1', '412', '2014-10-14', '5785', 'Parking Charges', '15840', '0', '0', '0', 'Cash', '727466'),
('1446', '1', '412', '2014-10-14', '1060', '', '-15840', '0', '0', '0', 'Cash', '727466'),
('1447', '1', '413', '2014-10-14', '5510', 'Staff Refreshment expenses Sep 2014', '170000', '0', '0', '0', 'Cash', '727467'),
('1448', '1', '413', '2014-10-14', '1060', '', '-170000', '0', '0', '0', 'Cash', '727467'),
('1449', '1', '414', '2014-10-24', '5765', 'Replacement of LED Bulb', '0', '0', '0', '0', NULL, '727468'),
('1450', '1', '414', '2014-10-24', '5765', 'Replacement of LED Bulb', '0', '0', '0', '0', NULL, '727468'),
('1451', '1', '414', '2014-10-24', '1060', '', '0', '0', '0', '0', NULL, '727468'),
('1452', '1', '415', '2014-10-24', '5470', ' Transport expenses', '321114.9', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '727469'),
('1453', '1', '415', '2014-10-24', '1060', '', '-321114.9', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '727469'),
('1454', '1', '416', '2014-10-28', '5450', 'The Superintendent, Employees Provident Fund for the month of Oct 2014', '481995', '0', '0', '4', '4', '727470'),
('1455', '1', '416', '2014-10-28', '1060', '', '-481995', '0', '0', '4', '4', '727470'),
('1456', '1', '417', '2014-10-28', '5460', 'Employees Trust Fund fot the month of oct 2014', '72299.25', '0', '0', '4', '5', '727471'),
('1457', '1', '417', '2014-10-28', '1060', '', '-72299.25', '0', '0', '4', '5', '727471'),
('1458', '1', '418', '2014-11-04', '5510', 'Payments for engineer of the month award for the month of Sep 2014', '12500', '0', '0', '0', 'Bershan Mendis', '727472'),
('1459', '1', '418', '2014-11-04', '1060', '', '-12500', '0', '0', '0', 'Bershan Mendis', '727472'),
('1460', '1', '419', '2014-11-04', '5510', 'Payments for engineer of the month award for the month of Sep 2014', '12500', '0', '0', '0', 'Dulanjaya Athulakeerthi', '727472'),
('1461', '1', '419', '2014-11-04', '1060', '', '-12500', '0', '0', '0', 'Dulanjaya Athulakeerthi', '727472'),
('1462', '1', '420', '2014-11-04', '5510', 'Payments for engineer of the month award for the month of Sep 2014', '12500', '0', '0', '0', 'Jude Padidilian', '727474'),
('1463', '1', '420', '2014-11-04', '1060', '', '-12500', '0', '0', '0', 'Jude Padidilian', '727474'),
('1464', '1', '421', '2014-11-04', '5765', 'Replacement of LED Bulb', '29155', '0', '0', '0', 'Cash', '727475'),
('1465', '1', '421', '2014-11-04', '5765', 'Replacement of LED Bulb', '11900', '0', '0', '0', 'Cash', '727475'),
('1466', '1', '421', '2014-11-04', '1060', '', '-41055', '0', '0', '0', 'Cash', '727475'),
('1467', '1', '422', '2014-11-26', '5510', 'Staff Refreshment expenses Oct 2014', '140000', '0', '0', '0', 'Cash', '727476'),
('1468', '1', '422', '2014-11-26', '1060', '', '-140000', '0', '0', '0', 'Cash', '727476'),
('1469', '1', '423', '2014-11-27', '5470', 'Staff Transport expenses', '401014', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '727477'),
('1470', '1', '423', '2014-11-27', '1060', '', '-401014', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '727477'),
('1471', '1', '424', '2014-11-28', '5450', 'The Superintendent, Employees Provident Fund Month Of Oct 2014', '488625', '0', '0', '4', '4', '727478'),
('1472', '1', '424', '2014-11-28', '1060', '', '-488625', '0', '0', '4', '4', '727478'),
('1473', '1', '425', '2014-11-28', '5460', 'Employees Trust Fund Month Of Oct 2014', '73294', '0', '0', '4', '5', '727479'),
('1474', '1', '425', '2014-11-28', '1060', '', '-73294', '0', '0', '4', '5', '727479'),
('1475', '1', '426', '2014-12-05', '5510', 'Payments for engineer of the month award ', '12500', '0', '0', '0', 'Prasanna Vivekanandarajah', '727480'),
('1476', '1', '426', '2014-12-05', '1060', '', '-12500', '0', '0', '0', 'Prasanna Vivekanandarajah', '727480'),
('1477', '1', '427', '2014-12-05', '5510', 'Payments for engineer of the month award', '12500', '0', '0', '0', 'Fazeem Hathy', '727481'),
('1478', '1', '427', '2014-12-05', '1060', '', '-12500', '0', '0', '0', 'Fazeem Hathy', '727481'),
('1479', '1', '428', '2014-12-09', '5510', 'Christmas party expenses ', '350000', '0', '0', '0', 'Uddeshika Jayawardhane', '727482'),
('1480', '1', '428', '2014-12-09', '5510', 'Staff T-shirt expenses', '108750', '0', '0', '0', 'Uddeshika Jayawardhane', '727482'),
('1481', '1', '428', '2014-12-09', '1060', '', '-458750', '0', '0', '0', 'Uddeshika Jayawardhane', '727482'),
('1482', '1', '429', '2014-12-31', '5460', 'Employees Trust fund for the month of Dec  2014', '73294', '0', '0', '4', '5', '727483'),
('1483', '1', '429', '2014-12-31', '1060', '', '-73294', '0', '0', '4', '5', '727483'),
('1484', '1', '430', '2014-12-31', '5450', 'The Superintendent, Employees Provident Fund for the month of Dec 2014', '488625', '0', '0', '4', '4', '727484'),
('1485', '1', '430', '2014-12-31', '1060', '', '-488625', '0', '0', '4', '4', '727484'),
('1486', '1', '431', '2015-01-13', '5520', 'Staff Recrument expenses', '86250', '0', '0', '0', 'Genesiis Software (PVT) LTD', '727485'),
('1487', '1', '431', '2015-01-13', '1060', '', '-86250', '0', '0', '0', 'Genesiis Software (PVT) LTD', '727485'),
('1488', '1', '432', '2015-01-13', '5510', 'Payments for engineer of the month award for the month of Nov 2014', '12500', '0', '0', '0', 'Prasanna Vivekanandarajah', '727486'),
('1489', '1', '432', '2015-01-13', '1060', '', '-12500', '0', '0', '0', 'Prasanna Vivekanandarajah', '727486'),
('1490', '1', '433', '2015-01-13', '5510', 'Payments for engineer of the month award for the month of Nov 2014', '12500', '0', '0', '0', 'Gayan Edirisinghe', '727487'),
('1491', '1', '433', '2015-01-13', '1060', '', '-12500', '0', '0', '0', 'Gayan Edirisinghe', '727487'),
('1492', '1', '434', '2015-01-13', '5510', 'Staff Refreshment expenses Dec 2014', '140000', '0', '0', '0', 'Cash', '727488'),
('1493', '1', '434', '2015-01-13', '1060', '', '-140000', '0', '0', '0', 'Cash', '727488'),
('1494', '1', '435', '2015-01-16', '5460', 'Employees Trust Fund-Delayed Payment ', '27408.8', '0', '0', '4', '5', '727491'),
('1495', '1', '435', '2015-01-16', '1060', '', '-27408.8', '0', '0', '4', '5', '727491'),
('1496', '1', '436', '2015-01-21', '5510', 'Payments for engineer of the month award for the month of Nov 2014', '12500', '0', '0', '0', 'Safa Afrak', '727492'),
('1497', '1', '436', '2015-01-21', '1060', '', '-12500', '0', '0', '0', 'Safa Afrak', '727492'),
('1498', '1', '437', '2015-01-26', '5440', 'Staff Medical expenses (Manoj Fernando)', '5000', '0', '0', '0', 'Manoj Fernando', '727493'),
('1499', '1', '437', '2015-01-26', '1060', '', '-5000', '0', '0', '0', 'Manoj Fernando', '727493'),
('1500', '1', '438', '2015-01-27', '5780', 'Dialog CDMA Bill payment (Dec)', '2508', '0', '0', '0', 'Cash', '727494'),
('1501', '1', '438', '2015-01-27', '5780', 'Dialog CDMA Bill payment(Dec)', '2341', '0', '0', '0', 'Cash', '727494'),
('1502', '1', '438', '2015-01-27', '5780', 'Dialog CDMA Bill payment (Jan)', '1115.68', '0', '0', '0', 'Cash', '727494'),
('1503', '1', '438', '2015-01-27', '5780', 'Dialog CDMA Bill payment (Jan)', '1115.68', '0', '0', '0', 'Cash', '727494'),
('1504', '1', '438', '2015-01-27', '5785', 'Payment Church for Parking slot (Jan-Mar for 2 slots)', '15840', '0', '0', '0', 'Cash', '727494'),
('1505', '1', '438', '2015-01-27', '1060', '', '-22920.36', '0', '0', '0', 'Cash', '727494'),
('1506', '1', '439', '2015-01-27', '5700', 'Payment for Design imprints', '105480', '0', '0', '0', 'Design imprints', '727495'),
('1507', '1', '439', '2015-01-27', '1060', '', '-105480', '0', '0', '0', 'Design imprints', '727495'),
('1508', '1', '440', '2015-01-27', '5510', 'Payment for performance Incentive', '0', '0', '0', '0', 'Cash', '727496'),
('1509', '1', '440', '2015-01-27', '1060', '', '0', '0', '0', '0', 'Cash', '727496'),
('1510', '1', '441', '2015-01-29', '5470', 'Staff Transport', '449591.3', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '727497');
INSERT INTO `1_gl_trans` VALUES
('1511', '1', '441', '2015-01-29', '1060', '', '-449591.3', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '727497'),
('1512', '1', '442', '2015-01-29', '5450', 'The Superintendent, Employees Provident Fund for the month of Jan 2015', '545000', '0', '0', '4', '4', '727498'),
('1513', '1', '442', '2015-01-29', '1060', '', '-545000', '0', '0', '4', '4', '727498'),
('1514', '1', '443', '2015-01-29', '5460', 'Employees Trust Fund for the month of jan 2015', '81750', '0', '0', '4', '5', '727499'),
('1515', '1', '443', '2015-01-29', '1060', '', '-81750', '0', '0', '4', '5', '727499'),
('1516', '1', '444', '2015-02-06', '5510', 'Payments for engineer of the month award for the month of DEC 2014', '12500', '0', '0', '0', 'Sahan Senevirathne', '727500'),
('1517', '1', '444', '2015-02-06', '1060', '', '-12500', '0', '0', '0', 'Sahan Senevirathne', '727500'),
('1518', '1', '445', '2015-02-06', '5510', 'Payments for engineer of the month award for the month of Dec 2014', '12500', '0', '0', '0', 'Jude Shanaka', '779551'),
('1519', '1', '445', '2015-02-06', '1060', '', '-12500', '0', '0', '0', 'Jude Shanaka', '779551'),
('1520', '1', '446', '2015-02-06', '5510', 'Payment for Award for becoming the Team Leader of the month for 3 consecutive month ', '17500', '0', '0', '0', 'Prasanna Vivekanandarajah', '779552'),
('1521', '1', '446', '2015-02-06', '1060', '', '-17500', '0', '0', '0', 'Prasanna Vivekanandarajah', '779552'),
('1522', '1', '447', '2015-02-06', '5440', 'Staff Medical expenses', '2490', '0', '0', '0', 'Uddeshika Jayawardhane', '779553'),
('1523', '1', '447', '2015-02-06', '1060', '', '-2490', '0', '0', '0', 'Uddeshika Jayawardhane', '779553'),
('1524', '1', '448', '2015-02-06', '5610', 'Anmual fees for Pope &amp; Company', '17600', '0', '0', '0', 'POPE &amp; COMPANY CONSULTANTS (PVT) LTD', '779554'),
('1525', '1', '448', '2015-02-06', '1060', '', '-17600', '0', '0', '0', 'POPE &amp; COMPANY CONSULTANTS (PVT) LTD', '779554'),
('1526', '1', '449', '2015-02-10', '5765', 'Additional Office work payment', '500000', '0', '0', '0', 'Chanaka Padmaperuma ', '779555'),
('1527', '1', '449', '2015-02-10', '1060', '', '-500000', '0', '0', '0', 'Chanaka Padmaperuma ', '779555'),
('1528', '1', '450', '2015-02-16', '5510', 'Staff Refreshment expenses Jan 2014', '140000', '0', '0', '0', 'Cash', '779556'),
('1529', '1', '450', '2015-02-16', '1060', '', '-140000', '0', '0', '0', 'Cash', '779556'),
('1530', '1', '451', '2013-08-27', '5410', 'Salaries for Involve Staff  Aug 2013', '2280412.67', '0', '0', '0', 'Cash', '0'),
('1531', '1', '451', '2013-08-27', '5690', 'Bank Charges', '500', '0', '0', '0', 'Cash', '0'),
('1532', '1', '451', '2013-08-27', '1060', '', '-2280912.67', '0', '0', '0', 'Cash', '0'),
('1533', '2', '84', '2013-08-08', '1221', 'Fund transfer', '-150000', '0', '0', '0', 'Fund transfer', '0'),
('1534', '2', '84', '2013-08-08', '1060', '', '150000', '0', '0', '0', 'Fund transfer', '0'),
('1535', '2', '85', '2013-08-22', '1221', 'Fund transfer', '-2800000', '0', '0', '0', 'Fund transfer', '0'),
('1536', '2', '85', '2013-08-22', '1060', '', '2800000', '0', '0', '0', 'Fund transfer', '0'),
('1537', '2', '86', '2013-09-02', '1221', 'Fund transfer', '-200000', '0', '0', '0', 'Fund transfer', '0'),
('1538', '2', '86', '2013-09-02', '1060', '', '200000', '0', '0', '0', 'Fund transfer', '0'),
('1539', '2', '87', '2013-09-02', '1221', 'Fund transfer', '-100000', '0', '0', '0', 'Fund transfer', '0'),
('1540', '2', '87', '2013-09-02', '1060', '', '100000', '0', '0', '0', 'Fund transfer', '0'),
('1541', '2', '88', '2013-09-27', '1221', 'Fund transfer', '-2800000', '0', '0', '0', 'Fund transfer', '0'),
('1542', '2', '88', '2013-09-27', '1060', '', '2800000', '0', '0', '0', 'Fund transfer', '0'),
('1543', '1', '452', '2013-09-27', '5410', 'Salaries for Involve Staff  Sep 2013', '2286260', '0', '0', '0', 'Salaries', '0'),
('1544', '1', '452', '2013-09-27', '5690', 'Salaries for Involve Staff  Sep 2013', '500', '0', '0', '0', 'Salaries', '0'),
('1545', '1', '452', '2013-09-27', '1060', '', '-2286760', '0', '0', '0', 'Salaries', '0'),
('1546', '2', '89', '2013-09-18', '1221', 'Fund transfer', '-500000', '0', '0', '0', 'Fund transfer', '0'),
('1547', '2', '89', '2013-09-18', '1060', '', '500000', '0', '0', '0', 'Fund transfer', '0'),
('1548', '2', '90', '2013-10-28', '1221', 'Fund transfer', '-3000000', '0', '0', '0', 'Fund transfer', '0'),
('1549', '2', '90', '2013-10-28', '1060', '', '3000000', '0', '0', '0', 'Fund transfer', '0'),
('1550', '1', '453', '2013-10-28', '5410', 'Salaries for Involve Staff  Oct 2013', '2401321.83', '0', '0', '0', 'Salaries', '0'),
('1551', '1', '453', '2013-10-28', '5690', 'Bank Charges', '500', '0', '0', '0', 'Salaries', '0'),
('1552', '1', '453', '2013-10-28', '1060', '', '-2401821.83', '0', '0', '0', 'Salaries', '0'),
('1553', '1', '454', '2013-10-28', '5690', 'OD Interest', '250', '0', '0', '0', 'OD Interest', '0'),
('1554', '1', '454', '2013-10-28', '1060', '', '-250', '0', '0', '0', 'OD Interest', '0'),
('1555', '1', '455', '2013-11-22', '5690', 'CHK Book Charge', '750', '0', '0', '0', 'Bank Charges', '0'),
('1556', '1', '455', '2013-11-22', '1060', '', '-750', '0', '0', '0', 'Bank Charges', '0'),
('1557', '1', '456', '2013-11-27', '5410', 'Salaries for Involve Staff  Nov 2013', '2501027.64', '0', '0', '0', 'Salaries', '0'),
('1558', '1', '456', '2013-11-27', '5690', 'Bank Charges', '500', '0', '0', '0', 'Salaries', '0'),
('1559', '1', '456', '2013-11-27', '1060', '', '-2501527.64', '0', '0', '0', 'Salaries', '0'),
('1560', '2', '91', '2013-11-01', '1221', 'Fund transfer', '-200000', '0', '0', '0', 'Fund transfer', '0'),
('1561', '2', '91', '2013-11-01', '1060', '', '200000', '0', '0', '0', 'Fund transfer', '0'),
('1562', '2', '92', '2013-11-27', '1221', 'Fund transfer', '-3200000', '0', '0', '0', 'Fund transfer', '0'),
('1563', '2', '92', '2013-11-27', '1060', '', '3200000', '0', '0', '0', 'Fund transfer', '0'),
('1564', '2', '93', '2013-12-10', '1221', 'Fund transfer', '-200000', '0', '0', '0', 'Fund transfer', '0'),
('1565', '2', '93', '2013-12-10', '1060', '', '200000', '0', '0', '0', 'Fund transfer', '0'),
('1566', '2', '94', '2013-12-10', '1221', 'Fund transfer', '-200000', '0', '0', '0', 'Fund transfer', '0'),
('1567', '2', '94', '2013-12-10', '1060', '', '200000', '0', '0', '0', 'Fund transfer', '0'),
('1568', '1', '457', '2013-12-11', '5690', 'Bank Charges', '50', '0', '0', '0', 'Sampath Bank', '0'),
('1569', '1', '457', '2013-12-11', '1060', '', '-50', '0', '0', '0', 'Sampath Bank', '0'),
('1570', '1', '458', '2013-12-17', '5690', 'Bank Charges', '500', '0', '0', '0', 'Bank Charges', '0'),
('1571', '1', '458', '2013-12-17', '1060', '', '-500', '0', '0', '0', 'Bank Charges', '0'),
('1572', '1', '459', '2013-12-24', '5410', 'Salaries for Involve Staff  Dec 2013', '2360685.64', '0', '0', '0', 'Salaries', '0'),
('1573', '1', '459', '2013-12-24', '5690', 'Bank Charges', '500', '0', '0', '0', 'Salaries', '0'),
('1574', '1', '459', '2013-12-24', '1060', '', '-2361185.64', '0', '0', '0', 'Salaries', '0'),
('1575', '1', '460', '2014-01-27', '5410', 'Salaries for Involve Staff  Jan 2014', '2308355.02', '0', '0', '0', 'Salaries', '0'),
('1576', '1', '460', '2014-01-27', '5690', 'Bank Charges', '500', '0', '0', '0', 'Salaries', '0'),
('1577', '1', '460', '2014-01-27', '1060', '', '-2308855.02', '0', '0', '0', 'Salaries', '0'),
('1578', '2', '95', '2013-12-23', '1221', 'Fund Transfer', '-3200000', '0', '0', '0', 'Fund transfer', '0'),
('1579', '2', '95', '2013-12-23', '1060', '', '3200000', '0', '0', '0', 'Fund transfer', '0'),
('1580', '2', '96', '2014-01-17', '1221', 'Fund transfer', '-500000', '0', '0', '0', 'Fund transfer', '0'),
('1581', '2', '96', '2014-01-17', '1060', '', '500000', '0', '0', '0', 'Fund transfer', '0'),
('1582', '2', '97', '2014-01-21', '1221', 'Fund transfer', '-500000', '0', '0', '0', 'Fund transfer', '0'),
('1583', '2', '97', '2014-01-21', '1060', '', '500000', '0', '0', '0', 'Fund transfer', '0'),
('1584', '2', '98', '2014-01-27', '1221', 'Fund transfer', '-2600000', '0', '0', '0', 'Fund transfer', '0'),
('1585', '2', '98', '2014-01-27', '1060', '', '2600000', '0', '0', '0', 'Fund transfer', '0'),
('1586', '2', '99', '2014-02-28', '1221', 'Fund transfer', '-3200000', '0', '0', '0', 'Fund transfer', '0'),
('1587', '2', '99', '2014-02-28', '1060', '', '3200000', '0', '0', '0', 'Fund transfer', '0'),
('1588', '1', '461', '2014-02-28', '5410', 'Salaries for Involve Staff  Feb 2014', '2350649.29', '0', '0', '0', 'Salaries', '0'),
('1589', '1', '461', '2014-02-28', '5690', 'Bank Charges', '500', '0', '0', '0', 'Salaries', '0'),
('1590', '1', '461', '2014-02-28', '1060', '', '-2351149.29', '0', '0', '0', 'Salaries', '0'),
('1591', '1', '462', '2014-03-19', '1221', 'Fund transfer', '0', '0', '0', '0', 'Fund transfer', '554563'),
('1592', '1', '462', '2014-03-19', '1060', '', '0', '0', '0', '0', 'Fund transfer', '554563'),
('1593', '2', '100', '2014-03-19', '1221', 'Fund transfer', '-400000', '0', '0', '0', 'Fund transfer', '0'),
('1594', '2', '100', '2014-03-19', '1060', '', '400000', '0', '0', '0', 'Fund transfer', '0'),
('1595', '2', '101', '2014-03-27', '1221', 'Fund transfer', '-2400000', '0', '0', '0', 'Fund transfer', '0'),
('1596', '2', '101', '2014-03-27', '1060', '', '2400000', '0', '0', '0', 'Fund transfer', '0'),
('1597', '1', '463', '2014-03-20', '5690', 'Bank Charges', '50', '0', '0', '0', 'Sampath Bank', '554564'),
('1598', '1', '463', '2014-03-20', '1060', '', '-50', '0', '0', '0', 'Sampath Bank', '554564'),
('1599', '2', '102', '2014-03-25', '1221', 'Fund transfer', '-400000', '0', '0', '0', 'Fund transfer', '0'),
('1600', '2', '102', '2014-03-25', '1060', '', '400000', '0', '0', '0', 'Fund transfer', '0'),
('1601', '1', '464', '2014-03-27', '5410', 'Salaries for Involve Staff  Mar 2014', '2376547.34', '0', '0', '0', 'Salaries', '0'),
('1602', '1', '464', '2014-03-27', '5690', 'Bank Charges', '500', '0', '0', '0', 'Salaries', '0'),
('1603', '1', '464', '2014-03-27', '1060', '', '-2377047.34', '0', '0', '0', 'Salaries', '0'),
('1604', '2', '103', '2014-03-14', '1210', 'Fund transfer', '-50000', '0', '0', '0', 'Fund transfer', '0'),
('1605', '2', '103', '2014-03-14', '1060', '', '50000', '0', '0', '0', 'Fund transfer', '0'),
('1606', '0', '29', '2014-03-31', '5410', 'Loan deductions - Uddeshika', '35000', '0', '0', NULL, NULL, '0'),
('1607', '0', '29', '2014-03-31', '1201', 'Loan deductions - Uddeshika', '-35000', '0', '0', NULL, NULL, '0'),
('1608', '1', '465', '2015-02-23', '5785', 'Visa &amp; Air tickets expenses', '609085', '0', '0', '0', 'Chanaka Padmaperuma', '779557'),
('1609', '1', '465', '2015-02-23', '1060', '', '-609085', '0', '0', '0', 'Chanaka Padmaperuma', '779557'),
('1610', '0', '30', '2013-04-01', '2110', 'Reverse Accrued charges march 2013', '726321', '0', '0', NULL, NULL, '0'),
('1611', '0', '30', '2013-04-01', '5450', 'The Superientendent - Employees Provident Fund for the month of March 2013', '-488523', '0', '0', NULL, NULL, '0'),
('1612', '0', '30', '2013-04-01', '5460', 'Employees Trust fund for the month of March 2013', '-73278', '0', '0', NULL, NULL, '0'),
('1613', '0', '30', '2013-04-01', '5470', 'Grand Taxi bill -march 2013', '-164520', '0', '0', NULL, NULL, '0'),
('1614', '10', '42', '2013-04-25', '4010', '', '-890418.4', '0', '0', '2', '2', '0'),
('1615', '10', '42', '2013-04-25', '1200', '', '890418.4', '0', '0', '2', '2', '0'),
('1616', '10', '43', '2013-04-25', '4010', '', '-3051934.4', '0', '0', '2', '2', '0'),
('1617', '10', '43', '2013-04-25', '1200', '', '3051934.4', '0', '0', '2', '2', '0'),
('1618', '10', '44', '2013-05-21', '4010', '', '-1371272.1', '0', '0', '2', '2', '0'),
('1619', '10', '44', '2013-05-21', '1200', '', '1371272.1', '0', '0', '2', '2', '0'),
('1620', '10', '45', '2013-05-21', '4010', '', '0', '0', '0', '2', '2', '0'),
('1621', '10', '45', '2013-05-21', '1200', '', '0', '0', '0', '2', '2', '0'),
('1622', '10', '46', '2013-06-21', '4010', '', '-3648819.15', '0', '0', '2', '2', '0'),
('1623', '10', '46', '2013-06-21', '1200', '', '3648819.15', '0', '0', '2', '2', '0'),
('1624', '10', '47', '2013-07-22', '4010', '', '-3414471.06', '0', '0', '2', '2', '0'),
('1625', '10', '47', '2013-07-22', '1200', '', '3414471.06', '0', '0', '2', '2', '0'),
('1626', '10', '48', '2013-08-21', '4010', '', '-3931746', '0', '0', '2', '2', '0'),
('1627', '10', '48', '2013-08-21', '1200', '', '3931746', '0', '0', '2', '2', '0'),
('1628', '10', '49', '2013-09-20', '4010', '', '-3811412', '0', '0', '2', '2', '0'),
('1629', '10', '49', '2013-09-20', '1200', '', '3811412', '0', '0', '2', '2', '0'),
('1630', '10', '50', '2013-10-21', '4010', '', '-3982310.28', '0', '0', '2', '2', '0'),
('1631', '10', '50', '2013-10-21', '1200', '', '3982310.28', '0', '0', '2', '2', '0'),
('1632', '10', '51', '2013-11-22', '4010', '', '-3797259.6', '0', '0', '2', '2', '0'),
('1633', '10', '51', '2013-11-22', '1200', '', '3797259.6', '0', '0', '2', '2', '0'),
('1634', '10', '52', '2013-12-23', '4010', '', '-3804826', '0', '0', '2', '2', '0'),
('1635', '10', '52', '2013-12-23', '1200', '', '3804826', '0', '0', '2', '2', '0'),
('1636', '10', '53', '2014-01-22', '4010', '', '-3613313.6', '0', '0', '2', '2', '0'),
('1637', '10', '53', '2014-01-22', '1200', '', '3613313.6', '0', '0', '2', '2', '0'),
('1638', '10', '54', '2014-02-21', '4010', '', '-3390930', '0', '0', '2', '2', '0'),
('1639', '10', '54', '2014-02-21', '1200', '', '3390930', '0', '0', '2', '2', '0'),
('1640', '12', '44', '2013-04-29', '1221', '', '4014519.3', '0', '0', '2', '2', '0'),
('1641', '12', '44', '2013-04-29', '1200', '', '-4014519.3', '0', '0', '2', '2', '0'),
('1642', '12', '44', '2014-02-21', '1200', 'Sales Invoice 42', '16299.5', '0', '0', '2', '2', '0'),
('1643', '12', '44', '2014-02-21', '4450', 'Sales Invoice 42', '-16299.5', '0', '0', '2', '2', '0'),
('1644', '12', '44', '2014-02-21', '1200', 'Sales Invoice 43', '55867', '0', '0', '2', '2', '0'),
('1645', '12', '44', '2014-02-21', '4450', 'Sales Invoice 43', '-55867', '0', '0', '2', '2', '0'),
('1646', '12', '45', '2013-05-27', '1221', '', '0', '0', '0', '2', '2', '0'),
('1647', '12', '45', '2013-05-27', '1200', '', '0', '0', '0', '2', '2', '0'),
('1648', '12', '46', '2013-06-26', '1221', '', '3648819.15', '0', '0', '2', '2', '0'),
('1649', '12', '46', '2013-06-26', '1200', '', '-3648819.15', '0', '0', '2', '2', '0'),
('1650', '12', '47', '2013-07-30', '1221', '', '3414471.06', '0', '0', '2', '2', '0'),
('1651', '12', '47', '2013-07-30', '1200', '', '-3414471.06', '0', '0', '2', '2', '0'),
('1652', '12', '48', '2013-08-29', '1221', '', '3931746', '0', '0', '2', '2', '0'),
('1653', '12', '48', '2013-08-29', '1200', '', '-3931746', '0', '0', '2', '2', '0'),
('1654', '12', '49', '2013-09-30', '1221', '', '3913358.02', '0', '0', '2', '2', '0'),
('1655', '12', '49', '2013-09-30', '1200', '', '-3913358.02', '0', '0', '2', '2', '0'),
('1656', '10', '49', '2013-09-20', '1200', 'Customer Payment 49', '101946.02', '0', '0', '2', '2', '0'),
('1657', '10', '49', '2013-09-20', '4450', 'Customer Payment 49', '-101946.02', '0', '0', '2', '2', '0'),
('1658', '12', '50', '2013-10-30', '1221', '', '3942583.2', '0', '0', '2', '2', '0'),
('1659', '12', '50', '2013-10-30', '1200', '', '-3942583.2', '0', '0', '2', '2', '0'),
('1660', '10', '50', '2013-10-21', '1200', 'Customer Payment 50', '-39727.08', '0', '0', '2', '2', '0'),
('1661', '10', '50', '2013-10-21', '4450', 'Customer Payment 50', '39727.08', '0', '0', '2', '2', '0'),
('1662', '12', '51', '2013-11-28', '1221', '', '3841687.9', '0', '0', '2', '2', '0'),
('1663', '12', '51', '2013-11-28', '1200', '', '-3841687.9', '0', '0', '2', '2', '0'),
('1664', '10', '51', '2013-11-22', '1200', 'Customer Payment 51', '44428.3', '0', '0', '2', '2', '0'),
('1665', '10', '51', '2013-11-22', '4450', 'Customer Payment 51', '-44428.3', '0', '0', '2', '2', '0'),
('1666', '12', '52', '2013-12-30', '1221', '', '3804826', '0', '0', '2', '2', '0'),
('1667', '12', '52', '2013-12-30', '1200', '', '-3804826', '0', '0', '2', '2', '0'),
('1668', '12', '53', '2013-12-30', '1221', '', '3613313.6', '0', '0', '2', '2', '0'),
('1669', '12', '53', '2013-12-30', '1200', '', '-3613313.6', '0', '0', '2', '2', '0'),
('1670', '12', '54', '2014-02-28', '1221', '', '3454386', '0', '0', '2', '2', '0'),
('1671', '12', '54', '2014-02-28', '1200', '', '-3454386', '0', '0', '2', '2', '0'),
('1672', '10', '54', '2014-02-21', '1200', 'Customer Payment 54', '63456', '0', '0', '2', '2', '0'),
('1673', '10', '54', '2014-02-21', '4450', 'Customer Payment 54', '-63456', '0', '0', '2', '2', '0'),
('1674', '10', '55', '2014-03-21', '4010', '', '-4325832', '0', '0', '2', '2', '0'),
('1675', '10', '55', '2014-03-21', '1200', '', '4325832', '0', '0', '2', '2', '0'),
('1676', '1', '466', '2013-04-04', '5470', 'Settlement of invoices No.0018 to 0023', '0', '0', '0', '0', 'Grand Taxi Company', '554565'),
('1677', '1', '466', '2013-04-04', '1221', '', '0', '0', '0', '0', 'Grand Taxi Company', '554565'),
('1678', '0', '31', '2013-04-04', '1221', 'Exchange Variance', '0', '0', '0', '0', 'Grand Taxi Company', '554565'),
('1679', '0', '31', '2013-04-04', '4450', 'Exchange Variance', '0', '0', '0', '0', 'Grand Taxi Company', '554565'),
('1680', '0', '32', '2013-03-30', '5760', 'Rent - Proportionately', '0', '0', '0', NULL, NULL, '0'),
('1681', '0', '32', '2013-03-30', '5660', 'Printing &amp; stationery paid by Evolve', '0', '0', '0', NULL, NULL, '0'),
('1682', '0', '32', '2013-03-30', '5780', 'Internet charges paid by Evolve', '0', '0', '0', NULL, NULL, '0'),
('1683', '0', '32', '2013-03-30', '1221', 'Expenses incurred by Evolve', '0', '0', '0', NULL, NULL, '0'),
('1684', '0', '32', '2013-03-30', '5760', 'Rent - Proportionately', '0', '0', '0', NULL, NULL, '0'),
('1685', '0', '32', '2013-03-30', '5660', 'Printing &amp; stationery paid by Evolve', '0', '0', '0', NULL, NULL, '0'),
('1686', '0', '32', '2013-03-30', '5780', 'Internet charges paid by Evolve42857.15X6,189795/95X6', '0', '0', '0', NULL, NULL, '0'),
('1687', '0', '32', '2013-03-30', '1221', 'Expenses incurred by Evolve', '0', '0', '0', NULL, NULL, '0'),
('1688', '1', '467', '2013-04-04', '5470', 'Settlement of invoices No.0018 to 0023', '261671', '0', '0', '0', 'Grand Taxi Company', '554566'),
('1689', '1', '467', '2013-04-04', '1221', '', '-261671', '0', '0', '0', 'Grand Taxi Company', '554566'),
('1690', '0', '33', '2013-04-04', '1221', 'Exchange Variance', '0', '0', '0', '0', 'Grand Taxi Company', '554566'),
('1691', '0', '33', '2013-04-04', '4450', 'Exchange Variance', '0', '0', '0', '0', 'Grand Taxi Company', '554566'),
('1692', '10', '56', '2013-02-20', '4010', '', '-2022240', '0', '0', '2', '2', '0'),
('1693', '10', '56', '2013-02-20', '1200', '', '2022240', '0', '0', '2', '2', '0'),
('1694', '12', '55', '2013-02-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('1695', '12', '55', '2013-02-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('1696', '12', '56', '2014-03-30', '1221', '', '4324229.84', '0', '0', '2', '2', '0'),
('1697', '12', '56', '2014-03-30', '1200', '', '-4324229.84', '0', '0', '2', '2', '0'),
('1698', '10', '55', '2014-03-21', '1200', 'Customer Payment 56', '-1602.16', '0', '0', '2', '2', '0'),
('1699', '10', '55', '2014-03-21', '4450', 'Customer Payment 56', '1602.16', '0', '0', '2', '2', '0'),
('1700', '1', '468', '2012-08-22', '5795', 'Secretarial fees for 2012', '0', '0', '0', '0', 'Pope &amp; Co;', '554567'),
('1701', '1', '468', '2012-08-22', '1220', '', '0', '0', '0', '0', 'Pope &amp; Co;', '554567'),
('1702', '1', '469', '2013-04-23', '5780', 'Telephone And internet expenses for the month of Apr 2013', '0', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1703', '1', '469', '2013-04-23', '1221', '', '0', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1704', '0', '34', '2013-04-23', '1221', 'Exchange Variance', '0', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1705', '0', '34', '2013-04-23', '4450', 'Exchange Variance', '0', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1706', '1', '470', '2013-04-23', '5780', 'Telephone And internet expenses for the month of Apr 2013', '189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1707', '1', '470', '2013-04-23', '1220', '', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1708', '1', '471', '2013-05-22', '5780', 'Telephone And internet expenses for the month of May 2013', '189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1709', '1', '471', '2013-05-22', '1220', '', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1710', '1', '472', '2013-06-21', '5780', 'Telephone And internet expenses for the month of Jun 2013', '189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1711', '1', '472', '2013-06-21', '1220', '', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1712', '1', '473', '2013-07-19', '5780', 'Telephone And internet expenses for the month of July 2013', '189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1713', '1', '473', '2013-07-19', '1220', '', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1714', '1', '474', '2013-08-06', '5780', 'Telephone And internet expenses for the month of Aug 2013', '189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1715', '1', '474', '2013-08-06', '1220', '', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1716', '1', '475', '2013-08-22', '5780', 'Telephone And internet expenses for the month of Sep 2013', '189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1717', '1', '475', '2013-08-22', '1220', '', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1718', '1', '476', '2013-10-05', '5780', 'Telephone And internet expenses for the month of Oct 2013', '189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1719', '1', '476', '2013-10-05', '1220', '', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1720', '1', '477', '2013-10-24', '5780', 'Telephone And internet expenses for the month of Nov 2013', '167139.71', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1721', '1', '477', '2013-10-24', '1220', '', '-167139.71', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1722', '1', '478', '2013-12-18', '5780', 'Telephone And internet expenses for the month of dec 2013', '189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1723', '1', '478', '2013-12-18', '1220', '', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1724', '1', '479', '2014-01-17', '5780', 'Telephone And internet expenses for the month of Jan 2014', '189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1725', '1', '479', '2014-01-17', '1220', '', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1726', '1', '480', '2014-02-21', '5780', 'Telephone And internet expenses for the month of Feb 2014', '189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1727', '1', '480', '2014-02-21', '1220', '', '-189795.95', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1728', '1', '481', '2014-03-20', '5780', 'Telephone And internet expenses for the month of Mar 2014', '197704.05', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1729', '1', '481', '2014-03-20', '1220', '', '-197704.05', '0', '0', '0', 'Dialog Broadband Network (PVT) Ltd', '0'),
('1730', '0', '32', '2013-03-30', '5760', 'Rent - Proportionately', '570000', '0', '0', NULL, NULL, '0'),
('1731', '0', '32', '2013-03-30', '5660', 'Printing &amp; stationery paid by Evolve', '60800', '0', '0', NULL, NULL, '0'),
('1732', '0', '32', '2013-03-30', '5780', 'Internet charges paid by Evolve42857.15X6,189795/95X6', '1395918.6', '0', '0', NULL, NULL, '0'),
('1733', '0', '32', '2013-03-30', '1221', 'Expenses incurred by Evolve', '-2126006.6', '0', '0', NULL, NULL, '0'),
('1734', '0', '32', '2013-03-30', '5765', 'Design Imprints - Interior work', '99288', '0', '0', NULL, NULL, '0'),
('1735', '0', '35', '2012-08-22', '5795', 'Pope &amp; Co; - Secretarial fees', '19180', '0', '0', NULL, NULL, '0'),
('1736', '0', '35', '2012-08-22', '1220', 'Pope &amp; Co; - Secretarial fees', '-19180', '0', '0', NULL, NULL, '0'),
('1737', '12', '55', '2013-02-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('1738', '12', '55', '2013-02-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('1739', '12', '55', '2013-02-28', '1200', 'Sales Invoice 56', '0', '0', '0', '2', '2', '0'),
('1740', '12', '55', '2013-02-28', '4450', 'Sales Invoice 56', '0', '0', '0', '2', '2', '0'),
('1741', '12', '55', '2013-02-28', '1221', '', '2170080', '0', '0', '2', '2', '0'),
('1742', '12', '55', '2013-02-28', '1200', '', '-2170080', '0', '0', '2', '2', '0'),
('1743', '12', '55', '2013-02-28', '1200', 'Sales Invoice 56', '147840', '0', '0', '2', '2', '0'),
('1744', '12', '55', '2013-02-28', '4450', 'Sales Invoice 56', '-147840', '0', '0', '2', '2', '0'),
('1745', '0', '36', '2013-03-31', '4450', 'Exchange gain transfer', '147840', '0', '0', NULL, NULL, '0'),
('1746', '0', '36', '2013-03-31', '4010', 'Exchange gain transfer', '-147840', '0', '0', NULL, NULL, '0'),
('1747', '1', '482', '2013-04-09', '5780', 'Reimbursement of Telephoe expenses ', '13000', '0', '0', '0', 'Cash', '554568'),
('1748', '1', '482', '2013-04-09', '1060', '', '-13000', '0', '0', '0', 'Cash', '554568'),
('1749', '1', '483', '2013-10-08', '5510', 'Cash for Staff Welfare', '100000', '0', '0', '0', 'Cash', '554569'),
('1750', '1', '483', '2013-10-08', '1060', '', '-100000', '0', '0', '0', 'Cash', '554569'),
('1751', '1', '484', '2013-11-06', '5510', 'Petty cash reimbusements for October', '100000', '0', '0', '0', 'Cash', '554570'),
('1752', '1', '484', '2013-11-06', '1060', '', '-100000', '0', '0', '0', 'Cash', '554570'),
('1753', '1', '485', '2013-09-06', '5510', 'Staff Refreshment expenses  Sep 2013', '60000', '0', '0', '0', 'Cash', '0'),
('1754', '1', '485', '2013-09-06', '1220', '', '-60000', '0', '0', '0', 'Cash', '0'),
('1755', '1', '486', '2013-11-14', '5470', 'Staff Transport', '129557', '0', '0', '0', 'Grand Taxi', '0'),
('1756', '1', '486', '2013-11-14', '1220', '', '-129557', '0', '0', '0', 'Grand Taxi', '0'),
('1757', '1', '487', '2013-04-17', '5470', 'Advance Payment', '100000', '0', '0', '0', 'Grand Taxi', '0'),
('1758', '1', '487', '2013-04-17', '1220', '', '-100000', '0', '0', '0', 'Grand Taxi', '0'),
('1759', '1', '488', '2013-09-06', '5780', 'Telephone And internet expenses', '13000', '0', '0', '0', 'Cash', '0'),
('1760', '1', '488', '2013-09-06', '1220', '', '-13000', '0', '0', '0', 'Cash', '0'),
('1761', '1', '489', '2015-02-26', '5440', 'Staff Medical expenses (Uddeshika Jayawardhane)', '2490', '0', '0', '0', 'Cash', '779558'),
('1762', '1', '489', '2015-02-26', '1060', '', '-2490', '0', '0', '0', 'Cash', '779558'),
('1763', '1', '490', '2015-02-27', '5450', 'The Superintendent, Employees Provident Fund for the month of feb 2015', '553066.6', '0', '0', '4', '4', '779559'),
('1764', '1', '490', '2015-02-27', '1060', '', '-553066.6', '0', '0', '4', '4', '779559'),
('1765', '1', '491', '2015-02-27', '5460', 'Employees Trust Fund for the month of feb 2015', '82960', '0', '0', '4', '5', '779560'),
('1766', '1', '491', '2015-02-27', '1060', '', '-82960', '0', '0', '4', '5', '779560'),
('1767', '1', '492', '2015-03-02', '5470', 'Staff Transport expenses', '449549.85', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '779561'),
('1768', '1', '492', '2015-03-02', '1060', '', '-449549.85', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '779561'),
('1769', '1', '493', '2013-08-22', '5695', 'Black hat link removal project - 30% payt.', '66000', '0', '0', '0', 'IAS Solutions (Pvt)Ltd.', '554571'),
('1770', '1', '493', '2013-08-22', '1060', '', '-66000', '0', '0', '0', 'IAS Solutions (Pvt)Ltd.', '554571'),
('1771', '0', '37', '2014-03-31', '5450', 'EPF -  March 2014', '0', '0', '0', NULL, NULL, '0'),
('1772', '0', '37', '2014-03-31', '5460', 'ETF -  March 2014', '0', '0', '0', NULL, NULL, '0'),
('1773', '0', '37', '2014-03-31', '5470', 'Grand Taxi -  March 2014', '0', '0', '0', NULL, NULL, '0'),
('1774', '0', '37', '2014-03-31', '2110', 'Accrued charges -  March 2014', '0', '0', '0', NULL, NULL, '0'),
('1775', '0', '38', '2014-03-31', '5430', 'Tea bills paid to Dilshee Enterprises', '0', '0', '0', NULL, NULL, '0'),
('1776', '0', '38', '2014-03-31', '1220', 'Tea bills paid to Dilshee Enterprises', '0', '0', '0', NULL, NULL, '0'),
('1777', '0', '39', '2014-03-31', '1220', 'Being transfer', '0', '0', '0', NULL, NULL, '0'),
('1778', '0', '39', '2014-03-31', '1221', 'Being transfer', '0', '0', '0', NULL, NULL, '0'),
('1779', '10', '57', '2013-05-21', '4010', '', '0', '0', '0', '2', '1', '0'),
('1780', '10', '57', '2013-05-21', '1200', '', '0', '0', '0', '2', '1', '0'),
('1781', '10', '58', '2013-05-21', '4010', '', '0', '0', '0', '2', '2', '0'),
('1782', '10', '58', '2013-05-21', '1200', '', '0', '0', '0', '2', '2', '0'),
('1783', '12', '45', '2013-05-27', '1221', '', '0', '0', '0', '2', '2', '0'),
('1784', '12', '45', '2013-05-27', '1200', '', '0', '0', '0', '2', '2', '0'),
('1785', '0', '40', '2013-03-31', '5440', 'Staff Medical Insurance cover for 2013', '128000', '0', '0', NULL, NULL, '0'),
('1786', '0', '40', '2013-03-31', '1220', 'Staff Medical Insurance cover for 2013', '-128000', '0', '0', NULL, NULL, '0'),
('1787', '0', '41', '2013-03-31', '3590', 'Closing Year', '-131717.91', '0', '0', NULL, NULL, '0'),
('1788', '0', '41', '2013-03-31', '9990', 'Closing Year', '131717.91', '0', '0', NULL, NULL, '0'),
('1789', '0', '39', '2014-03-31', '1220', 'Being transfer', '0', '0', '0', NULL, NULL, '0'),
('1790', '0', '39', '2014-03-31', '1221', 'Being transfer', '0', '0', '0', NULL, NULL, '0'),
('1791', '0', '38', '2014-03-31', '5430', 'Tea bills paid to Dilshee Enterprises', '105000', '0', '0', NULL, NULL, '0'),
('1792', '0', '38', '2014-03-31', '5760', 'Rent apportionment to Involve 360', '1140000', '0', '0', NULL, NULL, '0'),
('1793', '0', '38', '2014-03-31', '1220', 'Rent apportionment to Involve 360', '-1245000', '0', '0', NULL, NULL, '0'),
('1794', '0', '39', '2014-03-31', '1220', 'Being transfer', '3938360.26', '0', '0', NULL, NULL, '0'),
('1795', '0', '39', '2014-03-31', '1221', 'Being transfer', '-3938360.26', '0', '0', NULL, NULL, '0'),
('1796', '0', '42', '2014-03-31', '5410', 'PAYE payable for the year 2014.', '408735', '0', '0', NULL, NULL, '0'),
('1797', '0', '42', '2014-03-31', '2160', 'PAYE payable for the year 2014.', '-408735', '0', '0', NULL, NULL, '0'),
('1798', '10', '59', '2013-05-21', '4010', '', '-2132159.7', '0', '0', '2', '2', '0'),
('1799', '10', '59', '2013-05-21', '1200', '', '2132159.7', '0', '0', '2', '2', '0'),
('1800', '12', '45', '2013-05-27', '1221', '', '3503431.8', '0', '0', '2', '2', '0'),
('1801', '12', '45', '2013-05-27', '1200', '', '-3503431.8', '0', '0', '2', '2', '0'),
('1802', '0', '37', '2014-03-31', '5450', 'EPF -  March 2014', '452545', '0', '0', NULL, NULL, '0'),
('1803', '0', '37', '2014-03-31', '5460', 'ETF -  March 2014', '67881.75', '0', '0', NULL, NULL, '0'),
('1804', '0', '37', '2014-03-31', '5470', 'Grand Taxi -  March 2014', '164520', '0', '0', NULL, NULL, '0'),
('1805', '0', '37', '2014-03-31', '2110', 'Accrued charges -  March 2014', '-684946.75', '0', '0', NULL, NULL, '0'),
('1806', '1', '494', '2015-03-11', '5410', 'Salaries Advance for Uddeshika Jayawardhane', '10000', '0', '0', '0', 'Uddeshika Jayawardhane', '779562'),
('1807', '1', '494', '2015-03-11', '1060', '', '-10000', '0', '0', '0', 'Uddeshika Jayawardhane', '779562'),
('1808', '1', '495', '2015-03-30', '2110', 'Audit Fees for the yeay 2012-2013', '25000', '0', '0', '0', 'POPE &amp; COMPANY CONSULTANTS (PVT) LTD', '779563'),
('1809', '1', '495', '2015-03-30', '1060', '', '-25000', '0', '0', '0', 'POPE &amp; COMPANY CONSULTANTS (PVT) LTD', '779563'),
('1810', '1', '496', '2015-03-30', '5460', 'Employees Trust Fund for the month of feb 2015', '85200', '0', '0', '4', '5', '779564'),
('1811', '1', '496', '2015-03-30', '1060', '', '-85200', '0', '0', '4', '5', '779564'),
('1812', '1', '497', '2015-03-30', '5450', 'The Superintendent, Employees Provident Fund for the month of feb 2015', '568000', '0', '0', '4', '4', '779565'),
('1813', '1', '497', '2015-03-30', '1060', '', '-568000', '0', '0', '4', '4', '779565'),
('1814', '1', '498', '2015-03-30', '5470', 'Staff Transport expenses', '451176.85', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '779566'),
('1815', '1', '498', '2015-03-30', '1060', '', '-451176.85', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '779566'),
('1816', '1', '499', '2015-04-01', '5510', 'Staff Refreshment expenses Feb 2015', '140000', '0', '0', '0', 'Cash', '779567'),
('1817', '1', '499', '2015-04-01', '1060', '', '-140000', '0', '0', '0', 'Cash', '779567'),
('1818', '1', '500', '2015-04-10', '5440', 'Staff Medical expenses', '4810', '0', '0', '0', 'Prasanna Vivek', '779568'),
('1819', '1', '500', '2015-04-10', '1060', '', '-4810', '0', '0', '0', 'Prasanna Vivek', '779568'),
('1820', '1', '501', '2015-04-10', '5440', 'Staff Medical expenses', '3734', '0', '0', '0', 'Uddeshika Jayawardhane', '779569'),
('1821', '1', '501', '2015-04-10', '1060', '', '-3734', '0', '0', '0', 'Uddeshika Jayawardhane', '779569'),
('1822', '1', '502', '2015-04-10', '5521', 'Staff Loan For Uddeshika Jayawardane (8 month Installment)', '80000', '0', '0', '0', 'Uddeshika Jayawardhane', '779570'),
('1823', '1', '502', '2015-04-10', '1060', '', '-80000', '0', '0', '0', 'Uddeshika Jayawardhane', '779570'),
('1824', '1', '503', '2015-04-29', '5785', 'Car parking fees', '26720', '0', '0', '0', 'Cash', '779571'),
('1825', '1', '503', '2015-04-29', '1060', '', '-26720', '0', '0', '0', 'Cash', '779571'),
('1826', '1', '504', '2015-04-29', '5460', 'Employees Trust fund for the month of April 2015', '0', '0', '0', '4', '5', '779572'),
('1827', '1', '504', '2015-04-29', '1060', '', '0', '0', '0', '4', '5', '779572'),
('1828', '1', '505', '2015-04-29', '5450', 'The Superintendent, Employees Provident Fund for the month of April 2015', '0', '0', '0', '4', '4', '779573'),
('1829', '1', '505', '2015-04-29', '1060', '', '0', '0', '0', '4', '4', '779573'),
('1830', '1', '506', '2015-04-29', '5510', 'Staff Refreshment expenses April 2015', '140000', '0', '0', '0', 'Cash', '779574'),
('1831', '1', '506', '2015-04-29', '1060', '', '-140000', '0', '0', '0', 'Cash', '779574'),
('1832', '1', '507', '2015-05-05', '5510', 'Staff Quarterly event expenses', '60000', '0', '0', '0', 'Cash', '779575'),
('1833', '1', '507', '2015-05-05', '1060', '', '-60000', '0', '0', '0', 'Cash', '779575'),
('1834', '1', '508', '2015-05-13', '5470', 'Staff Transport expenses', '518957', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '779576'),
('1835', '1', '508', '2015-05-13', '1060', '', '-518957', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '779576'),
('1836', '1', '509', '2015-05-21', '5510', 'Staff Refreshment expenses May 2015', '140000', '0', '0', '0', 'Cash', '779577'),
('1837', '1', '509', '2015-05-21', '1060', '', '-140000', '0', '0', '0', 'Cash', '779577'),
('1838', '1', '510', '2015-05-21', '5440', 'Staff Medical expenses', '3313', '0', '0', '0', 'Amila Palihawadana', '779578'),
('1839', '1', '510', '2015-05-21', '1060', '', '-3313', '0', '0', '0', 'Amila Palihawadana', '779578'),
('1840', '1', '511', '2015-06-01', '5450', 'The Superintendent, Employees Provident Fund for the month of May 2015', '0', '0', '0', '4', '4', '779579'),
('1841', '1', '511', '2015-06-01', '1060', '', '0', '0', '0', '4', '4', '779579'),
('1842', '1', '512', '2015-06-01', '5460', 'Employees Trust fund for the month of Mayl 2015', '0', '0', '0', '4', '5', '779580'),
('1843', '1', '512', '2015-06-01', '1060', '', '0', '0', '0', '4', '5', '779580'),
('1844', '1', '513', '2015-06-10', '5780', 'Payment For Mark&#039;s Broadband Connection ', '61931.75', '0', '0', '0', 'Chanaka Padmaperuma', '779581'),
('1845', '1', '513', '2015-06-10', '1060', 'Payment For Mark&#039;s Broadband Connect In to the last Month Additional Payment.', '-61931.75', '0', '0', '0', 'Chanaka Padmaperuma', '779581'),
('1846', '1', '514', '2015-06-10', '5811', 'Overseas Travel Expenses', '0', '0', '0', '0', 'Chanaka Padmaperuma', '779582'),
('1847', '1', '514', '2015-06-10', '1060', '', '0', '0', '0', '0', 'Chanaka Padmaperuma', '779582'),
('1848', '1', '515', '2015-06-15', '5470', 'Staff Transport expenses', '501039.5', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '779583'),
('1849', '1', '515', '2015-06-15', '1060', '', '-501039.5', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '779583'),
('1850', '1', '516', '2015-06-18', '5510', 'Staff Refreshment expenses May 2015', '140000', '0', '0', '0', 'Cash', '779584'),
('1851', '1', '516', '2015-06-18', '1060', '', '-140000', '0', '0', '0', 'Cash', '779584'),
('1852', '1', '517', '2015-06-18', '5440', 'Staff Medical expenses', '2380', '0', '0', '0', 'Sahan Senevirathna', '779585'),
('1853', '1', '517', '2015-06-18', '1060', '', '-2380', '0', '0', '0', 'Sahan Senevirathna', '779585'),
('1854', '1', '518', '2015-06-18', '5440', 'Staff Medical expenses', '2460', '0', '0', '0', 'Uddeshika Jayawardhane', '779586'),
('1855', '1', '518', '2015-06-18', '1060', '', '-2460', '0', '0', '0', 'Uddeshika Jayawardhane', '779586'),
('1856', '1', '519', '2015-06-30', '5450', 'The Superintendent, Employees Provident Fund for the month of june 2015', '0', '0', '0', '4', '4', '779587'),
('1857', '1', '519', '2015-06-30', '1060', '', '0', '0', '0', '4', '4', '779587'),
('1858', '1', '520', '2015-06-30', '5460', 'Employees Trust Fund for the month of june 2015', '0', '0', '0', '4', 'Employees Trust Fund', '779588'),
('1859', '1', '520', '2015-06-30', '1060', '', '0', '0', '0', '4', 'Employees Trust Fund', '779588'),
('1860', '1', '521', '2015-07-02', '5410', 'Salries For 15 Days', '18400', '0', '0', '0', 'Lahiru Sampath', '779589'),
('1861', '1', '521', '2015-07-02', '1060', '', '-18400', '0', '0', '0', 'Lahiru Sampath', '779589'),
('1862', '1', '522', '2015-07-09', '5440', 'Staff Medical expenses', '5500', '0', '0', '0', 'Abdul Aziz bin navaz', '779590'),
('1863', '1', '522', '2015-07-09', '1060', '', '-5500', '0', '0', '0', 'Abdul Aziz bin navaz', '779590'),
('1864', '1', '523', '2015-07-09', '5440', 'Staff Medical expenses', '10000', '0', '0', '0', 'Shaaron Nadarajah', '779591'),
('1865', '1', '523', '2015-07-09', '1060', '', '-10000', '0', '0', '0', 'Shaaron Nadarajah', '779591'),
('1866', '1', '524', '2015-07-10', '5511', 'Staff Training expenses (microsoft Exam fee)', '72800', '0', '0', '0', 'Chanaka Padmaperuma', '779592'),
('1867', '1', '524', '2015-07-10', '1060', '', '-72800', '0', '0', '0', 'Chanaka Padmaperuma', '779592'),
('1868', '1', '525', '2015-07-10', '5470', 'Staff Transport expenses', '554071.35', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '779593'),
('1869', '1', '525', '2015-07-10', '1060', '', '-554071.35', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '779593'),
('1870', '1', '526', '2015-07-27', '5510', 'Staff Refreshment expenses for the month of June2015', '140000', '0', '0', '0', 'Cash', '779594'),
('1871', '1', '526', '2015-07-27', '1060', '', '-140000', '0', '0', '0', 'Cash', '779594'),
('1872', '1', '527', '2015-07-29', '5510', 'Staff Annual Trip expenses', '350000', '0', '0', '0', 'Chanaka Padmaperuma', '779595'),
('1873', '1', '527', '2015-07-29', '1060', '', '-350000', '0', '0', '0', 'Chanaka Padmaperuma', '779595'),
('1874', '1', '528', '2015-07-29', '5450', 'The Superintendent, Employees Provident Fundfor the month of july 2015', '0', '0', '0', '4', '4', '779596'),
('1875', '1', '528', '2015-07-29', '1060', '', '0', '0', '0', '4', '4', '779596'),
('1876', '1', '529', '2015-07-29', '5460', 'Employees Trust Fund for the month of july 2015', '0', '0', '0', '4', '5', '779597'),
('1877', '1', '529', '2015-07-29', '1060', '', '0', '0', '0', '4', '5', '779597'),
('1878', '1', '530', '2015-08-12', '5780', 'Payment For Mark&#039;s Broadband Connection Additional Payment June &amp; July', '25000', '0', '0', '0', 'Chanaka Padmaperuma', '779598'),
('1879', '1', '530', '2015-08-12', '5510', 'Special Rewards For the Aditional Payment Month Of July', '50000', '0', '0', '0', 'Chanaka Padmaperuma', '779598'),
('1880', '1', '530', '2015-08-12', '1060', '', '-75000', '0', '0', '0', 'Chanaka Padmaperuma', '779598'),
('1881', '1', '531', '2015-08-12', '5440', 'Staff Medical expenses', '2839', '0', '0', '0', 'Prasanna Vivek', '779599'),
('1882', '1', '531', '2015-08-12', '1060', '', '-2839', '0', '0', '0', 'Prasanna Vivek', '779599'),
('1883', '1', '532', '2015-08-19', '5470', 'Staff Transport Expenses ', '0', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '554572'),
('1884', '1', '532', '2015-08-19', '1060', '', '0', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '554572'),
('1885', '1', '533', '2015-08-19', '5470', 'Staff Transport Expenses ', '525289.2', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '779600'),
('1886', '1', '533', '2015-08-19', '1060', '', '-525289.2', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '779600'),
('1887', '1', '534', '2015-08-24', '5440', 'Staff Medical expenses', '1375', '0', '0', '0', 'Mewan Samarasinghe', '816701'),
('1888', '1', '534', '2015-08-24', '1060', '', '-1375', '0', '0', '0', 'Mewan Samarasinghe', '816701'),
('1889', '1', '535', '2015-08-31', '5450', 'The Superintendent, Employees Provident Fund for the month of Aug 2015', '0', '0', '0', '4', '4', '816702'),
('1890', '1', '535', '2015-08-31', '1060', '', '0', '0', '0', '4', '4', '816702'),
('1891', '1', '536', '2015-08-31', '5460', 'Employees Trust Fund for the month of Aug 2015', '0', '0', '0', '4', '5', '816703'),
('1892', '1', '536', '2015-08-31', '1060', '', '0', '0', '0', '4', '5', '816703'),
('1893', '1', '537', '2015-08-31', '5440', 'Staff Medical expenses', '10000', '0', '0', '0', 'Shanaka Silva', '816704'),
('1894', '1', '537', '2015-08-31', '1060', '', '-10000', '0', '0', '0', 'Shanaka Silva', '816704'),
('1895', '1', '538', '2015-08-31', '5440', 'Staff Medical expenses', '9590', '0', '0', '0', 'Asantha Rathnasekara', '816705'),
('1896', '1', '538', '2015-08-31', '1060', '', '-9590', '0', '0', '0', 'Asantha Rathnasekara', '816705'),
('1897', '1', '539', '2015-09-02', '5510', 'Staff Welfare Expenses', '0', '0', '0', '0', 'Cash', '816706'),
('1898', '1', '539', '2015-09-02', '1060', '', '0', '0', '0', '0', 'Cash', '816706'),
('1899', '1', '540', '2015-09-02', '5510', 'Staff Welfare Expenses', '0', '0', '0', '0', 'Cash', '816706'),
('1900', '1', '540', '2015-09-02', '1060', '', '0', '0', '0', '0', 'Cash', '816706'),
('1901', '1', '541', '2015-09-02', '5510', 'Staff Refreshment expenses For the Month Of August 2015', '140000', '0', '0', '0', 'Cash', '816706'),
('1902', '1', '541', '2015-09-02', '1060', '', '-140000', '0', '0', '0', 'Cash', '816706'),
('1903', '1', '542', '2015-09-09', '5410', 'Salary= 90,000 less EPF=7200 &amp; PAYE=1100 Balance=81700', '81700', '0', '0', '0', 'Tiron Aravinda ', '816707'),
('1904', '1', '542', '2015-09-09', '1060', '', '-81700', '0', '0', '0', 'Tiron Aravinda ', '816707'),
('1905', '1', '543', '2015-09-09', '5410', '8 days salary   ', '34666', '0', '0', '0', 'Dammika Suranga', '816708'),
('1906', '1', '543', '2015-09-09', '1060', '', '-34666', '0', '0', '0', 'Dammika Suranga', '816708'),
('1907', '1', '544', '2015-09-09', '1820', 'Purchase Lap Top Computers', '87250', '0', '0', '0', 'Computer Solutions &amp; Network Private LTD', '816709'),
('1908', '1', '544', '2015-09-09', '1060', '', '-87250', '0', '0', '0', 'Computer Solutions &amp; Network Private LTD', '816709'),
('1909', '1', '545', '2015-09-11', '5440', 'Staff Medical expenses', '6687', '0', '0', '0', 'Amila Palihawadana', '816710'),
('1910', '1', '545', '2015-09-11', '1060', '', '-6687', '0', '0', '0', 'Amila Palihawadana', '816710'),
('1911', '1', '546', '2015-09-22', '5470', 'Staff Transport  Expenses ', '553097', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '816711'),
('1912', '1', '546', '2015-09-22', '1060', '', '-553097', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '816711'),
('1913', '1', '547', '2015-09-22', '5510', 'Staff Refreshment expenses For the Month Of September 2015', '140000', '0', '0', '0', 'Cash', '816712'),
('1914', '1', '547', '2015-09-22', '1060', '', '-140000', '0', '0', '0', 'Cash', '816712'),
('1915', '1', '548', '2015-09-23', '5440', 'Staff Medical expenses', '6244', '0', '0', '0', 'Jude Premal Padidilian', '816713'),
('1916', '1', '548', '2015-09-23', '1060', '', '-6244', '0', '0', '0', 'Jude Premal Padidilian', '816713'),
('1917', '1', '549', '2015-09-30', '5450', 'The Superintendent, Employees Provident Fund for the month of aug 2015', '0', '0', '0', '4', '4', '816715'),
('1918', '1', '549', '2015-09-30', '1060', '', '0', '0', '0', '4', '4', '816715'),
('1919', '1', '550', '2015-09-30', '5460', 'Employees Trust Fund for the month of aug 2015', '0', '0', '0', '4', '5', '816716'),
('1920', '1', '550', '2015-09-30', '1060', '', '0', '0', '0', '4', '5', '816716'),
('1921', '1', '551', '2014-04-16', '6010', 'Bank Casual OD Charge', '50', '0', '0', '0', 'Bank Casual OD Charge', '0'),
('1922', '1', '551', '2014-04-16', '1060', 'Bank Casual OD Charge', '-50', '0', '0', '0', 'Bank Casual OD Charge', '0'),
('1923', '1', '552', '2014-04-22', '5010', 'Bank Cheque Book Charges', '0', '0', '0', '0', 'Bank Cheque Book Charges', '0'),
('1924', '1', '552', '2014-04-22', '1060', 'Bank Cheque Book Charges', '0', '0', '0', '0', 'Bank Cheque Book Charges', '0'),
('1925', '1', '553', '2014-04-28', '5410', 'Staff Salaries', '2325310', '0', '0', '0', 'Staff Salaries', '0'),
('1926', '1', '553', '2014-04-28', '1060', 'Staff Salaries for the month of April 2013', '-2325310', '0', '0', '0', 'Staff Salaries', '0'),
('1927', '1', '554', '2014-04-28', '5790', 'Salary Commission', '500', '0', '0', '0', 'Salary Commission', '0'),
('1928', '1', '554', '2014-04-28', '1060', 'Salary Commission', '-500', '0', '0', '0', 'Salary Commission', '0'),
('1929', '2', '104', '2014-04-03', '1221', 'Fund Transfer - Evolve Technologies', '-110000', '0', '0', '0', 'Fund Transfer - Evolve Technologies', '0'),
('1930', '2', '104', '2014-04-03', '1060', '', '110000', '0', '0', '0', 'Fund Transfer - Evolve Technologies', '0'),
('1931', '2', '105', '2014-04-11', '1221', 'Fund Transfer - Evolve Technologies', '-150000', '0', '0', '0', 'Fund Transfer - Evolve Technologies', '0'),
('1932', '2', '105', '2014-04-11', '1060', '', '150000', '0', '0', '0', 'Fund Transfer - Evolve Technologies', '0'),
('1933', '2', '106', '2014-04-28', '1221', 'Fund Transfer - Evolve Technologies', '-3300000', '0', '0', '0', 'Fund Transfer - Evolve Technologies', '0'),
('1934', '2', '106', '2014-04-28', '1060', '', '3300000', '0', '0', '0', 'Fund Transfer - Evolve Technologies', '0'),
('1935', '1', '555', '2014-05-28', '5410', 'Staff Salaries', '2567932.85', '0', '0', '0', 'Staff Salaries', '0'),
('1936', '1', '555', '2014-05-28', '1060', 'Staff Salaries for the month of May 2014', '-2567932.85', '0', '0', '0', 'Staff Salaries', '0'),
('1937', '1', '556', '2014-05-28', '5415', 'Salary Commission', '500', '0', '0', '0', 'Salary Commission', '0'),
('1938', '1', '556', '2014-05-28', '1060', 'Salary Commission for the month of May', '-500', '0', '0', '0', 'Salary Commission', '0'),
('1939', '1', '557', '2014-05-31', '6010', 'OD Interest for the month of May', '329.85', '0', '0', '0', 'OD Interest for the month of May', '0'),
('1940', '1', '557', '2014-05-31', '1060', 'OD Interest for the month of May', '-329.85', '0', '0', '0', 'OD Interest for the month of May', '0'),
('1941', '2', '107', '2014-05-26', '1221', 'Evolve Technologies (Pvt) Ltd', '-500000', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '0'),
('1942', '2', '107', '2014-05-26', '1060', 'Evolve Technologies (Pvt) Ltd', '500000', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '0'),
('1943', '2', '108', '2014-05-28', '1221', 'Evolve Technologies (Pvt) Ltd', '-600000', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '0'),
('1944', '2', '108', '2014-05-28', '1060', 'Evolve Technologies (Pvt) Ltd', '600000', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '0'),
('1945', '2', '109', '2014-05-30', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('1946', '2', '109', '2014-05-30', '1060', '', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('1947', '2', '110', '2014-05-28', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-2082400', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('1948', '2', '110', '2014-05-28', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '2082400', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('1949', '1', '558', '2014-06-17', '5790', 'Other expenses', '500', '0', '0', '0', 'Other expenses', '0'),
('1950', '1', '558', '2014-06-17', '1060', 'Other expenses', '-500', '0', '0', '0', 'Other expenses', '0'),
('1951', '1', '559', '2014-06-27', '5410', 'Staff Salaries', '2952564.44', '0', '0', '0', 'Staff Salaries', '0'),
('1952', '1', '559', '2014-06-27', '1060', 'Staff Salaries for the month of June', '-2952564.44', '0', '0', '0', 'Staff Salaries', '0'),
('1953', '1', '560', '2014-06-27', '5415', 'Salary Commission', '500', '0', '0', '0', 'Salary Commission', '0'),
('1954', '1', '560', '2014-06-27', '1060', 'Salary Commission for the month of June', '-500', '0', '0', '0', 'Salary Commission', '0'),
('1955', '2', '111', '2014-06-20', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-80000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('1956', '2', '111', '2014-06-20', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '80000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('1957', '2', '112', '2014-06-27', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-3000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('1958', '2', '112', '2014-06-27', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '3000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('1959', '2', '113', '2014-06-30', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-1000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('1960', '2', '113', '2014-06-30', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '1000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('1961', '1', '561', '2014-07-01', '5790', 'Other Payments', '0', '0', '0', '0', 'Other Payments', '0');
INSERT INTO `1_gl_trans` VALUES
('1962', '1', '561', '2014-07-01', '1060', 'Other Payments', '0', '0', '0', '0', 'Other Payments', '0'),
('1963', '1', '562', '2014-07-28', '5410', 'Staff Salaries', '2694027', '0', '0', '0', 'Staff Salaries', '0'),
('1964', '1', '562', '2014-07-28', '1060', 'Staff Salaries for the month of July.', '-2694027', '0', '0', '0', 'Staff Salaries', '0'),
('1965', '1', '563', '2014-07-28', '5415', 'Salary Commission', '500', '0', '0', '0', 'Salary Commission', '0'),
('1966', '1', '563', '2014-07-28', '1060', 'Salary Commission', '-500', '0', '0', '0', 'Salary Commission', '0'),
('1967', '2', '114', '2014-07-18', '1221', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '-150000', '0', '0', '0', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '0'),
('1968', '2', '114', '2014-07-18', '4010', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '0', '0', '0', '0', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '0'),
('1969', '2', '114', '2014-07-18', '1060', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '150000', '0', '0', '0', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '0'),
('1970', '2', '115', '2014-07-28', '1221', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '-3300000', '0', '0', '0', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '0'),
('1971', '2', '115', '2014-07-28', '1060', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '3300000', '0', '0', '0', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '0'),
('1972', '2', '116', '2014-07-31', '1221', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '-456916.95', '0', '0', '0', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '0'),
('1973', '2', '116', '2014-07-31', '1060', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '456916.95', '0', '0', '0', 'Fund Transfer - Evolve Technologies (Pvt) Ltd', '0'),
('1974', '1', '564', '2014-08-27', '5410', 'Staff Salaries', '2566397.5', '0', '0', '0', 'Staff Salaries', '0'),
('1975', '1', '564', '2014-08-27', '1060', 'Staff Salaries for the month of August', '-2566397.5', '0', '0', '0', 'Staff Salaries', '0'),
('1976', '1', '565', '2014-08-27', '5415', 'Salary Commission', '500', '0', '0', '0', 'Salary Commission', '0'),
('1977', '1', '565', '2014-08-27', '1060', 'Salary Commission for the month of August', '-500', '0', '0', '0', 'Salary Commission', '0'),
('1978', '1', '566', '2014-08-28', '5690', 'Bank Cheque Book Charges', '750', '0', '0', '0', 'Bank Cheque Book Charges', '0'),
('1979', '1', '566', '2014-08-28', '1060', 'Bank Cheque Book Charges', '-750', '0', '0', '0', 'Bank Cheque Book Charges', '0'),
('1980', '1', '567', '2014-08-31', '6010', 'Bank OD Interest', '0', '0', '0', '0', 'Bank OD Interest', '0'),
('1981', '1', '567', '2014-08-31', '1220', '', '0', '0', '0', '0', 'Bank OD Interest', '0'),
('1982', '2', '117', '2014-08-08', '1221', 'Evolve Technologies (Pvt) Ltd', '-100000', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '0'),
('1983', '2', '117', '2014-08-08', '1060', '', '100000', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '0'),
('1984', '2', '118', '2014-08-12', '1221', 'Fund Transfer  Evolve Technologies (Pvt) Ltd ', '-300000', '0', '0', '0', 'Fund Transfer  Evolve Technologies (Pvt) Ltd ', '0'),
('1985', '2', '118', '2014-08-12', '1060', 'Fund Transfer  Evolve Technologies (Pvt) Ltd ', '300000', '0', '0', '0', 'Fund Transfer  Evolve Technologies (Pvt) Ltd ', '0'),
('1986', '2', '119', '2014-08-27', '1221', 'Fund Transfer  Evolve Technologies (Pvt) Ltd ', '-3500000', '0', '0', '0', 'Fund Transfer  Evolve Technologies (Pvt) Ltd ', '0'),
('1987', '2', '119', '2014-08-27', '1060', 'Fund Transfer  Evolve Technologies (Pvt) Ltd ', '3500000', '0', '0', '0', 'Fund Transfer  Evolve Technologies (Pvt) Ltd ', '0'),
('1988', '1', '568', '2014-09-01', '5790', 'Cheque Payment', '0', '0', '0', '0', 'Cheque Payment', '0'),
('1989', '1', '568', '2014-09-01', '1060', 'Cheque Payment', '0', '0', '0', '0', 'Cheque Payment', '0'),
('1990', '1', '569', '2014-09-29', '5410', 'Staff Salaries', '2587477', '0', '0', '0', 'Staff Salaries', '0'),
('1991', '1', '569', '2014-09-29', '1060', 'Staff Salaries for the month of September', '-2587477', '0', '0', '0', 'Staff Salaries', '0'),
('1992', '1', '570', '2014-09-29', '5415', 'Salary Commission', '500', '0', '0', '0', 'Salary Commission', '0'),
('1993', '1', '570', '2014-09-29', '1060', '', '-500', '0', '0', '0', 'Salary Commission', '0'),
('1994', '1', '571', '2014-09-30', '6010', 'Bank OD Charges', '250', '0', '0', '0', 'Bank OD Charges', '0'),
('1995', '1', '571', '2014-09-30', '1060', '', '-250', '0', '0', '0', 'Bank OD Charges', '0'),
('1996', '2', '120', '2014-09-04', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('1997', '2', '120', '2014-09-04', '1060', '', '200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('1998', '2', '121', '2014-09-16', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('1999', '2', '121', '2014-09-16', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2000', '2', '122', '2014-09-29', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-3200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2001', '2', '122', '2014-09-29', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '3200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2002', '1', '572', '2014-10-27', '5410', 'Staff Salary', '2848146', '0', '0', '0', 'Staff Salary', '0'),
('2003', '1', '572', '2014-10-27', '1060', 'Staff Salary for the month of October', '-2848146', '0', '0', '0', 'Staff Salary', '0'),
('2004', '1', '573', '2014-10-27', '5010', 'Salary Commission', '0', '0', '0', '0', 'Salary Commission', '0'),
('2005', '1', '573', '2014-10-27', '1060', '', '0', '0', '0', '0', 'Salary Commission', '0'),
('2006', '2', '123', '2014-10-14', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-100000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2007', '2', '123', '2014-10-14', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '100000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2008', '2', '124', '2014-10-27', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-3700000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2009', '2', '124', '2014-10-27', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '3700000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2010', '1', '574', '2014-11-27', '5410', 'Staff Salaries', '2725392.01', '0', '0', '0', 'Staff Salaries', '0'),
('2011', '1', '574', '2014-11-27', '1060', 'Staff Salaries for the month of November', '-2725392.01', '0', '0', '0', 'Staff Salaries', '0'),
('2012', '1', '575', '2014-11-27', '5415', 'Salary Commission', '500', '0', '0', '0', 'Salary Commission', '554573'),
('2013', '1', '575', '2014-11-27', '1060', 'Salary Commission', '-500', '0', '0', '0', 'Salary Commission', '554573'),
('2014', '2', '125', '2014-11-04', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-80000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2015', '2', '125', '2014-11-04', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '80000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2016', '2', '126', '2014-11-26', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-150000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2017', '2', '126', '2014-11-26', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '150000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2018', '2', '127', '2014-11-27', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-3700000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2019', '2', '127', '2014-11-27', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '3700000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2020', '1', '576', '2015-10-01', '5780', 'Mark?s Broadband connection Payment (August &amp; September Additional payments)', '25000', '0', '0', '0', 'Chanaka Padmaperuma', '816717'),
('2021', '1', '576', '2015-10-01', '1820', 'Purchase of new Laptop', '150000', '0', '0', '0', 'Chanaka Padmaperuma', '816717'),
('2022', '1', '576', '2015-10-01', '5470', 'VISA Fees for Chanaka Padmaperuma', '14834', '0', '0', '0', 'Chanaka Padmaperuma', '816717'),
('2023', '1', '576', '2015-10-01', '5440', 'Staff Medical expenses ', '11579', '0', '0', '0', 'Chanaka Padmaperuma', '816717'),
('2024', '1', '576', '2015-10-01', '1060', '', '-201413', '0', '0', '0', 'Chanaka Padmaperuma', '816717'),
('2025', '1', '577', '2014-12-17', '5790', 'Other expenses', '500', '0', '0', '0', 'Other expenses', '0'),
('2026', '1', '577', '2014-12-17', '1060', '', '-500', '0', '0', '0', 'Other expenses', '0'),
('2027', '1', '578', '2014-12-22', '5410', 'Staff Salaries', '0', '0', '0', '0', 'Staff Salaries', '0'),
('2028', '1', '578', '2014-12-22', '1220', '', '0', '0', '0', '0', 'Staff Salaries', '0'),
('2029', '1', '579', '2014-12-22', '5415', 'Salary Commission', '0', '0', '0', '0', 'Salary Commission', '0'),
('2030', '1', '579', '2014-12-22', '1220', 'Salary Commission', '0', '0', '0', '0', 'Salary Commission', '0'),
('2031', '2', '128', '2014-12-10', '4010', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2032', '2', '128', '2014-12-10', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2033', '2', '129', '2014-12-10', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-650000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2034', '2', '129', '2014-12-10', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '650000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2035', '2', '130', '2014-12-29', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2036', '2', '130', '2014-12-29', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2037', '2', '131', '2014-12-22', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-3000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2038', '2', '131', '2014-12-22', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '3000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2039', '1', '580', '2015-01-27', '5410', 'Staff Salaries', '2884439.05', '0', '0', '0', 'Staff Salaries', '0'),
('2040', '1', '580', '2015-01-27', '1060', 'Staff Salaries for the month of January', '-2884439.05', '0', '0', '0', 'Staff Salaries', '0'),
('2041', '1', '581', '2015-01-27', '5415', 'Salary Commission', '500', '0', '0', '0', 'Salary Commission', '554574'),
('2042', '1', '581', '2015-01-27', '1060', 'Salary Commission', '-500', '0', '0', '0', 'Salary Commission', '554574'),
('2043', '1', '582', '2015-01-30', '5690', 'Bank Cheque Book Charges  ', '750', '0', '0', '0', 'Bank Cheque Book Charges  ', '0'),
('2044', '1', '582', '2015-01-30', '1060', 'Bank Cheque Book Charges  ', '-750', '0', '0', '0', 'Bank Cheque Book Charges  ', '0'),
('2045', '2', '132', '2015-01-20', '1221', 'Fund Transfer Evolve Technologies', '-150000', '0', '0', '0', 'Fund Transfer Evolve Technologies', '0'),
('2046', '2', '132', '2015-01-20', '1060', 'Fund Transfer Evolve Technologies', '150000', '0', '0', '0', 'Fund Transfer Evolve Technologies', '0'),
('2047', '2', '133', '2015-01-27', '1221', 'Fund Transfer Evolve Technologies', '-3600000', '0', '0', '0', 'Fund Transfer Evolve Technologies', '0'),
('2048', '2', '133', '2015-01-27', '1060', 'Fund Transfer Evolve Technologies', '3600000', '0', '0', '0', 'Fund Transfer Evolve Technologies', '0'),
('2049', '2', '134', '2015-01-29', '1221', 'Fund Transfer Evolve Technologies', '-500000', '0', '0', '0', 'Fund Transfer Evolve Technologies', '0'),
('2050', '2', '134', '2015-01-29', '1060', 'Fund Transfer Evolve Technologies', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies', '0'),
('2051', '1', '583', '2015-02-27', '5410', 'Staff Salaries', '3008901.71', '0', '0', '0', 'Staff Salaries', '0'),
('2052', '1', '583', '2015-02-27', '1060', 'Staff Salaries', '-3008901.71', '0', '0', '0', 'Staff Salaries', '0'),
('2053', '1', '584', '2015-02-27', '5415', 'Salary Commission', '750', '0', '0', '0', 'Salary Commission', '0'),
('2054', '1', '584', '2015-02-27', '1060', 'Salary Commission', '-750', '0', '0', '0', 'Salary Commission', '0'),
('2055', '1', '585', '2015-02-28', '6010', 'Bank OD Charges', '250', '0', '0', '0', 'Bank OD Charges', '0'),
('2056', '1', '585', '2015-02-28', '1060', 'Bank Cheque Book Charges', '-250', '0', '0', '0', 'Bank OD Charges', '0'),
('2057', '2', '135', '2015-02-10', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '-500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2058', '2', '135', '2015-02-10', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2059', '2', '136', '2015-02-20', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '-200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2060', '2', '136', '2015-02-20', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2061', '2', '137', '2015-02-24', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '-1000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2062', '2', '137', '2015-02-24', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '1000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2063', '2', '138', '2015-02-27', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '-4000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2064', '2', '138', '2015-02-27', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '4000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2065', '2', '139', '2015-03-27', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '-4000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2066', '2', '139', '2015-03-27', '1060', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '4000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2067', '1', '586', '2015-03-27', '5410', 'Staff Salaries', '3048692.73', '0', '0', '0', 'Staff Salaries', '554575'),
('2068', '1', '586', '2015-03-27', '1060', 'Staff Salaries for the month of March', '-3048692.73', '0', '0', '0', 'Staff Salaries', '554575'),
('2069', '1', '587', '2015-03-27', '5415', 'Salary Commission', '750', '0', '0', '0', 'Salary Commission', '554576'),
('2070', '1', '587', '2015-03-27', '1060', '', '-750', '0', '0', '0', 'Salary Commission', '554576'),
('2071', '1', '588', '2014-08-31', '6010', 'Bank OD Interest', '0', '0', '0', '0', 'Bank OD Interest', '554577'),
('2072', '1', '588', '2014-08-31', '1060', '', '0', '0', '0', '0', 'Bank OD Interest', '554577'),
('2073', '1', '589', '2014-08-31', '6010', 'Bank OD Charges', '887.39', '0', '0', '0', 'Bank OD Charges', '554578'),
('2074', '1', '589', '2014-08-31', '1060', '', '-887.39', '0', '0', '0', 'Bank OD Charges', '554578'),
('2075', '1', '590', '2014-12-22', '5410', 'Staff Salaries', '2993342', '0', '0', '0', 'Staff Salaries', '0'),
('2076', '1', '590', '2014-12-22', '1060', 'Staff Salaries for the month of December', '-2993342', '0', '0', '0', 'Staff Salaries', '0'),
('2077', '1', '591', '2014-12-22', '5415', 'Salary Commisssion', '500', '0', '0', '0', 'Salary Commisssion', '554579'),
('2078', '1', '591', '2014-12-22', '1060', '', '-500', '0', '0', '0', 'Salary Commisssion', '554579'),
('2079', '1', '592', '2015-10-02', '5460', 'Panelty Charges For The late Payment', '4117.5', '0', '0', '4', '5', '816718'),
('2080', '1', '592', '2015-10-02', '1060', '', '-4117.5', '0', '0', '4', '5', '816718'),
('2081', '1', '593', '2015-10-12', '5470', 'Staff tavelling expenses For The Month of August 2015', '659862.4', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '816719'),
('2082', '1', '593', '2015-10-12', '1060', '', '-659862.4', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '816719'),
('2083', '1', '594', '2015-10-13', '5440', 'Staff Medical expenses (Mr Mewan Samarasinghe)', '8250', '0', '0', '0', 'Mewan Samarasinghe', '816720'),
('2084', '1', '594', '2015-10-13', '1060', '', '-8250', '0', '0', '0', 'Mewan Samarasinghe', '816720'),
('2085', '1', '595', '2015-10-14', '5510', 'Staff Refreshment expenses For the Month Of Octomber 2015 ', '0', '0', '0', '0', 'Cash', '816721'),
('2086', '1', '595', '2015-10-14', '1060', '', '0', '0', '0', '0', 'Cash', '816721'),
('2087', '10', '60', '2014-04-25', '4010', '', '-3446515.04', '0', '0', '2', '2', '0'),
('2088', '10', '60', '2014-04-25', '1200', '', '3446515.04', '0', '0', '2', '2', '0'),
('2089', '10', '61', '2014-05-25', '4010', '', '-3892681.24', '0', '0', '2', '2', '0'),
('2090', '10', '61', '2014-05-25', '1200', '', '3892681.24', '0', '0', '2', '2', '0'),
('2091', '10', '62', '2014-06-25', '4010', '', '0', '0', '0', '2', '2', '0'),
('2092', '10', '62', '2014-06-25', '1200', '', '0', '0', '0', '2', '2', '0'),
('2093', '10', '63', '2014-07-25', '4010', '', '0', '0', '0', '2', '2', '0'),
('2094', '10', '63', '2014-07-25', '1200', '', '0', '0', '0', '2', '2', '0'),
('2095', '10', '64', '2014-08-25', '4010', '', '-4346402.32', '0', '0', '2', '2', '0'),
('2096', '10', '64', '2014-08-25', '1200', '', '4346402.32', '0', '0', '2', '2', '0'),
('2097', '10', '65', '2014-09-25', '4010', '', '0', '0', '0', '2', '2', '0'),
('2098', '10', '65', '2014-09-25', '1200', '', '0', '0', '0', '2', '2', '0'),
('2099', '10', '66', '2014-10-25', '4010', '', '-4343645', '0', '0', '2', '2', '0'),
('2100', '10', '66', '2014-10-25', '1200', '', '4343645', '0', '0', '2', '2', '0'),
('2101', '10', '67', '2014-11-25', '4010', '', '0', '0', '0', '2', '2', '0'),
('2102', '10', '67', '2014-11-25', '1200', '', '0', '0', '0', '2', '2', '0'),
('2103', '10', '68', '2014-12-24', '4010', '', '-4331605', '0', '0', '2', '2', '0'),
('2104', '10', '68', '2014-12-24', '1200', '', '4331605', '0', '0', '2', '2', '0'),
('2105', '10', '69', '2015-01-25', '4010', '', '-4803100', '0', '0', '2', '2', '0'),
('2106', '10', '69', '2015-01-25', '1200', '', '4803100', '0', '0', '2', '2', '0'),
('2107', '10', '70', '2015-02-25', '4010', '', '-5390265', '0', '0', '2', '2', '0'),
('2108', '10', '70', '2015-02-25', '1200', '', '5390265', '0', '0', '2', '2', '0'),
('2109', '2', '140', '2015-10-19', '4010', 'Transfer from GBP A/C', '0', '0', '0', '0', 'Transfer from GBP A/C', '0'),
('2110', '2', '140', '2015-10-19', '1060', '', '0', '0', '0', '0', 'Transfer from GBP A/C', '0'),
('2111', '10', '65', '2014-09-25', '4010', '', '-4413950', '0', '0', '2', '2', '0'),
('2112', '10', '65', '2014-09-25', '1200', '', '4413950', '0', '0', '2', '2', '0'),
('2113', '10', '72', '2015-03-25', '4010', '', '-4717849.5', '0', '0', '2', '2', '0'),
('2114', '10', '72', '2015-03-25', '1200', '', '4717849.5', '0', '0', '2', '2', '0'),
('2115', '12', '57', '2014-04-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2116', '12', '57', '2014-04-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2117', '12', '57', '2015-10-21', '1200', 'Sales Invoice 60', '0', '0', '0', '2', '2', '0'),
('2118', '12', '57', '2015-10-21', '4450', 'Sales Invoice 60', '0', '0', '0', '2', '2', '0'),
('2119', '12', '58', '2014-05-28', '1221', '', '3892681.24', '0', '0', '2', '2', '0'),
('2120', '12', '58', '2014-05-28', '1200', '', '-3892681.24', '0', '0', '2', '2', '0'),
('2121', '12', '59', '2014-06-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2122', '12', '59', '2014-06-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2123', '12', '60', '2014-08-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2124', '12', '60', '2014-08-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2125', '10', '64', '2014-08-25', '1200', 'Customer Payment 60', '-109182.32', '0', '0', '2', '2', '0'),
('2126', '10', '64', '2014-08-25', '4450', 'Customer Payment 60', '109182.32', '0', '0', '2', '2', '0'),
('2127', '12', '61', '2014-09-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2128', '12', '61', '2014-09-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2129', '12', '62', '2014-10-28', '1221', '', '4230508.2', '0', '0', '2', '2', '0'),
('2130', '12', '62', '2014-10-28', '1200', '', '-4230508.2', '0', '0', '2', '2', '0'),
('2131', '10', '66', '2014-10-25', '1200', 'Customer Payment 62', '-113136.8', '0', '0', '2', '2', '0'),
('2132', '10', '66', '2014-10-25', '4450', 'Customer Payment 62', '113136.8', '0', '0', '2', '2', '0'),
('2133', '12', '63', '2014-11-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2134', '12', '63', '2014-11-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2135', '10', '67', '2014-11-25', '1200', 'Customer Payment 63', '0', '0', '0', '2', '2', '0'),
('2136', '10', '67', '2014-11-25', '4450', 'Customer Payment 63', '0', '0', '0', '2', '2', '0'),
('2137', '12', '64', '2014-12-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2138', '12', '64', '2014-12-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2139', '10', '68', '2014-12-24', '1200', 'Customer Payment 64', '-156139.25', '0', '0', '2', '2', '0'),
('2140', '10', '68', '2014-12-24', '4450', 'Customer Payment 64', '156139.25', '0', '0', '2', '2', '0'),
('2141', '12', '65', '2015-01-28', '1221', '', '4447894', '0', '0', '2', '2', '0'),
('2142', '12', '65', '2015-01-28', '1200', '', '-4447894', '0', '0', '2', '2', '0'),
('2143', '12', '65', '2015-10-21', '1200', 'Sales Invoice 69', '-355206', '0', '0', '2', '2', '0'),
('2144', '12', '65', '2015-10-21', '4450', 'Sales Invoice 69', '355206', '0', '0', '2', '2', '0'),
('2145', '12', '66', '2015-02-28', '1221', '', '5133287.25', '0', '0', '2', '2', '0'),
('2146', '12', '66', '2015-02-28', '1200', '', '-5133287.25', '0', '0', '2', '2', '0'),
('2147', '12', '66', '2015-02-28', '1200', 'Sales Invoice 70', '-256977.75', '0', '0', '2', '2', '0'),
('2148', '12', '66', '2015-02-28', '4450', 'Sales Invoice 70', '256977.75', '0', '0', '2', '2', '0'),
('2149', '12', '67', '2015-03-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2150', '12', '67', '2015-03-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2151', '10', '72', '2015-03-25', '1200', 'Customer Payment 67', '-172354.16', '0', '0', '2', '2', '0'),
('2152', '10', '72', '2015-03-25', '4450', 'Customer Payment 67', '172354.16', '0', '0', '2', '2', '0'),
('2153', '10', '73', '2014-07-25', '4010', '', '0', '0', '0', '2', '2', '0'),
('2154', '10', '73', '2014-07-25', '1200', '', '0', '0', '0', '2', '2', '0'),
('2155', '12', '68', '2014-07-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2156', '12', '68', '2014-07-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2157', '12', '68', '2014-07-25', '1200', 'Sales Invoice 73', '0', '0', '0', '2', '2', '0'),
('2158', '12', '68', '2014-07-25', '4450', 'Sales Invoice 73', '0', '0', '0', '2', '2', '0'),
('2159', '2', '141', '2014-06-28', '4450', 'Exchange difference', '0', '0', '0', '0', 'Exchange difference', '0'),
('2160', '2', '141', '2014-06-28', '1220', '', '0', '0', '0', '0', 'Exchange difference', '0'),
('2161', '2', '142', '2014-06-28', '4450', 'Exchange difference', '0', '0', '0', '0', 'Exchange difference', '0'),
('2162', '2', '142', '2014-06-28', '1221', '', '0', '0', '0', '0', 'Exchange difference', '0'),
('2163', '0', '43', '2014-06-28', '1221', 'Exchange Variance', '0', '0', '0', '0', 'Exchange difference', '0'),
('2164', '0', '43', '2014-06-28', '4450', 'Exchange Variance', '0', '0', '0', '0', 'Exchange difference', '0'),
('2165', '1', '596', '2015-10-26', '5410', 'Staff Salary Payment to Mr Uddeshika Jayawardhane for the Month of Octomber 2015', '64100', '0', '0', '0', 'Cash', '816722'),
('2166', '1', '596', '2015-10-26', '1060', '', '-64100', '0', '0', '0', 'Cash', '816722'),
('2167', '1', '597', '2015-10-28', '5470', 'Staff tavelling expenses For The Month of September 2015', '512966.25', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '816723'),
('2168', '1', '597', '2015-10-28', '1060', '', '-512966.25', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '816723'),
('2169', '1', '598', '2015-10-28', '5440', 'Staff Medical expenses- (Jeewani Kokila Perera)', '10000', '0', '0', '0', 'Jeewaani Kokila Perera', '816724'),
('2170', '1', '598', '2015-10-28', '1060', '', '-10000', '0', '0', '0', 'Jeewaani Kokila Perera', '816724'),
('2171', '12', '57', '2014-04-25', '1221', '', '3446515.04', '0', '0', '2', '2', '0'),
('2172', '12', '57', '2014-04-25', '1200', '', '-3446515.04', '0', '0', '2', '2', '0'),
('2173', '12', '68', '2014-07-25', '1221', '', '0', '0', '0', '2', '2', '0'),
('2174', '12', '68', '2014-07-25', '1200', '', '0', '0', '0', '2', '2', '0'),
('2175', '12', '60', '2014-08-25', '1221', '', '4346402.32', '0', '0', '2', '2', '0'),
('2176', '12', '60', '2014-08-25', '1200', '', '-4346402.32', '0', '0', '2', '2', '0'),
('2177', '12', '61', '2014-09-25', '1221', '', '0', '0', '0', '2', '2', '0'),
('2178', '12', '61', '2014-09-25', '1200', '', '0', '0', '0', '2', '2', '0'),
('2179', '12', '64', '2014-12-25', '1221', '', '0', '0', '0', '2', '2', '0'),
('2180', '12', '64', '2014-12-25', '1200', '', '0', '0', '0', '2', '2', '0'),
('2181', '12', '64', '2014-12-28', '1200', 'Sales Invoice 68', '0', '0', '0', '2', '2', '0'),
('2182', '12', '64', '2014-12-28', '4450', 'Sales Invoice 68', '0', '0', '0', '2', '2', '0'),
('2183', '12', '64', '2014-12-29', '1221', '', '0', '0', '0', '2', '2', '0'),
('2184', '12', '64', '2014-12-29', '1200', '', '0', '0', '0', '2', '2', '0'),
('2185', '12', '64', '2014-12-25', '1200', 'Sales Invoice 68', '0', '0', '0', '2', '2', '0'),
('2186', '12', '64', '2014-12-25', '4450', 'Sales Invoice 68', '0', '0', '0', '2', '2', '0'),
('2187', '1', '599', '2015-10-29', '5450', 'The Superintendent, Employees Provident Fund for the month of Oct 2015', '0', '0', '0', '4', '4', '816725'),
('2188', '1', '599', '2015-10-29', '1060', '', '0', '0', '0', '4', '4', '816725'),
('2189', '1', '600', '2015-10-29', '5460', 'Employees Trust Fund for the month of Oct 2015', '0', '0', '0', '4', '5', '816726'),
('2190', '1', '600', '2015-10-29', '1060', '', '0', '0', '0', '4', '5', '816726'),
('2191', '12', '61', '2014-09-29', '1221', '', '4333883', '0', '0', '2', '2', '0'),
('2192', '12', '61', '2014-09-29', '1200', '', '-4333883', '0', '0', '2', '2', '0'),
('2193', '12', '61', '2014-09-25', '1200', 'Sales Invoice 65', '-80067', '0', '0', '2', '2', '0'),
('2194', '12', '61', '2014-09-25', '4450', 'Sales Invoice 65', '80067', '0', '0', '2', '2', '0'),
('2195', '12', '64', '2014-12-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2196', '12', '64', '2014-12-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2197', '12', '64', '2014-12-29', '1200', 'Sales Invoice 68', '0', '0', '0', '2', '2', '0'),
('2198', '12', '64', '2014-12-29', '4450', 'Sales Invoice 68', '0', '0', '0', '2', '2', '0'),
('2199', '12', '64', '2014-12-29', '1221', '', '4127515.89', '0', '0', '2', '2', '0'),
('2200', '12', '64', '2014-12-29', '1200', '', '-4127515.89', '0', '0', '2', '2', '0'),
('2201', '12', '64', '2014-12-28', '1200', 'Sales Invoice 68', '-204089.11', '0', '0', '2', '2', '0'),
('2202', '12', '64', '2014-12-28', '4450', 'Sales Invoice 68', '204089.11', '0', '0', '2', '2', '0'),
('2203', '1', '601', '2015-09-29', '1810', 'Purchase of Furniture &amp; Fittings (Involve 360 PVT Ltd)', '0', '0', '0', '0', 'Leema Creations (Pvt)Ltd.', '554580'),
('2204', '1', '601', '2015-09-29', '1220', '', '0', '0', '0', '0', 'Leema Creations (Pvt)Ltd.', '554580'),
('2205', '1', '602', '2015-11-05', '1810', 'Payment For Purchased Of office Furnitures to Involve 360 (Pvt) Ltd', '979658.65', '0', '0', '0', 'Leema Creation (Pvt) Ltd', '816727'),
('2206', '1', '602', '2015-11-05', '1060', '', '-979658.65', '0', '0', '0', 'Leema Creation (Pvt) Ltd', '816727'),
('2207', '1', '603', '2015-11-05', '5511', 'Staff Training Programme Expenses', '50000', '0', '0', '0', 'Cash', '816728'),
('2208', '1', '603', '2015-11-05', '1810', 'Payment For Purchased Of office Furnitures to Involve 360 (Pvt) Ltd', '245340', '0', '0', '0', 'Cash', '816728'),
('2209', '1', '603', '2015-11-05', '1060', '', '-295340', '0', '0', '0', 'Cash', '816728'),
('2210', '1', '604', '2015-11-11', '5510', 'Staff Refreshment expenses For the Month Of Octomber 2015 ', '140000', '0', '0', '0', 'Cash', '816729'),
('2211', '1', '604', '2015-11-11', '1060', '', '-140000', '0', '0', '0', 'Cash', '816729'),
('2212', '1', '605', '2015-10-14', '5510', 'Staff Refreshment expenses For the Month Of September 2015 ', '140000', '0', '0', '0', 'Cash', '816721'),
('2213', '1', '605', '2015-10-14', '1060', '', '-140000', '0', '0', '0', 'Cash', '816721'),
('2214', '1', '606', '2015-11-13', '5410', 'Staff Salary Advance for Mr.Uddeshika Jayawardhane Month of November 2015', '10000', '0', '0', '0', 'Uddeshika Jayawardhane', '816730'),
('2215', '1', '606', '2015-11-13', '1060', '', '-10000', '0', '0', '0', 'Uddeshika Jayawardhane', '816730'),
('2216', '1', '607', '2015-11-24', '5470', 'Staff tavelling expenses For The Month of October 2015', '580487.05', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '816731'),
('2217', '1', '607', '2015-11-24', '1060', '', '-580487.05', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '816731'),
('2218', '1', '608', '2015-12-01', '5440', 'Staff Medical Expenses-Mr.Aziz Navaz', '3603', '0', '0', '0', 'Aziz Navaz', '816732'),
('2219', '1', '608', '2015-12-01', '1060', '', '-3603', '0', '0', '0', 'Aziz Navaz', '816732'),
('2220', '1', '609', '2015-12-02', '5460', 'Employees Trust fund Settlement for the month of November 2015', '0', '0', '0', '4', '5', '816733'),
('2221', '1', '609', '2015-12-02', '1060', '', '0', '0', '0', '4', '5', '816733'),
('2222', '1', '610', '2015-12-02', '5450', 'The Superintendent, Employees Provident Fund Settlement for the Month of November 2015', '0', '0', '0', '4', '4', '816734'),
('2223', '1', '610', '2015-12-02', '1220', '', '0', '0', '0', '4', '4', '816734'),
('2224', '1', '611', '2015-12-02', '5450', 'The Superintendent, Employees Provident Fund Settlement for the Month of November 2015', '0', '0', '0', '4', '4', '816734'),
('2225', '1', '611', '2015-12-02', '1060', '', '0', '0', '0', '4', '4', '816734'),
('2226', '1', '612', '2015-12-04', '5511', 'Technical Training Expenses', '550000', '0', '0', '0', 'Cash', '816735'),
('2227', '1', '612', '2015-12-04', '5510', 'Expenses for Christians For Christmas(December-2015)', '88000', '0', '0', '0', 'Cash', '816735'),
('2228', '1', '612', '2015-12-04', '5511', 'Staff Training Expenses', '146500', '0', '0', '0', 'Cash', '816735'),
('2229', '1', '612', '2015-12-04', '5780', 'Mark&#039;s broadband Connection Additional payments for the month of October &amp; November', '25000', '0', '0', '0', 'Cash', '816735'),
('2230', '1', '612', '2015-12-04', '1060', '', '-809500', '0', '0', '0', 'Cash', '816735'),
('2231', '1', '613', '2015-12-04', '5695', 'ISO Consultancy Fee-2015', '0', '0', '0', '0', 'E-guardian', '816736'),
('2232', '1', '613', '2015-12-04', '1060', '', '0', '0', '0', '0', 'E-guardian', '816736'),
('2233', '1', '614', '2015-12-11', '5510', 'Staff Refreshment expenses For the Month OfNovember 2015 ', '140000', '0', '0', '0', 'Cash', '816737'),
('2234', '1', '614', '2015-12-11', '1060', '', '-140000', '0', '0', '0', 'Cash', '816737'),
('2235', '1', '615', '2015-12-11', '5510', 'Remaining Balance Payment for the annual Rewards in the Christmas Party 2015', '200000', '0', '0', '0', 'Cash', '816738'),
('2236', '1', '615', '2015-12-11', '1060', '', '-200000', '0', '0', '0', 'Cash', '816738'),
('2237', '1', '616', '2015-12-21', '5470', 'Staff tavelling expenses For The Month of November 2015', '584007.55', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '816739'),
('2238', '1', '616', '2015-12-21', '1060', '', '-584007.55', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '816739'),
('2239', '1', '617', '2015-12-30', '5450', 'The Superintendent, Employees Provident Fund Settlement for the Month of December 2015', '0', '0', '0', '4', '4', '816740'),
('2240', '1', '617', '2015-12-30', '1060', '', '0', '0', '0', '4', '4', '816740'),
('2241', '1', '618', '2015-12-30', '5460', 'Employees Trust fund Settlement for the month of December 2015', '0', '0', '0', '4', '5', '816741'),
('2242', '1', '618', '2015-12-30', '1060', '', '0', '0', '0', '4', '5', '816741'),
('2243', '1', '619', '2015-09-30', '5450', 'The Superintendent, Employees Provident Fund for the month of September 2015', '0', '0', '0', '4', '4', '816715'),
('2244', '1', '619', '2015-09-30', '1060', '', '0', '0', '0', '4', '4', '816715'),
('2245', '1', '620', '2015-09-30', '5460', 'Employees Trust Fund for the month of September 2015', '0', '0', '0', '4', '5', '816716'),
('2246', '1', '620', '2015-09-30', '1060', '', '0', '0', '0', '4', '5', '816716'),
('2247', '1', '621', '2014-07-31', '5510', 'The Superintendent, Employees Provident Fund', '170000', '0', '0', '4', NULL, '0'),
('2248', '1', '621', '2014-07-31', '1060', '', '-170000', '0', '0', '4', NULL, '0'),
('2249', '1', '622', '2014-08-05', '5812', 'Consyltant Fee(Involve 360 pvt ltd)', '0', '0', '0', '0', 'Chanaka Padmaperuma', '0'),
('2250', '1', '622', '2014-08-05', '1060', '', '0', '0', '0', '0', 'Chanaka Padmaperuma', '0'),
('2251', '1', '623', '2014-08-05', '5610', 'Secretarial Fees', '0', '0', '0', '0', 'POPE &amp; COMPANY', '0'),
('2252', '1', '623', '2014-08-05', '1060', '', '0', '0', '0', '0', 'POPE &amp; COMPANY', '0'),
('2253', '1', '624', '2014-09-16', '1820', 'Purchased a Laptop for Office Use', '0', '0', '0', '0', 'Cash', '0'),
('2254', '1', '624', '2014-09-16', '1060', '', '0', '0', '0', '0', 'Cash', '0'),
('2255', '1', '625', '2014-11-14', '5410', 'Six Month Salary in lieu of Notice', '0', '0', '0', '0', 'Nishan Jinadasa', '0'),
('2256', '1', '625', '2014-11-14', '1060', '', '0', '0', '0', '0', 'Nishan Jinadasa', '0'),
('2257', '1', '626', '2014-12-12', '5510', 'Staff Refreshment expenses For the Month Of November 2014', '0', '0', '0', '0', 'Cash', '0'),
('2258', '1', '626', '2014-12-12', '1060', '', '0', '0', '0', '0', 'Cash', '0'),
('2259', '1', '627', '2014-12-23', '5470', 'Staff Travelling Expenses-Casons Taxi Company (PVT) LTD', '0', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '0'),
('2260', '1', '627', '2014-12-23', '1060', '', '0', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '0'),
('2261', '1', '628', '2014-08-05', '5812', 'Consyltant Fee(Involve 360 pvt ltd)', '0', '0', '0', '0', 'Chanaka Padmaperuma', '554581'),
('2262', '1', '628', '2014-08-05', '1220', '', '0', '0', '0', '0', 'Chanaka Padmaperuma', '554581'),
('2263', '1', '629', '2014-08-05', '5812', 'Consyltant Fee(Involve 360 pvt ltd)', '0', '0', '0', '0', 'Chanaka Padmaperuma', '554582'),
('2264', '1', '629', '2014-08-05', '1220', '', '0', '0', '0', '0', 'Chanaka Padmaperuma', '554582'),
('2265', '1', '630', '2014-08-05', '5610', 'Secretarial Fees', '18500', '0', '0', '0', 'POPE &amp; COMPANY', '554583'),
('2266', '1', '630', '2014-08-05', '1220', '', '-18500', '0', '0', '0', 'POPE &amp; COMPANY', '554583'),
('2267', '1', '631', '2014-09-16', '1820', 'Purchased a Laptop for Office Use', '176000', '0', '0', '0', 'Cash', '554584'),
('2268', '1', '631', '2014-09-16', '1220', '', '-176000', '0', '0', '0', 'Cash', '554584'),
('2269', '1', '632', '2014-11-14', '5410', 'Six Month Salary in lieu of Notice', '504000', '0', '0', '0', 'Nishan Jinadasa', '554585'),
('2270', '1', '632', '2014-11-14', '1220', '', '-504000', '0', '0', '0', 'Nishan Jinadasa', '554585'),
('2271', '1', '633', '2014-12-12', '5510', 'Staff Refreshment expenses For the Month Of November 2014', '0', '0', '0', '0', 'Cash', '554586'),
('2272', '1', '633', '2014-12-12', '1220', '', '0', '0', '0', '0', 'Cash', '554586'),
('2273', '1', '634', '2014-12-23', '5470', 'Staff Travelling Expenses-Casons Taxi Company (PVT) LTD', '0', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '554587'),
('2274', '1', '634', '2014-12-23', '1220', '', '0', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '554587'),
('2275', '1', '635', '2014-08-05', '5812', 'Consyltant Fee(Involve 360 pvt ltd)', '22500', '0', '0', '0', 'Chanaka Padmaperuma', '554588'),
('2276', '1', '635', '2014-08-05', '1220', '', '-22500', '0', '0', '0', 'Chanaka Padmaperuma', '554588'),
('2277', '1', '636', '2014-08-05', '5510', 'The company annual trip expenses', '0', '0', '0', '0', 'Chanaka Padmaperuma', '554589'),
('2278', '1', '636', '2014-08-05', '1220', '', '0', '0', '0', '0', 'Chanaka Padmaperuma', '554589'),
('2279', '10', '74', '2014-12-29', '4010', '', '0', '0', '0', '2', '2', '0'),
('2280', '10', '74', '2014-12-29', '1200', '', '0', '0', '0', '2', '2', '0'),
('2281', '12', '69', '2014-12-29', '1221', '', '0', '0', '0', '2', '2', '0'),
('2282', '12', '69', '2014-12-29', '1200', '', '0', '0', '0', '2', '2', '0'),
('2283', '1', '637', '2016-01-06', '5440', 'Staff Medical Expenses- K M A Prasath Perera', '9935', '0', '0', '0', 'K M A Prasath Perera', '816742'),
('2284', '1', '637', '2016-01-06', '1060', '', '-9935', '0', '0', '0', 'K M A Prasath Perera', '816742'),
('2285', '1', '638', '2016-01-06', '5440', 'Staff Medical Expenses- Fathima Shahaniya Ashif', '9750', '0', '0', '0', 'Fathima Shahaniya Ashif', '816743'),
('2286', '1', '638', '2016-01-06', '1060', '', '-9750', '0', '0', '0', 'Fathima Shahaniya Ashif', '816743'),
('2287', '1', '639', '2016-01-12', '5440', 'Staff Medical Expenses for Mr Uddeshika Jayawardhane', '3806', '0', '0', '0', 'Uddeshika Jayawardhane', '816744'),
('2288', '1', '639', '2016-01-12', '1060', '', '-3806', '0', '0', '0', 'Uddeshika Jayawardhane', '816744'),
('2289', '10', '75', '2014-06-28', '4010', '', '-2458670.76', '0', '0', '2', '2', '0'),
('2290', '10', '75', '2014-06-28', '1200', '', '2458670.76', '0', '0', '2', '2', '0'),
('2291', '10', '76', '2014-07-25', '4010', '', '-2486044.6', '0', '0', '2', '2', '0'),
('2292', '10', '76', '2014-07-25', '1200', '', '2486044.6', '0', '0', '2', '2', '0'),
('2293', '10', '77', '2014-11-28', '4010', '', '-3949148.75', '0', '0', '2', '2', '0'),
('2294', '10', '77', '2014-11-28', '1200', '', '3949148.75', '0', '0', '2', '2', '0'),
('2295', '12', '70', '2014-06-28', '1221', '', '2458670.76', '0', '0', '2', '2', '0'),
('2296', '12', '70', '2014-06-28', '1200', '', '-2458670.76', '0', '0', '2', '2', '0'),
('2297', '12', '71', '2014-07-25', '1221', '', '2486044.6', '0', '0', '2', '2', '0'),
('2298', '12', '71', '2014-07-25', '1200', '', '-2486044.6', '0', '0', '2', '2', '0'),
('2299', '12', '72', '2014-11-28', '1221', '', '3949148.75', '0', '0', '2', '2', '0'),
('2300', '12', '72', '2014-11-28', '1200', '', '-3949148.75', '0', '0', '2', '2', '0'),
('2301', '11', '2', '2016-03-28', '4010', '', '0', '0', '0', '2', '2', '0'),
('2302', '11', '2', '2016-03-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2303', '11', '3', '2015-03-28', '4010', '', '670.72', '0', '0', '2', '2', '0'),
('2304', '11', '3', '2015-03-28', '1200', '', '-670.72', '0', '0', '2', '2', '0'),
('2305', '12', '67', '2015-03-28', '1221', '', '4544824.62', '0', '0', '2', '2', '0'),
('2306', '12', '67', '2015-03-28', '1200', '', '-4544824.62', '0', '0', '2', '2', '0'),
('2307', '12', '67', '2015-03-28', '1200', 'Sales Invoice 72', '-172328.73', '0', '0', '2', '2', '0'),
('2308', '12', '67', '2015-03-28', '4450', 'Sales Invoice 72', '172328.73', '0', '0', '2', '2', '0'),
('2309', '11', '3', '2015-03-28', '1200', 'Sales Invoice 72', '-25.43', '0', '0', '2', '2', '0'),
('2310', '11', '3', '2015-03-28', '4450', 'Sales Invoice 72', '25.43', '0', '0', '2', '2', '0'),
('2311', '1', '640', '2016-01-18', '5510', 'Staff Refreshment expenses For the Month Of December 2015 ', '140000', '0', '0', '0', 'Cash', '816745'),
('2312', '1', '640', '2016-01-18', '1060', '', '-140000', '0', '0', '0', 'Cash', '816745'),
('2313', '0', '44', '2014-03-31', '3590', 'Closing Year', '-512246.17', '0', '0', NULL, NULL, '0'),
('2314', '0', '44', '2014-03-31', '9990', 'Closing Year', '512246.17', '0', '0', NULL, NULL, '0'),
('2315', '1', '641', '2014-04-22', '5690', 'Bank Cheque Book Charges', '750', '0', '0', '0', 'Bank Cheque Book Charges', '554590'),
('2316', '1', '641', '2014-04-22', '1060', 'Bank Cheque Book Charges', '-750', '0', '0', '0', 'Bank Cheque Book Charges', '554590'),
('2317', '1', '642', '2014-10-27', '5690', 'Salary Commission', '500', '0', '0', '0', 'Salary Commission', '0'),
('2318', '1', '642', '2014-10-27', '1060', '', '-500', '0', '0', '0', 'Salary Commission', '0'),
('2319', '0', '45', '2015-03-31', '5460', 'Employees Trust Fund for the month of March 2015', '85500', '0', '0', NULL, NULL, '0'),
('2320', '0', '45', '2015-03-31', '5450', 'The Superientendent - Employees Provident Fund for the month of March 2015', '570000', '0', '0', NULL, NULL, '0'),
('2321', '0', '45', '2015-03-31', '5470', 'Staff Travelling Expenses-Casons Taxi Company (PVT) LTD month of March 2015', '518957', '0', '0', NULL, NULL, '0'),
('2322', '0', '45', '2015-03-31', '5510', 'Staff Refreshment expenses For the Month Of March 2015', '140000', '0', '0', NULL, NULL, '0'),
('2323', '0', '45', '2015-03-31', '2110', 'Accrued Charges for the month of march 2015', '-1314457', '0', '0', NULL, NULL, '0'),
('2324', '1', '643', '2014-04-29', '5460', 'Employees Trust Fund for March 2014', '67881.75', '0', '0', '4', '5', '0'),
('2325', '1', '643', '2014-04-29', '1060', '', '-67881.75', '0', '0', '4', '5', '0'),
('2326', '1', '644', '2014-04-29', '5450', 'The Superintendent, Employees Provident Fund for March 2014', '452545', '0', '0', '4', '5', '0'),
('2327', '1', '644', '2014-04-29', '1060', '', '-452545', '0', '0', '4', '5', '0'),
('2328', '2', '143', '2016-01-25', '1180', 'CHQ Receivable from Ceylinco General Insurance Ltd', '0', '0', '0', '0', 'Involve 360 (pvt) Ltd', '0'),
('2329', '2', '143', '2016-01-25', '1060', 'Seylan Bank 968258', '0', '0', '0', '0', 'Involve 360 (pvt) Ltd', '0'),
('2330', '1', '645', '2016-01-25', '5440', 'Staff Medical Expenses Settlement - Mr Amila Palihawadana', '9965.58', '0', '0', '0', 'Amila Palihawadana', '816746'),
('2331', '1', '645', '2016-01-25', '1060', '', '-9965.58', '0', '0', '0', 'Amila Palihawadana', '816746'),
('2332', '1', '646', '2016-01-26', '5440', 'Staff Medical Expenses- Mr Jude Premal Padidilian', '3756', '0', '0', '0', 'Jude Premal Padidilian', '816747'),
('2333', '1', '646', '2016-01-26', '1060', '', '-3756', '0', '0', '0', 'Jude Premal Padidilian', '816747'),
('2334', '1', '647', '2016-01-26', '5440', 'Staff Medical Expenses- Mr Naushad Ameer', '9907', '0', '0', '0', 'Naushad Ameer', '816748'),
('2335', '1', '647', '2016-01-26', '1060', '', '-9907', '0', '0', '0', 'Naushad Ameer', '816748'),
('2336', '1', '648', '2016-01-28', '5470', 'Staff tavelling expenses For The Month of December 2015 ( 580,980.85 - 300 over Added amount )', '580680.85', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '816749'),
('2337', '1', '648', '2016-01-28', '1060', '', '-580680.85', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '816749'),
('2338', '1', '649', '2016-01-28', '5695', 'ISO Consultancy Fee Final Payment Settlement', '0', '0', '0', '0', 'E-guardian (Pvt) Ltd', '816750'),
('2339', '1', '649', '2016-01-28', '1060', '', '0', '0', '0', '0', 'E-guardian (Pvt) Ltd', '816750'),
('2340', '1', '650', '2016-01-28', '5695', 'Audit &amp; UKAS Certificate Approval Expenses', '0', '0', '0', '0', 'Bureau VERITAS Lanka (Pvt) Ltd', '870751'),
('2341', '1', '650', '2016-01-28', '1060', '', '0', '0', '0', '0', 'Bureau VERITAS Lanka (Pvt) Ltd', '870751'),
('2342', '1', '651', '2016-01-28', '5610', 'Per-Audit Fee Settelement', '0', '0', '0', '0', 'Bureau VERITAS Lanka (Pvt) Ltd', '870752'),
('2343', '1', '651', '2016-01-28', '1060', '', '0', '0', '0', '0', 'Bureau VERITAS Lanka (Pvt) Ltd', '870752'),
('2344', '1', '652', '2016-01-28', '5765', 'Payment for UPS Annual Maintanance Contract ', '0', '0', '0', '0', 'Assidua Technologies (Pvt) Ltd', '870753'),
('2345', '1', '652', '2016-01-28', '1060', '', '0', '0', '0', '0', 'Assidua Technologies (Pvt) Ltd', '870753'),
('2346', '1', '653', '2016-01-28', '5520', 'Payment for Top Jops Annual Subscription to Genesiis Software (Pvt) Ltd', '86250', '0', '0', '0', 'Genesiis Software (Pvt) Ltd', '870754'),
('2347', '1', '653', '2016-01-28', '1060', '', '-86250', '0', '0', '0', 'Genesiis Software (Pvt) Ltd', '870754'),
('2348', '1', '654', '2016-01-28', '5780', 'ACSL Conection Fee Payment To Sri Lanka Telecom Plc', '12500', '0', '0', '0', 'Chanaka Padmaperuma', '870755'),
('2349', '1', '654', '2016-01-28', '1060', '', '-12500', '0', '0', '0', 'Chanaka Padmaperuma', '870755'),
('2350', '1', '655', '2016-01-28', '5511', 'Re-Imbursement of Training &amp; Events Certification Cost', '135000', '0', '0', '0', 'Chanaka Padmaperuma', '870756'),
('2351', '1', '655', '2016-01-28', '1060', '', '-135000', '0', '0', '0', 'Chanaka Padmaperuma', '870756'),
('2352', '1', '656', '2016-01-28', '5610', 'Audit &amp; UKAS Certificate Approval Expenses', '0', '0', '0', '0', 'Bureau VERITAS Lanka (Pvt) Ltd', '870751'),
('2353', '1', '656', '2016-01-28', '1060', '', '0', '0', '0', '0', 'Bureau VERITAS Lanka (Pvt) Ltd', '870751'),
('2354', '1', '657', '2016-01-28', '5695', 'ISO Consultancy Fee Final Payment Settlement', '0', '0', '0', '0', 'E-guardian (Pvt) Ltd', '816750'),
('2355', '1', '657', '2016-01-28', '1060', '', '0', '0', '0', '0', 'E-guardian (Pvt) Ltd', '816750'),
('2356', '1', '658', '2016-01-28', '5812', 'Audit &amp; UKAS Certificate Approval Expenses', '249084', '0', '0', '0', 'Bureau VERITAS Lanka (Pvt) Ltd', '870751'),
('2357', '1', '658', '2016-01-28', '1060', '', '-249084', '0', '0', '0', 'Bureau VERITAS Lanka (Pvt) Ltd', '870751'),
('2358', '1', '659', '2016-01-28', '5812', 'Per-Audit Fee Settelement', '45288', '0', '0', '0', 'Bureau VERITAS Lanka (Pvt) Ltd', '870752'),
('2359', '1', '659', '2016-01-28', '1060', '', '-45288', '0', '0', '0', 'Bureau VERITAS Lanka (Pvt) Ltd', '870752'),
('2360', '1', '660', '2016-01-28', '5812', 'ISO Consultancy Fee Final Payment Settlement', '0', '0', '0', '0', 'E-guardian (Pvt) Ltd', '816750'),
('2361', '1', '660', '2016-01-28', '1060', '', '0', '0', '0', '0', 'E-guardian (Pvt) Ltd', '816750'),
('2362', '1', '661', '2015-12-04', '5812', 'ISO Consultancy Fee-2015', '0', '0', '0', '0', 'E-guardian', '816736'),
('2363', '1', '661', '2015-12-04', '1060', '', '0', '0', '0', '0', 'E-guardian', '816736'),
('2364', '1', '662', '2016-01-28', '5700', 'Payment for UPS Annual Maintanance Contract ', '83250', '0', '0', '0', 'Assidua Technologies (Pvt) Ltd', '870753'),
('2365', '1', '662', '2016-01-28', '1060', '', '-83250', '0', '0', '0', 'Assidua Technologies (Pvt) Ltd', '870753'),
('2366', '1', '663', '2016-01-29', '5460', 'Employees Trust fund Settlement for the month of January 2016', '0', '0', '0', '4', '5', '870757'),
('2367', '1', '663', '2016-01-29', '1060', '', '0', '0', '0', '4', '5', '870757'),
('2368', '1', '664', '2016-01-29', '5450', 'The Superintendent, Employees Provident Fund Settlement for the Month of January 2016', '0', '0', '0', '4', '4', '870758'),
('2369', '1', '664', '2016-01-29', '1060', '', '0', '0', '0', '4', '4', '870758'),
('2370', '1', '665', '2016-02-05', '5790', 'Secretarial Fees at Capital Management Services (Pvt) Ltd', '0', '0', '0', '0', 'Capital Management Services (Pvt) Ltd', '870759'),
('2371', '1', '665', '2016-02-05', '1060', '', '0', '0', '0', '0', 'Capital Management Services (Pvt) Ltd', '870759'),
('2372', '1', '666', '2016-02-05', '5795', 'Secretarial Fees at Capital Management Services (Pvt) Ltd', '20633', '0', '0', '0', 'Capital Management Services (Pvt) Ltd', '870759'),
('2373', '1', '666', '2016-02-05', '1060', '', '-20633', '0', '0', '0', 'Capital Management Services (Pvt) Ltd', '870759'),
('2374', '0', '46', '2015-03-31', '5521', 'Staff Loan Settlement', '0', '0', '0', NULL, NULL, '0'),
('2375', '0', '46', '2015-03-31', '1210', 'Staff Loan Settlement', '0', '0', '0', NULL, NULL, '0'),
('2376', '10', '78', '2015-12-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('2377', '10', '78', '2015-12-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('2378', '10', '78', '2015-12-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('2379', '10', '78', '2015-12-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('2380', '0', '47', '2015-03-31', '1200', 'Foreign Exchange Gain / Loss Reversal', '82469.73', '0', '0', NULL, NULL, '0'),
('2381', '0', '47', '2015-03-31', '4450', 'Foreign Exchange Gain / Loss Reversal', '-82469.73', '0', '0', NULL, NULL, '0'),
('2382', '1', '667', '2015-03-31', '5760', 'Rent payment For the Year ', '2400000', '0', '0', '0', 'Cash', '0'),
('2383', '1', '667', '2015-03-31', '1220', '', '-2400000', '0', '0', '0', 'Cash', '0'),
('2384', '10', '79', '2014-12-21', '4010', '', '0', '0', '0', '2', '2', '0'),
('2385', '10', '79', '2014-12-21', '1200', '', '0', '0', '0', '2', '2', '0'),
('2386', '10', '79', '2014-12-21', '4010', '', '0', '0', '0', '2', '2', '0'),
('2387', '10', '79', '2014-12-21', '1200', '', '0', '0', '0', '2', '2', '0'),
('2388', '10', '80', '2014-12-21', '4010', '', '-5854812.5', '0', '0', '2', '2', '0'),
('2389', '10', '80', '2014-12-21', '1200', '', '5854812.5', '0', '0', '2', '2', '0'),
('2390', '12', '73', '2014-12-23', '1221', '', '5854812.5', '0', '0', '2', '2', '0'),
('2391', '12', '73', '2014-12-23', '1200', '', '-5854812.5', '0', '0', '2', '2', '0'),
('2392', '0', '48', '2015-04-01', '5450', ' 	EPF - March 2014', '0', '0', '0', NULL, NULL, '0'),
('2393', '0', '48', '2015-04-01', '5460', 'ETF - March 2014', '0', '0', '0', NULL, NULL, '0'),
('2394', '0', '48', '2015-04-01', '5470', 'Grand Taxi - March 2014', '0', '0', '0', NULL, NULL, '0'),
('2395', '0', '48', '2015-04-01', '2110', 'Accrued charges - March 2014', '0', '0', '0', NULL, NULL, '0'),
('2396', '0', '48', '2014-04-01', '5450', ' 	EPF - March 2014', '-452545', '0', '0', NULL, NULL, '0'),
('2397', '0', '48', '2014-04-01', '5460', 'ETF - March 2014', '-67881.75', '0', '0', NULL, NULL, '0'),
('2398', '0', '48', '2014-04-01', '5470', 'Grand Taxi - March 2014', '-164520', '0', '0', NULL, NULL, '0'),
('2399', '0', '48', '2014-04-01', '2110', 'Accrued charges - March 2014', '684946.75', '0', '0', NULL, NULL, '0');
INSERT INTO `1_gl_trans` VALUES
('2400', '0', '46', '2015-03-31', '1201', 'Staff Loan Settlement', '-50000', '0', '0', NULL, NULL, '0'),
('2401', '0', '46', '2015-03-31', '1210', 'Staff Loan Settlement', '50000', '0', '0', NULL, NULL, '0'),
('2402', '1', '668', '2016-02-09', '5410', 'Staff salary Advance for Mr Buddhika Edirimanna for the month of February 2016', '25000', '0', '0', '0', 'Buddhika Edirimanna', '870760'),
('2403', '1', '668', '2016-02-09', '1060', '', '-25000', '0', '0', '0', 'Buddhika Edirimanna', '870760'),
('2404', '1', '669', '2016-02-09', '5410', 'Staff salary Advance for Mr Uddeshika Jayawardhane for the month of February 2016', '12000', '0', '0', '0', 'Uddeshika Jayawardhane', '870761'),
('2405', '1', '669', '2016-02-09', '1060', '', '-12000', '0', '0', '0', 'Uddeshika Jayawardhane', '870761'),
('2406', '1', '670', '2016-02-09', '5460', 'Panelty Charger for the  Late Documentation ', '26084.34', '0', '0', '4', '5', '870762'),
('2407', '1', '670', '2016-02-09', '5460', 'Panelty Charger for the  Late Documentation', '16177.02', '0', '0', '4', '5', '870762'),
('2408', '1', '670', '2016-02-09', '1060', '', '-42261.36', '0', '0', '4', '5', '870762'),
('2409', '1', '671', '2016-12-02', '5470', 'Staff Travelling Expenses-Casons Taxi Company (PVT) LTD', '353525.4', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '0'),
('2410', '1', '671', '2016-12-02', '1060', '', '-353525.4', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '0'),
('2411', '1', '672', '2016-12-02', '5510', 'Staff Refreshment expenses For the Month Of November 2014', '140000', '0', '0', '0', 'Cash', '0'),
('2412', '1', '672', '2016-12-02', '1060', '', '-140000', '0', '0', '0', 'Cash', '0'),
('2413', '0', '49', '2015-03-31', '5410', 'P.A.Y.E deductions fpr the year', '963478', '0', '0', NULL, NULL, '0'),
('2414', '0', '49', '2015-03-31', '2160', 'P.A.Y.E deductions fpr the year', '-963478', '0', '0', NULL, NULL, '0'),
('2415', '0', '50', '2015-03-31', '5410', 'EPF 8% deduction from employees', '0', '0', '0', NULL, NULL, '0'),
('2416', '0', '50', '2015-03-31', '5450', 'EPF 8% deduction from employees', '0', '0', '0', NULL, NULL, '0'),
('2417', '1', '673', '2016-02-15', '5460', 'Panelty Charger for the  Late Documentation', '5190', '0', '0', '4', '5', '870763'),
('2418', '1', '673', '2016-02-15', '1060', '', '-5190', '0', '0', '4', '5', '870763'),
('2419', '1', '674', '2016-02-15', '5440', 'Staff Medical Expenses for Mr Dylan Beekmeyer', '3400', '0', '0', '0', 'Dylan Beekmeyer', '870764'),
('2420', '1', '674', '2016-02-15', '1060', '', '-3400', '0', '0', '0', 'Dylan Beekmeyer', '870764'),
('2421', '1', '675', '2016-02-15', '5510', 'Staff Refreshment expenses For the Month Of January 2016', '0', '0', '0', '0', 'cash', '870765'),
('2422', '1', '675', '2016-02-15', '1060', '', '0', '0', '0', '0', 'cash', '870765'),
('2423', '1', '676', '2016-02-15', '5510', 'Staff Refreshment expenses For the Month Of January 2016', '140000', '0', '0', '0', 'cash', '870765'),
('2424', '1', '676', '2016-02-15', '1060', '', '-140000', '0', '0', '0', 'cash', '870765'),
('2425', '0', '50', '2015-03-31', '5410', 'EPF 8% deduction from employees', '2173905', '0', '0', NULL, NULL, '0'),
('2426', '0', '50', '2015-03-31', '5450', 'EPF 8% deduction from employees', '-2173905', '0', '0', NULL, NULL, '0'),
('2427', '0', '51', '2015-03-31', '5465', 'Gratuity Provision for the year', '0', '0', '0', NULL, NULL, '0'),
('2428', '0', '51', '2015-03-31', '2140', 'Gratuity Provision for the year', '0', '0', '0', NULL, NULL, '0'),
('2429', '1', '677', '2016-02-16', '5812', 'ISO Consultancy Fee Final Payment Settlement', '584000', '0', '0', '0', 'E-guardian Lanka Private Limited ', '870766'),
('2430', '1', '677', '2016-02-16', '1060', '', '-584000', '0', '0', '0', 'E-guardian Lanka Private Limited ', '870766'),
('2431', '1', '678', '2016-02-29', '5460', 'Employees Trust fund Settlement for the month of January 2016', '132330', '0', '0', '4', '5', '870767'),
('2432', '1', '678', '2016-02-29', '1060', '', '-132330', '0', '0', '4', '5', '870767'),
('2433', '1', '679', '2016-02-29', '5450', 'The Superintendent, Employees Provident Fund Settlement for the Month of January 2016', '882200', '0', '0', '4', '4', '870768'),
('2434', '1', '679', '2016-02-29', '1060', '', '-882200', '0', '0', '4', '4', '870768'),
('2435', '1', '680', '2016-01-29', '5450', 'The Superintendent, Employees Provident Fund Settlement for the Month of December 2016', '872830.6', '0', '0', '4', '4', '870758'),
('2436', '1', '680', '2016-01-29', '1060', '', '-872830.6', '0', '0', '4', '4', '870758'),
('2437', '1', '681', '2016-01-29', '5460', 'Employees Trust fund Settlement for the month of December 2015', '130925', '0', '0', '4', '5', '870757'),
('2438', '1', '681', '2016-01-29', '1060', '', '-130925', '0', '0', '4', '5', '870757'),
('2439', '1', '682', '2015-12-30', '5450', 'The Superintendent, Employees Provident Fund Settlement for the Month of November 2015', '726000', '0', '0', '4', '4', '816740'),
('2440', '1', '682', '2015-12-30', '1060', '', '-726000', '0', '0', '4', '4', '816740'),
('2441', '1', '683', '2015-12-30', '5460', 'Employees Trust fund Settlement for the month of November 2015', '108900', '0', '0', '4', '5', '816741'),
('2442', '1', '683', '2015-12-30', '1060', '', '-108900', '0', '0', '4', '5', '816741'),
('2443', '1', '684', '2015-04-29', '5450', 'The Superintendent, Employees Provident Fund for the month of March 2015', '570000', '0', '0', '4', '4', '779573'),
('2444', '1', '684', '2015-04-29', '1060', '', '-570000', '0', '0', '4', '4', '779573'),
('2445', '1', '685', '2015-06-01', '5450', 'The Superintendent, Employees Provident Fund for the month of April 2015', '549000', '0', '0', '4', '4', '779579'),
('2446', '1', '685', '2015-06-01', '1060', '', '-549000', '0', '0', '4', '4', '779579'),
('2447', '1', '686', '2015-06-30', '5450', 'The Superintendent, Employees Provident Fund for the month of May 2015', '582000', '0', '0', '4', '4', '779587'),
('2448', '1', '686', '2015-06-30', '1060', '', '-582000', '0', '0', '4', '4', '779587'),
('2449', '1', '687', '2015-07-29', '5450', 'The Superintendent, Employees Provident Fundfor the month of June 2015', '613000', '0', '0', '4', '4', '779596'),
('2450', '1', '687', '2015-07-29', '1060', '', '-613000', '0', '0', '4', '4', '779596'),
('2451', '1', '688', '2015-08-31', '5450', 'The Superintendent, Employees Provident Fund for the month of July 2015', '659965.4', '0', '0', '4', '4', '816702'),
('2452', '1', '688', '2015-08-31', '1060', '', '-659965.4', '0', '0', '4', '4', '816702'),
('2453', '1', '689', '2015-09-30', '5450', 'The Superintendent, Employees Provident Fund for the month of August 2015', '694000', '0', '0', '4', '4', '816715'),
('2454', '1', '689', '2015-09-30', '1060', '', '-694000', '0', '0', '4', '4', '816715'),
('2455', '1', '690', '2015-10-29', '5450', 'The Superintendent, Employees Provident Fund for the month of September 2015', '734000', '0', '0', '4', '4', '816725'),
('2456', '1', '690', '2015-10-29', '1060', '', '-734000', '0', '0', '4', '4', '816725'),
('2457', '1', '691', '2015-12-02', '5450', 'The Superintendent, Employees Provident Fund Settlement for the Month of October 2015', '692000', '0', '0', '4', '4', '816734'),
('2458', '1', '691', '2015-12-02', '1060', '', '-692000', '0', '0', '4', '4', '816734'),
('2459', '1', '692', '2015-12-02', '5460', 'Employees Trust fund Settlement for the month of October 2015', '103800', '0', '0', '4', '5', '816734'),
('2460', '1', '692', '2015-12-02', '1060', '', '-103800', '0', '0', '4', '5', '816734'),
('2461', '1', '693', '2015-10-29', '5460', 'Employees Trust Fund for the month of September 2015', '110100', '0', '0', '4', '5', '816726'),
('2462', '1', '693', '2015-10-29', '1060', '', '-110100', '0', '0', '4', '5', '816726'),
('2463', '1', '694', '2015-09-30', '5460', 'Employees Trust Fund for the month of August 2015', '104100', '0', '0', '4', '5', '116716'),
('2464', '1', '694', '2015-09-30', '1060', '', '-104100', '0', '0', '4', '5', '116716'),
('2465', '1', '695', '2015-08-31', '5460', 'Employees Trust Fund for the month of July 2015', '98995', '0', '0', '4', '5', '816703'),
('2466', '1', '695', '2015-08-31', '1060', '', '-98995', '0', '0', '4', '5', '816703'),
('2467', '1', '696', '2015-07-29', '5460', 'Employees Trust Fund for the month of June 2015', '91950', '0', '0', '4', '5', '779597'),
('2468', '1', '696', '2015-07-29', '1060', '', '-91950', '0', '0', '4', '5', '779597'),
('2469', '1', '697', '2015-06-30', '5460', 'Employees Trust Fund for the month of May 2015', '87300', '0', '0', '4', '5', '779588'),
('2470', '1', '697', '2015-06-30', '1060', '', '-87300', '0', '0', '4', '5', '779588'),
('2471', '1', '698', '2015-06-01', '5460', 'Employees Trust fund for the month of April 2015', '82350', '0', '0', '4', '5', '779580'),
('2472', '1', '698', '2015-06-01', '1060', '', '-82350', '0', '0', '4', '5', '779580'),
('2473', '1', '699', '2015-04-29', '5460', 'Employees Trust fund for the month of Marchl 2015', '85500', '0', '0', '4', '5', '779572'),
('2474', '1', '699', '2015-04-29', '1060', '', '-85500', '0', '0', '4', '5', '779572'),
('2475', '1', '700', '2016-03-02', '5470', 'Staff tavelling expenses For The Month of January 2016', '629817.9', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '870769'),
('2476', '1', '700', '2016-03-02', '1060', '', '-629817.9', '0', '0', '0', 'Casons Taxi Company (PVT) LTD', '870769'),
('2477', '1', '701', '2016-03-02', '5440', 'Staff Medical Expenses for Mr.Sajith Chandraratne', '10000', '0', '0', '0', 'Sajith Chandraratne', '870770'),
('2478', '1', '701', '2016-03-02', '1060', '', '-10000', '0', '0', '0', 'Sajith Chandraratne', '870770'),
('2479', '1', '702', '2016-03-07', '5510', 'Special Reward for Mr Shiyam Kamal', '50000', '0', '0', '0', 'Chanaka Padmaperuma', '870771'),
('2480', '1', '702', '2016-03-07', '5785', 'Expenses for Jey&#039;s Visit', '65000', '0', '0', '0', 'Chanaka Padmaperuma', '870771'),
('2481', '1', '702', '2016-03-07', '5780', 'Telephone &amp; Internet Expenses - Sri Lanka Telecom', '12500', '0', '0', '0', 'Chanaka Padmaperuma', '870771'),
('2482', '1', '702', '2016-03-07', '1820', 'New LED Screen for NOC', '70000', '0', '0', '0', 'Chanaka Padmaperuma', '870771'),
('2483', '1', '702', '2016-03-07', '5700', 'Annual Maintenance Contract Fee', '65000', '0', '0', '0', 'Chanaka Padmaperuma', '870771'),
('2484', '1', '702', '2016-03-07', '5765', 'Office Maintanance Expenses', '50000', '0', '0', '0', 'Chanaka Padmaperuma', '870771'),
('2485', '1', '702', '2016-03-07', '1060', '', '-312500', '0', '0', '0', 'Chanaka Padmaperuma', '870771'),
('2486', '1', '703', '2016-03-07', '5410', 'Settled the Salary Difference to Mr Amirtharaj Sivakumaran for month of January &amp; February 2016', '10000', '0', '0', '0', 'Amirtharaj Sivakumaran', '870772'),
('2487', '1', '703', '2016-03-07', '1060', '', '-10000', '0', '0', '0', 'Amirtharaj Sivakumaran', '870772'),
('2488', '1', '704', '2016-03-07', '5410', 'Settled the Salary Difference to Mr Sheikh Basheer for month of January &amp; February 2016', '10000', '0', '0', '0', 'Sheikh Basheer', '870773'),
('2489', '1', '704', '2016-03-07', '1060', '', '-10000', '0', '0', '0', 'Sheikh Basheer', '870773'),
('2490', '1', '705', '2016-03-09', '1200', 'cash reversal against for the received customer payment from Schockman &amp; Samarawickrema (Pvt) Ltd', '0', '0', '0', '0', 'Chanaka Padmaperuma', '870774'),
('2491', '1', '705', '2016-03-09', '1060', '', '0', '0', '0', '0', 'Chanaka Padmaperuma', '870774'),
('2492', '1', '706', '2016-03-15', '5410', 'Staff salary Advance for Mr Aziz Navaz for the month of March 2016', '45000', '0', '0', '0', 'Aziz Navaz', '870776'),
('2493', '1', '706', '2016-03-15', '1060', '', '-45000', '0', '0', '0', 'Aziz Navaz', '870776'),
('2494', '1', '707', '2016-03-16', '5795', 'Secatarial Services Expenses for the period of 01-02-2016 to 31-03-2016', '5000', '0', '0', '0', 'Capital Management Services (Pvt) Ltd', '870777'),
('2495', '1', '707', '2016-03-16', '1060', '', '-5000', '0', '0', '0', 'Capital Management Services (Pvt) Ltd', '870777'),
('2496', '1', '708', '2016-03-16', '2120', 'Audit Fees for the Financial Year 2014/2015', '35000', '0', '0', '0', 'Shantha Adikari &amp; Co.(Chartered Accountants)', '870778'),
('2497', '1', '708', '2016-03-16', '1060', '', '-35000', '0', '0', '0', 'Shantha Adikari &amp; Co.(Chartered Accountants)', '870778'),
('2498', '1', '709', '2016-03-25', '5510', ' 	Staff Refreshment expenses For the Month Of February 2016', '140000', '0', '0', '0', 'Cash', '870779'),
('2499', '1', '709', '2016-03-25', '1060', '', '-140000', '0', '0', '0', 'Cash', '870779'),
('2500', '1', '710', '2016-03-25', '5470', 'Staff tavelling expenses For The Month of February 2016', '581981.4', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '870780'),
('2501', '1', '710', '2016-03-25', '1060', '', '-581981.4', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '870780'),
('2502', '1', '711', '2016-03-31', '5460', 'Employees Trust fund settlement for the month of February 2016', '121080', '0', '0', '4', '5', '870781'),
('2503', '1', '711', '2016-03-31', '1060', '', '-121080', '0', '0', '4', '5', '870781'),
('2504', '1', '712', '2016-03-31', '5450', 'The Superintendent, Employees Provident Fund settlement for the month of February 2016', '807200', '0', '0', '4', '4', '870782'),
('2505', '1', '712', '2016-03-31', '1060', '', '-807200', '0', '0', '4', '4', '870782'),
('2506', '1', '713', '2016-03-31', '2160', 'PAYE Tax Settlement April 2015 to March 2016', '1451968.09', '0', '0', '4', '6', '870783'),
('2507', '1', '713', '2016-03-31', '1060', '', '-1451968.09', '0', '0', '4', '6', '870783'),
('2508', '1', '714', '2016-03-31', '5440', 'Staff Medical Expenses for Mr Safa Afrak', '9646', '0', '0', '0', 'Safa Afrak', '870784'),
('2509', '1', '714', '2016-03-31', '1060', '', '-9646', '0', '0', '0', 'Safa Afrak', '870784'),
('2510', '1', '715', '2016-04-20', '5470', 'Staff tavelling expenses For The Month of March 2016', '643974.05', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '870785'),
('2511', '1', '715', '2016-04-20', '1060', '', '-643974.05', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '870785'),
('2512', '1', '716', '2016-04-20', '5510', ' Staff Refreshment expenses For the Month Of March 2016', '140000', '0', '0', '0', 'Cash', '870786'),
('2513', '1', '716', '2016-04-20', '1060', '', '-140000', '0', '0', '0', 'Cash', '870786'),
('2514', '1', '717', '2016-04-22', '5440', 'Staff Medical Expenses for Mr Gayan Edirisinghe (April 2016)', '5000', '0', '0', '0', 'Gayan Edirisinghe', '870787'),
('2515', '1', '717', '2016-04-22', '1060', '', '-5000', '0', '0', '0', 'Gayan Edirisinghe', '870787'),
('2516', '1', '718', '2016-04-27', '5780', 'Telephone And Internet expenses for Month Of March 2016 ( Invoice No 21125879 )', '197704.05', '0', '0', '0', 'Dialog Broadband Networks (Pvt) Ltd.', '870788'),
('2517', '1', '718', '2016-04-27', '1060', '', '-197704.05', '0', '0', '0', 'Dialog Broadband Networks (Pvt) Ltd.', '870788'),
('2518', '1', '719', '2016-04-28', '5460', 'Employees Trust fund settlement for the month of March 2016', '124380', '0', '0', '4', '5', '870789'),
('2519', '1', '719', '2016-04-28', '1060', '', '-124380', '0', '0', '4', '5', '870789'),
('2520', '1', '720', '2016-04-28', '5450', 'The Superientendent - Employees Provident Fund Settlement for the month of March 2016', '829200', '0', '0', '4', '4', '870790'),
('2521', '1', '720', '2016-04-28', '1060', '', '-829200', '0', '0', '4', '4', '870790'),
('2522', '10', '81', '2015-04-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('2523', '10', '81', '2015-04-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('2524', '12', '74', '2015-04-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2525', '12', '74', '2015-04-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2526', '10', '82', '2015-05-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('2527', '10', '82', '2015-05-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('2528', '10', '83', '2015-06-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('2529', '10', '83', '2015-06-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('2530', '10', '84', '2015-07-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('2531', '10', '84', '2015-07-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('2532', '10', '85', '2015-08-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('2533', '10', '85', '2015-08-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('2534', '10', '86', '2015-09-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('2535', '10', '86', '2015-09-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('2536', '10', '87', '2015-10-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('2537', '10', '87', '2015-10-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('2538', '10', '88', '2015-11-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('2539', '10', '88', '2015-11-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('2540', '10', '89', '2015-12-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('2541', '10', '89', '2015-12-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('2542', '10', '90', '2016-01-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('2543', '10', '90', '2016-01-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('2544', '10', '91', '2016-02-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('2545', '10', '91', '2016-02-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('2546', '10', '92', '2016-03-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('2547', '10', '92', '2016-03-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('2548', '12', '75', '2015-05-25', '1221', '', '0', '0', '0', '2', '2', '0'),
('2549', '12', '75', '2015-05-25', '1200', '', '0', '0', '0', '2', '2', '0'),
('2550', '12', '76', '2015-06-25', '1221', '', '0', '0', '0', '2', '2', '0'),
('2551', '12', '76', '2015-06-25', '1200', '', '0', '0', '0', '2', '2', '0'),
('2552', '12', '77', '2015-07-27', '1221', '', '0', '0', '0', '2', '2', '0'),
('2553', '12', '77', '2015-07-27', '1200', '', '0', '0', '0', '2', '2', '0'),
('2554', '12', '78', '2015-08-26', '1221', '', '0', '0', '0', '2', '2', '0'),
('2555', '12', '78', '2015-08-26', '1200', '', '0', '0', '0', '2', '2', '0'),
('2556', '12', '79', '2015-09-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2557', '12', '79', '2015-09-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2558', '12', '80', '2015-10-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2559', '12', '80', '2015-10-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2560', '12', '81', '2015-11-26', '1221', '', '0', '0', '0', '2', '2', '0'),
('2561', '12', '81', '2015-11-26', '1200', '', '0', '0', '0', '2', '2', '0'),
('2562', '12', '82', '2015-12-23', '1221', '', '0', '0', '0', '2', '2', '0'),
('2563', '12', '82', '2015-12-23', '1200', '', '0', '0', '0', '2', '2', '0'),
('2564', '12', '83', '2016-01-27', '1221', '', '0', '0', '0', '2', '2', '0'),
('2565', '12', '83', '2016-01-27', '1200', '', '0', '0', '0', '2', '2', '0'),
('2566', '12', '84', '2016-03-01', '1221', '', '0', '0', '0', '2', '2', '0'),
('2567', '12', '84', '2016-03-01', '1200', '', '0', '0', '0', '2', '2', '0'),
('2568', '12', '85', '2016-03-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2569', '12', '85', '2016-03-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2570', '1', '721', '2016-04-29', '5410', 'Allowance Payment for Mr Pintoe', '200000', '0', '0', '0', 'K.P.L. Pintoe', '870791'),
('2571', '1', '721', '2016-04-29', '1060', '', '-200000', '0', '0', '0', 'K.P.L. Pintoe', '870791'),
('2572', '1', '722', '2016-05-04', '5440', 'Staff Medical Expenses for Mr Iheshan Musafer', '3600', '0', '0', '0', 'Iheshan Musafer', '870792'),
('2573', '1', '722', '2016-05-04', '1060', '', '-3600', '0', '0', '0', 'Iheshan Musafer', '870792'),
('2574', '1', '723', '2016-05-05', '1820', 'Purchased 01 Qty of Singer 18000Btu Air Conditioner fro Singer Sri Lanka', '95000', '0', '0', '0', 'SINGER ( SRILANKA ) PLC', '870793'),
('2575', '1', '723', '2016-05-05', '1060', '', '-95000', '0', '0', '0', 'SINGER ( SRILANKA ) PLC', '870793'),
('2576', '1', '724', '2016-05-09', '5780', 'Telephone &amp; Internet Expenses for ADSL Connection', '0', '0', '0', '0', 'Cash', '870794'),
('2577', '1', '724', '2016-05-09', '5695', 'ITG Plan renewal - Payment reimbursement', '0', '0', '0', '0', 'Cash', '870794'),
('2578', '1', '724', '2016-05-09', '5695', 'Wachguard web blocker license for SL firewall - ISO requirement', '0', '0', '0', '0', 'Cash', '870794'),
('2579', '1', '724', '2016-05-09', '5695', 'BIO metrix scanner which supports unauthorized access reports - ISO requirement', '0', '0', '0', '0', 'Cash', '870794'),
('2580', '1', '724', '2016-05-09', '1060', '', '0', '0', '0', '0', 'Cash', '870794'),
('2581', '1', '725', '2015-06-10', '5811', 'Overseas Travel Expenses', '210663.05', '0', '0', '0', 'Chanaka Padmaperuma', '554591'),
('2582', '1', '725', '2015-06-10', '1060', '', '-210663.05', '0', '0', '0', 'Chanaka Padmaperuma', '554591'),
('2583', '1', '726', '2016-05-11', '5440', 'Staff Medical Expense for Mr Uddeshika Jayawardhana', '10000', '0', '0', '0', 'Uddeshika Jayawardhana', '870795'),
('2584', '1', '726', '2016-05-11', '1060', '', '-10000', '0', '0', '0', 'Uddeshika Jayawardhana', '870795'),
('2585', '1', '727', '2016-05-18', '5440', 'Staff Medical Expense for Mr Gayan Edirisinghe', '4350', '0', '0', '0', 'Gayan Edirisinghe', '870796'),
('2586', '1', '727', '2016-05-18', '1060', '', '-4350', '0', '0', '0', 'Gayan Edirisinghe', '870796'),
('2587', '1', '728', '2016-05-18', '5510', 'Staff Refreshment expenses For the Month Of April 2016', '140000', '0', '0', '0', 'Cash', '870797'),
('2588', '1', '728', '2016-05-18', '1060', '', '-140000', '0', '0', '0', 'Cash', '870797'),
('2589', '1', '729', '2016-05-19', '2160', 'P.A.Y.E for the month of April 2016', '147501', '0', '0', '4', '6', '870798'),
('2590', '1', '729', '2016-05-19', '1060', '', '-147501', '0', '0', '4', '6', '870798'),
('2591', '1', '730', '2016-05-23', '5470', 'Staff tavelling expenses For The Month of April 2016', '629463.35', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '870799'),
('2592', '1', '730', '2016-05-23', '1060', '', '-629463.35', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '870799'),
('2593', '2', '144', '2016-05-27', '5685', 'Insurance Claimed from Ceylinco General Insurance ltd', '-18185.87', '0', '0', '0', 'Ceylinco General Insuarance ltd', '0'),
('2594', '2', '144', '2016-05-27', '1060', '', '18185.87', '0', '0', '0', 'Ceylinco General Insuarance ltd', '0'),
('2595', '1', '731', '2016-05-30', '5460', 'Employees Trust fund settlement for the month of April 2016', '124230', '0', '0', '4', '5', '870800'),
('2596', '1', '731', '2016-05-30', '1060', '', '-124230', '0', '0', '4', '5', '870800'),
('2597', '1', '732', '2016-05-30', '5450', 'The Superientendent - Employees Provident Fund Settlement for the month of April 2016', '828200', '0', '0', '4', '4', '910101'),
('2598', '1', '732', '2016-05-30', '1060', '', '-828200', '0', '0', '4', '4', '910101'),
('2599', '1', '733', '2016-05-31', '1220', 'Fund Transfer to Evolve Technologies A/C  From Sampath Bank- Current Account', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '910102'),
('2600', '1', '733', '2016-05-31', '1060', '', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '910102'),
('2601', '1', '734', '2016-05-31', '1060', 'Fund Transfer to Evolve Technologies A/C  From Sampath Bank- Current Account', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '910102'),
('2602', '1', '734', '2016-05-31', '1060', '', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '910102'),
('2603', '1', '735', '2016-05-31', '1221', 'Fund Transfer to Evolve Technologies A/C  From Sampath Bank- Current Account', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '910102'),
('2604', '1', '735', '2016-05-31', '1060', '', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '910102'),
('2605', '1', '736', '2016-06-07', '5695', 'Requirement Analysis for N- able &amp; autotask', '200000', '0', '0', '0', 'Ceymplon (Pvt) Ltd', '910103'),
('2606', '1', '736', '2016-06-07', '1060', '', '-200000', '0', '0', '0', 'Ceymplon (Pvt) Ltd', '910103'),
('2607', '1', '737', '2016-06-07', '5780', 'ADSL Connection Charge', '2500', '0', '0', '0', 'Cash', '910104'),
('2608', '1', '737', '2016-06-07', '5511', 'Staff Training Expenses- Tecnical Team', '135000', '0', '0', '0', 'Cash', '910104'),
('2609', '1', '737', '2016-06-07', '1060', '', '-137500', '0', '0', '0', 'Cash', '910104'),
('2610', '1', '738', '2016-05-09', '5780', 'Telephone &amp; Internet Expenses for ADSL Connection', '0', '0', '0', '0', 'Cash', '870794'),
('2611', '1', '738', '2016-05-09', '5695', 'ITG Plan renewal - Payment reimbursement', '0', '0', '0', '0', 'Cash', '870794'),
('2612', '1', '738', '2016-05-09', '1060', 'Cash Refunded 87,500/= to Mr .Pintoe  (276,500 - 189,000)', '0', '0', '0', '0', 'Cash', '870794'),
('2613', '1', '739', '2016-05-09', '5780', 'Telephone &amp; Internet Expenses for ADSL Connection', '0', '0', '0', '0', 'Cash', '870794'),
('2614', '1', '739', '2016-05-09', '5695', 'ITG Plan renewal - Payment reimbursement', '0', '0', '0', '0', 'Cash', '870794'),
('2615', '1', '739', '2016-05-09', '1220', 'Cash Refunded', '0', '0', '0', '0', 'Cash', '870794'),
('2616', '1', '739', '2016-05-09', '1060', 'Cash Refunded 87,500/= to Mr .Pintoe  (276,500 - 189,000)', '0', '0', '0', '0', 'Cash', '870794'),
('2617', '1', '740', '2016-05-09', '5780', 'Telephone &amp; Internet Expenses for ADSL Connection', '35000', '0', '0', '0', 'Cash', '870794'),
('2618', '1', '740', '2016-05-09', '5695', 'ITG Plan renewal - Payment reimbursement', '154000', '0', '0', '0', 'Cash', '870794'),
('2619', '1', '740', '2016-05-09', '1221', 'Cash Refunded', '87500', '0', '0', '0', 'Cash', '870794'),
('2620', '1', '740', '2016-05-09', '1060', 'Cash Refunded 87,500/= to Mr .Pintoe  (276,500 - 189,000)', '-276500', '0', '0', '0', 'Cash', '870794'),
('2621', '1', '741', '2016-06-09', '1820', 'Purchased Computer Equipment from Tech Information Solutions- Invoice no 713562941', '243000', '0', '0', '0', 'Tech Information Solution (PVT) Ltd', '910105'),
('2622', '1', '741', '2016-06-09', '1060', '', '-243000', '0', '0', '0', 'Tech Information Solution (PVT) Ltd', '910105'),
('2623', '1', '742', '2016-06-13', '2160', 'P.A.Y.E for the month of May 2016', '181636.1', '0', '0', '4', '6', '910106'),
('2624', '1', '742', '2016-06-13', '1060', '', '-181636.1', '0', '0', '4', '6', '910106'),
('2625', '4', '1', '2016-05-31', '1060', 'From Sampath Bank - Current Account To Evolve Technologies (Pvt) Ltd.', '0', '0', '0', NULL, NULL, '0'),
('2626', '4', '1', '2016-05-31', '1220', 'From Sampath Bank - Current Account To Evolve Technologies (Pvt) Ltd.', '0', '0', '0', NULL, NULL, '0'),
('2627', '1', '743', '2016-05-31', '1220', 'Fund Transfer to Evolve Technologies Current Acc', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '910102'),
('2628', '1', '743', '2016-05-31', '1060', '', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '910102'),
('2629', '1', '744', '2016-05-31', '1221', 'Fund Transfer to Evolve Technologies Current Acc', '2600000', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '910101'),
('2630', '1', '744', '2016-05-31', '1060', '', '-2600000', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '910101'),
('2631', '1', '745', '2016-06-17', '5440', 'Staff Medical Expenses for Mr Prasanna Vivek', '10000', '0', '0', '0', 'Prasanna Vivek', '910107'),
('2632', '1', '745', '2016-06-17', '1060', '', '-10000', '0', '0', '0', 'Prasanna Vivek', '910107'),
('2633', '1', '746', '2016-06-17', '5510', 'Staff Refreshment Expenses for the Month of May 2016', '140000', '0', '0', '0', 'Cash', '910108'),
('2634', '1', '746', '2016-06-17', '1060', '', '-140000', '0', '0', '0', 'Cash', '910108'),
('2635', '1', '747', '2016-06-21', '5470', 'Staff Traveling expenses For The Month of May 2016', '695769.75', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '910109'),
('2636', '1', '747', '2016-06-21', '1060', '', '-695769.75', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '910109'),
('2637', '1', '748', '2016-06-24', '5780', 'Telephone And Internet expenses for Month Of May 2016 ( Invoice No 21498403 )', '429785.55', '0', '0', '0', 'Dialog Broadband Networks (Pvt) Ltd', '910110'),
('2638', '1', '748', '2016-06-24', '1060', '', '-429785.55', '0', '0', '0', 'Dialog Broadband Networks (Pvt) Ltd', '910110'),
('2639', '1', '749', '2016-06-24', '5780', 'Telephone &amp; Internet Expenses for the Month of May 2016', '171225.34', '0', '0', '0', 'Tata Communications Lanka Ltd', '910111'),
('2640', '1', '749', '2016-06-24', '1060', '', '-171225.34', '0', '0', '0', 'Tata Communications Lanka Ltd', '910111'),
('2641', '1', '750', '2016-04-27', '5410', 'Staff Salary payment for the month of April 2016', '4573014.66', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2642', '1', '750', '2016-04-27', '1060', '', '-4573014.66', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2643', '1', '751', '2016-04-27', '5415', 'Salary Commission- April 2016', '750', '0', '0', '0', 'Salary Commission', '0'),
('2644', '1', '751', '2016-04-27', '1060', '', '-750', '0', '0', '0', 'Salary Commission', '0'),
('2645', '1', '752', '2016-05-27', '5415', 'Salary Commission-May 2016', '750', '0', '0', '0', 'Salary Commission', '0'),
('2646', '1', '752', '2016-05-27', '1060', '', '-750', '0', '0', '0', 'Salary Commission', '0'),
('2647', '1', '753', '2016-05-27', '5410', 'Staff Salary payment for the month of May 2016', '4856567.59', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2648', '1', '753', '2016-05-27', '1060', '', '-4856567.59', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2649', '1', '754', '2016-05-20', '5690', 'Bank Charges-CHQ Book Charge', '500', '0', '0', '0', 'Bank Charges', '0'),
('2650', '1', '754', '2016-05-20', '1060', '', '-500', '0', '0', '0', 'Bank Charges', '0'),
('2651', '2', '145', '2016-04-20', '1221', 'Fund Transfer from Evolve Technologies (Pvt) Ltd ', '-400000', '0', '0', '0', 'Involve 360 (pvt) Ltd', '0'),
('2652', '2', '145', '2016-04-20', '1060', '', '400000', '0', '0', '0', 'Involve 360 (pvt) Ltd', '0'),
('2653', '1', '755', '2016-06-29', '5460', 'Employees Trust fund settlement for the month of May 2016', '131880', '0', '0', '4', '5', '910112'),
('2654', '1', '755', '2016-06-29', '1060', '', '-131880', '0', '0', '4', '5', '910112'),
('2655', '1', '756', '2016-06-29', '5450', 'The Superientendent - Employees Provident Fund Settlement for the month of May 2016', '879200', '0', '0', '4', '4', '910113'),
('2656', '1', '756', '2016-06-29', '1060', '', '-879200', '0', '0', '4', '4', '910113'),
('2657', '1', '757', '2016-06-29', '1221', 'Fund Transfer to Evolve Technologies Current Acc', '500000', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '910114'),
('2658', '1', '757', '2016-06-29', '1060', '', '-500000', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '910114'),
('2659', '1', '758', '2016-06-29', '5440', 'Staff Medical Expenses for Ms Safa Afrak', '10000', '0', '0', '0', 'Safa Afrak', '910115'),
('2660', '1', '758', '2016-06-29', '1060', '', '-10000', '0', '0', '0', 'Safa Afrak', '910115'),
('2661', '10', '93', '2016-04-26', '4010', '', '0', '0', '0', '2', '2', '0'),
('2662', '10', '93', '2016-04-26', '1200', '', '0', '0', '0', '2', '2', '0'),
('2663', '12', '86', '2016-04-26', '1221', '', '0', '0', '0', '2', '2', '0'),
('2664', '12', '86', '2016-04-26', '1200', '', '0', '0', '0', '2', '2', '0'),
('2665', '12', '86', '2016-04-26', '1200', 'Sales Invoice 93', '0', '0', '0', '2', '2', '0'),
('2666', '12', '86', '2016-04-26', '4450', 'Sales Invoice 93', '0', '0', '0', '2', '2', '0'),
('2667', '10', '94', '2016-04-26', '4010', '', '0', '0', '0', '2', '1', '0'),
('2668', '10', '94', '2016-04-26', '1200', '', '0', '0', '0', '2', '1', '0'),
('2669', '12', '87', '2016-04-26', '1060', '', '0', '0', '0', '2', '1', '0'),
('2670', '12', '87', '2016-04-26', '1200', '', '0', '0', '0', '2', '1', '0'),
('2671', '12', '88', '2016-04-26', '1061', '', '0', '0', '0', '2', '2', '0'),
('2672', '12', '88', '2016-04-26', '1200', '', '0', '0', '0', '2', '2', '0'),
('2673', '12', '88', '2016-07-01', '1200', 'Sales Invoice 93', '0', '0', '0', '2', '2', '0'),
('2674', '12', '88', '2016-07-01', '4450', 'Sales Invoice 93', '0', '0', '0', '2', '2', '0'),
('2675', '10', '93', '2016-04-26', '4010', '', '-7530058.5', '0', '0', '2', '2', '0'),
('2676', '10', '93', '2016-04-26', '1200', '', '7530058.5', '0', '0', '2', '2', '0'),
('2677', '12', '89', '2016-04-26', '1061', '', '0', '0', '0', '2', '2', '0'),
('2678', '12', '89', '2016-04-26', '1200', '', '0', '0', '0', '2', '2', '0'),
('2679', '12', '89', '2016-04-26', '5690', '', '0', '0', '0', '2', '2', '0'),
('2680', '12', '90', '2016-04-26', '1061', '', '7530058.5', '0', '0', '2', '2', '0'),
('2681', '12', '90', '2016-04-26', '1200', '', '-7530058.5', '0', '0', '2', '2', '0'),
('2682', '4', '2', '2016-04-26', '1061', 'From Sampath Bank - GBP Account To Sampath Bank - Current Account', '-7530058.5', '0', '0', NULL, NULL, '0'),
('2683', '4', '2', '2016-04-26', '1060', 'From Sampath Bank - GBP Account To Sampath Bank - Current Account', '7530058.5', '0', '0', NULL, NULL, '0'),
('2684', '1', '759', '2016-04-26', '5690', 'Bank charges', '575', '0', '0', '0', 'Bank charges', '554592'),
('2685', '1', '759', '2016-04-26', '1060', '', '-575', '0', '0', '0', 'Bank charges', '554592'),
('2686', '1', '760', '2015-04-27', '5410', 'Staff Salary payment for the month of April 2015', '3132381.1', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2687', '1', '760', '2015-04-27', '1060', '', '-3132381.1', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2688', '1', '761', '2015-04-27', '5415', 'Salary Commission- April 2015', '750', '0', '0', '0', 'Salary Commission', '0'),
('2689', '1', '761', '2015-04-27', '1060', '', '-750', '0', '0', '0', 'Salary Commission', '0'),
('2690', '1', '762', '2015-04-30', '6010', 'Overdraft Interest Charge', '600', '0', '0', '0', 'Overdraft Interest', '0'),
('2691', '1', '762', '2015-04-30', '1060', '', '-600', '0', '0', '0', 'Overdraft Interest', '0'),
('2692', '2', '146', '2015-04-10', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '-200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2693', '2', '146', '2015-04-10', '1060', '', '200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2694', '2', '147', '2015-04-27', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '-3200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2695', '2', '147', '2015-04-27', '1060', '', '3200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2696', '2', '148', '2015-04-30', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '-900000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2697', '2', '148', '2015-04-30', '1060', '', '900000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2698', '1', '763', '2015-05-28', '5410', 'Staff Salary payment for the month of May 2015', '3679647.41', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2699', '1', '763', '2015-05-28', '1060', '', '-3679647.41', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2700', '1', '764', '2015-05-28', '5415', 'Salary Commission- May 2015', '750', '0', '0', '0', 'Salary Commission', '0'),
('2701', '1', '764', '2015-05-28', '1060', '', '-750', '0', '0', '0', 'Salary Commission', '0'),
('2702', '2', '149', '2015-05-15', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '-500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2703', '2', '149', '2015-05-15', '1060', '', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2704', '2', '150', '2015-05-28', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '-4500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2705', '2', '150', '2015-05-28', '1060', '', '4500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd ', '0'),
('2706', '1', '765', '2015-06-29', '5410', 'Staff Salary payment for the month of June 2015', '3527216.7', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2707', '1', '765', '2015-06-29', '1060', '', '-3527216.7', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2708', '1', '766', '2015-06-29', '5415', 'Salary Commission- June 2015', '750', '0', '0', '0', 'Salary Commission', '0'),
('2709', '1', '766', '2015-06-29', '1060', '', '-750', '0', '0', '0', 'Salary Commission', '0'),
('2710', '2', '151', '2015-06-15', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-600000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2711', '2', '151', '2015-06-15', '1060', '', '600000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2712', '2', '152', '2015-06-19', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-150000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2713', '2', '152', '2015-06-19', '1060', '', '150000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2714', '2', '153', '2015-06-29', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-4300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2715', '2', '153', '2015-06-29', '1060', '', '4300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2716', '1', '767', '2015-06-17', '5690', 'Bank Charges-CHQ Book Charge', '500', '0', '0', '0', 'Bank Charges', '0'),
('2717', '1', '767', '2015-06-17', '1060', '', '-500', '0', '0', '0', 'Bank Charges', '0'),
('2718', '1', '768', '2015-07-28', '5410', 'Staff Salary payment for the month of July 2015', '3459224.6', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2719', '1', '768', '2015-07-28', '1060', '', '-3459224.6', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2720', '1', '769', '2015-07-28', '5415', 'Salary Commission- July 2015', '750', '0', '0', '0', 'Salary Commission', '0'),
('2721', '1', '769', '2015-07-28', '1060', '', '-750', '0', '0', '0', 'Salary Commission', '0'),
('2722', '2', '154', '2015-07-10', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-600000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2723', '2', '154', '2015-07-10', '1060', '', '600000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2724', '2', '155', '2015-07-28', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-4300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2725', '2', '155', '2015-07-28', '1060', '', '4300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2726', '1', '770', '2015-08-03', '5690', 'Bank Charges-CHQ Book Charge', '500', '0', '0', '0', 'Bank Charges', '0'),
('2727', '1', '770', '2015-08-03', '1060', '', '-500', '0', '0', '0', 'Bank Charges', '0'),
('2728', '1', '771', '2015-08-04', '6010', 'Overdraft Interest Charge', '50', '0', '0', '0', 'Bank Charges', '0'),
('2729', '1', '771', '2015-08-04', '1060', '', '-50', '0', '0', '0', 'Bank Charges', '0'),
('2730', '1', '772', '2015-08-04', '5690', 'CHQ Book Post Charges from City Bank', '115', '0', '0', '0', 'Bank Charges', '0'),
('2731', '1', '772', '2015-08-04', '1060', '', '-115', '0', '0', '0', 'Bank Charges', '0'),
('2732', '1', '773', '2015-08-27', '5410', 'Staff Salary payment for the month of August 2015', '3699062', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2733', '1', '773', '2015-08-27', '1060', '', '-3699062', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2734', '1', '774', '2015-08-27', '5415', 'Salary Commission- August 2015', '750', '0', '0', '0', 'Salary Commission', '0'),
('2735', '1', '774', '2015-08-27', '1060', '', '-750', '0', '0', '0', 'Salary Commission', '0'),
('2736', '2', '156', '2015-08-03', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2737', '2', '156', '2015-08-03', '1060', '', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2738', '2', '157', '2015-08-20', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2739', '2', '157', '2015-08-20', '1060', '', '500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2740', '2', '158', '2015-08-27', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-4300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2741', '2', '158', '2015-08-27', '1060', '', '4300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2742', '2', '159', '2015-08-31', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2743', '2', '159', '2015-08-31', '1060', '', '200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2744', '2', '160', '2015-09-10', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2745', '2', '160', '2015-09-10', '1060', '', '200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2746', '2', '161', '2015-09-23', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-700000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2747', '2', '161', '2015-09-23', '1060', '', '700000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2748', '2', '162', '2015-09-28', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-4600000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2749', '2', '162', '2015-09-28', '1060', '', '4600000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2750', '1', '775', '2015-09-28', '5410', 'Staff Salary payment for the month of September 2015', '3951061.2', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2751', '1', '775', '2015-09-28', '1060', '', '-3951061.2', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2752', '1', '776', '2015-09-28', '5415', 'Salary Commission- September 2016', '750', '0', '0', '0', 'Salary Commission', '0'),
('2753', '1', '776', '2015-09-28', '1060', '', '-750', '0', '0', '0', 'Salary Commission', '0'),
('2754', '1', '777', '2015-11-30', '5410', 'Staff Salary payment for the month of November 2015', '3895200.66', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2755', '1', '777', '2015-11-30', '1060', '', '-3895200.66', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2756', '1', '778', '2015-11-30', '5415', 'Salary Commission- November 2015', '750', '0', '0', '0', 'Salary Commission', '0'),
('2757', '1', '778', '2015-11-30', '1060', '', '-750', '0', '0', '0', 'Salary Commission', '0'),
('2758', '1', '779', '2015-11-30', '6010', 'Overdraft Interest Charge', '600', '0', '0', '0', 'Bank Charges', '0'),
('2759', '1', '779', '2015-11-30', '1060', '', '-600', '0', '0', '0', 'Bank Charges', '0'),
('2760', '2', '163', '2015-11-06', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-1300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2761', '2', '163', '2015-11-06', '1060', '', '1300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2762', '2', '164', '2015-11-11', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2763', '2', '164', '2015-11-11', '1060', '', '300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2764', '2', '165', '2015-11-24', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-1500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2765', '2', '165', '2015-11-24', '1060', '', '1500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2766', '2', '166', '2015-11-30', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-4800000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2767', '2', '166', '2015-11-30', '1060', '', '4800000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2768', '2', '167', '2015-12-04', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-1000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2769', '2', '167', '2015-12-04', '1060', '', '1000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2770', '2', '168', '2015-12-22', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-5000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2771', '2', '168', '2015-12-22', '1060', '', '5000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2772', '1', '780', '2015-12-22', '5410', 'Staff Salary payment for the month of December 2015', '4366764.46', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2773', '1', '780', '2015-12-22', '1060', '', '-4366764.46', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2774', '1', '781', '2015-12-22', '5415', 'Salary Commission- December 2015', '750', '0', '0', '0', 'Salary Commission', '0'),
('2775', '1', '781', '2015-12-22', '1060', '', '-750', '0', '0', '0', 'Salary Commission', '0'),
('2776', '1', '782', '2015-12-17', '5690', 'Bank Charges', '500', '0', '0', '0', 'Bank Charges', '0'),
('2777', '1', '782', '2015-12-17', '1060', '', '-500', '0', '0', '0', 'Bank Charges', '0'),
('2778', '1', '783', '2016-01-20', '5690', 'Bank Charges', '500', '0', '0', '0', 'Bank Charges', '0'),
('2779', '1', '783', '2016-01-20', '1060', '', '-500', '0', '0', '0', 'Bank Charges', '0'),
('2780', '1', '784', '2016-01-27', '5410', 'Staff Salary payment for the month of January 2016', '4560767.7', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2781', '1', '784', '2016-01-27', '1060', '', '-4560767.7', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2782', '1', '785', '2016-01-27', '5415', 'Salary Commission-January 2016', '750', '0', '0', '0', 'Salary Commission', '0'),
('2783', '1', '785', '2016-01-27', '1060', '', '-750', '0', '0', '0', 'Salary Commission', '0'),
('2784', '2', '169', '2016-01-27', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2785', '2', '169', '2016-01-27', '1060', '', '0', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2786', '2', '170', '2016-01-18', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-150000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2787', '2', '170', '2016-01-18', '1060', '', '150000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2788', '2', '171', '2016-01-27', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-4600000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2789', '2', '171', '2016-01-27', '1060', '', '4600000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2790', '2', '172', '2016-01-28', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-2500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2791', '2', '172', '2016-01-28', '1060', '', '2500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2792', '1', '786', '2016-01-18', '5690', 'Annual Fee Charge for Sampath-Vishwa Online Facility', '3000', '0', '0', '0', 'Sampath - Vishwa', '0'),
('2793', '1', '786', '2016-01-18', '1060', '', '-3000', '0', '0', '0', 'Sampath - Vishwa', '0'),
('2794', '2', '173', '2016-02-16', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-100000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2795', '2', '173', '2016-02-16', '1060', '', '100000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2796', '1', '787', '2016-03-01', '5410', 'Staff Salary payment for the month of February 2016', '4476894.36', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2797', '1', '787', '2016-03-01', '1060', '', '-4476894.36', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2798', '1', '788', '2016-03-01', '5415', 'Salary Commission- February 2016', '750', '0', '0', '0', 'Salary Commission', '0'),
('2799', '1', '788', '2016-03-01', '1060', '', '-750', '0', '0', '0', 'Salary Commission', '0'),
('2800', '1', '789', '2016-03-29', '5410', 'Staff Salary payment for the month of March 2016', '4227163.55', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2801', '1', '789', '2016-03-29', '1060', '', '-4227163.55', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2802', '1', '790', '2016-03-29', '5415', 'Salary Commission- March 2016', '750', '0', '0', '0', 'Salary Commission', '0'),
('2803', '1', '790', '2016-03-29', '1060', '', '-750', '0', '0', '0', 'Salary Commission', '0'),
('2804', '2', '174', '2016-03-01', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-6000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2805', '2', '174', '2016-03-01', '1060', '', '6000000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2806', '2', '175', '2016-03-03', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2807', '2', '175', '2016-03-03', '1060', '', '300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2808', '2', '176', '2016-03-09', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2809', '2', '176', '2016-03-09', '1060', '', '300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2810', '2', '177', '2016-03-14', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2811', '2', '177', '2016-03-14', '1060', '', '300000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2812', '2', '178', '2016-03-25', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-750000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2813', '2', '178', '2016-03-25', '1060', '', '750000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2814', '2', '179', '2016-03-29', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-5500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2815', '2', '179', '2016-03-29', '1060', '', '5500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0');
INSERT INTO `1_gl_trans` VALUES
('2816', '2', '180', '2016-03-31', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-1500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2817', '2', '180', '2016-03-31', '1060', '', '1500000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2818', '1', '791', '2015-10-28', '5410', 'Staff Salary payment for the month of October 2015', '3585535', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2819', '1', '791', '2015-10-28', '1060', '', '-3585535', '0', '0', '0', 'Staff Salaries &amp; Wages', '0'),
('2820', '1', '792', '2015-10-28', '5415', 'Salary Commission- October 2015', '750', '0', '0', '0', 'Salary Commission', '0'),
('2821', '1', '792', '2015-10-28', '1060', '', '-750', '0', '0', '0', 'Salary Commission', '0'),
('2822', '2', '181', '2015-10-01', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-150000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2823', '2', '181', '2015-10-01', '1060', '', '150000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2824', '2', '182', '2015-10-05', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2825', '2', '182', '2015-10-05', '1060', '', '200000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2826', '2', '183', '2015-10-13', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-700000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2827', '2', '183', '2015-10-13', '1060', '', '700000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2828', '2', '184', '2015-10-15', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-150000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2829', '2', '184', '2015-10-15', '1060', '', '150000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2830', '2', '185', '2015-10-28', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '-4800000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2831', '2', '185', '2015-10-28', '1060', '', '4800000', '0', '0', '0', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0'),
('2832', '2', '186', '2016-03-09', '1221', 'Fund Transfer Evolve Technologies (Pvt) Ltd', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '0'),
('2833', '2', '186', '2016-03-09', '1060', '', '0', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '0'),
('2834', '4', '3', '2016-05-27', '1221', 'From Evolve Technologies (Pvt)Ltd. To Sampath Bank - Current Account', '0', '0', '0', NULL, NULL, '0'),
('2835', '0', '52', '2016-05-27', '1221', 'Exchange Variance', '-11225969429.8', '0', '0', NULL, NULL, '0'),
('2836', '0', '52', '2016-05-27', '4450', 'Exchange Variance', '11225969429.8', '0', '0', NULL, NULL, '0'),
('2837', '4', '3', '2016-05-27', '1060', 'From Evolve Technologies (Pvt)Ltd. To Sampath Bank - Current Account', '0', '0', '0', NULL, NULL, '0'),
('2838', '4', '4', '2016-05-27', '1221', 'From Evolve Technologies (Pvt)Ltd. To Sampath Bank - Current Account', '-8635475', '0', '0', NULL, NULL, '0'),
('2839', '4', '4', '2016-05-27', '1060', 'From Evolve Technologies (Pvt)Ltd. To Sampath Bank - Current Account', '8635475', '0', '0', NULL, NULL, '0'),
('2840', '1', '793', '2016-05-27', '5690', 'Bank Charges', '575', '0', '0', '0', 'Bank Charges', '0'),
('2841', '1', '793', '2016-05-27', '1060', '', '-575', '0', '0', '0', 'Bank Charges', '0'),
('2842', '1', '794', '2016-07-14', '5510', 'Staff Refreshment Expenses for the Month of June 2016', '140000', '0', '0', '0', 'Cash', '910116'),
('2843', '1', '794', '2016-07-14', '1060', '', '-140000', '0', '0', '0', 'Cash', '910116'),
('2844', '1', '795', '2016-07-14', '5440', 'Staff Medical Expenses for Mrs Jeewani Kokila Perera', '10000', '0', '0', '0', 'Jeewani Kokila Perera', '910117'),
('2845', '1', '795', '2016-07-14', '1060', '', '-10000', '0', '0', '0', 'Jeewani Kokila Perera', '910117'),
('2846', '1', '796', '2016-07-14', '1820', 'Purchased 05Qty of BENQ- Monitor LED 21.5&quot; with 36 Months Warrenty', '101250', '0', '0', '0', 'Tech Information Solution (PVT) Ltd', '910118'),
('2847', '1', '796', '2016-07-14', '1060', '', '-101250', '0', '0', '0', 'Tech Information Solution (PVT) Ltd', '910118'),
('2848', '2', '187', '2016-03-09', '1200', 'Cash Reversal against for the received customer payment from Schockman &amp; Samarawickrema (Pvt) Ltd', '0', '0', '0', '0', 'Schockman &amp; Samarawickrema (Pvt) Ltd', '0'),
('2849', '2', '187', '2016-03-09', '1060', '', '0', '0', '0', '0', 'Schockman &amp; Samarawickrema (Pvt) Ltd', '0'),
('2850', '1', '797', '2016-07-14', '2160', 'P.A.Y.E for the month of June 2016 (114725374 03 16060)', '181149', '0', '0', '4', '6', '910119'),
('2851', '1', '797', '2016-07-14', '1060', '', '-181149', '0', '0', '4', '6', '910119'),
('2852', '1', '798', '2016-07-20', '5780', 'ADSL Connection Charge', '12500', '0', '0', '0', 'Cash', '910120'),
('2853', '1', '798', '2016-07-20', '5695', 'Expenses for Scott &amp; Jey&#039;s Visit', '114500', '0', '0', '0', 'Cash', '910120'),
('2854', '1', '798', '2016-07-20', '5511', 'Staff Training Expenses', '135000', '0', '0', '0', 'Cash', '910120'),
('2855', '1', '798', '2016-07-20', '1060', '', '-262000', '0', '0', '0', 'Cash', '910120'),
('2856', '1', '799', '2016-07-22', '5410', 'Staff Salary Advance for the month of July 2016 ( To be Deducted in Two Month as in 10,000/= Installment each )', '20000', '0', '0', '0', 'Uddeshika Jayawardhane', '910121'),
('2857', '1', '799', '2016-07-22', '1060', '', '-20000', '0', '0', '0', 'Uddeshika Jayawardhane', '910121'),
('2858', '1', '800', '2016-07-22', '5470', 'Staff Traveling expenses For The Month of June 2016', '701124.75', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '910122'),
('2859', '1', '800', '2016-07-22', '1060', '', '-701124.75', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '910122'),
('2860', '1', '801', '2016-07-26', '5440', 'Staff Medical Expenses for Mr Amila Palihawadana', '7192', '0', '0', '0', 'Amila Palihawadana', '910123'),
('2861', '1', '801', '2016-07-26', '1060', '', '-7192', '0', '0', '0', 'Amila Palihawadana', '910123'),
('2862', '2', '188', '2016-01-25', '5440', 'CHQ Receivable from Ceylinco General Insurance Ltd', '-9965.58', '0', '0', '0', 'Involve 360 (pvt) Ltd', '0'),
('2863', '2', '188', '2016-01-25', '1060', 'Seylan Bank 968258', '9965.58', '0', '0', '0', 'Involve 360 (pvt) Ltd', '0'),
('2864', '1', '802', '2015-09-29', '1810', 'Purchase of Furniture &amp; Fittings (Involve 360 PVT Ltd)', '0', '0', '0', '0', 'Leema Creations (Pvt)Ltd.', '554593'),
('2865', '1', '802', '2015-09-29', '1060', '', '0', '0', '0', '0', 'Leema Creations (Pvt)Ltd.', '554593'),
('2866', '0', '53', '2015-04-01', '5460', 'Employees Trust Fund for the month of March 2015', '-85500', '0', '0', NULL, NULL, '0'),
('2867', '0', '53', '2015-04-01', '5450', 'The Superientendent - Employees Provident Fund for the month of March 2015', '-570000', '0', '0', NULL, NULL, '0'),
('2868', '0', '53', '2015-04-01', '5470', 'Staff Travelling Expenses-Casons Taxi Company (PVT) LTD month of March 2015', '-518957', '0', '0', NULL, NULL, '0'),
('2869', '0', '53', '2015-04-01', '5510', 'Staff Refreshment expenses For the Month Of March 2015', '-140000', '0', '0', NULL, NULL, '0'),
('2870', '0', '53', '2015-04-01', '2110', 'Accrued Charges for the month of march 2015', '1314457', '0', '0', NULL, NULL, '0'),
('2871', '0', '54', '2016-03-31', '5450', 'The Superientendent - Employees Provident Fund Settlement for the month of March 2016', '829200', '0', '0', NULL, NULL, '0'),
('2872', '0', '54', '2016-03-31', '5460', 'Employees Trust fund settlement for the month of March 2016', '124380', '0', '0', NULL, NULL, '0'),
('2873', '0', '54', '2016-03-31', '5470', 'Staff tavelling expenses For The Month of March 2016', '643974.05', '0', '0', NULL, NULL, '0'),
('2874', '0', '54', '2016-03-31', '5510', 'Staff Refreshment expenses For the Month Of March 2016', '140000', '0', '0', NULL, NULL, '0'),
('2875', '0', '54', '2016-03-31', '2110', 'Accrued Charges for the month of march 2016', '-1737554.05', '0', '0', NULL, NULL, '0'),
('2876', '0', '55', '2016-03-31', '5410', 'Loan deductions - Uddeshika', '80000', '0', '0', NULL, NULL, '0'),
('2877', '0', '55', '2016-03-31', '5521', 'Loan deductions - Uddeshika', '-80000', '0', '0', NULL, NULL, '0'),
('2878', '0', '56', '2016-03-31', '5410', 'PAYE  deduction for the year 2016', '1451968.09', '0', '0', NULL, NULL, '0'),
('2879', '0', '56', '2016-03-31', '2160', 'PAYE  deduction for the year 2016', '-1451968.09', '0', '0', NULL, NULL, '0'),
('2880', '0', '57', '2016-03-31', '5760', 'Rent from April to December 2015', '1800000', '0', '0', NULL, NULL, '0'),
('2881', '0', '57', '2016-03-31', '1220', 'Rent from April to December 2015', '-1800000', '0', '0', NULL, NULL, '0'),
('2882', '0', '58', '2016-03-31', '5465', 'Grtuity provision -2016', '163868', '0', '0', NULL, NULL, '0'),
('2883', '0', '58', '2016-03-31', '2140', 'Grtuity provision -2016', '-163868', '0', '0', NULL, NULL, '0'),
('2884', '1', '803', '2016-07-28', '5460', 'Employees Trust fund settlement for the Month of June 2016', '141240', '0', '0', '4', '5', '910124'),
('2885', '1', '803', '2016-07-28', '1060', '', '-141240', '0', '0', '4', '5', '910124'),
('2886', '1', '804', '2016-07-28', '5450', 'The Superientendent - Employees Provident Fund Settlement for the Month of June 2016', '941600', '0', '0', '4', '4', '910125'),
('2887', '1', '804', '2016-07-28', '1060', '', '-941600', '0', '0', '4', '4', '910125'),
('2888', '0', '59', '2015-03-31', '5850', 'Depreciation for the year 2015', '0', '0', '0', NULL, NULL, '0'),
('2889', '0', '59', '2015-03-31', '1820', 'Depreciation for the year 2015', '0', '0', '0', NULL, NULL, '0'),
('2890', '0', '60', '2015-03-31', '5465', 'Gratuity provision for the year 2015', '86938', '0', '0', NULL, NULL, '0'),
('2891', '0', '60', '2015-03-31', '2140', 'Gratuity provision for the year 2015', '-86938', '0', '0', NULL, NULL, '0'),
('2892', '0', '59', '2015-03-31', '5850', 'Depreciation for the year 2015', '0', '0', '0', NULL, NULL, '0'),
('2893', '0', '59', '2015-03-31', '1820', 'Depreciation for the year 2015', '0', '0', '0', NULL, NULL, '0'),
('2894', '0', '59', '2015-03-31', '5850', 'Depreciation for the year 2015', '135503', '0', '0', NULL, NULL, '0'),
('2895', '0', '59', '2015-03-31', '1825', 'Depreciation for the year 2015', '-135503', '0', '0', NULL, NULL, '0'),
('2896', '1', '805', '2016-08-03', '5780', 'Telephone And Internet expenses for Month of June 2016 ( ES00002794 - In No 21706041 )', '230908', '0', '0', '0', 'Dialog Broadband Networks (Pvt) Ltd', '910126'),
('2897', '1', '805', '2016-08-03', '1060', '', '-230908', '0', '0', '0', 'Dialog Broadband Networks (Pvt) Ltd', '910126'),
('2898', '1', '806', '2016-08-03', '5780', 'Telephone &amp; Internet Expenses for the Month of June 2016', '171225.34', '0', '0', '0', 'Tata Communications Lanka Ltd', '910127'),
('2899', '1', '806', '2016-08-03', '1060', '', '-171225.34', '0', '0', '0', 'Tata Communications Lanka Ltd', '910127'),
('2900', '1', '807', '2016-08-03', '2140', 'Gratuity Provision Payment for April, May &amp; June 2016', '610334', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '910128'),
('2901', '1', '807', '2016-08-03', '1060', '', '-610334', '0', '0', '0', 'Evolve Technologies (Pvt) Ltd', '910128'),
('2902', '2', '189', '2016-08-03', '4460', 'Disposal Assets Sales Revenuve-CHQ 023207', '-86379.19', '0', '0', '0', 'Schockman &amp; Samarawickrema (Pvt) Ltd', '0'),
('2903', '2', '189', '2016-08-03', '4460', 'Disposal Assets Sales Revenuve-CHQ 029352', '-44498.7', '0', '0', '0', 'Schockman &amp; Samarawickrema (Pvt) Ltd', '0'),
('2904', '2', '189', '2016-08-03', '1060', '', '130877.89', '0', '0', '0', 'Schockman &amp; Samarawickrema (Pvt) Ltd', '0'),
('2905', '1', '808', '2016-08-03', '4460', 'Disposal of Assets-Schocman &amp; Samarawickreme', '130877.89', '0', '0', '0', 'Cash', '910129'),
('2906', '1', '808', '2016-08-03', '1060', '', '-130877.89', '0', '0', '0', 'Cash', '910129'),
('2907', '1', '809', '2016-08-18', '2160', 'P.A.Y.E Settlement', '0', '0', '0', '4', '6', '925092'),
('2908', '1', '809', '2016-08-18', '1060', '', '0', '0', '0', '4', '6', '925092'),
('2909', '1', '810', '2016-08-18', '2160', 'P.A.Y.E Settlement', '170867', '0', '0', '4', '6', '910130'),
('2910', '1', '810', '2016-08-18', '1060', '', '-170867', '0', '0', '4', '6', '910130'),
('2911', '1', '811', '2016-08-18', '5510', 'Staff Refreshment Expenses for the Month of July 2016', '140000', '0', '0', '0', 'Cash', '910131'),
('2912', '1', '811', '2016-08-18', '1060', '', '-140000', '0', '0', '0', 'Cash', '910131'),
('2913', '1', '812', '2016-08-19', '5812', 'ISO Consultancy Fee ', '84915', '0', '0', '0', 'E-guardian Lanka Private Limited ', '910132'),
('2914', '1', '812', '2016-08-19', '1060', '', '-84915', '0', '0', '0', 'E-guardian Lanka Private Limited ', '910132'),
('2915', '1', '813', '2016-08-19', '5780', 'ADSL Connection Charge', '12500', '0', '0', '0', 'Cash', '910133'),
('2916', '1', '813', '2016-08-19', '5410', 'Pay in Lieu of Notice', '25000', '0', '0', '0', 'Cash', '910133'),
('2917', '1', '813', '2016-08-19', '5511', 'Staff Training Expenses', '270000', '0', '0', '0', 'Cash', '910133'),
('2918', '1', '813', '2016-08-19', '1060', '', '-307500', '0', '0', '0', 'Cash', '910133'),
('2919', '1', '814', '2016-08-22', '5440', 'Staff Medical Expenses for Mr.E M Hemal Isuru', '10000', '0', '0', '0', 'E M Hemal Isuru', '910134'),
('2920', '1', '814', '2016-08-22', '1060', '', '-10000', '0', '0', '0', 'E M Hemal Isuru', '910134'),
('2921', '1', '815', '2016-08-26', '5470', 'Staff Traveling expenses For The Month of July 2016', '664973.85', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '910135'),
('2922', '1', '815', '2016-08-26', '1060', '', '-664973.85', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd', '910135'),
('2923', '1', '816', '2016-08-29', '5450', 'The Superientendent - Employees Provident Fund Settlement for the Month of July 2016', '985950', '0', '0', '4', '4', '910136'),
('2924', '1', '816', '2016-08-29', '1060', '', '-985950', '0', '0', '4', '4', '910136'),
('2925', '1', '817', '2016-08-29', '5460', 'Employees Trust fund settlement for the Month of July 2016', '147893', '0', '0', '4', '5', '910137'),
('2926', '1', '817', '2016-08-29', '1060', '', '-147893', '0', '0', '4', '5', '910137'),
('2927', '1', '818', '2016-09-06', '5510', 'Associated Costs for Air Tickets &amp; Documations for Mr Bershan &amp; Dylan (Visit to US &amp; Australia)', '403615.76', '0', '0', '0', 'Cash', '910138'),
('2928', '1', '818', '2016-09-06', '1060', '', '-403615.76', '0', '0', '0', 'Cash', '910138'),
('2929', '2', '190', '2016-03-09', '4460', 'Cash Reversal against for the received customer payment from Schockman &amp; Samarawickrema (Pvt) Ltd', '-173505.53', '0', '0', '0', 'Schockman &amp; Samarawickrema (Pvt) Ltd', '0'),
('2930', '2', '190', '2016-03-09', '1060', '', '173505.53', '0', '0', '0', 'Schockman &amp; Samarawickrema (Pvt) Ltd', '0'),
('2931', '1', '819', '2016-03-09', '5510', 'cash reversal against for the received customer payment from Schockman &amp; Samarawickrema (Pvt) Ltd', '173505.53', '0', '0', '0', 'Chanaka Padmaperuma', '870774'),
('2932', '1', '819', '2016-03-09', '1060', '', '-173505.53', '0', '0', '0', 'Chanaka Padmaperuma', '870774'),
('2933', '1', '820', '2016-09-07', '5780', 'Telephone And Internet expenses for Month of July 2016 ( ES00002794 )', '197609.5', '0', '0', '0', 'Dialog Broadband Networks (Pvt) Ltd', '910139'),
('2934', '1', '820', '2016-09-07', '1060', '', '-197609.5', '0', '0', '0', 'Dialog Broadband Networks (Pvt) Ltd', '910139'),
('2935', '1', '821', '2016-09-07', '5780', 'Telephone &amp; Internet Expenses for the Month of July 2016', '145977.93', '0', '0', '0', 'Tata Communications Lanka Ltd', '910140'),
('2936', '1', '821', '2016-09-07', '1060', '', '-145977.93', '0', '0', '0', 'Tata Communications Lanka Ltd', '910140'),
('2937', '1', '822', '2016-09-07', '5440', 'Staff Medical Expenses for Mr Shiyam Kamal', '10000', '0', '0', '0', 'Shiyam Kamal', '910141'),
('2938', '1', '822', '2016-09-07', '1060', '', '-10000', '0', '0', '0', 'Shiyam Kamal', '910141'),
('2939', '0', '51', '2014-04-01', '5465', 'Gratuity Provision for the year', '445254', '0', '0', NULL, NULL, '0'),
('2940', '0', '51', '2014-04-01', '2140', 'Gratuity Provision for the year', '-445254', '0', '0', NULL, NULL, '0'),
('2941', '0', '61', '2015-03-31', '5610', 'Audit fees payable ', '62500', '0', '0', NULL, NULL, '0'),
('2942', '0', '61', '2015-03-31', '2120', 'Audit fees payable ', '-62500', '0', '0', NULL, NULL, '0'),
('2943', '0', '62', '2015-03-31', '3590', 'Closing Year', '427344', '0', '0', NULL, NULL, '0'),
('2944', '0', '62', '2015-03-31', '9990', 'Closing Year', '-427344', '0', '0', NULL, NULL, '0'),
('2945', '0', '63', '2016-03-31', '1200', 'Beeing settlement of current a/c', '355206', '0', '0', NULL, NULL, '0'),
('2946', '0', '63', '2016-03-31', '1230', 'Beeing settlement of current a/c', '-343400', '0', '0', NULL, NULL, '0'),
('2947', '0', '63', '2016-03-31', '4450', 'Beeing settlement of current a/c', '-11806', '0', '0', NULL, NULL, '0'),
('2948', '0', '64', '2016-03-31', '5410', 'Employees contribution to EPF for 2016', '3456558', '0', '0', NULL, NULL, '0'),
('2949', '0', '64', '2016-03-31', '5450', 'Employees contribution to EPF for 2016', '-3456558', '0', '0', NULL, NULL, '0'),
('2950', '12', '75', '2015-05-25', '1221', '', '0', '0', '0', '2', '2', '0'),
('2951', '1', '823', '2016-09-13', '5510', 'Staff Refreshment Expenses for the Month of August 2016', '140000', '0', '0', '0', 'Cash', '910142'),
('2952', '1', '823', '2016-09-13', '1060', '', '-140000', '0', '0', '0', 'Cash', '910142'),
('2953', '1', '824', '2016-09-13', '5440', 'Staff Medical Expenses for Mr.Amila Palihawadana', '2562', '0', '0', '0', 'Amila Palihawadana', '910143'),
('2954', '1', '824', '2016-09-13', '1060', '', '-2562', '0', '0', '0', 'Amila Palihawadana', '910143'),
('2955', '12', '76', '2015-06-25', '1221', '', '0', '0', '0', '2', '2', '0'),
('2956', '12', '91', '2015-06-25', '1221', '', '0', '0', '0', '2', '2', '0'),
('2957', '12', '91', '2015-06-25', '1200', '', '0', '0', '0', '2', '2', '0'),
('2958', '12', '91', '2015-06-25', '1200', 'Sales Invoice 83', '0', '0', '0', '2', '2', '0'),
('2959', '12', '91', '2015-06-25', '4450', 'Sales Invoice 83', '0', '0', '0', '2', '2', '0'),
('2960', '12', '92', '2015-05-25', '1221', '', '0', '0', '0', '2', '2', '0'),
('2961', '12', '92', '2015-05-25', '1200', '', '0', '0', '0', '2', '2', '0'),
('2962', '12', '92', '2016-09-19', '1200', 'Sales Invoice 82', '0', '0', '0', '2', '2', '0'),
('2963', '12', '92', '2016-09-19', '4450', 'Sales Invoice 82', '0', '0', '0', '2', '2', '0'),
('2964', '12', '91', '2015-06-25', '1221', '', '0', '0', '0', '2', '2', '0'),
('2965', '12', '91', '2015-06-25', '1200', '', '0', '0', '0', '2', '2', '0'),
('2966', '12', '91', '2015-06-25', '1200', 'Sales Invoice 83', '0', '0', '0', '2', '2', '0'),
('2967', '12', '91', '2015-06-25', '4450', 'Sales Invoice 83', '0', '0', '0', '2', '2', '0'),
('2968', '12', '77', '2015-07-27', '1221', '', '0', '0', '0', '2', '2', '0'),
('2969', '12', '77', '2015-07-27', '1200', '', '0', '0', '0', '2', '2', '0'),
('2970', '12', '77', '2015-07-27', '1200', 'Sales Invoice 84', '0', '0', '0', '2', '2', '0'),
('2971', '12', '77', '2015-07-27', '4450', 'Sales Invoice 84', '0', '0', '0', '2', '2', '0'),
('2972', '12', '78', '2015-08-26', '1221', '', '0', '0', '0', '2', '2', '0'),
('2973', '12', '78', '2015-08-26', '1200', '', '0', '0', '0', '2', '2', '0'),
('2974', '12', '78', '2015-08-26', '1200', 'Sales Invoice 85', '0', '0', '0', '2', '2', '0'),
('2975', '12', '78', '2015-08-26', '4450', 'Sales Invoice 85', '0', '0', '0', '2', '2', '0'),
('2976', '12', '79', '2015-09-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2977', '12', '79', '2015-09-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2978', '12', '79', '2015-09-28', '1200', 'Sales Invoice 86', '0', '0', '0', '2', '2', '0'),
('2979', '12', '79', '2015-09-28', '4450', 'Sales Invoice 86', '0', '0', '0', '2', '2', '0'),
('2980', '12', '80', '2015-10-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2981', '12', '80', '2015-10-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2982', '12', '80', '2015-10-28', '1200', 'Sales Invoice 87', '0', '0', '0', '2', '2', '0'),
('2983', '12', '80', '2015-10-28', '4450', 'Sales Invoice 87', '0', '0', '0', '2', '2', '0'),
('2984', '12', '80', '2015-10-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('2985', '12', '80', '2015-10-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('2986', '12', '80', '2015-10-28', '1200', 'Sales Invoice 87', '0', '0', '0', '2', '2', '0'),
('2987', '12', '80', '2015-10-28', '4450', 'Sales Invoice 87', '0', '0', '0', '2', '2', '0'),
('2988', '12', '81', '2015-11-26', '1221', '', '0', '0', '0', '2', '2', '0'),
('2989', '12', '81', '2015-11-26', '1200', '', '0', '0', '0', '2', '2', '0'),
('2990', '12', '81', '2015-11-26', '1200', 'Sales Invoice 88', '0', '0', '0', '2', '2', '0'),
('2991', '12', '81', '2015-11-26', '4450', 'Sales Invoice 88', '0', '0', '0', '2', '2', '0'),
('2992', '12', '82', '2015-12-23', '1221', '', '0', '0', '0', '2', '2', '0'),
('2993', '12', '82', '2015-12-23', '1200', '', '0', '0', '0', '2', '2', '0'),
('2994', '12', '82', '2015-12-23', '1200', 'Sales Invoice 89', '0', '0', '0', '2', '2', '0'),
('2995', '12', '82', '2015-12-23', '4450', 'Sales Invoice 89', '0', '0', '0', '2', '2', '0'),
('2996', '12', '83', '2016-01-27', '1221', '', '0', '0', '0', '2', '2', '0'),
('2997', '12', '83', '2016-01-27', '1200', '', '0', '0', '0', '2', '2', '0'),
('2998', '12', '83', '2016-01-27', '1200', 'Sales Invoice 90', '0', '0', '0', '2', '2', '0'),
('2999', '12', '83', '2016-01-27', '4450', 'Sales Invoice 90', '0', '0', '0', '2', '2', '0'),
('3000', '12', '84', '2016-03-01', '1221', '', '0', '0', '0', '2', '2', '0'),
('3001', '12', '84', '2016-03-01', '1200', '', '0', '0', '0', '2', '2', '0'),
('3002', '12', '84', '2016-03-01', '1200', 'Sales Invoice 91', '0', '0', '0', '2', '2', '0'),
('3003', '12', '84', '2016-03-01', '4450', 'Sales Invoice 91', '0', '0', '0', '2', '2', '0'),
('3004', '12', '85', '2016-03-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('3005', '12', '85', '2016-03-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('3006', '12', '85', '2016-03-28', '1200', 'Sales Invoice 92', '0', '0', '0', '2', '2', '0'),
('3007', '12', '85', '2016-03-28', '4450', 'Sales Invoice 92', '0', '0', '0', '2', '2', '0'),
('3008', '0', '65', '2015-04-06', '5610', 'Audit Fee Settlement', '27500', '0', '0', NULL, NULL, '0'),
('3009', '0', '65', '2015-04-06', '1221', 'Audit Fee Settlement', '-27500', '0', '0', NULL, NULL, '0'),
('3010', '0', '66', '2015-09-28', '1221', 'Salary Payment for the month of September 2015-Mr Shaaroon Nadarajah', '-101173.81', '0', '0', NULL, NULL, '0'),
('3011', '0', '66', '2015-09-28', '5410', 'Salary Payment for the month of September 2015-Mr Shaaroon Nadarajah', '101173.81', '0', '0', NULL, NULL, '0'),
('3012', '0', '67', '2015-09-29', '1221', 'Payment for Purchased of Furniture&#039;s- Leema Creations', '-775000', '0', '0', NULL, NULL, '0'),
('3013', '0', '67', '2015-09-29', '1810', 'Payment for Purchased of Furniture&#039;s- Leema Creations', '775000', '0', '0', NULL, NULL, '0'),
('3014', '1', '825', '2016-09-19', '5440', 'Staff Medical Expenses for Mr.Mallcolm Mahesh', '9321', '0', '0', '0', 'Mallcolm Mahesh', '910144'),
('3015', '1', '825', '2016-09-19', '1060', '', '-9321', '0', '0', '0', 'Mallcolm Mahesh', '910144'),
('3016', '1', '826', '2016-09-22', '5780', 'ADSL Connection Fee', '37500', '0', '0', '0', 'Cash', '910145'),
('3017', '1', '826', '2016-09-22', '5765', 'Office Maintenance Fee March/April/May/June 2016', '250000', '0', '0', '0', 'Cash', '910145'),
('3018', '1', '826', '2016-09-22', '5511', 'Events Handling Fee', '500000', '0', '0', '0', 'Cash', '910145'),
('3019', '1', '826', '2016-09-22', '1060', '', '-787500', '0', '0', '0', 'Cash', '910145'),
('3020', '1', '827', '2016-09-23', '2160', 'P.A.Y.E for the month of August 2016 (114725374 03 16060)', '171617', '0', '0', '4', '6', '910146'),
('3021', '1', '827', '2016-09-23', '1060', '', '-171617', '0', '0', '4', '6', '910146'),
('3022', '1', '828', '2016-09-26', '5470', 'Staff Traveling expenses For The Month of August 2016', '657107.15', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd	', '910147'),
('3023', '1', '828', '2016-09-26', '1060', '', '-657107.15', '0', '0', '0', 'Casons Taxi Company (Pvt) Ltd	', '910147'),
('3024', '1', '829', '2016-09-28', '5410', 'Salary Increment Settled for the month of September 2016', '15000', '0', '0', '0', 'Hemal Ekanayake', '910148'),
('3025', '1', '829', '2016-09-28', '1060', '', '-15000', '0', '0', '0', 'Hemal Ekanayake', '910148'),
('3026', '1', '830', '2016-09-28', '5410', 'Salary Increment Settled fro the Month of September 2016', '13500', '0', '0', '0', 'Sandun Gamage', '910149'),
('3027', '1', '830', '2016-09-28', '1060', '', '-13500', '0', '0', '0', 'Sandun Gamage', '910149'),
('3028', '1', '831', '2016-09-28', '5410', 'Salary Increment Settled fro the Month of September 2016	', '10000', '0', '0', '0', 'Angela Roncali', '910150'),
('3029', '1', '831', '2016-09-28', '1060', '', '-10000', '0', '0', '0', 'Angela Roncali', '910150'),
('3030', '1', '832', '2016-09-28', '5410', 'Salary Increment Settled fro the Month of August &amp; September 2016	', '55000', '0', '0', '0', 'Mallcolm Mahesh', '946201'),
('3031', '1', '832', '2016-09-28', '1060', '', '-55000', '0', '0', '0', 'Mallcolm Mahesh', '946201'),
('3032', '10', '95', '2015-04-20', '4010', '', '-5311828.14', '0', '0', '2', '2', '0'),
('3033', '10', '95', '2015-04-20', '1200', '', '5311828.14', '0', '0', '2', '2', '0'),
('3034', '10', '96', '2015-05-20', '4010', '', '-6329047.3', '0', '0', '2', '2', '0'),
('3035', '10', '96', '2015-05-20', '1200', '', '6329047.3', '0', '0', '2', '2', '0'),
('3036', '10', '97', '2015-06-20', '4010', '', '-5891640.79', '0', '0', '2', '2', '0'),
('3037', '10', '97', '2015-06-20', '1200', '', '5891640.79', '0', '0', '2', '2', '0'),
('3038', '10', '98', '2015-07-20', '4010', '', '-6091420.25', '0', '0', '2', '2', '0'),
('3039', '10', '98', '2015-07-20', '1200', '', '6091420.25', '0', '0', '2', '2', '0'),
('3040', '10', '99', '2015-08-20', '4010', '', '-5832372.02', '0', '0', '2', '2', '0'),
('3041', '10', '99', '2015-08-20', '1200', '', '5832372.02', '0', '0', '2', '2', '0'),
('3042', '10', '100', '2015-09-20', '4010', '', '-5770051.04', '0', '0', '2', '2', '0'),
('3043', '10', '100', '2015-09-20', '1200', '', '5770051.04', '0', '0', '2', '2', '0'),
('3044', '12', '79', '2015-09-28', '1200', 'Sales Invoice 100', '0', '0', '0', '2', '2', '0'),
('3045', '12', '79', '2015-09-28', '4450', 'Sales Invoice 100', '0', '0', '0', '2', '2', '0'),
('3046', '10', '101', '2015-10-20', '4010', '', '-5935813.71', '0', '0', '2', '2', '0'),
('3047', '10', '101', '2015-10-20', '1200', '', '5935813.71', '0', '0', '2', '2', '0'),
('3048', '12', '80', '2015-10-28', '1200', 'Sales Invoice 101', '0', '0', '0', '2', '2', '0'),
('3049', '12', '80', '2015-10-28', '4450', 'Sales Invoice 101', '0', '0', '0', '2', '2', '0'),
('3050', '10', '102', '2015-11-20', '4010', '', '-6691634.33', '0', '0', '2', '2', '0'),
('3051', '10', '102', '2015-11-20', '1200', '', '6691634.33', '0', '0', '2', '2', '0'),
('3052', '10', '103', '2015-12-20', '4010', '', '-7004366.5', '0', '0', '2', '2', '0'),
('3053', '10', '103', '2015-12-20', '1200', '', '7004366.5', '0', '0', '2', '2', '0'),
('3054', '10', '104', '2016-01-20', '4010', '', '0', '0', '0', '2', '2', '0'),
('3055', '10', '104', '2016-01-20', '1200', '', '0', '0', '0', '2', '2', '0'),
('3056', '10', '105', '2016-02-20', '4010', '', '-7531395.98', '0', '0', '2', '2', '0'),
('3057', '10', '105', '2016-02-20', '1200', '', '7531395.98', '0', '0', '2', '2', '0'),
('3058', '12', '84', '2016-03-01', '1200', 'Sales Invoice 105', '0', '0', '0', '2', '2', '0'),
('3059', '12', '84', '2016-03-01', '4450', 'Sales Invoice 105', '0', '0', '0', '2', '2', '0'),
('3060', '10', '106', '2016-03-20', '4010', '', '-6886239.67', '0', '0', '2', '2', '0'),
('3061', '10', '106', '2016-03-20', '1200', '', '6886239.67', '0', '0', '2', '2', '0'),
('3062', '12', '91', '2015-06-25', '1221', '', '0', '0', '0', '2', '2', '0'),
('3063', '12', '91', '2015-06-25', '1200', '', '0', '0', '0', '2', '2', '0'),
('3064', '12', '77', '2015-07-27', '1221', '', '0', '0', '0', '2', '2', '0'),
('3065', '12', '77', '2015-07-27', '1200', '', '0', '0', '0', '2', '2', '0'),
('3066', '12', '74', '2015-04-28', '1221', '', '5311828.14', '0', '0', '2', '2', '0'),
('3067', '12', '74', '2015-04-28', '1200', '', '-5311828.14', '0', '0', '2', '2', '0'),
('3068', '12', '92', '2015-05-25', '1221', '', '6329047.3', '0', '0', '2', '2', '0'),
('3069', '12', '92', '2015-05-25', '1200', '', '-6329047.3', '0', '0', '2', '2', '0'),
('3070', '12', '91', '2015-06-25', '1221', '', '5891640.79', '0', '0', '2', '2', '0'),
('3071', '12', '91', '2015-06-25', '1200', '', '-5891640.79', '0', '0', '2', '2', '0'),
('3072', '12', '77', '2015-07-27', '1221', '', '6091420.25', '0', '0', '2', '2', '0'),
('3073', '12', '77', '2015-07-27', '1200', '', '-6091420.25', '0', '0', '2', '2', '0'),
('3074', '12', '78', '2015-08-26', '1221', '', '5832372.02', '0', '0', '2', '2', '0'),
('3075', '12', '78', '2015-08-26', '1200', '', '-5832372.02', '0', '0', '2', '2', '0'),
('3076', '12', '79', '2015-09-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('3077', '12', '79', '2015-09-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('3078', '12', '79', '2015-09-28', '1200', 'Sales Invoice 100', '0', '0', '0', '2', '2', '0'),
('3079', '12', '79', '2015-09-28', '4450', 'Sales Invoice 100', '0', '0', '0', '2', '2', '0'),
('3080', '12', '79', '2015-09-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('3081', '12', '79', '2015-09-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('3082', '12', '79', '2015-09-28', '1200', 'Sales Invoice 100', '0', '0', '0', '2', '2', '0'),
('3083', '12', '79', '2015-09-28', '4450', 'Sales Invoice 100', '0', '0', '0', '2', '2', '0'),
('3084', '12', '80', '2015-10-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('3085', '12', '80', '2015-10-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('3086', '12', '80', '2015-10-28', '1200', 'Sales Invoice 101', '0', '0', '0', '2', '2', '0'),
('3087', '12', '80', '2015-10-28', '4450', 'Sales Invoice 101', '0', '0', '0', '2', '2', '0'),
('3088', '12', '81', '2015-11-26', '1221', '', '6691634.33', '0', '0', '2', '2', '0'),
('3089', '12', '81', '2015-11-26', '1200', '', '-6691634.33', '0', '0', '2', '2', '0'),
('3090', '12', '82', '2015-12-23', '1221', '', '7004366.5', '0', '0', '2', '2', '0'),
('3091', '12', '82', '2015-12-23', '1200', '', '-7004366.5', '0', '0', '2', '2', '0'),
('3092', '12', '83', '2016-01-27', '1221', '', '0', '0', '0', '2', '2', '0'),
('3093', '12', '83', '2016-01-27', '1200', '', '0', '0', '0', '2', '2', '0'),
('3094', '12', '83', '2016-01-27', '1221', '', '0', '0', '0', '2', '2', '0'),
('3095', '12', '83', '2016-01-27', '1200', '', '0', '0', '0', '2', '2', '0'),
('3096', '12', '84', '2016-03-01', '1221', '', '0', '0', '0', '2', '2', '0'),
('3097', '12', '84', '2016-03-01', '1200', '', '0', '0', '0', '2', '2', '0'),
('3098', '12', '84', '2016-03-01', '1200', 'Sales Invoice 105', '0', '0', '0', '2', '2', '0'),
('3099', '12', '84', '2016-03-01', '4450', 'Sales Invoice 105', '0', '0', '0', '2', '2', '0'),
('3100', '12', '84', '2016-03-01', '1221', '', '7395432.92', '0', '0', '2', '2', '0'),
('3101', '12', '84', '2016-03-01', '1200', '', '-7395432.92', '0', '0', '2', '2', '0'),
('3102', '12', '84', '2016-03-01', '1200', 'Sales Invoice 105', '-135963.06', '0', '0', '2', '2', '0'),
('3103', '12', '84', '2016-03-01', '4450', 'Sales Invoice 105', '135963.06', '0', '0', '2', '2', '0'),
('3104', '12', '85', '2016-03-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('3105', '12', '85', '2016-03-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('3106', '12', '80', '2015-10-28', '1221', '', '0', '0', '0', '2', '2', '0'),
('3107', '12', '80', '2015-10-28', '1200', '', '0', '0', '0', '2', '2', '0'),
('3108', '12', '80', '2015-10-28', '1200', 'Sales Invoice 101', '0', '0', '0', '2', '2', '0'),
('3109', '12', '80', '2015-10-28', '4450', 'Sales Invoice 101', '0', '0', '0', '2', '2', '0'),
('3110', '12', '85', '2016-03-28', '1221', '', '6886239.67', '0', '0', '2', '2', '0'),
('3111', '12', '85', '2016-03-28', '1200', '', '-6886239.67', '0', '0', '2', '2', '0'),
('3112', '12', '79', '2015-09-28', '1221', '', '5908754.19', '0', '0', '2', '2', '0'),
('3113', '12', '79', '2015-09-28', '1200', '', '-5908754.19', '0', '0', '2', '2', '0'),
('3114', '12', '79', '2015-09-28', '1200', 'Sales Invoice 100', '138703.15', '0', '0', '2', '2', '0'),
('3115', '12', '79', '2015-09-28', '4450', 'Sales Invoice 100', '-138703.15', '0', '0', '2', '2', '0'),
('3116', '12', '80', '2015-10-28', '1221', '', '5981795.37', '0', '0', '2', '2', '0'),
('3117', '12', '80', '2015-10-28', '1200', '', '-5981795.37', '0', '0', '2', '2', '0'),
('3118', '12', '80', '2015-10-28', '1200', 'Sales Invoice 101', '45981.66', '0', '0', '2', '2', '0'),
('3119', '12', '80', '2015-10-28', '4450', 'Sales Invoice 101', '-45981.66', '0', '0', '2', '2', '0'),
('3120', '1', '833', '2016-09-30', '5460', 'Employees Trust fund Settlement for the month of August 2016', '157043', '0', '0', '4', '5', '946202'),
('3121', '1', '833', '2016-09-30', '1060', '', '-157043', '0', '0', '4', '5', '946202'),
('3122', '1', '834', '2016-09-30', '5450', 'The Superientendent - Employees Provident Fund Settlement for the Month of August 2016', '1046950', '0', '0', '4', '4', '946203'),
('3123', '1', '834', '2016-09-30', '1060', '', '-1046950', '0', '0', '4', '4', '946203'),
('3124', '1', '835', '2016-09-30', '5410', 'Staff Salary Payment for The Month of September 2016', '55200', '0', '0', '0', 'Sanka Liyanage', '946204'),
('3125', '1', '835', '2016-09-30', '1060', '', '-55200', '0', '0', '0', 'Sanka Liyanage', '946204'),
('3126', '10', '107', '2016-01-20', '4010', '', '-4291035.98', '0', '0', '2', '2', '0'),
('3127', '10', '107', '2016-01-20', '1200', '', '4291035.98', '0', '0', '2', '2', '0'),
('3128', '12', '93', '2016-01-27', '1221', '', '4291035.98', '0', '0', '2', '2', '0'),
('3129', '12', '93', '2016-01-27', '1200', '', '-4291035.98', '0', '0', '2', '2', '0'),
('3130', '1', '836', '2016-10-03', '5511', 'Consultancy Charges for Demonstration &amp; Refilling Charges ', '19650', '0', '0', '0', 'Fire Shelter Associate', '946205'),
('3131', '1', '836', '2016-10-03', '1060', '', '-19650', '0', '0', '0', 'Fire Shelter Associate', '946205'),
('3132', '1', '837', '2016-10-04', '1820', 'Purchased HP Pro Book 450 G3', '96000', '0', '0', '0', 'Cash', '946206'),
('3133', '1', '837', '2016-10-04', '5765', 'Disaster Recovery Failover Expenses', '240000', '0', '0', '0', 'Cash', '946206'),
('3134', '1', '837', '2016-10-04', '5695', 'Expenses for Kristian?s visit', '66000', '0', '0', '0', 'Cash', '946206'),
('3135', '1', '837', '2016-10-04', '1060', '', '-402000', '0', '0', '0', 'Cash', '946206'),
('3136', '1', '838', '2016-10-04', '5440', 'Staff Medical Expenses for Mr  Lahiru Sampath', '9250', '0', '0', '0', 'Lahiru Sampath', '946207'),
('3137', '1', '838', '2016-10-04', '1060', '', '-9250', '0', '0', '0', 'Lahiru Sampath', '946207'),
('3138', '1', '839', '2016-10-05', '5780', 'Telephone And Internet expenses for Month of August 2016 ( ES00002794 )', '197702.5', '0', '0', '0', 'Dialog Broadband Networks (Pvt) Ltd	', '946208'),
('3139', '1', '839', '2016-10-05', '1060', '', '-197702.5', '0', '0', '0', 'Dialog Broadband Networks (Pvt) Ltd	', '946208'),
('3140', '1', '840', '2016-10-05', '5780', 'Telephone &amp; Internet Expenses for the Month of August 2016', '145977.93', '0', '0', '0', 'Tata Communications Lanka Ltd	', '946209'),
('3141', '1', '840', '2016-10-05', '1060', '', '-145977.93', '0', '0', '0', 'Tata Communications Lanka Ltd	', '946209');

### Structure of table `1_grn_batch` ###

DROP TABLE IF EXISTS `1_grn_batch`;

CREATE TABLE `1_grn_batch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `purch_order_no` int(11) DEFAULT NULL,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `delivery_date` (`delivery_date`),
  KEY `purch_order_no` (`purch_order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_grn_batch` ###


### Structure of table `1_grn_items` ###

DROP TABLE IF EXISTS `1_grn_items`;

CREATE TABLE `1_grn_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_batch_id` int(11) DEFAULT NULL,
  `po_detail_item` int(11) NOT NULL DEFAULT '0',
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `qty_recd` double NOT NULL DEFAULT '0',
  `quantity_inv` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `grn_batch_id` (`grn_batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_grn_items` ###


### Structure of table `1_groups` ###

DROP TABLE IF EXISTS `1_groups`;

CREATE TABLE `1_groups` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_groups` ###

INSERT INTO `1_groups` VALUES
('1', 'Small', '0'),
('2', 'Medium', '0'),
('3', 'Large', '0');

### Structure of table `1_item_codes` ###

DROP TABLE IF EXISTS `1_item_codes`;

CREATE TABLE `1_item_codes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` smallint(6) unsigned NOT NULL,
  `quantity` double NOT NULL DEFAULT '1',
  `is_foreign` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `stock_id` (`stock_id`,`item_code`),
  KEY `item_code` (`item_code`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_item_codes` ###

INSERT INTO `1_item_codes` VALUES
('1', 'exports', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '4', '1', '0', '0');

### Structure of table `1_item_tax_type_exemptions` ###

DROP TABLE IF EXISTS `1_item_tax_type_exemptions`;

CREATE TABLE `1_item_tax_type_exemptions` (
  `item_tax_type_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_tax_type_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_item_tax_type_exemptions` ###


### Structure of table `1_item_tax_types` ###

DROP TABLE IF EXISTS `1_item_tax_types`;

CREATE TABLE `1_item_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `exempt` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_item_tax_types` ###

INSERT INTO `1_item_tax_types` VALUES
('1', 'Regular', '0', '0');

### Structure of table `1_item_units` ###

DROP TABLE IF EXISTS `1_item_units`;

CREATE TABLE `1_item_units` (
  `abbr` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `decimals` tinyint(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`abbr`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_item_units` ###

INSERT INTO `1_item_units` VALUES
('ea.', 'Each', '0', '0');

### Structure of table `1_loc_stock` ###

DROP TABLE IF EXISTS `1_loc_stock`;

CREATE TABLE `1_loc_stock` (
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `reorder_level` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`loc_code`,`stock_id`),
  KEY `stock_id` (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_loc_stock` ###

INSERT INTO `1_loc_stock` VALUES
('DEF', 'exports', '0');

### Structure of table `1_locations` ###

DROP TABLE IF EXISTS `1_locations`;

CREATE TABLE `1_locations` (
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `location_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fax` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`loc_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_locations` ###

INSERT INTO `1_locations` VALUES
('DEF', 'Default', 'N/A', '', '', '', '', '', '0');

### Structure of table `1_movement_types` ###

DROP TABLE IF EXISTS `1_movement_types`;

CREATE TABLE `1_movement_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_movement_types` ###

INSERT INTO `1_movement_types` VALUES
('1', 'Adjustment', '0');

### Structure of table `1_payment_terms` ###

DROP TABLE IF EXISTS `1_payment_terms`;

CREATE TABLE `1_payment_terms` (
  `terms_indicator` int(11) NOT NULL AUTO_INCREMENT,
  `terms` char(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `days_before_due` smallint(6) NOT NULL DEFAULT '0',
  `day_in_following_month` smallint(6) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`terms_indicator`),
  UNIQUE KEY `terms` (`terms`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_payment_terms` ###

INSERT INTO `1_payment_terms` VALUES
('1', 'Due 15th Of the Following Month', '0', '17', '0'),
('2', 'Due By End Of The Following Month', '0', '30', '0'),
('3', 'Payment due within 10 days', '10', '0', '0'),
('4', 'Cash Only', '0', '0', '0');

### Structure of table `1_prices` ###

DROP TABLE IF EXISTS `1_prices`;

CREATE TABLE `1_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type_id` int(11) NOT NULL DEFAULT '0',
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `price` (`stock_id`,`sales_type_id`,`curr_abrev`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_prices` ###


### Structure of table `1_print_profiles` ###

DROP TABLE IF EXISTS `1_print_profiles`;

CREATE TABLE `1_print_profiles` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `report` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `printer` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile` (`profile`,`report`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_print_profiles` ###

INSERT INTO `1_print_profiles` VALUES
('1', 'Out of office', NULL, '0'),
('2', 'Sales Department', NULL, '0'),
('3', 'Central', NULL, '2'),
('4', 'Sales Department', '104', '2'),
('5', 'Sales Department', '105', '2'),
('6', 'Sales Department', '107', '2'),
('7', 'Sales Department', '109', '2'),
('8', 'Sales Department', '110', '2'),
('9', 'Sales Department', '201', '2');

### Structure of table `1_printers` ###

DROP TABLE IF EXISTS `1_printers`;

CREATE TABLE `1_printers` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `queue` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `host` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `port` smallint(11) unsigned NOT NULL,
  `timeout` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_printers` ###

INSERT INTO `1_printers` VALUES
('1', 'QL500', 'Label printer', 'QL500', 'server', '127', '20'),
('2', 'Samsung', 'Main network printer', 'scx4521F', 'server', '515', '5'),
('3', 'Local', 'Local print server at user IP', 'lp', '', '515', '10');

### Structure of table `1_purch_data` ###

DROP TABLE IF EXISTS `1_purch_data`;

CREATE TABLE `1_purch_data` (
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT '0',
  `suppliers_uom` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `conversion_factor` double NOT NULL DEFAULT '1',
  `supplier_description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`supplier_id`,`stock_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_purch_data` ###


### Structure of table `1_purch_order_details` ###

DROP TABLE IF EXISTS `1_purch_order_details`;

CREATE TABLE `1_purch_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT '0',
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `act_price` double NOT NULL DEFAULT '0',
  `std_cost_unit` double NOT NULL DEFAULT '0',
  `quantity_ordered` double NOT NULL DEFAULT '0',
  `quantity_received` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_purch_order_details` ###


### Structure of table `1_purch_orders` ###

DROP TABLE IF EXISTS `1_purch_orders`;

CREATE TABLE `1_purch_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `comments` tinytext COLLATE utf8_unicode_ci,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `requisition_no` tinytext COLLATE utf8_unicode_ci,
  `into_stock_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `total` double NOT NULL DEFAULT '0',
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_purch_orders` ###


### Structure of table `1_quick_entries` ###

DROP TABLE IF EXISTS `1_quick_entries`;

CREATE TABLE `1_quick_entries` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `base_amount` double NOT NULL DEFAULT '0',
  `base_desc` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bal_type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `description` (`description`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_quick_entries` ###

INSERT INTO `1_quick_entries` VALUES
('1', '1', 'Maintenance', '0', 'Amount', '0'),
('2', '4', 'Phone', '0', 'Amount', '0'),
('3', '2', 'Cash Sales', '0', 'Amount', '0'),
('4', '1', 'The Superintendent, Employees Provident Fund', '161000', 'E.P.F', '0'),
('5', '1', 'Employees Trust Fund', '24150', 'E.T.F', '0'),
('6', '1', 'The Commissioner General of Inland Revenue', '0', 'P.A.Y.E', '0');

### Structure of table `1_quick_entry_lines` ###

DROP TABLE IF EXISTS `1_quick_entry_lines`;

CREATE TABLE `1_quick_entry_lines` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `qid` smallint(6) unsigned NOT NULL,
  `amount` double DEFAULT '0',
  `action` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `dest_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` smallint(6) unsigned DEFAULT NULL,
  `dimension2_id` smallint(6) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_quick_entry_lines` ###

INSERT INTO `1_quick_entry_lines` VALUES
('10', '6', '0', '=', '2160', '0', '0'),
('2', '2', '0', 't-', '1', '0', '0'),
('3', '3', '0', 't-', '1', '0', '0'),
('4', '3', '0', '=', '4010', '0', '0'),
('6', '2', '0', '=', '5780', '0', '0'),
('7', '4', '0', '=', '5450', '0', '0'),
('9', '5', '0', '=', '5460', '0', '0');

### Structure of table `1_recurrent_invoices` ###

DROP TABLE IF EXISTS `1_recurrent_invoices`;

CREATE TABLE `1_recurrent_invoices` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order_no` int(11) unsigned NOT NULL,
  `debtor_no` int(11) unsigned DEFAULT NULL,
  `group_no` smallint(6) unsigned DEFAULT NULL,
  `days` int(11) NOT NULL DEFAULT '0',
  `monthly` int(11) NOT NULL DEFAULT '0',
  `begin` date NOT NULL DEFAULT '0000-00-00',
  `end` date NOT NULL DEFAULT '0000-00-00',
  `last_sent` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_recurrent_invoices` ###


### Structure of table `1_refs` ###

DROP TABLE IF EXISTS `1_refs`;

CREATE TABLE `1_refs` (
  `id` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`type`),
  KEY `Type_and_Reference` (`type`,`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_refs` ###

INSERT INTO `1_refs` VALUES
('1', '0', '1'),
('10', '0', '10'),
('12', '0', '11'),
('13', '0', '12'),
('14', '0', '13'),
('15', '0', '14'),
('16', '0', '15'),
('17', '0', '16'),
('18', '0', '17'),
('19', '0', '18'),
('21', '0', '19'),
('2', '0', '2'),
('23', '0', '20'),
('24', '0', '21'),
('25', '0', '22'),
('26', '0', '23'),
('27', '0', '24'),
('28', '0', '25'),
('29', '0', '26'),
('30', '0', '27'),
('31', '0', '28'),
('32', '0', '29'),
('3', '0', '3'),
('33', '0', '30'),
('34', '0', '31'),
('35', '0', '31'),
('36', '0', '32'),
('37', '0', '33'),
('38', '0', '34'),
('39', '0', '35'),
('40', '0', '36'),
('42', '0', '37'),
('43', '0', '38'),
('45', '0', '38'),
('46', '0', '39'),
('4', '0', '4'),
('47', '0', '40'),
('48', '0', '41'),
('49', '0', '42'),
('50', '0', '43'),
('51', '0', '44'),
('52', '0', '45'),
('53', '0', '46'),
('54', '0', '47'),
('55', '0', '48'),
('56', '0', '49'),
('5', '0', '5'),
('57', '0', '50'),
('58', '0', '51'),
('59', '0', '52'),
('60', '0', '53'),
('61', '0', '54'),
('63', '0', '55'),
('64', '0', '56'),
('65', '0', '57'),
('66', '0', '58'),
('67', '0', '59'),
('6', '0', '6'),
('7', '0', '7'),
('8', '0', '8'),
('9', '0', '9'),
('1', '1', '1'),
('10', '1', '10'),
('48', '1', '10'),
('169', '1', '100'),
('161', '1', '1001'),
('162', '1', '1002'),
('163', '1', '1003'),
('170', '1', '101'),
('171', '1', '102'),
('172', '1', '103'),
('173', '1', '104'),
('174', '1', '105'),
('175', '1', '106'),
('176', '1', '107'),
('177', '1', '108'),
('178', '1', '109'),
('11', '1', '11'),
('179', '1', '110'),
('180', '1', '111'),
('181', '1', '112'),
('182', '1', '113'),
('183', '1', '114'),
('184', '1', '115'),
('185', '1', '116'),
('186', '1', '117'),
('187', '1', '118'),
('188', '1', '119'),
('12', '1', '12'),
('19', '1', '12'),
('189', '1', '120'),
('190', '1', '121'),
('191', '1', '122'),
('192', '1', '123'),
('193', '1', '124'),
('194', '1', '125'),
('195', '1', '126'),
('196', '1', '127'),
('197', '1', '128'),
('198', '1', '129'),
('13', '1', '13'),
('20', '1', '13'),
('36', '1', '13'),
('199', '1', '130'),
('200', '1', '131'),
('201', '1', '132'),
('202', '1', '133'),
('203', '1', '134'),
('204', '1', '135'),
('205', '1', '136'),
('206', '1', '137'),
('207', '1', '138'),
('208', '1', '139'),
('14', '1', '14'),
('21', '1', '14'),
('49', '1', '14'),
('209', '1', '140'),
('210', '1', '141'),
('211', '1', '142'),
('212', '1', '143'),
('213', '1', '144'),
('214', '1', '145'),
('215', '1', '146'),
('216', '1', '147'),
('217', '1', '148'),
('218', '1', '149'),
('15', '1', '15'),
('22', '1', '15'),
('37', '1', '15'),
('50', '1', '15'),
('220', '1', '15'),
('219', '1', '150'),
('221', '1', '151'),
('222', '1', '152'),
('223', '1', '153'),
('224', '1', '154'),
('225', '1', '155'),
('226', '1', '156'),
('227', '1', '157'),
('493', '1', '157'),
('228', '1', '158'),
('229', '1', '159'),
('16', '1', '16'),
('23', '1', '16'),
('38', '1', '16'),
('230', '1', '160'),
('231', '1', '161'),
('232', '1', '161'),
('233', '1', '161'),
('234', '1', '162'),
('235', '1', '163'),
('236', '1', '164'),
('237', '1', '165'),
('483', '1', '165'),
('238', '1', '166'),
('239', '1', '167'),
('240', '1', '168'),
('241', '1', '169'),
('17', '1', '17'),
('24', '1', '17'),
('39', '1', '17'),
('51', '1', '17'),
('242', '1', '170'),
('243', '1', '171'),
('244', '1', '172'),
('245', '1', '173'),
('246', '1', '174'),
('247', '1', '175'),
('248', '1', '176'),
('484', '1', '176'),
('249', '1', '177'),
('250', '1', '178'),
('251', '1', '179'),
('18', '1', '18'),
('25', '1', '18'),
('40', '1', '18'),
('52', '1', '18'),
('252', '1', '180'),
('253', '1', '181'),
('254', '1', '182'),
('255', '1', '183'),
('256', '1', '184'),
('257', '1', '185'),
('258', '1', '186'),
('259', '1', '187'),
('260', '1', '188'),
('261', '1', '189'),
('26', '1', '19'),
('41', '1', '19'),
('53', '1', '19'),
('262', '1', '190'),
('263', '1', '191'),
('264', '1', '192'),
('265', '1', '193'),
('266', '1', '194'),
('267', '1', '195'),
('268', '1', '196'),
('269', '1', '197'),
('270', '1', '198'),
('271', '1', '199'),
('2', '1', '2'),
('27', '1', '20'),
('42', '1', '20'),
('54', '1', '20'),
('111', '1', '20'),
('272', '1', '200'),
('273', '1', '201'),
('274', '1', '202'),
('275', '1', '203'),
('276', '1', '204'),
('277', '1', '205'),
('278', '1', '206'),
('279', '1', '207'),
('280', '1', '208'),
('281', '1', '209'),
('28', '1', '21'),
('43', '1', '21'),
('55', '1', '21'),
('112', '1', '21'),
('282', '1', '210'),
('283', '1', '211'),
('351', '1', '211'),
('284', '1', '212'),
('350', '1', '212'),
('352', '1', '212'),
('285', '1', '213'),
('286', '1', '214'),
('287', '1', '215'),
('288', '1', '215'),
('289', '1', '216'),
('290', '1', '217'),
('291', '1', '218'),
('292', '1', '219'),
('29', '1', '22'),
('44', '1', '22'),
('56', '1', '22'),
('113', '1', '22'),
('293', '1', '220'),
('294', '1', '221'),
('295', '1', '222'),
('296', '1', '223'),
('297', '1', '224'),
('298', '1', '225'),
('299', '1', '226'),
('300', '1', '227'),
('301', '1', '228'),
('302', '1', '229'),
('30', '1', '23'),
('45', '1', '23'),
('57', '1', '23'),
('114', '1', '23'),
('303', '1', '230'),
('304', '1', '231'),
('305', '1', '232'),
('306', '1', '233'),
('307', '1', '234'),
('308', '1', '235'),
('309', '1', '236'),
('310', '1', '237'),
('311', '1', '238'),
('312', '1', '239'),
('31', '1', '24'),
('58', '1', '24'),
('59', '1', '24'),
('115', '1', '24'),
('313', '1', '240'),
('314', '1', '241'),
('315', '1', '242'),
('316', '1', '242'),
('317', '1', '242'),
('318', '1', '243'),
('643', '1', '243'),
('319', '1', '244'),
('644', '1', '244'),
('320', '1', '245'),
('321', '1', '246'),
('322', '1', '247'),
('323', '1', '248'),
('324', '1', '249'),
('32', '1', '25'),
('60', '1', '25'),
('116', '1', '25'),
('325', '1', '250'),
('326', '1', '251'),
('327', '1', '252'),
('328', '1', '253'),
('329', '1', '254'),
('330', '1', '255'),
('331', '1', '256'),
('332', '1', '257'),
('333', '1', '258'),
('334', '1', '259'),
('33', '1', '26'),
('61', '1', '26'),
('117', '1', '26'),
('335', '1', '260'),
('336', '1', '261'),
('337', '1', '262'),
('338', '1', '263'),
('339', '1', '264'),
('340', '1', '265'),
('341', '1', '266'),
('342', '1', '267'),
('343', '1', '268'),
('344', '1', '269'),
('34', '1', '27'),
('62', '1', '27'),
('118', '1', '27'),
('345', '1', '270'),
('346', '1', '271'),
('347', '1', '272'),
('348', '1', '273'),
('349', '1', '274'),
('353', '1', '275'),
('354', '1', '276'),
('355', '1', '277'),
('356', '1', '278'),
('357', '1', '279'),
('35', '1', '28'),
('63', '1', '28'),
('119', '1', '28'),
('358', '1', '280'),
('359', '1', '281'),
('360', '1', '282'),
('361', '1', '282'),
('362', '1', '282'),
('363', '1', '283'),
('364', '1', '284'),
('365', '1', '285'),
('366', '1', '286'),
('367', '1', '287'),
('368', '1', '288'),
('369', '1', '289'),
('64', '1', '29'),
('120', '1', '29'),
('370', '1', '290'),
('371', '1', '291'),
('636', '1', '291'),
('372', '1', '292'),
('373', '1', '293'),
('374', '1', '294'),
('375', '1', '295'),
('376', '1', '296'),
('377', '1', '297'),
('378', '1', '298'),
('379', '1', '299'),
('3', '1', '3'),
('65', '1', '30'),
('121', '1', '30'),
('380', '1', '300'),
('381', '1', '301'),
('382', '1', '302'),
('383', '1', '303'),
('384', '1', '304'),
('385', '1', '305'),
('386', '1', '306'),
('387', '1', '307'),
('468', '1', '307'),
('388', '1', '308'),
('389', '1', '309'),
('66', '1', '31'),
('122', '1', '31'),
('466', '1', '31'),
('467', '1', '31'),
('390', '1', '310'),
('391', '1', '311'),
('392', '1', '312'),
('393', '1', '313'),
('394', '1', '314'),
('395', '1', '315'),
('396', '1', '316'),
('397', '1', '317'),
('398', '1', '318'),
('399', '1', '319'),
('67', '1', '32'),
('123', '1', '32'),
('400', '1', '320'),
('401', '1', '321'),
('403', '1', '321'),
('404', '1', '321'),
('405', '1', '321'),
('402', '1', '322'),
('406', '1', '323'),
('407', '1', '324'),
('408', '1', '325'),
('409', '1', '326'),
('410', '1', '327'),
('411', '1', '328'),
('412', '1', '329'),
('68', '1', '33'),
('124', '1', '33'),
('413', '1', '330'),
('414', '1', '331'),
('415', '1', '332'),
('416', '1', '333'),
('417', '1', '334'),
('418', '1', '335'),
('419', '1', '336'),
('420', '1', '337'),
('421', '1', '338'),
('422', '1', '339'),
('69', '1', '34'),
('125', '1', '34'),
('423', '1', '340'),
('424', '1', '341'),
('425', '1', '342'),
('426', '1', '343'),
('427', '1', '344'),
('428', '1', '345'),
('429', '1', '346'),
('430', '1', '347'),
('431', '1', '348'),
('432', '1', '349'),
('70', '1', '35'),
('126', '1', '35'),
('482', '1', '35'),
('433', '1', '350'),
('434', '1', '351'),
('435', '1', '352'),
('436', '1', '353'),
('437', '1', '354'),
('438', '1', '355'),
('439', '1', '356'),
('440', '1', '357'),
('441', '1', '358'),
('442', '1', '359'),
('71', '1', '36'),
('127', '1', '36'),
('443', '1', '360'),
('444', '1', '361'),
('445', '1', '362'),
('446', '1', '363'),
('447', '1', '364'),
('448', '1', '365'),
('449', '1', '366'),
('450', '1', '367'),
('451', '1', '368'),
('452', '1', '369'),
('72', '1', '37'),
('453', '1', '370'),
('454', '1', '371'),
('455', '1', '372'),
('456', '1', '373'),
('457', '1', '374'),
('458', '1', '375'),
('459', '1', '376'),
('460', '1', '377'),
('461', '1', '378'),
('462', '1', '379'),
('73', '1', '38'),
('463', '1', '380'),
('464', '1', '381'),
('465', '1', '382'),
('469', '1', '383'),
('470', '1', '384'),
('471', '1', '385'),
('472', '1', '386'),
('473', '1', '387'),
('474', '1', '388'),
('475', '1', '389'),
('74', '1', '39'),
('476', '1', '390'),
('477', '1', '391'),
('478', '1', '392'),
('479', '1', '393'),
('480', '1', '394'),
('481', '1', '395'),
('485', '1', '396'),
('486', '1', '397'),
('487', '1', '398'),
('488', '1', '399'),
('4', '1', '4'),
('75', '1', '40'),
('489', '1', '400'),
('490', '1', '401'),
('491', '1', '402'),
('492', '1', '403'),
('494', '1', '404'),
('495', '1', '405'),
('496', '1', '406'),
('497', '1', '407'),
('498', '1', '408'),
('499', '1', '409'),
('76', '1', '41'),
('500', '1', '410'),
('501', '1', '411'),
('502', '1', '412'),
('503', '1', '413'),
('504', '1', '414'),
('699', '1', '414'),
('505', '1', '415'),
('684', '1', '415'),
('506', '1', '416'),
('507', '1', '417'),
('508', '1', '418'),
('509', '1', '419'),
('77', '1', '42'),
('510', '1', '420'),
('511', '1', '421'),
('685', '1', '421'),
('512', '1', '422'),
('698', '1', '422'),
('513', '1', '423'),
('514', '1', '424'),
('725', '1', '424'),
('515', '1', '425'),
('516', '1', '426'),
('517', '1', '427'),
('518', '1', '428'),
('519', '1', '429'),
('686', '1', '429'),
('78', '1', '43'),
('520', '1', '430'),
('697', '1', '430'),
('521', '1', '431'),
('522', '1', '432'),
('523', '1', '433'),
('524', '1', '434'),
('525', '1', '435'),
('526', '1', '436'),
('527', '1', '437'),
('528', '1', '438'),
('687', '1', '438'),
('529', '1', '439'),
('696', '1', '439'),
('79', '1', '44'),
('530', '1', '440'),
('531', '1', '441'),
('532', '1', '442'),
('533', '1', '442'),
('534', '1', '442'),
('535', '1', '443'),
('688', '1', '443'),
('536', '1', '444'),
('695', '1', '444'),
('537', '1', '445'),
('538', '1', '446'),
('539', '1', '447'),
('540', '1', '447'),
('541', '1', '447'),
('542', '1', '447'),
('543', '1', '448'),
('544', '1', '449'),
('80', '1', '45'),
('545', '1', '450'),
('546', '1', '451'),
('547', '1', '452'),
('548', '1', '453'),
('549', '1', '454'),
('619', '1', '454'),
('689', '1', '454'),
('550', '1', '455'),
('620', '1', '455'),
('694', '1', '455'),
('551', '1', '456'),
('552', '1', '457'),
('641', '1', '457'),
('553', '1', '458'),
('554', '1', '459'),
('81', '1', '46'),
('555', '1', '460'),
('556', '1', '461'),
('557', '1', '462'),
('558', '1', '463'),
('559', '1', '464'),
('560', '1', '465'),
('561', '1', '466'),
('562', '1', '467'),
('563', '1', '468'),
('564', '1', '469'),
('82', '1', '47'),
('565', '1', '470'),
('567', '1', '471'),
('588', '1', '471'),
('568', '1', '472'),
('569', '1', '473'),
('570', '1', '474'),
('571', '1', '475'),
('572', '1', '476'),
('573', '1', '477'),
('642', '1', '477'),
('574', '1', '478'),
('575', '1', '479'),
('576', '1', '479'),
('83', '1', '48'),
('577', '1', '480'),
('578', '1', '481'),
('579', '1', '482'),
('580', '1', '483'),
('581', '1', '484'),
('582', '1', '485'),
('583', '1', '486'),
('584', '1', '487'),
('585', '1', '488'),
('586', '1', '489'),
('84', '1', '49'),
('587', '1', '490'),
('589', '1', '491'),
('590', '1', '492'),
('591', '1', '493'),
('592', '1', '494'),
('593', '1', '495'),
('594', '1', '496'),
('595', '1', '497'),
('605', '1', '497'),
('596', '1', '498'),
('597', '1', '499'),
('5', '1', '5'),
('85', '1', '50'),
('598', '1', '500'),
('599', '1', '501'),
('690', '1', '501'),
('600', '1', '502'),
('693', '1', '502'),
('601', '1', '503'),
('802', '1', '503'),
('602', '1', '504'),
('603', '1', '505'),
('604', '1', '506'),
('606', '1', '507'),
('607', '1', '508'),
('608', '1', '509'),
('86', '1', '51'),
('609', '1', '510'),
('692', '1', '510'),
('610', '1', '511'),
('611', '1', '511'),
('612', '1', '511'),
('691', '1', '511'),
('613', '1', '512'),
('661', '1', '512'),
('614', '1', '513'),
('615', '1', '514'),
('616', '1', '515'),
('617', '1', '516'),
('682', '1', '516'),
('618', '1', '517'),
('683', '1', '517'),
('621', '1', '518'),
('622', '1', '519'),
('628', '1', '519'),
('629', '1', '519'),
('635', '1', '519'),
('87', '1', '52'),
('623', '1', '520'),
('630', '1', '520'),
('624', '1', '521'),
('631', '1', '521'),
('625', '1', '522'),
('632', '1', '522'),
('626', '1', '523'),
('633', '1', '523'),
('672', '1', '523'),
('627', '1', '524'),
('634', '1', '524'),
('637', '1', '524'),
('671', '1', '524'),
('638', '1', '525'),
('639', '1', '526'),
('640', '1', '527'),
('645', '1', '528'),
('646', '1', '529'),
('88', '1', '53'),
('647', '1', '530'),
('648', '1', '531'),
('649', '1', '532'),
('657', '1', '532'),
('660', '1', '532'),
('677', '1', '532'),
('650', '1', '533'),
('656', '1', '533'),
('658', '1', '533'),
('651', '1', '534'),
('659', '1', '534'),
('652', '1', '535'),
('662', '1', '535'),
('653', '1', '536'),
('654', '1', '537'),
('655', '1', '538'),
('663', '1', '539'),
('681', '1', '539'),
('89', '1', '54'),
('664', '1', '540'),
('680', '1', '540'),
('665', '1', '541'),
('666', '1', '541'),
('667', '1', '541'),
('668', '1', '542'),
('669', '1', '543'),
('670', '1', '544'),
('673', '1', '545'),
('674', '1', '546'),
('675', '1', '547'),
('676', '1', '547'),
('678', '1', '547'),
('679', '1', '548'),
('700', '1', '549'),
('90', '1', '55'),
('701', '1', '550'),
('702', '1', '551'),
('703', '1', '552'),
('704', '1', '553'),
('705', '1', '554'),
('819', '1', '554'),
('706', '1', '555'),
('707', '1', '556'),
('708', '1', '557'),
('709', '1', '558'),
('710', '1', '559'),
('91', '1', '56'),
('711', '1', '560'),
('712', '1', '561'),
('713', '1', '562'),
('714', '1', '563'),
('715', '1', '564'),
('716', '1', '565'),
('717', '1', '566'),
('718', '1', '567'),
('719', '1', '568'),
('720', '1', '569'),
('92', '1', '57'),
('721', '1', '570'),
('722', '1', '571'),
('723', '1', '572'),
('724', '1', '573'),
('738', '1', '573'),
('739', '1', '573'),
('740', '1', '573'),
('726', '1', '574'),
('727', '1', '575'),
('728', '1', '576'),
('729', '1', '577'),
('730', '1', '578'),
('731', '1', '579'),
('93', '1', '58'),
('732', '1', '580'),
('733', '1', '581'),
('734', '1', '581'),
('735', '1', '581'),
('736', '1', '581'),
('737', '1', '582'),
('741', '1', '583'),
('742', '1', '584'),
('743', '1', '585'),
('744', '1', '585'),
('745', '1', '585'),
('746', '1', '586'),
('747', '1', '587'),
('748', '1', '588'),
('749', '1', '589'),
('94', '1', '59'),
('750', '1', '590'),
('751', '1', '591'),
('752', '1', '592'),
('753', '1', '593'),
('754', '1', '594'),
('755', '1', '595'),
('756', '1', '596'),
('757', '1', '597'),
('758', '1', '598'),
('759', '1', '599'),
('6', '1', '6'),
('95', '1', '60'),
('760', '1', '600'),
('761', '1', '601'),
('762', '1', '602'),
('763', '1', '603'),
('764', '1', '604'),
('765', '1', '605'),
('766', '1', '606'),
('767', '1', '607'),
('768', '1', '608'),
('769', '1', '609'),
('96', '1', '61'),
('770', '1', '610'),
('771', '1', '611'),
('772', '1', '612'),
('773', '1', '613'),
('774', '1', '614'),
('775', '1', '615'),
('776', '1', '616'),
('777', '1', '617'),
('778', '1', '618'),
('779', '1', '619'),
('97', '1', '62'),
('128', '1', '62'),
('780', '1', '620'),
('781', '1', '621'),
('782', '1', '622'),
('783', '1', '623'),
('784', '1', '624'),
('785', '1', '625'),
('786', '1', '626'),
('787', '1', '627'),
('788', '1', '628'),
('789', '1', '629'),
('98', '1', '63'),
('129', '1', '63'),
('790', '1', '630'),
('791', '1', '631'),
('792', '1', '632'),
('793', '1', '633'),
('794', '1', '634'),
('795', '1', '635'),
('796', '1', '636'),
('797', '1', '637'),
('798', '1', '638'),
('799', '1', '639'),
('99', '1', '64'),
('130', '1', '64'),
('800', '1', '640'),
('801', '1', '641'),
('803', '1', '642'),
('804', '1', '643'),
('805', '1', '644'),
('806', '1', '645'),
('807', '1', '646'),
('808', '1', '647'),
('809', '1', '648'),
('810', '1', '648'),
('811', '1', '648'),
('812', '1', '649'),
('100', '1', '65'),
('131', '1', '65'),
('813', '1', '650'),
('814', '1', '651'),
('815', '1', '652'),
('816', '1', '653'),
('817', '1', '654'),
('818', '1', '655'),
('820', '1', '656'),
('821', '1', '657'),
('822', '1', '658'),
('823', '1', '659'),
('101', '1', '66'),
('132', '1', '66'),
('824', '1', '660'),
('825', '1', '661'),
('826', '1', '662'),
('827', '1', '663'),
('828', '1', '664'),
('829', '1', '665'),
('830', '1', '666'),
('831', '1', '667'),
('832', '1', '668'),
('833', '1', '669'),
('102', '1', '67'),
('133', '1', '67'),
('834', '1', '670'),
('835', '1', '671'),
('836', '1', '672'),
('837', '1', '673'),
('838', '1', '674'),
('839', '1', '675'),
('840', '1', '676'),
('103', '1', '68'),
('134', '1', '68'),
('104', '1', '69'),
('135', '1', '69'),
('7', '1', '7'),
('105', '1', '70'),
('136', '1', '70'),
('106', '1', '71'),
('137', '1', '71'),
('107', '1', '72'),
('138', '1', '72'),
('108', '1', '73'),
('139', '1', '73'),
('109', '1', '74'),
('140', '1', '74'),
('110', '1', '75'),
('141', '1', '75'),
('142', '1', '76'),
('143', '1', '77'),
('144', '1', '78'),
('145', '1', '79'),
('8', '1', '8'),
('46', '1', '8'),
('146', '1', '80'),
('147', '1', '81'),
('148', '1', '82'),
('149', '1', '83'),
('150', '1', '84'),
('151', '1', '85'),
('152', '1', '86'),
('153', '1', '87'),
('154', '1', '88'),
('155', '1', '89'),
('9', '1', '9'),
('47', '1', '9'),
('156', '1', '90'),
('157', '1', '91'),
('158', '1', '92'),
('159', '1', '93'),
('160', '1', '94'),
('164', '1', '95'),
('165', '1', '96'),
('166', '1', '97'),
('167', '1', '98'),
('168', '1', '99'),
('566', '1', 'B'),
('1', '2', '1'),
('10', '2', '10'),
('108', '2', '100'),
('109', '2', '101'),
('110', '2', '102'),
('111', '2', '103'),
('112', '2', '104'),
('113', '2', '105'),
('114', '2', '106'),
('115', '2', '107'),
('116', '2', '108'),
('117', '2', '109'),
('11', '2', '11'),
('118', '2', '110'),
('119', '2', '111'),
('120', '2', '112'),
('121', '2', '113'),
('122', '2', '114'),
('123', '2', '115'),
('124', '2', '116'),
('125', '2', '117'),
('126', '2', '118'),
('127', '2', '119'),
('12', '2', '12'),
('34', '2', '12'),
('128', '2', '120'),
('129', '2', '120'),
('130', '2', '120'),
('131', '2', '121'),
('132', '2', '122'),
('133', '2', '123'),
('134', '2', '124'),
('135', '2', '125'),
('136', '2', '126'),
('137', '2', '127'),
('138', '2', '128'),
('139', '2', '129'),
('13', '2', '13'),
('140', '2', '130'),
('141', '2', '131'),
('142', '2', '131'),
('143', '2', '131'),
('188', '2', '131'),
('144', '2', '132'),
('145', '2', '133'),
('146', '2', '134'),
('147', '2', '135'),
('148', '2', '136'),
('149', '2', '137'),
('150', '2', '138'),
('151', '2', '139'),
('14', '2', '14'),
('152', '2', '140'),
('153', '2', '141'),
('154', '2', '142'),
('155', '2', '143'),
('156', '2', '144'),
('157', '2', '145'),
('158', '2', '146'),
('159', '2', '147'),
('160', '2', '148'),
('161', '2', '149'),
('15', '2', '15'),
('162', '2', '150'),
('163', '2', '151'),
('164', '2', '152'),
('165', '2', '153'),
('166', '2', '154'),
('167', '2', '155'),
('168', '2', '156'),
('169', '2', '157'),
('170', '2', '157'),
('171', '2', '157'),
('172', '2', '158'),
('173', '2', '159'),
('16', '2', '16'),
('17', '2', '16'),
('174', '2', '160'),
('175', '2', '161'),
('176', '2', '162'),
('177', '2', '163'),
('178', '2', '164'),
('179', '2', '165'),
('180', '2', '166'),
('181', '2', '167'),
('182', '2', '168'),
('183', '2', '169'),
('18', '2', '17'),
('184', '2', '170'),
('185', '2', '171'),
('186', '2', '172'),
('187', '2', '172'),
('189', '2', '172'),
('190', '2', '172'),
('19', '2', '18'),
('20', '2', '19'),
('2', '2', '2'),
('21', '2', '20'),
('22', '2', '21'),
('23', '2', '22'),
('24', '2', '23'),
('25', '2', '24'),
('26', '2', '25'),
('27', '2', '26'),
('28', '2', '27'),
('29', '2', '28'),
('30', '2', '29'),
('3', '2', '3'),
('31', '2', '30'),
('32', '2', '31'),
('33', '2', '32'),
('35', '2', '33'),
('36', '2', '34'),
('37', '2', '35'),
('38', '2', '36'),
('39', '2', '37'),
('40', '2', '38'),
('41', '2', '39'),
('4', '2', '4'),
('42', '2', '40'),
('43', '2', '41'),
('44', '2', '42'),
('45', '2', '43'),
('46', '2', '44'),
('47', '2', '45'),
('48', '2', '45'),
('49', '2', '46'),
('50', '2', '47'),
('51', '2', '48'),
('83', '2', '48'),
('52', '2', '49'),
('5', '2', '5'),
('53', '2', '50'),
('54', '2', '51'),
('55', '2', '52'),
('56', '2', '53'),
('57', '2', '54'),
('58', '2', '55'),
('59', '2', '56'),
('60', '2', '57'),
('61', '2', '58'),
('62', '2', '59'),
('65', '2', '59'),
('66', '2', '59'),
('67', '2', '59'),
('6', '2', '6'),
('63', '2', '60'),
('64', '2', '61'),
('68', '2', '62'),
('69', '2', '63'),
('70', '2', '64'),
('71', '2', '65'),
('72', '2', '66'),
('73', '2', '67'),
('82', '2', '67'),
('74', '2', '68'),
('75', '2', '69'),
('7', '2', '7'),
('76', '2', '70'),
('77', '2', '71'),
('78', '2', '72'),
('79', '2', '73'),
('80', '2', '74'),
('81', '2', '75'),
('84', '2', '76'),
('85', '2', '77'),
('86', '2', '78'),
('87', '2', '79'),
('8', '2', '8'),
('88', '2', '80'),
('89', '2', '81'),
('90', '2', '82'),
('91', '2', '83'),
('92', '2', '84'),
('93', '2', '85'),
('94', '2', '86'),
('95', '2', '87'),
('96', '2', '88'),
('97', '2', '89'),
('9', '2', '9'),
('98', '2', '90'),
('99', '2', '91'),
('100', '2', '92'),
('101', '2', '93'),
('102', '2', '94'),
('103', '2', '95'),
('104', '2', '96'),
('105', '2', '97'),
('106', '2', '98'),
('107', '2', '99'),
('1', '4', '79'),
('2', '4', '79'),
('3', '4', '80'),
('4', '4', '80'),
('1', '10', '1'),
('10', '10', '10'),
('105', '10', '100'),
('106', '10', '101'),
('107', '10', '102'),
('11', '10', '11'),
('12', '10', '12'),
('13', '10', '13'),
('14', '10', '14'),
('15', '10', '15'),
('16', '10', '16'),
('17', '10', '17'),
('18', '10', '18'),
('19', '10', '19'),
('2', '10', '2'),
('20', '10', '20'),
('21', '10', '21'),
('22', '10', '22'),
('23', '10', '23'),
('24', '10', '24'),
('25', '10', '25'),
('26', '10', '26'),
('27', '10', '27'),
('28', '10', '28'),
('29', '10', '29'),
('3', '10', '3'),
('30', '10', '30'),
('31', '10', '31'),
('32', '10', '32'),
('33', '10', '33'),
('34', '10', '34'),
('35', '10', '35'),
('36', '10', '36'),
('37', '10', '37'),
('38', '10', '38'),
('39', '10', '39'),
('4', '10', '4'),
('40', '10', '40'),
('41', '10', '41'),
('42', '10', '42'),
('43', '10', '43'),
('44', '10', '44'),
('45', '10', '45'),
('57', '10', '45/1'),
('58', '10', '45/1'),
('59', '10', '45/1'),
('46', '10', '46'),
('47', '10', '47'),
('48', '10', '48'),
('49', '10', '49'),
('5', '10', '5'),
('50', '10', '50'),
('51', '10', '51'),
('52', '10', '52'),
('53', '10', '53'),
('54', '10', '54'),
('55', '10', '55'),
('56', '10', '56'),
('60', '10', '57'),
('61', '10', '58'),
('62', '10', '59'),
('6', '10', '6'),
('63', '10', '60'),
('64', '10', '61'),
('65', '10', '62'),
('66', '10', '63'),
('67', '10', '64'),
('68', '10', '65'),
('69', '10', '66'),
('70', '10', '67'),
('71', '10', '68'),
('72', '10', '68'),
('73', '10', '69'),
('7', '10', '7'),
('74', '10', '70'),
('75', '10', '71'),
('76', '10', '72'),
('77', '10', '73'),
('78', '10', '74'),
('79', '10', '75'),
('80', '10', '76'),
('81', '10', '77'),
('82', '10', '78'),
('83', '10', '79'),
('8', '10', '8'),
('84', '10', '80'),
('85', '10', '81'),
('86', '10', '82'),
('87', '10', '83'),
('88', '10', '84'),
('89', '10', '85'),
('90', '10', '86'),
('91', '10', '87'),
('92', '10', '88'),
('93', '10', '89'),
('9', '10', '9'),
('94', '10', '90'),
('95', '10', '90'),
('96', '10', '91'),
('97', '10', '92'),
('98', '10', '93'),
('99', '10', '94'),
('100', '10', '95'),
('101', '10', '96'),
('102', '10', '97'),
('103', '10', '98'),
('104', '10', '99'),
('1', '11', '1'),
('2', '11', '2'),
('3', '11', '2'),
('1', '12', '1'),
('10', '12', '10'),
('11', '12', '11'),
('12', '12', '12'),
('13', '12', '13'),
('14', '12', '14'),
('93', '12', '144/1'),
('15', '12', '15'),
('16', '12', '16'),
('17', '12', '17'),
('18', '12', '18'),
('19', '12', '19'),
('2', '12', '2'),
('20', '12', '20'),
('21', '12', '21'),
('22', '12', '22'),
('23', '12', '23'),
('24', '12', '24'),
('25', '12', '25'),
('26', '12', '26'),
('27', '12', '27'),
('28', '12', '28'),
('29', '12', '29'),
('3', '12', '3'),
('30', '12', '30'),
('31', '12', '31'),
('32', '12', '32'),
('33', '12', '33'),
('34', '12', '34'),
('35', '12', '35'),
('36', '12', '36'),
('37', '12', '37'),
('38', '12', '38'),
('39', '12', '39'),
('4', '12', '4'),
('40', '12', '40'),
('41', '12', '41'),
('42', '12', '42'),
('43', '12', '43'),
('44', '12', '44'),
('45', '12', '45'),
('46', '12', '46'),
('47', '12', '47'),
('48', '12', '48'),
('49', '12', '49'),
('5', '12', '5'),
('50', '12', '50'),
('51', '12', '51'),
('52', '12', '52'),
('53', '12', '53'),
('54', '12', '54'),
('55', '12', '55'),
('56', '12', '56'),
('57', '12', '57'),
('58', '12', '58'),
('59', '12', '59'),
('6', '12', '6'),
('60', '12', '60'),
('61', '12', '61'),
('62', '12', '62'),
('63', '12', '63'),
('64', '12', '64'),
('65', '12', '65'),
('66', '12', '66'),
('67', '12', '67'),
('68', '12', '68'),
('69', '12', '69'),
('7', '12', '7'),
('70', '12', '70'),
('71', '12', '71'),
('72', '12', '72'),
('73', '12', '73'),
('74', '12', '74'),
('75', '12', '75'),
('76', '12', '76'),
('77', '12', '77'),
('78', '12', '78'),
('79', '12', '79'),
('91', '12', '79.'),
('8', '12', '8'),
('80', '12', '80'),
('81', '12', '81'),
('82', '12', '82'),
('83', '12', '83'),
('84', '12', '84'),
('85', '12', '85'),
('86', '12', '86'),
('87', '12', '87'),
('88', '12', '87/1'),
('92', '12', '87/2'),
('89', '12', '88'),
('90', '12', '89'),
('9', '12', '9'),
('1', '13', 'auto'),
('2', '13', 'auto'),
('3', '13', 'auto'),
('4', '13', 'auto'),
('5', '13', 'auto'),
('6', '13', 'auto'),
('7', '13', 'auto'),
('8', '13', 'auto'),
('9', '13', 'auto'),
('10', '13', 'auto'),
('11', '13', 'auto'),
('12', '13', 'auto'),
('13', '13', 'auto'),
('14', '13', 'auto'),
('15', '13', 'auto'),
('16', '13', 'auto'),
('17', '13', 'auto'),
('18', '13', 'auto'),
('19', '13', 'auto'),
('20', '13', 'auto'),
('21', '13', 'auto'),
('22', '13', 'auto'),
('23', '13', 'auto'),
('24', '13', 'auto'),
('25', '13', 'auto'),
('26', '13', 'auto'),
('27', '13', 'auto'),
('28', '13', 'auto'),
('29', '13', 'auto'),
('30', '13', 'auto'),
('31', '13', 'auto'),
('32', '13', 'auto'),
('33', '13', 'auto'),
('34', '13', 'auto'),
('35', '13', 'auto'),
('36', '13', 'auto'),
('37', '13', 'auto'),
('38', '13', 'auto'),
('39', '13', 'auto'),
('40', '13', 'auto'),
('41', '13', 'auto'),
('42', '13', 'auto'),
('43', '13', 'auto'),
('44', '13', 'auto'),
('45', '13', 'auto'),
('46', '13', 'auto'),
('47', '13', 'auto'),
('48', '13', 'auto'),
('49', '13', 'auto'),
('50', '13', 'auto'),
('51', '13', 'auto'),
('52', '13', 'auto'),
('53', '13', 'auto'),
('54', '13', 'auto'),
('55', '13', 'auto'),
('56', '13', 'auto'),
('57', '13', 'auto'),
('58', '13', 'auto'),
('59', '13', 'auto'),
('60', '13', 'auto'),
('61', '13', 'auto'),
('62', '13', 'auto'),
('63', '13', 'auto'),
('64', '13', 'auto'),
('65', '13', 'auto'),
('66', '13', 'auto'),
('67', '13', 'auto'),
('68', '13', 'auto'),
('69', '13', 'auto'),
('70', '13', 'auto'),
('71', '13', 'auto'),
('72', '13', 'auto'),
('73', '13', 'auto'),
('74', '13', 'auto'),
('75', '13', 'auto'),
('76', '13', 'auto'),
('77', '13', 'auto'),
('78', '13', 'auto'),
('79', '13', 'auto'),
('80', '13', 'auto'),
('81', '13', 'auto'),
('82', '13', 'auto'),
('83', '13', 'auto'),
('84', '13', 'auto'),
('85', '13', 'auto'),
('86', '13', 'auto'),
('87', '13', 'auto'),
('88', '13', 'auto'),
('89', '13', 'auto'),
('90', '13', 'auto'),
('91', '13', 'auto'),
('92', '13', 'auto'),
('93', '13', 'auto'),
('94', '13', 'auto'),
('95', '13', 'auto'),
('96', '13', 'auto'),
('97', '13', 'auto'),
('98', '13', 'auto'),
('99', '13', 'auto'),
('100', '13', 'auto'),
('101', '13', 'auto'),
('102', '13', 'auto'),
('103', '13', 'auto'),
('104', '13', 'auto'),
('105', '13', 'auto'),
('106', '13', 'auto'),
('107', '13', 'auto'),
('1', '20', '1'),
('2', '20', '2'),
('3', '20', '3'),
('4', '20', '4'),
('5', '20', '5'),
('6', '20', '6'),
('7', '20', '7'),
('8', '20', '8'),
('9', '20', '9'),
('1', '22', '16'),
('2', '22', '16'),
('1', '30', 'auto'),
('2', '30', 'auto'),
('3', '30', 'auto'),
('4', '30', 'auto'),
('5', '30', 'auto'),
('6', '30', 'auto'),
('7', '30', 'auto'),
('8', '30', 'auto'),
('9', '30', 'auto'),
('10', '30', 'auto'),
('11', '30', 'auto'),
('12', '30', 'auto'),
('13', '30', 'auto'),
('14', '30', 'auto'),
('15', '30', 'auto'),
('16', '30', 'auto'),
('17', '30', 'auto'),
('18', '30', 'auto'),
('19', '30', 'auto'),
('20', '30', 'auto'),
('21', '30', 'auto'),
('22', '30', 'auto'),
('23', '30', 'auto'),
('24', '30', 'auto'),
('25', '30', 'auto'),
('26', '30', 'auto'),
('27', '30', 'auto'),
('28', '30', 'auto'),
('29', '30', 'auto'),
('30', '30', 'auto'),
('31', '30', 'auto'),
('32', '30', 'auto'),
('33', '30', 'auto'),
('34', '30', 'auto'),
('35', '30', 'auto'),
('36', '30', 'auto'),
('37', '30', 'auto'),
('38', '30', 'auto'),
('39', '30', 'auto'),
('40', '30', 'auto'),
('41', '30', 'auto'),
('42', '30', 'auto'),
('43', '30', 'auto'),
('44', '30', 'auto'),
('45', '30', 'auto'),
('46', '30', 'auto'),
('47', '30', 'auto'),
('48', '30', 'auto'),
('49', '30', 'auto'),
('50', '30', 'auto'),
('51', '30', 'auto'),
('52', '30', 'auto'),
('53', '30', 'auto'),
('54', '30', 'auto'),
('55', '30', 'auto'),
('56', '30', 'auto'),
('57', '30', 'auto'),
('58', '30', 'auto'),
('59', '30', 'auto'),
('60', '30', 'auto'),
('61', '30', 'auto'),
('62', '30', 'auto'),
('63', '30', 'auto'),
('64', '30', 'auto'),
('65', '30', 'auto'),
('66', '30', 'auto'),
('67', '30', 'auto'),
('68', '30', 'auto'),
('69', '30', 'auto'),
('70', '30', 'auto'),
('71', '30', 'auto'),
('72', '30', 'auto'),
('73', '30', 'auto'),
('74', '30', 'auto'),
('75', '30', 'auto'),
('76', '30', 'auto'),
('77', '30', 'auto'),
('78', '30', 'auto'),
('79', '30', 'auto'),
('80', '30', 'auto'),
('81', '30', 'auto'),
('82', '30', 'auto'),
('83', '30', 'auto'),
('84', '30', 'auto'),
('85', '30', 'auto'),
('86', '30', 'auto'),
('87', '30', 'auto'),
('88', '30', 'auto'),
('89', '30', 'auto'),
('90', '30', 'auto'),
('91', '30', 'auto'),
('92', '30', 'auto'),
('93', '30', 'auto'),
('94', '30', 'auto'),
('95', '30', 'auto'),
('96', '30', 'auto'),
('97', '30', 'auto'),
('98', '30', 'auto'),
('99', '30', 'auto'),
('100', '30', 'auto'),
('101', '30', 'auto'),
('102', '30', 'auto'),
('103', '30', 'auto'),
('104', '30', 'auto'),
('105', '30', 'auto'),
('106', '30', 'auto'),
('107', '30', 'auto'),
('8', '50', ''),
('9', '50', ''),
('10', '50', ''),
('11', '50', ''),
('12', '50', ''),
('13', '50', ''),
('14', '50', ''),
('15', '50', ''),
('16', '50', ''),
('17', '50', ''),
('18', '50', ''),
('19', '50', ''),
('20', '50', ''),
('21', '50', ''),
('22', '50', ''),
('23', '50', ''),
('24', '50', ''),
('25', '50', ''),
('26', '50', ''),
('27', '50', ''),
('28', '50', ''),
('29', '50', ''),
('30', '50', ''),
('31', '50', ''),
('32', '50', ''),
('33', '50', ''),
('34', '50', ''),
('35', '50', ''),
('36', '50', ''),
('37', '50', ''),
('38', '50', ''),
('39', '50', ''),
('40', '50', ''),
('41', '50', ''),
('42', '50', ''),
('43', '50', ''),
('44', '50', ''),
('45', '50', ''),
('46', '50', ''),
('47', '50', ''),
('48', '50', ''),
('49', '50', ''),
('50', '50', ''),
('51', '50', ''),
('52', '50', ''),
('53', '50', ''),
('54', '50', ''),
('55', '50', ''),
('56', '50', ''),
('57', '50', ''),
('58', '50', ''),
('59', '50', ''),
('60', '50', ''),
('61', '50', ''),
('62', '50', ''),
('63', '50', ''),
('64', '50', ''),
('65', '50', ''),
('66', '50', ''),
('67', '50', ''),
('68', '50', ''),
('69', '50', ''),
('70', '50', ''),
('71', '50', ''),
('72', '50', ''),
('73', '50', ''),
('74', '50', ''),
('75', '50', ''),
('76', '50', ''),
('77', '50', ''),
('78', '50', ''),
('79', '50', ''),
('80', '50', ''),
('81', '50', ''),
('82', '50', ''),
('83', '50', ''),
('84', '50', ''),
('85', '50', ''),
('86', '50', ''),
('87', '50', ''),
('88', '50', ''),
('89', '50', ''),
('90', '50', ''),
('91', '50', ''),
('92', '50', ''),
('93', '50', ''),
('94', '50', ''),
('95', '50', ''),
('96', '50', ''),
('97', '50', ''),
('98', '50', ''),
('99', '50', ''),
('100', '50', ''),
('101', '50', ''),
('102', '50', ''),
('103', '50', ''),
('104', '50', ''),
('105', '50', ''),
('106', '50', ''),
('107', '50', ''),
('108', '50', ''),
('109', '50', ''),
('110', '50', ''),
('111', '50', ''),
('112', '50', ''),
('113', '50', ''),
('114', '50', ''),
('115', '50', ''),
('116', '50', ''),
('117', '50', ''),
('118', '50', ''),
('119', '50', ''),
('120', '50', ''),
('121', '50', ''),
('122', '50', ''),
('123', '50', ''),
('124', '50', ''),
('125', '50', ''),
('126', '50', ''),
('127', '50', ''),
('128', '50', ''),
('129', '50', ''),
('130', '50', ''),
('131', '50', ''),
('132', '50', ''),
('133', '50', ''),
('134', '50', ''),
('135', '50', ''),
('136', '50', ''),
('137', '50', ''),
('138', '50', ''),
('139', '50', ''),
('140', '50', ''),
('141', '50', ''),
('142', '50', ''),
('143', '50', ''),
('144', '50', ''),
('145', '50', ''),
('146', '50', ''),
('147', '50', ''),
('148', '50', ''),
('149', '50', ''),
('150', '50', ''),
('151', '50', ''),
('152', '50', ''),
('153', '50', ''),
('154', '50', ''),
('155', '50', ''),
('156', '50', ''),
('157', '50', ''),
('158', '50', ''),
('159', '50', ''),
('160', '50', ''),
('161', '50', ''),
('162', '50', ''),
('163', '50', ''),
('164', '50', ''),
('165', '50', ''),
('166', '50', ''),
('167', '50', ''),
('168', '50', ''),
('169', '50', ''),
('170', '50', ''),
('171', '50', ''),
('172', '50', ''),
('173', '50', ''),
('174', '50', ''),
('175', '50', ''),
('176', '50', ''),
('177', '50', ''),
('178', '50', ''),
('179', '50', ''),
('180', '50', ''),
('181', '50', ''),
('182', '50', ''),
('183', '50', ''),
('184', '50', ''),
('185', '50', ''),
('186', '50', ''),
('187', '50', ''),
('188', '50', ''),
('189', '50', ''),
('190', '50', ''),
('281', '50', ''),
('282', '50', ''),
('283', '50', ''),
('284', '50', ''),
('285', '50', ''),
('289', '50', ''),
('290', '50', ''),
('291', '50', ''),
('451', '50', ''),
('452', '50', ''),
('453', '50', ''),
('454', '50', ''),
('455', '50', ''),
('456', '50', ''),
('457', '50', ''),
('458', '50', ''),
('459', '50', ''),
('460', '50', ''),
('461', '50', ''),
('464', '50', ''),
('469', '50', ''),
('470', '50', ''),
('471', '50', ''),
('472', '50', ''),
('473', '50', ''),
('474', '50', ''),
('475', '50', ''),
('476', '50', ''),
('477', '50', ''),
('478', '50', ''),
('479', '50', ''),
('480', '50', ''),
('481', '50', ''),
('485', '50', ''),
('486', '50', ''),
('487', '50', ''),
('488', '50', ''),
('551', '50', ''),
('552', '50', ''),
('553', '50', ''),
('554', '50', ''),
('555', '50', ''),
('556', '50', ''),
('557', '50', ''),
('558', '50', ''),
('559', '50', ''),
('560', '50', ''),
('561', '50', ''),
('562', '50', ''),
('563', '50', ''),
('564', '50', ''),
('565', '50', ''),
('567', '50', ''),
('568', '50', ''),
('569', '50', ''),
('570', '50', ''),
('571', '50', ''),
('572', '50', ''),
('573', '50', ''),
('574', '50', ''),
('577', '50', ''),
('578', '50', ''),
('579', '50', ''),
('580', '50', ''),
('582', '50', ''),
('583', '50', ''),
('584', '50', ''),
('585', '50', ''),
('590', '50', ''),
('621', '50', ''),
('622', '50', ''),
('623', '50', ''),
('624', '50', ''),
('625', '50', ''),
('626', '50', ''),
('627', '50', ''),
('642', '50', ''),
('643', '50', ''),
('644', '50', ''),
('667', '50', ''),
('671', '50', ''),
('672', '50', ''),
('750', '50', ''),
('751', '50', ''),
('752', '50', ''),
('753', '50', ''),
('754', '50', ''),
('760', '50', ''),
('761', '50', ''),
('762', '50', ''),
('763', '50', ''),
('764', '50', ''),
('765', '50', ''),
('766', '50', ''),
('767', '50', ''),
('768', '50', ''),
('769', '50', ''),
('770', '50', ''),
('771', '50', ''),
('772', '50', ''),
('773', '50', ''),
('774', '50', ''),
('775', '50', ''),
('776', '50', ''),
('777', '50', ''),
('778', '50', ''),
('779', '50', ''),
('780', '50', ''),
('781', '50', ''),
('782', '50', ''),
('783', '50', ''),
('784', '50', ''),
('785', '50', ''),
('786', '50', ''),
('787', '50', ''),
('788', '50', ''),
('789', '50', ''),
('790', '50', ''),
('791', '50', ''),
('792', '50', ''),
('793', '50', ''),
('341', '50', '0'),
('342', '50', '0'),
('343', '50', '0'),
('344', '50', '0'),
('345', '50', '0'),
('346', '50', '0'),
('347', '50', '0'),
('348', '50', '0'),
('349', '50', '0'),
('354', '50', '0'),
('355', '50', '0'),
('356', '50', '0'),
('357', '50', '0'),
('358', '50', '0'),
('359', '50', '0'),
('360', '50', '0'),
('208', '50', '0114998'),
('191', '50', '014985'),
('192', '50', '014986'),
('193', '50', '014989'),
('194', '50', '014990'),
('195', '50', '014991'),
('196', '50', '014992'),
('197', '50', '014993'),
('198', '50', '014994'),
('199', '50', '014995'),
('200', '50', '014995'),
('201', '50', '014996'),
('202', '50', '014997'),
('207', '50', '014997'),
('203', '50', '014998'),
('204', '50', '014999'),
('205', '50', '015000'),
('206', '50', '015001'),
('209', '50', '015002'),
('212', '50', '015003'),
('213', '50', '015004'),
('214', '50', '015005'),
('215', '50', '015006'),
('216', '50', '015007'),
('217', '50', '015008'),
('218', '50', '015009'),
('219', '50', '015010'),
('221', '50', '015011'),
('222', '50', '015012'),
('223', '50', '015013'),
('224', '50', '015014'),
('225', '50', '015015'),
('211', '50', '0257202'),
('220', '50', '0257207'),
('694', '50', '116716'),
('3', '50', '14953'),
('6', '50', '14954'),
('210', '50', '257201'),
('1', '50', '257208'),
('2', '50', '257209'),
('286', '50', '257232'),
('4', '50', '27'),
('5', '50', '37'),
('361', '50', '554504'),
('226', '50', '554520'),
('227', '50', '554521'),
('228', '50', '554522'),
('229', '50', '554523'),
('230', '50', '554524'),
('231', '50', '554525'),
('232', '50', '554526'),
('233', '50', '554527'),
('234', '50', '554527'),
('235', '50', '554528'),
('236', '50', '554529'),
('237', '50', '554530'),
('238', '50', '554531'),
('239', '50', '554532'),
('240', '50', '554533'),
('241', '50', '554534'),
('242', '50', '554535'),
('243', '50', '554536'),
('244', '50', '554537'),
('245', '50', '554538'),
('246', '50', '554539'),
('247', '50', '554540'),
('248', '50', '554541'),
('249', '50', '554542'),
('250', '50', '554543'),
('251', '50', '554544'),
('252', '50', '554545'),
('258', '50', '554546'),
('253', '50', '554547'),
('287', '50', '554547'),
('254', '50', '554548'),
('316', '50', '554548'),
('255', '50', '554549'),
('350', '50', '554549'),
('256', '50', '554550'),
('351', '50', '554550'),
('352', '50', '554551'),
('387', '50', '554552'),
('388', '50', '554553'),
('389', '50', '554554'),
('390', '50', '554555'),
('391', '50', '554556'),
('392', '50', '554557'),
('393', '50', '554558'),
('394', '50', '554559'),
('395', '50', '554560'),
('403', '50', '554561'),
('405', '50', '554562'),
('462', '50', '554563'),
('463', '50', '554564'),
('466', '50', '554565'),
('467', '50', '554566'),
('468', '50', '554567'),
('482', '50', '554568'),
('483', '50', '554569'),
('484', '50', '554570'),
('493', '50', '554571'),
('532', '50', '554572'),
('575', '50', '554573'),
('581', '50', '554574'),
('586', '50', '554575'),
('587', '50', '554576'),
('588', '50', '554577'),
('589', '50', '554578'),
('591', '50', '554579'),
('601', '50', '554580'),
('628', '50', '554581'),
('629', '50', '554582'),
('630', '50', '554583'),
('631', '50', '554584'),
('632', '50', '554585'),
('633', '50', '554586'),
('634', '50', '554587'),
('635', '50', '554588'),
('636', '50', '554589'),
('641', '50', '554590'),
('725', '50', '554591'),
('759', '50', '554592'),
('802', '50', '554593'),
('7', '50', '61'),
('296', '50', '638371'),
('257', '50', '638701'),
('259', '50', '638703'),
('260', '50', '638704'),
('261', '50', '638705'),
('262', '50', '638706'),
('263', '50', '638707'),
('264', '50', '638708'),
('265', '50', '638709'),
('266', '50', '638710'),
('267', '50', '638712'),
('268', '50', '638713'),
('269', '50', '638714'),
('270', '50', '638715'),
('271', '50', '638716'),
('272', '50', '638717'),
('273', '50', '638718'),
('274', '50', '638719'),
('275', '50', '638720'),
('276', '50', '638721'),
('277', '50', '638722'),
('278', '50', '638723'),
('279', '50', '638724'),
('280', '50', '638725'),
('288', '50', '638726'),
('292', '50', '638727'),
('293', '50', '638728'),
('294', '50', '638729'),
('295', '50', '638730'),
('297', '50', '638732'),
('298', '50', '638733'),
('299', '50', '638734'),
('300', '50', '638735'),
('301', '50', '638736'),
('302', '50', '638737'),
('303', '50', '638738'),
('304', '50', '638739'),
('305', '50', '638740'),
('306', '50', '638741'),
('307', '50', '638742'),
('308', '50', '638743'),
('309', '50', '638744'),
('310', '50', '638745'),
('311', '50', '638746'),
('312', '50', '638747'),
('313', '50', '638748'),
('314', '50', '638749'),
('315', '50', '638750'),
('317', '50', '690402'),
('318', '50', '690403'),
('319', '50', '690404'),
('320', '50', '690405'),
('321', '50', '690406'),
('322', '50', '690407'),
('323', '50', '690408'),
('324', '50', '690409'),
('325', '50', '690410'),
('326', '50', '690411'),
('327', '50', '690412'),
('328', '50', '690413'),
('329', '50', '690414'),
('330', '50', '690415'),
('331', '50', '690416'),
('332', '50', '690417'),
('333', '50', '690418'),
('334', '50', '690419'),
('335', '50', '690420'),
('336', '50', '690421'),
('337', '50', '690422'),
('338', '50', '690423'),
('339', '50', '690424'),
('340', '50', '690425'),
('353', '50', '690426'),
('362', '50', '690427'),
('363', '50', '690428'),
('364', '50', '690429'),
('365', '50', '690430'),
('366', '50', '690431'),
('367', '50', '690432'),
('368', '50', '690433'),
('369', '50', '690434'),
('370', '50', '690435'),
('371', '50', '690436'),
('372', '50', '690437'),
('373', '50', '690438'),
('374', '50', '690439'),
('375', '50', '690440'),
('376', '50', '690441'),
('377', '50', '690442'),
('378', '50', '690443'),
('379', '50', '690444'),
('380', '50', '690445'),
('381', '50', '690446'),
('382', '50', '690447'),
('383', '50', '690448'),
('384', '50', '690449'),
('385', '50', '690450'),
('386', '50', '727451'),
('396', '50', '727452'),
('397', '50', '727453'),
('398', '50', '727454'),
('399', '50', '727455'),
('400', '50', '727456'),
('401', '50', '727457'),
('402', '50', '727457'),
('404', '50', '727459'),
('406', '50', '727460'),
('407', '50', '727461'),
('408', '50', '727462'),
('409', '50', '727463'),
('410', '50', '727464'),
('411', '50', '727465'),
('412', '50', '727466'),
('413', '50', '727467'),
('414', '50', '727468'),
('415', '50', '727469'),
('416', '50', '727470'),
('417', '50', '727471'),
('418', '50', '727472'),
('419', '50', '727472'),
('420', '50', '727474'),
('421', '50', '727475'),
('422', '50', '727476'),
('423', '50', '727477'),
('424', '50', '727478'),
('425', '50', '727479'),
('426', '50', '727480'),
('427', '50', '727481'),
('428', '50', '727482'),
('429', '50', '727483'),
('430', '50', '727484'),
('431', '50', '727485'),
('432', '50', '727486'),
('433', '50', '727487'),
('434', '50', '727488'),
('435', '50', '727491'),
('436', '50', '727492'),
('437', '50', '727493'),
('438', '50', '727494'),
('439', '50', '727495'),
('440', '50', '727496'),
('441', '50', '727497'),
('442', '50', '727498'),
('443', '50', '727499'),
('444', '50', '727500'),
('445', '50', '779551'),
('446', '50', '779552'),
('447', '50', '779553'),
('448', '50', '779554'),
('449', '50', '779555'),
('450', '50', '779556'),
('465', '50', '779557'),
('489', '50', '779558'),
('490', '50', '779559'),
('491', '50', '779560'),
('492', '50', '779561'),
('494', '50', '779562'),
('495', '50', '779563'),
('496', '50', '779564'),
('497', '50', '779565'),
('498', '50', '779566'),
('499', '50', '779567'),
('500', '50', '779568'),
('501', '50', '779569'),
('502', '50', '779570'),
('503', '50', '779571'),
('504', '50', '779572'),
('699', '50', '779572'),
('505', '50', '779573'),
('684', '50', '779573'),
('506', '50', '779574'),
('507', '50', '779575'),
('508', '50', '779576'),
('509', '50', '779577'),
('510', '50', '779578'),
('511', '50', '779579'),
('685', '50', '779579'),
('512', '50', '779580'),
('698', '50', '779580'),
('513', '50', '779581'),
('514', '50', '779582'),
('515', '50', '779583'),
('516', '50', '779584'),
('517', '50', '779585'),
('518', '50', '779586'),
('519', '50', '779587'),
('686', '50', '779587'),
('520', '50', '779588'),
('697', '50', '779588'),
('521', '50', '779589'),
('522', '50', '779590'),
('523', '50', '779591'),
('524', '50', '779592'),
('525', '50', '779593'),
('526', '50', '779594'),
('527', '50', '779595'),
('528', '50', '779596'),
('687', '50', '779596'),
('529', '50', '779597'),
('696', '50', '779597'),
('530', '50', '779598'),
('531', '50', '779599'),
('533', '50', '779600'),
('534', '50', '816701'),
('535', '50', '816702'),
('688', '50', '816702'),
('536', '50', '816703'),
('695', '50', '816703'),
('537', '50', '816704'),
('538', '50', '816705'),
('539', '50', '816706'),
('540', '50', '816706'),
('541', '50', '816706'),
('542', '50', '816707'),
('543', '50', '816708'),
('544', '50', '816709'),
('545', '50', '816710'),
('546', '50', '816711'),
('547', '50', '816712'),
('548', '50', '816713'),
('549', '50', '816715'),
('619', '50', '816715'),
('689', '50', '816715'),
('550', '50', '816716'),
('620', '50', '816716'),
('576', '50', '816717'),
('592', '50', '816718'),
('593', '50', '816719'),
('594', '50', '816720'),
('595', '50', '816721'),
('605', '50', '816721'),
('596', '50', '816722'),
('597', '50', '816723'),
('598', '50', '816724'),
('599', '50', '816725'),
('690', '50', '816725'),
('600', '50', '816726'),
('693', '50', '816726'),
('602', '50', '816727'),
('603', '50', '816728'),
('604', '50', '816729'),
('606', '50', '816730'),
('607', '50', '816731'),
('608', '50', '816732'),
('609', '50', '816733'),
('610', '50', '816734'),
('611', '50', '816734'),
('691', '50', '816734'),
('692', '50', '816734'),
('612', '50', '816735'),
('613', '50', '816736'),
('661', '50', '816736'),
('614', '50', '816737'),
('615', '50', '816738'),
('616', '50', '816739'),
('617', '50', '816740'),
('682', '50', '816740'),
('618', '50', '816741'),
('683', '50', '816741'),
('637', '50', '816742'),
('638', '50', '816743'),
('639', '50', '816744'),
('640', '50', '816745'),
('645', '50', '816746'),
('646', '50', '816747'),
('647', '50', '816748'),
('648', '50', '816749'),
('649', '50', '816750'),
('657', '50', '816750'),
('660', '50', '816750'),
('650', '50', '870751'),
('656', '50', '870751'),
('658', '50', '870751'),
('651', '50', '870752'),
('659', '50', '870752'),
('652', '50', '870753'),
('662', '50', '870753'),
('653', '50', '870754'),
('654', '50', '870755'),
('655', '50', '870756'),
('663', '50', '870757'),
('681', '50', '870757'),
('664', '50', '870758'),
('680', '50', '870758'),
('665', '50', '870759'),
('666', '50', '870759'),
('668', '50', '870760'),
('669', '50', '870761'),
('670', '50', '870762'),
('673', '50', '870763'),
('674', '50', '870764'),
('675', '50', '870765'),
('676', '50', '870765'),
('677', '50', '870766'),
('678', '50', '870767'),
('679', '50', '870768'),
('700', '50', '870769'),
('701', '50', '870770'),
('702', '50', '870771'),
('703', '50', '870772'),
('704', '50', '870773'),
('705', '50', '870774'),
('819', '50', '870774'),
('706', '50', '870776'),
('707', '50', '870777'),
('708', '50', '870778'),
('709', '50', '870779'),
('710', '50', '870780'),
('711', '50', '870781'),
('712', '50', '870782'),
('713', '50', '870783'),
('714', '50', '870784'),
('715', '50', '870785'),
('716', '50', '870786'),
('717', '50', '870787'),
('718', '50', '870788'),
('719', '50', '870789'),
('720', '50', '870790'),
('721', '50', '870791'),
('722', '50', '870792'),
('723', '50', '870793'),
('724', '50', '870794'),
('738', '50', '870794'),
('739', '50', '870794'),
('740', '50', '870794'),
('726', '50', '870795'),
('727', '50', '870796'),
('728', '50', '870797'),
('729', '50', '870798'),
('730', '50', '870799'),
('731', '50', '870800'),
('732', '50', '910101'),
('744', '50', '910101'),
('733', '50', '910102'),
('734', '50', '910102'),
('735', '50', '910102'),
('743', '50', '910102'),
('736', '50', '910103'),
('737', '50', '910104'),
('741', '50', '910105'),
('742', '50', '910106'),
('745', '50', '910107'),
('746', '50', '910108'),
('747', '50', '910109'),
('748', '50', '910110'),
('749', '50', '910111'),
('755', '50', '910112'),
('756', '50', '910113'),
('757', '50', '910114'),
('758', '50', '910115'),
('794', '50', '910116'),
('795', '50', '910117'),
('796', '50', '910118'),
('797', '50', '910119'),
('798', '50', '910120'),
('799', '50', '910121'),
('800', '50', '910122'),
('801', '50', '910123'),
('803', '50', '910124'),
('804', '50', '910125'),
('805', '50', '910126'),
('806', '50', '910127'),
('807', '50', '910128'),
('808', '50', '910129'),
('810', '50', '910130'),
('811', '50', '910131'),
('812', '50', '910132'),
('813', '50', '910133'),
('814', '50', '910134'),
('815', '50', '910135'),
('816', '50', '910136'),
('817', '50', '910137'),
('818', '50', '910138'),
('820', '50', '910139'),
('821', '50', '910140'),
('822', '50', '910141'),
('823', '50', '910142'),
('824', '50', '910143'),
('825', '50', '910144'),
('826', '50', '910145'),
('827', '50', '910146'),
('828', '50', '910147'),
('829', '50', '910148'),
('830', '50', '910149'),
('831', '50', '910150'),
('809', '50', '925092'),
('832', '50', '946201'),
('833', '50', '946202'),
('834', '50', '946203'),
('835', '50', '946204'),
('836', '50', '946205'),
('837', '50', '946206'),
('838', '50', '946207'),
('839', '50', '946208'),
('840', '50', '946209'),
('566', '50', 'OKK ');

### Structure of table `1_requisition_details` ###

DROP TABLE IF EXISTS `1_requisition_details`;

CREATE TABLE `1_requisition_details` (
  `requisition_detail_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `requisition_id` int(11) DEFAULT NULL,
  `item_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `lpo_id` int(11) DEFAULT '0',
  `order_quantity` int(11) NOT NULL DEFAULT '0',
  `estimate_price` double NOT NULL DEFAULT '0',
  `quantity` int(11) NOT NULL DEFAULT '0',
  `price` double NOT NULL DEFAULT '0',
  `purpose` varchar(320) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`requisition_detail_id`),
  UNIQUE KEY `requisition_detail_id` (`requisition_detail_id`),
  KEY `1_requisition_details_requisition_id` (`requisition_id`),
  KEY `1_requisition_details_item_code` (`item_code`),
  KEY `1_requisition_details_supplier_id` (`supplier_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_requisition_details` ###


### Structure of table `1_requisitions` ###

DROP TABLE IF EXISTS `1_requisitions`;

CREATE TABLE `1_requisitions` (
  `requisition_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `point_of_use` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `narrative` varchar(240) COLLATE utf8_unicode_ci DEFAULT NULL,
  `application_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `completed` tinyint(4) NOT NULL DEFAULT '0',
  `processed` tinyint(4) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`requisition_id`),
  UNIQUE KEY `requisition_id` (`requisition_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_requisitions` ###


### Structure of table `1_sales_order_details` ###

DROP TABLE IF EXISTS `1_sales_order_details`;

CREATE TABLE `1_sales_order_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT '0',
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `stk_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `qty_sent` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `discount_percent` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `sorder` (`trans_type`,`order_no`)
) ENGINE=InnoDB AUTO_INCREMENT=108 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_sales_order_details` ###

INSERT INTO `1_sales_order_details` VALUES
('1', '1', '30', 'exports', 'Export of IT &amp; Customer Support Services', '1', '1100325', '1', '0'),
('2', '2', '30', 'exports', 'Export of IT &amp; Customer Support Services', '1', '1434045', '1', '0'),
('3', '3', '30', 'exports', 'Export of IT &amp; Customer Support Services', '1', '1435915', '1', '0'),
('4', '4', '30', 'exports', 'Export of IT &amp; Customer Support Services', '1', '1406415', '1', '0'),
('5', '5', '30', 'exports', 'Export of IT &amp; Customer Support Services', '1', '1415415', '1', '0'),
('6', '6', '30', 'exports', 'Export of IT &amp; Customer Support Services', '1', '1432415', '1', '0'),
('7', '7', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '1451439', '1', '0'),
('8', '8', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '1378415', '1', '0'),
('9', '9', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '1226434', '1', '0'),
('10', '10', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '1273934', '1', '0'),
('11', '11', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '1049751', '1', '0'),
('12', '12', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '1417608', '1', '0'),
('13', '13', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '1278308', '1', '0'),
('14', '14', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '1250308', '1', '0'),
('15', '15', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '1385911', '1', '0'),
('16', '16', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '1470462', '1', '0'),
('17', '17', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '1594273', '1', '0'),
('18', '18', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '10900', '0', '0'),
('19', '19', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '10900', '1', '0'),
('20', '20', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '9032', '1', '0'),
('21', '21', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '1196', '1', '0'),
('22', '22', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '10722', '1', '0'),
('23', '23', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '2193', '1', '0'),
('24', '24', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '10620', '1', '0'),
('25', '25', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '4380', '1', '0'),
('26', '26', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '10699', '1', '0'),
('27', '27', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '4344', '1', '0'),
('28', '28', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '11008', '1', '0'),
('29', '29', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '4418', '1', '0'),
('30', '30', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '10302', '1', '0'),
('31', '31', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '4386', '1', '0'),
('32', '32', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '11165', '1', '0'),
('33', '33', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '4615', '1', '0'),
('34', '34', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '12004', '1', '0'),
('35', '35', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '4747', '1', '0'),
('36', '36', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '15924', '1', '0'),
('37', '37', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '4927', '0', '0'),
('38', '38', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '18426', '0', '0'),
('39', '39', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '5097', '1', '0'),
('40', '40', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '17396', '1', '0'),
('41', '41', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '4665', '1', '0'),
('42', '42', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '4657', '1', '0'),
('43', '43', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '15962', '1', '0'),
('44', '44', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '7043', '1', '0'),
('45', '45', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '20951', '0', '0'),
('46', '46', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '19169', '1', '0'),
('47', '47', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '17178', '1', '0'),
('48', '48', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '19708', '1', '0'),
('49', '49', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '18502', '1', '0'),
('50', '50', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '18828', '1', '0'),
('51', '51', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '18134', '1', '0'),
('52', '52', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '17960', '1', '0'),
('53', '53', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '17056', '1', '0'),
('54', '54', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '15864', '1', '0'),
('55', '55', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '20027', '1', '0'),
('56', '56', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '10560', '1', '0'),
('57', '57', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '3451', '0', '0'),
('58', '58', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '3451', '0', '0'),
('59', '59', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '10951', '1', '0'),
('60', '60', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '15962', '1', '0'),
('61', '61', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '17822', '1', '0'),
('62', '62', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '21298', '0', '0'),
('63', '63', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '212450', '0', '0'),
('64', '64', '30', 'exports', '19708', '1', '19708', '1', '0'),
('65', '65', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '20530', '1', '0'),
('66', '66', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '20203', '1', '0'),
('67', '67', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '29005', '0', '0'),
('68', '68', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '20147', '1', '0'),
('69', '69', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '22340', '1', '0'),
('70', '70', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '25071', '1', '0'),
('71', '71', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '0', '0', '0'),
('72', '72', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '23042', '1', '0'),
('73', '73', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '21245', '0', '0'),
('74', '74', '30', 'exports', '400', '0', '4000', '0', '0'),
('75', '75', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '11298', '1', '0'),
('76', '76', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '11245', '1', '0'),
('77', '77', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '19055', '1', '0'),
('78', '78', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '25250', '0', '0'),
('79', '79', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '31250', '0', '0'),
('80', '80', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '28250', '1', '0'),
('81', '81', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '26926.69', '0', '0'),
('82', '82', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '30933.76', '0', '0'),
('83', '83', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '28266.76', '0', '0'),
('84', '84', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '29110.73', '0', '0'),
('85', '85', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '28209.78', '0', '0'),
('86', '86', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '27740.63', '0', '0'),
('87', '87', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '27867.67', '0', '0'),
('88', '88', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '31174.63', '0', '0'),
('89', '89', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '32631.57', '0', '0'),
('90', '90', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '38775.45', '0', '0'),
('91', '91', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '36846.36', '0', '0'),
('92', '92', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '34309.4', '0', '0'),
('93', '93', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '35943', '1', '0'),
('94', '94', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '35943', '0', '0'),
('95', '95', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '26926.69', '1', '0'),
('96', '96', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '30933.76', '1', '0'),
('97', '97', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '28266.76', '1', '0'),
('98', '98', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '29110.73', '1', '0'),
('99', '99', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '28209.78', '1', '0'),
('100', '100', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '27740.63', '1', '0'),
('101', '101', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '27867.67', '1', '0'),
('102', '102', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '31174.63', '1', '0'),
('103', '103', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '32631.57', '1', '0'),
('104', '104', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '0', '38775.45', '0', '0'),
('105', '105', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '36846.36', '1', '0'),
('106', '106', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '34309.4', '1', '0'),
('107', '107', '30', 'exports', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', '1', '20068.45', '1', '0');

### Structure of table `1_sales_orders` ###

DROP TABLE IF EXISTS `1_sales_orders`;

CREATE TABLE `1_sales_orders` (
  `order_no` int(11) NOT NULL,
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `version` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `branch_code` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `customer_ref` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `comments` tinytext COLLATE utf8_unicode_ci,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `order_type` int(11) NOT NULL DEFAULT '0',
  `ship_via` int(11) NOT NULL DEFAULT '0',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `contact_phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `deliver_to` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `freight_cost` double NOT NULL DEFAULT '0',
  `from_stk_loc` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `payment_terms` int(11) DEFAULT NULL,
  `total` double NOT NULL DEFAULT '0',
  `done_by` int(2) NOT NULL,
  PRIMARY KEY (`trans_type`,`order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_sales_orders` ###

INSERT INTO `1_sales_orders` VALUES
('1', '30', '1', '0', '1', '1', 'auto', '', NULL, '2010-11-23', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2010-12-17', '1', '1100325', '0'),
('2', '30', '1', '0', '1', '1', 'auto', '', NULL, '2010-12-13', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2011-01-17', '1', '1434045', '0'),
('3', '30', '1', '0', '1', '1', 'auto', '', NULL, '2011-01-14', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2011-02-17', '1', '1435915', '0'),
('4', '30', '1', '0', '1', '1', 'auto', '', NULL, '2011-01-14', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2011-02-17', '1', '1406415', '0'),
('5', '30', '1', '0', '1', '1', 'auto', '', NULL, '2011-01-14', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2011-02-17', '1', '1415415', '0'),
('6', '30', '1', '0', '1', '1', 'auto', '', NULL, '2011-04-27', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2011-05-17', '1', '1432415', '0'),
('7', '30', '1', '0', '1', '1', 'auto', '', NULL, '2011-05-20', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2011-05-30', '3', '1451439', '0'),
('8', '30', '1', '0', '1', '1', 'auto', '', NULL, '2011-06-20', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2011-07-17', '1', '1378415', '0'),
('9', '30', '1', '0', '1', '1', 'auto', '', NULL, '2011-07-21', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2011-08-17', '1', '1226434', '0'),
('10', '30', '1', '0', '1', '1', 'auto', '', NULL, '2011-08-22', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2011-09-17', '1', '1273934', '0'),
('11', '30', '1', '0', '1', '1', 'auto', '', NULL, '2011-09-21', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2011-10-17', '1', '1049751', '0'),
('12', '30', '1', '0', '1', '1', 'auto', '', NULL, '2011-10-21', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2011-11-17', '1', '1417608', '0'),
('13', '30', '1', '0', '1', '1', 'auto', '', NULL, '2011-11-21', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2011-12-17', '1', '1278308', '0'),
('14', '30', '1', '0', '1', '1', 'auto', '', NULL, '2011-12-20', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2012-01-17', '1', '1250308', '0'),
('15', '30', '1', '0', '1', '1', 'auto', '', NULL, '2012-01-23', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2012-02-17', '1', '1385911', '0'),
('16', '30', '1', '0', '1', '1', 'auto', '', NULL, '2012-02-20', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2012-03-17', '1', '1470462', '0'),
('17', '30', '1', '0', '1', '1', 'auto', '', NULL, '2012-03-20', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2012-04-17', '1', '1594273', '0'),
('18', '30', '1', '0', '1', '1', 'auto', '', 'Invoice for the month of April 2012 ', '2012-04-20', '2', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2012-05-17', '1', '10900', '0'),
('19', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of April 202', '2012-04-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-04-30', '3', '10900', '0'),
('20', '30', '1', '0', '2', '2', 'auto', '', 'Invoice For the month of May 2012\n\nInvolve', '2012-05-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-08-08', '3', '9032', '0'),
('21', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of May 2012\nOrange Bus', '2012-05-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-05-30', '3', '1196', '0'),
('22', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the of June 2012\nInvolve ', '2012-06-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-06-30', '3', '10722', '0'),
('23', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of June \nOrange Bus', '2012-06-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-06-30', '3', '2193', '0'),
('24', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of July 2012\nInvolve', '2012-07-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-07-30', '3', '10620', '0'),
('25', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of July 2012\nOrange Bus', '2012-07-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-07-30', '3', '4380', '0'),
('26', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of Aug 2012\nInvolve ', '2012-08-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-08-30', '3', '10699', '0'),
('27', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of Aug 2012\nOrange Bus', '2012-08-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-08-30', '3', '4344', '0'),
('28', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of Sep 2012\nInvolve', '2012-09-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-09-30', '3', '11008', '0'),
('29', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of Sep 2012\nOrange bus', '2012-09-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-09-30', '3', '4418', '0'),
('30', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of Oct 2012\nInvolve', '2012-10-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-10-30', '3', '10302', '0'),
('31', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of Oct 2012\nOrange bus', '2012-10-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-10-30', '3', '4386', '0'),
('32', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of Nov 2012\nInvolve', '2012-11-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-11-30', '3', '11165', '0'),
('33', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of Nov 2012\nOrange bus', '2012-11-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-11-30', '3', '4615', '0'),
('34', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of Dec 2012\nInvolve', '2012-12-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-12-30', '3', '12004', '0'),
('35', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of Dec 2012\nOrange Bus', '2012-12-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2012-12-30', '3', '4747', '0'),
('36', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of Jan 2013\nInvolve', '2013-01-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-01-30', '3', '15924', '0'),
('37', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of Jan 2013\nOrange bus', '2013-01-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-01-30', '3', '4927', '0'),
('38', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of Feb 2013\nInvolve', '2013-02-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-03-02', '3', '18426', '0'),
('39', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of Feb 2013\nOrange Bus', '2013-02-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-03-02', '3', '5097', '0'),
('40', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of March 2013\nInvolve', '2013-03-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-03-30', '3', '17396', '0'),
('41', '30', '1', '0', '2', '2', 'auto', '', 'Invoice for the month of March 2013\nOrange bus', '2013-03-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-03-30', '3', '4665', '0'),
('42', '30', '1', '0', '2', '2', 'auto', '', 'IT Support services provided for the month of April 2013.', '2013-04-25', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-05-05', '3', '4657', '0'),
('43', '30', '1', '0', '2', '2', 'auto', '', 'IT services provided during the month of April 2013', '2013-04-25', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-05-05', '3', '15962', '0'),
('44', '30', '1', '0', '2', '2', 'auto', '', 'IT services provided during the month of May 2013 - Orange bus', '2013-05-21', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-05-31', '3', '7043', '0'),
('45', '30', '1', '0', '2', '2', 'auto', '', 'IT services provided during the month of May 2013', '2013-05-21', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-05-31', '3', '20951', '0'),
('46', '30', '1', '0', '2', '2', 'auto', '', 'IT services provided during the month of June 2013', '2013-06-21', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-07-01', '3', '19169', '0'),
('47', '30', '1', '0', '2', '2', 'auto', '', 'IT services provided during the month of July 2013', '2013-07-22', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-08-01', '3', '17178', '0'),
('48', '30', '1', '0', '2', '2', 'auto', '', 'IT services provided during the month of August 2013', '2013-08-21', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-08-31', '3', '19708', '0'),
('49', '30', '1', '0', '2', '2', 'auto', '', 'IT services provided during the month of September 2013', '2013-09-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-09-30', '3', '18502', '0'),
('50', '30', '1', '0', '2', '2', 'auto', '', 'IT services provided during the month of October 2013', '2013-10-21', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-10-31', '3', '18828', '0'),
('51', '30', '1', '0', '2', '2', 'auto', '', 'IT services provided during the month of November 2013', '2013-11-22', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-12-02', '3', '18134', '0'),
('52', '30', '1', '0', '2', '2', 'auto', '', 'IT services provided during the month of December 2013', '2013-12-23', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-01-02', '3', '17960', '0'),
('53', '30', '1', '0', '2', '2', 'auto', '', 'IT services provided during the month of January 2014', '2014-01-22', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-02-01', '3', '17056', '0'),
('54', '30', '1', '0', '2', '2', 'auto', '', 'IT services provided during the month of February 2014', '2014-02-21', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-03-03', '3', '15864', '0'),
('55', '30', '1', '0', '2', '2', 'auto', '', 'IT services provided during the month of March 2014', '2014-03-21', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-03-31', '3', '20027', '0'),
('56', '30', '1', '0', '2', '2', 'auto', '', 'IT services provided during the month of February 2013', '2013-02-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-03-02', '3', '10560', '0'),
('57', '30', '1', '0', '1', '1', 'auto', '', 'IT Support services provided during the month of May 2013.', '2013-05-21', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2013-06-17', '1', '3451', '0'),
('58', '30', '1', '0', '2', '2', 'auto', '', 'IT support services provided during the month of May 2013', '2013-05-21', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-05-31', '3', '3451', '0'),
('59', '30', '1', '0', '2', '2', 'auto', '', 'IT support services for the month of May 2013.', '2013-05-21', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2013-05-31', '3', '10951', '0'),
('60', '30', '1', '0', '2', '2', 'auto', '', 'Services Provided for the month of April 2014', '2014-04-25', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-05-05', '3', '15962', '0'),
('61', '30', '1', '0', '2', '2', 'auto', '', 'Export Services provided for the month of May', '2014-05-25', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-06-04', '3', '17822', '0'),
('62', '30', '1', '0', '2', '2', 'auto', '', 'Export Services provided for the month of June', '2014-06-25', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-07-05', '3', '21298', '0'),
('63', '30', '1', '0', '2', '2', 'auto', '', 'Export Services provided for the month of July.', '2014-07-25', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-08-04', '3', '212450', '0'),
('64', '30', '1', '0', '2', '2', 'auto', '', 'Export Services provided for the month of August', '2014-08-25', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-09-04', '3', '19708', '0'),
('65', '30', '1', '0', '2', '2', 'auto', '', 'Export Services provided for the month of September.', '2014-09-25', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-10-05', '3', '20530', '0'),
('66', '30', '1', '0', '2', '2', 'auto', '', 'Export Services provided for the month of October 2014.', '2014-10-25', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-11-04', '3', '20203', '0'),
('67', '30', '1', '0', '2', '2', 'auto', '', 'Export Services provided for the month of November 2014', '2014-11-25', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-12-05', '3', '29005', '0'),
('68', '30', '1', '0', '2', '2', 'auto', '', 'Export Services provided for the month of December 2014', '2014-12-24', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-01-03', '3', '20147', '0'),
('69', '30', '1', '0', '2', '2', 'auto', '', 'Export Services provided for the month of January 2015', '2015-01-25', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-02-04', '3', '22340', '0'),
('70', '30', '1', '0', '2', '2', 'auto', '', 'Export Services provided for the month of February 2015', '2015-02-25', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-03-07', '3', '25071', '0'),
('71', '30', '1', '0', '2', '2', 'auto', '', NULL, '2015-10-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-10-30', '3', '0', '0'),
('72', '30', '1', '0', '2', '2', 'auto', '', 'Export services for the month of March 2015', '2015-03-25', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-04-04', '3', '23042', '0'),
('73', '30', '1', '0', '2', '2', 'auto', '', 'Money for the export services provided for the month of July 2014', '2014-07-25', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-08-04', '3', '21245', '0'),
('74', '30', '1', '0', '2', '2', 'auto', '', 'Special IT work', '2014-12-29', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-01-08', '3', '4000', '0'),
('75', '30', '1', '0', '2', '2', 'auto', '', NULL, '2014-06-28', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-07-08', '3', '11298', '0'),
('76', '30', '1', '0', '2', '2', 'auto', '', NULL, '2014-07-25', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-08-04', '3', '11245', '0'),
('77', '30', '1', '0', '2', '2', 'auto', '', NULL, '2014-11-28', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-12-08', '3', '19055', '0'),
('78', '30', '1', '0', '2', '2', 'auto', '', 'Additional support services carried out during the month', '2015-12-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-12-30', '3', '25250', '0'),
('79', '30', '1', '0', '2', '2', 'auto', '', 'Additional IT work carried out during the month.', '2014-12-21', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-12-31', '3', '31250', '0'),
('80', '30', '1', '0', '2', '2', 'auto', '', 'Additional IT services for the month of December 2014', '2014-12-21', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2014-12-31', '3', '28250', '0'),
('81', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of April 2015', '2015-04-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-04-30', '3', '26926.69', '0'),
('82', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of May 2015', '2015-05-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-05-30', '3', '30933.76', '0'),
('83', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of June 2015', '2015-06-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-06-30', '3', '28266.76', '0'),
('84', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of July 2015', '2015-07-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-07-30', '3', '29110.73', '0'),
('85', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of August 2015', '2015-08-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-08-30', '3', '28209.78', '0'),
('86', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of September 2015', '2015-09-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-09-30', '3', '27740.63', '0'),
('87', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of October 2015', '2015-10-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-10-30', '3', '27867.67', '0'),
('88', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of November 2015', '2015-11-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-11-30', '3', '31174.63', '0'),
('89', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of December 2015', '2015-12-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-12-30', '3', '32631.57', '0'),
('90', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of January 2016', '2016-01-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2016-01-30', '3', '38775.45', '0'),
('91', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of February 2016', '2016-02-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2016-03-01', '3', '36846.36', '0'),
('92', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of March 2016', '2016-03-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2016-03-30', '3', '34309.4', '0'),
('93', '30', '1', '0', '2', '2', 'auto', '', NULL, '2016-04-26', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2016-05-06', '3', '35943', '0'),
('94', '30', '1', '0', '1', '1', 'auto', '', NULL, '2016-04-26', '1', '1', '45, Broadwick Street,\nLondon WIF 9QW', NULL, NULL, 'inbay', '0', 'DEF', '2016-05-17', '1', '35943', '0'),
('95', '30', '1', '0', '2', '2', 'auto', '', NULL, '2015-04-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-04-30', '3', '26926.69', '0'),
('96', '30', '1', '0', '2', '2', 'auto', '', NULL, '2015-05-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-05-30', '3', '30933.76', '0'),
('97', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of June 2015', '2015-06-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-06-30', '3', '28266.76', '0'),
('98', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Payment for the Month Of July 2015', '2015-07-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-07-30', '3', '29110.73', '0'),
('99', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of August 2015', '2015-08-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-08-30', '3', '28209.78', '0'),
('100', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of September 2015', '2015-09-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-09-30', '3', '27740.63', '0'),
('101', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of October 2015', '2015-10-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-10-30', '3', '27867.67', '0'),
('102', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of November 2015', '2015-11-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-11-30', '3', '31174.63', '0'),
('103', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of December 2015', '2015-12-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2015-12-30', '3', '32631.57', '0'),
('104', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of January 2016', '2016-01-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2016-01-30', '3', '38775.45', '0'),
('105', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of February 2016', '2016-02-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2016-03-01', '3', '36846.36', '0'),
('106', '30', '1', '0', '2', '2', 'auto', '', 'IT Support Services Charge for the Month Of March 2016', '2016-03-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2016-03-30', '3', '34309.4', '0'),
('107', '30', '1', '0', '2', '2', 'auto', '', 'IT support services for the month of January 2016.', '2016-01-20', '2', '1', 'Mr. Kristian Wright \nDirector\nInbay Limited \n45 Broadwick Street,\nLondon W1F 9QW \n', NULL, NULL, 'Inbay Limited', '0', 'DEF', '2016-01-30', '3', '20068.45', '0');

### Structure of table `1_sales_pos` ###

DROP TABLE IF EXISTS `1_sales_pos`;

CREATE TABLE `1_sales_pos` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `pos_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `cash_sale` tinyint(1) NOT NULL,
  `credit_sale` tinyint(1) NOT NULL,
  `pos_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `pos_account` smallint(6) unsigned NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `pos_name` (`pos_name`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_sales_pos` ###

INSERT INTO `1_sales_pos` VALUES
('1', 'Default', '1', '1', 'DEF', '2', '0');

### Structure of table `1_sales_types` ###

DROP TABLE IF EXISTS `1_sales_types`;

CREATE TABLE `1_sales_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_type` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_included` int(1) NOT NULL DEFAULT '0',
  `factor` double NOT NULL DEFAULT '1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_type` (`sales_type`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_sales_types` ###

INSERT INTO `1_sales_types` VALUES
('1', 'Retail', '1', '1', '0'),
('2', 'Wholesale', '0', '0.7', '0');

### Structure of table `1_salesman` ###

DROP TABLE IF EXISTS `1_salesman`;

CREATE TABLE `1_salesman` (
  `salesman_code` int(11) NOT NULL AUTO_INCREMENT,
  `salesman_name` char(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_phone` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_fax` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `provision` double NOT NULL DEFAULT '0',
  `break_pt` double NOT NULL DEFAULT '0',
  `provision2` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`salesman_code`),
  UNIQUE KEY `salesman_name` (`salesman_name`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_salesman` ###

INSERT INTO `1_salesman` VALUES
('1', 'Sales Person', '', '', '', '5', '1000', '4', '0');

### Structure of table `1_security_roles` ###

DROP TABLE IF EXISTS `1_security_roles`;

CREATE TABLE `1_security_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sections` text COLLATE utf8_unicode_ci,
  `areas` text COLLATE utf8_unicode_ci,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `role` (`role`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_security_roles` ###

INSERT INTO `1_security_roles` VALUES
('1', 'Inquiries', 'Inquiries', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;773;774;2822;3073;3075;3076;3077;3329;3330;3331;3332;3333;3334;3335;5377;5633;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8450;8451;10497;10753;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15873;15882;16129;16130;16131;16132', '0'),
('2', 'System Administrator', 'System Administrator', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;10496;10752;11008;13056;13312;15616;15872;16128', '513;514;515;516;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15629;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132', '0'),
('3', 'Salesman', 'Salesman', '768;3072;5632;8192;15872', '773;774;3073;3075;3081;5633;8194;15873', '0'),
('4', 'Stock Manager', 'Stock Manager', '2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128', '2818;2822;3073;3076;3077;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5640;5889;5890;5891;8193;8194;8450;8451;10753;11009;11010;11012;13313;13315;15882;16129;16130;16131;16132', '0'),
('5', 'Production Manager', 'Production Manager', '512;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;2818;2819;2820;2821;2822;2823;3073;3074;3076;3077;3078;3079;3080;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5640;5640;5889;5890;5891;8193;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15876;15877;15880;15882;16129;16130;16131;16132', '0'),
('6', 'Purchase Officer', 'Purchase Officer', '512;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;2818;2819;2820;2821;2822;2823;3073;3074;3076;3077;3078;3079;3080;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5377;5633;5635;5640;5640;5889;5890;5891;8193;8194;8196;8197;8449;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15876;15877;15880;15882;16129;16130;16131;16132', '0'),
('7', 'AR Officer', 'AR Officer', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;771;773;774;2818;2819;2820;2821;2822;2823;3073;3073;3074;3075;3076;3077;3078;3079;3080;3081;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5633;5634;5637;5638;5639;5640;5640;5889;5890;5891;8193;8194;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132', '0'),
('8', 'AP Officer', 'AP Officer', '512;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;769;770;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5635;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15876;15877;15880;15882;16129;16130;16131;16132', '0'),
('9', 'Accountant', 'New Accountant', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;10752;11008;13312;15616;15872;16128', '769;771;772;773;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15626;15627;15629;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;549988;549989;549990;615524;615525;812132;1008740;1074276;1533028', '0'),
('10', 'Sub Admin', 'Sub Admin', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5637;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15873;15874;15876;15877;15878;15879;15880;15882;16129;16130;16131;16132', '0');

### Structure of table `1_shippers` ###

DROP TABLE IF EXISTS `1_shippers`;

CREATE TABLE `1_shippers` (
  `shipper_id` int(11) NOT NULL AUTO_INCREMENT,
  `shipper_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`shipper_id`),
  UNIQUE KEY `name` (`shipper_name`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_shippers` ###

INSERT INTO `1_shippers` VALUES
('1', 'Default', '', '', '', '', '0');

### Structure of table `1_sql_trail` ###

DROP TABLE IF EXISTS `1_sql_trail`;

CREATE TABLE `1_sql_trail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sql` text COLLATE utf8_unicode_ci NOT NULL,
  `result` tinyint(1) NOT NULL,
  `msg` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_sql_trail` ###


### Structure of table `1_stock_category` ###

DROP TABLE IF EXISTS `1_stock_category`;

CREATE TABLE `1_stock_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_tax_type` int(11) NOT NULL DEFAULT '1',
  `dflt_units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `dflt_mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `dflt_sales_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_cogs_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_inventory_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_adjustment_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_assembly_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_dim1` int(11) DEFAULT NULL,
  `dflt_dim2` int(11) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `dflt_no_sale` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_stock_category` ###

INSERT INTO `1_stock_category` VALUES
('1', 'Components', '1', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0'),
('2', 'Charges', '1', 'each', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0'),
('3', 'Systems', '1', 'each', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0'),
('4', 'Services', '1', 'ea.', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0');

### Structure of table `1_stock_master` ###

DROP TABLE IF EXISTS `1_stock_master`;

CREATE TABLE `1_stock_master` (
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `long_description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cogs_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inventory_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `adjustment_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `assembly_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` int(11) DEFAULT NULL,
  `dimension2_id` int(11) DEFAULT NULL,
  `actual_cost` double NOT NULL DEFAULT '0',
  `last_cost` double NOT NULL DEFAULT '0',
  `material_cost` double NOT NULL DEFAULT '0',
  `labour_cost` double NOT NULL DEFAULT '0',
  `overhead_cost` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `no_sale` tinyint(1) NOT NULL DEFAULT '0',
  `editable` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_stock_master` ###

INSERT INTO `1_stock_master` VALUES
('exports', '4', '1', 'Export of IT &amp; Customer Support Services for the Inbay Limited customers in UK.', 'Export of IT support services and Customer Support services for the Month.', 'ea.', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1');

### Structure of table `1_stock_moves` ###

DROP TABLE IF EXISTS `1_stock_moves`;

CREATE TABLE `1_stock_moves` (
  `trans_id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` smallint(6) NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `person_id` int(11) DEFAULT NULL,
  `price` double NOT NULL DEFAULT '0',
  `reference` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT '1',
  `discount_percent` double NOT NULL DEFAULT '0',
  `standard_cost` double NOT NULL DEFAULT '0',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`trans_id`),
  KEY `type` (`type`,`trans_no`),
  KEY `Move` (`stock_id`,`loc_code`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=140 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_stock_moves` ###

INSERT INTO `1_stock_moves` VALUES
('1', '1', 'exports', '13', 'DEF', '2010-11-23', '0', '1100325', 'auto', '-1', '0', '0', '1'),
('2', '2', 'exports', '13', 'DEF', '2010-12-13', '0', '1434045', 'auto', '-1', '0', '0', '1'),
('3', '3', 'exports', '13', 'DEF', '2011-01-14', '0', '1435915', 'auto', '-1', '0', '0', '1'),
('4', '4', 'exports', '13', 'DEF', '2011-01-14', '0', '1406415', 'auto', '-1', '0', '0', '1'),
('5', '5', 'exports', '13', 'DEF', '2011-01-14', '0', '1415415', 'auto', '-1', '0', '0', '1'),
('6', '6', 'exports', '13', 'DEF', '2011-04-27', '0', '1432415', 'auto', '-1', '0', '0', '1'),
('7', '7', 'exports', '13', 'DEF', '2011-05-20', '0', '1451439', 'auto', '-1', '0', '0', '1'),
('8', '8', 'exports', '13', 'DEF', '2011-06-20', '0', '1378415', 'auto', '-1', '0', '0', '1'),
('9', '9', 'exports', '13', 'DEF', '2011-07-21', '0', '1226434', 'auto', '-1', '0', '0', '1'),
('10', '10', 'exports', '13', 'DEF', '2011-08-22', '0', '1273934', 'auto', '-1', '0', '0', '1'),
('11', '11', 'exports', '13', 'DEF', '2011-09-21', '0', '1049751', 'auto', '-1', '0', '0', '1'),
('12', '12', 'exports', '13', 'DEF', '2011-10-21', '0', '1417608', 'auto', '-1', '0', '0', '1'),
('13', '13', 'exports', '13', 'DEF', '2011-11-21', '0', '1278308', 'auto', '-1', '0', '0', '1'),
('14', '14', 'exports', '13', 'DEF', '2011-12-20', '0', '1250308', 'auto', '-1', '0', '0', '1'),
('15', '15', 'exports', '13', 'DEF', '2012-01-23', '0', '1385911', 'auto', '-1', '0', '0', '1'),
('16', '16', 'exports', '13', 'DEF', '2012-02-20', '0', '1470462', 'auto', '-1', '0', '0', '1'),
('17', '17', 'exports', '13', 'DEF', '2012-03-20', '0', '1594273', 'auto', '-1', '0', '0', '1'),
('18', '18', 'exports', '13', 'DEF', '2012-04-20', '0', '10900', 'auto', '-1', '0', '0', '1'),
('19', '19', 'exports', '13', 'DEF', '2012-04-20', '0', '10900', 'auto', '-1', '0', '0', '1'),
('20', '1', 'exports', '11', 'DEF', '2012-04-20', '0', '10900', 'Return Ex Inv: 18', '1', '0', '0', '0'),
('21', '20', 'exports', '13', 'DEF', '2012-05-20', '0', '9032', 'auto', '-1', '0', '0', '1'),
('22', '21', 'exports', '13', 'DEF', '2012-05-20', '0', '1196', 'auto', '-1', '0', '0', '1'),
('23', '22', 'exports', '13', 'DEF', '2012-06-20', '0', '10722', 'auto', '-1', '0', '0', '1'),
('24', '23', 'exports', '13', 'DEF', '2012-06-20', '0', '2193', 'auto', '-1', '0', '0', '1'),
('25', '24', 'exports', '13', 'DEF', '2012-07-20', '0', '10620', 'auto', '-1', '0', '0', '1'),
('26', '25', 'exports', '13', 'DEF', '2012-07-20', '0', '4380', 'auto', '-1', '0', '0', '1'),
('27', '26', 'exports', '13', 'DEF', '2012-08-20', '0', '10699', 'auto', '-1', '0', '0', '1'),
('28', '27', 'exports', '13', 'DEF', '2012-08-20', '0', '4344', 'auto', '-1', '0', '0', '1'),
('29', '28', 'exports', '13', 'DEF', '2012-09-20', '0', '11008', 'auto', '-1', '0', '0', '1'),
('30', '29', 'exports', '13', 'DEF', '2012-09-20', '0', '4418', 'auto', '-1', '0', '0', '1'),
('31', '30', 'exports', '13', 'DEF', '2012-10-20', '0', '10302', 'auto', '-1', '0', '0', '1'),
('32', '31', 'exports', '13', 'DEF', '2012-10-20', '0', '4386', 'auto', '-1', '0', '0', '1'),
('33', '32', 'exports', '13', 'DEF', '2012-11-20', '0', '11165', 'auto', '-1', '0', '0', '1'),
('34', '33', 'exports', '13', 'DEF', '2012-11-20', '0', '4615', 'auto', '-1', '0', '0', '1'),
('35', '34', 'exports', '13', 'DEF', '2012-12-20', '0', '12004', 'auto', '-1', '0', '0', '1'),
('36', '35', 'exports', '13', 'DEF', '2012-12-20', '0', '4747', 'auto', '-1', '0', '0', '1'),
('37', '36', 'exports', '13', 'DEF', '2013-01-20', '0', '15924', 'auto', '-1', '0', '0', '1'),
('38', '37', 'exports', '13', 'DEF', '2013-01-20', '0', '4927', 'auto', '-1', '0', '0', '1'),
('39', '38', 'exports', '13', 'DEF', '2013-02-20', '0', '18426', 'auto', '-1', '0', '0', '1'),
('40', '39', 'exports', '13', 'DEF', '2013-02-20', '0', '5097', 'auto', '-1', '0', '0', '1'),
('41', '40', 'exports', '13', 'DEF', '2013-03-20', '0', '17396', 'auto', '-1', '0', '0', '1'),
('42', '41', 'exports', '13', 'DEF', '2013-03-20', '0', '4665', 'auto', '-1', '0', '0', '1'),
('43', '18', 'exports', '13', 'DEF', '2012-04-20', '0', '10900', 'auto', '1', '0', '0', '1'),
('44', '37', 'exports', '13', 'DEF', '2013-01-20', '0', '4927', 'auto', '1', '0', '0', '1'),
('45', '38', 'exports', '13', 'DEF', '2013-02-20', '0', '18426', 'auto', '1', '0', '0', '1'),
('46', '42', 'exports', '13', 'DEF', '2013-04-25', '0', '4657', 'auto', '-1', '0', '0', '1'),
('47', '43', 'exports', '13', 'DEF', '2013-04-25', '0', '15962', 'auto', '-1', '0', '0', '1'),
('48', '44', 'exports', '13', 'DEF', '2013-05-21', '0', '7043', 'auto', '-1', '0', '0', '1'),
('49', '45', 'exports', '13', 'DEF', '2013-05-21', '0', '20951', 'auto', '-1', '0', '0', '1'),
('50', '46', 'exports', '13', 'DEF', '2013-06-21', '0', '19169', 'auto', '-1', '0', '0', '1'),
('51', '47', 'exports', '13', 'DEF', '2013-07-22', '0', '17178', 'auto', '-1', '0', '0', '1'),
('52', '48', 'exports', '13', 'DEF', '2013-08-21', '0', '19708', 'auto', '-1', '0', '0', '1'),
('53', '49', 'exports', '13', 'DEF', '2013-09-20', '0', '18502', 'auto', '-1', '0', '0', '1'),
('54', '50', 'exports', '13', 'DEF', '2013-10-21', '0', '18828', 'auto', '-1', '0', '0', '1'),
('55', '51', 'exports', '13', 'DEF', '2013-11-22', '0', '18134', 'auto', '-1', '0', '0', '1'),
('56', '52', 'exports', '13', 'DEF', '2013-12-23', '0', '17960', 'auto', '-1', '0', '0', '1'),
('57', '53', 'exports', '13', 'DEF', '2014-01-22', '0', '17056', 'auto', '-1', '0', '0', '1'),
('58', '54', 'exports', '13', 'DEF', '2014-02-21', '0', '15864', 'auto', '-1', '0', '0', '1'),
('59', '55', 'exports', '13', 'DEF', '2014-03-21', '0', '20027', 'auto', '-1', '0', '0', '1'),
('60', '56', 'exports', '13', 'DEF', '2013-02-20', '0', '10560', 'auto', '-1', '0', '0', '1'),
('61', '45', 'exports', '13', 'DEF', '2013-05-21', '0', '20951', 'auto', '1', '0', '0', '1'),
('62', '57', 'exports', '13', 'DEF', '2013-05-21', '0', '3451', 'auto', '-1', '0', '0', '1'),
('63', '57', 'exports', '13', 'DEF', '2013-05-21', '0', '3451', 'auto', '1', '0', '0', '1'),
('64', '58', 'exports', '13', 'DEF', '2013-05-21', '0', '3451', 'auto', '-1', '0', '0', '1'),
('65', '58', 'exports', '13', 'DEF', '2013-05-21', '0', '3451', 'auto', '1', '0', '0', '1'),
('66', '59', 'exports', '13', 'DEF', '2013-05-21', '0', '10951', 'auto', '-1', '0', '0', '1'),
('67', '60', 'exports', '13', 'DEF', '2014-04-25', '0', '15962', 'auto', '-1', '0', '0', '1'),
('68', '61', 'exports', '13', 'DEF', '2014-05-25', '0', '17822', 'auto', '-1', '0', '0', '1'),
('69', '62', 'exports', '13', 'DEF', '2014-06-25', '0', '21298', 'auto', '-1', '0', '0', '1'),
('70', '63', 'exports', '13', 'DEF', '2014-07-25', '0', '212450', 'auto', '-1', '0', '0', '1'),
('71', '64', 'exports', '13', 'DEF', '2014-08-25', '0', '19708', 'auto', '-1', '0', '0', '1'),
('72', '65', 'exports', '13', 'DEF', '2014-09-25', '0', '20530', 'auto', '-1', '0', '0', '1'),
('73', '66', 'exports', '13', 'DEF', '2014-10-25', '0', '20203', 'auto', '-1', '0', '0', '1'),
('74', '67', 'exports', '13', 'DEF', '2014-11-25', '0', '29005', 'auto', '-1', '0', '0', '1'),
('75', '68', 'exports', '13', 'DEF', '2014-12-24', '0', '20147', 'auto', '-1', '0', '0', '1'),
('76', '69', 'exports', '13', 'DEF', '2015-01-25', '0', '22340', 'auto', '-1', '0', '0', '1'),
('77', '70', 'exports', '13', 'DEF', '2015-02-25', '0', '25071', 'auto', '-1', '0', '0', '1'),
('78', '71', 'exports', '13', 'DEF', '2015-10-20', '0', '0', 'auto', '-1', '0', '0', '1'),
('79', '71', 'exports', '13', 'DEF', '2015-10-20', '0', '0', 'auto', '1', '0', '0', '1'),
('80', '72', 'exports', '13', 'DEF', '2015-03-25', '0', '23042', 'auto', '-1', '0', '0', '1'),
('81', '63', 'exports', '13', 'DEF', '2014-07-25', '0', '212450', 'auto', '1', '0', '0', '1'),
('82', '73', 'exports', '13', 'DEF', '2014-07-25', '0', '21245', 'auto', '-1', '0', '0', '1'),
('83', '74', 'exports', '13', 'DEF', '2014-12-29', '0', '4000', 'auto', '-1', '0', '0', '1'),
('84', '62', 'exports', '13', 'DEF', '2014-06-25', '0', '21298', 'auto', '1', '0', '0', '1'),
('85', '73', 'exports', '13', 'DEF', '2014-07-25', '0', '21245', 'auto', '1', '0', '0', '1'),
('86', '67', 'exports', '13', 'DEF', '2014-11-25', '0', '29005', 'auto', '1', '0', '0', '1'),
('87', '75', 'exports', '13', 'DEF', '2014-06-28', '0', '11298', 'auto', '-1', '0', '0', '1'),
('88', '76', 'exports', '13', 'DEF', '2014-07-25', '0', '11245', 'auto', '-1', '0', '0', '1'),
('89', '77', 'exports', '13', 'DEF', '2014-11-28', '0', '19055', 'auto', '-1', '0', '0', '1'),
('90', '74', 'exports', '13', 'DEF', '2014-12-29', '0', '4000', 'auto', '1', '0', '0', '1'),
('91', '2', 'exports', '11', 'DEF', '2016-03-28', '0', '3.4', 'Return', '1', '0', '0', '0'),
('92', '2', 'exports', '11', 'DEF', '2016-03-28', '0', '3.4', 'Return', '-1', '0', '0', '0'),
('93', '3', 'exports', '11', 'DEF', '2015-03-28', '0', '3.4', 'Return', '1', '0', '0', '0'),
('94', '78', 'exports', '13', 'DEF', '2015-12-20', '0', '25250', 'auto', '-1', '0', '0', '1'),
('95', '79', 'exports', '13', 'DEF', '2014-12-21', '0', '31250', 'auto', '-1', '0', '0', '1'),
('96', '80', 'exports', '13', 'DEF', '2014-12-21', '0', '28250', 'auto', '-1', '0', '0', '1'),
('97', '78', 'exports', '13', 'DEF', '2015-12-20', '0', '25250', 'auto', '1', '0', '0', '1'),
('98', '79', 'exports', '13', 'DEF', '2014-12-21', '0', '31250', 'auto', '1', '0', '0', '1'),
('99', '81', 'exports', '13', 'DEF', '2015-04-20', '0', '26926.69', 'auto', '-1', '0', '0', '1'),
('100', '82', 'exports', '13', 'DEF', '2015-05-20', '0', '30933.76', 'auto', '-1', '0', '0', '1'),
('101', '83', 'exports', '13', 'DEF', '2015-06-20', '0', '28266.76', 'auto', '-1', '0', '0', '1'),
('102', '84', 'exports', '13', 'DEF', '2015-07-20', '0', '29110.73', 'auto', '-1', '0', '0', '1'),
('103', '85', 'exports', '13', 'DEF', '2015-08-20', '0', '28209.78', 'auto', '-1', '0', '0', '1'),
('104', '86', 'exports', '13', 'DEF', '2015-09-20', '0', '27740.63', 'auto', '-1', '0', '0', '1'),
('105', '87', 'exports', '13', 'DEF', '2015-10-20', '0', '27867.67', 'auto', '-1', '0', '0', '1'),
('106', '88', 'exports', '13', 'DEF', '2015-11-20', '0', '31174.63', 'auto', '-1', '0', '0', '1'),
('107', '89', 'exports', '13', 'DEF', '2015-12-20', '0', '32631.57', 'auto', '-1', '0', '0', '1'),
('108', '90', 'exports', '13', 'DEF', '2016-01-20', '0', '38775.45', 'auto', '-1', '0', '0', '1'),
('109', '91', 'exports', '13', 'DEF', '2016-02-20', '0', '36846.36', 'auto', '-1', '0', '0', '1'),
('110', '92', 'exports', '13', 'DEF', '2016-03-20', '0', '34309.4', 'auto', '-1', '0', '0', '1'),
('111', '93', 'exports', '13', 'DEF', '2016-04-26', '0', '35943', 'auto', '-1', '0', '0', '1'),
('112', '94', 'exports', '13', 'DEF', '2016-04-26', '0', '35943', 'auto', '-1', '0', '0', '1'),
('113', '94', 'exports', '13', 'DEF', '2016-04-26', '0', '35943', 'auto', '1', '0', '0', '1'),
('114', '81', 'exports', '13', 'DEF', '2015-04-20', '0', '26926.69', 'auto', '1', '0', '0', '1'),
('115', '95', 'exports', '13', 'DEF', '2015-04-20', '0', '26926.69', 'auto', '-1', '0', '0', '1'),
('116', '82', 'exports', '13', 'DEF', '2015-05-20', '0', '30933.76', 'auto', '1', '0', '0', '1'),
('117', '96', 'exports', '13', 'DEF', '2015-05-20', '0', '30933.76', 'auto', '-1', '0', '0', '1'),
('118', '83', 'exports', '13', 'DEF', '2015-06-20', '0', '28266.76', 'auto', '1', '0', '0', '1'),
('119', '97', 'exports', '13', 'DEF', '2015-06-20', '0', '28266.76', 'auto', '-1', '0', '0', '1'),
('120', '84', 'exports', '13', 'DEF', '2015-07-20', '0', '29110.73', 'auto', '1', '0', '0', '1'),
('121', '98', 'exports', '13', 'DEF', '2015-07-20', '0', '29110.73', 'auto', '-1', '0', '0', '1'),
('122', '85', 'exports', '13', 'DEF', '2015-08-20', '0', '28209.78', 'auto', '1', '0', '0', '1'),
('123', '99', 'exports', '13', 'DEF', '2015-08-20', '0', '28209.78', 'auto', '-1', '0', '0', '1'),
('124', '86', 'exports', '13', 'DEF', '2015-09-20', '0', '27740.63', 'auto', '1', '0', '0', '1'),
('125', '100', 'exports', '13', 'DEF', '2015-09-20', '0', '27740.63', 'auto', '-1', '0', '0', '1'),
('126', '87', 'exports', '13', 'DEF', '2015-10-20', '0', '27867.67', 'auto', '1', '0', '0', '1'),
('127', '101', 'exports', '13', 'DEF', '2015-10-20', '0', '27867.67', 'auto', '-1', '0', '0', '1'),
('128', '88', 'exports', '13', 'DEF', '2015-11-20', '0', '31174.63', 'auto', '1', '0', '0', '1'),
('129', '102', 'exports', '13', 'DEF', '2015-11-20', '0', '31174.63', 'auto', '-1', '0', '0', '1'),
('130', '89', 'exports', '13', 'DEF', '2015-12-20', '0', '32631.57', 'auto', '1', '0', '0', '1'),
('131', '103', 'exports', '13', 'DEF', '2015-12-20', '0', '32631.57', 'auto', '-1', '0', '0', '1'),
('132', '90', 'exports', '13', 'DEF', '2016-01-20', '0', '38775.45', 'auto', '1', '0', '0', '1'),
('133', '104', 'exports', '13', 'DEF', '2016-01-20', '0', '38775.45', 'auto', '-1', '0', '0', '1'),
('134', '91', 'exports', '13', 'DEF', '2016-02-20', '0', '36846.36', 'auto', '1', '0', '0', '1'),
('135', '105', 'exports', '13', 'DEF', '2016-02-20', '0', '36846.36', 'auto', '-1', '0', '0', '1'),
('136', '92', 'exports', '13', 'DEF', '2016-03-20', '0', '34309.4', 'auto', '1', '0', '0', '1'),
('137', '106', 'exports', '13', 'DEF', '2016-03-20', '0', '34309.4', 'auto', '-1', '0', '0', '1'),
('138', '104', 'exports', '13', 'DEF', '2016-01-20', '0', '38775.45', 'auto', '1', '0', '0', '1'),
('139', '107', 'exports', '13', 'DEF', '2016-01-20', '0', '20068.45', 'auto', '-1', '0', '0', '1');

### Structure of table `1_supp_allocations` ###

DROP TABLE IF EXISTS `1_supp_allocations`;

CREATE TABLE `1_supp_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  `chk_no` int(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_supp_allocations` ###

INSERT INTO `1_supp_allocations` VALUES
('10', '40176.94', '2012-03-20', '2', '22', '1', '20', '257209'),
('11', '8214.29', '2012-03-20', '2', '22', '2', '20', '257209'),
('12', '21449.54', '2012-03-20', '2', '22', '3', '20', '257209'),
('13', '18183.88', '2012-03-20', '2', '22', '4', '20', '257209'),
('14', '33263.27', '2012-03-20', '2', '22', '5', '20', '257209'),
('15', '15600', '2012-03-20', '2', '22', '6', '20', '257209'),
('16', '43444.9', '2012-03-20', '2', '22', '7', '20', '257209'),
('17', '35177.55', '2012-03-20', '2', '22', '8', '20', '257209'),
('18', '5416.38', '2012-03-20', '2', '22', '9', '20', '257209');

### Structure of table `1_supp_invoice_items` ###

DROP TABLE IF EXISTS `1_supp_invoice_items`;

CREATE TABLE `1_supp_invoice_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_trans_no` int(11) DEFAULT NULL,
  `supp_trans_type` int(11) DEFAULT NULL,
  `gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `grn_item_id` int(11) DEFAULT NULL,
  `po_detail_item_id` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `quantity` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `unit_tax` double NOT NULL DEFAULT '0',
  `memo_` tinytext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`supp_trans_type`,`supp_trans_no`,`stock_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_supp_invoice_items` ###

INSERT INTO `1_supp_invoice_items` VALUES
('1', '1', '20', '5470', '0', '0', '', NULL, '0', '37454.94', '0', NULL),
('2', '1', '20', '1220', '0', '0', '', NULL, '0', '2722', '0', NULL),
('3', '2', '20', '5470', '0', '0', '', NULL, '0', '8214.29', '0', NULL),
('4', '3', '20', '5470', '0', '0', '', NULL, '0', '18919.54', '0', NULL),
('5', '3', '20', '1220', '0', '0', '', NULL, '0', '2530', '0', NULL),
('6', '4', '20', '5470', '0', '0', '', NULL, '0', '18183.88', '0', NULL),
('7', '5', '20', '5470', '0', '0', '', NULL, '0', '29663.27', '0', NULL),
('8', '5', '20', '1220', '0', '0', '', NULL, '0', '3600', '0', NULL),
('9', '6', '20', '5470', '0', '0', '', NULL, '0', '13700', '0', NULL),
('10', '6', '20', '1220', '0', '0', '', NULL, '0', '1900', '0', NULL),
('11', '7', '20', '5470', '0', '0', '', NULL, '0', '41608.9', '0', NULL),
('12', '7', '20', '1220', '0', '0', '', NULL, '0', '1836', '0', NULL),
('13', '8', '20', '5470', '0', '0', '', NULL, '0', '33277.55', '0', NULL),
('14', '8', '20', '1220', '0', '0', '', NULL, '0', '1900', '0', NULL),
('15', '9', '20', '5470', '0', '0', '', NULL, '0', '5416.38', '0', NULL);

### Structure of table `1_supp_trans` ###

DROP TABLE IF EXISTS `1_supp_trans`;

CREATE TABLE `1_supp_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `supplier_id` int(11) unsigned DEFAULT NULL,
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `ov_amount` double NOT NULL DEFAULT '0',
  `ov_discount` double NOT NULL DEFAULT '0',
  `ov_gst` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  `alloc` double NOT NULL DEFAULT '0',
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`type`,`trans_no`),
  KEY `supplier_id` (`supplier_id`),
  KEY `SupplierID_2` (`supplier_id`,`supp_reference`),
  KEY `type` (`type`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_supp_trans` ###

INSERT INTO `1_supp_trans` VALUES
('1', '20', '1', '1', '1203011', '2012-03-20', '2012-04-30', '40176.94', '0', '0', '1', '40176.94', '0'),
('2', '20', '1', '2', '12013010', '2012-03-20', '2012-04-30', '8214.29', '0', '0', '1', '8214.29', '0'),
('3', '20', '1', '3', '1201095', '2012-03-20', '2012-04-30', '21449.54', '0', '0', '1', '21449.54', '0'),
('4', '20', '1', '4', '1201094', '2012-03-20', '2012-04-30', '18183.88', '0', '0', '1', '18183.88', '0'),
('5', '20', '1', '5', '1201079', '2012-03-20', '2012-04-30', '33263.27', '0', '0', '1', '33263.27', '0'),
('6', '20', '1', '6', '1201050', '2012-03-20', '2012-04-30', '15600', '0', '0', '1', '15600', '0'),
('7', '20', '1', '7', '1201048', '2012-03-20', '2012-04-30', '43444.9', '0', '0', '1', '43444.9', '0'),
('8', '20', '1', '8', '1201045', '2012-03-20', '2012-04-30', '35177.55', '0', '0', '1', '35177.55', '0'),
('9', '20', '1', '9', '1203012', '2012-03-20', '2012-04-30', '5416.38', '0', '0', '1', '5416.38', '0'),
('1', '22', '1', '16', '', '2012-03-20', '2012-03-20', '0', '0', '0', '1', '0', '0'),
('2', '22', '1', '16', '', '2012-03-20', '2012-03-20', '-220926.75', '0', '0', '1', '220926.75', '0');

### Structure of table `1_suppliers` ###

DROP TABLE IF EXISTS `1_suppliers`;

CREATE TABLE `1_suppliers` (
  `supplier_id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supp_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `gst_no` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supp_account_no` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `website` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  `dimension_id` int(11) DEFAULT '0',
  `dimension2_id` int(11) DEFAULT '0',
  `tax_group_id` int(11) DEFAULT NULL,
  `credit_limit` double NOT NULL DEFAULT '0',
  `purchase_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payable_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`supplier_id`),
  KEY `supp_ref` (`supp_ref`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_suppliers` ###

INSERT INTO `1_suppliers` VALUES
('1', 'Highlevel Express(Pvt)Ltd.', 'highlevel', '274, Old Road,\nNawinna\nMaharagama.', '', '', '', '', '', '', 'Rs.', '2', '0', '0', '0', '2', '500000', '5470', '2100', '5060', '', '0');

### Structure of table `1_sys_prefs` ###

DROP TABLE IF EXISTS `1_sys_prefs`;

CREATE TABLE `1_sys_prefs` (
  `name` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `length` smallint(6) DEFAULT NULL,
  `value` tinytext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`name`),
  KEY `category` (`category`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_sys_prefs` ###

INSERT INTO `1_sys_prefs` VALUES
('coy_name', 'setup.company', 'varchar', '60', 'Involve 360 (Pvt) Ltd.'),
('gst_no', 'setup.company', 'varchar', '25', NULL),
('coy_no', 'setup.company', 'varchar', '25', NULL),
('tax_prd', 'setup.company', 'int', '11', '1'),
('tax_last', 'setup.company', 'int', '11', '1'),
('postal_address', 'setup.company', 'tinytext', '0', '428, R.A.De Mel Mawatha\r\nColombo 3.'),
('phone', 'setup.company', 'varchar', '30', '094 5631032'),
('fax', 'setup.company', 'varchar', '30', '094 7392830'),
('email', 'setup.company', 'varchar', '100', 'kplp@evolve-sl.com'),
('coy_logo', 'setup.company', 'varchar', '100', NULL),
('domicile', 'setup.company', 'varchar', '55', NULL),
('curr_default', 'setup.company', 'char', '3', 'Rs.'),
('use_dimension', 'setup.company', 'tinyint', '1', '1'),
('f_year', 'setup.company', 'int', '11', '7'),
('no_item_list', 'setup.company', 'tinyint', '1', '0'),
('no_customer_list', 'setup.company', 'tinyint', '1', '0'),
('no_supplier_list', 'setup.company', 'tinyint', '1', '0'),
('base_sales', 'setup.company', 'int', '11', '1'),
('time_zone', 'setup.company', 'tinyint', '1', '0'),
('add_pct', 'setup.company', 'int', '5', '-1'),
('round_to', 'setup.company', 'int', '5', '1'),
('login_tout', 'setup.company', 'smallint', '6', '2600'),
('past_due_days', 'glsetup.general', 'int', '11', '30'),
('profit_loss_year_act', 'glsetup.general', 'varchar', '15', '9990'),
('retained_earnings_act', 'glsetup.general', 'varchar', '15', '3590'),
('bank_charge_act', 'glsetup.general', 'varchar', '15', '5690'),
('exchange_diff_act', 'glsetup.general', 'varchar', '15', '4450'),
('default_credit_limit', 'glsetup.customer', 'int', '11', '1000'),
('accumulate_shipping', 'glsetup.customer', 'tinyint', '1', '0'),
('legal_text', 'glsetup.customer', 'tinytext', '0', NULL),
('freight_act', 'glsetup.customer', 'varchar', '15', '4430'),
('debtors_act', 'glsetup.sales', 'varchar', '15', '1200'),
('default_sales_act', 'glsetup.sales', 'varchar', '15', '4010'),
('default_sales_discount_act', 'glsetup.sales', 'varchar', '15', '4510'),
('default_prompt_payment_act', 'glsetup.sales', 'varchar', '15', '4500'),
('default_delivery_required', 'glsetup.sales', 'smallint', '6', '1'),
('default_dim_required', 'glsetup.dims', 'int', '11', '20'),
('pyt_discount_act', 'glsetup.purchase', 'varchar', '15', '5060'),
('creditors_act', 'glsetup.purchase', 'varchar', '15', '2100'),
('po_over_receive', 'glsetup.purchase', 'int', '11', '10'),
('po_over_charge', 'glsetup.purchase', 'int', '11', '10'),
('allow_negative_stock', 'glsetup.inventory', 'tinyint', '1', '0'),
('default_inventory_act', 'glsetup.items', 'varchar', '15', '1510'),
('default_cogs_act', 'glsetup.items', 'varchar', '15', '5010'),
('default_adj_act', 'glsetup.items', 'varchar', '15', '5040'),
('default_inv_sales_act', 'glsetup.items', 'varchar', '15', '4010'),
('default_assembly_act', 'glsetup.items', 'varchar', '15', '1530'),
('default_workorder_required', 'glsetup.manuf', 'int', '11', '20'),
('version_id', 'system', 'varchar', '11', '2.3rc'),
('auto_curr_reval', 'setup.company', 'smallint', '6', '1'),
('grn_clearing_act', 'glsetup.purchase', 'varchar', '15', '1550');

### Structure of table `1_sys_types` ###

DROP TABLE IF EXISTS `1_sys_types`;

CREATE TABLE `1_sys_types` (
  `type_id` smallint(6) NOT NULL DEFAULT '0',
  `type_no` int(11) NOT NULL DEFAULT '1',
  `next_reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_sys_types` ###

INSERT INTO `1_sys_types` VALUES
('0', '17', '60'),
('1', '7', '677'),
('2', '4', '172'),
('4', '3', '81'),
('10', '16', '103'),
('11', '2', '3'),
('12', '6', '87'),
('13', '1', '1'),
('16', '2', '1'),
('17', '2', '1'),
('18', '1', '1'),
('20', '6', '10'),
('21', '1', '1'),
('22', '3', '677'),
('25', '1', '1'),
('26', '1', '1'),
('28', '1', '1'),
('29', '1', '1'),
('30', '0', '1'),
('32', '0', '1'),
('35', '1', '1'),
('40', '1', '1'),
('50', '1', '554594');

### Structure of table `1_tag_associations` ###

DROP TABLE IF EXISTS `1_tag_associations`;

CREATE TABLE `1_tag_associations` (
  `record_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `tag_id` int(11) NOT NULL,
  UNIQUE KEY `record_id` (`record_id`,`tag_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_tag_associations` ###


### Structure of table `1_tags` ###

DROP TABLE IF EXISTS `1_tags`;

CREATE TABLE `1_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_tags` ###


### Structure of table `1_tax_group_items` ###

DROP TABLE IF EXISTS `1_tax_group_items`;

CREATE TABLE `1_tax_group_items` (
  `tax_group_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`tax_group_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_tax_group_items` ###

INSERT INTO `1_tax_group_items` VALUES
('1', '1', '5');

### Structure of table `1_tax_groups` ###

DROP TABLE IF EXISTS `1_tax_groups`;

CREATE TABLE `1_tax_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_shipping` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_tax_groups` ###

INSERT INTO `1_tax_groups` VALUES
('1', 'Tax', '0', '0'),
('2', 'Tax Exempt', '0', '0');

### Structure of table `1_tax_types` ###

DROP TABLE IF EXISTS `1_tax_types`;

CREATE TABLE `1_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rate` double NOT NULL DEFAULT '0',
  `sales_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `purchasing_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_tax_types` ###

INSERT INTO `1_tax_types` VALUES
('1', '5', '2150', '2150', 'Tax', '0');

### Structure of table `1_trans_tax_details` ###

DROP TABLE IF EXISTS `1_trans_tax_details`;

CREATE TABLE `1_trans_tax_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `tran_date` date NOT NULL,
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '0',
  `ex_rate` double NOT NULL DEFAULT '1',
  `included_in_price` tinyint(1) NOT NULL DEFAULT '0',
  `net_amount` double NOT NULL DEFAULT '0',
  `amount` double NOT NULL DEFAULT '0',
  `memo` tinytext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `Type_and_Number` (`trans_type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_trans_tax_details` ###


### Structure of table `1_useronline` ###

DROP TABLE IF EXISTS `1_useronline`;

CREATE TABLE `1_useronline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` int(15) NOT NULL DEFAULT '0',
  `ip` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `file` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_useronline` ###


### Structure of table `1_users` ###

DROP TABLE IF EXISTS `1_users`;

CREATE TABLE `1_users` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `real_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `role_id` int(11) NOT NULL DEFAULT '1',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_format` tinyint(1) NOT NULL DEFAULT '0',
  `date_sep` tinyint(1) NOT NULL DEFAULT '0',
  `tho_sep` tinyint(1) NOT NULL DEFAULT '0',
  `dec_sep` tinyint(1) NOT NULL DEFAULT '0',
  `theme` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'default',
  `page_size` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'A4',
  `prices_dec` smallint(6) NOT NULL DEFAULT '2',
  `qty_dec` smallint(6) NOT NULL DEFAULT '2',
  `rates_dec` smallint(6) NOT NULL DEFAULT '4',
  `percent_dec` smallint(6) NOT NULL DEFAULT '1',
  `show_gl` tinyint(1) NOT NULL DEFAULT '1',
  `show_codes` tinyint(1) NOT NULL DEFAULT '0',
  `show_hints` tinyint(1) NOT NULL DEFAULT '0',
  `last_visit_date` datetime DEFAULT NULL,
  `query_size` tinyint(1) DEFAULT '10',
  `graphic_links` tinyint(1) DEFAULT '1',
  `pos` smallint(6) DEFAULT '1',
  `print_profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `rep_popup` tinyint(1) DEFAULT '1',
  `sticky_doc_date` tinyint(1) DEFAULT '0',
  `startup_tab` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_users` ###

INSERT INTO `1_users` VALUES
('1', 'admin', '21232f297a57a5a743894a0e4a801fc3', 'Administrator', '2', '', 'adm@adm.com', 'C', '0', '0', '0', '0', 'default', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2016-10-06 03:42:45', '30', '1', '1', '', '1', '1', 'orders', '0'),
('2', 'Involve3', 'd6188c72995d80e1a8e00d34987e0f6b', 'Wellcome Mr.Jaliya', '9', '', 'jaliya', 'C', '0', '0', '0', '0', 'default', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2015-10-30 00:01:30', '30', '1', '1', '', '1', '1', 'orders', '0');

### Structure of table `1_voided` ###

DROP TABLE IF EXISTS `1_voided`;

CREATE TABLE `1_voided` (
  `type` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_voided` ###

INSERT INTO `1_voided` VALUES
('0', '31', '2015-02-25', ''),
('0', '33', '2015-02-25', ''),
('0', '34', '2015-02-24', ''),
('0', '43', '2015-10-29', ''),
('1', '44', '2011-03-31', ''),
('1', '45', '2011-03-31', ''),
('1', '50', '2013-08-04', 'Document reentered.'),
('1', '52', '2013-08-04', ''),
('1', '71', '2012-08-07', ''),
('1', '74', '2015-02-24', ''),
('1', '78', '2014-02-06', ''),
('1', '122', '2015-02-24', 'Document reentered.'),
('1', '126', '2015-02-25', 'Document reentered.'),
('1', '227', '2015-03-02', 'Document reentered.'),
('1', '231', '2013-09-06', 'Document reentered.'),
('1', '237', '2015-02-25', 'Document reentered.'),
('1', '248', '2015-02-25', 'Document reentered.'),
('1', '281', '2015-02-23', ''),
('1', '283', '2014-07-15', 'Document reentered.'),
('1', '284', '2014-07-15', 'Document reentered.'),
('1', '287', '2014-02-06', ''),
('1', '315', '2014-04-28', 'Document reentered.'),
('1', '318', '2016-01-19', 'Document reentered.'),
('1', '319', '2016-01-19', 'Document reentered.'),
('1', '350', '2014-07-15', ''),
('1', '360', '2014-07-21', 'Document reentered.'),
('1', '371', '2015-12-31', 'Document reentered.'),
('1', '387', '2015-02-24', 'Document reentered.'),
('1', '391', '2014-09-04', ''),
('1', '401', '2014-09-16', 'Document reentered.'),
('1', '404', '2014-09-17', 'Document reentered.'),
('1', '466', '2015-02-24', 'Document reentered.'),
('1', '468', '2015-02-24', ''),
('1', '504', '2016-02-29', 'Document reentered.'),
('1', '505', '2016-02-29', 'Document reentered.'),
('1', '511', '2016-02-29', 'Document reentered.'),
('1', '512', '2016-02-29', 'Document reentered.'),
('1', '514', '2016-05-09', 'Document reentered.'),
('1', '519', '2016-02-29', 'Document reentered.'),
('1', '520', '2016-02-29', 'Document reentered.'),
('1', '528', '2016-02-29', 'Document reentered.'),
('1', '529', '2016-02-29', 'Document reentered.'),
('1', '532', '2015-08-19', 'Document reentered.'),
('1', '535', '2016-02-29', 'Document reentered.'),
('1', '536', '2016-02-29', 'Document reentered.'),
('1', '539', '2015-09-02', 'Document reentered.'),
('1', '540', '2015-09-02', 'Document reentered.'),
('1', '549', '2015-12-30', 'Document reentered.'),
('1', '550', '2015-12-30', 'Document reentered.'),
('1', '552', '2016-01-19', 'Document reentered.'),
('1', '561', '2016-02-15', ''),
('1', '567', '2015-10-01', 'Document reentered.'),
('1', '568', '2015-10-01', ''),
('1', '573', '2016-01-19', 'Document reentered.'),
('1', '578', '2015-10-01', ''),
('1', '579', '2015-10-01', ''),
('1', '588', '2015-10-01', ''),
('1', '595', '2015-11-11', 'Document reentered.'),
('1', '599', '2016-02-29', 'Document reentered.'),
('1', '600', '2016-02-29', 'Document reentered.'),
('1', '601', '2016-07-27', 'Document reentered.'),
('1', '609', '2016-02-29', 'Document reentered.'),
('1', '610', '2015-12-02', 'Document reentered.'),
('1', '611', '2016-02-29', 'Document reentered.'),
('1', '613', '2016-01-28', 'Document reentered.'),
('1', '617', '2016-02-28', 'Document reentered.'),
('1', '618', '2016-02-28', 'Document reentered.'),
('1', '619', '2016-02-29', 'Document reentered.'),
('1', '620', '2016-02-29', 'Document reentered.'),
('1', '622', '2015-12-31', 'Document reentered.'),
('1', '623', '2015-12-31', 'Document reentered.'),
('1', '624', '2015-12-31', 'Document reentered.'),
('1', '625', '2015-12-31', 'Document reentered.'),
('1', '626', '2015-12-31', 'Document reentered.'),
('1', '627', '2015-12-31', 'Document reentered.'),
('1', '628', '2015-12-31', 'Document reentered.'),
('1', '629', '2015-12-31', 'Document reentered.'),
('1', '633', '2016-02-12', 'Document reentered.'),
('1', '634', '2016-02-12', 'Document reentered.'),
('1', '636', '2016-01-04', ''),
('1', '649', '2016-01-28', 'Document reentered.'),
('1', '650', '2016-01-28', 'Document reentered.'),
('1', '651', '2016-01-28', 'Document reentered.'),
('1', '652', '2016-01-28', 'Document reentered.'),
('1', '656', '2016-01-28', 'Document reentered.'),
('1', '657', '2016-01-28', 'Document reentered.'),
('1', '660', '2016-02-16', 'Document reentered.'),
('1', '663', '2016-02-28', 'Document reentered.'),
('1', '664', '2016-02-28', 'Document reentered.'),
('1', '665', '2016-02-05', 'Document reentered.'),
('1', '675', '2016-02-15', 'Document reentered.'),
('1', '705', '2016-09-06', 'Document reentered.'),
('1', '724', '2016-06-07', 'Document reentered.'),
('1', '733', '2016-05-31', 'Document reentered.'),
('1', '734', '2016-05-31', 'Document reentered.'),
('1', '735', '2016-06-13', ''),
('1', '738', '2016-06-07', 'Document reentered.'),
('1', '739', '2016-06-07', 'Document reentered.'),
('1', '743', '2016-06-14', 'Document reentered.'),
('1', '802', '2016-07-27', ''),
('1', '809', '2016-08-18', 'Document reentered.'),
('2', '12', '2013-08-07', 'Document reentered.'),
('2', '16', '2013-08-03', ''),
('2', '35', '2014-07-14', ''),
('2', '37', '2014-02-05', 'Voided By Danushka On request Sampath(Duplicate transaction with Deposit #39) '),
('2', '41', '2012-06-27', ''),
('2', '43', '2014-07-15', ''),
('2', '45', '2014-07-27', ''),
('2', '47', '2014-02-05', ''),
('2', '51', '2014-09-03', 'Document reentered.'),
('2', '56', '2014-02-06', ''),
('2', '62', '2014-07-14', 'Document reentered.'),
('2', '65', '2014-07-14', 'Document reentered.'),
('2', '66', '2014-07-14', ''),
('2', '73', '2014-09-03', 'Document reentered.'),
('2', '128', '2015-10-01', 'Document reentered.'),
('2', '140', '2016-07-27', ''),
('2', '141', '2015-10-22', 'Document reentered.'),
('2', '142', '2015-10-30', ''),
('2', '143', '2016-07-27', 'Document reentered.'),
('2', '169', '2016-07-07', 'Document reentered.'),
('2', '186', '2016-07-14', 'Document reentered.'),
('2', '187', '2016-09-06', 'Document reentered.'),
('4', '1', '2016-05-31', ''),
('4', '3', '2016-07-13', ''),
('10', '18', '2014-09-03', ''),
('10', '37', '2014-09-04', ''),
('10', '38', '2014-09-04', ''),
('10', '45', '2015-03-02', ''),
('10', '57', '2015-03-02', ''),
('10', '58', '2015-03-03', ''),
('10', '62', '2016-01-13', ''),
('10', '63', '2015-10-21', ''),
('10', '67', '2016-01-13', ''),
('10', '71', '2015-10-20', ''),
('10', '73', '2016-01-13', ''),
('10', '74', '2016-01-13', ''),
('10', '78', '2016-02-05', ''),
('10', '79', '2016-02-05', ''),
('10', '81', '2016-09-29', ''),
('10', '82', '2016-09-29', ''),
('10', '83', '2016-09-29', ''),
('10', '84', '2016-09-29', ''),
('10', '85', '2016-09-29', ''),
('10', '86', '2016-09-29', ''),
('10', '87', '2016-09-29', ''),
('10', '88', '2016-09-29', ''),
('10', '89', '2016-09-29', ''),
('10', '90', '2016-09-29', ''),
('10', '91', '2016-09-29', ''),
('10', '92', '2016-09-29', ''),
('10', '94', '2016-06-30', ''),
('10', '104', '2016-10-03', ''),
('11', '1', '2014-09-04', 'Void by danushka'),
('11', '2', '2016-01-13', ''),
('12', '2', '2010-11-29', ''),
('12', '39', '2014-09-04', ''),
('12', '40', '2014-09-04', ''),
('12', '59', '2016-01-13', ''),
('12', '63', '2016-01-13', ''),
('12', '68', '2016-01-13', ''),
('12', '69', '2016-01-13', ''),
('12', '83', '2016-10-03', ''),
('12', '86', '2016-06-30', ''),
('12', '87', '2016-06-30', ''),
('12', '88', '2016-07-01', ''),
('12', '89', '2016-07-01', ''),
('13', '18', '2014-09-03', ''),
('13', '37', '2014-09-04', ''),
('13', '38', '2014-09-04', ''),
('13', '45', '2015-03-02', ''),
('13', '57', '2015-03-02', ''),
('13', '58', '2015-03-03', ''),
('13', '62', '2016-01-13', ''),
('13', '63', '2015-10-21', ''),
('13', '67', '2016-01-13', ''),
('13', '71', '2015-10-20', ''),
('13', '73', '2016-01-13', ''),
('13', '74', '2016-01-13', ''),
('13', '78', '2016-02-05', ''),
('13', '79', '2016-02-05', ''),
('13', '81', '2016-09-29', ''),
('13', '82', '2016-09-29', ''),
('13', '83', '2016-09-29', ''),
('13', '84', '2016-09-29', ''),
('13', '85', '2016-09-29', ''),
('13', '86', '2016-09-29', ''),
('13', '87', '2016-09-29', ''),
('13', '88', '2016-09-29', ''),
('13', '89', '2016-09-29', ''),
('13', '90', '2016-09-29', ''),
('13', '91', '2016-09-29', ''),
('13', '92', '2016-09-29', ''),
('13', '94', '2016-06-30', ''),
('13', '104', '2016-10-03', ''),
('22', '1', '2012-03-20', '');

### Structure of table `1_wo_issue_items` ###

DROP TABLE IF EXISTS `1_wo_issue_items`;

CREATE TABLE `1_wo_issue_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_id` int(11) DEFAULT NULL,
  `qty_issued` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_wo_issue_items` ###


### Structure of table `1_wo_issues` ###

DROP TABLE IF EXISTS `1_wo_issues`;

CREATE TABLE `1_wo_issues` (
  `issue_no` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workcentre_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`issue_no`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_wo_issues` ###


### Structure of table `1_wo_manufacture` ###

DROP TABLE IF EXISTS `1_wo_manufacture`;

CREATE TABLE `1_wo_manufacture` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_wo_manufacture` ###


### Structure of table `1_wo_requirements` ###

DROP TABLE IF EXISTS `1_wo_requirements`;

CREATE TABLE `1_wo_requirements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre` int(11) NOT NULL DEFAULT '0',
  `units_req` double NOT NULL DEFAULT '1',
  `std_cost` double NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_issued` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_wo_requirements` ###


### Structure of table `1_workcentres` ###

DROP TABLE IF EXISTS `1_workcentres`;

CREATE TABLE `1_workcentres` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_workcentres` ###


### Structure of table `1_workorders` ###

DROP TABLE IF EXISTS `1_workorders`;

CREATE TABLE `1_workorders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wo_ref` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_reqd` double NOT NULL DEFAULT '1',
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `required_by` date NOT NULL DEFAULT '0000-00-00',
  `released_date` date NOT NULL DEFAULT '0000-00-00',
  `units_issued` double NOT NULL DEFAULT '0',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `released` tinyint(1) NOT NULL DEFAULT '0',
  `additional_costs` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `wo_ref` (`wo_ref`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `1_workorders` ###
