# MySQL dump of database 'horizonc_360v6' on host 'localhost'
# Backup Date and Time: 2018-06-20 15:54
# Built by EvolveAccounting EVOLVE360v6
# http://evolve-sl.com
# Company: Horizon College International - Malabe
# User: Administrator

# Compatibility: 2.4.1


SET NAMES latin1;


### Structure of table `3_amortisation` ###

DROP TABLE IF EXISTS `3_amortisation`;

CREATE TABLE `3_amortisation` (
  `amortisation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `amortisation_year` int(11) DEFAULT NULL,
  `asset_value` double DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `posted` int(11) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`amortisation_id`),
  UNIQUE KEY `amortisation_id` (`amortisation_id`),
  KEY `3_amortisation_asset_id` (`asset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_amortisation` ###


### Structure of table `3_areas` ###

DROP TABLE IF EXISTS `3_areas`;

CREATE TABLE `3_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_areas` ###

INSERT INTO `3_areas` VALUES
('1', 'USA', '0');

### Structure of table `3_asset_types` ###

DROP TABLE IF EXISTS `3_asset_types`;

CREATE TABLE `3_asset_types` (
  `asset_type_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_type_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `depreciation_type` int(11) NOT NULL DEFAULT '1',
  `depreciation_rate` double NOT NULL DEFAULT '10',
  `asset_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `depreciation_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `accumulated_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `valuation_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `disposal_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_type_id`),
  UNIQUE KEY `asset_type_id` (`asset_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_asset_types` ###


### Structure of table `3_asset_valuations` ###

DROP TABLE IF EXISTS `3_asset_valuations`;

CREATE TABLE `3_asset_valuations` (
  `asset_valuation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `valuation_year` int(11) DEFAULT NULL,
  `asset_value` double NOT NULL DEFAULT '0',
  `value_change` double NOT NULL DEFAULT '0',
  `posted` int(11) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_valuation_id`),
  UNIQUE KEY `asset_valuation_id` (`asset_valuation_id`),
  UNIQUE KEY `asset_id` (`asset_id`,`valuation_year`),
  KEY `3_asset_valuations_asset_id` (`asset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_asset_valuations` ###


### Structure of table `3_assets` ###

DROP TABLE IF EXISTS `3_assets`;

CREATE TABLE `3_assets` (
  `asset_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_type_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `asset_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_serial` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `purchase_date` date NOT NULL,
  `purchase_value` double NOT NULL,
  `disposal_amount` double DEFAULT NULL,
  `disposal_date` date DEFAULT NULL,
  `disposal_posting` int(11) DEFAULT '0',
  `tag_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_location` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_condition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_acquisition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_id`),
  UNIQUE KEY `asset_id` (`asset_id`),
  KEY `3_assets_asset_type_id` (`asset_type_id`),
  KEY `3_assets_item_id` (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_assets` ###


### Structure of table `3_attachments` ###

DROP TABLE IF EXISTS `3_attachments`;

CREATE TABLE `3_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_no` int(11) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `unique_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT '0',
  `filetype` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_attachments` ###


### Structure of table `3_audit_trail` ###

DROP TABLE IF EXISTS `3_audit_trail`;

CREATE TABLE `3_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `user` smallint(6) unsigned NOT NULL DEFAULT '0',
  `stamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL DEFAULT '0',
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=236 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_audit_trail` ###

INSERT INTO `3_audit_trail` VALUES
('1', '0', '1', '1', '2017-05-16 01:34:58', NULL, '3', '2017-05-16', '1'),
('2', '0', '2', '1', '2017-05-16 01:49:01', NULL, '3', '2017-05-16', NULL),
('3', '0', '3', '1', '2017-05-16 01:49:26', NULL, '3', '2017-05-16', NULL),
('4', '0', '4', '1', '2017-05-30 05:12:27', NULL, '3', '2017-05-30', NULL),
('5', '20', '1', '1', '2017-06-14 02:18:06', NULL, '3', '2017-06-14', '5'),
('6', '22', '1', '1', '2017-06-14 02:19:45', NULL, '3', '2017-06-14', '6'),
('7', '20', '2', '1', '2017-06-14 02:20:53', NULL, '3', '2017-06-14', '7'),
('8', '22', '2', '1', '2017-06-14 02:21:55', NULL, '3', '2017-06-14', '8'),
('9', '22', '3', '1', '2017-06-14 02:24:37', NULL, '3', '2017-08-31', '0'),
('10', '0', '5', '1', '2017-06-27 05:56:00', NULL, '3', '2017-06-27', NULL),
('11', '0', '6', '1', '2017-06-27 05:59:45', NULL, '3', '2017-06-27', NULL),
('12', '0', '7', '1', '2017-06-27 05:59:54', NULL, '3', '2017-06-27', NULL),
('13', '0', '8', '1', '2017-06-27 06:00:04', NULL, '3', '2017-06-27', NULL),
('14', '0', '9', '1', '2017-06-27 06:00:04', NULL, '3', '2017-06-27', NULL),
('15', '0', '2', '1', '2017-09-18 08:14:37', NULL, '3', '2017-08-01', NULL),
('16', '0', '2', '1', '2017-09-18 08:22:21', 'Voided.\nDocument reentered.', '3', '2017-09-18', '0'),
('17', '0', '3', '1', '2017-09-18 08:22:21', NULL, '3', '2017-08-01', '0'),
('18', '0', '4', '1', '2017-09-19 00:55:31', NULL, '3', '2017-09-19', '0'),
('19', '20', '3', '1', '2017-10-23 23:59:08', NULL, '3', '2017-10-24', '0'),
('20', '22', '4', '1', '2017-10-24 00:00:00', NULL, '3', '2017-10-24', '0'),
('21', '0', '5', '1', '2017-10-24 00:44:57', NULL, '3', '2017-04-30', '0'),
('22', '0', '6', '1', '2017-10-24 00:44:57', NULL, '3', '2017-05-31', '0'),
('23', '0', '7', '1', '2017-10-24 00:44:57', NULL, '3', '2017-06-30', '0'),
('24', '0', '8', '1', '2017-10-24 00:44:57', NULL, '3', '2017-07-31', '0'),
('25', '0', '9', '1', '2017-10-24 00:44:57', NULL, '3', '2017-08-31', '0'),
('26', '0', '10', '1', '2017-10-24 00:44:57', NULL, '3', '2017-09-30', '0'),
('27', '0', '11', '1', '2017-10-24 00:44:57', NULL, '3', '2017-10-31', '0'),
('28', '0', '12', '1', '2017-10-24 00:44:57', NULL, '3', '2017-11-30', '0'),
('29', '0', '13', '1', '2017-10-24 00:44:57', NULL, '3', '2017-12-31', '0'),
('30', '0', '14', '1', '2017-10-24 00:44:57', NULL, '3', '2018-01-31', '0'),
('31', '0', '15', '1', '2017-10-24 00:44:57', NULL, '3', '2018-02-28', '0'),
('32', '0', '16', '1', '2017-10-24 00:44:57', NULL, '3', '2018-03-31', '0'),
('33', '0', '17', '1', '2017-10-24 00:49:24', NULL, '3', '2017-04-03', '0'),
('34', '0', '18', '1', '2018-01-08 05:14:15', NULL, '3', '2018-01-08', '0'),
('35', '0', '19', '1', '2018-01-08 05:28:52', NULL, '3', '2018-01-08', '0'),
('36', '0', '20', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('37', '0', '21', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('38', '0', '22', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('39', '0', '23', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('40', '0', '24', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('41', '0', '25', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('42', '0', '26', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('43', '0', '27', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('44', '0', '28', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('45', '0', '29', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('46', '0', '30', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('47', '0', '31', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('48', '0', '32', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('49', '0', '33', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('50', '0', '34', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('51', '0', '35', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('52', '0', '36', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('53', '0', '37', '1', '2018-02-09 02:58:58', NULL, '3', '2018-02-09', '0'),
('54', '0', '38', '1', '2018-02-09 02:58:59', NULL, '3', '2018-02-09', '0'),
('55', '0', '39', '1', '2018-02-09 02:58:59', NULL, '3', '2018-02-09', '0'),
('56', '0', '40', '1', '2018-02-09 02:58:59', NULL, '3', '2018-02-09', '0'),
('57', '0', '41', '1', '2018-02-09 02:58:59', NULL, '3', '2018-02-09', '0'),
('58', '0', '42', '1', '2018-02-09 02:58:59', NULL, '3', '2018-02-09', '0'),
('59', '0', '43', '1', '2018-02-09 02:58:59', NULL, '3', '2018-02-09', '0'),
('60', '0', '44', '1', '2018-02-09 02:58:59', NULL, '3', '2018-02-09', '0'),
('61', '0', '45', '1', '2018-02-09 02:58:59', NULL, '3', '2018-02-09', '0'),
('62', '0', '46', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('63', '0', '47', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('64', '0', '48', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('65', '0', '49', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('66', '0', '50', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('67', '0', '51', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('68', '0', '52', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('69', '0', '53', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('70', '0', '54', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('71', '0', '55', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('72', '0', '56', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('73', '0', '57', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('74', '0', '58', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('75', '0', '59', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('76', '0', '60', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('77', '0', '61', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('78', '0', '62', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('79', '0', '63', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('80', '0', '64', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('81', '0', '65', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('82', '0', '66', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('83', '0', '67', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('84', '0', '68', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('85', '0', '69', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('86', '0', '70', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('87', '0', '71', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('88', '0', '72', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('89', '0', '73', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('90', '0', '74', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('91', '0', '75', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('92', '0', '76', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('93', '0', '77', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('94', '0', '78', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('95', '0', '79', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('96', '0', '80', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('97', '0', '81', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('98', '0', '82', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('99', '0', '83', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('100', '0', '84', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('101', '0', '85', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('102', '0', '86', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('103', '0', '87', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('104', '0', '88', '1', '2018-02-09 02:59:00', NULL, '3', '2018-02-09', '0'),
('105', '0', '89', '1', '2018-02-09 03:03:07', NULL, '3', '2018-02-09', '0'),
('106', '0', '90', '1', '2018-02-09 03:03:07', NULL, '3', '2018-02-09', '0'),
('107', '0', '91', '1', '2018-02-09 03:03:07', NULL, '3', '2018-02-09', '0'),
('108', '0', '92', '1', '2018-02-09 03:03:07', NULL, '3', '2018-02-09', '0'),
('109', '0', '93', '1', '2018-02-09 03:03:07', NULL, '3', '2018-02-09', '0'),
('110', '0', '94', '1', '2018-02-09 03:03:07', NULL, '3', '2018-02-09', '0'),
('111', '0', '95', '1', '2018-02-09 03:03:07', NULL, '3', '2018-02-09', '0'),
('112', '0', '96', '1', '2018-02-09 03:03:07', NULL, '3', '2018-02-09', '0'),
('113', '0', '97', '1', '2018-02-09 03:03:07', NULL, '3', '2018-02-09', '0'),
('114', '0', '98', '1', '2018-02-09 03:03:07', NULL, '3', '2018-02-09', '0'),
('115', '0', '99', '1', '2018-02-09 03:03:07', NULL, '3', '2018-02-09', '0'),
('116', '0', '100', '1', '2018-02-09 03:03:07', NULL, '3', '2018-02-09', '0'),
('117', '0', '101', '1', '2018-02-09 03:03:08', NULL, '3', '2018-02-09', '0'),
('118', '0', '102', '1', '2018-02-09 03:03:08', NULL, '3', '2018-02-09', '0'),
('119', '0', '103', '1', '2018-02-09 03:03:08', NULL, '3', '2018-02-09', '0'),
('120', '0', '104', '1', '2018-02-09 03:03:08', NULL, '3', '2018-02-09', '0'),
('121', '0', '105', '1', '2018-02-09 03:03:08', NULL, '3', '2018-02-09', '0'),
('122', '0', '106', '1', '2018-02-09 03:03:08', NULL, '3', '2018-02-09', '0'),
('123', '0', '107', '1', '2018-02-09 03:03:08', NULL, '3', '2018-02-09', '0'),
('124', '0', '108', '1', '2018-02-09 03:03:08', NULL, '3', '2018-02-09', '0'),
('125', '0', '109', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('126', '0', '110', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('127', '0', '111', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('128', '0', '112', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('129', '0', '113', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('130', '0', '114', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('131', '0', '115', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('132', '0', '116', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('133', '0', '117', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('134', '0', '118', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('135', '0', '119', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('136', '0', '120', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('137', '0', '121', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('138', '0', '122', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('139', '0', '123', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('140', '0', '124', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('141', '0', '125', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('142', '0', '126', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('143', '0', '127', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('144', '0', '128', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('145', '0', '129', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('146', '0', '130', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('147', '0', '131', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('148', '0', '132', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('149', '0', '133', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('150', '0', '134', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('151', '0', '135', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('152', '0', '136', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('153', '0', '137', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('154', '0', '138', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('155', '0', '139', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('156', '0', '140', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('157', '0', '141', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('158', '0', '142', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('159', '0', '143', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('160', '0', '144', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('161', '0', '145', '1', '2018-02-09 03:03:09', NULL, '3', '2018-02-09', '0'),
('162', '0', '146', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('163', '0', '147', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('164', '0', '148', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('165', '0', '149', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('166', '0', '150', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('167', '0', '151', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('168', '0', '152', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('169', '0', '153', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('170', '0', '154', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('171', '0', '155', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('172', '0', '156', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('173', '0', '157', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('174', '0', '158', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('175', '0', '159', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('176', '0', '160', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('177', '0', '161', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('178', '0', '162', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('179', '0', '163', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('180', '0', '164', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('181', '0', '165', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('182', '0', '166', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('183', '0', '167', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('184', '0', '168', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('185', '0', '169', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('186', '0', '170', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('187', '0', '171', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('188', '0', '172', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('189', '0', '173', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('190', '0', '174', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('191', '0', '175', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('192', '0', '176', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('193', '0', '177', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('194', '0', '178', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('195', '0', '179', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('196', '0', '180', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('197', '0', '181', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('198', '0', '182', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('199', '0', '183', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('200', '0', '184', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('201', '0', '185', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('202', '0', '186', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('203', '0', '187', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('204', '0', '188', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('205', '0', '189', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('206', '0', '190', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('207', '0', '191', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('208', '0', '192', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('209', '0', '193', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('210', '0', '194', '1', '2018-02-09 03:03:10', NULL, '3', '2018-02-09', '0'),
('211', '0', '195', '1', '2018-02-09 03:03:11', NULL, '3', '2018-02-09', '0'),
('212', '0', '196', '1', '2018-02-09 03:03:11', NULL, '3', '2018-02-09', '0'),
('213', '0', '197', '1', '2018-02-09 03:03:11', NULL, '3', '2018-02-09', '0'),
('214', '0', '198', '1', '2018-02-09 03:03:11', NULL, '3', '2018-02-09', '0'),
('215', '0', '199', '1', '2018-02-09 03:03:11', NULL, '3', '2018-02-09', '0'),
('216', '0', '200', '1', '2018-02-09 03:03:11', NULL, '3', '2018-02-09', '0'),
('217', '0', '201', '1', '2018-02-09 03:03:11', NULL, '3', '2018-02-09', '0'),
('218', '0', '202', '1', '2018-02-09 03:03:11', NULL, '3', '2018-02-09', '0'),
('219', '0', '203', '1', '2018-02-09 03:03:11', NULL, '3', '2018-02-09', '0'),
('220', '0', '204', '1', '2018-02-09 03:03:11', NULL, '3', '2018-02-09', '0'),
('221', '0', '205', '1', '2018-02-09 03:03:11', NULL, '3', '2018-02-09', '0'),
('222', '0', '206', '1', '2018-02-09 03:03:11', NULL, '3', '2018-02-09', NULL),
('223', '0', '207', '1', '2018-05-28 01:33:05', NULL, '3', '2018-05-28', '0'),
('224', '0', '206', '1', '2018-05-28 01:41:48', 'Voided.\n', '3', '2018-03-31', '0'),
('225', '0', '1', '1', '2018-05-28 03:02:10', NULL, '3', '2018-05-28', '0'),
('226', '0', '2', '1', '2018-05-28 03:56:42', NULL, '3', '2018-05-28', '0'),
('227', '0', '3', '1', '2018-05-28 03:59:04', NULL, '3', '2018-05-28', '0'),
('228', '0', '4', '1', '2018-05-28 04:02:31', NULL, '3', '2018-05-28', '0'),
('229', '0', '5', '1', '2018-05-28 04:08:24', NULL, '3', '2018-05-28', '0'),
('230', '0', '6', '1', '2018-05-28 04:20:15', NULL, '3', '2018-05-28', '0'),
('231', '0', '7', '1', '2018-05-28 05:24:23', NULL, '3', '2018-05-28', '0'),
('232', '0', '8', '1', '2018-05-28 05:28:26', NULL, '3', '2018-05-28', '0'),
('233', '0', '9', '1', '2018-05-28 05:37:20', NULL, '3', '2018-05-28', '0'),
('234', '0', '10', '1', '2018-05-28 05:39:05', NULL, '3', '2018-05-28', '0'),
('235', '0', '11', '1', '2018-05-31 05:28:17', NULL, '3', '2018-05-31', '0');

### Structure of table `3_bank_accounts` ###

DROP TABLE IF EXISTS `3_bank_accounts`;

CREATE TABLE `3_bank_accounts` (
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT '0',
  `bank_account_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_address` tinytext COLLATE utf8_unicode_ci,
  `bank_curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT '0',
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `bank_charge_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `bank_short_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_bank_accounts` ###


### Structure of table `3_bank_trans` ###

DROP TABLE IF EXISTS `3_bank_trans`;

CREATE TABLE `3_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ref` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `person_type_id` int(11) NOT NULL DEFAULT '0',
  `person_id` tinyblob,
  `reconciled` date DEFAULT NULL,
  `pay_mode` int(1) DEFAULT NULL,
  `cheque_reference` int(6) DEFAULT NULL,
  `payment_increment` int(11) DEFAULT NULL,
  `payment_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_bank_trans` ###

INSERT INTO `3_bank_trans` VALUES
('1', '22', '1', '4', '1', '2017-06-14', '-1500', '0', '0', '3', '1', NULL, '0', '1', '1', 'PB/06/2017/P/1'),
('2', '22', '2', '8', '2', '2017-06-14', '-5000', '0', '0', '3', '1', NULL, '0', '0', '1', 'Petty/06/2017/P/1'),
('3', '22', '3', '8', '3', '2017-08-31', '-2500', '0', '0', '3', '1', NULL, '0', '1', '2', 'Petty/06/2017/P/2'),
('4', '22', '4', '8', '4', '2017-10-24', '-50000', '0', '0', '3', '1', NULL, '0', '2', '3', 'Petty/10/2017/P/3');

### Structure of table `3_bom` ###

DROP TABLE IF EXISTS `3_bom`;

CREATE TABLE `3_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `component` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_bom` ###


### Structure of table `3_budget_trans` ###

DROP TABLE IF EXISTS `3_budget_trans`;

CREATE TABLE `3_budget_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `dimension_id` int(11) DEFAULT '0',
  `dimension2_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_budget_trans` ###


### Structure of table `3_chart_class` ###

DROP TABLE IF EXISTS `3_chart_class`;

CREATE TABLE `3_chart_class` (
  `cid` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `class_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_chart_class` ###

INSERT INTO `3_chart_class` VALUES
('1', 'Assets ', '1', '0'),
('2', 'Equity', '3', '0'),
('3', 'Liabilities', '2', '0'),
('4', 'Income', '4', '0'),
('5', 'Expenses', '6', '0');

### Structure of table `3_chart_master` ###

DROP TABLE IF EXISTS `3_chart_master`;

CREATE TABLE `3_chart_master` (
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_code2` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_chart_master` ###

INSERT INTO `3_chart_master` VALUES
('0001', '', 'School Land', '1.11', '1'),
('0002', '', 'Swimming Pool Land', '1.11', '1'),
('0005', '', 'Play Group Land', '1.11', '1'),
('0006', '', 'Landscape (Land Development)', '1.11', '1'),
('0015', '', 'Equipment-IMA Fixed Assets', '1.18', '1'),
('0024', '', 'Fixed Deposit - BOC', '1.31', '0'),
('0025', '', 'Fixed Deposit - Seylan', '1.31', '0'),
('0028', '', 'Other Payable - Collections from Teachers', '3.22', '0'),
('0032', '', 'Main Stores - School Exercise Books', '1.21', '0'),
('0033', '', 'Main Stores - School Bags', '1.21', '0'),
('0035', '', 'Main Stores - School Application Forms', '1.21', '0'),
('0036', '', 'Uniforms-Staff/Parents', '1.21', '0'),
('0037', '', 'Sports Kits', '1.21', '0'),
('0038', '', 'Main Stores - General Stocks (Photocopy Papers)', '1.21', '0'),
('0042', '', 'Sub-Stores-Front Office = School Text Books', '1.21', '0'),
('0043', '', 'Sub-Stores-Front Office = School Exercise Books', '1.21', '0'),
('0044', '', 'Sub-Stores-Front Office = School Bags', '1.21', '0'),
('0045', '', 'Sub-Stores-Front Office = School Application Forms', '1.21', '0'),
('0046', '', 'Sub-Stores-Front Office = Uniforms - Staff/Parents', '1.21', '0'),
('0047', '', 'Sub-Stores-Sports Office = Sports Kits', '1.21', '0'),
('0049', '', 'Sub-Stores- Sports Office = Uniforms-Staff/Parents', '1.21', '0'),
('0054', '', 'Accounts Receivables-School Students', '1.22', '0'),
('0055', '', 'Accounts Receivables-Childcare ', '1.22', '0'),
('0056', '', 'Accounts Receivables-Swimming Pool', '1.22', '0'),
('0058', '', 'Accounts Receivables-Hostals', '1.22', '0'),
('0072', '', 'Salary Advance', '1.23', '0'),
('0074', '', 'Staff Loan', '1.23', '0'),
('0075', '', 'Receivables - Costumes', '1.23', '0'),
('0076', '', 'Receivables - New Year Contributions', '1.22', '0'),
('0077', '', 'Receivables - Sports Kits', '1.22', '0'),
('0079', '', 'Returned Cheques', '1.23', '0'),
('0080', '', ' Int in Suspense - BOC Lease PF 4326', '1.24', '0'),
('0081', '', 'Int in Suspense - Seylan Bank CAE 0232', '1.24', '0'),
('0082', '', 'Int in Suspense - Seylan Bank WP NC 1950', '1.24', '0'),
('0083', '', 'Int in Suspense - Seylan Bank CAE 2377', '1.24', '0'),
('0084', '', 'Int in Suspense - Seylan Bank KU 4418', '1.24', '0'),
('0085', '', 'Int in Suspense - Seylan Bank KI 8024', '1.24', '0'),
('0086', '', 'Lease Interest in Suspense Seylan Bank - NC 2882', '1.24', '0'),
('0087', '', 'Lease Interest in Suspense Sampath Bank CAC 8447', '1.24', '0'),
('0088', '', 'Lease Interest in Suspense Sampath Bank CAL2141', '1.24', '0'),
('0089', '', 'Lease Interest in Suspense Sampath Bank - NC 5463', '1.24', '0'),
('0090', '', 'Lease Interest in Suspense BOC - NC 7403', '1.24', '0'),
('0095', '', 'Suspense A/c ', '1.24', '0'),
('0100', '', 'Receivable from HCBT', '1.25', '0'),
('0101', '', 'Current Account - Global Education Center', '1.25', '0'),
('0102', '', 'Current Account - Ceylon Plantation', '1.25', '0'),
('0103', '', 'Current Account - HHL', '1.25', '0'),
('0104', '', 'Current Account - Oxford College of Business', '1.25', '0'),
('0105', '', 'Current Account - Horizon Knowledge City Limited', '1.25', '0'),
('0106', '', 'Current Account - Eco Life Style Limited', '1.25', '0'),
('0107', '', 'Current Account - Kids in Action', '1.25', '0'),
('0108', '', 'Current Account - CFPS Academy', '1.25', '0'),
('0110', '', 'Bank of Ceylon Savings Account-74676813', '1.26', '0'),
('0111', '', 'Lien Savings Account - Commercial Bank 1860017610', '1.26', '0'),
('0112', '', 'Seylan Bank Malabe Savings Account 0670-33390393-101', '1.26', '0'),
('0113', '', 'Seylan Bank Malabe Savings Account 0670-33390393-108', '1.26', '0'),
('0114', '', 'IMA Bank of Ceylon Current Account-75907652', '1.26', '0'),
('0115', '', 'Peoples Bank Current Account 309-1001-70006954', '1.26', '0'),
('0116', '', 'Commercial Bank Current Account - 1860018610', '1.26', '0'),
('0117', '', 'Bank of Ceylon Current Account-74685206', '1.26', '0'),
('0118', '', 'Seylan Bank Current Account-0670 33390393-001', '1.26', '0'),
('0119', '', 'Sampath Bank Current Account-000310025119', '1.26', '0'),
('0121', '', 'Petty Cash II', '1.27', '0'),
('0123', '', 'Petty Cash III', '1.27', '0'),
('0130', '', 'Current Account - Mr.Daranagama', '2.11', '0'),
('0134', '', 'Current Account - Mrs.Daranagama', '2.11', '0'),
('0140', '', 'Seylan Bank Loan - Suhada Mawatha Hostel', '3.11', '0'),
('0141', '', 'Sampath Bank Term Loan (28.1Mn) 300370000228', '3.11', '0'),
('0142', '', 'Sampath Bank Term Loan (6Mn) 300370000233', '3.11', '0'),
('0145', '', 'Sampath Bank Term Loan (47Mn) 300370000232', '3.11', '0'),
('0150', '', 'BOC Lease Facility - PF 4326', '3.12', '0'),
('0151', '', 'Seylan Bank Lease Facility - CAE 0232', '3.12', '0'),
('0152', '', 'Seylan Bank Lease Facility - NC 1950', '3.12', '0'),
('0153', '', 'Seylan Bank Lease Facility - CAE 2377', '3.12', '0'),
('0154', '', 'Seylan Bank Lease Facility - KU 4418', '3.12', '0'),
('0155', '', 'Seylan Bank Lease Facility - KI 8024', '3.12', '0'),
('0156', '', 'Seylan Bank Lease Facility - NC 2882', '3.12', '0'),
('0157', '', 'Sampath Bank Lease Facility - CAC 8447', '3.12', '0'),
('0158', '', 'Sampath Bank Lease Facility - CAL 2141', '3.12', '0'),
('0159', '', 'Sampath Bank Lease Facility NC 5463 Lsn 48000419', '3.12', '0'),
('0160', '', 'BOC Lease Facility - NC 7403', '3.12', '0'),
('0170', '', 'Contractors Loan', '3.13', '0'),
('0175', '', 'Term Loan from Park Holding', '3.13', '0'),
('0190', '', 'Salaries Control', '3.23', '0'),
('0191', '', 'Rent in Advance Cricket Ground', '3.23', '0'),
('0192', '', 'Staff Standing Order Deductions - Mobile Phone', '3.23', '0'),
('0193', '', 'Staff Standing Order Deductions - Other', '3.23', '0'),
('0194', '', 'Staff Standing Order Deductions - Welfare Fund', '3.23', '0'),
('0195', '', 'Refundable Deposits kept with others', '3.23', '0'),
('0196', '', 'Refundable Deposits Received for Play Ground ', '3.23', '0'),
('0197', '', 'Refundable Term Fees', '3.23', '0'),
('0201', '', 'Differed Revenue', '3.2', '0'),
('0210', '', 'Provision For Gratuity', '3.21', '0'),
('0225', '', 'Other Payable - Sports Kits', '3.22', '0'),
('0226', '', 'Other Payable - Costumes', '3.22', '0'),
('0227', '', 'Other Payable - Collections from Students', '3.22', '0'),
('0230', '', 'Withholding Tax on Interest &amp; Other', '3.24', '0'),
('0231', '', 'VAT Payable', '3.24', '0'),
('0232', '', 'EPF Payable', '3.24', '0'),
('0233', '', 'ETF Payable', '3.24', '0'),
('0234', '', 'PAYE Tax Payable', '3.24', '0'),
('0235', '', 'NBT Payable', '3.24', '0'),
('0236', '', 'Stamp Duty Payable', '3.24', '0'),
('0237', '', 'Income Tax Payable', '3.24', '0'),
('0240', '', 'TL - Mr. Daranagama', '3.25', '0'),
('0241', '', 'TL - Mrs. Muditha', '3.25', '0'),
('0242', '', 'TL - Mr. Karunanayake', '3.25', '0'),
('0243', '', 'TL - Mr. Nomis Pandithasundara', '3.25', '0'),
('0250', '', 'STL - Seylan Bank', '3.25', '0'),
('0251', '', 'STL - Sampath Bank', '3.25', '0'),
('0252', '', 'STL - Bank Of Ceylon', '3.25', '0'),
('0256', '', 'STL - Commercial Bank', '3.25', '0'),
('0258', '', 'STL - Peoples Bank ', '3.25', '0'),
('0262', '', 'Current Account - D &amp; P Marketing Services', '3.26', '0'),
('0268', '', 'Current Account - HCI Nugegoda', '3.26', '0'),
('0269', '', 'Current Account - Sriko (Pvt) Ltd', '3.26', '0'),
('0510', '', 'Admission Fees Income', '4.2', '0'),
('0511', '', 'Term Fees Income', '4.2', '0'),
('0515', '', 'Service Fees Income', '4.2', '0'),
('0516', '', 'Facility Fees Income', '4.2', '0'),
('0517', '', 'Late Fees Fund', '4.2', '0'),
('0518', '', 'Refund of School Fees', '4.2', '0'),
('0530', '', 'Admission Fees Income', '4.3', '0'),
('0532', '', 'Monthly Fees Income', '4.3', '0'),
('0534', '', 'Facility Fees Income', '4.3', '0'),
('0536', '', 'Late Fees Income', '4.3', '0'),
('0538', '', 'Refund of Child Care Fees', '4.3', '0'),
('0554', '', 'IMA - Course Fees Income', '4.1', '0'),
('0556', '', 'IMA -  Other Income', '4.1', '0'),
('0558', '', 'IMA Franchise Fees From Centers', '4.1', '0'),
('0570', '', 'Registration Fees Income', '4.5', '0'),
('0576', '', 'Monthly Fees Income', '4.1', '0'),
('0580', '', 'Rent Income-Hostel', '4.4', '0'),
('0590', '', 'Sales of Books', '4.7', '0'),
('0593', '', 'Sales of Sports Kits', '4.7', '0'),
('0595', '', 'Sales of Uniforms', '4.7', '0'),
('0597', '', 'Sales of School Application', '4.7', '0'),
('0599', '', 'Sales Return', '4.7', '0'),
('0610', '', 'Interest Income from Fixed Deposits', '4.51', '0'),
('0615', '', 'Interest Income from Savings A/Cs', '4.51', '0'),
('0620', '', 'Play Ground Hire Income', '4.6', '0'),
('0621', '', 'Basket Ball Court Hire Income', '4.6', '0'),
('0622', '', 'Netball Court Hire Income', '4.6', '0'),
('0623', '', 'Cafeteria Rent Income', '4.6', '0'),
('0630', '', 'Profit/(Loss) from Disposal of Fixed Assets', '4.71', '0'),
('0633', '', 'Sundry Income', '4.71', '0'),
('0700', '', 'Purchases - Purchases of Application Forms Mlb', '5.1', '0'),
('0704', '', 'Purchases - Purchases of Photocopy Papers Mlb', '5.1', '0'),
('0705', '', 'Purchases - Purchases of School Bags Mlb', '5.1', '0'),
('0706', '', 'Purchases - Purchases of School Books Mlb', '5.1', '0'),
('0707', '', 'Purchases - Purchases of School Uniforms - Mlb', '5.1', '0'),
('0708', '', 'Purchases - School fees Refund -  Mlb', '5.1', '0'),
('0720', '', 'Salaries &amp; Wages - Academic Staff', '5.12', '0'),
('0721', '', 'Salaries &amp; Wages - Admin Staff', '5.12', '0'),
('0722', '', 'Salaries &amp; Wages - Accounts Staff', '5.12', '0'),
('0723', '', 'Salaries &amp; Wages - Accounts Staff', '5.12', '0'),
('0724', '', 'Salaries &amp; Wages - Transport Staff', '5.12', '0'),
('0726', '', 'Salaries &amp; Wages - Support Staff', '5.12', '0'),
('0727', '', 'Salaries &amp; Wages - Other Staff', '5.12', '0'),
('0729', '', 'Child Care - Salaries &amp; Wages ', '5.12', '0'),
('0735', '', 'EPF Expenses', '5.0', '0'),
('0740', '', 'ETF Expenses', '5.0', '0'),
('0750', '', 'Electricity Expenses - A Block', '5.13', '0'),
('0751', '', 'Electricity Expenses - H Block', '5.13', '0'),
('0754', '', 'Electricity Expenses-Hostel', '5.13', '0'),
('0760', '', 'Telephone Bills No - 0772602898', '5.14', '0'),
('0770', '', 'Water Expenses -School', '5.15', '0'),
('0771', '', 'Water Expenses-Hostel', '5.13', '0'),
('0780', '', 'Janitorial Service Expenses', '5.0', '0'),
('0781', '', 'Printing &amp; Stationary', '5.0', '0'),
('0790', '', 'Special Event Expenses', '5.16', '0'),
('0791', '', 'Educational Trips Expenses', '5.0', '0'),
('0792', '', 'Spots Items Expenses ', '5.0', '0'),
('0800', '', 'Child Care - Play Items', '5.17', '0'),
('0802', '', 'Child Care - Sundry Expenses', '5.17', '0'),
('0904', '', 'Child Care - Printing and Stionary', '5.17', '0'),
('0905', '', 'Child Care - Pantry Items', '5.17', '0'),
('0906', '', 'Child Care - Student Care Expenses', '5.17', '0'),
('0908', '', 'Child Care - Sundry Expenses', '5.17', '0'),
('0915', '', 'IMA Expenses', '5.0', '0'),
('0917', '', 'Insurance - Health Academic Staff', '5.18', '0'),
('0919', '', 'Fire Insurance - Academic Buildings', '5.18', '0'),
('0920', '', 'Hiring Charges - Shuttle Bus', '5.0', '0'),
('0924', '', 'Hiring Charges - Photo Copiers', '5.0', '0'),
('0925', '', 'Hiring Charges - External Facilities - Play Ground &amp; Oth', '5.0', '0'),
('0926', '', 'Hiring Charges - Furniture &amp; Other', '5.0', '0'),
('0927', '', 'Rent Expenses', '5.0', '0'),
('0930', '', 'Educational Equipment - Toys C Block', '5.19', '0'),
('0931', '', 'Educational Equipment - Science Lab Maintenance', '5.19', '0'),
('0933', '', 'Teacher&#039;s Copies - Books ', '5.19', '0'),
('0940', '', 'Mess Expenses', '5.0', '0'),
('0942', '', 'Tea Expenses', '5.0', '0'),
('0950', '', 'Student Care Expenses - Health', '5.191', '0'),
('0955', '', 'Student Care Expenses - Laundry Charges', '5.191', '0'),
('0960', '', 'Renovation of Building - Electrical Maintenance', '5.192', '0'),
('0962', '', 'Maintenance of Garden', '5.0', '0'),
('0965', '', 'Maintenance of Swimming Pool', '5.0', '0'),
('0967', '', 'Maintainence of Play Ground', '5.193', '0'),
('1000', '', 'Repairs &amp; Maintenance - Furniture', '5.2', '0'),
('10001', '', 'School Land', '1.11', '0'),
('10002', '', 'Swimming Pool Land', '1.11', '0'),
('10005', '', 'Playgroud Land', '1.11', '0'),
('10006', '', 'Land Development (Landscape)', '1.11', '0'),
('10010', '', 'Buildings Under Construction', '1.13', '0'),
('10020', '', 'Plant &amp; Equipment', '1.16', '0'),
('10030', '', 'Furniture &amp; Fittings', '1.17', '0'),
('10040', '', 'Motor Vehicles', '1.18', '0'),
('10060', '', 'Intangible Assets', '1.191', '0'),
('1010', '', 'Repairs &amp; Maintenance - Play Items', '5.2', '0'),
('10100', '', 'Inventory Control', '1.21', '0'),
('1015', '', 'Repairs &amp; Maintenance - Computer Systems', '5.2', '0'),
('1016', '', 'Repairs &amp; Maintenance - Tools &amp; Equipments', '5.21', '0'),
('1017', '', 'Repairs &amp; Maintenance - Child Care', '5.2', '0'),
('1018', '', 'Repairs &amp; Maintenance - Air Conditioners', '5.21', '0'),
('1020', '', 'Repairs &amp; Maintenance - Telephone System', '5.21', '0'),
('1025', '', 'Repairs &amp; Maintenance - Others', '5.21', '0'),
('1030', '', 'Interior Expenses', '5.2', '0'),
('1035', '', 'Fuel For Generator', '5.2', '0'),
('1040', '', 'Salaries &amp; Wages - Admin Staff', '5.22', '0'),
('1042', '', 'Salaries &amp; Wages - Accounts Staff', '5.22', '0'),
('1043', '', 'Salaries &amp; Wages - Supporting Staff', '5.22', '0'),
('1045', '', 'Salaries &amp; Wages - Transport Staff', '5.22', '0'),
('1046', '', 'Salaries &amp; Wages - Executive Staff', '5.22', '0'),
('1048', '', 'Salaries &amp; Wages - Other Staff', '5.22', '0'),
('1050', '', 'Staff Bonus', '5.2', '0'),
('1052', '', 'Staff Gratuity Expenses ', '5.2', '0'),
('1054', '', 'Staff Training &amp; Development Expenses', '5.2', '0'),
('1056', '', 'Staff Welfare Expenses', '5.2', '0'),
('1060', '', 'Professional Charges - Legal Fees', '5.23', '0'),
('1062', '', 'Professional Charges - Lawyer Fees', '5.23', '0'),
('1063', '', 'Professional Charges - Secretarial Fees', '5.23', '0'),
('1064', '', 'Professional Charges - Consultancy Fees', '5.23', '0'),
('1066', '', 'Professional Charges - Architech Fees', '5.23', '0'),
('1067', '', 'Professional Charges - Others', '5.23', '0'),
('1100', '', 'Insurance - Health Management Staff', '5.24', '0'),
('1110', '', 'Fire Insurance - Admin Building', '5.24', '0'),
('1115', '', 'NBT Expenses', '5.2', '0'),
('1120', '', 'Stamp Duty', '5.2', '0'),
('1125', '', 'Rates &amp; Taxes ', '5.2', '0'),
('1130', '', 'Entertainment Expenses', '5.2', '0'),
('1135', '', 'Newspapers &amp; Periodicals', '5.2', '0'),
('1140', '', 'Charity &amp; Donations', '5.2', '0'),
('1145', '', 'Security Fees', '5.2', '0'),
('1150', '', 'Postage &amp; Stamp Expenses ', '5.2', '0'),
('1155', '', 'Compliments Expenses', '5.2', '0'),
('1160', '', 'Surcharges', '5.2', '0'),
('1170', '', 'Sundry Expenses', '5.2', '0'),
('1180', '', 'Depreciation Expenses - Buildings Constructions', '5.25', '0'),
('1182', '', 'Depreciation Expenses - Motor Vehicles ', '5.25', '0'),
('1184', '', 'Depreciation Expenses - Furniture &amp; Fittings', '5.25', '0'),
('1185', '', 'Depreciation Expenses - Equipments', '5.25', '0'),
('1186', '', 'Depreciation Expenses - Computer Systems', '5.25', '0'),
('1187', '', 'Depreciation Expenses - Fixture &amp; Fittings', '5.25', '0'),
('1190', '', 'Depreciation Expenses -  Telephone, Network &amp; Camera Sys', '5.25', '0'),
('1194', '', 'Depreciation Expenses - Tools, Network &amp; Camera System', '5.25', '0'),
('1198', '', 'Depreciation Expenses - Intangible Assets', '5.25', '0'),
('2010', '', 'Advertisements - News Papers', '5.31', '0'),
('2012', '', 'Advertisements - Commercial', '5.31', '0'),
('2018', '', 'Advertisements - Street Promotions', '5.31', '0'),
('2019', '', 'Advertisements - Hoardings', '5.31', '0'),
('2020', '', 'Advertisements - Film Strips', '5.31', '0'),
('2030', '', 'Insurance - Motor Vehicles', '5.32', '0'),
('2040', '', 'Fuel for Motor Vehicle - 300-3314', '5.33', '0'),
('2041', '', 'Fuel for Motor Vehicle - KM 2544', '5.33', '0'),
('2042', '', 'Fuel for Motor Vehicle - PC 9961', '5.33', '0'),
('2045', '', 'Fuel for Motor Vehicle (Rosa Bus) - NB 2061', '5.33', '0'),
('2046', '', 'Fuel for Motor Vehicle (TATA Bus) - NB 2061', '5.33', '0'),
('2048', '', 'Fuel for Motor Vehicle (Star Bus) - NB 5269', '5.33', '0'),
('2049', '', 'Fuel for Motor Vehicle - PF 4326', '5.33', '0'),
('2051', '', 'Fuel for Motor Vehicle - NC 1950', '5.33', '0'),
('2052', '', 'Fuel for Motor Vehicle - CAE 2377', '5.33', '0'),
('2053', '', 'Fuel for Motor Vehicle - KI 8024', '5.33', '0'),
('2054', '', 'Fuel for Motor Vehicle - CAE 0232', '5.33', '0'),
('2055', '', 'Fuel for Motor Vehicle - GY 4483', '5.33', '0'),
('2056', '', 'Fuel for Motor Vehicle - CAC 8447', '5.33', '0'),
('2057', '', 'Fuel for Motor Vehicle - NC 5463', '5.33', '0'),
('2059', '', 'Fuel for Motor Vehicle - NC 7403', '5.33', '0'),
('2062', '', 'Fuel for Motor Bike - XP 5149', '5.33', '0'),
('2064', '', 'Fuel for Motor Bike - XF 4202', '5.33', '0'),
('2067', '', 'Fuel for Motor Vehicle - HA 5533', '5.33', '0'),
('2068', '', 'Fuel for Motor Vehicle - KW 5231', '5.33', '0'),
('2070', '', 'Repairs &amp; Maintenance - Motor Car 300-3314', '5.34', '0'),
('2072', '', 'Repairs &amp; Maintenance (Rosa Bus) - NB 7999', '5.34', '0'),
('2073', '', 'Repairs &amp; Maintenance - Star Bus NB 5269', '5.34', '0'),
('2074', '', 'Repairs &amp; Maintenance - Motor Van - PF 4326', '5.34', '0'),
('2076', '', 'Repairs &amp; Maintenance - Motor Vehicle KI 8024', '5.34', '0'),
('2078', '', 'Repairs &amp; Maintenance - Motor Vehicle - CAE 0232', '5.34', '0'),
('2079', '', 'Repairs &amp; Maintenance - Motor Vehicle - NC 1950', '5.34', '0'),
('2080', '', 'Repairs &amp; Maintenance - Motor Vehicle - GY 4483', '5.34', '0'),
('2081', '', 'Repairs &amp; Maintenance - Motor Vehicle - CAC 8447', '5.34', '0'),
('2094', '', 'Repairs &amp; Maintenance - Motor Vehicle - TATA Bus - 5463', '5.34', '0'),
('2096', '', 'Repairs &amp; Maintenance - Motor Vehicle - NC 7403', '5.34', '0'),
('2097', '', 'Repairs &amp; Maintenance - Motor Vehicle - XF 7403', '5.34', '0'),
('2098', '', 'Repairs &amp; Maintenance - Motor Vehicle - Others', '5.34', '0'),
('2210', '', 'Registration &amp; Licence Fees - Motor Vehicles', '5.35', '0'),
('2215', '', 'Registration &amp; Licence Fees - British Council', '5.35', '0'),
('2216', '', 'Registration &amp; Licence Fees - BOI', '5.35', '0'),
('2218', '', 'Registration &amp; Licence Fees - Others', '5.35', '0'),
('2250', '', 'Business Promotional Expenses', '5.3', '0'),
('2260', '', 'Travelling Charges', '5.3', '0'),
('2270', '', 'Transport Charges', '5.3', '0'),
('2280', '', 'Parking Reservation Expenses', '5.3', '0'),
('2310', '', 'Bank Loan Interest - Commercial Bank', '5.4', '0'),
('2312', '', 'Bank Loan Interest - BOC', '5.4', '0'),
('2318', '', 'Bank Loan Interest - Seylan Bank', '5.4', '0'),
('2319', '', 'Bank Loan Interest - Sampath Bank', '5.4', '0'),
('2330', '', 'Overdraft Interest - Commercial Bank', '5.4', '0'),
('2334', '', 'Overdraft Interest - BOC', '5.4', '0'),
('2335', '', 'Overdraft Interest - Seylan Bank ', '5.4', '0'),
('2336', '', 'Overdraft Interest - Sampath Bank', '5.4', '0'),
('2338', '', 'Overdraft Interest - Peoples Bank', '5.4', '0'),
('2350', '', 'Temporary Loan Interest - BOC', '5.4', '0'),
('2352', '', 'Temporary Loan Interest - Commercial Bank', '5.4', '0'),
('2354', '', 'Temporary Loan Interest - Sampath Bank', '5.4', '0'),
('2356', '', 'Temporary Loan Interest - Seylan Bank', '5.4', '0'),
('2357', '', 'Temporary Loan Interest - Peoples Bank', '5.4', '0'),
('2358', '', 'Temporary Loan Interest - Mr. Daranagama', '5.4', '0'),
('2359', '', 'Temporary Loan Interest - Ms. Muditha', '5.4', '0'),
('2364', '', 'Temporary Loan Interest - Mr. Karunanayake', '5.4', '0'),
('2368', '', 'Temporary Loan Interest - Mr Pandithasundara', '5.4', '0'),
('2370', '', 'Lease Interest - Commercial Bank', '5.4', '0'),
('2374', '', 'Lease Interest - BOC', '5.4', '0'),
('2378', '', 'Lease Interest - Seylan Bank', '5.4', '0'),
('2379', '', 'Lease Interest - Sampath Bank', '5.4', '0'),
('2400', '', 'Bank Charges - BOC', '5.41', '0'),
('2402', '', 'Bank Charges - Commercial Bank', '5.41', '0'),
('2405', '', 'Bank Charges - Seylan Bank', '5.41', '0'),
('2407', '', 'Bank Charges - Sampath Bank', '5.41', '0'),
('2408', '', 'Bank Charges - People&#039;s Bank', '5.41', '0'),
('2420', '', 'Bank Commission - BOC', '5.42', '0'),
('2422', '', 'Bank Commission - Seylan Bank', '5.42', '0'),
('2424', '', 'Bank Commission - Sampath Bank', '5.42', '0'),
('2427', '', 'Bank Commission - on Amex Cards', '5.42', '0'),
('40000', '', 'IMA - Registration Fees', '4.1', '0'),
('40001', '', 'IMA-Course Fees Income', '4.1', '0'),
('40002', '', 'IMA-Other Income', '4.1', '0'),
('40003', '', 'IMA Franchise Fees From Centers', '4.1', '0'),
('40004', '', 'Monthly Fee Income', '4.1', '0'),
('41000', '', 'Admission Fees ', '4.2', '0'),
('42000', '', 'Child Care Admission Fees', '4.3', '0'),
('49900', '', 'Procceds from sale of Assets', '4.8', '0'),
('49960', '', 'Other Income', '4.8', '0'),
('591', '', 'Sales of School Bags &amp; Others', '4.7', '0');

### Structure of table `3_chart_types` ###

DROP TABLE IF EXISTS `3_chart_types`;

CREATE TABLE `3_chart_types` (
  `id` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `class_id` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '-1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_chart_types` ###

INSERT INTO `3_chart_types` VALUES
(' 5.11', 'Purchases', '5', '5.1', '0'),
('1.1', 'Non-Current Asset', '1', '', '0'),
('1.11', 'Land', '1', '1.1', '0'),
('1.12', 'Buildings', '1', '1.1', '0'),
('1.13', 'Capital Work In Progress', '1', '1.1', '0'),
('1.16', 'Plant &amp; Equipment', '1', '1.1', '0'),
('1.17', 'Furniture &amp; Fittings', '1', '1.1', '0'),
('1.18', 'Motor Vehicles', '1', '1.1', '0'),
('1.19', 'Office Equipment', '1', '1.1', '0'),
('1.191', 'Intangible Assets', '1', '1.1', '0'),
('1.195', 'Provision for Depreciation', '1', '1.1', '0'),
('1.2', 'Current Assets', '1', '', '0'),
('1.21', 'Inventory', '1', '1.2', '0'),
('1.22', 'Trade Recievables', '1', '1.2', '0'),
('1.23', 'Other Receivables ', '1', '1.2', '0'),
('1.24', 'Other Current Assets', '1', '1.2', '0'),
('1.25', 'Amounts Due From Related Parties', '1', '1.2', '0'),
('1.26', 'Cash At Bank', '1', '1.2', '0'),
('1.27', 'Cash In Hand', '1', '1.2', '0'),
('1.3', 'Financial Assets', '1', '', '0'),
('1.31', 'Fixed Deposit', '1', '1.3', '0'),
('2.1', 'Equity', '2', '', '0'),
('2.11', 'Partner&#039;s Current Account', '2', '2.1', '0'),
('3.1', 'Non-Current Liabilities', '3', '', '0'),
('3.11', 'Bank Loans', '3', '3.1', '0'),
('3.12', 'Lease Creditiors', '3', '3.1', '0'),
('3.13', 'Other Long Term Loans', '3', '3.1', '0'),
('3.2', 'Current Liabilities', '3', '', '0'),
('3.21', 'Retirement Benefits', '3', '3.2', '0'),
('3.22', 'Trade Payables', '3', '3.2', '0'),
('3.23', 'Other Payables', '3', '3.2', '0'),
('3.24', 'Government Payables', '3', '3.2', '0'),
('3.25', 'Other Short Term Loans', '3', '3.2', '0'),
('3.26', 'Amounts Due To Related Parties', '3', '3.2', '0'),
('4', 'Income', '4', '', '0'),
('4.1', 'IMA Fees Income', '4', '4', '0'),
('4.2', 'School Fees Income', '4', '4', '0'),
('4.3', 'Child Care Fees Income', '4', '4', '0'),
('4.4', 'Hostel Rent Income', '4', '4', '0'),
('4.5', 'Swimming Pool Fees Income', '4', '4', '0'),
('4.51', 'Interest Income', '4', '', '0'),
('4.6', 'Rent Income', '4', '4', '0'),
('4.7', 'Sales Income', '4', '4', '0'),
('4.71', 'Other Income', '4', '', '0'),
('4.8', 'Other Income', '4', '4', '0'),
('5.0', 'Expenses', '5', '', '0'),
('5.1', 'School Operating Expenses', '5', '', '0'),
('5.12', 'Salaries &amp; Wages', '5', '5.1', '0'),
('5.13', 'Electricity Expenses', '5', '5.1', '0'),
('5.14', 'Telephone Expenses', '5', '5.1', '0'),
('5.15', 'Water Expenses', '5', '5.1', '0'),
('5.16', 'Special Event Expenses', '5', '5.1', '0'),
('5.17', 'Child Care Expenses', '5', '5.1', '0'),
('5.18', 'Insurance Expenses', '5', '5.1', '0'),
('5.19', 'Expenses on Educational Equipments', '5', '5.1', '0'),
('5.191', 'Student Care Expenses', '5', '5.1', '0'),
('5.192', 'Renovation Of Buildings', '5', '5.1', '0'),
('5.193', 'Maintenance Of Sports Complex', '5', '5.1', '0'),
('5.2', 'Administrative &amp; Other Expenses', '5', '', '0'),
('5.21', 'Repairs &amp; Maintenance Expenses', '5', '5.2', '0'),
('5.22', 'Salaries &amp; Wages', '5', '5.2', '0'),
('5.23', 'Professional Charges', '5', '5.2', '0'),
('5.24', 'Insurance Expenses', '5', '5.2', '0'),
('5.25', 'Depreciation Expenses', '5', '5.2', '0'),
('5.3', 'Marketing &amp; Selling Expenses', '5', '', '0'),
('5.31', 'Advertising Expenses', '5', '5.3', '0'),
('5.32', 'Insurance Expenses', '5', '5.3', '0'),
('5.33', 'Fuel Expenses', '5', '5.3', '0'),
('5.34', 'Repairs &amp; Maintenance - Motor Vehicles', '5', '5.3', '0'),
('5.35', 'Registration &amp; License Fees', '5', '5.3', '0'),
('5.4', 'Interest Expenses', '5', '', '0'),
('5.41', 'Bank Charges', '5', '5.4', '0'),
('5.42', 'Bank Commision', '5', '5.4', '0');

### Structure of table `3_cheque_books` ###

DROP TABLE IF EXISTS `3_cheque_books`;

CREATE TABLE `3_cheque_books` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(6) NOT NULL DEFAULT '0',
  `branch_code` varchar(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bank_code` varchar(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cheqeu_book_no` int(5) DEFAULT NULL,
  `chque_start_no` varchar(6) COLLATE utf8_unicode_ci DEFAULT NULL,
  `chque_end_no` varchar(6) COLLATE utf8_unicode_ci DEFAULT NULL,
  `added_date` datetime NOT NULL,
  `version` int(5) DEFAULT '0',
  `next_no_payment` varchar(6) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user` int(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_cheque_books` ###

INSERT INTO `3_cheque_books` VALUES
('1', '4', '009', '7214', '1', '001673', '001800', '2017-08-02 06:57:39', '2', '1654', '1', '0'),
('2', '5', '001', '7038', '1', '002352', '002440', '2017-09-25 22:03:42', '1', '2307', '1', '0'),
('3', '6', '001', '7038', '1', '010591', '010700', '2017-09-21 21:55:13', '3', '10605', '1', '0');

### Structure of table `3_comments` ###

DROP TABLE IF EXISTS `3_comments`;

CREATE TABLE `3_comments` (
  `type` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_comments` ###

INSERT INTO `3_comments` VALUES
('0', '5', '2017-04-30', 'test entry'),
('0', '6', '2017-05-31', 'test entry'),
('0', '7', '2017-06-30', 'test entry'),
('0', '8', '2017-07-31', 'test entry'),
('0', '9', '2017-08-31', 'test entry'),
('0', '10', '2017-09-30', 'test entry'),
('0', '11', '2017-10-31', 'test entry'),
('0', '12', '2017-11-30', 'test entry'),
('0', '13', '2017-12-31', 'test entry'),
('0', '14', '2018-01-31', 'test entry'),
('0', '15', '2018-02-28', 'test entry'),
('0', '16', '2018-03-31', 'test entry'),
('0', '17', '2017-04-03', 'fdfgfg');

### Structure of table `3_credit_status` ###

DROP TABLE IF EXISTS `3_credit_status`;

CREATE TABLE `3_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_credit_status` ###

INSERT INTO `3_credit_status` VALUES
('1', 'Good History', '0', '0'),
('3', 'No more work until payment received', '1', '0'),
('4', 'In liquidation', '1', '0');

### Structure of table `3_crm_categories` ###

DROP TABLE IF EXISTS `3_crm_categories`;

CREATE TABLE `3_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `system` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_crm_categories` ###

INSERT INTO `3_crm_categories` VALUES
('1', 'cust_branch', 'general', 'General', 'General contact data for customer branch (overrides company setting)', '1', '0'),
('2', 'cust_branch', 'invoice', 'Invoices', 'Invoice posting (overrides company setting)', '1', '0'),
('3', 'cust_branch', 'order', 'Orders', 'Order confirmation (overrides company setting)', '1', '0'),
('4', 'cust_branch', 'delivery', 'Deliveries', 'Delivery coordination (overrides company setting)', '1', '0'),
('5', 'customer', 'general', 'General', 'General contact data for customer', '1', '0'),
('6', 'customer', 'order', 'Orders', 'Order confirmation', '1', '0'),
('7', 'customer', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('8', 'customer', 'invoice', 'Invoices', 'Invoice posting', '1', '0'),
('9', 'supplier', 'general', 'General', 'General contact data for supplier', '1', '0'),
('10', 'supplier', 'order', 'Orders', 'Order confirmation', '1', '0'),
('11', 'supplier', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('12', 'supplier', 'invoice', 'Invoices', 'Invoice posting', '1', '0');

### Structure of table `3_crm_contacts` ###

DROP TABLE IF EXISTS `3_crm_contacts`;

CREATE TABLE `3_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT '0' COMMENT 'foreign key to crm_contacts',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `entity_id` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_crm_contacts` ###

INSERT INTO `3_crm_contacts` VALUES
('1', '1', 'supplier', 'general', '1');

### Structure of table `3_crm_persons` ###

DROP TABLE IF EXISTS `3_crm_persons`;

CREATE TABLE `3_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `name2` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` tinytext COLLATE utf8_unicode_ci,
  `phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone2` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lang` char(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_crm_persons` ###

INSERT INTO `3_crm_persons` VALUES
('1', 'ABC', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0');

### Structure of table `3_currencies` ###

DROP TABLE IF EXISTS `3_currencies`;

CREATE TABLE `3_currencies` (
  `currency` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `auto_update` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_currencies` ###

INSERT INTO `3_currencies` VALUES
('Sri Lankan Rupees', 'LKR', 'Rs', 'Sri Lanka', 'Cents', '0', '1');

### Structure of table `3_cust_allocations` ###

DROP TABLE IF EXISTS `3_cust_allocations`;

CREATE TABLE `3_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_cust_allocations` ###


### Structure of table `3_cust_branch` ###

DROP TABLE IF EXISTS `3_cust_branch`;

CREATE TABLE `3_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `br_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `br_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT '0',
  `default_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `receivables_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT '1',
  `br_post_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT '0',
  `notes` tinytext COLLATE utf8_unicode_ci,
  `bank_account` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `branch_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_cust_branch` ###


### Structure of table `3_debtor_trans` ###

DROP TABLE IF EXISTS `3_debtor_trans`;

CREATE TABLE `3_debtor_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `version` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `debtor_no` int(11) unsigned NOT NULL DEFAULT '0',
  `branch_code` int(11) NOT NULL DEFAULT '-1',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT '0',
  `order_` int(11) NOT NULL DEFAULT '0',
  `ov_amount` double NOT NULL DEFAULT '0',
  `ov_gst` double NOT NULL DEFAULT '0',
  `ov_freight` double NOT NULL DEFAULT '0',
  `ov_freight_tax` double NOT NULL DEFAULT '0',
  `ov_discount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  `ship_via` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`type`,`trans_no`,`debtor_no`),
  KEY `debtor_no` (`debtor_no`,`branch_code`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_debtor_trans` ###


### Structure of table `3_debtor_trans_details` ###

DROP TABLE IF EXISTS `3_debtor_trans_details`;

CREATE TABLE `3_debtor_trans_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_trans_no` int(11) DEFAULT NULL,
  `debtor_trans_type` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `unit_price` double NOT NULL DEFAULT '0',
  `unit_tax` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `discount_percent` double NOT NULL DEFAULT '0',
  `standard_cost` double NOT NULL DEFAULT '0',
  `qty_done` double NOT NULL DEFAULT '0',
  `src_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`debtor_trans_type`,`debtor_trans_no`),
  KEY `src_id` (`src_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_debtor_trans_details` ###


### Structure of table `3_debtors_master` ###

DROP TABLE IF EXISTS `3_debtors_master`;

CREATE TABLE `3_debtors_master` (
  `debtor_no` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address` tinytext COLLATE utf8_unicode_ci,
  `tax_id` varchar(55) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type` int(11) NOT NULL DEFAULT '1',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `credit_status` int(11) NOT NULL DEFAULT '0',
  `payment_terms` int(11) DEFAULT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `pymt_discount` double NOT NULL DEFAULT '0',
  `credit_limit` float NOT NULL DEFAULT '1000',
  `notes` tinytext COLLATE utf8_unicode_ci,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `debtor_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`debtor_no`),
  UNIQUE KEY `debtor_ref` (`debtor_ref`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_debtors_master` ###


### Structure of table `3_dimensions` ###

DROP TABLE IF EXISTS `3_dimensions`;

CREATE TABLE `3_dimensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_` tinyint(1) NOT NULL DEFAULT '1',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  KEY `date_` (`date_`),
  KEY `due_date` (`due_date`),
  KEY `type_` (`type_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_dimensions` ###


### Structure of table `3_exchange_rates` ###

DROP TABLE IF EXISTS `3_exchange_rates`;

CREATE TABLE `3_exchange_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rate_buy` double NOT NULL DEFAULT '0',
  `rate_sell` double NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `curr_code` (`curr_code`,`date_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_exchange_rates` ###


### Structure of table `3_fiscal_year` ###

DROP TABLE IF EXISTS `3_fiscal_year`;

CREATE TABLE `3_fiscal_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `begin` date DEFAULT '0000-00-00',
  `end` date DEFAULT '0000-00-00',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `begin` (`begin`),
  UNIQUE KEY `end` (`end`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_fiscal_year` ###

INSERT INTO `3_fiscal_year` VALUES
('1', '2015-04-01', '2016-03-31', '0'),
('2', '2016-04-01', '2017-03-31', '0'),
('3', '2017-04-01', '2018-03-31', '0');

### Structure of table `3_gl_trans` ###

DROP TABLE IF EXISTS `3_gl_trans`;

CREATE TABLE `3_gl_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT '0',
  `type_no` int(11) NOT NULL DEFAULT '0',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `amount` double NOT NULL DEFAULT '0',
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `dimension_id` (`dimension_id`),
  KEY `dimension2_id` (`dimension2_id`),
  KEY `tran_date` (`tran_date`),
  KEY `account_and_tran_date` (`account`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_gl_trans` ###

INSERT INTO `3_gl_trans` VALUES
('1', '0', '1', '2018-05-28', '0205', '', '628320', '0', '0', NULL, NULL),
('2', '0', '1', '2018-05-28', '0054', '', '-628320', '0', '0', NULL, NULL),
('3', '0', '2', '2018-05-28', '0400', '', '500000', '0', '0', NULL, NULL),
('4', '0', '2', '2018-05-28', '0054', '', '-500000', '0', '0', NULL, NULL),
('5', '0', '3', '2018-05-28', '0205', '', '83440', '0', '0', NULL, NULL),
('6', '0', '3', '2018-05-28', '0054', '', '-83440', '0', '0', NULL, NULL),
('7', '0', '4', '2018-05-28', '0205', '', '591600', '0', '0', NULL, NULL),
('8', '0', '4', '2018-05-28', '0054', '', '-591600', '0', '0', NULL, NULL),
('9', '0', '5', '2018-05-28', '0150', '', '551820', '0', '0', NULL, NULL),
('10', '0', '5', '2018-05-28', '0054', '', '-551820', '0', '0', NULL, NULL),
('11', '0', '6', '2018-05-28', '0201', '', '431919', '0', '0', NULL, NULL),
('12', '0', '6', '2018-05-28', '0054', '', '-431919', '0', '0', NULL, NULL),
('13', '0', '7', '2018-05-28', '523', '', '12240', '0', '0', NULL, NULL),
('14', '0', '7', '2018-05-28', '0054', '', '-12240', '0', '0', NULL, NULL),
('15', '0', '8', '2018-05-28', '523', '', '12240', '0', '0', NULL, NULL),
('16', '0', '8', '2018-05-28', '0054', '', '-12240', '0', '0', NULL, NULL),
('17', '0', '9', '2018-05-28', '200', '', '-15000', '0', '0', NULL, NULL),
('18', '0', '9', '2018-05-28', '0054', '', '15000', '0', '0', NULL, NULL),
('19', '0', '10', '2018-05-28', '0201', '', '300000', '0', '0', NULL, NULL),
('20', '0', '10', '2018-05-28', '0054', '', '-300000', '0', '0', NULL, NULL),
('21', '0', '11', '2018-05-31', '0201', '', '628320', '0', '0', NULL, NULL),
('22', '0', '11', '2018-05-31', '0054', '', '-628320', '0', '0', NULL, NULL);

### Structure of table `3_grn_batch` ###

DROP TABLE IF EXISTS `3_grn_batch`;

CREATE TABLE `3_grn_batch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `purch_order_no` int(11) DEFAULT NULL,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rate` double DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `delivery_date` (`delivery_date`),
  KEY `purch_order_no` (`purch_order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_grn_batch` ###


### Structure of table `3_grn_items` ###

DROP TABLE IF EXISTS `3_grn_items`;

CREATE TABLE `3_grn_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_batch_id` int(11) DEFAULT NULL,
  `po_detail_item` int(11) NOT NULL DEFAULT '0',
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `qty_recd` double NOT NULL DEFAULT '0',
  `quantity_inv` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `grn_batch_id` (`grn_batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_grn_items` ###


### Structure of table `3_groups` ###

DROP TABLE IF EXISTS `3_groups`;

CREATE TABLE `3_groups` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_groups` ###

INSERT INTO `3_groups` VALUES
('1', 'Small', '0'),
('2', 'Medium', '0'),
('3', 'Large', '0');

### Structure of table `3_item_codes` ###

DROP TABLE IF EXISTS `3_item_codes`;

CREATE TABLE `3_item_codes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` smallint(6) unsigned NOT NULL,
  `quantity` double NOT NULL DEFAULT '1',
  `is_foreign` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `stock_id` (`stock_id`,`item_code`),
  KEY `item_code` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_item_codes` ###

INSERT INTO `3_item_codes` VALUES
('1', 'desk', 'desk', 'School Desks', '5', '1', '0', '0'),
('2', 'chairs', 'chairs', 'School Chairs', '5', '1', '0', '0'),
('3', 'TESTITEM', 'TESTITEM', 'TEST ITEM', '1', '1', '0', '0'),
('5', 'motorvan-PF4326', 'motorvan-PF4326', 'Motor Van - PF 4326', '11', '1', '0', '0'),
('6', 'motorbicycleXF4202', 'motorbicycleXF4202', 'Motor Bicycle - XF 4202', '11', '1', '0', '0');

### Structure of table `3_item_tax_type_exemptions` ###

DROP TABLE IF EXISTS `3_item_tax_type_exemptions`;

CREATE TABLE `3_item_tax_type_exemptions` (
  `item_tax_type_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_tax_type_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_item_tax_type_exemptions` ###


### Structure of table `3_item_tax_types` ###

DROP TABLE IF EXISTS `3_item_tax_types`;

CREATE TABLE `3_item_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `exempt` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_item_tax_types` ###

INSERT INTO `3_item_tax_types` VALUES
('1', 'V.A.T.Output tax', '0', '0');

### Structure of table `3_item_units` ###

DROP TABLE IF EXISTS `3_item_units`;

CREATE TABLE `3_item_units` (
  `abbr` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `decimals` tinyint(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`abbr`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_item_units` ###

INSERT INTO `3_item_units` VALUES
('ea.', 'Each', '0', '0'),
('Kgs.', 'Ch', '2', '0');

### Structure of table `3_journal` ###

DROP TABLE IF EXISTS `3_journal`;

CREATE TABLE `3_journal` (
  `type` smallint(6) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `tran_date` date DEFAULT '0000-00-00',
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `source_ref` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `event_date` date DEFAULT '0000-00-00',
  `doc_date` date NOT NULL DEFAULT '0000-00-00',
  `currency` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_journal` ###

INSERT INTO `3_journal` VALUES
('0', '1', '2018-05-28', '1', '', '2018-05-28', '2018-05-28', 'LKR', '628320', '1'),
('0', '2', '2018-05-28', '2', '', '2018-05-28', '2018-05-28', 'LKR', '500000', '1'),
('0', '3', '2018-05-28', '3', '', '2018-05-28', '2018-05-28', 'LKR', '83440', '1'),
('0', '4', '2018-05-28', '4', '', '2018-05-28', '2018-05-28', 'LKR', '591600', '1'),
('0', '5', '2018-05-28', '5', '', '2018-05-28', '2018-05-28', 'LKR', '551820', '1'),
('0', '6', '2018-05-28', '6', '', '2018-05-28', '2018-05-28', 'LKR', '431919', '1'),
('0', '7', '2018-05-28', '7', '', '2018-05-28', '2018-05-28', 'LKR', '12240', '1'),
('0', '8', '2018-05-28', '8', '', '2018-05-28', '2018-05-28', 'LKR', '12240', '1'),
('0', '9', '2018-05-28', '9', '', '2018-05-28', '2018-05-28', 'LKR', '15000', '1'),
('0', '10', '2018-05-28', '10', '', '2018-05-28', '2018-05-28', 'LKR', '300000', '1'),
('0', '11', '2018-05-31', '11', '', '2018-05-31', '2018-05-31', 'LKR', '628320', '1');

### Structure of table `3_loc_stock` ###

DROP TABLE IF EXISTS `3_loc_stock`;

CREATE TABLE `3_loc_stock` (
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `reorder_level` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`loc_code`,`stock_id`),
  KEY `stock_id` (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_loc_stock` ###

INSERT INTO `3_loc_stock` VALUES
('01', 'chairs', '0'),
('01', 'desk', '0'),
('01', 'motorbicycleXF4202', '0'),
('01', 'motorvan-PF4326', '0'),
('01', 'TESTITEM', '0'),
('02', 'chairs', '0'),
('02', 'desk', '0'),
('02', 'motorbicycleXF4202', '0'),
('02', 'motorvan-PF4326', '0'),
('02', 'TESTITEM', '0'),
('DEF', 'chairs', '0'),
('DEF', 'desk', '0'),
('DEF', 'motorbicycleXF4202', '0'),
('DEF', 'motorvan-PF4326', '0'),
('DEF', 'TESTITEM', '0');

### Structure of table `3_locations` ###

DROP TABLE IF EXISTS `3_locations`;

CREATE TABLE `3_locations` (
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `location_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fax` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fixed_asset` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_locations` ###

INSERT INTO `3_locations` VALUES
('01', 'Office', '', '', '', '', '', 'Office', '1', '0'),
('02', 'School', '', '', '', '', '', 'School', '1', '0'),
('DEF', 'Default', 'N/A', '', '', '', '', '', '0', '0');

### Structure of table `3_main_category` ###

DROP TABLE IF EXISTS `3_main_category`;

CREATE TABLE `3_main_category` (
  `main_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `main_cat_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL,
  PRIMARY KEY (`main_category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_main_category` ###


### Structure of table `3_main_locations` ###

DROP TABLE IF EXISTS `3_main_locations`;

CREATE TABLE `3_main_locations` (
  `main_loc_id` int(11) NOT NULL AUTO_INCREMENT,
  `main_loc_code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `main_loc_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `inactive` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`main_loc_id`),
  UNIQUE KEY `main_loc_code` (`main_loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_main_locations` ###


### Structure of table `3_payment_terms` ###

DROP TABLE IF EXISTS `3_payment_terms`;

CREATE TABLE `3_payment_terms` (
  `terms_indicator` int(11) NOT NULL AUTO_INCREMENT,
  `terms` char(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `days_before_due` smallint(6) NOT NULL DEFAULT '0',
  `day_in_following_month` smallint(6) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`terms_indicator`),
  UNIQUE KEY `terms` (`terms`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_payment_terms` ###

INSERT INTO `3_payment_terms` VALUES
('1', 'Due 15th Of the Following Month', '0', '17', '0'),
('2', 'Due By End Of The Following Month', '0', '30', '0'),
('3', 'Payment due within 10 days', '10', '0', '0'),
('4', 'Cash Only', '1', '0', '0');

### Structure of table `3_prices` ###

DROP TABLE IF EXISTS `3_prices`;

CREATE TABLE `3_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type_id` int(11) NOT NULL DEFAULT '0',
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `price` (`stock_id`,`sales_type_id`,`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_prices` ###


### Structure of table `3_print_profiles` ###

DROP TABLE IF EXISTS `3_print_profiles`;

CREATE TABLE `3_print_profiles` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `report` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `printer` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile` (`profile`,`report`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_print_profiles` ###

INSERT INTO `3_print_profiles` VALUES
('1', 'Out of office', NULL, '0'),
('2', 'Sales Department', NULL, '0'),
('3', 'Central', NULL, '2'),
('4', 'Sales Department', '104', '2'),
('5', 'Sales Department', '105', '2'),
('6', 'Sales Department', '107', '2'),
('7', 'Sales Department', '109', '2'),
('8', 'Sales Department', '110', '2'),
('9', 'Sales Department', '201', '2');

### Structure of table `3_printers` ###

DROP TABLE IF EXISTS `3_printers`;

CREATE TABLE `3_printers` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `queue` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `host` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `port` smallint(11) unsigned NOT NULL,
  `timeout` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_printers` ###

INSERT INTO `3_printers` VALUES
('1', 'QL500', 'Label printer', 'QL500', 'server', '127', '20'),
('2', 'Samsung', 'Main network printer', 'scx4521F', 'server', '515', '5'),
('3', 'Local', 'Local print server at user IP', 'lp', '', '515', '10');

### Structure of table `3_products_collections` ###

DROP TABLE IF EXISTS `3_products_collections`;

CREATE TABLE `3_products_collections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pc_code` varchar(4) COLLATE utf8_unicode_ci NOT NULL,
  `pc_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `inactive` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pc_code` (`pc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_products_collections` ###


### Structure of table `3_purch_data` ###

DROP TABLE IF EXISTS `3_purch_data`;

CREATE TABLE `3_purch_data` (
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT '0',
  `suppliers_uom` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `conversion_factor` double NOT NULL DEFAULT '1',
  `supplier_description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`supplier_id`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_purch_data` ###


### Structure of table `3_purch_order_details` ###

DROP TABLE IF EXISTS `3_purch_order_details`;

CREATE TABLE `3_purch_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT '0',
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `act_price` double NOT NULL DEFAULT '0',
  `std_cost_unit` double NOT NULL DEFAULT '0',
  `quantity_ordered` double NOT NULL DEFAULT '0',
  `quantity_received` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`),
  KEY `itemcode` (`item_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_purch_order_details` ###


### Structure of table `3_purch_order_details_csv` ###

DROP TABLE IF EXISTS `3_purch_order_details_csv`;

CREATE TABLE `3_purch_order_details_csv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_ref` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `item_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `price` double(16,2) DEFAULT NULL,
  `order_date` date NOT NULL,
  `requeried_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_purch_order_details_csv` ###


### Structure of table `3_purch_orders` ###

DROP TABLE IF EXISTS `3_purch_orders`;

CREATE TABLE `3_purch_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT '0',
  `comments` tinytext COLLATE utf8_unicode_ci,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `requisition_no` tinytext COLLATE utf8_unicode_ci,
  `into_stock_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `total` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_purch_orders` ###


### Structure of table `3_quick_entries` ###

DROP TABLE IF EXISTS `3_quick_entries`;

CREATE TABLE `3_quick_entries` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `usage` varchar(120) COLLATE utf8_unicode_ci DEFAULT NULL,
  `base_amount` double NOT NULL DEFAULT '0',
  `base_desc` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bal_type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_quick_entries` ###

INSERT INTO `3_quick_entries` VALUES
('1', '1', 'Rental', NULL, '0', 'Amount', '0'),
('2', '1', 'Phone', NULL, '0', 'Amount', '0'),
('3', '2', 'Sundry Income', NULL, '0', 'Amount', '0'),
('4', '1', 'Lease Payment', NULL, '125000', 'Base Amount', '0');

### Structure of table `3_quick_entry_lines` ###

DROP TABLE IF EXISTS `3_quick_entry_lines`;

CREATE TABLE `3_quick_entry_lines` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `qid` smallint(6) unsigned NOT NULL,
  `amount` double DEFAULT '0',
  `memo` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `dest_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` smallint(6) unsigned DEFAULT NULL,
  `dimension2_id` smallint(6) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_quick_entry_lines` ###

INSERT INTO `3_quick_entry_lines` VALUES
('1', '1', '0', '', '=', '307050', '0', '0'),
('4', '3', '0', '', '=', '200000', '0', '0'),
('5', '2', '0', '', 'a', '2250', '0', '0'),
('6', '2', '0', '', 'a', '0915', '0', '0');

### Structure of table `3_recurrent_invoices` ###

DROP TABLE IF EXISTS `3_recurrent_invoices`;

CREATE TABLE `3_recurrent_invoices` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order_no` int(11) unsigned NOT NULL,
  `debtor_no` int(11) unsigned DEFAULT NULL,
  `group_no` smallint(6) unsigned DEFAULT NULL,
  `days` int(11) NOT NULL DEFAULT '0',
  `monthly` int(11) NOT NULL DEFAULT '0',
  `begin` date NOT NULL DEFAULT '0000-00-00',
  `end` date NOT NULL DEFAULT '0000-00-00',
  `last_sent` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_recurrent_invoices` ###


### Structure of table `3_reflines` ###

DROP TABLE IF EXISTS `3_reflines`;

CREATE TABLE `3_reflines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` int(11) NOT NULL,
  `prefix` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pattern` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default` tinyint(1) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `prefix` (`trans_type`,`prefix`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_reflines` ###

INSERT INTO `3_reflines` VALUES
('1', '0', '', '12', '', '1', '0'),
('2', '1', '', '1', '', '1', '0'),
('3', '2', '', '1', '', '1', '0'),
('4', '4', '', '1', '', '1', '0'),
('5', '10', '', '1', '', '1', '0'),
('6', '11', '', '1', '', '1', '0'),
('7', '12', '', '1', '', '1', '0'),
('8', '13', '', '1', '', '1', '0'),
('9', '16', '', '1', '', '1', '0'),
('10', '17', '', '1', '', '1', '0'),
('11', '18', '', '1', '', '1', '0'),
('12', '20', '', '1', '', '1', '0'),
('13', '21', '', '1', '', '1', '0'),
('14', '22', '', '1', '', '1', '0'),
('15', '25', '', '1', '', '1', '0'),
('16', '26', '', '1', '', '1', '0'),
('17', '28', '', '1', '', '1', '0'),
('18', '29', '', '1', '', '1', '0'),
('19', '30', '', '1', '', '1', '0'),
('20', '32', '', '1', '', '1', '0'),
('21', '35', '', '1', '', '1', '0'),
('22', '40', '', '1', '', '1', '0'),
('32', '50', '', '123473', '', '1', '0');

### Structure of table `3_refs` ###

DROP TABLE IF EXISTS `3_refs`;

CREATE TABLE `3_refs` (
  `id` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`type`),
  KEY `Type_and_Reference` (`type`,`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_refs` ###

INSERT INTO `3_refs` VALUES
('1', '0', '1'),
('10', '0', '10'),
('11', '0', '11'),
('2', '0', '2'),
('3', '0', '3'),
('4', '0', '4'),
('5', '0', '5'),
('6', '0', '6'),
('7', '0', '7'),
('8', '0', '8'),
('9', '0', '9');

### Structure of table `3_requisition_details` ###

DROP TABLE IF EXISTS `3_requisition_details`;

CREATE TABLE `3_requisition_details` (
  `requisition_detail_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `requisition_id` int(11) DEFAULT NULL,
  `item_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `lpo_id` int(11) DEFAULT '0',
  `order_quantity` int(11) NOT NULL DEFAULT '0',
  `estimate_price` double NOT NULL DEFAULT '0',
  `quantity` int(11) NOT NULL DEFAULT '0',
  `price` double NOT NULL DEFAULT '0',
  `purpose` varchar(320) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`requisition_detail_id`),
  UNIQUE KEY `requisition_detail_id` (`requisition_detail_id`),
  KEY `3_requisition_details_requisition_id` (`requisition_id`),
  KEY `3_requisition_details_item_code` (`item_code`),
  KEY `3_requisition_details_supplier_id` (`supplier_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_requisition_details` ###


### Structure of table `3_requisitions` ###

DROP TABLE IF EXISTS `3_requisitions`;

CREATE TABLE `3_requisitions` (
  `requisition_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `point_of_use` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `narrative` varchar(240) COLLATE utf8_unicode_ci DEFAULT NULL,
  `application_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `completed` tinyint(4) NOT NULL DEFAULT '0',
  `processed` tinyint(4) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`requisition_id`),
  UNIQUE KEY `requisition_id` (`requisition_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_requisitions` ###


### Structure of table `3_sales_order_details` ###

DROP TABLE IF EXISTS `3_sales_order_details`;

CREATE TABLE `3_sales_order_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT '0',
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `stk_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `qty_sent` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `invoiced` double NOT NULL DEFAULT '0',
  `discount_percent` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `sorder` (`trans_type`,`order_no`),
  KEY `stkcode` (`stk_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_sales_order_details` ###


### Structure of table `3_sales_orders` ###

DROP TABLE IF EXISTS `3_sales_orders`;

CREATE TABLE `3_sales_orders` (
  `order_no` int(11) NOT NULL,
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `version` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `branch_code` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `customer_ref` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `comments` tinytext COLLATE utf8_unicode_ci,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `order_type` int(11) NOT NULL DEFAULT '0',
  `ship_via` int(11) NOT NULL DEFAULT '0',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `contact_phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `deliver_to` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `freight_cost` double NOT NULL DEFAULT '0',
  `from_stk_loc` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `payment_terms` int(11) DEFAULT NULL,
  `total` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`trans_type`,`order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_sales_orders` ###


### Structure of table `3_sales_pos` ###

DROP TABLE IF EXISTS `3_sales_pos`;

CREATE TABLE `3_sales_pos` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `pos_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `cash_sale` tinyint(1) NOT NULL,
  `credit_sale` tinyint(1) NOT NULL,
  `pos_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `pos_account` smallint(6) unsigned NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `pos_name` (`pos_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_sales_pos` ###

INSERT INTO `3_sales_pos` VALUES
('1', 'Default', '1', '1', 'DEF', '1', '0');

### Structure of table `3_sales_types` ###

DROP TABLE IF EXISTS `3_sales_types`;

CREATE TABLE `3_sales_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_type` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_included` int(1) NOT NULL DEFAULT '0',
  `factor` double NOT NULL DEFAULT '1',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_type` (`sales_type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_sales_types` ###

INSERT INTO `3_sales_types` VALUES
('1', 'Retail', '0', '1', '0'),
('2', 'Wholesale', '0', '1', '0');

### Structure of table `3_salesman` ###

DROP TABLE IF EXISTS `3_salesman`;

CREATE TABLE `3_salesman` (
  `salesman_code` int(11) NOT NULL AUTO_INCREMENT,
  `salesman_name` char(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_phone` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_fax` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `provision` double NOT NULL DEFAULT '0',
  `break_pt` double NOT NULL DEFAULT '0',
  `provision2` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`salesman_code`),
  UNIQUE KEY `salesman_name` (`salesman_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_salesman` ###

INSERT INTO `3_salesman` VALUES
('1', 'Sales Person', '', '', '', '5', '20000', '4', '0');

### Structure of table `3_security_roles` ###

DROP TABLE IF EXISTS `3_security_roles`;

CREATE TABLE `3_security_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sections` text COLLATE utf8_unicode_ci,
  `areas` text COLLATE utf8_unicode_ci,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `role` (`role`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_security_roles` ###

INSERT INTO `3_security_roles` VALUES
('1', 'Inquiries', 'Inquiries', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;773;774;2822;3073;3075;3076;3077;3329;3330;3331;3332;3333;3334;3335;5377;5633;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8450;8451;10497;10753;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15873;15882;16129;16130;16131;16132;775', '0'),
('2', 'System Administrator', 'System Administrator', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;9216;9472;9728;10496;10752;11008;13056;13312;15616;15872;16128', '513;514;515;516;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;775;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15629;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132', '0'),
('3', 'Salesman', 'Salesman', '768;3072;5632;8192;15872', '773;774;3073;3075;3081;5633;8194;15873;775', '0'),
('4', 'Stock Manager', 'Stock Manager', '2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128;768', '775', '0'),
('5', 'Production Manager', 'Production Manager', '512;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128;768', '775', '0'),
('6', 'Purchase Officer', 'Purchase Officer', '512;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128;768', '775', '0'),
('7', 'AR Officer', 'AR Officer', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;771;773;774;2818;2819;2820;2821;2822;2823;3073;3073;3074;3075;3076;3077;3078;3079;3080;3081;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5633;5634;5637;5638;5639;5640;5640;5889;5890;5891;8193;8194;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0'),
('8', 'AP Officer', 'AP Officer', '512;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128;768', '775', '0'),
('9', 'Accountant', 'New Accountant', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;9216;9472;9728;10496;10752;11008;13056;13312;15616;15872;16128;1008640', '521;522;523;525;769;770;771;772;774;775;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15629;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;1008740;1008741', '0'),
('10', 'Sub Admin', 'Sub Admin', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5637;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15873;15874;15876;15877;15878;15879;15880;15882;16129;16130;16131;16132;775', '0');

### Structure of table `3_shippers` ###

DROP TABLE IF EXISTS `3_shippers`;

CREATE TABLE `3_shippers` (
  `shipper_id` int(11) NOT NULL AUTO_INCREMENT,
  `shipper_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`shipper_id`),
  UNIQUE KEY `name` (`shipper_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_shippers` ###

INSERT INTO `3_shippers` VALUES
('1', 'Default', '', '', '', '', '0');

### Structure of table `3_sizes` ###

DROP TABLE IF EXISTS `3_sizes`;

CREATE TABLE `3_sizes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `size_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `size_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `inactive` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_sizes` ###


### Structure of table `3_sql_trail` ###

DROP TABLE IF EXISTS `3_sql_trail`;

CREATE TABLE `3_sql_trail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sql` text COLLATE utf8_unicode_ci NOT NULL,
  `result` tinyint(1) NOT NULL,
  `msg` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_sql_trail` ###


### Structure of table `3_stock_category` ###

DROP TABLE IF EXISTS `3_stock_category`;

CREATE TABLE `3_stock_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `dflt_tax_type` int(11) NOT NULL DEFAULT '1',
  `dflt_units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `dflt_mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `dflt_sales_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_cogs_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_inventory_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_adjustment_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_wip_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_dim1` int(11) DEFAULT NULL,
  `dflt_dim2` int(11) DEFAULT NULL,
  `dflt_no_sale` tinyint(1) NOT NULL DEFAULT '0',
  `dflt_no_purchase` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_stock_category` ###

INSERT INTO `3_stock_category` VALUES
('1', 'Components', '0', '1', 'each', 'B', '100100', '150000', '702000', '170100', '702040', '0', '0', '0', '0'),
('2', 'Charges', '0', '1', 'each', 'B', '100100', '150000', '702000', '170100', '702040', '0', '0', '0', '0'),
('3', 'Systems', '0', '1', 'each', 'B', '100100', '150000', '702000', '170100', '702040', '0', '0', '0', '0'),
('4', 'Services', '0', '1', 'each', 'B', '100100', '150000', '702000', '170100', '702040', '0', '0', '0', '0'),
('5', 'Furniture &amp; Fittings', '0', '0', 'ea.', 'F', '0630', '1184', '1184', '0001', '702040', '0', '0', '1', '0'),
('6', 'Plant &amp; Machinery', '0', '1', 'ea.', 'F', '49900', '10020', '10020', '49900', '702040', '0', '0', '1', '0'),
('10', 'Computer Equipments', '0', '1', 'ea.', 'F', '10030', '10030', '10030', '10030', '702040', '0', '0', '1', '0'),
('11', 'Motor Vehicles', '0', '1', 'ea.', 'F', '49900', '10040', '10040', '49900', '702040', '0', '0', '1', '0');

### Structure of table `3_stock_fa_class` ###

DROP TABLE IF EXISTS `3_stock_fa_class`;

CREATE TABLE `3_stock_fa_class` (
  `fa_class_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `long_description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `depreciation_rate` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fa_class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_stock_fa_class` ###

INSERT INTO `3_stock_fa_class` VALUES
('01', '01', 'Immovable Properties', 'Land and Buildings', '2.5', '0'),
('02', '02', 'Movable Properties', 'Plant, Machinery and Furniture ', '20', '0');

### Structure of table `3_stock_master` ###

DROP TABLE IF EXISTS `3_stock_master`;

CREATE TABLE `3_stock_master` (
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `long_description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cogs_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inventory_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `adjustment_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `wip_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` int(11) DEFAULT NULL,
  `dimension2_id` int(11) DEFAULT NULL,
  `purchase_cost` double NOT NULL DEFAULT '0',
  `material_cost` double NOT NULL DEFAULT '0',
  `labour_cost` double NOT NULL DEFAULT '0',
  `overhead_cost` double NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `no_sale` tinyint(1) NOT NULL DEFAULT '0',
  `no_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `editable` tinyint(1) NOT NULL DEFAULT '0',
  `depreciation_method` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'S',
  `depreciation_rate` double NOT NULL DEFAULT '0',
  `depreciation_factor` double NOT NULL DEFAULT '0',
  `depreciation_start` date NOT NULL DEFAULT '0000-00-00',
  `depreciation_date` date NOT NULL DEFAULT '0000-00-00',
  `fa_class_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_stock_master` ###

INSERT INTO `3_stock_master` VALUES
('chairs', '5', '1', 'School Chairs', '', 'ea.', 'F', '49900', '1184', '10030', '49900', '702040', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', 'D', '20', '0', '2018-04-01', '2018-04-01', '02'),
('desk', '5', '1', 'School Desks', '', 'ea.', 'F', '49900', '1184', '10030', '49900', '702040', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', 'D', '20', '0', '2018-04-01', '2018-04-01', '02'),
('motorbicycleXF4202', '11', '1', 'Motor Bicycle - XF 4202', '', 'ea.', 'F', '49900', '10040', '10040', '49900', '702040', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', 'D', '20', '0', '2018-04-01', '2018-04-01', '02'),
('motorvan-PF4326', '11', '1', 'Motor Van - PF 4326', '', 'ea.', 'F', '49900', '1184', '10040', '49900', '702040', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', 'D', '20', '0', '2018-04-01', '2018-04-01', '02'),
('TESTITEM', '1', '1', 'TEST ITEM', '', 'ea.', 'M', '0630', '1184', '10030', '0001', '10001', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '', '0', '0', '2018-05-01', '2018-05-01', '');

### Structure of table `3_stock_moves` ###

DROP TABLE IF EXISTS `3_stock_moves`;

CREATE TABLE `3_stock_moves` (
  `trans_id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` smallint(6) NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `price` double NOT NULL DEFAULT '0',
  `reference` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT '1',
  `standard_cost` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`trans_id`),
  KEY `type` (`type`,`trans_no`),
  KEY `Move` (`stock_id`,`loc_code`,`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_stock_moves` ###


### Structure of table `3_stock_serial` ###

DROP TABLE IF EXISTS `3_stock_serial`;

CREATE TABLE `3_stock_serial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serial_key` int(4) DEFAULT NULL,
  `year_month` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serial_no` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `manufacture_date` date DEFAULT NULL,
  `stock_in_date` timestamp NULL DEFAULT NULL,
  `type_no_in` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_no_in` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `stock_out_date` datetime DEFAULT NULL,
  `type_no_out` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_no_out` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `availability` int(1) DEFAULT '1',
  `serial_status` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty` int(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `serial_number` (`serial_no`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_stock_serial` ###


### Structure of table `3_stock_serial_genarate_log` ###

DROP TABLE IF EXISTS `3_stock_serial_genarate_log`;

CREATE TABLE `3_stock_serial_genarate_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serial_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `commnet` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `user` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `genarate_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_stock_serial_genarate_log` ###


### Structure of table `3_supp_allocations` ###

DROP TABLE IF EXISTS `3_supp_allocations`;

CREATE TABLE `3_supp_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `person_id` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_supp_allocations` ###


### Structure of table `3_supp_invoice_items` ###

DROP TABLE IF EXISTS `3_supp_invoice_items`;

CREATE TABLE `3_supp_invoice_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_trans_no` int(11) DEFAULT NULL,
  `supp_trans_type` int(11) DEFAULT NULL,
  `gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `grn_item_id` int(11) DEFAULT NULL,
  `po_detail_item_id` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `quantity` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `unit_tax` double NOT NULL DEFAULT '0',
  `memo_` tinytext COLLATE utf8_unicode_ci,
  `dimension_id` int(11) NOT NULL DEFAULT '0',
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `Transaction` (`supp_trans_type`,`supp_trans_no`,`stock_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_supp_invoice_items` ###

INSERT INTO `3_supp_invoice_items` VALUES
('1', '1', '20', '0927', '-1', '0', '', NULL, '0', '4500', '0', 'Rent payment for the month of may 2017', '0', '0'),
('2', '2', '20', '0927', '-1', '0', '', NULL, '0', '4500', '0', 'Rent payment for the month of may 2017', '0', '0'),
('3', '3', '20', '0927', '-1', '0', '', NULL, '0', '100000', '0', NULL, '0', '0');

### Structure of table `3_supp_trans` ###

DROP TABLE IF EXISTS `3_supp_trans`;

CREATE TABLE `3_supp_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `supplier_id` int(11) unsigned NOT NULL DEFAULT '0',
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `ov_amount` double NOT NULL DEFAULT '0',
  `ov_discount` double NOT NULL DEFAULT '0',
  `ov_gst` double NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '1',
  `alloc` double NOT NULL DEFAULT '0',
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`type`,`trans_no`,`supplier_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_supp_trans` ###


### Structure of table `3_suppliers` ###

DROP TABLE IF EXISTS `3_suppliers`;

CREATE TABLE `3_suppliers` (
  `supplier_id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `gst_no` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supp_account_no` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `website` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT '0',
  `dimension_id` int(11) DEFAULT '0',
  `dimension2_id` int(11) DEFAULT '0',
  `tax_group_id` int(11) DEFAULT NULL,
  `credit_limit` double NOT NULL DEFAULT '0',
  `purchase_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payable_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `supp_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `supp_ref` (`supp_ref`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_suppliers` ###

INSERT INTO `3_suppliers` VALUES
('1', 'ABC', '', 'Colombo', '', '', '', '', '', 'LKR', '2', '0', '0', '0', '1', '0', '0927', '0001', '0001', '', '0', 'ABC');

### Structure of table `3_sys_prefs` ###

DROP TABLE IF EXISTS `3_sys_prefs`;

CREATE TABLE `3_sys_prefs` (
  `name` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `length` smallint(6) DEFAULT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`name`),
  KEY `category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_sys_prefs` ###

INSERT INTO `3_sys_prefs` VALUES
('accounts_alpha', 'glsetup.general', 'tinyint', '1', '0'),
('accumulate_shipping', 'glsetup.customer', 'tinyint', '1', '0'),
('add_pct', 'setup.company', 'int', '5', '-1'),
('allow_negative_prices', 'glsetup.inventory', 'tinyint', '1', ''),
('allow_negative_stock', 'glsetup.inventory', 'tinyint', '1', '1'),
('alternative_tax_include_on_docs', 'setup.company', 'tinyint', '1', ''),
('auto_curr_reval', 'setup.company', 'smallint', '6', ''),
('bank_charge_act', 'glsetup.general', 'varchar', '15', '702000'),
('base_sales', 'setup.company', 'int', '11', '0'),
('bcc_email', 'setup.company', 'varchar', '100', ''),
('coy_logo', 'setup.company', 'varchar', '100', 'horizon.jpg'),
('coy_name', 'setup.company', 'varchar', '60', 'Horizon College International-Malabe'),
('coy_no', 'setup.company', 'varchar', '25', ''),
('creditors_act', 'glsetup.purchase', 'varchar', '15', '801000'),
('curr_default', 'setup.company', 'char', '3', 'LKR'),
('debtors_act', 'glsetup.sales', 'varchar', '15', '701000'),
('default_adj_act', 'glsetup.items', 'varchar', '15', '170100'),
('default_cogs_act', 'glsetup.items', 'varchar', '15', '150000'),
('default_credit_limit', 'glsetup.customer', 'int', '11', '1000'),
('default_delivery_required', 'glsetup.sales', 'smallint', '6', '1'),
('default_dim_required', 'glsetup.dims', 'int', '11', '20'),
('default_inv_sales_act', 'glsetup.items', 'varchar', '15', '100100'),
('default_inventory_act', 'glsetup.items', 'varchar', '15', '702000'),
('default_loss_on_asset_disposal_act', 'glsetup.items', 'varchar', '15', '5660'),
('default_prompt_payment_act', 'glsetup.sales', 'varchar', '15', '101100'),
('default_quote_valid_days', 'glsetup.sales', 'smallint', '6', '30'),
('default_receival_required', 'glsetup.purchase', 'smallint', '6', '10'),
('default_sales_act', 'glsetup.sales', 'varchar', '15', '100100'),
('default_sales_discount_act', 'glsetup.sales', 'varchar', '15', '101000'),
('default_wip_act', 'glsetup.items', 'varchar', '15', '702040'),
('default_workorder_required', 'glsetup.manuf', 'int', '11', '20'),
('deferred_income_act', 'glsetup.sales', 'varchar', '15', ''),
('depreciation_period', 'glsetup.company', 'tinyint', '1', '1'),
('domicile', 'setup.company', 'varchar', '55', ''),
('email', 'setup.company', 'varchar', '100', ''),
('exchange_diff_act', 'glsetup.general', 'varchar', '15', '204000'),
('f_year', 'setup.company', 'int', '11', '3'),
('fax', 'setup.company', 'varchar', '30', ''),
('freight_act', 'glsetup.customer', 'varchar', '15', '180100'),
('gl_closing_date', 'setup.closing_date', 'date', '8', ''),
('grn_clearing_act', 'glsetup.purchase', 'varchar', '15', '0'),
('gst_no', 'setup.company', 'varchar', '25', ''),
('legal_text', 'glsetup.customer', 'tinytext', '0', ''),
('loc_notification', 'glsetup.inventory', 'tinyint', '1', ''),
('login_tout', 'setup.company', 'smallint', '6', '6000'),
('no_customer_list', 'setup.company', 'tinyint', '1', '0'),
('no_item_list', 'setup.company', 'tinyint', '1', '0'),
('no_supplier_list', 'setup.company', 'tinyint', '1', '0'),
('no_zero_lines_amount', 'glsetup.sales', 'tinyint', '1', '1'),
('past_due_days', 'glsetup.general', 'int', '11', '30'),
('phone', 'setup.company', 'varchar', '30', ''),
('po_over_charge', 'glsetup.purchase', 'int', '11', '10'),
('po_over_receive', 'glsetup.purchase', 'int', '11', '10'),
('postal_address', 'setup.company', 'tinytext', '0', 'Malabe. Srilanka. '),
('print_invoice_no', 'glsetup.sales', 'tinyint', '1', '0'),
('print_item_images_on_quote', 'glsetup.inventory', 'tinyint', '1', ''),
('profit_loss_year_act', 'glsetup.general', 'varchar', '15', '9990'),
('pyt_discount_act', 'glsetup.purchase', 'varchar', '15', '101000'),
('retained_earnings_act', 'glsetup.general', 'varchar', '15', '499999'),
('round_to', 'setup.company', 'int', '5', '1'),
('show_po_item_codes', 'glsetup.purchase', 'tinyint', '1', '1'),
('suppress_tax_rates', 'setup.company', 'tinyint', '1', ''),
('tax_algorithm', 'glsetup.customer', 'tinyint', '1', '1'),
('tax_last', 'setup.company', 'int', '11', '1'),
('tax_prd', 'setup.company', 'int', '11', '1'),
('time_zone', 'setup.company', 'tinyint', '1', '0'),
('use_dimension', 'setup.company', 'tinyint', '1', '2'),
('use_fixed_assets', 'setup.company', 'tinyint', '1', '1'),
('use_manufacturing', 'setup.company', 'tinyint', '1', '1'),
('version_id', 'system', 'varchar', '11', '2.4.1');

### Structure of table `3_sys_types` ###

DROP TABLE IF EXISTS `3_sys_types`;

CREATE TABLE `3_sys_types` (
  `type_id` smallint(6) NOT NULL DEFAULT '0',
  `type_no` int(11) NOT NULL DEFAULT '1',
  `next_reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_sys_types` ###

INSERT INTO `3_sys_types` VALUES
('0', '17', '1'),
('1', '7', '1'),
('2', '4', '1'),
('4', '3', '1'),
('10', '16', '1'),
('11', '2', '1'),
('12', '6', '1'),
('13', '1', '1'),
('16', '2', '1'),
('17', '2', '1'),
('18', '1', '1'),
('20', '6', '1'),
('21', '1', '1'),
('22', '3', '1'),
('25', '1', '1'),
('26', '1', '1'),
('28', '1', '1'),
('29', '1', '1'),
('30', '0', '1'),
('32', '0', '1'),
('35', '1', '1'),
('40', '1', '1');

### Structure of table `3_tag_associations` ###

DROP TABLE IF EXISTS `3_tag_associations`;

CREATE TABLE `3_tag_associations` (
  `record_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `tag_id` int(11) NOT NULL,
  UNIQUE KEY `record_id` (`record_id`,`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_tag_associations` ###

INSERT INTO `3_tag_associations` VALUES
('0080', '1'),
('0081', '1'),
('0082', '1');

### Structure of table `3_tags` ###

DROP TABLE IF EXISTS `3_tags`;

CREATE TABLE `3_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_tags` ###

INSERT INTO `3_tags` VALUES
('1', '1', 'Interest in suspence', 'Interest in suspence', '0');

### Structure of table `3_tax_group_items` ###

DROP TABLE IF EXISTS `3_tax_group_items`;

CREATE TABLE `3_tax_group_items` (
  `tax_group_id` int(11) NOT NULL DEFAULT '0',
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `tax_shipping` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tax_group_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_tax_group_items` ###


### Structure of table `3_tax_groups` ###

DROP TABLE IF EXISTS `3_tax_groups`;

CREATE TABLE `3_tax_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_tax_groups` ###

INSERT INTO `3_tax_groups` VALUES
('1', 'Taxexempted', '0');

### Structure of table `3_tax_types` ###

DROP TABLE IF EXISTS `3_tax_types`;

CREATE TABLE `3_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rate` double NOT NULL DEFAULT '0',
  `sales_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `purchasing_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`rate`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_tax_types` ###

INSERT INTO `3_tax_types` VALUES
('1', '15', '0112', '0112', 'VAT', '0');

### Structure of table `3_trans_tax_details` ###

DROP TABLE IF EXISTS `3_trans_tax_details`;

CREATE TABLE `3_trans_tax_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `tran_date` date NOT NULL,
  `tax_type_id` int(11) NOT NULL DEFAULT '0',
  `rate` double NOT NULL DEFAULT '0',
  `ex_rate` double NOT NULL DEFAULT '1',
  `included_in_price` tinyint(1) NOT NULL DEFAULT '0',
  `net_amount` double NOT NULL DEFAULT '0',
  `amount` double NOT NULL DEFAULT '0',
  `memo` tinytext COLLATE utf8_unicode_ci,
  `reg_type` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Type_and_Number` (`trans_type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_trans_tax_details` ###


### Structure of table `3_useronline` ###

DROP TABLE IF EXISTS `3_useronline`;

CREATE TABLE `3_useronline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` int(15) NOT NULL DEFAULT '0',
  `ip` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `file` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_useronline` ###


### Structure of table `3_users` ###

DROP TABLE IF EXISTS `3_users`;

CREATE TABLE `3_users` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `real_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `role_id` int(11) NOT NULL DEFAULT '1',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_format` tinyint(1) NOT NULL DEFAULT '0',
  `date_sep` tinyint(1) NOT NULL DEFAULT '0',
  `tho_sep` tinyint(1) NOT NULL DEFAULT '0',
  `dec_sep` tinyint(1) NOT NULL DEFAULT '0',
  `theme` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'default',
  `page_size` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'A4',
  `prices_dec` smallint(6) NOT NULL DEFAULT '2',
  `qty_dec` smallint(6) NOT NULL DEFAULT '2',
  `rates_dec` smallint(6) NOT NULL DEFAULT '4',
  `percent_dec` smallint(6) NOT NULL DEFAULT '1',
  `show_gl` tinyint(1) NOT NULL DEFAULT '1',
  `show_codes` tinyint(1) NOT NULL DEFAULT '0',
  `show_hints` tinyint(1) NOT NULL DEFAULT '0',
  `last_visit_date` datetime DEFAULT NULL,
  `query_size` tinyint(1) unsigned NOT NULL DEFAULT '10',
  `graphic_links` tinyint(1) DEFAULT '1',
  `pos` smallint(6) DEFAULT '1',
  `print_profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `rep_popup` tinyint(1) DEFAULT '1',
  `sticky_doc_date` tinyint(1) DEFAULT '0',
  `startup_tab` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'orders',
  `transaction_days` int(6) NOT NULL DEFAULT '30' COMMENT 'Transaction days',
  `save_report_selections` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Save Report Selection Days',
  `use_date_picker` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Use Date Picker for all Date Values',
  `def_print_destination` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Default Report Destination',
  `def_print_orientation` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Default Report Orientation',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_users` ###

INSERT INTO `3_users` VALUES
('1', 'admin', '5f4dcc3b5aa765d61d8327deb882cf99', 'Administrator', '2', '', 'adm@adm.com', 'C', '0', '0', '0', '0', 'bluecollar', 'A4', '2', '2', '4', '1', '1', '0', '0', '2018-06-20 15:53:47', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0'),
('2', 'accountant', 'c8dd5d6372a5793331ab59dcd8717fc4', 'Welcome Mrs. Nirosha', '9', '', 'nirosha@horizoncollegei.com', 'C', '0', '0', '0', '0', 'bluecollar', 'A4', '2', '2', '4', '1', '1', '0', '0', '2018-05-12 11:14:11', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0'),
('3', 'horizon1', 'ad0234829205b9033196ba818f7a872b', 'testaccountant2', '9', '', NULL, 'C', '0', '0', '0', '0', 'bluecollar', 'A4', '2', '2', '4', '1', '1', '0', '0', '2017-09-11 10:59:45', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0'),
('4', 'Bandara', '11c134c6d1d9e19689f0287137aae1de', 'Wellcome Mr Bandara', '9', '5353553', NULL, 'C', '0', '0', '0', '0', 'bluecollar', 'A4', '2', '2', '4', '1', '1', '0', '0', '2018-02-15 15:17:49', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0');

### Structure of table `3_voided` ###

DROP TABLE IF EXISTS `3_voided`;

CREATE TABLE `3_voided` (
  `type` int(11) NOT NULL DEFAULT '0',
  `id` int(11) NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_voided` ###


### Structure of table `3_wo_costing` ###

DROP TABLE IF EXISTS `3_wo_costing`;

CREATE TABLE `3_wo_costing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `cost_type` tinyint(1) NOT NULL DEFAULT '0',
  `trans_type` int(11) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `factor` double NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_wo_costing` ###


### Structure of table `3_wo_issue_items` ###

DROP TABLE IF EXISTS `3_wo_issue_items`;

CREATE TABLE `3_wo_issue_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_id` int(11) DEFAULT NULL,
  `qty_issued` double DEFAULT NULL,
  `unit_cost` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_wo_issue_items` ###


### Structure of table `3_wo_issues` ###

DROP TABLE IF EXISTS `3_wo_issues`;

CREATE TABLE `3_wo_issues` (
  `issue_no` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workcentre_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`issue_no`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_wo_issues` ###


### Structure of table `3_wo_manufacture` ###

DROP TABLE IF EXISTS `3_wo_manufacture`;

CREATE TABLE `3_wo_manufacture` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_wo_manufacture` ###


### Structure of table `3_wo_requirements` ###

DROP TABLE IF EXISTS `3_wo_requirements`;

CREATE TABLE `3_wo_requirements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT '0',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre` int(11) NOT NULL DEFAULT '0',
  `units_req` double NOT NULL DEFAULT '1',
  `unit_cost` double NOT NULL DEFAULT '0',
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_issued` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_wo_requirements` ###


### Structure of table `3_workcentres` ###

DROP TABLE IF EXISTS `3_workcentres`;

CREATE TABLE `3_workcentres` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_workcentres` ###


### Structure of table `3_workorders` ###

DROP TABLE IF EXISTS `3_workorders`;

CREATE TABLE `3_workorders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wo_ref` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_reqd` double NOT NULL DEFAULT '1',
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `required_by` date NOT NULL DEFAULT '0000-00-00',
  `released_date` date NOT NULL DEFAULT '0000-00-00',
  `units_issued` double NOT NULL DEFAULT '0',
  `closed` tinyint(1) NOT NULL DEFAULT '0',
  `released` tinyint(1) NOT NULL DEFAULT '0',
  `additional_costs` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `wo_ref` (`wo_ref`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `3_workorders` ###
