# MySQL dump of database 'evolve8_360_v6' on host 'localhost'
# Backup Date and Time: 2021-03-08 05:22
# Built by EvolveAccounting EVOLVE360v6
# http://evolve-sl.com
# Company: Evolve Technologies
# User: Administrator

# Compatibility: 2.4.1


SET NAMES latin1;


### Structure of table `0_amortisation` ###

DROP TABLE IF EXISTS `0_amortisation`;

CREATE TABLE `0_amortisation` (
  `amortisation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `amortisation_year` int(11) DEFAULT NULL,
  `asset_value` double DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `posted` int(11) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`amortisation_id`),
  UNIQUE KEY `amortisation_id` (`amortisation_id`),
  KEY `0_amortisation_asset_id` (`asset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_amortisation` ###


### Structure of table `0_areas` ###

DROP TABLE IF EXISTS `0_areas`;

CREATE TABLE `0_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_areas` ###

INSERT INTO `0_areas` VALUES
('1', 'Global', '0');

### Structure of table `0_asset_types` ###

DROP TABLE IF EXISTS `0_asset_types`;

CREATE TABLE `0_asset_types` (
  `asset_type_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_type_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `depreciation_type` int(11) NOT NULL DEFAULT '1',
  `depreciation_rate` double NOT NULL DEFAULT '10',
  `asset_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `depreciation_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `accumulated_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `valuation_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `disposal_account` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_type_id`),
  UNIQUE KEY `asset_type_id` (`asset_type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_asset_types` ###


### Structure of table `0_asset_valuations` ###

DROP TABLE IF EXISTS `0_asset_valuations`;

CREATE TABLE `0_asset_valuations` (
  `asset_valuation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `valuation_year` int(11) DEFAULT NULL,
  `asset_value` double NOT NULL DEFAULT '0',
  `value_change` double NOT NULL DEFAULT '0',
  `posted` int(11) NOT NULL DEFAULT '0',
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_valuation_id`),
  UNIQUE KEY `asset_valuation_id` (`asset_valuation_id`),
  UNIQUE KEY `asset_id` (`asset_id`,`valuation_year`),
  KEY `0_asset_valuations_asset_id` (`asset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_asset_valuations` ###


### Structure of table `0_assets` ###

DROP TABLE IF EXISTS `0_assets`;

CREATE TABLE `0_assets` (
  `asset_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_type_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `asset_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_serial` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `purchase_date` date NOT NULL,
  `purchase_value` double NOT NULL,
  `disposal_amount` double DEFAULT NULL,
  `disposal_date` date DEFAULT NULL,
  `disposal_posting` int(11) DEFAULT '0',
  `tag_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_location` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_condition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `asset_acquisition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT '0',
  `details` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`asset_id`),
  UNIQUE KEY `asset_id` (`asset_id`),
  KEY `0_assets_asset_type_id` (`asset_type_id`),
  KEY `0_assets_item_id` (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_assets` ###


### Structure of table `0_attachments` ###

DROP TABLE IF EXISTS `0_attachments`;

CREATE TABLE `0_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_no` int(11) NOT NULL DEFAULT '0',
  `trans_no` int(11) NOT NULL DEFAULT '0',
  `unique_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT '0',
  `filetype` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attachments` ###


### Structure of table `0_audit_trail` ###

DROP TABLE IF EXISTS `0_audit_trail`;

CREATE TABLE `0_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `trans_no` int(11) unsigned NOT NULL DEFAULT '0',
  `user` smallint(6) unsigned NOT NULL DEFAULT '0',
  `stamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL DEFAULT '0',
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=24703 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_audit_trail` ###

INSERT INTO `0_audit_trail` VALUES
('1', '0', '1', '1', '2016-11-02 06:15:47', NULL, '1', '2016-03-31', NULL),
('2', '1', '1', '1', '2016-10-10 06:20:39', NULL, '2', '2016-04-04', NULL),
('3', '1', '2', '1', '2016-10-10 06:20:47', NULL, '2', '2016-04-05', NULL),
('4', '0', '2', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-01', '1'),
('5', '1', '1', '1', '2016-11-02 06:15:47', 'Voided.\n', '2', '2016-04-04', '0'),
('6', '1', '2', '1', '2016-11-02 06:15:47', 'Voided.\n', '2', '2016-04-05', '0'),
('7', '0', '1', '1', '2016-11-02 06:15:47', 'Voided.\n', '1', '2016-03-31', '0'),
('8', '0', '3', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-01', '2'),
('9', '0', '4', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-01', '3'),
('10', '0', '5', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-01', '4'),
('11', '0', '6', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-01', '5'),
('12', '0', '7', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-01', '6'),
('13', '0', '8', '1', '2016-10-17 03:12:51', NULL, '2', '2016-04-01', NULL),
('14', '0', '9', '1', '2016-10-17 03:15:26', NULL, '2', '2016-04-01', NULL),
('15', '0', '8', '1', '2018-02-05 04:47:11', NULL, '2', '2016-04-01', '1'),
('16', '0', '9', '1', '2018-02-05 04:47:11', NULL, '2', '2016-04-01', '2'),
('17', '0', '10', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-01', '7'),
('18', '0', '11', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-01', '8'),
('19', '0', '12', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-01', '9'),
('20', '0', '13', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-01', '10'),
('21', '0', '14', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-01', '11'),
('22', '1', '3', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-01', '12'),
('23', '1', '4', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-01', '13'),
('24', '1', '5', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-06', '15'),
('25', '1', '6', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-07', NULL),
('26', '1', '7', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-01', '14'),
('27', '1', '8', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-08', '18'),
('28', '1', '9', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-08', '19'),
('29', '1', '10', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-08', '20'),
('30', '1', '11', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-09', '21'),
('31', '1', '12', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-10', '22'),
('32', '1', '13', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-10', '23'),
('33', '1', '14', '1', '2016-10-24 05:07:09', NULL, '2', '2016-10-24', NULL),
('34', '1', '15', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-24', '27'),
('35', '1', '16', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-24', '28'),
('36', '1', '17', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-24', '29'),
('37', '1', '18', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-24', '30'),
('38', '1', '19', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-24', '31'),
('39', '1', '20', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-24', '32'),
('40', '1', '21', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-24', '33'),
('41', '1', '22', '1', '2016-10-24 06:05:04', NULL, '2', '2016-10-24', NULL),
('42', '1', '23', '1', '2019-11-05 05:45:21', NULL, '2', '2016-10-27', '160'),
('43', '1', '24', '1', '2019-11-05 05:45:21', NULL, '2', '2016-10-27', '161'),
('44', '1', '25', '1', '2019-11-05 05:45:21', NULL, '2', '2016-10-29', '163'),
('45', '1', '26', '1', '2019-11-05 05:45:21', NULL, '2', '2016-10-29', '164'),
('46', '1', '27', '1', '2016-11-02 06:15:47', NULL, '1', '2015-04-24', NULL),
('47', '1', '14', '1', '2016-10-24 05:07:09', 'Voided.\nDocument reentered.', '2', '2016-10-24', '0'),
('48', '1', '28', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-24', '34'),
('49', '1', '27', '1', '2016-11-02 06:15:47', 'Voided.\nDocument reentered.', '1', '2015-04-24', '0'),
('50', '1', '29', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-24', '35'),
('51', '1', '30', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-24', '36'),
('52', '1', '22', '1', '2016-10-24 06:05:04', 'Voided.\nDocument reentered.', '2', '2016-10-24', '0'),
('53', '1', '31', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-27', '37'),
('54', '1', '32', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-27', '38'),
('55', '1', '33', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-29', '42'),
('56', '1', '34', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-29', '43'),
('57', '1', '35', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-07', '17'),
('58', '1', '6', '1', '2016-11-02 06:15:47', 'Voided.\nDocument reentered.', '1', '2015-04-07', '0'),
('59', '2', '1', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-06', '16'),
('60', '2', '2', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-16', '24'),
('61', '2', '3', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-16', '25'),
('62', '2', '4', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-16', '26'),
('63', '2', '5', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-27', '39'),
('64', '2', '6', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-27', '40'),
('65', '2', '7', '1', '2018-02-05 04:47:11', NULL, '1', '2015-04-27', '41'),
('70', '10', '1', '10', '2017-10-24 04:57:19', 'Updated.', '3', '2017-03-06', NULL),
('75', '10', '2', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2016-07-20', '68'),
('80', '10', '3', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2016-10-20', '154'),
('81', '30', '1', '10', '2017-04-20 00:22:42', NULL, '2', '2016-06-12', '0'),
('82', '13', '1', '10', '2017-04-20 00:22:42', NULL, '2', '2016-06-12', '0'),
('83', '10', '4', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-12', '39'),
('84', '30', '2', '10', '2017-04-20 00:26:13', NULL, '2', '2017-01-05', '0'),
('85', '13', '2', '10', '2017-04-20 00:26:13', NULL, '2', '2017-01-05', '0'),
('86', '10', '5', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-05', '249'),
('87', '30', '3', '10', '2017-04-20 00:37:50', NULL, '2', '2016-08-10', '0'),
('88', '13', '3', '10', '2017-04-20 00:37:50', NULL, '2', '2016-08-10', '0'),
('89', '10', '6', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-10', '92'),
('90', '30', '4', '10', '2017-04-20 00:39:39', NULL, '2', '2016-10-07', '0'),
('91', '13', '4', '10', '2017-10-19 04:14:10', NULL, '3', '2016-10-07', NULL),
('92', '10', '7', '10', '2017-10-19 04:14:10', NULL, '3', '2016-10-07', NULL),
('93', '1', '36', '1', '2017-04-21 00:34:41', NULL, '3', '2017-03-31', NULL),
('94', '1', '37', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-03', '3'),
('95', '1', '38', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-03', '4'),
('96', '2', '8', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-03', '5'),
('97', '1', '39', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-04', '6'),
('98', '2', '9', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-04', '7'),
('99', '1', '40', '10', '2018-03-19 10:59:55', NULL, '3', '2017-04-04', NULL),
('100', '1', '41', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '12'),
('101', '1', '42', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '13'),
('102', '1', '43', '10', '2017-04-20 05:16:50', NULL, '3', '2017-04-05', NULL),
('103', '1', '43', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '14'),
('104', '1', '44', '10', '2017-04-20 05:17:42', NULL, '3', '2017-04-05', NULL),
('105', '1', '44', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '15'),
('106', '2', '10', '10', '2017-04-20 05:22:46', NULL, '3', '2017-04-05', NULL),
('107', '2', '10', '10', '2018-01-08 05:22:23', NULL, '3', '2017-04-05', NULL),
('108', '1', '45', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '16'),
('109', '1', '46', '10', '2017-11-10 02:55:08', NULL, '3', '2017-04-05', NULL),
('110', '2', '11', '10', '2017-04-20 05:27:42', NULL, '3', '2017-04-05', NULL),
('111', '2', '11', '10', '2018-01-08 05:36:58', NULL, '3', '2017-04-05', NULL),
('112', '2', '12', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '30'),
('113', '4', '1', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '31'),
('114', '1', '47', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '32'),
('115', '1', '48', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '33'),
('116', '1', '49', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '34'),
('117', '1', '50', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '35'),
('118', '1', '51', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '36'),
('119', '1', '52', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '37'),
('120', '1', '53', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '38'),
('121', '1', '54', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '39'),
('122', '1', '55', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '40'),
('123', '1', '56', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '41'),
('124', '1', '57', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '42'),
('125', '1', '58', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '43'),
('126', '1', '59', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '44'),
('127', '1', '60', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '45'),
('128', '1', '61', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '46'),
('129', '1', '62', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '47'),
('130', '1', '63', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '48'),
('131', '1', '64', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '49'),
('132', '1', '65', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '50'),
('133', '1', '66', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '51'),
('134', '1', '67', '10', '2017-04-20 05:52:11', NULL, '3', '2017-04-06', NULL),
('135', '1', '68', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '52'),
('136', '1', '67', '10', '2017-04-20 05:52:11', 'Voided.\nDocument reentered.', '3', '2017-04-20', '0'),
('137', '1', '69', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '53'),
('138', '1', '70', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '54'),
('139', '1', '71', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '55'),
('140', '1', '72', '10', '2017-04-20 05:56:46', NULL, '3', '2017-04-06', NULL),
('141', '1', '73', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '56'),
('142', '1', '74', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '57'),
('143', '1', '72', '10', '2017-04-20 05:56:46', 'Voided.\nDocument reentered.', '3', '2017-04-20', '0'),
('144', '1', '75', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '58'),
('145', '2', '13', '10', '2017-04-20 05:58:07', NULL, '3', '2017-04-06', NULL),
('146', '2', '13', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '59'),
('147', '2', '14', '10', '2017-04-20 05:59:13', NULL, '3', '2017-04-06', NULL),
('148', '2', '14', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '60'),
('149', '2', '15', '10', '2017-04-20 05:59:47', NULL, '3', '2017-04-06', NULL),
('150', '2', '15', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '61'),
('151', '2', '16', '10', '2017-04-20 06:00:17', NULL, '3', '2017-04-06', NULL),
('152', '2', '16', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '62'),
('153', '2', '17', '10', '2017-04-20 06:00:55', NULL, '3', '2017-04-06', NULL),
('154', '2', '17', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '63'),
('155', '2', '18', '10', '2017-04-20 06:01:35', NULL, '3', '2017-04-07', NULL),
('156', '2', '18', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '68'),
('157', '2', '19', '10', '2017-04-20 06:02:09', NULL, '3', '2017-04-07', NULL),
('158', '2', '19', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '69'),
('159', '1', '76', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '70'),
('160', '1', '77', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '71'),
('161', '2', '20', '10', '2017-04-20 06:05:12', NULL, '3', '2017-04-07', NULL),
('162', '2', '20', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '72'),
('163', '2', '21', '10', '2017-04-20 06:06:58', NULL, '3', '2017-04-07', NULL),
('164', '2', '21', '10', '2017-04-20 06:06:58', 'Voided.\n', '3', '2017-04-20', '0'),
('165', '1', '78', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '73'),
('166', '1', '79', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '74'),
('167', '1', '80', '10', '2018-03-19 10:43:32', NULL, '3', '2017-04-11', NULL),
('168', '2', '22', '10', '2017-04-20 06:10:11', NULL, '3', '2017-04-11', NULL),
('169', '2', '22', '10', '2018-01-08 05:37:06', NULL, '3', '2017-04-11', NULL),
('170', '2', '23', '10', '2017-04-20 06:10:53', NULL, '3', '2017-04-11', NULL),
('171', '2', '23', '10', '2018-01-08 05:37:15', NULL, '3', '2017-04-11', NULL),
('172', '2', '24', '10', '2017-04-20 06:12:09', NULL, '3', '2017-04-11', NULL),
('173', '2', '24', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '92'),
('174', '2', '25', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '93'),
('175', '2', '26', '10', '2017-04-20 06:13:26', NULL, '3', '2017-04-11', NULL),
('176', '2', '26', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '94'),
('177', '2', '27', '10', '2017-04-20 06:14:07', NULL, '3', '2017-04-11', NULL),
('178', '2', '27', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '95'),
('179', '2', '28', '10', '2017-04-20 06:15:37', NULL, '3', '2017-04-11', NULL),
('180', '2', '28', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '96'),
('181', '2', '29', '10', '2017-04-20 06:16:39', NULL, '3', '2017-04-11', NULL),
('182', '2', '29', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '97'),
('183', '2', '30', '10', '2017-04-20 06:17:32', NULL, '3', '2017-04-11', NULL),
('184', '2', '30', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '98'),
('185', '2', '31', '10', '2017-04-20 06:18:02', NULL, '3', '2017-04-11', NULL),
('186', '2', '31', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '99'),
('187', '2', '32', '10', '2017-04-20 06:18:33', NULL, '3', '2017-04-11', NULL),
('188', '2', '32', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '100'),
('189', '2', '33', '10', '2017-04-20 06:19:07', NULL, '3', '2017-04-11', NULL),
('190', '2', '33', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '101'),
('191', '2', '34', '10', '2017-04-20 06:19:39', NULL, '3', '2017-04-11', NULL),
('192', '2', '34', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '102'),
('193', '2', '35', '10', '2017-04-20 06:20:14', NULL, '3', '2017-04-11', NULL),
('194', '2', '35', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '103'),
('195', '2', '36', '10', '2017-04-20 06:20:52', NULL, '3', '2017-04-11', NULL),
('196', '2', '36', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '104'),
('197', '1', '81', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '105'),
('198', '1', '82', '10', '2018-01-04 03:32:31', NULL, '3', '2017-04-11', NULL),
('199', '1', '83', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '106'),
('200', '1', '84', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '107'),
('201', '1', '85', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '108'),
('202', '1', '86', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '109'),
('203', '1', '87', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '110'),
('204', '1', '88', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '111'),
('205', '1', '89', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '112'),
('206', '1', '90', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '113'),
('207', '4', '2', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-12', '131'),
('208', '1', '91', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-12', '132'),
('209', '2', '37', '10', '2017-04-21 00:14:02', NULL, '3', '2017-04-17', NULL),
('210', '2', '37', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-17', '139'),
('211', '2', '38', '10', '2017-04-21 00:14:45', NULL, '3', '2017-04-18', NULL),
('212', '2', '38', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-18', '145'),
('213', '2', '39', '10', '2017-04-21 00:15:27', NULL, '3', '2017-04-18', NULL),
('214', '2', '39', '10', '2017-05-16 02:26:01', NULL, '3', '2017-04-18', NULL),
('215', '2', '40', '10', '2017-04-21 00:16:19', NULL, '3', '2017-04-18', NULL),
('216', '2', '40', '10', '2017-04-21 00:17:40', NULL, '3', '2017-04-18', NULL),
('217', '2', '41', '10', '2017-04-21 00:17:40', NULL, '3', '2017-04-18', NULL),
('218', '2', '41', '10', '2018-01-08 06:21:45', NULL, '3', '2017-04-18', NULL),
('219', '2', '40', '10', '2017-04-21 00:17:40', 'Voided.\nDocument reentered.', '3', '2017-04-21', '0'),
('220', '2', '42', '10', '2017-04-21 00:18:56', NULL, '3', '2017-04-18', NULL),
('221', '2', '42', '10', '2018-01-08 05:31:33', NULL, '3', '2017-04-18', NULL),
('222', '1', '92', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-19', '154'),
('223', '2', '43', '10', '2017-04-21 00:24:38', NULL, '3', '2017-04-19', NULL),
('224', '2', '43', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-19', '155'),
('225', '2', '44', '10', '2017-04-21 00:25:37', NULL, '3', '2017-04-20', NULL),
('226', '2', '44', '10', '2017-06-05 04:29:34', NULL, '3', '2017-04-20', NULL),
('227', '1', '93', '10', '2018-08-08 05:58:29', NULL, '5', '2017-04-20', NULL),
('228', '1', '94', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-20', '160'),
('229', '1', '95', '10', '2017-06-02 03:45:15', NULL, '3', '2017-04-20', NULL),
('230', '4', '3', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-20', '161'),
('231', '1', '96', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-20', '162'),
('232', '2', '45', '10', '2017-04-21 00:33:36', NULL, '3', '2017-04-21', NULL),
('233', '2', '45', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-21', '172'),
('234', '1', '36', '10', '2017-04-21 00:34:41', 'Voided.\nBy Dilrukshi', '3', '2017-04-21', '0'),
('235', '1', '97', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-04', '8'),
('236', '1', '98', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-04', '9'),
('237', '1', '99', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '17'),
('238', '1', '100', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '18'),
('239', '1', '101', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '19'),
('240', '1', '102', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '20'),
('241', '1', '103', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '21'),
('242', '1', '104', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '64'),
('243', '1', '105', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '75'),
('244', '1', '106', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '76'),
('245', '1', '107', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '77'),
('246', '1', '108', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '78'),
('247', '1', '109', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '79'),
('248', '2', '46', '10', '2017-04-21 00:49:57', NULL, '3', '2017-04-07', NULL),
('249', '2', '46', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '80'),
('250', '2', '47', '10', '2017-04-21 00:50:42', NULL, '3', '2017-04-07', NULL),
('251', '2', '47', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '81'),
('252', '1', '110', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '82'),
('253', '1', '111', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '114'),
('254', '1', '112', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '115'),
('255', '1', '113', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '116'),
('256', '1', '114', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '117'),
('257', '2', '48', '10', '2017-04-21 00:55:34', NULL, '3', '2017-04-11', NULL),
('258', '2', '48', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '118'),
('259', '2', '49', '10', '2017-04-21 00:56:32', NULL, '3', '2017-04-11', NULL),
('260', '2', '49', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '119'),
('261', '2', '50', '10', '2017-04-21 00:57:04', NULL, '3', '2017-04-11', NULL),
('262', '2', '50', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '120'),
('263', '2', '51', '10', '2017-04-21 00:57:36', NULL, '3', '2017-04-11', NULL),
('264', '2', '51', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '121'),
('265', '2', '52', '10', '2017-04-21 00:58:28', NULL, '3', '2017-04-11', NULL),
('266', '2', '52', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '122'),
('267', '1', '115', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-12', '133'),
('268', '1', '116', '10', '2017-04-21 01:02:12', NULL, '3', '2017-04-12', NULL),
('269', '1', '117', '10', '2017-04-21 01:01:51', NULL, '3', '2017-04-12', NULL),
('270', '1', '118', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-20', '163'),
('271', '1', '117', '10', '2017-04-21 01:01:51', 'Voided.\nDocument reentered.', '3', '2017-04-21', '0'),
('272', '1', '119', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-17', '140'),
('273', '1', '116', '10', '2017-04-21 01:02:12', 'Voided.\nDocument reentered.', '3', '2017-04-21', '0'),
('280', '1', '120', '10', '2017-04-21 01:09:04', NULL, '3', '2017-04-11', NULL),
('281', '1', '121', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-20', '164'),
('282', '1', '122', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-20', '165'),
('283', '1', '120', '10', '2017-04-21 01:09:04', 'Voided.\nDocument reentered.', '3', '2017-04-21', '0'),
('284', '1', '123', '10', '2017-04-21 01:14:49', NULL, '3', '2017-04-20', NULL),
('285', '1', '124', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-21', '173'),
('286', '1', '123', '10', '2017-04-21 01:14:49', 'Voided.\nDocument reentered.', '3', '2017-04-21', '0'),
('287', '1', '125', '10', '2018-03-06 23:09:33', NULL, '3', '2017-04-20', NULL),
('288', '1', '126', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-20', '166'),
('289', '1', '127', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-20', '167'),
('290', '30', '5', '10', '2017-04-21 01:35:40', NULL, '2', '2017-03-10', '0'),
('291', '13', '5', '10', '2017-04-21 01:35:40', NULL, '2', '2017-03-10', '0'),
('292', '10', '8', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-10', '393'),
('293', '30', '6', '10', '2017-04-21 01:37:11', NULL, '2', '2016-06-30', '0'),
('294', '13', '6', '10', '2017-04-21 01:37:11', NULL, '2', '2016-06-30', '0'),
('295', '10', '9', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-30', '56'),
('296', '12', '1', '10', '2017-10-19 04:05:08', NULL, '2', '2016-10-11', NULL),
('297', '12', '2', '10', '2017-10-19 04:05:17', NULL, '2', '2017-01-17', NULL),
('298', '30', '7', '10', '2017-04-21 01:43:37', NULL, '2', '2016-06-09', '0'),
('299', '13', '7', '10', '2017-04-21 01:43:37', NULL, '2', '2016-06-09', '0'),
('300', '10', '10', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-09', '38'),
('301', '30', '8', '10', '2017-04-21 01:49:06', NULL, '2', '2017-03-13', '0'),
('302', '13', '8', '10', '2017-04-21 01:49:06', NULL, '2', '2017-03-13', '0'),
('303', '10', '11', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-13', '395'),
('304', '30', '9', '10', '2017-04-21 01:52:25', NULL, '2', '2016-06-27', '0'),
('305', '13', '9', '10', '2017-04-21 01:52:25', NULL, '2', '2016-06-27', '0'),
('306', '10', '12', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-27', '51'),
('307', '30', '10', '10', '2017-04-21 01:54:29', NULL, '2', '2016-09-23', '0'),
('308', '13', '10', '10', '2017-04-21 01:54:29', NULL, '2', '2016-09-23', '0'),
('309', '10', '13', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-23', '126'),
('310', '30', '11', '10', '2017-04-21 01:55:59', NULL, '2', '2016-12-14', '0'),
('311', '13', '11', '10', '2017-04-21 01:55:59', NULL, '2', '2016-12-14', '0'),
('312', '10', '14', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-14', '188'),
('313', '30', '12', '10', '2017-04-21 01:59:42', NULL, '2', '2017-03-06', '0'),
('314', '13', '12', '10', '2017-04-21 01:59:42', NULL, '2', '2017-03-06', '0'),
('315', '10', '15', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-06', '378'),
('316', '12', '3', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '475'),
('317', '30', '13', '10', '2017-04-21 02:07:59', NULL, '2', '2017-02-13', '0'),
('318', '13', '13', '10', '2017-04-21 02:07:59', NULL, '2', '2017-02-13', '0'),
('319', '10', '16', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-13', '318'),
('320', '30', '14', '10', '2017-04-21 02:09:52', NULL, '1', '2016-03-31', '0'),
('321', '13', '14', '10', '2017-04-21 02:09:52', NULL, '1', '2016-03-31', '0'),
('322', '10', '17', '10', '2018-02-05 04:47:11', NULL, '1', '2016-03-31', '75'),
('323', '12', '4', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-09', '315'),
('324', '30', '15', '10', '2017-04-21 02:13:22', NULL, '2', '2017-03-10', '0'),
('325', '13', '15', '10', '2017-04-21 02:13:22', NULL, '2', '2017-03-10', '0'),
('326', '10', '18', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-10', '394'),
('327', '30', '16', '10', '2017-04-21 02:14:42', NULL, '2', '2016-06-06', '0'),
('328', '13', '16', '10', '2017-04-21 02:14:42', NULL, '2', '2016-06-06', '0'),
('329', '10', '19', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-06', '31'),
('330', '30', '17', '10', '2017-04-21 02:16:33', NULL, '2', '2016-06-05', '0'),
('331', '13', '17', '10', '2017-04-21 02:16:33', NULL, '2', '2016-06-05', '0'),
('332', '10', '20', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-05', '29'),
('333', '12', '5', '10', '2017-10-19 01:20:22', NULL, '2', '2017-01-03', NULL),
('334', '30', '18', '10', '2017-04-21 02:23:45', NULL, '2', '2017-02-28', '0'),
('335', '13', '18', '10', '2017-04-21 02:23:45', NULL, '2', '2017-02-28', '0'),
('336', '10', '21', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '353'),
('337', '30', '19', '10', '2017-04-21 02:26:20', NULL, '1', '2016-03-31', '0'),
('338', '13', '19', '10', '2017-04-21 02:26:21', NULL, '1', '2016-03-31', '0'),
('339', '10', '22', '10', '2018-02-05 04:47:11', NULL, '1', '2016-03-31', '76'),
('340', '12', '6', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-30', '289'),
('341', '30', '20', '10', '2017-04-21 02:39:34', NULL, '1', '2016-02-17', '0'),
('342', '13', '20', '10', '2017-04-21 02:39:34', NULL, '1', '2016-02-17', '0'),
('343', '10', '23', '10', '2018-02-05 04:47:11', NULL, '1', '2016-02-17', '61'),
('344', '11', '1', '10', '2018-02-05 04:47:11', NULL, '1', '2015-11-25', '51'),
('345', '12', '7', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-09', '385'),
('346', '30', '21', '10', '2017-04-21 02:52:14', NULL, '2', '2016-07-29', '0'),
('347', '13', '21', '10', '2017-04-21 02:52:14', NULL, '2', '2016-07-29', '0'),
('348', '10', '24', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-29', '77'),
('349', '30', '22', '10', '2017-04-21 02:53:09', NULL, '2', '2016-09-26', '0'),
('350', '13', '22', '10', '2017-04-21 02:53:09', NULL, '2', '2016-09-26', '0'),
('351', '10', '25', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-26', '131'),
('352', '1', '128', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-21', '174'),
('353', '1', '129', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-21', '175'),
('354', '30', '23', '10', '2017-04-21 04:14:50', NULL, '2', '2017-03-03', '0'),
('355', '13', '23', '10', '2017-04-21 04:14:50', NULL, '2', '2017-03-03', '0'),
('356', '10', '26', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-03', '373'),
('357', '30', '24', '10', '2017-04-21 04:21:56', NULL, '2', '2016-05-20', '0'),
('358', '13', '24', '10', '2017-04-21 04:21:56', NULL, '2', '2016-05-20', '0'),
('359', '10', '27', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-20', '17'),
('360', '30', '25', '10', '2017-04-21 04:23:43', NULL, '2', '2017-01-23', '0'),
('361', '13', '25', '10', '2017-04-21 04:23:43', NULL, '2', '2017-01-23', '0'),
('362', '10', '28', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-23', '269'),
('363', '30', '26', '10', '2017-04-21 04:24:58', NULL, '2', '2017-02-15', '0'),
('364', '13', '26', '10', '2017-04-21 04:24:58', NULL, '2', '2017-02-15', '0'),
('365', '10', '29', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-15', '332'),
('366', '30', '27', '10', '2017-04-21 04:26:22', NULL, '2', '2016-08-05', '0'),
('367', '13', '27', '10', '2017-04-21 04:26:22', NULL, '2', '2016-08-05', '0'),
('368', '10', '30', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-05', '89'),
('369', '30', '28', '10', '2017-04-21 04:27:26', NULL, '2', '2017-03-24', '0'),
('370', '13', '28', '10', '2017-04-21 04:27:26', NULL, '2', '2017-03-24', '0'),
('371', '10', '31', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-24', '429'),
('372', '30', '29', '10', '2017-04-21 04:28:03', NULL, '2', '2017-03-29', '0'),
('373', '13', '29', '10', '2017-04-21 04:28:03', NULL, '2', '2017-03-29', '0'),
('374', '10', '32', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-29', '443'),
('375', '30', '30', '10', '2017-04-21 04:30:45', NULL, '2', '2017-01-26', '0'),
('376', '13', '30', '10', '2017-04-21 04:30:45', NULL, '2', '2017-01-26', '0'),
('377', '10', '33', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-26', '279'),
('378', '30', '31', '10', '2017-04-21 04:31:55', NULL, '2', '2016-12-22', '0'),
('379', '13', '31', '10', '2017-04-21 04:31:55', NULL, '2', '2016-12-22', '0'),
('380', '10', '34', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-22', '207'),
('381', '30', '32', '10', '2017-04-21 04:34:11', NULL, '2', '2017-01-31', '0'),
('382', '13', '32', '10', '2017-04-21 04:34:11', NULL, '2', '2017-01-31', '0'),
('383', '10', '35', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-31', '294'),
('384', '30', '33', '10', '2017-04-21 04:36:33', NULL, '2', '2016-05-24', '0'),
('385', '13', '33', '10', '2017-04-21 04:36:33', NULL, '2', '2016-05-24', '0'),
('386', '10', '36', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-24', '22'),
('387', '30', '34', '10', '2017-04-21 04:37:34', NULL, '2', '2016-06-20', '0'),
('388', '13', '34', '10', '2017-04-21 04:37:34', NULL, '2', '2016-06-20', '0'),
('389', '10', '37', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-20', '43'),
('390', '30', '35', '10', '2017-04-21 04:44:19', NULL, '2', '2016-09-26', '0'),
('391', '13', '35', '10', '2017-04-21 04:44:19', NULL, '2', '2016-09-26', '0'),
('392', '10', '38', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-26', '132'),
('393', '4', '4', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-21', '176'),
('394', '1', '130', '10', '2018-03-07 00:07:08', NULL, '3', '2017-04-21', NULL),
('395', '1', '131', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-19', '156'),
('396', '1', '132', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-18', '146'),
('397', '1', '133', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-17', '141'),
('398', '1', '134', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-17', '142'),
('399', '1', '135', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-12', '134'),
('400', '1', '136', '10', '2018-03-07 00:06:12', NULL, '3', '2017-04-12', NULL),
('401', '1', '137', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '83'),
('402', '1', '138', '10', '2017-04-21 05:46:09', NULL, '3', '2017-04-07', NULL),
('403', '1', '139', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-21', '177'),
('404', '1', '138', '10', '2017-04-21 05:46:09', 'Voided.\nDocument reentered.', '3', '2017-04-21', '0'),
('405', '1', '140', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-21', '178'),
('406', '1', '141', '10', '2017-04-21 06:00:16', NULL, '3', '2017-04-21', NULL),
('407', '1', '142', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-18', '147'),
('408', '1', '141', '10', '2017-04-21 06:00:16', 'Voided.\nDocument reentered.', '3', '2017-04-21', '0'),
('409', '1', '143', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-18', '148'),
('410', '1', '144', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '476'),
('411', '12', '8', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '388'),
('412', '1', '145', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-24', '189'),
('413', '30', '36', '10', '2017-04-24 05:20:20', NULL, '2', '2016-09-30', '0'),
('414', '13', '36', '10', '2017-04-24 05:20:20', NULL, '2', '2016-09-30', '0'),
('415', '10', '39', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-30', '136'),
('416', '30', '37', '10', '2017-04-24 05:21:56', NULL, '2', '2016-06-23', '0'),
('417', '13', '37', '10', '2017-04-24 05:21:56', NULL, '2', '2016-06-23', '0'),
('418', '10', '40', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-23', '46'),
('419', '30', '38', '10', '2017-04-24 05:23:41', NULL, '2', '2016-06-23', '0'),
('420', '13', '38', '10', '2017-04-24 05:23:41', NULL, '2', '2016-06-23', '0'),
('421', '10', '41', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-23', '47'),
('422', '30', '39', '10', '2017-04-24 05:26:44', NULL, '1', '2016-03-31', '0'),
('423', '13', '39', '10', '2017-04-24 05:26:44', NULL, '1', '2016-03-31', '0'),
('424', '10', '42', '10', '2018-02-05 04:47:11', NULL, '1', '2016-03-31', '77'),
('425', '12', '9', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '477'),
('426', '30', '40', '10', '2017-04-24 05:32:10', NULL, '2', '2016-11-07', '0'),
('427', '13', '40', '10', '2017-04-24 05:32:10', NULL, '2', '2016-11-07', '0'),
('428', '10', '43', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-07', '169'),
('429', '30', '41', '10', '2017-04-24 05:35:13', NULL, '1', '2016-03-03', '0'),
('430', '13', '41', '10', '2017-04-24 05:35:13', NULL, '1', '2016-03-03', '0'),
('431', '10', '44', '10', '2018-02-05 04:47:11', NULL, '1', '2016-03-03', '69'),
('432', '30', '42', '10', '2017-04-24 05:36:11', NULL, '2', '2017-03-27', '0'),
('433', '13', '42', '10', '2017-04-24 05:36:11', NULL, '2', '2017-03-27', '0'),
('434', '10', '45', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-27', '434'),
('435', '30', '43', '10', '2017-04-24 05:38:16', NULL, '2', '2016-05-06', '0'),
('436', '13', '43', '10', '2017-04-24 05:38:16', NULL, '2', '2016-05-06', '0'),
('437', '10', '46', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-06', '10'),
('438', '30', '44', '10', '2017-04-24 05:39:45', NULL, '2', '2016-07-05', '0'),
('439', '13', '44', '10', '2017-04-24 05:39:45', NULL, '2', '2016-07-05', '0'),
('440', '10', '47', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-05', '60'),
('441', '30', '45', '10', '2017-04-24 05:42:39', NULL, '2', '2016-06-07', '0'),
('442', '13', '45', '10', '2017-04-24 05:42:39', NULL, '2', '2016-06-07', '0'),
('443', '10', '48', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-07', '34'),
('444', '30', '46', '10', '2017-04-24 05:43:36', NULL, '2', '2017-02-22', '0'),
('445', '13', '46', '10', '2017-04-24 05:43:36', NULL, '2', '2017-02-22', '0'),
('446', '10', '49', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-22', '342'),
('447', '12', '10', '10', '2017-10-16 06:35:46', NULL, '2', '2017-03-15', NULL),
('448', '30', '47', '10', '2017-04-24 05:45:53', NULL, '2', '2017-02-28', '0'),
('449', '13', '47', '10', '2017-04-24 05:45:53', NULL, '2', '2017-02-28', '0'),
('450', '10', '50', '10', '2017-11-24 00:42:42', NULL, '2', '2017-02-28', NULL),
('451', '30', '48', '10', '2017-04-24 05:47:14', NULL, '2', '2016-10-18', '0'),
('452', '13', '48', '10', '2017-04-24 05:47:14', NULL, '2', '2016-10-18', '0'),
('453', '10', '51', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-18', '151'),
('454', '30', '49', '10', '2017-04-24 05:48:35', NULL, '2', '2017-03-03', '0'),
('455', '13', '49', '10', '2017-04-24 05:48:35', NULL, '2', '2017-03-03', '0'),
('456', '10', '52', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-03', '374'),
('457', '30', '50', '10', '2017-04-24 05:50:55', NULL, '2', '2016-08-10', '0'),
('458', '13', '50', '10', '2017-04-24 05:50:55', NULL, '2', '2016-08-10', '0'),
('459', '10', '53', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-10', '93'),
('460', '30', '51', '10', '2017-04-24 05:52:58', NULL, '2', '2016-08-19', '0'),
('461', '13', '51', '10', '2017-04-24 05:52:58', NULL, '2', '2016-08-19', '0'),
('462', '10', '54', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-19', '99'),
('463', '12', '11', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-24', '190'),
('464', '30', '52', '10', '2017-04-24 05:54:46', NULL, '2', '2016-11-30', '0'),
('465', '13', '52', '10', '2017-04-24 05:54:46', NULL, '2', '2016-11-30', '0'),
('466', '10', '55', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-30', '182'),
('467', '30', '53', '10', '2017-04-24 05:55:56', NULL, '2', '2017-02-28', '0'),
('468', '13', '53', '10', '2017-04-24 05:55:56', NULL, '2', '2017-02-28', '0'),
('469', '10', '56', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '354'),
('470', '1', '146', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-24', '191'),
('471', '30', '54', '10', '2017-04-24 06:14:35', NULL, '2', '2016-11-16', '0'),
('472', '13', '54', '10', '2017-04-24 06:14:35', NULL, '2', '2016-11-16', '0'),
('473', '10', '57', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-16', '172'),
('474', '12', '12', '10', '2017-10-19 04:50:52', NULL, '2', '2017-03-09', NULL),
('475', '30', '55', '10', '2017-04-24 06:18:04', NULL, '1', '2016-03-31', '0'),
('476', '13', '55', '10', '2017-04-24 06:18:04', NULL, '1', '2016-03-31', '0'),
('477', '10', '58', '10', '2018-02-05 04:47:11', NULL, '1', '2016-03-31', '78'),
('478', '12', '13', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-03', '231'),
('479', '30', '56', '10', '2017-04-24 23:13:29', NULL, '2', '2016-08-31', '0'),
('480', '13', '56', '10', '2017-04-24 23:13:29', NULL, '2', '2016-08-31', '0'),
('481', '10', '59', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-31', '107'),
('482', '30', '57', '10', '2017-04-24 23:16:25', NULL, '2', '2016-07-05', '0'),
('483', '13', '57', '10', '2017-04-24 23:16:25', NULL, '2', '2016-07-05', '0'),
('484', '10', '60', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-05', '61'),
('485', '30', '58', '10', '2017-04-24 23:17:54', NULL, '2', '2016-09-15', '0'),
('486', '13', '58', '10', '2017-04-24 23:17:54', NULL, '2', '2016-09-15', '0'),
('487', '10', '61', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-15', '118'),
('488', '30', '59', '10', '2017-04-24 23:20:06', NULL, '2', '2016-08-18', '0'),
('489', '13', '59', '10', '2017-04-24 23:20:06', NULL, '2', '2016-08-18', '0'),
('490', '10', '62', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-18', '96'),
('491', '30', '60', '10', '2017-04-24 23:26:32', NULL, '2', '2017-01-05', '0'),
('492', '13', '60', '10', '2017-04-24 23:26:32', NULL, '2', '2017-01-05', '0'),
('493', '10', '63', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-05', '250'),
('494', '12', '14', '10', '2017-10-24 04:10:43', NULL, '2', '2016-12-29', NULL),
('495', '30', '61', '10', '2017-04-24 23:50:17', NULL, '2', '2016-06-06', '0'),
('496', '13', '61', '10', '2017-04-24 23:50:17', NULL, '2', '2016-06-06', '0'),
('497', '10', '64', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-06', '32'),
('498', '30', '62', '10', '2017-04-24 23:55:14', NULL, '2', '2016-07-26', '0'),
('499', '13', '62', '10', '2017-04-24 23:55:14', NULL, '2', '2016-07-26', '0'),
('500', '10', '65', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-26', '72'),
('501', '30', '63', '10', '2017-04-24 23:56:23', NULL, '2', '2016-06-03', '0'),
('502', '13', '63', '10', '2017-04-24 23:56:23', NULL, '2', '2016-06-03', '0'),
('503', '10', '66', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-03', '28'),
('504', '30', '64', '10', '2017-04-25 00:00:56', NULL, '2', '2016-08-02', '0'),
('505', '13', '64', '10', '2017-04-25 00:00:56', NULL, '2', '2016-08-02', '0'),
('506', '10', '67', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-02', '84'),
('507', '30', '65', '10', '2017-04-25 00:23:02', NULL, '2', '2016-09-23', '0'),
('508', '13', '65', '10', '2017-04-25 00:23:02', NULL, '2', '2016-09-23', '0'),
('509', '10', '68', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-23', '127'),
('510', '30', '66', '10', '2017-04-25 00:24:41', NULL, '2', '2017-03-17', '0'),
('511', '13', '66', '10', '2017-04-25 00:24:41', NULL, '2', '2017-03-17', '0'),
('512', '10', '69', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-17', '412'),
('513', '30', '67', '10', '2017-04-25 00:28:53', NULL, '2', '2016-06-23', '0'),
('514', '13', '67', '10', '2017-04-25 00:28:53', NULL, '2', '2016-06-23', '0'),
('515', '10', '70', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-23', '48'),
('516', '30', '68', '10', '2017-04-25 00:29:39', NULL, '2', '2016-09-28', '0'),
('517', '13', '68', '10', '2017-04-25 00:29:39', NULL, '2', '2016-09-28', '0'),
('518', '10', '71', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-28', '133'),
('519', '30', '69', '10', '2017-04-25 00:34:16', NULL, '2', '2017-03-23', '0'),
('520', '13', '69', '10', '2017-04-25 00:34:16', NULL, '2', '2017-03-23', '0'),
('521', '10', '72', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-23', '423'),
('522', '30', '70', '10', '2017-04-25 00:49:14', NULL, '2', '2016-04-26', '0'),
('523', '13', '70', '10', '2017-04-25 00:49:14', NULL, '2', '2016-04-26', '0'),
('524', '10', '73', '10', '2019-11-05 05:45:21', NULL, '2', '2016-04-26', '8'),
('525', '30', '71', '10', '2017-04-25 00:50:05', NULL, '2', '2016-12-14', '0'),
('526', '13', '71', '10', '2017-04-25 00:50:06', NULL, '2', '2016-12-14', '0'),
('527', '10', '74', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-14', '189'),
('528', '30', '72', '10', '2017-04-25 00:50:56', NULL, '2', '2017-02-28', '0'),
('529', '13', '72', '10', '2017-10-24 04:03:51', NULL, '3', '2017-02-28', NULL),
('530', '10', '75', '10', '2017-10-24 04:03:51', NULL, '3', '2017-02-28', NULL),
('531', '30', '73', '10', '2017-04-25 00:53:52', NULL, '2', '2017-01-23', '0'),
('532', '13', '73', '10', '2017-04-25 00:53:52', NULL, '2', '2017-01-23', '0'),
('533', '10', '76', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-23', '270'),
('534', '30', '74', '10', '2017-04-25 00:55:16', NULL, '2', '2017-01-25', '0'),
('535', '13', '74', '10', '2017-04-25 00:55:16', NULL, '2', '2017-01-25', '0'),
('536', '10', '77', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-25', '277'),
('537', '30', '75', '10', '2017-04-25 00:56:42', NULL, '2', '2017-03-13', '0'),
('538', '13', '75', '10', '2017-04-25 00:56:42', NULL, '2', '2017-03-13', '0'),
('539', '10', '78', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-13', '396'),
('540', '30', '76', '10', '2017-04-25 00:57:45', NULL, '2', '2017-02-13', '0'),
('541', '13', '76', '10', '2017-04-25 00:57:45', NULL, '2', '2017-02-13', '0'),
('542', '10', '79', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-13', '319'),
('543', '30', '77', '10', '2017-04-25 00:58:38', NULL, '2', '2017-03-23', '0'),
('544', '13', '77', '10', '2017-04-25 00:58:38', NULL, '2', '2017-03-23', '0'),
('545', '10', '80', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-23', '424'),
('546', '30', '78', '10', '2017-04-25 01:01:06', NULL, '2', '2017-03-31', '0'),
('547', '13', '78', '10', '2017-04-25 01:01:06', NULL, '2', '2017-03-31', '0'),
('548', '10', '81', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '478'),
('549', '30', '79', '10', '2017-04-25 01:03:33', NULL, '2', '2017-03-31', '0'),
('550', '13', '79', '10', '2017-04-25 01:03:33', NULL, '2', '2017-03-31', '0'),
('551', '10', '82', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '479'),
('552', '30', '80', '10', '2017-04-25 01:04:33', NULL, '2', '2017-03-31', '0'),
('553', '13', '80', '10', '2017-04-25 01:04:33', NULL, '2', '2017-03-31', '0'),
('554', '10', '83', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '480'),
('555', '30', '81', '10', '2017-04-25 01:08:17', NULL, '1', '2016-03-23', '0'),
('556', '13', '81', '10', '2017-04-25 01:08:17', NULL, '1', '2016-03-23', '0'),
('557', '10', '84', '10', '2018-02-05 04:47:11', NULL, '1', '2016-03-23', '74'),
('558', '30', '82', '10', '2017-04-25 01:09:21', NULL, '2', '2017-02-28', '0'),
('559', '13', '82', '10', '2017-04-25 01:09:21', NULL, '2', '2017-02-28', '0'),
('560', '10', '85', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '355'),
('561', '12', '15', '10', '2017-10-19 04:29:40', NULL, '2', '2016-08-15', NULL),
('562', '12', '16', '10', '2017-10-19 04:29:48', NULL, '2', '2017-01-03', NULL),
('563', '12', '17', '10', '2017-04-25 01:14:22', NULL, '3', '2017-04-06', NULL),
('564', '12', '17', '10', '2017-04-25 01:14:22', 'Voided.\n', '3', '2017-04-25', '0'),
('565', '30', '83', '10', '2017-04-25 01:18:55', NULL, '2', '2017-01-25', '0'),
('566', '13', '83', '10', '2017-04-25 01:18:55', NULL, '2', '2017-01-25', '0'),
('567', '10', '86', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-25', '278'),
('568', '30', '84', '10', '2017-04-25 01:21:03', NULL, '2', '2017-03-14', '0'),
('569', '13', '84', '10', '2017-04-25 01:21:03', NULL, '2', '2017-03-14', '0'),
('570', '10', '87', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-14', '399'),
('571', '30', '85', '10', '2017-04-25 01:21:51', NULL, '2', '2017-03-29', '0'),
('572', '13', '85', '10', '2017-04-25 01:21:51', NULL, '2', '2017-03-29', '0'),
('573', '10', '88', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-29', '444'),
('574', '30', '86', '10', '2017-04-25 01:25:21', NULL, '2', '2017-02-06', '0'),
('575', '13', '86', '10', '2017-04-25 01:25:21', NULL, '2', '2017-02-06', '0'),
('576', '10', '89', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-06', '310'),
('577', '30', '87', '10', '2017-04-25 01:28:26', NULL, '2', '2017-02-20', '0'),
('578', '13', '87', '10', '2017-04-25 01:28:26', NULL, '2', '2017-02-20', '0'),
('579', '10', '90', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-20', '337'),
('580', '12', '18', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '226'),
('581', '30', '88', '10', '2017-04-25 01:31:25', NULL, '2', '2017-01-23', '0'),
('582', '13', '88', '10', '2017-04-25 01:31:25', NULL, '2', '2017-01-23', '0'),
('583', '10', '91', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-23', '271'),
('584', '30', '89', '10', '2017-04-25 01:32:07', NULL, '2', '2017-02-27', '0'),
('585', '13', '89', '10', '2017-04-25 01:32:07', NULL, '2', '2017-02-27', '0'),
('586', '10', '92', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-27', '351'),
('587', '30', '90', '10', '2017-04-25 01:33:44', NULL, '2', '2017-03-27', '0'),
('588', '13', '90', '10', '2017-04-25 01:33:44', NULL, '2', '2017-03-27', '0'),
('589', '10', '93', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-27', '435'),
('590', '12', '19', '10', '2017-10-19 01:27:34', NULL, '2', '2017-03-15', NULL),
('591', '30', '91', '10', '2017-04-25 01:36:44', NULL, '2', '2016-07-05', '0'),
('592', '13', '91', '10', '2017-04-25 01:36:44', NULL, '2', '2016-07-05', '0'),
('593', '10', '94', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-05', '62'),
('594', '30', '92', '10', '2017-04-25 01:38:01', NULL, '2', '2017-03-16', '0'),
('595', '13', '92', '10', '2017-04-25 01:38:01', NULL, '2', '2017-03-16', '0'),
('596', '10', '95', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-16', '408'),
('597', '1', '147', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-25', '203'),
('598', '30', '93', '10', '2017-04-25 01:59:02', NULL, '1', '2015-09-07', '0'),
('599', '13', '93', '10', '2017-04-25 01:59:02', NULL, '1', '2015-09-07', '0'),
('600', '10', '96', '10', '2018-02-05 04:47:11', NULL, '1', '2015-09-07', '45'),
('601', '30', '94', '10', '2017-04-25 02:00:20', NULL, '2', '2016-12-30', '0'),
('602', '13', '94', '10', '2017-04-25 02:00:20', NULL, '2', '2016-12-30', '0'),
('603', '10', '97', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-30', '220'),
('604', '30', '95', '10', '2017-04-25 02:03:08', NULL, '2', '2016-11-24', '0'),
('605', '13', '95', '10', '2017-04-25 02:03:08', NULL, '2', '2016-11-24', '0'),
('606', '10', '98', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-24', '176'),
('607', '30', '96', '10', '2017-04-25 02:05:14', NULL, '2', '2017-01-30', '0'),
('608', '13', '96', '10', '2018-01-25 05:09:49', NULL, '3', '2017-01-30', NULL),
('609', '10', '99', '10', '2018-01-25 05:09:49', NULL, '3', '2017-01-30', NULL),
('610', '30', '97', '10', '2017-04-25 02:07:58', NULL, '2', '2017-03-31', '0'),
('611', '13', '97', '10', '2017-04-25 02:07:58', NULL, '2', '2017-03-31', '0'),
('612', '10', '100', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '481'),
('613', '30', '98', '10', '2017-04-25 02:21:52', NULL, '2', '2017-03-31', '0'),
('614', '13', '98', '10', '2017-04-25 02:21:52', NULL, '2', '2017-03-31', '0'),
('615', '10', '101', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '482'),
('616', '30', '99', '10', '2017-04-25 02:29:12', NULL, '2', '2016-09-15', '0'),
('617', '13', '99', '10', '2017-04-25 02:29:12', NULL, '2', '2016-09-15', '0'),
('618', '10', '102', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-15', '119'),
('619', '30', '100', '10', '2017-04-25 02:32:35', NULL, '2', '2017-01-18', '0'),
('620', '13', '100', '10', '2017-04-25 02:32:35', NULL, '2', '2017-01-18', '0'),
('621', '10', '103', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-18', '262'),
('622', '30', '101', '10', '2017-04-25 02:34:01', NULL, '2', '2017-02-28', '0'),
('623', '13', '101', '10', '2017-04-25 02:34:01', NULL, '2', '2017-02-28', '0'),
('624', '10', '104', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '356'),
('625', '12', '20', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-09', '386'),
('626', '30', '102', '10', '2017-04-25 02:35:58', NULL, '2', '2016-10-20', '0'),
('627', '13', '102', '10', '2017-04-25 02:35:58', NULL, '2', '2016-10-20', '0'),
('628', '10', '105', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-20', '155'),
('629', '30', '103', '10', '2017-04-25 02:37:23', NULL, '2', '2017-01-23', '0'),
('630', '13', '103', '10', '2017-04-25 02:37:23', NULL, '2', '2017-01-23', '0'),
('631', '10', '106', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-23', '272'),
('632', '30', '104', '10', '2017-04-25 02:38:34', NULL, '2', '2016-05-06', '0'),
('633', '13', '104', '10', '2017-04-25 02:38:34', NULL, '2', '2016-05-06', '0'),
('634', '10', '107', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-06', '11'),
('635', '12', '21', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-29', '212'),
('636', '30', '105', '10', '2017-04-25 02:42:04', NULL, '1', '2016-02-03', '0'),
('637', '13', '105', '10', '2017-04-25 02:42:04', NULL, '1', '2016-02-03', '0'),
('638', '10', '108', '10', '2018-02-05 04:47:11', NULL, '1', '2016-02-03', '58'),
('639', '12', '22', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-13', '320'),
('640', '30', '106', '10', '2017-04-25 02:46:34', NULL, '2', '2017-01-26', '0'),
('641', '13', '106', '10', '2017-04-25 02:46:34', NULL, '2', '2017-01-26', '0'),
('642', '10', '109', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-26', '280'),
('643', '30', '107', '10', '2017-04-25 02:48:33', NULL, '2', '2016-08-26', '0'),
('644', '13', '107', '10', '2017-04-25 02:48:33', NULL, '2', '2016-08-26', '0'),
('645', '10', '110', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-26', '102'),
('646', '30', '108', '10', '2017-04-25 02:50:30', NULL, '2', '2017-02-13', '0'),
('647', '13', '108', '10', '2017-04-25 02:50:30', NULL, '2', '2017-02-13', '0'),
('648', '10', '111', '10', '2017-10-19 05:19:08', NULL, '2', '2017-02-13', NULL),
('649', '30', '109', '10', '2017-04-25 02:52:09', NULL, '2', '2017-03-23', '0'),
('650', '13', '109', '10', '2017-04-25 02:52:09', NULL, '2', '2017-03-23', '0'),
('651', '10', '112', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-23', '425'),
('652', '30', '110', '10', '2017-04-25 02:54:22', NULL, '1', '2016-01-25', '0');
INSERT INTO `0_audit_trail` VALUES
('653', '13', '110', '10', '2017-04-25 02:54:22', NULL, '1', '2016-01-25', '0'),
('654', '10', '113', '10', '2018-02-05 04:47:11', NULL, '1', '2016-01-25', '55'),
('655', '30', '111', '10', '2017-04-25 03:33:30', NULL, '2', '2016-09-02', '0'),
('656', '13', '111', '10', '2017-04-25 03:33:30', NULL, '2', '2016-09-02', '0'),
('657', '10', '114', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-02', '109'),
('658', '12', '23', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-05', '112'),
('659', '30', '112', '10', '2017-04-25 03:37:43', NULL, '2', '2016-06-05', '0'),
('660', '13', '112', '10', '2017-04-25 03:37:43', NULL, '2', '2016-06-05', '0'),
('661', '10', '115', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-05', '30'),
('662', '30', '113', '10', '2017-04-25 03:38:32', NULL, '2', '2016-08-26', '0'),
('663', '13', '113', '10', '2017-04-25 03:38:32', NULL, '2', '2016-08-26', '0'),
('664', '10', '116', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-26', '103'),
('665', '30', '114', '10', '2017-04-25 03:39:27', NULL, '2', '2016-12-20', '0'),
('666', '13', '114', '10', '2017-04-25 03:39:27', NULL, '2', '2016-12-20', '0'),
('667', '10', '117', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-20', '200'),
('668', '30', '115', '10', '2017-04-25 03:41:46', NULL, '2', '2016-10-04', '0'),
('669', '13', '115', '10', '2017-09-18 05:43:32', NULL, '3', '2016-10-04', NULL),
('670', '10', '118', '10', '2017-09-18 05:43:32', NULL, '3', '2016-10-04', NULL),
('671', '30', '116', '10', '2017-04-25 03:51:54', NULL, '2', '2016-07-20', '0'),
('672', '13', '116', '10', '2017-04-25 03:51:54', NULL, '2', '2016-07-20', '0'),
('673', '10', '119', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-20', '69'),
('674', '30', '117', '10', '2017-04-25 03:54:23', NULL, '2', '2016-06-30', '0'),
('675', '13', '117', '10', '2017-04-25 03:54:23', NULL, '2', '2016-06-30', '0'),
('676', '10', '120', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-30', '57'),
('677', '12', '24', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-28', '181'),
('678', '11', '2', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '123'),
('679', '30', '118', '10', '2017-04-25 03:58:56', NULL, '2', '2017-03-20', '0'),
('680', '13', '118', '10', '2017-04-25 03:58:56', NULL, '2', '2017-03-20', '0'),
('681', '10', '121', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-20', '416'),
('682', '12', '25', '10', '2017-07-06 03:23:43', NULL, '2', '2017-03-31', NULL),
('683', '30', '119', '10', '2017-04-25 04:04:18', NULL, '2', '2016-08-24', '0'),
('684', '13', '119', '10', '2017-04-25 04:04:18', NULL, '2', '2016-08-24', '0'),
('685', '10', '122', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-24', '101'),
('686', '12', '26', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-02', '110'),
('687', '30', '120', '10', '2017-04-25 04:08:04', NULL, '2', '2016-09-23', '0'),
('688', '13', '120', '10', '2017-04-25 04:08:04', NULL, '2', '2016-09-23', '0'),
('689', '10', '123', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-23', '128'),
('690', '30', '121', '10', '2017-04-25 04:09:15', NULL, '2', '2016-06-29', '0'),
('691', '13', '121', '10', '2017-04-25 04:09:15', NULL, '2', '2016-06-29', '0'),
('692', '10', '124', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-29', '53'),
('693', '30', '122', '10', '2017-04-25 04:10:38', NULL, '2', '2016-12-20', '0'),
('694', '13', '122', '10', '2017-04-25 04:10:38', NULL, '2', '2016-12-20', '0'),
('695', '10', '125', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-20', '201'),
('696', '30', '123', '10', '2017-04-25 04:18:07', NULL, '1', '2016-03-31', '0'),
('697', '13', '123', '10', '2017-04-25 04:18:07', NULL, '1', '2016-03-31', '0'),
('698', '10', '126', '10', '2018-02-05 04:47:11', NULL, '1', '2016-03-31', '79'),
('699', '30', '124', '10', '2017-04-25 04:20:07', NULL, '2', '2016-11-27', '0'),
('700', '13', '124', '10', '2017-04-25 04:20:07', NULL, '2', '2016-11-27', '0'),
('701', '10', '127', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-27', '180'),
('702', '30', '125', '10', '2017-04-25 04:45:06', NULL, '2', '2017-03-16', '0'),
('703', '13', '125', '10', '2017-04-25 04:45:06', NULL, '2', '2017-03-16', '0'),
('704', '10', '128', '10', '2018-01-25 23:14:49', NULL, '2', '2017-03-16', NULL),
('705', '30', '126', '10', '2017-04-25 04:52:33', NULL, '2', '2016-07-05', '0'),
('706', '13', '126', '10', '2017-04-25 04:52:33', NULL, '2', '2016-07-05', '0'),
('707', '10', '129', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-05', '63'),
('708', '30', '127', '10', '2017-04-25 04:53:31', NULL, '2', '2016-12-30', '0'),
('709', '13', '127', '10', '2017-04-25 04:53:31', NULL, '2', '2016-12-30', '0'),
('710', '10', '130', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-30', '221'),
('711', '12', '27', '10', '2017-10-19 01:21:47', NULL, '2', '2017-01-03', NULL),
('712', '30', '128', '10', '2017-04-25 05:00:23', NULL, '2', '2017-02-13', '0'),
('713', '13', '128', '10', '2017-04-25 05:00:23', NULL, '2', '2017-02-13', '0'),
('714', '10', '131', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-13', '321'),
('715', '30', '129', '10', '2017-04-25 05:01:26', NULL, '2', '2017-03-28', '0'),
('716', '13', '129', '10', '2017-04-25 05:01:26', NULL, '2', '2017-03-28', '0'),
('717', '10', '132', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-28', '439'),
('718', '30', '130', '10', '2017-04-25 05:05:25', NULL, '1', '2015-11-18', '0'),
('719', '13', '130', '10', '2017-04-25 05:05:25', NULL, '1', '2015-11-18', '0'),
('720', '10', '133', '10', '2018-02-05 04:47:11', NULL, '1', '2015-11-18', '50'),
('721', '30', '131', '10', '2017-04-25 05:07:31', NULL, '2', '2017-03-13', '0'),
('722', '13', '131', '10', '2017-04-25 05:07:31', NULL, '2', '2017-03-13', '0'),
('723', '10', '134', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-13', '397'),
('724', '30', '132', '10', '2017-04-25 05:14:27', NULL, '2', '2017-02-24', '0'),
('725', '13', '132', '10', '2017-04-25 05:14:27', NULL, '2', '2017-02-24', '0'),
('726', '10', '135', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-24', '346'),
('727', '30', '133', '10', '2017-04-25 05:19:12', NULL, '2', '2016-09-28', '0'),
('728', '13', '133', '10', '2017-04-25 05:19:12', NULL, '2', '2016-09-28', '0'),
('729', '10', '136', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-28', '134'),
('730', '30', '134', '10', '2017-04-25 05:24:42', NULL, '2', '2017-03-31', '0'),
('731', '13', '134', '10', '2017-04-25 05:24:42', NULL, '2', '2017-03-31', '0'),
('732', '10', '137', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '483'),
('733', '30', '135', '10', '2017-04-25 06:06:05', NULL, '3', '2017-04-25', '0'),
('734', '13', '135', '10', '2017-04-25 06:06:05', NULL, '3', '2017-04-25', '0'),
('735', '10', '138', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-25', '204'),
('736', '12', '28', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-25', '205'),
('737', '1', '148', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-25', '206'),
('738', '30', '136', '10', '2017-04-26 01:13:28', NULL, '2', '2016-09-02', '0'),
('739', '13', '136', '10', '2017-04-26 01:13:28', NULL, '2', '2016-09-02', '0'),
('740', '10', '139', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-02', '111'),
('741', '12', '29', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-09', '387'),
('742', '30', '137', '10', '2017-04-26 01:20:11', NULL, '2', '2016-10-31', '0'),
('743', '13', '137', '10', '2017-04-26 01:20:12', NULL, '2', '2016-10-31', '0'),
('744', '10', '140', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-31', '165'),
('745', '30', '138', '10', '2017-04-26 01:22:26', NULL, '2', '2016-10-04', '0'),
('746', '13', '138', '10', '2017-04-26 01:22:26', NULL, '2', '2016-10-04', '0'),
('747', '10', '141', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-04', '141'),
('748', '30', '139', '10', '2017-04-26 01:24:49', NULL, '2', '2017-02-17', '0'),
('749', '13', '139', '10', '2017-04-26 01:24:49', NULL, '2', '2017-02-17', '0'),
('750', '10', '142', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-17', '335'),
('754', '30', '141', '10', '2017-04-26 01:28:43', NULL, '2', '2017-01-30', '0'),
('755', '13', '141', '10', '2017-04-26 01:28:43', NULL, '2', '2017-01-30', '0'),
('756', '10', '144', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-30', '290'),
('757', '30', '142', '10', '2017-04-26 01:30:38', NULL, '1', '2016-03-10', '0'),
('758', '13', '142', '10', '2017-04-26 01:30:38', NULL, '1', '2016-03-10', '0'),
('759', '10', '145', '10', '2018-02-05 04:47:11', NULL, '1', '2016-03-10', '72'),
('760', '12', '30', '10', '2017-10-19 04:27:47', NULL, '2', '2017-01-03', NULL),
('761', '30', '143', '10', '2017-04-26 01:32:37', NULL, '2', '2016-12-14', '0'),
('762', '13', '143', '10', '2017-04-26 01:32:37', NULL, '2', '2016-12-14', '0'),
('763', '10', '146', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-14', '190'),
('764', '30', '144', '10', '2017-04-26 01:57:49', NULL, '2', '2016-08-09', '0'),
('765', '13', '144', '10', '2017-04-26 01:57:49', NULL, '2', '2016-08-09', '0'),
('766', '10', '147', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-09', '90'),
('767', '30', '145', '10', '2017-04-26 02:01:18', NULL, '2', '2017-01-16', '0'),
('768', '13', '145', '10', '2017-04-26 02:01:18', NULL, '2', '2017-01-16', '0'),
('769', '10', '148', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-16', '257'),
('770', '30', '146', '10', '2017-04-26 02:02:10', NULL, '2', '2017-02-13', '0'),
('771', '13', '146', '10', '2017-04-26 02:02:10', NULL, '2', '2017-02-13', '0'),
('772', '10', '149', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-13', '322'),
('773', '30', '147', '10', '2017-04-26 02:05:04', NULL, '2', '2017-01-16', '0'),
('774', '13', '147', '10', '2017-04-26 02:05:04', NULL, '2', '2017-01-16', '0'),
('775', '10', '150', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-16', '258'),
('776', '30', '148', '10', '2017-04-26 02:08:24', NULL, '2', '2016-05-30', '0'),
('777', '13', '148', '10', '2017-04-26 02:08:24', NULL, '2', '2016-05-30', '0'),
('778', '10', '151', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-30', '26'),
('779', '30', '149', '10', '2017-04-26 02:09:14', NULL, '2', '2016-10-12', '0'),
('780', '13', '149', '10', '2017-04-26 02:09:14', NULL, '2', '2016-10-12', '0'),
('781', '10', '152', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-12', '150'),
('782', '30', '150', '10', '2017-04-26 02:12:24', NULL, '2', '2016-12-21', '0'),
('783', '13', '150', '10', '2017-04-26 02:12:24', NULL, '2', '2016-12-21', '0'),
('784', '10', '153', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-21', '205'),
('785', '12', '31', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-09', '388'),
('786', '30', '151', '10', '2017-04-26 02:41:34', NULL, '2', '2017-01-30', '0'),
('787', '13', '151', '10', '2017-04-26 02:41:34', NULL, '2', '2017-01-30', '0'),
('788', '10', '154', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-30', '291'),
('789', '30', '152', '10', '2017-04-26 02:44:01', NULL, '2', '2016-05-06', '0'),
('790', '13', '152', '10', '2017-04-26 02:44:01', NULL, '2', '2016-05-06', '0'),
('791', '10', '155', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-06', '12'),
('792', '12', '32', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-05', '143'),
('793', '30', '153', '10', '2017-04-26 02:46:49', NULL, '2', '2017-02-08', '0'),
('794', '13', '153', '10', '2017-04-26 02:46:49', NULL, '2', '2017-02-08', '0'),
('795', '10', '156', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-08', '312'),
('796', '30', '154', '10', '2017-04-26 02:51:22', NULL, '2', '2016-12-30', '0'),
('797', '13', '154', '10', '2017-04-26 02:51:22', NULL, '2', '2016-12-30', '0'),
('798', '10', '157', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-30', '222'),
('799', '30', '155', '10', '2017-04-26 02:52:19', NULL, '2', '2017-01-31', '0'),
('800', '13', '155', '10', '2017-04-26 02:52:19', NULL, '2', '2017-01-31', '0'),
('801', '10', '158', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-31', '295'),
('802', '30', '156', '10', '2017-04-26 02:53:41', NULL, '2', '2017-02-28', '0'),
('803', '13', '156', '10', '2017-04-26 02:53:41', NULL, '2', '2017-02-28', '0'),
('804', '10', '159', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '357'),
('805', '30', '157', '10', '2017-04-26 02:54:52', NULL, '2', '2017-03-30', '0'),
('806', '13', '157', '10', '2017-04-26 02:54:53', NULL, '2', '2017-03-30', '0'),
('807', '10', '160', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '458'),
('808', '12', '33', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-15', '333'),
('809', '12', '34', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-17', '413'),
('810', '12', '35', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-25', '207'),
('811', '12', '36', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-02', '294'),
('812', '12', '37', '10', '2017-10-19 01:02:34', NULL, '3', '2017-05-17', NULL),
('813', '30', '158', '10', '2017-04-26 03:01:33', NULL, '2', '2016-08-04', '0'),
('814', '13', '158', '10', '2017-04-26 03:01:33', NULL, '2', '2016-08-04', '0'),
('815', '10', '161', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-04', '88'),
('816', '30', '159', '10', '2017-04-26 03:04:00', NULL, '2', '2016-12-28', '0'),
('817', '13', '159', '10', '2017-04-26 03:04:00', NULL, '2', '2016-12-28', '0'),
('818', '10', '162', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-28', '209'),
('819', '1', '149', '10', '2017-04-26 03:07:56', NULL, '3', '2016-12-28', NULL),
('820', '1', '150', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-26', '217'),
('821', '1', '149', '10', '2017-04-26 03:07:56', 'Voided.\nDocument reentered.', '3', '2017-04-26', '0'),
('822', '1', '151', '10', '2018-03-06 23:10:12', NULL, '3', '2017-04-26', NULL),
('823', '30', '160', '10', '2017-04-26 03:59:48', NULL, '2', '2017-02-08', '0'),
('824', '13', '160', '10', '2017-04-26 03:59:48', NULL, '2', '2017-02-08', '0'),
('825', '10', '163', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-08', '313'),
('826', '30', '161', '10', '2017-04-26 04:00:29', NULL, '2', '2017-03-13', '0'),
('827', '13', '161', '10', '2017-04-26 04:00:29', NULL, '2', '2017-03-13', '0'),
('828', '10', '164', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-13', '398'),
('829', '12', '38', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-25', '208'),
('830', '30', '162', '10', '2017-04-26 04:17:21', NULL, '2', '2016-10-31', '0'),
('831', '13', '162', '10', '2017-09-12 06:00:00', NULL, '3', '2016-10-31', NULL),
('832', '10', '165', '10', '2017-09-12 06:00:00', NULL, '3', '2016-10-31', NULL),
('833', '30', '163', '10', '2017-04-26 04:20:55', NULL, '2', '2017-01-06', '0'),
('834', '13', '163', '10', '2017-04-26 04:20:55', NULL, '2', '2017-01-06', '0'),
('835', '10', '166', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-06', '251'),
('836', '30', '164', '10', '2017-04-26 04:24:48', NULL, '2', '2016-08-02', '0'),
('837', '13', '164', '10', '2017-04-26 04:24:48', NULL, '2', '2016-08-02', '0'),
('838', '10', '167', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-02', '85'),
('839', '30', '165', '10', '2017-04-26 04:25:56', NULL, '2', '2016-10-10', '0'),
('840', '13', '165', '10', '2017-04-26 04:25:56', NULL, '2', '2016-10-10', '0'),
('841', '10', '168', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-10', '147'),
('842', '11', '3', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-03', '87'),
('843', '11', '4', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-29', '213'),
('844', '12', '39', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-25', '209'),
('845', '30', '166', '10', '2017-04-26 04:36:49', NULL, '1', '2015-12-29', '0'),
('846', '13', '166', '10', '2017-04-26 04:36:49', NULL, '1', '2015-12-29', '0'),
('847', '10', '169', '10', '2018-02-05 04:47:11', NULL, '1', '2015-12-29', '52'),
('848', '11', '5', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-25', '177'),
('849', '30', '167', '10', '2017-04-26 04:39:40', NULL, '2', '2017-02-13', '0'),
('850', '13', '167', '10', '2017-04-26 04:39:40', NULL, '2', '2017-02-13', '0'),
('851', '10', '170', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-13', '323'),
('852', '30', '168', '10', '2017-04-26 04:42:06', NULL, '2', '2016-07-26', '0'),
('853', '13', '168', '10', '2017-04-26 04:42:06', NULL, '2', '2016-07-26', '0'),
('854', '10', '171', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-26', '73'),
('855', '30', '169', '10', '2017-04-26 04:43:11', NULL, '2', '2016-12-06', '0'),
('856', '13', '169', '10', '2017-04-26 04:43:11', NULL, '2', '2016-12-06', '0'),
('857', '10', '172', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-06', '185'),
('858', '30', '170', '10', '2017-04-26 04:44:17', NULL, '2', '2016-07-26', '0'),
('859', '13', '170', '10', '2017-04-26 04:44:17', NULL, '2', '2016-07-26', '0'),
('860', '10', '173', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-26', '74'),
('861', '30', '171', '10', '2017-04-26 04:45:25', NULL, '2', '2016-08-01', '0'),
('862', '13', '171', '10', '2017-04-26 04:45:25', NULL, '2', '2016-08-01', '0'),
('863', '10', '174', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-01', '80'),
('864', '30', '172', '10', '2017-04-26 04:46:15', NULL, '2', '2016-08-01', '0'),
('865', '13', '172', '10', '2017-04-26 04:46:15', NULL, '2', '2016-08-01', '0'),
('866', '10', '175', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-01', '81'),
('867', '30', '173', '10', '2017-04-26 04:46:57', NULL, '2', '2016-12-15', '0'),
('868', '13', '173', '10', '2017-04-26 04:46:57', NULL, '2', '2016-12-15', '0'),
('869', '10', '176', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-15', '191'),
('870', '30', '174', '10', '2017-04-26 04:47:36', NULL, '2', '2016-12-15', '0'),
('871', '13', '174', '10', '2017-04-26 04:47:36', NULL, '2', '2016-12-15', '0'),
('872', '10', '177', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-15', '192'),
('873', '30', '175', '10', '2017-04-26 04:48:26', NULL, '2', '2017-01-18', '0'),
('874', '13', '175', '10', '2017-04-26 04:48:26', NULL, '2', '2017-01-18', '0'),
('875', '10', '178', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-18', '263'),
('876', '30', '176', '10', '2017-04-26 04:48:51', NULL, '2', '2017-01-18', '0'),
('877', '13', '176', '10', '2017-04-26 04:48:51', NULL, '2', '2017-01-18', '0'),
('878', '10', '179', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-18', '264'),
('879', '12', '40', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-23', '344'),
('880', '30', '177', '10', '2017-04-26 04:51:12', NULL, '2', '2017-03-27', '0'),
('881', '13', '177', '10', '2017-04-26 04:51:12', NULL, '2', '2017-03-27', '0'),
('882', '10', '180', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-27', '436'),
('883', '30', '178', '10', '2017-04-26 04:52:25', NULL, '1', '2016-02-05', '0'),
('884', '13', '178', '10', '2017-04-26 04:52:25', NULL, '1', '2016-02-05', '0'),
('885', '10', '181', '10', '2018-02-05 04:47:11', NULL, '1', '2016-02-05', '59'),
('886', '30', '179', '10', '2017-04-26 04:54:15', NULL, '2', '2016-11-11', '0'),
('887', '13', '179', '10', '2017-04-26 04:54:15', NULL, '2', '2016-11-11', '0'),
('888', '10', '182', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-11', '171'),
('889', '30', '180', '10', '2017-04-26 04:55:03', NULL, '2', '2016-06-15', '0'),
('890', '13', '180', '10', '2017-04-26 04:55:03', NULL, '2', '2016-06-15', '0'),
('891', '10', '183', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-15', '40'),
('892', '30', '181', '10', '2017-04-26 04:56:00', NULL, '2', '2017-02-24', '0'),
('893', '13', '181', '10', '2017-04-26 04:56:00', NULL, '2', '2017-02-24', '0'),
('894', '10', '184', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-24', '347'),
('895', '30', '182', '10', '2017-04-26 04:57:02', NULL, '2', '2016-06-07', '0'),
('896', '13', '182', '10', '2017-04-26 04:57:02', NULL, '2', '2016-06-07', '0'),
('897', '10', '185', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-07', '35'),
('898', '30', '183', '10', '2017-04-26 04:59:10', NULL, '2', '2017-02-02', '0'),
('899', '13', '183', '10', '2017-04-26 04:59:10', NULL, '2', '2017-02-02', '0'),
('900', '10', '186', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-02', '306'),
('901', '30', '184', '10', '2017-04-26 05:38:34', NULL, '2', '2017-02-28', '0'),
('902', '13', '184', '10', '2017-04-26 05:38:34', NULL, '2', '2017-02-28', '0'),
('903', '10', '187', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '358'),
('904', '30', '185', '10', '2017-04-26 05:40:17', NULL, '2', '2017-03-29', '0'),
('905', '13', '185', '10', '2017-04-26 05:40:17', NULL, '2', '2017-03-29', '0'),
('906', '10', '188', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-29', '445'),
('907', '30', '186', '10', '2017-04-26 05:42:54', NULL, '2', '2016-10-21', '0'),
('908', '13', '186', '10', '2017-04-26 05:42:54', NULL, '2', '2016-10-21', '0'),
('909', '10', '189', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-21', '156'),
('910', '30', '187', '10', '2017-04-26 05:48:51', NULL, '2', '2016-07-28', '0'),
('911', '13', '187', '10', '2017-04-26 05:48:51', NULL, '2', '2016-07-28', '0'),
('912', '10', '190', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-28', '76'),
('913', '30', '188', '10', '2017-04-26 05:52:16', NULL, '2', '2016-04-07', '0'),
('914', '13', '188', '10', '2017-04-26 05:52:16', NULL, '2', '2016-04-07', '0'),
('915', '10', '191', '10', '2019-11-05 05:45:21', NULL, '2', '2016-04-07', '3'),
('916', '30', '189', '10', '2017-04-26 05:53:14', NULL, '2', '2017-03-30', '0'),
('917', '13', '189', '10', '2017-04-26 05:53:14', NULL, '2', '2017-03-30', '0'),
('918', '10', '192', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '459'),
('919', '30', '190', '10', '2017-04-26 05:55:10', NULL, '2', '2016-08-09', '0'),
('920', '13', '190', '10', '2017-04-26 05:55:10', NULL, '2', '2016-08-09', '0'),
('921', '10', '193', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-09', '91'),
('922', '30', '191', '10', '2017-04-26 05:56:10', NULL, '2', '2016-09-22', '0'),
('923', '13', '191', '10', '2017-04-26 05:56:10', NULL, '2', '2016-09-22', '0'),
('924', '10', '194', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-22', '125'),
('925', '30', '192', '10', '2017-04-26 05:57:23', NULL, '2', '2016-05-19', '0'),
('926', '13', '192', '10', '2017-04-26 05:57:23', NULL, '2', '2016-05-19', '0'),
('927', '10', '195', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-19', '14'),
('928', '30', '193', '10', '2017-04-26 05:58:11', NULL, '1', '2016-02-05', '0'),
('929', '13', '193', '10', '2017-04-26 05:58:11', NULL, '1', '2016-02-05', '0'),
('930', '10', '196', '10', '2018-02-05 04:47:11', NULL, '1', '2016-02-05', '60'),
('931', '12', '41', '10', '2017-04-26 06:02:49', NULL, '2', '2017-02-01', NULL),
('932', '12', '42', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-20', '202'),
('933', '12', '43', '10', '2017-10-16 06:40:36', NULL, '2', '2017-03-15', NULL),
('934', '12', '41', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-02-01', '303'),
('935', '30', '194', '10', '2017-04-26 06:04:29', NULL, '2', '2017-02-28', '0'),
('936', '13', '194', '10', '2017-04-26 06:04:29', NULL, '2', '2017-02-28', '0'),
('937', '10', '197', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '359'),
('938', '30', '195', '10', '2017-04-26 06:06:15', NULL, '1', '2016-02-17', '0'),
('939', '13', '195', '10', '2017-04-26 06:06:15', NULL, '1', '2016-02-17', '0'),
('940', '10', '198', '10', '2018-02-05 04:47:11', NULL, '1', '2016-02-17', '62'),
('941', '30', '196', '10', '2017-04-26 06:07:32', NULL, '2', '2016-09-13', '0'),
('942', '13', '196', '10', '2017-04-26 06:07:32', NULL, '2', '2016-09-13', '0'),
('943', '10', '199', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-13', '115'),
('944', '30', '197', '10', '2017-04-26 06:08:57', NULL, '2', '2017-01-09', '0'),
('945', '13', '197', '10', '2017-04-26 06:08:57', NULL, '2', '2017-01-09', '0'),
('946', '10', '200', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-09', '253'),
('947', '30', '198', '10', '2017-04-26 06:10:00', NULL, '2', '2016-12-21', '0'),
('948', '13', '198', '10', '2017-04-26 06:10:00', NULL, '2', '2016-12-21', '0'),
('949', '10', '201', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-21', '206'),
('950', '30', '199', '10', '2017-04-26 06:11:53', NULL, '2', '2017-03-31', '0'),
('951', '13', '199', '10', '2017-04-26 06:11:53', NULL, '2', '2017-03-31', '0'),
('952', '10', '202', '10', '2018-01-23 03:08:47', NULL, '2', '2017-03-31', NULL),
('953', '30', '200', '10', '2017-04-26 06:14:22', NULL, '2', '2016-08-01', '0'),
('954', '13', '200', '10', '2017-04-26 06:14:22', NULL, '2', '2016-08-01', '0'),
('955', '10', '203', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-01', '82'),
('956', '11', '6', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-29', '214'),
('957', '30', '201', '10', '2017-04-26 06:16:30', NULL, '2', '2017-01-09', '0'),
('958', '13', '201', '10', '2017-04-26 06:16:30', NULL, '2', '2017-01-09', '0'),
('959', '10', '204', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-09', '254'),
('960', '1', '152', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '227'),
('961', '1', '153', '10', '2017-04-26 23:40:47', NULL, '3', '2017-04-27', NULL),
('962', '1', '154', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '228'),
('963', '1', '153', '10', '2017-04-26 23:40:47', 'Voided.\nDocument reentered.', '3', '2017-04-26', '0'),
('964', '30', '202', '10', '2017-04-26 23:55:10', NULL, '2', '2016-07-26', '0'),
('965', '13', '202', '10', '2017-04-26 23:55:10', NULL, '2', '2016-07-26', '0'),
('966', '10', '205', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-26', '75'),
('967', '30', '203', '10', '2017-04-27 00:04:44', NULL, '2', '2016-12-15', '0'),
('968', '13', '203', '10', '2017-04-27 00:04:44', NULL, '2', '2016-12-15', '0'),
('969', '10', '206', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-15', '193'),
('970', '30', '204', '10', '2017-04-27 00:06:54', NULL, '2', '2016-08-18', '0'),
('971', '13', '204', '10', '2017-04-27 00:06:54', NULL, '2', '2016-08-18', '0'),
('972', '10', '207', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-18', '97'),
('973', '30', '205', '10', '2017-04-27 00:09:44', NULL, '2', '2016-08-29', '0'),
('974', '13', '205', '10', '2017-04-27 00:09:45', NULL, '2', '2016-08-29', '0'),
('975', '10', '208', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-29', '105'),
('976', '30', '206', '10', '2017-04-27 00:12:55', NULL, '2', '2016-04-11', '0'),
('977', '13', '206', '10', '2017-04-27 00:12:55', NULL, '2', '2016-04-11', '0'),
('978', '10', '209', '10', '2019-11-05 05:45:21', NULL, '2', '2016-04-11', '4'),
('979', '30', '207', '10', '2017-04-27 00:14:10', NULL, '2', '2016-12-29', '0'),
('980', '13', '207', '10', '2017-04-27 00:14:10', NULL, '2', '2016-12-29', '0'),
('981', '10', '210', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-29', '215'),
('982', '30', '208', '10', '2017-04-27 00:16:35', NULL, '2', '2016-05-26', '0'),
('983', '13', '208', '10', '2017-04-27 00:16:35', NULL, '2', '2016-05-26', '0'),
('984', '10', '211', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-26', '23'),
('985', '12', '44', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-01', '304'),
('986', '30', '209', '10', '2017-04-27 00:19:19', NULL, '2', '2016-08-26', '0'),
('987', '13', '209', '10', '2017-04-27 00:19:19', NULL, '2', '2016-08-26', '0'),
('988', '10', '212', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-26', '104'),
('989', '30', '210', '10', '2017-04-27 00:20:37', NULL, '2', '2017-03-30', '0'),
('990', '13', '210', '10', '2017-04-27 00:20:37', NULL, '2', '2017-03-30', '0'),
('991', '10', '213', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '460'),
('992', '30', '211', '10', '2017-04-27 00:21:57', NULL, '1', '2016-02-19', '0'),
('993', '13', '211', '10', '2017-04-27 00:21:57', NULL, '1', '2016-02-19', '0'),
('994', '10', '214', '10', '2018-02-05 04:47:11', NULL, '1', '2016-02-19', '66'),
('995', '30', '212', '10', '2017-04-27 00:22:48', NULL, '2', '2017-02-21', '0'),
('996', '13', '212', '10', '2017-04-27 00:22:48', NULL, '2', '2017-02-21', '0'),
('997', '10', '215', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-21', '339'),
('998', '30', '213', '10', '2017-04-27 00:24:51', NULL, '2', '2016-06-29', '0'),
('999', '13', '213', '10', '2017-04-27 00:27:24', NULL, '3', '2016-06-29', NULL),
('1000', '10', '216', '10', '2017-04-27 00:27:24', NULL, '3', '2016-06-29', NULL),
('1001', '13', '213', '10', '2017-04-27 00:27:24', 'Voided.', '3', '2017-04-27', '0'),
('1002', '10', '216', '10', '2017-04-27 00:27:24', 'Voided.\nSelected Wrong Customer-Voided by Dilrukshi', '3', '2017-04-27', '0'),
('1003', '30', '214', '10', '2017-04-27 00:29:43', NULL, '2', '2016-06-29', '0'),
('1004', '13', '214', '10', '2017-04-27 00:29:43', NULL, '2', '2016-06-29', '0'),
('1005', '10', '217', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-29', '54'),
('1006', '12', '45', '10', '2017-10-19 04:42:52', NULL, '2', '2017-01-03', NULL),
('1007', '30', '215', '10', '2017-04-27 00:32:15', NULL, '2', '2017-01-08', '0'),
('1008', '13', '215', '10', '2017-04-27 00:32:15', NULL, '2', '2017-01-08', '0'),
('1009', '10', '218', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-08', '252'),
('1010', '30', '216', '10', '2017-04-27 00:44:34', NULL, '2', '2016-09-13', '0'),
('1011', '13', '216', '10', '2017-04-27 00:44:34', NULL, '2', '2016-09-13', '0'),
('1012', '10', '219', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-13', '116'),
('1013', '30', '217', '10', '2017-04-27 00:49:48', NULL, '2', '2017-01-09', '0'),
('1014', '13', '217', '10', '2017-04-27 00:49:48', NULL, '2', '2017-01-09', '0'),
('1015', '10', '220', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-09', '255'),
('1016', '12', '46', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-06', '379'),
('1017', '30', '218', '10', '2017-04-27 00:53:00', NULL, '2', '2016-07-29', '0'),
('1018', '13', '218', '10', '2017-04-27 00:53:00', NULL, '2', '2016-07-29', '0'),
('1019', '10', '221', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-29', '78'),
('1020', '11', '7', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-04', '168'),
('1021', '11', '8', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-03', '232'),
('1022', '30', '219', '10', '2017-04-27 00:58:05', NULL, '2', '2016-07-31', '0'),
('1023', '13', '219', '10', '2017-04-27 00:58:05', NULL, '2', '2016-07-31', '0'),
('1024', '10', '222', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-31', '79'),
('1025', '30', '220', '10', '2017-04-27 00:59:42', NULL, '2', '2017-02-24', '0'),
('1026', '13', '220', '10', '2017-04-27 00:59:42', NULL, '2', '2017-02-24', '0'),
('1027', '10', '223', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-24', '348'),
('1028', '30', '221', '10', '2017-04-27 01:00:31', NULL, '2', '2017-03-03', '0'),
('1029', '13', '221', '10', '2017-04-27 01:00:31', NULL, '2', '2017-03-03', '0'),
('1030', '10', '224', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-03', '375'),
('1031', '1', '155', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '229'),
('1032', '30', '222', '10', '2017-04-27 01:16:06', NULL, '2', '2016-12-30', '0'),
('1033', '13', '222', '10', '2017-04-27 01:16:06', NULL, '2', '2016-12-30', '0'),
('1034', '10', '225', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-30', '223'),
('1035', '30', '223', '10', '2017-04-27 01:17:15', NULL, '2', '2017-01-27', '0'),
('1036', '13', '223', '10', '2017-04-27 01:17:15', NULL, '2', '2017-01-27', '0'),
('1037', '10', '226', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-27', '286'),
('1038', '12', '47', '10', '2017-04-27 01:19:21', NULL, '3', '2017-04-11', NULL),
('1039', '12', '47', '10', '2017-04-27 01:19:21', 'Voided.\nBy Dilrukshi', '3', '2017-04-27', '0'),
('1040', '30', '224', '10', '2017-04-27 01:21:02', NULL, '1', '2016-02-29', '0'),
('1041', '13', '224', '10', '2017-04-27 01:21:02', NULL, '1', '2016-02-29', '0'),
('1042', '10', '227', '10', '2018-02-05 04:47:11', NULL, '1', '2016-02-29', '68'),
('1043', '12', '48', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-03', '233'),
('1044', '30', '225', '10', '2017-04-27 01:23:15', NULL, '2', '2016-09-23', '0'),
('1045', '13', '225', '10', '2017-04-27 01:23:15', NULL, '2', '2016-09-23', '0'),
('1046', '10', '228', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-23', '129'),
('1047', '30', '226', '10', '2017-04-27 01:24:10', NULL, '2', '2017-01-31', '0'),
('1048', '13', '226', '10', '2017-04-27 01:24:10', NULL, '2', '2017-01-31', '0'),
('1049', '10', '229', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-31', '296'),
('1050', '30', '227', '10', '2017-04-27 01:25:15', NULL, '2', '2016-09-15', '0'),
('1051', '13', '227', '10', '2017-04-27 01:25:15', NULL, '2', '2016-09-15', '0'),
('1052', '10', '230', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-15', '120'),
('1053', '30', '228', '10', '2017-04-27 01:36:18', NULL, '3', '2017-04-01', '0'),
('1054', '13', '228', '10', '2017-04-27 01:36:18', NULL, '3', '2017-04-01', '0'),
('1055', '10', '231', '10', '2017-04-27 01:37:06', NULL, '2', '2017-04-01', NULL),
('1056', '10', '231', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-01-04', '248'),
('1057', '30', '229', '10', '2017-04-27 01:40:09', NULL, '2', '2017-03-23', '0'),
('1058', '13', '229', '10', '2017-04-27 01:40:09', NULL, '2', '2017-03-23', '0'),
('1059', '10', '232', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-23', '426'),
('1060', '30', '230', '10', '2017-04-27 01:47:38', NULL, '2', '2016-08-16', '0'),
('1061', '13', '230', '10', '2017-04-27 01:47:38', NULL, '2', '2016-08-16', '0'),
('1062', '10', '233', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-16', '95'),
('1063', '30', '231', '10', '2017-04-27 01:48:53', NULL, '2', '2016-12-15', '0'),
('1064', '13', '231', '10', '2017-04-27 01:48:53', NULL, '2', '2016-12-15', '0'),
('1065', '10', '234', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-15', '194'),
('1066', '12', '49', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-24', '276'),
('1067', '1', '156', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '230'),
('1068', '30', '232', '10', '2017-04-27 01:56:57', NULL, '2', '2016-06-07', '0'),
('1069', '13', '232', '10', '2017-04-27 01:56:57', NULL, '2', '2016-06-07', '0'),
('1070', '10', '235', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-07', '36'),
('1071', '30', '233', '10', '2017-04-27 01:57:50', NULL, '2', '2016-09-08', '0'),
('1072', '13', '233', '10', '2017-04-27 01:57:50', NULL, '2', '2016-09-08', '0'),
('1073', '10', '236', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-08', '114'),
('1074', '30', '234', '10', '2017-04-27 01:58:44', NULL, '2', '2017-01-31', '0'),
('1075', '13', '234', '10', '2017-04-27 01:58:44', NULL, '2', '2017-01-31', '0'),
('1076', '10', '237', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-31', '297'),
('1077', '12', '50', '10', '2017-10-19 01:04:10', NULL, '3', '2017-05-31', NULL),
('1078', '30', '235', '10', '2017-04-27 02:02:54', NULL, '2', '2016-10-10', '0'),
('1079', '13', '235', '10', '2017-04-27 02:02:54', NULL, '2', '2016-10-10', '0'),
('1080', '10', '238', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-10', '148'),
('1081', '11', '9', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-29', '216'),
('1082', '12', '51', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '435'),
('1083', '30', '236', '10', '2017-04-27 02:08:09', NULL, '2', '2016-12-15', '0'),
('1084', '13', '236', '10', '2017-04-27 02:08:09', NULL, '2', '2016-12-15', '0'),
('1085', '10', '239', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-15', '195'),
('1086', '12', '52', '10', '2017-10-19 04:56:23', NULL, '2', '2017-02-16', NULL),
('1087', '30', '237', '10', '2017-04-27 02:11:08', NULL, '2', '2017-02-13', '0'),
('1088', '13', '237', '10', '2017-04-27 02:11:08', NULL, '2', '2017-02-13', '0'),
('1089', '10', '240', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-13', '324'),
('1090', '12', '53', '10', '2017-04-27 02:30:53', NULL, '3', '2017-04-06', NULL),
('1091', '12', '53', '10', '2017-04-27 02:30:53', 'Voided.\nBy Dilrukshi\n', '3', '2017-04-27', '0'),
('1092', '1', '157', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '231'),
('1093', '1', '158', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '232'),
('1094', '1', '159', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-24', '192'),
('1095', '1', '160', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-24', '193'),
('1096', '30', '238', '10', '2017-04-27 03:25:14', NULL, '3', '2017-04-24', '0'),
('1097', '13', '238', '10', '2017-04-27 03:25:14', NULL, '3', '2017-04-24', '0'),
('1098', '10', '241', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-24', '194'),
('1099', '30', '239', '10', '2017-04-27 03:26:35', NULL, '3', '2017-04-24', '0'),
('1100', '13', '239', '10', '2017-04-27 03:26:35', NULL, '3', '2017-04-24', '0'),
('1101', '10', '242', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-24', '195'),
('1102', '30', '240', '10', '2017-04-27 03:27:50', NULL, '2', '2016-09-30', '0'),
('1103', '13', '240', '10', '2017-04-27 03:27:50', NULL, '2', '2016-09-30', '0'),
('1104', '10', '243', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-30', '137'),
('1105', '30', '241', '10', '2017-04-27 03:28:48', NULL, '2', '2016-12-28', '0'),
('1106', '13', '241', '10', '2017-04-27 03:28:48', NULL, '2', '2016-12-28', '0'),
('1107', '10', '244', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-28', '210'),
('1108', '12', '54', '10', '2017-10-19 01:15:24', NULL, '2', '2017-01-03', NULL),
('1109', '30', '242', '10', '2017-04-27 03:35:44', NULL, '2', '2016-08-02', '0'),
('1110', '13', '242', '10', '2017-04-27 03:35:44', NULL, '2', '2016-08-02', '0'),
('1111', '10', '245', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-02', '86'),
('1112', '30', '243', '10', '2017-04-27 03:36:49', NULL, '2', '2016-10-22', '0'),
('1113', '13', '243', '10', '2017-04-27 03:36:49', NULL, '2', '2016-10-22', '0'),
('1114', '10', '246', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-22', '157'),
('1115', '30', '244', '10', '2017-04-27 03:39:35', NULL, '2', '2017-01-26', '0'),
('1116', '13', '244', '10', '2017-04-27 03:39:35', NULL, '2', '2017-01-26', '0'),
('1117', '10', '247', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-26', '281'),
('1118', '30', '245', '10', '2017-04-27 03:40:41', NULL, '2', '2017-03-30', '0'),
('1119', '13', '245', '10', '2017-04-27 03:40:41', NULL, '2', '2017-03-30', '0'),
('1120', '10', '248', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '461'),
('1121', '30', '246', '10', '2017-04-27 03:42:20', NULL, '1', '2016-02-17', '0'),
('1122', '13', '246', '10', '2017-04-27 03:42:20', NULL, '1', '2016-02-17', '0'),
('1123', '10', '249', '10', '2018-02-05 04:47:11', NULL, '1', '2016-02-17', '63'),
('1124', '12', '55', '10', '2017-10-24 04:12:39', NULL, '2', '2017-01-03', NULL),
('1125', '30', '247', '10', '2017-04-27 03:47:56', NULL, '2', '2017-01-20', '0'),
('1126', '13', '247', '10', '2017-04-27 03:47:56', NULL, '2', '2017-01-20', '0'),
('1127', '10', '250', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-20', '267'),
('1128', '30', '248', '10', '2017-04-27 03:59:59', NULL, '2', '2017-03-09', '0'),
('1129', '13', '248', '10', '2017-04-27 03:59:59', NULL, '2', '2017-03-09', '0'),
('1130', '10', '251', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-09', '389'),
('1131', '30', '249', '10', '2017-04-27 04:00:48', NULL, '2', '2017-03-31', '0'),
('1132', '13', '249', '10', '2017-04-27 04:00:48', NULL, '2', '2017-03-31', '0'),
('1133', '10', '252', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '484'),
('1134', '30', '250', '10', '2017-04-27 04:02:43', NULL, '2', '2017-01-23', '0'),
('1135', '13', '250', '10', '2017-04-27 04:02:43', NULL, '2', '2017-01-23', '0'),
('1136', '10', '253', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-23', '273'),
('1137', '30', '251', '10', '2017-04-27 04:05:39', NULL, '2', '2017-01-30', '0'),
('1138', '13', '251', '10', '2017-04-27 04:05:39', NULL, '2', '2017-01-30', '0'),
('1139', '10', '254', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-30', '292'),
('1140', '30', '252', '10', '2017-04-27 04:06:39', NULL, '2', '2016-06-08', '0'),
('1141', '13', '252', '10', '2017-04-27 04:06:39', NULL, '2', '2016-06-08', '0'),
('1142', '10', '255', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-08', '37'),
('1143', '30', '253', '10', '2017-04-27 04:07:40', NULL, '2', '2016-06-27', '0'),
('1144', '13', '253', '10', '2017-04-27 04:07:40', NULL, '2', '2016-06-27', '0'),
('1145', '10', '256', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-27', '52'),
('1146', '30', '254', '10', '2017-04-27 04:09:49', NULL, '2', '2017-03-30', '0'),
('1147', '13', '254', '10', '2017-04-27 04:09:50', NULL, '2', '2017-03-30', '0'),
('1148', '10', '257', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '462'),
('1149', '30', '255', '10', '2017-04-27 04:11:00', NULL, '2', '2016-10-07', '0'),
('1150', '13', '255', '10', '2017-04-27 04:11:00', NULL, '2', '2016-10-07', '0'),
('1151', '10', '258', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-07', '145'),
('1152', '30', '256', '10', '2017-04-27 04:11:59', NULL, '2', '2017-02-09', '0'),
('1153', '13', '256', '10', '2017-04-27 04:11:59', NULL, '2', '2017-02-09', '0'),
('1154', '10', '259', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-09', '316'),
('1155', '1', '161', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '233'),
('1156', '1', '162', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '234'),
('1157', '1', '163', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '235'),
('1158', '1', '164', '10', '2017-04-27 04:30:30', NULL, '3', '2017-04-27', NULL),
('1159', '1', '165', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '236'),
('1160', '1', '166', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '237'),
('1161', '1', '164', '10', '2017-04-27 04:30:30', 'Voided.\nDocument reentered.', '3', '2017-04-27', '0'),
('1162', '1', '167', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '238'),
('1163', '1', '168', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '239'),
('1164', '1', '169', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '240'),
('1165', '30', '257', '10', '2017-04-27 05:16:24', NULL, '3', '2017-04-27', '0'),
('1166', '13', '257', '10', '2017-04-27 05:16:24', NULL, '3', '2017-04-27', '0'),
('1167', '10', '260', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '241'),
('1168', '12', '56', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '242'),
('1169', '30', '258', '10', '2017-04-27 05:47:04', NULL, '2', '2016-05-06', '0'),
('1170', '13', '258', '10', '2017-04-27 05:47:05', NULL, '2', '2016-05-06', '0'),
('1171', '10', '261', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-06', '13'),
('1172', '30', '259', '10', '2017-04-27 05:51:17', NULL, '2', '2016-04-12', '0'),
('1173', '13', '259', '10', '2017-04-27 05:51:17', NULL, '2', '2016-04-12', '0'),
('1174', '10', '262', '10', '2019-11-05 05:45:21', NULL, '2', '2016-04-12', '5'),
('1175', '30', '260', '10', '2017-04-27 06:12:37', NULL, '1', '2016-03-03', '0'),
('1176', '13', '260', '10', '2017-04-27 06:12:37', NULL, '1', '2016-03-03', '0'),
('1177', '10', '263', '10', '2018-02-05 04:47:11', NULL, '1', '2016-03-03', '70'),
('1178', '12', '57', '10', '2017-04-27 06:14:14', NULL, '2', '2016-03-01', NULL),
('1179', '12', '57', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-01-03', '234'),
('1180', '11', '10', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-03', '235'),
('1181', '30', '261', '10', '2017-04-27 06:21:05', NULL, '2', '2017-02-14', '0'),
('1182', '13', '261', '10', '2017-04-27 06:21:05', NULL, '2', '2017-02-14', '0'),
('1183', '10', '264', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-14', '328'),
('1184', '30', '262', '10', '2017-04-27 06:22:43', NULL, '2', '2016-07-15', '0'),
('1185', '13', '262', '10', '2017-04-27 06:22:43', NULL, '2', '2016-07-15', '0'),
('1186', '10', '265', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-15', '65'),
('1187', '30', '263', '10', '2017-04-27 06:23:48', NULL, '2', '2016-12-19', '0'),
('1188', '13', '263', '10', '2017-04-27 06:23:48', NULL, '2', '2016-12-19', '0'),
('1189', '10', '266', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-19', '198'),
('1190', '30', '264', '10', '2017-04-27 06:25:11', NULL, '1', '2016-02-19', '0'),
('1191', '13', '264', '10', '2017-04-27 06:25:11', NULL, '1', '2016-02-19', '0'),
('1192', '10', '267', '10', '2018-02-05 04:47:11', NULL, '1', '2016-02-19', '67'),
('1193', '1', '170', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '257'),
('1194', '1', '171', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '258'),
('1195', '1', '172', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '259'),
('1196', '1', '173', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '260'),
('1197', '18', '1', '10', '2017-04-28 03:24:09', NULL, '2', '2017-03-14', '0'),
('1198', '25', '1', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-14', '400'),
('1199', '20', '1', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-14', '401'),
('1200', '22', '1', '10', '2017-04-28 03:28:06', NULL, '3', '2017-03-14', NULL),
('1201', '22', '1', '10', '2017-04-28 03:28:06', 'Voided.\nBy Dilrukshi\n', '3', '2017-04-28', '0'),
('1202', '22', '2', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '261'),
('1203', '1', '174', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '262'),
('1204', '1', '175', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-25', '210'),
('1205', '1', '176', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '263'),
('1206', '1', '177', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '264'),
('1207', '1', '178', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '265'),
('1208', '1', '179', '10', '2018-03-19 11:00:57', NULL, '3', '2017-05-02', NULL),
('1209', '2', '53', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-02', '295'),
('1210', '1', '180', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-02', '296'),
('1211', '1', '181', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-02', '297'),
('1212', '1', '182', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-02', '298'),
('1213', '1', '183', '10', '2018-03-06 23:11:20', NULL, '3', '2017-05-02', NULL),
('1214', '30', '265', '10', '2017-05-02 05:22:46', NULL, '2', '2016-11-16', '0'),
('1215', '13', '265', '10', '2017-05-02 05:22:46', NULL, '2', '2016-11-16', '0'),
('1216', '10', '268', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-16', '173'),
('1217', '30', '266', '10', '2017-05-02 05:24:19', NULL, '2', '2017-01-26', '0'),
('1218', '13', '266', '10', '2017-05-02 05:24:19', NULL, '2', '2017-01-26', '0'),
('1219', '10', '269', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-26', '282'),
('1220', '30', '267', '10', '2017-05-02 05:25:57', NULL, '2', '2016-06-06', '0'),
('1221', '13', '267', '10', '2017-05-02 05:25:57', NULL, '2', '2016-06-06', '0'),
('1222', '10', '270', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-06', '33'),
('1223', '30', '268', '10', '2017-05-02 05:27:34', NULL, '2', '2017-02-28', '0'),
('1224', '13', '268', '10', '2017-05-02 05:27:34', NULL, '2', '2017-02-28', '0'),
('1225', '10', '271', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '360'),
('1226', '30', '269', '10', '2017-05-02 05:29:09', NULL, '2', '2017-01-27', '0'),
('1227', '13', '269', '10', '2017-05-02 05:29:09', NULL, '2', '2017-01-27', '0'),
('1228', '10', '272', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-27', '287'),
('1229', '30', '270', '10', '2017-05-02 05:32:48', NULL, '2', '2017-03-27', '0'),
('1230', '13', '270', '10', '2017-05-02 05:32:48', NULL, '2', '2017-03-27', '0'),
('1231', '10', '273', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-27', '437'),
('1232', '30', '271', '10', '2017-05-02 05:35:22', NULL, '1', '2015-06-11', '0'),
('1233', '13', '271', '10', '2017-05-02 05:35:22', NULL, '1', '2015-06-11', '0'),
('1234', '10', '274', '10', '2018-02-05 04:47:11', NULL, '1', '2015-06-11', '44'),
('1235', '30', '272', '10', '2017-05-02 05:37:42', NULL, '2', '2016-05-20', '0'),
('1236', '13', '272', '10', '2017-05-02 05:37:42', NULL, '2', '2016-05-20', '0'),
('1237', '10', '275', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-20', '18'),
('1238', '30', '273', '10', '2017-05-02 05:42:28', NULL, '2', '2016-10-22', '0'),
('1239', '13', '273', '10', '2017-05-02 05:42:28', NULL, '2', '2016-10-22', '0'),
('1240', '10', '276', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-22', '158'),
('1241', '30', '274', '10', '2017-05-02 05:46:06', NULL, '2', '2016-05-20', '0'),
('1242', '13', '274', '10', '2017-05-02 05:46:06', NULL, '2', '2016-05-20', '0'),
('1243', '10', '277', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-20', '19'),
('1244', '11', '11', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-03', '236'),
('1245', '30', '275', '10', '2017-05-02 05:48:29', NULL, '2', '2016-12-19', '0'),
('1246', '13', '275', '10', '2017-05-02 05:48:29', NULL, '2', '2016-12-19', '0'),
('1247', '10', '278', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-19', '199'),
('1248', '30', '276', '10', '2017-05-02 05:50:20', NULL, '2', '2017-01-23', '0'),
('1249', '13', '276', '10', '2017-05-02 05:50:20', NULL, '2', '2017-01-23', '0'),
('1250', '10', '279', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-23', '274'),
('1251', '30', '277', '10', '2017-05-02 05:52:00', NULL, '2', '2016-09-15', '0'),
('1252', '13', '277', '10', '2017-05-02 05:52:00', NULL, '2', '2016-09-15', '0'),
('1253', '10', '280', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-15', '121'),
('1254', '30', '278', '10', '2017-05-02 05:52:37', NULL, '2', '2016-11-16', '0'),
('1255', '13', '278', '10', '2017-05-02 05:52:38', NULL, '2', '2016-11-16', '0'),
('1256', '10', '281', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-16', '174'),
('1257', '12', '58', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-17', '414'),
('1258', '30', '279', '10', '2017-05-02 05:56:48', NULL, '2', '2017-03-29', '0'),
('1259', '13', '279', '10', '2017-05-02 05:56:48', NULL, '2', '2017-03-29', '0'),
('1260', '10', '282', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-29', '446'),
('1261', '30', '280', '10', '2017-05-02 05:57:58', NULL, '2', '2016-10-25', '0'),
('1262', '13', '280', '10', '2017-05-02 05:57:58', NULL, '2', '2016-10-25', '0'),
('1263', '10', '283', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-25', '159'),
('1264', '30', '281', '10', '2017-05-02 06:00:52', NULL, '1', '2016-03-04', '0'),
('1265', '13', '281', '10', '2017-05-02 06:00:52', NULL, '1', '2016-03-04', '0'),
('1266', '10', '284', '10', '2018-02-05 04:47:11', NULL, '1', '2016-03-04', '71'),
('1267', '30', '282', '10', '2017-05-02 06:02:51', NULL, '2', '2016-10-28', '0'),
('1268', '13', '282', '10', '2017-05-02 06:02:51', NULL, '2', '2016-10-28', '0'),
('1269', '10', '285', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-28', '162'),
('1270', '30', '283', '10', '2017-05-02 06:05:50', NULL, '2', '2017-01-27', '0'),
('1271', '13', '283', '10', '2017-05-02 06:05:50', NULL, '2', '2017-01-27', '0'),
('1272', '10', '286', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-27', '288'),
('1273', '30', '284', '10', '2017-05-02 06:06:37', NULL, '2', '2017-03-30', '0'),
('1274', '13', '284', '10', '2017-05-02 06:06:37', NULL, '2', '2017-03-30', '0'),
('1275', '10', '287', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '463'),
('1276', '30', '285', '10', '2017-05-02 06:07:48', NULL, '2', '2016-04-20', '0'),
('1277', '13', '285', '10', '2017-05-02 06:07:48', NULL, '2', '2016-04-20', '0');
INSERT INTO `0_audit_trail` VALUES
('1278', '10', '288', '10', '2019-11-05 05:45:21', NULL, '2', '2016-04-20', '6'),
('1279', '30', '286', '10', '2017-05-02 06:10:31', NULL, '1', '2015-11-04', '0'),
('1280', '13', '286', '10', '2017-05-02 06:10:31', NULL, '1', '2015-11-04', '0'),
('1281', '10', '289', '10', '2018-02-05 04:47:11', NULL, '1', '2015-11-04', '48'),
('1282', '12', '59', '10', '2017-10-24 03:28:10', NULL, '2', '2016-12-29', NULL),
('1283', '30', '287', '10', '2017-05-02 06:13:21', NULL, '2', '2016-08-01', '0'),
('1284', '13', '287', '10', '2017-05-02 06:13:21', NULL, '2', '2016-08-01', '0'),
('1285', '10', '290', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-01', '83'),
('1286', '30', '288', '10', '2017-05-02 06:14:30', NULL, '2', '2017-02-17', '0'),
('1287', '13', '288', '10', '2017-05-02 06:14:30', NULL, '2', '2017-02-17', '0'),
('1288', '10', '291', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-17', '336'),
('1289', '30', '289', '10', '2017-05-02 06:17:25', NULL, '2', '2017-03-29', '0'),
('1290', '13', '289', '10', '2017-05-02 06:17:25', NULL, '2', '2017-03-29', '0'),
('1291', '10', '292', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-29', '447'),
('1292', '30', '290', '10', '2017-05-02 06:19:54', NULL, '2', '2016-06-29', '0'),
('1293', '13', '290', '10', '2017-05-02 06:19:54', NULL, '2', '2016-06-29', '0'),
('1294', '10', '293', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-29', '55'),
('1295', '30', '291', '10', '2017-05-02 06:20:51', NULL, '2', '2016-10-31', '0'),
('1296', '13', '291', '10', '2017-05-02 06:20:51', NULL, '2', '2016-10-31', '0'),
('1297', '10', '294', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-31', '166'),
('1298', '30', '292', '10', '2017-05-02 06:21:58', NULL, '2', '2016-09-14', '0'),
('1299', '13', '292', '10', '2017-05-02 06:21:58', NULL, '2', '2016-09-14', '0'),
('1300', '10', '295', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-14', '117'),
('1301', '30', '293', '10', '2017-05-02 06:23:14', NULL, '2', '2017-02-28', '0'),
('1302', '13', '293', '10', '2017-05-02 06:23:14', NULL, '2', '2017-02-28', '0'),
('1303', '10', '296', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '361'),
('1304', '30', '294', '10', '2017-05-02 23:52:42', NULL, '2', '2016-12-29', '0'),
('1305', '13', '294', '10', '2017-05-02 23:52:42', NULL, '2', '2016-12-29', '0'),
('1306', '10', '297', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-29', '217'),
('1307', '30', '295', '10', '2017-05-02 23:54:35', NULL, '2', '2016-05-23', '0'),
('1308', '13', '295', '10', '2017-05-02 23:54:35', NULL, '2', '2016-05-23', '0'),
('1309', '10', '298', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-23', '21'),
('1310', '30', '296', '10', '2017-05-02 23:56:16', NULL, '1', '2016-03-11', '0'),
('1311', '13', '296', '10', '2017-05-02 23:56:16', NULL, '1', '2016-03-11', '0'),
('1312', '10', '299', '10', '2018-02-05 04:47:11', NULL, '1', '2016-03-11', '73'),
('1313', '30', '297', '10', '2017-05-02 23:57:22', NULL, '2', '2016-05-27', '0'),
('1314', '13', '297', '10', '2017-05-02 23:57:23', NULL, '2', '2016-05-27', '0'),
('1315', '10', '300', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-27', '24'),
('1316', '12', '60', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-27', '25'),
('1317', '11', '12', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-16', '122'),
('1318', '11', '13', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-16', '123'),
('1319', '30', '298', '10', '2017-05-03 00:05:55', NULL, '2', '2016-09-16', '0'),
('1320', '13', '298', '10', '2017-05-03 00:05:55', NULL, '2', '2016-09-16', '0'),
('1321', '10', '301', '10', '2017-05-15 05:15:00', NULL, '2', '2016-09-16', NULL),
('1322', '30', '299', '10', '2017-05-03 00:08:13', NULL, '2', '2016-12-30', '0'),
('1323', '13', '299', '10', '2017-05-03 00:08:13', NULL, '2', '2016-12-30', '0'),
('1324', '10', '302', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-30', '224'),
('1325', '30', '300', '10', '2017-05-03 00:12:14', NULL, '2', '2016-08-30', '0'),
('1326', '13', '300', '10', '2017-05-03 00:12:14', NULL, '2', '2016-08-30', '0'),
('1327', '10', '303', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-30', '106'),
('1328', '30', '301', '10', '2017-05-03 00:13:18', NULL, '2', '2016-11-09', '0'),
('1329', '13', '301', '10', '2017-05-03 00:13:18', NULL, '2', '2016-11-09', '0'),
('1330', '10', '304', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-09', '170'),
('1331', '30', '302', '10', '2017-05-03 00:14:04', NULL, '2', '2017-03-28', '0'),
('1332', '13', '302', '10', '2017-05-03 00:14:04', NULL, '2', '2017-03-28', '0'),
('1333', '10', '305', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-28', '440'),
('1334', '30', '303', '10', '2017-05-03 00:15:22', NULL, '2', '2016-11-25', '0'),
('1335', '13', '303', '10', '2017-05-03 00:15:22', NULL, '2', '2016-11-25', '0'),
('1336', '10', '306', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-25', '178'),
('1337', '30', '304', '10', '2017-05-03 00:30:54', NULL, '1', '2015-11-11', '0'),
('1338', '13', '304', '10', '2017-05-03 00:30:54', NULL, '1', '2015-11-11', '0'),
('1339', '10', '307', '10', '2018-02-05 04:47:11', NULL, '1', '2015-11-11', '49'),
('1340', '30', '305', '10', '2017-05-03 00:33:19', NULL, '1', '2016-01-20', '0'),
('1341', '13', '305', '10', '2017-05-03 00:33:19', NULL, '1', '2016-01-20', '0'),
('1342', '10', '308', '10', '2018-02-05 04:47:11', NULL, '1', '2016-01-20', '54'),
('1343', '30', '306', '10', '2017-05-03 00:34:58', NULL, '1', '2016-01-20', '0'),
('1344', '13', '306', '10', '2017-10-24 03:46:09', NULL, '3', '2016-01-20', NULL),
('1345', '10', '309', '10', '2017-10-24 03:46:09', NULL, '3', '2016-01-20', NULL),
('1346', '4', '5', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '306'),
('1347', '30', '307', '10', '2017-05-03 01:19:45', NULL, '2', '2016-06-23', '0'),
('1348', '13', '307', '10', '2017-05-03 01:19:45', NULL, '2', '2016-06-23', '0'),
('1349', '10', '310', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-23', '49'),
('1350', '30', '308', '10', '2017-05-03 01:20:51', NULL, '2', '2017-02-28', '0'),
('1351', '13', '308', '10', '2017-05-03 01:20:51', NULL, '2', '2017-02-28', '0'),
('1352', '10', '311', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '362'),
('1353', '30', '309', '10', '2017-05-03 01:22:18', NULL, '2', '2016-07-04', '0'),
('1354', '13', '309', '10', '2017-05-03 01:22:18', NULL, '2', '2016-07-04', '0'),
('1355', '10', '312', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-04', '59'),
('1356', '30', '310', '10', '2017-05-03 01:23:45', NULL, '3', '2017-04-06', '0'),
('1357', '13', '310', '10', '2017-05-03 01:23:45', NULL, '3', '2017-04-06', '0'),
('1358', '10', '313', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '65'),
('1359', '30', '311', '10', '2017-05-03 01:36:51', NULL, '2', '2017-02-24', '0'),
('1360', '13', '311', '10', '2017-05-03 01:36:51', NULL, '2', '2017-02-24', '0'),
('1361', '10', '314', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-24', '349'),
('1362', '30', '312', '10', '2017-05-03 01:37:59', NULL, '2', '2017-02-28', '0'),
('1363', '13', '312', '10', '2017-05-03 01:37:59', NULL, '2', '2017-02-28', '0'),
('1364', '10', '315', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '363'),
('1365', '30', '313', '10', '2017-05-03 01:39:34', NULL, '2', '2017-01-26', '0'),
('1366', '13', '313', '10', '2017-05-03 01:39:34', NULL, '2', '2017-01-26', '0'),
('1367', '10', '316', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-26', '283'),
('1368', '30', '314', '10', '2017-05-03 01:40:39', NULL, '2', '2017-03-03', '0'),
('1369', '13', '314', '10', '2017-05-03 01:40:39', NULL, '2', '2017-03-03', '0'),
('1370', '10', '317', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-03', '376'),
('1371', '30', '315', '10', '2017-05-03 01:42:14', NULL, '2', '2016-12-30', '0'),
('1372', '13', '315', '10', '2017-05-03 01:42:14', NULL, '2', '2016-12-30', '0'),
('1373', '10', '318', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-30', '225'),
('1374', '30', '316', '10', '2017-05-03 01:43:53', NULL, '2', '2017-01-31', '0'),
('1375', '13', '316', '10', '2017-05-03 01:43:53', NULL, '2', '2017-01-31', '0'),
('1376', '10', '319', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-31', '298'),
('1377', '12', '61', '10', '2017-10-19 04:41:10', NULL, '2', '2017-02-13', NULL),
('1378', '30', '317', '10', '2017-05-03 01:46:47', NULL, '2', '2017-02-28', '0'),
('1379', '13', '317', '10', '2017-05-03 01:46:47', NULL, '2', '2017-02-28', '0'),
('1380', '10', '320', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '364'),
('1381', '30', '318', '10', '2017-05-03 01:54:55', NULL, '2', '2016-06-15', '0'),
('1382', '13', '318', '10', '2017-05-03 01:54:55', NULL, '2', '2016-06-15', '0'),
('1383', '10', '321', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-15', '41'),
('1384', '12', '62', '10', '2017-10-19 04:44:21', NULL, '2', '2016-12-20', NULL),
('1385', '30', '319', '10', '2017-05-03 02:03:44', NULL, '2', '2016-07-15', '0'),
('1386', '13', '319', '10', '2017-05-03 02:03:44', NULL, '2', '2016-07-15', '0'),
('1387', '10', '322', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-15', '66'),
('1388', '30', '320', '10', '2017-05-03 02:05:18', NULL, '2', '2017-03-23', '0'),
('1389', '13', '320', '10', '2017-05-03 02:05:18', NULL, '2', '2017-03-23', '0'),
('1390', '10', '323', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-23', '427'),
('1391', '30', '321', '10', '2017-05-03 02:17:21', NULL, '2', '2016-12-16', '0'),
('1392', '13', '321', '10', '2017-05-03 02:17:21', NULL, '2', '2016-12-16', '0'),
('1393', '10', '324', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-16', '197'),
('1394', '30', '322', '10', '2017-05-03 02:18:47', NULL, '2', '2016-10-31', '0'),
('1395', '13', '322', '10', '2017-05-03 02:18:47', NULL, '2', '2016-10-31', '0'),
('1396', '10', '325', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-31', '167'),
('1397', '30', '323', '10', '2017-05-03 02:19:55', NULL, '2', '2017-03-17', '0'),
('1398', '13', '323', '10', '2017-05-03 02:19:55', NULL, '2', '2017-03-17', '0'),
('1399', '10', '326', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-17', '415'),
('1400', '30', '324', '10', '2017-05-03 02:22:45', NULL, '2', '2016-12-30', '0'),
('1401', '13', '324', '10', '2017-05-03 02:22:45', NULL, '2', '2016-12-30', '0'),
('1402', '10', '327', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-30', '226'),
('1403', '1', '184', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '307'),
('1404', '1', '185', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '308'),
('1405', '30', '325', '10', '2017-05-03 03:07:53', NULL, '2', '2016-11-30', '0'),
('1406', '13', '325', '10', '2017-05-18 00:01:38', NULL, '3', '2016-11-30', NULL),
('1407', '10', '328', '10', '2017-05-18 00:01:38', NULL, '3', '2016-11-30', NULL),
('1408', '30', '326', '10', '2017-05-03 03:09:26', NULL, '2', '2017-03-03', '0'),
('1409', '13', '326', '10', '2017-05-03 03:09:27', NULL, '2', '2017-03-03', '0'),
('1410', '10', '329', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-03', '377'),
('1411', '12', '63', '10', '2017-05-18 00:00:12', NULL, '3', '2017-03-21', NULL),
('1412', '12', '64', '10', '2017-05-18 00:00:25', NULL, '3', '2017-03-21', NULL),
('1413', '30', '327', '10', '2017-05-03 03:14:09', NULL, '2', '2016-09-30', '0'),
('1414', '13', '327', '10', '2017-05-03 03:14:09', NULL, '2', '2016-09-30', '0'),
('1415', '10', '330', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-30', '138'),
('1416', '1', '186', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '309'),
('1417', '1', '187', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '310'),
('1418', '1', '188', '10', '2018-03-06 23:12:07', NULL, '3', '2017-05-03', NULL),
('1419', '30', '328', '10', '2017-05-03 05:01:48', NULL, '2', '2016-08-22', '0'),
('1420', '13', '328', '10', '2017-05-03 05:01:49', NULL, '2', '2016-08-22', '0'),
('1421', '10', '331', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-22', '100'),
('1422', '30', '329', '10', '2017-05-03 05:02:56', NULL, '2', '2017-03-01', '0'),
('1423', '13', '329', '10', '2017-05-03 05:02:56', NULL, '2', '2017-03-01', '0'),
('1424', '10', '332', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-01', '372'),
('1425', '30', '330', '10', '2017-05-03 05:04:19', NULL, '2', '2017-02-14', '0'),
('1426', '13', '330', '10', '2017-05-03 05:04:19', NULL, '2', '2017-02-14', '0'),
('1427', '10', '333', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-14', '329'),
('1428', '30', '331', '10', '2017-05-03 05:06:01', NULL, '2', '2016-09-29', '0'),
('1429', '13', '331', '10', '2017-05-03 05:06:01', NULL, '2', '2016-09-29', '0'),
('1430', '10', '334', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-29', '135'),
('1431', '30', '332', '10', '2017-05-03 05:07:25', NULL, '2', '2016-12-30', '0'),
('1432', '13', '332', '10', '2017-05-03 05:07:25', NULL, '2', '2016-12-30', '0'),
('1433', '10', '335', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-30', '227'),
('1434', '30', '333', '10', '2017-05-03 05:08:47', NULL, '1', '2016-03-31', '0'),
('1435', '13', '333', '10', '2017-05-03 05:08:47', NULL, '1', '2016-03-31', '0'),
('1436', '10', '336', '10', '2018-02-05 04:47:11', NULL, '1', '2016-03-31', '80'),
('1437', '12', '65', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-03', '237'),
('1438', '30', '334', '10', '2017-05-03 05:22:03', NULL, '2', '2016-10-18', '0'),
('1439', '13', '334', '10', '2017-05-03 05:25:28', NULL, '3', '2016-10-18', NULL),
('1440', '10', '337', '10', '2017-05-03 05:25:28', NULL, '3', '2016-10-18', NULL),
('1441', '11', '14', '10', '2017-05-03 05:25:13', NULL, '3', '2016-10-18', NULL),
('1442', '11', '14', '10', '2017-05-03 05:25:13', 'Voided.\n', '3', '2017-05-03', '0'),
('1443', '13', '334', '10', '2017-05-03 05:25:28', 'Voided.', '3', '2017-05-03', '0'),
('1444', '10', '337', '10', '2017-05-03 05:25:28', 'Voided.\n', '3', '2017-05-03', '0'),
('1445', '30', '335', '10', '2017-05-03 05:27:02', NULL, '2', '2016-10-18', '0'),
('1446', '13', '335', '10', '2017-05-03 05:27:02', NULL, '2', '2016-10-18', '0'),
('1447', '10', '338', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-18', '152'),
('1448', '30', '336', '10', '2017-05-03 05:28:05', NULL, '2', '2016-07-15', '0'),
('1449', '13', '336', '10', '2017-05-03 05:28:05', NULL, '2', '2016-07-15', '0'),
('1450', '10', '339', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-15', '67'),
('1451', '30', '337', '10', '2017-05-03 05:29:19', NULL, '1', '2015-09-14', '0'),
('1452', '13', '337', '10', '2017-05-03 05:29:19', NULL, '1', '2015-09-14', '0'),
('1453', '10', '340', '10', '2018-01-04 00:46:27', NULL, '1', '2015-09-14', NULL),
('1454', '12', '66', '10', '2018-02-05 04:47:11', NULL, '1', '2015-10-02', '47'),
('1455', '12', '67', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-12', '64'),
('1456', '30', '338', '10', '2017-05-03 05:33:10', NULL, '2', '2017-03-29', '0'),
('1457', '13', '338', '10', '2017-05-03 05:33:10', NULL, '2', '2017-03-29', '0'),
('1458', '10', '341', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-29', '448'),
('1459', '30', '339', '10', '2017-05-03 05:35:01', NULL, '2', '2017-03-31', '0'),
('1460', '13', '339', '10', '2017-05-03 05:35:01', NULL, '2', '2017-03-31', '0'),
('1461', '10', '342', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '485'),
('1462', '30', '340', '10', '2017-05-03 05:37:39', NULL, '2', '2016-06-16', '0'),
('1463', '13', '340', '10', '2017-05-03 05:37:39', NULL, '2', '2016-06-16', '0'),
('1464', '10', '343', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-16', '42'),
('1465', '30', '341', '10', '2017-05-03 05:38:40', NULL, '2', '2016-07-20', '0'),
('1466', '13', '341', '10', '2017-05-03 05:38:40', NULL, '2', '2016-07-20', '0'),
('1467', '10', '344', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-20', '70'),
('1468', '30', '342', '10', '2017-05-03 05:39:36', NULL, '1', '2016-01-25', '0'),
('1469', '13', '342', '10', '2017-05-03 05:39:36', NULL, '1', '2016-01-25', '0'),
('1470', '10', '345', '10', '2018-02-05 04:47:11', NULL, '1', '2016-01-25', '56'),
('1471', '12', '68', '10', '2017-10-24 04:08:53', NULL, '2', '2016-10-05', NULL),
('1472', '30', '343', '10', '2017-05-03 05:42:03', NULL, '2', '2016-09-19', '0'),
('1473', '13', '343', '10', '2017-05-03 05:42:03', NULL, '2', '2016-09-19', '0'),
('1474', '10', '346', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-19', '124'),
('1475', '30', '344', '10', '2017-05-03 05:44:23', NULL, '2', '2017-01-26', '0'),
('1476', '13', '344', '10', '2017-05-03 05:44:23', NULL, '2', '2017-01-26', '0'),
('1477', '10', '347', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-26', '284'),
('1478', '30', '345', '10', '2017-05-03 05:45:24', NULL, '2', '2017-03-30', '0'),
('1479', '13', '345', '10', '2017-05-03 05:45:24', NULL, '2', '2017-03-30', '0'),
('1480', '10', '348', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '464'),
('1481', '30', '346', '10', '2017-05-03 05:47:00', NULL, '2', '2016-05-30', '0'),
('1482', '13', '346', '10', '2017-05-03 05:47:00', NULL, '2', '2016-05-30', '0'),
('1483', '10', '349', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-30', '27'),
('1484', '30', '347', '10', '2017-05-03 05:48:34', NULL, '2', '2017-01-20', '0'),
('1485', '13', '347', '10', '2017-05-03 05:48:34', NULL, '2', '2017-01-20', '0'),
('1486', '10', '350', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-20', '268'),
('1487', '30', '348', '10', '2017-05-03 05:49:44', NULL, '2', '2017-02-09', '0'),
('1488', '13', '348', '10', '2017-05-03 05:49:44', NULL, '2', '2017-02-09', '0'),
('1489', '10', '351', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-09', '317'),
('1490', '12', '69', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-20', '168'),
('1491', '12', '70', '10', '2017-10-24 04:17:56', NULL, '3', '2017-05-03', NULL),
('1492', '12', '71', '10', '2017-10-24 03:28:02', NULL, '3', '2017-05-03', NULL),
('1493', '12', '72', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '311'),
('1494', '12', '73', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '312'),
('1495', '12', '74', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '313'),
('1496', '12', '75', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '314'),
('1497', '1', '189', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '324'),
('1498', '1', '190', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '325'),
('1499', '1', '191', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '326'),
('1500', '1', '192', '10', '2018-03-07 00:46:13', NULL, '3', '2017-05-04', NULL),
('1501', '1', '193', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '327'),
('1502', '4', '6', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '328'),
('1503', '4', '7', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '329'),
('1504', '1', '194', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '330'),
('1505', '1', '195', '10', '2017-05-04 05:54:56', NULL, '3', '2017-05-04', NULL),
('1506', '1', '196', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-05', '344'),
('1507', '1', '197', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '331'),
('1508', '1', '195', '10', '2017-05-04 05:54:56', 'Voided.\nDocument reentered.', '3', '2017-05-04', '0'),
('1509', '1', '198', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '332'),
('1510', '1', '199', '10', '2018-03-07 00:07:57', NULL, '3', '2017-05-04', NULL),
('1511', '30', '349', '10', '2017-05-08 00:59:11', NULL, '3', '2017-04-28', '0'),
('1512', '13', '349', '10', '2017-05-08 00:59:11', NULL, '3', '2017-04-28', '0'),
('1513', '10', '352', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '266'),
('1514', '30', '350', '10', '2017-05-08 01:02:25', NULL, '3', '2017-04-28', '0'),
('1515', '13', '350', '10', '2017-05-08 01:02:25', NULL, '3', '2017-04-28', '0'),
('1516', '10', '353', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '267'),
('1517', '1', '200', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-08', '355'),
('1518', '1', '201', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-08', '356'),
('1519', '1', '202', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-08', '357'),
('1520', '1', '203', '10', '2017-05-08 02:20:26', NULL, '3', '2017-05-08', NULL),
('1521', '1', '204', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-02', '299'),
('1522', '1', '203', '10', '2017-05-08 02:20:26', 'Voided.\nDocument reentered.', '3', '2017-05-08', '0'),
('1523', '1', '205', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '268'),
('1524', '1', '206', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '315'),
('1525', '1', '207', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '316'),
('1526', '30', '351', '10', '2017-05-08 02:30:12', NULL, '2', '2017-03-30', '0'),
('1527', '13', '351', '10', '2017-05-08 02:30:12', NULL, '2', '2017-03-30', '0'),
('1528', '10', '354', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '465'),
('1529', '12', '76', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-05', '345'),
('1530', '1', '208', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-08', '358'),
('1531', '1', '209', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-08', '359'),
('1532', '1', '210', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-08', '360'),
('1533', '1', '211', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-08', '361'),
('1534', '4', '8', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-08', '362'),
('1535', '30', '352', '10', '2017-05-08 06:33:49', NULL, '3', '2017-05-08', '0'),
('1536', '13', '352', '10', '2018-03-17 04:13:05', NULL, '3', '2017-05-08', NULL),
('1537', '10', '355', '10', '2018-01-04 00:50:44', NULL, '3', '2017-05-08', NULL),
('1538', '1', '212', '10', '2018-01-04 03:36:20', NULL, '3', '2017-05-09', NULL),
('1539', '12', '77', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-09', '370'),
('1540', '12', '78', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-09', '371'),
('1541', '16', '1', '10', '2017-05-09 01:54:41', NULL, '3', '2017-05-05', '0'),
('1542', '1', '213', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-09', '372'),
('1543', '1', '214', '10', '2017-11-10 04:45:10', NULL, '3', '2017-05-09', NULL),
('1544', '30', '353', '10', '2017-05-09 05:20:25', NULL, '2', '2016-12-06', '0'),
('1545', '13', '353', '10', '2017-05-09 05:20:25', NULL, '2', '2016-12-06', '0'),
('1546', '10', '356', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-06', '186'),
('1547', '30', '354', '10', '2017-05-09 05:24:27', NULL, '2', '2017-02-28', '0'),
('1548', '13', '354', '10', '2017-05-09 05:24:27', NULL, '2', '2017-02-28', '0'),
('1549', '10', '357', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '365'),
('1550', '30', '355', '10', '2017-05-09 05:27:40', NULL, '2', '2017-01-30', '0'),
('1551', '13', '355', '10', '2017-05-09 05:27:40', NULL, '2', '2017-01-30', '0'),
('1552', '10', '358', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-30', '293'),
('1553', '30', '356', '10', '2017-05-09 05:29:43', NULL, '2', '2017-01-31', '0'),
('1554', '13', '356', '10', '2017-05-09 05:29:43', NULL, '2', '2017-01-31', '0'),
('1555', '10', '359', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-31', '299'),
('1556', '30', '357', '10', '2017-05-09 05:35:05', NULL, '2', '2016-12-07', '0'),
('1557', '13', '357', '10', '2017-05-09 05:35:05', NULL, '2', '2016-12-07', '0'),
('1558', '10', '360', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-07', '187'),
('1559', '30', '358', '10', '2017-05-09 05:45:08', NULL, '1', '2016-02-17', '0'),
('1560', '13', '358', '10', '2017-05-09 05:45:08', NULL, '1', '2016-02-17', '0'),
('1561', '10', '361', '10', '2018-02-05 04:47:11', NULL, '1', '2016-02-17', '64'),
('1562', '30', '359', '10', '2017-05-09 05:47:48', NULL, '2', '2017-02-01', '0'),
('1563', '13', '359', '10', '2017-05-09 05:47:48', NULL, '2', '2017-02-01', '0'),
('1564', '10', '362', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-01', '305'),
('1565', '30', '360', '10', '2017-05-09 05:48:35', NULL, '2', '2017-02-28', '0'),
('1566', '13', '360', '10', '2017-05-09 05:48:35', NULL, '2', '2017-02-28', '0'),
('1567', '10', '363', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '366'),
('1568', '30', '361', '10', '2017-05-09 05:52:39', NULL, '2', '2017-01-23', '0'),
('1569', '13', '361', '10', '2017-05-09 05:52:39', NULL, '2', '2017-01-23', '0'),
('1570', '10', '364', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-23', '275'),
('1571', '1', '215', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-12', '380'),
('1572', '1', '216', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-12', '381'),
('1573', '1', '217', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-12', '382'),
('1574', '30', '362', '10', '2017-05-12 02:34:07', NULL, '2', '2017-01-31', '0'),
('1575', '13', '362', '10', '2017-05-12 02:34:07', NULL, '2', '2017-01-31', '0'),
('1576', '10', '365', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-31', '300'),
('1577', '30', '363', '10', '2017-05-12 02:35:40', NULL, '2', '2017-03-27', '0'),
('1578', '13', '363', '10', '2017-05-12 02:35:40', NULL, '2', '2017-03-27', '0'),
('1579', '10', '366', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-27', '438'),
('1580', '1', '218', '10', '2018-03-06 23:13:01', NULL, '3', '2017-05-12', NULL),
('1581', '1', '219', '10', '2018-03-06 23:13:24', NULL, '3', '2017-05-12', NULL),
('1582', '1', '220', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-12', '383'),
('1583', '1', '221', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-12', '384'),
('1584', '30', '364', '10', '2017-05-14 23:58:26', NULL, '3', '2017-04-28', '0'),
('1585', '13', '364', '10', '2018-03-16 11:12:59', NULL, '3', '2017-04-28', NULL),
('1586', '10', '367', '10', '2017-05-15 00:04:58', NULL, '3', '2017-04-28', NULL),
('1587', '30', '365', '10', '2017-05-15 00:04:36', NULL, '3', '2017-04-28', '0'),
('1588', '13', '365', '10', '2017-05-15 00:04:37', NULL, '3', '2017-04-28', '0'),
('1589', '10', '368', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '269'),
('1590', '10', '367', '10', '2017-08-02 00:38:04', 'Updated.', '3', '2017-04-28', NULL),
('1591', '30', '366', '10', '2017-05-15 00:07:52', NULL, '2', '2017-02-28', '0'),
('1592', '13', '366', '10', '2017-05-15 00:07:52', NULL, '2', '2017-02-28', '0'),
('1593', '10', '369', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '367'),
('1594', '30', '367', '10', '2017-05-15 00:09:02', NULL, '2', '2017-03-31', '0'),
('1595', '13', '367', '10', '2017-05-15 00:09:02', NULL, '2', '2017-03-31', '0'),
('1596', '10', '370', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '486'),
('1597', '30', '368', '10', '2017-05-15 00:12:08', NULL, '2', '2016-12-31', '0'),
('1598', '13', '368', '10', '2017-05-15 00:12:08', NULL, '2', '2016-12-31', '0'),
('1599', '10', '371', '10', '2017-05-15 00:12:39', NULL, '2', '2016-12-31', NULL),
('1600', '10', '371', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2016-12-31', '230'),
('1601', '30', '369', '10', '2017-05-15 00:18:11', NULL, '2', '2017-03-31', '0'),
('1602', '13', '369', '10', '2017-05-15 00:18:11', NULL, '2', '2017-03-31', '0'),
('1603', '10', '372', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '487'),
('1604', '30', '370', '10', '2017-05-15 00:21:48', NULL, '2', '2016-11-30', '0'),
('1605', '13', '370', '10', '2017-05-15 00:21:48', NULL, '2', '2016-11-30', '0'),
('1606', '10', '373', '10', '2018-01-03 07:14:36', NULL, '2', '2016-11-30', NULL),
('1607', '30', '371', '10', '2017-05-15 00:23:17', NULL, '2', '2016-08-31', '0'),
('1608', '13', '371', '10', '2017-05-15 00:23:17', NULL, '2', '2016-08-31', '0'),
('1609', '10', '374', '10', '2018-01-03 07:14:51', NULL, '2', '2016-08-31', NULL),
('1610', '30', '372', '10', '2017-05-15 00:28:15', NULL, '2', '2016-11-30', '0'),
('1611', '13', '372', '10', '2017-05-15 00:28:16', NULL, '2', '2016-11-30', '0'),
('1612', '10', '375', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-30', '183'),
('1613', '30', '373', '10', '2017-05-15 00:30:14', NULL, '2', '2017-02-28', '0'),
('1614', '13', '373', '10', '2017-05-15 00:30:14', NULL, '2', '2017-02-28', '0'),
('1615', '10', '376', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '368'),
('1616', '1', '222', '10', '2018-01-04 03:36:57', NULL, '3', '2017-05-15', NULL),
('1617', '30', '374', '10', '2017-05-15 01:32:34', NULL, '3', '2017-04-21', '0'),
('1618', '13', '374', '10', '2017-05-15 01:32:34', NULL, '3', '2017-04-21', '0'),
('1619', '10', '377', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-21', '179'),
('1620', '30', '375', '10', '2017-05-15 01:33:24', NULL, '3', '2017-04-24', '0'),
('1621', '13', '375', '10', '2017-05-15 01:33:24', NULL, '3', '2017-04-24', '0'),
('1622', '10', '378', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-24', '196'),
('1623', '30', '376', '10', '2017-05-15 01:35:07', NULL, '3', '2017-04-25', '0'),
('1624', '13', '376', '10', '2017-05-15 01:35:07', NULL, '3', '2017-04-25', '0'),
('1625', '10', '379', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-25', '211'),
('1626', '30', '377', '10', '2017-05-15 01:36:02', NULL, '3', '2017-04-25', '0'),
('1627', '13', '377', '10', '2017-05-15 01:36:02', NULL, '3', '2017-04-25', '0'),
('1628', '10', '380', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-25', '212'),
('1629', '30', '378', '10', '2017-05-15 01:37:19', NULL, '3', '2017-04-26', '0'),
('1630', '13', '378', '10', '2017-05-15 01:37:19', NULL, '3', '2017-04-26', '0'),
('1631', '10', '381', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-26', '218'),
('1632', '30', '379', '10', '2017-05-15 01:38:31', NULL, '3', '2017-04-28', '0'),
('1633', '13', '379', '10', '2017-05-15 01:38:31', NULL, '3', '2017-04-28', '0'),
('1634', '10', '382', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '270'),
('1635', '30', '380', '10', '2017-05-15 01:39:27', NULL, '3', '2017-04-28', '0'),
('1636', '13', '380', '10', '2017-05-15 01:39:27', NULL, '3', '2017-04-28', '0'),
('1637', '10', '383', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '271'),
('1638', '30', '381', '10', '2017-05-15 01:40:33', NULL, '3', '2017-04-30', '0'),
('1639', '13', '381', '10', '2017-05-15 01:40:33', NULL, '3', '2017-04-30', '0'),
('1640', '10', '384', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-30', '283'),
('1641', '1', '223', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '389'),
('1642', '30', '382', '10', '2017-05-15 02:13:14', NULL, '3', '2017-04-30', '0'),
('1643', '13', '382', '10', '2017-05-15 02:13:14', NULL, '3', '2017-04-30', '0'),
('1644', '10', '385', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-30', '284'),
('1645', '30', '383', '10', '2017-05-15 02:25:40', NULL, '3', '2017-05-03', '0'),
('1646', '13', '383', '10', '2017-05-15 02:25:40', NULL, '3', '2017-05-03', '0'),
('1647', '10', '386', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '317'),
('1648', '30', '384', '10', '2017-05-15 02:26:31', NULL, '3', '2017-05-05', '0'),
('1649', '13', '384', '10', '2017-05-15 02:27:41', NULL, '3', '2017-05-05', NULL),
('1650', '10', '387', '10', '2017-05-15 02:27:41', NULL, '3', '2017-05-05', NULL),
('1651', '13', '384', '10', '2017-05-15 02:27:41', 'Voided.', '3', '2017-05-15', '0'),
('1652', '10', '387', '10', '2017-05-15 02:27:41', 'Voided.\nWrong Customer.Voided by Dilrukshi', '3', '2017-05-15', '0'),
('1653', '30', '385', '10', '2017-05-15 02:30:19', NULL, '3', '2017-05-05', '0'),
('1654', '13', '385', '10', '2017-05-15 02:30:19', NULL, '3', '2017-05-05', '0'),
('1655', '10', '388', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-05', '346'),
('1656', '30', '386', '10', '2017-05-15 02:32:25', NULL, '3', '2017-05-05', '0'),
('1657', '13', '386', '10', '2017-05-15 02:32:25', NULL, '3', '2017-05-05', '0'),
('1658', '10', '389', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-05', '347'),
('1659', '30', '387', '10', '2017-05-15 02:33:11', NULL, '3', '2017-05-05', '0'),
('1660', '13', '387', '10', '2017-05-15 02:33:11', NULL, '3', '2017-05-05', '0'),
('1661', '10', '390', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-05', '348'),
('1662', '30', '388', '10', '2017-05-15 02:34:02', NULL, '3', '2017-05-08', '0'),
('1663', '13', '388', '10', '2017-05-15 02:34:02', NULL, '3', '2017-05-08', '0'),
('1664', '10', '391', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-08', '363'),
('1665', '30', '389', '10', '2017-05-15 02:35:56', NULL, '3', '2017-05-08', '0'),
('1666', '13', '389', '10', '2017-05-15 02:35:56', NULL, '3', '2017-05-08', '0'),
('1667', '10', '392', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-08', '364'),
('1668', '30', '390', '10', '2017-05-15 02:36:44', NULL, '3', '2017-05-09', '0'),
('1669', '13', '390', '10', '2017-05-15 02:36:44', NULL, '3', '2017-05-09', '0'),
('1670', '10', '393', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-09', '373'),
('1671', '20', '2', '10', '2017-05-15 02:48:23', NULL, '3', '2017-05-15', NULL),
('1672', '20', '3', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '243'),
('1673', '20', '4', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-18', '149'),
('1674', '20', '2', '10', '2017-05-15 02:48:23', 'Voided.\nDocument reentered.', '3', '2017-05-15', '0'),
('1675', '20', '5', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-05', '349'),
('1676', '22', '3', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '390'),
('1677', '20', '6', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '318'),
('1678', '20', '7', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-04', '10'),
('1679', '22', '4', '10', '2017-05-15 03:09:04', NULL, '3', '2017-04-04', NULL),
('1680', '1', '224', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '391'),
('1681', '1', '225', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '392'),
('1682', '4', '9', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '393'),
('1683', '22', '4', '10', '2017-05-15 03:09:04', 'Voided.\n', '3', '2017-05-15', '0'),
('1684', '22', '5', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '394'),
('1685', '1', '226', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '395'),
('1686', '4', '10', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '396'),
('1687', '1', '227', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '397'),
('1688', '10', '301', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-03-16', '409'),
('1689', '12', '79', '10', '2018-03-20 05:41:22', NULL, '3', '2017-05-15', NULL),
('1690', '1', '228', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '398'),
('1691', '30', '391', '10', '2017-05-16 00:13:38', NULL, '3', '2017-04-20', '0'),
('1692', '13', '391', '10', '2017-05-16 00:13:39', NULL, '3', '2017-04-20', '0'),
('1693', '10', '394', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-20', '169'),
('1694', '30', '392', '10', '2017-05-16 00:18:17', NULL, '3', '2017-04-08', '0'),
('1695', '13', '392', '10', '2017-05-16 00:22:33', NULL, '3', '2017-04-08', NULL),
('1696', '10', '395', '10', '2017-05-16 00:22:33', NULL, '3', '2017-04-08', NULL),
('1697', '30', '393', '10', '2017-05-16 00:21:22', NULL, '3', '2017-04-28', '0'),
('1698', '13', '393', '10', '2017-05-16 00:21:22', NULL, '3', '2017-04-28', '0'),
('1699', '10', '396', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '272'),
('1700', '13', '392', '10', '2017-05-16 00:22:33', 'Voided.', '3', '2017-05-16', '0'),
('1701', '10', '395', '10', '2017-05-16 00:22:33', 'Voided.\nWrong Item Entered.Voided by Dilrukshi', '3', '2017-05-16', '0'),
('1702', '30', '394', '10', '2017-05-16 00:23:33', NULL, '3', '2017-04-18', '0'),
('1703', '13', '394', '10', '2017-05-16 00:23:33', NULL, '3', '2017-04-18', '0'),
('1704', '10', '397', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-18', '150'),
('1705', '30', '395', '10', '2017-05-16 00:25:50', NULL, '3', '2017-04-28', '0'),
('1706', '13', '395', '10', '2017-05-16 00:25:50', NULL, '3', '2017-04-28', '0'),
('1707', '10', '398', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '273'),
('1708', '1', '229', '10', '2018-03-06 23:14:19', NULL, '3', '2017-05-16', NULL),
('1709', '1', '230', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-16', '408'),
('1710', '1', '231', '10', '2018-03-06 23:14:58', NULL, '3', '2017-05-16', NULL),
('1711', '30', '396', '10', '2017-05-16 02:04:11', NULL, '3', '2017-05-16', '0'),
('1712', '13', '396', '10', '2017-05-16 02:04:11', NULL, '3', '2017-05-16', '0'),
('1713', '10', '399', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-16', '409'),
('1714', '30', '397', '10', '2017-05-16 02:08:10', NULL, '3', '2017-05-16', '0'),
('1715', '13', '397', '10', '2017-05-16 02:08:10', NULL, '3', '2017-05-16', '0'),
('1716', '10', '400', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-16', '410'),
('1717', '1', '232', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-16', '411'),
('1718', '2', '54', '10', '2017-05-16 02:26:01', NULL, '3', '2017-05-16', NULL),
('1719', '2', '54', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-16', '412'),
('1720', '2', '39', '10', '2017-05-16 02:26:01', 'Voided.\nDocument reentered.', '3', '2017-05-16', '0'),
('1721', '1', '233', '10', '2018-01-08 00:10:17', NULL, '3', '2017-05-06', NULL),
('1722', '30', '398', '10', '2017-05-16 03:44:15', NULL, '2', '2017-02-27', '0'),
('1723', '13', '398', '10', '2017-05-16 03:44:15', NULL, '2', '2017-02-27', '0'),
('1724', '10', '401', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-27', '352'),
('1725', '30', '399', '10', '2017-05-17 02:44:26', NULL, '2', '2017-02-13', '0'),
('1726', '13', '399', '10', '2017-05-17 02:44:26', NULL, '2', '2017-02-13', '0'),
('1727', '10', '402', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-13', '325'),
('1728', '30', '400', '10', '2017-05-17 02:46:42', NULL, '2', '2016-05-20', '0'),
('1729', '13', '400', '10', '2017-05-17 02:46:42', NULL, '2', '2016-05-20', '0'),
('1730', '10', '403', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-20', '20'),
('1731', '30', '401', '10', '2017-05-17 02:48:42', NULL, '1', '2016-01-28', '0'),
('1732', '13', '401', '10', '2017-05-17 02:48:42', NULL, '1', '2016-01-28', '0'),
('1733', '10', '404', '10', '2018-02-05 04:47:11', NULL, '1', '2016-01-28', '57'),
('1734', '12', '80', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-17', '260'),
('1735', '1', '234', '10', '2017-05-17 03:48:48', NULL, '3', '2017-04-17', NULL),
('1736', '1', '235', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-17', '418'),
('1737', '1', '234', '10', '2017-05-17 03:48:48', 'Voided.\nDocument reentered.', '3', '2017-05-17', '0'),
('1738', '1', '236', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-17', '419'),
('1739', '1', '237', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-17', '420'),
('1740', '1', '238', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-17', '421'),
('1741', '1', '239', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-17', '422'),
('1742', '12', '63', '10', '2017-05-18 00:00:12', 'Voided.\n', '3', '2017-05-17', '0'),
('1743', '12', '64', '10', '2017-05-18 00:00:25', 'Voided.\n', '3', '2017-05-18', '0'),
('1744', '13', '325', '10', '2017-05-18 00:01:38', 'Voided.', '3', '2017-05-18', '0'),
('1745', '10', '328', '10', '2017-05-18 00:01:38', 'Voided.\n', '3', '2017-05-18', '0'),
('1746', '4', '11', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-18', '427'),
('1747', '30', '402', '10', '2017-05-18 00:35:18', NULL, '2', '2017-01-31', '0'),
('1748', '13', '402', '10', '2017-05-18 00:35:18', NULL, '2', '2017-01-31', '0'),
('1749', '10', '405', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-31', '301'),
('1750', '12', '81', '10', '2017-07-16 23:42:52', NULL, '3', '2017-05-17', NULL),
('1751', '12', '82', '10', '2017-07-05 01:27:46', NULL, '3', '2017-05-22', NULL),
('1752', '30', '403', '10', '2017-05-18 00:55:46', NULL, '2', '2016-04-20', '0'),
('1753', '13', '403', '10', '2017-05-18 00:55:46', NULL, '2', '2016-04-20', '0'),
('1754', '10', '406', '10', '2019-11-05 05:45:21', NULL, '2', '2016-04-20', '7'),
('1755', '12', '83', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-20', '203'),
('1756', '12', '84', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-03', '238'),
('1757', '1', '240', '10', '2017-05-18 01:05:00', NULL, '3', '2017-01-03', NULL),
('1758', '1', '241', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-18', '428'),
('1759', '1', '240', '10', '2017-05-18 01:05:00', 'Voided.\nDocument reentered.', '3', '2017-05-18', '0'),
('1760', '30', '404', '10', '2017-05-18 01:08:05', NULL, '2', '2016-05-03', '0'),
('1761', '13', '404', '10', '2017-05-18 01:08:05', NULL, '2', '2016-05-03', '0'),
('1762', '10', '407', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-03', '9'),
('1763', '11', '15', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-25', '179'),
('1764', '30', '405', '10', '2017-05-18 01:20:55', NULL, '2', '2017-03-24', '0'),
('1765', '13', '405', '10', '2017-05-18 01:20:56', NULL, '2', '2017-03-24', '0'),
('1766', '10', '408', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-24', '430'),
('1767', '30', '406', '10', '2017-05-18 01:22:24', NULL, '3', '2017-04-05', '0'),
('1768', '13', '406', '10', '2018-03-16 10:18:17', NULL, '3', '2017-04-05', NULL),
('1769', '10', '409', '10', '2018-01-04 01:14:29', NULL, '3', '2017-04-05', NULL),
('1770', '30', '407', '10', '2017-05-18 01:23:27', NULL, '3', '2017-04-05', '0'),
('1771', '13', '407', '10', '2018-03-16 10:18:27', NULL, '3', '2017-04-05', NULL),
('1772', '10', '410', '10', '2018-01-04 01:14:41', NULL, '3', '2017-04-05', NULL),
('1773', '30', '408', '10', '2017-05-18 01:26:01', NULL, '3', '2017-04-07', '0'),
('1774', '13', '408', '10', '2018-03-16 10:41:42', NULL, '3', '2017-04-07', NULL),
('1775', '10', '411', '10', '2018-01-04 00:41:59', NULL, '3', '2017-04-07', NULL),
('1776', '30', '409', '10', '2017-05-18 02:50:47', NULL, '3', '2017-05-01', '0'),
('1777', '13', '409', '10', '2017-05-18 03:29:04', NULL, '3', '2017-05-01', NULL),
('1778', '10', '412', '10', '2017-05-18 03:29:04', NULL, '3', '2017-05-01', NULL),
('1779', '13', '409', '10', '2017-05-18 03:29:04', 'Voided.', '3', '2017-05-18', '0'),
('1780', '10', '412', '10', '2017-05-18 03:29:04', 'Voided.\nEntered two Times.Voided by Dilrukshi', '3', '2017-05-18', '0'),
('1781', '12', '85', '10', '2018-01-08 05:30:59', NULL, '3', '2017-05-18', NULL),
('1782', '30', '410', '10', '2017-05-18 03:38:20', NULL, '3', '2017-05-18', '0'),
('1783', '13', '410', '10', '2018-01-25 05:07:07', NULL, '3', '2017-05-18', NULL),
('1784', '10', '413', '10', '2017-05-18 03:39:08', NULL, '3', '2017-05-18', NULL),
('1785', '10', '413', '10', '2018-01-25 05:07:07', 'Updated.', '3', '2017-05-17', NULL),
('1786', '30', '411', '10', '2017-05-18 03:49:57', NULL, '3', '2017-05-18', '0'),
('1787', '13', '411', '10', '2017-05-18 03:49:57', NULL, '3', '2017-05-18', '0'),
('1788', '10', '414', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-18', '429'),
('1789', '1', '242', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-18', '430'),
('1790', '1', '243', '10', '2017-05-18 06:13:46', NULL, '3', '2017-05-18', NULL),
('1791', '1', '244', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-18', '431'),
('1792', '1', '243', '10', '2017-05-18 06:13:46', 'Voided.\nDocument reentered.', '3', '2017-05-18', '0'),
('1793', '1', '245', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '436'),
('1794', '1', '246', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '437'),
('1795', '1', '247', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '438'),
('1796', '1', '248', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '439'),
('1797', '1', '249', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '440'),
('1798', '1', '250', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '441'),
('1799', '1', '251', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '442'),
('1800', '1', '252', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '443'),
('1801', '1', '253', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '444'),
('1802', '1', '254', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '445'),
('1803', '1', '255', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '446'),
('1804', '1', '256', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-09', '374'),
('1805', '1', '257', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-09', '375'),
('1806', '1', '258', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-08', '365'),
('1807', '1', '259', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '399'),
('1808', '1', '260', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-30', '285'),
('1809', '1', '261', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-30', '286'),
('1810', '1', '262', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-30', '287'),
('1811', '1', '263', '10', '2018-03-07 00:42:18', NULL, '3', '2017-04-30', NULL),
('1812', '1', '264', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-22', '459'),
('1813', '30', '412', '10', '2017-05-22 01:51:30', NULL, '3', '2017-04-28', '0'),
('1814', '13', '412', '10', '2017-05-22 01:51:30', NULL, '3', '2017-04-28', '0'),
('1815', '10', '415', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '274'),
('1816', '4', '12', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-22', '460'),
('1817', '30', '413', '10', '2017-05-22 02:35:32', NULL, '3', '2017-05-22', '0'),
('1818', '13', '413', '10', '2017-05-24 02:43:24', NULL, '3', '2017-05-22', NULL),
('1819', '10', '416', '10', '2017-05-22 02:36:34', NULL, '3', '2017-05-22', NULL),
('1820', '10', '416', '10', '2017-05-22 03:57:15', 'Updated.', '3', '2017-05-22', NULL),
('1821', '30', '414', '10', '2017-05-22 02:49:37', NULL, '3', '2017-05-22', '0'),
('1822', '13', '414', '10', '2018-01-25 05:06:16', NULL, '3', '2017-05-22', NULL),
('1823', '10', '417', '10', '2018-01-25 05:06:16', NULL, '3', '2017-05-22', NULL),
('1824', '10', '416', '10', '2017-05-22 03:59:13', 'Updated.', '3', '2017-05-22', NULL),
('1825', '10', '416', '10', '2017-05-24 02:31:09', 'Updated.', '3', '2017-05-22', NULL),
('1826', '1', '265', '10', '2018-03-07 00:08:32', NULL, '3', '2017-05-22', NULL),
('1827', '1', '266', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-22', '461'),
('1828', '1', '267', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-22', '462'),
('1829', '1', '268', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-22', '463'),
('1830', '1', '269', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-23', '468'),
('1831', '1', '270', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-23', '469'),
('1832', '30', '415', '10', '2017-05-23 05:26:33', NULL, '3', '2017-05-23', '0'),
('1833', '13', '415', '10', '2017-05-23 05:26:33', NULL, '3', '2017-05-23', '0'),
('1834', '10', '418', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-23', '470'),
('1835', '1', '271', '10', '2018-03-07 00:08:58', NULL, '3', '2017-05-23', NULL),
('1836', '1', '272', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-23', '471'),
('1837', '10', '416', '10', '2017-05-24 02:32:52', 'Updated.', '3', '2017-05-22', NULL),
('1838', '10', '416', '10', '2017-05-24 02:43:24', 'Updated.', '3', '2017-05-22', NULL),
('1839', '30', '416', '10', '2017-05-24 02:33:21', NULL, '3', '2017-05-23', '0'),
('1840', '13', '416', '10', '2017-05-24 02:37:23', NULL, '3', '2017-05-23', NULL),
('1841', '10', '419', '10', '2017-05-24 02:37:23', NULL, '3', '2017-05-23', NULL),
('1842', '30', '417', '10', '2017-05-24 02:35:26', NULL, '3', '2017-05-22', '0'),
('1843', '13', '417', '10', '2017-05-24 02:36:53', NULL, '3', '2017-05-22', NULL),
('1844', '10', '420', '10', '2017-05-24 02:36:53', NULL, '3', '2017-05-22', NULL),
('1845', '13', '417', '10', '2017-05-24 02:36:53', 'Voided.', '3', '2017-05-24', '0'),
('1846', '10', '420', '10', '2017-05-24 02:36:53', 'Voided.\n', '3', '2017-05-24', '0'),
('1847', '13', '416', '10', '2017-05-24 02:37:23', 'Voided.', '3', '2017-05-24', '0'),
('1848', '10', '419', '10', '2017-05-24 02:37:23', 'Voided.\n', '3', '2017-05-24', '0'),
('1849', '30', '418', '10', '2017-05-24 02:39:56', NULL, '3', '2017-05-22', '0'),
('1850', '13', '418', '10', '2017-05-25 01:04:34', NULL, '3', '2017-05-22', NULL),
('1851', '10', '421', '10', '2017-05-25 01:04:34', NULL, '3', '2017-05-22', NULL),
('1852', '13', '413', '10', '2017-05-24 02:43:24', 'Voided.', '3', '2017-05-24', '0'),
('1853', '10', '416', '10', '2017-05-24 02:43:24', 'Voided.\n', '3', '2017-05-24', '0'),
('1854', '1', '273', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-24', '477'),
('1855', '1', '274', '10', '2017-06-07 02:55:07', NULL, '3', '2017-05-24', NULL),
('1856', '1', '275', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-24', '478'),
('1857', '30', '419', '10', '2017-05-24 23:41:57', NULL, '3', '2017-05-25', '0'),
('1858', '13', '419', '10', '2017-05-30 02:14:13', NULL, '3', '2017-05-25', NULL),
('1859', '10', '422', '10', '2017-05-30 02:14:13', NULL, '3', '2017-05-25', NULL),
('1860', '30', '420', '10', '2017-05-24 23:46:37', NULL, '3', '2017-05-25', '0'),
('1861', '13', '420', '10', '2017-05-24 23:46:37', NULL, '3', '2017-05-25', '0'),
('1862', '10', '423', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-25', '492'),
('1863', '30', '421', '10', '2017-05-25 01:03:24', NULL, '3', '2017-05-25', '0'),
('1864', '13', '421', '10', '2017-06-06 04:27:59', NULL, '3', '2017-05-25', NULL),
('1865', '10', '424', '10', '2017-06-06 04:27:59', NULL, '3', '2017-05-25', NULL),
('1866', '13', '418', '10', '2017-05-25 01:04:34', 'Voided.', '3', '2017-05-25', '0'),
('1867', '10', '421', '10', '2017-05-25 01:04:34', 'Voided.\n', '3', '2017-05-25', '0'),
('1868', '1', '276', '10', '2018-08-08 05:59:38', NULL, '5', '2017-05-25', NULL),
('1869', '30', '422', '10', '2017-05-25 02:21:55', NULL, '3', '2017-05-25', '0'),
('1870', '13', '422', '10', '2017-05-25 02:21:55', NULL, '3', '2017-05-25', '0'),
('1871', '10', '425', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-25', '493'),
('1872', '1', '277', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-25', '494'),
('1873', '1', '278', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-25', '495'),
('1874', '1', '279', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-25', '496'),
('1875', '1', '280', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-25', '497'),
('1876', '1', '281', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '447'),
('1877', '1', '282', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-25', '498'),
('1878', '1', '283', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '508'),
('1879', '1', '284', '10', '2017-05-26 02:27:43', NULL, '3', '2017-05-26', NULL),
('1880', '1', '285', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '509'),
('1881', '1', '286', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '510'),
('1882', '1', '287', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '511'),
('1883', '1', '288', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '512'),
('1884', '1', '289', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '513'),
('1885', '1', '290', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '514'),
('1886', '1', '284', '10', '2017-05-26 02:27:43', 'Voided.\nDocument reentered.', '3', '2017-05-26', '0'),
('1887', '1', '291', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '515'),
('1888', '1', '292', '10', '2017-06-01 04:48:20', NULL, '3', '2017-05-26', NULL),
('1889', '12', '86', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '516'),
('1890', '1', '293', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '517'),
('1891', '1', '294', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '518');
INSERT INTO `0_audit_trail` VALUES
('1892', '1', '295', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-29', '542'),
('1893', '30', '423', '10', '2017-05-29 03:28:40', NULL, '3', '2017-05-09', '0'),
('1894', '13', '423', '10', '2017-05-29 03:28:40', NULL, '3', '2017-05-09', '0'),
('1895', '10', '426', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-09', '376'),
('1896', '30', '424', '10', '2017-05-29 03:35:19', NULL, '3', '2017-05-16', '0'),
('1897', '13', '424', '10', '2017-05-29 03:35:19', NULL, '3', '2017-05-16', '0'),
('1898', '10', '427', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-16', '413'),
('1899', '30', '425', '10', '2017-05-29 03:38:22', NULL, '3', '2017-05-16', '0'),
('1900', '13', '425', '10', '2017-05-29 03:38:22', NULL, '3', '2017-05-16', '0'),
('1901', '10', '428', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-16', '414'),
('1902', '30', '426', '10', '2017-05-29 03:39:44', NULL, '3', '2017-05-23', '0'),
('1903', '13', '426', '10', '2017-05-29 03:39:44', NULL, '3', '2017-05-23', '0'),
('1904', '10', '429', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-23', '472'),
('1905', '30', '427', '10', '2017-05-29 03:40:56', NULL, '3', '2017-05-24', '0'),
('1906', '13', '427', '10', '2017-05-29 03:40:56', NULL, '3', '2017-05-24', '0'),
('1907', '10', '430', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-24', '479'),
('1908', '30', '428', '10', '2017-05-29 03:42:55', NULL, '3', '2017-05-24', '0'),
('1909', '13', '428', '10', '2017-05-29 03:42:55', NULL, '3', '2017-05-24', '0'),
('1910', '10', '431', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-24', '480'),
('1911', '30', '429', '10', '2017-05-29 03:45:33', NULL, '3', '2017-05-25', '0'),
('1912', '13', '429', '10', '2017-05-29 03:45:33', NULL, '3', '2017-05-25', '0'),
('1913', '10', '432', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-25', '499'),
('1914', '30', '430', '10', '2017-05-29 03:47:38', NULL, '3', '2017-05-25', '0'),
('1915', '13', '430', '10', '2017-05-29 03:47:38', NULL, '3', '2017-05-25', '0'),
('1916', '10', '433', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-25', '500'),
('1917', '30', '431', '10', '2017-05-29 03:48:55', NULL, '3', '2017-05-25', '0'),
('1918', '13', '431', '10', '2017-05-29 03:48:55', NULL, '3', '2017-05-25', '0'),
('1919', '10', '434', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-25', '501'),
('1920', '30', '432', '10', '2017-05-29 03:50:02', NULL, '3', '2017-05-25', '0'),
('1921', '13', '432', '10', '2017-05-29 03:50:02', NULL, '3', '2017-05-25', '0'),
('1922', '10', '435', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-25', '502'),
('1923', '30', '433', '10', '2017-05-29 03:51:13', NULL, '3', '2017-05-25', '0'),
('1924', '13', '433', '10', '2017-05-29 03:51:13', NULL, '3', '2017-05-25', '0'),
('1925', '10', '436', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-25', '503'),
('1926', '30', '434', '10', '2017-05-29 04:25:05', NULL, '2', '2016-12-28', '0'),
('1927', '13', '434', '10', '2017-05-29 04:25:05', NULL, '2', '2016-12-28', '0'),
('1928', '10', '437', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-28', '211'),
('1929', '12', '87', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '448'),
('1930', '12', '88', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-18', '151'),
('1931', '12', '89', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '519'),
('1932', '12', '90', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '520'),
('1933', '12', '91', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '521'),
('1934', '12', '92', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '560'),
('1935', '1', '296', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-30', '549'),
('1936', '1', '297', '10', '2017-05-30 01:38:54', NULL, '3', '2017-05-30', NULL),
('1937', '1', '298', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-30', '550'),
('1938', '1', '297', '10', '2017-05-30 01:38:54', 'Voided.\nDocument reentered.', '3', '2017-05-30', '0'),
('1939', '13', '419', '10', '2017-05-30 02:14:13', 'Voided.', '3', '2017-05-30', '0'),
('1940', '10', '422', '10', '2017-05-30 02:14:13', 'Voided.\nVoided by Dilrukshi.Items entered wrongly\n', '3', '2017-05-30', '0'),
('1941', '30', '435', '10', '2017-05-30 02:16:27', NULL, '3', '2017-05-26', '0'),
('1942', '13', '435', '10', '2017-05-30 02:16:27', NULL, '3', '2017-05-26', '0'),
('1943', '10', '438', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '522'),
('1944', '30', '436', '10', '2017-05-30 02:17:59', NULL, '3', '2017-05-30', '0'),
('1945', '13', '436', '10', '2017-05-30 02:17:59', NULL, '3', '2017-05-30', '0'),
('1946', '10', '439', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-30', '551'),
('1947', '1', '299', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-30', '552'),
('1948', '12', '93', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-02', '300'),
('1949', '1', '300', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-30', '553'),
('1950', '1', '301', '10', '2018-03-06 23:16:09', NULL, '3', '2017-05-30', NULL),
('1951', '1', '302', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-30', '554'),
('1952', '1', '303', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-30', '555'),
('1953', '12', '94', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '523'),
('1954', '12', '95', '10', '2017-10-24 04:41:31', NULL, '3', '2017-05-26', NULL),
('1955', '12', '96', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '524'),
('1956', '12', '97', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '525'),
('1957', '12', '98', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '333'),
('1958', '12', '99', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '334'),
('1959', '11', '16', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '335'),
('1960', '12', '100', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-03', '239'),
('1961', '12', '101', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '336'),
('1962', '11', '17', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '337'),
('1963', '12', '102', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '338'),
('1964', '12', '103', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '339'),
('1965', '12', '104', '10', '2017-10-19 04:05:27', NULL, '3', '2017-05-24', NULL),
('1966', '12', '105', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-24', '481'),
('1967', '12', '106', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-24', '482'),
('1968', '12', '107', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-24', '483'),
('1969', '12', '108', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-24', '484'),
('1970', '11', '18', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-24', '485'),
('1971', '11', '19', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-24', '486'),
('1972', '11', '20', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-24', '487'),
('1973', '11', '21', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-24', '488'),
('1974', '12', '109', '10', '2017-10-19 04:16:42', NULL, '3', '2017-05-29', NULL),
('1975', '1', '304', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '561'),
('1976', '1', '305', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '562'),
('1977', '1', '306', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '563'),
('1978', '12', '110', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '564'),
('1979', '1', '307', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '565'),
('1980', '4', '13', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-29', '543'),
('1981', '30', '437', '10', '2017-05-31 04:30:29', NULL, '3', '2017-04-20', '0'),
('1982', '13', '437', '10', '2018-03-16 10:57:45', NULL, '3', '2017-04-20', NULL),
('1983', '10', '440', '10', '2018-01-04 00:42:44', NULL, '3', '2017-04-20', NULL),
('1984', '12', '111', '10', '2018-01-04 04:35:29', NULL, '3', '2017-06-01', NULL),
('1985', '1', '308', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '526'),
('1986', '1', '292', '10', '2017-06-01 04:48:20', 'Voided.\nDocument reentered.', '3', '2017-06-01', '0'),
('1987', '1', '309', '10', '2017-06-01 05:46:54', NULL, '3', '2017-05-26', NULL),
('1988', '1', '310', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-01', '582'),
('1989', '1', '309', '10', '2017-06-01 05:46:54', 'Voided.\nDocument reentered.', '3', '2017-06-01', '0'),
('1990', '1', '311', '10', '2018-03-07 00:12:18', NULL, '3', '2017-06-02', NULL),
('1991', '1', '312', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '593'),
('1992', '1', '313', '10', '2017-06-02 01:28:28', NULL, '3', '2017-06-02', NULL),
('1993', '1', '314', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '594'),
('1994', '1', '315', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '595'),
('1995', '1', '316', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '596'),
('1996', '1', '317', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '597'),
('1997', '1', '313', '10', '2017-06-02 01:28:28', 'Voided.\nDocument reentered.', '3', '2017-06-02', '0'),
('1998', '1', '318', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '598'),
('1999', '1', '319', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '599'),
('2000', '1', '95', '10', '2017-06-02 03:45:15', 'Voided.\nDocument reentered.', '3', '2017-06-02', '0'),
('2001', '12', '112', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '600'),
('2002', '1', '320', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '601'),
('2003', '1', '321', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-05', '612'),
('2004', '1', '322', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-05', '613'),
('2005', '1', '323', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-05', '614'),
('2006', '1', '324', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-05', '615'),
('2007', '1', '325', '10', '2018-01-08 00:23:59', NULL, '3', '2017-06-05', NULL),
('2008', '1', '326', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-05', '616'),
('2009', '1', '327', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-05', '617'),
('2010', '12', '113', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-05', '618'),
('2011', '12', '114', '10', '2017-10-24 04:13:31', NULL, '3', '2017-06-12', NULL),
('2012', '12', '115', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-05', '619'),
('2013', '12', '116', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-01', '583'),
('2014', '12', '117', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-01', '584'),
('2015', '12', '118', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-01', '585'),
('2016', '12', '119', '10', '2017-10-24 03:50:15', NULL, '3', '2017-06-01', NULL),
('2017', '12', '120', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-01', '586'),
('2018', '12', '121', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-19', '695'),
('2019', '12', '122', '10', '2017-10-19 01:27:27', NULL, '3', '2017-06-09', NULL),
('2020', '12', '123', '10', '2018-01-12 00:42:48', NULL, '3', '2017-06-20', NULL),
('2021', '12', '124', '10', '2017-10-19 01:24:33', NULL, '3', '2017-07-21', NULL),
('2022', '12', '125', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '602'),
('2023', '12', '126', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '603'),
('2024', '2', '55', '10', '2017-06-05 04:29:33', NULL, '3', '2017-06-02', NULL),
('2025', '2', '55', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '604'),
('2026', '2', '44', '10', '2017-06-05 04:29:34', 'Voided.\nDocument reentered.', '3', '2017-06-05', '0'),
('2027', '16', '2', '10', '2017-06-05 04:39:02', NULL, '3', '2017-06-02', '0'),
('2028', '16', '3', '10', '2017-06-05 04:39:58', NULL, '3', '2017-06-02', '0'),
('2029', '30', '438', '10', '2017-06-05 06:22:25', NULL, '3', '2017-06-02', '0'),
('2030', '13', '438', '10', '2017-06-05 06:22:25', NULL, '3', '2017-06-02', '0'),
('2031', '10', '441', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '605'),
('2032', '30', '439', '10', '2017-06-05 06:22:54', NULL, '3', '2017-06-02', '0'),
('2033', '13', '439', '10', '2017-06-05 06:22:54', NULL, '3', '2017-06-02', '0'),
('2034', '10', '442', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '606'),
('2035', '12', '127', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '607'),
('2036', '30', '440', '10', '2017-06-06 03:05:22', NULL, '3', '2017-05-05', '0'),
('2037', '13', '440', '10', '2017-06-06 03:05:22', NULL, '3', '2017-05-05', '0'),
('2038', '10', '443', '10', '2018-01-04 00:47:29', NULL, '3', '2017-05-05', NULL),
('2039', '12', '128', '10', '2017-06-06 03:07:02', NULL, '3', '2017-06-06', NULL),
('2040', '12', '128', '10', '2018-01-08 05:18:13', 'Updated.', '3', '2017-06-06', NULL),
('2041', '12', '129', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-06', '624'),
('2042', '1', '328', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-06', '625'),
('2043', '30', '441', '10', '2017-06-06 04:27:24', NULL, '3', '2017-05-25', '0'),
('2044', '13', '441', '10', '2017-06-06 04:27:24', NULL, '3', '2017-05-25', '0'),
('2045', '10', '444', '10', '2018-01-04 00:45:34', NULL, '3', '2017-05-25', NULL),
('2046', '13', '421', '10', '2017-06-06 04:27:59', 'Voided.', '3', '2017-06-06', '0'),
('2047', '10', '424', '10', '2017-06-06 04:27:59', 'Voided.\n', '3', '2017-06-06', '0'),
('2048', '12', '130', '10', '2018-01-08 05:43:45', NULL, '3', '2017-06-05', NULL),
('2049', '12', '131', '10', '2018-01-08 05:23:45', NULL, '3', '2017-06-07', NULL),
('2050', '1', '329', '10', '2017-06-06 06:18:06', NULL, '3', '2017-06-06', NULL),
('2051', '1', '329', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-06', '626'),
('2052', '1', '330', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-06', '627'),
('2053', '1', '331', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-07', '629'),
('2054', '1', '332', '10', '2018-01-04 03:39:42', NULL, '3', '2017-06-07', NULL),
('2055', '1', '333', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-07', '630'),
('2056', '1', '334', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-07', '631'),
('2057', '1', '335', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-07', '632'),
('2058', '1', '336', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-24', '489'),
('2059', '1', '274', '10', '2017-06-07 02:55:07', 'Voided.\nDocument reentered.', '3', '2017-06-07', '0'),
('2060', '1', '337', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-07', '633'),
('2061', '1', '338', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-07', '634'),
('2062', '1', '339', '10', '2017-06-07 03:10:25', NULL, '3', '2017-06-07', NULL),
('2063', '1', '339', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-07', '635'),
('2064', '1', '340', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-07', '636'),
('2065', '1', '341', '10', '2017-06-07 05:16:47', NULL, '3', '2017-06-07', NULL),
('2066', '1', '342', '10', '2017-06-07 04:45:38', NULL, '3', '2017-06-07', NULL),
('2067', '1', '342', '10', '2017-06-07 04:45:38', 'Voided.\n', '3', '2017-06-07', '0'),
('2068', '1', '343', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '527'),
('2069', '1', '344', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-29', '544'),
('2070', '1', '345', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-29', '545'),
('2071', '1', '346', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '566'),
('2072', '1', '347', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-07', '637'),
('2073', '1', '348', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-07', '638'),
('2074', '30', '442', '10', '2017-06-07 05:14:40', NULL, '3', '2017-05-08', '0'),
('2075', '13', '442', '10', '2018-03-17 04:02:21', NULL, '3', '2017-05-08', NULL),
('2076', '10', '445', '10', '2018-01-04 00:51:27', NULL, '3', '2017-05-08', NULL),
('2077', '12', '132', '10', '2018-01-08 05:11:19', NULL, '3', '2017-06-07', NULL),
('2078', '1', '341', '10', '2017-06-07 05:16:47', 'Voided.\n', '3', '2017-06-07', '0'),
('2079', '1', '349', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-07', '639'),
('2080', '1', '350', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-16', '259'),
('2081', '1', '351', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-03', '308'),
('2082', '1', '352', '10', '2017-06-27 01:45:33', NULL, '3', '2017-02-03', NULL),
('2083', '1', '352', '10', '2017-06-27 01:45:33', NULL, '3', '2017-02-03', NULL),
('2084', '1', '353', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-22', '417'),
('2085', '1', '354', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-22', '418'),
('2086', '1', '355', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-22', '419'),
('2087', '1', '356', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-22', '420'),
('2088', '1', '357', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-24', '431'),
('2089', '1', '358', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-24', '432'),
('2090', '1', '359', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-24', '433'),
('2091', '1', '360', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-28', '441'),
('2092', '1', '361', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-28', '442'),
('2093', '1', '362', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-29', '449'),
('2094', '1', '363', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-29', '450'),
('2095', '1', '364', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-29', '451'),
('2096', '1', '365', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-29', '452'),
('2097', '1', '366', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-29', '453'),
('2098', '1', '367', '10', '2017-06-07 06:01:29', NULL, '2', '2017-03-29', NULL),
('2099', '1', '367', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-29', '454'),
('2100', '1', '368', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-29', '455'),
('2101', '1', '369', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-29', '456'),
('2102', '30', '443', '10', '2017-06-07 06:14:44', NULL, '2', '2016-05-19', '0'),
('2103', '13', '443', '10', '2017-06-07 06:14:44', NULL, '2', '2016-05-19', '0'),
('2104', '10', '446', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-19', '15'),
('2105', '12', '133', '10', '2018-02-05 04:47:11', NULL, '1', '2016-02-17', '65'),
('2106', '12', '134', '10', '2017-07-19 02:37:47', NULL, '2', '2016-03-30', NULL),
('2107', '12', '134', '10', '2017-07-19 02:37:47', 'Updated.', '2', '2016-03-30', NULL),
('2108', '1', '370', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '646'),
('2109', '30', '444', '10', '2017-06-09 01:38:12', NULL, '3', '2017-06-09', '0'),
('2110', '13', '444', '10', '2017-06-09 02:06:28', NULL, '3', '2017-06-09', NULL),
('2111', '10', '447', '10', '2017-06-09 02:06:28', NULL, '3', '2017-06-09', NULL),
('2112', '13', '444', '10', '2017-06-09 02:06:28', 'Voided.', '3', '2017-06-09', '0'),
('2113', '10', '447', '10', '2017-06-09 02:06:28', 'Voided.\n', '3', '2017-06-09', '0'),
('2114', '30', '445', '10', '2017-06-09 02:10:18', NULL, '3', '2017-06-09', '0'),
('2115', '13', '445', '10', '2017-06-09 02:10:18', NULL, '3', '2017-06-09', '0'),
('2116', '10', '448', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '647'),
('2117', '1', '371', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '648'),
('2118', '1', '372', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '649'),
('2119', '1', '373', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '650'),
('2120', '1', '374', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '651'),
('2121', '1', '375', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '652'),
('2122', '1', '376', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '653'),
('2123', '1', '377', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '654'),
('2124', '1', '378', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '655'),
('2125', '1', '379', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '656'),
('2126', '1', '380', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '657'),
('2127', '1', '381', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '658'),
('2128', '1', '382', '10', '2018-03-06 23:16:39', NULL, '3', '2017-06-09', NULL),
('2129', '1', '383', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-12', '670'),
('2130', '1', '384', '10', '2018-03-06 23:17:02', NULL, '3', '2017-06-12', NULL),
('2131', '4', '14', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-12', '671'),
('2132', '12', '135', '10', '2018-01-08 06:21:56', NULL, '3', '2017-06-12', NULL),
('2133', '1', '385', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-14', '676'),
('2134', '4', '15', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-14', '677'),
('2135', '1', '386', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-14', '678'),
('2136', '30', '446', '10', '2017-06-16 00:10:59', NULL, '3', '2017-05-30', '0'),
('2137', '13', '446', '10', '2017-06-16 00:10:59', NULL, '3', '2017-05-30', '0'),
('2138', '10', '449', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-30', '556'),
('2139', '30', '447', '10', '2017-06-16 00:13:29', NULL, '3', '2017-05-30', '0'),
('2140', '13', '447', '10', '2017-06-16 00:13:29', NULL, '3', '2017-05-30', '0'),
('2141', '10', '450', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-30', '557'),
('2142', '30', '448', '10', '2017-06-16 00:21:40', NULL, '3', '2017-05-31', '0'),
('2143', '13', '448', '10', '2017-06-16 00:21:40', NULL, '3', '2017-05-31', '0'),
('2144', '10', '451', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '567'),
('2145', '30', '449', '10', '2017-06-16 00:23:09', NULL, '3', '2017-05-31', '0'),
('2146', '13', '449', '10', '2017-06-16 00:23:09', NULL, '3', '2017-05-31', '0'),
('2147', '10', '452', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '568'),
('2148', '30', '450', '10', '2017-06-16 00:46:19', NULL, '3', '2017-04-12', '0'),
('2149', '13', '450', '10', '2017-06-16 00:46:19', NULL, '3', '2017-04-12', '0'),
('2150', '10', '453', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-12', '135'),
('2151', '30', '451', '10', '2017-06-16 00:53:08', NULL, '3', '2017-04-12', '0'),
('2152', '13', '451', '10', '2017-06-16 00:53:08', NULL, '3', '2017-04-12', '0'),
('2153', '10', '454', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-12', '136'),
('2154', '30', '452', '10', '2017-06-16 00:54:37', NULL, '3', '2017-04-07', '0'),
('2155', '13', '452', '10', '2017-06-16 00:54:37', NULL, '3', '2017-04-07', '0'),
('2156', '10', '455', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '84'),
('2157', '30', '453', '10', '2017-06-16 01:04:38', NULL, '3', '2017-04-06', '0'),
('2158', '13', '453', '10', '2017-06-16 01:04:38', NULL, '3', '2017-04-06', '0'),
('2159', '10', '456', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '66'),
('2160', '30', '454', '10', '2017-06-16 01:05:45', NULL, '3', '2017-04-07', '0'),
('2161', '13', '454', '10', '2017-06-16 01:05:45', NULL, '3', '2017-04-07', '0'),
('2162', '10', '457', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '85'),
('2163', '30', '455', '10', '2017-06-16 01:08:37', NULL, '3', '2017-04-17', '0'),
('2164', '13', '455', '10', '2017-06-16 01:08:37', NULL, '3', '2017-04-17', '0'),
('2165', '10', '458', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-17', '143'),
('2166', '30', '456', '10', '2017-06-16 01:09:55', NULL, '3', '2017-04-19', '0'),
('2167', '13', '456', '10', '2017-06-16 01:09:55', NULL, '3', '2017-04-19', '0'),
('2168', '10', '459', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-19', '157'),
('2169', '30', '457', '10', '2017-06-16 01:11:00', NULL, '3', '2017-04-19', '0'),
('2170', '13', '457', '10', '2017-06-16 01:11:00', NULL, '3', '2017-04-19', '0'),
('2171', '10', '460', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-19', '158'),
('2172', '30', '458', '10', '2017-06-16 01:14:07', NULL, '3', '2017-04-25', '0'),
('2173', '13', '458', '10', '2017-06-16 01:14:07', NULL, '3', '2017-04-25', '0'),
('2174', '10', '461', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-25', '213'),
('2175', '30', '459', '10', '2017-06-16 01:15:16', NULL, '3', '2017-04-26', '0'),
('2176', '13', '459', '10', '2017-06-16 01:15:16', NULL, '3', '2017-04-26', '0'),
('2177', '10', '462', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-26', '219'),
('2178', '30', '460', '10', '2017-06-16 01:24:12', NULL, '3', '2017-04-28', '0'),
('2179', '13', '460', '10', '2017-06-16 01:24:12', NULL, '3', '2017-04-28', '0'),
('2180', '10', '463', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '275'),
('2181', '30', '461', '10', '2017-06-16 01:24:59', NULL, '3', '2017-04-17', '0'),
('2182', '13', '461', '10', '2017-06-16 01:24:59', NULL, '3', '2017-04-17', '0'),
('2183', '10', '464', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-17', '144'),
('2184', '30', '462', '10', '2017-06-16 01:26:15', NULL, '3', '2017-04-19', '0'),
('2185', '13', '462', '10', '2017-06-16 01:26:15', NULL, '3', '2017-04-19', '0'),
('2186', '10', '465', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-19', '159'),
('2187', '30', '463', '10', '2017-06-16 01:37:01', NULL, '3', '2017-05-12', '0'),
('2188', '13', '463', '10', '2017-06-16 01:37:01', NULL, '3', '2017-05-12', '0'),
('2189', '10', '466', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-12', '385'),
('2190', '30', '464', '10', '2017-06-16 01:39:40', NULL, '3', '2017-05-15', '0'),
('2191', '13', '464', '10', '2017-06-16 01:39:40', NULL, '3', '2017-05-15', '0'),
('2192', '10', '467', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '400'),
('2193', '30', '465', '10', '2017-06-16 01:44:52', NULL, '3', '2017-05-15', '0'),
('2194', '13', '465', '10', '2017-06-16 01:44:52', NULL, '3', '2017-05-15', '0'),
('2195', '10', '468', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '401'),
('2196', '30', '466', '10', '2017-06-16 01:50:24', NULL, '3', '2017-05-15', '0'),
('2197', '13', '466', '10', '2017-06-16 01:51:35', NULL, '3', '2017-05-15', NULL),
('2198', '10', '469', '10', '2017-06-16 01:51:35', NULL, '3', '2017-05-15', NULL),
('2199', '13', '466', '10', '2017-06-16 01:51:35', 'Voided.', '3', '2017-06-16', '0'),
('2200', '10', '469', '10', '2017-06-16 01:51:35', 'Voided.\n', '3', '2017-06-16', '0'),
('2201', '30', '467', '10', '2017-06-16 01:53:11', NULL, '3', '2017-05-15', '0'),
('2202', '13', '467', '10', '2017-06-16 01:53:11', NULL, '3', '2017-05-15', '0'),
('2203', '10', '470', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '402'),
('2204', '30', '468', '10', '2017-06-16 01:54:00', NULL, '3', '2017-05-15', '0'),
('2205', '13', '468', '10', '2017-06-16 01:54:00', NULL, '3', '2017-05-15', '0'),
('2206', '10', '471', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '403'),
('2207', '30', '469', '10', '2017-06-16 01:54:42', NULL, '3', '2017-05-15', '0'),
('2208', '13', '469', '10', '2017-06-16 01:54:43', NULL, '3', '2017-05-15', '0'),
('2209', '10', '472', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '404'),
('2210', '30', '470', '10', '2017-06-16 02:14:17', NULL, '3', '2017-05-31', '0'),
('2211', '13', '470', '10', '2017-06-16 02:14:17', NULL, '3', '2017-05-31', '0'),
('2212', '10', '473', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '569'),
('2213', '30', '471', '10', '2017-06-16 02:23:31', NULL, '3', '2017-05-31', '0'),
('2214', '13', '471', '10', '2017-11-30 00:29:32', NULL, '3', '2017-05-31', NULL),
('2215', '10', '474', '10', '2017-11-30 00:29:32', NULL, '3', '2017-05-31', NULL),
('2216', '30', '472', '10', '2017-06-16 02:24:59', NULL, '3', '2017-05-31', '0'),
('2217', '13', '472', '10', '2017-06-16 02:24:59', NULL, '3', '2017-05-31', '0'),
('2218', '10', '475', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '570'),
('2219', '1', '387', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-16', '689'),
('2220', '1', '388', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-16', '690'),
('2221', '1', '389', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-16', '691'),
('2222', '1', '390', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-16', '692'),
('2223', '16', '4', '10', '2017-06-19 01:44:20', NULL, '3', '2017-06-15', '0'),
('2224', '16', '5', '10', '2017-06-19 01:48:58', NULL, '3', '2017-05-26', '0'),
('2225', '30', '473', '10', '2017-06-19 01:59:53', NULL, '3', '2017-06-19', '0'),
('2226', '13', '473', '10', '2017-06-19 01:59:53', NULL, '3', '2017-06-19', '0'),
('2227', '10', '476', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-19', '696'),
('2228', '30', '474', '10', '2017-06-19 02:00:37', NULL, '3', '2017-06-19', '0'),
('2229', '13', '474', '10', '2017-06-19 02:00:37', NULL, '3', '2017-06-19', '0'),
('2230', '10', '477', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-19', '697'),
('2231', '1', '391', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-19', '698'),
('2232', '4', '16', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-19', '699'),
('2233', '1', '392', '10', '2018-03-06 23:18:03', NULL, '3', '2017-06-19', NULL),
('2234', '1', '393', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-19', '700'),
('2235', '1', '394', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-19', '701'),
('2236', '1', '395', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-19', '702'),
('2237', '30', '475', '10', '2017-06-19 23:41:15', NULL, '3', '2017-06-20', '0'),
('2238', '13', '475', '10', '2017-06-19 23:41:15', NULL, '3', '2017-06-20', '0'),
('2239', '1', '396', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-16', '693'),
('2240', '1', '397', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-20', '706'),
('2241', '30', '476', '10', '2017-06-20 00:57:51', NULL, '3', '2017-06-20', '0'),
('2242', '13', '476', '10', '2017-06-20 00:57:51', NULL, '3', '2017-06-20', '0'),
('2243', '10', '478', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-20', '707'),
('2244', '12', '136', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-20', '708'),
('2245', '30', '477', '10', '2017-06-20 01:04:53', NULL, '3', '2017-05-08', '0'),
('2246', '13', '477', '10', '2017-06-20 01:04:53', NULL, '3', '2017-05-08', '0'),
('2247', '1', '398', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-20', '709'),
('2248', '1', '399', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-20', '710'),
('2249', '1', '400', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-20', '711'),
('2250', '1', '401', '10', '2017-06-30 01:26:39', NULL, '3', '2017-06-21', NULL),
('2251', '12', '137', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-21', '716'),
('2252', '30', '478', '10', '2017-06-21 01:56:22', NULL, '3', '2017-05-31', '0'),
('2253', '13', '478', '10', '2017-06-21 01:56:22', NULL, '3', '2017-05-31', '0'),
('2254', '10', '479', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '571'),
('2255', '30', '479', '10', '2017-06-21 02:00:43', NULL, '3', '2017-05-31', '0'),
('2256', '13', '479', '10', '2017-06-21 02:00:43', NULL, '3', '2017-05-31', '0'),
('2257', '10', '480', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '572'),
('2258', '30', '480', '10', '2017-06-21 02:17:41', NULL, '3', '2017-05-31', '0'),
('2259', '13', '480', '10', '2017-06-21 02:17:41', NULL, '3', '2017-05-31', '0'),
('2260', '10', '481', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '573'),
('2261', '1', '402', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-21', '717'),
('2262', '1', '403', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-21', '718'),
('2263', '1', '404', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-21', '719'),
('2264', '1', '405', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-21', '720'),
('2265', '1', '406', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-21', '721'),
('2266', '1', '407', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-21', '722'),
('2267', '1', '408', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-22', '729'),
('2268', '1', '409', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-22', '730'),
('2269', '1', '410', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-22', '731'),
('2270', '30', '481', '10', '2017-06-22 05:41:37', NULL, '3', '2017-05-15', '0'),
('2271', '13', '481', '10', '2017-06-22 05:41:37', NULL, '3', '2017-05-15', '0'),
('2272', '10', '482', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '405'),
('2273', '30', '482', '10', '2017-06-22 05:44:21', NULL, '3', '2017-05-19', '0'),
('2274', '13', '482', '10', '2017-06-22 05:44:21', NULL, '3', '2017-05-19', '0'),
('2275', '10', '483', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '449'),
('2276', '1', '411', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-23', '740'),
('2277', '1', '412', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-23', '741'),
('2278', '1', '413', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-23', '742'),
('2279', '1', '414', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-23', '743'),
('2280', '1', '415', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-23', '744'),
('2281', '1', '416', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-23', '745'),
('2282', '12', '138', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-23', '746'),
('2283', '12', '139', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-23', '747'),
('2284', '12', '140', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-23', '748'),
('2285', '12', '141', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-23', '749'),
('2286', '12', '142', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-23', '750'),
('2287', '12', '143', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '823'),
('2288', '12', '144', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '770'),
('2289', '12', '145', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-06', '901'),
('2290', '12', '146', '10', '2017-07-16 23:59:37', NULL, '3', '2017-06-26', NULL),
('2291', '12', '147', '10', '2017-06-30 02:28:10', NULL, '3', '2017-06-23', NULL),
('2292', '12', '148', '10', '2017-06-25 23:44:35', NULL, '3', '2017-07-25', NULL),
('2293', '12', '148', '10', '2017-06-25 23:44:35', 'Voided.\n', '3', '2017-06-25', '0'),
('2294', '12', '149', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-25', '1064'),
('2295', '12', '150', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-18', '998'),
('2296', '12', '151', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '922'),
('2297', '12', '152', '10', '2017-07-26 23:24:13', NULL, '3', '2017-07-25', NULL),
('2298', '12', '153', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1047'),
('2299', '12', '154', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1048'),
('2300', '12', '155', '10', '2017-06-28 03:08:07', NULL, '3', '2017-07-21', NULL),
('2301', '30', '483', '10', '2017-06-26 01:57:23', NULL, '2', '2017-01-31', '0'),
('2302', '13', '483', '10', '2017-06-26 01:57:23', NULL, '2', '2017-01-31', '0'),
('2303', '10', '484', '10', '2017-09-18 23:19:02', NULL, '2', '2017-01-31', NULL),
('2304', '30', '484', '10', '2017-06-26 01:58:25', NULL, '2', '2017-03-31', '0'),
('2305', '13', '484', '10', '2017-06-26 01:58:25', NULL, '2', '2017-03-31', '0'),
('2306', '10', '485', '10', '2017-09-18 23:19:17', NULL, '2', '2017-03-31', NULL),
('2307', '1', '417', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-26', '760'),
('2308', '1', '418', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-26', '761'),
('2309', '30', '485', '10', '2017-06-27 00:49:07', NULL, '3', '2017-06-27', '0'),
('2310', '13', '485', '10', '2017-06-27 00:49:07', NULL, '3', '2017-06-27', '0'),
('2311', '10', '486', '10', '2017-11-24 00:42:50', NULL, '3', '2017-06-27', NULL),
('2312', '20', '8', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-16', '410'),
('2313', '20', '9', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-08', '382'),
('2314', '20', '10', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-15', '402'),
('2315', '20', '11', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-29', '457'),
('2316', '20', '12', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-20', '454'),
('2317', '20', '13', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-23', '473'),
('2318', '20', '14', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-02', '2'),
('2319', '20', '15', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-08', '383'),
('2320', '20', '16', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-27', '208'),
('2321', '20', '17', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-18', '265'),
('2322', '20', '18', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '771'),
('2323', '1', '419', '10', '2017-06-27 01:45:33', NULL, '2', '2017-02-03', NULL),
('2324', '1', '419', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-03', '309'),
('2325', '1', '352', '10', '2017-06-27 01:45:33', 'Voided.\nDocument reentered.', '3', '2017-06-27', '0'),
('2326', '18', '2', '10', '2017-06-27 01:54:45', NULL, '2', '2017-01-26', '0'),
('2327', '25', '2', '10', '2017-06-27 01:54:45', NULL, '2', '2017-01-26', '0'),
('2328', '20', '19', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-26', '285'),
('2329', '4', '17', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '772'),
('2330', '1', '420', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '773'),
('2331', '1', '421', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '774'),
('2332', '1', '422', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '775'),
('2333', '1', '423', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '776'),
('2334', '1', '424', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '777'),
('2335', '1', '425', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '778'),
('2336', '1', '426', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '779'),
('2337', '1', '427', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '780'),
('2338', '1', '428', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '792'),
('2339', '1', '429', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '793'),
('2340', '1', '430', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '794'),
('2341', '1', '431', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '795'),
('2342', '1', '432', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '796'),
('2343', '4', '18', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '797'),
('2344', '1', '433', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '798'),
('2345', '1', '434', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '799'),
('2346', '1', '435', '10', '2017-11-24 03:44:14', NULL, '3', '2017-06-28', NULL),
('2347', '12', '155', '10', '2017-06-28 03:08:07', 'Voided.\n', '3', '2017-06-28', '0'),
('2348', '1', '436', '10', '2017-06-28 05:59:34', NULL, '3', '2017-06-28', NULL),
('2349', '1', '437', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '800'),
('2350', '1', '436', '10', '2017-06-28 05:59:34', 'Voided.\n', '3', '2017-06-28', '0'),
('2351', '1', '438', '10', '2018-03-06 23:19:05', NULL, '3', '2017-06-28', NULL),
('2352', '1', '439', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '801'),
('2353', '1', '440', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-29', '809'),
('2354', '30', '486', '10', '2017-06-29 03:40:03', NULL, '3', '2017-06-28', '0'),
('2355', '13', '486', '10', '2017-06-29 03:40:03', NULL, '3', '2017-06-28', '0'),
('2356', '10', '487', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '802'),
('2357', '1', '441', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-29', '810'),
('2358', '1', '442', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '824'),
('2359', '1', '443', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '825'),
('2360', '1', '444', '10', '2017-06-30 01:29:39', NULL, '3', '2017-06-21', NULL),
('2361', '1', '401', '10', '2017-06-30 01:26:39', 'Voided.\nDocument reentered.', '3', '2017-06-30', '0'),
('2362', '1', '445', '10', '2018-03-07 00:50:17', NULL, '3', '2017-06-21', NULL),
('2363', '1', '444', '10', '2017-06-30 01:29:39', 'Voided.\nDocument reentered.', '3', '2017-06-30', '0'),
('2364', '4', '19', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-21', '723'),
('2365', '1', '446', '10', '2018-03-06 23:19:29', NULL, '3', '2017-06-30', NULL),
('2366', '1', '447', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '826'),
('2367', '1', '448', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '827'),
('2368', '1', '449', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '828'),
('2369', '12', '147', '10', '2017-07-17 00:00:28', 'Updated.', '3', '2017-06-30', NULL),
('2370', '16', '6', '10', '2017-06-30 03:08:15', NULL, '3', '2017-06-29', '0'),
('2371', '11', '22', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-29', '811'),
('2372', '11', '23', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-29', '812'),
('2373', '1', '450', '10', '2017-06-30 04:26:55', NULL, '3', '2017-06-29', NULL),
('2374', '1', '451', '10', '2018-01-04 04:00:53', NULL, '3', '2017-06-30', NULL),
('2375', '1', '450', '10', '2017-06-30 04:26:55', 'Voided.\nDocument reentered.', '3', '2017-06-30', '0'),
('2376', '1', '452', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '829'),
('2377', '1', '453', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '830'),
('2378', '30', '487', '10', '2017-06-30 05:17:04', NULL, '3', '2017-06-05', '0'),
('2379', '13', '487', '10', '2017-06-30 05:17:04', NULL, '3', '2017-06-05', '0'),
('2380', '10', '488', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-05', '620'),
('2381', '30', '488', '10', '2017-06-30 05:17:57', NULL, '3', '2017-06-09', '0'),
('2382', '13', '488', '10', '2017-06-30 05:17:57', NULL, '3', '2017-06-09', '0'),
('2383', '10', '489', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '659'),
('2384', '30', '489', '10', '2017-06-30 05:19:07', NULL, '3', '2017-06-15', '0'),
('2385', '13', '489', '10', '2017-06-30 05:19:07', NULL, '3', '2017-06-15', '0'),
('2386', '10', '490', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-15', '682'),
('2387', '30', '490', '10', '2017-06-30 05:21:09', NULL, '3', '2017-06-15', '0'),
('2388', '13', '490', '10', '2017-06-30 05:21:09', NULL, '3', '2017-06-15', '0'),
('2389', '10', '491', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-15', '683'),
('2390', '30', '491', '10', '2017-06-30 05:21:54', NULL, '3', '2017-06-15', '0'),
('2391', '13', '491', '10', '2017-06-30 05:21:54', NULL, '3', '2017-06-15', '0'),
('2392', '10', '492', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-15', '684'),
('2393', '30', '492', '10', '2017-06-30 05:23:25', NULL, '3', '2017-06-15', '0'),
('2394', '13', '492', '10', '2017-06-30 05:23:25', NULL, '3', '2017-06-15', '0'),
('2395', '10', '493', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-15', '685'),
('2396', '30', '493', '10', '2017-06-30 05:24:42', NULL, '3', '2017-06-19', '0'),
('2397', '13', '493', '10', '2017-06-30 05:24:42', NULL, '3', '2017-06-19', '0'),
('2398', '10', '494', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-19', '703'),
('2399', '30', '494', '10', '2017-06-30 05:28:58', NULL, '3', '2017-06-07', '0'),
('2400', '13', '494', '10', '2017-06-30 05:28:58', NULL, '3', '2017-06-07', '0'),
('2401', '10', '495', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-07', '640'),
('2402', '1', '454', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '869'),
('2403', '1', '455', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '870'),
('2404', '1', '456', '10', '2018-01-04 04:01:40', NULL, '3', '2017-07-04', NULL),
('2405', '1', '457', '10', '2017-07-05 03:49:28', NULL, '3', '2017-07-04', NULL),
('2406', '1', '458', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '871'),
('2407', '1', '459', '10', '2018-03-07 00:09:49', NULL, '3', '2017-07-04', NULL),
('2408', '1', '460', '10', '2018-03-06 23:20:10', NULL, '3', '2017-07-04', NULL),
('2409', '1', '461', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '872'),
('2410', '1', '462', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '873'),
('2411', '1', '463', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '874'),
('2412', '1', '464', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '875'),
('2413', '1', '465', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '876'),
('2414', '20', '20', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-26', '762'),
('2415', '20', '21', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-19', '704'),
('2416', '20', '22', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '660'),
('2417', '20', '23', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '661'),
('2418', '22', '6', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '877'),
('2419', '20', '24', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-24', '755'),
('2420', '20', '25', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-15', '686'),
('2421', '20', '26', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '608'),
('2422', '22', '7', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '878'),
('2423', '1', '466', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '879'),
('2424', '1', '467', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-05', '890'),
('2425', '12', '82', '10', '2017-07-05 01:27:46', 'Voided.\nCheque Retuned', '3', '2017-07-05', '0'),
('2426', '16', '7', '10', '2017-07-05 01:59:02', NULL, '3', '2017-07-05', '0'),
('2427', '16', '8', '10', '2017-07-05 02:02:59', NULL, '3', '2017-07-05', '0'),
('2428', '30', '495', '10', '2017-07-05 03:34:33', NULL, '3', '2017-06-26', '0'),
('2429', '13', '495', '10', '2017-07-05 03:34:34', NULL, '3', '2017-06-26', '0'),
('2430', '10', '496', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-26', '763'),
('2431', '30', '496', '10', '2017-07-05 03:35:57', NULL, '3', '2017-06-26', '0'),
('2432', '13', '496', '10', '2017-07-05 03:35:57', NULL, '3', '2017-06-26', '0'),
('2433', '10', '497', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-26', '764'),
('2434', '30', '497', '10', '2017-07-05 03:37:38', NULL, '3', '2017-06-26', '0'),
('2435', '13', '497', '10', '2017-07-05 03:37:38', NULL, '3', '2017-06-26', '0'),
('2436', '10', '498', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-26', '765'),
('2437', '1', '468', '10', '2018-03-07 00:54:55', NULL, '3', '2017-07-05', NULL),
('2438', '1', '469', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-05', '891'),
('2439', '1', '457', '10', '2017-07-05 03:49:28', 'Voided.\nDocument reentered.', '3', '2017-07-05', '0'),
('2440', '1', '470', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-05', '892'),
('2441', '1', '471', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-05', '893'),
('2442', '1', '472', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-05', '894'),
('2443', '1', '473', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-06', '902'),
('2444', '30', '498', '10', '2017-07-06 02:29:13', NULL, '3', '2017-07-06', '0'),
('2445', '13', '498', '10', '2018-03-17 04:50:50', NULL, '3', '2017-07-06', NULL),
('2446', '10', '499', '10', '2017-07-06 03:06:25', NULL, '3', '2017-07-06', NULL),
('2447', '30', '499', '10', '2017-07-06 02:30:24', NULL, '3', '2017-07-06', '0'),
('2448', '13', '499', '10', '2018-03-17 04:51:07', NULL, '3', '2017-07-06', NULL),
('2449', '10', '500', '10', '2018-01-04 01:15:09', NULL, '3', '2017-07-06', NULL),
('2450', '10', '499', '10', '2018-01-04 01:14:55', 'Updated.', '3', '2017-07-06', NULL),
('2451', '12', '25', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-03-31', '488'),
('2452', '1', '474', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '22'),
('2453', '1', '475', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '86'),
('2454', '1', '476', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '87'),
('2455', '1', '477', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '88'),
('2456', '1', '478', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '89'),
('2457', '1', '479', '10', '2018-03-07 00:05:40', NULL, '3', '2017-04-11', NULL),
('2458', '1', '480', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '124'),
('2459', '1', '481', '10', '2017-07-06 04:33:28', NULL, '3', '2017-04-21', NULL),
('2460', '1', '482', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-21', '180'),
('2461', '1', '481', '10', '2017-07-06 04:33:28', 'Voided.\nDocument reentered.', '3', '2017-07-06', '0'),
('2462', '1', '483', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-21', '181'),
('2463', '1', '484', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-21', '182'),
('2464', '1', '485', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-24', '197'),
('2465', '1', '486', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-24', '198'),
('2466', '1', '487', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-25', '214'),
('2467', '1', '488', '10', '2017-07-06 05:22:55', NULL, '3', '2017-04-25', NULL),
('2468', '1', '489', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-24', '199'),
('2469', '1', '490', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-25', '215'),
('2470', '1', '488', '10', '2017-07-06 05:22:55', 'Voided.\nDocument reentered.', '3', '2017-07-06', '0'),
('2471', '1', '491', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-26', '220'),
('2472', '1', '492', '10', '2018-01-07 23:32:28', NULL, '3', '2017-04-27', NULL),
('2473', '1', '493', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '244'),
('2474', '1', '494', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '245'),
('2475', '1', '495', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '246'),
('2476', '1', '496', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-06', '903'),
('2477', '1', '497', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '276'),
('2478', '1', '498', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '277'),
('2479', '1', '499', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '319'),
('2480', '1', '500', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '340'),
('2481', '1', '501', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-05', '350'),
('2482', '1', '502', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-05', '351'),
('2483', '1', '503', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-08', '366'),
('2484', '1', '504', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-17', '423'),
('2485', '1', '505', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-17', '424'),
('2486', '1', '506', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-16', '415'),
('2487', '1', '507', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-17', '425'),
('2488', '1', '508', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-18', '432'),
('2489', '1', '509', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '450'),
('2490', '30', '500', '10', '2017-07-07 00:42:21', NULL, '3', '2017-07-07', '0'),
('2491', '13', '500', '10', '2018-03-17 04:35:39', NULL, '3', '2017-07-07', NULL),
('2492', '10', '501', '10', '2017-07-07 01:09:05', NULL, '3', '2017-07-07', NULL),
('2493', '1', '510', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-22', '464'),
('2494', '1', '511', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-22', '465'),
('2495', '1', '512', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-23', '474'),
('2496', '10', '501', '10', '2018-01-04 00:45:44', 'Updated.', '3', '2017-07-01', NULL),
('2497', '1', '513', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-25', '504'),
('2498', '1', '514', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-22', '466'),
('2499', '1', '515', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-29', '546'),
('2500', '1', '516', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-29', '547'),
('2501', '1', '517', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-30', '558'),
('2502', '1', '518', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-01', '587'),
('2503', '1', '519', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-01', '588');
INSERT INTO `0_audit_trail` VALUES
('2504', '1', '520', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-01', '589'),
('2505', '1', '521', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '662'),
('2506', '1', '522', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '663'),
('2507', '4', '20', '10', '2017-07-07 01:43:30', NULL, '3', '2017-07-07', '0'),
('2508', '1', '523', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '664'),
('2509', '1', '524', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '665'),
('2510', '1', '525', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '666'),
('2511', '1', '526', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '667'),
('2512', '12', '156', '10', '2017-07-07 02:06:15', NULL, '3', '2017-07-07', NULL),
('2513', '12', '156', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-07', '908'),
('2514', '12', '157', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-28', '1105'),
('2515', '1', '527', '10', '2017-07-07 03:29:08', NULL, '3', '2017-07-28', NULL),
('2516', '1', '528', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-07', '909'),
('2517', '1', '527', '10', '2017-07-07 03:29:08', 'Voided.\nDocument reentered.', '3', '2017-07-07', '0'),
('2518', '4', '21', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-07', '910'),
('2519', '1', '529', '10', '2017-11-16 02:50:54', NULL, '3', '2017-07-07', NULL),
('2520', '1', '530', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-07', '911'),
('2521', '1', '531', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-07', '912'),
('2522', '1', '532', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-07', '913'),
('2523', '1', '533', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-07', '914'),
('2524', '1', '534', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-07', '915'),
('2525', '1', '535', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '923'),
('2526', '1', '536', '10', '2018-01-24 01:46:59', NULL, '3', '2017-07-10', NULL),
('2527', '1', '537', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '924'),
('2528', '30', '501', '10', '2017-07-10 02:32:35', NULL, '3', '2017-07-07', '0'),
('2529', '13', '501', '10', '2017-07-10 02:32:35', NULL, '3', '2017-07-07', '0'),
('2530', '10', '502', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-07', '916'),
('2531', '12', '158', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '925'),
('2532', '1', '538', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '926'),
('2533', '1', '539', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '927'),
('2534', '1', '540', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '928'),
('2535', '1', '541', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '929'),
('2536', '1', '542', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '930'),
('2537', '1', '543', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '931'),
('2538', '16', '9', '10', '2017-07-10 05:51:59', NULL, '3', '2017-07-07', '0'),
('2539', '1', '544', '10', '2017-07-11 04:02:41', NULL, '3', '2017-07-11', NULL),
('2540', '1', '545', '10', '2017-07-11 04:03:33', NULL, '3', '2017-07-11', NULL),
('2541', '1', '544', '10', '2017-07-11 04:02:41', 'Voided.\nDocument reentered.', '3', '2017-07-11', '0'),
('2542', '1', '546', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-11', '942'),
('2543', '1', '545', '10', '2017-07-11 04:03:33', 'Voided.\nDocument reentered.', '3', '2017-07-11', '0'),
('2544', '30', '502', '10', '2017-07-11 04:11:51', NULL, '3', '2017-06-30', '0'),
('2545', '13', '502', '10', '2017-07-11 04:11:51', NULL, '3', '2017-06-30', '0'),
('2546', '10', '503', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '831'),
('2547', '30', '503', '10', '2017-07-11 04:13:45', NULL, '3', '2017-06-30', '0'),
('2548', '13', '503', '10', '2017-08-30 23:43:09', NULL, '3', '2017-06-30', NULL),
('2549', '10', '504', '10', '2017-08-30 23:43:09', NULL, '3', '2017-06-30', NULL),
('2550', '30', '504', '10', '2017-07-11 04:14:51', NULL, '3', '2017-06-30', '0'),
('2551', '13', '504', '10', '2017-09-11 03:32:38', NULL, '3', '2017-06-30', NULL),
('2552', '10', '505', '10', '2017-09-11 03:32:38', NULL, '3', '2017-06-30', NULL),
('2553', '30', '505', '10', '2017-07-11 05:08:38', NULL, '3', '2017-06-27', '0'),
('2554', '13', '505', '10', '2017-07-11 05:08:38', NULL, '3', '2017-06-27', '0'),
('2555', '10', '506', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '781'),
('2556', '30', '506', '10', '2017-07-11 05:12:28', NULL, '3', '2017-06-27', '0'),
('2557', '13', '506', '10', '2017-07-11 05:12:28', NULL, '3', '2017-06-27', '0'),
('2558', '10', '507', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '782'),
('2559', '30', '507', '10', '2017-07-11 05:19:05', NULL, '3', '2017-06-27', '0'),
('2560', '13', '507', '10', '2017-07-11 05:19:05', NULL, '3', '2017-06-27', '0'),
('2561', '10', '508', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '783'),
('2562', '30', '508', '10', '2017-07-11 05:20:17', NULL, '3', '2017-06-29', '0'),
('2563', '13', '508', '10', '2017-07-11 05:20:17', NULL, '3', '2017-06-29', '0'),
('2564', '10', '509', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-29', '813'),
('2565', '30', '509', '10', '2017-07-11 05:27:29', NULL, '3', '2017-06-29', '0'),
('2566', '13', '509', '10', '2017-07-11 05:27:29', NULL, '3', '2017-06-29', '0'),
('2567', '10', '510', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-29', '814'),
('2568', '4', '22', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-11', '943'),
('2569', '30', '510', '10', '2017-07-11 05:39:23', NULL, '3', '2017-06-29', '0'),
('2570', '13', '510', '10', '2017-07-11 05:39:23', NULL, '3', '2017-06-29', '0'),
('2571', '10', '511', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-29', '815'),
('2572', '30', '511', '10', '2017-07-11 05:40:28', NULL, '3', '2017-06-29', '0'),
('2573', '13', '511', '10', '2017-07-11 05:40:28', NULL, '3', '2017-06-29', '0'),
('2574', '10', '512', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-29', '816'),
('2575', '30', '512', '10', '2017-07-11 23:33:05', NULL, '3', '2017-07-11', '0'),
('2576', '13', '512', '10', '2017-07-11 23:33:05', NULL, '3', '2017-07-11', '0'),
('2577', '1', '547', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-12', '952'),
('2578', '1', '548', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-12', '953'),
('2579', '1', '549', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-12', '954'),
('2580', '1', '550', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-12', '955'),
('2581', '1', '551', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-26', '766'),
('2582', '1', '552', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-11', '944'),
('2583', '1', '553', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-12', '956'),
('2584', '1', '554', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-12', '957'),
('2585', '1', '555', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-12', '958'),
('2586', '1', '556', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-12', '959'),
('2587', '1', '557', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-12', '960'),
('2588', '1', '558', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-12', '961'),
('2589', '1', '559', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-12', '962'),
('2590', '2', '56', '10', '2017-07-13 03:37:05', NULL, '3', '2017-07-13', NULL),
('2591', '2', '57', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-13', '967'),
('2592', '2', '56', '10', '2017-07-13 03:37:05', 'Voided.\nDocument reentered.', '3', '2017-07-13', '0'),
('2593', '30', '513', '10', '2017-07-13 04:03:24', NULL, '3', '2017-06-07', '0'),
('2594', '13', '513', '10', '2017-07-13 04:03:24', NULL, '3', '2017-06-07', '0'),
('2595', '10', '513', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-07', '641'),
('2596', '30', '514', '10', '2017-07-13 04:08:04', NULL, '3', '2017-06-14', '0'),
('2597', '13', '514', '10', '2017-07-13 04:08:04', NULL, '3', '2017-06-14', '0'),
('2598', '10', '514', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-14', '679'),
('2599', '30', '515', '10', '2017-07-13 04:10:32', NULL, '3', '2017-06-15', '0'),
('2600', '13', '515', '10', '2017-07-13 04:10:32', NULL, '3', '2017-06-15', '0'),
('2601', '10', '515', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-15', '687'),
('2602', '30', '516', '10', '2017-07-13 04:12:54', NULL, '3', '2017-06-14', '0'),
('2603', '13', '516', '10', '2017-07-13 04:12:54', NULL, '3', '2017-06-14', '0'),
('2604', '10', '516', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-14', '680'),
('2605', '30', '517', '10', '2017-07-13 04:14:02', NULL, '3', '2017-06-20', '0'),
('2606', '13', '517', '10', '2017-07-13 04:14:02', NULL, '3', '2017-06-20', '0'),
('2607', '10', '517', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-20', '712'),
('2608', '30', '518', '10', '2017-07-13 04:15:09', NULL, '3', '2017-06-26', '0'),
('2609', '13', '518', '10', '2017-07-13 04:15:09', NULL, '3', '2017-06-26', '0'),
('2610', '10', '518', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-26', '767'),
('2611', '30', '519', '10', '2017-07-13 04:16:29', NULL, '3', '2017-06-26', '0'),
('2612', '13', '519', '10', '2017-07-13 04:16:29', NULL, '3', '2017-06-26', '0'),
('2613', '10', '519', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-26', '768'),
('2614', '30', '520', '10', '2017-07-13 04:20:30', NULL, '3', '2017-06-30', '0'),
('2615', '13', '520', '10', '2017-07-13 04:20:30', NULL, '3', '2017-06-30', '0'),
('2616', '10', '520', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '832'),
('2617', '11', '24', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '833'),
('2618', '12', '159', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-13', '675'),
('2619', '12', '160', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-10', '1232'),
('2620', '30', '521', '10', '2017-07-13 04:36:23', NULL, '1', '2016-03-31', '0'),
('2621', '13', '521', '10', '2017-07-13 04:36:23', NULL, '1', '2016-03-31', '0'),
('2622', '10', '521', '10', '2018-02-05 04:47:11', NULL, '1', '2016-03-31', '81'),
('2623', '12', '161', '10', '2017-10-19 04:32:02', NULL, '2', '2017-01-03', NULL),
('2624', '12', '162', '10', '2017-10-19 04:31:56', NULL, '3', '2017-07-03', NULL),
('2625', '12', '163', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-03', '857'),
('2626', '12', '164', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-03', '858'),
('2627', '12', '165', '10', '2017-10-19 04:50:43', NULL, '3', '2017-07-03', NULL),
('2628', '12', '166', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-03', '859'),
('2629', '12', '167', '10', '2017-10-19 04:41:03', NULL, '3', '2017-07-03', NULL),
('2630', '12', '168', '10', '2017-10-19 04:35:06', NULL, '3', '2017-07-03', NULL),
('2631', '11', '25', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '834'),
('2632', '12', '169', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-03', '860'),
('2633', '11', '26', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '835'),
('2634', '11', '27', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '836'),
('2635', '12', '170', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-03', '861'),
('2636', '11', '28', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '837'),
('2637', '1', '560', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-14', '968'),
('2638', '12', '171', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-14', '969'),
('2639', '12', '172', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-14', '970'),
('2640', '12', '173', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-14', '971'),
('2641', '1', '561', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-14', '972'),
('2642', '1', '562', '10', '2018-03-06 23:21:01', NULL, '3', '2017-07-14', NULL),
('2643', '1', '563', '10', '2018-03-07 00:10:22', NULL, '3', '2017-07-14', NULL),
('2644', '1', '564', '10', '2018-03-06 23:21:44', NULL, '3', '2017-07-14', NULL),
('2645', '18', '3', '10', '2017-07-14 02:57:10', NULL, '3', '2017-04-28', '0'),
('2646', '25', '3', '10', '2017-07-14 02:57:10', NULL, '3', '2017-04-28', '0'),
('2647', '20', '27', '10', '2018-01-04 04:20:37', NULL, '3', '2017-04-28', NULL),
('2648', '18', '4', '10', '2017-07-14 03:02:02', NULL, '3', '2017-06-20', '0'),
('2649', '25', '4', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-20', '713'),
('2650', '20', '28', '10', '2018-01-04 04:21:19', NULL, '3', '2017-06-20', NULL),
('2651', '22', '8', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-14', '973'),
('2652', '1', '565', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-14', '974'),
('2653', '1', '566', '10', '2017-11-10 04:47:43', NULL, '3', '2017-07-14', NULL),
('2654', '1', '567', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-14', '975'),
('2655', '12', '174', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1119'),
('2656', '12', '175', '10', '2017-10-19 04:16:48', NULL, '3', '2017-07-31', NULL),
('2657', '12', '176', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '980'),
('2658', '12', '177', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-10', '1233'),
('2659', '12', '178', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-25', '1335'),
('2660', '12', '179', '10', '2017-10-16 06:49:20', NULL, '3', '2017-08-29', NULL),
('2661', '12', '180', '10', '2017-09-04 01:45:48', NULL, '3', '2017-08-25', NULL),
('2662', '12', '81', '10', '2017-07-24 05:51:01', 'Updated.', '3', '2017-08-29', NULL),
('2663', '12', '181', '10', '2017-08-08 05:52:42', NULL, '3', '2017-07-31', NULL),
('2664', '12', '182', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '981'),
('2665', '12', '146', '10', '2017-07-16 23:59:37', 'Voided.\n', '3', '2017-07-16', '0'),
('2666', '12', '147', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-17', '982'),
('2667', '12', '183', '10', '2017-10-19 05:09:52', NULL, '3', '2017-08-14', NULL),
('2668', '12', '184', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '983'),
('2669', '12', '185', '10', '2017-10-19 04:56:30', NULL, '3', '2017-07-03', NULL),
('2670', '11', '29', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '838'),
('2671', '12', '186', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-03', '862'),
('2672', '1', '568', '10', '2017-07-17 04:03:42', NULL, '3', '2017-07-17', NULL),
('2673', '1', '569', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '984'),
('2674', '30', '522', '10', '2017-07-17 03:02:27', NULL, '3', '2017-07-17', '0'),
('2675', '13', '522', '10', '2017-07-17 03:02:27', NULL, '3', '2017-07-17', '0'),
('2676', '10', '522', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '985'),
('2677', '12', '187', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '986'),
('2678', '1', '570', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '987'),
('2679', '1', '571', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '988'),
('2680', '1', '572', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '989'),
('2681', '1', '573', '10', '2017-07-17 04:13:41', NULL, '3', '2017-07-17', NULL),
('2682', '1', '574', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '990'),
('2683', '1', '575', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '991'),
('2684', '1', '568', '10', '2017-07-17 04:03:42', 'Voided.\nDocument reentered.', '3', '2017-07-17', '0'),
('2685', '1', '576', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '992'),
('2686', '1', '577', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '993'),
('2687', '1', '578', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '994'),
('2688', '1', '579', '10', '2018-03-06 23:22:17', NULL, '3', '2017-07-17', NULL),
('2689', '1', '573', '10', '2017-07-17 04:13:41', 'Voided.\nDocument reentered.', '3', '2017-07-17', '0'),
('2690', '1', '580', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '995'),
('2691', '1', '581', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-18', '999'),
('2692', '30', '523', '10', '2017-07-18 04:10:59', NULL, '3', '2017-06-30', '0'),
('2693', '13', '523', '10', '2018-03-17 04:22:05', NULL, '3', '2017-06-30', NULL),
('2694', '10', '523', '10', '2018-01-03 06:16:46', NULL, '3', '2017-06-30', NULL),
('2695', '12', '188', '10', '2018-01-08 05:12:58', NULL, '3', '2017-07-18', NULL),
('2696', '12', '189', '10', '2018-01-03 06:32:32', NULL, '3', '2017-07-19', NULL),
('2697', '4', '23', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-19', '1005'),
('2698', '1', '582', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-19', '1006'),
('2699', '12', '134', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-03-30', '466'),
('2700', '1', '583', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-19', '1007'),
('2701', '1', '584', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-19', '1008'),
('2702', '1', '585', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-19', '1009'),
('2703', '1', '586', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-19', '1010'),
('2704', '16', '10', '10', '2017-07-20 04:34:18', NULL, '3', '2017-07-20', '0'),
('2705', '12', '190', '10', '2018-03-16 06:39:46', NULL, '3', '2017-07-20', NULL),
('2706', '1', '587', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-20', '1015'),
('2707', '4', '24', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-21', '1027'),
('2708', '1', '588', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-21', '1028'),
('2709', '1', '589', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-21', '1029'),
('2710', '1', '590', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-21', '1030'),
('2711', '1', '591', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '880'),
('2712', '1', '592', '10', '2018-03-07 00:47:30', NULL, '3', '2017-06-14', NULL),
('2713', '1', '593', '10', '2018-03-07 00:51:18', NULL, '3', '2017-06-30', NULL),
('2714', '1', '594', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '839'),
('2715', '1', '595', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '840'),
('2716', '1', '596', '10', '2018-03-06 23:34:41', NULL, '3', '2017-07-21', NULL),
('2717', '1', '597', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-21', '1031'),
('2718', '30', '524', '10', '2017-07-21 04:07:49', NULL, '3', '2017-07-24', '0'),
('2719', '13', '524', '10', '2017-07-25 00:06:50', NULL, '3', '2017-07-24', NULL),
('2720', '10', '524', '10', '2017-07-25 00:06:50', NULL, '3', '2017-07-24', NULL),
('2721', '30', '525', '10', '2017-07-21 04:10:17', NULL, '3', '2017-07-24', '0'),
('2722', '13', '525', '10', '2017-07-21 04:10:17', NULL, '3', '2017-07-24', '0'),
('2723', '10', '525', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1049'),
('2724', '30', '526', '10', '2017-07-21 04:12:11', NULL, '3', '2017-07-24', '0'),
('2725', '13', '526', '10', '2017-07-21 04:12:11', NULL, '3', '2017-07-24', '0'),
('2726', '10', '526', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1050'),
('2727', '30', '527', '10', '2017-07-21 04:13:54', NULL, '3', '2017-07-24', '0'),
('2728', '13', '527', '10', '2017-10-03 03:28:55', NULL, '3', '2017-07-24', NULL),
('2729', '10', '527', '10', '2017-10-03 03:28:55', NULL, '3', '2017-07-24', NULL),
('2730', '30', '528', '10', '2017-07-21 04:16:00', NULL, '3', '2017-07-24', '0'),
('2731', '13', '528', '10', '2017-07-21 04:16:00', NULL, '3', '2017-07-24', '0'),
('2732', '10', '528', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1051'),
('2733', '1', '598', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-21', '1032'),
('2734', '1', '599', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-21', '1033'),
('2735', '1', '600', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-20', '1016'),
('2737', '4', '25', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1052'),
('2738', '1', '601', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1053'),
('2739', '1', '602', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1054'),
('2740', '12', '81', '10', '2017-08-15 02:01:38', 'Updated.', '3', '2017-07-27', NULL),
('2741', '1', '603', '10', '2017-07-24 06:02:34', NULL, '3', '2017-07-27', NULL),
('2742', '1', '604', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1055'),
('2743', '1', '603', '10', '2017-07-24 06:02:34', 'Voided.\nDocument reentered.', '3', '2017-07-24', '0'),
('2744', '1', '605', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-23', '1045'),
('2745', '1', '606', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1056'),
('2746', '30', '529', '10', '2017-07-24 23:55:20', NULL, '3', '2017-07-25', '0'),
('2747', '13', '529', '10', '2017-07-24 23:55:20', NULL, '3', '2017-07-25', '0'),
('2748', '10', '529', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-25', '1065'),
('2749', '12', '191', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-25', '1066'),
('2750', '30', '530', '10', '2017-07-25 00:05:51', NULL, '3', '2017-07-24', '0'),
('2751', '13', '530', '10', '2017-07-25 00:05:51', NULL, '3', '2017-07-24', '0'),
('2752', '10', '530', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1057'),
('2753', '13', '524', '10', '2017-07-25 00:06:50', 'Voided.', '3', '2017-07-25', '0'),
('2754', '10', '524', '10', '2017-07-25 00:06:50', 'Voided.\n', '3', '2017-07-25', '0'),
('2755', '18', '5', '10', '2017-07-25 05:16:24', NULL, '3', '2017-06-23', '0'),
('2756', '25', '5', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-23', '751'),
('2757', '20', '29', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-23', '752'),
('2758', '22', '9', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-25', '1067'),
('2759', '1', '607', '10', '2017-07-25 05:48:08', NULL, '3', '2017-07-25', NULL),
('2760', '1', '608', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-25', '1068'),
('2761', '1', '609', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-25', '1069'),
('2762', '1', '607', '10', '2017-07-25 05:48:08', 'Voided.\nDocument reentered.', '3', '2017-07-25', '0'),
('2763', '32', '1', '10', '2017-07-25 05:59:27', NULL, '3', '2017-07-25', '0'),
('2764', '1', '610', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-25', '1070'),
('2765', '30', '531', '10', '2017-07-25 23:28:15', NULL, '3', '2017-07-26', '0'),
('2766', '13', '531', '10', '2017-07-25 23:28:15', NULL, '3', '2017-07-26', '0'),
('2767', '16', '11', '10', '2017-07-26 00:35:37', NULL, '3', '2017-07-26', '0'),
('2768', '1', '611', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-25', '1071'),
('2769', '1', '612', '10', '2017-07-26 05:04:41', NULL, '3', '2017-07-26', NULL),
('2770', '1', '613', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-26', '1077'),
('2771', '1', '614', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-26', '1078'),
('2772', '1', '615', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-26', '1079'),
('2773', '1', '612', '10', '2017-07-26 05:04:41', 'Voided.\nDocument reentered.', '3', '2017-07-26', '0'),
('2774', '4', '26', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-26', '1080'),
('2775', '12', '152', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-08-01', '1148'),
('2776', '1', '616', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1087'),
('2777', '1', '617', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1088'),
('2778', '1', '618', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1089'),
('2779', '1', '619', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1090'),
('2780', '1', '620', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1091'),
('2781', '1', '621', '10', '2017-07-27 03:56:49', NULL, '3', '2017-07-27', NULL),
('2782', '1', '622', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1092'),
('2783', '1', '621', '10', '2017-07-27 03:56:49', 'Voided.\nDocument reentered.', '3', '2017-07-27', '0'),
('2784', '1', '623', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1093'),
('2785', '1', '624', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1094'),
('2786', '1', '625', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1095'),
('2787', '1', '626', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1096'),
('2788', '1', '627', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1097'),
('2789', '1', '628', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1098'),
('2790', '1', '629', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-28', '1106'),
('2791', '1', '630', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-28', '1107'),
('2792', '30', '532', '10', '2017-07-28 02:05:26', NULL, '3', '2017-07-19', '0'),
('2793', '13', '532', '10', '2017-07-28 02:05:26', NULL, '3', '2017-07-19', '0'),
('2794', '10', '531', '10', '2018-01-04 00:47:40', NULL, '3', '2017-07-19', NULL),
('2795', '12', '192', '10', '2018-01-08 05:18:01', NULL, '3', '2017-07-28', NULL),
('2796', '1', '631', '10', '2017-12-18 05:00:50', NULL, '3', '2017-07-28', NULL),
('2797', '1', '632', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-28', '1108'),
('2798', '16', '12', '10', '2017-07-28 04:05:29', NULL, '2', '2017-03-28', '0'),
('2799', '16', '13', '10', '2017-07-28 04:06:40', NULL, '2', '2017-02-23', '0'),
('2800', '16', '14', '10', '2017-07-28 04:07:35', NULL, '2', '2017-03-09', '0'),
('2801', '12', '193', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-26', '1081'),
('2802', '30', '533', '10', '2017-07-30 22:12:38', NULL, '3', '2017-07-31', '0'),
('2803', '13', '533', '10', '2017-07-30 22:12:38', NULL, '3', '2017-07-31', '0'),
('2804', '12', '194', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '125'),
('2805', '1', '633', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1120'),
('2806', '1', '634', '10', '2018-03-06 23:35:50', NULL, '3', '2017-07-31', NULL),
('2807', '1', '635', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-01', '1149'),
('2808', '1', '636', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-01', '1150'),
('2809', '1', '637', '10', '2018-03-06 23:36:32', NULL, '3', '2017-08-01', NULL),
('2810', '1', '638', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1121'),
('2811', '1', '639', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1122'),
('2812', '1', '640', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-02', '1152'),
('2813', '30', '534', '10', '2017-08-01 23:56:51', NULL, '3', '2017-06-28', '0'),
('2814', '13', '534', '10', '2018-03-17 04:22:20', NULL, '3', '2017-06-28', NULL),
('2815', '10', '532', '10', '2018-01-04 00:43:17', NULL, '3', '2017-06-28', NULL),
('2816', '12', '195', '10', '2018-01-08 05:15:18', NULL, '3', '2017-08-02', NULL),
('2817', '10', '367', '10', '2018-03-16 11:13:00', 'Updated.', '3', '2017-04-28', NULL),
('2818', '1', '641', '10', '2018-03-07 00:10:59', NULL, '3', '2017-08-02', NULL),
('2819', '1', '642', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-02', '1153'),
('2820', '1', '643', '10', '2017-10-09 05:08:59', NULL, '3', '2017-08-02', NULL),
('2821', '1', '644', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-02', '1154'),
('2822', '1', '645', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1167'),
('2823', '1', '646', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1168'),
('2824', '1', '647', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1169'),
('2825', '16', '15', '10', '2017-08-03 05:22:45', NULL, '3', '2017-08-03', '0'),
('2826', '4', '27', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1170'),
('2827', '1', '648', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-04', '1196'),
('2828', '1', '649', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1171'),
('2829', '1', '650', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1172'),
('2830', '1', '651', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1173'),
('2831', '1', '652', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1199'),
('2832', '1', '653', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1200'),
('2833', '1', '654', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1201'),
('2834', '20', '30', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-19', '1011'),
('2835', '20', '31', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-11', '945'),
('2836', '20', '32', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-07', '917'),
('2837', '20', '33', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-06', '904'),
('2838', '22', '10', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1202'),
('2839', '20', '34', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-20', '1017'),
('2840', '20', '35', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-05', '895'),
('2841', '22', '11', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1203'),
('2842', '1', '655', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-04', '1197'),
('2843', '1', '656', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1204'),
('2844', '1', '657', '10', '2018-03-06 23:37:08', NULL, '3', '2017-08-08', NULL),
('2845', '1', '658', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1205'),
('2846', '1', '659', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1206'),
('2847', '1', '660', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1207'),
('2848', '1', '661', '10', '2017-08-08 05:21:57', NULL, '3', '2017-08-08', NULL),
('2849', '1', '662', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1208'),
('2850', '1', '661', '10', '2017-08-08 05:21:57', 'Voided.\nDocument reentered.', '3', '2017-08-08', '0'),
('2851', '1', '663', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1209'),
('2852', '12', '196', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-14', '1255'),
('2853', '12', '197', '10', '2017-10-19 04:26:22', NULL, '3', '2017-08-08', NULL),
('2854', '11', '30', '10', '2017-10-20 03:09:04', NULL, '3', '2017-08-08', NULL),
('2855', '12', '198', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1174'),
('2856', '12', '199', '10', '2017-10-19 04:29:54', NULL, '3', '2017-08-03', NULL),
('2857', '12', '200', '10', '2017-10-19 04:22:52', NULL, '3', '2017-08-03', NULL),
('2858', '12', '201', '10', '2017-10-19 04:40:56', NULL, '3', '2017-08-03', NULL),
('2859', '12', '202', '10', '2017-10-19 05:18:00', NULL, '3', '2017-08-03', NULL),
('2860', '12', '203', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1175'),
('2861', '12', '204', '10', '2017-10-19 05:22:58', NULL, '3', '2017-08-03', NULL),
('2862', '11', '31', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1176'),
('2863', '11', '32', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1177'),
('2864', '12', '205', '10', '2017-10-19 04:35:12', NULL, '3', '2017-08-03', NULL),
('2865', '12', '181', '10', '2017-08-08 05:52:42', 'Voided.\nReturned Chq', '3', '2017-08-08', '0'),
('2866', '12', '206', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1210'),
('2867', '12', '207', '10', '2017-08-14 05:25:35', NULL, '3', '2017-08-08', NULL),
('2868', '12', '208', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1211'),
('2869', '12', '209', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1212'),
('2870', '12', '210', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1213'),
('2871', '12', '211', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1278'),
('2872', '12', '212', '10', '2017-08-08 06:05:09', NULL, '3', '2017-08-02', NULL),
('2873', '12', '213', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-02', '1155'),
('2874', '12', '214', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-02', '1156'),
('2875', '12', '215', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-02', '1157'),
('2876', '12', '216', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-02', '1158'),
('2877', '12', '212', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-08-02', '1159'),
('2878', '1', '664', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1214'),
('2879', '1', '665', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1215'),
('2880', '30', '535', '10', '2017-08-09 02:05:52', NULL, '3', '2017-07-06', '0'),
('2881', '13', '535', '10', '2017-08-09 02:05:52', NULL, '3', '2017-07-06', '0'),
('2882', '10', '533', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-06', '905'),
('2883', '30', '536', '10', '2017-08-09 02:07:50', NULL, '3', '2017-07-07', '0'),
('2884', '13', '536', '10', '2017-08-09 02:07:50', NULL, '3', '2017-07-07', '0'),
('2885', '10', '534', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-07', '918'),
('2886', '30', '537', '10', '2017-08-09 02:08:39', NULL, '3', '2017-07-07', '0'),
('2887', '13', '537', '10', '2017-08-09 02:08:39', NULL, '3', '2017-07-07', '0'),
('2888', '10', '535', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-07', '919'),
('2889', '30', '538', '10', '2017-08-09 02:09:31', NULL, '3', '2017-07-11', '0'),
('2890', '13', '538', '10', '2017-08-09 02:09:31', NULL, '3', '2017-07-11', '0'),
('2891', '10', '536', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-11', '946'),
('2892', '30', '539', '10', '2017-08-09 02:24:57', NULL, '3', '2017-07-24', '0'),
('2893', '13', '539', '10', '2017-08-09 02:24:57', NULL, '3', '2017-07-24', '0'),
('2894', '10', '537', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1058'),
('2895', '30', '540', '10', '2017-08-09 02:28:50', NULL, '3', '2017-07-24', '0'),
('2896', '13', '540', '10', '2017-08-09 02:28:50', NULL, '3', '2017-07-24', '0'),
('2897', '10', '538', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1059'),
('2898', '30', '541', '10', '2017-08-09 02:30:49', NULL, '3', '2017-07-24', '0'),
('2899', '13', '541', '10', '2017-08-09 02:30:49', NULL, '3', '2017-07-24', '0'),
('2900', '10', '539', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1060'),
('2901', '30', '542', '10', '2017-08-09 02:48:19', NULL, '3', '2017-07-28', '0'),
('2902', '13', '542', '10', '2017-08-09 02:48:19', NULL, '3', '2017-07-28', '0'),
('2903', '10', '540', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-28', '1109'),
('2904', '30', '543', '10', '2017-08-09 02:51:26', NULL, '3', '2017-07-28', '0'),
('2905', '13', '543', '10', '2017-08-09 02:51:26', NULL, '3', '2017-07-28', '0'),
('2906', '10', '541', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-28', '1110'),
('2907', '30', '544', '10', '2017-08-09 02:55:23', NULL, '3', '2017-07-28', '0'),
('2908', '13', '544', '10', '2017-08-09 02:55:23', NULL, '3', '2017-07-28', '0'),
('2909', '10', '542', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-28', '1111'),
('2910', '30', '545', '10', '2017-08-09 02:56:30', NULL, '3', '2017-07-28', '0'),
('2911', '13', '545', '10', '2017-08-09 02:56:30', NULL, '3', '2017-07-28', '0'),
('2912', '10', '543', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-28', '1112'),
('2913', '30', '546', '10', '2017-08-09 02:57:21', NULL, '3', '2017-07-31', '0'),
('2914', '13', '546', '10', '2017-08-09 02:57:21', NULL, '3', '2017-07-31', '0'),
('2915', '10', '544', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1123'),
('2916', '30', '547', '10', '2017-08-09 02:58:15', NULL, '3', '2017-07-31', '0'),
('2917', '13', '547', '10', '2017-08-09 02:58:15', NULL, '3', '2017-07-31', '0'),
('2918', '10', '545', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1124'),
('2919', '1', '666', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-09', '1222'),
('2920', '30', '548', '10', '2017-08-09 03:39:39', NULL, '3', '2017-08-09', '0'),
('2921', '13', '548', '10', '2018-03-19 03:09:53', NULL, '3', '2017-08-09', NULL),
('2922', '10', '546', '10', '2017-08-09 03:40:31', NULL, '3', '2017-08-09', NULL),
('2923', '10', '546', '10', '2017-08-09 03:41:13', 'Updated.', '3', '2017-08-09', NULL),
('2924', '10', '546', '10', '2018-01-04 00:48:39', 'Updated.', '3', '2017-08-09', NULL),
('2925', '30', '549', '10', '2017-08-09 03:42:23', NULL, '3', '2017-08-09', '0'),
('2926', '13', '549', '10', '2018-03-19 03:12:56', NULL, '3', '2017-08-09', NULL),
('2927', '10', '547', '10', '2018-01-04 00:48:50', NULL, '3', '2017-08-09', NULL),
('2928', '1', '667', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-09', '1223'),
('2929', '1', '668', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-09', '1224'),
('2930', '1', '669', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-09', '1225'),
('2931', '1', '670', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-10', '1234'),
('2932', '4', '28', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-10', '1235'),
('2933', '1', '671', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-10', '1236'),
('2934', '1', '672', '10', '2018-01-04 04:25:34', NULL, '3', '2017-08-10', NULL),
('2935', '1', '673', '10', '2018-03-07 00:11:29', NULL, '3', '2017-08-10', NULL),
('2936', '1', '674', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-10', '1237'),
('2937', '1', '675', '10', '2018-03-07 01:00:25', NULL, '3', '2017-08-10', NULL),
('2938', '1', '676', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-11', '1243'),
('2939', '1', '677', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-11', '1244'),
('2940', '1', '678', '10', '2017-11-10 04:48:11', NULL, '3', '2017-08-11', NULL),
('2941', '1', '679', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-11', '1245'),
('2942', '1', '680', '10', '2017-08-11 02:49:24', NULL, '3', '2017-08-11', NULL),
('2943', '1', '681', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-11', '1246'),
('2944', '1', '680', '10', '2017-08-11 02:49:24', 'Voided.\nDocument reentered.', '3', '2017-08-11', '0'),
('2945', '12', '217', '10', '2018-01-08 05:31:46', NULL, '3', '2017-08-11', NULL),
('2946', '12', '218', '10', '2018-01-08 06:22:09', NULL, '3', '2017-08-11', NULL),
('2947', '1', '682', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-11', '1247'),
('2948', '1', '683', '10', '2017-08-11 05:24:45', NULL, '3', '2017-08-11', NULL),
('2949', '1', '684', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-04', '1198'),
('2950', '1', '683', '10', '2017-08-11 05:24:45', 'Voided.\nDocument reentered.', '3', '2017-08-11', '0'),
('2951', '1', '685', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-14', '1256'),
('2952', '30', '550', '10', '2017-08-14 02:18:19', NULL, '3', '2017-07-04', '0'),
('2953', '13', '550', '10', '2017-08-14 02:18:19', NULL, '3', '2017-07-04', '0'),
('2954', '10', '548', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '881'),
('2955', '30', '551', '10', '2017-08-14 02:22:02', NULL, '3', '2017-07-11', '0'),
('2956', '13', '551', '10', '2017-08-14 02:22:02', NULL, '3', '2017-07-11', '0'),
('2957', '10', '549', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-11', '947'),
('2958', '30', '552', '10', '2017-08-14 02:26:39', NULL, '3', '2017-07-10', '0'),
('2959', '13', '552', '10', '2017-08-14 02:26:39', NULL, '3', '2017-07-10', '0'),
('2960', '10', '550', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '932'),
('2961', '30', '553', '10', '2017-08-14 02:27:46', NULL, '3', '2017-07-11', '0'),
('2962', '13', '553', '10', '2017-08-14 02:27:46', NULL, '3', '2017-07-11', '0'),
('2963', '10', '551', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-11', '948'),
('2964', '30', '554', '10', '2017-08-14 02:31:28', NULL, '3', '2017-07-04', '0'),
('2965', '13', '554', '10', '2017-08-14 02:31:28', NULL, '3', '2017-07-04', '0'),
('2966', '10', '552', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '882'),
('2967', '30', '555', '10', '2017-08-14 03:50:53', NULL, '3', '2017-07-18', '0'),
('2968', '13', '555', '10', '2017-08-14 03:50:53', NULL, '3', '2017-07-18', '0'),
('2969', '10', '553', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-18', '1000'),
('2970', '30', '556', '10', '2017-08-14 04:46:31', NULL, '3', '2017-07-18', '0'),
('2971', '13', '556', '10', '2017-08-14 04:46:31', NULL, '3', '2017-07-18', '0'),
('2972', '10', '554', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-18', '1001'),
('2973', '30', '557', '10', '2017-08-14 04:47:31', NULL, '3', '2017-07-25', '0'),
('2974', '13', '557', '10', '2017-08-14 04:47:31', NULL, '3', '2017-07-25', '0'),
('2975', '10', '555', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-25', '1072'),
('2976', '30', '558', '10', '2017-08-14 04:48:47', NULL, '3', '2017-07-25', '0'),
('2977', '13', '558', '10', '2017-08-14 04:48:47', NULL, '3', '2017-07-25', '0'),
('2978', '10', '556', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-25', '1073'),
('2979', '30', '559', '10', '2017-08-14 04:50:23', NULL, '3', '2017-07-26', '0'),
('2980', '13', '559', '10', '2017-08-14 04:50:23', NULL, '3', '2017-07-26', '0'),
('2981', '10', '557', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-26', '1082'),
('2982', '30', '560', '10', '2017-08-14 04:54:05', NULL, '3', '2017-07-26', '0'),
('2983', '13', '560', '10', '2017-08-14 04:54:05', NULL, '3', '2017-07-26', '0'),
('2984', '10', '558', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-26', '1083'),
('2985', '30', '561', '10', '2017-08-14 04:55:20', NULL, '3', '2017-07-28', '0'),
('2986', '13', '561', '10', '2017-08-14 04:56:19', NULL, '3', '2017-07-28', NULL),
('2987', '10', '559', '10', '2017-08-14 04:56:19', NULL, '3', '2017-07-28', NULL),
('2988', '13', '561', '10', '2017-08-14 04:56:19', 'Voided.', '3', '2017-08-14', '0'),
('2989', '10', '559', '10', '2017-08-14 04:56:19', 'Voided.\n', '3', '2017-08-14', '0'),
('2990', '30', '562', '10', '2017-08-14 04:56:52', NULL, '3', '2017-07-28', '0'),
('2991', '13', '562', '10', '2017-08-14 04:56:52', NULL, '3', '2017-07-28', '0'),
('2992', '10', '560', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-28', '1113'),
('2993', '30', '563', '10', '2017-08-14 05:01:31', NULL, '3', '2017-07-28', '0'),
('2994', '13', '563', '10', '2017-08-14 05:01:31', NULL, '3', '2017-07-28', '0'),
('2995', '10', '561', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-28', '1114'),
('2996', '30', '564', '10', '2017-08-14 05:05:35', NULL, '3', '2017-07-28', '0'),
('2997', '13', '564', '10', '2017-08-14 05:05:35', NULL, '3', '2017-07-28', '0'),
('2998', '10', '562', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-28', '1115'),
('2999', '30', '565', '10', '2017-08-14 05:08:28', NULL, '3', '2017-07-31', '0'),
('3000', '13', '565', '10', '2017-08-14 05:08:28', NULL, '3', '2017-07-31', '0'),
('3001', '10', '563', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1125'),
('3002', '30', '566', '10', '2017-08-14 05:10:55', NULL, '3', '2017-07-31', '0'),
('3003', '13', '566', '10', '2017-08-14 05:10:55', NULL, '3', '2017-07-31', '0'),
('3004', '10', '564', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1126'),
('3005', '12', '207', '10', '2017-08-14 05:25:35', 'Voided.\nCHQ Returned', '3', '2017-08-14', '0'),
('3006', '1', '686', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-14', '1257'),
('3007', '1', '687', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-14', '1258'),
('3008', '1', '688', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1216'),
('3009', '1', '689', '10', '2017-12-06 01:27:12', NULL, '3', '2017-07-31', NULL),
('3010', '1', '690', '10', '2018-03-07 00:55:37', NULL, '3', '2017-07-31', NULL),
('3011', '1', '691', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1127'),
('3012', '1', '692', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1128'),
('3013', '1', '693', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-14', '1259'),
('3014', '12', '81', '10', '2017-10-19 01:24:40', 'Updated.', '3', '2017-07-27', NULL),
('3015', '1', '694', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-15', '1264'),
('3016', '1', '695', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-15', '1265'),
('3017', '1', '696', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-15', '1266'),
('3018', '1', '697', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-15', '1267'),
('3019', '1', '698', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-15', '1268'),
('3020', '30', '567', '10', '2017-08-16 03:13:10', NULL, '3', '2017-07-31', '0'),
('3021', '13', '567', '10', '2017-08-16 03:13:10', NULL, '3', '2017-07-31', '0'),
('3022', '10', '565', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1129'),
('3023', '30', '568', '10', '2017-08-16 03:27:21', NULL, '3', '2017-07-31', '0'),
('3024', '13', '568', '10', '2017-08-16 03:27:21', NULL, '3', '2017-07-31', '0'),
('3025', '10', '566', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1130'),
('3026', '30', '569', '10', '2017-08-16 03:28:15', NULL, '3', '2017-07-31', '0'),
('3027', '13', '569', '10', '2017-08-16 03:28:15', NULL, '3', '2017-07-31', '0'),
('3028', '10', '567', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1131'),
('3029', '30', '570', '10', '2017-08-16 03:32:37', NULL, '3', '2017-07-31', '0'),
('3030', '13', '570', '10', '2018-01-26 01:12:57', NULL, '3', '2017-07-31', NULL),
('3031', '10', '568', '10', '2017-09-19 02:32:42', NULL, '3', '2017-07-31', NULL),
('3032', '1', '699', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-16', '1271'),
('3033', '30', '571', '10', '2017-08-16 04:54:15', NULL, '3', '2017-07-31', '0'),
('3034', '13', '571', '10', '2017-08-16 04:54:15', NULL, '3', '2017-07-31', '0'),
('3035', '10', '569', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1132'),
('3036', '1', '700', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-11', '1248'),
('3037', '1', '701', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-11', '1249'),
('3038', '4', '29', '10', '2017-08-16 23:55:18', NULL, '3', '2017-08-17', '0'),
('3039', '30', '572', '10', '2017-08-17 01:08:56', NULL, '3', '2017-07-31', '0'),
('3040', '13', '572', '10', '2017-08-17 01:08:56', NULL, '3', '2017-07-31', '0'),
('3041', '10', '570', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1133'),
('3042', '4', '30', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-16', '1272'),
('3043', '1', '702', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-17', '1274'),
('3044', '1', '703', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-17', '1275'),
('3045', '18', '6', '10', '2017-08-17 04:18:20', NULL, '3', '2017-08-09', '0'),
('3046', '25', '6', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-09', '1226'),
('3047', '20', '36', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-09', '1227'),
('3048', '18', '7', '10', '2017-08-17 04:19:18', NULL, '3', '2017-08-03', '0'),
('3049', '25', '7', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1178'),
('3050', '20', '37', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1179'),
('3051', '18', '8', '10', '2017-08-17 04:22:01', NULL, '3', '2017-08-03', '0'),
('3052', '25', '8', '10', '2017-08-17 04:22:01', NULL, '3', '2017-08-03', '0'),
('3053', '20', '38', '10', '2018-01-04 04:21:47', NULL, '3', '2017-08-03', NULL),
('3054', '18', '9', '10', '2017-08-17 04:22:53', NULL, '3', '2017-07-25', '0'),
('3055', '25', '9', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-25', '1074'),
('3056', '20', '39', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-25', '1075'),
('3057', '18', '10', '10', '2017-08-17 04:24:07', NULL, '3', '2017-07-18', '0'),
('3058', '25', '10', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-18', '1002'),
('3059', '20', '40', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-18', '1003'),
('3060', '22', '12', '10', '2017-08-17 04:27:33', NULL, '3', '2017-07-18', NULL),
('3061', '22', '12', '10', '2017-08-17 04:27:33', 'Voided.\n', '3', '2017-08-17', '0'),
('3062', '22', '13', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-17', '1276'),
('3063', '12', '219', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-22', '1308'),
('3064', '30', '573', '10', '2017-08-17 23:15:42', NULL, '3', '2017-08-15', '0'),
('3065', '13', '573', '10', '2017-08-17 23:15:42', NULL, '3', '2017-08-15', '0'),
('3066', '10', '571', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-15', '1269'),
('3067', '12', '220', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1279'),
('3068', '12', '221', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1389'),
('3069', '12', '222', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1280'),
('3070', '12', '223', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1281'),
('3071', '12', '224', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-21', '1299'),
('3072', '1', '704', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1282'),
('3073', '1', '705', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1283'),
('3074', '1', '706', '10', '2018-03-06 23:38:08', NULL, '3', '2017-08-18', NULL),
('3075', '4', '31', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1284'),
('3076', '1', '707', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1285'),
('3077', '1', '708', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1286'),
('3078', '1', '709', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1287'),
('3079', '1', '710', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1288'),
('3080', '1', '711', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1289'),
('3081', '1', '712', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1290'),
('3082', '1', '713', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1291'),
('3083', '1', '714', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1292'),
('3084', '1', '715', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-17', '1277'),
('3085', '1', '716', '10', '2018-03-19 10:47:49', NULL, '3', '2017-08-16', NULL),
('3086', '4', '32', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-21', '1300'),
('3087', '1', '717', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-21', '1301'),
('3088', '1', '718', '10', '2017-08-22 02:07:53', NULL, '3', '2017-08-21', NULL),
('3089', '30', '574', '10', '2017-08-21 05:22:30', NULL, '3', '2017-08-21', '0'),
('3090', '13', '574', '10', '2017-08-21 05:22:30', NULL, '3', '2017-08-21', '0'),
('3091', '10', '572', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-21', '1302'),
('3092', '12', '225', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-22', '1309'),
('3093', '12', '226', '10', '2018-01-25 03:29:41', NULL, '3', '2017-08-30', NULL),
('3094', '1', '719', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-22', '1310'),
('3095', '1', '720', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-21', '1303'),
('3096', '1', '718', '10', '2017-08-22 02:07:53', 'Voided.\nDocument reentered.', '3', '2017-08-22', '0'),
('3097', '1', '721', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-22', '1311'),
('3098', '1', '722', '10', '2018-01-08 00:47:39', NULL, '3', '2017-08-21', NULL),
('3099', '1', '723', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-22', '1312'),
('3100', '1', '724', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-22', '1313'),
('3101', '2', '58', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-23', '1319'),
('3102', '12', '227', '10', '2018-03-16 06:52:07', NULL, '3', '2017-08-23', NULL),
('3103', '12', '228', '10', '2018-03-16 06:52:17', NULL, '3', '2017-08-23', NULL),
('3104', '1', '725', '10', '2017-08-23 02:05:13', NULL, '3', '2017-08-23', NULL),
('3105', '1', '726', '10', '2017-09-22 05:40:17', NULL, '3', '2017-08-23', NULL),
('3106', '1', '725', '10', '2017-08-23 02:05:13', 'Voided.\nDocument reentered.', '3', '2017-08-23', '0'),
('3107', '1', '727', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-23', '1320'),
('3108', '1', '728', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-23', '1321'),
('3109', '1', '729', '10', '2017-08-24 01:50:15', NULL, '3', '2017-08-23', NULL),
('3110', '1', '730', '10', '2018-01-04 04:08:09', NULL, '3', '2017-08-23', NULL),
('3111', '1', '731', '10', '2017-09-22 05:32:05', NULL, '3', '2017-08-23', NULL),
('3112', '1', '729', '10', '2017-08-24 01:50:15', 'Voided.\nDocument reentered.', '3', '2017-08-24', '0'),
('3113', '16', '16', '10', '2017-08-24 01:55:30', NULL, '3', '2017-08-23', '0');
INSERT INTO `0_audit_trail` VALUES
('3114', '30', '575', '10', '2017-08-24 02:04:11', NULL, '3', '2017-08-23', '0'),
('3115', '13', '575', '10', '2019-02-13 01:17:25', NULL, '5', '2017-08-23', NULL),
('3116', '10', '573', '10', '2019-02-13 01:17:25', NULL, '5', '2017-08-23', NULL),
('3117', '1', '732', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-24', '1329'),
('3118', '1', '733', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-24', '1330'),
('3119', '1', '734', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-24', '1331'),
('3120', '18', '11', '10', '2017-08-24 06:07:08', NULL, '3', '2017-07-01', '0'),
('3121', '25', '11', '10', '2017-08-24 06:07:09', NULL, '3', '2017-07-01', '0'),
('3122', '20', '41', '10', '2018-01-04 03:29:14', NULL, '3', '2017-07-01', NULL),
('3123', '22', '14', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-24', '1332'),
('3124', '1', '735', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-25', '1336'),
('3125', '1', '736', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-25', '1337'),
('3126', '2', '59', '10', '2018-08-01 08:53:30', NULL, '5', '2017-08-24', NULL),
('3127', '0', '16', '1', '2018-02-05 04:47:11', NULL, '1', '2016-03-31', '82'),
('3129', '1', '737', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-25', '1338'),
('3130', '1', '738', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-25', '1339'),
('3131', '18', '12', '10', '2017-08-25 06:09:15', NULL, '3', '2017-07-21', '0'),
('3132', '25', '12', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-21', '1034'),
('3133', '20', '42', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-21', '1035'),
('3134', '22', '15', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-25', '1340'),
('3135', '1', '739', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1346'),
('3136', '1', '740', '10', '2018-03-07 00:12:55', NULL, '3', '2017-08-28', NULL),
('3137', '1', '741', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1347'),
('3138', '1', '742', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1348'),
('3139', '1', '743', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1349'),
('3140', '1', '744', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1350'),
('3141', '1', '745', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1351'),
('3142', '1', '746', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1352'),
('3143', '1', '747', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1353'),
('3144', '1', '748', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1354'),
('3145', '30', '576', '10', '2017-08-29 00:37:05', NULL, '2', '2016-06-21', '0'),
('3146', '13', '576', '10', '2017-08-29 00:37:06', NULL, '2', '2016-06-21', '0'),
('3147', '10', '574', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-21', '44'),
('3148', '12', '229', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-22', '45'),
('3149', '12', '230', '10', '2019-11-05 05:45:21', NULL, '2', '2016-08-18', '98'),
('3150', '1', '749', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-29', '1368'),
('3151', '1', '750', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-29', '1369'),
('3152', '1', '751', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-29', '1370'),
('3153', '30', '577', '10', '2017-08-29 05:13:52', NULL, '3', '2017-05-31', '0'),
('3154', '13', '577', '10', '2017-08-29 05:13:52', NULL, '3', '2017-05-31', '0'),
('3155', '10', '575', '10', '2017-08-29 05:14:40', NULL, '3', '2017-05-31', NULL),
('3156', '10', '575', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-31', '574'),
('3157', '30', '578', '10', '2017-08-29 05:18:10', NULL, '3', '2017-06-30', '0'),
('3158', '13', '578', '10', '2017-08-29 05:18:11', NULL, '3', '2017-06-30', '0'),
('3159', '10', '576', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '841'),
('3160', '1', '752', '10', '2018-03-06 23:39:10', NULL, '3', '2017-08-29', NULL),
('3161', '1', '753', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-29', '1371'),
('3162', '1', '754', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-30', '1376'),
('3163', '1', '755', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-30', '1377'),
('3164', '1', '756', '10', '2018-03-07 00:13:56', NULL, '3', '2017-08-30', NULL),
('3165', '1', '757', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-30', '1378'),
('3166', '4', '33', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-30', '1379'),
('3167', '16', '17', '10', '2017-08-30 05:00:53', NULL, '3', '2017-08-29', '0'),
('3168', '16', '18', '10', '2017-08-30 05:01:37', NULL, '3', '2017-08-29', '0'),
('3169', '30', '579', '10', '2017-08-30 23:40:28', NULL, '3', '2017-06-30', '0'),
('3170', '13', '579', '10', '2017-08-30 23:42:28', NULL, '3', '2017-06-30', NULL),
('3171', '10', '577', '10', '2017-08-30 23:42:28', NULL, '3', '2017-06-30', NULL),
('3172', '30', '580', '10', '2017-08-30 23:41:29', NULL, '3', '2017-06-30', '0'),
('3173', '13', '580', '10', '2017-08-30 23:41:29', NULL, '3', '2017-06-30', '0'),
('3174', '10', '578', '10', '2018-01-03 06:35:24', NULL, '3', '2017-06-30', NULL),
('3175', '13', '579', '10', '2017-08-30 23:42:28', 'Voided.', '3', '2017-08-30', '0'),
('3176', '10', '577', '10', '2017-08-30 23:42:28', 'Voided.\n', '3', '2017-08-30', '0'),
('3177', '13', '503', '10', '2017-08-30 23:43:09', 'Voided.', '3', '2017-08-30', '0'),
('3178', '10', '504', '10', '2017-08-30 23:43:09', 'Voided.\n', '3', '2017-08-30', '0'),
('3179', '16', '19', '10', '2017-08-31 01:39:42', NULL, '3', '2017-04-18', '0'),
('3180', '1', '758', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1390'),
('3181', '1', '759', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1391'),
('3182', '1', '760', '10', '2017-08-31 03:46:28', NULL, '3', '2017-08-31', NULL),
('3183', '1', '761', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1392'),
('3184', '1', '762', '10', '2018-03-06 23:39:59', NULL, '3', '2017-08-31', NULL),
('3185', '1', '760', '10', '2017-08-31 03:46:28', 'Voided.\nDocument reentered.', '3', '2017-08-31', '0'),
('3186', '1', '763', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1393'),
('3187', '1', '764', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1394'),
('3188', '1', '765', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1395'),
('3189', '1', '766', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1396'),
('3190', '1', '767', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1397'),
('3191', '1', '768', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-01', '1412'),
('3192', '1', '769', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-01', '1413'),
('3193', '1', '770', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-01', '1414'),
('3194', '1', '771', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-01', '1415'),
('3195', '1', '772', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-01', '1416'),
('3196', '1', '773', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-01', '1417'),
('3197', '1', '774', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-01', '1418'),
('3198', '1', '775', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-04', '1421'),
('3199', '1', '776', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-04', '1422'),
('3200', '1', '777', '10', '2017-09-03 23:59:39', NULL, '3', '2017-09-04', NULL),
('3201', '1', '778', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-04', '1423'),
('3202', '1', '777', '10', '2017-09-03 23:59:39', 'Voided.\nDocument reentered.', '3', '2017-09-03', '0'),
('3203', '12', '180', '10', '2017-09-04 01:45:48', 'Voided.\nReturned CHQ', '3', '2017-09-04', '0'),
('3204', '1', '779', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-04', '1424'),
('3205', '1', '780', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-06', '1434'),
('3206', '1', '781', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-06', '1435'),
('3207', '1', '782', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-06', '1436'),
('3208', '1', '783', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-06', '1437'),
('3209', '1', '784', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-06', '1438'),
('3210', '12', '231', '10', '2018-01-03 06:37:06', NULL, '3', '2017-09-06', NULL),
('3211', '1', '785', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-06', '1439'),
('3212', '1', '786', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-06', '1440'),
('3213', '1', '787', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-06', '1441'),
('3214', '1', '788', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-07', '1446'),
('3215', '12', '232', '10', '2017-09-07 05:02:26', NULL, '3', '2017-09-07', NULL),
('3216', '12', '233', '10', '2017-09-11 00:07:11', NULL, '3', '2017-09-07', NULL),
('3217', '12', '232', '10', '2018-01-08 06:22:21', 'Updated.', '3', '2017-09-07', NULL),
('3218', '1', '789', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-08', '1448'),
('3219', '1', '790', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-08', '1449'),
('3220', '1', '791', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-08', '1450'),
('3221', '20', '43', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-19', '1295'),
('3222', '20', '44', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-02', '1160'),
('3223', '22', '16', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-08', '1451'),
('3224', '20', '45', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1355'),
('3225', '20', '46', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1293'),
('3226', '20', '47', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-09', '1228'),
('3227', '20', '48', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-01', '1419'),
('3228', '22', '17', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-08', '1452'),
('3229', '1', '792', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-08', '1453'),
('3230', '1', '793', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-08', '1454'),
('3231', '30', '581', '10', '2017-09-08 04:17:16', NULL, '3', '2017-09-08', '0'),
('3232', '13', '581', '10', '2017-09-08 04:17:16', NULL, '3', '2017-09-08', '0'),
('3233', '4', '34', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-08', '1455'),
('3234', '1', '794', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-08', '1456'),
('3235', '4', '35', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1458'),
('3236', '12', '233', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-07', '1997'),
('3237', '1', '795', '10', '2017-09-11 02:32:28', NULL, '3', '2017-09-11', NULL),
('3238', '1', '796', '10', '2017-09-11 02:30:36', NULL, '3', '2017-09-11', NULL),
('3239', '1', '797', '10', '2017-09-11 02:30:12', NULL, '3', '2017-09-11', NULL),
('3240', '1', '798', '10', '2017-09-11 02:29:45', NULL, '3', '2017-09-11', NULL),
('3241', '1', '799', '10', '2017-09-11 02:29:18', NULL, '3', '2017-09-11', NULL),
('3242', '1', '799', '10', '2017-09-11 02:29:18', 'Voided.\nCHQ Number Issue-Voided by Dilrukshi', '3', '2017-09-11', '0'),
('3243', '1', '798', '10', '2017-09-11 02:29:45', 'Voided.\nCHQ Number Issue-Voided by Dilrukshi', '3', '2017-09-11', '0'),
('3244', '1', '797', '10', '2017-09-11 02:30:12', 'Voided.\nCHQ Number Issue-Voided by Dilrukshi', '3', '2017-09-11', '0'),
('3245', '1', '796', '10', '2017-09-11 02:30:36', 'Voided.\nCHQ Number Issue-Voided by Dilrukshi', '3', '2017-09-11', '0'),
('3246', '1', '795', '10', '2017-09-11 02:32:28', 'Voided.\nCHQ Number Issue-Voided by Dilrukshi', '3', '2017-09-11', '0'),
('3247', '1', '800', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1459'),
('3248', '1', '801', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1460'),
('3249', '1', '802', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1461'),
('3250', '1', '803', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1462'),
('3251', '1', '804', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1463'),
('3252', '10', '579', '10', '2018-01-04 01:02:00', NULL, '3', '2017-09-11', NULL),
('3253', '13', '504', '10', '2017-09-11 03:32:38', 'Voided.', '3', '2017-09-11', '0'),
('3254', '10', '505', '10', '2017-09-11 03:32:38', 'Voided.\nQuantity has changed-Voided by Dilrukshi', '3', '2017-09-11', '0'),
('3255', '30', '582', '10', '2017-09-11 03:33:51', NULL, '3', '2017-06-30', '0'),
('3256', '13', '582', '10', '2017-10-02 02:26:19', NULL, '3', '2017-06-30', NULL),
('3257', '10', '580', '10', '2017-10-02 02:26:19', NULL, '3', '2017-06-30', NULL),
('3258', '2', '60', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1464'),
('3259', '1', '805', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1465'),
('3260', '1', '806', '10', '2017-10-09 05:51:46', NULL, '3', '2017-09-11', NULL),
('3261', '30', '583', '10', '2017-09-12 01:23:58', NULL, '3', '2017-07-31', '0'),
('3262', '13', '583', '10', '2017-09-12 01:23:58', NULL, '3', '2017-07-31', '0'),
('3263', '10', '581', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1134'),
('3264', '30', '584', '10', '2017-09-12 01:26:25', NULL, '3', '2017-08-02', '0'),
('3265', '13', '584', '10', '2017-09-12 01:26:25', NULL, '3', '2017-08-02', '0'),
('3266', '10', '582', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-02', '1161'),
('3267', '1', '807', '10', '2018-03-07 00:14:31', NULL, '3', '2017-09-12', NULL),
('3268', '30', '585', '10', '2017-09-12 02:45:35', NULL, '3', '2017-09-12', '0'),
('3269', '13', '585', '10', '2017-09-12 02:45:35', NULL, '3', '2017-09-12', '0'),
('3270', '10', '583', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1474'),
('3271', '1', '808', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1475'),
('3272', '30', '586', '10', '2017-09-12 03:48:13', NULL, '3', '2017-09-12', '0'),
('3273', '13', '586', '10', '2017-09-12 03:48:13', NULL, '3', '2017-09-12', '0'),
('3274', '10', '584', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1476'),
('3275', '30', '587', '10', '2017-09-12 03:59:23', NULL, '3', '2017-09-12', '0'),
('3276', '13', '587', '10', '2017-09-12 03:59:23', NULL, '3', '2017-09-12', '0'),
('3277', '10', '585', '10', '2017-09-14 00:16:06', NULL, '3', '2017-09-12', NULL),
('3278', '30', '588', '10', '2017-09-12 04:13:00', NULL, '3', '2017-08-02', '0'),
('3279', '13', '588', '10', '2017-09-12 04:13:00', NULL, '3', '2017-08-02', '0'),
('3280', '10', '586', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-02', '1162'),
('3281', '30', '589', '10', '2017-09-12 04:14:07', NULL, '3', '2017-08-11', '0'),
('3282', '13', '589', '10', '2017-09-12 04:14:07', NULL, '3', '2017-08-11', '0'),
('3283', '10', '587', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-11', '1250'),
('3284', '30', '590', '10', '2017-09-12 04:15:06', NULL, '3', '2017-08-11', '0'),
('3285', '13', '590', '10', '2017-09-12 04:15:06', NULL, '3', '2017-08-11', '0'),
('3286', '10', '588', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-11', '1251'),
('3287', '30', '591', '10', '2017-09-12 04:17:08', NULL, '3', '2017-08-14', '0'),
('3288', '13', '591', '10', '2017-09-12 04:17:08', NULL, '3', '2017-08-14', '0'),
('3289', '10', '589', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-14', '1260'),
('3290', '30', '592', '10', '2017-09-12 04:45:36', NULL, '3', '2017-08-15', '0'),
('3291', '13', '592', '10', '2017-09-12 04:45:36', NULL, '3', '2017-08-15', '0'),
('3292', '10', '590', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-15', '1270'),
('3293', '30', '593', '10', '2017-09-12 04:50:06', NULL, '3', '2017-08-25', '0'),
('3294', '13', '593', '10', '2017-09-12 04:50:06', NULL, '3', '2017-08-25', '0'),
('3295', '10', '591', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-25', '1341'),
('3296', '30', '594', '10', '2017-09-12 04:51:30', NULL, '3', '2017-08-25', '0'),
('3297', '13', '594', '10', '2017-09-12 04:51:30', NULL, '3', '2017-08-25', '0'),
('3298', '10', '592', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-25', '1342'),
('3299', '30', '595', '10', '2017-09-12 04:52:31', NULL, '3', '2017-08-25', '0'),
('3300', '13', '595', '10', '2017-09-12 04:54:38', NULL, '3', '2017-08-25', NULL),
('3301', '10', '593', '10', '2017-09-12 04:54:38', NULL, '3', '2017-08-25', NULL),
('3302', '13', '595', '10', '2017-09-12 04:54:38', 'Voided.', '3', '2017-09-12', '0'),
('3303', '10', '593', '10', '2017-09-12 04:54:38', 'Voided.\n', '3', '2017-09-12', '0'),
('3304', '30', '596', '10', '2017-09-12 04:56:35', NULL, '3', '2017-08-25', '0'),
('3305', '13', '596', '10', '2017-09-12 04:56:35', NULL, '3', '2017-08-25', '0'),
('3306', '10', '594', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-25', '1343'),
('3307', '30', '597', '10', '2017-09-12 05:01:13', NULL, '3', '2017-08-25', '0'),
('3308', '13', '597', '10', '2017-09-12 05:01:13', NULL, '3', '2017-08-25', '0'),
('3309', '10', '595', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-25', '1344'),
('3310', '30', '598', '10', '2017-09-12 05:04:13', NULL, '3', '2017-08-25', '0'),
('3311', '13', '598', '10', '2017-09-12 05:04:13', NULL, '3', '2017-08-25', '0'),
('3312', '10', '596', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-25', '1345'),
('3313', '30', '599', '10', '2017-09-12 05:05:16', NULL, '3', '2017-08-28', '0'),
('3314', '13', '599', '10', '2017-09-12 05:05:16', NULL, '3', '2017-08-28', '0'),
('3315', '10', '597', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1356'),
('3316', '30', '600', '10', '2017-09-12 05:08:04', NULL, '3', '2017-08-28', '0'),
('3317', '13', '600', '10', '2017-09-12 05:08:04', NULL, '3', '2017-08-28', '0'),
('3318', '10', '598', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1357'),
('3319', '30', '601', '10', '2017-09-12 05:09:20', NULL, '3', '2017-08-30', '0'),
('3320', '13', '601', '10', '2017-09-12 05:09:20', NULL, '3', '2017-08-30', '0'),
('3321', '10', '599', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-30', '1380'),
('3322', '30', '602', '10', '2017-09-12 05:10:26', NULL, '3', '2017-08-30', '0'),
('3323', '13', '602', '10', '2017-09-12 05:10:26', NULL, '3', '2017-08-30', '0'),
('3324', '10', '600', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-30', '1381'),
('3325', '30', '603', '10', '2017-09-12 05:11:22', NULL, '3', '2017-08-30', '0'),
('3326', '13', '603', '10', '2017-09-12 05:11:22', NULL, '3', '2017-08-30', '0'),
('3327', '10', '601', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-30', '1382'),
('3328', '30', '604', '10', '2017-09-12 05:21:10', NULL, '3', '2017-08-08', '0'),
('3329', '13', '604', '10', '2017-09-12 05:21:10', NULL, '3', '2017-08-08', '0'),
('3330', '10', '602', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1217'),
('3331', '30', '605', '10', '2017-09-12 05:22:59', NULL, '3', '2017-08-14', '0'),
('3332', '13', '605', '10', '2017-09-12 05:22:59', NULL, '3', '2017-08-14', '0'),
('3333', '10', '603', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-14', '1261'),
('3334', '30', '606', '10', '2017-09-12 05:41:01', NULL, '3', '2017-04-28', '0'),
('3335', '13', '606', '10', '2017-09-12 05:41:01', NULL, '3', '2017-04-28', '0'),
('3336', '10', '604', '10', '2018-01-04 03:14:40', NULL, '3', '2017-04-28', NULL),
('3337', '30', '607', '10', '2017-09-12 05:42:25', NULL, '3', '2017-05-31', '0'),
('3338', '13', '607', '10', '2017-09-12 05:42:25', NULL, '3', '2017-05-31', '0'),
('3339', '10', '605', '10', '2018-01-04 03:14:59', NULL, '3', '2017-05-31', NULL),
('3340', '30', '608', '10', '2017-09-12 05:43:34', NULL, '3', '2017-06-30', '0'),
('3341', '13', '608', '10', '2017-09-12 05:43:34', NULL, '3', '2017-06-30', '0'),
('3342', '10', '606', '10', '2018-01-04 03:15:09', NULL, '3', '2017-06-30', NULL),
('3343', '13', '162', '10', '2017-09-12 06:00:00', 'Voided.', '3', '2017-09-12', '0'),
('3344', '10', '165', '10', '2017-09-12 06:00:00', 'Voided.\n', '3', '2017-09-12', '0'),
('3345', '30', '609', '10', '2017-09-12 06:01:08', NULL, '3', '2017-07-31', '0'),
('3346', '13', '609', '10', '2017-09-12 06:01:08', NULL, '3', '2017-07-31', '0'),
('3347', '10', '607', '10', '2018-01-04 03:15:18', NULL, '3', '2017-07-31', NULL),
('3348', '12', '234', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1477'),
('3349', '30', '610', '10', '2017-09-12 06:19:46', NULL, '3', '2017-08-31', '0'),
('3350', '13', '610', '10', '2017-09-12 06:19:46', NULL, '3', '2017-08-31', '0'),
('3351', '10', '608', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1398'),
('3352', '1', '809', '10', '2019-11-05 05:45:21', NULL, '2', '2016-11-18', '175'),
('3353', '20', '49', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-02', '307'),
('3354', '20', '50', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-06', '311'),
('3355', '20', '51', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-21', '340'),
('3356', '22', '18', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-06', '380'),
('3357', '4', '36', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '247'),
('3358', '30', '611', '10', '2017-09-13 00:30:13', NULL, '2', '2017-02-28', '0'),
('3359', '13', '611', '10', '2017-09-13 00:30:13', NULL, '2', '2017-02-28', '0'),
('3360', '10', '609', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '369'),
('3361', '12', '235', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-25', '216'),
('3362', '30', '612', '10', '2017-09-13 00:33:30', NULL, '2', '2017-01-31', '0'),
('3363', '13', '612', '10', '2017-09-13 00:35:11', NULL, '3', '2017-01-31', NULL),
('3364', '10', '610', '10', '2017-09-13 00:35:11', NULL, '3', '2017-01-31', NULL),
('3365', '12', '236', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-24', '200'),
('3366', '13', '612', '10', '2017-09-13 00:35:11', 'Voided.', '3', '2017-09-13', '0'),
('3367', '10', '610', '10', '2017-09-13 00:35:11', 'Voided.\nDuplicate Invoice for Jan 2017', '3', '2017-09-13', '0'),
('3368', '1', '810', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-26', '221'),
('3369', '1', '811', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-26', '222'),
('3370', '1', '812', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '248'),
('3371', '1', '813', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '249'),
('3372', '1', '814', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '250'),
('3373', '1', '815', '10', '2017-09-13 02:26:22', NULL, '3', '2017-04-27', NULL),
('3374', '1', '816', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '251'),
('3375', '1', '817', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-30', '288'),
('3376', '12', '237', '10', '2017-10-19 01:24:25', NULL, '3', '2017-05-18', NULL),
('3377', '12', '238', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-01', '293'),
('3378', '30', '613', '10', '2017-09-13 01:49:57', NULL, '2', '2017-02-22', '0'),
('3379', '13', '613', '10', '2017-09-13 01:49:57', NULL, '2', '2017-02-22', '0'),
('3380', '10', '611', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-22', '343'),
('3381', '12', '239', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '278'),
('3382', '30', '614', '10', '2017-09-13 01:54:42', NULL, '1', '2016-01-18', '0'),
('3383', '13', '614', '10', '2017-09-13 01:54:42', NULL, '1', '2016-01-18', '0'),
('3384', '10', '612', '10', '2018-02-05 04:47:11', NULL, '1', '2016-01-18', '53'),
('3385', '12', '240', '10', '2017-10-19 04:40:49', NULL, '3', '2017-04-28', NULL),
('3386', '30', '615', '10', '2017-09-13 02:00:52', NULL, '2', '2016-07-01', '0'),
('3387', '13', '615', '10', '2017-09-13 02:00:52', NULL, '2', '2016-07-01', '0'),
('3388', '10', '613', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-01', '58'),
('3389', '11', '33', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-10', '256'),
('3390', '11', '34', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-23', '345'),
('3391', '12', '241', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-06', '113'),
('3392', '30', '616', '10', '2017-09-13 02:10:07', NULL, '2', '2016-07-22', '0'),
('3393', '13', '616', '10', '2017-09-13 02:10:07', NULL, '2', '2016-07-22', '0'),
('3394', '10', '614', '10', '2019-11-05 05:45:21', NULL, '2', '2016-07-22', '71'),
('3395', '12', '242', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '341'),
('3396', '1', '818', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '320'),
('3397', '1', '819', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '528'),
('3398', '1', '820', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '529'),
('3399', '1', '821', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '530'),
('3400', '1', '822', '10', '2017-11-10 04:47:12', NULL, '3', '2017-05-26', NULL),
('3401', '1', '823', '10', '2017-11-10 04:46:32', NULL, '3', '2017-04-27', NULL),
('3402', '1', '815', '10', '2017-09-13 02:26:22', 'Voided.\nDocument reentered.', '3', '2017-09-13', '0'),
('3403', '1', '824', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '531'),
('3404', '1', '825', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '532'),
('3405', '1', '826', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '575'),
('3406', '4', '37', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-09', '377'),
('3407', '4', '38', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '533'),
('3408', '1', '827', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-13', '1497'),
('3409', '1', '828', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-13', '1498'),
('3410', '1', '829', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-13', '1499'),
('3411', '1', '830', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-13', '1500'),
('3412', '30', '617', '10', '2017-09-13 03:20:12', NULL, '3', '2017-08-31', '0'),
('3413', '13', '617', '10', '2017-09-13 03:20:12', NULL, '3', '2017-08-31', '0'),
('3414', '10', '615', '10', '2018-01-04 03:15:28', NULL, '3', '2017-08-31', NULL),
('3415', '0', '18', '1', '2017-12-11 05:07:39', NULL, '3', '2017-03-31', NULL),
('3416', '1', '831', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-13', '1501'),
('3417', '1', '832', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1466'),
('3418', '2', '61', '1', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '467'),
('3419', '10', '585', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-08-30', '1383'),
('3420', '30', '618', '10', '2017-09-14 00:20:22', NULL, '3', '2017-08-31', '0'),
('3421', '13', '618', '10', '2017-09-27 00:49:54', NULL, '3', '2017-08-31', NULL),
('3422', '10', '616', '10', '2017-09-27 00:48:11', NULL, '3', '2017-08-31', NULL),
('3423', '1', '833', '10', '2017-09-14 01:01:37', NULL, '3', '2017-09-14', NULL),
('3424', '1', '834', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-14', '1502'),
('3425', '1', '833', '10', '2017-09-14 01:01:37', 'Voided.\nDocument reentered.', '3', '2017-09-14', '0'),
('3426', '1', '835', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-14', '1503'),
('3427', '1', '836', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-14', '1504'),
('3428', '1', '837', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-14', '1505'),
('3429', '1', '838', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1511'),
('3430', '1', '839', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1512'),
('3431', '1', '840', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1513'),
('3432', '4', '39', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1514'),
('3433', '1', '841', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1515'),
('3434', '1', '842', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1516'),
('3435', '12', '243', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1517'),
('3436', '12', '244', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1478'),
('3437', '12', '245', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-22', '1580'),
('3438', '12', '246', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1518'),
('3439', '12', '247', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1519'),
('3440', '12', '248', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1520'),
('3441', '12', '249', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1521'),
('3442', '12', '250', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1649'),
('3443', '12', '251', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1522'),
('3444', '12', '252', '10', '2017-10-24 04:13:40', NULL, '3', '2017-09-18', NULL),
('3445', '12', '253', '10', '2017-09-15 03:13:25', NULL, '3', '2017-10-16', NULL),
('3446', '12', '254', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1776'),
('3447', '12', '253', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-14', '1506'),
('3448', '12', '255', '10', '2018-02-08 01:25:55', NULL, '3', '2017-09-15', NULL),
('3449', '12', '256', '10', '2017-10-16 06:41:41', NULL, '3', '2017-09-14', NULL),
('3450', '12', '257', '10', '2017-11-17 03:54:08', NULL, '3', '2017-11-10', NULL),
('3451', '12', '258', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-10', '2038'),
('3452', '1', '843', '10', '2018-03-07 01:04:08', NULL, '3', '2017-09-14', NULL),
('3453', '1', '844', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-14', '1507'),
('3454', '12', '259', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1523'),
('3455', '12', '260', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1650'),
('3456', '12', '261', '10', '2017-09-15 04:00:09', NULL, '3', '2017-09-22', NULL),
('3457', '12', '261', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-22', '1581'),
('3458', '1', '845', '10', '2017-09-20 05:48:41', NULL, '3', '2017-09-15', NULL),
('3459', '1', '846', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1524'),
('3460', '30', '619', '10', '2017-09-18 00:00:14', NULL, '3', '2017-08-31', '0'),
('3461', '13', '619', '10', '2017-09-18 00:00:14', NULL, '3', '2017-08-31', '0'),
('3462', '10', '617', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1399'),
('3463', '30', '620', '10', '2017-09-18 00:03:49', NULL, '3', '2017-08-31', '0'),
('3464', '13', '620', '10', '2017-12-07 00:15:35', NULL, '3', '2017-08-31', NULL),
('3465', '10', '618', '10', '2017-10-12 00:20:21', NULL, '3', '2017-08-31', NULL),
('3466', '30', '621', '10', '2017-09-18 00:33:48', NULL, '3', '2017-09-06', '0'),
('3467', '13', '621', '10', '2017-09-18 00:33:48', NULL, '3', '2017-09-06', '0'),
('3468', '10', '619', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-06', '1442'),
('3469', '30', '622', '10', '2017-09-18 00:34:43', NULL, '3', '2017-09-08', '0'),
('3470', '13', '622', '10', '2017-09-18 00:35:27', NULL, '3', '2017-09-08', NULL),
('3471', '10', '620', '10', '2017-09-18 00:35:27', NULL, '3', '2017-09-08', NULL),
('3472', '13', '622', '10', '2017-09-18 00:35:27', 'Voided.', '3', '2017-09-18', '0'),
('3473', '10', '620', '10', '2017-09-18 00:35:27', 'Voided.\n', '3', '2017-09-18', '0'),
('3474', '30', '623', '10', '2017-09-18 00:36:11', NULL, '3', '2017-09-08', '0'),
('3475', '13', '623', '10', '2017-09-18 00:36:11', NULL, '3', '2017-09-08', '0'),
('3476', '10', '621', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-08', '1457'),
('3477', '30', '624', '10', '2017-09-18 00:37:01', NULL, '3', '2017-09-14', '0'),
('3478', '13', '624', '10', '2017-09-18 00:37:01', NULL, '3', '2017-09-14', '0'),
('3479', '10', '622', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-14', '1508'),
('3480', '12', '262', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-04', '1425'),
('3481', '12', '263', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-04', '1426'),
('3482', '12', '264', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-04', '1427'),
('3483', '12', '265', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '933'),
('3484', '12', '266', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '934'),
('3485', '12', '267', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '935'),
('3486', '12', '268', '10', '2017-10-24 04:10:51', NULL, '3', '2017-07-10', NULL),
('3487', '12', '269', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '936'),
('3488', '12', '270', '10', '2017-10-24 03:25:40', NULL, '3', '2017-07-10', NULL),
('3489', '12', '271', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '937'),
('3490', '12', '272', '10', '2017-10-24 04:17:33', NULL, '3', '2017-07-10', NULL),
('3491', '12', '273', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-04', '1428'),
('3492', '12', '274', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-04', '1429'),
('3493', '12', '275', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-04', '1430'),
('3494', '1', '847', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-18', '1532'),
('3495', '1', '848', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-18', '1533'),
('3496', '1', '849', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-18', '1534'),
('3497', '1', '850', '10', '2017-09-18 02:19:19', NULL, '3', '2017-09-18', NULL),
('3498', '1', '851', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-18', '1535'),
('3499', '1', '850', '10', '2017-09-18 02:19:19', 'Voided.\nDocument reentered.', '3', '2017-09-18', '0'),
('3500', '30', '625', '10', '2017-09-18 02:23:05', NULL, '3', '2017-09-18', '0'),
('3501', '13', '625', '10', '2017-09-18 02:23:05', NULL, '3', '2017-09-18', '0'),
('3502', '10', '623', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-18', '1536'),
('3503', '1', '852', '10', '2017-09-28 00:13:20', NULL, '3', '2017-09-18', NULL),
('3504', '1', '853', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-18', '1537'),
('3505', '1', '854', '10', '2018-03-07 00:18:23', NULL, '3', '2017-09-18', NULL),
('3506', '1', '855', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1525'),
('3507', '1', '856', '10', '2017-09-18 02:59:40', NULL, '3', '2017-09-18', NULL),
('3508', '1', '857', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-18', '1538'),
('3509', '1', '858', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-18', '1539'),
('3510', '1', '856', '10', '2017-09-18 02:59:40', 'Voided.\nDocument reentered.', '3', '2017-09-18', '0'),
('3511', '1', '859', '10', '2018-03-07 01:04:44', NULL, '3', '2017-09-18', NULL),
('3512', '1', '860', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-18', '1540'),
('3513', '1', '861', '10', '2017-09-18 04:30:40', NULL, '3', '2017-09-18', NULL),
('3514', '1', '862', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-18', '1541'),
('3515', '1', '861', '10', '2017-09-18 04:30:40', 'Voided.\nDocument reentered.', '3', '2017-09-18', '0'),
('3516', '30', '626', '10', '2017-09-18 05:01:15', NULL, '3', '2017-09-18', '0'),
('3517', '13', '626', '10', '2017-09-18 05:01:16', NULL, '3', '2017-09-18', '0'),
('3518', '10', '624', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-18', '1542'),
('3519', '13', '115', '10', '2017-09-18 05:43:32', 'Voided.', '3', '2017-09-18', '0'),
('3520', '10', '118', '10', '2017-09-18 05:43:32', 'Voided.\n', '3', '2017-09-18', '0'),
('3521', '30', '627', '10', '2017-09-18 05:43:39', NULL, '2', '2016-10-04', '0'),
('3522', '13', '627', '10', '2017-09-18 05:43:39', NULL, '2', '2016-10-04', '0'),
('3523', '10', '625', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-04', '142'),
('3524', '12', '276', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1479'),
('3525', '12', '277', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1480'),
('3526', '12', '278', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1481'),
('3527', '12', '279', '10', '2017-10-19 04:35:22', NULL, '3', '2017-09-12', NULL),
('3528', '12', '280', '10', '2017-10-19 05:18:08', NULL, '3', '2017-09-12', NULL),
('3529', '12', '281', '10', '2017-10-19 04:50:36', NULL, '3', '2017-09-12', NULL),
('3530', '12', '282', '10', '2017-10-19 04:35:30', NULL, '3', '2017-09-12', NULL),
('3531', '12', '283', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1482'),
('3532', '11', '35', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1483'),
('3533', '11', '36', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1484'),
('3534', '11', '37', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1485'),
('3535', '30', '628', '10', '2017-09-18 06:06:56', NULL, '2', '2017-03-23', '0'),
('3536', '13', '628', '10', '2017-09-18 06:06:56', NULL, '2', '2017-03-23', '0'),
('3537', '10', '626', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-23', '428'),
('3538', '11', '38', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1486'),
('3539', '11', '39', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1487'),
('3540', '10', '484', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-01-31', '302'),
('3541', '10', '485', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-03-31', '489'),
('3542', '30', '629', '10', '2017-09-18 23:50:05', NULL, '3', '2017-08-14', '0'),
('3543', '13', '629', '10', '2017-09-18 23:50:05', NULL, '3', '2017-08-14', '0'),
('3544', '10', '627', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-14', '1262'),
('3545', '30', '630', '10', '2017-09-18 23:53:58', NULL, '3', '2017-08-31', '0'),
('3546', '13', '630', '10', '2017-09-18 23:53:58', NULL, '3', '2017-08-31', '0'),
('3547', '10', '628', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1400'),
('3548', '30', '631', '10', '2017-09-18 23:58:51', NULL, '3', '2017-08-30', '0'),
('3549', '13', '631', '10', '2017-09-18 23:58:51', NULL, '3', '2017-08-30', '0'),
('3550', '10', '629', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-30', '1384'),
('3551', '30', '632', '10', '2017-09-19 00:03:46', NULL, '3', '2017-08-31', '0'),
('3552', '13', '632', '10', '2017-09-19 00:03:46', NULL, '3', '2017-08-31', '0'),
('3553', '10', '630', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1401'),
('3554', '30', '633', '10', '2017-09-19 00:09:24', NULL, '3', '2017-08-21', '0'),
('3555', '13', '633', '10', '2017-09-19 00:09:24', NULL, '3', '2017-08-21', '0'),
('3556', '10', '631', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-21', '1304'),
('3557', '30', '634', '10', '2017-09-19 00:10:26', NULL, '3', '2017-08-31', '0'),
('3558', '13', '634', '10', '2017-09-19 00:10:26', NULL, '3', '2017-08-31', '0'),
('3559', '10', '632', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1402'),
('3560', '30', '635', '10', '2017-09-19 00:27:35', NULL, '2', '2016-05-19', '0'),
('3561', '13', '635', '10', '2017-09-19 00:27:35', NULL, '2', '2016-05-19', '0'),
('3562', '10', '633', '10', '2019-11-05 05:45:21', NULL, '2', '2016-05-19', '16'),
('3563', '12', '284', '10', '2017-10-19 04:37:11', NULL, '3', '2017-08-08', NULL),
('3564', '30', '636', '10', '2017-09-19 00:33:30', NULL, '2', '2016-09-23', '0'),
('3565', '13', '636', '10', '2017-09-19 00:33:30', NULL, '2', '2016-09-23', '0'),
('3566', '10', '634', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-23', '130'),
('3567', '11', '40', '10', '2017-10-20 03:14:24', NULL, '3', '2017-08-03', NULL),
('3568', '11', '41', '10', '2017-10-20 03:14:31', NULL, '3', '2017-08-03', NULL),
('3569', '11', '42', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-15', '196'),
('3570', '12', '285', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-09', '390'),
('3571', '30', '637', '10', '2017-09-19 01:19:00', NULL, '3', '2017-06-22', '0'),
('3572', '13', '637', '10', '2017-09-19 01:19:50', NULL, '3', '2017-06-22', NULL),
('3573', '10', '635', '10', '2017-09-19 01:19:50', NULL, '3', '2017-06-22', NULL),
('3574', '13', '637', '10', '2017-09-19 01:19:50', 'Voided.', '3', '2017-09-19', '0'),
('3575', '10', '635', '10', '2017-09-19 01:19:50', 'Voided.\n', '3', '2017-09-19', '0'),
('3576', '30', '638', '10', '2017-09-19 01:30:24', NULL, '3', '2017-06-22', '0'),
('3577', '13', '638', '10', '2017-09-19 01:30:24', NULL, '3', '2017-06-22', '0'),
('3578', '10', '636', '10', '2019-02-13 01:55:22', NULL, '3', '2017-06-22', NULL),
('3579', '30', '639', '10', '2017-09-19 01:31:51', NULL, '3', '2017-06-26', '0'),
('3580', '13', '639', '10', '2017-09-19 01:35:16', NULL, '3', '2017-06-26', NULL),
('3581', '10', '637', '10', '2017-09-19 01:35:16', NULL, '3', '2017-06-26', NULL),
('3582', '13', '639', '10', '2017-09-19 01:35:16', 'Voided.', '3', '2017-09-19', '0'),
('3583', '10', '637', '10', '2017-09-19 01:35:16', 'Voided.\n', '3', '2017-09-19', '0'),
('3584', '30', '640', '10', '2017-09-19 01:35:55', NULL, '3', '2017-06-26', '0'),
('3585', '13', '640', '10', '2017-09-19 01:35:55', NULL, '3', '2017-06-26', '0'),
('3586', '10', '638', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-26', '769'),
('3587', '30', '641', '10', '2017-09-19 01:39:47', NULL, '3', '2017-06-30', '0'),
('3588', '13', '641', '10', '2017-09-19 01:39:47', NULL, '3', '2017-06-30', '0'),
('3589', '10', '639', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '842'),
('3590', '30', '642', '10', '2017-09-19 01:42:04', NULL, '3', '2017-06-22', '0'),
('3591', '13', '642', '10', '2017-09-19 01:42:04', NULL, '3', '2017-06-22', '0'),
('3592', '10', '640', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-22', '732'),
('3593', '30', '643', '10', '2017-09-19 01:43:06', NULL, '3', '2017-06-22', '0'),
('3594', '13', '643', '10', '2017-09-19 01:43:06', NULL, '3', '2017-06-22', '0'),
('3595', '10', '641', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-22', '733'),
('3596', '30', '644', '10', '2017-09-19 01:46:26', NULL, '3', '2017-07-19', '0'),
('3597', '13', '644', '10', '2017-09-19 01:46:26', NULL, '3', '2017-07-19', '0'),
('3598', '10', '642', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-19', '1012'),
('3599', '30', '645', '10', '2017-09-19 01:48:01', NULL, '3', '2017-07-20', '0'),
('3600', '13', '645', '10', '2017-09-19 01:48:01', NULL, '3', '2017-07-20', '0'),
('3601', '10', '643', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-20', '1018'),
('3602', '30', '646', '10', '2017-09-19 01:52:09', NULL, '3', '2017-07-21', '0'),
('3603', '13', '646', '10', '2017-09-19 01:52:09', NULL, '3', '2017-07-21', '0'),
('3604', '10', '644', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-21', '1036'),
('3605', '30', '647', '10', '2017-09-19 01:56:02', NULL, '3', '2017-07-21', '0'),
('3606', '13', '647', '10', '2017-09-19 01:56:02', NULL, '3', '2017-07-21', '0'),
('3607', '10', '645', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-21', '1037'),
('3608', '30', '648', '10', '2017-09-19 02:08:34', NULL, '3', '2017-07-21', '0'),
('3609', '13', '648', '10', '2017-09-19 02:08:34', NULL, '3', '2017-07-21', '0'),
('3610', '10', '646', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-21', '1038'),
('3611', '30', '649', '10', '2017-09-19 02:10:04', NULL, '3', '2017-07-27', '0'),
('3612', '13', '649', '10', '2017-09-19 02:10:04', NULL, '3', '2017-07-27', '0'),
('3613', '10', '647', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1099'),
('3614', '30', '650', '10', '2017-09-19 02:11:03', NULL, '3', '2017-07-31', '0'),
('3615', '13', '650', '10', '2017-09-19 02:11:03', NULL, '3', '2017-07-31', '0'),
('3616', '10', '648', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1135'),
('3617', '30', '651', '10', '2017-09-19 02:13:07', NULL, '3', '2017-07-31', '0'),
('3618', '13', '651', '10', '2017-09-19 02:13:07', NULL, '3', '2017-07-31', '0'),
('3619', '10', '649', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1136'),
('3620', '10', '568', '10', '2017-10-17 06:02:08', 'Updated.', '3', '2017-09-19', NULL),
('3621', '4', '40', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-19', '1548'),
('3622', '1', '863', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-19', '1549'),
('3623', '30', '652', '10', '2017-09-19 03:58:48', NULL, '3', '2017-09-19', '0'),
('3624', '13', '652', '10', '2017-09-19 03:58:48', NULL, '3', '2017-09-19', '0'),
('3625', '10', '650', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-19', '1550'),
('3626', '30', '653', '10', '2017-09-19 04:02:04', NULL, '3', '2017-09-19', '0'),
('3627', '13', '653', '10', '2017-09-19 04:02:04', NULL, '3', '2017-09-19', '0'),
('3628', '10', '651', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-19', '1551'),
('3629', '16', '20', '10', '2017-09-19 05:54:54', NULL, '3', '2017-09-15', '0'),
('3630', '1', '864', '10', '2017-11-10 04:48:47', NULL, '3', '2017-09-19', NULL),
('3631', '1', '865', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-19', '1552'),
('3632', '30', '654', '10', '2017-09-20 03:52:31', NULL, '3', '2017-09-19', '0'),
('3633', '13', '654', '10', '2017-09-20 03:52:31', NULL, '3', '2017-09-19', '0'),
('3634', '1', '866', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-20', '1560'),
('3635', '1', '867', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-20', '1561'),
('3636', '1', '868', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1526'),
('3637', '1', '845', '10', '2017-09-20 05:48:41', 'Voided.\nDocument reentered.', '3', '2017-09-20', '0'),
('3638', '1', '869', '10', '2018-03-07 00:18:49', NULL, '3', '2017-09-20', NULL),
('3639', '30', '655', '10', '2017-09-21 01:10:42', NULL, '3', '2017-09-21', '0'),
('3640', '13', '655', '10', '2017-09-21 01:10:42', NULL, '3', '2017-09-21', '0'),
('3641', '10', '652', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-21', '1573'),
('3642', '1', '870', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-19', '1553'),
('3643', '1', '871', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-21', '1574'),
('3644', '1', '872', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-21', '1575'),
('3645', '1', '873', '10', '2018-01-04 04:08:45', NULL, '3', '2017-09-20', NULL),
('3646', '1', '874', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-21', '1576'),
('3647', '1', '875', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-21', '1577'),
('3648', '30', '656', '10', '2017-09-22 01:21:04', NULL, '3', '2017-09-22', '0'),
('3649', '13', '656', '10', '2017-09-22 01:21:04', NULL, '3', '2017-09-22', '0'),
('3650', '10', '653', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-22', '1582'),
('3651', '1', '876', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-22', '1583'),
('3652', '1', '877', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-22', '1584'),
('3653', '1', '878', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-22', '1585'),
('3654', '1', '879', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-22', '1586'),
('3655', '1', '880', '10', '2018-03-06 23:40:52', NULL, '3', '2017-09-22', NULL),
('3656', '1', '881', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-22', '1587'),
('3657', '1', '882', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-22', '1588'),
('3658', '1', '883', '1', '2017-09-22 05:36:51', NULL, '3', '2017-08-23', NULL),
('3659', '1', '731', '1', '2017-09-22 05:32:05', 'Voided.\nDocument reentered.', '3', '2017-09-22', '0'),
('3660', '1', '884', '1', '2020-01-22 05:35:45', NULL, '3', '2017-08-23', '1322'),
('3661', '1', '883', '1', '2017-09-22 05:36:51', 'Voided.\nDocument reentered.', '3', '2017-09-22', '0'),
('3662', '1', '885', '1', '2017-09-22 05:45:18', NULL, '3', '2017-08-23', NULL),
('3663', '1', '726', '1', '2017-09-22 05:40:17', 'Voided.\nDocument reentered.', '3', '2017-09-22', '0'),
('3664', '1', '886', '1', '2020-01-22 05:35:45', NULL, '3', '2017-08-23', '1323'),
('3665', '1', '885', '1', '2017-09-22 05:45:18', 'Voided.\nDocument reentered.', '3', '2017-09-22', '0'),
('3666', '18', '13', '1', '2017-09-22 05:59:04', NULL, '3', '2017-09-22', '0'),
('3667', '25', '13', '1', '2020-01-22 05:35:45', NULL, '3', '2017-09-22', '1589'),
('3668', '20', '52', '1', '2017-10-04 04:25:05', NULL, '3', '2017-09-22', NULL),
('3669', '22', '19', '1', '2017-10-04 03:11:21', NULL, '3', '2017-09-22', NULL),
('3670', '1', '887', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-22', '1590'),
('3671', '18', '14', '1', '2017-09-23 08:29:58', NULL, '3', '2017-09-23', '0'),
('3672', '25', '14', '1', '2020-01-22 05:35:45', NULL, '3', '2017-09-23', '1597'),
('3673', '20', '53', '1', '2017-10-04 04:24:46', NULL, '3', '2017-09-23', NULL),
('3674', '1', '888', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-25', '1602'),
('3675', '1', '889', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-25', '1603'),
('3676', '1', '890', '10', '2018-03-06 23:44:37', NULL, '3', '2017-09-25', NULL),
('3677', '4', '41', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-25', '1604'),
('3678', '1', '891', '10', '2017-09-25 06:07:47', NULL, '3', '2017-09-25', NULL),
('3679', '1', '892', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-25', '1605'),
('3680', '1', '893', '10', '2017-09-25 04:45:50', NULL, '3', '2017-09-25', NULL),
('3681', '1', '894', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-25', '1606'),
('3682', '1', '893', '10', '2017-09-25 04:45:50', 'Voided.\nDocument reentered.', '3', '2017-09-25', '0'),
('3683', '1', '895', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-25', '1607'),
('3684', '1', '896', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-25', '1608'),
('3685', '1', '891', '10', '2017-09-25 06:07:47', 'Voided.\nDocument reentered.', '3', '2017-09-25', '0'),
('3686', '1', '897', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-26', '1614'),
('3687', '30', '657', '10', '2017-09-26 05:24:00', NULL, '3', '2017-09-20', '0'),
('3688', '13', '657', '10', '2017-09-26 05:24:00', NULL, '3', '2017-09-20', '0'),
('3689', '10', '654', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-20', '1562'),
('3690', '12', '286', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-25', '1609'),
('3691', '1', '898', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-26', '1615'),
('3692', '30', '658', '10', '2017-09-26 05:44:11', NULL, '3', '2017-09-26', '0'),
('3693', '13', '658', '10', '2017-09-26 05:44:11', NULL, '3', '2017-09-26', '0'),
('3694', '10', '655', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-26', '1616'),
('3695', '1', '899', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-26', '1617'),
('3696', '30', '659', '10', '2017-09-26 06:05:29', NULL, '3', '2017-07-05', '0'),
('3697', '13', '659', '10', '2017-09-26 06:05:29', NULL, '3', '2017-07-05', '0'),
('3698', '10', '656', '10', '2018-01-04 00:46:40', NULL, '3', '2017-07-05', NULL),
('3699', '12', '287', '10', '2018-01-08 05:38:44', NULL, '3', '2017-09-26', NULL),
('3700', '16', '21', '10', '2017-09-26 06:16:12', NULL, '3', '2017-09-26', '0'),
('3701', '10', '616', '10', '2017-09-27 00:49:54', 'Updated.', '3', '2017-08-31', NULL),
('3702', '13', '618', '10', '2017-09-27 00:49:54', 'Voided.', '3', '2017-09-27', '0'),
('3703', '10', '616', '10', '2017-09-27 00:49:54', 'Voided.\n', '3', '2017-09-27', '0'),
('3704', '30', '660', '10', '2017-09-27 00:50:33', NULL, '3', '2017-08-31', '0'),
('3705', '13', '660', '10', '2017-09-27 00:50:33', NULL, '3', '2017-08-31', '0'),
('3706', '10', '657', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1403'),
('3707', '1', '900', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1629'),
('3708', '1', '901', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1630'),
('3709', '1', '902', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1631'),
('3710', '1', '903', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1632'),
('3711', '1', '904', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1633'),
('3712', '1', '905', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1634'),
('3713', '1', '906', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1635'),
('3714', '1', '907', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1636'),
('3715', '1', '908', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1637'),
('3716', '1', '852', '10', '2017-09-28 00:13:20', 'Voided.\n', '3', '2017-09-28', '0'),
('3717', '30', '661', '10', '2017-09-28 00:30:01', NULL, '3', '2017-09-28', '0'),
('3718', '13', '661', '10', '2017-09-28 00:30:01', NULL, '3', '2017-09-28', '0'),
('3719', '10', '658', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1651');
INSERT INTO `0_audit_trail` VALUES
('3720', '12', '288', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1652'),
('3721', '1', '909', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1653'),
('3722', '1', '910', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1654'),
('3723', '1', '911', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1655'),
('3724', '1', '912', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1665'),
('3725', '11', '43', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-30', '289'),
('3726', '13', '582', '10', '2017-10-02 02:26:19', 'Voided.', '3', '2017-10-02', '0'),
('3727', '10', '580', '10', '2017-10-02 02:26:19', 'Voided.\n', '3', '2017-10-02', '0'),
('3728', '30', '662', '10', '2017-10-02 02:42:02', NULL, '3', '2017-06-30', '0'),
('3729', '13', '662', '10', '2017-10-02 02:42:02', NULL, '3', '2017-06-30', '0'),
('3730', '10', '659', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '843'),
('3731', '30', '663', '10', '2017-10-02 02:47:32', NULL, '2', '2016-09-30', '0'),
('3732', '13', '663', '10', '2018-02-04 23:52:38', NULL, '3', '2016-09-30', NULL),
('3733', '10', '660', '10', '2018-02-04 23:52:38', NULL, '3', '2016-09-30', NULL),
('3734', '1', '913', '10', '2017-10-02 03:54:17', NULL, '3', '2016-10-03', NULL),
('3735', '1', '914', '10', '2017-10-02 03:54:30', NULL, '3', '2016-10-03', NULL),
('3736', '1', '915', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-02', '1691'),
('3737', '1', '913', '10', '2017-10-02 03:54:17', 'Voided.\nDocument reentered.', '3', '2017-10-02', '0'),
('3738', '1', '916', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-02', '1692'),
('3739', '1', '914', '10', '2017-10-02 03:54:30', 'Voided.\nDocument reentered.', '3', '2017-10-02', '0'),
('3740', '2', '62', '10', '2018-08-01 08:54:32', NULL, '5', '2017-09-29', NULL),
('3741', '1', '917', '10', '2017-10-02 05:56:29', NULL, '3', '2017-10-02', NULL),
('3742', '1', '918', '10', '2018-03-06 23:45:33', NULL, '3', '2017-10-02', NULL),
('3743', '1', '917', '10', '2017-10-02 05:56:29', 'Voided.\nDocument reentered.', '3', '2017-10-02', '0'),
('3744', '20', '54', '1', '2018-01-03 06:06:20', NULL, '3', '2017-10-02', NULL),
('3745', '22', '20', '1', '2017-10-11 02:24:32', NULL, '3', '2017-10-02', NULL),
('3746', '1', '919', '10', '2017-12-18 23:44:00', NULL, '3', '2017-10-02', NULL),
('3747', '1', '920', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-03', '1695'),
('3748', '18', '15', '10', '2017-10-03 02:26:29', NULL, '3', '2017-09-11', '0'),
('3749', '25', '15', '10', '2017-10-03 02:26:29', NULL, '3', '2017-09-11', '0'),
('3750', '20', '55', '10', '2018-01-04 03:30:59', NULL, '3', '2017-09-11', NULL),
('3751', '22', '21', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-03', '1696'),
('3752', '1', '921', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-03', '1697'),
('3753', '1', '922', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-03', '1698'),
('3754', '1', '923', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-03', '1699'),
('3755', '13', '527', '10', '2017-10-03 03:28:55', 'Voided.', '3', '2017-10-03', '0'),
('3756', '10', '527', '10', '2017-10-03 03:28:55', 'Voided.\n', '3', '2017-10-03', '0'),
('3757', '30', '664', '10', '2017-10-03 03:34:01', NULL, '3', '2017-07-24', '0'),
('3758', '13', '664', '10', '2017-10-03 03:34:01', NULL, '3', '2017-07-24', '0'),
('3759', '10', '661', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1061'),
('3760', '20', '56', '1', '2017-10-03 06:08:08', NULL, '3', '2017-10-03', NULL),
('3761', '20', '57', '1', '2017-10-03 06:07:48', NULL, '3', '2017-10-03', NULL),
('3762', '1', '924', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-03', '1700'),
('3763', '16', '22', '10', '2017-10-03 04:58:30', NULL, '3', '2017-10-03', '0'),
('3764', '1', '925', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-03', '1701'),
('3765', '1', '926', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-03', '1702'),
('3766', '20', '57', '1', '2017-10-03 06:07:48', 'Voided.\n', '3', '2017-10-03', '0'),
('3767', '20', '56', '1', '2017-10-03 06:08:08', 'Voided.\n', '3', '2017-10-03', '0'),
('3768', '18', '16', '1', '2017-10-04 01:31:53', NULL, '3', '2017-10-04', '0'),
('3769', '25', '16', '1', '2020-01-22 05:35:45', NULL, '3', '2017-10-04', '1704'),
('3770', '20', '58', '1', '2017-10-04 04:24:20', NULL, '3', '2017-10-04', NULL),
('3771', '22', '22', '1', '2017-10-04 03:10:19', NULL, '3', '2017-10-04', NULL),
('3772', '1', '927', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-04', '1705'),
('3773', '1', '928', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-04', '1706'),
('3774', '1', '929', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-04', '1707'),
('3775', '12', '289', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-04', '1708'),
('3776', '30', '665', '1', '2017-10-04 03:07:10', NULL, '3', '2017-10-04', '0'),
('3777', '13', '665', '1', '2018-01-04 05:59:40', NULL, '3', '2017-10-04', NULL),
('3778', '10', '662', '1', '2017-10-04 03:17:25', NULL, '3', '2017-10-04', NULL),
('3779', '30', '666', '10', '2017-10-04 03:08:06', NULL, '2', '2017-01-19', '0'),
('3780', '13', '666', '10', '2017-10-04 03:08:06', NULL, '2', '2017-01-19', '0'),
('3781', '10', '663', '10', '2019-11-05 05:45:21', NULL, '2', '2017-01-19', '266'),
('3782', '12', '290', '10', '2020-01-03 01:14:34', NULL, '6', '2017-10-02', NULL),
('3783', '22', '22', '10', '2017-10-04 03:10:19', 'Voided.\nBy Dilrukshi', '3', '2017-10-04', '0'),
('3784', '22', '19', '10', '2017-10-04 03:11:21', 'Voided.\n', '3', '2017-10-04', '0'),
('3785', '10', '662', '1', '2017-10-04 03:20:39', 'Updated.', '3', '2017-10-04', NULL),
('3786', '10', '662', '1', '2018-01-04 02:33:44', 'Updated.', '3', '2017-10-04', NULL),
('3787', '20', '58', '10', '2017-10-04 04:24:20', 'Voided.\n', '3', '2017-10-04', '0'),
('3788', '20', '53', '10', '2017-10-04 04:24:46', 'Voided.\n', '3', '2017-10-04', '0'),
('3789', '20', '52', '10', '2017-10-04 04:25:05', 'Voided.\n', '3', '2017-10-04', '0'),
('3790', '1', '930', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-04', '1709'),
('3791', '1', '931', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-06', '1721'),
('3792', '20', '59', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-19', '1554'),
('3793', '20', '60', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-04', '1431'),
('3794', '20', '61', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-26', '1618'),
('3795', '20', '62', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-19', '1555'),
('3796', '1', '932', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-06', '1722'),
('3797', '11', '44', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '468'),
('3798', '11', '45', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '469'),
('3799', '22', '23', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-06', '1723'),
('3800', '22', '24', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-06', '1724'),
('3801', '1', '933', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-06', '1725'),
('3802', '1', '934', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-06', '1726'),
('3803', '1', '935', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-06', '1727'),
('3804', '1', '936', '10', '2017-10-11 01:28:19', NULL, '3', '2017-10-09', NULL),
('3805', '1', '937', '10', '2017-10-09 05:54:15', NULL, '3', '2017-10-09', NULL),
('3806', '1', '938', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-09', '1734'),
('3807', '1', '939', '10', '2017-10-09 05:10:02', NULL, '3', '2017-08-02', NULL),
('3808', '1', '643', '10', '2017-10-09 05:08:59', 'Voided.\nDocument reentered.', '3', '2017-10-09', '0'),
('3809', '1', '940', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-02', '1163'),
('3810', '1', '939', '10', '2017-10-09 05:10:02', 'Voided.\nDocument reentered.', '3', '2017-10-09', '0'),
('3811', '1', '941', '10', '2017-10-09 05:49:35', NULL, '3', '2017-10-09', NULL),
('3812', '18', '17', '1', '2017-10-09 05:40:10', NULL, '3', '2017-10-09', NULL),
('3813', '18', '17', '1', '2017-10-09 05:40:10', 'Updated.', '3', '2017-10-09', '0'),
('3814', '25', '17', '1', '2017-10-09 05:40:49', NULL, '3', '2017-10-09', '0'),
('3815', '1', '941', '10', '2017-10-09 05:49:35', 'Voided.\nMr Pintoe Ask to Settle these                       ', '3', '2017-10-09', '0'),
('3816', '1', '942', '1', '2017-10-09 05:52:34', NULL, '3', '2017-09-11', NULL),
('3817', '1', '806', '1', '2017-10-09 05:51:46', 'Voided.\nDocument reentered.', '3', '2017-10-09', '0'),
('3818', '1', '943', '1', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1467'),
('3819', '1', '942', '1', '2017-10-09 05:52:34', 'Voided.\nDocument reentered.', '3', '2017-10-09', '0'),
('3820', '1', '937', '10', '2017-10-09 05:54:15', 'Voided.\nMr Pintoe Ask to Settle these                       ', '3', '2017-10-09', '0'),
('3821', '1', '944', '10', '2017-10-11 01:28:30', NULL, '3', '2017-10-09', NULL),
('3822', '30', '667', '10', '2017-10-09 06:16:09', NULL, '3', '2017-10-09', '0'),
('3823', '13', '667', '10', '2017-10-09 06:16:09', NULL, '3', '2017-10-09', '0'),
('3824', '10', '664', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-09', '1735'),
('3825', '4', '42', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-10', '1743'),
('3826', '30', '668', '10', '2017-10-10 02:07:20', NULL, '3', '2017-09-25', '0'),
('3827', '13', '668', '10', '2017-10-10 02:07:20', NULL, '3', '2017-09-25', '0'),
('3828', '10', '665', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-25', '1610'),
('3829', '30', '669', '10', '2017-10-10 02:08:15', NULL, '3', '2017-09-25', '0'),
('3830', '13', '669', '10', '2017-10-10 02:08:15', NULL, '3', '2017-09-25', '0'),
('3831', '10', '666', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-25', '1611'),
('3832', '30', '670', '10', '2017-10-10 02:19:19', NULL, '3', '2017-09-27', '0'),
('3833', '13', '670', '10', '2017-10-10 02:19:19', NULL, '3', '2017-09-27', '0'),
('3834', '10', '667', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1638'),
('3835', '30', '671', '10', '2017-10-10 02:20:11', NULL, '3', '2017-09-28', '0'),
('3836', '13', '671', '10', '2017-10-10 02:20:11', NULL, '3', '2017-09-28', '0'),
('3837', '10', '668', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1656'),
('3838', '30', '672', '10', '2017-10-10 02:21:18', NULL, '3', '2017-09-28', '0'),
('3839', '13', '672', '10', '2017-10-10 02:21:18', NULL, '3', '2017-09-28', '0'),
('3840', '10', '669', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1657'),
('3841', '30', '673', '10', '2017-10-10 02:24:28', NULL, '3', '2017-09-28', '0'),
('3842', '13', '673', '10', '2017-10-10 02:24:28', NULL, '3', '2017-09-28', '0'),
('3843', '10', '670', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1658'),
('3844', '30', '674', '10', '2017-10-10 02:25:15', NULL, '3', '2017-09-28', '0'),
('3845', '13', '674', '10', '2017-10-10 02:25:15', NULL, '3', '2017-09-28', '0'),
('3846', '10', '671', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1659'),
('3847', '30', '675', '10', '2017-10-10 02:40:18', NULL, '3', '2017-09-29', '0'),
('3848', '13', '675', '10', '2017-10-10 02:40:18', NULL, '3', '2017-09-29', '0'),
('3849', '10', '672', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1666'),
('3850', '30', '676', '10', '2017-10-10 02:41:15', NULL, '3', '2017-09-29', '0'),
('3851', '13', '676', '10', '2017-10-10 02:41:15', NULL, '3', '2017-09-29', '0'),
('3852', '10', '673', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1667'),
('3853', '20', '63', '1', '2017-10-10 23:36:44', NULL, '3', '2017-10-10', NULL),
('3854', '22', '25', '1', '2017-10-10 23:40:58', NULL, '3', '2017-10-10', NULL),
('3855', '18', '18', '1', '2017-10-10 03:13:56', NULL, '3', '2017-10-10', '0'),
('3856', '25', '18', '1', '2020-01-22 05:35:45', NULL, '3', '2017-10-10', '1744'),
('3857', '20', '64', '1', '2017-10-10 23:36:53', NULL, '3', '2017-10-10', NULL),
('3858', '18', '19', '1', '2017-10-10 03:43:03', NULL, '3', '2017-10-10', '0'),
('3859', '25', '19', '1', '2020-01-22 05:35:45', NULL, '3', '2017-10-10', '1745'),
('3860', '20', '65', '1', '2017-10-10 23:36:58', NULL, '3', '2017-10-10', NULL),
('3861', '1', '945', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-10', '1746'),
('3862', '1', '946', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-10', '1747'),
('3863', '1', '947', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-10', '1748'),
('3864', '1', '948', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-11', '1752'),
('3865', '20', '63', '10', '2017-10-10 23:36:44', 'Voided.\n', '3', '2017-10-10', '0'),
('3866', '20', '64', '10', '2017-10-10 23:36:53', 'Voided.\n', '3', '2017-10-10', '0'),
('3867', '20', '65', '10', '2017-10-10 23:36:58', 'Voided.\n', '3', '2017-10-10', '0'),
('3868', '22', '25', '10', '2017-10-10 23:40:58', 'Voided.\n', '3', '2017-10-10', '0'),
('3869', '1', '949', '10', '2017-10-11 00:21:56', NULL, '3', '2017-10-10', NULL),
('3870', '1', '949', '10', '2017-10-11 00:21:56', 'Voided.\n', '3', '2017-10-11', '0'),
('3871', '1', '950', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1660'),
('3872', '1', '936', '10', '2017-10-11 01:28:19', 'Voided.\n', '3', '2017-10-11', '0'),
('3873', '1', '944', '10', '2017-10-11 01:28:30', 'Voided.\n', '3', '2017-10-11', '0'),
('3874', '1', '951', '10', '2018-08-08 05:41:21', NULL, '5', '2017-10-10', NULL),
('3875', '1', '952', '10', '2017-10-11 03:01:59', NULL, '3', '2017-10-10', NULL),
('3876', '22', '20', '1', '2017-10-11 02:24:32', 'Voided.\n', '3', '2017-10-11', '0'),
('3877', '1', '953', '1', '2017-10-11 02:47:57', NULL, '3', '2017-10-11', NULL),
('3878', '1', '953', '1', '2017-10-11 02:47:57', 'Voided.\n', '3', '2017-10-11', '0'),
('3879', '1', '952', '1', '2017-10-11 03:01:59', 'Voided.\nTest Transaction', '3', '2017-10-11', '0'),
('3880', '1', '954', '10', '2018-03-07 00:19:54', NULL, '3', '2017-10-09', NULL),
('3881', '4', '43', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-06', '1728'),
('3882', '1', '955', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-11', '1753'),
('3883', '1', '956', '10', '2017-10-11 04:55:23', NULL, '3', '2017-10-11', NULL),
('3884', '1', '956', '10', '2017-10-11 04:55:23', 'Voided.\n', '3', '2017-10-11', '0'),
('3885', '1', '957', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-11', '1754'),
('3886', '1', '958', '10', '2018-03-06 23:48:09', NULL, '3', '2017-10-11', NULL),
('3887', '1', '959', '10', '2018-03-06 23:49:03', NULL, '3', '2017-10-11', NULL),
('3888', '1', '960', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-11', '1755'),
('3889', '1', '961', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-11', '1756'),
('3890', '4', '44', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-11', '1757'),
('3891', '1', '962', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-11', '1758'),
('3892', '30', '677', '10', '2017-10-11 05:50:11', NULL, '3', '2017-09-11', '0'),
('3893', '13', '677', '10', '2017-10-11 05:50:11', NULL, '3', '2017-09-11', '0'),
('3894', '10', '674', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1468'),
('3895', '30', '678', '10', '2017-10-11 05:51:41', NULL, '3', '2017-09-11', '0'),
('3896', '13', '678', '10', '2017-10-11 05:51:41', NULL, '3', '2017-09-11', '0'),
('3897', '10', '675', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1469'),
('3898', '30', '679', '10', '2017-10-11 05:53:35', NULL, '3', '2017-09-12', '0'),
('3899', '13', '679', '10', '2017-10-11 05:53:35', NULL, '3', '2017-09-12', '0'),
('3900', '10', '676', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1488'),
('3901', '30', '680', '10', '2017-10-11 05:54:43', NULL, '3', '2017-09-12', '0'),
('3902', '13', '680', '10', '2017-10-11 05:54:43', NULL, '3', '2017-09-12', '0'),
('3903', '10', '677', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1489'),
('3904', '30', '681', '10', '2017-10-11 05:55:30', NULL, '3', '2017-09-12', '0'),
('3905', '13', '681', '10', '2017-10-11 05:55:30', NULL, '3', '2017-09-12', '0'),
('3906', '10', '678', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1490'),
('3907', '30', '682', '10', '2017-10-11 06:02:55', NULL, '3', '2017-09-22', '0'),
('3908', '13', '682', '10', '2017-10-11 06:02:55', NULL, '3', '2017-09-22', '0'),
('3909', '10', '679', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-22', '1591'),
('3910', '30', '683', '10', '2017-10-11 06:06:05', NULL, '3', '2017-09-11', '0'),
('3911', '13', '683', '10', '2017-10-11 06:06:05', NULL, '3', '2017-09-11', '0'),
('3912', '10', '680', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1470'),
('3913', '30', '684', '10', '2017-10-11 06:08:58', NULL, '3', '2017-09-11', '0'),
('3914', '13', '684', '10', '2017-10-11 06:08:58', NULL, '3', '2017-09-11', '0'),
('3915', '10', '681', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1471'),
('3916', '30', '685', '10', '2017-10-11 06:10:39', NULL, '3', '2017-09-12', '0'),
('3917', '13', '685', '10', '2017-10-11 06:10:39', NULL, '3', '2017-09-12', '0'),
('3918', '10', '682', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1491'),
('3919', '30', '686', '10', '2017-10-11 23:43:22', NULL, '3', '2017-09-29', '0'),
('3920', '13', '686', '10', '2018-03-19 03:37:49', NULL, '3', '2017-09-29', NULL),
('3921', '10', '683', '10', '2017-10-11 23:57:18', NULL, '3', '2017-09-29', NULL),
('3922', '30', '687', '10', '2017-10-11 23:48:05', NULL, '3', '2017-09-29', '0'),
('3923', '13', '687', '10', '2017-12-06 23:48:48', NULL, '3', '2017-09-29', NULL),
('3924', '10', '684', '10', '2017-10-11 23:57:46', NULL, '3', '2017-09-29', NULL),
('3925', '30', '688', '10', '2017-10-11 23:54:47', NULL, '3', '2017-09-29', '0'),
('3926', '13', '688', '10', '2017-12-06 23:51:57', NULL, '3', '2017-09-29', NULL),
('3927', '10', '685', '10', '2017-10-11 23:59:01', NULL, '3', '2017-09-29', NULL),
('3928', '10', '683', '10', '2017-10-11 23:58:11', 'Updated.', '3', '2017-09-29', NULL),
('3929', '10', '684', '10', '2017-10-11 23:58:32', 'Updated.', '3', '2017-09-29', NULL),
('3930', '10', '683', '10', '2018-03-19 03:37:49', 'Updated.', '3', '2017-09-29', NULL),
('3931', '10', '684', '10', '2017-12-06 23:48:48', 'Updated.', '3', '2017-09-29', NULL),
('3932', '10', '685', '10', '2017-12-06 23:51:57', 'Updated.', '3', '2017-09-29', NULL),
('3933', '30', '689', '10', '2017-10-12 00:00:31', NULL, '3', '2017-09-29', '0'),
('3934', '13', '689', '10', '2017-12-06 23:53:01', NULL, '3', '2017-09-29', NULL),
('3935', '10', '686', '10', '2017-12-06 23:53:01', NULL, '3', '2017-09-29', NULL),
('3936', '30', '690', '10', '2017-10-12 00:01:31', NULL, '3', '2017-09-29', '0'),
('3937', '13', '690', '10', '2017-12-06 23:55:45', NULL, '3', '2017-09-29', NULL),
('3938', '10', '687', '10', '2017-12-06 23:55:45', NULL, '3', '2017-09-29', NULL),
('3939', '30', '691', '10', '2017-10-12 00:02:37', NULL, '3', '2017-09-29', '0'),
('3940', '13', '691', '10', '2017-12-06 23:58:03', NULL, '3', '2017-09-29', NULL),
('3941', '10', '688', '10', '2017-12-06 23:58:03', NULL, '3', '2017-09-29', NULL),
('3942', '10', '618', '10', '2017-12-07 00:15:35', 'Updated.', '3', '2017-08-31', NULL),
('3943', '1', '963', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-12', '1761'),
('3944', '30', '692', '10', '2017-10-12 01:41:21', NULL, '3', '2017-09-20', '0'),
('3945', '13', '692', '10', '2017-10-12 01:41:21', NULL, '3', '2017-09-20', '0'),
('3946', '10', '689', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-20', '1563'),
('3947', '16', '23', '10', '2017-10-12 03:55:34', NULL, '3', '2017-10-12', '0'),
('3948', '30', '693', '10', '2017-10-12 04:14:57', NULL, '3', '2017-10-12', '0'),
('3949', '13', '693', '10', '2018-03-19 03:47:09', NULL, '3', '2017-10-12', NULL),
('3950', '10', '690', '10', '2018-01-04 01:15:26', NULL, '3', '2017-10-12', NULL),
('3951', '30', '694', '10', '2017-10-12 04:16:11', NULL, '3', '2017-10-12', '0'),
('3952', '13', '694', '10', '2018-03-19 03:53:53', NULL, '3', '2017-10-12', NULL),
('3953', '10', '691', '10', '2018-01-04 01:15:36', NULL, '3', '2017-10-12', NULL),
('3954', '1', '964', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-12', '1762'),
('3955', '30', '695', '10', '2017-10-12 04:59:41', NULL, '3', '2017-09-20', '0'),
('3956', '13', '695', '10', '2017-10-12 04:59:41', NULL, '3', '2017-09-20', '0'),
('3957', '10', '692', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-20', '1564'),
('3958', '30', '696', '10', '2017-10-12 05:01:12', NULL, '3', '2017-09-20', '0'),
('3959', '13', '696', '10', '2018-01-25 05:08:55', NULL, '3', '2017-09-20', NULL),
('3960', '10', '693', '10', '2018-01-25 05:08:55', NULL, '3', '2017-09-20', NULL),
('3961', '1', '965', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-12', '1763'),
('3962', '18', '20', '1', '2017-10-12 06:00:22', NULL, '3', '2017-10-12', '0'),
('3963', '25', '20', '1', '2020-01-22 05:35:45', NULL, '3', '2017-10-12', '1764'),
('3964', '20', '66', '1', '2020-01-22 05:35:45', NULL, '3', '2017-10-12', '1765'),
('3965', '1', '966', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-13', '1768'),
('3966', '4', '45', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-13', '1769'),
('3967', '1', '967', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-13', '1770'),
('3968', '1', '968', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-13', '1771'),
('3969', '1', '969', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-13', '1772'),
('3970', '12', '291', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-04', '1710'),
('3971', '12', '292', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-04', '1711'),
('3972', '12', '293', '10', '2017-10-24 04:17:06', NULL, '3', '2017-10-04', NULL),
('3973', '12', '294', '10', '2017-10-24 04:17:14', NULL, '3', '2017-10-04', NULL),
('3974', '12', '295', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-04', '1712'),
('3975', '12', '296', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-04', '1713'),
('3976', '11', '46', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1527'),
('3977', '11', '47', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1528'),
('3978', '11', '48', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1529'),
('3979', '1', '970', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1777'),
('3980', '1', '971', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1778'),
('3981', '12', '297', '10', '2017-10-16 04:57:30', NULL, '3', '2017-10-16', NULL),
('3982', '18', '21', '10', '2017-10-16 04:13:56', NULL, '3', '2017-09-19', '0'),
('3983', '25', '21', '10', '2017-10-16 04:13:56', NULL, '3', '2017-09-19', '0'),
('3984', '20', '67', '10', '2018-01-04 04:22:37', NULL, '3', '2017-09-19', NULL),
('3985', '22', '26', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1779'),
('3986', '1', '972', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1780'),
('3987', '1', '973', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1781'),
('3988', '1', '974', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1782'),
('3989', '1', '975', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1783'),
('3990', '12', '297', '10', '2017-11-17 03:54:31', 'Updated.', '3', '2017-11-10', NULL),
('3991', '1', '976', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1784'),
('3992', '1', '977', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1785'),
('3993', '1', '978', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1786'),
('3994', '1', '979', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1787'),
('3995', '1', '980', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1788'),
('3996', '1', '981', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1789'),
('3997', '12', '10', '1', '2019-11-05 05:45:21', 'Updated.', '2', '2017-03-15', '403'),
('3998', '12', '43', '1', '2019-11-05 05:45:21', 'Updated.', '2', '2017-03-15', '404'),
('3999', '12', '256', '1', '2017-10-16 06:43:31', 'Updated.', '3', '2017-09-14', NULL),
('4000', '12', '256', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-14', '1509'),
('4001', '12', '179', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-08-29', '1372'),
('4002', '12', '298', '1', '2019-11-05 05:45:21', NULL, '2', '2017-02-28', '370'),
('4003', '30', '697', '10', '2017-10-17 02:10:00', NULL, '3', '2017-09-29', '0'),
('4004', '13', '697', '10', '2017-10-17 02:10:00', NULL, '3', '2017-09-29', '0'),
('4005', '10', '694', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1668'),
('4006', '30', '698', '10', '2017-10-17 02:11:00', NULL, '3', '2017-09-29', '0'),
('4007', '13', '698', '10', '2017-10-17 02:11:00', NULL, '3', '2017-09-29', '0'),
('4008', '10', '695', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1669'),
('4009', '10', '568', '10', '2018-01-26 01:12:57', 'Updated.', '3', '2017-07-19', NULL),
('4010', '1', '982', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-17', '1796'),
('4011', '1', '983', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-18', '1800'),
('4012', '4', '46', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-18', '1801'),
('4013', '30', '699', '10', '2017-10-19 00:04:52', NULL, '3', '2017-10-19', '0'),
('4014', '13', '699', '10', '2017-10-19 00:04:52', NULL, '3', '2017-10-19', '0'),
('4015', '12', '37', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-17', '426'),
('4016', '12', '50', '10', '2018-01-12 00:36:07', 'Updated.', '3', '2017-05-31', NULL),
('4017', '12', '54', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-01-03', '240'),
('4018', '12', '5', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-01-03', '241'),
('4019', '12', '27', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-01-03', '242'),
('4020', '12', '237', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-18', '433'),
('4021', '12', '124', '10', '2017-11-17 05:21:14', 'Updated.', '3', '2017-07-21', NULL),
('4022', '12', '81', '10', '2018-02-08 01:18:00', 'Updated.', '3', '2017-07-27', NULL),
('4023', '12', '122', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-09', '668'),
('4024', '12', '19', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-03-15', '405'),
('4025', '12', '299', '10', '2018-07-21 08:03:11', NULL, '3', '2017-08-25', '0'),
('4026', '30', '700', '10', '2017-10-19 02:12:03', NULL, '2', '2016-06-25', '0'),
('4027', '13', '700', '10', '2017-10-19 02:12:03', NULL, '2', '2016-06-25', '0'),
('4028', '10', '696', '10', '2019-11-05 05:45:21', NULL, '2', '2016-06-25', '50'),
('4029', '30', '701', '10', '2017-10-19 02:22:59', NULL, '3', '2017-07-31', '0'),
('4030', '13', '701', '10', '2017-10-19 02:22:59', NULL, '3', '2017-07-31', '0'),
('4031', '10', '697', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1137'),
('4032', '30', '702', '10', '2017-10-19 02:27:47', NULL, '3', '2017-07-24', '0'),
('4033', '13', '702', '10', '2017-10-19 02:27:47', NULL, '3', '2017-07-24', '0'),
('4034', '10', '698', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-24', '1062'),
('4035', '30', '703', '10', '2017-10-19 02:28:50', NULL, '3', '2017-07-30', '0'),
('4036', '13', '703', '10', '2017-10-19 02:28:50', NULL, '3', '2017-07-30', '0'),
('4037', '10', '699', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-30', '1118'),
('4038', '30', '704', '10', '2017-10-19 02:31:41', NULL, '3', '2017-08-29', '0'),
('4039', '13', '704', '10', '2017-10-19 02:31:41', NULL, '3', '2017-08-29', '0'),
('4040', '10', '700', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-29', '1373'),
('4041', '30', '705', '10', '2017-10-19 02:32:59', NULL, '3', '2017-08-28', '0'),
('4042', '13', '705', '10', '2017-10-19 02:32:59', NULL, '3', '2017-08-28', '0'),
('4043', '10', '701', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1358'),
('4044', '30', '706', '10', '2017-10-19 02:35:02', NULL, '3', '2017-08-31', '0'),
('4045', '13', '706', '10', '2017-10-19 02:35:02', NULL, '3', '2017-08-31', '0'),
('4046', '10', '702', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1404'),
('4047', '30', '707', '10', '2017-10-19 02:38:07', NULL, '3', '2017-09-26', '0'),
('4048', '13', '707', '10', '2017-10-19 02:38:07', NULL, '3', '2017-09-26', '0'),
('4049', '10', '703', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-26', '1619'),
('4050', '30', '708', '10', '2017-10-19 02:38:46', NULL, '3', '2017-09-28', '0'),
('4051', '13', '708', '10', '2017-10-19 02:38:46', NULL, '3', '2017-09-28', '0'),
('4052', '10', '704', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1661'),
('4053', '30', '709', '10', '2017-10-19 02:39:43', NULL, '3', '2017-09-28', '0'),
('4054', '13', '709', '10', '2017-10-19 03:50:19', NULL, '3', '2017-09-28', NULL),
('4055', '10', '705', '10', '2017-10-19 03:50:19', NULL, '3', '2017-09-28', NULL),
('4056', '30', '710', '10', '2017-10-19 03:49:54', NULL, '3', '2017-09-28', '0'),
('4057', '13', '710', '10', '2017-10-19 03:49:54', NULL, '3', '2017-09-28', '0'),
('4058', '10', '706', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1662'),
('4059', '13', '709', '10', '2017-10-19 03:50:19', 'Voided.', '3', '2017-10-19', '0'),
('4060', '10', '705', '10', '2017-10-19 03:50:19', 'Voided.\n', '3', '2017-10-19', '0'),
('4061', '12', '1', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2016-10-11', '149'),
('4062', '12', '2', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-01-17', '261'),
('4063', '12', '104', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-24', '490'),
('4064', '30', '711', '10', '2017-10-19 04:13:22', NULL, '2', '2016-10-07', '0'),
('4065', '13', '711', '10', '2017-10-19 04:13:22', NULL, '2', '2016-10-07', '0'),
('4066', '10', '707', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-07', '146'),
('4067', '13', '4', '10', '2017-10-19 04:14:10', 'Voided.', '3', '2017-10-19', '0'),
('4068', '10', '7', '10', '2017-10-19 04:14:10', 'Voided.\n', '3', '2017-10-19', '0'),
('4069', '12', '109', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-29', '548'),
('4070', '12', '175', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-31', '1138'),
('4071', '12', '200', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-08-03', '1180'),
('4072', '12', '197', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-08-08', '1218'),
('4073', '12', '30', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-01-03', '243'),
('4074', '12', '15', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2016-08-15', '94'),
('4075', '12', '16', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-01-03', '244'),
('4076', '12', '199', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-08-03', '1181'),
('4077', '12', '162', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-03', '863'),
('4078', '12', '161', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-01-03', '245'),
('4079', '12', '168', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-03', '864'),
('4080', '12', '205', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-08-03', '1182'),
('4081', '12', '279', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-12', '1492'),
('4082', '12', '282', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-12', '1493'),
('4083', '12', '284', '10', '2017-10-20 03:14:57', 'Updated.', '3', '2017-08-08', NULL),
('4084', '12', '240', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-04-28', '279'),
('4085', '12', '201', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-08-03', '1183'),
('4086', '12', '167', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-03', '865'),
('4087', '12', '61', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-02-13', '326'),
('4088', '12', '45', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-01-03', '246'),
('4089', '12', '62', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2016-12-20', '204'),
('4090', '12', '300', '10', '2017-10-19 04:48:46', NULL, '2', '2017-03-09', NULL),
('4091', '12', '300', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-03-09', '391'),
('4092', '12', '281', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-12', '1494'),
('4093', '12', '165', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-03', '866'),
('4094', '12', '12', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-03-09', '392'),
('4095', '12', '52', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-02-16', '334'),
('4096', '12', '185', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-03', '867'),
('4097', '1', '984', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-19', '1804'),
('4098', '12', '183', '10', '2018-02-16 01:19:11', 'Updated.', '3', '2017-08-14', NULL),
('4099', '12', '202', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-08-03', '1184'),
('4100', '12', '280', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-12', '1495'),
('4101', '10', '111', '10', '2017-10-19 05:19:23', 'Updated.', '2', '2017-02-13', NULL),
('4102', '10', '111', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-02-13', '327'),
('4103', '12', '204', '10', '2017-10-19 05:23:36', 'Updated.', '3', '2017-08-03', NULL),
('4104', '12', '204', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-08-03', '1185'),
('4105', '1', '985', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-19', '1805'),
('4106', '1', '986', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1817'),
('4107', '1', '987', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1818'),
('4108', '1', '988', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1819'),
('4109', '1', '989', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1820'),
('4110', '1', '990', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1821'),
('4111', '1', '991', '10', '2018-03-07 01:07:36', NULL, '3', '2017-10-19', NULL),
('4112', '1', '992', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-19', '1806'),
('4113', '1', '993', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-19', '1807'),
('4114', '1', '994', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1822'),
('4115', '1', '995', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1823'),
('4116', '11', '30', '10', '2017-10-20 03:09:04', 'Voided.\n', '3', '2017-10-20', '0'),
('4117', '11', '40', '10', '2017-10-20 03:14:24', 'Voided.\n', '3', '2017-10-20', '0'),
('4118', '11', '41', '10', '2017-10-20 03:14:31', 'Voided.\n', '3', '2017-10-20', '0'),
('4119', '12', '284', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-08-08', '1219'),
('4120', '11', '49', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1186'),
('4121', '12', '301', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-06', '1985'),
('4122', '12', '302', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1871'),
('4123', '12', '303', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-13', '2052'),
('4124', '12', '304', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-20', '2447'),
('4125', '11', '50', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1824'),
('4126', '11', '51', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1825'),
('4127', '11', '52', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1826'),
('4128', '11', '53', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1827'),
('4129', '1', '996', '10', '2018-01-04 04:23:54', NULL, '3', '2017-10-20', NULL),
('4130', '16', '24', '10', '2017-10-26 01:04:07', NULL, '3', '2017-10-20', NULL),
('4131', '1', '997', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1828'),
('4132', '1', '998', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-23', '1847'),
('4133', '1', '999', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-23', '1848'),
('4134', '1', '1000', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-23', '1849'),
('4135', '1', '1001', '10', '2017-11-30 01:41:07', NULL, '3', '2017-10-23', NULL),
('4136', '12', '305', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1829'),
('4137', '12', '306', '10', '2017-10-24 04:14:38', NULL, '3', '2017-10-20', NULL),
('4138', '12', '307', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1830'),
('4139', '12', '308', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-08', '2002'),
('4140', '12', '309', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1831'),
('4141', '12', '310', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1832'),
('4142', '12', '311', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1833'),
('4143', '12', '312', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1834'),
('4144', '12', '313', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1835'),
('4145', '12', '314', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-06', '1986'),
('4146', '12', '315', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1916'),
('4147', '1', '1002', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-23', '1850'),
('4148', '12', '316', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1936'),
('4149', '12', '317', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1836'),
('4150', '12', '318', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1837'),
('4151', '1', '1003', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-23', '1851'),
('4152', '30', '712', '10', '2017-10-24 00:24:06', NULL, '3', '2017-07-20', '0'),
('4153', '13', '712', '10', '2017-10-24 00:24:06', NULL, '3', '2017-07-20', '0'),
('4154', '10', '708', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-20', '1019'),
('4155', '30', '713', '10', '2017-10-24 00:26:24', NULL, '3', '2017-07-20', '0'),
('4156', '13', '713', '10', '2017-10-24 00:26:24', NULL, '3', '2017-07-20', '0'),
('4157', '10', '709', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-20', '1020'),
('4158', '30', '714', '10', '2017-10-24 00:37:42', NULL, '3', '2017-07-20', '0'),
('4159', '13', '714', '10', '2017-10-24 00:37:42', NULL, '3', '2017-07-20', '0'),
('4160', '10', '710', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-20', '1021'),
('4161', '30', '715', '10', '2017-10-24 00:39:41', NULL, '3', '2017-07-20', '0'),
('4162', '13', '715', '10', '2017-10-24 00:39:41', NULL, '3', '2017-07-20', '0'),
('4163', '10', '711', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-20', '1022'),
('4164', '30', '716', '10', '2017-10-24 00:40:31', NULL, '3', '2017-07-20', '0'),
('4165', '13', '716', '10', '2017-10-24 00:40:31', NULL, '3', '2017-07-20', '0'),
('4166', '10', '712', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-20', '1023'),
('4167', '30', '717', '10', '2017-10-24 00:41:33', NULL, '3', '2017-07-21', '0'),
('4168', '13', '717', '10', '2017-10-24 00:41:33', NULL, '3', '2017-07-21', '0'),
('4169', '10', '713', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-21', '1039'),
('4170', '12', '319', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-10', '2039'),
('4171', '12', '320', '10', '2017-10-24 00:45:33', NULL, '3', '2017-10-20', NULL),
('4172', '12', '320', '10', '2017-10-26 02:03:46', 'Updated.', '3', '2017-10-20', NULL),
('4173', '1', '1004', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-24', '1857'),
('4174', '1', '1005', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-24', '1858'),
('4175', '4', '47', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-24', '1859'),
('4176', '1', '1006', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-24', '1860'),
('4177', '12', '270', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-10', '938'),
('4178', '12', '71', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-03', '321'),
('4179', '12', '59', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2016-12-29', '218'),
('4180', '12', '321', '10', '2017-10-24 03:29:21', NULL, '3', '2016-12-29', NULL),
('4181', '12', '321', '10', '2017-10-24 03:29:21', 'Voided.\n', '3', '2017-10-24', '0'),
('4182', '13', '306', '10', '2017-10-24 03:46:09', 'Voided.', '3', '2017-10-24', '0'),
('4183', '10', '309', '10', '2017-10-24 03:46:09', 'Voided.\n', '3', '2017-10-24', '0'),
('4184', '12', '119', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-01', '590'),
('4185', '30', '718', '10', '2017-10-24 04:02:01', NULL, '2', '2017-02-25', '0'),
('4186', '13', '718', '10', '2017-10-24 04:03:32', NULL, '3', '2017-02-25', NULL),
('4187', '10', '714', '10', '2017-10-24 04:03:32', NULL, '3', '2017-02-25', NULL),
('4188', '30', '719', '10', '2017-10-24 04:02:53', NULL, '2', '2017-02-25', '0'),
('4189', '13', '719', '10', '2017-10-24 04:02:53', NULL, '2', '2017-02-25', '0'),
('4190', '10', '715', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-25', '350'),
('4191', '13', '718', '10', '2017-10-24 04:03:32', 'Voided.', '3', '2017-10-24', '0'),
('4192', '10', '714', '10', '2017-10-24 04:03:32', 'Voided.\n', '3', '2017-10-24', '0'),
('4193', '13', '72', '10', '2017-10-24 04:03:51', 'Voided.', '3', '2017-10-24', '0'),
('4194', '10', '75', '10', '2017-10-24 04:03:51', 'Voided.\n', '3', '2017-10-24', '0'),
('4195', '12', '68', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2016-10-05', '144'),
('4196', '12', '14', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2016-12-29', '219'),
('4197', '12', '268', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-10', '939'),
('4198', '12', '55', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-01-03', '247'),
('4199', '12', '114', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-12', '672'),
('4200', '12', '252', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-18', '1543'),
('4201', '12', '306', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-10-20', '1838'),
('4202', '12', '293', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-10-04', '1714'),
('4203', '12', '294', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-10-04', '1715'),
('4204', '12', '272', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-10', '940'),
('4205', '12', '70', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-03', '322'),
('4206', '12', '95', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-26', '534'),
('4207', '30', '720', '10', '2017-10-24 04:56:45', NULL, '2', '2017-03-06', '0'),
('4208', '13', '720', '10', '2017-10-24 04:56:45', NULL, '2', '2017-03-06', '0'),
('4209', '10', '716', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-06', '381'),
('4210', '10', '1', '10', '2017-10-24 04:57:19', 'Voided.\n', '3', '2017-10-24', '0'),
('4211', '30', '721', '10', '2017-10-24 05:02:30', NULL, '3', '2017-09-20', '0'),
('4212', '13', '721', '10', '2017-10-24 05:02:30', NULL, '3', '2017-09-20', '0'),
('4213', '10', '717', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-20', '1565'),
('4214', '30', '722', '10', '2017-10-24 05:03:14', NULL, '3', '2017-09-21', '0'),
('4215', '13', '722', '10', '2017-10-24 05:03:14', NULL, '3', '2017-09-21', '0'),
('4216', '10', '718', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-21', '1578'),
('4217', '30', '723', '10', '2017-10-24 05:08:47', NULL, '3', '2017-10-24', '0'),
('4218', '13', '723', '10', '2017-10-24 05:08:47', NULL, '3', '2017-10-24', '0'),
('4219', '10', '719', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-24', '1861'),
('4220', '12', '322', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-24', '1862'),
('4221', '1', '1007', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-24', '1863'),
('4222', '1', '1008', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-24', '1864'),
('4223', '1', '1009', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1872'),
('4224', '1', '1010', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1873'),
('4225', '12', '323', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1874'),
('4226', '12', '324', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1875'),
('4227', '30', '724', '10', '2017-10-25 02:26:41', NULL, '3', '2017-09-18', '0'),
('4228', '13', '724', '10', '2017-10-25 02:26:41', NULL, '3', '2017-09-18', '0'),
('4229', '10', '720', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-18', '1544'),
('4230', '12', '325', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1876'),
('4231', '30', '725', '10', '2017-10-25 03:35:12', NULL, '3', '2017-10-17', '0'),
('4232', '13', '725', '10', '2017-11-13 04:31:51', NULL, '3', '2017-10-17', NULL),
('4233', '10', '721', '10', '2017-11-10 01:22:12', NULL, '3', '2017-10-17', NULL),
('4234', '1', '1011', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1877'),
('4235', '1', '1012', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1878'),
('4236', '1', '1013', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1879'),
('4237', '1', '1014', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1880'),
('4238', '1', '1015', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1881'),
('4239', '1', '1016', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-10', '1749'),
('4240', '1', '1017', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-03', '1703'),
('4241', '1', '1018', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-24', '1865'),
('4242', '1', '1019', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-24', '1866'),
('4243', '1', '1020', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1882'),
('4244', '1', '1021', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1883'),
('4245', '1', '1022', '10', '2018-01-04 04:06:22', NULL, '3', '2017-10-25', NULL),
('4246', '1', '1023', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-26', '1887'),
('4247', '1', '1024', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-26', '1888'),
('4248', '16', '24', '10', '2017-10-26 01:04:07', 'Voided.\n', '3', '2017-10-26', '0'),
('4249', '16', '25', '10', '2017-10-26 01:04:46', NULL, '3', '2017-10-20', '0'),
('4250', '12', '326', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-26', '1889'),
('4251', '12', '320', '10', '2017-10-26 02:03:46', 'Voided.\nCHQ Returned', '3', '2017-10-26', '0'),
('4252', '16', '26', '10', '2017-10-27 01:30:17', NULL, '3', '2017-10-27', '0'),
('4253', '16', '27', '10', '2017-10-27 01:38:08', NULL, '3', '2017-10-27', '0'),
('4254', '1', '1025', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1892'),
('4255', '1', '1026', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1893'),
('4256', '1', '1027', '10', '2017-11-17 02:44:55', NULL, '3', '2017-10-27', NULL),
('4257', '1', '1028', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1894'),
('4258', '1', '1029', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1895'),
('4259', '1', '1030', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1896'),
('4260', '20', '68', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1839'),
('4261', '20', '69', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-23', '1852'),
('4262', '20', '70', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-09', '1736'),
('4263', '20', '71', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-04', '1716'),
('4264', '1', '1031', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1897'),
('4265', '22', '27', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1917'),
('4266', '22', '28', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1918'),
('4267', '1', '1032', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1919'),
('4268', '1', '1033', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1920'),
('4269', '1', '1034', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1921'),
('4270', '1', '1035', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1922'),
('4271', '1', '1036', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1923'),
('4272', '1', '1037', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1924'),
('4273', '1', '1038', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1925'),
('4274', '1', '1039', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1926'),
('4275', '4', '48', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1937'),
('4276', '1', '1040', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1938'),
('4277', '12', '327', '10', '2018-01-03 06:38:18', NULL, '3', '2017-10-31', NULL),
('4278', '1', '1041', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1939'),
('4279', '1', '1042', '10', '2018-03-07 00:20:47', NULL, '3', '2017-10-31', NULL),
('4280', '1', '1043', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1940'),
('4281', '4', '49', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1941'),
('4282', '1', '1044', '10', '2018-03-06 23:49:59', NULL, '3', '2017-10-31', NULL),
('4283', '1', '1045', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1942'),
('4284', '1', '1046', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-01', '1958'),
('4285', '30', '726', '10', '2017-11-01 02:49:11', NULL, '3', '2017-10-19', '0'),
('4286', '13', '726', '10', '2017-11-01 02:49:11', NULL, '3', '2017-10-19', '0'),
('4287', '10', '722', '10', '2018-03-16 06:44:05', NULL, '3', '2017-10-19', NULL),
('4288', '12', '328', '10', '2018-03-16 06:44:21', NULL, '3', '2017-11-01', NULL),
('4289', '30', '727', '1', '2017-11-01 03:46:54', NULL, '3', '2017-11-01', '0'),
('4290', '13', '727', '1', '2017-11-08 05:27:42', NULL, '3', '2017-11-01', NULL),
('4291', '10', '723', '1', '2017-11-08 05:27:42', NULL, '3', '2017-11-01', NULL),
('4292', '12', '329', '10', '2018-01-08 05:31:59', NULL, '3', '2017-11-01', NULL),
('4293', '1', '1047', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-01', '1959'),
('4294', '1', '1048', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-01', '1960'),
('4295', '1', '1049', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-04', '1717'),
('4296', '1', '1050', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-02', '1967'),
('4297', '1', '1051', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-02', '1968'),
('4298', '1', '1052', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-02', '1969'),
('4299', '12', '330', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-02', '1970'),
('4300', '12', '331', '10', '2018-01-24 01:12:34', NULL, '3', '2017-11-02', NULL),
('4301', '12', '332', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-02', '1971'),
('4302', '12', '333', '10', '2018-01-24 01:05:27', NULL, '3', '2017-11-02', NULL),
('4303', '4', '50', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-02', '1972'),
('4304', '12', '334', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-02', '1973'),
('4305', '1', '1053', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-06', '1987'),
('4306', '1', '1054', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-06', '1988'),
('4307', '1', '1055', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-06', '1989'),
('4308', '1', '1056', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-06', '1990'),
('4309', '1', '1057', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-06', '1991'),
('4310', '1', '1058', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-06', '1992'),
('4311', '1', '1059', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-06', '1993'),
('4312', '1', '1060', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-06', '1994'),
('4313', '1', '1061', '10', '2018-03-07 00:21:33', NULL, '3', '2017-11-06', NULL),
('4314', '1', '1062', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-07', '1998'),
('4315', '1', '1063', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-07', '1999'),
('4316', '1', '1064', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-07', '2000'),
('4317', '10', '724', '10', '2018-01-23 02:18:36', NULL, '3', '2017-09-13', NULL),
('4318', '12', '335', '10', '2018-01-08 05:41:00', NULL, '3', '2017-11-02', NULL),
('4319', '1', '1065', '10', '2018-03-06 23:51:36', NULL, '3', '2017-11-08', NULL),
('4320', '1', '1066', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-08', '2003'),
('4321', '1', '1067', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-08', '2004');
INSERT INTO `0_audit_trail` VALUES
('4322', '1', '1068', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1670'),
('4323', '1', '1069', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1943'),
('4324', '1', '1070', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1944'),
('4325', '1', '1071', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1671'),
('4326', '18', '22', '1', '2017-11-08 02:45:38', NULL, '3', '2017-11-08', '0'),
('4327', '25', '22', '1', '2020-01-22 05:35:45', NULL, '3', '2017-11-08', '2005'),
('4328', '20', '72', '1', '2020-01-22 05:35:45', NULL, '3', '2017-11-08', '2006'),
('4329', '1', '1072', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-08', '2007'),
('4330', '30', '728', '10', '2017-11-08 05:09:17', NULL, '3', '2017-11-01', '0'),
('4331', '13', '728', '10', '2017-11-08 05:09:17', NULL, '3', '2017-11-01', '0'),
('4332', '10', '725', '10', '2018-01-04 00:53:48', NULL, '3', '2017-11-01', NULL),
('4333', '13', '727', '10', '2017-11-08 05:27:42', 'Voided.', '3', '2017-11-08', '0'),
('4334', '10', '723', '10', '2017-11-08 05:27:42', 'Voided.\n', '3', '2017-11-08', '0'),
('4335', '1', '1073', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2013'),
('4336', '1', '1074', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2014'),
('4337', '1', '1075', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2015'),
('4338', '1', '1076', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2016'),
('4339', '11', '54', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2017'),
('4340', '1', '1077', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2018'),
('4341', '4', '51', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2019'),
('4342', '1', '1078', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2020'),
('4343', '1', '1079', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2021'),
('4344', '1', '1080', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2022'),
('4345', '1', '1081', '10', '2017-12-11 02:49:58', NULL, '3', '2017-11-09', NULL),
('4346', '1', '1082', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2023'),
('4347', '12', '336', '10', '2018-01-08 05:37:26', NULL, '3', '2017-11-09', NULL),
('4348', '12', '337', '10', '2018-01-08 05:37:35', NULL, '3', '2017-11-09', NULL),
('4349', '11', '55', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1139'),
('4350', '12', '338', '10', '2018-01-08 05:32:10', NULL, '3', '2017-11-09', NULL),
('4351', '12', '339', '10', '2018-01-08 06:22:33', NULL, '3', '2017-11-09', NULL),
('4352', '1', '1083', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2024'),
('4353', '1', '1084', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-10', '2040'),
('4354', '1', '1085', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-10', '2041'),
('4355', '1', '1086', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-10', '2042'),
('4356', '10', '721', '10', '2017-11-10 01:23:34', 'Updated.', '3', '2017-10-17', NULL),
('4357', '10', '721', '10', '2017-11-10 01:24:11', 'Updated.', '3', '2017-10-17', NULL),
('4358', '10', '721', '10', '2017-11-10 01:27:31', 'Updated.', '3', '2017-10-17', NULL),
('4359', '10', '721', '10', '2017-11-10 01:30:40', 'Updated.', '3', '2017-10-17', NULL),
('4360', '10', '721', '10', '2017-11-13 04:31:51', 'Updated.', '3', '2017-10-17', NULL),
('4361', '1', '1087', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-10', '2043'),
('4362', '1', '1088', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-10', '2044'),
('4363', '1', '1089', '1', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '23'),
('4364', '1', '46', '1', '2017-11-10 02:55:08', 'Voided.\nDocument reentered.', '3', '2017-11-10', '0'),
('4365', '1', '1090', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-10', '2045'),
('4366', '30', '729', '1', '2017-11-10 03:05:52', NULL, '3', '2017-11-10', '0'),
('4367', '13', '729', '1', '2018-01-04 06:00:40', NULL, '3', '2017-11-10', NULL),
('4368', '10', '726', '1', '2017-11-10 03:07:59', NULL, '3', '2017-11-10', NULL),
('4369', '10', '726', '1', '2018-01-04 02:34:03', 'Updated.', '3', '2017-10-30', NULL),
('4370', '1', '1091', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-10', '2046'),
('4371', '1', '1092', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-10', '2047'),
('4372', '30', '730', '1', '2017-11-10 04:42:52', NULL, '3', '2017-11-10', '0'),
('4373', '13', '730', '1', '2018-01-04 06:08:10', NULL, '3', '2017-11-10', NULL),
('4374', '10', '727', '1', '2017-11-10 04:44:23', NULL, '3', '2017-11-10', NULL),
('4375', '10', '727', '1', '2018-01-04 02:34:18', 'Updated.', '3', '2017-11-10', NULL),
('4376', '1', '1093', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-09', '378'),
('4377', '1', '214', '10', '2017-11-10 04:45:10', 'Voided.\nDocument reentered.', '3', '2017-11-10', '0'),
('4378', '1', '1094', '10', '2017-11-10 05:00:36', NULL, '3', '2017-04-27', NULL),
('4379', '1', '823', '10', '2017-11-10 04:46:32', 'Voided.\nDocument reentered.', '3', '2017-11-10', '0'),
('4380', '1', '1095', '10', '2017-11-10 05:01:13', NULL, '3', '2017-05-26', NULL),
('4381', '1', '822', '10', '2017-11-10 04:47:12', 'Voided.\nDocument reentered.', '3', '2017-11-10', '0'),
('4382', '1', '1096', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-14', '976'),
('4383', '1', '566', '10', '2017-11-10 04:47:43', 'Voided.\nDocument reentered.', '3', '2017-11-10', '0'),
('4384', '1', '1097', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-11', '1252'),
('4385', '1', '678', '10', '2017-11-10 04:48:11', 'Voided.\nDocument reentered.', '3', '2017-11-10', '0'),
('4386', '1', '1098', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-19', '1556'),
('4387', '1', '864', '10', '2017-11-10 04:48:47', 'Voided.\nDocument reentered.', '3', '2017-11-10', '0'),
('4388', '1', '1099', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '252'),
('4389', '1', '1094', '10', '2017-11-10 05:00:36', 'Voided.\nDocument reentered.', '3', '2017-11-10', '0'),
('4390', '1', '1100', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '535'),
('4391', '1', '1095', '10', '2017-11-10 05:01:13', 'Voided.\nDocument reentered.', '3', '2017-11-10', '0'),
('4392', '1', '1101', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-13', '2053'),
('4393', '30', '731', '10', '2017-11-13 01:22:13', NULL, '3', '2017-11-13', '0'),
('4394', '13', '731', '10', '2018-03-19 04:15:56', NULL, '3', '2017-11-13', NULL),
('4395', '10', '728', '10', '2017-11-13 04:34:06', NULL, '3', '2017-11-13', NULL),
('4396', '1', '1102', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-13', '2054'),
('4397', '30', '732', '10', '2017-11-13 04:24:47', NULL, '3', '2017-11-13', '0'),
('4398', '13', '732', '10', '2018-03-19 04:18:05', NULL, '3', '2017-11-13', NULL),
('4399', '10', '729', '10', '2017-11-13 06:43:54', NULL, '3', '2017-11-13', NULL),
('4400', '30', '733', '10', '2017-11-13 04:28:23', NULL, '3', '2017-10-17', '0'),
('4401', '13', '733', '10', '2018-03-19 03:57:50', NULL, '3', '2017-10-17', NULL),
('4402', '10', '730', '10', '2017-11-13 04:30:13', NULL, '3', '2017-10-17', NULL),
('4403', '10', '730', '10', '2017-11-13 04:30:44', 'Updated.', '3', '2017-10-17', NULL),
('4404', '10', '730', '10', '2018-03-19 03:57:50', 'Updated.', '3', '2017-10-17', NULL),
('4405', '13', '725', '10', '2017-11-13 04:31:51', 'Voided.', '3', '2017-11-13', '0'),
('4406', '10', '721', '10', '2017-11-13 04:31:51', 'Voided.\n', '3', '2017-11-13', '0'),
('4407', '10', '728', '10', '2017-11-13 04:34:29', 'Updated.', '3', '2017-11-13', NULL),
('4408', '10', '728', '10', '2018-03-19 04:15:56', 'Updated.', '3', '2017-11-13', NULL),
('4409', '1', '1103', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-13', '2055'),
('4410', '16', '28', '10', '2017-11-13 05:16:45', NULL, '3', '2017-11-13', '0'),
('4411', '10', '729', '1', '2017-11-13 06:45:30', 'Updated.', '3', '2017-11-13', NULL),
('4412', '10', '729', '1', '2018-03-19 04:18:05', 'Updated.', '3', '2017-11-13', NULL),
('4413', '1', '1104', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-14', '2063'),
('4414', '30', '734', '1', '2017-11-14 01:32:49', NULL, '3', '2017-11-14', '0'),
('4415', '13', '734', '1', '2018-03-19 04:11:17', NULL, '3', '2017-11-14', NULL),
('4416', '10', '731', '1', '2017-11-14 01:33:41', NULL, '3', '2017-11-14', NULL),
('4417', '10', '731', '1', '2017-11-14 01:49:58', 'Updated.', '3', '2017-11-14', NULL),
('4418', '10', '731', '1', '2017-11-14 02:04:47', 'Updated.', '3', '2017-11-14', NULL),
('4419', '10', '731', '1', '2017-11-14 02:14:13', 'Updated.', '3', '2017-11-14', NULL),
('4420', '10', '731', '1', '2017-11-14 02:15:37', 'Updated.', '3', '2017-11-14', NULL),
('4421', '10', '731', '1', '2018-03-19 04:11:17', 'Updated.', '3', '2017-11-14', NULL),
('4422', '30', '735', '10', '2017-11-14 03:12:45', NULL, '3', '2017-11-14', '0'),
('4423', '13', '735', '10', '2017-11-14 03:12:45', NULL, '3', '2017-11-14', '0'),
('4424', '10', '732', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-14', '2064'),
('4425', '30', '736', '10', '2017-11-14 03:43:35', NULL, '3', '2017-11-01', '0'),
('4426', '13', '736', '10', '2017-11-14 04:10:13', NULL, '3', '2017-11-01', NULL),
('4427', '10', '733', '10', '2017-11-14 04:10:13', NULL, '3', '2017-11-01', NULL),
('4428', '12', '340', '10', '2017-11-14 04:08:04', NULL, '3', '2017-11-14', NULL),
('4429', '12', '340', '10', '2017-11-14 04:08:04', 'Voided.\n', '3', '2017-11-14', '0'),
('4430', '13', '736', '10', '2017-11-14 04:10:13', 'Voided.', '3', '2017-11-14', '0'),
('4431', '10', '733', '10', '2017-11-14 04:10:13', 'Voided.\nWrong Quantity Entered', '3', '2017-11-01', '0'),
('4432', '30', '737', '10', '2017-11-14 04:22:18', NULL, '3', '2017-11-14', '0'),
('4433', '13', '737', '10', '2017-11-14 04:22:18', NULL, '3', '2017-11-14', '0'),
('4434', '10', '734', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-14', '2065'),
('4435', '12', '341', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-14', '2066'),
('4436', '1', '1105', '10', '2018-03-06 23:52:14', NULL, '3', '2017-11-14', NULL),
('4437', '1', '1106', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-14', '2067'),
('4438', '1', '1107', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2072'),
('4439', '1', '1108', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2073'),
('4440', '1', '1109', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2074'),
('4441', '1', '1110', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2075'),
('4442', '1', '1111', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2076'),
('4443', '1', '1112', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2077'),
('4444', '1', '1113', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2078'),
('4445', '1', '1114', '10', '2017-11-14 23:46:03', NULL, '3', '2017-11-15', NULL),
('4446', '1', '1115', '10', '2017-11-14 23:46:15', NULL, '3', '2017-11-15', NULL),
('4447', '1', '1116', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2079'),
('4448', '1', '1114', '10', '2017-11-14 23:46:03', 'Voided.\nDocument reentered.', '3', '2017-11-14', '0'),
('4449', '1', '1117', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2080'),
('4450', '1', '1115', '10', '2017-11-14 23:46:15', 'Voided.\nDocument reentered.', '3', '2017-11-14', '0'),
('4451', '1', '1118', '10', '2017-11-14 23:54:03', NULL, '3', '2017-11-15', NULL),
('4452', '1', '1119', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2081'),
('4453', '1', '1118', '10', '2017-11-14 23:54:03', 'Voided.\nDocument reentered.', '3', '2017-11-14', '0'),
('4454', '1', '1120', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-14', '2068'),
('4455', '1', '1121', '10', '2018-03-07 01:10:32', NULL, '3', '2017-11-14', NULL),
('4456', '1', '1122', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-14', '2069'),
('4457', '1', '1123', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2082'),
('4458', '1', '1124', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2083'),
('4459', '1', '1125', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2084'),
('4460', '1', '1126', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2085'),
('4461', '1', '1127', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2086'),
('4462', '1', '1128', '10', '2018-03-07 00:23:11', NULL, '3', '2017-11-15', NULL),
('4463', '1', '1129', '10', '2017-11-15 03:08:50', NULL, '3', '2017-11-15', NULL),
('4464', '1', '1130', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2087'),
('4465', '1', '1131', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2088'),
('4466', '1', '1132', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2089'),
('4467', '1', '1133', '10', '2018-03-07 01:18:45', NULL, '3', '2017-11-15', NULL),
('4468', '1', '1134', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2090'),
('4469', '1', '1135', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2091'),
('4470', '1', '1129', '10', '2017-11-15 03:08:50', 'Voided.\nDocument reentered.', '3', '2017-11-15', '0'),
('4471', '1', '1136', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2092'),
('4472', '1', '1137', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2093'),
('4473', '1', '1138', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2094'),
('4474', '1', '1139', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2095'),
('4475', '1', '1140', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2096'),
('4476', '1', '1141', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2097'),
('4477', '1', '1142', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2098'),
('4478', '1', '1143', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2099'),
('4479', '4', '52', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-16', '2104'),
('4480', '12', '342', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-16', '2105'),
('4481', '1', '1144', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-16', '2106'),
('4482', '1', '1145', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-16', '2107'),
('4483', '12', '343', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-16', '2108'),
('4484', '12', '344', '10', '2017-11-16 02:40:11', NULL, '3', '2017-11-16', NULL),
('4485', '12', '344', '10', '2017-11-16 02:40:25', 'Updated.', '3', '2017-11-16', NULL),
('4486', '12', '344', '10', '2017-11-16 02:40:40', 'Updated.', '3', '2017-11-16', NULL),
('4487', '12', '344', '10', '2017-11-16 02:40:52', 'Updated.', '3', '2017-11-16', NULL),
('4488', '12', '344', '10', '2017-11-16 02:41:22', 'Updated.', '3', '2017-11-16', NULL),
('4489', '12', '344', '10', '2017-11-16 02:44:23', 'Updated.', '3', '2017-11-16', NULL),
('4490', '12', '344', '10', '2017-11-16 02:44:23', 'Voided.\n', '3', '2017-11-16', '0'),
('4491', '1', '1146', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-07', '920'),
('4492', '1', '529', '10', '2017-11-16 02:50:54', 'Voided.\nDocument reentered.', '3', '2017-11-16', '0'),
('4493', '2', '63', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-16', '2109'),
('4494', '12', '345', '10', '2017-11-16 03:01:54', NULL, '3', '2017-11-16', NULL),
('4495', '12', '346', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-16', '2110'),
('4496', '12', '345', '10', '2017-11-16 03:01:54', 'Voided.\n', '3', '2017-11-16', '0'),
('4497', '12', '347', '10', '2018-01-10 23:17:33', NULL, '3', '2017-11-16', NULL),
('4498', '1', '1147', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-16', '2111'),
('4499', '1', '1148', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-16', '2112'),
('4500', '4', '53', '10', '2017-11-16 23:23:17', NULL, '3', '2017-11-17', NULL),
('4501', '1', '1149', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2120'),
('4502', '4', '53', '10', '2017-11-16 23:23:17', 'Voided.\nGl Account Entered wrongly', '3', '2017-11-17', '0'),
('4503', '1', '1027', '10', '2017-11-17 02:44:55', 'Voided.\nInvoice Amount Changed-Ashan boss Ask to Void', '3', '2017-11-17', '0'),
('4504', '12', '257', '10', '2017-11-17 03:54:08', 'Voided.\nReturned CHQ', '3', '2017-11-17', '0'),
('4505', '12', '297', '10', '2017-11-17 03:54:31', 'Voided.\nReturned CHQ', '3', '2017-11-17', '0'),
('4506', '2', '64', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2121'),
('4507', '1', '1150', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2122'),
('4508', '1', '1151', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2123'),
('4509', '1', '1152', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2124'),
('4510', '12', '124', '10', '2017-11-27 03:09:22', 'Updated.', '3', '2017-11-17', NULL),
('4511', '1', '1153', '10', '2017-11-17 05:30:22', NULL, '3', '2017-11-17', NULL),
('4512', '1', '1154', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2125'),
('4513', '1', '1155', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2126'),
('4514', '1', '1153', '10', '2017-11-17 05:30:22', 'Voided.\nDocument reentered.', '3', '2017-11-17', '0'),
('4515', '30', '738', '10', '2017-11-19 23:17:09', NULL, '3', '2017-11-20', '0'),
('4516', '13', '738', '10', '2017-11-19 23:49:12', NULL, '3', '2017-11-20', NULL),
('4517', '10', '735', '10', '2017-11-19 23:49:12', NULL, '3', '2017-11-20', NULL),
('4518', '30', '739', '10', '2017-11-19 23:48:38', NULL, '3', '2017-11-20', '0'),
('4519', '13', '739', '10', '2017-11-19 23:48:38', NULL, '3', '2017-11-20', '0'),
('4520', '13', '738', '10', '2017-11-19 23:49:12', 'Voided.', '3', '2017-11-19', '0'),
('4521', '10', '735', '10', '2017-11-19 23:49:12', 'Voided.\n', '3', '2017-11-19', '0'),
('4522', '4', '54', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-20', '2139'),
('4523', '1', '1156', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-20', '2140'),
('4524', '1', '1157', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-20', '2141'),
('4525', '1', '1158', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-20', '2142'),
('4526', '1', '1159', '10', '2018-03-06 23:52:52', NULL, '3', '2017-11-21', NULL),
('4527', '1', '1160', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-21', '2146'),
('4528', '1', '1161', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-21', '2147'),
('4529', '1', '1162', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-22', '2149'),
('4530', '1', '1163', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-22', '2150'),
('4531', '1', '1164', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-23', '2154'),
('4532', '1', '1165', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-23', '2155'),
('4533', '1', '1166', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-23', '2156'),
('4534', '4', '55', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-23', '2157'),
('4535', '1', '1167', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-23', '2158'),
('4536', '10', '50', '10', '2017-11-24 00:43:07', 'Updated.', '2', '2017-02-28', NULL),
('4537', '10', '486', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-27', '784'),
('4538', '10', '50', '10', '2018-01-25 04:36:19', 'Updated.', '2', '2017-02-28', NULL),
('4539', '1', '1168', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-24', '2163'),
('4540', '1', '1169', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-24', '2164'),
('4541', '1', '1170', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-24', '2165'),
('4542', '1', '1171', '10', '2018-03-06 23:53:30', NULL, '3', '2017-11-24', NULL),
('4543', '1', '1172', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-24', '2166'),
('4544', '1', '1173', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-23', '2159'),
('4545', '1', '1174', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '803'),
('4546', '1', '435', '10', '2017-11-24 03:44:14', 'Voided.\nDocument reentered.', '3', '2017-11-24', '0'),
('4547', '2', '65', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-24', '2167'),
('4548', '30', '740', '10', '2017-11-24 04:25:04', NULL, '3', '2017-11-24', '0'),
('4549', '13', '740', '10', '2017-11-24 04:25:04', NULL, '3', '2017-11-24', '0'),
('4550', '10', '736', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-24', '2168'),
('4551', '30', '741', '10', '2017-11-27 00:56:17', NULL, '3', '2017-11-26', '0'),
('4552', '13', '741', '10', '2017-11-27 00:56:17', NULL, '3', '2017-11-26', '0'),
('4553', '10', '737', '10', '2018-01-04 00:54:23', NULL, '3', '2017-11-26', NULL),
('4554', '30', '742', '10', '2017-11-27 00:59:16', NULL, '3', '2017-11-27', '0'),
('4555', '13', '742', '10', '2017-11-27 00:59:16', NULL, '3', '2017-11-27', '0'),
('4556', '30', '743', '10', '2017-11-27 01:18:22', NULL, '3', '2017-10-09', '0'),
('4557', '13', '743', '10', '2017-11-27 01:18:22', NULL, '3', '2017-10-09', '0'),
('4558', '10', '738', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-09', '1737'),
('4559', '30', '744', '10', '2017-11-27 01:19:34', NULL, '3', '2017-10-09', '0'),
('4560', '13', '744', '10', '2017-11-27 01:19:34', NULL, '3', '2017-10-09', '0'),
('4561', '10', '739', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-09', '1738'),
('4562', '30', '745', '10', '2017-11-27 01:20:29', NULL, '3', '2017-10-13', '0'),
('4563', '13', '745', '10', '2017-11-27 01:20:29', NULL, '3', '2017-10-13', '0'),
('4564', '10', '740', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-13', '1773'),
('4565', '30', '746', '10', '2017-11-27 01:21:20', NULL, '3', '2017-10-13', '0'),
('4566', '13', '746', '10', '2017-11-27 01:21:20', NULL, '3', '2017-10-13', '0'),
('4567', '10', '741', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-13', '1774'),
('4568', '30', '747', '10', '2017-11-27 01:25:00', NULL, '3', '2017-10-13', '0'),
('4569', '13', '747', '10', '2017-11-27 01:25:00', NULL, '3', '2017-10-13', '0'),
('4570', '10', '742', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-13', '1775'),
('4571', '30', '748', '10', '2017-11-27 01:26:26', NULL, '3', '2017-10-16', '0'),
('4572', '13', '748', '10', '2017-11-27 01:26:26', NULL, '3', '2017-10-16', '0'),
('4573', '10', '743', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1790'),
('4574', '30', '749', '10', '2017-11-27 01:29:14', NULL, '3', '2017-10-16', '0'),
('4575', '13', '749', '10', '2017-11-27 01:29:14', NULL, '3', '2017-10-16', '0'),
('4576', '10', '744', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1791'),
('4577', '30', '750', '10', '2017-11-27 01:31:41', NULL, '3', '2017-10-17', '0'),
('4578', '13', '750', '10', '2017-11-27 01:31:41', NULL, '3', '2017-10-17', '0'),
('4579', '10', '745', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-17', '1797'),
('4580', '30', '751', '10', '2017-11-27 01:32:54', NULL, '3', '2017-10-17', '0'),
('4581', '13', '751', '10', '2017-11-27 01:32:55', NULL, '3', '2017-10-17', '0'),
('4582', '10', '746', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-17', '1798'),
('4583', '30', '752', '10', '2017-11-27 01:35:19', NULL, '3', '2017-10-19', '0'),
('4584', '13', '752', '10', '2017-11-27 01:35:19', NULL, '3', '2017-10-19', '0'),
('4585', '10', '747', '10', '2018-01-25 23:18:54', NULL, '3', '2017-10-19', NULL),
('4586', '30', '753', '10', '2017-11-27 01:36:05', NULL, '3', '2017-10-19', '0'),
('4587', '13', '753', '10', '2017-11-27 01:36:05', NULL, '3', '2017-10-19', '0'),
('4588', '10', '748', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-19', '1808'),
('4589', '30', '754', '10', '2017-11-27 01:40:06', NULL, '3', '2017-10-23', '0'),
('4590', '13', '754', '10', '2017-11-27 01:40:06', NULL, '3', '2017-10-23', '0'),
('4591', '10', '749', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-23', '1853'),
('4592', '30', '755', '10', '2017-11-27 01:41:26', NULL, '3', '2017-10-27', '0'),
('4593', '13', '755', '10', '2017-11-27 01:41:26', NULL, '3', '2017-10-27', '0'),
('4594', '10', '750', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1898'),
('4595', '1', '1175', '10', '2017-11-27 04:26:09', NULL, '3', '2017-10-27', NULL),
('4596', '12', '124', '10', '2017-11-27 03:09:22', 'Voided.\nCHQ Returned', '3', '2017-11-27', '0'),
('4597', '30', '756', '10', '2017-11-27 03:11:22', NULL, '3', '2017-10-27', '0'),
('4598', '13', '756', '10', '2017-11-27 03:11:22', NULL, '3', '2017-10-27', '0'),
('4599', '10', '751', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1899'),
('4600', '30', '757', '10', '2017-11-27 03:12:58', NULL, '3', '2017-10-27', '0'),
('4601', '13', '757', '10', '2017-11-27 03:12:58', NULL, '3', '2017-10-27', '0'),
('4602', '10', '752', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1900'),
('4603', '30', '758', '10', '2017-11-27 03:14:10', NULL, '3', '2017-10-27', '0'),
('4604', '13', '758', '10', '2017-11-27 03:14:10', NULL, '3', '2017-10-27', '0'),
('4605', '10', '753', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1901'),
('4606', '30', '759', '10', '2017-11-27 03:15:06', NULL, '3', '2017-10-27', '0'),
('4607', '13', '759', '10', '2017-11-27 03:15:06', NULL, '3', '2017-10-27', '0'),
('4608', '10', '754', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1902'),
('4609', '12', '348', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-02', '1974'),
('4610', '30', '760', '10', '2017-11-27 03:31:25', NULL, '3', '2017-10-30', '0'),
('4611', '13', '760', '10', '2017-11-27 03:31:25', NULL, '3', '2017-10-30', '0'),
('4612', '10', '755', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1927'),
('4613', '30', '761', '10', '2017-11-27 03:34:55', NULL, '3', '2017-10-30', '0'),
('4614', '13', '761', '10', '2017-11-27 03:34:55', NULL, '3', '2017-10-30', '0'),
('4615', '10', '756', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1928'),
('4616', '30', '762', '10', '2017-11-27 03:44:33', NULL, '3', '2017-11-02', '0'),
('4617', '13', '762', '10', '2017-11-27 03:44:33', NULL, '3', '2017-11-02', '0'),
('4618', '10', '757', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-02', '1975'),
('4619', '30', '763', '10', '2017-11-27 03:47:15', NULL, '3', '2017-11-02', '0'),
('4620', '13', '763', '10', '2017-11-27 03:47:15', NULL, '3', '2017-11-02', '0'),
('4621', '10', '758', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-02', '1976'),
('4622', '30', '764', '10', '2017-11-27 03:48:11', NULL, '3', '2017-11-02', '0'),
('4623', '13', '764', '10', '2017-11-27 03:48:11', NULL, '3', '2017-11-02', '0'),
('4624', '10', '759', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-02', '1977'),
('4625', '30', '765', '10', '2017-11-27 03:55:33', NULL, '3', '2017-11-08', '0'),
('4626', '13', '765', '10', '2017-11-27 03:55:33', NULL, '3', '2017-11-08', '0'),
('4627', '10', '760', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-08', '2008'),
('4628', '30', '766', '10', '2017-11-27 04:04:20', NULL, '3', '2017-11-16', '0'),
('4629', '13', '766', '10', '2017-11-27 04:04:20', NULL, '3', '2017-11-16', '0'),
('4630', '10', '761', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-16', '2113'),
('4631', '30', '767', '10', '2017-11-27 04:05:23', NULL, '3', '2017-11-16', '0'),
('4632', '13', '767', '10', '2017-11-27 04:05:23', NULL, '3', '2017-11-16', '0'),
('4633', '10', '762', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-16', '2114'),
('4634', '1', '1176', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2182'),
('4635', '1', '1175', '10', '2017-11-27 04:26:09', 'Voided.\nDocument reentered.', '3', '2017-11-27', '0'),
('4636', '12', '349', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-13', '2056'),
('4637', '1', '1177', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2183'),
('4638', '1', '1178', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2184'),
('4639', '1', '1179', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2185'),
('4640', '1', '1180', '10', '2017-12-04 00:36:57', NULL, '3', '2017-11-27', NULL),
('4641', '1', '1181', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2203'),
('4642', '1', '1182', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2204'),
('4643', '1', '1183', '10', '2017-11-27 23:42:10', NULL, '3', '2017-11-28', NULL),
('4644', '1', '1184', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2205'),
('4645', '1', '1185', '10', '2017-11-27 23:42:40', NULL, '3', '2017-11-28', NULL),
('4646', '1', '1186', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2206'),
('4647', '1', '1183', '10', '2017-11-27 23:42:10', 'Voided.\nDocument reentered.', '3', '2017-11-27', '0'),
('4648', '1', '1187', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2207'),
('4649', '1', '1185', '10', '2017-11-27 23:42:40', 'Voided.\nDocument reentered.', '3', '2017-11-27', '0'),
('4650', '30', '768', '10', '2017-11-28 00:25:45', NULL, '3', '2017-11-02', '0'),
('4651', '13', '768', '10', '2017-11-28 00:25:45', NULL, '3', '2017-11-02', '0'),
('4652', '10', '763', '10', '2018-03-16 06:44:57', NULL, '3', '2017-11-02', NULL),
('4653', '12', '350', '10', '2018-03-16 06:45:39', NULL, '3', '2017-11-28', NULL),
('4654', '30', '769', '10', '2017-11-28 00:28:25', NULL, '3', '2017-10-31', '0'),
('4655', '13', '769', '10', '2017-11-28 00:28:25', NULL, '3', '2017-10-31', '0'),
('4656', '10', '764', '10', '2017-11-28 00:31:25', NULL, '3', '2017-10-31', NULL),
('4657', '30', '770', '10', '2017-11-28 00:30:49', NULL, '3', '2017-10-31', '0'),
('4658', '13', '770', '10', '2017-11-28 00:30:49', NULL, '3', '2017-10-31', '0'),
('4659', '10', '765', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1945'),
('4660', '10', '764', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-10-31', '1946'),
('4661', '12', '351', '10', '2018-01-03 06:39:39', NULL, '3', '2017-11-28', NULL),
('4662', '30', '771', '10', '2017-11-28 01:31:14', NULL, '3', '2017-10-31', '0'),
('4663', '13', '771', '10', '2017-11-28 01:31:15', NULL, '3', '2017-10-31', '0'),
('4664', '10', '766', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1947'),
('4665', '30', '772', '10', '2017-11-28 01:33:18', NULL, '3', '2017-10-31', '0'),
('4666', '13', '772', '10', '2017-11-28 01:33:18', NULL, '3', '2017-10-31', '0'),
('4667', '10', '767', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1948'),
('4668', '30', '773', '10', '2017-11-28 01:36:48', NULL, '3', '2017-10-31', '0'),
('4669', '13', '773', '10', '2017-11-28 01:36:48', NULL, '3', '2017-10-31', '0'),
('4670', '10', '768', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1949'),
('4671', '10', '660', '10', '2018-02-04 23:52:38', 'Updated.', '3', '2016-09-30', NULL),
('4672', '18', '23', '1', '2017-11-28 07:36:53', NULL, '3', '2017-11-28', '0'),
('4673', '1', '1188', '1', '2017-11-28 07:48:33', NULL, '3', '2017-11-28', NULL),
('4674', '1', '1188', '1', '2017-11-28 07:48:33', 'Voided.\n', '3', '2017-11-28', '0'),
('4675', '4', '56', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-29', '2226'),
('4676', '1', '1189', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-29', '2227'),
('4677', '1', '1190', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-29', '2228'),
('4678', '1', '1191', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-29', '2229'),
('4679', '30', '774', '10', '2017-11-29 22:49:33', NULL, '3', '2017-11-30', '0'),
('4680', '13', '774', '10', '2017-11-29 22:49:33', NULL, '3', '2017-11-30', '0'),
('4681', '12', '352', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2234'),
('4682', '12', '353', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2235'),
('4683', '12', '354', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2236'),
('4684', '12', '355', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2237'),
('4685', '12', '356', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2238'),
('4686', '12', '357', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2239'),
('4687', '12', '358', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2240'),
('4688', '12', '359', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-14', '2399'),
('4689', '12', '360', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2241'),
('4690', '12', '361', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2242'),
('4691', '12', '362', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-28', '2502'),
('4692', '12', '363', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-15', '2417'),
('4693', '12', '364', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2292'),
('4694', '12', '365', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2243'),
('4695', '12', '366', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2244'),
('4696', '12', '367', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2245'),
('4697', '12', '368', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2246'),
('4698', '12', '369', '10', '2018-02-08 01:27:18', NULL, '3', '2017-12-15', NULL),
('4699', '12', '370', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2293'),
('4700', '11', '56', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2247'),
('4701', '12', '371', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-15', '2629'),
('4702', '12', '372', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-06', '2827'),
('4703', '12', '373', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2248'),
('4704', '12', '374', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2249'),
('4705', '11', '57', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2250'),
('4706', '12', '375', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2208'),
('4707', '12', '376', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2209'),
('4708', '12', '377', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2210'),
('4709', '11', '58', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2251'),
('4710', '12', '378', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2211'),
('4711', '12', '379', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2212'),
('4712', '12', '380', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2213'),
('4713', '12', '381', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2214'),
('4714', '11', '59', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2252'),
('4715', '12', '382', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2215'),
('4716', '11', '60', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2253'),
('4717', '12', '383', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2216'),
('4718', '11', '61', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2254'),
('4719', '11', '62', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2255'),
('4720', '12', '384', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2217'),
('4721', '11', '63', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2256'),
('4722', '11', '64', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2257'),
('4723', '11', '65', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2258'),
('4724', '30', '775', '10', '2017-11-30 00:28:16', NULL, '3', '2017-05-31', '0'),
('4725', '13', '775', '10', '2017-11-30 00:28:17', NULL, '3', '2017-05-31', '0'),
('4726', '10', '769', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '576'),
('4727', '11', '66', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2259'),
('4728', '13', '471', '10', '2017-11-30 00:29:32', 'Voided.', '3', '2017-11-30', '0'),
('4729', '10', '474', '10', '2017-11-30 00:29:32', 'Voided.\n', '3', '2017-05-31', '0'),
('4730', '12', '385', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2260'),
('4731', '12', '386', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-27', '2494'),
('4732', '12', '387', '10', '2018-08-01 04:55:40', NULL, '5', '2018-02-16', NULL),
('4733', '1', '1192', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2261'),
('4734', '1', '1193', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-23', '1854'),
('4735', '1', '1001', '10', '2017-11-30 01:41:07', 'Voided.\nDocument reentered.', '3', '2017-11-30', '0'),
('4736', '1', '1194', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2262'),
('4737', '1', '1195', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2263'),
('4738', '1', '1196', '10', '2018-03-06 23:55:42', NULL, '3', '2017-11-30', NULL),
('4739', '12', '388', '10', '2017-11-30 04:02:05', NULL, '3', '2017-11-30', NULL),
('4740', '12', '388', '10', '2018-01-07 23:32:40', 'Updated.', '3', '2017-12-15', NULL),
('4741', '11', '67', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2294'),
('4742', '11', '68', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2295'),
('4743', '1', '1197', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2296'),
('4744', '1', '1198', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2297'),
('4745', '1', '1199', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2186'),
('4746', '1', '1180', '10', '2017-12-04 00:36:57', 'Voided.\nDocument reentered.', '3', '2017-12-04', '0'),
('4747', '1', '1200', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-20', '2143'),
('4748', '1', '1201', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2187'),
('4749', '1', '1202', '10', '2017-12-04 00:54:26', NULL, '3', '2017-11-27', NULL),
('4750', '1', '1203', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2188'),
('4751', '1', '1202', '10', '2017-12-04 00:54:26', 'Voided.\nDocument reentered.', '3', '2017-12-04', '0'),
('4752', '1', '1204', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2189'),
('4753', '30', '776', '10', '2017-12-04 01:38:30', NULL, '3', '2017-12-04', '0'),
('4754', '13', '776', '10', '2017-12-04 01:38:30', NULL, '3', '2017-12-04', '0'),
('4755', '10', '770', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2298'),
('4756', '4', '57', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2299'),
('4757', '1', '1205', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2300'),
('4758', '1', '1206', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-29', '2230'),
('4759', '18', '24', '10', '2017-12-04 02:46:36', NULL, '3', '2017-10-19', '0'),
('4760', '25', '23', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-19', '1809'),
('4761', '20', '73', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-19', '1810'),
('4762', '22', '29', '10', '2018-01-10 22:58:04', NULL, '3', '2017-12-04', NULL),
('4763', '1', '1207', '10', '2018-01-10 22:54:50', NULL, '3', '2017-12-04', NULL),
('4764', '1', '1208', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2301'),
('4765', '1', '1209', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2302'),
('4766', '1', '1210', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2303'),
('4767', '1', '1211', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-05', '2320'),
('4768', '1', '1212', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-05', '2321'),
('4769', '1', '1213', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-05', '2322'),
('4770', '1', '1214', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-05', '2323'),
('4771', '1', '1215', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-05', '2324'),
('4772', '1', '1216', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-05', '2325'),
('4773', '20', '74', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-20', '2144'),
('4774', '20', '75', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-01', '1961'),
('4775', '22', '30', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-05', '2326'),
('4776', '1', '1217', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-05', '2327'),
('4777', '1', '1218', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-05', '2328'),
('4778', '18', '25', '10', '2017-12-05 04:04:16', NULL, '2', '2017-02-21', '0'),
('4779', '25', '24', '10', '2017-12-05 04:04:16', NULL, '2', '2017-02-21', '0'),
('4780', '20', '76', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-21', '341'),
('4781', '18', '26', '10', '2017-12-05 04:05:29', NULL, '2', '2017-02-08', '0'),
('4782', '25', '25', '10', '2017-12-05 04:05:29', NULL, '2', '2017-02-08', '0'),
('4783', '20', '77', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-08', '314'),
('4784', '18', '27', '10', '2017-12-05 04:06:20', NULL, '2', '2017-02-14', '0'),
('4785', '25', '26', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-14', '330'),
('4786', '20', '78', '10', '2019-11-05 05:45:21', NULL, '2', '2017-02-14', '331'),
('4787', '18', '28', '10', '2017-12-05 04:07:51', NULL, '2', '2017-03-08', '0'),
('4788', '25', '27', '10', '2017-12-05 04:07:51', NULL, '2', '2017-03-08', '0'),
('4789', '20', '79', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-08', '384'),
('4790', '18', '29', '10', '2017-12-05 04:08:52', NULL, '2', '2017-03-15', '0'),
('4791', '25', '28', '10', '2017-12-05 04:08:52', NULL, '2', '2017-03-15', '0'),
('4792', '20', '80', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-15', '406'),
('4793', '18', '30', '10', '2017-12-05 04:09:51', NULL, '2', '2017-03-15', '0'),
('4794', '25', '29', '10', '2017-12-05 04:09:51', NULL, '2', '2017-03-15', '0'),
('4795', '20', '81', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-15', '407'),
('4796', '18', '31', '10', '2017-12-05 04:10:31', NULL, '2', '2017-03-22', '0'),
('4797', '25', '30', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-22', '421'),
('4798', '20', '82', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-22', '422'),
('4799', '1', '1219', '10', '2017-12-05 04:19:38', NULL, '3', '2017-03-22', NULL),
('4800', '1', '1220', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-05', '2329'),
('4801', '1', '1219', '10', '2017-12-05 04:19:38', 'Voided.\nDocument reentered.', '3', '2017-12-05', '0'),
('4802', '1', '1221', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-23', '2160'),
('4803', '1', '1222', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2190'),
('4804', '1', '1223', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-06', '2334'),
('4805', '1', '1224', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2264'),
('4806', '1', '1225', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2265'),
('4807', '1', '1226', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-05', '2330'),
('4808', '1', '1227', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-05', '2331'),
('4809', '1', '1228', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-05', '2332'),
('4810', '12', '389', '10', '2018-01-23 02:22:02', NULL, '3', '2017-12-06', NULL),
('4811', '1', '1229', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1140'),
('4812', '1', '689', '10', '2017-12-06 01:27:12', 'Voided.\nDocument reentered.', '3', '2017-12-06', '0'),
('4813', '1', '1230', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-06', '2335'),
('4814', '1', '1231', '10', '2017-12-06 02:27:32', NULL, '3', '2017-12-06', NULL),
('4815', '1', '1232', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-06', '2336'),
('4816', '1', '1231', '10', '2017-12-06 02:27:32', 'Voided.\nDocument reentered.', '3', '2017-12-06', '0'),
('4817', '2', '66', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-05', '2333'),
('4818', '1', '1233', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-06', '2337'),
('4819', '1', '1234', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-06', '2338'),
('4820', '2', '67', '10', '2018-08-01 08:56:42', NULL, '5', '2017-10-25', NULL),
('4821', '13', '687', '10', '2017-12-06 23:48:48', 'Voided.', '3', '2017-12-06', '0'),
('4822', '10', '684', '10', '2017-12-06 23:48:48', 'Voided.\nItem Code Change.Umasha requested to re Invoice', '3', '2017-12-07', '0'),
('4823', '30', '777', '10', '2017-12-06 23:50:28', NULL, '3', '2017-09-29', '0'),
('4824', '13', '777', '10', '2017-12-06 23:50:28', NULL, '3', '2017-09-29', '0'),
('4825', '10', '771', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1672'),
('4826', '13', '688', '10', '2017-12-06 23:51:57', 'Voided.', '3', '2017-12-06', '0'),
('4827', '10', '685', '10', '2017-12-06 23:51:57', 'Voided.\nItem Code Change.Umasha requested to re Invoice', '3', '2017-12-06', '0'),
('4828', '30', '778', '10', '2017-12-06 23:52:05', NULL, '3', '2017-09-29', '0'),
('4829', '13', '778', '10', '2017-12-06 23:52:05', NULL, '3', '2017-09-29', '0'),
('4830', '10', '772', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1673'),
('4831', '13', '689', '10', '2017-12-06 23:53:01', 'Voided.', '3', '2017-12-06', '0'),
('4832', '10', '686', '10', '2017-12-06 23:53:01', 'Voided.\nItem Code Change.Umasha requested to re Invoice', '3', '2017-12-06', '0'),
('4833', '30', '779', '10', '2017-12-06 23:54:24', NULL, '3', '2017-09-29', '0'),
('4834', '13', '779', '10', '2017-12-06 23:54:24', NULL, '3', '2017-09-29', '0'),
('4835', '10', '773', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1674'),
('4836', '13', '690', '10', '2017-12-06 23:55:45', 'Voided.', '3', '2017-12-06', '0'),
('4837', '10', '687', '10', '2017-12-06 23:55:45', 'Voided.\nItem Code Change.Umasha ask to reprint', '3', '2017-12-06', '0'),
('4838', '30', '780', '10', '2017-12-06 23:56:47', NULL, '3', '2017-09-29', '0'),
('4839', '13', '780', '10', '2017-12-06 23:56:47', NULL, '3', '2017-09-29', '0'),
('4840', '10', '774', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1675'),
('4841', '13', '691', '10', '2017-12-06 23:58:03', 'Voided.', '3', '2017-12-06', '0'),
('4842', '10', '688', '10', '2017-12-06 23:58:03', 'Voided.\nItem Code Change.Umasha ask to reprint', '3', '2017-12-06', '0'),
('4843', '30', '781', '10', '2017-12-06 23:59:17', NULL, '3', '2017-09-29', '0'),
('4844', '13', '781', '10', '2017-12-07 00:10:33', NULL, '3', '2017-09-29', NULL),
('4845', '10', '775', '10', '2017-12-07 00:10:33', NULL, '3', '2017-09-29', NULL),
('4846', '13', '781', '10', '2017-12-07 00:10:33', 'Voided.', '3', '2017-12-07', '0'),
('4847', '10', '775', '10', '2017-12-07 00:10:33', 'Voided.\n', '3', '2017-12-06', '0'),
('4848', '30', '782', '10', '2017-12-07 00:11:18', NULL, '3', '2017-09-29', '0'),
('4849', '13', '782', '10', '2017-12-07 00:11:19', NULL, '3', '2017-09-29', '0'),
('4850', '10', '776', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1676'),
('4851', '13', '620', '10', '2017-12-07 00:15:35', 'Voided.', '3', '2017-12-07', '0'),
('4852', '10', '618', '10', '2017-12-07 00:15:35', 'Voided.\nItem Code Changed', '3', '2017-12-07', '0'),
('4853', '30', '783', '10', '2017-12-07 00:17:03', NULL, '3', '2017-08-31', '0'),
('4854', '13', '783', '10', '2017-12-07 00:17:03', NULL, '3', '2017-08-31', '0'),
('4855', '10', '777', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1405'),
('4856', '30', '784', '10', '2017-12-07 00:33:56', NULL, '3', '2017-04-26', '0'),
('4857', '13', '784', '10', '2017-12-07 00:33:56', NULL, '3', '2017-04-26', '0'),
('4858', '30', '785', '10', '2017-12-07 00:42:48', NULL, '3', '2017-12-07', '0'),
('4859', '13', '785', '10', '2017-12-07 00:42:48', NULL, '3', '2017-12-07', '0'),
('4860', '1', '1235', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-07', '2342'),
('4861', '1', '1236', '10', '2018-03-06 23:57:38', NULL, '3', '2017-12-07', NULL),
('4862', '1', '1237', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-07', '2343'),
('4863', '1', '1238', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-07', '2344'),
('4864', '1', '1239', '10', '2017-12-07 03:40:07', NULL, '3', '2017-12-07', NULL),
('4865', '1', '1239', '10', '2017-12-07 03:40:07', 'Voided.\n', '3', '2017-12-07', '0'),
('4866', '1', '1240', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-07', '2345'),
('4867', '1', '1241', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-07', '2346'),
('4868', '1', '1242', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-07', '2347'),
('4869', '11', '69', '10', '2017-12-07 04:44:36', NULL, '3', '2016-12-30', NULL),
('4870', '11', '70', '10', '2017-12-07 04:44:28', NULL, '3', '2016-12-30', NULL),
('4871', '11', '71', '10', '2017-12-07 04:44:21', NULL, '3', '2016-12-30', NULL),
('4872', '11', '71', '10', '2017-12-07 04:44:21', 'Voided.\n', '3', '2017-12-07', '0'),
('4873', '11', '70', '10', '2017-12-07 04:44:28', 'Voided.\n', '3', '2017-12-07', '0'),
('4874', '11', '69', '10', '2017-12-07 04:44:36', 'Voided.\n', '3', '2017-12-07', '0'),
('4875', '11', '72', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-30', '228'),
('4876', '11', '73', '10', '2019-11-05 05:45:21', NULL, '2', '2016-12-30', '229'),
('4877', '1', '1243', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-07', '2348'),
('4878', '1', '1244', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-07', '2349'),
('4879', '1', '1245', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-11', '2361'),
('4880', '1', '1246', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-11', '2362'),
('4881', '1', '1247', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-11', '2363'),
('4882', '1', '1248', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-11', '2364'),
('4883', '1', '1249', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2025'),
('4884', '1', '1081', '10', '2017-12-11 02:49:58', 'Voided.\nDocument reentered.', '3', '2017-12-11', '0'),
('4885', '1', '1250', '10', '2017-12-11 02:54:04', NULL, '3', '2017-11-09', NULL),
('4886', '1', '1251', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-11', '2365'),
('4887', '1', '1250', '10', '2017-12-11 02:54:04', 'Voided.\nDocument reentered.', '3', '2017-12-11', '0'),
('4888', '1', '1252', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-04', '1984'),
('4889', '1', '1253', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-11', '2366'),
('4890', '1', '1254', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-11', '2367'),
('4891', '0', '18', '1', '2017-12-11 05:07:39', 'Voided.\nDocument reentered.', '3', '2017-12-11', '0'),
('4892', '0', '19', '1', '2017-12-11 05:19:18', NULL, '3', '2017-03-31', NULL),
('4893', '11', '74', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2304'),
('4894', '0', '19', '1', '2017-12-11 05:19:18', 'Voided.\nDocument reentered.', '3', '2017-12-11', '0'),
('4895', '0', '20', '1', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '490'),
('4896', '1', '1255', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2373'),
('4897', '12', '390', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-26', '223'),
('4898', '1', '1256', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2374'),
('4899', '1', '1257', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2375'),
('4900', '1', '1258', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2376'),
('4901', '1', '1259', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2377'),
('4902', '1', '1260', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2378'),
('4903', '1', '1261', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2379'),
('4904', '1', '1262', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2380'),
('4905', '1', '1263', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2381'),
('4906', '4', '58', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2382'),
('4907', '12', '391', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2383'),
('4908', '12', '392', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2384'),
('4909', '12', '393', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-18', '2431'),
('4910', '12', '394', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-28', '2503'),
('4911', '12', '395', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2529'),
('4912', '12', '396', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-15', '2630'),
('4913', '1', '1264', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-11', '2368'),
('4914', '1', '1265', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-10', '2360'),
('4915', '1', '1266', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-08', '2353');
INSERT INTO `0_audit_trail` VALUES
('4916', '1', '1267', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-07', '2350'),
('4917', '1', '1268', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-07', '2351'),
('4918', '1', '1269', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1884'),
('4919', '1', '1270', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-23', '1855'),
('4920', '1', '1271', '10', '2017-12-12 04:25:10', NULL, '3', '2017-11-28', NULL),
('4921', '1', '1272', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2218'),
('4922', '1', '1271', '10', '2017-12-12 04:25:10', 'Voided.\nDocument reentered.', '3', '2017-12-12', '0'),
('4923', '1', '1273', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2266'),
('4924', '1', '1274', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '24'),
('4925', '1', '1275', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '25'),
('4926', '1', '1276', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '26'),
('4927', '1', '1277', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '253'),
('4928', '1', '1278', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '254'),
('4929', '1', '1279', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '255'),
('4930', '1', '1280', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '609'),
('4931', '1', '1281', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-22', '734'),
('4932', '1', '1282', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-23', '753'),
('4933', '1', '1283', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '785'),
('4934', '1', '1284', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '786'),
('4935', '1', '1285', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '787'),
('4936', '1', '1286', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '788'),
('4937', '1', '1287', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '789'),
('4938', '1', '1288', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '790'),
('4939', '1', '1289', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '804'),
('4940', '1', '1290', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '844'),
('4941', '2', '68', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-05', '621'),
('4942', '2', '69', '10', '2018-08-01 08:51:43', NULL, '5', '2017-06-27', NULL),
('4943', '2', '70', '10', '2017-12-13 00:20:45', NULL, '3', '2017-06-21', NULL),
('4944', '2', '70', '10', '2018-01-08 05:46:14', NULL, '3', '2017-06-21', NULL),
('4945', '4', '59', '10', '2017-12-13 00:25:36', NULL, '3', '2017-06-30', '0'),
('4946', '4', '60', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '845'),
('4947', '1', '1291', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-13', '2392'),
('4948', '1', '1292', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-13', '2393'),
('4949', '1', '1293', '10', '2017-12-13 03:35:12', NULL, '3', '2017-12-13', NULL),
('4950', '1', '1294', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-13', '2394'),
('4951', '1', '1293', '10', '2017-12-13 03:35:12', 'Voided.\nDocument reentered.', '3', '2017-12-13', '0'),
('4952', '12', '397', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-03', '868'),
('4953', '12', '398', '10', '2018-01-08 05:38:56', NULL, '3', '2017-12-14', NULL),
('4954', '1', '1295', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-14', '2400'),
('4955', '1', '1296', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-14', '2401'),
('4956', '12', '399', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '451'),
('4957', '30', '786', '10', '2017-12-14 02:47:56', NULL, '3', '2017-12-04', '0'),
('4958', '13', '786', '10', '2018-03-19 04:29:17', NULL, '3', '2017-12-04', NULL),
('4959', '10', '778', '10', '2018-01-04 00:47:49', NULL, '3', '2017-12-04', NULL),
('4960', '30', '787', '10', '2017-12-14 02:50:32', NULL, '3', '2017-12-04', '0'),
('4961', '13', '787', '10', '2017-12-14 02:50:32', NULL, '3', '2017-12-04', '0'),
('4962', '10', '779', '10', '2018-03-16 06:45:13', NULL, '3', '2017-12-04', NULL),
('4963', '1', '1297', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-14', '2402'),
('4964', '1', '1298', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-14', '2403'),
('4965', '1', '1299', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2385'),
('4966', '1', '1300', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-14', '2404'),
('4967', '1', '1301', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-14', '2405'),
('4968', '1', '1302', '10', '2018-03-07 01:25:06', NULL, '3', '2017-12-14', NULL),
('4969', '1', '1303', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-14', '2406'),
('4970', '1', '1304', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-14', '2407'),
('4971', '12', '400', '10', '2018-03-16 06:45:50', NULL, '3', '2017-12-14', NULL),
('4972', '12', '401', '10', '2018-01-08 05:07:47', NULL, '3', '2017-12-14', NULL),
('4973', '30', '788', '10', '2017-12-14 03:44:48', NULL, '3', '2017-12-14', '0'),
('4974', '13', '788', '10', '2017-12-14 03:44:48', NULL, '3', '2017-12-14', '0'),
('4975', '10', '780', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-14', '2408'),
('4976', '30', '789', '10', '2017-12-14 03:46:41', NULL, '3', '2017-12-14', '0'),
('4977', '13', '789', '10', '2017-12-14 03:46:41', NULL, '3', '2017-12-14', '0'),
('4978', '10', '781', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-14', '2409'),
('4979', '30', '790', '10', '2017-12-14 03:47:50', NULL, '3', '2017-12-14', '0'),
('4980', '13', '790', '10', '2017-12-14 04:13:06', NULL, '3', '2017-12-14', NULL),
('4981', '10', '782', '10', '2017-12-14 04:13:06', NULL, '3', '2017-12-14', NULL),
('4982', '13', '790', '10', '2017-12-14 04:13:06', 'Voided.', '3', '2017-12-14', '0'),
('4983', '10', '782', '10', '2017-12-14 04:13:06', 'Voided.\n', '3', '2017-12-14', '0'),
('4984', '30', '791', '10', '2017-12-14 04:14:08', NULL, '3', '2017-12-14', '0'),
('4985', '13', '791', '10', '2018-01-16 01:40:09', NULL, '3', '2017-12-14', NULL),
('4986', '10', '783', '10', '2018-01-16 01:40:09', NULL, '3', '2017-12-14', NULL),
('4987', '1', '1305', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-14', '2410'),
('4988', '1', '1306', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-26', '1084'),
('4989', '1', '1307', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-26', '1085'),
('4990', '1', '1308', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1100'),
('4991', '1', '1309', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1101'),
('4992', '1', '1310', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1102'),
('4993', '1', '1311', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1103'),
('4994', '1', '1312', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1141'),
('4995', '1', '1313', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1142'),
('4996', '4', '61', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-27', '1104'),
('4997', '1', '1314', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-14', '2411'),
('4998', '4', '62', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-15', '2418'),
('4999', '1', '1315', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-15', '2419'),
('5000', '1', '1316', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-15', '2420'),
('5001', '30', '792', '10', '2017-12-15 00:39:27', NULL, '2', '2016-10-18', '0'),
('5002', '13', '792', '10', '2017-12-15 00:39:27', NULL, '2', '2016-10-18', '0'),
('5003', '10', '784', '10', '2019-11-05 05:45:21', NULL, '2', '2016-10-18', '153'),
('5004', '12', '402', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-24', '201'),
('5005', '12', '403', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-06', '67'),
('5006', '1', '1317', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-02', '1164'),
('5007', '1', '1318', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-10', '1238'),
('5008', '1', '1319', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-10', '1239'),
('5009', '1', '1320', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1359'),
('5010', '1', '1321', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1360'),
('5011', '1', '1322', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1361'),
('5012', '1', '1323', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1362'),
('5013', '1', '1324', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1363'),
('5014', '1', '1325', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1364'),
('5015', '1', '1326', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-30', '1385'),
('5016', '1', '1327', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1406'),
('5017', '4', '63', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1407'),
('5018', '4', '64', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1365'),
('5019', '1', '1328', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-15', '2421'),
('5020', '30', '793', '10', '2017-12-15 01:37:29', NULL, '3', '2017-12-15', '0'),
('5021', '13', '793', '10', '2017-12-15 01:37:30', NULL, '3', '2017-12-15', '0'),
('5022', '10', '785', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-15', '2422'),
('5023', '12', '404', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-15', '2423'),
('5024', '1', '1329', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-15', '2424'),
('5025', '1', '1330', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-15', '2425'),
('5026', '1', '1331', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-15', '2426'),
('5027', '1', '1332', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-15', '2427'),
('5028', '16', '29', '10', '2017-12-18 00:04:26', NULL, '3', '2017-12-18', '0'),
('5029', '1', '1333', '10', '2017-12-18 03:19:40', NULL, '3', '2017-04-12', NULL),
('5030', '2', '71', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '27'),
('5031', '2', '72', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-12', '137'),
('5032', '1', '1333', '10', '2017-12-18 03:19:40', 'Voided.\n', '3', '2017-12-18', '0'),
('5033', '1', '1334', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '536'),
('5034', '1', '1335', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '537'),
('5035', '2', '73', '10', '2018-08-06 03:46:24', NULL, '5', '2017-05-19', NULL),
('5036', '2', '74', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '452'),
('5037', '1', '1336', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '805'),
('5038', '1', '1337', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '806'),
('5039', '1', '1338', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '577'),
('5040', '1', '1339', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-29', '817'),
('5041', '1', '1340', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-29', '818'),
('5042', '1', '1341', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-29', '819'),
('5043', '1', '1342', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-05', '896'),
('5044', '1', '1343', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-05', '897'),
('5045', '1', '1344', '10', '2017-12-18 04:00:56', NULL, '3', '2017-07-05', NULL),
('5046', '1', '1345', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-07', '921'),
('5047', '1', '1346', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-12', '963'),
('5048', '1', '1347', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-20', '1024'),
('5049', '1', '1348', '10', '2018-08-02 05:15:19', NULL, '5', '2017-07-20', NULL),
('5050', '1', '1349', '10', '2017-12-18 04:02:53', NULL, '3', '2017-07-05', NULL),
('5051', '1', '1344', '10', '2017-12-18 04:00:56', 'Voided.\nDocument reentered.', '3', '2017-12-18', '0'),
('5052', '1', '1350', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-05', '898'),
('5053', '1', '1349', '10', '2017-12-18 04:02:53', 'Voided.\nDocument reentered.', '3', '2017-12-18', '0'),
('5054', '1', '1351', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-21', '1305'),
('5055', '1', '1352', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-22', '1314'),
('5056', '1', '1353', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-22', '1315'),
('5057', '1', '1354', '10', '2018-01-08 00:57:29', NULL, '3', '2017-08-23', NULL),
('5058', '1', '1355', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-24', '1333'),
('5059', '1', '1356', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-29', '1374'),
('5060', '2', '75', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-22', '1316'),
('5061', '2', '76', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-22', '1317'),
('5062', '1', '1357', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-28', '1116'),
('5063', '1', '631', '10', '2017-12-18 05:00:50', 'Voided.\nDocument reentered.', '3', '2017-12-18', '0'),
('5064', '1', '1358', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-01', '1420'),
('5065', '1', '1359', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1639'),
('5066', '1', '1360', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1640'),
('5067', '1', '1361', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1641'),
('5068', '1', '1362', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1642'),
('5069', '1', '1363', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1643'),
('5070', '1', '1364', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1644'),
('5071', '1', '1365', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1645'),
('5072', '1', '1366', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1663'),
('5073', '1', '1367', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-30', '1688'),
('5074', '2', '77', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1646'),
('5075', '4', '65', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1366'),
('5076', '1', '1368', '10', '2018-01-04 04:09:24', NULL, '3', '2017-09-22', NULL),
('5077', '1', '1369', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-26', '1620'),
('5078', '1', '1370', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-26', '1621'),
('5079', '1', '1371', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1677'),
('5080', '1', '919', '10', '2017-12-18 23:44:00', 'Voided.\nDocument reentered.', '3', '2017-12-18', '0'),
('5081', '4', '66', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-22', '1592'),
('5082', '4', '67', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-22', '1593'),
('5083', '4', '68', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-19', '1811'),
('5084', '4', '69', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1903'),
('5085', '1', '1372', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-26', '1890'),
('5086', '1', '1373', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-26', '1891'),
('5087', '1', '1374', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1904'),
('5088', '1', '1375', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1905'),
('5089', '1', '1376', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1906'),
('5090', '1', '1377', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1907'),
('5091', '1', '1378', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1908'),
('5092', '1', '1379', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1909'),
('5093', '1', '1380', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1910'),
('5094', '1', '1381', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1911'),
('5095', '1', '1382', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1950'),
('5096', '1', '1383', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-19', '2440'),
('5097', '30', '794', '10', '2017-12-19 02:23:27', NULL, '3', '2017-11-02', '0'),
('5098', '13', '794', '10', '2017-12-19 02:23:27', NULL, '3', '2017-11-02', '0'),
('5099', '10', '786', '10', '2018-03-16 06:46:18', NULL, '3', '2017-11-02', NULL),
('5100', '30', '795', '10', '2017-12-19 02:24:43', NULL, '3', '2017-11-02', '0'),
('5101', '13', '795', '10', '2018-03-19 04:05:19', NULL, '3', '2017-11-02', NULL),
('5102', '10', '787', '10', '2018-01-04 02:30:55', NULL, '3', '2017-11-02', NULL),
('5103', '12', '405', '10', '2018-01-08 05:14:09', NULL, '3', '2017-12-19', NULL),
('5104', '12', '406', '10', '2018-03-16 06:46:29', NULL, '3', '2017-12-19', NULL),
('5105', '1', '1384', '10', '2017-12-19 05:18:03', NULL, '3', '2017-12-19', NULL),
('5106', '1', '1385', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-19', '2441'),
('5107', '1', '1386', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-11', '2369'),
('5108', '1', '1387', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-18', '2432'),
('5109', '1', '1388', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2386'),
('5110', '1', '1389', '10', '2018-03-07 01:20:30', NULL, '3', '2017-12-12', NULL),
('5111', '1', '1390', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2387'),
('5112', '1', '1391', '10', '2018-03-07 01:19:50', NULL, '3', '2017-12-12', NULL),
('5113', '1', '1392', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-16', '2430'),
('5114', '1', '1393', '1', '2017-12-20 23:36:06', NULL, '3', '2017-12-19', NULL),
('5115', '1', '1384', '1', '2017-12-19 05:18:03', 'Voided.\nDocument reentered.', '3', '2017-12-19', '0'),
('5116', '12', '407', '10', '2018-01-08 05:17:30', NULL, '3', '2017-12-04', NULL),
('5117', '12', '408', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2305'),
('5118', '12', '409', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2306'),
('5119', '12', '410', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2307'),
('5120', '12', '411', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2308'),
('5121', '12', '412', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2309'),
('5122', '30', '796', '10', '2017-12-19 23:04:45', NULL, '3', '2017-11-16', '0'),
('5123', '13', '796', '10', '2017-12-19 23:04:45', NULL, '3', '2017-11-16', '0'),
('5124', '10', '788', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-16', '2115'),
('5125', '30', '797', '10', '2017-12-19 23:06:08', NULL, '3', '2017-11-22', '0'),
('5126', '13', '797', '10', '2017-12-19 23:06:08', NULL, '3', '2017-11-22', '0'),
('5127', '10', '789', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-22', '2151'),
('5128', '30', '798', '10', '2017-12-19 23:08:44', NULL, '3', '2017-11-22', '0'),
('5129', '13', '798', '10', '2017-12-19 23:08:44', NULL, '3', '2017-11-22', '0'),
('5130', '10', '790', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-22', '2152'),
('5131', '30', '799', '10', '2017-12-19 23:09:45', NULL, '3', '2017-11-22', '0'),
('5132', '13', '799', '10', '2017-12-19 23:09:45', NULL, '3', '2017-11-22', '0'),
('5133', '10', '791', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-22', '2153'),
('5134', '30', '800', '10', '2017-12-19 23:10:44', NULL, '3', '2017-11-23', '0'),
('5135', '13', '800', '10', '2017-12-19 23:10:44', NULL, '3', '2017-11-23', '0'),
('5136', '10', '792', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-23', '2161'),
('5137', '30', '801', '10', '2017-12-19 23:11:36', NULL, '3', '2017-11-24', '0'),
('5138', '13', '801', '10', '2017-12-19 23:11:36', NULL, '3', '2017-11-24', '0'),
('5139', '10', '793', '10', '2018-01-25 23:20:52', NULL, '3', '2017-11-24', NULL),
('5140', '30', '802', '10', '2017-12-19 23:12:25', NULL, '3', '2017-11-24', '0'),
('5141', '13', '802', '10', '2017-12-19 23:12:25', NULL, '3', '2017-11-24', '0'),
('5142', '10', '794', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-24', '2169'),
('5143', '30', '803', '10', '2017-12-19 23:13:05', NULL, '3', '2017-11-24', '0'),
('5144', '13', '803', '10', '2017-12-19 23:13:05', NULL, '3', '2017-11-24', '0'),
('5145', '10', '795', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-24', '2170'),
('5146', '30', '804', '10', '2017-12-19 23:13:57', NULL, '3', '2017-11-28', '0'),
('5147', '13', '804', '10', '2017-12-19 23:13:57', NULL, '3', '2017-11-28', '0'),
('5148', '10', '796', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2219'),
('5149', '30', '805', '10', '2017-12-19 23:14:48', NULL, '3', '2017-11-28', '0'),
('5150', '13', '805', '10', '2017-12-19 23:14:48', NULL, '3', '2017-11-28', '0'),
('5151', '10', '797', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2220'),
('5152', '30', '806', '10', '2017-12-19 23:20:47', NULL, '3', '2017-11-30', '0'),
('5153', '13', '806', '10', '2017-12-19 23:20:47', NULL, '3', '2017-11-30', '0'),
('5154', '10', '798', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2267'),
('5155', '30', '807', '10', '2017-12-19 23:21:30', NULL, '3', '2017-11-30', '0'),
('5156', '13', '807', '10', '2017-12-19 23:21:30', NULL, '3', '2017-11-30', '0'),
('5157', '10', '799', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2268'),
('5158', '30', '808', '10', '2017-12-19 23:22:25', NULL, '3', '2017-11-30', '0'),
('5159', '13', '808', '10', '2017-12-19 23:22:25', NULL, '3', '2017-11-30', '0'),
('5160', '10', '800', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2269'),
('5161', '30', '809', '10', '2017-12-19 23:23:18', NULL, '3', '2017-12-04', '0'),
('5162', '13', '809', '10', '2017-12-19 23:23:18', NULL, '3', '2017-12-04', '0'),
('5163', '10', '801', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2310'),
('5164', '1', '1394', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-19', '2442'),
('5165', '1', '1393', '10', '2017-12-20 23:36:06', 'Voided.\nDocument reentered.', '3', '2017-12-20', '0'),
('5166', '1', '1395', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2457'),
('5167', '1', '1396', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2458'),
('5168', '1', '1397', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2459'),
('5169', '1', '1398', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2460'),
('5170', '4', '70', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2461'),
('5171', '1', '1399', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2462'),
('5172', '1', '1400', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2463'),
('5173', '1', '1401', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2464'),
('5174', '1', '1402', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-22', '2475'),
('5175', '1', '1403', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-22', '2476'),
('5176', '1', '1404', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-22', '2477'),
('5177', '1', '1405', '10', '2018-01-04 03:20:39', NULL, '3', '2017-12-22', NULL),
('5178', '18', '32', '10', '2017-12-22 04:10:53', NULL, '3', '2017-12-01', '0'),
('5179', '25', '31', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-01', '2290'),
('5180', '20', '83', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-01', '2291'),
('5181', '22', '31', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2465'),
('5182', '1', '1406', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-22', '2478'),
('5183', '1', '1407', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-22', '2479'),
('5184', '1', '1408', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-22', '2480'),
('5185', '30', '810', '10', '2017-12-27 00:52:30', NULL, '3', '2017-11-30', '0'),
('5186', '13', '810', '10', '2017-12-27 00:52:30', NULL, '3', '2017-11-30', '0'),
('5187', '10', '802', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2270'),
('5188', '30', '811', '10', '2017-12-27 00:56:49', NULL, '3', '2017-11-30', '0'),
('5189', '13', '811', '10', '2017-12-27 00:56:49', NULL, '3', '2017-11-30', '0'),
('5190', '10', '803', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2271'),
('5191', '30', '812', '10', '2017-12-27 00:58:32', NULL, '3', '2017-11-30', '0'),
('5192', '13', '812', '10', '2017-12-27 00:58:32', NULL, '3', '2017-11-30', '0'),
('5193', '10', '804', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2272'),
('5194', '1', '1409', '10', '2018-03-06 23:58:25', NULL, '3', '2017-12-27', NULL),
('5195', '1', '1410', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-27', '2495'),
('5196', '1', '1411', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-27', '2496'),
('5197', '1', '1412', '10', '2018-01-04 04:26:45', NULL, '3', '2017-12-27', NULL),
('5198', '1', '1413', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-27', '2497'),
('5199', '1', '1414', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-27', '2498'),
('5200', '1', '1415', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-28', '2504'),
('5201', '4', '71', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-28', '2505'),
('5202', '1', '1416', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-29', '2507'),
('5203', '1', '1417', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-29', '2508'),
('5204', '4', '72', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2530'),
('5205', '1', '1418', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2531'),
('5206', '1', '1419', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2532'),
('5207', '1', '1420', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2533'),
('5208', '1', '1421', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2534'),
('5209', '1', '1422', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-29', '2509'),
('5210', '1', '1423', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-29', '2510'),
('5211', '30', '813', '10', '2018-01-02 01:24:44', NULL, '3', '2018-01-02', '0'),
('5212', '13', '813', '10', '2018-01-16 03:12:37', NULL, '3', '2018-01-02', NULL),
('5213', '10', '805', '10', '2018-01-16 03:12:37', NULL, '3', '2018-01-02', NULL),
('5214', '1', '1424', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2535'),
('5215', '1', '1425', '10', '2018-01-02 02:27:28', NULL, '3', '2018-01-02', NULL),
('5216', '1', '1426', '10', '2018-01-02 02:00:02', NULL, '3', '2018-01-02', NULL),
('5217', '1', '1427', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2536'),
('5218', '1', '1428', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2537'),
('5219', '1', '1426', '10', '2018-01-02 02:00:02', 'Voided.\nDocument reentered.', '3', '2018-01-02', '0'),
('5220', '1', '1429', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2538'),
('5221', '1', '1430', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2539'),
('5222', '1', '1425', '10', '2018-01-02 02:27:28', 'Voided.\nDocument reentered.', '3', '2018-01-02', '0'),
('5223', '1', '1431', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2540'),
('5224', '1', '1432', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2541'),
('5225', '12', '413', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-04', '2572'),
('5226', '12', '414', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-12', '2615'),
('5227', '12', '415', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-17', '2657'),
('5228', '12', '416', '10', '2018-01-02 03:11:21', NULL, '3', '2018-02-02', NULL),
('5229', '12', '417', '10', '2018-01-24 01:11:23', NULL, '3', '2018-01-02', NULL),
('5230', '12', '416', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-02', '2542'),
('5231', '12', '418', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2543'),
('5232', '12', '419', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2544'),
('5233', '12', '420', '10', '2018-01-24 01:19:30', NULL, '3', '2018-01-02', NULL),
('5234', '12', '421', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-09', '2590'),
('5235', '1', '1433', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2545'),
('5236', '1', '1434', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2546'),
('5237', '30', '814', '10', '2018-01-02 23:58:11', NULL, '3', '2017-12-13', '0'),
('5238', '13', '814', '10', '2018-01-02 23:58:11', NULL, '3', '2017-12-13', '0'),
('5239', '10', '806', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-13', '2395'),
('5240', '30', '815', '10', '2018-01-02 23:59:11', NULL, '3', '2017-12-13', '0'),
('5241', '13', '815', '10', '2018-01-02 23:59:11', NULL, '3', '2017-12-13', '0'),
('5242', '10', '807', '10', '2018-01-25 23:23:07', NULL, '3', '2017-12-13', NULL),
('5243', '30', '816', '10', '2018-01-03 00:15:38', NULL, '3', '2017-12-13', '0'),
('5244', '13', '816', '10', '2018-01-03 00:15:38', NULL, '3', '2017-12-13', '0'),
('5245', '10', '808', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-13', '2396'),
('5246', '30', '817', '10', '2018-01-03 00:17:18', NULL, '3', '2017-12-13', '0'),
('5247', '13', '817', '10', '2018-01-03 00:17:18', NULL, '3', '2017-12-13', '0'),
('5248', '10', '809', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-13', '2397'),
('5249', '30', '818', '10', '2018-01-03 00:19:48', NULL, '3', '2017-12-18', '0'),
('5250', '13', '818', '10', '2018-01-03 00:19:48', NULL, '3', '2017-12-18', '0'),
('5251', '10', '810', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-18', '2433'),
('5252', '30', '819', '10', '2018-01-03 00:20:45', NULL, '3', '2017-12-18', '0'),
('5253', '13', '819', '10', '2018-01-03 00:20:45', NULL, '3', '2017-12-18', '0'),
('5254', '10', '811', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-18', '2434'),
('5255', '30', '820', '10', '2018-01-03 00:21:43', NULL, '3', '2017-12-18', '0'),
('5256', '13', '820', '10', '2018-01-03 00:21:43', NULL, '3', '2017-12-18', '0'),
('5257', '10', '812', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-18', '2435'),
('5258', '30', '821', '10', '2018-01-03 00:23:52', NULL, '3', '2017-12-20', '0'),
('5259', '13', '821', '10', '2018-01-03 00:23:52', NULL, '3', '2017-12-20', '0'),
('5260', '10', '813', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-20', '2448'),
('5261', '30', '822', '10', '2018-01-03 00:24:39', NULL, '3', '2017-12-20', '0'),
('5262', '13', '822', '10', '2018-01-03 00:24:39', NULL, '3', '2017-12-20', '0'),
('5263', '10', '814', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-20', '2449'),
('5264', '30', '823', '10', '2018-01-03 00:25:26', NULL, '3', '2017-12-20', '0'),
('5265', '13', '823', '10', '2018-01-03 00:25:26', NULL, '3', '2017-12-20', '0'),
('5266', '10', '815', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-20', '2450'),
('5267', '30', '824', '10', '2018-01-03 00:26:10', NULL, '3', '2017-12-20', '0'),
('5268', '13', '824', '10', '2018-01-03 00:26:10', NULL, '3', '2017-12-20', '0'),
('5269', '10', '816', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-20', '2451'),
('5270', '1', '1435', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-03', '2561'),
('5271', '1', '1436', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-03', '2562'),
('5272', '1', '1437', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-03', '2563'),
('5273', '1', '1438', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-03', '2564'),
('5274', '1', '1439', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-03', '2565'),
('5275', '1', '1440', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-03', '2566'),
('5276', '1', '1441', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-03', '2567'),
('5277', '1', '1442', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-03', '2568'),
('5278', '1', '1443', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-03', '2569'),
('5279', '1', '1444', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-03', '2570'),
('5280', '1', '1445', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-03', '2571'),
('5281', '1', '1446', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '578'),
('5282', '2', '78', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-23', '754'),
('5283', '2', '79', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-26', '1622'),
('5284', '0', '21', '1', '2018-01-03 05:39:30', NULL, '3', '2018-01-03', NULL),
('5285', '0', '21', '1', '2018-01-03 05:39:30', 'Voided.\nDocument reentered.', '3', '2018-01-03', '0'),
('5286', '0', '22', '1', '2018-01-03 05:41:59', NULL, '3', '2017-03-31', NULL),
('5287', '0', '22', '1', '2018-01-03 05:41:59', 'Voided.\nDocument reentered.', '3', '2018-01-03', '0'),
('5288', '0', '23', '1', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '491'),
('5289', '20', '54', '1', '2018-01-03 06:06:20', 'Voided.\n', '3', '2018-01-03', '0'),
('5290', '10', '523', '1', '2018-03-13 23:30:13', 'Updated.', '3', '2017-06-30', NULL),
('5291', '12', '189', '1', '2018-01-08 05:24:53', 'Updated.', '3', '2017-07-19', NULL),
('5292', '10', '578', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-30', '846'),
('5293', '12', '231', '1', '2018-01-08 05:26:44', 'Updated.', '3', '2017-09-06', NULL),
('5294', '12', '327', '1', '2018-01-08 05:28:06', 'Updated.', '3', '2017-10-31', NULL),
('5295', '12', '351', '1', '2018-01-08 05:28:18', 'Updated.', '3', '2017-11-28', NULL),
('5296', '10', '373', '1', '2019-06-03 02:15:20', 'Updated.', '2', '2016-11-30', NULL),
('5297', '10', '374', '1', '2019-11-05 05:45:21', 'Updated.', '2', '2016-08-31', '108'),
('5298', '30', '825', '1', '2018-01-03 23:48:01', NULL, '3', '2018-01-04', '0'),
('5299', '13', '825', '1', '2018-01-03 23:48:01', NULL, '3', '2018-01-04', '0'),
('5300', '10', '817', '1', '2018-01-16 23:21:41', NULL, '3', '2018-01-04', NULL),
('5301', '30', '826', '1', '2018-01-03 23:57:50', NULL, '3', '2017-11-16', '0'),
('5302', '13', '826', '1', '2018-01-03 23:57:50', NULL, '3', '2017-11-16', '0'),
('5303', '10', '818', '1', '2020-01-22 05:35:45', NULL, '3', '2017-11-16', '2116'),
('5304', '10', '411', '1', '2018-03-16 06:33:48', 'Updated.', '3', '2017-04-07', NULL),
('5305', '10', '440', '1', '2018-01-04 01:12:31', 'Updated.', '3', '2017-04-20', NULL),
('5306', '10', '532', '1', '2018-01-04 00:43:41', 'Updated.', '3', '2017-06-28', NULL),
('5307', '10', '532', '1', '2018-01-04 00:44:56', 'Updated.', '3', '2017-06-28', NULL),
('5308', '10', '532', '1', '2018-03-17 04:22:20', 'Updated.', '3', '2017-06-28', NULL),
('5309', '10', '444', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-25', '505'),
('5310', '10', '501', '1', '2018-03-17 04:35:39', 'Updated.', '3', '2017-07-01', NULL),
('5311', '10', '340', '1', '2018-02-05 04:47:11', 'Updated.', '1', '2015-09-14', '46'),
('5312', '10', '656', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-05', '899'),
('5313', '10', '443', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-05', '352'),
('5314', '10', '531', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-19', '1013'),
('5315', '10', '778', '1', '2018-01-08 02:16:02', 'Updated.', '3', '2017-12-04', NULL),
('5316', '10', '546', '1', '2018-03-19 02:36:43', 'Updated.', '3', '2017-08-09', NULL),
('5317', '10', '547', '1', '2018-03-19 02:38:36', 'Updated.', '3', '2017-08-09', NULL),
('5318', '10', '355', '1', '2018-03-13 23:25:11', 'Updated.', '3', '2017-05-08', NULL),
('5319', '10', '445', '1', '2018-03-16 06:38:14', 'Updated.', '3', '2017-05-08', NULL),
('5320', '10', '725', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-01', '1962'),
('5321', '10', '737', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-26', '2179'),
('5322', '10', '579', '1', '2018-03-19 03:19:29', 'Updated.', '3', '2017-09-11', NULL),
('5323', '10', '440', '1', '2018-03-16 10:55:18', 'Updated.', '3', '2017-04-20', NULL),
('5324', '10', '409', '1', '2018-03-16 06:34:50', 'Updated.', '3', '2017-04-05', NULL),
('5325', '10', '410', '1', '2018-03-16 06:36:23', 'Updated.', '3', '2017-04-05', NULL),
('5326', '10', '499', '1', '2018-03-16 06:39:07', 'Updated.', '3', '2017-07-06', NULL),
('5327', '10', '500', '1', '2018-03-16 06:39:25', 'Updated.', '3', '2017-07-06', NULL),
('5328', '10', '690', '1', '2018-03-16 06:40:42', 'Updated.', '3', '2017-10-12', NULL),
('5329', '10', '691', '1', '2018-03-16 06:40:55', 'Updated.', '3', '2017-10-12', NULL),
('5330', '10', '787', '1', '2018-01-04 02:31:40', 'Updated.', '3', '2017-11-02', NULL),
('5331', '10', '787', '1', '2018-03-19 04:05:19', 'Updated.', '3', '2017-11-02', NULL),
('5332', '10', '662', '1', '2018-01-04 02:40:55', 'Updated.', '3', '2017-10-04', NULL),
('5333', '10', '726', '1', '2018-01-04 02:45:10', 'Updated.', '3', '2017-10-30', NULL),
('5334', '10', '727', '1', '2018-01-04 02:57:59', 'Updated.', '3', '2017-11-10', NULL),
('5335', '10', '662', '1', '2018-01-04 02:59:40', 'Updated.', '3', '2017-10-04', NULL),
('5336', '10', '726', '1', '2018-01-04 03:00:17', 'Updated.', '3', '2017-10-30', NULL),
('5337', '30', '827', '1', '2018-01-04 02:54:04', NULL, '3', '2018-01-01', '0'),
('5338', '13', '827', '1', '2018-01-04 03:02:24', NULL, '3', '2018-01-01', NULL),
('5339', '10', '819', '1', '2018-01-04 02:57:04', NULL, '3', '2018-01-01', NULL),
('5340', '10', '819', '1', '2018-01-04 03:02:24', 'Updated.', '3', '2018-01-01', NULL),
('5341', '10', '727', '1', '2018-01-04 06:08:10', 'Updated.', '3', '2017-11-10', NULL),
('5342', '10', '662', '1', '2018-01-04 03:00:27', 'Updated.', '3', '2017-10-04', NULL),
('5343', '10', '726', '1', '2018-01-04 05:38:35', 'Updated.', '3', '2017-10-30', NULL),
('5344', '10', '662', '1', '2018-01-04 03:01:42', 'Updated.', '3', '2017-10-04', NULL),
('5345', '10', '662', '1', '2018-01-04 05:21:02', 'Updated.', '3', '2017-10-04', NULL),
('5346', '13', '827', '1', '2018-01-04 03:02:24', 'Voided.', '3', '2018-01-04', '0'),
('5347', '10', '819', '1', '2018-01-04 03:02:24', 'Voided.\n', '3', '2018-01-04', '0'),
('5348', '10', '604', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-04-28', '280'),
('5349', '10', '605', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-31', '579'),
('5350', '10', '606', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-30', '847'),
('5351', '10', '607', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-31', '1143'),
('5352', '10', '615', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-08-31', '1408'),
('5353', '1', '1447', '1', '2018-01-04 03:22:25', NULL, '3', '2017-12-22', NULL),
('5354', '1', '1405', '1', '2018-01-04 03:20:39', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5355', '1', '1448', '1', '2020-01-22 05:35:45', NULL, '3', '2017-12-22', '2481'),
('5356', '1', '1447', '1', '2018-01-04 03:22:25', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5357', '20', '41', '1', '2018-01-04 03:29:14', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5358', '20', '84', '1', '2020-01-22 05:35:44', NULL, '3', '2017-07-01', '855'),
('5359', '20', '55', '1', '2018-01-04 03:30:59', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5360', '20', '85', '1', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1472'),
('5361', '1', '1449', '1', '2018-01-04 03:34:46', NULL, '3', '2017-04-11', NULL),
('5362', '1', '82', '1', '2018-01-04 03:32:31', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5363', '1', '1450', '1', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '126'),
('5364', '1', '1449', '1', '2018-01-04 03:34:46', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5365', '1', '1451', '1', '2018-01-04 03:38:17', NULL, '3', '2017-05-09', NULL),
('5366', '1', '212', '1', '2018-01-04 03:36:20', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5367', '1', '1452', '1', '2018-01-04 03:38:57', NULL, '3', '2017-05-15', NULL),
('5368', '1', '222', '1', '2018-01-04 03:36:57', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5369', '1', '1453', '1', '2020-01-22 05:35:44', NULL, '3', '2017-05-09', '379'),
('5370', '1', '1451', '1', '2018-01-04 03:38:17', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5371', '1', '1454', '1', '2020-01-22 05:35:44', NULL, '3', '2017-05-15', '406'),
('5372', '1', '1452', '1', '2018-01-04 03:38:57', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5373', '1', '1455', '1', '2020-01-22 05:35:44', NULL, '3', '2017-06-07', '642'),
('5374', '1', '332', '1', '2018-01-04 03:39:42', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5375', '1', '1456', '1', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '848'),
('5376', '1', '451', '1', '2018-01-04 04:00:53', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5377', '1', '1457', '1', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '883'),
('5378', '1', '456', '1', '2018-01-04 04:01:40', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5379', '1', '1458', '1', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1885'),
('5380', '1', '1022', '1', '2018-01-04 04:06:22', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5381', '1', '1459', '1', '2020-01-22 05:35:45', NULL, '3', '2017-08-23', '1324'),
('5382', '1', '730', '1', '2018-01-04 04:08:09', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5383', '1', '1460', '1', '2018-01-08 00:58:50', NULL, '3', '2017-09-20', NULL),
('5384', '1', '873', '1', '2018-01-04 04:08:45', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5385', '1', '1461', '1', '2018-01-08 00:59:45', NULL, '3', '2017-09-22', NULL),
('5386', '1', '1368', '1', '2018-01-04 04:09:24', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5387', '20', '27', '1', '2018-01-04 04:20:37', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5388', '20', '86', '1', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '281'),
('5389', '20', '28', '1', '2018-01-04 04:21:19', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5390', '20', '87', '1', '2020-01-22 05:35:44', NULL, '3', '2017-06-20', '714'),
('5391', '20', '38', '1', '2018-01-04 04:21:47', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5392', '20', '88', '1', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1187'),
('5393', '20', '67', '1', '2018-01-04 04:22:37', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5394', '20', '89', '1', '2020-01-22 05:35:45', NULL, '3', '2017-09-19', '1557'),
('5395', '1', '1462', '1', '2018-01-04 04:24:40', NULL, '3', '2017-10-20', NULL),
('5396', '1', '996', '1', '2018-01-04 04:23:54', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5397', '1', '1463', '1', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1840'),
('5398', '1', '1462', '1', '2018-01-04 04:24:40', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5399', '1', '1464', '1', '2020-01-22 05:35:44', NULL, '3', '2017-08-10', '1240'),
('5400', '1', '672', '1', '2018-01-04 04:25:34', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5401', '1', '1465', '1', '2020-01-22 05:35:45', NULL, '3', '2017-12-27', '2499'),
('5402', '1', '1412', '1', '2018-01-04 04:26:45', 'Voided.\nDocument reentered.', '3', '2018-01-04', '0'),
('5403', '12', '111', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-01', '591'),
('5404', '30', '828', '1', '2018-01-04 04:37:54', NULL, '3', '2017-10-10', '0'),
('5405', '13', '828', '1', '2018-01-04 04:37:54', NULL, '3', '2017-10-10', '0'),
('5406', '10', '820', '1', '2018-03-19 09:38:34', NULL, '3', '2017-10-10', NULL),
('5407', '12', '422', '1', '2020-01-22 05:35:45', NULL, '3', '2017-10-20', '1841'),
('5408', '1', '1466', '1', '2020-01-22 05:35:45', NULL, '3', '2018-01-04', '2573'),
('5409', '1', '1467', '1', '2020-01-22 05:35:45', NULL, '3', '2018-01-04', '2574'),
('5410', '10', '662', '1', '2018-01-04 05:59:40', 'Updated.', '3', '2017-10-04', NULL),
('5411', '10', '726', '1', '2018-01-04 06:00:40', 'Updated.', '3', '2017-10-30', NULL),
('5412', '30', '829', '1', '2018-01-04 05:39:50', NULL, '3', '2018-01-04', '0'),
('5413', '13', '829', '1', '2018-01-04 05:57:02', NULL, '3', '2018-01-04', NULL),
('5414', '10', '821', '1', '2018-01-04 05:57:02', NULL, '3', '2018-01-04', NULL),
('5415', '30', '830', '1', '2018-01-04 05:46:29', NULL, '3', '2017-10-30', '0'),
('5416', '13', '830', '1', '2018-01-04 05:46:29', NULL, '3', '2017-10-30', '0'),
('5417', '10', '822', '1', '2018-01-04 06:07:14', NULL, '3', '2017-10-30', NULL),
('5418', '13', '829', '1', '2018-01-04 05:57:02', 'Voided.', '3', '2018-01-04', '0'),
('5419', '10', '821', '1', '2018-01-04 05:57:02', 'Voided.\n', '3', '2018-01-04', '0'),
('5420', '13', '665', '1', '2018-01-04 05:59:40', 'Voided.', '3', '2018-01-04', '0'),
('5421', '10', '662', '1', '2018-01-04 05:59:40', 'Voided.\n', '3', '2018-01-04', '0'),
('5422', '13', '729', '1', '2018-01-04 06:00:40', 'Voided.', '3', '2018-01-04', '0'),
('5423', '10', '726', '1', '2018-01-04 06:00:40', 'Voided.\n', '3', '2018-01-04', '0'),
('5424', '30', '831', '1', '2018-01-04 06:06:41', NULL, '3', '2017-11-10', '0'),
('5425', '13', '831', '1', '2018-01-04 06:06:41', NULL, '3', '2017-11-10', '0'),
('5426', '10', '823', '1', '2020-01-22 05:35:45', NULL, '3', '2017-11-10', '2048'),
('5427', '10', '822', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-10-30', '1929'),
('5428', '13', '730', '1', '2018-01-04 06:08:10', 'Voided.', '3', '2018-01-04', '0'),
('5429', '10', '727', '1', '2018-01-04 06:08:10', 'Voided.\n', '3', '2018-01-04', '0'),
('5430', '12', '423', '1', '2020-01-22 05:35:45', NULL, '3', '2017-11-10', '2049'),
('5431', '1', '1468', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-05', '2576'),
('5432', '1', '1469', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-05', '2577'),
('5433', '1', '1470', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-05', '2578'),
('5434', '1', '1471', '10', '2018-01-05 00:32:50', NULL, '3', '2018-01-05', NULL),
('5435', '1', '1472', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-05', '2579'),
('5436', '1', '1471', '10', '2018-01-05 00:32:50', 'Voided.\nDocument reentered.', '3', '2018-01-05', '0'),
('5437', '1', '1473', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-05', '2580'),
('5438', '1', '1474', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-05', '2581'),
('5439', '1', '1475', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-05', '2582'),
('5440', '1', '1476', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-05', '2583'),
('5441', '4', '73', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-05', '2584'),
('5442', '0', '24', '10', '2018-01-07 22:44:46', NULL, '3', '2017-03-31', NULL),
('5443', '0', '24', '10', '2018-01-07 22:44:46', 'Voided.\nDocument reentered.', '3', '2018-01-07', '0'),
('5444', '0', '25', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '492'),
('5445', '0', '26', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '493'),
('5446', '0', '27', '10', '2018-01-07 23:44:38', NULL, '3', '2017-03-31', NULL),
('5447', '1', '1477', '1', '2020-01-22 05:35:44', NULL, '3', '2017-04-27', '256'),
('5448', '1', '492', '1', '2018-01-07 23:32:28', 'Voided.\nDocument reentered.', '3', '2018-01-07', '0'),
('5449', '12', '388', '10', '2018-01-07 23:32:40', 'Voided.\n', '3', '2018-01-07', '0'),
('5450', '0', '27', '10', '2018-01-07 23:44:38', 'Voided.\nDocument reentered.', '3', '2018-01-07', '0'),
('5451', '0', '28', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '494'),
('5452', '30', '832', '10', '2018-01-07 23:48:54', NULL, '3', '2018-01-08', '0'),
('5453', '13', '832', '10', '2018-01-08 01:24:37', NULL, '3', '2018-01-08', NULL),
('5454', '10', '824', '10', '2018-01-08 00:45:49', NULL, '3', '2018-01-08', NULL),
('5455', '0', '29', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '495'),
('5456', '0', '30', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '496'),
('5457', '1', '1478', '1', '2018-03-19 10:42:01', NULL, '3', '2017-05-06', NULL),
('5458', '1', '233', '1', '2018-01-08 00:10:17', 'Voided.\nDocument reentered.', '3', '2018-01-08', '0'),
('5459', '0', '31', '10', '2018-08-03 04:51:31', NULL, '5', '2017-03-31', NULL),
('5460', '1', '1479', '1', '2020-01-22 05:35:44', NULL, '3', '2017-06-05', '622'),
('5461', '1', '325', '1', '2018-01-08 00:23:59', 'Voided.\nDocument reentered.', '3', '2018-01-08', '0'),
('5462', '10', '824', '10', '2018-01-08 00:46:23', 'Updated.', '3', '2018-01-08', NULL),
('5463', '10', '824', '10', '2018-01-08 00:48:04', 'Updated.', '3', '2018-01-08', NULL),
('5464', '1', '1480', '1', '2020-01-22 05:35:45', NULL, '3', '2017-08-21', '1306'),
('5465', '1', '722', '1', '2018-01-08 00:47:39', 'Voided.\nDocument reentered.', '3', '2018-01-08', '0'),
('5466', '10', '824', '10', '2018-01-08 01:24:37', 'Updated.', '3', '2018-01-08', NULL),
('5467', '30', '833', '10', '2018-01-08 00:49:03', NULL, '3', '2018-01-08', '0'),
('5468', '13', '833', '10', '2018-01-08 00:49:03', NULL, '3', '2018-01-08', '0'),
('5469', '10', '825', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-08', '2587'),
('5470', '0', '32', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '497'),
('5471', '1', '1481', '1', '2020-01-22 05:35:45', NULL, '3', '2017-08-23', '1325'),
('5472', '1', '1354', '1', '2018-01-08 00:57:29', 'Voided.\nDocument reentered.', '3', '2018-01-08', '0'),
('5473', '0', '33', '10', '2018-01-08 00:59:00', NULL, '3', '2017-03-31', NULL),
('5474', '1', '1482', '1', '2020-01-22 05:35:45', NULL, '3', '2017-09-20', '1566'),
('5475', '1', '1460', '1', '2018-01-08 00:58:50', 'Voided.\nDocument reentered.', '3', '2018-01-08', '0'),
('5476', '0', '33', '10', '2018-01-08 00:59:00', 'Voided.\n', '3', '2018-01-08', '0'),
('5477', '1', '1483', '1', '2020-01-22 05:35:45', NULL, '3', '2017-09-22', '1594'),
('5478', '1', '1461', '1', '2018-01-08 00:59:45', 'Voided.\nDocument reentered.', '3', '2018-01-08', '0'),
('5479', '13', '832', '10', '2018-01-08 01:24:37', 'Voided.', '3', '2018-01-08', '0'),
('5480', '10', '824', '10', '2018-01-08 01:24:37', 'Voided.\n', '3', '2018-01-08', '0'),
('5481', '1', '1484', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-08', '2588'),
('5482', '10', '778', '1', '2018-03-19 04:29:17', 'Updated.', '3', '2017-12-04', NULL),
('5483', '12', '401', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-12-14', '2412'),
('5484', '12', '132', '1', '2018-03-16 06:38:26', 'Updated.', '3', '2017-06-07', NULL),
('5485', '12', '188', '1', '2018-03-13 23:30:22', 'Updated.', '3', '2017-07-18', NULL),
('5486', '12', '405', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-12-19', '2443'),
('5487', '12', '195', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-08-02', '1165'),
('5488', '12', '407', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-12-04', '2311'),
('5489', '12', '192', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-28', '1117'),
('5490', '12', '128', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-06', '628'),
('5491', '2', '80', '1', '2018-01-08 05:22:23', NULL, '3', '2017-04-05', NULL),
('5492', '2', '80', '1', '2018-01-08 05:25:49', NULL, '3', '2017-04-05', NULL),
('5493', '2', '10', '1', '2018-01-08 05:22:23', 'Voided.\nDocument reentered.', '3', '2018-01-08', '0'),
('5494', '12', '131', '1', '2018-01-08 05:26:27', 'Updated.', '3', '2017-06-07', NULL),
('5495', '12', '189', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-19', '1014'),
('5496', '2', '81', '1', '2018-01-08 05:25:49', NULL, '3', '2017-04-05', NULL),
('5497', '2', '81', '1', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '28'),
('5498', '2', '80', '1', '2018-01-08 05:25:49', 'Voided.\nDocument reentered.', '3', '2018-01-08', '0'),
('5499', '12', '131', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-07', '643'),
('5500', '12', '231', '1', '2018-01-08 05:27:18', 'Updated.', '3', '2017-09-06', NULL),
('5501', '12', '231', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-06', '1443'),
('5502', '12', '327', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-10-31', '1951'),
('5503', '12', '351', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-28', '2221'),
('5504', '12', '85', '1', '2018-03-13 23:25:19', 'Updated.', '3', '2017-05-18', NULL),
('5505', '2', '82', '1', '2018-01-08 05:31:33', NULL, '3', '2017-04-18', NULL),
('5506', '2', '82', '1', '2020-01-22 05:35:44', NULL, '3', '2017-04-18', '152'),
('5507', '2', '42', '1', '2018-01-08 05:31:33', 'Voided.\nDocument reentered.', '3', '2018-01-08', '0'),
('5508', '12', '217', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-08-11', '1253');
INSERT INTO `0_audit_trail` VALUES
('5509', '12', '329', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-01', '1963'),
('5510', '12', '338', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-09', '2026'),
('5511', '2', '83', '1', '2018-01-08 05:36:58', NULL, '3', '2017-04-05', NULL),
('5512', '2', '83', '1', '2020-01-22 05:35:44', NULL, '3', '2017-04-05', '29'),
('5513', '2', '11', '1', '2018-01-08 05:36:58', 'Voided.\nDocument reentered.', '3', '2018-01-08', '0'),
('5514', '2', '84', '1', '2018-01-08 05:37:06', NULL, '3', '2017-04-11', NULL),
('5515', '2', '84', '1', '2018-03-16 06:37:26', NULL, '3', '2017-04-11', NULL),
('5516', '2', '22', '1', '2018-01-08 05:37:06', 'Voided.\nDocument reentered.', '3', '2018-01-08', '0'),
('5517', '2', '85', '1', '2018-01-08 05:37:15', NULL, '3', '2017-04-11', NULL),
('5518', '2', '85', '1', '2018-03-16 06:37:04', NULL, '3', '2017-04-11', NULL),
('5519', '2', '23', '1', '2018-01-08 05:37:15', 'Voided.\nDocument reentered.', '3', '2018-01-08', '0'),
('5520', '12', '336', '1', '2018-03-16 06:40:15', 'Updated.', '3', '2017-11-09', NULL),
('5521', '12', '337', '1', '2018-03-20 02:04:56', 'Updated.', '3', '2017-11-09', NULL),
('5522', '12', '287', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-26', '1623'),
('5523', '12', '398', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-12-14', '2413'),
('5524', '12', '335', '1', '2018-01-08 05:42:35', 'Updated.', '3', '2017-11-02', NULL),
('5525', '12', '335', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-02', '1978'),
('5526', '12', '130', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-05', '623'),
('5527', '2', '86', '1', '2018-01-08 05:46:14', NULL, '3', '2017-06-21', NULL),
('5528', '2', '86', '1', '2020-01-22 05:35:44', NULL, '3', '2017-06-21', '724'),
('5529', '2', '70', '1', '2018-01-08 05:46:14', 'Voided.\nDocument reentered.', '3', '2018-01-08', '0'),
('5530', '12', '424', '1', '2018-01-08 05:51:27', NULL, '3', '2017-07-31', NULL),
('5531', '12', '424', '1', '2018-01-08 05:51:27', 'Voided.\n', '3', '2018-01-08', '0'),
('5532', '2', '87', '1', '2018-01-08 06:21:45', NULL, '3', '2017-04-18', NULL),
('5533', '2', '87', '1', '2020-01-22 05:35:44', NULL, '3', '2017-04-18', '153'),
('5534', '2', '41', '1', '2018-01-08 06:21:45', 'Voided.\nDocument reentered.', '3', '2018-01-08', '0'),
('5535', '12', '135', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-12', '673'),
('5536', '12', '218', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-08-11', '1254'),
('5537', '12', '232', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-07', '1447'),
('5538', '12', '339', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-09', '2027'),
('5539', '26', '1', '1', '2018-01-08 06:31:55', NULL, '3', '2017-11-09', NULL),
('5540', '26', '1', '1', '2020-01-22 05:35:45', 'Released.', '3', '2017-11-09', '2028'),
('5541', '35', '1', '1', '2018-01-08 06:31:55', NULL, '3', '2017-11-09', '0'),
('5542', '29', '1', '1', '2020-01-22 05:35:45', 'Production.', '3', '2017-11-09', '2029'),
('5543', '16', '30', '1', '2018-01-08 06:35:50', NULL, '3', '2017-11-09', '0'),
('5544', '30', '834', '1', '2018-01-08 06:36:52', NULL, '3', '2017-11-09', '0'),
('5545', '13', '834', '1', '2018-01-08 07:18:43', NULL, '3', '2017-11-09', NULL),
('5546', '10', '826', '1', '2018-01-08 07:18:43', NULL, '3', '2017-11-09', NULL),
('5547', '16', '31', '1', '2018-01-08 06:49:40', NULL, '3', '2017-11-09', '0'),
('5548', '26', '2', '1', '2018-01-08 06:50:42', NULL, '3', '2017-11-09', NULL),
('5549', '26', '2', '1', '2020-01-22 05:35:45', 'Released.', '3', '2017-11-09', '2030'),
('5550', '29', '2', '1', '2020-01-22 05:35:45', 'Production.', '3', '2017-11-09', '2031'),
('5551', '26', '3', '1', '2018-01-08 06:56:22', NULL, '3', '2017-11-09', NULL),
('5552', '26', '3', '1', '2020-01-22 05:35:45', 'Released.', '3', '2017-11-09', '2032'),
('5553', '29', '3', '1', '2020-01-22 05:35:45', 'Production.', '3', '2017-11-09', '2033'),
('5554', '17', '1', '1', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2034'),
('5555', '30', '835', '1', '2018-01-08 07:15:46', NULL, '3', '2017-11-09', '0'),
('5556', '13', '835', '1', '2018-01-08 07:18:56', NULL, '3', '2017-11-09', NULL),
('5557', '10', '827', '1', '2018-01-08 07:18:56', NULL, '3', '2017-11-09', NULL),
('5558', '13', '834', '1', '2018-01-08 07:18:43', 'Voided.', '3', '2018-01-08', '0'),
('5559', '10', '826', '1', '2018-01-08 07:18:43', 'Voided.\n', '3', '2018-01-08', '0'),
('5560', '13', '835', '1', '2018-01-08 07:18:56', 'Voided.', '3', '2018-01-08', '0'),
('5561', '10', '827', '1', '2018-01-08 07:18:56', 'Voided.\n', '3', '2018-01-08', '0'),
('5562', '1', '1485', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-09', '2591'),
('5563', '4', '74', '10', '2018-02-05 23:33:11', NULL, '3', '2018-01-09', '0'),
('5564', '30', '836', '10', '2018-01-09 01:36:01', NULL, '3', '2018-01-09', '0'),
('5565', '13', '836', '10', '2018-03-19 10:30:55', NULL, '3', '2018-01-09', NULL),
('5566', '10', '828', '10', '2018-03-16 06:46:58', NULL, '3', '2018-01-09', NULL),
('5567', '30', '837', '10', '2018-01-09 01:37:22', NULL, '3', '2018-01-09', '0'),
('5568', '13', '837', '10', '2018-03-19 10:31:07', NULL, '3', '2018-01-09', NULL),
('5569', '10', '829', '10', '2018-03-16 06:47:10', NULL, '3', '2018-01-09', NULL),
('5570', '1', '1486', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-09', '2592'),
('5571', '1', '1487', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-09', '2593'),
('5572', '30', '838', '10', '2018-01-09 04:21:59', NULL, '3', '2017-04-21', '0'),
('5573', '13', '838', '10', '2018-01-09 04:21:59', NULL, '3', '2017-04-21', '0'),
('5574', '10', '830', '10', '2018-03-13 06:14:24', NULL, '3', '2017-04-21', NULL),
('5575', '12', '425', '10', '2018-03-13 06:16:20', NULL, '3', '2017-04-24', NULL),
('5576', '30', '839', '10', '2018-01-09 04:25:05', NULL, '3', '2017-05-23', '0'),
('5577', '13', '839', '10', '2018-01-09 04:25:05', NULL, '3', '2017-05-23', '0'),
('5578', '10', '831', '10', '2018-03-13 23:11:27', NULL, '3', '2017-05-23', NULL),
('5579', '12', '426', '10', '2018-03-13 23:12:22', NULL, '3', '2017-05-24', NULL),
('5580', '30', '840', '10', '2018-01-09 04:27:41', NULL, '3', '2017-06-21', '0'),
('5581', '13', '840', '10', '2018-01-09 04:27:41', NULL, '3', '2017-06-21', '0'),
('5582', '10', '832', '10', '2018-03-13 23:11:34', NULL, '3', '2017-06-21', NULL),
('5583', '12', '427', '10', '2018-03-13 23:12:28', NULL, '3', '2017-06-22', NULL),
('5584', '30', '841', '10', '2018-01-09 04:30:00', NULL, '3', '2017-07-21', '0'),
('5585', '13', '841', '10', '2018-01-09 04:30:00', NULL, '3', '2017-07-21', '0'),
('5586', '10', '833', '10', '2018-03-13 23:11:40', NULL, '3', '2017-07-21', NULL),
('5587', '12', '428', '10', '2018-03-13 23:12:38', NULL, '3', '2017-07-24', NULL),
('5588', '30', '842', '10', '2018-01-09 04:32:05', NULL, '3', '2017-08-22', '0'),
('5589', '13', '842', '10', '2018-01-09 04:32:05', NULL, '3', '2017-08-22', '0'),
('5590', '10', '834', '10', '2018-03-13 23:11:48', NULL, '3', '2017-08-22', NULL),
('5591', '12', '429', '10', '2018-03-13 23:12:44', NULL, '3', '2017-08-23', NULL),
('5592', '30', '843', '10', '2018-01-09 04:34:32', NULL, '3', '2017-09-20', '0'),
('5593', '13', '843', '10', '2018-01-09 04:34:32', NULL, '3', '2017-09-20', '0'),
('5594', '10', '835', '10', '2018-03-13 23:11:56', NULL, '3', '2017-09-20', NULL),
('5595', '12', '430', '10', '2018-03-13 23:12:54', NULL, '3', '2017-09-21', NULL),
('5596', '30', '844', '10', '2018-01-09 04:36:33', NULL, '3', '2017-10-20', '0'),
('5597', '13', '844', '10', '2018-01-09 04:36:33', NULL, '3', '2017-10-20', '0'),
('5598', '10', '836', '10', '2018-03-13 23:12:08', NULL, '3', '2017-10-20', NULL),
('5599', '12', '431', '10', '2018-03-13 23:13:04', NULL, '3', '2017-10-23', NULL),
('5600', '30', '845', '10', '2018-01-09 04:44:51', NULL, '3', '2017-05-02', '0'),
('5601', '13', '845', '10', '2018-01-09 04:44:51', NULL, '3', '2017-05-02', '0'),
('5602', '10', '837', '10', '2018-03-13 23:07:32', NULL, '3', '2017-05-02', NULL),
('5603', '30', '846', '10', '2018-01-09 04:46:12', NULL, '3', '2017-05-25', '0'),
('5604', '13', '846', '10', '2018-01-09 04:46:12', NULL, '3', '2017-05-25', '0'),
('5605', '10', '838', '10', '2018-03-13 23:08:02', NULL, '3', '2017-05-25', NULL),
('5606', '12', '432', '10', '2018-03-13 23:08:10', NULL, '3', '2017-05-26', NULL),
('5607', '12', '433', '10', '2018-03-13 23:07:52', NULL, '3', '2017-05-02', NULL),
('5608', '30', '847', '10', '2018-01-09 04:49:37', NULL, '3', '2017-05-01', '0'),
('5609', '13', '847', '10', '2018-01-09 23:46:16', NULL, '3', '2017-05-01', NULL),
('5610', '10', '839', '10', '2018-01-09 23:46:16', NULL, '3', '2017-05-01', NULL),
('5611', '12', '434', '10', '2018-01-09 23:47:01', NULL, '3', '2017-05-01', NULL),
('5612', '1', '1488', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-09', '2594'),
('5613', '13', '847', '10', '2018-01-09 23:46:16', 'Voided.', '3', '2018-01-09', '0'),
('5614', '10', '839', '10', '2018-01-09 23:46:16', 'Voided.\n', '3', '2018-01-09', '0'),
('5615', '12', '434', '10', '2018-01-09 23:47:01', 'Voided.\n', '3', '2018-01-09', '0'),
('5616', '12', '435', '10', '2018-01-09 23:49:38', NULL, '3', '2018-01-09', NULL),
('5617', '12', '435', '10', '2021-03-08 05:19:04', 'Updated.', '3', '2017-05-02', '301'),
('5618', '30', '848', '10', '2018-01-09 23:55:09', NULL, '3', '2017-06-29', '0'),
('5619', '13', '848', '10', '2018-01-09 23:55:09', NULL, '3', '2017-06-29', '0'),
('5620', '10', '840', '10', '2018-03-13 23:08:54', NULL, '3', '2017-06-29', NULL),
('5621', '12', '436', '10', '2018-03-13 23:09:32', NULL, '3', '2017-06-30', NULL),
('5622', '12', '437', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-10', '941'),
('5623', '30', '849', '10', '2018-01-10 00:00:34', NULL, '3', '2017-08-08', '0'),
('5624', '13', '849', '10', '2018-08-06 06:11:35', NULL, '5', '2017-08-08', NULL),
('5625', '10', '841', '10', '2018-08-06 06:11:35', NULL, '5', '2017-08-08', NULL),
('5626', '12', '438', '10', '2018-01-10 00:02:10', NULL, '3', '2017-08-09', NULL),
('5627', '12', '438', '10', '2018-03-13 23:10:16', 'Updated.', '3', '2017-08-09', NULL),
('5628', '30', '850', '10', '2018-01-10 00:05:37', NULL, '3', '2017-09-05', '0'),
('5629', '13', '850', '10', '2018-01-10 00:05:37', NULL, '3', '2017-09-05', '0'),
('5630', '10', '842', '10', '2018-03-13 23:09:11', NULL, '3', '2017-09-05', NULL),
('5631', '12', '439', '10', '2018-03-13 23:10:24', NULL, '3', '2017-09-06', NULL),
('5632', '30', '851', '10', '2018-01-10 00:06:54', NULL, '3', '2017-09-26', '0'),
('5633', '13', '851', '10', '2018-01-10 00:06:54', NULL, '3', '2017-09-26', '0'),
('5634', '10', '843', '10', '2018-03-13 23:09:18', NULL, '3', '2017-09-26', NULL),
('5635', '12', '440', '10', '2018-03-13 23:10:31', NULL, '3', '2017-09-27', NULL),
('5636', '1', '1489', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-10', '2601'),
('5637', '1', '1490', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-10', '2602'),
('5638', '1', '1491', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-10', '2603'),
('5639', '1', '1492', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-10', '2604'),
('5640', '1', '1493', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-26', '2180'),
('5641', '1', '1494', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-26', '2181'),
('5642', '1', '1495', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-20', '2145'),
('5643', '1', '1496', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2191'),
('5644', '1', '1497', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2192'),
('5645', '1', '1498', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2193'),
('5646', '1', '1499', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2194'),
('5647', '1', '1500', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2195'),
('5648', '1', '1501', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2196'),
('5649', '1', '1502', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2197'),
('5650', '1', '1503', '10', '2018-03-06 23:56:57', NULL, '3', '2017-11-30', NULL),
('5651', '1', '1207', '10', '2018-01-10 22:54:50', 'Voided.\nDocument reentered.', '3', '2018-01-10', '0'),
('5652', '22', '29', '10', '2018-01-10 22:58:04', 'Voided.\n', '3', '2018-01-10', '0'),
('5653', '22', '32', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2273'),
('5654', '1', '1504', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2274'),
('5655', '4', '75', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2198'),
('5656', '4', '76', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2100'),
('5657', '12', '347', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-16', '2117'),
('5658', '12', '441', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2222'),
('5659', '1', '1505', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2199'),
('5660', '1', '1506', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-11', '2607'),
('5661', '30', '852', '10', '2018-01-11 00:35:30', NULL, '3', '2017-10-06', '0'),
('5662', '13', '852', '10', '2018-01-11 00:35:30', NULL, '3', '2017-10-06', '0'),
('5663', '10', '844', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-06', '1729'),
('5664', '30', '853', '10', '2018-01-11 00:36:25', NULL, '3', '2017-10-16', '0'),
('5665', '13', '853', '10', '2018-01-11 00:36:25', NULL, '3', '2017-10-16', '0'),
('5666', '10', '845', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1792'),
('5667', '30', '854', '10', '2018-01-11 00:37:14', NULL, '3', '2017-10-18', '0'),
('5668', '13', '854', '10', '2018-01-11 00:37:14', NULL, '3', '2017-10-18', '0'),
('5669', '10', '846', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-18', '1802'),
('5670', '30', '855', '10', '2018-01-11 00:38:04', NULL, '3', '2017-10-18', '0'),
('5671', '13', '855', '10', '2018-01-11 00:38:04', NULL, '3', '2017-10-18', '0'),
('5672', '10', '847', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-18', '1803'),
('5673', '30', '856', '10', '2018-01-11 00:48:32', NULL, '3', '2017-10-27', '0'),
('5674', '13', '856', '10', '2018-01-11 00:48:32', NULL, '3', '2017-10-27', '0'),
('5675', '10', '848', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1912'),
('5676', '30', '857', '10', '2018-01-11 00:49:14', NULL, '3', '2017-10-27', '0'),
('5677', '13', '857', '10', '2018-01-11 00:49:14', NULL, '3', '2017-10-27', '0'),
('5678', '10', '849', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1913'),
('5679', '30', '858', '10', '2018-01-11 00:50:17', NULL, '3', '2017-10-30', '0'),
('5680', '13', '858', '10', '2018-01-11 00:50:17', NULL, '3', '2017-10-30', '0'),
('5681', '10', '850', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1930'),
('5682', '30', '859', '10', '2018-01-11 00:51:03', NULL, '3', '2017-10-30', '0'),
('5683', '13', '859', '10', '2018-01-11 00:51:03', NULL, '3', '2017-10-30', '0'),
('5684', '10', '851', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1931'),
('5685', '30', '860', '10', '2018-01-11 00:54:44', NULL, '3', '2017-11-17', '0'),
('5686', '13', '860', '10', '2018-01-11 00:54:44', NULL, '3', '2017-11-17', '0'),
('5687', '10', '852', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2127'),
('5688', '30', '861', '10', '2018-01-11 00:57:26', NULL, '3', '2017-11-10', '0'),
('5689', '13', '861', '10', '2018-01-11 00:57:26', NULL, '3', '2017-11-10', '0'),
('5690', '10', '853', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-10', '2050'),
('5691', '30', '862', '10', '2018-01-11 00:58:30', NULL, '3', '2017-11-10', '0'),
('5692', '13', '862', '10', '2018-01-11 00:58:30', NULL, '3', '2017-11-10', '0'),
('5693', '10', '854', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-10', '2051'),
('5694', '30', '863', '10', '2018-01-11 00:59:25', NULL, '3', '2017-11-17', '0'),
('5695', '13', '863', '10', '2018-01-11 00:59:25', NULL, '3', '2017-11-17', '0'),
('5696', '10', '855', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2128'),
('5697', '30', '864', '10', '2018-01-11 01:00:41', NULL, '3', '2017-11-17', '0'),
('5698', '13', '864', '10', '2018-01-11 01:00:41', NULL, '3', '2017-11-17', '0'),
('5699', '10', '856', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2129'),
('5700', '30', '865', '10', '2018-01-11 01:02:59', NULL, '3', '2017-11-17', '0'),
('5701', '13', '865', '10', '2018-01-11 01:02:59', NULL, '3', '2017-11-17', '0'),
('5702', '10', '857', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2130'),
('5703', '30', '866', '10', '2018-01-11 01:07:36', NULL, '3', '2017-11-24', '0'),
('5704', '13', '866', '10', '2018-01-11 01:07:36', NULL, '3', '2017-11-24', '0'),
('5705', '10', '858', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-24', '2171'),
('5706', '30', '867', '10', '2018-01-11 01:09:47', NULL, '3', '2017-11-24', '0'),
('5707', '13', '867', '10', '2018-01-11 01:09:47', NULL, '3', '2017-11-24', '0'),
('5708', '10', '859', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-24', '2172'),
('5709', '30', '868', '10', '2018-01-11 01:13:33', NULL, '3', '2017-11-24', '0'),
('5710', '13', '868', '10', '2018-01-11 01:13:33', NULL, '3', '2017-11-24', '0'),
('5711', '10', '860', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-24', '2173'),
('5712', '1', '1507', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-09', '2596'),
('5713', '1', '1508', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-11', '2608'),
('5714', '1', '1509', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-11', '2609'),
('5715', '30', '869', '10', '2018-01-11 22:33:57', NULL, '3', '2018-01-12', '0'),
('5716', '13', '869', '10', '2018-01-11 22:33:57', NULL, '3', '2018-01-12', '0'),
('5717', '10', '861', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-12', '2616'),
('5718', '1', '1510', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-12', '2617'),
('5719', '1', '1511', '10', '2018-08-02 05:18:22', NULL, '5', '2018-01-12', NULL),
('5720', '1', '1512', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-08', '2009'),
('5721', '2', '88', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2101'),
('5722', '1', '1513', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2131'),
('5723', '1', '1514', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2132'),
('5724', '1', '1515', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-29', '2231'),
('5725', '12', '50', '10', '2018-01-12 00:36:07', 'Voided.\n', '3', '2018-01-12', '0'),
('5726', '12', '123', '10', '2018-01-12 00:42:48', 'Voided.\n', '3', '2018-01-12', '0'),
('5727', '30', '870', '10', '2018-01-12 00:58:18', NULL, '3', '2017-11-23', '0'),
('5728', '13', '870', '10', '2018-01-12 00:58:18', NULL, '3', '2017-11-23', '0'),
('5729', '10', '862', '10', '2018-03-13 23:13:51', NULL, '3', '2017-11-23', NULL),
('5730', '12', '442', '10', '2018-03-13 23:13:11', NULL, '3', '2017-11-24', NULL),
('5731', '1', '1516', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-12', '2618'),
('5732', '1', '1517', '10', '2018-03-06 23:59:35', NULL, '3', '2018-01-12', NULL),
('5733', '1', '1518', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-12', '2619'),
('5734', '1', '1519', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-12', '2620'),
('5735', '1', '1520', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-12', '2621'),
('5736', '1', '1521', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-12', '2622'),
('5737', '1', '1522', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-12', '2623'),
('5738', '1', '1523', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-12', '2624'),
('5739', '1', '1524', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-12', '2625'),
('5740', '12', '443', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2312'),
('5741', '11', '75', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-15', '2428'),
('5742', '12', '444', '10', '2018-01-24 01:15:01', NULL, '3', '2018-01-02', NULL),
('5743', '12', '445', '10', '2018-01-21 23:51:13', NULL, '3', '2018-01-02', NULL),
('5744', '12', '446', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2547'),
('5745', '12', '447', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2548'),
('5746', '12', '448', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2549'),
('5747', '12', '449', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2550'),
('5748', '12', '450', '10', '2018-01-21 23:57:19', NULL, '3', '2018-01-02', NULL),
('5749', '12', '451', '10', '2018-01-24 01:14:50', NULL, '3', '2018-01-02', NULL),
('5750', '12', '452', '10', '2018-01-24 01:17:21', NULL, '3', '2018-01-02', NULL),
('5751', '12', '453', '10', '2018-01-24 01:07:44', NULL, '3', '2018-01-02', NULL),
('5752', '12', '454', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2551'),
('5753', '12', '455', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-15', '2631'),
('5754', '12', '456', '10', '2019-02-13 00:47:43', NULL, '3', '2017-11-30', NULL),
('5755', '12', '457', '10', '2019-02-13 00:47:53', NULL, '3', '2017-11-30', NULL),
('5756', '12', '458', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2275'),
('5757', '12', '459', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2276'),
('5758', '12', '460', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2277'),
('5759', '12', '461', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2278'),
('5760', '30', '871', '10', '2018-01-15 02:54:11', NULL, '3', '2017-09-26', '0'),
('5761', '13', '871', '10', '2018-01-15 02:54:11', NULL, '3', '2017-09-26', '0'),
('5762', '10', '863', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-26', '1624'),
('5763', '30', '872', '10', '2018-01-15 02:56:33', NULL, '3', '2017-10-27', '0'),
('5764', '13', '872', '10', '2018-01-15 02:56:33', NULL, '3', '2017-10-27', '0'),
('5765', '10', '864', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1914'),
('5766', '30', '873', '10', '2018-01-15 02:57:21', NULL, '3', '2017-10-16', '0'),
('5767', '13', '873', '10', '2018-01-15 02:57:21', NULL, '3', '2017-10-16', '0'),
('5768', '10', '865', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1793'),
('5769', '30', '874', '10', '2018-01-15 02:58:18', NULL, '3', '2017-10-16', '0'),
('5770', '13', '874', '10', '2018-01-15 02:58:18', NULL, '3', '2017-10-16', '0'),
('5771', '10', '866', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1794'),
('5772', '30', '875', '10', '2018-01-15 03:01:32', NULL, '3', '2017-10-30', '0'),
('5773', '13', '875', '10', '2018-01-15 03:01:32', NULL, '3', '2017-10-30', '0'),
('5774', '10', '867', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1932'),
('5775', '30', '876', '10', '2018-01-15 03:09:00', NULL, '3', '2017-10-30', '0'),
('5776', '13', '876', '10', '2018-01-15 03:09:00', NULL, '3', '2017-10-30', '0'),
('5777', '10', '868', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1933'),
('5778', '30', '877', '10', '2018-01-15 03:12:10', NULL, '3', '2017-10-30', '0'),
('5779', '13', '877', '10', '2018-01-15 03:12:10', NULL, '3', '2017-10-30', '0'),
('5780', '10', '869', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1934'),
('5781', '30', '878', '10', '2018-01-15 03:15:46', NULL, '3', '2017-10-30', '0'),
('5782', '13', '878', '10', '2018-01-15 03:15:46', NULL, '3', '2017-10-30', '0'),
('5783', '10', '870', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-30', '1935'),
('5784', '30', '879', '10', '2018-01-15 03:18:54', NULL, '3', '2017-11-30', '0'),
('5785', '13', '879', '10', '2018-01-15 03:18:54', NULL, '3', '2017-11-30', '0'),
('5786', '10', '871', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2279'),
('5787', '30', '880', '10', '2018-01-15 03:21:04', NULL, '3', '2017-11-30', '0'),
('5788', '13', '880', '10', '2018-01-15 03:21:04', NULL, '3', '2017-11-30', '0'),
('5789', '10', '872', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2280'),
('5790', '30', '881', '10', '2018-01-15 03:23:24', NULL, '3', '2017-11-30', '0'),
('5791', '13', '881', '10', '2018-01-15 03:23:24', NULL, '3', '2017-11-30', '0'),
('5792', '10', '873', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2281'),
('5793', '1', '1525', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-15', '2632'),
('5794', '18', '33', '10', '2018-01-15 05:22:29', NULL, '3', '2018-01-15', '0'),
('5795', '25', '32', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-15', '2633'),
('5796', '20', '90', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-15', '2634'),
('5797', '22', '33', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-15', '2635'),
('5798', '1', '1526', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2637'),
('5799', '1', '1527', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2638'),
('5800', '1', '1528', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2639'),
('5801', '1', '1529', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2640'),
('5802', '1', '1530', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2641'),
('5803', '1', '1531', '10', '2018-03-07 01:28:31', NULL, '3', '2018-01-16', NULL),
('5804', '1', '1532', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2642'),
('5805', '1', '1533', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2643'),
('5806', '1', '1534', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2644'),
('5807', '13', '791', '10', '2018-01-16 01:40:09', 'Voided.', '3', '2018-01-16', '0'),
('5808', '10', '783', '10', '2018-01-16 01:40:09', 'Voided.\n', '3', '2018-01-16', '0'),
('5809', '30', '882', '10', '2018-01-16 01:41:21', NULL, '3', '2017-12-14', '0'),
('5810', '13', '882', '10', '2018-01-16 01:41:21', NULL, '3', '2017-12-14', '0'),
('5811', '10', '874', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-14', '2414'),
('5812', '1', '1535', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2645'),
('5813', '12', '462', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-05', '2819'),
('5814', '30', '883', '10', '2018-01-16 02:53:00', NULL, '3', '2017-12-31', '0'),
('5815', '13', '883', '10', '2018-01-16 02:53:00', NULL, '3', '2017-12-31', '0'),
('5816', '10', '875', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-31', '2515'),
('5817', '30', '884', '10', '2018-01-16 03:11:47', NULL, '3', '2017-12-31', '0'),
('5818', '13', '884', '10', '2018-01-16 03:11:47', NULL, '3', '2017-12-31', '0'),
('5819', '10', '876', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-31', '2516'),
('5820', '13', '813', '10', '2018-01-16 03:12:37', 'Voided.', '3', '2018-01-16', '0'),
('5821', '10', '805', '10', '2018-01-16 03:12:37', 'Voided.\n', '3', '2018-01-16', '0'),
('5822', '1', '1536', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2646'),
('5823', '4', '77', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2647'),
('5824', '30', '885', '10', '2018-01-16 04:39:46', NULL, '3', '2017-12-31', '0'),
('5825', '13', '885', '10', '2018-01-16 04:39:46', NULL, '3', '2017-12-31', '0'),
('5826', '10', '877', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-31', '2517'),
('5827', '30', '886', '10', '2018-01-16 04:41:15', NULL, '3', '2017-12-31', '0'),
('5828', '13', '886', '10', '2018-01-16 04:41:15', NULL, '3', '2017-12-31', '0'),
('5829', '10', '878', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-31', '2518'),
('5830', '1', '1537', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2648'),
('5831', '1', '1538', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2649'),
('5832', '1', '1539', '10', '2018-01-16 22:28:36', NULL, '3', '2018-01-16', NULL),
('5833', '1', '1540', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2650'),
('5834', '1', '1539', '10', '2018-01-16 22:28:36', 'Voided.\nDocument reentered.', '3', '2018-01-16', '0'),
('5835', '10', '817', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-12-29', '2511'),
('5836', '1', '1541', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-17', '2658'),
('5837', '1', '1542', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-17', '2659'),
('5838', '1', '1543', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-17', '2660'),
('5839', '1', '1544', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-17', '2661'),
('5840', '1', '1545', '10', '2018-01-17 00:38:10', NULL, '3', '2018-01-17', NULL),
('5841', '1', '1546', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-17', '2662'),
('5842', '1', '1545', '10', '2018-01-17 00:38:10', 'Voided.\nDocument reentered.', '3', '2018-01-17', '0'),
('5843', '1', '1547', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-17', '2663'),
('5844', '1', '1548', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-17', '2664'),
('5845', '4', '78', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-18', '2669'),
('5846', '1', '1549', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-18', '2670'),
('5847', '1', '1550', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-18', '2671'),
('5848', '1', '1551', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-18', '2672'),
('5849', '20', '91', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-19', '2444'),
('5850', '20', '92', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2313'),
('5851', '22', '34', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-18', '2673'),
('5852', '1', '1552', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-12', '2626'),
('5853', '1', '1553', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-18', '2674'),
('5854', '1', '1554', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-18', '2675'),
('5855', '1', '1555', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-18', '2676'),
('5856', '1', '1556', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-18', '2677'),
('5857', '1', '1557', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-18', '2678'),
('5858', '1', '1558', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-18', '2679'),
('5859', '1', '1559', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-19', '2681'),
('5860', '12', '463', '10', '2018-03-16 06:41:14', NULL, '3', '2018-01-19', NULL),
('5861', '1', '1560', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-19', '2682'),
('5862', '30', '887', '10', '2018-01-19 03:52:39', NULL, '3', '2018-01-19', '0'),
('5863', '13', '887', '10', '2018-01-19 03:52:39', NULL, '3', '2018-01-19', '0'),
('5864', '10', '879', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-19', '2683'),
('5865', '1', '1561', '10', '2018-01-19 03:59:56', NULL, '3', '2018-01-19', NULL),
('5866', '1', '1562', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-19', '2684'),
('5867', '1', '1561', '10', '2018-01-19 03:59:56', 'Voided.\nDocument reentered.', '3', '2018-01-19', '0'),
('5868', '30', '888', '10', '2018-01-21 22:48:25', NULL, '3', '2017-12-31', '0'),
('5869', '13', '888', '10', '2018-01-21 22:48:25', NULL, '3', '2017-12-31', '0'),
('5870', '10', '880', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-31', '2519'),
('5871', '30', '889', '10', '2018-01-21 22:50:02', NULL, '3', '2017-12-31', '0'),
('5872', '13', '889', '10', '2018-01-21 22:50:03', NULL, '3', '2017-12-31', '0'),
('5873', '10', '881', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-31', '2520'),
('5874', '30', '890', '10', '2018-01-21 22:51:10', NULL, '3', '2017-12-31', '0'),
('5875', '13', '890', '10', '2018-01-21 22:51:10', NULL, '3', '2017-12-31', '0'),
('5876', '10', '882', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-31', '2521'),
('5877', '12', '464', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-29', '2766'),
('5878', '12', '465', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-18', '2680'),
('5879', '12', '466', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-14', '2894'),
('5880', '12', '467', '10', '2018-02-16 00:24:16', NULL, '3', '2018-01-17', NULL),
('5881', '12', '445', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-02', '2552'),
('5882', '12', '450', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-02', '2553'),
('5883', '12', '468', '10', '2018-02-08 00:44:21', NULL, '3', '2018-01-02', NULL),
('5884', '1', '1563', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-22', '2693'),
('5885', '1', '1564', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-22', '2694'),
('5886', '1', '1565', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-19', '2685'),
('5887', '12', '469', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-23', '2700'),
('5888', '1', '1566', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-23', '2701'),
('5889', '1', '1567', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-23', '2702'),
('5890', '30', '891', '10', '2018-01-23 00:28:32', NULL, '3', '2018-01-19', '0'),
('5891', '13', '891', '10', '2018-01-23 00:28:32', NULL, '3', '2018-01-19', '0'),
('5892', '10', '883', '10', '2018-03-16 06:47:46', NULL, '3', '2018-01-19', NULL),
('5893', '12', '470', '10', '2018-03-16 06:48:00', NULL, '3', '2018-01-23', NULL),
('5894', '12', '471', '10', '2018-03-20 02:07:37', NULL, '3', '2018-01-23', NULL),
('5895', '12', '472', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-23', '2703'),
('5896', '12', '473', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-23', '2704'),
('5897', '12', '474', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-23', '2705'),
('5898', '30', '892', '10', '2018-01-23 01:29:47', NULL, '3', '2018-01-11', '0'),
('5899', '13', '892', '10', '2018-01-23 01:29:48', NULL, '3', '2018-01-11', '0'),
('5900', '10', '884', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-11', '2610'),
('5901', '12', '475', '10', '2018-01-24 04:06:09', NULL, '3', '2018-01-11', NULL),
('5902', '1', '1568', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-23', '2706'),
('5903', '10', '724', '10', '2018-01-23 02:18:36', 'Voided.\n', '3', '2018-01-23', '0'),
('5904', '12', '389', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-12-06', '2339'),
('5905', '10', '202', '10', '2018-01-23 03:09:05', 'Updated.', '2', '2017-03-31', NULL),
('5906', '10', '202', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-03-31', '498'),
('5907', '1', '1569', '10', '2018-01-24 01:47:47', NULL, '3', '2018-01-23', NULL),
('5908', '1', '1570', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-23', '2707'),
('5909', '30', '893', '10', '2018-01-23 23:51:49', NULL, '3', '2018-01-24', '0'),
('5910', '13', '893', '10', '2018-03-19 04:32:33', NULL, '3', '2018-01-24', NULL),
('5911', '10', '885', '10', '2018-01-23 23:52:36', NULL, '3', '2018-01-24', NULL),
('5912', '10', '885', '10', '2018-01-24 00:19:55', 'Updated.', '3', '2018-01-24', NULL),
('5913', '10', '885', '10', '2018-01-24 00:21:18', 'Updated.', '3', '2018-01-24', NULL),
('5914', '10', '885', '10', '2018-03-19 04:32:33', 'Updated.', '3', '2018-01-24', NULL),
('5915', '12', '333', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-02', '1979'),
('5916', '12', '453', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-02', '2554'),
('5917', '12', '417', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-02', '2555'),
('5918', '12', '331', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-02', '1980'),
('5919', '12', '451', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-02', '2556'),
('5920', '12', '444', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-02', '2557'),
('5921', '12', '452', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-02', '2558'),
('5922', '12', '420', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-02', '2559'),
('5923', '4', '79', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-24', '2718'),
('5924', '1', '536', '10', '2018-01-24 01:46:59', 'Voided.\n', '3', '2018-01-24', '0'),
('5925', '1', '1571', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-23', '2708'),
('5926', '1', '1569', '10', '2018-01-24 01:47:47', 'Voided.\nDocument reentered.', '3', '2018-01-24', '0'),
('5927', '30', '894', '10', '2018-01-24 03:42:16', NULL, '3', '2017-12-31', '0'),
('5928', '13', '894', '10', '2018-02-27 03:48:59', NULL, '3', '2017-12-31', NULL),
('5929', '10', '886', '10', '2018-02-27 03:48:59', NULL, '3', '2017-12-31', NULL),
('5930', '12', '475', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-23', '2709'),
('5931', '2', '89', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-24', '2719'),
('5932', '30', '895', '10', '2018-01-24 04:42:54', NULL, '3', '2018-01-19', '0'),
('5933', '13', '895', '10', '2018-01-24 04:42:54', NULL, '3', '2018-01-19', '0'),
('5934', '10', '887', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-19', '2686'),
('5935', '12', '476', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-24', '2720'),
('5936', '1', '1572', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-24', '2721'),
('5937', '1', '1573', '10', '2018-01-24 04:59:45', NULL, '3', '2018-01-24', NULL),
('5938', '1', '1574', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-24', '2722'),
('5939', '1', '1575', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-24', '2723'),
('5940', '1', '1573', '10', '2018-01-24 04:59:45', 'Voided.\nDocument reentered.', '3', '2018-01-24', '0'),
('5941', '1', '1576', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-24', '2724'),
('5942', '1', '1577', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-25', '2728'),
('5943', '1', '1578', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-25', '2729'),
('5944', '1', '1579', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-25', '2730'),
('5945', '12', '226', '10', '2018-01-25 03:29:41', 'Voided.\nWrong Customer', '3', '2018-01-25', '0'),
('5946', '12', '477', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-30', '1386'),
('5947', '1', '1580', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-25', '2731'),
('5948', '1', '1581', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-25', '2732'),
('5949', '10', '50', '1', '2019-11-05 05:45:21', 'Updated.', '2', '2017-02-28', '371'),
('5950', '30', '896', '10', '2018-01-25 04:36:55', NULL, '3', '2018-01-25', '0'),
('5951', '13', '896', '10', '2018-01-25 04:36:56', NULL, '3', '2018-01-25', '0'),
('5952', '10', '888', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-25', '2733'),
('5953', '13', '414', '10', '2018-01-25 05:06:16', 'Voided.', '3', '2018-01-25', '0'),
('5954', '10', '417', '10', '2018-01-25 05:06:16', 'Voided.\nMr Pintoe Ask to Void ', '3', '2018-01-25', '0'),
('5955', '13', '410', '10', '2018-01-25 05:07:07', 'Voided.', '3', '2018-01-25', '0'),
('5956', '10', '413', '10', '2018-01-25 05:07:07', 'Voided.\nMr Pintoe Ask to Void ', '3', '2018-01-25', '0'),
('5957', '12', '478', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-25', '2734'),
('5958', '13', '696', '10', '2018-01-25 05:08:55', 'Voided.', '3', '2018-01-25', '0'),
('5959', '10', '693', '10', '2018-01-25 05:08:55', 'Voided.\nMr Pintoe Ask to Void ', '3', '2018-01-25', '0'),
('5960', '13', '96', '10', '2018-01-25 05:09:49', 'Voided.', '3', '2018-01-25', '0'),
('5961', '10', '99', '10', '2018-01-25 05:09:49', 'Voided.\nMr Pintoe Ask to Void ', '3', '2018-01-25', '0'),
('5962', '1', '1582', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-25', '2735'),
('5963', '10', '128', '10', '2018-01-25 23:15:13', 'Updated.', '2', '2017-03-16', NULL),
('5964', '10', '128', '10', '2019-11-05 05:45:21', 'Updated.', '2', '2017-03-16', '411'),
('5965', '10', '747', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-10-19', '1812'),
('5966', '10', '793', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-24', '2174'),
('5967', '11', '76', '10', '2018-01-25 23:22:12', NULL, '3', '2018-01-25', '0'),
('5968', '10', '807', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-12-13', '2398'),
('5969', '13', '570', '10', '2018-01-26 01:12:57', 'Voided.', '3', '2018-01-26', '0'),
('5970', '10', '568', '10', '2018-01-26 01:12:57', 'Voided.\n', '3', '2018-01-26', '0'),
('5971', '30', '897', '10', '2018-01-26 01:15:22', NULL, '3', '2018-01-26', '0'),
('5972', '13', '897', '10', '2018-01-26 01:15:23', NULL, '3', '2018-01-26', '0'),
('5973', '10', '889', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2738'),
('5974', '12', '479', '10', '2018-02-01 03:46:54', NULL, '3', '2018-01-26', NULL),
('5975', '1', '1583', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2739'),
('5976', '1', '1584', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2740'),
('5977', '1', '1585', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2741'),
('5978', '1', '1586', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2742'),
('5979', '30', '898', '10', '2018-01-26 02:30:16', NULL, '3', '2018-01-26', '0'),
('5980', '13', '898', '10', '2018-01-26 02:30:16', NULL, '3', '2018-01-26', '0'),
('5981', '1', '1587', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2743'),
('5982', '1', '1588', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2744'),
('5983', '1', '1589', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2745'),
('5984', '1', '1590', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2746'),
('5985', '12', '480', '10', '2018-02-16 00:12:29', NULL, '3', '2018-01-26', NULL),
('5986', '1', '1591', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2747'),
('5987', '12', '481', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2748'),
('5988', '1', '1592', '10', '2018-01-26 05:10:14', NULL, '3', '2018-01-26', NULL),
('5989', '1', '1593', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2749'),
('5990', '1', '1594', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2750'),
('5991', '1', '1595', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2751'),
('5992', '1', '1592', '10', '2018-01-26 05:10:14', 'Voided.\nDocument reentered.', '3', '2018-01-26', '0'),
('5993', '1', '1596', '10', '2018-01-30 02:26:25', NULL, '3', '2018-01-26', NULL),
('5994', '1', '1597', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-29', '2767'),
('5995', '1', '1598', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-29', '2768'),
('5996', '4', '80', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-29', '2769'),
('5997', '12', '482', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-20', '2947'),
('5998', '1', '1599', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-29', '2770'),
('5999', '1', '1600', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-29', '2771'),
('6000', '1', '1601', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-29', '2772'),
('6001', '1', '1602', '10', '2018-03-07 02:10:38', NULL, '3', '2018-01-29', NULL),
('6002', '1', '1603', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-29', '2773'),
('6003', '1', '1604', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-30', '2777'),
('6004', '1', '1605', '10', '2018-03-14 04:26:21', NULL, '3', '2018-01-26', NULL),
('6005', '1', '1596', '10', '2018-01-30 02:26:25', 'Voided.\nDocument reentered.', '3', '2018-01-30', '0'),
('6006', '30', '899', '10', '2018-01-30 02:43:51', NULL, '3', '2018-01-09', '0'),
('6007', '13', '899', '10', '2018-01-30 02:43:52', NULL, '3', '2018-01-09', '0'),
('6008', '10', '890', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-09', '2597'),
('6009', '12', '483', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-30', '2778'),
('6010', '1', '1606', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-30', '2779'),
('6011', '2', '90', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-28', '2506'),
('6012', '2', '91', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-20', '2452'),
('6013', '2', '92', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-20', '2453'),
('6014', '2', '93', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-20', '2454'),
('6015', '1', '1607', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-20', '2455'),
('6016', '1', '1608', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2466'),
('6017', '1', '1609', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2467'),
('6018', '1', '1610', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2468'),
('6019', '1', '1611', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2469'),
('6020', '1', '1612', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2470'),
('6021', '1', '1613', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2471'),
('6022', '1', '1614', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2472'),
('6023', '1', '1615', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2473'),
('6024', '1', '1616', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-26', '2490'),
('6025', '1', '1617', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-26', '2491'),
('6026', '1', '1618', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-31', '2522'),
('6027', '2', '94', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-22', '2482'),
('6028', '4', '81', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2388'),
('6029', '4', '82', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2389'),
('6030', '1', '1619', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2793'),
('6031', '1', '1620', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2794'),
('6032', '1', '1621', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2795'),
('6033', '1', '1622', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2796'),
('6034', '1', '1623', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2797'),
('6035', '1', '1624', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2798'),
('6036', '1', '1625', '10', '2018-07-31 09:01:09', NULL, '5', '2017-12-08', NULL),
('6037', '1', '1626', '10', '2018-07-31 09:01:45', NULL, '5', '2017-12-08', NULL),
('6038', '1', '1627', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2314'),
('6039', '1', '1628', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2315'),
('6040', '1', '1629', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-31', '2523'),
('6041', '1', '1630', '10', '2018-02-01 03:28:54', NULL, '3', '2018-02-01', NULL),
('6042', '1', '1631', '10', '2018-02-01 04:31:57', NULL, '3', '2018-02-01', NULL),
('6043', '1', '1632', '10', '2018-02-01 03:29:43', NULL, '3', '2018-02-01', NULL),
('6044', '1', '1633', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2799'),
('6045', '1', '1630', '10', '2018-02-01 03:28:54', 'Voided.\nDocument reentered.', '3', '2018-02-01', '0'),
('6046', '1', '1634', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2800'),
('6047', '1', '1632', '10', '2018-02-01 03:29:43', 'Voided.\nDocument reentered.', '3', '2018-02-01', '0'),
('6048', '1', '1635', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2801'),
('6049', '12', '479', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-26', '2752'),
('6050', '1', '1636', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2802'),
('6051', '1', '1631', '10', '2018-02-01 04:31:57', 'Voided.\nDocument reentered.', '3', '2018-02-01', '0'),
('6052', '1', '1637', '10', '2018-03-07 00:02:08', NULL, '3', '2018-02-01', NULL),
('6053', '1', '1638', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2803'),
('6054', '1', '1639', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-02', '2809'),
('6055', '30', '900', '10', '2018-02-02 00:00:50', NULL, '3', '2018-01-30', '0'),
('6056', '13', '900', '10', '2018-02-02 00:00:51', NULL, '3', '2018-01-30', '0'),
('6057', '10', '891', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-30', '2780'),
('6058', '1', '1640', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-02', '2810'),
('6059', '1', '1641', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-02', '2811'),
('6060', '1', '1642', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-02', '2812'),
('6061', '1', '1643', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-02', '2813'),
('6062', '1', '1644', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-02', '2814'),
('6063', '1', '1645', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-30', '2781'),
('6064', '1', '1646', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-30', '2782'),
('6065', '1', '1647', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-02', '2815'),
('6066', '1', '1648', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-05', '2820'),
('6067', '30', '901', '10', '2018-02-04 23:51:14', NULL, '2', '2016-09-30', '0'),
('6068', '13', '901', '10', '2018-02-04 23:51:14', NULL, '2', '2016-09-30', '0'),
('6069', '10', '892', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-30', '139'),
('6070', '13', '663', '10', '2018-02-04 23:52:38', 'Voided.', '3', '2018-02-04', '0'),
('6071', '10', '660', '10', '2018-02-04 23:52:38', 'Voided.\n', '3', '2018-02-04', '0'),
('6072', '18', '34', '10', '2018-02-05 00:17:55', NULL, '3', '2018-02-05', '0'),
('6073', '25', '33', '10', '2018-02-05 00:17:55', NULL, '3', '2018-02-05', '0'),
('6074', '1', '1649', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-05', '2821'),
('6075', '12', '484', '10', '2018-05-01 04:42:42', NULL, '5', '2018-04-30', NULL),
('6076', '12', '485', '10', '2018-07-02 01:40:10', NULL, '5', '2018-07-02', NULL),
('6077', '1', '1650', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-05', '2822'),
('6078', '1', '1651', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-05', '2823'),
('6079', '12', '486', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-06', '2828'),
('6080', '11', '77', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-06', '2829'),
('6081', '11', '78', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-06', '2830'),
('6082', '30', '902', '10', '2018-02-06 02:56:36', NULL, '3', '2018-02-06', '0'),
('6083', '13', '902', '10', '2018-03-19 04:39:18', NULL, '3', '2018-02-06', NULL),
('6084', '10', '893', '10', '2018-03-16 06:11:51', NULL, '3', '2018-02-06', NULL),
('6085', '30', '903', '10', '2018-02-06 03:01:23', NULL, '3', '2018-02-06', '0'),
('6086', '13', '903', '10', '2018-02-06 03:01:23', NULL, '3', '2018-02-06', '0'),
('6087', '10', '894', '10', '2018-03-16 06:50:04', NULL, '3', '2018-02-06', NULL),
('6088', '4', '83', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-06', '2831'),
('6089', '1', '1652', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-06', '2832'),
('6090', '1', '1653', '10', '2018-03-07 00:23:41', NULL, '3', '2018-02-06', NULL),
('6091', '1', '1654', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-06', '2833'),
('6092', '1', '1655', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-06', '2834'),
('6093', '1', '1656', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-06', '2835'),
('6094', '32', '2', '10', '2018-02-06 23:30:32', NULL, '3', '2018-02-07', '0'),
('6095', '1', '1657', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-07', '2842'),
('6096', '1', '1658', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-07', '2843'),
('6097', '1', '1659', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-07', '2844'),
('6098', '20', '93', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-10', '2605'),
('6099', '20', '94', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-23', '2710'),
('6100', '22', '35', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-07', '2845'),
('6101', '1', '1660', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-07', '2846'),
('6102', '1', '1661', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-07', '2847'),
('6103', '1', '1662', '10', '2018-02-07 22:43:06', NULL, '3', '2018-02-07', NULL),
('6104', '1', '1663', '10', '2018-02-07 05:20:13', NULL, '3', '2018-02-07', NULL),
('6105', '1', '1664', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-07', '2848'),
('6106', '1', '1663', '10', '2018-02-07 05:20:13', 'Voided.\nDocument reentered.', '3', '2018-02-07', '0'),
('6107', '1', '1665', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-07', '2849'),
('6108', '1', '1666', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-07', '2850');
INSERT INTO `0_audit_trail` VALUES
('6109', '1', '1662', '10', '2018-02-07 22:43:06', 'Voided.\nDocument reentered.', '3', '2018-02-07', '0'),
('6110', '1', '1667', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-08', '2853'),
('6111', '4', '84', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-08', '2854'),
('6112', '1', '1668', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-08', '2855'),
('6113', '12', '487', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2651'),
('6114', '12', '488', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2652'),
('6115', '12', '489', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2653'),
('6116', '12', '490', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2654'),
('6117', '12', '491', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2655'),
('6118', '12', '468', '10', '2018-02-08 00:44:21', 'Voided.\n', '3', '2018-02-08', '0'),
('6119', '4', '85', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-09', '2598'),
('6120', '4', '86', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-23', '2711'),
('6121', '4', '87', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-30', '2783'),
('6122', '1', '1669', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-01', '2528'),
('6123', '1', '1670', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-17', '2665'),
('6124', '1', '1671', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2753'),
('6125', '1', '1672', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2754'),
('6126', '1', '1673', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2755'),
('6127', '1', '1674', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2756'),
('6128', '1', '1675', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2757'),
('6129', '1', '1676', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2758'),
('6130', '1', '1677', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2759'),
('6131', '1', '1678', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2760'),
('6132', '1', '1679', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2761'),
('6133', '1', '1680', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2762'),
('6134', '1', '1681', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-31', '2787'),
('6135', '1', '1682', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-31', '2788'),
('6136', '12', '81', '10', '2018-02-08 01:18:00', 'Voided.\nCHQ Returned', '3', '2018-02-08', '0'),
('6137', '12', '255', '10', '2018-02-08 01:25:55', 'Voided.\nCHQ Returned', '3', '2018-02-08', '0'),
('6138', '12', '369', '10', '2018-02-08 01:27:18', 'Voided.\n', '3', '2018-02-08', '0'),
('6139', '1', '1683', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-08', '2856'),
('6140', '1', '1684', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-08', '2857'),
('6141', '32', '3', '10', '2018-02-08 23:08:36', NULL, '3', '2018-02-08', '0'),
('6142', '32', '4', '10', '2018-02-08 23:09:12', NULL, '3', '2018-02-08', '0'),
('6143', '1', '1685', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-09', '2859'),
('6144', '1', '1686', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-09', '2860'),
('6145', '1', '1687', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-09', '2861'),
('6146', '1', '1688', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-09', '2862'),
('6147', '1', '1689', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-09', '2863'),
('6148', '1', '1690', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-09', '2864'),
('6149', '1', '1691', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-09', '2865'),
('6150', '11', '79', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2877'),
('6151', '1', '1692', '10', '2018-02-13 01:30:18', NULL, '3', '2018-02-13', NULL),
('6152', '1', '1693', '10', '2018-02-13 01:31:40', NULL, '3', '2018-02-13', NULL),
('6153', '1', '1694', '10', '2018-03-14 04:27:54', NULL, '3', '2018-02-13', NULL),
('6154', '1', '1692', '10', '2018-02-13 01:30:18', 'Voided.\nDocument reentered.', '3', '2018-02-13', '0'),
('6155', '1', '1695', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2878'),
('6156', '1', '1693', '10', '2018-02-13 01:31:40', 'Voided.\nDocument reentered.', '3', '2018-02-13', '0'),
('6157', '1', '1696', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2879'),
('6158', '1', '1697', '10', '2018-03-07 02:13:15', NULL, '3', '2018-02-13', NULL),
('6159', '1', '1698', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2880'),
('6160', '1', '1699', '10', '2018-03-07 00:02:44', NULL, '3', '2018-02-13', NULL),
('6161', '4', '88', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-12', '2870'),
('6162', '1', '1700', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2881'),
('6163', '1', '1701', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2882'),
('6164', '1', '1702', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2883'),
('6165', '1', '1703', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2884'),
('6166', '1', '1704', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2885'),
('6167', '1', '1705', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2886'),
('6168', '1', '1706', '10', '2018-03-07 02:13:45', NULL, '3', '2018-02-13', NULL),
('6169', '1', '1707', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-14', '2895'),
('6170', '18', '35', '1', '2018-02-15 01:53:33', NULL, '3', '2018-02-15', '0'),
('6171', '35', '2', '1', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2902'),
('6172', '25', '34', '1', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2903'),
('6173', '1', '1708', '10', '2018-02-15 22:21:27', NULL, '3', '2018-02-15', NULL),
('6174', '1', '1709', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2904'),
('6175', '1', '1708', '10', '2018-02-15 22:21:27', 'Voided.\nDocument reentered.', '3', '2018-02-15', '0'),
('6176', '12', '480', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-02-16', '2919'),
('6177', '12', '492', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2905'),
('6178', '12', '493', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2906'),
('6179', '12', '494', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2907'),
('6180', '12', '495', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2908'),
('6181', '12', '496', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-16', '2920'),
('6182', '12', '497', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-16', '2921'),
('6183', '12', '498', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-16', '2922'),
('6184', '12', '499', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-20', '2948'),
('6185', '12', '500', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-16', '2923'),
('6186', '12', '501', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-30', '3267'),
('6187', '12', '502', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-16', '2924'),
('6188', '12', '467', '10', '2018-02-16 01:31:05', 'Updated.', '3', '2018-01-17', NULL),
('6189', '1', '1710', '10', '2018-02-25 22:42:09', NULL, '3', '2018-02-16', NULL),
('6190', '12', '503', '10', '2018-02-16 00:35:52', NULL, '3', '2018-01-26', NULL),
('6191', '12', '504', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-19', '2936'),
('6192', '12', '503', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-02-26', '2999'),
('6193', '12', '505', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2909'),
('6194', '12', '506', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2910'),
('6195', '12', '507', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2911'),
('6196', '11', '80', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2912'),
('6197', '11', '81', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2913'),
('6198', '11', '82', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2914'),
('6199', '11', '83', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2915'),
('6200', '11', '84', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2916'),
('6201', '11', '85', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2917'),
('6202', '11', '86', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-15', '2918'),
('6203', '12', '508', '10', '2018-03-19 22:52:41', NULL, '3', '2018-03-20', NULL),
('6204', '12', '509', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-20', '2949'),
('6205', '11', '87', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-16', '2925'),
('6206', '12', '183', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-02-16', '2926'),
('6207', '12', '510', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-16', '2927'),
('6208', '12', '467', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-02-16', '2928'),
('6209', '1', '1711', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-16', '2929'),
('6210', '12', '511', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-16', '2930'),
('6211', '1', '1712', '1', '2018-03-14 02:00:30', NULL, '3', '2018-02-16', NULL),
('6212', '30', '904', '10', '2018-02-16 02:40:22', NULL, '2', '2016-09-30', '0'),
('6213', '13', '904', '10', '2018-02-16 02:40:22', NULL, '2', '2016-09-30', '0'),
('6214', '10', '895', '10', '2019-11-05 05:45:21', NULL, '2', '2016-09-30', '140'),
('6215', '12', '512', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-16', '2931'),
('6216', '30', '905', '10', '2018-02-16 03:14:46', NULL, '3', '2018-02-01', '0'),
('6217', '13', '905', '10', '2018-03-19 04:36:03', NULL, '3', '2018-02-01', NULL),
('6218', '10', '896', '10', '2018-03-16 06:49:15', NULL, '3', '2018-02-01', NULL),
('6219', '12', '513', '10', '2018-03-16 06:49:39', NULL, '3', '2018-02-16', NULL),
('6220', '11', '88', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-16', '2932'),
('6221', '4', '89', '1', '2018-03-27 00:23:14', NULL, '3', '2018-02-16', NULL),
('6222', '30', '906', '10', '2018-02-18 21:27:33', NULL, '3', '2018-02-19', '0'),
('6223', '13', '906', '10', '2018-02-18 21:27:33', NULL, '3', '2018-02-19', '0'),
('6224', '10', '897', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-19', '2937'),
('6225', '30', '907', '10', '2018-02-18 21:29:18', NULL, '3', '2018-02-19', '0'),
('6226', '13', '907', '10', '2018-02-18 21:29:18', NULL, '3', '2018-02-19', '0'),
('6227', '10', '898', '10', '2018-03-16 06:51:33', NULL, '3', '2018-02-19', NULL),
('6228', '30', '908', '10', '2018-02-18 22:09:03', NULL, '3', '2018-01-31', '0'),
('6229', '13', '908', '10', '2018-02-18 22:09:03', NULL, '3', '2018-01-31', '0'),
('6230', '10', '899', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-31', '2789'),
('6231', '30', '909', '10', '2018-02-18 22:11:01', NULL, '3', '2018-01-31', '0'),
('6232', '13', '909', '10', '2018-08-13 03:22:36', NULL, '5', '2018-01-31', NULL),
('6233', '10', '900', '10', '2018-08-13 03:22:37', NULL, '5', '2018-01-31', NULL),
('6234', '1', '1713', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-19', '2938'),
('6235', '1', '1714', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-19', '2939'),
('6236', '1', '1715', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-19', '2940'),
('6237', '1', '1716', '10', '2018-03-07 00:03:21', NULL, '3', '2018-02-20', NULL),
('6238', '1', '1717', '10', '2018-03-07 00:24:18', NULL, '3', '2018-02-20', NULL),
('6239', '1', '1718', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-20', '2950'),
('6240', '1', '1719', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-20', '2951'),
('6241', '1', '1720', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-20', '2952'),
('6242', '30', '910', '10', '2018-02-20 22:50:31', NULL, '3', '2018-02-21', '0'),
('6243', '13', '910', '10', '2019-06-22 03:32:54', NULL, '6', '2018-02-21', NULL),
('6244', '10', '901', '10', '2019-06-22 03:32:54', NULL, '6', '2018-02-21', NULL),
('6245', '30', '911', '10', '2018-02-20 22:53:02', NULL, '3', '2018-02-21', '0'),
('6246', '13', '911', '10', '2018-02-20 22:53:02', NULL, '3', '2018-02-21', '0'),
('6247', '10', '902', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-21', '2958'),
('6248', '1', '1721', '1', '2018-02-21 02:05:08', NULL, '3', '2018-02-21', NULL),
('6249', '1', '1721', '1', '2018-02-21 02:05:08', 'Voided.\n', '3', '2018-02-21', '0'),
('6250', '1', '1722', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-21', '2959'),
('6251', '1', '1723', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-21', '2960'),
('6252', '1', '1724', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-21', '2961'),
('6253', '1', '1725', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-21', '2962'),
('6254', '1', '1726', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-21', '2963'),
('6255', '12', '514', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-21', '2964'),
('6256', '12', '515', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-15', '3174'),
('6257', '12', '516', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-22', '2971'),
('6258', '1', '1727', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-22', '2972'),
('6259', '1', '1728', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-22', '2973'),
('6260', '1', '1729', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-22', '2974'),
('6261', '1', '1730', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-22', '2975'),
('6262', '30', '912', '10', '2018-02-22 04:23:12', NULL, '3', '2018-02-22', '0'),
('6263', '13', '912', '10', '2018-02-22 04:23:12', NULL, '3', '2018-02-22', '0'),
('6264', '10', '903', '10', '2018-02-25 22:19:32', NULL, '3', '2018-02-22', NULL),
('6265', '12', '517', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-22', '2976'),
('6266', '12', '518', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-22', '2977'),
('6267', '32', '5', '10', '2018-02-22 20:17:34', NULL, '3', '2018-02-23', '0'),
('6268', '2', '95', '10', '2018-08-03 05:09:44', NULL, '5', '2018-02-23', NULL),
('6269', '12', '519', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-23', '2984'),
('6270', '1', '1731', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-23', '2985'),
('6271', '1', '1732', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-23', '2986'),
('6272', '1', '1733', '10', '2018-02-26 02:26:58', NULL, '3', '2018-02-23', NULL),
('6273', '26', '4', '1', '2018-02-24 08:35:14', NULL, '3', '2018-02-24', NULL),
('6274', '26', '4', '1', '2018-02-24 08:39:08', 'Released.', '3', '2018-02-24', NULL),
('6275', '29', '4', '1', '2018-02-24 08:35:14', 'Production.', '3', '2018-02-24', '0'),
('6276', '26', '4', '1', '2018-02-24 08:39:08', 'Voided.\n', '3', '2018-02-24', '0'),
('6277', '10', '903', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-02-22', '2978'),
('6278', '1', '1734', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-16', '2933'),
('6279', '1', '1710', '10', '2018-02-25 22:42:09', 'Voided.\nDocument reentered.', '3', '2018-02-25', '0'),
('6280', '1', '1735', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3000'),
('6281', '18', '36', '10', '2018-02-25 23:42:29', NULL, '3', '2018-01-26', '0'),
('6282', '25', '35', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2763'),
('6283', '20', '95', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2764'),
('6284', '22', '36', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-21', '2965'),
('6285', '1', '1736', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-20', '2953'),
('6286', '1', '1737', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-21', '2966'),
('6287', '12', '520', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3001'),
('6288', '16', '32', '10', '2018-02-26 00:08:15', NULL, '3', '2018-02-26', '0'),
('6289', '11', '89', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3002'),
('6290', '11', '90', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3003'),
('6291', '11', '91', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3004'),
('6292', '11', '92', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3005'),
('6293', '11', '93', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3006'),
('6294', '11', '94', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3007'),
('6295', '1', '1738', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3008'),
('6296', '1', '1739', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3009'),
('6297', '1', '1740', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3010'),
('6298', '1', '1741', '10', '2018-03-19 10:33:48', NULL, '3', '2018-02-23', NULL),
('6299', '1', '1733', '10', '2018-02-26 02:26:58', 'Voided.\nDocument reentered.', '3', '2018-02-26', '0'),
('6300', '1', '1742', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3011'),
('6301', '1', '1743', '10', '2018-03-19 10:52:57', NULL, '3', '2018-02-27', NULL),
('6302', '1', '1744', '10', '2018-03-19 10:53:18', NULL, '3', '2018-02-27', NULL),
('6303', '1', '1745', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3025'),
('6304', '1', '1746', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3026'),
('6305', '1', '1747', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3027'),
('6306', '1', '1748', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3028'),
('6307', '1', '1749', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3029'),
('6308', '1', '1750', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3030'),
('6309', '30', '913', '10', '2018-02-27 03:46:00', NULL, '3', '2017-12-31', '0'),
('6310', '13', '913', '10', '2018-03-26 22:47:07', NULL, '3', '2017-12-31', NULL),
('6311', '10', '904', '10', '2018-03-26 22:47:07', NULL, '3', '2017-12-31', NULL),
('6312', '13', '894', '10', '2018-02-27 03:48:59', 'Voided.', '3', '2018-02-27', '0'),
('6313', '10', '886', '10', '2018-02-27 03:48:59', 'Voided.\n', '3', '2018-02-27', '0'),
('6314', '1', '1751', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3031'),
('6315', '1', '1752', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3032'),
('6316', '1', '1753', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3033'),
('6317', '1', '1754', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3012'),
('6318', '1', '1755', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3013'),
('6319', '1', '1756', '10', '2018-03-14 01:52:38', NULL, '3', '2018-02-26', NULL),
('6320', '1', '1757', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3014'),
('6321', '1', '1758', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3041'),
('6322', '1', '1759', '10', '2018-02-28 01:59:40', NULL, '3', '2018-02-28', NULL),
('6323', '1', '1760', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3042'),
('6324', '1', '1761', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3043'),
('6325', '1', '1762', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3044'),
('6326', '30', '914', '10', '2018-02-28 00:55:38', NULL, '3', '2018-02-28', '0'),
('6327', '13', '914', '10', '2018-02-28 00:55:38', NULL, '3', '2018-02-28', '0'),
('6328', '1', '1763', '10', '2018-03-07 00:24:51', NULL, '3', '2018-02-28', NULL),
('6329', '1', '1759', '10', '2018-02-28 01:59:40', 'Voided.\nDocument reentered.', '3', '2018-02-28', '0'),
('6330', '1', '1764', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3045'),
('6331', '1', '1765', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3046'),
('6332', '1', '1766', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3047'),
('6333', '1', '1767', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-02', '3070'),
('6334', '1', '1768', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-02', '3071'),
('6335', '1', '1769', '10', '2018-03-21 00:07:55', NULL, '3', '2018-03-02', NULL),
('6336', '1', '1770', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-02', '3072'),
('6337', '1', '1771', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-02', '3073'),
('6338', '1', '1772', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-02', '3074'),
('6339', '1', '1773', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-02', '3075'),
('6340', '2', '96', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-02', '3076'),
('6341', '12', '521', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-05', '3082'),
('6342', '12', '522', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-05', '3083'),
('6343', '30', '915', '10', '2018-03-06 00:04:24', NULL, '3', '2018-03-06', '0'),
('6344', '13', '915', '10', '2018-03-06 00:28:15', NULL, '3', '2018-03-06', NULL),
('6345', '10', '905', '10', '2018-03-06 00:16:50', NULL, '3', '2018-03-06', NULL),
('6346', '10', '905', '10', '2018-03-06 00:19:44', 'Updated.', '3', '2018-03-06', NULL),
('6347', '10', '905', '10', '2018-03-06 00:20:42', 'Updated.', '3', '2018-03-06', NULL),
('6348', '10', '905', '10', '2018-03-06 00:22:45', 'Updated.', '3', '2018-03-06', NULL),
('6349', '10', '905', '10', '2018-03-06 00:28:15', 'Updated.', '3', '2018-03-06', NULL),
('6350', '30', '916', '10', '2018-03-06 00:23:40', NULL, '3', '2018-03-06', '0'),
('6351', '13', '916', '10', '2018-03-06 00:23:40', NULL, '3', '2018-03-06', '0'),
('6352', '10', '906', '10', '2018-03-06 00:24:19', NULL, '3', '2018-03-06', NULL),
('6353', '10', '906', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-03-06', '3090'),
('6354', '13', '915', '10', '2018-03-06 00:28:15', 'Voided.', '3', '2018-03-06', '0'),
('6355', '10', '905', '10', '2018-03-06 00:28:15', 'Voided.\n', '3', '2018-03-06', '0'),
('6356', '12', '523', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3091'),
('6357', '2', '97', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3092'),
('6358', '12', '524', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3093'),
('6359', '1', '1774', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3094'),
('6360', '1', '1775', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3095'),
('6361', '1', '1776', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3096'),
('6362', '1', '1777', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3097'),
('6363', '1', '1778', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3048'),
('6364', '1', '1779', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3049'),
('6365', '1', '1780', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3098'),
('6366', '4', '90', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3099'),
('6367', '1', '1781', '10', '2018-03-07 00:25:21', NULL, '3', '2018-03-06', NULL),
('6368', '1', '1782', '10', '2018-03-07 21:40:03', NULL, '3', '2018-03-06', NULL),
('6369', '1', '1783', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3100'),
('6370', '1', '1784', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-02', '3077'),
('6371', '1', '1785', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3101'),
('6372', '12', '525', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3102'),
('6373', '12', '526', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3103'),
('6374', '12', '527', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3104'),
('6375', '1', '1786', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-20', '170'),
('6376', '1', '125', '10', '2018-03-06 23:09:33', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6377', '1', '1787', '10', '2018-03-07 00:32:02', NULL, '3', '2017-04-26', NULL),
('6378', '1', '151', '10', '2018-03-06 23:10:12', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6379', '1', '1788', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-02', '302'),
('6380', '1', '183', '10', '2018-03-06 23:11:20', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6381', '1', '1789', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-03', '323'),
('6382', '1', '188', '10', '2018-03-06 23:12:07', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6383', '1', '1790', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-12', '386'),
('6384', '1', '218', '10', '2018-03-06 23:13:01', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6385', '1', '1791', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-12', '387'),
('6386', '1', '219', '10', '2018-03-06 23:13:24', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6387', '1', '1792', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-16', '416'),
('6388', '1', '229', '10', '2018-03-06 23:14:19', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6389', '1', '1793', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-16', '417'),
('6390', '1', '231', '10', '2018-03-06 23:14:58', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6391', '1', '1794', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-30', '559'),
('6392', '1', '301', '10', '2018-03-06 23:16:09', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6393', '1', '1795', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-09', '669'),
('6394', '1', '382', '10', '2018-03-06 23:16:39', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6395', '1', '1796', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-12', '674'),
('6396', '1', '384', '10', '2018-03-06 23:17:02', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6397', '1', '1797', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-19', '705'),
('6398', '1', '392', '10', '2018-03-06 23:18:03', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6399', '1', '1798', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '807'),
('6400', '1', '438', '10', '2018-03-06 23:19:05', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6401', '1', '1799', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '849'),
('6402', '1', '446', '10', '2018-03-06 23:19:29', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6403', '1', '1800', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '884'),
('6404', '1', '460', '10', '2018-03-06 23:20:10', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6405', '1', '1801', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-14', '977'),
('6406', '1', '562', '10', '2018-03-06 23:21:01', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6407', '1', '1802', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-14', '978'),
('6408', '1', '564', '10', '2018-03-06 23:21:44', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6409', '1', '1803', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '996'),
('6410', '1', '579', '10', '2018-03-06 23:22:17', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6411', '1', '1804', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-21', '1040'),
('6412', '1', '596', '10', '2018-03-06 23:34:41', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6413', '1', '1805', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1144'),
('6414', '1', '634', '10', '2018-03-06 23:35:50', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6415', '1', '1806', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-01', '1151'),
('6416', '1', '637', '10', '2018-03-06 23:36:32', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6417', '1', '1807', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1220'),
('6418', '1', '657', '10', '2018-03-06 23:37:08', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6419', '1', '1808', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-18', '1294'),
('6420', '1', '706', '10', '2018-03-06 23:38:08', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6421', '1', '1809', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-29', '1375'),
('6422', '1', '752', '10', '2018-03-06 23:39:10', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6423', '1', '1810', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1409'),
('6424', '1', '762', '10', '2018-03-06 23:39:59', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6425', '1', '1811', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-22', '1595'),
('6426', '1', '880', '10', '2018-03-06 23:40:52', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6427', '1', '1812', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-25', '1612'),
('6428', '1', '890', '10', '2018-03-06 23:44:37', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6429', '1', '1813', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-02', '1693'),
('6430', '1', '918', '10', '2018-03-06 23:45:33', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6431', '1', '1814', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-11', '1759'),
('6432', '1', '958', '10', '2018-03-06 23:48:09', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6433', '1', '1815', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-11', '1760'),
('6434', '1', '959', '10', '2018-03-06 23:49:03', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6435', '1', '1816', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1952'),
('6436', '1', '1044', '10', '2018-03-06 23:49:59', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6437', '1', '1817', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-08', '2010'),
('6438', '1', '1065', '10', '2018-03-06 23:51:36', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6439', '1', '1818', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-14', '2070'),
('6440', '1', '1105', '10', '2018-03-06 23:52:14', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6441', '1', '1819', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-21', '2148'),
('6442', '1', '1159', '10', '2018-03-06 23:52:52', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6443', '1', '1820', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-24', '2175'),
('6444', '1', '1171', '10', '2018-03-06 23:53:30', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6445', '1', '1821', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2282'),
('6446', '1', '1196', '10', '2018-03-06 23:55:42', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6447', '1', '1822', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2283'),
('6448', '1', '1503', '10', '2018-03-06 23:56:57', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6449', '1', '1823', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-07', '2352'),
('6450', '1', '1236', '10', '2018-03-06 23:57:38', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6451', '1', '1824', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-27', '2500'),
('6452', '1', '1409', '10', '2018-03-06 23:58:25', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6453', '1', '1825', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-12', '2627'),
('6454', '1', '1517', '10', '2018-03-06 23:59:35', 'Voided.\nDocument reentered.', '3', '2018-03-06', '0'),
('6455', '1', '1826', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2804'),
('6456', '1', '1637', '10', '2018-03-07 00:02:08', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6457', '1', '1827', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2887'),
('6458', '1', '1699', '10', '2018-03-07 00:02:44', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6459', '1', '1828', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-20', '2954'),
('6460', '1', '1716', '10', '2018-03-07 00:03:21', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6461', '1', '1829', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '127'),
('6462', '1', '479', '10', '2018-03-07 00:05:40', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6463', '1', '1830', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-12', '138'),
('6464', '1', '136', '10', '2018-03-07 00:06:12', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6465', '1', '1831', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-21', '183'),
('6466', '1', '130', '10', '2018-03-07 00:07:08', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6467', '1', '1832', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '342'),
('6468', '1', '199', '10', '2018-03-07 00:07:57', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6469', '1', '1833', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-22', '467'),
('6470', '1', '265', '10', '2018-03-07 00:08:32', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6471', '1', '1834', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-23', '475'),
('6472', '1', '271', '10', '2018-03-07 00:08:58', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6473', '1', '1835', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '885'),
('6474', '1', '459', '10', '2018-03-07 00:09:49', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6475', '1', '1836', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-14', '979'),
('6476', '1', '563', '10', '2018-03-07 00:10:22', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6477', '1', '1837', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-02', '1166'),
('6478', '1', '641', '10', '2018-03-07 00:10:59', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6479', '1', '1838', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-10', '1241'),
('6480', '1', '673', '10', '2018-03-07 00:11:29', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6481', '1', '1839', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '610'),
('6482', '1', '311', '10', '2018-03-07 00:12:18', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6483', '1', '1840', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-28', '1367'),
('6484', '1', '740', '10', '2018-03-07 00:12:55', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6485', '1', '1841', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-30', '1387'),
('6486', '1', '756', '10', '2018-03-07 00:13:56', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6487', '1', '1842', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-12', '1496'),
('6488', '1', '807', '10', '2018-03-07 00:14:31', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6489', '1', '1843', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-18', '1545'),
('6490', '1', '854', '10', '2018-03-07 00:18:23', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6491', '1', '1844', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-20', '1567'),
('6492', '1', '869', '10', '2018-03-07 00:18:49', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6493', '1', '1845', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-09', '1739'),
('6494', '1', '954', '10', '2018-03-07 00:19:54', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6495', '1', '1846', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1953'),
('6496', '1', '1042', '10', '2018-03-07 00:20:47', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6497', '1', '1847', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-06', '1995'),
('6498', '1', '1061', '10', '2018-03-07 00:21:33', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6499', '1', '1848', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2102'),
('6500', '1', '1128', '10', '2018-03-07 00:23:11', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6501', '1', '1849', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-06', '2836'),
('6502', '1', '1653', '10', '2018-03-07 00:23:41', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6503', '1', '1850', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-20', '2955'),
('6504', '1', '1717', '10', '2018-03-07 00:24:18', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6505', '1', '1851', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3050'),
('6506', '1', '1763', '10', '2018-03-07 00:24:51', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6507', '1', '1852', '10', '2018-03-07 04:44:24', NULL, '3', '2018-03-06', NULL),
('6508', '1', '1781', '10', '2018-03-07 00:25:21', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6509', '1', '1853', '10', '2018-03-07 00:33:34', NULL, '3', '2017-04-26', NULL),
('6510', '1', '1787', '10', '2018-03-07 00:32:02', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6511', '1', '1854', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-26', '224'),
('6512', '1', '1853', '10', '2018-03-07 00:33:34', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6513', '1', '1855', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-30', '290'),
('6514', '1', '263', '10', '2018-03-07 00:42:18', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6515', '1', '1856', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-04', '343'),
('6516', '1', '192', '10', '2018-03-07 00:46:13', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6517', '1', '1857', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-14', '681'),
('6518', '1', '592', '10', '2018-03-07 00:47:30', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6519', '1', '1858', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-21', '725'),
('6520', '1', '445', '10', '2018-03-07 00:50:17', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6521', '1', '1859', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '850'),
('6522', '1', '593', '10', '2018-03-07 00:51:18', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6523', '1', '1860', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-05', '900'),
('6524', '1', '468', '10', '2018-03-07 00:54:55', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6525', '1', '1861', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1145'),
('6526', '1', '690', '10', '2018-03-07 00:55:37', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6527', '1', '1862', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-10', '1242'),
('6528', '1', '675', '10', '2018-03-07 01:00:25', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6529', '1', '1863', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-14', '1510'),
('6530', '1', '843', '10', '2018-03-07 01:04:08', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6531', '1', '1864', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-18', '1546'),
('6532', '1', '859', '10', '2018-03-07 01:04:44', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6533', '1', '1865', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-19', '1813'),
('6534', '1', '991', '10', '2018-03-07 01:07:36', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6535', '1', '1866', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-14', '2071'),
('6536', '1', '1121', '10', '2018-03-07 01:10:32', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6537', '1', '1867', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-15', '2103'),
('6538', '1', '1133', '10', '2018-03-07 01:18:45', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6539', '1', '1868', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2390'),
('6540', '1', '1391', '10', '2018-03-07 01:19:50', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6541', '1', '1869', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-12', '2391'),
('6542', '1', '1389', '10', '2018-03-07 01:20:30', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6543', '1', '1870', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-14', '2415'),
('6544', '1', '1302', '10', '2018-03-07 01:25:06', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6545', '1', '1871', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-16', '2656'),
('6546', '1', '1531', '10', '2018-03-07 01:28:31', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6547', '1', '1872', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-29', '2774'),
('6548', '1', '1602', '10', '2018-03-07 02:10:38', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6549', '1', '1873', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2888'),
('6550', '1', '1697', '10', '2018-03-07 02:13:15', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6551', '1', '1874', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2889'),
('6552', '1', '1706', '10', '2018-03-07 02:13:45', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6553', '1', '1875', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-07', '3109'),
('6554', '1', '1876', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-07', '3110'),
('6555', '1', '1877', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-07', '3111'),
('6556', '1', '1878', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-07', '3112'),
('6557', '1', '1879', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3105'),
('6558', '1', '1852', '10', '2018-03-07 04:44:24', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6559', '1', '1880', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3106'),
('6560', '1', '1782', '10', '2018-03-07 21:40:03', 'Voided.\nDocument reentered.', '3', '2018-03-07', '0'),
('6561', '1', '1881', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-08', '3116'),
('6562', '30', '917', '10', '2018-03-08 00:26:05', NULL, '3', '2017-12-27', '0'),
('6563', '13', '917', '10', '2018-03-08 00:26:05', NULL, '3', '2017-12-27', '0'),
('6564', '10', '907', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-27', '2501'),
('6565', '30', '918', '10', '2018-03-08 00:26:56', NULL, '3', '2017-12-29', '0'),
('6566', '13', '918', '10', '2018-03-08 00:26:56', NULL, '3', '2017-12-29', '0'),
('6567', '10', '908', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-29', '2512'),
('6568', '30', '919', '10', '2018-03-08 00:27:46', NULL, '3', '2017-12-29', '0'),
('6569', '13', '919', '10', '2018-03-08 00:27:46', NULL, '3', '2017-12-29', '0'),
('6570', '10', '909', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-29', '2513'),
('6571', '30', '920', '10', '2018-03-08 00:28:29', NULL, '3', '2017-12-29', '0'),
('6572', '13', '920', '10', '2018-03-08 00:28:29', NULL, '3', '2017-12-29', '0'),
('6573', '10', '910', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-29', '2514'),
('6574', '30', '921', '10', '2018-03-08 00:29:20', NULL, '3', '2017-12-31', '0'),
('6575', '13', '921', '10', '2018-03-08 00:29:20', NULL, '3', '2017-12-31', '0'),
('6576', '10', '911', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-31', '2524'),
('6577', '30', '922', '10', '2018-03-08 00:30:31', NULL, '3', '2018-01-08', '0'),
('6578', '13', '922', '10', '2018-03-08 00:30:31', NULL, '3', '2018-01-08', '0'),
('6579', '10', '912', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-08', '2589'),
('6580', '30', '923', '10', '2018-03-08 00:31:13', NULL, '3', '2018-01-10', '0'),
('6581', '13', '923', '10', '2018-03-08 00:31:13', NULL, '3', '2018-01-10', '0'),
('6582', '10', '913', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-10', '2606'),
('6583', '30', '924', '10', '2018-03-08 00:32:03', NULL, '3', '2018-01-15', '0'),
('6584', '13', '924', '10', '2018-03-08 00:32:03', NULL, '3', '2018-01-15', '0'),
('6585', '10', '914', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-15', '2636'),
('6586', '30', '925', '10', '2018-03-08 00:33:22', NULL, '3', '2018-01-23', '0'),
('6587', '13', '925', '10', '2018-03-08 00:33:22', NULL, '3', '2018-01-23', '0'),
('6588', '10', '915', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-23', '2712'),
('6589', '30', '926', '10', '2018-03-08 00:34:29', NULL, '3', '2018-02-02', '0'),
('6590', '13', '926', '10', '2018-03-08 00:34:29', NULL, '3', '2018-02-02', '0'),
('6591', '10', '916', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-02', '2816'),
('6592', '30', '927', '10', '2018-03-08 00:35:06', NULL, '3', '2018-02-05', '0'),
('6593', '13', '927', '10', '2018-03-08 00:35:06', NULL, '3', '2018-02-05', '0'),
('6594', '10', '917', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-05', '2824'),
('6595', '30', '928', '10', '2018-03-08 00:39:48', NULL, '3', '2018-02-06', '0'),
('6596', '13', '928', '10', '2018-03-08 00:39:48', NULL, '3', '2018-02-06', '0'),
('6597', '10', '918', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-06', '2837'),
('6598', '30', '929', '10', '2018-03-08 00:40:43', NULL, '3', '2018-02-06', '0'),
('6599', '13', '929', '10', '2018-03-08 00:40:43', NULL, '3', '2018-02-06', '0'),
('6600', '10', '919', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-06', '2838'),
('6601', '30', '930', '10', '2018-03-08 00:41:28', NULL, '3', '2018-02-09', '0'),
('6602', '13', '930', '10', '2018-03-08 00:41:28', NULL, '3', '2018-02-09', '0'),
('6603', '10', '920', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-09', '2866'),
('6604', '30', '931', '10', '2018-03-08 00:42:37', NULL, '3', '2018-02-12', '0'),
('6605', '13', '931', '10', '2018-03-08 00:42:37', NULL, '3', '2018-02-12', '0'),
('6606', '10', '921', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-12', '2871'),
('6607', '12', '528', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-23', '3223'),
('6608', '1', '1882', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-08', '3117'),
('6609', '1', '1883', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-08', '3118'),
('6610', '30', '932', '10', '2018-03-08 02:45:59', NULL, '3', '2018-02-28', '0'),
('6611', '13', '932', '10', '2018-03-08 02:46:00', NULL, '3', '2018-02-28', '0'),
('6612', '10', '922', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3051'),
('6613', '1', '1884', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-08', '3119'),
('6614', '1', '1885', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-08', '3120'),
('6615', '1', '1886', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-08', '3121'),
('6616', '12', '529', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-14', '1263'),
('6617', '1', '1887', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-09', '3124'),
('6618', '1', '1888', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-09', '3125'),
('6619', '1', '1889', '10', '2018-03-19 10:36:34', NULL, '3', '2018-03-09', NULL),
('6620', '1', '1890', '10', '2018-03-19 11:10:25', NULL, '3', '2018-03-09', NULL),
('6621', '1', '1891', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-09', '3126'),
('6622', '1', '1892', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-09', '3127'),
('6623', '1', '1893', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-09', '3128'),
('6624', '1', '1894', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-09', '3129'),
('6625', '1', '1895', '10', '2018-03-14 01:53:52', NULL, '3', '2018-02-27', NULL),
('6626', '1', '1896', '10', '2018-03-14 01:54:13', NULL, '3', '2018-02-27', NULL),
('6627', '1', '1897', '10', '2018-03-14 01:53:57', NULL, '3', '2018-02-27', NULL),
('6628', '1', '1898', '10', '2018-03-14 01:54:18', NULL, '3', '2018-02-27', NULL),
('6629', '1', '1899', '10', '2018-03-14 01:54:25', NULL, '3', '2018-02-27', NULL),
('6630', '1', '1900', '10', '2018-03-14 01:54:34', NULL, '3', '2018-02-27', NULL),
('6631', '0', '34', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3052'),
('6632', '0', '35', '10', '2018-03-09 05:25:35', NULL, '3', '2018-02-28', NULL),
('6633', '0', '35', '10', '2018-03-09 05:25:35', 'Voided.\nDocument reentered.', '3', '2018-03-09', '0'),
('6634', '0', '36', '10', '2018-03-09 05:27:11', NULL, '3', '2018-02-28', NULL),
('6635', '0', '36', '10', '2018-03-09 05:27:11', 'Voided.\nDocument reentered.', '3', '2018-03-09', '0'),
('6636', '0', '37', '10', '2018-03-09 05:31:57', NULL, '3', '2018-02-28', NULL),
('6637', '0', '37', '10', '2018-03-09 05:31:57', 'Voided.\n', '3', '2018-03-09', '0'),
('6638', '0', '38', '10', '2018-03-09 05:54:58', NULL, '3', '2018-02-28', NULL),
('6639', '0', '38', '10', '2018-03-09 05:54:58', 'Voided.\nDocument reentered.', '3', '2018-03-09', '0'),
('6640', '0', '39', '10', '2018-03-09 05:56:16', NULL, '3', '2018-02-28', NULL),
('6641', '0', '39', '10', '2018-03-09 05:56:16', 'Voided.\nDocument reentered.', '3', '2018-03-09', '0'),
('6642', '0', '40', '10', '2018-03-09 06:03:21', NULL, '3', '2018-02-28', NULL),
('6643', '0', '40', '10', '2018-03-09 06:03:21', 'Voided.\nDocument reentered.', '3', '2018-03-09', '0'),
('6644', '0', '41', '10', '2018-03-16 07:07:22', NULL, '3', '2018-02-28', NULL),
('6645', '0', '42', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-31', '2790'),
('6646', '0', '43', '10', '2018-03-11 22:55:10', NULL, '3', '2018-01-31', NULL),
('6647', '0', '43', '10', '2018-03-11 22:55:10', 'Voided.\nDocument reentered.', '3', '2018-03-11', '0'),
('6648', '0', '44', '10', '2018-03-16 07:06:37', NULL, '3', '2018-01-31', NULL),
('6649', '0', '45', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-31', '2525'),
('6650', '0', '46', '10', '2018-03-16 07:05:48', NULL, '3', '2017-12-31', NULL),
('6651', '0', '47', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2284'),
('6652', '0', '48', '10', '2018-03-11 23:49:40', NULL, '3', '2017-11-30', NULL),
('6653', '0', '48', '10', '2018-03-11 23:49:40', 'Voided.\nDocument reentered.', '3', '2018-03-11', '0'),
('6654', '0', '49', '10', '2018-03-11 23:51:25', NULL, '3', '2017-11-30', NULL),
('6655', '0', '49', '10', '2018-03-11 23:51:25', 'Voided.\nDocument reentered.', '3', '2018-03-11', '0'),
('6656', '0', '50', '10', '2018-03-16 07:04:31', NULL, '3', '2017-11-30', NULL),
('6657', '0', '51', '10', '2018-08-08 08:17:53', NULL, '5', '2017-10-31', NULL),
('6658', '0', '52', '10', '2018-03-16 07:03:09', NULL, '3', '2017-10-31', NULL),
('6659', '0', '53', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-30', '1689'),
('6660', '0', '54', '10', '2018-03-16 07:01:47', NULL, '3', '2017-09-30', NULL),
('6661', '0', '55', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1410'),
('6662', '0', '56', '10', '2018-03-12 00:51:08', NULL, '3', '2017-08-31', NULL),
('6663', '0', '56', '10', '2018-03-12 00:51:08', 'Voided.\nDocument reentered.', '3', '2018-03-12', '0'),
('6664', '0', '57', '10', '2018-03-12 00:56:17', NULL, '3', '2017-08-31', NULL),
('6665', '0', '57', '10', '2018-03-12 00:56:17', 'Voided.\nDocument reentered.', '3', '2018-03-12', '0'),
('6666', '0', '58', '10', '2018-03-12 00:58:24', NULL, '3', '2017-08-31', NULL),
('6667', '0', '58', '10', '2018-03-12 00:58:24', 'Voided.\nDocument reentered.', '3', '2018-03-12', '0'),
('6668', '0', '59', '10', '2018-03-16 07:00:28', NULL, '3', '2017-08-31', NULL),
('6669', '1', '1901', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-12', '3133'),
('6670', '1', '1902', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-12', '3134'),
('6671', '1', '1903', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-12', '3135'),
('6672', '0', '60', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1146'),
('6673', '0', '61', '10', '2018-03-16 06:59:21', NULL, '3', '2017-07-31', NULL),
('6674', '0', '62', '10', '2018-03-12 05:47:11', NULL, '3', '2017-06-30', NULL),
('6675', '12', '530', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-12', '3136'),
('6676', '1', '1904', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-12', '3137'),
('6677', '1', '1905', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-12', '3138'),
('6678', '1', '1906', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-12', '3139'),
('6679', '1', '1907', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-12', '3140'),
('6680', '0', '63', '10', '2018-03-12 05:51:05', NULL, '3', '2017-06-30', NULL),
('6681', '0', '64', '10', '2018-03-12 04:38:52', NULL, '3', '2017-05-31', NULL),
('6682', '0', '65', '10', '2018-03-12 04:41:25', NULL, '3', '2017-05-31', NULL),
('6683', '0', '64', '10', '2018-03-12 04:38:52', 'Voided.\nDocument reentered.', '3', '2018-03-12', '0'),
('6684', '0', '66', '10', '2018-03-12 05:31:50', NULL, '3', '2017-04-30', NULL);
INSERT INTO `0_audit_trail` VALUES
('6685', '0', '65', '10', '2018-03-12 04:41:25', 'Voided.\nDocument reentered.', '3', '2018-03-12', '0'),
('6686', '0', '67', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-30', '291'),
('6687', '0', '68', '10', '2018-03-12 05:35:05', NULL, '3', '2017-05-31', NULL),
('6688', '0', '69', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '580'),
('6689', '30', '933', '10', '2018-03-12 05:13:29', NULL, '3', '2017-12-31', '0'),
('6690', '13', '933', '10', '2018-03-12 05:13:29', NULL, '3', '2017-12-31', '0'),
('6691', '10', '923', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-31', '2526'),
('6692', '1', '1908', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-12', '3141'),
('6693', '1', '1909', '10', '2018-03-12 05:27:45', NULL, '3', '2018-03-12', NULL),
('6694', '1', '1910', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-12', '3142'),
('6695', '1', '1909', '10', '2018-03-12 05:27:45', 'Voided.\nDocument reentered.', '3', '2018-03-12', '0'),
('6696', '0', '66', '10', '2018-03-12 05:31:50', 'Voided.\nDocument reentered.', '3', '2018-03-12', '0'),
('6697', '0', '70', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-30', '292'),
('6698', '0', '68', '10', '2018-03-12 05:35:05', 'Voided.\nDocument reentered.', '3', '2018-03-12', '0'),
('6699', '0', '71', '10', '2018-03-12 05:38:51', NULL, '3', '2017-05-31', NULL),
('6700', '0', '71', '10', '2018-03-12 05:38:51', 'Voided.\nDocument reentered.', '3', '2018-03-12', '0'),
('6701', '0', '72', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-31', '581'),
('6702', '0', '62', '10', '2018-03-12 05:47:11', 'Voided.\nDocument reentered.', '3', '2018-03-12', '0'),
('6703', '0', '73', '10', '2018-03-12 05:47:59', NULL, '3', '2017-06-30', NULL),
('6704', '0', '73', '10', '2018-03-12 05:47:59', 'Voided.\nDocument reentered.', '3', '2018-03-12', '0'),
('6705', '0', '74', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '851'),
('6706', '0', '63', '10', '2018-03-12 05:51:05', 'Voided.\nDocument reentered.', '3', '2018-03-12', '0'),
('6707', '0', '75', '10', '2018-03-16 06:58:09', NULL, '3', '2017-06-30', NULL),
('6708', '20', '96', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3015'),
('6709', '20', '97', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-08', '2858'),
('6710', '22', '37', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-12', '3143'),
('6711', '30', '934', '10', '2018-03-12 06:27:57', NULL, '3', '2018-01-25', '0'),
('6712', '13', '934', '10', '2018-03-12 06:27:57', NULL, '3', '2018-01-25', '0'),
('6713', '10', '924', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-25', '2736'),
('6714', '12', '531', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-12', '3144'),
('6715', '30', '935', '10', '2018-03-12 06:30:04', NULL, '3', '2018-01-25', '0'),
('6716', '13', '935', '10', '2018-03-12 06:30:04', NULL, '3', '2018-01-25', '0'),
('6717', '10', '925', '10', '2018-03-16 06:48:38', NULL, '3', '2018-01-25', NULL),
('6718', '12', '532', '10', '2018-03-16 06:48:50', NULL, '3', '2018-03-12', NULL),
('6719', '30', '936', '10', '2018-03-12 06:33:36', NULL, '3', '2018-03-05', '0'),
('6720', '13', '936', '10', '2018-03-12 06:33:36', NULL, '3', '2018-03-05', '0'),
('6721', '10', '926', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-05', '3084'),
('6722', '12', '533', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-12', '3145'),
('6723', '30', '937', '10', '2018-03-12 06:52:35', NULL, '3', '2018-02-28', '0'),
('6724', '13', '937', '10', '2018-03-12 06:52:35', NULL, '3', '2018-02-28', '0'),
('6725', '10', '927', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3053'),
('6726', '1', '1911', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3148'),
('6727', '1', '1912', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3149'),
('6728', '1', '1913', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3150'),
('6729', '1', '1914', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3151'),
('6730', '1', '1915', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3152'),
('6731', '1', '1916', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3153'),
('6732', '1', '1917', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3154'),
('6733', '1', '1918', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3155'),
('6734', '1', '1919', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-15', '688'),
('6735', '1', '1920', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-16', '694'),
('6736', '1', '1921', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-20', '715'),
('6737', '1', '1922', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-22', '735'),
('6738', '1', '1923', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-22', '736'),
('6739', '1', '1924', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-29', '820'),
('6740', '1', '1925', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-29', '821'),
('6741', '1', '1926', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '886'),
('6742', '1', '1927', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '887'),
('6743', '1', '1928', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '888'),
('6744', '1', '1929', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-04', '889'),
('6745', '1', '1930', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-11', '949'),
('6746', '1', '1931', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-11', '950'),
('6747', '1', '1932', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3156'),
('6748', '1', '1933', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-11', '951'),
('6749', '1', '1934', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-12', '964'),
('6750', '1', '1935', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-12', '965'),
('6751', '1', '1936', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-12', '966'),
('6752', '1', '1937', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-17', '997'),
('6753', '1', '1938', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-25', '1076'),
('6754', '1', '1939', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-26', '1086'),
('6755', '1', '1940', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1188'),
('6756', '1', '1941', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1189'),
('6757', '1', '1942', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1190'),
('6758', '1', '1943', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1191'),
('6759', '1', '1944', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1192'),
('6760', '1', '1945', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1193'),
('6761', '1', '1946', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1194'),
('6762', '1', '1947', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-03', '1195'),
('6763', '1', '1948', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-30', '1388'),
('6764', '1', '1949', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-06', '1444'),
('6765', '1', '1950', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-04', '1432'),
('6766', '1', '1951', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1530'),
('6767', '1', '1952', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-15', '1531'),
('6768', '1', '1953', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-19', '1558'),
('6769', '1', '1954', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-19', '1559'),
('6770', '1', '1955', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-20', '1568'),
('6771', '1', '1956', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-20', '1569'),
('6772', '1', '1957', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-20', '1570'),
('6773', '1', '1958', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-20', '1571'),
('6774', '1', '1959', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-26', '1625'),
('6775', '1', '1960', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-26', '1626'),
('6776', '1', '1961', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-26', '1627'),
('6777', '1', '1962', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-25', '1613'),
('6778', '1', '1963', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-27', '1647'),
('6779', '1', '1964', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-28', '1664'),
('6780', '1', '1965', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-04', '1718'),
('6781', '1', '1966', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-02', '1694'),
('6782', '1', '1967', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-06', '1730'),
('6783', '1', '1968', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-06', '1731'),
('6784', '1', '1969', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-06', '1732'),
('6785', '1', '1970', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-06', '1733'),
('6786', '1', '1971', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-09', '1740'),
('6787', '1', '1972', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-09', '1741'),
('6788', '1', '1973', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-09', '1742'),
('6789', '1', '1974', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-16', '1795'),
('6790', '1', '1975', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-19', '1814'),
('6791', '1', '1976', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-19', '1815'),
('6792', '1', '1977', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-24', '1867'),
('6793', '1', '1978', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-24', '1868'),
('6794', '1', '1979', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-24', '1869'),
('6795', '1', '1980', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-24', '1870'),
('6796', '1', '1981', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-27', '1915'),
('6797', '1', '1982', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1954'),
('6798', '1', '1983', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-01', '1964'),
('6799', '1', '1984', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-01', '1965'),
('6800', '1', '1985', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-06', '1996'),
('6801', '1', '1986', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1955'),
('6802', '1', '1987', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-07', '2001'),
('6803', '1', '1988', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-08', '2011'),
('6804', '1', '1989', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-08', '2012'),
('6805', '1', '1990', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-13', '2057'),
('6806', '1', '1991', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-13', '2058'),
('6807', '1', '1992', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-13', '2059'),
('6808', '1', '1993', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-16', '2118'),
('6809', '1', '1994', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-16', '2119'),
('6810', '1', '1995', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2133'),
('6811', '1', '1996', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2134'),
('6812', '1', '1997', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2135'),
('6813', '1', '1998', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2136'),
('6814', '1', '1999', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2137'),
('6815', '1', '2000', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-17', '2138'),
('6816', '1', '2001', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2200'),
('6817', '1', '2002', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2223'),
('6818', '1', '2003', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-28', '2224'),
('6819', '1', '2004', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2285'),
('6820', '1', '2005', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2286'),
('6821', '1', '2006', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-06', '2340'),
('6822', '1', '2007', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-06', '2341'),
('6823', '10', '830', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-04-21', '184'),
('6824', '12', '425', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-04-24', '202'),
('6825', '10', '837', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-02', '303'),
('6826', '12', '433', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-02', '304'),
('6827', '10', '838', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-25', '506'),
('6828', '12', '432', '10', '2018-03-16 09:34:30', 'Updated.', '3', '2017-05-26', NULL),
('6829', '10', '840', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-29', '822'),
('6830', '10', '841', '10', '2018-08-06 06:11:35', 'Updated.', '5', '2017-08-08', NULL),
('6831', '10', '842', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-05', '1433'),
('6832', '10', '843', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-26', '1628'),
('6833', '12', '436', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-30', '852'),
('6834', '12', '438', '10', '2018-07-26 05:28:06', 'Updated.', '3', '2017-08-09', NULL),
('6835', '12', '439', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-06', '1445'),
('6836', '12', '440', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-27', '1648'),
('6837', '10', '831', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-23', '476'),
('6838', '10', '832', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-21', '726'),
('6839', '10', '833', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-21', '1041'),
('6840', '10', '834', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-08-22', '1318'),
('6841', '10', '835', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-20', '1572'),
('6842', '10', '836', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-10-20', '1842'),
('6843', '12', '426', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-24', '491'),
('6844', '12', '427', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-22', '737'),
('6845', '12', '428', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-24', '1063'),
('6846', '12', '429', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-08-23', '1326'),
('6847', '12', '430', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-21', '1579'),
('6848', '12', '431', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-10-23', '1856'),
('6849', '12', '442', '10', '2018-03-13 23:13:59', 'Updated.', '3', '2017-11-24', NULL),
('6850', '10', '862', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-23', '2162'),
('6851', '12', '442', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-24', '2176'),
('6852', '10', '355', '10', '2018-03-13 23:27:01', 'Updated.', '3', '2017-05-08', NULL),
('6853', '12', '85', '10', '2018-03-13 23:27:14', 'Updated.', '3', '2017-05-18', NULL),
('6854', '10', '355', '10', '2018-03-13 23:29:32', 'Updated.', '3', '2017-05-08', NULL),
('6855', '12', '85', '10', '2018-03-13 23:29:44', 'Updated.', '3', '2017-05-18', NULL),
('6856', '10', '355', '10', '2018-03-17 04:13:05', 'Updated.', '3', '2017-05-08', NULL),
('6857', '12', '85', '10', '2018-03-28 02:07:44', 'Updated.', '3', '2017-05-18', NULL),
('6858', '10', '523', '10', '2018-03-17 04:22:05', 'Updated.', '3', '2017-06-30', NULL),
('6859', '12', '188', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-18', '1004'),
('6860', '1', '2008', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-04', '2818'),
('6861', '1', '2009', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-07', '2851'),
('6862', '1', '2010', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-09', '2867'),
('6863', '1', '2011', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-09', '2868'),
('6864', '1', '2012', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-09', '2869'),
('6865', '1', '2013', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-14', '2896'),
('6866', '1', '2014', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-14', '2897'),
('6867', '1', '2015', '10', '2018-03-14 01:48:47', NULL, '3', '2018-02-14', NULL),
('6868', '1', '2016', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3016'),
('6869', '1', '2017', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3017'),
('6870', '1', '2018', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3018'),
('6871', '1', '2019', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3034'),
('6872', '1', '2020', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3054'),
('6873', '1', '2021', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3055'),
('6874', '1', '2022', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3056'),
('6875', '1', '2023', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3057'),
('6876', '1', '2024', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3058'),
('6877', '1', '2025', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3059'),
('6878', '1', '2026', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3060'),
('6879', '30', '938', '10', '2018-03-14 01:10:22', NULL, '3', '2018-02-01', '0'),
('6880', '13', '938', '10', '2018-03-14 01:10:22', NULL, '3', '2018-02-01', '0'),
('6881', '10', '928', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2805'),
('6882', '12', '534', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-02', '2817'),
('6883', '30', '939', '10', '2018-03-14 01:11:12', NULL, '3', '2018-02-13', '0'),
('6884', '13', '939', '10', '2018-03-14 01:11:12', NULL, '3', '2018-02-13', '0'),
('6885', '10', '929', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2890'),
('6886', '12', '535', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2891'),
('6887', '2', '98', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-12', '2872'),
('6888', '30', '940', '10', '2018-03-14 01:13:51', NULL, '3', '2018-02-12', '0'),
('6889', '13', '940', '10', '2018-03-14 01:13:51', NULL, '3', '2018-02-12', '0'),
('6890', '10', '930', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-12', '2873'),
('6891', '12', '536', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-12', '2874'),
('6892', '4', '91', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-14', '2898'),
('6893', '30', '941', '10', '2018-03-14 01:17:10', NULL, '3', '2018-02-21', '0'),
('6894', '13', '941', '10', '2018-03-14 01:17:10', NULL, '3', '2018-02-21', '0'),
('6895', '10', '931', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-21', '2967'),
('6896', '12', '537', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-21', '2968'),
('6897', '4', '92', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3035'),
('6898', '30', '942', '10', '2018-03-14 01:34:47', NULL, '3', '2018-02-07', '0'),
('6899', '13', '942', '10', '2018-03-14 01:34:47', NULL, '3', '2018-02-07', '0'),
('6900', '10', '932', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-07', '2852'),
('6901', '12', '538', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3036'),
('6902', '1', '2027', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-20', '2956'),
('6903', '1', '2028', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-14', '2899'),
('6904', '1', '2015', '10', '2018-03-14 01:48:47', 'Voided.\nDocument reentered.', '3', '2018-03-14', '0'),
('6905', '1', '2029', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3019'),
('6906', '1', '1756', '10', '2018-03-14 01:52:38', 'Voided.\nDocument reentered.', '3', '2018-03-14', '0'),
('6907', '1', '1895', '10', '2018-03-14 01:53:52', 'Voided.\n', '3', '2018-03-14', '0'),
('6908', '1', '1897', '10', '2018-03-14 01:53:57', 'Voided.\n', '3', '2018-03-14', '0'),
('6909', '1', '1896', '10', '2018-03-14 01:54:13', 'Voided.\n', '3', '2018-03-14', '0'),
('6910', '1', '1898', '10', '2018-03-14 01:54:18', 'Voided.\n', '3', '2018-03-14', '0'),
('6911', '1', '1899', '10', '2018-03-14 01:54:25', 'Voided.\n', '3', '2018-03-14', '0'),
('6912', '1', '1900', '10', '2018-03-14 01:54:34', 'Voided.\n', '3', '2018-03-14', '0'),
('6913', '1', '1712', '10', '2018-03-14 02:00:30', 'Voided.\n', '3', '2018-03-14', '0'),
('6914', '1', '2030', '10', '2018-03-19 09:47:03', NULL, '3', '2018-01-26', NULL),
('6915', '1', '1605', '10', '2018-03-14 04:26:21', 'Voided.\nDocument reentered.', '3', '2018-03-14', '0'),
('6916', '1', '2031', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-13', '2892'),
('6917', '1', '1694', '10', '2018-03-14 04:27:54', 'Voided.\nDocument reentered.', '3', '2018-03-14', '0'),
('6918', '1', '2032', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-14', '3165'),
('6919', '0', '76', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '499'),
('6920', '0', '77', '10', '2018-03-14 23:35:49', NULL, '3', '2017-03-31', NULL),
('6921', '0', '77', '10', '2018-03-14 23:35:49', 'Voided.\n', '3', '2018-03-14', '0'),
('6922', '0', '78', '10', '2018-03-15 05:12:11', NULL, '3', '2017-03-31', NULL),
('6923', '1', '2033', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-05', '353'),
('6924', '1', '2034', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-08', '2354'),
('6925', '1', '2035', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-09', '2359'),
('6926', '1', '2036', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-11', '2370'),
('6927', '1', '2037', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-11', '2371'),
('6928', '1', '2038', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-11', '2372'),
('6929', '1', '2039', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-15', '2429'),
('6930', '1', '2040', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-18', '2436'),
('6931', '1', '2041', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-18', '2437'),
('6932', '1', '2042', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-18', '2438'),
('6933', '1', '2043', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-18', '2439'),
('6934', '1', '2044', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-20', '2456'),
('6935', '1', '2045', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-19', '2445'),
('6936', '1', '2046', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-22', '2483'),
('6937', '1', '2047', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-02', '2560'),
('6938', '1', '2048', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-04', '2575'),
('6939', '1', '2049', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-05', '2585'),
('6940', '1', '2050', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-05', '2586'),
('6941', '1', '2051', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-11', '2611'),
('6942', '1', '2052', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-11', '2612'),
('6943', '1', '2053', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-11', '2613'),
('6944', '1', '2054', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-12', '2628'),
('6945', '1', '2055', '10', '2018-08-08 08:30:21', NULL, '5', '2018-01-15', NULL),
('6946', '1', '2056', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-17', '2666'),
('6947', '1', '2057', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-17', '2667'),
('6948', '1', '2058', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-17', '2668'),
('6949', '1', '2059', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-22', '2695'),
('6950', '1', '2060', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-22', '2696'),
('6951', '1', '2061', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-22', '2697'),
('6952', '1', '2062', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-22', '2698'),
('6953', '1', '2063', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-22', '2699'),
('6954', '1', '2064', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-23', '2713'),
('6955', '1', '2065', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-24', '2725'),
('6956', '1', '2066', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-24', '2726'),
('6957', '1', '2067', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-29', '2775'),
('6958', '1', '2068', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-29', '2776'),
('6959', '1', '2069', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-05', '2825'),
('6960', '1', '2070', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-12', '2875'),
('6961', '1', '2071', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-12', '2876'),
('6962', '1', '2072', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-14', '2900'),
('6963', '4', '93', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-09', '2599'),
('6964', '1', '2073', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-15', '3175'),
('6965', '1', '2074', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-15', '3176'),
('6966', '0', '79', '10', '2018-03-15 05:14:41', NULL, '3', '2017-03-31', NULL),
('6967', '0', '78', '10', '2018-03-15 05:12:11', 'Voided.\nDocument reentered.', '3', '2018-03-15', '0'),
('6968', '0', '80', '10', '2018-03-15 05:15:54', NULL, '3', '2017-03-31', NULL),
('6969', '0', '79', '10', '2018-03-15 05:14:41', 'Voided.\nDocument reentered.', '3', '2018-03-15', '0'),
('6970', '0', '81', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '500'),
('6971', '0', '80', '10', '2018-03-15 05:15:54', 'Voided.\nDocument reentered.', '3', '2018-03-15', '0'),
('6972', '0', '82', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '501'),
('6973', '0', '83', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '502'),
('6974', '1', '2075', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-15', '3177'),
('6975', '1', '2076', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-16', '3178'),
('6976', '1', '2077', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-16', '3179'),
('6977', '1', '2078', '10', '2018-08-03 01:37:10', NULL, '5', '2018-03-16', NULL),
('6978', '1', '2079', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-16', '3180'),
('6979', '10', '893', '10', '2018-03-16 06:31:42', 'Updated.', '3', '2018-02-06', NULL),
('6980', '12', '290', '10', '2020-01-03 01:14:34', 'Updated.', '6', '2017-10-02', NULL),
('6981', '12', '290', '10', '2020-01-03 01:14:34', 'Updated.', '6', '2017-10-02', NULL),
('6982', '10', '893', '10', '2018-03-19 04:39:18', 'Updated.', '3', '2018-02-06', NULL),
('6983', '10', '411', '10', '2018-03-16 10:41:42', 'Updated.', '3', '2017-04-07', NULL),
('6984', '10', '409', '10', '2018-03-16 06:36:05', 'Updated.', '3', '2017-04-05', NULL),
('6985', '10', '409', '10', '2018-03-16 10:18:17', 'Updated.', '3', '2017-04-05', NULL),
('6986', '10', '410', '10', '2018-03-16 10:18:27', 'Updated.', '3', '2017-04-05', NULL),
('6987', '2', '99', '10', '2018-03-16 06:37:04', NULL, '3', '2017-04-11', NULL),
('6988', '2', '99', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '128'),
('6989', '2', '85', '10', '2018-03-16 06:37:04', 'Voided.\nDocument reentered.', '3', '2018-03-16', '0'),
('6990', '2', '100', '10', '2018-03-16 06:37:26', NULL, '3', '2017-04-11', NULL),
('6991', '2', '100', '10', '2018-03-20 02:03:34', NULL, '3', '2017-04-11', NULL),
('6992', '2', '84', '10', '2018-03-16 06:37:26', 'Voided.\nDocument reentered.', '3', '2018-03-16', '0'),
('6993', '10', '445', '10', '2018-03-17 04:02:21', 'Updated.', '3', '2017-05-08', NULL),
('6994', '12', '132', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-06-07', '644'),
('6995', '10', '499', '10', '2018-03-17 04:50:50', 'Updated.', '3', '2017-07-06', NULL),
('6996', '10', '500', '10', '2018-03-17 04:51:07', 'Updated.', '3', '2017-07-06', NULL),
('6997', '12', '190', '10', '2018-03-20 02:07:56', 'Updated.', '3', '2017-07-20', NULL),
('6998', '12', '336', '10', '2018-03-16 06:41:32', 'Updated.', '3', '2017-11-09', NULL),
('6999', '10', '690', '10', '2018-03-19 03:47:09', 'Updated.', '3', '2017-10-12', NULL),
('7000', '10', '691', '10', '2018-03-19 03:53:53', 'Updated.', '3', '2017-10-12', NULL),
('7001', '12', '463', '10', '2018-03-20 02:26:09', 'Updated.', '3', '2018-01-19', NULL),
('7002', '12', '336', '10', '2018-03-20 02:05:33', 'Updated.', '3', '2017-11-09', NULL),
('7003', '10', '722', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-10-19', '1816'),
('7004', '12', '328', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-01', '1966'),
('7005', '10', '763', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-02', '1981'),
('7006', '10', '779', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-12-04', '2316'),
('7007', '12', '350', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-28', '2225'),
('7008', '12', '400', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-12-14', '2416'),
('7009', '10', '786', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-02', '1982'),
('7010', '12', '406', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-12-19', '2446'),
('7011', '10', '828', '10', '2018-03-19 10:24:39', 'Updated.', '3', '2018-01-09', NULL),
('7012', '10', '829', '10', '2018-03-19 10:25:38', 'Updated.', '3', '2018-01-09', NULL),
('7013', '10', '883', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-19', '2687'),
('7014', '12', '470', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-23', '2714'),
('7015', '10', '925', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-25', '2737'),
('7016', '12', '532', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-03-12', '3146'),
('7017', '10', '896', '10', '2018-03-16 06:49:33', 'Updated.', '3', '2018-02-01', NULL),
('7018', '10', '896', '10', '2018-03-19 04:36:03', 'Updated.', '3', '2018-02-01', NULL),
('7019', '12', '513', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-02-16', '2934'),
('7020', '10', '894', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-02-06', '2839'),
('7021', '10', '898', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-02-19', '2941'),
('7022', '12', '227', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-08-23', '1327'),
('7023', '12', '228', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-08-23', '1328'),
('7024', '0', '75', '10', '2018-03-16 06:58:09', 'Voided.\nDocument reentered.', '3', '2018-03-16', '0'),
('7025', '0', '84', '10', '2018-03-19 10:51:45', NULL, '3', '2017-06-30', NULL),
('7026', '0', '61', '10', '2018-03-16 06:59:21', 'Voided.\nDocument reentered.', '3', '2018-03-16', '0'),
('7027', '0', '85', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-31', '1147'),
('7028', '0', '59', '10', '2018-03-16 07:00:28', 'Voided.\nDocument reentered.', '3', '2018-03-16', '0'),
('7029', '0', '86', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-31', '1411'),
('7030', '0', '54', '10', '2018-03-16 07:01:47', 'Voided.\nDocument reentered.', '3', '2018-03-16', '0'),
('7031', '0', '87', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-30', '1690'),
('7032', '0', '52', '10', '2018-03-16 07:03:09', 'Voided.\nDocument reentered.', '3', '2018-03-16', '0'),
('7033', '0', '88', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1956'),
('7034', '0', '50', '10', '2018-03-16 07:04:31', 'Voided.\nDocument reentered.', '3', '2018-03-16', '0'),
('7035', '0', '89', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-30', '2287'),
('7036', '0', '46', '10', '2018-03-16 07:05:48', 'Voided.\nDocument reentered.', '3', '2018-03-16', '0'),
('7037', '0', '90', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-31', '2527'),
('7038', '0', '44', '10', '2018-03-16 07:06:37', 'Voided.\nDocument reentered.', '3', '2018-03-16', '0'),
('7039', '0', '91', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-31', '2791'),
('7040', '0', '41', '10', '2018-03-16 07:07:22', 'Voided.\nDocument reentered.', '3', '2018-03-16', '0'),
('7041', '0', '92', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3061'),
('7042', '12', '432', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-26', '538'),
('7043', '13', '406', '1', '2018-03-16 10:18:17', 'Voided.', '3', '2018-03-16', '0'),
('7044', '10', '409', '1', '2018-03-16 10:18:17', 'Voided.\n', '3', '2018-03-16', '0'),
('7045', '13', '407', '1', '2018-03-16 10:18:27', 'Voided.', '3', '2018-03-16', '0'),
('7046', '10', '410', '1', '2018-03-16 10:18:27', 'Voided.\n', '3', '2018-03-16', '0'),
('7047', '30', '943', '1', '2018-03-16 10:21:14', NULL, '3', '2017-05-26', '0'),
('7048', '13', '943', '1', '2018-03-16 10:21:14', NULL, '3', '2017-05-26', '0'),
('7049', '10', '933', '1', '2018-03-16 10:25:55', NULL, '3', '2017-05-26', NULL),
('7050', '10', '933', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-26', '539'),
('7051', '30', '944', '1', '2018-03-16 10:29:21', NULL, '3', '2017-05-26', '0'),
('7052', '13', '944', '1', '2018-03-16 10:29:21', NULL, '3', '2017-05-26', '0'),
('7053', '10', '934', '1', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '540'),
('7054', '13', '408', '1', '2018-03-16 10:41:42', 'Voided.', '3', '2018-03-16', '0'),
('7055', '10', '411', '1', '2018-03-16 10:41:42', 'Voided.\n', '3', '2018-03-16', '0'),
('7056', '30', '945', '1', '2018-03-16 10:44:58', NULL, '3', '2017-04-07', '0'),
('7057', '13', '945', '1', '2018-03-16 10:44:58', NULL, '3', '2017-04-07', '0'),
('7058', '10', '935', '1', '2020-01-22 05:35:44', NULL, '3', '2017-04-07', '90'),
('7059', '10', '440', '1', '2018-03-16 10:57:45', 'Updated.', '3', '2017-04-20', NULL),
('7060', '13', '437', '1', '2018-03-16 10:57:45', 'Voided.', '3', '2018-03-16', '0'),
('7061', '10', '440', '1', '2018-03-16 10:57:45', 'Voided.\n', '3', '2018-03-16', '0'),
('7062', '30', '946', '1', '2018-03-16 11:00:57', NULL, '3', '2017-04-07', '0'),
('7063', '13', '946', '1', '2018-03-16 11:00:57', NULL, '3', '2017-04-07', '0'),
('7064', '10', '936', '1', '2018-03-19 09:37:54', NULL, '3', '2017-04-07', NULL),
('7065', '30', '947', '1', '2018-03-16 11:11:48', NULL, '3', '2017-04-28', '0'),
('7066', '13', '947', '1', '2018-03-16 11:11:48', NULL, '3', '2017-04-28', '0'),
('7067', '10', '937', '1', '2020-01-22 05:35:44', NULL, '3', '2017-04-28', '282'),
('7068', '13', '364', '1', '2018-03-16 11:12:59', 'Voided.', '3', '2018-03-16', '0'),
('7069', '10', '367', '1', '2018-03-16 11:13:00', 'Voided.\n', '3', '2018-03-16', '0'),
('7070', '30', '948', '1', '2018-03-17 03:46:46', NULL, '3', '2017-05-08', '0'),
('7071', '13', '948', '1', '2018-03-17 04:00:23', NULL, '3', '2017-05-08', NULL),
('7072', '10', '938', '1', '2018-03-17 04:00:23', NULL, '3', '2017-05-08', NULL),
('7073', '30', '949', '1', '2018-03-17 03:58:42', NULL, '3', '2017-05-08', '0'),
('7074', '13', '949', '1', '2018-03-17 03:58:42', NULL, '3', '2017-05-08', '0'),
('7075', '10', '939', '1', '2020-01-22 05:35:44', NULL, '3', '2017-05-08', '367'),
('7076', '13', '948', '1', '2018-03-17 04:00:23', 'Voided.', '3', '2018-03-17', '0'),
('7077', '10', '938', '1', '2018-03-17 04:00:23', 'Voided.\n', '3', '2018-03-17', '0'),
('7078', '13', '442', '1', '2018-03-17 04:02:21', 'Voided.', '3', '2018-03-17', '0'),
('7079', '10', '445', '1', '2018-03-17 04:02:21', 'Voided.\n', '3', '2018-03-17', '0'),
('7080', '30', '950', '1', '2018-03-17 04:07:00', NULL, '3', '2017-05-08', '0'),
('7081', '13', '950', '1', '2018-03-17 04:07:01', NULL, '3', '2017-05-08', '0'),
('7082', '10', '940', '1', '2018-03-19 10:05:11', NULL, '3', '2017-05-08', NULL),
('7083', '13', '352', '1', '2018-03-17 04:13:05', 'Voided.', '3', '2018-03-17', '0'),
('7084', '10', '355', '1', '2018-03-17 04:13:05', 'Voided.\n', '3', '2018-03-17', '0'),
('7085', '30', '951', '1', '2018-03-17 04:18:05', NULL, '3', '2017-06-28', '0'),
('7086', '13', '951', '1', '2018-03-17 04:18:05', NULL, '3', '2017-06-28', '0'),
('7087', '10', '941', '1', '2020-01-22 05:35:44', NULL, '3', '2017-06-28', '808'),
('7088', '30', '952', '1', '2018-03-17 04:21:18', NULL, '3', '2017-06-30', '0'),
('7089', '13', '952', '1', '2018-03-17 04:21:18', NULL, '3', '2017-06-30', '0'),
('7090', '10', '942', '1', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '853'),
('7091', '13', '523', '1', '2018-03-17 04:22:05', 'Voided.', '3', '2018-03-17', '0'),
('7092', '10', '523', '1', '2018-03-17 04:22:05', 'Voided.\n', '3', '2018-03-17', '0'),
('7093', '13', '534', '1', '2018-03-17 04:22:20', 'Voided.', '3', '2018-03-17', '0'),
('7094', '10', '532', '1', '2018-03-17 04:22:20', 'Voided.\n', '3', '2018-03-17', '0'),
('7095', '30', '953', '1', '2018-03-17 04:31:37', NULL, '3', '2017-07-01', '0'),
('7096', '13', '953', '1', '2018-03-17 04:31:37', NULL, '3', '2017-07-01', '0'),
('7097', '10', '943', '1', '2020-01-22 05:35:44', NULL, '3', '2017-07-01', '856'),
('7098', '13', '500', '1', '2018-03-17 04:35:39', 'Voided.', '3', '2018-03-17', '0'),
('7099', '10', '501', '1', '2018-03-17 04:35:39', 'Voided.\n', '3', '2018-03-17', '0'),
('7100', '30', '954', '1', '2018-03-17 04:48:11', NULL, '3', '2017-07-06', '0'),
('7101', '13', '954', '1', '2018-03-17 04:48:11', NULL, '3', '2017-07-06', '0'),
('7102', '10', '944', '1', '2020-01-22 05:35:44', NULL, '3', '2017-07-06', '906'),
('7103', '30', '955', '1', '2018-03-17 04:49:12', NULL, '3', '2017-07-06', '0'),
('7104', '13', '955', '1', '2018-03-17 04:49:12', NULL, '3', '2017-07-06', '0'),
('7105', '10', '945', '1', '2020-01-22 05:35:44', NULL, '3', '2017-07-06', '907'),
('7106', '13', '498', '1', '2018-03-17 04:50:50', 'Voided.', '3', '2018-03-17', '0'),
('7107', '10', '499', '1', '2018-03-17 04:50:50', 'Voided.\n', '3', '2018-03-17', '0'),
('7108', '13', '499', '1', '2018-03-17 04:51:07', 'Voided.', '3', '2018-03-17', '0'),
('7109', '10', '500', '1', '2018-03-17 04:51:07', 'Voided.\n', '3', '2018-03-17', '0'),
('7110', '10', '546', '1', '2018-03-19 03:09:53', 'Updated.', '3', '2017-08-09', NULL),
('7111', '10', '547', '1', '2018-03-19 02:39:45', 'Updated.', '3', '2017-08-09', NULL),
('7112', '10', '547', '1', '2018-03-19 03:12:56', 'Updated.', '3', '2017-08-09', NULL),
('7113', '12', '539', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-19', '3188'),
('7114', '30', '956', '10', '2018-03-19 03:08:57', NULL, '3', '2017-08-09', '0'),
('7115', '13', '956', '10', '2018-03-19 03:08:57', NULL, '3', '2017-08-09', '0'),
('7116', '10', '946', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-09', '1229'),
('7117', '13', '548', '10', '2018-03-19 03:09:53', 'Voided.', '3', '2018-03-19', '0'),
('7118', '10', '546', '10', '2018-03-19 03:09:53', 'Voided.\n', '3', '2018-03-19', '0'),
('7119', '30', '957', '10', '2018-03-19 03:12:16', NULL, '3', '2017-08-09', '0'),
('7120', '13', '957', '10', '2018-03-19 03:12:16', NULL, '3', '2017-08-09', '0'),
('7121', '10', '947', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-09', '1230'),
('7122', '13', '549', '10', '2018-03-19 03:12:56', 'Voided.', '3', '2018-03-19', '0'),
('7123', '10', '547', '10', '2018-03-19 03:12:56', 'Voided.\n', '3', '2018-03-19', '0'),
('7124', '12', '540', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-14', '3166'),
('7125', '12', '541', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-14', '3167'),
('7126', '30', '958', '10', '2018-03-19 03:18:46', NULL, '3', '2017-09-11', '0'),
('7127', '13', '958', '10', '2018-03-19 03:18:46', NULL, '3', '2017-09-11', '0'),
('7128', '10', '948', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-11', '1473'),
('7129', '10', '579', '10', '2018-03-19 03:19:29', 'Voided.\n', '3', '2018-03-19', '0'),
('7130', '30', '959', '10', '2018-03-19 03:36:55', NULL, '3', '2017-09-29', '0'),
('7131', '13', '959', '10', '2018-03-19 03:36:55', NULL, '3', '2017-09-29', '0'),
('7132', '10', '949', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1678'),
('7133', '13', '686', '10', '2018-03-19 03:37:49', 'Voided.', '3', '2018-03-19', '0'),
('7134', '10', '683', '10', '2018-03-19 03:37:49', 'Voided.\n', '3', '2018-03-19', '0'),
('7135', '30', '960', '10', '2018-03-19 03:46:14', NULL, '3', '2017-10-12', '0'),
('7136', '13', '960', '10', '2018-03-19 03:46:14', NULL, '3', '2017-10-12', '0'),
('7137', '10', '950', '10', '2018-03-19 10:16:23', NULL, '3', '2017-10-12', NULL),
('7138', '13', '693', '10', '2018-03-19 03:47:09', 'Voided.', '3', '2018-03-19', '0'),
('7139', '10', '690', '10', '2018-03-19 03:47:09', 'Voided.\n', '3', '2018-03-19', '0'),
('7140', '30', '961', '10', '2018-03-19 03:53:21', NULL, '3', '2017-10-12', '0'),
('7141', '13', '961', '10', '2018-03-19 03:53:21', NULL, '3', '2017-10-12', '0'),
('7142', '10', '951', '10', '2018-03-19 10:17:07', NULL, '3', '2017-10-12', NULL),
('7143', '13', '694', '10', '2018-03-19 03:53:53', 'Voided.', '3', '2018-03-19', '0'),
('7144', '10', '691', '10', '2018-03-19 03:53:53', 'Voided.\n', '3', '2018-03-19', '0'),
('7145', '30', '962', '10', '2018-03-19 03:57:17', NULL, '3', '2017-10-17', '0'),
('7146', '13', '962', '10', '2018-03-19 03:57:17', NULL, '3', '2017-10-17', '0'),
('7147', '10', '952', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-17', '1799'),
('7148', '13', '733', '10', '2018-03-19 03:57:50', 'Voided.', '3', '2018-03-19', '0'),
('7149', '10', '730', '10', '2018-03-19 03:57:50', 'Voided.\n', '3', '2018-03-19', '0'),
('7150', '30', '963', '10', '2018-03-19 04:04:51', NULL, '3', '2017-11-02', '0'),
('7151', '13', '963', '10', '2018-03-19 04:04:51', NULL, '3', '2017-11-02', '0'),
('7152', '10', '953', '10', '2018-03-19 09:52:51', NULL, '3', '2017-11-02', NULL),
('7153', '13', '795', '10', '2018-03-19 04:05:19', 'Voided.', '3', '2018-03-19', '0'),
('7154', '10', '787', '10', '2018-03-19 04:05:19', 'Voided.\n', '3', '2018-03-19', '0'),
('7155', '30', '964', '10', '2018-03-19 04:10:22', NULL, '3', '2017-11-14', '0'),
('7156', '13', '964', '10', '2018-08-02 06:17:35', NULL, '5', '2017-11-14', NULL),
('7157', '10', '954', '10', '2018-08-02 06:17:36', NULL, '5', '2017-11-14', NULL),
('7158', '13', '734', '10', '2018-03-19 04:11:17', 'Voided.', '3', '2018-03-19', '0'),
('7159', '10', '731', '10', '2018-03-19 04:11:17', 'Voided.\n', '3', '2018-03-19', '0'),
('7160', '30', '965', '10', '2018-03-19 04:14:51', NULL, '3', '2017-11-13', '0'),
('7161', '13', '965', '10', '2018-03-19 10:08:06', NULL, '3', '2017-11-13', NULL),
('7162', '10', '955', '10', '2018-03-19 10:08:06', NULL, '3', '2017-11-13', NULL),
('7163', '13', '731', '10', '2018-03-19 04:15:56', 'Voided.', '3', '2018-03-19', '0'),
('7164', '10', '728', '10', '2018-03-19 04:15:56', 'Voided.\n', '3', '2018-03-19', '0'),
('7165', '30', '966', '10', '2018-03-19 04:17:19', NULL, '3', '2017-11-13', '0'),
('7166', '13', '966', '10', '2018-03-19 04:17:19', NULL, '3', '2017-11-13', '0'),
('7167', '10', '956', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-13', '2060'),
('7168', '13', '732', '10', '2018-03-19 04:18:05', 'Voided.', '3', '2018-03-19', '0'),
('7169', '10', '729', '10', '2018-03-19 04:18:05', 'Voided.\n', '3', '2018-03-19', '0'),
('7170', '30', '967', '10', '2018-03-19 04:28:13', NULL, '3', '2017-12-04', '0'),
('7171', '13', '967', '10', '2018-03-19 04:28:13', NULL, '3', '2017-12-04', '0'),
('7172', '10', '957', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2317'),
('7173', '13', '786', '10', '2018-03-19 04:29:17', 'Voided.', '3', '2018-03-19', '0'),
('7174', '10', '778', '10', '2018-03-19 04:29:17', 'Voided.\n', '3', '2018-03-19', '0'),
('7175', '30', '968', '10', '2018-03-19 04:31:56', NULL, '3', '2018-01-24', '0'),
('7176', '13', '968', '10', '2018-08-06 06:14:22', NULL, '5', '2018-01-24', NULL),
('7177', '10', '958', '10', '2018-08-06 06:14:22', NULL, '3', '2018-01-24', NULL),
('7178', '13', '893', '10', '2018-03-19 04:32:33', 'Voided.', '3', '2018-03-19', '0'),
('7179', '10', '885', '10', '2018-03-19 04:32:33', 'Voided.\n', '3', '2018-03-19', '0'),
('7180', '30', '969', '10', '2018-03-19 04:35:31', NULL, '3', '2018-02-01', '0'),
('7181', '13', '969', '10', '2018-03-19 10:00:10', NULL, '3', '2018-02-01', NULL),
('7182', '10', '959', '10', '2018-03-19 09:50:09', NULL, '3', '2018-02-01', NULL),
('7183', '13', '905', '10', '2018-03-19 04:36:03', 'Voided.', '3', '2018-03-19', '0'),
('7184', '10', '896', '10', '2018-03-19 04:36:03', 'Voided.\n', '3', '2018-03-19', '0'),
('7185', '30', '970', '10', '2018-03-19 04:38:49', NULL, '3', '2018-02-06', '0'),
('7186', '13', '970', '10', '2018-03-19 04:38:49', NULL, '3', '2018-02-06', '0'),
('7187', '10', '960', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-06', '2840'),
('7188', '13', '902', '10', '2018-03-19 04:39:18', 'Voided.', '3', '2018-03-19', '0'),
('7189', '10', '893', '10', '2018-03-19 04:39:18', 'Voided.\n', '3', '2018-03-19', '0'),
('7190', '30', '971', '10', '2018-03-19 05:13:02', NULL, '3', '2017-12-08', '0'),
('7191', '13', '971', '10', '2018-03-19 05:13:02', NULL, '3', '2017-12-08', '0'),
('7192', '10', '961', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-08', '2355'),
('7193', '30', '972', '10', '2018-03-19 05:13:55', NULL, '3', '2017-12-08', '0'),
('7194', '13', '972', '10', '2018-03-19 05:13:55', NULL, '3', '2017-12-08', '0'),
('7195', '10', '962', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-08', '2356'),
('7196', '30', '973', '10', '2018-03-19 05:17:55', NULL, '3', '2018-01-11', '0'),
('7197', '13', '973', '10', '2018-03-19 05:17:55', NULL, '3', '2018-01-11', '0'),
('7198', '10', '963', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-11', '2614'),
('7199', '30', '974', '10', '2018-03-19 05:19:18', NULL, '3', '2018-01-30', '0'),
('7200', '13', '974', '10', '2018-03-19 05:19:18', NULL, '3', '2018-01-30', '0'),
('7201', '10', '964', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-30', '2784'),
('7202', '30', '975', '10', '2018-03-19 05:20:46', NULL, '3', '2018-01-30', '0'),
('7203', '13', '975', '10', '2018-03-19 05:20:46', NULL, '3', '2018-01-30', '0'),
('7204', '10', '965', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-30', '2785'),
('7205', '30', '976', '10', '2018-03-19 05:21:55', NULL, '3', '2018-01-23', '0'),
('7206', '13', '976', '10', '2018-03-19 05:21:55', NULL, '3', '2018-01-23', '0'),
('7207', '10', '966', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-23', '2715'),
('7208', '1', '2080', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-19', '3189'),
('7209', '10', '936', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-04-07', '91'),
('7210', '10', '820', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-10-10', '1750'),
('7211', '1', '2081', '1', '2020-01-22 05:35:45', NULL, '3', '2018-01-26', '2765'),
('7212', '1', '2030', '1', '2018-03-19 09:47:03', 'Voided.\nDocument reentered.', '3', '2018-03-19', '0'),
('7213', '10', '959', '1', '2018-03-19 09:55:08', 'Updated.', '3', '2018-02-01', NULL),
('7214', '10', '953', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-02', '1983'),
('7215', '10', '959', '1', '2018-03-19 10:00:10', 'Updated.', '3', '2018-02-01', NULL),
('7216', '30', '977', '1', '2018-03-19 09:59:20', NULL, '3', '2018-02-01', '0'),
('7217', '13', '977', '1', '2018-03-19 09:59:20', NULL, '3', '2018-02-01', '0'),
('7218', '10', '967', '1', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2806'),
('7219', '13', '969', '1', '2018-03-19 10:00:10', 'Voided.', '3', '2018-03-19', '0'),
('7220', '10', '959', '1', '2018-03-19 10:00:10', 'Voided.\n', '3', '2018-03-19', '0'),
('7221', '10', '940', '1', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-08', '368'),
('7222', '13', '965', '1', '2018-03-19 10:08:06', 'Voided.', '3', '2018-03-19', '0'),
('7223', '10', '955', '1', '2018-03-19 10:08:06', 'Voided.\n', '3', '2018-03-19', '0'),
('7224', '10', '950', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-10-12', '1766'),
('7225', '10', '951', '1', '2020-01-22 05:35:45', 'Updated.', '3', '2017-10-12', '1767'),
('7226', '0', '93', '1', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2807'),
('7227', '10', '828', '1', '2018-03-19 10:30:55', 'Updated.', '3', '2018-01-09', NULL),
('7228', '10', '829', '1', '2018-03-19 10:31:07', 'Updated.', '3', '2018-01-09', NULL),
('7229', '30', '978', '1', '2018-03-19 10:27:10', NULL, '3', '2018-02-01', '0'),
('7230', '13', '978', '1', '2018-03-19 10:27:10', NULL, '3', '2018-02-01', '0'),
('7231', '10', '968', '1', '2020-01-22 05:35:45', NULL, '3', '2018-02-01', '2808'),
('7232', '30', '979', '1', '2018-03-19 10:29:54', NULL, '3', '2018-01-09', '0'),
('7233', '13', '979', '1', '2018-03-19 10:29:54', NULL, '3', '2018-01-09', '0'),
('7234', '10', '969', '1', '2020-01-22 05:35:45', NULL, '3', '2018-01-09', '2600'),
('7235', '13', '836', '1', '2018-03-19 10:30:55', 'Voided.', '3', '2018-03-19', '0'),
('7236', '10', '828', '1', '2018-03-19 10:30:55', 'Voided.\n', '3', '2018-03-19', '0'),
('7237', '13', '837', '1', '2018-03-19 10:31:07', 'Voided.', '3', '2018-03-19', '0'),
('7238', '10', '829', '1', '2018-03-19 10:31:07', 'Voided.\n', '3', '2018-03-19', '0'),
('7239', '1', '2082', '1', '2020-01-22 05:35:45', NULL, '3', '2018-02-23', '2987'),
('7240', '1', '1741', '1', '2018-03-19 10:33:48', 'Voided.\nDocument reentered.', '3', '2018-03-19', '0'),
('7241', '1', '2083', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-09', '3130'),
('7242', '1', '1889', '1', '2018-03-19 10:36:34', 'Voided.\nDocument reentered.', '3', '2018-03-19', '0'),
('7243', '1', '2084', '1', '2020-01-22 05:35:44', NULL, '3', '2017-05-06', '354'),
('7244', '1', '1478', '1', '2018-03-19 10:42:01', 'Voided.\nDocument reentered.', '3', '2018-03-19', '0'),
('7245', '1', '2085', '1', '2018-03-19 10:45:54', NULL, '3', '2017-04-11', NULL),
('7246', '1', '80', '1', '2018-03-19 10:43:32', 'Voided.\nDocument reentered.', '3', '2018-03-19', '0'),
('7247', '1', '2086', '1', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '129'),
('7248', '1', '2085', '1', '2018-03-19 10:45:54', 'Voided.\nDocument reentered.', '3', '2018-03-19', '0'),
('7249', '1', '2087', '1', '2020-01-22 05:35:45', NULL, '3', '2017-08-16', '1273'),
('7250', '1', '716', '1', '2018-03-19 10:47:49', 'Voided.\nDocument reentered.', '3', '2018-03-19', '0'),
('7251', '0', '84', '1', '2018-03-19 10:51:45', 'Voided.\nDocument reentered.', '3', '2018-03-19', '0'),
('7252', '0', '94', '1', '2020-01-22 05:35:44', NULL, '3', '2017-06-30', '854'),
('7253', '1', '2088', '1', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3037'),
('7254', '1', '1743', '1', '2018-03-19 10:52:57', 'Voided.\nDocument reentered.', '3', '2018-03-19', '0'),
('7255', '1', '2089', '1', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3038'),
('7256', '1', '1744', '1', '2018-03-19 10:53:18', 'Voided.\nDocument reentered.', '3', '2018-03-19', '0'),
('7257', '1', '2090', '1', '2020-01-22 05:35:44', NULL, '3', '2017-04-04', '11'),
('7258', '1', '40', '1', '2018-03-19 10:59:55', 'Voided.\nDocument reentered.', '3', '2018-03-19', '0'),
('7259', '1', '2091', '1', '2020-01-22 05:35:44', NULL, '3', '2017-05-02', '305'),
('7260', '1', '179', '1', '2018-03-19 11:00:57', 'Voided.\nDocument reentered.', '3', '2018-03-19', '0'),
('7261', '0', '95', '1', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3062'),
('7262', '1', '2092', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-09', '3131'),
('7263', '1', '1890', '1', '2018-03-19 11:10:25', 'Voided.\nDocument reentered.', '3', '2018-03-19', '0'),
('7264', '12', '508', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-03-27', '3240'),
('7265', '30', '980', '10', '2018-03-20 00:28:42', NULL, '3', '2017-12-21', '0'),
('7266', '13', '980', '10', '2018-03-20 00:28:43', NULL, '3', '2017-12-21', '0'),
('7267', '10', '970', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-21', '2474'),
('7268', '12', '542', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-22', '2484'),
('7269', '30', '981', '10', '2018-03-20 00:32:03', NULL, '3', '2018-01-23', '0'),
('7270', '13', '981', '10', '2018-03-20 00:32:03', NULL, '3', '2018-01-23', '0'),
('7271', '10', '971', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-23', '2716'),
('7272', '12', '543', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-24', '2727'),
('7273', '30', '982', '10', '2018-03-20 00:34:00', NULL, '3', '2018-02-22', '0'),
('7274', '13', '982', '10', '2018-03-20 00:34:00', NULL, '3', '2018-02-22', '0');
INSERT INTO `0_audit_trail` VALUES
('7275', '10', '972', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-22', '2979'),
('7276', '12', '544', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-23', '2988'),
('7277', '1', '2093', '10', '2018-03-20 01:01:34', NULL, '3', '2017-10-04', NULL),
('7278', '1', '2094', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-04', '1719'),
('7279', '1', '2093', '10', '2018-03-20 01:01:34', 'Voided.\nDocument reentered.', '3', '2018-03-20', '0'),
('7280', '30', '983', '10', '2018-03-20 01:09:33', NULL, '3', '2017-11-13', '0'),
('7281', '13', '983', '10', '2018-03-20 01:09:33', NULL, '3', '2017-11-13', '0'),
('7282', '10', '973', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-13', '2061'),
('7283', '12', '545', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-13', '2062'),
('7284', '30', '984', '10', '2018-03-20 01:11:03', NULL, '3', '2017-11-29', '0'),
('7285', '13', '984', '10', '2018-03-20 01:11:03', NULL, '3', '2017-11-29', '0'),
('7286', '10', '974', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-29', '2232'),
('7287', '12', '546', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-29', '2233'),
('7288', '30', '985', '10', '2018-03-20 01:15:33', NULL, '3', '2017-12-26', '0'),
('7289', '13', '985', '10', '2018-03-20 01:15:33', NULL, '3', '2017-12-26', '0'),
('7290', '10', '975', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-26', '2492'),
('7291', '12', '547', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-26', '2493'),
('7292', '30', '986', '10', '2018-03-20 01:22:03', NULL, '3', '2018-02-05', '0'),
('7293', '13', '986', '10', '2018-03-20 01:22:03', NULL, '3', '2018-02-05', '0'),
('7294', '10', '976', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-05', '2826'),
('7295', '12', '548', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-06', '2841'),
('7296', '30', '987', '10', '2018-03-20 01:23:29', NULL, '3', '2018-02-26', '0'),
('7297', '13', '987', '10', '2018-03-20 01:23:29', NULL, '3', '2018-02-26', '0'),
('7298', '10', '977', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3020'),
('7299', '12', '549', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3021'),
('7300', '1', '2095', '10', '2018-03-20 01:46:23', NULL, '3', '2017-11-09', NULL),
('7301', '2', '101', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2035'),
('7302', '1', '2095', '10', '2018-03-20 01:46:23', 'Voided.\n', '3', '2018-03-20', '0'),
('7303', '1', '2096', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2318'),
('7304', '1', '2097', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-04', '2319'),
('7305', '2', '102', '10', '2018-03-20 02:03:34', NULL, '3', '2017-04-11', NULL),
('7306', '2', '102', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-11', '130'),
('7307', '2', '100', '10', '2018-03-20 02:03:34', 'Voided.\nDocument reentered.', '3', '2018-03-20', '0'),
('7308', '12', '337', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-11-09', '2036'),
('7309', '12', '336', '10', '2018-03-20 02:06:08', 'Updated.', '3', '2017-11-09', NULL),
('7310', '12', '336', '10', '2018-03-20 02:07:48', 'Updated.', '3', '2017-11-09', NULL),
('7311', '12', '471', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-23', '2717'),
('7312', '12', '336', '10', '2018-03-20 02:31:24', 'Updated.', '3', '2017-11-09', NULL),
('7313', '12', '190', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-07-20', '1025'),
('7314', '2', '103', '10', '2018-03-20 02:14:38', NULL, '3', '2018-01-19', NULL),
('7315', '2', '103', '10', '2018-03-20 02:23:48', NULL, '3', '2018-01-19', NULL),
('7316', '2', '104', '10', '2018-03-20 02:23:48', NULL, '3', '2018-01-19', NULL),
('7317', '2', '104', '10', '2018-03-20 02:38:22', NULL, '3', '2018-01-19', NULL),
('7318', '2', '103', '10', '2018-03-20 02:23:48', 'Voided.\nDocument reentered.', '3', '2018-03-20', '0'),
('7319', '12', '463', '10', '2018-03-20 02:46:34', 'Updated.', '3', '2018-01-19', NULL),
('7320', '12', '336', '10', '2018-03-20 02:46:02', 'Updated.', '3', '2017-11-09', NULL),
('7321', '2', '104', '10', '2018-03-20 02:38:22', 'Voided.\n', '3', '2018-03-20', '0'),
('7322', '2', '105', '10', '2018-03-20 02:45:22', NULL, '3', '2017-11-09', NULL),
('7323', '2', '105', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-09', '2037'),
('7324', '12', '336', '10', '2018-03-20 02:46:02', 'Voided.\n', '3', '2018-03-20', '0'),
('7325', '12', '463', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-01-19', '2688'),
('7326', '11', '95', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-20', '3193'),
('7327', '2', '106', '10', '2018-03-20 04:11:11', NULL, '3', '2017-06-01', NULL),
('7328', '1', '2098', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-01', '592'),
('7329', '2', '106', '10', '2018-03-20 04:11:11', 'Voided.\n', '3', '2018-03-20', '0'),
('7330', '2', '107', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-22', '738'),
('7331', '12', '79', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-15', '407'),
('7332', '1', '2099', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-20', '3194'),
('7333', '1', '2100', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-20', '3195'),
('7334', '1', '2101', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-20', '3196'),
('7335', '1', '2102', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-02', '3078'),
('7336', '1', '1769', '10', '2018-03-21 00:07:55', 'Voided.\nDocument reentered.', '3', '2018-03-21', '0'),
('7337', '1', '2103', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-21', '3199'),
('7338', '2', '108', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-21', '3200'),
('7339', '12', '550', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-21', '3201'),
('7340', '1', '2104', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-21', '3202'),
('7341', '0', '96', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3063'),
('7342', '30', '988', '10', '2018-03-21 03:41:09', NULL, '3', '2018-03-21', '0'),
('7343', '13', '988', '10', '2018-03-21 03:41:10', NULL, '3', '2018-03-21', '0'),
('7344', '10', '978', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-21', '3203'),
('7345', '1', '2105', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3204'),
('7346', '1', '2106', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3205'),
('7347', '30', '989', '10', '2018-03-22 00:38:46', NULL, '3', '2018-02-19', '0'),
('7348', '13', '989', '10', '2018-03-22 00:38:47', NULL, '3', '2018-02-19', '0'),
('7349', '10', '979', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-19', '2942'),
('7350', '30', '990', '10', '2018-03-22 00:40:40', NULL, '3', '2018-02-14', '0'),
('7351', '13', '990', '10', '2018-03-22 00:40:40', NULL, '3', '2018-02-14', '0'),
('7352', '10', '980', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-14', '2901'),
('7353', '30', '991', '10', '2018-03-22 00:41:33', NULL, '3', '2018-03-22', '0'),
('7354', '13', '991', '10', '2018-03-22 00:41:33', NULL, '3', '2018-03-22', '0'),
('7355', '10', '981', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3206'),
('7356', '12', '551', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3207'),
('7357', '30', '992', '10', '2018-03-22 00:48:32', NULL, '3', '2018-01-30', '0'),
('7358', '13', '992', '10', '2018-03-22 00:48:32', NULL, '3', '2018-01-30', '0'),
('7359', '10', '982', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-30', '2786'),
('7360', '12', '552', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3208'),
('7361', '12', '553', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3209'),
('7362', '12', '554', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3210'),
('7363', '11', '96', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3211'),
('7364', '12', '555', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3212'),
('7365', '11', '97', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3213'),
('7366', '12', '556', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-30', '3268'),
('7367', '12', '557', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3214'),
('7368', '12', '558', '10', '2018-03-22 01:23:31', NULL, '3', '2018-03-26', NULL),
('7369', '12', '559', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3215'),
('7370', '12', '560', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3216'),
('7371', '12', '561', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3217'),
('7372', '12', '562', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3218'),
('7373', '12', '563', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-23', '3224'),
('7374', '12', '564', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-23', '3225'),
('7375', '12', '565', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-28', '3257'),
('7376', '12', '558', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2018-03-22', '3219'),
('7377', '1', '2107', '10', '2018-08-01 06:04:15', NULL, '5', '2018-03-22', NULL),
('7378', '1', '2108', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-26', '3233'),
('7379', '1', '2109', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-23', '3226'),
('7380', '30', '993', '10', '2018-03-26 02:14:35', NULL, '3', '2018-03-26', '0'),
('7381', '13', '993', '10', '2018-03-26 02:14:35', NULL, '3', '2018-03-26', '0'),
('7382', '10', '983', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-26', '3234'),
('7383', '13', '913', '10', '2018-03-26 22:47:07', 'Voided.', '3', '2018-03-26', '0'),
('7384', '10', '904', '10', '2018-03-26 22:47:07', 'Voided.\n', '3', '2018-03-26', '0'),
('7385', '4', '89', '10', '2018-03-27 00:23:14', 'Voided.\n', '3', '2018-03-26', '0'),
('7386', '1', '2110', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3241'),
('7387', '1', '2111', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3242'),
('7388', '1', '2112', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3243'),
('7389', '1', '2113', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3244'),
('7390', '1', '2114', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3245'),
('7391', '1', '2115', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3246'),
('7392', '1', '2116', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3247'),
('7393', '1', '2117', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-28', '3258'),
('7394', '1', '2118', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-28', '3259'),
('7395', '1', '2119', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-28', '3260'),
('7396', '12', '85', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-05-18', '434'),
('7397', '30', '994', '10', '2018-03-28 02:26:57', NULL, '3', '2018-03-28', '0'),
('7398', '13', '994', '10', '2018-03-28 02:46:21', NULL, '3', '2018-03-28', NULL),
('7399', '10', '984', '10', '2018-03-28 02:27:55', NULL, '3', '2018-03-28', NULL),
('7400', '10', '984', '10', '2018-03-28 02:46:22', 'Updated.', '3', '2018-03-28', NULL),
('7401', '30', '995', '10', '2018-03-28 02:44:48', NULL, '3', '2018-03-28', '0'),
('7402', '13', '995', '10', '2018-03-28 02:44:48', NULL, '3', '2018-03-28', '0'),
('7403', '10', '985', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-28', '3261'),
('7404', '13', '994', '10', '2018-03-28 02:46:21', 'Voided.', '3', '2018-03-28', '0'),
('7405', '10', '984', '10', '2018-03-28 02:46:22', 'Voided.\n', '3', '2018-03-28', '0'),
('7406', '1', '2120', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-28', '3262'),
('7407', '1', '2121', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-23', '3227'),
('7408', '12', '566', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-30', '3269'),
('7409', '12', '567', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-30', '3270'),
('7410', '30', '996', '10', '2018-03-30 04:34:29', NULL, '3', '2018-03-30', '0'),
('7411', '13', '996', '10', '2018-03-30 04:34:29', NULL, '3', '2018-03-30', '0'),
('7412', '10', '986', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-30', '3271'),
('7413', '1', '2122', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-30', '3272'),
('7414', '1', '2123', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-30', '3273'),
('7415', '1', '2124', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-30', '3274'),
('7416', '1', '2125', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-30', '3275'),
('7417', '1', '2126', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-30', '3276'),
('7418', '1', '2127', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-02', '3'),
('7419', '12', '568', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-02', '4'),
('7420', '1', '2128', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-30', '3277'),
('7421', '1', '2129', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-03', '8'),
('7422', '1', '2130', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-03', '9'),
('7423', '1', '2131', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-03', '10'),
('7424', '1', '2132', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-03', '11'),
('7425', '1', '2133', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-03', '12'),
('7426', '1', '2134', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-03', '13'),
('7427', '1', '2135', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-30', '3278'),
('7428', '1', '2136', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-30', '3279'),
('7429', '1', '2137', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-03', '14'),
('7430', '30', '997', '10', '2018-04-03 00:59:55', NULL, '3', '2018-03-30', '0'),
('7431', '13', '997', '10', '2018-04-03 00:59:55', NULL, '3', '2018-03-30', '0'),
('7432', '10', '987', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-30', '3280'),
('7433', '30', '998', '10', '2018-04-03 01:01:17', NULL, '3', '2018-03-30', '0'),
('7434', '13', '998', '10', '2018-04-03 01:01:17', NULL, '3', '2018-03-30', '0'),
('7435', '10', '988', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-30', '3281'),
('7436', '1', '2138', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-03', '15'),
('7437', '1', '2139', '10', '2018-04-03 06:09:02', NULL, '5', '2018-04-03', NULL),
('7438', '1', '2140', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-03', '16'),
('7439', '1', '2139', '10', '2018-04-03 06:09:02', 'Voided.\nDocument reentered.', '5', '2018-04-03', '0'),
('7440', '0', '97', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-04', '19'),
('7441', '1', '2141', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-04', '20'),
('7442', '1', '2142', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '23'),
('7443', '1', '2143', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '24'),
('7444', '1', '2144', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '25'),
('7445', '1', '2145', '10', '2018-04-04 23:54:50', NULL, '5', '2018-04-05', NULL),
('7446', '1', '2146', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '26'),
('7447', '1', '2147', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '27'),
('7448', '1', '2148', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '28'),
('7449', '1', '2149', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '29'),
('7450', '1', '2150', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '30'),
('7451', '1', '2151', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '31'),
('7452', '1', '2152', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '32'),
('7453', '1', '2153', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '33'),
('7454', '1', '2154', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '34'),
('7455', '1', '2155', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '35'),
('7456', '1', '2156', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '36'),
('7457', '1', '2157', '10', '2018-04-05 06:04:54', NULL, '5', '2018-04-05', NULL),
('7458', '1', '2158', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '37'),
('7459', '1', '2159', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '38'),
('7460', '1', '2160', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '39'),
('7461', '1', '2161', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '40'),
('7462', '1', '2162', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '41'),
('7463', '1', '2145', '10', '2018-04-04 23:54:50', 'Voided.\nDocument reentered.', '5', '2018-04-04', '0'),
('7464', '1', '2163', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '42'),
('7465', '1', '2164', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '43'),
('7466', '1', '2165', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '44'),
('7467', '1', '2166', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '45'),
('7468', '1', '2167', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '46'),
('7469', '1', '2168', '10', '2018-12-01 04:32:10', NULL, '5', '2018-04-05', NULL),
('7470', '1', '2169', '10', '2018-04-23 23:13:48', NULL, '5', '2018-04-05', NULL),
('7471', '1', '2170', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '47'),
('7472', '1', '2171', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '48'),
('7473', '1', '2172', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '49'),
('7474', '1', '2173', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '50'),
('7475', '1', '2174', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '51'),
('7476', '1', '2157', '10', '2018-04-05 06:04:54', 'Voided.\nMr Pintoe Ask to Cancell the chq\n', '5', '2018-04-05', '0'),
('7477', '1', '2175', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '52'),
('7478', '1', '2176', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '59'),
('7479', '1', '2177', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '60'),
('7480', '1', '2178', '10', '2019-11-06 08:02:55', NULL, '6', '2018-04-06', NULL),
('7481', '18', '37', '10', '2018-04-06 01:33:57', NULL, '3', '2018-02-23', '0'),
('7482', '25', '36', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-23', '2989'),
('7483', '20', '98', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-23', '2990'),
('7484', '22', '38', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '61'),
('7485', '18', '38', '10', '2018-04-06 01:38:34', NULL, '3', '2018-03-01', '0'),
('7486', '25', '37', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-01', '3068'),
('7487', '20', '99', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-01', '3069'),
('7488', '22', '39', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '62'),
('7489', '1', '2179', '10', '2018-04-06 02:08:22', NULL, '5', '2018-04-06', NULL),
('7490', '12', '569', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-13', '120'),
('7491', '12', '570', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-30', '257'),
('7492', '12', '571', '10', '2018-05-09 01:29:26', NULL, '5', '2018-04-30', NULL),
('7493', '12', '572', '10', '2018-07-05 02:54:33', NULL, '5', '2018-07-02', NULL),
('7494', '12', '573', '10', '2018-04-11 01:19:46', NULL, '5', '2018-04-06', NULL),
('7495', '1', '2180', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '63'),
('7496', '1', '2179', '10', '2018-04-06 02:08:22', 'Voided.\nDocument reentered.', '5', '2018-04-06', '0'),
('7497', '1', '2181', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '64'),
('7498', '1', '2182', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '65'),
('7499', '1', '2183', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '66'),
('7500', '1', '2184', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '67'),
('7501', '1', '2185', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '68'),
('7502', '1', '2186', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '69'),
('7503', '1', '2187', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '70'),
('7504', '12', '574', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-12', '115'),
('7505', '12', '575', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '230'),
('7506', '12', '576', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-16', '121'),
('7507', '1', '2188', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-09', '80'),
('7508', '1', '2189', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-09', '81'),
('7509', '1', '2190', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-09', '82'),
('7510', '12', '577', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-09', '83'),
('7511', '12', '578', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-30', '258'),
('7512', '12', '579', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '556'),
('7513', '12', '580', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '919'),
('7514', '1', '2191', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-09', '84'),
('7515', '1', '2192', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-10', '93'),
('7516', '1', '2193', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-10', '94'),
('7517', '1', '2194', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-10', '95'),
('7518', '1', '2195', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-10', '96'),
('7519', '1', '2196', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-10', '97'),
('7520', '1', '2197', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-09', '85'),
('7521', '1', '2198', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-09', '86'),
('7522', '1', '2199', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-09', '87'),
('7523', '1', '2200', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-11', '100'),
('7524', '20', '100', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-14', '3168'),
('7525', '22', '40', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-14', '3169'),
('7526', '1', '2201', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-11', '101'),
('7527', '12', '573', '10', '2018-04-11 01:19:46', 'Voided.\nReturned Chq CHQ 343020\nBOC', '5', '2018-04-11', '0'),
('7528', '1', '2202', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-09', '88'),
('7529', '1', '2203', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-11', '102'),
('7530', '1', '2204', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-11', '103'),
('7531', '1', '2205', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-11', '104'),
('7532', '1', '2206', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-11', '105'),
('7533', '1', '2207', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-11', '106'),
('7534', '1', '2208', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-11', '107'),
('7535', '1', '2209', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-11', '108'),
('7536', '1', '2210', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-16', '122'),
('7537', '1', '2211', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-16', '123'),
('7538', '1', '2212', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-16', '124'),
('7539', '1', '2213', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-17', '127'),
('7540', '1', '2214', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-17', '128'),
('7541', '1', '2215', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-17', '129'),
('7542', '1', '2216', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-17', '130'),
('7543', '1', '2217', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-17', '131'),
('7544', '1', '2218', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-17', '132'),
('7545', '1', '2219', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-17', '133'),
('7546', '1', '2220', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-17', '134'),
('7547', '1', '2221', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-12', '116'),
('7548', '0', '98', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3157'),
('7549', '1', '2222', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-17', '135'),
('7550', '1', '2223', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-17', '136'),
('7551', '12', '581', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-18', '140'),
('7552', '1', '2224', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-18', '141'),
('7553', '1', '2225', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-18', '142'),
('7554', '1', '2226', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-18', '143'),
('7555', '30', '999', '10', '2018-04-18 06:32:53', NULL, '5', '2018-04-18', '0'),
('7556', '13', '999', '10', '2018-04-18 06:32:53', NULL, '5', '2018-04-18', '0'),
('7557', '30', '1000', '10', '2018-04-18 06:38:30', NULL, '5', '2018-04-18', '0'),
('7558', '13', '1000', '10', '2018-04-18 06:38:30', NULL, '5', '2018-04-18', '0'),
('7559', '1', '2227', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-19', '144'),
('7560', '1', '2228', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-19', '145'),
('7561', '30', '1001', '10', '2018-04-19 23:27:14', NULL, '5', '2018-04-20', '0'),
('7562', '13', '1001', '10', '2018-04-19 23:27:15', NULL, '5', '2018-04-20', '0'),
('7563', '10', '989', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '152'),
('7564', '30', '1002', '10', '2018-04-20 02:12:26', NULL, '3', '2018-03-13', '0'),
('7565', '13', '1002', '10', '2018-04-20 02:12:26', NULL, '3', '2018-03-13', '0'),
('7566', '10', '990', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3158'),
('7567', '12', '582', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '153'),
('7568', '12', '583', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-23', '189'),
('7569', '1', '2229', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '154'),
('7570', '1', '2230', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '155'),
('7571', '1', '2231', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '156'),
('7572', '30', '1003', '10', '2018-04-20 03:15:21', NULL, '5', '2018-04-20', '0'),
('7573', '13', '1003', '10', '2018-04-20 03:15:21', NULL, '5', '2018-04-20', '0'),
('7574', '10', '991', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '157'),
('7575', '1', '2232', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '158'),
('7576', '1', '2233', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '159'),
('7577', '1', '2234', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '160'),
('7578', '1', '2235', '10', '2018-04-20 03:53:02', NULL, '5', '2018-04-20', NULL),
('7579', '1', '2236', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '161'),
('7580', '1', '2235', '10', '2018-04-20 03:53:02', 'Voided.\nDocument reentered.', '5', '2018-04-20', '0'),
('7581', '1', '2237', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-17', '137'),
('7582', '4', '94', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3107'),
('7583', '2', '109', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-26', '3235'),
('7584', '1', '2238', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3282'),
('7585', '1', '2239', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3283'),
('7586', '1', '2240', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3248'),
('7587', '1', '2241', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3249'),
('7588', '1', '2242', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3250'),
('7589', '30', '1004', '10', '2018-04-23 03:32:02', NULL, '5', '2018-04-23', '0'),
('7590', '13', '1004', '10', '2018-04-23 05:00:43', NULL, '5', '2018-04-23', NULL),
('7591', '10', '992', '10', '2018-04-23 04:44:32', NULL, '5', '2018-04-23', NULL),
('7592', '10', '992', '10', '2018-04-23 04:56:33', 'Updated.', '5', '2018-04-23', NULL),
('7593', '1', '2243', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '162'),
('7594', '10', '992', '10', '2018-04-23 04:57:06', 'Updated.', '5', '2018-04-23', NULL),
('7595', '10', '992', '10', '2018-04-23 05:00:43', 'Updated.', '5', '2018-04-23', NULL),
('7596', '30', '1005', '10', '2018-04-23 04:58:24', NULL, '5', '2018-04-23', '0'),
('7597', '13', '1005', '10', '2018-04-23 05:00:53', NULL, '5', '2018-04-23', NULL),
('7598', '10', '993', '10', '2018-04-23 05:00:53', NULL, '5', '2018-04-23', NULL),
('7599', '30', '1006', '10', '2018-04-23 04:59:44', NULL, '5', '2018-04-23', '0'),
('7600', '13', '1006', '10', '2018-04-23 05:21:16', NULL, '5', '2018-04-23', NULL),
('7601', '10', '994', '10', '2018-04-23 05:21:16', NULL, '5', '2018-04-23', NULL),
('7602', '13', '1004', '10', '2018-04-23 05:00:43', 'Voided.', '5', '2018-04-23', '0'),
('7603', '10', '992', '10', '2018-04-23 05:00:43', 'Voided.\n', '5', '2018-04-23', '0'),
('7604', '13', '1005', '10', '2018-04-23 05:00:53', 'Voided.', '5', '2018-04-23', '0'),
('7605', '10', '993', '10', '2018-04-23 05:00:53', 'Voided.\n', '5', '2018-04-23', '0'),
('7606', '30', '1007', '10', '2018-04-23 05:19:41', NULL, '5', '2018-04-23', '0'),
('7607', '13', '1007', '10', '2018-04-23 05:19:42', NULL, '5', '2018-04-23', '0'),
('7608', '10', '995', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-23', '190'),
('7609', '13', '1006', '10', '2018-04-23 05:21:16', 'Voided.', '5', '2018-04-23', '0'),
('7610', '10', '994', '10', '2018-04-23 05:21:16', 'Voided.\n', '5', '2018-04-23', '0'),
('7611', '1', '2244', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-23', '191'),
('7612', '1', '2245', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-23', '192'),
('7613', '1', '2246', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3251'),
('7614', '1', '2247', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3252'),
('7615', '1', '2248', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3253'),
('7616', '1', '2249', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3254'),
('7617', '1', '2250', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-26', '3236'),
('7618', '1', '2251', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-26', '3237'),
('7619', '1', '2252', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-16', '3181'),
('7620', '1', '2169', '10', '2018-04-23 23:13:48', 'Voided.\nDocument reentered.', '5', '2018-04-23', '0'),
('7621', '1', '2253', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-14', '3170'),
('7622', '1', '2254', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-14', '3171'),
('7623', '1', '2255', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-14', '3172'),
('7624', '1', '2256', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-07', '3113'),
('7625', '1', '2257', '10', '2018-08-01 09:05:16', NULL, '5', '2018-03-12', NULL),
('7626', '1', '2258', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3159'),
('7627', '1', '2259', '10', '2018-04-24 00:29:23', NULL, '5', '2018-03-05', NULL),
('7628', '1', '2260', '10', '2018-04-24 00:30:10', NULL, '5', '2018-03-05', NULL),
('7629', '1', '2261', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-05', '3085'),
('7630', '1', '2259', '10', '2018-04-24 00:29:23', 'Voided.\nDocument reentered.', '5', '2018-04-24', '0'),
('7631', '1', '2262', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-28', '3263'),
('7632', '1', '2260', '10', '2018-04-24 00:30:10', 'Voided.\nDocument reentered.', '5', '2018-04-24', '0'),
('7633', '30', '1008', '10', '2018-04-24 00:44:07', NULL, '3', '2018-03-28', '0'),
('7634', '13', '1008', '10', '2018-04-24 00:44:07', NULL, '3', '2018-03-28', '0'),
('7635', '10', '996', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-28', '3264'),
('7636', '12', '584', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-28', '3265'),
('7637', '30', '1009', '10', '2018-04-24 00:51:33', NULL, '3', '2018-03-22', '0'),
('7638', '13', '1009', '10', '2018-04-24 00:51:33', NULL, '3', '2018-03-22', '0'),
('7639', '10', '997', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3220'),
('7640', '12', '585', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3221'),
('7641', '1', '2263', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-24', '200'),
('7642', '1', '2264', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-24', '201'),
('7643', '1', '2265', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-19', '3190'),
('7644', '1', '2266', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-24', '202'),
('7645', '1', '2267', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-24', '203'),
('7646', '1', '2268', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-24', '204'),
('7647', '1', '2269', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-24', '205'),
('7648', '1', '2270', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-24', '206'),
('7649', '1', '2271', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-24', '207'),
('7650', '1', '2272', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-24', '208'),
('7651', '1', '2273', '10', '2018-08-08 06:06:34', NULL, '5', '2018-04-25', NULL),
('7652', '1', '2274', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-25', '214'),
('7653', '30', '1010', '10', '2018-04-25 00:49:21', NULL, '5', '2018-04-25', '0'),
('7654', '13', '1010', '10', '2019-06-22 03:53:27', NULL, '6', '2018-04-25', NULL),
('7655', '10', '998', '10', '2019-06-22 03:53:28', NULL, '6', '2018-04-25', NULL),
('7656', '30', '1011', '10', '2018-04-25 01:00:21', NULL, '5', '2018-04-25', '0'),
('7657', '13', '1011', '10', '2018-04-25 01:00:21', NULL, '5', '2018-04-25', '0'),
('7658', '10', '999', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-25', '215'),
('7659', '1', '2275', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-25', '216'),
('7660', '10', '998', '10', '2019-06-22 03:53:28', 'Updated.', '6', '2018-04-25', NULL),
('7661', '10', '998', '10', '2019-06-22 03:53:28', 'Updated.', '6', '2018-04-25', NULL),
('7662', '1', '2276', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-25', '217'),
('7663', '1', '2277', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-25', '218'),
('7664', '1', '2278', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-25', '219'),
('7665', '12', '586', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-26', '221'),
('7666', '1', '2279', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-26', '222'),
('7667', '1', '2280', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-26', '223'),
('7668', '1', '2281', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-26', '224'),
('7669', '1', '2282', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-26', '225'),
('7670', '1', '2283', '10', '2018-04-26 06:35:21', NULL, '5', '2018-04-26', NULL),
('7671', '1', '2284', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-26', '226'),
('7672', '1', '2283', '10', '2018-04-26 06:35:21', 'Voided.\nDocument reentered.', '5', '2018-04-26', '0'),
('7673', '1', '2285', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '231'),
('7674', '1', '2286', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '232'),
('7675', '1', '2287', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '233'),
('7676', '1', '2288', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '234'),
('7677', '30', '1012', '10', '2018-04-27 02:46:06', NULL, '3', '2018-03-31', '0'),
('7678', '13', '1012', '10', '2018-04-27 02:46:06', NULL, '3', '2018-03-31', '0'),
('7679', '10', '1000', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3284'),
('7680', '1', '2289', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '235'),
('7681', '1', '2290', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '236'),
('7682', '1', '2291', '10', '2018-04-27 04:41:02', NULL, '5', '2018-04-27', NULL),
('7683', '1', '2292', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '237'),
('7684', '1', '2291', '10', '2018-04-27 04:41:02', 'Voided.\nDocument reentered.', '5', '2018-04-27', '0'),
('7685', '1', '2293', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '238'),
('7686', '1', '2294', '10', '2018-07-23 23:36:34', NULL, '5', '2018-04-27', NULL),
('7687', '1', '2295', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '239'),
('7688', '1', '2296', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '240'),
('7689', '1', '2297', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '241'),
('7690', '1', '2298', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '242'),
('7691', '1', '2299', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '243'),
('7692', '1', '2300', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '244'),
('7693', '12', '587', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '71'),
('7694', '12', '588', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '72'),
('7695', '12', '589', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '73'),
('7696', '12', '590', '10', '2018-05-02 23:51:12', NULL, '5', '2018-04-06', NULL),
('7697', '12', '591', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '74'),
('7698', '12', '592', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '75'),
('7699', '12', '593', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-01', '266'),
('7700', '12', '594', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-01', '267'),
('7701', '12', '595', '10', '2018-05-01 03:38:16', NULL, '5', '2018-05-01', NULL),
('7702', '12', '595', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-05-01', '268'),
('7703', '12', '596', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-24', '209'),
('7704', '1', '2301', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-01', '269'),
('7705', '12', '484', '10', '2018-05-01 04:42:42', 'Voided.\n', '5', '2018-05-01', '0'),
('7706', '1', '2302', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-01', '270'),
('7707', '1', '2303', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-01', '271'),
('7708', '1', '2304', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-01', '272'),
('7709', '1', '2305', '10', '2018-05-03 02:08:26', NULL, '5', '2018-04-27', NULL),
('7710', '1', '2306', '10', '2018-05-03 02:07:03', NULL, '5', '2018-04-27', NULL),
('7711', '30', '1013', '10', '2018-05-02 03:08:37', NULL, '3', '2018-03-31', '0'),
('7712', '13', '1013', '10', '2018-05-02 03:08:37', NULL, '3', '2018-03-31', '0'),
('7713', '10', '1001', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3285'),
('7714', '1', '2307', '10', '2018-05-02 22:42:49', NULL, '5', '2018-05-02', NULL),
('7715', '1', '2308', '10', '2018-05-02 22:42:42', NULL, '5', '2018-05-02', NULL),
('7716', '1', '2308', '10', '2018-05-02 22:42:42', 'Voided.\n', '5', '2018-05-02', '0'),
('7717', '1', '2307', '10', '2018-05-02 22:42:49', 'Voided.\n', '5', '2018-05-02', '0'),
('7718', '12', '590', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-04-06', '76'),
('7719', '30', '1014', '10', '2018-05-03 00:32:23', NULL, '3', '2018-03-20', '0'),
('7720', '13', '1014', '10', '2018-05-03 00:32:23', NULL, '3', '2018-03-20', '0'),
('7721', '10', '1002', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-20', '3197'),
('7722', '30', '1015', '10', '2018-05-03 00:35:27', NULL, '3', '2018-03-07', '0'),
('7723', '13', '1015', '10', '2018-05-03 00:35:27', NULL, '3', '2018-03-07', '0'),
('7724', '10', '1003', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-07', '3114'),
('7725', '30', '1016', '10', '2018-05-03 00:38:02', NULL, '3', '2018-03-20', '0'),
('7726', '13', '1016', '10', '2018-05-03 00:38:02', NULL, '3', '2018-03-20', '0'),
('7727', '10', '1004', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-20', '3198'),
('7728', '12', '597', '10', '2018-05-14 00:14:57', NULL, '5', '2018-04-20', NULL),
('7729', '12', '598', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '163'),
('7730', '12', '599', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '164'),
('7731', '12', '600', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '165'),
('7732', '12', '601', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '166'),
('7733', '11', '98', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '167'),
('7734', '1', '2309', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '281'),
('7735', '1', '2310', '10', '2018-05-03 02:07:34', NULL, '5', '2018-04-27', NULL),
('7736', '1', '2306', '10', '2018-05-03 02:07:03', 'Voided.\nDocument reentered.', '5', '2018-05-03', '0'),
('7737', '1', '2311', '10', '2019-07-13 03:35:58', NULL, '6', '2018-05-01', NULL),
('7738', '1', '2310', '10', '2018-05-03 02:07:34', 'Voided.\nDocument reentered.', '5', '2018-05-03', '0'),
('7739', '1', '2312', '10', '2019-07-13 03:36:23', NULL, '6', '2018-05-01', NULL),
('7740', '1', '2305', '10', '2018-05-03 02:08:26', 'Voided.\nDocument reentered.', '5', '2018-05-03', '0'),
('7741', '1', '2313', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '282'),
('7742', '30', '1017', '10', '2018-05-03 03:22:11', NULL, '5', '2018-05-03', '0'),
('7743', '13', '1017', '10', '2018-05-03 03:22:11', NULL, '5', '2018-05-03', '0'),
('7744', '1', '2314', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '283'),
('7745', '1', '2315', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '284'),
('7746', '1', '2316', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '285'),
('7747', '1', '2317', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '286'),
('7748', '1', '2318', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '287'),
('7749', '1', '2319', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '288'),
('7750', '30', '1018', '10', '2018-05-03 06:25:54', NULL, '5', '2018-05-03', '0'),
('7751', '13', '1018', '10', '2018-05-03 06:25:54', NULL, '5', '2018-05-03', '0'),
('7752', '10', '1005', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '289'),
('7753', '12', '602', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '290'),
('7754', '12', '603', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '291'),
('7755', '1', '2320', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '292'),
('7756', '1', '2321', '10', '2018-05-08 00:32:59', NULL, '5', '2018-05-04', NULL),
('7757', '1', '2322', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-04', '308'),
('7758', '1', '2323', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-04', '309'),
('7759', '18', '39', '10', '2018-05-04 02:17:49', NULL, '5', '2018-04-11', '0'),
('7760', '25', '38', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-11', '109'),
('7761', '20', '101', '10', '2018-05-10 02:37:34', NULL, '5', '2018-04-11', NULL),
('7762', '2', '110', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-04', '310'),
('7763', '18', '40', '10', '2018-05-04 02:40:19', NULL, '5', '2018-04-11', '0'),
('7764', '25', '39', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-11', '110'),
('7765', '20', '102', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-11', '111'),
('7766', '18', '41', '10', '2018-05-04 02:43:28', NULL, '5', '2018-04-19', '0'),
('7767', '25', '40', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-19', '146'),
('7768', '20', '103', '10', '2019-11-05 04:51:42', NULL, '6', '2018-04-19', NULL),
('7769', '1', '2324', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-04', '311'),
('7770', '26', '7', '1', '2018-05-04 03:18:49', NULL, '5', '2018-05-04', NULL),
('7771', '26', '7', '1', '2018-05-04 03:20:38', 'Released.', '5', '2018-05-04', NULL),
('7772', '29', '5', '1', '2018-05-04 03:18:49', 'Production.', '5', '2018-05-04', '0'),
('7773', '0', '99', '1', '2021-02-07 08:09:15', NULL, '5', '2018-05-04', '312'),
('7774', '26', '7', '1', '2018-05-04 03:20:38', 'Voided.\n', '5', '2018-05-04', '0'),
('7775', '26', '8', '1', '2018-05-04 03:26:52', NULL, '5', '2018-05-03', NULL),
('7776', '26', '8', '1', '2021-02-07 08:09:15', 'Released.', '5', '2018-05-03', '293'),
('7777', '29', '6', '1', '2021-02-07 08:09:15', 'Production.', '5', '2018-05-03', '294'),
('7778', '16', '33', '10', '2018-05-08 00:16:07', NULL, '5', '2018-05-04', '0'),
('7779', '16', '34', '10', '2018-05-08 00:16:34', NULL, '5', '2018-05-04', '0'),
('7780', '16', '35', '10', '2018-05-08 00:20:41', NULL, '5', '2018-05-04', '0'),
('7781', '12', '604', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '319'),
('7782', '12', '605', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '320'),
('7783', '1', '2325', '10', '2018-11-23 04:42:02', NULL, '5', '2018-05-04', NULL),
('7784', '1', '2321', '10', '2018-05-08 00:32:59', 'Voided.\nDocument reentered.', '5', '2018-05-08', '0'),
('7785', '1', '2326', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '321'),
('7786', '1', '2327', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '322'),
('7787', '1', '2328', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '323'),
('7788', '1', '2329', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '324'),
('7789', '1', '2330', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '325'),
('7790', '1', '2331', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '295'),
('7791', '1', '2332', '10', '2018-05-08 02:08:08', NULL, '5', '2018-05-03', NULL),
('7792', '1', '2333', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '326'),
('7793', '1', '2332', '10', '2018-05-08 02:08:08', 'Voided.\nDocument reentered.', '5', '2018-05-08', '0'),
('7794', '1', '2334', '10', '2018-07-24 00:37:03', NULL, '5', '2018-05-04', NULL),
('7795', '1', '2335', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-02', '276'),
('7796', '1', '2336', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-02', '277'),
('7797', '1', '2337', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-02', '278'),
('7798', '1', '2338', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '327'),
('7799', '1', '2339', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '328'),
('7800', '20', '104', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-03', '17'),
('7801', '20', '105', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-03', '18'),
('7802', '20', '106', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '168'),
('7803', '20', '107', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '169'),
('7804', '22', '41', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '329'),
('7805', '12', '606', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-09', '338'),
('7806', '12', '571', '10', '2018-05-09 01:29:26', 'Voided.\nCHQ Returned', '5', '2018-05-09', '0'),
('7807', '1', '2340', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-09', '339'),
('7808', '30', '1019', '10', '2018-05-09 01:39:19', NULL, '5', '2018-04-05', '0'),
('7809', '13', '1019', '10', '2018-05-09 01:48:13', NULL, '5', '2018-04-05', '0'),
('7810', '10', '1006', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '53'),
('7811', '12', '607', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '54'),
('7812', '1', '2341', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-09', '340'),
('7813', '1', '2342', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-09', '341'),
('7814', '1', '2343', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-09', '342'),
('7815', '1', '2344', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-09', '343'),
('7816', '20', '101', '10', '2018-05-10 02:37:34', 'Voided.\nDocument reentered.', '5', '2018-05-10', '0'),
('7817', '20', '108', '10', '2018-05-10 02:44:51', NULL, '5', '2018-04-11', NULL),
('7818', '22', '42', '10', '2018-05-10 02:41:41', NULL, '5', '2018-05-10', NULL),
('7819', '22', '42', '10', '2018-05-10 02:41:41', 'Voided.\n', '5', '2018-05-10', '0'),
('7820', '22', '43', '10', '2018-05-10 02:42:31', NULL, '5', '2018-05-10', NULL),
('7821', '22', '43', '10', '2018-05-10 02:42:31', 'Voided.\n', '5', '2018-05-10', '0'),
('7822', '20', '108', '10', '2018-05-10 02:44:51', 'Voided.\nDocument reentered.', '5', '2018-05-10', '0'),
('7823', '20', '109', '10', '2018-05-10 03:20:58', NULL, '5', '2018-04-11', NULL),
('7824', '22', '44', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-10', '350'),
('7825', '30', '1020', '10', '2018-05-10 03:11:24', NULL, '5', '2018-04-30', '0'),
('7826', '13', '1020', '10', '2018-05-10 03:11:24', NULL, '5', '2018-04-30', '0'),
('7827', '10', '1007', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-30', '259'),
('7828', '1', '2345', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-10', '351'),
('7829', '20', '109', '10', '2018-05-10 03:20:58', 'Voided.\nDocument reentered.', '5', '2018-05-10', '0'),
('7830', '20', '110', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-11', '112'),
('7831', '26', '9', '10', '2018-05-10 03:29:00', NULL, '5', '2018-05-09', NULL),
('7832', '26', '9', '10', '2021-02-07 08:09:15', 'Released.', '5', '2018-05-09', '344'),
('7833', '29', '7', '10', '2021-02-07 08:09:15', 'Production.', '5', '2018-05-09', '345'),
('7834', '12', '608', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '385'),
('7835', '12', '609', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '654'),
('7836', '12', '610', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-18', '727'),
('7837', '1', '2346', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-10', '352'),
('7838', '12', '611', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-11', '358'),
('7839', '1', '2347', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-10', '353'),
('7840', '1', '2348', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-10', '354'),
('7841', '1', '2349', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-11', '359'),
('7842', '12', '612', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-11', '360'),
('7843', '1', '2350', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-11', '361'),
('7844', '1', '2351', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-11', '362'),
('7845', '30', '1021', '10', '2018-05-11 05:04:04', NULL, '5', '2018-04-30', '0'),
('7846', '13', '1021', '10', '2018-05-11 05:04:04', NULL, '5', '2018-04-30', '0'),
('7847', '10', '1008', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-30', '260'),
('7848', '1', '2352', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-11', '363'),
('7849', '1', '2353', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-14', '373'),
('7850', '12', '597', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-04-20', '170'),
('7851', '12', '613', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '171'),
('7852', '11', '99', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '172'),
('7853', '11', '100', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '173'),
('7854', '11', '101', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '174'),
('7855', '11', '102', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '175'),
('7856', '11', '103', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '176'),
('7857', '11', '104', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '177'),
('7858', '11', '105', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '178'),
('7859', '11', '106', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '179'),
('7860', '11', '107', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '180'),
('7861', '11', '108', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '181'),
('7862', '11', '109', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '182'),
('7863', '11', '110', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '183'),
('7864', '11', '111', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-20', '184'),
('7865', '1', '2354', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-14', '374'),
('7866', '1', '2355', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-14', '375'),
('7867', '1', '2356', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-14', '376'),
('7868', '1', '2357', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-14', '377'),
('7869', '30', '1022', '10', '2018-05-14 04:33:04', NULL, '3', '2018-02-19', '0'),
('7870', '13', '1022', '10', '2018-05-14 04:33:04', NULL, '3', '2018-02-19', '0'),
('7871', '10', '1009', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-19', '2943'),
('7872', '30', '1023', '10', '2018-05-14 04:50:42', NULL, '3', '2018-02-20', '0'),
('7873', '13', '1023', '10', '2018-05-14 04:50:42', NULL, '3', '2018-02-20', '0'),
('7874', '10', '1010', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-20', '2957'),
('7875', '30', '1024', '10', '2018-05-14 04:52:41', NULL, '3', '2018-02-23', '0');
INSERT INTO `0_audit_trail` VALUES
('7876', '13', '1024', '10', '2018-05-14 04:52:41', NULL, '3', '2018-02-23', '0'),
('7877', '10', '1011', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-23', '2991'),
('7878', '30', '1025', '10', '2018-05-14 04:54:39', NULL, '3', '2018-02-27', '0'),
('7879', '13', '1025', '10', '2018-05-14 04:54:39', NULL, '3', '2018-02-27', '0'),
('7880', '10', '1012', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3039'),
('7881', '30', '1026', '10', '2018-05-14 04:56:07', NULL, '3', '2018-03-02', '0'),
('7882', '13', '1026', '10', '2018-05-14 04:56:07', NULL, '3', '2018-03-02', '0'),
('7883', '10', '1013', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-02', '3079'),
('7884', '30', '1027', '10', '2018-05-14 04:58:03', NULL, '3', '2018-03-02', '0'),
('7885', '13', '1027', '10', '2018-05-14 04:58:03', NULL, '3', '2018-03-02', '0'),
('7886', '10', '1014', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-02', '3080'),
('7887', '30', '1028', '10', '2018-05-14 05:00:42', NULL, '3', '2018-03-02', '0'),
('7888', '13', '1028', '10', '2018-05-14 05:00:42', NULL, '3', '2018-03-02', '0'),
('7889', '10', '1015', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-02', '3081'),
('7890', '30', '1029', '10', '2018-05-14 05:02:49', NULL, '3', '2018-03-06', '0'),
('7891', '13', '1029', '10', '2018-05-14 05:02:49', NULL, '3', '2018-03-06', '0'),
('7892', '10', '1016', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-06', '3108'),
('7893', '30', '1030', '10', '2018-05-14 05:06:47', NULL, '3', '2018-03-07', '0'),
('7894', '13', '1030', '10', '2018-05-14 05:06:47', NULL, '3', '2018-03-07', '0'),
('7895', '10', '1017', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-07', '3115'),
('7896', '30', '1031', '10', '2018-05-14 05:08:45', NULL, '3', '2018-03-08', '0'),
('7897', '13', '1031', '10', '2018-05-14 05:08:45', NULL, '3', '2018-03-08', '0'),
('7898', '10', '1018', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-08', '3122'),
('7899', '30', '1032', '10', '2018-05-14 05:10:19', NULL, '3', '2018-03-13', '0'),
('7900', '13', '1032', '10', '2018-05-14 05:10:19', NULL, '3', '2018-03-13', '0'),
('7901', '10', '1019', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3160'),
('7902', '30', '1033', '10', '2018-05-14 05:11:57', NULL, '3', '2018-03-16', '0'),
('7903', '13', '1033', '10', '2018-05-14 05:11:57', NULL, '3', '2018-03-16', '0'),
('7904', '10', '1020', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-16', '3182'),
('7905', '30', '1034', '10', '2018-05-14 05:13:44', NULL, '3', '2018-03-16', '0'),
('7906', '13', '1034', '10', '2018-05-14 05:13:44', NULL, '3', '2018-03-16', '0'),
('7907', '10', '1021', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-16', '3183'),
('7908', '30', '1035', '10', '2018-05-14 05:15:33', NULL, '3', '2018-03-16', '0'),
('7909', '13', '1035', '10', '2018-05-14 05:15:33', NULL, '3', '2018-03-16', '0'),
('7910', '10', '1022', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-16', '3184'),
('7911', '30', '1036', '10', '2018-05-14 05:16:23', NULL, '3', '2018-03-16', '0'),
('7912', '13', '1036', '10', '2018-05-14 05:16:23', NULL, '3', '2018-03-16', '0'),
('7913', '10', '1023', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-16', '3185'),
('7914', '30', '1037', '10', '2018-05-14 05:18:26', NULL, '3', '2018-03-23', '0'),
('7915', '13', '1037', '10', '2018-05-14 05:18:26', NULL, '3', '2018-03-23', '0'),
('7916', '10', '1024', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-23', '3228'),
('7917', '30', '1038', '10', '2018-05-14 05:19:12', NULL, '3', '2018-03-26', '0'),
('7918', '13', '1038', '10', '2018-05-14 05:19:12', NULL, '3', '2018-03-26', '0'),
('7919', '10', '1025', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-26', '3238'),
('7920', '30', '1039', '10', '2018-05-14 05:22:18', NULL, '5', '2018-04-02', '0'),
('7921', '13', '1039', '10', '2018-05-14 05:22:18', NULL, '5', '2018-04-02', '0'),
('7922', '10', '1026', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-02', '5'),
('7923', '1', '2358', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-14', '378'),
('7924', '30', '1040', '10', '2018-05-14 22:32:16', NULL, '3', '2018-01-31', '0'),
('7925', '13', '1040', '10', '2018-05-14 22:32:16', NULL, '3', '2018-01-31', '0'),
('7926', '10', '1027', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-31', '2792'),
('7927', '1', '2359', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '386'),
('7928', '12', '614', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-15', '717'),
('7929', '30', '1041', '10', '2018-05-15 00:37:48', NULL, '5', '2018-05-10', '0'),
('7930', '13', '1041', '10', '2018-05-15 00:37:48', NULL, '5', '2018-05-10', '0'),
('7931', '10', '1028', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-10', '355'),
('7932', '12', '615', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '387'),
('7933', '1', '2360', '10', '2018-05-15 01:59:55', NULL, '5', '2018-05-15', NULL),
('7934', '1', '2361', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '388'),
('7935', '1', '2360', '10', '2018-05-15 01:59:55', 'Voided.\nDocument reentered.', '5', '2018-05-15', '0'),
('7936', '1', '2362', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '389'),
('7937', '30', '1042', '10', '2018-05-15 03:58:21', NULL, '5', '2018-05-15', '0'),
('7938', '13', '1042', '10', '2018-05-15 04:00:00', NULL, '5', '2018-05-15', NULL),
('7939', '10', '1029', '10', '2018-05-15 04:00:00', NULL, '5', '2018-05-15', NULL),
('7940', '30', '1043', '10', '2018-05-15 03:59:25', NULL, '5', '2018-05-15', '0'),
('7941', '13', '1043', '10', '2018-05-17 04:15:41', NULL, '5', '2018-05-15', NULL),
('7942', '13', '1042', '10', '2018-05-15 04:00:00', 'Voided.', '5', '2018-05-15', '0'),
('7943', '10', '1029', '10', '2018-05-15 04:00:00', 'Voided.\n', '5', '2018-05-15', '0'),
('7944', '1', '2363', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '390'),
('7945', '1', '2364', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '391'),
('7946', '1', '2365', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '392'),
('7947', '1', '2366', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '393'),
('7948', '12', '616', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-12', '117'),
('7949', '11', '112', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-30', '261'),
('7950', '1', '2367', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '408'),
('7951', '1', '2368', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '409'),
('7952', '1', '2369', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '410'),
('7953', '1', '2370', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '411'),
('7954', '1', '2371', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '412'),
('7955', '1', '2372', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '413'),
('7956', '30', '1044', '10', '2018-05-17 04:12:41', NULL, '5', '2018-05-15', '0'),
('7957', '13', '1044', '10', '2018-05-17 04:12:41', NULL, '5', '2018-05-15', '0'),
('7958', '10', '1030', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '394'),
('7959', '13', '1043', '10', '2018-05-17 04:15:41', 'Voided.\n', '5', '2018-05-17', '0'),
('7960', '12', '617', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '431'),
('7961', '1', '2373', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-16', '406'),
('7962', '30', '1045', '10', '2018-05-18 02:39:38', NULL, '3', '2018-02-27', '0'),
('7963', '13', '1045', '10', '2018-05-18 02:39:39', NULL, '3', '2018-02-27', '0'),
('7964', '10', '1031', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-27', '3040'),
('7965', '30', '1046', '10', '2018-05-18 02:44:13', NULL, '5', '2018-04-19', '0'),
('7966', '13', '1046', '10', '2018-05-18 02:44:13', NULL, '5', '2018-04-19', '0'),
('7967', '10', '1032', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-19', '147'),
('7968', '30', '1047', '10', '2018-05-18 02:47:54', NULL, '5', '2018-04-19', '0'),
('7969', '13', '1047', '10', '2018-05-18 02:47:54', NULL, '5', '2018-04-19', '0'),
('7970', '10', '1033', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-19', '148'),
('7971', '30', '1048', '10', '2018-05-18 02:51:12', NULL, '5', '2018-04-19', '0'),
('7972', '13', '1048', '10', '2018-05-18 02:51:12', NULL, '5', '2018-04-19', '0'),
('7973', '10', '1034', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-19', '149'),
('7974', '30', '1049', '10', '2018-05-18 02:52:26', NULL, '5', '2018-05-03', '0'),
('7975', '13', '1049', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '296'),
('7976', '10', '1035', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '297'),
('7977', '30', '1050', '10', '2018-05-18 02:52:58', NULL, '5', '2018-05-03', '0'),
('7978', '13', '1050', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '298'),
('7979', '10', '1036', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '299'),
('7980', '30', '1051', '10', '2018-05-18 02:53:46', NULL, '5', '2018-05-03', '0'),
('7981', '13', '1051', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '300'),
('7982', '10', '1037', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '301'),
('7983', '30', '1052', '10', '2018-05-18 02:54:36', NULL, '5', '2018-05-03', '0'),
('7984', '13', '1052', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '302'),
('7985', '10', '1038', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '303'),
('7986', '30', '1053', '10', '2018-05-18 02:55:03', NULL, '5', '2018-05-03', '0'),
('7987', '13', '1053', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '304'),
('7988', '10', '1039', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '305'),
('7989', '30', '1054', '10', '2018-05-18 02:55:32', NULL, '5', '2018-05-03', '0'),
('7990', '13', '1054', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '306'),
('7991', '10', '1040', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-03', '307'),
('7992', '30', '1055', '10', '2018-05-18 02:57:45', NULL, '5', '2018-05-15', '0'),
('7993', '13', '1055', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '395'),
('7994', '10', '1041', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '396'),
('7995', '30', '1056', '10', '2018-05-18 03:17:41', NULL, '5', '2018-05-15', '0'),
('7996', '13', '1056', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '397'),
('7997', '10', '1042', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '398'),
('7998', '30', '1057', '10', '2018-05-18 03:19:27', NULL, '5', '2018-05-15', '0'),
('7999', '13', '1057', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '399'),
('8000', '10', '1043', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '400'),
('8001', '30', '1058', '10', '2018-05-18 03:20:16', NULL, '5', '2018-05-15', '0'),
('8002', '13', '1058', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '401'),
('8003', '10', '1044', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '402'),
('8004', '30', '1059', '10', '2018-05-18 03:21:02', NULL, '5', '2018-05-15', '0'),
('8005', '13', '1059', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '403'),
('8006', '10', '1045', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '404'),
('8007', '30', '1060', '10', '2018-05-18 03:22:44', NULL, '5', '2018-05-18', '0'),
('8008', '13', '1060', '10', '2018-11-15 05:06:04', NULL, '5', '2018-05-18', NULL),
('8009', '10', '1046', '10', '2018-11-15 05:06:04', NULL, '5', '2018-05-18', NULL),
('8010', '11', '113', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '432'),
('8011', '30', '1061', '10', '2018-05-18 03:26:55', NULL, '5', '2018-05-18', '0'),
('8012', '13', '1061', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '433'),
('8013', '10', '1047', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '434'),
('8014', '1', '2374', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '435'),
('8015', '1', '2375', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '436'),
('8016', '1', '2376', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '437'),
('8017', '1', '2377', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '438'),
('8018', '16', '36', '10', '2018-05-18 05:59:28', NULL, '5', '2018-05-21', '0'),
('8019', '16', '37', '10', '2018-05-21 23:06:56', NULL, '5', '2018-05-22', '0'),
('8020', '18', '42', '10', '2018-05-22 00:41:20', NULL, '5', '2018-05-22', '0'),
('8021', '25', '41', '10', '2018-05-22 00:41:20', NULL, '5', '2018-05-22', '0'),
('8022', '1', '2378', '10', '2018-07-02 01:46:14', NULL, '5', '2018-05-22', NULL),
('8023', '1', '2379', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '463'),
('8024', '1', '2380', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '464'),
('8025', '1', '2381', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '465'),
('8026', '1', '2382', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '466'),
('8027', '1', '2383', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '467'),
('8028', '1', '2384', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '468'),
('8029', '1', '2385', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '469'),
('8030', '12', '618', '10', '2018-06-29 02:11:14', NULL, '5', '2018-06-14', NULL),
('8031', '12', '619', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '655'),
('8032', '12', '620', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '470'),
('8033', '12', '621', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '471'),
('8034', '12', '622', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-21', '456'),
('8035', '12', '623', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-21', '457'),
('8036', '11', '114', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '472'),
('8037', '11', '115', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '473'),
('8038', '11', '116', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '474'),
('8039', '1', '2386', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '475'),
('8040', '1', '2387', '10', '2018-08-08 06:07:39', NULL, '5', '2018-05-23', NULL),
('8041', '1', '2388', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-25', '512'),
('8042', '1', '2389', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '481'),
('8043', '12', '624', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '482'),
('8044', '11', '117', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '525'),
('8045', '11', '118', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '526'),
('8046', '12', '625', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '527'),
('8047', '12', '626', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '528'),
('8048', '12', '627', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '529'),
('8049', '12', '628', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '530'),
('8050', '12', '629', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '531'),
('8051', '12', '630', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '532'),
('8052', '12', '631', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '533'),
('8053', '12', '632', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '534'),
('8054', '12', '633', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '610'),
('8055', '12', '634', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '535'),
('8056', '12', '635', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '536'),
('8057', '1', '2390', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '537'),
('8058', '1', '2391', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '538'),
('8059', '1', '2392', '10', '2018-05-28 06:16:38', NULL, '5', '2018-05-28', NULL),
('8060', '1', '2393', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '483'),
('8061', '1', '2394', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '484'),
('8062', '1', '2395', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '485'),
('8063', '1', '2396', '10', '2018-08-03 02:03:32', NULL, '5', '2018-05-23', NULL),
('8064', '1', '2397', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '486'),
('8065', '1', '2398', '10', '2018-07-21 06:58:42', NULL, '5', '2018-05-23', NULL),
('8066', '2', '111', '10', '2018-08-15 08:33:12', NULL, '5', '2018-05-23', NULL),
('8067', '1', '2399', '10', '2018-07-24 00:38:54', NULL, '5', '2018-05-25', NULL),
('8068', '1', '2400', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '539'),
('8069', '1', '2392', '10', '2018-05-28 06:16:38', 'Voided.\nDocument reentered.', '5', '2018-05-28', '0'),
('8070', '30', '1062', '10', '2018-05-29 23:21:47', NULL, '5', '2018-05-02', '0'),
('8071', '13', '1062', '10', '2018-05-29 23:21:47', NULL, '5', '2018-05-02', '0'),
('8072', '10', '1048', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-02', '279'),
('8073', '30', '1063', '10', '2018-05-29 23:24:43', NULL, '5', '2018-05-08', '0'),
('8074', '13', '1063', '10', '2018-05-29 23:24:43', NULL, '5', '2018-05-08', '0'),
('8075', '10', '1049', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '330'),
('8076', '30', '1064', '10', '2018-05-29 23:27:30', NULL, '5', '2018-05-09', '0'),
('8077', '13', '1064', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-09', '346'),
('8078', '10', '1050', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-09', '347'),
('8079', '30', '1065', '10', '2018-05-29 23:29:18', NULL, '5', '2018-05-11', '0'),
('8080', '13', '1065', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-11', '364'),
('8081', '10', '1051', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-11', '365'),
('8082', '30', '1066', '10', '2018-05-29 23:32:52', NULL, '5', '2018-05-14', '0'),
('8083', '13', '1066', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-14', '379'),
('8084', '10', '1052', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-14', '380'),
('8085', '30', '1067', '10', '2018-05-29 23:34:23', NULL, '5', '2018-05-14', '0'),
('8086', '13', '1067', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-14', '381'),
('8087', '10', '1053', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-14', '382'),
('8088', '30', '1068', '10', '2018-05-29 23:45:43', NULL, '5', '2018-05-17', '0'),
('8089', '13', '1068', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '414'),
('8090', '10', '1054', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '415'),
('8091', '30', '1069', '10', '2018-05-29 23:50:50', NULL, '5', '2018-05-17', '0'),
('8092', '13', '1069', '10', '2018-05-29 23:50:50', NULL, '5', '2018-05-17', '0'),
('8093', '10', '1055', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '416'),
('8094', '30', '1070', '10', '2018-05-29 23:54:07', NULL, '5', '2018-05-17', '0'),
('8095', '13', '1070', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '417'),
('8096', '10', '1056', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '418'),
('8097', '30', '1071', '10', '2018-05-29 23:57:54', NULL, '5', '2018-05-18', '0'),
('8098', '13', '1071', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '439'),
('8099', '10', '1057', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '440'),
('8100', '30', '1072', '10', '2018-05-30 00:03:38', NULL, '5', '2018-05-18', '0'),
('8101', '13', '1072', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '441'),
('8102', '10', '1058', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '442'),
('8103', '30', '1073', '10', '2018-05-30 00:05:20', NULL, '5', '2018-05-22', '0'),
('8104', '13', '1073', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '476'),
('8105', '10', '1059', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '477'),
('8106', '30', '1074', '10', '2018-05-30 00:19:00', NULL, '5', '2018-05-24', '0'),
('8107', '13', '1074', '10', '2018-05-30 00:19:00', NULL, '5', '2018-05-24', '0'),
('8108', '10', '1060', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-24', '506'),
('8109', '30', '1075', '10', '2018-05-30 00:20:40', NULL, '5', '2018-05-24', '0'),
('8110', '13', '1075', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-24', '507'),
('8111', '10', '1061', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-24', '508'),
('8112', '30', '1076', '10', '2018-05-30 00:22:40', NULL, '5', '2018-05-24', '0'),
('8113', '13', '1076', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-24', '509'),
('8114', '10', '1062', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-24', '510'),
('8115', '30', '1077', '10', '2018-05-30 00:57:53', NULL, '5', '2018-04-05', '0'),
('8116', '13', '1077', '10', '2018-05-30 00:57:53', NULL, '5', '2018-04-05', '0'),
('8117', '10', '1063', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '55'),
('8118', '30', '1078', '10', '2018-05-30 00:59:09', NULL, '5', '2018-04-06', '0'),
('8119', '13', '1078', '10', '2018-05-30 00:59:09', NULL, '5', '2018-04-06', '0'),
('8120', '10', '1064', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '77'),
('8121', '30', '1079', '10', '2018-05-30 01:00:35', NULL, '5', '2018-04-11', '0'),
('8122', '13', '1079', '10', '2018-05-30 01:00:35', NULL, '5', '2018-04-11', '0'),
('8123', '10', '1065', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-11', '113'),
('8124', '30', '1080', '10', '2018-05-30 01:02:44', NULL, '5', '2018-04-23', '0'),
('8125', '13', '1080', '10', '2018-05-30 01:02:44', NULL, '5', '2018-04-23', '0'),
('8126', '10', '1066', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-23', '193'),
('8127', '1', '2401', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-30', '547'),
('8128', '1', '2402', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-30', '548'),
('8129', '1', '2403', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-30', '549'),
('8130', '1', '2404', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-30', '550'),
('8131', '2', '112', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-30', '551'),
('8132', '1', '2405', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-30', '552'),
('8133', '1', '2406', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-30', '262'),
('8134', '1', '2407', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-30', '263'),
('8135', '1', '2408', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '245'),
('8136', '1', '2409', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '246'),
('8137', '1', '2410', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '247'),
('8138', '1', '2411', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '248'),
('8139', '1', '2412', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '249'),
('8140', '1', '2413', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '250'),
('8141', '1', '2414', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-26', '227'),
('8142', '1', '2415', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-26', '228'),
('8143', '1', '2416', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-17', '138'),
('8144', '2', '113', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-01', '1'),
('8145', '1', '2417', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '251'),
('8146', '2', '114', '10', '2019-11-06 07:45:22', NULL, '6', '2018-04-27', NULL),
('8147', '1', '2418', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '557'),
('8148', '1', '2419', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '558'),
('8149', '1', '2420', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '559'),
('8150', '1', '2421', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '560'),
('8151', '1', '2422', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '561'),
('8152', '1', '2423', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '562'),
('8153', '1', '2424', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-01', '575'),
('8154', '1', '2425', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-01', '576'),
('8155', '1', '2426', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-01', '577'),
('8156', '1', '2427', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-01', '578'),
('8157', '1', '2428', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-01', '579'),
('8158', '1', '2429', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-01', '580'),
('8159', '1', '2430', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-01', '581'),
('8160', '30', '1081', '10', '2018-06-01 06:41:17', NULL, '5', '2018-05-28', '0'),
('8161', '13', '1081', '10', '2018-06-01 06:41:17', NULL, '5', '2018-05-28', '0'),
('8162', '10', '1067', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '540'),
('8163', '12', '636', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-01', '582'),
('8164', '1', '2431', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '541'),
('8165', '1', '2432', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '542'),
('8166', '1', '2433', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-04', '585'),
('8167', '1', '2434', '10', '2018-06-04 03:20:49', NULL, '5', '2018-06-04', NULL),
('8168', '1', '2435', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-04', '586'),
('8169', '1', '2434', '10', '2018-06-04 03:20:49', 'Voided.\nDocument reentered.', '5', '2018-06-04', '0'),
('8170', '1', '2436', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-04', '587'),
('8171', '1', '2437', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-04', '588'),
('8172', '1', '2438', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-04', '589'),
('8173', '20', '111', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-30', '553'),
('8174', '20', '112', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-24', '511'),
('8175', '20', '113', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-09', '348'),
('8176', '22', '45', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-04', '590'),
('8177', '1', '2439', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-04', '591'),
('8178', '1', '2440', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-04', '592'),
('8179', '30', '1082', '10', '2018-06-05 22:34:59', NULL, '5', '2018-04-26', '0'),
('8180', '13', '1082', '10', '2018-06-05 22:34:59', NULL, '5', '2018-04-26', '0'),
('8181', '10', '1068', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-26', '229'),
('8182', '12', '637', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-06', '602'),
('8183', '1', '2441', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-06', '603'),
('8184', '1', '2442', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-06', '604'),
('8185', '1', '2443', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-06', '605'),
('8186', '1', '2444', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-06', '606'),
('8187', '1', '2445', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-06', '607'),
('8188', '1', '2446', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '611'),
('8189', '1', '2447', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '612'),
('8190', '1', '2448', '10', '2018-06-07 06:31:08', NULL, '5', '2018-06-07', NULL),
('8191', '1', '2449', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '613'),
('8192', '1', '2450', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '614'),
('8193', '1', '2451', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '615'),
('8194', '1', '2452', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '616'),
('8195', '1', '2453', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '617'),
('8196', '1', '2454', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '618'),
('8197', '12', '638', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '619'),
('8198', '1', '2455', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '620'),
('8199', '1', '2448', '10', '2018-06-07 06:31:08', 'Voided.\nDocument reentered.', '5', '2018-06-07', '0'),
('8200', '1', '2456', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-08', '634'),
('8201', '1', '2457', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-08', '635'),
('8202', '1', '2458', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-08', '636'),
('8203', '1', '2459', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-08', '637'),
('8204', '1', '2460', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-08', '638'),
('8205', '1', '2461', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-08', '639'),
('8206', '1', '2462', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-08', '640'),
('8207', '16', '38', '10', '2018-06-10 23:26:54', NULL, '5', '2018-06-11', '0'),
('8208', '16', '39', '10', '2018-06-10 23:27:14', NULL, '5', '2018-06-11', '0'),
('8209', '16', '40', '10', '2018-06-10 23:59:40', NULL, '5', '2018-06-11', '0'),
('8210', '1', '2463', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '656'),
('8211', '1', '2464', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '657'),
('8212', '1', '2465', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '658'),
('8213', '1', '2466', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '659'),
('8214', '1', '2467', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '660'),
('8215', '22', '46', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '661'),
('8216', '1', '2468', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '662'),
('8217', '12', '639', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '663'),
('8218', '1', '2469', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '664'),
('8219', '12', '640', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '679'),
('8220', '1', '2470', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-22', '3222'),
('8221', '4', '95', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-17', '139'),
('8222', '4', '96', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-06', '78'),
('8223', '1', '2471', '10', '2018-07-24 00:17:12', NULL, '5', '2018-05-06', NULL),
('8224', '1', '2472', '10', '2018-07-24 00:17:43', NULL, '5', '2018-05-08', NULL),
('8225', '1', '2473', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '680'),
('8226', '1', '2474', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '681'),
('8227', '1', '2475', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '682'),
('8228', '1', '2476', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '683'),
('8229', '1', '2477', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '684'),
('8230', '1', '2478', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '685'),
('8231', '1', '2479', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '686'),
('8232', '1', '2480', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '687'),
('8233', '12', '641', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '688'),
('8234', '11', '119', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-14', '710'),
('8235', '1', '2481', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-14', '711'),
('8236', '1', '2482', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-14', '712'),
('8237', '1', '2483', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-14', '713'),
('8238', '18', '43', '10', '2018-06-14 07:01:55', NULL, '5', '2018-05-05', '0'),
('8239', '25', '42', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-05', '316'),
('8240', '20', '114', '10', '2018-06-14 07:04:46', NULL, '5', '2018-05-05', NULL),
('8241', '20', '114', '10', '2018-06-14 07:04:46', 'Voided.\n', '5', '2018-06-14', '0'),
('8242', '18', '44', '10', '2018-06-14 07:05:38', NULL, '5', '2018-05-08', '0'),
('8243', '25', '43', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '331'),
('8244', '20', '115', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '332'),
('8245', '18', '45', '10', '2018-06-14 07:06:37', NULL, '5', '2018-05-08', '0'),
('8246', '25', '44', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '333'),
('8247', '20', '116', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '334'),
('8248', '22', '47', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-14', '714'),
('8249', '1', '2484', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-14', '715'),
('8250', '30', '1083', '10', '2018-06-15 01:44:37', NULL, '3', '2017-09-29', '0'),
('8251', '13', '1083', '10', '2018-06-15 01:44:37', NULL, '3', '2017-09-29', '0'),
('8252', '10', '1069', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1679'),
('8253', '30', '1084', '10', '2018-06-15 02:07:50', NULL, '3', '2017-09-29', '0'),
('8254', '13', '1084', '10', '2018-06-15 02:07:50', NULL, '3', '2017-09-29', '0'),
('8255', '10', '1070', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1680'),
('8256', '30', '1085', '10', '2018-06-15 02:14:32', NULL, '3', '2017-09-29', '0'),
('8257', '13', '1085', '10', '2018-06-15 02:14:32', NULL, '3', '2017-09-29', '0'),
('8258', '10', '1071', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1681'),
('8259', '30', '1086', '10', '2018-06-15 02:16:13', NULL, '3', '2017-09-29', '0'),
('8260', '13', '1086', '10', '2018-06-15 02:16:13', NULL, '3', '2017-09-29', '0'),
('8261', '10', '1072', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1682'),
('8262', '30', '1087', '10', '2018-06-15 02:23:11', NULL, '3', '2017-09-29', '0'),
('8263', '13', '1087', '10', '2018-06-15 02:23:11', NULL, '3', '2017-09-29', '0'),
('8264', '10', '1073', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1683'),
('8265', '11', '120', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1684'),
('8266', '16', '41', '10', '2018-06-15 03:40:53', NULL, '5', '2018-06-15', '0'),
('8267', '30', '1088', '10', '2018-06-15 04:13:28', NULL, '5', '2018-05-10', '0'),
('8268', '13', '1088', '10', '2018-06-15 04:13:28', NULL, '5', '2018-05-10', '0'),
('8269', '10', '1074', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-10', '356'),
('8270', '12', '642', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-15', '718'),
('8271', '1', '2485', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-15', '719'),
('8272', '1', '2486', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-15', '720'),
('8273', '1', '2487', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-15', '721'),
('8274', '1', '2488', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-15', '722'),
('8275', '1', '2489', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-18', '728'),
('8276', '30', '1089', '10', '2018-06-18 05:18:35', NULL, '5', '2018-05-30', '0'),
('8277', '13', '1089', '10', '2018-06-18 05:18:35', NULL, '5', '2018-05-30', '0'),
('8278', '10', '1075', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-30', '554'),
('8279', '12', '643', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-10', '1018'),
('8280', '12', '644', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '744'),
('8281', '1', '2490', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-18', '729'),
('8282', '1', '2491', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-18', '730'),
('8283', '1', '2492', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '745'),
('8284', '1', '2493', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '746'),
('8285', '1', '2494', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '747'),
('8286', '11', '121', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '748'),
('8287', '12', '645', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '749'),
('8288', '1', '2495', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '750'),
('8289', '1', '2496', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '751'),
('8290', '1', '2497', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '752'),
('8291', '1', '2498', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '753'),
('8292', '1', '2499', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '754'),
('8293', '1', '2500', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '755'),
('8294', '1', '2501', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-20', '762'),
('8295', '1', '2502', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-20', '763'),
('8296', '1', '2503', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '774'),
('8297', '30', '1090', '10', '2018-06-21 00:44:42', NULL, '5', '2018-06-13', '0'),
('8298', '13', '1090', '10', '2018-06-21 00:44:42', NULL, '5', '2018-06-13', '0'),
('8299', '10', '1076', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '689'),
('8300', '12', '646', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '775'),
('8301', '1', '2504', '10', '2018-10-15 02:11:00', NULL, '5', '2018-06-21', NULL),
('8302', '1', '2505', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '776'),
('8303', '1', '2506', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '777'),
('8304', '1', '2507', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '778'),
('8305', '1', '2508', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '779'),
('8306', '30', '1091', '10', '2018-06-22 03:20:44', NULL, '5', '2018-06-22', '0'),
('8307', '13', '1091', '10', '2018-06-22 03:20:44', NULL, '5', '2018-06-22', '0'),
('8308', '10', '1077', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '797'),
('8309', '12', '647', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '798'),
('8310', '1', '2509', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '799'),
('8311', '1', '2510', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '800'),
('8312', '1', '2511', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-25', '825'),
('8313', '11', '122', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-25', '826'),
('8314', '12', '648', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '996'),
('8315', '12', '649', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-28', '867'),
('8316', '12', '650', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '879'),
('8317', '12', '651', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-06', '1313'),
('8318', '12', '652', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-25', '827'),
('8319', '1', '2512', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-25', '828'),
('8320', '1', '2513', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-25', '829'),
('8321', '1', '2514', '10', '2018-06-25 06:19:34', NULL, '5', '2018-06-25', NULL),
('8322', '1', '2515', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-25', '830'),
('8323', '1', '2514', '10', '2018-06-25 06:19:34', 'Voided.\nDocument reentered.', '5', '2018-06-25', '0'),
('8324', '1', '2516', '1', '2018-07-04 01:45:13', NULL, '5', '2018-06-26', NULL),
('8325', '1', '2517', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-20', '764'),
('8326', '1', '2518', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '842'),
('8327', '1', '2519', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-15', '723'),
('8328', '1', '2520', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-12', '676'),
('8329', '12', '653', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-10', '1019'),
('8330', '12', '654', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '843'),
('8331', '1', '2521', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '844'),
('8332', '1', '2522', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '845'),
('8333', '1', '2523', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '846'),
('8334', '1', '2524', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '847'),
('8335', '1', '2525', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '848'),
('8336', '1', '2526', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '849'),
('8337', '1', '2527', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-28', '868'),
('8338', '1', '2528', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-28', '869'),
('8339', '1', '2529', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-28', '870'),
('8340', '1', '2530', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-28', '871'),
('8341', '12', '655', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '880'),
('8342', '1', '2531', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '881'),
('8343', '1', '2532', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '882'),
('8344', '1', '2533', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '883'),
('8345', '1', '2534', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '884'),
('8346', '1', '2535', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '885'),
('8347', '1', '2536', '10', '2018-08-08 06:08:48', NULL, '5', '2018-06-29', NULL),
('8348', '12', '618', '10', '2018-06-29 02:11:14', 'Voided.\nCHQ Returned.CHQ 592543\nBOC', '5', '2018-06-29', '0'),
('8349', '1', '2537', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '886'),
('8350', '1', '2538', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '887'),
('8351', '1', '2539', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '888'),
('8352', '1', '2540', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '889'),
('8353', '12', '656', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-20', '1442'),
('8354', '1', '2541', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1573'),
('8355', '30', '1092', '10', '2018-06-29 06:56:40', NULL, '5', '2018-06-29', '0'),
('8356', '13', '1092', '10', '2018-06-29 06:56:40', NULL, '5', '2018-06-29', '0'),
('8357', '10', '1078', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '890'),
('8358', '2', '115', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '891'),
('8359', '1', '2542', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '892'),
('8360', '12', '485', '10', '2018-07-02 01:40:10', 'Voided.\nDuplicate Entry', '5', '2018-07-02', '0'),
('8361', '1', '2543', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '478'),
('8362', '1', '2378', '10', '2018-07-02 01:46:14', 'Voided.\nDocument reentered.', '5', '2018-07-02', '0'),
('8363', '1', '2544', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '920'),
('8364', '1', '2545', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '921'),
('8365', '1', '2546', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '893'),
('8366', '1', '2547', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '894'),
('8367', '16', '42', '10', '2018-07-02 06:12:19', NULL, '5', '2018-06-25', '0'),
('8368', '30', '1093', '10', '2018-07-03 01:33:08', NULL, '5', '2018-05-13', '0'),
('8369', '13', '1093', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-13', '371'),
('8370', '10', '1079', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-13', '372'),
('8371', '30', '1094', '10', '2018-07-03 01:36:36', NULL, '5', '2018-05-17', '0'),
('8372', '13', '1094', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '419'),
('8373', '10', '1080', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '420'),
('8374', '30', '1095', '10', '2018-07-03 01:38:03', NULL, '5', '2018-05-19', '0'),
('8375', '13', '1095', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-19', '452'),
('8376', '10', '1081', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-19', '453'),
('8377', '11', '123', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '563'),
('8378', '11', '124', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '564'),
('8379', '1', '2548', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-03', '940'),
('8380', '1', '2549', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-03', '941'),
('8381', '1', '2550', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-03', '942'),
('8382', '1', '2551', '10', '2018-09-18 02:06:54', NULL, '5', '2018-07-03', NULL),
('8383', '1', '2552', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-03', '943'),
('8384', '30', '1096', '10', '2018-07-03 05:26:39', NULL, '5', '2018-07-03', '0'),
('8385', '13', '1096', '10', '2018-07-03 05:26:39', NULL, '5', '2018-07-03', '0'),
('8386', '10', '1082', '10', '2018-07-30 02:35:55', NULL, '5', '2018-07-03', NULL),
('8387', '1', '2553', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-03', '944'),
('8388', '1', '2516', '10', '2018-07-04 01:45:13', 'Voided.\nTest Transaction', '5', '2018-07-04', '0'),
('8389', '11', '125', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-03', '945'),
('8390', '11', '126', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-03', '946'),
('8391', '11', '127', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-03', '947'),
('8392', '11', '128', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-03', '948'),
('8393', '11', '129', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-03', '949'),
('8394', '30', '1097', '10', '2018-07-04 02:27:11', NULL, '3', '2017-11-01', '0'),
('8395', '13', '1097', '10', '2018-08-06 06:17:09', NULL, '5', '2017-11-01', NULL),
('8396', '10', '1083', '10', '2018-08-06 06:17:09', NULL, '5', '2017-11-01', NULL),
('8397', '30', '1098', '10', '2018-07-04 02:32:40', NULL, '3', '2017-11-01', '0'),
('8398', '13', '1098', '10', '2018-07-04 02:32:41', NULL, '3', '2017-11-01', '0'),
('8399', '10', '1084', '10', '2018-08-02 23:45:34', NULL, '5', '2017-11-01', NULL),
('8400', '11', '130', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '955'),
('8401', '1', '2554', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '956'),
('8402', '30', '1099', '10', '2018-07-04 04:50:02', NULL, '5', '2018-07-04', '0'),
('8403', '13', '1099', '10', '2018-07-04 04:50:02', NULL, '5', '2018-07-04', '0'),
('8404', '10', '1085', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '957'),
('8405', '30', '1100', '10', '2018-07-04 04:52:13', NULL, '5', '2018-07-04', '0'),
('8406', '13', '1100', '10', '2018-07-04 04:52:13', NULL, '5', '2018-07-04', '0'),
('8407', '10', '1086', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '958'),
('8408', '1', '2555', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '959'),
('8409', '1', '2556', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '960'),
('8410', '1', '2557', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '961'),
('8411', '1', '2558', '10', '2018-07-04 05:45:11', NULL, '5', '2018-07-04', NULL),
('8412', '1', '2559', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '962'),
('8413', '1', '2558', '10', '2018-07-04 05:45:11', 'Voided.\nDocument reentered.', '5', '2018-07-04', '0'),
('8414', '1', '2560', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '963'),
('8415', '30', '1101', '10', '2018-07-05 01:21:50', NULL, '5', '2018-05-18', '0'),
('8416', '13', '1101', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '443'),
('8417', '10', '1087', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '444'),
('8418', '30', '1102', '10', '2018-07-05 01:24:52', NULL, '5', '2018-05-23', '0'),
('8419', '13', '1102', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '487'),
('8420', '10', '1088', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '488'),
('8421', '1', '2561', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-05', '973'),
('8422', '12', '572', '10', '2018-07-05 02:54:33', 'Voided.\nCHQ Returned', '5', '2018-07-05', '0'),
('8423', '1', '2562', '10', '2018-07-08 23:28:56', NULL, '5', '2018-07-05', NULL),
('8424', '1', '2563', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-05', '974'),
('8425', '12', '657', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-06', '982'),
('8426', '12', '658', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-06', '983'),
('8427', '1', '2564', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-06', '984'),
('8428', '1', '2565', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-06', '985'),
('8429', '16', '43', '10', '2018-07-06 06:18:35', NULL, '5', '2018-07-06', '0'),
('8430', '16', '44', '10', '2018-07-06 06:18:55', NULL, '5', '2018-07-06', '0'),
('8431', '1', '2566', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-05', '975'),
('8432', '1', '2562', '10', '2018-07-08 23:28:56', 'Voided.\nDocument reentered.', '5', '2018-07-08', '0'),
('8433', '1', '2567', '10', '2018-07-08 23:35:08', NULL, '5', '2018-07-04', NULL),
('8434', '1', '2568', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '964'),
('8435', '1', '2567', '10', '2018-07-08 23:35:08', 'Voided.\nDocument reentered.', '5', '2018-07-08', '0'),
('8436', '1', '2569', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-05', '976'),
('8437', '1', '2570', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '997'),
('8438', '1', '2571', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '965'),
('8439', '1', '2572', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '998'),
('8440', '1', '2573', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '999'),
('8441', '1', '2574', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1000'),
('8442', '20', '117', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-28', '872'),
('8443', '20', '118', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '690'),
('8444', '22', '48', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1001'),
('8445', '30', '1103', '10', '2018-07-09 01:04:34', NULL, '5', '2018-07-06', '0'),
('8446', '13', '1103', '10', '2018-07-09 01:04:34', NULL, '5', '2018-07-06', '0'),
('8447', '10', '1089', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-06', '986'),
('8448', '12', '659', '10', '2018-07-09 01:42:41', NULL, '5', '2018-07-06', NULL),
('8449', '30', '1104', '10', '2018-07-09 01:08:19', NULL, '5', '2018-06-11', '0'),
('8450', '13', '1104', '10', '2018-07-09 01:08:19', NULL, '5', '2018-06-11', '0'),
('8451', '10', '1090', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '665'),
('8452', '12', '660', '10', '2018-07-09 01:42:13', NULL, '5', '2018-06-11', NULL),
('8453', '1', '2575', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1002'),
('8454', '12', '660', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-07-09', '1003'),
('8455', '12', '659', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-07-09', '1004'),
('8456', '1', '2576', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1005'),
('8457', '11', '131', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1006'),
('8458', '11', '132', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1007'),
('8459', '11', '133', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1008'),
('8460', '11', '134', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1009'),
('8461', '11', '135', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1010'),
('8462', '30', '1105', '10', '2018-07-09 02:35:14', NULL, '5', '2018-07-09', '0'),
('8463', '13', '1105', '10', '2019-01-09 00:40:38', NULL, '5', '2018-07-09', NULL),
('8464', '10', '1091', '10', '2018-07-10 22:21:18', NULL, '5', '2018-07-09', NULL),
('8465', '1', '2577', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1011'),
('8466', '1', '2578', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1012'),
('8467', '30', '1106', '10', '2018-07-09 22:34:51', NULL, '5', '2018-07-10', '0'),
('8468', '13', '1106', '10', '2018-07-09 22:34:51', NULL, '5', '2018-07-10', '0'),
('8469', '10', '1092', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-10', '1020'),
('8470', '30', '1107', '10', '2018-07-09 23:40:05', NULL, '5', '2018-07-10', '0'),
('8471', '13', '1107', '10', '2018-07-09 23:40:05', NULL, '5', '2018-07-10', '0'),
('8472', '10', '1093', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-10', '1021'),
('8473', '30', '1108', '10', '2018-07-09 23:43:10', NULL, '5', '2018-07-10', '0'),
('8474', '13', '1108', '10', '2018-07-09 23:43:10', NULL, '5', '2018-07-10', '0'),
('8475', '10', '1094', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-10', '1022'),
('8476', '1', '2579', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-10', '1023'),
('8477', '1', '2580', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-10', '1024'),
('8478', '1', '2581', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-10', '1025'),
('8479', '1', '2582', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-10', '1026'),
('8480', '10', '1091', '10', '2019-01-09 00:40:38', 'Updated.', '5', '2018-07-09', NULL);
INSERT INTO `0_audit_trail` VALUES
('8481', '30', '1109', '10', '2018-07-11 00:34:50', NULL, '5', '2018-05-28', '0'),
('8482', '13', '1109', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '543'),
('8483', '10', '1095', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '544'),
('8484', '30', '1110', '10', '2018-07-11 00:37:44', NULL, '5', '2018-05-31', '0'),
('8485', '13', '1110', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '565'),
('8486', '10', '1096', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '566'),
('8487', '30', '1111', '10', '2018-07-11 00:44:59', NULL, '5', '2018-05-31', '0'),
('8488', '13', '1111', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '567'),
('8489', '10', '1097', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '568'),
('8490', '30', '1112', '10', '2018-07-11 00:47:57', NULL, '5', '2018-05-31', '0'),
('8491', '13', '1112', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '569'),
('8492', '10', '1098', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '570'),
('8493', '30', '1113', '10', '2018-07-11 00:50:54', NULL, '5', '2018-06-11', '0'),
('8494', '13', '1113', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '666'),
('8495', '10', '1099', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '667'),
('8496', '30', '1114', '10', '2018-07-11 00:57:53', NULL, '5', '2018-06-11', '0'),
('8497', '13', '1114', '10', '2018-07-11 00:57:53', NULL, '5', '2018-06-11', '0'),
('8498', '10', '1100', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '668'),
('8499', '30', '1115', '10', '2018-07-11 00:59:54', NULL, '5', '2018-06-12', '0'),
('8500', '13', '1115', '10', '2018-07-11 00:59:54', NULL, '5', '2018-06-12', '0'),
('8501', '10', '1101', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-12', '677'),
('8502', '30', '1116', '10', '2018-07-11 01:06:36', NULL, '5', '2018-06-18', '0'),
('8503', '13', '1116', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-18', '731'),
('8504', '10', '1102', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-18', '732'),
('8505', '30', '1117', '10', '2018-07-11 01:09:54', NULL, '5', '2018-06-18', '0'),
('8506', '13', '1117', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-18', '733'),
('8507', '10', '1103', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-18', '734'),
('8508', '30', '1118', '10', '2018-07-11 01:12:01', NULL, '5', '2018-06-18', '0'),
('8509', '13', '1118', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-18', '735'),
('8510', '10', '1104', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-18', '736'),
('8511', '30', '1119', '10', '2018-07-11 01:13:19', NULL, '5', '2018-06-19', '0'),
('8512', '13', '1119', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '756'),
('8513', '10', '1105', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '757'),
('8514', '30', '1120', '10', '2018-07-11 01:17:45', NULL, '5', '2018-06-19', '0'),
('8515', '13', '1120', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '758'),
('8516', '10', '1106', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '759'),
('8517', '30', '1121', '10', '2018-07-11 01:20:25', NULL, '5', '2018-06-20', '0'),
('8518', '13', '1121', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-20', '765'),
('8519', '10', '1107', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-20', '766'),
('8520', '30', '1122', '10', '2018-07-11 01:22:02', NULL, '5', '2018-06-20', '0'),
('8521', '13', '1122', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-20', '767'),
('8522', '10', '1108', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-20', '768'),
('8523', '30', '1123', '10', '2018-07-11 01:25:14', NULL, '5', '2018-06-22', '0'),
('8524', '13', '1123', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '801'),
('8525', '10', '1109', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '802'),
('8526', '30', '1124', '10', '2018-07-11 01:27:07', NULL, '5', '2018-06-22', '0'),
('8527', '13', '1124', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '803'),
('8528', '10', '1110', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '804'),
('8529', '30', '1125', '10', '2018-07-11 01:32:39', NULL, '5', '2018-06-22', '0'),
('8530', '13', '1125', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '805'),
('8531', '10', '1111', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '806'),
('8532', '30', '1126', '10', '2018-07-11 01:34:08', NULL, '5', '2018-06-26', '0'),
('8533', '13', '1126', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '850'),
('8534', '10', '1112', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '851'),
('8535', '30', '1127', '10', '2018-07-11 01:35:42', NULL, '5', '2018-06-28', '0'),
('8536', '13', '1127', '10', '2018-07-11 01:35:42', NULL, '5', '2018-06-28', '0'),
('8537', '10', '1113', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-28', '873'),
('8538', '30', '1128', '10', '2018-07-11 01:37:19', NULL, '5', '2018-06-28', '0'),
('8539', '13', '1128', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-28', '874'),
('8540', '10', '1114', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-28', '875'),
('8541', '30', '1129', '10', '2018-07-11 01:38:36', NULL, '5', '2018-06-28', '0'),
('8542', '13', '1129', '10', '2018-07-11 01:38:36', NULL, '5', '2018-06-28', '0'),
('8543', '10', '1115', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-28', '876'),
('8544', '30', '1130', '10', '2018-07-11 01:39:43', NULL, '5', '2018-06-29', '0'),
('8545', '13', '1130', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '895'),
('8546', '10', '1116', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '896'),
('8547', '30', '1131', '10', '2018-07-11 01:40:59', NULL, '5', '2018-06-29', '0'),
('8548', '13', '1131', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '897'),
('8549', '10', '1117', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '898'),
('8550', '1', '2583', '10', '2018-07-11 02:06:16', NULL, '5', '2018-07-11', NULL),
('8551', '1', '2584', '10', '2018-07-11 02:07:53', NULL, '5', '2018-07-11', NULL),
('8552', '1', '2583', '10', '2018-07-11 02:06:16', 'Voided.\nDocument reentered.', '5', '2018-07-11', '0'),
('8553', '1', '2585', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-11', '1031'),
('8554', '1', '2584', '10', '2018-07-11 02:07:53', 'Voided.\nDocument reentered.', '5', '2018-07-11', '0'),
('8555', '1', '2586', '10', '2018-07-17 05:30:49', NULL, '5', '2018-07-11', NULL),
('8556', '1', '2587', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-11', '1032'),
('8557', '1', '2588', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-11', '1033'),
('8558', '1', '2589', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1046'),
('8559', '1', '2590', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1047'),
('8560', '1', '2591', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1048'),
('8561', '11', '136', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1063'),
('8562', '11', '137', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1064'),
('8563', '11', '138', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1065'),
('8564', '1', '2592', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-11', '1034'),
('8565', '1', '2593', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-11', '1035'),
('8566', '30', '1132', '10', '2018-07-13 01:16:06', NULL, '5', '2018-06-29', '0'),
('8567', '13', '1132', '10', '2018-07-13 01:16:06', NULL, '5', '2018-06-29', '0'),
('8568', '10', '1118', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '899'),
('8569', '30', '1133', '10', '2018-07-13 01:18:08', NULL, '5', '2018-06-29', '0'),
('8570', '13', '1133', '10', '2018-07-13 01:25:56', NULL, '5', '2018-06-29', NULL),
('8571', '10', '1119', '10', '2018-07-13 01:25:56', NULL, '5', '2018-06-29', NULL),
('8572', '30', '1134', '10', '2018-07-13 01:19:19', NULL, '5', '2018-05-31', '0'),
('8573', '13', '1134', '10', '2018-07-13 01:19:19', NULL, '5', '2018-05-31', '0'),
('8574', '10', '1120', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '571'),
('8575', '30', '1135', '10', '2018-07-13 01:20:03', NULL, '5', '2018-05-31', '0'),
('8576', '13', '1135', '10', '2018-07-13 01:20:03', NULL, '5', '2018-05-31', '0'),
('8577', '10', '1121', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '572'),
('8578', '30', '1136', '10', '2018-07-13 01:25:09', NULL, '5', '2018-06-29', '0'),
('8579', '13', '1136', '10', '2018-07-13 01:25:09', NULL, '5', '2018-06-29', '0'),
('8580', '10', '1122', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '900'),
('8581', '13', '1133', '10', '2018-07-13 01:25:56', 'Voided.', '5', '2018-07-13', '0'),
('8582', '10', '1119', '10', '2018-07-13 01:25:56', 'Voided.\n', '5', '2018-07-13', '0'),
('8583', '1', '2594', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1066'),
('8584', '1', '2595', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1067'),
('8585', '30', '1137', '10', '2018-07-13 02:46:39', NULL, '5', '2018-06-25', '0'),
('8586', '13', '1137', '10', '2018-07-13 02:46:39', NULL, '5', '2018-06-25', '0'),
('8587', '10', '1123', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-25', '831'),
('8588', '12', '661', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1068'),
('8589', '30', '1138', '10', '2018-07-13 02:50:08', NULL, '5', '2018-07-13', '0'),
('8590', '13', '1138', '10', '2018-07-13 02:50:08', NULL, '5', '2018-07-13', '0'),
('8591', '10', '1124', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1069'),
('8592', '12', '662', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1070'),
('8593', '30', '1139', '10', '2018-07-13 02:52:33', NULL, '5', '2018-06-19', '0'),
('8594', '13', '1139', '10', '2018-07-13 02:52:33', NULL, '5', '2018-06-19', '0'),
('8595', '10', '1125', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '760'),
('8596', '12', '663', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1071'),
('8597', '1', '2596', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1072'),
('8598', '1', '2597', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1073'),
('8599', '30', '1140', '10', '2018-07-13 05:49:20', NULL, '5', '2018-07-13', '0'),
('8600', '13', '1140', '10', '2018-07-13 05:49:20', NULL, '5', '2018-07-13', '0'),
('8601', '10', '1126', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1074'),
('8602', '1', '2598', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-16', '1090'),
('8603', '30', '1141', '10', '2018-07-16 01:45:17', NULL, '5', '2018-04-10', '0'),
('8604', '13', '1141', '10', '2018-07-16 01:45:18', NULL, '5', '2018-04-10', '0'),
('8605', '10', '1127', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-10', '98'),
('8606', '30', '1142', '10', '2018-07-16 01:48:05', NULL, '5', '2018-04-10', '0'),
('8607', '13', '1142', '10', '2018-07-16 01:48:05', NULL, '5', '2018-04-10', '0'),
('8608', '10', '1128', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-10', '99'),
('8609', '30', '1143', '10', '2018-07-16 01:49:20', NULL, '5', '2018-05-11', '0'),
('8610', '13', '1143', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-11', '366'),
('8611', '10', '1129', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-11', '367'),
('8612', '30', '1144', '10', '2018-07-16 01:50:29', NULL, '5', '2018-05-11', '0'),
('8613', '13', '1144', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-11', '368'),
('8614', '10', '1130', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-11', '369'),
('8615', '30', '1145', '10', '2018-07-16 01:53:18', NULL, '5', '2018-05-17', '0'),
('8616', '13', '1145', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '421'),
('8617', '10', '1131', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '422'),
('8618', '30', '1146', '10', '2018-07-16 01:54:41', NULL, '5', '2018-05-17', '0'),
('8619', '13', '1146', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '423'),
('8620', '10', '1132', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '424'),
('8621', '30', '1147', '10', '2018-07-16 01:56:51', NULL, '5', '2018-05-17', '0'),
('8622', '13', '1147', '10', '2018-07-16 02:02:48', NULL, '5', '2018-05-17', NULL),
('8623', '10', '1133', '10', '2018-07-16 02:02:48', NULL, '5', '2018-05-17', NULL),
('8624', '30', '1148', '10', '2018-07-16 01:58:22', NULL, '5', '2018-05-17', '0'),
('8625', '13', '1148', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '425'),
('8626', '10', '1134', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '426'),
('8627', '13', '1147', '10', '2018-07-16 02:02:48', 'Voided.', '5', '2018-07-16', '0'),
('8628', '10', '1133', '10', '2018-07-16 02:02:48', 'Voided.\n', '5', '2018-07-16', '0'),
('8629', '30', '1149', '10', '2018-07-16 02:03:36', NULL, '5', '2018-05-17', '0'),
('8630', '13', '1149', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '427'),
('8631', '10', '1135', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '428'),
('8632', '30', '1150', '10', '2018-07-16 02:04:32', NULL, '5', '2018-05-17', '0'),
('8633', '13', '1150', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '429'),
('8634', '10', '1136', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-17', '430'),
('8635', '30', '1151', '10', '2018-07-16 02:05:46', NULL, '5', '2018-05-18', '0'),
('8636', '13', '1151', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '445'),
('8637', '10', '1137', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '446'),
('8638', '30', '1152', '10', '2018-07-16 02:06:46', NULL, '5', '2018-05-18', '0'),
('8639', '13', '1152', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '447'),
('8640', '10', '1138', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '448'),
('8641', '30', '1153', '10', '2018-07-16 02:07:36', NULL, '5', '2018-05-18', '0'),
('8642', '13', '1153', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '449'),
('8643', '10', '1139', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '450'),
('8644', '30', '1154', '10', '2018-07-16 02:09:10', NULL, '5', '2018-05-23', '0'),
('8645', '13', '1154', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '489'),
('8646', '10', '1140', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '490'),
('8647', '30', '1155', '10', '2018-07-16 02:16:56', NULL, '5', '2018-05-23', '0'),
('8648', '13', '1155', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '491'),
('8649', '10', '1141', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '492'),
('8650', '30', '1156', '10', '2018-07-16 05:18:15', NULL, '5', '2018-07-16', '0'),
('8651', '13', '1156', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-16', '1091'),
('8652', '10', '1142', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-16', '1092'),
('8653', '30', '1157', '10', '2018-07-16 05:19:27', NULL, '5', '2018-05-22', '0'),
('8654', '13', '1157', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '479'),
('8655', '10', '1143', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-22', '480'),
('8656', '30', '1158', '10', '2018-07-16 05:20:33', NULL, '5', '2018-05-23', '0'),
('8657', '13', '1158', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '493'),
('8658', '10', '1144', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '494'),
('8659', '30', '1159', '10', '2018-07-16 05:21:54', NULL, '5', '2018-05-23', '0'),
('8660', '13', '1159', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '495'),
('8661', '10', '1145', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '496'),
('8662', '30', '1160', '10', '2018-07-16 05:22:36', NULL, '5', '2018-05-23', '0'),
('8663', '13', '1160', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '497'),
('8664', '10', '1146', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '498'),
('8665', '30', '1161', '10', '2018-07-16 05:23:59', NULL, '5', '2018-06-20', '0'),
('8666', '13', '1161', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-20', '769'),
('8667', '10', '1147', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-20', '770'),
('8668', '30', '1162', '10', '2018-07-16 05:28:06', NULL, '5', '2018-06-07', '0'),
('8669', '13', '1162', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '621'),
('8670', '10', '1148', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '622'),
('8671', '30', '1163', '10', '2018-07-16 05:29:01', NULL, '5', '2018-06-07', '0'),
('8672', '13', '1163', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '623'),
('8673', '10', '1149', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '624'),
('8674', '30', '1164', '10', '2018-07-16 05:36:43', NULL, '5', '2018-06-07', '0'),
('8675', '13', '1164', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '625'),
('8676', '10', '1150', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '626'),
('8677', '30', '1165', '10', '2018-07-16 05:39:36', NULL, '5', '2018-06-07', '0'),
('8678', '13', '1165', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '627'),
('8679', '10', '1151', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '628'),
('8680', '30', '1166', '10', '2018-07-16 05:41:23', NULL, '5', '2018-06-08', '0'),
('8681', '13', '1166', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-08', '641'),
('8682', '10', '1152', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-08', '642'),
('8683', '30', '1167', '10', '2018-07-16 05:43:52', NULL, '5', '2018-06-08', '0'),
('8684', '13', '1167', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-08', '643'),
('8685', '10', '1153', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-08', '644'),
('8686', '30', '1168', '10', '2018-07-16 05:47:29', NULL, '5', '2018-06-08', '0'),
('8687', '13', '1168', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-08', '645'),
('8688', '10', '1154', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-08', '646'),
('8689', '30', '1169', '10', '2018-07-16 05:48:30', NULL, '5', '2018-06-08', '0'),
('8690', '13', '1169', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-08', '647'),
('8691', '10', '1155', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-08', '648'),
('8692', '30', '1170', '10', '2018-07-16 05:54:33', NULL, '5', '2018-06-20', '0'),
('8693', '13', '1170', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-20', '771'),
('8694', '10', '1156', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-20', '772'),
('8695', '30', '1171', '10', '2018-07-16 05:55:28', NULL, '5', '2018-06-21', '0'),
('8696', '13', '1171', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '780'),
('8697', '10', '1157', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '781'),
('8698', '30', '1172', '10', '2018-07-16 05:56:45', NULL, '5', '2018-06-21', '0'),
('8699', '13', '1172', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '782'),
('8700', '10', '1158', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '783'),
('8701', '30', '1173', '10', '2018-07-16 05:57:52', NULL, '5', '2018-06-21', '0'),
('8702', '13', '1173', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '784'),
('8703', '10', '1159', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '785'),
('8704', '30', '1174', '10', '2018-07-16 06:01:05', NULL, '5', '2018-06-25', '0'),
('8705', '13', '1174', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-25', '832'),
('8706', '10', '1160', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-25', '833'),
('8707', '30', '1175', '10', '2018-07-16 06:02:28', NULL, '5', '2018-06-25', '0'),
('8708', '13', '1175', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-25', '834'),
('8709', '10', '1161', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-25', '835'),
('8710', '30', '1176', '10', '2018-07-16 06:03:22', NULL, '5', '2018-06-25', '0'),
('8711', '13', '1176', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-25', '836'),
('8712', '10', '1162', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-25', '837'),
('8713', '1', '2599', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-16', '1093'),
('8714', '1', '2600', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-17', '1098'),
('8715', '1', '2601', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-17', '1099'),
('8716', '1', '2602', '10', '2018-07-17 02:03:18', NULL, '5', '2018-07-17', NULL),
('8717', '1', '2603', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-17', '1100'),
('8718', '1', '2602', '10', '2018-07-17 02:03:18', 'Voided.\nDocument reentered.', '5', '2018-07-17', '0'),
('8719', '1', '2604', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-17', '1101'),
('8720', '1', '2605', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1075'),
('8721', '1', '2606', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-11', '1036'),
('8722', '1', '2586', '10', '2018-07-17 05:30:49', 'Voided.\nDocument reentered.', '5', '2018-07-17', '0'),
('8723', '1', '2607', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-17', '1102'),
('8724', '1', '2608', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-17', '1103'),
('8725', '1', '2609', '10', '2018-07-18 03:26:27', NULL, '5', '2018-07-18', NULL),
('8726', '1', '2610', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-18', '1113'),
('8727', '1', '2609', '10', '2018-07-18 03:26:27', 'Voided.\nDocument reentered.', '5', '2018-07-18', '0'),
('8728', '1', '2611', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-18', '1114'),
('8729', '1', '2612', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-18', '1115'),
('8730', '0', '100', '10', '2018-08-15 04:30:24', NULL, '5', '2017-04-01', NULL),
('8731', '1', '2613', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-18', '1116'),
('8732', '1', '2614', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-18', '1117'),
('8733', '1', '2615', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-19', '1118'),
('8734', '1', '2616', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-19', '1119'),
('8735', '1', '2617', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-19', '1120'),
('8736', '12', '664', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-30', '1224'),
('8737', '12', '665', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-12', '1771'),
('8738', '1', '2618', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-19', '1121'),
('8739', '1', '2619', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-19', '1122'),
('8740', '1', '2620', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-19', '1123'),
('8741', '1', '2621', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-19', '1124'),
('8742', '1', '2622', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-19', '1125'),
('8743', '1', '2623', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-19', '1126'),
('8744', '1', '2624', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1133'),
('8745', '1', '2625', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1134'),
('8746', '1', '2626', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1135'),
('8747', '1', '2627', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1136'),
('8748', '1', '2628', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1137'),
('8749', '1', '2629', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1138'),
('8750', '1', '2630', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1139'),
('8751', '1', '2631', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1140'),
('8752', '1', '2632', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1076'),
('8753', '1', '2633', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1141'),
('8754', '1', '2634', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-14', '716'),
('8755', '1', '2635', '10', '2018-07-20 02:16:37', NULL, '5', '2018-06-14', NULL),
('8756', '1', '2636', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-19', '1127'),
('8757', '1', '2635', '10', '2018-07-20 02:16:37', 'Voided.\nDocument reentered.', '5', '2018-07-20', '0'),
('8758', '1', '2637', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1142'),
('8759', '1', '2638', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1143'),
('8760', '1', '2639', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1144'),
('8761', '1', '2640', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1145'),
('8762', '1', '2641', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1146'),
('8763', '1', '2642', '10', '2018-07-20 06:11:36', NULL, '5', '2018-04-11', NULL),
('8764', '2', '116', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-19', '150'),
('8765', '1', '2643', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-11', '114'),
('8766', '1', '2642', '10', '2018-07-20 06:11:36', 'Voided.\nDocument reentered.', '5', '2018-07-20', '0'),
('8767', '0', '101', '1', '2018-07-21 08:11:47', NULL, '5', '2017-03-30', NULL),
('8768', '0', '102', '1', '2018-08-03 04:40:21', NULL, '5', '2017-03-30', NULL),
('8769', '1', '2398', '1', '2018-07-21 06:58:42', 'Voided.\n', '5', '2018-07-21', '0'),
('8770', '0', '103', '1', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '470'),
('8771', '2', '117', '1', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '471'),
('8772', '2', '118', '1', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '503'),
('8773', '0', '104', '1', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '504'),
('8774', '0', '105', '1', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '505'),
('8775', '2', '119', '1', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '506'),
('8776', '2', '120', '1', '2018-07-21 08:02:31', NULL, '5', '2017-03-30', NULL),
('8777', '2', '121', '1', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '472'),
('8778', '2', '120', '1', '2018-07-21 08:02:31', 'Voided.\nDocument reentered.', '5', '2018-07-21', '0'),
('8779', '0', '106', '1', '2018-07-21 08:03:10', NULL, '1', '2016-03-31', '83'),
('8780', '0', '107', '1', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '507'),
('8781', '0', '101', '1', '2018-07-21 08:11:47', 'Voided.\nDocument reentered.', '5', '2018-07-21', '0'),
('8782', '0', '108', '1', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '473'),
('8783', '1', '2644', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-06', '317'),
('8784', '1', '2645', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-06', '318'),
('8785', '30', '1177', '10', '2018-07-23 00:50:01', NULL, '5', '2018-04-04', '0'),
('8786', '13', '1177', '10', '2018-07-23 00:50:01', NULL, '5', '2018-04-04', '0'),
('8787', '10', '1163', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-04', '21'),
('8788', '12', '666', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-04', '22'),
('8789', '30', '1178', '10', '2018-07-23 00:51:13', NULL, '5', '2018-04-27', '0'),
('8790', '13', '1178', '10', '2018-07-23 00:51:13', NULL, '5', '2018-04-27', '0'),
('8791', '10', '1164', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '252'),
('8792', '12', '667', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '253'),
('8793', '30', '1179', '10', '2018-07-23 01:01:22', NULL, '5', '2018-04-23', '0'),
('8794', '13', '1179', '10', '2018-07-23 01:01:22', NULL, '5', '2018-04-23', '0'),
('8795', '10', '1165', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-23', '194'),
('8796', '12', '668', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-23', '195'),
('8797', '1', '2646', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-19', '151'),
('8798', '1', '2647', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-23', '2992'),
('8799', '2', '122', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-22', '2485'),
('8800', '1', '2648', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-22', '185'),
('8801', '2', '123', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-22', '186'),
('8802', '1', '2649', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-23', '187'),
('8803', '2', '124', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-23', '188'),
('8804', '1', '2650', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-20', '455'),
('8805', '2', '125', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-20', '456'),
('8806', '1', '2651', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-21', '457'),
('8807', '2', '126', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-21', '458'),
('8808', '1', '2652', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-24', '756'),
('8809', '2', '127', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-24', '757'),
('8810', '1', '2653', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-25', '758'),
('8811', '2', '128', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-25', '759'),
('8812', '1', '2654', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-22', '1042'),
('8813', '1', '2655', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-23', '1046'),
('8814', '2', '129', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-22', '1043'),
('8815', '2', '130', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-22', '1044'),
('8816', '1', '2656', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-20', '1296'),
('8817', '1', '2657', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-20', '1297'),
('8818', '2', '131', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-20', '1298'),
('8819', '2', '132', '10', '2020-01-22 05:35:45', NULL, '3', '2017-08-21', '1307'),
('8820', '1', '2658', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-23', '1598'),
('8821', '1', '2659', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-24', '1600'),
('8822', '2', '133', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-23', '1599'),
('8823', '2', '134', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-24', '1601'),
('8824', '1', '2660', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-21', '1843'),
('8825', '1', '2661', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-22', '1845'),
('8826', '2', '135', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-21', '1844'),
('8827', '2', '136', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-22', '1846'),
('8828', '1', '2662', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-25', '2177'),
('8829', '1', '2663', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2201'),
('8830', '2', '137', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-25', '2178'),
('8831', '2', '138', '10', '2020-01-22 05:35:45', NULL, '3', '2017-11-27', '2202'),
('8832', '1', '2664', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-23', '2486'),
('8833', '1', '2665', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-24', '2488'),
('8834', '2', '139', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-23', '2487'),
('8835', '2', '140', '10', '2020-01-22 05:35:45', NULL, '3', '2017-12-24', '2489'),
('8836', '1', '2666', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-20', '2689'),
('8837', '1', '2667', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-21', '2691'),
('8838', '2', '141', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-20', '2690'),
('8839', '2', '142', '10', '2020-01-22 05:35:45', NULL, '3', '2018-01-21', '2692'),
('8840', '1', '2668', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-25', '2997'),
('8841', '1', '2669', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3022'),
('8842', '2', '143', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-25', '2998'),
('8843', '2', '144', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3023'),
('8844', '1', '2670', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-24', '3229'),
('8845', '1', '2671', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-25', '3231'),
('8846', '2', '145', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-24', '3230'),
('8847', '2', '146', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-25', '3232'),
('8848', '1', '2672', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-23', '1169'),
('8849', '1', '2673', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-23', '1170'),
('8850', '1', '2674', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-23', '1171'),
('8851', '12', '669', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-23', '1172'),
('8852', '12', '670', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-23', '1173'),
('8853', '12', '671', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-23', '1174'),
('8854', '12', '672', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-23', '1175'),
('8855', '12', '673', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-06', '1314'),
('8856', '12', '674', '10', '2018-07-23 04:55:01', NULL, '5', '2018-08-06', NULL),
('8857', '12', '675', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-25', '1197'),
('8858', '11', '139', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-23', '1176'),
('8859', '30', '1180', '10', '2018-07-23 04:18:15', NULL, '5', '2018-06-22', '0'),
('8860', '13', '1180', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '807'),
('8861', '10', '1166', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '808'),
('8862', '12', '676', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-23', '1177'),
('8863', '12', '677', '10', '2018-08-02 02:56:57', NULL, '5', '2018-08-01', NULL),
('8864', '12', '678', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-23', '1178'),
('8865', '12', '679', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-30', '1225'),
('8866', '12', '680', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-23', '1179'),
('8867', '12', '681', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1507'),
('8868', '12', '682', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1262'),
('8869', '12', '683', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-14', '1808'),
('8870', '12', '684', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-20', '1443'),
('8871', '12', '685', '10', '2018-08-29 04:32:45', NULL, '5', '2018-08-10', NULL),
('8872', '12', '686', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-23', '1180'),
('8873', '12', '687', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-23', '1181'),
('8874', '12', '674', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-07-23', '1182'),
('8875', '1', '2675', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-23', '1183'),
('8876', '1', '2676', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-08', '335'),
('8877', '1', '2677', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-09', '349'),
('8878', '1', '2678', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-10', '357'),
('8879', '1', '2679', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-14', '383'),
('8880', '1', '2680', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-15', '405'),
('8881', '1', '2681', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-20', '454'),
('8882', '1', '2682', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-18', '451'),
('8883', '1', '2683', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-27', '254'),
('8884', '1', '2294', '10', '2018-07-23 23:36:34', 'Voided.\nDocument reentered.', '5', '2018-07-23', '0'),
('8885', '1', '2684', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-25', '513'),
('8886', '1', '2685', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-25', '514'),
('8887', '1', '2686', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-25', '515'),
('8888', '1', '2687', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-25', '516'),
('8889', '1', '2688', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-25', '517'),
('8890', '1', '2689', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-25', '518'),
('8891', '1', '2690', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-25', '519'),
('8892', '1', '2691', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-26', '523'),
('8893', '1', '2692', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-26', '524'),
('8894', '1', '2693', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-31', '573'),
('8895', '1', '2471', '10', '2018-07-24 00:17:12', 'Voided.\n', '5', '2018-07-24', '0'),
('8896', '1', '2472', '10', '2018-07-24 00:17:43', 'Voided.\n', '5', '2018-07-24', '0'),
('8897', '2', '147', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-04', '313'),
('8898', '4', '97', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-01', '273'),
('8899', '4', '98', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-25', '520'),
('8900', '4', '99', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-14', '384'),
('8901', '1', '2694', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-04', '314'),
('8902', '1', '2334', '10', '2018-07-24 00:37:03', 'Voided.\nDocument reentered.', '5', '2018-07-24', '0'),
('8903', '1', '2695', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-25', '521'),
('8904', '1', '2399', '10', '2018-07-24 00:38:54', 'Voided.\nDocument reentered.', '5', '2018-07-24', '0'),
('8905', '1', '2696', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '629'),
('8906', '1', '2697', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '691'),
('8907', '1', '2698', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-16', '726'),
('8908', '1', '2699', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '786'),
('8909', '1', '2700', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '852'),
('8910', '1', '2701', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '853'),
('8911', '1', '2702', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '854'),
('8912', '1', '2703', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-24', '1186'),
('8913', '1', '2704', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '855'),
('8914', '1', '2705', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '856'),
('8915', '1', '2706', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '857'),
('8916', '1', '2707', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '858'),
('8917', '1', '2708', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '859'),
('8918', '1', '2709', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '860'),
('8919', '1', '2710', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-30', '908'),
('8920', '1', '2711', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-30', '909'),
('8921', '4', '100', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-18', '737'),
('8922', '4', '101', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '861'),
('8923', '2', '148', '10', '2018-10-18 03:13:16', NULL, '5', '2018-06-01', NULL),
('8924', '2', '149', '10', '2018-10-18 03:13:38', NULL, '5', '2018-06-01', NULL),
('8925', '4', '102', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '630'),
('8926', '1', '2712', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-24', '1187'),
('8927', '1', '2713', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-25', '1198'),
('8928', '1', '2714', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-25', '1199'),
('8929', '1', '2715', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-25', '1200'),
('8930', '1', '2716', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1204'),
('8931', '30', '1181', '10', '2018-07-26 00:34:01', NULL, '5', '2018-06-13', '0'),
('8932', '13', '1181', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '692'),
('8933', '10', '1167', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '693'),
('8934', '30', '1182', '10', '2018-07-26 00:34:58', NULL, '5', '2018-06-13', '0'),
('8935', '13', '1182', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '694'),
('8936', '10', '1168', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '695'),
('8937', '30', '1183', '10', '2018-07-26 00:40:21', NULL, '5', '2018-06-13', '0'),
('8938', '13', '1183', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '696'),
('8939', '10', '1169', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '697'),
('8940', '30', '1184', '10', '2018-07-26 00:41:57', NULL, '5', '2018-06-13', '0'),
('8941', '13', '1184', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '698'),
('8942', '10', '1170', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '699'),
('8943', '30', '1185', '10', '2018-07-26 00:42:44', NULL, '5', '2018-06-13', '0'),
('8944', '13', '1185', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '700'),
('8945', '10', '1171', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '701'),
('8946', '30', '1186', '10', '2018-07-26 00:45:24', NULL, '5', '2018-06-18', '0'),
('8947', '13', '1186', '10', '2018-07-26 00:45:24', NULL, '5', '2018-06-18', '0'),
('8948', '10', '1172', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-18', '738'),
('8949', '30', '1187', '10', '2018-07-26 00:55:18', NULL, '5', '2018-06-18', '0'),
('8950', '13', '1187', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-18', '739'),
('8951', '10', '1173', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-18', '740'),
('8952', '30', '1188', '10', '2018-07-26 00:58:02', NULL, '5', '2018-06-21', '0'),
('8953', '13', '1188', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '787'),
('8954', '10', '1174', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '788'),
('8955', '30', '1189', '10', '2018-07-26 00:59:05', NULL, '5', '2018-06-21', '0'),
('8956', '13', '1189', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '789'),
('8957', '10', '1175', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '790'),
('8958', '30', '1190', '10', '2018-07-26 01:02:09', NULL, '5', '2018-06-21', '0'),
('8959', '13', '1190', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '791'),
('8960', '10', '1176', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '792'),
('8961', '30', '1191', '10', '2018-07-26 01:07:21', NULL, '5', '2018-06-21', '0'),
('8962', '13', '1191', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '793'),
('8963', '10', '1177', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '794'),
('8964', '30', '1192', '10', '2018-07-26 01:09:58', NULL, '5', '2018-06-26', '0'),
('8965', '13', '1192', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '862'),
('8966', '10', '1178', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '863'),
('8967', '30', '1193', '10', '2018-07-26 01:12:21', NULL, '5', '2018-06-26', '0'),
('8968', '13', '1193', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '864'),
('8969', '10', '1179', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '865'),
('8970', '30', '1194', '10', '2018-07-26 01:13:44', NULL, '5', '2018-06-22', '0'),
('8971', '13', '1194', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '809'),
('8972', '10', '1180', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '810'),
('8973', '1', '2717', '10', '2018-08-08 06:00:13', NULL, '5', '2018-07-26', NULL),
('8974', '11', '140', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1205'),
('8975', '1', '2718', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1206'),
('8976', '1', '2719', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1207'),
('8977', '1', '2720', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1208'),
('8978', '1', '2721', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1209'),
('8979', '1', '2722', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1210'),
('8980', '1', '2723', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1211'),
('8981', '10', '841', '10', '2018-08-06 06:11:35', 'Updated.', '5', '2017-08-08', NULL),
('8982', '12', '438', '10', '2020-01-22 05:35:44', 'Updated.', '3', '2017-08-09', '1231'),
('8983', '12', '688', '10', '2018-07-26 06:42:01', NULL, '3', '2017-09-22', NULL),
('8984', '12', '689', '10', '2020-01-22 05:35:45', NULL, '3', '2017-09-18', '1547'),
('8985', '12', '688', '10', '2020-01-22 05:35:45', 'Updated.', '3', '2017-09-22', '1596'),
('8986', '0', '109', '10', '2018-07-31 09:12:18', NULL, '5', '2018-03-31', NULL),
('8987', '1', '2724', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-30', '1226'),
('8988', '1', '2725', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-30', '1227'),
('8989', '10', '1082', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-07-03', '950'),
('8990', '1', '2726', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-30', '1228'),
('8991', '1', '2727', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-30', '1229'),
('8992', '1', '2728', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-30', '1230'),
('8993', '1', '2729', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-30', '1231'),
('8994', '1', '2730', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-30', '1232'),
('8995', '1', '2731', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1239'),
('8996', '1', '2732', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1240'),
('8997', '1', '2733', '10', '2018-07-31 02:49:32', NULL, '5', '2018-07-31', NULL),
('8998', '1', '2734', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1241'),
('8999', '1', '2733', '10', '2018-07-31 02:49:32', 'Voided.\nDocument reentered.', '5', '2018-07-31', '0'),
('9000', '1', '2735', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1242'),
('9001', '1', '2736', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1243'),
('9002', '0', '110', '1', '2018-07-31 09:06:22', NULL, '5', '2018-03-31', NULL),
('9003', '0', '111', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3286'),
('9004', '0', '112', '1', '2018-08-06 06:14:00', NULL, '5', '2018-03-31', NULL),
('9005', '1', '2737', '1', '2018-08-03 03:49:43', NULL, '5', '2018-03-31', NULL),
('9006', '1', '2738', '1', '2020-01-22 05:35:45', NULL, '3', '2017-12-08', '2357'),
('9007', '1', '1625', '1', '2018-07-31 09:01:09', 'Voided.\nDocument reentered.', '5', '2018-07-31', '0'),
('9008', '1', '2739', '1', '2020-01-22 05:35:45', NULL, '3', '2017-12-08', '2358'),
('9009', '1', '1626', '1', '2018-07-31 09:01:45', 'Voided.\nDocument reentered.', '5', '2018-07-31', '0'),
('9010', '0', '110', '1', '2018-07-31 09:06:22', 'Voided.\nDocument reentered.', '5', '2018-07-31', '0'),
('9011', '0', '113', '1', '2019-12-13 02:37:18', NULL, '6', '2018-03-31', NULL),
('9012', '0', '109', '1', '2018-07-31 09:12:18', 'Voided.\nDocument reentered.', '5', '2018-07-31', '0'),
('9013', '0', '114', '1', '2018-08-21 04:31:59', NULL, '5', '2018-03-31', NULL),
('9014', '11', '141', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-30', '910'),
('9015', '11', '142', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-30', '911'),
('9016', '11', '143', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-30', '912'),
('9017', '11', '144', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-30', '913'),
('9018', '11', '145', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-30', '914'),
('9019', '11', '146', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-30', '915'),
('9020', '11', '147', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-30', '916'),
('9021', '11', '148', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-30', '917'),
('9022', '12', '690', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-22', '1157'),
('9023', '12', '691', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-22', '1158'),
('9024', '12', '692', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-22', '1159'),
('9025', '12', '693', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-22', '1160'),
('9026', '12', '694', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-22', '1161'),
('9027', '12', '695', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-22', '1162'),
('9028', '12', '696', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-22', '1163'),
('9029', '12', '697', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-22', '1164'),
('9030', '0', '115', '1', '2020-01-22 05:35:44', NULL, '3', '2017-06-21', '727'),
('9031', '0', '116', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3287'),
('9032', '0', '117', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3288'),
('9033', '1', '2740', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1263'),
('9034', '1', '2741', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1264'),
('9035', '12', '698', '10', '2018-08-01 04:12:56', NULL, '5', '2018-08-01', NULL),
('9036', '12', '698', '10', '2018-08-01 04:13:44', 'Updated.', '5', '2018-08-01', NULL),
('9037', '12', '698', '10', '2018-08-01 04:13:59', 'Updated.', '5', '2018-08-01', NULL),
('9038', '12', '698', '10', '2018-08-01 04:14:20', 'Updated.', '5', '2018-08-01', NULL),
('9039', '12', '698', '10', '2018-08-01 04:14:38', 'Updated.', '5', '2018-08-01', NULL),
('9040', '12', '698', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-08-01', '1265'),
('9041', '12', '699', '10', '2018-08-02 02:53:01', NULL, '5', '2018-08-01', NULL),
('9042', '12', '700', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1266'),
('9043', '0', '118', '10', '2018-08-01 04:30:00', NULL, '5', '2017-04-01', NULL),
('9044', '0', '118', '10', '2018-08-01 04:30:00', 'Voided.\nDocument reentered.', '5', '2018-08-01', '0'),
('9045', '0', '119', '10', '2018-08-03 05:30:20', NULL, '5', '2017-03-31', NULL),
('9046', '0', '120', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3289'),
('9047', '12', '387', '10', '2018-08-01 04:55:40', 'Voided.\nReturned CHQ-Kosala', '5', '2018-08-01', '0'),
('9048', '1', '2107', '10', '2018-08-01 06:04:15', 'Voided.\n', '5', '2018-08-01', '0'),
('9049', '1', '2742', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1267'),
('9050', '1', '2743', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1268'),
('9051', '2', '150', '1', '2020-01-22 05:35:44', NULL, '3', '2017-06-02', '611'),
('9052', '2', '151', '1', '2020-01-22 05:35:44', NULL, '3', '2017-06-27', '791'),
('9053', '2', '69', '1', '2018-08-01 08:51:43', 'Voided.\nDocument reentered.', '5', '2018-08-01', '0'),
('9054', '2', '152', '1', '2020-01-22 05:35:45', NULL, '3', '2017-08-24', '1334'),
('9055', '2', '59', '1', '2018-08-01 08:53:30', 'Voided.\nDocument reentered.', '5', '2018-08-01', '0'),
('9056', '2', '153', '1', '2018-08-01 09:00:44', NULL, '5', '2017-09-29', NULL),
('9057', '2', '62', '1', '2018-08-01 08:54:32', 'Voided.\nDocument reentered.', '5', '2018-08-01', '0'),
('9058', '2', '154', '1', '2018-08-01 09:38:52', NULL, '5', '2017-10-25', NULL),
('9059', '2', '67', '1', '2018-08-01 08:56:42', 'Voided.\nDocument reentered.', '5', '2018-08-01', '0'),
('9060', '2', '155', '1', '2018-08-02 04:16:50', NULL, '5', '2017-09-29', NULL),
('9061', '2', '153', '1', '2018-08-01 09:00:44', 'Voided.\nDocument reentered.', '5', '2018-08-01', '0'),
('9062', '1', '2744', '1', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '56'),
('9063', '1', '2257', '1', '2018-08-01 09:05:16', 'Voided.\nDocument reentered.', '5', '2018-08-01', '0'),
('9064', '2', '156', '1', '2020-01-22 05:35:45', NULL, '3', '2017-10-25', '1886'),
('9065', '2', '154', '1', '2018-08-01 09:38:52', 'Voided.\nDocument reentered.', '5', '2018-08-01', '0'),
('9066', '1', '2745', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-02', '1287'),
('9067', '1', '2746', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-02', '1288'),
('9068', '12', '699', '10', '2018-08-02 02:53:01', 'Voided.\n', '5', '2018-08-02', '0'),
('9069', '12', '1541', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-02', '1289'),
('9070', '12', '677', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-08-15', '1414'),
('9071', '2', '157', '1', '2020-01-22 05:35:45', NULL, '3', '2017-09-29', '1685'),
('9072', '2', '155', '1', '2018-08-02 04:16:50', 'Voided.\nDocument reentered.', '5', '2018-08-02', '0'),
('9073', '1', '2747', '10', '2020-01-22 05:35:44', NULL, '3', '2017-07-20', '1026'),
('9074', '1', '1348', '10', '2018-08-02 05:15:19', 'Voided.\nDocument reentered.', '5', '2018-08-02', '0'),
('9075', '1', '1511', '10', '2018-08-02 05:18:22', 'Voided.\n', '5', '2018-08-02', '0'),
('9076', '1', '2748', '10', '2018-08-02 05:58:56', NULL, '5', '2017-08-02', NULL),
('9077', '1', '2749', '10', '2018-08-02 06:00:22', NULL, '5', '2018-08-02', NULL),
('9078', '1', '2748', '10', '2018-08-02 05:58:56', 'Voided.\nDocument reentered.', '5', '2018-08-02', '0');
INSERT INTO `0_audit_trail` VALUES
('9079', '1', '2750', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-02', '1290'),
('9080', '1', '2749', '10', '2018-08-02 06:00:22', 'Voided.\nDocument reentered.', '5', '2018-08-02', '0'),
('9081', '0', '121', '10', '2018-08-03 05:31:50', NULL, '5', '2017-03-31', NULL),
('9082', '13', '964', '10', '2018-08-02 06:17:35', 'Voided.', '5', '2018-08-02', '0'),
('9083', '10', '954', '10', '2018-08-02 06:17:36', 'Voided.\n', '5', '2018-08-02', '0'),
('9084', '0', '122', '10', '2018-08-02 06:26:33', NULL, '5', '2017-03-31', NULL),
('9085', '0', '122', '10', '2018-08-02 06:26:33', 'Voided.\nDocument reentered.', '5', '2018-08-02', '0'),
('9086', '0', '123', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3290'),
('9087', '10', '1084', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-08-03', '1297'),
('9088', '1', '2751', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-16', '2935'),
('9089', '1', '2752', '10', '2018-08-03 02:24:23', NULL, '5', '2018-03-16', NULL),
('9090', '1', '2078', '10', '2018-08-03 01:37:10', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9091', '1', '2753', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-19', '2944'),
('9092', '1', '2754', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-19', '2945'),
('9093', '1', '2755', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-19', '2946'),
('9094', '1', '2756', '10', '2018-08-03 02:21:55', NULL, '5', '2018-02-22', NULL),
('9095', '1', '2757', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-22', '2980'),
('9096', '1', '2758', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-23', '2993'),
('9097', '1', '2759', '10', '2018-08-03 02:23:25', NULL, '5', '2018-02-26', NULL),
('9098', '1', '2760', '10', '2018-08-03 02:16:45', NULL, '5', '2018-02-22', NULL),
('9099', '1', '2761', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-22', '2981'),
('9100', '1', '2762', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3064'),
('9101', '1', '2763', '10', '2018-08-03 02:17:08', NULL, '5', '2018-02-28', NULL),
('9102', '1', '2764', '10', '2018-08-03 02:06:06', NULL, '5', '2018-05-23', NULL),
('9103', '1', '2396', '10', '2018-08-03 02:03:32', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9104', '1', '2765', '10', '2018-12-01 04:33:51', NULL, '5', '2018-05-23', NULL),
('9105', '1', '2764', '10', '2018-08-03 02:06:06', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9106', '1', '2766', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-03', '1298'),
('9107', '1', '2767', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-22', '2982'),
('9108', '1', '2760', '10', '2018-08-03 02:16:45', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9109', '1', '2768', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3065'),
('9110', '1', '2763', '10', '2018-08-03 02:17:08', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9111', '1', '2769', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-22', '2983'),
('9112', '1', '2756', '10', '2018-08-03 02:21:55', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9113', '1', '2770', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-26', '3024'),
('9114', '1', '2759', '10', '2018-08-03 02:23:25', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9115', '1', '2771', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-16', '3186'),
('9116', '1', '2752', '10', '2018-08-03 02:24:23', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9117', '1', '2772', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3066'),
('9118', '1', '2773', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-28', '3067'),
('9119', '1', '2774', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-05', '3086'),
('9120', '1', '2775', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-05', '3087'),
('9121', '1', '2776', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-05', '3088'),
('9122', '1', '2777', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-05', '3089'),
('9123', '1', '2778', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-08', '3123'),
('9124', '1', '2779', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-09', '3132'),
('9125', '1', '2780', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-12', '3147'),
('9126', '1', '2781', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3161'),
('9127', '1', '2782', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3162'),
('9128', '1', '2783', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-13', '3163'),
('9129', '1', '2784', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-14', '3173'),
('9130', '1', '2785', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-03', '1299'),
('9131', '1', '2786', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-03', '1300'),
('9132', '1', '2787', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3291'),
('9133', '1', '2737', '1', '2018-08-03 03:49:43', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9134', '0', '124', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3292'),
('9135', '1', '2788', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-03', '1301'),
('9136', '1', '2789', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-03', '1302'),
('9137', '1', '2790', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-03', '1303'),
('9138', '1', '2791', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-02', '1291'),
('9139', '1', '2792', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-02', '1292'),
('9140', '1', '2793', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-02', '1293'),
('9141', '1', '2794', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-02', '1294'),
('9142', '1', '2795', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1244'),
('9143', '0', '102', '10', '2018-08-03 04:40:21', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9144', '0', '125', '10', '2018-08-03 04:43:16', NULL, '5', '2017-03-30', NULL),
('9145', '0', '125', '10', '2018-08-03 04:43:16', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9146', '0', '126', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-30', '474'),
('9147', '0', '31', '10', '2018-08-03 04:51:31', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9148', '0', '127', '10', '2019-11-05 05:45:21', NULL, '2', '2017-03-31', '508'),
('9149', '1', '2796', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-26', '225'),
('9150', '1', '2797', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-08', '369'),
('9151', '1', '2798', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-26', '541'),
('9152', '1', '2799', '10', '2018-08-03 04:59:08', NULL, '5', '2017-05-26', NULL),
('9153', '1', '2800', '10', '2020-01-22 05:35:44', NULL, '3', '2017-06-07', '645'),
('9154', '1', '2799', '10', '2018-08-03 04:59:08', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9155', '2', '158', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-23', '2994'),
('9156', '2', '95', '10', '2018-08-03 05:09:44', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9157', '0', '119', '10', '2018-08-03 05:30:20', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9158', '0', '128', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3293'),
('9159', '0', '121', '10', '2018-08-03 05:31:50', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9160', '0', '129', '10', '2018-08-03 05:32:48', NULL, '5', '2018-03-31', NULL),
('9161', '0', '129', '10', '2018-08-03 05:32:48', 'Voided.\nDocument reentered.', '5', '2018-08-03', '0'),
('9162', '0', '130', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3294'),
('9163', '12', '1542', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-06', '1315'),
('9164', '1', '2801', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-03', '1304'),
('9165', '0', '131', '1', '2018-08-06 03:41:42', NULL, '5', '2018-03-31', NULL),
('9166', '0', '132', '1', '2018-08-06 05:34:34', NULL, '5', '2018-03-31', NULL),
('9167', '1', '2802', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-06', '1316'),
('9168', '1', '2803', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-06', '1317'),
('9169', '1', '2804', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-06', '1318'),
('9170', '16', '45', '10', '2018-08-06 02:25:48', NULL, '5', '2018-08-06', '0'),
('9171', '16', '46', '10', '2018-08-06 02:26:12', NULL, '5', '2018-08-06', '0'),
('9172', '16', '47', '10', '2018-08-06 02:26:41', NULL, '5', '2018-08-06', '0'),
('9173', '16', '48', '10', '2018-08-06 02:27:00', NULL, '5', '2018-08-06', '0'),
('9174', '11', '149', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-19', '1128'),
('9175', '11', '150', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-19', '1129'),
('9176', '0', '131', '1', '2018-08-06 03:41:42', 'Voided.\nDocument reentered.', '5', '2018-08-06', '0'),
('9177', '0', '133', '1', '2018-08-06 04:00:39', NULL, '5', '2018-03-31', NULL),
('9178', '2', '159', '1', '2018-08-15 08:53:48', NULL, '5', '2017-05-19', NULL),
('9179', '2', '73', '1', '2018-08-06 03:46:24', 'Voided.\nDocument reentered.', '5', '2018-08-06', '0'),
('9180', '12', '1543', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '922'),
('9181', '0', '133', '1', '2018-08-06 04:00:39', 'Voided.\nDocument reentered.', '5', '2018-08-06', '0'),
('9182', '0', '134', '1', '2018-08-15 08:44:01', NULL, '5', '2018-03-31', NULL),
('9183', '12', '1544', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '923'),
('9184', '12', '1545', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '924'),
('9185', '12', '1546', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '925'),
('9186', '12', '1547', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '926'),
('9187', '12', '1548', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '927'),
('9188', '12', '1549', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '928'),
('9189', '12', '1550', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '929'),
('9190', '12', '1551', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '930'),
('9191', '11', '151', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '931'),
('9192', '11', '152', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '932'),
('9193', '11', '153', '10', '2018-08-29 05:21:05', NULL, '5', '2018-07-02', NULL),
('9194', '11', '154', '10', '2018-08-29 05:21:13', NULL, '5', '2018-07-02', NULL),
('9195', '0', '132', '1', '2018-08-06 05:34:34', 'Voided.\nDocument reentered.', '5', '2018-08-06', '0'),
('9196', '0', '135', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3295'),
('9197', '13', '849', '10', '2018-08-06 06:11:35', 'Voided.', '5', '2018-08-06', '0'),
('9198', '10', '841', '10', '2018-08-06 06:11:35', 'Voided.\n', '5', '2018-08-06', '0'),
('9199', '30', '1195', '10', '2018-08-06 06:12:56', NULL, '3', '2017-08-08', '0'),
('9200', '13', '1195', '10', '2018-08-06 06:12:56', NULL, '3', '2017-08-08', '0'),
('9201', '10', '1181', '10', '2020-01-22 05:35:44', NULL, '3', '2017-08-08', '1221'),
('9202', '0', '112', '1', '2018-08-06 06:14:00', 'Voided.\nDocument reentered.', '5', '2018-08-06', '0'),
('9203', '0', '136', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3296'),
('9204', '13', '968', '10', '2018-08-06 06:14:22', 'Voided.', '5', '2018-08-06', '0'),
('9205', '10', '958', '10', '2018-08-06 06:14:22', 'Voided.\n', '3', '2018-01-11', '0'),
('9206', '13', '1097', '10', '2018-08-06 06:17:09', 'Voided.', '5', '2018-08-06', '0'),
('9207', '10', '1083', '10', '2018-08-06 06:17:09', 'Voided.\n', '5', '2018-08-06', '0'),
('9208', '30', '1196', '10', '2018-08-06 06:20:15', NULL, '5', '2018-07-04', '0'),
('9209', '13', '1196', '10', '2018-08-06 06:20:15', NULL, '5', '2018-07-04', '0'),
('9210', '10', '1182', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '966'),
('9211', '0', '137', '10', '2018-08-06 07:03:43', NULL, '5', '2018-03-31', NULL),
('9212', '0', '138', '10', '2018-08-15 06:21:30', NULL, '5', '2018-03-31', NULL),
('9213', '0', '137', '10', '2018-08-06 07:03:43', 'Voided.\nDocument reentered.', '5', '2018-08-06', '0'),
('9214', '0', '139', '10', '2018-08-08 06:06:59', NULL, '5', '2018-03-31', NULL),
('9215', '1', '2805', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-07', '1323'),
('9216', '1', '2806', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-16', '3187'),
('9217', '1', '2807', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-19', '3191'),
('9218', '1', '2808', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-19', '3192'),
('9219', '1', '2809', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-26', '3239'),
('9220', '1', '2810', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3255'),
('9221', '1', '2811', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-27', '3256'),
('9222', '1', '2812', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-28', '3266'),
('9223', '12', '1552', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-07', '1324'),
('9224', '2', '160', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '901'),
('9225', '2', '161', '10', '2019-11-18 04:42:19', NULL, '6', '2018-06-29', NULL),
('9226', '12', '1553', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-04', '593'),
('9227', '12', '1554', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-04', '594'),
('9228', '12', '1555', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-04', '595'),
('9229', '12', '1556', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-04', '596'),
('9230', '12', '1557', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-04', '597'),
('9231', '12', '1558', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-04', '598'),
('9232', '12', '1559', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-04', '599'),
('9233', '12', '1560', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '811'),
('9234', '12', '1561', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '812'),
('9235', '12', '1562', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '813'),
('9236', '12', '1563', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-22', '1165'),
('9237', '11', '155', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-22', '1166'),
('9238', '11', '156', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-22', '1167'),
('9239', '1', '2813', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-08', '1326'),
('9240', '1', '2814', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-08', '1327'),
('9241', '0', '140', '10', '2018-08-08 08:22:17', NULL, '5', '2018-03-31', NULL),
('9242', '1', '2815', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-08', '1328'),
('9243', '1', '2816', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-08', '1329'),
('9244', '1', '2817', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-08', '1330'),
('9245', '1', '2818', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-08', '1331'),
('9246', '0', '141', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3297'),
('9247', '1', '2819', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-10', '1751'),
('9248', '1', '951', '10', '2018-08-08 05:41:21', 'Voided.\nDocument reentered.', '5', '2018-08-08', '0'),
('9249', '0', '142', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3298'),
('9250', '1', '2820', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1147'),
('9251', '1', '2821', '10', '2018-08-08 06:04:16', NULL, '5', '2017-04-20', NULL),
('9252', '1', '93', '10', '2018-08-08 05:58:29', 'Voided.\nDocument reentered.', '5', '2018-08-08', '0'),
('9253', '1', '2822', '10', '2018-08-08 06:01:19', NULL, '5', '2017-05-25', NULL),
('9254', '1', '276', '10', '2018-08-08 05:59:38', 'Voided.\nDocument reentered.', '5', '2018-08-08', '0'),
('9255', '0', '143', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3299'),
('9256', '1', '2823', '10', '2018-08-08 06:09:07', NULL, '5', '2018-07-26', NULL),
('9257', '1', '2717', '10', '2018-08-08 06:00:13', 'Voided.\nDocument reentered.', '5', '2018-08-08', '0'),
('9258', '1', '2824', '10', '2020-01-22 05:35:44', NULL, '3', '2017-05-25', '507'),
('9259', '1', '2822', '10', '2018-08-08 06:01:19', 'Voided.\nDocument reentered.', '5', '2018-08-08', '0'),
('9260', '1', '2825', '10', '2020-01-22 05:35:44', NULL, '3', '2017-04-20', '171'),
('9261', '1', '2821', '10', '2018-08-08 06:04:16', 'Voided.\nDocument reentered.', '5', '2018-08-08', '0'),
('9262', '1', '2826', '10', '2021-02-07 08:09:15', NULL, '5', '2018-04-25', '220'),
('9263', '1', '2273', '10', '2018-08-08 06:06:34', 'Voided.\nDocument reentered.', '5', '2018-08-08', '0'),
('9264', '0', '139', '1', '2018-08-08 06:06:59', 'Voided.\nDocument reentered.', '5', '2018-08-08', '0'),
('9265', '0', '144', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3300'),
('9266', '1', '2827', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '499'),
('9267', '1', '2387', '10', '2018-08-08 06:07:39', 'Voided.\nDocument reentered.', '5', '2018-08-08', '0'),
('9268', '1', '2828', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '902'),
('9269', '1', '2536', '10', '2018-08-08 06:08:48', 'Voided.\nDocument reentered.', '5', '2018-08-08', '0'),
('9270', '1', '2829', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1212'),
('9271', '1', '2823', '10', '2018-08-08 06:09:07', 'Voided.\nDocument reentered.', '5', '2018-08-08', '0'),
('9272', '0', '145', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3301'),
('9273', '0', '146', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3302'),
('9274', '0', '147', '1', '2018-08-08 08:02:05', NULL, '5', '2018-03-31', NULL),
('9275', '0', '148', '1', '2018-08-08 07:53:04', NULL, '5', '2018-03-31', NULL),
('9276', '0', '148', '1', '2018-08-08 07:53:04', 'Voided.\nDocument reentered.', '5', '2018-08-08', '0'),
('9277', '0', '149', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3303'),
('9278', '0', '147', '1', '2018-08-08 08:02:05', 'Voided.\nDocument reentered.', '5', '2018-08-08', '0'),
('9279', '0', '150', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3304'),
('9280', '0', '151', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3305'),
('9281', '0', '51', '1', '2018-08-08 08:17:53', 'Voided.\nDocument reentered.', '5', '2018-08-08', '0'),
('9282', '0', '152', '1', '2018-08-21 03:56:51', NULL, '5', '2017-10-31', NULL),
('9283', '0', '140', '1', '2018-08-08 08:22:17', 'Voided.\nDocument reentered.', '5', '2018-08-08', '0'),
('9284', '0', '153', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3306'),
('9285', '1', '2055', '1', '2018-08-08 08:30:21', 'Voided.\n', '5', '2018-08-08', '0'),
('9286', '0', '154', '1', '2019-11-04 06:32:33', NULL, '6', '2018-03-31', NULL),
('9287', '1', '2830', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-08', '1332'),
('9288', '1', '2831', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1335'),
('9289', '1', '2832', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1336'),
('9290', '1', '2833', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1337'),
('9291', '1', '2834', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1338'),
('9292', '1', '2835', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-10', '1355'),
('9293', '1', '2836', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1339'),
('9294', '2', '162', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '903'),
('9295', '1', '2837', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1340'),
('9296', '1', '2838', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1341'),
('9297', '1', '2839', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1342'),
('9298', '1', '2840', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1343'),
('9299', '1', '2841', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1344'),
('9300', '1', '2842', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1345'),
('9301', '1', '2843', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1346'),
('9302', '1', '2844', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1347'),
('9303', '1', '2845', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1348'),
('9304', '12', '1564', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1371'),
('9305', '1', '2846', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1372'),
('9306', '1', '2847', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1373'),
('9307', '1', '2848', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1374'),
('9308', '13', '909', '10', '2018-08-13 03:22:36', 'Voided.', '5', '2018-08-13', '0'),
('9309', '10', '900', '10', '2018-08-13 03:22:37', 'Voided.\n', '5', '2018-08-13', '0'),
('9310', '1', '2849', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1375'),
('9311', '1', '2850', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1376'),
('9312', '30', '1197', '10', '2018-08-14 02:36:58', NULL, '5', '2018-08-14', '0'),
('9313', '13', '1197', '10', '2018-08-14 02:36:59', NULL, '5', '2018-08-14', '0'),
('9314', '10', '1183', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1388'),
('9315', '11', '157', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1389'),
('9316', '11', '158', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1390'),
('9317', '11', '159', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-12', '370'),
('9318', '1', '2851', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1391'),
('9319', '1', '2852', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1392'),
('9320', '20', '119', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-19', '1130'),
('9321', '22', '49', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1393'),
('9322', '1', '2853', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1394'),
('9323', '1', '2854', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1395'),
('9324', '1', '2855', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1396'),
('9325', '12', '1565', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1397'),
('9326', '0', '100', '10', '2018-08-15 04:30:24', 'Voided.\nDocument reentered.', '5', '2018-08-15', '0'),
('9327', '0', '155', '10', '2018-08-15 06:23:59', NULL, '5', '2017-04-01', NULL),
('9328', '0', '138', '1', '2018-08-15 06:21:30', 'Voided.\nDocument reentered.', '5', '2018-08-15', '0'),
('9329', '0', '156', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3307'),
('9330', '0', '155', '1', '2018-08-15 06:23:59', 'Voided.\nDocument reentered.', '5', '2018-08-15', '0'),
('9331', '0', '157', '1', '2020-01-22 05:35:44', NULL, '3', '2017-04-01', '1'),
('9332', '0', '158', '1', '2018-08-15 07:32:59', NULL, '5', '2018-03-31', NULL),
('9333', '0', '159', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3308'),
('9334', '0', '158', '1', '2018-08-15 07:32:59', 'Voided.\nDocument reentered.', '5', '2018-08-15', '0'),
('9335', '0', '160', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3309'),
('9336', '2', '163', '1', '2019-11-06 03:49:22', NULL, '6', '2018-05-23', NULL),
('9337', '2', '111', '1', '2018-08-15 08:33:12', 'Voided.\nDocument reentered.', '5', '2018-08-15', '0'),
('9338', '0', '134', '1', '2018-08-15 08:44:01', 'Voided.\nDocument reentered.', '5', '2018-08-15', '0'),
('9339', '0', '161', '1', '2018-08-15 09:05:39', NULL, '5', '2018-03-31', NULL),
('9340', '2', '164', '1', '2020-01-22 05:35:44', NULL, '3', '2017-05-19', '453'),
('9341', '2', '159', '1', '2018-08-15 08:53:48', 'Voided.\nDocument reentered.', '5', '2018-08-15', '0'),
('9342', '0', '161', '1', '2018-08-15 09:05:39', 'Voided.\nDocument reentered.', '5', '2018-08-15', '0'),
('9343', '0', '162', '1', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3310'),
('9344', '1', '2856', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1349'),
('9345', '1', '2857', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-17', '1431'),
('9346', '1', '2858', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-17', '1432'),
('9347', '1', '2859', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-17', '1433'),
('9348', '1', '2860', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-17', '1434'),
('9349', '0', '163', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3311'),
('9350', '1', '2861', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-17', '1435'),
('9351', '1', '2862', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-17', '1436'),
('9352', '1', '2863', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-17', '1437'),
('9353', '1', '2864', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-17', '1438'),
('9354', '1', '2865', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-17', '1439'),
('9355', '12', '1566', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-20', '1444'),
('9356', '30', '1198', '10', '2018-08-20 02:45:35', NULL, '5', '2018-08-17', '0'),
('9357', '13', '1198', '10', '2018-08-20 02:45:35', NULL, '5', '2018-08-17', '0'),
('9358', '10', '1184', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-17', '1440'),
('9359', '12', '1567', '10', '2018-09-19 04:58:04', NULL, '5', '2018-08-20', NULL),
('9360', '1', '2866', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-20', '1445'),
('9361', '1', '2867', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-20', '1446'),
('9362', '1', '2868', '10', '2018-08-21 03:44:52', NULL, '5', '2018-08-20', NULL),
('9363', '1', '2869', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-20', '1447'),
('9364', '1', '2870', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-20', '1448'),
('9365', '1', '2871', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-20', '1449'),
('9366', '11', '160', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-21', '1460'),
('9367', '1', '2872', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-21', '1461'),
('9368', '1', '2873', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-20', '1450'),
('9369', '1', '2868', '10', '2018-08-21 03:44:52', 'Voided.\nDocument reentered.', '5', '2018-08-21', '0'),
('9370', '1', '2874', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-20', '1451'),
('9371', '0', '152', '10', '2018-08-21 03:56:51', 'Voided.\nDocument reentered.', '5', '2018-08-21', '0'),
('9372', '0', '164', '10', '2020-01-22 05:35:45', NULL, '3', '2017-10-31', '1957'),
('9373', '0', '165', '10', '2020-01-22 05:35:45', NULL, '3', '2018-03-31', '3312'),
('9374', '0', '114', '10', '2018-08-21 04:31:59', 'Voided.\nDocument reentered.', '5', '2018-08-21', '0'),
('9375', '0', '166', '10', '2019-11-04 06:49:20', NULL, '6', '2018-03-31', NULL),
('9376', '1', '2875', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-21', '1462'),
('9377', '1', '2876', '10', '2018-08-23 01:52:44', NULL, '5', '2018-08-22', NULL),
('9378', '1', '2877', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-21', '1463'),
('9379', '1', '2878', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-22', '1470'),
('9380', '1', '2879', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-22', '1471'),
('9381', '1', '2880', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-23', '1482'),
('9382', '1', '2876', '10', '2018-08-23 01:52:44', 'Voided.\nDocument reentered.', '5', '2018-08-23', '0'),
('9383', '1', '2881', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-23', '1483'),
('9384', '16', '49', '10', '2018-08-23 02:03:41', NULL, '5', '2018-08-14', '0'),
('9385', '18', '46', '10', '2018-08-23 03:20:12', NULL, '5', '2018-07-10', '0'),
('9386', '25', '45', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-10', '1027'),
('9387', '20', '120', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-10', '1028'),
('9388', '22', '50', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-23', '1484'),
('9389', '1', '2882', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-23', '1485'),
('9390', '1', '2883', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-24', '1491'),
('9391', '1', '2884', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-24', '1492'),
('9392', '1', '2885', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-24', '1493'),
('9393', '1', '2886', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-24', '1494'),
('9394', '12', '1568', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-24', '1495'),
('9395', '12', '1569', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-24', '1496'),
('9396', '12', '1570', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-10', '1731'),
('9397', '1', '2887', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-24', '1497'),
('9398', '1', '2888', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-24', '1498'),
('9399', '1', '2889', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-24', '1499'),
('9400', '11', '161', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1508'),
('9401', '1', '2890', '10', '2018-08-27 05:07:17', NULL, '5', '2018-08-27', NULL),
('9402', '1', '2891', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1509'),
('9403', '1', '2890', '10', '2018-08-27 05:07:17', 'Voided.\nDocument reentered.', '5', '2018-08-27', '0'),
('9404', '1', '2892', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1510'),
('9405', '1', '2893', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1511'),
('9406', '1', '2894', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1512'),
('9407', '1', '2895', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1513'),
('9408', '1', '2896', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1514'),
('9409', '1', '2897', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1515'),
('9410', '1', '2898', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1516'),
('9411', '1', '2899', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1517'),
('9412', '1', '2900', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1518'),
('9413', '1', '2901', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1519'),
('9414', '1', '2902', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1520'),
('9415', '1', '2903', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1521'),
('9416', '1', '2904', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1522'),
('9417', '1', '2905', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1377'),
('9418', '1', '2906', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1378'),
('9419', '1', '2907', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1148'),
('9420', '1', '2908', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1398'),
('9421', '11', '162', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '669'),
('9422', '11', '163', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '670'),
('9423', '11', '164', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '671'),
('9424', '11', '165', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '672'),
('9425', '11', '166', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '673'),
('9426', '11', '167', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-11', '674'),
('9427', '1', '2909', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1540'),
('9428', '1', '2910', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-24', '1500'),
('9429', '1', '2911', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1541'),
('9430', '1', '2912', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1542'),
('9431', '1', '2913', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1543'),
('9432', '1', '2914', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1574'),
('9433', '30', '1199', '10', '2018-08-29 00:13:26', NULL, '5', '2018-07-31', '0'),
('9434', '13', '1199', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1245'),
('9435', '10', '1185', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1246'),
('9436', '30', '1200', '10', '2018-08-29 00:14:50', NULL, '5', '2018-07-13', '0'),
('9437', '13', '1200', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1077'),
('9438', '10', '1186', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1078'),
('9439', '30', '1201', '10', '2018-08-29 00:15:53', NULL, '5', '2018-07-13', '0'),
('9440', '13', '1201', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1079'),
('9441', '10', '1187', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1080'),
('9442', '30', '1202', '10', '2018-08-29 00:17:58', NULL, '5', '2018-07-13', '0'),
('9443', '13', '1202', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1081'),
('9444', '10', '1188', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1082'),
('9445', '30', '1203', '10', '2018-08-29 00:20:12', NULL, '5', '2018-07-24', '0'),
('9446', '13', '1203', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-24', '1188'),
('9447', '10', '1189', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-24', '1189'),
('9448', '30', '1204', '10', '2018-08-29 00:23:13', NULL, '5', '2018-07-24', '0'),
('9449', '13', '1204', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-24', '1190'),
('9450', '10', '1190', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-24', '1191'),
('9451', '30', '1205', '10', '2018-08-29 00:25:25', NULL, '5', '2018-07-24', '0'),
('9452', '13', '1205', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-24', '1192'),
('9453', '10', '1191', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-24', '1193'),
('9454', '30', '1206', '10', '2018-08-29 00:29:21', NULL, '5', '2018-07-09', '0'),
('9455', '13', '1206', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1013'),
('9456', '10', '1192', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1014'),
('9457', '30', '1207', '10', '2018-08-29 00:30:56', NULL, '5', '2018-07-07', '0'),
('9458', '13', '1207', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-07', '990'),
('9459', '10', '1193', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-07', '991'),
('9460', '30', '1208', '10', '2018-08-29 00:34:34', NULL, '5', '2018-06-13', '0'),
('9461', '13', '1208', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '702'),
('9462', '10', '1194', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '703'),
('9463', '30', '1209', '10', '2018-08-29 00:36:47', NULL, '5', '2018-06-13', '0'),
('9464', '13', '1209', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '704'),
('9465', '10', '1195', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-13', '705'),
('9466', '30', '1210', '10', '2018-08-29 00:39:36', NULL, '5', '2018-06-22', '0'),
('9467', '13', '1210', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '814'),
('9468', '10', '1196', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '815'),
('9469', '30', '1211', '10', '2018-08-29 00:45:31', NULL, '5', '2018-06-22', '0'),
('9470', '13', '1211', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '816'),
('9471', '10', '1197', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '817'),
('9472', '30', '1212', '10', '2018-08-29 00:46:25', NULL, '5', '2018-06-22', '0'),
('9473', '13', '1212', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '818'),
('9474', '10', '1198', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '819'),
('9475', '30', '1213', '10', '2018-08-29 00:49:30', NULL, '5', '2018-06-09', '0'),
('9476', '13', '1213', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-09', '652'),
('9477', '10', '1199', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-09', '653'),
('9478', '1', '2915', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1575'),
('9479', '1', '2916', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1576'),
('9480', '11', '168', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-05', '601'),
('9481', '1', '2917', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1577'),
('9482', '12', '1571', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1591'),
('9483', '12', '1572', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1578'),
('9484', '12', '1573', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1579'),
('9485', '12', '1574', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-22', '1918'),
('9486', '12', '1575', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1544'),
('9487', '12', '1576', '10', '2018-11-01 23:56:46', NULL, '5', '2018-10-15', NULL),
('9488', '12', '1577', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1545'),
('9489', '12', '1578', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1546'),
('9490', '12', '1579', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1547'),
('9491', '12', '1580', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1548'),
('9492', '12', '1581', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1549'),
('9493', '12', '1582', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-04', '1652'),
('9494', '12', '1583', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-03', '1642'),
('9495', '12', '1584', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1592'),
('9496', '12', '1585', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-03', '1643'),
('9497', '12', '1586', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1550'),
('9498', '12', '1587', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1551'),
('9499', '12', '1588', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1552'),
('9500', '12', '1589', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1553'),
('9501', '12', '1590', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1554'),
('9502', '12', '1591', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1555'),
('9503', '12', '685', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-03', '1644'),
('9504', '30', '1214', '10', '2018-08-29 04:37:13', NULL, '5', '2018-07-20', '0'),
('9505', '13', '1214', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1149'),
('9506', '10', '1200', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1150'),
('9507', '12', '1592', '10', '2019-02-12 00:30:01', NULL, '5', '2018-09-06', NULL),
('9508', '11', '153', '10', '2018-08-29 05:21:05', 'Voided.\n', '5', '2018-08-29', '0'),
('9509', '11', '154', '10', '2018-08-29 05:21:13', 'Voided.\n', '5', '2018-08-29', '0'),
('9510', '12', '1593', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1556'),
('9511', '12', '1594', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1269'),
('9512', '12', '1595', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1270'),
('9513', '12', '1596', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1271'),
('9514', '12', '1597', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1272'),
('9515', '11', '169', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1273'),
('9516', '12', '1598', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1274'),
('9517', '12', '1599', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1275'),
('9518', '12', '1600', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1276'),
('9519', '12', '1601', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1277'),
('9520', '11', '170', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1278'),
('9521', '11', '171', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-10', '1356'),
('9522', '11', '172', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-10', '1357'),
('9523', '2', '165', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1593'),
('9524', '1', '2918', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1594'),
('9525', '1', '2919', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1595'),
('9526', '30', '1215', '10', '2018-08-30 22:54:30', NULL, '5', '2018-08-30', '0'),
('9527', '13', '1215', '10', '2018-08-30 22:54:30', NULL, '5', '2018-08-30', '0'),
('9528', '10', '1201', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1596'),
('9529', '1', '2920', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1617'),
('9530', '1', '2921', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1618'),
('9531', '1', '2922', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-03', '1645'),
('9532', '1', '2923', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1619'),
('9533', '30', '1216', '10', '2018-09-03 05:40:49', NULL, '5', '2018-07-31', '0'),
('9534', '13', '1216', '10', '2018-09-21 00:56:06', NULL, '5', '2018-07-31', NULL),
('9535', '10', '1202', '10', '2018-09-21 00:56:07', NULL, '5', '2018-07-31', NULL),
('9536', '30', '1217', '10', '2018-09-03 05:43:35', NULL, '5', '2018-07-31', '0'),
('9537', '13', '1217', '10', '2018-09-03 05:43:35', NULL, '5', '2018-07-31', '0'),
('9538', '10', '1203', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1247'),
('9539', '30', '1218', '10', '2018-09-03 05:47:07', NULL, '5', '2018-07-31', '0'),
('9540', '13', '1218', '10', '2018-09-03 05:47:07', NULL, '5', '2018-07-31', '0'),
('9541', '10', '1204', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1248'),
('9542', '1', '2924', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1597'),
('9543', '1', '2925', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1598'),
('9544', '1', '2926', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1599'),
('9545', '1', '2927', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1600'),
('9546', '1', '2928', '10', '2018-10-18 05:38:32', NULL, '5', '2018-08-30', NULL),
('9547', '1', '2929', '10', '2018-09-04 01:38:38', NULL, '5', '2018-08-30', NULL),
('9548', '1', '2930', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1601'),
('9549', '1', '2931', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1602'),
('9550', '1', '2929', '10', '2018-09-04 01:38:38', 'Voided.\nDocument reentered.', '5', '2018-09-04', '0'),
('9551', '1', '2932', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1603'),
('9552', '1', '2933', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1604'),
('9553', '1', '2934', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1620'),
('9554', '26', '10', '1', '2018-09-04 02:59:47', NULL, '5', '2018-09-04', NULL),
('9555', '26', '10', '1', '2018-09-04 02:59:47', 'Updated.', '5', '2018-09-04', '0'),
('9556', '18', '47', '10', '2018-09-04 05:03:10', NULL, '5', '2018-08-09', '0'),
('9557', '25', '46', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1350'),
('9558', '20', '121', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1351'),
('9559', '1', '2935', '10', '2018-09-04 05:18:17', NULL, '5', '2018-09-04', NULL),
('9560', '1', '2936', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-04', '1653'),
('9561', '1', '2935', '10', '2018-09-04 05:18:17', 'Voided.\nDocument reentered.', '5', '2018-09-04', '0'),
('9562', '12', '1602', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2169'),
('9563', '12', '1603', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1665'),
('9564', '12', '1604', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1666'),
('9565', '12', '1605', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1667'),
('9566', '12', '1606', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1926'),
('9567', '1', '2937', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-04', '1654'),
('9568', '11', '173', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1668'),
('9569', '11', '174', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1669'),
('9570', '11', '175', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1670'),
('9571', '11', '176', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1671'),
('9572', '1', '2938', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1672'),
('9573', '1', '2939', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1673'),
('9574', '1', '2940', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1674'),
('9575', '1', '2941', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1675'),
('9576', '1', '2942', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1676'),
('9577', '1', '2943', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1677'),
('9578', '1', '2944', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1678'),
('9579', '1', '2945', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-04', '1655'),
('9580', '30', '1219', '10', '2018-09-06 03:25:15', NULL, '5', '2018-09-06', '0'),
('9581', '13', '1219', '10', '2018-09-06 03:25:15', NULL, '5', '2018-09-06', '0'),
('9582', '1', '2946', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-06', '1685'),
('9583', '1', '2947', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-06', '1686'),
('9584', '12', '1607', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-06', '1687'),
('9585', '1', '2948', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1695'),
('9586', '1', '2949', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1696'),
('9587', '16', '50', '10', '2018-09-07 00:46:21', NULL, '5', '2018-09-07', '0'),
('9588', '11', '177', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1697'),
('9589', '16', '51', '10', '2018-09-07 00:50:53', NULL, '5', '2018-09-07', '0'),
('9590', '16', '52', '10', '2018-09-07 00:51:50', NULL, '5', '2018-09-07', '0'),
('9591', '16', '53', '10', '2018-09-07 00:52:36', NULL, '5', '2018-09-07', '0'),
('9592', '16', '54', '10', '2018-09-07 00:53:19', NULL, '5', '2018-09-07', '0'),
('9593', '1', '2950', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1698'),
('9594', '1', '2951', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1699'),
('9595', '1', '2952', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1700'),
('9596', '1', '2953', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1701'),
('9597', '1', '2954', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1702'),
('9598', '1', '2955', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1703'),
('9599', '1', '2956', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1704'),
('9600', '20', '122', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1352'),
('9601', '20', '123', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1580'),
('9602', '22', '51', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1705'),
('9603', '1', '2957', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1706'),
('9604', '1', '2958', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-10', '1732'),
('9605', '10', '901', '10', '2019-06-22 03:32:54', 'Updated.', '6', '2018-02-21', NULL),
('9606', '10', '901', '10', '2019-06-22 03:32:54', 'Updated.', '6', '2018-02-21', NULL),
('9607', '30', '1220', '10', '2018-09-10 01:46:48', NULL, '3', '2018-02-21', '0'),
('9608', '13', '1220', '10', '2018-09-10 01:46:48', NULL, '3', '2018-02-21', '0'),
('9609', '10', '1205', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-21', '2969'),
('9610', '1', '2959', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-10', '1733'),
('9611', '1', '2960', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-10', '1734'),
('9612', '30', '1221', '10', '2018-09-10 23:55:05', NULL, '5', '2018-09-10', '0'),
('9613', '13', '1221', '10', '2018-09-10 23:57:40', NULL, '5', '2018-09-10', NULL),
('9614', '13', '1221', '10', '2018-09-10 23:57:40', 'Updated.', '5', '2018-09-10', '0'),
('9615', '1', '2961', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1740'),
('9616', '1', '2962', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1741'),
('9617', '1', '2963', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1742'),
('9618', '18', '48', '10', '2018-09-11 02:33:05', NULL, '5', '2018-08-13', '0'),
('9619', '25', '47', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1379'),
('9620', '20', '124', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1380'),
('9621', '22', '52', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1743'),
('9622', '30', '1222', '10', '2018-09-11 03:00:43', NULL, '5', '2018-09-11', '0'),
('9623', '13', '1222', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1744'),
('9624', '10', '1206', '10', '2018-09-11 03:33:30', NULL, '5', '2018-09-11', NULL),
('9625', '30', '1223', '10', '2018-09-11 03:03:14', NULL, '5', '2018-09-11', '0'),
('9626', '13', '1223', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1745'),
('9627', '10', '1207', '10', '2018-09-11 03:34:50', NULL, '5', '2018-09-11', NULL),
('9628', '30', '1224', '10', '2018-09-11 03:25:56', NULL, '5', '2018-09-11', '0'),
('9629', '13', '1224', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1746'),
('9630', '10', '1208', '10', '2018-09-13 05:39:06', NULL, '5', '2018-09-11', NULL),
('9631', '30', '1225', '10', '2018-09-11 03:30:08', NULL, '5', '2018-09-11', '0'),
('9632', '13', '1225', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1747'),
('9633', '10', '1209', '10', '2018-09-13 05:39:25', NULL, '5', '2018-09-11', NULL),
('9634', '10', '1206', '10', '2018-09-13 05:38:31', 'Updated.', '5', '2018-09-11', NULL),
('9635', '10', '1207', '10', '2018-09-13 05:38:52', 'Updated.', '5', '2018-09-11', NULL),
('9636', '1', '2964', '10', '2018-10-18 06:27:55', NULL, '5', '2018-09-11', NULL),
('9637', '1', '2965', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1748'),
('9638', '1', '2966', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1749'),
('9639', '1', '2967', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1399'),
('9640', '30', '1226', '10', '2018-09-11 05:49:00', NULL, '5', '2018-07-04', '0'),
('9641', '13', '1226', '10', '2018-09-11 05:49:00', NULL, '5', '2018-07-04', '0'),
('9642', '10', '1210', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '967'),
('9643', '12', '1608', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-04', '1656'),
('9644', '1', '2968', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-04', '1657'),
('9645', '1', '2969', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1750'),
('9646', '1', '2970', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-03', '1646'),
('9647', '1', '2971', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-03', '1647'),
('9648', '1', '2972', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1751'),
('9649', '30', '1227', '10', '2018-09-11 23:20:50', NULL, '5', '2018-09-12', '0'),
('9650', '13', '1227', '10', '2019-06-22 05:31:16', NULL, '6', '2018-09-12', NULL),
('9651', '10', '1211', '10', '2019-06-22 05:31:16', NULL, '6', '2018-09-12', NULL),
('9652', '10', '1211', '10', '2019-06-22 05:31:16', 'Updated.', '6', '2018-09-12', NULL),
('9653', '30', '1228', '10', '2018-09-11 23:26:58', NULL, '5', '2018-09-12', '0'),
('9654', '13', '1228', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-12', '1772'),
('9655', '10', '1212', '10', '2018-09-13 05:40:02', NULL, '5', '2018-09-12', NULL),
('9656', '30', '1229', '10', '2018-09-12 03:43:08', NULL, '5', '2018-09-12', '0'),
('9657', '13', '1229', '10', '2018-09-12 03:43:08', NULL, '5', '2018-09-12', '0'),
('9658', '10', '1213', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-12', '1773'),
('9659', '30', '1230', '10', '2018-09-12 03:46:11', NULL, '5', '2018-09-12', '0'),
('9660', '13', '1230', '10', '2018-09-12 03:46:11', NULL, '5', '2018-09-12', '0'),
('9661', '10', '1214', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-12', '1774'),
('9662', '30', '1231', '10', '2018-09-12 03:48:05', NULL, '5', '2018-09-12', '0'),
('9663', '13', '1231', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-12', '1775'),
('9664', '10', '1215', '10', '2018-09-13 05:40:23', NULL, '5', '2018-09-12', NULL),
('9665', '30', '1232', '10', '2018-09-12 03:50:50', NULL, '5', '2018-09-12', '0'),
('9666', '13', '1232', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-12', '1776'),
('9667', '10', '1216', '10', '2018-09-13 05:40:39', NULL, '5', '2018-09-12', NULL);
INSERT INTO `0_audit_trail` VALUES
('9668', '12', '1609', '10', '2018-09-19 05:02:37', NULL, '5', '2018-09-12', NULL),
('9669', '30', '1233', '10', '2018-09-12 03:57:50', NULL, '5', '2018-09-07', '0'),
('9670', '13', '1233', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1707'),
('9671', '10', '1217', '10', '2018-09-13 05:40:53', NULL, '5', '2018-09-07', NULL),
('9672', '12', '1610', '10', '2018-09-19 05:02:59', NULL, '5', '2018-09-12', NULL),
('9673', '12', '1611', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-24', '1920'),
('9674', '11', '178', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-12', '1777'),
('9675', '12', '1612', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2096'),
('9676', '12', '1613', '10', '2018-09-19 05:03:15', NULL, '5', '2018-09-12', NULL),
('9677', '16', '55', '10', '2018-09-12 06:33:01', NULL, '5', '2018-09-12', '0'),
('9678', '1', '2973', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-12', '1778'),
('9679', '1', '2974', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-12', '1779'),
('9680', '30', '1234', '10', '2018-09-12 23:56:04', NULL, '5', '2018-09-13', '0'),
('9681', '13', '1234', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-13', '1793'),
('9682', '10', '1218', '10', '2018-09-13 05:41:08', NULL, '5', '2018-09-13', NULL),
('9683', '30', '1235', '10', '2018-09-13 01:30:22', NULL, '5', '2018-09-13', '0'),
('9684', '13', '1235', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-13', '1794'),
('9685', '10', '1219', '10', '2018-09-13 05:41:25', NULL, '5', '2018-09-13', NULL),
('9686', '12', '1614', '10', '2018-09-19 05:03:26', NULL, '5', '2018-09-13', NULL),
('9687', '12', '1615', '10', '2018-09-19 05:04:47', NULL, '5', '2018-09-13', NULL),
('9688', '1', '2975', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-13', '1795'),
('9689', '12', '1616', '10', '2018-09-19 05:03:33', NULL, '5', '2018-09-13', NULL),
('9690', '30', '1236', '10', '2018-09-13 04:20:12', NULL, '5', '2018-09-13', '0'),
('9691', '13', '1236', '10', '2018-09-13 04:20:12', NULL, '5', '2018-09-13', '0'),
('9692', '10', '1220', '10', '2018-09-13 04:34:19', NULL, '5', '2018-09-13', NULL),
('9693', '12', '1617', '10', '2018-09-13 04:25:08', NULL, '5', '2018-07-04', NULL),
('9694', '12', '1617', '10', '2018-09-13 04:25:08', 'Voided.\n', '5', '2018-09-13', '0'),
('9695', '12', '1618', '10', '2018-09-13 04:26:55', NULL, '5', '2018-07-04', NULL),
('9696', '12', '1618', '10', '2018-09-13 04:26:55', 'Voided.\n', '5', '2018-09-13', '0'),
('9697', '10', '1220', '1', '2021-02-07 08:09:15', 'Updated.', '5', '2018-06-15', '724'),
('9698', '12', '1619', '1', '2018-11-12 05:17:13', NULL, '5', '2018-07-04', NULL),
('9699', '10', '1206', '1', '2018-09-14 02:24:40', 'Updated.', '5', '2018-09-11', NULL),
('9700', '10', '1207', '1', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-11', '1752'),
('9701', '10', '1208', '1', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-11', '1753'),
('9702', '10', '1209', '1', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-11', '1754'),
('9703', '10', '1211', '1', '2019-06-22 05:31:16', 'Updated.', '6', '2018-09-12', NULL),
('9704', '10', '1212', '1', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-12', '1780'),
('9705', '10', '1215', '1', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-12', '1781'),
('9706', '10', '1216', '1', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-12', '1782'),
('9707', '10', '1217', '1', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-07', '1708'),
('9708', '10', '1218', '1', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-13', '1796'),
('9709', '10', '1219', '1', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-13', '1797'),
('9710', '0', '167', '1', '2021-02-07 08:09:15', NULL, '5', '2018-09-13', '1798'),
('9711', '10', '1206', '1', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-11', '1755'),
('9712', '30', '1237', '10', '2018-09-16 23:22:39', NULL, '5', '2018-09-16', '0'),
('9713', '13', '1237', '10', '2018-09-17 00:26:23', NULL, '5', '2018-09-16', NULL),
('9714', '10', '1221', '10', '2018-09-17 00:26:23', NULL, '5', '2018-09-16', NULL),
('9715', '1', '2976', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-13', '1799'),
('9716', '1', '2977', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-17', '1824'),
('9717', '30', '1238', '10', '2018-09-17 00:24:20', NULL, '5', '2018-09-17', '0'),
('9718', '13', '1238', '10', '2018-09-17 00:24:21', NULL, '5', '2018-09-17', '0'),
('9719', '10', '1222', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-17', '1825'),
('9720', '13', '1237', '10', '2018-09-17 00:26:23', 'Voided.', '5', '2018-09-17', '0'),
('9721', '10', '1221', '10', '2018-09-17 00:26:23', 'Voided.\n', '5', '2018-09-17', '0'),
('9722', '1', '2978', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-17', '1826'),
('9723', '1', '2979', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-17', '1827'),
('9724', '1', '2980', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-17', '1828'),
('9725', '1', '2981', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-17', '1829'),
('9726', '1', '2982', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-03', '951'),
('9727', '1', '2983', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '968'),
('9728', '1', '2984', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '969'),
('9729', '1', '2985', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1083'),
('9730', '1', '2986', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-17', '1104'),
('9731', '1', '2987', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-21', '1153'),
('9732', '1', '2988', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1213'),
('9733', '1', '2989', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1214'),
('9734', '1', '2990', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1215'),
('9735', '1', '2991', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1216'),
('9736', '1', '2992', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1217'),
('9737', '1', '2993', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1218'),
('9738', '1', '2994', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1249'),
('9739', '4', '103', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-03', '952'),
('9740', '4', '104', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-11', '1037'),
('9741', '4', '105', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1219'),
('9742', '2', '166', '10', '2018-10-20 06:56:51', NULL, '5', '2018-07-31', NULL),
('9743', '2', '167', '10', '2018-10-18 03:14:07', NULL, '5', '2018-07-26', NULL),
('9744', '2', '168', '10', '2018-10-18 03:14:25', NULL, '5', '2018-07-26', NULL),
('9745', '2', '169', '10', '2018-09-18 02:05:03', NULL, '5', '2018-07-23', NULL),
('9746', '2', '169', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-23', '1184'),
('9747', '1', '2551', '10', '2018-09-18 02:06:54', 'Voided.\n', '5', '2018-09-18', '0'),
('9748', '1', '2995', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1840'),
('9749', '1', '2996', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1841'),
('9750', '1', '2997', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1842'),
('9751', '1', '2998', '10', '2018-09-18 02:58:18', NULL, '5', '2018-09-18', NULL),
('9752', '1', '2999', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1843'),
('9753', '1', '3000', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1844'),
('9754', '1', '2998', '10', '2018-09-18 02:58:18', 'Voided.\nDocument reentered.', '5', '2018-09-18', '0'),
('9755', '1', '3001', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1845'),
('9756', '1', '3002', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1846'),
('9757', '20', '125', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-03', '1305'),
('9758', '20', '126', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1581'),
('9759', '20', '127', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-21', '1464'),
('9760', '22', '53', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1847'),
('9761', '1', '3003', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1848'),
('9762', '1', '3004', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1849'),
('9763', '1', '3005', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1850'),
('9764', '30', '1239', '10', '2018-09-19 02:14:16', NULL, '5', '2018-09-03', '0'),
('9765', '13', '1239', '10', '2018-09-19 02:14:17', NULL, '5', '2018-09-03', '0'),
('9766', '10', '1223', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-03', '1648'),
('9767', '12', '1620', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-19', '1868'),
('9768', '18', '49', '10', '2018-09-19 02:58:55', NULL, '5', '2018-08-01', '0'),
('9769', '25', '48', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1279'),
('9770', '20', '128', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1280'),
('9771', '22', '54', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-20', '1452'),
('9772', '1', '3006', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-13', '1800'),
('9773', '1', '3007', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-19', '1869'),
('9774', '1', '3008', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-19', '1870'),
('9775', '12', '1567', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-08-20', '1453'),
('9776', '12', '1609', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-12', '1783'),
('9777', '12', '1610', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-12', '1784'),
('9778', '12', '1613', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-12', '1785'),
('9779', '12', '1614', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-13', '1801'),
('9780', '12', '1616', '10', '2018-09-19 05:04:19', 'Updated.', '5', '2018-09-13', NULL),
('9781', '12', '1621', '10', '2018-09-19 05:04:58', NULL, '5', '2018-09-13', NULL),
('9782', '12', '1616', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-13', '1802'),
('9783', '12', '1615', '10', '2018-09-19 05:07:11', 'Updated.', '5', '2018-09-13', NULL),
('9784', '12', '1621', '10', '2018-11-08 04:20:07', 'Updated.', '5', '2018-09-13', NULL),
('9785', '12', '1615', '10', '2018-11-08 04:19:54', 'Updated.', '5', '2018-09-13', NULL),
('9786', '30', '1240', '10', '2018-09-20 01:08:28', NULL, '5', '2018-05-23', '0'),
('9787', '13', '1240', '10', '2018-09-20 01:08:28', NULL, '5', '2018-05-23', '0'),
('9788', '10', '1224', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '500'),
('9789', '12', '1622', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '501'),
('9790', '1', '3009', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-02', '280'),
('9791', '1', '3010', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-28', '545'),
('9792', '30', '1241', '10', '2018-09-20 01:26:04', NULL, '5', '2018-06-25', '0'),
('9793', '13', '1241', '10', '2018-09-20 01:26:04', NULL, '5', '2018-06-25', '0'),
('9794', '10', '1225', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-25', '838'),
('9795', '12', '1623', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-26', '866'),
('9796', '30', '1242', '10', '2018-09-20 01:31:34', NULL, '5', '2018-07-24', '0'),
('9797', '13', '1242', '10', '2018-09-20 01:31:35', NULL, '5', '2018-07-24', '0'),
('9798', '10', '1226', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-24', '1194'),
('9799', '12', '1624', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-25', '1201'),
('9800', '30', '1243', '10', '2018-09-20 01:34:07', NULL, '5', '2018-08-26', '0'),
('9801', '13', '1243', '10', '2018-09-20 01:34:07', NULL, '5', '2018-08-26', '0'),
('9802', '10', '1227', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-26', '1504'),
('9803', '12', '1625', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1523'),
('9804', '4', '106', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1524'),
('9805', '30', '1244', '10', '2018-09-20 01:47:24', NULL, '5', '2018-07-03', '0'),
('9806', '13', '1244', '10', '2018-09-20 01:47:24', NULL, '5', '2018-07-03', '0'),
('9807', '10', '1228', '10', '2018-10-03 05:35:23', NULL, '5', '2018-07-03', NULL),
('9808', '12', '1626', '10', '2018-10-03 05:35:50', NULL, '5', '2018-07-03', NULL),
('9809', '30', '1245', '10', '2018-09-20 01:52:52', NULL, '5', '2018-07-31', '0'),
('9810', '13', '1245', '10', '2018-09-20 01:52:52', NULL, '5', '2018-07-31', '0'),
('9811', '10', '1229', '10', '2018-09-20 01:54:15', NULL, '5', '2018-07-31', NULL),
('9812', '10', '1229', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-07-02', '933'),
('9813', '4', '107', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1605'),
('9814', '4', '108', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-08', '1333'),
('9815', '1', '3011', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-20', '1884'),
('9816', '1', '3012', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-20', '1885'),
('9817', '1', '3013', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-20', '1886'),
('9818', '1', '3014', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '631'),
('9819', '1', '3015', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '904'),
('9820', '30', '1246', '10', '2018-09-20 06:25:11', NULL, '5', '2018-06-07', '0'),
('9821', '13', '1246', '10', '2018-09-20 06:25:11', NULL, '5', '2018-06-07', '0'),
('9822', '10', '1230', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '632'),
('9823', '30', '1247', '10', '2018-09-20 06:26:20', NULL, '5', '2018-06-13', '0'),
('9824', '13', '1247', '10', '2018-09-20 06:26:20', NULL, '5', '2018-06-13', '0'),
('9825', '10', '1231', '10', '2018-10-15 02:13:36', NULL, '5', '2018-06-13', NULL),
('9826', '12', '1627', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-07', '633'),
('9827', '12', '1628', '10', '2018-10-15 02:13:59', NULL, '5', '2018-06-13', NULL),
('9828', '1', '3016', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-19', '1871'),
('9829', '1', '3017', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-19', '1872'),
('9830', '1', '3018', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-19', '1873'),
('9831', '30', '1248', '10', '2018-09-21 00:53:31', NULL, '5', '2018-09-19', '0'),
('9832', '13', '1248', '10', '2018-09-21 00:53:32', NULL, '5', '2018-09-19', '0'),
('9833', '10', '1232', '10', '2018-09-21 00:55:07', NULL, '5', '2018-09-19', NULL),
('9834', '30', '1249', '10', '2018-09-21 00:54:13', NULL, '5', '2018-07-31', '0'),
('9835', '13', '1249', '10', '2018-12-02 23:59:36', NULL, '5', '2018-07-31', NULL),
('9836', '10', '1233', '10', '2018-12-02 23:59:36', NULL, '5', '2018-07-31', NULL),
('9837', '10', '1232', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-08-31', '1621'),
('9838', '13', '1216', '10', '2018-09-21 00:56:06', 'Voided.', '5', '2018-09-21', '0'),
('9839', '10', '1202', '10', '2018-09-21 00:56:07', 'Voided.\n', '5', '2018-09-21', '0'),
('9840', '30', '1250', '10', '2018-09-21 00:59:58', NULL, '5', '2018-08-31', '0'),
('9841', '13', '1250', '10', '2018-09-21 00:59:58', NULL, '5', '2018-08-31', '0'),
('9842', '10', '1234', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1622'),
('9843', '30', '1251', '10', '2018-09-21 01:01:20', NULL, '5', '2018-08-31', '0'),
('9844', '13', '1251', '10', '2018-09-21 01:01:20', NULL, '5', '2018-08-31', '0'),
('9845', '10', '1235', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1623'),
('9846', '1', '3019', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-21', '1901'),
('9847', '1', '3020', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-21', '1902'),
('9848', '1', '3021', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-21', '1903'),
('9849', '1', '3022', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-21', '1904'),
('9850', '12', '1629', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-01', '2038'),
('9851', '1', '3023', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-21', '1905'),
('9852', '30', '1252', '10', '2018-09-21 02:52:42', NULL, '5', '2018-09-21', '0'),
('9853', '13', '1252', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-21', '1906'),
('9854', '10', '1236', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-21', '1907'),
('9855', '12', '1630', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-21', '1908'),
('9856', '1', '3024', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-21', '1909'),
('9857', '1', '3025', '10', '2018-09-21 03:49:43', NULL, '5', '2018-09-21', NULL),
('9858', '1', '3026', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-21', '1910'),
('9859', '1', '3025', '10', '2018-09-21 03:49:43', 'Voided.\nDocument reentered.', '5', '2018-09-21', '0'),
('9860', '1', '3027', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-21', '1911'),
('9861', '1', '3028', '10', '2018-09-21 05:11:09', NULL, '5', '2018-09-21', NULL),
('9862', '1', '3029', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-21', '1912'),
('9863', '1', '3028', '10', '2018-09-21 05:11:09', 'Voided.\nDocument reentered.', '5', '2018-09-21', '0'),
('9864', '30', '1253', '10', '2018-09-25 01:33:23', NULL, '5', '2018-09-25', '0'),
('9865', '13', '1253', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1927'),
('9866', '10', '1237', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1928'),
('9867', '1', '3030', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1929'),
('9868', '1', '3031', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1930'),
('9869', '1', '3032', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1931'),
('9870', '12', '1631', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1932'),
('9871', '1', '3033', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1933'),
('9872', '1', '3034', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-17', '1830'),
('9873', '30', '1254', '10', '2018-09-25 22:49:13', NULL, '5', '2018-07-02', '0'),
('9874', '13', '1254', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '934'),
('9875', '10', '1238', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '935'),
('9876', '30', '1255', '10', '2018-09-25 22:50:19', NULL, '5', '2018-07-06', '0'),
('9877', '13', '1255', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-06', '987'),
('9878', '10', '1239', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-06', '988'),
('9879', '30', '1256', '10', '2018-09-25 22:52:37', NULL, '5', '2018-07-09', '0'),
('9880', '13', '1256', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1015'),
('9881', '10', '1240', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1016'),
('9882', '30', '1257', '10', '2018-09-25 22:54:00', NULL, '5', '2018-07-11', '0'),
('9883', '13', '1257', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-11', '1038'),
('9884', '10', '1241', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-11', '1039'),
('9885', '30', '1258', '10', '2018-09-25 22:56:53', NULL, '5', '2018-07-11', '0'),
('9886', '13', '1258', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-11', '1040'),
('9887', '10', '1242', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-11', '1041'),
('9888', '30', '1259', '10', '2018-09-25 22:57:52', NULL, '5', '2018-07-11', '0'),
('9889', '13', '1259', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-11', '1042'),
('9890', '10', '1243', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-11', '1043'),
('9891', '30', '1260', '10', '2018-09-25 22:59:44', NULL, '5', '2018-07-11', '0'),
('9892', '13', '1260', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-11', '1044'),
('9893', '10', '1244', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-11', '1045'),
('9894', '30', '1261', '10', '2018-09-25 23:00:50', NULL, '5', '2018-07-13', '0'),
('9895', '13', '1261', '10', '2018-09-25 23:00:50', NULL, '5', '2018-07-13', '0'),
('9896', '10', '1245', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1084'),
('9897', '30', '1262', '10', '2018-09-25 23:01:56', NULL, '5', '2018-07-12', '0'),
('9898', '13', '1262', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1049'),
('9899', '10', '1246', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1050'),
('9900', '30', '1263', '10', '2018-09-25 23:03:44', NULL, '5', '2018-07-12', '0'),
('9901', '13', '1263', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1051'),
('9902', '10', '1247', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1052'),
('9903', '30', '1264', '10', '2018-09-25 23:05:54', NULL, '5', '2018-07-20', '0'),
('9904', '13', '1264', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1151'),
('9905', '10', '1248', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-20', '1152'),
('9906', '30', '1265', '10', '2018-09-25 23:22:52', NULL, '5', '2018-07-25', '0'),
('9907', '13', '1265', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-25', '1202'),
('9908', '10', '1249', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-25', '1203'),
('9909', '30', '1266', '10', '2018-09-25 23:26:00', NULL, '5', '2018-07-30', '0'),
('9910', '13', '1266', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-30', '1233'),
('9911', '10', '1250', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-30', '1234'),
('9912', '30', '1267', '10', '2018-09-25 23:27:12', NULL, '5', '2018-07-30', '0'),
('9913', '13', '1267', '10', '2018-09-25 23:27:12', NULL, '5', '2018-07-30', '0'),
('9914', '10', '1251', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-30', '1235'),
('9915', '30', '1268', '10', '2018-09-25 23:57:33', NULL, '5', '2018-07-31', '0'),
('9916', '13', '1268', '10', '2018-09-25 23:57:34', NULL, '5', '2018-07-31', '0'),
('9917', '10', '1252', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1250'),
('9918', '30', '1269', '10', '2018-09-25 23:59:00', NULL, '5', '2018-07-31', '0'),
('9919', '13', '1269', '10', '2018-09-25 23:59:00', NULL, '5', '2018-07-31', '0'),
('9920', '10', '1253', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1251'),
('9921', '30', '1270', '10', '2018-09-26 00:00:33', NULL, '5', '2018-07-31', '0'),
('9922', '13', '1270', '10', '2019-07-30 01:26:07', NULL, '6', '2018-07-31', NULL),
('9923', '10', '1254', '10', '2019-07-30 01:26:07', NULL, '6', '2018-07-31', NULL),
('9924', '30', '1271', '10', '2018-09-26 00:01:44', NULL, '5', '2018-07-31', '0'),
('9925', '13', '1271', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1252'),
('9926', '10', '1255', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1253'),
('9927', '30', '1272', '10', '2018-09-26 00:03:03', NULL, '5', '2018-07-31', '0'),
('9928', '13', '1272', '10', '2018-09-26 00:03:03', NULL, '5', '2018-07-31', '0'),
('9929', '10', '1256', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1254'),
('9930', '30', '1273', '10', '2018-09-26 00:04:24', NULL, '5', '2018-08-03', '0'),
('9931', '13', '1273', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-03', '1306'),
('9932', '10', '1257', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-03', '1307'),
('9933', '30', '1274', '10', '2018-09-26 00:07:03', NULL, '5', '2018-08-10', '0'),
('9934', '13', '1274', '10', '2018-09-26 00:07:03', NULL, '5', '2018-08-10', '0'),
('9935', '10', '1258', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-10', '1358'),
('9936', '30', '1275', '10', '2018-09-26 00:11:04', NULL, '5', '2018-08-10', '0'),
('9937', '13', '1275', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-10', '1359'),
('9938', '10', '1259', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-10', '1360'),
('9939', '30', '1276', '10', '2018-09-26 00:12:46', NULL, '5', '2018-08-10', '0'),
('9940', '13', '1276', '10', '2018-09-26 00:12:46', NULL, '5', '2018-08-10', '0'),
('9941', '10', '1260', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-10', '1361'),
('9942', '30', '1277', '10', '2018-09-26 00:14:05', NULL, '5', '2018-08-10', '0'),
('9943', '13', '1277', '10', '2018-09-26 00:14:05', NULL, '5', '2018-08-10', '0'),
('9944', '10', '1261', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-10', '1362'),
('9945', '30', '1278', '10', '2018-09-26 00:15:55', NULL, '5', '2018-08-13', '0'),
('9946', '13', '1278', '10', '2018-09-26 00:15:55', NULL, '5', '2018-08-13', '0'),
('9947', '10', '1262', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1381'),
('9948', '30', '1279', '10', '2018-09-26 00:18:10', NULL, '5', '2018-08-13', '0'),
('9949', '13', '1279', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1382'),
('9950', '10', '1263', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1383'),
('9951', '30', '1280', '10', '2018-09-26 00:19:10', NULL, '5', '2018-08-16', '0'),
('9952', '13', '1280', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-16', '1423'),
('9953', '10', '1264', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-16', '1424'),
('9954', '30', '1281', '10', '2018-09-26 00:20:31', NULL, '5', '2018-08-20', '0'),
('9955', '13', '1281', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-20', '1454'),
('9956', '10', '1265', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-20', '1455'),
('9957', '30', '1282', '10', '2018-09-26 00:22:27', NULL, '5', '2018-08-20', '0'),
('9958', '13', '1282', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-20', '1456'),
('9959', '10', '1266', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-20', '1457'),
('9960', '30', '1283', '10', '2018-09-26 00:26:41', NULL, '5', '2018-08-22', '0'),
('9961', '13', '1283', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-22', '1472'),
('9962', '10', '1267', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-22', '1473'),
('9963', '30', '1284', '10', '2018-09-26 00:29:21', NULL, '5', '2018-08-22', '0'),
('9964', '13', '1284', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-22', '1474'),
('9965', '10', '1268', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-22', '1475'),
('9966', '30', '1285', '10', '2018-09-26 00:30:41', NULL, '5', '2018-08-22', '0'),
('9967', '13', '1285', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-22', '1476'),
('9968', '10', '1269', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-22', '1477'),
('9969', '30', '1286', '10', '2018-09-26 00:31:58', NULL, '5', '2018-08-23', '0'),
('9970', '13', '1286', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-23', '1486'),
('9971', '10', '1270', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-23', '1487'),
('9972', '30', '1287', '10', '2018-09-26 00:34:23', NULL, '5', '2018-08-27', '0'),
('9973', '13', '1287', '10', '2018-09-26 00:37:32', NULL, '5', '2018-08-27', NULL),
('9974', '10', '1271', '10', '2018-09-26 00:37:32', NULL, '5', '2018-08-27', NULL),
('9975', '30', '1288', '10', '2018-09-26 00:35:52', NULL, '5', '2018-08-27', '0'),
('9976', '13', '1288', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1525'),
('9977', '10', '1272', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1526'),
('9978', '13', '1287', '10', '2018-09-26 00:37:32', 'Voided.', '5', '2018-09-26', '0'),
('9979', '10', '1271', '10', '2018-09-26 00:37:32', 'Voided.\n', '5', '2018-09-26', '0'),
('9980', '30', '1289', '10', '2018-09-26 00:39:34', NULL, '5', '2018-08-27', '0'),
('9981', '13', '1289', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1527'),
('9982', '10', '1273', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1528'),
('9983', '30', '1290', '10', '2018-09-26 00:41:36', NULL, '5', '2018-08-28', '0'),
('9984', '13', '1290', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1557'),
('9985', '10', '1274', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1558'),
('9986', '30', '1291', '10', '2018-09-26 00:44:09', NULL, '5', '2018-08-28', '0'),
('9987', '13', '1291', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1559'),
('9988', '10', '1275', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1560'),
('9989', '30', '1292', '10', '2018-09-26 00:45:08', NULL, '5', '2018-08-30', '0'),
('9990', '13', '1292', '10', '2018-09-26 00:45:08', NULL, '5', '2018-08-30', '0'),
('9991', '10', '1276', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1606'),
('9992', '30', '1293', '10', '2018-09-26 00:46:37', NULL, '5', '2018-08-31', '0'),
('9993', '13', '1293', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1624'),
('9994', '10', '1277', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1625'),
('9995', '30', '1294', '10', '2018-09-26 00:47:26', NULL, '5', '2018-08-31', '0'),
('9996', '13', '1294', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1626'),
('9997', '10', '1278', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1627'),
('9998', '30', '1295', '10', '2018-09-26 00:48:24', NULL, '5', '2018-08-31', '0'),
('9999', '13', '1295', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1628'),
('10000', '10', '1279', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1629'),
('10001', '1', '3035', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-26', '1949'),
('10002', '30', '1296', '10', '2018-09-26 01:09:48', NULL, '5', '2018-07-13', '0'),
('10003', '13', '1296', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1085'),
('10004', '10', '1280', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1086'),
('10005', '30', '1297', '10', '2018-09-26 01:10:42', NULL, '5', '2018-07-16', '0'),
('10006', '13', '1297', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-16', '1094'),
('10007', '10', '1281', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-16', '1095'),
('10008', '30', '1298', '10', '2018-09-26 01:12:53', NULL, '5', '2018-07-16', '0'),
('10009', '13', '1298', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-16', '1096'),
('10010', '10', '1282', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-16', '1097'),
('10011', '30', '1299', '10', '2018-09-26 01:14:25', NULL, '5', '2018-07-12', '0'),
('10012', '13', '1299', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1053'),
('10013', '10', '1283', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1054'),
('10014', '30', '1300', '10', '2018-09-26 01:15:34', NULL, '5', '2018-07-12', '0'),
('10015', '13', '1300', '10', '2018-09-26 01:15:34', NULL, '5', '2018-07-12', '0'),
('10016', '10', '1284', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1055'),
('10017', '30', '1301', '10', '2018-09-26 01:16:25', NULL, '5', '2018-07-12', '0'),
('10018', '13', '1301', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1056'),
('10019', '10', '1285', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1057'),
('10020', '30', '1302', '10', '2018-09-26 01:17:18', NULL, '5', '2018-07-26', '0'),
('10021', '13', '1302', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1220'),
('10022', '10', '1286', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-26', '1221'),
('10023', '30', '1303', '10', '2018-09-26 01:18:30', NULL, '5', '2018-07-13', '0'),
('10024', '13', '1303', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1087'),
('10025', '10', '1287', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-13', '1088'),
('10026', '30', '1304', '10', '2018-09-26 01:19:35', NULL, '5', '2018-07-19', '0'),
('10027', '13', '1304', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-19', '1131'),
('10028', '10', '1288', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-19', '1132'),
('10029', '30', '1305', '10', '2018-09-26 01:21:15', NULL, '5', '2018-08-13', '0'),
('10030', '13', '1305', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1384'),
('10031', '10', '1289', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1385'),
('10032', '30', '1306', '10', '2018-09-26 01:24:10', NULL, '5', '2018-08-14', '0'),
('10033', '13', '1306', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1400'),
('10034', '10', '1290', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1401'),
('10035', '30', '1307', '10', '2018-09-26 01:26:30', NULL, '5', '2018-08-14', '0'),
('10036', '13', '1307', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1402'),
('10037', '10', '1291', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1403'),
('10038', '30', '1308', '10', '2018-09-26 01:29:02', NULL, '5', '2018-08-14', '0'),
('10039', '13', '1308', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1404'),
('10040', '10', '1292', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1405'),
('10041', '30', '1309', '10', '2018-09-26 01:30:43', NULL, '5', '2018-08-14', '0'),
('10042', '13', '1309', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1406'),
('10043', '10', '1293', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1407'),
('10044', '30', '1310', '10', '2018-09-26 01:32:35', NULL, '5', '2018-08-27', '0'),
('10045', '13', '1310', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1529'),
('10046', '10', '1294', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1530'),
('10047', '30', '1311', '10', '2018-09-26 01:33:25', NULL, '5', '2018-08-27', '0'),
('10048', '13', '1311', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1531'),
('10049', '10', '1295', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1532'),
('10050', '30', '1312', '10', '2018-09-26 01:34:56', NULL, '5', '2018-08-28', '0'),
('10051', '13', '1312', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1561'),
('10052', '10', '1296', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1562'),
('10053', '1', '3036', '10', '2018-10-11 23:54:54', NULL, '5', '2018-09-26', NULL),
('10054', '1', '3037', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-26', '1950'),
('10055', '1', '3038', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-26', '1951'),
('10056', '16', '56', '10', '2018-09-26 05:05:55', NULL, '5', '2018-09-21', '0'),
('10057', '16', '57', '10', '2018-09-26 05:06:49', NULL, '5', '2018-09-07', '0'),
('10058', '30', '1313', '10', '2018-09-26 05:10:18', NULL, '5', '2018-09-26', '0'),
('10059', '13', '1313', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-26', '1952'),
('10060', '10', '1297', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-26', '1953'),
('10061', '12', '1632', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-26', '1954'),
('10062', '1', '3039', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-26', '1955'),
('10063', '1', '3040', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1961'),
('10064', '1', '3041', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1962'),
('10065', '1', '3042', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1963'),
('10066', '1', '3043', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1964'),
('10067', '1', '3044', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1965'),
('10068', '1', '3045', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1966'),
('10069', '1', '3046', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1967'),
('10070', '1', '3047', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1968'),
('10071', '1', '3048', '10', '2019-05-13 06:26:26', NULL, '6', '2018-09-27', NULL),
('10072', '1', '3049', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1969'),
('10073', '1', '3050', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '1994'),
('10074', '11', '179', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-10', '1363'),
('10075', '12', '1633', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-10', '1364'),
('10076', '11', '180', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-10', '1365'),
('10077', '1', '3051', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '1995'),
('10078', '1', '3052', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '1996'),
('10079', '12', '1634', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-24', '1921'),
('10080', '12', '1635', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-24', '1922'),
('10081', '11', '181', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1582'),
('10082', '11', '182', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1583'),
('10083', '11', '183', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1584'),
('10084', '11', '184', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1585'),
('10085', '30', '1314', '10', '2018-09-28 01:26:39', NULL, '5', '2018-08-28', '0'),
('10086', '13', '1314', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1563'),
('10087', '10', '1298', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1564'),
('10088', '30', '1315', '10', '2018-09-28 01:28:08', NULL, '5', '2018-08-30', '0'),
('10089', '13', '1315', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1607'),
('10090', '10', '1299', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1608'),
('10091', '30', '1316', '10', '2018-09-28 01:29:17', NULL, '5', '2018-08-30', '0'),
('10092', '13', '1316', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1609'),
('10093', '10', '1300', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1610'),
('10094', '12', '1636', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1970'),
('10095', '12', '1637', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-24', '1923'),
('10096', '30', '1317', '10', '2018-09-28 01:58:57', NULL, '5', '2018-06-22', '0'),
('10097', '13', '1317', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '820'),
('10098', '10', '1301', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-22', '821'),
('10099', '30', '1318', '10', '2018-09-28 02:05:22', NULL, '5', '2018-06-28', '0'),
('10100', '13', '1318', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-28', '877'),
('10101', '10', '1302', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-28', '878'),
('10102', '30', '1319', '10', '2018-09-28 02:07:02', NULL, '5', '2018-06-29', '0'),
('10103', '13', '1319', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '905'),
('10104', '10', '1303', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-29', '906'),
('10105', '30', '1320', '10', '2018-09-28 02:10:35', NULL, '5', '2018-07-02', '0'),
('10106', '13', '1320', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '936'),
('10107', '10', '1304', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-02', '937'),
('10108', '30', '1321', '10', '2018-09-28 02:12:57', NULL, '5', '2018-07-05', '0'),
('10109', '13', '1321', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-05', '977'),
('10110', '10', '1305', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-05', '978'),
('10111', '30', '1322', '10', '2018-09-28 02:13:56', NULL, '5', '2018-07-21', '0'),
('10112', '13', '1322', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-21', '1154'),
('10113', '10', '1306', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-21', '1155'),
('10114', '30', '1323', '10', '2018-09-28 02:16:54', NULL, '5', '2018-08-01', '0'),
('10115', '13', '1323', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1281'),
('10116', '10', '1307', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1282'),
('10117', '30', '1324', '10', '2018-09-28 02:24:19', NULL, '5', '2018-08-03', '0'),
('10118', '13', '1324', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-03', '1308'),
('10119', '10', '1308', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-03', '1309'),
('10120', '30', '1325', '10', '2018-09-28 02:28:57', NULL, '5', '2018-08-03', '0'),
('10121', '13', '1325', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-03', '1310'),
('10122', '10', '1309', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-03', '1311'),
('10123', '30', '1326', '10', '2018-09-28 02:30:01', NULL, '5', '2018-08-06', '0'),
('10124', '13', '1326', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-06', '1319'),
('10125', '10', '1310', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-06', '1320'),
('10126', '1', '3053', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '1997'),
('10127', '1', '3054', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '1998'),
('10128', '30', '1327', '10', '2018-09-30 23:19:52', NULL, '5', '2018-09-30', '0'),
('10129', '13', '1327', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-30', '2031'),
('10130', '10', '1311', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-30', '2032'),
('10131', '12', '1638', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-01', '2039'),
('10132', '12', '1639', '10', '2018-10-12 04:13:11', NULL, '5', '2018-10-15', NULL),
('10133', '22', '55', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-01', '2040'),
('10134', '30', '1328', '10', '2018-10-01 01:57:10', NULL, '5', '2018-08-06', '0'),
('10135', '13', '1328', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-06', '1321'),
('10136', '10', '1312', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-06', '1322'),
('10137', '30', '1329', '10', '2018-10-01 01:59:45', NULL, '5', '2018-08-13', '0'),
('10138', '13', '1329', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1386'),
('10139', '10', '1313', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-13', '1387'),
('10140', '30', '1330', '10', '2018-10-01 02:00:35', NULL, '5', '2018-08-14', '0'),
('10141', '13', '1330', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1408'),
('10142', '10', '1314', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-14', '1409'),
('10143', '30', '1331', '10', '2018-10-01 02:03:57', NULL, '5', '2018-08-15', '0'),
('10144', '13', '1331', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-15', '1415'),
('10145', '10', '1315', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-15', '1416'),
('10146', '30', '1332', '10', '2018-10-01 02:05:50', NULL, '5', '2018-08-15', '0'),
('10147', '13', '1332', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-15', '1417'),
('10148', '10', '1316', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-15', '1418'),
('10149', '30', '1333', '10', '2018-10-01 02:07:48', NULL, '5', '2018-08-22', '0'),
('10150', '13', '1333', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-22', '1478'),
('10151', '10', '1317', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-22', '1479'),
('10152', '30', '1334', '10', '2018-10-01 02:09:05', NULL, '5', '2018-08-23', '0'),
('10153', '13', '1334', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-23', '1488'),
('10154', '10', '1318', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-23', '1489'),
('10155', '30', '1335', '10', '2018-10-01 02:10:47', NULL, '5', '2018-08-28', '0'),
('10156', '13', '1335', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1565'),
('10157', '10', '1319', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1566'),
('10158', '30', '1336', '10', '2018-10-01 02:14:57', NULL, '5', '2018-08-28', '0'),
('10159', '13', '1336', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1567'),
('10160', '10', '1320', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1568'),
('10161', '30', '1337', '10', '2018-10-01 02:18:53', NULL, '5', '2018-07-04', '0'),
('10162', '13', '1337', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '970'),
('10163', '10', '1321', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-04', '971'),
('10164', '30', '1338', '10', '2018-10-01 02:32:34', NULL, '5', '2018-07-12', '0'),
('10165', '13', '1338', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1058'),
('10166', '10', '1322', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1059'),
('10167', '30', '1339', '10', '2018-10-01 02:38:08', NULL, '5', '2018-07-12', '0'),
('10168', '13', '1339', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1060'),
('10169', '10', '1323', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-12', '1061'),
('10170', '30', '1340', '10', '2018-10-01 02:39:25', NULL, '5', '2018-07-09', '0'),
('10171', '13', '1340', '10', '2018-10-01 02:39:25', NULL, '5', '2018-07-09', '0'),
('10172', '10', '1324', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-09', '1017'),
('10173', '30', '1341', '10', '2018-10-01 02:40:48', NULL, '5', '2018-07-07', '0'),
('10174', '13', '1341', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-07', '992'),
('10175', '10', '1325', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-07', '993'),
('10176', '30', '1342', '10', '2018-10-01 02:41:41', NULL, '5', '2018-07-07', '0'),
('10177', '13', '1342', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-07', '994'),
('10178', '10', '1326', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-07', '995'),
('10179', '30', '1343', '10', '2018-10-01 03:27:10', NULL, '5', '2018-08-01', '0'),
('10180', '13', '1343', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1283'),
('10181', '10', '1327', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1284'),
('10182', '30', '1344', '10', '2018-10-01 03:32:20', NULL, '5', '2018-08-15', '0'),
('10183', '13', '1344', '10', '2018-10-01 04:13:43', NULL, '5', '2018-08-15', NULL),
('10184', '10', '1328', '10', '2018-10-01 04:13:43', NULL, '5', '2018-08-15', NULL),
('10185', '30', '1345', '10', '2018-10-01 03:34:26', NULL, '5', '2018-08-16', '0'),
('10186', '13', '1345', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-16', '1425'),
('10187', '10', '1329', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-16', '1426'),
('10188', '30', '1346', '10', '2018-10-01 03:36:09', NULL, '5', '2018-08-16', '0'),
('10189', '13', '1346', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-16', '1427'),
('10190', '10', '1330', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-16', '1428'),
('10191', '30', '1347', '10', '2018-10-01 03:43:44', NULL, '5', '2018-08-21', '0'),
('10192', '13', '1347', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-21', '1465'),
('10193', '10', '1331', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-21', '1466'),
('10194', '30', '1348', '10', '2018-10-01 03:44:38', NULL, '5', '2018-08-21', '0'),
('10195', '13', '1348', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-21', '1467'),
('10196', '10', '1332', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-21', '1468'),
('10197', '30', '1349', '10', '2018-10-01 03:46:28', NULL, '5', '2018-08-28', '0'),
('10198', '13', '1349', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1569'),
('10199', '10', '1333', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-28', '1570'),
('10200', '30', '1350', '10', '2018-10-01 03:50:14', NULL, '5', '2018-08-29', '0'),
('10201', '13', '1350', '10', '2018-10-01 03:50:14', NULL, '5', '2018-08-29', '0'),
('10202', '10', '1334', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1586'),
('10203', '30', '1351', '10', '2018-10-01 04:13:09', NULL, '5', '2018-08-15', '0'),
('10204', '13', '1351', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-15', '1419'),
('10205', '10', '1335', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-15', '1420'),
('10206', '13', '1344', '10', '2018-10-01 04:13:43', 'Voided.', '5', '2018-10-01', '0'),
('10207', '10', '1328', '10', '2018-10-01 04:13:43', 'Voided.\n', '5', '2018-10-01', '0'),
('10208', '11', '185', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1756'),
('10209', '11', '186', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1757'),
('10210', '11', '187', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1758'),
('10211', '12', '1640', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1285'),
('10212', '11', '188', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1679'),
('10213', '11', '189', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1680'),
('10214', '11', '190', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1681'),
('10215', '11', '191', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1682'),
('10216', '1', '3055', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-01', '2041'),
('10217', '1', '3056', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-01', '2042'),
('10218', '1', '3057', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-01', '2043'),
('10219', '30', '1352', '10', '2018-10-01 06:44:47', NULL, '5', '2018-10-01', '0'),
('10220', '13', '1352', '10', '2018-10-01 06:44:48', NULL, '5', '2018-10-01', '0'),
('10221', '10', '1336', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-01', '2044'),
('10222', '1', '3058', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2056'),
('10223', '1', '3059', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2057'),
('10224', '1', '3060', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2058'),
('10225', '12', '1641', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2059'),
('10226', '12', '1642', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2060'),
('10227', '12', '1643', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2061'),
('10228', '12', '1644', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2062'),
('10229', '12', '1645', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2063'),
('10230', '12', '1646', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2064'),
('10231', '12', '1647', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2065'),
('10232', '12', '1648', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2066'),
('10233', '12', '1649', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2067'),
('10234', '12', '1650', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2068'),
('10235', '11', '192', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2069'),
('10236', '11', '193', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2070'),
('10237', '12', '1651', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2071'),
('10238', '12', '1652', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2072'),
('10239', '12', '1653', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-19', '2260'),
('10240', '12', '1654', '10', '2018-10-02 03:30:09', NULL, '5', '2018-10-19', NULL),
('10241', '12', '1654', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-28', '1999'),
('10242', '12', '1655', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2000'),
('10243', '12', '1656', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-08', '2125'),
('10244', '12', '1657', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2073'),
('10245', '12', '1658', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2097'),
('10246', '12', '1659', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-09', '2139'),
('10247', '12', '1660', '10', '2018-10-02 03:44:43', NULL, '5', '2018-10-09', NULL),
('10248', '12', '1660', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-10-17', '2206'),
('10249', '12', '1661', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-10', '2151'),
('10250', '12', '1662', '10', '2018-10-17 01:27:50', NULL, '5', '2018-10-29', NULL),
('10251', '12', '1663', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-03', '2083'),
('10252', '12', '1664', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2074'),
('10253', '12', '1665', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2075'),
('10254', '12', '1666', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2098'),
('10255', '1', '3061', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2076'),
('10256', '1', '3062', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-01', '2045'),
('10257', '1', '3063', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1587'),
('10258', '1', '3064', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1611'),
('10259', '1', '3065', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1612'),
('10260', '1', '3066', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1613'),
('10261', '30', '1353', '10', '2018-10-03 01:06:52', NULL, '5', '2018-10-03', '0'),
('10262', '13', '1353', '10', '2018-10-03 01:06:52', NULL, '5', '2018-10-03', '0'),
('10263', '10', '1337', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-03', '2084'),
('10264', '30', '1354', '10', '2018-10-03 01:14:22', NULL, '5', '2018-09-04', '0');
INSERT INTO `0_audit_trail` VALUES
('10265', '13', '1354', '10', '2018-10-03 01:14:22', NULL, '5', '2018-09-04', '0'),
('10266', '10', '1338', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-04', '1658'),
('10267', '12', '1667', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2077'),
('10268', '1', '3067', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-03', '2085'),
('10269', '1', '3068', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-05', '979'),
('10270', '1', '3069', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1255'),
('10271', '1', '3070', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1256'),
('10272', '1', '3071', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-17', '1105'),
('10273', '12', '1668', '10', '2018-10-03 05:31:02', NULL, '5', '2018-07-17', NULL),
('10274', '12', '1668', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-07-17', '1106'),
('10275', '30', '1355', '10', '2018-10-03 05:34:18', NULL, '5', '2018-08-07', '0'),
('10276', '13', '1355', '10', '2018-10-03 05:34:18', NULL, '5', '2018-08-07', '0'),
('10277', '10', '1339', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-07', '1325'),
('10278', '30', '1356', '10', '2018-10-03 05:35:03', NULL, '5', '2018-08-29', '0'),
('10279', '13', '1356', '10', '2018-10-03 05:35:03', NULL, '5', '2018-08-29', '0'),
('10280', '10', '1340', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1588'),
('10281', '10', '1228', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-07-03', '953'),
('10282', '12', '1626', '10', '2018-10-03 05:36:04', 'Updated.', '5', '2018-07-03', NULL),
('10283', '12', '1626', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-07-03', '954'),
('10284', '12', '1669', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-08', '1334'),
('10285', '12', '1670', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1614'),
('10286', '1', '3072', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-05', '980'),
('10287', '1', '3073', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-06', '989'),
('10288', '1', '3074', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-03', '2086'),
('10289', '1', '3075', '10', '2018-10-14 23:56:06', NULL, '5', '2018-10-04', NULL),
('10290', '1', '3076', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-04', '2087'),
('10291', '1', '3077', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-04', '2088'),
('10292', '1', '3078', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-04', '2089'),
('10293', '1', '3079', '10', '2018-10-05 05:14:34', NULL, '5', '2018-10-05', NULL),
('10294', '1', '3080', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2099'),
('10295', '1', '3081', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2100'),
('10296', '1', '3082', '10', '2018-10-05 05:15:38', NULL, '5', '2018-10-05', NULL),
('10297', '1', '3079', '10', '2018-10-05 05:14:34', 'Voided.\nDocument reentered.', '5', '2018-10-05', '0'),
('10298', '1', '3083', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2101'),
('10299', '1', '3082', '10', '2018-10-05 05:15:38', 'Voided.\nDocument reentered.', '5', '2018-10-05', '0'),
('10300', '1', '3084', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2102'),
('10301', '18', '50', '10', '2018-10-08 06:29:21', NULL, '5', '2018-09-01', '0'),
('10302', '25', '49', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-01', '1637'),
('10303', '20', '129', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-01', '1638'),
('10304', '18', '51', '10', '2018-10-08 06:30:05', NULL, '5', '2018-09-01', '0'),
('10305', '25', '50', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-01', '1639'),
('10306', '20', '130', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-01', '1640'),
('10307', '22', '56', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-08', '2126'),
('10308', '18', '52', '10', '2018-10-08 06:47:31', NULL, '5', '2018-09-12', '0'),
('10309', '25', '51', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-12', '1786'),
('10310', '20', '131', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-12', '1787'),
('10311', '18', '53', '10', '2018-10-08 06:50:43', NULL, '5', '2018-09-12', '0'),
('10312', '25', '52', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-12', '1788'),
('10313', '20', '132', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-12', '1789'),
('10314', '18', '54', '10', '2018-10-08 06:52:04', NULL, '5', '2018-09-12', '0'),
('10315', '25', '53', '10', '2018-10-08 06:52:04', NULL, '5', '2018-09-12', '0'),
('10316', '20', '133', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-12', '1790'),
('10317', '22', '57', '10', '2018-10-08 06:56:02', NULL, '5', '2018-10-08', NULL),
('10318', '22', '57', '10', '2018-10-08 06:56:02', 'Voided.\n', '5', '2018-10-08', '0'),
('10319', '22', '58', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-08', '2127'),
('10320', '1', '3085', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-08', '2128'),
('10321', '1', '3086', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-08', '2129'),
('10322', '30', '1357', '10', '2018-10-09 00:43:37', NULL, '5', '2018-10-09', '0'),
('10323', '13', '1357', '10', '2018-10-09 00:43:37', NULL, '5', '2018-10-09', '0'),
('10324', '10', '1341', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-09', '2140'),
('10325', '30', '1358', '10', '2018-10-09 00:45:05', NULL, '5', '2018-10-09', '0'),
('10326', '13', '1358', '10', '2018-10-09 00:45:05', NULL, '5', '2018-10-09', '0'),
('10327', '10', '1342', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-09', '2141'),
('10328', '1', '3087', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-09', '2142'),
('10329', '1', '3088', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-04', '2090'),
('10330', '1', '3089', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-04', '2091'),
('10331', '1', '3090', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-09', '2143'),
('10332', '30', '1359', '10', '2018-10-09 03:48:19', NULL, '5', '2018-10-02', '0'),
('10333', '13', '1359', '10', '2018-10-09 03:48:19', NULL, '5', '2018-10-02', '0'),
('10334', '10', '1343', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2078'),
('10335', '12', '1671', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-09', '2144'),
('10336', '1', '3091', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-03', '1312'),
('10337', '1', '3092', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1353'),
('10338', '1', '3093', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-09', '1354'),
('10339', '1', '3094', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-10', '1366'),
('10340', '1', '3095', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-15', '1421'),
('10341', '1', '3096', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-16', '1429'),
('10342', '1', '3097', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-21', '1469'),
('10343', '1', '3098', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-25', '1503'),
('10344', '1', '3099', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-26', '1505'),
('10345', '1', '3100', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-26', '1506'),
('10346', '1', '3101', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1533'),
('10347', '1', '3102', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1534'),
('10348', '1', '3103', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1535'),
('10349', '1', '3104', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1536'),
('10350', '1', '3105', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1537'),
('10351', '1', '3106', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1538'),
('10352', '1', '3107', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-27', '1539'),
('10353', '1', '3108', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1630'),
('10354', '1', '3109', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1631'),
('10355', '2', '170', '10', '2018-10-20 06:58:56', NULL, '5', '2018-08-31', NULL),
('10356', '1', '3110', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-09', '2145'),
('10357', '30', '1360', '10', '2018-10-10 01:44:26', NULL, '5', '2018-09-28', '0'),
('10358', '13', '1360', '10', '2018-10-10 01:44:26', NULL, '5', '2018-09-28', '0'),
('10359', '10', '1344', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2001'),
('10360', '30', '1361', '10', '2018-10-10 01:47:17', NULL, '5', '2018-09-28', '0'),
('10361', '13', '1361', '10', '2018-10-10 01:47:17', NULL, '5', '2018-09-28', '0'),
('10362', '10', '1345', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2002'),
('10363', '1', '3111', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-10', '2152'),
('10364', '1', '3112', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-11', '2157'),
('10365', '1', '3113', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-11', '2158'),
('10366', '30', '1362', '10', '2018-10-11 04:12:05', NULL, '5', '2018-09-04', '0'),
('10367', '13', '1362', '10', '2018-10-11 04:17:37', NULL, '5', '2018-09-04', NULL),
('10368', '10', '1346', '10', '2018-10-11 04:14:49', NULL, '5', '2018-09-04', NULL),
('10369', '10', '1346', '10', '2018-10-11 04:17:37', 'Updated.', '5', '2018-09-04', NULL),
('10370', '30', '1363', '10', '2018-10-11 04:16:55', NULL, '5', '2018-09-04', '0'),
('10371', '13', '1363', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-04', '1659'),
('10372', '10', '1347', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-04', '1660'),
('10373', '13', '1362', '10', '2018-10-11 04:17:37', 'Voided.', '5', '2018-10-11', '0'),
('10374', '10', '1346', '10', '2018-10-11 04:17:37', 'Voided.\n', '5', '2018-10-11', '0'),
('10375', '30', '1364', '10', '2018-10-11 04:18:35', NULL, '5', '2018-09-04', '0'),
('10376', '13', '1364', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-04', '1661'),
('10377', '10', '1348', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-04', '1662'),
('10378', '30', '1365', '10', '2018-10-11 04:55:42', NULL, '5', '2018-09-06', '0'),
('10379', '13', '1365', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-06', '1688'),
('10380', '10', '1349', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-06', '1689'),
('10381', '30', '1366', '10', '2018-10-11 04:58:05', NULL, '5', '2018-09-07', '0'),
('10382', '13', '1366', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1709'),
('10383', '10', '1350', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1710'),
('10384', '30', '1367', '10', '2018-10-11 04:59:12', NULL, '5', '2018-09-07', '0'),
('10385', '13', '1367', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1711'),
('10386', '10', '1351', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1712'),
('10387', '30', '1368', '10', '2018-10-11 05:01:07', NULL, '5', '2018-09-14', '0'),
('10388', '13', '1368', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-14', '1809'),
('10389', '10', '1352', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-14', '1810'),
('10390', '30', '1369', '10', '2018-10-11 05:02:20', NULL, '5', '2018-09-14', '0'),
('10391', '13', '1369', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-14', '1811'),
('10392', '10', '1353', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-14', '1812'),
('10393', '30', '1370', '10', '2018-10-11 05:04:03', NULL, '5', '2018-09-14', '0'),
('10394', '13', '1370', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-14', '1813'),
('10395', '10', '1354', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-14', '1814'),
('10396', '30', '1371', '10', '2018-10-11 05:05:05', NULL, '5', '2018-09-15', '0'),
('10397', '13', '1371', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-15', '1817'),
('10398', '10', '1355', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-15', '1818'),
('10399', '30', '1372', '10', '2018-10-11 05:06:54', NULL, '5', '2018-09-15', '0'),
('10400', '13', '1372', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-15', '1819'),
('10401', '10', '1356', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-15', '1820'),
('10402', '30', '1373', '10', '2018-10-11 05:33:33', NULL, '5', '2018-09-18', '0'),
('10403', '13', '1373', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1851'),
('10404', '10', '1357', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1852'),
('10405', '30', '1374', '10', '2018-10-11 05:34:51', NULL, '5', '2018-09-18', '0'),
('10406', '13', '1374', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1853'),
('10407', '10', '1358', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1854'),
('10408', '30', '1375', '10', '2018-10-11 05:53:48', NULL, '5', '2018-09-18', '0'),
('10409', '13', '1375', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1855'),
('10410', '10', '1359', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1856'),
('10411', '30', '1376', '10', '2018-10-11 05:56:10', NULL, '5', '2018-09-18', '0'),
('10412', '13', '1376', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1857'),
('10413', '10', '1360', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1858'),
('10414', '30', '1377', '10', '2018-10-11 05:58:17', NULL, '5', '2018-09-19', '0'),
('10415', '13', '1377', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-19', '1874'),
('10416', '10', '1361', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-19', '1875'),
('10417', '30', '1378', '10', '2018-10-11 05:59:38', NULL, '5', '2018-09-19', '0'),
('10418', '13', '1378', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-19', '1876'),
('10419', '10', '1362', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-19', '1877'),
('10420', '30', '1379', '10', '2018-10-11 06:01:24', NULL, '5', '2018-09-19', '0'),
('10421', '13', '1379', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-19', '1878'),
('10422', '10', '1363', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-19', '1879'),
('10423', '30', '1380', '10', '2018-10-11 06:12:16', NULL, '5', '2018-09-26', '0'),
('10424', '13', '1380', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-26', '1956'),
('10425', '10', '1364', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-26', '1957'),
('10426', '30', '1381', '10', '2018-10-11 06:13:19', NULL, '5', '2018-09-28', '0'),
('10427', '13', '1381', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2003'),
('10428', '10', '1365', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2004'),
('10429', '30', '1382', '10', '2018-10-11 06:14:32', NULL, '5', '2018-09-28', '0'),
('10430', '13', '1382', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2005'),
('10431', '10', '1366', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2006'),
('10432', '30', '1383', '10', '2018-10-11 06:15:51', NULL, '5', '2018-09-28', '0'),
('10433', '13', '1383', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2007'),
('10434', '10', '1367', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2008'),
('10435', '12', '1672', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2009'),
('10436', '12', '1673', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-19', '2261'),
('10437', '12', '1674', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2010'),
('10438', '12', '1675', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2011'),
('10439', '12', '1676', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2012'),
('10440', '12', '1677', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2013'),
('10441', '12', '1678', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-11', '2159'),
('10442', '1', '3114', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2170'),
('10443', '1', '3036', '10', '2018-10-11 23:54:54', 'Voided.\n', '5', '2018-10-11', '0'),
('10444', '1', '3115', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2171'),
('10445', '1', '3116', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2172'),
('10446', '1', '3117', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2173'),
('10447', '20', '134', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1934'),
('10448', '20', '135', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-10', '1735'),
('10449', '22', '59', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2174'),
('10450', '20', '136', '10', '2018-10-12 02:18:15', NULL, '5', '2018-10-24', NULL),
('10451', '20', '136', '10', '2018-10-12 02:18:15', 'Voided.\nDocument reentered.', '5', '2018-10-12', '0'),
('10452', '20', '137', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-24', '1924'),
('10453', '22', '60', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2175'),
('10454', '1', '3118', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2176'),
('10455', '1', '3119', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2177'),
('10456', '1', '3120', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2178'),
('10457', '1', '3121', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2179'),
('10458', '1', '3122', '10', '2018-10-12 03:19:14', NULL, '5', '2018-10-12', NULL),
('10459', '1', '3123', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2180'),
('10460', '1', '3122', '10', '2018-10-12 03:19:14', 'Voided.\nDocument reentered.', '5', '2018-10-12', '0'),
('10461', '1', '3124', '10', '2018-10-12 04:05:58', NULL, '5', '2018-10-12', NULL),
('10462', '30', '1384', '10', '2018-10-12 03:36:31', NULL, '5', '2018-10-12', '0'),
('10463', '13', '1384', '10', '2018-10-12 03:36:31', NULL, '5', '2018-10-12', '0'),
('10464', '10', '1368', '10', '2018-10-12 04:08:03', NULL, '5', '2018-10-12', NULL),
('10465', '1', '3124', '10', '2018-10-12 04:05:58', 'Voided.\n', '5', '2018-10-12', '0'),
('10466', '10', '1368', '10', '2019-02-05 01:20:37', 'Updated.', '5', '2018-10-12', NULL),
('10467', '12', '1639', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-10-22', '2273'),
('10468', '1', '3125', '10', '2018-10-12 04:25:19', NULL, '5', '2018-10-12', NULL),
('10469', '1', '3126', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2181'),
('10470', '1', '3127', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2182'),
('10471', '1', '3125', '10', '2018-10-12 04:25:19', 'Voided.\nDocument reentered.', '5', '2018-10-12', '0'),
('10472', '1', '3128', '10', '2019-03-12 03:58:00', NULL, '5', '2018-10-12', NULL),
('10473', '1', '3129', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2183'),
('10474', '1', '3130', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2184'),
('10475', '1', '3075', '10', '2018-10-14 23:56:06', 'Voided.\n', '5', '2018-10-14', '0'),
('10476', '1', '3131', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-15', '2190'),
('10477', '1', '3132', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-21', '795'),
('10478', '1', '2504', '10', '2018-10-15 02:11:00', 'Voided.\nDocument reentered.', '5', '2018-10-15', '0'),
('10479', '10', '1231', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-06-13', '706'),
('10480', '12', '1628', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-06-13', '707'),
('10481', '1', '3133', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-15', '2191'),
('10482', '1', '3134', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-15', '2192'),
('10483', '1', '3135', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-15', '2193'),
('10484', '1', '3136', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-15', '2194'),
('10485', '1', '3137', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-15', '2195'),
('10486', '30', '1385', '10', '2018-10-16 22:34:38', NULL, '5', '2018-09-07', '0'),
('10487', '13', '1385', '10', '2018-10-16 22:34:38', NULL, '5', '2018-09-07', '0'),
('10488', '10', '1369', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1713'),
('10489', '30', '1386', '10', '2018-10-16 22:35:47', NULL, '5', '2018-09-07', '0'),
('10490', '13', '1386', '10', '2018-10-16 22:35:47', NULL, '5', '2018-09-07', '0'),
('10491', '10', '1370', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1714'),
('10492', '30', '1387', '10', '2018-10-16 22:37:25', NULL, '5', '2018-09-07', '0'),
('10493', '13', '1387', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1715'),
('10494', '10', '1371', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1716'),
('10495', '30', '1388', '10', '2018-10-16 22:39:24', NULL, '5', '2018-09-10', '0'),
('10496', '13', '1388', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-10', '1736'),
('10497', '10', '1372', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-10', '1737'),
('10498', '30', '1389', '10', '2018-10-16 22:42:29', NULL, '5', '2018-09-11', '0'),
('10499', '13', '1389', '10', '2018-10-16 22:42:29', NULL, '5', '2018-09-11', '0'),
('10500', '10', '1373', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1759'),
('10501', '30', '1390', '10', '2018-10-16 22:43:41', NULL, '5', '2018-09-11', '0'),
('10502', '13', '1390', '10', '2018-10-16 22:43:41', NULL, '5', '2018-09-11', '0'),
('10503', '10', '1374', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1760'),
('10504', '30', '1391', '10', '2018-10-16 22:46:22', NULL, '5', '2018-09-15', '0'),
('10505', '13', '1391', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-15', '1821'),
('10506', '10', '1375', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-15', '1822'),
('10507', '30', '1392', '10', '2018-10-16 22:47:57', NULL, '5', '2018-09-17', '0'),
('10508', '13', '1392', '10', '2018-10-16 22:47:57', NULL, '5', '2018-09-17', '0'),
('10509', '10', '1376', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-17', '1831'),
('10510', '30', '1393', '10', '2018-10-16 22:49:20', NULL, '5', '2018-09-17', '0'),
('10511', '13', '1393', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-17', '1832'),
('10512', '10', '1377', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-17', '1833'),
('10513', '30', '1394', '10', '2018-10-16 22:51:57', NULL, '5', '2018-09-17', '0'),
('10514', '13', '1394', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-17', '1834'),
('10515', '10', '1378', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-17', '1835'),
('10516', '30', '1395', '10', '2018-10-16 22:54:23', NULL, '5', '2018-09-19', '0'),
('10517', '13', '1395', '10', '2018-10-16 22:54:23', NULL, '5', '2018-09-19', '0'),
('10518', '10', '1379', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-19', '1880'),
('10519', '30', '1396', '10', '2018-10-16 23:00:32', NULL, '5', '2018-09-20', '0'),
('10520', '13', '1396', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-20', '1887'),
('10521', '10', '1380', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-20', '1888'),
('10522', '30', '1397', '10', '2018-10-16 23:06:23', NULL, '5', '2018-09-20', '0'),
('10523', '13', '1397', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-20', '1889'),
('10524', '10', '1381', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-20', '1890'),
('10525', '30', '1398', '10', '2018-10-16 23:08:36', NULL, '5', '2018-09-25', '0'),
('10526', '13', '1398', '10', '2018-10-16 23:08:36', NULL, '5', '2018-09-25', '0'),
('10527', '10', '1382', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1935'),
('10528', '30', '1399', '10', '2018-10-16 23:15:46', NULL, '5', '2018-09-25', '0'),
('10529', '13', '1399', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1936'),
('10530', '10', '1383', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1937'),
('10531', '30', '1400', '10', '2018-10-16 23:18:09', NULL, '5', '2018-09-25', '0'),
('10532', '13', '1400', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1938'),
('10533', '10', '1384', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1939'),
('10534', '30', '1401', '10', '2018-10-16 23:20:05', NULL, '5', '2018-09-25', '0'),
('10535', '13', '1401', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1940'),
('10536', '10', '1385', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1941'),
('10537', '30', '1402', '10', '2018-10-16 23:23:35', NULL, '5', '2018-09-27', '0'),
('10538', '13', '1402', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1971'),
('10539', '10', '1386', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1972'),
('10540', '30', '1403', '10', '2018-10-16 23:35:23', NULL, '5', '2018-09-27', '0'),
('10541', '13', '1403', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1973'),
('10542', '10', '1387', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1974'),
('10543', '30', '1404', '10', '2018-10-16 23:36:30', NULL, '5', '2018-09-27', '0'),
('10544', '13', '1404', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1975'),
('10545', '10', '1388', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1976'),
('10546', '30', '1405', '10', '2018-10-16 23:58:02', NULL, '5', '2018-09-27', '0'),
('10547', '13', '1405', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1977'),
('10548', '10', '1389', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1978'),
('10549', '30', '1406', '10', '2018-10-16 23:59:06', NULL, '5', '2018-09-27', '0'),
('10550', '13', '1406', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1979'),
('10551', '10', '1390', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1980'),
('10552', '12', '1679', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1717'),
('10553', '12', '1680', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1718'),
('10554', '12', '1681', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1719'),
('10555', '12', '1682', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1720'),
('10556', '12', '1683', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1721'),
('10557', '12', '1684', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1722'),
('10558', '11', '194', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1723'),
('10559', '11', '195', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1724'),
('10560', '11', '196', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1725'),
('10561', '11', '197', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-07', '1726'),
('10562', '12', '1685', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2014'),
('10563', '12', '1686', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2015'),
('10564', '12', '1687', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2016'),
('10565', '12', '1688', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2017'),
('10566', '12', '1689', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2018'),
('10567', '12', '1690', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2019'),
('10568', '11', '198', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2020'),
('10569', '12', '1691', '10', '2019-07-31 01:53:12', NULL, '5', '2018-09-28', NULL),
('10570', '12', '1692', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-19', '1881'),
('10571', '12', '1662', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-10-29', '2352'),
('10572', '11', '199', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2353'),
('10573', '18', '55', '10', '2018-10-17 02:35:40', NULL, '5', '2018-10-17', '0'),
('10574', '25', '54', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2207'),
('10575', '20', '138', '10', '2018-10-17 02:38:47', NULL, '5', '2018-10-17', NULL),
('10576', '20', '138', '10', '2018-10-17 02:38:47', 'Voided.\n', '5', '2018-10-17', '0'),
('10577', '18', '56', '10', '2018-10-17 02:40:03', NULL, '5', '2018-10-17', '0'),
('10578', '25', '55', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2208'),
('10579', '20', '139', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2209'),
('10580', '22', '61', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2210'),
('10581', '1', '3138', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2211'),
('10582', '1', '3139', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2212'),
('10583', '1', '3140', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2213'),
('10584', '12', '1693', '10', '2018-11-15 00:41:48', NULL, '5', '2018-11-15', NULL),
('10585', '17', '2', '1', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2214'),
('10586', '17', '3', '1', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2215'),
('10587', '30', '1407', '10', '2018-10-17 05:43:14', NULL, '5', '2018-10-17', '0'),
('10588', '13', '1407', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2216'),
('10589', '10', '1391', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2217'),
('10590', '12', '1694', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2218'),
('10591', '1', '3141', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2219'),
('10592', '0', '168', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2220'),
('10593', '17', '4', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2221'),
('10594', '16', '58', '10', '2018-10-17 06:26:11', NULL, '5', '2018-10-03', '0'),
('10595', '35', '3', '1', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2222'),
('10596', '16', '59', '10', '2018-10-17 06:27:06', NULL, '5', '2018-10-03', '0'),
('10597', '30', '1408', '10', '2018-10-18 00:07:39', NULL, '5', '2018-09-17', '0'),
('10598', '13', '1408', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-17', '1836'),
('10599', '10', '1392', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-17', '1837'),
('10600', '30', '1409', '10', '2018-10-18 00:09:11', NULL, '5', '2018-09-18', '0'),
('10601', '13', '1409', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1859'),
('10602', '10', '1393', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1860'),
('10603', '30', '1410', '10', '2018-10-18 00:17:28', NULL, '5', '2018-09-20', '0'),
('10604', '13', '1410', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-20', '1891'),
('10605', '10', '1394', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-20', '1892'),
('10606', '30', '1411', '10', '2018-10-18 00:24:54', NULL, '5', '2018-09-20', '0'),
('10607', '13', '1411', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-20', '1893'),
('10608', '10', '1395', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-20', '1894'),
('10609', '30', '1412', '10', '2018-10-18 00:44:13', NULL, '5', '2018-09-20', '0'),
('10610', '13', '1412', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-20', '1895'),
('10611', '10', '1396', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-20', '1896'),
('10612', '30', '1413', '10', '2018-10-18 00:47:38', NULL, '5', '2018-09-27', '0'),
('10613', '13', '1413', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1981'),
('10614', '10', '1397', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1982'),
('10615', '30', '1414', '10', '2018-10-18 01:22:19', NULL, '5', '2018-10-18', '0'),
('10616', '13', '1414', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-18', '2245'),
('10617', '10', '1398', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-18', '2246'),
('10618', '1', '3142', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-18', '2247'),
('10619', '1', '3143', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-18', '2248'),
('10620', '1', '3144', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-18', '2249'),
('10621', '1', '3145', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-18', '2250'),
('10622', '30', '1415', '10', '2018-10-18 02:59:03', NULL, '5', '2018-10-18', '0'),
('10623', '13', '1415', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-18', '2251'),
('10624', '10', '1399', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-18', '2252'),
('10625', '2', '171', '10', '2019-11-04 06:07:10', NULL, '6', '2018-06-01', NULL),
('10626', '2', '148', '10', '2018-10-18 03:13:16', 'Voided.\nDocument reentered.', '5', '2018-10-18', '0'),
('10627', '2', '172', '10', '2019-11-04 06:07:37', NULL, '6', '2018-06-01', NULL),
('10628', '2', '149', '10', '2018-10-18 03:13:38', 'Voided.\nDocument reentered.', '5', '2018-10-18', '0'),
('10629', '2', '173', '10', '2019-11-04 06:08:54', NULL, '6', '2018-07-26', NULL),
('10630', '2', '167', '10', '2018-10-18 03:14:07', 'Voided.\nDocument reentered.', '5', '2018-10-18', '0'),
('10631', '2', '174', '10', '2019-11-04 06:09:23', NULL, '6', '2018-07-26', NULL),
('10632', '2', '168', '10', '2018-10-18 03:14:25', 'Voided.\nDocument reentered.', '5', '2018-10-18', '0'),
('10633', '12', '1695', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-18', '2253'),
('10634', '1', '3146', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1632'),
('10635', '1', '3147', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1633'),
('10636', '1', '3148', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1615'),
('10637', '1', '2928', '10', '2018-10-18 05:38:32', 'Voided.\nDocument reentered.', '5', '2018-10-18', '0'),
('10638', '4', '109', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1983'),
('10639', '4', '110', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1984'),
('10640', '4', '111', '10', '2018-10-18 06:21:02', NULL, '5', '2018-09-27', '0'),
('10641', '4', '112', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-06', '1690'),
('10642', '2', '175', '10', '2019-11-04 06:10:30', NULL, '6', '2018-09-28', NULL),
('10643', '1', '3149', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1761'),
('10644', '1', '2964', '10', '2018-10-18 06:27:55', 'Voided.\nDocument reentered.', '5', '2018-10-18', '0'),
('10645', '1', '3150', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-18', '2254'),
('10646', '2', '176', '1', '2019-11-18 04:43:44', NULL, '6', '2018-07-31', NULL),
('10647', '2', '166', '1', '2018-10-20 06:56:51', 'Voided.\nDocument reentered.', '5', '2018-10-20', '0'),
('10648', '2', '177', '1', '2019-11-18 04:44:59', NULL, '6', '2018-08-31', NULL),
('10649', '2', '170', '1', '2018-10-20 06:58:56', 'Voided.\nDocument reentered.', '5', '2018-10-20', '0'),
('10650', '30', '1416', '10', '2018-10-21 23:07:31', NULL, '5', '2018-10-22', '0'),
('10651', '13', '1416', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2274'),
('10652', '10', '1400', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2275'),
('10653', '1', '3151', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-16', '2197'),
('10654', '1', '3152', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-04', '2092'),
('10655', '1', '3153', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2223'),
('10656', '1', '3154', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-11', '2160'),
('10657', '1', '3155', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2276'),
('10658', '1', '3156', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2277'),
('10659', '1', '3157', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2278'),
('10660', '16', '60', '10', '2018-10-22 02:30:50', NULL, '5', '2018-10-03', '0'),
('10661', '16', '61', '10', '2018-10-22 02:45:20', NULL, '5', '2018-10-03', '0'),
('10662', '1', '3158', '10', '2018-10-22 02:58:33', NULL, '5', '2018-10-22', NULL),
('10663', '1', '3159', '10', '2018-10-22 03:06:24', NULL, '5', '2018-10-22', NULL),
('10664', '1', '3160', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2279'),
('10665', '1', '3158', '10', '2018-10-22 02:58:33', 'Voided.\nDocument reentered.', '5', '2018-10-22', '0'),
('10666', '1', '3161', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2280'),
('10667', '12', '1696', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2281'),
('10668', '30', '1417', '10', '2018-10-22 03:04:21', NULL, '5', '2018-10-19', '0'),
('10669', '13', '1417', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-19', '2262'),
('10670', '10', '1401', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-19', '2263'),
('10671', '12', '1697', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2282'),
('10672', '1', '3162', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2283'),
('10673', '1', '3159', '10', '2018-10-22 03:06:24', 'Voided.\nDocument reentered.', '5', '2018-10-22', '0'),
('10674', '30', '1418', '10', '2018-10-22 03:13:52', NULL, '5', '2018-10-18', '0'),
('10675', '13', '1418', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-18', '2255'),
('10676', '10', '1402', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-18', '2256'),
('10677', '12', '1698', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2562'),
('10678', '11', '200', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2284'),
('10679', '11', '201', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2285'),
('10680', '1', '3163', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2286'),
('10681', '1', '3164', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2287'),
('10682', '1', '3165', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2288'),
('10683', '1', '3166', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2289'),
('10684', '1', '3167', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2290'),
('10685', '30', '1419', '10', '2018-10-22 06:25:42', NULL, '5', '2018-10-22', '0'),
('10686', '13', '1419', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2291'),
('10687', '10', '1403', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2292'),
('10688', '1', '3168', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-23', '2300'),
('10689', '1', '3169', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-23', '2301'),
('10690', '30', '1420', '10', '2018-10-23 02:02:45', NULL, '5', '2018-08-15', '0'),
('10691', '13', '1420', '10', '2018-10-23 02:02:45', NULL, '5', '2018-08-15', '0'),
('10692', '10', '1404', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-15', '1422'),
('10693', '12', '1699', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-16', '1430'),
('10694', '30', '1421', '10', '2018-10-23 02:10:20', NULL, '5', '2018-10-22', '0'),
('10695', '13', '1421', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2293'),
('10696', '10', '1405', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2294'),
('10697', '12', '1700', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-22', '2295'),
('10698', '12', '1701', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-23', '2302'),
('10699', '12', '1702', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-23', '2303'),
('10700', '12', '1703', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-23', '2304'),
('10701', '1', '3170', '10', '2018-10-23 06:58:23', NULL, '5', '2018-10-23', NULL),
('10702', '1', '3171', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-23', '2305'),
('10703', '1', '3170', '10', '2018-10-23 06:58:23', 'Voided.\n', '5', '2018-10-23', '0'),
('10704', '30', '1422', '10', '2018-10-25 00:22:02', NULL, '5', '2018-10-25', '0'),
('10705', '13', '1422', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-25', '2320'),
('10706', '10', '1406', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-25', '2321'),
('10707', '11', '202', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-25', '2322'),
('10708', '1', '3172', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-25', '2323'),
('10709', '1', '3173', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-25', '2324'),
('10710', '1', '3174', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-25', '2325'),
('10711', '30', '1423', '10', '2018-10-25 03:13:52', NULL, '5', '2018-10-25', '0'),
('10712', '13', '1423', '10', '2018-10-25 03:13:52', NULL, '5', '2018-10-25', '0'),
('10713', '10', '1407', '10', '2019-02-21 01:07:44', NULL, '5', '2018-10-25', NULL),
('10714', '1', '3175', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-25', '2326'),
('10715', '12', '1704', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-26', '2343'),
('10716', '12', '1705', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-26', '2344'),
('10717', '1', '3176', '10', '2018-10-26 01:53:09', NULL, '5', '2018-10-26', NULL),
('10718', '1', '3177', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-26', '2345'),
('10719', '1', '3176', '10', '2018-10-26 01:53:09', 'Voided.\n', '5', '2018-10-26', '0'),
('10720', '1', '3178', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-26', '2346'),
('10721', '1', '3179', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-25', '2327'),
('10722', '1', '3180', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-02', '2079'),
('10723', '1', '3181', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-01', '2046'),
('10724', '30', '1424', '10', '2018-10-26 05:48:40', NULL, '5', '2018-10-12', '0'),
('10725', '13', '1424', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2185'),
('10726', '10', '1408', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2186'),
('10727', '30', '1425', '10', '2018-10-26 05:50:19', NULL, '5', '2018-10-17', '0'),
('10728', '13', '1425', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2224'),
('10729', '10', '1409', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2225'),
('10730', '30', '1426', '10', '2018-10-26 05:52:08', NULL, '5', '2018-10-17', '0'),
('10731', '13', '1426', '10', '2018-10-26 05:52:08', NULL, '5', '2018-10-17', '0'),
('10732', '10', '1410', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2226'),
('10733', '30', '1427', '10', '2018-10-26 05:53:28', NULL, '5', '2018-10-17', '0'),
('10734', '13', '1427', '10', '2018-10-26 05:53:28', NULL, '5', '2018-10-17', '0'),
('10735', '10', '1411', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2227'),
('10736', '30', '1428', '10', '2018-10-26 05:56:08', NULL, '5', '2018-10-17', '0'),
('10737', '13', '1428', '10', '2018-10-26 05:56:09', NULL, '5', '2018-10-17', '0'),
('10738', '10', '1412', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2228'),
('10739', '30', '1429', '10', '2018-10-26 05:59:04', NULL, '5', '2018-10-17', '0'),
('10740', '13', '1429', '10', '2019-01-03 01:25:41', NULL, '5', '2018-10-17', NULL),
('10741', '10', '1413', '10', '2019-01-03 01:25:41', NULL, '5', '2018-10-17', NULL),
('10742', '30', '1430', '10', '2018-10-26 06:03:47', NULL, '5', '2018-10-17', '0'),
('10743', '13', '1430', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2229'),
('10744', '10', '1414', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2230'),
('10745', '1', '3182', '10', '2018-10-29 02:49:45', NULL, '5', '2018-10-29', NULL),
('10746', '1', '3183', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2354'),
('10747', '1', '3184', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2355'),
('10748', '1', '3185', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2356'),
('10749', '1', '3186', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2357'),
('10750', '1', '3187', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2358'),
('10751', '1', '3182', '10', '2018-10-29 02:49:45', 'Voided.\nDocument reentered.', '5', '2018-10-29', '0'),
('10752', '1', '3188', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2359'),
('10753', '1', '3189', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2360'),
('10754', '1', '3190', '10', '2018-10-29 04:20:38', NULL, '5', '2018-10-29', NULL),
('10755', '1', '3191', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2361'),
('10756', '1', '3192', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2362'),
('10757', '1', '3190', '10', '2018-10-29 04:20:38', 'Voided.\nDocument reentered.', '5', '2018-10-29', '0'),
('10758', '30', '1431', '10', '2018-10-29 05:03:44', NULL, '5', '2018-09-11', '0'),
('10759', '13', '1431', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1762'),
('10760', '10', '1415', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1763'),
('10761', '30', '1432', '10', '2018-10-29 05:04:38', NULL, '5', '2018-09-11', '0'),
('10762', '13', '1432', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1764'),
('10763', '10', '1416', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1765'),
('10764', '30', '1433', '10', '2018-10-29 05:05:44', NULL, '5', '2018-09-11', '0'),
('10765', '13', '1433', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1766'),
('10766', '10', '1417', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1767'),
('10767', '30', '1434', '10', '2018-10-29 05:21:18', NULL, '5', '2018-09-11', '0'),
('10768', '13', '1434', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1768'),
('10769', '10', '1418', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-11', '1769'),
('10770', '30', '1435', '10', '2018-10-29 05:22:41', NULL, '5', '2018-09-18', '0'),
('10771', '13', '1435', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1861'),
('10772', '10', '1419', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1862'),
('10773', '30', '1436', '10', '2018-10-29 05:23:51', NULL, '5', '2018-09-18', '0'),
('10774', '13', '1436', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1863'),
('10775', '10', '1420', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1864'),
('10776', '30', '1437', '10', '2018-10-29 05:25:11', NULL, '5', '2018-09-25', '0'),
('10777', '13', '1437', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1942'),
('10778', '10', '1421', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-25', '1943'),
('10779', '1', '3193', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2363'),
('10780', '12', '1706', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2364'),
('10781', '12', '1707', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-30', '2397'),
('10782', '30', '1438', '10', '2018-10-30 01:41:09', NULL, '5', '2018-10-30', '0'),
('10783', '13', '1438', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-30', '2398'),
('10784', '10', '1422', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-30', '2399'),
('10785', '16', '62', '10', '2018-10-30 01:50:56', NULL, '5', '2018-10-22', '0'),
('10786', '16', '63', '10', '2018-10-30 01:54:52', NULL, '5', '2018-10-17', '0'),
('10787', '16', '64', '10', '2018-10-30 01:55:18', NULL, '5', '2018-10-17', '0'),
('10788', '16', '65', '10', '2018-10-30 01:55:53', NULL, '5', '2018-10-17', '0'),
('10789', '16', '66', '10', '2018-10-30 01:56:19', NULL, '5', '2018-10-17', '0'),
('10790', '1', '3194', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-30', '2400'),
('10791', '1', '3195', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2410'),
('10792', '1', '3196', '10', '2018-11-27 01:46:04', NULL, '5', '2018-10-31', NULL),
('10793', '1', '3197', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2411'),
('10794', '1', '3198', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2412'),
('10795', '1', '3199', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2413'),
('10796', '1', '3200', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-25', '2328'),
('10797', '1', '3201', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-25', '2329'),
('10798', '11', '203', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2414'),
('10799', '11', '204', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2415'),
('10800', '30', '1439', '10', '2018-11-01 00:42:38', NULL, '5', '2018-11-01', '0'),
('10801', '13', '1439', '10', '2018-11-12 04:04:24', NULL, '5', '2018-11-01', NULL),
('10802', '10', '1423', '10', '2018-11-12 04:04:24', NULL, '5', '2018-11-01', NULL),
('10803', '30', '1440', '10', '2018-11-01 00:53:26', NULL, '5', '2018-11-01', '0'),
('10804', '13', '1440', '10', '2018-11-05 03:05:49', NULL, '5', '2018-11-01', NULL),
('10805', '10', '1424', '10', '2018-11-05 03:05:49', NULL, '5', '2018-11-01', NULL),
('10806', '30', '1441', '10', '2018-11-01 01:29:06', NULL, '5', '2018-11-01', '0'),
('10807', '13', '1441', '10', '2019-06-22 05:49:49', NULL, '6', '2018-11-01', NULL),
('10808', '10', '1425', '10', '2019-06-22 05:49:49', NULL, '6', '2018-11-01', NULL),
('10809', '10', '1425', '10', '2019-06-22 05:49:49', 'Updated.', '6', '2018-11-01', NULL),
('10810', '10', '1425', '10', '2019-06-22 05:49:49', 'Updated.', '6', '2018-11-01', NULL),
('10811', '30', '1442', '10', '2018-11-01 01:39:18', NULL, '5', '2018-10-30', '0'),
('10812', '13', '1442', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-30', '2401'),
('10813', '10', '1426', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-30', '2402'),
('10814', '12', '1708', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2434'),
('10815', '1', '3202', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2435'),
('10816', '12', '1709', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2436'),
('10817', '1', '3203', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2437'),
('10818', '1', '3204', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2438'),
('10819', '1', '3205', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2416'),
('10820', '1', '3206', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2365'),
('10821', '1', '3207', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2439'),
('10822', '1', '3208', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2440'),
('10823', '12', '1576', '10', '2018-11-14 00:17:56', 'Updated.', '5', '2018-11-14', NULL),
('10824', '12', '1710', '10', '2018-11-27 04:37:19', NULL, '5', '2018-11-23', NULL),
('10825', '12', '1711', '10', '2019-01-02 00:44:39', NULL, '5', '2018-12-20', NULL),
('10826', '1', '3209', '10', '2018-11-02 00:26:01', NULL, '5', '2018-11-02', NULL),
('10827', '1', '3210', '10', '2018-11-02 00:25:50', NULL, '5', '2018-11-02', NULL),
('10828', '1', '3211', '10', '2018-11-02 00:25:39', NULL, '5', '2018-11-02', NULL),
('10829', '1', '3212', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2465'),
('10830', '1', '3211', '10', '2018-11-02 00:25:39', 'Voided.\n', '5', '2018-11-02', '0'),
('10831', '1', '3210', '10', '2018-11-02 00:25:50', 'Voided.\n', '5', '2018-11-02', '0'),
('10832', '1', '3209', '10', '2018-11-02 00:26:01', 'Voided.\n', '5', '2018-11-02', '0'),
('10833', '1', '3213', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2466'),
('10834', '1', '3214', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2467'),
('10835', '12', '1712', '10', '2018-11-02 03:18:15', NULL, '5', '2018-12-28', NULL),
('10836', '12', '1713', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-26', '2707'),
('10837', '12', '1714', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2468'),
('10838', '12', '1715', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2776'),
('10839', '12', '1712', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-11-12', '2563'),
('10840', '12', '1716', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-28', '3175'),
('10841', '12', '1717', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2469'),
('10842', '12', '1718', '10', '2019-11-13 01:58:09', NULL, '6', '2018-11-05', NULL),
('10843', '12', '1719', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2470'),
('10844', '12', '1720', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2777'),
('10845', '12', '1721', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2471'),
('10846', '12', '1722', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2564'),
('10847', '12', '1723', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-08', '2511'),
('10848', '12', '1724', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2472'),
('10849', '12', '1725', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2473'),
('10850', '12', '1726', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2474'),
('10851', '12', '1727', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2475'),
('10852', '12', '1728', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2476'),
('10853', '12', '1729', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2477'),
('10854', '12', '1730', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2478');
INSERT INTO `0_audit_trail` VALUES
('10855', '12', '1731', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2479'),
('10856', '12', '1732', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-02', '2480'),
('10857', '12', '1733', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2565'),
('10858', '11', '205', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2566'),
('10859', '12', '1734', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-05', '2484'),
('10860', '1', '3215', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-25', '2330'),
('10861', '1', '3216', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-25', '2331'),
('10862', '30', '1443', '10', '2018-11-05 01:06:05', NULL, '5', '2018-10-05', '0'),
('10863', '13', '1443', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2103'),
('10864', '10', '1427', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2104'),
('10865', '30', '1444', '10', '2018-11-05 01:07:08', NULL, '5', '2018-10-05', '0'),
('10866', '13', '1444', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2105'),
('10867', '10', '1428', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2106'),
('10868', '30', '1445', '10', '2018-11-05 01:08:35', NULL, '5', '2018-10-05', '0'),
('10869', '13', '1445', '10', '2018-11-05 01:08:35', NULL, '5', '2018-10-05', '0'),
('10870', '10', '1429', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2107'),
('10871', '30', '1446', '10', '2018-11-05 01:10:10', NULL, '5', '2018-10-05', '0'),
('10872', '13', '1446', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2108'),
('10873', '10', '1430', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2109'),
('10874', '30', '1447', '10', '2018-11-05 01:12:28', NULL, '5', '2018-10-05', '0'),
('10875', '13', '1447', '10', '2018-11-05 01:12:28', NULL, '5', '2018-10-05', '0'),
('10876', '10', '1431', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2110'),
('10877', '30', '1448', '10', '2018-11-05 01:15:42', NULL, '5', '2018-10-05', '0'),
('10878', '13', '1448', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2111'),
('10879', '10', '1432', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2112'),
('10880', '30', '1449', '10', '2018-11-05 01:18:23', NULL, '5', '2018-10-11', '0'),
('10881', '13', '1449', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-11', '2161'),
('10882', '10', '1433', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-11', '2162'),
('10883', '30', '1450', '10', '2018-11-05 01:23:55', NULL, '5', '2018-10-11', '0'),
('10884', '13', '1450', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-11', '2163'),
('10885', '10', '1434', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-11', '2164'),
('10886', '30', '1451', '10', '2018-11-05 01:25:21', NULL, '5', '2018-10-11', '0'),
('10887', '13', '1451', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-11', '2165'),
('10888', '10', '1435', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-11', '2166'),
('10889', '30', '1452', '10', '2018-11-05 01:31:14', NULL, '5', '2018-10-17', '0'),
('10890', '13', '1452', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2231'),
('10891', '10', '1436', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2232'),
('10892', '30', '1453', '10', '2018-11-05 01:33:17', NULL, '5', '2018-10-23', '0'),
('10893', '13', '1453', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-23', '2306'),
('10894', '10', '1437', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-23', '2307'),
('10895', '30', '1454', '10', '2018-11-05 01:34:30', NULL, '5', '2018-10-23', '0'),
('10896', '13', '1454', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-23', '2308'),
('10897', '10', '1438', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-23', '2309'),
('10898', '30', '1455', '10', '2018-11-05 01:39:14', NULL, '5', '2018-10-23', '0'),
('10899', '13', '1455', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-23', '2310'),
('10900', '10', '1439', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-23', '2311'),
('10901', '30', '1456', '10', '2018-11-05 01:40:18', NULL, '5', '2018-10-23', '0'),
('10902', '13', '1456', '10', '2018-11-05 01:40:18', NULL, '5', '2018-10-23', '0'),
('10903', '10', '1440', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-23', '2312'),
('10904', '30', '1457', '10', '2018-11-05 01:42:44', NULL, '5', '2018-10-29', '0'),
('10905', '13', '1457', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2366'),
('10906', '10', '1441', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2367'),
('10907', '30', '1458', '10', '2018-11-05 01:44:16', NULL, '5', '2018-10-29', '0'),
('10908', '13', '1458', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2368'),
('10909', '10', '1442', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2369'),
('10910', '30', '1459', '10', '2018-11-05 01:44:57', NULL, '5', '2018-10-29', '0'),
('10911', '13', '1459', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2370'),
('10912', '10', '1443', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2371'),
('10913', '30', '1460', '10', '2018-11-05 01:45:55', NULL, '5', '2018-10-30', '0'),
('10914', '13', '1460', '10', '2018-11-05 01:45:55', NULL, '5', '2018-10-30', '0'),
('10915', '10', '1444', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-30', '2403'),
('10916', '12', '1735', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2441'),
('10917', '12', '1736', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2442'),
('10918', '12', '1737', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2443'),
('10919', '12', '1738', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2444'),
('10920', '12', '1739', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2445'),
('10921', '12', '1740', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2446'),
('10922', '12', '1741', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2447'),
('10923', '12', '1742', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2448'),
('10924', '12', '1743', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2449'),
('10925', '12', '1744', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2450'),
('10926', '12', '1745', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2451'),
('10927', '12', '1746', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2452'),
('10928', '13', '1440', '10', '2018-11-05 03:05:49', 'Voided.', '5', '2018-11-05', '0'),
('10929', '10', '1424', '10', '2018-11-05 03:05:49', 'Voided.\n', '5', '2018-11-05', '0'),
('10930', '12', '1747', '10', '2019-06-22 05:55:54', NULL, '5', '2018-11-05', NULL),
('10931', '1', '3217', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2453'),
('10932', '1', '3218', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-05', '2485'),
('10933', '30', '1461', '10', '2018-11-05 22:37:25', NULL, '5', '2018-11-05', '0'),
('10934', '13', '1461', '10', '2019-06-22 06:00:56', NULL, '6', '2018-11-05', NULL),
('10935', '10', '1445', '10', '2019-06-22 06:00:56', NULL, '6', '2018-11-05', NULL),
('10936', '10', '1445', '10', '2019-06-22 06:00:56', 'Updated.', '6', '2018-11-05', NULL),
('10937', '10', '1445', '10', '2019-06-22 06:00:56', 'Updated.', '6', '2018-11-05', NULL),
('10938', '10', '1445', '10', '2019-06-22 06:00:56', 'Updated.', '6', '2018-11-05', NULL),
('10939', '10', '1445', '10', '2019-06-22 06:00:56', 'Updated.', '6', '2018-11-05', NULL),
('10940', '12', '1748', '10', '2019-06-22 06:00:11', NULL, '5', '2018-11-05', NULL),
('10941', '12', '1749', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-04', '2093'),
('10942', '12', '1750', '10', '2018-11-06 01:14:48', NULL, '5', '2018-09-17', NULL),
('10943', '12', '1751', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1865'),
('10944', '10', '1445', '10', '2019-06-22 06:00:56', 'Updated.', '6', '2018-11-05', NULL),
('10945', '1', '3219', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-06', '2492'),
('10946', '1', '3220', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-06', '2493'),
('10947', '12', '1752', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2417'),
('10948', '12', '1753', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2418'),
('10949', '12', '1750', '10', '2018-11-06 01:14:48', 'Voided.\n', '5', '2018-11-06', '0'),
('10950', '12', '1754', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-17', '1838'),
('10951', '12', '1755', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1589'),
('10952', '12', '1756', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-29', '1590'),
('10953', '30', '1462', '10', '2018-11-06 01:40:13', NULL, '5', '2018-10-10', '0'),
('10954', '13', '1462', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-10', '2153'),
('10955', '10', '1446', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-10', '2154'),
('10956', '30', '1463', '10', '2018-11-06 01:42:02', NULL, '5', '2018-10-01', '0'),
('10957', '13', '1463', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-01', '2047'),
('10958', '10', '1447', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-01', '2048'),
('10959', '30', '1464', '10', '2018-11-06 01:44:15', NULL, '5', '2018-10-04', '0'),
('10960', '13', '1464', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-04', '2094'),
('10961', '10', '1448', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-04', '2095'),
('10962', '1', '3221', '10', '2018-11-06 03:20:03', NULL, '5', '2018-09-01', NULL),
('10963', '1', '3222', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-01', '1641'),
('10964', '1', '3221', '10', '2018-11-06 03:20:03', 'Voided.\nDocument reentered.', '5', '2018-11-06', '0'),
('10965', '1', '3223', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-04', '1663'),
('10966', '1', '3224', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-12', '1791'),
('10967', '1', '3225', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-13', '1803'),
('10968', '1', '3226', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-16', '1823'),
('10969', '1', '3227', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-18', '1866'),
('10970', '1', '3228', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-20', '1897'),
('10971', '1', '3229', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-21', '1913'),
('10972', '1', '3230', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-26', '1958'),
('10973', '1', '3231', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-26', '1959'),
('10974', '1', '3232', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1985'),
('10975', '1', '3233', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1986'),
('10976', '1', '3234', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1987'),
('10977', '1', '3235', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1988'),
('10978', '1', '3236', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1989'),
('10979', '1', '3237', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1990'),
('10980', '1', '3238', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1991'),
('10981', '1', '3239', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-27', '1992'),
('10982', '1', '3240', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2021'),
('10983', '1', '3241', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2022'),
('10984', '1', '3242', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-30', '2033'),
('10985', '1', '3243', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-29', '2030'),
('10986', '30', '1465', '10', '2018-11-06 04:12:45', NULL, '5', '2018-10-21', '0'),
('10987', '13', '1465', '10', '2018-11-15 01:03:11', NULL, '5', '2018-10-21', NULL),
('10988', '10', '1449', '10', '2018-11-15 01:03:11', NULL, '5', '2018-10-21', NULL),
('10989', '1', '3244', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-06', '2494'),
('10990', '1', '3245', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-07', '2499'),
('10991', '1', '3246', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-06', '1691'),
('10992', '1', '3247', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-13', '1804'),
('10993', '1', '3248', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-30', '2034'),
('10994', '1', '3249', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2419'),
('10995', '1', '3250', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-07', '2500'),
('10996', '1', '3251', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-07', '2501'),
('10997', '1', '3252', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-07', '2502'),
('10998', '20', '140', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-18', '2257'),
('10999', '20', '141', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-25', '2332'),
('11000', '20', '142', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-08', '2130'),
('11001', '22', '62', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-07', '2503'),
('11002', '20', '143', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2187'),
('11003', '20', '144', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-30', '2404'),
('11004', '22', '63', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-07', '2504'),
('11005', '1', '3253', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-07', '2505'),
('11006', '12', '1757', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-07', '2506'),
('11007', '1', '3254', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-07', '2507'),
('11008', '1', '3255', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-07', '2508'),
('11009', '1', '3256', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-07', '2509'),
('11010', '30', '1466', '10', '2018-11-07 23:22:53', NULL, '5', '2018-11-08', '0'),
('11011', '13', '1466', '10', '2018-11-07 23:32:56', NULL, '5', '2018-11-08', NULL),
('11012', '10', '1450', '10', '2018-11-07 23:32:56', NULL, '5', '2018-11-08', NULL),
('11013', '13', '1466', '10', '2018-11-07 23:32:56', 'Voided.', '5', '2018-11-07', '0'),
('11014', '10', '1450', '10', '2018-11-07 23:32:56', 'Voided.\n', '5', '2018-11-07', '0'),
('11015', '30', '1467', '10', '2018-11-07 23:34:07', NULL, '5', '2018-11-08', '0'),
('11016', '13', '1467', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-08', '2512'),
('11017', '10', '1451', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-08', '2513'),
('11018', '30', '1468', '10', '2018-11-08 01:06:52', NULL, '5', '2018-11-08', '0'),
('11019', '13', '1468', '10', '2018-11-08 01:10:53', NULL, '5', '2018-11-08', NULL),
('11020', '10', '1452', '10', '2018-11-08 01:08:47', NULL, '5', '2018-11-08', NULL),
('11021', '10', '1452', '10', '2018-11-08 01:10:53', 'Updated.', '5', '2018-11-08', NULL),
('11022', '30', '1469', '10', '2018-11-08 01:09:17', NULL, '5', '2018-11-08', '0'),
('11023', '13', '1469', '10', '2018-11-08 01:09:17', NULL, '5', '2018-11-08', '0'),
('11024', '10', '1453', '10', '2018-11-23 03:55:15', NULL, '5', '2018-11-08', NULL),
('11025', '13', '1468', '10', '2018-11-08 01:10:53', 'Voided.', '5', '2018-11-08', '0'),
('11026', '10', '1452', '10', '2018-11-08 01:10:53', 'Voided.\n', '5', '2018-11-08', '0'),
('11027', '1', '3257', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-08', '2514'),
('11028', '12', '1615', '10', '2018-11-08 04:22:05', 'Updated.', '5', '2018-09-13', NULL),
('11029', '12', '1621', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-13', '1805'),
('11030', '12', '1615', '10', '2018-11-08 04:37:52', 'Updated.', '5', '2018-09-13', NULL),
('11031', '2', '178', '10', '2018-11-08 04:28:18', NULL, '5', '2018-11-08', NULL),
('11032', '2', '178', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-08', '2515'),
('11033', '12', '1615', '10', '2018-11-08 04:37:52', 'Voided.\n', '5', '2018-11-08', '0'),
('11034', '12', '1758', '10', '2018-11-08 04:38:41', NULL, '5', '2018-09-13', NULL),
('11035', '12', '1758', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-09-13', '1806'),
('11036', '1', '3258', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-28', '2023'),
('11037', '2', '179', '10', '2019-11-19 00:07:14', NULL, '6', '2018-09-28', NULL),
('11038', '1', '3259', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-24', '1501'),
('11039', '1', '3260', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-24', '1502'),
('11040', '1', '3261', '10', '2018-12-01 04:29:50', NULL, '5', '2018-08-31', NULL),
('11041', '12', '1759', '10', '2021-02-07 08:09:15', NULL, '5', '2018-06-19', '761'),
('11042', '1', '3262', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2525'),
('11043', '1', '3263', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2526'),
('11044', '1', '3264', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2527'),
('11045', '1', '3265', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2528'),
('11046', '12', '1760', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2529'),
('11047', '1', '3266', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2530'),
('11048', '30', '1470', '10', '2018-11-09 01:54:14', NULL, '5', '2018-10-16', '0'),
('11049', '13', '1470', '10', '2018-11-09 01:54:14', NULL, '5', '2018-10-16', '0'),
('11050', '10', '1454', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-16', '2198'),
('11051', '12', '1761', '10', '2018-11-09 02:00:50', NULL, '5', '2018-11-09', NULL),
('11052', '12', '1761', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-11-09', '2531'),
('11053', '1', '3267', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2532'),
('11054', '1', '3268', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2533'),
('11055', '1', '3269', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2534'),
('11056', '1', '3270', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2535'),
('11057', '1', '3271', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2536'),
('11058', '1', '3272', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2537'),
('11059', '1', '3273', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2538'),
('11060', '30', '1471', '10', '2018-11-12 00:44:27', NULL, '5', '2018-11-12', '0'),
('11061', '13', '1471', '10', '2018-11-12 00:44:28', NULL, '5', '2018-11-12', '0'),
('11062', '10', '1455', '10', '2018-11-12 00:46:47', NULL, '5', '2018-11-12', NULL),
('11063', '10', '1425', '10', '2019-06-22 05:49:49', 'Updated.', '6', '2018-11-01', NULL),
('11064', '10', '1455', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-11-12', '2567'),
('11065', '1', '3274', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2568'),
('11066', '1', '3275', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2569'),
('11067', '1', '3276', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2570'),
('11068', '30', '1472', '10', '2018-11-12 01:46:22', NULL, '5', '2018-08-01', '0'),
('11069', '13', '1472', '10', '2018-11-12 01:46:22', NULL, '5', '2018-08-01', '0'),
('11070', '10', '1456', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-01', '1286'),
('11071', '12', '1762', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2571'),
('11072', '10', '1425', '10', '2019-06-22 05:49:49', 'Updated.', '6', '2018-11-01', NULL),
('11073', '13', '1439', '10', '2018-11-12 04:04:24', 'Voided.', '5', '2018-11-12', '0'),
('11074', '10', '1423', '10', '2018-11-12 04:04:24', 'Voided.\n', '5', '2018-11-12', '0'),
('11075', '11', '206', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2572'),
('11076', '11', '207', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2573'),
('11077', '2', '180', '10', '2021-02-07 08:09:15', NULL, '5', '2018-08-30', '1616'),
('11078', '30', '1473', '10', '2018-11-12 05:06:28', NULL, '5', '2018-09-05', '0'),
('11079', '13', '1473', '10', '2018-11-13 01:34:50', NULL, '5', '2018-09-05', NULL),
('11080', '10', '1457', '10', '2018-11-13 01:34:50', NULL, '5', '2018-09-05', NULL),
('11081', '12', '1763', '10', '2018-11-12 05:16:11', NULL, '5', '2018-09-05', NULL),
('11082', '12', '1763', '10', '2018-11-12 05:18:48', 'Updated.', '5', '2018-09-05', NULL),
('11083', '12', '1619', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-07-04', '972'),
('11084', '12', '1763', '10', '2018-11-13 01:34:31', 'Updated.', '5', '2018-09-05', NULL),
('11085', '1', '3277', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-13', '2582'),
('11086', '1', '3278', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-13', '2583'),
('11087', '1', '3279', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-13', '2584'),
('11088', '30', '1474', '10', '2018-11-13 01:33:20', NULL, '5', '2018-09-04', '0'),
('11089', '13', '1474', '10', '2018-11-13 01:33:20', NULL, '5', '2018-09-04', '0'),
('11090', '10', '1458', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-04', '1664'),
('11091', '12', '1764', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1683'),
('11092', '12', '1763', '10', '2018-11-13 01:34:31', 'Voided.\n', '5', '2018-11-13', '0'),
('11093', '13', '1473', '10', '2018-11-13 01:34:50', 'Voided.', '5', '2018-11-13', '0'),
('11094', '10', '1457', '10', '2018-11-13 01:34:50', 'Voided.\n', '5', '2018-11-13', '0'),
('11095', '11', '208', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-01', '2049'),
('11096', '11', '209', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-01', '2050'),
('11097', '12', '1765', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-14', '2597'),
('11098', '12', '1576', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-11-14', '2598'),
('11099', '30', '1475', '10', '2018-11-14 00:42:14', NULL, '5', '2018-10-08', '0'),
('11100', '13', '1475', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-08', '2131'),
('11101', '10', '1459', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-08', '2132'),
('11102', '12', '1766', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2574'),
('11103', '10', '901', '10', '2019-06-22 03:32:54', 'Updated.', '6', '2018-02-21', NULL),
('11104', '1', '3280', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-14', '2599'),
('11105', '1', '3281', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-14', '2600'),
('11106', '1', '3282', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-14', '2601'),
('11107', '1', '3283', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-14', '2602'),
('11108', '1', '3284', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-14', '2603'),
('11109', '1', '3285', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-14', '2604'),
('11110', '1', '3286', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-14', '2605'),
('11111', '1', '3287', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-15', '2610'),
('11112', '1', '3288', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-13', '2585'),
('11113', '1', '3289', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-13', '2586'),
('11114', '1', '3290', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-15', '2611'),
('11115', '12', '1767', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-15', '2612'),
('11116', '12', '1693', '10', '2018-11-15 00:41:48', 'Voided.\n', '5', '2018-11-15', '0'),
('11117', '13', '1465', '10', '2018-11-15 01:03:11', 'Voided.', '5', '2018-11-15', '0'),
('11118', '10', '1449', '10', '2018-11-15 01:03:11', 'Voided.\n', '5', '2018-11-01', '0'),
('11119', '1', '3291', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-15', '2613'),
('11120', '13', '1060', '10', '2018-11-15 05:06:04', 'Voided.', '5', '2018-11-15', '0'),
('11121', '10', '1046', '10', '2018-11-15 05:06:04', 'Voided.\n', '5', '2018-11-15', '0'),
('11122', '1', '3292', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-05', '2113'),
('11123', '1', '3293', '10', '2019-11-11 05:23:11', NULL, '6', '2018-10-06', NULL),
('11124', '1', '3294', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-12', '2188'),
('11125', '1', '3295', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-18', '2258'),
('11126', '1', '3296', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-26', '2347'),
('11127', '1', '3297', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-26', '2348'),
('11128', '1', '3298', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-26', '2349'),
('11129', '1', '3299', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2372'),
('11130', '1', '3300', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2373'),
('11131', '1', '3301', '10', '2018-11-16 02:02:18', NULL, '5', '2018-11-16', NULL),
('11132', '1', '3302', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-16', '2616'),
('11133', '1', '3301', '10', '2018-11-16 02:02:18', 'Voided.\nDocument reentered.', '5', '2018-11-16', '0'),
('11134', '12', '1768', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-16', '2617'),
('11135', '18', '57', '10', '2018-11-16 03:08:17', NULL, '5', '2018-09-14', '0'),
('11136', '25', '56', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-14', '1815'),
('11137', '20', '145', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-14', '1816'),
('11138', '1', '3303', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-16', '2618'),
('11139', '22', '64', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-16', '2619'),
('11140', '1', '3304', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-16', '2620'),
('11141', '1', '3305', '10', '2018-12-13 01:11:05', NULL, '5', '2018-11-15', NULL),
('11142', '1', '3306', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-16', '2621'),
('11143', '11', '210', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-16', '2622'),
('11144', '1', '3307', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-16', '2623'),
('11145', '1', '3308', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-16', '2624'),
('11146', '1', '3309', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-16', '2625'),
('11147', '30', '1476', '10', '2018-11-18 21:59:42', NULL, '5', '2018-11-19', '0'),
('11148', '13', '1476', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2632'),
('11149', '10', '1460', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2633'),
('11150', '30', '1477', '10', '2018-11-19 00:03:50', NULL, '5', '2018-11-16', '0'),
('11151', '13', '1477', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-16', '2626'),
('11152', '10', '1461', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-16', '2627'),
('11153', '12', '1769', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-16', '3424'),
('11154', '12', '1770', '10', '2021-02-07 08:09:15', NULL, '5', '2019-02-14', '3882'),
('11155', '11', '211', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-08', '2516'),
('11156', '30', '1478', '10', '2018-11-19 00:50:08', NULL, '5', '2018-11-19', '0'),
('11157', '13', '1478', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2634'),
('11158', '10', '1462', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2635'),
('11159', '1', '3310', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-16', '2628'),
('11160', '1', '3311', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2420'),
('11161', '1', '3312', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-15', '2614'),
('11162', '1', '3313', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2374'),
('11163', '1', '3314', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2375'),
('11164', '1', '3315', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2376'),
('11165', '1', '3316', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-30', '2405'),
('11166', '1', '3317', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2421'),
('11167', '1', '3318', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2422'),
('11168', '1', '3319', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2423'),
('11169', '1', '3320', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2636'),
('11170', '1', '3321', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2637'),
('11171', '1', '3322', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-23', '2685'),
('11172', '1', '3323', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-23', '2686'),
('11173', '1', '3324', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-23', '2687'),
('11174', '1', '3325', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-23', '2688'),
('11175', '1', '3326', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-23', '2689'),
('11176', '1', '3327', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-23', '2690'),
('11177', '1', '3328', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-23', '2691'),
('11178', '1', '3329', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-23', '2692'),
('11179', '1', '3330', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-23', '2693'),
('11180', '1', '3331', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-20', '2656'),
('11181', '1', '3332', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-20', '2657'),
('11182', '1', '3333', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-20', '2658'),
('11183', '1', '3334', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-23', '2694'),
('11184', '10', '1453', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-10-08', '2133'),
('11185', '30', '1479', '10', '2018-11-23 04:00:48', NULL, '5', '2018-11-23', '0'),
('11186', '13', '1479', '10', '2019-01-18 04:34:21', NULL, '5', '2018-11-23', NULL),
('11187', '10', '1463', '10', '2018-11-23 04:02:41', NULL, '5', '2018-11-23', NULL),
('11188', '10', '1463', '10', '2018-11-23 04:04:57', 'Updated.', '5', '2018-11-23', NULL),
('11189', '30', '1480', '10', '2018-11-23 04:04:37', NULL, '5', '2018-10-31', '0'),
('11190', '13', '1480', '10', '2018-11-23 04:04:37', NULL, '5', '2018-10-31', '0'),
('11191', '10', '1464', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2424'),
('11192', '10', '1463', '10', '2019-01-18 04:34:21', 'Updated.', '5', '2018-10-31', NULL),
('11193', '16', '67', '10', '2018-11-23 04:13:38', NULL, '5', '2018-11-16', '0'),
('11194', '16', '68', '10', '2018-11-23 04:14:54', NULL, '5', '2018-11-23', '0'),
('11195', '16', '69', '10', '2018-11-23 04:15:38', NULL, '5', '2018-11-23', '0'),
('11196', '16', '70', '10', '2018-11-23 04:16:37', NULL, '5', '2018-11-23', '0'),
('11197', '1', '3335', '10', '2018-12-27 01:39:17', NULL, '5', '2018-05-04', NULL),
('11198', '1', '2325', '10', '2018-11-23 04:42:02', 'Voided.\nDocument reentered.', '5', '2018-11-23', '0'),
('11199', '20', '146', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-08', '1728'),
('11200', '18', '58', '10', '2018-11-23 04:49:00', NULL, '5', '2018-11-08', '0'),
('11201', '25', '57', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-08', '2517'),
('11202', '20', '147', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-08', '2518'),
('11203', '22', '65', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-23', '2695'),
('11204', '1', '3336', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-23', '2696'),
('11205', '18', '59', '10', '2018-11-23 04:58:08', NULL, '5', '2018-11-19', '0'),
('11206', '25', '58', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2638'),
('11207', '20', '148', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2639'),
('11208', '1', '3337', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-21', '2667'),
('11209', '30', '1481', '10', '2018-11-25 22:13:23', NULL, '5', '2018-10-31', '0'),
('11210', '13', '1481', '10', '2018-11-25 22:13:23', NULL, '5', '2018-10-31', '0'),
('11211', '10', '1465', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2425'),
('11212', '30', '1482', '10', '2018-11-26 00:26:35', NULL, '5', '2018-11-26', '0'),
('11213', '13', '1482', '10', '2018-11-26 00:26:35', NULL, '5', '2018-11-26', '0'),
('11214', '10', '1466', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-26', '2708'),
('11215', '30', '1483', '10', '2018-11-26 00:28:25', NULL, '5', '2018-11-26', '0'),
('11216', '13', '1483', '10', '2019-11-04 00:32:59', NULL, '6', '2018-11-26', NULL),
('11217', '10', '1467', '10', '2019-11-04 00:32:59', NULL, '6', '2018-11-26', NULL),
('11218', '1', '3338', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-26', '2709'),
('11219', '1', '3339', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-26', '2710'),
('11220', '1', '3340', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-26', '2711'),
('11221', '1', '3341', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-26', '2712'),
('11222', '1', '3342', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-26', '2713'),
('11223', '11', '212', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2575'),
('11224', '11', '213', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2576'),
('11225', '11', '214', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2577'),
('11226', '1', '3343', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-26', '2714'),
('11227', '1', '3344', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-26', '2715'),
('11228', '1', '3345', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-26', '2716'),
('11229', '1', '3346', '10', '2019-03-08 04:06:05', NULL, '5', '2018-11-26', NULL),
('11230', '1', '3347', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-20', '2659'),
('11231', '1', '3348', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-20', '2660'),
('11232', '20', '149', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-13', '2587'),
('11233', '22', '66', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-27', '2727'),
('11234', '1', '3349', '10', '2018-11-27 00:34:40', NULL, '5', '2018-11-27', NULL),
('11235', '1', '3350', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-27', '2728'),
('11236', '1', '3349', '10', '2018-11-27 00:34:40', 'Voided.\nDocument reentered.', '5', '2018-11-27', '0'),
('11237', '20', '150', '10', '2018-11-27 00:38:14', NULL, '5', '2018-11-13', NULL),
('11238', '20', '151', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-06', '2495'),
('11239', '20', '150', '10', '2018-11-27 00:38:14', 'Voided.\nDocument reentered.', '5', '2018-11-27', '0'),
('11240', '20', '152', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-13', '2588'),
('11241', '22', '67', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-27', '2729'),
('11242', '1', '3351', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-27', '2730'),
('11243', '1', '3352', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-27', '2731'),
('11244', '1', '3353', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-27', '2732'),
('11245', '1', '3354', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-27', '2733'),
('11246', '1', '3355', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-27', '2734'),
('11247', '1', '3356', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-27', '2735'),
('11248', '1', '3357', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-27', '2736'),
('11249', '1', '3358', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-27', '2737'),
('11250', '1', '3359', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-27', '2738'),
('11251', '1', '3360', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2426'),
('11252', '1', '3196', '10', '2018-11-27 01:46:04', 'Voided.\nDocument reentered.', '5', '2018-11-27', '0'),
('11253', '1', '3361', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-27', '2739'),
('11254', '1', '3362', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-27', '2740'),
('11255', '10', '1467', '10', '2019-11-04 00:32:59', 'Updated.', '6', '2018-11-26', NULL),
('11256', '10', '1467', '10', '2019-11-04 00:32:59', 'Updated.', '6', '2018-11-26', NULL),
('11257', '12', '1710', '10', '2018-11-27 04:37:19', 'Voided.\nReturned CHQ', '5', '2018-11-27', '0'),
('11258', '1', '3363', '10', '2018-11-27 05:41:12', NULL, '5', '2018-11-27', NULL),
('11259', '1', '3364', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-27', '2741'),
('11260', '1', '3363', '10', '2018-11-27 05:41:12', 'Voided.\nDocument reentered.', '5', '2018-11-27', '0'),
('11261', '30', '1484', '10', '2018-11-28 01:22:39', NULL, '5', '2018-10-25', '0'),
('11262', '13', '1484', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-25', '2333'),
('11263', '10', '1468', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-25', '2334'),
('11264', '30', '1485', '10', '2018-11-28 01:30:49', NULL, '5', '2018-10-16', '0'),
('11265', '13', '1485', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-16', '2199'),
('11266', '10', '1469', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-16', '2200'),
('11267', '30', '1486', '10', '2018-11-28 01:34:02', NULL, '5', '2018-10-16', '0'),
('11268', '13', '1486', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-16', '2201'),
('11269', '10', '1470', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-16', '2202'),
('11270', '30', '1487', '10', '2018-11-28 01:35:19', NULL, '5', '2018-10-16', '0'),
('11271', '13', '1487', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-16', '2203'),
('11272', '10', '1471', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-16', '2204'),
('11273', '30', '1488', '10', '2018-11-28 01:36:25', NULL, '5', '2018-10-29', '0'),
('11274', '13', '1488', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2377'),
('11275', '10', '1472', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2378'),
('11276', '30', '1489', '10', '2018-11-28 01:37:40', NULL, '5', '2018-10-29', '0'),
('11277', '13', '1489', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2379'),
('11278', '10', '1473', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2380'),
('11279', '30', '1490', '10', '2018-11-28 01:38:27', NULL, '5', '2018-10-29', '0'),
('11280', '13', '1490', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2381'),
('11281', '10', '1474', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2382'),
('11282', '30', '1491', '10', '2018-11-28 01:42:08', NULL, '5', '2018-10-29', '0'),
('11283', '13', '1491', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2383'),
('11284', '10', '1475', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2384'),
('11285', '30', '1492', '10', '2018-11-28 01:42:59', NULL, '5', '2018-10-29', '0'),
('11286', '13', '1492', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2385'),
('11287', '10', '1476', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2386'),
('11288', '30', '1493', '10', '2018-11-28 01:53:21', NULL, '5', '2018-10-29', '0'),
('11289', '13', '1493', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2387'),
('11290', '10', '1477', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2388'),
('11291', '30', '1494', '10', '2018-11-28 01:55:01', NULL, '5', '2018-10-29', '0'),
('11292', '13', '1494', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2389'),
('11293', '10', '1478', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2390'),
('11294', '12', '1771', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2454'),
('11295', '12', '1772', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2455'),
('11296', '12', '1773', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2456'),
('11297', '12', '1774', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2457'),
('11298', '11', '215', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2458'),
('11299', '12', '1775', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2459'),
('11300', '11', '216', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2460'),
('11301', '12', '1776', '10', '2019-01-29 03:45:30', NULL, '5', '2018-12-24', NULL),
('11302', '11', '217', '10', '2018-11-28 04:45:34', NULL, '5', '2018-11-28', NULL),
('11303', '11', '217', '10', '2018-11-28 04:45:34', 'Voided.\n', '5', '2018-11-28', '0'),
('11304', '11', '218', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-28', '2750'),
('11305', '16', '71', '10', '2018-11-28 05:01:48', NULL, '5', '2018-11-26', '0'),
('11306', '30', '1495', '10', '2018-11-28 05:08:23', NULL, '5', '2018-11-26', '0'),
('11307', '13', '1495', '10', '2018-11-28 05:08:51', NULL, '5', '2018-11-26', NULL),
('11308', '13', '1495', '10', '2018-11-28 05:08:51', 'Updated.', '5', '2018-11-28', '0'),
('11309', '11', '219', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-23', '2995'),
('11310', '11', '220', '10', '2020-01-22 05:35:45', NULL, '3', '2018-02-23', '2996'),
('11311', '1', '3365', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-23', '2697'),
('11312', '1', '3366', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-29', '2758'),
('11313', '1', '3367', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-29', '2759'),
('11314', '1', '3368', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-29', '2760'),
('11315', '1', '3369', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-29', '2761'),
('11316', '1', '3370', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-29', '2762'),
('11317', '1', '3371', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-29', '2763'),
('11318', '11', '221', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-29', '2764'),
('11319', '11', '222', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-29', '2765'),
('11320', '12', '1777', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-29', '2766'),
('11321', '30', '1496', '10', '2018-11-29 04:35:31', NULL, '5', '2018-11-12', '0'),
('11322', '13', '1496', '10', '2018-11-29 04:35:31', NULL, '5', '2018-11-12', '0'),
('11323', '10', '1479', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2578'),
('11324', '12', '1778', '10', '2019-01-13 23:22:44', NULL, '5', '2018-11-30', NULL),
('11325', '12', '1779', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2778'),
('11326', '1', '3372', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-29', '2767'),
('11327', '1', '3373', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-29', '2768'),
('11328', '1', '3374', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-29', '2769'),
('11329', '1', '3375', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-29', '2770'),
('11330', '30', '1497', '10', '2018-11-29 22:36:51', NULL, '5', '2018-11-29', '0'),
('11331', '13', '1497', '10', '2018-11-29 22:36:51', NULL, '5', '2018-11-29', '0'),
('11332', '10', '1480', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-29', '2771'),
('11333', '30', '1498', '10', '2018-11-29 23:54:23', NULL, '5', '2018-10-29', '0'),
('11334', '13', '1498', '10', '2018-11-29 23:54:24', NULL, '5', '2018-10-29', '0'),
('11335', '10', '1481', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2391'),
('11336', '1', '3376', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2779'),
('11337', '1', '3377', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2780'),
('11338', '11', '223', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2781'),
('11339', '11', '224', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2782'),
('11340', '11', '225', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-05', '1684'),
('11341', '11', '226', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2783'),
('11342', '1', '3378', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2784'),
('11343', '1', '3379', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2785'),
('11344', '1', '3380', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2786'),
('11345', '1', '3381', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2787'),
('11346', '1', '3382', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2788'),
('11347', '1', '3383', '1', '2021-02-07 08:09:15', NULL, '5', '2018-08-31', '1634'),
('11348', '1', '3261', '1', '2018-12-01 04:29:50', 'Voided.\nDocument reentered.', '5', '2018-12-01', '0'),
('11349', '1', '3384', '1', '2021-02-07 08:09:15', NULL, '5', '2018-04-05', '57'),
('11350', '1', '2168', '1', '2018-12-01 04:32:10', 'Voided.\nDocument reentered.', '5', '2018-12-01', '0'),
('11351', '1', '3385', '1', '2021-02-07 08:09:15', NULL, '5', '2018-05-23', '502'),
('11352', '1', '2765', '1', '2018-12-01 04:33:51', 'Voided.\nDocument reentered.', '5', '2018-12-01', '0'),
('11353', '0', '169', '1', '2021-02-07 08:09:15', NULL, '5', '2018-09-30', '2035'),
('11354', '0', '170', '1', '2021-02-07 08:09:15', NULL, '5', '2018-06-15', '725'),
('11355', '30', '1499', '10', '2018-12-02 23:58:57', NULL, '5', '2018-07-31', '0'),
('11356', '13', '1499', '10', '2018-12-02 23:58:57', NULL, '5', '2018-07-31', '0'),
('11357', '10', '1482', '10', '2021-02-07 08:09:15', NULL, '5', '2018-07-31', '1257'),
('11358', '13', '1249', '10', '2018-12-02 23:59:36', 'Voided.', '5', '2018-12-02', '0'),
('11359', '10', '1233', '10', '2018-12-02 23:59:36', 'Voided.\n', '5', '2018-12-02', '0'),
('11360', '1', '3386', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2813'),
('11361', '1', '3387', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2814'),
('11362', '1', '3388', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2815'),
('11363', '1', '3389', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2816'),
('11364', '1', '3390', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2817'),
('11365', '1', '3391', '10', '2018-12-03 03:15:39', NULL, '5', '2018-12-03', NULL),
('11366', '1', '3392', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2818'),
('11367', '1', '3391', '10', '2018-12-03 03:15:39', 'Voided.\nDocument reentered.', '5', '2018-12-03', '0'),
('11368', '1', '3393', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2819'),
('11369', '30', '1500', '10', '2018-12-03 03:37:24', NULL, '5', '2018-11-12', '0'),
('11370', '13', '1500', '10', '2018-12-03 03:37:24', NULL, '5', '2018-11-12', '0'),
('11371', '10', '1483', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2579'),
('11372', '12', '1780', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2820'),
('11373', '1', '3394', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2821'),
('11374', '1', '3395', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2822'),
('11375', '1', '3396', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2823'),
('11376', '1', '3397', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2824'),
('11377', '1', '3398', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2825'),
('11378', '12', '1781', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2233'),
('11379', '12', '1782', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2234'),
('11380', '1', '3399', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2826'),
('11381', '1', '3400', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2827'),
('11382', '1', '3401', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2828'),
('11383', '12', '1783', '10', '2019-01-29 00:44:23', NULL, '5', '2018-12-10', NULL),
('11384', '11', '227', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2829'),
('11385', '1', '3402', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-05', '2865'),
('11386', '1', '3403', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-05', '2866'),
('11387', '1', '3404', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-06', '2883'),
('11388', '1', '3405', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-10', '2914'),
('11389', '1', '3406', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-10', '2915'),
('11390', '1', '3407', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-10', '2916'),
('11391', '1', '3408', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-11', '2932'),
('11392', '1', '3409', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-11', '2933'),
('11393', '1', '3410', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-12', '2945'),
('11394', '1', '3411', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-13', '2955'),
('11395', '1', '3412', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-13', '2956'),
('11396', '1', '3413', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-13', '2957'),
('11397', '1', '3414', '1', '2021-02-07 08:09:15', NULL, '5', '2018-11-15', '2615'),
('11398', '1', '3305', '1', '2018-12-13 01:11:05', 'Voided.\nDocument reentered.', '5', '2018-12-13', '0'),
('11399', '1', '3415', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-13', '2958'),
('11400', '1', '3416', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-13', '2959'),
('11401', '1', '3417', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-13', '2960'),
('11402', '1', '3418', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-14', '2983'),
('11403', '11', '228', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2830'),
('11404', '11', '229', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2831'),
('11405', '11', '230', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2832'),
('11406', '11', '231', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2833'),
('11407', '11', '232', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2846'),
('11408', '11', '233', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2847'),
('11409', '11', '234', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2848'),
('11410', '11', '235', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2849'),
('11411', '11', '236', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2850'),
('11412', '11', '237', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2851'),
('11413', '11', '238', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2852'),
('11414', '11', '239', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2853'),
('11415', '11', '240', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2854'),
('11416', '11', '241', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-07', '2896'),
('11417', '11', '242', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-07', '2897'),
('11418', '11', '243', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-12', '2946'),
('11419', '11', '244', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-05', '2867'),
('11420', '11', '245', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-05', '2868'),
('11421', '11', '246', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-05', '2869'),
('11422', '30', '1501', '10', '2018-12-17 00:16:37', NULL, '5', '2018-12-17', '0'),
('11423', '13', '1501', '10', '2018-12-17 00:16:37', NULL, '5', '2018-12-17', '0'),
('11424', '10', '1484', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-17', '3008'),
('11425', '1', '3419', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-17', '3009'),
('11426', '12', '1784', '10', '2019-02-14 00:57:37', NULL, '5', '2019-02-11', NULL),
('11427', '12', '1785', '10', '2019-03-11 03:31:23', NULL, '5', '2019-03-11', NULL),
('11428', '1', '3420', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-17', '3010'),
('11429', '1', '3421', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-17', '3011'),
('11430', '1', '3422', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-17', '3012'),
('11431', '1', '3423', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-17', '3013'),
('11432', '1', '3424', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-17', '3014'),
('11433', '12', '1786', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-29', '3618'),
('11434', '12', '1787', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-30', '3640'),
('11435', '12', '1788', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-17', '3015'),
('11436', '12', '1789', '10', '2018-12-17 03:59:14', NULL, '5', '2019-02-25', NULL),
('11437', '12', '1789', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2019-02-25', '4017'),
('11438', '12', '1790', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-30', '3641'),
('11439', '12', '1791', '10', '2019-01-28 02:14:12', NULL, '5', '2019-01-28', NULL),
('11440', '12', '1792', '10', '2019-02-27 23:25:14', NULL, '5', '2019-02-26', NULL),
('11441', '12', '1793', '10', '2019-03-28 02:00:23', NULL, '5', '2019-03-26', NULL),
('11442', '12', '1794', '10', '2021-02-07 08:09:15', NULL, '5', '2019-02-18', '3930'),
('11443', '12', '1795', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-18', '3464'),
('11444', '12', '1796', '10', '2021-02-07 08:09:15', NULL, '5', '2019-03-18', '4353');
INSERT INTO `0_audit_trail` VALUES
('11445', '12', '1797', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-14', '2984'),
('11446', '12', '1798', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-14', '2985'),
('11447', '12', '1799', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-14', '2986'),
('11448', '1', '3425', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-17', '3016'),
('11449', '1', '3426', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-17', '3017'),
('11450', '1', '3427', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-18', '3042'),
('11451', '1', '3428', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-18', '3043'),
('11452', '12', '1800', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-14', '2987'),
('11453', '1', '3429', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-18', '3044'),
('11454', '1', '3430', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-18', '3045'),
('11455', '30', '1502', '10', '2018-12-18 04:48:24', NULL, '5', '2018-10-31', '0'),
('11456', '13', '1502', '10', '2018-12-18 04:48:24', NULL, '5', '2018-10-31', '0'),
('11457', '10', '1485', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-31', '2427'),
('11458', '30', '1503', '10', '2018-12-18 04:49:37', NULL, '5', '2018-09-30', '0'),
('11459', '13', '1503', '10', '2018-12-18 04:49:37', NULL, '5', '2018-09-30', '0'),
('11460', '10', '1486', '10', '2021-02-07 08:09:15', NULL, '5', '2018-09-30', '2036'),
('11461', '16', '72', '10', '2018-12-18 04:57:34', NULL, '5', '2018-12-06', '0'),
('11462', '16', '73', '10', '2018-12-18 04:58:06', NULL, '5', '2018-12-06', '0'),
('11463', '16', '74', '10', '2018-12-18 05:00:27', NULL, '5', '2018-12-06', '0'),
('11464', '16', '75', '10', '2018-12-18 05:01:32', NULL, '5', '2018-12-06', '0'),
('11465', '16', '76', '10', '2018-12-18 05:02:10', NULL, '5', '2018-12-06', '0'),
('11466', '16', '77', '10', '2018-12-18 05:03:44', NULL, '5', '2018-12-06', '0'),
('11467', '16', '78', '10', '2018-12-18 05:04:13', NULL, '5', '2018-12-06', '0'),
('11468', '32', '6', '10', '2018-12-18 21:55:35', NULL, '5', '2018-12-18', '0'),
('11469', '1', '3431', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-19', '3060'),
('11470', '12', '1801', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-20', '3069'),
('11471', '1', '3432', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-13', '2961'),
('11472', '1', '3433', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-13', '2962'),
('11473', '1', '3434', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-13', '2963'),
('11474', '1', '3435', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-13', '2964'),
('11475', '1', '3436', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-12', '2947'),
('11476', '1', '3437', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-12', '2948'),
('11477', '1', '3438', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-08', '2913'),
('11478', '1', '3439', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-06', '2884'),
('11479', '1', '3440', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2855'),
('11480', '1', '3441', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-05', '2870'),
('11481', '1', '3442', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-05', '2871'),
('11482', '1', '3443', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3090'),
('11483', '30', '1504', '10', '2018-12-21 00:50:46', NULL, '5', '2018-12-21', '0'),
('11484', '13', '1504', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3091'),
('11485', '10', '1487', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3092'),
('11486', '1', '3444', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3093'),
('11487', '1', '3445', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3094'),
('11488', '1', '3446', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3095'),
('11489', '1', '3447', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3096'),
('11490', '1', '3448', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3097'),
('11491', '1', '3449', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3098'),
('11492', '1', '3450', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3099'),
('11493', '1', '3451', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3100'),
('11494', '1', '3452', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3101'),
('11495', '1', '3453', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3102'),
('11496', '1', '3454', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3103'),
('11497', '1', '3455', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3104'),
('11498', '1', '3456', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3105'),
('11499', '1', '3457', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3106'),
('11500', '1', '3458', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3107'),
('11501', '1', '3459', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3108'),
('11502', '1', '3460', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3109'),
('11503', '1', '3461', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3110'),
('11504', '1', '3462', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3111'),
('11505', '1', '3463', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3112'),
('11506', '1', '3464', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3113'),
('11507', '1', '3465', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3114'),
('11508', '1', '3466', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3115'),
('11509', '1', '3467', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3116'),
('11510', '1', '3468', '10', '2018-12-27 00:44:03', NULL, '5', '2018-12-27', NULL),
('11511', '1', '3468', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-27', '3149'),
('11512', '2', '181', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-27', '3150'),
('11513', '1', '3469', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2856'),
('11514', '1', '3470', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-21', '3117'),
('11515', '1', '3471', '10', '2021-02-07 08:09:15', NULL, '5', '2018-05-04', '315'),
('11516', '1', '3335', '10', '2018-12-27 01:39:17', 'Voided.\nDocument reentered.', '5', '2018-12-27', '0'),
('11517', '4', '113', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-29', '2392'),
('11518', '4', '114', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-30', '2406'),
('11519', '1', '3472', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-27', '3151'),
('11520', '1', '3473', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-27', '3152'),
('11521', '1', '3474', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-27', '3153'),
('11522', '1', '3475', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-27', '3154'),
('11523', '1', '3476', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-27', '3155'),
('11524', '30', '1505', '10', '2018-12-27 23:02:01', NULL, '5', '2018-11-09', '0'),
('11525', '13', '1505', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2539'),
('11526', '10', '1488', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2540'),
('11527', '30', '1506', '10', '2018-12-27 23:03:35', NULL, '5', '2018-11-01', '0'),
('11528', '13', '1506', '10', '2018-12-27 23:03:35', NULL, '5', '2018-11-01', '0'),
('11529', '10', '1489', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-01', '2461'),
('11530', '30', '1507', '10', '2018-12-27 23:04:55', NULL, '5', '2018-11-05', '0'),
('11531', '13', '1507', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-05', '2486'),
('11532', '10', '1490', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-05', '2487'),
('11533', '30', '1508', '10', '2018-12-27 23:06:48', NULL, '5', '2018-11-09', '0'),
('11534', '13', '1508', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2541'),
('11535', '10', '1491', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-09', '2542'),
('11536', '30', '1509', '10', '2018-12-27 23:09:27', NULL, '5', '2018-11-14', '0'),
('11537', '13', '1509', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-14', '2606'),
('11538', '10', '1492', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-14', '2607'),
('11539', '30', '1510', '10', '2018-12-27 23:14:35', NULL, '5', '2018-11-14', '0'),
('11540', '13', '1510', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-14', '2608'),
('11541', '10', '1493', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-14', '2609'),
('11542', '30', '1511', '10', '2018-12-27 23:17:25', NULL, '5', '2018-11-16', '0'),
('11543', '13', '1511', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-16', '2629'),
('11544', '10', '1494', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-16', '2630'),
('11545', '30', '1512', '10', '2018-12-27 23:21:24', NULL, '5', '2018-11-19', '0'),
('11546', '13', '1512', '10', '2018-12-27 23:21:25', NULL, '5', '2018-11-19', '0'),
('11547', '10', '1495', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2640'),
('11548', '30', '1513', '10', '2018-12-27 23:27:59', NULL, '5', '2018-11-19', '0'),
('11549', '13', '1513', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2641'),
('11550', '10', '1496', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2642'),
('11551', '30', '1514', '10', '2018-12-27 23:33:49', NULL, '5', '2018-11-19', '0'),
('11552', '13', '1514', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2643'),
('11553', '10', '1497', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2644'),
('11554', '30', '1515', '10', '2018-12-27 23:55:46', NULL, '5', '2018-11-19', '0'),
('11555', '13', '1515', '10', '2018-12-27 23:55:46', NULL, '5', '2018-11-19', '0'),
('11556', '10', '1498', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2645'),
('11557', '30', '1516', '10', '2018-12-27 23:58:24', NULL, '5', '2018-11-21', '0'),
('11558', '13', '1516', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-21', '2668'),
('11559', '10', '1499', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-21', '2669'),
('11560', '30', '1517', '10', '2018-12-27 23:59:25', NULL, '5', '2018-11-21', '0'),
('11561', '13', '1517', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-21', '2670'),
('11562', '10', '1500', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-21', '2671'),
('11563', '30', '1518', '10', '2018-12-28 00:04:36', NULL, '5', '2018-11-26', '0'),
('11564', '13', '1518', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-26', '2717'),
('11565', '10', '1501', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-26', '2718'),
('11566', '30', '1519', '10', '2018-12-28 00:08:08', NULL, '5', '2018-11-30', '0'),
('11567', '13', '1519', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2789'),
('11568', '10', '1502', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2790'),
('11569', '30', '1520', '10', '2018-12-28 00:11:06', NULL, '5', '2018-12-01', '0'),
('11570', '13', '1520', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-01', '2810'),
('11571', '10', '1503', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-01', '2811'),
('11572', '30', '1521', '10', '2018-12-28 00:12:26', NULL, '5', '2018-12-01', '0'),
('11573', '13', '1521', '10', '2018-12-28 00:13:10', NULL, '5', '2018-12-01', NULL),
('11574', '10', '1504', '10', '2018-12-28 00:13:10', NULL, '5', '2018-12-01', NULL),
('11575', '13', '1521', '10', '2018-12-28 00:13:10', 'Voided.', '5', '2018-12-28', '0'),
('11576', '10', '1504', '10', '2018-12-28 00:13:10', 'Voided.\n', '5', '2018-12-28', '0'),
('11577', '30', '1522', '10', '2018-12-28 00:14:29', NULL, '5', '2018-12-01', '0'),
('11578', '13', '1522', '10', '2018-12-28 00:14:30', NULL, '5', '2018-12-01', '0'),
('11579', '10', '1505', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-01', '2812'),
('11580', '30', '1523', '10', '2018-12-28 00:17:04', NULL, '5', '2018-12-03', '0'),
('11581', '13', '1523', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2834'),
('11582', '10', '1506', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2835'),
('11583', '30', '1524', '10', '2018-12-28 00:19:22', NULL, '5', '2018-12-03', '0'),
('11584', '13', '1524', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2836'),
('11585', '10', '1507', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2837'),
('11586', '30', '1525', '10', '2018-12-28 00:37:53', NULL, '5', '2018-11-12', '0'),
('11587', '13', '1525', '10', '2018-12-28 00:37:53', NULL, '5', '2018-11-12', '0'),
('11588', '10', '1508', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-12', '2580'),
('11589', '12', '1802', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-28', '3176'),
('11590', '1', '3477', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-28', '3177'),
('11591', '1', '3478', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-28', '3178'),
('11592', '30', '1526', '10', '2018-12-28 03:03:52', NULL, '5', '2018-12-28', '0'),
('11593', '13', '1526', '10', '2018-12-28 03:03:52', NULL, '5', '2018-12-28', '0'),
('11594', '10', '1509', '10', '2018-12-28 04:57:34', NULL, '5', '2018-12-28', NULL),
('11595', '1', '3479', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-28', '3179'),
('11596', '1', '3480', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-28', '3180'),
('11597', '1', '3481', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-28', '3181'),
('11598', '10', '1509', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-12-28', '3182'),
('11599', '1', '3482', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-28', '3183'),
('11600', '30', '1527', '10', '2018-12-28 05:27:04', NULL, '5', '2018-12-28', '0'),
('11601', '13', '1527', '10', '2018-12-28 05:27:05', NULL, '5', '2018-12-28', '0'),
('11602', '10', '1510', '10', '2018-12-28 05:27:51', NULL, '5', '2018-12-28', NULL),
('11603', '10', '1510', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-12-28', '3184'),
('11604', '12', '1803', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-02', '3240'),
('11605', '12', '1711', '10', '2019-01-02 00:44:39', 'Voided.\nCHQ Returned', '5', '2019-01-02', '0'),
('11606', '12', '1804', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-02', '3241'),
('11607', '1', '3483', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-02', '3242'),
('11608', '30', '1528', '10', '2019-01-02 01:27:40', NULL, '5', '2018-11-19', '0'),
('11609', '13', '1528', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2646'),
('11610', '10', '1511', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2647'),
('11611', '30', '1529', '10', '2019-01-02 01:32:09', NULL, '5', '2018-11-19', '0'),
('11612', '13', '1529', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2648'),
('11613', '10', '1512', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-19', '2649'),
('11614', '30', '1530', '10', '2019-01-02 01:39:51', NULL, '5', '2018-11-20', '0'),
('11615', '13', '1530', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-20', '2661'),
('11616', '10', '1513', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-20', '2662'),
('11617', '30', '1531', '10', '2019-01-02 01:43:24', NULL, '5', '2018-11-30', '0'),
('11618', '13', '1531', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2791'),
('11619', '10', '1514', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2792'),
('11620', '30', '1532', '10', '2019-01-02 01:45:10', NULL, '5', '2018-11-30', '0'),
('11621', '13', '1532', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2793'),
('11622', '10', '1515', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2794'),
('11623', '30', '1533', '10', '2019-01-02 01:46:42', NULL, '5', '2018-11-30', '0'),
('11624', '13', '1533', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2795'),
('11625', '10', '1516', '10', '2021-02-07 08:09:15', NULL, '5', '2018-11-30', '2796'),
('11626', '1', '3484', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-02', '3243'),
('11627', '12', '1805', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-05', '2872'),
('11628', '12', '1806', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-05', '2873'),
('11629', '12', '1807', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-05', '2874'),
('11630', '12', '1808', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-02', '3244'),
('11631', '12', '1809', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-02', '3245'),
('11632', '11', '247', '10', '2019-01-02 02:47:46', NULL, '5', '2018-12-05', '0'),
('11633', '11', '248', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-05', '2875'),
('11634', '1', '3485', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-27', '3156'),
('11635', '1', '3486', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-27', '3157'),
('11636', '1', '3487', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-27', '3158'),
('11637', '1', '3488', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-27', '3159'),
('11638', '1', '3489', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-27', '3160'),
('11639', '1', '3490', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-02', '3246'),
('11640', '1', '3491', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-12', '2949'),
('11641', '30', '1534', '10', '2019-01-02 23:06:53', NULL, '5', '2019-01-03', '0'),
('11642', '13', '1534', '10', '2019-01-02 23:06:53', NULL, '5', '2019-01-03', '0'),
('11643', '10', '1517', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-03', '3262'),
('11644', '30', '1535', '10', '2019-01-02 23:08:01', NULL, '5', '2019-01-03', '0'),
('11645', '13', '1535', '10', '2019-01-22 01:11:39', NULL, '5', '2019-01-03', NULL),
('11646', '10', '1518', '10', '2019-01-22 01:11:39', NULL, '5', '2019-01-03', NULL),
('11647', '1', '3492', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-12', '2950'),
('11648', '1', '3493', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-05', '2876'),
('11649', '12', '1810', '10', '2019-02-25 04:29:05', NULL, '5', '2019-01-21', NULL),
('11650', '12', '1811', '10', '2020-03-03 00:23:22', NULL, '6', '2019-01-01', NULL),
('11651', '12', '1812', '10', '2020-03-03 00:24:15', NULL, '6', '2019-01-01', NULL),
('11652', '12', '1813', '10', '2020-03-03 00:24:55', NULL, '6', '2019-01-01', NULL),
('11653', '12', '1814', '10', '2020-03-03 00:25:41', NULL, '6', '2019-01-01', NULL),
('11654', '12', '1815', '10', '2020-03-03 00:26:23', NULL, '6', '2019-01-01', NULL),
('11655', '12', '1816', '10', '2020-03-03 00:27:14', NULL, '6', '2019-01-01', NULL),
('11656', '11', '249', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-01', '3232'),
('11657', '11', '250', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-01', '3233'),
('11658', '11', '251', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-01', '3234'),
('11659', '11', '252', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-01', '3235'),
('11660', '12', '1817', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2857'),
('11661', '12', '1818', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2858'),
('11662', '12', '1819', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2859'),
('11663', '12', '1820', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2860'),
('11664', '12', '1821', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2861'),
('11665', '11', '253', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-04', '2862'),
('11666', '12', '1822', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-02', '3247'),
('11667', '12', '1823', '10', '2019-01-03 01:14:59', NULL, '5', '2019-01-18', NULL),
('11668', '12', '1823', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2019-01-18', '3465'),
('11669', '12', '1824', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-02', '3248'),
('11670', '30', '1536', '10', '2019-01-03 01:25:05', NULL, '5', '2018-10-17', '0'),
('11671', '13', '1536', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2235'),
('11672', '10', '1519', '10', '2021-02-07 08:09:15', NULL, '5', '2018-10-17', '2236'),
('11673', '13', '1429', '10', '2019-01-03 01:25:41', 'Voided.', '5', '2019-01-03', '0'),
('11674', '10', '1413', '10', '2019-01-03 01:25:41', 'Voided.\n', '5', '2019-01-03', '0'),
('11675', '12', '1825', '10', '2019-01-03 01:44:08', NULL, '5', '2019-01-02', NULL),
('11676', '12', '1826', '10', '2019-01-03 01:43:40', NULL, '5', '2019-01-02', NULL),
('11677', '12', '1827', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-05', '2877'),
('11678', '12', '1826', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-12-05', '2878'),
('11679', '12', '1825', '10', '2021-02-07 08:09:15', 'Updated.', '5', '2018-12-05', '2879'),
('11680', '12', '1828', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-02', '3249'),
('11681', '12', '1829', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-02', '3250'),
('11682', '12', '1830', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-05', '2880'),
('11683', '12', '1831', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-02', '3251'),
('11684', '12', '1832', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-10', '3367'),
('11685', '1', '3494', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-03', '3263'),
('11686', '1', '3495', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-03', '3264'),
('11687', '1', '3496', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-03', '3265'),
('11688', '1', '3497', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-03', '3266'),
('11689', '1', '3498', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-03', '3267'),
('11690', '1', '3499', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-03', '3268'),
('11691', '18', '60', '10', '2019-01-03 02:49:37', NULL, '5', '2019-01-01', '0'),
('11692', '35', '4', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-01', '3236'),
('11693', '35', '5', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-01', '3237'),
('11694', '25', '59', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-01', '3238'),
('11695', '20', '153', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-01', '3239'),
('11696', '1', '3500', '10', '2021-02-07 08:09:15', NULL, '5', '2019-01-03', '3269'),
('11697', '12', '1833', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-31', '3191'),
('11698', '30', '1537', '10', '2019-01-03 03:32:03', NULL, '5', '2018-12-03', '0'),
('11699', '13', '1537', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2838'),
('11700', '10', '1520', '10', '2021-02-07 08:09:15', NULL, '5', '2018-12-03', '2839'),
('11701', '30', '1538', '1